//-----------------------------------------------------------------------------
// FadeOutActorSprite.js
//-----------------------------------------------------------------------------
/*:
 * @target MZ
 * @plugindesc 戦闘不能時にアクタースプライトをフェードアウトさせます。
 * @version 1.1.0
 * @author OpenAI
 * @url https://github.com/openai-melody/RPGMaker-MZ-Scripts
 *
 * @help FadeOutActorSprite.js
 *
 * This plugin fades out actor sprites upon collapsing in battle.
 *
 * Plugin Commands:
 *
 * None
 *
 * @param ---
 * @text Compatibility
 * @default
 *
 * @param UseBlendModes
 * @text Use Blend Modes
 * @type boolean
 * @default true
 * @desc If set to true, blend modes will be used for the collapsing effect.
 *
 * @param ---
 * @text Debugging
 * @default
 *
 * @param DebugMode
 * @text Debug Mode
 * @type boolean
 * @default false
 * @desc If set to true, debugging information will be outputted to the console.
 *
 * @license
 * MIT License
 */
(() => {
    const pluginName = "FadeOutActorSprite";
    const parameters = PluginManager.parameters(pluginName);
    const useBlendModes = parameters.UseBlendModes === "true";
    const debugMode = parameters.DebugMode === "true";

    // アクターの戦闘キャラクター画像の不透明度を徐々に0にして、消えていく演出を実装する
    Sprite_Actor.prototype.startCollapse = function() {
        this._stateIconSprite.visible = false;
        this._hpGaugeSprite.visible = false;
        this._mpGaugeSprite.visible = false;
        this._tpGaugeSprite.visible = false;
        this._lifeGaugeSprite.visible = false;
        this._collapseDuration = 48;
        this._collapseCount = 0;
        if (useBlendModes) {
            this._mainSprite.blendMode = PIXI.BLEND_MODES.ADD;
        }
        this._effectTarget = this._mainSprite;

        // 徐々に不透明度を下げていく演出
        const duration = 48;
        const targetOpacity = 0;
        const originalOpacity = this._mainSprite.alpha;
        const opacityStep = (originalOpacity - targetOpacity) / duration;
        this._collapseEffect = function() {
            this._mainSprite.alpha -= opacityStep;
        };
    };

    Sprite_Actor.prototype.updateCollapse = function() {
        this._collapseCount++;
        this._collapseEffect.call(this);

        if (this._collapseCount === this._collapseDuration) {
            this._mainSprite.opacity = 0;
            this._effectTarget = null;
            this.visible = false;
        }
    };

    if (debugMode) {
        console.log(`[${pluginName}] Debug mode is on.`);
        console.log(`[${pluginName}] UseBlendModes: ${useBlendModes}`);
    }
})();
