/*:
 * @target MZ
 * @plugindesc バトル画面に指定された画像を表示し、クリック時にコモンイベントを実行します
 * @author YourName
 *
 * @param imageName
 * @text 画像ファイル名
 * @desc 表示する画像ファイル名を指定してください（拡張子不要）
 * @type file
 * @dir img/pictures/
 * @default
 *
 * @param x
 * @text X座標
 * @desc 画像のX座標を指定してください
 * @type number
 * @default 0
 *
 * @param y
 * @text Y座標
 * @desc 画像のY座標を指定してください
 * @type number
 * @default 0
 *
 * @param commonEventId
 * @text コモンイベントID
 * @desc クリック時に実行するコモンイベントのIDを指定してください
 * @type common_event
 * @default 1
 *
 */

(() => {
    const pluginName = "ShowBattleImage";
    const parameters = PluginManager.parameters(pluginName);
    const imageName = String(parameters["imageName"]);
    const x = Number(parameters["x"]);
    const y = Number(parameters["y"]);
    const commonEventId = Number(parameters["commonEventId"]);
  
    class ShowBattleImageSprite extends Sprite {
      constructor() {
        super();
        this.bitmap = ImageManager.loadPicture(imageName);
        this.x = x;
        this.y = y;
        this.anchor.x = 0;
        this.anchor.y = 0;
        this.interactive = true;
        this.buttonMode = true;
        this.on("pointertap", this.onClick, this);
      }
  
      onClick() {
        $gameTemp.reserveCommonEvent(commonEventId);
      }
    }
  
    const _Scene_Battle_createSpriteset = Scene_Battle.prototype.createSpriteset;
    Scene_Battle.prototype.createSpriteset = function () {
      _Scene_Battle_createSpriteset.call(this);
      this._battleImageSprite = new ShowBattleImageSprite();
      this.addChild(this._battleImageSprite);
    };
  
    const _Scene_Battle_terminate = Scene_Battle.prototype.terminate;
    Scene_Battle.prototype.terminate = function () {
      _Scene_Battle_terminate.call(this);
      this.removeChild(this._battleImageSprite);
    };
  })();
  