//=============================================================================
// SoR_BuffFunctionExtension_MZ.js
// SoR License (C) 2020 蒼竜, REQUIRED User Registration on Dragon Cave
// http://dragonflare.blue/dcave/license.php
// ----------------------------------------------------------------------------
// Latest version v1.10 (2022/06/21)
//=============================================================================
/*:ja
@plugindesc ＜バフシステム拡張＞ v1.10
@author 蒼竜
@target MZ
@url https://dragonflare.blue/dcave/
@base SoR_BattleActionParameterRefactor_MZ
@base SoR_TagDataProcessor_MZ
@orderAfter SoR_TagDataProcessor_MZ
@orderAfter SoR_BattleActionParameterRefactor_MZ
@help ※要 88.「SoRタグデータ解析」(SoR_TagDataProcessor_MZ)
94.「戦闘行動パラメータ参照細分化」(SoR_BattleActionParameterRefactor_MZ.js)

RPGツクール標準環境では、仕様が決め打ちにされていて
プラグインによる機能拡張およびゲーム内のバトラー状態の参照が
融通の利かない状態にあるバフ・デバフ機能の根幹部を修正します。

プラグイン管理画面における適当な配置に関しては、
具体的な新しいゲームシステムを導入するプラグインよりは上部、
「SoRタグデータ解析」のようなシステム全体の根幹に関わるプラグイン
よりは下部という立ち位置をとります。

@param --基本--
@param BuffRate
@desc バフ(1段階あたり)の強化倍率の定義式。バフ段階を表す変数lvが使用可能。
@type string
@default 0.25
@param BuffMaxLevel
@desc バフ強化段階の最大値
@type number
@default 2
@min 1
@param DebuffMaxLevel
@desc デバフ弱体化段階の最大値
@type number
@default 2
@min 1

@param --拡張機能--
@param ExtraBuffIcons
@desc 3段階以上のバフ有効時の対応するアイコンの先頭(mhp)ID (1:3段階目, 2:4段階目, ...)
@default []
@type number[]
@param ExtraDebuffIcons
@desc 3段階以上のデバフ有効時の対応するデバフアイコンの先頭(mhp)ID (1:3段階目, 2:4段階目, ...)
@type number[]
@default []
*/
/*
@plugindesc <Buff Function Extension> v1.10
@author Soryu
@base SoR_BattleActionParameterRefactor_MZ
@base SoR_TagDataProcessor_MZ
@orderAfter SoR_TagDataProcessor_MZ
@orderAfter SoR_BattleActionParameterRefactor_MZ
@target MZ
@url https://dragonflare.blue/dcave/index_e.php
@help [Prerequisite] 88. SoR_TagDataProcessor_MZ
94. SoR_BattleActionParameterRefactor_MZ

This plugin modifies the fundamental mechanism of buff and debuff 
system whose behavior on games are strictly fixed by the default 
RPGMaker. It helps other related plugins to extend the buff system
and access the battler data for their new systems.

Concerning the position of this plugin on the plugin manager,
it must be placed upper than any other plugins which present
new game systems and game-play designs and lower than 
fundamental plugins to modify the entire system such as 
88. "SoR_TagDataProcessor_MZ".

@param --Basic--
@param BuffRate
@desc Formula of buff rate. A variable lv is available to represent the current buff level.
@type string
@default 0.25
@param BuffMaxLevel
@desc Maximum level of buff
@type number
@default 2
@min 1
@param DebuffMaxLevel
@desc Maximum level of debuff
@type number
@default 2
@min 1

@param --Extension--
@param ExtraBuffIcons
@desc Icon ID for the top stat (mhp) when more than 3 levels of buff are used (1: Lv.3, 2: Lv.4, ...)
@default []
@type number[]
@param ExtraDebuffIcons
@desc Icon ID for the top stat (mhp) when more than 3 levels of debuff are used (1: Lv.3, 2: Lv.4, ...)
@type number[]
@default []
*/
(function() {
if(!PluginManager._scripts.includes("SoR_BattleActionParameterRefactor_MZ")) throw new Error("[SoR_BuffFunctionExtension_MZ] This plugin REQUIRES SoR_BattleActionParameterRefactor_MZ.");
if(!PluginManager._scripts.includes("SoR_TagDataProcessor_MZ")) throw new Error("[SoR_BuffFunctionExtension_MZ] This plugin REQUIRES SoR_TagDataProcessor_MZ.");

const pluginName = "SoR_BuffFunctionExtension_MZ";
const Param = PluginManager.parameters(pluginName);

const BuffRate = String(Param['BuffRate']).trim();
const BuffMaxLevel = Number(Param['BuffMaxLevel']) || 0;
const DebuffMaxLevel = Number(Param['DebuffMaxLevel']) || 0;

const ExtraBuffIcons = convertJsonParam(Param['ExtraBuffIcons']);
const ExtraDebuffIcons = convertJsonParam(Param['ExtraDebuffIcons']);

function convertJsonParam(param) {
    if (param == undefined) return [];
    let arr = [];
        JSON.parse(param).map(function(param) {
            arr.push(Number(param));
        });
    return arr;
}

/////////////////////////////////////////////////////////////////////
const SoR_BFE_DM_initializeSoRTagProcessor = DataManager.initializeSoRTagProcessor;
DataManager.initializeSoRTagProcessor = function() {
    SoR_BFE_DM_initializeSoRTagProcessor.call(this);
    const q = {name: "SoRTagBFE", target: ["skill"]};
    this._SoRTagProcessFuncs.push(q);
}

DataManager.SoRTagBFE_init = function(obj) {
    obj.buffControl = [];
}

//param, turn, rank, prob, cond
const tag = /<(?:BuffControl):[ ]*(.*),[ ]*(\d+),[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;
const tag2 = /<(?:DebuffControl):[ ]*(.*),[ ]*(\d+),[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;

const tag3 = /<(?:BuffControlSelf):[ ]*(.*),[ ]*(\d+),[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;
const tag4 = /<(?:DebuffControlSelf):[ ]*(.*),[ ]*(\d+),[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;

DataManager.SoRTagBFE = function(obj, line) {
    let MatchFlag = false;

    const reg1 = line.match(tag);
    const reg2 = line.match(tag2);
    const reg3 = line.match(tag3);
    const reg4 = line.match(tag4);
    if(reg1){
        const param = convS2ID(reg1[1]);
        if(param==null) return MatchFlag;

        const turn = Number(reg1[2]);
        const rank = Number(reg1[3]);
        if(rank==0) return MatchFlag;

        const prob = Number(reg1[4]);
        const cond = reg1[5];
        obj.buffControl.push({
            param, turn, rank, prob, cond, iself : false 
        });
        MatchFlag = true;
    }
    else if(reg2){
        const param = convS2ID(reg2[1]);
        if(param==null) return MatchFlag;

        const turn = Number(reg2[2]);
        const rank = -Number(reg2[3]);
        if(rank==0) return MatchFlag;

        const prob = Number(reg2[4]);
        const cond = reg2[5];
        obj.buffControl.push({
            param, turn, rank, prob, cond, iself : false 
        });
        MatchFlag = true;
    }
    else if(reg3){
        const param = convS2ID(reg3[1]);
        if(param==null) return MatchFlag;

        const turn = Number(reg3[2]);
        const rank = Number(reg3[3]);
        if(rank==0) return MatchFlag;

        const prob = Number(reg3[4]);
        const cond = reg3[5];
        obj.buffControl.push({
            param, turn, rank, prob, cond, iself : true 
        });
        MatchFlag = true;
		
//		console.log(obj.buffControl);
    }
    else if(reg4){
        const param = convS2ID(reg4[1]);
        if(param==null) return MatchFlag;

        const turn = Number(reg4[2]);
        const rank = -Number(reg4[3]);
        if(rank==0) return MatchFlag;

        const prob = Number(reg4[4]);
        const cond = reg4[5];
        obj.buffControl.push({
            param, turn, rank, prob, cond, iself : true 
        });
        MatchFlag = true;
    }
	
    return MatchFlag;
}

function convS2ID(x){
    if(!Number.isNaN(Number(x))){
        if(x<0) return null;
        return x;
    }

    const test = x.trim();
    const strs = ["mhp","mmp","atk","def","mat","mdf","agi","luk"];
    const idx = strs.findIndex(x=>x==test);

    if(idx>=0) return idx;
    return null;
}
/////////////////////////////////////////////////////////////////////

/*
Processed by BAPRefactor
Game_BattlerBase.prototype.paramBuffRate = function(paramId) {  return 1.0+ this.paramBuffCorrection(paramId); }
Game_BattlerBase.prototype.paramBuffCorrection = function(paramId) { return this._buffs[paramId] * this.BuffRateConstant(paramId); }
*/

Game_BattlerBase.prototype.BuffRateConstant = function(paramId) {
    return SoR_EvalBSL(BuffRate, this._buffs[paramId]);
}

Game_BattlerBase.prototype.isMaxBuffAffected = function(paramId) {
    return this._buffs[paramId] === BuffMaxLevel;
}

Game_BattlerBase.prototype.isMaxDebuffAffected = function(paramId) {
    return this._buffs[paramId] === -DebuffMaxLevel;
}

///////////////////////////////////////////////////////////////////////////////////////
//refactor
const SoR_BFE_GA_applyAdditionalItemEffects = Game_Action.prototype.applyAdditionalItemEffects;
Game_Action.prototype.applyAdditionalItemEffects = function(target) {
    SoR_BFE_GA_applyAdditionalItemEffects.call(this,target);
	
	const bfc = this.item().buffControl;
    if(bfc && bfc.length>0) this.applybuffsBFE(target, bfc);
}

Game_Action.prototype.applybuffsBFE = function(target, bfc) {
    for(const x of bfc){
        if(!SoR_Eval(x.cond)) continue;
        if(x.prob!=0 && x.prob!=1){
            if(Math.random()>x.prob) continue;
        }

		const obj = x.iself == false ? target : this.subject();
//		console.log(obj);
		
        if(x.rank>0){
            const n = x.rank;
            for(let i=0; i<n; i++) obj.addBuff(x.param, x.turn);
        }
        else{
            const n = -x.rank;
            for(let i=0; i<n; i++) obj.addDebuff(x.param, x.turn);
        }
    }
}

//overwritten
Game_BattlerBase.prototype.buffIconIndex = function(buffLevel, paramId) {
    if (buffLevel > 0) {
        if(buffLevel>=3) return ExtraBuffIcons[buffLevel-3] + (buffLevel - 3) * 8 + paramId;
        else return Game_BattlerBase.ICON_BUFF_START + (buffLevel - 1) * 8 + paramId;
    } 
    else if (buffLevel < 0) {
        if(buffLevel<=-3) return ExtraDebuffIcons[-buffLevel-3] + (-buffLevel - 3) * 8 + paramId;
        else return Game_BattlerBase.ICON_DEBUFF_START + (-buffLevel - 1) * 8 + paramId;
    }
    else return 0;
}

///////////////////////////////////////////////////////////////////////////////////////
function SoR_Eval(ev) {
    const sentence = "return (" + ev + ");";
    if(typeof $gameTemp.SoRTmp_script === "undefined") $gameTemp.SoRTmp_script = new Map();
    if(!$gameTemp.SoRTmp_script.has(sentence)){
        $gameTemp.SoRTmp_script.set(sentence, new Function(sentence));
    }     
    const res = $gameTemp.SoRTmp_script.get(sentence)();
    return res;
}

function SoR_EvalBSL(ev, lv) {
    ev = ev.replace(/lv/g, "lv");
    const sentence = "return (" + ev + ");";

    if(typeof $gameTemp.SoRTmp_script === "undefined") $gameTemp.SoRTmp_script = new Map();
    if(!$gameTemp.SoRTmp_script.has(sentence)){
        $gameTemp.SoRTmp_script.set(sentence, new Function("lv",sentence));
    }
    const res = $gameTemp.SoRTmp_script.get(sentence)(lv);
    return res;
}
})();