//=============================================================================
// SoR_DataNoteExtension_MZ.js
// SoR License (C) 2020 蒼竜, REQUIRED User Registration on Dragon Cave
// http://dragonflare.blue/dcave/license.php
// ----------------------------------------------------------------------------
// Latest version v1.21 (2022/08/12)
//=============================================================================
/*:ja
@plugindesc ＜外部メモ欄拡張＞ v1.21
@author 蒼竜
@target MZ
@url https://dragonflare.blue/dcave/
@help RPGツクールのエディタ内にある"メモ欄"内に相当するテキストを
外部テキストファイルに記述したファイルを、エディタ上での設定したものと
同じようにタグ情報等をゲーム内へ取り込んで使用できるようにします。

(※ゲーム公開時はゲーム改ざん防止のため、公開用データからは".txtファイル"を
全て削除しておくことを強く推奨します)
@param ---基本設定---
@param ExNotePath
@desc 拡張メモファイル配置ディレクトリ (default: data/SoRNote/)
@default data/SoRNote/
@type string
@param ExNoteSuffix
@desc 拡張メモ用ファイル名の接尾辞 (default: _note)
@default _note
@type string
@param ExNoteExtension
@desc 拡張メモ用ファイルデータの拡張子
@default
@type string
@param ---補助機能---
@param ProtectOverwritten
@desc 指定の*.txtがあっても読込・ファイル生成をしない。主に完成品の公開時用 (default: false)
@default false
@type boolean
*/
/*:
@plugindesc <External Note Extension> v1.21
@author Soryu
@target MZ
@url https://dragonflare.blue/dcave/index_e.php
@help This plugin enables RPGMaker games to include note tags
for every item on the database(editor) as additional note fields.
Text files (*.txt) located designated directory in the game project
are translated into the compressed format when the game boots.

(!! When you release the completed game, you must exclude *.txt files
from the release data not to be tampered by others.)
@param ---Basic---
@param ExNotePath
@desc Directory of extended note texts (default: data/SoRNote/)
@default data/SoRNote/
@type string
@param ExNoteSuffix
@desc Suffix of "compressed" extended note files (default: _note)
@default _note
@type string
@param ExNoteExtension
@desc Extension of "compressed" extended note files
@default
@type string
@param ---Auxiliary---
@param ProtectOverwritten
@desc Disable to generate extended note data even if *.txt is existing. For release of completed games (default: false)
@default false
@type boolean
*/

(function() {
const Param = PluginManager.parameters('SoR_DataNoteExtension_MZ');
const Extended_NotePath = String(Param['ExNotePath'] || "data/SoRNote/");
const ExNoteSuffix = String(Param['ExNoteSuffix'] || "");
const ExNoteExtension = String(Param['ExNoteExtension'] || "");

//v1.10
const ProtectOverwritten = Boolean(Param['ProtectOverwritten'] === 'true' || false);


function f2() {
	throw new Error("Illegal Operation.");
	return
}
///////////////////////////////////////////////////////////////////

const seed = 120;
const DMList = ["Actors","Classes","Skills","Items","Weapons","Armors","Enemies","Troops","States","Animations","Tilesets","CommonEvents"];

const SoR_DNE_SB_initialize = Scene_Boot.prototype.initialize;
Scene_Boot.prototype.initialize = function() {
    DataManager.loadExtendedNotesRawData();
    SoR_DNE_SB_initialize.call(this);
}

DataManager.loadExtendedNotesRawData = function(){
    const fs = require('fs');
    const ls = fs.readdirSync(Extended_NotePath);

    if(!ProtectOverwritten){
        for(const file of ls){
            if(file.match(/^(.+?)\.txt$/)){
                const fn = String(RegExp.$1);
                const txtar = Extended_NotePath+file;
                const convfile = Extended_NotePath + fn + ExNoteSuffix + ExNoteExtension;
                const tx = fs.readFileSync(txtar, 'utf8');
				const stgf = e2(JsonEx.stringify(tx), seed);
                const z = pako.deflate(stgf, { to: "string", level: 3 });
                fs.writeFileSync(convfile, z);
            }
        }
    }
    //finalize
    this.ExtendedNoteFiles = fs.readdirSync(Extended_NotePath);
    this._tmpEXNote = new Map();
}

const SoR_DNE_DM_loadDataFile = DataManager.loadDataFile;
DataManager.loadDataFile = function(name, src) {
    let testsrc = src;
    testsrc = testsrc.replace("Test_", "");
    const targetFiles = this.listTargetJsons(testsrc);
    const targetarr = [""];
    let Domain = "";
    for(const exNote of targetFiles){
        const ret = this.ExtractExtendedNotesJson(exNote);
        Domain = ret.key;
        targetarr[ret.id-1] = ret.val;
    }
    if(Domain != "") this._tmpEXNote.set(Domain, targetarr);

    SoR_DNE_DM_loadDataFile.call(this,...arguments);
}


DataManager.listTargetJsons = function(name){
    const fs = require('fs');
    const ls = fs.readdirSync(Extended_NotePath);

    if(PluginManager._scripts.includes("SoRX_DataCompressor_Release_MZ")) name.match(/^(.+?)\.sorx$/);
    else name.match(/^(.+?)\.json$/);
	
	
    const fnraw = String(RegExp.$1);
    if(DMList.some(x=> x==fnraw)){
        const regexp = new RegExp(fnraw + '(\\d{4})' + ExNoteSuffix + ExNoteExtension); 
        const ret = this.ExtendedNoteFiles.filter(elem => elem.match(regexp));
        if(ret) return ret; //array
        else return [];
    }
    else if(fnraw.match(/Map(\d{3})/)){
        const cand = fnraw + ExNoteSuffix + ExNoteExtension;
        const ret = this.ExtendedNoteFiles.find(elem => elem == cand);
        const arr = ret? [cand] : [];

        const regexp = new RegExp('^' + fnraw + "Ev" + '(\\d{3})' + ExNoteSuffix + ExNoteExtension + '$');
        for(const file of ls){
            if(file.match(regexp)){
                const sub_cand = fnraw + "Ev" + String(RegExp.$1) + ExNoteSuffix + ExNoteExtension;
                arr.push(sub_cand);
            }
        }
        return arr;
    }
    else{
        return [];
    }
}


DataManager.ExtractExtendedNotesJson = function(exnote){
	const fs = require('fs');
    const regexp = new RegExp('^(\\D+)(\\d+)(Ev\\d{3})?' + ExNoteSuffix + ExNoteExtension + '$');
    const regexp2 = new RegExp('^(\\D+)(\\d+)' + "Ev" + '(\\d{3})' + ExNoteSuffix + ExNoteExtension + '$');
    exnote.match(regexp);

    let fnraw = String(RegExp.$1);
    let id = Number(RegExp.$2);

    if(DMList.every(x=> x!=fnraw)){
        fnraw += RegExp.$2;
        if(exnote.match(regexp2)) id = Number(RegExp.$3) + 1;//mapevid
        else id = 1;
    }

    const extfile = Extended_NotePath + exnote;
    if(fs.existsSync(extfile)){
        const z = fs.readFileSync(extfile, 'utf8');
        const json =  d2(pako.inflate(z, { to: "string" }), seed);
        const object = JsonEx.parse(json);

        return {key: fnraw, val: object, id};
    }
    return {key: fnraw, val: [], id};	
}


DataManager.extractExnote_arbitrary = function(exnotef){
	const fs = require('fs');

    const extfile = Extended_NotePath + exnotef + ExNoteExtension;
    if(fs.existsSync(extfile)){
        const z = fs.readFileSync(extfile, 'utf8');
        const json = d2(pako.inflate(z, { to: "string" }), seed);
        const object = JsonEx.parse(json);

        return object;
    }
    return null;
}




const SoR_DNE_DM_extractMetadata = DataManager.extractMetadata;
DataManager.extractMetadata = function(data, mapid) {
    const tar = calcTargetFileClass(data, mapid);

    if(tar && this._tmpEXNote.get(tar.key) && this._tmpEXNote.get(tar.key)[tar.idx]){
        data.note = data.note.concat("\n");//for error treatment
        data.note = data.note.concat(this._tmpEXNote.get(tar.key)[tar.idx]);
    }

    SoR_DNE_DM_extractMetadata.call(this,...arguments);
}


//data matching
function calcTargetFileClass(data,mapid){
    const idx = data.id? data.id-1 : 0;

    if(data.hasOwnProperty("nickname")) return {key: "Actors", idx};
    else if(data.hasOwnProperty("learnings")) return {key: "Classes", idx};
    else if(data.hasOwnProperty("wtypeId")) return {key: "Weapons", idx};
    else if(data.hasOwnProperty("atypeId")) return {key: "Armors", idx};
    else if(data.hasOwnProperty("itypeId")) return {key: "Items", idx};
    else if(data.hasOwnProperty("stypeId")) return {key: "Skills", idx};
    else if(data.hasOwnProperty("tilesetNames")) return {key: "Tilesets", idx};
    else if(data.hasOwnProperty("minTurns") && data.hasOwnProperty("chanceByDamage")) return {key: "States", idx};
    else if(data.hasOwnProperty("dropItems") && data.hasOwnProperty("battlerHue")) return {key: "Enemies", idx};
    else if(data.hasOwnProperty("members") && data.hasOwnProperty("pages")) return {key: "Troops", idx};
    else if(data.hasOwnProperty("effectName") && data.hasOwnProperty("soundTimings")) return {key: "Animations", idx};
    else if(data.hasOwnProperty("switchId") && data.hasOwnProperty("list")) return {key: "CommonEvents", idx};
    else if(data.hasOwnProperty("disableDashing") && data.hasOwnProperty("encounterList")) return {key: "Map" + mapid, idx};
    else if(data.hasOwnProperty("pages") && data.hasOwnProperty("x") && data.hasOwnProperty("y")) return {key: "Map" + mapid, idx: idx+1, event: true};

    return null;
}


//////////////////////////////////////////////////////////////////////////////
function e2(v, k) {
    if(!k) f2();
	
    v = encodeURIComponent(v);
    let re = "";
	const vl = v.length;
    for (let i = 0; i < vl; i++) re += String.fromCharCode(v.charCodeAt(i) + k);
 
    return re;
}

function d2(v, k) {
    if(!k) f2();		
	
    let re = "";
	const vl = v.length;
    for (let i = 0; i < vl; i++) re += String.fromCharCode(v.charCodeAt(i) - k);
	
    return decodeURIComponent(re) ;
}





//////////////////////////////////////////////////////////////////////////////
const SoR_DBE_DM_onXhrLoad = DataManager.onXhrLoad;
DataManager.onXhrLoad = function(xhr, name, src, url) {
    if(src.match(/Map(\d{3}).json/)){//maploading
        if (xhr.status < 400) {
            window[name] = JSON.parse(xhr.responseText);
            this.onMapLoad(window[name], String(RegExp.$1));
        } 
        else this.onXhrError(name, src, url);
    }
    else if(src.match(/Troops.json/) || src.match(/Animations.json/) || src.match(/CommonEvents.json/)){
        if (xhr.status < 400) {
            window[name] = JSON.parse(xhr.responseText);
            this.onNonMetaLoad(window[name]);
        } 
        else this.onXhrError(name, src, url);
    }
    else SoR_DBE_DM_onXhrLoad.call(this, ...arguments);
}

DataManager.onMapLoad = function(object, mapid){
    this.extractMetadata(object, mapid);
    this.extractMapArrayMetadata(object.events, mapid);
}

DataManager.extractMapArrayMetadata = function(array, mapid){
    if (Array.isArray(array)) {
        for (const data of array) {
            if (data && "note" in data)  this.extractMetadata(data, mapid);
        }
    }
}

DataManager.onNonMetaLoad = function(object){
    if (Array.isArray(object)) {
        for (const data of object) {
            if(data){
                data.note = "";
                this.extractMetadata(data);
            }
        }
    }
}


})();