//=============================================================================
// SoR_EscapedProcessExtension_MZ.js
// SoR License (C) 2020 蒼竜, REQUIRED User Registration on Dragon Cave
// http://dragonflare.blue/dcave/license.php
// ----------------------------------------------------------------------------
// Latest version v1.00 (2021/06/25)
//=============================================================================
/*:ja
@plugindesc ＜戦闘逃走処理拡張・成功率調整＞ v1.00
@author 蒼竜
@target MZ
@base SoR_BattleTeminationRefactor_MZ
@orderAfter SoR_BattleTeminationRefactor_MZ
@url http://dragonflare.blue/dcave/
@help ※要 57.「戦闘終了処理ルーチン細分化」(SoR_BattleTeminationRefactor_MZ.js)

戦闘逃走時における成功率などの補正機能を導入します。
特に82.「戦闘逃走メッセージウィンドウ」のポップアップシステム導入による
内部システムの都合上、他者作のプラグインと共存できない細かな戦闘仕様を補填する
ことが主な目的です。

※「戦闘終了処理ルーチン細分化」(SoR_BattleTeminationRefactor_MZ)において
専用パラメータ"Enable_EscapeAbort"を有効にしておく必要があります。

<計算式記述上の注意>
逃走確率は0以上1以下の実数(単位なし)で表され、1.0のとき100%成功に相当する。
計算式の値はこの範囲に収まることを念頭に置くと良い。
@param -逃走確率-
@param AlternativeEscapeRateFormula
@desc 適用する通常の戦闘逃走確率計算式。空欄でデフォルト計算式使用
@type string
@default 
@param AlternativeEscapeRateFormula_Preemptive
@desc 適用する先制攻撃時の戦闘逃走判定条件式。空欄でデフォルト条件(100%成功)使用
@type string
@default 
@param PenartyEscapeRateFormula_Surprised
@desc 不意打ち時に戦闘逃走率へ追加する逃走率補正式(計算式)。空欄でデフォルト通り(ペナルティなし)
@type string
@default 
@param ModifierEscapeRateFormula_onFailure
@desc 逃走失敗時の逃走成功率補正式。空欄でデフォルト通り(失敗ごとに+10%)
@type string
@default 
@param -その他-
@param EscapedBahavior
@desc サイドビュー戦闘における、逃走成功時のアクター動作 (default: 0)
@type select
@option 後方に退却
@value 0
@option 前方へ退却(突破)
@value 1
@option 両方(確率で決定)
@value 2
@default 0
@param IsSeparateSE
@desc true: 逃走成功/失敗に応じて異なる効果音を再生 (default: false)
@default false
@type boolean
@param SE_EscapeFailed
@desc (成功/失敗SE分離時のみ)逃走失敗時に再生する効果音
@type struct<SEDATA>
@default {"name":"","volume":"100","pitch":"100","pan":"0"}
@param BalloonID_EscapeSucceeded
@desc 逃走成功時にアクター頭上に表示するふきだしバルーンのID。0で非表示
@type number 
@default 0
@param BalloonID_EscapeFailed
@desc 逃走失敗時にアクター頭上に表示するふきだしバルーンのID。0で非表示
@type number 
@default 6
*/
/*:
@plugindesc <Battle Escape Extension/Adjustment> v1.00
@author Soryu
@target MZ
@base SoR_BattleTeminationRefactor_MZ
@orderAfter SoR_BattleTeminationRefactor_MZ
@url http://dragonflare.blue/dcave/index_e.php
@help [Prerequisite] 57. SoR_BattleTeminationRefactor_MZ
and enable a parameter "Enable_EscapeAbort"

This plugin supports the modification of battle escape probability 
and other features related to the battle escape.
This is particularly a conmpensation for the internal battle system with 
the plugin 82. "SoR_EscapedMessageWindow" which may not get along with
plugins developed by others.

@param -Probability of Escape-
@param AlternativeEscapeRateFormula
@desc An alternative regular escape formula. Leave it blank to use the default.
@type string
@default 
@param AlternativeEscapeRateFormula_Preemptive
@desc An alternative escape CONDITION under preemptive. Leave it blank to use the default (must success to escape).
@type string
@default 
@param PenartyEscapeRateFormula_Surprised
@desc An alternative escape formula under surprised. Leave it blank to use the default (no penalty).
@type string
@default 
@param ModifierEscapeRateFormula_onFailure
@desc An alternative correction of escape probability applied when the escape is failed. Leave it blank to use the default (+10% every time).
@type string
@default 
@param -Others-
@param EscapedBahavior
@desc Actor performance in the side-view battle to escape from the baatle (default: 0)
@type select
@option Retreat backward 
@value 0
@option Retreat forward (like breakthrough)
@value 1
@option Both (selected in probability)
@value 2
@default 0
@param IsSeparateSE
@desc If true, different SE is played based on the situation escape successfull or failed. (default: false)
@default false
@type boolean
@param SE_EscapeFailed
@desc An SE palayed when the escape is failed, if the independent failure SE is enabled. 
@type struct<SEDATAE>
@default {"name":"","volume":"100","pitch":"100","pan":"0"}
@param BalloonID_EscapeSucceeded
@desc A balloon ID shown above actors if succeeded in escape. Set 0 to disable.
@type number 
@default 0
@param BalloonID_EscapeFailed
@desc A balloon ID shown above actors if failed in escape. Set 0 to disable.
@type number 
@default 6
*/
/*~struct~SEDATA:
@type string
@param name
@dir audio/se/
@type file
@desc 効果音
@param volume
@desc 音量 [0...100]
@type number
@default 100
@min 0
@max 100
@param pitch
@desc ピッチ [50...150]
@type number
@default 100
@min 50
@max 150
@param pan
@desc パン(位相) [-50...50]
@type number
@default 0
@min -50
@max 50
*/
/*~struct~SEDATAE:
@type string
@param name
@dir audio/se/
@type file
@desc SE File
@param volume
@desc Voulme [0...100]
@type number
@default 100
@min 0
@max 100
@param pitch
@desc Pitch [50...150]
@type number
@default 100
@min 50
@max 150
@param pan
@desc Pan [-50...50]
@type number
@default 0
@min -50
@max 50
*/

(function() {
const pluginName = "SoR_EscapedProcessExtension_MZ";
const Param = PluginManager.parameters(pluginName);

if(!PluginManager._scripts.includes("SoR_BattleTeminationRefactor_MZ")) throw new Error("[SoR_EscapedProcessExtension_MZ] This plugin REQUIRES SoR_BattleTeminationRefactor_MZ.");
else{
	const testp = PluginManager.parameters("SoR_BattleTeminationRefactor_MZ");
	const eea = Boolean(testp['Enable_EscapeAbort'] === 'true') || false;
	if(!eea) throw new Error("[SoR_EscapedProcessExtension_MZ] A plugin parameter \"Enable_EscapeAbort\" in SoR_BattleTeminationRefactor_MZ MUST be true.");
}

const AlternativeEscapeRateFormula = String(Param['AlternativeEscapeRateFormula']) || ''; 
const AlternativeEscapeRateFormula_Preemptive = String(Param['AlternativeEscapeRateFormula_Preemptive']) || ''; 
const PenartyEscapeRateFormula_Surprised = String(Param['PenartyEscapeRateFormula_Surprised']) || ''; 
const ModifierEscapeRateFormula_onFailure = String(Param['ModifierEscapeRateFormula_onFailure']) || ''; 
const EscapedBahavior = Number(Param['EscapedBahavior']) || 0; 
const IsSeparateSE = Boolean(Param['IsSeparateSE'] === 'true' || false);
const SE_EscapeFailed = convertJsonSE(Param['SE_EscapeFailed']);

const BalloonID_EscapeSucceeded = Number(Param['BalloonID_EscapeSucceeded']) || 0; 
const BalloonID_EscapeFailed = Number(Param['BalloonID_EscapeFailed']) || 0; 

function convertJsonSE(param) {
    const obj = JSON.parse(param);
    obj.volume = Number(obj.volume);
    obj.pan = Number(obj.pan);
    obj.pitch = Number(obj.pitch);
    return obj;
}

const SoR_EPE_BM_makeEscapeRatio = BattleManager.makeEscapeRatio;
BattleManager.makeEscapeRatio = function() {
    if(AlternativeEscapeRateFormula == "") SoR_EPE_BM_makeEscapeRatio.call(this); //default
    else this._escapeRatio = SoR_Eval(AlternativeEscapeRateFormula); //(0.5 * $gameParty.agility()) / $gameTroop.agility();
}

const SoR_EPE_BM_processEsc_evalEscapeRate_Preemptive = BattleManager.processEsc_evalEscapeRate_Preemptive;
BattleManager.processEsc_evalEscapeRate_Preemptive = function() {
    if(AlternativeEscapeRateFormula_Preemptive == "") SoR_EPE_BM_processEsc_evalEscapeRate_Preemptive.call(this);
    return SoR_Eval(AlternativeEscapeRateFormula_Preemptive);
}

const SoR_EPE_BM_processEsc_calcEscapeRate = BattleManager.processEsc_calcEscapeRate;
BattleManager.processEsc_calcEscapeRate = function() {
    let base = SoR_EPE_BM_processEsc_calcEscapeRate.call(this); //this._escapeRatio

    if(PenartyEscapeRateFormula_Surprised != ""){
        if(this._surprise){
            base += SoR_Eval(PenartyEscapeRateFormula_Surprised);
        }
    }
    return base;
}

const SoR_EPE_BM_ModifyEscapeRateonEscapeFailure = BattleManager.ModifyEscapeRateonEscapeFailure;
BattleManager.ModifyEscapeRateonEscapeFailure = function() {

    if(ModifierEscapeRateFormula_onFailure == "") SoR_EPE_BM_ModifyEscapeRateonEscapeFailure.call(this);
    else this._escapeRatio += SoR_Eval(ModifierEscapeRateFormula_onFailure);
}


const SoR_EPE_SA_retreat = Sprite_Actor.prototype.retreat;
Sprite_Actor.prototype.retreat = function() {
    let pattern = 0;
    switch(EscapedBahavior){
        case 1:
        pattern = 1;
        break;
        case 2:
        pattern = Math.random()<0.5? 0 : 1;
        break;
        default:
        break;
    }

    if(pattern == 0) SoR_EPE_SA_retreat.call(this);//default
    else this.startMove(-Graphics.width, 0, 60); //forward 
}

const SoR_EPE_BM_processEsc_PerformSound = BattleManager.processEsc_PerformSound;
BattleManager.processEsc_PerformSound = function() {
    if(!IsSeparateSE) SoR_EPE_BM_processEsc_PerformSound.call(this);
}

const SoR_EPE_BM_processonEscapeSuccess = BattleManager.processonEscapeSuccess;
BattleManager.processonEscapeSuccess = function() {
	SoR_EPE_BM_processonEscapeSuccess.call(this);
    if(IsSeparateSE) SoundManager.playEscape();
    this.EscapeBalloons(BalloonID_EscapeSucceeded);
}

const SoR_EPE_BM_processonEscapeFailure = BattleManager.processonEscapeFailure;
BattleManager.processonEscapeFailure = function() {
	SoR_EPE_BM_processonEscapeFailure.call(this);
    if(IsSeparateSE) AudioManager.playSe(SE_EscapeFailed);
    this.EscapeBalloons(BalloonID_EscapeFailed);
}


/////////////////////////////////////////////////////////////////////////////////////
const SoR_EPE_SSB_initialize = Spriteset_Battle.prototype.initialize;
Spriteset_Battle.prototype.initialize = function() {
    Spriteset_Base.prototype.initialize.call(this);
    if(typeof this._balloonSprs === "undefined") this._balloonSprs = [];
}

const SoR_EPE_SSB_update = Spriteset_Battle.prototype.update;
Spriteset_Battle.prototype.update = function() {
    SoR_EPE_SSB_update.call(this);
    this.updateBalloonSprs();
}
Spriteset_Battle.prototype.updateBalloonSprs = function() {
    for (const sprite of this._balloonSprs) {
        if (!sprite.isPlaying()) this.removeBalloonSprs(sprite);
    }
}

Spriteset_Battle.prototype.removeBalloonSprs = function(sprite) {
    this._balloonSprs.remove(sprite);
    this._effectsContainer.removeChild(sprite);
    if (sprite.targetObject.endBalloon) sprite.targetObject.endBalloon();
    sprite.destroy();
}

BattleManager.EscapeBalloons = function(idx) {
    if(idx<=0) return;
    for (const x of $gameParty.battleMembers()){
        if (x.canMove()){
            const targetSprite = x._sprite();
            if(targetSprite == null) continue;
            const sprite = new Sprite_BalloonBEsc();
            sprite.targetObject = x;
            sprite.setup(targetSprite, idx);
            this._spriteset._effectsContainer.addChild(sprite);
            this._spriteset._balloonSprs.push(sprite);
        }
    }
}

//map: battler object -> battler sprite
Game_Battler.prototype._sprite = function() {
    if(BattleManager._spriteset!=null) return BattleManager._spriteset.findTargetSprite(this);
    return null;
}

/////////////////////////////////////////////////////////////////////////////////////
function Sprite_BalloonBEsc() {
    this.initialize(...arguments);
}
Sprite_BalloonBEsc.prototype = Object.create(Sprite_Balloon.prototype);
Sprite_BalloonBEsc.prototype.constructor = Sprite_BalloonBEsc;
Sprite_BalloonBEsc.prototype.initialize = function() {
    Sprite_Balloon.prototype.initialize.call(this);
}
/////////////////////////////////////////////////////////////////////////////////////












/////////////////////////////////////////////////////////////////////////////////////
Game_Unit.prototype._maxAGI = function() {
    const members = this.members();
    return members.reduce((r, member) => { return Math.max(r, member.agi)}, 0 );
}
Game_Unit.prototype._minAGI = function() {
    const members = this.members();
    return members.reduce((r, member) => { return Math.min(r, member.agi)}, 9999999999 );
}
Game_Temp.prototype._rErr = function(a,e) {
    const absErr = a-e;
    if(e==0) return 0;
    return absErr/e;
}


/////////////////////////////////////////////////////////////////////////////////////
function SoR_Eval(ev) {
    const sentence = "return (" + ev + ");";

    if(typeof $gameTemp.SoRTmp_script === "undefined") $gameTemp.SoRTmp_script = new Map();
    if(!$gameTemp.SoRTmp_script.has(sentence)){
        $gameTemp.SoRTmp_script.set(sentence, new Function(sentence));
    }
    const res = $gameTemp.SoRTmp_script.get(sentence)();
    return res;
}


})();