//=============================================================================
// SoR_SkillConsecutiveActivation_MZ.js
// SoR License (C) 2022 蒼竜, REQUIRED User Registration on Dragon Cave
// http://dragonflare.blue/dcave/license.php
// ----------------------------------------------------------------------------
// Latest version v1.40 (2023/08/06)
//=============================================================================
/*:ja
@plugindesc ＜連続スキル発動＞ v1.40
@author 蒼竜
@target MZ
@url https://dragonflare.blue/dcave/
@orderAfter SoR_TagDataProcessor_MZ
@base SoR_TagDataProcessor_MZ
@help ※要 88.「SoRタグデータ解析」(SoR_TagDataProcessor_MZ.js)

１回の戦闘行動において、
登録したスキルを連続して発動する機能を持ったスキルを実装します。

起点となるスキルを戦闘で使用した際に、登録された連続発動スキルは
基本的な発動条件、並びに指定した任意の条件を満たしている限り、
続けて発動します。
*/
/*:
@plugindesc <Consecutive Skill Activation> v1.40
@author Soryu
@target MZ
@url https://dragonflare.blue/dcave/index_e.php
@orderAfter SoR_TagDataProcessor_MZ
@base SoR_TagDataProcessor_MZ
@help [Prerequisite] 88. SoR_TagDataProcessor_MZ

This plugin implements skills which can be followed
by designated skills when it is activated in battles.

Once the origin skill is used, its associated skills 
are activated consecutively as long as skill conditions
(given by the default system and originally designated)
are fulfilled.
*/
(function() {
if(!PluginManager._scripts.includes("SoR_TagDataProcessor_MZ")) throw new Error("[SoR_SkillConsecutiveActivation_MZ] This plugin REQUIRES SoR_TagDataProcessor_MZ.");
const pluginName = "SoR_SkillConsecutiveActivation_MZ";
const Param = PluginManager.parameters(pluginName);

const SoR_SCA_DM_initializeSoRTagProcessor = DataManager.initializeSoRTagProcessor;
DataManager.initializeSoRTagProcessor = function() {
    SoR_SCA_DM_initializeSoRTagProcessor.call(this);
    const q = {name: "SoRSCA", target: ["skill"]};
    this._SoRTagProcessFuncs.push(q);
}
DataManager.SoRSCA_init = function(obj) {}

const beginTag = /<(?:SkillConsecutive)(:[\s]*(fix))?>/i;

const endTag = /<(?:\/SkillConsecutive)>/i;
const skillTag = /[\s]*(\d+)?,[\s]*(.*)[\s]*,[\s]*(.*)/;

DataManager.SoRSCA = function(obj, line, intensive) {
    let MatchFlag = false;
	
    if(!intensive){
        if(line.match(beginTag)){
            obj.consecutiveList = [];
            if(RegExp.$2 == "fix") obj.consecutiveFix = true; 
            return null;
        }
        else return false;
    }

	if(intensive === true){
        if(line.match(skillTag)){
            const sid = Number(RegExp.$1);
            const prob = Number(RegExp.$2);
            const cond = RegExp.$3;

            if(!Number.isNaN(sid) && !Number.isNaN(prob)){
                const cand = {
                    skillId: sid,
                    prob: prob,
                    cond: cond.trim()
                }
                if(cand.prob<=0 || cand.prob>=1) cand.prob=1;
                obj.consecutiveList.push(cand);
            }
		}
        else if (line.match(endTag)){//finish tags
            return true;
        }
    }
	
	return MatchFlag;
}


//////////////////////////////////////////////////////////////////////////////////
const SoR_SCA_BM_startBattle = BattleManager.startBattle;
BattleManager.startBattle = function() {
    SoR_SCA_BM_startBattle.call(this);
    this.Init_SkillConsecutiveActivation();
}

BattleManager.Init_SkillConsecutiveActivation = function() {
    this.ConsecutiveSkills = [];
	this.ConsecutiveSkills_evac = [];
    this.SKLConsecutiveFlag = false;
}

const SoR_SCA_BM_endAction = BattleManager.endAction;
BattleManager.endAction = function() {
	
    if(this.ConsecutiveSkills.length >= 1){
        if($gameTroop.isAllDead()){
            this.Init_SkillConsecutiveActivation();			
        }
        else{
			this.SKLConsecutiveFlag = true;
            this.perform_consecutiveSkills();
            return;
        }
    }
	else if(this.ConsecutiveSkills_evac.length>=1){
		this.resumeOriginalSkills_consec();
	}
	else this.SKLConsecutiveFlag = false;

    SoR_SCA_BM_endAction.call(this);//default
}


BattleManager.resumeOriginalSkills_consec = function() {
	const origin_item = this.ConsecutiveSkills_evac.shift();	
	const oldData = {idx: origin_item._targetIndex, scope: origin_item.item().scope};

    this._subject.clearActions();
    this._subject._actions[0] = origin_item;
    this._subject._actions[0]._SoR_ActionCounter = 0;

    const subject = this._subject;
    const action = this._subject._actions[0];

    targets = action.testTarget();
	if(this.ConsecutiveSkillsTargetFix && action.item().scope == oldData.scope) action._targetIndex = oldData.idx; //keep target index if required
    this._phase = "turn";
}


BattleManager.perform_consecutiveSkills = function() {
    const skill = this.ConsecutiveSkills.shift();

    const testRand = Math.random();
	const condTxt = skill.cond ? PSVScriptFunctionConverter(skill.cond) : "true";
    if(skill.prob < testRand || !SoR_EvalBSS(condTxt, this._subject)){
        this.ConsecutiveSkills = [];
        return;
    }

    const conSkill = new Game_Action(this._subject);
    conSkill.setSkill(skill.skillId);
    if(!this._subject.canUse($dataSkills[skill.skillId])){
        this.ConsecutiveSkills = [];
        return;
    }


	const oldData = {idx: this._action._targetIndex, scope: this._action.item().scope};

    this._subject.clearActions();
    this._subject._actions[0] = conSkill;
    this._subject._actions[0]._SoR_ActionCounter = 0;

    const subject = this._subject;
    const action = this._subject._actions[0];

    targets = action.testTarget();
	if(this.ConsecutiveSkillsTargetFix && action.item().scope == oldData.scope) action._targetIndex = oldData.idx; //keep target index if required
    this._phase = "turn";
}


Game_Action.prototype.testTarget = function() {
    const targets = [];
    if (!this._forcing && this.subject().isConfused()) {
        targets.push(this.confusionTarget());
    } else if (this.isForEveryone()) {
        targets.push(...this.targetsForEveryone());
    } else if (this.isForOpponent()) {
        targets.push(...this.targetsForOpponents());
    } else if (this.isForFriend()) {
        targets.push(...this.targetsForFriends());
    }
    return this.repeatTargets(targets);
}


//////////////////////////////////////////////////////////////
const SoR_SCA_BM_startAction = BattleManager.startAction;
BattleManager.startAction = function() {
    SoR_SCA_BM_startAction.call(this);
    this.setConsecutiveSkills();
}

BattleManager.setConsecutiveSkills = function() {
    const subject = this._subject;

    // 現在のアクションが null であれば、処理を中断する
    if (!subject) {
        console.log("null subject");
        return;
    }

    const action = subject.currentAction();

    // 現在のアクションが null であれば、処理を中断する
    if (!action) {
        console.log("null action");
        return;
    }

    const obj = action._item.object();

    if(!obj.consecutiveList || this.ConsecutiveSkills.length>0) return;
    this.ConsecutiveSkills = obj.consecutiveList.slice();
    this.ConsecutiveSkillsTargetFix = !!obj.consecutiveFix;
	
	
	let test_left_len = this._subject._actions.length-1;
	while(test_left_len>=1){
		const evacitem = this._subject._actions.pop();
		this.ConsecutiveSkills_evac.unshift(evacitem);
		test_left_len--;
	}

}

///v1.40
const SoR_SCA_BM_updateTpb = BattleManager.updateTpb;
BattleManager.updateTpb = function() {
	if(this.SKLConsecutiveFlag == true) return; //dirty update........
	SoR_SCA_BM_updateTpb.call(this);
}

/////////////////////////////////////////////////////////////////////////////////////
//treatment in v1.21
const SoR_SCA_GA_setConfusion = Game_Action.prototype.setConfusion;
Game_Action.prototype.setConfusion = function() {
	
	const actionItem = this._item.object();
	if(BattleManager.ConsecutiveSkills && actionItem!=null){
		if(!actionItem.consecutiveList || BattleManager.ConsecutiveSkills.length>0) return;		
	}
	SoR_SCA_GA_setConfusion.call(this);
}

/////////////////////////////////////////////////////////////////////////////////////
function PSVScriptFunctionConverter(command){
    command = command.replace(/LeftHPRate/ig, "this.hp/this.mhp");
    command = command.replace(/LeftHP/ig, "this.hp");
    command = command.replace(/LeftMPRate/ig, "this.mp/this.mmp");
    command = command.replace(/LeftMP/ig, "this.mp");
    command = command.replace(/LeftTP/ig, "this.tp");
    command = command.replace(/LeftTPRate/ig, "this.tp/this.maxTp()");
    command = command.replace(/Level/ig, "this.level");
    command = command.replace(/IsState\[(\d+)\]/ig, (_, p1) => {return "this.isStateAffected("+ p1 +")"});
    command = command.replace(/aliveParty/ig, "$gameParty.aliveMembers().length");
    command = command.replace(/aliveTroop/ig, "$gameTroop.aliveMembers().length");
    command = command.replace(/aliveFriend/ig, "this.friendsUnit.aliveMembers().length");
    command = command.replace(/aliveOpponent/ig, "this.opponentsUnit.aliveMembers().length");
    command = command.replace(/Turn/ig, "$gameTroop._turnCount");
    if(PluginManager._scripts.includes("SoR_BattleTimeCounter_MZ")) command = command.replace(/Time/ig, "BattleManager._getRawCurrentBTCounter()");
    return command;
}
/////////////////////////////////////////////////////////////////////////////////////

function SoR_EvalBSS(ev, gb) {
    ev = ev.replace(/this/g, "gb");
    const sentence = "return (" + ev + ");";
    if(typeof $gameTemp.SoRTmp_script === "undefined") $gameTemp.SoRTmp_script = new Map();
    if(!$gameTemp.SoRTmp_script.has(sentence)){
        $gameTemp.SoRTmp_script.set(sentence, new Function("gb",sentence));
    }
    const res = $gameTemp.SoRTmp_script.get(sentence)(gb);
    return res;
}

function SoR_Eval(ev) {
    const sentence = "return (" + ev + ");";
    if(typeof $gameTemp.SoRTmp_script === "undefined") $gameTemp.SoRTmp_script = new Map();
    if(!$gameTemp.SoRTmp_script.has(sentence)){
        $gameTemp.SoRTmp_script.set(sentence, new Function(sentence));
    }     
    const res = $gameTemp.SoRTmp_script.get(sentence)();
    return res;
}

})();