//=============================================================================
// SoR_UnidentifiedItems_MZ.js
// SoR License (C) 2020 蒼竜, REQUIRED User Registration on Dragon Cave
// http://dragonflare.blue/dcave/license.php
// ----------------------------------------------------------------------------
// Latest version v1.10 (2020/12/07)
//=============================================================================
/*:ja
@plugindesc ＜未鑑定アイテム＞ v1.10
@author 蒼竜
@target MZ
@orderAfter SoR_TagDataProcessor_MZ
@base SoR_TagDataProcessor_MZ
@url https://dragonflare.blue/dcave/
@help ※要 88.「SoRタグデータ解析」(SoR_TagDataProcessor_MZ.js)

入手したアイテムの実体を確認するために鑑定作業が必要となる
不確定アイテム・装備品を実装します。

未鑑定状態で入手したアイテムに対して、所定のアイテム・スキルを
実行することで鑑定済み(アイテムの実体へ変換)状態にして
使用可能になるゲーム内のプロセスを生み出します。

導入に際して下記の作業(タグ記述)が必要となります。
・不確定アイテムの定義
・鑑定後のアイテム実体(変化後)の設定
・鑑定アイテム・スキルの定義

@param Setting_IdentifyWindow
@type struct<RECT>
@desc 鑑定アイテム選択ウィンドウ設定
@default {"x":"80","y":"144","width":"656","height":"364"}
@param Setting_IdentifyResultWindow
@type struct<RECT>
@desc 鑑定アイテム処理結果通知ウィンドウ設定
@default {"x":"112","y":"260","width":"592","height":"70"}

@param ResultText_Prefix
@desc 結果通知ウィンドウ内テキスト(アイテム名の前に付くテキスト)
@type string
@default  
@param ResultText_Suffix
@desc 結果通知ウィンドウ内テキスト(アイテム名の後に付くテキスト)
@type string
@default に変化しました

@param ItemColumn_IdentifyCandidate
@desc 鑑定候補を表す装備アイテムウィンドウの表示列数 (default: 1)
@default 1
@min 1
@type number

@command IdentifyAll
@text 全未鑑定アイテム鑑定 [未鑑定アイテム]
@desc 所持している全ての未鑑定アイテムを一斉に鑑定します
@command GetIdentified
@text 鑑定記録取得 [未鑑定アイテム]
@desc 直前に鑑定したアイテムの鑑定記録を1つ取得して、ゲーム変数に取り込みます
@arg arg0
@type variable
@text アイテムID格納変数
@arg arg1
@type variable
@text アイテム種類ID格納変数
*/
/*:
@plugindesc <Unidentified Items> v1.10
@author Soryu
@target MZ
@orderAfter SoR_TagDataProcessor_MZ
@base SoR_TagDataProcessor_MZ
@url https://dragonflare.blue/dcave/index_e.php
@help [Prerequisite] 88. SoR_TagDataProcessor_MZ

This plugin implements unidentified items which 
will turn to be real items by identification process.

Using designated skills or items on the menu scene,
player can obtain identified items (converted).

Following works (tag description) are required for use in the game.
- Definition of unidentified items
- Specification of tables to real items by identification
- Definition identifying skills or items

@param Setting_IdentifyWindow
@type struct<RECTE>
@desc A window to select unidentified items by skills/items 
@default {"x":"80","y":"144","width":"656","height":"364"}
@param Setting_IdentifyResultWindow
@type struct<RECTE>
@desc A window to show a result of identification
@default {"x":"112","y":"260","width":"592","height":"70"}

@param ResultText_Prefix
@desc A prefix text shown before the item name text
@type string
@default You obtained
@param ResultText_Suffix
@desc A suffix text shown after the item name text
@type string
@default .

@param ItemColumn_IdentifyCandidate
@desc The number of candidate unidentified items in a row listed in the window (default: 1)
@default 1
@min 1
@type number

@command IdentifyAll
@text Identify All [Unidentified Items]
@desc Perform identification for all unidentified items in the party possession.
@command GetIdentified
@text Get Identified Log [Unidentified Items]
@desc Extract the item identified log to the designated game variable.
@arg arg0
@type variable
@text A variable for identified item ID
@arg arg1
@type variable
@text A variable for an integer represents a type of identified item
*/
/*~struct~RECT:
@param x
@desc ウィンドウ左上x座標
@type number
@default 0
@param y
@desc ウィンドウ左上y座標
@type number
@default 0
@param width
@desc ウィンドウ幅
@type number
@default 0
@param height
@desc ウィンドウ高さ
@type number
@default 0
*/
/*~struct~RECTE:
@param x
@desc X-coordinate of top-left of the window
@type number
@default 0
@param y
@desc Y-coordinate of top-left of the window
@type number
@default 0
@param width
@desc Width of the window
@type number
@default 0
@param height
@desc Height of the window
@type number
@default 0
*/

(function() {
if(!PluginManager._scripts.includes("SoR_TagDataProcessor_MZ")) throw new Error("[SoR_UnidentifiedItems_MZ] This plugin REQUIRES SoR_TagDataProcessor_MZ.");
const pluginName = "SoR_UnidentifiedItems_MZ";
const Param = PluginManager.parameters(pluginName);

const Setting_IdentifyWindow = convertJsonParam(Param['Setting_IdentifyWindow']) || '';
const Setting_IdentifyResultWindow = convertJsonParam(Param['Setting_IdentifyResultWindow']) || '';

const ResultText_Prefix = String(Param['ResultText_Prefix']) || '';
const ResultText_Suffix = String(Param['ResultText_Suffix']) || '';
const ItemColumn_IdentifyCandidate = Number(Param['ItemColumn_IdentifyCandidate']) || 0;

function convertJsonParam(param) {
    const obj = JSON.parse(param);
    obj.x = Number(obj.x);
    obj.y = Number(obj.y);
    obj.width = Number(obj.width);
    obj.height = Number(obj.height);
    return obj;
}

PluginManager.registerCommand(pluginName, "GetIdentified", args => { 
	const argc = args.length;

    const dest1 = Number(args.arg0);
    const dest2 = Number(args.arg1);
	if(Number.isNaN(dest1)) return false;
	if(Number.isNaN(dest2)) return false;

    const log1 = $gameTemp.identified_log.shift();

    let type = -1, itemid = -1;
    if(DataManager.isItem(log1)){
        type = 1;
        itemid = log1.id;
    }
    else if(DataManager.isWeapon(log1)){
        type = 2;
        itemid = log1.id;
    }
    else if(DataManager.isArmor(log1)){
        type = 3;
        itemid = log1.id;
    }

    $gameVariables.setValue(dest1,type);
    $gameVariables.setValue(dest2,itemid);
    return true;
});
	
PluginManager.registerCommand(pluginName, "IdentifyAll", args => {
    $gameParty.identify_allUIO();
});
	

///////////////////////////////////////////////////////////////////////////////////////
const SoR_TLSA_DM_initializeSoRTagProcessor = DataManager.initializeSoRTagProcessor;
DataManager.initializeSoRTagProcessor = function() {
    SoR_TLSA_DM_initializeSoRTagProcessor.call(this);
    const q = {name: "SoRTagUDI", target: ["item"]};
    this._SoRTagProcessFuncs.push(q);
    const q2 = {name: "SoRTagUDI2", target: ["skill"]};
    this._SoRTagProcessFuncs.push(q2);
}
DataManager.SoRTagUDI_init = function(obj) {
    if(obj.meta.Unidentified) obj.unidentified = {cands: [], res: 0};
    else if(obj.meta.IdentifySkill) obj.identifySkill = true;
}
DataManager.SoRTagUDI = function(obj, line) {
    let MatchFlag = false;
    const tag = /<(?:Identify):?[ ]*(.*),[ ]*(\d+),[ ]*(\d+),[ ]*(.*)>/i;//type id prob cond

    if(typeof obj.unidentified === "undefined") return MatchFlag;

    let ret = MatchUI_calccands(line, tag);
    if(ret!=null){
        obj.unidentified.cands.push(ret);
        return true;
    }

    return MatchFlag;
}

DataManager.SoRTagUDI2_init = function(obj) {
    if(obj.meta.IdentifySkill) obj.identifySkill = true;
}
DataManager.SoRTagUDI2= function(obj) {
    let MatchFlag = false;
    return MatchFlag;
}


function MatchUI_calccands(line, maintag) {
	if (line.match(maintag)) {
        const uii = {
            type: "",
            id: undefined,
            prob: 0,
            cond: undefined
        };

        const teststr = RegExp.$1.trim();
        if(teststr=="item"||teststr=="armor"||teststr=="weapon") uii.type = teststr;

        uii.id = Number(RegExp.$2);
        if(Number.isNaN(uii.id)) uii.id = 0;

        uii.prob = Number(RegExp.$3);
        if(Number.isNaN(uii.prob)) uii.prob = 0;

        const condtx = String(RegExp.$4);
        uii.cond = condtx? condtx.trim() : "true";

        if(uii.type!="" && uii.id>0){
            return uii;
        }
	}

    return null;
}
///////////////////////////////////////////////////////////////////////////////////////

const SoR_UDI_GT_initialize = Game_Temp.prototype.initialize;
Game_Temp.prototype.initialize = function(){
    SoR_UDI_GT_initialize.call(this);
    this.identified_log = [];
}

Game_Temp.prototype.Num_unidentified = function(){
    return $gameParty.allItems().filter(item => item.unidentified).length;
}


Game_Party.prototype.identify_allUIO = function(){
    const allcands = this.allItems().filter(item => item.unidentified);
    for(const x of allcands){
        const num = this.numItems(x);
        for(let i=0; i<num; i++){
            const res = itemIdentifyrot(x);
            const realobj = getitemIdentified(x.unidentified.cands[res]);
            $gameParty.loseItem(x, 1, false);
            $gameParty.gainItem(realobj,1);
            $gameTemp.identified_log.push(realobj);
        }
    }
}
///////////////////////////////////////////////////////////////////////////////////////

const SoR_UDI_SI_create = Scene_ItemBase.prototype.create;
Scene_ItemBase.prototype.create = function() {
    SoR_UDI_SI_create.call(this);
    this.createItemIdentifyWindow();
    this.createItemIdentifyResultWindow();
}


Scene_ItemBase.prototype.createItemIdentifyWindow = function() {
    const rect = new Rectangle(Setting_IdentifyWindow.x, Setting_IdentifyWindow.y, Setting_IdentifyWindow.width, Setting_IdentifyWindow.height);
    this._IDFcandwindow = new Window_IdentifyItemList(rect);
    this._IDFcandwindow.setHandler("ok", this.onSoR_IDFOk.bind(this));
    this._IDFcandwindow.setHandler("cancel", this.onSoR_IDFCancel.bind(this));
    this._IDFcandwindow.hide();
    this.addChild(this._IDFcandwindow);
}

Scene_ItemBase.prototype.createItemIdentifyResultWindow = function() {
    const rect = new Rectangle(Setting_IdentifyResultWindow.x, Setting_IdentifyResultWindow.y, Setting_IdentifyResultWindow.width, Setting_IdentifyResultWindow.height);
    this._IDFReswindow = new Window_IdentifyItemResult(rect);
    this._IDFReswindow.setHandler("ok", this.onSoR_IDFResultchecked.bind(this));
    this._IDFReswindow.setHandler("cancel", this.onSoR_IDFResultchecked.bind(this));
    this._IDFReswindow.hide();
    this.addChild(this._IDFReswindow);
}

const SoR_UDI_SII_create = Scene_Item.prototype.create;
Scene_Item.prototype.create = function() {
	SoR_UDI_SII_create.call(this);
	this._IDFcandwindow.setHelpWindow(this._helpWindow);
}
const SoR_UDI_SS_create = Scene_Skill.prototype.create;
Scene_Skill.prototype.create = function() {
	SoR_UDI_SS_create.call(this);
	this._IDFcandwindow.setHelpWindow(this._helpWindow);
}

Scene_ItemBase.prototype.onSoR_IDFOk = function() {}
Scene_ItemBase.prototype.onSoR_IDFCancel = function() {}
Scene_ItemBase.prototype.onSoR_IDFResultchecked = function() {}

Scene_Item.prototype.onSoR_IDFOk = function() {
    const item = this._IDFcandwindow.item();
    const res = itemIdentifyrot(item);
    if(res!=null){
        const realobj = getitemIdentified(item.unidentified.cands[res]);
        $gameParty.consumeItem(this.item());
        $gameParty.loseItem(item, 1, false);
        $gameParty.gainItem(realobj,1);
        $gameTemp.identified_log.push(realobj);
        this.playSeForItem();
        this._IDFcandwindow.deactivate();
        this._helpWindow.setItem(realobj);
        this._IDFReswindow.startpopup(item,realobj);
        //this.onSoR_IDFResultOk();
    }
}
Scene_Skill.prototype.onSoR_IDFOk = function() {//////////////////////////////////////////
    const user = this.user();
    const item = this._IDFcandwindow.item();
    const res = itemIdentifyrot(item);
    if(res!=null){
        $gameTemp.identified_log = [];
        const realobj = getitemIdentified(item.unidentified.cands[res]);
        user.paySkillCost(this.item());
        $gameParty.loseItem(item, 1, false);
        $gameParty.gainItem(realobj,1);
        $gameTemp.identified_log.push(realobj);
        this.playSeForItem();
        this._statusWindow.refresh();
        this._IDFcandwindow.deactivate();
        this._helpWindow.setItem(realobj);
        this._IDFReswindow.startpopup(item,realobj);
        //this.onSoR_IDFResultOk();
    }

}


Scene_ItemBase.prototype.onSoR_IDFResultchecked = function() {
    this._IDFReswindow.close();
    this._IDFReswindow.deactivate();
    this.onSoR_IDFResultOk();
}

Scene_Item.prototype.onSoR_IDFResultOk = function() {
    if($gameParty.numItems(this.item())>=1 && this._IDFcandwindow.left_NUII()>=1){// for item (skill is independent)
        this._IDFcandwindow.checkindex();
        this._IDFcandwindow.activate();
        this._itemWindow.refresh();
        this._IDFcandwindow.refresh();
    }
    else{
        this._itemWindow.refresh();
        this._IDFcandwindow.refresh();
        this.onSoR_IDFCancel();
    }
}
Scene_Skill.prototype.onSoR_IDFResultOk = function() {
    const user = this.user();
    if(user.canUse(this.item()) && this._IDFcandwindow.left_NUII()>=1){// for skill 
        this._IDFcandwindow.checkindex();
        this._IDFcandwindow.activate();
        this._itemWindow.refresh();
        this._IDFcandwindow.refresh();
    }
    else{
        this._itemWindow.refresh();
        this._IDFcandwindow.refresh();
        this.onSoR_IDFCancel();
    }
}

Scene_ItemBase.prototype.onSoR_IDFCancel = function() {
    this._IDFcandwindow.deselect();
    this._IDFcandwindow.deactivate();
    this._IDFcandwindow.hide();
    this._itemWindow.activate();
    
}


const SoR_UDI_SIB_determineItem = Scene_ItemBase.prototype.determineItem;
Scene_ItemBase.prototype.determineItem = function() {
    const item = this.item();
    if(item.identifySkill) this.SoRUDI_determineItem();
    else SoR_UDI_SIB_determineItem.call(this);
}

Scene_ItemBase.prototype.SoRUDI_determineItem = function() {
    if(this._IDFcandwindow.left_NUII()==0){
        this.onSoR_IDFCancel();
        return;
    }

    this._IDFcandwindow.refresh();
    this._IDFcandwindow.forceSelect(0);
    this._IDFcandwindow.show();
    this._IDFcandwindow.activate();
}


function itemIdentifyrot(item){
    const realcands = item.unidentified.cands.filter(x=>(SoR_Eval(x.cond)==true));
    if(realcands.length==0) return null;
    if(realcands.length==1) return 0;

    const allsum = item.unidentified.cands.reduce((p,c)=> p+c.prob,0);
    const rndidx = Math.floor(Math.random()*allsum);

    let idx = 0;
    let testsum = 0;
    for(const x of realcands){
        if(testsum <= rndidx && testsum+x.prob > rndidx) break;
        testsum += x.prob;
        idx++;
    }

    return idx;
}

function getitemIdentified(item){
    const id = item.id;
    const type = item.type;

    if (type == "item") return $dataItems[id];
    else if (type == "weapon") return $dataWeapons[id];
    else if (type == "armor") return $dataArmors[id];
    else return null;
}



Game_Party.prototype.SoR_IdentifyAll = function(){
    $gameTemp.identified_log = [];
    while(1){
        const allcands = $gameParty.allItems().filter(item => item.unidentified);
        if(allcands.length==0) break;
        const item = allcands[0];
        const res = itemIdentifyrot(item);
        if(res!=null){
            const realobj = getitemIdentified(item.unidentified.cands[res]);
            $gameParty.loseItem(item, 1, false);
            $gameParty.gainItem(realobj,1);
            $gameTemp.identified_log.push(realobj);
        }
    }
}


///////////////////////////////////////////////////////////////////////////////////////
function Window_IdentifyItemList() {
    this.initialize(...arguments);
}

Window_IdentifyItemList.prototype = Object.create(Window_ItemList.prototype);
Window_IdentifyItemList.prototype.constructor = Window_IdentifyItemList;

Window_IdentifyItemList.prototype.initialize = function(rect) {
    Window_ItemList.prototype.initialize.call(this, rect);
}

Window_IdentifyItemList.prototype.isEnabled = function(item) {
    return true;
}

Window_IdentifyItemList.prototype.maxCols = function() {
    return ItemColumn_IdentifyCandidate;
}

Window_IdentifyItemList.prototype.includes = function(item) {
    return item.unidentified;
}

Window_IdentifyItemList.prototype.makeItemList = function() {
    this._data = $gameParty.allItems().filter(item => this.includes(item));
}

Window_IdentifyItemList.prototype.left_NUII = function() {
    return $gameParty.allItems().filter(item => this.includes(item)).length;
}

Window_IdentifyItemList.prototype.checkindex = function() {
    if(this.index()>=this.left_NUII()) this.select(this.left_NUII()-1);
}

Window_IdentifyItemList.prototype.isCurrentItemEnabled = function() {
    return true;
}

Window_IdentifyItemList.prototype.updateHelp = function() {
    this.setHelpWindowItem(this.item());
}

Window_IdentifyItemList.prototype.select = function(index) {
    this._index = index;
    this.refreshCursor();
    this.updateHelp();
}


///////////////////////////////////////////////////////////////////////////////////////

function Window_IdentifyItemResult() {
    this.initialize(...arguments);
}

Window_IdentifyItemResult.prototype = Object.create(Window_Selectable.prototype);
Window_IdentifyItemResult.prototype.constructor = Window_IdentifyItemResult;
Window_IdentifyItemResult.prototype.initialize = function(rect) {
    Window_Selectable.prototype.initialize.call(this, rect);
    this.select(0);
}

Window_IdentifyItemResult.prototype.startpopup = function(before,after) {
    this.contents.clear();
    /*
    this.drawIcon(before.iconIndex, 8, 8);
    this.drawText(before.name, 40, 8, this.width-48);

    const text = after.name + "に変化しました！";
    this.drawIcon(after.iconIndex, 8, 50);
    this.drawText(after.name, 40, 50, this.width-48);
*/
    const text = ResultText_Prefix + "\\i[" + after.iconIndex + "]" + after.name + ResultText_Suffix;
    //this.drawIcon(after.iconIndex, 12, 8);
    this.drawTextEx(text, 16, 4, this.width-88);

    this.show();
    this.activate();
    this.open();
}


///////////////////////////////////////////////////////////////////////////////////////
function SoR_Eval(ev) {
    const sentence = "return (" + ev + ");";

    if(typeof $gameTemp.SoRTmp_script === "undefined") $gameTemp.SoRTmp_script = new Map();
    if(!$gameTemp.SoRTmp_script.has(sentence)){
        $gameTemp.SoRTmp_script.set(sentence, new Function(sentence));
    }     
    const res = $gameTemp.SoRTmp_script.get(sentence)();
    return res;
}
})();