/*~struct~SE:
 *
 * @param name
 * @text ファイル名
 * @desc ファイル名です。
 * @require 1
 * @dir audio/se/
 * @type file
 * @default
 *
 * @param volume
 * @text ボリューム
 * @desc ボリュームです。
 * @type number
 * @default 90
 * @min 0
 * @max 100
 *
 * @param pitch
 * @text ピッチ
 * @desc ピッチです。
 * @type number
 * @default 100
 * @min 50
 * @max 150
 *
 * @param pan
 * @text 定位
 * @desc 定位(左右バランス)です。
 * @type number
 * @default 0
 * @min -100
 * @max 100
 */

/*:
 * @plugindesc 敵にプレイヤーを一定確率で敵視させるステートを付与する
 * @target MZ
 *
 * @param Remove Start
 * @type number
 * @text 解除するステートの開始ID
 * @desc 解除するステートの開始ID
 * @default 101
 *
 * @param Remove End
 * @type number
 * @text 解除するステートの終了ID
 * @desc 解除するステートの終了ID
 * @default 104
 *
 * @param probabilityVariableId
 * @type number
 * @text 敵視確率を格納する変数ID
 * @desc 敵視確率を格納する変数ID
 * @default 1
 *
 * @param TargetSe
 * @text 敵視発生の効果音
 * @desc 敵視発生の効果音
 * @type struct<SE>
 * @default {"FileName": "", "Volume": "90", "Pitch": "100", "Pan": "0"}
 * 
 * @help
 * このプラグインは、プレイヤー側のアクターが敵に攻撃を行った際に、
 * 敵にプレイヤーを一定確率で敵視させるステートを付与し、
 * 同時に他のプレイヤーを敵視しているステートを解除するプラグインです。
 */



(() => {
  const pluginName = 'Svr_Aggro';
  const parameters = PluginManager.parameters(pluginName);
  const REMOVE_START = Number(parameters['Remove Start']);
  const REMOVE_END = Number(parameters['Remove End']);
  const probabilityVariableId = Number(parameters['probabilityVariableId']);
  const TargetSe = JSON.parse(parameters['TargetSe']);

  const _Game_Action_apply = Game_Action.prototype.apply;
  Game_Action.prototype.apply = function(target) {
    _Game_Action_apply.call(this, target);
    if (this.subject().isActor() && target.isEnemy()) {
      const partyId = $gameParty.battleMembers().indexOf(this.subject());
      if (partyId < 0) return;
      const stateId = partyId + REMOVE_START;

      let probability = $gameVariables.value(probabilityVariableId) / 100;
//      console.log(probability);

      if (Math.random() < probability) {
        target.states().forEach(state => {
          if (state.id >= REMOVE_START && state.id <= REMOVE_END) {
            target.removeState(state.id);
          }
        });
        if (target.isAlive()) {
          this.playTargetSe();
          target.addState(stateId);
          if (probability != 1) {
            target.removeState(11);
          }
        } else {
          target.removeState(stateId);
        }
      } else if ($gameVariables.value(probabilityVariableId) === -1) {
        target.removeState(stateId);
      } else if ($gameVariables.value(probabilityVariableId) === -2) {
        target.states().forEach(state => {
          if (state.id >= REMOVE_START && state.id <= REMOVE_END) {
            target.removeState(state.id);
          }
        });
      }
    }
  };

  Game_Action.prototype.playTargetSe = function() {
    if (TargetSe.name === "") return;
    const se = {
      name: TargetSe.name,
      pan: Number(TargetSe.pan),
      pitch: Number(TargetSe.pitch),
      volume: Number(TargetSe.volume),
    };
    AudioManager.playSe(se);
  };

})();