//=============================================================================
// Svr_AttackCommandSelectFix.js
//=============================================================================

/*:
 * @target MZ
 * @plugindesc 戦闘開始時に攻撃コマンドを自動選択するプラグイン
 * @author スタジオVR
 *
 * @help
 * VisuStella Battle Core使用時に、戦闘コマンドで
 * 攻撃が自動選択されない問題を修正します。
 */

(() => {
    const _Window_ActorCommand_makeCommandList = Window_ActorCommand.prototype.makeCommandList;
    
    Window_ActorCommand.prototype.makeCommandList = function() {
        _Window_ActorCommand_makeCommandList.call(this);
        this.select(0); // 常に最初のコマンド（通常は攻撃）を選択
    };
    
    const _Window_ActorCommand_setup = Window_ActorCommand.prototype.setup;
    
    Window_ActorCommand.prototype.setup = function(actor) {
        _Window_ActorCommand_setup.call(this, actor);
        this.select(0); // セットアップ時にも最初のコマンドを選択
    };
})();