/*:
 * @target MZ
 * @plugindesc 店でアクター1の歩行キャラを指定した画像に変更し、店を出たら元に戻すプラグイン
 * @help
 * 店の画面を開いたとき、アクター1の歩行キャラを指定した画像に変更し、
 * 店を出たら元に戻す処理を行います。
 *
 * @param shopCharacterName
 * @text 店内キャラ画像ファイル
 * @desc 店に入ったときに表示されるアクター1のキャラ画像ファイル名を指定します。
 * @default Actor1
 *
 * @param shopCharacterIndex
 * @text 店内キャラ画像インデックス
 * @desc 店に入ったときに表示されるアクター1のキャラ画像のインデックス（0～7）を指定します。
 * @default 0
 */

(() => {
    const parameters = PluginManager.parameters('Svr_ChangeCharacterInShop');
    const shopCharacterName = parameters['shopCharacterName'] || 'Actor1';
    const shopCharacterIndex = Number(parameters['shopCharacterIndex'] || 0);

    let originalCharacterName = null;
    let originalCharacterIndex = null;

    const _Scene_Shop_create = Scene_Shop.prototype.create;
    Scene_Shop.prototype.create = function() {
        _Scene_Shop_create.call(this);
        this.changePlayerCharacterForShop();
    };

    const _Scene_Shop_terminate = Scene_Shop.prototype.terminate;
    Scene_Shop.prototype.terminate = function() {
        _Scene_Shop_terminate.call(this);
        this.restorePlayerCharacter();
    };

    Scene_Shop.prototype.changePlayerCharacterForShop = function() {
        const actor = $gameActors.actor(1); // アクター1を取得
        if (actor) {
            // 元のキャラ画像を保存
            originalCharacterName = actor.characterName();
            originalCharacterIndex = actor.characterIndex();

            // 店用のキャラ画像に変更
            actor.setCharacterImage(shopCharacterName, shopCharacterIndex);
            $gamePlayer.refresh();
        }
    };

    Scene_Shop.prototype.restorePlayerCharacter = function() {
        const actor = $gameActors.actor(1); // アクター1を取得
        if (actor && originalCharacterName !== null && originalCharacterIndex !== null) {
            // 元のキャラ画像に戻す
            actor.setCharacterImage(originalCharacterName, originalCharacterIndex);
            $gamePlayer.refresh();
        }
    };
})();
