/*:
 * @target MZ
 * @plugindesc Enables a skill to trigger another skill after its use.
 * @author スタジオVR
 *
 * @help
 * This plugin allows a skill to automatically trigger another skill.
 * Use the <ContinuousSkill:ID> note tag in a skill's note box to specify the ID
 * of the skill that should be triggered after it.
 *
 * Example:
 * <ContinuousSkill:250> in a skill's note will trigger skill with ID 250.
 */

(() => {
    const pluginName = 'ContinuousSkillTrigger';

    // Extend Game_Battler to handle continuous skills
    Game_Battler.prototype.addContinuousSkill = function(skillId) {
        this._continuousSkills = this._continuousSkills || [];
        this._continuousSkills.push(skillId);
    };

    Game_Battler.prototype.executeContinuousSkills = function() {
        if (!this._continuousSkills || this._continuousSkills.length === 0) return;

        while (this._continuousSkills.length > 0) {
            const skillId = this._continuousSkills.shift();
            const action = new Game_Action(this);
            action.setSkill(skillId);
            action.apply(this.opponentsUnit().randomTarget());
            BattleManager._logWindow.displayActionResults(this, action);
        }
    };

    // Overriding Game_Battler's onActionEnd to execute continuous skills
    const _Game_Battler_onActionEnd = Game_Battler.prototype.onActionEnd;
    Game_Battler.prototype.onActionEnd = function() {
        _Game_Battler_onActionEnd.call(this);
        this.executeContinuousSkills();
    };

    // Overriding apply method of Game_Action
    const _Game_Action_apply = Game_Action.prototype.apply;
    Game_Action.prototype.apply = function(target) {
        _Game_Action_apply.call(this, target);

        if (this.isSkill() && this.item().meta.ContinuousSkill) {
            const skillId = Number(this.item().meta.ContinuousSkill);
            if ($dataSkills[skillId]) {
                this.subject().addContinuousSkill(skillId);
            }
        }
    };
})();