/*:
 * @plugindesc [Ver1.0.0] メッセージカウントダウン位置制御プラグイン
 * @author スタジオVR
 * @target MZ
 * @base Svr_MessageCountdown
 * 
 * @param CountdownStartValue
 * @text カウントダウン開始の値
 * @type number
 * @min 1
 * @default 5
 * @desc 文章表示コマンドを上に移動させる数
 *
 * @command setCountdownPosition
 * @text カウントダウン位置特定開始
 * @desc イベント内のコマンド位置を特定し、カウントダウンの位置を設定します
 */

(() => {
    'use strict';
    const pluginName = "Svr_CountdownPosition";
    const parameters = PluginManager.parameters(pluginName);
    const countdownStartValue = Number(parameters.CountdownStartValue || 5);

    PluginManager.registerCommand(pluginName, "setCountdownPosition", args => {
        const interpreter = $gameMap._interpreter;
        if (!interpreter) return;

        let currentInterpreter = interpreter;
        while (currentInterpreter._childInterpreter) {
            currentInterpreter = currentInterpreter._childInterpreter;
        }

        const list = currentInterpreter._list;
        if (!list) return;

        removeCommonEvent(list, 478);

        const commonEvent402Index = findCommonEventIndex(list, 402);
        if (commonEvent402Index === -1) return;

        const messageCommandIndex = findMessageCommandIndex(list, commonEvent402Index, countdownStartValue);
        insertCommonEvent478(list, messageCommandIndex);
    });

    function removeCommonEvent(list, commonEventId) {
        let count = 0;
        for (let i = list.length - 1; i >= 0; i--) {
            if (list[i] && list[i].code === 117 && 
                list[i].parameters[0] === commonEventId) {
                list.splice(i, 1);
                count++;
            }
        }
        return count;
    }

    function findCommonEventIndex(list, commonEventId) {
        for (let i = 0; i < list.length; i++) {
            if (list[i] && list[i].code === 117 && 
                list[i].parameters[0] === commonEventId) {
                return i;
            }
        }
        return -1;
    }

    function findMessageCommandIndex(list, startIndex, moveCount) {
        let currentIndex = startIndex;
        let foundCommands = 0;

        while (currentIndex >= 0 && foundCommands < moveCount) {
            if (list[currentIndex] && list[currentIndex].code === 101) {
                foundCommands++;
                if (foundCommands === moveCount) {
                    return currentIndex;
                }
            }
            currentIndex--;
        }
        return startIndex;
    }

    function insertCommonEvent478(list, position) {
        const commonEventCommand = {
            code: 117,
            indent: 0,
            parameters: [478]
        };
        list.splice(position, 0, commonEventCommand);
    }
})();