/*:
 * @target MZ
 * @plugindesc メッセージウィンドウのフォントサイズを常にプラグインパラメータで指定した値に設定します。
 * @author スタジオVR
 * @help メッセージウィンドウのフォントサイズをプラグインパラメータで指定した値にします。
 *
 * @param fontSizeVariable
 * @text フォントサイズ変数ID
 * @desc メッセージウィンドウのフォントサイズを指定する変数のID。
 * @default 1
 * @type variable
 */

(() => {
    const parameters = PluginManager.parameters('CustomMessageFontSize');
    const fontSizeVariableId = Number(parameters['fontSizeVariable'] || 1);

    const getCustomFontSize = () => {
        return $gameVariables.value(fontSizeVariableId) || 30;
    };

    const _Window_Message_resetFontSettings = Window_Message.prototype.resetFontSettings;
    Window_Message.prototype.resetFontSettings = function() {
        _Window_Message_resetFontSettings.call(this);
        this.contents.fontSize = getCustomFontSize();
    };

    const _Window_Base_drawTextEx = Window_Base.prototype.drawTextEx;
    Window_Base.prototype.drawTextEx = function(text, x, y, width) {
        const originalFontSize = this.contents.fontSize;
        this.contents.fontSize = getCustomFontSize();
        const value = _Window_Base_drawTextEx.call(this, text, x, y, width);
        this.contents.fontSize = originalFontSize;
        return value;
    };
})();
