/*:
 * @target MZ
 * @plugindesc 全体攻撃・回復時の平均値表示（作成中）
 * @author Claude
 */

(() => {
    let damageTotal = 0;
    let healTotal = 0;
    let drainTotal = 0;
    let targetCount = 0;
    let isMultiTarget = false;

    // アクション開始時の処理
    const _BattleManager_startAction = BattleManager.startAction;
    BattleManager.startAction = function() {
        damageTotal = 0;
        healTotal = 0;
        drainTotal = 0;
        targetCount = 0;
        
        const action = this._subject.currentAction();
        if (action && action.item()) {
            const scope = action.item().scope;
            isMultiTarget = [2, 4, 5, 6].includes(scope);
        } else {
            isMultiTarget = false;
        }
        
        _BattleManager_startAction.call(this);
    };

    // ダメージ表示の処理
    const _Window_BattleLog_displayHpDamage = Window_BattleLog.prototype.displayHpDamage;
    Window_BattleLog.prototype.displayHpDamage = function(target) {
        _Window_BattleLog_displayHpDamage.call(this, target);
        
        if (isMultiTarget) {
            const result = target.result();
            if (result.hpDamage > 0) {
                damageTotal += result.hpDamage;
                targetCount++;
            } else if (result.hpDamage < 0) {
                healTotal += Math.abs(result.hpDamage);
                targetCount++;
            }
            if (result.drain) {
                drainTotal += result.hpDamage;
            }
        }
    };

    // アクション完了時の処理
    const _BattleManager_endAction = BattleManager.endAction;
    BattleManager.endAction = function() {
        if (isMultiTarget && targetCount > 0) {
            const logWindow = this._logWindow;
            
            if (damageTotal > 0) {
                const average = Math.floor(damageTotal / targetCount);
                const target = this._targets[0];
                const message = target.isEnemy() ? 
                    `敵に平均${average}のダメージを与えた！` :
                    `平均${average}のダメージを受けた！`;
                logWindow.push('addText', message);
            } else if (healTotal > 0) {
                const average = Math.floor(healTotal / targetCount);
                const target = this._targets[0];
                const message = target.isEnemy() ? 
                    `敵の HPが平均${average}回復した！` :
                    `HPが平均${average}回復した！`;
                logWindow.push('addText', message);
            }
            
            if (drainTotal > 0) {
                const average = Math.floor(drainTotal / targetCount);
                logWindow.push('addText', `HPを平均${average}奪った！`);
            }
        }
        
        _BattleManager_endAction.call(this);
    };
})();
