/*:
* @plugindesc 敵のスキル使用時に敵IDとスキルIDを変数に格納するプラグイン
* @author スタジオVR
*
* @param Enemy Variable ID
* @desc 敵IDを格納する変数のID
* @type number
* @default 1131
*
* @param Skill Variable ID
* @desc スキルIDを格納する変数のID
* @type number
* @default 1132
*
* @help
* このプラグインは、敵がスキルを使用したときに敵のIDとスキルIDを指定された変数に格納します。
*/

(function() {
    var parameters = PluginManager.parameters('Svr_EnemySkillWatch');
    var enemyVariableId = Number(parameters['Enemy Variable ID'] || 1131);
    var skillVariableId = Number(parameters['Skill Variable ID'] || 1132);

    var _Game_Enemy_useItem = Game_Enemy.prototype.useItem;
    Game_Enemy.prototype.useItem = function(item) {
        _Game_Enemy_useItem.call(this, item);
        if (DataManager.isSkill(item)) {
            $gameVariables.setValue(enemyVariableId, this._enemyId);
            $gameVariables.setValue(skillVariableId, item.id);
        }
    };
})();
