/*:
 * @target MZ
 * @plugindesc Changes the enemy transformation animation to fade out, transform, and fade in. Author: スタジオVR
 * @author スタジオVR
 * 
 * @param FadeOutDuration
 * @text フェードアウトの時間
 * @type number
 * @min 1
 * @default 30
 * @desc 敵キャラのフェードアウトにかかるフレーム数
 * 
 * @param FadeInDuration
 * @text フェードインの時間
 * @type number
 * @min 1
 * @default 30
 * @desc 敵キャラのフェードインにかかるフレーム数
 * 
 * @param WaitDuration
 * @text 待機時間
 * @type number
 * @min 0
 * @default 20
 * @desc フェードアウトとフェードインの間の待機時間（フレーム数）
 * 
 * @help
 * 敵キャラの変身時、フェードアウトとフェードインを行うようにします。
 */

(() => {
    const parameters = PluginManager.parameters('YourPluginName');
    const fadeOutDuration = Number(parameters['FadeOutDuration'] || 30);
    const fadeInDuration = Number(parameters['FadeInDuration'] || 30);
    const waitDuration = Number(parameters['WaitDuration'] || 20);

    const _Game_Enemy_transform = Game_Enemy.prototype.transform;
    Game_Enemy.prototype.transform = function(enemyId) {
        const sprite = this.battlerSprite();
        if (sprite) {
            const fadeOut = () => {
                let opacity = 255;
                const interval = setInterval(() => {
                    opacity -= 255 / fadeOutDuration;
                    sprite.opacity = opacity;
                    if (opacity <= 0) {
                        clearInterval(interval);
                        this.performTransform(enemyId, fadeIn);
                    }
                }, 1000 / 60);
            };

            const fadeIn = () => {
                let opacity = 0;
                const interval = setInterval(() => {
                    opacity += 255 / fadeInDuration;
                    sprite.opacity = opacity;
                    if (opacity >= 255) {
                        clearInterval(interval);
                    }
                }, 1000 / 60);
            };

            fadeOut();
        } else {
            this.performTransform(enemyId);
        }
    };

    Game_Enemy.prototype.performTransform = function(enemyId, callback) {
        _Game_Enemy_transform.call(this, enemyId);
        if (callback) {
            setTimeout(callback, 1000 / 60 * waitDuration);
        }
    };

    Game_Enemy.prototype.battlerSprite = function() {
        const sprite = SceneManager._scene._spriteset._enemySprites.find(sprite => sprite._enemy === this);
        return sprite;
    };
})();
