/*:
 * @target MZ
 * @plugindesc 最後にセーブしたスロットを記録して表示します。
 * @author Modified version
 * @help
 * このプラグインは、最後にセーブしたスロット番号を記録します。
 */

(() => {
    const STORAGE_KEY = "Svr_LastSaveSlot";

    const saveLastSlot = (savefileId) => {
        if (savefileId === 0) return;
        localStorage.setItem(STORAGE_KEY, String(savefileId));
        if ($gameSystem) {
            $gameSystem._lastSaveSlot = savefileId;
        }
    };

    const loadLastSlot = () => {
        const slot = localStorage.getItem(STORAGE_KEY);
        return slot ? Number(slot) : 0;
    };

    const _DataManager_saveGame = DataManager.saveGame;
    DataManager.saveGame = function(savefileId) {
        const result = _DataManager_saveGame.call(this, savefileId);
        if (result) {
            saveLastSlot(savefileId);
        }
        return result;
    };

    const _Game_System_initialize = Game_System.prototype.initialize;
    Game_System.prototype.initialize = function() {
        _Game_System_initialize.call(this);
        this._lastSaveSlot = loadLastSlot();
    };

    Game_System.prototype.lastSaveSlot = function() {
        return this._lastSaveSlot || loadLastSlot();
    };
})();