/*=============================================================================
 Svr_MousePointerErase.js
----------------------------------------------------------------------------
 Version
 1.2.0 2024/12/03 スイッチ292による機能制御を追加
 1.1.1 2024/11/30 タイトル画面でエラーが発生する不具合を修正
 1.1.0 2024/11/30 マウス非アクティブタイマー機能を追加
 1.0.0 2022/10/02 初版
----------------------------------------------------------------------------
=============================================================================*/

/*:
 * @plugindesc マウスポインタ消去プラグイン
 * @target MZ
 * @author Svr
 *
 * @help Svr_MousePointerErase.js
 *　
 * ゲームウィンドウ内にマウスポインタが存在するとき
 * キーボードやパッドの入力を検知するとマウスポインタが非表示になります。
 * マウスポインタを動かすと再表示されます。
 * 
 * また、変数272に設定された秒数の間マウスが動かない場合、
 * 自動的にマウスポインタが非表示になります。
 * 
 * スイッチ292がONの時のみ、この機能が有効になります。
 */

 (() => {
    'use strict';

    let _lastMouseMoveTime = Date.now();
    
    const _Input_update = Input.update;
    Input.update = function() {
        const oldDate = this.date;
        _Input_update.apply(this, arguments);

        // スイッチ292の状態をチェック
        if ($gameSwitches && typeof $gameSwitches.value === 'function' && $gameSwitches.value(292)) {
            if (this.date !== oldDate) {
                Graphics.setHiddenPointer(true);
            }
            
            // マウス非アクティブタイマーのチェック
            if ($gameVariables && typeof $gameVariables.value === 'function') {
                const inactiveSeconds = $gameVariables.value(272);
                if (inactiveSeconds > 0) {
                    const currentTime = Date.now();
                    const elapsedTime = (currentTime - _lastMouseMoveTime) / 1000;
                    if (elapsedTime >= inactiveSeconds) {
                        Graphics.setHiddenPointer(true);
                    }
                }
            }
        } else {
            // スイッチがOFFの場合は常にポインタを表示
            Graphics.setHiddenPointer(false);
        }
    };

    const _TouchInput__onMouseMove = TouchInput._onMouseMove;
    TouchInput._onMouseMove = function(event) {
        _TouchInput__onMouseMove.apply(this, arguments);
        // スイッチ292の状態をチェック
        if ($gameSwitches && typeof $gameSwitches.value === 'function' && $gameSwitches.value(292)) {
            Graphics.setHiddenPointer(false);
            _lastMouseMoveTime = Date.now();
        }
    };

    Graphics.setHiddenPointer = function(value) {
        document.body.style.cursor = value ? 'none' : '';
    };
})();