/*:
 * @plugindesc メッセージウィンドウの開閉演出と全ての遅延をなくし、完全に即時表示・非表示にします。選択肢ウィンドウは通常通り表示します。
 * @author スタジオVR
 * @target MZ
 * @url 
 *
 * @help Svr_NoWindowTransitionDelay.js
 *
 * このプラグインは、メッセージウィンドウの開閉時のアニメーション演出と
 * あらゆる遅延を完全に無効化し、ウィンドウが一切の遅延なく
 * 即座に開き、即座に閉じるようにします。
 * 
 * ただし、選択肢ウィンドウ(Window_ChoiceList)は通常通りのアニメーション表示を
 * 維持します。
 * 
 * 使用方法:
 * プラグインを導入するだけで機能します。設定は必要ありません。
 * 
 * 利用規約:
 * クレジット表記は不要です。
 * 商用・非商用ともに自由にお使いください。
 * 
 */

(function() {
    'use strict';
    
    //=============================================================================
    // Window_Message - メッセージウィンドウの完全即時表示/非表示化
    //=============================================================================
    
    // ウィンドウの開閉を即時化するためのオーバーライド
    Window_Message.prototype.updateOpen = function() {
        if (this._opening) {
            this.openness = 255; // 即時に完全に開く
            this._opening = false;
        }
    };
    
    Window_Message.prototype.updateClose = function() {
        if (this._closing) {
            this.openness = 0; // 即時に完全に閉じる
            this._closing = false;
        }
    };
    
    // ウィンドウの開閉速度を最大にする
    const _Window_Message_initialize = Window_Message.prototype.initialize;
    Window_Message.prototype.initialize = function(rect) {
        _Window_Message_initialize.call(this, rect);
        this._openingSpeed = 255; // 開く速度を最大に
        this._closingSpeed = 255; // 閉じる速度を最大に
    };
    
    // open関数のオーバーライド
    const _Window_Message_open = Window_Message.prototype.open;
    Window_Message.prototype.open = function() {
        _Window_Message_open.call(this);
        this.openness = 255; // 即座に完全に開く
    };
    
    // isEndOfText関数を維持して正常に処理できるようにする
    const _Window_Message_isEndOfText = Window_Message.prototype.isEndOfText;
    Window_Message.prototype.isEndOfText = function(textState) {
        return _Window_Message_isEndOfText.call(this, textState);
    };
    
    // startWait関数を調整して最低限の待機は残す
    const _Window_Message_startWait = Window_Message.prototype.startWait;
    Window_Message.prototype.startWait = function(count) {
        // 完全にゼロにすると問題が起きるので1に設定
        this._waitCount = 1;
    };
    
    //=============================================================================
    // Window_Base - 基本ウィンドウクラスの即時表示/非表示化（選択肢ウィンドウを除く）
    //=============================================================================
    
    // オリジナルのWindow_BaseのupdateOpen/updateClose関数を保存
    const _Window_Base_updateOpen = Window_Base.prototype.updateOpen;
    const _Window_Base_updateClose = Window_Base.prototype.updateClose;
    
    // 基本ウィンドウの開閉も即時化（選択肢ウィンドウを除く）
    Window_Base.prototype.updateOpen = function() {
        // Window_ChoiceListのインスタンスの場合は元の動作を維持
        if (this instanceof Window_ChoiceList) {
            _Window_Base_updateOpen.call(this);
        } else {
            if (this._opening) {
                this.openness = 255; // 即時に完全に開く
                this._opening = false;
            }
        }
    };
    
    Window_Base.prototype.updateClose = function() {
        // Window_ChoiceListのインスタンスの場合は元の動作を維持
        if (this instanceof Window_ChoiceList) {
            _Window_Base_updateClose.call(this);
        } else {
            if (this._closing) {
                this.openness = 0; // 即時に完全に閉じる
                this._closing = false;
            }
        }
    };
    
    // 名前ボックスウィンドウも対応
    if (typeof Window_NameBox !== 'undefined') {
        Window_NameBox.prototype.updateOpen = function() {
            if (this._opening) {
                this.openness = 255;
                this._opening = false;
            }
        };
        
        Window_NameBox.prototype.updateClose = function() {
            if (this._closing) {
                this.openness = 0;
                this._closing = false;
            }
        };
    }
    
})();