/*:
 * @plugindesc パーティーメンバー変更プラグイン
 * @author YourName
 *
 * @help
 * このプラグインは以下のプラグインコマンドを提供します：
 * 
 * ChangeParty 1 2 3 4 - 指定したIDのアクターでパーティーを構成します（1～4つのID）
 * RestoreParty - 変更前のパーティーメンバーに戻します
 *
 * @command ChangeParty
 * @text パーティー変更
 * @desc 指定したIDのアクターでパーティーを構成します
 *
 * @arg actorId1
 * @type actor
 * @text アクター1
 * @desc パーティーに加える1番目のアクターのID
 *
 * @arg actorId2
 * @type actor
 * @text アクター2
 * @desc パーティーに加える2番目のアクターのID
 *
 * @arg actorId3
 * @type actor
 * @text アクター3
 * @desc パーティーに加える3番目のアクターのID
 *
 * @arg actorId4
 * @type actor
 * @text アクター4
 * @desc パーティーに加える4番目のアクターのID
 *
 * @command RestoreParty
 * @text パーティー復帰
 * @desc 変更前のパーティーメンバーに戻します
 */

(function() {
    const pluginName = "Svr_PartyChange";
    
    let originalBattleMembers = [];
    
    PluginManager.registerCommand(pluginName, "ChangeParty", args => {
        // 戦闘参加メンバーのみ保存
        originalBattleMembers = $gameParty.battleMembers().map(actor => actor.actorId());
        
        const newPartyIds = [
            Number(args.actorId1),
            Number(args.actorId2),
            Number(args.actorId3),
            Number(args.actorId4)
        ].filter(id => id > 0);
        
        // 現在の戦闘参加メンバーのみを外す
        $gameParty.battleMembers().slice().forEach(actor => {
            $gameParty.removeActor(actor.actorId());
        });
        
        // 新しいメンバーを追加
        newPartyIds.forEach(id => {
            $gameParty.addActor(id);
        });
    });
    
    PluginManager.registerCommand(pluginName, "RestoreParty", args => {
        if (originalBattleMembers.length > 0) {
            // 現在の戦闘参加メンバーのみを外す
            $gameParty.battleMembers().slice().forEach(actor => {
                $gameParty.removeActor(actor.actorId());
            });
            
            // 元の戦闘参加メンバーを追加
            originalBattleMembers.forEach(id => {
                $gameParty.addActor(id);
            });
            
            originalBattleMembers = [];
        }
    });
})();