//=============================================================================
// Svr_SaveCore_FloatGlobal.js
//=============================================================================

/*:ja
 * @target MZ
 * @plugindesc SaveCoreのグローバル変数で小数点を使用可能にします。
 * @author スタジオVR
 * @base VisuMZ_1_SaveCore
 * @orderAfter VisuMZ_1_SaveCore
 */

(() => {
    'use strict';

    const _Game_Variables_initialize = Game_Variables.prototype.initialize;
    const _Game_Variables_setValue = Game_Variables.prototype.setValue;
    const _Game_Variables_value = Game_Variables.prototype.value;
    
    Game_Variables.prototype.initialize = function() {
        _Game_Variables_initialize.call(this);
        this._floatData = {};
    };

    Game_Variables.prototype.setValue = function(variableId, value) {
        if (this.isGlobalVariable(variableId)) {
            if (typeof value === 'number') {
                const floatValue = Math.round(value * 10000) / 10000;
                this._floatData[variableId] = floatValue;
                _Game_Variables_setValue.call(this, variableId, floatValue);
                return;
            }
        }
        _Game_Variables_setValue.call(this, variableId, value);
    };

    Game_Variables.prototype.value = function(variableId) {
        if (this.isGlobalVariable(variableId)) {
            return this._floatData[variableId] !== undefined ? 
                   this._floatData[variableId] : 
                   _Game_Variables_value.call(this, variableId);
        }
        return _Game_Variables_value.call(this, variableId);
    };

    Game_Variables.prototype.isGlobalVariable = function(variableId) {
        if (!$dataSystem || !$dataSystem.variables || !$dataSystem.variables[variableId]) {
            return false;
        }
        return String($dataSystem.variables[variableId]).includes('<Global>');
    };

    const _DataManager_createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function() {
        _DataManager_createGameObjects.call(this);
        $gameVariables._floatData = $gameVariables._floatData || {};
    };

    const _DataManager_extractSaveContents = DataManager.extractSaveContents;
    DataManager.extractSaveContents = function(contents) {
        _DataManager_extractSaveContents.call(this, contents);
        $gameVariables._floatData = $gameVariables._floatData || {};
    };
})();