/*:
 * @plugindesc プレイヤー側のアクターがスキルを使用した際に、変数に値を設定できます。
 * @target MZ
 *
 * @param Variables
 * @type struct<Variable>[]
 * @text 変数IDとメタタグ名
 * @desc 変数IDとメタタグ名を設定します。
 *
 * @help
 * このプラグインでは、プレイヤー側のアクターがスキルを使用した際に、
 * 変数に値を設定できます。
 * <SetVariable:変数に設定する値>
 * 上記のメタタグをスキルに設定してください。
 *
 * @command setVariable
 * @text 変数設定
 * @desc 変数に値を設定します。
 *
 */
/*~struct~Variable:
 * @param variableId
 * @type variable
 * @text 格納する変数ID
 * @desc 格納する変数ID
 * @default 1
 *
 * @param setVariableTag
 * @text スキルに設定するメタタグ名
 * @desc スキルに設定するメタタグ名
 * @default SetVariable
 * @type text
 */

(() => {
  const pluginName = 'Svr_SkillSetVariables';
  const pluginParams = PluginManager.parameters(pluginName);
  const variables = JSON.parse(pluginParams['Variables'] || '[]').map(param => JSON.parse(param));

  const _Game_Action_apply = Game_Action.prototype.apply;
  Game_Action.prototype.apply = function(target) {
    const skill = this.item();
    variables.forEach((variable) => {
      const { variableId, setVariableTag } = variable;
      const variableMetaTag = skill.meta[setVariableTag];
      if (variableMetaTag !== undefined) {
        const [value] = variableMetaTag.split(':').map(str => parseInt(str));
        if (!isNaN(value)) {
          $gameVariables.setValue(variableId, value);
        }
      }
    });
    _Game_Action_apply.apply(this, arguments);
  };
})();