/*:
 * @target MZ
 * @plugindesc スキル画面でスキルタイプを並び替え、アイコンを設定できるプラグイン
 * @author スタジオVR
 * @help
 * このプラグインを使用すると、スキル画面でスキルタイプの並び順とアイコンをカスタマイズできます。
 *
 * @param SkillTypeIcons
 * @text スキルタイプのアイコンと並び順
 * @type struct<SkillTypeIcon>[]
 * @default []
 * @desc 各スキルタイプに対してアイコンと並び順を設定します。
 *
 * @param MaxSkillTypeId
 * @text 最大スキルタイプID
 * @type number
 * @desc 適用する最大スキルタイプIDを指定します。
 */

/*~struct~SkillTypeIcon:
 * @param SkillTypeId
 * @text スキルタイプID
 * @type number
 * @desc スキルタイプのIDを指定します。
 *
 * @param IconIndex
 * @text アイコンインデックス
 * @type number
 * @desc アイコンセット内のインデックスを指定します。
 */

(() => {
    const parameters = PluginManager.parameters('Svr_SkillTypeOrder'); // プラグイン名を変更
    const skillTypeIcons = JSON.parse(parameters['SkillTypeIcons']).map(item => JSON.parse(item));
    
    // 追加: プラグインパラメータから最大スキルタイプIDを取得
    const maxSkillTypeId = Number(parameters['MaxSkillTypeId']) || null;

    Window_SkillType.prototype.makeCommandList = function() {
        if (this._actor) {
            const skillTypes = this._actor.addedSkillTypes();
            const sortedSkillTypes = skillTypeIcons
                .filter(iconInfo => skillTypes.includes(Number(iconInfo.SkillTypeId)) && 
                    (maxSkillTypeId === null || Number(iconInfo.SkillTypeId) <= maxSkillTypeId))
                .sort((a, b) => skillTypes.indexOf(Number(a.SkillTypeId)) - skillTypes.indexOf(Number(b.SkillTypeId)));

            sortedSkillTypes.forEach(iconInfo => {
                const stypeId = Number(iconInfo.SkillTypeId);
                const name = $dataSystem.skillTypes[stypeId];
                const iconIndex = Number(iconInfo.IconIndex);
                this.addCommand(name, 'skill', true, stypeId, iconIndex);
            });

            // 追加: maxSkillTypeId以上のスキルタイプIDを全て追加
            const extraSkillTypes = skillTypes.filter(stypeId => stypeId > maxSkillTypeId);
            extraSkillTypes.forEach(stypeId => {
                const name = $dataSystem.skillTypes[stypeId];
                this.addCommand(name, 'skill', true, stypeId);
            });
        }
    };

    Window_SkillType.prototype.drawItem = function(index) {
        const rect = this.itemLineRect(index);
        const align = this.itemTextAlign();
        this.resetTextColor();
        this.changePaintOpacity(this.isCommandEnabled(index));
        const stypeId = this.commandExt(index);
        const iconInfo = skillTypeIcons.find(icon => Number(icon.SkillTypeId) === stypeId);
        const iconIndex = iconInfo ? Number(iconInfo.IconIndex) : 0;
        if (iconIndex) {
            const iconWidth = ImageManager.iconWidth;
            const iconHeight = ImageManager.iconHeight;
            this.drawIcon(iconIndex, rect.x, rect.y + (rect.height - iconHeight) / 2);
            rect.x += iconWidth + 4;
            rect.width -= iconWidth + 4;
        }
        this.drawText(this.commandName(index), rect.x, rect.y, rect.width, align);
    };

    Window_Command.prototype.commandExt = function(index) {
        return this._list[index].ext;
    };
})();
