//=============================================================================
// VisuStella MZ - Battle Core
// VisuMZ_1_BattleCore.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_1_BattleCore = true;

var VisuMZ = VisuMZ || {};
VisuMZ.BattleCore = VisuMZ.BattleCore || {};
VisuMZ.BattleCore.version = 1.83;

//=============================================================================
/* ----------------------------------------------------------------------------
 * Auto Battle Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~AutoBattle:
 *
 * @param BattleDisplay
 * @text Battle Display
 *
 * @param AutoBattleMsg:str
 * @text Message
 * @parent BattleDisplay
 * @desc Message that's displayed when Auto Battle is on.
 * Text codes allowed. %1 - OK button, %2 - Cancel button
 * @default Press %1 or %2 to stop Auto Battle
 *
 * @param AutoBattleOK:str
 * @text OK Button
 * @parent BattleDisplay
 * @desc Text used to represent the OK button.
 * If VisuMZ_0_CoreEngine is present, ignore this.
 * @default OK
 *
 * @param AutoBattleCancel:str
 * @text Cancel Button
 * @parent BattleDisplay
 * @desc Text used to represent the Cancel button.
 * If VisuMZ_0_CoreEngine is present, ignore this.
 * @default Cancel
 *
 * @param AutoBattleBgType:num
 * @text Background Type
 * @parent BattleDisplay
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for Auto Battle window.
 * @default 1
 *
 * @param AutoBattleRect:func
 * @text JS: X, Y, W, H
 * @parent BattleDisplay
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const width = Graphics.width;\nconst height = this.calcWindowHeight(1, false);\nconst x = 0;\nconst y = (Graphics.height - height) / 2;\nreturn new Rectangle(x, y, width, height);"
 *
 * @param Options
 *
 * @param AddOption:eval
 * @text Add Option?
 * @parent Options
 * @type boolean
 * @on Add
 * @off Don't Add
 * @desc Add the Auto Battle options to the Options menu?
 * @default true
 *
 * @param AdjustRect:eval
 * @text Adjust Window Height
 * @parent Options
 * @type boolean
 * @on Adjust
 * @off Don't
 * @desc Automatically adjust the options window height?
 * @default true
 *
 * @param StartName:str
 * @text Startup Name
 * @parent Options
 * @desc Command name of the option.
 * @default Auto Battle Start
 *
 * @param StyleName:str
 * @text Style Name
 * @parent Options
 * @desc Command name of the option.
 * @default Auto Battle Style
 *
 * @param StyleOFF:str
 * @text OFF
 * @parent StyleName:str
 * @desc Text displayed when Auto Battle Style is OFF.
 * @default Attack
 *
 * @param StyleON:str
 * @text ON
 * @parent StyleName:str
 * @desc Text displayed when Auto Battle Style is ON.
 * @default Skills
 *
 */
/* ----------------------------------------------------------------------------
 * Damage Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Damage:
 *
 * @param DamageStyles
 * @text Damage Styles
 *
 * @param DefaultDamageStyle:str
 * @text Default Style
 * @parent DamageStyles
 * @desc Which Damage Style do you want to set as default?
 * Use 'Manual' to not use any styles at all.
 * @default Standard
 *
 * @param DamageStyleList:arraystruct
 * @text Style List
 * @parent DamageStyles
 * @type struct<DamageStyle>[]
 * @desc A list of the damage styles available.
 * These are used to calculate base damage.
 * @default ["{\"Name:str\":\"Standard\",\"Formula:func\":\"\\\"// Declare Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Replace Formula\\\\nlet formula = item.damage.formula;\\\\nif (SceneManager.isSceneBattle() && !this.isCertainHit()) {\\\\n    const fmt = 'Math.max(this.applyArmorModifiers(b, %1), 0)';\\\\n    formula = formula.replace(/b.def/g, fmt.format('b.def'));\\\\n    formula = formula.replace(/b.mdf/g, fmt.format('b.mdf'));\\\\n    formula = formula.replace(/b.agi/g, fmt.format('b.agi'));\\\\n    formula = formula.replace(/b.luk/g, fmt.format('b.luk'));\\\\n}\\\\n\\\\n// Calculate Damage\\\\nlet value = Math.max(eval(formula), 0);\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"return this.getItemDamageAmountTextOriginal();\\\"\"}","{\"Name:str\":\"Armor Scaling\",\"Formula:func\":\"\\\"// Declare Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Replace Formula\\\\nlet formula = item.damage.formula;\\\\nif (SceneManager.isSceneBattle() && !this.isCertainHit()) {\\\\n    const fmt = 'Math.max(this.applyArmorModifiers(b, %1), 1)';\\\\n    formula = formula.replace(/b.def/g, fmt.format('b.def'));\\\\n    formula = formula.replace(/b.mdf/g, fmt.format('b.mdf'));\\\\n    formula = formula.replace(/b.agi/g, fmt.format('b.agi'));\\\\n    formula = formula.replace(/b.luk/g, fmt.format('b.luk'));\\\\n}\\\\n\\\\n// Calculate Damage\\\\nlet value = Math.max(eval(formula), 0);\\\\n\\\\n// Apply Defender's Defense Parameter\\\\nif (this.isDamage() && !this.isCertainHit()) {\\\\n\\\\n    // Calculate Base Armor\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\n    armor = this.applyArmorModifiers(target, armor);\\\\n\\\\n    // Apply Armor to Damage\\\\n    if (armor >= 0) {\\\\n        value *= 100 / (100 + armor);\\\\n    } else {\\\\n        value *= 2 - (100 / (100 - armor));\\\\n    }\\\\n}\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"return this.getItemDamageAmountTextOriginal();\\\"\"}","{\"Name:str\":\"CT\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Multiplier\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Values\\\\nlet value = 0;\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = Math.max(this.applyArmorModifiers(target, armor), 0);\\\\nlet attackStat = 0;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    attackStat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    attackStat =  a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    attackStat =  a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    attackStat =  a.mdf;\\\\n}\\\\n\\\\n// Calculate Damage\\\\nattackStat = (attackStat * 1.75) + (level ** 2 / 45.5);\\\\nvalue = attackStat * 4;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value *= Math.max(256 - armor, 0) / 256;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value *= Math.max(102.4 - armor, 0) / 128;\\\\n}\\\\nvalue *= multiplier;\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"D4\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Multiplier\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Values\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(target, armor);\\\\nlet stat = 0;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    stat = a.def;\\\\n    armor = 0;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    stat = a.mdf;\\\\n    armor = 0;\\\\n}\\\\n\\\\n// Calculate Damage \\\\nlet value = 1.5 * Math.max(2 * stat * multiplier - armor, 1) * multiplier / 5;\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"DQ\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Multiplier\\\\nlet multiplier = Math.max(eval(item.damage.formula), 0);\\\\nif (this.isCertainHit()) {\\\\n    let value = multiplier * Math.max(a.atk, a.mat);\\\\n    return (isNaN(value) ? 0 : value) * sign;\\\\n}\\\\n\\\\n// Get Primary Stats\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(b, armor);\\\\nlet stat = 1;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    stat = a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    stat = a.mdf;\\\\n}\\\\n\\\\n// Check for Recovery\\\\nif (this.isRecover()) {\\\\n    let value = stat * multiplier * sign;\\\\n    return isNaN(value) ? 0 : value;\\\\n}\\\\n\\\\n// Calculate Damage\\\\nlet value = 0;\\\\nif (stat < ((2 + armor) / 2)) {\\\\n    // Plink Damage\\\\n    let baseline = Math.max(stat - ((12 * (armor - stat + 1)) / stat), 5);\\\\n    value = baseline / 3;\\\\n} else {\\\\n    // Normal Damage\\\\n    let baseline = Math.max(stat - (armor / 2), 1);\\\\n    value = baseline / 2;\\\\n}\\\\nvalue *= multiplier;\\\\n\\\\n// Return Value\\\\nreturn isNaN(value) ? 0 : value;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"FF7\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Power\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare base Damage\\\\nlet baseDamage = 0;\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    baseDamage = a.atk + ((a.atk + level) / 32) * ((a.atk * level) / 32);\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    baseDamage = 6 * (a.mat + level);\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    baseDamage = 6 * (a.def + level);\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    baseDamage = 6 * (a.mdf + level);\\\\n}\\\\n\\\\n// Calculate Final Damage\\\\nlet value = baseDamage;\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(target, armor);\\\\nif (this.isRecover()) {\\\\n    value += 22 * power;\\\\n} else {\\\\n    value = (power * Math.max(512 - armor, 1) * baseDamage) / (16 * 512);\\\\n}\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"FF8\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Power\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Damage\\\\nlet Value = 0;\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(target, armor);\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value = a.atk ** 2 / 16 + a.atk;\\\\n    value *= Math.max(265 - armor, 1) / 256;\\\\n    value *= power / 16;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value = a.mat + power;\\\\n    value *= Math.max(265 - armor, 1) / 4;\\\\n    value *= power / 256;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    value = (power + a.def) * power / 2;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    value = (power + a.mdf) * power / 2;\\\\n}\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"FF9\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Damage Constant\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\nif (this.isCertainHit()) {\\\\n    return (isNaN(power) ? 0 : power) * sign;\\\\n}\\\\n\\\\n// Declare Main Stats\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(b, armor);\\\\nlet stat = 1;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    stat = a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    stat = a.mdf;\\\\n}\\\\n\\\\n// Declare Base Damage\\\\nlet baseDamage = power;\\\\nif (this.isPhysical()) {\\\\n    baseDamage += stat;\\\\n}\\\\nif (this.isDamage() || this.isDrain()) {\\\\n    baseDamage -= armor;\\\\n    baseDamage = Math.max(1, baseDamage);\\\\n}\\\\n\\\\n// Declare Bonus Damage\\\\nlet bonusDamage = stat + (((a.level || a.luk) + stat) / 8);\\\\n\\\\n// Declare Final Damage\\\\nlet value = baseDamage * bonusDamage * sign;\\\\n\\\\n// Return Value\\\\nreturn isNaN(value) ? 0 : value;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"FF10\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Damage Constant\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\nif (this.isCertainHit()) {\\\\n    return (isNaN(power) ? 0 : power) * sign;\\\\n}\\\\n\\\\n// Create Damage Offense Value\\\\nlet value = power;\\\\n\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value = (((a.atk ** 3) / 32) + 32) * power / 16;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value = power * ((a.mat ** 2 / 6) + power) / 4;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    value = power * ((a.def + power) / 2);\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    value = power * ((a.mdf + power) / 2);\\\\n}\\\\n\\\\n// Apply Damage Defense Value\\\\nif (this.isDamage() || this.isDrain()) {\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\n    armor = this.applyArmorModifiers(b, armor);\\\\n    armor = Math.max(armor, 1);\\\\n    value *= ((((armor - 280.4) ** 2) / 110) / 16) / 730;\\\\n    value *= (730 - (armor * 51 - (armor ** 2) / 11) / 10) / 730;\\\\n} else if (this.isRecover()) {\\\\n    value *= -1;\\\\n}\\\\n\\\\n// Return Value\\\\nreturn isNaN(value) ? 0 : value;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"MK\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Multiplier\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Values\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(target, armor);\\\\nconst denominator = Math.max(200 + armor, 1);\\\\n\\\\n// Calculate Damage \\\\nlet value = 0;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value = 200 * a.atk / denominator;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value = 200 * a.mat / denominator;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    value = 200 * a.def / 200;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    value = 200 * a.mdf / 200;\\\\n}\\\\nvalue *= multiplier;\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"MOBA\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Damage Value\\\\nlet value = Math.max(eval(item.damage.formula), 0) * sign;\\\\n\\\\n// Apply Attacker's Offense Parameter\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value *= a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value *= a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    value *= a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    value *= a.mdf;\\\\n}\\\\n\\\\n// Apply Defender's Defense Parameter\\\\nif (this.isDamage() && !this.isCertainHit()) {\\\\n\\\\n    // Calculate Base Armor\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\n    armor = this.applyArmorModifiers(target, armor);\\\\n\\\\n    // Apply Armor to Damage\\\\n    if (armor >= 0) {\\\\n        value *= 100 / (100 + armor);\\\\n    } else {\\\\n        value *= 2 - (100 / (100 - armor));\\\\n    }\\\\n}\\\\n\\\\n// Return Value\\\\nreturn isNaN(value) ? 0 : value;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"PKMN\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Power\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Values\\\\nlet value = 0;\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = Math.max(this.applyArmorModifiers(target, armor), 0);\\\\nlet attackStat = 0;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    attackStat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    attackStat =  a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    attackStat =  a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    attackStat =  a.mdf;\\\\n}\\\\n\\\\n// Calculate Damage\\\\nvalue = (((((2 * level) / 5) + 2) * power * (attackStat / armor)) / 50) + 2;\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}"]
 *
 * @param Cap
 * @text Damage Cap
 *
 * @param EnableDamageCap:eval
 * @text Enable Damage Cap?
 * @parent Cap
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Put a maximum hard damage cap on how far damage can go?
 * This can be broken through the usage of notetags.
 * @default false
 *
 * @param DefaultHardCap:num
 * @text Default Hard Cap
 * @parent EnableDamageCap:eval
 * @type number
 * @min 1
 * @desc The default hard damage cap used before applying damage.
 * @default 9999
 *
 * @param EnableSoftCap:eval
 * @text Enable Soft Cap?
 * @parent Cap
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Soft caps ease in the damage values leading up to the 
 * hard damage cap. Requires hard Damage Cap enabled.
 * @default false
 *
 * @param DefaultSoftCap:num
 * @text Base Soft Cap Rate
 * @parent EnableSoftCap:eval
 * @desc The default soft damage cap used before applying damage.
 * @default 0.80
 *
 * @param DefaultSoftScaler:num
 * @text Soft Scale Constant
 * @parent EnableSoftCap:eval
 * @desc The default soft damage cap used before applying damage.
 * @default 0.1275
 *
 * @param Popups
 *
 * @param PopupDuration:num
 * @text Popup Duration
 * @parent Popups
 * @type number
 * @min 1
 * @desc Adjusts how many frames a popup stays visible.
 * @default 128
 *
 * @param NewPopupBottom:eval
 * @text Newest Popups Bottom
 * @parent Popups
 * @type boolean
 * @on Bottom
 * @off Top
 * @desc Puts the newest popups at the bottom.
 * @default true
 *
 * @param PopupPosition:str
 * @text Appear Position
 * @parent Popups
 * @type select
 * @option Head - At the top of the battler.
 * @value head
 * @option Center - At the center of the battler.
 * @value center
 * @option Base - At the foot of the battler.
 * @value base
 * @desc Selects where you want popups to appear relative to the battler.
 * @default base
 *
 * @param EndBattlePopups:eval
 * @text End Battle Show?
 * @parent Popups
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show or hide popups upon victory or escape?
 * Used to hide battle-state removal popups.
 * @default true
 *
 * @param PopupOffsetX:num
 * @text Offset X
 * @parent Popups
 * @desc Sets how much to offset the sprites by horizontally.
 * Negative values go left. Positive values go right.
 * @default 0
 *
 * @param PopupOffsetY:num
 * @text Offset Y
 * @parent Popups
 * @desc Sets how much to offset the sprites by vertically.
 * Negative values go up. Positive values go down.
 * @default 0
 *
 * @param PopupShiftX:num
 * @text Shift X
 * @parent Popups
 * @desc Sets how much to shift the sprites by horizontally.
 * Negative values go left. Positive values go right.
 * @default 8
 *
 * @param PopupShiftY:num
 * @text Shift Y
 * @parent Popups
 * @desc Sets how much to shift the sprites by vertically.
 * Negative values go up. Positive values go down.
 * @default -28
 *
 * @param hpDamageFmt:str
 * @text HP Damage Format
 * @parent Popups
 * @desc Determines HP damage format for popup.
 * %1 - Value, %2 - HP Text
 * @default -%1
 *
 * @param hpHealingFmt:str
 * @text HP Healing Format
 * @parent Popups
 * @desc Determines HP healing format for popup.
 * %1 - Value, %2 - HP Text
 * @default +%1
 *
 * @param mpDamageFmt:str
 * @text MP Damage Format
 * @parent Popups
 * @desc Determines MP damage format for popup.
 * %1 - Value, %2 - MP Text
 * @default -%1 %2
 *
 * @param mpHealingFmt:str
 * @text MP Healing Format
 * @parent Popups
 * @desc Determines MP healing format for popup.
 * %1 - Value, %2 - MP Text
 * @default +%1 %2
 *
 * @param CriticalColor:eval
 * @text Critical Flash Color
 * @parent Popups
 * @desc Adjust the popup's flash color.
 * Format: [red, green, blue, alpha]
 * @default [255, 0, 0, 160]
 *
 * @param CriticalDuration:num
 * @text Critical Duration
 * @parent Popups
 * @type number
 * @min 1
 * @desc Adjusts how many frames a the flash lasts.
 * @default 128
 *
 * @param Formulas
 *
 * @param OverallFormulaJS:func
 * @text JS: Overall Formula
 * @parent Formulas
 * @type note
 * @desc The overall formula used when calculating damage.
 * @default "// Declare Constants\nconst target = arguments[0];\nconst critical = arguments[1];\nconst item = this.item();\n\n// Get Base Damage\nconst baseValue = this.evalDamageFormula(target);\n\n// Calculate Element Modifiers\nlet value = baseValue * this.calcElementRate(target);\n\n// Calculate Physical and Magical Modifiers\nif (this.isPhysical()) {\n    value *= target.pdr;\n}\nif (this.isMagical()) {\n    value *= target.mdr;\n}\n\n// Apply Healing Modifiers\nif (baseValue < 0) {\n    value *= target.rec;\n}\n\n// Apply Critical Modifiers\nif (critical) {\n    value = this.applyCritical(value);\n}\n\n// Apply Variance and Guard Modifiers\nvalue = this.applyVariance(value, item.damage.variance);\nvalue = this.applyGuard(value, target);\n\n// Finalize Damage\nvalue = Math.round(value);\nreturn value;"
 *
 * @param VarianceFormulaJS:func
 * @text JS: Variance Formula
 * @parent Formulas
 * @type note
 * @desc The formula used when damage variance.
 * @default "// Declare Constants\nconst damage = arguments[0];\nconst variance = arguments[1];\n\n// Calculate Variance\nconst amp = Math.floor(Math.max((Math.abs(damage) * variance) / 100, 0));\nconst v = Math.randomInt(amp + 1) + Math.randomInt(amp + 1) - amp;\n\n// Return Damage\nreturn damage >= 0 ? damage + v : damage - v;"
 *
 * @param GuardFormulaJS:func
 * @text JS: Guard Formula
 * @parent Formulas
 * @type note
 * @desc The formula used when damage is guarded.
 * @default "// Declare Constants\nconst damage = arguments[0];\nconst target = arguments[1];\n\n// Return Damage Early\nconst note = this.item().note;\nif (note.match(/<UNBLOCKABLE>/i)) return damage;\nif (!target.isGuard()) return damage;\nif (damage < 0) return damage;\n\n// Declare Guard Rate\nlet guardRate = 0.5;\nguardRate /= target.grd;\n\n// Return Damage\nreturn damage * guardRate;"
 *
 * @param Critical
 * @text Critical Hits
 *
 * @param CriticalHitRateJS:func
 * @text JS: Rate Formula
 * @parent Critical
 * @type note
 * @desc The formula used to calculate Critical Hit Rates.
 * @default "// Declare Constants\nconst user = this.subject();\nconst target = arguments[0];\n\n// Create Base Critical Rate\nlet rate = this.subject().cri * (1 - target.cev);\n\n// Apply Notetags\nconst note = this.item().note;\nif (note.match(/<ALWAYS CRITICAL>/i)) {\n    return 1;\n}\nif (note.match(/<SET CRITICAL RATE:[ ](\\d+)([%％])>/i)) {\n    return Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL RATE:[ ](\\d+)([%％])>/i)) {\n    rate *= Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL RATE:[ ]([\\+\\-]\\d+)([%％])>/i)) {\n    rate += Number(RegExp.$1) / 100;\n}\nif (note.match(/<JS CRITICAL RATE>\\s*([\\s\\S]*)\\s*<\\/JS CRITICAL RATE>/i)) {\n    const code = String(RegExp.$1);\n    try {\n        eval(code);\n    } catch (e) {\n        if ($gameTemp.isPlaytest()) console.log(e);\n    }\n}\n\n// Apply LUK Buffs/Debuffs\nconst lukStack = this.subject().buff(7);\nrate *= 2 ** lukStack;\n\n// Return Rate\nreturn rate;"
 *
 * @param CriticalHitMultiplier:func
 * @text JS: Damage Formula
 * @parent Critical
 * @type note
 * @desc The formula used to calculate Critical Hit Damage modification.
 * @default "// Declare Constants\nconst user = this.subject();\nlet damage = arguments[0];\nlet multiplier = 2.0;\nlet bonusDamage = this.subject().luk * this.subject().cri;\n\n// Apply Notetags\nconst note = this.item().note;\nif (note.match(/<MODIFY CRITICAL MULTIPLIER:[ ](\\d+)([%％])>/i)) {\n    multiplier = Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL MULTIPLIER:[ ]([\\+\\-]\\d+)([%％])>/i)) {\n    multiplier += Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL BONUS DAMAGE:[ ](\\d+)([%％])>/i)) {\n    bonusDamage *= Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL BONUS DAMAGE:[ ]([\\+\\-]\\d+)([%％])>/i)) {\n    bonusDamage += bonusDamage * (RegExp.$1) / 100;\n}\nif (note.match(/<JS CRITICAL DAMAGE>\\s*([\\s\\S]*)\\s*<\\/JS CRITICAL DAMAGE>/i)) {\n    const code = String(RegExp.$1);\n    try {\n        eval(code);\n    } catch (e) {\n        if ($gameTemp.isPlaytest()) console.log(e);\n    }\n}\n\n// Return Damage\nreturn damage * multiplier + bonusDamage;"
 *
 */
/* ----------------------------------------------------------------------------
 * Damage Formula Style
 * ----------------------------------------------------------------------------
 */
/*~struct~DamageStyle:
 *
 * @param Name:str
 * @text Name
 * @desc Name of this Damage Style.
 * Used for notetags and such.
 * @default Untitled
 *
 * @param Formula:func
 * @text JS: Formula
 * @parent Name:str
 * @type note
 * @desc The base formula for this Damage Style.
 * @default "// Define Constants\nconst item = this.item();\nconst a = this.subject();\nconst b = target;\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\n\n// Create Damage Value\nlet value = Math.max(eval(item.damage.formula), 0) * sign;\n\n// Return Value\nreturn isNaN(value) ? 0 : value;"
 *
 * @param ItemsEquipsCore
 * @text Items & Equips Core
 *
 * @param DamageType
 * @text Damage Label
 * @parent ItemsEquipsCore
 *
 * @param DamageType1:str
 * @text HP Damage
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Damage Multiplier
 *
 * @param DamageType2:str
 * @text MP Damage
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Damage Multiplier
 *
 * @param DamageType3:str
 * @text HP Recovery
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Recovery Multiplier
 *
 * @param DamageType4:str
 * @text MP Recovery
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Recovery Multiplier
 *
 * @param DamageType5:str
 * @text HP Drain
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Drain Multiplier
 *
 * @param DamageType6:str
 * @text MP Drain
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Drain Multiplier
 *
 * @param DamageDisplay:func
 * @text JS: Damage Display
 * @parent ItemsEquipsCore
 * @type note
 * @desc Code used the data displayed for this category.
 * @default "// Define Constants\nconst item = this._item;\nconst formula = item.damage.formula;\nconst a = this._tempActorA;\nconst b = this._tempActorB;\nconst user = a;\nconst target = b;\n\n// Return Value\ntry {\n    const value = Math.max(eval(formula), 0);\n    return '%1%'.format(Math.round(value * 100));\n} catch (e) {\n    if ($gameTemp.isPlaytest()) {\n        console.log('Damage Formula Error for %1'.format(this._item.name));\n    }\n    return '?????';\n}"
 *
 */
/* ----------------------------------------------------------------------------
 * Mechanics Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Mechanics:
 *
 * @param ActionSpeed
 * @text Action Speed
 *
 * @param AllowRandomSpeed:eval
 * @text Allow Random Speed?
 * @parent ActionSpeed
 * @type boolean
 * @on Allow
 * @off Disable
 * @desc Allow speed to be randomized base off the user's AGI?
 * @default false
 *
 * @param SyncBuffExpire:eval
 * @text Turn End Buffs Expire
 * @parent ActionSpeed
 * @type boolean
 * @on Expire
 * @off Don't Expire
 * @desc Normally, buffs expire after all actions end.
 * But here, you can have buffs expire on turn end.
 * @default false
 *
 * @param CalcActionSpeedJS:func
 * @text JS: Calculate
 * @parent ActionSpeed
 * @type note
 * @desc Code used to calculate action speed.
 * @default "// Declare Constants\nconst agi = this.subject().agi;\n\n// Create Speed\nlet speed = agi;\nif (this.allowRandomSpeed()) {\n    speed += Math.randomInt(Math.floor(5 + agi / 4));\n}\nif (this.item()) {\n    speed += this.item().speed;\n}\nif (this.isAttack()) {\n    speed += this.subject().attackSpeed();\n}\n\n// Return Speed\nreturn speed;"
 *
 * @param BaseTroop
 * @text Base Troop
 *
 * @param BaseTroopIDs:arraynum
 * @text Base Troop ID's
 * @parent BaseTroop
 * @type troop[]
 * @desc Select the Troop ID(s) to duplicate page events from for all other troops.
 * @default ["1"]
 *
 * @param CommonEvents
 * @text Common Events (on Map)
 *
 * @param BattleStartEvent:num
 * @text Pre-Battle Event
 * @parent CommonEvents
 * @type common_event
 * @desc Common Event to run before each battle on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param BattleEndEvent:num
 * @text Post-Battle Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run after each battle on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param VictoryEvent:num
 * @text Victory Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run upon victory on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param DefeatEvent:num
 * @text Defeat Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run upon defeat on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param EscapeSuccessEvent:num
 * @text Escape Success Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run upon escape success on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param EscapeFailEvent:num
 * @text Escape Fail Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run upon escape failure on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param Escape
 *
 * @param CalcEscapeRatioJS:func
 * @text JS: Calc Escape Ratio
 * @parent Escape
 * @type note
 * @desc Code used to calculate the escape success ratio.
 * @default "// Calculate Escape Ratio\nlet ratio = 0.5;\nratio *= $gameParty.agility();\nratio /= $gameTroop.agility();\n\n// Return Ratio\nreturn ratio;"
 *
 * @param CalcEscapeRaiseJS:func
 * @text JS: Calc Escape Raise
 * @parent Escape
 * @type note
 * @desc Code used to calculate how much the escape success ratio raises upon each failure.
 * @default "// Calculate Escape Ratio\nlet value = 0.1;\nvalue += $gameParty.aliveMembers().length;\n\n// Return Value\nreturn value;"
 *
 * @param Switches
 *
 * @param SwitchCritical:num
 * @text Switch: Critical
 * @parent Switches
 * @type switch
 * @desc Turns switch ON if the action performs a critical hit.
 * Switch reverts to OFF whenever an action starts.
 * @default 0
 *
 * @param SwitchMissEvade:num
 * @text Switch: Miss/Evade
 * @parent Switches
 * @type switch
 * @desc Turns switch ON if the action misses/is evaded.
 * Switch reverts to OFF whenever an action starts.
 * @default 0
 *
 * @param Variables
 *
 * @param VariableDmg:num
 * @text Variable: Damage
 * @parent Variables
 * @type variable
 * @desc Variable records target damage during action.
 * Variable reverts to 0 whenever an action starts.
 * @default 0
 *
 * @param VariableHeal:num
 * @text Variable: Healing
 * @parent Variables
 * @type variable
 * @desc Variable records target healing during action.
 * Variable reverts to 0 whenever an action starts.
 * @default 0
 *
 * @param BattleJS
 * @text JS: Battle-Related
 * 
 * @param PreStartBattleJS:func
 * @text JS: Pre-Start Battle
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.startBattle()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostStartBattleJS:func
 * @text JS: Post-Start Battle
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.startBattle()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 * 
 * @param BattleVictoryJS:func
 * @text JS: Battle Victory
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.processVictory()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param EscapeSuccessJS:func
 * @text JS: Escape Success
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.onEscapeSuccess()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param EscapeFailureJS:func
 * @text JS: Escape Failure
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.onEscapeFailure()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 * 
 * @param BattleDefeatJS:func
 * @text JS: Battle Defeat
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.processDefeat()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 * 
 * @param PreEndBattleJS:func
 * @text JS: Pre-End Battle
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.endBattle()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostEndBattleJS:func
 * @text JS: Post-End Battle
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.endBattle()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param TurnJS
 * @text JS: Turn-Related
 *
 * @param PreStartTurnJS:func
 * @text JS: Pre-Start Turn
 * @parent TurnJS
 * @type note
 * @desc Target function: BattleManager.startTurn()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostStartTurnJS:func
 * @text JS: Post-Start Turn
 * @parent TurnJS
 * @type note
 * @desc Target function: BattleManager.startTurn()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PreEndTurnJS:func
 * @text JS: Pre-End Turn
 * @parent TurnJS
 * @type note
 * @desc Target function: Game_Battler.prototype.onTurnEnd()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostEndTurnJS:func
 * @text JS: Post-End Turn
 * @parent TurnJS
 * @type note
 * @desc Target function: Game_Battler.prototype.onTurnEnd()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PreRegenerateJS:func
 * @text JS: Pre-Regenerate
 * @parent TurnJS
 * @type note
 * @desc Target function: Game_Battler.prototype.regenerateAll()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostRegenerateJS:func
 * @text JS: Post-Regenerate
 * @parent TurnJS
 * @type note
 * @desc Target function: Game_Battler.prototype.regenerateAll()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param ActionJS
 * @text JS: Action-Related
 *
 * @param PreStartActionJS:func
 * @text JS: Pre-Start Action
 * @parent ActionJS
 * @type note
 * @desc Target function: BattleManager.startAction()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst user = this.subject();\nconst target = user;\nconst a = user;\nconst b = user;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n"
 *
 * @param PostStartActionJS:func
 * @text JS: Post-Start Action
 * @parent ActionJS
 * @type note
 * @desc Target function: BattleManager.startAction()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst user = this.subject();\nconst target = user;\nconst a = user;\nconst b = user;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n"
 *
 * @param PreApplyJS:func
 * @text JS: Pre-Apply
 * @parent ActionJS
 * @type note
 * @desc Target function: Game_Action.prototype.apply()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst target = arguments[1];\nconst user = this.subject();\nconst a = user;\nconst b = target;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n\n// Return Value\nreturn value;"
 *
 * @param PreDamageJS:func
 * @text JS: Pre-Damage
 * @parent ActionJS
 * @type note
 * @desc Target function: Game_Action.prototype.executeDamage()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst target = arguments[1];\nconst user = this.subject();\nconst a = user;\nconst b = target;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n\n// Return Value\nreturn value;"
 *
 * @param PostDamageJS:func
 * @text JS: Post-Damage
 * @parent ActionJS
 * @type note
 * @desc Target function: Game_Action.prototype.executeDamage()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst target = arguments[1];\nconst user = this.subject();\nconst a = user;\nconst b = target;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n\n// Return Value\nreturn value;"
 *
 * @param PostApplyJS:func
 * @text JS: Post-Apply
 * @parent ActionJS
 * @type note
 * @desc Target function: Game_Action.prototype.apply()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst target = arguments[1];\nconst user = this.subject();\nconst a = user;\nconst b = target;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n\n// Return Value\nreturn value;"
 *
 * @param PreEndActionJS:func
 * @text JS: Pre-End Action
 * @parent ActionJS
 * @type note
 * @desc Target function: BattleManager.endAction()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst user = this.subject();\nconst target = user;\nconst a = user;\nconst b = user;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n"
 *
 * @param PostEndActionJS:func
 * @text JS: Post-End Action
 * @parent ActionJS
 * @type note
 * @desc Target function: BattleManager.endAction()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst user = this.subject();\nconst target = user;\nconst a = user;\nconst b = user;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n"
 *
 */
/* ----------------------------------------------------------------------------
 * Battle Layout Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~BattleLayout:
 *
 * @param Style:str
 * @text Battle Layout Style
 * @type select
 * @option Default - Shows actor faces in Battle Status.
 * @value default
 * @option List - Lists actors in Battle Status.
 * @value list
 * @option XP - Shows actor battlers in a stretched Battle Status.
 * @value xp
 * @option Portrait - Shows portraits in a stretched Battle Status.
 * @value portrait
 * @option Border - Displays windows around the screen border.
 * @value border
 * @option Frontview Battle UI - Requires VisuMZ_3_FrontviewBattleUI
 * @value frontview_ui
 * @option Sideview Battle UI - Requires VisuMZ_3_SideviewBattleUI
 * @value sideview_ui
 * @desc The style used for the battle layout.
 * @default default
 *
 * @param ListStyle
 * @text List Style
 * @parent Style:str
 *
 * @param ShowFacesListStyle:eval
 * @text Show Faces
 * @parent ListStyle
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Shows faces in List Style?
 * @default true
 *
 * @param CommandWidth:num
 * @text Command Window Width
 * @parent ListStyle
 * @type number
 * @min 1
 * @desc Determine the window width for the Party and Actor Command
 * Windows. Affects Default and List Battle Layout styles.
 * @default 192
 *
 * @param XPStyle
 * @text XP Style
 * @parent Style:str
 *
 * @param XPActorCommandLines:num
 * @text Command Lines
 * @parent XPStyle
 * @type number
 * @min 1
 * @desc Number of action lines in the Actor Command Window for the XP Style.
 * @default 4
 *
 * @param XPActorDefaultHeight:num
 * @text Sprite Height
 * @parent XPStyle
 * @type number
 * @min 1
 * @desc Default sprite height used when if the sprite's height has not been determined yet.
 * @default 64
 *
 * @param XPSpriteYLocation:str
 * @text Sprite Base Location
 * @parent XPStyle
 * @type select
 * @option Above Name - Sprite is located above the name.
 * @value name
 * @option Bottom - Sprite is located at the bottom of the window.
 * @value bottom
 * @option Centered - Sprite is centered in the window.
 * @value center
 * @option Top - Sprite is located at the top of the window.
 * @value top
 * @desc Determine where the sprite is located on the Battle Status Window.
 * @default name
 *
 * @param PotraitStyle
 * @text Portrait Style
 * @parent Style:str
 *
 * @param ShowPortraits:eval
 * @text Show Portraits?
 * @parent PotraitStyle
 * @type boolean
 * @on Portraits
 * @off Faces
 * @desc Requires VisuMZ_1_MainMenuCore.
 * Shows the actor's portrait instead of a face.
 * @default true
 *
 * @param PortraitScale:num
 * @text Portrait Scaling
 * @parent PotraitStyle
 * @desc If portraits are used, scale them by this much.
 * @default 0.5
 *
 * @param BorderStyle
 * @text Border Style
 * @parent Style:str
 *
 * @param SkillItemBorderCols:num
 * @text Columns
 * @parent BorderStyle
 * @type number
 * @min 1
 * @desc The total number of columns for Skill & Item Windows
 * in the battle scene.
 * @default 1
 *
 * @param ShowPortraitsBorderStyle:eval
 * @text Show Portraits?
 * @parent BorderStyle
 * @type boolean
 * @on Portraits
 * @off Faces
 * @desc Requires VisuMZ_1_MainMenuCore.
 * Shows the actor's portrait at the edge of the screen.
 * @default true
 *
 * @param PortraitScaleBorderStyle:num
 * @text Portrait Scaling
 * @parent BorderStyle
 * @desc If portraits are used, scale them by this much.
 * @default 1.0
 *
 * @param SkillItemWindows
 * @text Skill & Item Windows
 *
 * @param SkillItemMiddleLayout:eval
 * @text Middle Layout
 * @parent SkillItemWindows
 * @type boolean
 * @on Middle
 * @off Bottom
 * @desc Shows the Skill & Item Windows in mid-screen?
 * @default false
 *
 * @param SkillItemStandardCols:num
 * @text Columns
 * @parent SkillItemWindows
 * @type number
 * @min 1
 * @desc The total number of columns for Skill & Item Windows
 * in the battle scene.
 * @default 2
 *
 * @param StatusWindow
 * @text Status Window Elements
 *
 * @param StatusWindowName
 * @text Battler Name
 * @parent StatusWindow
 *
 * @param NameOffsetX:num
 * @text Offset: X
 * @parent StatusWindowName
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param NameOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowName
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowHpGauge
 * @text Gauge 1 (HP)
 * @parent StatusWindow
 *
 * @param HpGaugeOffsetX:num
 * @text Offset: X
 * @parent StatusWindowHpGauge
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param HpGaugeOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowHpGauge
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowMpGauge
 * @text Gauge 2 (MP)
 * @parent StatusWindow
 *
 * @param MpGaugeOffsetX:num
 * @text Offset: X
 * @parent StatusWindowMpGauge
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param MpGaugeOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowMpGauge
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowTpGauge
 * @text Gauge 3 (TP)
 * @parent StatusWindow
 *
 * @param TpGaugeOffsetX:num
 * @text Offset: X
 * @parent StatusWindowTpGauge
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param TpGaugeOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowTpGauge
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowStateIcon
 * @text State Icon
 * @parent StatusWindow
 *
 * @param StateIconOffsetX:num
 * @text Offset: X
 * @parent StatusWindowStateIcon
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param StateIconOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowStateIcon
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowTpbGauge
 * @text TPB/ATB Gauge
 * @parent StatusWindow
 *
 * @param TpbGaugeOffsetX:num
 * @text Offset: X
 * @parent StatusWindowTpbGauge
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param TpbGaugeOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowTpbGauge
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowSkin
 * @text Window Skin
 * @parent StatusWindow
 *
 * @param StatusWindowSkinFilename:str
 * @text Filename
 * @parent StatusWindowSkin
 * @type file
 * @dir img/system/
 * @desc Filename used for the Battle Status Window skin.
 * Leave this empty to use the default window skin.
 * @default 
 *
 * @param StatusWindowSkinHide:eval
 * @text Hide Window Skin?
 * @parent StatusWindowSkin
 * @type boolean
 * @on No Window Skin
 * @off Default Skin
 * @desc Show/Hide the window skin for the Battle Status Window?
 * @default false
 *
 * @param StatusWindowSelectBack
 * @text Selectable Background
 * @parent StatusWindow
 *
 * @param StatusWindowSelectableBackHide:eval
 * @text Hide Selectable BG?
 * @parent StatusWindowSelectBack
 * @type boolean
 * @on No Selectable BG
 * @off Default Selectable BG
 * @desc Show/Hide the selectable background box for the Battle Status Window?
 * @default false
 *
 * @param StatusWindowAttachments
 * @text Attachments
 * @parent StatusWindow
 *
 * @param StatusWindowBackAttachment
 * @text Back Attachment
 * @parent StatusWindowAttachments
 *
 * @param StatusWindowAttachmentBack:str
 * @text Filename
 * @parent StatusWindowBackAttachment
 * @type file
 * @dir img/system/
 * @desc Filename used for an image to attach to the back of the
 * Battle Status Window. Leave empty for none.
 * @default 
 *
 * @param StatusWindowAttachmentBackOffsetX:num
 * @text Offset: X
 * @parent StatusWindowBackAttachment
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param StatusWindowAttachmentBackOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowBackAttachment
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowFrontAttachment
 * @text Front Attachment
 * @parent StatusWindowAttachments
 *
 * @param StatusWindowAttachmentFront:str
 * @text Filename
 * @parent StatusWindowFrontAttachment
 * @type file
 * @dir img/system/
 * @desc Filename used for an image to attach to the front of the
 * Battle Status Window. Leave empty for none.
 * @default 
 *
 * @param StatusWindowAttachmentFrontOffsetX:num
 * @text Offset: X
 * @parent StatusWindowFrontAttachment
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param StatusWindowAttachmentFrontOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowFrontAttachment
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param UiElements
 * @text UI Elements
 *
 * @param AntiTintUiElements:eval
 * @text Anti-Tint UI?
 * @parent UiElements
 * @type boolean
 * @on Prevent Tint
 * @off Allow Tint
 * @desc Prevent UI Elements from being tinted?
 * @default true
 *
 */
/* ----------------------------------------------------------------------------
 * Battle Log Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~BattleLog:
 *
 * @param General
 *
 * @param BackColor:str
 * @text Back Color
 * @parent General
 * @desc Use #rrggbb for a hex color.
 * @default #000000
 *
 * @param MaxLines:num
 * @text Max Lines
 * @parent General
 * @type number
 * @min 1
 * @desc Maximum number of lines to be displayed.
 * @default 10
 *
 * @param MessageWait:num
 * @text Message Wait
 * @parent General
 * @type number
 * @min 1
 * @desc Number of frames for a usual message wait.
 * @default 16
 *
 * @param TextAlign:str
 * @text Text Align
 * @parent General
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for the Window_BattleLog.
 * @default center
 *
 * @param BattleLogRectJS:func
 * @text JS: X, Y, W, H
 * @parent General
 * @type note
 * @desc Code used to determine the dimensions for the battle log.
 * @default "const wx = 0;\nconst wy = 0;\nconst ww = Graphics.boxWidth;\nconst wh = this.calcWindowHeight(10, false);\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param StartTurn
 * @text Start Turn
 *
 * @param StartTurnShow:eval
 * @text Show Start Turn?
 * @parent StartTurn
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display turn changes at the start of the turn?
 * @default false
 *
 * @param StartTurnMsg:str
 * @text Start Turn Message
 * @parent StartTurn
 * @desc Message displayed at turn start.
 * %1 - Turn Count
 * @default Turn %1
 *
 * @param StartTurnWait:num
 * @text Start Turn Wait
 * @parent StartTurn
 * @type number
 * @min 1
 * @desc Number of frames to wait after a turn started.
 * @default 40
 *
 * @param DisplayAction
 * @text Display Action
 *
 * @param ActionCenteredName:eval
 * @text Show Centered Action?
 * @parent DisplayAction
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display a centered text of the action name?
 * @default true
 *
 * @param ActionSkillMsg1:eval
 * @text Show Skill Message 1?
 * @parent DisplayAction
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display the 1st skill message?
 * @default false
 *
 * @param ActionSkillMsg2:eval
 * @text Show Skill Message 2?
 * @parent DisplayAction
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display the 2nd skill message?
 * @default true
 *
 * @param ActionItemMsg:eval
 * @text Show Item Message?
 * @parent DisplayAction
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display the item use message?
 * @default false
 *
 * @param ActionChanges
 * @text Action Changes
 *
 * @param ShowCounter:eval
 * @text Show Counter?
 * @parent ActionChanges
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display counter text?
 * @default true
 *
 * @param ShowReflect:eval
 * @text Show Reflect?
 * @parent ActionChanges
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display magic reflection text?
 * @default true
 *
 * @param ShowSubstitute:eval
 * @text Show Substitute?
 * @parent ActionChanges
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display substitute text?
 * @default true
 *
 * @param ActionResults
 * @text Action Results
 *
 * @param ShowFailure:eval
 * @text Show No Effect?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display no effect text?
 * @default false
 *
 * @param ShowCritical:eval
 * @text Show Critical?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display critical text?
 * @default false
 *
 * @param ShowMissEvasion:eval
 * @text Show Miss/Evasion?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display miss/evasion text?
 * @default false
 *
 * @param ShowHpDmg:eval
 * @text Show HP Damage?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display HP Damage text?
 * @default false
 *
 * @param ShowMpDmg:eval
 * @text Show MP Damage?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display MP Damage text?
 * @default false
 *
 * @param ShowTpDmg:eval
 * @text Show TP Damage?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display TP Damage text?
 * @default false
 *
 * @param DisplayStates
 * @text Display States
 *
 * @param ShowAddedState:eval
 * @text Show Added States?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display added states text?
 * @default false
 *
 * @param ShowRemovedState:eval
 * @text Show Removed States?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display removed states text?
 * @default false
 *
 * @param ShowCurrentState:eval
 * @text Show Current States?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display the currently affected state text?
 * @default false
 *
 * @param ShowAddedBuff:eval
 * @text Show Added Buffs?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display added buffs text?
 * @default false
 *
 * @param ShowAddedDebuff:eval
 * @text Show Added Debuffs?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display added debuffs text?
 * @default false
 *
 * @param ShowRemovedBuff:eval
 * @text Show Removed Buffs?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display removed de/buffs text?
 * @default false
 *
 */
/* ----------------------------------------------------------------------------
 * Battleback Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Battleback:
 *
 * @param DefaultStyle:str
 * @text Default Style
 * @type select
 * @option MZ (MZ's default style)
 * @value MZ
 * @option 1:1 (No Scaling)
 * @value 1:1
 * @option Scale To Fit (Scale to screen size)
 * @value ScaleToFit
 * @option Scale Down (Scale Downward if Larger than Screen)
 * @value ScaleDown
 * @option Scale Up (Scale Upward if Smaller than Screen)
 * @value ScaleUp
 * @desc The default scaling style used for battlebacks.
 * @default MZ
 *
 * @param jsOneForOne:func
 * @text JS: 1:1
 * @type note
 * @desc This code gives you control over the scaling for this style.
 * @default "// Adjust Size\nthis.width = Graphics.width;\nthis.height = Graphics.height;\n\n// Adjust Scale\nconst scale = 1.0;\nthis.scale.x = scale;\nthis.scale.y = scale;\n\n// Adjust Coordinates\nthis.x = 0;\nthis.y = 0;"
 *
 * @param jsScaleToFit:func
 * @text JS: Scale To Fit
 * @type note
 * @desc This code gives you control over the scaling for this style.
 * @default "// Adjust Size\nthis.width = Graphics.width;\nthis.height = Graphics.height;\n\n// Adjust Scale\nconst ratioX = this.width / this.bitmap.width;\nconst ratioY = this.height / this.bitmap.height;\nconst scale = Math.max(ratioX, ratioY);\nthis.scale.x = scale;\nthis.scale.y = scale;\n\n// Adjust Coordinates\nthis.x = (Graphics.width - this.width) / 2;\nthis.y = Graphics.height - this.height;"
 *
 * @param jsScaleDown:func
 * @text JS: Scale Down
 * @type note
 * @desc This code gives you control over the scaling for this style.
 * @default "// Adjust Size\nthis.width = Graphics.width;\nthis.height = Graphics.height;\n\n// Adjust Scale\nconst ratioX = Math.min(1, this.width / this.bitmap.width);\nconst ratioY = Math.min(1, this.height / this.bitmap.height);\nconst scale = Math.max(ratioX, ratioY);\nthis.scale.x = scale;\nthis.scale.y = scale;\n\n// Adjust Coordinates\nthis.x = (Graphics.width - this.width) / 2;\nthis.y = Graphics.height - this.height;"
 *
 * @param jsScaleUp:func
 * @text JS: Scale Up
 * @type note
 * @desc This code gives you control over the scaling for this style.
 * @default "// Adjust Size\nthis.width = Graphics.width;\nthis.height = Graphics.height;\n\n// Adjust Scale\nconst ratioX = Math.max(1, this.width / this.bitmap.width);\nconst ratioY = Math.max(1, this.height / this.bitmap.height);\nconst scale = Math.max(ratioX, ratioY);\nthis.scale.x = scale;\nthis.scale.y = scale;\n\n// Adjust Coordinates\nthis.x = (Graphics.width - this.width) / 2;\nthis.y = Graphics.height - this.height;"
 *
 */
/* ----------------------------------------------------------------------------
 * Party Command Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~PartyCmd:
 *
 * @param Cmd
 * @text Command Window
 *
 * @param CmdStyle:str
 * @text Style
 * @parent Cmd
 * @type select
 * @option Text Only
 * @value text
 * @option Icon Only
 * @value icon
 * @option Icon + Text
 * @value iconText
 * @option Automatic
 * @value auto
 * @desc How do you wish to draw commands in the Party Command Window?
 * @default auto
 *
 * @param CmdTextAlign:str
 * @text Text Align
 * @parent Cmd
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for the Party Command Window.
 * @default left
 *
 * @param CmdIconFight:num
 * @text Fight Icon
 * @parent Cmd
 * @desc The icon used for the Fight command.
 * @default 76
 *
 * @param CommandAddAutoBattle:eval
 * @text Add Auto Battle?
 * @parent Cmd
 * @type boolean
 * @on Add
 * @off Don't
 * @desc Add the "Auto Battle" command to the Command Window?
 * @default true
 *
 * @param CmdIconAutoBattle:num
 * @text Auto Battle Icon
 * @parent CommandAddAutoBattle:eval
 * @desc The icon used for the Auto Battle command.
 * @default 78
 *
 * @param CmdTextAutoBattle:str
 * @text Auto Battle Text
 * @parent CommandAddAutoBattle:eval
 * @desc The text used for the Auto Battle command.
 * @default Auto
 *
 * @param CommandAddOptions:eval
 * @text Add Options?
 * @parent Cmd
 * @type boolean
 * @on Add
 * @off Don't
 * @desc Add the "Options" command to the Command Window?
 * @default true
 *
 * @param CmdIconOptions:num
 * @text Options Icon
 * @parent CommandAddOptions:eval
 * @desc The icon used for the Options command.
 * @default 83
 *
 * @param ActiveTpbOptionsMessage:str
 * @text Active TPB Message
 * @parent CommandAddOptions:eval
 * @desc Message that will be displayed when selecting options during the middle of an action.
 * @default Options Menu queued after action is complete.
 *
 * @param CmdIconEscape:num
 * @text Escape Icon
 * @parent Cmd
 * @desc The icon used for the Escape command.
 * @default 82
 *
 * @param Access
 *
 * @param SkipPartyCmd:eval
 * @text Skip Party Command
 * @parent Access
 * @type boolean
 * @on Skip
 * @off Don't
 * @desc DTB: Skip Party Command selection on turn start.
 * TPB: Skip Party Command selection at battle start.
 * @default true
 *
 * @param DisablePartyCmd:eval
 * @text Disable Party Command
 * @parent Access
 * @type boolean
 * @on Disable
 * @off Don't
 * @desc Disable the Party Command Window entirely?
 * @default false
 *
 * @param HelpWindow
 * @text Help Window
 *
 * @param HelpFight:str
 * @text Fight
 * @parent HelpWindow
 * @desc Text displayed when selecting a skill type.
 * %1 - Skill Type Name
 * @default Select actions to fight.
 *
 * @param HelpAutoBattle:str
 * @text Auto Battle
 * @parent HelpWindow
 * @desc Text displayed when selecting the Auto Battle command.
 * @default Sets party to Auto Battle mode.
 *
 * @param HelpOptions:str
 * @text Options
 * @parent HelpWindow
 * @desc Text displayed when selecting the Options command.
 * @default Opens up the Options Menu.
 *
 * @param HelpEscape:str
 * @text Escape
 * @parent HelpWindow
 * @desc Text displayed when selecting the escape command.
 * @default Attempt to escape the battle.
 *
 */
/* ----------------------------------------------------------------------------
 * Actor Command Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ActorCmd:
 *
 * @param Cmd
 * @text Command Window
 *
 * @param CmdStyle:str
 * @text Style
 * @parent Cmd
 * @type select
 * @option Text Only
 * @value text
 * @option Icon Only
 * @value icon
 * @option Icon + Text
 * @value iconText
 * @option Automatic
 * @value auto
 * @desc How do you wish to draw commands in the Actor Command Window?
 * @default auto
 *
 * @param CmdTextAlign:str
 * @text Text Align
 * @parent Cmd
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for the Actor Command Window.
 * @default left
 *
 * @param CmdIconItem:num
 * @text Item Icon
 * @parent Cmd
 * @desc The icon used for the Item command.
 * @default 176
 *
 * @param IconStypeNorm:num
 * @text Normal SType Icon
 * @parent Cmd
 * @desc Icon used for normal skill types that aren't assigned any
 * icons. Ignore if VisuMZ_1_SkillsStatesCore is installed.
 * @default 78
 *
 * @param IconStypeMagic:num
 * @text Magic SType Icon
 * @parent Cmd
 * @desc Icon used for magic skill types that aren't assigned any
 * icons. Ignore if VisuMZ_1_SkillsStatesCore is installed.
 * @default 79
 *
 * @param BattleCmd
 * @text Battle Commands
 *
 * @param BattleCmdList:arraystr
 * @text Command List
 * @parent BattleCmd
 * @type combo[]
 * @option attack
 * @option skills
 * @option guard
 * @option item
 * @option party
 * @option escape
 * @option auto battle
 * @option stypes
 * @option stype: x
 * @option stype: name
 * @option all skills
 * @option skill: x
 * @option skill: name
 * @option combat log
 * @option talk
 * @option weapon swap
 * @desc List of battle commands that appear by default
 * if the <Battle Commands> notetag isn't present.
 * @default ["attack","skills","guard","party","item"]
 *
 * @param ShowCosts:eval
 * @text Show Command Costs
 * @parent BattleCmd
 * @type boolean
 * @on Show Costs
 * @off Hide Costs
 * @desc If a battle command has a resource cost, show it?
 * @default true
 *
 * @param HelpWindow
 * @text Help Window
 *
 * @param HelpSkillType:str
 * @text Skill Types
 * @parent HelpWindow
 * @desc Text displayed when selecting a skill type.
 * %1 - Skill Type Name
 * @default Opens up a list of skills under the \C[16]%1\C[0] category.
 *
 * @param HelpItem:str
 * @text Items
 * @parent HelpWindow
 * @desc Text displayed when selecting the item command.
 * @default Opens up a list of items that you can use.
 *
 * @param HelpEscape:str
 * @text Escape
 * @parent HelpWindow
 * @desc Text displayed when selecting the escape command.
 * @default Attempt to escape the battle.
 *
 * @param HelpAutoBattle:str
 * @text Auto Battle
 * @parent HelpWindow
 * @desc Text displayed when selecting the Auto Battle command.
 * @default Automatically choose an action suitable for combat.
 *
 * @param HelpParty:str
 * @text Party
 * @parent HelpWindow
 * @desc Text displayed when selecting the Party command.
 * Requires 
 * @default Automatically choose an action suitable for combat.
 *
 */
/* ----------------------------------------------------------------------------
 * Multi-Target Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~MultiTarget:
 *
 * @param Properties
 * 
 * @param WindowWidth:num
 * @text Window Width
 * @parent Properties
 * @type number
 * @min 1
 * @desc What is the width used for the Multi-Target Window?
 * @default 280
 *
 * @param BgType:num
 * @text Background Type
 * @parent Properties
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for these windows.
 * @default 2
 *
 * @param ShowButton:eval
 * @text Show Button
 * @parent Properties
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Shows the keyboard/controller button to press?
 * Requires VisuMZ_0_CoreEngine!
 * @default true
 * 
 * @param Vocab
 *
 * @param AllActorsText:str
 * @text All Actors
 * @parent Vocab
 * @desc What is the text used for the "All Actors" button?
 * @default All Allies
 *
 * @param AllEnemiesText:str
 * @text All Enemies
 * @parent Vocab
 * @desc What is the text used for the "All Enemies" button?
 * @default All Enemies
 * 
 * @param Offsets
 * 
 * @param ActorOffsets
 * @text Actor Offsets
 * @parent Offsets
 *
 * @param ActorOffsetX:num
 * @text Offset X
 * @parent ActorOffsets
 * @desc Offsets the button's x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param ActorOffsetY:num
 * @text Offset Y
 * @parent ActorOffsets
 * @desc Offsets the button's y position.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @param EnemyOffsets
 * @text Enemy Offsets
 * @parent Offsets
 *
 * @param EnemyOffsetX:num
 * @text Offset X
 * @parent EnemyOffsets
 * @desc Offsets the button's x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param EnemyOffsetY:num
 * @text Offset Y
 * @parent EnemyOffsets
 * @desc Offsets the button's y position.
 * Negative: up. Positive: down.
 * @default +0
 *
 */
/* ----------------------------------------------------------------------------
 * Combo Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ComboWindow:
 *
 * @param General
 * @text General Settings
 *
 * @param Enable:eval
 * @text Enable?
 * @parent General
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Add the Combo Window to show in battle?
 * @default true
 *
 * @param Appearance
 * @text Appearance Settings
 *
 * @param CustomFontFace:str
 * @text Custom Font
 * @parent Appearance
 * @desc Insert the custom font face name here.
 * Use VisuMZ_1_MessageCore to register new fonts.
 * @default Arial
 *
 * @param TextAlign:str
 * @text Text Align
 * @parent Appearance
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for this window?
 * @default left
 *
 * @param ComboWindow_DrawJS:func
 * @text JS: Draw Data
 * @parent Appearance
 * @type note
 * @desc Code used to draw the data in this window.
 * @default ""
 * 
 * @param Vocab
 * @text Vocabulary
 *
 * @param hitsDmgFmt:str
 * @text Damage Combo Format
 * @parent Vocab
 * @desc Text format used to display total hits for damage.
 * %1 - Total Hits
 * @default \C[6]%1\} \C[4]Hit Combo\C[0]\{
 *
 * @param hitsHealFmt:str
 * @text Healing Combo Format
 * @parent Vocab
 * @desc Text format used to display total hits for healing.
 * %1 - Total Hits
 * @default \C[6]%1\} \C[4]Heal Combo\C[0]\{
 *
 * @param totalDmgFmt:str
 * @text Damage Total Format
 * @parent Vocab
 * @desc Text format used to display total value for damage.
 * %1 - Total Damage
 * @default \}\C[21]Total Damage: \{\C[0]%1
 *
 * @param totalHealFmt:str
 * @text Healing Total Format
 * @parent Vocab
 * @desc Text format used to display total value for healing.
 * %1 - Total Healing
 * @default \}\C[21]Total Healing: \{\C[24]+%1\C[0]
 *
 * @param Position
 * @text Position Settings
 *
 * @param fadeShiftX:num
 * @text Fade Shift X
 * @parent Position
 * @desc Shifts the windows x position when fading.
 * Negative: left. Positive: right.
 * @default -2
 *
 * @param fadeShiftY:num
 * @text Fade Shift Y
 * @parent Position
 * @desc Shifts the windows y position when fading.
 * Negative: up. Positive: down.
 * @default +0
 *
 * @param PosOffsetX:num
 * @text Offset X
 * @parent Position
 * @desc Offsets the windows x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param PosOffsetY:num
 * @text Offset Y
 * @parent Position
 * @desc Offsets the windows y position.
 * Negative: up. Positive: down.
 * @default +0
 *
 * @param ComboWindow_RectJS:func
 * @text JS: X, Y, W, H
 * @parent Position
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const ww = Math.ceil(Graphics.width / 4);\nconst wh = this.calcWindowHeight(2, true);\nconst wx = 0 + this.comboWindowOffsetX();\nconst wy = Math.round(Graphics.boxHeight * 1 / 3) + this.comboWindowOffsetY();\nreturn new Rectangle(wx, wy, ww, wh);"
 * 
 * @param Update
 * @text Updating Settings
 *
 * @param updateDuration:num
 * @text Number Roll Duration
 * @parent Update
 * @type number
 * @min 1
 * @desc Frame duration to roll damage numbers.
 * 60 frames = 1 second.
 * @default 20
 *
 * @param minimumStayDuration:num
 * @text Minimum Stay Duration
 * @parent Update
 * @type number
 * @desc Frame duration to stay visible minimum.
 * 60 frames = 1 second.
 * @default 40
 *
 * @param minimumHits:num
 * @text Minimum Hit Visible
 * @parent Update
 * @type number
 * @min 1
 * @desc Minimum hits before combo window becomes visible?
 * @default 1
 *
 * @param opacitySpeed:num
 * @text Opacity Speed
 * @parent Update
 * @type number
 * @min 1
 * @desc Opacity speed when fading in/out.
 * @default 16
 *
 */
/* ----------------------------------------------------------------------------
 * Actor Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Actor:
 *
 * @param Flinch
 *
 * @param FlinchDistanceX:num
 * @text Flinch Distance X
 * @parent Flinch
 * @desc The normal X distance when flinching.
 * @default 12
 *
 * @param FlinchDistanceY:num
 * @text Flinch Distance Y
 * @parent Flinch
 * @desc The normal Y distance when flinching.
 * @default 0
 *
 * @param FlinchDuration:num
 * @text Flinch Duration
 * @parent Flinch
 * @desc The number of frames for a flinch to complete.
 * @default 6
 *
 * @param ShakeFlinch:eval
 * @text Shake Flinch
 * @parent Flinch
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Perform a shake flinch when taking damage?
 * @default false
 *
 * @param ShakeFlinchDuration:num
 * @text Max Duration
 * @parent ShakeFlinch:eval
 * @type number
 * @min 1
 * @desc Maximum duration a shake flinch can have.
 * This is reduced relative to the amount of damage taken.
 * @default 24
 *
 * @param ShakeFlinchPower:num
 * @text Max Power
 * @parent ShakeFlinch:eval
 * @type number
 * @min 1
 * @desc The power rating of a shake flinch at full damage.
 * This is reduced relative to the amount of damage taken.
 * @default 48
 *
 * @param SvBattlers
 * @text Sideview Battlers
 * 
 * @param SvAnchor
 * @text Anchor
 * @parent SvBattlers
 *
 * @param AnchorX:num
 * @text Anchor: X
 * @parent SvAnchor
 * @desc Default X anchor for Sideview Battlers.
 * Use values between 0 and 1 to be safe.
 * @default 0.5
 *
 * @param AnchorY:num
 * @text Anchor: Y
 * @parent SvAnchor
 * @desc Default Y anchor for Sideview Battlers.
 * Use values between 0 and 1 to be safe.
 * @default 1.0
 *
 * @param ChantStyle:eval
 * @text Chant Style
 * @parent SvBattlers
 * @type boolean
 * @on Magical Hit Type
 * @off Magical Skill Type
 * @desc What determines the chant motion?
 * Hit type or skill type?
 * @default true
 *
 * @param MotionSpeed:num
 * @text Motion Speed
 * @parent SvBattlers
 * @type number
 * @min 1
 * @desc The number of frames in between each motion.
 * @default 12
 * 
 * @param SvPosition
 * @text Position
 * @parent SvBattlers
 *
 * @param OffsetX:num
 * @text Offset: X
 * @parent SvPosition
 * @desc Offsets X position where actor is positioned.
 * Negative values go left. Positive values go right.
 * @default 0
 *
 * @param OffsetY:num
 * @text Offset: Y
 * @parent SvPosition
 * @desc Offsets Y position where actor is positioned.
 * Negative values go up. Positive values go down.
 * @default 0
 *
 * @param PrioritySortActive:eval
 * @text Priority: Active
 * @parent SvBattlers
 * @type boolean
 * @on Active Actor over All Else
 * @off Active Actor is Sorted Normally
 * @desc Place the active actor on top of actor and enemy sprites.
 * @default false
 *
 * @param PrioritySortActors:eval
 * @text Priority: Actors
 * @parent SvBattlers
 * @type boolean
 * @on Actors over Enemies
 * @off Sort by Y Position
 * @desc Prioritize actors over enemies when placing sprites on top
 * of each other.
 * @default true
 *
 * @param Shadow:eval
 * @text Shadow Visible
 * @parent SvBattlers
 * @type boolean
 * @on Visible
 * @off Hidden
 * @desc Show or hide the shadow for Sideview Battlers.
 * @default true
 * 
 * @param SvStateOverlay
 * @text State Overlay
 * @parent SvBattlers
 *
 * @param StateOverlayOffsetX:num
 * @text Offset: X
 * @parent SvStateOverlay
 * @desc Offsets X position for state overlay on actor.
 * Negative values go left. Positive values go right.
 * @default 0
 *
 * @param StateOverlayOffsetY:num
 * @text Offset: Y
 * @parent SvStateOverlay
 * @desc Offsets Y position for state overlay on actor.
 * Negative values go up. Positive values go down.
 * @default 0
 *
 * @param SmoothImage:eval
 * @text Smooth Image
 * @parent SvBattlers
 * @type boolean
 * @on Smooth
 * @off Pixelated
 * @desc Smooth out the battler images or pixelate them?
 * @default false
 *
 * @param HomePosJS:func
 * @text JS: Home Position
 * @parent SvBattlers
 * @type note
 * @desc Code used to calculate the home position of actors.
 * @default "// Declare Constants\nconst sprite = this;\nconst actor = this._actor;\nconst index = arguments[0];\n\n// Make Calculations\nlet x = Math.round((Graphics.width / 2) + 192)\nx -= Math.floor((Graphics.width - Graphics.boxWidth) / 2);\nx += index * 32;\nlet y = (Graphics.height - 200) - ($gameParty.maxBattleMembers() * 48);\ny -= Math.floor((Graphics.height - Graphics.boxHeight) / 2);\ny += index * 48;\n\n// Home Position Offsets\nconst offsetNote = /<SIDEVIEW HOME OFFSET:[ ]([\\+\\-]\\d+),[ ]([\\+\\-]\\d+)>/i;\nconst xOffsets = actor.traitObjects().map((obj) => (obj && obj.note.match(offsetNote) ? Number(RegExp.$1) : 0));\nconst yOffsets = actor.traitObjects().map((obj) => (obj && obj.note.match(offsetNote) ? Number(RegExp.$2) : 0));\nx = xOffsets.reduce((r, offset) => r + offset, x);\ny = yOffsets.reduce((r, offset) => r + offset, y);\n\n// Set Home Position\nthis.setHome(x, y);"
 *
 */
/* ----------------------------------------------------------------------------
 * Enemy Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Enemy:
 *
 * @param Visual
 *
 * @param AttackAnimation:num
 * @text Attack Animation
 * @parent Visual
 * @type animation
 * @desc Default attack animation used for enemies.
 * Use <Attack Animation: x> for custom animations.
 * @default 1
 *
 * @param EmergeText:eval
 * @text Emerge Text
 * @parent Visual
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show or hide the 'Enemy emerges!' text at the start of battle.
 * @default false
 *
 * @param OffsetX:num
 * @text Offset: X
 * @parent Visual
 * @desc Offsets X position where enemy is positioned.
 * Negative values go left. Positive values go right.
 * @default 0
 *
 * @param OffsetY:num
 * @text Offset: Y
 * @parent Visual
 * @desc Offsets Y position where enemy is positioned.
 * Negative values go up. Positive values go down.
 * @default 0
 *
 * @param SmoothImage:eval
 * @text Smooth Image
 * @parent Visual
 * @type boolean
 * @on Smooth
 * @off Pixelated
 * @desc Smooth out the battler images or pixelate them?
 * @default true
 *
 * @param SelectWindow
 * @text Select Window
 *
 * @param LastSelected:eval
 * @text Any: Last Selected
 * @parent SelectWindow
 * @type boolean
 * @on Last Selected
 * @off FV/SV Priority
 * @desc Prioritize last selected enemy over front view or sideview settings?
 * @default true
 *
 * @param FrontViewSelect:eval
 * @text FV: Right Priority
 * @parent SelectWindow
 * @type boolean
 * @on Right
 * @off Normal
 * @desc If using frontview, auto select the enemy furthest right.
 * @default false
 *
 * @param SideviewSelect:eval
 * @text SV: Right Priority
 * @parent SelectWindow
 * @type boolean
 * @on Right
 * @off Normal
 * @desc If using sideview, auto select the enemy furthest right.
 * @default true
 * 
 * @param Name
 *
 * @param NameLegacy:eval
 * @text Legacy Option
 * @parent Name
 * @type boolean
 * @on Legacy Version
 * @off New Version (Sprite)
 * @desc Use the legacy version (window) or new version (sprite).
 * WARNING: Legacy version is no longer supported for bugs.
 * @default false
 *
 * @param NameFontSize:num
 * @text Font Size
 * @parent Name
 * @desc Font size used for enemy names.
 * @default 22
 * 
 * @param NamePosition
 * @text Name Position
 * @parent Name
 *
 * @param NameOffsetX:num
 * @text Offset X
 * @parent NamePosition
 * @desc Offset the enemy name's X position by this much.
 * Negative goes left. Positive goes right.
 * @default 0
 *
 * @param NameOffsetY:num
 * @text Offset Y
 * @parent NamePosition
 * @desc Offset the enemy name's Y position by this much.
 * Negative goes up. Positive goes down.
 * @default 0
 *
 * @param NameAttachStateIcon:eval
 * @text Attach States
 * @parent Name
 * @type boolean
 * @on Attach
 * @off Normal Position
 * @desc Attach the enemy's state icon to the enemy name?
 * @default false
 *
 * @param AttachStateOffsetX:num
 * @text Attach: Offset X
 * @parent NameAttachStateIcon:eval
 * @desc How much to offset the attached icon's X position by?
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param AttachStateOffsetY:num
 * @text Attach: Offset Y
 * @parent NameAttachStateIcon:eval
 * @desc How much to offset the attached icon's Y position by?
 * Negative goes up. Positive goes down.
 * @default +0
 * 
 * @param NameVisibility
 * @text Name Visibility
 * @parent Name
 *
 * @param NameAlwaysHidden:eval
 * @text Always Hidden
 * @parent NameVisibility
 * @type boolean
 * @on Always Hidden
 * @off No Priority
 * @desc Determines if the enemy name will always be visible.
 * Highest priority.
 * @default false
 *
 * @param NameAlwaysVisible:eval
 * @text Always Visible
 * @parent NameVisibility
 * @type boolean
 * @on Always Visible
 * @off Hide when Unselected
 * @desc Determines if the enemy name will always be visible.
 * Medium priority.
 * @default false
 *
 * @param NameAsTarget:eval
 * @text As Target
 * @parent NameVisibility
 * @type boolean
 * @on Visible As Target
 * @off No Priority
 * @desc Shows enemy name when enemy is a target.
 * Medium priority.
 * @default true
 *
 * @param NameAlwaysSelectOnly:eval
 * @text By Selection?
 * @parent NameVisibility
 * @type boolean
 * @on Visible when Selected
 * @off Visible when Targeting
 * @desc Determines the conditions for enemy name visibility.
 * Lowest priority.
 * @default false
 *
 * @param NameDamageVisibility:num
 * @text Temporary Visibility
 * @parent NameVisibility
 * @type number
 * @desc Number of frames enemy's name temporarily visible after
 * taking an action effect in battle. 60 frames = 1 second.
 * @default 0
 *
 * @param SvBattlers
 * @text Sideview Battlers
 *
 * @param AllowCollapse:eval
 * @text Allow Collapse
 * @parent SvBattlers
 * @type boolean
 * @on Allow
 * @off Don't
 * @desc Causes defeated enemies with SV Battler graphics
 * to "fade away" when defeated?
 * @default false
 *
 * @param AnchorX:num
 * @text Anchor: X
 * @parent SvBattlers
 * @desc Default X anchor for Sideview Battlers.
 * Use values between 0 and 1 to be safe.
 * @default 0.5
 *
 * @param AnchorY:num
 * @text Anchor: Y
 * @parent SvBattlers
 * @desc Default Y anchor for Sideview Battlers.
 * Use values between 0 and 1 to be safe.
 * @default 1.0
 *
 * @param MotionIdle:str
 * @text Motion: Idle
 * @parent SvBattlers
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Sets default idle animation used by Sideview Battlers.
 * @default walk
 *
 * @param Shadow:eval
 * @text Shadow Visible
 * @parent SvBattlers
 * @type boolean
 * @on Visible
 * @off Hidden
 * @desc Show or hide the shadow for Sideview Battlers.
 * @default true
 *
 * @param Width:num
 * @text Size: Width
 * @parent SvBattlers
 * @type number
 * @min 1
 * @desc Default width for enemies that use Sideview Battlers.
 * @default 64
 *
 * @param Height:num
 * @text Size: Height
 * @parent SvBattlers
 * @type number
 * @min 1
 * @desc Default height for enemies that use Sideview Battlers.
 * @default 64
 *
 * @param WtypeId:num
 * @text Weapon Type
 * @parent SvBattlers
 * @type number
 * @min 0
 * @desc Sets default weapon type used by Sideview Battlers.
 * Use 0 for Bare Hands.
 * @default 0
 *
 */
/* ----------------------------------------------------------------------------
 * HP Gauge Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~HpGauge:
 *
 * @param Display
 * @text Show Gauges For
 *
 * @param ShowActorGauge:eval
 * @text Actors
 * @parent Display
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show HP Gauges over the actor sprites' heads?
 * Requires SV Actors to be visible.
 * @default true
 *
 * @param ShowEnemyGauge:eval
 * @text Enemies
 * @parent Display
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show HP Gauges over the enemy sprites' heads?
 * Can be bypassed with <Hide HP Gauge> notetag.
 * @default true
 *
 * @param RequiresDefeat:eval
 * @text Requires Defeat?
 * @parent ShowEnemyGauge:eval
 * @type boolean
 * @on Require Defeat First
 * @off No Requirement
 * @desc Requires defeating the enemy once to show HP Gauge?
 * Can be bypassed with <Show HP Gauge> notetag.
 * @default true
 *
 * @param BTestBypass:eval
 * @text Battle Test Bypass?
 * @parent RequiresDefeat:eval
 * @type boolean
 * @on Bypass
 * @off Don't Bypass
 * @desc Bypass the defeat requirement in battle test?
 * @default true
 *
 * @param Settings
 *
 * @param AniDuration:num
 * @text Animation Duration
 * @parent Settings
 * @type number
 * @min 1
 * @desc How many frames should gauges animate themselves?
 * Default: 20 frames.
 * @default 20
 *
 * @param AnchorX:num
 * @text Anchor X
 * @parent Settings
 * @desc Where do you want the HP Gauge sprite's anchor X to be?
 * Use values between 0 and 1 to be safe.
 * @default 0.5
 *
 * @param AnchorY:num
 * @text Anchor Y
 * @parent Settings
 * @desc Where do you want the HP Gauge sprite's anchor Y to be?
 * Use values between 0 and 1 to be safe.
 * @default 1.0
 *
 * @param Scale:num
 * @text Scale
 * @parent Settings
 * @desc How large/small do you want the HP Gauge to be scaled?
 * @default 0.5
 *
 * @param OffsetX:num
 * @text Offset X
 * @parent Settings
 * @desc How many pixels to offset the HP Gauge's X by?
 * @default 0
 *
 * @param OffsetY:num
 * @text Offset Y
 * @parent Settings
 * @desc How many pixels to offset the HP Gauge's Y by?
 * @default -3
 *
 * @param Options
 * @text Options
 *
 * @param AddHpGaugeOption:eval
 * @text Add Option?
 * @parent Options
 * @type boolean
 * @on Add
 * @off Don't Add
 * @desc Add the 'Show HP Gauge' option to the Options menu?
 * @default true
 *
 * @param AdjustRect:eval
 * @text Adjust Window Height
 * @parent Options
 * @type boolean
 * @on Adjust
 * @off Don't
 * @desc Automatically adjust the options window height?
 * @default true
 *
 * @param Name:str
 * @text Option Name
 * @parent Options
 * @desc Command name of the option.
 * @default Show HP Gauge
 *
 */
/* ----------------------------------------------------------------------------
 * Action Sequence Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ActionSequence:
 *
 * @param AutoSequences
 * @text Automatic Sequences
 *
 * @param AutoMeleeSolo:eval
 * @text Melee Single Target
 * @parent AutoSequences
 * @type boolean
 * @on Allow
 * @off Ignore
 * @desc Allow this auto sequence for physical, single target actions?
 * @default true
 *
 * @param AutoMeleeAoE:eval
 * @text Melee Multi Target
 * @parent AutoSequences
 * @type boolean
 * @on Allow
 * @off Ignore
 * @desc Allow this auto sequence for physical, multi-target actions?
 * @default true
 *
 * @param QoL
 * @text Quality of Life
 *
 * @param AutoNotetag:eval
 * @text Auto Notetag
 * @parent QoL
 * @type boolean
 * @on Automatic
 * @off Manual
 * @desc Automatically apply the <Custom Action Sequence> notetag
 * effect to any item or skill that has a Common Event?
 * @default false
 *
 * @param CastAnimations
 * @text Cast Animations
 *
 * @param CastCertain:num
 * @text Certain Hit
 * @parent CastAnimations
 * @type animation
 * @desc Cast animation for Certain Hit skills.
 * @default 120
 *
 * @param CastPhysical:num
 * @text Physical
 * @parent CastAnimations
 * @type animation
 * @desc Cast animation for Physical skills.
 * @default 52
 *
 * @param CastMagical:num
 * @text Magical
 * @parent CastAnimations
 * @type animation
 * @desc Cast animation for Magical skills.
 * @default 51
 *
 * @param CounterReflection
 * @text Counter/Reflect
 *
 * @param CounterPlayback:eval
 * @text Counter Back
 * @parent CounterReflection
 * @type boolean
 * @on Play Back
 * @off Ignore
 * @desc Play back the attack animation used?
 * @default true
 *
 * @param ReflectAnimation:num
 * @text Reflect Animation
 * @parent CounterReflection
 * @type animation
 * @desc Animation played when an action is reflected.
 * @default 53
 *
 * @param ReflectPlayback:eval
 * @text Reflect Back
 * @parent CounterReflection
 * @type boolean
 * @on Play Back
 * @off Ignore
 * @desc Play back the attack animation used?
 * @default true
 *
 * @param Stepping
 *
 * @param MeleeDistance:num
 * @text Melee Distance
 * @parent Stepping
 * @desc Minimum distance in pixels for Movement Action Sequences.
 * @default 24
 *
 * @param StepDistanceX:num
 * @text Step Distance X
 * @parent Stepping
 * @desc The normal X distance when stepping forward.
 * @default 48
 *
 * @param StepDistanceY:num
 * @text Step Distance Y
 * @parent Stepping
 * @desc The normal Y distance when stepping forward.
 * @default 0
 *
 * @param StepDuration:num
 * @text Step Duration
 * @parent Stepping
 * @desc The number of frames for a stepping action to complete.
 * @default 12
 *
 */
/* ----------------------------------------------------------------------------
 * Projectile Start Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ProjectileStart:
 * 
 * @param Type:str
 * @text Type
 * @type select
 * @option Target - Start from battler target(s)
 * @value target
 * @option Point - Start from a point on the screen
 * @value point
 * @desc Select where the projectile should start from.
 * @default target
 * 
 * @param Targets:arraystr
 * @text Target(s)
 * @parent Type:str
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to start the projectile from.
 * @default ["user"]
 * 
 * @param TargetCenter:eval
 * @text Centralize
 * @parent Targets:arraystr
 * @type boolean
 * @on Center Projectile
 * @off Create Each
 * @desc Create one projectile at the center of the targets?
 * Or create a projectile for each target?
 * @default false
 * 
 * @param TargetLocation:str
 * @text Target Location
 * @parent Targets:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part of the target to send the projectile from.
 * @default middle center
 * 
 * @param PointX:eval
 * @text Point X
 * @parent Type:str
 * @desc Insert the X coordinate to start the projectile at.
 * You may use JavaScript code.
 * @default Graphics.width / 2
 * 
 * @param PointY:eval
 * @text Point Y
 * @parent Type:str
 * @desc Insert the Y coordinate to start the projectile at.
 * You may use JavaScript code.
 * @default Graphics.height / 2
 * 
 * @param OffsetX:eval
 * @text Offset X
 * @desc Insert how many pixels to offset the X coordinate by.
 * You may use JavaScript code.
 * @default +0
 * 
 * @param OffsetY:eval
 * @text Offset Y
 * @desc Insert how many pixels to offset the Y coordinate by.
 * You may use JavaScript code.
 * @default +0
 *
 */
/* ----------------------------------------------------------------------------
 * Projectile Goal Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ProjectileGoal:
 * 
 * @param Type:str
 * @text Type
 * @type select
 * @option Target - Goal is battler target(s)
 * @value target
 * @option Point - Goal is a point on the screen
 * @value point
 * @desc Select where the projectile should go to.
 * @default target
 * 
 * @param Targets:arraystr
 * @text Target(s)
 * @parent Type:str
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) for projectile to go to.
 * @default ["all targets"]
 * 
 * @param TargetCenter:eval
 * @text Centralize
 * @parent Targets:arraystr
 * @type boolean
 * @on Center Projectile
 * @off Create Each
 * @desc Set goal in the center of targets?
 * Or create a projectile to go to each target?
 * @default false
 * 
 * @param TargetLocation:str
 * @text Target Location
 * @parent Targets:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part of the target to send the projectile at.
 * @default middle center
 * 
 * @param PointX:eval
 * @text Point X
 * @parent Type:str
 * @desc Insert the X coordinate to send the projectile to.
 * You may use JavaScript code.
 * @default Graphics.width / 2
 * 
 * @param PointY:eval
 * @text Point Y
 * @parent Type:str
 * @desc Insert the Y coordinate to send the projectile to.
 * You may use JavaScript code.
 * @default Graphics.height / 2
 * 
 * @param OffsetX:eval
 * @text Offset X
 * @desc Insert how many pixels to offset the X coordinate by.
 * You may use JavaScript code.
 * @default +0
 * 
 * @param OffsetY:eval
 * @text Offset Y
 * @desc Insert how many pixels to offset the Y coordinate by.
 * You may use JavaScript code.
 * @default +0
 *
 */
/* ----------------------------------------------------------------------------
 * Projectile Extra Animation Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ProjectileExAni:
 * 
 * @param AutoAngle:eval
 * @text Auto Angle?
 * @parent Settings
 * @type boolean
 * @on Automatically Angle
 * @off Normal
 * @desc Automatically angle the projectile to tilt the direction it's moving?
 * @default true
 * 
 * @param AngleOffset:eval
 * @text Angle Offset
 * @desc Alter the projectile's tilt by this many degrees.
 * @default +0
 * 
 * @param Arc:eval
 * @text Arc Peak
 * @parent Settings
 * @desc This is the height of the projectile's trajectory arc
 * in pixels.
 * @default 0
 *
 * @param EasingType:str
 * @text Easing
 * @parent Settings
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type to apply to the projectile's trajectory.
 * @default Linear
 * 
 * @param Spin:eval
 * @text Spin Speed
 * @parent Settings
 * @desc Determine how much angle the projectile spins per frame.
 * Does not work well with "Auto Angle".
 * @default +0.0
 * 
 * @param Emulate
 * @text Effect Emulation
 * 
 * @param EmulateActionEffect:eval
 * @text Action Effect?
 * @parent Emulate
 * @type boolean
 * @on Emulate
 * @off Don't Emulate
 * @desc Emulate current Action Effect when projectile reaches
 * target? Only works with start/goal targets.
 * @default false
 * 
 * @param EmulateItemEffect:eval
 * @text Item Effect ID
 * @parent Emulate
 * @type item
 * @desc Emulate an Item Effect when projectile reaches target?
 * Use 0 to not use. Only works with start/goal targets.
 * @default 0
 * 
 * @param EmulateSkillEffect:eval
 * @text Skill Effect ID
 * @parent Emulate
 * @type skill
 * @desc Emulate a Skill Effect when projectile reaches target?
 * Use 0 to not use. Only works with start/goal targets.
 * @default 0
 *
 * @param OnceParallel:num
 * @text Common Event ID
 * @parent Emulate
 * @type common_event
 * @desc Plays a Once Parallel Common Event upon reaching target.
 * Use 0 to not use. Works regardless of start/goal targets.
 * @default 0
 *
 */
/* ----------------------------------------------------------------------------
 * Projectile Extra Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ProjectileExtra:
 * 
 * @param AutoAngle:eval
 * @text Auto Angle?
 * @parent Settings
 * @type boolean
 * @on Automatically Angle
 * @off Normal
 * @desc Automatically angle the projectile to tilt the direction it's moving?
 * @default true
 * 
 * @param AngleOffset:eval
 * @text Angle Offset
 * @desc Alter the projectile's tilt by this many degrees.
 * @default +0
 * 
 * @param Arc:eval
 * @text Arc Peak
 * @parent Settings
 * @desc This is the height of the projectile's trajectory arc
 * in pixels.
 * @default 0
 *
 * @param BlendMode:num
 * @text Blend Mode
 * @type select
 * @option 0 - Normal
 * @value 0
 * @option 1 - Additive
 * @value 1
 * @option 2 - Multiply
 * @value 2
 * @option 3 - Screen
 * @value 3
 * @desc What kind of blend mode do you wish to apply to the projectile?
 * @default 0
 *
 * @param EasingType:str
 * @text Easing
 * @parent Settings
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type to apply to the projectile's trajectory.
 * @default Linear
 * 
 * @param Hue:eval
 * @text Hue
 * @parent Settings
 * @desc Adjust the hue of the projectile.
 * Insert a number between 0 and 360.
 * @default 0
 * 
 * @param Scale:eval
 * @text Scale
 * @parent Settings
 * @desc Adjust the size scaling of the projectile.
 * Use decimals for exact control.
 * @default 1.0
 * 
 * @param Spin:eval
 * @text Spin Speed
 * @parent Settings
 * @desc Determine how much angle the projectile spins per frame.
 * Does not work well with "Auto Angle".
 * @default +0.0
 * 
 * @param Emulate
 * @text Effect Emulation
 * 
 * @param EmulateActionEffect:eval
 * @text Action Effect?
 * @parent Emulate
 * @type boolean
 * @on Emulate
 * @off Don't Emulate
 * @desc Emulate current Action Effect when projectile reaches
 * target? Only works with start/goal targets.
 * @default false
 * 
 * @param EmulateItemEffect:eval
 * @text Item Effect ID
 * @parent Emulate
 * @type item
 * @desc Emulate an Item Effect when projectile reaches target?
 * Use 0 to not use. Only works with start/goal targets.
 * @default 0
 * 
 * @param EmulateSkillEffect:eval
 * @text Skill Effect ID
 * @parent Emulate
 * @type skill
 * @desc Emulate a Skill Effect when projectile reaches target?
 * Use 0 to not use. Only works with start/goal targets.
 * @default 0
 *
 * @param OnceParallel:num
 * @text Common Event ID
 * @parent Emulate
 * @type common_event
 * @desc Plays a Once Parallel Common Event upon reaching target.
 * Use 0 to not use. Works regardless of start/goal targets.
 * @default 0
 *
 */
/* ----------------------------------------------------------------------------
 * Visual Cutin Effect Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~VisualCutinEffect:
 *
 * @param Transition
 * 
 * @param enterDuration:num
 * @text Entrance Duration
 * @parent Transition
 * @type number
 * @desc How many frames does it take to fully enter?
 * Used when a Visual Cutin Effect starts.
 * @default 12
 * 
 * @param exitDuration:num
 * @text Exit Duration
 * @parent Transition
 * @type number
 * @desc How many frames does it take to fully exit?
 * Used when a Visual Cutin Effect ends.
 * @default 12
 *
 * @param Cutin
 * @text Cutin Settings
 *
 * @param bgShow:eval
 * @text Show BG Color?
 * @parent Cutin
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Add a background color for this cutin?
 * Background colors appear behind the parallax.
 * @default true
 *
 * @param outlineShow:eval
 * @text Show Outline?
 * @parent Cutin
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show the cutin outline?
 * @default true
 *
 * @param Portrait
 * @text Portrait Settings
 *
 * @param PortraitBase
 * @text Base Properties
 * @parent Portrait
 * 
 * @param portraitAnchorX:num
 * @text Anchor X
 * @parent PortraitBase
 * @desc Determines the sprite anchor X alignment.
 * 0.0: Left, 0.5: Center, 1.0: Right.
 * @default 0.5
 * 
 * @param portraitAnchorY:num
 * @text Anchor Y
 * @parent PortraitBase
 * @desc Determines the sprite anchor Y alignment.
 * 0.0: Top, 0.5: Middle, 1.0: Bottom.
 * @default 0.5
 *
 * @param portraitHue:num
 * @text Hue
 * @parent PortraitBase
 * @type number
 * @min 0
 * @max 360
 * @desc Do you wish to adjust this cutin's portrait hue?
 * @default 0
 * 
 * @param portraitOpacity:num
 * @text Opacity
 * @parent PortraitBase
 * @type number
 * @max 255
 * @desc What is the opacity level of this cutin's portrait?
 * @default 255
 * 
 * @param portraitOffsetX:num
 * @text Offset X
 * @parent PortraitBase
 * @desc Offsets the cutin portrait's X location.
 * Negative: left. Positive: right.
 * @default +0
 * 
 * @param portraitOffsetY:num
 * @text Offset Y
 * @parent PortraitBase
 * @desc Offsets the cutin portrait's Y location.
 * Negative: up. Positive: down.
 * @default +0
 *
 * @param PortraitEnter
 * @text Entrance Properties
 * @parent Portrait
 * 
 * @param portraitEnterX:num
 * @text Entrance X
 * @parent PortraitEnter
 * @desc Sets the cutin portrait's X entrance.
 * Negative: from left. Positive: from right.
 * @default +0
 * 
 * @param portraitEnterY:num
 * @text Entrance Y
 * @parent PortraitEnter
 * @desc Sets the cutin portrait's Y entrance.
 * Negative: from up. Positive: from down.
 * @default +0
 *
 * @param portraitEnterEasingType:str
 * @text Entrance Easing
 * @parent PortraitEnter
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default InOutSine
 *
 * @param PortraitExit
 * @text Exit Properties
 * @parent Portrait
 * 
 * @param portraitExitX:num
 * @text Exit X
 * @parent PortraitExit
 * @desc Sets the cutin portrait's X exit.
 * Negative: to left. Positive: to right.
 * @default +0
 * 
 * @param portraitExitY:num
 * @text Exit Y
 * @parent PortraitExit
 * @desc Sets the cutin portrait's Y exit.
 * Negative: to up. Positive: to down.
 * @default +0
 *
 * @param portraitExitEasingType:str
 * @text Exit Easing
 * @parent PortraitExit
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default InOutSine
 *
 * @param PortraitFlip
 * @text Flip Properties
 * @parent Portrait
 *
 * @param portraitFlipHorz:eval
 * @text Flip Horizontally?
 * @parent PortraitFlip
 * @type boolean
 * @on Flip
 * @off Don't Flip
 * @desc Flip the cutin portrait horizontally?
 * @default false
 *
 * @param portraitFlipVert:eval
 * @text Flip Vertically?
 * @parent PortraitFlip
 * @type boolean
 * @on Flip
 * @off Don't Flip
 * @desc Flip the cutin portrait vertically?
 * @default false
 *
 * @param PortraitScale
 * @text Scaling Properties
 * @parent Portrait
 * 
 * @param portraitForcedScale:num
 * @text Forced Scaling
 * @parent PortraitScale
 * @desc Do you want to force a scaling ratio?
 * Leave as 0 for none. Disables "Fit to Scale?".
 * @default 0.0
 *
 * @param portraitScaleToFit:eval
 * @text Fit to Scale?
 * @parent PortraitScale
 * @type boolean
 * @on Fit to Scale
 * @off Don't Scale
 * @desc Scale the cutin portrait to fit the cutin style?
 * Cannot be used with "Forced Scaling".
 * @default true
 *
 * @param portraitScaleMax:eval
 * @text Scale Max?
 * @parent portraitScaleToFit:eval
 * @type boolean
 * @on Scale Maximum
 * @off Scale Minimum
 * @desc Scale the cutin portrait to the maximum fit or
 * scale the cutin portrait to the minimum fit.
 * @default false
 *
 * @param PortraitAni
 * @text Animated Portraits
 * @parent Portrait
 *
 * @param animatedPortraitLooping:eval
 * @text Loop?
 * @parent PortraitAni
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Will loop back to beginning once ended.
 * Requires VisuMZ_4_AnimatedPictures!
 * @default true
 *
 * @param animatedPortraitWaitFrames:num
 * @text Wait Frames
 * @parent PortraitAni
 * @type number
 * @min 1
 * @desc Frames to wait before moving to next cell.
 * Requires VisuMZ_4_AnimatedPictures!
 * @default 4
 *
 * @param Parallax
 * @text Parallax Settings
 *
 * @param ParallaxBase
 * @text Base Settings
 * @parent Parallax
 *
 * @param parallaxBlendMode:num
 * @text Blend Mode
 * @parent ParallaxBase
 * @type select
 * @option 0 - Normal
 * @value 0
 * @option 1 - Additive
 * @value 1
 * @option 2 - Multiply
 * @value 2
 * @option 3 - Screen
 * @value 3
 * @desc What kind of blend mode do you wish to apply to the cutin?
 * @default 0
 *
 * @param parallaxHue:num
 * @text Hue
 * @parent ParallaxBase
 * @type number
 * @min 0
 * @max 360
 * @desc Do you wish to adjust this cutin's parallax hue?
 * @default 0
 *
 * @param parallaxHueEnemyModifier:num
 * @text Enemy Modifier
 * @parent parallaxHue:num
 * @desc Adjust the hue value by this if the cutin target is an enemy.
 * @default +0
 * 
 * @param parallaxOpacity:num
 * @text Opacity
 * @parent ParallaxBase
 * @type number
 * @max 255
 * @desc What is the opacity level of this cutin's parallax?
 * @default 255
 *
 * @param ParallaxScroll
 * @text Scrolling Settings
 * @parent Parallax
 * 
 * @param parallaxOffsetX:num
 * @text Offset X
 * @parent ParallaxScroll
 * @desc Offsets the cutin parallax's X location.
 * Negative: left. Positive: right.
 * @default +0.0
 * 
 * @param parallaxOffsetY:num
 * @text Offset Y
 * @parent ParallaxScroll
 * @desc Offsets the cutin parallax's Y location.
 * Negative: up. Positive: down.
 * @default +0.0
 * 
 * @param parallaxScrollX:num
 * @text Scroll X
 * @parent ParallaxScroll
 * @desc How many pixels does the parallax scroll horizontally?
 * Negative: Scroll to right. Positive: Scroll to left.
 * @default +0.0
 *
 * @param parallaxScrollXinvertEnemy:eval
 * @text Invert for Enemy?
 * @parent parallaxScrollX:num
 * @type boolean
 * @on Invert
 * @off Don't Invert
 * @desc Invert the X scroll direction if the cutin target is an enemy?
 * @default false
 * 
 * @param parallaxScrollY:num
 * @text Scroll Y
 * @parent ParallaxScroll
 * @desc How many pixels does the parallax scroll vertically?
 * Negative: Scroll to down. Positive: Scroll to up.
 * @default +0.0
 *
 * @param parallaxScrollYinvertEnemy:eval
 * @text Invert for Enemy?
 * @parent parallaxScrollY:num
 * @type boolean
 * @on Invert
 * @off Don't Invert
 * @desc Invert the Y scroll direction if the cutin target is an enemy?
 * @default false
 *
 */
//=============================================================================

const _0xe90fac=_0x5c2f;(function(_0x26777e,_0x4d6911){const _0x59131e=_0x5c2f,_0x5835a6=_0x26777e();while(!![]){try{const _0x3410fb=-parseInt(_0x59131e(0x46a))/(0x1*0x103d+0x269d*0x1+-0x36d9)+parseInt(_0x59131e(0xbce))/(0x480+-0x40c*0x2+0x39a)+parseInt(_0x59131e(0x12a7))/(-0x4d9*0x5+-0x502+0x1d42)*(parseInt(_0x59131e(0x1b2))/(-0xb3d+0x1757+0xdd*-0xe))+-parseInt(_0x59131e(0x62d))/(0xa39*-0x1+-0x2*-0xe8b+0x9*-0x218)*(-parseInt(_0x59131e(0x906))/(0x9e9+0x1b24+0x2507*-0x1))+-parseInt(_0x59131e(0xf69))/(-0x61f*0x2+-0x1162+0x1da7*0x1)*(-parseInt(_0x59131e(0x2e3))/(0x13bb+-0x1510*0x1+-0x1*-0x15d))+-parseInt(_0x59131e(0x11b1))/(-0x53*0x67+0x5c2+0x1bac)*(parseInt(_0x59131e(0x12eb))/(0x10ff+0x1*-0x8d3+-0x411*0x2))+parseInt(_0x59131e(0x1305))/(0x4*-0x182+-0x1*0x10e1+-0x5bd*-0x4);if(_0x3410fb===_0x4d6911)break;else _0x5835a6['push'](_0x5835a6['shift']());}catch(_0x441fd1){_0x5835a6['push'](_0x5835a6['shift']());}}}(_0x84f8,0x893ad*0x1+0x81fa0+-0xb2ef1));var label=_0xe90fac(0x118f),tier=tier||-0x8b*-0x34+-0xfec*0x1+-0xc50,dependencies=[],pluginData=$plugins[_0xe90fac(0x55f)](function(_0x2f6b56){const _0x53d2ad=_0xe90fac,_0x470ccd={'PkNKj':function(_0x2c3b41,_0x3d1410){return _0x2c3b41+_0x3d1410;}};return _0x2f6b56[_0x53d2ad(0x211)]&&_0x2f6b56[_0x53d2ad(0x8ce)+'n'][_0x53d2ad(0x79c)](_0x470ccd[_0x53d2ad(0x17c)](_0x470ccd['PkNKj']('[',label),']'));})[-0x1ab7+0x1139+0x97e];VisuMZ[label]['Settings']=VisuMZ[label][_0xe90fac(0x281)]||{},VisuMZ[_0xe90fac(0x15ae)+'ams']=function(_0x2b9ecf,_0x55d6fb){const _0x1d5df1=_0xe90fac,_0x2439ed={'gWwcs':function(_0x5c5141,_0x53a6b7){return _0x5c5141(_0x53a6b7);},'mfGqv':'NUM','PRnAK':function(_0x4dfed7,_0x26ccd2){return _0x4dfed7!==_0x26ccd2;},'nhxDo':function(_0x5d638e,_0xa228d2){return _0x5d638e(_0xa228d2);},'hsZlj':_0x1d5df1(0xb67),'DwlAc':function(_0x1e0b6d,_0xbab1e6){return _0x1e0b6d!==_0xbab1e6;},'WzUsr':'EVAL','muXBp':function(_0x2e2434,_0x501d6e){return _0x2e2434(_0x501d6e);},'eDZJX':_0x1d5df1(0x1b5),'paSHB':function(_0xc2ae10,_0x107ed1){return _0xc2ae10!==_0x107ed1;},'GHzaa':_0x1d5df1(0xe92),'OHhlT':function(_0x5e81d1,_0x4ee7de){return _0x5e81d1!==_0x4ee7de;},'PVJdf':_0x1d5df1(0x3b4),'eMKqF':'FUNC','BFThx':_0x1d5df1(0xdb7),'PzJfm':_0x1d5df1(0xb16),'LFGir':function(_0x4fb8d5,_0x1488d4){return _0x4fb8d5!==_0x1488d4;},'CFfVt':_0x1d5df1(0xcba),'rDDgm':_0x1d5df1(0x1261),'xLisn':function(_0x30d7b5,_0x4799d3){return _0x30d7b5!==_0x4799d3;},'bLgVc':_0x1d5df1(0x28b),'WXyrx':function(_0x435034,_0x4ef872){return _0x435034!==_0x4ef872;},'eiqWX':_0x1d5df1(0x1230)+'T','gZMEI':function(_0x4b78fe,_0x4f3fd9){return _0x4b78fe!==_0x4f3fd9;}};for(const _0x593bb4 in _0x55d6fb){if(_0x593bb4['match'](/(.*):(.*)/i)){const _0xeb5ecd=_0x2439ed[_0x1d5df1(0x15e8)](String,RegExp['$1']),_0xa6371b=_0x2439ed[_0x1d5df1(0x15e8)](String,RegExp['$2'])[_0x1d5df1(0x1318)+'e']()[_0x1d5df1(0x808)]();let _0x2845fa,_0x318a63,_0x4a77ae;switch(_0xa6371b){case _0x2439ed[_0x1d5df1(0x2f5)]:_0x2845fa=_0x2439ed[_0x1d5df1(0x90c)](_0x55d6fb[_0x593bb4],'')?_0x2439ed[_0x1d5df1(0xa94)](Number,_0x55d6fb[_0x593bb4]):-0x14f5+0x1*0xc83+0x872;break;case _0x2439ed[_0x1d5df1(0x1514)]:_0x318a63=_0x2439ed['DwlAc'](_0x55d6fb[_0x593bb4],'')?JSON[_0x1d5df1(0x119c)](_0x55d6fb[_0x593bb4]):[],_0x2845fa=_0x318a63[_0x1d5df1(0x457)](_0x28166d=>Number(_0x28166d));break;case _0x2439ed[_0x1d5df1(0xf7c)]:_0x2845fa=_0x2439ed['PRnAK'](_0x55d6fb[_0x593bb4],'')?_0x2439ed[_0x1d5df1(0x1512)](eval,_0x55d6fb[_0x593bb4]):null;break;case _0x2439ed[_0x1d5df1(0x57d)]:_0x318a63=_0x2439ed[_0x1d5df1(0x379)](_0x55d6fb[_0x593bb4],'')?JSON[_0x1d5df1(0x119c)](_0x55d6fb[_0x593bb4]):[],_0x2845fa=_0x318a63[_0x1d5df1(0x457)](_0x4192fb=>eval(_0x4192fb));break;case _0x2439ed[_0x1d5df1(0x827)]:_0x2845fa=_0x2439ed[_0x1d5df1(0x25c)](_0x55d6fb[_0x593bb4],'')?JSON['parse'](_0x55d6fb[_0x593bb4]):'';break;case _0x2439ed[_0x1d5df1(0xe3a)]:_0x318a63=_0x2439ed[_0x1d5df1(0xf20)](_0x55d6fb[_0x593bb4],'')?JSON['parse'](_0x55d6fb[_0x593bb4]):[],_0x2845fa=_0x318a63[_0x1d5df1(0x457)](_0x256179=>JSON['parse'](_0x256179));break;case _0x2439ed[_0x1d5df1(0x1491)]:_0x2845fa=_0x2439ed[_0x1d5df1(0x90c)](_0x55d6fb[_0x593bb4],'')?new Function(JSON['parse'](_0x55d6fb[_0x593bb4])):new Function(_0x2439ed[_0x1d5df1(0x417)]);break;case _0x2439ed[_0x1d5df1(0x12a6)]:_0x318a63=_0x2439ed[_0x1d5df1(0xa7e)](_0x55d6fb[_0x593bb4],'')?JSON['parse'](_0x55d6fb[_0x593bb4]):[],_0x2845fa=_0x318a63[_0x1d5df1(0x457)](_0x90635c=>new Function(JSON[_0x1d5df1(0x119c)](_0x90635c)));break;case _0x2439ed[_0x1d5df1(0xfb6)]:_0x2845fa=_0x2439ed[_0x1d5df1(0xa7e)](_0x55d6fb[_0x593bb4],'')?_0x2439ed[_0x1d5df1(0x1512)](String,_0x55d6fb[_0x593bb4]):'';break;case _0x2439ed[_0x1d5df1(0xabc)]:_0x318a63=_0x2439ed[_0x1d5df1(0x11d0)](_0x55d6fb[_0x593bb4],'')?JSON['parse'](_0x55d6fb[_0x593bb4]):[],_0x2845fa=_0x318a63[_0x1d5df1(0x457)](_0x4b2329=>String(_0x4b2329));break;case _0x2439ed[_0x1d5df1(0xf5a)]:_0x4a77ae=_0x2439ed['WXyrx'](_0x55d6fb[_0x593bb4],'')?JSON[_0x1d5df1(0x119c)](_0x55d6fb[_0x593bb4]):{},_0x2b9ecf[_0xeb5ecd]={},VisuMZ[_0x1d5df1(0x15ae)+_0x1d5df1(0xe3)](_0x2b9ecf[_0xeb5ecd],_0x4a77ae);continue;case _0x2439ed[_0x1d5df1(0xdc)]:_0x318a63=_0x2439ed['gZMEI'](_0x55d6fb[_0x593bb4],'')?JSON[_0x1d5df1(0x119c)](_0x55d6fb[_0x593bb4]):[],_0x2845fa=_0x318a63[_0x1d5df1(0x457)](_0x5cf648=>VisuMZ['ConvertPar'+'ams']({},JSON[_0x1d5df1(0x119c)](_0x5cf648)));break;default:continue;}_0x2b9ecf[_0xeb5ecd]=_0x2845fa;}}return _0x2b9ecf;},(_0x4646a0=>{const _0x3ddda8=_0xe90fac,_0x21c37f={'dppvm':function(_0x6e6ede,_0x13a2e7){return _0x6e6ede(_0x13a2e7);},'tzYpc':_0x3ddda8(0xf95)+'ing\x20a\x20requ'+'ired\x20plugi'+_0x3ddda8(0x13a0)+_0x3ddda8(0x1563)+'\x20into\x20the\x20'+_0x3ddda8(0x1150)+_0x3ddda8(0xaca),'dpjEi':function(_0xe9ec8d,_0xe3f093){return _0xe9ec8d(_0xe3f093);},'FThyL':function(_0x3f40c2,_0x1095b8){return _0x3f40c2!==_0x1095b8;},'qiAVt':function(_0x1abd9a,_0x4be8fe){return _0x1abd9a(_0x4be8fe);},'NPVuB':_0x3ddda8(0x8a2)+_0x3ddda8(0x15d5)+_0x3ddda8(0x1ad)+'ugin\x27s.\x20Pl'+'ease\x20updat'+'e\x20it\x20in\x20th'+_0x3ddda8(0xb43)+'anager.','kevPC':function(_0xce098a,_0x2b2811){return _0xce098a<_0x2b2811;},'jKLba':function(_0x21ebe5,_0x533ae9){return _0x21ebe5(_0x533ae9);},'vNwdf':'%1\x20is\x20inco'+_0x3ddda8(0x7af)+_0x3ddda8(0xe50)+_0x3ddda8(0x10c7)+_0x3ddda8(0x2f0)+_0x3ddda8(0x850)+_0x3ddda8(0x69a)+_0x3ddda8(0xbc0)+_0x3ddda8(0xed5)+_0x3ddda8(0x963)+'s.\x0aPlease\x20'+_0x3ddda8(0x86a)+_0x3ddda8(0x10c7)+_0x3ddda8(0x119)+_0x3ddda8(0x552)+_0x3ddda8(0x11cf)+_0x3ddda8(0xc0f)+'s.'},_0x1abf78=_0x4646a0[_0x3ddda8(0x14c)];for(const _0x25f631 of dependencies){if(!Imported[_0x25f631]){_0x21c37f[_0x3ddda8(0x68f)](alert,_0x21c37f['tzYpc'][_0x3ddda8(0xeb8)](_0x1abf78,_0x25f631)),SceneManager[_0x3ddda8(0x10c0)]();break;}}const _0x402854=_0x4646a0[_0x3ddda8(0x8ce)+'n'];if(_0x402854[_0x3ddda8(0x3eb)](/\[Version[ ](.*?)\]/i)){const _0x2cb545=_0x21c37f[_0x3ddda8(0xb5)](Number,RegExp['$1']);_0x21c37f[_0x3ddda8(0x1166)](_0x2cb545,VisuMZ[label][_0x3ddda8(0x6ca)])&&(_0x21c37f[_0x3ddda8(0x623)](alert,_0x21c37f[_0x3ddda8(0x7c5)][_0x3ddda8(0xeb8)](_0x1abf78,_0x2cb545)),SceneManager[_0x3ddda8(0x10c0)]());}if(_0x402854[_0x3ddda8(0x3eb)](/\[Tier[ ](\d+)\]/i)){const _0x5ae5cd=_0x21c37f[_0x3ddda8(0xb5)](Number,RegExp['$1']);_0x21c37f[_0x3ddda8(0x647)](_0x5ae5cd,tier)?(_0x21c37f[_0x3ddda8(0x1583)](alert,_0x21c37f[_0x3ddda8(0x89b)]['format'](_0x1abf78,_0x5ae5cd,tier)),SceneManager['exit']()):tier=Math[_0x3ddda8(0xd3e)](_0x5ae5cd,tier);}VisuMZ[_0x3ddda8(0x15ae)+_0x3ddda8(0xe3)](VisuMZ[label]['Settings'],_0x4646a0[_0x3ddda8(0x115b)]);})(pluginData),VisuMZ[_0xe90fac(0xd1a)+_0xe90fac(0x12fd)+_0xe90fac(0x1027)]=function(_0x528a11){const _0x566227=_0xe90fac;let _0x16caba=[];for(const _0x24b289 of _0x528a11){_0x16caba=_0x16caba[_0x566227(0x67c)](VisuMZ[_0x566227(0x1412)+'ionSequenc'+'eTarget'](_0x24b289));}return _0x16caba[_0x566227(0x55f)](_0x453667=>_0x453667);},VisuMZ[_0xe90fac(0x1412)+_0xe90fac(0x57c)+'eTarget']=function(_0x5268ba){const _0x31f27a=_0xe90fac,_0xdfa6c4={'pdrtX':function(_0x3e718b,_0xfe2036){return _0x3e718b===_0xfe2036;},'usugc':_0x31f27a(0x14f2),'yPPAQ':'current\x20ta'+_0x31f27a(0xe64),'foJAo':function(_0x2d8b29,_0xe2fa65){return _0x2d8b29===_0xe2fa65;},'UIkAN':'prev\x20targe'+'t','aedHr':function(_0x125070,_0x52e32e){return _0x125070>=_0x52e32e;},'dmIfA':function(_0x20364a,_0x27e9b6){return _0x20364a-_0x27e9b6;},'kudJC':function(_0x75e6ab,_0x244117){return _0x75e6ab===_0x244117;},'RBVCL':_0x31f27a(0x49d)+'t','IHrtl':function(_0x3d7b0c,_0x9b3da6){return _0x3d7b0c>=_0x9b3da6;},'SqFwQ':function(_0x33ca97,_0x33824a){return _0x33ca97+_0x33824a;},'mnFBN':_0x31f27a(0x667)+'s','vcwYJ':function(_0x5c05b5,_0x21080f){return _0x5c05b5===_0x21080f;},'ILxZp':_0x31f27a(0x10d2),'sxGcw':function(_0x45e474,_0x572961){return _0x45e474===_0x572961;},'NmJXe':'not\x20focus','ITtLT':function(_0x4ad332,_0x355fa1){return _0x4ad332===_0x355fa1;},'aUtdb':_0x31f27a(0x178),'eyoZq':function(_0xe29a27,_0x42ce30){return _0xe29a27(_0x42ce30);},'lzGbo':_0x31f27a(0x72c)+_0x31f27a(0x8df),'tVBGu':_0x31f27a(0x72c)+_0x31f27a(0x14e2)+'er','fvRml':_0x31f27a(0x72c)+_0x31f27a(0x1471)+_0x31f27a(0xe64),'aeveU':function(_0x5abb1e,_0xf92ce7){return _0x5abb1e===_0xf92ce7;},'gmOqQ':_0x31f27a(0x9cf)+'ds','UxJvE':function(_0x23b15b,_0x37a3ed){return _0x23b15b(_0x37a3ed);},'MYbdT':function(_0x501a5c,_0xc89dfe){return _0x501a5c===_0xc89dfe;},'ioKhy':'alive\x20oppo'+_0x31f27a(0x15db),'SGvTS':_0x31f27a(0x31c)+_0x31f27a(0x8d4)+_0x31f27a(0xafd),'aCDes':function(_0x1e8e72,_0x2b6b7a){return _0x1e8e72===_0x2b6b7a;},'xntKz':'dead\x20oppon'+_0x31f27a(0x95e),'xJiGm':function(_0x3f7f50,_0x6a7402){return _0x3f7f50(_0x6a7402);},'QtzUx':function(_0x1806c2,_0x20c356){return _0x1806c2===_0x20c356;},'sbbkH':_0x31f27a(0x365)+'rs','mFANJ':'alive\x20acto'+_0x31f27a(0xce)+'r','CIXQT':'alive\x20acto'+_0x31f27a(0x3c7)+_0x31f27a(0x976),'yOISt':'dead\x20actor'+'s','SOcKA':function(_0x5dffd2,_0x31a19a){return _0x5dffd2(_0x31a19a);},'rpfBs':function(_0x23e5d9,_0x566dbc){return _0x23e5d9(_0x566dbc);},'Ouvrt':_0x31f27a(0x1220)+_0x31f27a(0x14c5),'pYGkz':function(_0x24b5e8,_0x29ca76){return _0x24b5e8===_0x29ca76;},'VonSN':'alive\x20enem'+_0x31f27a(0xf25)+'er','hjbRh':function(_0x59a612,_0x4e2b81){return _0x59a612===_0x4e2b81;},'WNYze':_0x31f27a(0x1220)+_0x31f27a(0x13c1)+_0x31f27a(0xe64),'trTWf':_0x31f27a(0xc40)+'es','jiRPM':function(_0x478ac,_0x3b1dff){return _0x478ac(_0x3b1dff);},'FJLRs':_0x31f27a(0x14e0)+_0x31f27a(0x148e),'fnOvv':function(_0x3cd09d,_0x148033){return _0x3cd09d===_0x148033;},'qWimG':_0x31f27a(0x14e0)+_0x31f27a(0xd32)+_0x31f27a(0x2e2),'nCdVH':'alive\x20batt'+_0x31f27a(0xd73)+_0x31f27a(0x915),'aWbqD':function(_0x41a2f1,_0x1c55e7){return _0x41a2f1===_0x1c55e7;},'hNAxE':_0x31f27a(0x12e3)+_0x31f27a(0x446)},_0x64029d=BattleManager['allBattleM'+_0x31f27a(0xcdb)]()[_0x31f27a(0x55f)](_0x8c6934=>_0x8c6934&&_0x8c6934[_0x31f27a(0xe7f)]()),_0x30ab6e=BattleManager[_0x31f27a(0x14c1)],_0x32fd0c=BattleManager[_0x31f27a(0x146b)],_0x4d8c29=BattleManager[_0x31f27a(0xa1c)+'s']?BattleManager[_0x31f27a(0xa1c)+'s'][_0x31f27a(0x77f)](-0x22ae+0x2323+-0x3*0x27):_0x64029d;_0x5268ba=_0x5268ba[_0x31f27a(0x371)+'e']()[_0x31f27a(0x808)]();if(_0xdfa6c4[_0x31f27a(0x238)](_0x5268ba,_0xdfa6c4[_0x31f27a(0xd8e)]))return[_0x30ab6e];else{if(_0xdfa6c4[_0x31f27a(0x238)](_0x5268ba,_0xdfa6c4[_0x31f27a(0x214)]))return[_0x32fd0c];else{if(_0xdfa6c4[_0x31f27a(0xedc)](_0x5268ba,_0xdfa6c4[_0x31f27a(0xd28)])){if(_0x32fd0c){const _0x2ac6b7=_0x4d8c29[_0x31f27a(0x741)](_0x32fd0c);return _0xdfa6c4['aedHr'](_0x2ac6b7,0xd67+-0x1*-0x1312+0x3*-0xad3)?[_0x4d8c29[_0xdfa6c4[_0x31f27a(0x3d4)](_0x2ac6b7,-0xd68+-0x1330+0x2099)]||_0x32fd0c]:[_0x32fd0c];}}else{if(_0xdfa6c4['kudJC'](_0x5268ba,_0xdfa6c4['RBVCL'])){if(_0x32fd0c){const _0xbd4e04=_0x4d8c29[_0x31f27a(0x741)](_0x32fd0c);return _0xdfa6c4[_0x31f27a(0x1202)](_0xbd4e04,0x1855*0x1+-0x60a+0x29d*-0x7)?[_0x4d8c29[_0xdfa6c4[_0x31f27a(0xb50)](_0xbd4e04,-0x19*-0x1+0x1*-0x48+0x30)]||_0x32fd0c]:[_0x32fd0c];}}else{if(_0xdfa6c4[_0x31f27a(0x96a)](_0x5268ba,_0xdfa6c4[_0x31f27a(0xca9)]))return _0x4d8c29;else{if(_0xdfa6c4[_0x31f27a(0xcd7)](_0x5268ba,_0xdfa6c4[_0x31f27a(0x11aa)]))return[_0x30ab6e]['concat'](_0x4d8c29);else{if(_0xdfa6c4[_0x31f27a(0xfc6)](_0x5268ba,_0xdfa6c4[_0x31f27a(0x822)]))return _0x64029d[_0x31f27a(0x55f)](_0x3c562e=>_0x3c562e!==_0x30ab6e&&!_0x4d8c29[_0x31f27a(0x79c)](_0x3c562e)&&_0x3c562e[_0x31f27a(0x1224)+_0x31f27a(0xa58)]());else{if(_0xdfa6c4['ITtLT'](_0x5268ba,_0xdfa6c4['aUtdb']))return[VisuMZ[_0x31f27a(0x335)+_0x31f27a(0x12f)+_0x31f27a(0x7d6)]()];else{if(_0x5268ba['match'](/SPECIAL (.*)>/i)){const _0x1702f1=_0xdfa6c4[_0x31f27a(0x7a8)](String,RegExp['$1'])[_0x31f27a(0xab1)](',')[_0x31f27a(0x457)](_0x548555=>_0x548555['trim']());return[VisuMZ[_0x31f27a(0x335)+_0x31f27a(0x12f)+'cialTarget'+_0x31f27a(0x12c7)](_0x1702f1)];}}}}}}}}}if(_0x30ab6e){if(_0xdfa6c4[_0x31f27a(0xedc)](_0x5268ba,_0xdfa6c4[_0x31f27a(0xf9a)]))return _0x30ab6e['friendsUni'+'t']()['aliveMembe'+'rs']();else{if(_0xdfa6c4['foJAo'](_0x5268ba,_0xdfa6c4[_0x31f27a(0xc82)]))return _0x30ab6e[_0x31f27a(0x2dd)+'t']()[_0x31f27a(0xf79)+'rs']()[_0x31f27a(0x55f)](_0x4529a2=>_0x4529a2!==_0x30ab6e);else{if(_0xdfa6c4['ITtLT'](_0x5268ba,_0xdfa6c4[_0x31f27a(0x502)]))return _0x30ab6e[_0x31f27a(0x2dd)+'t']()[_0x31f27a(0xf79)+'rs']()[_0x31f27a(0x55f)](_0x398270=>_0x398270!==_0x32fd0c);else{if(_0xdfa6c4['aeveU'](_0x5268ba,_0xdfa6c4[_0x31f27a(0x938)]))return _0x30ab6e[_0x31f27a(0x2dd)+'t']()[_0x31f27a(0x104a)+'s']();else{if(_0x5268ba[_0x31f27a(0x3eb)](/FRIEND INDEX (\d+)/i)){const _0x469392=_0xdfa6c4[_0x31f27a(0x1316)](Number,RegExp['$1']);return[_0x30ab6e[_0x31f27a(0x2dd)+'t']()['members']()[_0x469392]];}}}}}if(_0xdfa6c4[_0x31f27a(0x1069)](_0x5268ba,_0xdfa6c4['ioKhy']))return _0x30ab6e['opponentsU'+'nit']()[_0x31f27a(0xf79)+'rs']();else{if(_0xdfa6c4['foJAo'](_0x5268ba,_0xdfa6c4[_0x31f27a(0x1df)]))return _0x30ab6e[_0x31f27a(0xb10)+_0x31f27a(0x14a)]()[_0x31f27a(0xf79)+'rs']()[_0x31f27a(0x55f)](_0x27a934=>_0x27a934!==_0x32fd0c);else{if(_0xdfa6c4[_0x31f27a(0x6a0)](_0x5268ba,_0xdfa6c4['xntKz']))return _0x30ab6e[_0x31f27a(0xb10)+_0x31f27a(0x14a)]()[_0x31f27a(0x104a)+'s']();else{if(_0x5268ba[_0x31f27a(0x3eb)](/OPPONENT INDEX (\d+)/i)){const _0x57905c=_0xdfa6c4[_0x31f27a(0xc66)](Number,RegExp['$1']);return[_0x30ab6e['opponentsU'+_0x31f27a(0x14a)]()[_0x31f27a(0xe13)]()[_0x57905c]];}}}}}if(_0xdfa6c4[_0x31f27a(0x77b)](_0x5268ba,_0xdfa6c4['sbbkH']))return $gameParty[_0x31f27a(0xf79)+'rs']();else{if(_0xdfa6c4['vcwYJ'](_0x5268ba,_0xdfa6c4[_0x31f27a(0x10fc)]))return $gameParty[_0x31f27a(0xf79)+'rs']()[_0x31f27a(0x55f)](_0x2b08ce=>_0x2b08ce!==_0x30ab6e);else{if(_0xdfa6c4[_0x31f27a(0x77b)](_0x5268ba,_0xdfa6c4[_0x31f27a(0xa16)]))return $gameParty[_0x31f27a(0xf79)+'rs']()[_0x31f27a(0x55f)](_0x2c1f57=>_0x2c1f57!==_0x32fd0c);else{if(_0xdfa6c4[_0x31f27a(0x1541)](_0x5268ba,_0xdfa6c4[_0x31f27a(0x436)]))return $gameParty[_0x31f27a(0x104a)+'s']();else{if(_0x5268ba[_0x31f27a(0x3eb)](/ACTOR INDEX (\d+)/i)){const _0x3bc906=_0xdfa6c4[_0x31f27a(0x632)](Number,RegExp['$1']);return[$gameParty[_0x31f27a(0xe13)]()[_0x3bc906]];}else{if(_0x5268ba[_0x31f27a(0x3eb)](/ACTOR ID (\d+)/i)){const _0x505b77=_0xdfa6c4[_0x31f27a(0x12f3)](Number,RegExp['$1']);return[$gameActors[_0x31f27a(0x31d)](_0x505b77)];}}}}}}if(_0xdfa6c4[_0x31f27a(0x1541)](_0x5268ba,_0xdfa6c4[_0x31f27a(0xe07)]))return $gameTroop[_0x31f27a(0xf79)+'rs']();else{if(_0xdfa6c4[_0x31f27a(0xd5)](_0x5268ba,_0xdfa6c4[_0x31f27a(0xbbc)]))return $gameTroop[_0x31f27a(0xf79)+'rs']()[_0x31f27a(0x55f)](_0x34e91e=>_0x34e91e!==_0x30ab6e);else{if(_0xdfa6c4[_0x31f27a(0x11f0)](_0x5268ba,_0xdfa6c4[_0x31f27a(0x883)]))return $gameTroop[_0x31f27a(0xf79)+'rs']()[_0x31f27a(0x55f)](_0x23d9e0=>_0x23d9e0!==_0x32fd0c);else{if(_0xdfa6c4[_0x31f27a(0x96a)](_0x5268ba,_0xdfa6c4[_0x31f27a(0xbbb)]))return $gameTroop[_0x31f27a(0x104a)+'s']();else{if(_0x5268ba[_0x31f27a(0x3eb)](/ENEMY INDEX (\d+)/i)){const _0x148a62=_0xdfa6c4['UxJvE'](Number,RegExp['$1']);return[$gameTroop[_0x31f27a(0xe13)]()[_0x148a62]];}else{if(_0x5268ba[_0x31f27a(0x3eb)](/ENEMY ID (\d+)/i)){const _0x53b571=_0xdfa6c4[_0x31f27a(0xade)](Number,RegExp['$1']);return $gameTroop[_0x31f27a(0xf79)+'rs']()[_0x31f27a(0x55f)](_0x477eac=>_0x477eac[_0x31f27a(0x999)]()===_0x53b571);}}}}}}if(_0xdfa6c4[_0x31f27a(0x1069)](_0x5268ba,_0xdfa6c4[_0x31f27a(0xf90)]))return _0x64029d[_0x31f27a(0x55f)](_0x897e71=>_0x897e71[_0x31f27a(0xb30)]());else{if(_0xdfa6c4[_0x31f27a(0xd76)](_0x5268ba,_0xdfa6c4[_0x31f27a(0x14e9)]))return _0x64029d['filter'](_0xa7bd1d=>_0xa7bd1d['isAlive']()&&_0xa7bd1d!==_0x30ab6e);else{if(_0xdfa6c4[_0x31f27a(0xd76)](_0x5268ba,_0xdfa6c4[_0x31f27a(0x1264)]))return _0x64029d[_0x31f27a(0x55f)](_0x2c48ab=>_0x2c48ab[_0x31f27a(0xb30)]()&&_0x2c48ab!==_0x32fd0c);else{if(_0xdfa6c4[_0x31f27a(0xcb5)](_0x5268ba,_0xdfa6c4[_0x31f27a(0xfe4)]))return _0x64029d[_0x31f27a(0x55f)](_0x196c28=>_0x196c28['isDead']());}}}return[];},VisuMZ[_0xe90fac(0x335)+_0xe90fac(0x12f)+_0xe90fac(0x7d6)]=function(){const _0x1f5f32=_0xe90fac;return BattleManager[_0x1f5f32(0x146b)];},VisuMZ['GetActionS'+_0xe90fac(0x12f)+_0xe90fac(0x7d6)+_0xe90fac(0x12c7)]=function(_0x9746c0){const _0x40cab0=_0xe90fac;return BattleManager[_0x40cab0(0x146b)];},PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x21e)+_0xe90fac(0x11c8)+'on',_0x181d8a=>{const _0x203acd=_0xe90fac,_0x192ead={'RTosp':function(_0x162db5,_0x4427a4){return _0x162db5||_0x4427a4;},'jIwMB':_0x203acd(0xed1)+_0x203acd(0x15b9),'tWcCz':_0x203acd(0x763)+_0x203acd(0x911),'EbkWC':_0x203acd(0x136b)+'ement','lgYNR':_0x203acd(0x11af)+_0x203acd(0x10f4),'FuSVK':_0x203acd(0x145d)+'mation','nAoZI':_0x203acd(0xb52)};if(!SceneManager[_0x203acd(0x11be)+_0x203acd(0x3ad)]())return;VisuMZ[_0x203acd(0x15ae)+_0x203acd(0xe3)](_0x181d8a,_0x181d8a);const _0x2e4526=$gameTemp[_0x203acd(0xb71)+_0x203acd(0x10f2)+_0x203acd(0x1b4)+'r'](),_0x1b546c=BattleManager[_0x203acd(0xc37)],_0x1fa322=BattleManager['_subject'],_0x2dcc08=BattleManager[_0x203acd(0xa1c)+'s']?BattleManager['_allTarget'+'s'][_0x203acd(0x77f)](0x789*0x1+-0xf55+0x7cc):[],_0x1c15b5=BattleManager['_logWindow'];if(_0x192ead['RTosp'](!_0x2e4526,!_0x1b546c)||!_0x1fa322)return;if(!_0x1b546c[_0x203acd(0xdd)]())return;if(_0x181d8a[_0x203acd(0x241)+_0x203acd(0x130a)])_0x1c15b5[_0x203acd(0xa26)+'ion'](_0x1fa322,_0x1b546c[_0x203acd(0xdd)]());_0x181d8a[_0x203acd(0xe3d)+_0x203acd(0x15b9)]&&_0x1c15b5[_0x203acd(0x15f1)](_0x192ead[_0x203acd(0x12ea)],_0x1fa322,_0x2dcc08,!![]);if(_0x181d8a[_0x203acd(0xfe7)+'t'])_0x1c15b5[_0x203acd(0x15f1)](_0x192ead[_0x203acd(0xb5b)],_0x1fa322,_0x1b546c);if(_0x181d8a[_0x203acd(0x12b1)+_0x203acd(0x4a5)])_0x1c15b5['push'](_0x192ead['EbkWC']);if(_0x181d8a[_0x203acd(0x15c2)+_0x203acd(0x130a)])_0x1c15b5[_0x203acd(0x15f1)](_0x192ead[_0x203acd(0xec6)],_0x1fa322,_0x1b546c);if(_0x181d8a['WaitForAni'+'mation'])_0x1c15b5[_0x203acd(0x15f1)](_0x192ead[_0x203acd(0x1247)]);_0x2e4526[_0x203acd(0xdaa)+'e'](_0x192ead[_0x203acd(0x221)]);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x21e)+'_WholeActi'+'onSet',_0x4f5ddb=>{const _0x26f1d4=_0xe90fac,_0x115f56={'mKfrS':function(_0x29422a,_0x1ea3a6){return _0x29422a||_0x1ea3a6;},'ePGmr':function(_0x3a8e67,_0x138538){return _0x3a8e67<_0x138538;},'TjuXv':_0x26f1d4(0x11ad)+'eaponSet','QqHWq':_0x26f1d4(0x763)+_0x26f1d4(0x130a),'SxMLt':function(_0x522d2a,_0x3403c0){return _0x522d2a>_0x3403c0;},'xcEii':_0x26f1d4(0x1172),'uSpUe':'showAnimat'+_0x26f1d4(0x130a),'alYDM':_0x26f1d4(0x145d)+_0x26f1d4(0xb0d),'diUQS':_0x26f1d4(0x679)+'ct','sVqxN':'clearActiv'+_0x26f1d4(0x8c3),'uVVzT':'applyImmor'+'tal','ltmOj':_0x26f1d4(0xb52)};if(!SceneManager[_0x26f1d4(0x11be)+'tle']())return;VisuMZ[_0x26f1d4(0x15ae)+_0x26f1d4(0xe3)](_0x4f5ddb,_0x4f5ddb);const _0x553640=$gameTemp[_0x26f1d4(0xb71)+_0x26f1d4(0x10f2)+_0x26f1d4(0x1b4)+'r'](),_0x263de1=BattleManager[_0x26f1d4(0xc37)],_0x599ea0=BattleManager['_subject'],_0x56f0c2=BattleManager[_0x26f1d4(0xa1c)+'s']?BattleManager[_0x26f1d4(0xa1c)+'s'][_0x26f1d4(0x77f)](-0x2d9+0x38d+-0x12*0xa):[],_0x324bf3=BattleManager[_0x26f1d4(0x3b7)],_0x3e6f0a=_0x4f5ddb[_0x26f1d4(0x847)]??![];if(_0x115f56['mKfrS'](!_0x553640,!_0x263de1)||!_0x599ea0)return;if(!_0x263de1['item']())return;let _0x5056f3=_0x3e6f0a?_0x324bf3[_0x26f1d4(0x1308)+'ldTimes'](_0x599ea0):0xf82+0x3e9*0x5+0x1187*-0x2;for(let _0x398846=0x1e5a+0x22f3*0x1+-0x414d;_0x115f56[_0x26f1d4(0xfab)](_0x398846,_0x5056f3);_0x398846++){_0x3e6f0a&&_0x599ea0[_0x26f1d4(0xd83)]()&&_0x324bf3[_0x26f1d4(0x15f1)](_0x115f56[_0x26f1d4(0x12ce)],_0x599ea0,_0x398846);if(_0x4f5ddb['PerformAct'+_0x26f1d4(0x130a)])_0x324bf3[_0x26f1d4(0x15f1)](_0x115f56['QqHWq'],_0x599ea0,_0x263de1);if(_0x115f56['SxMLt'](_0x4f5ddb[_0x26f1d4(0x2c2)],-0x105d+-0x1ff0+0x304d))_0x324bf3[_0x26f1d4(0x15f1)](_0x115f56['xcEii'],_0x4f5ddb[_0x26f1d4(0x2c2)]);if(_0x4f5ddb[_0x26f1d4(0xbdd)+_0x26f1d4(0x1094)])_0x324bf3[_0x26f1d4(0x15f1)](_0x115f56['uSpUe'],_0x599ea0,_0x56f0c2,_0x263de1[_0x26f1d4(0xdd)]()[_0x26f1d4(0x4cf)+'d']);if(_0x4f5ddb[_0x26f1d4(0xdd3)+_0x26f1d4(0xb0d)])_0x324bf3[_0x26f1d4(0x15f1)](_0x115f56[_0x26f1d4(0x128f)]);for(const _0x345897 of _0x56f0c2){if(!_0x345897)continue;if(_0x4f5ddb[_0x26f1d4(0xe5f)+'ct'])_0x324bf3[_0x26f1d4(0x15f1)](_0x115f56[_0x26f1d4(0xeef)],_0x599ea0,_0x345897);}}_0x3e6f0a&&_0x599ea0[_0x26f1d4(0xd83)]()&&_0x324bf3['push'](_0x115f56[_0x26f1d4(0x6b4)],_0x599ea0);if(_0x4f5ddb[_0x26f1d4(0xe3d)+_0x26f1d4(0x15b9)])_0x324bf3[_0x26f1d4(0x15f1)](_0x115f56[_0x26f1d4(0xbac)],_0x599ea0,_0x56f0c2,![]);_0x553640[_0x26f1d4(0xdaa)+'e'](_0x115f56[_0x26f1d4(0x1304)]);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],'ActSeq_Set'+'_TargetAct'+'ionSet',_0x28d98a=>{const _0xdbc46c=_0xe90fac,_0x84c1f0={'cHTny':function(_0x48a29f,_0x1695dc){return _0x48a29f||_0x1695dc;},'PVasF':function(_0x465e7e,_0x523717){return _0x465e7e<_0x523717;},'Ieirh':_0xdbc46c(0x11ad)+_0xdbc46c(0xbdc),'RqfBZ':_0xdbc46c(0x763)+'ion','pSfng':function(_0x45fee5,_0x5ad5fc){return _0x45fee5>_0x5ad5fc;},'MxKIC':_0xdbc46c(0x1172),'EffTm':_0xdbc46c(0x1b7)+_0xdbc46c(0x130a),'AKTro':_0xdbc46c(0x679)+'ct','emhtp':_0xdbc46c(0x8e2)+_0xdbc46c(0x8c3),'FVXor':'applyImmor'+_0xdbc46c(0x15b9),'AzOgN':_0xdbc46c(0xb52)};if(!SceneManager[_0xdbc46c(0x11be)+_0xdbc46c(0x3ad)]())return;VisuMZ['ConvertPar'+_0xdbc46c(0xe3)](_0x28d98a,_0x28d98a);const _0x382540=$gameTemp[_0xdbc46c(0xb71)+'ginCommand'+_0xdbc46c(0x1b4)+'r'](),_0x10e959=BattleManager['_action'],_0x281018=BattleManager[_0xdbc46c(0x14c1)],_0x505259=BattleManager['_allTarget'+'s']?BattleManager[_0xdbc46c(0xa1c)+'s'][_0xdbc46c(0x77f)](0x49a*0x2+0x65a+-0xb5*0x16):[],_0x3289af=BattleManager[_0xdbc46c(0x3b7)],_0x5b1b36=_0x28d98a[_0xdbc46c(0x847)]??![];if(_0x84c1f0[_0xdbc46c(0xd56)](!_0x382540,!_0x10e959)||!_0x281018)return;if(!_0x10e959[_0xdbc46c(0xdd)]())return;let _0x1ba15c=_0x5b1b36?_0x3289af[_0xdbc46c(0x1308)+_0xdbc46c(0x155)](_0x281018):-0x1e26+0x44*0x57+-0x1*-0x70b;for(let _0x5166a6=-0x1553*0x1+-0x1*0x25ef+0x3b42;_0x84c1f0[_0xdbc46c(0xf45)](_0x5166a6,_0x1ba15c);_0x5166a6++){for(const _0x5de16a of _0x505259){if(!_0x5de16a)continue;_0x5b1b36&&_0x281018[_0xdbc46c(0xd83)]()&&_0x3289af[_0xdbc46c(0x15f1)](_0x84c1f0[_0xdbc46c(0x962)],_0x281018,_0x5166a6);if(_0x28d98a[_0xdbc46c(0x846)+_0xdbc46c(0x130a)])_0x3289af[_0xdbc46c(0x15f1)](_0x84c1f0[_0xdbc46c(0x1518)],_0x281018,_0x10e959);if(_0x84c1f0[_0xdbc46c(0xff1)](_0x28d98a[_0xdbc46c(0xb66)],-0x564+0x557+0xd))_0x3289af[_0xdbc46c(0x15f1)](_0x84c1f0['MxKIC'],_0x28d98a[_0xdbc46c(0xb66)]);if(_0x28d98a[_0xdbc46c(0xbdd)+'ation'])_0x3289af[_0xdbc46c(0x15f1)](_0x84c1f0[_0xdbc46c(0x152c)],_0x281018,[_0x5de16a],_0x10e959[_0xdbc46c(0xdd)]()[_0xdbc46c(0x4cf)+'d']);if(_0x84c1f0[_0xdbc46c(0xff1)](_0x28d98a['WaitCount2'],0x17f6+0xe57+-0x25*0x109))_0x3289af['push'](_0x84c1f0[_0xdbc46c(0x1464)],_0x28d98a[_0xdbc46c(0x1339)]);if(_0x28d98a['ActionEffe'+'ct'])_0x3289af[_0xdbc46c(0x15f1)](_0x84c1f0[_0xdbc46c(0x903)],_0x281018,_0x5de16a);}}_0x5b1b36&&_0x281018[_0xdbc46c(0xd83)]()&&_0x3289af[_0xdbc46c(0x15f1)](_0x84c1f0[_0xdbc46c(0x57b)],_0x281018);if(_0x28d98a['ApplyImmor'+'tal'])_0x3289af[_0xdbc46c(0x15f1)](_0x84c1f0[_0xdbc46c(0xcb2)],_0x281018,_0x505259,![]);_0x382540[_0xdbc46c(0xdaa)+'e'](_0x84c1f0[_0xdbc46c(0xa35)]);}),PluginManager[_0xe90fac(0xbd6)+'mmand'](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x21e)+_0xe90fac(0x1038)+_0xe90fac(0x130a),_0x563548=>{const _0x128a59=_0xe90fac,_0x4f4841={'qNWhJ':function(_0xf4bf6b,_0x176c4e){return _0xf4bf6b||_0x176c4e;},'yWSNW':_0x128a59(0xed1)+_0x128a59(0x15b9),'SAckC':'waitForNew'+_0x128a59(0x1212),'ocURO':_0x128a59(0x676)+_0x128a59(0x41d),'mmFJX':_0x128a59(0xf98),'cHuxM':_0x128a59(0x763)+_0x128a59(0x15f),'EBUSh':_0x128a59(0x136b)+_0x128a59(0x4a5),'eXBxI':_0x128a59(0xb52)};if(!SceneManager['isSceneBat'+'tle']())return;VisuMZ[_0x128a59(0x15ae)+'ams'](_0x563548,_0x563548);const _0x17b602=$gameTemp[_0x128a59(0xb71)+_0x128a59(0x10f2)+'Interprete'+'r'](),_0x4d6739=BattleManager[_0x128a59(0xc37)],_0x24930e=BattleManager[_0x128a59(0x14c1)],_0x467bf3=BattleManager[_0x128a59(0xa1c)+'s']?BattleManager[_0x128a59(0xa1c)+'s'][_0x128a59(0x77f)](0xe5*0x5+0x8*-0x27a+0x77*0x21):[],_0x19f431=BattleManager[_0x128a59(0x3b7)];if(_0x4f4841[_0x128a59(0x9bf)](!_0x17b602,!_0x4d6739)||!_0x24930e)return;if(!_0x4d6739['item']())return;if(_0x563548[_0x128a59(0xe3d)+_0x128a59(0x15b9)])_0x19f431[_0x128a59(0x15f1)](_0x4f4841['yWSNW'],_0x24930e,_0x467bf3,![]);if(_0x563548[_0x128a59(0xebb)+_0x128a59(0x1212)])_0x19f431[_0x128a59(0x15f1)](_0x4f4841[_0x128a59(0x6f5)]);if(_0x563548[_0x128a59(0x1ed)+_0x128a59(0x41d)])_0x19f431[_0x128a59(0x15f1)](_0x4f4841[_0x128a59(0x7fa)]);if(_0x563548['ClearBattl'+'eLog'])_0x19f431[_0x128a59(0x15f1)](_0x4f4841[_0x128a59(0xc34)]);if(_0x563548[_0x128a59(0x6c7)])_0x19f431[_0x128a59(0x15f1)](_0x4f4841[_0x128a59(0x14fa)],_0x24930e);if(_0x563548['WaitForMov'+'ement'])_0x19f431['push'](_0x4f4841[_0x128a59(0x803)]);_0x17b602[_0x128a59(0xdaa)+'e'](_0x4f4841[_0x128a59(0x754)]);}),PluginManager['registerCo'+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x11e1)+_0xe90fac(0x14a7),_0x17782e=>{const _0x568b39=_0xe90fac,_0x353170={'wvlfT':'battleAngl'+'e'};if(!SceneManager[_0x568b39(0x11be)+_0x568b39(0x3ad)]())return;if(!Imported[_0x568b39(0xc49)+'ctSeqCamer'+'a'])return;VisuMZ[_0x568b39(0x15ae)+'ams'](_0x17782e,_0x17782e);const _0x3ee700=$gameTemp[_0x568b39(0xb71)+_0x568b39(0x10f2)+_0x568b39(0x1b4)+'r'](),_0x32ba1d=_0x17782e['WaitForAng'+'le'];if(!_0x3ee700)return;$gameScreen[_0x568b39(0xc51)+'ngle'](_0x17782e[_0x568b39(0x306)],_0x17782e[_0x568b39(0x825)],_0x17782e[_0x568b39(0x1521)]);if(_0x32ba1d)_0x3ee700[_0x568b39(0xdaa)+'e'](_0x353170[_0x568b39(0xc4a)]);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x2f8)+_0xe90fac(0xa27),_0x4c47e6=>{const _0x361921=_0xe90fac,_0x3625cc={'cCwCr':_0x361921(0x1214)+'e'};if(!SceneManager[_0x361921(0x11be)+_0x361921(0x3ad)]())return;if(!Imported[_0x361921(0xc49)+_0x361921(0x26a)+'a'])return;VisuMZ['ConvertPar'+_0x361921(0xe3)](_0x4c47e6,_0x4c47e6);const _0x4edc12=$gameTemp[_0x361921(0xb71)+_0x361921(0x10f2)+_0x361921(0x1b4)+'r'](),_0x2480a7=_0x4c47e6[_0x361921(0x1208)+'le'];if(!_0x4edc12)return;$gameScreen[_0x361921(0xc51)+_0x361921(0x3aa)](-0x236c+-0x11*-0x159+0xc83,_0x4c47e6[_0x361921(0x825)],_0x4c47e6['EasingType']);if(_0x2480a7)_0x4edc12['setWaitMod'+'e'](_0x3625cc['cCwCr']);}),PluginManager['registerCo'+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x2f8)+_0xe90fac(0x21c)+_0xe90fac(0x306),_0x59c0a1=>{const _0x44cb2f=_0xe90fac,_0x166d55={'sZRJs':_0x44cb2f(0x1214)+'e'};if(!SceneManager['isSceneBat'+_0x44cb2f(0x3ad)]())return;if(!Imported[_0x44cb2f(0xc49)+_0x44cb2f(0x26a)+'a'])return;const _0x9886ba=$gameTemp[_0x44cb2f(0xb71)+'ginCommand'+_0x44cb2f(0x1b4)+'r']();if(!_0x9886ba)return;_0x9886ba[_0x44cb2f(0xdaa)+'e'](_0x166d55[_0x44cb2f(0x6d2)]);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData['name'],_0xe90fac(0x9bd)+_0xe90fac(0x1116)+_0xe90fac(0xd92)+'on',_0x47aabd=>{const _0x16b890=_0xe90fac,_0x25e3ed={'kCvgR':function(_0x7fff45,_0x2add53){return _0x7fff45||_0x2add53;},'gVsFU':function(_0x324ff4,_0x5f5525){return _0x324ff4<_0x5f5525;},'obTCP':_0x16b890(0x13fa)+'ation'};if(!SceneManager[_0x16b890(0x11be)+'tle']())return;VisuMZ['ConvertPar'+'ams'](_0x47aabd,_0x47aabd);const _0x16e29f=$gameTemp['getLastPlu'+_0x16b890(0x10f2)+_0x16b890(0x1b4)+'r'](),_0x3e155e=BattleManager[_0x16b890(0xc37)],_0x46f57a=BattleManager['_subject'],_0x4c1635=VisuMZ[_0x16b890(0xd1a)+_0x16b890(0x12fd)+_0x16b890(0x1027)](_0x47aabd[_0x16b890(0x1027)]),_0x79e2c=_0x47aabd['Mirror'],_0x4673ae=BattleManager[_0x16b890(0x3b7)];if(_0x25e3ed[_0x16b890(0x1028)](!_0x16e29f,!_0x3e155e)||!_0x46f57a)return;if(!_0x3e155e[_0x16b890(0xdd)]())return;let _0x257824=_0x3e155e['item']()[_0x16b890(0x4cf)+'d'];if(_0x25e3ed[_0x16b890(0xe17)](_0x257824,0x1080+0x1*-0x2412+0x686*0x3))_0x257824=_0x46f57a[_0x16b890(0x146d)+_0x16b890(0x15b6)]();$gameTemp['requestAni'+_0x16b890(0xb0d)](_0x4c1635,_0x257824,_0x79e2c),_0x47aabd['WaitForAni'+_0x16b890(0xb0d)]&&_0x16e29f['setWaitMod'+'e'](_0x25e3ed[_0x16b890(0xc1c)]);}),PluginManager['registerCo'+_0xe90fac(0xc22)](pluginData['name'],'ActSeq_Ani'+_0xe90fac(0x61e)+_0xe90fac(0xbdb)+'on',_0x14183f=>{const _0x4e5685=_0xe90fac,_0x3cf96b={'amQgy':function(_0x51f348,_0x4ceab6){return _0x51f348||_0x4ceab6;},'CmOPr':_0x4e5685(0x13fa)+'ation'};if(!SceneManager['isSceneBat'+_0x4e5685(0x3ad)]())return;VisuMZ['ConvertPar'+_0x4e5685(0xe3)](_0x14183f,_0x14183f);const _0xda6d05=$gameTemp[_0x4e5685(0xb71)+_0x4e5685(0x10f2)+_0x4e5685(0x1b4)+'r'](),_0x2e46d6=BattleManager[_0x4e5685(0x14c1)],_0xaf8f6a=VisuMZ[_0x4e5685(0xd1a)+_0x4e5685(0x12fd)+_0x4e5685(0x1027)](_0x14183f[_0x4e5685(0x1027)]),_0xe9c18e=_0x14183f[_0x4e5685(0x56b)],_0x3164e0=BattleManager[_0x4e5685(0x3b7)];if(_0x3cf96b[_0x4e5685(0x765)](!_0xda6d05,!_0x2e46d6))return;const _0x4b7efa=_0x2e46d6[_0x4e5685(0x146d)+'ationId1']();$gameTemp['requestAni'+'mation'](_0xaf8f6a,_0x4b7efa,_0xe9c18e),_0x14183f[_0x4e5685(0xdd3)+_0x4e5685(0xb0d)]&&_0xda6d05[_0x4e5685(0xdaa)+'e'](_0x3cf96b[_0x4e5685(0x10c4)]);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData['name'],_0xe90fac(0x9bd)+_0xe90fac(0x61e)+'ackAnimati'+_0xe90fac(0xda2),_0x1e7a6e=>{const _0x5e8ea5=_0xe90fac,_0x257467={'txrUq':function(_0x3368d4,_0x148ed5){return _0x3368d4<=_0x148ed5;},'vJmyl':function(_0x12f823,_0x745401){return _0x12f823||_0x745401;},'afEiC':'battleAnim'+_0x5e8ea5(0x1094)};if(!SceneManager[_0x5e8ea5(0x11be)+_0x5e8ea5(0x3ad)]())return;VisuMZ[_0x5e8ea5(0x15ae)+_0x5e8ea5(0xe3)](_0x1e7a6e,_0x1e7a6e);const _0x9be3b8=_0x1ee2c2[_0x5e8ea5(0x146d)+_0x5e8ea5(0xc13)+'t'](_0x1e7a6e[_0x5e8ea5(0xf5b)]);if(_0x257467[_0x5e8ea5(0x1131)](_0x9be3b8,-0x67f*0x1+0x1*0x316+0x9*0x61))return;const _0x11ab5f=$gameTemp[_0x5e8ea5(0xb71)+_0x5e8ea5(0x10f2)+_0x5e8ea5(0x1b4)+'r'](),_0x1ee2c2=BattleManager[_0x5e8ea5(0x14c1)],_0x7d05e3=VisuMZ['CreateActi'+_0x5e8ea5(0x12fd)+_0x5e8ea5(0x1027)](_0x1e7a6e[_0x5e8ea5(0x1027)]),_0x4e4f92=_0x1e7a6e[_0x5e8ea5(0x56b)],_0x45f7fc=BattleManager[_0x5e8ea5(0x3b7)];if(_0x257467['vJmyl'](!_0x11ab5f,!_0x1ee2c2))return;$gameTemp[_0x5e8ea5(0xdfd)+_0x5e8ea5(0xb0d)](_0x7d05e3,_0x9be3b8,_0x4e4f92),_0x1e7a6e[_0x5e8ea5(0xdd3)+_0x5e8ea5(0xb0d)]&&_0x11ab5f['setWaitMod'+'e'](_0x257467['afEiC']);}),PluginManager[_0xe90fac(0xbd6)+'mmand'](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x9bd)+_0xe90fac(0x1192)+_0xe90fac(0x87e)+_0xe90fac(0x130a),_0x28a148=>{const _0x3460f9=_0xe90fac,_0x465259={'GuskX':_0x3460f9(0x79e)+'N','csnih':_0x3460f9(0x12a3),'kTyBp':'MUSIC','cWjEd':_0x3460f9(0x15ad),'OEaAQ':_0x3460f9(0x128c),'IOfLA':_0x3460f9(0xca3),'PejAV':_0x3460f9(0x876),'JLDUj':_0x3460f9(0x13dc),'vmRyl':_0x3460f9(0xab9),'HvTdI':_0x3460f9(0xa4b),'tuqFB':_0x3460f9(0x9de),'wWTfD':_0x3460f9(0xd58),'IkGqV':_0x3460f9(0x10de),'fhoXm':'ANNOYED','IbZLU':_0x3460f9(0x307)+'N','qbLZk':_0x3460f9(0xfae),'mqcei':_0x3460f9(0x50f),'PEtCo':'LIGHT','xHDVk':'BULB','JzcmA':'LIGHT\x20BULB','PEykn':_0x3460f9(0x5eb),'AhgIX':_0x3460f9(0xac0),'iDLqm':'ZZZ','rPZKY':_0x3460f9(0xd0b),'zvrxb':_0x3460f9(0xdad)+_0x3460f9(0x15ea),'ntinr':_0x3460f9(0xdad)+_0x3460f9(0x5aa),'uZTXz':_0x3460f9(0xdad)+'ED\x203','YjavF':_0x3460f9(0xdad)+'ED\x204','ybdHw':_0x3460f9(0xdad)+_0x3460f9(0x1341),'PMGwM':_0x3460f9(0x339)+_0x3460f9(0xc78)};if(!SceneManager['isSceneBat'+_0x3460f9(0x3ad)]())return;VisuMZ[_0x3460f9(0x15ae)+_0x3460f9(0xe3)](_0x28a148,_0x28a148);const _0xae2453=$gameTemp[_0x3460f9(0xb71)+_0x3460f9(0x10f2)+_0x3460f9(0x1b4)+'r'](),_0x5bc81d=VisuMZ[_0x3460f9(0xd1a)+_0x3460f9(0x12fd)+_0x3460f9(0x1027)](_0x28a148[_0x3460f9(0x1027)]),_0x5061c9=_0x28a148[_0x3460f9(0x111a)];let _0x111567=-0xec5+0x22f5+-0x4*0x50c;switch(_0x5061c9[_0x3460f9(0x1318)+'e']()[_0x3460f9(0x808)]()){case'!':case _0x465259['GuskX']:_0x111567=-0x2609+-0x210a+0x4714*0x1;break;case'?':case _0x465259['csnih']:_0x111567=0x1c75*-0x1+-0x4*0x277+-0x2653*-0x1;break;case _0x465259[_0x3460f9(0x9d1)]:case _0x465259['cWjEd']:case _0x465259[_0x3460f9(0x905)]:case _0x465259[_0x3460f9(0xeb7)]:case _0x465259['PejAV']:_0x111567=0x135e+0xce2*0x1+0x3*-0xabf;break;case _0x465259['JLDUj']:case _0x465259[_0x3460f9(0x986)]:_0x111567=0x1d34+0xec4+-0x2bf4;break;case _0x465259[_0x3460f9(0x2ef)]:case _0x465259['tuqFB']:_0x111567=0x1861+0x1ed9+-0x7*0x7e3;break;case _0x465259[_0x3460f9(0xc2c)]:_0x111567=-0x1*0xc22+0xca2+-0x7a;break;case _0x465259[_0x3460f9(0x59c)]:case _0x465259[_0x3460f9(0x1604)]:case _0x465259[_0x3460f9(0xaa5)]:_0x111567=-0x1a32*0x1+-0x116d+0x2ba6;break;case _0x465259[_0x3460f9(0x11e5)]:case _0x465259[_0x3460f9(0x76c)]:_0x111567=0x20ae+-0xf*-0xd6+0xb4c*-0x4;break;case _0x465259[_0x3460f9(0xeac)]:case _0x465259[_0x3460f9(0x1468)]:case _0x465259[_0x3460f9(0x887)]:case _0x465259['PEykn']:case _0x465259['AhgIX']:_0x111567=-0xec4+0x1*-0x11f9+0x20c6;break;case'Z':case'ZZ':case _0x465259['iDLqm']:case _0x465259[_0x3460f9(0x1175)]:_0x111567=0xd77+-0x1b7a*-0x1+0x28e7*-0x1;break;case _0x465259[_0x3460f9(0x579)]:_0x111567=0x222b+0x1*-0x231d+0xfd;break;case _0x465259[_0x3460f9(0x10e2)]:_0x111567=0xc6*0x1d+0x371*0x4+0x2426*-0x1;break;case _0x465259[_0x3460f9(0x8c1)]:_0x111567=0x53+-0xc87+-0xc41*-0x1;break;case _0x465259[_0x3460f9(0x13dd)]:_0x111567=0x10*0x9a+-0xff4+0x662;break;case _0x465259['ybdHw']:_0x111567=-0x1162+-0xe81+0x1ff2;break;}for(const _0x188b2a of _0x5bc81d){if(!_0x188b2a)continue;$gameTemp[_0x3460f9(0x6e6)+_0x3460f9(0xc4)](_0x188b2a,_0x111567);}_0x28a148[_0x3460f9(0xad1)+'te']&&_0xae2453&&(_0xae2453[_0x3460f9(0x600)](-0xd0c+-0x3b+0xd48),_0xae2453[_0x3460f9(0xdaa)+'e'](_0x465259[_0x3460f9(0x86c)]));}),PluginManager['registerCo'+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x9bd)+_0xe90fac(0x1192)+_0xe90fac(0xefa),_0x2a414f=>{const _0x5758ee=_0xe90fac,_0x32168f={'gpWiH':'battleBall'+_0x5758ee(0xc78)};if(!SceneManager[_0x5758ee(0x11be)+_0x5758ee(0x3ad)]())return;if(!Imported[_0x5758ee(0x114d)+_0x5758ee(0xc69)+'s'])return;VisuMZ[_0x5758ee(0x15ae)+_0x5758ee(0xe3)](_0x2a414f,_0x2a414f);const _0x25f9f5=$gameTemp[_0x5758ee(0xb71)+'ginCommand'+_0x5758ee(0x1b4)+'r'](),_0x44b940=VisuMZ[_0x5758ee(0xd1a)+'onSequence'+_0x5758ee(0x1027)](_0x2a414f['Targets']),_0x37109d=_0x2a414f[_0x5758ee(0x3f8)];for(const _0x10a3f4 of _0x44b940){if(!_0x10a3f4)continue;$gameTemp[_0x5758ee(0x6e6)+_0x5758ee(0xc4)](_0x10a3f4,[_0x37109d]);}_0x2a414f[_0x5758ee(0xad1)+'te']&&_0x25f9f5&&(_0x25f9f5['wait'](-0x227c+-0x1e01*-0x1+0x47c),_0x25f9f5[_0x5758ee(0xdaa)+'e'](_0x32168f['gpWiH']));}),PluginManager[_0xe90fac(0xbd6)+'mmand'](pluginData[_0xe90fac(0x14c)],'ActSeq_Ani'+_0xe90fac(0x1192)+_0xe90fac(0x7eb)+'nge',_0xabd983=>{const _0x1cb977=_0xe90fac,_0x396f1e={'SLUbB':function(_0x330d19,_0x16157f){return _0x330d19(_0x16157f);},'ioBYp':function(_0x2b2e00,_0x5f5c8b){return _0x2b2e00(_0x5f5c8b);},'zJvIe':function(_0x573b79,_0x2f747e){return _0x573b79(_0x2f747e);},'kKZEa':function(_0x367f6d,_0x3a4222){return _0x367f6d<=_0x3a4222;},'HNCLr':_0x1cb977(0x339)+_0x1cb977(0xc78)};if(!SceneManager[_0x1cb977(0x11be)+_0x1cb977(0x3ad)]())return;if(!Imported[_0x1cb977(0x114d)+_0x1cb977(0xc69)+'s'])return;VisuMZ[_0x1cb977(0x15ae)+'ams'](_0xabd983,_0xabd983);const _0x1d94e2=$gameTemp[_0x1cb977(0xb71)+_0x1cb977(0x10f2)+_0x1cb977(0x1b4)+'r'](),_0x18a7cf=VisuMZ[_0x1cb977(0xd1a)+_0x1cb977(0x12fd)+'Targets'](_0xabd983[_0x1cb977(0x1027)]),_0x93b596=Math[_0x1cb977(0xeed)](_0x396f1e[_0x1cb977(0x12ec)](Number,_0xabd983[_0x1cb977(0xb9f)]||0x321*0x4+0x1d8f+-0x2a13),_0x396f1e[_0x1cb977(0x12ec)](Number,_0xabd983[_0x1cb977(0xb3c)]||0x1657*-0x1+-0x1a78+0x15*0x253)),_0x3c4cff=Math[_0x1cb977(0xd3e)](_0x396f1e[_0x1cb977(0x5fa)](Number,_0xabd983['startIcon']||0x117+0x66d*-0x1+0x556),_0x396f1e[_0x1cb977(0x597)](Number,_0xabd983['endIcon']||0x50b+-0x1*0x97f+0x474*0x1)),_0x19ecef=[];for(let _0xb28701=_0x93b596;_0x396f1e[_0x1cb977(0x11de)](_0xb28701,_0x3c4cff);_0xb28701++){_0x19ecef[_0x1cb977(0x15f1)](_0xb28701);}for(const _0xab3ca5 of _0x18a7cf){if(!_0xab3ca5)continue;$gameTemp[_0x1cb977(0x6e6)+_0x1cb977(0xc4)](_0xab3ca5,_0x19ecef);}_0xabd983['WaitComple'+'te']&&_0x1d94e2&&(_0x1d94e2['wait'](0xe5*-0x13+0x8*0x421+-0x804*0x2),_0x1d94e2[_0x1cb977(0xdaa)+'e'](_0x396f1e[_0x1cb977(0xdb0)]));}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData['name'],_0xe90fac(0x9bd)+_0xe90fac(0x1192)+'loonIconSp'+'ecific',_0x46e0a6=>{const _0x14f23c=_0xe90fac,_0x457449={'DOroh':'battleBall'+'oon'};if(!SceneManager[_0x14f23c(0x11be)+_0x14f23c(0x3ad)]())return;if(!Imported[_0x14f23c(0x114d)+_0x14f23c(0xc69)+'s'])return;VisuMZ['ConvertPar'+'ams'](_0x46e0a6,_0x46e0a6);const _0x550fdc=$gameTemp[_0x14f23c(0xb71)+_0x14f23c(0x10f2)+_0x14f23c(0x1b4)+'r'](),_0x550311=VisuMZ[_0x14f23c(0xd1a)+_0x14f23c(0x12fd)+_0x14f23c(0x1027)](_0x46e0a6[_0x14f23c(0x1027)]),_0x2bb09e=_0x46e0a6[_0x14f23c(0x13b7)];for(const _0x3cdeb9 of _0x550311){if(!_0x3cdeb9)continue;$gameTemp['requestBat'+'tleBalloon'](_0x3cdeb9,_0x2bb09e);}_0x46e0a6['WaitComple'+'te']&&_0x550fdc&&(_0x550fdc[_0x14f23c(0x600)](0x3*-0x616+0x113d+0x2*0x83),_0x550fdc[_0x14f23c(0xdaa)+'e'](_0x457449[_0x14f23c(0x1043)]));}),PluginManager['registerCo'+_0xe90fac(0xc22)](pluginData['name'],'ActSeq_Ani'+'mation_Cas'+_0xe90fac(0x10f4),_0x3cbeaf=>{const _0xa5f1b8=_0xe90fac,_0xdeabaf={'RpBsK':function(_0x170dff,_0x3e3109){return _0x170dff||_0x3e3109;},'SfRye':_0xa5f1b8(0x13fa)+_0xa5f1b8(0x1094)};if(!SceneManager['isSceneBat'+'tle']())return;VisuMZ[_0xa5f1b8(0x15ae)+_0xa5f1b8(0xe3)](_0x3cbeaf,_0x3cbeaf);const _0x1f1c5c=$gameTemp[_0xa5f1b8(0xb71)+_0xa5f1b8(0x10f2)+_0xa5f1b8(0x1b4)+'r'](),_0x23015e=BattleManager[_0xa5f1b8(0xc37)],_0x1ec02a=_0x3cbeaf[_0xa5f1b8(0x56b)],_0x2e1e1f=VisuMZ[_0xa5f1b8(0xd1a)+_0xa5f1b8(0x12fd)+_0xa5f1b8(0x1027)](_0x3cbeaf['Targets']);if(_0xdeabaf[_0xa5f1b8(0xe47)](!_0x1f1c5c,!_0x23015e))return;if(!_0x23015e['item']())return;for(const _0x192dd1 of _0x2e1e1f){if(!_0x192dd1)continue;_0x192dd1[_0xa5f1b8(0x11af)+_0xa5f1b8(0x10f4)](_0x23015e,_0x1ec02a);}if(_0x3cbeaf[_0xa5f1b8(0xdd3)+_0xa5f1b8(0xb0d)])_0x1f1c5c['setWaitMod'+'e'](_0xdeabaf[_0xa5f1b8(0xace)]);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],'ActSeq_Ani'+_0xe90fac(0x2b3)+'ngeBattleP'+'ortrait',_0x4e765d=>{const _0x18ef61=_0xe90fac;VisuMZ['ConvertPar'+_0x18ef61(0xe3)](_0x4e765d,_0x4e765d);const _0x13111c=$gameTemp[_0x18ef61(0xb71)+_0x18ef61(0x10f2)+'Interprete'+'r'](),_0x138787=VisuMZ[_0x18ef61(0xd1a)+_0x18ef61(0x12fd)+_0x18ef61(0x1027)](_0x4e765d[_0x18ef61(0x1027)]),_0x5b0ee7=_0x4e765d[_0x18ef61(0x12a5)];if(!_0x5b0ee7)return;for(const _0xbd6059 of _0x138787){if(!_0xbd6059)continue;if(!_0xbd6059['isActor']())continue;_0xbd6059[_0x18ef61(0x105a)+_0x18ef61(0xd8f)](_0x5b0ee7);}}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData['name'],_0xe90fac(0x9bd)+_0xe90fac(0x95d)+_0xe90fac(0x947)+'n',_0x45fb35=>{const _0x43a52d=_0xe90fac,_0x47c006={'yXgqr':function(_0x1a1732,_0x213f2a){return _0x1a1732||_0x213f2a;},'nzZXw':'battleAnim'+_0x43a52d(0x1094)};if(!SceneManager['isSceneBat'+_0x43a52d(0x3ad)]())return;VisuMZ[_0x43a52d(0x15ae)+_0x43a52d(0xe3)](_0x45fb35,_0x45fb35);const _0x5b4c82=$gameTemp[_0x43a52d(0xb71)+_0x43a52d(0x10f2)+_0x43a52d(0x1b4)+'r'](),_0x35e885=BattleManager['_subject'],_0x4938a9=VisuMZ[_0x43a52d(0xd1a)+'onSequence'+'Targets'](_0x45fb35['Targets']),_0x33a086=_0x45fb35[_0x43a52d(0x56b)];if(_0x47c006[_0x43a52d(0xc3)](!_0x5b4c82,!_0x35e885))return;const _0x638bee=$dataSkilles[_0x35e885[_0x43a52d(0x1443)+'Id']()],_0x2130c1=_0x638bee[_0x43a52d(0x4cf)+'d'];$gameTemp[_0x43a52d(0xdfd)+'mation'](_0x4938a9,_0x2130c1,_0x33a086),_0x45fb35[_0x43a52d(0xdd3)+_0x43a52d(0xb0d)]&&_0x5b4c82[_0x43a52d(0xdaa)+'e'](_0x47c006['nzZXw']);}),PluginManager[_0xe90fac(0xbd6)+'mmand'](pluginData['name'],_0xe90fac(0x9bd)+_0xe90fac(0xc77)+'mAnimation',_0x3c495=>{const _0x17cfac=_0xe90fac,_0x5155e5={'ZXzjc':function(_0x18397c,_0x30b0d4){return _0x18397c(_0x30b0d4);},'cqezN':_0x17cfac(0x13fa)+_0x17cfac(0x1094)};if(!SceneManager[_0x17cfac(0x11be)+_0x17cfac(0x3ad)]())return;VisuMZ[_0x17cfac(0x15ae)+_0x17cfac(0xe3)](_0x3c495,_0x3c495);const _0x45a342=$gameTemp[_0x17cfac(0xb71)+_0x17cfac(0x10f2)+_0x17cfac(0x1b4)+'r'](),_0x246bd2=VisuMZ[_0x17cfac(0xd1a)+_0x17cfac(0x12fd)+'Targets'](_0x3c495[_0x17cfac(0x1027)]),_0x52c2c0=_0x5155e5[_0x17cfac(0x346)](Number,_0x3c495[_0x17cfac(0x1213)]||0x161*-0x6+-0x1df*0x1+0xa26),_0x993a00=$dataItems[_0x52c2c0],_0x33a316=_0x3c495[_0x17cfac(0x56b)];if(!_0x45a342)return;if(!_0x993a00)return;let _0x459dbd=_0x993a00[_0x17cfac(0x4cf)+'d'];$gameTemp[_0x17cfac(0xdfd)+'mation'](_0x246bd2,_0x459dbd,_0x33a316),_0x3c495['WaitForAni'+_0x17cfac(0xb0d)]&&_0x45a342[_0x17cfac(0xdaa)+'e'](_0x5155e5[_0x17cfac(0x79f)]);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],'ActSeq_Ani'+_0xe90fac(0x418)+_0xe90fac(0x2a9)+_0xe90fac(0x135d),_0x5d1196=>{const _0x365fe4=_0xe90fac,_0x5a454a={'NcAiX':_0x365fe4(0x13fa)+_0x365fe4(0x1094)};if(!SceneManager['_scene'])return;if(!SceneManager[_0x365fe4(0x11dd)][_0x365fe4(0x981)])return;if(!Imported['VisuMZ_0_C'+_0x365fe4(0x100d)])return;VisuMZ[_0x365fe4(0x15ae)+_0x365fe4(0xe3)](_0x5d1196,_0x5d1196);const _0x52239b=$gameTemp[_0x365fe4(0xb71)+_0x365fe4(0x10f2)+_0x365fe4(0x1b4)+'r'](),_0x3fa92b=Math['round'](_0x5d1196[_0x365fe4(0x701)]),_0x116f20=Math['round'](_0x5d1196[_0x365fe4(0x75a)]);$gameTemp['requestPoi'+_0x365fe4(0x87c)+'n'](_0x3fa92b,_0x116f20,_0x5d1196[_0x365fe4(0x102)+'D'],_0x5d1196[_0x365fe4(0x56b)],_0x5d1196['Mute']),_0x5d1196[_0x365fe4(0xad1)+'te']&&_0x52239b&&(SceneManager[_0x365fe4(0x11dd)][_0x365fe4(0x981)][_0x365fe4(0x266)+_0x365fe4(0x10f4)+'s'](),_0x52239b[_0x365fe4(0xdaa)+'e'](_0x5a454a[_0x365fe4(0x144c)]));}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x9bd)+_0xe90fac(0x163)+_0xe90fac(0x15a3),_0x5213bc=>{const _0x4e657e=_0xe90fac,_0x1b078d={'PJaFS':'battleAnim'+'ation'};if(!SceneManager[_0x4e657e(0x11be)+'tle']())return;VisuMZ[_0x4e657e(0x15ae)+_0x4e657e(0xe3)](_0x5213bc,_0x5213bc);const _0x3be0b2=$gameTemp['getLastPlu'+_0x4e657e(0x10f2)+_0x4e657e(0x1b4)+'r'](),_0x1d6e07=VisuMZ[_0x4e657e(0xd1a)+'onSequence'+_0x4e657e(0x1027)](_0x5213bc[_0x4e657e(0x1027)]),_0x195952=_0x5213bc[_0x4e657e(0x102)+'D'],_0x448098=_0x5213bc[_0x4e657e(0x56b)];if(!_0x3be0b2)return;$gameTemp[_0x4e657e(0xdfd)+_0x4e657e(0xb0d)](_0x1d6e07,_0x195952,_0x448098);if(_0x5213bc[_0x4e657e(0xdd3)+_0x4e657e(0xb0d)])_0x3be0b2['setWaitMod'+'e'](_0x1b078d[_0x4e657e(0x3f6)]);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData['name'],_0xe90fac(0x9bd)+_0xe90fac(0x163)+_0xe90fac(0x15a3)+'JS',_0xea4e2a=>{const _0x3becb4=_0xe90fac,_0x347ced={'vxBYQ':function(_0x4fc974,_0x25a33c){return _0x4fc974(_0x25a33c);},'QVZwx':_0x3becb4(0x13fa)+'ation'};if(!SceneManager[_0x3becb4(0x11be)+'tle']())return;VisuMZ[_0x3becb4(0x15ae)+_0x3becb4(0xe3)](_0xea4e2a,_0xea4e2a);const _0x5c036c=$gameTemp[_0x3becb4(0xb71)+'ginCommand'+_0x3becb4(0x1b4)+'r'](),_0x3c1bc7=VisuMZ['CreateActi'+_0x3becb4(0x12fd)+_0x3becb4(0x1027)](_0xea4e2a[_0x3becb4(0x1027)]),_0x527f2e=_0x347ced['vxBYQ'](Number,_0xea4e2a[_0x3becb4(0x102)+'D'])||0x34d+0x1*-0x841+0x4f5,_0xc39e30=_0xea4e2a[_0x3becb4(0x56b)];if(!_0x5c036c)return;$gameTemp['requestAni'+_0x3becb4(0xb0d)](_0x3c1bc7,_0x527f2e,_0xc39e30);if(_0xea4e2a['WaitForAni'+_0x3becb4(0xb0d)])_0x5c036c[_0x3becb4(0xdaa)+'e'](_0x347ced[_0x3becb4(0xab5)]);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x9bd)+_0xe90fac(0xb42)+'llAnimatio'+'n',_0x361770=>{const _0xb4e4d3=_0xe90fac,_0x52710c={'aqcmS':function(_0x367ea4,_0x2a393a){return _0x367ea4(_0x2a393a);},'qIIXk':_0xb4e4d3(0x13fa)+_0xb4e4d3(0x1094)};if(!SceneManager['isSceneBat'+'tle']())return;VisuMZ['ConvertPar'+_0xb4e4d3(0xe3)](_0x361770,_0x361770);const _0x5ba080=$gameTemp[_0xb4e4d3(0xb71)+'ginCommand'+'Interprete'+'r'](),_0x4fa384=VisuMZ[_0xb4e4d3(0xd1a)+_0xb4e4d3(0x12fd)+'Targets'](_0x361770[_0xb4e4d3(0x1027)]),_0x387a1e=_0x52710c[_0xb4e4d3(0x6ed)](Number,_0x361770[_0xb4e4d3(0x1121)]||-0x1*0x33+0x1754+-0x1720),_0xb9da9=$dataSkills[_0x387a1e],_0x594d7e=_0x361770[_0xb4e4d3(0x56b)];if(!_0x5ba080)return;if(!_0xb9da9)return;let _0x38309b=_0xb9da9[_0xb4e4d3(0x4cf)+'d'];$gameTemp[_0xb4e4d3(0xdfd)+_0xb4e4d3(0xb0d)](_0x4fa384,_0x38309b,_0x594d7e),_0x361770[_0xb4e4d3(0xdd3)+'mation']&&_0x5ba080[_0xb4e4d3(0xdaa)+'e'](_0x52710c[_0xb4e4d3(0x101)]);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],'ActSeq_Ani'+'mation_Wai'+_0xe90fac(0xf92)+_0xe90fac(0x130a),_0x131994=>{const _0x50762a=_0xe90fac,_0x2bd66b={'fBWaf':_0x50762a(0x13fa)+_0x50762a(0x1094)};if(!SceneManager['isSceneBat'+_0x50762a(0x3ad)]())return;const _0x5471a7=$gameTemp[_0x50762a(0xb71)+'ginCommand'+_0x50762a(0x1b4)+'r']();if(!_0x5471a7)return;_0x5471a7['setWaitMod'+'e'](_0x2bd66b['fBWaf']);}),PluginManager[_0xe90fac(0xbd6)+'mmand'](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x92d)+_0xe90fac(0x778)+'Text',_0x141cae=>{const _0x3b6fa8=_0xe90fac;if(!SceneManager[_0x3b6fa8(0x11be)+_0x3b6fa8(0x3ad)]())return;VisuMZ[_0x3b6fa8(0x15ae)+_0x3b6fa8(0xe3)](_0x141cae,_0x141cae);const _0x2db445=BattleManager[_0x3b6fa8(0x3b7)],_0x4ce79b=_0x141cae[_0x3b6fa8(0x224)+'Log']&&Imported[_0x3b6fa8(0x80d)+'ombatLog'];_0x2db445[_0x3b6fa8(0xf33)](_0x141cae[_0x3b6fa8(0x755)]),_0x4ce79b&&Imported[_0x3b6fa8(0x80d)+'ombatLog']&&$gameSystem[_0x3b6fa8(0x258)+_0x3b6fa8(0xb89)](_0x141cae[_0x3b6fa8(0x755)]||'',_0x141cae[_0x3b6fa8(0x1379)+_0x3b6fa8(0x5ad)]||-0x1bed+0xbd8*0x2+0x43d);}),PluginManager['registerCo'+'mmand'](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x92d)+_0xe90fac(0x1b0)+'ar',_0xbdf087=>{const _0x19ddae=_0xe90fac;if(!SceneManager[_0x19ddae(0x11be)+_0x19ddae(0x3ad)]())return;const _0x41f1a9=BattleManager['_logWindow'];_0x41f1a9[_0x19ddae(0xf98)]();}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x92d)+'tleLog_Dis'+_0xe90fac(0xda9),_0x3f9c53=>{const _0x586244=_0xe90fac,_0x418c3b={'OuGzO':function(_0x1700d3,_0x57ae81){return _0x1700d3||_0x57ae81;},'iTHlW':'battlelog'};if(!SceneManager[_0x586244(0x11be)+_0x586244(0x3ad)]())return;const _0xea53ce=$gameTemp[_0x586244(0xb71)+'ginCommand'+_0x586244(0x1b4)+'r'](),_0x58ed8c=BattleManager[_0x586244(0xc37)],_0xb354f6=BattleManager['_subject'],_0x2ee926=BattleManager[_0x586244(0x3b7)];if(_0x418c3b['OuGzO'](!_0xea53ce,!_0x58ed8c)||!_0xb354f6)return;if(!_0x58ed8c['item']())return;_0x2ee926['displayAct'+_0x586244(0x130a)](_0xb354f6,_0x58ed8c[_0x586244(0xdd)]()),_0xea53ce[_0x586244(0xdaa)+'e'](_0x418c3b[_0x586244(0xa2a)]);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x92d)+'tleLog_Pop'+_0xe90fac(0x12d7),_0x3a0b46=>{const _0x46ea35=_0xe90fac;if(!SceneManager[_0x46ea35(0x11be)+_0x46ea35(0x3ad)]())return;const _0x506b26=BattleManager[_0x46ea35(0x3b7)];_0x506b26[_0x46ea35(0x75b)+'e']();}),PluginManager[_0xe90fac(0xbd6)+'mmand'](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x92d)+_0xe90fac(0xa64)+_0xe90fac(0x200),_0x347505=>{const _0x2c6ea0=_0xe90fac;if(!SceneManager['isSceneBat'+_0x2c6ea0(0x3ad)]())return;const _0x352560=BattleManager['_logWindow'];_0x352560[_0x2c6ea0(0x159c)+'ne']();}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData['name'],_0xe90fac(0x92d)+_0xe90fac(0x9e9)+_0xe90fac(0x111c),_0x8d137=>{const _0x45b2c7=_0xe90fac;if(!SceneManager[_0x45b2c7(0x11be)+_0x45b2c7(0x3ad)]())return;const _0x58c0d0=BattleManager['_logWindow'];_0x58c0d0[_0x45b2c7(0x944)]();}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],'ActSeq_Bat'+_0xe90fac(0x26b),_0x5019b0=>{const _0x3c84bd=_0xe90fac;if(!SceneManager[_0x3c84bd(0x11be)+_0x3c84bd(0x3ad)]())return;VisuMZ[_0x3c84bd(0x15ae)+'ams'](_0x5019b0,_0x5019b0),SceneManager[_0x3c84bd(0x11dd)][_0x3c84bd(0x11bb)+'UI'](_0x5019b0[_0x3c84bd(0xee3)]);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x92d)+_0xe90fac(0x9d2)+_0xe90fac(0xdb6)+_0xe90fac(0xd44),_0x5b8a65=>{const _0x6efacb=_0xe90fac,_0x340ba4={'DgPug':_0x6efacb(0xb52)};if(!SceneManager[_0x6efacb(0x11be)+_0x6efacb(0x3ad)]())return;const _0x1b4dd2=$gameTemp[_0x6efacb(0xb71)+_0x6efacb(0x10f2)+_0x6efacb(0x1b4)+'r']();_0x1b4dd2[_0x6efacb(0xdaa)+'e'](_0x340ba4[_0x6efacb(0x1547)]);}),PluginManager['registerCo'+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x92d)+'tleLog_Wai'+_0xe90fac(0x10fa)+'e',_0x345119=>{const _0x47b891=_0xe90fac,_0x260a5e={'eXeTB':_0x47b891(0xb52)};if(!SceneManager[_0x47b891(0x11be)+_0x47b891(0x3ad)]())return;const _0x547fdb=$gameTemp[_0x47b891(0xb71)+_0x47b891(0x10f2)+_0x47b891(0x1b4)+'r'](),_0x11e0ec=BattleManager[_0x47b891(0x3b7)];_0x11e0ec[_0x47b891(0x299)+_0x47b891(0x1212)](),_0x547fdb[_0x47b891(0xdaa)+'e'](_0x260a5e['eXeTB']);}),PluginManager[_0xe90fac(0xbd6)+'mmand'](pluginData[_0xe90fac(0x14c)],'ActSeq_Cam'+_0xe90fac(0x12dc),_0x3573cf=>{const _0xa46636=_0xe90fac;if(!SceneManager['isSceneBat'+_0xa46636(0x3ad)]())return;if(!Imported[_0xa46636(0xc49)+_0xa46636(0x26a)+'a'])return;VisuMZ['ConvertPar'+_0xa46636(0xe3)](_0x3573cf,_0x3573cf);const _0x34eaac=$gameScreen[_0xa46636(0x1558)+_0xa46636(0x96d)]();_0x34eaac[_0xa46636(0x916)+'p']=_0x3573cf[_0xa46636(0x608)];}),PluginManager[_0xe90fac(0xbd6)+'mmand'](pluginData[_0xe90fac(0x14c)],'ActSeq_Cam'+_0xe90fac(0x974)+_0xe90fac(0x9da),_0x4fab7d=>{const _0x5f5b9b=_0xe90fac,_0x2448bf={'SSrcc':'battleCame'+'ra'};if(!SceneManager[_0x5f5b9b(0x11be)+_0x5f5b9b(0x3ad)]())return;if(!Imported[_0x5f5b9b(0xc49)+_0x5f5b9b(0x26a)+'a'])return;VisuMZ[_0x5f5b9b(0x15ae)+_0x5f5b9b(0xe3)](_0x4fab7d,_0x4fab7d);const _0x59fd67=$gameTemp[_0x5f5b9b(0xb71)+'ginCommand'+'Interprete'+'r'](),_0x46629e=_0x4fab7d[_0x5f5b9b(0xff9)+_0x5f5b9b(0xe18)];$gameScreen['setBattleC'+'ameraPoint'](_0x4fab7d[_0x5f5b9b(0x148f)],_0x4fab7d[_0x5f5b9b(0x7e7)],_0x4fab7d[_0x5f5b9b(0x825)],_0x4fab7d[_0x5f5b9b(0x1521)]);if(_0x46629e)_0x59fd67[_0x5f5b9b(0xdaa)+'e'](_0x2448bf[_0x5f5b9b(0x36c)]);}),PluginManager[_0xe90fac(0xbd6)+'mmand'](pluginData[_0xe90fac(0x14c)],'ActSeq_Cam'+_0xe90fac(0xfa1)+_0xe90fac(0x915),_0x5c2dc1=>{const _0x1a087c=_0xe90fac,_0x4e2175={'DSOhi':_0x1a087c(0x1558)+'ra'};if(!SceneManager[_0x1a087c(0x11be)+_0x1a087c(0x3ad)]())return;if(!Imported[_0x1a087c(0xc49)+'ctSeqCamer'+'a'])return;VisuMZ[_0x1a087c(0x15ae)+_0x1a087c(0xe3)](_0x5c2dc1,_0x5c2dc1);const _0xa4479=$gameTemp[_0x1a087c(0xb71)+_0x1a087c(0x10f2)+_0x1a087c(0x1b4)+'r'](),_0x469ecf=VisuMZ[_0x1a087c(0xd1a)+_0x1a087c(0x12fd)+_0x1a087c(0x1027)](_0x5c2dc1[_0x1a087c(0x1027)]),_0x105a15=_0x5c2dc1[_0x1a087c(0xff9)+_0x1a087c(0xe18)];$gameScreen[_0x1a087c(0xe24)+_0x1a087c(0xea2)+'ts'](_0x469ecf,_0x5c2dc1[_0x1a087c(0x825)],_0x5c2dc1[_0x1a087c(0x1521)]);if(_0x105a15)_0xa4479[_0x1a087c(0xdaa)+'e'](_0x4e2175[_0x1a087c(0xcd2)]);}),PluginManager['registerCo'+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],'ActSeq_Cam'+_0xe90fac(0x8fa),_0x2ce243=>{const _0x26d14c=_0xe90fac,_0x23b7c7={'TtdPe':'battleCame'+'ra'};if(!SceneManager['isSceneBat'+'tle']())return;if(!Imported['VisuMZ_3_A'+'ctSeqCamer'+'a'])return;VisuMZ[_0x26d14c(0x15ae)+'ams'](_0x2ce243,_0x2ce243);const _0x30f24d=$gameTemp['getLastPlu'+_0x26d14c(0x10f2)+_0x26d14c(0x1b4)+'r'](),_0x3c724c=_0x2ce243[_0x26d14c(0xff9)+_0x26d14c(0xe18)];$gameScreen[_0x26d14c(0xe24)+_0x26d14c(0x5ea)+'t'](_0x2ce243[_0x26d14c(0x11c6)],_0x2ce243['OffsetY'],_0x2ce243[_0x26d14c(0x825)],_0x2ce243[_0x26d14c(0x1521)]);if(_0x3c724c)_0x30f24d[_0x26d14c(0xdaa)+'e'](_0x23b7c7['TtdPe']);}),PluginManager['registerCo'+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0xced)+_0xe90fac(0xa05),_0x3291b9=>{const _0x3b0de1=_0xe90fac,_0xf1c563={'CEidp':function(_0x5dd99a,_0x5a102a){return _0x5dd99a/_0x5a102a;},'qhzrb':function(_0x55c542,_0x3a7aaa){return _0x55c542/_0x3a7aaa;},'PDvtH':_0x3b0de1(0x1558)+'ra'};if(!SceneManager[_0x3b0de1(0x11be)+_0x3b0de1(0x3ad)]())return;if(!Imported[_0x3b0de1(0xc49)+'ctSeqCamer'+'a'])return;VisuMZ[_0x3b0de1(0x15ae)+_0x3b0de1(0xe3)](_0x3291b9,_0x3291b9);const _0x4e69c2=$gameTemp[_0x3b0de1(0xb71)+_0x3b0de1(0x10f2)+'Interprete'+'r'](),_0x4d9c48=_0x3291b9[_0x3b0de1(0xc3a)],_0x23fafc=_0x3291b9[_0x3b0de1(0x55d)+'t'],_0x555d60=_0x3291b9['WaitForCam'+_0x3b0de1(0xe18)];if(_0x4d9c48){const _0x2a5318=Math[_0x3b0de1(0x10a1)](_0xf1c563[_0x3b0de1(0x810)](Graphics[_0x3b0de1(0x301)],0x1*0x1877+0x1832+-0x30a7)),_0x6946e9=Math[_0x3b0de1(0x10a1)](_0xf1c563[_0x3b0de1(0x1ca)](Graphics['height'],-0x2188+-0x2397+0x4521));$gameScreen[_0x3b0de1(0xe24)+_0x3b0de1(0xa8a)](_0x2a5318,_0x6946e9,_0x3291b9[_0x3b0de1(0x825)],_0x3291b9[_0x3b0de1(0x1521)]);}_0x23fafc&&$gameScreen[_0x3b0de1(0xe24)+_0x3b0de1(0x5ea)+'t'](0x16ad+0x72a+0x1*-0x1dd7,0x199b+-0x2431+0x5*0x21e,_0x3291b9[_0x3b0de1(0x825)],_0x3291b9[_0x3b0de1(0x1521)]);if(_0x555d60)_0x4e69c2[_0x3b0de1(0xdaa)+'e'](_0xf1c563[_0x3b0de1(0x149)]);}),PluginManager[_0xe90fac(0xbd6)+'mmand'](pluginData['name'],_0xe90fac(0xced)+_0xe90fac(0xc44)+_0xe90fac(0x612),_0x2ff465=>{const _0x1fa302=_0xe90fac,_0x4876bc={'NZURC':_0x1fa302(0x1558)+'ra'};if(!SceneManager[_0x1fa302(0x11be)+_0x1fa302(0x3ad)]())return;if(!Imported[_0x1fa302(0xc49)+_0x1fa302(0x26a)+'a'])return;const _0x48df10=$gameTemp['getLastPlu'+'ginCommand'+_0x1fa302(0x1b4)+'r']();if(!_0x48df10)return;_0x48df10['setWaitMod'+'e'](_0x4876bc[_0x1fa302(0xb0f)]);}),VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x11e9)+_0xe90fac(0x1ce)]=function(_0x3cad6c){const _0x33bd76=_0xe90fac,_0x41a849={'EhhQt':_0x33bd76(0x4ce)+'4','kBmJr':function(_0x22b8b5,_0x1cb5fd){return _0x22b8b5===_0x1cb5fd;},'ryQAb':_0x33bd76(0x13c3)};_0x3cad6c[_0x33bd76(0x130e)+'lename']='';const _0x464e31=VisuMZ['VisualCuti'+_0x33bd76(0xaac)][_0x33bd76(0x11e9)+_0x33bd76(0x1ce)](_0x3cad6c),_0x14e8fd=VisuMZ[_0x33bd76(0xd1a)+_0x33bd76(0x12fd)+'Targets'](_0x3cad6c['Targets'])[0x15aa+-0x7d3+-0xdd7]||null;if(_0x14e8fd){_0x464e31[_0x33bd76(0x130e)+'lename']=_0x14e8fd[_0x33bd76(0x97f)+_0x33bd76(0xe9)+_0x33bd76(0xa8e)](),_0x464e31[_0x33bd76(0x96f)+_0x33bd76(0x1227)]=_0x14e8fd['visualCuti'+'nPortraitI'+'ndex'](),_0x464e31[_0x33bd76(0xe46)+'e']=_0x14e8fd[_0x33bd76(0x97f)+'nPortraitH'+'ue'](),_0x464e31[_0x33bd76(0xe3e)+'pe']=_0x14e8fd[_0x33bd76(0x97f)+_0x33bd76(0x110f)+_0x33bd76(0xbbf)]();if(_0x14e8fd[_0x33bd76(0xb9a)]()){const _0x5a4d83=_0x41a849[_0x33bd76(0x14af)][_0x33bd76(0xab1)]('|');let _0x16163d=-0x1a59+-0x1d14+0x376d;while(!![]){switch(_0x5a4d83[_0x16163d++]){case'0':_0x14e8fd[_0x33bd76(0x699)+_0x33bd76(0xf9e)]()&&(_0x464e31[_0x33bd76(0x478)+'ipVert']=!_0x464e31[_0x33bd76(0x478)+_0x33bd76(0x3e7)]);continue;case'1':_0x3cad6c[_0x33bd76(0xda0)+_0x33bd76(0x1167)][_0x33bd76(0x13e1)+_0x33bd76(0x1360)+_0x33bd76(0xe78)]&&(_0x464e31[_0x33bd76(0x13e1)+_0x33bd76(0x933)]*=-(-0x1*0x15e9+-0x1627+-0x2c11*-0x1));continue;case'2':_0x3cad6c['ExtraSetti'+_0x33bd76(0x1167)]['parallaxSc'+'rollXinver'+_0x33bd76(0xe78)]&&(_0x464e31[_0x33bd76(0x13e1)+_0x33bd76(0x15ff)]*=-(-0xf*-0x12d+0x502+-0x16a4));continue;case'3':_0x14e8fd['flipVisual'+'CutinHorz']()&&(_0x464e31[_0x33bd76(0x478)+_0x33bd76(0xc0)]=!_0x464e31[_0x33bd76(0x478)+_0x33bd76(0xc0)]);continue;case'4':_0x464e31[_0x33bd76(0xaf3)+'e']+=_0x3cad6c[_0x33bd76(0xda0)+_0x33bd76(0x1167)]['parallaxHu'+'eEnemyModi'+_0x33bd76(0x14fd)]??-0x7*-0x70+0x1685+-0x1995;continue;case'5':_0x41a849[_0x33bd76(0x948)](_0x464e31[_0x33bd76(0xe3e)+'pe'],_0x41a849[_0x33bd76(0xbec)])&&(_0x464e31[_0x33bd76(0x478)+_0x33bd76(0xc0)]=!_0x464e31[_0x33bd76(0x478)+_0x33bd76(0xc0)]);continue;}break;}}}return _0x464e31;},PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],'ActSeq_Cut'+_0xe90fac(0xd20)+_0xe90fac(0x19b)+_0xe90fac(0x41d),_0x7e5e1c=>{const _0x1cfd24=_0xe90fac,_0x5b8ff8={'sTyMK':_0x1cfd24(0x991)};if(!SceneManager[_0x1cfd24(0x11be)+_0x1cfd24(0x3ad)]())return;if(!Imported[_0x1cfd24(0x15d0)+_0x1cfd24(0x1286)+_0x1cfd24(0x175)])return;VisuMZ['ConvertPar'+_0x1cfd24(0xe3)](_0x7e5e1c,_0x7e5e1c);const _0x70051a=VisuMZ[_0x1cfd24(0x118f)][_0x1cfd24(0x11e9)+_0x1cfd24(0x1ce)](_0x7e5e1c);SceneManager[_0x1cfd24(0x11dd)][_0x1cfd24(0xc9b)+_0x1cfd24(0x37a)](_0x70051a);const _0xfc69e4=$gameTemp[_0x1cfd24(0xb71)+'ginCommand'+_0x1cfd24(0x1b4)+'r']();_0xfc69e4&&_0x7e5e1c[_0x1cfd24(0x14cc)+_0x1cfd24(0x13ab)]&&_0xfc69e4['setWaitMod'+'e'](_0x5b8ff8[_0x1cfd24(0x322)]);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0xc93)+_0xe90fac(0x13b3)+_0xe90fac(0x19b)+_0xe90fac(0x62c),_0x396e7f=>{const _0x3fe1bd=_0xe90fac,_0x1ce560={'YmmeA':_0x3fe1bd(0x34d)};if(!SceneManager[_0x3fe1bd(0x11be)+_0x3fe1bd(0x3ad)]())return;if(!Imported[_0x3fe1bd(0x15d0)+_0x3fe1bd(0x1286)+_0x3fe1bd(0x175)])return;VisuMZ[_0x3fe1bd(0x15ae)+_0x3fe1bd(0xe3)](_0x396e7f,_0x396e7f),SceneManager[_0x3fe1bd(0x11dd)][_0x3fe1bd(0x33e)+_0x3fe1bd(0xcd9)]();const _0x39bfaf=$gameTemp[_0x3fe1bd(0xb71)+_0x3fe1bd(0x10f2)+_0x3fe1bd(0x1b4)+'r']();_0x39bfaf&&_0x396e7f[_0x3fe1bd(0xddf)+'t']&&_0x39bfaf[_0x3fe1bd(0xdaa)+'e'](_0x1ce560['YmmeA']);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0xc93)+_0xe90fac(0x13b3)+_0xe90fac(0x19b)+_0xe90fac(0xa43),_0xd85e57=>{const _0x4a206a=_0xe90fac,_0xa8c244={'BMwCi':'cutinExit'};if(!SceneManager[_0x4a206a(0x11be)+_0x4a206a(0x3ad)]())return;if(!Imported[_0x4a206a(0x15d0)+_0x4a206a(0x1286)+_0x4a206a(0x175)])return;VisuMZ['ConvertPar'+_0x4a206a(0xe3)](_0xd85e57,_0xd85e57);const _0x3a4870=_0xd85e57[_0x4a206a(0x152a)]['toLowerCas'+'e']()[_0x4a206a(0x808)]();SceneManager[_0x4a206a(0x11dd)][_0x4a206a(0xf37)+'utin'](_0x3a4870);const _0x3bf4c4=$gameTemp[_0x4a206a(0xb71)+'ginCommand'+_0x4a206a(0x1b4)+'r']();_0x3bf4c4&&_0xd85e57[_0x4a206a(0xddf)+'t']&&_0x3bf4c4[_0x4a206a(0xdaa)+'e'](_0xa8c244[_0x4a206a(0xd49)]);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0xc93)+_0xe90fac(0x434)+_0xe90fac(0xcd1),_0x70f440=>{const _0x500ea3=_0xe90fac,_0xd4bc5c={'wkhcw':_0x500ea3(0x991)};if(!SceneManager[_0x500ea3(0x11be)+_0x500ea3(0x3ad)]())return;if(!Imported[_0x500ea3(0x15d0)+'isualCutin'+_0x500ea3(0x175)])return;const _0x4d04cc=$gameTemp[_0x500ea3(0xb71)+'ginCommand'+'Interprete'+'r']();_0x4d04cc['setWaitMod'+'e'](_0xd4bc5c[_0x500ea3(0x140)]);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0xc93)+_0xe90fac(0x434)+_0xe90fac(0x132d),_0x284725=>{const _0x5bcf83=_0xe90fac,_0x14e707={'LcIPo':'cutinExit'};if(!SceneManager['isSceneBat'+'tle']())return;if(!Imported[_0x5bcf83(0x15d0)+_0x5bcf83(0x1286)+_0x5bcf83(0x175)])return;const _0x1d2352=$gameTemp['getLastPlu'+_0x5bcf83(0x10f2)+'Interprete'+'r']();_0x1d2352['setWaitMod'+'e'](_0x14e707[_0x5bcf83(0x1336)]);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],'ActSeq_DB_'+_0xe90fac(0x18f)+'sMotionAni',_0x208c60=>{const _0x56a180=_0xe90fac;if(!SceneManager['isSceneBat'+_0x56a180(0x3ad)]())return;if(!Imported[_0x56a180(0x10e)+_0x56a180(0xf49)+_0x56a180(0xa74)])return;VisuMZ[_0x56a180(0x15ae)+_0x56a180(0xe3)](_0x208c60,_0x208c60);const _0x1865e5=VisuMZ[_0x56a180(0xd1a)+_0x56a180(0x12fd)+_0x56a180(0x1027)](_0x208c60[_0x56a180(0x1027)]),_0x6a0f66=_0x208c60['MotionAni']['toLowerCas'+'e']()[_0x56a180(0x808)]();for(const _0x4561c1 of _0x1865e5){if(!_0x4561c1)continue;_0x4561c1[_0x56a180(0xc06)+_0x56a180(0x1238)+_0x56a180(0x1489)](_0x6a0f66);}}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x65c)+_0xe90fac(0x18f)+_0xe90fac(0x1f4),_0x46a546=>{const _0x4e4a19=_0xe90fac;if(!SceneManager[_0x4e4a19(0x11be)+_0x4e4a19(0x3ad)]())return;if(!Imported['VisuMZ_2_D'+_0x4e4a19(0xf49)+'Union'])return;VisuMZ[_0x4e4a19(0x15ae)+_0x4e4a19(0xe3)](_0x46a546,_0x46a546);const _0x14b790=VisuMZ[_0x4e4a19(0xd1a)+_0x4e4a19(0x12fd)+_0x4e4a19(0x1027)](_0x46a546[_0x4e4a19(0x1027)]),_0x54f4c1=_0x46a546['TimeScale'];for(const _0x5056a4 of _0x14b790){if(!_0x5056a4)continue;_0x5056a4[_0x4e4a19(0x1283)+_0x4e4a19(0x227)]()[_0x4e4a19(0xc75)]=_0x54f4c1;}}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],'ActSeq_Ele'+_0xe90fac(0x1233)+_0xe90fac(0xa0a),_0x55ac6e=>{const _0x2c3c0b=_0xe90fac;if(!SceneManager[_0x2c3c0b(0x11be)+'tle']())return;if(!Imported[_0x2c3c0b(0xc89)+_0x2c3c0b(0x139d)+_0x2c3c0b(0x657)])return;VisuMZ[_0x2c3c0b(0x15ae)+_0x2c3c0b(0xe3)](_0x55ac6e,_0x55ac6e);const _0x37a829=BattleManager[_0x2c3c0b(0xc37)],_0x45dce1=_0x55ac6e[_0x2c3c0b(0xb6f)];if(!_0x37a829)return;_0x37a829[_0x2c3c0b(0x89f)+_0x2c3c0b(0xba6)+'ents']=_0x45dce1;}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x46f)+_0xe90fac(0x12e5),_0x5e033d=>{const _0x3005fb=_0xe90fac;if(!SceneManager[_0x3005fb(0x11be)+_0x3005fb(0x3ad)]())return;if(!Imported['VisuMZ_1_E'+_0x3005fb(0x139d)+'usCore'])return;const _0x120fc2=BattleManager[_0x3005fb(0xc37)];if(!_0x120fc2)return;_0x120fc2[_0x3005fb(0xdce)+_0x3005fb(0x1255)]();}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],'ActSeq_Ele'+_0xe90fac(0xfef)+_0xe90fac(0xb6f),_0x186282=>{const _0xa214b7=_0xe90fac;if(!SceneManager[_0xa214b7(0x11be)+_0xa214b7(0x3ad)]())return;if(!Imported['VisuMZ_1_E'+_0xa214b7(0x139d)+_0xa214b7(0x657)])return;VisuMZ[_0xa214b7(0x15ae)+_0xa214b7(0xe3)](_0x186282,_0x186282);const _0x59164e=BattleManager[_0xa214b7(0xc37)],_0x1fe312=_0x186282[_0xa214b7(0xb6f)];if(!_0x59164e)return;_0x59164e[_0xa214b7(0x89f)+'eForcedEle'+_0xa214b7(0x137c)]=_0x1fe312;}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x46f)+_0xe90fac(0xa01)+_0xe90fac(0xb80),_0x42d3c4=>{const _0x414c6c=_0xe90fac;if(!SceneManager[_0x414c6c(0x11be)+_0x414c6c(0x3ad)]())return;if(!Imported[_0x414c6c(0xc89)+_0x414c6c(0x139d)+_0x414c6c(0x657)])return;const _0x483e74=BattleManager[_0x414c6c(0xc37)];if(!_0x483e74)return;_0x483e74[_0x414c6c(0x89f)+_0x414c6c(0x6bd)]=!![];}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],'ActSeq_Gri'+_0xe90fac(0x8c6)+_0xe90fac(0x1fe)+_0xe90fac(0xab4),_0x22bd27=>{const _0x5ccf08=_0xe90fac;VisuMZ[_0x5ccf08(0x10c3)+_0x5ccf08(0xf48)]['ActSeq_Gri'+'d_ActionAn'+'imationAtN'+_0x5ccf08(0xab4)](_0x22bd27);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData['name'],_0xe90fac(0x8d6)+_0xe90fac(0xed7)+_0xe90fac(0x844)+_0xe90fac(0x1315),_0x2b594b=>{const _0x5eedbc=_0xe90fac;VisuMZ[_0x5eedbc(0x10c3)+_0x5eedbc(0xf48)][_0x5eedbc(0x8d6)+_0x5eedbc(0xed7)+'veStatesTo'+'Node'](_0x2b594b);}),PluginManager['registerCo'+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x8d6)+_0xe90fac(0xe67)+_0xe90fac(0xfa7),_0x5b82e8=>{const _0x459313=_0xe90fac;VisuMZ[_0x459313(0x10c3)+'System'][_0x459313(0x8d6)+_0x459313(0xe67)+'erToNode'](_0x5b82e8);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],'ActSeq_Gri'+_0xe90fac(0xe67)+'erToNodeJS',_0x3c8ab8=>{const _0x41d82f=_0xe90fac;VisuMZ[_0x41d82f(0x10c3)+_0x41d82f(0xf48)][_0x41d82f(0x8d6)+_0x41d82f(0xe67)+_0x41d82f(0xfa7)](_0x3c8ab8);}),PluginManager[_0xe90fac(0xbd6)+'mmand'](pluginData['name'],_0xe90fac(0x8d6)+_0xe90fac(0xbfc)+_0xe90fac(0x7cb),_0x46fb9c=>{const _0x13bade=_0xe90fac;VisuMZ['BattleGrid'+_0x13bade(0xf48)][_0x13bade(0x8d6)+_0x13bade(0xbfc)+_0x13bade(0x7cb)](_0x46fb9c);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x8d6)+_0xe90fac(0xbfc)+'nJsAtNode',_0x3b1ab9=>{const _0x1200d9=_0xe90fac;VisuMZ[_0x1200d9(0x10c3)+_0x1200d9(0xf48)][_0x1200d9(0x8d6)+'d_Animatio'+'nJsAtNode'](_0x3b1ab9);}),PluginManager[_0xe90fac(0xbd6)+'mmand'](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x8d6)+_0xe90fac(0xbfc)+_0xe90fac(0xc50)+'e',_0x4c7ac7=>{const _0x3f48b6=_0xe90fac;VisuMZ[_0x3f48b6(0x10c3)+_0x3f48b6(0xf48)]['ActSeq_Gri'+'d_Animatio'+_0x3f48b6(0xc50)+'e'](_0x4c7ac7);}),PluginManager['registerCo'+_0xe90fac(0xc22)](pluginData['name'],_0xe90fac(0x8d6)+_0xe90fac(0xa75)+_0xe90fac(0x1105)+_0xe90fac(0xf15),_0x3de832=>{const _0x1063eb=_0xe90fac;VisuMZ[_0x1063eb(0x10c3)+_0x1063eb(0xf48)][_0x1063eb(0x8d6)+'d_ClearPas'+_0x1063eb(0x1105)+_0x1063eb(0xf15)](_0x3de832);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData['name'],_0xe90fac(0x8d6)+'d_MoveTarg'+_0xe90fac(0xbe7)+'tion',_0x370637=>{const _0x549ab5=_0xe90fac;VisuMZ['BattleGrid'+_0x549ab5(0xf48)][_0x549ab5(0x8d6)+'d_MoveTarg'+_0x549ab5(0xbe7)+_0x549ab5(0x1580)](_0x370637);}),PluginManager['registerCo'+'mmand'](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x8d6)+_0xe90fac(0xacd)+_0xe90fac(0x9b3),_0x2ba325=>{const _0x3fd555=_0xe90fac;VisuMZ['BattleGrid'+_0x3fd555(0xf48)][_0x3fd555(0x8d6)+_0x3fd555(0xacd)+_0x3fd555(0x9b3)](_0x2ba325);}),PluginManager[_0xe90fac(0xbd6)+'mmand'](pluginData['name'],_0xe90fac(0x8d6)+_0xe90fac(0xff3)+_0xe90fac(0x125f),_0x1a77d4=>{const _0x32a6b6=_0xe90fac;VisuMZ['BattleGrid'+'System'][_0x32a6b6(0x8d6)+_0x32a6b6(0xff3)+_0x32a6b6(0x125f)](_0x1a77d4);}),PluginManager['registerCo'+'mmand'](pluginData['name'],'ActSeq_Gri'+_0xe90fac(0xbf7)+'ssiveState'+_0xe90fac(0x2ad),_0x57674d=>{const _0x5268b2=_0xe90fac;VisuMZ[_0x5268b2(0x10c3)+_0x5268b2(0xf48)][_0x5268b2(0x8d6)+_0x5268b2(0xbf7)+_0x5268b2(0x1495)+_0x5268b2(0x2ad)](_0x57674d);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x8d6)+'d_RemoveTr'+_0xe90fac(0x8b2)+'ode',_0x2d8a53=>{const _0x54685e=_0xe90fac;VisuMZ[_0x54685e(0x10c3)+_0x54685e(0xf48)][_0x54685e(0x8d6)+_0x54685e(0x53b)+_0x54685e(0x8b2)+_0x54685e(0xab4)](_0x2d8a53);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x8d6)+_0xe90fac(0x143f)+_0xe90fac(0x293),_0x2583b6=>{const _0x19c6d3=_0xe90fac;VisuMZ[_0x19c6d3(0x10c3)+_0x19c6d3(0xf48)][_0x19c6d3(0x8d6)+_0x19c6d3(0x143f)+'ToNode'](_0x2583b6);}),PluginManager[_0xe90fac(0xbd6)+'mmand'](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x8d6)+_0xe90fac(0x742)+'ToNode',_0x1ebf1b=>{const _0x4dafbe=_0xe90fac;VisuMZ['BattleGrid'+_0x4dafbe(0xf48)][_0x4dafbe(0x8d6)+_0x4dafbe(0x742)+_0x4dafbe(0x293)](_0x1ebf1b);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],'ActSeq_Hor'+_0xe90fac(0x52b),_0x4971cc=>{const _0x3179e5=_0xe90fac,_0x2216f1={'Rlwzb':_0x3179e5(0x1024),'EZnJN':_0x3179e5(0xa5d)};if(!Imported['VisuMZ_2_H'+'orrorEffec'+'ts'])return;if(!SceneManager[_0x3179e5(0x11be)+'tle']())return;VisuMZ['ConvertPar'+_0x3179e5(0xe3)](_0x4971cc,_0x4971cc);const _0x5bb6a8=VisuMZ['CreateActi'+_0x3179e5(0x12fd)+_0x3179e5(0x1027)](_0x4971cc[_0x3179e5(0x1027)]);for(const _0x192bc7 of _0x5bb6a8){if(!_0x192bc7)continue;_0x192bc7[_0x3179e5(0x639)+_0x3179e5(0x11b5)](_0x2216f1[_0x3179e5(0xb4c)]),_0x192bc7['removeHorr'+_0x3179e5(0x11b5)](_0x2216f1[_0x3179e5(0x1052)]),_0x192bc7['removeHorr'+_0x3179e5(0x11b5)]('tv'),_0x192bc7['clearHorro'+_0x3179e5(0x69e)]();}$gamePlayer['refresh']();}),PluginManager['registerCo'+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],'ActSeq_Hor'+_0xe90fac(0xb07)+_0xe90fac(0x734),_0x2b08b7=>{const _0x4c63a2=_0xe90fac,_0xc5a69e={'MWXXU':_0x4c63a2(0xa5d),'HZBgt':function(_0x1756e3,_0x1e2118){return _0x1756e3/_0x1e2118;}};if(!Imported[_0x4c63a2(0xa5)+_0x4c63a2(0x7ac)+'ts'])return;if(!SceneManager['isSceneBat'+_0x4c63a2(0x3ad)]())return;VisuMZ[_0x4c63a2(0x15ae)+_0x4c63a2(0xe3)](_0x2b08b7,_0x2b08b7);const _0x262b92=VisuMZ['CreateActi'+'onSequence'+_0x4c63a2(0x1027)](_0x2b08b7[_0x4c63a2(0x1027)]),_0x654476=_0xc5a69e[_0x4c63a2(0x1257)];_0x2b08b7[_0x4c63a2(0x8d)]=Math['ceil'](_0xc5a69e[_0x4c63a2(0x19d)](_0x2b08b7[_0x4c63a2(0xd6c)],0x1031+-0x2577+-0x18*-0xe3)),_0x2b08b7[_0x4c63a2(0x9ee)]=_0x2b08b7[_0x4c63a2(0xd6c)],_0x2b08b7['refreshReq'+_0x4c63a2(0x481)]=!![];for(const _0x36c425 of _0x262b92){if(!_0x36c425)continue;_0x36c425[_0x4c63a2(0x121b)+_0x4c63a2(0xff8)+'ngs'](_0x654476,_0x2b08b7);}$gamePlayer['refresh']();}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x102a)+_0xe90fac(0xb07)+_0xe90fac(0x28f),_0x4590d1=>{const _0x38851a=_0xe90fac,_0x895ad5={'nkbnS':'glitch'};if(!Imported['VisuMZ_2_H'+_0x38851a(0x7ac)+'ts'])return;if(!SceneManager[_0x38851a(0x11be)+_0x38851a(0x3ad)]())return;VisuMZ[_0x38851a(0x15ae)+_0x38851a(0xe3)](_0x4590d1,_0x4590d1);const _0x5467ca=VisuMZ['CreateActi'+'onSequence'+_0x38851a(0x1027)](_0x4590d1[_0x38851a(0x1027)]);for(const _0x2c48b4 of _0x5467ca){if(!_0x2c48b4)continue;_0x2c48b4[_0x38851a(0x639)+_0x38851a(0x11b5)](_0x895ad5['nkbnS']);}$gamePlayer['refresh']();}),PluginManager['registerCo'+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],'ActSeq_Hor'+_0xe90fac(0x88d)+_0xe90fac(0xd9b),_0xf2dcd0=>{const _0x510752=_0xe90fac,_0x16f8ba={'yZnZi':_0x510752(0x1024)};if(!Imported[_0x510752(0xa5)+'orrorEffec'+'ts'])return;if(!SceneManager[_0x510752(0x11be)+_0x510752(0x3ad)]())return;VisuMZ[_0x510752(0x15ae)+_0x510752(0xe3)](_0xf2dcd0,_0xf2dcd0);const _0x5481ef=VisuMZ['CreateActi'+_0x510752(0x12fd)+_0x510752(0x1027)](_0xf2dcd0[_0x510752(0x1027)]),_0x1fd5a5=_0x16f8ba[_0x510752(0x784)];for(const _0x201f86 of _0x5481ef){if(!_0x201f86)continue;_0x201f86[_0x510752(0x121b)+_0x510752(0xff8)+_0x510752(0x1167)](_0x1fd5a5,_0xf2dcd0);}$gamePlayer[_0x510752(0x944)]();}),PluginManager[_0xe90fac(0xbd6)+'mmand'](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x102a)+_0xe90fac(0xab)+_0xe90fac(0xcad),_0x5969e9=>{const _0x126d0e=_0xe90fac,_0x1c09ed={'ldsvI':'noise'};if(!Imported['VisuMZ_2_H'+_0x126d0e(0x7ac)+'ts'])return;if(!SceneManager[_0x126d0e(0x11be)+_0x126d0e(0x3ad)]())return;VisuMZ[_0x126d0e(0x15ae)+_0x126d0e(0xe3)](_0x5969e9,_0x5969e9);const _0x1fe2a5=VisuMZ[_0x126d0e(0xd1a)+_0x126d0e(0x12fd)+_0x126d0e(0x1027)](_0x5969e9[_0x126d0e(0x1027)]);for(const _0xc8cc54 of _0x1fe2a5){if(!_0xc8cc54)continue;_0xc8cc54['removeHorr'+_0x126d0e(0x11b5)](_0x1c09ed[_0x126d0e(0xb48)]);}$gamePlayer[_0x126d0e(0x944)]();}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData['name'],_0xe90fac(0x102a)+_0xe90fac(0x105b)+'te',_0xa93fd6=>{const _0x5b1577=_0xe90fac;if(!Imported[_0x5b1577(0xa5)+_0x5b1577(0x7ac)+'ts'])return;if(!SceneManager[_0x5b1577(0x11be)+_0x5b1577(0x3ad)]())return;VisuMZ[_0x5b1577(0x15ae)+_0x5b1577(0xe3)](_0xa93fd6,_0xa93fd6);const _0x44e5ca=VisuMZ[_0x5b1577(0xd1a)+_0x5b1577(0x12fd)+_0x5b1577(0x1027)](_0xa93fd6[_0x5b1577(0x1027)]),_0x2d88a1='tv';for(const _0x51741a of _0x44e5ca){if(!_0x51741a)continue;_0x51741a[_0x5b1577(0x121b)+_0x5b1577(0xff8)+_0x5b1577(0x1167)](_0x2d88a1,_0xa93fd6);}$gamePlayer[_0x5b1577(0x944)]();}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x102a)+_0xe90fac(0x4d9)+'ve',_0x4b4a4f=>{const _0x4f01f1=_0xe90fac;if(!Imported[_0x4f01f1(0xa5)+_0x4f01f1(0x7ac)+'ts'])return;if(!SceneManager[_0x4f01f1(0x11be)+_0x4f01f1(0x3ad)]())return;VisuMZ[_0x4f01f1(0x15ae)+_0x4f01f1(0xe3)](_0x4b4a4f,_0x4b4a4f);const _0x3b4605=VisuMZ[_0x4f01f1(0xd1a)+_0x4f01f1(0x12fd)+_0x4f01f1(0x1027)](_0x4b4a4f[_0x4f01f1(0x1027)]);for(const _0x4d826a of _0x3b4605){if(!_0x4d826a)continue;_0x4d826a[_0x4f01f1(0x639)+_0x4f01f1(0x11b5)]('tv');}$gamePlayer[_0x4f01f1(0x944)]();}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0xca1)+_0xe90fac(0x147d)+_0xe90fac(0xb36),_0x1d25bb=>{const _0x2c1387=_0xe90fac,_0x29d8db={'XYllc':function(_0x1de742,_0x49a6dc){return _0x1de742<=_0x49a6dc;},'LJjlH':function(_0x306db0,_0x464849){return _0x306db0(_0x464849);},'KExri':'Action\x20Seq'+_0x2c1387(0x7f2)+'ct\x20needs\x20a'+_0x2c1387(0x381)};if(!Imported['VisuMZ_3_A'+_0x2c1387(0x386)+'t'])return;const _0x8d4830=SceneManager['_scene'][_0x2c1387(0x981)];if(!_0x8d4830)return;if(_0x29d8db[_0x2c1387(0xee0)](VisuMZ['ActSeqImpa'+'ct'][_0x2c1387(0x6ca)],-0x1342+0x267*-0x4+0x1cdf+0.040000000000000036)){_0x29d8db[_0x2c1387(0xe2b)](alert,_0x29d8db[_0x2c1387(0x4c2)]),SceneManager[_0x2c1387(0x10c0)]();return;}VisuMZ['ConvertPar'+_0x2c1387(0xe3)](_0x1d25bb,_0x1d25bb);const _0x836cd1=_0x1d25bb[_0x2c1387(0x159b)];_0x8d4830[_0x2c1387(0x13ed)+_0x2c1387(0x9f8)+_0x2c1387(0xd33)](_0x836cd1);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData['name'],_0xe90fac(0xca1)+'act_ColorB'+_0xe90fac(0x127e),_0x118c8e=>{const _0x5008fc=_0xe90fac,_0x1d3718={'MEnLS':_0x5008fc(0x44a)};if(!SceneManager['isSceneBat'+'tle']())return;if(!Imported[_0x5008fc(0xc49)+'ctSeqImpac'+'t'])return;const _0x615f48=SceneManager[_0x5008fc(0x11dd)][_0x5008fc(0x981)];if(!_0x615f48)return;VisuMZ[_0x5008fc(0x15ae)+'ams'](_0x118c8e,_0x118c8e);const _0x1d0491=_0x118c8e[_0x5008fc(0x897)]||-0x2d*-0x9d+-0x2127+0x58f*0x1,_0x28ac1e=_0x118c8e[_0x5008fc(0x825)]||-0x6c0+-0x1a8*0x12+0x2491,_0x4d6bc4=_0x118c8e[_0x5008fc(0x1521)]||_0x1d3718['MEnLS'];_0x615f48[_0x5008fc(0x1307)+'litImpactF'+_0x5008fc(0x363)](_0x1d0491,_0x28ac1e,_0x4d6bc4);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0xca1)+_0xe90fac(0x4b0)+_0xe90fac(0x104),_0x367114=>{const _0x520b9e=_0xe90fac,_0xd6b180={'hSZJm':function(_0x2335bc,_0x51c00a){return _0x2335bc<=_0x51c00a;},'eFvaj':function(_0x10ec81,_0x389ad6){return _0x10ec81(_0x389ad6);},'ZBQbW':'Action\x20Seq'+'uence\x20Impa'+'ct\x20needs\x20a'+_0x520b9e(0x381)};if(!Imported['VisuMZ_3_A'+_0x520b9e(0x386)+'t'])return;const _0xd725c7=SceneManager[_0x520b9e(0x11dd)][_0x520b9e(0x981)];if(!_0xd725c7)return;if(_0xd6b180[_0x520b9e(0x861)](VisuMZ[_0x520b9e(0x42e)+'ct'][_0x520b9e(0x6ca)],-0x2473+-0x1ceb*0x1+0x415f+0.040000000000000036)){_0xd6b180['eFvaj'](alert,_0xd6b180[_0x520b9e(0x5ff)]),SceneManager[_0x520b9e(0x10c0)]();return;}VisuMZ['ConvertPar'+'ams'](_0x367114,_0x367114);const _0x49c6cc=_0x367114[_0x520b9e(0x159b)];_0xd725c7['setupDesat'+_0x520b9e(0x149a)+_0x520b9e(0xbf9)](_0x49c6cc);}),PluginManager['registerCo'+_0xe90fac(0xc22)](pluginData['name'],_0xe90fac(0xca1)+_0xe90fac(0x222)+'BlurScreen',_0x31d5bc=>{const _0x32df74=_0xe90fac,_0x1464dc={'tyswV':function(_0x5beb5a,_0x12d958){return _0x5beb5a(_0x12d958);},'JjIyO':function(_0x3d9b69,_0x1f0cb0){return _0x3d9b69(_0x1f0cb0);},'DfBFk':_0x32df74(0x44a)};if(!SceneManager[_0x32df74(0x11be)+_0x32df74(0x3ad)]())return;if(!Imported[_0x32df74(0xc49)+_0x32df74(0x386)+'t'])return;const _0x4c3d37=SceneManager[_0x32df74(0x11dd)][_0x32df74(0x981)];if(!_0x4c3d37)return;VisuMZ[_0x32df74(0x15ae)+_0x32df74(0xe3)](_0x31d5bc,_0x31d5bc);const _0x4e541e=_0x1464dc[_0x32df74(0xaee)](Number,_0x31d5bc['Angle'])||0xedd*0x2+0x1*-0x665+0x1755*-0x1,_0x3151fe=_0x1464dc['JjIyO'](Number,_0x31d5bc['Rate']),_0xb3c14=_0x31d5bc[_0x32df74(0x825)]||-0xf9f+-0xc0b+0x1bab*0x1,_0xe5eed9=_0x31d5bc[_0x32df74(0x1521)]||_0x1464dc[_0x32df74(0x270)];_0x4c3d37[_0x32df74(0x12b2)+_0x32df74(0xf13)+_0x32df74(0xbf9)](_0x4e541e,_0x3151fe,_0xb3c14,_0xe5eed9);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData['name'],'ActSeq_Imp'+_0xe90fac(0x222)+_0xe90fac(0xe1),_0x539877=>{const _0x5993a1=_0xe90fac,_0x5177fc={'kKtol':function(_0x1552da,_0x304f31){return _0x1552da(_0x304f31);},'HRxLq':function(_0x1ee191,_0x5e7f75){return _0x1ee191(_0x5e7f75);},'olHeB':_0x5993a1(0x44a)};if(!SceneManager[_0x5993a1(0x11be)+_0x5993a1(0x3ad)]())return;if(!Imported[_0x5993a1(0xc49)+_0x5993a1(0x386)+'t'])return;const _0x2d957a=SceneManager[_0x5993a1(0x11dd)]['_spriteset'];if(!_0x2d957a)return;VisuMZ[_0x5993a1(0x15ae)+'ams'](_0x539877,_0x539877);const _0x2023ab=_0x5177fc[_0x5993a1(0x75f)](Number,_0x539877['Angle'])||0xeb*0x2+-0x16eb*-0x1+-0x18c1,_0x2dcaad=_0x5177fc[_0x5993a1(0xb4)](Number,_0x539877['Rate']),_0x51e50b=_0x539877[_0x5993a1(0x825)]||0x1069+0x2428+0x8*-0x692,_0xa40bf1=_0x539877[_0x5993a1(0x1521)]||_0x5177fc[_0x5993a1(0x12e2)],_0x5d74f1=VisuMZ[_0x5993a1(0xd1a)+'onSequence'+'Targets'](_0x539877[_0x5993a1(0x1027)]);for(const _0x126740 of _0x5d74f1){if(!_0x126740)continue;if(!_0x126740[_0x5993a1(0x81d)]())continue;_0x126740[_0x5993a1(0x81d)]()[_0x5993a1(0x12b2)+_0x5993a1(0xf13)+_0x5993a1(0xbf9)](_0x2023ab,_0x2dcaad,_0x51e50b,_0xa40bf1);}}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0xca1)+_0xe90fac(0x222)+_0xe90fac(0xac9)+'e',_0x42998d=>{const _0x4bef7c=_0xe90fac;if(!SceneManager[_0x4bef7c(0x11be)+_0x4bef7c(0x3ad)]())return;if(!Imported['VisuMZ_3_A'+_0x4bef7c(0x386)+'t'])return;VisuMZ[_0x4bef7c(0x15ae)+'ams'](_0x42998d,_0x42998d);const _0x3af27a={'delay':_0x42998d['delay'],'duration':_0x42998d['duration'],'hue':_0x42998d[_0x4bef7c(0x104c)],'opacityStart':_0x42998d['opacitySta'+'rt'],'tone':_0x42998d[_0x4bef7c(0x14c4)],'visible':!![]},_0x2f3982=VisuMZ['CreateActi'+'onSequence'+'Targets'](_0x42998d[_0x4bef7c(0x1027)]);for(const _0x3a301b of _0x2f3982){if(!_0x3a301b)continue;_0x3a301b['setBattler'+_0x4bef7c(0x900)+_0x4bef7c(0x141c)](_0x3af27a);}}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0xca1)+'act_Motion'+_0xe90fac(0xc08)+'e',_0x5a7e9b=>{const _0x5b359d=_0xe90fac;if(!SceneManager[_0x5b359d(0x11be)+_0x5b359d(0x3ad)]())return;if(!Imported[_0x5b359d(0xc49)+_0x5b359d(0x386)+'t'])return;VisuMZ[_0x5b359d(0x15ae)+_0x5b359d(0xe3)](_0x5a7e9b,_0x5a7e9b);const _0x2ba3c6=VisuMZ[_0x5b359d(0xd1a)+'onSequence'+'Targets'](_0x5a7e9b['Targets']);for(const _0x2285d7 of _0x2ba3c6){if(!_0x2285d7)continue;_0x2285d7['clearBattl'+_0x5b359d(0xeff)+_0x5b359d(0x125b)]();}}),PluginManager[_0xe90fac(0xbd6)+'mmand'](pluginData[_0xe90fac(0x14c)],_0xe90fac(0xca1)+'act_Negati'+'ve',_0xa7d29e=>{const _0x23aa70=_0xe90fac,_0x2fa4b0={'Ocwlh':function(_0x6343d1,_0x5020ba){return _0x6343d1<=_0x5020ba;},'hNPLw':function(_0x35d484,_0x43b18d){return _0x35d484(_0x43b18d);},'ouHXv':'Action\x20Seq'+_0x23aa70(0x7f2)+_0x23aa70(0x9e0)+_0x23aa70(0x381)};if(!Imported[_0x23aa70(0xc49)+_0x23aa70(0x386)+'t'])return;const _0x420aca=SceneManager['_scene'][_0x23aa70(0x981)];if(!_0x420aca)return;if(_0x2fa4b0[_0x23aa70(0x4ec)](VisuMZ[_0x23aa70(0x42e)+'ct']['version'],-0x22f8+-0x7f*-0x2b+0xda4+0.040000000000000036)){_0x2fa4b0[_0x23aa70(0xc8a)](alert,_0x2fa4b0[_0x23aa70(0xb64)]),SceneManager[_0x23aa70(0x10c0)]();return;}VisuMZ[_0x23aa70(0x15ae)+_0x23aa70(0xe3)](_0xa7d29e,_0xa7d29e);const _0x1b6598=_0xa7d29e[_0x23aa70(0x159b)];_0x420aca[_0x23aa70(0x337)+_0x23aa70(0x1579)+_0x23aa70(0x363)](_0x1b6598);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0xca1)+'act_Oversa'+_0xe90fac(0x51e),_0x4b593b=>{const _0xf44ef=_0xe90fac,_0x502a93={'mDSpT':function(_0x3f6dae,_0x3d336e){return _0x3f6dae<=_0x3d336e;},'oCJxD':function(_0x180780,_0x4a0978){return _0x180780(_0x4a0978);},'qJbPW':'Action\x20Seq'+_0xf44ef(0x7f2)+_0xf44ef(0x9e0)+_0xf44ef(0x381)};if(!Imported[_0xf44ef(0xc49)+'ctSeqImpac'+'t'])return;const _0x5a2a6f=SceneManager['_scene'][_0xf44ef(0x981)];if(!_0x5a2a6f)return;if(_0x502a93[_0xf44ef(0x10e6)](VisuMZ['ActSeqImpa'+'ct'][_0xf44ef(0x6ca)],-0xddc+0x1310+-0xb*0x79+0.040000000000000036)){_0x502a93[_0xf44ef(0xceb)](alert,_0x502a93[_0xf44ef(0xedb)]),SceneManager[_0xf44ef(0x10c0)]();return;}VisuMZ[_0xf44ef(0x15ae)+'ams'](_0x4b593b,_0x4b593b);const _0x16c9ca=_0x4b593b[_0xf44ef(0x159b)];_0x5a2a6f[_0xf44ef(0xa51)+_0xf44ef(0xc8f)+_0xf44ef(0x779)](_0x16c9ca);}),PluginManager['registerCo'+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0xca1)+_0xe90fac(0x268)+'avePoint',_0x5253db=>{const _0x29e8a4=_0xe90fac;if(!Imported[_0x29e8a4(0xc49)+'ctSeqImpac'+'t'])return;const _0x5a7559=SceneManager[_0x29e8a4(0x11dd)][_0x29e8a4(0x981)];if(!_0x5a7559)return;VisuMZ[_0x29e8a4(0x15ae)+_0x29e8a4(0xe3)](_0x5253db,_0x5253db);const _0x1532ec=_0x5253db['X']||-0x1ac+-0x1d03+0x1eaf,_0x14d660=_0x5253db['Y']||0x22ec+0x2047*-0x1+-0x2a5,_0x4fa9ac=_0x5253db['Amp']||-0x16f6+-0xb16+0x220c,_0x1681f0=_0x5253db['Wave']||0x1632+0x1973+-0x2fa5,_0x1ae316=_0x5253db['Duration']||-0x539+0x1*-0x2d7+-0x19d*-0x5;_0x5a7559[_0x29e8a4(0x2e0)+_0x29e8a4(0xc01)+_0x29e8a4(0x757)](_0x1532ec,_0x14d660,_0x4fa9ac,_0x1681f0,_0x1ae316);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData['name'],_0xe90fac(0xca1)+'act_Shockw'+'aveEachTar'+_0xe90fac(0x1297),_0x38b7eb=>{const _0x396ebd=_0xe90fac,_0x29844c={'gWSpq':function(_0x191b61,_0x32c911){return _0x191b61/_0x32c911;},'uDtJo':function(_0xb46e3,_0xbcc5d5){return _0xb46e3-_0xbcc5d5;},'DyoVa':function(_0x184939,_0x1c7524){return _0x184939/_0x1c7524;},'nucmw':function(_0x21afaf,_0x572e8d){return _0x21afaf*_0x572e8d;},'aHcxH':function(_0x22762d,_0x14e635){return _0x22762d/_0x14e635;},'sBpdR':function(_0x550676,_0x2ef139){return _0x550676*_0x2ef139;}};if(!SceneManager[_0x396ebd(0x11be)+'tle']())return;if(!Imported[_0x396ebd(0xc49)+_0x396ebd(0x386)+'t'])return;const _0x142c61=SceneManager[_0x396ebd(0x11dd)][_0x396ebd(0x981)];if(!_0x142c61)return;VisuMZ['ConvertPar'+_0x396ebd(0xe3)](_0x38b7eb,_0x38b7eb);const _0x3c9bf5=VisuMZ[_0x396ebd(0xd1a)+'onSequence'+'Targets'](_0x38b7eb['Targets']),_0x1e7e72=_0x38b7eb[_0x396ebd(0x400)+_0x396ebd(0x1580)],_0x37178a=_0x38b7eb[_0x396ebd(0x11c6)]||-0x24f*0xa+0x1ed5+-0x7bf,_0x4ab310=_0x38b7eb[_0x396ebd(0xc1e)]||0xe1a*0x1+0x71d*0x3+-0x2371,_0x26e055=_0x38b7eb[_0x396ebd(0xab0)]||0x49*-0x2+0x461*0x3+-0xc91,_0x53e0cc=_0x38b7eb[_0x396ebd(0x1061)]||-0x3be*0x7+-0x88e+-0x4*-0x8b0,_0x3b0b40=_0x38b7eb[_0x396ebd(0x825)]||0x13c9+-0x56c*0x3+-0x384;for(const _0x551ec8 of _0x3c9bf5){if(!_0x551ec8)continue;if(!_0x551ec8[_0x396ebd(0x81d)]())continue;const _0xb93299=_0x551ec8[_0x396ebd(0x81d)]();let _0x583658=_0xb93299[_0x396ebd(0x156)],_0x23c41a=_0xb93299[_0x396ebd(0x1098)];_0x583658+=_0x29844c[_0x396ebd(0x85f)](_0x29844c[_0x396ebd(0x697)](Graphics[_0x396ebd(0x301)],Graphics[_0x396ebd(0x3dc)]),0x1678+-0x7e4*-0x1+-0xde*0x23),_0x23c41a+=_0x29844c[_0x396ebd(0x85f)](_0x29844c[_0x396ebd(0x697)](Graphics[_0x396ebd(0xa68)],Graphics[_0x396ebd(0x7b7)]),0x2086+-0x2623+-0x1*-0x59f);if(_0x1e7e72[_0x396ebd(0x3eb)](/front/i))_0x583658+=_0x29844c[_0x396ebd(0x8fd)](_0x29844c[_0x396ebd(0xc45)](_0x551ec8[_0x396ebd(0xb9a)]()?-0x1ea4+0x142c+0x7*0x17f:-(0x59f*0x6+-0xd5b*-0x1+-0x2f14),_0xb93299[_0x396ebd(0x4a7)+_0x396ebd(0x56a)]()),-0x1*-0x26e7+0x50*-0x30+-0x17e5);else _0x1e7e72[_0x396ebd(0x3eb)](/back/i)&&(_0x583658+=_0x29844c['aHcxH'](_0x29844c[_0x396ebd(0xf9b)](_0x551ec8[_0x396ebd(0xb9a)]()?-(-0x269b+-0x20b7+-0x1*-0x4753):0x1*-0x84e+0x1*0x1cda+-0x148b*0x1,_0xb93299['mainSprite'+'Width']()),0x2b*0xb+0x20b3+0x1*-0x228a));if(_0x1e7e72[_0x396ebd(0x3eb)](/head/i))_0x23c41a-=_0xb93299[_0x396ebd(0x4a7)+_0x396ebd(0x1e5)]();else _0x1e7e72[_0x396ebd(0x3eb)](/center/i)&&(_0x23c41a-=_0x29844c[_0x396ebd(0x8fd)](_0xb93299[_0x396ebd(0x4a7)+_0x396ebd(0x1e5)](),0x23d*0x4+0x3*-0xc7d+0x1c85));_0x583658+=_0x37178a,_0x23c41a+=_0x4ab310,_0x142c61[_0x396ebd(0x2e0)+'waveImpact'+_0x396ebd(0x757)](_0x583658,_0x23c41a,_0x26e055,_0x53e0cc,_0x3b0b40);}}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData['name'],_0xe90fac(0xca1)+_0xe90fac(0x268)+_0xe90fac(0xcd6)+_0xe90fac(0xbf),_0x2686b0=>{const _0x16ac7e=_0xe90fac,_0x36ee05={'GahfG':function(_0x233c50,_0x1ea918){return _0x233c50>=_0x1ea918;},'LJUGV':function(_0x523c0c,_0x1455d4){return _0x523c0c/_0x1455d4;},'RWkrI':function(_0x39fe90,_0x2abd76){return _0x39fe90+_0x2abd76;},'yniXS':function(_0x5ab9f6,_0x2abb81){return _0x5ab9f6>=_0x2abb81;},'UMeEp':function(_0x1d0f63,_0x2f626e){return _0x1d0f63/_0x2f626e;},'abXXJ':function(_0x3dc040,_0x11a14b){return _0x3dc040+_0x11a14b;},'rLBzf':function(_0xe3643b,_0x5eea3b){return _0xe3643b/_0x5eea3b;},'TBooe':function(_0x363724,_0x4b80be){return _0x363724-_0x4b80be;},'aQLCI':function(_0x3076b7,_0x54be0b){return _0x3076b7/_0x54be0b;}};if(!SceneManager['isSceneBat'+_0x16ac7e(0x3ad)]())return;if(!Imported[_0x16ac7e(0xc49)+_0x16ac7e(0x386)+'t'])return;const _0x249c17=SceneManager[_0x16ac7e(0x11dd)][_0x16ac7e(0x981)];if(!_0x249c17)return;VisuMZ[_0x16ac7e(0x15ae)+_0x16ac7e(0xe3)](_0x2686b0,_0x2686b0);const _0xa4cac6=VisuMZ[_0x16ac7e(0xd1a)+_0x16ac7e(0x12fd)+_0x16ac7e(0x1027)](_0x2686b0[_0x16ac7e(0x1027)]),_0x3793eb=_0x2686b0[_0x16ac7e(0x400)+_0x16ac7e(0x1580)],_0x181394=_0x2686b0['OffsetX']||0x1396+0x1835+-0x1*0x2bcb,_0x455095=_0x2686b0[_0x16ac7e(0xc1e)]||-0xf5*0xe+-0x1728+-0x1*-0x248e,_0x2853bd=_0x2686b0[_0x16ac7e(0xab0)]||-0x368+-0x2623+-0xdd9*-0x3,_0x251745=_0x2686b0['Wave']||-0x1fa6*0x1+-0x913*0x3+0x3adf,_0xf72b3f=_0x2686b0[_0x16ac7e(0x825)]||-0x2301+-0xe17*0x2+0x3f30,_0x176d02=Math[_0x16ac7e(0xeed)](..._0xa4cac6[_0x16ac7e(0x457)](_0x3cf1b7=>_0x3cf1b7[_0x16ac7e(0x81d)]()[_0x16ac7e(0x156)]-_0x3cf1b7[_0x16ac7e(0x81d)]()[_0x16ac7e(0x4a7)+'Width']()/(-0x1*0xe5b+0x18b9+-0x11*0x9c))),_0x41bdfb=Math[_0x16ac7e(0xd3e)](..._0xa4cac6['map'](_0x2a9f58=>_0x2a9f58['battler']()['_baseX']+_0x2a9f58[_0x16ac7e(0x81d)]()[_0x16ac7e(0x4a7)+_0x16ac7e(0x56a)]()/(0x2*0xa48+-0xa*-0x193+-0x244c))),_0x3b9cd0=Math[_0x16ac7e(0xeed)](..._0xa4cac6['map'](_0x28a921=>_0x28a921[_0x16ac7e(0x81d)]()['_baseY']-_0x28a921[_0x16ac7e(0x81d)]()[_0x16ac7e(0x4a7)+_0x16ac7e(0x1e5)]())),_0x48e473=Math[_0x16ac7e(0xd3e)](..._0xa4cac6['map'](_0x197064=>_0x197064['battler']()[_0x16ac7e(0x1098)])),_0x1347c3=_0xa4cac6[_0x16ac7e(0x55f)](_0x4a2c1a=>_0x4a2c1a[_0x16ac7e(0xd83)]())[_0x16ac7e(0x1268)],_0x211f2f=_0xa4cac6['filter'](_0x3354b1=>_0x3354b1[_0x16ac7e(0xb9a)]())['length'];let _0x3b4f89=0x2290+0x5ad+-0x283d,_0x160620=-0x1*0x415+0x1f3+0x27*0xe;if(_0x3793eb[_0x16ac7e(0x3eb)](/front/i))_0x3b4f89=_0x36ee05[_0x16ac7e(0xfff)](_0x1347c3,_0x211f2f)?_0x176d02:_0x41bdfb;else{if(_0x3793eb[_0x16ac7e(0x3eb)](/middle/i))_0x3b4f89=_0x36ee05[_0x16ac7e(0xb2f)](_0x36ee05['RWkrI'](_0x176d02,_0x41bdfb),-0x19*-0x125+-0xc*0x16f+0x7*-0x1a1),melee=-(-0x1709+-0x142b+0xe67*0x3);else _0x3793eb[_0x16ac7e(0x3eb)](/back/i)&&(_0x3b4f89=_0x36ee05[_0x16ac7e(0x6a5)](_0x1347c3,_0x211f2f)?_0x41bdfb:_0x176d02);}if(_0x3793eb[_0x16ac7e(0x3eb)](/head/i))_0x160620=_0x3b9cd0;else{if(_0x3793eb[_0x16ac7e(0x3eb)](/center/i))_0x160620=_0x36ee05[_0x16ac7e(0x4f0)](_0x36ee05[_0x16ac7e(0x11b2)](_0x3b9cd0,_0x48e473),0xcab+-0x3eb*-0x5+-0x2040);else _0x3793eb[_0x16ac7e(0x3eb)](/base/i)&&(_0x160620=_0x48e473);}_0x3b4f89+=_0x36ee05['rLBzf'](_0x36ee05[_0x16ac7e(0x9b8)](Graphics[_0x16ac7e(0x301)],Graphics[_0x16ac7e(0x3dc)]),-0x39a+0x1*0x43a+0x9e*-0x1),_0x160620+=_0x36ee05[_0x16ac7e(0xe62)](_0x36ee05[_0x16ac7e(0x9b8)](Graphics[_0x16ac7e(0xa68)],Graphics[_0x16ac7e(0x7b7)]),-0x1db2+0x1d5*0xb+0x98d),_0x3b4f89+=_0x181394,_0x160620+=_0x455095,_0x249c17[_0x16ac7e(0x2e0)+_0x16ac7e(0xc01)+_0x16ac7e(0x757)](_0x3b4f89,_0x160620,_0x2853bd,_0x251745,_0xf72b3f);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0xca1)+'act_TimeSc'+_0xe90fac(0x540),_0x4a5a15=>{const _0x46ff5f=_0xe90fac,_0x28bc04={'nRiKs':function(_0x4800bb,_0x1cd17c){return _0x4800bb<=_0x1cd17c;},'IuAed':function(_0x453a74,_0x42ba9b){return _0x453a74(_0x42ba9b);},'TiiMU':_0x46ff5f(0x4c5)+'uence\x20Impa'+_0x46ff5f(0x9e0)+_0x46ff5f(0x381)};if(!Imported[_0x46ff5f(0xc49)+_0x46ff5f(0x386)+'t'])return;const _0x308802=SceneManager['_scene']['_spriteset'];if(!_0x308802)return;if(_0x28bc04[_0x46ff5f(0xa9b)](VisuMZ[_0x46ff5f(0x42e)+'ct'][_0x46ff5f(0x6ca)],0x335*0x5+-0x1*0x16ed+0x5*0x161+0.040000000000000036)){_0x28bc04[_0x46ff5f(0xe33)](alert,_0x28bc04[_0x46ff5f(0x43c)]),SceneManager['exit']();return;}VisuMZ['ConvertPar'+_0x46ff5f(0xe3)](_0x4a5a15,_0x4a5a15);const _0x71753a=$gameTemp[_0x46ff5f(0xb71)+_0x46ff5f(0x10f2)+_0x46ff5f(0x1b4)+'r'](),_0x2d6093=Math['max'](-0x1750+0xa2d*0x2+0x17b*0x2+0.01,_0x4a5a15[_0x46ff5f(0xfe6)]);$gameTemp['setBattleI'+_0x46ff5f(0x8d7)+_0x46ff5f(0x2fa)](_0x2d6093,_0x71753a);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData['name'],'ActSeq_Imp'+_0xe90fac(0x618)+'op',_0x28b1a3=>{const _0x186aa=_0xe90fac,_0x4a1ed8={'zbegD':function(_0x388181,_0x377ffa){return _0x388181<=_0x377ffa;},'rMnaS':function(_0x439c6f,_0x4717d2){return _0x439c6f(_0x4717d2);},'XKMSH':_0x186aa(0x4c5)+_0x186aa(0x7f2)+_0x186aa(0x9e0)+_0x186aa(0x381)};if(!Imported['VisuMZ_3_A'+'ctSeqImpac'+'t'])return;const _0x3c67ba=SceneManager[_0x186aa(0x11dd)][_0x186aa(0x981)];if(!_0x3c67ba)return;if(_0x4a1ed8[_0x186aa(0xe9b)](VisuMZ[_0x186aa(0x42e)+'ct'][_0x186aa(0x6ca)],0x1*0xcb2+0xa32+-0x16e3+0.040000000000000036)){_0x4a1ed8[_0x186aa(0xf75)](alert,_0x4a1ed8[_0x186aa(0x4ff)]),SceneManager[_0x186aa(0x10c0)]();return;}VisuMZ[_0x186aa(0x15ae)+_0x186aa(0xe3)](_0x28b1a3,_0x28b1a3);const _0x4672c4=$gameTemp[_0x186aa(0xb71)+_0x186aa(0x10f2)+_0x186aa(0x1b4)+'r'](),_0x229147=_0x28b1a3['ms']||0x18a7+0x1bee+-0x542*0xa;VisuMZ['ActSeqImpa'+'ct']['freezeTime'](_0x229147,_0x4672c4);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],'ActSeq_Imp'+_0xe90fac(0x1522)+_0xe90fac(0x880),_0x137a57=>{const _0x4b6ac2=_0xe90fac,_0x5dd8ac={'LlbVf':_0x4b6ac2(0x44a)};if(!Imported[_0x4b6ac2(0xc49)+_0x4b6ac2(0x386)+'t'])return;const _0xcfd2de=SceneManager[_0x4b6ac2(0x11dd)][_0x4b6ac2(0x981)];if(!_0xcfd2de)return;VisuMZ['ConvertPar'+_0x4b6ac2(0xe3)](_0x137a57,_0x137a57);const _0x3a4f1c=_0x137a57['X']||0x43*-0x76+-0x1c*0x161+-0x22bf*-0x2,_0x2cc45a=_0x137a57['Y']||-0x200b+0xe3*0x21+0x2c8,_0x9aaa9=_0x137a57[_0x4b6ac2(0x853)]||0x647+0x1e25+-0x246c,_0x276a0b=_0x137a57['Radius']||0x979*0x1+0x1494+-0x9d*0x31,_0x7c5933=_0x137a57['Duration']||0x7f7*-0x4+-0x2418+0x16a7*0x3,_0x5ab643=_0x137a57['EasingType']||_0x5dd8ac[_0x4b6ac2(0x627)];_0xcfd2de['setupZoomB'+'lurImpactF'+_0x4b6ac2(0x363)](_0x9aaa9,_0x3a4f1c,_0x2cc45a,_0x276a0b,_0x7c5933,_0x5ab643);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData['name'],_0xe90fac(0xca1)+_0xe90fac(0x1522)+'urTargetCe'+'nter',_0x5f36f0=>{const _0x51e503=_0xe90fac,_0x9dbfab={'SvYry':'Linear','uVEoJ':function(_0x1c5850,_0x2ae09b){return _0x1c5850>=_0x2ae09b;},'CCvyh':function(_0x5a2fe3,_0x52b2d8){return _0x5a2fe3/_0x52b2d8;},'eCBbD':function(_0x2748b3,_0x23a36d){return _0x2748b3+_0x23a36d;},'ZQYZs':function(_0x465468,_0x41d2a6){return _0x465468>=_0x41d2a6;},'SmtMm':function(_0x5f4646,_0x159230){return _0x5f4646-_0x159230;},'IqATH':function(_0x454967,_0x49ae12){return _0x454967/_0x49ae12;}};if(!Imported[_0x51e503(0xc49)+'ctSeqImpac'+'t'])return;const _0x46164b=SceneManager[_0x51e503(0x11dd)][_0x51e503(0x981)];if(!_0x46164b)return;VisuMZ[_0x51e503(0x15ae)+_0x51e503(0xe3)](_0x5f36f0,_0x5f36f0);const _0x370de5=VisuMZ[_0x51e503(0xd1a)+_0x51e503(0x12fd)+_0x51e503(0x1027)](_0x5f36f0['Targets']),_0x5dc6f9=_0x5f36f0[_0x51e503(0x400)+_0x51e503(0x1580)],_0x1f6a8d=_0x5f36f0['OffsetX']||-0x1c*0x5b+0x8*-0x410+-0x1a2*-0x1a,_0x32974c=_0x5f36f0[_0x51e503(0xc1e)]||-0x3*0x245+-0x1049*0x2+0x2761*0x1,_0x4dfbb5=_0x5f36f0[_0x51e503(0x853)]||0x47*0x11+0x1f*0xf7+0x22a*-0x10,_0x41fef5=_0x5f36f0['Radius']||0x1f43+-0x1*-0x21f8+0x413b*-0x1,_0x24efc5=_0x5f36f0[_0x51e503(0x825)]||-0xc30*-0x3+0x16cb+-0x3b5a,_0x47d4de=_0x5f36f0[_0x51e503(0x1521)]||_0x9dbfab[_0x51e503(0x15e3)],_0xda519b=Math['min'](..._0x370de5[_0x51e503(0x457)](_0x5c9179=>_0x5c9179[_0x51e503(0x81d)]()[_0x51e503(0x156)]-_0x5c9179[_0x51e503(0x81d)]()[_0x51e503(0x4a7)+'Width']()/(-0x12f8+0x514+0x3*0x4a2))),_0x4c9e4b=Math['max'](..._0x370de5[_0x51e503(0x457)](_0x51d26f=>_0x51d26f[_0x51e503(0x81d)]()[_0x51e503(0x156)]+_0x51d26f[_0x51e503(0x81d)]()[_0x51e503(0x4a7)+_0x51e503(0x56a)]()/(-0x1*0x16e7+0x154a+0x19f))),_0x3ac8c2=Math[_0x51e503(0xeed)](..._0x370de5['map'](_0xe7f6a0=>_0xe7f6a0[_0x51e503(0x81d)]()['_baseY']-_0xe7f6a0[_0x51e503(0x81d)]()['mainSprite'+'Height']())),_0x1b6d37=Math['max'](..._0x370de5[_0x51e503(0x457)](_0x1c8d19=>_0x1c8d19[_0x51e503(0x81d)]()[_0x51e503(0x1098)])),_0x199b67=_0x370de5[_0x51e503(0x55f)](_0x5c2747=>_0x5c2747['isActor']())[_0x51e503(0x1268)],_0x474ad5=_0x370de5[_0x51e503(0x55f)](_0x1d3bc8=>_0x1d3bc8['isEnemy']())[_0x51e503(0x1268)];let _0x411339=0xca7*-0x1+0x18c+0x1*0xb1b,_0x5d5029=0x92c+0x24dd+-0x2e09;if(_0x5dc6f9['match'](/front/i))_0x411339=_0x9dbfab[_0x51e503(0x1023)](_0x199b67,_0x474ad5)?_0xda519b:_0x4c9e4b;else{if(_0x5dc6f9['match'](/middle/i))_0x411339=_0x9dbfab[_0x51e503(0x110d)](_0x9dbfab[_0x51e503(0x1170)](_0xda519b,_0x4c9e4b),-0x1f5c+0xb93*-0x3+0x4217),melee=-(-0x1*0x1a2d+-0x17*0x161+0x39e5);else _0x5dc6f9[_0x51e503(0x3eb)](/back/i)&&(_0x411339=_0x9dbfab['ZQYZs'](_0x199b67,_0x474ad5)?_0x4c9e4b:_0xda519b);}if(_0x5dc6f9['match'](/head/i))_0x5d5029=_0x3ac8c2;else{if(_0x5dc6f9[_0x51e503(0x3eb)](/center/i))_0x5d5029=_0x9dbfab[_0x51e503(0x110d)](_0x9dbfab[_0x51e503(0x1170)](_0x3ac8c2,_0x1b6d37),0x2021+-0x707*-0x1+-0x2726);else _0x5dc6f9[_0x51e503(0x3eb)](/base/i)&&(_0x5d5029=_0x1b6d37);}_0x411339+=_0x9dbfab[_0x51e503(0x110d)](_0x9dbfab[_0x51e503(0xe26)](Graphics['width'],Graphics[_0x51e503(0x3dc)]),0xc5*-0x10+-0x2*-0x14+0x207*0x6),_0x5d5029+=_0x9dbfab['IqATH'](_0x9dbfab[_0x51e503(0xe26)](Graphics[_0x51e503(0xa68)],Graphics[_0x51e503(0x7b7)]),0xbd1+0x1369*-0x1+0x79a),_0x411339+=_0x1f6a8d,_0x5d5029+=_0x32974c,_0x46164b['setupZoomB'+'lurImpactF'+_0x51e503(0x363)](_0x4dfbb5,_0x411339,_0x5d5029,_0x41fef5,_0x24efc5,_0x47d4de);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x98a)+_0xe90fac(0x8ad)+_0xe90fac(0x911),_0x60e7ad=>{const _0x4e1a0d=_0xe90fac,_0x32a399={'PTHxc':function(_0x27c627,_0x1ca212){return _0x27c627<=_0x1ca212;},'nmnDL':function(_0x393754,_0x3d80a3){return _0x393754(_0x3d80a3);},'OzpKD':_0x4e1a0d(0x4c5)+_0x4e1a0d(0x7f2)+_0x4e1a0d(0x9e0)+_0x4e1a0d(0x381),'ryRbp':_0x4e1a0d(0x64f)+_0x4e1a0d(0x8bc)};if(!Imported[_0x4e1a0d(0xc49)+_0x4e1a0d(0x386)+'t'])return;const _0x228263=SceneManager[_0x4e1a0d(0x11dd)][_0x4e1a0d(0x981)];if(!_0x228263)return;if(_0x32a399[_0x4e1a0d(0xc26)](VisuMZ['ActSeqImpa'+'ct'][_0x4e1a0d(0x6ca)],-0x1301+-0x9b*0x8+0x17da+0.050000000000000044)){_0x32a399['nmnDL'](alert,_0x32a399[_0x4e1a0d(0x74c)]),SceneManager[_0x4e1a0d(0x10c0)]();return;}VisuMZ[_0x4e1a0d(0x15ae)+_0x4e1a0d(0xe3)](_0x60e7ad,_0x60e7ad);const _0x1b313e=VisuMZ[_0x4e1a0d(0xd1a)+_0x4e1a0d(0x12fd)+_0x4e1a0d(0x1027)](_0x60e7ad['Targets']),_0x916f21={'filename':_0x60e7ad['Filename'],'horzCells':_0x60e7ad['horzCells']||-0xe47+-0xf*0x5+0xe93*0x1,'vertCells':_0x60e7ad['vertCells']||-0xb*-0x2e6+-0x1f8d*-0x1+-0x3f6e,'frameDelay':_0x60e7ad[_0x4e1a0d(0xa02)]||-0x3*0x2aa+-0x875+-0x3*-0x57c,'smooth':_0x60e7ad[_0x4e1a0d(0xb1f)]||![],'anchorX':_0x60e7ad[_0x4e1a0d(0x1385)]||-0x84c+-0x141c+0x18*0x12f,'anchorY':_0x60e7ad[_0x4e1a0d(0x147)]||-0x21f5*-0x1+0x52*-0x32+0x5fb*-0x3,'offsetX':_0x60e7ad['offsetX']||0x8f*0x25+0x7*-0x419+-0xab*-0xc,'offsetY':_0x60e7ad[_0x4e1a0d(0xd2a)]||0x11ed+-0x1*-0xaf1+-0x1cde};for(const _0x25a473 of _0x1b313e){if(!_0x25a473)continue;if(!_0x25a473[_0x4e1a0d(0x81d)]())continue;_0x25a473[_0x4e1a0d(0x81d)]()[_0x4e1a0d(0xe57)+_0x4e1a0d(0x10f4)](_0x916f21);}const _0x44d5d1=$gameTemp['getLastPlu'+_0x4e1a0d(0x10f2)+_0x4e1a0d(0x1b4)+'r']();_0x44d5d1&&_0x44d5d1[_0x4e1a0d(0xdaa)+'e'](_0x32a399[_0x4e1a0d(0xfce)]);}),PluginManager['registerCo'+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x98a)+'ect_Animat'+'ionEnd',_0x14a973=>{const _0x34e3c7=_0xe90fac,_0x5c3be0={'hHxKb':function(_0x2b5683,_0x5c06b2){return _0x2b5683<=_0x5c06b2;},'UFeUm':function(_0x4af335,_0x1b999e){return _0x4af335(_0x1b999e);},'eSKXV':_0x34e3c7(0x4c5)+'uence\x20Impa'+_0x34e3c7(0x9e0)+_0x34e3c7(0x381)};if(!Imported[_0x34e3c7(0xc49)+_0x34e3c7(0x386)+'t'])return;const _0x57cd8d=SceneManager[_0x34e3c7(0x11dd)]['_spriteset'];if(!_0x57cd8d)return;if(_0x5c3be0[_0x34e3c7(0x64c)](VisuMZ['ActSeqImpa'+'ct'][_0x34e3c7(0x6ca)],0x11*-0x29+0x17ae+-0x14f4+0.050000000000000044)){_0x5c3be0[_0x34e3c7(0x1f6)](alert,_0x5c3be0[_0x34e3c7(0x931)]),SceneManager[_0x34e3c7(0x10c0)]();return;}VisuMZ[_0x34e3c7(0x15ae)+'ams'](_0x14a973,_0x14a973);const _0x319235=VisuMZ[_0x34e3c7(0xd1a)+_0x34e3c7(0x12fd)+_0x34e3c7(0x1027)](_0x14a973[_0x34e3c7(0x1027)]);for(const _0x2041af of _0x319235){if(!_0x2041af)continue;if(!_0x2041af[_0x34e3c7(0x81d)]())continue;_0x2041af['battler']()['stopInject'+_0x34e3c7(0x2cc)]();}}),PluginManager['registerCo'+'mmand'](pluginData['name'],'ActSeq_Inj'+_0xe90fac(0x8ad)+_0xe90fac(0x15f8)+_0xe90fac(0x4b5),_0x4e9c56=>{const _0x5aa094=_0xe90fac,_0x46b974={'yoSoZ':function(_0x49b4f2,_0x48a686){return _0x49b4f2<=_0x48a686;},'lVmtx':function(_0x44fe71,_0x539c47){return _0x44fe71(_0x539c47);},'dSVoe':_0x5aa094(0x4c5)+'uence\x20Impa'+_0x5aa094(0x9e0)+_0x5aa094(0x381)};if(!Imported[_0x5aa094(0xc49)+_0x5aa094(0x386)+'t'])return;const _0x82acf2=SceneManager[_0x5aa094(0x11dd)][_0x5aa094(0x981)];if(!_0x82acf2)return;if(_0x46b974['yoSoZ'](VisuMZ['ActSeqImpa'+'ct'][_0x5aa094(0x6ca)],-0x1*-0x27a+-0x1fbc+0x1d43+0.050000000000000044)){_0x46b974[_0x5aa094(0xfd7)](alert,_0x46b974[_0x5aa094(0xb2c)]),SceneManager['exit']();return;}VisuMZ[_0x5aa094(0x15ae)+_0x5aa094(0xe3)](_0x4e9c56,_0x4e9c56);const _0x59ea42=VisuMZ[_0x5aa094(0xd1a)+_0x5aa094(0x12fd)+'Targets'](_0x4e9c56['Targets']),_0x32e77b=_0x4e9c56[_0x5aa094(0x3cd)];for(const _0x237725 of _0x59ea42){if(!_0x237725)continue;if(!_0x237725['battler']())continue;_0x237725[_0x5aa094(0x81d)]()['pauseInjec'+_0x5aa094(0x10f4)](_0x32e77b);}}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x98a)+_0xe90fac(0x128e)+_0xe90fac(0xca8),_0x3bd580=>{const _0x3c03c9=_0xe90fac,_0x4fd90f={'dzYAK':_0x3c03c9(0x64f)+_0x3c03c9(0xf4d)};if(!SceneManager[_0x3c03c9(0x11be)+'tle']())return;const _0x4a49a0=$gameTemp['getLastPlu'+_0x3c03c9(0x10f2)+_0x3c03c9(0x1b4)+'r']();if(!_0x4a49a0)return;_0x4a49a0['setWaitMod'+'e'](_0x4fd90f[_0x3c03c9(0xe44)]);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData['name'],_0xe90fac(0x11f8)+_0xe90fac(0xbfb)+_0xe90fac(0x125c),_0x4207f2=>{const _0x2d8598=_0xe90fac,_0x1bc7f9={'rkbLt':function(_0x235020,_0xe43e16){return _0x235020||_0xe43e16;},'uEgbL':_0x2d8598(0x679)+'ct','NwPOg':_0x2d8598(0xb52)};if(!SceneManager[_0x2d8598(0x11be)+_0x2d8598(0x3ad)]())return;VisuMZ[_0x2d8598(0x15ae)+_0x2d8598(0xe3)](_0x4207f2,_0x4207f2);const _0x4ff422=$gameTemp[_0x2d8598(0xb71)+'ginCommand'+_0x2d8598(0x1b4)+'r'](),_0x8a814c=BattleManager[_0x2d8598(0xc37)],_0x4d7d5d=BattleManager['_subject'],_0x893f3a=BattleManager[_0x2d8598(0x3b7)];if(_0x1bc7f9[_0x2d8598(0x3ff)](!_0x4ff422,!_0x8a814c)||!_0x4d7d5d)return;if(!_0x8a814c[_0x2d8598(0xdd)]())return;const _0x4c3618=VisuMZ[_0x2d8598(0xd1a)+_0x2d8598(0x12fd)+'Targets'](_0x4207f2['Targets']);for(const _0x52cde3 of _0x4c3618){if(!_0x52cde3)continue;_0x893f3a['push'](_0x1bc7f9[_0x2d8598(0x1010)],_0x4d7d5d,_0x52cde3);}_0x4ff422['setWaitMod'+'e'](_0x1bc7f9[_0x2d8598(0x283)]);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x11f8)+'hanics_Act'+_0xe90fac(0xd6b)+_0xe90fac(0x9a1),_0x145af4=>{const _0x6dbd4a=_0xe90fac;if(!SceneManager[_0x6dbd4a(0x11be)+_0x6dbd4a(0x3ad)]())return;if(!Imported['VisuMZ_3_A'+'ctiveChain'+_0x6dbd4a(0x943)])return;$gameTemp[_0x6dbd4a(0x112e)+_0x6dbd4a(0xa41)]=!![];}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x11f8)+'hanics_Add'+'BuffDebuff',_0x2cfc0f=>{const _0x4dcc29=_0xe90fac,_0x5adc56={'vdyZD':_0x4dcc29(0xbd7),'LsUeH':_0x4dcc29(0x1a8),'QHtpU':_0x4dcc29(0x15ec),'rSqdC':_0x4dcc29(0xce2),'nSQEC':_0x4dcc29(0xa0b),'CqIoF':_0x4dcc29(0x1455),'AxwAJ':_0x4dcc29(0x215),'AKfVU':_0x4dcc29(0xc8e),'mYfRu':function(_0x7265c0,_0x3f9fba){return _0x7265c0>=_0x3f9fba;},'myXMv':function(_0x5023ed,_0x5d6178){return _0x5023ed<=_0x5d6178;},'QDkNt':function(_0x3fe144,_0xa97b95){return _0x3fe144<=_0xa97b95;}};if(!SceneManager[_0x4dcc29(0x11be)+_0x4dcc29(0x3ad)]())return;VisuMZ[_0x4dcc29(0x15ae)+_0x4dcc29(0xe3)](_0x2cfc0f,_0x2cfc0f);const _0xabe98f=[_0x5adc56[_0x4dcc29(0x500)],_0x5adc56['LsUeH'],_0x5adc56['QHtpU'],_0x5adc56['rSqdC'],_0x5adc56['nSQEC'],_0x5adc56[_0x4dcc29(0x11da)],_0x5adc56[_0x4dcc29(0xe19)],_0x5adc56[_0x4dcc29(0xc7b)]],_0x1f714a=_0x2cfc0f[_0x4dcc29(0x7ea)],_0x590c1b=_0x2cfc0f[_0x4dcc29(0xb9c)],_0x11c34e=_0x2cfc0f[_0x4dcc29(0x4f9)],_0x3f391e=VisuMZ['CreateActi'+_0x4dcc29(0x12fd)+'Targets'](_0x2cfc0f[_0x4dcc29(0x1027)]);for(const _0x1bb3a2 of _0x3f391e){if(!_0x1bb3a2)continue;for(const _0x4a0b69 of _0x1f714a){const _0x28e070=_0xabe98f['indexOf'](_0x4a0b69['toUpperCas'+'e']()[_0x4dcc29(0x808)]());_0x5adc56[_0x4dcc29(0x132c)](_0x28e070,-0x66e+0x9c7+0x359*-0x1)&&_0x5adc56[_0x4dcc29(0xf2f)](_0x28e070,0xe8b+0x1*0xaf7+-0x197b)&&_0x1bb3a2[_0x4dcc29(0x8ae)](_0x28e070,_0x11c34e);}for(const _0x225e6b of _0x590c1b){const _0x5cc0e9=_0xabe98f[_0x4dcc29(0x741)](_0x225e6b['toUpperCas'+'e']()[_0x4dcc29(0x808)]());_0x5adc56[_0x4dcc29(0x132c)](_0x5cc0e9,-0xef*-0x1b+0xd8a+0x2fb*-0xd)&&_0x5adc56[_0x4dcc29(0x414)](_0x5cc0e9,-0x23d3+0x161*-0x3+0x27fd)&&_0x1bb3a2['addDebuff'](_0x5cc0e9,_0x11c34e);}}}),PluginManager[_0xe90fac(0xbd6)+'mmand'](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x11f8)+'hanics_Add'+_0xe90fac(0x11fa),_0x27608f=>{const _0x2b7f7f=_0xe90fac;if(!SceneManager[_0x2b7f7f(0x11be)+'tle']())return;VisuMZ['ConvertPar'+_0x2b7f7f(0xe3)](_0x27608f,_0x27608f);const _0x54c37d=_0x27608f[_0x2b7f7f(0x8da)],_0x1b3f2f=VisuMZ['CreateActi'+_0x2b7f7f(0x12fd)+_0x2b7f7f(0x1027)](_0x27608f[_0x2b7f7f(0x1027)]);for(const _0x4dc5e0 of _0x1b3f2f){if(!_0x4dc5e0)continue;for(const _0x5e842f of _0x54c37d){_0x4dc5e0[_0x2b7f7f(0xf41)](_0x5e842f);}}}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],'ActSeq_Mec'+_0xe90fac(0x38c)+_0xe90fac(0x1540)+_0xe90fac(0x130a),_0x21c776=>{const _0x4d1788=_0xe90fac;if(!SceneManager['isSceneBat'+_0x4d1788(0x3ad)]())return;VisuMZ[_0x4d1788(0x15ae)+'ams'](_0x21c776,_0x21c776);const _0x57416f=BattleManager[_0x4d1788(0xc37)],_0x458306={'arPenRate':_0x21c776[_0x4d1788(0x114b)],'arPenFlat':_0x21c776['ArPenFlat'],'arRedRate':_0x21c776[_0x4d1788(0x1e1)],'arRedFlat':_0x21c776[_0x4d1788(0x495)]};_0x57416f[_0x4d1788(0xa2)+'tration']=_0x458306;}),PluginManager[_0xe90fac(0xbd6)+'mmand'](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x11f8)+_0xe90fac(0xd63)+'lyzeWeakne'+'ss',_0xfa2aa4=>{const _0x3c61eb=_0xe90fac;if(!SceneManager['isSceneBat'+'tle']())return;if(!Imported[_0x3c61eb(0x82f)+_0x3c61eb(0xfe1)+_0x3c61eb(0x29e)])return;VisuMZ['ConvertPar'+'ams'](_0xfa2aa4,_0xfa2aa4);const _0x5e4cd7=VisuMZ[_0x3c61eb(0xd1a)+'onSequence'+_0x3c61eb(0x1027)](_0xfa2aa4[_0x3c61eb(0x1027)]),_0x63f15c=_0xfa2aa4['Reveal']||0x205c+0x2148+-0x41a3;for(const _0x1644c3 of _0x5e4cd7){if(!_0x1644c3)continue;if(!_0x1644c3[_0x3c61eb(0xb9a)]())continue;_0x1644c3['revealNewW'+_0x3c61eb(0x99a)](_0x63f15c);}}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData['name'],_0xe90fac(0x11f8)+_0xe90fac(0x1064)+_0xe90fac(0x11a4),_0x4ffe48=>{const _0x50b87c=_0xe90fac;if(!SceneManager['isSceneBat'+_0x50b87c(0x3ad)]())return;if(!Imported[_0x50b87c(0x859)+_0x50b87c(0x9c1)+_0x50b87c(0x305)])return;if(!BattleManager[_0x50b87c(0x1138)]())return;VisuMZ[_0x50b87c(0x15ae)+_0x50b87c(0xe3)](_0x4ffe48,_0x4ffe48);const _0x5a63c0=VisuMZ[_0x50b87c(0xd1a)+_0x50b87c(0x12fd)+_0x50b87c(0x1027)](_0x4ffe48[_0x50b87c(0x1027)]),_0x5db20b=_0x4ffe48[_0x50b87c(0xba5)],_0x6a8f2=_0x4ffe48[_0x50b87c(0xba5)],_0x122bcf=_0x4ffe48[_0x50b87c(0x3b5)];for(const _0x59f860 of _0x5a63c0){if(!_0x59f860)continue;if(_0x59f860[_0x50b87c(0x124b)+_0x50b87c(0x824)]())_0x59f860[_0x50b87c(0x137e)+'hargeTime'](_0x5db20b);else{if(_0x59f860['isAtbCasti'+_0x50b87c(0x572)]()){_0x59f860[_0x50b87c(0x137e)+'astTime'](_0x6a8f2);if(_0x122bcf)_0x59f860[_0x50b87c(0xe0b)+'pt']();}}}}),PluginManager['registerCo'+'mmand'](pluginData[_0xe90fac(0x14c)],'ActSeq_Mec'+_0xe90fac(0x5d2)+_0xe90fac(0x3ca)+'ange',_0x457c50=>{const _0x1d2e64=_0xe90fac;if(!SceneManager['isSceneBat'+_0x1d2e64(0x3ad)]())return;if(!Imported['VisuMZ_3_B'+_0x1d2e64(0x800)])return;VisuMZ[_0x1d2e64(0x15ae)+_0x1d2e64(0xe3)](_0x457c50,_0x457c50);const _0x2ed954=VisuMZ['CreateActi'+'onSequence'+_0x1d2e64(0x1027)](_0x457c50[_0x1d2e64(0x1027)]),_0x5caf44=_0x457c50['BoostPoint'+'s'];for(const _0x4a8ecb of _0x2ed954){if(!_0x4a8ecb)continue;_0x4a8ecb[_0x1d2e64(0x1239)+_0x1d2e64(0x8b1)+'s'](_0x5caf44);}}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x11f8)+_0xe90fac(0x5d2)+_0xe90fac(0x3f9)+'oreData',_0x3b8764=>{const _0x40fbdf=_0xe90fac;if(!SceneManager[_0x40fbdf(0x11be)+_0x40fbdf(0x3ad)]())return;if(!Imported[_0x40fbdf(0xa56)+'oostAction'])return;if(!BattleManager[_0x40fbdf(0x14c1)])return;VisuMZ['ConvertPar'+_0x40fbdf(0xe3)](_0x3b8764,_0x3b8764);const _0x2a624e=_0x3b8764[_0x40fbdf(0x180)];$gameVariables[_0x40fbdf(0x16b)](_0x2a624e,BattleManager[_0x40fbdf(0x14c1)][_0x40fbdf(0xdeb)+_0x40fbdf(0x1520)]());}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData['name'],'ActSeq_Mec'+_0xe90fac(0x6a1)+_0xe90fac(0xfe0)+_0xe90fac(0x7fe),_0x5e01d9=>{const _0x49077d=_0xe90fac;if(!SceneManager[_0x49077d(0x11be)+'tle']())return;if(!Imported['VisuMZ_4_B'+'reakShield'+'s'])return;VisuMZ[_0x49077d(0x15ae)+_0x49077d(0xe3)](_0x5e01d9,_0x5e01d9);const _0x200c49=VisuMZ[_0x49077d(0xd1a)+_0x49077d(0x12fd)+_0x49077d(0x1027)](_0x5e01d9[_0x49077d(0x1027)]),_0x416aa8=_0x5e01d9['BreakShiel'+'ds'];for(const _0x23d147 of _0x200c49){if(!_0x23d147)continue;if(_0x23d147[_0x49077d(0x1119)+_0x49077d(0x399)]())continue;if(!_0x23d147[_0x49077d(0x1d2)+_0x49077d(0xcda)+'eld']())continue;_0x23d147[_0x49077d(0x292)+_0x49077d(0x7c4)](_0x416aa8);}}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData['name'],'ActSeq_Mec'+_0xe90fac(0x6a1)+'akShieldRe'+'set',_0x402b80=>{const _0x2baa67=_0xe90fac;if(!SceneManager['isSceneBat'+'tle']())return;if(!Imported['VisuMZ_4_B'+_0x2baa67(0x80b)+'s'])return;VisuMZ[_0x2baa67(0x15ae)+_0x2baa67(0xe3)](_0x402b80,_0x402b80);const _0x589280=VisuMZ['CreateActi'+'onSequence'+'Targets'](_0x402b80[_0x2baa67(0x1027)]);for(const _0xb769eb of _0x589280){if(!_0xb769eb)continue;if(_0xb769eb[_0x2baa67(0x1119)+_0x2baa67(0x399)]())continue;if(!_0xb769eb[_0x2baa67(0x1d2)+_0x2baa67(0xcda)+_0x2baa67(0x1068)]())continue;_0xb769eb['resetBreak'+'Shield']();}}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],'ActSeq_Mec'+_0xe90fac(0xc3b)+_0xe90fac(0xc15),_0x4d58e0=>{const _0x4660cf=_0xe90fac;if(!SceneManager['isSceneBat'+_0x4660cf(0x3ad)]())return;if(!Imported['VisuMZ_2_B'+_0x4660cf(0x9c1)+_0x4660cf(0x6c8)])return;if(!BattleManager[_0x4660cf(0xc62)]())return;VisuMZ[_0x4660cf(0x15ae)+_0x4660cf(0xe3)](_0x4d58e0,_0x4d58e0);const _0x506e1c=VisuMZ[_0x4660cf(0xd1a)+'onSequence'+_0x4660cf(0x1027)](_0x4d58e0[_0x4660cf(0x1027)]),_0xb41d81=_0x4d58e0[_0x4660cf(0x1186)+'s'];for(const _0x1e5cb6 of _0x506e1c){if(!_0x1e5cb6)continue;_0x1e5cb6['gainBraveP'+_0x4660cf(0x250)](_0xb41d81);}}),PluginManager[_0xe90fac(0xbd6)+'mmand'](pluginData['name'],'ActSeq_Mec'+_0xe90fac(0xb40)+'lapse',_0x45d590=>{const _0x48d583=_0xe90fac,_0x5613a0={'JytyR':function(_0x4be066,_0x2d873f){return _0x4be066||_0x2d873f;},'anHiG':_0x48d583(0x122)+'ct'};if(!SceneManager[_0x48d583(0x11be)+_0x48d583(0x3ad)]())return;VisuMZ[_0x48d583(0x15ae)+'ams'](_0x45d590,_0x45d590);const _0xfcee85=$gameTemp[_0x48d583(0xb71)+_0x48d583(0x10f2)+_0x48d583(0x1b4)+'r'](),_0x490f13=BattleManager['_action'],_0x13e565=BattleManager[_0x48d583(0x14c1)];if(_0x5613a0[_0x48d583(0x94d)](!_0xfcee85,!_0x490f13)||!_0x13e565)return;if(!_0x490f13[_0x48d583(0xdd)]())return;const _0x3bac02=VisuMZ[_0x48d583(0xd1a)+_0x48d583(0x12fd)+'Targets'](_0x45d590[_0x48d583(0x1027)]);for(const _0x2c4856 of _0x3bac02){if(!_0x2c4856)continue;_0x45d590[_0x48d583(0xde4)]&&(_0x2c4856[_0x48d583(0x3a5)+_0x48d583(0xb19)](),_0x2c4856[_0x48d583(0xf41)](_0x2c4856[_0x48d583(0xfb8)+'Id']())),_0x2c4856['isDeathSta'+_0x48d583(0x240)]()&&_0x2c4856[_0x48d583(0x4a2)+_0x48d583(0x65d)]();}_0xfcee85[_0x48d583(0xdaa)+'e'](_0x5613a0['anHiG']);}),PluginManager['registerCo'+'mmand'](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x11f8)+_0xe90fac(0x826)+_0xe90fac(0x7f9),_0x5079a0=>{const _0x1b034a=_0xe90fac;if(!SceneManager['isSceneBat'+'tle']())return;if(!Imported[_0x1b034a(0x859)+_0x1b034a(0x9c1)+'mCTB'])return;if(!BattleManager[_0x1b034a(0x6c1)]())return;VisuMZ[_0x1b034a(0x15ae)+_0x1b034a(0xe3)](_0x5079a0,_0x5079a0);const _0x25cf71=VisuMZ[_0x1b034a(0xd1a)+'onSequence'+_0x1b034a(0x1027)](_0x5079a0[_0x1b034a(0x1027)]),_0x41bdf1=_0x5079a0[_0x1b034a(0x362)+'rBy'];for(const _0x5c3422 of _0x25cf71){if(!_0x5c3422)continue;_0x5c3422[_0x1b034a(0x1589)+_0x1b034a(0xdd0)](_0x41bdf1);}}),PluginManager[_0xe90fac(0xbd6)+'mmand'](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x11f8)+_0xe90fac(0x826)+'Speed',_0xb2b854=>{const _0x360c7b=_0xe90fac,_0x2601da={'gcbeU':function(_0x267be7,_0xa29103){return _0x267be7===_0xa29103;},'ktyWT':_0x360c7b(0xf88),'dcVsg':_0x360c7b(0x8c8)};if(!SceneManager['isSceneBat'+_0x360c7b(0x3ad)]())return;if(!Imported[_0x360c7b(0x859)+_0x360c7b(0x9c1)+_0x360c7b(0x1544)])return;if(!BattleManager[_0x360c7b(0x6c1)]())return;VisuMZ[_0x360c7b(0x15ae)+'ams'](_0xb2b854,_0xb2b854);const _0x3c790d=VisuMZ[_0x360c7b(0xd1a)+_0x360c7b(0x12fd)+'Targets'](_0xb2b854[_0x360c7b(0x1027)]),_0x5045ed=_0xb2b854[_0x360c7b(0xba5)],_0x2069ed=_0xb2b854[_0x360c7b(0xba5)];for(const _0x5ddb4e of _0x3c790d){if(!_0x5ddb4e)continue;if(_0x2601da[_0x360c7b(0x606)](_0x5ddb4e[_0x360c7b(0x14dd)],_0x2601da[_0x360c7b(0xfa3)]))_0x5ddb4e[_0x360c7b(0x13e9)+_0x360c7b(0xcef)](_0x5045ed);else _0x2601da[_0x360c7b(0x606)](_0x5ddb4e[_0x360c7b(0x14dd)],_0x2601da[_0x360c7b(0x9fb)])&&_0x5ddb4e['changeCtbC'+_0x360c7b(0x153e)](_0x2069ed);}}),PluginManager['registerCo'+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x11f8)+_0xe90fac(0x428)+'tomDmgForm'+'ula',_0x4c0478=>{const _0xc8a0dc=_0xe90fac;if(!SceneManager[_0xc8a0dc(0x11be)+_0xc8a0dc(0x3ad)]())return;VisuMZ[_0xc8a0dc(0x15ae)+_0xc8a0dc(0xe3)](_0x4c0478,_0x4c0478);const _0x2e4fe4=BattleManager['_action'];if(!_0x2e4fe4)return;let _0x68cdda=_0x4c0478[_0xc8a0dc(0x1590)];_0x2e4fe4[_0xc8a0dc(0x83a)+_0xc8a0dc(0xa00)+'la'](_0x68cdda);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x11f8)+_0xe90fac(0x792)+_0xe90fac(0x811),_0x122859=>{const _0x1e567a=_0xe90fac;if(!SceneManager[_0x1e567a(0x11be)+_0x1e567a(0x3ad)]())return;VisuMZ[_0x1e567a(0x15ae)+_0x1e567a(0xe3)](_0x122859,_0x122859);const _0x321eb3=VisuMZ[_0x1e567a(0xd1a)+_0x1e567a(0x12fd)+_0x1e567a(0x1027)](_0x122859[_0x1e567a(0x1027)]);for(const _0xe2a3d5 of _0x321eb3){if(!_0xe2a3d5)continue;if(_0xe2a3d5[_0x1e567a(0xaf7)+'pDamage']())_0xe2a3d5[_0x1e567a(0x6ce)+_0x1e567a(0xeeb)]();}}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x11f8)+_0xe90fac(0xe8f)+'thBreak',_0x39a28f=>{const _0x52ef46=_0xe90fac,_0x29e631={'ZXlXY':function(_0x52a314,_0x3b197d){return _0x52a314!==_0x3b197d;},'wXyxC':_0x52ef46(0x977)};if(!SceneManager['isSceneBat'+_0x52ef46(0x3ad)]())return;VisuMZ['ConvertPar'+'ams'](_0x39a28f,_0x39a28f);const _0x4a0163=$gameTemp['getLastPlu'+_0x52ef46(0x10f2)+_0x52ef46(0x1b4)+'r'](),_0x1241a7=BattleManager[_0x52ef46(0x14c1)],_0x38ce18=_0x39a28f[_0x52ef46(0xde1)+'l'];if(!_0x4a0163)return;if(!_0x1241a7)return;_0x1241a7&&_0x1241a7[_0x52ef46(0x17d)]()&&_0x29e631['ZXlXY'](_0x38ce18[_0x52ef46(0x1318)+'e']()['trim'](),_0x29e631[_0x52ef46(0x11ea)])&&_0x4a0163[_0x52ef46(0x1022)]([_0x38ce18]);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],'ActSeq_Mec'+_0xe90fac(0x11d8)+_0xe90fac(0x1099)+_0xe90fac(0x175),_0xacd23=>{const _0x30c8da=_0xe90fac,_0x18b5d3={'HynVO':_0x30c8da(0x849)+'ionEffect','EEWCL':_0x30c8da(0xb52)};if(!SceneManager[_0x30c8da(0x11be)+'tle']())return;VisuMZ[_0x30c8da(0x15ae)+_0x30c8da(0xe3)](_0xacd23,_0xacd23);const _0x3737d5=$gameTemp['getLastPlu'+_0x30c8da(0x10f2)+_0x30c8da(0x1b4)+'r'](),_0x5d6531=BattleManager[_0x30c8da(0x3b7)];if(!_0x3737d5)return;const _0x127572=VisuMZ['CreateActi'+_0x30c8da(0x12fd)+'Targets'](_0xacd23[_0x30c8da(0xd72)]),_0x28486b=VisuMZ[_0x30c8da(0xd1a)+_0x30c8da(0x12fd)+'Targets'](_0xacd23[_0x30c8da(0x1027)]);for(const _0x3d452a of _0x127572){for(const _0x53ece2 of _0x28486b){if(!_0x53ece2)continue;const _0x7d4a4f=$dataSkills[_0x3d452a['attackSkil'+_0x30c8da(0x1065)]()];_0x5d6531[_0x30c8da(0x15f1)](_0x18b5d3[_0x30c8da(0x119d)],_0x3d452a,_0x53ece2,_0x7d4a4f);}}_0x3737d5[_0x30c8da(0xdaa)+'e'](_0x18b5d3['EEWCL']);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x11f8)+'hanics_Emu'+'lateGuardE'+'ffect',_0x5577b2=>{const _0x402673=_0xe90fac,_0x464118={'bkChC':_0x402673(0x849)+_0x402673(0x125c),'LDYNF':_0x402673(0xb52)};if(!SceneManager[_0x402673(0x11be)+'tle']())return;VisuMZ[_0x402673(0x15ae)+_0x402673(0xe3)](_0x5577b2,_0x5577b2);const _0x18e187=$gameTemp['getLastPlu'+_0x402673(0x10f2)+_0x402673(0x1b4)+'r'](),_0x449fe4=BattleManager[_0x402673(0x3b7)];if(!_0x18e187)return;const _0x30b8f4=VisuMZ['CreateActi'+_0x402673(0x12fd)+_0x402673(0x1027)](_0x5577b2['Users']),_0x3a376a=VisuMZ['CreateActi'+_0x402673(0x12fd)+_0x402673(0x1027)](_0x5577b2[_0x402673(0x1027)]);for(const _0x3b6bc1 of _0x30b8f4){for(const _0x442f23 of _0x3a376a){if(!_0x442f23)continue;const _0x267eaf=$dataSkills[_0x3b6bc1[_0x402673(0x1443)+'Id']()];_0x449fe4[_0x402673(0x15f1)](_0x464118[_0x402673(0x133a)],_0x3b6bc1,_0x442f23,_0x267eaf);}}_0x18e187[_0x402673(0xdaa)+'e'](_0x464118['LDYNF']);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],'ActSeq_Mec'+'hanics_Emu'+_0xe90fac(0x367)+_0xe90fac(0x9bc),_0x45e5a7=>{const _0x3a668d=_0xe90fac,_0x1861e9={'WeSzN':function(_0x5552db,_0x293e28){return _0x5552db(_0x293e28);},'cwTvX':_0x3a668d(0x849)+_0x3a668d(0x125c),'LtjEP':'battlelog'};if(!SceneManager['isSceneBat'+_0x3a668d(0x3ad)]())return;VisuMZ['ConvertPar'+'ams'](_0x45e5a7,_0x45e5a7);const _0x1a9f30=$gameTemp[_0x3a668d(0xb71)+_0x3a668d(0x10f2)+_0x3a668d(0x1b4)+'r'](),_0x5a08a2=BattleManager[_0x3a668d(0x3b7)],_0x5a6f2d=_0x1861e9[_0x3a668d(0x9ed)](Number,_0x45e5a7[_0x3a668d(0x1213)]||0xba9*0x3+0xd54+-0x304e),_0x277676=$dataItems[_0x5a6f2d];if(!_0x1a9f30)return;if(!_0x277676)return;const _0x1ef55b=VisuMZ[_0x3a668d(0xd1a)+_0x3a668d(0x12fd)+_0x3a668d(0x1027)](_0x45e5a7[_0x3a668d(0xd72)]),_0x46d88e=VisuMZ['CreateActi'+_0x3a668d(0x12fd)+_0x3a668d(0x1027)](_0x45e5a7[_0x3a668d(0x1027)]);for(const _0x972d0b of _0x1ef55b){for(const _0x2b8ac5 of _0x46d88e){if(!_0x2b8ac5)continue;_0x5a08a2[_0x3a668d(0x15f1)](_0x1861e9[_0x3a668d(0x13be)],_0x972d0b,_0x2b8ac5,_0x277676);}}_0x1a9f30[_0x3a668d(0xdaa)+'e'](_0x1861e9[_0x3a668d(0x10d7)]);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x11f8)+'hanics_Emu'+_0xe90fac(0x1277)+_0xe90fac(0x1210),_0x77c3c2=>{const _0xec0888=_0xe90fac,_0x127e14={'WdqZJ':function(_0x40e3ba,_0x56058d){return _0x40e3ba(_0x56058d);},'DxSHq':function(_0x547131,_0x4fecc1){return _0x547131<=_0x4fecc1;}};if(!SceneManager[_0xec0888(0x11be)+_0xec0888(0x3ad)]())return;VisuMZ[_0xec0888(0x15ae)+_0xec0888(0xe3)](_0x77c3c2,_0x77c3c2);let _0xa7010f=_0x127e14['WdqZJ'](Number,_0x77c3c2[_0xec0888(0x1121)]||-0x15b1+-0x289+0x183a);if(_0x127e14[_0xec0888(0x2d5)](_0xa7010f,-0x1752+0x13d1+0x381)){const _0x32b90f=BattleManager['_action'];if(_0x32b90f&&_0x32b90f['isSkill']())_0xa7010f=_0x32b90f[_0xec0888(0xdd)]()['id'];else return;}const _0x520f2e=$dataSkills[_0xa7010f];if(!_0x520f2e)return;const _0xd23687=VisuMZ[_0xec0888(0xd1a)+_0xec0888(0x12fd)+_0xec0888(0x1027)](_0x77c3c2[_0xec0888(0xd72)]);for(const _0x36945d of _0xd23687){_0x36945d[_0xec0888(0x133e)+'st'](_0x520f2e);}}),PluginManager['registerCo'+'mmand'](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x11f8)+_0xe90fac(0x11d8)+'lateSkillE'+_0xe90fac(0x421),_0x1c3a9c=>{const _0x1d060e=_0xe90fac,_0x1b8ec8={'KAzxh':function(_0x491313,_0x5d4566){return _0x491313(_0x5d4566);},'CGBBs':_0x1d060e(0x849)+_0x1d060e(0x125c),'tHKQD':_0x1d060e(0xb52)};if(!SceneManager[_0x1d060e(0x11be)+_0x1d060e(0x3ad)]())return;VisuMZ[_0x1d060e(0x15ae)+_0x1d060e(0xe3)](_0x1c3a9c,_0x1c3a9c);const _0x51953b=$gameTemp[_0x1d060e(0xb71)+'ginCommand'+_0x1d060e(0x1b4)+'r'](),_0x509012=BattleManager[_0x1d060e(0x3b7)],_0x41895f=_0x1b8ec8[_0x1d060e(0x8f)](Number,_0x1c3a9c[_0x1d060e(0x1121)]||-0xab3*0x3+-0x600+0x130d*0x2),_0x47496e=$dataSkills[_0x41895f];if(!_0x51953b)return;if(!_0x47496e)return;const _0x3d0b9e=VisuMZ['CreateActi'+'onSequence'+'Targets'](_0x1c3a9c[_0x1d060e(0xd72)]),_0x5ef6b7=VisuMZ[_0x1d060e(0xd1a)+_0x1d060e(0x12fd)+'Targets'](_0x1c3a9c['Targets']);for(const _0x197e94 of _0x3d0b9e){for(const _0x228cf3 of _0x5ef6b7){if(!_0x228cf3)continue;_0x509012['push'](_0x1b8ec8[_0x1d060e(0x345)],_0x197e94,_0x228cf3,_0x47496e);}}_0x51953b['setWaitMod'+'e'](_0x1b8ec8[_0x1d060e(0xa4d)]);}),PluginManager['registerCo'+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],'ActSeq_Mec'+_0xe90fac(0x3c9)+_0xe90fac(0xb9),_0xdd308e=>{const _0x4e9ec2=_0xe90fac;if(!SceneManager[_0x4e9ec2(0x11be)+_0x4e9ec2(0x3ad)]())return;VisuMZ[_0x4e9ec2(0x15ae)+_0x4e9ec2(0xe3)](_0xdd308e,_0xdd308e);const _0xb5b94c=VisuMZ[_0x4e9ec2(0xd1a)+_0x4e9ec2(0x12fd)+'Targets'](_0xdd308e[_0x4e9ec2(0x1027)]);for(const _0x4c24fe of _0xb5b94c){if(!_0x4c24fe)continue;if(!_0x4c24fe[_0x4e9ec2(0xb9a)]())continue;_0x4c24fe[_0x4e9ec2(0xa34)]();}}),PluginManager[_0xe90fac(0xbd6)+'mmand'](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x11f8)+_0xe90fac(0x7d5)+_0xe90fac(0x841),_0x1b2361=>{const _0x416aee=_0xe90fac;if(!SceneManager[_0x416aee(0x11be)+'tle']())return;if(!Imported[_0x416aee(0x859)+'attleSyste'+_0x416aee(0xae7)])return;if(!BattleManager['isETB']())return;VisuMZ['ConvertPar'+_0x416aee(0xe3)](_0x1b2361,_0x1b2361);const _0x1fa516=_0x1b2361[_0x416aee(0xccd)+'t'];BattleManager[_0x416aee(0x14c1)]&&BattleManager[_0x416aee(0x14c1)][_0x416aee(0x2dd)+'t']()[_0x416aee(0x205)+'tActionsET'+'B'](_0x1fa516);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x11f8)+_0xe90fac(0x58b)+_0xe90fac(0x841),_0x5ebc41=>{const _0x20a689=_0xe90fac;if(!SceneManager[_0x20a689(0x11be)+_0x20a689(0x3ad)]())return;if(!Imported[_0x20a689(0x859)+_0x20a689(0x9c1)+'mFTB'])return;if(!BattleManager[_0x20a689(0x555)]())return;VisuMZ[_0x20a689(0x15ae)+_0x20a689(0xe3)](_0x5ebc41,_0x5ebc41);const _0x5ba9a3=_0x5ebc41[_0x20a689(0xccd)+'t'];BattleManager[_0x20a689(0x14c1)]&&BattleManager[_0x20a689(0x14c1)][_0x20a689(0x2dd)+'t']()[_0x20a689(0x205)+_0x20a689(0x95c)+'B'](_0x5ba9a3);}),PluginManager['registerCo'+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x11f8)+_0xe90fac(0x686)+'pTp',_0x284c58=>{const _0x34fbc3=_0xe90fac,_0x3c975c={'kVLeq':function(_0x3fd3f6,_0x5563ed){return _0x3fd3f6+_0x5563ed;},'PWlFD':function(_0x342cb8,_0x4c7965){return _0x342cb8*_0x4c7965;},'Bdyzh':function(_0x3408e2,_0x1af066){return _0x3408e2+_0x1af066;},'lNXvL':function(_0x2007e8,_0x46a58d){return _0x2007e8*_0x46a58d;},'KyXTP':function(_0x192fc3,_0x40b47e){return _0x192fc3+_0x40b47e;},'vvKbb':function(_0x4682b9,_0xd3fb77){return _0x4682b9*_0xd3fb77;},'GgaBe':function(_0x3878a2,_0x5c5519){return _0x3878a2!==_0x5c5519;}};if(!SceneManager[_0x34fbc3(0x11be)+_0x34fbc3(0x3ad)]())return;VisuMZ[_0x34fbc3(0x15ae)+_0x34fbc3(0xe3)](_0x284c58,_0x284c58);const _0x43d12e=VisuMZ['CreateActi'+_0x34fbc3(0x12fd)+_0x34fbc3(0x1027)](_0x284c58[_0x34fbc3(0x1027)]),_0x13add5=_0x284c58['HP_Rate'],_0x4ba3b6=_0x284c58[_0x34fbc3(0x92)],_0x18a4c7=_0x284c58['MP_Rate'],_0x3ab498=_0x284c58['MP_Flat'],_0x26db35=_0x284c58[_0x34fbc3(0x12f4)],_0x3f7c21=_0x284c58[_0x34fbc3(0x590)],_0x42e263=_0x284c58[_0x34fbc3(0xe31)];for(const _0x1709cf of _0x43d12e){if(!_0x1709cf)continue;const _0x1fce29=_0x1709cf[_0x34fbc3(0xb30)](),_0x40333a=Math['round'](_0x3c975c['kVLeq'](_0x3c975c[_0x34fbc3(0x368)](_0x13add5,_0x1709cf[_0x34fbc3(0x60e)]),_0x4ba3b6)),_0x2e6bdb=Math['round'](_0x3c975c[_0x34fbc3(0x1177)](_0x3c975c[_0x34fbc3(0x32b)](_0x18a4c7,_0x1709cf[_0x34fbc3(0x139a)]),_0x3ab498)),_0x5aecdf=Math[_0x34fbc3(0x10a1)](_0x3c975c[_0x34fbc3(0x4ad)](_0x3c975c[_0x34fbc3(0x1453)](_0x26db35,_0x1709cf[_0x34fbc3(0x9b4)]()),_0x3f7c21));if(_0x3c975c[_0x34fbc3(0x14ce)](_0x40333a,0x55d*-0x2+-0xa*0x2ad+-0x95f*-0x4))_0x1709cf['gainHp'](_0x40333a);if(_0x3c975c[_0x34fbc3(0x14ce)](_0x2e6bdb,-0x2*-0x857+0xb1d+-0x5*0x58f))_0x1709cf[_0x34fbc3(0x1015)](_0x2e6bdb);if(_0x3c975c[_0x34fbc3(0x14ce)](_0x5aecdf,-0x7b1+-0x3c0*-0x7+0x128f*-0x1))_0x1709cf['gainTp'](_0x5aecdf);if(_0x42e263)_0x1709cf[_0x34fbc3(0x6ce)+'ePopup']();_0x1fce29&&_0x1709cf[_0x34fbc3(0x17d)]()&&_0x1709cf[_0x34fbc3(0x4a2)+_0x34fbc3(0x65d)]();}}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],'ActSeq_Mec'+'hanics_Imm'+'ortal',_0x19924d=>{const _0x3607cd=_0xe90fac;if(!SceneManager[_0x3607cd(0x11be)+_0x3607cd(0x3ad)]())return;VisuMZ[_0x3607cd(0x15ae)+'ams'](_0x19924d,_0x19924d);const _0x30b3b0=VisuMZ[_0x3607cd(0xd1a)+_0x3607cd(0x12fd)+'Targets'](_0x19924d[_0x3607cd(0x1027)]);for(const _0x47b4c8 of _0x30b3b0){if(!_0x47b4c8)continue;_0x47b4c8[_0x3607cd(0xd9)+'l'](_0x19924d[_0x3607cd(0x3dd)]);}}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],'ActSeq_Mec'+_0xe90fac(0x6d4)+'tipliers',_0x28a063=>{const _0x21fae5=_0xe90fac;if(!SceneManager[_0x21fae5(0x11be)+_0x21fae5(0x3ad)]())return;VisuMZ[_0x21fae5(0x15ae)+_0x21fae5(0xe3)](_0x28a063,_0x28a063);const _0x5b6a9d=BattleManager['_action'],_0x4ae1fe={'criticalHitRate':_0x28a063['CriticalHi'+_0x21fae5(0x622)],'criticalHitFlat':_0x28a063[_0x21fae5(0x106b)+'tFlat'],'criticalDmgRate':_0x28a063[_0x21fae5(0x1375)+_0x21fae5(0x10e0)],'criticalDmgFlat':_0x28a063[_0x21fae5(0x1375)+_0x21fae5(0x8e1)],'damageRate':_0x28a063[_0x21fae5(0xb3e)],'damageFlat':_0x28a063[_0x21fae5(0x2c8)],'hitRate':_0x28a063[_0x21fae5(0xcfa)],'hitFlat':_0x28a063[_0x21fae5(0x863)]};_0x5b6a9d[_0x21fae5(0x4a0)+'rs']=_0x4ae1fe;}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x11f8)+_0xe90fac(0x521)+_0xe90fac(0x10db),_0x3bbbfb=>{const _0x268beb=_0xe90fac;if(!SceneManager['isSceneBat'+'tle']())return;VisuMZ[_0x268beb(0x15ae)+_0x268beb(0xe3)](_0x3bbbfb,_0x3bbbfb);const _0x57b094=_0x3bbbfb['CommonEven'+_0x268beb(0xf8f)];SceneManager[_0x268beb(0x11dd)][_0x268beb(0xb46)+_0x268beb(0x1016)+_0x268beb(0x55a)](_0x57b094);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],'ActSeq_Mec'+_0xe90fac(0xa3d)+_0xe90fac(0x7f9),_0x593924=>{const _0x56ac5c=_0xe90fac;if(!SceneManager['isSceneBat'+'tle']())return;if(!Imported[_0x56ac5c(0x859)+_0x56ac5c(0x9c1)+_0x56ac5c(0x160d)])return;if(!BattleManager[_0x56ac5c(0xa5e)]())return;VisuMZ[_0x56ac5c(0x15ae)+_0x56ac5c(0xe3)](_0x593924,_0x593924);const _0x2e1107=VisuMZ[_0x56ac5c(0xd1a)+_0x56ac5c(0x12fd)+_0x56ac5c(0x1027)](_0x593924[_0x56ac5c(0x1027)]);for(const _0x18a5a3 of _0x2e1107){if(!_0x18a5a3)continue;let _0x3c5888=_0x593924[_0x56ac5c(0x5ca)+'n'],_0xd88b00=_0x593924[_0x56ac5c(0xadd)],_0x373d1b=_0x593924[_0x56ac5c(0x13d5)];BattleManager[_0x56ac5c(0xabd)+_0x56ac5c(0x15ac)]['includes'](_0x18a5a3)?_0x3c5888+=_0x373d1b:_0xd88b00+=_0x373d1b,BattleManager['turnOrderC'+_0x56ac5c(0xf23)](_0x18a5a3,-_0x3c5888,![]),BattleManager[_0x56ac5c(0xa1b)+_0x56ac5c(0xf23)](_0x18a5a3,-_0xd88b00,!![]);}}),PluginManager['registerCo'+'mmand'](pluginData[_0xe90fac(0x14c)],'ActSeq_Mec'+_0xe90fac(0x4f6)+_0xe90fac(0xda8),_0x54c1e0=>{const _0xbd9f72=_0xe90fac,_0x214e29={'MfyCX':'unchanged'};if(!SceneManager[_0xbd9f72(0x11be)+_0xbd9f72(0x3ad)]())return;if(!Imported[_0xbd9f72(0x859)+_0xbd9f72(0x9c1)+_0xbd9f72(0x1399)])return;if(!BattleManager[_0xbd9f72(0x82b)]())return;VisuMZ[_0xbd9f72(0x15ae)+'ams'](_0x54c1e0,_0x54c1e0);const _0x170910=BattleManager[_0xbd9f72(0x14c1)][_0xbd9f72(0x2dd)+'t'](),_0x55bb32=_0x54c1e0['Override'],_0x81b13b=_0x54c1e0[_0xbd9f72(0xc05)+'e']||_0x214e29[_0xbd9f72(0xd15)],_0x335633=_0x54c1e0['alterType']||_0x214e29[_0xbd9f72(0xd15)],_0x1a431=_0x54c1e0[_0xbd9f72(0x3f5)]||0x978+0x1*0x12a9+0x1c21*-0x1,_0x53b8d2=_0x54c1e0['alterPrior'+_0xbd9f72(0x798)]||0x21f*-0x6+0x1*-0x1f1+0xeab;(_0x170910['canAlterAc'+_0xbd9f72(0x649)+'B']()||_0x55bb32)&&(_0x55bb32&&(_0x170910[_0xbd9f72(0xcfd)+_0xbd9f72(0x64e)]=_0x170910[_0xbd9f72(0xcfd)+_0xbd9f72(0x64e)]||{},_0x170910[_0xbd9f72(0xcfd)+_0xbd9f72(0x64e)]['priority']=-0x8b4*0x4+-0xc05+0x2ed5*0x1),_0x170910['alterActio'+_0xbd9f72(0xa23)](_0x81b13b,_0x335633,_0x1a431,_0x53b8d2));}),PluginManager['registerCo'+_0xe90fac(0xc22)](pluginData['name'],_0xe90fac(0x11f8)+_0xe90fac(0x4f6)+_0xe90fac(0xb99),_0x4428be=>{const _0x57dfd0=_0xe90fac,_0x497ee8={'VmsuE':function(_0x5b4397,_0x47d7df){return _0x5b4397<=_0x47d7df;},'kLzmT':function(_0x30e8f7,_0x3053ce){return _0x30e8f7>_0x3053ce;}};if(!SceneManager[_0x57dfd0(0x11be)+_0x57dfd0(0x3ad)]())return;if(!Imported[_0x57dfd0(0x859)+_0x57dfd0(0x9c1)+_0x57dfd0(0x1399)])return;if(!BattleManager[_0x57dfd0(0x82b)]())return;VisuMZ[_0x57dfd0(0x15ae)+_0x57dfd0(0xe3)](_0x4428be,_0x4428be);const _0x414716=BattleManager[_0x57dfd0(0x14c1)][_0x57dfd0(0x2dd)+'t']();let _0x4bd293=Math[_0x57dfd0(0xd3e)](_0x4428be[_0x57dfd0(0x895)+'nt'],0x6b*0x46+-0x2228+0x4e6),_0x30c553=_0x414716[_0x57dfd0(0x581)+_0x57dfd0(0x45d)](),_0x10c1a6=_0x414716[_0x57dfd0(0x7c0)+'ionsPTB']();while(_0x4bd293--){if(_0x497ee8[_0x57dfd0(0x790)](_0x30c553,0x3*-0x473+-0x26b*-0x3+-0x78*-0xd)&&_0x497ee8[_0x57dfd0(0x790)](_0x10c1a6,0xa9a+-0x1*0x21c3+0x1*0x1729))break;else _0x497ee8[_0x57dfd0(0xa37)](_0x30c553,0x225b+-0x74a*-0x1+-0x29a5)?(_0x30c553--,_0x10c1a6++):_0x10c1a6--;}_0x414716['setFullAct'+_0x57dfd0(0x45d)](_0x30c553),_0x414716[_0x57dfd0(0x151b)+_0x57dfd0(0x45d)](_0x10c1a6);}),PluginManager[_0xe90fac(0xbd6)+'mmand'](pluginData['name'],_0xe90fac(0x11f8)+_0xe90fac(0x4f6)+'FullHalfAc'+_0xe90fac(0x1580),_0x3cdeb3=>{const _0xe6b923=_0xe90fac;if(!SceneManager[_0xe6b923(0x11be)+_0xe6b923(0x3ad)]())return;if(!Imported[_0xe6b923(0x859)+_0xe6b923(0x9c1)+_0xe6b923(0x1399)])return;if(!BattleManager['isPTB']())return;VisuMZ[_0xe6b923(0x15ae)+_0xe6b923(0xe3)](_0x3cdeb3,_0x3cdeb3);const _0x465291=BattleManager[_0xe6b923(0x14c1)][_0xe6b923(0x2dd)+'t']();let _0x420842=_0x3cdeb3[_0xe6b923(0x59b)+'s'],_0x434398=_0x3cdeb3[_0xe6b923(0x15fd)+'s'];_0x465291[_0xe6b923(0x410)+_0xe6b923(0x9e6)](_0x420842),_0x465291['gainHalfAc'+_0xe6b923(0x9e6)](_0x434398);}),PluginManager[_0xe90fac(0xbd6)+'mmand'](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x11f8)+_0xe90fac(0xf6e)+_0xe90fac(0xc35)+'uff',_0x392a4f=>{const _0x2a1f2e=_0xe90fac,_0x46ecdb={'EMCsD':_0x2a1f2e(0xbd7),'FkeFd':'MAXMP','ZQDtF':_0x2a1f2e(0x15ec),'nuZmH':_0x2a1f2e(0xce2),'geqao':_0x2a1f2e(0xa0b),'UaAQw':_0x2a1f2e(0x1455),'YvBeA':_0x2a1f2e(0x215),'zyqBN':_0x2a1f2e(0xc8e),'zqHqb':function(_0x3aead1,_0x2a4bef){return _0x3aead1>=_0x2a4bef;},'OemxA':function(_0x2bf772,_0x3ad185){return _0x2bf772<=_0x3ad185;},'lPfOw':function(_0x22cb27,_0x590303){return _0x22cb27>=_0x590303;}};if(!SceneManager[_0x2a1f2e(0x11be)+_0x2a1f2e(0x3ad)]())return;VisuMZ[_0x2a1f2e(0x15ae)+_0x2a1f2e(0xe3)](_0x392a4f,_0x392a4f);const _0x1a6136=[_0x46ecdb[_0x2a1f2e(0x1449)],_0x46ecdb[_0x2a1f2e(0x1234)],_0x46ecdb['ZQDtF'],_0x46ecdb[_0x2a1f2e(0x1532)],_0x46ecdb['geqao'],_0x46ecdb['UaAQw'],_0x46ecdb[_0x2a1f2e(0x130b)],_0x46ecdb[_0x2a1f2e(0x58c)]],_0x1e6bac=_0x392a4f[_0x2a1f2e(0x7ea)],_0xd47642=_0x392a4f[_0x2a1f2e(0xb9c)],_0x540466=VisuMZ[_0x2a1f2e(0xd1a)+'onSequence'+'Targets'](_0x392a4f[_0x2a1f2e(0x1027)]);for(const _0xe633f6 of _0x540466){if(!_0xe633f6)continue;for(const _0x32c4f5 of _0x1e6bac){const _0x59950b=_0x1a6136[_0x2a1f2e(0x741)](_0x32c4f5[_0x2a1f2e(0x1318)+'e']()[_0x2a1f2e(0x808)]());_0x46ecdb['zqHqb'](_0x59950b,0x2*0x11ae+-0x1e07+-0x555)&&_0x46ecdb['OemxA'](_0x59950b,-0x15b7+0x20*0x10d+-0xbe2)&&_0xe633f6[_0x2a1f2e(0xd3c)+_0x2a1f2e(0x15e1)](_0x59950b)&&_0xe633f6[_0x2a1f2e(0x1526)](_0x59950b);}for(const _0x5c9523 of _0xd47642){const _0x3638a6=_0x1a6136[_0x2a1f2e(0x741)](_0x5c9523['toUpperCas'+'e']()[_0x2a1f2e(0x808)]());_0x46ecdb[_0x2a1f2e(0x10fe)](_0x3638a6,0x1e03+-0x24aa+0x6a7)&&_0x46ecdb['OemxA'](_0x3638a6,0x153d+-0x20f6*-0x1+-0x362c)&&_0xe633f6[_0x2a1f2e(0xb56)+'fected'](_0x3638a6)&&_0xe633f6['removeBuff'](_0x3638a6);}}}),PluginManager['registerCo'+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x11f8)+_0xe90fac(0xf6e)+'oveState',_0x2dbcab=>{const _0x5dbbe4=_0xe90fac;if(!SceneManager[_0x5dbbe4(0x11be)+'tle']())return;VisuMZ[_0x5dbbe4(0x15ae)+_0x5dbbe4(0xe3)](_0x2dbcab,_0x2dbcab);const _0x28061c=_0x2dbcab[_0x5dbbe4(0x8da)],_0x5afd2b=VisuMZ[_0x5dbbe4(0xd1a)+_0x5dbbe4(0x12fd)+_0x5dbbe4(0x1027)](_0x2dbcab['Targets']);for(const _0x32f8f0 of _0x5afd2b){if(!_0x32f8f0)continue;for(const _0x392958 of _0x28061c){_0x32f8f0[_0x5dbbe4(0x1001)+'e'](_0x392958);}}}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x11f8)+_0xe90fac(0x1584)+_0xe90fac(0x15df)+_0xe90fac(0x160f),_0x13a5c6=>{const _0x2c77d4=_0xe90fac,_0x17b5bb={'eAziN':function(_0x4fa44a,_0x3f0751){return _0x4fa44a(_0x3f0751);},'HqlOr':function(_0x43e602,_0x15cf20){return _0x43e602(_0x15cf20);}};if(!SceneManager[_0x2c77d4(0x11be)+_0x2c77d4(0x3ad)]())return;if(!Imported[_0x2c77d4(0x120b)+'killsState'+'sCore'])return;VisuMZ[_0x2c77d4(0x15ae)+_0x2c77d4(0xe3)](_0x13a5c6,_0x13a5c6);const _0x5c7e6b=VisuMZ[_0x2c77d4(0xd1a)+'onSequence'+_0x2c77d4(0x1027)](_0x13a5c6[_0x2c77d4(0x1027)]),_0x15cff9=_0x17b5bb[_0x2c77d4(0x8b)](Number,_0x13a5c6[_0x2c77d4(0x2d6)]),_0x3a094f=_0x17b5bb['HqlOr'](Number,_0x13a5c6[_0x2c77d4(0x4f9)]),_0x305c52=_0x13a5c6['AutoAddSta'+'te'];for(const _0xcaef2c of _0x5c7e6b){if(!_0xcaef2c)continue;_0x305c52&&!_0xcaef2c['isStateAff'+_0x2c77d4(0xe1a)](_0x15cff9)?(_0xcaef2c[_0x2c77d4(0xf41)](_0x15cff9),_0xcaef2c['setStateTu'+_0x2c77d4(0x13f4)](_0x15cff9,_0x3a094f)):_0xcaef2c['addStateTu'+_0x2c77d4(0x13f4)](_0x15cff9,_0x3a094f);}}),PluginManager['registerCo'+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x11f8)+_0xe90fac(0x1584)+_0xe90fac(0x15df)+_0xe90fac(0x14f8),_0x3001cb=>{const _0x20fa69=_0xe90fac,_0x15796d={'XZBcx':function(_0x1e39d,_0x26a331){return _0x1e39d(_0x26a331);},'kOaDC':function(_0x95e0b1,_0x18a142){return _0x95e0b1(_0x18a142);}};if(!SceneManager['isSceneBat'+_0x20fa69(0x3ad)]())return;if(!Imported[_0x20fa69(0x120b)+_0x20fa69(0xa7c)+_0x20fa69(0x284)])return;VisuMZ[_0x20fa69(0x15ae)+_0x20fa69(0xe3)](_0x3001cb,_0x3001cb);const _0x57eb0b=VisuMZ[_0x20fa69(0xd1a)+'onSequence'+_0x20fa69(0x1027)](_0x3001cb['Targets']),_0xb86e87=_0x15796d['XZBcx'](Number,_0x3001cb[_0x20fa69(0x2d6)]),_0x1406ef=Math[_0x20fa69(0xd3e)](_0x15796d[_0x20fa69(0x31a)](Number,_0x3001cb[_0x20fa69(0x4f9)]),-0x3*-0x664+-0x1*-0x1e09+-0x3135),_0x43d84e=_0x3001cb['AutoAddSta'+'te'];for(const _0x324950 of _0x57eb0b){if(!_0x324950)continue;_0x43d84e&&!_0x324950['isStateAff'+_0x20fa69(0xe1a)](_0xb86e87)&&_0x324950[_0x20fa69(0xf41)](_0xb86e87),_0x324950[_0x20fa69(0x14be)+'rns'](_0xb86e87,_0x1406ef);}}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],'ActSeq_Mec'+_0xe90fac(0xaa7)+'Exploit',_0x332c3f=>{const _0x122964=_0xe90fac,_0x298cf5={'vnpSN':function(_0x36f936,_0x40347c){return _0x36f936===_0x40347c;}};if(!SceneManager[_0x122964(0x11be)+'tle']())return;if(!Imported[_0x122964(0x859)+'attleSyste'+_0x122964(0x1048)])return;if(!BattleManager[_0x122964(0x134f)]())return;VisuMZ[_0x122964(0x15ae)+'ams'](_0x332c3f,_0x332c3f);const _0x2694c6=_0x332c3f[_0x122964(0x383)],_0x39fb49=VisuMZ[_0x122964(0xd1a)+_0x122964(0x12fd)+_0x122964(0x1027)](_0x332c3f[_0x122964(0x1027)]),_0x5af384=_0x332c3f['ForceExplo'+'ited'],_0x54f0b9=_0x332c3f[_0x122964(0xb01)],_0x33d147=_0x332c3f[_0x122964(0x6bb)+_0x122964(0x111b)],_0x5c3996=BattleManager[_0x122964(0xc37)];if(_0x2694c6)for(const _0x5bd7d6 of _0x39fb49){if(!_0x5bd7d6)continue;if(_0x298cf5[_0x122964(0x10a7)](_0x5bd7d6,user))continue;if(_0x5af384)_0x5bd7d6[_0x122964(0xee5)+_0x122964(0x13ac)](![]);_0x5bd7d6[_0x122964(0x289)+'xploited'](BattleManager['_subject'],_0x5c3996);}if(_0x54f0b9&&BattleManager[_0x122964(0x14c1)]){if(_0x33d147)BattleManager[_0x122964(0x14c1)][_0x122964(0xee5)+_0x122964(0x13ac)](![]);const _0xab53cb=_0x39fb49[0x1047+-0x25aa+-0x1*-0x1563];BattleManager[_0x122964(0x13aa)+_0x122964(0xb01)](_0xab53cb,_0x5c3996);}}),PluginManager[_0xe90fac(0xbd6)+'mmand'](pluginData[_0xe90fac(0x14c)],'ActSeq_Mec'+_0xe90fac(0xaa7)+'ExtraActio'+'n',_0x4e4da3=>{const _0x554f19=_0xe90fac;if(!SceneManager[_0x554f19(0x11be)+_0x554f19(0x3ad)]())return;if(!Imported[_0x554f19(0x859)+_0x554f19(0x9c1)+'mSTB'])return;if(!BattleManager[_0x554f19(0x134f)]())return;VisuMZ[_0x554f19(0x15ae)+'ams'](_0x4e4da3,_0x4e4da3);const _0x645abc=_0x4e4da3[_0x554f19(0x91a)];BattleManager['_subject']&&BattleManager[_0x554f19(0x14c1)][_0x554f19(0x1ae)+_0x554f19(0xf6d)](_0x645abc);}),PluginManager['registerCo'+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],'ActSeq_Mec'+_0xe90fac(0xaa7)+_0xe90fac(0x47f)+_0xe90fac(0xa45),_0x5e21d8=>{const _0x4a6978=_0xe90fac,_0x5a1115={'zMxaq':function(_0x5740da,_0xaca18f){return _0x5740da<=_0xaca18f;}};if(!SceneManager[_0x4a6978(0x11be)+_0x4a6978(0x3ad)]())return;if(!Imported[_0x4a6978(0x859)+_0x4a6978(0x9c1)+_0x4a6978(0x1048)])return;if(!BattleManager['isSTB']())return;VisuMZ[_0x4a6978(0x15ae)+_0x4a6978(0xe3)](_0x5e21d8,_0x5e21d8);let _0x2b1548=_0x5e21d8[_0x4a6978(0x91a)];if(BattleManager[_0x4a6978(0x14c1)]){BattleManager['_subject'][_0x4a6978(0x146a)]=BattleManager[_0x4a6978(0x14c1)]['_actions']||[];while(_0x2b1548--){if(_0x5a1115[_0x4a6978(0x27c)](BattleManager[_0x4a6978(0x14c1)][_0x4a6978(0x146a)]['length'],0x1d6c+0x3bd+-0x2129))break;BattleManager[_0x4a6978(0x14c1)][_0x4a6978(0x146a)]['shift']();}}}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],'ActSeq_Mec'+_0xe90fac(0xa2b)+_0xe90fac(0x68c),_0x3f05d3=>{const _0x43ab86=_0xe90fac;if(!SceneManager['isSceneBat'+_0x43ab86(0x3ad)]())return;if(!Imported[_0x43ab86(0x625)+_0x43ab86(0xf2)+_0x43ab86(0xe30)])return;VisuMZ[_0x43ab86(0x15ae)+'ams'](_0x3f05d3,_0x3f05d3);const _0x5f49ac=VisuMZ[_0x43ab86(0xd1a)+_0x43ab86(0x12fd)+_0x43ab86(0x1027)](_0x3f05d3[_0x43ab86(0x1027)]),_0x49148f=_0x3f05d3['WeaponType'+'ID'];for(const _0x5b08bf of _0x5f49ac){if(!_0x5b08bf)continue;if(!_0x5b08bf[_0x43ab86(0xd83)]())continue;_0x5b08bf[_0x43ab86(0x134e)+_0x43ab86(0xd46)](_0x49148f);}}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x11f8)+_0xe90fac(0x1f8)+'tPopup',_0x5d1661=>{const _0x14acfb=_0xe90fac;if(!SceneManager[_0x14acfb(0x11be)+'tle']())return;VisuMZ[_0x14acfb(0x15ae)+_0x14acfb(0xe3)](_0x5d1661,_0x5d1661);const _0x21f687=VisuMZ[_0x14acfb(0xd1a)+_0x14acfb(0x12fd)+_0x14acfb(0x1027)](_0x5d1661[_0x14acfb(0x1027)]),_0x88fec0=_0x5d1661[_0x14acfb(0x755)],_0x237d25={'textColor':ColorManager[_0x14acfb(0x15c0)](_0x5d1661[_0x14acfb(0x6df)]),'flashColor':_0x5d1661[_0x14acfb(0xa0)],'flashDuration':_0x5d1661[_0x14acfb(0x3ac)+_0x14acfb(0x130a)]};for(const _0x322f6f of _0x21f687){if(!_0x322f6f)continue;_0x322f6f[_0x14acfb(0x866)+_0x14acfb(0x1f9)](_0x88fec0,_0x237d25);}}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData['name'],_0xe90fac(0x11f8)+'hanics_Var'+'iablePopup',_0x2aeffc=>{const _0x28936f=_0xe90fac,_0x25984a={'uQLUK':function(_0x311587,_0x50c791){return _0x311587(_0x50c791);}};if(!SceneManager[_0x28936f(0x11be)+_0x28936f(0x3ad)]())return;VisuMZ['ConvertPar'+_0x28936f(0xe3)](_0x2aeffc,_0x2aeffc);const _0x179e94=VisuMZ[_0x28936f(0xd1a)+_0x28936f(0x12fd)+_0x28936f(0x1027)](_0x2aeffc[_0x28936f(0x1027)]);let _0x2d5b54=$gameVariables[_0x28936f(0x101c)](_0x2aeffc[_0x28936f(0xebe)]);Imported[_0x28936f(0x155e)+_0x28936f(0x100d)]&&_0x2aeffc[_0x28936f(0x10d3)+_0x28936f(0x312)]&&(_0x2d5b54=VisuMZ[_0x28936f(0x1a1)+'s'](_0x2d5b54));const _0x487100=_0x25984a['uQLUK'](String,_0x2d5b54),_0x21e88e={'textColor':ColorManager[_0x28936f(0x15c0)](_0x2aeffc[_0x28936f(0x6df)]),'flashColor':_0x2aeffc[_0x28936f(0xa0)],'flashDuration':_0x2aeffc[_0x28936f(0x3ac)+_0x28936f(0x130a)]};for(const _0x117865 of _0x179e94){if(!_0x117865)continue;_0x117865['setupTextP'+_0x28936f(0x1f9)](_0x487100,_0x21e88e);}}),PluginManager['registerCo'+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x11f8)+_0xe90fac(0x775)+'tForEffect',_0x5ed487=>{const _0x3c5890=_0xe90fac,_0x26fd91={'qAiJV':_0x3c5890(0x122)+'ct'};if(!SceneManager['isSceneBat'+_0x3c5890(0x3ad)]())return;const _0x3750f6=$gameTemp['getLastPlu'+_0x3c5890(0x10f2)+'Interprete'+'r']();if(!_0x3750f6)return;_0x3750f6['setWaitMod'+'e'](_0x26fd91[_0x3c5890(0x1077)]);}),PluginManager['registerCo'+'mmand'](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x1545)+_0xe90fac(0x13b9)+_0xe90fac(0x1365),_0x2e7abc=>{const _0x5ddfcf=_0xe90fac;if(!SceneManager['isSceneBat'+_0x5ddfcf(0x3ad)]())return;VisuMZ[_0x5ddfcf(0x15ae)+_0x5ddfcf(0xe3)](_0x2e7abc,_0x2e7abc);const _0x585318=VisuMZ[_0x5ddfcf(0xd1a)+'onSequence'+_0x5ddfcf(0x1027)](_0x2e7abc[_0x5ddfcf(0x1027)]);for(const _0x2debef of _0x585318){if(!_0x2debef)continue;_0x2debef[_0x5ddfcf(0x651)+_0x5ddfcf(0x113a)]();}}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x1545)+'ion_Freeze'+'MotionFram'+'e',_0x153814=>{const _0x5a08ba=_0xe90fac,_0x501290={'zCRMe':'attack','lqpkZ':'thrust','fAqwQ':'swing','dloan':_0x5a08ba(0x929)};if(!SceneManager[_0x5a08ba(0x11be)+_0x5a08ba(0x3ad)]())return;VisuMZ['ConvertPar'+_0x5a08ba(0xe3)](_0x153814,_0x153814);const _0x5c07cc=VisuMZ[_0x5a08ba(0xd1a)+_0x5a08ba(0x12fd)+_0x5a08ba(0x1027)](_0x153814[_0x5a08ba(0x1027)]),_0x2e9730=_0x153814[_0x5a08ba(0x772)]['toLowerCas'+'e']()[_0x5a08ba(0x808)]();let _0x4588ee=_0x153814[_0x5a08ba(0x5f7)];const _0xa2eb00=_0x153814[_0x5a08ba(0x966)];![_0x501290[_0x5a08ba(0x1ba)],_0x501290[_0x5a08ba(0x1426)],_0x501290[_0x5a08ba(0x1302)],_0x501290[_0x5a08ba(0x82c)]]['includes'](_0x2e9730)&&(_0x4588ee=![]);for(const _0x9bb3d3 of _0x5c07cc){if(!_0x9bb3d3)continue;_0x9bb3d3['freezeMoti'+'on'](_0x2e9730,_0x4588ee,_0xa2eb00);}}),PluginManager[_0xe90fac(0xbd6)+'mmand'](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x1545)+_0xe90fac(0xbdf)+'Type',_0x5cb0d1=>{const _0x329d0c=_0xe90fac,_0x2604ce={'lfhdS':function(_0x2fc8a9,_0x206f02){return _0x2fc8a9(_0x206f02);},'CiUTf':function(_0x525d8f,_0x3b0640){return _0x525d8f===_0x3b0640;},'IXDzr':_0x329d0c(0x3e3),'NlMXr':_0x329d0c(0x501),'WQvvE':'swing','mXHIh':_0x329d0c(0x1070)};if(!SceneManager[_0x329d0c(0x11be)+_0x329d0c(0x3ad)]())return;VisuMZ[_0x329d0c(0x15ae)+_0x329d0c(0xe3)](_0x5cb0d1,_0x5cb0d1);const _0x19b149=VisuMZ[_0x329d0c(0xd1a)+'onSequence'+_0x329d0c(0x1027)](_0x5cb0d1[_0x329d0c(0x1027)]),_0x20de1d=_0x5cb0d1[_0x329d0c(0x772)]['toLowerCas'+'e']()[_0x329d0c(0x808)](),_0x5e210d=_0x5cb0d1[_0x329d0c(0x5f7)];for(const _0x6096b2 of _0x19b149){if(!_0x6096b2)continue;_0x6096b2[_0x329d0c(0xbb0)+'n']=_0x5e210d;if(_0x20de1d[_0x329d0c(0x3eb)](/ATTACK[ ](\d+)/i))_0x6096b2[_0x329d0c(0xe22)+'ackSlot'](_0x2604ce['lfhdS'](Number,RegExp['$1']));else _0x2604ce[_0x329d0c(0x1d4)](_0x20de1d,_0x2604ce[_0x329d0c(0x473)])?_0x6096b2[_0x329d0c(0xe22)+_0x329d0c(0x9dd)]():_0x6096b2['requestMot'+_0x329d0c(0x130a)](_0x20de1d);if(!_0x5e210d)_0x6096b2[_0x329d0c(0x76f)+_0x329d0c(0x117c)](-0x2569*-0x1+0x1*0x76b+0x4c*-0x97);else{if(_0x5e210d&&[_0x2604ce[_0x329d0c(0xeb2)],_0x2604ce[_0x329d0c(0xecd)],_0x2604ce[_0x329d0c(0x3d5)]][_0x329d0c(0x79c)](_0x20de1d)){}}_0x6096b2[_0x329d0c(0xbb0)+'n']=undefined;}}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x1545)+_0xe90fac(0xa5c)+_0xe90fac(0x873),_0x502373=>{const _0x41ed16=_0xe90fac;if(!SceneManager[_0x41ed16(0x11be)+_0x41ed16(0x3ad)]())return;VisuMZ[_0x41ed16(0x15ae)+_0x41ed16(0xe3)](_0x502373,_0x502373);const _0x109053=BattleManager[_0x41ed16(0xc37)];if(!_0x109053)return;if(!_0x109053[_0x41ed16(0xdd)]())return;const _0xed21e6=VisuMZ[_0x41ed16(0xd1a)+_0x41ed16(0x12fd)+_0x41ed16(0x1027)](_0x502373[_0x41ed16(0x1027)]);for(const _0x350187 of _0xed21e6){if(!_0x350187)continue;_0x350187['performAct'+_0x41ed16(0x130a)](_0x109053);}}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x1545)+'ion_Refres'+_0xe90fac(0x166),_0x52552c=>{const _0x16bdf6=_0xe90fac;if(!SceneManager[_0x16bdf6(0x11be)+_0x16bdf6(0x3ad)]())return;VisuMZ['ConvertPar'+_0x16bdf6(0xe3)](_0x52552c,_0x52552c);const _0x1354f8=VisuMZ[_0x16bdf6(0xd1a)+'onSequence'+_0x16bdf6(0x1027)](_0x52552c[_0x16bdf6(0x1027)]);for(const _0x3973ce of _0x1354f8){if(!_0x3973ce)continue;if(!_0x3973ce['battler']())continue;_0x3973ce[_0x16bdf6(0x81d)]()['refreshMot'+_0x16bdf6(0x130a)]();}}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData['name'],_0xe90fac(0x1545)+_0xe90fac(0x1049)+_0xe90fac(0x1047),_0x82fe26=>{const _0x4777eb=_0xe90fac,_0x10c02a={'VHOVC':function(_0x4b28e9,_0x5d0d10){return _0x4b28e9*_0x5d0d10;}};if(!SceneManager[_0x4777eb(0x11be)+'tle']())return;VisuMZ[_0x4777eb(0x15ae)+_0x4777eb(0xe3)](_0x82fe26,_0x82fe26);const _0x549abf=$gameTemp[_0x4777eb(0xb71)+_0x4777eb(0x10f2)+_0x4777eb(0x1b4)+'r'](),_0x43388c=_0x10c02a['VHOVC'](_0x82fe26[_0x4777eb(0x12fe)+_0x4777eb(0x1571)],Sprite_Battler[_0x4777eb(0x1597)+'ed']);_0x549abf[_0x4777eb(0x600)](_0x43388c);}),PluginManager[_0xe90fac(0xbd6)+'mmand'](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x44d)+'ement_Batt'+_0xe90fac(0xd2),_0x226ea7=>{const _0x55b37d=_0xe90fac,_0x5e0958={'ExeFt':function(_0x46cb95,_0x53fedf){return _0x46cb95||_0x53fedf;},'NUvXa':'battleMove'};if(!SceneManager[_0x55b37d(0x11be)+_0x55b37d(0x3ad)]())return;VisuMZ['ConvertPar'+_0x55b37d(0xe3)](_0x226ea7,_0x226ea7);const _0x22ef42=$gameTemp[_0x55b37d(0xb71)+_0x55b37d(0x10f2)+_0x55b37d(0x1b4)+'r'](),_0x54d836=BattleManager[_0x55b37d(0xc37)];if(_0x5e0958[_0x55b37d(0x14ab)](!_0x22ef42,!_0x54d836))return;if(!_0x54d836[_0x55b37d(0xdd)]())return;const _0x35b9bc=VisuMZ[_0x55b37d(0xd1a)+_0x55b37d(0x12fd)+'Targets'](_0x226ea7[_0x55b37d(0x1027)]);for(const _0x3cc5c0 of _0x35b9bc){if(!_0x3cc5c0)continue;_0x3cc5c0[_0x55b37d(0x763)+_0x55b37d(0x911)](_0x54d836);}if(_0x226ea7[_0x55b37d(0x12b1)+_0x55b37d(0x4a5)])_0x22ef42[_0x55b37d(0xdaa)+'e'](_0x5e0958[_0x55b37d(0xb6)]);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],'ActSeq_Mov'+'ement_Home'+'MoveBy',_0x38041b=>{const _0x271bf8=_0xe90fac,_0xfbe3bc={'uEOcv':_0x271bf8(0x79a)};if(!SceneManager[_0x271bf8(0x11be)+_0x271bf8(0x3ad)]())return;if(!$gameSystem[_0x271bf8(0x53d)]())return;VisuMZ[_0x271bf8(0x15ae)+_0x271bf8(0xe3)](_0x38041b,_0x38041b);const _0x14834e=$gameTemp['getLastPlu'+_0x271bf8(0x10f2)+_0x271bf8(0x1b4)+'r'](),_0x363e59=VisuMZ[_0x271bf8(0xd1a)+'onSequence'+'Targets'](_0x38041b[_0x271bf8(0x1027)]),_0x322e33=_0x38041b[_0x271bf8(0x1040)+_0x271bf8(0x626)],_0x30529d=_0x38041b[_0x271bf8(0x9f4)],_0x25ef33=_0x38041b[_0x271bf8(0x22a)],_0x2c7b22=_0x38041b[_0x271bf8(0x825)],_0x2a4e22=_0x38041b[_0x271bf8(0x1333)+'ion'],_0x28818a=_0x38041b[_0x271bf8(0x1521)],_0x16cc1a=_0x38041b[_0x271bf8(0x772)],_0x28b2c6=_0x38041b[_0x271bf8(0x12b1)+_0x271bf8(0x4a5)];if(!_0x14834e)return;for(const _0x2b32a1 of _0x363e59){if(!_0x2b32a1)continue;let _0x48d557=_0x30529d,_0x849acd=_0x25ef33;if(_0x322e33[_0x271bf8(0x3eb)](/horz/i))_0x48d557*=_0x2b32a1[_0x271bf8(0xd83)]()?-(-0x72b+0x2*-0xfdf+0x26ea):-0xbb*-0xc+0x267e*-0x1+0x1dbb*0x1;if(_0x322e33[_0x271bf8(0x3eb)](/vert/i))_0x849acd*=_0x2b32a1[_0x271bf8(0xd83)]()?-(-0x52f*0x1+0x3b+-0x3*-0x1a7):0x3d1+-0x5*0x16a+0x342;_0x2b32a1[_0x271bf8(0x37b)+_0x271bf8(0x2aa)+_0x271bf8(0xed3)](_0x48d557,_0x849acd,_0x2c7b22,_0x2a4e22,_0x28818a),_0x2b32a1[_0x271bf8(0xa08)+_0x271bf8(0x130a)](_0x16cc1a);}if(_0x28b2c6)_0x14834e[_0x271bf8(0xdaa)+'e'](_0xfbe3bc[_0x271bf8(0x889)]);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],'ActSeq_Mov'+'ement_Home'+_0xe90fac(0xe0f)+'int',_0x46d220=>{const _0x306d81=_0xe90fac,_0x21a238={'ugQPE':_0x306d81(0x79a)};if(!SceneManager[_0x306d81(0x11be)+'tle']())return;if(!$gameSystem[_0x306d81(0x53d)]())return;VisuMZ[_0x306d81(0x15ae)+'ams'](_0x46d220,_0x46d220);const _0x514eb1=$gameTemp[_0x306d81(0xb71)+'ginCommand'+'Interprete'+'r'](),_0x4fa909=VisuMZ['CreateActi'+_0x306d81(0x12fd)+_0x306d81(0x1027)](_0x46d220[_0x306d81(0x1027)]),_0x506d5b=_0x46d220[_0x306d81(0x11ef)+'st'],_0x30d4ee=_0x46d220['OffsetX'],_0xd13f77=_0x46d220[_0x306d81(0xc1e)],_0x5ad841=_0x46d220[_0x306d81(0x825)],_0x1327af=_0x46d220[_0x306d81(0x1333)+_0x306d81(0x130a)],_0x46849f=_0x46d220['EasingType'],_0x51f8c1=_0x46d220[_0x306d81(0x772)],_0x167cba=_0x46d220['WaitForMov'+_0x306d81(0x4a5)];if(!_0x514eb1)return;for(const _0x36c937 of _0x4fa909){if(!_0x36c937)continue;const _0x3f12b6=_0x46d220['Destinatio'+_0x306d81(0x13af)](_0x36c937)||{'x':0x0,'y':0x0};let _0x3c2ad1=_0x3f12b6['x'],_0x2df2b6=_0x3f12b6['y'];if(_0x506d5b[_0x306d81(0x3eb)](/none/i))_0x3c2ad1+=_0x30d4ee,_0x2df2b6+=_0xd13f77;else{if(_0x506d5b[_0x306d81(0x3eb)](/horz/i)&&_0x506d5b[_0x306d81(0x3eb)](/vert/i))_0x3c2ad1+=_0x36c937['isActor']()?-_0x30d4ee:_0x30d4ee,_0x2df2b6+=_0x36c937[_0x306d81(0xd83)]()?-_0xd13f77:_0xd13f77;else{if(_0x506d5b[_0x306d81(0x3eb)](/horz/i))_0x3c2ad1+=_0x36c937['isActor']()?-_0x30d4ee:_0x30d4ee,_0x2df2b6+=_0xd13f77;else _0x506d5b[_0x306d81(0x3eb)](/vert/i)&&(_0x3c2ad1+=_0x30d4ee,_0x2df2b6+=_0x36c937['isActor']()?-_0xd13f77:_0xd13f77);}}_0x36c937[_0x306d81(0x37b)+_0x306d81(0x724)+'nt'](_0x3c2ad1,_0x2df2b6,_0x5ad841,_0x1327af,_0x46849f,-(0x26dd+-0x56c+-0x2170)),_0x36c937['requestMot'+_0x306d81(0x130a)](_0x51f8c1);}if(_0x167cba)_0x514eb1[_0x306d81(0xdaa)+'e'](_0x21a238[_0x306d81(0x1163)]);}),PluginManager['registerCo'+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x44d)+'ement_Home'+_0xe90fac(0xce7)+'t',_0x431f9f=>{const _0x32db95=_0xe90fac,_0x78992c={'riqJw':function(_0x1929cd,_0x51088b){return _0x1929cd/_0x51088b;},'gPSBP':function(_0x18972a,_0x2740c1){return _0x18972a(_0x2740c1);},'VmZzV':_0x32db95(0x79a)};if(!SceneManager[_0x32db95(0x11be)+_0x32db95(0x3ad)]())return;if(!$gameSystem[_0x32db95(0x53d)]())return;VisuMZ['ConvertPar'+'ams'](_0x431f9f,_0x431f9f);const _0x1d89fa=$gameTemp[_0x32db95(0xb71)+'ginCommand'+'Interprete'+'r'](),_0xbe7681=VisuMZ[_0x32db95(0xd1a)+_0x32db95(0x12fd)+_0x32db95(0x1027)](_0x431f9f[_0x32db95(0x1027)]),_0x5073b2=_0x431f9f[_0x32db95(0x1488)+'n'],_0x42bab3=_0x431f9f[_0x32db95(0x11ef)+'st'],_0x35d562=_0x431f9f[_0x32db95(0x11c6)],_0x2a0c00=_0x431f9f[_0x32db95(0xc1e)],_0x119c3a=_0x431f9f['Duration'],_0x5a6033=_0x431f9f[_0x32db95(0x1333)+_0x32db95(0x130a)],_0x506ded=_0x431f9f[_0x32db95(0x1521)],_0x35a11c=_0x431f9f[_0x32db95(0x772)],_0x290cc3=_0x431f9f[_0x32db95(0x12b1)+_0x32db95(0x4a5)];if(!_0x1d89fa)return;for(const _0x8a0f63 of _0xbe7681){if(!_0x8a0f63)continue;let _0x4ad8dc=_0x8a0f63[_0x32db95(0x81d)]()[_0x32db95(0x156)],_0x3b3bef=_0x8a0f63['battler']()[_0x32db95(0x1098)];if(_0x5073b2[_0x32db95(0x3eb)](/home/i))_0x4ad8dc=_0x8a0f63[_0x32db95(0x81d)]()['_homeX'],_0x3b3bef=_0x8a0f63[_0x32db95(0x81d)]()['_homeY'];else{if(_0x5073b2['match'](/center/i))_0x4ad8dc=_0x78992c['riqJw'](Graphics['boxWidth'],0x3*-0x4c3+0x20*-0x4f+0x10d*0x17),_0x3b3bef=_0x78992c[_0x32db95(0x10e4)](Graphics[_0x32db95(0x7b7)],-0x6*0x174+0x1eb0+-0x15f6);else _0x5073b2[_0x32db95(0x3eb)](/point (\d+), (\d+)/i)&&(_0x4ad8dc=_0x78992c[_0x32db95(0xda5)](Number,RegExp['$1']),_0x3b3bef=_0x78992c[_0x32db95(0xda5)](Number,RegExp['$2']));}if(_0x42bab3[_0x32db95(0x3eb)](/none/i))_0x4ad8dc+=_0x35d562,_0x3b3bef+=_0x2a0c00;else{if(_0x42bab3['match'](/horz/i)&&_0x42bab3[_0x32db95(0x3eb)](/vert/i))_0x4ad8dc+=_0x8a0f63[_0x32db95(0xd83)]()?-_0x35d562:_0x35d562,_0x3b3bef+=_0x8a0f63[_0x32db95(0xd83)]()?-_0x2a0c00:_0x2a0c00;else{if(_0x42bab3['match'](/horz/i))_0x4ad8dc+=_0x8a0f63[_0x32db95(0xd83)]()?-_0x35d562:_0x35d562,_0x3b3bef+=_0x2a0c00;else _0x42bab3['match'](/vert/i)&&(_0x4ad8dc+=_0x35d562,_0x3b3bef+=_0x8a0f63['isActor']()?-_0x2a0c00:_0x2a0c00);}}_0x8a0f63[_0x32db95(0x37b)+_0x32db95(0x724)+'nt'](_0x4ad8dc,_0x3b3bef,_0x119c3a,_0x5a6033,_0x506ded,-(-0x45*-0x2f+-0x122f*-0x1+-0x1ed9)),_0x8a0f63[_0x32db95(0xa08)+'ion'](_0x35a11c);}if(_0x290cc3)_0x1d89fa['setWaitMod'+'e'](_0x78992c[_0x32db95(0x1c9)]);}),PluginManager['registerCo'+'mmand'](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x44d)+_0xe90fac(0x9aa)+_0xe90fac(0x15ee)+'et',_0x48ef67=>{const _0x1fcefa=_0xe90fac,_0x4a710a={'krWRI':function(_0x269d5b,_0x59f6d9){return _0x269d5b>=_0x59f6d9;},'mxIhJ':function(_0xa6957a,_0xd03a1b){return _0xa6957a/_0xd03a1b;},'gOoKe':function(_0x1a7e52,_0x1e01b9){return _0x1a7e52+_0x1e01b9;},'WVKwG':function(_0x3b2f20,_0x16c693){return _0x3b2f20>=_0x16c693;},'XdEsF':function(_0xcfda8a,_0x17369a){return _0xcfda8a/_0x17369a;},'HHsrs':_0x1fcefa(0x79a)};if(!SceneManager[_0x1fcefa(0x11be)+_0x1fcefa(0x3ad)]())return;if(!$gameSystem['isSideView']())return;VisuMZ[_0x1fcefa(0x15ae)+_0x1fcefa(0xe3)](_0x48ef67,_0x48ef67);const _0x52e3e1=$gameTemp[_0x1fcefa(0xb71)+'ginCommand'+_0x1fcefa(0x1b4)+'r'](),_0x1cd8eb=VisuMZ[_0x1fcefa(0xd1a)+_0x1fcefa(0x12fd)+_0x1fcefa(0x1027)](_0x48ef67[_0x1fcefa(0x12d2)]),_0x200dbb=VisuMZ['CreateActi'+_0x1fcefa(0x12fd)+_0x1fcefa(0x1027)](_0x48ef67[_0x1fcefa(0x148)]),_0xb4b80c=_0x48ef67[_0x1fcefa(0x400)+'tion'];let _0x44ad71=_0x48ef67[_0x1fcefa(0x109)+_0x1fcefa(0xed3)];const _0x477a10=_0x48ef67[_0x1fcefa(0x11ef)+'st'],_0x50756c=_0x48ef67['OffsetX'],_0x15de82=_0x48ef67[_0x1fcefa(0xc1e)],_0x445e29=_0x48ef67[_0x1fcefa(0x825)],_0x3db410=_0x48ef67['FaceDirect'+'ion'],_0x187117=_0x48ef67[_0x1fcefa(0x1521)],_0x4e284c=_0x48ef67[_0x1fcefa(0x772)],_0xf7eebc=_0x48ef67['WaitForMov'+_0x1fcefa(0x4a5)],_0x203b7e=Math[_0x1fcefa(0xeed)](..._0x200dbb[_0x1fcefa(0x457)](_0x456fbe=>_0x456fbe[_0x1fcefa(0x81d)]()[_0x1fcefa(0x156)]-_0x456fbe['battler']()[_0x1fcefa(0x4a7)+'Width']()/(-0x379*0x1+-0x721+0xa9c))),_0x5bbc94=Math[_0x1fcefa(0xd3e)](..._0x200dbb[_0x1fcefa(0x457)](_0x3af5f1=>_0x3af5f1[_0x1fcefa(0x81d)]()[_0x1fcefa(0x156)]+_0x3af5f1[_0x1fcefa(0x81d)]()[_0x1fcefa(0x4a7)+_0x1fcefa(0x56a)]()/(0xd72+-0x25ad+0x183d))),_0x585ecd=Math[_0x1fcefa(0xeed)](..._0x200dbb[_0x1fcefa(0x457)](_0x4cbd65=>_0x4cbd65[_0x1fcefa(0x81d)]()[_0x1fcefa(0x1098)]-_0x4cbd65[_0x1fcefa(0x81d)]()[_0x1fcefa(0x4a7)+_0x1fcefa(0x1e5)]())),_0x1e32c3=Math[_0x1fcefa(0xd3e)](..._0x200dbb[_0x1fcefa(0x457)](_0x3d8429=>_0x3d8429['battler']()['_baseY'])),_0x394e73=_0x200dbb[_0x1fcefa(0x55f)](_0x1523c2=>_0x1523c2[_0x1fcefa(0xd83)]())[_0x1fcefa(0x1268)],_0x48aba1=_0x200dbb[_0x1fcefa(0x55f)](_0x2bb0be=>_0x2bb0be['isEnemy']())[_0x1fcefa(0x1268)];let _0x80a214=-0x1ae*-0x8+-0xbde+-0x192,_0x202c91=0x2c6*0x1+-0x1a5*0x10+0x178a;if(_0xb4b80c[_0x1fcefa(0x3eb)](/front/i))_0x80a214=_0x4a710a[_0x1fcefa(0x4b7)](_0x394e73,_0x48aba1)?_0x203b7e:_0x5bbc94;else{if(_0xb4b80c[_0x1fcefa(0x3eb)](/middle/i))_0x80a214=_0x4a710a[_0x1fcefa(0x6c4)](_0x4a710a['gOoKe'](_0x203b7e,_0x5bbc94),-0x167c+-0x1cfa+0x8*0x66f),_0x44ad71=-(0x1604+-0x1ee8+0x8e5);else _0xb4b80c[_0x1fcefa(0x3eb)](/back/i)&&(_0x80a214=_0x4a710a[_0x1fcefa(0x25f)](_0x394e73,_0x48aba1)?_0x5bbc94:_0x203b7e);}if(_0xb4b80c['match'](/head/i))_0x202c91=_0x585ecd;else{if(_0xb4b80c['match'](/center/i))_0x202c91=_0x4a710a['XdEsF'](_0x4a710a[_0x1fcefa(0x459)](_0x585ecd,_0x1e32c3),-0x37e+-0xfdc+0xc*0x19d);else _0xb4b80c[_0x1fcefa(0x3eb)](/base/i)&&(_0x202c91=_0x1e32c3);}if(!_0x52e3e1)return;for(const _0xd71fe9 of _0x1cd8eb){if(!_0xd71fe9)continue;let _0x1645ef=_0x80a214,_0x50a3c4=_0x202c91;if(_0x477a10[_0x1fcefa(0x3eb)](/none/i))_0x1645ef+=_0x50756c,_0x50a3c4+=_0x15de82;else{if(_0x477a10['match'](/horz/i)&&_0x477a10[_0x1fcefa(0x3eb)](/vert/i))_0x1645ef+=_0xd71fe9[_0x1fcefa(0xd83)]()?-_0x50756c:_0x50756c,_0x50a3c4+=_0xd71fe9[_0x1fcefa(0xd83)]()?-_0x15de82:_0x15de82;else{if(_0x477a10['match'](/horz/i))_0x1645ef+=_0xd71fe9[_0x1fcefa(0xd83)]()?-_0x50756c:_0x50756c,_0x50a3c4+=_0x15de82;else _0x477a10[_0x1fcefa(0x3eb)](/vert/i)&&(_0x1645ef+=_0x50756c,_0x50a3c4+=_0xd71fe9[_0x1fcefa(0xd83)]()?-_0x15de82:_0x15de82);}}_0xd71fe9[_0x1fcefa(0x37b)+_0x1fcefa(0x724)+'nt'](_0x1645ef,_0x50a3c4,_0x445e29,_0x3db410,_0x187117,_0x44ad71),_0xd71fe9[_0x1fcefa(0xa08)+'ion'](_0x4e284c);}if(_0xf7eebc)_0x52e3e1['setWaitMod'+'e'](_0x4a710a[_0x1fcefa(0x658)]);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],'ActSeq_Mov'+_0xe90fac(0x36f)+_0xe90fac(0xf3e),_0x68801b=>{const _0x48022d=_0xe90fac;if(!SceneManager[_0x48022d(0x11be)+'tle']())return;if(!$gameSystem[_0x48022d(0x53d)]())return;VisuMZ[_0x48022d(0x15ae)+'ams'](_0x68801b,_0x68801b);const _0x42f5dd=VisuMZ[_0x48022d(0xd1a)+'onSequence'+_0x48022d(0x1027)](_0x68801b[_0x48022d(0x1027)]);let _0x140143=_0x68801b[_0x48022d(0xf3e)][_0x48022d(0x3eb)](/back/i);for(const _0x250cf8 of _0x42f5dd){if(!_0x250cf8)continue;if(_0x68801b[_0x48022d(0xf3e)][_0x48022d(0x3eb)](/rand/i))_0x140143=Math[_0x48022d(0x1608)](-0x4*-0x4e9+0x1cbf+-0x3061);_0x250cf8[_0x48022d(0x117e)+'Flip'](!!_0x140143);}}),PluginManager['registerCo'+'mmand'](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x44d)+_0xe90fac(0x36f)+'JsPoint',_0x30fc10=>{const _0x39ee1b=_0xe90fac;if(!SceneManager[_0x39ee1b(0x11be)+_0x39ee1b(0x3ad)]())return;if(!$gameSystem[_0x39ee1b(0x53d)]())return;VisuMZ['ConvertPar'+'ams'](_0x30fc10,_0x30fc10);const _0x372956=VisuMZ[_0x39ee1b(0xd1a)+'onSequence'+_0x39ee1b(0x1027)](_0x30fc10[_0x39ee1b(0x1027)]),_0x2cc5d4=_0x30fc10[_0x39ee1b(0x1037)];for(const _0x216e1e of _0x372956){if(!_0x216e1e)continue;const _0x278f94=_0x30fc10[_0x39ee1b(0x12a)](_0x216e1e)||{'x':0x0,'y':0x0};let _0x45d04e=_0x278f94['x'],_0x241c3c=_0x278f94['y'];_0x216e1e['setBattler'+_0x39ee1b(0xea4)](Math[_0x39ee1b(0x10a1)](_0x45d04e),Math[_0x39ee1b(0x10a1)](_0x241c3c),!!_0x2cc5d4);}}),PluginManager['registerCo'+_0xe90fac(0xc22)](pluginData['name'],_0xe90fac(0x44d)+'ement_Face'+_0xe90fac(0x85d),_0x3cba9b=>{const _0x5e6b43=_0xe90fac,_0x4d11c0={'MyYTG':function(_0x35114b,_0x1e2c78){return _0x35114b/_0x1e2c78;},'fpTus':function(_0x291945,_0x4c6a8c){return _0x291945/_0x4c6a8c;},'VpaME':function(_0x46fb75,_0x14aaf3){return _0x46fb75(_0x14aaf3);}};if(!SceneManager['isSceneBat'+'tle']())return;if(!$gameSystem[_0x5e6b43(0x53d)]())return;VisuMZ['ConvertPar'+_0x5e6b43(0xe3)](_0x3cba9b,_0x3cba9b);const _0x617423=VisuMZ[_0x5e6b43(0xd1a)+_0x5e6b43(0x12fd)+_0x5e6b43(0x1027)](_0x3cba9b[_0x5e6b43(0x1027)]);let _0x715010=_0x3cba9b[_0x5e6b43(0x85d)];const _0x18bd52=_0x3cba9b['FaceAway'];for(const _0x40bab5 of _0x617423){if(!_0x40bab5)continue;let _0x3828d9=_0x40bab5[_0x5e6b43(0x81d)]()[_0x5e6b43(0x156)],_0x10a02d=_0x40bab5['battler']()[_0x5e6b43(0x1098)];if(_0x715010[_0x5e6b43(0x3eb)](/home/i))_0x3828d9=_0x40bab5[_0x5e6b43(0x81d)]()[_0x5e6b43(0xcc4)],_0x10a02d=_0x40bab5[_0x5e6b43(0x81d)]()[_0x5e6b43(0x54e)];else{if(_0x715010[_0x5e6b43(0x3eb)](/center/i))_0x3828d9=_0x4d11c0[_0x5e6b43(0x1f5)](Graphics['boxWidth'],0x12f4*0x1+0x1c93*0x1+0x5*-0x981),_0x10a02d=_0x4d11c0[_0x5e6b43(0x7b5)](Graphics[_0x5e6b43(0x7b7)],-0x1*-0x2359+0x1*0x4ea+-0x2841);else _0x715010['match'](/point (\d+), (\d+)/i)&&(_0x3828d9=_0x4d11c0[_0x5e6b43(0x558)](Number,RegExp['$1']),_0x10a02d=_0x4d11c0[_0x5e6b43(0x558)](Number,RegExp['$2']));}_0x40bab5[_0x5e6b43(0x117e)+_0x5e6b43(0xea4)](Math[_0x5e6b43(0x10a1)](_0x3828d9),Math[_0x5e6b43(0x10a1)](_0x10a02d),!!_0x18bd52);}}),PluginManager['registerCo'+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],'ActSeq_Mov'+_0xe90fac(0x36f)+'Target',_0x22b5cf=>{const _0x5c6d3b=_0xe90fac,_0x5473ba={'kAAre':function(_0xd57506,_0x412e7d){return _0xd57506/_0x412e7d;}};if(!SceneManager['isSceneBat'+_0x5c6d3b(0x3ad)]())return;if(!$gameSystem[_0x5c6d3b(0x53d)]())return;VisuMZ['ConvertPar'+_0x5c6d3b(0xe3)](_0x22b5cf,_0x22b5cf);const _0xcb36be=VisuMZ[_0x5c6d3b(0xd1a)+_0x5c6d3b(0x12fd)+_0x5c6d3b(0x1027)](_0x22b5cf[_0x5c6d3b(0x12d2)]),_0x42b9cc=VisuMZ[_0x5c6d3b(0xd1a)+_0x5c6d3b(0x12fd)+_0x5c6d3b(0x1027)](_0x22b5cf[_0x5c6d3b(0x148)]),_0x6ec040=_0x5473ba[_0x5c6d3b(0x126c)](_0x42b9cc['map'](_0x306057=>_0x306057&&_0x306057[_0x5c6d3b(0x81d)]()?_0x306057[_0x5c6d3b(0x81d)]()[_0x5c6d3b(0x156)]:-0x3d*0x31+0xc11*-0x3+0x8*0x5fc),_0x42b9cc['length']||-0x4*0x3f1+0x15f5+-0xb*0x90),_0x1a60cb=_0x5473ba[_0x5c6d3b(0x126c)](_0x42b9cc['map'](_0x41362f=>_0x41362f&&_0x41362f[_0x5c6d3b(0x81d)]()?_0x41362f[_0x5c6d3b(0x81d)]()['_baseY']:0x29*-0xb3+0x1*0xb7+-0x6fd*-0x4),_0x42b9cc['length']||-0x1b0f+0x233*-0x4+0x23dc),_0xc5e3e4=_0x22b5cf['FaceAway'];for(const _0x17f4eb of _0xcb36be){if(!_0x17f4eb)continue;_0x17f4eb[_0x5c6d3b(0x117e)+'FacePoint'](Math['round'](_0x6ec040),Math[_0x5c6d3b(0x10a1)](_0x1a60cb),!!_0xc5e3e4);}}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],'ActSeq_Mov'+'ement_Floa'+'t',_0x54049a=>{const _0x32be9b=_0xe90fac,_0x212fa5={'OweTd':_0x32be9b(0x8de)+'t'};if(!SceneManager[_0x32be9b(0x11be)+_0x32be9b(0x3ad)]())return;VisuMZ['ConvertPar'+'ams'](_0x54049a,_0x54049a);const _0xff3bac=$gameTemp[_0x32be9b(0xb71)+_0x32be9b(0x10f2)+_0x32be9b(0x1b4)+'r'](),_0x2bd445=VisuMZ['CreateActi'+_0x32be9b(0x12fd)+'Targets'](_0x54049a[_0x32be9b(0x1027)]),_0x2a40ae=_0x54049a[_0x32be9b(0x1e5)],_0x55602d=_0x54049a[_0x32be9b(0x825)],_0x451c20=_0x54049a[_0x32be9b(0x1521)],_0x5de450=_0x54049a[_0x32be9b(0xa91)+'at'];if(!_0xff3bac)return;for(const _0x17b6bf of _0x2bd445){if(!_0x17b6bf)continue;_0x17b6bf[_0x32be9b(0x10b)+'er'](_0x2a40ae,_0x55602d,_0x451c20);}if(_0x5de450)_0xff3bac[_0x32be9b(0xdaa)+'e'](_0x212fa5[_0x32be9b(0x134d)]);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x44d)+_0xe90fac(0x9aa)+'Reset',_0x583dcf=>{const _0x5dcd94=_0xe90fac,_0x22b3ac={'RKSwP':'battleMove'};if(!SceneManager[_0x5dcd94(0x11be)+_0x5dcd94(0x3ad)]())return;VisuMZ[_0x5dcd94(0x15ae)+_0x5dcd94(0xe3)](_0x583dcf,_0x583dcf);const _0x51d095=$gameTemp['getLastPlu'+'ginCommand'+_0x5dcd94(0x1b4)+'r']();if(!_0x51d095)return;const _0x3ed146=VisuMZ[_0x5dcd94(0xd1a)+_0x5dcd94(0x12fd)+_0x5dcd94(0x1027)](_0x583dcf[_0x5dcd94(0x1027)]);for(const _0x4f3b2d of _0x3ed146){if(!_0x4f3b2d)continue;_0x4f3b2d[_0x5dcd94(0x763)+_0x5dcd94(0xea7)+_0x5dcd94(0x446)]();}BattleManager[_0x5dcd94(0x14c1)]&&BattleManager[_0x5dcd94(0x14c1)][_0x5dcd94(0x763)+_0x5dcd94(0x15f)]();if(_0x583dcf[_0x5dcd94(0x12b1)+'ement'])_0x51d095[_0x5dcd94(0xdaa)+'e'](_0x22b3ac[_0x5dcd94(0x11cb)]);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x44d)+'ement_Jump',_0x4a7c17=>{const _0x3b8331=_0xe90fac,_0x1f0699={'hdlzK':_0x3b8331(0x86f)};if(!SceneManager[_0x3b8331(0x11be)+_0x3b8331(0x3ad)]())return;VisuMZ[_0x3b8331(0x15ae)+_0x3b8331(0xe3)](_0x4a7c17,_0x4a7c17);const _0x402743=$gameTemp['getLastPlu'+'ginCommand'+_0x3b8331(0x1b4)+'r'](),_0x1df6a9=VisuMZ[_0x3b8331(0xd1a)+_0x3b8331(0x12fd)+_0x3b8331(0x1027)](_0x4a7c17[_0x3b8331(0x1027)]),_0x3f6933=_0x4a7c17[_0x3b8331(0x1e5)],_0xc3c6ba=_0x4a7c17[_0x3b8331(0x825)],_0x9fd040=_0x4a7c17['WaitForJum'+'p'];if(!_0x402743)return;for(const _0x123e5c of _0x1df6a9){if(!_0x123e5c)continue;_0x123e5c['jumpBattle'+'r'](_0x3f6933,_0xc3c6ba);}if(_0x9fd040)_0x402743['setWaitMod'+'e'](_0x1f0699[_0x3b8331(0x42d)]);}),PluginManager[_0xe90fac(0xbd6)+'mmand'](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x44d)+_0xe90fac(0xbd3)+'By',_0x2a001e=>{const _0x18f58b=_0xe90fac,_0x1d6112={'tQQRG':_0x18f58b(0x79a)};if(!SceneManager[_0x18f58b(0x11be)+'tle']())return;if(!$gameSystem[_0x18f58b(0x53d)]())return;VisuMZ[_0x18f58b(0x15ae)+'ams'](_0x2a001e,_0x2a001e);const _0x4c2a9f=$gameTemp[_0x18f58b(0xb71)+'ginCommand'+_0x18f58b(0x1b4)+'r'](),_0x17caf8=VisuMZ[_0x18f58b(0xd1a)+_0x18f58b(0x12fd)+_0x18f58b(0x1027)](_0x2a001e['Targets']),_0x564e52=_0x2a001e[_0x18f58b(0x1040)+'just'],_0xc21ec2=_0x2a001e[_0x18f58b(0x9f4)],_0x34f169=_0x2a001e[_0x18f58b(0x22a)],_0x110844=_0x2a001e[_0x18f58b(0x825)],_0x170ade=_0x2a001e['FaceDirect'+_0x18f58b(0x130a)],_0xd06835=_0x2a001e[_0x18f58b(0x1521)],_0x451478=_0x2a001e[_0x18f58b(0x772)],_0x3854ca=_0x2a001e[_0x18f58b(0x12b1)+'ement'];if(!_0x4c2a9f)return;for(const _0xcdf27a of _0x17caf8){if(!_0xcdf27a)continue;let _0x1004c4=_0xc21ec2,_0x38012b=_0x34f169;if(_0x564e52[_0x18f58b(0x3eb)](/horz/i))_0x1004c4*=_0xcdf27a[_0x18f58b(0xd83)]()?-(0x1*0x1d4c+0x2045+0x8*-0x7b2):0x6*-0x60d+-0x3b9+0x2808;if(_0x564e52['match'](/vert/i))_0x38012b*=_0xcdf27a[_0x18f58b(0xd83)]()?-(0x301*0x7+-0x8bd+0x55*-0x25):0x1216+-0x4a*-0x2c+0x1*-0x1ecd;_0xcdf27a[_0x18f58b(0x37b)+_0x18f58b(0x93)](_0x1004c4,_0x38012b,_0x110844,_0x170ade,_0xd06835),_0xcdf27a[_0x18f58b(0xa08)+'ion'](_0x451478);}if(_0x3854ca)_0x4c2a9f['setWaitMod'+'e'](_0x1d6112[_0x18f58b(0x1171)]);}),PluginManager['registerCo'+'mmand'](pluginData['name'],_0xe90fac(0x44d)+'ement_Move'+_0xe90fac(0x4a3),_0x3afa41=>{const _0x2a7e7e=_0xe90fac,_0x6e3116={'PGyyP':_0x2a7e7e(0x79a)};if(!SceneManager[_0x2a7e7e(0x11be)+_0x2a7e7e(0x3ad)]())return;if(!$gameSystem['isSideView']())return;VisuMZ[_0x2a7e7e(0x15ae)+_0x2a7e7e(0xe3)](_0x3afa41,_0x3afa41);const _0x290a44=$gameTemp[_0x2a7e7e(0xb71)+_0x2a7e7e(0x10f2)+_0x2a7e7e(0x1b4)+'r'](),_0x2ca7aa=VisuMZ[_0x2a7e7e(0xd1a)+'onSequence'+_0x2a7e7e(0x1027)](_0x3afa41[_0x2a7e7e(0x1027)]),_0x579607=_0x3afa41['OffsetAdju'+'st'],_0x53bd4f=_0x3afa41[_0x2a7e7e(0x11c6)],_0x417c89=_0x3afa41[_0x2a7e7e(0xc1e)],_0x1f766a=_0x3afa41[_0x2a7e7e(0x825)],_0x429be1=_0x3afa41[_0x2a7e7e(0x1333)+_0x2a7e7e(0x130a)],_0x3c46bb=_0x3afa41[_0x2a7e7e(0x1521)],_0x5d35c9=_0x3afa41[_0x2a7e7e(0x772)],_0x49086c=_0x3afa41[_0x2a7e7e(0x12b1)+_0x2a7e7e(0x4a5)];if(!_0x290a44)return;for(const _0x1103a1 of _0x2ca7aa){if(!_0x1103a1)continue;const _0x435fc7=_0x3afa41[_0x2a7e7e(0x1488)+'nJS'](_0x1103a1)||{'x':0x0,'y':0x0};let _0x1cace5=_0x435fc7['x'],_0x3a990e=_0x435fc7['y'];if(_0x579607[_0x2a7e7e(0x3eb)](/none/i))_0x1cace5+=_0x53bd4f,_0x3a990e+=_0x417c89;else{if(_0x579607[_0x2a7e7e(0x3eb)](/horz/i)&&_0x579607[_0x2a7e7e(0x3eb)](/vert/i))_0x1cace5+=_0x1103a1[_0x2a7e7e(0xd83)]()?-_0x53bd4f:_0x53bd4f,_0x3a990e+=_0x1103a1[_0x2a7e7e(0xd83)]()?-_0x417c89:_0x417c89;else{if(_0x579607['match'](/horz/i))_0x1cace5+=_0x1103a1[_0x2a7e7e(0xd83)]()?-_0x53bd4f:_0x53bd4f,_0x3a990e+=_0x417c89;else _0x579607[_0x2a7e7e(0x3eb)](/vert/i)&&(_0x1cace5+=_0x53bd4f,_0x3a990e+=_0x1103a1['isActor']()?-_0x417c89:_0x417c89);}}_0x1103a1[_0x2a7e7e(0x37b)+_0x2a7e7e(0x975)](_0x1cace5,_0x3a990e,_0x1f766a,_0x429be1,_0x3c46bb,-(-0x24c5+-0x2e5*0xd+0x4a67)),_0x1103a1['requestMot'+'ion'](_0x5d35c9);}if(_0x49086c)_0x290a44[_0x2a7e7e(0xdaa)+'e'](_0x6e3116['PGyyP']);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x44d)+_0xe90fac(0xbd3)+_0xe90fac(0xf40),_0xb088f2=>{const _0x2f4094=_0xe90fac,_0x2ea435={'powav':function(_0x27e2e0,_0x5b6d27){return _0x27e2e0/_0x5b6d27;},'ZFEbu':function(_0x2aa893,_0x434b1a){return _0x2aa893(_0x434b1a);},'wKCtX':function(_0x113b1e,_0x3102f2){return _0x113b1e(_0x3102f2);},'njbkq':'battleMove'};if(!SceneManager[_0x2f4094(0x11be)+_0x2f4094(0x3ad)]())return;if(!$gameSystem['isSideView']())return;VisuMZ[_0x2f4094(0x15ae)+_0x2f4094(0xe3)](_0xb088f2,_0xb088f2);const _0xe8bceb=$gameTemp['getLastPlu'+_0x2f4094(0x10f2)+_0x2f4094(0x1b4)+'r'](),_0x4d1ade=VisuMZ[_0x2f4094(0xd1a)+_0x2f4094(0x12fd)+'Targets'](_0xb088f2[_0x2f4094(0x1027)]),_0x361e78=_0xb088f2[_0x2f4094(0x1488)+'n'],_0x3e4023=_0xb088f2[_0x2f4094(0x11ef)+'st'],_0x1c53d1=_0xb088f2[_0x2f4094(0x11c6)],_0x272f8a=_0xb088f2[_0x2f4094(0xc1e)],_0x17382c=_0xb088f2[_0x2f4094(0x825)],_0x93ea2c=_0xb088f2['FaceDirect'+'ion'],_0x33fca2=_0xb088f2['EasingType'],_0x10c0c9=_0xb088f2[_0x2f4094(0x772)],_0x1fac4c=_0xb088f2['WaitForMov'+_0x2f4094(0x4a5)];if(!_0xe8bceb)return;for(const _0x3f46bf of _0x4d1ade){if(!_0x3f46bf)continue;let _0x5afcb6=_0x3f46bf[_0x2f4094(0x81d)]()[_0x2f4094(0x156)],_0x2014d7=_0x3f46bf[_0x2f4094(0x81d)]()[_0x2f4094(0x1098)];if(_0x361e78[_0x2f4094(0x3eb)](/home/i))_0x5afcb6=_0x3f46bf[_0x2f4094(0x81d)]()[_0x2f4094(0xcc4)],_0x2014d7=_0x3f46bf[_0x2f4094(0x81d)]()[_0x2f4094(0x54e)];else{if(_0x361e78['match'](/center/i))_0x5afcb6=_0x2ea435[_0x2f4094(0x1438)](Graphics['boxWidth'],-0x1f52+0xd68+0x11ec),_0x2014d7=_0x2ea435[_0x2f4094(0x1438)](Graphics[_0x2f4094(0x7b7)],-0x1abf+0x1833+0x28e);else _0x361e78['match'](/point (\d+), (\d+)/i)&&(_0x5afcb6=_0x2ea435[_0x2f4094(0xe77)](Number,RegExp['$1']),_0x2014d7=_0x2ea435[_0x2f4094(0x15f5)](Number,RegExp['$2']));}if(_0x3e4023[_0x2f4094(0x3eb)](/none/i))_0x5afcb6+=_0x1c53d1,_0x2014d7+=_0x272f8a;else{if(_0x3e4023[_0x2f4094(0x3eb)](/horz/i)&&_0x3e4023['match'](/vert/i))_0x5afcb6+=_0x3f46bf[_0x2f4094(0xd83)]()?-_0x1c53d1:_0x1c53d1,_0x2014d7+=_0x3f46bf['isActor']()?-_0x272f8a:_0x272f8a;else{if(_0x3e4023[_0x2f4094(0x3eb)](/horz/i))_0x5afcb6+=_0x3f46bf['isActor']()?-_0x1c53d1:_0x1c53d1,_0x2014d7+=_0x272f8a;else _0x3e4023[_0x2f4094(0x3eb)](/vert/i)&&(_0x5afcb6+=_0x1c53d1,_0x2014d7+=_0x3f46bf[_0x2f4094(0xd83)]()?-_0x272f8a:_0x272f8a);}}_0x3f46bf[_0x2f4094(0x37b)+_0x2f4094(0x975)](_0x5afcb6,_0x2014d7,_0x17382c,_0x93ea2c,_0x33fca2,-(0x1df0+-0xa93+-0x15*0xec)),_0x3f46bf[_0x2f4094(0xa08)+_0x2f4094(0x130a)](_0x10c0c9);}if(_0x1fac4c)_0xe8bceb[_0x2f4094(0xdaa)+'e'](_0x2ea435['njbkq']);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x44d)+_0xe90fac(0xbd3)+_0xe90fac(0x139),_0xc9ad16=>{const _0x34c244=_0xe90fac,_0x19da01={'AQzLx':function(_0x382f15,_0x44b367){return _0x382f15>=_0x44b367;},'AZzTR':function(_0x1ab734,_0x5d3947){return _0x1ab734/_0x5d3947;},'ipKSW':function(_0x2daa0e,_0x287119){return _0x2daa0e+_0x287119;},'gwwwa':function(_0x543769,_0x149672){return _0x543769+_0x149672;},'XFvRL':_0x34c244(0x79a)};if(!SceneManager['isSceneBat'+_0x34c244(0x3ad)]())return;if(!$gameSystem['isSideView']())return;VisuMZ[_0x34c244(0x15ae)+_0x34c244(0xe3)](_0xc9ad16,_0xc9ad16);const _0x531035=$gameTemp[_0x34c244(0xb71)+_0x34c244(0x10f2)+'Interprete'+'r'](),_0x500ad1=VisuMZ['CreateActi'+_0x34c244(0x12fd)+'Targets'](_0xc9ad16[_0x34c244(0x12d2)]),_0x220077=VisuMZ[_0x34c244(0xd1a)+_0x34c244(0x12fd)+'Targets'](_0xc9ad16[_0x34c244(0x148)]),_0x3f23ee=_0xc9ad16[_0x34c244(0x400)+'tion'];let _0x3064f5=_0xc9ad16[_0x34c244(0x109)+_0x34c244(0xed3)];const _0x2a7dc3=_0xc9ad16['OffsetAdju'+'st'],_0x493df6=_0xc9ad16[_0x34c244(0x11c6)],_0x5f3c05=_0xc9ad16[_0x34c244(0xc1e)],_0x1084c3=_0xc9ad16[_0x34c244(0x825)],_0x6fe2cb=_0xc9ad16[_0x34c244(0x1333)+_0x34c244(0x130a)],_0x406598=_0xc9ad16[_0x34c244(0x1521)],_0x398ab2=_0xc9ad16['MotionType'],_0x30aca3=_0xc9ad16[_0x34c244(0x12b1)+_0x34c244(0x4a5)],_0x5d046f=Math['min'](..._0x220077[_0x34c244(0x457)](_0x50a844=>_0x50a844[_0x34c244(0x81d)]()[_0x34c244(0x156)]-_0x50a844[_0x34c244(0x81d)]()[_0x34c244(0x4a7)+'Width']()/(-0x2db+0xb1*0x1+0x1*0x22c))),_0x1df248=Math[_0x34c244(0xd3e)](..._0x220077[_0x34c244(0x457)](_0x4b93f9=>_0x4b93f9[_0x34c244(0x81d)]()[_0x34c244(0x156)]+_0x4b93f9[_0x34c244(0x81d)]()[_0x34c244(0x4a7)+_0x34c244(0x56a)]()/(0x599*0x3+0x12c4+0x238d*-0x1))),_0x178104=Math[_0x34c244(0xeed)](..._0x220077[_0x34c244(0x457)](_0x1b5e9b=>_0x1b5e9b[_0x34c244(0x81d)]()[_0x34c244(0x1098)]-_0x1b5e9b[_0x34c244(0x81d)]()[_0x34c244(0x4a7)+_0x34c244(0x1e5)]())),_0x373815=Math[_0x34c244(0xd3e)](..._0x220077['map'](_0xf6a4a9=>_0xf6a4a9[_0x34c244(0x81d)]()[_0x34c244(0x1098)])),_0x3cb527=_0x220077[_0x34c244(0x55f)](_0x2f7672=>_0x2f7672['isActor']())[_0x34c244(0x1268)],_0x61941=_0x220077[_0x34c244(0x55f)](_0x1d616d=>_0x1d616d[_0x34c244(0xb9a)]())['length'];let _0xe20ba1=-0x12d2+0x23e4+-0x1112,_0x209a20=0x1be7*0x1+0x1f1d+-0x3b04;if(_0x3f23ee[_0x34c244(0x3eb)](/front/i))_0xe20ba1=_0x19da01[_0x34c244(0x6fb)](_0x3cb527,_0x61941)?_0x5d046f:_0x1df248;else{if(_0x3f23ee[_0x34c244(0x3eb)](/middle/i))_0xe20ba1=_0x19da01[_0x34c244(0xb68)](_0x19da01[_0x34c244(0x9f9)](_0x5d046f,_0x1df248),0x131*0x8+-0x1*0x2414+0x1a8e),_0x3064f5=-(-0x2ee+-0xbf6*-0x1+-0x907);else _0x3f23ee['match'](/back/i)&&(_0xe20ba1=_0x19da01[_0x34c244(0x6fb)](_0x3cb527,_0x61941)?_0x1df248:_0x5d046f);}if(_0x3f23ee[_0x34c244(0x3eb)](/head/i))_0x209a20=_0x178104;else{if(_0x3f23ee[_0x34c244(0x3eb)](/center/i))_0x209a20=_0x19da01[_0x34c244(0xb68)](_0x19da01[_0x34c244(0x1080)](_0x178104,_0x373815),-0x6ed+0x2b*-0x5f+-0x24a*-0xa);else _0x3f23ee[_0x34c244(0x3eb)](/base/i)&&(_0x209a20=_0x373815);}if(!_0x531035)return;for(const _0x38f6d6 of _0x500ad1){if(!_0x38f6d6)continue;let _0x36e673=_0xe20ba1,_0x2f578e=_0x209a20;if(_0x2a7dc3[_0x34c244(0x3eb)](/none/i))_0x36e673+=_0x493df6,_0x2f578e+=_0x5f3c05;else{if(_0x2a7dc3[_0x34c244(0x3eb)](/horz/i)&&_0x2a7dc3[_0x34c244(0x3eb)](/vert/i))_0x36e673+=_0x38f6d6[_0x34c244(0xd83)]()?-_0x493df6:_0x493df6,_0x2f578e+=_0x38f6d6[_0x34c244(0xd83)]()?-_0x5f3c05:_0x5f3c05;else{if(_0x2a7dc3['match'](/horz/i))_0x36e673+=_0x38f6d6['isActor']()?-_0x493df6:_0x493df6,_0x2f578e+=_0x5f3c05;else _0x2a7dc3[_0x34c244(0x3eb)](/vert/i)&&(_0x36e673+=_0x493df6,_0x2f578e+=_0x38f6d6['isActor']()?-_0x5f3c05:_0x5f3c05);}}_0x38f6d6[_0x34c244(0x37b)+_0x34c244(0x975)](_0x36e673,_0x2f578e,_0x1084c3,_0x6fe2cb,_0x406598,_0x3064f5),_0x38f6d6[_0x34c244(0xa08)+_0x34c244(0x130a)](_0x398ab2);}if(_0x30aca3)_0x531035[_0x34c244(0xdaa)+'e'](_0x19da01[_0x34c244(0x4e1)]);}),PluginManager[_0xe90fac(0xbd6)+'mmand'](pluginData['name'],_0xe90fac(0x44d)+_0xe90fac(0x15ba)+_0xe90fac(0x798),_0x1d4b97=>{const _0x3b78e2=_0xe90fac,_0x1806da={'sImSm':_0x3b78e2(0x389)+_0x3b78e2(0x798)};if(!SceneManager[_0x3b78e2(0x11be)+_0x3b78e2(0x3ad)]())return;VisuMZ[_0x3b78e2(0x15ae)+'ams'](_0x1d4b97,_0x1d4b97);const _0x5f14aa=$gameTemp[_0x3b78e2(0xb71)+_0x3b78e2(0x10f2)+_0x3b78e2(0x1b4)+'r'](),_0x38e062=VisuMZ[_0x3b78e2(0xd1a)+_0x3b78e2(0x12fd)+'Targets'](_0x1d4b97['Targets']),_0x3d33d5=_0x1d4b97[_0x3b78e2(0xb61)],_0x25bfa0=_0x1d4b97[_0x3b78e2(0x825)],_0x1a4a45=_0x1d4b97[_0x3b78e2(0x1521)],_0x57939f=_0x1d4b97[_0x3b78e2(0x1111)+_0x3b78e2(0x442)];if(!_0x5f14aa)return;for(const _0x376ac4 of _0x38e062){if(!_0x376ac4)continue;_0x376ac4['changeBatt'+_0x3b78e2(0x311)](_0x3d33d5,_0x25bfa0,_0x1a4a45);}if(_0x57939f)_0x5f14aa[_0x3b78e2(0xdaa)+'e'](_0x1806da['sImSm']);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x44d)+'ement_Scal'+'e',_0x1a505b=>{const _0x18e18e=_0xe90fac,_0x50252b={'LorOZ':_0x18e18e(0x1118)};if(!SceneManager['isSceneBat'+_0x18e18e(0x3ad)]())return;VisuMZ[_0x18e18e(0x15ae)+'ams'](_0x1a505b,_0x1a505b);const _0x41f8b4=$gameTemp[_0x18e18e(0xb71)+_0x18e18e(0x10f2)+_0x18e18e(0x1b4)+'r'](),_0x75aa1b=VisuMZ['CreateActi'+_0x18e18e(0x12fd)+'Targets'](_0x1a505b['Targets']),_0x4be47c=_0x1a505b[_0x18e18e(0x157)],_0x5608cf=_0x1a505b['ScaleY'],_0x220063=_0x1a505b[_0x18e18e(0x825)],_0x3b11ef=_0x1a505b[_0x18e18e(0x1521)],_0x504b5a=_0x1a505b[_0x18e18e(0x8f7)+'le'];if(!_0x41f8b4)return;for(const _0x1a1456 of _0x75aa1b){if(!_0x1a1456)continue;_0x1a1456[_0x18e18e(0x10a4)+'r'](_0x4be47c,_0x5608cf,_0x220063,_0x3b11ef);}if(_0x504b5a)_0x41f8b4[_0x18e18e(0xdaa)+'e'](_0x50252b[_0x18e18e(0x1187)]);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x44d)+_0xe90fac(0x5de),_0x445c21=>{const _0x2622dd=_0xe90fac,_0x7917e6={'cPVoR':_0x2622dd(0x15b4)+_0x2622dd(0x374)};if(!SceneManager['isSceneBat'+_0x2622dd(0x3ad)]())return;VisuMZ[_0x2622dd(0x15ae)+'ams'](_0x445c21,_0x445c21);const _0x4135d5=$gameTemp[_0x2622dd(0xb71)+'ginCommand'+'Interprete'+'r'](),_0x3402e3=VisuMZ[_0x2622dd(0xd1a)+_0x2622dd(0x12fd)+_0x2622dd(0x1027)](_0x445c21[_0x2622dd(0x1027)]),_0x450c90=_0x445c21[_0x2622dd(0x157e)],_0x4ec3b3=_0x445c21[_0x2622dd(0x239)],_0x5b1d74=_0x445c21[_0x2622dd(0x825)],_0x5c07cf=_0x445c21[_0x2622dd(0x1521)],_0x1c33e6=_0x445c21['WaitForSke'+'w'];if(!_0x4135d5)return;for(const _0x2d9a63 of _0x3402e3){if(!_0x2d9a63)continue;_0x2d9a63[_0x2622dd(0xa7b)+'r'](_0x450c90,_0x4ec3b3,_0x5b1d74,_0x5c07cf);}if(_0x1c33e6)_0x4135d5['setWaitMod'+'e'](_0x7917e6['cPVoR']);}),PluginManager['registerCo'+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],'ActSeq_Mov'+_0xe90fac(0x1272),_0x545856=>{const _0x31df80=_0xe90fac,_0x308a4f={'koWGL':'battleSpin'};if(!SceneManager[_0x31df80(0x11be)+_0x31df80(0x3ad)]())return;VisuMZ[_0x31df80(0x15ae)+_0x31df80(0xe3)](_0x545856,_0x545856);const _0x4f9cf6=$gameTemp[_0x31df80(0xb71)+_0x31df80(0x10f2)+_0x31df80(0x1b4)+'r'](),_0x4a0bd3=VisuMZ['CreateActi'+'onSequence'+_0x31df80(0x1027)](_0x545856[_0x31df80(0x1027)]),_0x2e0651=_0x545856[_0x31df80(0x306)],_0x486bea=_0x545856[_0x31df80(0x825)],_0x267bbc=_0x545856[_0x31df80(0x1521)],_0x137104=_0x545856[_0x31df80(0xa7d)+'e'],_0x448fc7=_0x545856['WaitForSpi'+'n'];if(!_0x4f9cf6)return;for(const _0x525fc0 of _0x4a0bd3){if(!_0x525fc0)continue;_0x525fc0[_0x31df80(0x120a)+'r'](_0x2e0651,_0x486bea,_0x267bbc,_0x137104);}if(_0x448fc7)_0x4f9cf6[_0x31df80(0xdaa)+'e'](_0x308a4f[_0x31df80(0x1303)]);}),PluginManager[_0xe90fac(0xbd6)+'mmand'](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x44d)+'ement_Wait'+'ForFloat',_0x3336e6=>{const _0x18e5ac=_0xe90fac,_0xdc8439={'RCrXa':_0x18e5ac(0x8de)+'t'};if(!SceneManager['isSceneBat'+_0x18e5ac(0x3ad)]())return;const _0xebc4de=$gameTemp['getLastPlu'+'ginCommand'+_0x18e5ac(0x1b4)+'r']();if(!_0xebc4de)return;_0xebc4de[_0x18e5ac(0xdaa)+'e'](_0xdc8439[_0x18e5ac(0x10c5)]);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x44d)+_0xe90fac(0x1528)+_0xe90fac(0xe16),_0x47ae5e=>{const _0x2662b9=_0xe90fac,_0x294ec4={'mPElv':'battleJump'};if(!SceneManager['isSceneBat'+_0x2662b9(0x3ad)]())return;const _0x49ca01=$gameTemp[_0x2662b9(0xb71)+_0x2662b9(0x10f2)+_0x2662b9(0x1b4)+'r']();if(!_0x49ca01)return;_0x49ca01[_0x2662b9(0xdaa)+'e'](_0x294ec4[_0x2662b9(0x14aa)]);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData['name'],_0xe90fac(0x44d)+'ement_Wait'+_0xe90fac(0x1483)+'t',_0x5ef756=>{const _0x54422e=_0xe90fac,_0x4f01d4={'sxWCG':_0x54422e(0x79a)};if(!SceneManager[_0x54422e(0x11be)+_0x54422e(0x3ad)]())return;const _0x19b439=$gameTemp[_0x54422e(0xb71)+_0x54422e(0x10f2)+_0x54422e(0x1b4)+'r']();if(!_0x19b439)return;_0x19b439['setWaitMod'+'e'](_0x4f01d4[_0x54422e(0x53e)]);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData['name'],'ActSeq_Mov'+'ement_Wait'+'ForOpacity',_0x10d9ac=>{const _0x50a204=_0xe90fac,_0x19a407={'BrdgW':_0x50a204(0x389)+_0x50a204(0x798)};if(!SceneManager[_0x50a204(0x11be)+_0x50a204(0x3ad)]())return;const _0x3a124d=$gameTemp[_0x50a204(0xb71)+_0x50a204(0x10f2)+'Interprete'+'r']();if(!_0x3a124d)return;_0x3a124d[_0x50a204(0xdaa)+'e'](_0x19a407[_0x50a204(0xa24)]);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],'ActSeq_Mov'+_0xe90fac(0x1528)+_0xe90fac(0xc7c),_0x19fb5b=>{const _0xe766c0=_0xe90fac,_0x50d72f={'MzBUO':_0xe766c0(0x1118)};if(!SceneManager[_0xe766c0(0x11be)+'tle']())return;const _0x1d3a89=$gameTemp[_0xe766c0(0xb71)+_0xe766c0(0x10f2)+_0xe766c0(0x1b4)+'r']();if(!_0x1d3a89)return;_0x1d3a89[_0xe766c0(0xdaa)+'e'](_0x50d72f[_0xe766c0(0xb03)]);}),PluginManager['registerCo'+'mmand'](pluginData[_0xe90fac(0x14c)],'ActSeq_Mov'+'ement_Wait'+'ForSkew',_0x3bd420=>{const _0x5e63a2=_0xe90fac,_0x26a0ec={'glpCL':'battleSpri'+_0x5e63a2(0x374)};if(!SceneManager[_0x5e63a2(0x11be)+_0x5e63a2(0x3ad)]())return;const _0x24fecf=$gameTemp[_0x5e63a2(0xb71)+_0x5e63a2(0x10f2)+'Interprete'+'r']();if(!_0x24fecf)return;_0x24fecf[_0x5e63a2(0xdaa)+'e'](_0x26a0ec[_0x5e63a2(0xb60)]);}),PluginManager[_0xe90fac(0xbd6)+'mmand'](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x44d)+_0xe90fac(0x1528)+_0xe90fac(0x3ab),_0x5e552f=>{const _0x3069a4=_0xe90fac,_0x566ade={'EWTEX':'battleSpin'};if(!SceneManager[_0x3069a4(0x11be)+_0x3069a4(0x3ad)]())return;const _0x54a225=$gameTemp[_0x3069a4(0xb71)+_0x3069a4(0x10f2)+_0x3069a4(0x1b4)+'r']();if(!_0x54a225)return;_0x54a225[_0x3069a4(0xdaa)+'e'](_0x566ade['EWTEX']);}),VisuMZ['BattleCore'][_0xe90fac(0x140e)+'qProjectil'+_0xe90fac(0x359)]=function(){const _0xc6ac1f=_0xe90fac,_0x42d433={'Ojtsv':function(_0x2a725b,_0x5448a2){return _0x2a725b<_0x5448a2;},'JRxpR':_0xc6ac1f(0xc49)+_0xc6ac1f(0x52f)+_0xc6ac1f(0x42a)+'ds\x20to\x20be\x20u'+_0xc6ac1f(0x4fa),'cYhMT':'in\x20order\x20f'+_0xc6ac1f(0x6d6)+'1_BattleCo'+'re\x20to\x20work'+'.','VXuvp':function(_0x54983c,_0x5c340a){return _0x54983c(_0x5c340a);}};if(!Imported[_0xc6ac1f(0xc49)+_0xc6ac1f(0x52f)+_0xc6ac1f(0x1cb)])return;if(_0x42d433[_0xc6ac1f(0x5cb)](VisuMZ[_0xc6ac1f(0x142d)+'ectiles'][_0xc6ac1f(0x6ca)],-0x1*-0xb51+0xc63+-0x17b3+0.08000000000000007)){let _0x2b25b9='';_0x2b25b9+=_0x42d433[_0xc6ac1f(0x9db)],_0x2b25b9+=_0x42d433[_0xc6ac1f(0x1143)],_0x42d433[_0xc6ac1f(0x560)](alert,_0x2b25b9),SceneManager[_0xc6ac1f(0x10c0)]();}},PluginManager['registerCo'+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],'ActSeq_Pro'+'jectile_An'+'imation',_0x48d0f1=>{const _0x410c4a=_0xe90fac,_0x47f31c={'GguTV':_0x410c4a(0x5da)+_0x410c4a(0x870)};if(!SceneManager['isSceneBat'+'tle']())return;if(!Imported['VisuMZ_3_A'+'ctSeqProje'+_0x410c4a(0x1cb)])return;VisuMZ['ConvertPar'+_0x410c4a(0xe3)](_0x48d0f1,_0x48d0f1),VisuMZ[_0x410c4a(0x118f)][_0x410c4a(0x140e)+_0x410c4a(0x160a)+_0x410c4a(0x359)]();const _0x17fa18=$gameTemp['getLastPlu'+'ginCommand'+_0x410c4a(0x1b4)+'r'](),_0xdc5b84=_0x48d0f1[_0x410c4a(0x135)+_0x410c4a(0x1609)];if(!_0x17fa18)return;const _0x382919=BattleManager[_0x410c4a(0x981)];if(!_0x382919)return;_0x382919[_0x410c4a(0x1139)+'onSequence'+_0x410c4a(0xaf8)](_0x48d0f1);if(_0xdc5b84)_0x17fa18[_0x410c4a(0xdaa)+'e'](_0x47f31c[_0x410c4a(0x10a0)]);}),PluginManager[_0xe90fac(0xbd6)+'mmand'](pluginData[_0xe90fac(0x14c)],_0xe90fac(0xbc7)+_0xe90fac(0x1042)+'on',_0x452e24=>{const _0x6b3a11=_0xe90fac,_0x4f6390={'CnKrF':'battleProj'+_0x6b3a11(0x870)};if(!SceneManager[_0x6b3a11(0x11be)+_0x6b3a11(0x3ad)]())return;if(!Imported['VisuMZ_3_A'+_0x6b3a11(0x52f)+_0x6b3a11(0x1cb)])return;VisuMZ['ConvertPar'+'ams'](_0x452e24,_0x452e24),VisuMZ[_0x6b3a11(0x118f)][_0x6b3a11(0x140e)+_0x6b3a11(0x160a)+_0x6b3a11(0x359)]();const _0x178592=$gameTemp[_0x6b3a11(0xb71)+_0x6b3a11(0x10f2)+_0x6b3a11(0x1b4)+'r'](),_0x4d6b24=_0x452e24[_0x6b3a11(0x135)+_0x6b3a11(0x1609)];if(!_0x178592)return;const _0x48083b=BattleManager[_0x6b3a11(0x981)];if(!_0x48083b)return;_0x48083b[_0x6b3a11(0x1139)+_0x6b3a11(0x12fd)+_0x6b3a11(0xaf8)](_0x452e24);if(_0x4d6b24)_0x178592[_0x6b3a11(0xdaa)+'e'](_0x4f6390[_0x6b3a11(0xbba)]);}),PluginManager['registerCo'+_0xe90fac(0xc22)](pluginData['name'],'ActSeq_Pro'+_0xe90fac(0xde8)+_0xe90fac(0x3ae),_0x4ddf1d=>{const _0x2d7fb0=_0xe90fac,_0xfe29a7={'eSann':_0x2d7fb0(0x5da)+_0x2d7fb0(0x870)};if(!SceneManager[_0x2d7fb0(0x11be)+_0x2d7fb0(0x3ad)]())return;if(!Imported[_0x2d7fb0(0xc49)+_0x2d7fb0(0x52f)+_0x2d7fb0(0x1cb)])return;VisuMZ[_0x2d7fb0(0x15ae)+_0x2d7fb0(0xe3)](_0x4ddf1d,_0x4ddf1d),VisuMZ[_0x2d7fb0(0x118f)][_0x2d7fb0(0x140e)+_0x2d7fb0(0x160a)+_0x2d7fb0(0x359)]();const _0x597a66=$gameTemp[_0x2d7fb0(0xb71)+'ginCommand'+_0x2d7fb0(0x1b4)+'r'](),_0x1238e1=_0x4ddf1d[_0x2d7fb0(0x135)+_0x2d7fb0(0x1609)];if(!_0x597a66)return;const _0x576537=BattleManager[_0x2d7fb0(0x981)];if(!_0x576537)return;_0x576537['createActi'+'onSequence'+_0x2d7fb0(0xaf8)](_0x4ddf1d);if(_0x1238e1)_0x597a66[_0x2d7fb0(0xdaa)+'e'](_0xfe29a7['eSann']);}),PluginManager['registerCo'+'mmand'](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x11e1)+_0xe90fac(0xd7a),_0x3ae3ae=>{const _0x4eed47=_0xe90fac,_0x5d48a3={'QLRJz':_0x4eed47(0xec8)};if(!SceneManager[_0x4eed47(0x11be)+_0x4eed47(0x3ad)]())return;if(!Imported[_0x4eed47(0xc49)+_0x4eed47(0x26a)+'a'])return;VisuMZ[_0x4eed47(0x15ae)+_0x4eed47(0xe3)](_0x3ae3ae,_0x3ae3ae);const _0x5c39a4=$gameTemp[_0x4eed47(0xb71)+_0x4eed47(0x10f2)+_0x4eed47(0x1b4)+'r'](),_0xb4fb7a=_0x3ae3ae[_0x4eed47(0x152)+'w'];if(!_0x5c39a4)return;$gameScreen['setBattleS'+_0x4eed47(0x1456)](_0x3ae3ae[_0x4eed47(0x157e)],_0x3ae3ae['SkewY'],_0x3ae3ae[_0x4eed47(0x825)],_0x3ae3ae[_0x4eed47(0x1521)]);if(_0xb4fb7a)_0x5c39a4['setWaitMod'+'e'](_0x5d48a3[_0x4eed47(0x7e2)]);}),PluginManager['registerCo'+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0xe8e)+_0xe90fac(0x1551),_0x291621=>{const _0x333e46=_0xe90fac,_0x291c4d={'YWTDu':_0x333e46(0xec8)};if(!SceneManager[_0x333e46(0x11be)+_0x333e46(0x3ad)]())return;if(!Imported[_0x333e46(0xc49)+_0x333e46(0x26a)+'a'])return;VisuMZ[_0x333e46(0x15ae)+_0x333e46(0xe3)](_0x291621,_0x291621);const _0x1187af=$gameTemp[_0x333e46(0xb71)+_0x333e46(0x10f2)+_0x333e46(0x1b4)+'r'](),_0x40d2e4=_0x291621['WaitForSke'+'w'];if(!_0x1187af)return;$gameScreen[_0x333e46(0x9fa)+_0x333e46(0x1456)](0x25c7+0x1b4c+-0x4113,0x2*-0xf9a+-0x12f*-0x2+0x1cd6,_0x291621[_0x333e46(0x825)],_0x291621['EasingType']);if(_0x40d2e4)_0x1187af[_0x333e46(0xdaa)+'e'](_0x291c4d['YWTDu']);}),PluginManager['registerCo'+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],'ActSeq_Ske'+_0xe90fac(0x6c2)+_0xe90fac(0x1456),_0x41db9b=>{const _0x36b130=_0xe90fac,_0x2382a6={'tqvxw':'battleSkew'};if(!SceneManager[_0x36b130(0x11be)+'tle']())return;if(!Imported['VisuMZ_3_A'+_0x36b130(0x26a)+'a'])return;const _0x2f5232=$gameTemp['getLastPlu'+'ginCommand'+_0x36b130(0x1b4)+'r']();if(!_0x2f5232)return;_0x2f5232[_0x36b130(0xdaa)+'e'](_0x2382a6[_0x36b130(0x613)]);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x125e)+_0xe90fac(0x6d7)+'tIndex',_0x2bf8c7=>{const _0x889a1d=_0xe90fac,_0x4d06db={'VZODB':function(_0x413435,_0x6720d0){return _0x413435!==_0x6720d0;},'EOEUO':_0x889a1d(0x977)};if(!SceneManager['isSceneBat'+_0x889a1d(0x3ad)]())return;VisuMZ[_0x889a1d(0x15ae)+_0x889a1d(0xe3)](_0x2bf8c7,_0x2bf8c7);const _0x18022d=$gameTemp['getLastPlu'+_0x889a1d(0x10f2)+_0x889a1d(0x1b4)+'r'](),_0x45481c=_0x2bf8c7[_0x889a1d(0x10dc)],_0x5eef23=_0x2bf8c7[_0x889a1d(0xde1)+'l'];if(!_0x18022d)return;BattleManager['_targetInd'+'ex']=_0x45481c,BattleManager[_0x889a1d(0x146b)]=BattleManager[_0x889a1d(0xa1c)+'s']?BattleManager[_0x889a1d(0xa1c)+'s'][BattleManager['_targetInd'+'ex']]||null:null,BattleManager[_0x889a1d(0x146b)]&&_0x4d06db[_0x889a1d(0xe49)](_0x5eef23[_0x889a1d(0x1318)+'e']()['trim'](),_0x4d06db[_0x889a1d(0xe73)])&&_0x18022d['command119']([_0x5eef23]);}),PluginManager[_0xe90fac(0xbd6)+'mmand'](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x125e)+_0xe90fac(0x985)+'rget',_0x3472b8=>{const _0x22df59=_0xe90fac,_0x57b56d={'BVhOD':function(_0x4349ae,_0x77ba35){return _0x4349ae!==_0x77ba35;},'QSNrZ':'UNTITLED'};if(!SceneManager['isSceneBat'+_0x22df59(0x3ad)]())return;VisuMZ[_0x22df59(0x15ae)+_0x22df59(0xe3)](_0x3472b8,_0x3472b8);const _0x3229f8=$gameTemp[_0x22df59(0xb71)+_0x22df59(0x10f2)+_0x22df59(0x1b4)+'r'](),_0x269d65=_0x3472b8[_0x22df59(0xde1)+'l'];if(!_0x3229f8)return;BattleManager[_0x22df59(0xc83)+'ex']++,BattleManager['_target']=BattleManager[_0x22df59(0xa1c)+'s'][BattleManager[_0x22df59(0xc83)+'ex']]||null,BattleManager[_0x22df59(0x146b)]&&_0x57b56d[_0x22df59(0xeb3)](_0x269d65[_0x22df59(0x1318)+'e']()[_0x22df59(0x808)](),_0x57b56d[_0x22df59(0x4af)])&&_0x3229f8[_0x22df59(0x1022)]([_0x269d65]);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x125e)+_0xe90fac(0x1508)+_0xe90fac(0xe64),_0x6f0aaa=>{const _0x1c9c80=_0xe90fac,_0x3beced={'HxCaf':function(_0xf3e464,_0x14f467){return _0xf3e464!==_0x14f467;},'qiudq':_0x1c9c80(0x977)};if(!SceneManager['isSceneBat'+_0x1c9c80(0x3ad)]())return;VisuMZ[_0x1c9c80(0x15ae)+_0x1c9c80(0xe3)](_0x6f0aaa,_0x6f0aaa);const _0x5c792e=$gameTemp[_0x1c9c80(0xb71)+'ginCommand'+'Interprete'+'r'](),_0xdd0730=_0x6f0aaa['JumpToLabe'+'l'];if(!_0x5c792e)return;BattleManager[_0x1c9c80(0xc83)+'ex']--,BattleManager['_target']=BattleManager[_0x1c9c80(0xa1c)+'s'][BattleManager[_0x1c9c80(0xc83)+'ex']]||null,BattleManager[_0x1c9c80(0x146b)]&&_0x3beced[_0x1c9c80(0xbb7)](_0xdd0730['toUpperCas'+'e']()[_0x1c9c80(0x808)](),_0x3beced[_0x1c9c80(0x13b5)])&&_0x5c792e[_0x1c9c80(0x1022)]([_0xdd0730]);}),PluginManager['registerCo'+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x125e)+'get_RandTa'+_0xe90fac(0xe64),_0x1b4b35=>{const _0x3dd4af=_0xe90fac,_0x1cc254={'aDTJV':function(_0x7ef697,_0xaf1ae4){return _0x7ef697!==_0xaf1ae4;},'hmXOi':function(_0x547b1f,_0x414520){return _0x547b1f<=_0x414520;},'svxEt':function(_0x12342f,_0x42abca){return _0x12342f!==_0x42abca;},'egbac':'UNTITLED'};if(!SceneManager[_0x3dd4af(0x11be)+_0x3dd4af(0x3ad)]())return;VisuMZ[_0x3dd4af(0x15ae)+'ams'](_0x1b4b35,_0x1b4b35);const _0x44542d=$gameTemp[_0x3dd4af(0xb71)+_0x3dd4af(0x10f2)+_0x3dd4af(0x1b4)+'r'](),_0x497ea7=_0x1b4b35[_0x3dd4af(0x3fb)+'m'],_0x52d1f1=_0x1b4b35[_0x3dd4af(0xde1)+'l'];if(!_0x44542d)return;const _0x229257=BattleManager['_targetInd'+'ex'];for(;;){BattleManager[_0x3dd4af(0xc83)+'ex']=Math['randomInt'](BattleManager[_0x3dd4af(0xa1c)+'s']['length']);if(!_0x497ea7)break;if(_0x1cc254[_0x3dd4af(0x1055)](BattleManager['_targetInd'+'ex'],_0x229257))break;if(_0x1cc254[_0x3dd4af(0x8fe)](BattleManager[_0x3dd4af(0xa1c)+'s'][_0x3dd4af(0x1268)],-0x32f*-0x9+-0x208f+-0x5b*-0xb)){BattleManager[_0x3dd4af(0xc83)+'ex']=0xb59+-0xc7e*-0x1+0x11*-0x167;break;}}BattleManager['_target']=BattleManager['_allTarget'+'s'][BattleManager[_0x3dd4af(0xc83)+'ex']]||null,BattleManager[_0x3dd4af(0x146b)]&&_0x1cc254[_0x3dd4af(0x12b3)](_0x52d1f1[_0x3dd4af(0x1318)+'e']()[_0x3dd4af(0x808)](),_0x1cc254[_0x3dd4af(0x6c9)])&&_0x44542d[_0x3dd4af(0x1022)]([_0x52d1f1]);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x92d)+_0xe90fac(0x11dc)+'layCommonL'+_0xe90fac(0xbd0),_0x101271=>{const _0x21682e=_0xe90fac;if(!SceneManager[_0x21682e(0x11be)+_0x21682e(0x3ad)]())return;if(!Imported['VisuMZ_3_B'+_0x21682e(0x4c4)+'s'])return;if(!ConfigManager['battleVoic'+'es'])return;VisuMZ['ConvertPar'+'ams'](_0x101271,_0x101271);const _0x2d4caa=VisuMZ['CreateActi'+'onSequence'+'Targets'](_0x101271[_0x21682e(0x1027)]);let _0x3c705b=_0x101271[_0x21682e(0x57a)]||'';for(const _0xc2d29d of _0x2d4caa){if(!_0xc2d29d)continue;_0xc2d29d[_0x21682e(0x10b2)+_0x21682e(0x13b6)](_0x3c705b);}}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x92d)+_0xe90fac(0x11dc)+_0xe90fac(0xdc6)+_0xe90fac(0x1212),_0x587ea7=>{const _0x5cb5c0=_0xe90fac,_0x3181fa={'ghbdY':function(_0x127421,_0x5a2d6a){return _0x127421+_0x5a2d6a;}};if(!SceneManager[_0x5cb5c0(0x11be)+_0x5cb5c0(0x3ad)]())return;if(!Imported['VisuMZ_3_B'+'attleVoice'+'s'])return;if(!ConfigManager['battleVoic'+'es'])return;VisuMZ[_0x5cb5c0(0x15ae)+'ams'](_0x587ea7,_0x587ea7);const _0x15b912=VisuMZ[_0x5cb5c0(0xd1a)+_0x5cb5c0(0x12fd)+_0x5cb5c0(0x1027)](_0x587ea7[_0x5cb5c0(0x1027)]);let _0x27b048=_0x3181fa[_0x5cb5c0(0x644)](_0x587ea7['VoiceLineT'+_0x5cb5c0(0xbbf)]||'',_0x587ea7[_0x5cb5c0(0x1128)]||'');for(const _0x30f38e of _0x15b912){if(!_0x30f38e)continue;_0x30f38e[_0x5cb5c0(0x10b2)+_0x5cb5c0(0x13b6)](_0x27b048);}}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x1251)+'pon_ClearA'+'ctiveWeapo'+'n',_0x1250a2=>{const _0x1d4210=_0xe90fac;if(!SceneManager[_0x1d4210(0x11be)+_0x1d4210(0x3ad)]())return;VisuMZ[_0x1d4210(0x15ae)+'ams'](_0x1250a2,_0x1250a2);const _0x249d5c=VisuMZ[_0x1d4210(0xd1a)+_0x1d4210(0x12fd)+'Targets'](_0x1250a2[_0x1d4210(0x1027)]);for(const _0x5c5f08 of _0x249d5c){if(!_0x5c5f08)continue;if(!_0x5c5f08[_0x1d4210(0xd83)]())continue;_0x5c5f08[_0x1d4210(0x8e2)+_0x1d4210(0x150e)+'t']();}}),PluginManager['registerCo'+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x1251)+'pon_NextAc'+_0xe90fac(0xaed),_0x8c84e8=>{const _0x5466eb=_0xe90fac,_0x22427a={'CFQbw':function(_0x105f27,_0x4bb0d3){return _0x105f27>_0x4bb0d3;},'BsVHC':function(_0x35da07,_0x1411df){return _0x35da07!==_0x1411df;},'NHjlU':_0x5466eb(0x977)};if(!SceneManager['isSceneBat'+_0x5466eb(0x3ad)]())return;VisuMZ['ConvertPar'+'ams'](_0x8c84e8,_0x8c84e8);const _0x159aee=$gameTemp[_0x5466eb(0xb71)+_0x5466eb(0x10f2)+_0x5466eb(0x1b4)+'r']();let _0x54f288=![];const _0x41b568=_0x8c84e8[_0x5466eb(0xde1)+'l'],_0x545a29=VisuMZ[_0x5466eb(0xd1a)+_0x5466eb(0x12fd)+_0x5466eb(0x1027)](_0x8c84e8[_0x5466eb(0x1027)]);for(const _0x7a33de of _0x545a29){if(!_0x7a33de)continue;if(!_0x7a33de[_0x5466eb(0xd83)]())continue;_0x7a33de[_0x5466eb(0xc27)+'WeaponSlot'](),_0x22427a[_0x5466eb(0xc7d)](_0x7a33de[_0x5466eb(0x1232)]()[_0x5466eb(0x1268)],-0x179*0x9+-0x1091*-0x2+-0x13e1)?_0x54f288=!![]:_0x7a33de['clearActiv'+_0x5466eb(0x150e)+'t']();}_0x54f288&&_0x22427a[_0x5466eb(0x1eb)](_0x41b568['toUpperCas'+'e']()[_0x5466eb(0x808)](),_0x22427a[_0x5466eb(0xef8)])&&_0x159aee[_0x5466eb(0x1022)]([_0x41b568]);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x1251)+_0xe90fac(0x277)+_0xe90fac(0x1530),_0x35e87a=>{const _0x523dbe=_0xe90fac;if(!SceneManager[_0x523dbe(0x11be)+_0x523dbe(0x3ad)]())return;VisuMZ[_0x523dbe(0x15ae)+'ams'](_0x35e87a,_0x35e87a);let _0x2c715e=_0x35e87a[_0x523dbe(0x1567)];_0x2c715e--,_0x2c715e=Math['max'](_0x2c715e,0x15d2+0x135e+-0x293*0x10);const _0x72c7b5=VisuMZ[_0x523dbe(0xd1a)+_0x523dbe(0x12fd)+_0x523dbe(0x1027)](_0x35e87a[_0x523dbe(0x1027)]);for(const _0x2616cb of _0x72c7b5){if(!_0x2616cb)continue;if(!_0x2616cb[_0x523dbe(0xd83)]())continue;_0x2616cb[_0x523dbe(0x11ad)+_0x523dbe(0xd57)](_0x2c715e);}}),PluginManager[_0xe90fac(0xbd6)+'mmand'](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x111d)+_0xe90fac(0x11f1),_0x2b792d=>{const _0x15ab92=_0xe90fac,_0x16bc87={'fPQnU':'battleZoom'};if(!SceneManager['isSceneBat'+'tle']())return;if(!Imported[_0x15ab92(0xc49)+_0x15ab92(0x26a)+'a'])return;VisuMZ['ConvertPar'+_0x15ab92(0xe3)](_0x2b792d,_0x2b792d);const _0x2ad852=$gameTemp[_0x15ab92(0xb71)+'ginCommand'+_0x15ab92(0x1b4)+'r'](),_0x1c3f05=_0x2b792d[_0x15ab92(0x10d8)+'m'];if(!_0x2ad852)return;$gameScreen[_0x15ab92(0x678)+_0x15ab92(0xd9d)](_0x2b792d[_0x15ab92(0xfe6)],_0x2b792d['Duration'],_0x2b792d[_0x15ab92(0x1521)]);if(_0x1c3f05)_0x2ad852[_0x15ab92(0xdaa)+'e'](_0x16bc87['fPQnU']);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],'ActSeq_Zoo'+_0xe90fac(0x585),_0x569ed8=>{const _0x57f139=_0xe90fac,_0x2f2026={'xJYCg':'battleZoom'};if(!SceneManager[_0x57f139(0x11be)+'tle']())return;if(!Imported[_0x57f139(0xc49)+_0x57f139(0x26a)+'a'])return;VisuMZ[_0x57f139(0x15ae)+_0x57f139(0xe3)](_0x569ed8,_0x569ed8);const _0x54b6f7=$gameTemp['getLastPlu'+'ginCommand'+'Interprete'+'r'](),_0x295b0c=_0x569ed8['WaitForZoo'+'m'];if(!_0x54b6f7)return;$gameScreen[_0x57f139(0x678)+'oom'](0xc0d+0x26d5*-0x1+-0x1ac9*-0x1,_0x569ed8[_0x57f139(0x825)],_0x569ed8[_0x57f139(0x1521)]);if(_0x295b0c)_0x54b6f7[_0x57f139(0xdaa)+'e'](_0x2f2026[_0x57f139(0x14ea)]);}),PluginManager[_0xe90fac(0xbd6)+_0xe90fac(0xc22)](pluginData[_0xe90fac(0x14c)],_0xe90fac(0x111d)+_0xe90fac(0xd5a)+'oom',_0x2f40f1=>{const _0x46c5d1=_0xe90fac,_0x598460={'fcrDx':'battleZoom'};if(!SceneManager[_0x46c5d1(0x11be)+_0x46c5d1(0x3ad)]())return;if(!Imported[_0x46c5d1(0xc49)+_0x46c5d1(0x26a)+'a'])return;const _0x469d31=$gameTemp[_0x46c5d1(0xb71)+_0x46c5d1(0x10f2)+_0x46c5d1(0x1b4)+'r']();if(!_0x469d31)return;_0x469d31[_0x46c5d1(0xdaa)+'e'](_0x598460['fcrDx']);}),VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xa13)+'_onDatabas'+_0xe90fac(0x6b8)]=Scene_Boot['prototype'][_0xe90fac(0xd2c)+_0xe90fac(0xdf1)],Scene_Boot[_0xe90fac(0x510)][_0xe90fac(0xd2c)+_0xe90fac(0xdf1)]=function(){const _0xb568b1=_0xe90fac,_0x3ea330={'eZIgN':_0xb568b1(0x4f5)+'8|5|3|2'},_0x27c3b1=_0x3ea330[_0xb568b1(0x605)][_0xb568b1(0xab1)]('|');let _0xd5c66=-0x11bd+-0x608+-0x4c1*-0x5;while(!![]){switch(_0x27c3b1[_0xd5c66++]){case'0':VisuMZ[_0xb568b1(0x118f)][_0xb568b1(0xa13)+_0xb568b1(0xfa8)+'eLoaded'][_0xb568b1(0x351)](this);continue;case'1':this[_0xb568b1(0x9ae)+_0xb568b1(0x1538)+'eCore_Dama'+'geStyles']();continue;case'2':this[_0xb568b1(0x9ae)+_0xb568b1(0x1538)+_0xb568b1(0x14ec)+'onEventKey'+'s']();continue;case'3':this['process_Vi'+_0xb568b1(0x1538)+_0xb568b1(0x118e)+_0xb568b1(0x13f5)+_0xb568b1(0x9f7)]();continue;case'4':this[_0xb568b1(0x9ae)+_0xb568b1(0x1538)+'eCore_Plug'+_0xb568b1(0x15bf)]();continue;case'5':this[_0xb568b1(0x9ae)+'suMZ_Battl'+_0xb568b1(0xd0e)+_0xb568b1(0x33f)]();continue;case'6':this[_0xb568b1(0x9ae)+_0xb568b1(0x1538)+_0xb568b1(0xea9)+'teRegExp']();continue;case'7':this[_0xb568b1(0x9ae)+_0xb568b1(0x1538)+'eCore_Fail'+'safes']();continue;case'8':this[_0xb568b1(0x9ae)+_0xb568b1(0x1538)+_0xb568b1(0x145)+_0xb568b1(0x137a)]();continue;}break;}},Scene_Boot[_0xe90fac(0x510)][_0xe90fac(0x9ae)+'suMZ_Battl'+_0xe90fac(0x145)+'tags']=function(){const _0x314fbd=_0xe90fac;if(VisuMZ['ParseAllNo'+'tetags'])return;this[_0x314fbd(0x9ae)+_0x314fbd(0x1538)+_0x314fbd(0x26e)+_0x314fbd(0x4a8)+'s'](),this[_0x314fbd(0x9ae)+_0x314fbd(0x1538)+_0x314fbd(0x732)+_0x314fbd(0x577)+'tetags'](),this[_0x314fbd(0x9ae)+_0x314fbd(0x1538)+_0x314fbd(0x14a6)+'nctions']();},Scene_Boot['prototype']['process_Vi'+_0xe90fac(0x1538)+_0xe90fac(0xee6)+_0xe90fac(0x117b)]=function(){const _0x2df0cb=_0xe90fac,_0x44f493={'hqKPc':function(_0x349267,_0x4d04be){return _0x349267<_0x4d04be;}},_0x4082a8=$dataSystem[_0x2df0cb(0x927)+'s'][_0x2df0cb(0x1268)];for(let _0x2dfd8f=0x1f06+0x1817+-0x3*0x125f;_0x44f493[_0x2df0cb(0x1240)](_0x2dfd8f,_0x4082a8);_0x2dfd8f++){const _0x46c6ed=$dataSystem['attackMoti'+'ons'][_0x2dfd8f];if(_0x46c6ed)continue;$dataSystem[_0x2df0cb(0x198)+_0x2df0cb(0x15e9)][_0x2dfd8f]={'type':0x1,'weaponImageId':0x1};}},Scene_Boot['prototype'][_0xe90fac(0x9ae)+_0xe90fac(0x1538)+_0xe90fac(0xe40)+_0xe90fac(0x15bf)]=function(){const _0x584392=_0xe90fac,_0x511b7e={'PDhrv':function(_0x20d6cd,_0x81cc10){return _0x20d6cd===_0x81cc10;},'nzjeT':_0x584392(0xe2f),'dfHXt':function(_0x1285e5,_0x3bcdb2){return _0x1285e5===_0x3bcdb2;},'FyKpJ':function(_0xe9748f,_0x454029){return _0xe9748f===_0x454029;},'loRZt':function(_0x2eb95a,_0x3c503c){return _0x2eb95a===_0x3c503c;}},_0x292542=VisuMZ['BattleCore'][_0x584392(0x281)];_0x511b7e[_0x584392(0xa7)](_0x292542[_0x584392(0x7d7)][_0x584392(0xc90)+_0x584392(0x130a)],undefined)&&(_0x292542[_0x584392(0x7d7)][_0x584392(0xc90)+_0x584392(0x130a)]=_0x511b7e[_0x584392(0xc54)]),_0x511b7e['PDhrv'](_0x292542['Actor'][_0x584392(0x8a1)+'e'],undefined)&&(_0x292542[_0x584392(0xd11)][_0x584392(0x8a1)+'e']=![]),_0x511b7e['dfHXt'](_0x292542[_0x584392(0x105f)][_0x584392(0x8a1)+'e'],undefined)&&(_0x292542[_0x584392(0x105f)][_0x584392(0x8a1)+'e']=!![]),_0x511b7e[_0x584392(0x43a)](_0x292542['Actor'][_0x584392(0x535)+_0x584392(0x9e7)],undefined)&&(_0x292542[_0x584392(0xd11)][_0x584392(0x535)+'rtActive']=![]),_0x511b7e['loRZt'](_0x292542[_0x584392(0xd11)][_0x584392(0x535)+_0x584392(0xe38)],undefined)&&(_0x292542['Actor'][_0x584392(0x535)+_0x584392(0xe38)]=!![]);},VisuMZ[_0xe90fac(0x13f9)+'es']={},Scene_Boot['prototype'][_0xe90fac(0x9ae)+'suMZ_Battl'+_0xe90fac(0x7d8)+_0xe90fac(0xa92)]=function(){const _0x5f455d=_0xe90fac;for(const _0x426ef5 of VisuMZ[_0x5f455d(0x118f)][_0x5f455d(0x281)][_0x5f455d(0x7d7)][_0x5f455d(0x13f9)+'eList']){if(!_0x426ef5)continue;const _0x134c3e=_0x426ef5['Name'][_0x5f455d(0x1318)+'e']()['trim']();VisuMZ[_0x5f455d(0x13f9)+'es'][_0x134c3e]=_0x426ef5;}},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x193)]={'jsAccuracy':/<JS (?:ACCURACY|ACC|HIT|EVA)>\s*([\s\S]*?)\s*<\/JS (?:ACCURACY|ACC|HIT|EVA)>/i,'jsAccuracyAsUser':/<JS (?:ACCURACY|ACC|HIT|EVA) AS USER>\s*([\s\S]*?)\s*<\/JS (?:ACCURACY|ACC|HIT|EVA) AS USER>/i,'jsAccuracyAsTarget':/<JS (?:ACCURACY|ACC|HIT|EVA) AS TARGET>\s*([\s\S]*?)\s*<\/JS (?:ACCURACY|ACC|HIT|EVA) AS TARGET>/i,'jsCritRateAsUser':/<JS (?:CRITICAL RATE|CRI) AS USER>\s*([\s\S]*?)\s*<\/JS (?:CRITICAL RATE|CRI) AS USER>/i,'jsCritRateAsTarget':/<JS (?:CRITICAL RATE|CRI) AS TARGET>\s*([\s\S]*?)\s*<\/JS (?:CRITICAL RATE|CRI) AS TARGET>/i},Scene_Boot['prototype']['process_Vi'+_0xe90fac(0x1538)+_0xe90fac(0xea9)+'teRegExp']=function(){const _0x4f9e63=_0xe90fac,_0x50d844={'tTxsa':_0x4f9e63(0xed4)+_0x4f9e63(0x350)+'\x5c/%1>','sgsYa':_0x4f9e63(0x102e),'NrFSM':_0x4f9e63(0x51a),'xiFEC':_0x4f9e63(0x504),'trYRo':_0x4f9e63(0xe2e),'WAADs':'%1Apply%2J'+'S','FBSeS':_0x4f9e63(0x149d)+_0x4f9e63(0x4d1),'FatMf':_0x4f9e63(0x1d7)+'JS','YKHAh':_0x4f9e63(0x124d)+_0x4f9e63(0x983),'LUmIC':_0x4f9e63(0xe8d),'YtKeN':_0x4f9e63(0x1074),'KWqiG':_0x4f9e63(0x711),'ufROP':'AS\x20TARGET','mjjfY':'%1StartAct'+_0x4f9e63(0x1146),'NhCas':_0x4f9e63(0x1081)+_0x4f9e63(0x1035),'waXFJ':'%1EndActio'+_0x4f9e63(0x13af),'pmmrx':_0x4f9e63(0x12d8)+_0x4f9e63(0x5f1),'egrdB':_0x4f9e63(0x63c)+_0x4f9e63(0x3a6),'FRWhI':_0x4f9e63(0x1081)+'\x20BATTLE','zstul':'%1EndBattl'+'eJS','MIQsz':_0x4f9e63(0x151f)+_0x4f9e63(0xcc5),'LbLzg':_0x4f9e63(0x818)+_0x4f9e63(0x18b),'QWOlP':_0x4f9e63(0x119e)+_0x4f9e63(0x1437),'RAbaR':_0x4f9e63(0xcb9)+_0x4f9e63(0x160b),'ElyFL':_0x4f9e63(0x119e)+_0x4f9e63(0x656),'wzQer':_0x4f9e63(0xe4c)+_0x4f9e63(0xbfa),'HoXEz':'JS\x20ESCAPE\x20'+_0x4f9e63(0xdbb),'OyPgs':_0x4f9e63(0x14ae)+'ureJS','ZCTLe':_0x4f9e63(0x122e)+_0x4f9e63(0x287),'sVcWV':_0x4f9e63(0xf0b)+_0x4f9e63(0x13af),'qfABL':_0x4f9e63(0x1081)+_0x4f9e63(0x1137),'WlMwe':_0x4f9e63(0x8d2)+'S','bqnPj':_0x4f9e63(0x187)+'URN','jZWXF':_0x4f9e63(0x761)+_0x4f9e63(0x806),'wNauH':_0x4f9e63(0xff5)+_0x4f9e63(0xa4c)},_0x2efe9a=VisuMZ[_0x4f9e63(0x118f)][_0x4f9e63(0x193)],_0x574a70=_0x50d844[_0x4f9e63(0x1174)],_0x3fd016=[[_0x50d844['sgsYa'],_0x50d844[_0x4f9e63(0x145f)]],[_0x50d844['xiFEC'],_0x50d844[_0x4f9e63(0xf61)]]],_0x34a973=[[_0x50d844[_0x4f9e63(0x90b)],_0x50d844[_0x4f9e63(0x630)]],[_0x50d844[_0x4f9e63(0x11e)],_0x50d844[_0x4f9e63(0xac6)]]],_0x23ac47=[['',''],[_0x50d844[_0x4f9e63(0xb29)],_0x50d844[_0x4f9e63(0x452)]],[_0x50d844['KWqiG'],_0x50d844[_0x4f9e63(0x6ef)]]];for(const _0x4ac1f0 of _0x34a973){for(const _0x299351 of _0x23ac47){for(const _0x374e9e of _0x3fd016){const _0x1a8557=_0x4ac1f0[-0xc*-0x189+-0x1f*0xef+0xa85][_0x4f9e63(0xeb8)](_0x374e9e[-0x1*-0xec9+-0x2*0x634+-0x261],_0x299351[-0x185+0x10f*0x9+-0x802]),_0x400b4c=_0x4ac1f0[-0x444+0x1*-0x6a9+-0x577*-0x2][_0x4f9e63(0xeb8)](_0x374e9e[-0x22fc+-0xecb*-0x1+0x1432],_0x299351[0x2589+-0x2*0xd2d+-0xb2e])[_0x4f9e63(0x808)](),_0x22df78=new RegExp(_0x574a70[_0x4f9e63(0xeb8)](_0x400b4c),'i');_0x2efe9a[_0x1a8557]=_0x22df78;}}}const _0x5855bd=[[_0x50d844[_0x4f9e63(0x1482)],_0x50d844[_0x4f9e63(0xd2e)]],[_0x50d844['waXFJ'],_0x50d844['pmmrx']]];for(const _0x4513ae of _0x5855bd){for(const _0x5d3997 of _0x3fd016){const _0x22c78d=_0x4513ae[0x16e5*-0x1+-0xe25*-0x2+0x1*-0x565]['format'](_0x5d3997[-0x496*-0x5+-0x448+-0x12a6]),_0x26827b=_0x4513ae[0x1*0x9e9+-0x480+-0x1*0x568]['format'](_0x5d3997[0x1*0x20c9+-0x1a4+-0x1f24]),_0x55db32=new RegExp(_0x574a70['format'](_0x26827b),'i');_0x2efe9a[_0x22c78d]=_0x55db32;}}const _0x109aa3=[[_0x50d844[_0x4f9e63(0x5f6)],_0x50d844[_0x4f9e63(0xecc)]],[_0x50d844[_0x4f9e63(0x13c4)],_0x50d844[_0x4f9e63(0x1066)]],[_0x50d844[_0x4f9e63(0xc4b)],_0x50d844[_0x4f9e63(0x150)]],[_0x50d844[_0x4f9e63(0x1406)],_0x50d844[_0x4f9e63(0x5d3)]],[_0x50d844[_0x4f9e63(0xf96)],_0x50d844[_0x4f9e63(0x10f1)]],[_0x50d844[_0x4f9e63(0xe8)],_0x50d844[_0x4f9e63(0xa0f)]],[_0x50d844[_0x4f9e63(0x10ff)],_0x50d844['qfABL']],[_0x50d844[_0x4f9e63(0x56e)],_0x50d844[_0x4f9e63(0x73c)]],[_0x50d844[_0x4f9e63(0x2c6)],_0x50d844[_0x4f9e63(0x688)]]];for(const _0x589259 of _0x109aa3){for(const _0x194c7f of _0x3fd016){const _0x194009=_0x589259[0x25*-0x9d+0xb48+-0x1*-0xb69]['format'](_0x194c7f[0x1*0xf3d+0x1*0x1921+-0x285e]),_0x40e8c9=_0x589259[-0x2*0x2f5+0x2*-0xc15+0x1e15]['format'](_0x194c7f[0x1*0xf32+0xe61+-0xec9*0x2]),_0x28f51a=new RegExp(_0x574a70[_0x4f9e63(0xeb8)](_0x40e8c9),'i');_0x2efe9a[_0x194009]=_0x28f51a;}}},Scene_Boot[_0xe90fac(0x510)][_0xe90fac(0x9ae)+_0xe90fac(0x1538)+_0xe90fac(0x26e)+_0xe90fac(0x4a8)+'s']=function(){const _0x4e1266=_0xe90fac,_0x11ae0c=$dataSkills[_0x4e1266(0x67c)]($dataItems);for(const _0x972d36 of _0x11ae0c){if(!_0x972d36)continue;VisuMZ[_0x4e1266(0x118f)][_0x4e1266(0x10b3)+'tags_Actio'+'n'](_0x972d36);}},Scene_Boot[_0xe90fac(0x510)][_0xe90fac(0x9ae)+_0xe90fac(0x1538)+_0xe90fac(0x732)+_0xe90fac(0x577)+_0xe90fac(0xa65)]=function(){const _0x376488=_0xe90fac,_0x113198=$dataActors[_0x376488(0x67c)]($dataClasses,$dataWeapons,$dataArmors,$dataEnemies,$dataStates);for(const _0x2feaf1 of _0x113198){if(!_0x2feaf1)continue;VisuMZ['BattleCore']['Parse_Note'+'tags_Trait'+_0x376488(0x528)](_0x2feaf1);}},Scene_Boot[_0xe90fac(0x510)][_0xe90fac(0x9ae)+_0xe90fac(0x1538)+'eCore_Base'+_0xe90fac(0x33f)]=function(){const _0x5d50b0=_0xe90fac,_0x579adf={'xYDPK':function(_0x54f354,_0x43f4bb){return _0x54f354===_0x43f4bb;}},_0x194479=VisuMZ['BattleCore']['Settings'][_0x5d50b0(0x7dd)][_0x5d50b0(0x13d8)+'Ds'],_0x3d929b=[];for(const _0x1fc9f5 of _0x194479){const _0x45a5f0=$dataTroops[_0x1fc9f5];if(_0x45a5f0)_0x3d929b[_0x5d50b0(0x15f1)](JsonEx[_0x5d50b0(0x2f7)+'py'](_0x45a5f0));}for(const _0x2af9e6 of $dataTroops){if(!_0x2af9e6)continue;for(const _0xcf2dd of _0x3d929b){if(_0x579adf[_0x5d50b0(0x13a7)](_0xcf2dd['id'],_0x2af9e6['id']))continue;_0x2af9e6[_0x5d50b0(0x1095)]=_0x2af9e6[_0x5d50b0(0x1095)][_0x5d50b0(0x67c)](_0xcf2dd[_0x5d50b0(0x1095)]);}}},Scene_Boot[_0xe90fac(0x510)][_0xe90fac(0x9ae)+_0xe90fac(0x1538)+'eCore_PreB'+'attleCommo'+_0xe90fac(0x9f7)]=function(){const _0x5e141b=_0xe90fac,_0x4080e2={'cZVvQ':function(_0x36b7e9,_0x52ba79){return _0x36b7e9>_0x52ba79;},'wxCLf':function(_0x1451a0,_0x3913dd){return _0x1451a0-_0x3913dd;},'HQRbv':function(_0x2442ec,_0x44517a){return _0x2442ec!==_0x44517a;}},_0x50253f=VisuMZ['BattleCore'][_0x5e141b(0x281)][_0x5e141b(0x7dd)];if(_0x4080e2['cZVvQ'](_0x50253f[_0x5e141b(0xcfe)+'tEvent'],0x1*0x615+-0x92f*0x3+0x1ca*0xc)&&$dataCommonEvents[_0x50253f[_0x5e141b(0xcfe)+_0x5e141b(0x12d5)]]){const _0x162d9b=$dataCommonEvents[_0x50253f['BattleStar'+_0x5e141b(0x12d5)]],_0x177744=_0x4080e2[_0x5e141b(0xe66)](_0x162d9b[_0x5e141b(0xa83)]['length'],-0x121b*0x1+-0x2551+0x56*0xa5),_0xccddfb=_0x162d9b[_0x5e141b(0xa83)][_0x177744];if(_0xccddfb&&_0x4080e2[_0x5e141b(0xfa)](_0xccddfb[_0x5e141b(0x7ce)],-0x2636+-0x68c+-0x4*-0xb6a)){const _0x15b4e0={'code':0xe6,'indent':0x0,'parameters':[-0x1*-0x1181+0x2498+0x482*-0xc]},_0x46ebba=_0x162d9b[_0x5e141b(0xa83)][_0x5e141b(0x12f5)]();_0x162d9b[_0x5e141b(0xa83)][_0x5e141b(0xf78)](_0x15b4e0),_0x162d9b[_0x5e141b(0xa83)]['unshift'](_0x46ebba);}}},Scene_Boot[_0xe90fac(0x510)][_0xe90fac(0x9ae)+'suMZ_Battl'+_0xe90fac(0x14ec)+'onEventKey'+'s']=function(){const _0x252d30=_0xe90fac;VisuMZ[_0x252d30(0x118f)]['CreateComm'+_0x252d30(0x14f7)+'s'](),VisuMZ['BattleCore']['BindCommon'+_0x252d30(0x47e)+_0x252d30(0x15be)]($dataSkills),VisuMZ['BattleCore'][_0x252d30(0x199)+_0x252d30(0x47e)+_0x252d30(0x15be)]($dataItems);},VisuMZ[_0xe90fac(0x118f)]['CreateComm'+_0xe90fac(0x14f7)+'s']=function(){const _0x12da5e=_0xe90fac,_0x4e7059={'BQVDr':function(_0x940970,_0x47103f){return _0x940970(_0x47103f);}};VisuMZ[_0x12da5e(0x118f)][_0x12da5e(0x1a6)+_0x12da5e(0x133f)]={};for(const _0x501d9d of $dataCommonEvents){if(!_0x501d9d)continue;if(_0x501d9d['name']['match'](/\[(.*)\]/i)){let _0x4c748f=_0x4e7059['BQVDr'](String,RegExp['$1'])[_0x12da5e(0x1144)](/,/g,'')[_0x12da5e(0x1318)+'e']()[_0x12da5e(0x808)]();VisuMZ[_0x12da5e(0x118f)]['_commonEve'+_0x12da5e(0x133f)][_0x4c748f]=_0x501d9d['id'];}}},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x199)+_0xe90fac(0x47e)+_0xe90fac(0x15be)]=function(_0x3ea9a5){const _0x1f8505=_0xe90fac;for(const _0xd0a84e of _0x3ea9a5){if(!_0xd0a84e)continue;VisuMZ[_0x1f8505(0x118f)][_0x1f8505(0x199)+'EventKeysF'+'orObj'](_0xd0a84e);}},VisuMZ[_0xe90fac(0x118f)]['BindCommon'+_0xe90fac(0x47e)+'orObj']=function(_0x259394){const _0x45e1d8=_0xe90fac,_0x2136b1={'gFglJ':function(_0x553604,_0x167668){return _0x553604(_0x167668);},'jgRQy':_0x45e1d8(0x513)+'TION\x20SEQUE'+'NCE>','fVfju':function(_0x5ab981,_0x2a4e9c){return _0x5ab981(_0x2a4e9c);}};if(!_0x259394)return;if(!_0x259394[_0x45e1d8(0x1516)])return;VisuMZ['BattleCore'][_0x45e1d8(0x1a6)+'ntKey']=VisuMZ[_0x45e1d8(0x118f)][_0x45e1d8(0x1a6)+'ntKey']||{};const _0x5157a0=/<COMMON EVENT (?:KEY|KEYS):[ ](.*)>/gi,_0x63e90=/<COMMON EVENT (?:KEY|KEYS)>\s*([\s\S]*)\s*<\/COMMON EVENT (?:KEY|KEYS)>/i;let _0x1a985d=[];const _0x252dc3=_0x259394[_0x45e1d8(0xfee)][_0x45e1d8(0x3eb)](_0x5157a0);if(_0x252dc3){for(const _0xf1e0e4 of _0x252dc3){_0xf1e0e4[_0x45e1d8(0x3eb)](_0x5157a0);const _0x3eb3f1=_0x2136b1['gFglJ'](String,RegExp['$1'])[_0x45e1d8(0xab1)](',')[_0x45e1d8(0x457)](_0x561075=>String(_0x561075)[_0x45e1d8(0x1318)+'e']()[_0x45e1d8(0x808)]());_0x1a985d=_0x1a985d[_0x45e1d8(0x67c)](_0x3eb3f1);}!_0x259394[_0x45e1d8(0xfee)][_0x45e1d8(0x3eb)](/<CUSTOM ACTION SEQUENCE>/i)&&(_0x259394[_0x45e1d8(0xfee)]+=_0x2136b1[_0x45e1d8(0x12df)]);;}if(_0x259394[_0x45e1d8(0xfee)]['match'](_0x63e90)){const _0x35958e=_0x2136b1[_0x45e1d8(0x884)](String,RegExp['$1'])[_0x45e1d8(0xab1)](/[\r\n]+/)[_0x45e1d8(0x457)](_0x56c216=>String(_0x56c216)[_0x45e1d8(0x1318)+'e']()[_0x45e1d8(0x808)]());_0x1a985d=_0x1a985d[_0x45e1d8(0x67c)](_0x35958e);!_0x259394['note'][_0x45e1d8(0x3eb)](/<CUSTOM ACTION SEQUENCE>/i)&&(_0x259394[_0x45e1d8(0xfee)]+=_0x2136b1['jgRQy']);;}for(const _0x357cdd of _0x1a985d){if(VisuMZ['BattleCore'][_0x45e1d8(0x1a6)+_0x45e1d8(0x133f)][_0x357cdd]){const _0x16729d=VisuMZ[_0x45e1d8(0x118f)]['_commonEve'+_0x45e1d8(0x133f)][_0x357cdd],_0x5e6ec7={'code':0x2c,'dataId':_0x16729d,'value1':0x1,'value2':0x0};_0x259394[_0x45e1d8(0x1516)][_0x45e1d8(0x15f1)](_0x5e6ec7);}}},Scene_Boot[_0xe90fac(0x510)]['process_Vi'+_0xe90fac(0x1538)+_0xe90fac(0x14a6)+_0xe90fac(0x8c7)]=function(){const _0xdec441=_0xe90fac,_0x3b463c=$dataSkills[_0xdec441(0x67c)]($dataItems);for(const _0x2dadd3 of _0x3b463c){if(!_0x2dadd3)continue;VisuMZ[_0xdec441(0x118f)][_0xdec441(0x10b3)+_0xdec441(0x431)+'ts'](_0x2dadd3);}},VisuMZ[_0xe90fac(0x118f)]['ParseActor'+_0xe90fac(0xa4e)]=VisuMZ['ParseActor'+_0xe90fac(0xa4e)],VisuMZ[_0xe90fac(0x12c6)+_0xe90fac(0xa4e)]=function(_0xf82fa4){const _0x15971f=_0xe90fac;VisuMZ[_0x15971f(0x118f)][_0x15971f(0x12c6)+_0x15971f(0xa4e)]&&VisuMZ[_0x15971f(0x118f)][_0x15971f(0x12c6)+_0x15971f(0xa4e)][_0x15971f(0x351)](this,_0xf82fa4),VisuMZ[_0x15971f(0x118f)][_0x15971f(0x10b3)+_0x15971f(0x1189)+_0x15971f(0x528)](_0xf82fa4);},VisuMZ[_0xe90fac(0x118f)]['ParseClass'+'Notetags']=VisuMZ['ParseClass'+_0xe90fac(0xa4e)],VisuMZ['ParseClass'+_0xe90fac(0xa4e)]=function(_0x35a9ff){const _0x1a7b3c=_0xe90fac;VisuMZ['BattleCore'][_0x1a7b3c(0x673)+_0x1a7b3c(0xa4e)]&&VisuMZ['BattleCore'][_0x1a7b3c(0x673)+_0x1a7b3c(0xa4e)][_0x1a7b3c(0x351)](this,_0x35a9ff),VisuMZ[_0x1a7b3c(0x118f)][_0x1a7b3c(0x10b3)+_0x1a7b3c(0x1189)+_0x1a7b3c(0x528)](_0x35a9ff);},VisuMZ[_0xe90fac(0x118f)]['ParseSkill'+_0xe90fac(0xa4e)]=VisuMZ[_0xe90fac(0xe09)+'Notetags'],VisuMZ['ParseSkill'+_0xe90fac(0xa4e)]=function(_0x395527){const _0x2ab5c0=_0xe90fac;VisuMZ['BattleCore'][_0x2ab5c0(0xe09)+_0x2ab5c0(0xa4e)]&&VisuMZ[_0x2ab5c0(0x118f)]['ParseSkill'+_0x2ab5c0(0xa4e)]['call'](this,_0x395527),VisuMZ[_0x2ab5c0(0x118f)]['Parse_Note'+_0x2ab5c0(0xb84)+'n'](_0x395527),VisuMZ[_0x2ab5c0(0x118f)][_0x2ab5c0(0x10b3)+'tags_Targe'+'ts'](_0x395527);},VisuMZ[_0xe90fac(0x118f)]['ParseItemN'+'otetags']=VisuMZ[_0xe90fac(0x1181)+_0xe90fac(0x69d)],VisuMZ[_0xe90fac(0x1181)+_0xe90fac(0x69d)]=function(_0x41fbbf){const _0x4dcbf5=_0xe90fac;VisuMZ['BattleCore'][_0x4dcbf5(0x1181)+'otetags']&&VisuMZ[_0x4dcbf5(0x118f)]['ParseItemN'+_0x4dcbf5(0x69d)][_0x4dcbf5(0x351)](this,_0x41fbbf),VisuMZ[_0x4dcbf5(0x118f)][_0x4dcbf5(0x10b3)+'tags_Actio'+'n'](_0x41fbbf),VisuMZ[_0x4dcbf5(0x118f)][_0x4dcbf5(0x10b3)+_0x4dcbf5(0x431)+'ts'](_0x41fbbf);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xa69)+'nNotetags']=VisuMZ[_0xe90fac(0xa69)+_0xe90fac(0x149c)],VisuMZ[_0xe90fac(0xa69)+'nNotetags']=function(_0x2c4de5){const _0x9b6aa4=_0xe90fac;VisuMZ[_0x9b6aa4(0x118f)][_0x9b6aa4(0xa69)+_0x9b6aa4(0x149c)]&&VisuMZ[_0x9b6aa4(0x118f)][_0x9b6aa4(0xa69)+_0x9b6aa4(0x149c)][_0x9b6aa4(0x351)](this,_0x2c4de5),VisuMZ[_0x9b6aa4(0x118f)][_0x9b6aa4(0x10b3)+_0x9b6aa4(0x1189)+_0x9b6aa4(0x528)](_0x2c4de5);},VisuMZ[_0xe90fac(0x118f)]['ParseArmor'+'Notetags']=VisuMZ['ParseArmor'+_0xe90fac(0xa4e)],VisuMZ[_0xe90fac(0x554)+_0xe90fac(0xa4e)]=function(_0x1ab8c2){const _0x3c23e0=_0xe90fac;VisuMZ[_0x3c23e0(0x118f)][_0x3c23e0(0x554)+_0x3c23e0(0xa4e)]&&VisuMZ[_0x3c23e0(0x118f)][_0x3c23e0(0x554)+'Notetags'][_0x3c23e0(0x351)](this,_0x1ab8c2),VisuMZ['BattleCore']['Parse_Note'+'tags_Trait'+_0x3c23e0(0x528)](_0x1ab8c2);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x144e)+_0xe90fac(0xa4e)]=VisuMZ[_0xe90fac(0x144e)+_0xe90fac(0xa4e)],VisuMZ[_0xe90fac(0x144e)+_0xe90fac(0xa4e)]=function(_0x2fc0ac){const _0x1ee3b2=_0xe90fac;VisuMZ[_0x1ee3b2(0x118f)][_0x1ee3b2(0x144e)+_0x1ee3b2(0xa4e)]&&VisuMZ[_0x1ee3b2(0x118f)][_0x1ee3b2(0x144e)+_0x1ee3b2(0xa4e)][_0x1ee3b2(0x351)](this,_0x2fc0ac),VisuMZ[_0x1ee3b2(0x118f)]['Parse_Note'+_0x1ee3b2(0x1189)+'Objects'](_0x2fc0ac);},VisuMZ[_0xe90fac(0x118f)]['ParseState'+'Notetags']=VisuMZ['ParseState'+_0xe90fac(0xa4e)],VisuMZ[_0xe90fac(0x4c9)+_0xe90fac(0xa4e)]=function(_0xe04978){const _0x285a83=_0xe90fac;VisuMZ[_0x285a83(0x118f)]['ParseState'+_0x285a83(0xa4e)]&&VisuMZ[_0x285a83(0x118f)]['ParseState'+_0x285a83(0xa4e)][_0x285a83(0x351)](this,_0xe04978),VisuMZ[_0x285a83(0x118f)][_0x285a83(0x10b3)+_0x285a83(0x1189)+_0x285a83(0x528)](_0xe04978);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x10b3)+_0xe90fac(0xb84)+'n']=function(_0xf42d7b){const _0x5cf764=_0xe90fac,_0x13ffc8={'mlwqF':_0x5cf764(0x522),'AHtdm':'PostApplyJ'+'S','yiqmi':_0x5cf764(0x156a)+'S','OnPbC':_0x5cf764(0x8e5)+'JS','AbNvP':_0x5cf764(0xd81)+_0x5cf764(0x14ff),'bFYrB':_0x5cf764(0xc74)+_0x5cf764(0x6fc),'fQpAG':_0x5cf764(0xdc3)+_0x5cf764(0x1209),'RgKkM':'PostEndAct'+_0x5cf764(0x1146),'NmFHL':function(_0x2fa786,_0x373f8b){return _0x2fa786(_0x373f8b);}},_0x1034c5=[_0x13ffc8[_0x5cf764(0x3b3)],_0x13ffc8['AHtdm'],_0x13ffc8[_0x5cf764(0x135f)],_0x13ffc8['OnPbC'],_0x13ffc8[_0x5cf764(0x13e4)],_0x13ffc8[_0x5cf764(0x973)],_0x13ffc8['fQpAG'],_0x13ffc8[_0x5cf764(0xcc0)]];for(const _0x314244 of _0x1034c5){VisuMZ[_0x5cf764(0x118f)][_0x5cf764(0x1469)](_0xf42d7b,_0x314244);}const _0x513cf1=_0xf42d7b[_0x5cf764(0xfee)];_0x513cf1['match'](/<ALWAYS CRITICAL/i)&&(_0xf42d7b[_0x5cf764(0x11df)]['critical']=!![]),_0x513cf1[_0x5cf764(0x3eb)](/<(?:REPEAT|REPEATS|REPEAT HITS):[ ](\d+)/i)&&(_0xf42d7b[_0x5cf764(0xec3)]=Math['max'](0xfa1+0x1*0x1467+-0x2407,_0x13ffc8[_0x5cf764(0x5ec)](Number,RegExp['$1']))),_0x513cf1[_0x5cf764(0x3eb)](/<TARGET:[ ](.*)>/i)&&(_0xf42d7b[_0x5cf764(0x108c)]=_0x13ffc8[_0x5cf764(0x5ec)](String,RegExp['$1'])[_0x5cf764(0x1318)+'e']()[_0x5cf764(0x808)]());},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x10b3)+_0xe90fac(0x1189)+'Objects']=function(_0x5556e1){const _0x7cde5b=_0xe90fac,_0x276e8a={'NfWpb':_0x7cde5b(0xb8c)+_0x7cde5b(0xec4),'xZCRp':'PostApplyA'+_0x7cde5b(0x4b2),'jPQrl':'PreDamageA'+_0x7cde5b(0x4b2),'iwOxV':'PostDamage'+_0x7cde5b(0x862),'eLCFo':'PreApplyAs'+_0x7cde5b(0x1075),'VaBZJ':_0x7cde5b(0x10af)+_0x7cde5b(0x219),'uiATM':_0x7cde5b(0x636)+'sTargetJS','REUqA':'PostDamage'+_0x7cde5b(0x4f1),'BoFfJ':'PreStartAc'+_0x7cde5b(0x14ff),'sUOBE':'PostStartA'+_0x7cde5b(0x6fc),'rlNWv':_0x7cde5b(0xdc3)+'onJS','QzGnS':_0x7cde5b(0xbd4)+_0x7cde5b(0x1146),'ajSfy':'PreStartBa'+'ttleJS','FoZaH':_0x7cde5b(0x373)+_0x7cde5b(0x1076),'ySXBf':_0x7cde5b(0xed2)+_0x7cde5b(0x1377),'QPaaj':_0x7cde5b(0xc46)+'tleJS','VJiZG':_0x7cde5b(0x818)+_0x7cde5b(0x18b),'sDPFB':_0x7cde5b(0xcb9)+_0x7cde5b(0x160b),'GLxYF':_0x7cde5b(0xe4c)+_0x7cde5b(0xbfa),'cCTTR':_0x7cde5b(0x14ae)+_0x7cde5b(0x115a),'Dzvpr':_0x7cde5b(0xbb4)+'rnJS','XhbCr':'PostStartT'+_0x7cde5b(0xdb8),'PknGt':_0x7cde5b(0x13eb)+'JS','SKggF':_0x7cde5b(0xb08)+'nJS','HPdSt':'PreRegener'+_0x7cde5b(0xa6b),'XrTok':_0x7cde5b(0x69f)+_0x7cde5b(0x207),'txncj':'jsAccuracy','PFItz':_0x7cde5b(0x748)+_0x7cde5b(0xe8d),'VcqpN':_0x7cde5b(0x748)+'AsTarget','dafpZ':_0x7cde5b(0x1060)+_0x7cde5b(0xe8d),'RNvbN':_0x7cde5b(0x1060)+_0x7cde5b(0x711)},_0x4259e0=[_0x276e8a[_0x7cde5b(0x1fc)],_0x276e8a[_0x7cde5b(0xfca)],_0x276e8a[_0x7cde5b(0x8a5)],_0x276e8a['iwOxV'],_0x276e8a[_0x7cde5b(0xf1e)],_0x276e8a['VaBZJ'],_0x276e8a[_0x7cde5b(0x10e7)],_0x276e8a[_0x7cde5b(0x28d)],_0x276e8a[_0x7cde5b(0x5d5)],_0x276e8a[_0x7cde5b(0x4eb)],_0x276e8a['rlNWv'],_0x276e8a[_0x7cde5b(0xfb4)],_0x276e8a[_0x7cde5b(0x32f)],_0x276e8a[_0x7cde5b(0xa57)],_0x276e8a['ySXBf'],_0x276e8a[_0x7cde5b(0xee9)],_0x276e8a[_0x7cde5b(0x151)],_0x276e8a[_0x7cde5b(0xd98)],_0x276e8a['GLxYF'],_0x276e8a[_0x7cde5b(0x15a4)],_0x276e8a[_0x7cde5b(0x14e4)],_0x276e8a[_0x7cde5b(0xa09)],_0x276e8a[_0x7cde5b(0x1499)],_0x276e8a['SKggF'],_0x276e8a[_0x7cde5b(0xfbf)],_0x276e8a[_0x7cde5b(0xf03)]];for(const _0xc58164 of _0x4259e0){VisuMZ[_0x7cde5b(0x118f)]['createJS'](_0x5556e1,_0xc58164);}const _0x14521a=[_0x276e8a['txncj'],_0x276e8a[_0x7cde5b(0xcc8)],_0x276e8a[_0x7cde5b(0x936)],_0x276e8a[_0x7cde5b(0x1537)],_0x276e8a[_0x7cde5b(0x280)]];for(const _0x56765c of _0x14521a){VisuMZ[_0x7cde5b(0x118f)][_0x7cde5b(0x9a8)+'JS'](_0x5556e1,_0x56765c);}},VisuMZ['BattleCore']['Parse_Note'+_0xe90fac(0x431)+'ts']=function(_0x372e95){const _0x3f2f7d=_0xe90fac,_0x1ea587={'iBmqO':function(_0x1056be,_0x10efd4){return _0x1056be(_0x10efd4);},'tQkQk':_0x3f2f7d(0x1027),'gOVIg':function(_0x1bac37,_0x2a1258){return _0x1bac37(_0x2a1258);},'wdaEb':_0x3f2f7d(0x83d)+_0x3f2f7d(0x90a)},_0x3d9964=_0x372e95[_0x3f2f7d(0xfee)];if(_0x3d9964['match'](/<JS TARGETS>\s*([\s\S]*)\s*<\/JS TARGETS>/i)){const _0x1862a9=_0x1ea587['iBmqO'](String,RegExp['$1']),_0x2dccb8=VisuMZ['BattleCore'][_0x3f2f7d(0xc4e)+'S'](_0x372e95,_0x1ea587[_0x3f2f7d(0x62f)]);VisuMZ['BattleCore'][_0x3f2f7d(0x941)+_0x3f2f7d(0x1407)](_0x1862a9,_0x2dccb8);}if(_0x3d9964['match'](/<JS COMMAND (?:VISIBLE|SHOW|HIDE)>\s*([\s\S]*)\s*<\/JS COMMAND (?:VISIBLE|SHOW|HIDE)>/i)){const _0x478555=_0x1ea587[_0x3f2f7d(0xbf2)](String,RegExp['$1']),_0x422a25=VisuMZ[_0x3f2f7d(0x118f)]['createKeyJ'+'S'](_0x372e95,_0x1ea587[_0x3f2f7d(0x111e)]);VisuMZ[_0x3f2f7d(0x118f)][_0x3f2f7d(0x939)+_0x3f2f7d(0x15b1)+'JS'](_0x478555,_0x422a25);}},VisuMZ['BattleCore']['JS']={},VisuMZ['BattleCore'][_0xe90fac(0x1469)]=function(_0x55fdc5,_0x56e4ae){const _0x57eb94=_0xe90fac,_0x322297=_0x55fdc5[_0x57eb94(0xfee)];if(_0x322297['match'](VisuMZ[_0x57eb94(0x118f)]['RegExp'][_0x56e4ae])){const _0x2caaad=RegExp['$1'],_0x143a4d=('\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20'+_0x57eb94(0xe65)+_0x57eb94(0xd34)+'nts\x0a\x20\x20\x20\x20\x20\x20'+_0x57eb94(0xa9e)+_0x57eb94(0x18c)+_0x57eb94(0x6cb)+'];\x0a\x20\x20\x20\x20\x20\x20\x20'+_0x57eb94(0xe79)+_0x57eb94(0xd37)+'arguments['+_0x57eb94(0xc43)+_0x57eb94(0xa9e)+_0x57eb94(0x5c0)+_0x57eb94(0xd04)+';\x0a\x20\x20\x20\x20\x20\x20\x20\x20'+_0x57eb94(0xdf)+_0x57eb94(0x6ea)+'ments[3]\x20|'+_0x57eb94(0x11ab)+_0x57eb94(0x14da)+'\x20originalV'+_0x57eb94(0x1494)+_0x57eb94(0x759)+_0x57eb94(0xa1f)+_0x57eb94(0x1577)+'nstants\x0a\x20\x20'+_0x57eb94(0xaae)+'const\x20acti'+_0x57eb94(0x355)+_0x57eb94(0x71e)+_0x57eb94(0xed)+_0x57eb94(0xc8c)+_0x57eb94(0xd59)+_0x57eb94(0x3d2)+_0x57eb94(0x12cb)+_0x57eb94(0x820)+_0x57eb94(0x703)+_0x57eb94(0xfc1)+_0x57eb94(0xaae)+_0x57eb94(0xe15)+_0x57eb94(0x67d)+_0x57eb94(0xaae)+'\x20const\x20att'+_0x57eb94(0xf38)+_0x57eb94(0x1602)+_0x57eb94(0xa9e)+_0x57eb94(0x13a2)+_0x57eb94(0x1e6)+_0x57eb94(0x820)+_0x57eb94(0x74d)+'ealer\x20=\x20us'+_0x57eb94(0x1602)+_0x57eb94(0xa9e)+_0x57eb94(0xb33)+'\x20=\x20target;'+'\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20'+_0x57eb94(0x703)+'ctor\x20=\x20obj'+_0x57eb94(0x1004)+_0x57eb94(0x100f)+_0x57eb94(0x6b9)+'ss\x20=\x20obj;\x0a'+_0x57eb94(0xaae)+_0x57eb94(0x877)+_0x57eb94(0x2f9)+_0x57eb94(0xb7d)+'tor\x20===\x20Ga'+'me_Action)'+_0x57eb94(0x2d8)+_0x57eb94(0x1573)+_0x57eb94(0x1004)+_0x57eb94(0x100f)+_0x57eb94(0xf27)+'is.constru'+_0x57eb94(0xf0a)+'ame_Action'+_0x57eb94(0x14cd)+'tem()\x20:\x20ob'+_0x57eb94(0x4c0)+_0x57eb94(0xe79)+_0x57eb94(0x9ad)+'obj;\x0a\x20\x20\x20\x20\x20'+_0x57eb94(0xe4d)+'st\x20armor\x20='+'\x20obj;\x0a\x20\x20\x20\x20'+_0x57eb94(0xa54)+'nst\x20enemy\x20'+'=\x20obj;\x0a\x20\x20\x20'+_0x57eb94(0xbe)+_0x57eb94(0xd03)+_0x57eb94(0x155d)+_0x57eb94(0xaae)+_0x57eb94(0xd70)+_0x57eb94(0x932)+_0x57eb94(0x6e0)+_0x57eb94(0x136d)+_0x57eb94(0x14da)+_0x57eb94(0x5db)+_0x57eb94(0xad6)+(_0x57eb94(0x13bd)+_0x57eb94(0x1164)+'.VisuMZ_1_'+'SkillsStat'+_0x57eb94(0xef0)+'$dataState'+_0x57eb94(0x30c)+_0x57eb94(0x340)+_0x57eb94(0xaae)+_0x57eb94(0x12e)+_0x57eb94(0x4b9)+'.getStateO'+'rigin(obj.'+_0x57eb94(0xdc2)+_0x57eb94(0xfdc)+_0x57eb94(0xaae)+_0x57eb94(0x958)+_0x57eb94(0x51b)+_0x57eb94(0xaae)+_0x57eb94(0x76b)+_0x57eb94(0xaae)+_0x57eb94(0x216)+_0x57eb94(0xafb)+'atch\x20(e)\x20{'+_0x57eb94(0x820)+_0x57eb94(0x149e)+_0x57eb94(0x1f1)+_0x57eb94(0xcf5)+_0x57eb94(0x15b)+'le.log(e);'+_0x57eb94(0x820)+_0x57eb94(0x8ea)+_0x57eb94(0x13a3)+_0x57eb94(0x2e7)+_0x57eb94(0x820)+_0x57eb94(0x77a)+_0x57eb94(0x1d0)+_0x57eb94(0x130d)+'\x20\x20\x20\x20\x20\x20\x20\x20if'+'\x20($gameTem'+'p.isPlayte'+_0x57eb94(0x7a9)+_0x57eb94(0xaae)+_0x57eb94(0xa54)+_0x57eb94(0x82e)+_0x57eb94(0x10ef)+_0x57eb94(0xbb1)+'y\x20%2\x27.form'+_0x57eb94(0x77d)+_0x57eb94(0x9c0)+'\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20'+_0x57eb94(0xa54)+_0x57eb94(0x82e)+_0x57eb94(0x41b)+'\x20value\x20to\x20'+_0x57eb94(0x604)+_0x57eb94(0xf52)+_0x57eb94(0x121a)+'\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20'+'\x20\x20\x20\x20\x20\x20\x20}\x0a\x20'+_0x57eb94(0xaae)+_0x57eb94(0x533)+_0x57eb94(0x36e)+_0x57eb94(0x112b)+_0x57eb94(0xaae)+_0x57eb94(0x24d)+_0x57eb94(0xaa)+'turn\x20Value'+_0x57eb94(0x820)+_0x57eb94(0xad8)+_0x57eb94(0x2f2)+'\x20\x20\x20\x20\x20'))[_0x57eb94(0xeb8)](_0x2caaad),_0x3c62b7=VisuMZ[_0x57eb94(0x118f)][_0x57eb94(0xc4e)+'S'](_0x55fdc5,_0x56e4ae);VisuMZ[_0x57eb94(0x118f)]['JS'][_0x3c62b7]=new Function(_0x143a4d);}},VisuMZ['BattleCore'][_0xe90fac(0xc4e)+'S']=function(_0x518a2b,_0x32db3a){const _0x12955d=_0xe90fac,_0x38355a={'EkdLl':_0x12955d(0x45f)+'2','GKQiC':_0x12955d(0x15d2)+'2','vfugf':_0x12955d(0x10ca)+'2','tsisv':_0x12955d(0x13a5),'OpebB':_0x12955d(0xa44)+'%2','Jqyoy':_0x12955d(0x73f)+'2','noFpU':_0x12955d(0x97)+'2','YRCXk':_0x12955d(0xfb3)+'2'};if(VisuMZ[_0x12955d(0xc4e)+'S'])return VisuMZ[_0x12955d(0xc4e)+'S'](_0x518a2b,_0x32db3a);let _0x53a9b2='';if($dataActors[_0x12955d(0x79c)](_0x518a2b))_0x53a9b2=_0x38355a[_0x12955d(0x913)]['format'](_0x518a2b['id'],_0x32db3a);if($dataClasses['includes'](_0x518a2b))_0x53a9b2=_0x38355a[_0x12955d(0xa04)][_0x12955d(0xeb8)](_0x518a2b['id'],_0x32db3a);if($dataSkills['includes'](_0x518a2b))_0x53a9b2=_0x38355a[_0x12955d(0x739)][_0x12955d(0xeb8)](_0x518a2b['id'],_0x32db3a);if($dataItems[_0x12955d(0x79c)](_0x518a2b))_0x53a9b2=_0x38355a[_0x12955d(0x2b4)][_0x12955d(0xeb8)](_0x518a2b['id'],_0x32db3a);if($dataWeapons['includes'](_0x518a2b))_0x53a9b2=_0x38355a['OpebB']['format'](_0x518a2b['id'],_0x32db3a);if($dataArmors[_0x12955d(0x79c)](_0x518a2b))_0x53a9b2=_0x38355a['Jqyoy'][_0x12955d(0xeb8)](_0x518a2b['id'],_0x32db3a);if($dataEnemies[_0x12955d(0x79c)](_0x518a2b))_0x53a9b2=_0x38355a[_0x12955d(0x140d)]['format'](_0x518a2b['id'],_0x32db3a);if($dataStates['includes'](_0x518a2b))_0x53a9b2=_0x38355a[_0x12955d(0x1279)][_0x12955d(0xeb8)](_0x518a2b['id'],_0x32db3a);return _0x53a9b2;},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x941)+'etsJS']=function(_0x3f5ec2,_0x294f6c){const _0x1d5e75=_0xe90fac,_0x558717=('\x0a\x20\x20\x20\x20\x20\x20\x20\x20/'+_0x1d5e75(0x1078)+_0x1d5e75(0x118a)+_0x1d5e75(0xa54)+'nst\x20user\x20='+'\x20arguments'+'[0];\x0a\x20\x20\x20\x20\x20'+_0x1d5e75(0x703)+'\x20=\x20user;\x0a\x20'+_0x1d5e75(0xe4d)+_0x1d5e75(0xa89)+_0x1d5e75(0xa86)+_0x1d5e75(0x484)+'ts\x20=\x20argum'+'ents[1];\x0a\x0a'+_0x1d5e75(0x13a3)+_0x1d5e75(0xeda)+_0x1d5e75(0xce9)+_0x1d5e75(0x1e3)+_0x1d5e75(0xaae)+'%1\x0a\x20\x20\x20\x20\x20\x20\x20'+_0x1d5e75(0x45b)+_0x1d5e75(0x12bb)+_0x1d5e75(0x149e)+_0x1d5e75(0x1f1)+_0x1d5e75(0xcf5)+'t())\x20conso'+'le.log(e);'+_0x1d5e75(0x16e)+'\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20'+'//\x20Return\x20'+_0x1d5e75(0x48a)+_0x1d5e75(0x15cb)+_0x1d5e75(0x499)+_0x1d5e75(0x791))[_0x1d5e75(0xeb8)](_0x3f5ec2);VisuMZ[_0x1d5e75(0x118f)]['JS'][_0x294f6c]=new Function(_0x558717);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x939)+_0xe90fac(0x15b1)+'JS']=function(_0x287490,_0x4f1eef){const _0xb13385=_0xe90fac,_0x41ba05=(_0xb13385(0x4ba)+_0xb13385(0x1078)+_0xb13385(0x118a)+_0xb13385(0xa54)+_0xb13385(0xa84)+_0xb13385(0xb12)+'[0];\x0a\x20\x20\x20\x20\x20'+_0xb13385(0x99)+'kill\x20=\x20arg'+_0xb13385(0x12e1)+_0xb13385(0x8cc)+_0xb13385(0xd4c)+_0xb13385(0x3fc)+_0xb13385(0x2c5)+_0xb13385(0xfc1)+_0xb13385(0x14da)+_0xb13385(0x217)+'\x20true;\x0a\x0a\x20\x20'+_0xb13385(0x144f)+_0xb13385(0xc9f)+_0xb13385(0x5e4)+_0xb13385(0x76b)+'\x20\x20\x20\x20\x20\x20\x20\x20%1'+_0xb13385(0x16e)+_0xb13385(0x526)+_0xb13385(0x272)+_0xb13385(0x11c1)+_0xb13385(0x14f0)+_0xb13385(0xe03)+_0xb13385(0xcde)+_0xb13385(0x86)+_0xb13385(0xfdc)+_0xb13385(0x13a3)+_0xb13385(0x15d4)+_0xb13385(0x483)+'\x20\x20return\x20v'+_0xb13385(0xb9b)+'\x20\x20')[_0xb13385(0xeb8)](_0x287490);VisuMZ[_0xb13385(0x118f)]['JS'][_0x4f1eef]=new Function(_0x41ba05);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x9a8)+'JS']=function(_0x4b938a,_0x5751d7){const _0xb7d85b=_0xe90fac,_0x4b344d=_0x4b938a[_0xb7d85b(0xfee)];if(_0x4b344d[_0xb7d85b(0x3eb)](VisuMZ[_0xb7d85b(0x118f)]['RegExp'][_0x5751d7])){const _0x52033a=RegExp['$1'],_0xd23732=(_0xb7d85b(0x820)+_0xb7d85b(0xe65)+_0xb7d85b(0xd34)+_0xb7d85b(0x394)+_0xb7d85b(0xa9e)+_0xb7d85b(0x18c)+'rguments[0'+_0xb7d85b(0x6db)+_0xb7d85b(0xe79)+_0xb7d85b(0xd37)+_0xb7d85b(0x6d0)+_0xb7d85b(0xc43)+_0xb7d85b(0xa9e)+_0xb7d85b(0x5c0)+_0xb7d85b(0xd04)+_0xb7d85b(0x1004)+_0xb7d85b(0xba2)+'te\x20=\x20argum'+'ents[3]\x20||'+_0xb7d85b(0x63e)+_0xb7d85b(0x1431)+_0xb7d85b(0x1401)+_0xb7d85b(0x3ea)+_0xb7d85b(0xd6f)+_0xb7d85b(0x3ef)+_0xb7d85b(0x12a1)+_0xb7d85b(0x1578)+_0xb7d85b(0xe4d)+_0xb7d85b(0x1252)+_0xb7d85b(0x1100)+_0xb7d85b(0x1030)+_0xb7d85b(0x133b)+_0xb7d85b(0x1519)+_0xb7d85b(0x29d)+_0xb7d85b(0x14a4)+'tion();\x0a\x20\x20'+_0xb7d85b(0xaae)+_0xb7d85b(0x1309)+_0xb7d85b(0xad6)+'\x20\x20\x20\x20\x20\x20\x20\x20co'+_0xb7d85b(0xbe8)+_0xb7d85b(0x12de)+_0xb7d85b(0xa54)+_0xb7d85b(0x141f)+'er\x20=\x20user;'+_0xb7d85b(0x820)+_0xb7d85b(0xc92)+_0xb7d85b(0xf1a)+_0xb7d85b(0x5dd)+'\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20'+_0xb7d85b(0x107)+_0xb7d85b(0x14a1)+_0xb7d85b(0x820)+_0xb7d85b(0x6e4)+_0xb7d85b(0x15d1)+_0xb7d85b(0x5dd)+'\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20'+'const\x20acto'+_0xb7d85b(0x491)+'\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20'+_0xb7d85b(0x720)+'rentClass\x20'+'=\x20obj;\x0a\x20\x20\x20'+'\x20\x20\x20\x20\x20\x20\x20\x20\x20c'+_0xb7d85b(0x13ef)+_0xb7d85b(0xa3e)+_0xb7d85b(0x398)+_0xb7d85b(0x1204)+_0xb7d85b(0x1292)+_0xb7d85b(0x1113)+')\x20:\x20obj;\x0a\x20'+_0xb7d85b(0xaae)+_0xb7d85b(0xd3a)+'m\x20=\x20(this.'+'constructo'+_0xb7d85b(0xca2)+_0xb7d85b(0x13ee)+_0xb7d85b(0x11f3)+_0xb7d85b(0x13db)+'\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20'+_0xb7d85b(0x591)+'apon\x20=\x20obj'+';\x0a\x20\x20\x20\x20\x20\x20\x20\x20'+_0xb7d85b(0x100f)+_0xb7d85b(0x451)+_0xb7d85b(0x4c0)+_0xb7d85b(0xe79)+_0xb7d85b(0xfc0)+'bj;\x0a\x20\x20\x20\x20\x20\x20'+_0xb7d85b(0xa9e)+_0xb7d85b(0x285)+_0xb7d85b(0xb39)+_0xb7d85b(0x13a3)+_0xb7d85b(0x1427)+_0xb7d85b(0x15d3)+_0xb7d85b(0x10cc)+_0xb7d85b(0xad2)+_0xb7d85b(0xc5)+_0xb7d85b(0xd2d)+_0xb7d85b(0xa86)+(_0xb7d85b(0xcdd)+_0xb7d85b(0x1596)+_0xb7d85b(0x5f8)+'llsStatesC'+_0xb7d85b(0x7bb)+_0xb7d85b(0xe8a)+_0xb7d85b(0x37c)+_0xb7d85b(0x1266)+_0xb7d85b(0xaae)+_0xb7d85b(0xecf)+_0xb7d85b(0x1011)+_0xb7d85b(0x152e)+'in(obj.id)'+_0xb7d85b(0x1004)+_0xb7d85b(0xdec)+_0xb7d85b(0xeb0)+_0xb7d85b(0x3ee)+_0xb7d85b(0x2d3)+_0xb7d85b(0x1c6)+_0xb7d85b(0x272)+_0xb7d85b(0x1435)+'1\x0a\x20\x20\x20\x20\x20\x20\x20\x20'+_0xb7d85b(0xa8d)+_0xb7d85b(0x641)+_0xb7d85b(0xaae)+_0xb7d85b(0x11a6)+_0xb7d85b(0x6eb)+_0xb7d85b(0x2e1)+_0xb7d85b(0x1142)+_0xb7d85b(0xa80)+_0xb7d85b(0xaae)+_0xb7d85b(0x24d)+'\x20\x20\x20\x20\x20//\x20Na'+_0xb7d85b(0x108)+_0xb7d85b(0xaae)+_0xb7d85b(0x1133)+_0xb7d85b(0x7b3)+_0xb7d85b(0xaae)+_0xb7d85b(0x11a6)+'ameTemp.is'+_0xb7d85b(0x2e1)+_0xb7d85b(0x286)+_0xb7d85b(0xaae)+'\x20\x20\x20\x20consol'+'e.log(\x27NaN'+_0xb7d85b(0xd4)+_0xb7d85b(0x25a)+_0xb7d85b(0xf6c)+_0xb7d85b(0xe2)+_0xb7d85b(0x885)+_0xb7d85b(0xaae)+_0xb7d85b(0x990)+_0xb7d85b(0xffa)+_0xb7d85b(0x3fe)+_0xb7d85b(0x1352)+'rmat(\x27\x27,or'+_0xb7d85b(0x1410)+_0xb7d85b(0xbfd)+_0xb7d85b(0xaae)+_0xb7d85b(0x1fa)+_0xb7d85b(0x58f)+_0xb7d85b(0x14f3)+'inalRate;\x0a'+_0xb7d85b(0xaae)+'\x20\x20}\x0a\x0a\x20\x20\x20\x20\x20'+_0xb7d85b(0xa1f)+_0xb7d85b(0x157c)+_0xb7d85b(0x5e4)+_0xb7d85b(0x15cb)+_0xb7d85b(0xf80)+_0xb7d85b(0x10ed)))[_0xb7d85b(0xeb8)](_0x52033a),_0x505640=VisuMZ[_0xb7d85b(0x118f)][_0xb7d85b(0xc4e)+'S'](_0x4b938a,_0x5751d7);VisuMZ[_0xb7d85b(0x118f)]['JS'][_0x505640]=new Function(_0xd23732);}},TextManager[_0xe90fac(0xfa2)]=VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x281)][_0xe90fac(0x1463)][_0xe90fac(0xc71)+_0xe90fac(0x912)],TextManager[_0xe90fac(0xfa2)+_0xe90fac(0x854)]=VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x281)][_0xe90fac(0x33a)][_0xe90fac(0x5bb)],TextManager['autoBattle'+_0xe90fac(0x10f9)]=VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x281)][_0xe90fac(0x33a)]['StyleName'],TextManager['visualHpGa'+'uge']=VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x281)]['HpGauge'][_0xe90fac(0xbf5)],ColorManager[_0xe90fac(0x15c0)]=function(_0x47f2e7){const _0x42f597=_0xe90fac,_0x57c79c={'gFLPB':function(_0x861da0,_0xb3d170){return _0x861da0(_0xb3d170);},'wpcyG':_0x42f597(0xba1),'pwusg':function(_0x4c3bc0,_0x459ffe){return _0x4c3bc0(_0x459ffe);},'qROgy':function(_0x5de86f,_0x4c372b){return _0x5de86f(_0x4c372b);}};return _0x47f2e7=_0x57c79c[_0x42f597(0x70f)](String,_0x47f2e7),_0x47f2e7['match'](/#(.*)/i)?_0x57c79c['wpcyG'][_0x42f597(0xeb8)](_0x57c79c[_0x42f597(0x7e1)](String,RegExp['$1'])):this[_0x42f597(0x5a9)](_0x57c79c['qROgy'](Number,_0x47f2e7));},DataManager[_0xe90fac(0x2d0)+_0xe90fac(0x951)]=function(_0xfe0cc0){const _0x3e4e6c=_0xe90fac,_0x165cf9={'TGuGx':function(_0x1480f8,_0x1256e4){return _0x1480f8(_0x1256e4);},'DQtfw':function(_0x387efc,_0x73288d){return _0x387efc===_0x73288d;},'ORsfJ':_0x3e4e6c(0x152b)};if(_0xfe0cc0[_0x3e4e6c(0xfee)][_0x3e4e6c(0x3eb)](/<DAMAGE STYLE:[ ](.*)>/i)){const _0x536059=_0x165cf9['TGuGx'](String,RegExp['$1'])[_0x3e4e6c(0x1318)+'e']()[_0x3e4e6c(0x808)]();if(_0x165cf9[_0x3e4e6c(0x88e)](_0x536059,_0x165cf9[_0x3e4e6c(0x86b)]))return _0x165cf9[_0x3e4e6c(0x86b)];if(VisuMZ[_0x3e4e6c(0x13f9)+'es'][_0x536059])return _0x536059;}const _0x233394=VisuMZ[_0x3e4e6c(0x118f)][_0x3e4e6c(0x281)]['Damage'][_0x3e4e6c(0x15b5)+'ageStyle'][_0x3e4e6c(0x1318)+'e']()[_0x3e4e6c(0x808)]();if(VisuMZ[_0x3e4e6c(0x13f9)+'es'][_0x233394])return _0x233394;return _0x165cf9[_0x3e4e6c(0x86b)];},DataManager[_0xe90fac(0xb0c)+_0xe90fac(0xdd9)]=function(_0xac3e77){const _0x1501bd=_0xe90fac,_0xec8401={'SjeVz':function(_0x1d50f4,_0x10282e){return _0x1d50f4<_0x10282e;}};_0xac3e77=_0xac3e77[_0x1501bd(0x1318)+'e']()[_0x1501bd(0x808)](),this[_0x1501bd(0x27b)]=this[_0x1501bd(0x27b)]||{};if(this[_0x1501bd(0x27b)][_0xac3e77])return this['_stypeIDs'][_0xac3e77];for(let _0x149025=0x17*0x50+0x5*-0x627+0x1794;_0xec8401['SjeVz'](_0x149025,0x1*-0xd88+0x170*0x3+0x29*0x3c);_0x149025++){if(!$dataSystem['skillTypes'][_0x149025])continue;let _0x5e7498=$dataSystem[_0x1501bd(0x10bb)][_0x149025][_0x1501bd(0x1318)+'e']()[_0x1501bd(0x808)]();_0x5e7498=_0x5e7498[_0x1501bd(0x1144)](/\x1I\[(\d+)\]/gi,''),_0x5e7498=_0x5e7498['replace'](/\\I\[(\d+)\]/gi,''),this[_0x1501bd(0x27b)][_0x5e7498]=_0x149025;}return this[_0x1501bd(0x27b)][_0xac3e77]||-0x14d2+-0xc3b+0x210d;},DataManager[_0xe90fac(0x5b5)+'WithName']=function(_0x595be4){const _0x15feca=_0xe90fac;_0x595be4=_0x595be4['toUpperCas'+'e']()[_0x15feca(0x808)](),this[_0x15feca(0x1057)]=this[_0x15feca(0x1057)]||{};if(this[_0x15feca(0x1057)][_0x595be4])return this[_0x15feca(0x1057)][_0x595be4];for(const _0x4e9c6a of $dataSkills){if(!_0x4e9c6a)continue;this[_0x15feca(0x1057)][_0x4e9c6a[_0x15feca(0x14c)][_0x15feca(0x1318)+'e']()['trim']()]=_0x4e9c6a['id'];}return this['_skillIDs'][_0x595be4]||-0x869+-0x5*0x253+0x4*0x502;},DataManager[_0xe90fac(0x85e)+_0xe90fac(0xdd9)]=function(_0x59b1e0){const _0x223622=_0xe90fac;_0x59b1e0=_0x59b1e0[_0x223622(0x1318)+'e']()[_0x223622(0x808)](),this['_enemyIDs']=this[_0x223622(0x49c)]||{};if(this['_enemyIDs'][_0x59b1e0])return this[_0x223622(0x49c)][_0x59b1e0];for(const _0x4b5d32 of $dataEnemies){if(!_0x4b5d32)continue;this[_0x223622(0x49c)][_0x4b5d32[_0x223622(0x14c)]['toUpperCas'+'e']()['trim']()]=_0x4b5d32['id'];}return this[_0x223622(0x49c)][_0x59b1e0]||-0x664*0x3+0x9a5*-0x1+0x1cd1;},DataManager[_0xe90fac(0x922)+_0xe90fac(0xdd9)]=function(_0x2e37eb){const _0x331768=_0xe90fac,_0x20c645={'ROwNm':function(_0x3cde45,_0x3d5071){return _0x3cde45<_0x3d5071;},'MLDyQ':_0x331768(0x13e2)};_0x2e37eb=_0x2e37eb['toUpperCas'+'e']()[_0x331768(0x808)](),this[_0x331768(0x12b6)]=this['_wtypeIDs']||{};if(this['_wtypeIDs'][_0x2e37eb])return this[_0x331768(0x12b6)][_0x2e37eb];for(let _0x74ab8b=-0x1cba+-0xdec+0x3d*0xb3;_0x20c645[_0x331768(0x5d6)](_0x74ab8b,-0x1eab+0x20d7*-0x1+0x3fe6);_0x74ab8b++){if(!$dataSystem['weaponType'+'s'][_0x74ab8b])continue;let _0x535b18=$dataSystem['weaponType'+'s'][_0x74ab8b]['toUpperCas'+'e']()[_0x331768(0x808)]();_0x535b18=_0x535b18[_0x331768(0x1144)](/\x1I\[(\d+)\]/gi,''),_0x535b18=_0x535b18[_0x331768(0x1144)](/\\I\[(\d+)\]/gi,''),this[_0x331768(0x12b6)][_0x535b18]=_0x74ab8b;}return this[_0x331768(0x12b6)][_0x20c645[_0x331768(0x27e)]]=0x26aa+-0x5*0x60a+-0x878,this[_0x331768(0x12b6)][_0x2e37eb]||0x21f+-0x1*-0x20c3+0x5e*-0x5f;},DataManager[_0xe90fac(0x694)+_0xe90fac(0xb2e)]=function(_0x1609de){const _0x2c7c9e=_0xe90fac,_0x37fa70={'lcDdP':_0x2c7c9e(0x768),'nQsYB':function(_0x1bfda8,_0x348260){return _0x1bfda8(_0x348260);}},_0x2c23c7=_0x37fa70[_0x2c7c9e(0x996)];let _0x4e43a3=_0x1609de[_0x2c7c9e(0x5e1)],_0xb6f00e=_0x1609de['name'];const _0x22b804=_0x1609de[_0x2c7c9e(0xfee)];return _0x22b804[_0x2c7c9e(0x3eb)](/<DISPLAY ICON: (\d+)>/i)&&(_0x4e43a3=_0x37fa70[_0x2c7c9e(0xb0)](Number,RegExp['$1'])),_0x22b804[_0x2c7c9e(0x3eb)](/<DISPLAY TEXT: (.*)>/i)&&(_0xb6f00e=_0x37fa70[_0x2c7c9e(0xb0)](String,RegExp['$1'])),_0x2c23c7[_0x2c7c9e(0xeb8)](_0x4e43a3,_0xb6f00e);},DataManager[_0xe90fac(0x750)+_0xe90fac(0x967)]=function(_0x1425e5){const _0x13dc3f=_0xe90fac,_0x23ac6f={'XtXGU':function(_0x5d2620,_0x200e74){return _0x5d2620(_0x200e74);}};return _0x1425e5[_0x13dc3f(0xfee)][_0x13dc3f(0x3eb)](/<COMMAND TEXT: (.*)>/i)?_0x23ac6f['XtXGU'](String,RegExp['$1']):_0x1425e5[_0x13dc3f(0x14c)];},DataManager[_0xe90fac(0x750)+_0xe90fac(0x14d9)]=function(_0x36f494){const _0x2bdafd=_0xe90fac,_0x23dae2={'ptAkQ':function(_0x4ecf92,_0x5b543c){return _0x4ecf92(_0x5b543c);}};return _0x36f494['note'][_0x2bdafd(0x3eb)](/<COMMAND ICON: (\d+)>/i)?_0x23dae2[_0x2bdafd(0x767)](Number,RegExp['$1']):_0x36f494['iconIndex'];},DataManager[_0xe90fac(0xdd2)+'Ds']=function(_0x2f2e61){const _0x2c58b9=_0xe90fac,_0x15257d={'BSWgF':function(_0x45f42f,_0x40b9ea){return _0x45f42f(_0x40b9ea);}},_0x3ac16c=$dataEnemies[_0x2f2e61];if(_0x3ac16c){if(_0x3ac16c['note'][_0x2c58b9(0x3eb)](/<SWAP ENEMIES>\s*([\s\S]*)\s*<\/SWAP ENEMIES>/i)){const _0x52a8f1=_0x15257d[_0x2c58b9(0x271)](String,RegExp['$1'])['split'](/[\r\n]+/)['remove'](''),_0x3f6629=this[_0x2c58b9(0x13c8)+'domizedDat'+'a'](_0x52a8f1);_0x2f2e61=this['getEnemyId'+_0x2c58b9(0xdd9)](_0x3f6629)||_0x2f2e61,_0x2f2e61=DataManager[_0x2c58b9(0xdd2)+'Ds'](_0x2f2e61);}}return _0x2f2e61;},DataManager[_0xe90fac(0x13c8)+_0xe90fac(0x813)+'a']=function(_0x581f34){const _0x3f040e=_0xe90fac,_0x38285f={'ezkBe':function(_0x425886,_0x7476f1){return _0x425886(_0x7476f1);},'iVhhZ':function(_0x5e6f0e,_0x17cc04){return _0x5e6f0e(_0x17cc04);},'ueSNb':function(_0xdfdbc,_0x314804){return _0xdfdbc(_0x314804);},'cXasf':function(_0x2b95fb,_0x45bfd4){return _0x2b95fb!==_0x45bfd4;},'VdWyt':function(_0x444eaa,_0x1d0627){return _0x444eaa<=_0x1d0627;},'VlPYv':function(_0x114b69,_0x562288){return _0x114b69*_0x562288;},'AlTFM':function(_0x26f9a4,_0x575ba5){return _0x26f9a4<=_0x575ba5;}};let _0x3c4762=0x977*-0x1+-0x1*-0x6e9+0x3*0xda;const _0x400f4f={};for(const _0x20e6d9 of _0x581f34){if(_0x20e6d9[_0x3f040e(0x3eb)](/(.*):[ ](\d+)/i)){const _0x2cc97a=_0x38285f[_0x3f040e(0xa0d)](String,RegExp['$1'])[_0x3f040e(0x808)](),_0x12f9fe=_0x38285f[_0x3f040e(0xa0d)](Number,RegExp['$2']);_0x400f4f[_0x2cc97a]=_0x12f9fe,_0x3c4762+=_0x12f9fe;}else{if(_0x20e6d9[_0x3f040e(0x3eb)](/(.*):[ ](\d+\.?\d+)/i)){const _0x293d5f=_0x38285f['iVhhZ'](String,RegExp['$1'])[_0x3f040e(0x808)](),_0x58abe2=_0x38285f[_0x3f040e(0xb4d)](Number,RegExp['$2']);_0x400f4f[_0x293d5f]=_0x58abe2,_0x3c4762+=_0x58abe2;}else _0x38285f[_0x3f040e(0x878)](_0x20e6d9,'')&&(_0x400f4f[_0x20e6d9]=-0x2*0x2c5+-0x4f4*0x7+0x2837,_0x3c4762++);}}if(_0x38285f[_0x3f040e(0xac)](_0x3c4762,-0x1*-0x377+-0x13de+-0xf7*-0x11))return'';let _0x252930=_0x38285f[_0x3f040e(0x839)](Math[_0x3f040e(0x9c3)](),_0x3c4762);for(const _0x6aa328 in _0x400f4f){_0x252930-=_0x400f4f[_0x6aa328];if(_0x38285f[_0x3f040e(0xbee)](_0x252930,0x2155+-0x20fe+0x1*-0x57))return _0x6aa328;}return'';},DataManager[_0xe90fac(0x525)+_0xe90fac(0x192)+_0xe90fac(0x5a6)+_0xe90fac(0x1117)+'ct']=function(_0xecc81b){const _0x28cf64=_0xe90fac,_0x59c476={'htHXi':function(_0xe5cd4c,_0x2fa7df){return _0xe5cd4c===_0x2fa7df;}};if(!_0xecc81b)return![];if(!VisuMZ[_0x28cf64(0x118f)][_0x28cf64(0x281)][_0x28cf64(0xdd1)+_0x28cf64(0x16a)][_0x28cf64(0xa30)+'g'])return![];if(_0xecc81b[_0x28cf64(0xfee)][_0x28cf64(0x3eb)](/<AUTO ACTION SEQUENCE>/i))return![];if(_0xecc81b[_0x28cf64(0xfee)][_0x28cf64(0x3eb)](/<COMMON (?:EVENT|EVENTS):[ ](.*)>/gi))return!![];for(const _0x223560 of _0xecc81b[_0x28cf64(0x1516)]){if(!_0x223560)continue;if(_0x59c476[_0x28cf64(0x141b)](_0x223560[_0x28cf64(0x7ce)],Game_Action[_0x28cf64(0x78d)+_0x28cf64(0xdcd)]))return!![];}return![];},DataManager[_0xe90fac(0xe23)+'pNote']=function(_0x16a0ec){const _0x3fefe5=_0xe90fac,_0x537c7d=$dataTroops[_0x16a0ec];if(!_0x537c7d)return'';let _0x52c1c6='';_0x52c1c6+=_0x537c7d['name'];for(const _0x2f3a95 of _0x537c7d['pages']){for(const _0x518528 of _0x2f3a95[_0x3fefe5(0xa83)]){[0xd*0x17d+-0x2a*0x4e+-0x1*0x621,-0x151*-0x17+0x6*0x407+0xa3*-0x53][_0x3fefe5(0x79c)](_0x518528[_0x3fefe5(0x7ce)])&&(_0x52c1c6+='\x0a',_0x52c1c6+=_0x518528[_0x3fefe5(0x115b)][-0x1f*-0x36+-0x10d*-0x1+-0x797]);}}return _0x52c1c6;},ConfigManager[_0xe90fac(0xfa2)+'AtStart']=ConfigManager[_0xe90fac(0xfa2)+'AtStart']??![],ConfigManager[_0xe90fac(0xfa2)+_0xe90fac(0x1b1)]=ConfigManager[_0xe90fac(0xfa2)+'UseSkills']??![],ConfigManager[_0xe90fac(0x503)+_0xe90fac(0x9dc)]=ConfigManager[_0xe90fac(0x503)+_0xe90fac(0x9dc)]??!![],VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xf6b)+_0xe90fac(0x13c7)+'ta']=ConfigManager[_0xe90fac(0xf7f)],ConfigManager[_0xe90fac(0xf7f)]=function(){const _0xb5ae90=_0xe90fac,_0x554416=VisuMZ[_0xb5ae90(0x118f)][_0xb5ae90(0xf6b)+_0xb5ae90(0x13c7)+'ta']['call'](this);return _0x554416['autoBattle'+_0xb5ae90(0x9fe)]=this[_0xb5ae90(0xfa2)+_0xb5ae90(0x9fe)],_0x554416['autoBattle'+_0xb5ae90(0x1b1)]=this[_0xb5ae90(0xfa2)+_0xb5ae90(0x1b1)],_0x554416['visualHpGa'+_0xb5ae90(0x9dc)]=this[_0xb5ae90(0x503)+_0xb5ae90(0x9dc)],_0x554416;},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xf6b)+_0xe90fac(0x8af)+'ata']=ConfigManager['applyData'],ConfigManager[_0xe90fac(0x1364)]=function(_0xb85226){const _0xa8f2c5=_0xe90fac,_0x6a933f={'kMpER':function(_0x572f5a,_0x4c5ca0){return _0x572f5a in _0x4c5ca0;},'elGUY':_0xa8f2c5(0xfa2)+_0xa8f2c5(0x9fe),'qAKVX':function(_0x44233b,_0x3fbd2c){return _0x44233b in _0x3fbd2c;},'unZkF':_0xa8f2c5(0xfa2)+_0xa8f2c5(0x1b1),'hTYit':function(_0x5a3f66,_0x4d9e1e){return _0x5a3f66 in _0x4d9e1e;},'RCJJc':_0xa8f2c5(0x503)+_0xa8f2c5(0x9dc)};VisuMZ[_0xa8f2c5(0x118f)][_0xa8f2c5(0xf6b)+_0xa8f2c5(0x8af)+_0xa8f2c5(0xdcc)][_0xa8f2c5(0x351)](this,_0xb85226),_0x6a933f[_0xa8f2c5(0x140b)](_0x6a933f[_0xa8f2c5(0xf39)],_0xb85226)?this[_0xa8f2c5(0xfa2)+_0xa8f2c5(0x9fe)]=_0xb85226[_0x6a933f[_0xa8f2c5(0xf39)]]:this[_0xa8f2c5(0xfa2)+_0xa8f2c5(0x9fe)]=![],_0x6a933f[_0xa8f2c5(0x1329)](_0x6a933f[_0xa8f2c5(0x12d4)],_0xb85226)?this[_0xa8f2c5(0xfa2)+_0xa8f2c5(0x1b1)]=_0xb85226[_0x6a933f['unZkF']]:this['autoBattle'+'UseSkills']=![],_0x6a933f[_0xa8f2c5(0x13e6)](_0x6a933f[_0xa8f2c5(0x2ae)],_0xb85226)?this['visualHpGa'+_0xa8f2c5(0x9dc)]=_0xb85226[_0x6a933f['RCJJc']]:this[_0xa8f2c5(0x503)+_0xa8f2c5(0x9dc)]=!![];},ImageManager[_0xe90fac(0x12f1)+_0xe90fac(0x588)]=ImageManager[_0xe90fac(0x12f1)+_0xe90fac(0x588)]||-0xeba+0x2c5*0xb+0x4*-0x3ed,ImageManager[_0xe90fac(0xd27)+_0xe90fac(0x494)]=ImageManager['svActorVer'+_0xe90fac(0x494)]||0x2405+-0xf6b+0x2*-0xa4a,VisuMZ['BattleCore'][_0xe90fac(0xb54)+_0xe90fac(0xd00)]=BattleManager['setup'],BattleManager[_0xe90fac(0xc70)]=function(_0x39dad6,_0x5606f9,_0x47ff28){const _0x2e9262=_0xe90fac;VisuMZ[_0x2e9262(0x118f)][_0x2e9262(0xb54)+_0x2e9262(0xd00)][_0x2e9262(0x351)](this,_0x39dad6,_0x5606f9,_0x47ff28),this[_0x2e9262(0xa67)+_0x2e9262(0x55e)]={};},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xb54)+'ger_initMe'+'mbers']=BattleManager[_0xe90fac(0x11d5)+'s'],BattleManager[_0xe90fac(0x11d5)+'s']=function(){const _0x8f7870=_0xe90fac;VisuMZ[_0x8f7870(0x118f)]['BattleMana'+_0x8f7870(0xd65)+_0x8f7870(0x2d2)][_0x8f7870(0x351)](this),this[_0x8f7870(0x1588)+_0x8f7870(0x15ac)]=[];},BattleManager[_0xe90fac(0x9a4)+_0xe90fac(0x118c)]=function(){const _0x165327=_0xe90fac;if(!SceneManager[_0x165327(0x11be)+'tle']())return;const _0x4648a3=SceneManager[_0x165327(0x11dd)][_0x165327(0xbed)+'dow'];if(_0x4648a3)_0x4648a3[_0x165327(0x12cf)+'resh']();},BattleManager[_0xe90fac(0x8c5)]=function(){const _0x1d289b=_0xe90fac,_0x279490={'xlCQS':'TPB','ZBddt':'DTB'};if(BattleManager[_0x1d289b(0x537)]())return _0x279490[_0x1d289b(0xd17)];return _0x279490[_0x1d289b(0x111)];},BattleManager['isBattleSy'+'s']=function(_0x57e1e4){const _0x42ef8e=_0xe90fac,_0x5cea4f={'EKGSY':function(_0x346eeb,_0x432483){return _0x346eeb===_0x432483;}};return _0x57e1e4=_0x57e1e4[_0x42ef8e(0x1318)+'e']()[_0x42ef8e(0x808)](),_0x5cea4f[_0x42ef8e(0x99d)](this[_0x42ef8e(0x8c5)](),_0x57e1e4);},BattleManager['isDTB']=function(){const _0x4cacf3=_0xe90fac,_0x580dbe={'PnVBm':_0x4cacf3(0x6dc)};return this[_0x4cacf3(0xbe9)+'s'](_0x580dbe[_0x4cacf3(0x7aa)]);},BattleManager[_0xe90fac(0x1446)+'d']=function(){const _0x5042d5=_0xe90fac;return this[_0x5042d5(0x872)]();},BattleManager[_0xe90fac(0x42c)+'d']=function(){const _0xdc7ca5=_0xe90fac;return!this[_0xdc7ca5(0x1446)+'d']();},BattleManager[_0xe90fac(0x148a)+'d']=function(){const _0x1d4e87=_0xe90fac;return!this[_0x1d4e87(0x1446)+'d']()&&!this[_0x1d4e87(0x42c)+'d']();},BattleManager[_0xe90fac(0xde)+_0xe90fac(0x94c)]=function(_0xa432d5){const _0x46b382=_0xe90fac,_0x17c713={'SqYNc':function(_0x54b59a,_0x53833d){return _0x54b59a!==_0x53833d;}};this['_battlerKe'+_0x46b382(0x55e)]=this[_0x46b382(0xa67)+_0x46b382(0x55e)]||{};if(_0x17c713[_0x46b382(0x1203)](this[_0x46b382(0xa67)+_0x46b382(0x55e)][_0xa432d5],undefined))return this[_0x46b382(0xa67)+_0x46b382(0x55e)][_0xa432d5];this[_0x46b382(0xa67)+'yCache'][_0xa432d5]=null;const _0x558794=this[_0x46b382(0x9c8)+_0x46b382(0xcdb)](),_0x1ab61c=_0x558794['find'](_0x2ca4f0=>_0x2ca4f0[_0x46b382(0x848)]()===_0xa432d5);if(_0x1ab61c)this[_0x46b382(0xa67)+_0x46b382(0x55e)][_0xa432d5]=_0x1ab61c;return this['_battlerKe'+_0x46b382(0x55e)][_0xa432d5];},Game_BattlerBase['prototype']['battlerKey']=function(){const _0x348ca5=_0xe90fac,_0x9f14f3={'llFUt':_0x348ca5(0x10dd),'MiVgm':'actor','rOSqr':'enemy'};return _0x9f14f3[_0x348ca5(0x135b)][_0x348ca5(0xeb8)](this[_0x348ca5(0xd83)]()?_0x9f14f3[_0x348ca5(0x693)]:_0x9f14f3[_0x348ca5(0x909)],this[_0x348ca5(0x14c)]());},Game_Action['prototype']['setTargetB'+'attlerKey']=function(_0x19e2b0){const _0x3d0226=_0xe90fac,_0x232127={'ievQa':function(_0x4f420d,_0x15eeba){return _0x4f420d!==_0x15eeba;},'zPIBN':function(_0x1a0596,_0x2962b0){return _0x1a0596===_0x2962b0;},'BMRtj':_0x3d0226(0x72d)};if(_0x232127[_0x3d0226(0xa17)](this[_0x3d0226(0x7fb)+_0x3d0226(0xe80)],''))return;_0x232127[_0x3d0226(0x14b5)](typeof _0x19e2b0,_0x232127[_0x3d0226(0xc36)])?this['_targetBat'+_0x3d0226(0xe80)]=_0x19e2b0[_0x3d0226(0x371)+'e']()[_0x3d0226(0x808)]():this[_0x3d0226(0x7fb)+_0x3d0226(0xe80)]=_0x19e2b0[_0x3d0226(0x848)]();},Game_Action[_0xe90fac(0x510)]['getBattler'+_0xe90fac(0x959)]=function(){const _0x6d772e=_0xe90fac;return[this[_0x6d772e(0xa18)+_0x6d772e(0x153f)+_0x6d772e(0x41c)]()];},Game_Action['prototype']['getSpecifi'+_0xe90fac(0x153f)+_0xe90fac(0x41c)]=function(){const _0x155cc7=_0xe90fac,_0x402eed=this['_targetBat'+_0x155cc7(0xe80)]||'',_0x2d1798=BattleManager[_0x155cc7(0xde)+'FromKey'](_0x402eed);if(!_0x2d1798)return this['getBattler'+_0x155cc7(0x914)+_0x155cc7(0xea8)]();if(!_0x2d1798[_0x155cc7(0xb30)]())return this[_0x155cc7(0xde)+_0x155cc7(0x914)+_0x155cc7(0xea8)]();return _0x2d1798;},Game_Action['prototype'][_0xe90fac(0xde)+_0xe90fac(0x914)+_0xe90fac(0xea8)]=function(){const _0x249ef1=_0xe90fac,_0x3cdc01=this[_0x249ef1(0x7fb)+_0x249ef1(0xe80)];return _0x3cdc01[_0x249ef1(0x3eb)](/ACTOR/i)?this['friendsUni'+'t']()[_0x249ef1(0xdd4)+_0x249ef1(0xf28)]():this[_0x249ef1(0xb10)+_0x249ef1(0x14a)]()[_0x249ef1(0xdd4)+'Target']();},BattleManager[_0xe90fac(0x1347)+_0xe90fac(0x1be)]=function(){const _0x3dae41=_0xe90fac;return this[_0x3dae41(0x9c8)+_0x3dae41(0xcdb)]()[_0x3dae41(0x55f)](_0x14c1fb=>_0x14c1fb[_0x3dae41(0x228)]());},BattleManager['processBat'+_0xe90fac(0xf8a)]=function(_0x1c9e5c){const _0x497593=_0xe90fac,_0x545f64={'ZwwHS':function(_0x5b4184,_0x4f6173){return _0x5b4184===_0x4f6173;},'CeWSE':'BattleVict'+_0x497593(0x18b)};_0x545f64[_0x497593(0x1419)](_0x1c9e5c,_0x545f64[_0x497593(0x169)])&&(this[_0x497593(0x794)+'tle']=!![]),$gameParty['processBat'+_0x497593(0xf8a)](_0x1c9e5c),$gameTroop[_0x497593(0x60b)+_0x497593(0xf8a)](_0x1c9e5c);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xb54)+_0xe90fac(0x38e)+_0xe90fac(0x106)]=BattleManager['startBattl'+'e'],BattleManager[_0xe90fac(0x117d)+'e']=function(){const _0x289a5b=_0xe90fac,_0x50ab31={'uNfHQ':_0x289a5b(0x6de)+'2','xPUze':_0x289a5b(0x5b0)+'ttleJS','LdirJ':_0x289a5b(0x373)+'attleJS'},_0x2aff7b=_0x50ab31[_0x289a5b(0x19e)]['split']('|');let _0x3c296b=0x1ff3+0x3*-0x3bd+-0x4*0x52f;while(!![]){switch(_0x2aff7b[_0x3c296b++]){case'0':this[_0x289a5b(0xcf9)+'e']=ConfigManager[_0x289a5b(0xfa2)+_0x289a5b(0x9fe)];continue;case'1':this[_0x289a5b(0x60b)+_0x289a5b(0xf8a)](_0x50ab31[_0x289a5b(0x6d3)]);continue;case'2':this[_0x289a5b(0x60b)+_0x289a5b(0xf8a)](_0x50ab31[_0x289a5b(0x13c9)]);continue;case'3':this[_0x289a5b(0xb34)]=![];continue;case'4':this[_0x289a5b(0x794)+_0x289a5b(0x3ad)]=![];continue;case'5':VisuMZ[_0x289a5b(0x118f)]['BattleMana'+_0x289a5b(0x38e)+_0x289a5b(0x106)]['call'](this);continue;}break;}},BattleManager['processPos'+_0xe90fac(0x95b)+_0xe90fac(0x13d)]=function(_0x3261ac){const _0x42e551=_0xe90fac,_0x13067b={'HQdmP':function(_0x546f3e,_0x6bc2df){return _0x546f3e!==_0x6bc2df;},'MxBhn':_0x42e551(0x14ae),'mIWIH':_0x42e551(0x30a)},_0x1e7bb9=VisuMZ[_0x42e551(0x118f)][_0x42e551(0x281)][_0x42e551(0x7dd)];_0x13067b[_0x42e551(0xc0b)](_0x3261ac,_0x13067b[_0x42e551(0xe71)])&&_0x1e7bb9[_0x42e551(0x7b0)+_0x42e551(0x234)]&&VisuMZ[_0x42e551(0x118f)]['CheckMapBa'+'ttleEventV'+_0x42e551(0x879)](_0x1e7bb9[_0x42e551(0x7b0)+_0x42e551(0x234)])&&$gameTemp['reserveCom'+_0x42e551(0x15f7)](_0x1e7bb9[_0x42e551(0x7b0)+_0x42e551(0x234)]);const _0x55e361=_0x13067b[_0x42e551(0x924)][_0x42e551(0xeb8)](_0x3261ac);_0x1e7bb9[_0x55e361]&&VisuMZ[_0x42e551(0x118f)][_0x42e551(0x1429)+_0x42e551(0xb15)+_0x42e551(0x879)](_0x1e7bb9[_0x55e361])&&$gameTemp[_0x42e551(0x11bf)+'monEvent'](_0x1e7bb9[_0x55e361]);},VisuMZ['BattleCore']['BattleMana'+_0xe90fac(0x1b3)]=BattleManager[_0xe90fac(0x210)],BattleManager[_0xe90fac(0x210)]=function(){const _0xc6a0e2=_0xe90fac;VisuMZ['BattleCore'][_0xc6a0e2(0xb54)+_0xc6a0e2(0x1b3)]['call'](this),SceneManager[_0xc6a0e2(0x11be)+_0xc6a0e2(0x3ad)]()&&BattleManager[_0xc6a0e2(0x127)+'t']();},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xb54)+_0xe90fac(0x35d)+'attleEnd']=BattleManager[_0xe90fac(0x871)+_0xe90fac(0x246)],BattleManager[_0xe90fac(0x871)+_0xe90fac(0x246)]=function(){const _0x5c6729=_0xe90fac,_0x318424={'ivelz':function(_0x726b39,_0x17ca46){return _0x726b39===_0x17ca46;},'gKKzQ':_0x5c6729(0x126)};if(_0x318424[_0x5c6729(0x288)](this[_0x5c6729(0xd75)],_0x318424[_0x5c6729(0xe06)])){if($gameTemp[_0x5c6729(0x9f3)+_0x5c6729(0xbe5)+'d']())return![];}return VisuMZ['BattleCore'][_0x5c6729(0xb54)+_0x5c6729(0x35d)+_0x5c6729(0x5cd)][_0x5c6729(0x351)](this);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xb54)+_0xe90fac(0xe34)+'sVictory']=BattleManager[_0xe90fac(0xc64)+'tory'],BattleManager['processVic'+_0xe90fac(0x1314)]=function(){const _0x1ef92a=_0xe90fac,_0x426a43={'wWbZJ':_0x1ef92a(0x818)+_0x1ef92a(0x18b),'xzKvX':_0x1ef92a(0x4aa)};this['_endingBat'+_0x1ef92a(0x3ad)]=!![],this[_0x1ef92a(0x60b)+_0x1ef92a(0xf8a)](_0x426a43[_0x1ef92a(0x42b)]),VisuMZ[_0x1ef92a(0x118f)][_0x1ef92a(0xb54)+'ger_proces'+'sVictory'][_0x1ef92a(0x351)](this),this[_0x1ef92a(0x104e)+_0x1ef92a(0x95b)+_0x1ef92a(0x13d)](_0x426a43[_0x1ef92a(0xeb1)]);},VisuMZ['BattleCore'][_0xe90fac(0xb54)+_0xe90fac(0xe34)+_0xe90fac(0x143a)]=BattleManager[_0xe90fac(0xc9a)+'rt'],BattleManager['processAbo'+'rt']=function(){const _0x51491d=_0xe90fac;this['_endingBat'+_0x51491d(0x3ad)]=!![],VisuMZ[_0x51491d(0x118f)][_0x51491d(0xb54)+_0x51491d(0xe34)+_0x51491d(0x143a)]['call'](this);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xb54)+_0xe90fac(0xe34)+_0xe90fac(0xb70)]=BattleManager[_0xe90fac(0x11f5)+_0xe90fac(0x1026)],BattleManager[_0xe90fac(0x11f5)+'eat']=function(){const _0x4ac1b8=_0xe90fac,_0x394dc7={'eRhNw':'BattleDefe'+_0x4ac1b8(0x160b),'AHtnO':_0x4ac1b8(0x8ef)};this[_0x4ac1b8(0x794)+'tle']=!![],this[_0x4ac1b8(0x60b)+_0x4ac1b8(0xf8a)](_0x394dc7[_0x4ac1b8(0x1594)]),VisuMZ['BattleCore'][_0x4ac1b8(0xb54)+_0x4ac1b8(0xe34)+'sDefeat'][_0x4ac1b8(0x351)](this),this[_0x4ac1b8(0x104e)+'tBattleCom'+_0x4ac1b8(0x13d)](_0x394dc7[_0x4ac1b8(0x1ac)]);},VisuMZ['BattleCore'][_0xe90fac(0xb54)+_0xe90fac(0xa10)+'tle']=BattleManager[_0xe90fac(0xaa8)],BattleManager['endBattle']=function(_0xf12fce){const _0x50b019=_0xe90fac,_0x1162a9={'LUGiA':'2|3|1|0|4','MvsLr':'PreEndBatt'+_0x50b019(0x1377),'sLWis':_0x50b019(0xc46)+_0x50b019(0x3a6)},_0x56c062=_0x1162a9['LUGiA']['split']('|');let _0x1f4837=0x903*-0x4+-0x20fb+0x4507;while(!![]){switch(_0x56c062[_0x1f4837++]){case'0':VisuMZ['BattleCore']['BattleMana'+_0x50b019(0xa10)+_0x50b019(0x3ad)]['call'](this,_0xf12fce);continue;case'1':this[_0x50b019(0x60b)+_0x50b019(0xf8a)](_0x1162a9[_0x50b019(0x8e7)]);continue;case'2':this[_0x50b019(0xb34)]=!![];continue;case'3':this['_autoBattl'+'e']=![];continue;case'4':this[_0x50b019(0x60b)+_0x50b019(0xf8a)](_0x1162a9[_0x50b019(0x14a9)]);continue;}break;}},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xb54)+_0xe90fac(0xef5)+_0xe90fac(0x76d)]=BattleManager[_0xe90fac(0x107e)],BattleManager[_0xe90fac(0x107e)]=function(){const _0xe569bc=_0xe90fac,_0x5977b4={'fZJCt':'PreStartTu'+_0xe569bc(0xcc),'DEIMH':_0xe569bc(0x125a)+_0xe569bc(0xdb8)};if(this[_0xe569bc(0x1446)+'d']())this[_0xe569bc(0x60b)+_0xe569bc(0xf8a)](_0x5977b4['fZJCt']);VisuMZ['BattleCore'][_0xe569bc(0xb54)+_0xe569bc(0xef5)+'urn'][_0xe569bc(0x351)](this);if(this[_0xe569bc(0x1446)+'d']())this[_0xe569bc(0x60b)+_0xe569bc(0xf8a)](_0x5977b4[_0xe569bc(0x3d6)]);},BattleManager[_0xe90fac(0xd41)+'n']=function(){const _0x215fe2=_0xe90fac,_0x2d7e5c=this[_0x215fe2(0x14c1)],_0x106f16=_0x2d7e5c[_0x215fe2(0x7f5)+_0x215fe2(0x130a)]();_0x106f16?(_0x106f16[_0x215fe2(0x1328)](),_0x106f16[_0x215fe2(0x6ab)]()?(this[_0x215fe2(0x116c)+'n'](),_0x2d7e5c[_0x215fe2(0x62a)+_0x215fe2(0x3ed)]()):(_0x2d7e5c[_0x215fe2(0x62a)+_0x215fe2(0x3ed)](),this['endAction']())):(this['endAction'](),this[_0x215fe2(0x14c1)]=null);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xb54)+_0xe90fac(0xfd8)+_0xe90fac(0xce0)]=BattleManager[_0xe90fac(0x116c)+'n'],BattleManager[_0xe90fac(0x116c)+'n']=function(){const _0x2fdc1f=_0xe90fac,_0x1eaa2f={'jSuwS':function(_0x414ac7,_0x510a94){return _0x414ac7===_0x510a94;},'jfMEV':_0x2fdc1f(0xd81)+_0x2fdc1f(0x14ff),'dXEVJ':_0x2fdc1f(0xc74)+_0x2fdc1f(0x6fc)},_0x2588df=this[_0x2fdc1f(0x14c1)][_0x2fdc1f(0x7f5)+_0x2fdc1f(0x130a)](),_0x29b1ab=this['_subject'];_0x2588df&&_0x1eaa2f['jSuwS'](_0x2588df['subject'](),_0x29b1ab)&&_0x2588df[_0x2fdc1f(0x5c1)+_0x2fdc1f(0xf59)](_0x1eaa2f[_0x2fdc1f(0x1531)]),VisuMZ[_0x2fdc1f(0x118f)][_0x2fdc1f(0xb54)+_0x2fdc1f(0xfd8)+_0x2fdc1f(0xce0)]['call'](this),_0x2588df&&_0x1eaa2f['jSuwS'](_0x2588df['subject'](),_0x29b1ab)&&_0x2588df[_0x2fdc1f(0x5c1)+_0x2fdc1f(0xf59)](_0x1eaa2f['dXEVJ']);},VisuMZ[_0xe90fac(0x118f)]['BattleMana'+_0xe90fac(0xadb)+'ion']=BattleManager[_0xe90fac(0x6e3)],BattleManager[_0xe90fac(0x6e3)]=function(){const _0x2729bf=_0xe90fac,_0x17f72d={'BOVpu':function(_0x28a552,_0x51f56a){return _0x28a552!==_0x51f56a;},'RlCIo':function(_0x2bae53,_0x48a616){return _0x2bae53===_0x48a616;},'cQGsd':'PreEndActi'+'onJS','Klnep':_0x2729bf(0x126),'Ngkml':function(_0x36c2a8,_0x398a32){return _0x36c2a8!==_0x398a32;},'HslAK':function(_0x37ade9,_0x45fea1){return _0x37ade9===_0x45fea1;},'rMRkL':_0x2729bf(0xbd4)+'ionJS'},_0x4b167e=this[_0x2729bf(0xc37)],_0x5d48a9=this[_0x2729bf(0x14c1)];_0x4b167e&&_0x17f72d[_0x2729bf(0xc1f)](_0x4b167e,this[_0x2729bf(0xd84)+'n'])&&_0x17f72d[_0x2729bf(0x40b)](_0x4b167e['subject'](),_0x5d48a9)&&_0x4b167e[_0x2729bf(0x5c1)+_0x2729bf(0xf59)](_0x17f72d['cQGsd']),this[_0x2729bf(0x14c1)]?VisuMZ[_0x2729bf(0x118f)][_0x2729bf(0xb54)+'ger_endAct'+_0x2729bf(0x130a)][_0x2729bf(0x351)](this):this[_0x2729bf(0xd75)]=_0x17f72d['Klnep'],_0x4b167e&&_0x17f72d['Ngkml'](_0x4b167e,this[_0x2729bf(0xd84)+'n'])&&_0x17f72d[_0x2729bf(0xd31)](_0x4b167e[_0x2729bf(0xdf5)](),_0x5d48a9)&&_0x4b167e['actionBatt'+_0x2729bf(0xf59)](_0x17f72d[_0x2729bf(0x7d3)]),this['refreshBat'+_0x2729bf(0x15ca)+'s'](this[_0x2729bf(0x9c8)+_0x2729bf(0xcdb)]()),this['_lastActio'+'n']=this[_0x2729bf(0xc37)];},BattleManager[_0xe90fac(0x10b8)+_0xe90fac(0x15ca)+'s']=function(_0x221803){const _0x43bbf9=_0xe90fac;for(const _0x32f188 of _0x221803){if(!_0x32f188)continue;if(!_0x32f188[_0x43bbf9(0x81d)]())continue;_0x32f188[_0x43bbf9(0x81d)]()[_0x43bbf9(0xff4)+_0x43bbf9(0x130a)]();}},BattleManager['updateActi'+'on']=function(){const _0x3b1a35=_0xe90fac;!this[_0x3b1a35(0x3b7)][_0x3b1a35(0x704)]()&&this[_0x3b1a35(0x6e3)]();},Game_Battler['prototype']['onAllActio'+_0xe90fac(0x91)]=function(){const _0x230284=_0xe90fac,_0x547819={'STfwD':function(_0x1c8890,_0x19c176){return _0x1c8890===_0x19c176;}};this[_0x230284(0x8c0)+'t']();if(Imported[_0x230284(0x120b)+_0x230284(0xa7c)+_0x230284(0x284)]){const _0x5b3f01=VisuMZ[_0x230284(0x10be)+_0x230284(0x13f1)]['Settings'][_0x230284(0x8da)];_0x5b3f01&&_0x547819[_0x230284(0x9c6)](_0x5b3f01[_0x230284(0x469)+_0x230284(0x29b)],![])&&this['removeStat'+_0x230284(0x1595)](0x1cb4+0x15*-0x171+-0x2*-0xc9);}else this[_0x230284(0x1001)+'esAuto'](-0x97*-0x3e+-0x1e2+-0x22af);this[_0x230284(0x1526)+_0x230284(0x164)]();},BattleManager[_0xe90fac(0x79b)+'Ratio']=function(){const _0x52fba0=_0xe90fac;this[_0x52fba0(0x575)+'io']=VisuMZ[_0x52fba0(0x118f)][_0x52fba0(0x281)][_0x52fba0(0x7dd)][_0x52fba0(0x2b7)+'RatioJS'][_0x52fba0(0x351)](this);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xb54)+_0xe90fac(0x1282)+_0xe90fac(0xae)]=BattleManager[_0xe90fac(0xb44)+_0xe90fac(0x1320)],BattleManager[_0xe90fac(0xb44)+_0xe90fac(0x1320)]=function(){const _0x19edc3=_0xe90fac,_0x3b58eb={'TQkOY':_0x19edc3(0xe4c)+_0x19edc3(0xbfa),'rAmLy':'EscapeSucc'+_0x19edc3(0xe04)};this[_0x19edc3(0x60b)+_0x19edc3(0xf8a)](_0x3b58eb['TQkOY']),BattleManager[_0x19edc3(0x981)][_0x19edc3(0x13f)+_0x19edc3(0x109e)](),VisuMZ[_0x19edc3(0x118f)][_0x19edc3(0xb54)+_0x19edc3(0x1282)+_0x19edc3(0xae)][_0x19edc3(0x351)](this),this[_0x19edc3(0x104e)+_0x19edc3(0x95b)+_0x19edc3(0x13d)](_0x3b58eb[_0x19edc3(0xa1)]);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xb54)+'ger_onEsca'+_0xe90fac(0x153)]=BattleManager[_0xe90fac(0x3b6)+_0xe90fac(0xe4e)],BattleManager['onEscapeFa'+_0xe90fac(0xe4e)]=function(){const _0x2752a8=_0xe90fac,_0x4ac309={'Jkolq':_0x2752a8(0x14ae)+_0x2752a8(0x115a),'KUrzA':function(_0x241aa3,_0x1a0a24){return _0x241aa3+_0x1a0a24;},'KWOey':_0x2752a8(0x14ae)};this['processBat'+'tleCoreJS'](_0x4ac309[_0x2752a8(0xefc)]);const _0x55562a=this['_escapeRat'+'io'];VisuMZ[_0x2752a8(0x118f)][_0x2752a8(0xb54)+'ger_onEsca'+_0x2752a8(0x153)][_0x2752a8(0x351)](this),this[_0x2752a8(0x575)+'io']=_0x4ac309[_0x2752a8(0x6fa)](_0x55562a,VisuMZ['BattleCore'][_0x2752a8(0x281)][_0x2752a8(0x7dd)][_0x2752a8(0x2b7)+_0x2752a8(0x5b6)][_0x2752a8(0x351)](this)),this['_inputting']=![],this['processPos'+_0x2752a8(0x95b)+_0x2752a8(0x13d)](_0x4ac309[_0x2752a8(0x108e)]);},BattleManager[_0xe90fac(0xee7)+_0xe90fac(0xe21)]=function(){const _0x378a53=_0xe90fac,_0x1784b1={'gwAIG':_0x378a53(0xf33),'jXjcx':_0x378a53(0x600),'QTSKv':'clear'};let _0x1ec389=![];if(this['isDisplayE'+_0x378a53(0xeee)+'ies']())for(const _0x546e6c of $gameTroop[_0x378a53(0x1c8)]()){this['_logWindow'][_0x378a53(0x15f1)](_0x1784b1[_0x378a53(0x640)],TextManager[_0x378a53(0x804)][_0x378a53(0xeb8)](_0x546e6c)),this[_0x378a53(0x3b7)][_0x378a53(0x15f1)](_0x1784b1[_0x378a53(0x2f6)]),_0x1ec389=!![];}if(this[_0x378a53(0x10bc)+'e'])this[_0x378a53(0x3b7)][_0x378a53(0x15f1)](_0x1784b1[_0x378a53(0x640)],TextManager['preemptive'][_0x378a53(0xeb8)]($gameParty['name']())),this[_0x378a53(0x3b7)][_0x378a53(0x15f1)](_0x1784b1[_0x378a53(0x2f6)]);else this['_surprise']&&(this[_0x378a53(0x3b7)]['push'](_0x1784b1[_0x378a53(0x640)],TextManager['surprise'][_0x378a53(0xeb8)]($gameParty[_0x378a53(0x14c)]())),this[_0x378a53(0x3b7)][_0x378a53(0x15f1)](_0x1784b1[_0x378a53(0x2f6)]));_0x1ec389&&(this[_0x378a53(0x3b7)]['push'](_0x1784b1['jXjcx']),this['_logWindow'][_0x378a53(0x15f1)](_0x1784b1[_0x378a53(0x7fd)])),this['isTpb']()&&this[_0x378a53(0xde2)+_0x378a53(0x2b6)+_0x378a53(0xd82)]()&&(this[_0x378a53(0x1165)+_0x378a53(0x15f6)+'d']=![]);},BattleManager[_0xe90fac(0x128d)+_0xe90fac(0xeee)+_0xe90fac(0x14c5)]=function(){const _0x1dca4c=_0xe90fac;if(BattleManager[_0x1dca4c(0xcf9)+'e'])return![];return VisuMZ['BattleCore'][_0x1dca4c(0x281)][_0x1dca4c(0x105f)][_0x1dca4c(0xef9)];},VisuMZ['BattleCore'][_0xe90fac(0xb54)+'ger_startI'+_0xe90fac(0xe6e)]=BattleManager['startInput'],BattleManager['startInput']=function(){const _0x176041=_0xe90fac;VisuMZ[_0x176041(0x118f)][_0x176041(0xb54)+_0x176041(0xa29)+_0x176041(0xe6e)][_0x176041(0x351)](this),this['isDTB']()&&this[_0x176041(0xde2)+_0x176041(0x2b6)+_0x176041(0xd82)]()&&!this[_0x176041(0x357)]&&$gameParty['canInput']()&&this[_0x176041(0x118d)+'Command']();},BattleManager[_0xe90fac(0xde2)+_0xe90fac(0x2b6)+_0xe90fac(0xd82)]=function(){const _0x3165e6=_0xe90fac;return VisuMZ[_0x3165e6(0x118f)][_0x3165e6(0x281)][_0x3165e6(0x1463)][_0x3165e6(0x426)+'md'];},BattleManager['checkTpbIn'+'putOpen']=function(){const _0x5786c4=_0xe90fac;this[_0x5786c4(0x1045)+'Inputtable']()&&this[_0x5786c4(0x118d)+_0x5786c4(0x1290)]();},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x152d)+_0xe90fac(0x4fc)+_0xe90fac(0x14dc)+_0xe90fac(0x1e0)]=Scene_Battle['prototype'][_0xe90fac(0x7f8)+'CommandSel'+_0xe90fac(0x11db)],Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0x7f8)+_0xe90fac(0x15cd)+_0xe90fac(0x11db)]=function(){const _0x305224=_0xe90fac;VisuMZ[_0x305224(0x118f)][_0x305224(0x152d)+_0x305224(0x4fc)+_0x305224(0x14dc)+_0x305224(0x1e0)][_0x305224(0x351)](this),BattleManager[_0x305224(0x537)]()&&BattleManager['_tpbNeedsP'+_0x305224(0x15f6)+'d']&&(BattleManager[_0x305224(0x1165)+_0x305224(0x15f6)+'d']=![],this[_0x305224(0x13f6)+_0x305224(0x677)+'B']());},BattleManager[_0xe90fac(0x849)+_0xe90fac(0x130a)]=function(_0x33af5f,_0x100a1f,_0x108e00){const _0xd429c1=_0xe90fac;if(!_0x108e00)return;if(!_0x33af5f)return;if(!_0x100a1f)return;const _0xfef280=this[_0xd429c1(0xc37)];this[_0xd429c1(0xc37)]=new Game_Action(_0x33af5f);if(DataManager[_0xd429c1(0x1485)](_0x108e00))this['_action'][_0xd429c1(0x325)](_0x108e00['id']);if(DataManager[_0xd429c1(0x97a)](_0x108e00))this['_action'][_0xd429c1(0x318)](_0x108e00['id']);if(this['_action'][_0xd429c1(0xdd)]())BattleManager[_0xd429c1(0xdb4)+'on'](_0x33af5f,_0x100a1f);this[_0xd429c1(0xc37)]=_0xfef280;},BattleManager['invokeMagi'+'cReflectio'+'n']=function(_0x2960c5,_0x4fe216){const _0x57e945=_0xe90fac,_0x5aac7d={'UXHlD':_0x57e945(0x148b)},_0x3ca1e2=_0x5aac7d['UXHlD'][_0x57e945(0xab1)]('|');let _0x5a56b9=0x1361*-0x1+-0x37f+0x16e0;while(!![]){switch(_0x3ca1e2[_0x5a56b9++]){case'0':this[_0x57e945(0xc37)]['apply'](_0x2960c5);continue;case'1':this['_logWindow'][_0x57e945(0xa26)+_0x57e945(0x9d7)](_0x2960c5,_0x2960c5);continue;case'2':this['_logWindow']['displayRef'+_0x57e945(0xd9a)+_0x57e945(0x8f8)](_0x2960c5,this[_0x57e945(0xc37)]);continue;case'3':this['_logWindow']['displayRef'+'lection'](_0x4fe216);continue;case'4':this[_0x57e945(0xc37)][_0x57e945(0x891)+_0x57e945(0xe41)]=_0x4fe216;continue;}break;}},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xb54)+'ger_makeAc'+_0xe90fac(0xcf0)]=BattleManager[_0xe90fac(0x375)+_0xe90fac(0xcd8)],BattleManager[_0xe90fac(0x375)+_0xe90fac(0xcd8)]=function(){const _0x4f4c31=_0xe90fac;VisuMZ[_0x4f4c31(0x118f)]['BattleMana'+_0x4f4c31(0x456)+_0x4f4c31(0xcf0)][_0x4f4c31(0x351)](this),this[_0x4f4c31(0xabd)+_0x4f4c31(0x15ac)]=this[_0x4f4c31(0xabd)+'tlers'][_0x4f4c31(0x55f)](_0x870ff7=>_0x870ff7&&_0x870ff7[_0x4f4c31(0xe7f)]());},VisuMZ['BattleCore']['BattleMana'+'ger_update'+_0xe90fac(0xed0)]=BattleManager[_0xe90fac(0x1155)+'e'],BattleManager['updatePhas'+'e']=function(_0x11b596){const _0x5a23cb=_0xe90fac,_0x2b090d={'NTnRX':function(_0x2bcae7,_0x1f090){return _0x2bcae7===_0x1f090;},'VTUDg':'custom','CrsxS':_0x5a23cb(0x390)+'n'};if(_0x2b090d['NTnRX'](this[_0x5a23cb(0xd75)],_0x2b090d[_0x5a23cb(0x1ff)]))this['updateCust'+'omActionSe'+'quence']();else _0x2b090d['NTnRX'](this[_0x5a23cb(0xd75)],_0x2b090d[_0x5a23cb(0xc09)])?this[_0x5a23cb(0x4d0)+_0x5a23cb(0x11c)]():VisuMZ[_0x5a23cb(0x118f)][_0x5a23cb(0xb54)+_0x5a23cb(0x116b)+_0x5a23cb(0xed0)][_0x5a23cb(0x351)](this,_0x11b596);},BattleManager[_0xe90fac(0xb62)+_0xe90fac(0x12ed)+'equence']=function(){const _0x5e6b6d=_0xe90fac,_0x30cb5e={'PMcHA':_0x5e6b6d(0x2ea)};this[_0x5e6b6d(0xa1c)+'s']=this[_0x5e6b6d(0x12dd)]['slice'](0x6a3+0x15b2+-0x1*0x1c55),this[_0x5e6b6d(0xc83)+'ex']=0x1c30+-0x1ae1+0x1*-0x14f,this['_target']=this[_0x5e6b6d(0xa1c)+'s'][0x9a4*0x3+0x19f*-0xb+0x1*-0xb17]||null,this['_phase']=_0x30cb5e['PMcHA'];},BattleManager[_0xe90fac(0x121f)+_0xe90fac(0xc57)+'quence']=function(){const _0x1278c4=_0xe90fac,_0x5505f5={'Nnsll':'action'};!this['updateEven'+'tMain']()&&!this[_0x1278c4(0x3b7)][_0x1278c4(0x704)]()&&(this[_0x1278c4(0xd75)]=_0x5505f5[_0x1278c4(0xc60)]);},BattleManager[_0xe90fac(0x390)+'n']=function(_0x10b069){const _0xfae2=_0xe90fac,_0x459229={'gdrsP':function(_0x51e14d,_0x21baf2){return _0x51e14d===_0x21baf2;}};this['_actionBat'+'tlers'][_0xfae2(0x8a4)](_0x10b069);if(_0x459229[_0xfae2(0x12b)](_0x10b069,this[_0xfae2(0x14c1)]))return;const _0xb9d539=JsonEx['makeDeepCo'+'py'](_0x10b069['currentAct'+_0xfae2(0x130a)]());this['_forcedBat'+_0xfae2(0x15ac)][_0xfae2(0x15f1)]([_0x10b069,_0xb9d539]);},BattleManager[_0xe90fac(0x12d3)+_0xe90fac(0x326)]=function(){},BattleManager[_0xe90fac(0x9cd)+'t']=function(){const _0x8ffc6=_0xe90fac,_0x45327a={'RrvGU':_0x8ffc6(0x126),'CpkMy':function(_0x21ed47,_0x51574d){return _0x21ed47>_0x51574d;}};if(this[_0x8ffc6(0x537)]())this[_0x8ffc6(0xd75)]=_0x45327a['RrvGU'];else _0x45327a[_0x8ffc6(0xe4)](this['_forcedBat'+_0x8ffc6(0x15ac)][_0x8ffc6(0x1268)],-0xc3a+0x1a9+-0xa91*-0x1)?this[_0x8ffc6(0xd75)]=_0x45327a['RrvGU']:this[_0x8ffc6(0xef4)]();},BattleManager[_0xe90fac(0xbc3)+_0xe90fac(0x1317)]=function(){const _0x3b4709=_0xe90fac,_0x1b011e={'gxVln':_0x3b4709(0xae2)},_0x112dff=this[_0x3b4709(0x14c1)];_0x112dff&&this[_0x3b4709(0x537)]()&&_0x112dff['setActionS'+_0x3b4709(0x2ce)](_0x1b011e[_0x3b4709(0xaa6)]);for(;;){const _0x302067=this[_0x3b4709(0xbc3)+_0x3b4709(0x13d7)+'ol']();if(!_0x302067)return null;if(_0x302067[_0x3b4709(0x749)+_0x3b4709(0x189)]()&&_0x302067[_0x3b4709(0xb30)]())return _0x302067;}},BattleManager['getNextSub'+_0xe90fac(0x13d7)+'ol']=function(){const _0x4ee37d=_0xe90fac,_0x3ec5ab={'TxjRu':function(_0x42c5b5,_0x4b4d4d){return _0x42c5b5>_0x4b4d4d;}};if(_0x3ec5ab[_0x4ee37d(0xbea)](this[_0x4ee37d(0x1588)+_0x4ee37d(0x15ac)][_0x4ee37d(0x1268)],0x1*-0xe83+-0x465+-0x2c*-0x6e)){const _0x202a55=this[_0x4ee37d(0x1588)+_0x4ee37d(0x15ac)][_0x4ee37d(0xbe0)](),_0x1ee183=_0x202a55[0x2691*-0x1+0x1*0x1915+0xd7c*0x1];return _0x1ee183[_0x4ee37d(0x146a)]=_0x1ee183[_0x4ee37d(0x146a)]||[],_0x1ee183['_actions'][-0x1*0x9a1+0x407+0x59a]=_0x202a55[-0x1*0x2390+-0x198+0x2529],_0x1ee183;}else return this[_0x4ee37d(0xabd)+_0x4ee37d(0x15ac)][_0x4ee37d(0xbe0)]();},VisuMZ['BattleCore'][_0xe90fac(0x6e8)+_0xe90fac(0xf5f)+_0xe90fac(0x1580)]=Game_Battler[_0xe90fac(0x510)][_0xe90fac(0x390)+'n'],Game_Battler[_0xe90fac(0x510)]['forceActio'+'n']=function(_0x3d5f6a,_0x14bc13){const _0xf080a=_0xe90fac,_0x2ada61={'PeftX':function(_0x4cf977,_0x1a0a2f){return _0x4cf977-_0x1a0a2f;}};VisuMZ['BattleCore'][_0xf080a(0x6e8)+_0xf080a(0xf5f)+'tion'][_0xf080a(0x351)](this,_0x3d5f6a,_0x14bc13),this[_0xf080a(0x146a)][_0x2ada61[_0xf080a(0x92b)](this['_actions'][_0xf080a(0x1268)],0x35b*0xb+-0x1*0x61b+-0x53*0x5f)]['_forceActi'+'on']=!![];},Game_Interpreter[_0xe90fac(0x510)]['command339']=function(_0x38fa16){const _0x5833f8=_0xe90fac;return this[_0x5833f8(0xeaf)+_0x5833f8(0x8d5)](_0x38fa16[0x3*-0x783+0x7e+0x160b],_0x38fa16[-0x21*-0x3+-0x13*-0x62+0x2*-0x3d4],_0x5c0526=>{const _0x5a4068=_0x5833f8;!_0x5c0526[_0x5a4068(0x1363)+_0x5a4068(0x240)]()&&(_0x5c0526['forceActio'+'n'](_0x38fa16[-0xea*0xd+0x1f8e+-0x13aa],_0x38fa16[-0xb*0x1e0+-0x6a3*-0x4+-0x5e9]),BattleManager[_0x5a4068(0x390)+'n'](_0x5c0526));}),!![];},VisuMZ['BattleCore'][_0xe90fac(0x6e8)+'er_makeSpe'+'ed']=Game_Battler['prototype'][_0xe90fac(0x1503)],Game_Battler[_0xe90fac(0x510)]['makeSpeed']=function(){const _0x1333f7=_0xe90fac,_0x49c6a5={'vtwEt':function(_0xefed68,_0x433e30){return _0xefed68<=_0x433e30;}};VisuMZ[_0x1333f7(0x118f)][_0x1333f7(0x6e8)+_0x1333f7(0x13cb)+'ed'][_0x1333f7(0x351)](this),_0x49c6a5[_0x1333f7(0x2a7)](this[_0x1333f7(0x146a)]['length'],-0x25ea*0x1+0x1*0x1c0f+0x9db)&&(this['_speed']=Number[_0x1333f7(0xaf0)+_0x1333f7(0x814)]);},BattleManager[_0xe90fac(0x8bd)+_0xe90fac(0x8f6)+_0xe90fac(0x12fb)]=function(){const _0x50d7e1=_0xe90fac;if(VisuMZ[_0x50d7e1(0x118f)][_0x50d7e1(0x281)][_0x50d7e1(0x7d7)][_0x50d7e1(0xbd8)+_0x50d7e1(0x12fb)]??!![])return![];return SceneManager[_0x50d7e1(0x11be)+_0x50d7e1(0x3ad)]()&&this[_0x50d7e1(0x794)+_0x50d7e1(0x3ad)];},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xb54)+_0xe90fac(0xf17)+_0xe90fac(0x1059)+'d']=BattleManager[_0xe90fac(0x118d)+_0xe90fac(0x1290)],BattleManager['selectNext'+_0xe90fac(0x1290)]=function(){const _0x33b287=_0xe90fac;this['isTpb']()?this[_0x33b287(0x118d)+_0x33b287(0x60a)]():VisuMZ[_0x33b287(0x118f)][_0x33b287(0xb54)+_0x33b287(0xf17)+_0x33b287(0x1059)+'d']['call'](this);},BattleManager[_0xe90fac(0x118d)+_0xe90fac(0x60a)]=function(){const _0x3b5d98=_0xe90fac;if(this['_currentAc'+_0x3b5d98(0x323)]){if(this[_0x3b5d98(0x1123)+'tor'][_0x3b5d98(0x118d)+'Command']())return;this[_0x3b5d98(0xc24)+_0x3b5d98(0x120)](),this['checkTpbIn'+_0x3b5d98(0x2cf)](),!this[_0x3b5d98(0x14c1)]&&!this[_0x3b5d98(0x1123)+_0x3b5d98(0x323)]&&SceneManager[_0x3b5d98(0x11dd)]['updateBatt'+_0x3b5d98(0x59a)]();}else!this['_subject']&&this[_0x3b5d98(0x118d)+'Actor']();},BattleManager[_0xe90fac(0x103)+_0xe90fac(0x2cf)]=function(){const _0x5d6bec=_0xe90fac;(!this[_0x5d6bec(0x1045)+_0x5d6bec(0x868)]()||this['needsActor'+_0x5d6bec(0x10d5)+'l']())&&(this[_0x5d6bec(0x727)+_0x5d6bec(0x758)+'Actor']&&(!$gameParty['battleMemb'+'ers']()[_0x5d6bec(0x79c)](this[_0x5d6bec(0x727)+_0x5d6bec(0x758)+_0x5d6bec(0xd11)])&&(this['_tpbSceneC'+'hangeCache'+'Actor']=null)),!this['_tpbSceneC'+_0x5d6bec(0x758)+_0x5d6bec(0xd11)]?(this[_0x5d6bec(0x9ca)+'rInput'](),this[_0x5d6bec(0x1123)+_0x5d6bec(0x323)]=null,this[_0x5d6bec(0xd3)]=![]):this['revertTpbC'+_0x5d6bec(0xfc7)]());},BattleManager[_0xe90fac(0xa47)+_0xe90fac(0xfc7)]=function(){const _0x24befc=_0xe90fac,_0x48ec33={'ckXWG':_0x24befc(0x76a)};!$gameParty[_0x24befc(0xac1)+_0x24befc(0x446)]()['includes'](this['_tpbSceneC'+_0x24befc(0x758)+_0x24befc(0xd11)])&&(this['_tpbSceneC'+'hangeCache'+_0x24befc(0xd11)]=null),this[_0x24befc(0x727)+_0x24befc(0x758)+'Actor']?(this['_currentAc'+_0x24befc(0x323)]=this[_0x24befc(0x727)+'hangeCache'+_0x24befc(0xd11)],this['_currentAc'+'tor'][_0x24befc(0x14dd)]=_0x48ec33[_0x24befc(0x960)],this[_0x24befc(0xd3)]=!![],this[_0x24befc(0x727)+_0x24befc(0x758)+'Actor']=null):(this[_0x24befc(0x9ca)+_0x24befc(0x120)](),this[_0x24befc(0x1123)+_0x24befc(0x323)]=null,this[_0x24befc(0xd3)]=![]);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xb54)+_0xe90fac(0x6a9)+'ainPhase']=BattleManager[_0xe90fac(0x830)+_0xe90fac(0xd94)],BattleManager[_0xe90fac(0x830)+'hase']=function(){const _0x4d6300=_0xe90fac,_0x3fcc94={'UQofD':function(_0x44cac1,_0x1bfde6){return _0x44cac1===_0x1bfde6;},'kLLgg':_0x4d6300(0x2ea)};return _0x3fcc94[_0x4d6300(0x8b0)](this[_0x4d6300(0xd75)],_0x3fcc94[_0x4d6300(0x51c)])?this[_0x4d6300(0x523)+'TpbMainPha'+'se']():VisuMZ['BattleCore'][_0x4d6300(0xb54)+_0x4d6300(0x6a9)+_0x4d6300(0x135c)][_0x4d6300(0x351)](this);},BattleManager[_0xe90fac(0x523)+_0xe90fac(0xe7e)+'se']=function(){const _0x26bac1=_0xe90fac;return this[_0x26bac1(0x107c)+'b']();},VisuMZ['BattleCore'][_0xe90fac(0xb54)+_0xe90fac(0xec2)+_0xe90fac(0x92e)]=BattleManager['cancelActo'+_0xe90fac(0x120)],BattleManager[_0xe90fac(0x9ca)+'rInput']=function(){const _0x1bf2b4=_0xe90fac,_0x3412ca={'UpQHE':function(_0x53632a,_0x1e20b2){return _0x53632a===_0x1e20b2;},'Ejeaz':_0x1bf2b4(0x2dc)};this[_0x1bf2b4(0x537)]()&&_0x3412ca[_0x1bf2b4(0x665)](this['_phase'],_0x3412ca[_0x1bf2b4(0xe02)])&&(this[_0x1bf2b4(0x1123)+_0x1bf2b4(0x323)]=null),VisuMZ[_0x1bf2b4(0x118f)][_0x1bf2b4(0xb54)+'ger_cancel'+_0x1bf2b4(0x92e)]['call'](this);},VisuMZ['BattleCore'][_0xe90fac(0xb54)+_0xe90fac(0x1330)+_0xe90fac(0x136e)]=BattleManager[_0xe90fac(0x450)+_0xe90fac(0xce0)],BattleManager['inputtingA'+_0xe90fac(0xce0)]=function(){const _0x54ba21=_0xe90fac,_0x33e73e=this['_currentAc'+_0x54ba21(0x323)];if(_0x33e73e&&!_0x33e73e[_0x54ba21(0x450)+'ction']()){const _0xa16d7b=_0x33e73e[_0x54ba21(0xe28)+_0x54ba21(0x120f)];_0x33e73e[_0x54ba21(0x146a)][_0xa16d7b]=new Game_Action(_0x33e73e);}return VisuMZ[_0x54ba21(0x118f)][_0x54ba21(0xb54)+_0x54ba21(0x1330)+'ingAction'][_0x54ba21(0x351)](this);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xb54)+_0xe90fac(0xb8d)+_0xe90fac(0x930)]=BattleManager[_0xe90fac(0xce6)+_0xe90fac(0x81c)],BattleManager[_0xe90fac(0xce6)+_0xe90fac(0x81c)]=function(_0x574705){const _0x3dfd6f=_0xe90fac;if(this[_0x3dfd6f(0xc37)][_0x3dfd6f(0x30f)+'d']())return![];return VisuMZ[_0x3dfd6f(0x118f)][_0x3dfd6f(0xb54)+_0x3dfd6f(0xb8d)+_0x3dfd6f(0x930)][_0x3dfd6f(0x351)](this,_0x574705);},SceneManager[_0xe90fac(0x11be)+_0xe90fac(0x3ad)]=function(){const _0x14af4c=_0xe90fac,_0x1c1b34={'tQaTH':function(_0x479555,_0x191439){return _0x479555===_0x191439;}};return this['_scene']&&_0x1c1b34['tQaTH'](this[_0x14af4c(0x11dd)][_0x14af4c(0x14c0)+'r'],Scene_Battle);},SceneManager['isBattleFl'+'ipped']=function(){const _0x10182c=_0xe90fac;return Spriteset_Battle[_0x10182c(0x510)]['isFlipped']();},SceneManager['isPrevious'+_0xe90fac(0x1367)+_0xe90fac(0x38d)+_0xe90fac(0x1357)]=function(){const _0x1bc701=_0xe90fac;if(SceneManager[_0x1bc701(0x1473)+_0x1bc701(0x4b8)](Scene_Options))return!![];return![];},SceneManager[_0xe90fac(0x865)+_0xe90fac(0x1262)+'nsitionabl'+'e']=function(){const _0x45812a=_0xe90fac;if(SceneManager[_0x45812a(0x865)+'e'](Scene_Options))return!![];return![];},SceneManager[_0xe90fac(0x10fd)+_0xe90fac(0x83e)+'sitionable']=function(_0x450a59){const _0x2ddfee=_0xe90fac,_0x14b717={'hkkfx':_0x2ddfee(0x733)+_0x2ddfee(0x15e9),'nrMwe':_0x2ddfee(0x1127)+'y','wJQmI':_0x2ddfee(0x1432)+_0x2ddfee(0x107b)};if(!SceneManager[_0x2ddfee(0x11be)+_0x2ddfee(0x3ad)]())return!![];const _0x17d7f9=[_0x14b717['hkkfx'],_0x14b717[_0x2ddfee(0xf57)],_0x14b717[_0x2ddfee(0xe35)]];return _0x17d7f9[_0x2ddfee(0x79c)](_0x450a59['name']);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xbd)+_0xe90fac(0x68a)]=SceneManager['push'],SceneManager[_0xe90fac(0x15f1)]=function(_0x76db0b){const _0x3791f4=_0xe90fac;if(!SceneManager[_0x3791f4(0x10fd)+_0x3791f4(0x83e)+_0x3791f4(0x119a)](_0x76db0b))return this[_0x3791f4(0xd36)+'tleCoreTra'+_0x3791f4(0x675)+_0x3791f4(0xf9)](_0x76db0b);VisuMZ[_0x3791f4(0x118f)][_0x3791f4(0xbd)+'er_push'][_0x3791f4(0x351)](this,_0x76db0b);},SceneManager[_0xe90fac(0xd36)+_0xe90fac(0x3e9)+_0xe90fac(0x675)+_0xe90fac(0xf9)]=function(_0xfd7da9){const _0xe25e47=_0xe90fac,_0x20ba1b={'WEeAO':_0xe25e47(0xf68)+_0xe25e47(0xd90)+_0xe25e47(0x5ed)+'upport\x20cha'+_0xe25e47(0x1c7),'PaWBZ':_0xe25e47(0x15f9)+'battle.','yUTtN':function(_0x54e8d6,_0x3833bc){return _0x54e8d6(_0x3833bc);}};if(!$gameTemp['isPlaytest']())return;if(this[_0xe25e47(0xb8a)+'ttleCoreTr'+_0xe25e47(0x1bf)+_0xe25e47(0x18a)])return;this[_0xe25e47(0xb8a)+_0xe25e47(0x1d3)+_0xe25e47(0x1bf)+_0xe25e47(0x18a)]=!![];let _0x4398d5='';_0x4398d5+=_0x20ba1b[_0xe25e47(0x34a)],_0x4398d5+=_0x20ba1b[_0xe25e47(0x1587)][_0xe25e47(0xeb8)](_0xfd7da9[_0xe25e47(0x14c)]),_0x20ba1b[_0xe25e47(0x83c)](alert,_0x4398d5);},VisuMZ[_0xe90fac(0x118f)]['Game_Temp_'+_0xe90fac(0xc68)]=Game_Temp[_0xe90fac(0x510)][_0xe90fac(0xc68)],Game_Temp[_0xe90fac(0x510)][_0xe90fac(0xc68)]=function(){const _0x1f4b64=_0xe90fac;VisuMZ[_0x1f4b64(0x118f)][_0x1f4b64(0x177)+'initialize'][_0x1f4b64(0x351)](this),this['_battleBal'+'loonQueue']=[];},VisuMZ['BattleCore'][_0xe90fac(0x177)+_0xe90fac(0xdfd)+_0xe90fac(0xb0d)]=Game_Temp[_0xe90fac(0x510)]['requestAni'+'mation'],Game_Temp['prototype']['requestAni'+_0xe90fac(0xb0d)]=function(_0x50013c,_0x27caab,_0x201b34){const _0x113091=_0xe90fac;_0x50013c=_0x50013c['filter']((_0xc03f4a,_0x2764e0,_0x4c37a4)=>_0x4c37a4['indexOf'](_0xc03f4a)===_0x2764e0);SceneManager[_0x113091(0x11be)+_0x113091(0x3ad)]()&&SceneManager[_0x113091(0x333)+_0x113091(0xe11)]()&&(_0x201b34=!_0x201b34);VisuMZ['BattleCore'][_0x113091(0x177)+'requestAni'+_0x113091(0xb0d)][_0x113091(0x351)](this,_0x50013c,_0x27caab,_0x201b34);SceneManager[_0x113091(0x11be)+_0x113091(0x3ad)]()&&BattleManager['_spriteset']['processAni'+_0x113091(0x108f)+_0x113091(0xb35)]();for(const _0x5ad033 of _0x50013c){_0x5ad033&&_0x5ad033[_0x113091(0xb9a)]&&_0x5ad033[_0x113091(0xb9a)]()&&_0x5ad033['resetNameT'+'empVisibil'+_0x113091(0x798)]();}},Game_Temp[_0xe90fac(0x510)]['setLastPlu'+_0xe90fac(0x10f2)+_0xe90fac(0x1b4)+'r']=function(_0x3d114d){const _0x51e7f9=_0xe90fac;this[_0x51e7f9(0xdea)+'nCommandIn'+_0x51e7f9(0x14b3)]=_0x3d114d;},Game_Temp[_0xe90fac(0x510)][_0xe90fac(0xb71)+_0xe90fac(0x10f2)+_0xe90fac(0x1b4)+'r']=function(){const _0x3fff89=_0xe90fac;return this[_0x3fff89(0xdea)+_0x3fff89(0x33d)+_0x3fff89(0x14b3)];},Game_Temp[_0xe90fac(0x510)][_0xe90fac(0x87)+'dGameTroop'+'SettingsBa'+_0xe90fac(0xc12)]=function(){const _0x4daec5=_0xe90fac;this[_0x4daec5(0x1588)+'tleLayout']=undefined;},Game_Temp['prototype'][_0xe90fac(0x66b)+_0xe90fac(0x139f)+'SettingsBa'+_0xe90fac(0xc12)]=function(_0x1cd3e4){const _0x43dad5=_0xe90fac,_0x14b623={'zPoOb':function(_0x4b37b5,_0x327941){return _0x4b37b5&&_0x327941;}};_0x14b623[_0x43dad5(0x718)]($gameMap,$dataMap)&&$dataMap[_0x43dad5(0xfee)]&&this[_0x43dad5(0x5fc)+_0x43dad5(0x139f)+_0x43dad5(0x670)+'ttleCore']($dataMap['note']);const _0x53a61d=$dataTroops[_0x1cd3e4];if(_0x53a61d){let _0x38d016=DataManager[_0x43dad5(0xe23)+'pNote'](_0x53a61d['id']);this[_0x43dad5(0x5fc)+_0x43dad5(0x139f)+_0x43dad5(0x670)+_0x43dad5(0xc12)](_0x38d016);}},Game_Temp[_0xe90fac(0x510)][_0xe90fac(0x5fc)+_0xe90fac(0x139f)+_0xe90fac(0x670)+_0xe90fac(0xc12)]=function(_0x2ac515){const _0x52a592=_0xe90fac,_0x17a022={'cMcLs':function(_0x2deebc,_0x1efdd0){return _0x2deebc(_0x1efdd0);},'pNEAT':_0x52a592(0x142c),'JRdXx':'list','aiTxs':_0x52a592(0x142b),'PgaLg':_0x52a592(0xea1),'WoxMG':'sideview_u'+'i','KNcwN':_0x52a592(0x6f6)+'ui'};if(!_0x2ac515)return;if(_0x2ac515[_0x52a592(0x3eb)](/<(?:BATTLELAYOUT|BATTLE LAYOUT|LAYOUT):[ ](.*?)>/i)){const _0x3a6f76=_0x17a022[_0x52a592(0x6b7)](String,RegExp['$1']);if(_0x3a6f76['match'](/DEFAULT/i))this[_0x52a592(0x1588)+_0x52a592(0x11fe)]=_0x17a022[_0x52a592(0xbff)];else{if(_0x3a6f76[_0x52a592(0x3eb)](/LIST/i))this['_forcedBat'+_0x52a592(0x11fe)]=_0x17a022[_0x52a592(0x17a)];else{if(_0x3a6f76[_0x52a592(0x3eb)](/XP/i))this[_0x52a592(0x1588)+_0x52a592(0x11fe)]='xp';else{if(_0x3a6f76[_0x52a592(0x3eb)](/PORTRAIT/i))this['_forcedBat'+_0x52a592(0x11fe)]=_0x17a022[_0x52a592(0x129b)];else{if(_0x3a6f76[_0x52a592(0x3eb)](/BORDER/i))this[_0x52a592(0x1588)+_0x52a592(0x11fe)]=_0x17a022[_0x52a592(0x465)];else{if(_0x3a6f76[_0x52a592(0x3eb)](/(?:SIDEVIEW UI|SIDEVIEW)/i))Imported[_0x52a592(0xc07)+_0x52a592(0xcb7)+_0x52a592(0x146f)]?this[_0x52a592(0x1588)+_0x52a592(0x11fe)]=_0x17a022[_0x52a592(0xa6d)]:this[_0x52a592(0x1588)+_0x52a592(0x11fe)]=_0x17a022[_0x52a592(0xbff)];else _0x3a6f76[_0x52a592(0x3eb)](/(?:FRONTVIEW UI|FRONTVIEW)/i)&&(Imported['VisuMZ_3_F'+_0x52a592(0x1f3)+_0x52a592(0x940)]?this[_0x52a592(0x1588)+_0x52a592(0x11fe)]=_0x17a022['KNcwN']:this[_0x52a592(0x1588)+_0x52a592(0x11fe)]=_0x17a022[_0x52a592(0xbff)]);}}}}}}},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x177)+'requestBal'+_0xe90fac(0xe69)]=Game_Temp[_0xe90fac(0x510)][_0xe90fac(0x37e)+_0xe90fac(0xe69)],Game_Temp[_0xe90fac(0x510)][_0xe90fac(0x37e)+_0xe90fac(0xe69)]=function(_0x51c47d,_0x4a0460){const _0x18c25c=_0xe90fac;SceneManager[_0x18c25c(0x11be)+_0x18c25c(0x3ad)]()?this[_0x18c25c(0x6e6)+'tleBalloon'](_0x51c47d,_0x4a0460):VisuMZ['BattleCore'][_0x18c25c(0x177)+_0x18c25c(0x37e)+_0x18c25c(0xe69)]['call'](this,_0x51c47d,_0x4a0460);},Game_Temp[_0xe90fac(0x510)]['requestBat'+'tleBalloon']=function(_0x344fee,_0x58936f){const _0x34d341=_0xe90fac,_0x2a0e5f={'target':_0x344fee,'balloonId':_0x58936f};this[_0x34d341(0xf2a)+'loonQueue']=this[_0x34d341(0xf2a)+_0x34d341(0x10b5)]||[],this[_0x34d341(0xf2a)+'loonQueue'][_0x34d341(0x15f1)](_0x2a0e5f);},Game_Temp[_0xe90fac(0x510)][_0xe90fac(0x1de)+'ttleBalloo'+'n']=function(){const _0x21c9e1=_0xe90fac;return this[_0x21c9e1(0xf2a)+_0x21c9e1(0x10b5)]=this[_0x21c9e1(0xf2a)+_0x21c9e1(0x10b5)]||[],this[_0x21c9e1(0xf2a)+_0x21c9e1(0x10b5)]['shift']();},Game_Temp[_0xe90fac(0x510)][_0xe90fac(0x149b)+_0xe90fac(0xad0)]=function(){const _0x245219=_0xe90fac;this[_0x245219(0xf2a)+'loonQueue']=[];},Spriteset_Battle['prototype'][_0xe90fac(0xc88)+_0xe90fac(0xd62)]=function(){const _0xe1030c=_0xe90fac,_0x2dc27d={'iIQnn':function(_0x17c966,_0x3e684a){return _0x17c966===_0x3e684a;}};_0x2dc27d[_0xe1030c(0xc7f)](this['_battleBal'+'loonSprite'+'s'],undefined)&&(this['_battleBal'+_0xe1030c(0x11a)+'s']=[]);for(const _0x2dfd4e of this[_0xe1030c(0xf2a)+_0xe1030c(0x11a)+'s']){!_0x2dfd4e[_0xe1030c(0x12d)]()&&this[_0xe1030c(0x11d2)+_0xe1030c(0x14c7)](_0x2dfd4e);}this['processBat'+_0xe1030c(0xc4)+_0xe1030c(0x919)]();},Spriteset_Battle[_0xe90fac(0x510)]['processBat'+_0xe90fac(0xc4)+_0xe90fac(0x919)]=function(){const _0x30ce53=_0xe90fac;for(;;){const _0x6b7953=$gameTemp[_0x30ce53(0x1de)+_0x30ce53(0xe4b)+'n']();if(_0x6b7953)this[_0x30ce53(0x4e3)+_0x30ce53(0x14c7)](_0x6b7953);else break;}},Spriteset_Battle[_0xe90fac(0x510)][_0xe90fac(0x4e3)+_0xe90fac(0x14c7)]=function(_0x2eca7e){const _0x47ef97=_0xe90fac,_0x5b1205=this['findTarget'+_0x47ef97(0x15e6)](_0x2eca7e['target']);if(_0x5b1205){let _0x35b3c6=null;Imported[_0x47ef97(0x114d)+_0x47ef97(0xc69)+'s']&&Array[_0x47ef97(0x130)](_0x2eca7e['balloonId'])?_0x35b3c6=new Sprite_IconBalloon():_0x35b3c6=new Sprite_Balloon(),_0x35b3c6[_0x47ef97(0x73a)+'ct']=_0x2eca7e[_0x47ef97(0xafd)],_0x35b3c6[_0x47ef97(0x146b)]=_0x5b1205,_0x35b3c6[_0x47ef97(0x146b)][_0x47ef97(0x24b)]=_0x5b1205,_0x35b3c6[_0x47ef97(0xc70)](_0x5b1205,_0x2eca7e[_0x47ef97(0xefd)]),BattleManager[_0x47ef97(0xe5b)+'UiContaine'+'r'](_0x35b3c6),this[_0x47ef97(0xf2a)+_0x47ef97(0x11a)+'s']['push'](_0x35b3c6);}},Spriteset_Battle[_0xe90fac(0x510)][_0xe90fac(0x11d2)+_0xe90fac(0x14c7)]=function(_0x1b920a){const _0x1a328f=_0xe90fac;this[_0x1a328f(0xf2a)+'loonSprite'+'s'][_0x1a328f(0x8a4)](_0x1b920a),BattleManager[_0x1a328f(0xf46)+_0x1a328f(0x131e)+_0x1a328f(0x257)](_0x1b920a),_0x1b920a[_0x1a328f(0x851)]();},Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0xe9a)+'Pose']=function(_0xf46c21,_0x9d4c2c){},Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0x43b)+'8dir']=function(){return![];},Spriteset_Battle[_0xe90fac(0x510)][_0xe90fac(0x729)+_0xe90fac(0x4ea)+_0xe90fac(0x157d)]=function(){const _0x17c699=_0xe90fac,_0x9a1b18={'fPqQh':function(_0x144dd0,_0x3eaa49){return _0x144dd0>_0x3eaa49;}};return this['_battleBal'+_0x17c699(0x11a)+'s']=this[_0x17c699(0xf2a)+_0x17c699(0x11a)+'s']||[],_0x9a1b18[_0x17c699(0x1586)](this[_0x17c699(0xf2a)+_0x17c699(0x11a)+'s'][_0x17c699(0x1268)],0x32f+0x169+-0x498);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x46b)+_0xe90fac(0xe94)+'ze']=Game_System['prototype']['initialize'],Game_System['prototype'][_0xe90fac(0xc68)]=function(){const _0x5ea601=_0xe90fac;VisuMZ[_0x5ea601(0x118f)][_0x5ea601(0x46b)+_0x5ea601(0xe94)+'ze'][_0x5ea601(0x351)](this),this[_0x5ea601(0xdae)+_0x5ea601(0x126e)]();},Game_System['prototype'][_0xe90fac(0xdae)+_0xe90fac(0x126e)]=function(){const _0x3dacc0=_0xe90fac;this[_0x3dacc0(0x39d)+'nemies']=this[_0x3dacc0(0x39d)+_0x3dacc0(0x1243)]||[];},Game_System[_0xe90fac(0x510)][_0xe90fac(0x9c2)+_0xe90fac(0x1436)]=function(){const _0x493d48=_0xe90fac,_0x236a1f={'cumto':function(_0x1840d9,_0x336131){return _0x1840d9===_0x336131;}};if(_0x236a1f['cumto'](this['_defeatedE'+_0x493d48(0x1243)],undefined))this[_0x493d48(0xdae)+_0x493d48(0x126e)]();return this[_0x493d48(0x39d)+'nemies'];},Game_System[_0xe90fac(0x510)][_0xe90fac(0x770)+'featedEnem'+'y']=function(_0x1e9c74){const _0x41b1ce=_0xe90fac,_0x293b40={'MFGxr':_0x41b1ce(0xf02),'hnAPC':function(_0x354eb2,_0x4a514e){return _0x354eb2===_0x4a514e;}},_0x20e1f1=_0x293b40[_0x41b1ce(0x419)][_0x41b1ce(0xab1)]('|');let _0x2124c3=0x1*0x9e6+0x1de*-0x9+-0xd*-0x88;while(!![]){switch(_0x20e1f1[_0x2124c3++]){case'0':this[_0x41b1ce(0x39d)+_0x41b1ce(0x1243)]['sort']((_0x4ca323,_0x3c08ee)=>_0x4ca323-_0x3c08ee);continue;case'1':if(_0x293b40['hnAPC'](this[_0x41b1ce(0x39d)+_0x41b1ce(0x1243)],undefined))this[_0x41b1ce(0xdae)+_0x41b1ce(0x126e)]();continue;case'2':if(this[_0x41b1ce(0x39d)+_0x41b1ce(0x1243)][_0x41b1ce(0x79c)](_0x1e9c74))return;continue;case'3':this[_0x41b1ce(0x39d)+'nemies']['push'](_0x1e9c74);continue;case'4':if(!_0x1e9c74)return;continue;}break;}},VisuMZ[_0xe90fac(0x118f)]['Game_Battl'+_0xe90fac(0x181)+_0xe90fac(0x162)]=Game_BattlerBase[_0xe90fac(0x510)][_0xe90fac(0x7e5)+'e'],Game_BattlerBase['prototype'][_0xe90fac(0x7e5)+'e']=function(_0x28a727){const _0x8938ed=_0xe90fac,_0xcaad82={'tgeJM':function(_0x1fc622,_0x19e245){return _0x1fc622!==_0x19e245;}},_0x47cfbb=this[_0x8938ed(0xb30)](),_0x3ff040=this[_0x8938ed(0x881)+_0x8938ed(0x84a)]();VisuMZ['BattleCore']['Game_Battl'+_0x8938ed(0x181)+'NewState'][_0x8938ed(0x351)](this,_0x28a727),this['isEnemy']()&&_0x47cfbb&&this[_0x8938ed(0x17d)]()&&(this[_0x8938ed(0x557)+_0x8938ed(0xc17)+_0x8938ed(0x4f3)]=!this['hasBeenDef'+_0x8938ed(0x7cd)+'e'](),$gameSystem[_0x8938ed(0x770)+'featedEnem'+'y'](this[_0x8938ed(0x999)]())),SceneManager[_0x8938ed(0x11be)+_0x8938ed(0x3ad)]()&&_0xcaad82[_0x8938ed(0x1072)](_0x3ff040,this[_0x8938ed(0x881)+_0x8938ed(0x84a)]())&&(this[_0x8938ed(0x81d)]()&&this[_0x8938ed(0x81d)]()['refreshMot'+_0x8938ed(0x130a)]());},Game_Enemy[_0xe90fac(0x510)]['hasBeenDef'+_0xe90fac(0x7cd)+'e']=function(){const _0x28f609=_0xe90fac;return $gameSystem['getDefeate'+'dEnemies']()['includes'](this[_0x28f609(0xbf6)]);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x6e8)+_0xe90fac(0x15de)+'seState']=Game_BattlerBase[_0xe90fac(0x510)][_0xe90fac(0x176)],Game_BattlerBase['prototype'][_0xe90fac(0x176)]=function(_0x5b7c89){const _0x36db87=_0xe90fac,_0x3d422b={'mKdmY':function(_0xc17654,_0x44b69a){return _0xc17654===_0x44b69a;}};VisuMZ[_0x36db87(0x118f)][_0x36db87(0x6e8)+_0x36db87(0x15de)+_0x36db87(0x980)][_0x36db87(0x351)](this,_0x5b7c89),this['isEnemy']()&&_0x3d422b['mKdmY'](_0x5b7c89,this[_0x36db87(0xfb8)+'Id']())&&this[_0x36db87(0xb30)]()&&(this[_0x36db87(0x557)+_0x36db87(0xc17)+'ied']=![]),!this[_0x36db87(0x170)]&&!this[_0x36db87(0x1404)+'er']&&SceneManager['isSceneBat'+_0x36db87(0x3ad)]()&&this[_0x36db87(0xa08)+'ionRefresh']();},VisuMZ[_0xe90fac(0x118f)]['Game_Actio'+_0xe90fac(0x137d)]=Game_Action[_0xe90fac(0x510)][_0xe90fac(0xf98)],Game_Action[_0xe90fac(0x510)]['clear']=function(){const _0x22d47f=_0xe90fac,_0x3c6b18={'GgqMV':'4|3|0|1|2','GuCKn':_0x22d47f(0x142c)},_0x275bc9=_0x3c6b18['GgqMV']['split']('|');let _0x544f88=0x1*0x132f+0xdf0+0x211f*-0x1;while(!![]){switch(_0x275bc9[_0x544f88++]){case'0':this[_0x22d47f(0x4a0)+'rs']={'criticalHitRate':0x1,'criticalHitFlat':0x0,'criticalDmgRate':0x1,'criticalDmgFlat':0x0,'damageRate':0x1,'damageFlat':0x0,'hitRate':0x1,'hitFlat':0x0};continue;case'1':this['_customDam'+_0x22d47f(0x98d)]=_0x3c6b18[_0x22d47f(0x9b1)];continue;case'2':this[_0x22d47f(0x13bb)+'tBattlerKe'+'y']();continue;case'3':this[_0x22d47f(0xa2)+'tration']={'arPenRate':0x0,'arPenFlat':0x0,'arRedRate':0x0,'arRedFlat':0x0};continue;case'4':VisuMZ[_0x22d47f(0x118f)][_0x22d47f(0xf8b)+_0x22d47f(0x137d)][_0x22d47f(0x351)](this);continue;}break;}},Game_Action['prototype']['clearTarge'+_0xe90fac(0x819)+'y']=function(){const _0x52724a=_0xe90fac;this['_targetBat'+_0x52724a(0xe80)]='';},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xf8b)+'n_setSubje'+'ct']=Game_Action[_0xe90fac(0x510)][_0xe90fac(0x129)],Game_Action['prototype']['setSubject']=function(_0x1c9588){const _0x4891c2=_0xe90fac;VisuMZ[_0x4891c2(0x118f)][_0x4891c2(0xf8b)+_0x4891c2(0x14f1)+'ct'][_0x4891c2(0x351)](this,_0x1c9588),this[_0x4891c2(0x13bb)+_0x4891c2(0x819)+'y']();},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xf8b)+_0xe90fac(0x6e2)]=Game_Action[_0xe90fac(0x510)]['setSkill'],Game_Action[_0xe90fac(0x510)]['setSkill']=function(_0x5b1227){const _0x2f4cd4=_0xe90fac;VisuMZ[_0x2f4cd4(0x118f)]['Game_Actio'+_0x2f4cd4(0x6e2)]['call'](this,_0x5b1227),this[_0x2f4cd4(0x13bb)+'tBattlerKe'+'y']();},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xf8b)+_0xe90fac(0xb75)]=Game_Action[_0xe90fac(0x510)][_0xe90fac(0x325)],Game_Action[_0xe90fac(0x510)]['setItem']=function(_0x66b10d){const _0x1ef22c=_0xe90fac;VisuMZ[_0x1ef22c(0x118f)][_0x1ef22c(0xf8b)+_0x1ef22c(0xb75)][_0x1ef22c(0x351)](this,_0x66b10d),this[_0x1ef22c(0x13bb)+'tBattlerKe'+'y']();},Game_Action['prototype']['makeDamage'+_0xe90fac(0x68e)]=function(_0x3d6dc6,_0x594980){const _0x432816=_0xe90fac;return VisuMZ[_0x432816(0x118f)][_0x432816(0x281)][_0x432816(0x7d7)][_0x432816(0xaef)+_0x432816(0x751)]['call'](this,_0x3d6dc6,_0x594980);},Game_Action[_0xe90fac(0x510)][_0xe90fac(0x156d)+_0xe90fac(0xed3)]=function(_0x10a089,_0x25b6a9){const _0x22d222=_0xe90fac;return VisuMZ[_0x22d222(0x118f)]['Settings'][_0x22d222(0x7d7)][_0x22d222(0x15b3)+_0x22d222(0x634)]['call'](this,_0x10a089,_0x25b6a9);},Game_Action['prototype'][_0xe90fac(0x112)]=function(_0x2684ff,_0x1c915d){const _0x2d4ccc=_0xe90fac;return VisuMZ[_0x2d4ccc(0x118f)][_0x2d4ccc(0x281)][_0x2d4ccc(0x7d7)][_0x2d4ccc(0xb5f)+_0x2d4ccc(0x6e9)][_0x2d4ccc(0x351)](this,_0x2684ff,_0x1c915d);},VisuMZ['BattleCore']['Game_Actio'+'n_itemHit']=Game_Action['prototype'][_0xe90fac(0x2eb)],Game_Action[_0xe90fac(0x510)]['itemHit']=function(_0x47d08c){const _0x2f1a69=_0xe90fac,_0x21b389={'CEila':function(_0x5498a0,_0x5c602b){return _0x5498a0/_0x5c602b;},'OWfEK':function(_0x79b740,_0x1ffc15){return _0x79b740(_0x1ffc15);},'JqnQf':function(_0x5910ea,_0x228ef6){return _0x5910ea+_0x228ef6;},'rzdhu':function(_0x6ee4d7,_0x2562a5){return _0x6ee4d7*_0x2562a5;}},_0x1ce9ca=this[_0x2f1a69(0xdd)]()[_0x2f1a69(0xfee)];if(_0x1ce9ca['match'](/<ALWAYS HIT>/i))return 0x16dc+0x2669*0x1+-0xa36*0x6;else{if(_0x1ce9ca[_0x2f1a69(0x3eb)](/<ALWAYS HIT RATE: (\d+)([%％])>/i))return _0x21b389['CEila'](_0x21b389['OWfEK'](Number,RegExp['$1']),0x299+0x64b+-0x880);else{let _0x48b64d=VisuMZ[_0x2f1a69(0x118f)][_0x2f1a69(0xf8b)+_0x2f1a69(0xb1d)]['call'](this,_0x47d08c);return _0x48b64d=_0x21b389[_0x2f1a69(0x1fd)](_0x21b389[_0x2f1a69(0xc7a)](this[_0x2f1a69(0x4a0)+'rs']['hitRate'],_0x48b64d),this['_multiplie'+'rs'][_0x2f1a69(0x7a1)]),$gameParty[_0x2f1a69(0x138f)]()&&(_0x48b64d=this[_0x2f1a69(0x1448)+'eCoreHitRa'+_0x2f1a69(0x806)](_0x48b64d,_0x47d08c)),_0x48b64d;}}},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xf8b)+_0xe90fac(0x1311)+'stTarget']=Game_Action[_0xe90fac(0x510)]['updateLast'+_0xe90fac(0xf28)],Game_Action[_0xe90fac(0x510)][_0xe90fac(0xfcc)+_0xe90fac(0xf28)]=function(_0x67f14d){const _0x4edcb7=_0xe90fac;this[_0x4edcb7(0xfb5)+'plyBattleC'+_0x4edcb7(0x24e)+'JS']=!![],VisuMZ[_0x4edcb7(0x118f)]['Game_Actio'+_0x4edcb7(0x1311)+_0x4edcb7(0x64b)][_0x4edcb7(0x351)](this,_0x67f14d),this[_0x4edcb7(0xfb5)+_0x4edcb7(0x1480)+_0x4edcb7(0x24e)+'JS']=undefined;},Game_Action[_0xe90fac(0x510)][_0xe90fac(0xcb0)+_0xe90fac(0xff)+'es']=function(_0x38ddff){const _0x4cc92a=_0xe90fac,_0x1eeffe={'jVZZP':_0x4cc92a(0xb98)+_0x4cc92a(0x1462)},_0x2f6af8=_0x1eeffe[_0x4cc92a(0x517)][_0x4cc92a(0xab1)]('|');let _0x1c91da=0x836*0x1+0x1*-0x100f+-0x11f*-0x7;while(!![]){switch(_0x2f6af8[_0x1c91da++]){case'0':window[_0x4cc92a(0xafd)]=_0x38ddff;continue;case'1':window['a']=this[_0x4cc92a(0xdf5)]();continue;case'2':window['b']=_0x38ddff;continue;case'3':window['item']=this['item']();continue;case'4':window[_0x4cc92a(0xf44)]=this[_0x4cc92a(0xdd)]();continue;case'5':window[_0x4cc92a(0x1575)]=this[_0x4cc92a(0xdd)]();continue;case'6':window['action']=this;continue;case'7':window[_0x4cc92a(0x14f2)]=this[_0x4cc92a(0xdf5)]();continue;}break;}},Game_Action[_0xe90fac(0x510)]['clearGloba'+_0xe90fac(0x13a8)]=function(_0x3bda51){const _0x13160d=_0xe90fac,_0x46c1ab={'pDKUo':_0x13160d(0xdb)+_0x13160d(0x1337)},_0x3636c9=_0x46c1ab[_0x13160d(0x4ac)][_0x13160d(0xab1)]('|');let _0x47c426=-0x1335+-0x28c+0x15c1;while(!![]){switch(_0x3636c9[_0x47c426++]){case'0':window[_0x13160d(0xf44)]=undefined;continue;case'1':window[_0x13160d(0xdb3)]=undefined;continue;case'2':window['b']=undefined;continue;case'3':window['target']=undefined;continue;case'4':window[_0x13160d(0x14f2)]=undefined;continue;case'5':window['a']=undefined;continue;case'6':window[_0x13160d(0xdd)]=undefined;continue;case'7':window['obj']=undefined;continue;}break;}},Game_Action[_0xe90fac(0x510)][_0xe90fac(0x1448)+_0xe90fac(0x11bc)+'teJS']=function(_0x1fbd46,_0x23deba){const _0x6acbb3=_0xe90fac,_0x59cf5b={'ZWamD':_0x6acbb3(0x748),'lecYx':_0x6acbb3(0x748)+_0x6acbb3(0xe8d),'PrXHp':_0x6acbb3(0x748)+_0x6acbb3(0x711)};if(this[_0x6acbb3(0xfb5)+_0x6acbb3(0x1480)+_0x6acbb3(0x24e)+'JS'])return _0x1fbd46;this[_0x6acbb3(0xcb0)+'balVariabl'+'es'](_0x23deba);if(this[_0x6acbb3(0xdd)]()){let _0x387889=VisuMZ[_0x6acbb3(0x118f)]['createKeyJ'+'S'](this['item'](),_0x59cf5b[_0x6acbb3(0x9be)]);VisuMZ[_0x6acbb3(0x118f)]['JS'][_0x387889]&&(_0x1fbd46=VisuMZ['BattleCore']['JS'][_0x387889][_0x6acbb3(0x351)](this,this[_0x6acbb3(0xdf5)](),_0x23deba,this[_0x6acbb3(0xdd)](),_0x1fbd46));}for(const _0xc7df0 of this[_0x6acbb3(0xdf5)]()[_0x6acbb3(0x412)+'ts']()){if(!_0xc7df0)continue;key=VisuMZ['BattleCore']['createKeyJ'+'S'](_0xc7df0,_0x59cf5b['lecYx']),VisuMZ[_0x6acbb3(0x118f)]['JS'][key]&&(_0x1fbd46=VisuMZ['BattleCore']['JS'][key][_0x6acbb3(0x351)](this,this[_0x6acbb3(0xdf5)](),_0x23deba,this[_0x6acbb3(0xdd)](),_0x1fbd46));}for(const _0x52a06a of _0x23deba[_0x6acbb3(0x412)+'ts']()){if(!_0x52a06a)continue;key=VisuMZ[_0x6acbb3(0x118f)][_0x6acbb3(0xc4e)+'S'](_0x52a06a,_0x59cf5b[_0x6acbb3(0x1417)]),VisuMZ[_0x6acbb3(0x118f)]['JS'][key]&&(_0x1fbd46=VisuMZ[_0x6acbb3(0x118f)]['JS'][key][_0x6acbb3(0x351)](this,this['subject'](),_0x23deba,this[_0x6acbb3(0xdd)](),_0x1fbd46));}return this[_0x6acbb3(0x638)+_0x6acbb3(0x13a8)](_0x23deba),_0x1fbd46;},Game_Action[_0xe90fac(0x510)]['itemCri']=function(_0x40264d){const _0x5d3306=_0xe90fac,_0x43d3b6={'Mvarq':function(_0x399b3b,_0x2c7161){return _0x399b3b+_0x2c7161;},'DGdXN':function(_0x56a4ba,_0x4e82e4){return _0x56a4ba*_0x4e82e4;}};if(!this['item']()['damage'][_0x5d3306(0x2af)])return-0x1*0xb9d+0x2351+0x94*-0x29;let _0x2a9ae0=VisuMZ[_0x5d3306(0x118f)]['Settings'][_0x5d3306(0x7d7)][_0x5d3306(0x106b)+_0x5d3306(0x771)][_0x5d3306(0x351)](this,_0x40264d);return _0x2a9ae0=_0x43d3b6[_0x5d3306(0xb23)](_0x43d3b6[_0x5d3306(0x4cc)](this[_0x5d3306(0x4a0)+'rs']['criticalHi'+_0x5d3306(0x622)],_0x2a9ae0),this[_0x5d3306(0x4a0)+'rs'][_0x5d3306(0xaad)+_0x5d3306(0x404)]),$gameParty[_0x5d3306(0x138f)]()&&(_0x2a9ae0=this[_0x5d3306(0x1448)+_0x5d3306(0x12bd)+_0x5d3306(0xfed)+'JS'](_0x2a9ae0,_0x40264d)),_0x2a9ae0;},Game_Action['prototype'][_0xe90fac(0x1448)+_0xe90fac(0x12bd)+_0xe90fac(0xfed)+'JS']=function(_0x227a60,_0x484dc9){const _0x1cd6a7=_0xe90fac,_0x1f1ccd={'YMBCh':function(_0x1a4306,_0x1c4de5){return _0x1a4306(_0x1c4de5);},'fBTMz':function(_0x32b1ac,_0x2fae82){return _0x32b1ac(_0x2fae82);}};this[_0x1cd6a7(0xcb0)+_0x1cd6a7(0xff)+'es'](_0x484dc9),window[_0x1cd6a7(0x104)]=_0x227a60;{const _0x5d7538=this[_0x1cd6a7(0xdf5)]()[_0x1cd6a7(0x412)+'ts']();for(const _0x4ebade of _0x5d7538){if(!_0x4ebade)continue;if(_0x4ebade[_0x1cd6a7(0xfee)][_0x1cd6a7(0x3eb)](/<JS (?:CRITICAL RATE|CRI) AS USER>\s*([\s\S]*?)\s*<\/JS (?:CRITICAL RATE|CRI) AS USER>/i)){const _0x3b7042=_0x1f1ccd['YMBCh'](String,RegExp['$1']);try{_0x1f1ccd['fBTMz'](eval,_0x3b7042);}catch(_0x7562a7){if($gameTemp[_0x1cd6a7(0x13da)]())console[_0x1cd6a7(0xad3)](_0x7562a7);}}}}{const _0x1fe24c=_0x484dc9[_0x1cd6a7(0x412)+'ts']();for(const _0x26f414 of _0x1fe24c){if(!_0x26f414)continue;if(_0x26f414[_0x1cd6a7(0xfee)][_0x1cd6a7(0x3eb)](/<JS (?:CRITICAL RATE|CRI) AS TARGET>\s*([\s\S]*?)\s*<\/JS (?:CRITICAL RATE|CRI) AS TARGET>/i)){const _0x122f80=_0x1f1ccd[_0x1cd6a7(0x61d)](String,RegExp['$1']);try{_0x1f1ccd[_0x1cd6a7(0x61d)](eval,_0x122f80);}catch(_0x227312){if($gameTemp[_0x1cd6a7(0x13da)]())console['log'](_0x227312);}}}}return _0x227a60=window[_0x1cd6a7(0x104)],this[_0x1cd6a7(0x638)+_0x1cd6a7(0x13a8)](_0x484dc9),_0x227a60;},Game_Action[_0xe90fac(0x510)][_0xe90fac(0x1448)+_0xe90fac(0x12bd)+'calHitRate'+'JS']=function(_0x1113a3,_0x36609f){const _0x2ee285=_0xe90fac,_0x7f5961={'LmvIT':_0x2ee285(0x1060)+'AsUser','XKdTw':'jsCritRate'+_0x2ee285(0x711)};this[_0x2ee285(0xcb0)+'balVariabl'+'es'](_0x36609f);for(const _0x3bc0a4 of this[_0x2ee285(0xdf5)]()['traitObjec'+'ts']()){if(!_0x3bc0a4)continue;key=VisuMZ['BattleCore'][_0x2ee285(0xc4e)+'S'](_0x3bc0a4,_0x7f5961[_0x2ee285(0xfea)]),VisuMZ[_0x2ee285(0x118f)]['JS'][key]&&(_0x1113a3=VisuMZ[_0x2ee285(0x118f)]['JS'][key][_0x2ee285(0x351)](this,this[_0x2ee285(0xdf5)](),_0x36609f,this['item'](),_0x1113a3));}for(const _0x209f91 of _0x36609f[_0x2ee285(0x412)+'ts']()){if(!_0x209f91)continue;key=VisuMZ['BattleCore'][_0x2ee285(0xc4e)+'S'](_0x209f91,_0x7f5961[_0x2ee285(0x1223)]),VisuMZ[_0x2ee285(0x118f)]['JS'][key]&&(_0x1113a3=VisuMZ[_0x2ee285(0x118f)]['JS'][key]['call'](this,this[_0x2ee285(0xdf5)](),_0x36609f,this['item'](),_0x1113a3));}return this['clearGloba'+_0x2ee285(0x13a8)](_0x36609f),_0x1113a3;},Game_Action[_0xe90fac(0x510)][_0xe90fac(0x4cd)+_0xe90fac(0x384)]=function(_0x1e6ebf){const _0x341073=_0xe90fac,_0x13519e={'bXdve':function(_0x69e73b,_0x5a24bc){return _0x69e73b+_0x5a24bc;},'omZks':function(_0x25f9ea,_0x4c127c){return _0x25f9ea*_0x4c127c;}};return _0x1e6ebf=VisuMZ[_0x341073(0x118f)]['Settings'][_0x341073(0x7d7)]['CriticalHi'+_0x341073(0x249)+'r'][_0x341073(0x351)](this,_0x1e6ebf),_0x1e6ebf=_0x13519e[_0x341073(0x15cf)](_0x13519e[_0x341073(0xdb9)](this['_multiplie'+'rs']['criticalDm'+_0x341073(0x10e0)],_0x1e6ebf),this[_0x341073(0x4a0)+'rs']['criticalDm'+'gFlat']),_0x1e6ebf;},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xf8b)+_0xe90fac(0xc1b)+_0xe90fac(0x12ae)]=Game_Action[_0xe90fac(0x510)][_0xe90fac(0x14a2)+'Formula'],Game_Action['prototype'][_0xe90fac(0x14a2)+'Formula']=function(_0x1082a1){const _0x10dd10=_0xe90fac,_0x58ef28={'hgYUR':function(_0x82ddf7,_0x42a909){return _0x82ddf7!==_0x42a909;},'zWWcB':_0x10dd10(0x142c),'bAIER':function(_0x2bd97a,_0x1f8421){return _0x2bd97a===_0x1f8421;},'bvTkc':_0x10dd10(0x152b)};if(_0x58ef28[_0x10dd10(0x12f9)](this[_0x10dd10(0x1358)+_0x10dd10(0x98d)],_0x58ef28[_0x10dd10(0x1585)]))return this[_0x10dd10(0x63b)+_0x10dd10(0x12ae)](_0x1082a1);else return _0x58ef28['bAIER'](DataManager[_0x10dd10(0x2d0)+'tyle'](this[_0x10dd10(0xdd)]()),_0x58ef28[_0x10dd10(0x11a0)])?VisuMZ[_0x10dd10(0x118f)][_0x10dd10(0xf8b)+_0x10dd10(0xc1b)+_0x10dd10(0x12ae)][_0x10dd10(0x351)](this,_0x1082a1):this[_0x10dd10(0x14a2)+_0x10dd10(0x635)+'tleCore'](_0x1082a1);},Game_Action[_0xe90fac(0x510)][_0xe90fac(0x83a)+_0xe90fac(0xa00)+'la']=function(_0x1e4f67){const _0x30fdbf=_0xe90fac;this[_0x30fdbf(0x1358)+_0x30fdbf(0x98d)]=_0x1e4f67;},Game_Action['prototype'][_0xe90fac(0x63b)+_0xe90fac(0x12ae)]=function(_0x59342b){const _0x260743=_0xe90fac,_0x2f8335=this[_0x260743(0xdd)](),_0xca22b3=_0x2f8335[_0x260743(0x11df)]['formula'];_0x2f8335[_0x260743(0x11df)][_0x260743(0xbcc)]=this[_0x260743(0x1358)+_0x260743(0x98d)];let _0x7b9250=VisuMZ['BattleCore'][_0x260743(0xf8b)+'n_evalDama'+'geFormula'][_0x260743(0x351)](this,_0x59342b);return _0x2f8335[_0x260743(0x11df)]['formula']=_0xca22b3,_0x7b9250;},Game_Action['prototype'][_0xe90fac(0x13cf)+'e']=function(){const _0x521255=_0xe90fac,_0x2b5ebc={'YnIbx':function(_0x52e981,_0x49bbd5){return _0x52e981(_0x49bbd5);},'XEtUA':_0x521255(0x152b)};if(this['item']()[_0x521255(0xfee)][_0x521255(0x3eb)](/<DAMAGE STYLE:[ ](.*)>/i)){const _0x2a08a8=_0x2b5ebc[_0x521255(0x102d)](String,RegExp['$1'])[_0x521255(0x1318)+'e']()[_0x521255(0x808)]();return _0x2a08a8;}return _0x2b5ebc[_0x521255(0xa55)];},Game_Action[_0xe90fac(0x510)]['evalDamage'+_0xe90fac(0x635)+_0xe90fac(0x80e)]=function(_0x4571d0){const _0x40391c=_0xe90fac,_0x20e788=DataManager[_0x40391c(0x2d0)+'tyle'](this[_0x40391c(0xdd)]()),_0x5cf382=VisuMZ[_0x40391c(0x13f9)+'es'][_0x20e788];try{return _0x5cf382['Formula'][_0x40391c(0x351)](this,_0x4571d0);}catch(_0x2cde9e){if($gameTemp[_0x40391c(0x13da)]())console['log'](_0x2cde9e);return VisuMZ[_0x40391c(0x118f)][_0x40391c(0xf8b)+_0x40391c(0xc1b)+_0x40391c(0x12ae)]['call'](this);}},Game_Action[_0xe90fac(0x510)][_0xe90fac(0xb9d)+_0xe90fac(0x150a)]=function(_0x435b07,_0x2beae7){const _0x5c64f6=_0xe90fac,_0x308881={'AgFBQ':function(_0x1dae39,_0x25929d){return _0x1dae39(_0x25929d);},'mbPIv':function(_0x3e00ed,_0x2b5cdd){return _0x3e00ed(_0x2b5cdd);},'MeFni':function(_0xdea58c,_0x137cee){return _0xdea58c>_0x137cee;}};if(this['isCertainH'+'it']())return _0x2beae7;const _0xedf20c=this[_0x5c64f6(0xdf5)](),_0xf7ee1d=_0x435b07;let _0x3d98c5=[],_0x473176=[];_0x3d98c5[_0x5c64f6(0x15f1)](this[_0x5c64f6(0xa2)+_0x5c64f6(0xe4f)][_0x5c64f6(0xd5f)],this['_armorPene'+_0x5c64f6(0xe4f)][_0x5c64f6(0x317)]),_0x473176['push'](this[_0x5c64f6(0xa2)+_0x5c64f6(0xe4f)][_0x5c64f6(0x87b)],this['_armorPene'+_0x5c64f6(0xe4f)]['arRedRate']);const _0x3f997c=this[_0x5c64f6(0x9f)]()?/<ARMOR REDUCTION:[ ](\d+\.?\d*)>/i:/<MAGIC REDUCTION:[ ](\d+\.?\d*)>/i,_0x41ae84=this['isPhysical']()?/<ARMOR REDUCTION:[ ](\d+\.?\d*)([%％])>/i:/<MAGIC REDUCTION:[ ](\d+\.?\d*)([%％])>/i,_0x1438c3=this['isPhysical']()?/<ARMOR PENETRATION:[ ](\d+\.?\d*)>/i:/<MAGIC PENETRATION:[ ](\d+\.?\d*)>/i,_0x50dcde=this['isPhysical']()?/<ARMOR PENETRATION:[ ](\d+\.?\d*)([%％])>/i:/<MAGIC PENETRATION:[ ](\d+\.?\d*)([%％])>/i;return _0x3d98c5=_0x3d98c5[_0x5c64f6(0x67c)](_0xf7ee1d[_0x5c64f6(0x412)+'ts']()[_0x5c64f6(0x457)](_0x4780b2=>_0x4780b2&&_0x4780b2['note'][_0x5c64f6(0x3eb)](_0x3f997c)?Number(RegExp['$1']):-0x1feb+0x245d+0x1*-0x472)),_0x473176=_0x473176['concat'](_0xf7ee1d['traitObjec'+'ts']()[_0x5c64f6(0x457)](_0x2c2d3b=>_0x2c2d3b&&_0x2c2d3b[_0x5c64f6(0xfee)][_0x5c64f6(0x3eb)](_0x41ae84)?Number(RegExp['$1'])/(-0xf90+-0x1a7*-0xd+-0x587):-0x1f05*0x1+-0x3a1*0x8+-0x3c0d*-0x1)),_0x3d98c5=_0x3d98c5[_0x5c64f6(0x67c)](_0xedf20c[_0x5c64f6(0x412)+'ts']()[_0x5c64f6(0x457)](_0x2598fc=>_0x2598fc&&_0x2598fc[_0x5c64f6(0xfee)][_0x5c64f6(0x3eb)](_0x1438c3)?Number(RegExp['$1']):0x25e3+-0xa65*-0x1+-0x26a*0x14)),_0x473176=_0x473176[_0x5c64f6(0x67c)](_0xedf20c['traitObjec'+'ts']()['map'](_0x3fb60f=>_0x3fb60f&&_0x3fb60f['note'][_0x5c64f6(0x3eb)](_0x50dcde)?Number(RegExp['$1'])/(-0x1b47+0x1cd*0x2+-0x1*-0x1811):0x2*-0x1160+-0x70*0x37+0x3ad0)),this['item']()[_0x5c64f6(0xfee)][_0x5c64f6(0x3eb)](_0x1438c3)&&_0x3d98c5['push'](_0x308881[_0x5c64f6(0xcdc)](Number,RegExp['$1'])),this['item']()[_0x5c64f6(0xfee)][_0x5c64f6(0x3eb)](_0x50dcde)&&_0x473176[_0x5c64f6(0x15f1)](_0x308881[_0x5c64f6(0x1178)](Number,RegExp['$1'])),_0x2beae7=_0x3d98c5['reduce']((_0x1dff7b,_0x28b074)=>_0x1dff7b-_0x28b074,_0x2beae7),_0x308881['MeFni'](_0x2beae7,-0x2f5*-0x5+0x2001+-0x2eca)&&(_0x2beae7=_0x473176[_0x5c64f6(0x1313)]((_0xda9c0a,_0x117740)=>_0xda9c0a*(-0xe3a*-0x2+-0xff2+-0x123*0xb-_0x117740),_0x2beae7)),_0x2beae7;},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xf8b)+_0xe90fac(0x6d1)+'amage']=Game_Action[_0xe90fac(0x510)][_0xe90fac(0x603)+_0xe90fac(0x154d)],Game_Action[_0xe90fac(0x510)][_0xe90fac(0x603)+'age']=function(_0x38c172,_0x4f195a){const _0xb45cea=_0xe90fac,_0x570356={'cvaZW':_0xb45cea(0x14ef)+_0xb45cea(0x5e0),'oIDxv':function(_0x60e498,_0x5bf45c){return _0x60e498>_0x5bf45c;},'sWviO':_0xb45cea(0x8e5)+_0xb45cea(0x1280),'mOLAD':function(_0x4395a7,_0x193f4d){return _0x4395a7*_0x193f4d;},'xREmq':function(_0x35d9ce,_0x1ab89a){return _0x35d9ce>=_0x1ab89a;},'nzeeJ':function(_0x17b687,_0x13dfed){return _0x17b687*_0x13dfed;},'LDHJP':_0xb45cea(0xabf)+'1JS'},_0x2c524a=_0x570356['cvaZW'][_0xb45cea(0xab1)]('|');let _0x424ce4=-0xe*-0x253+-0x1cc9+-0x3c1;while(!![]){switch(_0x2c524a[_0x424ce4++]){case'0':_0x570356[_0xb45cea(0x8f0)](_0x4f195a,0x89b+-0x11a1*0x1+0x906)?_0x4f195a=Math[_0xb45cea(0x964)](_0x4f195a):_0x4f195a=Math['floor'](_0x4f195a);continue;case'1':this[_0xb45cea(0x1448)+_0xb45cea(0xa6e)](_0x570356[_0xb45cea(0x40f)],_0x38c172,_0x4f195a,!![]);continue;case'2':VisuMZ[_0xb45cea(0x118f)][_0xb45cea(0xf8b)+'n_executeD'+_0xb45cea(0x970)][_0xb45cea(0x351)](this,_0x38c172,_0x4f195a);continue;case'3':_0x4f195a+=_0x570356[_0xb45cea(0x10c2)](this[_0xb45cea(0x4a0)+'rs'][_0xb45cea(0x136)],_0x570356[_0xb45cea(0x391)](_0x4f195a,0xdec+-0x91e+-0x4ce)?-0x2636*-0x1+-0x1c28+-0xa0d:-(-0x1*0x21a6+-0x6b*0x4f+0x42ac));continue;case'4':_0x4f195a=_0x570356[_0xb45cea(0x5c4)](_0x4f195a,this[_0xb45cea(0x4a0)+'rs'][_0xb45cea(0x1079)]);continue;case'5':_0x4f195a=this[_0xb45cea(0xf63)+_0xb45cea(0x73b)](_0x4f195a);continue;case'6':this[_0xb45cea(0x12e7)+'alue']=_0x4f195a;continue;case'7':this[_0xb45cea(0xe3f)+'e']+=_0x4f195a;continue;case'8':_0x4f195a=this[_0xb45cea(0x1448)+_0xb45cea(0xa6e)](_0x570356[_0xb45cea(0x662)],_0x38c172,_0x4f195a,![]);continue;case'9':this[_0xb45cea(0xe3f)+'e']=this[_0xb45cea(0xe3f)+'e']||0x694+0x14*0x191+-0x25e8;continue;}break;}},Game_Action[_0xe90fac(0x510)]['applyDamag'+'eCaps']=function(_0x5678f5){const _0x3cf3b0=_0xe90fac;if(this[_0x3cf3b0(0x23f)+_0x3cf3b0(0x7f6)]())return _0x5678f5;return _0x5678f5=this[_0x3cf3b0(0x140c)+'amageCap'](_0x5678f5),_0x5678f5=this['applyHardD'+_0x3cf3b0(0x12db)](_0x5678f5),_0x5678f5;},Game_Action[_0xe90fac(0x510)][_0xe90fac(0x23f)+'mageCap']=function(){const _0x2be59f=_0xe90fac,_0x1229cd=/<BYPASS DAMAGE CAP>/i;if(this[_0x2be59f(0xdd)]()[_0x2be59f(0xfee)]['match'](_0x1229cd))return!![];if(this[_0x2be59f(0xdf5)]()[_0x2be59f(0x412)+'ts']()[_0x2be59f(0xcaa)](_0x1daffd=>_0x1daffd&&_0x1daffd[_0x2be59f(0xfee)][_0x2be59f(0x3eb)](_0x1229cd)))return!![];return!VisuMZ[_0x2be59f(0x118f)]['Settings']['Damage'][_0x2be59f(0x1392)+_0x2be59f(0x24a)];},Game_Action['prototype']['applySoftD'+_0xe90fac(0x12db)]=function(_0x20f659){const _0x35a32a=_0xe90fac,_0x4db690={'GhhgI':function(_0x2ce79a,_0x2a347b){return _0x2ce79a<_0x2a347b;},'bVOKf':function(_0x42aedf,_0x22b260){return _0x42aedf/_0x22b260;},'lTvbd':function(_0x526130,_0x1e3bd5){return _0x526130(_0x1e3bd5);},'GSuRj':function(_0x465b39,_0x4b766b){return _0x465b39*_0x4b766b;},'suVsb':function(_0x5e9a75,_0x2eca42){return _0x5e9a75>_0x2eca42;},'tGsRn':function(_0x4956af,_0xfa250e){return _0x4956af>_0xfa250e;},'ZPxYK':function(_0x4e3389,_0x5b272a){return _0x4e3389-_0x5b272a;},'HLudU':function(_0x16eb53,_0x1daee4){return _0x16eb53+_0x1daee4;},'LtKch':function(_0x4f62bd,_0x1141ad){return _0x4f62bd*_0x1141ad;},'tCqyR':function(_0x1ec701,_0xedcd4a){return _0x1ec701-_0xedcd4a;}};if(!VisuMZ[_0x35a32a(0x118f)][_0x35a32a(0x281)][_0x35a32a(0x7d7)]['EnableSoft'+_0x35a32a(0xd3d)])return _0x20f659;const _0x1b9c6e=/<BYPASS SOFT DAMAGE CAP>/i;if(this[_0x35a32a(0xdd)]()[_0x35a32a(0xfee)][_0x35a32a(0x3eb)](_0x1b9c6e))return _0x20f659;if(this[_0x35a32a(0xdf5)]()[_0x35a32a(0x412)+'ts']()[_0x35a32a(0xcaa)](_0x6948d7=>_0x6948d7&&_0x6948d7[_0x35a32a(0xfee)][_0x35a32a(0x3eb)](_0x1b9c6e)))return _0x20f659;const _0x3db796=_0x4db690[_0x35a32a(0xd1b)](_0x20f659,0x461*-0x1+0x5*-0xa9+0x7ae)?-(0x1*0x6d2+-0x17e3+-0x36a*-0x5):0xce0+-0x3*0x696+-0x1*-0x6e3;_0x20f659=Math['abs'](_0x20f659);let _0x29d441=this[_0x35a32a(0xdf5)]()['softDamage'+_0x35a32a(0x103d)]();this[_0x35a32a(0xdd)]()[_0x35a32a(0xfee)]['match'](/<SOFT DAMAGE CAP:[ ]([\+\-]\d+)([%％])>/i)&&(_0x29d441+=_0x4db690[_0x35a32a(0x10ee)](_0x4db690['lTvbd'](Number,RegExp['$1']),0xab4+0x26d5+0x223*-0x17));_0x29d441=_0x29d441['clamp'](0xd0b+0x16*-0x17+-0xb11+0.01,-0x1*-0x209c+-0x1a26*-0x1+-0x3ac1);const _0x1ef69c=this[_0x35a32a(0x77e)+'ageCap'](),_0x189c86=_0x4db690[_0x35a32a(0x2ac)](_0x29d441,_0x1ef69c);if(_0x4db690[_0x35a32a(0x130f)](_0x20f659,_0x189c86)&&_0x4db690[_0x35a32a(0xfec)](_0x1ef69c,_0x189c86)){_0x20f659-=_0x189c86;const _0x5a2b1f=VisuMZ['BattleCore'][_0x35a32a(0x281)][_0x35a32a(0x7d7)][_0x35a32a(0xe3b)+_0x35a32a(0x13d4)],_0x7bfa79=Math['max'](_0x4db690[_0x35a32a(0xb06)](0x29*-0x1e+0xc0*0x24+-0x12b*0x13,_0x4db690[_0x35a32a(0x10ee)](_0x20f659,_0x4db690[_0x35a32a(0x129e)](_0x4db690[_0x35a32a(0x1566)](_0x4db690['tCqyR'](_0x1ef69c,_0x189c86),_0x5a2b1f),_0x20f659))),0x1*0x24e9+-0xa8c+-0x1a5d+0.01);_0x20f659*=_0x7bfa79,_0x20f659+=_0x189c86;}return _0x4db690[_0x35a32a(0x2ac)](_0x20f659,_0x3db796);},Game_Action[_0xe90fac(0x510)][_0xe90fac(0x77e)+_0xe90fac(0x230)]=function(){const _0x5046e5=_0xe90fac,_0x110962={'mvpEJ':function(_0x2bb4d0,_0x577bf1){return _0x2bb4d0(_0x577bf1);}};return this[_0x5046e5(0xdd)]()[_0x5046e5(0xfee)][_0x5046e5(0x3eb)](/<DAMAGE CAP:[ ](\d+)>/i)?_0x110962[_0x5046e5(0xce1)](Number,RegExp['$1']):this[_0x5046e5(0xdf5)]()[_0x5046e5(0xae6)+_0x5046e5(0xd3d)]();},Game_Action['prototype'][_0xe90fac(0x663)+_0xe90fac(0x12db)]=function(_0x1aa390){const _0xf2d550=_0xe90fac;let _0x4bfde9=this[_0xf2d550(0x77e)+_0xf2d550(0x230)]();return _0x1aa390['clamp'](-_0x4bfde9,_0x4bfde9);},Game_Action[_0xe90fac(0x510)]['shouldDisp'+_0xe90fac(0x1229)]=function(){const _0x12d1ed=_0xe90fac;if(!this[_0x12d1ed(0xdd)]())return![];if(!$gameParty['inBattle']())return![];return(this[_0x12d1ed(0xdd)]()[_0x12d1ed(0xfee)]||'')[_0x12d1ed(0x3eb)](/<DISPERSE DAMAGE>/i);},Game_Action[_0xe90fac(0x510)][_0xe90fac(0x121)+_0xe90fac(0x343)]=function(_0x2787c1){const _0x1f3f2d=_0xe90fac,_0xcc5755={'wEqCx':function(_0x45d0ed,_0x312e5f){return _0x45d0ed+_0x312e5f;},'jpXas':function(_0x6cef64,_0x3ca5fd){return _0x6cef64>_0x3ca5fd;}};if(this[_0x1f3f2d(0x1384)+'erseDamage']()){let _0x170524=BattleManager[_0x1f3f2d(0x12dd)];_0x2787c1/=_0x170524[_0x1f3f2d(0x1268)],this['isAttack']()&&(_0x2787c1*=_0xcc5755[_0x1f3f2d(0x5a1)](this['subject']()[_0x1f3f2d(0xef7)+_0x1f3f2d(0xb1a)](),0x1dfa+0x72e+-0x2527)),_0x2787c1=_0xcc5755['jpXas'](_0x2787c1,-0x1b0a*0x1+0x12fb+0x1*0x80f)?Math[_0x1f3f2d(0x964)](_0x2787c1):Math[_0x1f3f2d(0x12be)](_0x2787c1);}return _0x2787c1;},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xf8b)+'n_makeDama'+_0xe90fac(0xd93)+_0xe90fac(0x1020)]=Game_Action[_0xe90fac(0x510)][_0xe90fac(0x9bb)+_0xe90fac(0x68e)],Game_Action[_0xe90fac(0x510)][_0xe90fac(0x9bb)+_0xe90fac(0x68e)]=function(_0x49f71e,_0x4c762f){const _0x4a768b=_0xe90fac;let _0x2644c9=VisuMZ[_0x4a768b(0x118f)]['Game_Actio'+'n_makeDama'+'geValueDis'+_0x4a768b(0x1020)][_0x4a768b(0x351)](this,_0x49f71e,_0x4c762f);return this[_0x4a768b(0x121)+'mage'](_0x2644c9);},Game_Action[_0xe90fac(0x510)]['itemEffect'+_0xe90fac(0x1149)]=function(_0x5a2894,_0x3bdad3){const _0x17ed1f=_0xe90fac,_0x4a32ec={'lUFXG':function(_0x5c7602,_0x27e926){return _0x5c7602*_0x27e926;},'utzdn':function(_0x22703b,_0x1f0ecf){return _0x22703b+_0x1f0ecf;},'BccIO':function(_0xd8e8f6,_0x504863){return _0xd8e8f6!==_0x504863;}};let _0x5efef1=_0x4a32ec['lUFXG'](_0x4a32ec['utzdn'](_0x4a32ec[_0x17ed1f(0x11e4)](_0x5a2894['mhp'],_0x3bdad3[_0x17ed1f(0x9a0)]),_0x3bdad3[_0x17ed1f(0xf4c)]),_0x5a2894[_0x17ed1f(0xae3)]);_0x5efef1=this[_0x17ed1f(0x121)+_0x17ed1f(0x343)](_0x5efef1),this[_0x17ed1f(0x1485)]()&&(_0x5efef1*=this[_0x17ed1f(0xdf5)]()[_0x17ed1f(0x7c3)]),_0x5efef1=Math[_0x17ed1f(0x12be)](_0x5efef1),_0x4a32ec[_0x17ed1f(0x6a7)](_0x5efef1,-0x659+0x2134+-0x5*0x55f)&&(_0x5a2894[_0x17ed1f(0xc04)](_0x5efef1),this[_0x17ed1f(0x136f)+'s'](_0x5a2894));},Game_Action[_0xe90fac(0x510)]['itemEffect'+_0xe90fac(0xc6b)]=function(_0x474b93,_0x37ef4f){const _0x3fc861=_0xe90fac,_0x562d9b={'UdZrJ':function(_0x4a1d99,_0x3d66a4){return _0x4a1d99*_0x3d66a4;},'MWCLS':function(_0x5ce6bd,_0x15760b){return _0x5ce6bd+_0x15760b;},'NtqfO':function(_0x31607d,_0x4d0c6d){return _0x31607d!==_0x4d0c6d;}};let _0x3c8e43=_0x562d9b[_0x3fc861(0x1104)](_0x562d9b[_0x3fc861(0x154c)](_0x562d9b['UdZrJ'](_0x474b93['mmp'],_0x37ef4f[_0x3fc861(0x9a0)]),_0x37ef4f['value2']),_0x474b93[_0x3fc861(0xae3)]);_0x3c8e43=this[_0x3fc861(0x121)+'mage'](_0x3c8e43),this[_0x3fc861(0x1485)]()&&(_0x3c8e43*=this[_0x3fc861(0xdf5)]()[_0x3fc861(0x7c3)]),_0x3c8e43=Math[_0x3fc861(0x12be)](_0x3c8e43),_0x562d9b[_0x3fc861(0x90d)](_0x3c8e43,0x1d07*0x1+0x1*-0x25d1+0x8ca)&&(_0x474b93[_0x3fc861(0x1015)](_0x3c8e43),this[_0x3fc861(0x136f)+'s'](_0x474b93));},Game_Action['prototype'][_0xe90fac(0x10eb)+_0xe90fac(0xb69)]=function(_0x1131cf,_0x5e3ca3){const _0xd73414=_0xe90fac,_0x4108d0={'BJYHa':function(_0x708569,_0xbce51e){return _0x708569!==_0xbce51e;}};let _0x4a43de=Math[_0xd73414(0x12be)](_0x5e3ca3['value1']);_0x4a43de=this[_0xd73414(0x121)+_0xd73414(0x343)](_0x4a43de),_0x4108d0[_0xd73414(0xd87)](_0x4a43de,0xc48+0x64a*-0x1+0x76*-0xd)&&(_0x1131cf[_0xd73414(0xe56)](_0x4a43de),this['makeSucces'+'s'](_0x1131cf));},VisuMZ[_0xe90fac(0x118f)]['Game_Actio'+'n_apply']=Game_Action['prototype'][_0xe90fac(0x957)],Game_Action['prototype'][_0xe90fac(0x957)]=function(_0x1d20ea){const _0x29fdfa=_0xe90fac,_0x4cf6e4={'YtTlH':'2|0|4|1|3','tGBXe':'PreApply%1'+'JS','rycjv':_0x29fdfa(0xfa9)+_0x29fdfa(0xe20)},_0x5c4c41=_0x4cf6e4[_0x29fdfa(0xa49)]['split']('|');let _0x17cc9c=0x1*0x155c+-0xb7*0x5+-0x11c9*0x1;while(!![]){switch(_0x5c4c41[_0x17cc9c++]){case'0':this[_0x29fdfa(0x1448)+'eCoreJS'](_0x4cf6e4[_0x29fdfa(0xa38)],_0x1d20ea,0xea3+-0x1470+-0x87*-0xb,!![]);continue;case'1':this[_0x29fdfa(0x1448)+_0x29fdfa(0xa6e)](_0x4cf6e4[_0x29fdfa(0x117)],_0x1d20ea,this[_0x29fdfa(0x12e7)+'alue']||-0x208f+0x1*-0x1786+0x3815,!![]);continue;case'2':if(_0x1d20ea&&_0x1d20ea[_0x29fdfa(0xb9a)]())_0x1d20ea[_0x29fdfa(0x100)+_0x29fdfa(0xf55)+_0x29fdfa(0x798)]();continue;case'3':this[_0x29fdfa(0x7bf)+_0x29fdfa(0xe39)](_0x1d20ea);continue;case'4':VisuMZ[_0x29fdfa(0x118f)][_0x29fdfa(0xf8b)+_0x29fdfa(0x498)][_0x29fdfa(0x351)](this,_0x1d20ea);continue;}break;}},Game_Action[_0xe90fac(0x510)]['applyBattl'+_0xe90fac(0xa6e)]=function(_0x32af60,_0x149871,_0x3bf778,_0x50b5b2){const _0x5542e2=_0xe90fac,_0x4dba1a={'ZlGMS':function(_0x3ce1e5,_0x26d776){return _0x3ce1e5||_0x26d776;},'IootC':'AsUser','qyQCw':'AsTarget'};if(this['_tempBattl'+'er']||this[_0x5542e2(0x170)])return;_0x3bf778=_0x4dba1a[_0x5542e2(0x364)](_0x3bf778,0xd67+0x4bb+0xb*-0x1a6);const _0x5e0318=_0x3bf778,_0x2840af=VisuMZ[_0x5542e2(0x118f)][_0x5542e2(0x281)][_0x5542e2(0x7dd)],_0x1c11cf=_0x32af60[_0x5542e2(0xeb8)]('');if(_0x2840af[_0x1c11cf]){_0x3bf778=_0x2840af[_0x1c11cf]['call'](this,_0x3bf778,_0x149871);if(_0x50b5b2)_0x3bf778=_0x5e0318;}let _0xb71c3c=VisuMZ['BattleCore']['createKeyJ'+'S'](this[_0x5542e2(0xdd)](),_0x32af60['format'](''));if(VisuMZ[_0x5542e2(0x118f)]['JS'][_0xb71c3c]){_0x3bf778=VisuMZ[_0x5542e2(0x118f)]['JS'][_0xb71c3c][_0x5542e2(0x351)](this,this['subject'](),_0x149871,this['item'](),_0x3bf778);if(_0x50b5b2)_0x3bf778=_0x5e0318;}for(const _0x564ddf of this['subject']()[_0x5542e2(0x412)+'ts']()){if(!_0x564ddf)continue;_0xb71c3c=VisuMZ[_0x5542e2(0x118f)]['createKeyJ'+'S'](_0x564ddf,_0x32af60[_0x5542e2(0xeb8)](_0x4dba1a[_0x5542e2(0x13df)]));if(VisuMZ[_0x5542e2(0x118f)]['JS'][_0xb71c3c]){_0x3bf778=VisuMZ[_0x5542e2(0x118f)]['JS'][_0xb71c3c][_0x5542e2(0x351)](this,this[_0x5542e2(0xdf5)](),_0x149871,_0x564ddf,_0x3bf778);if(_0x50b5b2)_0x3bf778=_0x5e0318;}}for(const _0x5b5531 of _0x149871[_0x5542e2(0x412)+'ts']()){if(!_0x5b5531)continue;_0xb71c3c=VisuMZ[_0x5542e2(0x118f)][_0x5542e2(0xc4e)+'S'](_0x5b5531,_0x32af60[_0x5542e2(0xeb8)](_0x4dba1a['qyQCw']));if(VisuMZ[_0x5542e2(0x118f)]['JS'][_0xb71c3c]){_0x3bf778=VisuMZ[_0x5542e2(0x118f)]['JS'][_0xb71c3c][_0x5542e2(0x351)](this,this[_0x5542e2(0xdf5)](),_0x149871,_0x5b5531,_0x3bf778);if(_0x50b5b2)_0x3bf778=_0x5e0318;}}return _0x3bf778;},Game_Action[_0xe90fac(0x510)][_0xe90fac(0x5c1)+_0xe90fac(0xf59)]=function(_0x3ddc9a){const _0x250c7d=_0xe90fac,_0xe7faa3=this['_totalValu'+'e']||0x4*-0x79+-0xfa7+-0x9*-0x1f3,_0x1401ab=VisuMZ['BattleCore'][_0x250c7d(0x281)][_0x250c7d(0x7dd)],_0x375e6a=_0x3ddc9a[_0x250c7d(0xeb8)]('');_0x1401ab[_0x375e6a]&&_0x1401ab[_0x375e6a]['call'](this,_0xe7faa3);let _0x28a356=VisuMZ[_0x250c7d(0x118f)][_0x250c7d(0xc4e)+'S'](this[_0x250c7d(0xdd)](),_0x3ddc9a);VisuMZ[_0x250c7d(0x118f)]['JS'][_0x28a356]&&VisuMZ['BattleCore']['JS'][_0x28a356]['call'](this,this['subject'](),this['subject'](),this[_0x250c7d(0xdd)](),_0xe7faa3);for(const _0x2c9b8f of this['subject']()[_0x250c7d(0x412)+'ts']()){if(!_0x2c9b8f)continue;_0x28a356=VisuMZ[_0x250c7d(0x118f)]['createKeyJ'+'S'](_0x2c9b8f,_0x3ddc9a),VisuMZ[_0x250c7d(0x118f)]['JS'][_0x28a356]&&VisuMZ['BattleCore']['JS'][_0x28a356]['call'](this,this['subject'](),this['subject'](),_0x2c9b8f,_0xe7faa3);}},Game_Action[_0xe90fac(0x510)][_0xe90fac(0x72f)]=function(){const _0x3b110e=_0xe90fac;return VisuMZ[_0x3b110e(0x118f)][_0x3b110e(0x281)][_0x3b110e(0x7dd)][_0x3b110e(0x4c8)+_0x3b110e(0xcf)][_0x3b110e(0x351)](this);},Game_Action[_0xe90fac(0x510)][_0xe90fac(0x2ff)+'mSpeed']=function(){const _0x18bfff=_0xe90fac;return VisuMZ['BattleCore'][_0x18bfff(0x281)][_0x18bfff(0x7dd)][_0x18bfff(0x17e)+'mSpeed'];},Game_Action[_0xe90fac(0x510)][_0xe90fac(0xe93)+_0xe90fac(0xe88)]=function(){const _0x5ca8f7=_0xe90fac,_0x510cf6={'dulSU':function(_0x9d0bb1,_0x1e0eaa){return _0x9d0bb1===_0x1e0eaa;},'KhAya':_0x5ca8f7(0xa59),'JcZnZ':function(_0x3584f5,_0x4dfe43){return _0x3584f5===_0x4dfe43;},'uuBtI':_0x5ca8f7(0xc87)+'s'};if(_0x510cf6[_0x5ca8f7(0xd91)](this['_targetBat'+_0x5ca8f7(0xe80)],_0x510cf6[_0x5ca8f7(0x98)]))return![];if(_0x510cf6['JcZnZ'](this['_targetBat'+'tlerKey'],_0x510cf6[_0x5ca8f7(0x660)]))return![];if(!this['item']())return![];return this[_0x5ca8f7(0xdd)]()['note']['match'](/<JS TARGETS>/i);},Game_Action[_0xe90fac(0x510)][_0xe90fac(0x10ce)+'reTargetSc'+_0xe90fac(0x7d0)]=function(){const _0x4e25b1=_0xe90fac,_0x50ec2a={'COBMV':_0x4e25b1(0xda6)+'1','BIdry':function(_0x5c1abd,_0x5b5134){return _0x5c1abd===_0x5b5134;},'QUYzg':_0x4e25b1(0x72d),'XyNxF':function(_0x3368b5,_0x106304){return _0x3368b5===_0x106304;},'oOcSH':'all\x20actors','udilf':'all\x20enemie'+'s'},_0x3c5975=_0x50ec2a[_0x4e25b1(0x113c)][_0x4e25b1(0xab1)]('|');let _0x1dc673=-0x190+0x17cb*0x1+-0x769*0x3;while(!![]){switch(_0x3c5975[_0x1dc673++]){case'0':if(this['isCustomBa'+'ttleScope']())return!![];continue;case'1':return _0x50ec2a[_0x4e25b1(0xf06)](typeof this[_0x4e25b1(0xdd)]()[_0x4e25b1(0x108c)],_0x50ec2a[_0x4e25b1(0xf5e)]);case'2':if(_0x50ec2a[_0x4e25b1(0x11c3)](this['_targetBat'+_0x4e25b1(0xe80)],_0x50ec2a['oOcSH']))return![];continue;case'3':if(!this[_0x4e25b1(0xdd)]())return![];continue;case'4':if(_0x50ec2a[_0x4e25b1(0x11c3)](this['_targetBat'+_0x4e25b1(0xe80)],_0x50ec2a[_0x4e25b1(0x1148)]))return![];continue;case'5':if(!this[_0x4e25b1(0x3cc)]&&this['subject']()[_0x4e25b1(0xc67)]())return![];continue;}break;}},VisuMZ['BattleCore'][_0xe90fac(0xf8b)+_0xe90fac(0x753)+_0xe90fac(0x147a)]=Game_Action[_0xe90fac(0x510)][_0xe90fac(0xb88)+'ent'],Game_Action[_0xe90fac(0x510)][_0xe90fac(0xb88)+_0xe90fac(0x11ae)]=function(){const _0x44e188=_0xe90fac,_0x5c9e1d={'itMEI':function(_0x262347,_0x4b277c){return _0x262347===_0x4b277c;},'PbNuF':_0x44e188(0xa59),'PqOoW':function(_0x32ac52,_0x271ad6){return _0x32ac52===_0x271ad6;},'fjcXx':_0x44e188(0xc87)+'s'};if(_0x5c9e1d[_0x44e188(0xb20)](this[_0x44e188(0x7fb)+'tlerKey'],_0x5c9e1d['PbNuF']))return![];if(_0x5c9e1d[_0x44e188(0x14d4)](this['_targetBat'+_0x44e188(0xe80)],_0x5c9e1d[_0x44e188(0xfe3)]))return!![];return this[_0x44e188(0x10ce)+_0x44e188(0xbb5)+_0x44e188(0x7d0)]()&&!this['isCustomBa'+_0x44e188(0xe88)]()?this[_0x44e188(0xb88)+_0x44e188(0x1476)+_0x44e188(0x86e)]():VisuMZ['BattleCore'][_0x44e188(0xf8b)+_0x44e188(0x753)+_0x44e188(0x147a)][_0x44e188(0x351)](this);},Game_Action[_0xe90fac(0x510)][_0xe90fac(0xb88)+_0xe90fac(0x1476)+'ore']=function(){const _0x26c7cd=_0xe90fac,_0x3c8499={'Xltrq':function(_0x29bf7a,_0x458641){return _0x29bf7a(_0x458641);}},_0x8bb579=_0x3c8499[_0x26c7cd(0xcee)](String,this[_0x26c7cd(0xdd)]()[_0x26c7cd(0x108c)]);if(_0x8bb579[_0x26c7cd(0x3eb)](/ANY/i))return!![];return _0x8bb579['match'](/(?:ENEMY|ENEMIES|FOE|FOES)/i);},VisuMZ['BattleCore'][_0xe90fac(0xf8b)+_0xe90fac(0x952)+_0xe90fac(0x4d4)]=Game_Action['prototype']['isForFrien'+'d'],Game_Action[_0xe90fac(0x510)][_0xe90fac(0x30f)+'d']=function(){const _0x20519c=_0xe90fac,_0x4d32f3={'gVRhM':function(_0x137073,_0x4df820){return _0x137073===_0x4df820;},'koQQj':_0x20519c(0xa59),'WLJXe':_0x20519c(0xc87)+'s'};if(_0x4d32f3['gVRhM'](this[_0x20519c(0x7fb)+_0x20519c(0xe80)],_0x4d32f3[_0x20519c(0x497)]))return!![];if(_0x4d32f3['gVRhM'](this['_targetBat'+_0x20519c(0xe80)],_0x4d32f3[_0x20519c(0x109a)]))return![];return this['isBattleCo'+'reTargetSc'+_0x20519c(0x7d0)]()&&!this[_0x20519c(0xe93)+_0x20519c(0xe88)]()?this[_0x20519c(0x30f)+_0x20519c(0x114)+'e']():VisuMZ[_0x20519c(0x118f)][_0x20519c(0xf8b)+'n_isForFri'+_0x20519c(0x4d4)]['call'](this);},Game_Action[_0xe90fac(0x510)][_0xe90fac(0x30f)+'dBattleCor'+'e']=function(){const _0x58836e=_0xe90fac,_0x4a73bf={'AOKKS':function(_0x5c10dd,_0x1eaf10){return _0x5c10dd(_0x1eaf10);}},_0x3ea798=_0x4a73bf[_0x58836e(0x146e)](String,this[_0x58836e(0xdd)]()['scope']);return _0x3ea798[_0x58836e(0x3eb)](/(?:ALLY|ALLIES|FRIEND|FRIENDS)/i);},Game_Action[_0xe90fac(0x510)][_0xe90fac(0xcf2)+'e']=function(){const _0x2239c8=_0xe90fac,_0x150387={'HlQPq':function(_0x371341,_0x5acbc7){return _0x371341(_0x5acbc7);}};if(this[_0x2239c8(0x10ce)+_0x2239c8(0xbb5)+_0x2239c8(0x7d0)]()&&!this['isCustomBa'+_0x2239c8(0xe88)]()){const _0x27d4c2=_0x150387[_0x2239c8(0xdc1)](String,this[_0x2239c8(0xdd)]()[_0x2239c8(0x108c)]);return _0x27d4c2[_0x2239c8(0x3eb)](/(?:ENEMY|FOE)/i)&&_0x27d4c2[_0x2239c8(0x3eb)](/OR/i)&&_0x27d4c2['match'](/(?:ALLY|FRIEND)/i);}else return![];},Game_Action[_0xe90fac(0x510)][_0xe90fac(0xcf2)+_0xe90fac(0x9b2)+_0xe90fac(0x8df)]=function(){const _0x22589b=_0xe90fac,_0x3f4997={'LAXMZ':function(_0xbd2122,_0x313b74){return _0xbd2122(_0x313b74);}};if(this['isForAnyon'+'e']()){const _0x2b8298=_0x3f4997[_0x22589b(0x14e8)](String,this[_0x22589b(0xdd)]()[_0x22589b(0x108c)]);if(_0x2b8298['match'](/(?:ALLY|FRIEND) OR (?:ENEMY|FOE)/i))return!![];}return![];},Game_Action[_0xe90fac(0x510)]['isForAnyon'+_0xe90fac(0x567)+_0xe90fac(0x15db)]=function(){const _0x1fd8e0=_0xe90fac,_0x252c8e={'zgsut':function(_0x4c90d5,_0x2a50b6){return _0x4c90d5(_0x2a50b6);}};if(this[_0x1fd8e0(0xcf2)+'e']()){const _0x13270e=_0x252c8e['zgsut'](String,this[_0x1fd8e0(0xdd)]()['scope']);if(_0x13270e[_0x1fd8e0(0x3eb)](/(?:ENEMY|FOE) OR (?:ALLY|FRIEND)/i))return!![];}return![];},VisuMZ[_0xe90fac(0x118f)]['Game_Actio'+'n_isForAli'+_0xe90fac(0x908)]=Game_Action[_0xe90fac(0x510)][_0xe90fac(0xf50)+_0xe90fac(0x138d)],Game_Action[_0xe90fac(0x510)][_0xe90fac(0xf50)+_0xe90fac(0x138d)]=function(){const _0x4870e1=_0xe90fac,_0x49c2a4={'dhCTK':function(_0x4be4a2,_0x28152a){return _0x4be4a2===_0x28152a;},'cjxrL':_0x4870e1(0xa59)};if(_0x49c2a4['dhCTK'](this[_0x4870e1(0x7fb)+_0x4870e1(0xe80)],_0x49c2a4[_0x4870e1(0x910)]))return!![];return this[_0x4870e1(0x10ce)+_0x4870e1(0xbb5)+'ope']()&&!this[_0x4870e1(0xe93)+'ttleScope']()?this[_0x4870e1(0xf50)+_0x4870e1(0x71c)+_0x4870e1(0xa2f)]():VisuMZ[_0x4870e1(0x118f)][_0x4870e1(0xf8b)+'n_isForAli'+'veFriend'][_0x4870e1(0x351)](this);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xf8b)+_0xe90fac(0x14f5)+_0xe90fac(0x105d)]=Game_Action[_0xe90fac(0x510)][_0xe90fac(0x14ca)+'riend'],Game_Action[_0xe90fac(0x510)][_0xe90fac(0x14ca)+'riend']=function(){const _0x33d8f1=_0xe90fac,_0x48384a={'YyWwr':function(_0x358397,_0x14e1e8){return _0x358397===_0x14e1e8;},'nNbtr':_0x33d8f1(0xa59)};if(_0x48384a[_0x33d8f1(0x8d9)](this['_targetBat'+_0x33d8f1(0xe80)],_0x48384a['nNbtr']))return VisuMZ[_0x33d8f1(0x118f)][_0x33d8f1(0xf8b)+'n_isForDea'+'dFriend'][_0x33d8f1(0x351)](this);return VisuMZ[_0x33d8f1(0x118f)][_0x33d8f1(0xf8b)+_0x33d8f1(0x14f5)+_0x33d8f1(0x105d)][_0x33d8f1(0x351)](this);},Game_Action[_0xe90fac(0x510)][_0xe90fac(0xf50)+_0xe90fac(0x71c)+_0xe90fac(0xa2f)]=function(){const _0x57e8ff=_0xe90fac;if(this[_0x57e8ff(0xcf2)+'e']())return!![];return![];},Game_Action[_0xe90fac(0x510)][_0xe90fac(0xe99)+'er']=function(){const _0x130379=_0xe90fac;return this[_0x130379(0xdd)]()&&this[_0x130379(0xdd)]()[_0x130379(0xfee)][_0x130379(0x3eb)](/<CANNOT TARGET (?:USER|SELF)>/i);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xf8b)+_0xe90fac(0x1273)]=Game_Action[_0xe90fac(0x510)][_0xe90fac(0xbef)],Game_Action[_0xe90fac(0x510)][_0xe90fac(0xbef)]=function(){const _0x13e3a9=_0xe90fac,_0x470316={'BIgys':function(_0x26258b,_0x58668e){return _0x26258b===_0x58668e;},'dHqtv':_0x13e3a9(0xa59),'FwxsO':'all\x20enemie'+'s'};if(_0x470316[_0x13e3a9(0x10a6)](this['_targetBat'+'tlerKey'],_0x470316[_0x13e3a9(0xe8c)]))return![];if(_0x470316[_0x13e3a9(0x10a6)](this[_0x13e3a9(0x7fb)+_0x13e3a9(0xe80)],_0x470316['FwxsO']))return![];return this['isBattleCo'+'reTargetSc'+_0x13e3a9(0x7d0)]()&&!this['isCustomBa'+_0x13e3a9(0xe88)]()?this['isForOneBa'+_0x13e3a9(0xc12)]():VisuMZ['BattleCore'][_0x13e3a9(0xf8b)+_0x13e3a9(0x1273)][_0x13e3a9(0x351)](this);},Game_Action[_0xe90fac(0x510)][_0xe90fac(0x78c)+_0xe90fac(0xc12)]=function(){const _0x3bc3f5=_0xe90fac;if(this[_0x3bc3f5(0xcf2)+'e']())return!![];return![];},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xf8b)+'n_isForRan'+_0xe90fac(0x1a4)]=Game_Action[_0xe90fac(0x510)]['isForRando'+'m'],Game_Action[_0xe90fac(0x510)][_0xe90fac(0x12c0)+'m']=function(){const _0x5c2ab5=_0xe90fac,_0x55cdcf={'xkFyx':function(_0x46df7b,_0x47ba87){return _0x46df7b===_0x47ba87;},'EHllY':_0x5c2ab5(0xa59),'tgbPA':_0x5c2ab5(0xc87)+'s'};if(_0x55cdcf[_0x5c2ab5(0xe1b)](this[_0x5c2ab5(0x7fb)+'tlerKey'],_0x55cdcf[_0x5c2ab5(0x161)]))return![];if(_0x55cdcf['xkFyx'](this['_targetBat'+'tlerKey'],_0x55cdcf['tgbPA']))return![];return this[_0x5c2ab5(0x10ce)+'reTargetSc'+_0x5c2ab5(0x7d0)]()&&!this[_0x5c2ab5(0xe93)+_0x5c2ab5(0xe88)]()?this[_0x5c2ab5(0x12c0)+_0x5c2ab5(0xd47)+'e']():VisuMZ['BattleCore'][_0x5c2ab5(0xf8b)+'n_isForRan'+_0x5c2ab5(0x1a4)]['call'](this);},Game_Action[_0xe90fac(0x510)][_0xe90fac(0x12c0)+_0xe90fac(0xd47)+'e']=function(){const _0x560b8a=_0xe90fac,_0x3ac4fd={'IJfoG':function(_0x1235a9,_0x2530a2){return _0x1235a9(_0x2530a2);}},_0x430221=_0x3ac4fd['IJfoG'](String,this['item']()['scope']);return _0x430221[_0x560b8a(0x3eb)](/(?:RAND|RANDOM)/i);},VisuMZ[_0xe90fac(0x118f)]['Game_Actio'+_0xe90fac(0x1003)]=Game_Action[_0xe90fac(0x510)][_0xe90fac(0xae9)],Game_Action[_0xe90fac(0x510)][_0xe90fac(0xae9)]=function(){const _0x5d8131=_0xe90fac,_0x5ecae8={'nvSbg':function(_0x33b1bf,_0x28ffec){return _0x33b1bf===_0x28ffec;},'ltZNA':'all\x20actors','vZRok':function(_0x159dc2,_0x5cdae2){return _0x159dc2===_0x5cdae2;},'wDesg':_0x5d8131(0xc87)+'s'};if(_0x5ecae8['nvSbg'](this[_0x5d8131(0x7fb)+_0x5d8131(0xe80)],_0x5ecae8[_0x5d8131(0xc19)]))return!![];if(_0x5ecae8[_0x5d8131(0xfde)](this['_targetBat'+_0x5d8131(0xe80)],_0x5ecae8[_0x5d8131(0x541)]))return!![];return VisuMZ[_0x5d8131(0x118f)]['Game_Actio'+_0x5d8131(0x1003)][_0x5d8131(0x351)](this);},Game_Action['prototype'][_0xe90fac(0xaa1)+_0xe90fac(0xed9)+'elect']=function(){const _0x4d3a88=_0xe90fac;if(!this['item']())return![];if(this['isForDeadF'+'riend']())return![];return(this[_0x4d3a88(0xdd)]()[_0x4d3a88(0xfee)]||'')[_0x4d3a88(0x3eb)](/<SINGLE OR MULTIPLE SELECT>/i);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xf8b)+_0xe90fac(0x15a0)+'y']=Game_Action[_0xe90fac(0x510)][_0xe90fac(0x1370)],Game_Action['prototype'][_0xe90fac(0x1370)]=function(_0x2bc702){const _0x1b985f=_0xe90fac,_0x53b68d={'cPBuK':function(_0x280425,_0x194e22){return _0x280425===_0x194e22;}};if(this[_0x1b985f(0xe99)+'er']()&&_0x53b68d[_0x1b985f(0x714)](_0x2bc702,this[_0x1b985f(0xdf5)]()))return![];return VisuMZ[_0x1b985f(0x118f)][_0x1b985f(0xf8b)+_0x1b985f(0x15a0)+'y']['call'](this,_0x2bc702);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xf8b)+_0xe90fac(0xbb9)+_0xe90fac(0xfe5)+'es']=Game_Action['prototype'][_0xe90fac(0x90e)+'Candidates'],Game_Action['prototype']['itemTarget'+_0xe90fac(0x296)]=function(){const _0x4a4b33=_0xe90fac,_0x1021a5=VisuMZ[_0x4a4b33(0x118f)][_0x4a4b33(0xf8b)+_0x4a4b33(0xbb9)+_0x4a4b33(0xfe5)+'es']['call'](this);if(this[_0x4a4b33(0xe99)+'er']())_0x1021a5['remove'](this[_0x4a4b33(0xdf5)]());return _0x1021a5;},VisuMZ[_0xe90fac(0x118f)]['Game_Actio'+_0xe90fac(0xb45)+'ection']=Game_Action[_0xe90fac(0x510)][_0xe90fac(0x9eb)+_0xe90fac(0x1580)],Game_Action[_0xe90fac(0x510)][_0xe90fac(0x9eb)+_0xe90fac(0x1580)]=function(){const _0x64af0b=_0xe90fac;return this[_0x64af0b(0x10ce)+_0x64af0b(0xbb5)+'ope']()&&!this['isCustomBa'+_0x64af0b(0xe88)]()?this['needsSelec'+'tionBattle'+_0x64af0b(0x126e)]():VisuMZ[_0x64af0b(0x118f)]['Game_Actio'+_0x64af0b(0xb45)+_0x64af0b(0x11db)][_0x64af0b(0x351)](this);},Game_Action[_0xe90fac(0x510)][_0xe90fac(0x9eb)+'tionBattle'+'Core']=function(){const _0xb80630=_0xe90fac,_0x12fc87={'LZSUq':function(_0x158ac7,_0x27d69d){return _0x158ac7(_0x27d69d);}},_0x5ca0c9=_0x12fc87[_0xb80630(0xe0e)](String,this[_0xb80630(0xdd)]()[_0xb80630(0x108c)]);if(_0x5ca0c9[_0xb80630(0x3eb)](/RANDOM/i))return![];if(_0x5ca0c9[_0xb80630(0x3eb)](/ALL (?:ALLY|ALLIES|FRIEND|FRIENDS)/i))return![];if(_0x5ca0c9[_0xb80630(0x3eb)](/ALL (?:ENEMY|ENEMIES|FOE|FOES)/i))return![];if(_0x5ca0c9[_0xb80630(0x3eb)](/(?:ENEMY|FOE) OR (?:ALLY|FRIEND)/i))return!![];if(_0x5ca0c9[_0xb80630(0x3eb)](/(?:ALLY|FRIEND) OR (?:ENEMY|FOE)/i))return!![];return VisuMZ[_0xb80630(0x118f)]['Game_Actio'+'n_needsSel'+'ection'][_0xb80630(0x351)](this);},VisuMZ['BattleCore'][_0xe90fac(0xf8b)+_0xe90fac(0x8d3)+_0xe90fac(0x7ff)]=Game_Action[_0xe90fac(0x510)]['makeTarget'+'s'],Game_Action[_0xe90fac(0x510)]['makeTarget'+'s']=function(){const _0x592f1e=_0xe90fac;let _0x2f2b64=[];return this['isBattleCo'+'reTargetSc'+'ope']()?this[_0x592f1e(0xe93)+'ttleScope']()?_0x2f2b64=this[_0x592f1e(0xadf)+_0x592f1e(0xf2e)+_0x592f1e(0x12c4)]():_0x2f2b64=this['makeTarget'+'sBattleCor'+'e']():_0x2f2b64=VisuMZ['BattleCore'][_0x592f1e(0xf8b)+_0x592f1e(0x8d3)+'ets'][_0x592f1e(0x351)](this),_0x2f2b64=this['applyTarge'+_0x592f1e(0x8c4)](_0x2f2b64),_0x2f2b64;},Game_Action[_0xe90fac(0x510)]['isSubjectV'+_0xe90fac(0x188)+_0xe90fac(0x61b)]=function(){const _0x308d84=_0xe90fac;return this[_0x308d84(0xdf5)]()[_0x308d84(0xd83)]()&&!this['subject']()['isAutoBatt'+'le']();},Game_Action[_0xe90fac(0x510)][_0xe90fac(0xadf)+_0xe90fac(0xf2e)+_0xe90fac(0x12c4)]=function(){const _0xbcbbff=_0xe90fac,_0x289033={'WWblQ':'Targets'},_0x4eb2f5=VisuMZ[_0xbcbbff(0x118f)][_0xbcbbff(0xc4e)+'S'](this['item'](),_0x289033[_0xbcbbff(0x405)]);if(VisuMZ['BattleCore']['JS'][_0x4eb2f5]){targets=VisuMZ[_0xbcbbff(0x118f)]['Game_Actio'+_0xbcbbff(0x8d3)+_0xbcbbff(0x7ff)]['call'](this);const _0x4fe115=VisuMZ[_0xbcbbff(0x118f)]['createKeyJ'+'S'](this['item'](),_0x289033[_0xbcbbff(0x405)]);return targets=VisuMZ[_0xbcbbff(0x118f)]['JS'][_0x4fe115][_0xbcbbff(0x351)](this,this[_0xbcbbff(0xdf5)](),targets),this[_0xbcbbff(0xa11)+'ets'](targets);}return this[_0xbcbbff(0xadf)+_0xbcbbff(0xf2e)+'e']();},Game_Action[_0xe90fac(0x510)][_0xe90fac(0xadf)+_0xe90fac(0xf2e)+'e']=function(){const _0x278d97=_0xe90fac,_0x289a10={'OGFPT':function(_0x10933c,_0x3abcf6){return _0x10933c(_0x3abcf6);},'agojN':function(_0x28005e,_0x432f14){return _0x28005e<_0x432f14;},'cqGVe':'VisuMZ_3_B'+_0x278d97(0x13cc)+_0x278d97(0x65a)+_0x278d97(0x529),'yHdyX':_0x278d97(0x3e1)+_0x278d97(0x2c0)+_0x278d97(0xf24)+'geting\x20to\x20'+_0x278d97(0x108b),'axIhZ':'with\x20lates'+_0x278d97(0x1414)+'of\x20VisuMZ_'+'1_BattleCo'+_0x278d97(0x9c4),'QbZfR':function(_0x38b194,_0x55b977){return _0x38b194(_0x55b977);},'XNCSp':function(_0x177221,_0x10e76f){return _0x177221===_0x10e76f;},'QWwYZ':function(_0x32483f,_0x171da2){return _0x32483f(_0x171da2);},'BQnei':function(_0x25f51c,_0x5c10a3){return _0x25f51c(_0x5c10a3);}};let _0xcc0518=[];const _0x1876a5=_0x289a10['OGFPT'](String,this[_0x278d97(0xdd)]()[_0x278d97(0x108c)]);if(this['isForAnyon'+_0x278d97(0x567)+_0x278d97(0x15db)]())return this[_0x278d97(0x6d8)+_0x278d97(0x188)+'oneSelect']()?(_0xcc0518=this[_0x278d97(0xde)+_0x278d97(0x959)](),this[_0x278d97(0xa11)+'ets'](_0xcc0518)):(this[_0x278d97(0xc83)+'ex']=-(-0x1*0x1dcc+0x13*-0x25+0x208c),_0xcc0518[_0x278d97(0x15f1)](...this['targetsFor'+_0x278d97(0xcc1)]()),this[_0x278d97(0xa11)+_0x278d97(0x7ff)](_0xcc0518));if(this[_0x278d97(0xcf2)+_0x278d97(0x9b2)+_0x278d97(0x8df)]()){if(this[_0x278d97(0x6d8)+_0x278d97(0x188)+'oneSelect']())return _0xcc0518=this[_0x278d97(0xde)+'KeyTargets'](),this[_0x278d97(0xa11)+_0x278d97(0x7ff)](_0xcc0518);else{if(Imported[_0x278d97(0xa56)+_0x278d97(0x8e4)]){if(_0x289a10[_0x278d97(0xb1c)](VisuMZ[_0x278d97(0x719)][_0x278d97(0x6ca)],-0x14f3+0x13ef+0x57*0x3+0.18999999999999995)){let _0x4644c1='';_0x4644c1+=_0x289a10[_0x278d97(0x130c)],_0x4644c1+=_0x289a10[_0x278d97(0xddc)],_0x4644c1+=_0x289a10[_0x278d97(0x101b)],_0x289a10[_0x278d97(0x40c)](alert,_0x4644c1),SceneManager[_0x278d97(0x10c0)]();}}return this['_targetInd'+'ex']=-(-0x1e5d+-0x2230+-0x2047*-0x2),_0xcc0518[_0x278d97(0x15f1)](...this['targetsFor'+'Friends']()),this[_0x278d97(0xa11)+_0x278d97(0x7ff)](_0xcc0518);}}if(_0x1876a5[_0x278d97(0x3eb)](/(\d+) RANDOM ANY/i)){let _0x253a6c=_0x289a10[_0x278d97(0x40c)](Number,RegExp['$1']);while(_0x253a6c--){const _0x1bf14b=_0x289a10[_0x278d97(0xb6e)](Math[_0x278d97(0x1608)](0x194*-0xc+-0x79*0xb+0x373*0x7),0x3*-0x317+0xd24+-0x3df)?this[_0x278d97(0xb10)+_0x278d97(0x14a)]():this[_0x278d97(0x2dd)+'t']();_0xcc0518[_0x278d97(0x15f1)](_0x1bf14b['trueRandom'+_0x278d97(0xf28)]());}return this[_0x278d97(0xa11)+_0x278d97(0x7ff)](_0xcc0518);}if(_0x1876a5[_0x278d97(0x3eb)](/(\d+) RANDOM (?:ENEMY|ENEMIES|FOE|FOES)/i)){let _0x366011=_0x289a10[_0x278d97(0x4b3)](Number,RegExp['$1']);while(_0x366011--){_0xcc0518[_0x278d97(0x15f1)](this[_0x278d97(0xb10)+_0x278d97(0x14a)]()[_0x278d97(0xdd4)+_0x278d97(0xf28)]());}return this[_0x278d97(0xa11)+_0x278d97(0x7ff)](_0xcc0518);}if(_0x1876a5[_0x278d97(0x3eb)](/(\d+) RANDOM (?:ALLY|ALLIES|FRIEND|FRIENDS)/i)){let _0x601398=_0x289a10[_0x278d97(0x1420)](Number,RegExp['$1']);while(_0x601398--){_0xcc0518[_0x278d97(0x15f1)](this[_0x278d97(0x2dd)+'t']()[_0x278d97(0xdd4)+_0x278d97(0xf28)]());}return this[_0x278d97(0xa11)+_0x278d97(0x7ff)](_0xcc0518);}if(_0x1876a5['match'](/ALL (?:ALLY|ALLIES|FRIEND|FRIENDS) (?:BUT|EXCEPT) (?:USER|SELF)/i))return _0xcc0518[_0x278d97(0x15f1)](...this[_0x278d97(0x2dd)+'t']()[_0x278d97(0xf79)+'rs']()[_0x278d97(0x55f)](_0x1e4cb2=>_0x1e4cb2!==this[_0x278d97(0xdf5)]())),this[_0x278d97(0xa11)+_0x278d97(0x7ff)](_0xcc0518);return VisuMZ[_0x278d97(0x118f)][_0x278d97(0xf8b)+_0x278d97(0x8d3)+'ets']['call'](this);},Game_Action[_0xe90fac(0x510)][_0xe90fac(0x5f2)+_0xe90fac(0x7ff)]=function(_0x202712){const _0x1e711c=_0xe90fac,_0x11fa49={'ukoFA':function(_0x473222,_0x184a7d){return _0x473222<_0x184a7d;}},_0x389fa7=[];for(let _0x51a553=-0x151f+-0x1cf5+0x190a*0x2;_0x11fa49[_0x1e711c(0xd3b)](_0x51a553,this[_0x1e711c(0x378)]());_0x51a553++){_0x389fa7[_0x1e711c(0x15f1)](_0x202712[_0x1e711c(0xdd4)+_0x1e711c(0xf28)]());}return _0x389fa7;},Game_Action[_0xe90fac(0x510)][_0xe90fac(0x1327)+_0xe90fac(0x8c4)]=function(_0x319102){const _0xcf6ff8=_0xe90fac,_0x33e01c={'BjZWX':function(_0x330366,_0x291890){return _0x330366>_0x291890;}};if(!this['item']())return _0x319102;const _0x529dfc=this['item']()[_0xcf6ff8(0xfee)];if(this[_0xcf6ff8(0xe99)+'er']()){this['isForAll']()&&_0x319102[_0xcf6ff8(0x8a4)](this['subject']());if(_0x319102[_0xcf6ff8(0x79c)](this[_0xcf6ff8(0xdf5)]())){const _0xa13f91=this['friendsUni'+'t']()[_0xcf6ff8(0xf79)+'rs']()[_0xcf6ff8(0x8a4)](this[_0xcf6ff8(0xdf5)]());if(_0x33e01c[_0xcf6ff8(0xfaf)](_0xa13f91['length'],0x2633+0x1d84+0xd8b*-0x5)){_0xa13f91[_0xcf6ff8(0xf47)]((_0x5ab196,_0x3cc875)=>_0x5ab196[_0xcf6ff8(0x7ab)]()-_0x3cc875[_0xcf6ff8(0x7ab)]());while(_0x319102[_0xcf6ff8(0x79c)](this[_0xcf6ff8(0xdf5)]())){const _0x4b065f=_0x319102[_0xcf6ff8(0x741)](this[_0xcf6ff8(0xdf5)]());_0x319102[_0x4b065f]=_0xa13f91[Math['randomInt'](_0xa13f91[_0xcf6ff8(0x1268)])];}}else _0x319102['remove'](this['subject']());}}return _0x319102;},VisuMZ['BattleCore']['Game_Actio'+_0xe90fac(0xd1e)+'ctAddAttac'+_0xe90fac(0x643)]=Game_Action[_0xe90fac(0x510)][_0xe90fac(0x10eb)+'AddAttackS'+'tate'],Game_Action[_0xe90fac(0x510)][_0xe90fac(0x10eb)+_0xe90fac(0x201)+_0xe90fac(0x2ce)]=function(_0x23d3fa,_0x348110){const _0x4bcdf0=_0xe90fac,_0xfdaa8a={'UMzZg':function(_0x4ee71d,_0x2672b7){return _0x4ee71d===_0x2672b7;},'JkCFi':function(_0x31808c,_0x30f4ae){return _0x31808c<_0x30f4ae;}};VisuMZ[_0x4bcdf0(0x118f)][_0x4bcdf0(0xf8b)+'n_itemEffe'+_0x4bcdf0(0x13e0)+'kState']['call'](this,_0x23d3fa,_0x348110);if(!_0x23d3fa[_0x4bcdf0(0x852)]())return;for(const _0x5b49dc of this[_0x4bcdf0(0xdf5)]()[_0x4bcdf0(0x39c)+'es']()){if(_0xfdaa8a[_0x4bcdf0(0x30e)](_0x5b49dc,_0x23d3fa[_0x4bcdf0(0xfb8)+'Id']())){let _0x36af0c=_0x348110['value1'];_0x36af0c*=_0x23d3fa[_0x4bcdf0(0xc02)](_0x5b49dc),_0x36af0c*=this[_0x4bcdf0(0xdf5)]()[_0x4bcdf0(0x39c)+_0x4bcdf0(0x327)](_0x5b49dc),_0x36af0c*=this[_0x4bcdf0(0x81a)+_0x4bcdf0(0x135d)](_0x23d3fa),_0xfdaa8a['JkCFi'](Math['random'](),_0x36af0c)&&(_0x23d3fa[_0x4bcdf0(0x3c0)+_0x4bcdf0(0x138b)]=!![],this[_0x4bcdf0(0x136f)+'s'](_0x23d3fa));}}},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xf8b)+'n_itemEffe'+_0xe90fac(0x1056)+_0xe90fac(0x988)]=Game_Action[_0xe90fac(0x510)][_0xe90fac(0x10eb)+_0xe90fac(0xa31)+'tate'],Game_Action[_0xe90fac(0x510)]['itemEffect'+_0xe90fac(0xa31)+_0xe90fac(0x2ce)]=function(_0x24b79a,_0x2c4229){const _0xbf4720=_0xe90fac,_0x4bb1ed={'EPUrp':function(_0x4a0ecf,_0x3b8b8b){return _0x4a0ecf!==_0x3b8b8b;},'cnlSU':function(_0x519815,_0x4738f7){return _0x519815<_0x4738f7;}};VisuMZ[_0xbf4720(0x118f)][_0xbf4720(0xf8b)+'n_itemEffe'+_0xbf4720(0x1056)+_0xbf4720(0x988)][_0xbf4720(0x351)](this,_0x24b79a,_0x2c4229);if(!_0x24b79a[_0xbf4720(0x852)]())return;if(_0x4bb1ed[_0xbf4720(0x135e)](_0x2c4229[_0xbf4720(0x88c)],_0x24b79a[_0xbf4720(0xfb8)+'Id']()))return;let _0x18ef81=_0x2c4229['value1'];!this[_0xbf4720(0x127f)+'it']()&&(_0x18ef81*=_0x24b79a[_0xbf4720(0xc02)](_0x2c4229['dataId']),_0x18ef81*=this[_0xbf4720(0x81a)+_0xbf4720(0x135d)](_0x24b79a)),_0x4bb1ed[_0xbf4720(0x1085)](Math[_0xbf4720(0x9c3)](),_0x18ef81)&&(_0x24b79a[_0xbf4720(0x3c0)+'eApplied']=!![],this['makeSucces'+'s'](_0x24b79a));},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xf8b)+_0xe90fac(0x1603)+'bal']=Game_Action[_0xe90fac(0x510)][_0xe90fac(0x516)+'l'],Game_Action['prototype'][_0xe90fac(0x516)+'l']=function(){const _0x275f66=_0xe90fac;VisuMZ['BattleCore'][_0x275f66(0xf8b)+_0x275f66(0x1603)+_0x275f66(0x6af)]['call'](this),this[_0x275f66(0x516)+_0x275f66(0x3a8)+_0x275f66(0x1012)](),this[_0x275f66(0x120d)+_0x275f66(0xe39)]();},Game_Action[_0xe90fac(0x510)]['applyGloba'+_0xe90fac(0x3a8)+'ntNotetags']=function(){const _0x25203d=_0xe90fac,_0x162ae9={'oNYBh':function(_0x1d637e,_0x2a205e){return _0x1d637e(_0x2a205e);}};if(!SceneManager[_0x25203d(0x11be)+_0x25203d(0x3ad)]())return;const _0x3c3bf5=/<COMMON (?:EVENT|EVENTS):[ ](.*)>/gi,_0x5bb1ff=this[_0x25203d(0xdd)]()['note'][_0x25203d(0x3eb)](_0x3c3bf5);if(_0x5bb1ff)for(const _0x3fd8cc of _0x5bb1ff){if(!_0x3fd8cc)continue;_0x3fd8cc[_0x25203d(0x3eb)](_0x3c3bf5);const _0x24587f=_0x162ae9[_0x25203d(0xdcb)](String,RegExp['$1'])[_0x25203d(0xab1)](',')['map'](_0x5eff47=>String(_0x5eff47)[_0x25203d(0x808)]()),_0x57d758=_0x24587f['map'](_0x3758cd=>DataManager[_0x25203d(0x453)+_0x25203d(0x237)+_0x25203d(0xbf5)](_0x3758cd));for(const _0x48abdf of _0x57d758){const _0x5293f3=$dataCommonEvents[_0x48abdf];_0x5293f3&&$gameTemp[_0x25203d(0x11bf)+_0x25203d(0x15f7)](_0x48abdf);}}},DataManager['getCommonE'+_0xe90fac(0x237)+'Name']=function(_0x3bc06d){const _0x3bfb6f=_0xe90fac;_0x3bc06d=_0x3bc06d['toUpperCas'+'e']()['trim'](),this[_0x3bfb6f(0x1a6)+_0x3bfb6f(0xa2c)]=this[_0x3bfb6f(0x1a6)+_0x3bfb6f(0xa2c)]||{};if(this[_0x3bfb6f(0x1a6)+_0x3bfb6f(0xa2c)][_0x3bc06d])return this[_0x3bfb6f(0x1a6)+_0x3bfb6f(0xa2c)][_0x3bc06d];for(const _0x5e3e78 of $dataCommonEvents){if(!_0x5e3e78)continue;let _0x4d2057=_0x5e3e78[_0x3bfb6f(0x14c)];_0x4d2057=_0x4d2057[_0x3bfb6f(0x1144)](/\x1I\[(\d+)\]/gi,''),_0x4d2057=_0x4d2057[_0x3bfb6f(0x1144)](/\\I\[(\d+)\]/gi,''),this[_0x3bfb6f(0x1a6)+_0x3bfb6f(0xa2c)][_0x4d2057[_0x3bfb6f(0x1318)+'e']()[_0x3bfb6f(0x808)]()]=_0x5e3e78['id'];}return this[_0x3bfb6f(0x1a6)+_0x3bfb6f(0xa2c)][_0x3bc06d]||0x1fc5+0x15af+-0x3574;},Game_Action[_0xe90fac(0x510)][_0xe90fac(0x120d)+_0xe90fac(0xe39)]=function(){const _0x56bf45=_0xe90fac;if(!SceneManager[_0x56bf45(0x11be)+'tle']())return;const _0x19b209=VisuMZ[_0x56bf45(0x118f)][_0x56bf45(0x281)]['Mechanics'];_0x19b209[_0x56bf45(0x11b0)+_0x56bf45(0x466)]&&$gameSwitches[_0x56bf45(0x16b)](_0x19b209['SwitchCrit'+_0x56bf45(0x466)],![]),_0x19b209['SwitchMiss'+_0x56bf45(0x745)]&&$gameSwitches[_0x56bf45(0x16b)](_0x19b209['SwitchMiss'+'Evade'],![]),_0x19b209[_0x56bf45(0x628)+'g']&&$gameVariables['setValue'](_0x19b209[_0x56bf45(0x628)+'g'],0x1203+-0x1c65*-0x1+-0x2e68),_0x19b209[_0x56bf45(0x6b1)+'al']&&$gameVariables[_0x56bf45(0x16b)](_0x19b209[_0x56bf45(0x6b1)+'al'],0x17*0x30+-0x1982+0x1532*0x1);},Game_Action[_0xe90fac(0x510)][_0xe90fac(0x7bf)+'tSwitches']=function(_0x55c8f7){const _0x31ed83=_0xe90fac,_0xba44e7={'nlapP':function(_0x5c677c,_0x59c85a){return _0x5c677c>_0x59c85a;},'ZifwR':function(_0x28877f,_0x46629b){return _0x28877f<_0x46629b;}};if(!SceneManager[_0x31ed83(0x11be)+_0x31ed83(0x3ad)]())return;if(!_0x55c8f7)return;const _0x52402e=_0x55c8f7[_0x31ed83(0x1c5)](),_0x128e46=VisuMZ[_0x31ed83(0x118f)][_0x31ed83(0x281)][_0x31ed83(0x7dd)];_0x128e46[_0x31ed83(0x11b0)+_0x31ed83(0x466)]&&_0x52402e[_0x31ed83(0x2af)]&&$gameSwitches[_0x31ed83(0x16b)](_0x128e46[_0x31ed83(0x11b0)+'ical'],!![]);_0x128e46[_0x31ed83(0x171)+_0x31ed83(0x745)]&&(_0x52402e[_0x31ed83(0x324)]||_0x52402e[_0x31ed83(0x49a)])&&$gameSwitches[_0x31ed83(0x16b)](_0x128e46[_0x31ed83(0x171)+_0x31ed83(0x745)],!![]);if(_0x128e46[_0x31ed83(0x628)+'g']){let _0x2ac68a=$gameVariables[_0x31ed83(0x101c)](_0x128e46[_0x31ed83(0x628)+'g']);_0xba44e7[_0x31ed83(0xcf7)](_0x52402e[_0x31ed83(0x4da)],-0x12b9*-0x1+0x4f7*-0x5+0x61a)&&(_0x2ac68a+=Math['abs'](_0x52402e[_0x31ed83(0x4da)])),$gameVariables[_0x31ed83(0x16b)](_0x128e46[_0x31ed83(0x628)+'g'],_0x2ac68a);}if(_0x128e46[_0x31ed83(0x6b1)+'al']){let _0x18c583=$gameVariables[_0x31ed83(0x101c)](_0x128e46[_0x31ed83(0x6b1)+'al']);_0xba44e7['ZifwR'](_0x52402e['hpDamage'],-0x35*-0x91+-0xef*-0x22+-0x3dc3)&&(_0x18c583+=Math[_0x31ed83(0x5cc)](_0x52402e[_0x31ed83(0x4da)])),$gameVariables['setValue'](_0x128e46['VariableHe'+'al'],_0x18c583);}},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x9ce)+'egExp']={'lifeSteaItem':/<(.*?) (?:LIFE|MANA) STEAL:[ ](\d+)([%％])>/gi,'lifeStealTrait':/<(.*?) (?:LIFE|MANA) STEAL (.*?):[ ]([\+\-]\d+)([%％])>/gi,'cancelLifeSteal':/<CANCEL LIFE STEAL>/i,'cancelHpLifeSteal':/<CANCEL HP LIFE STEAL>/i,'cancelMpLifeSteal':/<CANCEL MP LIFE STEAL>/i,'guardLifeSteal':/<GUARD LIFE STEAL>/i,'guardHpLifeSteal':/<GUARD HP LIFE STEAL>/i,'guardMpLifeSteal':/<GUARD MP LIFE STEAL>/i,'disarmLifeSteal':/<DISARM LIFE STEAL>/i,'disarmHpLifeSteal':/<DISARM HP LIFE STEAL>/i,'disarmMpLifeSteal':/<DISARM MP LIFE STEAL>/i,'negativeLifeSteal':/<REVERSE LIFE STEAL>/i,'negativeHpLifeSteal':/<REVERSE HP LIFE STEAL>/i,'negativeMpLifeSteal':/<REVERSE MP LIFE STEAL>/i},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xf8b)+_0xe90fac(0x248)+'pDamage']=Game_Action[_0xe90fac(0x510)][_0xe90fac(0x21b)+'amage'],Game_Action[_0xe90fac(0x510)]['executeHpD'+_0xe90fac(0x970)]=function(_0x577a2f,_0xfae837){const _0x4fa2da=_0xe90fac,_0x2c4b5d={'WzRWS':function(_0x4b5fa9,_0x304238){return _0x4b5fa9>_0x304238;}};VisuMZ[_0x4fa2da(0x118f)][_0x4fa2da(0xf8b)+_0x4fa2da(0x248)+'pDamage']['call'](this,_0x577a2f,_0xfae837);!this[_0x4fa2da(0x55b)]()&&_0x577a2f&&_0x2c4b5d[_0x4fa2da(0x1bc)](_0x577a2f['result']()[_0x4fa2da(0x4da)],0x124c+0x1a55+-0x2ca1)&&this['performLif'+_0x4fa2da(0x15ab)]('HP',_0x577a2f,_0x577a2f[_0x4fa2da(0x1c5)]()[_0x4fa2da(0x4da)]);if(_0x577a2f){this['_executeHp'+_0x4fa2da(0x7d7)]=this[_0x4fa2da(0x1425)+_0x4fa2da(0x7d7)]||{};const _0x36be10=_0x577a2f[_0x4fa2da(0x848)]();this[_0x4fa2da(0x1425)+_0x4fa2da(0x7d7)][_0x36be10]=_0xfae837;}},Game_Action['prototype'][_0xe90fac(0x1274)+'amage']=function(_0x4d346c){const _0x38b9f1=_0xe90fac;this[_0x38b9f1(0x1425)+_0x38b9f1(0x7d7)]=this[_0x38b9f1(0x1425)+_0x38b9f1(0x7d7)]||{};const _0x27a33f=_0x4d346c[_0x38b9f1(0x848)]();return this['_executeHp'+'Damage'][_0x27a33f]||0x2621+0xbc0+-0x31e1;},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xf8b)+'n_executeM'+_0xe90fac(0x6b5)]=Game_Action['prototype']['executeMpD'+_0xe90fac(0x970)],Game_Action[_0xe90fac(0x510)][_0xe90fac(0x109b)+_0xe90fac(0x970)]=function(_0x4ce62c,_0x39615d){const _0x547b9f=_0xe90fac,_0x4562a9={'VRcNB':function(_0x9e8deb,_0x375c38){return _0x9e8deb>_0x375c38;}};VisuMZ[_0x547b9f(0x118f)]['Game_Actio'+_0x547b9f(0x1258)+'pDamage'][_0x547b9f(0x351)](this,_0x4ce62c,_0x39615d),!this[_0x547b9f(0x55b)]()&&_0x4ce62c&&_0x4562a9[_0x547b9f(0x892)](_0x4ce62c['result']()[_0x547b9f(0x1381)],0x884+0x89*-0x17+0x3cb)&&this['performLif'+'eSteal']('MP',_0x4ce62c,_0x4ce62c[_0x547b9f(0x1c5)]()[_0x547b9f(0x1381)]);},Game_Action[_0xe90fac(0x510)]['performLif'+'eSteal']=function(_0x713398,_0x451498,_0x2d862a){const _0x3d958e=_0xe90fac,_0x555f64={'tDhEH':function(_0x2a514d,_0x3b7ae3){return _0x2a514d<=_0x3b7ae3;},'sJxPZ':function(_0x4387a4,_0x5d9027){return _0x4387a4*_0x5d9027;},'KPpOA':function(_0x55040a,_0x316260){return _0x55040a<=_0x316260;},'vqVZU':function(_0x2311be,_0x1245d5){return _0x2311be===_0x1245d5;},'YjwpU':function(_0x1f0597,_0x10ac81){return _0x1f0597*_0x10ac81;},'chKNm':function(_0x12797f,_0x54f22b){return _0x12797f*_0x54f22b;}};_0x713398=_0x713398[_0x3d958e(0x1318)+'e']()[_0x3d958e(0x808)]();const _0x41c80b=this[_0x3d958e(0x455)+'ate'](_0x713398,_0x451498);if(_0x555f64[_0x3d958e(0x1395)](_0x41c80b,0x1*0x1bb6+0x1dc3+-0x3979))return;const _0x241a1d=Math[_0x3d958e(0x10a1)](_0x555f64[_0x3d958e(0xff7)](_0x2d862a,_0x41c80b));if(_0x555f64['KPpOA'](_0x241a1d,-0x10f*0x1d+-0x1bb*-0x7+0x1296))return;let _0x416927=this[_0x3d958e(0xdf5)]();if(this[_0x3d958e(0x891)+_0x3d958e(0xe41)])_0x416927=this[_0x3d958e(0x891)+'nTarget'];const _0x472ff3=_0x451498['isNegative'+_0x3d958e(0x70c)](_0x713398)?-(-0x200f*0x1+0x677*0x6+-0x6ba):-0x29*0xb7+0x6c1+0x168f;if(_0x555f64[_0x3d958e(0x315)](_0x713398,'HP'))_0x416927[_0x3d958e(0xc04)](_0x555f64['YjwpU'](_0x472ff3,_0x241a1d));if(_0x555f64[_0x3d958e(0x315)](_0x713398,'MP'))_0x416927['gainMp'](_0x555f64['chKNm'](_0x472ff3,_0x241a1d));},Game_Action['prototype'][_0xe90fac(0x455)+_0xe90fac(0x135d)]=function(_0xbd5863,_0x314a8f){const _0x4c9f8d=_0xe90fac;if(this['isCancelLi'+_0x4c9f8d(0x12ef)](_0xbd5863))return-0x11cf+-0x1c17+0x2de6;if(this[_0x4c9f8d(0xdf5)]()[_0x4c9f8d(0x1bb)+_0x4c9f8d(0x12ef)](_0xbd5863))return-0x23*0x7d+0x61f*-0x1+0x1736;if(_0x314a8f[_0x4c9f8d(0xc96)+_0x4c9f8d(0x15ab)](_0xbd5863))return 0x184e+-0x54*-0x31+-0x2862;let _0xa1d96c=-0x257*-0x7+0xb7e*0x1+-0x1bdf;return _0xa1d96c+=this['itemLifeSt'+'ealRate'](_0xbd5863),_0xa1d96c+=this[_0x4c9f8d(0xdf5)]()['lifeStealR'+'ate'](_0xbd5863,this[_0x4c9f8d(0xdd)]()[_0x4c9f8d(0x3cf)]),_0xa1d96c[_0x4c9f8d(0x61c)](0xa9f*-0x1+0x2*0x3c5+0x315,-0xd*-0x8e+0x3c1+0xaf6*-0x1);},Game_Action[_0xe90fac(0x510)][_0xe90fac(0x29a)+'feSteal']=function(_0x10c373){const _0x14d9af=_0xe90fac,_0x374c5b={'tQUJh':function(_0x3b90d6,_0x37018a){return _0x3b90d6===_0x37018a;},'YfyTi':function(_0x11fd6e,_0x3afa02){return _0x11fd6e===_0x3afa02;}};_0x10c373=_0x10c373[_0x14d9af(0x1318)+'e']()['trim']();const _0x59b773=VisuMZ[_0x14d9af(0x118f)]['LifeStealR'+_0x14d9af(0xb17)],_0xb00b14=this[_0x14d9af(0xdd)]()['note']||'';if(_0xb00b14[_0x14d9af(0x3eb)](_0x59b773[_0x14d9af(0xb8e)+_0x14d9af(0xa6f)]))return!![];if(_0x374c5b[_0x14d9af(0x1479)](_0x10c373,'HP')&&_0xb00b14[_0x14d9af(0x3eb)](_0x59b773[_0x14d9af(0x154a)+_0x14d9af(0x12ef)]))return!![];if(_0x374c5b[_0x14d9af(0xdab)](_0x10c373,'MP')&&_0xb00b14['match'](_0x59b773['cancelMpLi'+'feSteal']))return!![];return![];},Game_Action[_0xe90fac(0x510)][_0xe90fac(0x148d)+_0xe90fac(0xe14)]=function(_0x423822){const _0x26c6ca=_0xe90fac,_0xf5a649={'iMLOr':function(_0x4a471a,_0x229135){return _0x4a471a(_0x229135);},'YCvww':function(_0x189cda,_0x12c574){return _0x189cda*_0x12c574;},'wJAiH':function(_0x2428d7,_0x12ff25){return _0x2428d7(_0x12ff25);},'EOBlv':function(_0x122f55,_0x29a6e2){return _0x122f55!==_0x29a6e2;}},_0x18333a=VisuMZ[_0x26c6ca(0x118f)][_0x26c6ca(0x9ce)+_0x26c6ca(0xb17)],_0x2d8bfe=this[_0x26c6ca(0xdd)]()[_0x26c6ca(0xfee)]||'';_0x423822=_0x423822[_0x26c6ca(0x1318)+'e']()[_0x26c6ca(0x808)]();const _0x3b9a0e=_0x2d8bfe[_0x26c6ca(0x3eb)](_0x18333a['lifeSteaIt'+'em']);if(_0x3b9a0e)for(const _0x5b5d23 of _0x3b9a0e){_0x5b5d23[_0x26c6ca(0x3eb)](_0x18333a[_0x26c6ca(0x49f)+'em']);const _0x546cab=_0xf5a649[_0x26c6ca(0x32d)](String,RegExp['$1'])[_0x26c6ca(0x1318)+'e']()[_0x26c6ca(0x808)](),_0x54899c=_0xf5a649['YCvww'](_0xf5a649['wJAiH'](Number,RegExp['$2']),-0x26e8+0x26a4+0x44+0.01);if(_0xf5a649[_0x26c6ca(0x4bc)](_0x546cab,_0x423822))continue;return _0x54899c;}return 0x9a1+-0x31*-0xbf+-0x2e30;},Game_BattlerBase['prototype'][_0xe90fac(0x455)+_0xe90fac(0x135d)]=function(_0x74a225,_0x30974c){const _0x2bfe32=_0xe90fac,_0x3a4e56={'TWRDO':function(_0x22487a,_0x562eba){return _0x22487a(_0x562eba);},'dSeiD':function(_0x852323,_0x1ef90b){return _0x852323(_0x1ef90b);},'xZMjn':function(_0x2d2422,_0x1bcc36){return _0x2d2422*_0x1bcc36;},'UdSta':function(_0x1c968b,_0x50dc2e){return _0x1c968b(_0x50dc2e);},'Fffzs':function(_0x8d1849,_0x3ee599){return _0x8d1849!==_0x3ee599;},'tEKkj':function(_0x1947a3,_0xcd0d30){return _0x1947a3===_0xcd0d30;},'CVRav':function(_0x66f868,_0x3f189d){return _0x66f868===_0x3f189d;},'qLUqv':function(_0x4f8ac2,_0x24a252){return _0x4f8ac2===_0x24a252;}},_0x55bbd7=VisuMZ[_0x2bfe32(0x118f)][_0x2bfe32(0x9ce)+_0x2bfe32(0xb17)];let _0x3c49fd=0xa22*-0x2+-0x148f*-0x1+-0x4b;_0x74a225=_0x74a225[_0x2bfe32(0x1318)+'e']()[_0x2bfe32(0x808)]();for(const _0x385929 of this['traitObjec'+'ts']()){if(!_0x385929)continue;const _0x57e62d=_0x385929[_0x2bfe32(0xfee)]||'',_0x244fb1=_0x57e62d[_0x2bfe32(0x3eb)](_0x55bbd7['lifeStealT'+_0x2bfe32(0x1000)]);if(_0x244fb1)for(const _0x39ca7d of _0x244fb1){_0x39ca7d[_0x2bfe32(0x3eb)](_0x55bbd7['lifeStealT'+_0x2bfe32(0x1000)]);const _0x584982=_0x3a4e56[_0x2bfe32(0x14fc)](String,RegExp['$1'])[_0x2bfe32(0x1318)+'e']()[_0x2bfe32(0x808)](),_0x30649b=_0x3a4e56[_0x2bfe32(0x15a6)](String,RegExp['$2']),_0x304603=_0x3a4e56[_0x2bfe32(0x14ed)](_0x3a4e56[_0x2bfe32(0xdd7)](Number,RegExp['$3']),-0x2*-0xfcd+0x1784+0xa6*-0x55+0.01);if(_0x3a4e56['Fffzs'](_0x584982,_0x74a225))continue;if(_0x3a4e56[_0x2bfe32(0xc28)](_0x30974c,Game_Action[_0x2bfe32(0x60f)+'RTAIN'])&&_0x30649b['match'](/CERTAIN/i))_0x3c49fd+=_0x304603;else{if(_0x3a4e56[_0x2bfe32(0x444)](_0x30974c,Game_Action['HITTYPE_PH'+_0x2bfe32(0x1500)])&&_0x30649b[_0x2bfe32(0x3eb)](/PHYS/i))_0x3c49fd+=_0x304603;else _0x3a4e56[_0x2bfe32(0xe48)](_0x30974c,Game_Action['HITTYPE_MA'+_0x2bfe32(0x7ee)])&&_0x30649b[_0x2bfe32(0x3eb)](/MAGIC/i)&&(_0x3c49fd+=_0x304603);}}}return _0x3c49fd;},Game_BattlerBase[_0xe90fac(0x510)][_0xe90fac(0x1bb)+_0xe90fac(0x12ef)]=function(_0x808a6d){const _0x27c0bb=_0xe90fac,_0x461c5e={'ZOkXg':function(_0x529fdc,_0x243b66){return _0x529fdc===_0x243b66;}};_0x808a6d=_0x808a6d[_0x27c0bb(0x1318)+'e']()[_0x27c0bb(0x808)]();const _0x43150c=VisuMZ[_0x27c0bb(0x118f)][_0x27c0bb(0x9ce)+_0x27c0bb(0xb17)];for(const _0x54ec73 of this[_0x27c0bb(0x412)+'ts']()){if(!_0x54ec73)continue;const _0xa4dfe0=_0x54ec73[_0x27c0bb(0xfee)]||'';if(_0xa4dfe0[_0x27c0bb(0x3eb)](_0x43150c[_0x27c0bb(0x736)+_0x27c0bb(0xa6f)]))return!![];if(_0x461c5e[_0x27c0bb(0x13fd)](_0x808a6d,'HP')&&_0xa4dfe0[_0x27c0bb(0x3eb)](_0x43150c[_0x27c0bb(0x338)+'feSteal']))return!![];if(_0x461c5e[_0x27c0bb(0x13fd)](_0x808a6d,'MP')&&_0xa4dfe0[_0x27c0bb(0x3eb)](_0x43150c[_0x27c0bb(0x4ee)+_0x27c0bb(0x12ef)]))return!![];}return![];},Game_BattlerBase['prototype'][_0xe90fac(0x11c5)+'LifeSteal']=function(_0x536a45){const _0xd3e4d5=_0xe90fac,_0x42c50e={'komnj':function(_0x1d6931,_0x17cbac){return _0x1d6931===_0x17cbac;},'ERmYe':function(_0x17f011,_0x13a884){return _0x17f011===_0x13a884;}};_0x536a45=_0x536a45[_0xd3e4d5(0x1318)+'e']()['trim']();const _0x49db62=VisuMZ['BattleCore'][_0xd3e4d5(0x9ce)+_0xd3e4d5(0xb17)];for(const _0x33e7f1 of this['traitObjec'+'ts']()){if(!_0x33e7f1)continue;const _0x5b3da4=_0x33e7f1['note']||'';if(_0x5b3da4[_0xd3e4d5(0x3eb)](_0x49db62['negativeLi'+'feSteal']))return!![];if(_0x42c50e[_0xd3e4d5(0xbda)](_0x536a45,'HP')&&_0x5b3da4['match'](_0x49db62[_0xd3e4d5(0x85b)+_0xd3e4d5(0x70c)]))return!![];if(_0x42c50e[_0xd3e4d5(0xf0c)](_0x536a45,'MP')&&_0x5b3da4['match'](_0x49db62[_0xd3e4d5(0x8db)+'LifeSteal']))return!![];}return![];},Game_BattlerBase[_0xe90fac(0x510)][_0xe90fac(0xc96)+_0xe90fac(0x15ab)]=function(_0x3281fc){const _0x3f7ce0=_0xe90fac,_0x135825={'pmhmq':function(_0xde5aae,_0x306d3a){return _0xde5aae===_0x306d3a;}};_0x3281fc=_0x3281fc[_0x3f7ce0(0x1318)+'e']()['trim']();const _0x5135a7=VisuMZ[_0x3f7ce0(0x118f)][_0x3f7ce0(0x9ce)+'egExp'];for(const _0x30a6ed of this[_0x3f7ce0(0x412)+'ts']()){if(!_0x30a6ed)continue;const _0x140eff=_0x30a6ed['note']||'';if(_0x140eff[_0x3f7ce0(0x3eb)](_0x5135a7[_0x3f7ce0(0x344)+'teal']))return!![];if(_0x135825[_0x3f7ce0(0x1324)](_0x3281fc,'HP')&&_0x140eff[_0x3f7ce0(0x3eb)](_0x5135a7[_0x3f7ce0(0x7d2)+'eSteal']))return!![];if(_0x135825[_0x3f7ce0(0x1324)](_0x3281fc,'MP')&&_0x140eff[_0x3f7ce0(0x3eb)](_0x5135a7['guardMpLif'+_0x3f7ce0(0x15ab)]))return!![];}return![];},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x6e8)+'erBase_ini'+_0xe90fac(0x1343)]=Game_BattlerBase[_0xe90fac(0x510)][_0xe90fac(0x11d5)+'s'],Game_BattlerBase[_0xe90fac(0x510)][_0xe90fac(0x11d5)+'s']=function(){const _0x236f7e=_0xe90fac;VisuMZ[_0x236f7e(0x118f)][_0x236f7e(0x6e8)+_0x236f7e(0x1542)+_0x236f7e(0x1343)][_0x236f7e(0x351)](this),this[_0x236f7e(0x11d5)+_0x236f7e(0xf2e)+'e']();},Game_BattlerBase[_0xe90fac(0x510)][_0xe90fac(0x11d5)+_0xe90fac(0xf2e)+'e']=function(){const _0x33bff3=_0xe90fac;this[_0x33bff3(0x1269)]=![];},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x6e8)+'erBase_ref'+'resh']=Game_BattlerBase[_0xe90fac(0x510)][_0xe90fac(0x944)],Game_BattlerBase[_0xe90fac(0x510)]['refresh']=function(){const _0x202d5c=_0xe90fac;this[_0x202d5c(0xe7)]={},VisuMZ['BattleCore'][_0x202d5c(0x6e8)+'erBase_ref'+_0x202d5c(0x111c)]['call'](this);},Game_BattlerBase[_0xe90fac(0x510)]['checkCache'+_0xe90fac(0x66d)]=function(_0x52136e){const _0x13fbef=_0xe90fac,_0x419212={'YcyXR':function(_0x5a1c75,_0x5ddae9){return _0x5a1c75!==_0x5ddae9;}};return this[_0x13fbef(0xe7)]=this[_0x13fbef(0xe7)]||{},_0x419212[_0x13fbef(0x8c2)](this['_cache'][_0x52136e],undefined);},Game_BattlerBase[_0xe90fac(0x510)][_0xe90fac(0xae6)+_0xe90fac(0xd3d)]=function(){const _0x229b57=_0xe90fac,_0x161030={'XBNQv':function(_0x2cfb92,_0xfc9084){return _0x2cfb92!==_0xfc9084;},'NBEcx':function(_0x3211a0,_0x2ca931){return _0x3211a0>_0x2ca931;},'UGHIw':function(_0x398221,_0x4e858c){return _0x398221<=_0x4e858c;}};if(_0x161030[_0x229b57(0x8b9)](this[_0x229b57(0xe7)]['hardDamage'+_0x229b57(0xd3d)],undefined))return this[_0x229b57(0xe7)][_0x229b57(0xae6)+'Cap'];const _0x16273d=/<DAMAGE CAP:[ ](\d+)>/i,_0x1eba40=this['traitObjec'+'ts']()['map'](_0xfa9174=>_0xfa9174&&_0xfa9174[_0x229b57(0xfee)]['match'](_0x16273d)?Number(RegExp['$1']):-0x75b*0x3+0x174+0x149d);let _0x45af45=_0x161030[_0x229b57(0xcf4)](_0x1eba40[_0x229b57(0x1268)],0x236*-0x7+-0x13ff+-0x2379*-0x1)?Math[_0x229b57(0xd3e)](..._0x1eba40):0x155+0x1c58+-0x47*0x6b;if(_0x161030[_0x229b57(0x411)](_0x45af45,0x1d3f+0x139b+-0x30da))_0x45af45=VisuMZ[_0x229b57(0x118f)][_0x229b57(0x281)][_0x229b57(0x7d7)][_0x229b57(0x1184)+_0x229b57(0x740)];return this['_cache']['hardDamage'+_0x229b57(0xd3d)]=_0x45af45,this[_0x229b57(0xe7)]['hardDamage'+'Cap'];},Game_BattlerBase[_0xe90fac(0x510)][_0xe90fac(0xf74)+_0xe90fac(0x103d)]=function(){const _0x646a36=_0xe90fac,_0x31b8c4={'xVXSz':function(_0x54c24b,_0x2b0f09){return _0x54c24b!==_0x2b0f09;}};if(_0x31b8c4['xVXSz'](this[_0x646a36(0xe7)][_0x646a36(0xf74)+_0x646a36(0xd3d)],undefined))return this[_0x646a36(0xe7)][_0x646a36(0xf74)+_0x646a36(0xd3d)];let _0x4ba3d3=VisuMZ['BattleCore'][_0x646a36(0x281)]['Damage'][_0x646a36(0xe3b)+_0x646a36(0x90)];const _0x5a29ca=/<SOFT DAMAGE CAP:[ ]([\+\-]\d+)([%％])>/i,_0x1eda2a=this['traitObjec'+'ts']()[_0x646a36(0x457)](_0x532234=>_0x532234&&_0x532234['note'][_0x646a36(0x3eb)](_0x5a29ca)?Number(RegExp['$1'])/(0x11*-0x1cb+0x1de7+0x4*0x3e):-0x11*-0x171+-0x48c+-0x13f5);return _0x4ba3d3=_0x1eda2a[_0x646a36(0x1313)]((_0x2bdc49,_0x1b407d)=>_0x2bdc49+_0x1b407d,_0x4ba3d3),this[_0x646a36(0xe7)][_0x646a36(0xf74)+'Cap']=_0x4ba3d3,this['_cache'][_0x646a36(0xf74)+_0x646a36(0xd3d)]['clamp'](-0x244b+-0x167*0xf+0x3954+0.01,0x9c9+-0x1e0d+0x1445);},VisuMZ[_0xe90fac(0x118f)]['Game_Battl'+_0xe90fac(0xfd9)]=Game_BattlerBase[_0xe90fac(0x510)][_0xe90fac(0x12a4)],Game_BattlerBase[_0xe90fac(0x510)][_0xe90fac(0x12a4)]=function(){const _0x404e4a=_0xe90fac,_0x4b57c7={'gmGMC':_0x404e4a(0x10a5)};VisuMZ['BattleCore'][_0x404e4a(0x6e8)+'erBase_die'][_0x404e4a(0x351)](this),SceneManager['isSceneBat'+'tle']()&&(this[_0x404e4a(0xa08)+_0x404e4a(0x130a)](_0x4b57c7[_0x404e4a(0xdf7)]),this['_performDa'+_0x404e4a(0x7c8)]=undefined);},Game_BattlerBase[_0xe90fac(0x510)][_0xe90fac(0x81d)]=function(){const _0x50ff72=_0xe90fac;if(!SceneManager['isSceneBat'+'tle']())return null;if(!SceneManager[_0x50ff72(0x11dd)][_0x50ff72(0x981)])return null;return SceneManager[_0x50ff72(0x11dd)][_0x50ff72(0x981)][_0x50ff72(0x20c)+_0x50ff72(0x15e6)](this);},Game_BattlerBase[_0xe90fac(0x510)]['svBattlerA'+_0xe90fac(0x13e7)]=function(){const _0x550bbc=_0xe90fac;return VisuMZ[_0x550bbc(0x118f)][_0x550bbc(0x281)]['Actor'][_0x550bbc(0x7f3)];},Game_BattlerBase['prototype'][_0xe90fac(0x1465)+'nchorY']=function(){const _0x353775=_0xe90fac;return VisuMZ['BattleCore'][_0x353775(0x281)][_0x353775(0xd11)][_0x353775(0xfd3)];},Game_BattlerBase['prototype'][_0xe90fac(0xa25)+_0xe90fac(0x1607)+'le']=function(){const _0x50c6b8=_0xe90fac;return this['isActor']&&this[_0x50c6b8(0xd83)]()?VisuMZ[_0x50c6b8(0x118f)]['Settings'][_0x50c6b8(0xd11)]['Shadow']:VisuMZ['BattleCore'][_0x50c6b8(0x281)][_0x50c6b8(0x105f)][_0x50c6b8(0x532)];},Game_BattlerBase[_0xe90fac(0x510)][_0xe90fac(0x15fe)+_0xe90fac(0xa73)]=function(){return!![];},Game_BattlerBase[_0xe90fac(0x510)]['battleUIOf'+_0xe90fac(0x53c)]=function(){return 0x328+0x687+-0x9af;},Game_BattlerBase[_0xe90fac(0x510)][_0xe90fac(0xb31)+_0xe90fac(0xebf)]=function(){return-0x7ed+0x1596+0x10d*-0xd;},Game_BattlerBase[_0xe90fac(0x510)][_0xe90fac(0x4e3)+'leUIOffset'+'X']=function(_0x2e68f2){const _0x424b23=_0xe90fac,_0x5ad997={'LCFQL':function(_0x5042c6,_0x1b431f){return _0x5042c6(_0x1b431f);}};if(!_0x2e68f2)return-0x1*-0x1d6c+-0xad0+-0x129c;let _0x4331ee=-0x10e0+0x11*-0x1b1+0x2da1*0x1;const _0x44ee7e=_0x2e68f2[_0x424b23(0xfee)];return _0x44ee7e['match'](/<BATTLE UI OFFSET X:[ ]([\+\-]\d+)>/i)&&(_0x4331ee+=_0x5ad997[_0x424b23(0x155c)](Number,RegExp['$1'])),_0x44ee7e['match'](/<BATTLE UI OFFSET:[ ]([\+\-]\d+),[ ]([\+\-]\d+)>/i)&&(_0x4331ee+=_0x5ad997[_0x424b23(0x155c)](Number,RegExp['$1'])),_0x4331ee;},Game_BattlerBase['prototype'][_0xe90fac(0x4e3)+_0xe90fac(0xd07)+'Y']=function(_0x2be39f){const _0x135a44=_0xe90fac,_0x252f2b={'tcsiT':function(_0xf842a7,_0x3491b9){return _0xf842a7(_0x3491b9);}};if(!_0x2be39f)return 0x523+-0x2*0x12ae+0x2039;let _0x3637a5=0x165f+0x36*0x37+-0x21f9;const _0x2777c3=_0x2be39f[_0x135a44(0xfee)];return _0x2777c3['match'](/<BATTLE UI OFFSET Y:[ ]([\+\-]\d+)>/i)&&(_0x3637a5+=_0x252f2b['tcsiT'](Number,RegExp['$1'])),_0x2777c3['match'](/<BATTLE UI OFFSET:[ ]([\+\-]\d+),[ ]([\+\-]\d+)>/i)&&(_0x3637a5+=_0x252f2b['tcsiT'](Number,RegExp['$2'])),_0x3637a5;},VisuMZ['BattleCore'][_0xe90fac(0x6e8)+'erBase_isS'+_0xe90fac(0x143c)]=Game_BattlerBase[_0xe90fac(0x510)][_0xe90fac(0x242)+_0xe90fac(0xf85)],Game_BattlerBase['prototype'][_0xe90fac(0x242)+_0xe90fac(0xf85)]=function(_0x1dda28){const _0x1a35b6=_0xe90fac,_0x130627={'fREKz':function(_0x554bbf,_0x372775){return _0x554bbf===_0x372775;}};if(_0x130627[_0x1a35b6(0x99e)](_0x1dda28,this['deathState'+'Id']())&&this[_0x1a35b6(0x852)]())return!![];return VisuMZ[_0x1a35b6(0x118f)]['Game_Battl'+_0x1a35b6(0x45e)+_0x1a35b6(0x143c)][_0x1a35b6(0x351)](this,_0x1dda28);},Game_BattlerBase['prototype'][_0xe90fac(0x852)]=function(){const _0x5a3e97=_0xe90fac;return this[_0x5a3e97(0x1269)];},Game_BattlerBase[_0xe90fac(0x510)][_0xe90fac(0xd9)+'l']=function(_0x317e0e){const _0x2db6fe=_0xe90fac;_0x317e0e?this['addImmorta'+'l']():this['removeImmo'+_0x2db6fe(0xb19)]();},Game_BattlerBase[_0xe90fac(0x510)][_0xe90fac(0x1196)+'l']=function(){const _0x4ce7c2=_0xe90fac;if(this['isDead']())return;this[_0x4ce7c2(0x1269)]=!![],this[_0x4ce7c2(0x3c0)+_0x4ce7c2(0x138b)]=![];},Game_BattlerBase[_0xe90fac(0x510)][_0xe90fac(0x3a5)+'rtal']=function(){const _0x3a6db4=_0xe90fac,_0x11280e=this[_0x3a6db4(0xb30)]();this[_0x3a6db4(0x1269)]=![],_0x11280e&&this[_0x3a6db4(0x3c0)+_0x3a6db4(0x138b)]&&this['die'](),this['_deathStat'+_0x3a6db4(0x138b)]=![],this[_0x3a6db4(0x944)](),this[_0x3a6db4(0x17d)]()&&_0x11280e&&(this[_0x3a6db4(0x4a2)+_0x3a6db4(0x65d)](),this[_0x3a6db4(0xa08)+'ionRefresh']());},VisuMZ['BattleCore'][_0xe90fac(0xf8b)+'n_numRepea'+'ts']=Game_Action['prototype'][_0xe90fac(0xe6b)],Game_Action[_0xe90fac(0x510)][_0xe90fac(0xe6b)]=function(){const _0x343d64=_0xe90fac;return this[_0x343d64(0xdd)]()?VisuMZ['BattleCore'][_0x343d64(0xf8b)+'n_numRepea'+'ts'][_0x343d64(0x351)](this):0x221*-0xd+0x8d0+-0x1b7*-0xb;},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xf8b)+_0xe90fac(0xd71)+'k']=Game_Action[_0xe90fac(0x510)][_0xe90fac(0x1207)],Game_Action[_0xe90fac(0x510)]['setAttack']=function(){const _0x42ef04=_0xe90fac;this[_0x42ef04(0xdf5)]()&&this[_0x42ef04(0xdf5)]()['canAttack']()?VisuMZ[_0x42ef04(0x118f)][_0x42ef04(0xf8b)+_0x42ef04(0xd71)+'k'][_0x42ef04(0x351)](this):this[_0x42ef04(0xf98)]();},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x6e8)+_0xe90fac(0x11fd)+_0xe90fac(0x114a)]=Game_BattlerBase[_0xe90fac(0x510)]['canAttack'],Game_BattlerBase[_0xe90fac(0x510)][_0xe90fac(0xe59)]=function(){const _0x3ac747=_0xe90fac;if(!this['canAttackB'+_0x3ac747(0x402)]())return![];return VisuMZ[_0x3ac747(0x118f)][_0x3ac747(0x6e8)+'erBase_can'+'Attack']['call'](this);},Game_BattlerBase['prototype']['canAttackB'+_0xe90fac(0x402)]=function(){const _0x5f0a9f=_0xe90fac;for(const _0x102560 of this[_0x5f0a9f(0x412)+'ts']()){if(!_0x102560)continue;if(_0x102560['note']['match'](/<(?:ATTACK SEAL|SEAL ATTACK)>/i))return![];}return!![];},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xf8b)+'n_setGuard']=Game_Action['prototype']['setGuard'],Game_Action['prototype']['setGuard']=function(){const _0x3e381d=_0xe90fac;this[_0x3e381d(0xdf5)]()[_0x3e381d(0x11a8)]()&&VisuMZ[_0x3e381d(0x118f)][_0x3e381d(0xf8b)+'n_setGuard']['call'](this);},VisuMZ['BattleCore'][_0xe90fac(0x6e8)+_0xe90fac(0x11fd)+_0xe90fac(0xdfa)]=Game_BattlerBase['prototype'][_0xe90fac(0x11a8)],Game_BattlerBase['prototype'][_0xe90fac(0x11a8)]=function(){const _0x568034=_0xe90fac;if(!this[_0x568034(0x3d7)+_0x568034(0xc12)]())return![];return VisuMZ[_0x568034(0x118f)][_0x568034(0x6e8)+_0x568034(0x11fd)+'Guard'][_0x568034(0x351)](this);},Game_BattlerBase[_0xe90fac(0x510)][_0xe90fac(0x3d7)+_0xe90fac(0xc12)]=function(){const _0x424806=_0xe90fac;for(const _0xc52b18 of this['traitObjec'+'ts']()){if(!_0xc52b18)continue;if(_0xc52b18[_0x424806(0xfee)][_0x424806(0x3eb)](/<(?:GUARD SEAL|SEAL GUARD)>/i))return![];}return!![];},Game_BattlerBase['prototype']['canUseItem'+_0xe90fac(0x1290)]=function(){const _0x1be58b=_0xe90fac;for(const _0x520c8e of this[_0x1be58b(0x412)+'ts']()){if(!_0x520c8e)continue;if(_0x520c8e[_0x1be58b(0xfee)]['match'](/<(?:ITEM SEAL|SEAL ITEM|SEAL ITEMS)>/i))return![];}return!![];},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x6e8)+_0xe90fac(0xb00)+_0xe90fac(0x829)+_0xe90fac(0x99f)+'ns']=Game_BattlerBase[_0xe90fac(0x510)][_0xe90fac(0xf04)+_0xe90fac(0xf2b)+_0xe90fac(0x972)],Game_BattlerBase[_0xe90fac(0x510)][_0xe90fac(0xf04)+_0xe90fac(0xf2b)+_0xe90fac(0x972)]=function(_0x38c119){const _0x5798c9=_0xe90fac,_0x2354af={'YXcQF':function(_0x5071a6,_0x3294b0){return _0x5071a6===_0x3294b0;},'YcATA':function(_0x582326,_0x76866){return _0x582326===_0x76866;}};if(_0x38c119&&_0x38c119[_0x5798c9(0xfee)][_0x5798c9(0x3eb)](/<CANNOT TARGET (?:USER|SELF)>/i)){const _0xf70eba=this['friendsUni'+'t']()[_0x5798c9(0xf79)+'rs']();if(_0x2354af['YXcQF'](_0xf70eba[_0x5798c9(0x1268)],0x34d*-0xa+0x1*-0x1615+0x3718)&&_0x2354af[_0x5798c9(0xdbc)](_0xf70eba[0x102b*0x1+0x1361+-0x238c],this))return![];}return VisuMZ['BattleCore'][_0x5798c9(0x6e8)+_0x5798c9(0xb00)+_0x5798c9(0x829)+'emConditio'+'ns'][_0x5798c9(0x351)](this,_0x38c119);},Game_Battler['prototype']['allowRando'+_0xe90fac(0x546)]=function(){const _0x39873b=_0xe90fac;return VisuMZ[_0x39873b(0x118f)][_0x39873b(0x281)][_0x39873b(0x7dd)][_0x39873b(0x17e)+_0x39873b(0x546)];},VisuMZ['BattleCore'][_0xe90fac(0x6e8)+'er_regener'+'ateAll']=Game_Battler[_0xe90fac(0x510)][_0xe90fac(0xbeb)+_0xe90fac(0x3d9)],Game_Battler[_0xe90fac(0x510)][_0xe90fac(0xbeb)+_0xe90fac(0x3d9)]=function(){const _0x95c737=_0xe90fac,_0x379c3b={'xtnFr':_0x95c737(0x35a)+'0','vuoCQ':_0x95c737(0x69f)+_0x95c737(0x207),'aQCql':function(_0x13860b,_0x2f7266){return _0x13860b===_0x2f7266;},'KSfpn':_0x95c737(0x817)+_0x95c737(0xa6b),'xYRZl':function(_0x58b294,_0x2dcbad){return _0x58b294<=_0x2dcbad;}},_0x2dfa2f=_0x379c3b[_0x95c737(0x7cf)][_0x95c737(0xab1)]('|');let _0x289c0c=0x121f+-0x13e9+0x1ca;while(!![]){switch(_0x2dfa2f[_0x289c0c++]){case'0':SceneManager[_0x95c737(0x11be)+'tle']()&&(this[_0x95c737(0xbeb)+_0x95c737(0x1470)+_0x95c737(0x86e)](),this[_0x95c737(0x60b)+_0x95c737(0xf8a)](_0x379c3b[_0x95c737(0x113b)]));continue;case'1':if(SceneManager[_0x95c737(0x11be)+_0x95c737(0x3ad)]()&&BattleManager['isTpb']()&&_0x379c3b['aQCql'](this['_lastRegen'+_0x95c737(0x304)],Graphics[_0x95c737(0x12ac)]))return;continue;case'2':SceneManager[_0x95c737(0x11be)+_0x95c737(0x3ad)]()&&this[_0x95c737(0x60b)+_0x95c737(0xf8a)](_0x379c3b[_0x95c737(0xf0e)]);continue;case'3':this[_0x95c737(0xfc4)+_0x95c737(0x304)]=Graphics[_0x95c737(0x12ac)];continue;case'4':VisuMZ[_0x95c737(0x118f)][_0x95c737(0x6e8)+'er_regener'+_0x95c737(0x15b2)][_0x95c737(0x351)](this);continue;case'5':if(SceneManager[_0x95c737(0x11be)+_0x95c737(0x3ad)]()){if(BattleManager[_0x95c737(0x537)]()){if(_0x379c3b[_0x95c737(0x231)](this[_0x95c737(0x1097)](),0x1*0xcc8+-0x7a4+-0x524))return;}else{if(_0x379c3b[_0x95c737(0x231)]($gameTroop['turnCount'](),-0x1*0x229+-0x4*-0x335+-0xaab))return;}}continue;}break;}},Game_Battler['prototype'][_0xe90fac(0xbeb)+_0xe90fac(0x1470)+_0xe90fac(0x86e)]=function(){const _0x1b2ead=_0xe90fac;if(SceneManager[_0x1b2ead(0x11be)+'tle']())for(const _0x4fa9b2 of this['traitObjec'+'ts']()){if(!_0x4fa9b2)continue;this[_0x1b2ead(0x122d)+_0x1b2ead(0x1249)+_0x1b2ead(0x109d)](_0x4fa9b2);}},Game_Battler[_0xe90fac(0x510)][_0xe90fac(0x122d)+'tePlayStat'+_0xe90fac(0x109d)]=function(_0x260bde){const _0xbaafb9=_0xe90fac,_0x530be7={'jRyjB':function(_0x52e5da,_0x5bb17a){return _0x52e5da(_0x5bb17a);}};if(!Imported[_0xbaafb9(0x155e)+_0xbaafb9(0x100d)])return;if(!SceneManager[_0xbaafb9(0x11be)+_0xbaafb9(0x3ad)]())return;if(this[_0xbaafb9(0x17d)]())return;if(this[_0xbaafb9(0x1182)]())return;if(_0x260bde[_0xbaafb9(0xfee)][_0xbaafb9(0x3eb)](/<(?:REGENERATE|REGEN|DEGEN|DOT|SLIP)[ ]ANIMATION:[ ](\d+)>/i)){const _0x11149e=_0x530be7[_0xbaafb9(0x1452)](Number,RegExp['$1']);$gameTemp[_0xbaafb9(0x15a8)+'xAnimation']([this],_0x11149e,![],![]);}},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x6e8)+_0xe90fac(0x1125)+_0xe90fac(0x11d9)]=Game_Battler[_0xe90fac(0x510)][_0xe90fac(0x11eb)+'rn'],Game_Battler['prototype'][_0xe90fac(0x11eb)+'rn']=function(){const _0x2447a2=_0xe90fac,_0x5cd6e0={'ZprrF':_0x2447a2(0xbb4)+_0x2447a2(0xcc),'BFoFn':_0x2447a2(0x125a)+_0x2447a2(0xdb8)};this['processBat'+_0x2447a2(0xf8a)](_0x5cd6e0['ZprrF']),VisuMZ[_0x2447a2(0x118f)][_0x2447a2(0x6e8)+_0x2447a2(0x1125)+_0x2447a2(0x11d9)][_0x2447a2(0x351)](this),this[_0x2447a2(0x60b)+_0x2447a2(0xf8a)](_0x5cd6e0['BFoFn']);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x6e8)+_0xe90fac(0x14b6)+'nd']=Game_Battler[_0xe90fac(0x510)]['onTurnEnd'],Game_Battler[_0xe90fac(0x510)]['onTurnEnd']=function(){const _0x2eca2b=_0xe90fac,_0x5397ec={'tUJmp':'PreEndTurn'+'JS','OKAcz':_0x2eca2b(0xb08)+'nJS'};this[_0x2eca2b(0x60b)+_0x2eca2b(0xf8a)](_0x5397ec[_0x2eca2b(0xbe1)]),VisuMZ[_0x2eca2b(0x118f)][_0x2eca2b(0x6e8)+_0x2eca2b(0x14b6)+'nd']['call'](this),VisuMZ['BattleCore'][_0x2eca2b(0x281)]['Mechanics'][_0x2eca2b(0x1572)+'pire']&&this[_0x2eca2b(0x1526)+_0x2eca2b(0x164)](),this['processBat'+_0x2eca2b(0xf8a)](_0x5397ec['OKAcz']);},Game_Battler[_0xe90fac(0x510)][_0xe90fac(0x60b)+'tleCoreJS']=function(_0x3a4b17){const _0x53eb19=_0xe90fac;if(this[_0x53eb19(0x1404)+'er']||this['_tempActor'])return;const _0x3f7c5e=VisuMZ[_0x53eb19(0x118f)]['Settings'][_0x53eb19(0x7dd)];if(_0x3f7c5e[_0x3a4b17])_0x3f7c5e[_0x3a4b17][_0x53eb19(0x351)](this);for(const _0x5c61fd of this['traitObjec'+'ts']()){if(!_0x5c61fd)continue;key=VisuMZ[_0x53eb19(0x118f)]['createKeyJ'+'S'](_0x5c61fd,_0x3a4b17),VisuMZ[_0x53eb19(0x118f)]['JS'][key]&&VisuMZ[_0x53eb19(0x118f)]['JS'][key][_0x53eb19(0x351)](this,this,this,_0x5c61fd,0x2*0x98+-0x1*0x2291+-0x2161*-0x1);}},Game_Battler[_0xe90fac(0x510)][_0xe90fac(0xe3c)]=function(){const _0x223678=_0xe90fac;return VisuMZ[_0x223678(0x118f)]['Settings'][_0x223678(0xd11)][_0x223678(0xc1)]||![];},Game_Battler[_0xe90fac(0x510)][_0xe90fac(0x13a1)]=function(){const _0x2f7c03=_0xe90fac,_0x5eec79={'TWbcX':function(_0x18ebc9,_0x43208e){return _0x18ebc9===_0x43208e;},'wHRrP':_0x2f7c03(0x8c8)};if(this[_0x2f7c03(0x2e6)]()){if(this['chantStyle']()){if(this[_0x2f7c03(0x146a)][_0x2f7c03(0xcaa)](_0x13a2c4=>_0x13a2c4[_0x2f7c03(0xdd)]()&&_0x13a2c4[_0x2f7c03(0x717)]()))return!![];}else{if(this[_0x2f7c03(0x146a)][_0x2f7c03(0xcaa)](_0x1b6ed2=>_0x1b6ed2['item']()&&_0x1b6ed2[_0x2f7c03(0x1560)+'ll']()))return!![];}}if(BattleManager['isTpb']()&&_0x5eec79[_0x2f7c03(0x894)](this[_0x2f7c03(0x14dd)],_0x5eec79[_0x2f7c03(0x890)]))return this[_0x2f7c03(0xe3c)]()?this[_0x2f7c03(0x7f5)+_0x2f7c03(0x130a)]()&&this[_0x2f7c03(0x7f5)+_0x2f7c03(0x130a)]()[_0x2f7c03(0xdd)]()&&this[_0x2f7c03(0x7f5)+_0x2f7c03(0x130a)]()[_0x2f7c03(0x717)]():this[_0x2f7c03(0x7f5)+_0x2f7c03(0x130a)]()&&this[_0x2f7c03(0x7f5)+_0x2f7c03(0x130a)]()[_0x2f7c03(0xdd)]()&&this['currentAct'+_0x2f7c03(0x130a)]()['isMagicSki'+'ll']();return![];},Game_Battler['prototype'][_0xe90fac(0xd9c)]=function(){const _0x7c5cda=_0xe90fac,_0x584788={'IKmqz':function(_0x20b87e,_0x52aebd){return _0x20b87e===_0x52aebd;},'qyFoR':_0x7c5cda(0x8c8)};if(BattleManager['isTpb']()&&_0x584788['IKmqz'](this[_0x7c5cda(0x14dd)],_0x584788[_0x7c5cda(0x101d)]))return this['chantStyle']()?this[_0x7c5cda(0x7f5)+_0x7c5cda(0x130a)]()&&this['currentAct'+_0x7c5cda(0x130a)]()[_0x7c5cda(0xdd)]()&&!this[_0x7c5cda(0x7f5)+_0x7c5cda(0x130a)]()[_0x7c5cda(0x717)]():this[_0x7c5cda(0x7f5)+_0x7c5cda(0x130a)]()&&this[_0x7c5cda(0x7f5)+_0x7c5cda(0x130a)]()[_0x7c5cda(0xdd)]()&&!this[_0x7c5cda(0x7f5)+'ion']()[_0x7c5cda(0x1560)+'ll']();return![];},VisuMZ['BattleCore'][_0xe90fac(0x6e8)+_0xe90fac(0x126a)+_0xe90fac(0xeaa)]=Game_Battler[_0xe90fac(0x510)][_0xe90fac(0x142e)+'ePopup'],Game_Battler[_0xe90fac(0x510)][_0xe90fac(0x142e)+'ePopup']=function(){const _0xc4d8bf=_0xe90fac;VisuMZ['BattleCore'][_0xc4d8bf(0x6e8)+_0xc4d8bf(0x126a)+_0xc4d8bf(0xeaa)][_0xc4d8bf(0x351)](this),this['_damagePop'+_0xc4d8bf(0x52c)]=[];},Game_Battler[_0xe90fac(0x510)][_0xe90fac(0xc6e)+_0xe90fac(0x1477)+'ed']=function(){const _0x5ae2ad=_0xe90fac,_0x5a4b1a={'QYFXf':function(_0x11aae2,_0x4e2621){return _0x11aae2>_0x4e2621;}};if(!this[_0x5ae2ad(0x6d9)+_0x5ae2ad(0x52c)])this[_0x5ae2ad(0x142e)+_0x5ae2ad(0xeeb)]();return _0x5a4b1a[_0x5ae2ad(0x1345)](this[_0x5ae2ad(0x6d9)+'upArray'][_0x5ae2ad(0x1268)],0x13d1+-0x3*-0x157+-0xe2*0x1b);},Game_Battler[_0xe90fac(0x510)][_0xe90fac(0x6ce)+_0xe90fac(0xeeb)]=function(){const _0x245265=_0xe90fac;if(!SceneManager[_0x245265(0x11be)+_0x245265(0x3ad)]())return;if(BattleManager['shouldHide'+'BattleEndP'+_0x245265(0x12fb)]())return;if(!this[_0x245265(0x6d9)+_0x245265(0x52c)])this['clearDamag'+_0x245265(0xeeb)]();this[_0x245265(0x935)+'rateDamage'+'Popups']();const _0x46fac5=this[_0x245265(0x81d)]();if(_0x46fac5)_0x46fac5[_0x245265(0x416)+_0x245265(0xeeb)]();},Game_Battler[_0xe90fac(0x510)][_0xe90fac(0x935)+_0xe90fac(0x6e5)+'Popups']=function(){const _0x52d3a6=_0xe90fac,_0x401167={'tRgbC':function(_0x21e2d8,_0x3750f4){return _0x21e2d8!==_0x3750f4;}},_0x5e9552=this[_0x52d3a6(0x1c5)]();if(_0x5e9552[_0x52d3a6(0x324)]||_0x5e9552[_0x52d3a6(0x49a)]){const _0x16ee7d=JsonEx[_0x52d3a6(0x2f7)+'py'](_0x5e9552);_0x16ee7d[_0x52d3a6(0xf67)]=![],_0x16ee7d[_0x52d3a6(0x1381)]=0x6*-0x4cb+0x5*-0x23+-0x1*-0x1d71,this[_0x52d3a6(0x6d9)+_0x52d3a6(0x52c)][_0x52d3a6(0x15f1)](_0x16ee7d);if(!_0x5e9552[_0x52d3a6(0x4da)]&&!_0x5e9552['mpDamage'])return;}if(_0x5e9552[_0x52d3a6(0xf67)]){const _0x479c24=JsonEx[_0x52d3a6(0x2f7)+'py'](_0x5e9552);_0x479c24['missed']=![],_0x479c24[_0x52d3a6(0x49a)]=![],_0x479c24['mpDamage']=0xfce+-0x3e0+-0xbee,this[_0x52d3a6(0x6d9)+_0x52d3a6(0x52c)][_0x52d3a6(0x15f1)](_0x479c24);}if(_0x401167[_0x52d3a6(0xe7c)](_0x5e9552[_0x52d3a6(0x1381)],0x2159+-0xe56+0x1f*-0x9d)){const _0x429d54=JsonEx['makeDeepCo'+'py'](_0x5e9552);_0x429d54[_0x52d3a6(0x324)]=![],_0x429d54[_0x52d3a6(0x49a)]=![],_0x429d54[_0x52d3a6(0xf67)]=![],this[_0x52d3a6(0x6d9)+_0x52d3a6(0x52c)][_0x52d3a6(0x15f1)](_0x429d54);}},Game_Battler[_0xe90fac(0x510)][_0xe90fac(0x1008)+_0xe90fac(0x811)]=function(){const _0x1ff11c=_0xe90fac;if(!this[_0x1ff11c(0x6d9)+_0x1ff11c(0x52c)])this[_0x1ff11c(0x142e)+_0x1ff11c(0xeeb)]();return VisuMZ[_0x1ff11c(0x118f)]['Settings'][_0x1ff11c(0x7d7)][_0x1ff11c(0x10d0)+_0x1ff11c(0x120c)]?this['_damagePop'+_0x1ff11c(0x52c)]['shift']():this[_0x1ff11c(0x6d9)+_0x1ff11c(0x52c)]['pop']();},Game_Battler[_0xe90fac(0x510)][_0xe90fac(0x866)+_0xe90fac(0x1f9)]=function(_0x193b4e,_0x42766e){const _0x558640=_0xe90fac,_0x303105={'xbZtC':_0x558640(0xd2b)+_0x558640(0xa9d),'KMOpT':'#ffffff','KCvcQ':function(_0x80753d,_0x271fb1){return _0x80753d<=_0x271fb1;},'cQYjg':function(_0x5f2146,_0x1f1395){return _0x5f2146||_0x1f1395;}},_0x31a751=_0x303105[_0x558640(0x6a2)][_0x558640(0xab1)]('|');let _0x3e8f32=-0x36e*0x3+0x15e0+0x1*-0xb96;while(!![]){switch(_0x31a751[_0x3e8f32++]){case'0':_0x42766e[_0x558640(0x76e)]=_0x42766e[_0x558640(0x76e)]||[-0xf86+-0xad9*-0x3+-0x1*0x1105,-0x9e5+-0x5*-0x37d+0x1e3*-0x4,0x1*-0xa07+-0xae7+-0x39*-0x5e,0x45e+-0xcec+0x1b6*0x5];continue;case'1':if(!SceneManager[_0x558640(0x11be)+_0x558640(0x3ad)]())return;continue;case'2':if(!this[_0x558640(0x81d)]())return;continue;case'3':_0x42766e['flashDurat'+_0x558640(0x130a)]=_0x42766e['flashDurat'+_0x558640(0x130a)]||0x1d92+-0x248d+-0x1*-0x6fb;continue;case'4':this[_0x558640(0x81d)]()[_0x558640(0x866)+'opup'](_0x193b4e,_0x42766e);continue;case'5':if(BattleManager[_0x558640(0x8bd)+_0x558640(0x8f6)+_0x558640(0x12fb)]())return;continue;case'6':_0x42766e['textColor']=_0x42766e[_0x558640(0x5a9)]||_0x303105[_0x558640(0x629)];continue;case'7':if(_0x303105['KCvcQ'](_0x193b4e['length'],-0xb61+0x8*0x3c7+-0x2b1*0x7))return;continue;case'8':_0x42766e=_0x303105[_0x558640(0xd86)](_0x42766e,{});continue;}break;}},Game_Battler['prototype']['setupIconT'+'extPopup']=function(_0x3d3d09,_0x5948ff,_0x508483){const _0x42f6e8=_0xe90fac,_0x11ec32={'BAEgp':_0x42f6e8(0x468)+_0x42f6e8(0xe96),'lUWdd':_0x42f6e8(0x1527),'WOlYG':function(_0x314906,_0x30b872){return _0x314906||_0x30b872;},'TiKIa':function(_0x1d9d60,_0xe381f4){return _0x1d9d60<=_0xe381f4;}},_0x6d8420=_0x11ec32['BAEgp'][_0x42f6e8(0xab1)]('|');let _0x2e7081=0x888+-0x303*0x6+0x21*0x4a;while(!![]){switch(_0x6d8420[_0x2e7081++]){case'0':_0x508483[_0x42f6e8(0x5a9)]=_0x508483['textColor']||_0x11ec32[_0x42f6e8(0x624)];continue;case'1':if(!SceneManager['isSceneBat'+_0x42f6e8(0x3ad)]())return;continue;case'2':_0x508483=_0x11ec32[_0x42f6e8(0x116d)](_0x508483,{});continue;case'3':_0x508483[_0x42f6e8(0x76e)]=_0x508483[_0x42f6e8(0x76e)]||[-0x422+0x1a3*-0x13+0x233b*0x1,0xf0d+-0x1294+0x387,0x2*-0xe35+0x38*-0xa3+-0x3b*-0x116,0xe8d*0x1+-0x7c2*-0x3+0x1a5*-0x17];continue;case'4':if(BattleManager[_0x42f6e8(0x8bd)+_0x42f6e8(0x8f6)+_0x42f6e8(0x12fb)]())return;continue;case'5':if(_0x11ec32[_0x42f6e8(0xb49)](_0x5948ff['length'],-0x399*-0x3+-0x1*-0x1b77+-0x2642))return;continue;case'6':this[_0x42f6e8(0x81d)]()[_0x42f6e8(0x2ee)+_0x42f6e8(0xc7)](_0x3d3d09,_0x5948ff,_0x508483);continue;case'7':_0x508483[_0x42f6e8(0xbf8)+_0x42f6e8(0x130a)]=_0x508483['flashDurat'+'ion']||0x11*0x1ac+0x2*-0x115c+0x64c;continue;case'8':if(!this[_0x42f6e8(0x81d)]())return;continue;}break;}},Game_Battler[_0xe90fac(0x510)][_0xe90fac(0x1224)+_0xe90fac(0xa58)]=function(){const _0x480744=_0xe90fac;if(this[_0x480744(0x1182)]())return![];if(this[_0x480744(0xb30)]()&&this['isAppeared']())return!![];if(this['isEnemy']()&&this[_0x480744(0x358)+'er']()){if(this[_0x480744(0x17d)]()&&this[_0x480744(0x793)+_0x480744(0x8bb)]())return![];}else{if(this[_0x480744(0x17d)]())return![];}return!![];},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x6e8)+_0xe90fac(0x278)+'tion']=Game_Battler[_0xe90fac(0x510)]['clearMotio'+'n'],Game_Battler['prototype'][_0xe90fac(0xe53)+'n']=function(){const _0x544de9=_0xe90fac;VisuMZ[_0x544de9(0x118f)][_0x544de9(0x6e8)+_0x544de9(0x278)+_0x544de9(0x1580)][_0x544de9(0x351)](this),this[_0x544de9(0x651)+'eMotion']();},Game_Battler[_0xe90fac(0x510)][_0xe90fac(0xa20)+_0xe90fac(0xddd)]=function(){return!![];},Game_Battler[_0xe90fac(0x510)][_0xe90fac(0xfa0)+_0xe90fac(0xbd5)]=function(){return![];},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x6e8)+_0xe90fac(0xf9d)+_0xe90fac(0x115)]=Game_Battler[_0xe90fac(0x510)]['onBattleSt'+_0xe90fac(0x1091)],Game_Battler[_0xe90fac(0x510)][_0xe90fac(0x112a)+_0xe90fac(0x1091)]=function(_0x47b2fe){const _0x169aba=_0xe90fac;VisuMZ[_0x169aba(0x118f)]['Game_Battl'+_0x169aba(0xf9d)+_0x169aba(0x115)][_0x169aba(0x351)](this,_0x47b2fe),this[_0x169aba(0x112a)+_0x169aba(0x1342)+'ore'](_0x47b2fe),this[_0x169aba(0x142e)+_0x169aba(0xeeb)]();},Game_Battler[_0xe90fac(0x510)][_0xe90fac(0x112a)+'artBattleC'+_0xe90fac(0x86e)]=function(_0x2acceb){const _0x5a4d14=_0xe90fac;this[_0x5a4d14(0x117e)+_0x5a4d14(0x137f)](![]),this['_forcedHom'+'eX']=undefined,this[_0x5a4d14(0x154b)+'eY']=undefined;},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x6e8)+'er_onBattl'+_0xe90fac(0x246)]=Game_Battler[_0xe90fac(0x510)][_0xe90fac(0x20d)+'d'],Game_Battler[_0xe90fac(0x510)][_0xe90fac(0x20d)+'d']=function(){const _0x581e9f=_0xe90fac;VisuMZ[_0x581e9f(0x118f)][_0x581e9f(0x6e8)+_0x581e9f(0xf9d)+_0x581e9f(0x246)][_0x581e9f(0x351)](this),this['onBattleEn'+_0x581e9f(0x114)+'e']();},Game_Battler['prototype'][_0xe90fac(0x20d)+_0xe90fac(0x114)+'e']=function(){const _0x4e388a=_0xe90fac;this['_forcedHom'+'eX']=undefined,this[_0x4e388a(0x154b)+'eY']=undefined;},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x6e8)+_0xe90fac(0x261)+'ActionStar'+'t']=Game_Battler[_0xe90fac(0x510)][_0xe90fac(0x763)+_0xe90fac(0x911)],Game_Battler[_0xe90fac(0x510)]['performAct'+'ionStart']=function(_0x45a834){const _0x429240=_0xe90fac;VisuMZ[_0x429240(0x118f)][_0x429240(0x6e8)+'er_perform'+'ActionStar'+'t'][_0x429240(0x351)](this,_0x45a834);if(!_0x45a834[_0x429240(0x123e)]()){const _0x551359=this['battler']();_0x551359&&_0x551359['stepForwar'+'d']();}this[_0x429240(0x117e)+_0x429240(0x137f)](![]);},Game_Battler['prototype'][_0xe90fac(0x763)+_0xe90fac(0xea7)+_0xe90fac(0x446)]=function(){const _0x12c9ab=_0xe90fac,_0x22a722={'GTLBs':function(_0xc03973,_0x4a9d87){return _0xc03973&&_0x4a9d87;}};this[_0x12c9ab(0x1191)+'mageMotion']=undefined;const _0x46ca62=this[_0x12c9ab(0x5ce)];this[_0x12c9ab(0x5ce)]=![];if(BattleManager[_0x12c9ab(0x107c)+'b']()&&this[_0x12c9ab(0x15f0)+'g']()){const _0x4d8c96=this[_0x12c9ab(0x81d)]();if(_0x22a722[_0x12c9ab(0xac8)](_0x4d8c96,_0x46ca62))_0x4d8c96['stepForwar'+'d']();return;}const _0x1ebbb9=this[_0x12c9ab(0x81d)]();if(_0x1ebbb9)_0x1ebbb9[_0x12c9ab(0xd0a)]();this[_0x12c9ab(0x117e)+_0x12c9ab(0x137f)](![]),this[_0x12c9ab(0xa08)+'ionRefresh']();},Game_Battler[_0xe90fac(0x510)][_0xe90fac(0x763)+'ionMotions']=function(_0x5ea1c8){const _0x21b56a=_0xe90fac,_0x285209={'yijks':_0x21b56a(0x547),'PXJlK':_0x21b56a(0x1129),'JVEZE':_0x21b56a(0xf44),'DSZpm':_0x21b56a(0xdd)};if(_0x5ea1c8[_0x21b56a(0x7e4)]())this[_0x21b56a(0xe22)+_0x21b56a(0x9dd)]();else{if(_0x5ea1c8[_0x21b56a(0x123e)]())this[_0x21b56a(0xa08)+_0x21b56a(0x130a)](_0x285209[_0x21b56a(0x108a)]);else{if(_0x5ea1c8[_0x21b56a(0x717)]())this[_0x21b56a(0xa08)+_0x21b56a(0x130a)](_0x285209[_0x21b56a(0xd26)]);else{if(_0x5ea1c8[_0x21b56a(0x97a)]())[-0x119b*0x1+0x23f8+-0x125c,-0x194c+-0x449+0x1d97,0x1ed7*0x1+0x9ee+-0x28c0,-0x225d*-0x1+0xa16*-0x3+-0x5*0xd1][_0x21b56a(0x79c)](_0x5ea1c8[_0x21b56a(0xdd)]()[_0x21b56a(0x11df)][_0x21b56a(0x152a)])?this[_0x21b56a(0xe22)+_0x21b56a(0x9dd)]():this[_0x21b56a(0xa08)+_0x21b56a(0x130a)](_0x285209[_0x21b56a(0x6f1)]);else _0x5ea1c8[_0x21b56a(0x1485)]()&&this[_0x21b56a(0xa08)+_0x21b56a(0x130a)](_0x285209[_0x21b56a(0x25e)]);}}}},Game_Battler[_0xe90fac(0x510)][_0xe90fac(0x408)+'otion']=function(){const _0x190a84=_0xe90fac;return $dataSystem['attackMoti'+_0x190a84(0x15e9)][0xd*0x16b+-0x1c5+-0x10aa];},Game_Battler['prototype'][_0xe90fac(0x54f)+'eaponAnima'+_0xe90fac(0xf53)]=function(){const _0x5e3b94=_0xe90fac,_0x1a2f21=this[_0x5e3b94(0x408)+'otion']();return _0x1a2f21?_0x1a2f21[_0x5e3b94(0x1041)+_0x5e3b94(0x14e5)]:0x207d+-0x3d+0x2b*-0xc0;},Game_Battler['prototype']['performSub'+'stitute']=function(_0x20a112){const _0x1a2f6b=_0xe90fac,_0x402bfa={'DtkDe':function(_0x123b60,_0x3fb923){return _0x123b60||_0x3fb923;},'jDrFd':'Linear','uEBHW':function(_0x44897f,_0x4846a4){return _0x44897f/_0x4846a4;},'MMagA':function(_0x3eab7e,_0x1b2725){return _0x3eab7e+_0x1b2725;},'SaYwj':function(_0x2f9f6e,_0x2c5df2){return _0x2f9f6e*_0x2c5df2;}};if(!$gameSystem[_0x1a2f6b(0x53d)]())return;const _0x8718f6=this[_0x1a2f6b(0x81d)](),_0x291af0=_0x20a112['battler']();if(_0x402bfa['DtkDe'](!_0x8718f6,!_0x291af0))return;const _0x2192db=_0x291af0[_0x1a2f6b(0x156)],_0x33050c=_0x291af0[_0x1a2f6b(0x1098)];this['moveBattle'+_0x1a2f6b(0x975)](_0x2192db,_0x33050c,-0x22c1+0x2fc+0x1fc5,![],_0x402bfa[_0x1a2f6b(0x243)],-(-0x5*0x58d+-0x3f+-0x6b*-0x43)),_0x8718f6[_0x1a2f6b(0xe9f)+_0x1a2f6b(0x1580)]();const _0x592ad9=VisuMZ[_0x1a2f6b(0x118f)]['Settings'][_0x1a2f6b(0xdd1)+_0x1a2f6b(0x16a)];let _0x5e7223=_0x402bfa[_0x1a2f6b(0x9c9)](_0x402bfa['MMagA'](_0x291af0[_0x1a2f6b(0x301)],_0x8718f6[_0x1a2f6b(0x301)]),-0x7*-0x11+-0xe46+-0x1b*-0x83);_0x5e7223*=this[_0x1a2f6b(0xd83)]()?0x1666+0x1*-0x1e66+0x801:-(0x7e2+0x157f+0x5e*-0x50);let _0x7359=_0x402bfa[_0x1a2f6b(0xd43)](_0x592ad9[_0x1a2f6b(0x562)+_0x1a2f6b(0x652)],this[_0x1a2f6b(0xd83)]()?0x1c0+0x1c42+-0x1e01:-(0x4*-0x4ca+0x20d9*0x1+0x124*-0xc));_0x20a112[_0x1a2f6b(0x37b)+_0x1a2f6b(0x93)](_0x5e7223,_0x7359,0x2505+-0x1f97+-0x116*0x5,![],_0x402bfa[_0x1a2f6b(0x243)]),_0x291af0[_0x1a2f6b(0xe9f)+'tion']();},Game_Battler[_0xe90fac(0x510)][_0xe90fac(0xa08)+'ion']=function(_0x577f9e){const _0x8044d2=_0xe90fac,_0x1e48e4={'rGVlc':_0x8044d2(0x121e),'uIAmQ':_0x8044d2(0x501),'XKGvQ':_0x8044d2(0x929)};if(SceneManager['isSceneBat'+'tle']()){const _0x9a95d3=this['battler']();_0x9a95d3&&(_0x9a95d3['forceMotio'+'n'](_0x577f9e),[_0x1e48e4[_0x8044d2(0xb7f)],_0x1e48e4[_0x8044d2(0x8ca)],_0x1e48e4['XKGvQ']][_0x8044d2(0x79c)](_0x577f9e)&&this[_0x8044d2(0x38b)+_0x8044d2(0xd8a)+'on']());}this[_0x8044d2(0x651)+_0x8044d2(0x113a)]();},Game_Battler['prototype']['performWea'+_0xe90fac(0xd8a)+'on']=function(){},Game_Battler[_0xe90fac(0x510)][_0xe90fac(0x76f)+_0xe90fac(0x117c)]=function(_0x18338b){const _0x3f9e92=_0xe90fac;if(SceneManager[_0x3f9e92(0x11be)+_0x3f9e92(0x3ad)]()){const _0x3bb325=this[_0x3f9e92(0x81d)]();if(_0x3bb325)_0x3bb325[_0x3f9e92(0xccb)+'nAnimation'](_0x18338b);}},Game_Battler[_0xe90fac(0x510)][_0xe90fac(0xa96)+_0xe90fac(0xc73)+_0xe90fac(0xb0d)]=function(){const _0x4071df=_0xe90fac;if(SceneManager[_0x4071df(0x11be)+_0x4071df(0x3ad)]()){const _0x6e7b5e=this[_0x4071df(0x54f)+_0x4071df(0xa88)+'tionId']();this[_0x4071df(0x76f)+_0x4071df(0x117c)](_0x6e7b5e);}},Game_Battler[_0xe90fac(0x510)]['performCas'+_0xe90fac(0x10f4)]=function(_0x55e699,_0x503952){const _0x2b98b0=_0xe90fac,_0x4b8cfa={'OosHm':function(_0x52c612,_0x26c576){return _0x52c612(_0x26c576);},'IIfFD':function(_0x1c5301,_0x54a6f0){return _0x1c5301>_0x54a6f0;}};if(!_0x55e699)return;if(!_0x55e699['item']())return;if(_0x55e699[_0x2b98b0(0x7e4)]())return;if(_0x55e699[_0x2b98b0(0x123e)]())return;if(_0x55e699[_0x2b98b0(0x1485)]())return;if($gameTemp[_0x2b98b0(0x968)+'astMode'])return;let _0x139761=0x1ed8+0x6*0x222+-0x63c*0x7;const _0x4827cb=VisuMZ[_0x2b98b0(0x118f)][_0x2b98b0(0x281)][_0x2b98b0(0xdd1)+_0x2b98b0(0x16a)],_0x365fdb=_0x55e699['item']()[_0x2b98b0(0xfee)];if(_0x365fdb[_0x2b98b0(0x3eb)](/<CAST ANIMATION: (\d+)>/i))_0x139761=_0x4b8cfa[_0x2b98b0(0x113d)](Number,RegExp['$1']);else{if(_0x365fdb[_0x2b98b0(0x3eb)](/<NO CAST ANIMATION>/i))return;else{if(_0x55e699[_0x2b98b0(0x127f)+'it']())_0x139761=_0x4827cb['CastCertai'+'n'];else{if(_0x55e699[_0x2b98b0(0x9f)]())_0x139761=_0x4827cb[_0x2b98b0(0x12c1)+'al'];else _0x55e699['isMagical']()&&(_0x139761=_0x4827cb[_0x2b98b0(0xc9)+'l']);}}}_0x4b8cfa['IIfFD'](_0x139761,0x7*0x521+0x239a+-0xe4d*0x5)&&$gameTemp[_0x2b98b0(0xdfd)+_0x2b98b0(0xb0d)]([this],_0x139761,!!_0x503952);},Game_Battler['prototype']['performRef'+_0xe90fac(0x9f1)]=function(){const _0x52f141=_0xe90fac,_0x608d41={'SLEQD':function(_0x58425c,_0x61c6cc){return _0x58425c>_0x61c6cc;}};SoundManager[_0x52f141(0x584)+_0x52f141(0x1580)]();let _0x3fdb66=VisuMZ[_0x52f141(0x118f)][_0x52f141(0x281)]['ActionSequ'+'ence'][_0x52f141(0x154f)+'mation'];_0x608d41[_0x52f141(0x712)](_0x3fdb66,-0x1*-0x21f4+-0xa57*0x3+-0x2ef)&&(Imported[_0x52f141(0x155e)+_0x52f141(0x100d)]?$gameTemp[_0x52f141(0x15a8)+_0x52f141(0x1014)]([this],_0x3fdb66):$gameTemp[_0x52f141(0xdfd)+_0x52f141(0xb0d)]([this],_0x3fdb66));},Game_Battler[_0xe90fac(0x510)][_0xe90fac(0x107c)+_0xe90fac(0x1285)]=function(){const _0x540a1b=_0xe90fac,_0x28f006={'bkwkZ':_0x540a1b(0x34e)+_0x540a1b(0xfa5),'gkIHw':function(_0x32bb2b,_0x437137){return _0x32bb2b>=_0x437137;}},_0x22d08e=_0x28f006[_0x540a1b(0xc10)][_0x540a1b(0xab1)]('|');let _0x176100=-0x8*0x4c3+-0x2*0xa85+0x1d*0x20a;while(!![]){switch(_0x22d08e[_0x176100++]){case'0':if(!BattleManager[_0x540a1b(0x107c)+'b']())return![];continue;case'1':return![];case'2':if(_0x28f006['gkIHw'](this[_0x540a1b(0xd2f)+_0x540a1b(0x15b7)],0x5fb+0x1d*-0x25+-0x1c9))return!![];continue;case'3':if(!$gameSystem[_0x540a1b(0x53d)]())return![];continue;case'4':if(!this[_0x540a1b(0xb30)]())return![];continue;case'5':if(this[_0x540a1b(0x14c9)]())return!![];continue;case'6':if(this[_0x540a1b(0x15f0)+'g']())return!![];continue;}break;}},VisuMZ['BattleCore'][_0xe90fac(0x6e8)+_0xe90fac(0x261)+'Damage']=Game_Battler['prototype'][_0xe90fac(0x179)+_0xe90fac(0x154d)],Game_Battler[_0xe90fac(0x510)][_0xe90fac(0x179)+_0xe90fac(0x154d)]=function(){const _0x5a7a78=_0xe90fac;this[_0x5a7a78(0x107c)+_0x5a7a78(0x1285)]()&&(this[_0x5a7a78(0x1191)+_0x5a7a78(0x7c8)]=!![]),VisuMZ['BattleCore'][_0x5a7a78(0x6e8)+_0x5a7a78(0x261)+_0x5a7a78(0x7d7)][_0x5a7a78(0x351)](this),this[_0x5a7a78(0x928)+'nch'](),this['performSha'+_0x5a7a78(0x138c)]();},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x6e8)+_0xe90fac(0x261)+'Miss']=Game_Battler[_0xe90fac(0x510)][_0xe90fac(0x1374)+'s'],Game_Battler[_0xe90fac(0x510)][_0xe90fac(0x1374)+'s']=function(){const _0x6cd541=_0xe90fac;this['isActiveTp'+_0x6cd541(0x1285)]()&&(this['_performDa'+_0x6cd541(0x7c8)]=!![]),VisuMZ[_0x6cd541(0x118f)][_0x6cd541(0x6e8)+_0x6cd541(0x261)+'Miss'][_0x6cd541(0x351)](this),this['performFli'+_0x6cd541(0x2a0)]();},VisuMZ[_0xe90fac(0x118f)]['Game_Battl'+'er_perform'+_0xe90fac(0x159a)]=Game_Battler[_0xe90fac(0x510)][_0xe90fac(0x1cc)+_0xe90fac(0xca)],Game_Battler[_0xe90fac(0x510)][_0xe90fac(0x1cc)+_0xe90fac(0xca)]=function(){const _0x2ccc5e=_0xe90fac;this[_0x2ccc5e(0x107c)+_0x2ccc5e(0x1285)]()&&(this[_0x2ccc5e(0x1191)+_0x2ccc5e(0x7c8)]=!![]),VisuMZ[_0x2ccc5e(0x118f)][_0x2ccc5e(0x6e8)+'er_perform'+_0x2ccc5e(0x159a)][_0x2ccc5e(0x351)](this),this[_0x2ccc5e(0x928)+_0x2ccc5e(0x2a0)]();},Game_Battler[_0xe90fac(0x510)][_0xe90fac(0x928)+_0xe90fac(0x2a0)]=function(){const _0x1631e4=_0xe90fac;if(!$gameSystem[_0x1631e4(0x53d)]())return;if(this[_0x1631e4(0x5ce)])return;this[_0x1631e4(0x5ce)]=!![];const _0x5570a9=this[_0x1631e4(0x81d)]();if(_0x5570a9)_0x5570a9[_0x1631e4(0xc2e)]();},Game_Battler[_0xe90fac(0x510)][_0xe90fac(0x1408)+_0xe90fac(0x138c)]=function(){const _0x3f10ac=_0xe90fac,_0x4410d2={'QzqWD':function(_0x58f0ec,_0x149d01){return _0x58f0ec<=_0x149d01;},'RjJfd':function(_0x5cd947,_0x4a9e2d){return _0x5cd947/_0x4a9e2d;},'dAiyY':function(_0x5b119e,_0x1fc9ae){return _0x5b119e*_0x1fc9ae;}};if(!this['canBattler'+_0x3f10ac(0xddd)]())return;const _0x3d459a=VisuMZ[_0x3f10ac(0x118f)][_0x3f10ac(0x281)][_0x3f10ac(0xd11)];if(!(_0x3d459a['ShakeFlinc'+'h']??![]))return;if(_0x4410d2[_0x3f10ac(0xc39)](this[_0x3f10ac(0xf0)+_0x3f10ac(0x154d)],0x13*0x11+0x1d0+-0x313))return;const _0x87f767=this[_0x3f10ac(0x81d)]();if(_0x87f767){const _0x1f27b9=this['_lastHpDam'+_0x3f10ac(0x154d)],_0x1d8a62=_0x4410d2['RjJfd'](_0x1f27b9,this[_0x3f10ac(0x60e)])[_0x3f10ac(0x61c)](0x10d0+-0xe*-0x245+-0x9*0x566+0.8,0x2bc*0xd+-0x1*-0x1ca3+-0x402e),_0x52d83f=_0x3d459a[_0x3f10ac(0x142)+'hPower']??-0x5*-0x3+0x4*0x3fb+-0xfcb,_0x49b533=_0x4410d2[_0x3f10ac(0x4e8)](_0x1d8a62,_0x52d83f);_0x87f767[_0x3f10ac(0x1294)+_0x3f10ac(0xbc5)](_0x49b533,_0x1d8a62);}},Game_Battler[_0xe90fac(0x510)][_0xe90fac(0xa08)+_0xe90fac(0x730)]=function(){const _0x135498=_0xe90fac,_0x34f16a={'fzTxJ':_0x135498(0x41a)+'1|0|7|9|3|'+'10','XGWLP':function(_0x38db0d,_0x596524){return _0x38db0d===_0x596524;},'NjZkf':_0x135498(0x547),'HMtzK':function(_0x5e675a,_0x530240){return _0x5e675a===_0x530240;},'MLPfI':_0x135498(0xa34),'fDsOL':'victory','dIXZX':function(_0x4395d6,_0x43a808){return _0x4395d6!==_0x43a808;},'syBda':'dead','MTZiy':function(_0x44aee1,_0x49f5b1){return _0x44aee1===_0x49f5b1;},'xtoda':function(_0x26ee82,_0x369bd6){return _0x26ee82===_0x369bd6;}},_0x18e661=_0x34f16a[_0x135498(0xf42)][_0x135498(0xab1)]('|');let _0x2ac316=-0x584+-0x687*0x1+0x1*0xc0b;while(!![]){switch(_0x18e661[_0x2ac316++]){case'0':if(_0x34f16a[_0x135498(0x23a)](this[_0x135498(0xf1f)+'e'],_0x34f16a[_0x135498(0x131f)])&&!BattleManager[_0x135498(0x15f0)+'g']())return;continue;case'1':if(_0x34f16a['HMtzK'](this[_0x135498(0xf1f)+'e'],_0x34f16a[_0x135498(0x48f)])&&!BattleManager[_0x135498(0x15f0)+'g']())return;continue;case'2':if(_0x34f16a['HMtzK'](this['_motionTyp'+'e'],_0x34f16a[_0x135498(0x89d)]))return;continue;case'3':if(this[_0x135498(0x81d)]()&&BattleManager[_0x135498(0x15f0)+'g']()){this[_0x135498(0x81d)]()[_0x135498(0xff4)+'ion'](),this[_0x135498(0x651)+_0x135498(0x113a)]();return;}continue;case'4':if(this[_0x135498(0x17d)]()&&_0x34f16a[_0x135498(0xc9d)](this[_0x135498(0xf1f)+'e'],_0x34f16a['syBda'])){this[_0x135498(0xa08)+'ion'](_0x34f16a[_0x135498(0x13e5)]);return;}continue;case'5':if(this['isEnemy']()){if(!this['isDuringNo'+_0x135498(0xef3)+_0x135498(0x1580)]()&&_0x34f16a[_0x135498(0xc9d)](this,BattleManager[_0x135498(0x14c1)])){if(this[_0x135498(0x81d)]())this[_0x135498(0x81d)]()[_0x135498(0xff4)+_0x135498(0x130a)]();}this[_0x135498(0x651)+_0x135498(0x113a)]();return;}continue;case'6':if(!!this['_freezeMot'+'ionData'])return;continue;case'7':this[_0x135498(0xe53)+'n']();continue;case'8':if(this[_0x135498(0x17d)]()&&_0x34f16a[_0x135498(0x7a4)](this[_0x135498(0xf1f)+'e'],_0x34f16a[_0x135498(0x13e5)]))return;continue;case'9':if(BattleManager[_0x135498(0x107c)+'b']()&&_0x34f16a[_0x135498(0x937)](this,BattleManager['_subject']))return;continue;case'10':this[_0x135498(0x81d)]()&&BattleManager['isActiveTp'+'b']()&&_0x34f16a[_0x135498(0xc9d)](this,BattleManager[_0x135498(0x14c1)])&&this[_0x135498(0x81d)]()[_0x135498(0xff4)+_0x135498(0x130a)]();continue;}break;}},Game_Enemy['prototype'][_0xe90fac(0x1216)+_0xe90fac(0xef3)+_0xe90fac(0x1580)]=function(){const _0x378fb2=_0xe90fac;if(!this[_0x378fb2(0x358)+'er']())return![];const _0x1bcf1f=this[_0x378fb2(0x81d)]();if(!_0x1bcf1f)return![];const _0x53b29b=_0x1bcf1f[_0x378fb2(0x1ee)+_0x378fb2(0x15e6)];if(!_0x53b29b)return![];const _0xb8277=_0x53b29b[_0x378fb2(0xa0c)];return _0xb8277&&!_0xb8277[_0x378fb2(0x1359)];},Game_Battler[_0xe90fac(0x510)]['isBattlerF'+_0xe90fac(0x445)]=function(){const _0x164fb0=_0xe90fac;return this['_isBattler'+_0x164fb0(0xf64)];},Game_Battler[_0xe90fac(0x510)][_0xe90fac(0x117e)+_0xe90fac(0x137f)]=function(_0xc89a95){const _0x5f0c8d=_0xe90fac;if(!$gameSystem[_0x5f0c8d(0x53d)]())return;this['_isBattler'+_0x5f0c8d(0xf64)]=_0xc89a95;const _0x4461ae=this[_0x5f0c8d(0x81d)]();if(_0x4461ae)_0x4461ae[_0x5f0c8d(0xe81)]();},Game_Battler[_0xe90fac(0x510)][_0xe90fac(0x117e)+_0xe90fac(0xea4)]=function(_0x3836b5,_0x471b7f,_0x25aac1){const _0x1c80c2=_0xe90fac,_0x9da8cf={'VnBMJ':function(_0x16b141,_0x34af25){return _0x16b141===_0x34af25;},'wJKFY':function(_0x37e11b,_0x6c0339){return _0x37e11b>_0x6c0339;},'xkCBK':function(_0xabd1a3,_0x3dca8a){return _0xabd1a3<_0x3dca8a;},'LsNHy':function(_0x431e5f,_0x37aa53){return _0x431e5f<_0x37aa53;}};if(!$gameSystem['isSideView']())return;const _0x5b3d3a=this[_0x1c80c2(0x81d)]();if(!_0x5b3d3a)return;if(_0x9da8cf['VnBMJ'](_0x3836b5,_0x5b3d3a[_0x1c80c2(0x156)]))return;let _0x3af42d=![];if(this[_0x1c80c2(0xd83)]()){if(_0x9da8cf[_0x1c80c2(0x1281)](_0x3836b5,_0x5b3d3a[_0x1c80c2(0x156)]))_0x3af42d=!![];if(_0x9da8cf[_0x1c80c2(0x245)](_0x3836b5,_0x5b3d3a[_0x1c80c2(0x156)]))_0x3af42d=![];}else{if(this[_0x1c80c2(0xb9a)]()){if(_0x9da8cf['wJKFY'](_0x3836b5,_0x5b3d3a[_0x1c80c2(0x156)]))_0x3af42d=![];if(_0x9da8cf[_0x1c80c2(0x4ed)](_0x3836b5,_0x5b3d3a[_0x1c80c2(0x156)]))_0x3af42d=!![];}};this['setBattler'+_0x1c80c2(0x137f)](_0x25aac1?!_0x3af42d:_0x3af42d),_0x5b3d3a[_0x1c80c2(0xe81)]();},Game_Battler[_0xe90fac(0x510)]['moveBattle'+_0xe90fac(0x93)]=function(_0x687dbe,_0x2a4977,_0x27ecb8,_0x4f76c4,_0x8d1e34){const _0x368d56=_0xe90fac,_0xab2193={'sDFCV':function(_0x64139c,_0x2a9b13){return _0x64139c+_0x2a9b13;},'tEfoY':function(_0x26927e,_0x46c760){return _0x26927e+_0x46c760;},'fWZfq':function(_0x484278,_0x6d52af){return _0x484278-_0x6d52af;},'tzeJz':function(_0x4b2ba8,_0x5d21a9){return _0x4b2ba8-_0x5d21a9;},'Cijvm':function(_0x18fc7f,_0x1797c2){return _0x18fc7f||_0x1797c2;},'iuYnn':_0x368d56(0x44a)};if(!$gameSystem[_0x368d56(0x53d)]())return;const _0x868e35=this[_0x368d56(0x81d)]();if(!_0x868e35)return;if(_0x4f76c4)this[_0x368d56(0x117e)+'FacePoint'](_0xab2193[_0x368d56(0xffe)](_0x687dbe,_0x868e35[_0x368d56(0x156)]),_0xab2193[_0x368d56(0x110)](_0x2a4977,_0x868e35[_0x368d56(0x1098)]),![]);_0x687dbe+=_0xab2193[_0x368d56(0xb2a)](_0x868e35[_0x368d56(0x156)],_0x868e35[_0x368d56(0xcc4)]),_0x2a4977+=_0xab2193[_0x368d56(0x5f3)](_0x868e35[_0x368d56(0x1098)],_0x868e35[_0x368d56(0x54e)]),_0x868e35[_0x368d56(0xae0)](_0x687dbe,_0x2a4977,_0x27ecb8);if(Imported['VisuMZ_0_C'+_0x368d56(0x100d)])_0x868e35[_0x368d56(0x91e)+_0x368d56(0x2f1)](_0xab2193['Cijvm'](_0x8d1e34,_0xab2193[_0x368d56(0xe6d)]));},Game_Battler[_0xe90fac(0x510)]['moveBattle'+'rToPoint']=function(_0x2ef3db,_0x25fba8,_0x16f65c,_0x460a18,_0x2d3b02,_0x39c728){const _0x1ee44f=_0xe90fac,_0x1f61b7={'GAUhf':function(_0x510afc,_0x163101){return _0x510afc===_0x163101;},'xhvLL':function(_0x4c6fe3,_0x52ff7b){return _0x4c6fe3===_0x52ff7b;},'cMzjn':function(_0xec40c0,_0x264666){return _0xec40c0(_0x264666);},'BiRub':function(_0x37ea00,_0x32c803){return _0x37ea00||_0x32c803;},'HUIgM':function(_0x522460,_0x38aa6b){return _0x522460>_0x38aa6b;},'VoLRF':function(_0x577666,_0x1fccf2){return _0x577666>_0x1fccf2;},'PLnnq':function(_0x4eb71d,_0x1ad81a){return _0x4eb71d+_0x1ad81a;},'moCjM':function(_0x5409f1,_0xb6bdb4){return _0x5409f1/_0xb6bdb4;},'JoKzo':function(_0x463682,_0x3e330e){return _0x463682<_0x3e330e;},'KyngB':function(_0x91f8d2,_0x3d93a9){return _0x91f8d2/_0x3d93a9;},'vydEN':function(_0x46878f,_0x49894f){return _0x46878f||_0x49894f;},'nxwiR':_0x1ee44f(0x44a)};if(!$gameSystem[_0x1ee44f(0x53d)]())return;const _0x499631=this[_0x1ee44f(0x81d)]();if(!_0x499631)return;if(_0x1f61b7[_0x1ee44f(0x1389)](_0x2ef3db,Infinity)||_0x1f61b7[_0x1ee44f(0x32e)](_0x25fba8,Infinity))return;if(_0x1f61b7[_0x1ee44f(0x104d)](isNaN,_0x2ef3db)||_0x1f61b7['cMzjn'](isNaN,_0x25fba8))return;_0x39c728=_0x1f61b7[_0x1ee44f(0x28a)](_0x39c728,-0x1*0x1dc5+-0x24b2+0x4277);if(_0x1f61b7['HUIgM'](_0x39c728,-0x77c*-0x3+0x6*0xa3+-0xb1*0x26)){if(_0x1f61b7[_0x1ee44f(0x61f)](_0x499631[_0x1ee44f(0x156)],_0x2ef3db))_0x2ef3db+=_0x1f61b7[_0x1ee44f(0x842)](_0x1f61b7['moCjM'](_0x499631[_0x1ee44f(0x301)],0xe04+0xc4d+-0x8c5*0x3),_0x39c728);if(_0x1f61b7[_0x1ee44f(0x6f8)](_0x499631[_0x1ee44f(0x156)],_0x2ef3db))_0x2ef3db-=_0x1f61b7[_0x1ee44f(0x842)](_0x1f61b7[_0x1ee44f(0x5ee)](_0x499631[_0x1ee44f(0x301)],-0x2620+-0x1*0x749+0x2d6b),_0x39c728);}if(_0x460a18)this[_0x1ee44f(0x117e)+_0x1ee44f(0xea4)](_0x2ef3db,_0x25fba8,![]);_0x2ef3db-=_0x499631[_0x1ee44f(0xcc4)],_0x25fba8-=_0x499631[_0x1ee44f(0x54e)],_0x499631[_0x1ee44f(0xae0)](_0x2ef3db,_0x25fba8,_0x16f65c);if(Imported[_0x1ee44f(0x155e)+_0x1ee44f(0x100d)])_0x499631[_0x1ee44f(0x91e)+_0x1ee44f(0x2f1)](_0x1f61b7[_0x1ee44f(0x1226)](_0x2d3b02,_0x1f61b7[_0x1ee44f(0x14ee)]));},Game_Battler[_0xe90fac(0x510)][_0xe90fac(0x37b)+_0xe90fac(0x2aa)+_0xe90fac(0xed3)]=function(_0x537803,_0x1a5d9c,_0x1f0871,_0x3bd424,_0x509f5e){const _0x567266=_0xe90fac,_0xd0250b={'PWEuc':function(_0x4bbbda,_0x5a3444){return _0x4bbbda+_0x5a3444;},'HqeLZ':function(_0x5075e1,_0x297ec8){return _0x5075e1+_0x297ec8;}};if(!$gameSystem[_0x567266(0x53d)]())return;const _0x41cadb=this[_0x567266(0x81d)]();if(!_0x41cadb)return;if(_0x3bd424)this['setBattler'+_0x567266(0xea4)](_0xd0250b['PWEuc'](_0x537803,_0x41cadb[_0x567266(0x156)]),_0xd0250b[_0x567266(0x20e)](_0x1a5d9c,_0x41cadb[_0x567266(0x1098)]),![]);_0x537803+=_0x41cadb[_0x567266(0xcc4)],_0x1a5d9c+=_0x41cadb[_0x567266(0x54e)],_0x41cadb[_0x567266(0x74a)+_0x567266(0xf0f)](_0x537803,_0x1a5d9c,_0x1f0871,_0x509f5e),this[_0x567266(0x154b)+'eX']=_0x537803,this['_forcedHom'+'eY']=_0x1a5d9c;},Game_Battler['prototype']['moveBattle'+_0xe90fac(0x724)+'nt']=function(_0x369660,_0x4b8e89,_0xb98c0c,_0x555b08,_0x1d575c,_0x42782b){const _0x4e21f8=_0xe90fac,_0x585b77={'UNwkx':function(_0x5d67fa,_0x20762f){return _0x5d67fa||_0x20762f;},'lOknG':function(_0x1a39f0,_0x23e21c){return _0x1a39f0>_0x23e21c;},'oIBpP':function(_0x45d01f,_0x538215){return _0x45d01f>_0x538215;},'iuEZi':function(_0xf0f429,_0x315ed4){return _0xf0f429+_0x315ed4;},'tzzQR':function(_0x267f35,_0x27f8a0){return _0x267f35/_0x27f8a0;},'wMOss':function(_0x4f4f03,_0x4e283e){return _0x4f4f03<_0x4e283e;},'TpxYD':function(_0x1b1d9c,_0x2d3eeb){return _0x1b1d9c/_0x2d3eeb;}};if(!$gameSystem['isSideView']())return;const _0x21a781=this[_0x4e21f8(0x81d)]();if(!_0x21a781)return;_0x42782b=_0x585b77['UNwkx'](_0x42782b,-0x455*-0x6+0xeda+-0x28d8);if(_0x585b77[_0x4e21f8(0x143d)](_0x42782b,0x7*0x53+-0x1f*0x40+-0x57b*-0x1)){if(_0x585b77[_0x4e21f8(0x1c1)](_0x21a781[_0x4e21f8(0x156)],_0x369660))_0x369660+=_0x585b77[_0x4e21f8(0xf65)](_0x585b77['tzzQR'](_0x21a781[_0x4e21f8(0x301)],0xf94*-0x2+0x4a3*0x5+0xe3*0x9),_0x42782b);if(_0x585b77[_0x4e21f8(0x372)](_0x21a781[_0x4e21f8(0x156)],_0x369660))_0x369660-=_0x585b77['iuEZi'](_0x585b77[_0x4e21f8(0xc00)](_0x21a781['width'],-0xb*0x10e+0x1fdb+-0x143f),_0x42782b);}if(_0x555b08)this[_0x4e21f8(0x117e)+_0x4e21f8(0xea4)](_0x369660,_0x4b8e89,![]);_0x21a781[_0x4e21f8(0x74a)+_0x4e21f8(0xf0f)](_0x369660,_0x4b8e89,_0xb98c0c,_0x1d575c),this[_0x4e21f8(0x154b)+'eX']=_0x369660,this[_0x4e21f8(0x154b)+'eY']=_0x4b8e89;},Game_Battler['prototype'][_0xe90fac(0x10b)+'er']=function(_0x3837ba,_0x5901c6,_0x7fae20){const _0x4a07f7=_0xe90fac;if(!$gameSystem[_0x4a07f7(0x53d)]())return;const _0x315178=this[_0x4a07f7(0x81d)]();if(!_0x315178)return;_0x315178[_0x4a07f7(0x4fd)](_0x3837ba,_0x5901c6,_0x7fae20);},Game_Battler[_0xe90fac(0x510)]['jumpBattle'+'r']=function(_0x3a5610,_0x38b15a){const _0xec0c47=_0xe90fac;if(!$gameSystem[_0xec0c47(0x53d)]())return;const _0x5155ee=this['battler']();if(!_0x5155ee)return;_0x5155ee['startJump'](_0x3a5610,_0x38b15a);},Game_Battler['prototype'][_0xe90fac(0x120a)+'r']=function(_0x39727b,_0x1252d6,_0x474c6f,_0x16183d){const _0x1f77f5=_0xe90fac;if(!$gameSystem[_0x1f77f5(0x53d)]())return;const _0x2c76b2=this[_0x1f77f5(0x81d)]();if(!_0x2c76b2)return;_0x2c76b2[_0x1f77f5(0xf76)](_0x39727b,_0x1252d6,_0x474c6f,_0x16183d);},Game_Battler[_0xe90fac(0x510)]['skewBattle'+'r']=function(_0x55d938,_0x65cc6a,_0x2a03c5,_0x103a61){const _0x1bd6c4=_0xe90fac;if(!$gameSystem[_0x1bd6c4(0x53d)]())return;const _0x1b5da4=this[_0x1bd6c4(0x81d)]();if(!_0x1b5da4)return;this[_0x1bd6c4(0xd83)]()&&(_0x55d938*=-(-0x83a+-0x7*0x4b9+0x294a*0x1),_0x65cc6a*=-(-0x93f+-0xa79*-0x1+-0x139)),_0x1b5da4[_0x1bd6c4(0x7b4)](_0x55d938,_0x65cc6a,_0x2a03c5,_0x103a61);},Game_Battler[_0xe90fac(0x510)]['growBattle'+'r']=function(_0x2d2d29,_0x41ff77,_0x2a0e1e,_0x1609fa){const _0x4fd7ba=_0xe90fac;if(!$gameSystem[_0x4fd7ba(0x53d)]())return;const _0x189ba6=this[_0x4fd7ba(0x81d)]();if(!_0x189ba6)return;_0x189ba6[_0x4fd7ba(0x70a)](_0x2d2d29,_0x41ff77,_0x2a0e1e,_0x1609fa);},Game_Battler[_0xe90fac(0x510)][_0xe90fac(0xccf)+_0xe90fac(0x311)]=function(_0x5c73c1,_0x5822f3,_0x1b1d01){const _0x567b48=_0xe90fac;if(!$gameSystem[_0x567b48(0x53d)]())return;const _0x108846=this[_0x567b48(0x81d)]();if(!_0x108846)return;_0x108846[_0x567b48(0xf3)+'ty'](_0x5c73c1,_0x5822f3,_0x1b1d01);},Game_Battler[_0xe90fac(0x510)][_0xe90fac(0x651)+_0xe90fac(0x113a)]=function(){const _0x29e6da=_0xe90fac,_0x1f8a5d=!!this[_0x29e6da(0xc3f)+_0x29e6da(0x6b0)];this[_0x29e6da(0xc3f)+'ionData']=undefined,_0x1f8a5d&&(this[_0x29e6da(0xa08)+_0x29e6da(0x730)](),this[_0x29e6da(0x651)+'eMotionFor'+'Weapons']());},Game_Battler[_0xe90fac(0x510)][_0xe90fac(0x651)+_0xe90fac(0xd16)+_0xe90fac(0x154)]=function(){const _0x467370=_0xe90fac;if(!SceneManager[_0x467370(0x11be)+_0x467370(0x3ad)]())return;const _0x14d942=this[_0x467370(0x81d)]();if(!_0x14d942)return;let _0x136663=this[_0x467370(0xd83)]()?_0x14d942[_0x467370(0x79d)+_0x467370(0xdf4)]:_0x14d942['_svBattler'+_0x467370(0x15e6)][_0x467370(0x79d)+_0x467370(0xdf4)];_0x136663&&_0x136663[_0x467370(0xc70)](-0x15c+-0x4cf*0x7+0xb*0x32f);},Game_Battler[_0xe90fac(0x510)][_0xe90fac(0x12ba)+'on']=function(_0x1ec58f,_0x93f004,_0xaca85a){const _0x49909b=_0xe90fac,_0x50e3fb={'ePAPa':function(_0x5bb54c,_0x4ab8a9){return _0x5bb54c(_0x4ab8a9);},'sYXMy':_0x49909b(0x501),'dWNEd':_0x49909b(0x121e),'VTpQV':_0x49909b(0x929)};if(this[_0x49909b(0xb9a)]()&&!this[_0x49909b(0x358)+'er']())return;let _0x8b788c=0x1289+0x3*0x2cf+0xee*-0x1d,_0xb5e619=-0x1daa*-0x1+-0xfd1+0x2c5*-0x5;_0x1ec58f[_0x49909b(0x3eb)](/ATTACK[ ](\d+)/i)&&(_0xb5e619=_0x50e3fb[_0x49909b(0x1338)](Number,RegExp['$1']),_0xb5e619--);if(this[_0x49909b(0xd83)]()){const _0x395883=this[_0x49909b(0x1232)]();_0x8b788c=_0x395883[_0xb5e619]?_0x395883[_0xb5e619][_0x49909b(0x12b8)]:-0x18d1+-0x18c7+-0x4*-0xc66;}else this[_0x49909b(0xb9a)]()&&(_0x8b788c=this[_0x49909b(0x11a2)+_0x49909b(0xdcc)]()[_0x49909b(0x12b8)]||0x2*0xca6+0xb3*0xd+-0x2263);const _0xa24360=$dataSystem[_0x49909b(0x198)+_0x49909b(0x15e9)][_0x8b788c];_0x1ec58f[_0x49909b(0x3eb)](/attack/i)&&(_0x1ec58f=[_0x50e3fb[_0x49909b(0x112d)],_0x50e3fb[_0x49909b(0x7fc)],_0x50e3fb[_0x49909b(0xada)]][_0xa24360['type']]||_0x50e3fb[_0x49909b(0x7fc)]),this[_0x49909b(0xc3f)+'ionData']={'motionType':_0x1ec58f,'weaponImageId':_0x93f004?_0xa24360[_0x49909b(0x1041)+_0x49909b(0x14e5)]:-0x1c25+0x8*0x1de+0xd35,'pattern':_0xaca85a};},Game_Battler[_0xe90fac(0x510)][_0xe90fac(0x4f8)]=function(_0x5e6ac9){const _0x7969aa=_0xe90fac,_0x296813={'Lqukm':function(_0x5da5fe,_0x38fc50){return _0x5da5fe===_0x38fc50;}};if(!_0x5e6ac9)return![];return _0x296813[_0x7969aa(0x12d6)](_0x5e6ac9[_0x7969aa(0x2dd)+'t'](),this['friendsUni'+'t']());},Game_Battler[_0xe90fac(0x510)][_0xe90fac(0xdc7)]=function(_0x21a4ae){const _0x5189f1=_0xe90fac,_0x44955c={'Rmjlo':function(_0x23327e,_0x3647a6){return _0x23327e===_0x3647a6;}};if(!_0x21a4ae)return![];return _0x44955c[_0x5189f1(0x10a)](_0x21a4ae[_0x5189f1(0xb10)+'nit'](),this[_0x5189f1(0x2dd)+'t']());},Game_Battler['prototype'][_0xe90fac(0x48d)+_0xe90fac(0x1346)]=function(){return![];},Game_Actor[_0xe90fac(0x510)][_0xe90fac(0x48d)+_0xe90fac(0x1346)]=function(){const _0x3cb44a=_0xe90fac;return this[_0x3cb44a(0x84c)+'e']()[_0x3cb44a(0x3eb)](/\$/i);},Game_Enemy[_0xe90fac(0x510)]['hasStaticS'+_0xe90fac(0x1346)]=function(){const _0x4344e9=_0xe90fac;return this[_0x4344e9(0x358)+'er']()&&this['svBattlerN'+_0x4344e9(0xd7d)]()[_0x4344e9(0x3eb)](/\$/i);},VisuMZ[_0xe90fac(0x118f)]['Game_Actor'+_0xe90fac(0x2cb)]=Game_Actor[_0xe90fac(0x510)][_0xe90fac(0xc70)],Game_Actor['prototype']['setup']=function(_0x615398){const _0xfc5a=_0xe90fac;VisuMZ['BattleCore']['Game_Actor'+_0xfc5a(0x2cb)][_0xfc5a(0x351)](this,_0x615398),this[_0xfc5a(0xdae)+_0xfc5a(0xab8)]();},Game_Actor['prototype'][_0xe90fac(0xdae)+_0xe90fac(0xab8)]=function(){const _0x565198=_0xe90fac,_0x2c3922={'VlVNX':function(_0x5241fc,_0x441cfb){return _0x5241fc(_0x441cfb);}};this[_0x565198(0xb59)+_0x565198(0x8a)]='',this[_0x565198(0x31d)]()&&this[_0x565198(0x31d)]()[_0x565198(0xfee)][_0x565198(0x3eb)](/<BATTLE (?:IMAGE|PORTRAIT):[ ](.*)>/i)&&(this[_0x565198(0xb59)+_0x565198(0x8a)]=_0x2c3922['VlVNX'](String,RegExp['$1']));},Game_Actor['prototype']['getBattleP'+_0xe90fac(0x515)+_0xe90fac(0x4c1)]=function(){const _0x21f812=_0xe90fac,_0x45b6c2={'NFBEX':function(_0x1f5e55,_0x578de5){return _0x1f5e55!==_0x578de5;},'LSNWr':function(_0x502216,_0x479f20){return _0x502216!==_0x479f20;}};if(_0x45b6c2['NFBEX'](this['getBattleP'+_0x21f812(0xd8f)](),''))return this[_0x21f812(0x12d9)+'ortrait']();else{if(Imported[_0x21f812(0x100b)+_0x21f812(0xd01)+'e']&&_0x45b6c2[_0x21f812(0x132e)](this['getMenuIma'+'ge'](),''))return this['getMenuIma'+'ge']();}return'';},Game_Actor[_0xe90fac(0x510)][_0xe90fac(0x12d9)+_0xe90fac(0xd8f)]=function(){const _0x5805f6=_0xe90fac,_0x2c7980={'AQAni':function(_0x1b76a0,_0x369112){return _0x1b76a0===_0x369112;}};if(_0x2c7980[_0x5805f6(0x122a)](this[_0x5805f6(0xb59)+_0x5805f6(0x8a)],undefined))this[_0x5805f6(0xdae)+_0x5805f6(0xab8)]();return this[_0x5805f6(0xb59)+_0x5805f6(0x8a)];},Game_Actor[_0xe90fac(0x510)][_0xe90fac(0x105a)+_0xe90fac(0xd8f)]=function(_0x1bc85f){const _0x3feb3e=_0xe90fac,_0x23488f={'Nzsuq':function(_0x21ec88,_0x3ece2e){return _0x21ec88===_0x3ece2e;}};if(_0x23488f[_0x3feb3e(0x11b7)](this['_battlePor'+_0x3feb3e(0x8a)],undefined))this['initBattle'+_0x3feb3e(0xab8)]();this[_0x3feb3e(0xb59)+_0x3feb3e(0x8a)]=_0x1bc85f;if(SceneManager[_0x3feb3e(0x11be)+_0x3feb3e(0x3ad)]()&&$gameParty['battleMemb'+'ers']()['includes'](this)){const _0x475b60=SceneManager[_0x3feb3e(0x11dd)][_0x3feb3e(0xbed)+'dow'];_0x475b60&&_0x475b60[_0x3feb3e(0xfd4)+_0x3feb3e(0x5c3)](this);}},Game_Actor[_0xe90fac(0x510)][_0xe90fac(0x147c)+_0xe90fac(0x527)]=function(){return!![];},Game_Actor[_0xe90fac(0x510)]['isAutoBatt'+'le']=function(){const _0x4e64d7=_0xe90fac;if(!this['isConfused']()&&BattleManager['_autoBattl'+'e'])return!![];return Game_Battler[_0x4e64d7(0x510)][_0x4e64d7(0x9a9)+'le'][_0x4e64d7(0x351)](this);},VisuMZ['BattleCore'][_0xe90fac(0xf6a)+_0xe90fac(0x508)+_0xe90fac(0xc95)]=Game_Actor[_0xe90fac(0x510)][_0xe90fac(0x375)+_0xe90fac(0x1403)],Game_Actor[_0xe90fac(0x510)][_0xe90fac(0x375)+_0xe90fac(0x1403)]=function(){const _0x55bb61=_0xe90fac;if(BattleManager[_0x55bb61(0xcf9)+'e']&&!ConfigManager[_0x55bb61(0xfa2)+_0x55bb61(0x1b1)])return this[_0x55bb61(0x375)+_0x55bb61(0x1218)+_0x55bb61(0xa7f)]();else{return VisuMZ[_0x55bb61(0x118f)][_0x55bb61(0xf6a)+_0x55bb61(0x508)+_0x55bb61(0xc95)][_0x55bb61(0x351)](this);;}},Game_Actor[_0xe90fac(0x510)]['makeAction'+_0xe90fac(0x1218)+'tack']=function(){const _0x3a250e=_0xe90fac,_0x4ced3d=[],_0x528029=new Game_Action(this);return _0x528029[_0x3a250e(0x1207)](),_0x4ced3d['push'](_0x528029),_0x4ced3d;},Game_Actor[_0xe90fac(0x510)][_0xe90fac(0x750)+'ands']=function(){const _0x5637dc=_0xe90fac,_0x545423={'VAzmi':function(_0x576ee7,_0x5ae9c2){return _0x576ee7(_0x5ae9c2);}};return this[_0x5637dc(0x6b9)+'ss']()[_0x5637dc(0xfee)][_0x5637dc(0x3eb)](/<BATTLE COMMANDS>\s*([\s\S]*)\s*<\/BATTLE COMMANDS>/i)?_0x545423[_0x5637dc(0x85a)](String,RegExp['$1'])['split'](/[\r\n]+/):VisuMZ[_0x5637dc(0x118f)][_0x5637dc(0x281)][_0x5637dc(0x320)][_0x5637dc(0x653)+_0x5637dc(0xf85)];},Game_Actor['prototype'][_0xe90fac(0x1465)+'nchorX']=function(){const _0x526753=_0xe90fac,_0x40467e={'VydFz':function(_0x25ef5e,_0x6d5b19){return _0x25ef5e!==_0x6d5b19;},'PaAcE':function(_0x5430b5,_0x18e6b5){return _0x5430b5(_0x18e6b5);},'XTtlU':function(_0x4dbde2,_0x39eabc){return _0x4dbde2(_0x39eabc);}};if(_0x40467e['VydFz'](this['_cache'][_0x526753(0x10a8)],undefined))return this[_0x526753(0xe7)]['svAnchorX'];return this[_0x526753(0x31d)]()['note'][_0x526753(0x3eb)](/<SIDEVIEW ANCHOR: (.*), (.*)>/i)?(this['_cache']['svAnchorX']=_0x40467e['PaAcE'](eval,RegExp['$1']),this['_cache'][_0x526753(0x14a3)]=_0x40467e[_0x526753(0xa97)](eval,RegExp['$2'])):this[_0x526753(0xe7)][_0x526753(0x10a8)]=Game_Battler['prototype'][_0x526753(0x1465)+'nchorX']['call'](this),this[_0x526753(0xe7)][_0x526753(0x10a8)];},Game_Actor[_0xe90fac(0x510)][_0xe90fac(0x1465)+'nchorY']=function(){const _0x37287b=_0xe90fac,_0x37f775={'XnzoZ':function(_0x304d8b,_0x32eb08){return _0x304d8b!==_0x32eb08;},'fdxhz':function(_0x24267d,_0x4ebcf3){return _0x24267d(_0x4ebcf3);}};if(_0x37f775['XnzoZ'](this[_0x37287b(0xe7)][_0x37287b(0x14a3)],undefined))return this[_0x37287b(0xe7)][_0x37287b(0x14a3)];return this[_0x37287b(0x31d)]()[_0x37287b(0xfee)][_0x37287b(0x3eb)](/<SIDEVIEW ANCHOR: (.*), (.*)>/i)?(this[_0x37287b(0xe7)][_0x37287b(0x10a8)]=_0x37f775[_0x37287b(0x291)](eval,RegExp['$1']),this[_0x37287b(0xe7)][_0x37287b(0x14a3)]=_0x37f775['fdxhz'](eval,RegExp['$2'])):this[_0x37287b(0xe7)]['svAnchorY']=Game_Battler['prototype'][_0x37287b(0x1465)+_0x37287b(0x15e7)][_0x37287b(0x351)](this),this[_0x37287b(0xe7)][_0x37287b(0x14a3)];},Game_Actor[_0xe90fac(0x510)][_0xe90fac(0xa25)+'hadowVisib'+'le']=function(){const _0xe69b66=_0xe90fac,_0x4ab947={'KHslX':function(_0x5a7013,_0x5d8f23){return _0x5a7013!==_0x5d8f23;}};if(_0x4ab947[_0xe69b66(0x4f7)](this[_0xe69b66(0xe7)][_0xe69b66(0x11f6)],undefined))return this[_0xe69b66(0xe7)][_0xe69b66(0x11f6)];if(this[_0xe69b66(0x31d)]()['note']['match'](/<SIDEVIEW SHOW SHADOW>/i))this[_0xe69b66(0xe7)][_0xe69b66(0x11f6)]=!![];else this['actor']()[_0xe69b66(0xfee)][_0xe69b66(0x3eb)](/<SIDEVIEW HIDE SHADOW>/i)?this['_cache'][_0xe69b66(0x11f6)]=![]:this[_0xe69b66(0xe7)]['svShadow']=Game_Battler['prototype'][_0xe69b66(0xa25)+_0xe69b66(0x1607)+'le'][_0xe69b66(0x351)](this);return this[_0xe69b66(0xe7)][_0xe69b66(0x11f6)];},Game_Actor[_0xe90fac(0x510)][_0xe90fac(0x15fe)+_0xe90fac(0xa73)]=function(){const _0x35abcb=_0xe90fac;return VisuMZ[_0x35abcb(0x118f)][_0x35abcb(0x281)][_0x35abcb(0xd11)][_0x35abcb(0x8a1)+'e'];},Game_Actor['prototype']['performWea'+_0xe90fac(0xd8a)+'on']=function(){const _0x2f4aa5=_0xe90fac,_0x598ee2=this['weapons'](),_0x1da438=_0x598ee2[0xd45+0x202*-0x13+-0x1*-0x18e1]?_0x598ee2[0xb71*-0x1+0x6b2+0x2d*0x1b]['wtypeId']:-0x1559*-0x1+-0xe8e+-0x6cb,_0x55c01d=$dataSystem['attackMoti'+_0x2f4aa5(0x15e9)][_0x1da438];_0x55c01d&&this['startWeapo'+_0x2f4aa5(0x117c)](_0x55c01d[_0x2f4aa5(0x1041)+_0x2f4aa5(0x14e5)]);},Game_Actor['prototype'][_0xe90fac(0x763)+_0xe90fac(0x130a)]=function(_0x3cc857){const _0xe70a9f=_0xe90fac;Game_Battler[_0xe70a9f(0x510)][_0xe70a9f(0x763)+_0xe70a9f(0x130a)][_0xe70a9f(0x351)](this,_0x3cc857),this[_0xe70a9f(0x763)+_0xe70a9f(0x6e7)](_0x3cc857);},Game_Actor[_0xe90fac(0x510)]['getAttackM'+'otion']=function(){const _0x117d85=_0xe90fac,_0xcf377c=this[_0x117d85(0x1232)](),_0x1d0b46=_0xcf377c[-0x133+0x26b3+0x258*-0x10]?_0xcf377c[-0x434*0x7+-0xe1d*0x2+0x39a6][_0x117d85(0x12b8)]:-0x1c*-0x91+0x38d+-0x1369;return $dataSystem[_0x117d85(0x198)+_0x117d85(0x15e9)][_0x1d0b46];},Game_Actor[_0xe90fac(0x510)]['attackAnim'+_0xe90fac(0xc13)+'t']=function(_0x11273f){const _0x34254b=_0xe90fac,_0x812da0={'eupJN':function(_0x44253e,_0x3022b2){return _0x44253e||_0x3022b2;}};_0x11273f=_0x812da0[_0x34254b(0x5a4)](_0x11273f,0x254d+0xe49+-0x3395),_0x11273f--;const _0x1c8e11=this[_0x34254b(0x1232)]();return _0x1c8e11[_0x11273f]?_0x1c8e11[_0x11273f][_0x34254b(0x4cf)+'d']:0x264a+-0x221e+-0x42c;},Game_Actor[_0xe90fac(0x510)][_0xe90fac(0x408)+'otionSlot']=function(_0x40e258){const _0x1c5e49=_0xe90fac,_0x24920a={'jTMNe':function(_0x36a4a0,_0xf9ea95){return _0x36a4a0||_0xf9ea95;}};_0x40e258=_0x24920a[_0x1c5e49(0x10da)](_0x40e258,-0x23fe+0x12b1+0x114e),_0x40e258--;const _0x4e8738=this['weapons'](),_0xe0afd0=_0x4e8738[_0x40e258]?_0x4e8738[_0x40e258][_0x1c5e49(0x12b8)]:-0x1*-0xc89+-0x7b8+-0x4d1;return $dataSystem[_0x1c5e49(0x198)+_0x1c5e49(0x15e9)][_0xe0afd0];},Game_Actor[_0xe90fac(0x510)]['performAtt'+'ackSlot']=function(_0x45ba32){const _0x1fe2c7=_0xe90fac,_0x51aff1={'MUfSf':function(_0x28bc48,_0x4c33a3){return _0x28bc48||_0x4c33a3;},'igAwS':function(_0x2560e8,_0x5dbc61){return _0x2560e8===_0x5dbc61;},'ayquQ':_0x1fe2c7(0x501),'zYOus':function(_0x32673a,_0x882e79){return _0x32673a===_0x882e79;},'iGUKt':_0x1fe2c7(0x121e),'EhWlm':function(_0x4b2b57,_0x581b2b){return _0x4b2b57===_0x581b2b;},'ENFlN':_0x1fe2c7(0x929)};_0x45ba32=_0x51aff1[_0x1fe2c7(0x668)](_0x45ba32,0x7*-0xd+0x5c6+-0x56a),_0x45ba32--;const _0x593e21=this[_0x1fe2c7(0x1232)](),_0x5f481d=_0x593e21[_0x45ba32]?_0x593e21[_0x45ba32]['wtypeId']:0x1*0x19ee+0xdcc+-0x27ba,_0x2a0408=$dataSystem[_0x1fe2c7(0x198)+'ons'][_0x5f481d];if(_0x2a0408){if(_0x51aff1[_0x1fe2c7(0xba)](_0x2a0408['type'],0x3d7*-0x2+-0x195a+0x2108))this[_0x1fe2c7(0xa08)+_0x1fe2c7(0x130a)](_0x51aff1['ayquQ']);else{if(_0x51aff1[_0x1fe2c7(0xe12)](_0x2a0408[_0x1fe2c7(0x152a)],-0x20*-0xbe+-0x2034+0x875*0x1))this[_0x1fe2c7(0xa08)+_0x1fe2c7(0x130a)](_0x51aff1[_0x1fe2c7(0xec)]);else _0x51aff1[_0x1fe2c7(0x11a5)](_0x2a0408[_0x1fe2c7(0x152a)],0x1e0e*-0x1+-0x13*-0x59+0x1*0x1775)&&this[_0x1fe2c7(0xa08)+_0x1fe2c7(0x130a)](_0x51aff1[_0x1fe2c7(0xf11)]);}this[_0x1fe2c7(0x76f)+_0x1fe2c7(0x117c)](_0x2a0408['weaponImag'+'eId']);}},Game_Battler['prototype'][_0xe90fac(0x11ad)+_0xe90fac(0xd57)]=function(_0x597a02){const _0x4d98c5=_0xe90fac,_0x11a492={'ptOhD':function(_0x3f16d2,_0x4d4b12){return _0x3f16d2>_0x4d4b12;},'KlDhX':function(_0x4a5d90,_0x3bc7be){return _0x4a5d90||_0x3bc7be;}};if(this['isActor']()){const _0x3ff014=this[_0x4d98c5(0x1232)]();if(_0x11a492[_0x4d98c5(0x14cb)](_0x3ff014[_0x4d98c5(0x1268)],-0xc6c+-0xa4*0x26+-0xd*-0x2d4)){const _0x3d01f7=_0x3ff014[_0x597a02];if(_0x3d01f7)_0x597a02=this[_0x4d98c5(0x1260)]()[_0x4d98c5(0x741)](_0x3d01f7);}}this[_0x4d98c5(0x106c)+_0x4d98c5(0x22e)]=_0x11a492[_0x4d98c5(0xf22)](_0x597a02,-0xe39+-0x4b1*-0x3+0x26),this[_0x4d98c5(0xe7)]={};},Game_Battler[_0xe90fac(0x510)][_0xe90fac(0xc27)+_0xe90fac(0x543)]=function(){const _0x291556=_0xe90fac;this[_0x291556(0x106c)+'ponSlot']=this[_0x291556(0x106c)+_0x291556(0x22e)]||0x1915+-0x1*-0x2335+-0x1*0x3c4a,this[_0x291556(0x106c)+'ponSlot']++,this[_0x291556(0xe7)]={};},Game_Battler[_0xe90fac(0x510)][_0xe90fac(0x8e2)+'eWeaponSlo'+'t']=function(){const _0x335341=_0xe90fac;this[_0x335341(0x106c)+_0x335341(0x22e)]=undefined,this[_0x335341(0xe7)]={};},VisuMZ['BattleCore'][_0xe90fac(0xf6a)+_0xe90fac(0x13b8)]=Game_Actor[_0xe90fac(0x510)][_0xe90fac(0x1260)],Game_Actor[_0xe90fac(0x510)][_0xe90fac(0x1260)]=function(){const _0xb50dc1=_0xe90fac,_0x560aa8={'WHOlF':function(_0x5797f4,_0x2da786){return _0x5797f4!==_0x2da786;},'aEGdF':function(_0x321205,_0x28bef4){return _0x321205<_0x28bef4;},'AOzvX':function(_0x15afac,_0x2014ab){return _0x15afac===_0x2014ab;},'xvCgm':function(_0x34a11e,_0x5bffbc){return _0x34a11e!==_0x5bffbc;}};let _0x3ebbb5=VisuMZ[_0xb50dc1(0x118f)]['Game_Actor'+'_equips'][_0xb50dc1(0x351)](this);if(this[_0xb50dc1(0x1034)+_0xb50dc1(0xe1d)])return _0x3ebbb5;if(_0x560aa8['WHOlF'](this[_0xb50dc1(0x106c)+_0xb50dc1(0x22e)],undefined)){this[_0xb50dc1(0x1034)+_0xb50dc1(0xe1d)]=!![];const _0xbcde15=this['equipSlots']();for(let _0x5f0c49=0x19e5+-0x2333+-0x94e*-0x1;_0x560aa8['aEGdF'](_0x5f0c49,_0xbcde15[_0xb50dc1(0x1268)]);_0x5f0c49++){_0x560aa8[_0xb50dc1(0x13c6)](_0xbcde15[_0x5f0c49],0x26a2*-0x1+-0x1530+0x3bd3)&&_0x560aa8['xvCgm'](this['_activeWea'+_0xb50dc1(0x22e)],_0x5f0c49)&&(_0x3ebbb5[_0x5f0c49]=null);}this[_0xb50dc1(0x1034)+_0xb50dc1(0xe1d)]=undefined;}return _0x3ebbb5;},Window_BattleLog['prototype'][_0xe90fac(0x1308)+'ldTimes']=function(_0x94fe85){const _0x26845b=_0xe90fac;return _0x94fe85[_0x26845b(0xd83)]()?_0x94fe85[_0x26845b(0x1232)]()['length']||-0x1a73+-0x5c7*-0x5+0x59*-0x7:-0x1*0x1b71+0x114e+0xa24;},Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x11ad)+_0xe90fac(0xbdc)]=function(_0x3aeadd,_0x2118df){const _0x567116=_0xe90fac;_0x3aeadd&&_0x3aeadd[_0x567116(0xd83)]()&&_0x3aeadd['setActiveW'+'eaponSlot'](_0x2118df),this[_0x567116(0x514)+_0x567116(0x6da)]();},Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x8e2)+_0xe90fac(0x8c3)]=function(_0x2089ad){const _0x4e77af=_0xe90fac;_0x2089ad&&_0x2089ad[_0x4e77af(0xd83)]()&&_0x2089ad[_0x4e77af(0x8e2)+'eWeaponSlo'+'t'](),this['callNextMe'+_0x4e77af(0x6da)]();},Game_Actor[_0xe90fac(0x510)][_0xe90fac(0xb31)+_0xe90fac(0x53c)]=function(){const _0x41aace=_0xe90fac,_0x36883f={'CNWtD':'battleUIOf'+_0x41aace(0x53c)};let _0x1e981=_0x36883f[_0x41aace(0xb5d)];if(this['checkCache'+_0x41aace(0x66d)](_0x1e981))return this[_0x41aace(0xe7)][_0x1e981];return this[_0x41aace(0xe7)][_0x1e981]=this[_0x41aace(0x4e3)+_0x41aace(0xd07)+'X'](this[_0x41aace(0x31d)]()),this['_cache'][_0x1e981];},Game_Actor[_0xe90fac(0x510)]['battleUIOf'+'fsetY']=function(){const _0x58a2e4=_0xe90fac,_0x219027={'UhMyQ':_0x58a2e4(0xb31)+_0x58a2e4(0xebf)};let _0x3b3c39=_0x219027[_0x58a2e4(0x14ac)];if(this[_0x58a2e4(0x63f)+_0x58a2e4(0x66d)](_0x3b3c39))return this['_cache'][_0x3b3c39];return this[_0x58a2e4(0xe7)][_0x3b3c39]=this[_0x58a2e4(0x4e3)+'leUIOffset'+'Y'](this[_0x58a2e4(0x31d)]()),this[_0x58a2e4(0xe7)][_0x3b3c39];},VisuMZ[_0xe90fac(0x118f)]['Game_Enemy'+_0xe90fac(0x2cb)]=Game_Enemy['prototype'][_0xe90fac(0xc70)],Game_Enemy[_0xe90fac(0x510)]['setup']=function(_0x14dbdd,_0xded3f6,_0xcb5ca8){const _0x29bd80=_0xe90fac,_0x141c33={'QCQjH':_0x29bd80(0xf5c)+'1'},_0x507a52=_0x141c33[_0x29bd80(0x1112)]['split']('|');let _0x25642c=0xda*-0x22+0x11*-0x175+0x35b9;while(!![]){switch(_0x507a52[_0x25642c++]){case'0':this[_0x29bd80(0x149b)+'eCoreData']();continue;case'1':Imported['VisuMZ_1_E'+_0x29bd80(0x139d)+_0x29bd80(0x657)]&&this[_0x29bd80(0xac5)]();continue;case'2':this['setupBattl'+_0x29bd80(0x129a)]();continue;case'3':Imported[_0x29bd80(0xc89)+'lementStat'+_0x29bd80(0x657)]&&this['initElemen'+_0x29bd80(0xba3)+'e']();continue;case'4':_0x14dbdd=DataManager[_0x29bd80(0xdd2)+'Ds'](_0x14dbdd);continue;case'5':VisuMZ[_0x29bd80(0x118f)][_0x29bd80(0x601)+_0x29bd80(0x2cb)]['call'](this,_0x14dbdd,_0xded3f6,_0xcb5ca8);continue;}break;}},Game_Enemy[_0xe90fac(0x510)]['clearBattl'+'eCoreData']=function(){const _0x512eba=_0xe90fac,_0x293f19=VisuMZ['BattleCore']['Settings'][_0x512eba(0x105f)];this[_0x512eba(0xcd3)+_0x512eba(0xe52)]=_0x293f19[_0x512eba(0x11d7)+_0x512eba(0x1094)],this[_0x512eba(0x1ee)+'Data']={},this[_0x512eba(0x100)+_0x512eba(0xf55)+_0x512eba(0x798)]();},Game_Enemy[_0xe90fac(0x510)][_0xe90fac(0x15e2)+_0xe90fac(0x129a)]=function(){const _0x17154e=_0xe90fac,_0x4a2365={'keEdN':function(_0x4cf0ed,_0x21ad45){return _0x4cf0ed(_0x21ad45);},'yifmY':function(_0x40d9c4,_0x3c8c0f){return _0x40d9c4(_0x3c8c0f);},'PElIi':function(_0x3afd29,_0x2fbfe5){return _0x3afd29(_0x2fbfe5);},'OYcpZ':function(_0xb5da24,_0x176699){return _0xb5da24(_0x176699);},'VosWt':_0x17154e(0xdb2)+_0x17154e(0x11d4),'OzVSz':function(_0x1de599,_0x1e986d){return _0x1de599(_0x1e986d);},'NnISJ':_0x17154e(0x12bc)+'ass-%1-%2','TZZGc':_0x17154e(0xde0)+_0x17154e(0xb76),'WmsaH':_0x17154e(0x438)+_0x17154e(0x5ae),'sXGDw':function(_0x514f04,_0x56e4e7){return _0x514f04(_0x56e4e7);},'RCqNS':'SvMotionId'+'leSolo-%1-'+'%2','GfGmO':function(_0x2015c4,_0x10a7dc){return _0x2015c4(_0x10a7dc);},'Newfy':'SvMotionId'+_0x17154e(0x1611)+'%2'},_0x130a59=VisuMZ[_0x17154e(0x118f)][_0x17154e(0x281)][_0x17154e(0x105f)],_0x24fa9a=this['enemy']()[_0x17154e(0xfee)];this[_0x17154e(0x1ee)+_0x17154e(0x105)]={'name':'','wtypeId':_0x130a59['WtypeId'],'collapse':_0x130a59[_0x17154e(0x131c)+_0x17154e(0x8bb)],'motionIdle':_0x130a59[_0x17154e(0xbad)],'width':_0x130a59['Width']||-0xbf9+0x3*-0x2f9+0x1524,'height':_0x130a59['Height']||-0x1*-0x193a+-0x1*-0x11fb+-0x2af5,'anchorX':_0x130a59['AnchorX']||-0x8c5*-0x2+-0x120c+0x82,'anchorY':_0x130a59[_0x17154e(0xfd3)]||-0x295*-0x8+0x108d+0xf*-0x27b,'shadow':_0x130a59[_0x17154e(0x532)]};_0x24fa9a[_0x17154e(0x3eb)](/<ATTACK ANIMATION:[ ](\d+)>/i)&&(this[_0x17154e(0xcd3)+_0x17154e(0xe52)]=_0x4a2365[_0x17154e(0x290)](Number,RegExp['$1']));const _0x272f7e=this[_0x17154e(0x1ee)+_0x17154e(0x105)];if(_0x24fa9a[_0x17154e(0x3eb)](/<SIDEVIEW BATTLER: (.*)>/i))_0x272f7e[_0x17154e(0x14c)]=_0x4a2365[_0x17154e(0xd25)](String,RegExp['$1']);else{if(_0x24fa9a[_0x17154e(0x3eb)](/<SIDEVIEW BATTLERS>\s*([\s\S]*)\s*<\/SIDEVIEW BATTLERS>/i)){const _0x1b645c=_0x4a2365[_0x17154e(0x290)](String,RegExp['$1'])['split'](/[\r\n]+/)[_0x17154e(0x8a4)]('');_0x272f7e[_0x17154e(0x14c)]=DataManager['processRan'+_0x17154e(0x813)+'a'](_0x1b645c);}}_0x24fa9a[_0x17154e(0x3eb)](/<SIDEVIEW ANCHOR: (.*), (.*)>/i)&&(_0x272f7e[_0x17154e(0x1385)]=_0x4a2365[_0x17154e(0x290)](eval,RegExp['$1']),_0x272f7e[_0x17154e(0x147)]=_0x4a2365[_0x17154e(0xd25)](eval,RegExp['$2']));if(_0x24fa9a[_0x17154e(0x3eb)](/<SIDEVIEW COLLAPSE>/i))_0x272f7e['collapse']=!![];else _0x24fa9a[_0x17154e(0x3eb)](/<SIDEVIEW NO COLLAPSE>/i)&&(_0x272f7e[_0x17154e(0xa03)]=![]);if(_0x24fa9a[_0x17154e(0x3eb)](/<SIDEVIEW SHOW SHADOW>/i))_0x272f7e['shadow']=!![];else _0x24fa9a[_0x17154e(0x3eb)](/<SIDEVIEW HIDE SHADOW>/i)&&(_0x272f7e[_0x17154e(0x1543)]=![]);if(_0x24fa9a[_0x17154e(0x3eb)](/<SIDEVIEW IDLE MOTION: (.*)>/i))_0x272f7e[_0x17154e(0x2d4)]=_0x4a2365[_0x17154e(0x290)](String,RegExp['$1'])[_0x17154e(0x371)+'e']()[_0x17154e(0x808)]();else{if(_0x24fa9a['match'](/<SIDEVIEW IDLE MOTIONS>\s*([\s\S]*)\s*<\/SIDEVIEW IDLE MOTIONS>/i)){const _0xb94398=_0x4a2365[_0x17154e(0xd25)](String,RegExp['$1'])['split'](/[\r\n]+/)['remove']('');_0x272f7e[_0x17154e(0x2d4)]=DataManager[_0x17154e(0x13c8)+_0x17154e(0x813)+'a'](_0xb94398);}}_0x24fa9a['match'](/<SIDEVIEW SIZE: (\d+), (\d+)>/i)&&(_0x272f7e['width']=_0x4a2365['PElIi'](Number,RegExp['$1']),_0x272f7e['height']=_0x4a2365[_0x17154e(0x290)](Number,RegExp['$2']));if(_0x24fa9a[_0x17154e(0x3eb)](/<SIDEVIEW WEAPON: (.*)>/i))_0x272f7e[_0x17154e(0x12b8)]=DataManager[_0x17154e(0x922)+_0x17154e(0xdd9)](RegExp['$1']);else{if(_0x24fa9a['match'](/<SIDEVIEW WEAPONS>\s*([\s\S]*)\s*<\/SIDEVIEW WEAPONS>/i)){const _0x4a0bd7=_0x4a2365[_0x17154e(0xb0e)](String,RegExp['$1'])['split'](/[\r\n]+/)[_0x17154e(0x8a4)](''),_0x35fe44=DataManager[_0x17154e(0x13c8)+'domizedDat'+'a'](_0x4a0bd7);_0x272f7e[_0x17154e(0x12b8)]=DataManager['getWtypeId'+_0x17154e(0xdd9)](_0x35fe44);}}if(Imported['VisuMZ_1_E'+_0x17154e(0x139d)+_0x17154e(0x657)]){const _0x453ac8=this[_0x17154e(0x4b1)+_0x17154e(0xe58)]();for(const _0x15e2ff of _0x453ac8){const _0x12d769=this[_0x17154e(0xa9f)](_0x15e2ff)[_0x17154e(0xbf5)]['toUpperCas'+'e']()[_0x17154e(0x808)](),_0x425f2d=_0x15e2ff['toUpperCas'+'e']()[_0x17154e(0x808)]();if(_0x24fa9a[_0x17154e(0x3eb)](VisuMZ['ElementSta'+'tusCore']['RegExp'][_0x4a2365[_0x17154e(0x66a)][_0x17154e(0xeb8)](_0x425f2d,_0x12d769)]))_0x272f7e['name']=_0x4a2365[_0x17154e(0x3a2)](String,RegExp['$1']);else{if(_0x24fa9a[_0x17154e(0x3eb)](VisuMZ[_0x17154e(0xaea)+_0x17154e(0xdf0)][_0x17154e(0x193)][_0x4a2365['NnISJ'][_0x17154e(0xeb8)](_0x425f2d,_0x12d769)])){const _0x298b56=_0x4a2365[_0x17154e(0xd25)](String,RegExp['$1'])['split'](/[\r\n]+/)['remove']('');_0x272f7e[_0x17154e(0x14c)]=DataManager[_0x17154e(0x13c8)+_0x17154e(0x813)+'a'](_0x298b56);}}if(_0x24fa9a[_0x17154e(0x3eb)](VisuMZ['ElementSta'+_0x17154e(0xdf0)]['RegExp'][_0x4a2365[_0x17154e(0xd8d)][_0x17154e(0xeb8)](_0x425f2d,_0x12d769)]))_0x272f7e[_0x17154e(0x12b8)]=DataManager[_0x17154e(0x922)+_0x17154e(0xdd9)](RegExp['$1']);else{if(_0x24fa9a[_0x17154e(0x3eb)](VisuMZ['ElementSta'+_0x17154e(0xdf0)]['RegExp'][_0x4a2365[_0x17154e(0x10e5)]['format'](_0x425f2d,_0x12d769)])){const _0x2f775d=_0x4a2365[_0x17154e(0xbcf)](String,RegExp['$1'])[_0x17154e(0xab1)](/[\r\n]+/)['remove'](''),_0x36aac5=DataManager[_0x17154e(0x13c8)+_0x17154e(0x813)+'a'](_0x2f775d);_0x272f7e[_0x17154e(0x12b8)]=DataManager['getWtypeId'+_0x17154e(0xdd9)](_0x36aac5);}}if(_0x24fa9a[_0x17154e(0x3eb)](VisuMZ['ElementSta'+_0x17154e(0xdf0)][_0x17154e(0x193)][_0x4a2365['RCqNS'][_0x17154e(0xeb8)](_0x425f2d,_0x12d769)]))_0x272f7e['motionIdle']=_0x4a2365[_0x17154e(0x20a)](String,RegExp['$1'])[_0x17154e(0x371)+'e']()[_0x17154e(0x808)]();else{if(_0x24fa9a[_0x17154e(0x3eb)](VisuMZ[_0x17154e(0xaea)+_0x17154e(0xdf0)][_0x17154e(0x193)][_0x4a2365[_0x17154e(0x700)]['format'](_0x425f2d,_0x12d769)])){const _0x59fcfd=_0x4a2365[_0x17154e(0x3a2)](String,RegExp['$1'])[_0x17154e(0xab1)](/[\r\n]+/)[_0x17154e(0x8a4)]('');_0x272f7e[_0x17154e(0x2d4)]=DataManager['processRan'+'domizedDat'+'a'](_0x59fcfd);}}}}},Game_Enemy[_0xe90fac(0x510)][_0xe90fac(0x146d)+_0xe90fac(0x15b6)]=function(){const _0x16778c=_0xe90fac;return this[_0x16778c(0xcd3)+_0x16778c(0xe52)]||0xeee+-0xf*-0x17f+-0x255f;},Game_Enemy[_0xe90fac(0x510)]['attackAnim'+_0xe90fac(0x273)]=function(){const _0x37f3ea=_0xe90fac;return this['attackAnim'+_0x37f3ea(0x15b6)]();},Game_Enemy['prototype'][_0xe90fac(0x146d)+_0xe90fac(0xc13)+'t']=function(_0x586cd4){const _0x246f7e=_0xe90fac;return this['attackAnim'+_0x246f7e(0x15b6)]();},Game_Enemy[_0xe90fac(0x510)][_0xe90fac(0xa20)+_0xe90fac(0xddd)]=function(){const _0x2a65b5=_0xe90fac;if(this['enemy']()[_0x2a65b5(0xfee)][_0x2a65b5(0x3eb)](/<BATTLER SPRITE CANNOT MOVE>/i))return![];return Game_Battler[_0x2a65b5(0x510)][_0x2a65b5(0xa20)+'Move'][_0x2a65b5(0x351)](this);},Game_Enemy[_0xe90fac(0x510)][_0xe90fac(0xfa0)+_0xe90fac(0xbd5)]=function(){const _0x252f42=_0xe90fac;if(this[_0x252f42(0x70d)]()[_0x252f42(0xfee)][_0x252f42(0x3eb)](/<BATTLER SPRITE GROUNDED>/i))return!![];return![];},Game_Enemy[_0xe90fac(0x510)][_0xe90fac(0xffc)]=function(){const _0x505e45=_0xe90fac,_0xf1464f=[];for(const _0x2eea00 of this[_0x505e45(0x70d)]()['actions']){const _0x88c19f=$dataSkills[_0x2eea00[_0x505e45(0xa70)]];if(_0x88c19f&&!_0xf1464f[_0x505e45(0x79c)](_0x88c19f))_0xf1464f[_0x505e45(0x15f1)](_0x88c19f);}return _0xf1464f;},Game_Enemy['prototype'][_0xe90fac(0xb31)+'fsetX']=function(){const _0x40faa2=_0xe90fac,_0x38def0={'FqEkZ':_0x40faa2(0xb31)+'fsetX'};let _0xb62046=_0x38def0[_0x40faa2(0xdc5)];if(this['checkCache'+_0x40faa2(0x66d)](_0xb62046))return this['_cache'][_0xb62046];return this[_0x40faa2(0xe7)][_0xb62046]=this[_0x40faa2(0x4e3)+_0x40faa2(0xd07)+'X'](this['enemy']()),this[_0x40faa2(0xe7)][_0xb62046];},Game_Enemy[_0xe90fac(0x510)][_0xe90fac(0xb31)+'fsetY']=function(){const _0x21aa54=_0xe90fac,_0xdc3f75={'tNqHg':_0x21aa54(0xb31)+_0x21aa54(0xebf)};let _0x3f4b2d=_0xdc3f75[_0x21aa54(0xcca)];if(this[_0x21aa54(0x63f)+_0x21aa54(0x66d)](_0x3f4b2d))return this['_cache'][_0x3f4b2d];return this['_cache'][_0x3f4b2d]=this[_0x21aa54(0x4e3)+_0x21aa54(0xd07)+'Y'](this[_0x21aa54(0x70d)]()),this[_0x21aa54(0xe7)][_0x3f4b2d];},Game_Enemy['prototype'][_0xe90fac(0x11a2)+_0xe90fac(0xdcc)]=function(){const _0x67b601=_0xe90fac,_0x37d674={'yCPYv':function(_0x484bf8,_0x48f1c8){return _0x484bf8!==_0x48f1c8;}};if(_0x37d674[_0x67b601(0x12ad)](this[_0x67b601(0x1ee)+_0x67b601(0x105)],undefined))return this[_0x67b601(0x1ee)+_0x67b601(0x105)];return this['setupBattl'+'eCoreData'](),this[_0x67b601(0x1ee)+_0x67b601(0x105)];},Game_Enemy[_0xe90fac(0x510)]['hasSvBattl'+'er']=function(){const _0xbd9a39=_0xe90fac,_0x3488b7={'wufXH':function(_0x5d8b76,_0x58190b){return _0x5d8b76!==_0x58190b;}};return _0x3488b7[_0xbd9a39(0x10d1)](this[_0xbd9a39(0x11a2)+_0xbd9a39(0xdcc)]()[_0xbd9a39(0x14c)],'');},Game_Enemy[_0xe90fac(0x510)][_0xe90fac(0x298)+_0xe90fac(0xd7d)]=function(){const _0x38424d=_0xe90fac;return this[_0x38424d(0x11a2)+_0x38424d(0xdcc)]()[_0x38424d(0x14c)];},Game_Enemy['prototype'][_0xe90fac(0x15fe)+'othImage']=function(){const _0x18bccf=_0xe90fac;return this['hasSvBattl'+'er']()?VisuMZ['BattleCore'][_0x18bccf(0x281)][_0x18bccf(0xd11)][_0x18bccf(0x8a1)+'e']:VisuMZ['BattleCore'][_0x18bccf(0x281)]['Enemy'][_0x18bccf(0x8a1)+'e'];},Game_Enemy['prototype'][_0xe90fac(0x763)+'ion']=function(_0x2b7517){const _0x5f22ee=_0xe90fac;Game_Battler[_0x5f22ee(0x510)]['performAct'+'ion'][_0x5f22ee(0x351)](this,_0x2b7517);if(this[_0x5f22ee(0x358)+'er']())this[_0x5f22ee(0x763)+_0x5f22ee(0x6e7)](_0x2b7517);},Game_Enemy[_0xe90fac(0x510)][_0xe90fac(0xe22)+_0xe90fac(0x9dd)]=function(){const _0x3ff6d3=_0xe90fac,_0x2e5a45={'DUCyV':function(_0x4f23d7,_0x7a3178){return _0x4f23d7===_0x7a3178;},'rJomu':_0x3ff6d3(0x501),'iYHAa':function(_0x5d4186,_0x440b39){return _0x5d4186===_0x440b39;},'Konbn':_0x3ff6d3(0x121e),'NlHbf':_0x3ff6d3(0x929)},_0x5c1402=this[_0x3ff6d3(0x11a2)+_0x3ff6d3(0xdcc)]()[_0x3ff6d3(0x12b8)]||0xb1*0x38+-0xad*0x2b+-0x9a9,_0x29c945=$dataSystem[_0x3ff6d3(0x198)+_0x3ff6d3(0x15e9)][_0x5c1402];if(_0x29c945){if(_0x2e5a45[_0x3ff6d3(0x538)](_0x29c945['type'],-0xd*0x5b+-0x10*-0x184+-0x4b*0x43))this[_0x3ff6d3(0xa08)+_0x3ff6d3(0x130a)](_0x2e5a45[_0x3ff6d3(0xc8d)]);else{if(_0x2e5a45[_0x3ff6d3(0x57e)](_0x29c945[_0x3ff6d3(0x152a)],0x145a+0x1906*0x1+-0x2d5f))this[_0x3ff6d3(0xa08)+_0x3ff6d3(0x130a)](_0x2e5a45[_0x3ff6d3(0xa39)]);else _0x2e5a45[_0x3ff6d3(0x538)](_0x29c945[_0x3ff6d3(0x152a)],0x1c6f+-0x7*-0x203+-0x2a82)&&this[_0x3ff6d3(0xa08)+'ion'](_0x2e5a45[_0x3ff6d3(0x269)]);}}},Game_Enemy[_0xe90fac(0x510)][_0xe90fac(0x38b)+'ponAnimati'+'on']=function(){const _0x104ba3=_0xe90fac,_0x172d94=this['svBattlerD'+_0x104ba3(0xdcc)]()[_0x104ba3(0x12b8)]||0x2*0xa52+0x7b6+-0x1c5a,_0x52bbf7=$dataSystem[_0x104ba3(0x198)+_0x104ba3(0x15e9)][_0x172d94];_0x52bbf7&&this[_0x104ba3(0x76f)+_0x104ba3(0x117c)](_0x52bbf7['weaponImag'+_0x104ba3(0x14e5)]);},Game_Enemy[_0xe90fac(0x510)][_0xe90fac(0x408)+'otion']=function(){const _0x1614dc=_0xe90fac,_0x2b7c40=this['svBattlerD'+_0x1614dc(0xdcc)]()[_0x1614dc(0x12b8)]||0x295+-0x11a5+0xf10;return $dataSystem['attackMoti'+_0x1614dc(0x15e9)][_0x2b7c40];},Game_Enemy[_0xe90fac(0x510)]['getAttackM'+_0xe90fac(0xc21)]=function(_0x5a910c){const _0xf446b7=_0xe90fac;return this[_0xf446b7(0x408)+'otion']();},Game_Enemy['prototype']['performDam'+_0xe90fac(0x154d)]=function(){const _0x40f040=_0xe90fac,_0x7410e7={'vtkHn':_0x40f040(0x11df)};Game_Battler['prototype'][_0x40f040(0x179)+_0x40f040(0x154d)]['call'](this),this[_0x40f040(0x147c)+_0x40f040(0x527)]()&&this[_0x40f040(0x358)+'er']()&&this['requestMot'+'ion'](_0x7410e7[_0x40f040(0xf54)]),SoundManager[_0x40f040(0x9e5)+_0x40f040(0x970)]();},Game_Enemy[_0xe90fac(0x510)][_0xe90fac(0x1cc)+_0xe90fac(0xca)]=function(){const _0x50752c=_0xe90fac,_0x575a16={'gzafH':_0x50752c(0x2d1)};Game_Battler[_0x50752c(0x510)][_0x50752c(0x1cc)+_0x50752c(0xca)][_0x50752c(0x351)](this),this['requestMot'+_0x50752c(0x130a)](_0x575a16['gzafH']);},Game_Enemy[_0xe90fac(0x510)][_0xe90fac(0x898)+_0xe90fac(0x145a)]=function(){const _0x2381f7=_0xe90fac,_0x2614d0={'QoCwb':_0x2381f7(0x2d1)};Game_Battler[_0x2381f7(0x510)][_0x2381f7(0x898)+_0x2381f7(0x145a)][_0x2381f7(0x351)](this),this[_0x2381f7(0xa08)+_0x2381f7(0x130a)](_0x2614d0[_0x2381f7(0x140f)]);},Game_Enemy['prototype'][_0xe90fac(0x10f)+_0xe90fac(0x12c9)]=function(){const _0x108414=_0xe90fac;Game_Battler['prototype']['performCou'+_0x108414(0x12c9)]['call'](this),this[_0x108414(0xe22)+_0x108414(0x9dd)]();},Game_Enemy['prototype'][_0xe90fac(0x793)+_0xe90fac(0x8bb)]=function(){const _0x21f24e=_0xe90fac,_0x33175c={'OAWKv':function(_0x1f9448,_0x407b0b){return _0x1f9448>=_0x407b0b;}};if(this[_0x21f24e(0x358)+'er']()){if(_0x33175c[_0x21f24e(0xe5e)](this[_0x21f24e(0x387)+'pe'](),0x47*-0x16+0x2311+-0x1cf6*0x1))return!![];return this['svBattlerD'+_0x21f24e(0xdcc)]()[_0x21f24e(0xa03)];}else return!![];},Game_Enemy['prototype'][_0xe90fac(0x1465)+_0xe90fac(0x13e7)]=function(){const _0x3644b8=_0xe90fac;return this['svBattlerD'+'ata']()[_0x3644b8(0x1385)];},Game_Enemy['prototype']['svBattlerA'+'nchorY']=function(){const _0x51b131=_0xe90fac;return this[_0x51b131(0x11a2)+'ata']()[_0x51b131(0x147)];},Game_Enemy[_0xe90fac(0x510)]['svBattlerS'+_0xe90fac(0x1607)+'le']=function(){const _0x2d8fd5=_0xe90fac;return this['svBattlerD'+'ata']()[_0x2d8fd5(0x1543)];},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x601)+'_transform']=Game_Enemy[_0xe90fac(0x510)]['transform'],Game_Enemy[_0xe90fac(0x510)][_0xe90fac(0x661)]=function(_0x1bdac0){const _0x491cec=_0xe90fac;VisuMZ[_0x491cec(0x118f)][_0x491cec(0x601)+_0x491cec(0xa79)][_0x491cec(0x351)](this,_0x1bdac0),this[_0x491cec(0x149b)+'eCoreData'](),this[_0x491cec(0x15e2)+'eCoreData']();const _0x50513d=this['battler']();_0x50513d&&(_0x50513d[_0x491cec(0x406)+'me']=undefined,_0x50513d[_0x491cec(0x117e)](this));},Game_Enemy[_0xe90fac(0x510)][_0xe90fac(0x100)+_0xe90fac(0xf55)+'ity']=function(){const _0x395a62=_0xe90fac,_0x1ea123=VisuMZ[_0x395a62(0x118f)][_0x395a62(0x281)][_0x395a62(0x105f)];this[_0x395a62(0x3b8)+'isibleDura'+'tion']=_0x1ea123[_0x395a62(0x141a)+_0x395a62(0x611)]??-0xc6d+0x131a+-0x1*0x6ad;},Game_Enemy['prototype'][_0xe90fac(0xb2d)+_0xe90fac(0x864)+'ible']=function(){const _0x2f0d31=_0xe90fac,_0x3cd23a={'wuNRB':function(_0x23744a,_0x173e44){return _0x23744a>_0x173e44;}};return this[_0x2f0d31(0x3b8)+'isibleDura'+'tion']&&_0x3cd23a[_0x2f0d31(0xfb0)](this[_0x2f0d31(0x3b8)+_0x2f0d31(0x1275)+_0x2f0d31(0x1580)],0x168f+-0x1775+0xe6);},Game_Enemy[_0xe90fac(0x510)]['updateName'+_0xe90fac(0xd6a)+_0xe90fac(0x573)]=function(){const _0x38160b=_0xe90fac,_0x3513ba={'ceivl':function(_0x229793,_0x4b366f){return _0x229793>_0x4b366f;}};this[_0x38160b(0x3b8)+_0x38160b(0x1275)+_0x38160b(0x1580)]&&_0x3513ba[_0x38160b(0x123f)](this[_0x38160b(0x3b8)+'isibleDura'+_0x38160b(0x1580)],0x9c2*-0x3+-0x1524+-0x2*-0x1935)&&this[_0x38160b(0x3b8)+_0x38160b(0x1275)+_0x38160b(0x1580)]--;},Game_Enemy[_0xe90fac(0x510)]['clearNameT'+_0xe90fac(0xf55)+'ity']=function(){const _0x52ae70=_0xe90fac;this[_0x52ae70(0x3b8)+_0x52ae70(0x1275)+_0x52ae70(0x1580)]=-0xeef*0x2+0x2*-0x41b+0x2614;},Game_Unit[_0xe90fac(0x510)][_0xe90fac(0x60b)+_0xe90fac(0xf8a)]=function(_0x2b007c){const _0x762da=_0xe90fac;for(const _0x1eb03d of this[_0x762da(0xe13)]()){if(_0x1eb03d)_0x1eb03d['processBat'+_0x762da(0xf8a)](_0x2b007c);}},Game_Unit[_0xe90fac(0x510)][_0xe90fac(0xdd4)+_0xe90fac(0xf28)]=function(){const _0xeb0014=_0xe90fac,_0x21e8a5=this['aliveMembe'+'rs']();return _0x21e8a5[Math[_0xeb0014(0x1608)](_0x21e8a5['length'])];},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x11ee)+_0xe90fac(0x762)]=Game_Party[_0xe90fac(0x510)][_0xe90fac(0x353)],Game_Party[_0xe90fac(0x510)][_0xe90fac(0x353)]=function(_0xb2f332){const _0x22efe5=_0xe90fac;VisuMZ[_0x22efe5(0x118f)][_0x22efe5(0x11ee)+_0x22efe5(0x762)][_0x22efe5(0x351)](this,_0xb2f332),BattleManager[_0x22efe5(0x9a4)+_0x22efe5(0x118c)]();},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x11ee)+_0xe90fac(0x1183)+'or']=Game_Party[_0xe90fac(0x510)][_0xe90fac(0x1569)+'r'],Game_Party[_0xe90fac(0x510)][_0xe90fac(0x1569)+'r']=function(_0x435316){const _0x1558d6=_0xe90fac;VisuMZ['BattleCore'][_0x1558d6(0x11ee)+_0x1558d6(0x1183)+'or']['call'](this,_0x435316),BattleManager['refreshSta'+_0x1558d6(0x118c)]();},VisuMZ['BattleCore'][_0xe90fac(0x15af)+_0xe90fac(0x2cb)]=Game_Troop[_0xe90fac(0x510)]['setup'],Game_Troop[_0xe90fac(0x510)][_0xe90fac(0xc70)]=function(_0x3d9af5){const _0x10d491=_0xe90fac;$gameTemp[_0x10d491(0x87)+_0x10d491(0x139f)+_0x10d491(0x670)+'ttleCore'](),$gameTemp[_0x10d491(0x66b)+_0x10d491(0x139f)+_0x10d491(0x670)+_0x10d491(0xc12)](_0x3d9af5),VisuMZ['BattleCore'][_0x10d491(0x15af)+_0x10d491(0x2cb)][_0x10d491(0x351)](this,_0x3d9af5),this[_0x10d491(0x8f5)+_0x10d491(0x12e8)]();},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x15af)+_0xe90fac(0x2fb)]=Game_Troop[_0xe90fac(0x510)][_0xe90fac(0xcf3)],Game_Troop['prototype'][_0xe90fac(0xcf3)]=function(){const _0x394b1c=_0xe90fac;let _0x458664=VisuMZ['BattleCore'][_0x394b1c(0x15af)+_0x394b1c(0x2fb)][_0x394b1c(0x351)](this);return this['expRate']&&(_0x458664*=this[_0x394b1c(0x1253)]()),Math[_0x394b1c(0x964)](_0x458664);},Game_Troop[_0xe90fac(0x510)]['expRate']=function(){return-0x20d9+0x937+0x17a3;},Game_Troop[_0xe90fac(0x510)][_0xe90fac(0x8f5)+_0xe90fac(0x12e8)]=function(){const _0x17f030=_0xe90fac,_0x120a79=DataManager['createTroo'+'pNote'](this[_0x17f030(0x7d1)]()['id']);if(_0x120a79['match'](/<(?:EXTEND|ADD):[ ](.*?)>/i)){const _0x118bd4=RegExp['$1'][_0x17f030(0xab1)](',')['map'](_0x7c4dee=>Number(_0x7c4dee));this['checkExten'+_0x17f030(0x5be)+_0x17f030(0xc84)](),this['processExt'+_0x17f030(0x7dc)+_0x17f030(0x2d2)](_0x118bd4);}},Game_Troop[_0xe90fac(0x510)][_0xe90fac(0x10fb)+_0xe90fac(0x5be)+_0xe90fac(0xc84)]=function(){const _0x53a4d5=_0xe90fac,_0x5a8d2c={'jUtgO':function(_0x4ec664,_0xbf5813){return _0x4ec664+_0xbf5813;},'zYDyf':_0x53a4d5(0xaa4)+_0x53a4d5(0x1151)+'ystem\x20-\x20%1'+_0x53a4d5(0xe98)+_0x53a4d5(0x1195),'xjwfr':_0x53a4d5(0x106d)+_0x53a4d5(0xf14)+_0x53a4d5(0x12fa)+_0x53a4d5(0x100a)+_0x53a4d5(0x534),'MmuEj':function(_0xbd2000,_0x4546b8){return _0xbd2000<_0x4546b8;},'WMdnn':function(_0x562ebd,_0x44ede4){return _0x562ebd(_0x44ede4);},'ESHVF':'BTB','apCkV':function(_0x4f10ce,_0x543a9d){return _0x4f10ce<_0x543a9d;},'DSjFJ':'CTB','Rjhal':function(_0x11c09c,_0x4146d9){return _0x11c09c<_0x4146d9;},'bJVwJ':function(_0x45c802,_0xf14bdc){return _0x45c802(_0xf14bdc);},'ayUDS':'STB'};let _0x26bd09=_0x5a8d2c['jUtgO'](_0x5a8d2c[_0x53a4d5(0x1236)],'\x0a');_0x26bd09+=_0x5a8d2c[_0x53a4d5(0xf30)],Imported[_0x53a4d5(0x859)+_0x53a4d5(0x9c1)+'mBTB']&&(_0x5a8d2c['MmuEj'](VisuMZ[_0x53a4d5(0xf7)+_0x53a4d5(0xec9)][_0x53a4d5(0x6ca)],0x1d55+0x1835*0x1+0x5*-0xab5+0.1100000000000001)&&(_0x5a8d2c[_0x53a4d5(0xd10)](alert,_0x26bd09[_0x53a4d5(0xeb8)](_0x5a8d2c[_0x53a4d5(0x10ac)])),SceneManager[_0x53a4d5(0x10c0)]())),Imported[_0x53a4d5(0x859)+'attleSyste'+_0x53a4d5(0x1544)]&&(_0x5a8d2c[_0x53a4d5(0x1145)](VisuMZ[_0x53a4d5(0xf7)+_0x53a4d5(0x553)][_0x53a4d5(0x6ca)],0x1fe5+0x2263+-0x4247*0x1+0.18999999999999995)&&(_0x5a8d2c[_0x53a4d5(0xd10)](alert,_0x26bd09[_0x53a4d5(0xeb8)](_0x5a8d2c['DSjFJ'])),SceneManager[_0x53a4d5(0x10c0)]())),Imported[_0x53a4d5(0x859)+_0x53a4d5(0x9c1)+_0x53a4d5(0x1048)]&&(_0x5a8d2c[_0x53a4d5(0x3f1)](VisuMZ[_0x53a4d5(0xf7)+_0x53a4d5(0xf01)][_0x53a4d5(0x6ca)],0x239+-0x2014+0xe*0x222+0.1499999999999999)&&(_0x5a8d2c[_0x53a4d5(0x777)](alert,_0x26bd09[_0x53a4d5(0xeb8)](_0x5a8d2c['ayUDS'])),SceneManager[_0x53a4d5(0x10c0)]()));},Game_Troop[_0xe90fac(0x510)][_0xe90fac(0x805)+_0xe90fac(0x7dc)+_0xe90fac(0x2d2)]=function(_0x24f2ac){const _0x4d9215=_0xe90fac;this[_0x4d9215(0x48c)+'t']={};for(const _0x2b65b3 of this['members']()){if(!_0x2b65b3)continue;_0x2b65b3[_0x4d9215(0x9cb)]('');}for(const _0x5b97c0 of _0x24f2ac){const _0x2197e6=$dataTroops[_0x5b97c0];if(_0x2197e6)this['addExtende'+_0x4d9215(0x9a6)+_0x4d9215(0x446)](_0x2197e6);}this[_0x4d9215(0x8cd)+'Names']();},Game_Troop[_0xe90fac(0x510)][_0xe90fac(0x10b1)+_0xe90fac(0x9a6)+'ers']=function(_0x245d1f){const _0x3fa3b0=_0xe90fac;for(const _0x33a923 of _0x245d1f[_0x3fa3b0(0xe13)]){if($dataEnemies[_0x33a923[_0x3fa3b0(0x999)]]){const _0x546799=_0x33a923[_0x3fa3b0(0x999)],_0x535be8=_0x33a923['x'],_0xb82af5=_0x33a923['y'],_0x1c7b95=new Game_Enemy(_0x546799,_0x535be8,_0xb82af5);_0x33a923[_0x3fa3b0(0x7f0)]&&_0x1c7b95[_0x3fa3b0(0x150b)](),this['_enemies'][_0x3fa3b0(0x15f1)](_0x1c7b95);}}},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x55c)+_0xe90fac(0xc94)+_0xe90fac(0x88)]=Game_Map[_0xe90fac(0x510)][_0xe90fac(0x15e2)+_0xe90fac(0xa15)],Game_Map[_0xe90fac(0x510)][_0xe90fac(0x15e2)+_0xe90fac(0xa15)]=function(){const _0x3f2899=_0xe90fac;VisuMZ['BattleCore']['Game_Map_s'+_0x3f2899(0xc94)+'back']['call'](this),this['setupBattl'+_0x3f2899(0x7be)+'eCore']();},Game_Map['prototype'][_0xe90fac(0x15e2)+_0xe90fac(0x7be)+_0xe90fac(0x1287)]=function(){const _0x438449=_0xe90fac,_0x3012cd={'RLbQD':function(_0x2a6aa2,_0x3c3c49){return _0x2a6aa2(_0x3c3c49);},'OcQTs':function(_0x225482,_0x3776bd){return _0x225482===_0x3776bd;},'btOJW':function(_0x5c3b4f,_0x57f0a5){return _0x5c3b4f(_0x57f0a5);}};this[_0x438449(0x3fa)+_0x438449(0x901)]={},this['_regionBat'+_0x438449(0x486)]={};if(!$dataMap)return;const _0x2ba938=$dataMap[_0x438449(0xfee)];if(!_0x2ba938)return;const _0x59a999=_0x2ba938['match'](/<REGION (\d+) BATTLEBACK(\d+): (.*)>/gi);if(_0x59a999)for(const _0x1ae348 of _0x59a999){_0x1ae348[_0x438449(0x3eb)](/<REGION (\d+) BATTLEBACK(\d+): (.*)>/i);const _0x388790=_0x3012cd[_0x438449(0xae4)](Number,RegExp['$1']),_0x3c4da4=_0x3012cd[_0x438449(0xae4)](Number,RegExp['$2']),_0x53ebbb=_0x3012cd[_0x438449(0xfb7)](_0x3c4da4,0x3a*0x38+0x459*0x3+-0x19ba)?this['_regionBat'+_0x438449(0x901)]:this[_0x438449(0x3fa)+'tleback2'],_0x444a8f=_0x3012cd[_0x438449(0x978)](String,RegExp['$3']);_0x53ebbb[_0x388790]=_0x444a8f;}},VisuMZ['BattleCore']['Game_Map_b'+_0xe90fac(0xf51)+_0xe90fac(0xbf5)]=Game_Map[_0xe90fac(0x510)][_0xe90fac(0x65f)+_0xe90fac(0x156f)],Game_Map[_0xe90fac(0x510)][_0xe90fac(0x65f)+_0xe90fac(0x156f)]=function(){const _0x41197c=_0xe90fac;if(!BattleManager[_0x41197c(0xf36)+'st']()){const _0x2865cf=$gamePlayer[_0x41197c(0xe1e)]($gamePlayer['x'],$gamePlayer['y']);if(this['_regionBat'+_0x41197c(0x901)]&&this['_regionBat'+_0x41197c(0x901)][_0x2865cf])return this[_0x41197c(0x3fa)+'tleback1'][_0x2865cf];}return VisuMZ[_0x41197c(0x118f)][_0x41197c(0x157a)+_0x41197c(0xf51)+'Name']['call'](this);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x157a)+_0xe90fac(0x1366)+_0xe90fac(0xbf5)]=Game_Map['prototype']['battleback'+'2Name'],Game_Map['prototype'][_0xe90fac(0x65f)+_0xe90fac(0xd51)]=function(){const _0x383cdb=_0xe90fac;if(!BattleManager['isBattleTe'+'st']()){const _0x500c65=$gamePlayer[_0x383cdb(0xe1e)]($gamePlayer['x'],$gamePlayer['y']);if(this[_0x383cdb(0x3fa)+_0x383cdb(0x901)]&&this[_0x383cdb(0x3fa)+_0x383cdb(0x486)][_0x500c65])return this[_0x383cdb(0x3fa)+_0x383cdb(0x486)][_0x500c65];}return VisuMZ[_0x383cdb(0x118f)][_0x383cdb(0x157a)+_0x383cdb(0x1366)+_0x383cdb(0xbf5)][_0x383cdb(0x351)](this);},VisuMZ['BattleCore'][_0xe90fac(0xc9c)+_0xe90fac(0x93b)+'st']=Game_Map[_0xe90fac(0x510)][_0xe90fac(0xad)+_0xe90fac(0xf85)],Game_Map['prototype'][_0xe90fac(0xad)+_0xe90fac(0xf85)]=function(){const _0x1d5128=_0xe90fac;let _0x586316=JsonEx['makeDeepCo'+'py'](VisuMZ[_0x1d5128(0x118f)]['Game_Map_e'+_0x1d5128(0x93b)+'st']['call'](this));return VisuMZ[_0x1d5128(0x118f)][_0x1d5128(0x308)+'ay'](_0x586316);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x308)+'ay']=function(_0x19aadd){const _0x4b39d4=_0xe90fac,_0xf0ca04={'UosHT':function(_0x3f0203,_0x585bfc){return _0x3f0203-_0x585bfc;},'DJher':function(_0x413966,_0x153d0f){return _0x413966>_0x153d0f;},'HdcLH':function(_0x51d5d1,_0x3bfd82){return _0x51d5d1*_0x3bfd82;},'ycKle':function(_0x44a572,_0xd6aec3){return _0x44a572+_0xd6aec3;}};var _0x1c8994,_0x2338c4,_0x13f54b;for(_0x13f54b=_0xf0ca04[_0x4b39d4(0xb4f)](_0x19aadd[_0x4b39d4(0x1268)],0x224a+-0x66e*0x2+-0x156d);_0xf0ca04[_0x4b39d4(0x1263)](_0x13f54b,0xb*0x23e+-0x4a*-0x3d+0x1*-0x2a4c);_0x13f54b--){_0x1c8994=Math[_0x4b39d4(0x12be)](_0xf0ca04['HdcLH'](Math[_0x4b39d4(0x9c3)](),_0xf0ca04[_0x4b39d4(0x1199)](_0x13f54b,-0x2*-0x432+0x21c8+-0x1*0x2a2b))),_0x2338c4=_0x19aadd[_0x13f54b],_0x19aadd[_0x13f54b]=_0x19aadd[_0x1c8994],_0x19aadd[_0x1c8994]=_0x2338c4;}return _0x19aadd;},VisuMZ['BattleCore'][_0xe90fac(0x98e)+_0xe90fac(0x6f4)+_0xe90fac(0x10f2)]=Game_Interpreter['prototype']['command357'],Game_Interpreter[_0xe90fac(0x510)][_0xe90fac(0x11b)]=function(_0x4ae46f){const _0x2e8388=_0xe90fac;return $gameTemp['setLastPlu'+_0x2e8388(0x10f2)+_0x2e8388(0x1b4)+'r'](this),VisuMZ[_0x2e8388(0x118f)][_0x2e8388(0x98e)+_0x2e8388(0x6f4)+_0x2e8388(0x10f2)]['call'](this,_0x4ae46f);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x98e)+'preter_upd'+_0xe90fac(0x571)+'e']=Game_Interpreter[_0xe90fac(0x510)]['updateWait'+'Mode'],Game_Interpreter[_0xe90fac(0x510)][_0xe90fac(0xde3)+_0xe90fac(0x39f)]=function(){const _0x31c1d3=_0xe90fac,_0x2ec5c4={'QaEsz':_0x31c1d3(0x1214)+'e','pmlag':function(_0x70613e,_0x22b923){return _0x70613e>_0x22b923;},'bJZsZ':'battleAnim'+_0x31c1d3(0x1094),'WFYtN':_0x31c1d3(0x339)+_0x31c1d3(0xc78),'PDlLT':_0x31c1d3(0x1558)+'ra','AMSey':_0x31c1d3(0x122)+'ct','eClYz':_0x31c1d3(0x8de)+'t','sExxS':_0x31c1d3(0x86f),'SIIYQ':_0x31c1d3(0xb52),'oCJRX':_0x31c1d3(0x79a),'whvly':_0x31c1d3(0x389)+_0x31c1d3(0x798),'KzeQk':_0x31c1d3(0x1118),'plkqb':_0x31c1d3(0x15b4)+'teSkew','PWIpg':_0x31c1d3(0x5da)+_0x31c1d3(0x870),'SmyvK':_0x31c1d3(0xec8),'tzquF':function(_0x4fb704,_0x4b7bf7){return _0x4fb704>_0x4b7bf7;},'uDAQY':_0x31c1d3(0x11e8),'rtNDj':_0x31c1d3(0x15c7),'mqRNh':function(_0x282006,_0x2fb944){return _0x282006>_0x2fb944;},'BGCrx':'battleInje'+_0x31c1d3(0x8bc),'sGkid':_0x31c1d3(0x64f)+_0x31c1d3(0xf4d)};if(SceneManager[_0x31c1d3(0x11be)+_0x31c1d3(0x3ad)]())switch(this[_0x31c1d3(0xb87)]){case _0x2ec5c4[_0x31c1d3(0xbe4)]:if(Imported['VisuMZ_3_A'+'ctSeqCamer'+'a']){if(_0x2ec5c4[_0x31c1d3(0x7d4)]($gameScreen[_0x31c1d3(0x1558)+'raData']()[_0x31c1d3(0x1430)+_0x31c1d3(0x130a)],0x3*-0x94a+0x2b3+-0x11*-0x17b))return!![];this[_0x31c1d3(0xb87)]='';}break;case _0x2ec5c4['bJZsZ']:if(BattleManager[_0x31c1d3(0x981)][_0x31c1d3(0xfaa)+_0x31c1d3(0x137b)]())return!![];this[_0x31c1d3(0xb87)]='';break;case _0x2ec5c4['WFYtN']:if(BattleManager[_0x31c1d3(0x981)][_0x31c1d3(0x729)+'eBalloonPl'+'aying']())return!![];this[_0x31c1d3(0xb87)]='';break;case _0x2ec5c4['PDlLT']:if(Imported[_0x31c1d3(0xc49)+_0x31c1d3(0x26a)+'a']){if(_0x2ec5c4[_0x31c1d3(0x7d4)]($gameScreen[_0x31c1d3(0x1558)+'raData']()[_0x31c1d3(0x689)+_0x31c1d3(0x1580)],0x26ba+0x198f+-0x4049))return!![];if(_0x2ec5c4[_0x31c1d3(0x7d4)]($gameScreen[_0x31c1d3(0x1558)+_0x31c1d3(0x96d)]()[_0x31c1d3(0x89e)+'etDuration'],0x1bdb+0x1add+0x4*-0xdae))return!![];this[_0x31c1d3(0xb87)]='';}break;case _0x2ec5c4[_0x31c1d3(0x100c)]:if(BattleManager[_0x31c1d3(0x981)][_0x31c1d3(0xca5)+'g']())return!![];this[_0x31c1d3(0xb87)]='';break;case _0x2ec5c4[_0x31c1d3(0xd69)]:if(BattleManager[_0x31c1d3(0x981)][_0x31c1d3(0x1101)+_0x31c1d3(0x774)]())return!![];this['_waitMode']='';break;case _0x2ec5c4[_0x31c1d3(0x145e)]:if(BattleManager['_spriteset'][_0x31c1d3(0x917)+'mping']())return!![];this[_0x31c1d3(0xb87)]='';break;case _0x2ec5c4[_0x31c1d3(0xb3a)]:if(BattleManager[_0x31c1d3(0x3b7)][_0x31c1d3(0x704)]())return!![];this[_0x31c1d3(0xb87)]='';break;case _0x2ec5c4[_0x31c1d3(0x867)]:if(BattleManager[_0x31c1d3(0x981)][_0x31c1d3(0xde6)+'ving']())return!![];this[_0x31c1d3(0xb87)]='';break;case _0x2ec5c4[_0x31c1d3(0x46c)]:if(BattleManager[_0x31c1d3(0x981)]['isAnyoneCh'+_0x31c1d3(0x3bc)+_0x31c1d3(0x798)]())return!![];this['_waitMode']='';break;case _0x2ec5c4[_0x31c1d3(0x54a)]:if(BattleManager[_0x31c1d3(0x981)][_0x31c1d3(0x709)+_0x31c1d3(0x480)]())return!![];this[_0x31c1d3(0xb87)]='';break;case _0x2ec5c4[_0x31c1d3(0xfd6)]:if(BattleManager[_0x31c1d3(0x981)][_0x31c1d3(0xcea)+'ewing']())return!![];this[_0x31c1d3(0xb87)]='';break;case _0x2ec5c4[_0x31c1d3(0x3b2)]:if(Imported['VisuMZ_3_A'+'ctSeqProje'+_0x31c1d3(0x1cb)]){if(BattleManager['_spriteset']['isAnyProje'+_0x31c1d3(0x48b)+'nt']())return!![];this[_0x31c1d3(0xb87)]='';}break;case _0x2ec5c4['SmyvK']:if(Imported[_0x31c1d3(0xc49)+_0x31c1d3(0x26a)+'a']){if(_0x2ec5c4[_0x31c1d3(0x5c7)]($gameScreen[_0x31c1d3(0x1558)+_0x31c1d3(0x96d)]()[_0x31c1d3(0xf31)+'on'],0x1*-0x1306+0x12a1*-0x2+-0x1c24*-0x2))return!![];this['_waitMode']='';}break;case _0x2ec5c4[_0x31c1d3(0xe91)]:if(BattleManager[_0x31c1d3(0x981)][_0x31c1d3(0x997)+_0x31c1d3(0x294)]())return!![];this[_0x31c1d3(0xb87)]='';break;case _0x2ec5c4[_0x31c1d3(0xb3b)]:if(Imported['VisuMZ_3_A'+_0x31c1d3(0x26a)+'a']){if(_0x2ec5c4[_0x31c1d3(0xca7)]($gameScreen[_0x31c1d3(0x1558)+_0x31c1d3(0x96d)]()['zoomDurati'+'on'],0x16a*0x10+0x1612+0x1*-0x2cb2))return!![];this[_0x31c1d3(0xb87)]='';}break;case _0x2ec5c4[_0x31c1d3(0x15e4)]:if(Imported[_0x31c1d3(0xc49)+'ctSeqImpac'+'t']){if(BattleManager['_spriteset'][_0x31c1d3(0x3e6)+_0x31c1d3(0x69b)+_0x31c1d3(0x91f)]){if(BattleManager['_spriteset'][_0x31c1d3(0x3e6)+'jectAniPre'+_0x31c1d3(0x91f)]())return!![];this[_0x31c1d3(0xb87)]=_0x2ec5c4[_0x31c1d3(0x102c)];}else this['_waitMode']='';break;}break;case _0x2ec5c4[_0x31c1d3(0x102c)]:if(Imported[_0x31c1d3(0xc49)+_0x31c1d3(0x386)+'t']){if(BattleManager[_0x31c1d3(0x981)]['isAnyoneIn'+_0x31c1d3(0x22c)+_0x31c1d3(0x312)]())return!![];this['_waitMode']='';}break;}return VisuMZ[_0x31c1d3(0x118f)][_0x31c1d3(0x98e)+_0x31c1d3(0x1058)+_0x31c1d3(0x571)+'e'][_0x31c1d3(0x351)](this);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x98e)+'preter_com'+_0xe90fac(0x82d)]=Game_Interpreter[_0xe90fac(0x510)]['command301'],Game_Interpreter[_0xe90fac(0x510)][_0xe90fac(0x13f2)]=function(_0x824581){const _0xc21a4=_0xe90fac;return!$gameParty[_0xc21a4(0x138f)]()?this[_0xc21a4(0x13f2)+'_PreBattle'+_0xc21a4(0xcd4)](_0x824581):VisuMZ[_0xc21a4(0x118f)][_0xc21a4(0x98e)+_0xc21a4(0x195)+_0xc21a4(0x82d)]['call'](this,_0x824581);},Game_Interpreter[_0xe90fac(0x510)][_0xe90fac(0x13f2)+'1']=function(_0x418630){const _0x2e38c4=_0xe90fac;return VisuMZ[_0x2e38c4(0x118f)][_0x2e38c4(0x98e)+_0x2e38c4(0x195)+_0x2e38c4(0x82d)]['call'](this,_0x418630),BattleManager['setEventCa'+_0x2e38c4(0x139c)](_0x4fccb7=>{const _0x13ecd0=_0x2e38c4;this['_branch'][this[_0x13ecd0(0x98f)]]=_0x4fccb7;}),!![];},VisuMZ[_0xe90fac(0x118f)]['CheckMapBa'+_0xe90fac(0xb15)+'alid']=function(_0x1bcc77){const _0x351937=_0xe90fac,_0x31f5a8={'xYiQq':function(_0x27066e,_0xcc4f31){return _0x27066e<=_0xcc4f31;}},_0x6c8b05=$dataCommonEvents[_0x1bcc77];if(!_0x6c8b05)return![];if(_0x31f5a8['xYiQq'](_0x6c8b05[_0x351937(0xa83)][_0x351937(0x1268)],0x2029+-0x1*0x5e2+0x39*-0x76))return![];return!![];},Game_Interpreter[_0xe90fac(0x510)][_0xe90fac(0x13f2)+_0xe90fac(0x1083)+_0xe90fac(0xcd4)]=function(_0x2ff7e6){const _0x35dea5=_0xe90fac,_0x24f6fb={'dFDaX':function(_0x2f433a,_0x4a3e1f){return _0x2f433a+_0x4a3e1f;}},_0x3942bd=VisuMZ[_0x35dea5(0x118f)][_0x35dea5(0x281)][_0x35dea5(0x7dd)],_0x3160cb=_0x3942bd['BattleStar'+_0x35dea5(0x12d5)],_0x28d9d5=$dataCommonEvents[_0x3160cb];if(_0x28d9d5&&VisuMZ['BattleCore'][_0x35dea5(0x1429)+'ttleEventV'+_0x35dea5(0x879)](_0x3160cb)){const _0x1bd0e2=this[_0x35dea5(0x987)+_0x35dea5(0xfb1)]()?this['_eventId']:0x2*-0xf2f+0xa*0x311+-0x4c,_0x3994a3=_0x28d9d5[_0x35dea5(0xa83)];this[_0x35dea5(0x50a)](_0x3994a3,_0x1bd0e2),this[_0x35dea5(0x136a)]=JsonEx[_0x35dea5(0x2f7)+'py'](this[_0x35dea5(0x136a)]);const _0x34f0df={'code':0xbc3,'indent':this[_0x35dea5(0x98f)],'parameters':JsonEx[_0x35dea5(0x2f7)+'py'](_0x2ff7e6)};return this[_0x35dea5(0x136a)][_0x35dea5(0xba7)](_0x24f6fb[_0x35dea5(0x531)](this[_0x35dea5(0xd35)],-0x1*0x1d5+0x129a+-0x74*0x25),-0x1*0x23e+-0x1b4e*0x1+0x1d8c,_0x34f0df),!![];}else return VisuMZ[_0x35dea5(0x118f)]['Game_Inter'+_0x35dea5(0x195)+_0x35dea5(0x82d)]['call'](this,_0x2ff7e6);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xb54)+_0xe90fac(0x1474)+_0xe90fac(0x5e7)]=BattleManager[_0xe90fac(0x6e1)+'r'],BattleManager[_0xe90fac(0x6e1)+'r']=function(){const _0x156c7b=_0xe90fac;VisuMZ[_0x156c7b(0x118f)][_0x156c7b(0xb54)+'ger_onEnco'+_0x156c7b(0x5e7)]['call'](this),this['onEncounte'+_0x156c7b(0x3fd)+'e']();},BattleManager[_0xe90fac(0x6e1)+_0xe90fac(0x3fd)+'e']=function(){const _0x62026e=_0xe90fac,_0x14f20a={'IqRGv':function(_0x3f1a57,_0x3ec29d){return _0x3f1a57>_0x3ec29d;}},_0x318cc1=VisuMZ[_0x62026e(0x118f)][_0x62026e(0x281)][_0x62026e(0x7dd)],_0x3318b5=_0x318cc1[_0x62026e(0xcfe)+_0x62026e(0x12d5)];_0x3318b5&&VisuMZ['BattleCore']['CheckMapBa'+_0x62026e(0xb15)+'alid'](_0x3318b5)&&(this[_0x62026e(0x89f)+_0x62026e(0x12da)+_0x62026e(0x12bf)]=!![],$gameTemp[_0x62026e(0x11bf)+'monEvent'](_0x318cc1['BattleStar'+_0x62026e(0x12d5)]),$gameMap[_0x62026e(0x10ad)+'rpreter'](),$gameMap[_0x62026e(0x15b0)+'er'][_0x62026e(0x165)+'CommonEven'+'t']=!![]),_0x14f20a[_0x62026e(0x12f8)](_0x318cc1[_0x62026e(0xe8b)+'t'],-0x15*-0x199+-0x1319+-0xe74)&&(this[_0x62026e(0x9b9)]=!![]);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x4bd)+_0xe90fac(0x1122)+_0xe90fac(0x1106)]=Scene_Map[_0xe90fac(0x510)]['updateCall'+'Menu'],Scene_Map['prototype'][_0xe90fac(0x1122)+_0xe90fac(0x1106)]=function(){const _0x1fab0a=_0xe90fac;if(BattleManager[_0x1fab0a(0x89f)+_0x1fab0a(0x12da)+_0x1fab0a(0x12bf)])return;VisuMZ[_0x1fab0a(0x118f)][_0x1fab0a(0x4bd)+'updateCall'+_0x1fab0a(0x1106)]['call'](this);},VisuMZ['BattleCore'][_0xe90fac(0x4bd)+_0xe90fac(0xf84)+'le']=Scene_Map[_0xe90fac(0x510)]['launchBatt'+'le'],Scene_Map[_0xe90fac(0x510)][_0xe90fac(0xf84)+'le']=function(){const _0x2c97c9=_0xe90fac;BattleManager['_battleCor'+_0x2c97c9(0x12da)+'rtEvent']?this['battleCore'+_0x2c97c9(0xfc8)+_0x2c97c9(0xa4)]():VisuMZ[_0x2c97c9(0x118f)][_0x2c97c9(0x4bd)+_0x2c97c9(0xf84)+'le']['call'](this);},Scene_Map[_0xe90fac(0x510)][_0xe90fac(0x523)+'PreBattleC'+_0xe90fac(0xa4)]=function(){const _0x3775e4=_0xe90fac;this[_0x3775e4(0x14c3)]=!![];},VisuMZ[_0xe90fac(0x118f)]['SceneManag'+_0xe90fac(0x1f0)+'Changing']=SceneManager[_0xe90fac(0x159)+_0xe90fac(0x1c7)],SceneManager['isSceneCha'+_0xe90fac(0x1c7)]=function(){const _0x2913cd=_0xe90fac;if(BattleManager['_battleCor'+_0x2913cd(0x12da)+_0x2913cd(0x12bf)])return![];return VisuMZ[_0x2913cd(0x118f)][_0x2913cd(0xbd)+_0x2913cd(0x1f0)+'Changing'][_0x2913cd(0x351)](this);},VisuMZ['BattleCore'][_0xe90fac(0x98e)+_0xe90fac(0xadc)+_0xe90fac(0x4a9)]=Game_Interpreter[_0xe90fac(0x510)][_0xe90fac(0xafe)],Game_Interpreter[_0xe90fac(0x510)]['terminate']=function(){const _0x2e125c=_0xe90fac;VisuMZ['BattleCore'][_0x2e125c(0x98e)+_0x2e125c(0xadc)+'minate']['call'](this),this[_0x2e125c(0x165)+_0x2e125c(0x2be)+'t']&&(this[_0x2e125c(0x165)+_0x2e125c(0x2be)+'t']=undefined,SceneManager[_0x2e125c(0x11dd)][_0x2e125c(0x523)+_0x2e125c(0xd0)+_0x2e125c(0xea)]());},Scene_Map['prototype'][_0xe90fac(0x523)+'ResumeLaun'+_0xe90fac(0xea)]=function(){const _0x4b981f=_0xe90fac;BattleManager[_0x4b981f(0x89f)+_0x4b981f(0x12da)+_0x4b981f(0x12bf)]=undefined,BattleManager['_battleCor'+_0x4b981f(0xd4d)+_0x4b981f(0xb65)]=!![],this[_0x4b981f(0xd67)]();},VisuMZ['BattleCore']['Scene_Map_'+_0xe90fac(0xc68)+_0xe90fac(0x5d0)]=Scene_Map[_0xe90fac(0x510)]['initialize'],Scene_Map[_0xe90fac(0x510)]['initialize']=function(){const _0x38827b=_0xe90fac;VisuMZ[_0x38827b(0x118f)]['Scene_Map_'+_0x38827b(0xc68)+'After'][_0x38827b(0x351)](this),BattleManager[_0x38827b(0x89f)+_0x38827b(0xd4d)+'umeAfter']&&(this[_0x38827b(0x14c3)]=!![],BattleManager[_0x38827b(0x89f)+_0x38827b(0xd4d)+_0x38827b(0xb65)]=undefined);},VisuMZ['BattleCore'][_0xe90fac(0x4bd)+_0xe90fac(0xc68)]=Scene_Map[_0xe90fac(0x510)][_0xe90fac(0xc68)],Scene_Map[_0xe90fac(0x510)][_0xe90fac(0xc68)]=function(){const _0x190ec5=_0xe90fac;VisuMZ['BattleCore'][_0x190ec5(0x4bd)+'initialize'][_0x190ec5(0x351)](this),$gameTemp['clearForce'+_0x190ec5(0x139f)+_0x190ec5(0x670)+'ttleCore']();},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xbe3)+_0xe90fac(0x143e)+_0xe90fac(0xbaa)]=Scene_ItemBase[_0xe90fac(0x510)][_0xe90fac(0x78a)],Scene_ItemBase[_0xe90fac(0x510)][_0xe90fac(0x78a)]=function(){const _0xaa2aa0=_0xe90fac;VisuMZ['BattleCore'][_0xaa2aa0(0xbe3)+'Base_apply'+_0xaa2aa0(0xbaa)][_0xaa2aa0(0x351)](this);if(this[_0xaa2aa0(0xdd)]()[_0xaa2aa0(0xfee)]['match'](/<BYPASS AUTO ACTION SEQUENCE>/i))return;this[_0xaa2aa0(0xdd)]()['note']['match'](/<CUSTOM ACTION SEQUENCE>/i)&&($gameTemp[_0xaa2aa0(0x1a6)+_0xaa2aa0(0x7ad)]=[]),DataManager[_0xaa2aa0(0x525)+_0xaa2aa0(0x192)+_0xaa2aa0(0x5a6)+_0xaa2aa0(0x1117)+'ct'](this[_0xaa2aa0(0xdd)]())&&($gameTemp['_commonEve'+'ntQueue']=[]);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x733)+_0xe90fac(0x593)+'mands']=Scene_Options['prototype'][_0xe90fac(0x1aa)+'s'],Scene_Options[_0xe90fac(0x510)][_0xe90fac(0x1aa)+'s']=function(){const _0x259cf4=_0xe90fac;let _0x304d1b=VisuMZ[_0x259cf4(0x118f)][_0x259cf4(0x733)+_0x259cf4(0x593)+_0x259cf4(0x11b4)][_0x259cf4(0x351)](this);const _0x196b20=VisuMZ[_0x259cf4(0x118f)][_0x259cf4(0x281)];if(_0x196b20[_0x259cf4(0x33a)][_0x259cf4(0xfd5)]&&_0x196b20[_0x259cf4(0x33a)][_0x259cf4(0xe32)])_0x304d1b+=-0x1db5+-0x2059+0xa58*0x6;if(_0x196b20['HpGauge'][_0x259cf4(0xfd5)]&&_0x196b20['HpGauge'][_0x259cf4(0xe32)])_0x304d1b+=0x93a+-0x3*0x753+0xcc0;return _0x304d1b;},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x152d)+_0xe90fac(0x4ef)+_0xe90fac(0xe51)]=Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0xc68)],Scene_Battle[_0xe90fac(0x510)]['initialize']=function(){const _0x3669a5=_0xe90fac;VisuMZ[_0x3669a5(0x118f)][_0x3669a5(0x152d)+_0x3669a5(0x4ef)+_0x3669a5(0xe51)]['call'](this),this[_0x3669a5(0x12c8)+_0x3669a5(0x6bc)+_0x3669a5(0x13ba)]();},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x152d)+_0xe90fac(0x8e)]=Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0x147b)],Scene_Battle[_0xe90fac(0x510)]['start']=function(){const _0x284781=_0xe90fac;SceneManager[_0x284781(0x1473)+_0x284781(0x1367)+'eTransitio'+_0x284781(0x1357)]()?(Scene_Message[_0x284781(0x510)][_0x284781(0x147b)][_0x284781(0x351)](this),this[_0x284781(0x981)]&&this['_spriteset']['update'](),BattleManager[_0x284781(0x727)+_0x284781(0x758)+_0x284781(0xd11)]&&BattleManager[_0x284781(0xa47)+_0x284781(0xfc7)]()):(VisuMZ[_0x284781(0x118f)][_0x284781(0x152d)+_0x284781(0x8e)][_0x284781(0x351)](this),$gameTroop[_0x284781(0x112a)+_0x284781(0x1383)+_0x284781(0x583)]());},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x152d)+_0xe90fac(0x10df)]=Scene_Battle['prototype'][_0xe90fac(0xd67)],Scene_Battle[_0xe90fac(0x510)]['stop']=function(){const _0x3ab6e6=_0xe90fac;SceneManager[_0x3ab6e6(0x865)+_0x3ab6e6(0x1262)+_0x3ab6e6(0x316)+'e']()?Scene_Message[_0x3ab6e6(0x510)][_0x3ab6e6(0xd67)]['call'](this):VisuMZ[_0x3ab6e6(0x118f)][_0x3ab6e6(0x152d)+'le_stop']['call'](this);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x152d)+_0xe90fac(0x137)+'te']=Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0xafe)],Scene_Battle['prototype'][_0xe90fac(0xafe)]=function(){const _0x4013b3=_0xe90fac;SceneManager['isNextScen'+_0x4013b3(0x1262)+'nsitionabl'+'e']()?Scene_Message[_0x4013b3(0x510)]['terminate']['call'](this):VisuMZ[_0x4013b3(0x118f)][_0x4013b3(0x152d)+_0x4013b3(0x137)+'te'][_0x4013b3(0x351)](this),$gameTemp['clearBattl'+'eBalloons'](),this[_0x4013b3(0x12c8)+_0x4013b3(0x6bc)+_0x4013b3(0x13ba)]();},Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0xb5a)+_0xe90fac(0xcb3)]=function(){const _0xa2efd5=_0xe90fac,_0x2fc62c={'qDJiw':function(_0x5b3c33,_0x1e73b9){return _0x5b3c33!==_0x1e73b9;},'sbHhk':function(_0x290881,_0xf16e37){return _0x290881===_0xf16e37;},'MRZbK':_0xa2efd5(0xea1)};if(ConfigManager['uiMenuStyl'+'e']&&_0x2fc62c[_0xa2efd5(0xc3c)](ConfigManager['uiInputPos'+_0xa2efd5(0x191)],undefined))return ConfigManager['uiInputPos'+_0xa2efd5(0x191)];else{if(_0x2fc62c['sbHhk'](this[_0xa2efd5(0x3a1)+_0xa2efd5(0x15fa)](),_0x2fc62c[_0xa2efd5(0x127d)]))return![];else{return Scene_Message['prototype'][_0xa2efd5(0xb5a)+_0xa2efd5(0xcb3)]['call'](this);;}}},VisuMZ['BattleCore'][_0xe90fac(0x152d)+_0xe90fac(0x3e4)+_0xe90fac(0x561)]=Scene_Battle[_0xe90fac(0x510)]['createAllW'+_0xe90fac(0x1115)],Scene_Battle[_0xe90fac(0x510)]['createAllW'+_0xe90fac(0x1115)]=function(){const _0x40b92f=_0xe90fac;this[_0x40b92f(0xc63)+_0x40b92f(0xa2d)+_0x40b92f(0x1350)](),VisuMZ[_0x40b92f(0x118f)][_0x40b92f(0x152d)+_0x40b92f(0x3e4)+_0x40b92f(0x561)][_0x40b92f(0x351)](this),this['createAuto'+_0x40b92f(0x332)+'ow']();},VisuMZ[_0xe90fac(0x118f)]['Scene_Batt'+'le_createE'+_0xe90fac(0xa72)]=Scene_Battle['prototype'][_0xe90fac(0xc63)+_0xe90fac(0x59d)],Scene_Battle['prototype'][_0xe90fac(0xc63)+_0xe90fac(0x59d)]=function(){const _0x3e1987=_0xe90fac;VisuMZ['BattleCore']['Scene_Batt'+_0x3e1987(0x9d8)+_0x3e1987(0xa72)][_0x3e1987(0x351)](this),this[_0x3e1987(0xf21)+'iTargetWin'+_0x3e1987(0x1605)]();},Scene_Battle[_0xe90fac(0x510)]['createMult'+'iTargetWin'+_0xe90fac(0x1605)]=function(){const _0x41072d=_0xe90fac;this['createMult'+'iTargetWin'+_0x41072d(0x1600)](!![]),this[_0x41072d(0xf21)+_0x41072d(0x10b9)+'dow'](![]);},Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0x6a6)+_0xe90fac(0x36b)+'t']=function(_0x34bdb6){const _0x4ba12f=_0xe90fac,_0x104e5e={'qYZBm':function(_0x41a8de,_0xecd390){return _0x41a8de-_0xecd390;},'AmXRS':_0x4ba12f(0x6f6)+'ui','httYj':function(_0x529902,_0xba7737){return _0x529902-_0xba7737;},'pYbBk':function(_0x4e8c98,_0x2ef8a4){return _0x4e8c98-_0x2ef8a4;}},_0x18be5a=Window_BattleMultiTarget[_0x4ba12f(0xf70)],_0x45e27a=this['calcWindow'+_0x4ba12f(0x1e5)](-0x16*0x1a7+-0x2*-0x40b+-0x1c45*-0x1,!![]);let _0x1e83b9=_0x34bdb6?_0x104e5e[_0x4ba12f(0xb79)](Graphics[_0x4ba12f(0x3dc)],_0x18be5a):0x6*-0x48f+0x10*-0x145+-0x17d5*-0x2;_0x1e83b9+=_0x34bdb6?Window_BattleMultiTarget[_0x4ba12f(0x15d)+_0x4ba12f(0x107d)]:Window_BattleMultiTarget[_0x4ba12f(0xeba)+_0x4ba12f(0x107d)];const _0x3fd64e=[_0x104e5e[_0x4ba12f(0x7d9)]][_0x4ba12f(0x79c)](this[_0x4ba12f(0x3a1)+_0x4ba12f(0x15fa)]())?-0x78*0x45+0x1714+0x944:this[_0x4ba12f(0xbed)+_0x4ba12f(0x1600)]['height'];let _0x13831d=_0x104e5e['httYj'](_0x104e5e[_0x4ba12f(0x9c7)](Graphics[_0x4ba12f(0x7b7)],_0x3fd64e),_0x45e27a);return _0x13831d+=_0x34bdb6?Window_BattleMultiTarget[_0x4ba12f(0x15d)+_0x4ba12f(0x1466)]:Window_BattleMultiTarget[_0x4ba12f(0xeba)+_0x4ba12f(0x1466)],new Rectangle(_0x1e83b9,_0x13831d,_0x18be5a,_0x45e27a);},Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0xf21)+_0xe90fac(0x10b9)+_0xe90fac(0x1600)]=function(_0x205f78){const _0x4baf15=_0xe90fac,_0x2c4c67=this[_0x4baf15(0x6a6)+_0x4baf15(0x36b)+'t'](_0x205f78),_0x270948=new Window_BattleMultiTarget(_0x2c4c67,_0x205f78);this[_0x4baf15(0x132f)](_0x270948),_0x205f78?this[_0x4baf15(0x485)+_0x4baf15(0x10b9)+_0x4baf15(0x1600)]=_0x270948:this['_enemyMult'+_0x4baf15(0x10b9)+_0x4baf15(0x1600)]=_0x270948;},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x152d)+_0xe90fac(0x833)+_0xe90fac(0xa6a)+'n']=Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0x620)+_0xe90fac(0xd1f)],Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0x620)+_0xe90fac(0xd1f)]=function(){const _0x2f8a31=_0xe90fac,_0x7c235a={'NCVRv':function(_0x46e17c,_0x1e4732){return _0x46e17c===_0x1e4732;},'WtBqq':_0x2f8a31(0xea1)};VisuMZ[_0x2f8a31(0x118f)][_0x2f8a31(0x152d)+_0x2f8a31(0x833)+_0x2f8a31(0xa6a)+'n'][_0x2f8a31(0x351)](this),_0x7c235a[_0x2f8a31(0x11ac)](this[_0x2f8a31(0x3a1)+_0x2f8a31(0x15fa)](),_0x7c235a[_0x2f8a31(0xdcf)])&&this[_0x2f8a31(0xb09)+_0x2f8a31(0x23c)+_0x2f8a31(0xf97)+'yle']();},Scene_Battle['prototype'][_0xe90fac(0x11bb)+'UI']=function(_0x3b4cd6){const _0xa2e99d=_0xe90fac,_0x5e1447={'CiOst':function(_0x376429,_0x39569e){return _0x376429/_0x39569e;},'BQJBQ':function(_0xe9e236,_0x340ed1){return _0xe9e236-_0x340ed1;},'maTLG':function(_0x28ea57,_0x194699){return _0x28ea57/_0x194699;},'cGqvv':function(_0x1f259b,_0x3cb454){return _0x1f259b-_0x3cb454;},'eGTCc':function(_0x14fb0b,_0x49ceb5){return _0x14fb0b*_0x49ceb5;}};_0x3b4cd6?(this[_0xa2e99d(0x1487)+'er']['x']=_0x5e1447['CiOst'](_0x5e1447[_0xa2e99d(0x1322)](Graphics[_0xa2e99d(0x301)],Graphics[_0xa2e99d(0x3dc)]),0x475+0x4c1*0x1+-0x4*0x24d),this[_0xa2e99d(0x1487)+'er']['y']=_0x5e1447['maTLG'](_0x5e1447['cGqvv'](Graphics[_0xa2e99d(0xa68)],Graphics[_0xa2e99d(0x7b7)]),-0x2*-0xf86+-0x15f2+-0x918)):(this[_0xa2e99d(0x1487)+'er']['x']=_0x5e1447[_0xa2e99d(0x14b9)](Graphics[_0xa2e99d(0x301)],-0x199*0x15+-0x95e+0x7*0x623),this[_0xa2e99d(0x1487)+'er']['y']=_0x5e1447['eGTCc'](Graphics['height'],-0x3d4*0x8+0x20*0x89+0xd8a));},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x152d)+_0xe90fac(0x158e)+'extCommand']=Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0x118d)+_0xe90fac(0x1290)],Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0x118d)+_0xe90fac(0x1290)]=function(){const _0x29b088=_0xe90fac,_0x12fd6a={'CoXBB':function(_0x45df09,_0x5d4a35){return _0x45df09===_0x5d4a35;},'XdHge':function(_0x2a920a,_0xbe5795){return _0x2a920a===_0xbe5795;}},_0x2746a0=BattleManager[_0x29b088(0x31d)]();VisuMZ[_0x29b088(0x118f)][_0x29b088(0x152d)+'le_selectN'+_0x29b088(0xf32)]['call'](this);if(_0x2746a0){if(_0x12fd6a[_0x29b088(0xf3f)](_0x2746a0,BattleManager[_0x29b088(0x31d)]()))return;if(_0x12fd6a['XdHge'](_0x2746a0,BattleManager[_0x29b088(0x14c1)]))return;if(_0x2746a0['battler']())_0x2746a0[_0x29b088(0x81d)]()[_0x29b088(0xd0a)]();}},VisuMZ['BattleCore'][_0xe90fac(0x152d)+_0xe90fac(0x776)+_0xe90fac(0xd96)+_0xe90fac(0x1a5)]=Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0xc4f)+_0xe90fac(0x3d8)+'d'],Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0xc4f)+_0xe90fac(0x3d8)+'d']=function(){const _0x7e73a5=_0xe90fac,_0x567c3d=BattleManager[_0x7e73a5(0x31d)]();if(_0x567c3d&&_0x567c3d[_0x7e73a5(0x81d)])_0x567c3d[_0x7e73a5(0x81d)]()['stepBack']();VisuMZ[_0x7e73a5(0x118f)][_0x7e73a5(0x152d)+_0x7e73a5(0x776)+_0x7e73a5(0xd96)+_0x7e73a5(0x1a5)]['call'](this);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x152d)+'le_logWind'+_0xe90fac(0x88f)]=Scene_Battle[_0xe90fac(0x510)]['logWindowR'+'ect'],Scene_Battle['prototype']['logWindowR'+_0xe90fac(0x41d)]=function(){const _0x348d30=_0xe90fac;if(VisuMZ[_0x348d30(0x118f)][_0x348d30(0x281)][_0x348d30(0xa22)]['BattleLogR'+_0x348d30(0x12f0)])return VisuMZ['BattleCore'][_0x348d30(0x281)][_0x348d30(0xa22)][_0x348d30(0x443)+_0x348d30(0x12f0)]['call'](this);return VisuMZ['BattleCore'][_0x348d30(0x152d)+_0x348d30(0x1e9)+_0x348d30(0x88f)][_0x348d30(0x351)](this);},VisuMZ['BattleCore'][_0xe90fac(0x152d)+_0xe90fac(0x10ea)+_0xe90fac(0x15f6)+'dWindow']=Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0x1396)+_0xe90fac(0x2b6)+_0xe90fac(0xd82)],Scene_Battle['prototype']['createPart'+_0xe90fac(0x2b6)+_0xe90fac(0xd82)]=function(){const _0xf864a9=_0xe90fac;VisuMZ['BattleCore'][_0xf864a9(0x152d)+'le_createP'+_0xf864a9(0x15f6)+'dWindow'][_0xf864a9(0x351)](this),this[_0xf864a9(0x1396)+'yCommandWi'+_0xf864a9(0x2fd)+'Core']();},Scene_Battle['prototype'][_0xe90fac(0x1396)+_0xe90fac(0x2b6)+_0xe90fac(0x2fd)+_0xe90fac(0x126e)]=function(){const _0x58b224=_0xe90fac,_0x5b1a16={'YrjgV':_0x58b224(0xfa2),'JLOqu':_0x58b224(0x586),'wKuxh':_0x58b224(0x142b)},_0x3c7f78=this[_0x58b224(0x58e)+_0x58b224(0x3de)];_0x3c7f78['setHandler'](_0x5b1a16[_0x58b224(0x2bf)],this[_0x58b224(0xe4a)+_0x58b224(0x912)][_0x58b224(0x874)](this)),_0x3c7f78[_0x58b224(0x2a3)](_0x5b1a16['JLOqu'],this['commandOpt'+_0x58b224(0x1ab)][_0x58b224(0x874)](this));const _0x30a492=this[_0x58b224(0x3a1)+_0x58b224(0x15fa)]();switch(_0x30a492){case'xp':case _0x5b1a16[_0x58b224(0x1103)]:return this[_0x58b224(0x58e)+_0x58b224(0x3de)][_0x58b224(0x54c)+_0x58b224(0x2f4)](-0x190b+-0xe9*0x2+0x1ade);break;}},Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0xe4a)+_0xe90fac(0x912)]=function(){const _0x40ddda=_0xe90fac;BattleManager[_0x40ddda(0xcf9)+'e']=!![],$gameParty[_0x40ddda(0x375)+'s'](),this['selectNext'+'Command'](),BattleManager[_0x40ddda(0x537)]()&&(BattleManager[_0x40ddda(0xd3)]=![]);},Scene_Battle['prototype'][_0xe90fac(0x39e)+_0xe90fac(0x1ab)]=function(){const _0x3dc987=_0xe90fac,_0xcc11ac={'WSfNk':_0x3dc987(0xf33)};this[_0x3dc987(0x9ab)+_0x3dc987(0xe76)]()?(this[_0x3dc987(0x7c6)+_0x3dc987(0x14d7)]=!![],this['_logWindow'][_0x3dc987(0x15f1)](_0xcc11ac[_0x3dc987(0x15bd)],VisuMZ[_0x3dc987(0x118f)][_0x3dc987(0x281)]['PartyCmd'][_0x3dc987(0x4b4)+_0x3dc987(0xe29)+_0x3dc987(0x154d)])):this[_0x3dc987(0x1dd)+'s']();},Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0x9ab)+_0xe90fac(0xe76)]=function(){const _0x512be5=_0xe90fac;return BattleManager[_0x512be5(0x107c)+'b']();},Scene_Battle['prototype'][_0xe90fac(0x1dd)+'s']=function(){const _0x4452d2=_0xe90fac,_0x4bedb1={'KnVkh':_0x4452d2(0x659)+'4'},_0x1e2eb7=_0x4bedb1[_0x4452d2(0x1582)][_0x4452d2(0xab1)]('|');let _0x302960=-0x5*0x259+0xc30+-0x73;while(!![]){switch(_0x1e2eb7[_0x302960++]){case'0':SceneManager[_0x4452d2(0x15f1)](Scene_Options);continue;case'1':this[_0x4452d2(0x981)][_0x4452d2(0x94)]();continue;case'2':this[_0x4452d2(0x7c6)+_0x4452d2(0x14d7)]=![];continue;case'3':if(BattleManager[_0x4452d2(0xf36)+'st']())($dataSystem[_0x4452d2(0x65f)+_0x4452d2(0x156f)]||$dataSystem['battleback'+'2Name'])&&SceneManager[_0x4452d2(0x92f)+'kground']();else($gameMap[_0x4452d2(0x65f)+'1Name']()||$gameMap['battleback'+_0x4452d2(0xd51)]())&&SceneManager['snapForBac'+'kground']();continue;case'4':BattleManager['isTpb']()&&(BattleManager[_0x4452d2(0x727)+_0x4452d2(0x758)+'Actor']=BattleManager[_0x4452d2(0x31d)]());continue;case'5':this[_0x4452d2(0x1487)+'er']['visible']=![];continue;}break;}},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x152d)+_0xe90fac(0x14d8)+'attleProce'+'ss']=Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0xc88)+_0xe90fac(0x59a)],Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0xc88)+_0xe90fac(0x59a)]=function(){const _0x1ad8ca=_0xe90fac;VisuMZ[_0x1ad8ca(0x118f)][_0x1ad8ca(0x152d)+_0x1ad8ca(0x14d8)+'attleProce'+'ss'][_0x1ad8ca(0x351)](this);if(this[_0x1ad8ca(0x7c6)+_0x1ad8ca(0x14d7)]&&!BattleManager[_0x1ad8ca(0x14c1)])this['callOption'+'s']();},VisuMZ[_0xe90fac(0x118f)]['Scene_Batt'+_0xe90fac(0xe7d)]=Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0x94)],Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0x94)]=function(){const _0xbcccf8=_0xe90fac;VisuMZ['BattleCore'][_0xbcccf8(0x152d)+_0xbcccf8(0xe7d)][_0xbcccf8(0x351)](this),this[_0xbcccf8(0xf5)+'ParallelIn'+_0xbcccf8(0x1ef)]();},Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0xfdb)+'BattleWind'+'ow']=function(){const _0xdcaa29=_0xe90fac,_0x2a0a20=this[_0xdcaa29(0xfa2)+_0xdcaa29(0x955)]();this[_0xdcaa29(0xcf9)+_0xdcaa29(0xdc4)]=new Window_AutoBattleCancel(_0x2a0a20),this[_0xdcaa29(0xcf9)+_0xdcaa29(0xdc4)][_0xdcaa29(0x150b)](),this['addChild'](this[_0xdcaa29(0xcf9)+'eWindow']);},Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0xfa2)+_0xe90fac(0x955)]=function(){const _0x124ae9=_0xe90fac;return VisuMZ[_0x124ae9(0x118f)][_0x124ae9(0x281)][_0x124ae9(0x33a)][_0x124ae9(0x33a)+_0x124ae9(0x13d6)][_0x124ae9(0x351)](this);},Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0x12c8)+_0xe90fac(0x6bc)+_0xe90fac(0x13ba)]=function(){const _0x822e0=_0xe90fac;this[_0x822e0(0xe36)+_0x822e0(0x441)+_0x822e0(0x71d)]=[];},Scene_Battle['prototype'][_0xe90fac(0xf5)+_0xe90fac(0x1271)+_0xe90fac(0x1ef)]=function(){const _0x25e9db=_0xe90fac;if(!this[_0x25e9db(0xe36)+_0x25e9db(0x441)+_0x25e9db(0x71d)])return;for(const _0x52bcde of this['_onceParal'+'lelInterpr'+_0x25e9db(0x71d)]){_0x52bcde&&_0x52bcde['update']();}},Scene_Battle['prototype'][_0xe90fac(0xb46)+_0xe90fac(0x1016)+_0xe90fac(0x55a)]=function(_0x27620c){const _0xc4cebb=_0xe90fac,_0x11d85e=$dataCommonEvents[_0x27620c];if(!_0x11d85e)return;const _0x2d14e2=new Game_BattleOnceParallelInterpreter();this[_0xc4cebb(0x548)+_0xc4cebb(0x8a3)+_0xc4cebb(0x158a)](_0x2d14e2),_0x2d14e2[_0xc4cebb(0x1206)+_0xc4cebb(0x234)](_0x27620c);},Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0x548)+'allelInter'+_0xe90fac(0x158a)]=function(_0x6bac44){const _0x3976e6=_0xe90fac;this[_0x3976e6(0xe36)+_0x3976e6(0x441)+'eters']=this[_0x3976e6(0xe36)+'lelInterpr'+'eters']||[],this['_onceParal'+_0x3976e6(0x441)+_0x3976e6(0x71d)]['push'](_0x6bac44);},Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0x923)+_0xe90fac(0x1271)+'terpreter']=function(_0x59f2db){const _0x1916b7=_0xe90fac;this[_0x1916b7(0xe36)+'lelInterpr'+'eters']=this[_0x1916b7(0xe36)+_0x1916b7(0x441)+'eters']||[],this[_0x1916b7(0xe36)+_0x1916b7(0x441)+'eters']['remove'](_0x59f2db);},Game_Troop[_0xe90fac(0x510)][_0xe90fac(0x112a)+_0xe90fac(0x1383)+'allels']=function(){const _0x3da56b=_0xe90fac;for(const _0x15ae3a of this[_0x3da56b(0x7d1)]()['pages']){if(!this[_0x3da56b(0x592)+_0x3da56b(0x1387)+_0x3da56b(0xc72)](_0x15ae3a))continue;SceneManager[_0x3da56b(0x11dd)][_0x3da56b(0xb46)+_0x3da56b(0x925)+'pPage'](_0x15ae3a);}},Game_Troop['prototype']['doesPageHa'+_0xe90fac(0x1387)+'llelStart']=function(_0x3f5eab){const _0x4f310c=_0xe90fac;if(!_0x3f5eab)return;for(const _0x27edf2 of _0x3f5eab[_0x4f310c(0xa83)]){if([-0x1235+-0x16fb+0x2*0x14ce,-0xf24+-0x1aff*0x1+-0x1*-0x2bbb][_0x4f310c(0x79c)](_0x27edf2['code'])){const _0x27b86b=_0x27edf2[_0x4f310c(0x115b)][-0x1522+0xfc+0x1426];if(_0x27b86b[_0x4f310c(0x3eb)](/<ONCE PARALLEL WHEN START BATTLE>/i))return!![];}}return![];},Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0xb46)+'rallelTroo'+_0xe90fac(0x21f)]=function(_0x533fb3){const _0x374952=_0xe90fac;if(!_0x533fb3)return;const _0xb4b549=new Game_BattleOnceParallelInterpreter();this['addOncePar'+_0x374952(0x8a3)+'preter'](_0xb4b549),_0xb4b549[_0x374952(0x1007)+'ge'](_0x533fb3);};function Game_BattleOnceParallelInterpreter(){const _0x1ee342=_0xe90fac;this[_0x1ee342(0xc68)](...arguments);}Game_BattleOnceParallelInterpreter[_0xe90fac(0x510)]=Object[_0xe90fac(0xc3d)](Game_Interpreter[_0xe90fac(0x510)]),Game_BattleOnceParallelInterpreter[_0xe90fac(0x510)][_0xe90fac(0x14c0)+'r']=Game_BattleOnceParallelInterpreter,Game_BattleOnceParallelInterpreter[_0xe90fac(0x510)][_0xe90fac(0x1206)+'vent']=function(_0x3da066){const _0x2f79eb=_0xe90fac,_0x10d1b4=$dataCommonEvents[_0x3da066];_0x10d1b4?this[_0x2f79eb(0xc70)](_0x10d1b4[_0x2f79eb(0xa83)],0x3*0xa42+0x20d3*-0x1+-0x23*-0xf):this[_0x2f79eb(0xafe)]();},Game_BattleOnceParallelInterpreter[_0xe90fac(0x510)][_0xe90fac(0xafe)]=function(){const _0x27c78a=_0xe90fac;if(!SceneManager[_0x27c78a(0x11be)+'tle']())return;SceneManager[_0x27c78a(0x11dd)][_0x27c78a(0x923)+'ParallelIn'+_0x27c78a(0x14b3)](this),Game_Interpreter['prototype'][_0x27c78a(0xafe)]['call'](this);},Game_BattleOnceParallelInterpreter[_0xe90fac(0x510)][_0xe90fac(0x1007)+'ge']=function(_0x428550){const _0x39bb6a=_0xe90fac;_0x428550?this[_0x39bb6a(0xc70)](_0x428550[_0x39bb6a(0xa83)],-0x95f*-0x2+0x72*-0x22+-0x39a):this[_0x39bb6a(0xafe)]();},Scene_Battle[_0xe90fac(0x510)]['isPartyCom'+_0xe90fac(0x15d7)+_0xe90fac(0x3c4)]=function(){const _0xd9f881=_0xe90fac;return VisuMZ[_0xd9f881(0x118f)][_0xd9f881(0x281)][_0xd9f881(0x1463)][_0xd9f881(0x840)+_0xd9f881(0xdd8)];},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x152d)+_0xe90fac(0xb51)+_0xe90fac(0x78f)+'Selection']=Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0x182)+'CommandSel'+_0xe90fac(0x11db)],Scene_Battle[_0xe90fac(0x510)]['startParty'+_0xe90fac(0x15cd)+_0xe90fac(0x11db)]=function(){const _0x38993e=_0xe90fac;this[_0x38993e(0x5a5)+_0x38993e(0x15d7)+'Disabled']()?this[_0x38993e(0x1ec)+_0x38993e(0xcfc)+'ndSelectio'+'n']():VisuMZ[_0x38993e(0x118f)][_0x38993e(0x152d)+_0x38993e(0xb51)+_0x38993e(0x78f)+_0x38993e(0x1e0)][_0x38993e(0x351)](this);},Scene_Battle[_0xe90fac(0x510)]['onDisabled'+_0xe90fac(0xcfc)+_0xe90fac(0x11c0)+'n']=function(){const _0x37d9d3=_0xe90fac;if(BattleManager[_0x37d9d3(0x872)]())this[_0x37d9d3(0x118d)+_0x37d9d3(0x1290)]();else BattleManager[_0x37d9d3(0x537)]()&&VisuMZ[_0x37d9d3(0x118f)][_0x37d9d3(0x152d)+_0x37d9d3(0xb51)+_0x37d9d3(0x78f)+'Selection'][_0x37d9d3(0x351)](this);},VisuMZ['BattleCore']['Scene_Batt'+'le_command'+'Fight']=Scene_Battle[_0xe90fac(0x510)]['commandFig'+'ht'],Scene_Battle['prototype']['commandFig'+'ht']=function(){const _0x34807e=_0xe90fac;BattleManager[_0x34807e(0x537)]()?(this['tpbCommand'+_0x34807e(0x15a1)](),this[_0x34807e(0x7f8)+_0x34807e(0x15cd)+_0x34807e(0x11db)]()):VisuMZ['BattleCore'][_0x34807e(0x152d)+_0x34807e(0xa6)+_0x34807e(0x15a1)][_0x34807e(0x351)](this);},Scene_Battle[_0xe90fac(0x510)]['tpbCommand'+_0xe90fac(0x15a1)]=function(){const _0x1555a2=_0xe90fac,_0x5f0841={'xmKGl':_0x1555a2(0x12c3)};if(!VisuMZ[_0x1555a2(0x118f)][_0x1555a2(0x9e3)+_0x1555a2(0xe08)+'ed'])return;if(Imported[_0x1555a2(0x859)+_0x1555a2(0x9c1)+_0x1555a2(0x1544)]&&BattleManager[_0x1555a2(0x6c1)]())return;const _0x9da404=$gameParty[_0x1555a2(0xf79)+'rs']()[_0x1555a2(0x55f)](_0x437a7f=>_0x437a7f[_0x1555a2(0x128a)+'ed']()&&_0x437a7f[_0x1555a2(0x2e4)]());BattleManager[_0x1555a2(0x1123)+_0x1555a2(0x323)]=_0x9da404[0xd13*-0x1+0xe*0x8a+0x587]||null,BattleManager[_0x1555a2(0x1123)+'tor']&&BattleManager['_currentAc'+_0x1555a2(0x323)][_0x1555a2(0xfc2)+_0x1555a2(0x2ce)](_0x5f0841[_0x1555a2(0xc85)]);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x152d)+_0xe90fac(0xa6)+_0xe90fac(0xd19)]=Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0xe75)+_0xe90fac(0x109e)],Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0xe75)+_0xe90fac(0x109e)]=function(){const _0x4374e3=_0xe90fac;VisuMZ[_0x4374e3(0x118f)][_0x4374e3(0x152d)+_0x4374e3(0xa6)+_0x4374e3(0xd19)][_0x4374e3(0x351)](this);if(!BattleManager['isTpb']())BattleManager[_0x4374e3(0x1123)+_0x4374e3(0x323)]=null;},VisuMZ['BattleCore'][_0xe90fac(0x152d)+_0xe90fac(0x3e4)+_0xe90fac(0x11f2)+_0xe90fac(0x415)]=Scene_Battle['prototype'][_0xe90fac(0x12e6)+_0xe90fac(0x496)+_0xe90fac(0xd82)],Scene_Battle[_0xe90fac(0x510)]['createActo'+'rCommandWi'+_0xe90fac(0xd82)]=function(){const _0x471ad9=_0xe90fac;VisuMZ[_0x471ad9(0x118f)][_0x471ad9(0x152d)+_0x471ad9(0x3e4)+'ctorComman'+'dWindow']['call'](this),this[_0x471ad9(0x12e6)+_0x471ad9(0x496)+_0x471ad9(0x2fd)+_0x471ad9(0x126e)]();},Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0x12e6)+_0xe90fac(0x496)+_0xe90fac(0x2fd)+'Core']=function(){const _0x233ec2=_0xe90fac,_0x52d906={'CArfn':_0x233ec2(0xa34),'mCeiN':_0x233ec2(0xfa2),'IUmSn':_0x233ec2(0x39a)+'l','YFcsQ':_0x233ec2(0x505)},_0x28abb7=this[_0x233ec2(0x11f4)+'andWindow'];_0x28abb7[_0x233ec2(0x2a3)](_0x52d906[_0x233ec2(0x13c5)],this[_0x233ec2(0x13f6)+_0x233ec2(0x186)][_0x233ec2(0x874)](this)),_0x28abb7[_0x233ec2(0x2a3)](_0x52d906[_0x233ec2(0x196)],this[_0x233ec2(0x13f6)+_0x233ec2(0x423)+'le'][_0x233ec2(0x874)](this)),_0x28abb7[_0x233ec2(0x2a3)](_0x52d906[_0x233ec2(0xde9)],this[_0x233ec2(0x13f6)+_0x233ec2(0x6c3)+_0x233ec2(0x59e)][_0x233ec2(0x874)](this)),BattleManager[_0x233ec2(0x537)]()&&(this['isPartyCom'+_0x233ec2(0x15d7)+'Disabled']()?delete _0x28abb7[_0x233ec2(0xa85)][_0x52d906['YFcsQ']]:_0x28abb7[_0x233ec2(0x2a3)](_0x52d906[_0x233ec2(0xe1c)],this['actorComma'+_0x233ec2(0x677)+'B'][_0x233ec2(0x874)](this)));},Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0x13f6)+'ndEscape']=function(){const _0x1b8081=_0xe90fac;this[_0x1b8081(0xe75)+'ape']();},Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0x13f6)+_0xe90fac(0x423)+'le']=function(){const _0x349080=_0xe90fac;BattleManager['actor']()[_0x349080(0x549)+'ttleAction'+'s'](),BattleManager[_0x349080(0xc24)+_0x349080(0x120)](),BattleManager[_0x349080(0x118d)+_0x349080(0xd11)](),this[_0x349080(0x1486)+_0x349080(0x1162)]();},Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0x13f6)+'ndSingleSk'+_0xe90fac(0x59e)]=function(){const _0x348556=_0xe90fac,_0x3c17fe=BattleManager['inputtingA'+_0x348556(0xce0)](),_0x55cafc=this['_actorComm'+_0x348556(0x3de)][_0x348556(0xf09)]();_0x3c17fe[_0x348556(0x318)](_0x55cafc),BattleManager[_0x348556(0x31d)]()[_0x348556(0x1018)+_0x348556(0x15d6)]($dataSkills[_0x55cafc]),this[_0x348556(0x4ae)+_0x348556(0x1580)]();},Scene_Battle[_0xe90fac(0x510)]['actorComma'+'ndCancelTP'+'B']=function(){const _0x595e47=_0xe90fac;this['tpbActorSw'+_0x595e47(0x551)+_0x595e47(0x1576)]()?this[_0x595e47(0x39b)+_0x595e47(0x106f)+_0x595e47(0x133)]():this[_0x595e47(0x10c1)+'orCommandC'+_0x595e47(0x580)]();},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x9e3)+_0xe90fac(0xe08)+'ed']=![],Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0x13ca)+_0xe90fac(0x551)+'ionsMet']=function(){const _0x532f72=_0xe90fac,_0x24f6cf={'mZnQl':function(_0x3a9dae,_0x45b317){return _0x3a9dae>_0x45b317;},'SUxgS':function(_0x490b26,_0x4c6afe){return _0x490b26!==_0x4c6afe;},'ySYDP':function(_0x3cb9b1,_0x35dc2b){return _0x3cb9b1-_0x35dc2b;}};if(Imported['VisuMZ_2_B'+_0x532f72(0x9c1)+_0x532f72(0x1544)]&&BattleManager[_0x532f72(0x6c1)]())return![];else{if(!VisuMZ[_0x532f72(0x118f)][_0x532f72(0x9e3)+_0x532f72(0xe08)+'ed'])return![];const _0x56f7cc=$gameParty[_0x532f72(0xf79)+'rs']()[_0x532f72(0x55f)](_0x1da357=>_0x1da357[_0x532f72(0x128a)+'ed']()&&_0x1da357['canInput']());return _0x24f6cf['mZnQl'](_0x56f7cc[_0x532f72(0x1268)],-0xb*0x1ba+0x76f*-0x1+-0xf*-0x1c3)&&_0x24f6cf[_0x532f72(0xfc5)](BattleManager[_0x532f72(0x31d)](),_0x56f7cc[_0x24f6cf[_0x532f72(0x13c)](_0x56f7cc['length'],0x1668+0x1f3*-0x14+0x1095)]);}},Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0x39b)+_0xe90fac(0x106f)+_0xe90fac(0x133)]=function(){const _0x8ced49=_0xe90fac,_0x20ce39={'UHiRZ':function(_0xb6d797,_0x1bcd28){return _0xb6d797+_0x1bcd28;},'QpQSw':function(_0x51d8c8,_0x345b63){return _0x51d8c8||_0x345b63;},'iqMBL':_0x8ced49(0x12c3),'rWMsy':_0x8ced49(0xae2)},_0x1a9b8d=BattleManager[_0x8ced49(0x31d)](),_0x128595=_0x1a9b8d['battler']();if(_0x128595)_0x128595['stepBack']();const _0x289b5b=$gameParty[_0x8ced49(0xf79)+'rs']()[_0x8ced49(0x55f)](_0x37e220=>_0x37e220[_0x8ced49(0x128a)+'ed']()&&_0x37e220[_0x8ced49(0x2e4)]()),_0x4a22ea=_0x289b5b['indexOf'](_0x1a9b8d),_0x1f92b4=_0x289b5b[_0x20ce39[_0x8ced49(0xe45)](_0x4a22ea,-0x55*-0x69+0x1*0x19dc+-0x1*0x3cb8)];BattleManager['_currentAc'+_0x8ced49(0x323)]=_0x20ce39[_0x8ced49(0x1235)](_0x1f92b4,null);if(_0x1f92b4)_0x1f92b4[_0x8ced49(0xfc2)+'tate'](_0x20ce39[_0x8ced49(0x15da)]);_0x1a9b8d[_0x8ced49(0xfc2)+_0x8ced49(0x2ce)](_0x20ce39['rWMsy']),this[_0x8ced49(0x1486)+_0x8ced49(0x1162)]();},Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0x10c1)+'orCommandC'+'ancelTPB']=function(){const _0x423c22=_0xe90fac,_0x35cd43={'kHtgC':_0x423c22(0xae2)};this[_0x423c22(0x58e)+_0x423c22(0x3de)][_0x423c22(0xc70)](),this[_0x423c22(0x11f4)+_0x423c22(0x3de)][_0x423c22(0x202)]();if(!VisuMZ[_0x423c22(0x118f)][_0x423c22(0x9e3)+'hangeEnabl'+'ed'])return;if(Imported[_0x423c22(0x859)+_0x423c22(0x9c1)+'mCTB']&&BattleManager['isCTB']())return;if(BattleManager[_0x423c22(0x1123)+_0x423c22(0x323)]){BattleManager[_0x423c22(0x1123)+_0x423c22(0x323)][_0x423c22(0xfc2)+_0x423c22(0x2ce)](_0x35cd43[_0x423c22(0xae8)]);const _0x36b76c=BattleManager['_currentAc'+_0x423c22(0x323)]['battler']();if(_0x36b76c)_0x36b76c[_0x423c22(0xd0a)]();}BattleManager['_currentAc'+_0x423c22(0x323)]=null;},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x152d)+'le_createH'+_0xe90fac(0x385)]=Scene_Battle['prototype']['createHelp'+_0xe90fac(0x226)],Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0x313)+_0xe90fac(0x226)]=function(){const _0x430381=_0xe90fac;VisuMZ[_0x430381(0x118f)][_0x430381(0x152d)+_0x430381(0x2fc)+'elpWindow'][_0x430381(0x351)](this),this[_0x430381(0x313)+_0x430381(0x461)+_0x430381(0xa2f)]();},Scene_Battle['prototype'][_0xe90fac(0x313)+_0xe90fac(0x461)+_0xe90fac(0xa2f)]=function(){const _0x28034e=_0xe90fac;this['_actorComm'+_0x28034e(0x3de)][_0x28034e(0x114c)+_0x28034e(0x1600)](this['_helpWindo'+'w']),this[_0x28034e(0x58e)+_0x28034e(0x3de)]['setHelpWin'+_0x28034e(0x1600)](this[_0x28034e(0x507)+'w']);},Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0x3a1)+_0xe90fac(0x15fa)]=function(){const _0x13413e=_0xe90fac,_0x462b6f={'QolkN':_0x13413e(0x1371)+'1','bhvKk':function(_0x41c014,_0x1be92c){return _0x41c014!==_0x1be92c;},'DhtxI':function(_0x15d727,_0x4aa378){return _0x15d727===_0x4aa378;},'CfHUJ':'frontview_'+'ui','lKSlQ':_0x13413e(0x142c),'Ngmme':function(_0x2cbd88,_0x36fae6){return _0x2cbd88===_0x36fae6;},'STZYb':'sideview_u'+'i'},_0x3d814b=_0x462b6f['QolkN']['split']('|');let _0x3915f6=0x88b+0x709*-0x2+0x587;while(!![]){switch(_0x3d814b[_0x3915f6++]){case'0':this['_battleLay'+'outStyle']=VisuMZ[_0x13413e(0x118f)][_0x13413e(0x281)][_0x13413e(0x5a2)+'ut']['Style']['toLowerCas'+'e']()[_0x13413e(0x808)]();continue;case'1':return this[_0x13413e(0xdca)+_0x13413e(0x309)];case'2':if(_0x462b6f[_0x13413e(0x15ce)]($gameTemp[_0x13413e(0x1588)+_0x13413e(0x11fe)],undefined))return $gameTemp['_forcedBat'+_0x13413e(0x11fe)];continue;case'3':_0x462b6f['DhtxI'](this[_0x13413e(0xdca)+_0x13413e(0x309)],_0x462b6f[_0x13413e(0x1090)])&&!Imported[_0x13413e(0xb77)+'rontviewBa'+_0x13413e(0x940)]&&(this['_battleLay'+'outStyle']=_0x462b6f[_0x13413e(0x10d)]);continue;case'4':if(this[_0x13413e(0xdca)+_0x13413e(0x309)])return this[_0x13413e(0xdca)+_0x13413e(0x309)];continue;case'5':_0x462b6f['Ngmme'](this['_battleLay'+'outStyle'],_0x462b6f[_0x13413e(0x15c)])&&!Imported[_0x13413e(0xc07)+_0x13413e(0xcb7)+_0x13413e(0x146f)]&&(this[_0x13413e(0xdca)+_0x13413e(0x309)]=_0x462b6f['lKSlQ']);continue;}break;}},VisuMZ['BattleCore'][_0xe90fac(0x152d)+_0xe90fac(0xd8c)+_0xe90fac(0x275)]=Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0xcce)+_0xe90fac(0x1e5)],Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0xcce)+_0xe90fac(0x1e5)]=function(){const _0x45a4bf=_0xe90fac,_0x10b300={'chMmC':_0x45a4bf(0xa83)},_0x1f1159=this[_0x45a4bf(0x3a1)+_0x45a4bf(0x15fa)]();switch(_0x1f1159){case _0x10b300[_0x45a4bf(0x41e)]:return this[_0x45a4bf(0xbaf)+'Height'](Math[_0x45a4bf(0xd3e)](0x231*-0x8+-0xda*0x1c+0x2961,$gameParty[_0x45a4bf(0x1200)+_0x45a4bf(0xcdb)]()),!![]);break;default:return VisuMZ[_0x45a4bf(0x118f)]['Scene_Batt'+_0x45a4bf(0xd8c)+_0x45a4bf(0x275)][_0x45a4bf(0x351)](this);break;}},VisuMZ[_0xe90fac(0x118f)]['Scene_Batt'+'le_helpWin'+_0xe90fac(0xc59)]=Scene_Battle[_0xe90fac(0x510)]['helpWindow'+'Rect'],Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0xc38)+'Rect']=function(){const _0x3e2c66=_0xe90fac,_0x3036eb={'JGltu':'border','NHtjN':'default','xblwu':_0x3e2c66(0xa83),'PklVb':_0x3e2c66(0x142b)},_0x45f43a=this[_0x3e2c66(0x3a1)+_0x3e2c66(0x15fa)]();switch(_0x45f43a){case _0x3036eb[_0x3e2c66(0x1510)]:return this[_0x3e2c66(0xc38)+_0x3e2c66(0xb86)+_0x3e2c66(0x10f9)]();break;case _0x3036eb[_0x3e2c66(0x409)]:case _0x3036eb['xblwu']:case'xp':case _0x3036eb[_0x3e2c66(0x109c)]:default:return VisuMZ[_0x3e2c66(0x118f)][_0x3e2c66(0x152d)+_0x3e2c66(0x489)+_0x3e2c66(0xc59)][_0x3e2c66(0x351)](this);break;}},Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0x617)+_0xe90fac(0x88f)]=function(){const _0x20c5bd=_0xe90fac,_0x451cb9={'XfcVR':_0x20c5bd(0x142b),'ShMyJ':_0x20c5bd(0xea1),'ldeQh':_0x20c5bd(0x142c),'FBpHF':_0x20c5bd(0xa83)},_0x4b1ba5=this[_0x20c5bd(0x3a1)+_0x20c5bd(0x15fa)]();switch(_0x4b1ba5){case'xp':case _0x451cb9['XfcVR']:return this[_0x20c5bd(0x617)+_0x20c5bd(0x13a4)+_0x20c5bd(0x1176)]();break;case _0x451cb9['ShMyJ']:return this[_0x20c5bd(0x617)+_0x20c5bd(0xedf)+_0x20c5bd(0x146c)]();break;case _0x451cb9[_0x20c5bd(0x602)]:case _0x451cb9[_0x20c5bd(0x3b1)]:default:return this[_0x20c5bd(0x617)+_0x20c5bd(0x152f)+_0x20c5bd(0x6ee)]();break;}},VisuMZ['BattleCore'][_0xe90fac(0x152d)+_0xe90fac(0x156e)+_0xe90fac(0x5b7)+_0xe90fac(0x144)]=Scene_Battle['prototype'][_0xe90fac(0x550)+_0xe90fac(0x5e2)+'ct'],Scene_Battle['prototype'][_0xe90fac(0x550)+_0xe90fac(0x5e2)+'ct']=function(){const _0x42d01b=_0xe90fac,_0x5c6b34={'CZWlQ':'portrait','nbvcu':'border','IdALo':'default','bJzpV':_0x42d01b(0xa83)},_0x3bb5e5=this[_0x42d01b(0x3a1)+_0x42d01b(0x15fa)]();switch(_0x3bb5e5){case'xp':case _0x5c6b34[_0x42d01b(0x81b)]:return this['partyComma'+_0x42d01b(0x5e2)+'ctXPStyle']();break;case _0x5c6b34['nbvcu']:return this[_0x42d01b(0x550)+_0x42d01b(0x5e2)+_0x42d01b(0x83f)+_0x42d01b(0x1176)]();case _0x5c6b34[_0x42d01b(0xeb5)]:case _0x5c6b34['bJzpV']:default:return this[_0x42d01b(0x550)+_0x42d01b(0x5e2)+_0x42d01b(0x8aa)+'tyle']();break;}},Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0x550)+_0xe90fac(0x5e2)+_0xe90fac(0x8aa)+_0xe90fac(0x951)]=function(){const _0x160283=_0xe90fac,_0x593248={'lqvlX':function(_0x57b891,_0x307e9b){return _0x57b891-_0x307e9b;},'CbVWy':function(_0x587355,_0x388da5){return _0x587355-_0x388da5;}},_0x415f4c=VisuMZ['BattleCore'][_0x160283(0x281)][_0x160283(0x5a2)+'ut'],_0x5accb9=_0x415f4c[_0x160283(0x7cc)+'th']||0x1a93*0x1+0x15ff*0x1+-0x2fd2,_0x266af0=this[_0x160283(0xcce)+_0x160283(0x1e5)](),_0x5474cd=this['isRightInp'+_0x160283(0xcb3)]()?_0x593248['lqvlX'](Graphics[_0x160283(0x3dc)],_0x5accb9):-0x26bb+0x67c*-0x1+0x2d37,_0x2ad48d=_0x593248[_0x160283(0x8ff)](Graphics['boxHeight'],_0x266af0);return new Rectangle(_0x5474cd,_0x2ad48d,_0x5accb9,_0x266af0);},Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0x13f6)+_0xe90fac(0x5e2)+'ct']=function(){return this['partyComma'+'ndWindowRe'+'ct']();},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x152d)+_0xe90fac(0x2db)+'tatusWindo'+_0xe90fac(0x206)]=Scene_Battle['prototype']['updateStat'+_0xe90fac(0xa8c)+_0xe90fac(0x942)],Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0x14e)+'usWindowPo'+_0xe90fac(0x942)]=function(){const _0x556f34=_0xe90fac,_0x2e0ebb={'bykDt':_0x556f34(0x142b),'UarRo':'border','ZivaE':'default','Fagqx':_0x556f34(0xa83)},_0x462b86=this['battleLayo'+_0x556f34(0x15fa)]();switch(_0x462b86){case'xp':case _0x2e0ebb[_0x556f34(0x133d)]:case _0x2e0ebb['UarRo']:break;case _0x2e0ebb[_0x556f34(0x83b)]:case _0x2e0ebb[_0x556f34(0x22b)]:default:VisuMZ[_0x556f34(0x118f)][_0x556f34(0x152d)+_0x556f34(0x2db)+_0x556f34(0x8e8)+_0x556f34(0x206)]['call'](this);break;}},VisuMZ['BattleCore'][_0xe90fac(0x152d)+_0xe90fac(0x4fc)+'torSelecti'+'on']=Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0x7f8)+_0xe90fac(0x1e0)],Scene_Battle[_0xe90fac(0x510)]['startActor'+_0xe90fac(0x1e0)]=function(){const _0x485b63=_0xe90fac;VisuMZ[_0x485b63(0x118f)][_0x485b63(0x152d)+_0x485b63(0x4fc)+_0x485b63(0x1496)+'on'][_0x485b63(0x351)](this),this['makeTarget'+_0x485b63(0x5e6)+'oreVisible']();},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x152d)+_0xe90fac(0xa8b)+_0xe90fac(0x41f)+'on']=Scene_Battle['prototype'][_0xe90fac(0x40a)+_0xe90fac(0x1e0)],Scene_Battle['prototype'][_0xe90fac(0x40a)+_0xe90fac(0x1e0)]=function(){const _0x2d0e17=_0xe90fac;VisuMZ[_0x2d0e17(0x118f)][_0x2d0e17(0x152d)+_0x2d0e17(0xa8b)+_0x2d0e17(0x41f)+'on'][_0x2d0e17(0x351)](this),this[_0x2d0e17(0x356)+'ow'][_0x2d0e17(0xf81)](),this[_0x2d0e17(0xadf)+_0x2d0e17(0x5e6)+_0x2d0e17(0x545)]();},Scene_Battle['prototype'][_0xe90fac(0xadf)+_0xe90fac(0x5e6)+_0xe90fac(0x545)]=function(){const _0x42a379=_0xe90fac,_0x487aab={'nEVZc':_0x42a379(0x142b),'gnxjR':_0x42a379(0xea1),'ukYjf':function(_0x5a7baf,_0x393c48){return _0x5a7baf===_0x393c48;}},_0x177ee2=this['battleLayo'+_0x42a379(0x15fa)]();['xp',_0x487aab[_0x42a379(0x11a7)],_0x487aab[_0x42a379(0x9ea)]]['includes'](_0x177ee2)&&this['_actorComm'+_0x42a379(0x3de)][_0x42a379(0x202)](),(_0x487aab['ukYjf'](_0x177ee2,_0x487aab[_0x42a379(0x9ea)])||this['isSkillIte'+_0x42a379(0xf7b)+'ddle']())&&(this['_skillWind'+'ow'][_0x42a379(0x202)](),this['_itemWindo'+'w'][_0x42a379(0x202)]());},VisuMZ['BattleCore'][_0xe90fac(0x152d)+'le_onActor'+'Ok']=Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0x5e9)],Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0x5e9)]=function(){const _0x2c9914=_0xe90fac;VisuMZ['BattleCore'][_0x2c9914(0x152d)+_0x2c9914(0x671)+'Ok'][_0x2c9914(0x351)](this),this[_0x2c9914(0x10e8)+_0x2c9914(0x816)+_0x2c9914(0x8ac)]();},Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0x87d)+_0xe90fac(0xc31)]=function(){const _0x242c99=_0xe90fac,_0x118a9a={'nGWoX':_0x242c99(0x3e3),'CfKWY':'guard','dLOkj':'singleSkil'+'l'};return[_0x118a9a[_0x242c99(0xfd2)],_0x118a9a['CfKWY'],_0x118a9a[_0x242c99(0x19a)]][_0x242c99(0x79c)](this[_0x242c99(0x11f4)+_0x242c99(0x3de)]['currentSym'+_0x242c99(0x155f)]());},VisuMZ['BattleCore'][_0xe90fac(0x152d)+_0xe90fac(0x671)+_0xe90fac(0xb81)]=Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0x8b3)+_0xe90fac(0x93a)],Scene_Battle['prototype'][_0xe90fac(0x8b3)+_0xe90fac(0x93a)]=function(){const _0x117321=_0xe90fac;this[_0x117321(0x87d)+_0x117321(0xc31)]()?(this[_0x117321(0xbed)+'dow']['show'](),this[_0x117321(0xfb)+'ow'][_0x117321(0x150b)](),this['_actorComm'+_0x117321(0x3de)][_0x117321(0xa3a)]()):VisuMZ['BattleCore'][_0x117321(0x152d)+'le_onActor'+_0x117321(0xb81)][_0x117321(0x351)](this),this[_0x117321(0xc25)+'etSelectio'+_0x117321(0x6ff)+'y']();},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x152d)+_0xe90fac(0x467)+'Ok']=Scene_Battle['prototype'][_0xe90fac(0x587)],Scene_Battle['prototype']['onEnemyOk']=function(){const _0x30a3e8=_0xe90fac;if(!this['_enemyWind'+'ow'][_0x30a3e8(0x70d)]()){this[_0x30a3e8(0x356)+'ow'][_0x30a3e8(0xa3a)]();return;}const _0x4de693=BattleManager[_0x30a3e8(0x450)+_0x30a3e8(0xce0)]();_0x4de693[_0x30a3e8(0x49e)+'attlerKey'](this[_0x30a3e8(0x356)+'ow'][_0x30a3e8(0x70d)]()),this[_0x30a3e8(0x356)+'ow'][_0x30a3e8(0x564)+_0x30a3e8(0x14f9)+'ow'](),VisuMZ[_0x30a3e8(0x118f)][_0x30a3e8(0x152d)+_0x30a3e8(0x467)+'Ok']['call'](this),this[_0x30a3e8(0x10e8)+'lectionVis'+_0x30a3e8(0x8ac)]();},VisuMZ['BattleCore']['Scene_Batt'+_0xe90fac(0x467)+_0xe90fac(0xb81)]=Scene_Battle['prototype'][_0xe90fac(0x124a)+_0xe90fac(0x93a)],Scene_Battle['prototype']['onEnemyCan'+_0xe90fac(0x93a)]=function(){const _0x52f0be=_0xe90fac;this[_0x52f0be(0x87d)+_0x52f0be(0xc31)]()?(this['_statusWin'+_0x52f0be(0x1600)][_0x52f0be(0x3f3)](),this[_0x52f0be(0x356)+'ow'][_0x52f0be(0x150b)](),this[_0x52f0be(0x11f4)+_0x52f0be(0x3de)][_0x52f0be(0xa3a)]()):VisuMZ['BattleCore']['Scene_Batt'+_0x52f0be(0x467)+_0x52f0be(0xb81)][_0x52f0be(0x351)](this),this['cancelTarg'+_0x52f0be(0xd21)+_0x52f0be(0x6ff)+'y'](),this[_0x52f0be(0x356)+'ow'][_0x52f0be(0x564)+_0x52f0be(0x14f9)+'ow']();},Scene_Battle[_0xe90fac(0x510)]['okTargetSe'+_0xe90fac(0x816)+_0xe90fac(0x8ac)]=function(){const _0xa45a68=_0xe90fac,_0x5f257f={'YoTEn':function(_0x202b46,_0x34b470){return _0x202b46===_0x34b470;},'UMhpa':_0xa45a68(0xea1)},_0x476886=this[_0xa45a68(0x3a1)+_0xa45a68(0x15fa)]();(_0x5f257f['YoTEn'](_0x476886,_0x5f257f['UMhpa'])||this[_0xa45a68(0x12a2)+_0xa45a68(0xf7b)+_0xa45a68(0x5d8)]())&&(this[_0xa45a68(0xdff)+'ow'][_0xa45a68(0x1110)](),this[_0xa45a68(0xdff)+'ow'][_0xa45a68(0xd66)]&&this[_0xa45a68(0xdff)+'ow'][_0xa45a68(0x3f3)](),this[_0xa45a68(0xc4c)+'w'][_0xa45a68(0x1110)](),this[_0xa45a68(0xc4c)+'w'][_0xa45a68(0xd66)]&&this['_itemWindo'+'w'][_0xa45a68(0x3f3)]());},Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0xc25)+'etSelectio'+_0xe90fac(0x6ff)+'y']=function(){const _0xb57c71=_0xe90fac,_0xf4655b={'MvsOe':_0xb57c71(0x142b),'LEKSx':_0xb57c71(0xea1)},_0x426f81=this[_0xb57c71(0x3a1)+'utStyle']();['xp',_0xf4655b['MvsOe'],_0xf4655b[_0xb57c71(0x15f4)]][_0xb57c71(0x79c)](_0x426f81)&&this[_0xb57c71(0x11f4)+_0xb57c71(0x3de)][_0xb57c71(0x1110)](),this[_0xb57c71(0x10e8)+_0xb57c71(0x816)+_0xb57c71(0x8ac)]();},Scene_Battle[_0xe90fac(0x510)]['statusWind'+_0xe90fac(0x152f)+_0xe90fac(0x6ee)]=function(){const _0xbc6e6b=_0xe90fac,_0x325dd5={'nCCmk':function(_0x186ece,_0x1a1cd7){return _0x186ece-_0x1a1cd7;},'TFiXX':function(_0x338ef4,_0x4f3306){return _0x338ef4+_0x4f3306;}},_0x1bad64=VisuMZ[_0xbc6e6b(0x118f)]['Settings']['BattleLayo'+'ut'],_0x1bee79=Window_BattleStatus['prototype']['extraHeigh'+'t'](),_0xca1b5a=_0x325dd5[_0xbc6e6b(0x25d)](Graphics[_0xbc6e6b(0x3dc)],_0x1bad64[_0xbc6e6b(0x7cc)+'th']||0x1070+-0x1a+-0xf96),_0xbd6cbd=_0x325dd5[_0xbc6e6b(0x1592)](this['windowArea'+_0xbc6e6b(0x1e5)](),_0x1bee79),_0x410a33=this[_0xbc6e6b(0xb5a)+_0xbc6e6b(0xcb3)]()?0x220*-0x7+0x8a*0x2f+-0x53b*0x2:_0x325dd5[_0xbc6e6b(0x25d)](Graphics[_0xbc6e6b(0x3dc)],_0xca1b5a),_0x8a232c=_0x325dd5[_0xbc6e6b(0x1592)](_0x325dd5['nCCmk'](Graphics[_0xbc6e6b(0x7b7)],_0xbd6cbd),_0x1bee79);return new Rectangle(_0x410a33,_0x8a232c,_0xca1b5a,_0xbd6cbd);},Scene_Battle['prototype'][_0xe90fac(0x617)+_0xe90fac(0x13a4)+_0xe90fac(0x1176)]=function(){const _0x564fc5=_0xe90fac,_0x52e9bb={'zRFab':function(_0x48438f,_0x47e70e){return _0x48438f+_0x47e70e;},'MDhIl':function(_0x19d54b,_0x4d9157){return _0x19d54b-_0x4d9157;}},_0x3c188e=Window_BattleStatus['prototype'][_0x564fc5(0xb95)+'t'](),_0xac41a0=Graphics[_0x564fc5(0x3dc)],_0xb2ea33=_0x52e9bb[_0x564fc5(0xf08)](this[_0x564fc5(0xcce)+_0x564fc5(0x1e5)](),_0x3c188e),_0x4ae554=0xb29*-0x3+0x8e9*-0x2+0x1*0x334d,_0x325e7a=_0x52e9bb[_0x564fc5(0xf08)](_0x52e9bb['MDhIl'](Graphics[_0x564fc5(0x7b7)],_0xb2ea33),_0x3c188e);return new Rectangle(_0x4ae554,_0x325e7a,_0xac41a0,_0xb2ea33);},Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0x550)+_0xe90fac(0x5e2)+_0xe90fac(0xe2d)]=function(){const _0x2be3de=_0xe90fac,_0x1266f9={'xKifl':function(_0x19cd5b,_0x1a742c){return _0x19cd5b/_0x1a742c;},'DxGAb':function(_0xe479a,_0x46ae2b){return _0xe479a/_0x46ae2b;},'IAKKA':function(_0x587e45,_0x57901e){return _0x587e45-_0x57901e;},'UXbNf':function(_0x57c312,_0x11c96e){return _0x57c312-_0x11c96e;}},_0x4cbd8d=_0x1266f9[_0x2be3de(0x559)](Graphics[_0x2be3de(0x3dc)],0x2*0xf9e+0x9ad+-0x28e7),_0x58d4af=this[_0x2be3de(0xbaf)+_0x2be3de(0x1e5)](VisuMZ[_0x2be3de(0x118f)]['Settings'][_0x2be3de(0x5a2)+'ut'][_0x2be3de(0xe74)+_0x2be3de(0x722)],!![]),_0x526990=Math[_0x2be3de(0x10a1)](_0x1266f9[_0x2be3de(0x536)](_0x1266f9[_0x2be3de(0x6f9)](Graphics[_0x2be3de(0x3dc)],_0x4cbd8d),-0xd7b+-0x1*-0x248c+0x170f*-0x1)),_0x4918bb=_0x1266f9['IAKKA'](_0x1266f9['UXbNf'](Graphics['boxHeight'],_0x58d4af),this[_0x2be3de(0x617)+_0x2be3de(0x13a4)+_0x2be3de(0x1176)]()[_0x2be3de(0xa68)]);return new Rectangle(_0x526990,_0x4918bb,_0x4cbd8d,_0x58d4af);},Scene_Battle['prototype']['helpWindow'+_0xe90fac(0xb86)+'Style']=function(){const _0x1b05bd=_0xe90fac,_0x3271fa={'cvWaZ':function(_0x44be52,_0xd6ef89){return _0x44be52/_0xd6ef89;},'QrhKj':function(_0x84076b,_0x4da799){return _0x84076b-_0x4da799;}},_0x44e7c3=Graphics[_0x1b05bd(0x301)],_0x443993=Math[_0x1b05bd(0x10a1)](_0x3271fa[_0x1b05bd(0xaf)](_0x3271fa['QrhKj'](Graphics['boxWidth'],_0x44e7c3),-0x1748+0x1229+0x521)),_0x20f0dc=this[_0x1b05bd(0x9d6)+_0x1b05bd(0x1278)](),_0x234fad=_0x3271fa['cvWaZ'](_0x3271fa[_0x1b05bd(0xbc1)](Graphics[_0x1b05bd(0xa68)],Graphics[_0x1b05bd(0x7b7)]),-(0x8b2+0x847*0x2+-0x167*0x12));return new Rectangle(_0x443993,_0x234fad,_0x44e7c3,_0x20f0dc);},Scene_Battle[_0xe90fac(0x510)]['statusWind'+'owRectBord'+'erStyle']=function(){const _0x2e3f0e=_0xe90fac,_0x2356a7={'MCRGo':function(_0x23f47d,_0x2bdcd4){return _0x23f47d/_0x2bdcd4;},'iETYW':function(_0x197b64,_0x2ef132){return _0x197b64-_0x2ef132;},'nQoqe':function(_0x513044,_0x1b1ab7){return _0x513044+_0x1b1ab7;},'sUxXs':function(_0xb2a32d,_0x2ac486){return _0xb2a32d-_0x2ac486;},'pyjqD':function(_0xa3affa,_0xa5ca8c){return _0xa3affa/_0xa5ca8c;},'MThNY':function(_0x17912d,_0x5dc8e5){return _0x17912d-_0x5dc8e5;}},_0x11586d=Graphics[_0x2e3f0e(0x301)],_0x111aab=Math['round'](_0x2356a7['MCRGo'](_0x2356a7[_0x2e3f0e(0xa5f)](Graphics[_0x2e3f0e(0x3dc)],_0x11586d),-0x4*-0x570+-0x6a*-0x58+-0x3a2e)),_0x34202d=this['calcWindow'+'Height'](0x1*0x2115+-0x3c3+-0x2*0xea7,!![]),_0x7e9905=_0x2356a7[_0x2e3f0e(0xb55)](_0x2356a7['sUxXs'](Graphics[_0x2e3f0e(0x7b7)],_0x34202d),_0x2356a7[_0x2e3f0e(0x8b5)](_0x2356a7[_0x2e3f0e(0xa9c)](Graphics['height'],Graphics[_0x2e3f0e(0x7b7)]),0x1f77+0x1*-0x116f+-0xe06));return new Rectangle(_0x111aab,_0x7e9905,_0x11586d,_0x34202d);},Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0x550)+_0xe90fac(0x5e2)+_0xe90fac(0x83f)+_0xe90fac(0x1176)]=function(){const _0x20d856=_0xe90fac,_0x5cea3c={'WrYwt':function(_0x38dd77,_0x5aaef4){return _0x38dd77/_0x5aaef4;},'YPohu':function(_0x2c7fce,_0x8a3c88){return _0x2c7fce-_0x8a3c88;},'xzOol':function(_0x5230b7,_0x56d356){return _0x5230b7/_0x56d356;},'QAsTo':function(_0x495e75,_0x1a038a){return _0x495e75+_0x1a038a;},'rlGbo':function(_0x328faf,_0x5e90c5){return _0x328faf/_0x5e90c5;}},_0x8acbf4=Math[_0x20d856(0x12be)](_0x5cea3c[_0x20d856(0xae5)](Graphics[_0x20d856(0x301)],0x4*0x8c8+0x4a*-0x16+-0x1cc1)),_0x154229=this[_0x20d856(0xb5a)+_0x20d856(0xcb3)]()?_0x5cea3c[_0x20d856(0x4fe)](_0x5cea3c[_0x20d856(0x705)](_0x5cea3c[_0x20d856(0xb2b)](Graphics[_0x20d856(0x301)],Graphics[_0x20d856(0x3dc)]),0x1dc0+-0x1de2+0x24),_0x8acbf4):_0x5cea3c[_0x20d856(0x3c2)](_0x5cea3c[_0x20d856(0x4fe)](Graphics[_0x20d856(0x301)],Graphics['boxWidth']),-(-0x1cb5+0x3*-0x7f7+-0x5b*-0x94)),_0x1803e7=this[_0x20d856(0xc38)+_0x20d856(0xb86)+_0x20d856(0x10f9)](),_0x483a75=_0x5cea3c[_0x20d856(0xb2b)](_0x1803e7['y'],_0x1803e7[_0x20d856(0xa68)]),_0xc45643=this['statusWind'+'owRectBord'+'erStyle'](),_0x55849c=_0x5cea3c[_0x20d856(0x4fe)](_0xc45643['y'],_0x483a75);return new Rectangle(_0x154229,_0x483a75,_0x8acbf4,_0x55849c);},Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0x14f4)+_0xe90fac(0x1009)+'orderStyle']=function(){const _0x147c1d=_0xe90fac,_0x5e4424={'RyaIr':function(_0x5dcb5d,_0x30c6b9){return _0x5dcb5d/_0x30c6b9;},'gSvrf':function(_0x9db8e8,_0x497cdb){return _0x9db8e8-_0x497cdb;}},_0x531381=Math[_0x147c1d(0x964)](_0x5e4424['RyaIr'](Graphics[_0x147c1d(0x301)],0x1550+0x496+-0x19e3)),_0x4140fc=Math[_0x147c1d(0x10a1)](_0x5e4424['RyaIr'](_0x5e4424[_0x147c1d(0x97b)](Graphics[_0x147c1d(0x3dc)],_0x531381),-0x29*-0x7+0x1*-0x1bef+0x1ad2)),_0x496f20=this[_0x147c1d(0x550)+'ndWindowRe'+_0x147c1d(0x83f)+_0x147c1d(0x1176)](),_0x19cfa2=_0x496f20['y'],_0x5adeb7=_0x496f20[_0x147c1d(0xa68)];return new Rectangle(_0x4140fc,_0x19cfa2,_0x531381,_0x5adeb7);},Scene_Battle['prototype'][_0xe90fac(0xb09)+_0xe90fac(0x23c)+_0xe90fac(0xf97)+_0xe90fac(0x1176)]=function(){const _0x47f938=_0xe90fac,_0x53ce33={'uJVPY':function(_0x29acce,_0x348088){return _0x29acce+_0x348088;},'HssVJ':function(_0xfe7e02,_0x1d303f){return _0xfe7e02===_0x1d303f;},'RinZA':_0x47f938(0xea1),'hVGLl':function(_0x140309,_0xd806c3){return _0x140309-_0xd806c3;},'hnKLH':function(_0xda3a20,_0x9a7bcf){return _0xda3a20-_0x9a7bcf;},'KLxrM':function(_0x138248,_0x18c276){return _0x138248-_0x18c276;},'MdWjI':function(_0x43091b,_0x5340d4){return _0x43091b/_0x5340d4;}};this[_0x47f938(0x1082)+_0x47f938(0x15bc)]['y']=_0x53ce33[_0x47f938(0x85c)](this[_0x47f938(0x507)+'w']['y'],this['_helpWindo'+'w'][_0x47f938(0xa68)]),this[_0x47f938(0xb5a)+_0x47f938(0xcb3)]()?_0x53ce33[_0x47f938(0x3e0)](this[_0x47f938(0x3a1)+_0x47f938(0x15fa)](),_0x53ce33[_0x47f938(0xbc4)])?this[_0x47f938(0x1082)+_0x47f938(0x15bc)]['x']=0x1479+0x1*-0x9d3+-0xa9e:this[_0x47f938(0x1082)+_0x47f938(0x15bc)]['x']=_0x53ce33[_0x47f938(0x407)](-this[_0x47f938(0x1082)+_0x47f938(0x15bc)]['width'],-0x1e7+-0x841+0xa2c):this[_0x47f938(0x1082)+_0x47f938(0x15bc)]['x']=_0x53ce33[_0x47f938(0x96e)](_0x53ce33[_0x47f938(0x96e)](_0x53ce33[_0x47f938(0x5b8)](Graphics[_0x47f938(0x301)],_0x53ce33[_0x47f938(0x99c)](_0x53ce33[_0x47f938(0x407)](Graphics[_0x47f938(0x301)],Graphics[_0x47f938(0x3dc)]),0x2*0xef2+-0x2+0x3bc*-0x8)),this[_0x47f938(0x1082)+_0x47f938(0x15bc)][_0x47f938(0x301)]),0x794+-0x1a*0x26+-0x3b4);},VisuMZ[_0xe90fac(0x118f)]['Scene_Batt'+_0xe90fac(0x2a4)+_0xe90fac(0x2cd)]=Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0x1293)+'wRect'],Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0x1293)+_0xe90fac(0x144)]=function(){const _0x33c497=_0xe90fac,_0x1abe12={'uAJOp':function(_0x39eb40,_0x312e4d){return _0x39eb40===_0x312e4d;},'WDLEV':_0x33c497(0xea1)};if(_0x1abe12[_0x33c497(0x1554)](this[_0x33c497(0x3a1)+'utStyle'](),_0x1abe12[_0x33c497(0x159f)]))return this[_0x33c497(0x14f4)+_0x33c497(0x1009)+_0x33c497(0x14fb)]();else return this[_0x33c497(0x12a2)+_0x33c497(0xf7b)+_0x33c497(0x5d8)]()?this[_0x33c497(0x14f4)+'indowRectM'+_0x33c497(0x9fd)]():VisuMZ[_0x33c497(0x118f)]['Scene_Batt'+_0x33c497(0x2a4)+_0x33c497(0x2cd)][_0x33c497(0x351)](this);},VisuMZ[_0xe90fac(0x118f)]['Scene_Batt'+_0xe90fac(0x1d6)+_0xe90fac(0xc59)]=Scene_Battle['prototype'][_0xe90fac(0x795)+_0xe90fac(0x13d6)],Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0x795)+'Rect']=function(){const _0x2d063e=_0xe90fac,_0x5c5909={'uZLmM':function(_0x24c989,_0x1c7ee6){return _0x24c989===_0x1c7ee6;},'ISnXg':_0x2d063e(0xea1)};if(_0x5c5909[_0x2d063e(0x4d7)](this[_0x2d063e(0x3a1)+_0x2d063e(0x15fa)](),_0x5c5909[_0x2d063e(0x14ba)]))return this[_0x2d063e(0x14f4)+_0x2d063e(0x1009)+_0x2d063e(0x14fb)]();else return this['isSkillIte'+_0x2d063e(0xf7b)+_0x2d063e(0x5d8)]()?this[_0x2d063e(0x14f4)+_0x2d063e(0x1b8)+_0x2d063e(0x9fd)]():VisuMZ[_0x2d063e(0x118f)][_0x2d063e(0x152d)+_0x2d063e(0x1d6)+'dowRect']['call'](this);},Scene_Battle[_0xe90fac(0x510)][_0xe90fac(0x12a2)+'mWindowsMi'+_0xe90fac(0x5d8)]=function(){const _0x2b4817=_0xe90fac;return VisuMZ[_0x2b4817(0x118f)][_0x2b4817(0x281)][_0x2b4817(0x5a2)+'ut']['SkillItemM'+_0x2b4817(0x91c)+'t'];},Scene_Battle[_0xe90fac(0x510)]['skillItemW'+_0xe90fac(0x1b8)+'iddle']=function(){const _0x160e81=_0xe90fac,_0x2eddb8={'TFxzA':function(_0x582c07,_0x52ab4f){return _0x582c07+_0x52ab4f;},'RnvFI':function(_0xbacd6c,_0x385c1f){return _0xbacd6c*_0x385c1f;},'twoZW':function(_0x30f130,_0x72b46c){return _0x30f130-_0x72b46c;},'LCnsx':function(_0x2fb766,_0xa4c22d){return _0x2fb766+_0xa4c22d;},'nbSWK':function(_0x613955,_0x3c25cb){return _0x613955-_0x3c25cb;}},_0x37b1ca=_0x2eddb8[_0x160e81(0x7ed)](_0x2eddb8['RnvFI'](Sprite_Button[_0x160e81(0x510)]['blockWidth'](),-0x1a8*-0xb+-0x7bb+-0xa7b*0x1),0x56d+-0x33f+-0x22a);let _0xe75822=_0x2eddb8[_0x160e81(0x31b)](Graphics[_0x160e81(0x3dc)],_0x37b1ca);Imported['VisuMZ_0_C'+_0x160e81(0x100d)]&&SceneManager[_0x160e81(0x9ac)+'onLayout']()&&(_0xe75822+=_0x37b1ca);const _0x4fbe03=this[_0x160e81(0xbf1)+'ttom'](),_0x9c85e3=_0x2eddb8['LCnsx'](_0x2eddb8[_0x160e81(0x31b)](_0x2eddb8[_0x160e81(0xfc3)](Graphics['boxHeight'],_0x4fbe03),this[_0x160e81(0x617)+_0x160e81(0x88f)]()[_0x160e81(0xa68)]),Window_BattleStatus[_0x160e81(0x510)][_0x160e81(0xb95)+'t']()),_0x49322e=0x1485+0x21df+-0x3664;return new Rectangle(_0x49322e,_0x4fbe03,_0xe75822,_0x9c85e3);},Scene_Battle['prototype'][_0xe90fac(0xc63)+_0xe90fac(0xa2d)+_0xe90fac(0x1350)]=function(){const _0x2121c5=_0xe90fac,_0x3a8bc7={'Xoqqm':function(_0x40bd61,_0x576734){return _0x40bd61<_0x576734;}};if(!VisuMZ[_0x2121c5(0x118f)][_0x2121c5(0x281)]['Enemy'][_0x2121c5(0x80f)])return;this[_0x2121c5(0x1564)+_0x2121c5(0x1325)]=new Sprite(),this[_0x2121c5(0x1564)+_0x2121c5(0x1325)]['x']=this[_0x2121c5(0x1487)+'er']['x'],this[_0x2121c5(0x1564)+_0x2121c5(0x1325)]['y']=this[_0x2121c5(0x1487)+'er']['y'];const _0x1a94c3=this[_0x2121c5(0x728)][_0x2121c5(0x741)](this['_windowLay'+'er']);this['addChildAt'](this[_0x2121c5(0x1564)+_0x2121c5(0x1325)],_0x1a94c3);for(let _0x3de4a8=0x1*0x2285+0x1e*-0x119+0xb*-0x25;_0x3a8bc7[_0x2121c5(0x34f)](_0x3de4a8,0x1321+0xdd5+-0x20ee);_0x3de4a8++){const _0x523092=new Window_EnemyName(_0x3de4a8);this['_enemyName'+_0x2121c5(0x1325)][_0x2121c5(0xda3)](_0x523092);}},Sprite_Battler[_0xe90fac(0x1597)+'ed']=VisuMZ[_0xe90fac(0x118f)]['Settings']['Actor'][_0xe90fac(0x1557)+'d'],VisuMZ['BattleCore'][_0xe90fac(0x5bd)+_0xe90fac(0x263)+'embers']=Sprite_Battler['prototype'][_0xe90fac(0x11d5)+'s'],Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0x11d5)+'s']=function(){const _0x16058d=_0xe90fac,_0x1ca06b={'rMQAx':function(_0x1045cc,_0x563e45){return _0x1045cc===_0x563e45;}};VisuMZ[_0x16058d(0x118f)][_0x16058d(0x5bd)+_0x16058d(0x263)+_0x16058d(0xcdb)][_0x16058d(0x351)](this),this['initMember'+_0x16058d(0xf2e)+'e']();if(_0x1ca06b['rMQAx'](this[_0x16058d(0x14c0)+'r'],Sprite_Enemy))this[_0x16058d(0x9e2)+'owSprite']();this[_0x16058d(0xe68)+_0x16058d(0xaf4)+'te']();},Sprite_Battler['prototype'][_0xe90fac(0x11d5)+_0xe90fac(0xf2e)+'e']=function(){const _0x4d2ca8=_0xe90fac,_0x39c720={'YiFWc':_0x4d2ca8(0xac3)+'6|35|27|19'+'|33|41|42|'+'23|29|31|2'+_0x4d2ca8(0x138)+_0x4d2ca8(0x449)+_0x4d2ca8(0x993)+'26|11|1|34'+'|21|14|32|'+_0x4d2ca8(0x12a9)+_0x4d2ca8(0x34c)+_0x4d2ca8(0x530),'CWmJV':_0x4d2ca8(0x44a)},_0x5daeb3=_0x39c720[_0x4d2ca8(0xded)][_0x4d2ca8(0xab1)]('|');let _0x314002=0x851+-0x1bfb+-0x6*-0x347;while(!![]){switch(_0x5daeb3[_0x314002++]){case'0':this[_0x4d2ca8(0x5a3)+_0x4d2ca8(0x128b)]=!![];continue;case'1':this[_0x4d2ca8(0xac4)+'g']=_0x39c720[_0x4d2ca8(0xe25)];continue;case'2':this[_0x4d2ca8(0x13e3)+'ion']=-0xa9f+-0x211*0x11+0x2dc0;continue;case'3':this[_0x4d2ca8(0x156)]=0x24e1+-0x15*0x138+0x3*-0x3c3;continue;case'4':this[_0x4d2ca8(0x253)+_0x4d2ca8(0x825)]=0x3*-0x5af+-0x29*0x9a+0x29b7;continue;case'5':this['_currentAn'+_0x4d2ca8(0x9b5)]=-0xd01+0x13cb+-0x6ca;continue;case'6':this['_floatHeig'+'ht']=0xf07+0x99a+-0x1*0x18a1;continue;case'7':this['_targetHom'+'eY']=-0x2ef+0x63d*0x6+-0x1*0x227f;continue;case'8':this['_baseY']=0x1*-0x3ee+-0xb*0x2a1+0xaf3*0x3;continue;case'9':this[_0x4d2ca8(0x388)+'X']=-0x1*-0xa56+0x1*-0x11c0+-0xd3*-0x9;continue;case'10':this[_0x4d2ca8(0x11d6)+_0x4d2ca8(0x130a)]=0x16ba+0x5*0x358+-0x2772;continue;case'11':this[_0x4d2ca8(0x11a9)+_0x4d2ca8(0x825)]=0x1e1f*0x1+0x17ad+0x272*-0x16;continue;case'12':this['_targetSke'+'wX']=0x20ee+-0x529*-0x3+-0x3069;continue;case'13':this[_0x4d2ca8(0xe63)+'ng']=_0x39c720[_0x4d2ca8(0xe25)];continue;case'14':this[_0x4d2ca8(0x32a)+'wX']=-0x14e3*0x1+-0x4bc+0x19a0;continue;case'15':this[_0x4d2ca8(0xec7)]=-0x9c8+-0x2548+0x18*0x1f6;continue;case'16':this[_0x4d2ca8(0x109f)+'tion']=-0x1*-0x75e+0xfb3+0x5*-0x49d;continue;case'17':this['_targetSke'+'wY']=0x1179+-0x19b*-0xf+-0x298e;continue;case'18':this[_0x4d2ca8(0x6b2)+'g']=_0x39c720[_0x4d2ca8(0xe25)];continue;case'19':this['_jumpHeigh'+'t']=-0x22f1+-0x1*0x14d5+0x16*0x289;continue;case'20':this[_0x4d2ca8(0xa40)+_0x4d2ca8(0xd7c)]=_0x39c720['CWmJV'];continue;case'21':this[_0x4d2ca8(0x90f)]=-0x3*0x2af+-0x20c+-0x3*-0x35e;continue;case'22':this[_0x4d2ca8(0xe5a)+'le']=-0x746+-0x1ec0+0x2606;continue;case'23':this[_0x4d2ca8(0x1136)+_0x4d2ca8(0x442)]=-0x24f*-0x4+0x1*0x67e+-0xebb;continue;case'24':this[_0x4d2ca8(0x21d)+'Duration']=0x686+0x154*-0x11+-0xf*-0x112;continue;case'25':this['_shakeFlin'+_0x4d2ca8(0x1039)]=-0x1*-0x1d69+0x219b+-0x3f04;continue;case'26':this[_0x4d2ca8(0x837)+_0x4d2ca8(0x130a)]=0x212b+0x23e0+-0x450b;continue;case'27':this[_0x4d2ca8(0x4e4)+'ng']=_0x39c720['CWmJV'];continue;case'28':this[_0x4d2ca8(0x151d)+'eX']=0x90c+0x17*0xa3+-0x1*0x17b1;continue;case'29':this[_0x4d2ca8(0x490)+_0x4d2ca8(0x796)]=-0x16e8+0x100f*-0x1+0x1*0x26f7;continue;case'30':this[_0x4d2ca8(0x13d9)+'g']=_0x39c720[_0x4d2ca8(0xe25)];continue;case'31':this[_0x4d2ca8(0x15a5)+_0x4d2ca8(0x1005)+'n']=0x515+-0x187*0x3+-0x80;continue;case'32':this[_0x4d2ca8(0x32a)+'wY']=0x534*-0x5+0x844+0x11c1;continue;case'33':this[_0x4d2ca8(0x124e)+'ight']=0x1d2*-0x14+-0x1*-0x1b52+0x2*0x48b;continue;case'34':this[_0x4d2ca8(0x11f)]=0xa30+0x1eb3*0x1+-0x28e2*0x1;continue;case'35':this[_0x4d2ca8(0x1490)+_0x4d2ca8(0x7e8)]=-0x7*0x35+-0x786+0x8f9*0x1;continue;case'36':this['_shakeFlin'+_0x4d2ca8(0x8fb)]=0x1*-0xd9f+-0x9eb+0x178a;continue;case'37':this[_0x4d2ca8(0x1517)]=-0x836+-0x176f*0x1+0x1fa5;continue;case'38':this[_0x4d2ca8(0x1402)+_0x4d2ca8(0xbcd)]=-0x6fa+0x1ef8+0x17fe*-0x1;continue;case'39':this[_0x4d2ca8(0xdee)+_0x4d2ca8(0x1580)]=0x2004+-0x1c51*0x1+-0x1*0x3b3;continue;case'40':this[_0x4d2ca8(0x11e2)+_0x4d2ca8(0x7e8)]=0x9d4+-0xf5a+0x586;continue;case'41':this[_0x4d2ca8(0x1276)+_0x4d2ca8(0x130a)]=-0x1398*0x1+-0xffe+0x2396;continue;case'42':this['_jumpWhole'+_0x4d2ca8(0x825)]=-0x21dd+0x6d2+0x1b0b;continue;}break;}},Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0x9e2)+_0xe90fac(0xa2e)]=function(){const _0x2c8eeb=_0xe90fac,_0x4173e8={'AnfoV':'4|0|6|1|3|'+_0x2c8eeb(0x159d),'Tgasx':_0x2c8eeb(0xb6b)},_0x159d59=_0x4173e8[_0x2c8eeb(0x1398)][_0x2c8eeb(0xab1)]('|');let _0x5d014b=-0x11e*0x10+-0x1697+0x2877;while(!![]){switch(_0x159d59[_0x5d014b++]){case'0':this[_0x2c8eeb(0x93f)+_0x2c8eeb(0xdf4)]['bitmap']=ImageManager[_0x2c8eeb(0xb8)](_0x4173e8[_0x2c8eeb(0x1447)]);continue;case'1':this[_0x2c8eeb(0x93f)+_0x2c8eeb(0xdf4)][_0x2c8eeb(0x11c2)]['x']=-0xa9e+0xc24+-0x186+0.5;continue;case'2':this[_0x2c8eeb(0xda3)](this[_0x2c8eeb(0x93f)+_0x2c8eeb(0xdf4)]);continue;case'3':this[_0x2c8eeb(0x93f)+_0x2c8eeb(0xdf4)][_0x2c8eeb(0x11c2)]['y']=0x1f57+-0xfc4+-0xf93+0.5;continue;case'4':this[_0x2c8eeb(0x93f)+'ite']=new Sprite();continue;case'5':this[_0x2c8eeb(0x93f)+_0x2c8eeb(0xdf4)]['visible']=![];continue;case'6':this['_shadowSpr'+_0x2c8eeb(0xdf4)][_0x2c8eeb(0x24c)][_0x2c8eeb(0xb1f)]=VisuMZ['BattleCore']['Settings'][_0x2c8eeb(0xd11)][_0x2c8eeb(0x8a1)+'e'];continue;case'7':this[_0x2c8eeb(0x93f)+_0x2c8eeb(0xdf4)]['y']=-(-0x502+0x7c2+-0x2be);continue;}break;}},Sprite_Battler['prototype'][_0xe90fac(0xe68)+'ortionSpri'+'te']=function(){const _0x566e2e=_0xe90fac;this[_0x566e2e(0x174)+'nSprite']=new Sprite(),this[_0x566e2e(0x174)+'nSprite'][_0x566e2e(0x11c2)]['x']=0x605*-0x3+0x1017+0x1f8+0.5,this[_0x566e2e(0x174)+_0x566e2e(0x94e)]['anchor']['y']=-0xb4e+-0x2*-0x79+-0x44*-0x27+0.5,this[_0x566e2e(0xda3)](this[_0x566e2e(0x174)+_0x566e2e(0x94e)]);},Sprite_Battler['prototype'][_0xe90fac(0xe86)+_0xe90fac(0x66f)]=function(){const _0x8bb859=_0xe90fac;if(this['getDragonb'+_0x8bb859(0x786)]&&this['getDragonb'+'ones']()){Sprite['prototype'][_0x8bb859(0xe86)+_0x8bb859(0x66f)]['call'](this);return;}const _0x181ab3=this[_0x8bb859(0x174)+_0x8bb859(0x94e)];if(!_0x181ab3)return;!_0x181ab3['_colorFilt'+'er']&&_0x181ab3['_createCol'+'orFilter'](),_0x181ab3[_0x8bb859(0x61a)+'er'][_0x8bb859(0x1124)](this['_hue']),_0x181ab3[_0x8bb859(0x61a)+'er']['setBlendCo'+'lor'](this[_0x8bb859(0xf71)+'r']),_0x181ab3[_0x8bb859(0x61a)+'er']['setColorTo'+'ne'](this[_0x8bb859(0x582)]);},Sprite_Battler['prototype'][_0xe90fac(0x15c1)+_0xe90fac(0x73d)+_0xe90fac(0xebd)+'e']=function(){const _0x2546fb=_0xe90fac;if(!this[_0x2546fb(0x174)+_0x2546fb(0x94e)])return;if(this[_0x2546fb(0x93f)+_0x2546fb(0xdf4)]){const _0xd2a2a1=this[_0x2546fb(0xfe)+_0x2546fb(0x1227)](this[_0x2546fb(0x174)+_0x2546fb(0x94e)]);this[_0x2546fb(0x9d5)](this[_0x2546fb(0x93f)+'ite'],_0xd2a2a1),this['updateShad'+_0x2546fb(0x12f7)+'ty']();}this['_svBattler'+_0x2546fb(0x15e6)]&&this[_0x2546fb(0x174)+_0x2546fb(0x94e)]['addChild'](this['_svBattler'+'Sprite']),this[_0x2546fb(0x79d)+_0x2546fb(0xdf4)]&&this[_0x2546fb(0x174)+_0x2546fb(0x94e)][_0x2546fb(0xda3)](this[_0x2546fb(0x79d)+_0x2546fb(0xdf4)]),this['_mainSprit'+'e']&&this[_0x2546fb(0x174)+'nSprite']['addChild'](this[_0x2546fb(0x8d1)+'e']),this[_0x2546fb(0xa8f)+_0x2546fb(0x10e1)+'te']&&this[_0x2546fb(0x174)+_0x2546fb(0x94e)]['addChild'](this[_0x2546fb(0xa8f)+'mationSpri'+'te']),this[_0x2546fb(0x8a8)+_0x2546fb(0x66c)+_0x2546fb(0xb05)]&&this[_0x2546fb(0x174)+_0x2546fb(0x94e)]['addChild'](this['_dragonbon'+_0x2546fb(0x66c)+_0x2546fb(0xb05)]);},Sprite_Battler['prototype'][_0xe90fac(0xa52)+'owVisibili'+'ty']=function(){const _0x4108ae=_0xe90fac;if(!this['_shadowSpr'+'ite'])return;if(this[_0x4108ae(0xbb8)]&&this[_0x4108ae(0xbb8)][_0x4108ae(0xa25)+_0x4108ae(0x1607)+'le']()){const _0x294d27=this['_shadowSpr'+_0x4108ae(0xdf4)][_0x4108ae(0x24c)];this[_0x4108ae(0x93f)+_0x4108ae(0xdf4)]['setFrame'](0x12f4+-0x57d*-0x1+-0x1871,-0x1d50+0x1e3f+-0xef,_0x294d27[_0x4108ae(0x301)],_0x294d27['height']);}else this['_shadowSpr'+_0x4108ae(0xdf4)][_0x4108ae(0xf6)](-0x1672+-0x6f8+0x1d6a,-0x3cf+0xd1*0x27+0x4ac*-0x6,-0x6*0x2+0xeca*0x1+-0xebe,-0x1339+-0x13aa+0x1*0x26e3);},Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0x1c2)+_0xe90fac(0x397)]=function(){const _0x26796f=_0xe90fac;return SceneManager[_0x26796f(0x11be)+'tle']()?SceneManager['_scene']['_spriteset'][_0x26796f(0x158)+_0x26796f(0x257)]:this['parent'];},Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0x866)+_0xe90fac(0x1f9)]=function(_0x1f2f71,_0x54fb8c){const _0x4dc0e1=_0xe90fac;if(!this['_battler'][_0x4dc0e1(0x147c)+_0x4dc0e1(0x527)]())return;if(BattleManager[_0x4dc0e1(0x8bd)+_0x4dc0e1(0x8f6)+_0x4dc0e1(0x12fb)]())return;const _0x159e9c=VisuMZ[_0x4dc0e1(0x118f)][_0x4dc0e1(0x281)][_0x4dc0e1(0x7d7)],_0x5abe15=new Sprite_Damage();_0x5abe15[_0x4dc0e1(0x1102)]=_0x159e9c[_0x4dc0e1(0xb57)+_0x4dc0e1(0x130a)],this[_0x4dc0e1(0x10c6)+_0x4dc0e1(0xdf8)](_0x5abe15),_0x5abe15['setupTextP'+_0x4dc0e1(0x1f9)](_0x1f2f71,_0x54fb8c),this[_0x4dc0e1(0x5fe)+_0x4dc0e1(0x118)](_0x5abe15);},Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0x2ee)+_0xe90fac(0xc7)]=function(_0x4f0291,_0x3fb5d4,_0x5cdef3){const _0x2ccd07=_0xe90fac;if(!this[_0x2ccd07(0xbb8)]['isSpriteVi'+'sible']())return;if(BattleManager[_0x2ccd07(0x8bd)+_0x2ccd07(0x8f6)+'opups']())return;const _0x2cddf2=VisuMZ[_0x2ccd07(0x118f)][_0x2ccd07(0x281)]['Damage'],_0x41af28=new Sprite_Damage();_0x41af28[_0x2ccd07(0x1102)]=_0x2cddf2[_0x2ccd07(0xb57)+'ion'],this[_0x2ccd07(0x10c6)+_0x2ccd07(0xdf8)](_0x41af28),_0x41af28[_0x2ccd07(0x2ee)+_0x2ccd07(0xc7)](_0x4f0291,_0x3fb5d4,_0x5cdef3),this[_0x2ccd07(0x5fe)+_0x2ccd07(0x118)](_0x41af28);},Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0x416)+_0xe90fac(0xeeb)]=function(){const _0x57f1cf=_0xe90fac;if(!this[_0x57f1cf(0xbb8)][_0x57f1cf(0xc6e)+_0x57f1cf(0x1477)+'ed']())return;while(this[_0x57f1cf(0xbb8)][_0x57f1cf(0xc6e)+'pupRequest'+'ed']()){this[_0x57f1cf(0xbb8)][_0x57f1cf(0x147c)+'sible']()&&this[_0x57f1cf(0xcc3)+'geSprite']();}this[_0x57f1cf(0xbb8)][_0x57f1cf(0x142e)+'ePopup'](),this[_0x57f1cf(0xbb8)][_0x57f1cf(0x8c0)+'t']();},Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0xcc3)+'geSprite']=function(){const _0x1796d8=_0xe90fac;if(BattleManager['shouldHide'+'BattleEndP'+_0x1796d8(0x12fb)]())return;const _0x19ab4e=VisuMZ[_0x1796d8(0x118f)][_0x1796d8(0x281)][_0x1796d8(0x7d7)],_0x2fa33f=new Sprite_Damage();_0x2fa33f[_0x1796d8(0x1102)]=_0x19ab4e['PopupDurat'+'ion'],this['sortDamage'+_0x1796d8(0xdf8)](_0x2fa33f),_0x2fa33f[_0x1796d8(0xc70)](this[_0x1796d8(0xbb8)]),_0x2fa33f[_0x1796d8(0x15e2)+_0x1796d8(0x1287)](this[_0x1796d8(0xbb8)]),this[_0x1796d8(0x5fe)+_0x1796d8(0x118)](_0x2fa33f);},Sprite_Battler['prototype'][_0xe90fac(0x5fe)+_0xe90fac(0x118)]=function(_0xbba17e){const _0x16cd23=_0xe90fac;this['_damages'][_0x16cd23(0x15f1)](_0xbba17e);if(this[_0x16cd23(0x781)+'attlePortr'+_0x16cd23(0x45a)]()){const _0xca5b71=SceneManager[_0x16cd23(0x11dd)][_0x16cd23(0xbed)+'dow'];if(_0xca5b71)_0xca5b71[_0x16cd23(0x5fe)+_0x16cd23(0x118)](_0xbba17e,this['_battler']);}else{this[_0x16cd23(0x1c2)+'ainer']()[_0x16cd23(0xda3)](_0xbba17e);if(SceneManager['isBattleFl'+'ipped']())_0xbba17e[_0x16cd23(0xe61)]['x']=-(0xc*0x82+-0x77*0x16+0x423);}},Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0x781)+_0xe90fac(0x32c)+_0xe90fac(0x45a)]=function(){const _0x2ed016=_0xe90fac,_0x1a888f={'NbRLj':function(_0x4b3818,_0x101a00){return _0x4b3818===_0x101a00;},'qgYip':_0x2ed016(0x142b)};return!$gameSystem[_0x2ed016(0x53d)]()&&this[_0x2ed016(0xbb8)]&&this['_battler'][_0x2ed016(0xd83)]();return!$gameSystem[_0x2ed016(0x53d)]()&&this[_0x2ed016(0xbb8)]&&this[_0x2ed016(0xbb8)][_0x2ed016(0xd83)]()&&_0x1a888f[_0x2ed016(0x1492)](Window_BattleStatus[_0x2ed016(0x510)]['battleLayo'+'utStyle'](),_0x1a888f['qgYip']);},Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0x10c6)+_0xe90fac(0xdf8)]=function(_0x581d8d){const _0x38ff4f=_0xe90fac,_0x10264c={'AuZad':function(_0x5aa7a8,_0x166282){return _0x5aa7a8*_0x166282;},'JRcvF':function(_0x2a7706,_0x1d52d6){return _0x2a7706-_0x1d52d6;},'WvdFA':function(_0xf6554,_0x38bbcb){return _0xf6554+_0x38bbcb;},'FTraV':function(_0x21aaaa,_0x15447e){return _0x21aaaa*_0x15447e;},'QToEw':function(_0x37d091,_0x4c1aa5){return _0x37d091+_0x4c1aa5;}};this[_0x38ff4f(0x121d)+_0x38ff4f(0xb47)+_0x38ff4f(0x15a9)](_0x581d8d,!![]);const _0x4c6b83=VisuMZ[_0x38ff4f(0x118f)]['Settings'][_0x38ff4f(0x7d7)],_0x48f73b=SceneManager[_0x38ff4f(0x333)+_0x38ff4f(0xe11)]()?-(0x16b6*-0x1+-0x1481*0x1+-0x159c*-0x2):0x21c3+0x1090+-0x3252;if(_0x4c6b83[_0x38ff4f(0x10d0)+_0x38ff4f(0x120c)])for(const _0x408562 of this['_damages']){_0x408562['x']+=_0x10264c[_0x38ff4f(0xcbb)](_0x4c6b83[_0x38ff4f(0x1444)+'X'],_0x48f73b),_0x408562['y']+=_0x4c6b83['PopupShift'+'Y'];}else{const _0x34e558=this[_0x38ff4f(0x47d)][_0x10264c[_0x38ff4f(0x4c3)](this['_damages']['length'],0x5ee+-0x5f2+0x5)];_0x34e558&&(_0x581d8d['x']=_0x10264c[_0x38ff4f(0xac7)](_0x34e558['x'],_0x10264c['FTraV'](_0x4c6b83[_0x38ff4f(0x1444)+'X'],_0x48f73b)),_0x581d8d['y']=_0x10264c[_0x38ff4f(0x127a)](_0x34e558['y'],_0x4c6b83['PopupShift'+'Y']));}},Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0x121d)+_0xe90fac(0xb47)+'eSprite']=function(_0x1ec9c8,_0x2d189c){const _0x274293=_0xe90fac,_0xc78b29={'adlSv':function(_0xbb35c2,_0x134396){return _0xbb35c2===_0x134396;},'rywvq':function(_0x3a9bdc,_0x5488b4){return _0x3a9bdc-_0x5488b4;},'ZIDQk':function(_0x2edfd3,_0x620a5a){return _0x2edfd3/_0x620a5a;},'jJEjt':function(_0x20cbc0,_0x5a60e0){return _0x20cbc0*_0x5a60e0;},'otVmz':function(_0x175504,_0x4f4b88){return _0x175504+_0x4f4b88;},'PyYWD':function(_0x314038,_0x394a02){return _0x314038+_0x394a02;},'tSEfn':function(_0x3a1018,_0x30722f){return _0x3a1018-_0x30722f;},'BZaNR':function(_0x516bca,_0x491612){return _0x516bca*_0x491612;},'ZwKRx':function(_0xd59891,_0x301caa){return _0xd59891+_0x301caa;}},_0xd79c50=SceneManager[_0x274293(0x333)+'ipped']()?-(-0x369*0x4+0x875*-0x3+-0x38c*-0xb):0x2*0x6e3+-0x1*-0x2239+-0x2ffe;let _0x31b8bd=this['_baseX'];_0x31b8bd+=this[_0x274293(0x945)+_0x274293(0xb28)]();let _0xd9a3ff=this[_0x274293(0x1098)];const _0x389d25=this[_0x274293(0x174)+_0x274293(0x94e)][_0x274293(0xe61)]['y'];_0xd9a3ff+=this['extraPosit'+_0x274293(0x7a2)]();const _0x230ad5=SceneManager[_0x274293(0x11dd)][_0x274293(0xbed)+'dow'];if(_0x230ad5&&_0xc78b29[_0x274293(0x8ee)](this['parent'],_0x230ad5)){_0x31b8bd+=_0xc78b29[_0x274293(0xc48)](_0x230ad5['x'],this['damageOffs'+_0x274293(0xe6)]());const _0x21ce1c=_0xc78b29['ZIDQk'](_0xc78b29[_0x274293(0x1478)](_0x230ad5[_0x274293(0xf4b)](),-0x5*0x28f+0xd*-0xbf+0x1681),-0x22fa*0x1+0x3*-0x6cb+-0x7e9*-0x7);_0xd9a3ff=_0xc78b29[_0x274293(0x565)](_0x230ad5['y'],_0x21ce1c),_0xd9a3ff=Math[_0x274293(0xeed)](_0xd9a3ff,_0xc78b29[_0x274293(0xce3)](_0xc78b29[_0x274293(0xd39)](_0xc78b29[_0x274293(0x565)](_0x230ad5['y'],this['y']),this[_0x274293(0xa68)]),_0x21ce1c));}_0x1ec9c8['x']=Math[_0x274293(0x10a1)](_0xc78b29[_0x274293(0xce3)](_0x31b8bd,_0xc78b29[_0x274293(0xcff)](this[_0x274293(0x15eb)+_0x274293(0xe6)](),_0xd79c50))),_0x1ec9c8['y']=Math[_0x274293(0x10a1)](_0xc78b29[_0x274293(0x21a)](_0xd9a3ff,this['damageOffs'+_0x274293(0x65b)]()));},VisuMZ[_0xe90fac(0x118f)]['Sprite_Bat'+_0xe90fac(0x666)+_0xe90fac(0x15f2)]=Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0x15eb)+_0xe90fac(0xe6)],Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0x15eb)+_0xe90fac(0xe6)]=function(){const _0x28a628=_0xe90fac,_0x46dff3={'LtJPV':function(_0x2246d7,_0x8d3d5f){return _0x2246d7+_0x8d3d5f;}};let _0x4706b1=VisuMZ[_0x28a628(0x118f)]['Sprite_Bat'+_0x28a628(0x666)+'eOffsetX'][_0x28a628(0x351)](this),_0x1fa918=VisuMZ[_0x28a628(0x118f)]['Settings'][_0x28a628(0x7d7)][_0x28a628(0x5f0)+'tX']||-0xc45+0x13be+-0x779;return Math['round'](_0x46dff3[_0x28a628(0x698)](_0x4706b1,_0x1fa918));},VisuMZ['BattleCore'][_0xe90fac(0x5bd)+_0xe90fac(0x666)+_0xe90fac(0x15dc)]=Sprite_Battler[_0xe90fac(0x510)]['damageOffs'+_0xe90fac(0x65b)],Sprite_Battler['prototype']['damageOffs'+_0xe90fac(0x65b)]=function(){const _0xbe88af=_0xe90fac,_0x36acf5={'Jbbps':'head','mNAqM':function(_0x6e2009,_0x451af0){return _0x6e2009*_0x451af0;},'aaMOu':_0xbe88af(0x8dd),'IafcS':function(_0x5409da,_0x321d0b){return _0x5409da*_0x321d0b;},'yHZJt':function(_0x2dd80c,_0x5ce28d){return _0x2dd80c*_0x5ce28d;},'EYInd':function(_0x5c80d8,_0x3179eb){return _0x5c80d8+_0x3179eb;}};let _0x1b25fd=VisuMZ[_0xbe88af(0x118f)][_0xbe88af(0x5bd)+_0xbe88af(0x666)+_0xbe88af(0x15dc)][_0xbe88af(0x351)](this);switch(VisuMZ[_0xbe88af(0x118f)][_0xbe88af(0x281)]['Damage'][_0xbe88af(0xc90)+'ion']){case _0x36acf5[_0xbe88af(0x5d7)]:_0x1b25fd-=_0x36acf5[_0xbe88af(0x1326)](this[_0xbe88af(0xa68)],this['scale']['y']);break;case _0x36acf5[_0xbe88af(0x8ec)]:_0x1b25fd-=_0x36acf5['IafcS'](_0x36acf5[_0xbe88af(0x1188)](this[_0xbe88af(0xa68)],this[_0xbe88af(0xe61)]['y']),-0x4*-0x1f1+-0x679*0x5+0x1899+0.5);break;}let _0x520a97=VisuMZ[_0xbe88af(0x118f)]['Settings']['Damage'][_0xbe88af(0x5f0)+'tY']||-0x6*0x1b6+0x1607+-0xbc3;return Math['round'](_0x36acf5[_0xbe88af(0x1c4)](_0x1b25fd,_0x520a97));},Sprite_Actor[_0xe90fac(0x510)][_0xe90fac(0x15eb)+_0xe90fac(0xe6)]=function(){const _0x4297ae=_0xe90fac;return Sprite_Battler[_0x4297ae(0x510)][_0x4297ae(0x15eb)+'etX'][_0x4297ae(0x351)](this);},Sprite_Actor[_0xe90fac(0x510)][_0xe90fac(0x15eb)+_0xe90fac(0x65b)]=function(){const _0x3f048a=_0xe90fac;return Sprite_Battler[_0x3f048a(0x510)][_0x3f048a(0x15eb)+_0x3f048a(0x65b)]['call'](this);},Sprite_Battler['prototype'][_0xe90fac(0x655)+_0xe90fac(0x35e)]=function(_0x8effa7){const _0x599ab8=_0xe90fac;this['isShownOnB'+_0x599ab8(0x32c)+'ait']()?SceneManager['_scene'][_0x599ab8(0xbed)+_0x599ab8(0x1600)][_0x599ab8(0x447)+'geSprite'](_0x8effa7):(this[_0x599ab8(0x1c2)+_0x599ab8(0x397)]()[_0x599ab8(0xf46)+'d'](_0x8effa7),this[_0x599ab8(0x47d)][_0x599ab8(0x8a4)](_0x8effa7),_0x8effa7[_0x599ab8(0x851)]());},VisuMZ['BattleCore'][_0xe90fac(0x5bd)+_0xe90fac(0xe6f)+'me']=Sprite_Battler['prototype'][_0xe90fac(0xb7)],Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0xb7)]=function(_0x4f10c7,_0x2f0267){const _0x3a8cea=_0xe90fac,_0x2bb3f1={'JdgVw':function(_0x1e745d,_0x597db4){return _0x1e745d===_0x597db4;},'PVGiZ':function(_0x50783f,_0x40494e){return _0x50783f===_0x40494e;},'jLBYv':_0x3a8cea(0x44a)},_0x2da83c=VisuMZ['BattleCore'][_0x3a8cea(0x281)];if(_0x2bb3f1['JdgVw'](this['constructo'+'r'],Sprite_Actor))_0x4f10c7+=_0x2da83c[_0x3a8cea(0xd11)][_0x3a8cea(0x11c6)]||-0x33*0x3f+-0x6f*0xa+0x83*0x21,_0x2f0267+=_0x2da83c[_0x3a8cea(0xd11)][_0x3a8cea(0xc1e)]||0x7*0x40e+0x18ec+-0x354e;else _0x2bb3f1[_0x3a8cea(0xfd0)](this[_0x3a8cea(0x14c0)+'r'],Sprite_Enemy)&&(_0x4f10c7+=_0x2da83c['Enemy'][_0x3a8cea(0x11c6)]||0x1e2c+-0x2*-0x121a+-0x4260,_0x2f0267+=_0x2da83c[_0x3a8cea(0x105f)]['OffsetY']||-0xe41+-0x1308+-0x2149*-0x1);this[_0x3a8cea(0xbb8)]&&(_0x4f10c7=this[_0x3a8cea(0xbb8)][_0x3a8cea(0x154b)+'eX']??_0x4f10c7,_0x2f0267=this[_0x3a8cea(0xbb8)]['_forcedHom'+'eY']??_0x2f0267),VisuMZ[_0x3a8cea(0x118f)][_0x3a8cea(0x5bd)+'tler_setHo'+'me'][_0x3a8cea(0x351)](this,_0x4f10c7,_0x2f0267),this[_0x3a8cea(0x151d)+'eX']=this[_0x3a8cea(0xcc4)],this[_0x3a8cea(0x151d)+'eY']=this[_0x3a8cea(0x54e)],this['_homeDurat'+_0x3a8cea(0x130a)]=-0xd9*0x15+0xf*-0x27d+0x3720,this['_homeWhole'+'Duration']=0x23ff+-0x20b*-0x2+-0x14b*0x1f,this['_homeEasin'+'g']=_0x2bb3f1['jLBYv'];},VisuMZ[_0xe90fac(0x118f)]['Sprite_Bat'+_0xe90fac(0xce5)+'e']=Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0x94)],Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0x94)]=function(){const _0x24093d=_0xe90fac;VisuMZ[_0x24093d(0x118f)][_0x24093d(0x5bd)+_0x24093d(0xce5)+'e'][_0x24093d(0x351)](this),!this[_0x24093d(0xbb8)]&&this[_0x24093d(0x2b2)+_0x24093d(0x831)]&&(this[_0x24093d(0x2b2)+_0x24093d(0x831)][_0x24093d(0xf56)]=![]);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x5bd)+'tler_updat'+_0xe90fac(0xf07)]=Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0x12a8)],Sprite_Battler['prototype'][_0xe90fac(0x12a8)]=function(){const _0x5d4913=_0xe90fac,_0x19c370={'XmUHH':'7|2|1|6|4|'+'3|5|0','eKryw':function(_0x4b2af9,_0x5ad9ca){return _0x4b2af9===_0x5ad9ca;}},_0x111af7=_0x19c370[_0x5d4913(0x1400)][_0x5d4913(0xab1)]('|');let _0x4644e0=0x227*0x6+0x5*0x4b2+-0x2464;while(!![]){switch(_0x111af7[_0x4644e0++]){case'0':if(_0x19c370[_0x5d4913(0xb0a)](this[_0x5d4913(0x14c0)+'r'],Sprite_Enemy))this[_0x5d4913(0xa52)+'ow']();continue;case'1':this[_0x5d4913(0xf2c)]();continue;case'2':this[_0x5d4913(0x13bc)]();continue;case'3':this[_0x5d4913(0x9a2)+_0x5d4913(0x1504)+'n']();continue;case'4':VisuMZ[_0x5d4913(0x118f)]['Sprite_Bat'+'tler_updat'+_0x5d4913(0xf07)][_0x5d4913(0x351)](this);continue;case'5':this['updateShak'+_0x5d4913(0x10c8)]();continue;case'6':this[_0x5d4913(0xe81)]();continue;case'7':this[_0x5d4913(0x10f0)+'e']();continue;}break;}},VisuMZ['BattleCore'][_0xe90fac(0x5bd)+'tler_updat'+'ePosition']=Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0xe9f)+_0xe90fac(0x1580)],Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0xe9f)+_0xe90fac(0x1580)]=function(){const _0x47846d=_0xe90fac;this[_0x47846d(0x14a0)+_0x47846d(0xddd)](),VisuMZ[_0x47846d(0x118f)][_0x47846d(0x5bd)+_0x47846d(0xce5)+_0x47846d(0x95)]['call'](this),this[_0x47846d(0xe9f)+_0x47846d(0x87f)+_0x47846d(0x126e)](),this[_0x47846d(0xbde)+'ity']();},Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0x66e)+_0xe90fac(0x463)+'t']=function(){const _0x3fa193=_0xe90fac,_0x5171bf={'CNRFp':function(_0x24ac0e,_0x203da1){return _0x24ac0e<_0x203da1;},'IXZjf':function(_0x1eef8b,_0x315643){return _0x1eef8b%_0x315643;},'gCxuw':function(_0x5334c,_0x43f30f){return _0x5334c>_0x43f30f;}},_0x2205b3=this[_0x3fa193(0x4a7)]();if(this[_0x3fa193(0xbb8)][_0x3fa193(0x228)]())this[_0x3fa193(0xe37)+_0x3fa193(0x797)+'t']++,_0x5171bf[_0x3fa193(0x1046)](_0x5171bf[_0x3fa193(0xa62)](Graphics['frameCount'],-0x26fd+-0x35*0x1a+-0x65b*-0x7),-0x9f5*0x3+0x1117+0x13*0xad)?_0x2205b3['setBlendCo'+_0x3fa193(0x1380)]([0x1ed1+-0x8c9+-0x3*0x703,0x53f*-0x1+0x2431+-0x11*0x1c3,-0xbff+-0xba3+0x18a1,-0xb85*0x2+-0x134a+0x2*0x154a]):_0x2205b3[_0x3fa193(0x921)+_0x3fa193(0x1380)]([0x1f22+0x1*-0x976+-0x15ac,0x17c2+0xc07+-0x23c9,0x2d7*-0x1+0x1770+-0x1499,-0x887+0x1d78+-0x14f1]);else _0x5171bf[_0x3fa193(0xfa4)](this[_0x3fa193(0xe37)+_0x3fa193(0x797)+'t'],-0x1a35+-0xf00+0x2935)&&(this['_selection'+'EffectCoun'+'t']=0x10b4*-0x2+-0x23de+0x4546,_0x2205b3[_0x3fa193(0x921)+'lor']([-0x2a6*0x7+-0x35*-0xa0+-0x2*0x74b,0x20d0+0x1*-0x607+-0x1*0x1ac9,0x19b*-0x16+-0x1499*-0x1+0xeb9*0x1,0x43d*0x7+0x44*-0x1b+0x167f*-0x1]));},Sprite_Battler['prototype'][_0xe90fac(0x150d)+_0xe90fac(0xddd)]=function(_0x466ea4,_0x27c95e){const _0x1cb391=_0xe90fac,_0x4ea23d={'Wolsb':function(_0x5ecf15,_0x1fb943){return _0x5ecf15===_0x1fb943;},'cjzZr':function(_0x2d2007,_0x1d3a71){return _0x2d2007-_0x1d3a71;}},_0x2e86a5=VisuMZ[_0x1cb391(0x118f)][_0x1cb391(0x281)];if(_0x4ea23d[_0x1cb391(0x4dd)](this['constructo'+'r'],Sprite_Actor))_0x466ea4+=_0x2e86a5['Actor'][_0x1cb391(0x11c6)]||-0x1e85+0x2d2*-0xa+0x3ab9,_0x27c95e+=_0x2e86a5[_0x1cb391(0xd11)][_0x1cb391(0xc1e)]||0x1*0x1f5d+0x3b2+0x167*-0x19;else _0x4ea23d[_0x1cb391(0x4dd)](this[_0x1cb391(0x14c0)+'r'],Sprite_Enemy)&&(_0x466ea4+=_0x2e86a5['Enemy'][_0x1cb391(0x11c6)]||-0x9*0x409+-0x1090+0x1*0x34e1,_0x27c95e+=_0x2e86a5[_0x1cb391(0x105f)]['OffsetY']||-0x11b0+-0x1*0x19db+0x2b8b*0x1);const _0x2537d9=_0x4ea23d[_0x1cb391(0x9b)](_0x466ea4,this[_0x1cb391(0xcc4)]),_0x5724b2=_0x4ea23d[_0x1cb391(0x9b)](_0x27c95e,this[_0x1cb391(0x54e)]);this[_0x1cb391(0xcc4)]=_0x466ea4,this['_homeY']=_0x27c95e,this[_0x1cb391(0x1062)]-=_0x2537d9,this['_offsetY']-=_0x5724b2,this['_targetOff'+_0x1cb391(0x95f)]-=_0x2537d9,this['_targetOff'+_0x1cb391(0x1193)]-=_0x5724b2,this[_0x1cb391(0xe9f)+_0x1cb391(0x1580)]();},Sprite_Battler[_0xe90fac(0x510)]['startHomeM'+_0xe90fac(0xf0f)]=function(_0x3ac659,_0x4d1cd0,_0x494c72,_0x56f9b5){const _0x1489c3=_0xe90fac,_0x4713e3={'UpdiK':function(_0x171ae8,_0x2f31dc){return _0x171ae8===_0x2f31dc;},'EOeOB':function(_0x4132fe,_0x1a1e57){return _0x4132fe===_0x1a1e57;},'OCkDV':function(_0x3aa7fe,_0x15d3af){return _0x3aa7fe!==_0x15d3af;},'KwxRb':'4|1|5|3|2|'+'0','podBd':function(_0x3037cf,_0x2887bf){return _0x3037cf<=_0x2887bf;}},_0x1d7f6e=VisuMZ[_0x1489c3(0x118f)]['Settings'];if(_0x4713e3[_0x1489c3(0x956)](this[_0x1489c3(0x14c0)+'r'],Sprite_Actor))_0x3ac659+=_0x1d7f6e['Actor']['OffsetX']||0xe43*-0x1+0x29e*0x3+0x1*0x669,_0x4d1cd0+=_0x1d7f6e[_0x1489c3(0xd11)][_0x1489c3(0xc1e)]||-0xa6f*0x1+0x1177+-0x708;else _0x4713e3['EOeOB'](this[_0x1489c3(0x14c0)+'r'],Sprite_Enemy)&&(_0x3ac659+=_0x1d7f6e['Enemy'][_0x1489c3(0x11c6)]||-0x129e*0x2+-0x1*-0x4fc+0x2040,_0x4d1cd0+=_0x1d7f6e[_0x1489c3(0x105f)][_0x1489c3(0xc1e)]||0x595*-0x2+-0x641*-0x1+-0x4e9*-0x1);if(_0x4713e3[_0x1489c3(0x926)](this[_0x1489c3(0x151d)+'eX'],_0x3ac659)||_0x4713e3['OCkDV'](this[_0x1489c3(0x151d)+'eY'],_0x4d1cd0)){const _0x1a71f3=_0x4713e3[_0x1489c3(0x33c)][_0x1489c3(0xab1)]('|');let _0x3571aa=-0x17fd*0x1+0x23a1+-0xba4;while(!![]){switch(_0x1a71f3[_0x3571aa++]){case'0':_0x4713e3[_0x1489c3(0xc55)](_0x494c72,-0x24c5+-0x23e4+0x48a9)&&this[_0x1489c3(0xf77)+_0x1489c3(0x11d)]();continue;case'1':this[_0x1489c3(0x151d)+'eY']=_0x4d1cd0;continue;case'2':this['_homeEasin'+'g']=_0x56f9b5;continue;case'3':this['_homeWhole'+'Duration']=_0x494c72;continue;case'4':this['_targetHom'+'eX']=_0x3ac659;continue;case'5':this[_0x1489c3(0x11d6)+_0x1489c3(0x130a)]=_0x494c72;continue;}break;}}},Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0x14a0)+_0xe90fac(0xddd)]=function(){const _0x13190d=_0xe90fac,_0x82e480={'WHBNH':function(_0x3ec6cf,_0x574c3e){return _0x3ec6cf<=_0x574c3e;},'howBK':function(_0x24c188,_0x2322fc){return _0x24c188/_0x2322fc;},'YdYhJ':function(_0x1d8f02,_0x4058e2){return _0x1d8f02+_0x4058e2;},'PUVLD':function(_0x397354,_0x5e3c2e){return _0x397354*_0x5e3c2e;},'fxXKz':function(_0x3e68c1,_0x2e1554){return _0x3e68c1-_0x2e1554;},'ZtpYa':function(_0x24dabd,_0x260e31){return _0x24dabd+_0x260e31;},'CExaB':function(_0x110c20,_0x4f0b6d){return _0x110c20*_0x4f0b6d;},'KwzxD':function(_0x39766f,_0x53209f){return _0x39766f<=_0x53209f;}};if(_0x82e480['WHBNH'](this[_0x13190d(0x11d6)+_0x13190d(0x130a)],-0x5b*0x18+0x14a6+-0x21*0x5e))return;const _0x198f1f=this['_homeDurat'+'ion'],_0x1f7222=this[_0x13190d(0x21d)+_0x13190d(0x825)],_0x51309f=this['_homeEasin'+'g'];Imported[_0x13190d(0x155e)+_0x13190d(0x100d)]?(this[_0x13190d(0xcc4)]=this[_0x13190d(0x44b)+'g'](this[_0x13190d(0xcc4)],this['_targetHom'+'eX'],_0x198f1f,_0x1f7222,_0x51309f),this[_0x13190d(0x54e)]=this[_0x13190d(0x44b)+'g'](this['_homeY'],this[_0x13190d(0x151d)+'eY'],_0x198f1f,_0x1f7222,_0x51309f)):(this[_0x13190d(0xcc4)]=_0x82e480[_0x13190d(0xd40)](_0x82e480[_0x13190d(0x8ab)](_0x82e480['PUVLD'](this[_0x13190d(0xcc4)],_0x82e480['fxXKz'](_0x198f1f,0x1202+0x1315+-0x2516)),this[_0x13190d(0x151d)+'eX']),_0x198f1f),this[_0x13190d(0x54e)]=_0x82e480['howBK'](_0x82e480[_0x13190d(0xcd0)](_0x82e480[_0x13190d(0x664)](this[_0x13190d(0x54e)],_0x82e480[_0x13190d(0xfbe)](_0x198f1f,0x14a8+-0x2600+0x1159)),this[_0x13190d(0x151d)+'eY']),_0x198f1f));this[_0x13190d(0x11d6)+_0x13190d(0x130a)]--;if(_0x82e480[_0x13190d(0x8bf)](this[_0x13190d(0x11d6)+'ion'],-0x19ef*0x1+0x1cbe+0x2cf*-0x1))this[_0x13190d(0xf77)+_0x13190d(0x11d)]();},Sprite_Battler[_0xe90fac(0x510)]['onHomeMove'+_0xe90fac(0x11d)]=function(){const _0x2f570a=_0xe90fac;this[_0x2f570a(0xcc4)]=this[_0x2f570a(0x151d)+'eX'],this[_0x2f570a(0x54e)]=this[_0x2f570a(0x151d)+'eY'];},Sprite_Battler['prototype'][_0xe90fac(0xe9f)+_0xe90fac(0x87f)+_0xe90fac(0x126e)]=function(){const _0x533a33=_0xe90fac,_0x2e15c3={'kvCrN':_0x533a33(0x88b)+_0x533a33(0x746)},_0x24192e=_0x2e15c3[_0x533a33(0xf8e)][_0x533a33(0xab1)]('|');let _0x2572f5=-0x34*-0x28+-0x1ca5+0x1485;while(!![]){switch(_0x24192e[_0x2572f5++]){case'0':this['_baseX']=this['x'];continue;case'1':this['y']=Math[_0x533a33(0x12be)](this['y']);continue;case'2':this['x']=Math[_0x533a33(0x12be)](this['x']);continue;case'3':this['y']+=this['extraPosit'+'ionScaledY']();continue;case'4':this['x']+=this[_0x533a33(0x945)+_0x533a33(0xb28)]();continue;case'5':this['y']+=this[_0x533a33(0x945)+_0x533a33(0x7a2)]();continue;case'6':this[_0x533a33(0xc1d)+'t']();continue;case'7':this[_0x533a33(0xc4d)]();continue;case'8':this['_baseY']=this['y'];continue;}break;}},Sprite_Battler[_0xe90fac(0x510)]['extraPosit'+_0xe90fac(0xb28)]=function(){let _0x331d51=0x10c6+0x1a*-0xe6+0x696;return _0x331d51;},Sprite_Battler[_0xe90fac(0x510)]['extraPosit'+_0xe90fac(0x7a2)]=function(){const _0x5e9ced=_0xe90fac;let _0x5ca4b1=-0x1*0x18bd+-0x722+0x29*0xc7;return this[_0x5e9ced(0xbb8)]&&!this[_0x5e9ced(0xbb8)]['isBattlerG'+'rounded']()&&(_0x5ca4b1-=this[_0x5e9ced(0xf94)+'ht'],_0x5ca4b1-=this[_0x5e9ced(0xe0d)+'t']),_0x5ca4b1;},Sprite_Battler[_0xe90fac(0x510)]['extraPosit'+_0xe90fac(0x3cb)]=function(){const _0xd6ff2a=_0xe90fac,_0x2a1f81={'vemUs':function(_0x749a6f,_0x3ca5c3){return _0x749a6f!==_0x3ca5c3;},'UBVcD':function(_0x1b2ea6,_0x35cd88){return _0x1b2ea6*_0x35cd88;},'pdaYs':function(_0x2c1b8d,_0x288395){return _0x2c1b8d-_0x288395;}};let _0x20247c=-0xdf3+-0x92*0x11+0x17a5;if(this[_0xd6ff2a(0x174)+_0xd6ff2a(0x94e)]&&_0x2a1f81[_0xd6ff2a(0x145c)](this[_0xd6ff2a(0x14c0)+'r'],Sprite_SvEnemy)){const _0x581352=this[_0xd6ff2a(0x174)+_0xd6ff2a(0x94e)]['scale']['y'];_0x20247c-=_0x2a1f81['UBVcD'](_0x2a1f81[_0xd6ff2a(0x1386)](_0x581352,0x59f+0x2d*0x21+-0xb6b),this[_0xd6ff2a(0xa68)]);}return _0x20247c;},Sprite_Battler['prototype'][_0xe90fac(0xe81)]=function(){const _0x5929a0=_0xe90fac,_0x2db2db={'zUGTi':function(_0x26efa7,_0x1053a8){return _0x26efa7*_0x1053a8;}},_0x53c19a=this[_0x5929a0(0xbb8)]&&this['_battler']['isBattlerF'+_0x5929a0(0x445)]();this[_0x5929a0(0x388)+'X']=_0x2db2db['zUGTi'](_0x53c19a?-(0x2*0x923+-0x1*-0x345+-0x158a):0x1d9f+-0xbe+0x1*-0x1ce0,Math['abs'](this[_0x5929a0(0xe61)]['x']));},Sprite_Battler['prototype'][_0xe90fac(0x4fd)]=function(_0x3372b3,_0x2457a0,_0x37bbe4){const _0x622c42=_0xe90fac,_0x47df4f={'mGwbs':_0x622c42(0x75d)+'0|4','KDrVD':function(_0x5426b6,_0x107a3f){return _0x5426b6||_0x107a3f;},'CrlUl':_0x622c42(0x44a),'VzCFa':function(_0x363477,_0x26e19b){return _0x363477===_0x26e19b;},'qsSTL':function(_0xbf8f84,_0x8bd1b9){return _0xbf8f84<=_0x8bd1b9;}},_0x566be2=_0x47df4f[_0x622c42(0x11fc)][_0x622c42(0xab1)]('|');let _0x58338d=-0x71*0x1d+-0x1a2b+0x26f8;while(!![]){switch(_0x566be2[_0x58338d++]){case'0':this[_0x622c42(0x4e4)+'ng']=_0x47df4f[_0x622c42(0xecb)](_0x37bbe4,_0x47df4f[_0x622c42(0x8f4)]);continue;case'1':this['_floatWhol'+_0x622c42(0x7e8)]=_0x2457a0;continue;case'2':if(_0x47df4f[_0x622c42(0x773)](this[_0x622c42(0x1402)+_0x622c42(0xbcd)],_0x3372b3))return;continue;case'3':this['_floatDura'+_0x622c42(0x1580)]=_0x2457a0;continue;case'4':if(_0x47df4f[_0x622c42(0x123a)](_0x2457a0,0x1170+0xf44*-0x2+0xd18))this[_0x622c42(0xf94)+'ht']=_0x3372b3;continue;case'5':this['_targetFlo'+'atHeight']=_0x3372b3;continue;case'6':if(!this['canMove']())return;continue;}break;}},Sprite_Battler['prototype'][_0xe90fac(0xc1d)+'t']=function(){const _0xa45834=_0xe90fac,_0x374936={'GvVqo':function(_0x568b98,_0x133d46){return _0x568b98<=_0x133d46;},'WKAiq':function(_0xd8ece1,_0x2495db){return _0xd8ece1/_0x2495db;},'kdMsz':function(_0x5579df,_0x50a9e3){return _0x5579df+_0x50a9e3;},'hxAWC':function(_0x1f4c01,_0x286300){return _0x1f4c01*_0x286300;},'HQWQQ':function(_0x5bdd26,_0x36e391){return _0x5bdd26-_0x36e391;},'DLiJA':function(_0x4c3d75,_0x492adf){return _0x4c3d75<=_0x492adf;}};if(_0x374936['GvVqo'](this[_0xa45834(0x109f)+_0xa45834(0x1580)],-0x1*0x19d6+-0x7fe+-0x10ea*-0x2))return;const _0x2b2df7=this[_0xa45834(0x109f)+_0xa45834(0x1580)],_0x413fda=this[_0xa45834(0x1490)+_0xa45834(0x7e8)],_0x1b27f3=this[_0xa45834(0x4e4)+'ng'];Imported['VisuMZ_0_C'+_0xa45834(0x100d)]?this[_0xa45834(0xf94)+'ht']=this[_0xa45834(0x44b)+'g'](this['_floatHeig'+'ht'],this[_0xa45834(0x1402)+'atHeight'],_0x2b2df7,_0x413fda,_0x1b27f3):this[_0xa45834(0xf94)+'ht']=_0x374936[_0xa45834(0xa53)](_0x374936['kdMsz'](_0x374936[_0xa45834(0x413)](this[_0xa45834(0xf94)+'ht'],_0x374936[_0xa45834(0x34b)](_0x2b2df7,0x1c6a+-0x1ffa*0x1+-0x391*-0x1)),this[_0xa45834(0x1402)+_0xa45834(0xbcd)]),_0x2b2df7);this['_floatDura'+_0xa45834(0x1580)]--;if(_0x374936[_0xa45834(0xfcf)](this[_0xa45834(0x109f)+'tion'],-0xc00*-0x1+0xcac+-0x18ac))this[_0xa45834(0x57f)]();},Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0x57f)]=function(){const _0x199c2f=_0xe90fac;this['_floatHeig'+'ht']=this[_0x199c2f(0x1402)+'atHeight'];},Sprite_Battler['prototype'][_0xe90fac(0x8f3)]=function(){const _0x4e94f4=_0xe90fac,_0x41d35a={'lJUnx':function(_0x1ce4c4,_0x5ecccf){return _0x1ce4c4>_0x5ecccf;}};return _0x41d35a[_0x4e94f4(0x1505)](this['_floatDura'+_0x4e94f4(0x1580)],-0x2d6*-0x3+-0x22e0+0x1a5e);},Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0x1a7)]=function(_0x1a577e,_0x19e2b7){const _0x8f9616=_0xe90fac,_0x554a22={'rybCh':_0x8f9616(0xaa0),'stjeb':function(_0x5722f0,_0x5b1656){return _0x5722f0<=_0x5b1656;}},_0x1e23ee=_0x554a22['rybCh']['split']('|');let _0xe708a1=0x5*0x2d7+0xc28+-0x1a5b;while(!![]){switch(_0x1e23ee[_0xe708a1++]){case'0':this[_0x8f9616(0xf18)+_0x8f9616(0x825)]=_0x19e2b7;continue;case'1':this[_0x8f9616(0x1276)+_0x8f9616(0x130a)]=_0x19e2b7;continue;case'2':if(!this[_0x8f9616(0x10e9)]())return;continue;case'3':if(_0x554a22[_0x8f9616(0x208)](_0x19e2b7,0x1a6+-0x22ee+0x2148))return;continue;case'4':this['_jumpMaxHe'+'ight']=_0x1a577e;continue;}break;}},Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0xc4d)]=function(){const _0x335438=_0xe90fac,_0xf92520={'eBObL':function(_0x4ef7b4,_0x3bbd99){return _0x4ef7b4<=_0x3bbd99;},'FmYPo':function(_0x22b0fd,_0x23162b){return _0x22b0fd-_0x23162b;},'iaLSv':function(_0x248573,_0x333315){return _0x248573/_0x333315;},'ioHiv':function(_0x37ca67,_0x47052e){return _0x37ca67+_0x47052e;},'XkqgL':function(_0x16085a,_0x1426b7){return _0x16085a*_0x1426b7;},'hPxxs':function(_0x55ce86,_0x34e35b){return _0x55ce86-_0x34e35b;},'Fztxt':function(_0x26b0f2,_0x4b4852){return _0x26b0f2<=_0x4b4852;}};if(_0xf92520[_0x335438(0xbb6)](this[_0x335438(0x1276)+_0x335438(0x130a)],0x5dd+0x11*-0x1ed+-0xac*-0x28))return;const _0x3fb0fa=_0xf92520[_0x335438(0x1424)](this[_0x335438(0xf18)+'Duration'],this[_0x335438(0x1276)+'ion']),_0x60653=_0xf92520['iaLSv'](this[_0x335438(0xf18)+_0x335438(0x825)],0x1a40+-0x46a*0x7+0x95*0x8),_0x416635=this[_0x335438(0x124e)+_0x335438(0x1278)],_0x827fe1=_0xf92520[_0x335438(0x129d)](-_0x416635,Math['pow'](_0x60653,-0x26f5*0x1+0x185*0x3+0x18*0x16f));this[_0x335438(0xe0d)+'t']=_0xf92520[_0x335438(0x143)](_0xf92520['XkqgL'](_0x827fe1,Math[_0x335438(0x23d)](_0xf92520[_0x335438(0x16c)](_0x3fb0fa,_0x60653),0x7bb+-0xbdb*-0x3+0x3*-0xe6e)),_0x416635),this[_0x335438(0x1276)+'ion']--;if(_0xf92520['Fztxt'](this[_0x335438(0x1276)+_0x335438(0x130a)],-0x3f*0x5d+0x1e0a+-0x727))return this[_0x335438(0x11f9)]();},Sprite_Battler['prototype'][_0xe90fac(0x11f9)]=function(){const _0x27148c=_0xe90fac;this[_0x27148c(0xe0d)+'t']=-0x1144+-0x1576+0x26ba*0x1;},Sprite_Battler['prototype'][_0xe90fac(0x7df)]=function(){const _0x18ab46=_0xe90fac,_0x43b71f={'yDRQe':function(_0xe5092b,_0x2b20a6){return _0xe5092b>_0x2b20a6;}};return _0x43b71f['yDRQe'](this[_0x18ab46(0x1276)+'ion'],0x1*0x2479+0x12e2+-0x375b);},Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0xf3)+'ty']=function(_0x5ef105,_0x3808dc,_0x4ea5e8){const _0x29ec67=_0xe90fac,_0x385688={'SgptG':_0x29ec67(0x3d3)+'1','iztqi':function(_0x171746,_0x5472a1){return _0x171746<=_0x5472a1;},'opKqD':function(_0x199b31,_0x28ae89){return _0x199b31||_0x28ae89;},'dSgAY':_0x29ec67(0x44a),'PuTOX':function(_0x57bab0,_0x248ac3){return _0x57bab0===_0x248ac3;}},_0x37addd=_0x385688['SgptG'][_0x29ec67(0xab1)]('|');let _0x4f01d0=0x12f9*-0x1+-0x49*0x57+-0xc*-0x3a6;while(!![]){switch(_0x37addd[_0x4f01d0++]){case'0':this[_0x29ec67(0x15a5)+_0x29ec67(0x1005)+'n']=_0x3808dc;continue;case'1':if(_0x385688['iztqi'](_0x3808dc,-0x50+0x17a*-0xd+0x1382))this['opacity']=_0x5ef105;continue;case'2':this[_0x29ec67(0x1136)+'city']=_0x5ef105;continue;case'3':this['_opacityEa'+_0x29ec67(0xd7c)]=_0x385688['opKqD'](_0x4ea5e8,_0x385688[_0x29ec67(0x361)]);continue;case'4':if(_0x385688[_0x29ec67(0xfb2)](this[_0x29ec67(0x1136)+_0x29ec67(0x442)],_0x5ef105))return;continue;case'5':this['_opacityDu'+'ration']=_0x3808dc;continue;}break;}},Sprite_Battler['prototype'][_0xe90fac(0xbde)+_0xe90fac(0x798)]=function(){const _0x1cbf33=_0xe90fac,_0x28695d={'tlVGG':function(_0x4488b0,_0x2ccf48){return _0x4488b0===_0x2ccf48;},'uBIpV':_0x1cbf33(0x14b7)+_0x1cbf33(0x44c),'HiFKm':function(_0x42f1f0,_0x569768){return _0x42f1f0<=_0x569768;},'pZRtU':function(_0x424d8d,_0x2764ff){return _0x424d8d/_0x2764ff;},'IhfYf':function(_0x55aed1,_0xcb0532){return _0x55aed1+_0xcb0532;},'WjncQ':function(_0x4fe3ff,_0x3142c6){return _0x4fe3ff*_0x3142c6;},'zfZnf':function(_0x273147,_0x4ea330){return _0x273147-_0x4ea330;},'oGCXZ':function(_0x2e201e,_0x17bb4d){return _0x2e201e<=_0x17bb4d;}};if(_0x28695d[_0x1cbf33(0xf7e)](this[_0x1cbf33(0x14c0)+'r'][_0x1cbf33(0x14c)],_0x28695d['uBIpV']))return;if(_0x28695d[_0x1cbf33(0x1029)](this['_opacityDu'+_0x1cbf33(0x796)],0x2173+0x2153*0x1+-0x42c6))return;const _0x17f8fc=this[_0x1cbf33(0x490)+_0x1cbf33(0x796)],_0x45ef50=this[_0x1cbf33(0x15a5)+_0x1cbf33(0x1005)+'n'],_0x2561cf=this[_0x1cbf33(0xa40)+_0x1cbf33(0xd7c)];Imported[_0x1cbf33(0x155e)+_0x1cbf33(0x100d)]?this[_0x1cbf33(0xfac)]=this['applyEasin'+'g'](this[_0x1cbf33(0xfac)],this[_0x1cbf33(0x1136)+_0x1cbf33(0x442)],_0x17f8fc,_0x45ef50,_0x2561cf):this[_0x1cbf33(0xfac)]=_0x28695d['pZRtU'](_0x28695d[_0x1cbf33(0xb94)](_0x28695d['WjncQ'](this[_0x1cbf33(0xfac)],_0x28695d[_0x1cbf33(0x1498)](_0x17f8fc,-0x22ef+0x129f+0x1*0x1051)),this['_targetOpa'+'city']),_0x17f8fc);this[_0x1cbf33(0x490)+'ration']--;if(_0x28695d[_0x1cbf33(0x14d6)](this[_0x1cbf33(0x490)+_0x1cbf33(0x796)],-0x1*-0xb9d+-0x1*-0x1a93+-0x2f*0xd0))this[_0x1cbf33(0xdc9)+'nd']();},Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0xdc9)+'nd']=function(){const _0x332689=_0xe90fac;this[_0x332689(0xfac)]=this['_targetOpa'+'city'];},Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0x126b)+_0xe90fac(0xb61)]=function(){const _0x1dc741=_0xe90fac,_0x51fa94={'xmNzx':function(_0x171560,_0x6733b7){return _0x171560>_0x6733b7;}};return _0x51fa94[_0x1dc741(0x812)](this[_0x1dc741(0x490)+_0x1dc741(0x796)],-0x250a+-0xaa*0x25+-0x1ece*-0x2);},Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0xa52)+'ow']=function(){const _0x578f92=_0xe90fac;this[_0x578f92(0x93f)+_0x578f92(0xdf4)][_0x578f92(0xf56)]=this[_0x578f92(0xbb8)][_0x578f92(0x358)+'er'](),this[_0x578f92(0xa52)+_0x578f92(0x1033)]();},Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0xa52)+_0xe90fac(0x1033)]=function(){const _0x532e3a=_0xe90fac,_0x5e8aa8={'SsaPP':function(_0x56dc87,_0x4fe323){return _0x56dc87-_0x4fe323;},'SFpVi':function(_0xba5de3,_0x59648f){return _0xba5de3-_0x59648f;}};if(!this[_0x532e3a(0x93f)+_0x532e3a(0xdf4)])return;this[_0x532e3a(0x93f)+'ite']['y']=_0x5e8aa8['SsaPP'](_0x5e8aa8['SFpVi'](this[_0x532e3a(0x1098)],this['y']),-0x1e24+0x30f+0x16d*0x13);},Sprite_Battler['prototype'][_0xe90fac(0xa52)+'owScale']=function(){const _0x590a78=_0xe90fac;if(!this[_0x590a78(0xbb8)])return;this[_0x590a78(0xd09)+_0x590a78(0x282)]=this[_0x590a78(0xbb8)][_0x590a78(0x2df)+_0x590a78(0x2b5)](),this[_0x590a78(0xd09)+_0x590a78(0x4a1)]=this[_0x590a78(0xbb8)][_0x590a78(0x2df)+_0x590a78(0x67e)]();},Game_BattlerBase['prototype'][_0xe90fac(0x2df)+_0xe90fac(0x2b5)]=function(){const _0x2b2700=_0xe90fac,_0x10a22b={'QxVSI':function(_0x4e3fda,_0x5ebd6f){return _0x4e3fda*_0x5ebd6f;},'uteKo':function(_0x5c90aa,_0xa21e9c){return _0x5c90aa(_0xa21e9c);},'zXAzQ':function(_0x3788d1,_0x3e7cf1){return _0x3788d1(_0x3e7cf1);}},_0x53a74c=this['isActor']()?this[_0x2b2700(0x31d)]():this[_0x2b2700(0x70d)]();if(_0x53a74c){const _0x3fe832=_0x53a74c[_0x2b2700(0xfee)];if(_0x3fe832[_0x2b2700(0x3eb)](/<SIDEVIEW SHADOW (?:SCALE|SCALE X):[ ](\d+)([%％])>/i))return _0x10a22b[_0x2b2700(0x4df)](_0x10a22b['uteKo'](Number,RegExp['$1']),0x184*-0x19+-0x366+-0x46*-0x97+0.01);else{if(_0x3fe832[_0x2b2700(0x3eb)](/<SIDEVIEW SHADOW (?:SCALE|SCALE X):[ ](.*)>/i))return _0x10a22b[_0x2b2700(0xc30)](Number,RegExp['$1'])||0x243a+0x280*0xb+-0x3fba;}}return 0x499*-0x3+-0xab*0x1+0xa1*0x17;},Game_BattlerBase[_0xe90fac(0x510)][_0xe90fac(0x2df)+_0xe90fac(0x67e)]=function(){const _0x2ac223=_0xe90fac,_0x4ac900={'YTRhZ':function(_0x20c52c,_0x521fcd){return _0x20c52c*_0x521fcd;},'PQPIe':function(_0x19fcce,_0x20cc11){return _0x19fcce(_0x20cc11);}},_0x24ea18=this[_0x2ac223(0xd83)]()?this['actor']():this['enemy']();if(_0x24ea18){const _0x39d092=_0x24ea18[_0x2ac223(0xfee)];if(_0x39d092[_0x2ac223(0x3eb)](/<SIDEVIEW SHADOW (?:SCALE|SCALE Y):[ ](\d+)([%％])>/i))return _0x4ac900['YTRhZ'](_0x4ac900[_0x2ac223(0xd9f)](Number,RegExp['$1']),0x20fa*-0x1+0x896+0x4*0x619+0.01);else{if(_0x39d092['match'](/<SIDEVIEW SHADOW (?:SCALE|SCALE Y):[ ](.*)>/i))return _0x4ac900[_0x2ac223(0xd9f)](Number,RegExp['$1'])||-0x77*-0x52+-0x779*-0x2+-0x3510;}}return-0x25cd+0x73f*-0x1+0x2d0d;},Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0x10f0)+'e']=function(){const _0x126e88=_0xe90fac,_0x40132d={'GsbjF':function(_0x568e89,_0x436588){return _0x568e89===_0x436588;}};if(_0x40132d[_0x126e88(0xa3f)](this[_0x126e88(0x14c0)+'r'],Sprite_SvEnemy))return;this['updateGrow'](),this[_0x126e88(0x1006)+'ale']();},Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0x1006)+_0xe90fac(0x540)]=function(){const _0x389381=_0xe90fac,_0x3e75a2=this[_0x389381(0x174)+'nSprite'];_0x3e75a2&&(_0x3e75a2[_0x389381(0xe61)]['x']=this[_0x389381(0x4a7)+_0x389381(0x157)](),_0x3e75a2[_0x389381(0xe61)]['y']=this['mainSprite'+_0x389381(0xef6)]());},Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0x4a7)+_0xe90fac(0x157)]=function(){const _0x28009c=_0xe90fac;let _0x39b062=-0x2560+0x144c+0x1115;return _0x39b062*=this[_0x28009c(0x388)+'X'],_0x39b062*=this[_0x28009c(0x11f)],_0x39b062;},Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0x4a7)+'ScaleY']=function(){const _0x1536cb=_0xe90fac,_0x3b65d7={'TFoSJ':function(_0x52ee15,_0x151132){return _0x52ee15*_0x151132;}};return _0x3b65d7[_0x1536cb(0x297)](0x114a+-0x1707+-0x5*-0x126,this['_growY']);},Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0x4a7)+_0xe90fac(0x56a)]=function(){const _0x4c2af6=_0xe90fac,_0x95b65b={'RDGAP':function(_0x470894,_0x2518af){return _0x470894*_0x2518af;}};return _0x95b65b[_0x4c2af6(0xe9c)](this[_0x4c2af6(0x301)],this[_0x4c2af6(0x4a7)+_0x4c2af6(0x157)]());},Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0x4a7)+'Height']=function(){const _0xb78eb8=_0xe90fac,_0x485d63={'etcKE':function(_0x3195c4,_0x55bcf7){return _0x3195c4*_0x55bcf7;}};return _0x485d63[_0xb78eb8(0x1382)](this[_0xb78eb8(0xa68)],this[_0xb78eb8(0x4a7)+_0xb78eb8(0xef6)]());},Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0x70a)]=function(_0x5be474,_0x56f5ec,_0x31ba11,_0x275b4a){const _0x3f87f4=_0xe90fac,_0x15407d={'WVWSB':_0x3f87f4(0x683)+_0x3f87f4(0x26d),'zezgc':function(_0x2ae02e,_0x561bb7){return _0x2ae02e<=_0x561bb7;},'sigzy':function(_0x802cfa,_0x52961c){return _0x802cfa===_0x52961c;},'Utsbu':function(_0x2d3eea,_0x2faf6e){return _0x2d3eea||_0x2faf6e;},'MJXDU':_0x3f87f4(0x44a)},_0x4f548b=_0x15407d[_0x3f87f4(0x3be)][_0x3f87f4(0xab1)]('|');let _0x2f75f7=0x1287+-0x1efe+-0xc77*-0x1;while(!![]){switch(_0x4f548b[_0x2f75f7++]){case'0':this[_0x3f87f4(0x32a)+'wY']=_0x56f5ec;continue;case'1':_0x15407d[_0x3f87f4(0x1450)](_0x31ba11,0x1a4f+0x612+-0x2061)&&(this['_growX']=this['_targetGro'+'wX'],this['_growY']=this[_0x3f87f4(0x32a)+'wY']);continue;case'2':this['_growDurat'+_0x3f87f4(0x130a)]=_0x31ba11;continue;case'3':if(!this['canMove']())return;continue;case'4':if(_0x15407d['sigzy'](this[_0x3f87f4(0x32a)+'wX'],_0x5be474)&&_0x15407d[_0x3f87f4(0x124)](this[_0x3f87f4(0x32a)+'wY'],_0x56f5ec))return;continue;case'5':if(!this[_0x3f87f4(0x174)+_0x3f87f4(0x94e)])return;continue;case'6':this[_0x3f87f4(0x13d9)+'g']=_0x15407d['Utsbu'](_0x275b4a,_0x15407d['MJXDU']);continue;case'7':this[_0x3f87f4(0x32a)+'wX']=_0x5be474;continue;case'8':this['_growWhole'+'Duration']=_0x31ba11;continue;}break;}},Sprite_Battler['prototype'][_0xe90fac(0x167)]=function(){const _0xe1a11f=_0xe90fac,_0x417130={'dgbWq':function(_0x2fb085,_0x28d64f){return _0x2fb085<=_0x28d64f;},'ZYZsG':function(_0xcd4bb6,_0x4cf3f4){return _0xcd4bb6/_0x4cf3f4;},'MBElO':function(_0xc7bc87,_0x762c50){return _0xc7bc87+_0x762c50;},'KgXeq':function(_0x5971e1,_0x55d9ca){return _0x5971e1*_0x55d9ca;},'AcIXl':function(_0x21cd02,_0x206730){return _0x21cd02-_0x206730;},'mklwW':function(_0x181aed,_0x138e14){return _0x181aed+_0x138e14;},'alwgg':function(_0x54cd1e,_0x397348){return _0x54cd1e-_0x397348;},'yZXOL':function(_0x2c732c,_0x4c9d88){return _0x2c732c<=_0x4c9d88;}};if(_0x417130['dgbWq'](this[_0xe1a11f(0x13e3)+_0xe1a11f(0x130a)],-0xa69+0x1dc*-0xe+0x1eb*0x13))return;if(!this[_0xe1a11f(0x174)+_0xe1a11f(0x94e)])return;const _0x11d5ea=this['_growDurat'+'ion'],_0x118a3e=this['_growWhole'+_0xe1a11f(0x825)],_0xecdd89=this[_0xe1a11f(0x13d9)+'g'];Imported[_0xe1a11f(0x155e)+_0xe1a11f(0x100d)]?(this[_0xe1a11f(0x11f)]=this[_0xe1a11f(0x44b)+'g'](this[_0xe1a11f(0x11f)],this[_0xe1a11f(0x32a)+'wX'],_0x11d5ea,_0x118a3e,_0xecdd89),this['_growY']=this[_0xe1a11f(0x44b)+'g'](this['_growY'],this[_0xe1a11f(0x32a)+'wY'],_0x11d5ea,_0x118a3e,_0xecdd89)):(this['_growX']=_0x417130['ZYZsG'](_0x417130['MBElO'](_0x417130[_0xe1a11f(0x14df)](this[_0xe1a11f(0x11f)],_0x417130[_0xe1a11f(0x9d3)](_0x11d5ea,-0x5d3+-0x1*0xa06+-0x2*-0x7ed)),this[_0xe1a11f(0x32a)+'wX']),_0x11d5ea),this[_0xe1a11f(0x90f)]=_0x417130[_0xe1a11f(0x72b)](_0x417130[_0xe1a11f(0xfdf)](_0x417130[_0xe1a11f(0x14df)](this[_0xe1a11f(0x90f)],_0x417130[_0xe1a11f(0xd12)](_0x11d5ea,-0x567+-0xca*0x25+0x229a)),this[_0xe1a11f(0x32a)+'wY']),_0x11d5ea));this['_growDurat'+_0xe1a11f(0x130a)]--;if(_0x417130['yZXOL'](this['_growDurat'+_0xe1a11f(0x130a)],0x1c40+-0x2*0x5e5+-0x1076))this['onGrowEnd']();},Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0x75c)]=function(){const _0x53f63e=_0xe90fac;this[_0x53f63e(0x11f)]=this['_targetGro'+'wX'],this[_0x53f63e(0x90f)]=this[_0x53f63e(0x32a)+'wY'];},Sprite_Battler['prototype'][_0xe90fac(0x28c)]=function(){const _0x26e6ce=_0xe90fac,_0x31b78d={'BkddQ':function(_0xc32223,_0x438bb1){return _0xc32223>_0x438bb1;}};return _0x31b78d[_0x26e6ce(0xf1c)](this[_0x26e6ce(0x13e3)+_0x26e6ce(0x130a)],-0xd*-0x281+-0x22*-0xa6+-0x3699);},Sprite_Battler['prototype'][_0xe90fac(0x7b4)]=function(_0x334029,_0x5e66fb,_0xa80fc5,_0x54f7e2){const _0x5d3742=_0xe90fac,_0x3e02d8={'VzECW':_0x5d3742(0x56f)+_0x5d3742(0x10bf),'pAMNz':function(_0x267816,_0x44e88d){return _0x267816||_0x44e88d;},'niQMh':_0x5d3742(0x44a),'xgxQD':function(_0x10188b,_0x5102e6){return _0x10188b===_0x5102e6;},'mHYRt':function(_0x2c5bf2,_0x294d9a){return _0x2c5bf2===_0x294d9a;},'DmNmS':function(_0x3f349c,_0x4c914b){return _0x3f349c<=_0x4c914b;}},_0x2890ea=_0x3e02d8[_0x5d3742(0xf7a)][_0x5d3742(0xab1)]('|');let _0x5a8462=0x5cf+-0x1*0x20f9+0x2*0xd95;while(!![]){switch(_0x2890ea[_0x5a8462++]){case'0':this[_0x5d3742(0xe97)+'wX']=_0x334029;continue;case'1':this[_0x5d3742(0xac4)+'g']=_0x3e02d8[_0x5d3742(0x8b8)](_0x54f7e2,_0x3e02d8[_0x5d3742(0xaab)]);continue;case'2':this[_0x5d3742(0x11a9)+_0x5d3742(0x825)]=_0xa80fc5;continue;case'3':this[_0x5d3742(0x837)+_0x5d3742(0x130a)]=_0xa80fc5;continue;case'4':if(_0x3e02d8[_0x5d3742(0x832)](this['_targetSke'+'wX'],_0x334029)&&_0x3e02d8[_0x5d3742(0xbd1)](this['_targetSke'+'wY'],_0x5e66fb))return;continue;case'5':this['_targetSke'+'wY']=_0x5e66fb;continue;case'6':if(!this['canMove']())return;continue;case'7':_0x3e02d8['DmNmS'](_0xa80fc5,-0x5e*0x3a+-0x1*0x50b+0x265*0xb)&&(this[_0x5d3742(0x174)+_0x5d3742(0x94e)]['skew']['x']=this['_targetSke'+'wX'],this[_0x5d3742(0x174)+_0x5d3742(0x94e)][_0x5d3742(0x310)]['y']=this[_0x5d3742(0xe97)+'wY']);continue;case'8':if(!this['_distortio'+_0x5d3742(0x94e)])return;continue;}break;}},Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0x13bc)]=function(){const _0xb7452=_0xe90fac,_0x2f9fec={'gXJww':function(_0x3ecf7a,_0x1583a2){return _0x3ecf7a<=_0x1583a2;},'PdxPb':function(_0x4be056,_0x556b92){return _0x4be056/_0x556b92;},'MukNp':function(_0x478646,_0x2cb1a7){return _0x478646+_0x2cb1a7;},'ooCJz':function(_0x3333ee,_0x4aecd0){return _0x3333ee*_0x4aecd0;},'tZQoQ':function(_0x3b777c,_0x6006b2){return _0x3b777c-_0x6006b2;},'BQXfC':function(_0x443797,_0x4e22a4){return _0x443797/_0x4e22a4;},'flGjg':function(_0x30524e,_0x4c699a){return _0x30524e+_0x4c699a;},'qirin':function(_0x1e143d,_0x4def1c){return _0x1e143d-_0x4def1c;}};if(_0x2f9fec[_0xb7452(0x6aa)](this[_0xb7452(0x837)+'ion'],0xa8*0x2d+0x16ca+-0x3452))return;if(!this[_0xb7452(0x174)+_0xb7452(0x94e)])return;const _0x3b0108=this[_0xb7452(0x837)+_0xb7452(0x130a)],_0x4d8b96=this[_0xb7452(0x11a9)+_0xb7452(0x825)],_0x228be5=this[_0xb7452(0xac4)+'g'],_0x51d7c3=this[_0xb7452(0x174)+_0xb7452(0x94e)];Imported[_0xb7452(0x155e)+'oreEngine']?(_0x51d7c3[_0xb7452(0x310)]['x']=this[_0xb7452(0x44b)+'g'](_0x51d7c3[_0xb7452(0x310)]['x'],this['_targetSke'+'wX'],_0x3b0108,_0x4d8b96,_0x228be5),_0x51d7c3[_0xb7452(0x310)]['y']=this[_0xb7452(0x44b)+'g'](_0x51d7c3[_0xb7452(0x310)]['y'],this[_0xb7452(0xe97)+'wY'],_0x3b0108,_0x4d8b96,_0x228be5)):(_0x51d7c3[_0xb7452(0x310)]['x']=_0x2f9fec['PdxPb'](_0x2f9fec[_0xb7452(0x8f9)](_0x2f9fec[_0xb7452(0xb91)](_0x51d7c3[_0xb7452(0x310)]['x'],_0x2f9fec[_0xb7452(0xbe2)](_0x3b0108,0x1e19+-0x1ea3*0x1+0x1*0x8b)),this['_targetSke'+'wX']),_0x3b0108),_0x51d7c3['skew']['y']=_0x2f9fec['BQXfC'](_0x2f9fec[_0xb7452(0x134c)](_0x2f9fec[_0xb7452(0xb91)](_0x51d7c3[_0xb7452(0x310)]['y'],_0x2f9fec['qirin'](_0x3b0108,-0xda9+0x1ac8+0xd1e*-0x1)),this[_0xb7452(0xe97)+'wY']),_0x3b0108));this['_skewDurat'+'ion']--;if(_0x2f9fec[_0xb7452(0x6aa)](this[_0xb7452(0x837)+_0xb7452(0x130a)],-0x1595+0x57a+0x101b*0x1))this[_0xb7452(0x1442)]();},Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0x1442)]=function(){const _0xe7d2aa=_0xe90fac;this[_0xe7d2aa(0x174)+_0xe7d2aa(0x94e)]['skew']['x']=this[_0xe7d2aa(0xe97)+'wX'],this[_0xe7d2aa(0x174)+_0xe7d2aa(0x94e)][_0xe7d2aa(0x310)]['y']=this['_targetSke'+'wY'];},Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0xacc)]=function(){const _0x32a03c=_0xe90fac,_0x2639d2={'KRsYR':function(_0x979e51,_0x6b9a4c){return _0x979e51>_0x6b9a4c;}};return _0x2639d2[_0x32a03c(0xc6f)](this[_0x32a03c(0x837)+_0x32a03c(0x130a)],-0x26*-0x2d+0x19*-0x13f+0xb3*0x23);},Sprite_Battler['prototype'][_0xe90fac(0xf76)]=function(_0x14410f,_0x3020d2,_0x2b296d,_0x1afb58){const _0x1114e4=_0xe90fac,_0x4dc930={'Mzdhv':_0x1114e4(0x11d1)+'9|4|6|1|3','lKnic':function(_0x272f3b,_0x1601fa){return _0x272f3b===_0x1601fa;},'VWrWV':function(_0x3eff57,_0x2e78ee){return _0x3eff57<=_0x2e78ee;},'mOMzO':function(_0x3c2964,_0x5ed900){return _0x3c2964||_0x5ed900;},'YLQoq':_0x1114e4(0x44a),'hCnov':function(_0x22d556,_0x1a0a30){return _0x22d556===_0x1a0a30;}},_0x492e83=_0x4dc930[_0x1114e4(0x744)][_0x1114e4(0xab1)]('|');let _0x107a9c=0x57*-0x51+-0x1*0x1e2e+-0xbb*-0x4f;while(!![]){switch(_0x492e83[_0x107a9c++]){case'0':if(!this[_0x1114e4(0x174)+_0x1114e4(0x94e)])return;continue;case'1':_0x4dc930[_0x1114e4(0x11b8)](this[_0x1114e4(0x5a3)+'rtOnFinish'],undefined)&&(this[_0x1114e4(0x5a3)+_0x1114e4(0x128b)]=!![]);continue;case'2':this[_0x1114e4(0xdee)+_0x1114e4(0x1580)]=_0x3020d2;continue;case'3':_0x4dc930[_0x1114e4(0xb1b)](_0x3020d2,0xd+0x163b+-0x1648)&&(this[_0x1114e4(0x5b9)+_0x1114e4(0x9b5)]=_0x14410f,this[_0x1114e4(0x5a3)+'rtOnFinish']&&(this[_0x1114e4(0xe5a)+'le']=0x3*0x2bb+-0x146e+-0x1*-0xc3d,this[_0x1114e4(0x5b9)+'gle']=-0x1d41+0x16d*-0x1b+0x21e*0x20));continue;case'4':this[_0x1114e4(0xe63)+'ng']=_0x4dc930['mOMzO'](_0x2b296d,_0x4dc930[_0x1114e4(0xd5b)]);continue;case'5':if(_0x4dc930['hCnov'](this['_targetAng'+'le'],_0x14410f))return;continue;case'6':this[_0x1114e4(0x5a3)+_0x1114e4(0x128b)]=_0x1afb58;continue;case'7':if(!this[_0x1114e4(0x10e9)]())return;continue;case'8':this[_0x1114e4(0xe5a)+'le']=_0x14410f;continue;case'9':this[_0x1114e4(0x11e2)+_0x1114e4(0x7e8)]=_0x3020d2;continue;}break;}},Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0xf2c)]=function(){const _0x4ac9da=_0xe90fac;this[_0x4ac9da(0x265)+_0x4ac9da(0x54b)+_0x4ac9da(0x15e9)](),this['applyAngle'+_0x4ac9da(0x46e)]();},Sprite_Battler[_0xe90fac(0x510)]['updateAngl'+_0xe90fac(0x54b)+_0xe90fac(0x15e9)]=function(){const _0x15b8da=_0xe90fac,_0x4c6274={'fMMIF':function(_0x426c09,_0xda9a41){return _0x426c09<=_0xda9a41;},'RfsFt':function(_0x5447e6,_0x9340b0){return _0x5447e6/_0x9340b0;},'foDgQ':function(_0x1b0bd5,_0x1f06d6){return _0x1b0bd5+_0x1f06d6;},'MIbVA':function(_0x4741da,_0x282e47){return _0x4741da*_0x282e47;},'iuljy':function(_0x3ee0e6,_0x5ad489){return _0x3ee0e6-_0x5ad489;},'DRfMS':function(_0xc80343,_0x37a207){return _0xc80343<=_0x37a207;}};if(_0x4c6274['fMMIF'](this['_angleDura'+_0x15b8da(0x1580)],0x3*-0x1a1+0x16*-0x99+0x1209))return;const _0x550de0=this['_angleDura'+_0x15b8da(0x1580)],_0x317493=this[_0x15b8da(0x11e2)+_0x15b8da(0x7e8)],_0x3eb27e=this['_angleEasi'+'ng'];Imported[_0x15b8da(0x155e)+_0x15b8da(0x100d)]?this[_0x15b8da(0x5b9)+_0x15b8da(0x9b5)]=this[_0x15b8da(0x44b)+'g'](this['_currentAn'+_0x15b8da(0x9b5)],this[_0x15b8da(0xe5a)+'le'],_0x550de0,_0x317493,_0x3eb27e):this['_currentAn'+_0x15b8da(0x9b5)]=_0x4c6274[_0x15b8da(0x672)](_0x4c6274[_0x15b8da(0x53a)](_0x4c6274['MIbVA'](this[_0x15b8da(0x5b9)+_0x15b8da(0x9b5)],_0x4c6274[_0x15b8da(0x738)](_0x550de0,-0x1f1f*0x1+-0xb0a+0x2a2a)),this[_0x15b8da(0xe5a)+'le']),_0x550de0);this['_angleDura'+_0x15b8da(0x1580)]--;if(_0x4c6274[_0x15b8da(0x2da)](this[_0x15b8da(0xdee)+_0x15b8da(0x1580)],0x17ad+-0x9ae+0x1*-0xdff))this[_0x15b8da(0x1445)]();},Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0x1445)]=function(){const _0x2daa92=_0xe90fac;this[_0x2daa92(0x5b9)+_0x2daa92(0x9b5)]=this[_0x2daa92(0xe5a)+'le'],this['_angleReve'+_0x2daa92(0x128b)]&&(this[_0x2daa92(0xe5a)+'le']=-0xedb*0x1+-0x1b44+0x2a1f,this[_0x2daa92(0x5b9)+_0x2daa92(0x9b5)]=0x1*-0x1cde+0x1*-0x1197+-0x7*-0x6a3);},Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0x8a9)]=function(){const _0x5d4c70=_0xe90fac,_0x2cca37={'Cfotd':function(_0x59a1a8,_0x36332d){return _0x59a1a8>_0x36332d;}};return _0x2cca37[_0x5d4c70(0x15c9)](this[_0x5d4c70(0xdee)+_0x5d4c70(0x1580)],-0x1aa9+0x1*0xa9f+-0x100a*-0x1);},Sprite_Battler['prototype'][_0xe90fac(0xe7a)+'Change']=function(){const _0x5b0192=_0xe90fac,_0xc14585={'SiUjL':function(_0x3902df,_0x3b8cda){return _0x3902df*_0x3b8cda;},'zhtiL':function(_0x5d4fd2,_0x20f9a4){return _0x5d4fd2*_0x20f9a4;},'bSiAX':function(_0x345c94,_0x16509c){return _0x345c94*_0x16509c;},'BjsQf':function(_0x2ff5a9,_0x3584c9){return _0x2ff5a9*_0x3584c9;},'ytEkR':function(_0x50f177,_0x2a290c){return _0x50f177-_0x2a290c;},'MAmUr':function(_0x43fbe9,_0x2cc0c3){return _0x43fbe9*_0x2cc0c3;},'orvmE':function(_0x54bf29,_0x4b61f7){return _0x54bf29*_0x4b61f7;}};if(!this[_0x5b0192(0x174)+_0x5b0192(0x94e)])return;const _0x2eca51=this[_0x5b0192(0x5b9)+'gle'],_0x1c2c71=this[_0x5b0192(0xe61)]['x'],_0x28c105=this['_battler'][_0x5b0192(0xd83)]()?-(0x17*-0x14f+-0x92b+0x3*0xd17):-0x9*-0x1a6+-0x193f*0x1+0xa6a;this[_0x5b0192(0x174)+_0x5b0192(0x94e)][_0x5b0192(0xec0)]=_0xc14585[_0x5b0192(0xd74)](_0xc14585['zhtiL'](_0x2eca51,_0x1c2c71),_0x28c105);const _0x1f867b=this[_0x5b0192(0x174)+_0x5b0192(0x94e)][_0x5b0192(0xe61)]['y'];this[_0x5b0192(0x174)+_0x5b0192(0x94e)]['y']=_0xc14585[_0x5b0192(0x7ca)](_0xc14585['BjsQf'](this['height'],-(0xd*0x7+-0x3aa+0x34f+0.5)),_0xc14585[_0x5b0192(0x11e0)](0x234d*0x1+0x1*-0xcd7+-0x1674,_0x1f867b)),this[_0x5b0192(0x174)+_0x5b0192(0x94e)]['y']=Math['ceil'](this[_0x5b0192(0x174)+_0x5b0192(0x94e)]['y']);const _0x1d2aa4=[this['_mainSprit'+'e'],this[_0x5b0192(0x1ee)+_0x5b0192(0x15e6)],this[_0x5b0192(0x8a8)+'esSpriteCo'+_0x5b0192(0xb05)]];for(const _0x2587cb of _0x1d2aa4){if(!_0x2587cb)continue;_0x2587cb['y']=_0xc14585['MAmUr'](this[_0x5b0192(0xa68)],-0xd5*0x2d+-0x10e5+0x3656+0.5);}this[_0x5b0192(0x93f)+_0x5b0192(0xdf4)]&&(this['_shadowSca'+_0x5b0192(0x282)]=this[_0x5b0192(0xd09)+'leX']??0x5*0x29b+0x205c+-0x2d62,this[_0x5b0192(0xd09)+_0x5b0192(0x4a1)]=this[_0x5b0192(0xd09)+_0x5b0192(0x4a1)]??-0x1bf1+-0xfc1+0x2bb3,this['_shadowSpr'+_0x5b0192(0xdf4)][_0x5b0192(0xe61)]['x']=_0xc14585[_0x5b0192(0x190)](this[_0x5b0192(0x174)+'nSprite'][_0x5b0192(0xe61)]['x'],this['_shadowSca'+_0x5b0192(0x282)]),this[_0x5b0192(0x93f)+_0x5b0192(0xdf4)]['scale']['y']=_0xc14585[_0x5b0192(0x828)](this[_0x5b0192(0x174)+_0x5b0192(0x94e)][_0x5b0192(0xe61)]['y'],this[_0x5b0192(0xd09)+_0x5b0192(0x4a1)]));},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x1044)+_0xe90fac(0x2a2)+'tateSprite']=Sprite_Actor[_0xe90fac(0x510)][_0xe90fac(0xd4e)+_0xe90fac(0x15a9)],Sprite_Actor[_0xe90fac(0x510)][_0xe90fac(0xd4e)+_0xe90fac(0x15a9)]=function(){const _0x279e0a=_0xe90fac;VisuMZ[_0x279e0a(0x118f)][_0x279e0a(0x1044)+'or_createS'+_0x279e0a(0xf3b)]['call'](this),VisuMZ[_0x279e0a(0x118f)]['Settings']['HpGauge'][_0x279e0a(0x8e6)+_0x279e0a(0xf82)]&&this[_0x279e0a(0x67a)+_0x279e0a(0xc14)]();},VisuMZ[_0xe90fac(0x118f)]['Sprite_Ene'+'my_createS'+'tateIconSp'+_0xe90fac(0x831)]=Sprite_Enemy[_0xe90fac(0x510)][_0xe90fac(0xd4e)+'eIconSprit'+'e'],Sprite_Enemy['prototype'][_0xe90fac(0xd4e)+'eIconSprit'+'e']=function(){const _0x94aa4c=_0xe90fac;VisuMZ[_0x94aa4c(0x118f)][_0x94aa4c(0x281)][_0x94aa4c(0x10a9)][_0x94aa4c(0x1032)+_0x94aa4c(0xf82)]&&this[_0x94aa4c(0x67a)+_0x94aa4c(0xc14)](),VisuMZ[_0x94aa4c(0x118f)][_0x94aa4c(0xe5c)+'my_createS'+_0x94aa4c(0x50d)+'rite'][_0x94aa4c(0x351)](this);},Sprite_Battler[_0xe90fac(0x510)]['createHpGa'+_0xe90fac(0xc14)]=function(){const _0xcb5709=_0xe90fac,_0x5ee345={'PWrPC':function(_0x358a23,_0x2879c8){return _0x358a23===_0x2879c8;}};if(!ConfigManager[_0xcb5709(0x503)+_0xcb5709(0x9dc)])return;if(_0x5ee345[_0xcb5709(0x13c2)](this[_0xcb5709(0x14c0)+'r'],Sprite_SvEnemy))return;const _0x3a6192=VisuMZ['BattleCore']['Settings'][_0xcb5709(0x10a9)],_0x16f0a3=new Sprite_HpGauge();_0x16f0a3['anchor']['x']=_0x3a6192['AnchorX'],_0x16f0a3['anchor']['y']=_0x3a6192[_0xcb5709(0xfd3)],_0x16f0a3[_0xcb5709(0xe61)]['x']=_0x16f0a3[_0xcb5709(0xe61)]['y']=_0x3a6192[_0xcb5709(0xfe6)],this[_0xcb5709(0x2b2)+_0xcb5709(0x831)]=_0x16f0a3,this[_0xcb5709(0xda3)](this[_0xcb5709(0x2b2)+_0xcb5709(0x831)]),Spriteset_Battle[_0xcb5709(0x7f4)+'UI']&&BattleManager[_0xcb5709(0xe5b)+_0xcb5709(0xec5)+'r'](this[_0xcb5709(0x2b2)+'rite']);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x5bd)+_0xe90fac(0xc7e)+'ttler']=Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0x117e)],Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0x117e)]=function(_0x39aa81){const _0x239880=_0xe90fac,_0x4bc61b={'ZLcaU':function(_0x50da12,_0x80bb87){return _0x50da12!==_0x80bb87;}},_0x46c688=this[_0x239880(0xbb8)];VisuMZ[_0x239880(0x118f)]['Sprite_Bat'+'tler_setBa'+_0x239880(0x8a7)][_0x239880(0x351)](this,_0x39aa81),this['setupHpGau'+_0x239880(0xa93)](_0x39aa81);if(_0x4bc61b[_0x239880(0xb6c)](_0x46c688,_0x39aa81))this['updateShad'+_0x239880(0x1173)]();},Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0x7ec)+'geSprite']=function(_0x2d1ec2){const _0x63acd7=_0xe90fac,_0x1a89c6={'daqWk':function(_0x3b9cbb,_0x116335){return _0x3b9cbb===_0x116335;}};if(!_0x2d1ec2)return;if(!this[_0x63acd7(0x2b2)+'rite'])return;if(_0x2d1ec2['isActor']()){}else{if(_0x2d1ec2['isEnemy']()){if(_0x1a89c6[_0x63acd7(0x124f)](this['constructo'+'r'],Sprite_SvEnemy)&&!_0x2d1ec2[_0x63acd7(0x358)+'er']())return;}}this['_hpGaugeSp'+_0x63acd7(0x831)][_0x63acd7(0xc70)](_0x2d1ec2,'hp');},Sprite_Battler['prototype'][_0xe90fac(0x48d)+'vBattler']=function(){const _0x5d98ec=_0xe90fac;return this[_0x5d98ec(0xbb8)]&&this[_0x5d98ec(0xbb8)][_0x5d98ec(0x48d)+_0x5d98ec(0x1346)]();},Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0x14e)+_0xe90fac(0xd52)+'rFrames']=function(){const _0x948918=_0xe90fac,_0x53286d={'ubLBq':function(_0x2f0c94,_0x2886ee){return _0x2f0c94-_0x2886ee;}},_0x575370=this[_0x948918(0x8d1)+'e'][_0x948918(0x24c)];if(!_0x575370)return;const _0x5d05e6=_0x575370[_0x948918(0x301)];let _0x3d069c=_0x575370[_0x948918(0xa68)];if(this['_battler'][_0x948918(0x17d)]()){if(this['_frame'])_0x3d069c=Math[_0x948918(0xd3e)](-0x338*-0x8+-0x3*0x94d+0x13*0x1d,_0x53286d[_0x948918(0xe6a)](this[_0x948918(0x764)][_0x948918(0xa68)],-0x5*-0x54d+0xd31+-0x3*0xd3a));}this[_0x948918(0x8d1)+'e'][_0x948918(0xf6)](0xd06+0x12c4+-0x1*0x1fca,-0x224f+0x10a4+-0x1*-0x11ab,_0x5d05e6,_0x3d069c),this[_0x948918(0xf6)](-0xa8+0x1e4f+-0x1da7,-0x12f5+0x1*0x2007+-0xd12,_0x5d05e6,_0x3d069c);},Sprite_Battler['prototype']['updateHpGa'+_0xe90fac(0x1504)+'n']=function(){const _0x1261b1=_0xe90fac,_0x1216da={'GIODx':function(_0x2b36ea,_0x2d8b99){return _0x2b36ea+_0x2d8b99;}};if(!this['_battler'])return;if(!this['_hpGaugeSp'+_0x1261b1(0x831)])return;const _0x4aa05c=VisuMZ[_0x1261b1(0x118f)]['Settings'][_0x1261b1(0x10a9)],_0x31a343=this[_0x1261b1(0x2b2)+'rite'];_0x31a343['visible']=this[_0x1261b1(0x5b2)+_0x1261b1(0x15a7)+_0x1261b1(0x81e)]();const _0x2fb4a9=_0x4aa05c[_0x1261b1(0x11c6)],_0x30eac1=_0x4aa05c[_0x1261b1(0xc1e)];_0x31a343['x']=_0x2fb4a9,_0x31a343['x']+=this[_0x1261b1(0xbb8)][_0x1261b1(0xb31)+'fsetX'](),_0x31a343['y']=_0x1216da['GIODx'](-this[_0x1261b1(0xa68)],_0x30eac1),_0x31a343['y']+=this['_battler'][_0x1261b1(0xb31)+'fsetY'](),Spriteset_Battle['ANTI_TINT_'+'UI']&&SceneManager[_0x1261b1(0x11dd)][_0x1261b1(0x981)]&&(_0x31a343['x']+=this['x'],_0x31a343['y']+=this['y']);},Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0x5b2)+_0xe90fac(0x15a7)+_0xe90fac(0x81e)]=function(){const _0x4abb9a=_0xe90fac,_0x45ebec={'wtpqd':function(_0xfe0524,_0x5d43aa){return _0xfe0524<=_0x5d43aa;}};if(!this[_0x4abb9a(0xbb8)])return![];if(this[_0x4abb9a(0xbb8)][_0x4abb9a(0xd83)]())return!![];if(this[_0x4abb9a(0xbb8)]['isHidden']())return![];if(_0x45ebec[_0x4abb9a(0x8d0)](this[_0x4abb9a(0xfac)],0x3c6+0x183*0x12+-0x3*0xa54))return![];const _0x3b7653=this[_0x4abb9a(0xbb8)]['enemy']()[_0x4abb9a(0xfee)];if(_0x3b7653[_0x4abb9a(0x3eb)](/<SHOW HP GAUGE>/i))return!![];if(_0x3b7653[_0x4abb9a(0x3eb)](/<HIDE HP GAUGE>/i))return![];const _0xfb7443=VisuMZ[_0x4abb9a(0x118f)][_0x4abb9a(0x281)][_0x4abb9a(0x10a9)];if(_0xfb7443[_0x4abb9a(0x14d3)+_0x4abb9a(0x2ec)]){if(_0xfb7443[_0x4abb9a(0x524)+'s']&&BattleManager[_0x4abb9a(0xf36)+'st']())return!![];if(this[_0x4abb9a(0xbb8)]['_visualHpG'+'auge_JustD'+_0x4abb9a(0x4f3)])return![];return this[_0x4abb9a(0xbb8)]['hasBeenDef'+_0x4abb9a(0x7cd)+'e']();}return!![];},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x5bd)+'tler_isMov'+_0xe90fac(0x312)]=Sprite_Battler['prototype'][_0xe90fac(0xd42)],Sprite_Battler[_0xe90fac(0x510)]['isMoving']=function(){const _0x1c5654=_0xe90fac,_0x21e585={'cUavQ':function(_0x3f3cb5,_0xa33080){return _0x3f3cb5>_0xa33080;}};if(!this[_0x1c5654(0xbb8)])return![];if(_0x21e585[_0x1c5654(0x223)](this[_0x1c5654(0x11d6)+_0x1c5654(0x130a)],0x1*0xa62+0x1*0x8ce+-0x1330))return!![];return VisuMZ[_0x1c5654(0x118f)][_0x1c5654(0x5bd)+'tler_isMov'+_0x1c5654(0x312)]['call'](this);},VisuMZ[_0xe90fac(0x118f)]['Sprite_Bat'+'tler_start'+_0xe90fac(0xddd)]=Sprite_Battler[_0xe90fac(0x510)]['startMove'],Sprite_Battler['prototype']['startMove']=function(_0x3e7277,_0x4ad5fa,_0x54e72e){const _0x30b5b1=_0xe90fac;this['canMove']()&&VisuMZ[_0x30b5b1(0x118f)][_0x30b5b1(0x5bd)+_0x30b5b1(0x63a)+_0x30b5b1(0xddd)][_0x30b5b1(0x351)](this,_0x3e7277,_0x4ad5fa,_0x54e72e);},Sprite_Battler['prototype'][_0xe90fac(0x10e9)]=function(){const _0xe96ee1=_0xe90fac;if(this[_0xe96ee1(0xbb8)]&&this[_0xe96ee1(0xbb8)][_0xe96ee1(0x17d)]())return![];if(this[_0xe96ee1(0xbb8)]&&!this[_0xe96ee1(0xbb8)]['canBattler'+_0xe96ee1(0xddd)]())return![];return $gameSystem[_0xe96ee1(0x53d)]();},Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0xc81)+'d']=function(){},Sprite_Battler[_0xe90fac(0x510)]['stepBack']=function(){const _0x372c1f=_0xe90fac;this[_0x372c1f(0xae0)](0x12e6+0x1*0x1d7b+-0x3061,0x12b*0x1d+-0x105*-0x11+-0x3334,0x1*-0x1bc5+0x8*-0x469+0x3f19);},Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0xfdd)]=function(){},Sprite_Battler[_0xe90fac(0x510)]['stepFlinch']=function(){const _0x3b0023=_0xe90fac,_0x28572c={'wmLEA':function(_0xcf69c4,_0x11cf6e){return _0xcf69c4+_0x11cf6e;},'RvvBs':function(_0x3a2807,_0xcd03f){return _0x3a2807-_0xcd03f;},'cijlM':function(_0x49fa61,_0x5b38be){return _0x49fa61*_0x5b38be;},'kmaXR':function(_0x1e6a8a,_0x51fe71){return _0x1e6a8a+_0x51fe71;}},_0x5dbff8=VisuMZ[_0x3b0023(0x118f)]['Settings'][_0x3b0023(0xd11)],_0x5a6590=this['_battler']&&this[_0x3b0023(0xbb8)][_0x3b0023(0xd83)]()?0x1c5a+0x163c+-0x1*0x3295:-(0x396+-0x9*0x3d+0x1*-0x170),_0x287248=_0x28572c['wmLEA'](_0x28572c[_0x3b0023(0x123b)](this[_0x3b0023(0x156)],this['_homeX']),_0x28572c['cijlM'](_0x5a6590,_0x5dbff8[_0x3b0023(0x1299)+_0x3b0023(0x13f8)])),_0x10b7a2=_0x28572c[_0x3b0023(0xdfe)](_0x28572c[_0x3b0023(0x123b)](this[_0x3b0023(0x1098)],this['_homeY']),_0x28572c[_0x3b0023(0x7a3)](_0x5a6590,_0x5dbff8['FlinchDist'+'anceY'])),_0x328dec=_0x5dbff8[_0x3b0023(0x835)+_0x3b0023(0x1580)];this['startMove'](_0x287248,_0x10b7a2,_0x328dec);},Sprite_Battler[_0xe90fac(0x510)][_0xe90fac(0x1294)+_0xe90fac(0xbc5)]=function(_0x1d0a66,_0x4f0b82){const _0x192007=_0xe90fac,_0x19def5={'sVwOq':function(_0x2aabaa,_0x3d3b4a){return _0x2aabaa*_0x3d3b4a;}},_0x5b00ac=VisuMZ['BattleCore'][_0x192007(0x281)][_0x192007(0xd11)];this[_0x192007(0x1af)+_0x192007(0x1039)]=Math[_0x192007(0x964)](_0x19def5['sVwOq'](_0x5b00ac['ShakeFlinc'+_0x192007(0x9d0)]??0x3a2+-0x21a4+0x1e1a,_0x4f0b82)),this[_0x192007(0x1af)+_0x192007(0x8fb)]=Math[_0x192007(0xd3e)](this['_shakeFlin'+_0x192007(0x8fb)],_0x1d0a66);},Sprite_Battler['prototype'][_0xe90fac(0x13ec)+_0xe90fac(0x10c8)]=function(){const _0x24f558=_0xe90fac,_0x29ad91={'BnUBr':function(_0x3bd54d,_0x6ad7db){return _0x3bd54d>_0x6ad7db;},'OBogc':function(_0x5edf90,_0x57c3b5){return _0x5edf90/_0x57c3b5;},'SBEwl':function(_0x37eadb,_0x313292){return _0x37eadb*_0x313292;},'gfwAM':function(_0x31ad36,_0x23031c){return _0x31ad36-_0x23031c;},'fXpMK':function(_0x37b473,_0x4f56ea){return _0x37b473<=_0x4f56ea;},'zzkww':function(_0x128b41,_0x44025f){return _0x128b41*_0x44025f;},'EXSKZ':function(_0x2d03cf,_0x3fe78e){return _0x2d03cf<_0x3fe78e;},'NEjbj':function(_0x1e0f4e,_0x2019da){return _0x1e0f4e!==_0x2019da;},'lIAUl':function(_0x5a1bb0,_0x55f808){return _0x5a1bb0*_0x55f808;},'wDkJB':function(_0x3e9af9,_0x452f54){return _0x3e9af9*_0x452f54;},'Sruhu':function(_0x61715e,_0x2e1987){return _0x61715e<_0x2e1987;}},_0x2e7cae=VisuMZ[_0x24f558(0x118f)][_0x24f558(0x281)][_0x24f558(0xd11)];if(!(_0x2e7cae['ShakeFlinc'+'h']??![]))return;if(_0x29ad91['BnUBr'](this[_0x24f558(0x1af)+'chDuration'],-0x17ad+-0x256c*0x1+-0x3d19*-0x1)){const _0x5f1ef4=this[_0x24f558(0x1af)+'chDuration'];this[_0x24f558(0x1af)+'chPower']=_0x29ad91[_0x24f558(0x1525)](_0x29ad91['SBEwl'](this[_0x24f558(0x1af)+_0x24f558(0x8fb)],_0x29ad91['gfwAM'](_0x5f1ef4,-0xd6e+-0xc46+-0x1*-0x19b5)),_0x5f1ef4),this[_0x24f558(0x1af)+'chDuration']--,_0x29ad91[_0x24f558(0x77c)](this[_0x24f558(0x1af)+'chDuration'],-0x22f5*0x1+0x3*0x665+0xfc6)&&(this[_0x24f558(0x1af)+_0x24f558(0x8fb)]=0x136a+0x4*-0xdb+-0xffe);}_0x29ad91[_0x24f558(0x1509)](this[_0x24f558(0x1af)+_0x24f558(0x8fb)],0x737+-0xb*0x2c9+0x176c)?(this['_mainSprit'+'e']['x']=_0x29ad91[_0x24f558(0x44f)](Math[_0x24f558(0x1608)](this[_0x24f558(0x1af)+_0x24f558(0x8fb)]),_0x29ad91[_0x24f558(0x6ba)](Math[_0x24f558(0x9c3)](),0xbac+-0x3ef*-0x7+-0x2735+0.5)?-(0x4*0x269+0x1e29+0x2*-0x13e6):-0xb*0x28a+-0x16ab+0x329a),_0x29ad91[_0x24f558(0x113f)](this[_0x24f558(0x1098)],this['y'])&&(this['_mainSprit'+'e']['y']=_0x29ad91['lIAUl'](this[_0x24f558(0xa68)],-0x23b7+0xacf+0x18e8+0.5),this[_0x24f558(0x8d1)+'e']['y']+=_0x29ad91[_0x24f558(0x6ad)](Math[_0x24f558(0x1608)](this[_0x24f558(0x1af)+_0x24f558(0x8fb)]),_0x29ad91[_0x24f558(0x857)](Math['random'](),0xee6+-0x1c5+0x1*-0xd21+0.5)?-(0x1*0x2509+0x25f8+-0xf00*0x5):-0xdc3*0x1+-0x69b*0x5+-0x2ecb*-0x1))):(this[_0x24f558(0x8d1)+'e']['x']=0x4*0x556+-0x1cf1*0x1+0x799,this[_0x24f558(0x8d1)+'e']['y']=_0x29ad91[_0x24f558(0x44f)](this[_0x24f558(0xa68)],-0x3d*-0x5f+-0x157+0x154c*-0x1+0.5));},VisuMZ['BattleCore'][_0xe90fac(0x1044)+_0xe90fac(0x101e)+'bers']=Sprite_Actor[_0xe90fac(0x510)][_0xe90fac(0x11d5)+'s'],Sprite_Actor['prototype']['initMember'+'s']=function(){const _0x296e4a=_0xe90fac;VisuMZ[_0x296e4a(0x118f)][_0x296e4a(0x1044)+_0x296e4a(0x101e)+_0x296e4a(0x971)][_0x296e4a(0x351)](this),this[_0x296e4a(0x15c1)+_0x296e4a(0x73d)+'rtionSprit'+'e']();},Sprite_Actor[_0xe90fac(0x510)][_0xe90fac(0x4a7)]=function(){const _0x869c62=_0xe90fac;return this[_0x869c62(0x174)+_0x869c62(0x94e)]||this['_mainSprit'+'e']||this;},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x1044)+_0xe90fac(0x16d)+_0xe90fac(0x882)+'on']=Sprite_Actor[_0xe90fac(0x510)][_0xe90fac(0x1cd)+_0xe90fac(0xcf1)],Sprite_Actor['prototype'][_0xe90fac(0x1cd)+_0xe90fac(0xcf1)]=function(){},Sprite_Actor['prototype'][_0xe90fac(0x1cd)+_0xe90fac(0x7e3)+_0xe90fac(0x402)]=function(_0x1fc870){const _0x141d52=_0xe90fac;if(SceneManager[_0x141d52(0x1473)+_0x141d52(0x1367)+_0x141d52(0x38d)+_0x141d52(0x1357)]())return;if(!_0x1fc870)return;if(!_0x1fc870['canMove']())return;VisuMZ[_0x141d52(0x118f)][_0x141d52(0x1044)+_0x141d52(0x16d)+_0x141d52(0x882)+'on'][_0x141d52(0x351)](this);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x1044)+_0xe90fac(0x953)+_0xe90fac(0xde5)]=Sprite_Actor[_0xe90fac(0x510)][_0xe90fac(0x43e)+'me'],Sprite_Actor[_0xe90fac(0x510)][_0xe90fac(0x43e)+'me']=function(_0x52948c){const _0x6c4e82=_0xe90fac;VisuMZ[_0x6c4e82(0x118f)][_0x6c4e82(0x281)][_0x6c4e82(0xd11)][_0x6c4e82(0x204)]?VisuMZ[_0x6c4e82(0x118f)]['Settings']['Actor'][_0x6c4e82(0x204)]['call'](this,_0x52948c):VisuMZ['BattleCore'][_0x6c4e82(0x1044)+_0x6c4e82(0x953)+'rHome'][_0x6c4e82(0x351)](this,_0x52948c);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x1044)+_0xe90fac(0xd24)+'ler']=Sprite_Actor[_0xe90fac(0x510)][_0xe90fac(0x117e)],Sprite_Actor['prototype']['setBattler']=function(_0x5f2eae){const _0x3d3fa5=_0xe90fac;VisuMZ[_0x3d3fa5(0x118f)][_0x3d3fa5(0x1044)+'or_setBatt'+_0x3d3fa5(0x5df)]['call'](this,_0x5f2eae),this[_0x3d3fa5(0x117e)+_0x3d3fa5(0x118f)](_0x5f2eae);},Sprite_Actor[_0xe90fac(0x510)][_0xe90fac(0x117e)+_0xe90fac(0x118f)]=function(_0xc077d0){const _0x43ba74=_0xe90fac,_0x724c86={'EZBtD':'3|4|0|2|1'},_0x3e0716=_0x724c86[_0x43ba74(0xacb)][_0x43ba74(0xab1)]('|');let _0x268bb5=0x6f4+0xaed*0x1+-0x11e1;while(!![]){switch(_0x3e0716[_0x268bb5++]){case'0':this['_mainSprit'+'e'][_0x43ba74(0x11c2)]['x']=this[_0x43ba74(0x69c)][_0x43ba74(0x1465)+_0x43ba74(0x13e7)]();continue;case'1':this[_0x43ba74(0xa52)+_0x43ba74(0x12f7)+'ty']();continue;case'2':this['_mainSprit'+'e'][_0x43ba74(0x11c2)]['y']=this[_0x43ba74(0x69c)][_0x43ba74(0x1465)+_0x43ba74(0x15e7)]();continue;case'3':if(!_0xc077d0)return;continue;case'4':if(!this[_0x43ba74(0x8d1)+'e'])return;continue;}break;}},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x1044)+_0xe90fac(0x11ed)]=Sprite_Actor[_0xe90fac(0x510)][_0xe90fac(0x94)],Sprite_Actor[_0xe90fac(0x510)][_0xe90fac(0x94)]=function(){const _0x453b6b=_0xe90fac;VisuMZ['BattleCore'][_0x453b6b(0x1044)+_0x453b6b(0x11ed)][_0x453b6b(0x351)](this),this[_0x453b6b(0x69c)]&&(this[_0x453b6b(0x14e)+_0x453b6b(0x15a9)](),this[_0x453b6b(0xc5e)+_0x453b6b(0x1036)]());},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x1044)+_0xe90fac(0x110a)+'itmap']=Sprite_Actor[_0xe90fac(0x510)]['updateBitm'+'ap'],Sprite_Actor[_0xe90fac(0x510)][_0xe90fac(0x105c)+'ap']=function(){const _0x4ab504=_0xe90fac,_0x5682d6={'griVC':function(_0xd74da7,_0x9ec69e){return _0xd74da7!==_0x9ec69e;}};VisuMZ[_0x4ab504(0x118f)][_0x4ab504(0x1044)+_0x4ab504(0x110a)+_0x4ab504(0x14c2)]['call'](this),this[_0x4ab504(0x8d1)+'e']&&this[_0x4ab504(0x8d1)+'e'][_0x4ab504(0x24c)]&&this[_0x4ab504(0xbb8)]&&(_0x5682d6['griVC'](this['_mainSprit'+'e']['bitmap'][_0x4ab504(0xb1f)],this[_0x4ab504(0xbb8)][_0x4ab504(0x15fe)+'othImage']())&&(this[_0x4ab504(0x8d1)+'e'][_0x4ab504(0x24c)][_0x4ab504(0xb1f)]=this[_0x4ab504(0xbb8)][_0x4ab504(0x15fe)+_0x4ab504(0xa73)]()));},VisuMZ['BattleCore'][_0xe90fac(0x1044)+_0xe90fac(0x10f7)+_0xe90fac(0x6a3)]=Sprite_Actor[_0xe90fac(0x510)]['updateShad'+'ow'],Sprite_Actor[_0xe90fac(0x510)][_0xe90fac(0xa52)+'ow']=function(){const _0x21ea9e=_0xe90fac;VisuMZ['BattleCore'][_0x21ea9e(0x1044)+'or_updateS'+'hadow']['call'](this),this[_0x21ea9e(0xa52)+_0x21ea9e(0xb5e)+'re']();},Sprite_Actor[_0xe90fac(0x510)][_0xe90fac(0xa52)+'owBattleCo'+'re']=function(){const _0x1f7446=_0xe90fac;if(!this[_0x1f7446(0x8d1)+'e'])return;if(!this[_0x1f7446(0x93f)+_0x1f7446(0xdf4)])return;this[_0x1f7446(0xa52)+'owVisibili'+'ty'](),this[_0x1f7446(0xa52)+_0x1f7446(0x1033)]();},Sprite_Actor[_0xe90fac(0x510)]['updateStat'+'eSprite']=function(){const _0x5b6509=_0xe90fac,_0x51f264={'LoVSo':function(_0x56a37a,_0x59d840){return _0x56a37a/_0x59d840;},'ghOUF':function(_0x476ffa,_0x79fbce){return _0x476ffa+_0x79fbce;},'BloAU':function(_0xcd648a,_0x316831){return _0xcd648a-_0x316831;}};{this[_0x5b6509(0x7e9)+'te'][_0x5b6509(0xe61)]['x']=_0x51f264[_0x5b6509(0xbbe)](0xc89+0xfe0+0x8*-0x38d,this[_0x5b6509(0xe61)]['x']||0x1962+-0xa56+-0x282*0x6+0.001),this[_0x5b6509(0x7e9)+'te'][_0x5b6509(0xe61)]['y']=_0x51f264[_0x5b6509(0xbbe)](-0xa5+-0x228e+0x2334,this[_0x5b6509(0xe61)]['y']||0x11d4+-0x2269+0x1095+0.001);}{this[_0x5b6509(0x7e9)+'te']['x']=0x3b8*0x4+-0x25e0+0x1*0x1700,this['_stateSpri'+'te']['y']=_0x51f264[_0x5b6509(0x15c5)](_0x51f264[_0x5b6509(0xa81)](-this[_0x5b6509(0xa68)],0xc42+0x219e+-0x2dc0),0x3*0x6ff+-0xe3c*0x1+0x661*-0x1);const _0x30ef4c=VisuMZ['BattleCore'][_0x5b6509(0x281)][_0x5b6509(0xd11)];this[_0x5b6509(0x7e9)+'te']['x']+=_0x30ef4c[_0x5b6509(0x1108)+_0x5b6509(0x1334)]??0xc*-0x1ae+0x2593+-0x116b,this[_0x5b6509(0x7e9)+'te']['y']+=_0x30ef4c[_0x5b6509(0x1108)+_0x5b6509(0xb4a)]??-0x4*0x1b3+-0x2692+0x2d5e;}},Sprite_Actor['prototype'][_0xe90fac(0xc5e)+'eOpacity']=function(){const _0x8150e6=_0xe90fac,_0x4cdec0={'JUkCt':function(_0x3e9037,_0x4b1bb9){return _0x3e9037===_0x4b1bb9;},'AsOBP':_0x8150e6(0x142c),'refgu':_0x8150e6(0xa83),'HUMAC':'portrait','ITWxG':_0x8150e6(0xea1)};if(!$gameSystem['isSideView']()&&_0x4cdec0['JUkCt'](this[_0x8150e6(0x14c0)+'r'],Sprite_Actor)){const _0x524307=Scene_Battle[_0x8150e6(0x510)][_0x8150e6(0x3a1)+'utStyle']();[_0x4cdec0[_0x8150e6(0x103b)],_0x4cdec0[_0x8150e6(0xcd)],_0x4cdec0['HUMAC'],_0x4cdec0['ITWxG']][_0x8150e6(0x79c)](_0x524307)&&(this['opacity']=-0x3*-0x6a8+-0x1*-0x12af+-0x26a7);}},Sprite_Actor[_0xe90fac(0x510)][_0xe90fac(0xff4)+_0xe90fac(0x130a)]=function(){const _0x35e09a=_0xe90fac,_0x5bd786={'aVflB':_0x35e09a(0x1348),'HsBnE':function(_0x7508a3,_0x2b38fe){return _0x7508a3===_0x2b38fe;},'PjuPT':_0x35e09a(0x10a5),'qiOgQ':'sleep','NCAnV':'escape','ybzkp':_0x35e09a(0x600),'fywVr':_0x35e09a(0xee),'KlcjX':_0x35e09a(0x547),'Euvns':_0x35e09a(0x84e),'zuulQ':_0x35e09a(0x458)},_0x49f5f0=this['_actor'];if(_0x49f5f0){if(_0x49f5f0[_0x35e09a(0x1191)+_0x35e09a(0x7c8)])return;const _0x3c332c=_0x49f5f0[_0x35e09a(0x881)+_0x35e09a(0x84a)]();if(_0x49f5f0['isInputtin'+'g']()||_0x49f5f0['isActing']())this[_0x35e09a(0xc41)+'n'](_0x5bd786['aVflB']);else{if(_0x5bd786['HsBnE'](_0x3c332c,-0x692+0x57*-0x21+0x10c*0x11))this[_0x35e09a(0xc41)+'n'](_0x5bd786[_0x35e09a(0x123d)]);else{if(_0x5bd786[_0x35e09a(0x1c3)](_0x3c332c,-0xe8*-0x4+-0x23cc+-0x3*-0xaba))this[_0x35e09a(0xc41)+'n'](_0x5bd786['qiOgQ']);else{if(this[_0x35e09a(0x888)+_0x35e09a(0x15a9)])this[_0x35e09a(0xc41)+'n'](_0x5bd786[_0x35e09a(0x13fb)]);else{if(_0x49f5f0['isCharging']())this[_0x35e09a(0xc41)+'n'](_0x5bd786[_0x35e09a(0xe72)]);else{if(_0x49f5f0[_0x35e09a(0x13a1)]())this[_0x35e09a(0xc41)+'n'](_0x5bd786[_0x35e09a(0x35f)]);else{if(_0x49f5f0['isGuard']()||_0x49f5f0[_0x35e09a(0xbb)+_0x35e09a(0xad7)]())this[_0x35e09a(0xc41)+'n'](_0x5bd786['KlcjX']);else{if(_0x5bd786[_0x35e09a(0x1c3)](_0x3c332c,0x1*0x20d8+-0x1d29+-0x3ae))this[_0x35e09a(0xc41)+'n'](_0x5bd786[_0x35e09a(0xe90)]);else{if(_0x49f5f0[_0x35e09a(0xb41)]())this['startMotio'+'n'](_0x5bd786[_0x35e09a(0x492)]);else{if(_0x49f5f0[_0x35e09a(0xff0)+'d']())this[_0x35e09a(0xc41)+'n'](_0x5bd786[_0x35e09a(0x71b)]);else _0x49f5f0[_0x35e09a(0x7f5)+_0x35e09a(0x130a)]()?this[_0x35e09a(0xc41)+'n'](_0x5bd786[_0x35e09a(0xe72)]):this[_0x35e09a(0xc41)+'n'](_0x5bd786[_0x35e09a(0x71b)]);}}}}}}}}}}},Sprite_Actor[_0xe90fac(0x510)][_0xe90fac(0xfdd)]=function(){const _0x596c2c=_0xe90fac,_0x98f5ba={'wpcph':function(_0x5e261f,_0x684b50){return _0x5e261f*_0x684b50;}},_0x32c196=-0x47*-0x77+-0x41*-0x33+-0x2dea,_0xc66b3a=_0x98f5ba['wpcph'](0x13a0+0x25a2*-0x1+0x132e,_0x32c196),_0x30b348=_0x98f5ba[_0x596c2c(0x95a)](-0x2c*0x5+0x5a6+-0x4ac,_0x32c196);this[_0x596c2c(0xae0)](_0xc66b3a,-0x1c1e+-0x1a1*0x11+0x37cf,_0x30b348);},Sprite_Actor[_0xe90fac(0x510)][_0xe90fac(0xe60)]=function(){const _0x350e16=_0xe90fac;Sprite_Battler['prototype'][_0x350e16(0xe60)][_0x350e16(0x351)](this);},Sprite_Actor[_0xe90fac(0x510)][_0xe90fac(0x8ed)+'d']=function(){const _0x188a0a=_0xe90fac;return Sprite_Battler[_0x188a0a(0x1597)+'ed'];},Sprite_Weapon[_0xe90fac(0x510)][_0xe90fac(0x1289)+_0xe90fac(0x45a)]=function(){return Sprite_Battler['_motionSpe'+'ed'];},Sprite_Actor[_0xe90fac(0x510)]['setupMotio'+'n']=function(){},Sprite_Actor[_0xe90fac(0x510)][_0xe90fac(0x11b9)+_0xe90fac(0x117c)]=function(){},Sprite_Actor['prototype'][_0xe90fac(0x54d)+_0xe90fac(0x518)]=function(){const _0x3ea28b=_0xe90fac,_0x5c3162={'fKepM':function(_0x223d8f,_0x283385){return _0x223d8f>=_0x283385;},'GTZUW':function(_0x25aa36,_0xe60eca){return _0x25aa36%_0xe60eca;},'JCExu':function(_0x1246f4,_0x4e2e4c){return _0x1246f4+_0x4e2e4c;},'cKkxE':function(_0x38363b,_0x54a00b){return _0x38363b<_0x54a00b;}};if(this[_0x3ea28b(0xa0c)]&&_0x5c3162[_0x3ea28b(0x10f8)](++this['_motionCou'+'nt'],this['motionSpee'+'d']())){if(this[_0x3ea28b(0xa0c)]['loop'])this[_0x3ea28b(0xdef)]=_0x5c3162['GTZUW'](_0x5c3162[_0x3ea28b(0x5bf)](this[_0x3ea28b(0xdef)],-0x593+-0x1*0x1c90+-0x1cc*-0x13),-0x15cb+-0xd*-0x213+-0x528);else{if(_0x5c3162['cKkxE'](this[_0x3ea28b(0xdef)],-0x1*-0x1731+-0xc5*-0x25+-0xe4*0x3a))this[_0x3ea28b(0xdef)]++;else{const _0x3dbd82=this[_0x3ea28b(0x69c)];if(_0x3dbd82)_0x3dbd82['_performDa'+_0x3ea28b(0x7c8)]=undefined;this[_0x3ea28b(0xff4)+_0x3ea28b(0x130a)]();}}this[_0x3ea28b(0xaeb)+'nt']=0x11af+0x2*-0x385+-0x6d*0x19;}},Sprite_Actor[_0xe90fac(0x510)][_0xe90fac(0x68d)+'n']=function(_0x5d403f){const _0x24c259=_0xe90fac,_0x44fde5={'URwia':'dead'};if(this[_0x24c259(0xbb8)]&&this[_0x24c259(0xbb8)]['isDead']()){this[_0x24c259(0xa0c)]=Sprite_Actor[_0x24c259(0x43d)][_0x44fde5[_0x24c259(0x114e)]];return;}const _0x56f1a1=Sprite_Actor['MOTIONS'][_0x5d403f];this[_0x24c259(0xa0c)]=_0x56f1a1,this[_0x24c259(0xaeb)+'nt']=0x142f+0x179d+-0x2bcc,this[_0x24c259(0xdef)]=0x7a9+-0x9*-0x35+-0x986;},Sprite_Actor[_0xe90fac(0x510)][_0xe90fac(0xccb)+_0xe90fac(0x117c)]=function(_0x1def0b){const _0x45ec0e=_0xe90fac;if(this[_0x45ec0e(0x48d)+_0x45ec0e(0x1346)]())return;this['adjustWeap'+_0x45ec0e(0x4d5)+_0x45ec0e(0xc6a)](),this['_weaponSpr'+_0x45ec0e(0xdf4)][_0x45ec0e(0xc70)](_0x1def0b),this['_actor'][_0x45ec0e(0x3df)+_0x45ec0e(0x117c)]();},Sprite_Actor['prototype']['adjustWeap'+'onSpriteOf'+_0xe90fac(0xc6a)]=function(){const _0x12d380=_0xe90fac,_0xba541d={'TFDEI':function(_0x251840,_0x2f2a87){return _0x251840*_0x2f2a87;}};let _0xd60b64=-(-0x20ef+0x113d+0xfc2),_0xb742dc=_0xba541d[_0x12d380(0x220)](this['height'],-0x1ed5*0x1+-0x74*0x1f+0x2ce1+0.5);const _0x7a1efc=/<SIDEVIEW WEAPON OFFSET:[ ]([\+\-]\d+),[ ]([\+\-]\d+)>/i,_0x53b900=this[_0x12d380(0xbb8)][_0x12d380(0x412)+'ts']()[_0x12d380(0x457)](_0x4b5701=>_0x4b5701&&_0x4b5701[_0x12d380(0xfee)][_0x12d380(0x3eb)](_0x7a1efc)?Number(RegExp['$1']):-0x1ef1+-0x1257+0x3148),_0x43284b=this[_0x12d380(0xbb8)]['traitObjec'+'ts']()['map'](_0x54572f=>_0x54572f&&_0x54572f[_0x12d380(0xfee)][_0x12d380(0x3eb)](_0x7a1efc)?Number(RegExp['$2']):0x14a9+-0x20e4+0xc3b);_0xd60b64=_0x53b900[_0x12d380(0x1313)]((_0x330c0e,_0x16394d)=>_0x330c0e+_0x16394d,_0xd60b64),_0xb742dc=_0x43284b[_0x12d380(0x1313)]((_0x3d2fe5,_0x223e47)=>_0x3d2fe5+_0x223e47,_0xb742dc),this[_0x12d380(0x79d)+_0x12d380(0xdf4)]['x']=_0xd60b64,this[_0x12d380(0x79d)+_0x12d380(0xdf4)]['y']=_0xb742dc,this[_0x12d380(0x79d)+_0x12d380(0xdf4)][_0x12d380(0x94)]();},Sprite_Weapon[_0xe90fac(0x510)][_0xe90fac(0xc70)]=function(_0x2c1123){const _0x5e15b8=_0xe90fac,_0x2d15f9={'ayGSa':'3|0|1|4|2'},_0x5a218f=_0x2d15f9[_0x5e15b8(0x369)][_0x5e15b8(0xab1)]('|');let _0x1e95c9=0x2f+0xc57+0xe*-0xe5;while(!![]){switch(_0x5a218f[_0x1e95c9++]){case'0':this[_0x5e15b8(0x477)+_0x5e15b8(0xfa6)]=-(-0x5*-0x369+0x82f+0x1*-0x193b);continue;case'1':this[_0x5e15b8(0xdef)]=0x270f+-0x6*-0x5d1+-0x49f5;continue;case'2':this[_0x5e15b8(0xccc)+'e']();continue;case'3':this[_0x5e15b8(0x15a2)+_0x5e15b8(0x787)]=_0x2c1123;continue;case'4':this[_0x5e15b8(0x13fc)]();continue;}break;}},Sprite_Actor[_0xe90fac(0x510)][_0xe90fac(0xa06)+'etPosition']=function(){},Sprite_Actor[_0xe90fac(0x510)][_0xe90fac(0xc81)+'d']=function(){const _0x532207=_0xe90fac,_0x56c32c=VisuMZ[_0x532207(0x118f)][_0x532207(0x281)]['ActionSequ'+_0x532207(0x16a)],_0x267411=_0x56c32c[_0x532207(0x562)+_0x532207(0x15cc)],_0x41e54e=_0x56c32c[_0x532207(0x562)+_0x532207(0x652)],_0x5b6c26=_0x56c32c['StepDurati'+'on'];this[_0x532207(0xae0)](-_0x267411,-_0x41e54e,_0x5b6c26);},VisuMZ['BattleCore']['Sprite_Act'+_0xe90fac(0x539)+'rame']=Sprite_Actor[_0xe90fac(0x510)][_0xe90fac(0xccc)+'e'],Sprite_Actor['prototype'][_0xe90fac(0xccc)+'e']=function(){const _0x586f11=_0xe90fac;this[_0x586f11(0x48d)+_0x586f11(0x1346)]()?this[_0x586f11(0x14e)+_0x586f11(0xd52)+_0x586f11(0x6cd)]():(this['applyFreez'+_0x586f11(0x650)+'mes'](),VisuMZ[_0x586f11(0x118f)]['Sprite_Act'+_0x586f11(0x539)+_0x586f11(0x149f)]['call'](this));},Sprite_Actor[_0xe90fac(0x510)][_0xe90fac(0x8eb)+_0xe90fac(0x650)+_0xe90fac(0x568)]=function(){const _0x2f5a80=_0xe90fac;if(this[_0x2f5a80(0xbb8)]&&this[_0x2f5a80(0xbb8)]['_freezeMot'+_0x2f5a80(0x6b0)]){const _0x3ad959=this[_0x2f5a80(0xbb8)][_0x2f5a80(0xc3f)+_0x2f5a80(0x6b0)];this[_0x2f5a80(0xa0c)]=Sprite_Actor['MOTIONS'][_0x3ad959['motionType']],this[_0x2f5a80(0xdef)]=_0x3ad959[_0x2f5a80(0x14e6)];const _0x4a00b0=this[_0x2f5a80(0x79d)+_0x2f5a80(0xdf4)];_0x4a00b0['freezeFram'+'e'](_0x3ad959[_0x2f5a80(0x1041)+_0x2f5a80(0x14e5)],_0x3ad959[_0x2f5a80(0x14e6)]),this[_0x2f5a80(0x11b3)+_0x2f5a80(0x4d5)+_0x2f5a80(0xc6a)]();}},Sprite_Weapon[_0xe90fac(0x510)][_0xe90fac(0x11a1)+'e']=function(_0x4f0c3b,_0x8d42ba){const _0x40224e=_0xe90fac,_0x5ded3e={'lBDqr':_0x40224e(0x259)},_0x2d6e6b=_0x5ded3e[_0x40224e(0x184)][_0x40224e(0xab1)]('|');let _0xbbbfff=0x18a9+0x1eb6+0x15*-0x2a3;while(!![]){switch(_0x2d6e6b[_0xbbbfff++]){case'0':this[_0x40224e(0xdef)]=_0x8d42ba;continue;case'1':this[_0x40224e(0x15a2)+_0x40224e(0x787)]=_0x4f0c3b;continue;case'2':this['_animation'+_0x40224e(0xfa6)]=-Infinity;continue;case'3':this[_0x40224e(0x13fc)]();continue;case'4':this[_0x40224e(0xccc)+'e']();continue;}break;}},Sprite_Enemy[_0xe90fac(0x510)][_0xe90fac(0x11d5)+'s']=function(){const _0x1f200a=_0xe90fac,_0x412a55={'ymwZL':_0x1f200a(0x84d)+_0x1f200a(0x1331)},_0x37f1d7=_0x412a55['ymwZL'][_0x1f200a(0xab1)]('|');let _0x557d93=-0xce7*-0x3+-0x25e8+-0xcd;while(!![]){switch(_0x37f1d7[_0x557d93++]){case'0':Sprite_Battler[_0x1f200a(0x510)]['initMember'+'s']['call'](this);continue;case'1':this[_0x1f200a(0x47b)+'e']=null;continue;case'2':this['createStat'+_0x1f200a(0xd77)+'e']();continue;case'3':this[_0x1f200a(0xfc9)]=![];continue;case'4':this['_enemy']=null;continue;case'5':this[_0x1f200a(0x1153)+'ation']=0x1*-0x59c+0x5*0x4e9+-0x12f1;continue;case'6':this[_0x1f200a(0x406)+'me']='';continue;case'7':this['_shake']=0x562+0x1*-0x148d+0xf2b;continue;case'8':this[_0x1f200a(0xa12)+'e']=0x25*0x20+-0x83*-0x4a+-0x2a*0x103;continue;case'9':this[_0x1f200a(0x566)+_0x1f200a(0x15e6)]();continue;}break;}},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xe5c)+_0xe90fac(0x3c6)]=Sprite_Enemy[_0xe90fac(0x510)]['update'],Sprite_Enemy[_0xe90fac(0x510)]['update']=function(){const _0x140e71=_0xe90fac;VisuMZ[_0x140e71(0x118f)][_0x140e71(0xe5c)+_0x140e71(0x3c6)]['call'](this),this['updateShad'+'owVisibili'+'ty'](),this[_0x140e71(0x1533)+_0x140e71(0xd6a)+_0x140e71(0x573)]();},Sprite_Enemy[_0xe90fac(0x510)][_0xe90fac(0x566)+_0xe90fac(0x15e6)]=function(){const _0x5298e6=_0xe90fac,_0x51605b={'Vbuuh':_0x5298e6(0xc2b)},_0x5584e9=_0x51605b[_0x5298e6(0x702)][_0x5298e6(0xab1)]('|');let _0x57c255=0x2*-0x9f0+0x1b9*0x5+0xb43*0x1;while(!![]){switch(_0x5584e9[_0x57c255++]){case'0':this['addChild'](this[_0x5298e6(0x8d1)+'e']);continue;case'1':this[_0x5298e6(0x8d1)+'e']=new Sprite();continue;case'2':this[_0x5298e6(0x15c1)+'tesToDisto'+_0x5298e6(0xebd)+'e']();continue;case'3':this[_0x5298e6(0x8d1)+'e'][_0x5298e6(0x11c2)]['x']=-0x1526+-0x1*0xd39+0x225f+0.5;continue;case'4':this[_0x5298e6(0x8d1)+'e']['anchor']['y']=-0x158f*0x1+-0x2*0x679+0x2282;continue;}break;}},Sprite_Enemy['prototype']['mainSprite']=function(){const _0x49244f=_0xe90fac;return this[_0x49244f(0x174)+_0x49244f(0x94e)]||this[_0x49244f(0x8d1)+'e']||this;},Sprite_Enemy[_0xe90fac(0x510)][_0xe90fac(0x13fc)]=function(_0x1b1efd){const _0xa42748=_0xe90fac;this[_0xa42748(0x24c)]=new Bitmap(0x17d1+0xd0a+-0x24da,0xc7b+0x32+-0xcac*0x1);if(this[_0xa42748(0x358)+'er']()){const _0x42ed33=this[_0xa42748(0x899)][_0xa42748(0x11a2)+_0xa42748(0xdcc)]();this[_0xa42748(0x24c)]=new Bitmap(_0x42ed33['width'],_0x42ed33[_0xa42748(0xa68)]),this[_0xa42748(0x8d1)+'e'][_0xa42748(0x24c)]=new Bitmap(0xc*-0x101+-0xe+0xc1b,-0x1e13+0x1*-0x2528+0x433c);}else{if($gameSystem[_0xa42748(0x53d)]()){const _0x419ae8=ImageManager[_0xa42748(0x12b4)+'y'](_0x1b1efd);_0x419ae8[_0xa42748(0x12e4)+_0xa42748(0xef)](this[_0xa42748(0x8e3)+_0xa42748(0xb37)+'oad'][_0xa42748(0x874)](this,_0x419ae8));}else{const _0x2125e3=ImageManager[_0xa42748(0x26c)](_0x1b1efd);_0x2125e3[_0xa42748(0x12e4)+_0xa42748(0xef)](this[_0xa42748(0x8e3)+_0xa42748(0xb37)+_0xa42748(0x5ab)][_0xa42748(0x874)](this,_0x2125e3));}}},Sprite_Enemy[_0xe90fac(0x510)][_0xe90fac(0x8e3)+_0xe90fac(0xb37)+'oad']=function(_0x60c63e){const _0x1710fb=_0xe90fac;this[_0x1710fb(0x8d1)+'e'][_0x1710fb(0x24c)]=_0x60c63e,this[_0x1710fb(0x24c)]=new Bitmap(_0x60c63e[_0x1710fb(0x301)],_0x60c63e[_0x1710fb(0xa68)]);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xe5c)+'my_setHue']=Sprite_Enemy[_0xe90fac(0x510)]['setHue'],Sprite_Enemy[_0xe90fac(0x510)][_0xe90fac(0x1124)]=function(_0x3c581b){const _0xd1700b=_0xe90fac;this[_0xd1700b(0x8d1)+'e']&&this['_mainSprit'+'e'][_0xd1700b(0x1124)](_0x3c581b);},VisuMZ[_0xe90fac(0x118f)]['Sprite_Ene'+_0xe90fac(0x474)+'ibility']=Sprite_Enemy[_0xe90fac(0x510)][_0xe90fac(0x47a)+_0xe90fac(0x573)],Sprite_Enemy[_0xe90fac(0x510)]['initVisibi'+'lity']=function(){const _0x25a6bc=_0xe90fac;this['allowColla'+_0x25a6bc(0x8bb)]()?VisuMZ[_0x25a6bc(0x118f)][_0x25a6bc(0xe5c)+_0x25a6bc(0x474)+_0x25a6bc(0x8ac)][_0x25a6bc(0x351)](this):(this[_0x25a6bc(0xfc9)]=!this[_0x25a6bc(0x899)][_0x25a6bc(0x1182)](),!this[_0x25a6bc(0xfc9)]&&(this[_0x25a6bc(0xfac)]=-0x10*0x10d+0x1cd*-0x5+0x19d1));},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xe5c)+'my_updateC'+_0xe90fac(0x37f)]=Sprite_Enemy[_0xe90fac(0x510)][_0xe90fac(0xb24)+'apse'],Sprite_Enemy['prototype'][_0xe90fac(0xb24)+_0xe90fac(0x6b3)]=function(){const _0x66242c=_0xe90fac;if(this[_0x66242c(0x793)+_0x66242c(0x8bb)]())VisuMZ[_0x66242c(0x118f)][_0x66242c(0xe5c)+'my_updateC'+_0x66242c(0x37f)][_0x66242c(0x351)](this);},Sprite_Enemy[_0xe90fac(0x510)][_0xe90fac(0xccc)+'e']=function(){const _0x3ffe2e=_0xe90fac,_0x55b860={'HkGmE':function(_0x1bf686,_0x1c9170){return _0x1bf686===_0x1c9170;},'OgQpq':'bossCollap'+'se'};Sprite_Battler[_0x3ffe2e(0x510)][_0x3ffe2e(0xccc)+'e']['call'](this);const _0x42188a=this[_0x3ffe2e(0x4a7)]()||this;if(!_0x42188a)return;!_0x42188a[_0x3ffe2e(0x24c)]&&(_0x42188a['bitmap']=new Bitmap(this['width']||-0x23a1+-0x19a2+0x3d44,this['height']||0x24e1+-0x713*0x1+-0x9ef*0x3));if(_0x55b860[_0x3ffe2e(0x1246)](this[_0x3ffe2e(0x47b)+'e'],_0x55b860[_0x3ffe2e(0x8e9)]))this[_0x3ffe2e(0x8d1)+'e'][_0x3ffe2e(0xf6)](0x1fe1+0x20*-0xd+-0x60d*0x5,-0x1*0x1dc8+-0x76d+0x2535,this[_0x3ffe2e(0x8d1)+'e'][_0x3ffe2e(0x301)]||0xdf3+-0x1d18+0xe*0x115,this[_0x3ffe2e(0x1153)+_0x3ffe2e(0x1094)]);else{let _0x1c88cd=-0x55*0x1+-0x59*-0x4f+-0x1b21;if(_0x42188a&&_0x42188a['bitmap'])_0x1c88cd=_0x42188a[_0x3ffe2e(0x24c)]['width'];let _0x5697c7=-0x2673+0x82+0x25f2;if(this[_0x3ffe2e(0x24c)])_0x5697c7=this['bitmap'][_0x3ffe2e(0xa68)];_0x42188a[_0x3ffe2e(0xf6)](-0x4e1*0x7+-0x1668+-0x388f*-0x1,0x1be9+-0x1ecc+0x2e3,_0x1c88cd,_0x5697c7);}},VisuMZ[_0xe90fac(0x118f)]['Sprite_Ene'+_0xe90fac(0x68b)+'ossCollaps'+'e']=Sprite_Enemy['prototype'][_0xe90fac(0x1362)+_0xe90fac(0x1197)],Sprite_Enemy[_0xe90fac(0x510)][_0xe90fac(0x1362)+_0xe90fac(0x1197)]=function(){const _0x249cb4=_0xe90fac;if(this[_0x249cb4(0x793)+_0x249cb4(0x8bb)]())VisuMZ[_0x249cb4(0x118f)][_0x249cb4(0xe5c)+_0x249cb4(0x68b)+_0x249cb4(0x51f)+'e']['call'](this);},Sprite_Enemy[_0xe90fac(0x510)]['isMoving']=function(){const _0x5d936c=_0xe90fac;return Sprite_Battler[_0x5d936c(0x510)][_0x5d936c(0xd42)][_0x5d936c(0x351)](this);},VisuMZ['BattleCore'][_0xe90fac(0xe5c)+'my_updateS'+_0xe90fac(0xf3b)]=Sprite_Enemy[_0xe90fac(0x510)][_0xe90fac(0x14e)+_0xe90fac(0x15a9)],Sprite_Enemy[_0xe90fac(0x510)]['updateStat'+_0xe90fac(0x15a9)]=function(){const _0x382d38=_0xe90fac;VisuMZ[_0x382d38(0x118f)]['Sprite_Ene'+'my_updateS'+_0x382d38(0xf3b)][_0x382d38(0x351)](this),this['updateStat'+'eSpriteBat'+_0x382d38(0x80e)]();},Sprite_Enemy['prototype'][_0xe90fac(0x14e)+'eSpriteBat'+_0xe90fac(0x80e)]=function(){const _0x3d879e=_0xe90fac,_0x3437a8={'PjbcF':function(_0x39ca96,_0x6ac4a7){return _0x39ca96-_0x6ac4a7;},'QcwCU':function(_0x175357,_0x326c84){return _0x175357/_0x326c84;},'UNiCv':function(_0x50c7cd,_0x35fa18){return _0x50c7cd/_0x35fa18;}},_0x2ff3=VisuMZ[_0x3d879e(0x118f)][_0x3d879e(0x281)][_0x3d879e(0x105f)];if(_0x2ff3['NameAttach'+_0x3d879e(0x4d3)]&&!_0x2ff3['NameLegacy']){this[_0x3d879e(0xf12)+_0x3d879e(0x15e6)][_0x3d879e(0xfac)]=0x1118+-0x2*0xc85+0x7f2;return;}this['_stateIcon'+'Sprite']['x']=0x1*-0x335+0x3*0xba5+-0x1fba,this[_0x3d879e(0xf12)+_0x3d879e(0x15e6)]['x']+=this[_0x3d879e(0xbb8)]['battleUIOf'+_0x3d879e(0x53c)]();let _0x383b87=0x110*0x2+-0x1*0x1219+0xffa;if(this[_0x3d879e(0x24c)])_0x383b87=this[_0x3d879e(0x24c)][_0x3d879e(0xa68)];this[_0x3d879e(0xf12)+_0x3d879e(0x15e6)]['y']=_0x3437a8['PjbcF'](_0x3437a8[_0x3d879e(0x1433)](-_0x383b87,this[_0x3d879e(0xf12)+_0x3d879e(0x15e6)][_0x3d879e(0xa68)]),-0x8*0x490+-0xd31+-0x31b5*-0x1),this[_0x3d879e(0xf12)+_0x3d879e(0x15e6)]['y']+=this['_battler'][_0x3d879e(0xb31)+_0x3d879e(0xebf)](),this[_0x3d879e(0xf12)+_0x3d879e(0x15e6)][_0x3d879e(0xe61)]['x']=_0x3437a8['QcwCU'](-0x2540+-0x2074+0x45b5*0x1,this[_0x3d879e(0xe61)]['x']||-0x116a+0x644+0xb26+0.001),this[_0x3d879e(0xf12)+_0x3d879e(0x15e6)][_0x3d879e(0xe61)]['y']=_0x3437a8[_0x3d879e(0x685)](-0x145+-0x1798+0x84a*0x3,this['scale']['y']||-0x1286+0x5d5*0x3+-0x107*-0x1+0.001),this['hasSvBattl'+'er']()&&(this[_0x3d879e(0x1ee)+_0x3d879e(0x15e6)]['_stateSpri'+'te'][_0x3d879e(0xe61)]['x']=_0x3437a8[_0x3d879e(0x685)](-(0x21d1+0x2e*-0x11+0xf61*-0x2),this[_0x3d879e(0xe61)]['x']||0x26b*-0x1+-0x1bba*0x1+0x1e25+0.001),this[_0x3d879e(0x1ee)+_0x3d879e(0x15e6)]['_stateSpri'+'te'][_0x3d879e(0xe61)]['y']=_0x3437a8['UNiCv'](-0x45*0x30+0x1*0x1a1b+-0xa*0x151,this[_0x3d879e(0xe61)]['y']||-0x5*-0x1d3+0x99*-0x2+-0x7ed+0.001));},Sprite_Enemy[_0xe90fac(0x510)][_0xe90fac(0x1533)+_0xe90fac(0xd6a)+_0xe90fac(0x573)]=function(){const _0x5378cb=_0xe90fac;this['_battler']&&this[_0x5378cb(0xbb8)][_0x5378cb(0x1533)+_0x5378cb(0xd6a)+_0x5378cb(0x573)]();},VisuMZ[_0xe90fac(0x118f)]['Sprite_Ene'+_0xe90fac(0x599)+_0xe90fac(0x5df)]=Sprite_Enemy[_0xe90fac(0x510)][_0xe90fac(0x117e)],Sprite_Enemy[_0xe90fac(0x510)]['setBattler']=function(_0x3d7106){const _0x3eb04b=_0xe90fac;VisuMZ[_0x3eb04b(0x118f)][_0x3eb04b(0xe5c)+'my_setBatt'+_0x3eb04b(0x5df)][_0x3eb04b(0x351)](this,_0x3d7106),this[_0x3eb04b(0x1d5)+_0x3eb04b(0x1141)](_0x3d7106);},Sprite_Enemy[_0xe90fac(0x510)][_0xe90fac(0x1d5)+_0xe90fac(0x1141)]=function(_0x3a55cf){const _0x4308e1=_0xe90fac;!this['_svBattler'+'Sprite']&&(this[_0x4308e1(0x1ee)+_0x4308e1(0x15e6)]=new Sprite_SvEnemy(_0x3a55cf),this[_0x4308e1(0x15c1)+'tesToDisto'+'rtionSprit'+'e']()),this[_0x4308e1(0x1ee)+_0x4308e1(0x15e6)][_0x4308e1(0x117e)](_0x3a55cf);},Sprite_Enemy[_0xe90fac(0x510)][_0xe90fac(0x358)+'er']=function(){const _0x22808b=_0xe90fac;return this['_enemy']&&this[_0x22808b(0x899)][_0x22808b(0x358)+'er']();},Sprite_Enemy[_0xe90fac(0x510)][_0xe90fac(0x793)+'pse']=function(){const _0x23791e=_0xe90fac;return this[_0x23791e(0x358)+'er']()?this[_0x23791e(0x899)]['allowColla'+_0x23791e(0x8bb)]():!![];},Sprite_Enemy[_0xe90fac(0x510)]['refreshMot'+'ion']=function(){const _0x3a0406=_0xe90fac;this[_0x3a0406(0x358)+'er']()&&this[_0x3a0406(0x1ee)+_0x3a0406(0x15e6)][_0x3a0406(0xff4)+'ion']();},Sprite_Enemy[_0xe90fac(0x510)][_0xe90fac(0x68d)+'n']=function(_0x2b59cd){const _0x6386a2=_0xe90fac;if(this[_0x6386a2(0x358)+'er']())this[_0x6386a2(0x1ee)+_0x6386a2(0x15e6)][_0x6386a2(0x68d)+'n'](_0x2b59cd);},Sprite_Enemy['prototype'][_0xe90fac(0xccb)+_0xe90fac(0x117c)]=function(_0x8119cf){const _0x4996e6=_0xe90fac;if(this['hasSvBattl'+'er']())this[_0x4996e6(0x1ee)+_0x4996e6(0x15e6)][_0x4996e6(0xccb)+'nAnimation'](_0x8119cf);},Sprite_Enemy[_0xe90fac(0x510)][_0xe90fac(0xc81)+'d']=function(){const _0x19124c=_0xe90fac,_0x4e5915=VisuMZ[_0x19124c(0x118f)]['Settings']['ActionSequ'+_0x19124c(0x16a)],_0x370911=_0x4e5915[_0x19124c(0x562)+'ceX'],_0x1d0d6f=_0x4e5915[_0x19124c(0x562)+_0x19124c(0x652)],_0x5e2127=_0x4e5915[_0x19124c(0x119b)+'on'];this[_0x19124c(0xae0)](_0x370911,_0x1d0d6f,_0x5e2127);};function Sprite_SvEnemy(){const _0x3ae00f=_0xe90fac;this[_0x3ae00f(0xc68)](...arguments);}Sprite_SvEnemy[_0xe90fac(0x510)]=Object[_0xe90fac(0xc3d)](Sprite_Actor[_0xe90fac(0x510)]),Sprite_SvEnemy['prototype']['constructo'+'r']=Sprite_SvEnemy,Sprite_SvEnemy['prototype'][_0xe90fac(0xc68)]=function(_0x15a6a1){const _0x433479=_0xe90fac;Sprite_Actor['prototype'][_0x433479(0xc68)][_0x433479(0x351)](this,_0x15a6a1),this[_0x433479(0xe61)]['x']=-(0x288+-0x1*0x171a+0x1*0x1493),this[_0x433479(0x7e9)+'te'][_0x433479(0xe61)]['x']=-(0x1734+0x159d+-0x3*0xef0);},Sprite_SvEnemy[_0xe90fac(0x510)][_0xe90fac(0x9e2)+_0xe90fac(0xa2e)]=function(){},Sprite_SvEnemy[_0xe90fac(0x510)][_0xe90fac(0x1cd)+_0xe90fac(0xcf1)]=function(){},Sprite_SvEnemy[_0xe90fac(0x510)][_0xe90fac(0x43e)+'me']=function(_0x4c9d30){},Sprite_SvEnemy[_0xe90fac(0x510)][_0xe90fac(0xa52)+'ow']=function(){},Sprite_SvEnemy[_0xe90fac(0x510)][_0xe90fac(0xa52)+_0xe90fac(0x1033)]=function(){},Sprite_SvEnemy['prototype']['updateStat'+_0xe90fac(0x15a9)]=function(){const _0x2aa39b=_0xe90fac;this[_0x2aa39b(0x7e9)+'te'][_0x2aa39b(0xf56)]=![];},Sprite_SvEnemy[_0xe90fac(0x510)]['updateBitm'+'ap']=function(){const _0x31970e=_0xe90fac,_0x52b0e2={'aovgw':function(_0x257049,_0x4e60bc){return _0x257049!==_0x4e60bc;}};Sprite_Battler[_0x31970e(0x510)][_0x31970e(0x105c)+'ap'][_0x31970e(0x351)](this);const _0x5a752a=this['_actor'][_0x31970e(0x298)+_0x31970e(0xd7d)]();_0x52b0e2[_0x31970e(0xb22)](this[_0x31970e(0x406)+'me'],_0x5a752a)&&(this[_0x31970e(0x406)+'me']=_0x5a752a,this[_0x31970e(0x8d1)+'e']['bitmap']=ImageManager[_0x31970e(0xc91)+'r'](_0x5a752a)),this[_0x31970e(0x8d1)+'e']&&this[_0x31970e(0x8d1)+'e'][_0x31970e(0x24c)]&&this[_0x31970e(0xbb8)]&&(_0x52b0e2[_0x31970e(0xb22)](this['_mainSprit'+'e'][_0x31970e(0x24c)]['smooth'],this['_battler'][_0x31970e(0x15fe)+_0x31970e(0xa73)]())&&(this[_0x31970e(0x8d1)+'e'][_0x31970e(0x24c)][_0x31970e(0xb1f)]=this[_0x31970e(0xbb8)][_0x31970e(0x15fe)+_0x31970e(0xa73)]()));},Sprite_SvEnemy[_0xe90fac(0x510)][_0xe90fac(0xfdd)]=function(){},Sprite_SvEnemy[_0xe90fac(0x510)][_0xe90fac(0xae0)]=function(_0x50a239,_0x5196a0,_0x121878){const _0x12be57=_0xe90fac;if(this[_0x12be57(0xb74)])this['parent'][_0x12be57(0xae0)](_0x50a239,_0x5196a0,_0x121878);},Sprite_SvEnemy['prototype'][_0xe90fac(0xff4)+_0xe90fac(0x130a)]=function(){const _0x1d5c89=_0xe90fac,_0x22e268={'bYGqA':'walk','lgFZZ':function(_0x1d11fc,_0x18d62b){return _0x1d11fc===_0x18d62b;},'ayWKQ':_0x1d5c89(0x10a5),'goTds':function(_0x5ddd6d,_0x4b7aab){return _0x5ddd6d===_0x4b7aab;},'QZgHi':_0x1d5c89(0x232),'vJgUn':_0x1d5c89(0xee),'xidpR':'guard','AxpaT':function(_0xf1ee0c,_0x2779b7){return _0xf1ee0c===_0x2779b7;},'Kjnow':_0x1d5c89(0x84e),'KCaCU':_0x1d5c89(0x458)},_0x4e7200=this['_actor'];if(_0x4e7200){const _0x33b170=_0x4e7200[_0x1d5c89(0x881)+_0x1d5c89(0x84a)]();if(_0x4e7200[_0x1d5c89(0x15f0)+'g']()||_0x4e7200[_0x1d5c89(0xaff)]())this['startMotio'+'n'](_0x22e268[_0x1d5c89(0x2a6)]);else{if(_0x22e268[_0x1d5c89(0x815)](_0x33b170,-0x65e+0x2b*0x3d+-0x16*0x2d))this[_0x1d5c89(0xc41)+'n'](_0x22e268[_0x1d5c89(0xac2)]);else{if(_0x22e268['goTds'](_0x33b170,-0x207d+0xde1+0x1*0x129e))this[_0x1d5c89(0xc41)+'n'](_0x22e268[_0x1d5c89(0x902)]);else{if(_0x4e7200[_0x1d5c89(0x13a1)]())this[_0x1d5c89(0xc41)+'n'](_0x22e268[_0x1d5c89(0x2b1)]);else{if(_0x4e7200[_0x1d5c89(0x123e)]()||_0x4e7200[_0x1d5c89(0xbb)+_0x1d5c89(0xad7)]())this[_0x1d5c89(0xc41)+'n'](_0x22e268[_0x1d5c89(0xeab)]);else{if(_0x22e268[_0x1d5c89(0x141d)](_0x33b170,0x11dd+-0xb08*0x3+0xf3c))this['startMotio'+'n'](_0x22e268[_0x1d5c89(0x1497)]);else{if(_0x4e7200[_0x1d5c89(0xb41)]())this['startMotio'+'n'](_0x22e268['KCaCU']);else _0x4e7200[_0x1d5c89(0xff0)+'d']()?this[_0x1d5c89(0xc41)+'n'](_0x22e268[_0x1d5c89(0x2a6)]):this[_0x1d5c89(0xc41)+'n'](_0x4e7200['svBattlerD'+_0x1d5c89(0xdcc)]()[_0x1d5c89(0x2d4)]||_0x22e268[_0x1d5c89(0x2a6)]);}}}}}}}},Sprite_SvEnemy[_0xe90fac(0x510)][_0xe90fac(0x319)+_0xe90fac(0x1580)]=function(){const _0x5dfbf8=_0xe90fac,_0x42a5b2={'nufPo':function(_0x89a779,_0x57931b){return _0x89a779===_0x57931b;}};return this['parent']?_0x42a5b2['nufPo'](this[_0x5dfbf8(0xb74)][_0x5dfbf8(0x1062)],-0x3cc+0x3*0xae7+-0x1ce9*0x1)&&_0x42a5b2[_0x5dfbf8(0x1306)](this[_0x5dfbf8(0xb74)][_0x5dfbf8(0x10cb)],0xccd+-0xa*0x362+-0x1*-0x1507):!![];},Sprite_SvEnemy[_0xe90fac(0x510)][_0xe90fac(0xe81)]=function(){},VisuMZ[_0xe90fac(0x118f)]['Sprite_Ani'+_0xe90fac(0x769)+_0xe90fac(0xc2d)+_0xe90fac(0x3f4)]=Sprite_Animation['prototype']['targetSpri'+'tePosition'],Sprite_Animation[_0xe90fac(0x510)][_0xe90fac(0x1d8)+'tePosition']=function(_0x15f670){const _0x2809eb=_0xe90fac;return _0x15f670[_0x2809eb(0x174)+_0x2809eb(0x94e)]?this['targetDist'+'ortionSpri'+_0x2809eb(0xd85)](_0x15f670):VisuMZ[_0x2809eb(0x118f)]['Sprite_Ani'+'mation_tar'+_0x2809eb(0xc2d)+_0x2809eb(0x3f4)][_0x2809eb(0x351)](this,_0x15f670);},Sprite_Animation['prototype'][_0xe90fac(0x13f0)+_0xe90fac(0xaf4)+'tePosition']=function(_0x1c4d0d){const _0x8c35e4=_0xe90fac,_0x5db00d={'UAFdi':function(_0x46b2c8,_0x73f2f2){return _0x46b2c8+_0x73f2f2;},'PrSYL':function(_0x4fc77d,_0x5dc5cc){return _0x4fc77d+_0x5dc5cc;}};let _0x901e7=_0x1c4d0d['x'],_0x405a14=_0x1c4d0d['y'],_0xb13f9=_0x1c4d0d[_0x8c35e4(0xa68)],_0x32190d=_0x1c4d0d[_0x8c35e4(0x174)+_0x8c35e4(0x94e)]['scale']['y'];_0x1c4d0d['x']=_0x5db00d[_0x8c35e4(0x3db)](_0x1c4d0d[_0x8c35e4(0x156)],_0x1c4d0d[_0x8c35e4(0x945)+_0x8c35e4(0xb28)]()),_0x1c4d0d['y']=_0x5db00d[_0x8c35e4(0x984)](_0x1c4d0d[_0x8c35e4(0x1098)],_0x1c4d0d[_0x8c35e4(0x945)+'ionY']()),_0x1c4d0d['height']*=_0x32190d;let _0x213df0=VisuMZ[_0x8c35e4(0x118f)][_0x8c35e4(0x493)+_0x8c35e4(0x769)+_0x8c35e4(0xc2d)+_0x8c35e4(0x3f4)]['call'](this,_0x1c4d0d);return _0x1c4d0d['x']=_0x901e7,_0x1c4d0d['y']=_0x405a14,_0x1c4d0d[_0x8c35e4(0xa68)]=_0xb13f9,_0x213df0;},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x493)+_0xe90fac(0xd05)+_0xe90fac(0xdf3)+'ion']=Sprite_AnimationMV['prototype'][_0xe90fac(0xe9f)+_0xe90fac(0x1580)],Sprite_AnimationMV['prototype'][_0xe90fac(0xe9f)+'tion']=function(){const _0x20fb02=_0xe90fac,_0x634d3f={'stZmJ':function(_0x3bb957,_0x4f3dc7){return _0x3bb957===_0x4f3dc7;},'zLfsY':function(_0x57d158,_0x4a82ea){return _0x57d158/_0x4a82ea;}};VisuMZ[_0x20fb02(0x118f)]['Sprite_Ani'+'mationMV_u'+'pdatePosit'+'ion']['call'](this);if(!SceneManager[_0x20fb02(0x11be)+'tle']())return;if(_0x634d3f[_0x20fb02(0xbd2)](this[_0x20fb02(0x477)][_0x20fb02(0x1368)],0x13*-0x4a+-0x1*0x165b+-0x6f7*-0x4))this['x']=Math['round'](_0x634d3f[_0x20fb02(0xd4b)](Graphics[_0x20fb02(0x3dc)],-0xf47+0x1f6*0x10+-0x1017)),this['y']=Math[_0x20fb02(0x10a1)](_0x634d3f[_0x20fb02(0xd4b)](Graphics[_0x20fb02(0x7b7)],-0x449*0x1+-0x1*0xaac+-0x3*-0x4fd));else{if(this['battleStat'+'usSprite'])return;}},Sprite_Damage[_0xe90fac(0x510)][_0xe90fac(0x15e2)+'eCore']=function(_0x583908){const _0x2bf420=_0xe90fac,_0x3341bb={'dfrkY':function(_0x2a1eaf,_0x2d3d6b){return _0x2a1eaf>=_0x2d3d6b;},'lUamZ':function(_0x498f6f,_0xf4910f){return _0x498f6f!==_0xf4910f;}},_0x59f8a8=_0x583908[_0x2bf420(0x1008)+_0x2bf420(0x811)]()||_0x583908[_0x2bf420(0x1c5)]();if(_0x59f8a8[_0x2bf420(0x324)]||_0x59f8a8[_0x2bf420(0x49a)])this[_0x2bf420(0x53f)]=-0x1d73+0xc2f*-0x2+-0x35d1*-0x1,this['createMiss']();else{if(_0x59f8a8[_0x2bf420(0xf67)])this[_0x2bf420(0x53f)]=_0x3341bb['dfrkY'](_0x59f8a8[_0x2bf420(0x4da)],0x38*-0x45+-0x16f*-0x10+-0x7d8)?-0x5*0x647+0x2bc*-0xc+0x4033:0x1*0x19a3+0x827+-0x21c9,this[_0x2bf420(0x60c)+'ts'](_0x59f8a8[_0x2bf420(0x4da)]);else _0x583908[_0x2bf420(0xb30)]()&&_0x3341bb['lUamZ'](_0x59f8a8['mpDamage'],0x5*0x705+-0x1b04+0x1*-0x815)&&(this['_colorType']=_0x3341bb['dfrkY'](_0x59f8a8['mpDamage'],-0x2*-0x10b2+-0x118+-0x204c)?-0x1238+-0x2037+0x3271:0x240c+-0x13*0x10d+-0x1012,this['createDigi'+'ts'](_0x59f8a8[_0x2bf420(0x1381)]));}_0x59f8a8[_0x2bf420(0x2af)]&&this[_0x2bf420(0x472)+_0x2bf420(0xc98)]();},Sprite_Damage[_0xe90fac(0x510)][_0xe90fac(0xc70)]=function(_0xe93d77){},Sprite_Damage[_0xe90fac(0x510)]['createDigi'+'ts']=function(_0x2a8936){const _0xb411ea=_0xe90fac,_0x4c109e={'NXMJy':function(_0x2c1507,_0x4736ea){return _0x2c1507*_0x4736ea;},'lgEuw':function(_0xdf8b56,_0x30ba96){return _0xdf8b56<_0x30ba96;},'tfeUu':_0xb411ea(0x8dd),'didBM':function(_0x10cb56,_0x4772bf){return _0x10cb56-_0x4772bf;},'RSImk':function(_0x3e2bf2,_0x38559e){return _0x3e2bf2/_0x38559e;},'qWhXp':function(_0x3e2758,_0x332dc1){return _0x3e2758-_0x332dc1;}};let _0x1e6da3=this[_0xb411ea(0xa63)+'ng'](_0x2a8936);const _0x2eaa91=this[_0xb411ea(0xe10)](),_0xaed97b=Math[_0xb411ea(0x12be)](_0x4c109e[_0xb411ea(0x5c8)](_0x2eaa91,-0x1f32+0x17c+-0x1db6*-0x1+0.75));for(let _0x570915=0x146f+0x1695+-0xac1*0x4;_0x4c109e[_0xb411ea(0x3bd)](_0x570915,_0x1e6da3[_0xb411ea(0x1268)]);_0x570915++){const _0x427a9c=this[_0xb411ea(0x9d)+'dSprite'](_0xaed97b,_0x2eaa91);_0x427a9c[_0xb411ea(0x24c)][_0xb411ea(0xa07)](_0x1e6da3[_0x570915],-0x1*0x647+-0x25b3+0x2bfa,-0x1*-0x1e55+0x1a*0xa1+-0x2eaf,_0xaed97b,_0x2eaa91,_0x4c109e[_0xb411ea(0x1b6)]),_0x427a9c['x']=_0x4c109e['NXMJy'](_0x4c109e[_0xb411ea(0x31f)](_0x570915,_0x4c109e[_0xb411ea(0x105e)](_0x4c109e[_0xb411ea(0x1221)](_0x1e6da3[_0xb411ea(0x1268)],0x1a1f*-0x1+-0x1*-0x1a2f+-0xf),-0xd15+0x2514+0x45*-0x59)),_0xaed97b),_0x427a9c['dy']=-_0x570915;}},Sprite_Damage[_0xe90fac(0x510)]['createStri'+'ng']=function(_0xb6567c){const _0x3cf1b5=_0xe90fac,_0x30ead6={'KQMdU':'-%1','vKTuN':function(_0x40dca5,_0x2a312f){return _0x40dca5===_0x2a312f;},'JLYYv':_0x3cf1b5(0xd0c),'DGSTR':_0x3cf1b5(0x110c),'SUsRm':_0x3cf1b5(0x14bc)};let _0x2748b8=Math[_0x3cf1b5(0x5cc)](_0xb6567c)[_0x3cf1b5(0x950)]();this[_0x3cf1b5(0x1393)+_0x3cf1b5(0x27d)]()&&(_0x2748b8=VisuMZ[_0x3cf1b5(0x1a1)+'s'](_0x2748b8));const _0x2b8193=VisuMZ['BattleCore']['Settings'][_0x3cf1b5(0x7d7)];let _0x23bff5='',_0x422dd4='';switch(this['_colorType']){case 0x21fc+-0x16ab+0x1*-0xb51:_0x23bff5=_0x2b8193[_0x3cf1b5(0x106a)+'t']||_0x30ead6[_0x3cf1b5(0x9c5)],_0x422dd4=TextManager['hp'];if(_0x30ead6[_0x3cf1b5(0x295)](_0xb6567c,0x1b*-0x89+-0x37*-0x7d+-0xc68))_0x23bff5='%1';break;case 0x9e9*0x1+-0xaa6+-0xa*-0x13:_0x23bff5=_0x2b8193[_0x3cf1b5(0x28e)+'mt']||_0x30ead6[_0x3cf1b5(0x123c)],_0x422dd4=TextManager['hp'];break;case 0x476*0x8+0x11b3*0x2+0x2*-0x238a:_0x23bff5=_0x2b8193[_0x3cf1b5(0xddb)+'t']||_0x30ead6[_0x3cf1b5(0xf99)],_0x422dd4=TextManager['mp'];break;case 0x1368*-0x2+-0xbe7+0x2*0x195d:_0x23bff5=_0x2b8193['mpHealingF'+'mt']||_0x30ead6[_0x3cf1b5(0x9e1)],_0x422dd4=TextManager['mp'];break;}return _0x23bff5[_0x3cf1b5(0xeb8)](_0x2748b8,_0x422dd4)[_0x3cf1b5(0x808)]();},Sprite_Damage['prototype'][_0xe90fac(0x1393)+'ouping']=function(){const _0xfd674e=_0xe90fac;return Imported[_0xfd674e(0x155e)+_0xfd674e(0x100d)]?VisuMZ[_0xfd674e(0x642)][_0xfd674e(0x281)]['QoL'][_0xfd674e(0x10d3)+_0xfd674e(0x1459)+'prites']:![];},Sprite_Damage[_0xe90fac(0x510)][_0xe90fac(0x472)+'calEffect']=function(){const _0x9a13b1=_0xe90fac,_0x55160c=VisuMZ[_0x9a13b1(0x118f)][_0x9a13b1(0x281)][_0x9a13b1(0x7d7)];_0x55160c[_0x9a13b1(0x1349)+_0x9a13b1(0x1380)]=_0x55160c[_0x9a13b1(0x1349)+_0x9a13b1(0x1380)]||[-0x9c*0x2d+-0x1462+0x2fce,-0x8de+0x5be+-0x50*-0xa,-0x1213+0x5f5+0xc1e,-0x161f*0x1+0x4bd+0x2*0x8b1],this[_0x9a13b1(0xfe9)+'r']=_0x55160c[_0x9a13b1(0x1349)+_0x9a13b1(0x1380)][_0x9a13b1(0x77f)](-0x1cf0+0x1867+-0x2b*-0x1b),this['_flashDura'+_0x9a13b1(0x1580)]=_0x55160c[_0x9a13b1(0x1460)+_0x9a13b1(0x796)]||-0xec+-0x533+-0x2*-0x310;},Sprite_Damage[_0xe90fac(0x510)][_0xe90fac(0x866)+_0xe90fac(0x1f9)]=function(_0x9bb6d9,_0x443cb3){const _0x43e7b7=_0xe90fac,_0x358b95={'fICqO':function(_0xd112f6,_0x211d59){return _0xd112f6*_0x211d59;},'ygHqd':_0x43e7b7(0x8dd)};this[_0x43e7b7(0xfe9)+'r']=_0x443cb3[_0x43e7b7(0x76e)]||[0x263+0x5*-0x209+-0x3e5*-0x2,0x210b+0x6fb+-0x2806,0x2*0xcdd+0x1bb*-0x11+-0x7*-0x87,0x1a4c+0x1d16+-0x342*0x11],this['_flashColo'+'r']=JsonEx[_0x43e7b7(0x2f7)+'py'](this[_0x43e7b7(0xfe9)+'r']),this[_0x43e7b7(0x1158)+'tion']=_0x443cb3[_0x43e7b7(0xbf8)+_0x43e7b7(0x130a)]||0x3*-0x1f3+0x8ee+-0x315;const _0x408a18=this[_0x43e7b7(0xe10)](),_0x55e11c=Math['floor'](_0x358b95['fICqO'](_0x408a18,-0x23bd+-0x6e5+0x2ac0)),_0x1a5bb6=this['createChil'+_0x43e7b7(0x2b8)](_0x55e11c,_0x408a18);_0x1a5bb6['bitmap'][_0x43e7b7(0x5a9)]=ColorManager['getColor'](_0x443cb3['textColor']),_0x1a5bb6[_0x43e7b7(0x24c)][_0x43e7b7(0xa07)](_0x9bb6d9,0x1*-0x24b+-0xc89+0x2*0x76a,0x7*0x3a9+0x1883+-0x3222,_0x55e11c,_0x408a18,_0x358b95[_0x43e7b7(0xc20)]),_0x1a5bb6['dy']=0x7ce+-0x1*0x1b42+0x1374;},Sprite_Damage['prototype'][_0xe90fac(0x2ee)+_0xe90fac(0xc7)]=function(_0x556880,_0x17f63b,_0xf3e699){const _0x240d48=_0xe90fac,_0x5f2731={'zgDCV':function(_0x220384,_0x35320d){return _0x220384*_0x35320d;},'BTFUK':function(_0x3bac04,_0x5a8808){return _0x3bac04/_0x5a8808;},'akOct':function(_0x4b5d1d,_0x396582){return _0x4b5d1d+_0x396582;},'vNyAX':function(_0x34f5ef,_0x51d7ca){return _0x34f5ef-_0x51d7ca;},'RoAYb':'center','MrSmk':function(_0x2f1cea,_0x40705e){return _0x2f1cea/_0x40705e;},'XCsco':function(_0x339fb6,_0x5df7aa){return _0x339fb6/_0x5df7aa;},'mBxUg':_0x240d48(0x424),'ItMix':function(_0x22d3b3,_0x167c60){return _0x22d3b3%_0x167c60;},'YhUec':function(_0x1504c3,_0x2e0a77){return _0x1504c3*_0x2e0a77;}},_0x5cfd94=Math['max'](this[_0x240d48(0xe10)](),ImageManager[_0x240d48(0xd1d)]),_0x5e32cf=Math[_0x240d48(0x12be)](_0x5f2731[_0x240d48(0x782)](_0x5cfd94,-0x50*0x3e+0x745+0x1*0xc39)),_0x1a5057=this[_0x240d48(0x9d)+'dSprite'](_0x5e32cf,_0x5cfd94),_0x29bbb4=_0x5f2731[_0x240d48(0x965)](ImageManager[_0x240d48(0x172)],0x1fc3*0x1+-0x1c43+-0x37e),_0x59be73=_0x1a5057[_0x240d48(0x24c)][_0x240d48(0x101a)+_0x240d48(0x11d3)](_0x5f2731[_0x240d48(0x60d)](_0x17f63b,'\x20'));_0x1a5057[_0x240d48(0x24c)][_0x240d48(0x5a9)]=ColorManager[_0x240d48(0x15c0)](_0xf3e699['textColor']),_0x1a5057[_0x240d48(0x24c)][_0x240d48(0xa07)](_0x17f63b,_0x29bbb4,-0x26dc*-0x1+0x4*0x37c+-0x1b4*0x1f,_0x5f2731[_0x240d48(0x1562)](_0x5e32cf,_0x29bbb4),_0x5cfd94,_0x5f2731[_0x240d48(0x11ff)]);const _0x29d656=Math[_0x240d48(0x10a1)](_0x5f2731[_0x240d48(0x845)](_0x5f2731[_0x240d48(0x1562)](_0x5cfd94,ImageManager[_0x240d48(0xd1d)]),0xf12+-0x1*0x9e4+-0x52c)),_0x164f18=_0x5f2731[_0x240d48(0x60d)](_0x5f2731[_0x240d48(0x1562)](_0x5f2731[_0x240d48(0x1562)](_0x5f2731[_0x240d48(0xe70)](_0x5e32cf,0x278+-0x2*0x8e6+0xf56),ImageManager['iconWidth']),_0x5f2731[_0x240d48(0x845)](_0x59be73,0x2407+0x1*-0x14b0+0x311*-0x5)),_0x5f2731[_0x240d48(0xe70)](_0x29bbb4,-0x47*0x3e+-0xd9c+0x1ed0)),_0x308199=ImageManager['loadSystem'](_0x5f2731[_0x240d48(0xaaa)]),_0x7557ff=ImageManager[_0x240d48(0x172)],_0x331045=ImageManager['iconHeight'],_0x5b7554=_0x5f2731[_0x240d48(0x782)](_0x5f2731[_0x240d48(0x22d)](_0x556880,-0x1*0x1e02+-0x1d62+0x2*0x1dba),_0x7557ff),_0x37cc94=_0x5f2731[_0x240d48(0x125d)](Math[_0x240d48(0x12be)](_0x5f2731[_0x240d48(0xe70)](_0x556880,0x1e02+-0x124d+-0xba5)),_0x331045);_0x1a5057[_0x240d48(0x24c)][_0x240d48(0x1546)](_0x308199,_0x5b7554,_0x37cc94,_0x7557ff,_0x331045,_0x164f18,_0x29d656),this['_flashColo'+'r']=_0xf3e699[_0x240d48(0x76e)]||[-0x20e*-0x5+-0x2f*0xac+0x154e,0x1bc7+0x1e5*0xe+-0x364d,0x49*-0x5f+0x1*-0xb5+0x1bcc,0x1b*0x137+-0x7*-0x3ee+-0x3c4f*0x1],this[_0x240d48(0xfe9)+'r']=JsonEx['makeDeepCo'+'py'](this[_0x240d48(0xfe9)+'r']),this['_flashDura'+_0x240d48(0x1580)]=_0xf3e699[_0x240d48(0xbf8)+_0x240d48(0x130a)]||-0xc14+0x1429+-0x815,_0x1a5057['dy']=0x22fe+-0x2071+0x28d*-0x1,_0xf3e699['offsetX']&&(_0x1a5057['x']+=_0xf3e699[_0x240d48(0xed8)]),_0xf3e699[_0x240d48(0xd2a)]&&(_0x1a5057['dy']+=_0xf3e699[_0x240d48(0xd2a)]);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xfda)+_0xe90fac(0x2ab)+_0xe90fac(0xfeb)+'e']=Sprite_Damage['prototype'][_0xe90fac(0x9d)+_0xe90fac(0x2b8)],Sprite_Damage['prototype'][_0xe90fac(0x9d)+'dSprite']=function(_0x52caf1,_0x19eed8){const _0x10f1a2=_0xe90fac,_0x4df020={'KmxXv':function(_0x4a1b39,_0x18091e){return _0x4a1b39*_0x18091e;}};return _0x19eed8=Math[_0x10f1a2(0x10a1)](_0x4df020[_0x10f1a2(0x1553)](_0x19eed8,0x7*-0x2f9+0x40f*-0x3+0x20fd+0.19999999999999996)),VisuMZ[_0x10f1a2(0x118f)][_0x10f1a2(0xfda)+'age_create'+'ChildSprit'+'e']['call'](this,_0x52caf1,_0x19eed8);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x1156)+_0xe90fac(0x10d4)+_0xe90fac(0x84b)]=Sprite_StateIcon[_0xe90fac(0x510)][_0xe90fac(0xccc)+'e'],Sprite_StateIcon[_0xe90fac(0x510)][_0xe90fac(0xccc)+'e']=function(){const _0x52d450=_0xe90fac,_0x24316a={'fJQjb':function(_0x16603d,_0x1c94da){return _0x16603d>_0x1c94da;}};VisuMZ[_0x52d450(0x118f)][_0x52d450(0x1156)+'teIcon_upd'+_0x52d450(0x84b)][_0x52d450(0x351)](this),this[_0x52d450(0xfac)]=_0x24316a[_0x52d450(0x1e8)](this[_0x52d450(0x13ff)],-0x2d3*-0x1+0x677+0x4a5*-0x2)?-0x17*0x7f+0x2bd*0x8+-0x98*0x10:-0x5db+0xcf8+-0x25f*0x3;},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x15bb)+_0xe90fac(0x860)+_0xe90fac(0x1e7)]=Sprite_Weapon[_0xe90fac(0x510)][_0xe90fac(0x13fc)],Sprite_Weapon[_0xe90fac(0x510)][_0xe90fac(0x13fc)]=function(){const _0x2c28f8=_0xe90fac;VisuMZ['BattleCore'][_0x2c28f8(0x15bb)+_0x2c28f8(0x860)+_0x2c28f8(0x1e7)]['call'](this),this[_0x2c28f8(0x24c)]&&(this[_0x2c28f8(0x24c)][_0x2c28f8(0xb1f)]=VisuMZ[_0x2c28f8(0x118f)][_0x2c28f8(0x281)]['Actor'][_0x2c28f8(0x8a1)+'e']);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x7a0)+_0xe90fac(0x1154)+_0xe90fac(0xe04)]=Sprite_Gauge[_0xe90fac(0x510)][_0xe90fac(0xdd5)],Sprite_Gauge[_0xe90fac(0x510)][_0xe90fac(0xdd5)]=function(){const _0x27610a=_0xe90fac,_0x1ef376={'FlVKk':function(_0x1e1aa0,_0x2deef5){return _0x1e1aa0!==_0x2deef5;},'utFos':_0x27610a(0x1225)};return _0x1ef376[_0x27610a(0x422)](this['_statusTyp'+'e'],_0x1ef376['utFos'])?VisuMZ[_0x27610a(0x118f)][_0x27610a(0x281)][_0x27610a(0x10a9)][_0x27610a(0x35c)+'n']??0x1d87+0x508+-0x61*0x5b:VisuMZ[_0x27610a(0x118f)]['Sprite_Gau'+_0x27610a(0x1154)+_0x27610a(0xe04)][_0x27610a(0x351)](this);};function Sprite_HpGauge(){const _0x3c627b=_0xe90fac;this[_0x3c627b(0xc68)](...arguments);}Sprite_HpGauge[_0xe90fac(0x510)]=Object[_0xe90fac(0xc3d)](Sprite_Gauge[_0xe90fac(0x510)]),Sprite_HpGauge[_0xe90fac(0x510)][_0xe90fac(0x14c0)+'r']=Sprite_HpGauge,Sprite_HpGauge[_0xe90fac(0x510)][_0xe90fac(0xc68)]=function(){const _0x1727ff=_0xe90fac;Sprite_Gauge['prototype']['initialize'][_0x1727ff(0x351)](this);},Sprite_HpGauge[_0xe90fac(0x510)][_0xe90fac(0xa4a)]=function(){return-0x153*0x1d+0x1*0x1dd7+0x890;},Sprite_HpGauge['prototype'][_0xe90fac(0x979)]=function(){const _0x2e3132=_0xe90fac,_0x4af658={'dwqPZ':function(_0x3a6e1d,_0x122fef){return _0x3a6e1d(_0x122fef);}};this[_0x2e3132(0x24c)][_0x2e3132(0xf98)]();const _0x5f7e9c=this[_0x2e3132(0x49b)+'ue']();!_0x4af658[_0x2e3132(0xa14)](isNaN,_0x5f7e9c)&&this[_0x2e3132(0x126f)]();};function Sprite_EnemyName(){const _0x2a7831=_0xe90fac;this[_0x2a7831(0xc68)](...arguments);}Sprite_EnemyName[_0xe90fac(0x510)]=Object['create'](Sprite_Name['prototype']),Sprite_EnemyName[_0xe90fac(0x510)][_0xe90fac(0x14c0)+'r']=Sprite_EnemyName,Sprite_EnemyName['prototype']['initialize']=function(){const _0x2aaa55=_0xe90fac;Sprite_Name[_0x2aaa55(0x510)]['initialize'][_0x2aaa55(0x351)](this),this['createAtta'+_0x2aaa55(0xd97)+'s']();},Sprite_EnemyName['prototype'][_0xe90fac(0x11d5)+'s']=function(){const _0x2f9bfe=_0xe90fac,_0x3afa98={'LrRvS':_0x2f9bfe(0x126d)},_0x4d4e68=_0x3afa98[_0x2f9bfe(0xc16)][_0x2f9bfe(0xab1)]('|');let _0x528700=0xe9b+-0x83d*0x2+0x1df*0x1;while(!![]){switch(_0x4d4e68[_0x528700++]){case'0':this['anchor']['x']=-0x1e71+-0x6a*-0x24+-0x29*-0x61+0.5;continue;case'1':Sprite_Name[_0x2f9bfe(0x510)][_0x2f9bfe(0x11d5)+'s'][_0x2f9bfe(0x351)](this);continue;case'2':this['_linkedSpr'+'ite']=null;continue;case'3':this[_0x2f9bfe(0xfac)]=0x422+0xf73+-0x1395;continue;case'4':this[_0x2f9bfe(0x11c2)]['y']=-0x2*0x30e+-0x1*-0x1311+-0xcf5;continue;}break;}},Sprite_EnemyName['prototype']['createAtta'+_0xe90fac(0xd97)+'s']=function(){const _0x1aabc8=_0xe90fac;VisuMZ[_0x1aabc8(0x118f)][_0x1aabc8(0x281)][_0x1aabc8(0x105f)][_0x1aabc8(0x64a)+'StateIcon']&&(this[_0x1aabc8(0xf12)+_0x1aabc8(0x15e6)]=new Sprite_StateIcon(),this[_0x1aabc8(0xda3)](this[_0x1aabc8(0xf12)+_0x1aabc8(0x15e6)]));},Sprite_EnemyName[_0xe90fac(0x510)]['bitmapWidt'+'h']=function(){return Graphics['boxWidth'];},Sprite_EnemyName[_0xe90fac(0x510)][_0xe90fac(0x72a)+'ht']=function(){const _0x9de02=_0xe90fac,_0x295686={'KLvuP':function(_0x486c3a,_0x32689b){return _0x486c3a*_0x32689b;}};return this['_lineHeigh'+'t']=this['_lineHeigh'+'t']||Window_Base['prototype'][_0x9de02(0xf4b)]()||0x3*-0xcff+-0x553+0x2c74,_0x295686['KLvuP'](this[_0x9de02(0x621)+'t'],0x134f+0x89*-0x19+-0x5ea*0x1);},Sprite_EnemyName[_0xe90fac(0x510)][_0xe90fac(0xe10)]=function(){const _0xa728fd=_0xe90fac;return VisuMZ[_0xa728fd(0x118f)]['Settings']['Enemy']['NameFontSi'+'ze']||$gameSystem[_0xa728fd(0xe84)+'ze']();},Sprite_EnemyName[_0xe90fac(0x510)][_0xe90fac(0x97e)]=function(_0x1a1d69){const _0x10a538=_0xe90fac;this[_0x10a538(0xf3c)+_0x10a538(0xdf4)]=_0x1a1d69;},Sprite_EnemyName[_0xe90fac(0x510)][_0xe90fac(0x94)]=function(){const _0x5206e8=_0xe90fac,_0x4d595b={'FQdzi':'0|3|1|2|4'},_0x55eedd=_0x4d595b[_0x5206e8(0xde7)][_0x5206e8(0xab1)]('|');let _0x1ae1ec=0x330+-0x221f*-0x1+-0x254f*0x1;while(!![]){switch(_0x55eedd[_0x1ae1ec++]){case'0':Sprite_Name['prototype'][_0x5206e8(0x94)]['call'](this);continue;case'1':this['updatePosi'+'tion']();continue;case'2':this[_0x5206e8(0x994)+_0x5206e8(0xd97)+'s']();continue;case'3':this[_0x5206e8(0xd22)]();continue;case'4':this[_0x5206e8(0xbde)+_0x5206e8(0x798)]();continue;}break;}},Sprite_EnemyName[_0xe90fac(0x510)][_0xe90fac(0x979)]=function(){const _0x50806e=_0xe90fac,_0x1e6244={'gSQcu':_0x50806e(0x8dd)};this[_0x50806e(0x96b)+_0x50806e(0x56a)]=undefined;const _0x3fd830=this[_0x50806e(0x14c)](),_0x18fd22=this[_0x50806e(0xa82)+'h'](),_0x1ce655=Window_Base[_0x50806e(0x510)][_0x50806e(0xf4b)]();this[_0x50806e(0xdf2)](),this[_0x50806e(0x24c)]['clear'](),this['bitmap']['drawText'](_0x3fd830,-0xac*0x2c+-0x8b*0x23+0x1*0x3091,0x1*0x22f5+0x1375*0x1+-0x366a,_0x18fd22,_0x1ce655,_0x1e6244['gSQcu']);},Sprite_EnemyName[_0xe90fac(0x510)]['updateLink']=function(){const _0x49f328=_0xe90fac,_0x28e2c0={'GMmKR':function(_0x14cdb1,_0x5d45a0){return _0x14cdb1!==_0x5d45a0;}};if(!this['_linkedSpr'+_0x49f328(0xdf4)])return;_0x28e2c0[_0x49f328(0x118b)](this[_0x49f328(0xbb8)],this['_linkedSpr'+_0x49f328(0xdf4)][_0x49f328(0xbb8)])&&this[_0x49f328(0xc70)](this['_linkedSpr'+_0x49f328(0xdf4)][_0x49f328(0xbb8)]);},Sprite_EnemyName[_0xe90fac(0x510)][_0xe90fac(0xe9f)+_0xe90fac(0x1580)]=function(){const _0x19b8cd=_0xe90fac,_0x5854f2={'BYLxD':function(_0x1d6fda,_0x2749c9){return _0x1d6fda-_0x2749c9;},'FpNII':function(_0x5ae2a3,_0x5ee146){return _0x5ae2a3*_0x5ee146;}};if(!this[_0x19b8cd(0xf3c)+_0x19b8cd(0xdf4)])return;this['_lineHeigh'+'t']=this[_0x19b8cd(0x621)+'t']||Window_Base['prototype']['lineHeight'](),this['x']=Math[_0x19b8cd(0x10a1)](this[_0x19b8cd(0xf3c)+_0x19b8cd(0xdf4)][_0x19b8cd(0x156)]),this['y']=Math[_0x19b8cd(0x10a1)](_0x5854f2[_0x19b8cd(0x1084)](this[_0x19b8cd(0xf3c)+_0x19b8cd(0xdf4)][_0x19b8cd(0x1098)],_0x5854f2[_0x19b8cd(0x392)](this[_0x19b8cd(0x621)+'t'],-0xc*-0x189+-0x85d+-0xa0f+0.5)));const _0x3690bc=VisuMZ[_0x19b8cd(0x118f)][_0x19b8cd(0x281)][_0x19b8cd(0x105f)];this['x']+=Math[_0x19b8cd(0x10a1)](_0x3690bc[_0x19b8cd(0x1405)+'X']||0xc20+-0x1961+0xd41),this['y']+=Math['round'](_0x3690bc[_0x19b8cd(0x1405)+'Y']||-0x657+-0x6b9*-0x3+-0xdd4);},Sprite_EnemyName[_0xe90fac(0x510)][_0xe90fac(0x994)+_0xe90fac(0xd97)+'s']=function(){const _0x1bec36=_0xe90fac;this[_0x1bec36(0x14e)+_0x1bec36(0xd77)+'e']();},Sprite_EnemyName[_0xe90fac(0x510)][_0xe90fac(0x14e)+_0xe90fac(0xd77)+'e']=function(){const _0x313597=_0xe90fac,_0x17495b={'DnDYk':function(_0x57b6ab,_0x27fb0d){return _0x57b6ab!==_0x27fb0d;},'mvHHu':function(_0x17d944,_0x280c58){return _0x17d944+_0x280c58;},'eSzTW':function(_0x17d3f5,_0x43c6fa){return _0x17d3f5/_0x43c6fa;},'dXnnI':function(_0x137850,_0x1a5957){return _0x137850/_0x1a5957;}};if(!this[_0x313597(0xf12)+'Sprite'])return;_0x17495b[_0x313597(0xd4f)](this[_0x313597(0xbb8)],this[_0x313597(0xf12)+_0x313597(0x15e6)][_0x313597(0xbb8)])&&this[_0x313597(0xf12)+'Sprite'][_0x313597(0xc70)](this[_0x313597(0xbb8)]);const _0x12a1e5=this[_0x313597(0x50e)]();this['_lineHeigh'+'t']=this['_lineHeigh'+'t']||Window_Base[_0x313597(0x510)][_0x313597(0xf4b)](),this[_0x313597(0xf12)+_0x313597(0x15e6)]['x']=_0x17495b[_0x313597(0x954)](Math[_0x313597(0x10a1)](_0x17495b[_0x313597(0xcac)](_0x17495b[_0x313597(0x954)](_0x12a1e5,ImageManager[_0x313597(0x172)]),0x36c*-0x5+-0x2*-0xc92+0x1a*-0x4f)),-0x3ef+0x79*0x1f+-0xab0),this[_0x313597(0xf12)+'Sprite']['y']=_0x17495b['dXnnI'](this[_0x313597(0x621)+'t'],0xb3*-0xb+0x61*0x2b+-0x898);const _0xfe78be=VisuMZ[_0x313597(0x118f)]['Settings']['Enemy'];this[_0x313597(0xf12)+_0x313597(0x15e6)]['x']+=_0xfe78be['AttachStat'+_0x313597(0x15f2)]||0x6*-0x4e+-0xea0+0x1074,this['_stateIcon'+_0x313597(0x15e6)]['y']+=_0xfe78be[_0x313597(0x633)+_0x313597(0x15dc)]||-0x1e66*0x1+-0x137d+0x31e3;},Sprite_EnemyName[_0xe90fac(0x510)][_0xe90fac(0xbde)+_0xe90fac(0x798)]=function(){const _0x39eb16=_0xe90fac,_0x2c47cf={'jHVMB':function(_0x1d82e0,_0x590415){return _0x1d82e0<_0x590415;},'oDBpG':function(_0x2205f4,_0x44bf44){return _0x2205f4>_0x44bf44;}},_0x1c97a3=this[_0x39eb16(0x1301)+_0x39eb16(0x11fa)]();if(_0x1c97a3&&_0x2c47cf[_0x39eb16(0x81f)](this['opacity'],-0x2059+-0x13c2+0x351a))this[_0x39eb16(0xfac)]+=-0x1cbb+-0x1da5+-0x37*-0x110;else!_0x1c97a3&&_0x2c47cf[_0x39eb16(0x62b)](this['opacity'],0x64d*0x1+-0x11ca+-0xb7d*-0x1)&&(this[_0x39eb16(0xfac)]-=0x8*-0x4ab+0x334+0x2234);},Sprite_EnemyName[_0xe90fac(0x510)][_0xe90fac(0x1301)+'State']=function(){const _0x5dd127=_0xe90fac,_0x4609db={'MyQgG':function(_0x2836f7,_0x16ee09){return _0x2836f7>_0x16ee09;}};if(this[_0x5dd127(0xd99)+'dden']())return![];else{if(!this[_0x5dd127(0xbb8)])return![];else{if(!this[_0x5dd127(0xbb8)][_0x5dd127(0xe7f)]())return![];else{if(this[_0x5dd127(0x116e)+'isibile']())return!![];else{if(this[_0x5dd127(0xbb8)][_0x5dd127(0x17d)]())return![];else{if(this['isBattlerT'+_0x5dd127(0xcc6)]())return!![];else{if(this['compatibil'+'ityVisible']())return!![];else{if(this[_0x5dd127(0x743)+_0x5dd127(0x527)]())return!![];else{if(this[_0x5dd127(0xc53)+_0x5dd127(0x3c8)+'dow']())return!![];else{if(_0x4609db[_0x5dd127(0x11bd)](this[_0x5dd127(0xfac)],-0xd75+-0x2de*-0x4+-0x1*-0x1fd))return![];}}}}}}}}}},Sprite_EnemyName[_0xe90fac(0x510)][_0xe90fac(0x116e)+_0xe90fac(0x1610)]=function(){const _0x26a0e5=_0xe90fac;return this[_0x26a0e5(0xbb8)]&&this[_0x26a0e5(0xbb8)][_0x26a0e5(0xb2d)+_0x26a0e5(0x864)+_0x26a0e5(0x90a)]();},Sprite_EnemyName[_0xe90fac(0x510)][_0xe90fac(0xd99)+_0xe90fac(0x1310)]=function(){const _0x1f9d03=_0xe90fac;return VisuMZ[_0x1f9d03(0x118f)][_0x1f9d03(0x281)][_0x1f9d03(0x105f)]['NameAlways'+'Hidden'];},Sprite_EnemyName['prototype']['isBattlerT'+'argeted']=function(){const _0x2eb82f=_0xe90fac;return this[_0x2eb82f(0xbb8)]&&BattleManager[_0x2eb82f(0x12dd)]['includes'](this[_0x2eb82f(0xbb8)]);},Sprite_EnemyName[_0xe90fac(0x510)][_0xe90fac(0xd13)+_0xe90fac(0x98c)]=function(){return![];},Sprite_EnemyName[_0xe90fac(0x510)]['isAlwaysVi'+_0xe90fac(0x527)]=function(){const _0x2633a6=_0xe90fac;return VisuMZ[_0x2633a6(0x118f)][_0x2633a6(0x281)]['Enemy'][_0x2633a6(0x6c5)+_0x2633a6(0x756)];},Sprite_EnemyName[_0xe90fac(0x510)][_0xe90fac(0xc53)+'InEnemyWin'+_0xe90fac(0x1600)]=function(){const _0x3534dc=_0xe90fac;return VisuMZ[_0x3534dc(0x118f)][_0x3534dc(0x281)][_0x3534dc(0x105f)]['NameAlways'+'SelectOnly']?this[_0x3534dc(0xbb8)][_0x3534dc(0x228)]():SceneManager['_scene'][_0x3534dc(0x356)+'ow']&&SceneManager[_0x3534dc(0x11dd)][_0x3534dc(0x356)+'ow'][_0x3534dc(0xd66)]&&SceneManager[_0x3534dc(0x11dd)][_0x3534dc(0x356)+'ow']['_enemies'][_0x3534dc(0x79c)](this[_0x3534dc(0xbb8)]);},Sprite_EnemyName['prototype']['textWidth']=function(){const _0x214f4a=_0xe90fac;if(!this['_battler'])return-0xa1a+0x1eb0+-0x1496;if(this[_0x214f4a(0x96b)+_0x214f4a(0x56a)])return this['_cacheText'+_0x214f4a(0x56a)];const _0x305c74=this['name']();return this[_0x214f4a(0xdf2)](),this[_0x214f4a(0x96b)+_0x214f4a(0x56a)]=this[_0x214f4a(0x24c)][_0x214f4a(0x101a)+'tWidth'](_0x305c74)||-0x269d*-0x1+-0x1*-0x1636+0x2d*-0x15a,this[_0x214f4a(0x96b)+_0x214f4a(0x56a)];},VisuMZ['BattleCore']['Sprite_Bat'+_0xe90fac(0x487)+_0xe90fac(0x131b)+'on']=Sprite_Battleback['prototype'][_0xe90fac(0x14ad)+_0xe90fac(0x1580)],Sprite_Battleback[_0xe90fac(0x510)][_0xe90fac(0x14ad)+_0xe90fac(0x1580)]=function(){const _0x185c30=_0xe90fac,_0x93af43={'heMkQ':function(_0x1a2fdf,_0x329a7b){return _0x1a2fdf(_0x329a7b);},'uIVii':_0x185c30(0x13bf),'mfcKW':'ScaleToFit','AJBUn':'ScaleDown','HXnBr':_0x185c30(0xcbd)},_0x504c2c=VisuMZ[_0x185c30(0x118f)][_0x185c30(0x281)][_0x185c30(0x12d0)+_0x185c30(0xfe6)];if(!_0x504c2c)return VisuMZ[_0x185c30(0x118f)][_0x185c30(0x5bd)+_0x185c30(0x487)+'justPositi'+'on'][_0x185c30(0x351)](this);const _0x56725d=_0x93af43['heMkQ'](String,_0x504c2c['DefaultSty'+'le'])||'MZ';switch(_0x56725d){case'MZ':VisuMZ[_0x185c30(0x118f)][_0x185c30(0x5bd)+_0x185c30(0x487)+_0x185c30(0x131b)+'on'][_0x185c30(0x351)](this);break;case _0x93af43[_0x185c30(0x454)]:this[_0x185c30(0x14ad)+_0x185c30(0x4be)]();break;case _0x93af43[_0x185c30(0x15a)]:this[_0x185c30(0x14ad)+_0x185c30(0x168)+_0x185c30(0x67b)]();break;case _0x93af43[_0x185c30(0x476)]:this[_0x185c30(0x14ad)+'tion_Scale'+'Down']();break;case _0x93af43['HXnBr']:this[_0x185c30(0x14ad)+'tion_Scale'+'Up']();break;}},Sprite_Battleback['prototype'][_0xe90fac(0x14ad)+_0xe90fac(0x4be)]=function(){const _0x39c89d=_0xe90fac,_0x497dd6=VisuMZ['BattleCore'][_0x39c89d(0x281)]['Battleback'+_0x39c89d(0xfe6)];if(_0x497dd6&&_0x497dd6[_0x39c89d(0x157f)+'e'])return _0x497dd6['jsOneForOn'+'e']['call'](this);this[_0x39c89d(0x301)]=Graphics[_0x39c89d(0x301)],this['height']=Graphics[_0x39c89d(0xa68)];const _0x4caea7=-0x1e28+0x7*0x40b+0x1dc;this[_0x39c89d(0xe61)]['x']=_0x4caea7,this[_0x39c89d(0xe61)]['y']=_0x4caea7,this['x']=0x2b*-0x27+-0x1a98+-0x6a1*-0x5,this['y']=-0x5b3+0x8a+-0x529*-0x1;},Sprite_Battleback['prototype'][_0xe90fac(0x14ad)+_0xe90fac(0x168)+_0xe90fac(0x67b)]=function(){const _0x5d564b=_0xe90fac,_0x5c2c49={'efurh':function(_0x2ec519,_0x3f6db9){return _0x2ec519/_0x3f6db9;},'sFhBB':function(_0x220ad0,_0x252687){return _0x220ad0/_0x252687;},'NlBvM':function(_0x503b13,_0x104725){return _0x503b13-_0x104725;}},_0x5617a6=VisuMZ[_0x5d564b(0x118f)]['Settings'][_0x5d564b(0x12d0)+_0x5d564b(0xfe6)];if(_0x5617a6&&_0x5617a6[_0x5d564b(0x4d8)+'it'])return _0x5617a6['jsScaleToF'+'it'][_0x5d564b(0x351)](this);this[_0x5d564b(0x301)]=Graphics['width'],this[_0x5d564b(0xa68)]=Graphics[_0x5d564b(0xa68)];const _0x1909b2=_0x5c2c49[_0x5d564b(0x4b6)](this[_0x5d564b(0x301)],this[_0x5d564b(0x24c)][_0x5d564b(0x301)]),_0x4b5e3d=_0x5c2c49['sFhBB'](this['height'],this['bitmap'][_0x5d564b(0xa68)]),_0x50904e=Math[_0x5d564b(0xd3e)](_0x1909b2,_0x4b5e3d);this[_0x5d564b(0xe61)]['x']=_0x50904e,this[_0x5d564b(0xe61)]['y']=_0x50904e,this['x']=_0x5c2c49[_0x5d564b(0x645)](_0x5c2c49['NlBvM'](Graphics['width'],this['width']),-0xfd3*0x1+0x3*-0xa6+0x3*0x5ed),this['y']=_0x5c2c49[_0x5d564b(0x3bb)](Graphics[_0x5d564b(0xa68)],this[_0x5d564b(0xa68)]);},Sprite_Battleback[_0xe90fac(0x510)][_0xe90fac(0x14ad)+_0xe90fac(0x168)+_0xe90fac(0x631)]=function(){const _0x3adba7=_0xe90fac,_0x548ba0={'ecKZw':function(_0x6aa0ac,_0x18e728){return _0x6aa0ac/_0x18e728;},'sBcDl':function(_0x4aa7f7,_0x14f8b5){return _0x4aa7f7-_0x14f8b5;},'mIwyL':function(_0x5780cf,_0x233adf){return _0x5780cf-_0x233adf;}},_0x1dab66=VisuMZ[_0x3adba7(0x118f)][_0x3adba7(0x281)]['Battleback'+_0x3adba7(0xfe6)];if(_0x1dab66&&_0x1dab66[_0x3adba7(0x12e9)+'n'])return _0x1dab66[_0x3adba7(0x12e9)+'n'][_0x3adba7(0x351)](this);this['width']=Graphics[_0x3adba7(0x301)],this[_0x3adba7(0xa68)]=Graphics[_0x3adba7(0xa68)];const _0x371a0b=Math[_0x3adba7(0xeed)](-0x1adf+0xad0+0x1010,_0x548ba0[_0x3adba7(0x920)](this[_0x3adba7(0x301)],this[_0x3adba7(0x24c)][_0x3adba7(0x301)])),_0xc4fe=Math[_0x3adba7(0xeed)](0x64e+0x141e+-0x1*0x1a6b,_0x548ba0[_0x3adba7(0x920)](this[_0x3adba7(0xa68)],this[_0x3adba7(0x24c)][_0x3adba7(0xa68)])),_0x4b6e3c=Math[_0x3adba7(0xd3e)](_0x371a0b,_0xc4fe);this['scale']['x']=_0x4b6e3c,this[_0x3adba7(0xe61)]['y']=_0x4b6e3c,this['x']=_0x548ba0[_0x3adba7(0x920)](_0x548ba0['sBcDl'](Graphics[_0x3adba7(0x301)],this[_0x3adba7(0x301)]),0xf48+0x1c*-0xa3+0x28e),this['y']=_0x548ba0[_0x3adba7(0x578)](Graphics[_0x3adba7(0xa68)],this['height']);},Sprite_Battleback[_0xe90fac(0x510)][_0xe90fac(0x14ad)+'tion_Scale'+'Up']=function(){const _0x9b7e28=_0xe90fac,_0x424ddb={'PLREp':function(_0x442108,_0x3fbd70){return _0x442108/_0x3fbd70;},'qyiny':function(_0x116cc7,_0x489f98){return _0x116cc7/_0x489f98;},'zjnxw':function(_0x5df705,_0x3c20c9){return _0x5df705-_0x3c20c9;},'yTxLy':function(_0x17e51f,_0xba5600){return _0x17e51f-_0xba5600;}},_0x47b1d8=VisuMZ['BattleCore']['Settings'][_0x9b7e28(0x12d0)+_0x9b7e28(0xfe6)];if(_0x47b1d8&&_0x47b1d8[_0x9b7e28(0x9b7)])return _0x47b1d8[_0x9b7e28(0x9b7)][_0x9b7e28(0x351)](this);this[_0x9b7e28(0x301)]=Graphics['width'],this['height']=Graphics['height'];const _0xc4c9d4=Math[_0x9b7e28(0xd3e)](0x1*-0x1b72+-0x1*0xaea+0x265d,_0x424ddb[_0x9b7e28(0x1051)](this[_0x9b7e28(0x301)],this[_0x9b7e28(0x24c)][_0x9b7e28(0x301)])),_0x31d908=Math[_0x9b7e28(0xd3e)](0x4f*-0x6d+0x92*0x8+-0x1d14*-0x1,_0x424ddb['PLREp'](this[_0x9b7e28(0xa68)],this['bitmap'][_0x9b7e28(0xa68)])),_0x2629b7=Math[_0x9b7e28(0xd3e)](_0xc4c9d4,_0x31d908);this['scale']['x']=_0x2629b7,this['scale']['y']=_0x2629b7,this['x']=_0x424ddb[_0x9b7e28(0x194)](_0x424ddb[_0x9b7e28(0xa33)](Graphics[_0x9b7e28(0x301)],this[_0x9b7e28(0x301)]),0xd*0x215+-0x2*-0x427+0x1*-0x235d),this['y']=_0x424ddb['yTxLy'](Graphics[_0x9b7e28(0xa68)],this['height']);},Spriteset_Battle[_0xe90fac(0x7f4)+'UI']=VisuMZ[_0xe90fac(0x118f)]['Settings'][_0xe90fac(0x5a2)+'ut'][_0xe90fac(0x1da)+'Elements']??!![],Spriteset_Battle[_0xe90fac(0x510)][_0xe90fac(0xea3)]=function(){const _0x365a18=_0xe90fac;if(!$gameSystem[_0x365a18(0x53d)]())return![];return![];},Spriteset_Battle[_0xe90fac(0x510)][_0xe90fac(0x151e)+_0xe90fac(0x752)]=function(){return 0x169*0x7+0x123*-0x15+-0xe00*-0x1;},Spriteset_Battle[_0xe90fac(0x510)]['animationN'+_0xe90fac(0x106e)]=function(){return-0x2155+-0x181c+-0x55*-0xad;},VisuMZ['BattleCore'][_0xe90fac(0x1245)+_0xe90fac(0x114f)+'ateLowerLa'+_0xe90fac(0x1501)]=Spriteset_Battle[_0xe90fac(0x510)][_0xe90fac(0xb7c)+_0xe90fac(0x1053)],Spriteset_Battle[_0xe90fac(0x510)][_0xe90fac(0xb7c)+_0xe90fac(0x1053)]=function(){const _0xb98658=_0xe90fac;VisuMZ[_0xb98658(0x118f)][_0xb98658(0x1245)+'Battle_cre'+'ateLowerLa'+_0xb98658(0x1501)][_0xb98658(0x351)](this),this[_0xb98658(0x3ec)+'her'](),this['createEnem'+_0xb98658(0x1344)]();},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x1245)+_0xe90fac(0x2f3)+_0xe90fac(0x135d)]=Spriteset_Battle[_0xe90fac(0x510)][_0xe90fac(0x94)],Spriteset_Battle[_0xe90fac(0x510)][_0xe90fac(0x94)]=function(){const _0x283e17=_0xe90fac,_0x1fae7a={'WGwHj':_0x283e17(0x696)},_0x46d68c=_0x1fae7a['WGwHj'][_0x283e17(0xab1)]('|');let _0x45e6a9=-0x16a3+-0x2*-0xd39+-0x3cf;while(!![]){switch(_0x46d68c[_0x45e6a9++]){case'0':this['updateBatt'+_0x283e17(0x10b7)+'er']();continue;case'1':this[_0x283e17(0x5bc)+'ntainerPos'+'ition']();continue;case'2':VisuMZ[_0x283e17(0x118f)][_0x283e17(0x1245)+_0x283e17(0x2f3)+_0x283e17(0x135d)][_0x283e17(0x351)](this);continue;case'3':this[_0x283e17(0x12fc)+_0x283e17(0x1013)]();continue;case'4':this['updateBatt'+_0x283e17(0xd62)]();continue;}break;}},Spriteset_Battle['prototype'][_0xe90fac(0x3ec)+_0xe90fac(0x1013)]=function(){const _0x129965=_0xe90fac;this[_0x129965(0x1019)]=new Weather(),this[_0x129965(0x1217)+'ld'][_0x129965(0xda3)](this[_0x129965(0x1019)]);},Spriteset_Battle[_0xe90fac(0x510)][_0xe90fac(0x12fc)+_0xe90fac(0x1013)]=function(){const _0x99144b=_0xe90fac;this[_0x99144b(0x1019)][_0x99144b(0x152a)]=$gameScreen['weatherTyp'+'e'](),this[_0x99144b(0x1019)]['power']=$gameScreen[_0x99144b(0xf8)+'er']();},Game_Interpreter[_0xe90fac(0x510)][_0xe90fac(0x1a9)]=function(_0x4acb00){const _0x3bf46c=_0xe90fac;$gameScreen[_0x3bf46c(0x134b)+_0x3bf46c(0x1013)](_0x4acb00[-0x205*0x9+0xa*0x31f+-0xd09],_0x4acb00[-0x9c+-0x2*-0x8a1+-0x10a5*0x1],_0x4acb00[0x2509+0x681+-0x2b88]);if(_0x4acb00[0x1*-0x23e8+-0x1da1+-0x1063*-0x4])this[_0x3bf46c(0x600)](_0x4acb00[0x1*-0xf4a+0x1*0x92f+0x61d]);return!![];},VisuMZ['BattleCore'][_0xe90fac(0x98e)+_0xe90fac(0x195)+_0xe90fac(0xad9)]=Game_Interpreter[_0xe90fac(0x510)]['command283'],Game_Interpreter[_0xe90fac(0x510)][_0xe90fac(0x13ad)]=function(_0x384ad3){const _0xc2a527=_0xe90fac;return SceneManager[_0xc2a527(0x11be)+_0xc2a527(0x3ad)]()?(SceneManager[_0xc2a527(0x11dd)][_0xc2a527(0x981)][_0xc2a527(0xccf)+_0xc2a527(0x1168)](_0x384ad3[0xb1*0x1d+-0xe3e+-0x5cf],_0x384ad3[-0x1247+-0x1b59+0x2da1*0x1]),!![]):VisuMZ[_0xc2a527(0x118f)][_0xc2a527(0x98e)+'preter_com'+_0xc2a527(0xad9)][_0xc2a527(0x351)](this,_0x384ad3);},Spriteset_Battle[_0xe90fac(0x510)]['updateBatt'+_0xe90fac(0x1205)+'ap']=function(_0x187d9e,_0x51af31){const _0x3d0996=_0xe90fac;_0x187d9e[_0x3d0996(0x24c)]=_0x51af31;},Spriteset_Battle[_0xe90fac(0x510)][_0xe90fac(0xccf)+_0xe90fac(0x1168)]=function(_0x21d8f6,_0x7e05a3){const _0x4e370c=_0xe90fac,_0x4b2dcd={'WvTHX':function(_0x56690b,_0x52d742){return _0x56690b||_0x52d742;},'umFDD':function(_0x17e2c7,_0x525f60){return _0x17e2c7===_0x525f60;},'MSmIW':function(_0xba334f,_0x52d342){return _0xba334f===_0x52d342;}};_0x21d8f6=_0x4b2dcd[_0x4e370c(0xcb8)](_0x21d8f6,''),_0x7e05a3=_0x4b2dcd['WvTHX'](_0x7e05a3,'');_0x4b2dcd[_0x4e370c(0x1250)](_0x21d8f6,'')&&_0x4b2dcd[_0x4e370c(0xd68)](_0x7e05a3,'')&&(_0x21d8f6=this['_back1Spri'+'te'][_0x4e370c(0x65f)+_0x4e370c(0x156f)](),_0x7e05a3=this['_back2Spri'+'te'][_0x4e370c(0x65f)+'2Name']());const _0x472a34=ImageManager['loadBattle'+_0x4e370c(0x342)](_0x21d8f6),_0x1f4aeb=ImageManager[_0x4e370c(0x11e6)+'back2'](_0x7e05a3);_0x472a34['addLoadLis'+_0x4e370c(0xef)](this[_0x4e370c(0xc88)+'lebackBitm'+_0x4e370c(0x1539)][_0x4e370c(0x874)](this,this[_0x4e370c(0x1132)+'te'],this[_0x4e370c(0x2bc)+'te'],_0x472a34,_0x1f4aeb));},Spriteset_Battle[_0xe90fac(0x510)][_0xe90fac(0xc88)+_0xe90fac(0x1205)+_0xe90fac(0x1539)]=function(_0x568513,_0x29fa4a,_0x24fb84,_0x128a2a){const _0x2de7e5=_0xe90fac;_0x128a2a['addLoadLis'+_0x2de7e5(0xef)](this[_0x2de7e5(0xc88)+_0x2de7e5(0x1205)+_0x2de7e5(0x682)]['bind'](this,_0x568513,_0x29fa4a,_0x24fb84,_0x128a2a));},Spriteset_Battle['prototype'][_0xe90fac(0xc88)+_0xe90fac(0x1205)+_0xe90fac(0x682)]=function(_0x3e48ef,_0x43c565,_0x5d22e9,_0x914f38){const _0x3a1129=_0xe90fac;_0x3e48ef[_0x3a1129(0x24c)]=_0x5d22e9,_0x43c565['bitmap']=_0x914f38,_0x3e48ef[_0x3a1129(0x14ad)+_0x3a1129(0x1580)](),_0x43c565[_0x3a1129(0x14ad)+_0x3a1129(0x1580)]();},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x1245)+_0xe90fac(0x114f)+_0xe90fac(0x1120)+_0xe90fac(0x1a3)]=Spriteset_Battle[_0xe90fac(0x510)][_0xe90fac(0x4e3)+_0xe90fac(0x15c3)],Spriteset_Battle[_0xe90fac(0x510)][_0xe90fac(0x4e3)+_0xe90fac(0x15c3)]=function(){const _0x2bc650=_0xe90fac;VisuMZ[_0x2bc650(0x118f)][_0x2bc650(0x1245)+_0x2bc650(0x114f)+'ateBattleF'+_0x2bc650(0x1a3)][_0x2bc650(0x351)](this),this[_0x2bc650(0x4e3)+_0x2bc650(0x1135)+_0x2bc650(0x80e)]();},Spriteset_Battle['prototype'][_0xe90fac(0x4e3)+_0xe90fac(0x1135)+_0xe90fac(0x80e)]=function(){const _0x31ac09=_0xe90fac,_0x17c35e={'toCMF':_0x31ac09(0x16f)},_0x3b4d8e=_0x17c35e[_0x31ac09(0x71a)]['split']('|');let _0x5dd1b3=-0x3ca*-0x4+0x97*0x25+-0x24fb;while(!![]){switch(_0x3b4d8e[_0x5dd1b3++]){case'0':this[_0x31ac09(0xcc3)+_0x31ac09(0x437)+'r']();continue;case'1':this['createAnim'+_0x31ac09(0x300)+'iner']();continue;case'2':this['createBatt'+_0x31ac09(0xf58)+_0x31ac09(0x257)]();continue;case'3':this[_0x31ac09(0x12b7)+_0x31ac09(0x10f3)+_0x31ac09(0x1a3)]();continue;case'4':this[_0x31ac09(0x2de)+_0x31ac09(0xb05)]();continue;}break;}},Spriteset_Battle[_0xe90fac(0x510)][_0xe90fac(0x4e3)+_0xe90fac(0xf58)+_0xe90fac(0x257)]=function(){const _0x24ef47=_0xe90fac;this[_0x24ef47(0x14e3)+_0x24ef47(0xb05)]=new Sprite(),this[_0x24ef47(0x1217)+'ld'][_0x24ef47(0xda3)](this[_0x24ef47(0x14e3)+'ntainer']);},Spriteset_Battle[_0xe90fac(0x510)][_0xe90fac(0x721)+'ationConta'+_0xe90fac(0x1350)]=function(){const _0x10cdc1=_0xe90fac;this[_0x10cdc1(0x477)+'Container']=new Sprite(),Spriteset_Battle[_0x10cdc1(0x7f4)+'UI']?this['addChild'](this[_0x10cdc1(0x477)+'Container']):this[_0x10cdc1(0x1217)+'ld'][_0x10cdc1(0xda3)](this['_animation'+_0x10cdc1(0x1325)]);},Spriteset_Battle[_0xe90fac(0x510)]['createDama'+_0xe90fac(0x437)+'r']=function(){const _0x54f514=_0xe90fac;this['_damageCon'+'tainer']=new Sprite(),this[_0x54f514(0x158)+_0x54f514(0x257)]['x']=this['_battleFie'+'ld']['x'],this[_0x54f514(0x158)+_0x54f514(0x257)]['y']=this['_battleFie'+'ld']['y'],this[_0x54f514(0xda3)](this[_0x54f514(0x158)+_0x54f514(0x257)]);},Spriteset_Battle[_0xe90fac(0x510)]['adjustFlip'+_0xe90fac(0x10f3)+_0xe90fac(0x1a3)]=function(){const _0x1f8bc1=_0xe90fac,_0x2eccbc={'cRdbT':_0x1f8bc1(0x47c)+'7|3|2|0','GSqWd':function(_0x44f682,_0x468dba){return _0x44f682+_0x468dba;}},_0x3d5756=_0x2eccbc[_0x1f8bc1(0xcf6)]['split']('|');let _0x204cde=0x79*0x17+0x17fa+-0x22d9;while(!![]){switch(_0x3d5756[_0x204cde++]){case'0':this[_0x1f8bc1(0x158)+'tainer']['x']=_0x2eccbc[_0x1f8bc1(0x9e4)](this['_battleFie'+'ld']['x'],this[_0x1f8bc1(0x1217)+'ld'][_0x1f8bc1(0x301)]);continue;case'1':this['_battlerCo'+_0x1f8bc1(0xb05)]['x']=this[_0x1f8bc1(0x1217)+'ld'][_0x1f8bc1(0x301)];continue;case'2':this[_0x1f8bc1(0x158)+_0x1f8bc1(0x257)][_0x1f8bc1(0xe61)]['x']=-(-0x14b6+-0xdf*0x22+0x1*0x3255);continue;case'3':this[_0x1f8bc1(0x477)+_0x1f8bc1(0x1325)]['x']=this[_0x1f8bc1(0x1217)+'ld']['width'];continue;case'4':this[_0x1f8bc1(0x9e8)+'er'][_0x1f8bc1(0xe61)]['x']=-(0x2202+-0x4*0x3c8+-0xb3*0x1b);continue;case'5':this[_0x1f8bc1(0x14e3)+_0x1f8bc1(0xb05)][_0x1f8bc1(0xe61)]['x']=-(0x1c2*-0x10+-0x146a+0x308b);continue;case'6':this['_uiContain'+'er']['x']=this[_0x1f8bc1(0x1217)+'ld'][_0x1f8bc1(0x301)];continue;case'7':this['_animation'+_0x1f8bc1(0x1325)]['scale']['x']=-(-0xb05+-0x1*0x2374+0x1*0x2e7a);continue;case'8':if(!this[_0x1f8bc1(0xea3)]())return;continue;}break;}},Spriteset_Battle[_0xe90fac(0x510)][_0xe90fac(0xc63)+_0xe90fac(0x14c5)]=function(){const _0x2fd83a=_0xe90fac;Imported[_0x2fd83a(0x155e)+_0x2fd83a(0x100d)]&&this['coreEngine'+_0x2fd83a(0x1461)+_0x2fd83a(0xa4f)]()&&this[_0x2fd83a(0xb09)+_0x2fd83a(0xc11)+'esolution']();const _0x1b31fb=$gameTroop[_0x2fd83a(0xe13)](),_0xf6c7d8=[];for(const _0x3774df of _0x1b31fb){_0xf6c7d8[_0x2fd83a(0x15f1)](new Sprite_Enemy(_0x3774df));}_0xf6c7d8[_0x2fd83a(0xf47)](this['compareEne'+'mySprite'][_0x2fd83a(0x874)](this));for(const _0x39abb3 of _0xf6c7d8){this[_0x2fd83a(0x14e3)+_0x2fd83a(0xb05)]['addChild'](_0x39abb3);}this[_0x2fd83a(0x14b2)+_0x2fd83a(0x6be)]=_0xf6c7d8;},Spriteset_Battle[_0xe90fac(0x510)][_0xe90fac(0x12e6)+'rs']=function(){const _0x573415=_0xe90fac,_0x4f9d0a={'MUafT':function(_0x37c97d,_0x330672){return _0x37c97d<_0x330672;}};this['_actorSpri'+_0x573415(0x6be)]=[];for(let _0x5dca36=0x863+-0xb59+0x2f6;_0x4f9d0a[_0x573415(0xa50)](_0x5dca36,$gameParty[_0x573415(0x1200)+_0x573415(0xcdb)]());_0x5dca36++){const _0x3ea059=$gameParty[_0x573415(0xac1)+_0x573415(0x446)]()[_0x5dca36],_0x41d27c=new Sprite_Actor();_0x41d27c[_0x573415(0x1cd)+'tPositionB'+_0x573415(0x402)](_0x3ea059),_0x41d27c[_0x573415(0x117e)](_0x3ea059),_0x41d27c['update'](),this[_0x573415(0x1160)+_0x573415(0x6be)][_0x573415(0x15f1)](_0x41d27c),this[_0x573415(0x14e3)+_0x573415(0xb05)]['addChild'](_0x41d27c);}},Spriteset_Battle[_0xe90fac(0x510)][_0xe90fac(0x721)+_0xe90fac(0xd88)+'e']=function(_0x4cd98e,_0x2d42e2,_0x9f8c95,_0x5a7ae5){const _0x556726=_0xe90fac,_0x324125=this[_0x556726(0xe5d)+'ion'](_0x2d42e2),_0x3f5a95=new(_0x324125?Sprite_AnimationMV:Sprite_Animation)(),_0xd97423=this[_0x556726(0xadf)+_0x556726(0xdf8)](_0x4cd98e);this['animationS'+_0x556726(0xfbd)+'r'](_0x4cd98e[-0x552+-0x6f6+-0x3*-0x418])&&(_0x9f8c95=!_0x9f8c95),_0x3f5a95[_0x556726(0x73a)+_0x556726(0x9a)]=_0x4cd98e,_0x3f5a95['setup'](_0xd97423,_0x2d42e2,_0x9f8c95,_0x5a7ae5),this[_0x556726(0x94a)+_0x556726(0x155b)+'Container'](_0x3f5a95);},Spriteset_Battle[_0xe90fac(0x510)][_0xe90fac(0x94a)+_0xe90fac(0x155b)+_0xe90fac(0x1325)]=function(_0x173cd2){const _0x1efd52=_0xe90fac;this['isAnimatio'+'nShownOnBa'+'ttlePortra'+'it'](_0x173cd2)?(this[_0x1efd52(0xc8)+_0x1efd52(0x14eb)+'imationCon'+_0x1efd52(0x257)]()[_0x1efd52(0xda3)](_0x173cd2),_0x173cd2['battleStat'+_0x1efd52(0x104b)]=!![]):(this[_0x1efd52(0x477)+_0x1efd52(0x1325)]['addChild'](_0x173cd2),Spriteset_Battle[_0x1efd52(0x7f4)+'UI']&&(this[_0x1efd52(0x477)+_0x1efd52(0x1325)]['x']=this[_0x1efd52(0x1031)+_0x1efd52(0xb05)]['x'],this['_animation'+_0x1efd52(0x1325)]['y']=this['_effectsCo'+_0x1efd52(0xb05)]['y'])),this['_animation'+_0x1efd52(0xdf8)]['push'](_0x173cd2);},Spriteset_Battle['prototype'][_0xe90fac(0xfaa)+_0xe90fac(0x5dc)+'ttlePortra'+'it']=function(_0x51c11b){const _0x5b608e=_0xe90fac,_0x64ffa9={'lMHJY':function(_0x48f6d1,_0x5b5fd3){return _0x48f6d1===_0x5b5fd3;},'jZWYb':function(_0x23fd56,_0x4b7c66){return _0x23fd56!==_0x4b7c66;},'sHEQK':function(_0xad58d5,_0xd7567e){return _0xad58d5===_0xd7567e;},'ziOae':function(_0x50ffb5,_0x5eb257){return _0x50ffb5===_0x5eb257;},'mEOJg':'portrait'};if(!_0x51c11b)return![];if(!_0x51c11b[_0x5b608e(0x477)])return![];if(!_0x51c11b['targetObje'+_0x5b608e(0x9a)][0x1372+0x1c29+-0x7*0x6cd])return![];if(_0x51c11b['targetObje'+_0x5b608e(0x9a)][-0x1cce+0x279*-0x5+0x292b][_0x5b608e(0xd83)]&&!_0x51c11b[_0x5b608e(0x73a)+'cts'][-0x1*0x1618+-0x2485*-0x1+-0xe6d][_0x5b608e(0xd83)]())return![];if($gameSystem[_0x5b608e(0x53d)]())return![];if(!this['battleStat'+_0x5b608e(0x14eb)+_0x5b608e(0x15c4)+_0x5b608e(0x257)]())return![];if(_0x64ffa9[_0x5b608e(0x4e0)](_0x51c11b[_0x5b608e(0x14c0)+'r'],Sprite_Animation)){if(_0x64ffa9[_0x5b608e(0x1440)](_0x51c11b[_0x5b608e(0x477)]['displayTyp'+'e'],-0xbff*-0x3+-0xa8b+-0x1972))return![];}else{if(_0x64ffa9[_0x5b608e(0xdbe)](_0x51c11b['constructo'+'r'],Sprite_AnimationMV)){if(_0x64ffa9[_0x5b608e(0x1561)](_0x51c11b[_0x5b608e(0x477)][_0x5b608e(0x1368)],0x20c7+-0x2636+0x2*0x2b9))return![];}}return!![];const _0x7e07e3=Window_BattleStatus['prototype']['battleLayo'+_0x5b608e(0x15fa)]();return['xp',_0x64ffa9[_0x5b608e(0x5cf)]][_0x5b608e(0xf87)](_0x7e07e3);},Spriteset_Battle[_0xe90fac(0x510)][_0xe90fac(0xc8)+_0xe90fac(0x14eb)+_0xe90fac(0x15c4)+_0xe90fac(0x257)]=function(){const _0x19d407=_0xe90fac;if(!SceneManager[_0x19d407(0x11dd)])return null;if(!SceneManager['_scene'][_0x19d407(0xbed)+_0x19d407(0x1600)])return null;if(!SceneManager[_0x19d407(0x11dd)]['_statusWin'+'dow'][_0x19d407(0x1031)+_0x19d407(0xb05)])return null;return SceneManager[_0x19d407(0x11dd)]['_statusWin'+_0x19d407(0x1600)][_0x19d407(0x1031)+_0x19d407(0xb05)];},Spriteset_Battle[_0xe90fac(0x510)][_0xe90fac(0x276)+_0xe90fac(0x1094)]=function(_0x5ed222){const _0x978e48=_0xe90fac;this['removeAnim'+_0x978e48(0x329)+'ontainer'](_0x5ed222);for(const _0x4b3253 of _0x5ed222[_0x978e48(0x73a)+_0x978e48(0x9a)]){_0x4b3253[_0x978e48(0x7da)+'on']&&_0x4b3253['endAnimati'+'on']();}_0x5ed222['destroy']();},Spriteset_Battle['prototype'][_0xe90fac(0x276)+_0xe90fac(0x329)+_0xe90fac(0x823)]=function(_0x913535){const _0xd5b6ca=_0xe90fac,_0x5613d5={'KhRpe':_0xd5b6ca(0xb7e)},_0x5b4c4d=_0x5613d5[_0xd5b6ca(0xfcb)][_0xd5b6ca(0xab1)]('|');let _0x40a45b=-0x1*-0x775+-0x259e+0x7*0x44f;while(!![]){switch(_0x5b4c4d[_0x40a45b++]){case'0':this[_0xd5b6ca(0xfaa)+_0xd5b6ca(0x5dc)+_0xd5b6ca(0xd08)+'it'](_0x913535)?this['battleStat'+_0xd5b6ca(0x14eb)+_0xd5b6ca(0x15c4)+_0xd5b6ca(0x257)]()[_0xd5b6ca(0xf46)+'d'](_0x913535):this[_0xd5b6ca(0x477)+_0xd5b6ca(0x1325)]['removeChil'+'d'](_0x913535);continue;case'1':this[_0xd5b6ca(0x477)+_0xd5b6ca(0xdf8)][_0xd5b6ca(0x8a4)](_0x913535);continue;case'2':this[_0xd5b6ca(0x1031)+_0xd5b6ca(0xb05)][_0xd5b6ca(0xf46)+'d'](_0x913535);continue;case'3':this[_0xd5b6ca(0x477)+'Container']['removeChil'+'d'](_0x913535);continue;case'4':if(this['_fauxAnima'+_0xd5b6ca(0x2ca)+'s'])this[_0xd5b6ca(0xd60)+'tionSprite'+'s'][_0xd5b6ca(0x8a4)](_0x913535);continue;}break;}},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x1245)+'Battle_upd'+_0xe90fac(0xd1)]=Spriteset_Battle['prototype'][_0xe90fac(0x38a)+'rs'],Spriteset_Battle['prototype'][_0xe90fac(0x38a)+'rs']=function(){const _0x464c98=_0xe90fac;VisuMZ[_0x464c98(0x118f)][_0x464c98(0x1245)+_0x464c98(0x2f3)+'ateActors'][_0x464c98(0x351)](this),this[_0x464c98(0xc88)+_0x464c98(0x10b7)+'er']();},Spriteset_Battle['prototype'][_0xe90fac(0xc88)+_0xe90fac(0x10b7)+'er']=function(){const _0x2652e8=_0xe90fac;this['_battlerCo'+'ntainer']['children'][_0x2652e8(0xf47)](this[_0x2652e8(0x12ff)+'tlerSprite'+'s'][_0x2652e8(0x874)](this)),this[_0x2652e8(0xc03)+'attlerOnTo'+'p']();if(!this[_0x2652e8(0x14e3)+_0x2652e8(0xb05)])return;this[_0x2652e8(0x14e3)+'ntainer'][_0x2652e8(0xfac)]=this['targetBatt'+'lerContain'+_0x2652e8(0x3a0)]();},Spriteset_Battle[_0xe90fac(0x510)]['compareBat'+_0xe90fac(0x64d)+'s']=function(_0x2c7d56,_0x758890){const _0x2a93c9=_0xe90fac,_0x4c360c={'PyaEI':function(_0x1ddedb,_0x31ce3d){return _0x1ddedb!==_0x31ce3d;},'YaHmM':function(_0x260b40,_0x368b59){return _0x260b40-_0x368b59;}};if(VisuMZ['BattleCore']['Settings']['Actor'][_0x2a93c9(0x535)+'rtActors']){if(_0x2c7d56['_battler']&&_0x758890[_0x2a93c9(0xbb8)]){if(_0x2c7d56['_battler']['isActor']()&&_0x758890['_battler'][_0x2a93c9(0xb9a)]())return-0x2*-0x9d6+-0x2409+0x1a3*0xa;else{if(_0x758890[_0x2a93c9(0xbb8)][_0x2a93c9(0xd83)]()&&_0x2c7d56[_0x2a93c9(0xbb8)]['isEnemy']())return-(0xca3+0x21ce+-0x2e70);}}}return _0x4c360c[_0x2a93c9(0xdc8)](_0x2c7d56[_0x2a93c9(0x1098)],_0x758890['_baseY'])?_0x4c360c[_0x2a93c9(0x460)](_0x2c7d56[_0x2a93c9(0x1098)],_0x758890[_0x2a93c9(0x1098)]):_0x4c360c[_0x2a93c9(0x460)](_0x758890[_0x2a93c9(0x7ba)],_0x2c7d56[_0x2a93c9(0x7ba)]);},Spriteset_Battle[_0xe90fac(0x510)]['putActiveB'+_0xe90fac(0x122b)+'p']=function(){const _0x494c53=_0xe90fac,_0x966e7={'EgMWd':function(_0x2c62f0,_0x57866f){return _0x2c62f0===_0x57866f;}};if(!VisuMZ['BattleCore'][_0x494c53(0x281)][_0x494c53(0xd11)][_0x494c53(0x535)+'rtActive'])return;const _0x29fb70=BattleManager[_0x494c53(0x14c1)];if(_0x29fb70){if(_0x29fb70[_0x494c53(0xd83)]()&&!$gameSystem['isSideView']())return;if(_0x966e7[_0x494c53(0x1559)](_0x29fb70,BattleManager[_0x494c53(0x31d)]()))return;const _0xb4fe3c=_0x29fb70[_0x494c53(0x81d)]();if(_0xb4fe3c&&_0x29fb70['isActor']())this[_0x494c53(0x14e3)+_0x494c53(0xb05)][_0x494c53(0xda3)](_0xb4fe3c);}},Spriteset_Battle[_0xe90fac(0x510)][_0xe90fac(0x13f)+_0xe90fac(0x109e)]=function(){const _0x45fa82=_0xe90fac;for(const _0x3a0858 of $gameParty[_0x45fa82(0xf79)+'rs']()){if(!_0x3a0858)continue;if(!_0x3a0858[_0x45fa82(0x81d)]())continue;_0x3a0858['battler']()[_0x45fa82(0x888)+_0x45fa82(0x15a9)]=!![],_0x3a0858['battler']()[_0x45fa82(0xfdd)]();}},Spriteset_Battle[_0xe90fac(0x510)][_0xe90fac(0x2de)+_0xe90fac(0xb05)]=function(){const _0x368942=_0xe90fac;this[_0x368942(0x9e8)+'er']=new Sprite(),Spriteset_Battle['ANTI_TINT_'+'UI']?this['addChild'](this[_0x368942(0x9e8)+'er']):this[_0x368942(0x1217)+'ld'][_0x368942(0xda3)](this[_0x368942(0x9e8)+'er']),SceneManager['_scene'][_0x368942(0x9e8)+'er']=this[_0x368942(0x9e8)+'er'];},Spriteset_Battle[_0xe90fac(0x510)][_0xe90fac(0xc63)+'yNames']=function(){const _0x2b52c0=_0xe90fac;if(VisuMZ[_0x2b52c0(0x118f)][_0x2b52c0(0x281)][_0x2b52c0(0x105f)][_0x2b52c0(0x80f)])return;this['_enemyName'+'Container']=new Sprite(),BattleManager[_0x2b52c0(0xe5b)+_0x2b52c0(0xec5)+'r'](this[_0x2b52c0(0x1564)+_0x2b52c0(0x1325)]);for(const _0x369598 of this[_0x2b52c0(0x14b2)+_0x2b52c0(0x6be)]){const _0x5e7ac7=new Sprite_EnemyName();this['_enemyName'+'Container'][_0x2b52c0(0xda3)](_0x5e7ac7),_0x5e7ac7[_0x2b52c0(0x97e)](_0x369598);}},Spriteset_Battle[_0xe90fac(0x510)][_0xe90fac(0x5bc)+_0xe90fac(0x9d4)+'ition']=function(){const _0x371d21=_0xe90fac,_0x4259e8={'zVqzQ':function(_0x5816e5,_0x5cf5ad){return _0x5816e5+_0x5cf5ad;},'hXQeG':function(_0x17932d,_0xf0b987){return _0x17932d+_0xf0b987;}};if(!this[_0x371d21(0x158)+_0x371d21(0x257)])return;if(!this[_0x371d21(0x9e8)+'er'])return;const _0x471cc5=Spriteset_Battle['ANTI_TINT_'+'UI']?this['_damageCon'+_0x371d21(0x257)]['x']:0x31*-0x7f+0x2ae+0x15a1,_0x23dd94=Spriteset_Battle[_0x371d21(0x7f4)+'UI']?this[_0x371d21(0x158)+_0x371d21(0x257)]['y']:0xe3*0x10+-0x5ec*0x1+-0x2*0x422,_0x2068d0=Imported[_0x371d21(0xc49)+'ctSeqCamer'+'a']?this[_0x371d21(0x1217)+'ld']['x']:0x15a+-0x2*-0xb1d+0x7dc*-0x3,_0x2b37fa=Imported[_0x371d21(0xc49)+_0x371d21(0x26a)+'a']?this[_0x371d21(0x1217)+'ld']['y']:0x1db3+0x17be+-0x3571;this[_0x371d21(0x9e8)+'er']['x']=_0x4259e8[_0x371d21(0x131a)](_0x471cc5,_0x2068d0),this[_0x371d21(0x9e8)+'er']['y']=_0x4259e8[_0x371d21(0xafc)](_0x23dd94,_0x2b37fa);},BattleManager['addChildTo'+_0xe90fac(0xec5)+'r']=function(_0x211e31){const _0x551d2a=_0xe90fac;if(!SceneManager[_0x551d2a(0x11dd)][_0x551d2a(0x9e8)+'er'])return;SceneManager[_0x551d2a(0x11dd)]['_uiContain'+'er']['addChild'](_0x211e31);},BattleManager[_0xe90fac(0xf46)+_0xe90fac(0x131e)+'tainer']=function(_0x4974f6){const _0xe8fe9c=_0xe90fac;if(!SceneManager[_0xe8fe9c(0x11dd)][_0xe8fe9c(0x9e8)+'er'])return;SceneManager[_0xe8fe9c(0x11dd)][_0xe8fe9c(0x9e8)+'er'][_0xe8fe9c(0xf46)+'d'](_0x4974f6);},Spriteset_Battle[_0xe90fac(0x510)][_0xe90fac(0xc5f)+_0xe90fac(0x10b7)+_0xe90fac(0x3a0)]=function(){return 0xfbf*0x1+0x8e3+-0x1*0x17a3;},Spriteset_Battle[_0xe90fac(0x510)][_0xe90fac(0x704)]=function(){return![];},Spriteset_Battle[_0xe90fac(0x510)][_0xe90fac(0x1101)+_0xe90fac(0x774)]=function(){const _0x2204c0=_0xe90fac;return this[_0x2204c0(0x1441)+'ites']()[_0x2204c0(0xcaa)](_0x48087f=>_0x48087f[_0x2204c0(0x8f3)]());},Spriteset_Battle['prototype'][_0xe90fac(0x917)+_0xe90fac(0x1291)]=function(){const _0x218965=_0xe90fac;return this[_0x218965(0x1441)+'ites']()[_0x218965(0xcaa)](_0x432934=>_0x432934[_0x218965(0x7df)]());},Spriteset_Battle['prototype']['isAnyoneGr'+'owing']=function(){const _0x5192e8=_0xe90fac;return this[_0x5192e8(0x1441)+_0x5192e8(0x235)]()[_0x5192e8(0xcaa)](_0x2961d8=>_0x2961d8[_0x5192e8(0x28c)]());},Spriteset_Battle[_0xe90fac(0x510)]['isAnyoneSk'+'ewing']=function(){const _0x4504ad=_0xe90fac;return this[_0x4504ad(0x1441)+_0x4504ad(0x235)]()[_0x4504ad(0xcaa)](_0x353d59=>_0x353d59[_0x4504ad(0xacc)]());},Spriteset_Battle[_0xe90fac(0x510)][_0xe90fac(0x997)+_0xe90fac(0x294)]=function(){const _0x5c421b=_0xe90fac;return this['battlerSpr'+_0x5c421b(0x235)]()[_0x5c421b(0xcaa)](_0xed2a11=>_0xed2a11['isSpinning']());},Spriteset_Battle[_0xe90fac(0x510)][_0xe90fac(0x144d)+_0xe90fac(0x3bc)+_0xe90fac(0x798)]=function(){const _0x580896=_0xe90fac;return this[_0x580896(0x1441)+_0x580896(0x235)]()[_0x580896(0xcaa)](_0x5bf908=>_0x5bf908['isChanging'+_0x580896(0xb61)]());},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x251)+_0xe90fac(0xefe)+_0xe90fac(0x134)]=Window_ItemList[_0xe90fac(0x510)][_0xe90fac(0x142f)],Window_ItemList[_0xe90fac(0x510)]['maxCols']=function(){const _0x5b3f04=_0xe90fac,_0x2d0b86={'oWyPe':function(_0x4e8e87,_0xe228c){return _0x4e8e87===_0xe228c;},'bxBsq':'border'};return SceneManager[_0x5b3f04(0x11be)+_0x5b3f04(0x3ad)]()?_0x2d0b86[_0x5b3f04(0xdc0)](SceneManager[_0x5b3f04(0x11dd)][_0x5b3f04(0x3a1)+_0x5b3f04(0x15fa)](),_0x2d0b86[_0x5b3f04(0x86d)])?VisuMZ[_0x5b3f04(0x118f)][_0x5b3f04(0x281)][_0x5b3f04(0x5a2)+'ut'][_0x5b3f04(0x1063)+_0x5b3f04(0x14b1)]:VisuMZ[_0x5b3f04(0x118f)]['Settings'][_0x5b3f04(0x5a2)+'ut'][_0x5b3f04(0x1147)+_0x5b3f04(0x1351)+'s']:VisuMZ[_0x5b3f04(0x118f)][_0x5b3f04(0x251)+_0x5b3f04(0xefe)+'ols'][_0x5b3f04(0x351)](this);},VisuMZ['BattleCore']['Window_Ski'+_0xe90fac(0xd5d)+'Cols']=Window_SkillList[_0xe90fac(0x510)][_0xe90fac(0x142f)],Window_SkillList[_0xe90fac(0x510)]['maxCols']=function(){const _0x48d4d5=_0xe90fac,_0x2726cc={'HVvmX':function(_0x2914c9,_0x3e9564){return _0x2914c9===_0x3e9564;},'VIoGS':'border'};return SceneManager[_0x48d4d5(0x11be)+'tle']()?_0x2726cc[_0x48d4d5(0x801)](SceneManager[_0x48d4d5(0x11dd)]['battleLayo'+_0x48d4d5(0x15fa)](),_0x2726cc[_0x48d4d5(0x218)])?VisuMZ[_0x48d4d5(0x118f)][_0x48d4d5(0x281)][_0x48d4d5(0x5a2)+'ut'][_0x48d4d5(0x1063)+_0x48d4d5(0x14b1)]:VisuMZ[_0x48d4d5(0x118f)][_0x48d4d5(0x281)][_0x48d4d5(0x5a2)+'ut']['SkillItemS'+_0x48d4d5(0x1351)+'s']:VisuMZ[_0x48d4d5(0x118f)][_0x48d4d5(0xcd5)+_0x48d4d5(0xd5d)+_0x48d4d5(0x209)]['call'](this);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x5c6)+_0xe90fac(0x103a)+_0xe90fac(0x10ab)+'ns']=Window_Options['prototype']['addGeneral'+_0xe90fac(0x14d7)],Window_Options['prototype']['addGeneral'+_0xe90fac(0x14d7)]=function(){const _0x4b1ed9=_0xe90fac;VisuMZ[_0x4b1ed9(0x118f)][_0x4b1ed9(0x5c6)+_0x4b1ed9(0x103a)+_0x4b1ed9(0x10ab)+'ns']['call'](this),this[_0x4b1ed9(0x13d1)+_0x4b1ed9(0x1515)+'s'](),this['addShowHpG'+'augeComman'+'d']();},Window_Options[_0xe90fac(0x510)][_0xe90fac(0x13d1)+_0xe90fac(0x1515)+'s']=function(){const _0x1dbe47=_0xe90fac;VisuMZ[_0x1dbe47(0x118f)][_0x1dbe47(0x281)][_0x1dbe47(0x33a)]['AddOption']&&(this[_0x1dbe47(0x156b)+'oreAutoBat'+_0x1dbe47(0x6c0)+'Command'](),this[_0x1dbe47(0x156b)+_0x1dbe47(0x691)+_0x1dbe47(0xe0c)+_0x1dbe47(0xc22)]());},Window_Options[_0xe90fac(0x510)][_0xe90fac(0x6f7)+'augeComman'+'d']=function(){const _0x57d5ad=_0xe90fac,_0x2e6bb5={'pfkDr':'visualHpGa'+_0x57d5ad(0x9dc)};if(!VisuMZ[_0x57d5ad(0x118f)][_0x57d5ad(0x281)][_0x57d5ad(0x10a9)][_0x57d5ad(0x262)+'Option'])return;const _0x1236c6=TextManager[_0x57d5ad(0x503)+_0x57d5ad(0x9dc)],_0x17f31b=_0x2e6bb5[_0x57d5ad(0x27a)];this[_0x57d5ad(0xbcb)](_0x1236c6,_0x17f31b);},Window_Options[_0xe90fac(0x510)][_0xe90fac(0x156b)+_0xe90fac(0x691)+_0xe90fac(0x6c0)+'Command']=function(){const _0x5f21b2=_0xe90fac,_0x19f4e0={'NcslW':_0x5f21b2(0xfa2)+_0x5f21b2(0x9fe)},_0x38bf82=TextManager[_0x5f21b2(0xfa2)+_0x5f21b2(0x854)],_0x4035ac=_0x19f4e0[_0x5f21b2(0x3e2)];this[_0x5f21b2(0xbcb)](_0x38bf82,_0x4035ac);},Window_Options[_0xe90fac(0x510)][_0xe90fac(0x156b)+_0xe90fac(0x691)+_0xe90fac(0xe0c)+'mmand']=function(){const _0x1e0d6b=_0xe90fac,_0x15b879={'VSrkg':_0x1e0d6b(0xfa2)+'UseSkills'},_0x1de7d5=TextManager[_0x1e0d6b(0xfa2)+_0x1e0d6b(0x10f9)],_0x2379c1=_0x15b879[_0x1e0d6b(0x360)];this['addCommand'](_0x1de7d5,_0x2379c1);},VisuMZ['BattleCore'][_0xe90fac(0x5c6)+_0xe90fac(0xb8b)+_0xe90fac(0x151a)]=Window_Options[_0xe90fac(0x510)][_0xe90fac(0x1021)],Window_Options['prototype'][_0xe90fac(0x1021)]=function(_0x1a5f75){const _0x5e0790=_0xe90fac,_0x30c34a={'jtttw':function(_0x360d4d,_0x47b0e3){return _0x360d4d===_0x47b0e3;},'VNWGY':_0x5e0790(0xfa2)+'UseSkills'},_0x530661=this[_0x5e0790(0x14b)+_0x5e0790(0x155f)](_0x1a5f75);return _0x30c34a['jtttw'](_0x530661,_0x30c34a['VNWGY'])?this[_0x5e0790(0x1021)+_0x5e0790(0x33a)+_0x5e0790(0x10f9)]():VisuMZ['BattleCore']['Window_Opt'+_0x5e0790(0xb8b)+_0x5e0790(0x151a)][_0x5e0790(0x351)](this,_0x1a5f75);},Window_Options[_0xe90fac(0x510)][_0xe90fac(0x1021)+_0xe90fac(0x33a)+_0xe90fac(0x10f9)]=function(){const _0x36d807=_0xe90fac,_0x2a6f2c={'IzRlq':_0x36d807(0xfa2)+_0x36d807(0x1b1)},_0xf75a86=VisuMZ[_0x36d807(0x118f)][_0x36d807(0x281)]['AutoBattle'],_0x3b205f=this['getConfigV'+_0x36d807(0xffb)](_0x2a6f2c[_0x36d807(0x14d)]);return _0x3b205f?_0xf75a86[_0x36d807(0x1421)]:_0xf75a86[_0x36d807(0x11cd)];},Window_ShopStatus[_0xe90fac(0x510)][_0xe90fac(0x1556)+'ageAmountL'+_0xe90fac(0xb8f)+_0xe90fac(0x126e)]=function(){const _0x1bd7d7=_0xe90fac,_0x1a4d16={'XWBvW':_0x1bd7d7(0x100e)+'%1'},_0x16b57d=DataManager[_0x1bd7d7(0x2d0)+_0x1bd7d7(0x951)](this['_item']),_0xebd8e4=VisuMZ[_0x1bd7d7(0x13f9)+'es'][_0x16b57d];if(!_0xebd8e4)return this[_0x1bd7d7(0x1556)+_0x1bd7d7(0xe2c)+_0x1bd7d7(0x843)+'al']();const _0x199f17=_0x1a4d16['XWBvW'][_0x1bd7d7(0xeb8)](this[_0x1bd7d7(0x731)][_0x1bd7d7(0x11df)][_0x1bd7d7(0x152a)]),_0x492c04=[null,TextManager['hp'],TextManager['mp'],TextManager['hp'],TextManager['mp'],TextManager['hp'],TextManager['mp']][this[_0x1bd7d7(0x731)][_0x1bd7d7(0x11df)][_0x1bd7d7(0x152a)]];return _0xebd8e4[_0x199f17]['format'](_0x492c04);},Window_ShopStatus[_0xe90fac(0x510)][_0xe90fac(0x1556)+_0xe90fac(0x1267)+_0xe90fac(0x117a)+_0xe90fac(0x86e)]=function(){const _0xe51689=_0xe90fac,_0x48a8ff=DataManager['getDamageS'+_0xe51689(0x951)](this[_0xe51689(0x731)]),_0x50fc58=VisuMZ[_0xe51689(0x13f9)+'es'][_0x48a8ff];if(!_0x50fc58)return this[_0xe51689(0x1556)+_0xe51689(0x1267)+'extOrigina'+'l']();return _0x50fc58[_0xe51689(0x1397)+_0xe51689(0xdf6)][_0xe51689(0x351)](this);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xc3e)+_0xe90fac(0x12b9)+'initialize']=Window_PartyCommand[_0xe90fac(0x510)][_0xe90fac(0xc68)],Window_PartyCommand[_0xe90fac(0x510)][_0xe90fac(0xc68)]=function(_0x5caa42){const _0x437f52=_0xe90fac;VisuMZ[_0x437f52(0x118f)]['Window_Par'+_0x437f52(0x12b9)+'initialize'][_0x437f52(0x351)](this,_0x5caa42),this[_0x437f52(0x939)+_0x437f52(0x236)+_0x437f52(0x1600)](_0x5caa42);},Window_PartyCommand[_0xe90fac(0x510)]['createComm'+_0xe90fac(0x236)+_0xe90fac(0x1600)]=function(_0x5cc3f1){const _0xc8f208=_0xe90fac,_0x3ac45a=new Rectangle(0x339+-0x1*-0xa99+-0xdd2,0x26b8+-0xb2*0x14+-0x18d0,_0x5cc3f1[_0xc8f208(0x301)],_0x5cc3f1[_0xc8f208(0xa68)]);this[_0xc8f208(0x6a8)+'meWindow']=new Window_Base(_0x3ac45a),this[_0xc8f208(0x6a8)+_0xc8f208(0x992)][_0xc8f208(0xfac)]=0x266d+-0x42a+-0xb3*0x31,this[_0xc8f208(0xda3)](this[_0xc8f208(0x6a8)+_0xc8f208(0x992)]),this[_0xc8f208(0xa78)+_0xc8f208(0x236)+'dow']();},Window_PartyCommand[_0xe90fac(0x510)]['callUpdate'+_0xe90fac(0x112c)]=function(){const _0x477e4f=_0xe90fac;Window_Command[_0x477e4f(0x510)]['callUpdate'+_0x477e4f(0x112c)]['call'](this);if(this[_0x477e4f(0x6a8)+_0x477e4f(0x992)])this['updateComm'+_0x477e4f(0x236)+_0x477e4f(0x1600)]();},Window_PartyCommand[_0xe90fac(0x510)]['updateComm'+_0xe90fac(0x236)+_0xe90fac(0x1600)]=function(){const _0x95a3b8=_0xe90fac,_0x17b4ee={'PEkGq':function(_0x2433c5,_0x3bdf75){return _0x2433c5===_0x3bdf75;},'kqHMS':_0x95a3b8(0x274),'uOJRo':function(_0xa40cd0,_0x25cecf){return _0xa40cd0>_0x25cecf;}},_0x3ede8c=this['_commandNa'+_0x95a3b8(0x992)];_0x3ede8c[_0x95a3b8(0x141e)][_0x95a3b8(0xf98)]();const _0x37f3b8=this['commandSty'+_0x95a3b8(0x148c)](this['index']());if(_0x17b4ee[_0x95a3b8(0xbfe)](_0x37f3b8,_0x17b4ee[_0x95a3b8(0x681)])&&_0x17b4ee[_0x95a3b8(0x141)](this[_0x95a3b8(0x44e)](),0x397*-0x6+-0x1ada+-0x4c*-0xa3)){const _0x5246a6=this[_0x95a3b8(0x789)+'ct'](this[_0x95a3b8(0x96c)]());let _0x5ab624=this[_0x95a3b8(0x726)+'e'](this[_0x95a3b8(0x96c)]());_0x5ab624=_0x5ab624[_0x95a3b8(0x1144)](/\\I\[(\d+)\]/gi,''),_0x3ede8c['resetFontS'+_0x95a3b8(0x29c)](),this[_0x95a3b8(0x726)+'eWindowDra'+_0x95a3b8(0x136c)+'d'](_0x5ab624,_0x5246a6),this[_0x95a3b8(0x726)+_0x95a3b8(0x596)+_0x95a3b8(0xbd9)](_0x5ab624,_0x5246a6),this[_0x95a3b8(0x726)+'eWindowCen'+_0x95a3b8(0xca4)](_0x5ab624,_0x5246a6);}},Window_PartyCommand[_0xe90fac(0x510)]['commandNam'+_0xe90fac(0x596)+'wBackgroun'+'d']=function(_0x51a53f,_0x81f850){},Window_PartyCommand[_0xe90fac(0x510)][_0xe90fac(0x726)+_0xe90fac(0x596)+_0xe90fac(0xbd9)]=function(_0x3d023e,_0x219262){const _0x5ce2fe=_0xe90fac,_0x12eca8={'zXAUz':_0x5ce2fe(0x8dd)},_0x754dbb=this['_commandNa'+'meWindow'];_0x754dbb[_0x5ce2fe(0xa07)](_0x3d023e,0x238+0x1*0x10a6+-0x12de,_0x219262['y'],_0x754dbb[_0x5ce2fe(0x74b)],_0x12eca8['zXAUz']);},Window_PartyCommand[_0xe90fac(0x510)][_0xe90fac(0x726)+_0xe90fac(0xee4)+_0xe90fac(0xca4)]=function(_0x39db93,_0x4921be){const _0x47a30c=_0xe90fac,_0x5270db={'dcUtt':function(_0x5a8fe9,_0x351ed2){return _0x5a8fe9+_0x351ed2;},'HHEEB':function(_0x5a02b4,_0x219fb1){return _0x5a02b4/_0x219fb1;},'HGIuc':function(_0xc4f3ac,_0x36b162){return _0xc4f3ac/_0x36b162;}},_0x40e78f=this[_0x47a30c(0x6a8)+_0x47a30c(0x992)],_0x1a07d2=$gameSystem['windowPadd'+'ing'](),_0x4f3689=_0x5270db[_0x47a30c(0xb32)](_0x5270db[_0x47a30c(0xb32)](_0x4921be['x'],Math[_0x47a30c(0x12be)](_0x5270db['HHEEB'](_0x4921be[_0x47a30c(0x301)],-0x5*-0x65+-0x15*-0xef+-0x1592))),_0x1a07d2);_0x40e78f['x']=_0x5270db[_0x47a30c(0xb32)](_0x5270db[_0x47a30c(0xfba)](_0x40e78f[_0x47a30c(0x301)],-(0xf1*0x1d+-0x49*-0xb+-0x1e6e)),_0x4f3689),_0x40e78f['y']=Math['floor'](_0x5270db['HGIuc'](_0x4921be['height'],-0x21*-0x16+0x25*0xb+-0x46b));},Window_PartyCommand[_0xe90fac(0x510)][_0xe90fac(0x648)+_0xe90fac(0x8e0)]=function(){const _0x218897=_0xe90fac,_0x3d9cc0={'KWdGE':_0x218897(0x614)},_0x894e5e=_0x3d9cc0[_0x218897(0x5fd)]['split']('|');let _0x224f02=0x1336+0x25a9+0x45*-0xd3;while(!![]){switch(_0x894e5e[_0x224f02++]){case'0':this[_0x218897(0x13d1)+'tleCommand']();continue;case'1':this[_0x218897(0xcf8)+'mmand']();continue;case'2':this[_0x218897(0x14f6)+'ommands']();continue;case'3':this[_0x218897(0x1bd)+'ommand']();continue;case'4':this[_0x218897(0x615)+_0x218897(0x1290)]();continue;}break;}},Window_PartyCommand[_0xe90fac(0x510)][_0xe90fac(0xcf8)+_0xe90fac(0xc22)]=function(){const _0x211774=_0xe90fac,_0x1ea4d5={'GDUaj':function(_0x383276,_0x2caaf1){return _0x383276===_0x2caaf1;},'UYnfr':_0x211774(0x10aa),'eFBgw':_0x211774(0x768),'fYPHU':_0x211774(0x56c)},_0x4e3d29=this[_0x211774(0xd80)+'le'](),_0x950a02=VisuMZ[_0x211774(0x118f)][_0x211774(0x281)][_0x211774(0x1463)]['CmdIconFig'+'ht'],_0x15ff94=_0x1ea4d5[_0x211774(0xb38)](_0x4e3d29,_0x1ea4d5[_0x211774(0x12b5)])?TextManager[_0x211774(0x56c)]:_0x1ea4d5[_0x211774(0x3e5)][_0x211774(0xeb8)](_0x950a02,TextManager[_0x211774(0x56c)]),_0x3f11c3=this['isFightCom'+'mandEnable'+'d']();this[_0x211774(0xbcb)](_0x15ff94,_0x1ea4d5[_0x211774(0x1dc)],_0x3f11c3);},Window_PartyCommand[_0xe90fac(0x510)][_0xe90fac(0x1130)+_0xe90fac(0xc2a)+'d']=function(){return!![];},Window_PartyCommand['prototype'][_0xe90fac(0x13d1)+_0xe90fac(0x1515)]=function(){const _0x5c1866=_0xe90fac,_0x34eaa7={'UAMvn':function(_0x26f99a,_0x11279f){return _0x26f99a===_0x11279f;},'aANcw':'text','yNgRE':'\x5cI[%1]%2','WfBCL':_0x5c1866(0xfa2)};if(!this[_0x5c1866(0x9a9)+'leCommandA'+_0x5c1866(0xece)]())return;const _0x13e85d=this[_0x5c1866(0xd80)+'le'](),_0x221f92=VisuMZ[_0x5c1866(0x118f)][_0x5c1866(0x281)][_0x5c1866(0x1463)][_0x5c1866(0x886)+_0x5c1866(0x912)],_0x2db6d6=_0x34eaa7[_0x5c1866(0x3f0)](_0x13e85d,_0x34eaa7[_0x5c1866(0xe87)])?TextManager[_0x5c1866(0xfa2)]:_0x34eaa7[_0x5c1866(0xf72)][_0x5c1866(0xeb8)](_0x221f92,TextManager['autoBattle']),_0x4842c8=this[_0x5c1866(0x9a9)+_0x5c1866(0x1481)+_0x5c1866(0xcb6)]();this[_0x5c1866(0xbcb)](_0x2db6d6,_0x34eaa7[_0x5c1866(0x934)],_0x4842c8);},Window_PartyCommand[_0xe90fac(0x510)][_0xe90fac(0x9a9)+_0xe90fac(0x875)+_0xe90fac(0xece)]=function(){const _0x29fc51=_0xe90fac;return VisuMZ['BattleCore'][_0x29fc51(0x281)][_0x29fc51(0x1463)][_0x29fc51(0x144a)+_0x29fc51(0x33a)];},Window_PartyCommand[_0xe90fac(0x510)][_0xe90fac(0x9a9)+_0xe90fac(0x1481)+_0xe90fac(0xcb6)]=function(){return!![];},Window_PartyCommand[_0xe90fac(0x510)][_0xe90fac(0x14f6)+'ommands']=function(){},Window_PartyCommand[_0xe90fac(0x510)][_0xe90fac(0x615)+_0xe90fac(0x1290)]=function(){const _0x4ec021=_0xe90fac,_0x4c41c7={'tNXIY':function(_0x18ee69,_0x346bdf){return _0x18ee69===_0x346bdf;},'eTpPF':'text','iwBRc':_0x4ec021(0x768),'WIqdO':_0x4ec021(0x586)};if(!this[_0x4ec021(0x448)+'ommandAdde'+'d']())return;const _0x244423=this[_0x4ec021(0xd80)+'le'](),_0x401af5=VisuMZ[_0x4ec021(0x118f)][_0x4ec021(0x281)][_0x4ec021(0x1463)][_0x4ec021(0xa0e)+_0x4ec021(0x1ab)],_0x34fd04=_0x4c41c7[_0x4ec021(0xb3)](_0x244423,_0x4c41c7[_0x4ec021(0xe2a)])?TextManager[_0x4ec021(0x586)]:_0x4c41c7[_0x4ec021(0xeea)][_0x4ec021(0xeb8)](_0x401af5,TextManager[_0x4ec021(0x586)]),_0x4728dc=this['isOptionsC'+_0x4ec021(0xad5)+_0x4ec021(0x1211)]();this[_0x4ec021(0xbcb)](_0x34fd04,_0x4c41c7[_0x4ec021(0x255)],_0x4728dc);},Window_PartyCommand[_0xe90fac(0x510)][_0xe90fac(0x448)+_0xe90fac(0x1601)+'d']=function(){const _0x4fdf3d=_0xe90fac;return VisuMZ['BattleCore'][_0x4fdf3d(0x281)][_0x4fdf3d(0x1463)]['CommandAdd'+'Options'];},Window_PartyCommand['prototype']['isOptionsC'+_0xe90fac(0xad5)+'led']=function(){return!![];},Window_PartyCommand[_0xe90fac(0x510)][_0xe90fac(0x1bd)+_0xe90fac(0x131)]=function(){const _0x248f45=_0xe90fac,_0x29290d={'ttiJo':function(_0x3dbc31,_0x838787){return _0x3dbc31===_0x838787;},'EmcgS':_0x248f45(0x10aa),'frzHY':_0x248f45(0x768),'bsvFA':'escape'},_0x4def97=this[_0x248f45(0xd80)+'le'](),_0x2e2176=VisuMZ[_0x248f45(0x118f)]['Settings']['PartyCmd'][_0x248f45(0xaf2)+_0x248f45(0x109e)],_0x53c334=_0x29290d[_0x248f45(0x132)](_0x4def97,_0x29290d['EmcgS'])?TextManager['escape']:_0x29290d[_0x248f45(0x3a4)][_0x248f45(0xeb8)](_0x2e2176,TextManager[_0x248f45(0xa34)]),_0x1ec100=this[_0x248f45(0xcc9)+'mmandEnabl'+'ed']();this[_0x248f45(0xbcb)](_0x53c334,_0x29290d['bsvFA'],_0x1ec100);},Window_PartyCommand[_0xe90fac(0x510)]['isEscapeCo'+_0xe90fac(0xf4f)+'ed']=function(){const _0x215232=_0xe90fac;return BattleManager[_0x215232(0x254)]();},Window_PartyCommand[_0xe90fac(0x510)][_0xe90fac(0x5a7)+'ign']=function(){const _0x9835a6=_0xe90fac;return VisuMZ['BattleCore'][_0x9835a6(0x281)]['PartyCmd'][_0x9835a6(0x6f3)+'gn'];},Window_PartyCommand[_0xe90fac(0x510)][_0xe90fac(0x3bf)]=function(_0x27733b){const _0x4bc023=_0xe90fac,_0x5ee601={'BvnBH':function(_0x195a82,_0x16651a){return _0x195a82===_0x16651a;},'YRhxZ':_0x4bc023(0x4f4),'uSSgn':function(_0x346b00,_0x140042){return _0x346b00===_0x140042;},'JyrUs':_0x4bc023(0x274)},_0x1dd9be=this[_0x4bc023(0xd80)+_0x4bc023(0x148c)](_0x27733b);if(_0x5ee601['BvnBH'](_0x1dd9be,_0x5ee601[_0x4bc023(0x108d)]))this[_0x4bc023(0x710)+'yleIconTex'+'t'](_0x27733b);else _0x5ee601[_0x4bc023(0x98b)](_0x1dd9be,_0x5ee601['JyrUs'])?this[_0x4bc023(0x710)+'yleIcon'](_0x27733b):Window_Command[_0x4bc023(0x510)][_0x4bc023(0x3bf)][_0x4bc023(0x351)](this,_0x27733b);},Window_PartyCommand[_0xe90fac(0x510)][_0xe90fac(0xd80)+'le']=function(){const _0x143118=_0xe90fac;return VisuMZ[_0x143118(0x118f)][_0x143118(0x281)][_0x143118(0x1463)][_0x143118(0x8be)];},Window_PartyCommand['prototype'][_0xe90fac(0xd80)+'leCheck']=function(_0x4a140e){const _0x12daca=_0xe90fac,_0x3d3559={'uaBeQ':function(_0x1fb39d,_0x9e9021){return _0x1fb39d<_0x9e9021;},'SIjLk':_0x12daca(0x10aa),'Qoxjt':function(_0x4f41f5,_0x24f00d){return _0x4f41f5!==_0x24f00d;},'VRhDd':'auto','XVjWA':function(_0x1da2fb,_0x653da0){return _0x1da2fb>_0x653da0;},'bQXpO':function(_0x40029e,_0x5314c9){return _0x40029e<=_0x5314c9;},'zaImY':_0x12daca(0x4f4),'FdVLg':'icon'};if(_0x3d3559[_0x12daca(0x1391)](_0x4a140e,0x957+0x4c1*-0x7+0x17f0))return _0x3d3559[_0x12daca(0x6dd)];const _0x5a7d31=this['commandSty'+'le']();if(_0x3d3559[_0x12daca(0x785)](_0x5a7d31,_0x3d3559[_0x12daca(0xeb9)]))return _0x5a7d31;else{if(_0x3d3559[_0x12daca(0xb85)](this[_0x12daca(0x44e)](),-0x1bb6+0x257*0xb+0x1f9)){const _0x269dbb=this[_0x12daca(0x726)+'e'](_0x4a140e);if(_0x269dbb[_0x12daca(0x3eb)](/\\I\[(\d+)\]/i)){const _0x4ce616=this['itemLineRe'+'ct'](_0x4a140e),_0x5f5497=this[_0x12daca(0x2a1)](_0x269dbb)[_0x12daca(0x301)];return _0x3d3559[_0x12daca(0x9a3)](_0x5f5497,_0x4ce616['width'])?_0x3d3559[_0x12daca(0x15e)]:_0x3d3559[_0x12daca(0x1241)];}}}return _0x3d3559[_0x12daca(0x6dd)];},Window_PartyCommand[_0xe90fac(0x510)][_0xe90fac(0x710)+_0xe90fac(0x896)+'t']=function(_0x17636d){const _0x10c48a=_0xe90fac,_0x243588={'CYudp':function(_0x2a7063,_0x3c3d9a){return _0x2a7063===_0x3c3d9a;},'cAolD':_0x10c48a(0x8d8),'flvHf':function(_0x20d442,_0x385131){return _0x20d442-_0x385131;},'jRdwb':function(_0x27434f,_0x11ef19){return _0x27434f+_0x11ef19;},'VuuRX':_0x10c48a(0x8dd),'KYXCQ':function(_0x5e31e5,_0x48117e){return _0x5e31e5/_0x48117e;},'nMTUm':function(_0x3b0530,_0x162059){return _0x3b0530-_0x162059;}},_0x583fc2=this[_0x10c48a(0x789)+'ct'](_0x17636d),_0x467268=this[_0x10c48a(0x726)+'e'](_0x17636d),_0x2e579a=this[_0x10c48a(0x2a1)](_0x467268)[_0x10c48a(0x301)];this['changePain'+_0x10c48a(0x264)](this[_0x10c48a(0xd54)+_0x10c48a(0xcb6)](_0x17636d));const _0x2c25b8=this['itemTextAl'+'ign']();if(_0x243588[_0x10c48a(0x396)](_0x2c25b8,_0x243588[_0x10c48a(0x4cb)]))this[_0x10c48a(0x1002)](_0x467268,_0x243588[_0x10c48a(0x330)](_0x243588[_0x10c48a(0x12c2)](_0x583fc2['x'],_0x583fc2['width']),_0x2e579a),_0x583fc2['y'],_0x2e579a);else{if(_0x243588['CYudp'](_0x2c25b8,_0x243588[_0x10c48a(0x73e)])){const _0x170b4b=_0x243588['jRdwb'](_0x583fc2['x'],Math[_0x10c48a(0x12be)](_0x243588[_0x10c48a(0xd79)](_0x243588[_0x10c48a(0xd95)](_0x583fc2[_0x10c48a(0x301)],_0x2e579a),0x114b+-0x1*-0x32+-0xb3*0x19)));this['drawTextEx'](_0x467268,_0x170b4b,_0x583fc2['y'],_0x2e579a);}else this['drawTextEx'](_0x467268,_0x583fc2['x'],_0x583fc2['y'],_0x2e579a);}},Window_PartyCommand[_0xe90fac(0x510)]['drawItemSt'+'yleIcon']=function(_0x266674){const _0x1dde85=_0xe90fac,_0x43c5d4={'RdNHK':function(_0x3c2f7a,_0x255b68){return _0x3c2f7a(_0x255b68);},'xQiKd':function(_0x401aea,_0x525524){return _0x401aea+_0x525524;},'xXKZa':function(_0x1ff0af,_0x529cb1){return _0x1ff0af/_0x529cb1;},'hiLsa':function(_0x4bcc27,_0x32dbf3){return _0x4bcc27-_0x32dbf3;},'uosfT':function(_0xbd932,_0x572c32){return _0xbd932-_0x572c32;}};this[_0x1dde85(0x726)+'e'](_0x266674)[_0x1dde85(0x3eb)](/\\I\[(\d+)\]/i);const _0x16d288=_0x43c5d4[_0x1dde85(0xea5)](Number,RegExp['$1'])||0x24c9+-0x267+-0x2262,_0x5efe45=this['itemLineRe'+'ct'](_0x266674),_0x43428f=_0x43c5d4[_0x1dde85(0xaba)](_0x5efe45['x'],Math[_0x1dde85(0x12be)](_0x43c5d4[_0x1dde85(0x1295)](_0x43c5d4[_0x1dde85(0x155a)](_0x5efe45['width'],ImageManager[_0x1dde85(0x172)]),-0x827+-0x189f*-0x1+-0x1076))),_0x5c65e2=_0x43c5d4['xQiKd'](_0x5efe45['y'],_0x43c5d4[_0x1dde85(0x1295)](_0x43c5d4['uosfT'](_0x5efe45['height'],ImageManager['iconHeight']),0x6d*-0x4+0x2180*0x1+0x272*-0xd));this[_0x1dde85(0xe01)](_0x16d288,_0x43428f,_0x5c65e2);},Window_PartyCommand[_0xe90fac(0x510)]['hide']=function(){},Window_PartyCommand[_0xe90fac(0x510)][_0xe90fac(0xa3a)]=function(){const _0x476da5=_0xe90fac,_0x42cc2e={'BFTcw':function(_0x5343e9,_0x307010){return _0x5343e9===_0x307010;},'HokjT':_0x476da5(0xea1)};Window_Command[_0x476da5(0x510)][_0x476da5(0xa3a)][_0x476da5(0x351)](this);const _0x190e22=this[_0x476da5(0x3a1)+_0x476da5(0x15fa)]();_0x42cc2e[_0x476da5(0xc56)](_0x190e22,_0x42cc2e[_0x476da5(0x9b0)])&&this[_0x476da5(0xd02)+_0x476da5(0xd82)]();},Window_PartyCommand[_0xe90fac(0x510)][_0xe90fac(0x3a1)+_0xe90fac(0x15fa)]=function(){const _0x59b1d2=_0xe90fac;if(this[_0x59b1d2(0xdca)+_0x59b1d2(0x309)])return this['_battleLay'+_0x59b1d2(0x309)];return this[_0x59b1d2(0xdca)+_0x59b1d2(0x309)]=SceneManager[_0x59b1d2(0x11dd)]['battleLayo'+_0x59b1d2(0x15fa)](),this[_0x59b1d2(0xdca)+_0x59b1d2(0x309)];},Window_PartyCommand['prototype'][_0xe90fac(0x1529)]=function(){const _0x718eb7=_0xe90fac,_0x507e34={'qjSZe':'fight','XdfrH':_0x718eb7(0xfa2),'gChzS':_0x718eb7(0x586),'SLGAq':'escape'},_0xaa7e86=VisuMZ[_0x718eb7(0x118f)]['Settings'][_0x718eb7(0x1463)],_0x1668ce=this[_0x718eb7(0x4f2)+_0x718eb7(0x155f)]();switch(_0x1668ce){case _0x507e34[_0x718eb7(0xb58)]:this[_0x718eb7(0x507)+'w']['setText'](_0xaa7e86[_0x718eb7(0x1067)]);break;case _0x507e34[_0x718eb7(0x12f6)]:this[_0x718eb7(0x507)+'w'][_0x718eb7(0x52e)](_0xaa7e86['HelpAutoBa'+'ttle']);break;case _0x507e34[_0x718eb7(0x9af)]:this[_0x718eb7(0x507)+'w']['setText'](_0xaa7e86[_0x718eb7(0x918)+'s']);break;case _0x507e34[_0x718eb7(0x855)]:this['_helpWindo'+'w']['setText'](_0xaa7e86[_0x718eb7(0x14cf)]);break;default:this[_0x718eb7(0x507)+'w'][_0x718eb7(0x52e)]('');break;}},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x1439)+'orCommand_'+'initialize']=Window_ActorCommand[_0xe90fac(0x510)][_0xe90fac(0xc68)],Window_ActorCommand[_0xe90fac(0x510)][_0xe90fac(0xc68)]=function(_0x202967){const _0x40e02a=_0xe90fac;VisuMZ[_0x40e02a(0x118f)][_0x40e02a(0x1439)+_0x40e02a(0x51d)+_0x40e02a(0xc68)][_0x40e02a(0x351)](this,_0x202967),this['createComm'+'andNameWin'+_0x40e02a(0x1600)](_0x202967);},Window_ActorCommand[_0xe90fac(0x510)][_0xe90fac(0x939)+'andNameWin'+'dow']=function(_0x4d145f){const _0x569c3b=_0xe90fac,_0x21b47b=new Rectangle(-0x10af+-0x5*0x5e9+0x21a*0x16,0xe76+0x1*-0x1ca7+-0xe31*-0x1,_0x4d145f['width'],_0x4d145f[_0x569c3b(0xa68)]);this['_commandNa'+_0x569c3b(0x992)]=new Window_Base(_0x21b47b),this[_0x569c3b(0x6a8)+_0x569c3b(0x992)][_0x569c3b(0xfac)]=-0x15bb+0x1*0x25fd+0x1042*-0x1,this[_0x569c3b(0xda3)](this[_0x569c3b(0x6a8)+'meWindow']),this['updateComm'+_0x569c3b(0x236)+'dow']();},Window_ActorCommand[_0xe90fac(0x510)]['callUpdate'+_0xe90fac(0x112c)]=function(){const _0x58714f=_0xe90fac;Window_Command[_0x58714f(0x510)]['callUpdate'+'Help'][_0x58714f(0x351)](this);if(this[_0x58714f(0x6a8)+_0x58714f(0x992)])this[_0x58714f(0xa78)+_0x58714f(0x236)+'dow']();},Window_ActorCommand['prototype']['updateComm'+_0xe90fac(0x236)+'dow']=function(){const _0x3fe33d=_0xe90fac,_0x4cb323={'aeGiq':function(_0x38f8fe,_0xb14833){return _0x38f8fe===_0xb14833;},'jTKgR':_0x3fe33d(0x274),'VFEhZ':function(_0x48e89d,_0x4ac2c2){return _0x48e89d>_0x4ac2c2;}},_0x488b39=this[_0x3fe33d(0x6a8)+_0x3fe33d(0x992)];_0x488b39[_0x3fe33d(0x141e)][_0x3fe33d(0xf98)]();const _0xf4f436=this['commandSty'+_0x3fe33d(0x148c)](this[_0x3fe33d(0x96c)]());if(_0x4cb323[_0x3fe33d(0x570)](_0xf4f436,_0x4cb323[_0x3fe33d(0x4ab)])&&_0x4cb323[_0x3fe33d(0xb93)](this[_0x3fe33d(0x44e)](),-0x17d3+0x1f9f+-0x2*0x3e6)){const _0x1e6ced=this[_0x3fe33d(0x789)+'ct'](this[_0x3fe33d(0x96c)]());let _0x2b2c16=this[_0x3fe33d(0x726)+'e'](this['index']());_0x2b2c16=_0x2b2c16[_0x3fe33d(0x1144)](/\\I\[(\d+)\]/gi,''),_0x488b39[_0x3fe33d(0x160c)+'ettings'](),this[_0x3fe33d(0x726)+'eWindowDra'+_0x3fe33d(0x136c)+'d'](_0x2b2c16,_0x1e6ced),this[_0x3fe33d(0x726)+'eWindowDra'+_0x3fe33d(0xbd9)](_0x2b2c16,_0x1e6ced),this[_0x3fe33d(0x726)+_0x3fe33d(0xee4)+_0x3fe33d(0xca4)](_0x2b2c16,_0x1e6ced);}},Window_ActorCommand[_0xe90fac(0x510)]['commandNam'+'eWindowDra'+_0xe90fac(0x136c)+'d']=function(_0x2bb254,_0x449087){},Window_ActorCommand[_0xe90fac(0x510)][_0xe90fac(0x726)+_0xe90fac(0x596)+_0xe90fac(0xbd9)]=function(_0x3c7be2,_0x5d7d6d){const _0x2422f1=_0xe90fac,_0x433038={'echcq':_0x2422f1(0x8dd)},_0x3977e4=this['_commandNa'+'meWindow'];_0x3977e4['drawText'](_0x3c7be2,0xb06+-0x34*-0x45+-0x190a,_0x5d7d6d['y'],_0x3977e4[_0x2422f1(0x74b)],_0x433038[_0x2422f1(0x15fc)]);},Window_ActorCommand[_0xe90fac(0x510)][_0xe90fac(0x726)+'eWindowCen'+'ter']=function(_0xe79d82,_0x4c99d2){const _0x3f3b96=_0xe90fac,_0x41e1c4={'yyqoB':function(_0x19cb4d,_0x41f226){return _0x19cb4d+_0x41f226;},'fmbsg':function(_0x577f34,_0x3374c1){return _0x577f34+_0x3374c1;},'GoEMr':function(_0x200005,_0xb021fb){return _0x200005/_0xb021fb;},'imwBU':function(_0x3eb071,_0x123b13){return _0x3eb071+_0x123b13;},'BcVwN':function(_0x43d734,_0x4f84b1){return _0x43d734/_0x4f84b1;}},_0xfd00ff=this[_0x3f3b96(0x6a8)+'meWindow'],_0x4eb317=$gameSystem[_0x3f3b96(0x3e8)+_0x3f3b96(0x312)](),_0x987e23=_0x41e1c4['yyqoB'](_0x41e1c4['fmbsg'](_0x4c99d2['x'],Math['floor'](_0x41e1c4[_0x3f3b96(0x1288)](_0x4c99d2[_0x3f3b96(0x301)],0x609+0xbf1*0x1+-0x11f8))),_0x4eb317);_0xfd00ff['x']=_0x41e1c4[_0x3f3b96(0x2fe)](_0x41e1c4[_0x3f3b96(0x1288)](_0xfd00ff[_0x3f3b96(0x301)],-(-0x645+-0xa*0x365+0x2839)),_0x987e23),_0xfd00ff['y']=Math[_0x3f3b96(0x12be)](_0x41e1c4[_0x3f3b96(0xea6)](_0x4c99d2[_0x3f3b96(0xa68)],0x1*-0x212b+-0x130a+0x1*0x3437));},Window_ActorCommand[_0xe90fac(0x510)][_0xe90fac(0x648)+_0xe90fac(0x8e0)]=function(){const _0x22557a=_0xe90fac;if(!this[_0x22557a(0x69c)])return;const _0x5d4efb=this['_actor'][_0x22557a(0x750)+_0x22557a(0x780)]();for(const _0x11a851 of _0x5d4efb){this[_0x22557a(0x2c7)+_0x22557a(0x1290)](_0x11a851[_0x22557a(0x1318)+'e']()[_0x22557a(0x808)]());}},Window_ActorCommand[_0xe90fac(0x510)]['makeBattle'+'Command']=function(_0x2694b1){const _0x3ba937=_0xe90fac,_0x17bad3={'jRSVJ':function(_0x535481,_0x32b090){return _0x535481===_0x32b090;},'Xgsen':_0x3ba937(0x1db),'odsUZ':_0x3ba937(0x8b4),'QGFFd':'SKILLS','NHkzW':function(_0x463ba1,_0x4ffb3e){return _0x463ba1===_0x4ffb3e;},'whMHN':_0x3ba937(0x1088),'aHcuY':function(_0x3bf26c,_0x424f07){return _0x3bf26c===_0x424f07;},'LZXOR':_0x3ba937(0xd48),'txRDB':function(_0x15963d,_0x4830b8){return _0x15963d===_0x4830b8;},'GLSVF':_0x3ba937(0x1190),'JFBGJ':function(_0x5f073f,_0x5907ca){return _0x5f073f===_0x5907ca;},'pqLVq':'AUTO\x20BATTL'+'E','jghEj':function(_0x37b3e6,_0x226f77){return _0x37b3e6(_0x226f77);},'YRkUQ':function(_0x1097f6,_0x3e81fc){return _0x1097f6===_0x3e81fc;},'HDofy':_0x3ba937(0x9f2),'LTMSX':function(_0x1cec34,_0x4eb16d){return _0x1cec34(_0x4eb16d);},'GWehA':'PARTY','GvelY':_0x3ba937(0xdf9),'KJboe':_0x3ba937(0x5f5),'MMRQx':function(_0x4e1ab4,_0x5950d2){return _0x4e1ab4===_0x5950d2;},'yjhfd':_0x3ba937(0x6cf)+'P','quLHi':_0x3ba937(0x616)};_0x17bad3[_0x3ba937(0x1cf)](_0x2694b1,_0x17bad3[_0x3ba937(0x7bc)])&&this[_0x3ba937(0xd6e)+'ommand']();[_0x17bad3[_0x3ba937(0x471)],_0x17bad3[_0x3ba937(0x1467)]]['includes'](_0x2694b1)&&this[_0x3ba937(0xaf5)+_0x3ba937(0x7e0)]();_0x17bad3[_0x3ba937(0xa1d)](_0x2694b1,_0x17bad3['whMHN'])&&this[_0x3ba937(0x38f)+'mmand']();_0x17bad3[_0x3ba937(0xacf)](_0x2694b1,_0x17bad3[_0x3ba937(0x11e3)])&&this[_0x3ba937(0x12c)+_0x3ba937(0x1a5)]();_0x17bad3[_0x3ba937(0xbc)](_0x2694b1,_0x17bad3[_0x3ba937(0x131d)])&&this['addEscapeC'+'ommand']();_0x17bad3[_0x3ba937(0xc1a)](_0x2694b1,_0x17bad3[_0x3ba937(0x119f)])&&this[_0x3ba937(0x13d1)+_0x3ba937(0x1515)]();if(_0x2694b1['match'](/STYPE: (\d+)/i)){const _0x1c496e=_0x17bad3[_0x3ba937(0xb14)](Number,RegExp['$1']);this['addSkillTy'+'peCommand'](_0x1c496e);}else{if(_0x2694b1[_0x3ba937(0x3eb)](/STYPE: (.*)/i)){const _0x56c501=DataManager['getStypeId'+_0x3ba937(0xdd9)](RegExp['$1']);this[_0x3ba937(0xe0a)+_0x3ba937(0xf1)](_0x56c501);}}_0x17bad3[_0x3ba937(0xcaf)](_0x2694b1,_0x17bad3[_0x3ba937(0x14bb)])&&this[_0x3ba937(0xa32)+'killComman'+'ds']();if(_0x2694b1[_0x3ba937(0x3eb)](/SKILL: (\d+)/i)){const _0x31cc69=_0x17bad3[_0x3ba937(0xec1)](Number,RegExp['$1']);this[_0x3ba937(0xa32)+_0x3ba937(0xc97)+'d']($dataSkills[_0x31cc69]);}else{if(_0x2694b1[_0x3ba937(0x3eb)](/SKILL: (.*)/i)){const _0x430b91=DataManager[_0x3ba937(0x5b5)+'WithName'](RegExp['$1']);this[_0x3ba937(0xa32)+_0x3ba937(0xc97)+'d']($dataSkills[_0x430b91]);}}_0x17bad3[_0x3ba937(0x1cf)](_0x2694b1,_0x17bad3[_0x3ba937(0xee1)])&&Imported[_0x3ba937(0xe05)+'artySystem']&&this[_0x3ba937(0x13b1)+_0x3ba937(0xc22)](),[_0x17bad3[_0x3ba937(0x1340)],_0x17bad3[_0x3ba937(0x556)]]['includes'](_0x2694b1)&&Imported['VisuMZ_4_C'+_0x3ba937(0xb89)]&&this[_0x3ba937(0x1423)+_0x3ba937(0xc33)](),_0x17bad3[_0x3ba937(0x380)](_0x2694b1,_0x17bad3['yjhfd'])&&Imported['VisuMZ_2_W'+_0x3ba937(0xf2)+'ystem']&&this[_0x3ba937(0x52d)+'wapCommand'](!![]),_0x17bad3['NHkzW'](_0x2694b1,_0x17bad3[_0x3ba937(0x115f)])&&Imported['VisuMZ_2_B'+_0x3ba937(0x695)+_0x3ba937(0xe30)]&&this[_0x3ba937(0x92c)+_0x3ba937(0x9f0)+_0x3ba937(0x1a5)]();},Window_ActorCommand[_0xe90fac(0x510)]['addAttackC'+_0xe90fac(0x131)]=function(){const _0x51d3d5=_0xe90fac,_0xedd677={'xbuPi':function(_0x53906d,_0x5efc41){return _0x53906d===_0x5efc41;},'XiUjL':'text','gJMFS':_0x51d3d5(0x768),'tATWr':_0x51d3d5(0x3e3)},_0x2cc0ee=$dataSkills[this[_0x51d3d5(0x69c)][_0x51d3d5(0x12f2)+_0x51d3d5(0x1065)]()];if(!_0x2cc0ee)return;if(!this[_0x51d3d5(0xc42)+_0x51d3d5(0xf43)](_0x2cc0ee))return;const _0x570104=this['commandSty'+'le'](),_0x17e8dd=DataManager[_0x51d3d5(0x750)+_0x51d3d5(0x967)](_0x2cc0ee),_0x38cac2=DataManager['battleComm'+_0x51d3d5(0x14d9)](_0x2cc0ee),_0x564bc2=_0xedd677['xbuPi'](_0x570104,_0xedd677[_0x51d3d5(0x5ac)])?_0x17e8dd:_0xedd677[_0x51d3d5(0xd50)]['format'](_0x38cac2,_0x17e8dd);this[_0x51d3d5(0xbcb)](_0x564bc2,_0xedd677[_0x51d3d5(0x147e)],this[_0x51d3d5(0x69c)][_0x51d3d5(0xe59)]());},Window_ActorCommand[_0xe90fac(0x510)][_0xe90fac(0x38f)+_0xe90fac(0xc22)]=function(){const _0x5c9df9=_0xe90fac,_0x57e9a7={'rHnqH':function(_0x4dc974,_0x1749f0){return _0x4dc974===_0x1749f0;},'zvhBU':'text','DXLfX':'\x5cI[%1]%2','XbVaX':'guard'},_0x131f3b=$dataSkills[this[_0x5c9df9(0x69c)]['guardSkill'+'Id']()];if(!_0x131f3b)return;if(!this[_0x5c9df9(0xc42)+'lCommand'](_0x131f3b))return;const _0x362266=this['commandSty'+'le'](),_0x17f4f6=DataManager[_0x5c9df9(0x750)+_0x5c9df9(0x967)](_0x131f3b),_0x5736cf=DataManager['battleComm'+'andIcon'](_0x131f3b),_0x4e100c=_0x57e9a7[_0x5c9df9(0x904)](_0x362266,_0x57e9a7[_0x5c9df9(0xb13)])?_0x17f4f6:_0x57e9a7['DXLfX']['format'](_0x5736cf,_0x17f4f6);this[_0x5c9df9(0xbcb)](_0x4e100c,_0x57e9a7[_0x5c9df9(0x13d2)],this[_0x5c9df9(0x69c)][_0x5c9df9(0x11a8)]());},Window_ActorCommand[_0xe90fac(0x510)][_0xe90fac(0x12c)+'mand']=function(){const _0x30e379=_0xe90fac,_0x57e60b={'fVgIW':function(_0x3a689a,_0x375576){return _0x3a689a===_0x375576;},'ENxKM':_0x30e379(0x10aa),'FStgc':_0x30e379(0x768),'wopYL':_0x30e379(0xdd)},_0x230b5d=this[_0x30e379(0xd80)+'le'](),_0x9eb7ec=VisuMZ[_0x30e379(0x118f)]['Settings'][_0x30e379(0x320)]['CmdIconIte'+'m'],_0x4af940=_0x57e60b[_0x30e379(0x3a3)](_0x230b5d,_0x57e60b[_0x30e379(0xd8b)])?TextManager['item']:_0x57e60b['FStgc']['format'](_0x9eb7ec,TextManager[_0x30e379(0xdd)]),_0x12bc05=this['isItemComm'+_0x30e379(0x8c9)]();this['addCommand'](_0x4af940,_0x57e60b['wopYL'],_0x12bc05);},Window_ActorCommand['prototype']['isItemComm'+_0xe90fac(0x8c9)]=function(){const _0x3243ac=_0xe90fac;return this[_0x3243ac(0x69c)]&&this['_actor'][_0x3243ac(0x1593)+'Command']();},Window_ActorCommand[_0xe90fac(0x510)][_0xe90fac(0xaf5)+_0xe90fac(0x7e0)]=function(){const _0xd44d84=_0xe90fac,_0x1f8af2=this['_actor'][_0xd44d84(0x10bb)]();for(const _0xde6882 of _0x1f8af2){this[_0xd44d84(0xe0a)+_0xd44d84(0xf1)](_0xde6882);}},Window_ActorCommand['prototype'][_0xe90fac(0xe0a)+_0xe90fac(0xf1)]=function(_0x12bd84){const _0x1eb206=_0xe90fac,_0x145983={'zRxUC':function(_0x1654db,_0xd43da0){return _0x1654db===_0xd43da0;},'fMfrd':'text','BAHkL':_0x1eb206(0x768),'IHqOq':'skill'};let _0x357c79=$dataSystem[_0x1eb206(0x10bb)][_0x12bd84];if(!_0x357c79)return;let _0x518764=_0x357c79;const _0x5b11c8=this[_0x1eb206(0xd80)+'le']();if(_0x145983[_0x1eb206(0xce4)](_0x5b11c8,_0x145983[_0x1eb206(0xd3f)]))_0x518764=_0x518764[_0x1eb206(0x1144)](/\x1I\[(\d+)\]/gi,''),_0x518764=_0x518764[_0x1eb206(0x1144)](/\\I\[(\d+)\]/gi,'');else{if(!_0x357c79[_0x1eb206(0x3eb)](/\\I\[(\d+)\]/i)){const _0x1ad24b=Imported[_0x1eb206(0x120b)+_0x1eb206(0xa7c)+_0x1eb206(0x284)]?VisuMZ[_0x1eb206(0x10be)+_0x1eb206(0x13f1)][_0x1eb206(0x281)][_0x1eb206(0x943)]:VisuMZ[_0x1eb206(0x118f)][_0x1eb206(0x281)][_0x1eb206(0x320)],_0x34d817=$dataSystem[_0x1eb206(0x122f)+'s']['includes'](_0x12bd84),_0x58ceba=_0x34d817?_0x1ad24b[_0x1eb206(0x127b)+_0x1eb206(0xe27)]:_0x1ad24b['IconStypeN'+_0x1eb206(0xa5a)];_0x518764=_0x145983[_0x1eb206(0x70b)][_0x1eb206(0xeb8)](_0x58ceba,_0x357c79);}}this[_0x1eb206(0xbcb)](_0x518764,_0x145983[_0x1eb206(0xa46)],!![],_0x12bd84);},Window_ActorCommand[_0xe90fac(0x510)][_0xe90fac(0xa32)+_0xe90fac(0xc97)+'ds']=function(){const _0x452bb1=_0xe90fac,_0x3e4dda=this[_0x452bb1(0x69c)][_0x452bb1(0x10bb)](),_0x2f40d8=this[_0x452bb1(0x69c)][_0x452bb1(0xffc)]();for(const _0x3d15a3 of _0x2f40d8){if(!_0x3d15a3)continue;if(Imported[_0x452bb1(0x120b)+'killsState'+_0x452bb1(0x284)]){if(this[_0x452bb1(0x576)+_0x452bb1(0x15d8)](_0x3d15a3))continue;if(this['isHiddenSk'+_0x452bb1(0x59e)](_0x3d15a3))continue;}else{if(!_0x3e4dda['includes'](_0x3d15a3['stypeId']))continue;}this[_0x452bb1(0xa32)+_0x452bb1(0xc97)+'d'](_0x3d15a3);}},Window_ActorCommand[_0xe90fac(0x510)]['noSimilarS'+_0xe90fac(0x15d8)]=function(_0x30a330){const _0x2cfcdc=_0xe90fac,_0x1a2313={'bYgzb':function(_0x40e79f,_0x5186fb){return _0x40e79f<=_0x5186fb;}},_0x3f38e4=this[_0x2cfcdc(0x69c)][_0x2cfcdc(0x10bb)](),_0x75004e=_0x3f38e4[_0x2cfcdc(0x55f)](_0x41e75a=>DataManager['getSkillTy'+_0x2cfcdc(0x692)](_0x30a330)['includes'](_0x41e75a));return _0x1a2313['bYgzb'](_0x75004e[_0x2cfcdc(0x1268)],-0x65*0x55+-0x1*-0x1dde+0x139*0x3);},Window_ActorCommand['prototype'][_0xe90fac(0x110b)+_0xe90fac(0x59e)]=function(_0x39e3ae){const _0x4c3dec=_0xe90fac,_0x413e0d={'eTvpY':function(_0x48f04c,_0x29e04c){return _0x48f04c>=_0x29e04c;}};if(Imported[_0x4c3dec(0x120b)+_0x4c3dec(0xa7c)+_0x4c3dec(0x284)]){if(_0x413e0d[_0x4c3dec(0x1025)](VisuMZ['SkillsStat'+_0x4c3dec(0x13f1)][_0x4c3dec(0x6ca)],-0x204b+-0x1a7+0x21f3+0.24)){if(this[_0x4c3dec(0x69c)]){if(!VisuMZ[_0x4c3dec(0x10be)+_0x4c3dec(0x13f1)][_0x4c3dec(0x2e8)+'leBattleNo'+_0x4c3dec(0xa65)](this[_0x4c3dec(0x69c)],_0x39e3ae))return!![];if(!VisuMZ[_0x4c3dec(0x10be)+_0x4c3dec(0x13f1)][_0x4c3dec(0x2e8)+_0x4c3dec(0x12ca)+_0x4c3dec(0xa65)](this[_0x4c3dec(0x69c)],_0x39e3ae))return!![];if(!VisuMZ[_0x4c3dec(0x10be)+_0x4c3dec(0x13f1)][_0x4c3dec(0x2e8)+_0x4c3dec(0xf4a)+'etags'](this[_0x4c3dec(0x69c)],_0x39e3ae))return!![];}}else{if(!Window_SkillList[_0x4c3dec(0x510)][_0x4c3dec(0x1092)+_0x4c3dec(0xc2f)+_0x4c3dec(0x69d)][_0x4c3dec(0x351)](this,_0x39e3ae))return!![];if(!Window_SkillList['prototype'][_0x4c3dec(0x1092)+_0x4c3dec(0x11fb)+_0x4c3dec(0x69d)]['call'](this,_0x39e3ae))return!![];if(!Window_SkillList[_0x4c3dec(0x510)][_0x4c3dec(0x1092)+_0x4c3dec(0x6ae)+_0x4c3dec(0xa65)]['call'](this,_0x39e3ae))return!![];}}return![];},Window_ActorCommand[_0xe90fac(0x510)][_0xe90fac(0xa32)+'killComman'+'d']=function(_0xb5a2d){const _0x170758=_0xe90fac,_0xf31da6={'VXdcd':function(_0x413c56,_0x2d9929){return _0x413c56===_0x2d9929;},'SdpvL':'text','FHniy':_0x170758(0x768),'Jdiej':_0x170758(0x39a)+'l'};if(!_0xb5a2d)return;if(!this[_0x170758(0xc42)+'lCommand'](_0xb5a2d))return;const _0x17bda9=this[_0x170758(0xd80)+'le'](),_0x53b1c6=DataManager[_0x170758(0x750)+_0x170758(0x967)](_0xb5a2d),_0x220276=DataManager[_0x170758(0x750)+_0x170758(0x14d9)](_0xb5a2d),_0x2c742e=_0xf31da6[_0x170758(0x544)](_0x17bda9,_0xf31da6[_0x170758(0x646)])?_0x53b1c6:_0xf31da6[_0x170758(0xf3d)][_0x170758(0xeb8)](_0x220276,_0x53b1c6),_0xf899c9=this[_0x170758(0x69c)]['canUse'](_0xb5a2d);this[_0x170758(0xbcb)](_0x2c742e,_0xf31da6[_0x170758(0x158b)],_0xf899c9,_0xb5a2d['id']);},Window_ActorCommand[_0xe90fac(0x510)][_0xe90fac(0xc42)+_0xe90fac(0xf43)]=function(_0x42cfdc){const _0xf8e746=_0xe90fac,_0x2e5bad={'wuoYQ':_0xf8e746(0x83d)+_0xf8e746(0x90a)},_0x4466d9=_0x42cfdc[_0xf8e746(0xfee)];if(_0x4466d9[_0xf8e746(0x3eb)](/<COMMAND REQUIRE LEARN>/i)){if(!this[_0xf8e746(0x69c)][_0xf8e746(0x520)+_0xf8e746(0x9d9)](_0x42cfdc['id']))return![];}if(_0x4466d9[_0xf8e746(0x3eb)](/<COMMAND REQUIRE ACCESS>/i)){if(!this[_0xf8e746(0x69c)][_0xf8e746(0x147f)](_0x42cfdc['id']))return![];}const _0x5415a0=VisuMZ[_0xf8e746(0x118f)][_0xf8e746(0xc4e)+'S'](_0x42cfdc,_0x2e5bad[_0xf8e746(0xb2)]);if(VisuMZ['BattleCore']['JS'][_0x5415a0]){if(!VisuMZ['BattleCore']['JS'][_0x5415a0][_0xf8e746(0x351)](this,this[_0xf8e746(0x69c)],_0x42cfdc))return![];}return VisuMZ[_0xf8e746(0x118f)]['CheckSkill'+'CommandSho'+'wSwitches'](_0x42cfdc);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0xbb2)+_0xe90fac(0x11e7)+'wSwitches']=function(_0x4910b6){const _0x439f3a=_0xe90fac,_0x29a04f={'iofgM':function(_0x292c0d,_0x167d28){return _0x292c0d+_0x167d28;},'lhRBZ':function(_0x2544f3,_0xac890d){return _0x2544f3+_0xac890d;},'wQxHt':function(_0x35dc0b,_0x34f1ce){return _0x35dc0b+_0x34f1ce;},'EAsBz':function(_0x29aacb,_0x2cdb72){return _0x29aacb+_0x2cdb72;},'QptmD':function(_0x647cc8,_0x5aead4){return _0x647cc8+_0x5aead4;},'MWxgv':function(_0x476cfb,_0xd50998){return _0x476cfb+_0xd50998;},'Vycxo':function(_0x27ac62,_0x438489){return _0x27ac62+_0x438489;}},_0x36d593=_0x4910b6[_0x439f3a(0xfee)];if(_0x36d593[_0x439f3a(0x3eb)](/<COMMAND SHOW[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0x1a6310=JSON[_0x439f3a(0x119c)](_0x29a04f[_0x439f3a(0xbca)](_0x29a04f['lhRBZ']('[',RegExp['$1'][_0x439f3a(0x3eb)](/\d+/g)),']'));for(const _0x3b87a3 of _0x1a6310){if(!$gameSwitches[_0x439f3a(0x101c)](_0x3b87a3))return![];}return!![];}if(_0x36d593[_0x439f3a(0x3eb)](/<COMMAND SHOW ALL[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0x68128c=JSON[_0x439f3a(0x119c)](_0x29a04f[_0x439f3a(0xef1)](_0x29a04f[_0x439f3a(0x7b6)]('[',RegExp['$1'][_0x439f3a(0x3eb)](/\d+/g)),']'));for(const _0x38534e of _0x68128c){if(!$gameSwitches[_0x439f3a(0x101c)](_0x38534e))return![];}return!![];}if(_0x36d593[_0x439f3a(0x3eb)](/<COMMAND SHOW ANY[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0x3af5ce=JSON[_0x439f3a(0x119c)](_0x29a04f[_0x439f3a(0x7b6)](_0x29a04f[_0x439f3a(0x1390)]('[',RegExp['$1'][_0x439f3a(0x3eb)](/\d+/g)),']'));for(const _0x5088d2 of _0x3af5ce){if($gameSwitches['value'](_0x5088d2))return!![];}return![];}if(_0x36d593['match'](/<COMMAND HIDE[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0x3e6979=JSON['parse'](_0x29a04f['iofgM'](_0x29a04f[_0x439f3a(0x341)]('[',RegExp['$1'][_0x439f3a(0x3eb)](/\d+/g)),']'));for(const _0x1dde48 of _0x3e6979){if(!$gameSwitches[_0x439f3a(0x101c)](_0x1dde48))return!![];}return![];}if(_0x36d593[_0x439f3a(0x3eb)](/<COMMAND HIDE ALL[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0x8ad0b5=JSON['parse'](_0x29a04f[_0x439f3a(0x607)](_0x29a04f[_0x439f3a(0x1390)]('[',RegExp['$1']['match'](/\d+/g)),']'));for(const _0x5c8011 of _0x8ad0b5){if(!$gameSwitches[_0x439f3a(0x101c)](_0x5c8011))return!![];}return![];}if(_0x36d593['match'](/<COMMAND HIDE ANY[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0x3856d3=JSON['parse'](_0x29a04f[_0x439f3a(0x314)](_0x29a04f[_0x439f3a(0x1390)]('[',RegExp['$1'][_0x439f3a(0x3eb)](/\d+/g)),']'));for(const _0x397818 of _0x3856d3){if($gameSwitches[_0x439f3a(0x101c)](_0x397818))return![];}return!![];}return!![];},Window_ActorCommand[_0xe90fac(0x510)][_0xe90fac(0x1bd)+'ommand']=function(){const _0xc11dea=_0xe90fac,_0x5defcf={'ydDIA':function(_0x3fe9da,_0xfe7ed4){return _0x3fe9da===_0xfe7ed4;},'wBOIZ':_0xc11dea(0x10aa),'hhHAG':_0xc11dea(0x768),'QxOoZ':'escape'},_0x6e2ce6=this['commandSty'+'le'](),_0x33aca4=VisuMZ[_0xc11dea(0x118f)][_0xc11dea(0x281)][_0xc11dea(0x1463)][_0xc11dea(0xaf2)+_0xc11dea(0x109e)],_0x365587=_0x5defcf['ydDIA'](_0x6e2ce6,_0x5defcf[_0xc11dea(0xcb1)])?TextManager[_0xc11dea(0xa34)]:_0x5defcf[_0xc11dea(0xdbf)][_0xc11dea(0xeb8)](_0x33aca4,TextManager['escape']),_0x118733=this[_0xc11dea(0xcc9)+_0xc11dea(0xf4f)+'ed']();this[_0xc11dea(0xbcb)](_0x365587,_0x5defcf[_0xc11dea(0xb4e)],_0x118733);},Window_ActorCommand[_0xe90fac(0x510)][_0xe90fac(0xcc9)+_0xe90fac(0xf4f)+'ed']=function(){const _0x547589=_0xe90fac;return BattleManager[_0x547589(0x254)]();},Window_ActorCommand[_0xe90fac(0x510)]['addAutoBat'+'tleCommand']=function(){const _0x5bdff8=_0xe90fac,_0x3beebe={'LlCjw':function(_0x43190d,_0x2f81a8){return _0x43190d===_0x2f81a8;},'XeZAz':'text','BjWuG':'\x5cI[%1]%2','heEor':_0x5bdff8(0xfa2)},_0x2b185d=this[_0x5bdff8(0xd80)+'le'](),_0x13304a=VisuMZ[_0x5bdff8(0x118f)][_0x5bdff8(0x281)]['PartyCmd']['CmdIconAut'+'oBattle'],_0x4af29d=_0x3beebe[_0x5bdff8(0xb73)](_0x2b185d,_0x3beebe['XeZAz'])?TextManager[_0x5bdff8(0xfa2)]:_0x3beebe[_0x5bdff8(0xfcd)][_0x5bdff8(0xeb8)](_0x13304a,TextManager['autoBattle']),_0x479c41=this['isAutoBatt'+'leCommandE'+'nabled']();this[_0x5bdff8(0xbcb)](_0x4af29d,_0x3beebe['heEor'],_0x479c41);},Window_ActorCommand['prototype'][_0xe90fac(0x9a9)+_0xe90fac(0x1481)+_0xe90fac(0xcb6)]=function(){return!![];},Window_ActorCommand['prototype'][_0xe90fac(0x5a7)+_0xe90fac(0x475)]=function(){const _0x134ba5=_0xe90fac;return VisuMZ[_0x134ba5(0x118f)][_0x134ba5(0x281)]['ActorCmd']['CmdTextAli'+'gn'];},Window_ActorCommand['prototype'][_0xe90fac(0x3bf)]=function(_0x46ed86){const _0x425b97=_0xe90fac,_0x2acf9a={'AfKnV':function(_0x146ab6,_0x23dcef){return _0x146ab6===_0x23dcef;},'HwKqh':'iconText','eRyRJ':_0x425b97(0x274)},_0x43b8dc=this[_0x425b97(0xd80)+'leCheck'](_0x46ed86);if(_0x2acf9a[_0x425b97(0xab7)](_0x43b8dc,_0x2acf9a['HwKqh']))this['drawItemSt'+'yleIconTex'+'t'](_0x46ed86);else _0x2acf9a['AfKnV'](_0x43b8dc,_0x2acf9a['eRyRJ'])?this[_0x425b97(0x710)+_0x425b97(0x113)](_0x46ed86):Window_Command[_0x425b97(0x510)][_0x425b97(0x3bf)]['call'](this,_0x46ed86);this[_0x425b97(0x50c)+_0x425b97(0x31e)](_0x46ed86);},Window_ActorCommand[_0xe90fac(0x510)]['commandSty'+'le']=function(){const _0x449778=_0xe90fac;return VisuMZ['BattleCore'][_0x449778(0x281)][_0x449778(0x320)][_0x449778(0x8be)];},Window_ActorCommand['prototype'][_0xe90fac(0xd80)+_0xe90fac(0x148c)]=function(_0x3e4abd){const _0x1e1b4d=_0xe90fac,_0x5d643e={'FKxCb':function(_0x1b8004,_0x183d79){return _0x1b8004<_0x183d79;},'AILqT':_0x1e1b4d(0x10aa),'vkCZM':function(_0x494e53,_0x2cf2e1){return _0x494e53!==_0x2cf2e1;},'mPkYG':'auto','uXeMI':function(_0x329564,_0xe030db){return _0x329564>_0xe030db;},'VaSXo':function(_0x5a3937,_0xdca431){return _0x5a3937<=_0xdca431;},'JnLxv':'iconText','qsAFw':_0x1e1b4d(0x274)};if(_0x5d643e[_0x1e1b4d(0xab3)](_0x3e4abd,-0x153b+-0x2*-0x8d7+0x38d))return _0x5d643e[_0x1e1b4d(0x4de)];const _0x587418=this[_0x1e1b4d(0xd80)+'le']();if(_0x5d643e[_0x1e1b4d(0x4ca)](_0x587418,_0x5d643e[_0x1e1b4d(0x20f)]))return _0x587418;else{if(_0x5d643e[_0x1e1b4d(0xf9f)](this[_0x1e1b4d(0x44e)](),-0x5*0x32f+0x19bf+-0x9d4)){const _0x9f5103=this['commandNam'+'e'](_0x3e4abd);if(_0x9f5103[_0x1e1b4d(0x3eb)](/\\I\[(\d+)\]/i)){const _0x10fc86=this['itemLineRe'+'ct'](_0x3e4abd),_0x1ac2e4=this[_0x1e1b4d(0x2a1)](_0x9f5103)['width'];return _0x5d643e['VaSXo'](_0x1ac2e4,_0x10fc86['width'])?_0x5d643e['JnLxv']:_0x5d643e[_0x1e1b4d(0x7c7)];}}}return _0x5d643e['AILqT'];},Window_ActorCommand[_0xe90fac(0x510)]['drawItemSt'+_0xe90fac(0x896)+'t']=function(_0x4793a8){const _0x289ef4=_0xe90fac,_0x2be656={'mibMK':function(_0x279861,_0x35a69d){return _0x279861===_0x35a69d;},'mjZtx':_0x289ef4(0x8d8),'DInRU':function(_0xd57d4e,_0x288d81){return _0xd57d4e-_0x288d81;},'isFEO':function(_0x13ad25,_0x177f4d){return _0x13ad25+_0x177f4d;},'CRIVH':function(_0x91be8b,_0x56de8d){return _0x91be8b===_0x56de8d;},'HXrkF':_0x289ef4(0x8dd),'LZdPv':function(_0x454689,_0x46eda5){return _0x454689+_0x46eda5;},'oljzx':function(_0x4b355e,_0x4bf806){return _0x4b355e/_0x4bf806;}},_0x1592b8=this[_0x289ef4(0x789)+'ct'](_0x4793a8),_0x81411e=this[_0x289ef4(0x726)+'e'](_0x4793a8),_0x2b09fb=this[_0x289ef4(0x2a1)](_0x81411e)[_0x289ef4(0x301)];this[_0x289ef4(0xf8c)+'tOpacity'](this[_0x289ef4(0xd54)+_0x289ef4(0xcb6)](_0x4793a8));const _0x23ee1a=this[_0x289ef4(0x5a7)+'ign']();if(_0x2be656[_0x289ef4(0x45c)](_0x23ee1a,_0x2be656['mjZtx']))this[_0x289ef4(0x1002)](_0x81411e,_0x2be656[_0x289ef4(0x2bb)](_0x2be656[_0x289ef4(0x20b)](_0x1592b8['x'],_0x1592b8['width']),_0x2b09fb),_0x1592b8['y'],_0x2b09fb);else{if(_0x2be656[_0x289ef4(0x233)](_0x23ee1a,_0x2be656[_0x289ef4(0xc0a)])){const _0x316a2f=_0x2be656['LZdPv'](_0x1592b8['x'],Math[_0x289ef4(0x12be)](_0x2be656['oljzx'](_0x2be656[_0x289ef4(0x2bb)](_0x1592b8[_0x289ef4(0x301)],_0x2b09fb),0x1ed2*0x1+0x513+-0x23e3)));this[_0x289ef4(0x1002)](_0x81411e,_0x316a2f,_0x1592b8['y'],_0x2b09fb);}else this['drawTextEx'](_0x81411e,_0x1592b8['x'],_0x1592b8['y'],_0x2b09fb);}},Window_ActorCommand[_0xe90fac(0x510)]['drawItemSt'+_0xe90fac(0x113)]=function(_0x393282){const _0x4eac1a=_0xe90fac,_0xc76098={'jorjq':function(_0x22cd48,_0x553986){return _0x22cd48(_0x553986);},'FSyJH':function(_0x20e9e1,_0x5ad6dc){return _0x20e9e1+_0x5ad6dc;},'CAsar':function(_0x5d16e7,_0xcb342c){return _0x5d16e7/_0xcb342c;},'IKwbk':function(_0x4b874d,_0x22ae81){return _0x4b874d-_0x22ae81;},'MifZG':function(_0x55b3dc,_0x7aa966){return _0x55b3dc-_0x7aa966;}};this[_0x4eac1a(0x726)+'e'](_0x393282)[_0x4eac1a(0x3eb)](/\\I\[(\d+)\]/i);const _0x3d681f=_0xc76098[_0x4eac1a(0x595)](Number,RegExp['$1'])||-0x1*0xd59+0x3*-0xa5d+0x278*0x12,_0x18e87f=this[_0x4eac1a(0x789)+'ct'](_0x393282),_0x1770b7=_0xc76098['FSyJH'](_0x18e87f['x'],Math['floor'](_0xc76098[_0x4eac1a(0x30b)](_0xc76098['IKwbk'](_0x18e87f[_0x4eac1a(0x301)],ImageManager['iconWidth']),0x1*0x1b4b+-0x1fc6+-0x17f*-0x3))),_0x4c5424=_0xc76098[_0x4eac1a(0x11c4)](_0x18e87f['y'],_0xc76098['CAsar'](_0xc76098[_0x4eac1a(0xcae)](_0x18e87f['height'],ImageManager[_0x4eac1a(0xd1d)]),-0xec*-0x1+-0x325*-0xc+0xc2*-0x33));this[_0x4eac1a(0xe01)](_0x3d681f,_0x1770b7,_0x4c5424);},Window_ActorCommand[_0xe90fac(0x510)]['drawSingle'+_0xe90fac(0x31e)]=function(_0x589111){const _0x92982a=_0xe90fac,_0x30e6af={'fmhwA':_0x92982a(0x3e3),'RDqli':_0x92982a(0x547),'VbWIV':'singleSkil'+'l','kHhpp':function(_0x4c9a0b,_0x1b0509){return _0x4c9a0b===_0x1b0509;},'NxVpG':function(_0x4047c1,_0x31aa0b){return _0x4047c1===_0x31aa0b;}};if(!(VisuMZ[_0x92982a(0x118f)]['Settings'][_0x92982a(0x320)]['ShowCosts']??!![]))return;const _0x341861=this[_0x92982a(0x14b)+_0x92982a(0x155f)](_0x589111);if(![_0x30e6af['fmhwA'],_0x30e6af[_0x92982a(0xc0c)],_0x30e6af[_0x92982a(0x14bd)]]['includes'](_0x341861))return;const _0x1c857c=this[_0x92982a(0x789)+'ct'](_0x589111);let _0x51c62a=null;if(_0x30e6af[_0x92982a(0x12e0)](_0x341861,_0x30e6af[_0x92982a(0xc0e)]))_0x51c62a=$dataSkills[this[_0x92982a(0x69c)]['attackSkil'+_0x92982a(0x1065)]()];else _0x30e6af['NxVpG'](_0x341861,_0x30e6af[_0x92982a(0xc0c)])?_0x51c62a=$dataSkills[this[_0x92982a(0x69c)]['guardSkill'+'Id']()]:_0x51c62a=$dataSkills[this['_list'][_0x589111][_0x92982a(0x1270)]];this[_0x92982a(0x129f)+_0x92982a(0x1210)](this[_0x92982a(0x69c)],_0x51c62a,_0x1c857c['x'],_0x1c857c['y'],_0x1c857c[_0x92982a(0x301)]);},Window_ActorCommand[_0xe90fac(0x510)]['drawSkillC'+_0xe90fac(0x1210)]=function(_0x1549f1,_0x11a755,_0x1238fa,_0x3cdea5,_0x40311f){const _0x3d8ae6=_0xe90fac;if(!_0x11a755)return;Imported['VisuMZ_1_S'+_0x3d8ae6(0xa7c)+_0x3d8ae6(0x284)]?Window_Command[_0x3d8ae6(0x510)][_0x3d8ae6(0x129f)+_0x3d8ae6(0x1210)][_0x3d8ae6(0x351)](this,_0x1549f1,_0x11a755,_0x1238fa,_0x3cdea5,_0x40311f):Window_SkillList[_0x3d8ae6(0x510)]['drawSkillC'+'ost'][_0x3d8ae6(0x351)](this,_0x11a755,_0x1238fa,_0x3cdea5,_0x40311f);},Window_ActorCommand[_0xe90fac(0x510)][_0xe90fac(0x150b)]=function(){},Window_ActorCommand[_0xe90fac(0x510)][_0xe90fac(0xa3a)]=function(){const _0x92c6c8=_0xe90fac,_0x3d275d={'bhceQ':function(_0x1afbd0,_0x5e3fd3){return _0x1afbd0===_0x5e3fd3;},'iBWtF':_0x92c6c8(0xea1)};Window_Command[_0x92c6c8(0x510)][_0x92c6c8(0xa3a)]['call'](this);const _0x3421f1=this[_0x92c6c8(0x3a1)+'utStyle']();_0x3d275d['bhceQ'](_0x3421f1,_0x3d275d[_0x92c6c8(0xb96)])&&this[_0x92c6c8(0xd02)+_0x92c6c8(0xd82)]();},Window_ActorCommand[_0xe90fac(0x510)][_0xe90fac(0x3a1)+'utStyle']=function(){const _0x7043a4=_0xe90fac;if(this[_0x7043a4(0xdca)+_0x7043a4(0x309)])return this[_0x7043a4(0xdca)+'outStyle'];return this[_0x7043a4(0xdca)+'outStyle']=SceneManager['_scene'][_0x7043a4(0x3a1)+_0x7043a4(0x15fa)](),this[_0x7043a4(0xdca)+'outStyle'];},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x1439)+_0xe90fac(0x51d)+_0xe90fac(0xc70)]=Window_ActorCommand[_0xe90fac(0x510)]['setup'],Window_ActorCommand[_0xe90fac(0x510)]['setup']=function(_0xcfa45c){const _0x4f7b50=_0xe90fac,_0x4d8b92={'ACNvb':_0x4f7b50(0x142b),'HnqsV':'border','dSQCK':function(_0x28bc0f,_0x533d44){return _0x28bc0f>_0x533d44;}},_0x269cf2=this[_0x4f7b50(0x3a1)+_0x4f7b50(0x15fa)]();if(_0xcfa45c&&['xp',_0x4d8b92[_0x4f7b50(0xc18)]][_0x4f7b50(0x79c)](_0x269cf2))this[_0x4f7b50(0x1484)+_0x4f7b50(0x619)](_0xcfa45c);else _0xcfa45c&&[_0x4d8b92[_0x4f7b50(0x13b)]][_0x4f7b50(0x79c)](_0x269cf2)&&(this['resizeWind'+_0x4f7b50(0x1d9)+_0x4f7b50(0x1176)](_0xcfa45c),this[_0x4f7b50(0xd02)+'ndow']());VisuMZ['BattleCore'][_0x4f7b50(0x1439)+_0x4f7b50(0x51d)+'setup'][_0x4f7b50(0x351)](this,_0xcfa45c),_0xcfa45c&&_0x4d8b92[_0x4f7b50(0xd5c)]($gameTroop[_0x4f7b50(0xf79)+'rs']()[_0x4f7b50(0x1268)],-0x1*0xb65+0x1e6c+-0x1307)&&_0xcfa45c[_0x4f7b50(0x81d)]()&&_0xcfa45c['battler']()[_0x4f7b50(0xc81)+'d']();},Window_ActorCommand[_0xe90fac(0x510)][_0xe90fac(0x1484)+'owXPStyle']=function(_0x3d041f){const _0x413492=_0xe90fac,_0x108ffb={'WTpvb':function(_0x58e939,_0xc99729){return _0x58e939/_0xc99729;},'EAXfa':function(_0x1e4abf,_0x2c17e7){return _0x1e4abf-_0x2c17e7;},'ywIzh':function(_0x28a693,_0x21cae7){return _0x28a693+_0x21cae7;},'hCQFD':function(_0x3d6bfe,_0x25da8a){return _0x3d6bfe*_0x25da8a;},'dRtSf':function(_0x2561c6,_0x984f0){return _0x2561c6/_0x984f0;},'UJdNW':function(_0x2e067d,_0x32f29b){return _0x2e067d-_0x32f29b;},'aUBAO':function(_0x5c484e,_0x585d0f){return _0x5c484e-_0x585d0f;}},_0x16bf79=VisuMZ[_0x413492(0x118f)]['Settings'][_0x413492(0x5a2)+'ut']['CommandWid'+'th'],_0x28c972=Math[_0x413492(0x10a1)](_0x108ffb['WTpvb'](Graphics[_0x413492(0x3dc)],0x1576+0x1*-0x269e+0x1*0x112b)),_0x302a2f=Math[_0x413492(0x10a1)](_0x108ffb[_0x413492(0xda1)](Graphics[_0x413492(0x3dc)],$gameParty['battleMemb'+_0x413492(0x446)]()[_0x413492(0x1268)])),_0xb52967=Math[_0x413492(0xd3e)](Math[_0x413492(0xeed)](_0x28c972,_0x302a2f),_0x16bf79),_0x5b1c17=this[_0x413492(0x4e5)+_0x413492(0x328)](VisuMZ[_0x413492(0x118f)][_0x413492(0x281)][_0x413492(0x5a2)+'ut'][_0x413492(0xe74)+_0x413492(0x722)]),_0x1a7937=Math[_0x413492(0x12be)](_0x108ffb[_0x413492(0xda1)](_0x108ffb['EAXfa'](Graphics['boxWidth'],Graphics[_0x413492(0x301)]),0x185*-0x12+-0x1*-0x445+-0x101*-0x17)),_0x51a0f5=_0x108ffb['EAXfa'](Graphics[_0x413492(0x3dc)],_0x1a7937),_0x318724=_0x108ffb[_0x413492(0x15e5)](Math['round'](_0x108ffb[_0x413492(0xead)](_0x302a2f,_0x3d041f[_0x413492(0x96c)]())),Math['round'](_0x108ffb[_0x413492(0x247)](_0x108ffb['EAXfa'](_0x302a2f,_0xb52967),-0xfe*-0x5+-0x2192+0x1c9e)))[_0x413492(0x61c)](_0x1a7937,_0x108ffb['UJdNW'](_0x51a0f5,_0xb52967)),_0x272f3f=Math[_0x413492(0x10a1)](_0x108ffb['aUBAO'](SceneManager[_0x413492(0x11dd)][_0x413492(0xbed)+_0x413492(0x1600)]['y'],_0x5b1c17));this['move'](_0x318724,_0x272f3f,_0xb52967,_0x5b1c17),this[_0x413492(0x124c)+'ents'](),this['setBackgro'+_0x413492(0x2f4)](0x1*0xc85+0x2395+0x7*-0x6df);},Window_ActorCommand[_0xe90fac(0x510)][_0xe90fac(0x1484)+_0xe90fac(0x1d9)+_0xe90fac(0x1176)]=function(_0xb3d4dd){const _0x29d9d3=_0xe90fac,_0x34d75e=SceneManager[_0x29d9d3(0x11dd)][_0x29d9d3(0x550)+'ndWindowRe'+_0x29d9d3(0x83f)+_0x29d9d3(0x1176)]();this[_0x29d9d3(0x1415)](_0x34d75e['x'],_0x34d75e['y'],_0x34d75e[_0x29d9d3(0x301)],_0x34d75e['height']),this[_0x29d9d3(0x124c)+_0x29d9d3(0x95e)](),this[_0x29d9d3(0x54c)+_0x29d9d3(0x2f4)](-0x1bd*-0xd+-0x184b*0x1+0x1b2);},Window_ActorCommand[_0xe90fac(0x510)]['refreshDim'+_0xe90fac(0x1073)]=function(){const _0x4aa2d2=_0xe90fac,_0x4dc831={'NjGHB':function(_0x344d6a,_0x16bdbe){return _0x344d6a-_0x16bdbe;},'eSwgc':function(_0x928cad,_0x5e1841){return _0x928cad*_0x5e1841;}};if(this['_dimmerSpr'+_0x4aa2d2(0xdf4)]){const _0x50008d=this[_0x4aa2d2(0x1300)+_0x4aa2d2(0xdf4)][_0x4aa2d2(0x24c)],_0x3ee15b=_0x4dc831[_0x4aa2d2(0xf3a)](this[_0x4aa2d2(0x301)],0x15*-0x21+0x1d99*-0x1+-0x2*-0x102b),_0x42c911=this[_0x4aa2d2(0xa68)],_0x438353=this[_0x4aa2d2(0x6a4)],_0x5d5b06=ColorManager[_0x4aa2d2(0x1598)](),_0x1a4941=ColorManager['dimColor2']();this[_0x4aa2d2(0x1300)+_0x4aa2d2(0xdf4)]['x']=0x1a3*-0xb+-0x1*-0x1f0d+0x8*-0x1a1,_0x50008d['resize'](_0x3ee15b,_0x42c911),_0x50008d[_0x4aa2d2(0xa9a)+_0x4aa2d2(0x14d5)](0x13c1*0x1+-0x3*-0x805+-0x2bd0,-0x1ecd+0x2363+-0x2*0x24b,_0x3ee15b,_0x438353,_0x1a4941,_0x5d5b06,!![]),_0x50008d[_0x4aa2d2(0x542)](0x281*0x1+0x6c7+-0x16*0x6c,_0x438353,_0x3ee15b,_0x4dc831[_0x4aa2d2(0xf3a)](_0x42c911,_0x4dc831[_0x4aa2d2(0xda)](_0x438353,-0x25f2+0xa56+0x1b9e)),_0x5d5b06),_0x50008d[_0x4aa2d2(0xa9a)+'llRect'](-0xede+0x1bab*-0x1+-0x2a89*-0x1,_0x4dc831[_0x4aa2d2(0xf3a)](_0x42c911,_0x438353),_0x3ee15b,_0x438353,_0x5d5b06,_0x1a4941,!![]),this[_0x4aa2d2(0x1300)+_0x4aa2d2(0xdf4)][_0x4aa2d2(0xf6)](-0x1d9e+0x249b*-0x1+0x1613*0x3,-0x8ec+-0x2*-0x51b+-0x14a,_0x3ee15b,_0x42c911);}},Window_ActorCommand['prototype'][_0xe90fac(0x1529)]=function(){const _0x271374=_0xe90fac,_0x330abb={'XxzOz':_0x271374(0x3e3),'TPkoJ':_0x271374(0x547),'WvJwj':_0x271374(0xf44),'ZcEvR':_0x271374(0x39a)+'l','UhmTF':_0x271374(0xdd),'UQDNK':_0x271374(0xa34),'rXkne':_0x271374(0xfa2)};if(!this[_0x271374(0x69c)])return;const _0x439bf4=VisuMZ[_0x271374(0x118f)][_0x271374(0x281)]['ActorCmd'],_0x577df2=this['currentSym'+_0x271374(0x155f)]();switch(_0x577df2){case _0x330abb['XxzOz']:this[_0x271374(0x114c)+_0x271374(0xc80)]($dataSkills[this['_actor'][_0x271374(0x12f2)+_0x271374(0x1065)]()]);break;case _0x330abb[_0x271374(0x13ae)]:this[_0x271374(0x114c)+_0x271374(0xc80)]($dataSkills[this[_0x271374(0x69c)][_0x271374(0x1443)+'Id']()]);break;case _0x330abb[_0x271374(0x5d4)]:const _0x5ee31a=_0x439bf4[_0x271374(0x1411)+_0x271374(0xbbf)],_0x340452=_0x5ee31a[_0x271374(0xeb8)]($dataSystem[_0x271374(0x10bb)][this['currentExt']()]);this['_helpWindo'+'w'][_0x271374(0x52e)](_0x340452);break;case _0x330abb[_0x271374(0xb72)]:this['setHelpWin'+'dowItem']($dataSkills[this[_0x271374(0xf09)]()]);break;case _0x330abb['UhmTF']:this['_helpWindo'+'w'][_0x271374(0x52e)](_0x439bf4[_0x271374(0x9a5)]);break;case _0x330abb[_0x271374(0x334)]:this['_helpWindo'+'w']['setText'](_0x439bf4[_0x271374(0x14cf)]);break;case _0x330abb['rXkne']:this[_0x271374(0x507)+'w'][_0x271374(0x52e)](_0x439bf4['HelpAutoBa'+_0x271374(0x907)]);break;default:this['_helpWindo'+'w'][_0x271374(0x52e)]('');break;}},Window_ActorCommand[_0xe90fac(0x510)]['selectLast']=function(){const _0x589ebd=_0xe90fac,_0xf69ac6={'hDnKs':function(_0x37f707,_0x530a49){return _0x37f707===_0x530a49;},'HKaKq':'skill','NdzCh':function(_0x336f7b,_0xeb2a5e){return _0x336f7b||_0xeb2a5e;},'DekDG':function(_0x162886,_0x3d18c2){return _0x162886===_0x3d18c2;},'WJaMZ':_0x589ebd(0x39a)+'l','aGIDh':function(_0x19a9f5,_0x29046a){return _0x19a9f5||_0x29046a;}};this[_0x589ebd(0x91b)+'t'](0x1a37+-0x1*0xb2d+-0xf0a);if(this[_0x589ebd(0x69c)]&&ConfigManager[_0x589ebd(0xab2)+_0x589ebd(0x1d1)]){const _0x47933b=this[_0x589ebd(0x69c)][_0x589ebd(0x150f)+_0x589ebd(0x2a5)]();this[_0x589ebd(0x5ef)+'ol'](_0x47933b);if(_0xf69ac6['hDnKs'](_0x47933b,_0xf69ac6[_0x589ebd(0x9ec)])){const _0x440700=this[_0x589ebd(0x69c)]['lastBattle'+_0x589ebd(0xfc)]();if(_0x440700){const _0x350210=this[_0x589ebd(0x13ea)+_0x589ebd(0x225)](_0xf69ac6['HKaKq'],_0x440700[_0x589ebd(0x1244)]);this[_0x589ebd(0x10d9)](_0xf69ac6['NdzCh'](_0x350210,-0x2c8+0x7a*-0x31+-0x29d*-0xa));}}else{if(_0xf69ac6[_0x589ebd(0x610)](_0x47933b,_0xf69ac6[_0x589ebd(0x1e4)])){const _0x4d802d=this[_0x589ebd(0x69c)]['lastBattle'+_0x589ebd(0xfc)]();if(_0x4d802d){const _0x1598e2=this['findSymbol'+'Ext'](_0xf69ac6[_0x589ebd(0x1e4)],_0x4d802d['id']);this['select'](_0xf69ac6[_0x589ebd(0x153c)](_0x1598e2,0x761*-0x1+0x3*0x781+-0xf22));}}}}},Window_ActorCommand['prototype'][_0xe90fac(0x13ea)+_0xe90fac(0x225)]=function(_0x5ea66b,_0x40f672){const _0xf34f55=_0xe90fac;return this['_list'][_0xf34f55(0x14f)](_0x2bf31c=>_0x2bf31c['symbol']===_0x5ea66b&&_0x2bf31c[_0xf34f55(0x1270)]===_0x40f672);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x8a0)+_0xe90fac(0x123)+'initialize']=Window_BattleStatus[_0xe90fac(0x510)]['initialize'],Window_BattleStatus['prototype'][_0xe90fac(0xc68)]=function(_0x13024f){const _0xde8d40=_0xe90fac;VisuMZ['BattleCore'][_0xde8d40(0x8a0)+'tleStatus_'+_0xde8d40(0xc68)][_0xde8d40(0x351)](this,_0x13024f),this[_0xde8d40(0xdae)+_0xde8d40(0x126e)](),this[_0xde8d40(0xf26)+'chmentSpri'+_0xde8d40(0x6be)]();},Window_BattleStatus[_0xe90fac(0x510)][_0xe90fac(0x3a1)+_0xe90fac(0x15fa)]=function(){const _0x4b1186=_0xe90fac;if(this[_0x4b1186(0xdca)+_0x4b1186(0x309)])return this[_0x4b1186(0xdca)+_0x4b1186(0x309)];return this[_0x4b1186(0xdca)+_0x4b1186(0x309)]=SceneManager[_0x4b1186(0x11dd)][_0x4b1186(0x3a1)+'utStyle'](),this[_0x4b1186(0xdca)+'outStyle'];},Window_BattleStatus[_0xe90fac(0x510)][_0xe90fac(0xdae)+_0xe90fac(0x126e)]=function(){const _0x6a2a76=_0xe90fac;this[_0x6a2a76(0x13ce)+'le']=this[_0x6a2a76(0xd55)+'ible']();const _0x51e724=VisuMZ[_0x6a2a76(0x118f)]['Settings'][_0x6a2a76(0x5a2)+'ut'];_0x51e724[_0x6a2a76(0x821)+_0x6a2a76(0x36d)]&&(this[_0x6a2a76(0xfac)]=0x16bf+-0xde0+-0x8df);},Window_BattleStatus['prototype']['isFrameVis'+_0xe90fac(0x90a)]=function(){const _0x40bd97=_0xe90fac,_0x4775a3={'TyLGX':_0x40bd97(0xa83),'TcFXU':_0x40bd97(0xea1),'PUDgf':_0x40bd97(0x142c),'OzOkU':_0x40bd97(0x142b)},_0x385725=VisuMZ['BattleCore'][_0x40bd97(0x281)][_0x40bd97(0x5a2)+'ut'];if(_0x385725[_0x40bd97(0x821)+_0x40bd97(0x139e)+'name'])return!![];const _0x2a7dd6=this['battleLayo'+_0x40bd97(0x15fa)]();switch(_0x2a7dd6){case _0x4775a3[_0x40bd97(0x58a)]:case _0x4775a3[_0x40bd97(0x1493)]:return!![];break;case _0x4775a3[_0x40bd97(0xce8)]:case'xp':case _0x4775a3[_0x40bd97(0x1422)]:default:return![];break;}},Window_BattleStatus[_0xe90fac(0x510)][_0xe90fac(0xb95)+'t']=function(){return this['isFrameVis'+'ible']()?0x136*0x2+-0x127*-0x2+-0x4ba:0x196e+0xcfa+-0x2*0x132f;},Window_BattleStatus[_0xe90fac(0x510)]['maxCols']=function(){const _0x4ce65d=_0xe90fac,_0x2188ac={'vckCa':_0x4ce65d(0xa83),'QyuuX':'portrait','LywEN':_0x4ce65d(0x142c)},_0x54a11c=this[_0x4ce65d(0x3a1)+'utStyle']();switch(_0x54a11c){case _0x2188ac[_0x4ce65d(0x15e0)]:return 0x3*0x3d6+-0x1276+-0x6f5*-0x1;break;case'xp':case _0x2188ac['QyuuX']:return $gameParty[_0x4ce65d(0xac1)+_0x4ce65d(0x446)]()['length'];break;case _0x2188ac[_0x4ce65d(0x154e)]:default:return $gameParty[_0x4ce65d(0x1200)+_0x4ce65d(0xcdb)]();break;}},Window_BattleStatus['prototype'][_0xe90fac(0x142a)]=function(){const _0x58739c=_0xe90fac,_0x15342a={'NMmCg':'list','kEfuH':_0x58739c(0x142c),'zBfXM':'portrait'},_0x10a3c2=this['battleLayo'+_0x58739c(0x15fa)]();switch(_0x10a3c2){case _0x15342a[_0x58739c(0xeb6)]:return Window_StatusBase[_0x58739c(0x510)][_0x58739c(0x142a)]['call'](this);break;case _0x15342a['kEfuH']:case'xp':case _0x15342a['zBfXM']:default:return this[_0x58739c(0x366)+'t'];break;}},Window_BattleStatus[_0xe90fac(0x510)][_0xe90fac(0x92a)]=function(){const _0x262c92=_0xe90fac,_0x5de34b={'QvYVQ':_0x262c92(0xa83),'Capzr':_0x262c92(0x142c),'zjMIU':_0x262c92(0x142b)},_0x537b69=this['battleLayo'+'utStyle']();switch(_0x537b69){case _0x5de34b[_0x262c92(0x3c3)]:return Window_StatusBase[_0x262c92(0x510)]['rowSpacing']['call'](this);break;case _0x5de34b['Capzr']:case'xp':case _0x5de34b[_0x262c92(0xa66)]:default:return-0x1*0x913+0x1b21+0x907*-0x2;break;}},Window_BattleStatus['prototype']['updatePadd'+_0xe90fac(0x312)]=function(){const _0xf84ae7=_0xe90fac;this[_0xf84ae7(0xd55)+_0xf84ae7(0x90a)]()?Window_StatusBase['prototype'][_0xf84ae7(0x25b)+_0xf84ae7(0x312)][_0xf84ae7(0x351)](this):this['padding']=-0x7*-0x4e8+0x11*-0x11f+-0xf41;},Window_BattleStatus[_0xe90fac(0x510)][_0xe90fac(0xf4)+'skin']=function(){const _0x4d0a7a=_0xe90fac,_0xfe0d62=VisuMZ[_0x4d0a7a(0x118f)][_0x4d0a7a(0x281)][_0x4d0a7a(0x5a2)+'ut'];_0xfe0d62[_0x4d0a7a(0x821)+_0x4d0a7a(0x139e)+'name']?this[_0x4d0a7a(0x4bf)]=ImageManager[_0x4d0a7a(0xb8)](_0xfe0d62[_0x4d0a7a(0x821)+_0x4d0a7a(0x139e)+_0x4d0a7a(0x14c)]):Window_StatusBase[_0x4d0a7a(0x510)][_0x4d0a7a(0xf4)+_0x4d0a7a(0xb3d)][_0x4d0a7a(0x351)](this);},Window_BattleStatus['prototype']['drawItemBa'+_0xe90fac(0x1606)]=function(_0x15696c){const _0x5e2985=_0xe90fac,_0x1c487e=VisuMZ[_0x5e2985(0x118f)][_0x5e2985(0x281)][_0x5e2985(0x5a2)+'ut'];if(_0x1c487e['StatusWind'+_0x5e2985(0x65e)+_0x5e2985(0x349)])return;Window_StatusBase[_0x5e2985(0x510)]['drawItemBa'+'ckground'][_0x5e2985(0x351)](this,_0x15696c);},Window_BattleStatus[_0xe90fac(0x510)]['requestRef'+'resh']=function(){const _0x28c56a=_0xe90fac;this[_0x28c56a(0xe5)+_0x28c56a(0x75e)]=!![];},Window_BattleStatus[_0xe90fac(0x510)][_0xe90fac(0x94)]=function(){const _0x1ed1bf=_0xe90fac,_0x3c225f={'WVMCj':function(_0x567753,_0x584fee){return _0x567753===_0x584fee;},'DsyiN':_0x1ed1bf(0xea1)};Window_StatusBase['prototype'][_0x1ed1bf(0x94)][_0x1ed1bf(0x351)](this),this[_0x1ed1bf(0x14e7)+_0x1ed1bf(0xba4)](),this['updateEffe'+_0x1ed1bf(0xca6)+'rs']();if(_0x3c225f[_0x1ed1bf(0xdb5)](this[_0x1ed1bf(0x3a1)+_0x1ed1bf(0x15fa)](),_0x3c225f['DsyiN']))this['updateBord'+_0x1ed1bf(0x146c)]();},Window_BattleStatus[_0xe90fac(0x510)][_0xe90fac(0x14e7)+_0xe90fac(0xba4)]=function(){const _0x182c4a=_0xe90fac;if($gameTemp['isBattleRe'+'freshReque'+_0x182c4a(0x382)]())this[_0x182c4a(0x3b9)+_0x182c4a(0x1570)](),this['_requestRe'+'fresh']=![],$gameTemp[_0x182c4a(0x149b)+_0x182c4a(0xfb9)+'quest']();else this[_0x182c4a(0xe5)+_0x182c4a(0x75e)]&&(this[_0x182c4a(0xe5)+_0x182c4a(0x75e)]=![],this[_0x182c4a(0x944)](),this[_0x182c4a(0x994)+_0x182c4a(0x506)+_0x182c4a(0x6be)]());},Window_BattleStatus['prototype'][_0xe90fac(0x3f3)]=function(){const _0x5099ee=_0xe90fac;Window_StatusBase[_0x5099ee(0x510)][_0x5099ee(0x3f3)][_0x5099ee(0x351)](this);if(!$gameSystem[_0x5099ee(0x53d)]())this['refresh']();},Window_BattleStatus[_0xe90fac(0x510)][_0xe90fac(0x150b)]=function(){const _0x15ed69=_0xe90fac,_0xabe36={'RUKam':function(_0x13ec5e,_0x5d0574){return _0x13ec5e===_0x5d0574;}};if(_0xabe36[_0x15ed69(0x104f)](this[_0x15ed69(0x14c0)+'r'],Window_BattleStatus))return;Window_StatusBase[_0x15ed69(0x510)][_0x15ed69(0x150b)][_0x15ed69(0x351)](this);},Window_BattleStatus[_0xe90fac(0x510)][_0xe90fac(0x1581)+_0xe90fac(0x13c0)]=function(_0x26efca){const _0x597483=_0xe90fac,_0x3ea4b9={'lVJyj':_0x597483(0x142b),'zuuPa':_0x597483(0x142c),'NCuAi':_0x597483(0xa83),'HdQFA':_0x597483(0xea1)},_0x1203c7=this['battleLayo'+_0x597483(0x15fa)]();switch(_0x1203c7){case'xp':case _0x3ea4b9[_0x597483(0xd7e)]:break;case _0x3ea4b9[_0x597483(0x429)]:case _0x3ea4b9[_0x597483(0x59f)]:case _0x3ea4b9[_0x597483(0x10d6)]:default:return Window_StatusBase[_0x597483(0x510)]['drawBackgr'+_0x597483(0x13c0)][_0x597483(0x351)](this,_0x26efca);break;}},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x8a0)+_0xe90fac(0x123)+_0xe90fac(0x1355)+_0xe90fac(0x154d)]=Window_BattleStatus[_0xe90fac(0x510)][_0xe90fac(0x1355)+_0xe90fac(0x154d)],Window_BattleStatus['prototype'][_0xe90fac(0x1355)+_0xe90fac(0x154d)]=function(_0x4cd7f){const _0x569ceb=_0xe90fac,_0x19fca2={'hgSUd':'list','Vqild':_0x569ceb(0x142b),'sUmrJ':_0x569ceb(0x142c),'lPzJD':'border'},_0x4b150a=this[_0x569ceb(0x3a1)+_0x569ceb(0x15fa)]();switch(_0x4b150a){case _0x19fca2[_0x569ceb(0x2ba)]:this[_0x569ceb(0x1355)+'ageListSty'+'le'](_0x4cd7f);break;case'xp':this[_0x569ceb(0x1355)+_0x569ceb(0x1332)](_0x4cd7f);break;case _0x19fca2[_0x569ceb(0xc86)]:this['drawItemIm'+_0x569ceb(0x3af)+_0x569ceb(0xb83)](_0x4cd7f);break;case _0x19fca2[_0x569ceb(0x401)]:case _0x19fca2[_0x569ceb(0x347)]:default:VisuMZ[_0x569ceb(0x118f)][_0x569ceb(0x8a0)+_0x569ceb(0x123)+'drawItemIm'+'age'][_0x569ceb(0x351)](this,_0x4cd7f);break;}},Window_BattleStatus[_0xe90fac(0x510)][_0xe90fac(0x710)+_0xe90fac(0xf9c)]=function(_0x29e043){const _0x13ee80=_0xe90fac,_0x4d87e2={'IIFts':_0x13ee80(0xa83),'aXrMx':_0x13ee80(0x142b),'MWNUW':_0x13ee80(0x142c),'RONJr':_0x13ee80(0xea1)},_0x5b826e=this['battleLayo'+_0x13ee80(0x15fa)]();if(!$gameSystem[_0x13ee80(0x53d)]())this['centerFron'+_0x13ee80(0x4db)+'e'](_0x29e043);switch(_0x5b826e){case _0x4d87e2[_0x13ee80(0x5af)]:this[_0x13ee80(0x710)+_0x13ee80(0x18d)+'yle'](_0x29e043);break;case'xp':case _0x4d87e2[_0x13ee80(0x9ef)]:case _0x4d87e2['MWNUW']:case _0x4d87e2[_0x13ee80(0xee2)]:default:this['drawItemSt'+_0x13ee80(0x2a8)+'e'](_0x29e043);break;}},Window_BattleStatus[_0xe90fac(0x510)][_0xe90fac(0x14bf)+'sor']=function(){const _0x2baa37=_0xe90fac,_0x5e70ce=this['battleLayo'+_0x2baa37(0x15fa)]();if(['xp'][_0x2baa37(0x79c)](_0x5e70ce)&&!$gameSystem['isSideView']()){this[_0x2baa37(0x134a)+'ect'](-0x421*-0x2+-0xad*-0x27+0x229d*-0x1,0x675+-0x1d1e+0x16a9,-0xd*0xe9+-0x86+0xc5b*0x1,0x1bb9+0x1d*-0x153+-0x557*-0x2);return;}Window_StatusBase['prototype'][_0x2baa37(0x14bf)+_0x2baa37(0x331)][_0x2baa37(0x351)](this);},Window_BattleStatus[_0xe90fac(0x510)]['centerFron'+_0xe90fac(0x4db)+'e']=function(_0x38a0b6){const _0x260000=_0xe90fac,_0x280ad5={'ZjFNM':function(_0xd6627d,_0x203abc){return _0xd6627d+_0x203abc;},'ACeMQ':function(_0x22953a,_0x54b296){return _0x22953a/_0x54b296;},'Ppaon':_0x260000(0xa83),'RFiGB':function(_0xf756bb,_0x28ba84){return _0xf756bb/_0x28ba84;},'Szvdm':function(_0x1505fd,_0x1343fb){return _0x1505fd/_0x1343fb;}},_0xecb2c1=this['actor'](_0x38a0b6)[_0x260000(0x81d)]();if(!_0xecb2c1)return;const _0xd39b65=this[_0x260000(0x3a1)+_0x260000(0x15fa)](),_0x103a64=this[_0x260000(0x46d)](_0x38a0b6);let _0x26453c=_0x280ad5[_0x260000(0x27f)](Math[_0x260000(0x10a1)](_0x280ad5['ZjFNM'](_0x103a64['x'],_0x280ad5[_0x260000(0x3da)](_0x103a64['width'],0xb*0x45+-0x161*-0x3+-0x4*0x1c6))),this[_0x260000(0x6a4)]);[_0x280ad5[_0x260000(0x8fc)]][_0x260000(0x79c)](_0xd39b65)&&(_0x26453c=_0x280ad5[_0x260000(0x1256)](_0x103a64[_0x260000(0x301)],$gameParty[_0x260000(0xac1)+_0x260000(0x446)]()['length']),_0x26453c*=_0x38a0b6,_0x26453c+=_0x280ad5[_0x260000(0x1256)](_0x280ad5['Szvdm'](_0x103a64[_0x260000(0x301)],$gameParty[_0x260000(0xac1)+_0x260000(0x446)]()['length']),0x14c9+0x45*-0x89+-0x813*-0x2));let _0x515c88=Math[_0x260000(0x10a1)](this['frontviewS'+_0x260000(0x512)](_0x38a0b6,_0xecb2c1,_0x103a64));_0xecb2c1[_0x260000(0xb7)](_0x26453c,_0x515c88),this[_0x260000(0x9d5)](_0xecb2c1,0x1fef+-0xe7f+-0x116f),_0xecb2c1['show'](),this[_0x260000(0x252)+_0x260000(0x15ef)+'er'](),this[_0x260000(0x994)+'chmentSpri'+_0x260000(0x6be)]();},Window_BattleStatus['prototype'][_0xe90fac(0x1353)+_0xe90fac(0x512)]=function(_0x196aae,_0x1ea3cf,_0xe14ce4){const _0x4b2e4c=_0xe90fac,_0x5fec75={'ARDKw':function(_0x5a1e53,_0x40a68e){return _0x5a1e53===_0x40a68e;},'oPHxJ':_0x4b2e4c(0xf93),'ezhYb':function(_0x88b94,_0x5c0992){return _0x88b94-_0x5c0992;},'gtIiN':function(_0x1a5ed9,_0x485746){return _0x1a5ed9/_0x485746;},'bYNGU':'center','sOSGB':function(_0x585d7e,_0xd193dd){return _0x585d7e+_0xd193dd;},'tAbQh':_0x4b2e4c(0x5b3),'gOKrs':_0x4b2e4c(0x14c),'CTYcJ':_0x4b2e4c(0x142b)},_0x38187e=VisuMZ['BattleCore']['Settings'][_0x4b2e4c(0x5a2)+'ut'],_0x449304=this[_0x4b2e4c(0x3a1)+'utStyle']();if(_0x5fec75[_0x4b2e4c(0x13b4)](_0x449304,'xp')){const _0x16b250=_0x38187e[_0x4b2e4c(0xe82)+_0x4b2e4c(0xd64)];switch(_0x16b250[_0x4b2e4c(0x371)+'e']()[_0x4b2e4c(0x808)]()){case _0x5fec75['oPHxJ']:return _0x5fec75[_0x4b2e4c(0x2c4)](_0xe14ce4[_0x4b2e4c(0xa68)],_0x5fec75[_0x4b2e4c(0x1fb)](_0x1ea3cf[_0x4b2e4c(0x93f)+_0x4b2e4c(0xdf4)]['height'],-0x4*-0x2cb+-0x30a+-0x81e));break;case _0x5fec75[_0x4b2e4c(0xffd)]:const _0xf6b223=_0x38187e['XPActorDef'+'aultHeight'];return _0x5fec75['gtIiN'](_0x5fec75['sOSGB'](_0xe14ce4[_0x4b2e4c(0xa68)],_0x1ea3cf[_0x4b2e4c(0xa68)]||_0xf6b223),0x1c1*0x7+0xfb9+-0x1bfe);break;case _0x5fec75[_0x4b2e4c(0x1599)]:return 0x3d*0x3+-0x3f*0x3+0x6;case _0x5fec75[_0x4b2e4c(0x1312)]:default:return this[_0x4b2e4c(0x574)](_0xe14ce4);break;}}else{if(_0x5fec75[_0x4b2e4c(0x13b4)](_0x449304,_0x5fec75[_0x4b2e4c(0x1354)])){}}return _0x1ea3cf['height'];},Sprite_Name[_0xe90fac(0x510)][_0xe90fac(0x72a)+'ht']=function(){return-0x1*-0x1bbb+-0x2a7*-0x6+-0x12d*0x25;},Sprite_Name[_0xe90fac(0x510)][_0xe90fac(0x979)]=function(){const _0x31ef19=_0xe90fac,_0x54773d={'uJcsy':_0x31ef19(0x1369)},_0x3b1076=this[_0x31ef19(0x14c)](),_0x3edc66=this[_0x31ef19(0xa82)+'h'](),_0x4ae4b9=this[_0x31ef19(0x72a)+'ht']();this[_0x31ef19(0xdf2)](),this[_0x31ef19(0x24c)][_0x31ef19(0xf98)](),this['bitmap'][_0x31ef19(0x203)+_0x31ef19(0xeb4)](_0x3b1076,-0x3b*-0x95+0x1d08+-0x3f5b,0x10ce+-0x1050+-0x7e,_0x3edc66,_0x4ae4b9,_0x54773d[_0x31ef19(0xf0d)]);},Bitmap[_0xe90fac(0x510)][_0xe90fac(0x203)+_0xe90fac(0xeb4)]=function(_0x476567,_0x4d940d,_0x17f3c9,_0x2cf555,_0x44324b,_0x1da12d){const _0xf6e21b=_0xe90fac,_0x938da0={'FMKIa':function(_0x4db8a1,_0x29c4e5){return _0x4db8a1||_0x29c4e5;},'vxmwS':function(_0x348448,_0x44f0ea){return _0x348448+_0x44f0ea;},'qjUWu':function(_0xcc5a35,_0x317c64){return _0xcc5a35/_0x317c64;},'tCwGL':function(_0x329a62,_0x213621){return _0x329a62*_0x213621;},'qGylD':function(_0x21752b,_0x263eb8){return _0x21752b===_0x263eb8;},'dydEA':_0xf6e21b(0x8dd),'budDR':function(_0xd96dda,_0x3a7a7b){return _0xd96dda/_0x3a7a7b;},'yZEbh':'right','TNhKh':'alphabetic'};TextManager[_0xf6e21b(0x1457)+_0xf6e21b(0xcc7)]&&(_0x476567=TextManager[_0xf6e21b(0x1457)+_0xf6e21b(0xcc7)](_0x476567));const _0x30890c=this[_0xf6e21b(0x103c)],_0x5bb8f9=_0x30890c['globalAlph'+'a'];_0x2cf555=_0x938da0[_0xf6e21b(0x725)](_0x2cf555,-0x3916f0c0+-0x1848fab5b+0x2bda69c1a);let _0x2453c1=_0x4d940d,_0x4483ca=Math[_0xf6e21b(0x10a1)](_0x938da0[_0xf6e21b(0x11cc)](_0x938da0['vxmwS'](_0x17f3c9,_0x938da0[_0xf6e21b(0x6ec)](0x7*0x1f+-0x62+-0x5f*0x1,-0x693*-0x5+0x2*-0x1201+0x325)),_0x938da0[_0xf6e21b(0x1185)](this['fontSize'],-0x1e7e+-0xab3*-0x2+0x918+0.35)));_0x938da0['qGylD'](_0x1da12d,_0x938da0['dydEA'])&&(_0x2453c1+=_0x938da0['budDR'](_0x2cf555,0xe79+0x1571+-0x23e8)),_0x938da0[_0xf6e21b(0x4e9)](_0x1da12d,_0x938da0[_0xf6e21b(0xebc)])&&(_0x2453c1+=_0x2cf555),_0x30890c['save'](),_0x30890c[_0xf6e21b(0xcec)]=this[_0xf6e21b(0x80a)+_0xf6e21b(0x420)](),_0x30890c['textAlign']=_0x1da12d,_0x30890c[_0xf6e21b(0x150c)+'ne']=_0x938da0['TNhKh'],_0x30890c[_0xf6e21b(0xf5d)+'a']=-0x1*0x1efd+-0xd86+-0x4a*-0x9a,this[_0xf6e21b(0x101f)+_0xf6e21b(0xbc2)](_0x476567,_0x2453c1,_0x4483ca,_0x2cf555),_0x30890c['globalAlph'+'a']=_0x5bb8f9,this[_0xf6e21b(0xd1c)+'ody'](_0x476567,_0x2453c1,_0x4483ca,_0x2cf555),_0x30890c['restore'](),this[_0xf6e21b(0x10b6)+'re']['update']();},Window_BattleStatus[_0xe90fac(0x510)][_0xe90fac(0x574)]=function(_0x17925d){const _0x5e6cf8=_0xe90fac,_0x30a623={'OFQfR':function(_0x362bc9,_0x9d9fe6){return _0x362bc9-_0x9d9fe6;}};return _0x30a623[_0x5e6cf8(0xa21)](this[_0x5e6cf8(0x6ac)+'sY'](_0x17925d),this[_0x5e6cf8(0xa61)+_0x5e6cf8(0x435)]());},Window_BattleStatus[_0xe90fac(0x510)][_0xe90fac(0x1355)+_0xe90fac(0x2e9)+'le']=function(_0x2fa6ed){const _0xe0742=_0xe90fac,_0x212735={'sPTQN':function(_0x516f60,_0x3f64f3){return _0x516f60+_0x3f64f3;}};if(!VisuMZ[_0xe0742(0x118f)]['Settings'][_0xe0742(0x5a2)+'ut'][_0xe0742(0xbf0)+_0xe0742(0x834)])return;const _0x3e3a35=this[_0xe0742(0x31d)](_0x2fa6ed),_0x9579d1=this[_0xe0742(0x46d)](_0x2fa6ed);_0x9579d1[_0xe0742(0x301)]=ImageManager[_0xe0742(0xb90)],_0x9579d1['height']-=-0x1172+-0xac0+0x1c34,this['drawActorF'+_0xe0742(0x185)](_0x3e3a35,_0x212735[_0xe0742(0xf00)](_0x9579d1['x'],0x119c+-0x1d99*-0x1+-0x2f34),_0x212735[_0xe0742(0xf00)](_0x9579d1['y'],0x104e+0x9f3*-0x3+0xd8c),_0x9579d1[_0xe0742(0x301)],_0x9579d1['height']);},Window_BattleStatus[_0xe90fac(0x510)]['drawItemSt'+'atusListSt'+_0xe90fac(0x1176)]=function(_0x18a7cd){const _0x1d1bc4=_0xe90fac,_0x2c1d65={'HmHNi':function(_0x118e66,_0x3121f1){return _0x118e66+_0x3121f1;},'QPvch':function(_0x3fdf2d,_0x14c56d){return _0x3fdf2d+_0x14c56d;},'hWCnS':function(_0x46be65,_0x1e24df){return _0x46be65*_0x1e24df;},'kynZK':function(_0xba4200,_0x25a4c7){return _0xba4200*_0x25a4c7;},'QGZTJ':function(_0x2f261b,_0x392d3a){return _0x2f261b-_0x392d3a;},'WCikH':function(_0x58f446,_0x3bcf80){return _0x58f446+_0x3bcf80;},'CsIkA':function(_0x424139,_0x1d538b){return _0x424139+_0x1d538b;},'KDRXw':function(_0x453574,_0x517a2f){return _0x453574+_0x517a2f;},'VjScu':function(_0x287c29,_0xfe40c3){return _0x287c29+_0xfe40c3;},'PGIvy':function(_0x509796,_0x3f01fb){return _0x509796/_0x3f01fb;},'aCsGh':function(_0x292d82,_0x168a9d){return _0x292d82/_0x168a9d;},'vITpL':function(_0x2e0e83,_0x5513e3){return _0x2e0e83-_0x5513e3;},'FFktF':function(_0x3b5eb0,_0x3c1efd){return _0x3b5eb0+_0x3c1efd;},'UeMcm':function(_0x5594b5,_0x5752ed){return _0x5594b5+_0x5752ed;},'qpcnw':function(_0x56d83a,_0x309c31){return _0x56d83a-_0x309c31;},'JkOnU':function(_0x16b7f7,_0x5d8a95){return _0x16b7f7+_0x5d8a95;},'yovTl':function(_0x2a2e3b,_0x3ee90b){return _0x2a2e3b+_0x3ee90b;},'lPDqV':function(_0x602aef,_0x2cae39){return _0x602aef+_0x2cae39;},'SjxsA':function(_0x299aab,_0x1fa76f){return _0x299aab+_0x1fa76f;},'fRGJa':function(_0x595427,_0x438198){return _0x595427*_0x438198;},'WYMbw':function(_0x4a1019,_0x479e94){return _0x4a1019+_0x479e94;},'xjnKz':function(_0x5a00e1,_0x457db3){return _0x5a00e1*_0x457db3;},'cXnva':function(_0x2de3c5,_0x581baa){return _0x2de3c5+_0x581baa;}},_0x48ba8e=VisuMZ[_0x1d1bc4(0x118f)][_0x1d1bc4(0x281)][_0x1d1bc4(0x5a2)+'ut'],_0x2fe2a4=$dataSystem[_0x1d1bc4(0xb1)+'Tp']?0xbda+0x16db*0x1+-0x22b1:-0x431*0x1+0xa39*-0x3+-0x71*-0x4f,_0x43d8e4=_0x2c1d65[_0x1d1bc4(0x1298)](_0x2c1d65[_0x1d1bc4(0x183)](_0x2c1d65[_0x1d1bc4(0xc5a)](_0x2fe2a4,0x5*0x41e+-0x13bd+-0x59),_0x2c1d65[_0x1d1bc4(0xb5c)](_0x2c1d65['QGZTJ'](_0x2fe2a4,0x151e+0x61a+-0x1*0x1b37),-0x5*0x39b+0x530+0xcdf*0x1)),-0x8bd*-0x1+0x1*-0x9e5+0x12c),_0x4afe6b=this['actor'](_0x18a7cd),_0x41c4ab=this[_0x1d1bc4(0x46d)](_0x18a7cd);let _0x42c7e0=_0x2c1d65[_0x1d1bc4(0x128)](_0x41c4ab['x'],this[_0x1d1bc4(0x6a4)]);_0x48ba8e['ShowFacesL'+_0x1d1bc4(0x834)]?_0x42c7e0=_0x2c1d65[_0x1d1bc4(0x183)](_0x2c1d65[_0x1d1bc4(0x10ec)](_0x41c4ab['x'],ImageManager['faceWidth']),0x747+0x1*0x1f2d+-0x266c):_0x42c7e0+=ImageManager[_0x1d1bc4(0x172)];const _0x665952=Math[_0x1d1bc4(0x10a1)](Math[_0x1d1bc4(0xeed)](_0x2c1d65[_0x1d1bc4(0xe85)](_0x2c1d65[_0x1d1bc4(0x9df)](_0x41c4ab['x'],_0x41c4ab[_0x1d1bc4(0x301)]),_0x43d8e4),_0x42c7e0)),_0x2de51b=Math[_0x1d1bc4(0x10a1)](_0x2c1d65[_0x1d1bc4(0x4e2)](_0x41c4ab['y'],_0x2c1d65[_0x1d1bc4(0xa87)](_0x2c1d65[_0x1d1bc4(0xe85)](_0x41c4ab[_0x1d1bc4(0xa68)],Sprite_Name[_0x1d1bc4(0x510)][_0x1d1bc4(0x72a)+'ht']()),-0x1*-0x99a+-0x1424+0xa8c))),_0x5ee342=Math[_0x1d1bc4(0x10a1)](_0x2c1d65[_0x1d1bc4(0xe85)](_0x2c1d65[_0x1d1bc4(0xe85)](_0x665952,_0x2c1d65[_0x1d1bc4(0x430)](ImageManager['iconWidth'],-0x166*0x1+0xadb*-0x1+0xc43)),-0x2396+-0x3*-0x2c2+0x1b54)),_0x5e59ab=Math[_0x1d1bc4(0x10a1)](_0x2c1d65[_0x1d1bc4(0x128)](_0x2c1d65['WCikH'](_0x41c4ab['y'],_0x2c1d65[_0x1d1bc4(0x430)](_0x2c1d65['vITpL'](_0x41c4ab[_0x1d1bc4(0xa68)],ImageManager['iconHeight']),-0xe7e+-0x1ee1+0x2d61*0x1)),_0x2c1d65[_0x1d1bc4(0xa87)](ImageManager[_0x1d1bc4(0xd1d)],-0x5*0x16d+0x159d*0x1+0x11*-0xda)));let _0x23ff18=_0x2c1d65[_0x1d1bc4(0xda7)](_0x665952,-0x267b+-0x450+0x2b53);const _0x28d876=_0x2de51b;this[_0x1d1bc4(0xa3)+_0x1d1bc4(0xf82)](_0x4afe6b,_0x2c1d65['UeMcm'](_0x2c1d65[_0x1d1bc4(0x1140)](_0x665952,0x154f+-0x1623+-0x3*-0x48),_0x48ba8e[_0x1d1bc4(0x127c)+_0x1d1bc4(0x53c)]||-0x139*0x2+0x1*0x1fc3+-0x1d51),_0x2c1d65[_0x1d1bc4(0xda7)](_0x2de51b,_0x48ba8e[_0x1d1bc4(0x127c)+'fsetY']||0x2c7+-0x1*0x1693+0x13cc)),this[_0x1d1bc4(0x15c8)+_0x1d1bc4(0xbf5)](_0x4afe6b,_0x2c1d65[_0x1d1bc4(0xc58)](_0x665952,_0x48ba8e[_0x1d1bc4(0x1405)+'X']||-0x1716+0x49*0x1c+0xf1a),_0x2c1d65[_0x1d1bc4(0x10c)](_0x2de51b,_0x48ba8e[_0x1d1bc4(0x1405)+'Y']||-0x1bfb+0x1edf+-0x2e4)),this[_0x1d1bc4(0x244)+_0x1d1bc4(0x158c)](_0x4afe6b,_0x2c1d65['HmHNi'](_0x5ee342,_0x48ba8e[_0x1d1bc4(0xb6a)+_0x1d1bc4(0x14b0)]||0x1ce*0x7+-0x1*-0x1609+-0x22ab),_0x2c1d65[_0x1d1bc4(0x1372)](_0x5e59ab,_0x48ba8e[_0x1d1bc4(0xb6a)+_0x1d1bc4(0xa77)]||0x3*-0xa9a+0x57*0x5f+-0x7b)),this[_0x1d1bc4(0x1378)](_0x4afe6b,'hp',_0x2c1d65[_0x1d1bc4(0x9df)](_0x2c1d65['UeMcm'](_0x23ff18,_0x2c1d65[_0x1d1bc4(0xc5a)](0x3*-0xae5+-0x1*0x1687+-0x2*-0x1bdf,0x295*0x2+0x1a5a*0x1+0x2*-0xfc2)),_0x48ba8e['HpGaugeOff'+_0x1d1bc4(0x95f)]||0x2*0x8b+-0x18aa+0x1794),_0x2c1d65['WCikH'](_0x28d876,_0x48ba8e[_0x1d1bc4(0xf91)+_0x1d1bc4(0x1193)]||-0x1*0x21db+0x9fd*-0x1+0x2bd8)),this[_0x1d1bc4(0x1378)](_0x4afe6b,'mp',_0x2c1d65[_0x1d1bc4(0xc5c)](_0x2c1d65[_0x1d1bc4(0x197)](_0x23ff18,_0x2c1d65[_0x1d1bc4(0xbc8)](-0x6cb*0x1+0x1508+0x13f*-0xb,-0x85b+-0x1572+0x1dce)),_0x48ba8e[_0x1d1bc4(0x14d1)+_0x1d1bc4(0x95f)]||0x207e+0xe41*0x1+-0x2ebf),_0x2c1d65['QPvch'](_0x28d876,_0x48ba8e[_0x1d1bc4(0x14d1)+_0x1d1bc4(0x1193)]||0x1*-0x190b+0xfb5*-0x2+0x3875)),$dataSystem[_0x1d1bc4(0xb1)+'Tp']&&this[_0x1d1bc4(0x1378)](_0x4afe6b,'tp',_0x2c1d65['WYMbw'](_0x2c1d65[_0x1d1bc4(0x197)](_0x23ff18,_0x2c1d65['xjnKz'](0x2448+0x11a7+-0x3567,-0x79d+-0x2245+-0x7*-0x5fc)),_0x48ba8e[_0x1d1bc4(0x9f6)+'setX']||0x1627*-0x1+0x1652+-0x2b),_0x2c1d65['cXnva'](_0x28d876,_0x48ba8e[_0x1d1bc4(0x9f6)+_0x1d1bc4(0x1193)]||-0x2*-0x1165+-0x11b2+-0x1118));},Window_BattleStatus[_0xe90fac(0x510)][_0xe90fac(0x1355)+_0xe90fac(0x1332)]=function(_0x10e382){const _0x570174=_0xe90fac;if(!$gameSystem[_0x570174(0x53d)]())return;VisuMZ['BattleCore'][_0x570174(0x8a0)+'tleStatus_'+'drawItemIm'+_0x570174(0x154d)][_0x570174(0x351)](this,_0x10e382);},Window_BattleStatus[_0xe90fac(0x510)]['drawItemSt'+_0xe90fac(0x2a8)+'e']=function(_0x376204){const _0x5ce36b=_0xe90fac,_0x17b4a6={'Vcnvk':function(_0x555fe2,_0x5cbd84){return _0x555fe2+_0x5cbd84;},'iKZhr':function(_0x131099,_0xf8ceb3){return _0x131099/_0xf8ceb3;},'PkSsH':function(_0x5f410c,_0xa5d7c2){return _0x5f410c-_0xa5d7c2;},'jfMbu':function(_0x405d4d,_0x5a0181){return _0x405d4d-_0x5a0181;},'lqVNt':function(_0xd78f72,_0x508e5e){return _0xd78f72/_0x508e5e;},'aOCzY':function(_0x23b13c,_0x25bd7f){return _0x23b13c+_0x25bd7f;},'gRHnT':function(_0x3b3128,_0x4c334f){return _0x3b3128/_0x4c334f;},'TNUzl':function(_0x329714,_0x58f7d5){return _0x329714<_0x58f7d5;},'CfVyS':function(_0xc86d74,_0x8102b6){return _0xc86d74-_0x8102b6;},'TOLXu':function(_0x4a2600,_0x4fb3ad){return _0x4a2600-_0x4fb3ad;},'NraSP':function(_0xfbc695,_0x43f777){return _0xfbc695+_0x43f777;},'LLltL':function(_0x5b9d0b,_0x4eaf13){return _0x5b9d0b+_0x4eaf13;},'mxKYd':function(_0x5d5a16,_0x42488a){return _0x5d5a16+_0x42488a;},'ZUGNa':function(_0x475a38,_0xae3a61){return _0x475a38+_0xae3a61;},'FeJOT':function(_0x5a75a3,_0x2e5854){return _0x5a75a3+_0x2e5854;},'MrFhu':function(_0x1b2f84,_0xad6d3a){return _0x1b2f84+_0xad6d3a;},'qCVDw':function(_0x28d17c,_0x53ec18){return _0x28d17c+_0x53ec18;},'LDQnG':function(_0x1f7f9b,_0x4fd51b){return _0x1f7f9b+_0x4fd51b;},'dSpDd':function(_0x2dbfa5,_0x6924ec){return _0x2dbfa5*_0x6924ec;}},_0x5c5e14=VisuMZ['BattleCore']['Settings'][_0x5ce36b(0x5a2)+'ut'],_0x62a8ab=this[_0x5ce36b(0x31d)](_0x376204),_0x40624f=this[_0x5ce36b(0x46d)](_0x376204),_0x38730c=Math['round'](_0x17b4a6[_0x5ce36b(0xa60)](_0x40624f['x'],_0x17b4a6[_0x5ce36b(0x637)](_0x17b4a6[_0x5ce36b(0x6f0)](_0x40624f[_0x5ce36b(0x301)],0x14b1*-0x1+-0x1626+0x23*0x13d),0xeb3+0x11*0x142+-0x2413))),_0x5b0376=this['nameY'](_0x40624f);let _0x37370d=_0x17b4a6[_0x5ce36b(0x6f0)](_0x17b4a6['jfMbu'](_0x38730c,_0x17b4a6[_0x5ce36b(0x10a3)](ImageManager[_0x5ce36b(0x172)],0x898+0xb*0x35b+-0x2d7f)),-0x1*0x1406+0x6d*0x51+-0xe73),_0x28adcd=_0x17b4a6[_0x5ce36b(0xaa2)](_0x5b0376,_0x17b4a6[_0x5ce36b(0x138e)](ImageManager[_0x5ce36b(0xd1d)],-0x9ad*0x3+-0x243*-0x10+0x1*-0x727));_0x17b4a6[_0x5ce36b(0xdac)](_0x17b4a6['PkSsH'](_0x37370d,_0x17b4a6[_0x5ce36b(0x637)](ImageManager[_0x5ce36b(0x172)],0xedf+0x22f2+0x29*-0x137)),_0x40624f['x'])&&(_0x37370d=_0x17b4a6['CfVyS'](_0x17b4a6['Vcnvk'](_0x38730c,_0x17b4a6[_0x5ce36b(0x637)](ImageManager[_0x5ce36b(0x172)],-0x13d4+0x2*-0xd08+0x2de6)),-0x1a77+0x956+-0x21*-0x85),_0x28adcd=_0x17b4a6[_0x5ce36b(0x1a0)](_0x5b0376,_0x17b4a6[_0x5ce36b(0x10a3)](ImageManager[_0x5ce36b(0xd1d)],-0x6d*0x3b+0xd3d+0xbe4)));const _0xc22aa6=_0x38730c,_0x148c59=this[_0x5ce36b(0x6ac)+'sY'](_0x40624f);this['placeTimeG'+_0x5ce36b(0xf82)](_0x62a8ab,_0x17b4a6[_0x5ce36b(0x36a)](_0x38730c,_0x5c5e14['TpbGaugeOf'+'fsetX']||0x255+0x4*0x94+-0x4a5),_0x17b4a6[_0x5ce36b(0x393)](_0x5b0376,_0x5c5e14['TpbGaugeOf'+_0x5ce36b(0xebf)]||-0x25a5+0x16cb+0x76d*0x2)),this[_0x5ce36b(0x15c8)+_0x5ce36b(0xbf5)](_0x62a8ab,_0x17b4a6[_0x5ce36b(0xa60)](_0x38730c,_0x5c5e14['NameOffset'+'X']||-0x42*-0x17+-0x22*-0x101+-0x2810),_0x17b4a6[_0x5ce36b(0xa60)](_0x5b0376,_0x5c5e14[_0x5ce36b(0x1405)+'Y']||0x41e*0x5+0x513+0x19a9*-0x1)),this['placeState'+_0x5ce36b(0x158c)](_0x62a8ab,_0x17b4a6[_0x5ce36b(0x393)](_0x37370d,_0x5c5e14[_0x5ce36b(0xb6a)+'ffsetX']||0x14d1+0x7ff+-0x1cd0),_0x17b4a6[_0x5ce36b(0x393)](_0x28adcd,_0x5c5e14['StateIconO'+_0x5ce36b(0xa77)]||0x19*-0xef+-0x1fd1*0x1+0x1b94*0x2)),this[_0x5ce36b(0x1378)](_0x62a8ab,'hp',_0x17b4a6[_0x5ce36b(0x6d5)](_0xc22aa6,_0x5c5e14['HpGaugeOff'+'setX']||0x7f*0x2b+-0x2645+0x43c*0x4),_0x17b4a6[_0x5ce36b(0x482)](_0x148c59,_0x5c5e14[_0x5ce36b(0xf91)+_0x5ce36b(0x1193)]||-0x131*-0x1e+-0x1e0f+-0x5af)),this[_0x5ce36b(0x1378)](_0x62a8ab,'mp',_0x17b4a6[_0x5ce36b(0xaa2)](_0xc22aa6,_0x5c5e14['MpGaugeOff'+_0x5ce36b(0x95f)]||0x1757*0x1+0x1*-0x191f+0x39*0x8),_0x17b4a6[_0x5ce36b(0x93d)](_0x17b4a6[_0x5ce36b(0xc76)](_0x148c59,this[_0x5ce36b(0xa61)+_0x5ce36b(0x435)]()),_0x5c5e14[_0x5ce36b(0x14d1)+'setY']||-0x1ad9+-0x2036+-0x1*-0x3b0f)),$dataSystem['optDisplay'+'Tp']&&this['placeGauge'](_0x62a8ab,'tp',_0x17b4a6[_0x5ce36b(0xb53)](_0xc22aa6,_0x5c5e14['TpGaugeOff'+_0x5ce36b(0x95f)]||-0x14e4+0x1*0x1bfa+-0x716),_0x17b4a6[_0x5ce36b(0x393)](_0x17b4a6[_0x5ce36b(0x669)](_0x148c59,_0x17b4a6[_0x5ce36b(0x10f5)](this[_0x5ce36b(0xa61)+_0x5ce36b(0x435)](),0x158+-0x7*-0x46f+-0x205f)),_0x5c5e14['TpGaugeOff'+'setY']||0x9*0x2ab+0x98*-0x17+-0xa5b));},Window_BattleStatus['prototype']['showPortra'+_0xe90fac(0x139b)]=function(_0xc5f734){const _0x228586=_0xe90fac;if(!VisuMZ[_0x228586(0x118f)]['Settings'][_0x228586(0x5a2)+'ut'][_0x228586(0x1152)+_0x228586(0x139b)])return![];if(_0xc5f734[_0x228586(0x12d9)+_0x228586(0xd8f)]())return!![];return Imported[_0x228586(0x100b)+_0x228586(0xd01)+'e']&&_0xc5f734[_0x228586(0x836)+'ge']();},Game_Actor['prototype']['getBattleP'+_0xe90fac(0xcbc)+_0xe90fac(0x95f)]=function(){const _0x3e171d=_0xe90fac,_0x591ccc={'CUXla':function(_0x443d63,_0x55c8b4){return _0x443d63(_0x55c8b4);}};if(this[_0x3e171d(0x31d)]()[_0x3e171d(0xfee)]['match'](/<BATTLE (?:IMAGE|PORTRAIT) OFFSET X:[ ]([\+\-]\d+)>/i))return _0x591ccc[_0x3e171d(0xaec)](Number,RegExp['$1']);else{if(this[_0x3e171d(0x31d)]()[_0x3e171d(0xfee)]['match'](/<BATTLE (?:IMAGE|PORTRAIT) OFFSET:[ ]([\+\-]\d+),[ ]([\+\-]\d+)>/i))return _0x591ccc[_0x3e171d(0xaec)](Number,RegExp['$1']);}return 0x24f6+0x1a35*0x1+-0x3f2b;},Game_Actor['prototype'][_0xe90fac(0x12d9)+_0xe90fac(0xcbc)+'setY']=function(){const _0x45d7c6=_0xe90fac,_0x31e6ce={'fEyRi':function(_0xe2d1ff,_0x448be4){return _0xe2d1ff(_0x448be4);},'lqCGV':function(_0x47328b,_0x330575){return _0x47328b(_0x330575);}};if(this[_0x45d7c6(0x31d)]()[_0x45d7c6(0xfee)][_0x45d7c6(0x3eb)](/<BATTLE (?:IMAGE|PORTRAIT) OFFSET Y:[ ]([\+\-]\d+)>/i))return _0x31e6ce[_0x45d7c6(0x48e)](Number,RegExp['$1']);else{if(this[_0x45d7c6(0x31d)]()['note'][_0x45d7c6(0x3eb)](/<BATTLE (?:IMAGE|PORTRAIT) OFFSET:[ ]([\+\-]\d+),[ ]([\+\-]\d+)>/i))return _0x31e6ce[_0x45d7c6(0x321)](Number,RegExp['$2']);}return-0x16*0x8d+0x262f+-0x1a11;},Window_BattleStatus[_0xe90fac(0x510)][_0xe90fac(0x1355)+'agePortrai'+_0xe90fac(0xb83)]=function(_0x1ea458){const _0x4f39d3=_0xe90fac,_0xae6c55={'nRKxJ':_0x4f39d3(0x1231)+_0x4f39d3(0x12cd),'CqeHG':function(_0xad7b82,_0x599834){return _0xad7b82!==_0x599834;},'vTbna':function(_0x126c3f,_0x41ab50){return _0x126c3f+_0x41ab50;},'qgLts':function(_0x246204,_0x4b4d1c){return _0x246204+_0x4b4d1c;},'cULtJ':function(_0x3b8c9c,_0x33709b){return _0x3b8c9c/_0x33709b;}},_0x275429=this['actor'](_0x1ea458);if(this['showPortra'+_0x4f39d3(0x139b)](_0x275429)){const _0x27ad79=_0xae6c55['nRKxJ']['format'](_0x275429['actorId']()),_0x1c7d70=this[_0x4f39d3(0xba0)+_0x4f39d3(0x348)](_0x27ad79,Sprite),_0x443d1d=_0x275429['getBattleP'+_0x4f39d3(0x515)+_0x4f39d3(0x4c1)]();_0xae6c55[_0x4f39d3(0x1549)](_0x443d1d,'')?_0x1c7d70['bitmap']=ImageManager[_0x4f39d3(0x3ce)+'e'](_0x443d1d):_0x1c7d70[_0x4f39d3(0x24c)]=ImageManager[_0x4f39d3(0x7e6)+'ap'];const _0x23c307=this[_0x4f39d3(0x46d)](_0x1ea458);_0x1c7d70['anchor']['x']=0x2680+0x15*-0xf5+-0x1267+0.5,_0x1c7d70[_0x4f39d3(0x11c2)]['y']=-0x9ca+-0x24a+-0x407*-0x3;let _0x1710dc=_0xae6c55['vTbna'](Math['round'](_0xae6c55[_0x4f39d3(0x1254)](_0x23c307['x'],_0xae6c55[_0x4f39d3(0x5c5)](_0x23c307['width'],-0x1471+-0xad*-0x1+0x13c6))),this['padding']);_0x1710dc+=_0x275429[_0x4f39d3(0x12d9)+_0x4f39d3(0xcbc)+_0x4f39d3(0x95f)]();let _0x173ae2=Math[_0x4f39d3(0x10a1)](this['height']);_0x173ae2+=_0x275429[_0x4f39d3(0x12d9)+_0x4f39d3(0xcbc)+_0x4f39d3(0x1193)](),_0x1c7d70[_0x4f39d3(0x1415)](_0x1710dc,_0x173ae2);const _0x16e223=VisuMZ[_0x4f39d3(0x118f)][_0x4f39d3(0x281)][_0x4f39d3(0x5a2)+'ut'][_0x4f39d3(0x40e)+_0x4f39d3(0x540)];_0x1c7d70[_0x4f39d3(0xe61)]['x']=_0x16e223,_0x1c7d70[_0x4f39d3(0xe61)]['y']=_0x16e223,_0x1c7d70[_0x4f39d3(0x3f3)]();}else{const _0x31a305=this['faceRect'](_0x1ea458);this[_0x4f39d3(0x716)+'ace'](_0x275429,_0x31a305['x'],_0x31a305['y'],_0x31a305['width'],_0x31a305[_0x4f39d3(0xa68)]);}},Window_BattleStatus[_0xe90fac(0x510)][_0xe90fac(0xba0)+'rPortrait']=function(_0x4405f7,_0x45fc17){const _0x195f22=_0xe90fac,_0x2de066=this[_0x195f22(0x135a)+'lSprites'];if(_0x2de066[_0x4405f7])return _0x2de066[_0x4405f7];else{const _0x338585=new _0x45fc17();return _0x2de066[_0x4405f7]=_0x338585,this['addChildTo'+_0x195f22(0xf05)](_0x338585),this[_0x195f22(0xe5b)+_0x195f22(0xf05)](this[_0x195f22(0x4e7)+'a']),_0x338585;}},Window_BattleStatus[_0xe90fac(0x510)][_0xe90fac(0x9a7)+'entArea']=function(){const _0x59ab68=_0xe90fac;this[_0x59ab68(0x9c)+_0x59ab68(0xf19)](),this[_0x59ab68(0x5a0)+'ectsContai'+_0x59ab68(0xa3c)](),Window_StatusBase['prototype']['_createCli'+_0x59ab68(0xb97)][_0x59ab68(0x351)](this),this[_0x59ab68(0xf89)+_0x59ab68(0x690)+'er']();},Window_BattleStatus['prototype']['_createCur'+_0xe90fac(0xf19)]=function(){const _0x39ae19=_0xe90fac,_0x4832d6={'rQIex':_0x39ae19(0x1574)},_0x517f0e=_0x4832d6['rQIex'][_0x39ae19(0xab1)]('|');let _0x4682f9=0x2*-0xd85+0x16ed+-0x1*-0x41d;while(!![]){switch(_0x517f0e[_0x4682f9++]){case'0':this[_0x39ae19(0x4e7)+'a']=new Sprite();continue;case'1':this['_cursorAre'+'a'][_0x39ae19(0x14c8)]=[new PIXI[(_0x39ae19(0x14c8))]['AlphaFilte'+'r']()];continue;case'2':this['_cursorAre'+'a'][_0x39ae19(0x43f)]=new Rectangle();continue;case'3':this[_0x39ae19(0x4e7)+'a'][_0x39ae19(0x1415)](this[_0x39ae19(0x144b)],this[_0x39ae19(0x144b)]);continue;case'4':this[_0x39ae19(0xda3)](this[_0x39ae19(0x4e7)+'a']);continue;}break;}},Window_BattleStatus[_0xe90fac(0x510)][_0xe90fac(0x5a0)+_0xe90fac(0x3ba)+_0xe90fac(0xa3c)]=function(){const _0x51e88d=_0xe90fac;this['_effectsCo'+'ntainer']=new Sprite(),this[_0x51e88d(0xda3)](this[_0x51e88d(0x1031)+'ntainer']);},Window_BattleStatus[_0xe90fac(0x510)][_0xe90fac(0x252)+_0xe90fac(0x15ef)+'er']=function(){const _0x1f98a3=_0xe90fac;this[_0x1f98a3(0x1031)+'ntainer']&&this['addChild'](this[_0x1f98a3(0x1031)+_0x1f98a3(0xb05)]);},Window_BattleStatus[_0xe90fac(0x510)]['_createDam'+'ageContain'+'er']=function(){const _0x144f5d=_0xe90fac;this['_damageCon'+_0x144f5d(0x257)]=new Sprite(),this[_0x144f5d(0xda3)](this[_0x144f5d(0x158)+_0x144f5d(0x257)]);},Window_BattleStatus['prototype'][_0xe90fac(0x9c)+_0xe90fac(0x8f1)]=function(){const _0x592b66=_0xe90fac,_0x1bf4ac={'lcmat':function(_0x5f1b22,_0x2cdebb){return _0x5f1b22<_0x2cdebb;}};this['_cursorSpr'+_0x592b66(0xdf4)]=new Sprite();for(let _0xdfc429=0x8f*-0x17+0x1f26+0x124d*-0x1;_0x1bf4ac[_0x592b66(0xdde)](_0xdfc429,0x13cb*-0x1+0xb76+0x85e*0x1);_0xdfc429++){this[_0x592b66(0x1416)+_0x592b66(0xdf4)]['addChild'](new Sprite());}this['_cursorAre'+'a'][_0x592b66(0xda3)](this[_0x592b66(0x1416)+_0x592b66(0xdf4)]);},Window_BattleStatus[_0xe90fac(0x510)][_0xe90fac(0x10cf)+_0xe90fac(0xb97)]=function(){const _0x48ed65=_0xe90fac;Window_StatusBase[_0x48ed65(0x510)]['_updateCli'+'entArea'][_0x48ed65(0x351)](this),this[_0x48ed65(0xb92)+_0x48ed65(0xf19)]();},Window_BattleStatus[_0xe90fac(0x510)][_0xe90fac(0xb92)+_0xe90fac(0xf19)]=function(){const _0x98ae7c=_0xe90fac,_0x4bb892={'uuKYg':function(_0x9811d0,_0x197b95){return _0x9811d0-_0x197b95;},'ftYlw':function(_0x2bcc76,_0x1ccec2){return _0x2bcc76>_0x1ccec2;},'cRrzj':function(_0x678afe,_0x1a20ac){return _0x678afe>_0x1a20ac;}},_0x3d2a95=this[_0x98ae7c(0x144b)];this['_cursorAre'+'a'][_0x98ae7c(0x1415)](_0x3d2a95,_0x3d2a95),this[_0x98ae7c(0x4e7)+'a']['x']=_0x4bb892[_0x98ae7c(0xb63)](_0x3d2a95,this[_0x98ae7c(0x110e)]['x']),this['_cursorAre'+'a']['y']=_0x4bb892['uuKYg'](_0x3d2a95,this[_0x98ae7c(0x110e)]['y']),_0x4bb892[_0x98ae7c(0xfbb)](this[_0x98ae7c(0x74b)],-0x2451+0x214f+0x302)&&_0x4bb892[_0x98ae7c(0x1565)](this[_0x98ae7c(0x366)+'t'],0x3e7+-0x19d6+-0x5*-0x463)?this[_0x98ae7c(0x4e7)+'a'][_0x98ae7c(0xf56)]=this['isOpen']():this['_cursorAre'+'a'][_0x98ae7c(0xf56)]=![];},Window_BattleStatus['prototype'][_0xe90fac(0x654)+_0xe90fac(0xa1e)]=function(){const _0x20faf0=_0xe90fac;Window_StatusBase[_0x20faf0(0x510)]['_updateFil'+_0x20faf0(0xa1e)][_0x20faf0(0x351)](this),this['_updateCur'+'sorFilterA'+_0x20faf0(0x377)]();},Window_BattleStatus[_0xe90fac(0x510)]['_updateCur'+_0xe90fac(0x425)+_0xe90fac(0x377)]=function(){const _0x2b04c5=_0xe90fac,_0x21737d={'EuZvm':function(_0x10f2a5,_0x51b9ea){return _0x10f2a5+_0x51b9ea;}},_0x4e3003=this['_cursorAre'+'a'][_0x2b04c5(0x982)+_0x2b04c5(0x589)]['apply'](new Point(-0x19e9+-0x4*0x4f0+0x2da9,-0x812+-0xb9b+-0xdb*-0x17)),_0x1eb495=this[_0x2b04c5(0x4e7)+'a'][_0x2b04c5(0x43f)];_0x1eb495['x']=_0x21737d[_0x2b04c5(0x133c)](_0x4e3003['x'],this[_0x2b04c5(0x110e)]['x']),_0x1eb495['y']=_0x21737d['EuZvm'](_0x4e3003['y'],this[_0x2b04c5(0x110e)]['y']),_0x1eb495[_0x2b04c5(0x301)]=this[_0x2b04c5(0x74b)],_0x1eb495[_0x2b04c5(0xa68)]=this[_0x2b04c5(0x366)+'t'];},Window_BattleStatus[_0xe90fac(0x510)][_0xe90fac(0xfd4)+_0xe90fac(0x5c3)]=function(_0x3b5499){const _0x54507e=_0xe90fac,_0xe56b8f={'OStLv':function(_0xa8d7b1,_0x359b0b){return _0xa8d7b1!==_0x359b0b;},'JOzhc':'portrait'};if(_0xe56b8f[_0x54507e(0xdaf)](this[_0x54507e(0x3a1)+_0x54507e(0x15fa)](),_0xe56b8f[_0x54507e(0x50b)]))return;this['drawItemIm'+'agePortrai'+_0x54507e(0xb83)](_0x3b5499['index']());},Window_BattleStatus[_0xe90fac(0x510)][_0xe90fac(0x5fe)+_0xe90fac(0x118)]=function(_0x3d2544,_0x2cffc8){const _0x36bfbc=_0xe90fac,_0x19377d={'BPflW':function(_0x31c740,_0x211805){return _0x31c740+_0x211805;},'ySyYh':function(_0x74d314,_0x4593ab){return _0x74d314/_0x4593ab;}};if(!this[_0x36bfbc(0x158)+_0x36bfbc(0x257)])return;if(!_0x3d2544)return;if(!_0x2cffc8)return;const _0x3f7dfc=this['itemRect'](_0x2cffc8[_0x36bfbc(0x96c)]());_0x3f7dfc['x']+=_0x19377d[_0x36bfbc(0x5f4)](_0x19377d['ySyYh'](_0x3f7dfc[_0x36bfbc(0x301)],0x1*0xef+0xb0d+0xe*-0xdb),this[_0x36bfbc(0x6a4)]),_0x3d2544['x']=_0x3f7dfc['x'],_0x3d2544['y']=_0x3f7dfc['y'],this['_damageCon'+_0x36bfbc(0x257)][_0x36bfbc(0xda3)](_0x3d2544);},Window_BattleStatus['prototype'][_0xe90fac(0x447)+_0xe90fac(0xa93)]=function(_0x2cf4a8){const _0x3f6125=_0xe90fac;if(!this['_damageCon'+_0x3f6125(0x257)])return;if(!_0x2cf4a8)return;this[_0x3f6125(0x158)+_0x3f6125(0x257)][_0x3f6125(0xf46)+'d'](_0x2cf4a8);},Window_BattleStatus[_0xe90fac(0x510)]['updateBord'+_0xe90fac(0x146c)]=function(){const _0x3da3f9=_0xe90fac;if(!this[_0x3da3f9(0x10cd)+'ylePortrai'+_0x3da3f9(0x432)]())return;if(!this[_0x3da3f9(0xcb4)+_0x3da3f9(0xbab)+'e'])this[_0x3da3f9(0x4fb)+_0x3da3f9(0xf1b)+'traitSprit'+'e']();this[_0x3da3f9(0x354)+_0x3da3f9(0xcc2)](),this[_0x3da3f9(0x519)+_0x3da3f9(0x1141)]();},Window_BattleStatus[_0xe90fac(0x510)][_0xe90fac(0x10cd)+_0xe90fac(0xa7a)+_0xe90fac(0x432)]=function(){const _0x10e469=_0xe90fac,_0x510e1d={'TMlCe':function(_0x4109fe,_0x1f94ce){return _0x4109fe!==_0x1f94ce;}};if(_0x510e1d[_0x10e469(0x13d0)](this[_0x10e469(0x14c0)+'r'],Window_BattleStatus))return![];if(!SceneManager[_0x10e469(0x11be)+_0x10e469(0x3ad)]())return![];return VisuMZ[_0x10e469(0x118f)][_0x10e469(0x281)][_0x10e469(0x5a2)+'ut'][_0x10e469(0x1152)+_0x10e469(0x9ff)+_0x10e469(0x951)];},Window_BattleStatus[_0xe90fac(0x510)]['createBord'+_0xe90fac(0xf1b)+'traitSprit'+'e']=function(){const _0x473190=_0xe90fac,_0xda218f={'wtwEy':function(_0x546140,_0xd1fae4){return _0x546140+_0xd1fae4;}};this['_borderPor'+_0x473190(0xbab)+'e']=new Sprite();const _0x5044b1=SceneManager[_0x473190(0x11dd)],_0x20d485=_0x5044b1[_0x473190(0x728)][_0x473190(0x741)](_0x5044b1[_0x473190(0x1487)+'er']);_0x5044b1[_0x473190(0x9d5)](this['_borderPor'+_0x473190(0xbab)+'e'],_0x20d485),this[_0x473190(0xcb4)+_0x473190(0xbab)+'e'][_0x473190(0x11c2)]['x']=-0x7*0x1c3+-0xc*0x33a+0x1*0x330d+0.5,this[_0x473190(0xcb4)+_0x473190(0xbab)+'e']['anchor']['y']=0x8c+0x18b6*-0x1+-0x10d*-0x17;const _0x249d67=VisuMZ[_0x473190(0x118f)]['Settings']['BattleLayo'+'ut']['PortraitSc'+_0x473190(0x11ec)+_0x473190(0x951)];this[_0x473190(0xcb4)+_0x473190(0xbab)+'e']['scale']['x']=_0x249d67,this[_0x473190(0xcb4)+'traitSprit'+'e'][_0x473190(0xe61)]['y']=_0x249d67,this['_borderPor'+'traitSprit'+'e']['y']=_0xda218f['wtwEy'](this['y'],this['height']),this['_borderPor'+_0x473190(0x7b8)+_0x473190(0x130a)]=-0x69d*0x3+-0x39*0x67+0xa*0x447;},Window_BattleStatus[_0xe90fac(0x510)][_0xe90fac(0x13f7)+_0xe90fac(0x2bd)+'teVisible']=function(){const _0x183fd4=_0xe90fac;return BattleManager[_0x183fd4(0x15f0)+'g']();},Window_BattleStatus[_0xe90fac(0x510)][_0xe90fac(0x354)+_0xe90fac(0xcc2)]=function(){const _0x459757=_0xe90fac,_0x3ead1b={'jSXAu':function(_0x398b06,_0xfa4dcb){return _0x398b06===_0xfa4dcb;},'pDwAL':function(_0x48a931,_0x4a446c){return _0x48a931===_0x4a446c;},'NYHVr':function(_0x171644,_0x1b8101){return _0x171644===_0x1b8101;}};this[_0x459757(0xcb4)+_0x459757(0xbab)+'e'][_0x459757(0xf56)]=this[_0x459757(0x13f7)+_0x459757(0x2bd)+_0x459757(0xbf3)]();const _0x4b5d2e=BattleManager[_0x459757(0x31d)](),_0x244fd3=_0x4b5d2e?_0x4b5d2e[_0x459757(0x12d9)+_0x459757(0x515)+'ename']()||'':'';if(_0x3ead1b[_0x459757(0xa8)](_0x4b5d2e,this[_0x459757(0xcb4)+_0x459757(0xbab)+'e'][_0x459757(0x31d)])&&_0x3ead1b[_0x459757(0xbbd)](_0x244fd3,this['_borderPor'+_0x459757(0xbab)+'e'][_0x459757(0xad4)+'me']))return;this['_borderPor'+_0x459757(0xbab)+'e']['actor']=_0x4b5d2e||this['_borderPor'+'traitSprit'+'e'][_0x459757(0x31d)],this[_0x459757(0xcb4)+_0x459757(0xbab)+'e'][_0x459757(0xad4)+'me']=_0x244fd3;if(!_0x4b5d2e)return;else{if(_0x3ead1b['NYHVr'](_0x244fd3,'')){this['_borderPor'+_0x459757(0xbab)+'e'][_0x459757(0x24c)]=ImageManager['_emptyBitm'+'ap'],this[_0x459757(0xcb4)+'traitSprit'+'e'][_0x459757(0xad4)+'me']='';return;}else{const _0x2fcbcc=ImageManager[_0x459757(0x3ce)+'e'](_0x244fd3);this[_0x459757(0xcb4)+_0x459757(0xbab)+'e'][_0x459757(0xfac)]=0x20b9+-0x1fb5+0x1a*-0xa,_0x2fcbcc[_0x459757(0x12e4)+'tener'](this['processBor'+_0x459757(0xcc2)][_0x459757(0x874)](this,_0x2fcbcc));}}},Window_BattleStatus[_0xe90fac(0x510)][_0xe90fac(0x563)+_0xe90fac(0xcc2)]=function(_0x3e89df){const _0x25ec71=_0xe90fac,_0x5f0dc8={'KvCTg':function(_0x805e9,_0xcee093){return _0x805e9/_0xcee093;},'Ibdlq':function(_0x655562,_0x36eba6){return _0x655562*_0x36eba6;},'iDQAf':function(_0x5252e0,_0x44f4b2){return _0x5252e0+_0x44f4b2;}};this['_borderPor'+'traitDurat'+_0x25ec71(0x130a)]=-0x1149+-0x96e+0x1acb,this[_0x25ec71(0xcb4)+'traitSprit'+'e']['bitmap']=_0x3e89df;SceneManager[_0x25ec71(0x11dd)][_0x25ec71(0xb5a)+_0x25ec71(0xcb3)]()?(this[_0x25ec71(0xcb4)+_0x25ec71(0xbab)+'e']['x']=0x98d+-0x2*-0x9e3+0x1*-0x1d53,this[_0x25ec71(0xcb4)+_0x25ec71(0x10a2)+'tX']=Math[_0x25ec71(0x964)](_0x5f0dc8['KvCTg'](_0x3e89df[_0x25ec71(0x301)],0xc14+0x59*-0x35+0x65b))):(this[_0x25ec71(0xcb4)+_0x25ec71(0xbab)+'e']['x']=this[_0x25ec71(0x301)],this[_0x25ec71(0xcb4)+_0x25ec71(0x10a2)+'tX']=_0x5f0dc8[_0x25ec71(0x1555)](_0x5f0dc8[_0x25ec71(0x56d)](this[_0x25ec71(0x301)],-0x1*-0x1779+-0x14fd+-0x279),-0x107*0x4+0x165b+-0x123b));this[_0x25ec71(0xcb4)+_0x25ec71(0xbab)+'e'][_0x25ec71(0xfac)]=-0x1a23*0x1+-0x3f*0x3+0x1ae0,this[_0x25ec71(0xcb4)+_0x25ec71(0xbab)+'e']['y']=_0x5f0dc8[_0x25ec71(0x336)](this['y'],this[_0x25ec71(0xa68)]);const _0x5d1c7d=BattleManager['actor']();_0x5d1c7d&&(this[_0x25ec71(0xcb4)+_0x25ec71(0x10a2)+'tX']+=_0x5d1c7d[_0x25ec71(0x12d9)+_0x25ec71(0xcbc)+_0x25ec71(0x95f)](),this[_0x25ec71(0xcb4)+_0x25ec71(0xbab)+'e']['y']+=_0x5d1c7d[_0x25ec71(0x12d9)+_0x25ec71(0xcbc)+_0x25ec71(0x1193)]());},Window_BattleStatus[_0xe90fac(0x510)][_0xe90fac(0x519)+_0xe90fac(0x1141)]=function(){const _0x49a31c=_0xe90fac,_0x2eb527={'rkuAe':function(_0x30d353,_0x1c1c5f){return _0x30d353>_0x1c1c5f;},'BpKSd':function(_0x250511,_0x3561fa){return _0x250511/_0x3561fa;},'ykwpH':function(_0x20f4e5,_0x125b4a){return _0x20f4e5+_0x125b4a;},'SqufG':function(_0x3febba,_0x48944b){return _0x3febba*_0x48944b;},'rARJW':function(_0x3e4da9,_0x37cdbc){return _0x3e4da9-_0x37cdbc;},'BVkUa':function(_0x108f35,_0x4ab8f2){return _0x108f35*_0x4ab8f2;}};if(_0x2eb527[_0x49a31c(0x15aa)](this['_borderPor'+'traitDurat'+_0x49a31c(0x130a)],0x2*0x5b7+0x251d*-0x1+0x19af)){const _0x2ca58d=this[_0x49a31c(0xcb4)+_0x49a31c(0x7b8)+_0x49a31c(0x130a)],_0x5d7f11=this['_borderPor'+_0x49a31c(0xbab)+'e'];_0x5d7f11['x']=_0x2eb527[_0x49a31c(0x52a)](_0x2eb527[_0x49a31c(0xc52)](_0x2eb527[_0x49a31c(0xf66)](_0x5d7f11['x'],_0x2eb527['rARJW'](_0x2ca58d,-0xd6*-0x1c+-0x1933*0x1+0x1cc)),this[_0x49a31c(0xcb4)+_0x49a31c(0x10a2)+'tX']),_0x2ca58d),_0x5d7f11['opacity']=_0x2eb527['BpKSd'](_0x2eb527[_0x49a31c(0xc52)](_0x2eb527[_0x49a31c(0x212)](_0x5d7f11[_0x49a31c(0xfac)],_0x2eb527[_0x49a31c(0x72e)](_0x2ca58d,-0x109f*0x1+0x1de1*0x1+-0xd41*0x1)),-0xa52*0x1+0xac6+-0x8b*-0x1),_0x2ca58d),this[_0x49a31c(0xcb4)+_0x49a31c(0x7b8)+'ion']--;}},Window_BattleStatus[_0xe90fac(0x510)][_0xe90fac(0x252)+'ctContaine'+'rs']=function(){const _0x46bfdd=_0xe90fac;return;this[_0x46bfdd(0x1031)+_0x46bfdd(0xb05)]&&(this['_effectsCo'+_0x46bfdd(0xb05)]['x']=this['x'],this[_0x46bfdd(0x1031)+_0x46bfdd(0xb05)]['y']=this['y']),this[_0x46bfdd(0x158)+_0x46bfdd(0x257)]&&(this[_0x46bfdd(0x158)+_0x46bfdd(0x257)]['x']=this['x'],this[_0x46bfdd(0x158)+_0x46bfdd(0x257)]['y']=this['y']);},Window_BattleStatus[_0xe90fac(0x510)][_0xe90fac(0xf26)+_0xe90fac(0x506)+_0xe90fac(0x6be)]=function(){const _0x66e5f=_0xe90fac,_0x17d5a7=VisuMZ[_0x66e5f(0x118f)][_0x66e5f(0x281)]['BattleLayo'+'ut'];if(_0x17d5a7[_0x66e5f(0x821)+'owAttachme'+_0x66e5f(0x352)]){const _0x4cca3d=new Sprite();_0x4cca3d[_0x66e5f(0x24c)]=ImageManager[_0x66e5f(0xb8)](_0x17d5a7['StatusWind'+_0x66e5f(0xfe2)+_0x66e5f(0x352)]),_0x4cca3d['x']=_0x17d5a7[_0x66e5f(0x821)+_0x66e5f(0xfe2)+_0x66e5f(0x12ee)+_0x66e5f(0xe6)]||-0x97d+0x90+0x8ed,_0x4cca3d['y']=_0x17d5a7[_0x66e5f(0x821)+_0x66e5f(0xfe2)+_0x66e5f(0x12ee)+_0x66e5f(0x65b)]||0x2*0xe1d+-0x97*0x3b+0x693,this[_0x66e5f(0xe5b)+_0x66e5f(0xf05)](_0x4cca3d),this['_backAttac'+_0x66e5f(0xd06)+'e']=_0x4cca3d;}if(_0x17d5a7[_0x66e5f(0x821)+_0x66e5f(0xfe2)+'ntFront']){const _0x49c88a=new Sprite();_0x49c88a[_0x66e5f(0x24c)]=ImageManager[_0x66e5f(0xb8)](_0x17d5a7['StatusWind'+'owAttachme'+_0x66e5f(0x23b)]),_0x49c88a['x']=_0x17d5a7['StatusWind'+_0x66e5f(0xfe2)+'ntFrontOff'+_0x66e5f(0x95f)]||0x443*0x9+-0x3a7+-0x22b4,_0x49c88a['y']=_0x17d5a7[_0x66e5f(0x821)+'owAttachme'+'ntFrontOff'+_0x66e5f(0x1193)]||0x89e+-0x1*-0x19cb+-0x2269,this[_0x66e5f(0xda3)](_0x49c88a),this[_0x66e5f(0x3b0)+_0x66e5f(0x506)+'te']=_0x49c88a;}},Window_BattleStatus['prototype'][_0xe90fac(0x994)+_0xe90fac(0x506)+'tes']=function(){const _0x3d73a2=_0xe90fac;this[_0x3d73a2(0x3b0)+_0x3d73a2(0x506)+'te']&&this['addChild'](this[_0x3d73a2(0x3b0)+_0x3d73a2(0x506)+'te']),this['_backAttac'+'hmentSprit'+'e']&&this['addChildTo'+'Back'](this['_backAttac'+_0x3d73a2(0xd06)+'e']);},Window_BattleActor[_0xe90fac(0x510)][_0xe90fac(0x115c)+_0xe90fac(0x229)]=function(){const _0x40ad92=_0xe90fac;return this[_0x40ad92(0x8cb)+'lectionVal'+'id']();},Window_BattleActor[_0xe90fac(0x510)]['isActionSe'+_0xe90fac(0x1413)+'id']=function(){const _0x97e97e=_0xe90fac,_0x444371={'Hheia':function(_0x598f0a,_0x329a2a){return _0x598f0a===_0x329a2a;}},_0x6d0557=BattleManager[_0x97e97e(0x450)+_0x97e97e(0xce0)]();if(!_0x6d0557)return!![];if(!_0x6d0557[_0x97e97e(0xdd)]())return!![];const _0x507065=this[_0x97e97e(0x31d)](this[_0x97e97e(0x96c)]()),_0x3d5e0a=_0x6d0557[_0x97e97e(0xdd)]()[_0x97e97e(0xfee)];if(_0x6d0557[_0x97e97e(0xe99)+'er']()){if(_0x444371['Hheia'](_0x507065,BattleManager[_0x97e97e(0x31d)]()))return![];}if(_0x6d0557[_0x97e97e(0x14ca)+_0x97e97e(0xb3f)]()){if(!_0x507065[_0x97e97e(0x17d)]())return![];}if(_0x6d0557[_0x97e97e(0xf50)+'Friend']()){if(!_0x507065[_0x97e97e(0xb30)]())return![];}return!![];},Window_BattleActor['prototype'][_0xe90fac(0x1159)+_0xe90fac(0x439)]=function(_0x1b91ab){const _0x1f3292=_0xe90fac;this['_enemyWind'+_0x1f3292(0x6cc)]=_0x1b91ab;},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x8a0)+'tleActor_p'+_0xe90fac(0x1284)+'h']=Window_BattleActor[_0xe90fac(0x510)][_0xe90fac(0x117f)+'ch'],Window_BattleActor['prototype']['processTou'+'ch']=function(){const _0x3c0d59=_0xe90fac;Window_BattleStatus['prototype']['processTou'+'ch']['call'](this),this[_0x3c0d59(0x356)+_0x3c0d59(0x6cc)]?this[_0x3c0d59(0x4c7)+_0x3c0d59(0xe00)+_0x3c0d59(0x302)+'e']():VisuMZ['BattleCore']['Window_Bat'+_0x3c0d59(0x1201)+_0x3c0d59(0x1284)+'h'][_0x3c0d59(0x351)](this);},Window_BattleActor[_0xe90fac(0x510)][_0xe90fac(0x4c7)+_0xe90fac(0xe00)+_0xe90fac(0x302)+'e']=function(){const _0x33a51a=_0xe90fac,_0x4c1173={'eVreB':function(_0x647a2b,_0x49edaf){return _0x647a2b>=_0x49edaf;},'sZgee':function(_0xa147bc,_0x2f12ca){return _0xa147bc>=_0x2f12ca;}},_0x4f494f=SceneManager[_0x33a51a(0x11dd)]['_enemyWind'+'ow'];if(!_0x4f494f)return;this[_0x33a51a(0x125)+'ch']=![];const _0x5afc2b=this[_0x33a51a(0x10bd)]();if(_0x4c1173[_0x33a51a(0x1248)](_0x5afc2b,-0x2*0x8e9+0x13c4+0x1*-0x1f2)){this['select'](_0x5afc2b);if(TouchInput['isClicked']()){const _0xf0344e=$gameParty[_0x33a51a(0xe13)]()[_0x5afc2b],_0x4f5ad2=_0x4f494f[_0x33a51a(0x856)][_0x33a51a(0x741)](_0xf0344e);_0x4c1173[_0x33a51a(0xdfb)](_0x4f5ad2,0x306*0x2+-0x88a*-0x2+-0x1720)&&(_0x4f494f[_0x33a51a(0x10d9)](_0x4f5ad2),_0x4f494f[_0x33a51a(0xba9)]());}}},Window_BattleActor['prototype'][_0xe90fac(0x303)+_0xe90fac(0xba8)]=function(){const _0x55f94c=_0xe90fac;this[_0x55f94c(0x356)+_0x55f94c(0x6cc)]&&(this[_0x55f94c(0x477)+_0x55f94c(0xfa6)]++,this[_0x55f94c(0xd66)]=!![]);const _0xa4cc8c=Window_BattleStatus[_0x55f94c(0x510)][_0x55f94c(0x303)+'rAlpha'][_0x55f94c(0x351)](this);return this[_0x55f94c(0x356)+_0x55f94c(0x6cc)]&&(this[_0x55f94c(0xd66)]=![]),_0xa4cc8c;},VisuMZ['BattleCore'][_0xe90fac(0x8a0)+_0xe90fac(0x723)+_0xe90fac(0x6fe)]=Window_BattleActor[_0xe90fac(0x510)][_0xe90fac(0x3f3)],Window_BattleActor[_0xe90fac(0x510)][_0xe90fac(0x3f3)]=function(){const _0x2b5db5=_0xe90fac,_0x4622b9={'ZKamy':function(_0x5bf6f7,_0x15aed0){return _0x5bf6f7>_0x15aed0;},'RDDHJ':_0x2b5db5(0x153b)};VisuMZ['BattleCore']['Window_Bat'+'tleActor_s'+_0x2b5db5(0x6fe)]['call'](this);const _0x50a101=BattleManager[_0x2b5db5(0x450)+'ction']();if(_0x50a101){const _0x34e664=$gameParty[_0x2b5db5(0xf79)+'rs']();_0x50a101['canSingleO'+'rMultipleS'+_0x2b5db5(0x213)]()&&_0x4622b9[_0x2b5db5(0x7b2)](_0x34e664[_0x2b5db5(0x1268)],0x1dd9+0x14+-0x1dec)&&this[_0x2b5db5(0x2a3)](_0x4622b9[_0x2b5db5(0x37d)],this[_0x2b5db5(0x12af)+_0x2b5db5(0x1296)][_0x2b5db5(0x874)](this));}},VisuMZ['BattleCore'][_0xe90fac(0x8a0)+_0xe90fac(0xe42)+_0xe90fac(0xd23)]=Window_BattleActor[_0xe90fac(0x510)][_0xe90fac(0x150b)],Window_BattleActor[_0xe90fac(0x510)][_0xe90fac(0x150b)]=function(){const _0x257fa1=_0xe90fac;VisuMZ[_0x257fa1(0x118f)][_0x257fa1(0x8a0)+_0x257fa1(0xe42)+_0x257fa1(0xd23)]['call'](this),delete this[_0x257fa1(0xa85)][_0x257fa1(0x93c)],delete this[_0x257fa1(0xa85)]['pagedown'];},Window_BattleActor['prototype'][_0xe90fac(0x12af)+_0xe90fac(0x1296)]=function(){const _0x49af9a=_0xe90fac,_0x267ee4={'AxiIK':'all\x20actors'},_0x4aec40=BattleManager['inputtingA'+_0x49af9a(0xce0)]();if(_0x4aec40)_0x4aec40['setTargetB'+_0x49af9a(0x115d)](_0x267ee4[_0x49af9a(0x949)]);this['processOk']();},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x8a0)+_0xe90fac(0xf73)+_0xe90fac(0x1506)]=Window_BattleEnemy['prototype'][_0xe90fac(0xc68)],Window_BattleEnemy[_0xe90fac(0x510)][_0xe90fac(0xc68)]=function(_0x29ac31){const _0x4fa26f=_0xe90fac,_0x3f6eca={'gzNsA':function(_0x132b19,_0x2503a0){return _0x132b19<_0x2503a0;},'tWGgg':'VisuMZ_2_A'+_0x4fa26f(0x395)+_0x4fa26f(0x160)+'eds\x20to\x20be\x20'+_0x4fa26f(0x529),'nRhYg':_0x4fa26f(0x3e1)+'or\x20Taunt\x20a'+_0x4fa26f(0xf62)+'\x20features\x20'+_0x4fa26f(0x94f),'qNGWa':_0x4fa26f(0x158f)+_0x4fa26f(0x1414)+_0x4fa26f(0x1180)+'1_BattleCo'+_0x4fa26f(0x9c4),'DzdVv':function(_0x113e32,_0x2e1ad1){return _0x113e32(_0x2e1ad1);}};this[_0x4fa26f(0xe9d)]=null,VisuMZ[_0x4fa26f(0x118f)][_0x4fa26f(0x8a0)+_0x4fa26f(0xf73)+_0x4fa26f(0x1506)][_0x4fa26f(0x351)](this,_0x29ac31);if(Imported[_0x4fa26f(0x42f)+'ggroContro'+'lSystem']){if(_0x3f6eca[_0x4fa26f(0x107f)](VisuMZ[_0x4fa26f(0xd7b)+_0x4fa26f(0x70e)]['version'],0x2bf*-0xc+-0x3eb*0x4+0x30a1+0.1200000000000001)){let _0x15accb='';_0x15accb+=_0x3f6eca[_0x4fa26f(0x157b)],_0x15accb+=_0x3f6eca[_0x4fa26f(0x1e2)],_0x15accb+=_0x3f6eca[_0x4fa26f(0x1534)],_0x3f6eca[_0x4fa26f(0x998)](alert,_0x15accb),SceneManager['exit']();}}},Window_BattleEnemy['prototype']['maxCols']=function(){const _0x34e6ad=_0xe90fac;return this[_0x34e6ad(0x44e)]();},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x8a0)+_0xe90fac(0xa3b)+_0xe90fac(0x6fe)]=Window_BattleEnemy['prototype'][_0xe90fac(0x3f3)],Window_BattleEnemy['prototype'][_0xe90fac(0x3f3)]=function(){const _0x4e103e=_0xe90fac,_0xbb5ac5={'LRjmP':function(_0x42b899,_0x2be8a3){return _0x42b899*_0x2be8a3;}};VisuMZ[_0x4e103e(0x118f)][_0x4e103e(0x8a0)+_0x4e103e(0xa3b)+'how'][_0x4e103e(0x351)](this),this['y']=_0xbb5ac5[_0x4e103e(0xeae)](Graphics['height'],0x1cc1+0x174b+-0x3402),this['meetsSelec'+'tFrontview'+_0x4e103e(0x1388)+_0x4e103e(0x972)]()&&this[_0x4e103e(0xa48)+_0x4e103e(0x609)+'w']();},VisuMZ[_0xe90fac(0x118f)]['Window_Bat'+_0xe90fac(0xe7b)+_0xe90fac(0xd23)]=Window_BattleEnemy[_0xe90fac(0x510)][_0xe90fac(0x150b)],Window_BattleEnemy[_0xe90fac(0x510)][_0xe90fac(0x150b)]=function(){const _0x4fde86=_0xe90fac;VisuMZ['BattleCore'][_0x4fde86(0x8a0)+'tleEnemy_h'+'ide'][_0x4fde86(0x351)](this),$gameParty[_0x4fde86(0x10d9)](null),delete this[_0x4fde86(0xa85)][_0x4fde86(0x93c)],delete this[_0x4fde86(0xa85)][_0x4fde86(0x153b)];},Window_BattleEnemy[_0xe90fac(0x510)]['validTarge'+'ts']=function(){const _0x2296df=_0xe90fac,_0x34189c={'qSHvC':function(_0x5d6d79,_0x2e8974){return _0x5d6d79>_0x2e8974;},'ULwTP':_0x2296df(0x93c),'pgQrD':function(_0x38d768,_0x2c4f18){return _0x38d768>_0x2c4f18;},'Bmirt':'pagedown'};let _0x19622d=$gameTroop[_0x2296df(0xf79)+'rs']();const _0x4320a4=BattleManager[_0x2296df(0x450)+_0x2296df(0xce0)]();if(_0x4320a4){_0x4320a4[_0x2296df(0xaa1)+_0x2296df(0xed9)+_0x2296df(0x213)]()&&_0x34189c[_0x2296df(0xe95)](_0x19622d[_0x2296df(0x1268)],-0xf*0x93+0x1c22+-0x4*0x4e1)&&this[_0x2296df(0x2a3)](_0x34189c[_0x2296df(0xb1e)],this[_0x2296df(0xcb)+_0x2296df(0x1243)]['bind'](this));if(_0x4320a4[_0x2296df(0xcf2)+'e']()){const _0x359383=$gameParty[_0x2296df(0xf79)+'rs']();_0x19622d=_0x19622d[_0x2296df(0x67c)](_0x359383),_0x4320a4[_0x2296df(0xaa1)+_0x2296df(0xed9)+_0x2296df(0x213)]()&&_0x34189c['pgQrD'](_0x359383[_0x2296df(0x1268)],0xa*-0x1d5+0xdfc+-0xb*-0x65)&&this[_0x2296df(0x2a3)](_0x34189c[_0x2296df(0xdda)],this[_0x2296df(0x12af)+'ctors'][_0x2296df(0x874)](this));}}return _0x19622d;},Window_BattleEnemy['prototype'][_0xe90fac(0x944)]=function(){const _0xc31a4b=_0xe90fac;this[_0xc31a4b(0x856)]=this['validTarge'+'ts'](),this[_0xc31a4b(0x509)+'s'](),Window_Selectable[_0xc31a4b(0x510)][_0xc31a4b(0x944)]['call'](this);},Window_BattleEnemy[_0xe90fac(0x510)][_0xe90fac(0x509)+'s']=function(){const _0x5e4757=_0xe90fac,_0x2dbf95={'Onzcf':function(_0x41f005,_0x45b4ad){return _0x41f005!==_0x45b4ad;},'GoxfJ':function(_0x3ec4c3,_0x1f5410){return _0x3ec4c3-_0x1f5410;},'oVwlx':function(_0x5cfc2a,_0x2bf5e6){return _0x5cfc2a===_0x2bf5e6;},'AUOlV':function(_0x3049bb,_0x3e8cd0){return _0x3049bb-_0x3e8cd0;}};this[_0x5e4757(0x856)]['sort']((_0x495b25,_0xa135ba)=>{const _0x22cafd=_0x5e4757;if(_0x2dbf95[_0x22cafd(0x2c1)](_0x495b25[_0x22cafd(0xd83)](),_0xa135ba[_0x22cafd(0xd83)]())){if(_0x495b25['isEnemy']())return-(0xb5e+-0x1760+0xc03);if(_0xa135ba[_0x22cafd(0xb9a)]())return-0x3*-0x4c+0xc0a*-0x1+0x23b*0x5;}if(_0x495b25[_0x22cafd(0xd83)]()&&_0xa135ba[_0x22cafd(0xd83)]())return _0x2dbf95[_0x22cafd(0x1373)](_0x495b25[_0x22cafd(0x96c)](),_0xa135ba['index']());return _0x2dbf95[_0x22cafd(0x158d)](_0x495b25['battler']()[_0x22cafd(0x156)],_0xa135ba[_0x22cafd(0x81d)]()[_0x22cafd(0x156)])?_0x2dbf95[_0x22cafd(0x1373)](_0x495b25[_0x22cafd(0x81d)]()[_0x22cafd(0x1098)],_0xa135ba['battler']()[_0x22cafd(0x1098)]):_0x2dbf95['AUOlV'](_0x495b25[_0x22cafd(0x81d)]()[_0x22cafd(0x156)],_0xa135ba[_0x22cafd(0x81d)]()[_0x22cafd(0x156)]);}),SceneManager['isBattleFl'+_0x5e4757(0xe11)]()&&this[_0x5e4757(0x856)][_0x5e4757(0xff2)]();},Window_BattleEnemy[_0xe90fac(0x510)][_0xe90fac(0xf81)]=function(){const _0x9e20ff=_0xe90fac,_0x181621=VisuMZ[_0x9e20ff(0x118f)][_0x9e20ff(0x281)][_0x9e20ff(0x105f)];_0x181621['LastSelect'+'ed']?this[_0x9e20ff(0xf81)+_0x9e20ff(0x116a)+'ed']():this[_0x9e20ff(0xf81)+_0x9e20ff(0x680)]();},Window_BattleEnemy['prototype'][_0xe90fac(0xf81)+_0xe90fac(0x116a)+'ed']=function(){const _0x4178fd=_0xe90fac,_0x4be56e=BattleManager['inputtingA'+_0x4178fd(0xce0)]();if(_0x4be56e&&_0x4be56e[_0x4178fd(0xcf2)+'e']()){if(_0x4be56e[_0x4178fd(0xcf2)+_0x4178fd(0x9b2)+_0x4178fd(0x8df)]()){if(this[_0x4178fd(0xef2)]&&this['_enemies']['includes'](this[_0x4178fd(0xef2)])){const _0x4b3d3c=this[_0x4178fd(0x856)][_0x4178fd(0x741)](this[_0x4178fd(0xef2)]);return this['forceSelec'+'t'](_0x4b3d3c);}else return this[_0x4178fd(0xf81)+_0x4178fd(0x680)]();}}if(this[_0x4178fd(0xe9d)]&&this[_0x4178fd(0x856)][_0x4178fd(0x79c)](this[_0x4178fd(0xe9d)])){const _0x2d6025=this['_enemies']['indexOf'](this[_0x4178fd(0xe9d)]);this[_0x4178fd(0x91b)+'t'](_0x2d6025);}else this[_0x4178fd(0xf81)+_0x4178fd(0x680)]();},Window_BattleEnemy[_0xe90fac(0x510)]['autoSelect'+'Priority']=function(){const _0x5f2965=_0xe90fac,_0x1567fc={'mXhWT':function(_0x33e57b,_0x3d6ceb){return _0x33e57b-_0x3d6ceb;}},_0x28fdb8=BattleManager[_0x5f2965(0x450)+_0x5f2965(0xce0)]();if(_0x28fdb8&&_0x28fdb8[_0x5f2965(0xcf2)+'e']()){const _0x26e3f0=$gameParty['aliveMembe'+'rs']()[0xe9*-0x1+0x2230+0x2147*-0x1];let _0x158ffc=this['_enemies'][_0x5f2965(0x741)](_0x26e3f0);const _0x4c380b=_0x28fdb8['item']()[_0x5f2965(0x108c)];if(_0x4c380b[_0x5f2965(0x3eb)](/(?:ALLY|FRIEND) OR (?:ENEMY|FOE)/i)){this[_0x5f2965(0x91b)+'t'](_0x158ffc);return;}else{if(_0x4c380b[_0x5f2965(0x3eb)](/(?:ENEMY|FOE) OR (?:ALLY|FRIEND)/i)){this[_0x5f2965(0x91b)+'t'](_0x1567fc[_0x5f2965(0x1050)](_0x158ffc,0x441+-0x3*-0x66e+0x178a*-0x1));return;}}}const _0x4be301=VisuMZ['BattleCore'][_0x5f2965(0x281)]['Enemy'];let _0x41a2de=![];$gameSystem[_0x5f2965(0x53d)]()?_0x41a2de=_0x4be301['SideviewSe'+_0x5f2965(0x140a)]:_0x41a2de=_0x4be301[_0x5f2965(0x14a5)+'elect'],this['forceSelec'+'t'](_0x41a2de?_0x1567fc[_0x5f2965(0x1050)](this[_0x5f2965(0x44e)](),-0x8c+0x76*0x47+-0x1*0x202d):0xc20+-0x10fd+-0xf9*-0x5);},Window_BattleEnemy[_0xe90fac(0x510)][_0xe90fac(0x1093)+_0xe90fac(0x5df)]=function(){const _0x35df5e=_0xe90fac;Window_Selectable[_0x35df5e(0x510)][_0x35df5e(0x1093)+_0x35df5e(0x5df)][_0x35df5e(0x351)](this);if(!this[_0x35df5e(0x70d)]())return;if(this[_0x35df5e(0x70d)]()['isEnemy']())this[_0x35df5e(0xe9d)]=this[_0x35df5e(0x70d)]();if(this[_0x35df5e(0x70d)]()[_0x35df5e(0xd83)]())this['_lastActor']=this[_0x35df5e(0x70d)]();},Window_BattleEnemy[_0xe90fac(0x510)]['select']=function(_0x4f26ef){const _0x4f0c62=_0xe90fac;Window_Selectable[_0x4f0c62(0x510)]['select']['call'](this,_0x4f26ef),$gameTroop['select'](this[_0x4f0c62(0x70d)]()),$gameParty['select'](this['enemy']());if(!this[_0x4f0c62(0x70d)]())return;if(this[_0x4f0c62(0x1356)+_0x4f0c62(0x15c6)+_0x4f0c62(0x1388)+_0x4f0c62(0x972)]()){const _0x496539=SceneManager[_0x4f0c62(0x11dd)][_0x4f0c62(0xfb)+'ow'];this[_0x4f0c62(0x70d)]()['isActor']()?_0x496539[_0x4f0c62(0x10d9)](this[_0x4f0c62(0x70d)]()[_0x4f0c62(0x96c)]()):_0x496539[_0x4f0c62(0x120e)]();}},Window_BattleEnemy['prototype'][_0xe90fac(0x1356)+_0xe90fac(0x15c6)+_0xe90fac(0x1388)+_0xe90fac(0x972)]=function(){const _0x464366=_0xe90fac,_0x18111a={'gSAvU':_0x464366(0x142c),'cQHYb':_0x464366(0xa83),'PGVAJ':_0x464366(0x142b),'AMuZU':_0x464366(0xea1)};if(!this[_0x464366(0xf56)])return![];if($gameSystem[_0x464366(0x53d)]())return![];const _0x24c3f3=SceneManager['_scene'][_0x464366(0x3a1)+_0x464366(0x15fa)](),_0x5a7d7b=[_0x18111a['gSAvU'],_0x18111a[_0x464366(0x1ea)],'xp',_0x18111a[_0x464366(0x1f2)],_0x18111a[_0x464366(0x1017)]];return _0x5a7d7b[_0x464366(0x79c)](_0x24c3f3);},Window_BattleEnemy[_0xe90fac(0x510)]['openBattle'+'ActorWindo'+'w']=function(){const _0x558155=_0xe90fac,_0xfb436={'PvXbn':_0x558155(0x142b),'KQtot':_0x558155(0xea1)},_0x5a2605=SceneManager[_0x558155(0x11dd)][_0x558155(0xfb)+'ow'];_0x5a2605[_0x558155(0x3f3)](),_0x5a2605['setEnemyWi'+'ndowMode'](!![]),_0x5a2605[_0x558155(0x944)](),_0x5a2605[_0x558155(0x120e)]();const _0x16860a=SceneManager['_scene'][_0x558155(0x3a1)+_0x558155(0x15fa)](),_0x5446bc=['xp',_0xfb436[_0x558155(0xb27)],_0xfb436[_0x558155(0x9f5)]];if(_0x5446bc[_0x558155(0x79c)](_0x16860a)){const _0x4bf1a9=SceneManager['_scene'][_0x558155(0xbed)+_0x558155(0x1600)];_0x4bf1a9[_0x558155(0xe61)]['y']=0x253+-0x1*0xc77+0xa24;}},Window_BattleEnemy['prototype']['closeBattl'+_0xe90fac(0x14f9)+'ow']=function(){const _0x24c5c0=_0xe90fac,_0x2c3eda=SceneManager[_0x24c5c0(0x11dd)][_0x24c5c0(0xfb)+'ow'];_0x2c3eda[_0x24c5c0(0x150b)](),_0x2c3eda['setEnemyWi'+_0x24c5c0(0x439)](![]),_0x2c3eda[_0x24c5c0(0x120e)]();const _0x1f9a1c=SceneManager[_0x24c5c0(0x11dd)][_0x24c5c0(0xbed)+_0x24c5c0(0x1600)];_0x1f9a1c[_0x24c5c0(0xe61)]['y']=0xc39*0x2+-0x2206+0xdf*0xb;},Window_BattleEnemy['prototype'][_0xe90fac(0xcb)+_0xe90fac(0x1243)]=function(){const _0x3875a0=_0xe90fac,_0x1edaee={'QbqXj':'all\x20enemie'+'s'},_0x574028=BattleManager[_0x3875a0(0x450)+_0x3875a0(0xce0)]();if(_0x574028)_0x574028[_0x3875a0(0x49e)+_0x3875a0(0x115d)](_0x1edaee['QbqXj']);this[_0x3875a0(0xba9)]();},Window_BattleEnemy[_0xe90fac(0x510)][_0xe90fac(0x12af)+_0xe90fac(0x1296)]=function(){const _0x133e41=_0xe90fac,_0x3e5c38={'oUbcP':_0x133e41(0xa59)},_0x41d325=BattleManager[_0x133e41(0x450)+'ction']();if(_0x41d325)_0x41d325['setTargetB'+_0x133e41(0x115d)](_0x3e5c38[_0x133e41(0xf35)]);this[_0x133e41(0xba9)]();},Window_BattleEnemy[_0xe90fac(0x510)]['isCurrentI'+'temEnabled']=function(){const _0x10c082=_0xe90fac;return this[_0x10c082(0x8cb)+_0x10c082(0x1413)+'id']();},Window_BattleEnemy[_0xe90fac(0x510)]['isActionSe'+_0xe90fac(0x1413)+'id']=function(){const _0x2978c5=_0xe90fac,_0x15ab1c={'PVBQR':function(_0x428408,_0x13e80e){return _0x428408===_0x13e80e;}},_0x175c7f=BattleManager[_0x2978c5(0x450)+'ction']();if(!_0x175c7f)return!![];if(!_0x175c7f[_0x2978c5(0xdd)]())return!![];const _0x503499=this[_0x2978c5(0x70d)](),_0x3ed9cc=_0x175c7f['item']()[_0x2978c5(0xfee)];if(_0x175c7f['isForNotUs'+'er']()){if(_0x15ab1c['PVBQR'](_0x503499,BattleManager[_0x2978c5(0x31d)]()))return![];}return!![];},Window_BattleItem[_0xe90fac(0x510)]['includes']=function(_0x563720){const _0x1a88f4=_0xe90fac,_0x5259f9={'RHgcU':function(_0x262c4c,_0x114659){return _0x262c4c===_0x114659;}};if(!_0x563720)return![];return _0x5259f9[_0x1a88f4(0x1265)](_0x563720['occasion'],-0x1aec+-0x1607+-0x1051*-0x3)||_0x5259f9[_0x1a88f4(0x1265)](_0x563720['occasion'],0xd*0x1f3+-0x115e+-0x7f8);};function _0x84f8(){const _0x54006=['addCustomC','onEventKey','ngeTo','eActorWind','cHuxM','orderStyle','TWRDO','fier','eIROS','tionJS','YSICAL','yer','CfSRW','makeSpeed','ugePositio','lJUnx','nitialize','Naqhq','get_PrevTa','BnUBr','Modifiers','hide','textBaseli','silentHome','eWeaponSlo','lastComman','JGltu','MaxLines','muXBp','1|0|3|2|4','hsZlj','tleCommand','effects','_skewX','RqfBZ','ction)\x20?\x20t','sText','setHalfAct','yFPow','_targetHom','animationB','JS\x20%1END\x20B','Points','EasingType','act_ZoomBl','finishActi','ypJpz','OBogc','removeBuff','#ffffff','ement_Wait','updateHelp','type','MANUAL','EffTm','Scene_Batt','tStateOrig','owRectDefa','iveWeapon','jfMEV','nuZmH','updateName','qNGWa','isTriggere','XXWYg','dafpZ','suMZ_Battl','ap1','opacitySpe','pagedown','aGIDh','Ibpmh','astTime','cBattlerKe','orPenetrat','ITtLT','erBase_ini','shadow','mCTB','ActSeq_Mot','blt','DgPug','performRec','CqeHG','cancelHpLi','_forcedHom','MWCLS','age','LywEN','ReflectAni','ebuff','w_Reset','tActionSet','KmxXv','uAJOp','KvCTg','getItemDam','MotionSpee','battleCame','EgMWd','hiLsa','onSpriteTo','LCFQL','\x20=\x20obj;\x0a\x0a\x20','VisuMZ_0_C','bol','isMagicSki','ziOae','vNyAX','install\x20%2','_enemyName','cRrzj','LtKch','SlotID','ThiId','removeActo','PreDamageJ','addBattleC','nterWindow','applyVaria','le_partyCo','1Name','tyRefresh','eWait','SyncBuffEx','em()\x20:\x20obj','0|1|2|3|4','obj','ionsMet','Declare\x20Co','ants\x0a\x20\x20\x20\x20\x20','iveImpactF','Game_Map_b','tWGgg','Return\x20rat','aying','SkewX','jsOneForOn','tion','drawBackgr','KnVkh','jKLba','hanics_Sta','zWWcB','fPqQh','PaWBZ','_forcedBat','changeTurn','preter','Jdiej','Icon','oVwlx','le_selectN','with\x20lates','Formula','SamGA','TFiXX','canUseItem','eRhNw','esAuto','mported.Vi','_motionSpe','dimColor1','tAbQh','Evasion','Enable','pushBaseLi','7|5|2','nTKAR','WDLEV','n_testAppl','Fight','_weaponIma','wAnimation','cCTTR','_opacityWh','dSeiD','GaugeDispl','requestFau','eSprite','rkuAe','eSteal','tlers','NOTE','ConvertPar','Game_Troop','_interpret','andVisible','ateAll','VarianceFo','battleSpri','DefaultDam','ationId1','Time','fnordAdded','tal','ement_Opac','Sprite_Wea','ton','WSfNk','orGroup','inParams','getColor','attachSpri','CastAnimat','leField','imationCon','ghOUF','tFrontview','battleZoom','placeActor','Cfotd','tlerMotion','\x20\x20\x20\x20return','ceX','CommandSel','bhvKk','bXdve','VisuMZ_3_V','eceiver\x20=\x20','Class-%1-%','mpatibilit','\x20Return\x20Va','on\x20does\x20no','tleSkill','mandWindow','Types','_buttonTex','iqMBL','nents','eOffsetY','_totalHits','erBase_era','teTurnsCha','vckCa','cted','setupBattl','SvYry','BGCrx','ywIzh','Sprite','nchorY','gWwcs','ons','ED\x201','damageOffs','ATK','KqIjV','MoveToTarg','ctsContain','isInputtin','push','eOffsetX','jumpBattle','LEKSx','wKCtX','artyComman','monEvent','ionPauseRe','\x20to\x20%1\x20mid','utStyle','BPhjO','echcq','HalfAction','battlerSmo','rollX','dow','ommandAdde','er;\x0a\x20\x20\x20\x20\x20\x20','n_applyGlo','fhoXm','dows','ckground','hadowVisib','randomInt','jectile','qProjectil','atJS','resetFontS','mOTB','CvtqR','ngeBy','isibile','leMass-%1-','.log(e);\x0a\x20','clearForce','back','displayMis','trait','eAziN','wOffsetX','sliceMin','le_start','KAzxh','tCap','nsEnd','HP_Flat','rDistance','update','ePosition','ylCBd','Enemy-%1-%','KhAya','\x20\x20\x20const\x20s','cts','cjzZr','_createCur','createChil','yDuration','isPhysical','FlashColor','rAmLy','_armorPene','placeTimeG','ommonEvent','VisuMZ_2_H','le_command','PDhrv','jSXAu','LGZLu','\x20\x20\x20\x20\x20//\x20Re','ror_NoiseR','VdWyt','encounterL','peSuccess','cvWaZ','nQsYB','optDisplay','wuoYQ','tNXIY','HRxLq','dpjEi','NUvXa','setHome','loadSystem','myEscape','igAwS','isGuardWai','txRDB','SceneManag','\x20\x20\x20\x20\x20\x20\x20\x20\x20c','argets','ipHorz','ChantStyle','lIdRJ','yXgqr','tleBalloon','\x20\x20\x20\x20let\x20or','YJIpp','extPopup','battleStat','CastMagica','sion','selectAllE','rnJS','refgu','rs\x20not\x20use','SpeedJS','ResumeLaun','ateActors','leStep','_inputting','\x20rate\x20crea','pYGkz','TextAlign','rentState','_forActor','setImmorta','eSwgc','1|5|2|4|3|','eiqWX','item','getBattler','\x20\x20\x20\x20let\x20va','_targetY','BlurTarget',',obj.name)','ams','CpkMy','_requestRe','etX','_cache','OyPgs','nPortraitF','chBattle','AllActorsT','iGUKt','or\x20===\x20Gam','chant','tener','_lastHpDam','peCommand','eaponSwapS','startOpaci','loadWindow','updateOnce','setFrame','BattleSyst','weatherPow','orMsg','HQRbv','_actorWind','Skill','displayMpD','getChildIn','balVariabl','resetNameT','qIIXk','AnimationI','checkTpbIn','rate','Data','attle','const\x20heal','N\x20Check\x0a\x20\x20','MeleeDista','Rmjlo','floatBattl','UeMcm','lKSlQ','VisuMZ_2_D','performCou','tEfoY','ZBddt','applyGuard','yleIcon','dBattleCor','eStart','geText','rycjv','prite','ist\x20from\x20s','loonSprite','command357','eAction','End','FatMf','_growX','rInput','disperseDa','battleEffe','tleStatus_','sigzy','_doubleTou','turn','updateEven','WCikH','setSubject','PointJS','gdrsP','addItemCom','isPlaying','\x20\x20\x20\x20\x20origi','equenceSpe','isArray','ommand','ttiJo','kSwitch','ols','WaitForPro','damageFlat','le_termina','0|5|22|39|','ToTarget','asion','HnqsV','ySYDP','monEvents','ectedStatu','processEsc','wkhcw','uOJRo','ShakeFlinc','ioHiv','wRect','eCore_Note','OYxjl','anchorY','Targets2','PDvtH','nit','commandSym','name','IzRlq','updateStat','findIndex','QWOlP','VJiZG','WaitForSke','peFailure','Weapons','ldTimes','_baseX','ScaleX','_damageCon','isSceneCha','mfcKW','t())\x20conso','STZYb','ACTOR_OFFS','zaImY','ionEnd','lSystem\x20ne','EHllY','NewState','mation_Sho','sAuto','_preBattle','hMotion','updateGrow','tion_Scale','CeWSE','ence','setValue','hPxxs','or_moveToS','\x0a\x20\x20\x20\x20\x20\x20\x20\x20}','2|4|1|0|3','_tempActor','SwitchMiss','iconWidth','oiNAK','_distortio','Effect','eraseState','Game_Temp_','special','performDam','JRdXx','playMiss','PkNKj','isDead','AllowRando','JlSxZ','VariableID','erBase_add','startParty','QPvch','lBDqr','ace','ndEscape','JS\x20%1END\x20T','alidForAny','mber','rorMsg','oryJS','t\x20user\x20=\x20a','atusListSt','StartTurnW','Dragonbone','orvmE','ition','ustomActio','RegExp','qyiny','preter_com','mCeiN','SjxsA','attackMoti','BindCommon','dLOkj','alCutinEff','AbQtI','HZBgt','uNfHQ','tState','TOLXu','GroupDigit','tleLog_per','ield','dom','mand','_commonEve','startJump','MAXMP','command236','maxCommand','ions','AHtnO','t\x20match\x20pl','stbGainIns','_shakeFlin','tleLog_Cle','UseSkills','1865692JVcHmr','ger_abort','Interprete','ARRAYEVAL','tfeUu','showAnimat','indowRectM','zqhuH','zCRMe','isDisarmLi','WzRWS','addEscapeC','ttlers','ansitionEr','_baseLineS','oIBpP','damageCont','HsBnE','EYInd','result','\x20\x20\x20\x20\x20\x20\x20try','nging','enemyNames','VmZzV','qhzrb','ctiles','performEva','moveToStar','nSettings','jRSVJ','aN(value))','ember','isAffected','ttleCoreTr','CiUTf','setSvBattl','le_itemWin','%1Damage%2','targetSpri','owBorderSt','AntiTintUi','ATTACK','fYPHU','callOption','retrieveBa','SGvTS','Selection','ArRedRate','nRhYg','\x20\x20try\x20{\x0a\x20\x20','WJaMZ','Height','\x20=\x20target;','tmap','fJQjb','le_logWind','cQHYb','BsVHC','onDisabled','WaitForEff','_svBattler','terpreters','er_isScene','($gameTemp','PGVAJ','rontviewBa','sTimeScale','MyYTG','UFeUm','YciQE','hanics_Tex','opup','}\x0a\x20\x20\x20\x20\x20\x20\x20\x20','gtIiN','NfWpb','JqnQf','imationAtN','VTUDg','hBaseLine','AddAttackS','close','drawTextTo','HomePosJS','gainCurren','wPosition','rateJS','stjeb','Cols','GfGmO','isFEO','findTarget','onBattleEn','HqeLZ','mPkYG','abort','status','BVkUa','elect','yPPAQ','AGI','\x20\x20%1\x0a\x20\x20\x20\x20\x20','\x20visible\x20=','VIoGS','sTargetJS','ZwKRx','executeHpD','le_WaitFor','_homeWhole','ActSeq_Set','pPage','TFDEI','nAoZI','act_Motion','cUavQ','CopyCombat','Ext','Window','sData','isSelected','temEnabled','DistanceY','Fagqx','jectAnimat','ItMix','ponSlot','<CENTER>%1','ageCap','xYRZl','sleep','CRIVH','vent','ites','andNameWin','ventIdWith','pdrtX','SkewY','XGWLP','ntFront','CancelButt','pow','EnemyOffse','isBypassDa','teAffected','DisplayAct','isStateRes','jDrFd','placeState','xkCBK','eEnd','dRtSf','n_executeH','tMultiplie','geCap','_character','bitmap','}\x0a\x0a\x20\x20\x20\x20\x20\x20\x20','oreHitRate','pDamage_Co','oints','Window_Ite','updateEffe','_growWhole','canEscape','WIqdO','_targetDam','tainer','addTextToC','1|2|0|3|4','ted\x20by\x20%2\x27','updatePadd','OHhlT','nCCmk','DSZpm','WVKwG','performRef','er_perform','AddHpGauge','tler_initM','tOpacity','updateAngl','updatePoin','vasion','act_Shockw','NlHbf','ctSeqCamer','tleLog_UI','loadEnemy','2|8|6|1','eCore_Acti','rzTbV','DfBFk','BSWgF','\x20{\x0a\x20\x20\x20\x20\x20\x20\x20','ationId2','icon','reaHeight','removeAnim','pon_SetAct','er_clearMo','ZoQjv','pfkDr','_stypeIDs','zMxaq','ouping','MLDyQ','ZjFNM','RNvbN','Settings','leX','NwPOg','sCore','t\x20state\x20=\x20',')\x20{\x0a\x20\x20\x20\x20\x20\x20','FAILURE','ivelz','becomeSTBE','BiRub','STRUCT','isGrowing','REUqA','hpHealingF','Remove','keEdN','fdxhz','alterBreak','ToNode','inning','vKTuN','Candidates','TFoSJ','svBattlerN','waitForNew','isCancelLi','pdate','ettings','his\x20:\x20user','play','formEvasio','nch','textSizeEx','or_createS','setHandler','le_skillWi','dSymbol','bYGqA','vtwEt','atusXPStyl','yAtCoordin','rHomeDista','age_create','GSuRj','sFromNode','RCJJc','critical','ActionSet','vJgUn','_hpGaugeSp','mation_Cha','tsisv','dowScaleX','yCommandWi','CalcEscape','dSprite','minimumSta','hgSUd','DInRU','_back2Spri','rtraitSpri','CommonEven','YrjgV','or\x20Ally\x20or','Onzcf','WaitCount','Face','ezhYb','\x20\x20\x20const\x20b','jZWXF','makeBattle','DamageFlat','PosOffsetX','tionSprite','_setup','Animation','ndowRect','tate','putClose','getDamageS','evade','mbers','Code\x0a\x20\x20\x20\x20\x20','motionIdle','DxSHq','StateID','ALL_ACTORS','\x20?\x20this.it','itemPaddin','DRfMS','le_updateS','battleEnd','friendsUni','createUICo','battlerSha','setupShock','Playtest()','ser','64bTGEev','canInput','CounterPla','isWaiting','\x20NaN\x20Check','CheckVisib','ageListSty','custom','itemHit','feat','stitute','setupIconT','HvTdI','ist.\x0aIt\x20is','ingType','value;\x0a\x20\x20\x20','Battle_upd','undType','mfGqv','jXjcx','makeDeepCo','ActSeq_Ang','ill\x20=\x20(thi','cale','_expTotal','le_createH','ndowBattle','imwBU','allowRando','ationConta','width','hBattleCor','_makeCurso','FrameCount','mATB','Angle','FRUSTRATIO','ShuffleArr','outStyle','%1Event','CAsar','s.includes','jTHVH','UMzZg','isForFrien','skew','lerOpacity','ing','createHelp','Vycxo','vqVZU','nsitionabl','arRedFlat','setSkill','inHomePosi','kOaDC','twoZW','alive\x20oppo','actor','SkillCost','didBM','ActorCmd','lqCGV','sTyMK','tor','missed','setItem','cedAction','esRate','ght','ationFromC','_targetGro','lNXvL','attlePortr','iMLOr','xhvLL','ajSfy','flvHf','sor','BattleWind','isBattleFl','UQDNK','GetActionS','iDQAf','setupNegat','disarmHpLi','battleBall','AutoBattle','iHrwb','KwxRb','nCommandIn','clearAllVi','Troops','(obj))\x20{\x0a\x20','QptmD','back1','mage','guardLifeS','CGBBs','ZXzjc','lPzJD','rPortrait','leBackHide','WEeAO','HQWQQ','8|7|10|24|','cutinExit','3|0|4|6|5|','Xoqqm','s\x5cS]*)\x5cs*<','call','ntBack','addActor','prepareBor','on\x20=\x20(this','_enemyWind','_surprise','hasSvBattl','eVersion','5|1|3|2|4|','hitsDmgFmt','AniDuratio','ger_checkB','ageSprite','fywVr','VSrkg','dSgAY','ChangeOrde','ilter','ZlGMS','alive\x20acto','innerHeigh','lateItemEf','PWlFD','ayGSa','NraSP','tWindowRec','SSrcc','owSkinHide','\x20=\x20origina','ement_Face','TSFOL','toLowerCas','wMOss','PostStartB','teSkew','makeAction','yback','rea','numTargets','paSHB','lCutin','moveBattle','ncludes(ob','RDDHJ','requestBal','ollapse','MMRQx','n\x20update!','sted','Exploited','cal','elpWindow','ctSeqImpac','collapseTy','_flipScale','battleOpac','updateActo','performWea','hanics_Arm','eTransitio','ger_startB','addGuardCo','forceActio','xREmq','FpNII','LLltL','nts\x0a\x20\x20\x20\x20\x20\x20','ggroContro','CYudp','ainer','onstructor','nned','singleSkil','performTpb','attackStat','_defeatedE','commandOpt','Mode','erOpacity','battleLayo','OzVSz','fVgIW','frzHY','removeImmo','tleJS','cancelButt','lCommonEve','WindowWidt','ngle','ForSpin','FlashDurat','tle','cture','agePortrai','_frontAtta','FBpHF','PWIpg','mlwqF','ARRAYJSON','Interrupt','onEscapeFa','_logWindow','_nameTempV','preparePar','ectsContai','NlBvM','angingOpac','lgEuw','WVWSB','drawItem','_deathStat','WHcux','rlGbo','QvYVQ','Disabled','_methods','my_update','rs\x20not\x20tar','InEnemyWin','hanics_Ene','stPointsCh','ionScaledY','_forcing','pause','loadPictur','hitType','eToTargets','SETTINGS','ser.curren','4|2|5|0|3|','dmIfA','mXHIh','DEIMH','canGuardBa','iousComman','All','ACeMQ','UAFdi','boxWidth','Immortal','andWindow','clearWeapo','HssVJ','in\x20order\x20f','NcslW','attack','le_createA','eFBgw','isAnyoneIn','ipVert','windowPadd','tleCoreTra','te\x20=\x20rate;','match','createWeat','entAction','/\x20Process\x20','\x20\x20\x20\x20//\x20Dec','UAMvn','Rjhal','gleTargetA','show','osition','alterCost','PJaFS','numberFont','IconIndex','stPointsSt','_regionBat','ForceRando','ser;\x0a\x20\x20\x20\x20\x20','rBattleCor','oring\x20rate','rkbLt','TargetLoca','sUmrJ','attleCore','targetActi','tFlat','WWblQ','_battlerNa','hVGLl','getAttackM','NHtjN','startEnemy','RlCIo','QbZfR','playEnemyA','PortraitSc','sWviO','gainFullAc','UGHIw','traitObjec','hxAWC','QDkNt','dWindow','setupDamag','BFThx','mation_Pla','MFGxr','4|8|6|5|2|','\x27Restoring','yTarget','ect','chMmC','emySelecti','ameText','ffect','FlVKk','ndAutoBatt','IconSet','sorFilterA','SkipPartyC','ombo\x5c{','hanics_Cus','zuuPa','ctiles\x20nee','wWbZJ','isTickBase','hdlzK','ActSeqImpa','VisuMZ_2_A','aCsGh','tags_Targe','tShown','\x5cC[6]%1\x5c}\x20','in_WaitFor','eight','yOISt','geContaine','SvWeaponMa','ndowMode','FyKpJ','isSpriteVS','TiiMU','MOTIONS','setActorHo','filterArea','isMeleeSin','lelInterpr','city','BattleLogR','CVRav','lipped','ers','removeDama','isOptionsC','40|13|0|37','Linear','applyEasin','nemy','ActSeq_Mov','maxItems','zzkww','inputtingA','armor\x20=\x20ob','YtKeN','getCommonE','uIVii','lifeStealR','ger_makeAc','map','dying','gOoKe','ait','\x20}\x20catch\x20(','mibMK','ionsPTB','erBase_isS','Actor-%1-%','YaHmM','WindowBatt','formCounte','ctionEffec','isCancelle','PgaLg','ical','le_onEnemy','1|4|8|5|2|','ActionEndU','696875qMhQZT','Game_Syste','whvly','itemRect','Change','ActSeq_Ele','VrivV','odsUZ','setupCriti','IXDzr','my_initVis','ign','AJBUn','_animation','portraitFl','ttonString','initVisibi','_effectTyp','8|5|1|4|6|','_damages','EventKeysF','RemoveExce','owing','uest','ZUGNa','lue\x0a\x20\x20\x20\x20\x20\x20','\x20let\x20targe','_actorMult','tleback2','tleback_ad','olo','le_helpWin','Value\x0a\x20\x20\x20\x20','ctilePrese','_namesCoun','hasStaticS','fEyRi','MLPfI','_opacityDu','r\x20=\x20obj;\x0a\x20','zuulQ','Sprite_Ani','tCells','ArRedFlat','rCommandWi','koQQj','n_apply','\x20targets\x20|','evaded','currentVal','_enemyIDs','text\x20targe','setTargetB','lifeSteaIt','_multiplie','leY','performCol','ToJsPoint','resetTextC','ement','tal\x20Damage','mainSprite','on_Notetag','minate','Victory','jTKgR','pDKUo','KyXTP','onSelectAc','QSNrZ','act_Desatu','getTraitSe','sUserJS','QWwYZ','ActiveTpbO','sume','efurh','krWRI','Scene','n\x20=\x20target','\x0a\x20\x20\x20\x20\x20\x20\x20\x20/','ShowButton','EOBlv','Scene_Map_','tion_1for1','windowskin','j;\x0a\x20\x20\x20\x20\x20\x20\x20','ename','KExri','JRcvF','attleVoice','Action\x20Seq','oiIln','processEne','CalcAction','ParseState','vkCZM','cAolD','DGdXN','applyCriti','3|0|5|2|1|','animationI','updateForc','\x20%2','Ashtk','StateIcon','end','onSpriteOf','SHOW_BUTTO','uZLmM','jsScaleToF','ror_TVRemo','hpDamage','tViewSprit','_damageCou','Wolsb','AILqT','QxVSI','lMHJY','XFvRL','VjScu','createBatt','_floatEasi','fittingHei','QBuLa','_cursorAre','dAiyY','qGylD','eBalloonPl','sUOBE','Ocwlh','LsNHy','disarmMpLi','le_initial','UMeEp','AsTargetJS','currentSym','ied','iconText','7|4|1|6|0|','hanics_Ptb','KHslX','isFriendly','Turns','pdated\x20','createBord','le_startAc','startFloat','YPohu','XKMSH','vdyZD','thrust','fvRml','visualHpGa','Post','cancel','chmentSpri','_helpWindo','_makeActio','sortEnemie','setupChild','JOzhc','drawSingle','tateIconSp','textWidth','...','prototype','QlkSu','priteY','<CUSTOM\x20AC','callNextMe','ortraitFil','applyGloba','jVZZP','onCount','updateBord','PRE-','ss\x20Code\x0a\x20\x20','kLLgg','orCommand_','turate','ossCollaps','isLearnedS','hanics_Onc','PreApplyJS','battleCore','BTestBypas','checkAutoC','\x20catch\x20(e)','sible','Objects','updated\x20','BpKSd','ror_Clear','upArray','addWeaponS','setText','ctSeqProje','18|25|36','dFDaX','Shadow','\x20\x20\x20\x20\x20value','function.','PrioritySo','DxGAb','isTpb','DUCyV','or_updateF','foDgQ','d_RemoveTr','fsetX','isSideView','sxWCG','_colorType','ale','wDesg','fillRect','WeaponSlot','VXdcd','oreVisible','mSpeed','guard','addOncePar','makeAutoBa','KzeQk','eCalculati','setBackgro','updateMoti','_homeY','getAttackW','partyComma','itchCondit','mallest\x20to','emCTB','ParseArmor','isFTB','KJboe','_visualHpG','VpaME','xKifl','rpreter','isDrain','Game_Map_s','ResetOffse','yCache','filter','VXuvp','llWindows','StepDistan','processBor','closeBattl','otVmz','createMain','eFocusOppo','mes','tleLog_dis','Width','Mirror','fight','Ibdlq','WlMwe','6|8|4|0|5|','aeGiq','ateWaitMod','ngState','lity','nameY','_escapeRat','noSimilarS','tObject_No','mIwyL','zvrxb','VoiceLine','emhtp','ionSequenc','eDZJX','iYHAa','onFloatEnd','ancelTPB','getFullAct','_colorTone','allels','playReflec','m_Reset','options','onEnemyOk','zCells','form','TyLGX','hanics_Ftb','zyqBN','cePoint','_partyComm','\x20\x20\x20\x20\x20\x20\x20\x20va','TP_Flat','\x20\x20const\x20we','doesPageHa','ons_maxCom','wOffsetY','jorjq','eWindowDra','zJvIe','magicRefle','my_setBatt','leProcess','FullAction','IkGqV','yWindow','ill','NCuAi','_createEff','wEqCx','BattleLayo','_angleReve','eupJN','isPartyCom','nSequenceN','itemTextAl','fontFace','textColor','ED\x202','oad','XiUjL','con','ss-%1-%2','IIFts','PreStartBa','sbJks','isVisualHp','top','_visibleDu','getSkillId','RaiseJS','mmandWindo','KLxrM','_currentAn','DFnhI','StartName','updateUiCo','Sprite_Bat','dTroopComp','JCExu','t\x20obj\x20=\x20ar','actionBatt','laSPe','orPortrait','nzeeJ','cULtJ','Window_Opt','tzquF','NXMJy','NCJwh','CurrentTur','Ojtsv','abs','attleEnd','_flinched','mEOJg','After','Jmxig','hanics_Boo','ElyFL','WvJwj','BoFfJ','ROwNm','Jbbps','ddle','displayFai','battleProj','\x20origin\x20=\x20','nShownOnBa','target;\x0a\x20\x20','ement_Skew','ler','6|9|7|2|1','iconIndex','ndWindowRe','uTjFB','e\x0a\x20\x20\x20\x20\x20\x20\x20\x20','OadgX','SelectionM','unter','fadeShiftX','onActorOk','ameraOffse','LIGHT-BULB','NmFHL','does\x20NOT\x20s','KyngB','selectSymb','PopupOffse','CTION','randomTarg','tzeJz','BPflW','COMBAT\x20LOG','egrdB','ShowWeapon','suMZ_1_Ski','kdJlb','ioBYp','ShowCurren','parseForce','KWdGE','addDamageS','ZBQbW','wait','Game_Enemy','ldeQh','executeDam','%2\x27.format','eZIgN','gcbeU','MWxgv','Setting','ActorWindo','CommandTpb','processBat','createDigi','akOct','mhp','HITTYPE_CE','DekDG','Visibility','rCamera','tqvxw','1|0|2|4|3','addOptions','GRID\x20MOVE','statusWind','act_TimeSt','owXPStyle','_colorFilt','oneSelect','clamp','YMBCh','mation_Att','VoLRF','createCanc','_lineHeigh','tRate','qiAVt','lUWdd','VisuMZ_2_W','just','LlbVf','VariableDm','KMOpT','removeCurr','oDBpG','ectAll','10egKkFI','formReflec','tQkQk','FBSeS','Down','SOcKA','AttachStat','rmulaJS','FormulaBat','PreDamageA','iKZhr','clearGloba','removeHorr','tler_start','customDama','%1StartBat','comboWindo','\x200;\x0a\x20\x20\x20\x20\x20\x20','checkCache','gwAIG','h\x20(e)\x20{\x0a\x20\x20','CoreEngine','kState','ghbdY','sFhBB','SdpvL','kevPC','makeComman','tionCostPT','NameAttach','stTarget','hHxKb','tlerSprite','Cost','battleInje','eMotionFra','clearFreez','ceY','BattleCmdL','_updateFil','destroyDam','DEFEAT','usCore','HHsrs','2|1|5|3|0|','eds\x20to\x20be\x20','etY','ActSeq_DB_','lapse','owSelectab','battleback','uuBtI','transform','LDHJP','applyHardD','CExaB','UpQHE','tler_damag','all\x20target','MUfSf','LDQnG','VosWt','applyForce','esSpriteCo','Key','updateSele','orFilter','SettingsBa','le_onActor','RfsFt','ParseClass','terWindowR','nsitionErr','waitForEff','ndCancelTP','setBattleZ','actionEffe','createHpGa','ToFit','concat','\x20target;\x0a\x20','dowScaleY','onSet','Priority','kqHMS','ap2','3|5|4|7|0|','HwTzp','QcwCU','hanics_HpM','playCancel','wNauH','cameraDura','er_push','my_updateB','pWeapon','forceMotio','Value','dppvm','ageContain','oreAutoBat','pes','MiVgm','battleDisp','attleGridS','2|0|1|3|4','uDtJo','LtJPV','flipVisual','\x20plugin\x20pl','jectAniPre','_actor','otetags','rEffects','PostRegene','aCDes','hanics_Bre','xbZtC','hadow','padding','yniXS','multiTarge','BccIO','_commandNa','ger_isTpbM','gXJww','isValid','basicGauge','wDkJB','ideSkillNo','bal','ionData','VariableHe','_homeEasin','apse','sVqxN','pDamage','drawComboT','cMcLs','eLoaded','currentCla','EXSKZ','ForceExplo','arallelInt','eNoElement','tes','turnAction','tleStartup','isCTB','w_WaitForS','ndSingleSk','mxIhJ','NameAlways','usePremade','ActionEnd','mBTB','egbac','version','rguments[0','owMode','rFrames','startDamag','WEAPON\x20SWA','arguments[','n_executeD','sZRJs','xPUze','hanics_Mul','mxKYd','or\x20VisuMZ_','get_Curren','isSubjectV','_damagePop','thod','];\x0a\x20\x20\x20\x20\x20\x20\x20','DTB','SIjLk','3|0|4|1|5|','TextColor','lity\x20Varia','onEncounte','n_setSkill','endAction','\x20\x20\x20const\x20r','rateDamage','requestBat','ionMotions','Game_Battl','laJS','lue\x20=\x20argu','ameTemp.is','qjUWu','aqcmS','ultStyle','ufROP','PkSsH','JVEZE','waitForOpa','CmdTextAli','preter_Plu','SAckC','frontview_','addShowHpG','JoKzo','IAKKA','KUrzA','AQzLx','ctionJS','hitText','how','nVisibilit','Newfy','pointX','Vbuuh','\x20\x20\x20const\x20a','isBusy','xzOol','BG_TYPE','FePpb','ShowTpDmg','isAnyoneGr','startGrow','BAHkL','LifeSteal','enemy','olSystem','gFLPB','drawItemSt','AsTarget','SLEQD','movement','cPBuK','pWPFC','drawActorF','isMagical','zPoOb','BattleAI','toCMF','aVflB','FriendBatt','eters','.construct','enabled','\x20const\x20cur','createAnim','mandLines','tleActor_s','rHomeToPoi','FMKIa','commandNam','_tpbSceneC','children','isAnyBattl','bitmapHeig','ZYZsG','alive\x20frie','string','rARJW','speed','ionRefresh','_item','eCore_Trai','Scene_Opti','Create','displayBuf','disarmLife','tute','iuljy','vfugf','targetObje','eCaps','bqnPj','tesToDisto','VuuRX','Armor-%1-%','dCap','indexOf','d_Traverse','isAlwaysVi','Mzdhv','Evade','5|3|2|1','Vtsmy','jsAccuracy','isBattleMe','startHomeM','innerWidth','OzpKD','\x20\x20\x20const\x20h','QUcNQ','buffRemove','battleComm','mulaJS','aseDelay','n_isForOpp','eXBxI','Text','Visible','Filter','hangeCache','ue;\x0a\x0a\x20\x20\x20\x20\x20','pointY','popBaseLin','onGrowEnd','6|2|5|3|1|','fresh','kKtol','gnsyz','%1Regenera','_addActor','performAct','_frame','amQgy','playCurren','ptAkQ','\x5cI[%1]%2','mation_tar','charged','try\x20{\x0a\x20\x20\x20\x20','mqcei','urn','flashColor','startWeapo','registerDe','tRateJS','MotionType','VzCFa','oating','hanics_Wai','le_selectP','bJVwJ','tleLog_Add','actFilter','\x20\x20\x20if\x20(isN','QtzUx','fXpMK','at(\x27\x27,obj.','getHardDam','slice','ands','isShownOnB','zgDCV','deactivate','yZnZi','Qoxjt','ones','geId','performJum','itemLineRe','applyItem','textAlign','isForOneBa','EFFECT_COM','_targetHit','rtyCommand','VmsuE','|\x20[];\x0a\x20\x20\x20\x20','hanics_Dam','allowColla','_endingBat','itemWindow','ration','EffectCoun','ity','fUvrL','battleMove','makeEscape','includes','_weaponSpr','EXCLAMATIO','cqezN','Sprite_Gau','hitFlat','ionY','cijlM','MTZiy','mxIUK','_enemyID','PosOffsetY','eyoZq','st())\x20{\x0a\x20\x20','PnVBm','hpRate','orrorEffec','ntQueue','Msg','rrectly\x20pl','BattleEndE','ALL_ENEMIE','ZKamy','rate)){\x0a\x20\x20','startSkew','fpTus','wQxHt','boxHeight','traitDurat','getInputBu','spriteId','ore\x20&&\x20$da','Xgsen','vvMpB','ebackBattl','applyResul','getHalfAct','animation','ActionItem','pha','Shield','NPVuB','_callScene','qsAFw','mageMotion','_lines','bSiAX','nIDAtNode','CommandWid','eatedBefor','code','xtnFr','ope','troop','guardHpLif','rMRkL','pmlag','hanics_Etb','cialTarget','Damage','eCore_Dama','AmXRS','endAnimati','QzopX','endTroopMe','Mechanics','updateCoun','isJumping','mmands','pwusg','QLRJz','tPositionB','isAttack','addNewStat','_emptyBitm','FocusY','eDuration','_stateSpri','Buffs','loonIconRa','setupHpGau','TFxzA','GICAL','ard','hidden','mWlOr','uence\x20Impa','AnchorX','ANTI_TINT_','currentAct','mageCap','nSet','startActor','Order','ocURO','_targetBat','dWNEd','QTSKv','ange','ets','oostAction','HVvmX','lineRect','EBUSh','emerge','processExt','teJS','DIZCz','trim','ridFO','_makeFontN','reakShield','updateKeyb','VisuMZ_4_C','tleCore','NameLegacy','CEidp','agePopup','xmNzx','domizedDat','NTEGER','lgFZZ','lectionVis','PreRegener','BattleVict','tBattlerKe','lukEffectR','CZWlQ','itute','battler','ayed','jHVMB','\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20','StatusWind','NmJXe','ontainer','ingState','Duration','hanics_Ctb','GHzaa','zhtiL','tsUsableIt','Qawbo','isPTB','dloan','mand301','nsole.log(','VisuMZ_3_W','isTpbMainP','rite','xgxQD','le_createC','istStyle','FlinchDura','getMenuIma','_skewDurat','ActionSkil','VlPYv','setCustomD','ZivaE','yUTtN','CommandVis','BattleTran','ctBorderSt','DisablePar','Action','PLnnq','abelOrigin','veStatesTo','MrSmk','PerformAct','DualWield','battlerKey','emulateAct','nIndex','ateFrame','battlerNam','0|4|3|6|8|','abnormal','fected','\x20a\x20Tier\x20%2','destroy','isImmortal','Strength','Start','SLGAq','_enemies','Sruhu','wuTPa','VisuMZ_2_B','VAzmi','negativeHp','uJVPY','Point','getEnemyId','gWSpq','pon_loadBi','hSZJm','AsUserJS','HitFlat','orarilyVis','isNextScen','setupTextP','oCJRX','Inputtable','fgosT','reorder\x20th','ORsfJ','PMGwM','bxBsq','ore','battleJump','ectiles','checkBattl','isDTB','mAction','bind','leCommandA','MUSICNOTE','\x20\x20const\x20sk','cXasf','alid','GeWHZ','arPenRate','ntAnimatio','isNonSubme','loonAnimat','tionBattle','urPoint','stateMotio','tartPositi','WNYze','fVfju',');\x0a\x20\x20\x20\x20\x20\x20\x20','CmdIconAut','JzcmA','forceEscap','uEOcv','float','0|8|6|7|4|','dataId','ror_NoiseC','DQtfw','owRect','wHRrP','_reflectio','VRcNB','drawLineTe','TWbcX','ConvertCou','yleIconTex','Intensity','performMag','_enemy','ShowRemove','vNwdf','ActorOffse','fDsOL','cameraOffs','_battleCor','Window_Bat','SmoothImag','%1\x27s\x20versi','allelInter','remove','jPQrl','AMqlJ','ttler','_dragonbon','isSpinning','ctDefaultS','YdYhJ','ibility','ect_Animat','addBuff','ger_applyD','UQofD','BoostPoint','iggerFromN','onActorCan','STYPES','pyjqD','ESuWh','mboWindow','pAMNz','XBNQv','edStates','pse','ctPrep','shouldHide','CmdStyle','KwzxD','clearResul','uZTXz','YcyXR','eWeaponSet','tFilters','battleSys','d_ActionAn','nctions','casting','andEnabled','uIAmQ','isActionSe','\x0a\x20\x20\x20\x20\x20\x20\x20\x20c','makeUnique','descriptio','actionSpli','wtpqd','_mainSprit','%1EndTurnJ','n_makeTarg','nents\x20not\x20','tler','ActSeq_Gri','mpactTimeS','right','YyWwr','States','negativeMp','KskGW','center','battleFloa','nds','dList','gFlat','clearActiv','onStaticEn','attleAI','PostDamage','ShowActorG','MvsLr','tatusWindo','OgQpq','\x20\x20\x20}\x0a\x0a\x20\x20\x20\x20','applyFreez','aaMOu','motionSpee','adlSv','Defeat','oIDxv','sorSprite','formSubsti','isFloating','CrlUl','extendTroo','BattleEndP','WaitForSca','yBack','MukNp','era_Offset','chPower','Ppaon','DyoVa','hmXOi','CbVWy','MotionTrai','tleback1','QZgHi','AKTro','rHnqH','OEaAQ','473556ipvwJX','ttle','veFriend','rOSqr','ible','WAADs','PRnAK','NtqfO','itemTarget','_growY','cjxrL','ionStart','oBattle','EkdLl','KeyTargetR','arget','cameraClam','isAnyoneJu','HelpOption','Requests','Actions','forceSelec','iddleLayou','ctActionSe','setMoveEas','pping','ecKZw','setBlendCo','getWtypeId','removeOnce','mIWIH','rallelTroo','OCkDV','weaponType','performFli','missile','rowSpacing','PeftX','addBattleG','ActSeq_Bat','ActorInput','snapForBac','ubstitute','eSKXV','\x20Compatibi','rollY','WfBCL','createSepa','VcqpN','xtoda','gmOqQ','createComm','cel','ncounterLi','pageup','FeJOT','VZGjY','_shadowSpr','ttleUI','createTarg','sition','Skills','refresh','extraPosit','jump','rdAnimatio','kBmJr','AxiIK','addAnimati','ActionCent','FromKey','JytyR','nSprite','to\x20work\x20','toString','tyle','n_isForFri','or_setActo','mvHHu','WindowRect','UpdiK','apply','\x20\x20//\x20Proce','KeyTargets','wpcph','tBattleCom','tActionsFT','mation_Gua','ents','setX','ckXWG','_waitCount','Ieirh','\x20%3\x20plugin','ceil','BTFUK','Frame','andName','_playTestF','addedBuffs','kudJC','_cacheText','index','raData','hnKLH','portraitIn','amage','bers','tions','bFYrB','era_FocusP','rToPoint','get','UNTITLED','btOJW','redraw','isSkill','gSvrf','qlcOX','wholeActio','linkSprite','visualCuti','seState','_spriteset','worldTrans','E\x20%2','PrSYL','get_NextTa','vmRyl','isOnCurren','lState','ShowMissEv','ActSeq_Inj','uSSgn','ityVisible','ageFormula','Game_Inter','_indent','\x20\x20\x20console','cutinEnter','meWindow','|15|12|17|','updateAtta','AllEnemies','lcDdP','isAnyoneSp','DzdVv','enemyId','eaknesses','isFastForw','MdWjI','EKGSY','fREKz','emConditio','value1','putDisable','updateHpGa','bQXpO','refreshSta','HelpItem','dTroopMemb','_createCli','createRate','isAutoBatt','ement_Home','isQueueOpt','isSideButt','\x20weapon\x20=\x20','process_Vi','gChzS','HokjT','GuCKn','eFocusFrie','rgetNode','maxTp','gle','opZHj','jsScaleUp','TBooe','_canLose','tleLog_pus','makeDamage','fect','ActSeq_Ani','ZWamD','qNWhJ','name));\x0a\x20\x20','attleSyste','getDefeate','random','re!','KQMdU','STfwD','pYbBk','allBattleM','uEBHW','cancelActo','setLetter','CrUtT','updateStar','LifeStealR','dead\x20frien','hDuration','kTyBp','tleLog_Wai','AcIXl','ntainerPos','addChildAt','helpAreaHe','ionResults','le_createE','kill','oint','JRxpR','uge','ack','ANGER','KDRXw','ct\x20needs\x20a','SUsRm','createShad','TpbActiveC','GSqWd','playEnemyD','tionsPTB','rtActive','_uiContain','tleLog_Ref','gnxjR','needsSelec','HKaKq','WeSzN','sliceMax','aXrMx','ridMoveCom','lection','ALL\x20SKILLS','isCommonEv','DistanceX','KQtot','TpGaugeOff','nEvent','edInvertIm','ipKSW','setBattleS','dcVsg','vZxKw','iddle','AtStart','itsBorderS','amageFormu','ment_NullE','frameDelay','collapse','GKQiC','era_Reset','updateTarg','drawText','requestMot','XhbCr','ements','MAT','_motion','ezkBe','CmdIconOpt','ZCTLe','ger_endBat','repeatTarg','_battlerHu','Scene_Boot','dwqPZ','eback','CIXQT','ievQa','getSpecifi','damageText','uzXuY','turnOrderC','_allTarget','NHkzW','terArea','\x20\x20\x20\x20\x20\x20\x20//\x20','canBattler','OFQfR','BattleLog','nCostPTB','BrdgW','svBattlerS','displayAct','le_Reset','CTLwi','ger_startI','iTHlW','hanics_Swa','ntIDs','yNameConta','owSprite','leCore','AutoNoteta','AddNormalS','addSingleS','zjnxw','escape','AzOgN','ultiTarget','kLzmT','tGBXe','Konbn','activate','tleEnemy_s','ner','hanics_Otb','\x20=\x20(this.c','GsbjF','_opacityEa','tionEnd','processRef','ectType','Weapon-%1-','ssActions','IHqOq','revertTpbC','openBattle','YtTlH','gaugeX','ANGLE','ERATE','tHKQD','Notetags','Enemies','MUafT','setupOvers','updateShad','WKAiq','\x20\x20\x20\x20\x20\x20\x20\x20co','XEtUA','VisuMZ_3_B','FoZaH','lid','all\x20actors','orm','All\x20Allies','ion_Perfor','glitch','isOTB','iETYW','Vcnvk','gaugeLineH','IXZjf','createStri','tleLog_Pus','tetags','zjMIU','_battlerKe','height','ParseWeapo','ancelButto','ateJS','Set','WoxMG','eCoreJS','Steal','skillId','formCollap','nemyWindow','othImage','Union','d_ClearPas','fBOdR','ffsetY','updateComm','_transform','ylePortrai','skewBattle','killsState','RevertAngl','LFGir','tack','log(e);\x0a\x20\x20','BloAU','bitmapWidt','list','nst\x20user\x20=','_handlers','r;\x0a\x20\x20\x20\x20\x20\x20\x20','PGIvy','eaponAnima','st\x20b\x20=\x20use','ameraPoint','le_startEn','usWindowPo','\x20\x20\x20\x20}\x20catc','ilename','_injectAni','formMagicE','WaitForFlo','geStyles','geSprite','nhxDo','displayIte','startAttac','XTtlU','lure','displayCha','gradientFi','nRiKs','MThNY','6|0|3|4','\x20\x20\x20\x20\x20\x20cons','traitSet','2|3|4|1|0','canSingleO','aOCzY','displayCri','Update\x20you','IbZLU','gxVln','hanics_Stb','endBattle','autoMeleeS','mBxUg','niQMh','nEffect','criticalHi','\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20','XyEJr','Amp','split','commandRem','FKxCb','ode','QVZwx','eYKHQ','AfKnV','Portrait','LOVE','xQiKd','contentsOp','rDDgm','_actionBat','tleLog_pop','PreDamage%','LIGHTBULB','battleMemb','ayWKQ','3|8|6|38|1','_skewEasin','recoverAll','YKHAh','WvdFA','GTLBs','TrailCreat','ager.','EZBtD','isSkewing','d_PullToTa','SfRye','aHcuY','eBalloons','WaitComple','s\x0a\x20\x20\x20\x20\x20\x20\x20\x20','log','lastFilena','ommandEnab','user;\x0a\x20\x20\x20\x20','ting','\x20\x20\x20return\x20','mand283','VTpQV','ger_endAct','preter_ter','NextTurn','jiRPM','makeTarget','startMove','fnordRemov','undecided','rec','RLbQD','WrYwt','hardDamage','mETB','kHtgC','isForAll','ElementSta','_motionCou','CUXla','tiveWeapon','tyswV','OverallFor','MIN_SAFE_I','displayTpD','CmdIconEsc','parallaxHu','ortionSpri','addSkillCo','eToPoint','shouldPopu','Projectile','nDITx','SPxCZ','\x20\x20\x20\x20\x20\x20\x20}\x20c','hXQeG','target','terminate','isActing','erBase_mee','Exploiter','tal\x20Healin','MzBUO','LQedj','ntainer','ZPxYK','ror_Glitch','PostEndTur','reposition','eKryw','front\x20cent','getStypeId','mation','OYcpZ','NZURC','opponentsU','hitsHealFm','\x20arguments','zvhBU','jghEj','ttleEventV','ARRAYFUNC','egExp','removedBuf','rtal','sAdd','VWrWV','agojN','n_itemHit','ULwTP','smooth','itMEI','olor','aovgw','Mvarq','updateColl','VqmCY','tical','PvXbn','ionX','LUmIC','fWZfq','QAsTo','dSVoe','isNameTemp','layText','LJUGV','isAlive','battleUIOf','dcUtt','t\x20receiver','_endBattle','ests','dInvert','emyBitmapL','GDUaj','obj;\x0a\x0a\x20\x20\x20\x20','SIIYQ','rtNDj','endIcon','skin','DamageRate','riend','hanics_Col','isDying','mation_Ski','e\x20Plugin\x20M','onEscapeSu','n_needsSel','playOncePa','eCoreDamag','ldsvI','TiKIa','ayOffsetY','UfsxJ','Rlwzb','ueSNb','QxOoZ','UosHT','SqFwQ','le_startPa','battlelog','qCVDw','BattleMana','nQoqe','isDebuffAf','PopupDurat','qjSZe','_battlePor','isRightInp','tWcCz','kynZK','CNWtD','owBattleCo','GuardFormu','glpCL','Opacity','prepareCus','uuKYg','ouHXv','umeAfter','WaitCount1','ARRAYNUM','AZzTR','GainTp','StateIconO','Shadow2','ZLcaU','playCritic','XNCSp','Elements','sDefeat','getLastPlu','ZcEvR','LlCjw','parent','n_setItem','lo-%1-%2','VisuMZ_3_F','ShowAddedS','qYZBm','dOayO','customFont','createLowe','s.construc','0|2|3|1|4','rGVlc','lements','Cancel','\x5c}\x5cC[21]To','tStyle','tags_Actio','XVjWA','RectBorder','_waitMode','isForOppon','ombatLog','_displayBa','ions_statu','PreApplyAs','ger_checkS','cancelLife','abelBattle','faceWidth','ooCJz','_updateCur','VFEhZ','IhfYf','extraHeigh','iBWtF','entArea','6|1|2|7|0|','Convert','isEnemy','isible;\x0a\x20\x20','Debuffs','applyArmor','isCustomAc','startIcon','createInne','#%1','\x20\x20\x20\x20let\x20ra','tStatusCor','esh','ChargeRate','eAddedElem','splice','rAlpha','processOk','Item','traitSprit','uVVzT','MotionIdle','wyszH','calcWindow','_showWeapo','\x20created\x20b','CheckSkill','zVJKg','PreStartTu','reTargetSc','eBObL','HxCaf','_battler','n_itemTarg','CnKrF','trTWf','VonSN','pDwAL','LoVSo','ype','aced\x20over\x20','QrhKj','utline','getNextSub','RinZA','Flinch','MSctm','ActSeq_Pro','fRGJa','oardKeys','iofgM','addCommand','formula','atHeight','1228260yRJmnk','sXGDw','ine','mHYRt','stZmJ','ement_Move','PostEndAct','rounded','registerCo','MAXHP','EndBattleP','wText','komnj','ackAnimati','eaponSet','ActionAnim','updateOpac','ion_Motion','shift','tUJmp','tZQoQ','Scene_Item','QaEsz','entReserve','addedState','etsInDirec','nst\x20b\x20=\x20ta','isBattleSy','TxjRu','regenerate','ryQAb','_statusWin','AlTFM','isForOne','ShowFacesL','helpAreaBo','gOVIg','teVisible','indow','Name','_enemyId','d_RemovePa','flashDurat','tFilter','essJS','hanics_Act','d_Animatio','));\x0a\x20\x20\x20\x20\x20\x20','PEkGq','pNEAT','TpxYD','waveImpact','stateRate','putActiveB','gainHp','alterChang','requestDra','VisuMZ_3_S','TrailRemov','CrsxS','HXrkF','HQdmP','RDqli','cfFIo','fmhwA','ier\x20number','bkwkZ','EnemiesByR','ttleCore','ationIdSlo','ugeSprite','Gain','LrRvS','auge_JustD','ACNvb','ltZNA','JFBGJ','n_evalDama','obTCP','updateFloa','OffsetY','BOVpu','ygHqd','otionSlot','mmand','IWMnk','finishActo','cancelTarg','PTHxc','nextActive','tEKkj','pLVWa','mandEnable','1|3|4|0|2','wWTfD','getSpriteP','stepFlinch','ideBattleN','zXAzQ','nuCancel','TextFmt','ogCommand','mmFJX','oveBuffDeb','BMRtj','_action','helpWindow','QzqWD','ResetFocus','hanics_Btb','qDJiw','create','Window_Par','_freezeMot','dead\x20enemi','startMotio','canAddSkil','1];\x0a\x20\x20\x20\x20\x20\x20','era_WaitFo','nucmw','PostEndBat','AutoMeleeA','rywvq','VisuMZ_3_A','wvlfT','LbLzg','_itemWindo','updateJump','createKeyJ','selectPrev','nTypeAtNod','setBattleA','ykwpH','isIncluded','nzjeT','podBd','BFTcw','omActionSe','JkOnU','dowRect','hWCnS','JkRoR','lPDqV','autoMeleeM','updateStyl','targetBatt','Nnsll','tleLog_cle','isBTB','createEnem','processVic','ttackAnima','xJiGm','isConfused','initialize','conBalloon','fset','RecoverMp','ihcGu','playEvasio','isDamagePo','KRsYR','setup','CmdTextAut','llelStart','kWeaponAni','PostStartA','timeScale','MrFhu','mation_Ite','oon','resetCount','rzdhu','AKfVU','ForScale','CFQbw','tler_setBa','iIQnn','dowItem','stepForwar','tVBGu','_targetInd','atibility','xmKGl','Vqild','all\x20enemie','updateBatt','VisuMZ_1_E','hNPLw','phZvw','e_Action)\x20','rJomu','LUK','aturateImp','PopupPosit','loadSvActo','\x20\x20\x20const\x20d','ActSeq_Cut','etupBattle','nList','isGuardLif','killComman','calEffect','clearRect','processAbo','startVisua','Game_Map_e','dIXZX','HOujr','rocess\x20Cod','jzogy','ActSeq_Imp','r\x20===\x20Game','MUSIC-NOTE','ter','isEffectin','ctContaine','mqRNh','rInjectAni','mnFBN','some','riVMt','eSzTW','emove','MifZG','YRkUQ','declareGlo','wBOIZ','FVXor','utMode','_borderPor','aWbqD','nabled','ideviewBat','WvTHX','BattleDefe','STR','AuZad','ortraitOff','ScaleUp','kNNLm','_targetX','RgKkM','Opponents','derActor','createDama','_homeX','ATTLE','argeted','izedText','PFItz','isEscapeCo','tNqHg','forceWeapo','updateFram','ActionCoun','windowArea','changeBatt','ZtpYa','Entrance','DSOhi','_attackAni','Event','Window_Ski','aveCenterT','vcwYJ','Orders','sualCutins','ByBreakShi','embers','AgFBQ','\x20\x20\x20\x20\x20if\x20(I','))\x20console','selectAll','ction','mvpEJ','DEF','PyYWD','zRxUC','tler_updat','checkSubst','MoveToPoin','PUDgf','ode\x0a\x20\x20\x20\x20\x20\x20','isAnyoneSk','oCJxD','font','ActSeq_Cam','Xltrq','hargeTime','tionOrders','tPosition','isForAnyon','expTotal','NBEcx','.isPlaytes','cRdbT','nlapP','addFightCo','_autoBattl','HitRate','waitForFlo','PartyComma','_ptbAction','BattleStar','BZaNR','ger_setup','ainMenuCor','showHelpWi','onst\x20state','guments[2]','mationMV_u','hmentSprit','leUIOffset','ttlePortra','_shadowSca','stepBack','SLEEP','+%1','performSub','eCore_Base','CustomFont','WMdnn','Actor','alwgg','compatibil','displayAdd','MfyCX','eMotionFor','xlCQS','addMeleeRe','Escape','CreateActi','GhhgI','_drawTextB','iconHeight','n_itemEffe','elButton','in_AddVisu','etSelectio','updateLink','ide','or_setBatt','yifmY','PXJlK','svActorVer','UIkAN','StartTurnM','offsetY','1|5|2|7|8|','onDatabase','igin\x20=\x20use','NhCas','_tpbCharge','GosBt','HslAK','lers\x20not\x20u','pactFilter','are\x20Argume','_index','displayBat','\x20target\x20=\x20','effect','tSEfn','\x20const\x20ite','ukoFA','isBuffAffe','Cap','max','fMfrd','howBK','processTur','isMoving','SaYwj','Log','ShowAddedB','aponType','mBattleCor','ITEM','BMwCi','dBuff','zLfsY','onst\x20a\x20=\x20u','eBattleRes','createStat','DnDYk','gJMFS','2Name','icSvBattle','displayEva','isCommandE','isFrameVis','cHTny','eaponSlot','SWEAT','?\x20this\x20:\x20u','m_WaitForZ','YLQoq','dSQCK','llList_max','ftcVj','arPenFlat','_fauxAnima','iHbrq','leBalloons','hanics_Ana','ocation','ger_initMe','active','stop','MSmIW','eClYz','TempVisibi','iveChainIn','slices','setupActio','addAttackC','\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20','\x20//\x20Create','n_setAttac','Users','lers\x20not\x20t','SiUjL','_phase','fnOvv','eIconSprit','Results','KYXCQ','ngeSkew','AggroContr','sing','ame','lVJyj','ComboWindo','commandSty','PreStartAc','ndow','isActor','_lastActio','tePosition','cQYjg','BJYHa','ationSprit','createAllW','ponAnimati','ENxKM','le_windowA','TZZGc','usugc','ortrait','attleCore\x20','dulSU','ionAnimati','geValueDis','hase','nMTUm','reviousCom','chedSprite','sDPFB','isAlwaysHi','lectionPla','reate','isCharging','oom','vEkDV','PQPIe','ExtraSetti','WTpvb','on2','addChild','kTRGp','gPSBP','2|4|5|0|3|','FFktF','AlterCost','playAction','setWaitMod','YfyTi','TNUzl','USER-DEFIN','initBattle','OStLv','HNCLr','jwwFa','SvBattlerS','action','invokeActi','WVMCj','tForBattle','return\x200','urnJS','omZks','oxvLo','SUCCESS','YcATA','VCrDH','sHEQK','hhHAG','oWyPe','HlQPq','id);\x0a\x20\x20\x20\x20\x20','PreEndActi','eWindow','FqEkZ','laySpecial','isOpponent','PyaEI','onOpacityE','_battleLay','oNYBh','ata','MON_EVENT','clearEleme','WtBqq','OrderByCTB','ActionSequ','swapEnemyI','WaitForAni','trueRandom','smoothness','MessageWai','UdSta','tyCmd','WithName','Bmirt','mpDamageFm','yHdyX','Move','lcmat','WaitForExi','SvWeaponSo','JumpToLabe','isSkipPart','updateWait','ForceDeath','rHome','isAnyoneMo','FQdzi','jectile_Pi','IUmSn','_lastPlugi','toUseBoost','\x20\x20\x20\x20}\x0a\x0a\x20\x20\x20','YiFWc','_angleDura','_pattern','tusCore','Loaded','setupFont','pdatePosit','ite','subject','lay','gmGMC','Sprites','COMBATLOG','Guard','sZgee','RqlJx','requestAni','kmaXR','_skillWind','myModeTouc','drawIcon','Ejeaz','sPlaytest(','ess','VisuMZ_2_P','gKKzQ','Ouvrt','hangeEnabl','ParseSkill','addSkillTy','atbInterru','tleStyleCo','_jumpHeigh','LZSUq','MoveToJsPo','fontSize','ipped','zYOus','members','ealRate','\x20const\x20b\x20=','ForJump','gVsFU','era','AxwAJ','ected','xkFyx','YFcsQ','Check','regionId','zptSt','1JS','rtMessages','performAtt','createTroo','setBattleC','CWmJV','SmtMm','agic','_actionInp','ptionsMess','eTpPF','LJjlH','ageAmountL','ctXPStyle','POST-','base','ystem','ShowPopup','AdjustRect','IuAed','ger_proces','wJQmI','_onceParal','_selection','rtActors','tSwitches','PVJdf','DefaultSof','chantStyle','ApplyImmor','portraitTy','_totalValu','eCore_Plug','nTarget','tleActor_h','_updateDur','dzYAK','UHiRZ','portraitHu','RpBsK','qLUqv','VZODB','commandAut','ttleBalloo','EscapeSucc','\x20\x20\x20\x20\x20\x20\x20con','ilure','tration','aced\x20on\x20th','ize','mationId','clearMotio','jTIvj','AsVUI','gainTp','startInjec','tKeys','canAttack','_targetAng','addChildTo','Sprite_Ene','isMVAnimat','OAWKv','ActionEffe','onMoveEnd','scale','aQLCI','_angleEasi','rget','\x20\x20\x20//\x20Decl','wxCLf','d_AddTrigg','createDist','loon','ubLBq','numRepeats','zHcvl','iuYnn','nput','tler_setHo','XCsco','MxBhn','ybzkp','EOEUO','XPActorCom','commandEsc','ionsMenu','ZFEbu','tEnemy','\x20\x20\x20\x20\x20const','applyAngle','tleEnemy_h','tRgbC','le_update','TpbMainPha','isAppeared','tlerKey','updateFlip','XPSpriteYL','XJvkI','mainFontSi','QGZTJ','_updateCol','aANcw','ttleScope','vUvlh','taStates.i','DefeatEven','dHqtv','AsUser','ActSeq_Ske','hanics_Dea','Euvns','uDAQY','JSON','isCustomBa','m_initiali','qSHvC','0|3|7|6','_targetSke','\x20to\x20the\x20la','isForNotUs','setBalloon','zbegD','RDGAP','_lastEnemy','ovedStates','updatePosi','eldkL','border','ameraTarge','isFlipped','FacePoint','RdNHK','BcVwN','ionEndMemb','eplacement','eCore_Crea','magePopup','xidpR','PEtCo','hCQFD','LRjmP','iterateBat','\x20\x20\x20\x20\x20\x20\x20\x20\x20/','xzKvX','NlMXr','BVhOD','pAligned','IdALo','NMmCg','IOfLA','format','VRhDd','ENEMY_OFFS','WaitForNew','yZEbh','rtionSprit','Variable','fsetY','angle','LTMSX','ger_cancel','repeats','UserJS','UiContaine','lgYNR','_skewY','battleSkew','emBTB','OlTII','KDrVD','FRWhI','WQvvE','dded','\x20\x20origin\x20=','Phase','applyImmor','PreEndBatt','nce','<%1>\x5cs*([\x5c','other\x20Tier','upDamage','d_AddPassi','offsetX','rMultipleS','\x20Process\x20C','qJbPW','foJAo','KxRfr','jvdsh','owRectBord','XYllc','GWehA','RONJr','ShowHide','eWindowCen','setSTBExpl','eCore_Fail','displaySta','damageCoun','QPaaj','iwBRc','ePopup','ShowCritic','min','mergedEnem','diUQS','esCore\x20&&\x20','lhRBZ','_lastActor','nLoopingMo','startInput','ger_startT','ScaleY','attackTime','NHjlU','EmergeText','loonIcon','MVxan','Jkolq','balloonId','mList_maxC','erMotionTr','sPTQN','emSTB','1|4|2|3|0','XrTok','meetsUsabl','Back','BIdry','eMain','zRFab','currentExt','ctor\x20===\x20G','%1StartTur','ERmYe','uJcsy','KSfpn','ove','xXVnS','ENFlN','_stateIcon','nBlurImpac','\x20order\x20to\x20','FromNode','sYTSE','ger_select','_jumpWhole','sorArea','efender\x20=\x20','erStylePor','BkddQ','overy','eLCFo','_motionTyp','DwlAc','createMult','KlDhX','hangeOTB','\x20Enemy\x20tar','ies\x20not\x20us','createAtta','item\x20=\x20(th','Target','llWindows_','_battleBal','eItemCondi','updateSpin','addedDebuf','sBattleCor','myXMv','xjwfr','skewDurati','extCommand','addText','teObjects','oUbcP','isBattleTe','endVisualC','acker\x20=\x20us','elGUY','NjGHB','tateSprite','_linkedSpr','FHniy','Direction','CoXBB','ToPoint','addState','fzTxJ','lCommand','skill','PVasF','removeChil','sort','System','ragonbones','leSkillNot','lineHeight','value2','ctAni','ButtonAssi','mmandEnabl','isForAlive','attleback1','(\x27\x27,origin','tionId','vtkHn','empVisibil','visible','nrMwe','leFieldCon','leCoreJS','bLgVc','Slot','4|5|3|0|2|','globalAlph','QUYzg','er_forceAc','debuffAdd','trYRo','nd\x20Provoke','applyDamag','Flipped','iuEZi','SqufG','hpAffected','VisuMZ_1_B','25137YpDxFf','Game_Actor','ConfigMana','.format(\x27\x27','tant','hanics_Rem','showEnemyA','WIDTH','_blendColo','yNgRE','tleEnemy_i','softDamage','rMnaS','startSpin','onHomeMove','unshift','aliveMembe','VzECW','mWindowsMi','WzUsr','updateDura','tlVGG','makeData','\x20rate;\x0a\x20\x20\x20','autoSelect','auge','bgType','launchBatt','ist','message4','contains','charging','_createDam','tleCoreJS','Game_Actio','changePain','formAction','kvCrN','tID','FJLRs','HpGaugeOff','tForAnimat','bottom','_floatHeig','%1\x20is\x20miss','wzQer','onBorderSt','clear','DGSTR','lzGbo','sBpdR','atus','er_onBattl','CutinVert','uXeMI','isBattlerG','era_FocusT','autoBattle','ktyWT','gCxuw','2|1','Count','erToNode','_onDatabas','PostApply%','isAnimatio','ePGmr','opacity','hwFsX','SILENCE','BjZWX','wuNRB','tMap','PuTOX','State-%1-%','QzGnS','_bypass_ap','CFfVt','OcQTs','deathState','eRefreshRe','HGIuc','ftYlw','gGIik','houldMirro','fxXKz','HPdSt','\x20enemy\x20=\x20o','\x20=\x20user;\x0a\x20','setActionS','nbSWK','_lastRegen','SUxgS','sxGcw','achedActor','PreBattleC','_appeared','xZCRp','KhRpe','updateLast','BjWuG','ryRbp','DLiJA','PVGiZ','onText','nGWoX','AnchorY','refreshAct','AddOption','plkqb','lVmtx','ger_startA','erBase_die','Sprite_Dam','createAuto','\x20\x20\x20\x20\x20\x20\x20}\x0a\x0a','retreat','vZRok','mklwW','akShieldCh','eaknessDis','owAttachme','fjcXx','hNAxE','etCandidat','Scale','ActionStar','ZfOtt','_flashColo','LmvIT','ChildSprit','tGsRn','calHitRate','note','ment_Force','isUndecide','pSfng','reverse','d_PushFrom','refreshMot','JS\x20%1REGEN','formRecove','sJxPZ','ffectSetti','WaitForCam','.log(\x27Rest','alue','skills','bYNGU','sDFCV','GahfG','rait','removeStat','drawTextEx','n_isForAll',';\x0a\x20\x20\x20\x20\x20\x20\x20\x20','oleDuratio','finalizeSc','setTroopPa','getNextDam','indowRectB','xtend:\x20x>\x20','VisuMZ_1_M','AMSey','oreEngine','DamageType','\x20\x20\x20\x20const\x20','uEgbL','\x20target.ge','ntNotetags','her','xAnimation','gainMp','rallelInte','AMuZU','setLastBat','_weather','measureTex','axIhZ','value','qyFoR','or_initMem','_drawTextO','perse','statusText','command119','uVEoJ','noise','eTvpY','eat','Targets','kCvgR','HiFKm','ActSeq_Hor','waitForJum','sGkid','YnIbx','Pre','displayCur','nstructor\x20','_effectsCo','ShowEnemyG','owPosition','_tempEquip','\x20ACTION','eOpacity','FaceAway','_FinishAct','chDuration','ions_addGe','AsOBP','context','CapRate','popupDamag','front\x20base','DistanceAd','weaponImag','jectile_Ic','DOroh','Sprite_Act','isPartyTpb','CNRFp','tionFrame','mSTB','ion_WaitMo','deadMember','usSprite','hue','cMzjn','processPos','RUKam','mXhWT','PLREp','EZnJN','rLayer','MultiTarge','aDTJV','ctAddNorma','_skillIDs','preter_upd','NextComman','setBattleP','ror_TVCrea','updateBitm','dFriend','RSImk','Enemy','jsCritRate','Wave','_offsetX','SkillItemB','hanics_Atb','lId','MIQsz','HelpFight','eld','MYbdT','hpDamageFm','CriticalHi','_activeWea','version\x20in','extDelay','ActiveChec','missle','buffAdd','tgeJM','merBitmap','AS\x20USER','TargetJS','attleJS','qAiJV','/\x20Declare\x20','damageRate','performMov','kLoad','isActiveTp','ET_X','startTurn','gzNsA','gwwwa','JS\x20%1START','_cancelBut','_PreBattle','BYLxD','cnlSU','_totalDama','textAlignm','GUARD','playTpDama','yijks','work\x20','scope','YRhxZ','KWOey','mationRequ','CfHUJ','art','checkShowH','callOkHand','ation','pages','clone','turnCount','_baseY','lateAttack','WLJXe','executeMpD','PklVb','eAnimation','ape','_floatDura','GguTV','round','traitTarge','lqVNt','growBattle','dead','BIgys','vnpSN','svAnchorX','HpGauge','text','neralOptio','ESHVF','updateInte','showNormal','PostApplyA','BrJuA','addExtende','playBattle','Parse_Note','otion','loonQueue','_baseTextu','lerContain','refreshBat','iTargetWin','ieOpS','skillTypes','_preemptiv','hitIndex','SkillsStat','3|2|1|7','exit','processAct','mOLAD','BattleGrid','CmOPr','RCrXa','sortDamage','e\x20plugin\x20l','eFlinch','acity','Skill-%1-%','_offsetY','y\x20Variable','isBorderSt','isBattleCo','_updateCli','NewPopupBo','wufXH','focus','DigitGroup','teIcon_upd','InputCance','HdQFA','LtjEP','WaitForZoo','select','jTMNe','eParallel','Index','%1-%2','COBWEB','le_stop','gRate','mationSpri','ntinr','w_DrawJS','riqJw','WmsaH','mDSpT','uiATM','okTargetSe','canMove','le_createP','itemEffect','CsIkA','\x20\x20\x20\x20\x20','bVOKf','\x27NaN\x20value','updateScal','HoXEz','ginCommand','pedBattlef','tAnimation','dSpDd','GExjN','or_updateS','fKepM','Style','tForNewLin','checkExten','mFANJ','checkScene','lPfOw','sVcWV','=\x20(this.co','isAnyoneFl','_duration','wKuxh','UdZrJ','siveStates','Menu','bility','StateOverl','totalDmgFm','or_updateB','isHiddenSk','-%1\x20MP','CCvyh','origin','nPortraitT','open','WaitForOpa','QCQjH','this.item(','ZMilH','indows','mation_Act','otetagEffe','battleGrow','isBreakStu','Balloon','iter','resh','ActSeq_Zoo','wdaEb','WhIeI','ateBattleF','SkillID','updateCall','_currentAc','setHue','er_startTp','DhzrF','Scene_Part','Letter','spell','onBattleSt','lValue;\x0a\x20\x20','Help','sYXMy','_performAc','displayRef','isFightCom','txrUq','_back1Spri','if\x20(isNaN(','CqxtV','leFieldBat','_targetOpa','\x20TURN','isATB','createActi','eMotion','vuoCQ','COBMV','OosHm','lxlQC','NEjbj','qpcnw','erSprite',')\x20console.','cYhMT','replace','apCkV','ionJS','SkillItemS','udilf','RecoverHp','Attack','ArPenRate','setHelpWin','VisuMZ_4_I','URwia','Battle_cre','Plugin\x20Man','r\x20Battle\x20S','ShowPortra','_effectDur','ge_smoothn','updatePhas','Sprite_Sta','message1','_flashDura','setEnemyWi','ureJS','parameters','isCurrentI','attlerKey','XiqlV','quLHi','_actorSpri','jYUTP','tWindow','ugQPE','\x20(Imported','_tpbNeedsP','FThyL','ngs','lebacks','w_RectJS','LastSelect','ger_update','startActio','WOlYG','temporaryV','tleLog_ref','eCBbD','tQQRG','waitCount','owScale','tTxsa','rPZKY','yle','Bdyzh','mbPIv','WfmyR','extBattleC','safes','nAnimation','startBattl','setBattler','processTou','of\x20VisuMZ_','ParseItemN','isHidden','_removeAct','DefaultHar','tCwGL','BravePoint','LorOZ','yHZJt','tags_Trait','Arguments\x0a','GMmKR','tusWindow','selectNext','eCore_PreB','BattleCore','ESCAPE','_performDa','mation_Bal','setY','displayAff','test','addImmorta','Collapse','isMeleeMul','ycKle','sitionable','StepDurati','parse','HynVO','JS\x20BATTLE\x20','pqLVq','bvTkc','freezeFram','svBattlerD','forActor','Gauge','EhWlm','\x20\x20\x20\x20if\x20($g','nEVZc','canGuard','_skewWhole','ILxZp','|\x200;\x0a\x20\x20\x20\x20\x20','NCVRv','setActiveW','ent','performCas','SwitchCrit','4783743PfvCmh','abXXJ','adjustWeap','mands','orEffect','BackColor','Nzsuq','lKnic','setupWeapo','BlTAo','setVisible','eCoreHitRa','MyQgG','isSceneBat','reserveCom','ndSelectio','\x20\x20\x20\x20\x20if\x20($','anchor','XyNxF','FSyJH','isNegative','OffsetX','minimumHit','_SetupActi','toVVt','mMessage','RKSwP','vxmwS','StyleOFF','drawEnemyN','\x20largest\x20t','xLisn','7|0|5|8|2|','removeBatt','tWidth','olo-%1-%2','initMember','_homeDurat','AttackAnim','hanics_Emu','bTurn','CqIoF','ection','tleVoice_P','_scene','kKZEa','damage','ytEkR','ActSeq_Cha','_angleWhol','LZXOR','lUFXG','qbLZk','loadBattle','CommandSho','battleSpin','CreateCuti','wXyxC','startTpbTu','aleBorderS','or_update','Game_Party','OffsetAdju','hjbRh','m_Scale','ctorComman','\x20this.item','_actorComm','processDef','svShadow','RrAjp','ActSeq_Mec','onJumpEnd','State','ideSwitchN','mGwbs','erBase_can','tleLayout','RoAYb','maxBattleM','tleActor_p','IHrtl','SqYNc','\x20===\x20Game_','lebackBitm','setCommonE','setAttack','WaitForAng','onJS','spinBattle','VisuMZ_1_S','ttom','resetResul','deselect','utIndex','ost','led','Line','ItemID','battleAngl','QxkiH','isDuringNo','_battleFie','ListAutoAt','gwluC','alValue));','setHorrorE','CGCOG','alignBattl','swing','updateCust','alive\x20enem','qWhXp','displaySub','XKdTw','notFocusVa','time','vydEN','dex','ZtpSH','erseDamage','AQAni','attlerOnTo','vCwHx','onRegenera','JS\x20ESCAPE\x20','magicSkill','ARRAYSTRUC','actor%1-po','weapons','ment_AddEl','FkeFd','QpQSw','zYDyf','positionOf','gonbonesAn','gainStored','qsSTL','RvvBs','JLYYv','PjuPT','isGuard','ceivl','hqKPc','FdVLg','okButtonTe','nemies','stypeId','Spriteset_','HkGmE','FuSVK','eVreB','tePlayStat','onEnemyCan','isAtbCharg','createCont','JS\x20%1DAMAG','_jumpMaxHe','daqWk','umFDD','ActSeq_Wea','st\x20action\x20','expRate','qgLts','ntChanges','RFiGB','MWXXU','n_executeM','ShowHpDmg','PostStartT','ailData','ionEffect','YhUec','ActSeq_Tar','TargetNode','equips','ARRAYSTR','eBattleTra','DJher','nCdVH','RHgcU','j))\x20{\x0a\x20\x20\x20\x20','ageAmountT','length','_immortal','er_clearDa','isChanging','kAAre','1|3|2|0|4','Core','drawGauge','ext','ParallelIn','ement_Spin','n_isForOne','getLastHpD','isibleDura','_jumpDurat','lateSkillC','ight','YRCXk','QToEw','IconStypeM','TpbGaugeOf','MRZbK','reak','isCertainH','%1JS','wJKFY','ger_onEsca','dragonbone','rocessTouc','bReady','isualCutin','eCore','GoEMr','animationW','isTpbCharg','rtOnFinish','MUSIC\x20NOTE','isDisplayE','ect_WaitFo','alYDM','Command','mping','Action)\x20?\x20','skillWindo','startShake','xXKZa','ctors','gets','HmHNi','FlinchDist','eCoreData','aiTxs','TJQkt','iaLSv','HLudU','drawSkillC','lmNCz','lare\x20Const','isSkillIte','QUESTION','die','Filename','PzJfm','3FriwJk','updateMain','2|4|30|9|2','BgType','DhNFv','frameCount','yCPYv','geFormula','selectAllA','createEffe','WaitForMov','setupMotio','svxEt','loadSvEnem','UYnfr','_wtypeIDs','adjustFlip','wtypeId','tyCommand_','freezeMoti','e)\x20{\x0a\x20\x20\x20\x20\x20','SvBattlerM','eCoreCriti','floor','rtEvent','isForRando','CastPhysic','jRdwb','inputting','eJS','increaseTo','ParseActor','WithFlags','clearOnceP','nter','leSwitchNo','tAction();','backColor','rtrait','TjuXv','requestRef','Battleback','lMsg2','Targets1','processFor','unZkF','tEvent','Lqukm','BaseLine','JS\x20%1END\x20A','getBattleP','eBattleSta','amageCap','era_Clamp','_targets','rget;\x0a\x20\x20\x20\x20','jgRQy','kHhpp','uments[1];','olHeB','dead\x20battl','addLoadLis','ment_Clear','createActo','_executedV','pMembers','jsScaleDow','jIwMB','10FMNITp','SLUbB','tomActionS','ntBackOffs','feSteal','ectJS','svActorHor','attackSkil','rpfBs','TP_Rate','pop','XdfrH','owVisibili','IqRGv','hgYUR','use\x20the\x20<E','opups','updateWeat','onSequence','MotionFram','compareBat','_dimmerSpr','visibility','fAqwQ','koWGL','ltmOj','3551163msDTIw','nufPo','setupRgbSp','getDualWie','const\x20a\x20=\x20','ion','YvBeA','cqGVe','{\x0a\x20\x20\x20\x20\x20\x20\x20\x20','portraitFi','suVsb','dden','n_updateLa','gOKrs','reduce','tory','Node','UxJvE','ject','toUpperCas','physical','zVqzQ','justPositi','AllowColla','GLSVF','dFromUiCon','NjZkf','ccess','tyiMj','BQJBQ','TLVbq','pmhmq','Container','mNAqM','applyTarge','prepare','qAKVX','counterAtt','updateVisi','mYfRu','Exit','LSNWr','addWindow','ger_inputt','1|5|7|9|2','ageXPStyle','FaceDirect','ayOffsetX','ving','LcIPo','7|0|6','ePAPa','WaitCount2','bkChC','===\x20Game_A','EuZvm','bykDt','paySkillCo','ntKey','GvelY','ED\x205','artBattleC','tMembers','yNames','QYFXf','vBattler','selectedBa','walk','CriticalCo','setCursorR','changeWeat','flGjg','OweTd','switchToWe','isSTB','iner','tandardCol','\x20to\x20%2\x27.fo','frontviewS','CTYcJ','drawItemIm','meetsSelec','nable','_customDam','loop','_additiona','llFUt','ainPhase','ate','EPUrp','yiqmi','rollYinver','tionSequen','updateBoss','isDeathSta','applyData','reezeFrame','attleback2','SceneBattl','position','left','_list','waitForMov','wBackgroun','bles\x0a\x20\x20\x20\x20\x20','ingAction','makeSucces','testApply','2|4|0|5|3|','yovTl','GoxfJ','performMis','CriticalDm','ion_ComboW','leJS','placeGauge','CombatLogI','tags','nPlaying','ments','n_clear','changeAtbC','Flip','lor','mpDamage','etcKE','artOncePar','shouldDisp','anchorX','pdaYs','veOncePara','ActorCondi','GAUhf','_text','eApplied','keFlinch','Friend','gRHnT','inBattle','EAsBz','uaBeQ','EnableDama','useDigitGr','lMsg1','tDhEH','createPart','DamageDisp','AnfoV','mPTB','mmp','its','llback','lementStat','owSkinFile','dGameTroop','n.\x0aPlease\x20','isChanting','t\x20defender','\x20\x20\x20\x20\x20\x20\x20\x20//','owRectXPSt','Item-%1-%2','formDamage','xYDPK','lVariables','fGmuk','performSTB','rance','oited','command283','TPkoJ','nJS','CaDRC','addPartyCo','eredName','in_EndVisu','ARDKw','qiudq','Voice','icons','_equips','ion_ClearF','erpreters','clearTarge','updateSkew','\x20\x20\x20\x20\x20\x20\x20\x20if','cwTvX','1:1','oundRect','ies\x20not\x20ta','PWrPC','svActor','zstul','CArfn','AOzvX','ger_makeDa','processRan','LdirJ','tpbActorSw','er_makeSpe','attleAI\x20ne','DTHXw','frameVisib','damageStyl','TMlCe','addAutoBat','XbVaX','LKvMB','tScaler','FollowTurn','Rect','jectFromPo','BaseTroopI','_growEasin','isPlaytest','()\x20:\x20obj;\x0a','HEART','YjavF','YbUSO','IootC','ctAddAttac','parallaxSc','BARE\x20HANDS','_growDurat','AbNvP','syBda','hTYit','nchorX','formMiss','changeCtbC','findSymbol','PreEndTurn','updateShak','setupBlueR','_Action)\x20?','onst\x20skill','targetDist','esCore','command301','increaseHi','rns','attleCommo','actorComma','isBorderPo','anceX','DamageStyl','battleAnim','NCAnV','loadBitmap','ZOkXg','updateCanc','_iconIndex','XmUHH','originalRa','_targetFlo','List','_tempBattl','NameOffset','RAbaR','etsJS','performSha','Odgjs','lect','kMpER','applySoftD','noFpU','CheckActSe','QoCwb','iginalRate','HelpSkillT','ConvertAct','lectionVal','t\x20version\x20','move','_cursorSpr','PrXHp','HudFN','ZwwHS','NameDamage','htHXi','lData','AxpaT','contents','nst\x20attack','BQnei','StyleON','OzOkU','addCombatL','FmYPo','_executeHp','lqpkZ','\x20Create\x20Co','message2','CheckMapBa','itemHeight','portrait','default','ActSeqProj','clearDamag','maxCols','angleDurat','\x20\x20\x20\x20\x20\x20let\x20','Scene_Quic','PjbcF','luQHJ','\x20\x20\x20\x20\x20\x20\x20\x20\x20%','dEnemies','VICTORY','powav','Window_Act','sAbort','drain','tateResist','lOknG','Base_apply','d_Teleport','jZWYb','battlerSpr','onSkewEnd','guardSkill','PopupShift','onAngleEnd','isTurnBase','Tgasx','applyBattl','EMCsD','CommandAdd','_padding','NcAiX','isAnyoneCh','ParseEnemy','\x20\x20\x20\x20\x20\x20//\x20P','zezgc','Combo\x5c{','jRyjB','vvKbb','maxLines','MDF','kew','parseLocal','StartTurnS','ingDamageS','icEvasion','geCounterW','vemUs','waitForAni','sExxS','NrFSM','CriticalDu','Reposition','5|4|3','PartyCmd','MxKIC','svBattlerA','ET_Y','QGFFd','xHDVk','createJS','_actions','_target','erStyle','attackAnim','AOKKS','tleUI','AllBattleC','nds\x20not\x20ta','isClicked','isPrevious','ger_onEnco','_buttonKey','entBattleC','pupRequest','jJEjt','tQUJh','onent','start','isSpriteVi','act_BlueRe','tATWr','hasSkill','plyBattleC','leCommandE','mjjfY','ForMovemen','resizeWind','isItem','changeInpu','_windowLay','Destinatio','imation','isTeamBase','4|3|2|0|1','leCheck','itemLifeSt','lers','FocusX','_floatWhol','eMKqF','NbRLj','TcFXU','alue\x20=\x20val','ssiveState','torSelecti','Kjnow','zfZnf','PknGt','urateImpac','clearBattl','nNotetags','JS\x20%1APPLY','\x20\x20\x20\x20\x20\x20\x20if\x20','rame','updateHome','er\x20=\x20user;','evalDamage','svAnchorY','.currentAc','FrontViewS','eCore_jsFu','ngeAngle','pJLZk','sLWis','mPElv','ExeFt','UhMyQ','adjustPosi','EscapeFail','EhhQt','ffsetX','orderCols','_enemySpri','terpreter','uHJtN','zPIBN','er_onTurnE','Sprite_SvE','5|1|0|2|4|','eGTCc','ISnXg','HDofy','+%1\x20MP','VbWIV','setStateTu','refreshCur','constructo','_subject','itmap','_active','tone','ies',']+%1','leBalloon','filters','isTpbReady','isForDeadF','ptOhD','WaitForEnt',')\x20?\x20this.i','GgaBe','HelpEscape','ngedBuffs','MpGaugeOff','fadeShiftY','RequiresDe','PqOoW','llRect','oGCXZ','Options','le_updateB','andIcon','\x20\x20\x20\x20\x20\x20\x20let','\x5cC[4]Heal\x20','torCommand','_tpbState','lnBCy','KgXeq','alive\x20batt','totalHealF','nds\x20not\x20us','_battlerCo','Dzvpr','eId','pattern','updateRefr','LAXMZ','qWimG','xJYCg','usWindowAn','eCore_Comm','xZMjn','nxwiR','4|3|8|5|0|','gameTemp.i','n_setSubje','user','lue\x20=\x20orig','skillItemW','n_isForDea'];_0x84f8=function(){return _0x54006;};return _0x84f8();}function Window_AutoBattleCancel(){this['initialize'](...arguments);}Window_AutoBattleCancel[_0xe90fac(0x510)]=Object['create'](Window_Base[_0xe90fac(0x510)]),Window_AutoBattleCancel[_0xe90fac(0x510)]['constructo'+'r']=Window_AutoBattleCancel,Window_AutoBattleCancel[_0xe90fac(0x510)]['initialize']=function(_0x71c9eb){const _0x1957c1=_0xe90fac;Window_Base[_0x1957c1(0x510)][_0x1957c1(0xc68)][_0x1957c1(0x351)](this,_0x71c9eb),this[_0x1957c1(0x54c)+_0x1957c1(0x2f4)](this['bgType']()),this[_0x1957c1(0x944)]();},Window_AutoBattleCancel[_0xe90fac(0x510)][_0xe90fac(0xf83)]=function(){const _0x1bdd4b=_0xe90fac;return VisuMZ['BattleCore'][_0x1bdd4b(0x281)][_0x1bdd4b(0x33a)][_0x1bdd4b(0x33a)+_0x1bdd4b(0x12aa)];},Window_AutoBattleCancel[_0xe90fac(0x510)]['refresh']=function(){const _0x11f1c4=_0xe90fac,_0x55d1f7={'DtGSw':function(_0x3b64d5,_0x578d57){return _0x3b64d5/_0x578d57;},'ZMilH':function(_0x184d7e,_0xb9e6d0){return _0x184d7e-_0xb9e6d0;}};this[_0x11f1c4(0x141e)][_0x11f1c4(0xf98)]();const _0x3fc931=VisuMZ[_0x11f1c4(0x118f)][_0x11f1c4(0x281)]['AutoBattle']['AutoBattle'+'Msg'],_0x286b03=_0x3fc931['format'](this[_0x11f1c4(0x1242)+'xt'](),this[_0x11f1c4(0x3a7)+_0x11f1c4(0xfd1)]()),_0x549727=this[_0x11f1c4(0x2a1)](_0x286b03)[_0x11f1c4(0x301)],_0x3ccc8=Math[_0x11f1c4(0x12be)](_0x55d1f7['DtGSw'](_0x55d1f7[_0x11f1c4(0x1114)](this['innerWidth'],_0x549727),0x1b7*-0x16+0x643+0x47f*0x7));this[_0x11f1c4(0x1002)](_0x286b03,_0x3ccc8,-0x757*-0x3+-0x27*0x15+-0x12d2,_0x549727);},Window_AutoBattleCancel['prototype'][_0xe90fac(0x1242)+'xt']=function(){const _0xfb25c8=_0xe90fac;return Imported['VisuMZ_0_C'+_0xfb25c8(0x100d)]?TextManager[_0xfb25c8(0x7b9)+_0xfb25c8(0x479)]('ok'):VisuMZ['BattleCore'][_0xfb25c8(0x281)][_0xfb25c8(0x33a)][_0xfb25c8(0x33a)+'OK'];},Window_AutoBattleCancel[_0xe90fac(0x510)][_0xe90fac(0x3a7)+_0xe90fac(0xfd1)]=function(){const _0x5379dc=_0xe90fac,_0x392bf0={'hMEIN':_0x5379dc(0x505)};return Imported[_0x5379dc(0x155e)+_0x5379dc(0x100d)]?TextManager[_0x5379dc(0x7b9)+_0x5379dc(0x479)](_0x392bf0['hMEIN']):VisuMZ[_0x5379dc(0x118f)]['Settings'][_0x5379dc(0x33a)][_0x5379dc(0x33a)+_0x5379dc(0xb81)];},Window_AutoBattleCancel[_0xe90fac(0x510)][_0xe90fac(0x94)]=function(){const _0x16b238=_0xe90fac;Window_Base['prototype'][_0x16b238(0x94)]['call'](this),this['updateVisi'+'bility'](),this[_0x16b238(0x13fe)+'el']();},Window_AutoBattleCancel['prototype'][_0xe90fac(0x132b)+'bility']=function(){this['visible']=BattleManager['_autoBattl'+'e'];},Window_AutoBattleCancel[_0xe90fac(0x510)]['updateCanc'+'el']=function(){const _0x2bc442=_0xe90fac,_0x17f3b9={'oMFES':_0x2bc442(0x505)};if(!BattleManager[_0x2bc442(0xcf9)+'e'])return;(Input['isTriggere'+'d']('ok')||Input[_0x2bc442(0x1535)+'d'](_0x17f3b9['oMFES'])||TouchInput[_0x2bc442(0x1472)]()||TouchInput[_0x2bc442(0x464)+'d']())&&(SoundManager[_0x2bc442(0x687)](),BattleManager[_0x2bc442(0xcf9)+'e']=![],Input[_0x2bc442(0xf98)](),TouchInput[_0x2bc442(0xf98)]());};function Window_EnemyName(){const _0x5d3a97=_0xe90fac;this[_0x5d3a97(0xc68)](...arguments);}Window_EnemyName[_0xe90fac(0x510)]=Object[_0xe90fac(0xc3d)](Window_StatusBase[_0xe90fac(0x510)]),Window_EnemyName['prototype'][_0xe90fac(0x14c0)+'r']=Window_EnemyName,Window_EnemyName[_0xe90fac(0x510)][_0xe90fac(0xc68)]=function(_0xd22986){const _0x529be=_0xe90fac,_0x54df7c={'RrAjp':function(_0x1706fe,_0x5d04d1){return _0x1706fe*_0x5d04d1;}};this[_0x529be(0x7a6)]=_0xd22986,this[_0x529be(0x138a)]='';const _0xe58c28=new Rectangle(0x111d+0x1873+-0x7*0x5f0,-0x7e3+-0x116*-0x1d+-0x1*0x179b,Graphics[_0x529be(0x3dc)],_0x54df7c[_0x529be(0x11f7)](this[_0x529be(0xf4b)](),0x3*-0x7cd+0x1c41+-0x4d6));Window_StatusBase['prototype'][_0x529be(0xc68)][_0x529be(0x351)](this,_0xe58c28),this[_0x529be(0x54c)+_0x529be(0x2f4)](0x605*0x1+-0x1*0xa7b+0x478),this[_0x529be(0xabb)+_0x529be(0x10c9)]=-0x107f*0x2+-0x2596*-0x1+0x18*-0x31;},Window_EnemyName[_0xe90fac(0x510)]['updatePadd'+_0xe90fac(0x312)]=function(){this['padding']=-0x1*0x805+-0x1eba+0x26bf;},Window_EnemyName['prototype'][_0xe90fac(0x70d)]=function(){const _0x302620=_0xe90fac;return $gameTroop[_0x302620(0xe13)]()[this[_0x302620(0x7a6)]];},Window_EnemyName[_0xe90fac(0x510)]['update']=function(){const _0x70df62=_0xe90fac,_0x510386={'DhzrF':function(_0x26e978,_0x404a11){return _0x26e978!==_0x404a11;}};Window_StatusBase['prototype']['update'][_0x70df62(0x351)](this),this[_0x70df62(0x70d)]()&&_0x510386[_0x70df62(0x1126)](this[_0x70df62(0x70d)]()[_0x70df62(0x14c)](),this[_0x70df62(0x138a)])&&(this[_0x70df62(0x138a)]=this[_0x70df62(0x70d)]()[_0x70df62(0x14c)](),this['refresh']()),this[_0x70df62(0xbde)+_0x70df62(0x798)](),this[_0x70df62(0xe9f)+_0x70df62(0x1580)]();},Window_EnemyName['prototype'][_0xe90fac(0xbde)+'ity']=function(){const _0x297d76=_0xe90fac,_0x5a05ed={'jvdsh':function(_0x48b0c1,_0x47c323){return _0x48b0c1>_0x47c323;},'FxrSd':function(_0x123ff2,_0x4f2bc9){return _0x123ff2>_0x4f2bc9;},'QxkiH':function(_0x47fc7f,_0x5f0444){return _0x47fc7f<_0x5f0444;}};if(!this[_0x297d76(0x70d)]()){if(_0x5a05ed[_0x297d76(0xede)](this[_0x297d76(0xabb)+_0x297d76(0x10c9)],-0x10f6+-0x1f19+0x300f))this[_0x297d76(0xabb)+_0x297d76(0x10c9)]-=-0x165d+0x1072+0x5fb;}else{if(this[_0x297d76(0x70d)]()[_0x297d76(0x17d)]()){if(_0x5a05ed['FxrSd'](this[_0x297d76(0xabb)+_0x297d76(0x10c9)],0x1a8e+-0x1f7*0xf+0x2eb))this[_0x297d76(0xabb)+_0x297d76(0x10c9)]-=-0x664+0xf71*0x1+0x1*-0x8fd;}else{if(SceneManager['_scene'][_0x297d76(0x356)+'ow']&&SceneManager[_0x297d76(0x11dd)][_0x297d76(0x356)+'ow']['active']&&SceneManager[_0x297d76(0x11dd)][_0x297d76(0x356)+'ow']['_enemies']['includes'](this[_0x297d76(0x70d)]())){if(_0x5a05ed[_0x297d76(0x1215)](this['contentsOp'+_0x297d76(0x10c9)],-0xb82+-0xcde+0x5*0x513))this[_0x297d76(0xabb)+_0x297d76(0x10c9)]+=-0xdfd*-0x1+0x1655+0x222*-0x11;}else _0x5a05ed['jvdsh'](this[_0x297d76(0xabb)+_0x297d76(0x10c9)],0x3*-0xac3+-0x55*0x6e+0x44cf*0x1)&&(this[_0x297d76(0xabb)+_0x297d76(0x10c9)]-=-0x1765*0x1+-0x319*0x4+0x45*0x85);}}},Window_EnemyName[_0xe90fac(0x510)][_0xe90fac(0xe9f)+_0xe90fac(0x1580)]=function(){const _0x4d343c=_0xe90fac,_0x538d45={'VCrDH':function(_0x276439,_0x392c6a){return _0x276439-_0x392c6a;},'LQedj':function(_0x393c09,_0x18a174){return _0x393c09/_0x18a174;},'JkRoR':function(_0x19125d,_0x10e514){return _0x19125d-_0x10e514;},'XXWYg':function(_0x209fc8,_0x4b44b){return _0x209fc8*_0x4b44b;}};if(!this['enemy']())return;SceneManager[_0x4d343c(0x333)+'ipped']()?this['x']=_0x538d45[_0x4d343c(0xdbd)](Graphics[_0x4d343c(0x3dc)],this['enemy']()['battler']()[_0x4d343c(0x156)]):this['x']=this[_0x4d343c(0x70d)]()[_0x4d343c(0x81d)]()['_baseX'];this['x']-=Math[_0x4d343c(0x10a1)](_0x538d45[_0x4d343c(0xb04)](this[_0x4d343c(0x301)],0x1460+0x6f5+-0x1b53)),this['y']=_0x538d45[_0x4d343c(0xc5b)](this[_0x4d343c(0x70d)]()['battler']()['_baseY'],Math[_0x4d343c(0x10a1)](_0x538d45[_0x4d343c(0x1536)](this['lineHeight'](),-0x217d+0x219b+-0x1d*0x1+0.5)));const _0x371733=VisuMZ[_0x4d343c(0x118f)][_0x4d343c(0x281)]['Enemy'];this['x']+=_0x371733[_0x4d343c(0x1405)+'X']||0xb0c+-0x2217*-0x1+-0x2d23,this['y']+=_0x371733[_0x4d343c(0x1405)+'Y']||-0xdc*-0x25+0x1c0a+-0x14d*0x2e;},Window_EnemyName['prototype']['resetFontS'+'ettings']=function(){const _0x29fada=_0xe90fac;Window_Base['prototype'][_0x29fada(0x160c)+_0x29fada(0x29c)][_0x29fada(0x351)](this),this[_0x29fada(0x141e)][_0x29fada(0xe10)]=VisuMZ[_0x29fada(0x118f)]['Settings'][_0x29fada(0x105f)]['NameFontSi'+'ze'];},Window_EnemyName['prototype'][_0xe90fac(0x944)]=function(){const _0x4f4e52=_0xe90fac;Window_StatusBase['prototype'][_0x4f4e52(0x944)][_0x4f4e52(0x351)](this),this[_0x4f4e52(0x141e)][_0x4f4e52(0xf98)]();if(!this[_0x4f4e52(0x70d)]())return;this[_0x4f4e52(0x11ce)+_0x4f4e52(0xd7d)]();},Window_EnemyName[_0xe90fac(0x510)][_0xe90fac(0x11ce)+_0xe90fac(0xd7d)]=function(){const _0x5998c2=_0xe90fac,_0x4df50f={'Jlpjb':function(_0xf789ed,_0x241e7c){return _0xf789ed/_0x241e7c;},'DFnhI':function(_0x36f2e1,_0x5ed1d9){return _0x36f2e1-_0x5ed1d9;},'OadgX':function(_0xaa117b,_0x28ed9b){return _0xaa117b+_0x28ed9b;}};this[_0x5998c2(0x138a)]=this[_0x5998c2(0x70d)]()[_0x5998c2(0x14c)]();const _0x536c46=this[_0x5998c2(0x2a1)](this[_0x5998c2(0x138a)])['width'],_0x401b4a=Math[_0x5998c2(0x10a1)](_0x4df50f['Jlpjb'](_0x4df50f[_0x5998c2(0x5ba)](this['innerWidth'],_0x536c46),-0x25*0x48+0x53c+0x52e));this[_0x5998c2(0x1002)](this['_text'],_0x401b4a,0x55d*0x1+-0x5*0x343+0xaf2,_0x4df50f[_0x5998c2(0x5e5)](_0x536c46,-0x35*0xbc+-0x2*-0xf09+0x8e2));},Window_BattleLog['prototype'][_0xe90fac(0x1454)]=function(){const _0x52701e=_0xe90fac;return VisuMZ[_0x52701e(0x118f)]['Settings'][_0x52701e(0xa22)][_0x52701e(0x1511)];},Window_BattleLog[_0xe90fac(0x510)]['messageSpe'+'ed']=function(){const _0x4db109=_0xe90fac;return VisuMZ[_0x4db109(0x118f)][_0x4db109(0x281)][_0x4db109(0xa22)][_0x4db109(0xdd6)+'t'];},Window_BattleLog['prototype'][_0xe90fac(0x12cc)]=function(){const _0x5033a5=_0xe90fac;return VisuMZ[_0x5033a5(0x118f)][_0x5033a5(0x281)]['BattleLog'][_0x5033a5(0x11b6)];},Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x99b)+_0xe90fac(0x7ef)]=function(){return![];},Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x679)+'ct']=function(_0x181ef4,_0x44ca60){const _0x8d4ce1=_0xe90fac,_0x3f6287={'ZfOtt':_0x8d4ce1(0x8cf)+_0x8d4ce1(0x58d)};this[_0x8d4ce1(0xf78)](_0x3f6287[_0x8d4ce1(0xfe8)]),BattleManager[_0x8d4ce1(0xdb4)+'on'](_0x181ef4,_0x44ca60),this[_0x8d4ce1(0x514)+_0x8d4ce1(0x6da)]();},Window_BattleLog[_0xe90fac(0x510)]['emulateAct'+_0xe90fac(0x125c)]=function(_0x4e076a,_0x56b9ec,_0x29379f){const _0x28a755=_0xe90fac,_0x194f2e={'BAwZF':_0x28a755(0x8cf)+_0x28a755(0x58d)};this[_0x28a755(0xf78)](_0x194f2e['BAwZF']),BattleManager[_0x28a755(0x849)+'ion'](_0x4e076a,_0x56b9ec,_0x29379f),this[_0x28a755(0x514)+'thod']();},Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x8cf)+_0xe90fac(0x58d)]=function(){const _0x347fe8=_0xe90fac;this[_0x347fe8(0x514)+_0x347fe8(0x6da)]();},Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x15f1)]=function(_0x2db32c){const _0x1db335=_0xe90fac,_0x45728f={'iHrwb':_0x1db335(0x8cf)+_0x1db335(0x58d),'BFVpW':function(_0x35cc90,_0xf2d9ca){return _0x35cc90>=_0xf2d9ca;}},_0x1cc7ba=Array['prototype'][_0x1db335(0x77f)]['call'](arguments,-0x1*0x10e8+-0x1b29+0x2c12),_0x3e39c1={'name':_0x2db32c,'params':_0x1cc7ba},_0x32e4fa=this[_0x1db335(0x3c5)][_0x1db335(0x457)](_0x2424ed=>_0x2424ed['name'])[_0x1db335(0x741)](_0x45728f[_0x1db335(0x33b)]);_0x45728f['BFVpW'](_0x32e4fa,0x21ae+0x697+-0x1*0x2845)?this[_0x1db335(0x3c5)][_0x1db335(0xba7)](_0x32e4fa,0x17eb+0x2345+-0x3b30,_0x3e39c1):this[_0x1db335(0x3c5)][_0x1db335(0x15f1)](_0x3e39c1);},Window_BattleLog['prototype'][_0xe90fac(0xf78)]=function(_0x54be60){const _0x56664b=_0xe90fac,_0x1dd6f8=Array[_0x56664b(0x510)][_0x56664b(0x77f)]['call'](arguments,-0x1e97*-0x1+0x5d9+0x3*-0xc25);this[_0x56664b(0x3c5)][_0x56664b(0xf78)]({'name':_0x54be60,'params':_0x1dd6f8});},Window_BattleLog[_0xe90fac(0x510)]['logActionL'+'ist']=function(){const _0xf39b83=_0xe90fac;if(!$gameTemp['isPlaytest']())return;console[_0xf39b83(0xad3)](this[_0xf39b83(0x3c5)][_0xf39b83(0x457)](_0x58a26e=>_0x58a26e[_0xf39b83(0x14c)])['join']('\x0a'));},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x8a0)+_0xe90fac(0x116f)+'resh']=Window_BattleLog['prototype'][_0xe90fac(0x944)],Window_BattleLog['prototype'][_0xe90fac(0x944)]=function(){const _0x526d88=_0xe90fac;this['_requestRe'+_0x526d88(0x75e)]=!![];},VisuMZ[_0xe90fac(0x118f)]['Window_Bat'+'tleLog_upd'+_0xe90fac(0x135d)]=Window_BattleLog['prototype'][_0xe90fac(0x94)],Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x94)]=function(){const _0x153c05=_0xe90fac;VisuMZ[_0x153c05(0x118f)][_0x153c05(0x8a0)+'tleLog_upd'+_0x153c05(0x135d)][_0x153c05(0x351)](this);if(this['_requestRe'+'fresh'])this[_0x153c05(0xa42)+_0x153c05(0x111c)]();},Window_BattleLog['prototype']['processRef'+_0xe90fac(0x111c)]=function(){const _0x834190=_0xe90fac;this[_0x834190(0xe5)+_0x834190(0x75e)]=![],VisuMZ['BattleCore']['Window_Bat'+'tleLog_ref'+_0x834190(0x111c)]['call'](this);},Window_BattleLog['prototype'][_0xe90fac(0x893)+'xt']=function(_0x4c48f7){const _0x2d5065=_0xe90fac,_0x3a31c8={'qJyxN':_0x2d5065(0x1369),'AMqlJ':_0x2d5065(0x8dd),'iHbrq':'right','LGZLu':function(_0x2d68f0,_0x5d4337){return _0x2d68f0===_0x5d4337;},'pJLZk':function(_0x17521a,_0x542dab){return _0x17521a/_0x542dab;},'ThiId':function(_0xd8b5a5,_0x19b5fc){return _0xd8b5a5-_0x19b5fc;},'gGIik':function(_0x4c1975,_0x109ec1){return _0x4c1975-_0x109ec1;},'ZtBOo':function(_0x1b93a0,_0x2c907a){return _0x1b93a0+_0x2c907a;}};let _0x174e85=VisuMZ[_0x2d5065(0x118f)]['Settings'][_0x2d5065(0xa22)][_0x2d5065(0xd6)][_0x2d5065(0x371)+'e']()[_0x2d5065(0x808)](),_0x2aa084=this[_0x2d5065(0x7c9)][_0x4c48f7];if(_0x2aa084[_0x2d5065(0x3eb)](/<LEFT>/i))_0x174e85=_0x3a31c8['qJyxN'];else{if(_0x2aa084[_0x2d5065(0x3eb)](/<CENTER>/i))_0x174e85=_0x3a31c8[_0x2d5065(0x8a6)];else _0x2aa084[_0x2d5065(0x3eb)](/<RIGHT>/i)&&(_0x174e85=_0x3a31c8['iHbrq']);}_0x2aa084=_0x2aa084[_0x2d5065(0x1144)](/<(?:LEFT|CENTER|RIGHT)>/gi,''),_0x2aa084=_0x2aa084[_0x2d5065(0x1144)](/\\I\[0\]/gi,'');const _0x95d366=this[_0x2d5065(0x802)](_0x4c48f7);this[_0x2d5065(0x141e)][_0x2d5065(0xc99)](_0x95d366['x'],_0x95d366['y'],_0x95d366['width'],_0x95d366['height']);const _0x2e2fb2=this[_0x2d5065(0x2a1)](_0x2aa084)[_0x2d5065(0x301)];let _0x48b93d=_0x95d366['x'];if(_0x3a31c8[_0x2d5065(0xa9)](_0x174e85,_0x3a31c8[_0x2d5065(0x8a6)]))_0x48b93d+=_0x3a31c8[_0x2d5065(0x14a8)](_0x3a31c8[_0x2d5065(0x1568)](_0x95d366['width'],_0x2e2fb2),0x4*0x7cf+-0x2*0x4df+-0x157c);else _0x3a31c8[_0x2d5065(0xa9)](_0x174e85,_0x3a31c8[_0x2d5065(0xd61)])&&(_0x48b93d+=_0x3a31c8[_0x2d5065(0xfbc)](_0x95d366['width'],_0x2e2fb2));this[_0x2d5065(0x1002)](_0x2aa084,_0x48b93d,_0x95d366['y'],_0x3a31c8['ZtBOo'](_0x2e2fb2,0x7*0x6b+-0x10e5+0xe00*0x1));},Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0xf33)]=function(_0x31570f){const _0xe2aa1=_0xe90fac;this[_0xe2aa1(0x7c9)][_0xe2aa1(0x15f1)](_0x31570f),this[_0xe2aa1(0x944)](),this[_0xe2aa1(0x514)+_0xe2aa1(0x6da)]();},Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0xde3)+_0xe90fac(0x39f)]=function(){const _0x55b76e=_0xe90fac,_0x434ffd={'NCJwh':_0x55b76e(0xd38),'Odgjs':_0x55b76e(0x713),'Qawbo':_0x55b76e(0x7c1),'DIZCz':_0x55b76e(0x88a),'UfsxJ':_0x55b76e(0x946),'eZBtU':'opacity'};let _0x15c19f=![];switch(this[_0x55b76e(0xb87)]){case _0x434ffd[_0x55b76e(0x5c9)]:_0x15c19f=this[_0x55b76e(0x981)][_0x55b76e(0xca5)+'g']();break;case _0x434ffd[_0x55b76e(0x1409)]:_0x15c19f=this[_0x55b76e(0x981)][_0x55b76e(0xde6)+_0x55b76e(0x1335)]();break;case _0x434ffd[_0x55b76e(0x82a)]:_0x15c19f=this['_spriteset'][_0x55b76e(0xfaa)+_0x55b76e(0x137b)]();break;case _0x434ffd[_0x55b76e(0x807)]:_0x15c19f=this['_spriteset'][_0x55b76e(0x1101)+_0x55b76e(0x774)]();break;case _0x434ffd[_0x55b76e(0xb4b)]:_0x15c19f=this[_0x55b76e(0x981)][_0x55b76e(0x917)+_0x55b76e(0x1291)]();break;case _0x434ffd['eZBtU']:_0x15c19f=this[_0x55b76e(0x981)][_0x55b76e(0x144d)+_0x55b76e(0x3bc)+_0x55b76e(0x798)]();break;}return!_0x15c19f&&(this[_0x55b76e(0xb87)]=''),_0x15c19f;},Window_BattleLog['prototype'][_0xe90fac(0x145d)+_0xe90fac(0xb0d)]=function(){const _0x543f82=_0xe90fac,_0x2b29b9={'PztXt':_0x543f82(0x7c1)};this[_0x543f82(0xdaa)+'e'](_0x2b29b9['PztXt']);},Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0xcfb)+'at']=function(){const _0x4093ed=_0xe90fac,_0x3fbf1a={'LBnsO':'float'};this[_0x4093ed(0xdaa)+'e'](_0x3fbf1a['LBnsO']);},Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x102b)+'p']=function(){const _0x548c8e=_0xe90fac,_0x38ef81={'OWZHY':_0x548c8e(0x946)};this[_0x548c8e(0xdaa)+'e'](_0x38ef81['OWZHY']);},Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x6f2)+_0xe90fac(0x442)]=function(){const _0x115c9d=_0xe90fac,_0xda4070={'jTIvj':_0x115c9d(0xfac)};this[_0x115c9d(0xdaa)+'e'](_0xda4070[_0x115c9d(0xe54)]);},Window_BattleLog['prototype']['startTurn']=function(){const _0x4c13fb=_0xe90fac,_0x14e442={'XiqlV':_0x4c13fb(0xf33),'IIMbk':_0x4c13fb(0x1172),'mhxjO':'clear'},_0x1ac369=VisuMZ[_0x4c13fb(0x118f)][_0x4c13fb(0x281)][_0x4c13fb(0xa22)];if(!_0x1ac369[_0x4c13fb(0x1458)+'how'])return;this[_0x4c13fb(0x15f1)](_0x14e442[_0x4c13fb(0x115e)],_0x1ac369[_0x4c13fb(0xd29)+'sg'][_0x4c13fb(0xeb8)]($gameTroop[_0x4c13fb(0x1097)]())),this[_0x4c13fb(0x15f1)](_0x14e442['IIMbk'],_0x1ac369[_0x4c13fb(0x18e)+_0x4c13fb(0x45a)]),this['push'](_0x14e442['mhxjO']);},Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x116c)+'n']=function(_0x72fb2b,_0x579408,_0x4c41ac){const _0x15ad8f=_0xe90fac;this[_0x15ad8f(0xb9e)+_0x15ad8f(0x1361)+'ce'](_0x579408)?BattleManager['prepareCus'+_0x15ad8f(0x12ed)+'equence']():this[_0x15ad8f(0x6c6)+_0x15ad8f(0xdd1)+_0x15ad8f(0x16a)](_0x72fb2b,_0x579408,_0x4c41ac);},Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0xb9e)+'tionSequen'+'ce']=function(_0x48531){const _0x30117f=_0xe90fac,_0x1b8949={'pLVWa':'0|4|1|3|2|'+'5'},_0x2e84c0=_0x1b8949[_0x30117f(0xc29)]['split']('|');let _0x58a5f4=0x6e6*0x3+-0xeb7*-0x1+-0x103*0x23;while(!![]){switch(_0x2e84c0[_0x58a5f4++]){case'0':if(!SceneManager[_0x30117f(0x11be)+_0x30117f(0x3ad)]())return![];continue;case'1':if(!_0x48531[_0x30117f(0xdd)]())return![];continue;case'2':if(DataManager[_0x30117f(0x525)+_0x30117f(0x192)+_0x30117f(0x5a6)+_0x30117f(0x1117)+'ct'](_0x48531[_0x30117f(0xdd)]()))return!![];continue;case'3':if(_0x48531[_0x30117f(0xdd)]()[_0x30117f(0xfee)]['match'](/<CUSTOM ACTION SEQUENCE>/i))return!![];continue;case'4':if(!_0x48531)return![];continue;case'5':return![];}break;}},Window_BattleLog['prototype'][_0xe90fac(0x6c6)+'ActionSequ'+_0xe90fac(0x16a)]=function(_0x14877b,_0x4b490c,_0x39b84a){const _0x2e4486=_0xe90fac;this[_0x2e4486(0xd6d)+_0x2e4486(0x7f7)](_0x14877b,_0x4b490c,_0x39b84a),this[_0x2e4486(0x12b0)+_0x2e4486(0x91d)+'t'](_0x14877b,_0x4b490c,_0x39b84a),this['finishActi'+_0x2e4486(0x67f)](_0x14877b,_0x4b490c,_0x39b84a);},Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0xa26)+_0xe90fac(0x130a)]=function(_0x3ad23a,_0x3aa562){const _0x12b4fe=_0xe90fac,_0x3e4053={'qlcOX':_0x12b4fe(0xf33),'rzTbV':_0x12b4fe(0x22f)},_0x5b2d6c=VisuMZ[_0x12b4fe(0x118f)][_0x12b4fe(0x281)][_0x12b4fe(0xa22)];_0x5b2d6c[_0x12b4fe(0x94b)+_0x12b4fe(0x13b2)]&&this['push'](_0x3e4053[_0x12b4fe(0x97c)],_0x3e4053[_0x12b4fe(0x26f)][_0x12b4fe(0xeb8)](DataManager[_0x12b4fe(0x694)+'layText'](_0x3aa562)));if(DataManager[_0x12b4fe(0x97a)](_0x3aa562)){if(_0x5b2d6c[_0x12b4fe(0x838)+_0x12b4fe(0x1394)])this[_0x12b4fe(0xa95)+_0x12b4fe(0x11ca)](_0x3aa562[_0x12b4fe(0x1157)],_0x3ad23a,_0x3aa562);if(_0x5b2d6c['ActionSkil'+_0x12b4fe(0x12d1)])this[_0x12b4fe(0xa95)+'mMessage'](_0x3aa562[_0x12b4fe(0x1428)],_0x3ad23a,_0x3aa562);}else{if(_0x5b2d6c[_0x12b4fe(0x7c2)+_0x12b4fe(0x7ae)])this['displayIte'+'mMessage'](TextManager['useItem'],_0x3ad23a,_0x3aa562);}},Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0xd6d)+_0xe90fac(0x7f7)]=function(_0x36c7ed,_0x292843,_0x15763d){const _0x3d30b9=_0xe90fac,_0x130f62={'BrJuA':_0x3d30b9(0xed1)+_0x3d30b9(0x15b9),'ssQYI':'performAct'+_0x3d30b9(0x911),'Ashtk':_0x3d30b9(0x136b)+_0x3d30b9(0x4a5),'zptSt':_0x3d30b9(0x11af)+_0x3d30b9(0x10f4),'IWMnk':_0x3d30b9(0x145d)+'mation'},_0x23abc0=_0x292843[_0x3d30b9(0xdd)]();this['displayAct'+'ion'](_0x36c7ed,_0x23abc0),this[_0x3d30b9(0x15f1)](_0x130f62[_0x3d30b9(0x10b0)],_0x36c7ed,_0x15763d,!![]),this[_0x3d30b9(0x15f1)](_0x130f62['ssQYI'],_0x36c7ed,_0x292843),this[_0x3d30b9(0x15f1)](_0x130f62[_0x3d30b9(0x4d2)]),this[_0x3d30b9(0x15f1)](_0x130f62[_0x3d30b9(0xe1f)],_0x36c7ed,_0x292843),this[_0x3d30b9(0x15f1)](_0x130f62[_0x3d30b9(0xc23)]);},Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x12b0)+_0xe90fac(0x91d)+'t']=function(_0x19c554,_0x56f2ff,_0x539057){const _0x3d9126=_0xe90fac;if(this[_0x3d9126(0x440)+_0x3d9126(0x3f2)+_0x3d9126(0xce0)](_0x56f2ff))this[_0x3d9126(0xaa9)+'ingleTarge'+_0x3d9126(0x1552)](_0x19c554,_0x56f2ff,_0x539057);else{if(this[_0x3d9126(0x1198)+'tiTargetAc'+'tion'](_0x56f2ff))this[_0x3d9126(0xc5d)+_0x3d9126(0xa36)+'ActionSet'](_0x19c554,_0x56f2ff,_0x539057);else _0x56f2ff[_0x3d9126(0x12c0)+'m']()?this[_0x3d9126(0x403)+_0x3d9126(0x67f)](_0x19c554,_0x56f2ff,_0x539057):this[_0x3d9126(0x97d)+_0x3d9126(0x7f7)](_0x19c554,_0x56f2ff,_0x539057);}},Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0xd18)+_0xe90fac(0x6bf)+_0xe90fac(0xa6c)]=function(_0x5e62a6,_0x43f3ef,_0x1784e1,_0x49b557){const _0xc8a257=_0xe90fac,_0x19906f={'ridFO':'performJum'+'p','SamGA':_0xc8a257(0x107a)+_0xc8a257(0xaf6),'vZxKw':'Linear','WfmyR':_0xc8a257(0xa08)+_0xc8a257(0x130a),'CGCOG':_0xc8a257(0x2d1),'uTjFB':_0xc8a257(0x136b)+'ement','yFPow':_0xc8a257(0x1348)};if(_0x43f3ef){const _0x377594=_0x5e62a6['battler']();this[_0xc8a257(0x15f1)](_0x19906f[_0xc8a257(0x809)],[_0x5e62a6],_0x1784e1,_0x49b557),this['push'](_0x19906f[_0xc8a257(0x1591)],_0x5e62a6,_0x377594[_0xc8a257(0xcc4)],_0x377594[_0xc8a257(0x54e)],_0x49b557,![],_0x19906f[_0xc8a257(0x9fc)]),this[_0xc8a257(0x15f1)](_0x19906f[_0xc8a257(0x1179)],[_0x5e62a6],_0x19906f[_0xc8a257(0x121c)]),this['push'](_0x19906f[_0xc8a257(0x5e3)]),this[_0xc8a257(0x15f1)](_0x19906f[_0xc8a257(0x1179)],[_0x5e62a6],_0x19906f[_0xc8a257(0x151c)]);}},Window_BattleLog['prototype'][_0xe90fac(0x440)+_0xe90fac(0x3f2)+_0xe90fac(0xce0)]=function(_0x263fb0){const _0x429d38=_0xe90fac;if(!_0x263fb0[_0x429d38(0x9f)]())return![];if(!_0x263fb0['isForOne']())return![];if(!_0x263fb0[_0x429d38(0xb88)+_0x429d38(0x11ae)]())return![];return VisuMZ[_0x429d38(0x118f)][_0x429d38(0x281)]['ActionSequ'+_0x429d38(0x16a)]['AutoMeleeS'+_0x429d38(0x488)];},Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0xaa9)+'ingleTarge'+'tActionSet']=function(_0x44aae1,_0x175d4d,_0x232f85){const _0x147362=_0xe90fac,_0x388086={'XyEJr':function(_0x3fc582,_0x26d740){return _0x3fc582<_0x26d740;},'GExjN':function(_0x4f5f9c,_0x23cce0){return _0x4f5f9c>_0x23cce0;},'wuTPa':function(_0x3d5218,_0x3bf156){return _0x3d5218===_0x3bf156;},'KqIjV':function(_0x46f1a9,_0x40dfd7){return _0x46f1a9&&_0x40dfd7;},'CaDRC':'performJum'+'p','riVMt':_0x147362(0x107a)+_0x147362(0x3d0),'jTHVH':'front\x20base','MSctm':_0x147362(0x44a),'YJIpp':'requestMot'+_0x147362(0x130a),'tyiMj':_0x147362(0x1348),'ZtpSH':_0x147362(0x136b)+'ement','ieOpS':function(_0x556a1d,_0x19d3d9){return _0x556a1d<_0x19d3d9;},'LKvMB':_0x147362(0x11ad)+_0x147362(0xbdc),'jwwFa':_0x147362(0x8e2)+_0x147362(0x8c3),'wyszH':_0x147362(0xed1)+'tal'},_0x38b3d2=_0x388086[_0x147362(0xaaf)](_0x44aae1[_0x147362(0x408)+_0x147362(0x10b4)]()[_0x147362(0x152a)],-0x7ed*-0x1+0x1967+-0x2152),_0x431c91=0x289*0xd+-0x23c8*-0x1+-0x44a9,_0xbcfbc0=0x1d*0x4b+0x1af*0x5+0x2*-0x85d;let _0x4623b7=!![];_0x388086[_0x147362(0x10f6)](_0x232f85[_0x147362(0x1268)],0x8f2+-0xac5+0x1*0x1d3)&&_0x388086[_0x147362(0x858)](_0x44aae1[_0x147362(0xd83)](),_0x232f85[-0x12f0+-0x20c9+0x33b9][_0x147362(0xd83)]())&&(_0x4623b7=![]);_0x388086[_0x147362(0x15ed)](_0x38b3d2,_0x4623b7)&&(this['push'](_0x388086[_0x147362(0x13b0)],[_0x44aae1],_0xbcfbc0,_0x431c91),this[_0x147362(0x15f1)](_0x388086[_0x147362(0xcab)],_0x44aae1,_0x232f85,_0x388086[_0x147362(0x30d)],_0x431c91,!![],_0x388086[_0x147362(0xbc6)],!![]),this['push'](_0x388086[_0x147362(0xc6)],[_0x44aae1],_0x388086[_0x147362(0x1321)]),this[_0x147362(0x15f1)](_0x388086[_0x147362(0x1228)]));let _0x48c9f2=_0x175d4d[_0x147362(0x7e4)]()?this['getDualWie'+'ldTimes'](_0x44aae1):-0x7a*0x40+0xc5*-0x3+0xc8*0x2a;for(let _0x1591c2=0xac1+-0xdbb*-0x1+-0x187c;_0x388086[_0x147362(0x10ba)](_0x1591c2,_0x48c9f2);_0x1591c2++){_0x175d4d[_0x147362(0x7e4)]()&&_0x44aae1[_0x147362(0xd83)]()&&this['push'](_0x388086[_0x147362(0x13d3)],_0x44aae1,_0x1591c2),_0x388086[_0x147362(0x10ba)](_0x175d4d[_0x147362(0xdd)]()[_0x147362(0x4cf)+'d'],-0xe2+0xfb6+0x2*-0x76a)?this[_0x147362(0x403)+_0x147362(0x67f)](_0x44aae1,_0x175d4d,_0x232f85):this[_0x147362(0x97d)+'nSet'](_0x44aae1,_0x175d4d,_0x232f85);}_0x175d4d[_0x147362(0x7e4)]()&&_0x44aae1[_0x147362(0xd83)]()&&this[_0x147362(0x15f1)](_0x388086[_0x147362(0xdb1)],_0x44aae1),this[_0x147362(0x15f1)](_0x388086[_0x147362(0xbae)],_0x44aae1,_0x232f85,![]),this[_0x147362(0xd18)+_0x147362(0x6bf)+_0x147362(0xa6c)](_0x44aae1,_0x38b3d2,_0xbcfbc0,_0x431c91);},Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x1198)+'tiTargetAc'+_0xe90fac(0x1580)]=function(_0x167c86){const _0x4221de=_0xe90fac;if(!_0x167c86[_0x4221de(0x9f)]())return![];if(!_0x167c86[_0x4221de(0xae9)]())return![];if(!_0x167c86['isForOppon'+_0x4221de(0x11ae)]())return![];return VisuMZ[_0x4221de(0x118f)]['Settings'][_0x4221de(0xdd1)+'ence'][_0x4221de(0xc47)+'oE'];},Window_BattleLog['prototype'][_0xe90fac(0xc5d)+_0xe90fac(0xa36)+_0xe90fac(0x2b0)]=function(_0x5b6871,_0x1168e2,_0x1fdf2d){const _0x2bc6f7=_0xe90fac,_0x59b558={'sbJks':function(_0x20d320,_0x2369e1){return _0x20d320<_0x2369e1;},'phZvw':_0x2bc6f7(0x788)+'p','RvOUP':function(_0x4f72ef,_0x324b62){return _0x4f72ef>_0x324b62;},'gwluC':_0x2bc6f7(0xb0b)+'er','KxRfr':_0x2bc6f7(0x103f),'KskGW':_0x2bc6f7(0x107a)+_0x2bc6f7(0x3d0),'eYKHQ':_0x2bc6f7(0x44a),'laSPe':_0x2bc6f7(0xa08)+_0x2bc6f7(0x130a),'lxlQC':_0x2bc6f7(0x1348),'HOujr':_0x2bc6f7(0x136b)+_0x2bc6f7(0x4a5),'GeWHZ':function(_0x499661,_0xc35487){return _0x499661<_0xc35487;},'eldkL':'setActiveW'+_0x2bc6f7(0xbdc),'jYUTP':_0x2bc6f7(0x8e2)+_0x2bc6f7(0x8c3),'rrrmT':_0x2bc6f7(0xed1)+'tal'},_0x515105=_0x59b558[_0x2bc6f7(0x5b1)](_0x5b6871['getAttackM'+_0x2bc6f7(0x10b4)]()[_0x2bc6f7(0x152a)],-0x1*-0x1550+-0x22a9+0xd5b),_0x179037=0x1278*0x2+0xd3*-0x1c+-0xdc8,_0x8109f8=0xacc+0x1*-0xff4+0x558;if(_0x515105){this['push'](_0x59b558[_0x2bc6f7(0xc8b)],[_0x5b6871],_0x8109f8,_0x179037);const _0x5cdd2b=_0x59b558['RvOUP'](_0x1fdf2d[_0x2bc6f7(0x1268)],0x198f+0x14aa+-0x74*0x66)?_0x59b558[_0x2bc6f7(0x1219)]:_0x59b558[_0x2bc6f7(0xedd)];this[_0x2bc6f7(0x15f1)](_0x59b558[_0x2bc6f7(0x8dc)],_0x5b6871,_0x1fdf2d,_0x5cdd2b,_0x179037,!![],_0x59b558[_0x2bc6f7(0xab6)],!![]),this['push'](_0x59b558[_0x2bc6f7(0x5c2)],[_0x5b6871],_0x59b558[_0x2bc6f7(0x113e)]),this['push'](_0x59b558[_0x2bc6f7(0xc9e)]);}let _0x4bdcb0=_0x1168e2[_0x2bc6f7(0x7e4)]()?this[_0x2bc6f7(0x1308)+_0x2bc6f7(0x155)](_0x5b6871):0x11*0x1b+0x1af3*0x1+-0x1cbd;for(let _0x3adee3=-0x878*-0x2+0x1*-0x249d+0x13ad;_0x59b558[_0x2bc6f7(0x87a)](_0x3adee3,_0x4bdcb0);_0x3adee3++){_0x1168e2[_0x2bc6f7(0x7e4)]()&&_0x5b6871[_0x2bc6f7(0xd83)]()&&this[_0x2bc6f7(0x15f1)](_0x59b558[_0x2bc6f7(0xea0)],_0x5b6871,_0x3adee3),this[_0x2bc6f7(0x97d)+_0x2bc6f7(0x7f7)](_0x5b6871,_0x1168e2,_0x1fdf2d);}_0x1168e2['isAttack']()&&_0x5b6871['isActor']()&&this[_0x2bc6f7(0x15f1)](_0x59b558[_0x2bc6f7(0x1161)],_0x5b6871),this[_0x2bc6f7(0x15f1)](_0x59b558['rrrmT'],_0x5b6871,_0x1fdf2d,![]),this[_0x2bc6f7(0xd18)+'turnAction'+_0x2bc6f7(0xa6c)](_0x5b6871,_0x515105,_0x8109f8,_0x179037);},Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x403)+'onSet']=function(_0xe5595e,_0x3b3454,_0x55849e){const _0x2eddff=_0xe90fac,_0x1a5ff1={'DTHXw':_0x2eddff(0x763)+'ion','VqmCY':_0x2eddff(0x1172),'ZoQjv':_0x2eddff(0x1b7)+_0x2eddff(0x130a),'CvtqR':_0x2eddff(0x679)+'ct'},_0x296df0=_0x3b3454[_0x2eddff(0xdd)]();for(const _0xe4d422 of _0x55849e){if(!_0xe4d422)continue;this[_0x2eddff(0x15f1)](_0x1a5ff1[_0x2eddff(0x13cd)],_0xe5595e,_0x3b3454),this[_0x2eddff(0x15f1)](_0x1a5ff1[_0x2eddff(0xb25)],Sprite_Battler[_0x2eddff(0x1597)+'ed']),this[_0x2eddff(0x15f1)](_0x1a5ff1[_0x2eddff(0x279)],_0xe5595e,[_0xe4d422],_0x296df0[_0x2eddff(0x4cf)+'d']),this[_0x2eddff(0x15f1)](_0x1a5ff1[_0x2eddff(0xb25)],-0x5c5+-0x1e2a+-0x1*-0x2407),this[_0x2eddff(0x15f1)](_0x1a5ff1[_0x2eddff(0x160e)],_0xe5595e,_0xe4d422);}},Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x97d)+_0xe90fac(0x7f7)]=function(_0xce01d,_0x1c664a,_0x1a96a6){const _0x78a03c=_0xe90fac,_0x1cd4db={'lIdRJ':function(_0x1c9909,_0x1c8748){return _0x1c9909+_0x1c8748;},'CfSRW':_0x78a03c(0x763)+'ion','BEOIE':_0x78a03c(0x1172),'CYeJV':_0x78a03c(0x1b7)+_0x78a03c(0x130a),'BPhjO':_0x78a03c(0x145d)+'mation','ihcGu':_0x78a03c(0x679)+'ct'},_0x34fbaf=_0x1c664a['item']();let _0x178754=_0x1c664a[_0x78a03c(0x7e4)]()?_0x1cd4db[_0x78a03c(0xc2)](0x1*0x1825+-0x2298+0xa74,_0xce01d[_0x78a03c(0xef7)+'sAdd']()):-0x10df+0x61*0x3d+0x63d*-0x1;while(_0x178754--){this[_0x78a03c(0x15f1)](_0x1cd4db[_0x78a03c(0x1502)],_0xce01d,_0x1c664a),this[_0x78a03c(0x15f1)](_0x1cd4db['BEOIE'],Sprite_Battler[_0x78a03c(0x1597)+'ed']),this[_0x78a03c(0x15f1)](_0x1cd4db['CYeJV'],_0xce01d,_0x1a96a6[_0x78a03c(0x1096)](),_0x34fbaf[_0x78a03c(0x4cf)+'d']),this[_0x78a03c(0x15f1)](_0x1cd4db[_0x78a03c(0x15fb)]);}for(const _0x36c976 of _0x1a96a6){if(!_0x36c976)continue;this[_0x78a03c(0x15f1)](_0x1cd4db[_0x78a03c(0xc6c)],_0xce01d,_0x36c976);}},Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x1523)+_0xe90fac(0x67f)]=function(_0x11e086,_0x4b3294,_0x318ccd){const _0x573e0a=_0xe90fac,_0x5a5bc1={'cfFIo':_0x573e0a(0xed1)+_0x573e0a(0x15b9),'TSFOL':_0x573e0a(0x299)+_0x573e0a(0x1212),'YbUSO':_0x573e0a(0x676)+_0x573e0a(0x41d),'dOayO':_0x573e0a(0xf98),'BZdmE':'performAct'+_0x573e0a(0x15f),'fUvrL':_0x573e0a(0x136b)+_0x573e0a(0x4a5)},_0x1fedc5=_0x4b3294[_0x573e0a(0xdd)]();this[_0x573e0a(0x15f1)](_0x5a5bc1[_0x573e0a(0xc0d)],_0x11e086,_0x318ccd,![]),this[_0x573e0a(0x15f1)](_0x5a5bc1[_0x573e0a(0x370)]),this['push'](_0x5a5bc1[_0x573e0a(0x13de)]),this[_0x573e0a(0x15f1)](_0x5a5bc1[_0x573e0a(0xb7a)]),this['push'](_0x5a5bc1['BZdmE'],_0x11e086),this[_0x573e0a(0x15f1)](_0x5a5bc1[_0x573e0a(0x799)]);},Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x6e3)]=function(_0x587c35){},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x8a0)+'tleLog_dis'+_0xe90fac(0x766)+_0xe90fac(0x19f)]=Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x102f)+_0xe90fac(0xd7)],Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x102f)+_0xe90fac(0xd7)]=function(_0x25c5b2){const _0x32e28b=_0xe90fac;if(!VisuMZ[_0x32e28b(0x118f)]['Settings'][_0x32e28b(0xa22)][_0x32e28b(0x5fb)+'tState'])return;VisuMZ[_0x32e28b(0x118f)]['Window_Bat'+_0x32e28b(0x569)+_0x32e28b(0x766)+_0x32e28b(0x19f)][_0x32e28b(0x351)](this,_0x25c5b2);},Window_BattleLog[_0xe90fac(0x510)]['displayCou'+_0xe90fac(0x12c9)]=function(_0x40b67c){const _0x3576e2=_0xe90fac,_0x3fc19e={'AbQtI':_0x3576e2(0x10f)+_0x3576e2(0x12c9),'TLVbq':_0x3576e2(0x1b7)+_0x3576e2(0x130a),'JlSxZ':_0x3576e2(0xf33)};this['push'](_0x3fc19e[_0x3576e2(0x19c)],_0x40b67c);VisuMZ[_0x3576e2(0x118f)][_0x3576e2(0x281)][_0x3576e2(0xdd1)+_0x3576e2(0x16a)][_0x3576e2(0x2e5)+'yback']&&this[_0x3576e2(0x15f1)](_0x3fc19e[_0x3576e2(0x1323)],_0x40b67c,[BattleManager[_0x3576e2(0x14c1)]],-(0x107e+-0x7b*0x45+0x3*0x58e));if(!VisuMZ['BattleCore'][_0x3576e2(0x281)][_0x3576e2(0xa22)]['ShowCounte'+'r'])return;this[_0x3576e2(0x15f1)](_0x3fc19e[_0x3576e2(0x17f)],TextManager[_0x3576e2(0x132a)+_0x3576e2(0x9dd)][_0x3576e2(0xeb8)](_0x40b67c[_0x3576e2(0x14c)]()));},Window_BattleLog[_0xe90fac(0x510)]['displayRef'+'lection']=function(_0x1db13c){const _0x3f541f=_0xe90fac,_0x9f89ad={'QbXWw':_0x3f541f(0x260)+_0x3f541f(0x9f1),'qziSA':'addText'};this[_0x3f541f(0x15f1)](_0x9f89ad['QbXWw'],_0x1db13c);if(!VisuMZ[_0x3f541f(0x118f)]['Settings'][_0x3f541f(0xa22)]['ShowReflec'+'t'])return;this[_0x3f541f(0x15f1)](_0x9f89ad['qziSA'],TextManager[_0x3f541f(0x598)+_0x3f541f(0xce0)][_0x3f541f(0xeb8)](_0x1db13c[_0x3f541f(0x14c)]()));},Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x112f)+'lectionPla'+_0xe90fac(0x8f8)]=function(_0x4f8bca,_0x1009e0){const _0x528258=_0xe90fac,_0x40d236={'xsJgP':_0x528258(0x1b7)+_0x528258(0x130a)};if(VisuMZ['BattleCore'][_0x528258(0x281)]['ActionSequ'+_0x528258(0x16a)]['ReflectPla'+_0x528258(0x376)]){const _0x3c925c=_0x1009e0[_0x528258(0xdd)]();this['push'](_0x40d236['xsJgP'],_0x4f8bca,[_0x4f8bca],_0x3c925c[_0x528258(0x4cf)+'d']);}},Window_BattleLog['prototype'][_0xe90fac(0x1222)+_0xe90fac(0x2ed)]=function(_0x7579b2,_0x498b9e){const _0x36afff=_0xe90fac,_0x36f414={'CrUtT':_0x36afff(0xd0d)+_0x36afff(0x2ed),'KPRqh':_0x36afff(0xf33)};this['push'](_0x36f414[_0x36afff(0x9cc)],_0x7579b2,_0x498b9e);if(!VisuMZ[_0x36afff(0x118f)][_0x36afff(0x281)][_0x36afff(0xa22)]['ShowSubsti'+_0x36afff(0x737)])return;const _0x24d044=_0x7579b2['name'](),_0x13800f=TextManager['substitute'][_0x36afff(0xeb8)](_0x24d044,_0x498b9e[_0x36afff(0x14c)]());this[_0x36afff(0x15f1)](_0x36f414['KPRqh'],_0x13800f);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x8a0)+_0xe90fac(0x569)+_0xe90fac(0xda9)+_0xe90fac(0xd78)]=Window_BattleLog['prototype'][_0xe90fac(0xa26)+_0xe90fac(0x9d7)],Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0xa26)+_0xe90fac(0x9d7)]=function(_0x5efcc9,_0x5cbc2b){const _0x3b621f=_0xe90fac;VisuMZ[_0x3b621f(0x118f)][_0x3b621f(0x8a0)+_0x3b621f(0x569)+'playAction'+_0x3b621f(0xd78)][_0x3b621f(0x351)](this,_0x5efcc9,_0x5cbc2b);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x8a0)+'tleLog_dis'+'playFailur'+'e']=Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x5d9)+_0xe90fac(0xa98)],Window_BattleLog[_0xe90fac(0x510)]['displayFai'+_0xe90fac(0xa98)]=function(_0x1bba8f){const _0x33adef=_0xe90fac;if(!VisuMZ['BattleCore'][_0x33adef(0x281)][_0x33adef(0xa22)]['ShowFailur'+'e'])return;VisuMZ[_0x33adef(0x118f)][_0x33adef(0x8a0)+_0x33adef(0x569)+'playFailur'+'e'][_0x33adef(0x351)](this,_0x1bba8f);},VisuMZ['BattleCore'][_0xe90fac(0x8a0)+_0xe90fac(0x569)+_0xe90fac(0xb6d)+'al']=Window_BattleLog[_0xe90fac(0x510)]['displayCri'+_0xe90fac(0xb26)],Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0xaa3)+_0xe90fac(0xb26)]=function(_0xfc7fee){const _0x14f6b8=_0xe90fac;if(!VisuMZ[_0x14f6b8(0x118f)][_0x14f6b8(0x281)][_0x14f6b8(0xa22)][_0x14f6b8(0xeec)+'al'])return;VisuMZ['BattleCore'][_0x14f6b8(0x8a0)+_0x14f6b8(0x569)+_0x14f6b8(0xb6d)+'al'][_0x14f6b8(0x351)](this,_0xfc7fee);},VisuMZ['BattleCore'][_0xe90fac(0x8a0)+'tleLog_dis'+_0xe90fac(0x17b)]=Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x89)+'s'],Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x89)+'s']=function(_0x313d29){const _0xd805db=_0xe90fac,_0x36e529={'nDITx':'performMis'+'s'};!VisuMZ[_0xd805db(0x118f)]['Settings'][_0xd805db(0xa22)][_0xd805db(0x989)+_0xd805db(0x13a)]?this['push'](_0x36e529[_0xd805db(0xaf9)],_0x313d29):VisuMZ[_0xd805db(0x118f)][_0xd805db(0x8a0)+'tleLog_dis'+_0xd805db(0x17b)][_0xd805db(0x351)](this,_0x313d29);},VisuMZ['BattleCore'][_0xe90fac(0x8a0)+_0xe90fac(0x569)+_0xe90fac(0xc6d)+'n']=Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0xd53)+_0xe90fac(0xca)],Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0xd53)+_0xe90fac(0xca)]=function(_0x32ff9d){const _0x1a95bc=_0xe90fac,_0xf65a6b={'vUvlh':'performEva'+_0x1a95bc(0xca),'QBuLa':_0x1a95bc(0x898)+_0x1a95bc(0x145a)};!VisuMZ[_0x1a95bc(0x118f)][_0x1a95bc(0x281)]['BattleLog'][_0x1a95bc(0x989)+'asion']?_0x32ff9d[_0x1a95bc(0x1c5)]()[_0x1a95bc(0x1319)]?this[_0x1a95bc(0x15f1)](_0xf65a6b[_0x1a95bc(0xe89)],_0x32ff9d):this[_0x1a95bc(0x15f1)](_0xf65a6b[_0x1a95bc(0x4e6)],_0x32ff9d):VisuMZ[_0x1a95bc(0x118f)][_0x1a95bc(0x8a0)+_0x1a95bc(0x569)+_0x1a95bc(0xc6d)+'n']['call'](this,_0x32ff9d);},Window_BattleLog[_0xe90fac(0x510)]['displayHpD'+'amage']=function(_0x34512a){const _0x5d663d=_0xe90fac,_0x5c61a7={'oiIln':function(_0x4d3c54,_0x29358a){return _0x4d3c54>_0x29358a;},'fBOdR':_0x5d663d(0x179)+_0x5d663d(0x154d),'sYTSE':function(_0x42e47e,_0xc722cd){return _0x42e47e<_0xc722cd;},'VrivV':'performRec'+_0x5d663d(0xf1d),'vvMpB':_0x5d663d(0xf33)};_0x34512a[_0x5d663d(0x1c5)]()[_0x5d663d(0xf67)]&&(_0x34512a[_0x5d663d(0xf0)+_0x5d663d(0x154d)]=-0x220+-0xd60+0x1f0*0x8,_0x5c61a7[_0x5d663d(0x4c6)](_0x34512a[_0x5d663d(0x1c5)]()[_0x5d663d(0x4da)],0x14f2+-0x14b8+-0x3a)&&!_0x34512a[_0x5d663d(0x1c5)]()[_0x5d663d(0x143b)]&&(_0x34512a['_lastHpDam'+'age']=_0x34512a['result']()[_0x5d663d(0x4da)],this[_0x5d663d(0x15f1)](_0x5c61a7[_0x5d663d(0xa76)],_0x34512a)),_0x5c61a7[_0x5d663d(0xf16)](_0x34512a[_0x5d663d(0x1c5)]()[_0x5d663d(0x4da)],0x1dea+-0x1ae0+-0x30a)&&this[_0x5d663d(0x15f1)](_0x5c61a7[_0x5d663d(0x470)],_0x34512a),VisuMZ[_0x5d663d(0x118f)]['Settings'][_0x5d663d(0xa22)][_0x5d663d(0x1259)]&&this[_0x5d663d(0x15f1)](_0x5c61a7[_0x5d663d(0x7bd)],this['makeHpDama'+_0x5d663d(0x116)](_0x34512a)));},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x8a0)+_0xe90fac(0x569)+'playMpDama'+'ge']=Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0xfd)+_0xe90fac(0x970)],Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0xfd)+_0xe90fac(0x970)]=function(_0xa532a4){const _0x31de7d=_0xe90fac;if(!VisuMZ['BattleCore'][_0x31de7d(0x281)]['BattleLog']['ShowMpDmg'])return;VisuMZ[_0x31de7d(0x118f)][_0x31de7d(0x8a0)+_0x31de7d(0x569)+'playMpDama'+'ge']['call'](this,_0xa532a4);},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x8a0)+_0xe90fac(0x569)+_0xe90fac(0x1089)+'ge']=Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0xaf1)+'amage'],Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0xaf1)+_0xe90fac(0x970)]=function(_0x41352b){const _0x22f3ca=_0xe90fac;if(!VisuMZ[_0x22f3ca(0x118f)]['Settings']['BattleLog'][_0x22f3ca(0x708)])return;VisuMZ[_0x22f3ca(0x118f)][_0x22f3ca(0x8a0)+'tleLog_dis'+_0x22f3ca(0x1089)+'ge'][_0x22f3ca(0x351)](this,_0x41352b);},Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x1194)+_0xe90fac(0x13e)+'s']=function(_0x43efdd){const _0x270d34=_0xe90fac,_0x3c6ea6={'WhIeI':_0x270d34(0x159c)+'ne','uHJtN':_0x270d34(0x299)+'Line'};_0x43efdd[_0x270d34(0x1c5)]()['isStatusAf'+_0x270d34(0x84f)]()&&(this[_0x270d34(0x15f1)](_0x3c6ea6[_0x270d34(0x111f)]),this[_0x270d34(0xa99)+'ngedStates'](_0x43efdd),this[_0x270d34(0xa99)+_0x270d34(0x14d0)](_0x43efdd),this[_0x270d34(0x15f1)](_0x3c6ea6[_0x270d34(0x14b4)]));},Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0xd14)+_0xe90fac(0x8ba)]=function(_0x4be5f5){const _0x52d6fb=_0xe90fac,_0x5dba2e={'nUOjE':_0x52d6fb(0x1513),'opZHj':_0x52d6fb(0x75b)+'e','BlTAo':_0x52d6fb(0x15b8)+_0x52d6fb(0x8da),'uzXuY':'addText','fgosT':_0x52d6fb(0x159c)+'ne','Ibpmh':_0x52d6fb(0x600),'FePpb':function(_0x44d566,_0x193031){return _0x44d566===_0x193031;},'OlTII':_0x52d6fb(0x4a2)+_0x52d6fb(0x65d)},_0x12de7e=_0x4be5f5[_0x52d6fb(0x1c5)](),_0x121073=_0x12de7e[_0x52d6fb(0xbe6)+_0x52d6fb(0x528)]();for(const _0x12280a of _0x121073){const _0x4cce56=_0x4be5f5[_0x52d6fb(0xd83)]()?_0x12280a['message1']:_0x12280a[_0x52d6fb(0x1428)];if(_0x4cce56&&VisuMZ[_0x52d6fb(0x118f)]['Settings'][_0x52d6fb(0xa22)][_0x52d6fb(0xb78)+_0x52d6fb(0x2ce)]){const _0x524737=_0x5dba2e['nUOjE'][_0x52d6fb(0xab1)]('|');let _0x32c0a0=-0x1853+0x1e17*0x1+-0x5c4;while(!![]){switch(_0x524737[_0x32c0a0++]){case'0':this['push'](_0x5dba2e[_0x52d6fb(0x9b6)]);continue;case'1':this['push'](_0x5dba2e[_0x52d6fb(0x11ba)]);continue;case'2':this[_0x52d6fb(0x15f1)](_0x5dba2e[_0x52d6fb(0xa1a)],_0x4cce56[_0x52d6fb(0xeb8)](_0x4be5f5[_0x52d6fb(0x14c)]()));continue;case'3':this['push'](_0x5dba2e[_0x52d6fb(0x869)]);continue;case'4':this[_0x52d6fb(0x15f1)](_0x5dba2e[_0x52d6fb(0x153d)]);continue;}break;}}_0x5dba2e[_0x52d6fb(0x707)](_0x12280a['id'],_0x4be5f5['deathState'+'Id']())&&this[_0x52d6fb(0x15f1)](_0x5dba2e[_0x52d6fb(0xeca)],_0x4be5f5);}},Window_BattleLog[_0xe90fac(0x510)]['fnordAdded'+_0xe90fac(0x8da)]=function(){},Window_BattleLog[_0xe90fac(0x510)]['displayRem'+_0xe90fac(0xe9e)]=function(_0x5013a3){const _0x45fdbc=_0xe90fac,_0x254ee2={'vCwHx':'1|4|2|3|0','ylCBd':_0x45fdbc(0x600),'fGmuk':_0x45fdbc(0xae1)+_0x45fdbc(0x8ba),'zqhuH':'pushBaseLi'+'ne','nTKAR':_0x45fdbc(0xf33),'Jmxig':_0x45fdbc(0x75b)+'e'};if(!VisuMZ[_0x45fdbc(0x118f)][_0x45fdbc(0x281)][_0x45fdbc(0xa22)][_0x45fdbc(0x89a)+'dState'])return;const _0x28b2de=_0x5013a3['result'](),_0x2ebc5e=_0x28b2de['removedSta'+_0x45fdbc(0xf34)]();for(const _0x4f0e49 of _0x2ebc5e){if(_0x4f0e49[_0x45fdbc(0xf86)]){const _0x19f5ef=_0x254ee2[_0x45fdbc(0x122c)]['split']('|');let _0x4a8437=-0x11a+0xc5*-0x18+0x1392;while(!![]){switch(_0x19f5ef[_0x4a8437++]){case'0':this[_0x45fdbc(0x15f1)](_0x254ee2[_0x45fdbc(0x96)]);continue;case'1':this[_0x45fdbc(0x15f1)](_0x254ee2[_0x45fdbc(0x13a9)]);continue;case'2':this[_0x45fdbc(0x15f1)](_0x254ee2[_0x45fdbc(0x1b9)]);continue;case'3':this[_0x45fdbc(0x15f1)](_0x254ee2[_0x45fdbc(0x159e)],_0x4f0e49[_0x45fdbc(0xf86)][_0x45fdbc(0xeb8)](_0x5013a3[_0x45fdbc(0x14c)]()));continue;case'4':this['push'](_0x254ee2[_0x45fdbc(0x5d1)]);continue;}break;}}}},Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0xae1)+_0xe90fac(0x8ba)]=function(){},Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0xa99)+_0xe90fac(0x14d0)]=function(_0x414159){const _0x7e9822=_0xe90fac,_0x17d520=VisuMZ[_0x7e9822(0x118f)][_0x7e9822(0x281)][_0x7e9822(0xa22)],_0x2a3d1a=_0x414159[_0x7e9822(0x1c5)]();if(_0x17d520[_0x7e9822(0xd45)+'uff'])this[_0x7e9822(0x735)+'fs'](_0x414159,_0x2a3d1a[_0x7e9822(0x969)],TextManager[_0x7e9822(0x1071)]);if(_0x17d520['ShowAddedD'+_0x7e9822(0x1550)])this['displayBuf'+'fs'](_0x414159,_0x2a3d1a[_0x7e9822(0xf2d)+'fs'],TextManager[_0x7e9822(0xf60)]);if(_0x17d520[_0x7e9822(0x89a)+_0x7e9822(0xd4a)])this['displayBuf'+'fs'](_0x414159,_0x2a3d1a[_0x7e9822(0xb18)+'fs'],TextManager[_0x7e9822(0x74f)]);},Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x735)+'fs']=function(_0x4effe6,_0x16abb3,_0x3ddcda){const _0x1faac1=_0xe90fac,_0x4395b3={'pWPFC':_0x1faac1(0x75b)+'e','AsVUI':_0x1faac1(0x159c)+'ne','oxvLo':'addText','SPxCZ':_0x1faac1(0x600)};for(const _0x3fd56c of _0x16abb3){const _0x102242=_0x3ddcda[_0x1faac1(0xeb8)](_0x4effe6[_0x1faac1(0x14c)](),TextManager['param'](_0x3fd56c));this[_0x1faac1(0x15f1)](_0x4395b3[_0x1faac1(0x715)]),this[_0x1faac1(0x15f1)](_0x4395b3[_0x1faac1(0xe55)]),this[_0x1faac1(0x15f1)](_0x4395b3[_0x1faac1(0xdba)],_0x102242),this[_0x1faac1(0x15f1)](_0x4395b3[_0x1faac1(0xafa)]);}},VisuMZ[_0xe90fac(0x118f)]['Window_Bat'+_0xe90fac(0xc61)+'ar']=Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0xf98)],Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0xf98)]=function(){const _0x575fda=_0xe90fac;VisuMZ[_0x575fda(0x118f)][_0x575fda(0x8a0)+_0x575fda(0xc61)+'ar']['call'](this),this[_0x575fda(0x514)+'thod']();},VisuMZ['BattleCore'][_0xe90fac(0x8a0)+'tleLog_pus'+_0xe90fac(0x200)]=Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x159c)+'ne'],Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x159c)+'ne']=function(){const _0x1a04bd=_0xe90fac;VisuMZ[_0x1a04bd(0x118f)][_0x1a04bd(0x8a0)+_0x1a04bd(0x9ba)+_0x1a04bd(0x200)][_0x1a04bd(0x351)](this),this[_0x1a04bd(0x514)+_0x1a04bd(0x6da)]();},VisuMZ[_0xe90fac(0x118f)]['Window_Bat'+_0xe90fac(0xabe)+_0xe90fac(0x12d7)]=Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x75b)+'e'],Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x75b)+'e']=function(){const _0x2393cc=_0xe90fac;VisuMZ['BattleCore']['Window_Bat'+'tleLog_pop'+_0x2393cc(0x12d7)][_0x2393cc(0x351)](this),this[_0x2393cc(0xa42)+_0x2393cc(0x111c)](),this[_0x2393cc(0x514)+_0x2393cc(0x6da)]();},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x8a0)+'tleLog_pop'+_0xe90fac(0xed6)]=Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x103e)+'e'],Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x103e)+'e']=function(_0x181cec){const _0x3af465=_0xe90fac;VisuMZ[_0x3af465(0x118f)][_0x3af465(0x8a0)+_0x3af465(0xabe)+_0x3af465(0xed6)][_0x3af465(0x351)](this,_0x181cec),this[_0x3af465(0x514)+_0x3af465(0x6da)]();},Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x299)+_0xe90fac(0x1212)]=function(){const _0x541b91=_0xe90fac,_0x49a15b={'YQWOv':function(_0x4ed7fa,_0x2ee22e){return _0x4ed7fa>_0x2ee22e;},'SGFvm':function(_0x59b8fa,_0x29d562){return _0x59b8fa-_0x29d562;}};let _0x18be09=0x6d*0x42+0xd*0x2ea+-0x41fc;_0x49a15b['YQWOv'](this['_baseLineS'+'tack'][_0x541b91(0x1268)],0x2*0xa9a+-0x877+-0xcbd)&&(_0x18be09=this[_0x541b91(0x1c0)+_0x541b91(0xa7f)][_0x49a15b['SGFvm'](this[_0x541b91(0x1c0)+_0x541b91(0xa7f)]['length'],-0x522*0x4+-0x80*0xb+0x1a09)]),_0x49a15b['YQWOv'](this[_0x541b91(0x7c9)][_0x541b91(0x1268)],_0x18be09)?this['wait']():this[_0x541b91(0x514)+_0x541b91(0x6da)]();},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x8a0)+_0xe90fac(0x1a2)+_0xe90fac(0xf8d)+_0xe90fac(0x854)]=Window_BattleLog['prototype']['performAct'+_0xe90fac(0x911)],Window_BattleLog[_0xe90fac(0x510)]['performAct'+_0xe90fac(0x911)]=function(_0x4833f5,_0x52054f){const _0x50f36a=_0xe90fac;VisuMZ[_0x50f36a(0x118f)]['Window_Bat'+'tleLog_per'+_0x50f36a(0xf8d)+_0x50f36a(0x854)][_0x50f36a(0x351)](this,_0x4833f5,_0x52054f),this['callNextMe'+_0x50f36a(0x6da)]();},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x8a0)+'tleLog_per'+_0xe90fac(0xf8d)]=Window_BattleLog[_0xe90fac(0x510)]['performAct'+_0xe90fac(0x130a)],Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x763)+_0xe90fac(0x130a)]=function(_0x489cf9,_0x302a23){const _0x4f288e=_0xe90fac;VisuMZ[_0x4f288e(0x118f)][_0x4f288e(0x8a0)+_0x4f288e(0x1a2)+_0x4f288e(0xf8d)][_0x4f288e(0x351)](this,_0x489cf9,_0x302a23),this[_0x4f288e(0x514)+_0x4f288e(0x6da)]();},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x8a0)+'tleLog_per'+'formAction'+_0xe90fac(0x11d)]=Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x763)+_0xe90fac(0x15f)],Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x763)+_0xe90fac(0x15f)]=function(_0x16e768){const _0x4f43d4=_0xe90fac;VisuMZ[_0x4f43d4(0x118f)][_0x4f43d4(0x8a0)+'tleLog_per'+_0x4f43d4(0xf8d)+_0x4f43d4(0x11d)][_0x4f43d4(0x351)](this,_0x16e768);for(const _0x5bd855 of BattleManager['allBattleM'+_0x4f43d4(0xcdb)]()){if(!_0x5bd855)continue;if(_0x5bd855[_0x4f43d4(0x17d)]())continue;_0x5bd855[_0x4f43d4(0x763)+'ionEndMemb'+_0x4f43d4(0x446)]();}this[_0x4f43d4(0x514)+_0x4f43d4(0x6da)]();},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x8a0)+_0xe90fac(0x1a2)+'formDamage']=Window_BattleLog[_0xe90fac(0x510)]['performDam'+_0xe90fac(0x154d)],Window_BattleLog['prototype']['performDam'+_0xe90fac(0x154d)]=function(_0x17dcae){const _0x4c07b1=_0xe90fac;VisuMZ[_0x4c07b1(0x118f)][_0x4c07b1(0x8a0)+_0x4c07b1(0x1a2)+_0x4c07b1(0x13a6)][_0x4c07b1(0x351)](this,_0x17dcae),this[_0x4c07b1(0x514)+_0x4c07b1(0x6da)]();},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x8a0)+_0xe90fac(0x1a2)+_0xe90fac(0x13e8)]=Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x1374)+'s'],Window_BattleLog[_0xe90fac(0x510)]['performMis'+'s']=function(_0x4640f5){const _0x210fdc=_0xe90fac;VisuMZ['BattleCore']['Window_Bat'+_0x210fdc(0x1a2)+'formMiss'][_0x210fdc(0x351)](this,_0x4640f5),this[_0x210fdc(0x514)+'thod']();},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x8a0)+_0xe90fac(0x1a2)+_0xe90fac(0xff6)+'ry']=Window_BattleLog['prototype'][_0xe90fac(0x1548)+'overy'],Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x1548)+'overy']=function(_0x4c886f){const _0x2ac92d=_0xe90fac;VisuMZ[_0x2ac92d(0x118f)]['Window_Bat'+_0x2ac92d(0x1a2)+_0x2ac92d(0xff6)+'ry'][_0x2ac92d(0x351)](this,_0x4c886f),this['callNextMe'+'thod']();},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x8a0)+_0xe90fac(0x1a2)+_0xe90fac(0x29f)+'n']=Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x1cc)+_0xe90fac(0xca)],Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x1cc)+_0xe90fac(0xca)]=function(_0x4cf414){const _0x2f9d19=_0xe90fac;VisuMZ[_0x2f9d19(0x118f)][_0x2f9d19(0x8a0)+_0x2f9d19(0x1a2)+_0x2f9d19(0x29f)+'n'][_0x2f9d19(0x351)](this,_0x4cf414),this[_0x2f9d19(0x514)+'thod']();},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x8a0)+_0xe90fac(0x1a2)+'formMagicE'+_0xe90fac(0x267)]=Window_BattleLog['prototype']['performMag'+_0xe90fac(0x145a)],Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x898)+'icEvasion']=function(_0x32b28a){const _0x511d49=_0xe90fac;VisuMZ[_0x511d49(0x118f)][_0x511d49(0x8a0)+'tleLog_per'+_0x511d49(0xa90)+_0x511d49(0x267)]['call'](this,_0x32b28a),this['callNextMe'+_0x511d49(0x6da)]();},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x8a0)+_0xe90fac(0x1a2)+'formCounte'+'r']=Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x10f)+_0xe90fac(0x12c9)],Window_BattleLog['prototype']['performCou'+_0xe90fac(0x12c9)]=function(_0x50b749){const _0x40508a=_0xe90fac;VisuMZ['BattleCore'][_0x40508a(0x8a0)+'tleLog_per'+_0x40508a(0x462)+'r'][_0x40508a(0x351)](this,_0x50b749),this[_0x40508a(0x514)+_0x40508a(0x6da)]();},VisuMZ['BattleCore']['Window_Bat'+'tleLog_per'+'formReflec'+_0xe90fac(0x1580)]=Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x260)+_0xe90fac(0x9f1)],Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x260)+'lection']=function(_0x516133){const _0x43951f=_0xe90fac;VisuMZ[_0x43951f(0x118f)][_0x43951f(0x8a0)+_0x43951f(0x1a2)+_0x43951f(0x62e)+_0x43951f(0x1580)][_0x43951f(0x351)](this,_0x516133),this[_0x43951f(0x514)+_0x43951f(0x6da)]();},VisuMZ['BattleCore']['Window_Bat'+'tleLog_per'+_0xe90fac(0x8f2)+_0xe90fac(0x737)]=Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0xd0d)+'stitute'],Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0xd0d)+_0xe90fac(0x2ed)]=function(_0x2c4ced,_0x23d77b){const _0x89415=_0xe90fac;VisuMZ[_0x89415(0x118f)][_0x89415(0x8a0)+_0x89415(0x1a2)+_0x89415(0x8f2)+_0x89415(0x737)][_0x89415(0x351)](this,_0x2c4ced,_0x23d77b),this[_0x89415(0x514)+_0x89415(0x6da)]();},VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x8a0)+_0xe90fac(0x1a2)+_0xe90fac(0xa71)+'se']=Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x4a2)+_0xe90fac(0x65d)],Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x4a2)+_0xe90fac(0x65d)]=function(_0x163eef){const _0x453b75=_0xe90fac;VisuMZ['BattleCore'][_0x453b75(0x8a0)+_0x453b75(0x1a2)+'formCollap'+'se'][_0x453b75(0x351)](this,_0x163eef),this['callNextMe'+_0x453b75(0x6da)]();},Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x11af)+'tAnimation']=function(_0x29b8b6,_0x41357c){const _0x5ec282=_0xe90fac;_0x29b8b6[_0x5ec282(0x11af)+'tAnimation'](_0x41357c),this[_0x5ec282(0x514)+_0x5ec282(0x6da)]();},Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0xf6f)+_0xe90fac(0xc65)+'tion']=function(_0x47dc9a,_0x2d0d2c){const _0x2e7a30=_0xe90fac,_0x345ca5={'jzogy':function(_0x19ad5c,_0x323c6b){return _0x19ad5c<=_0x323c6b;}},_0x27ecf7=_0x47dc9a['attackAnim'+_0x2e7a30(0x15b6)]();_0x345ca5[_0x2e7a30(0xca0)](_0x27ecf7,-0x95*-0x33+0x1484+-0x3233)?SoundManager[_0x2e7a30(0x40d)+'ttack']():this[_0x2e7a30(0x10ae)+'Animation'](_0x2d0d2c,_0x27ecf7);},Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0xed1)+_0xe90fac(0x15b9)]=function(_0x469454,_0x2ffcf1,_0x308647){const _0x1bdb9d=_0xe90fac,_0x23d093=[_0x469454][_0x1bdb9d(0x67c)](_0x2ffcf1);for(const _0x292f7d of _0x23d093){if(!_0x292f7d)continue;_0x292f7d[_0x1bdb9d(0xd9)+'l'](_0x308647);}this[_0x1bdb9d(0x514)+'thod']();},Window_BattleLog['prototype'][_0xe90fac(0x1172)]=function(_0x2e4e2e){const _0x1d70f2=_0xe90fac;this[_0x1d70f2(0x961)]=_0x2e4e2e;},Window_BattleLog['prototype'][_0xe90fac(0xa08)+_0xe90fac(0x130a)]=function(_0x3e3691,_0x51f466){const _0x48bb96=_0xe90fac;for(const _0x243c8e of _0x3e3691){if(!_0x243c8e)continue;_0x243c8e[_0x48bb96(0xa08)+'ion'](_0x51f466);}this['callNextMe'+_0x48bb96(0x6da)]();},Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x107a)+'eToPoint']=function(_0x1856cf,_0x286517,_0x3253b6,_0x24396f,_0x4b43be,_0x3e5294){const _0x57f49f=_0xe90fac;_0x1856cf[_0x57f49f(0x37b)+_0x57f49f(0x975)](_0x286517,_0x3253b6,_0x24396f,_0x4b43be,_0x3e5294,-(0x824+0x1*-0x262+0x1*-0x5c1)),this[_0x57f49f(0x514)+_0x57f49f(0x6da)]();},Window_BattleLog['prototype'][_0xe90fac(0x107a)+_0xe90fac(0x3d0)]=function(_0x5d2e44,_0x53c6e9,_0x4bdc98,_0x3d2213,_0x45ddf1,_0x53e802,_0x2cc221){const _0x212f70=_0xe90fac,_0x5cd3f9={'QzopX':function(_0x3132bc,_0x205b64){return _0x3132bc>=_0x205b64;},'eIROS':function(_0x448fc6,_0xf24e83){return _0x448fc6/_0xf24e83;},'HwTzp':function(_0x3d1160,_0x3ea6cb){return _0x3d1160+_0x3ea6cb;}},_0x235197=Math[_0x212f70(0xeed)](..._0x53c6e9[_0x212f70(0x457)](_0x417229=>_0x417229[_0x212f70(0x81d)]()[_0x212f70(0x156)]-_0x417229[_0x212f70(0x81d)]()[_0x212f70(0x4a7)+'Width']()/(0x96a+0xd18*0x1+-0x5a0*0x4))),_0x59021f=Math[_0x212f70(0xd3e)](..._0x53c6e9['map'](_0x378ffa=>_0x378ffa[_0x212f70(0x81d)]()[_0x212f70(0x156)]+_0x378ffa[_0x212f70(0x81d)]()[_0x212f70(0x4a7)+'Width']()/(-0xa17*-0x3+-0x924+-0x151f))),_0x1545f8=Math[_0x212f70(0xeed)](..._0x53c6e9[_0x212f70(0x457)](_0x2a7571=>_0x2a7571[_0x212f70(0x81d)]()[_0x212f70(0x1098)]-_0x2a7571[_0x212f70(0x81d)]()[_0x212f70(0x4a7)+'Height']())),_0x31198d=Math[_0x212f70(0xd3e)](..._0x53c6e9['map'](_0x130f02=>_0x130f02[_0x212f70(0x81d)]()[_0x212f70(0x1098)])),_0x5bfa2e=_0x53c6e9['filter'](_0x107fd9=>_0x107fd9[_0x212f70(0xd83)]())[_0x212f70(0x1268)],_0x43c8df=_0x53c6e9[_0x212f70(0x55f)](_0x5b23aa=>_0x5b23aa[_0x212f70(0xb9a)]())[_0x212f70(0x1268)];let _0xb54ffc=0xe1e+0x84e+-0x166c,_0x2b7386=-0xb*-0x1a2+-0x1890+-0x69a*-0x1;if(_0x4bdc98[_0x212f70(0x3eb)](/front/i))_0xb54ffc=_0x5cd3f9[_0x212f70(0x7db)](_0x5bfa2e,_0x43c8df)?_0x235197:_0x59021f;else{if(_0x4bdc98[_0x212f70(0x3eb)](/middle/i))_0xb54ffc=_0x5cd3f9[_0x212f70(0x14fe)](_0x5cd3f9[_0x212f70(0x684)](_0x235197,_0x59021f),0x2b*-0x8c+-0x1*-0x1eb2+-0x72c),_0x2cc221=-(0xe12+0x5*0x529+-0x27de);else _0x4bdc98['match'](/back/i)&&(_0xb54ffc=_0x5cd3f9[_0x212f70(0x7db)](_0x5bfa2e,_0x43c8df)?_0x59021f:_0x235197);}if(_0x4bdc98[_0x212f70(0x3eb)](/head/i))_0x2b7386=_0x1545f8;else{if(_0x4bdc98[_0x212f70(0x3eb)](/center/i)){_0x2b7386=_0x5cd3f9[_0x212f70(0x14fe)](_0x5cd3f9[_0x212f70(0x684)](_0x1545f8,_0x31198d),-0x222c+0xf5*-0x3+-0x7*-0x54b);if(_0x5d2e44[_0x212f70(0x81d)]())_0x2b7386+=_0x5cd3f9[_0x212f70(0x14fe)](_0x5d2e44['battler']()[_0x212f70(0xa68)],0x1*-0x189e+0x362*0x4+-0xb18*-0x1);}else _0x4bdc98['match'](/base/i)&&(_0x2b7386=_0x31198d);}_0x5d2e44[_0x212f70(0x37b)+_0x212f70(0x975)](_0xb54ffc,_0x2b7386,_0x3d2213,_0x45ddf1,_0x53e802,_0x2cc221),this[_0x212f70(0x514)+_0x212f70(0x6da)]();},Window_BattleLog[_0xe90fac(0x510)][_0xe90fac(0x788)+'p']=function(_0x4fd390,_0x2a021a,_0x12c704){const _0x15d68c=_0xe90fac;for(const _0x2dddbc of _0x4fd390){if(!_0x2dddbc)continue;_0x2dddbc[_0x15d68c(0x15f3)+'r'](_0x2a021a,_0x12c704);}this[_0x15d68c(0x514)+_0x15d68c(0x6da)]();};function Window_BattleMultiTarget(){const _0x249537=_0xe90fac;this[_0x249537(0xc68)](...arguments);}Window_BattleMultiTarget[_0xe90fac(0x510)]=Object[_0xe90fac(0xc3d)](Window_Command[_0xe90fac(0x510)]),Window_BattleMultiTarget[_0xe90fac(0x510)][_0xe90fac(0x14c0)+'r']=Window_BattleMultiTarget,VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x281)][_0xe90fac(0x1054)+'t']=VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x281)][_0xe90fac(0x1054)+'t']||{},Window_BattleMultiTarget[_0xe90fac(0xf70)]=VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x281)][_0xe90fac(0x1054)+'t'][_0xe90fac(0x3a9)+'h']??-0x214b+-0x6be*-0x1+0x1ba5,Window_BattleMultiTarget['BG_TYPE']=VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x281)][_0xe90fac(0x1054)+'t']['BgType']??-0x368+-0x199a+-0xe82*-0x2,Window_BattleMultiTarget['SHOW_BUTTO'+'N']=VisuMZ[_0xe90fac(0x118f)]['Settings'][_0xe90fac(0x1054)+'t'][_0xe90fac(0x4bb)]??!![],Window_BattleMultiTarget['ALL_ACTORS']=VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x281)][_0xe90fac(0x1054)+'t'][_0xe90fac(0xeb)+_0xe90fac(0x1270)]??_0xe90fac(0xa5b),Window_BattleMultiTarget[_0xe90fac(0x7b1)+'S']=VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x281)][_0xe90fac(0x1054)+'t'][_0xe90fac(0x995)+'Text']??'All\x20Enemie'+'s',Window_BattleMultiTarget[_0xe90fac(0x15d)+_0xe90fac(0x107d)]=VisuMZ['BattleCore'][_0xe90fac(0x281)][_0xe90fac(0x1054)+'t'][_0xe90fac(0x89c)+'tX']??-0xc77*-0x3+0x1*0xf43+0x1a54*-0x2,Window_BattleMultiTarget['ACTOR_OFFS'+_0xe90fac(0x1466)]=VisuMZ['BattleCore'][_0xe90fac(0x281)][_0xe90fac(0x1054)+'t'][_0xe90fac(0x89c)+'tY']??-0xd2b+0x213+0xb18,Window_BattleMultiTarget[_0xe90fac(0xeba)+_0xe90fac(0x107d)]=VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x281)][_0xe90fac(0x1054)+'t'][_0xe90fac(0x23e)+'tX']??-0x1*0x1a23+0x1bce*-0x1+-0x3*-0x11fb,Window_BattleMultiTarget['ENEMY_OFFS'+_0xe90fac(0x1466)]=VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x281)][_0xe90fac(0x1054)+'t']['EnemyOffse'+'tY']??0x28f*0x6+0x42e*-0x4+0x15e,Window_BattleMultiTarget['prototype'][_0xe90fac(0xc68)]=function(_0x438bef,_0xab874f){const _0x5876d9=_0xe90fac,_0x5a76d7={'CTLwi':_0x5876d9(0x14b8)+'3'},_0x3ece63=_0x5a76d7[_0x5876d9(0xa28)][_0x5876d9(0xab1)]('|');let _0x2af664=0x8b4*0x1+0x4b*0x11+-0xdaf;while(!![]){switch(_0x3ece63[_0x2af664++]){case'0':this[_0x5876d9(0x54c)+_0x5876d9(0x2f4)](Window_BattleMultiTarget[_0x5876d9(0x706)]);continue;case'1':Window_Command['prototype'][_0x5876d9(0xc68)]['call'](this,_0x438bef);continue;case'2':this[_0x5876d9(0x783)]();continue;case'3':this[_0x5876d9(0x120e)]();continue;case'4':this[_0x5876d9(0x150b)]();continue;case'5':this[_0x5876d9(0xd8)]=_0xab874f;continue;}break;}},Window_BattleMultiTarget[_0xe90fac(0x510)][_0xe90fac(0x11a3)]=function(){const _0x55f4ea=_0xe90fac;return this[_0x55f4ea(0xd8)];},Window_BattleMultiTarget[_0xe90fac(0x510)][_0xe90fac(0x648)+_0xe90fac(0x8e0)]=function(){const _0x3e7832=_0xe90fac,_0x54a120={'CqxtV':'pagedown','zHcvl':'pageup','QUcNQ':_0x3e7832(0xcdf)};let _0x1c56ca=this[_0x3e7832(0x11a3)]()?Window_BattleMultiTarget[_0x3e7832(0x2d7)]:Window_BattleMultiTarget[_0x3e7832(0x7b1)+'S'];if(Imported[_0x3e7832(0x155e)+_0x3e7832(0x100d)]&&Window_BattleMultiTarget[_0x3e7832(0x4d6)+'N']){this[_0x3e7832(0x1475)]=this[_0x3e7832(0x11a3)]()?_0x54a120[_0x3e7832(0x1134)]:_0x54a120[_0x3e7832(0xe6c)],this[_0x3e7832(0x15d9)+'t']=TextManager['getInputBu'+_0x3e7832(0x479)](this[_0x3e7832(0x1475)]);const _0x79b407=VisuMZ['CoreEngine'][_0x3e7832(0x281)][_0x3e7832(0xf4e)+'st'][_0x3e7832(0xc32)];_0x1c56ca=_0x79b407[_0x3e7832(0xeb8)](this[_0x3e7832(0x15d9)+'t'],_0x1c56ca);}this['addCommand'](_0x1c56ca,_0x54a120[_0x3e7832(0x74e)]);},Window_BattleMultiTarget[_0xe90fac(0x510)][_0xe90fac(0x3bf)]=function(_0x2c6bd7){const _0x4c41b3=_0xe90fac,_0x123a8c={'ftcVj':function(_0x5e4659,_0x3b3320){return _0x5e4659+_0x3b3320;},'CqkXj':function(_0x323bd0,_0x216d05){return _0x323bd0/_0x216d05;},'mYSww':function(_0x53da14,_0x15fb52){return _0x53da14-_0x15fb52;}},_0xddd458=this[_0x4c41b3(0x789)+'ct'](_0x2c6bd7);this[_0x4c41b3(0x4a4)+_0x4c41b3(0xb21)](),this['changePain'+_0x4c41b3(0x264)](this['isCommandE'+'nabled'](_0x2c6bd7));const _0x2f8379=this['commandNam'+'e'](_0x2c6bd7),_0x347373=this['textSizeEx'](_0x2f8379)[_0x4c41b3(0x301)],_0x15f5f6=_0x123a8c[_0x4c41b3(0xd5e)](_0xddd458['x'],Math[_0x4c41b3(0x12be)](_0x123a8c['CqkXj'](_0x123a8c['mYSww'](_0xddd458['width'],_0x347373),0x1241+-0x2*0x38f+-0xb21)));this[_0x4c41b3(0x1002)](_0x2f8379,_0x15f5f6,_0xddd458['y'],_0xddd458['width']);},Window_BattleMultiTarget[_0xe90fac(0x510)]['update']=function(){const _0x572ef6=_0xe90fac;Window_Command['prototype'][_0x572ef6(0x94)][_0x572ef6(0x351)](this),this[_0x572ef6(0x132b)+_0x572ef6(0x1107)](),this[_0x572ef6(0x80c)+'oardKeys']();},Window_BattleMultiTarget[_0xe90fac(0x510)][_0xe90fac(0x132b)+_0xe90fac(0x1107)]=function(){const _0x4db2e0=_0xe90fac;this[_0x4db2e0(0xf56)]=this[_0x4db2e0(0x1301)+_0x4db2e0(0x11fa)]();},Window_BattleMultiTarget[_0xe90fac(0x510)]['visibility'+_0xe90fac(0x11fa)]=function(){const _0x3c8c8c=_0xe90fac,_0x367969=BattleManager['inputtingA'+'ction'](),_0x404737=_0x367969&&_0x367969[_0x3c8c8c(0xaa1)+'rMultipleS'+'elect']();if(!_0x404737)return![];const _0x419e8f=SceneManager[_0x3c8c8c(0x11dd)];if(this['forActor']()){if(_0x419e8f[_0x3c8c8c(0xfb)+'ow'][_0x3c8c8c(0xd66)]&&_0x419e8f['_actorWind'+'ow'][_0x3c8c8c(0xa85)][_0x3c8c8c(0x153b)])return!![];if(_0x419e8f[_0x3c8c8c(0x356)+'ow'][_0x3c8c8c(0xd66)]&&_0x419e8f['_enemyWind'+'ow'][_0x3c8c8c(0xa85)][_0x3c8c8c(0x153b)])return!![];}else{if(_0x419e8f[_0x3c8c8c(0x356)+'ow'][_0x3c8c8c(0xd66)]&&_0x419e8f[_0x3c8c8c(0x356)+'ow'][_0x3c8c8c(0xa85)][_0x3c8c8c(0x93c)])return!![];}return![];},Window_BattleMultiTarget[_0xe90fac(0x510)][_0xe90fac(0x80c)+_0xe90fac(0xbc9)]=function(){const _0x5e710d=_0xe90fac,_0x4d20d6={'IFeXW':function(_0x55387b,_0x52441d){return _0x55387b!==_0x52441d;}};if(!Imported[_0x5e710d(0x155e)+'oreEngine'])return;_0x4d20d6['IFeXW'](this[_0x5e710d(0x15d9)+'t'],TextManager['getInputBu'+_0x5e710d(0x479)](this[_0x5e710d(0x1475)]))&&this[_0x5e710d(0x944)]();},Window_BattleMultiTarget[_0xe90fac(0x510)]['processTou'+'ch']=function(){const _0x501aa3=_0xe90fac,_0xdab8c3={'WHcux':function(_0x42e2f5,_0x479305){return _0x42e2f5>=_0x479305;},'TJQkt':_0x501aa3(0x153b),'HudFN':_0x501aa3(0x93c)};if(this[_0x501aa3(0xf56)]&&TouchInput['isClicked']()){const _0x3783d5=this[_0x501aa3(0x10bd)]();if(_0xdab8c3[_0x501aa3(0x3c1)](_0x3783d5,0x2*0x103c+0x10ad+-0x3125)){const _0x2b7513=this[_0x501aa3(0x11a3)]()?_0xdab8c3[_0x501aa3(0x129c)]:_0xdab8c3[_0x501aa3(0x1418)];Input['virtualCli'+'ck'](_0x2b7513);}}};function Window_DamageCounter(){const _0xc96151=_0xe90fac;this[_0xc96151(0xc68)](...arguments);}Window_DamageCounter[_0xe90fac(0x510)]=Object['create'](Window_Base[_0xe90fac(0x510)]),Window_DamageCounter['prototype'][_0xe90fac(0x14c0)+'r']=Window_DamageCounter,Window_DamageCounter[_0xe90fac(0x3d1)]={'enabled':VisuMZ[_0xe90fac(0x118f)]['Settings'][_0xe90fac(0xd7f)+'w'][_0xe90fac(0x159b)]??!![],'customFontFace':VisuMZ['BattleCore']['Settings'][_0xe90fac(0xd7f)+'w'][_0xe90fac(0xd0f)+_0xe90fac(0x2c3)]??'','textAlign':VisuMZ[_0xe90fac(0x118f)]['Settings'][_0xe90fac(0xd7f)+'w'][_0xe90fac(0xd6)]??_0xe90fac(0x1369),'hitsDmgFmt':VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x281)]['ComboWindo'+'w'][_0xe90fac(0x35b)]??'\x5cC[6]%1\x5c}\x20'+'\x5cC[4]Hit\x20C'+_0xe90fac(0x427),'hitsHealFmt':VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x281)][_0xe90fac(0xd7f)+'w'][_0xe90fac(0xb11)+'t']??_0xe90fac(0x433)+_0xe90fac(0x14db)+_0xe90fac(0x1451),'totalDmgFmt':VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x281)][_0xe90fac(0xd7f)+'w'][_0xe90fac(0x1109)+'t']??_0xe90fac(0xb82)+_0xe90fac(0x4a6)+':\x20\x5c{\x5cC[0]%'+'1','totalHealFmt':VisuMZ['BattleCore']['Settings']['ComboWindo'+'w'][_0xe90fac(0x14e1)+'mt']??'\x5c}\x5cC[21]To'+_0xe90fac(0xb02)+'g:\x20\x5c{\x5cC[24'+_0xe90fac(0x14c6),'fadeShiftX':VisuMZ[_0xe90fac(0x118f)]['Settings'][_0xe90fac(0xd7f)+'w'][_0xe90fac(0x5e8)]??-(0x1119*-0x2+-0x2175+0x43a9*0x1),'fadeShiftY':VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x281)]['ComboWindo'+'w']['fadeShiftY']??-0x1*0x2137+0x8b+-0x20ac*-0x1,'positionOffsetX':VisuMZ['BattleCore'][_0xe90fac(0x281)][_0xe90fac(0xd7f)+'w'][_0xe90fac(0x2c9)]??0x10ed+0x1*0xda1+-0x2*0xf47,'positionOffsetY':VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x281)][_0xe90fac(0xd7f)+'w'][_0xe90fac(0x7a7)]??-0x15e*0x17+0x1eb5+-0x1b*-0x7,'updateDuration':VisuMZ['BattleCore'][_0xe90fac(0x281)][_0xe90fac(0xd7f)+'w'][_0xe90fac(0xf7d)+_0xe90fac(0x1580)]??-0x184b+-0x1*0x2504+0x3d63,'minimumStayDuration':VisuMZ['BattleCore'][_0xe90fac(0x281)][_0xe90fac(0xd7f)+'w']['minimumSta'+_0xe90fac(0x9e)]??0x163e+0x1*0x1bcb+-0x31e1,'minimumHits':VisuMZ['BattleCore'][_0xe90fac(0x281)]['ComboWindo'+'w'][_0xe90fac(0x11c7)+'s']??-0xb2b+-0x4f*-0x61+0x3*-0x641,'opacitySpeed':VisuMZ[_0xe90fac(0x118f)][_0xe90fac(0x281)][_0xe90fac(0xd7f)+'w'][_0xe90fac(0x153a)+'ed']??0x2*0x9fd+-0x2*-0x110b+0xd80*-0x4},Window_DamageCounter['prototype'][_0xe90fac(0xc68)]=function(_0x566d09){const _0xea8664=_0xe90fac,_0x4bd1cb={'oiNAK':'2|4|5|1|0|'+'3'},_0x2717fc=_0x4bd1cb[_0xea8664(0x173)][_0xea8664(0xab1)]('|');let _0x3b2b3e=0x7a8+-0xf2*0x11+0x86a;while(!![]){switch(_0x2717fc[_0x3b2b3e++]){case'0':this[_0xea8664(0xc79)+'er']();continue;case'1':this[_0xea8664(0xe0)]=_0x566d09['y'];continue;case'2':this[_0xea8664(0x5b4)+_0xea8664(0x796)]=0xd46+0x13b7+-0x20fd;continue;case'3':this[_0xea8664(0x54c)+'undType'](0x1956+-0x1*0xaed+-0xe67);continue;case'4':Window_Base['prototype'][_0xea8664(0xc68)][_0xea8664(0x351)](this,_0x566d09);continue;case'5':this[_0xea8664(0xcbf)]=_0x566d09['x'];continue;}break;}},Window_DamageCounter[_0xe90fac(0x510)][_0xe90fac(0xc79)+'er']=function(){const _0x1fbac9=_0xe90fac,_0x57bdaf={'lnBCy':'1|4|2|0|3'},_0x4ab19a=_0x57bdaf[_0x1fbac9(0x14de)][_0x1fbac9(0xab1)]('|');let _0x3e9e46=-0x2f*-0xb9+0x1166+0x1b*-0x1e7;while(!![]){switch(_0x4ab19a[_0x3e9e46++]){case'0':this[_0x1fbac9(0x78e)+'s']=0xe8*-0x8+-0x1707+0x1e47;continue;case'1':this[_0x1fbac9(0xe43)+_0x1fbac9(0x1094)]=0x47*-0x60+0x1*0x25c3+0x1*-0xb23;continue;case'2':this[_0x1fbac9(0x1086)+'ge']=-0x1935+0x1da5+-0x47*0x10;continue;case'3':this['_targetDam'+_0x1fbac9(0x154d)]=-0x5*0x39d+-0x3c8*0x1+-0x7*-0x31f;continue;case'4':this[_0x1fbac9(0x15dd)]=0x7*0x215+-0x1783*-0x1+-0x2616;continue;}break;}},Window_DamageCounter['prototype'][_0xe90fac(0x160c)+_0xe90fac(0x29c)]=function(){const _0x2e3e6=_0xe90fac;Window_Base[_0x2e3e6(0x510)][_0x2e3e6(0x160c)+_0x2e3e6(0x29c)]['call'](this);const _0x200efa=Window_DamageCounter[_0x2e3e6(0x3d1)];_0x200efa[_0x2e3e6(0xb7b)+'Face']?this[_0x2e3e6(0x141e)][_0x2e3e