//=============================================================================
// VisuStella MZ - Items & Equips Core
// VisuMZ_1_ItemsEquipsCore.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_1_ItemsEquipsCore = true;

var VisuMZ = VisuMZ || {};
VisuMZ.ItemsEquipsCore = VisuMZ.ItemsEquipsCore || {};
VisuMZ.ItemsEquipsCore.version = 1.53;

//=============================================================================
/* ----------------------------------------------------------------------------
 * Item Menu Scene Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ItemScene:
 *
 * @param General
 *
 * @param EnableLayout:eval
 * @text Use Updated Layout
 * @parent General
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use the Updated Item Menu Layout provided by this plugin?
 * This will override the Core Engine windows settings.
 * @default true
 *
 * @param LayoutStyle:str
 * @text Layout Style
 * @parent General
 * @type select
 * @option Upper Help, Left Input
 * @value upper/left
 * @option Upper Help, Right Input
 * @value upper/right
 * @option Lower Help, Left Input
 * @value lower/left
 * @option Lower Help, Right Input
 * @value lower/right
 * @desc If using an updated layout, how do you want to style
 * the menu scene layout?
 * @default upper/left
 *
 * @param ListWindow
 * @text List Window
 *
 * @param ListWindowCols:num
 * @text Columns
 * @parent ListWindow
 * @type number
 * @min 1
 * @desc Number of maximum columns.
 * @default 1
 *
 * @param ItemQt
 * @text Item Quantity
 *
 * @param MaxItems:num
 * @text Item Max
 * @parent ItemQt
 * @desc The default maximum quantity for items.
 * @default 99
 *
 * @param MaxWeapons:num
 * @text Weapon Max
 * @parent ItemQt
 * @desc The default maximum quantity for weapons.
 * @default 99
 *
 * @param MaxArmors:num
 * @text Armor Max
 * @parent ItemQt
 * @desc The default maximum quantity for armors.
 * @default 99
 *
 * @param ItemQuantityFmt:str
 * @text Quantity Format
 * @parent ItemQt
 * @desc How to display an item's quantity.
 * %1 - Item Quantity
 * @default ×%1
 *
 * @param ItemQuantityFontSize:num
 * @text Font Size
 * @parent ItemQt
 * @desc Default font size for item quantity.
 * @default 22
 *
 * @param ShopStatusWindow
 * @text Shop Status Window
 *
 * @param ShowShopStatus:eval
 * @text Show in Item Menu?
 * @parent ShopStatusWindow
 * @type boolean
 * @on Show
 * @off Don't Show
 * @desc Show the Shop Status Window in the Item Menu?
 * This is enabled if the Updated Layout is on.
 * @default true
 *
 * @param ItemSceneAdjustItemList:eval
 * @text Adjust List Window?
 * @parent ShopStatusWindow
 * @type boolean
 * @on Adjust
 * @off Don't
 * @desc Automatically adjust the Item List Window in the Item Menu if using the Shop Status Window?
 * @default true
 *
 * @param ItemMenuStatusBgType:num
 * @text Background Type
 * @parent ShopStatusWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param ItemMenuStatusRect:func
 * @text JS: X, Y, W, H
 * @parent ShopStatusWindow
 * @type note
 * @desc Code used to determine the dimensions for this Status Window in the Item Menu.
 * @default "const width = this.statusWidth();\nconst height = this._itemWindow.height;\nconst x = Graphics.boxWidth - width;\nconst y = this._itemWindow.y;\nreturn new Rectangle(x, y, width, height);"
 *
 * @param ButtonAssist
 * @text Button Assist Window
 *
 * @param buttonAssistCategory:str
 * @text Switch Category
 * @parent ButtonAssist
 * @desc Button assist text used for switching categories.
 * For VisuStella MZ's Core Engine's Button Assist Window.
 * @default Switch Category
 *
 */
/* ----------------------------------------------------------------------------
 * Item Categories
 * ----------------------------------------------------------------------------
 */
/*~struct~Categories:
 *
 * @param MainList
 * @text List
 * 
 * @param List:arraystruct
 * @text Category List
 * @parent MainList
 * @type struct<Category>[]
 * @desc A list of the item categories displayed in the Item/Shop menus.
 * @default ["{\"Type:str\":\"RegularItems\",\"Icon:num\":\"208\"}","{\"Type:str\":\"AllWeapons\",\"Icon:num\":\"97\"}","{\"Type:str\":\"AllArmors\",\"Icon:num\":\"137\"}","{\"Type:str\":\"KeyItems\",\"Icon:num\":\"195\"}"]
 *
 * @param Style:str
 * @text Category Style
 * @parent MainList
 * @type select
 * @option Text Only
 * @value text
 * @option Icon Only
 * @value icon
 * @option Icon + Text
 * @value iconText
 * @option Automatic
 * @value auto
 * @desc How do you wish to draw categorie entries in the Category Window?
 * @default icon
 *
 * @param TextAlign:str
 * @text Text Alignment
 * @parent MainList
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Decide how you want the text to be aligned.
 * @default center
 *
 * @param Vocabulary
 *
 * @param HiddenItemA:str
 * @text Hidden Item A
 * @parent Vocabulary
 * @desc How this category is named in the Item Menu.
 * @default Special Items
 *
 * @param HiddenItemB:str
 * @text Hidden Item B
 * @parent Vocabulary
 * @desc How this category is named in the Item Menu.
 * @default Unique Items
 *
 * @param Consumable:str
 * @text Consumable
 * @parent Vocabulary
 * @desc How this category is named in the Item Menu.
 * @default Consumable
 *
 * @param Nonconsumable:str
 * @text Nonconsumable
 * @parent Vocabulary
 * @desc How this category is named in the Item Menu.
 * @default Nonconsumable
 *
 * @param AlwaysUsable:str
 * @text Always Usable
 * @parent Vocabulary
 * @desc How this category is named in the Item Menu.
 * @default Usable
 *
 * @param BattleUsable:str
 * @text Battle Usable
 * @parent Vocabulary
 * @desc How this category is named in the Item Menu.
 * @default Battle
 *
 * @param FieldUsable:str
 * @text Field Usable
 * @parent Vocabulary
 * @desc How this category is named in the Item Menu.
 * @default Field
 *
 * @param NeverUsable:str
 * @text Never Usable
 * @parent Vocabulary
 * @desc How this category is named in the Item Menu.
 * @default Materials
 *
 */
/* ----------------------------------------------------------------------------
 * Category Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Category:
 *
 * @param Type:str
 * @text Type
 * @type combo
 * @option AllItems
 * @option 
 * @option RegularItems
 * @option KeyItems
 * @option HiddenItemA
 * @option HiddenItemB
 * @option 
 * @option Consumable
 * @option Nonconsumable
 * @option 
 * @option AlwaysUsable
 * @option BattleUsable
 * @option FieldUsable
 * @option NeverUsable
 * @option 
 * @option AllWeapons
 * @option WType:x
 * @option 
 * @option AllArmors
 * @option AType:x
 * @option 
 * @option EType:x
 * @option 
 * @option Category:x
 * @option
 * @desc A list of the item categories displayed in the Item/Shop
 * menus. Replace x with ID numbers or text.
 * @default RegularItems
 *
 * @param Icon:num
 * @text Icon
 * @desc Icon used for this category.
 * Use 0 for no icon.
 * @default 0
 *
 * @param SwitchID:num
 * @text Visibility Switch
 * @type switch
 * @desc This Switch must be turned ON in order for the category to show.
 * Use 0 for no Switch requirement.
 * @default 0
 *
 * @param SortBy:str
 * @text Sorted By
 * @type select
 * @option ID
 * @option Name
 * @desc Sort this category (in Scene_Item and Scene_Shop only) this way.
 * @default ID
 *
 */
/* ----------------------------------------------------------------------------
 * New Label Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~NewLabel:
 *
 * @param Enable:eval
 * @text Use NEW! Labels?
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use the NEW! Labels or not?
 * @default true
 *
 * @param Icon:num
 * @text Icon
 * @desc The icon index used to represent the NEW! text.
 * Use 0 to not draw any icons.
 * @default 0
 *
 * @param Text:str
 * @text Text
 * @desc The text written on the NEW! Label.
 * @default NEW!
 *
 * @param FontColor:str
 * @text Font Color
 * @parent Text:str
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 17
 *
 * @param FontFace:str
 * @text Font Face
 * @parent Text:str
 * @desc Font face used for the NEW! Label.
 * @default Verdana
 *
 * @param FontSize:str
 * @text Font Size
 * @parent Text:str
 * @desc The font size used for the NEW! text.
 * @default 16
 *
 * @param FadeLimit:num
 * @text Fade Limit
 * @desc What's the upper opaque limit before reversing?
 * @default 360
 *
 * @param FadeSpeed:num
 * @text Fade Speed
 * @desc What's the fade speed of the NEW! Label?
 * @default 4
 *
 * @param OffsetX:num
 * @text Offset X
 * @desc How much to offset the NEW! Label's X position by.
 * @default 0
 *
 * @param OffsetY:num
 * @text Offset Y
 * @desc How much to offset the NEW! Label's Y position by.
 * @default 4
 *
 */
/* ----------------------------------------------------------------------------
 * Equip Menu Scene Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~EquipScene:
 *
 * @param General
 *
 * @param EnableLayout:eval
 * @text Use Updated Layout
 * @parent General
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use the Updated Equip Layout provided by this plugin?
 * This will override the Core Engine windows settings.
 * @default true
 *
 * @param LayoutStyle:str
 * @text Layout Style
 * @parent General
 * @type select
 * @option Upper Help, Left Input
 * @value upper/left
 * @option Upper Help, Right Input
 * @value upper/right
 * @option Lower Help, Left Input
 * @value lower/left
 * @option Lower Help, Right Input
 * @value lower/right
 * @desc If using an updated layout, how do you want to style
 * the menu scene layout?
 * @default upper/right
 *
 * @param ParamValueFontSize:num
 * @text Param Font Size
 * @parent EnableLayout:eval
 * @desc The font size used for parameter values.
 * @default 22
 *
 * @param MenuPortraits:eval
 * @text Show Menu Portraits?
 * @parent EnableLayout:eval
 * @type boolean
 * @on Use Portraits
 * @off Use Faces
 * @desc If Main Menu Core is installed, display the Menu Portraits
 * instead of the actor's face in the status window?
 * @default true
 *
 * @param DrawPortraitJS:func
 * @text JS: Portrait Upper
 * @parent EnableLayout:eval
 * @type note
 * @desc If Menu Portraits are available, this is code used to draw
 * the upper data like this in the Status Window.
 * @default "// Declare Variables\nconst lineHeight = this.lineHeight();\nconst padding = this.itemPadding();\nconst x1 = padding;\nconst x2 = this.innerWidth - 128 - padding;\n\n// Draw Menu Image\nthis.drawItemActorMenuImage(this._actor, 0, 0, this.innerWidth, this.innerHeight);\n\n// Draw Data\nthis.drawActorName(this._actor, x1, lineHeight * 0);\nthis.drawActorClass(this._actor, x1, lineHeight * 1);\nthis.drawActorIcons(this._actor, x1, lineHeight * 2);\nthis.drawActorLevel(this._actor, x2, lineHeight * 0);\nthis.placeBasicGauges(this._actor, x2, lineHeight * 1);"
 *
 * @param DrawFaceJS:func
 * @text JS: Face Upper
 * @parent EnableLayout:eval
 * @type note
 * @desc If faces used used, this is code used to draw the upper
 * data like this in the Status Window.
 * @default "// Declare Variables\nconst lineHeight = this.lineHeight();\nconst gaugeLineHeight = this.gaugeLineHeight();\nconst x = Math.floor(this.innerWidth / 2);\nconst limitHeight = this.innerHeight - (this.actorParams().length * lineHeight);\nconst actorX = Math.floor((x - ImageManager.faceWidth) / 2);\nconst actorY = Math.max(0, Math.floor((limitHeight - ImageManager.faceHeight) / 2));\nlet dataHeight = lineHeight * 3;\ndataHeight += gaugeLineHeight * ($dataSystem.optDisplayTp ? 3 : 2);\nconst dataY = Math.max(0, Math.floor((limitHeight - dataHeight) / 2));\n\n// Draw Data\nthis.drawActorFace(this._actor, actorX, actorY, ImageManager.faceWidth, ImageManager.faceHeight);\nthis.drawActorIcons(this._actor, actorX + 16, actorY + ImageManager.faceHeight - lineHeight);\nthis.drawActorName(this._actor, x, dataY + lineHeight * 0);\nthis.drawActorLevel(this._actor, x, dataY + lineHeight * 1);\nthis.drawActorClass(this._actor, x, dataY + lineHeight * 2);\nthis.placeBasicGauges(this._actor, x, dataY + lineHeight * 3);"
 *
 * @param DrawParamJS:func
 * @text JS: Parameter Lower
 * @parent EnableLayout:eval
 * @type note
 * @desc Code to determine how parameters are drawn in the
 * Status Window.
 * @default "// Declare variables\nconst params = this.actorParams();\nconst lineHeight = this.lineHeight();\nconst padding = this.itemPadding();\nconst baseX = 0;\nconst baseY = this.innerHeight - params.length * lineHeight;\nconst baseWidth = this.innerWidth;\nconst valueFontSize = this.paramValueFontSize();\n\n// Calculate Widths\nlet paramNameWidth = Math.max(...params.map(param => this.textWidth(TextManager.param(param))));\nparamNameWidth += padding * 2;\nif (this.isUseParamNamesWithIcons()) {\n    paramNameWidth += ImageManager.iconWidth + 4;\n}\nlet arrowWidth = this.rightArrowWidth();\nconst totalDivides = this.innerWidth >= 500 ? 3 : 2;\nlet paramValueWidth = Math.floor((baseWidth - paramNameWidth - arrowWidth) / totalDivides);\nparamNameWidth = baseWidth - (paramValueWidth * totalDivides) - arrowWidth;\n\n// Draw Parameters\nlet x = baseX;\nlet y = baseY;\nlet value = 0;\nlet diffValue = 0;\nlet alter = 2;\nfor (const paramId of params) {\n    // Draw Param Name\n    this.drawItemDarkRect(x, y, paramNameWidth, lineHeight, alter);\n    this.drawUpdatedParamName(paramId, x, y, paramNameWidth);\n    this.resetFontSettings();\n    x += paramNameWidth;\n\n    // Draw Param Before\n    this.contents.fontSize = valueFontSize;\n    this.drawItemDarkRect(x, y, paramValueWidth, lineHeight, alter);\n    this.drawUpdatedBeforeParamValue(paramId, x, y, paramValueWidth);\n    this.resetFontSettings();\n    x += paramValueWidth;\n\n    // Draw Arrow\n    this.drawItemDarkRect(x, y, arrowWidth, lineHeight, alter);\n    this.drawRightArrow(x, y);\n    x += arrowWidth;\n\n    // Draw Param After\n    this.contents.fontSize = valueFontSize;\n    this.drawItemDarkRect(x, y, paramValueWidth, lineHeight, alter);\n    this.drawUpdatedAfterParamValue(paramId, x, y, paramValueWidth);\n    x += paramValueWidth;\n\n    // Draw Param Change\n    if (totalDivides > 2) {\n        this.drawItemDarkRect(x, y, paramValueWidth, lineHeight, alter);\n        this.drawUpdatedParamValueDiff(paramId, x, y, paramValueWidth);\n    }\n\n    // Prepare Next Parameter\n    x = baseX;\n    y += lineHeight;\n    alter = alter === 2 ? 1 : 2;\n}"
 *
 * @param StatusWindowWidth:num
 * @text Status Window Width
 * @parent General
 * @desc The usual width of the status window if using the 
 * non-Updated Equip Menu Layout.
 * @default 312
 *
 * @param DrawBackRect:eval
 * @text Show Back Rectangles?
 * @parent General
 * @type boolean
 * @on Draw
 * @off Don't Draw
 * @desc Show back rectangles of darker colors to display information better?
 * @default true
 *
 * @param BackRectColor:str
 * @text Back Rectangle Color
 * @parent DrawBackRect:eval
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 19
 *
 * @param CursedTextPopup:json
 * @text Cursed Equip Popup
 * @parent General
 * @type note
 * @desc %1 - Actor, %2 - Equip, %3 - Icon. Text codes allowed.
 * Requires VisuMZ_0_CoreEngine! Empty to not use.
 * @default "%1 is cursed by %3%2!"
 *
 * @param Command
 * @text Command Window
 *
 * @param CmdStyle:str
 * @text Style
 * @parent Command
 * @type select
 * @option Text Only
 * @value text
 * @option Icon Only
 * @value icon
 * @option Icon + Text
 * @value iconText
 * @option Automatic
 * @value auto
 * @desc How do you wish to draw commands in the Command Window?
 * @default auto
 *
 * @param CmdTextAlign:str
 * @text Text Align
 * @parent Command
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for the Command Window.
 * @default center
 *
 * @param CmdIconEquip:num
 * @text Equip Icon
 * @parent Command
 * @desc The icon used for the Equip command.
 * @default 136
 *
 * @param equipCmdDesc:json
 * @text Help Description
 * @parent CmdIconEquip:num
 * @type note
 * @desc Help description used when this command is selected.
 * Text codes allowed.
 * @default "Pick and choose equipment to change."
 *
 * @param CommandAddOptimize:eval
 * @text Add Optimize Command?
 * @parent Command
 * @type boolean
 * @on Add
 * @off Don't
 * @desc Add the "Optimize" command to the Command Window?
 * @default true
 *
 * @param optimizeCmdDesc:json
 * @text Help Description
 * @parent CommandAddOptimize:eval
 * @type note
 * @desc Help description used when this command is selected.
 * Text codes allowed.
 * @default "Equip the strongest available equipment."
 *
 * @param CmdIconOptimize:num
 * @text Optimize Icon
 * @parent CommandAddOptimize:eval
 * @desc The icon used for the Optimize command.
 * @default 137
 *
 * @param CommandAddClear:eval
 * @text Add Clear Command?
 * @parent Command
 * @type boolean
 * @on Add
 * @off Don't
 * @desc Add the "Clear" command to the Command Window?
 * @default true
 *
 * @param clearCmdDesc:json
 * @text Help Description
 * @parent CommandAddClear:eval
 * @type note
 * @desc Help description used when this command is selected.
 * Text codes allowed.
 * @default "Remove all available equipment."
 *
 * @param CmdIconClear:num
 * @text Clear Icon
 * @parent CommandAddClear:eval
 * @desc The icon used for the Clear command.
 * @default 135
 *
 * @param RemoveEquip
 * @text Remove Equip
 *
 * @param RemoveEquipIcon:num
 * @text Icon
 * @parent RemoveEquip
 * @desc Icon used for equipment removal.
 * @default 16
 *
 * @param RemoveEquipText:str
 * @text Text
 * @parent RemoveEquip
 * @desc Text used for equipment removal.
 * @default Remove
 *
 * @param ShiftShortcutKey:eval
 * @text Use SHIFT Shortcut?
 * @parent RemoveEquip
 * @type boolean
 * @on Use
 * @off Don't
 * @desc Add the "Shift" button as a shortcut key to removing items?
 * @default true

 * @param Rulings
 *
 * @param EquipAdjustHpMp:eval
 * @text Equip-Adjust HP/MP
 * @parent Rulings
 * @type boolean
 * @on Adjust
 * @off Don't
 * @desc Adjust HP/MP differences after changing equips with MaxHP/MaxMP values.
 * @default true
 * 
 * @param NonRemoveETypes:arraynum
 * @text Non-Removable Types
 * @parent Rulings
 * @type number[]
 * @min 1
 * @max 100
 * @desc Insert ID's of the Equipment Types that must always have
 * an item equipped and cannot be empty.
 * @default []
 *
 * @param NonOptimizeETypes:arraynum
 * @text Non-Optimized Types
 * @parent Rulings
 * @type number[]
 * @min 1
 * @max 100
 * @desc Insert ID's of the Equipment Types that will be ignored
 * when equipment is being optimized.
 * @default []
 *
 * @param ButtonAssist
 * @text Button Assist Window
 *
 * @param buttonAssistRemove:str
 * @text SHIFT: Remove
 * @parent ButtonAssist
 * @desc Button assist text used for the SHIFT Remove Shortcut.
 * For VisuStella MZ's Core Engine's Button Assist Window.
 * @default Unequip
 * 
 */
/* ----------------------------------------------------------------------------
 * Shop Menu Scene Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ShopScene:
 *
 * @param General
 *
 * @param EnableLayout:eval
 * @text Use Updated Layout
 * @parent General
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use the Updated Shop Layout provided by this plugin?
 * This will override the Core Engine windows settings.
 * @default true
 *
 * @param LayoutStyle:str
 * @text Layout Style
 * @parent General
 * @type select
 * @option Upper Help, Left Input
 * @value upper/left
 * @option Upper Help, Right Input
 * @value upper/right
 * @option Lower Help, Left Input
 * @value lower/left
 * @option Lower Help, Right Input
 * @value lower/right
 * @desc If using an updated layout, how do you want to style
 * the menu scene layout?
 * @default upper/left
 *
 * @param Switches
 *
 * @param SwitchBuy:num
 * @text Switch: Buy
 * @parent Switches
 * @type switch
 * @desc Buying items in the Shop Scene turns this Switch to ON.
 * Switch reverts to OFF whenever the Shop Scene opens.
 * @default 0
 *
 * @param SwitchSell:num
 * @text Switch: Sell
 * @parent Switches
 * @type switch
 * @desc Selling items in the Shop Scene turns this Switch to ON.
 * Switch reverts to OFF whenever the Shop Scene opens.
 * @default 0
 *
 * @param Command
 * @text Command Window
 *
 * @param CmdHideDisabled:eval
 * @text Hide Unavailable?
 * @parent Command
 * @type boolean
 * @on Hide
 * @off Default
 * @desc Hide all unavailable commands like when a shop is set to Purchase Only?
 * @default true
 *
 * @param CmdStyle:str
 * @text Style
 * @parent Command
 * @type select
 * @option Text Only
 * @value text
 * @option Icon Only
 * @value icon
 * @option Icon + Text
 * @value iconText
 * @option Automatic
 * @value auto
 * @desc How do you wish to draw commands in the Command Window?
 * @default auto
 *
 * @param CmdTextAlign:str
 * @text Text Align
 * @parent Command
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for the Command Window.
 * @default center
 *
 * @param CmdIconBuy:num
 * @text Buy Icon
 * @parent Command
 * @desc The icon used for the Buy command.
 * @default 208
 *
 * @param CmdIconSell:num
 * @text Sell Icon
 * @parent Command
 * @desc The icon used for the Sell command.
 * @default 314
 *
 * @param CmdIconCancel:num
 * @text Cancel Icon
 * @parent Command
 * @desc The icon used for the Cancel command.
 * @default 82
 *
 * @param CmdCancelRename:str
 * @text Rename "Cancel"
 * @parent Command
 * @desc Rename Cancel to something more logical for the Shop Menu Scene.
 * @default Exit
 *
 * @param Prices
 *
 * @param SellPriceRate:num
 * @text Sell Price Rate
 * @parent Prices
 * @desc The default sell price rate.
 * @default 0.50
 *
 * @param BuyPriceJS:func
 * @text JS: Buy Price
 * @parent Prices
 * @type note
 * @desc Modificatons made to the buy price before finalizing it.
 * @default "// Declare variables\nlet item = arguments[0];\nlet price = arguments[1];\n\n// Return the finalized price\nreturn price;"
 *
 * @param SellPriceJS:func
 * @text JS: Sell Price
 * @parent Prices
 * @type note
 * @desc Modificatons made to the sell price before finalizing it.
 * @default "// Declare variables\nlet item = arguments[0];\nlet price = arguments[1];\n\n// Return the finalized price\nreturn price;"
 * 
 * @param ButtonAssist
 * @text Button Assist Window
 *
 * @param buttonAssistSmallIncrement:str
 * @text Small Increment
 * @parent ButtonAssist
 * @desc Text used for changing amount bought/sold.
 * For VisuStella MZ's Core Engine's Button Assist Window.
 * @default -1/+1
 *
 * @param buttonAssistLargeIncrement:str
 * @text Large Increment
 * @parent ButtonAssist
 * @desc Text used for changing amount bought/sold.
 * For VisuStella MZ's Core Engine's Button Assist Window.
 * @default -10/+10
 *
 */
/* ----------------------------------------------------------------------------
 * Shop Status Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~StatusWindow:
 *
 * @param General
 *
 * @param Width:num
 * @text Window Width
 * @parent General
 * @desc The usual width of the status window.
 * @default 352
 *
 * @param ParamChangeFontSize:num
 * @text Parameter Font Size
 * @parent General
 * @desc Font size used for parameter changes.
 * @default 22
 *
 * @param Translucent:num
 * @text Translucent Opacity
 * @parent General
 * @desc Opacity setting used for translucent window objects.
 * @default 64
 *
 * @param DrawBackRect:eval
 * @text Show Back Rectangles?
 * @parent General
 * @type boolean
 * @on Draw
 * @off Don't Draw
 * @desc Show back rectangles of darker colors to display information better?
 * @default true
 *
 * @param BackRectColor:str
 * @text Back Rectangle Color
 * @parent DrawBackRect:eval
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 19
 *
 * @param EquipData
 * @text Equipment Data
 *
 * @param AlreadyEquipMarker:str
 * @text Already Equipped
 * @parent EquipData
 * @desc Marker used to show an actor cannot equip an item.
 * @default E
 *
 * @param CannotEquipMarker:str
 * @text Can't Equip
 * @parent EquipData
 * @desc Marker used to show an actor cannot equip an item.
 * @default -
 *
 * @param EquipDelayMS:num
 * @text Delay MS
 * @parent EquipData
 * @type number
 * @min 1
 * @max 999
 * @desc How many milliseconds (MS) to delay the preview update?
 * This is to prevent lag spikes for equips only.
 * @default 240
 *
 * @param NoChangeMarker:str
 * @text No Changes
 * @parent EquipData
 * @desc Marker used to show no changes have occurred.
 * @default -
 *
 * @param DrawEquipData:func
 * @text JS: Draw Equip Data
 * @parent EquipData
 * @type note
 * @desc Code used to draw the equipment data for the Shop Status Window.
 * @default "// Set Variables\nconst lineHeight = this.lineHeight();\nconst paramheight = this.gaugeLineHeight() + 8;\nlet x = 0;\nlet y = 0;\nlet width = this.innerWidth;\nlet height = this.innerHeight;\nlet hw = Math.floor(width / 2);\nlet hx = x + width - hw;\n\n// Draw Item Name, Type, and Quantity\nthis.drawItemName(this._item, x + this.itemPadding(), y, width - this.itemPadding() * 2);\nthis.drawItemDarkRect(x, y, width);\ny += lineHeight;\nif (this.drawItemEquipType(x, y, hw)) y += 0;\nif (this.drawItemQuantity(hx, y, hw)) y += lineHeight;\n\n// Draw Parameter Names\nconst params = this.actorParams();\nconst backY = y;\ny = height - (params.length * paramheight) - 4;\nlet paramX = x;\nlet paramWidth = 0;\nlet tableY = y;\nfor (const paramId of params) {\n    paramWidth = Math.max(this.drawParamName(paramId, x + 4, y + 4, width), paramWidth);\n    y += paramheight;\n}\n\n// Draw Actor Data\nconst actorMax = $gameParty.maxBattleMembers();\nconst actorWidth = Math.floor((width - paramWidth) / actorMax);\nparamWidth = width - (actorWidth * actorMax);\nfor (const actor of $gameParty.battleMembers()) {\n    const index = $gameParty.battleMembers().indexOf(actor);\n    const actorX = paramX + paramWidth + (index * actorWidth);\n    this.changePaintOpacity(actor.canEquip(this._item));\n    this.drawActorCharacter(actor, actorX + (actorWidth / 2), tableY);\n    let actorY = tableY;\n\n    // Draw Parameter Changes\n    for (const paramId of params) {\n        const diffY = actorY - ((lineHeight - paramheight) / 2);\n        this.drawActorParamDifference(actor, paramId, actorX, diffY, actorWidth);\n        actorY += paramheight;\n    }\n}\n\n// Draw Back Rectangles\nthis.drawItemDarkRect(paramX, backY, paramWidth, tableY - backY);\nfor (let i = 0; i < actorMax; i++) {\n    const actorX = paramX + paramWidth + (i * actorWidth);\n    this.drawItemDarkRect(actorX, backY, actorWidth, tableY - backY);\n}\nfor (const paramId of params) {\n    this.drawItemDarkRect(paramX, tableY, paramWidth, paramheight);\n    for (let i = 0; i < actorMax; i++) {\n        const actorX = paramX + paramWidth + (i * actorWidth);\n        this.drawItemDarkRect(actorX, tableY, actorWidth, paramheight);\n    }\n    tableY += paramheight;\n}"
 *
 * @param ItemData
 * @text Item Data
 *
 * @param ItemGeneral
 * @parent ItemData
 * @text Data Settings
 *
 * @param MaxIcons:num
 * @text Max State/Buff Icons
 * @parent ItemGeneral
 * @desc Maximum number of icons that can be displayed for Add/Remove States/Buffs.
 * @default 8
 *
 * @param MultiplierStandard:num
 * @text Multiplier Standard
 * @parent ItemGeneral
 * @desc Constant standard to filter out random values when calculating the damage multiplier.
 * @default 1000000
 *
 * @param DrawItemData:func
 * @text JS: Draw Item Data
 * @parent ItemGeneral
 * @type note
 * @desc Code used to draw the item data for the Shop Status Window.
 * @default "const lineHeight = this.lineHeight();\nlet x = 0;\nlet y = 0;\nlet width = this.innerWidth;\nlet height = this.innerHeight;\nlet hw = Math.floor(width / 2);\nlet hx = x + width - hw;\n\n// Draw Item Name and Quantity\nthis.drawItemName(this._item, x + this.itemPadding(), y, width - this.itemPadding() * 2);\nthis.drawItemDarkRect(x, y, width);\ny += lineHeight;\n\n// Draw Main Item Properties\nif (this.drawItemConsumable(x, y, hw)) y += 0;\nif (this.drawItemQuantity(hx, y, hw)) y += lineHeight;\nif (this._item.occasion < 3) {\n    y = this.drawItemDamage(x, y, width);\n    y = this.drawItemEffects(x, y, width);\n}\ny = this.drawItemCustomEntries(x, y, width);\n\n// Draw Remaining Item Properties\nif (this._item.occasion < 3) {\n    if (this.drawItemOccasion(x, y, hw)) y += 0;\n    if (this.drawItemScope(hx, y, hw)) y += lineHeight;\n    if (this.drawItemHitType(x, y, hw)) y += 0;\n    if (this.drawItemSuccessRate(hx, y, hw)) y += lineHeight;\n    if (this.drawItemSpeed(x, y, hw)) y += 0;\n    if (this.drawItemRepeats(hx, y, hw)) y += lineHeight;\n}\n\n// Fill Rest of the Window\nthis.drawItemDarkRect(x, y, width, height - y);"
 *
 * @param Vocabulary
 * @parent ItemData
 *
 * @param LabelConsume:str
 * @text Consumable
 * @parent Vocabulary
 * @desc Vocabulary used for this data entry.
 * @default Consumable
 *
 * @param Consumable:str
 * @text Yes
 * @parent LabelConsume:str
 * @desc Vocabulary used for this data entry.
 * @default ✔
 *
 * @param NotConsumable:str
 * @text No
 * @parent LabelConsume:str
 * @desc Vocabulary used for this data entry.
 * @default ✘
 *
 * @param Occasions
 * @parent Vocabulary
 *
 * @param Occasion0:str
 * @text Always
 * @parent Occasions
 * @desc Vocabulary used for this data entry.
 * @default Anytime Use
 *
 * @param Occasion1:str
 * @text Battle Screen
 * @parent Occasions
 * @desc Vocabulary used for this data entry.
 * @default Battle-Only
 *
 * @param Occasion2:str
 * @text Menu Screen
 * @parent Occasions
 * @desc Vocabulary used for this data entry.
 * @default Field-Only
 *
 * @param Occasion3:str
 * @text Never
 * @parent Occasions
 * @desc Vocabulary used for this data entry.
 * @default -
 *
 * @param Scope
 * @parent Vocabulary
 *
 * @param Scope0:str
 * @text None
 * @parent Scope
 * @desc Vocabulary used for this data entry.
 * @default No Target
 *
 * @param Scope1:str
 * @text 1 Enemy
 * @parent Scope
 * @desc Vocabulary used for this data entry.
 * @default 1 Foe
 *
 * @param Scope2:str
 * @text All Enemies
 * @parent Scope
 * @desc Vocabulary used for this data entry.
 * @default All Foes
 *
 * @param Scope3:str
 * @text 1 Random Enemy
 * @parent Scope
 * @desc Vocabulary used for this data entry.
 * @default Random Foe
 *
 * @param Scope4:str
 * @text 2 Random Enemies
 * @parent Scope
 * @desc Vocabulary used for this data entry.
 * @default 2 Random Foes
 *
 * @param Scope5:str
 * @text 3 Random Enemies
 * @parent Scope
 * @desc Vocabulary used for this data entry.
 * @default 3 Random Foes
 *
 * @param Scope6:str
 * @text 4 Random Enemies
 * @parent Scope
 * @desc Vocabulary used for this data entry.
 * @default 4 Random Foes
 *
 * @param Scope7:str
 * @text 1 Ally
 * @parent Scope
 * @desc Vocabulary used for this data entry.
 * @default 1 Ally
 *
 * @param Scope8:str
 * @text All Allies
 * @parent Scope
 * @desc Vocabulary used for this data entry.
 * @default Alive Allies
 *
 * @param Scope9:str
 * @text 1 Ally (Dead)
 * @parent Scope
 * @desc Vocabulary used for this data entry.
 * @default Dead Ally
 *
 * @param Scope10:str
 * @text All Allies (Dead)
 * @parent Scope
 * @desc Vocabulary used for this data entry.
 * @default Dead Allies
 *
 * @param Scope11:str
 * @text The User
 * @parent Scope
 * @desc Vocabulary used for this data entry.
 * @default User
 *
 * @param Scope12:str
 * @text 1 Ally (DoA)
 * @parent Scope
 * @desc Vocabulary used for this data entry.
 * @default Any Ally
 *
 * @param Scope13:str
 * @text All Allies (DoA)
 * @parent Scope
 * @desc Vocabulary used for this data entry.
 * @default All Allies
 *
 * @param Scope14:str
 * @text Enemies & Allies
 * @parent Scope
 * @desc Vocabulary used for this data entry.
 * @default Everybody
 *
 * @param BattleCore
 * @text Battle Core Support
 * @parent Vocabulary
 *
 * @param ScopeRandomAny:str
 * @text x Random Any
 * @parent BattleCore
 * @desc Vocabulary used for <Target: x Random Any> notetag.
 * @default %1 Random Units
 *
 * @param ScopeRandomEnemies:str
 * @text x Random Enemies
 * @parent BattleCore
 * @desc Vocabulary used for <Target: x Random Enemies> notetag.
 * @default %1 Random Foes
 *
 * @param ScopeRandomAllies:str
 * @text x Random Allies
 * @parent BattleCore
 * @desc Vocabulary used for <Target: x Random Allies> notetag.
 * @default %1 Random Allies
 *
 * @param ScopeAlliesButUser:str
 * @text All Allies But User
 * @parent BattleCore
 * @desc Vocabulary used for <Target: All Allies But User> notetag.
 * @default Other Allies
 *
 * @param ScopeAllyOrEnemy:str
 * @text Ally or Enemy
 * @parent BattleCore
 * @desc Vocabulary used for <Target: Ally or Enemy> notetag.
 * @default Ally/Enemy
 *
 * @param ScopeEnemyOrAlly:str
 * @text Enemy or Ally
 * @parent BattleCore
 * @desc Vocabulary used for <Target: Enemy or Ally> notetag.
 * @default Enemy/Ally
 *
 * @param LabelSpeed:str
 * @text Speed
 * @parent Vocabulary
 * @desc Vocabulary used for this data entry.
 * @default Speed
 *
 * @param Speed2000:str
 * @text >= 2000 Speed
 * @parent LabelSpeed:str
 * @desc Vocabulary used for this data entry.
 * @default Fastest
 *
 * @param Speed1000:str
 * @text >= 1000 Speed
 * @parent LabelSpeed:str
 * @desc Vocabulary used for this data entry.
 * @default Faster
 *
 * @param Speed1:str
 * @text >= 1 Speed
 * @parent LabelSpeed:str
 * @desc Vocabulary used for this data entry.
 * @default Fast
 *
 * @param Speed0:str
 * @text == 0 Speed
 * @parent LabelSpeed:str
 * @desc Vocabulary used for this data entry.
 * @default Normal
 *
 * @param SpeedNeg999:str
 * @text >= -999 Speed
 * @parent LabelSpeed:str
 * @desc Vocabulary used for this data entry.
 * @default Slow
 *
 * @param SpeedNeg1999:str
 * @text >= -1999 Speed
 * @parent LabelSpeed:str
 * @desc Vocabulary used for this data entry.
 * @default Slower
 *
 * @param SpeedNeg2000:str
 * @text <= -2000 Speed
 * @parent LabelSpeed:str
 * @desc Vocabulary used for this data entry.
 * @default Slowest
 *
 * @param LabelSuccessRate:str
 * @text Success Rate
 * @parent Vocabulary
 * @desc Vocabulary used for this data entry.
 * @default Accuracy
 *
 * @param LabelRepeats:str
 * @text Repeats
 * @parent Vocabulary
 * @desc Vocabulary used for this data entry.
 * @default Hits
 *
 * @param LabelHitType:str
 * @text Hit Type
 * @parent Vocabulary
 * @desc Vocabulary used for this data entry.
 * @default Type
 *
 * @param HitType0:str
 * @text Certain Hit
 * @parent LabelHitType:str
 * @desc Vocabulary used for this data entry.
 * @default Neutral
 *
 * @param HitType1:str
 * @text Physical
 * @parent LabelHitType:str
 * @desc Vocabulary used for this data entry.
 * @default Physical
 *
 * @param HitType2:str
 * @text Magical
 * @parent LabelHitType:str
 * @desc Vocabulary used for this data entry.
 * @default Magical
 *
 * @param LabelElement:str
 * @text Element
 * @parent Vocabulary
 * @desc Vocabulary used for this data entry.
 * @default Element
 *
 * @param ElementWeapon:str
 * @text Weapon-Based
 * @parent LabelElement:str
 * @desc Vocabulary used for this data entry.
 * @default \I[97]Weapon
 *
 * @param ElementNone:str
 * @text Nonelement Element
 * @parent LabelElement:str
 * @desc Vocabulary used for this data entry.
 * @default \I[160]No Element
 *
 * @param DamageType
 * @text Damage Type
 * @parent Vocabulary
 *
 * @param DamageType1:str
 * @text HP Damage
 * @parent DamageType
 * @desc Vocabulary used for this data entry. If Visu_1_BattleCore
 * is installed, priority goes to its Damage Style settings.
 * @default %1 Damage Multiplier
 *
 * @param DamageType2:str
 * @text MP Damage
 * @parent DamageType
 * @desc Vocabulary used for this data entry. If Visu_1_BattleCore
 * is installed, priority goes to its Damage Style settings.
 * @default %1 Damage Multiplier
 *
 * @param DamageType3:str
 * @text HP Recovery
 * @parent DamageType
 * @desc Vocabulary used for this data entry. If Visu_1_BattleCore
 * is installed, priority goes to its Damage Style settings.
 * @default %1 Recovery Multiplier
 *
 * @param DamageType4:str
 * @text MP Recovery
 * @parent DamageType
 * @desc Vocabulary used for this data entry. If Visu_1_BattleCore
 * is installed, priority goes to its Damage Style settings.
 * @default %1 Recovery Multiplier
 *
 * @param DamageType5:str
 * @text HP Drain
 * @parent DamageType
 * @desc Vocabulary used for this data entry. If Visu_1_BattleCore
 * is installed, priority goes to its Damage Style settings.
 * @default %1 Drain Multiplier
 *
 * @param DamageType6:str
 * @text MP Drain
 * @parent DamageType
 * @desc Vocabulary used for this data entry. If Visu_1_BattleCore
 * is installed, priority goes to its Damage Style settings.
 * @default %1 Drain Multiplier
 *
 * @param Effects
 * @parent Vocabulary
 *
 * @param LabelRecoverHP:str
 * @text Recover HP
 * @parent Effects
 * @desc Vocabulary used for this data entry.
 * @default %1 Recovery
 *
 * @param LabelRecoverMP:str
 * @text Recover MP
 * @parent Effects
 * @desc Vocabulary used for this data entry.
 * @default %1 Recovery
 *
 * @param LabelRecoverTP:str
 * @text Recover TP
 * @parent Effects
 * @desc Vocabulary used for this data entry.
 * @default %1 Recovery
 *
 * @param LabelSelfGainTP:str
 * @text Self Gain TP
 * @parent Effects
 * @desc Vocabulary used for this data entry.
 * @default User %1
 *
 * @param LabelDamageHP:str
 * @text Damage HP
 * @parent Effects
 * @desc Vocabulary used for this data entry.
 * @default %1 Damage
 *
 * @param LabelDamageMP:str
 * @text Damage MP
 * @parent Effects
 * @desc Vocabulary used for this data entry.
 * @default %1 Damage
 *
 * @param LabelDamageTP:str
 * @text Damage TP
 * @parent Effects
 * @desc Vocabulary used for this data entry.
 * @default %1 Damage
 *
 * @param LabelApply:str
 * @text Add State/Buff
 * @parent Effects
 * @desc Vocabulary used for this data entry.
 * @default Applies
 *
 * @param LabelRemove:str
 * @text Remove State/Buff
 * @parent Effects
 * @desc Vocabulary used for this data entry.
 * @default Removes
 *
 */
//=============================================================================

const _0x77d410=_0xebad;(function(_0x6d867c,_0x13adbd){const _0x3d58d4=_0xebad,_0x167218=_0x6d867c();while(!![]){try{const _0xb735eb=-parseInt(_0x3d58d4(0x274))/0x1*(-parseInt(_0x3d58d4(0xab))/0x2)+parseInt(_0x3d58d4(0x2af))/0x3*(-parseInt(_0x3d58d4(0x2c1))/0x4)+parseInt(_0x3d58d4(0x28d))/0x5+-parseInt(_0x3d58d4(0x455))/0x6*(-parseInt(_0x3d58d4(0x23a))/0x7)+-parseInt(_0x3d58d4(0x1a4))/0x8+parseInt(_0x3d58d4(0x179))/0x9*(parseInt(_0x3d58d4(0x379))/0xa)+-parseInt(_0x3d58d4(0x1ae))/0xb;if(_0xb735eb===_0x13adbd)break;else _0x167218['push'](_0x167218['shift']());}catch(_0x267141){_0x167218['push'](_0x167218['shift']());}}}(_0x3470,0x7dc9f));var label='ItemsEquipsCore',tier=tier||0x0,dependencies=[],pluginData=$plugins[_0x77d410(0x301)](function(_0x582c2b){const _0x4677f7=_0x77d410;return _0x582c2b[_0x4677f7(0x400)]&&_0x582c2b[_0x4677f7(0x3d5)][_0x4677f7(0x26b)]('['+label+']');})[0x0];VisuMZ[label][_0x77d410(0x96)]=VisuMZ[label][_0x77d410(0x96)]||{},VisuMZ[_0x77d410(0x265)]=function(_0x5bda87,_0x2878ce){const _0x59301b=_0x77d410;for(const _0x407f52 in _0x2878ce){if(_0x407f52[_0x59301b(0x336)](/(.*):(.*)/i)){const _0x1d5d0f=String(RegExp['$1']),_0x5edee7=String(RegExp['$2'])[_0x59301b(0x143)]()['trim']();let _0x47a455,_0x2e81f1,_0x5a66d4;switch(_0x5edee7){case _0x59301b(0x2dc):_0x47a455=_0x2878ce[_0x407f52]!==''?Number(_0x2878ce[_0x407f52]):0x0;break;case _0x59301b(0x230):_0x2e81f1=_0x2878ce[_0x407f52]!==''?JSON[_0x59301b(0x443)](_0x2878ce[_0x407f52]):[],_0x47a455=_0x2e81f1['map'](_0x44e1c9=>Number(_0x44e1c9));break;case _0x59301b(0x33e):_0x47a455=_0x2878ce[_0x407f52]!==''?eval(_0x2878ce[_0x407f52]):null;break;case _0x59301b(0x2aa):_0x2e81f1=_0x2878ce[_0x407f52]!==''?JSON['parse'](_0x2878ce[_0x407f52]):[],_0x47a455=_0x2e81f1[_0x59301b(0x199)](_0x4b97b5=>eval(_0x4b97b5));break;case _0x59301b(0xa8):_0x47a455=_0x2878ce[_0x407f52]!==''?JSON[_0x59301b(0x443)](_0x2878ce[_0x407f52]):'';break;case _0x59301b(0x382):_0x2e81f1=_0x2878ce[_0x407f52]!==''?JSON[_0x59301b(0x443)](_0x2878ce[_0x407f52]):[],_0x47a455=_0x2e81f1['map'](_0x58b652=>JSON[_0x59301b(0x443)](_0x58b652));break;case'FUNC':_0x47a455=_0x2878ce[_0x407f52]!==''?new Function(JSON[_0x59301b(0x443)](_0x2878ce[_0x407f52])):new Function(_0x59301b(0x42f));break;case _0x59301b(0x2e4):_0x2e81f1=_0x2878ce[_0x407f52]!==''?JSON[_0x59301b(0x443)](_0x2878ce[_0x407f52]):[],_0x47a455=_0x2e81f1[_0x59301b(0x199)](_0x4bfd52=>new Function(JSON['parse'](_0x4bfd52)));break;case'STR':_0x47a455=_0x2878ce[_0x407f52]!==''?String(_0x2878ce[_0x407f52]):'';break;case'ARRAYSTR':_0x2e81f1=_0x2878ce[_0x407f52]!==''?JSON[_0x59301b(0x443)](_0x2878ce[_0x407f52]):[],_0x47a455=_0x2e81f1['map'](_0x5e8f0f=>String(_0x5e8f0f));break;case _0x59301b(0x164):_0x5a66d4=_0x2878ce[_0x407f52]!==''?JSON[_0x59301b(0x443)](_0x2878ce[_0x407f52]):{},_0x5bda87[_0x1d5d0f]={},VisuMZ[_0x59301b(0x265)](_0x5bda87[_0x1d5d0f],_0x5a66d4);continue;case _0x59301b(0x399):_0x2e81f1=_0x2878ce[_0x407f52]!==''?JSON[_0x59301b(0x443)](_0x2878ce[_0x407f52]):[],_0x47a455=_0x2e81f1[_0x59301b(0x199)](_0x9821a=>VisuMZ[_0x59301b(0x265)]({},JSON[_0x59301b(0x443)](_0x9821a)));break;default:continue;}_0x5bda87[_0x1d5d0f]=_0x47a455;}}return _0x5bda87;},(_0x1abfac=>{const _0x347b97=_0x77d410,_0x39e72d=_0x1abfac['name'];for(const _0x2a83db of dependencies){if(!Imported[_0x2a83db]){alert(_0x347b97(0x16e)[_0x347b97(0x290)](_0x39e72d,_0x2a83db)),SceneManager['exit']();break;}}const _0x2c8f72=_0x1abfac[_0x347b97(0x3d5)];if(_0x2c8f72[_0x347b97(0x336)](/\[Version[ ](.*?)\]/i)){const _0x4dbb18=Number(RegExp['$1']);_0x4dbb18!==VisuMZ[label][_0x347b97(0x3a7)]&&(alert(_0x347b97(0x341)[_0x347b97(0x290)](_0x39e72d,_0x4dbb18)),SceneManager['exit']());}if(_0x2c8f72['match'](/\[Tier[ ](\d+)\]/i)){const _0x3b0b56=Number(RegExp['$1']);_0x3b0b56<tier?(alert(_0x347b97(0x2fb)[_0x347b97(0x290)](_0x39e72d,_0x3b0b56,tier)),SceneManager[_0x347b97(0x68)]()):tier=Math[_0x347b97(0x17f)](_0x3b0b56,tier);}VisuMZ[_0x347b97(0x265)](VisuMZ[label][_0x347b97(0x96)],_0x1abfac[_0x347b97(0x171)]);})(pluginData),PluginManager[_0x77d410(0xbb)](pluginData['name'],_0x77d410(0x2c9),_0x3b3aa6=>{const _0x1bf532=_0x77d410;VisuMZ[_0x1bf532(0x265)](_0x3b3aa6,_0x3b3aa6);const _0x58a83f=_0x3b3aa6[_0x1bf532(0x2b3)][_0x1bf532(0x199)](_0x4c379c=>$gameActors[_0x1bf532(0x1d7)](_0x4c379c)),_0x59de17=_0x3b3aa6[_0x1bf532(0x348)][_0x1bf532(0x199)](_0x24d7e9=>$dataSystem[_0x1bf532(0x3f0)][_0x1bf532(0xbd)](_0x24d7e9[_0x1bf532(0x72)]()));for(const _0xe74c01 of _0x58a83f){if(!_0xe74c01)continue;_0xe74c01[_0x1bf532(0x89)](_0x59de17);}}),PluginManager[_0x77d410(0xbb)](pluginData[_0x77d410(0x123)],_0x77d410(0x380),_0x16b202=>{const _0x4810ba=_0x77d410;VisuMZ[_0x4810ba(0x265)](_0x16b202,_0x16b202);const _0xcff27c=_0x16b202[_0x4810ba(0x2b3)][_0x4810ba(0x199)](_0xef2430=>$gameActors[_0x4810ba(0x1d7)](_0xef2430));for(const _0x278c3e of _0xcff27c){if(!_0x278c3e)continue;_0x278c3e[_0x4810ba(0xc7)]();}}),PluginManager[_0x77d410(0xbb)](pluginData[_0x77d410(0x123)],_0x77d410(0x38d),_0x102aea=>{const _0x4a5f85=_0x77d410;if($gameParty[_0x4a5f85(0x17d)]())return;VisuMZ[_0x4a5f85(0x265)](_0x102aea,_0x102aea);const _0x8e12ca=_0x102aea[_0x4a5f85(0x2b3)][_0x4a5f85(0x199)](_0x52af14=>$gameActors[_0x4a5f85(0x1d7)](_0x52af14));for(const _0x308b60 of _0x8e12ca){if(!_0x308b60)continue;_0x308b60['purifyCursedEquips']();}}),PluginManager['registerCommand'](pluginData[_0x77d410(0x123)],_0x77d410(0x10f),_0xe9b092=>{const _0x213ffa=_0x77d410;if($gameParty[_0x213ffa(0x17d)]())return;$gameParty[_0x213ffa(0x2d7)]();}),PluginManager[_0x77d410(0xbb)](pluginData[_0x77d410(0x123)],_0x77d410(0x23e),_0x5be238=>{const _0x25e85c=_0x77d410;VisuMZ[_0x25e85c(0x265)](_0x5be238,_0x5be238);const _0x3227a8=[],_0x161437=_0x5be238[_0x25e85c(0x3ca)][_0x25e85c(0x199)](_0x334a53=>_0x334a53[_0x25e85c(0x143)]()[_0x25e85c(0x72)]()),_0x2c780b=_0x5be238[_0x25e85c(0x1c3)]['map'](_0x519276=>_0x519276[_0x25e85c(0x143)]()['trim']()),_0x2a8619=_0x5be238[_0x25e85c(0x332)]>=_0x5be238[_0x25e85c(0x2f8)]?_0x5be238['Step1Start']:_0x5be238[_0x25e85c(0x332)],_0x3e88a2=_0x5be238[_0x25e85c(0x332)]>=_0x5be238['Step1Start']?_0x5be238[_0x25e85c(0x332)]:_0x5be238[_0x25e85c(0x2f8)],_0x48354d=Array(_0x3e88a2-_0x2a8619+0x1)[_0x25e85c(0x442)]()[_0x25e85c(0x199)]((_0x471f5e,_0x1a08cd)=>_0x2a8619+_0x1a08cd);for(const _0x242434 of _0x48354d){const _0x3cbdcc=$dataItems[_0x242434];if(!_0x3cbdcc)continue;if(!VisuMZ[_0x25e85c(0x1e8)][_0x25e85c(0x113)](_0x3cbdcc,_0x161437,_0x2c780b))continue;_0x3227a8[_0x25e85c(0x31f)]([0x0,_0x242434,0x0,_0x3cbdcc[_0x25e85c(0x36a)]]);}const _0x161987=_0x5be238[_0x25e85c(0x45a)]>=_0x5be238[_0x25e85c(0xe2)]?_0x5be238[_0x25e85c(0xe2)]:_0x5be238['Step2End'],_0x32890e=_0x5be238[_0x25e85c(0x45a)]>=_0x5be238[_0x25e85c(0xe2)]?_0x5be238[_0x25e85c(0x45a)]:_0x5be238['Step2Start'],_0x345f28=Array(_0x32890e-_0x161987+0x1)[_0x25e85c(0x442)]()[_0x25e85c(0x199)]((_0x1d0a66,_0x6c2bfb)=>_0x161987+_0x6c2bfb);for(const _0x2b953c of _0x345f28){const _0x3102dd=$dataWeapons[_0x2b953c];if(!_0x3102dd)continue;if(!VisuMZ[_0x25e85c(0x1e8)][_0x25e85c(0x113)](_0x3102dd,_0x161437,_0x2c780b))continue;_0x3227a8[_0x25e85c(0x31f)]([0x1,_0x2b953c,0x0,_0x3102dd['price']]);}const _0x4c3df3=_0x5be238[_0x25e85c(0x116)]>=_0x5be238[_0x25e85c(0x263)]?_0x5be238['Step3Start']:_0x5be238[_0x25e85c(0x116)],_0x2eda93=_0x5be238[_0x25e85c(0x116)]>=_0x5be238[_0x25e85c(0x263)]?_0x5be238[_0x25e85c(0x116)]:_0x5be238[_0x25e85c(0x263)],_0x3bfc20=Array(_0x2eda93-_0x4c3df3+0x1)[_0x25e85c(0x442)]()['map']((_0x4d64aa,_0x435ad4)=>_0x4c3df3+_0x435ad4);for(const _0x39b63b of _0x3bfc20){const _0x21f415=$dataArmors[_0x39b63b];if(!_0x21f415)continue;if(!VisuMZ[_0x25e85c(0x1e8)][_0x25e85c(0x113)](_0x21f415,_0x161437,_0x2c780b))continue;_0x3227a8[_0x25e85c(0x31f)]([0x2,_0x39b63b,0x0,_0x21f415['price']]);}SceneManager[_0x25e85c(0x31f)](Scene_Shop),SceneManager[_0x25e85c(0x2a8)](_0x3227a8,_0x5be238[_0x25e85c(0x2b6)]);}),VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x113)]=function(_0x41d26e,_0x79c2b3,_0x20a726){const _0x135c73=_0x77d410;if(_0x41d26e[_0x135c73(0x123)][_0x135c73(0x72)]()==='')return![];if(_0x41d26e[_0x135c73(0x123)][_0x135c73(0x336)](/-----/i))return![];const _0x16b638=_0x41d26e[_0x135c73(0x259)];if(_0x79c2b3[_0x135c73(0xcc)]>0x0)for(const _0x1e6870 of _0x79c2b3){if(!_0x1e6870)continue;if(_0x16b638[_0x135c73(0x26b)](_0x1e6870))return![];}if(_0x20a726['length']>0x0){for(const _0x3c3e26 of _0x20a726){if(!_0x3c3e26)continue;if(_0x16b638[_0x135c73(0x26b)](_0x3c3e26))return!![];}return![];}return!![];},VisuMZ[_0x77d410(0x1e8)]['Scene_Boot_onDatabaseLoaded']=Scene_Boot[_0x77d410(0xc6)][_0x77d410(0x1dd)],Scene_Boot[_0x77d410(0xc6)][_0x77d410(0x1dd)]=function(){const _0x403258=_0x77d410;this[_0x403258(0x13b)](),VisuMZ[_0x403258(0x1e8)][_0x403258(0x2f7)][_0x403258(0x200)](this),this['process_VisuMZ_ItemsEquipsCore_Notetags'](),VisuMZ[_0x403258(0x1e8)][_0x403258(0x408)](),VisuMZ[_0x403258(0x1e8)]['SetupArtifactItemIDs']();},Scene_Boot[_0x77d410(0xc6)]['process_VisuMZ_ItemsEquipsCore_RegExp']=function(){const _0x8228e5=_0x77d410;VisuMZ[_0x8228e5(0x1e8)][_0x8228e5(0x202)]={},VisuMZ[_0x8228e5(0x1e8)][_0x8228e5(0x202)][_0x8228e5(0x2a0)]=[],VisuMZ[_0x8228e5(0x1e8)][_0x8228e5(0x202)][_0x8228e5(0x26f)]=[];const _0x5a6c88=[_0x8228e5(0x3f8),_0x8228e5(0x435),_0x8228e5(0x2f0),_0x8228e5(0x3e5),_0x8228e5(0x76),'MDF','AGI',_0x8228e5(0x178)];for(const _0x262874 of _0x5a6c88){const _0x133aab=_0x8228e5(0x273)[_0x8228e5(0x290)](_0x262874);VisuMZ[_0x8228e5(0x1e8)][_0x8228e5(0x202)]['EquipParams'][_0x8228e5(0x31f)](new RegExp(_0x133aab,'i'));const _0xbbe0f0=_0x8228e5(0x129)[_0x8228e5(0x290)](_0x262874);VisuMZ[_0x8228e5(0x1e8)][_0x8228e5(0x202)][_0x8228e5(0x26f)]['push'](new RegExp(_0xbbe0f0,'g'));}},Scene_Boot[_0x77d410(0xc6)][_0x77d410(0xd4)]=function(){const _0x3962a0=_0x77d410;if(VisuMZ[_0x3962a0(0x195)])return;this[_0x3962a0(0x7f)]();const _0x5e0da5=[$dataItems,$dataWeapons,$dataArmors];for(const _0x29b3a0 of _0x5e0da5){for(const _0xdfed8f of _0x29b3a0){if(!_0xdfed8f)continue;VisuMZ[_0x3962a0(0x1e8)][_0x3962a0(0x41d)](_0xdfed8f,_0x29b3a0),VisuMZ[_0x3962a0(0x1e8)]['Parse_Notetags_Prices'](_0xdfed8f,_0x29b3a0),VisuMZ['ItemsEquipsCore'][_0x3962a0(0x45f)](_0xdfed8f,_0x29b3a0),VisuMZ['ItemsEquipsCore']['Parse_Notetags_ParamJS'](_0xdfed8f,_0x29b3a0),VisuMZ[_0x3962a0(0x1e8)][_0x3962a0(0x392)](_0xdfed8f,_0x29b3a0);}}},Scene_Boot[_0x77d410(0xc6)]['process_VisuMZ_ItemsEquipsCore_EquipSlots']=function(){for(const _0x2bc365 of $dataClasses){if(!_0x2bc365)continue;VisuMZ['ItemsEquipsCore']['Parse_Notetags_EquipSlots'](_0x2bc365);}},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x358)]=VisuMZ['ParseClassNotetags'],VisuMZ['ParseClassNotetags']=function(_0xfd6317){const _0xe745f2=_0x77d410;VisuMZ['ItemsEquipsCore'][_0xe745f2(0x358)][_0xe745f2(0x200)](this,_0xfd6317),VisuMZ['ItemsEquipsCore'][_0xe745f2(0x42a)](_0xfd6317);},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x3b1)]=VisuMZ[_0x77d410(0x3b1)],VisuMZ['ParseItemNotetags']=function(_0x2e617b){const _0x736169=_0x77d410;VisuMZ['ItemsEquipsCore'][_0x736169(0x3b1)][_0x736169(0x200)](this,_0x2e617b),VisuMZ[_0x736169(0x1e8)][_0x736169(0x8f)](_0x2e617b,$dataItems);},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x8a)]=VisuMZ['ParseWeaponNotetags'],VisuMZ['ParseWeaponNotetags']=function(_0x1b578d){const _0x404417=_0x77d410;VisuMZ['ItemsEquipsCore']['ParseWeaponNotetags']['call'](this,_0x1b578d),VisuMZ[_0x404417(0x1e8)]['Parse_Notetags_Batch'](_0x1b578d,$dataWeapons);},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x29d)]=VisuMZ[_0x77d410(0x29d)],VisuMZ[_0x77d410(0x29d)]=function(_0x303516){const _0x36b51c=_0x77d410;VisuMZ[_0x36b51c(0x1e8)][_0x36b51c(0x29d)]['call'](this,_0x303516),VisuMZ[_0x36b51c(0x1e8)][_0x36b51c(0x8f)](_0x303516,$dataArmors);},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x42a)]=function(_0x5c1bc5){const _0x4fe592=_0x77d410;_0x5c1bc5[_0x4fe592(0x30d)]=[];const _0x5240df=$dataSystem[_0x4fe592(0x3f0)][_0x4fe592(0x199)](_0x2b682f=>_0x2b682f?_0x2b682f[_0x4fe592(0x72)]():'');if(!BattleManager[_0x4fe592(0x427)]()&&_0x5c1bc5[_0x4fe592(0x272)][_0x4fe592(0x336)](/<EQUIP SLOTS>\s*([\s\S]*)\s*<\/EQUIP SLOTS>/i)){const _0x458fd8=String(RegExp['$1'])[_0x4fe592(0x21e)](/[\r\n]+/);for(const _0x1d80f6 of _0x458fd8){const _0x1242e0=_0x5240df[_0x4fe592(0xbd)](_0x1d80f6[_0x4fe592(0x72)]());if(_0x1242e0>0x0)_0x5c1bc5[_0x4fe592(0x30d)][_0x4fe592(0x31f)](_0x1242e0);}}else for(const _0x35c4b7 of _0x5240df){const _0x2f5f2d=_0x5240df[_0x4fe592(0xbd)](_0x35c4b7[_0x4fe592(0x72)]());if(_0x2f5f2d>0x0)_0x5c1bc5[_0x4fe592(0x30d)][_0x4fe592(0x31f)](_0x2f5f2d);}},VisuMZ['ItemsEquipsCore'][_0x77d410(0x8f)]=function(_0x3cb2ad,_0x234707){const _0x279956=_0x77d410;VisuMZ[_0x279956(0x1e8)][_0x279956(0x41d)](_0x3cb2ad,_0x234707),VisuMZ[_0x279956(0x1e8)]['Parse_Notetags_Prices'](_0x3cb2ad,_0x234707),VisuMZ[_0x279956(0x1e8)][_0x279956(0x45f)](_0x3cb2ad,_0x234707),VisuMZ[_0x279956(0x1e8)]['Parse_Notetags_ParamJS'](_0x3cb2ad,_0x234707),VisuMZ[_0x279956(0x1e8)][_0x279956(0x392)](_0x3cb2ad,_0x234707);},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x41d)]=function(_0x5a2a07,_0x43fc7b){const _0x46ba42=_0x77d410;_0x5a2a07[_0x46ba42(0x259)]=[];const _0x4218b0=_0x5a2a07[_0x46ba42(0x272)]||'',_0x146a8b=_0x4218b0[_0x46ba42(0x336)](/<(?:CATEGORY|CATEGORIES):[ ](.*)>/gi);if(_0x146a8b)for(const _0x3b2a15 of _0x146a8b){_0x3b2a15[_0x46ba42(0x336)](/<(?:CATEGORY|CATEGORIES):[ ](.*)>/gi);const _0x52102b=String(RegExp['$1'])[_0x46ba42(0x143)]()['trim']()[_0x46ba42(0x21e)](',');for(const _0x59291c of _0x52102b){_0x5a2a07[_0x46ba42(0x259)]['push'](_0x59291c['trim']());}}if(_0x4218b0[_0x46ba42(0x336)](/<(?:CATEGORY|CATEGORIES)>\s*([\s\S]*)\s*<\/(?:CATEGORY|CATEGORIES)>/i)){const _0x15f305=RegExp['$1'][_0x46ba42(0x21e)](/[\r\n]+/);for(const _0x4a4476 of _0x15f305){_0x5a2a07[_0x46ba42(0x259)][_0x46ba42(0x31f)](_0x4a4476['toUpperCase']()[_0x46ba42(0x72)]());}}},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x2c6)]=function(_0x135f14,_0x2eb3de){const _0x5e589c=_0x77d410;if(!_0x135f14)return;_0x135f14['sortPriority']=0x32;const _0xeac02f=_0x135f14[_0x5e589c(0x272)]||'';_0xeac02f[_0x5e589c(0x336)](/<(?:|ID )SORT(?:|ING)[ ]PRIORITY:[ ](\d+)>/i)&&(_0x135f14[_0x5e589c(0x40a)]=Number(RegExp['$1']));},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x44d)]=function(_0x2fc2b3,_0x3311b5){const _0x816633=_0x77d410;_0x2fc2b3[_0x816633(0x272)][_0x816633(0x336)](/<PRICE:[ ](\d+)>/i)&&(_0x2fc2b3['price']=Number(RegExp['$1']));},VisuMZ['ItemsEquipsCore']['Parse_Notetags_ParamValues']=function(_0x3d22e4,_0x162a6d){const _0x5892cf=_0x77d410;if(_0x162a6d===$dataItems)return;for(let _0x5a2e5=0x0;_0x5a2e5<0x8;_0x5a2e5++){const _0x3bbe57=VisuMZ[_0x5892cf(0x1e8)][_0x5892cf(0x202)][_0x5892cf(0x2a0)][_0x5a2e5];_0x3d22e4[_0x5892cf(0x272)][_0x5892cf(0x336)](_0x3bbe57)&&(_0x3d22e4[_0x5892cf(0x2e8)][_0x5a2e5]=parseInt(RegExp['$1']));}},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x211)]={},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x1e5)]=function(_0x3784b6,_0x27c4a7){const _0x2ee345=_0x77d410;if(_0x27c4a7===$dataItems)return;if(_0x3784b6[_0x2ee345(0x272)][_0x2ee345(0x336)](/<JS PARAMETERS>\s*([\s\S]*)\s*<\/JS PARAMETERS>/i)){const _0x5b6cee=String(RegExp['$1']),_0x345454=(_0x27c4a7===$dataWeapons?_0x2ee345(0x3e8):_0x2ee345(0x8e))[_0x2ee345(0x290)](_0x3784b6['id']),_0x25bc30=_0x2ee345(0x33d)[_0x2ee345(0x290)](_0x5b6cee);for(let _0x3ec208=0x0;_0x3ec208<0x8;_0x3ec208++){if(_0x5b6cee[_0x2ee345(0x336)](VisuMZ[_0x2ee345(0x1e8)][_0x2ee345(0x202)][_0x2ee345(0x26f)][_0x3ec208])){const _0x1069d0=_0x2ee345(0xd9)[_0x2ee345(0x290)](_0x345454,_0x3ec208);VisuMZ[_0x2ee345(0x1e8)]['paramJS'][_0x1069d0]=new Function(_0x2ee345(0x298),_0x2ee345(0x1ba),_0x25bc30);}}}},VisuMZ[_0x77d410(0x1e8)]['itemEnableJS']={},VisuMZ['ItemsEquipsCore'][_0x77d410(0x392)]=function(_0x5bf929,_0x353214){const _0x539d08=_0x77d410;if(_0x353214!==$dataItems)return;if(_0x5bf929['note'][_0x539d08(0x336)](/<JS ITEM ENABLE>\s*([\s\S]*)\s*<\/JS ITEM ENABLE>/i)){const _0x4efa3e=String(RegExp['$1']),_0x4cda00=_0x539d08(0x328)[_0x539d08(0x290)](_0x4efa3e);VisuMZ[_0x539d08(0x1e8)]['itemEnableJS'][_0x5bf929['id']]=new Function(_0x539d08(0x298),_0x4cda00);}},DataManager[_0x77d410(0x100)]=function(_0xc0cea0){return this['isItem'](_0xc0cea0)&&_0xc0cea0['itypeId']===0x2;},DataManager[_0x77d410(0x256)]=function(_0x4303ea){const _0x168d16=_0x77d410;if(!_0x4303ea)return 0x63;else return _0x4303ea[_0x168d16(0x272)][_0x168d16(0x336)](/<MAX:[ ](\d+)>/i)?parseInt(RegExp['$1']):this[_0x168d16(0x285)](_0x4303ea);},DataManager[_0x77d410(0x285)]=function(_0x1b2ef9){const _0x520b8e=_0x77d410;if(this[_0x520b8e(0x19e)](_0x1b2ef9))return VisuMZ[_0x520b8e(0x1e8)][_0x520b8e(0x96)][_0x520b8e(0x3cc)][_0x520b8e(0x10c)];else{if(this['isWeapon'](_0x1b2ef9))return VisuMZ['ItemsEquipsCore']['Settings']['ItemScene']['MaxWeapons'];else{if(this['isArmor'](_0x1b2ef9))return VisuMZ[_0x520b8e(0x1e8)][_0x520b8e(0x96)][_0x520b8e(0x3cc)][_0x520b8e(0x3d7)];}}},DataManager[_0x77d410(0xdd)]=function(_0x19069a){const _0x1fb07f=_0x77d410;_0x19069a=_0x19069a[_0x1fb07f(0x143)]()[_0x1fb07f(0x72)](),this['_classIDs']=this['_classIDs']||{};if(this[_0x1fb07f(0x445)][_0x19069a])return this[_0x1fb07f(0x445)][_0x19069a];for(const _0x2687e2 of $dataClasses){if(!_0x2687e2)continue;let _0x586116=_0x2687e2[_0x1fb07f(0x123)];_0x586116=_0x586116[_0x1fb07f(0x311)](/\x1I\[(\d+)\]/gi,''),_0x586116=_0x586116[_0x1fb07f(0x311)](/\\I\[(\d+)\]/gi,''),this[_0x1fb07f(0x445)][_0x586116[_0x1fb07f(0x143)]()[_0x1fb07f(0x72)]()]=_0x2687e2['id'];}return this['_classIDs'][_0x19069a]||0x0;},DataManager[_0x77d410(0x441)]=function(_0x62e7c7){const _0x1624af=_0x77d410;_0x62e7c7=_0x62e7c7['toUpperCase']()[_0x1624af(0x72)](),this['_skillIDs']=this['_skillIDs']||{};if(this['_skillIDs'][_0x62e7c7])return this[_0x1624af(0x452)][_0x62e7c7];for(const _0x56f7ac of $dataSkills){if(!_0x56f7ac)continue;this['_skillIDs'][_0x56f7ac['name'][_0x1624af(0x143)]()[_0x1624af(0x72)]()]=_0x56f7ac['id'];}return this[_0x1624af(0x452)][_0x62e7c7]||0x0;},DataManager[_0x77d410(0x1b8)]=function(_0x1597c7){const _0x33a6d2=_0x77d410;_0x1597c7=_0x1597c7[_0x33a6d2(0x143)]()[_0x33a6d2(0x72)](),this[_0x33a6d2(0x37f)]=this[_0x33a6d2(0x37f)]||{};if(this[_0x33a6d2(0x37f)][_0x1597c7])return this[_0x33a6d2(0x37f)][_0x1597c7];for(const _0x302225 of $dataItems){if(!_0x302225)continue;this[_0x33a6d2(0x37f)][_0x302225[_0x33a6d2(0x123)][_0x33a6d2(0x143)]()[_0x33a6d2(0x72)]()]=_0x302225['id'];}return this[_0x33a6d2(0x37f)][_0x1597c7]||0x0;},DataManager[_0x77d410(0x27c)]=function(_0x1b091c){const _0x2fe4ac=_0x77d410;_0x1b091c=_0x1b091c[_0x2fe4ac(0x143)]()[_0x2fe4ac(0x72)](),this['_weaponIDs']=this[_0x2fe4ac(0x43f)]||{};if(this[_0x2fe4ac(0x43f)][_0x1b091c])return this[_0x2fe4ac(0x43f)][_0x1b091c];for(const _0x4055e8 of $dataWeapons){if(!_0x4055e8)continue;this['_weaponIDs'][_0x4055e8[_0x2fe4ac(0x123)]['toUpperCase']()['trim']()]=_0x4055e8['id'];}return this[_0x2fe4ac(0x43f)][_0x1b091c]||0x0;},DataManager[_0x77d410(0x3e9)]=function(_0x50ea85){const _0x471cfd=_0x77d410;_0x50ea85=_0x50ea85[_0x471cfd(0x143)]()['trim'](),this['_armorIDs']=this[_0x471cfd(0x327)]||{};if(this[_0x471cfd(0x327)][_0x50ea85])return this[_0x471cfd(0x327)][_0x50ea85];for(const _0x192258 of $dataArmors){if(!_0x192258)continue;this[_0x471cfd(0x327)][_0x192258['name'][_0x471cfd(0x143)]()[_0x471cfd(0x72)]()]=_0x192258['id'];}return this[_0x471cfd(0x327)][_0x50ea85]||0x0;},DataManager[_0x77d410(0x244)]=function(_0x363816){const _0x46a347=_0x77d410;_0x363816=_0x363816[_0x46a347(0x143)]()[_0x46a347(0x72)](),this['_etypeIDs']=this[_0x46a347(0x3a5)]||{};if(this[_0x46a347(0x3a5)][_0x363816])return this[_0x46a347(0x3a5)][_0x363816];for(const _0x56e180 of $dataSystem[_0x46a347(0x3f0)]){this[_0x46a347(0x3a5)][_0x56e180[_0x46a347(0x143)]()['trim']()]=$dataSystem[_0x46a347(0x3f0)]['indexOf'](_0x56e180);}return this[_0x46a347(0x3a5)][_0x363816]||0x0;},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x408)]=function(){const _0x987c36=_0x77d410;VisuMZ['ItemsEquipsCore']['SetupProxyItemGroup']($dataItems),VisuMZ[_0x987c36(0x1e8)][_0x987c36(0x189)]($dataWeapons),VisuMZ['ItemsEquipsCore'][_0x987c36(0x189)]($dataArmors);},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x189)]=function(_0x5ab5c9){const _0x411c6e=_0x77d410;for(const _0x464e8a of _0x5ab5c9){if(!_0x464e8a)continue;if(!DataManager[_0x411c6e(0x1a5)](_0x464e8a))continue;const _0x11b324=DataManager[_0x411c6e(0x23c)](_0x464e8a),_0x2e8d6a=[_0x411c6e(0x123),_0x411c6e(0x214),_0x411c6e(0x3d5)];for(const _0x29c252 of _0x2e8d6a){_0x464e8a[_0x29c252]=_0x11b324[_0x29c252];}}},DataManager[_0x77d410(0x1a5)]=function(_0x9c8df8){const _0x58416d=_0x77d410;if(!_0x9c8df8)return![];if(!_0x9c8df8['note'])return![];return _0x9c8df8&&_0x9c8df8[_0x58416d(0x272)][_0x58416d(0x336)](/<PROXY:[ ](.*)>/i);},DataManager[_0x77d410(0x23c)]=function(_0x29178c){return this['isProxyItem'](_0x29178c)?this['switchProxyItem'](_0x29178c)||_0x29178c:_0x29178c;},DataManager[_0x77d410(0x110)]=function(_0x1ec822){const _0x21ee11=_0x77d410;_0x1ec822[_0x21ee11(0x272)]['match'](/<PROXY:[ ](.*)>/i);const _0x465575=RegExp['$1']['trim'](),_0x593cb2=/^\d+$/[_0x21ee11(0x23f)](_0x465575);if(this[_0x21ee11(0x19e)](_0x1ec822)){const _0x7023dc=_0x593cb2?Number(_0x465575):DataManager[_0x21ee11(0x1b8)](_0x465575);return $dataItems[_0x7023dc]||_0x1ec822;}else{if(this['isWeapon'](_0x1ec822)){const _0x178338=_0x593cb2?Number(_0x465575):DataManager[_0x21ee11(0x27c)](_0x465575);return $dataWeapons[_0x178338]||_0x1ec822;}else{if(this[_0x21ee11(0x81)](_0x1ec822)){const _0x2a582d=_0x593cb2?Number(_0x465575):DataManager[_0x21ee11(0x3e9)](_0x465575);return $dataArmors[_0x2a582d]||_0x1ec822;}}}return _0x1ec822;},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x153)]=Window_ItemList[_0x77d410(0xc6)][_0x77d410(0x298)],Window_ItemList[_0x77d410(0xc6)][_0x77d410(0x298)]=function(){const _0x67f99f=_0x77d410;if($gameTemp[_0x67f99f(0x20e)])return VisuMZ[_0x67f99f(0x1e8)][_0x67f99f(0x153)][_0x67f99f(0x200)](this);return DataManager[_0x67f99f(0x23c)](VisuMZ[_0x67f99f(0x1e8)][_0x67f99f(0x153)][_0x67f99f(0x200)](this));},Window_ItemList[_0x77d410(0xc6)]['proxyItem']=function(){const _0x4be412=_0x77d410;return VisuMZ['ItemsEquipsCore'][_0x4be412(0x153)][_0x4be412(0x200)](this);},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x112)]=Window_ShopBuy['prototype'][_0x77d410(0x298)],Window_ShopBuy[_0x77d410(0xc6)][_0x77d410(0x298)]=function(){const _0x517a98=_0x77d410;if($gameTemp[_0x517a98(0x20e)])return VisuMZ['ItemsEquipsCore'][_0x517a98(0x112)][_0x517a98(0x200)](this);return DataManager[_0x517a98(0x23c)](VisuMZ[_0x517a98(0x1e8)][_0x517a98(0x112)][_0x517a98(0x200)](this));},Window_ShopBuy[_0x77d410(0xc6)][_0x77d410(0x2a4)]=function(){const _0x10d5e1=_0x77d410;return VisuMZ[_0x10d5e1(0x1e8)]['Window_ShopBuy_item'][_0x10d5e1(0x200)](this);},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x395)]=Game_Item[_0x77d410(0xc6)][_0x77d410(0x29f)],Game_Item[_0x77d410(0xc6)][_0x77d410(0x29f)]=function(_0x214832){const _0x3895ee=_0x77d410;if(DataManager[_0x3895ee(0x1a5)](_0x214832))return;VisuMZ['ItemsEquipsCore']['Game_Item_setObject']['call'](this,_0x214832);},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x2f5)]=function(){const _0x1034c3=_0x77d410;this[_0x1034c3(0x2f4)]={'partyArtifactIDs':[],'troopArtifactIDs':[]};for(const _0x4485e6 of $dataArmors){if(!_0x4485e6)continue;if(!DataManager[_0x1034c3(0x275)](_0x4485e6))continue;DataManager[_0x1034c3(0xe4)](_0x4485e6)&&this[_0x1034c3(0x2f4)][_0x1034c3(0x1c9)][_0x1034c3(0x31f)](_0x4485e6['id']),DataManager[_0x1034c3(0x368)](_0x4485e6)&&this['artifactIDs']['troopArtifactIDs'][_0x1034c3(0x31f)](_0x4485e6['id']);}},DataManager[_0x77d410(0x275)]=function(_0x2ada3a){const _0x3133f6=_0x77d410;if(!this['isArmor'](_0x2ada3a))return![];const _0x57d933=_0x2ada3a[_0x3133f6(0x272)];if(!_0x57d933)return![];if(_0x57d933[_0x3133f6(0x336)](/<(?:PARTY|ALLY) (?:ARTIFACT|RELIC)>/i))return!![];if(_0x57d933[_0x3133f6(0x336)](/<(?:STACKABLE|STACK) (?:PARTY|ALLY) (?:ARTIFACT|RELIC)>/i))return!![];if(_0x57d933[_0x3133f6(0x336)](/<(?:TROOP|FOE) (?:ARTIFACT|RELIC)>/i))return!![];if(_0x57d933['match'](/<(?:STACKABLE|STACK) (?:TROOP|FOE) (?:ARTIFACT|RELIC)>/i))return!![];return![];},DataManager[_0x77d410(0x29c)]=function(_0x3546f7){const _0x579980=_0x77d410;if(!this[_0x579980(0x275)](_0x3546f7))return![];const _0x1a1e04=_0x3546f7[_0x579980(0x272)];if(!_0x1a1e04)return![];if(_0x1a1e04[_0x579980(0x336)](/<(?:STACKABLE|STACK) (?:PARTY|ALLY) (?:ARTIFACT|RELIC)>/i))return!![];if(_0x1a1e04[_0x579980(0x336)](/<(?:STACKABLE|STACK) (?:TROOP|FOE) (?:ARTIFACT|RELIC)>/i))return!![];return![];},DataManager['isPartyArtifact']=function(_0x4a916c){const _0x2cde7a=_0x77d410;if(!this['isArtifact'](_0x4a916c))return![];const _0x3e6008=_0x4a916c['note'];if(!_0x3e6008)return![];if(_0x3e6008[_0x2cde7a(0x336)](/<(?:PARTY|ALLY) (?:ARTIFACT|RELIC)>/i))return!![];if(_0x3e6008[_0x2cde7a(0x336)](/<(?:STACKABLE|STACK) (?:PARTY|ALLY) (?:ARTIFACT|RELIC)>/i))return!![];return![];},DataManager[_0x77d410(0x368)]=function(_0xc83997){const _0x1b28de=_0x77d410;if(!this[_0x1b28de(0x275)](_0xc83997))return![];const _0xdf0ef5=_0xc83997[_0x1b28de(0x272)];if(!_0xdf0ef5)return![];if(_0xdf0ef5[_0x1b28de(0x336)](/<(?:TROOP|FOE) (?:ARTIFACT|RELIC)>/i))return!![];if(_0xdf0ef5[_0x1b28de(0x336)](/<(?:STACKABLE|STACK) (?:TROOP|FOE) (?:ARTIFACT|RELIC)>/i))return!![];return![];},VisuMZ[_0x77d410(0x1e8)]['Game_BattlerBase_canEquip_artifact']=Game_BattlerBase[_0x77d410(0xc6)][_0x77d410(0x2c3)],Game_BattlerBase['prototype']['canEquip']=function(_0x32cfdb){const _0x389d2b=_0x77d410;if(DataManager[_0x389d2b(0x275)](_0x32cfdb))return![];if(!DataManager[_0x389d2b(0x1c5)](this,_0x32cfdb))return![];if(!DataManager[_0x389d2b(0x1f4)](this,_0x32cfdb))return![];return VisuMZ[_0x389d2b(0x1e8)][_0x389d2b(0x35b)][_0x389d2b(0x200)](this,_0x32cfdb);},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x267)]=Game_BattlerBase[_0x77d410(0xc6)]['param'],Game_BattlerBase[_0x77d410(0xc6)][_0x77d410(0xb8)]=function(_0x2be472){const _0x484cdf=_0x77d410;this[_0x484cdf(0x412)]=!![];const _0x2f92d8=VisuMZ[_0x484cdf(0x1e8)]['Game_BattlerBase_param_artifact'][_0x484cdf(0x200)](this,_0x2be472);return this['_allowArtifactParamBase']=undefined,_0x2f92d8;},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x258)]=Game_Actor[_0x77d410(0xc6)][_0x77d410(0x3ad)],Game_Actor['prototype'][_0x77d410(0x3ad)]=function(){const _0x319f96=_0x77d410;this[_0x319f96(0xb9)]=!![];const _0x5f5098=VisuMZ['ItemsEquipsCore'][_0x319f96(0x258)][_0x319f96(0x200)](this);return this[_0x319f96(0xb9)]=undefined,_0x5f5098;},VisuMZ[_0x77d410(0x1e8)]['Game_Actor_equips_artifacts']=Game_Actor[_0x77d410(0xc6)]['equips'],Game_Actor[_0x77d410(0xc6)][_0x77d410(0x3ac)]=function(){const _0x54a59e=_0x77d410,_0x29e9da=VisuMZ[_0x54a59e(0x1e8)]['Game_Actor_equips_artifacts']['call'](this);if(this['_allowArtifactTraitObjects']||this[_0x54a59e(0x412)]){const _0x2943de=_0x29e9da[_0x54a59e(0x234)]($gameParty['partyArtifacts']());return _0x2943de;}else return _0x29e9da;},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x3de)]=Game_BattlerBase['prototype'][_0x77d410(0xd1)],Game_BattlerBase[_0x77d410(0xc6)][_0x77d410(0xd1)]=function(_0x155803){const _0x2a4a87=_0x77d410;let _0x58351a=VisuMZ[_0x2a4a87(0x1e8)][_0x2a4a87(0x3de)]['call'](this,_0x155803);if(this[_0x2a4a87(0x8d)]===Game_Enemy)for(const _0x4bc5ef of $gameParty['troopArtifacts']()){if(_0x4bc5ef)_0x58351a+=_0x4bc5ef[_0x2a4a87(0x2e8)][_0x155803];}return _0x58351a;},VisuMZ['ItemsEquipsCore']['Game_Enemy_traitObjects_artifact']=Game_Enemy[_0x77d410(0xc6)][_0x77d410(0x3ad)],Game_Enemy['prototype'][_0x77d410(0x3ad)]=function(){const _0x16df27=_0x77d410;let _0x5c57e8=VisuMZ[_0x16df27(0x1e8)][_0x16df27(0x98)][_0x16df27(0x200)](this);return _0x5c57e8[_0x16df27(0x234)]($gameParty[_0x16df27(0x319)]());},VisuMZ['ItemsEquipsCore'][_0x77d410(0x40b)]=Game_Party[_0x77d410(0xc6)][_0x77d410(0x375)],Game_Party[_0x77d410(0xc6)][_0x77d410(0x375)]=function(_0x551333,_0x1876f9,_0x4f8e19){const _0x3ae13a=_0x77d410;VisuMZ['ItemsEquipsCore'][_0x3ae13a(0x40b)][_0x3ae13a(0x200)](this,_0x551333,_0x1876f9,_0x4f8e19);if(DataManager[_0x3ae13a(0x275)](_0x551333)){let _0x44b960=$gameParty[_0x3ae13a(0x1c0)]();if($gameParty[_0x3ae13a(0x17d)]())_0x44b960=_0x44b960[_0x3ae13a(0x234)]($gameTroop['members']());for(const _0x27ea85 of _0x44b960){if(!_0x27ea85)continue;_0x27ea85['_cache']={};}}},Game_Party[_0x77d410(0xc6)][_0x77d410(0x3b2)]=function(){const _0x48ec51=_0x77d410;let _0x34af90=[];const _0x3fe2a1=VisuMZ[_0x48ec51(0x1e8)][_0x48ec51(0x2f4)][_0x48ec51(0x1c9)];if(_0x3fe2a1)for(const _0x1446b9 of _0x3fe2a1){const _0x481055=$dataArmors[_0x1446b9];if(!_0x481055)continue;if(!this['hasItem'](_0x481055))continue;let _0x281545=0x1;if(DataManager['isStackableArtifact'](_0x481055))_0x281545=this[_0x48ec51(0x342)](_0x481055);while(_0x281545--)_0x34af90[_0x48ec51(0x31f)](_0x481055);}return _0x34af90;},Game_Party[_0x77d410(0xc6)][_0x77d410(0x319)]=function(){const _0x13abf9=_0x77d410;let _0xe5f940=[];const _0x27aa00=VisuMZ[_0x13abf9(0x1e8)][_0x13abf9(0x2f4)][_0x13abf9(0x19f)];if(_0x27aa00)for(const _0x4a90df of _0x27aa00){const _0x550241=$dataArmors[_0x4a90df];if(!_0x550241)continue;if(!this[_0x13abf9(0x207)](_0x550241))continue;let _0x47a963=0x1;if(DataManager[_0x13abf9(0x29c)](_0x550241))_0x47a963=this[_0x13abf9(0x342)](_0x550241);while(_0x47a963--)_0xe5f940[_0x13abf9(0x31f)](_0x550241);}return _0xe5f940;},Game_Party[_0x77d410(0xc6)][_0x77d410(0x3d9)]=function(){const _0x4125d3=_0x77d410;return this[_0x4125d3(0x3b2)]()['concat'](this['troopArtifacts']());},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x23b)]=Game_Party[_0x77d410(0xc6)]['setupBattleTestItems'],Game_Party[_0x77d410(0xc6)][_0x77d410(0x2eb)]=function(){const _0x109a13=_0x77d410;VisuMZ[_0x109a13(0x1e8)][_0x109a13(0x23b)]['call'](this),this['removeBattleTestArtifacts']();},Game_Party['prototype'][_0x77d410(0xd6)]=function(){const _0x28603e=_0x77d410,_0x183107=$gameParty[_0x28603e(0x438)]()[_0x28603e(0x301)](_0x2fc283=>DataManager[_0x28603e(0x275)](_0x2fc283));for(const _0x4ad8f9 of _0x183107){const _0x3d319e=this[_0x28603e(0x342)](_0x4ad8f9);if(_0x3d319e)this['loseItem'](_0x4ad8f9,_0x3d319e);}},DataManager['meetsClassRequirements']=function(_0x1355e1,_0x991e73){const _0x5c565e=_0x77d410;if(this[_0x5c565e(0x19e)](_0x991e73))return![];if(!_0x1355e1)return![];if($gameTemp[_0x5c565e(0x228)])return!![];if(BattleManager[_0x5c565e(0x427)]())return!![];const _0x29ae42=this['getClassRequirements'](_0x991e73);if(_0x29ae42['length']<=0x0)return!![];return _0x29ae42[_0x5c565e(0x26b)](_0x1355e1['currentClass']()['id']);},DataManager[_0x77d410(0x41f)]=function(_0x2d3f9a){const _0x57c558=_0x77d410;if(!_0x2d3f9a)return[];this[_0x57c558(0x15c)]=this['_getClassRequirements']||{};const _0x64acd2=_0x57c558(0xd9)['format'](this['isWeapon'](_0x2d3f9a)?_0x57c558(0x118):_0x57c558(0x114),_0x2d3f9a['id']);if(this[_0x57c558(0x15c)][_0x64acd2]!==undefined)return this['_getClassRequirements'][_0x64acd2];let _0x365601=[];const _0x476b1b=_0x2d3f9a[_0x57c558(0x272)]||'';if(_0x476b1b[_0x57c558(0x336)](/<EQUIP FOR CLASS(?:|ES) ONLY:[ ](.*)>/i)){const _0xa9fa75=String(RegExp['$1'])[_0x57c558(0x21e)](',')['map'](_0x21330d=>_0x21330d['trim']());for(const _0x3a43ad of _0xa9fa75){const _0x5abaa2=/^\d+$/[_0x57c558(0x23f)](_0x3a43ad);_0x5abaa2?_0x365601[_0x57c558(0x31f)](Number(_0x3a43ad)):_0x365601['push'](DataManager[_0x57c558(0xdd)](_0x3a43ad));}}return this[_0x57c558(0x15c)][_0x64acd2]=_0x365601,this[_0x57c558(0x15c)][_0x64acd2];},DataManager[_0x77d410(0x1f4)]=function(_0x48ed05,_0x26e8a0){const _0x46752c=_0x77d410;if(this['isItem'](_0x26e8a0))return![];if(!_0x48ed05)return![];if($gameTemp[_0x46752c(0x228)])return!![];if(BattleManager[_0x46752c(0x427)]())return!![];const _0xe4a9c=this[_0x46752c(0x433)](_0x26e8a0);for(const _0x286d35 of _0xe4a9c){if(!this[_0x46752c(0x2d2)](_0x48ed05,_0x286d35))return![];}return!![];},DataManager[_0x77d410(0x433)]=function(_0x1d730e){const _0x377057=_0x77d410;if(!_0x1d730e)return[];this[_0x377057(0x324)]=this[_0x377057(0x324)]||{};const _0x3d6ba0=_0x377057(0xd9)[_0x377057(0x290)](this['isWeapon'](_0x1d730e)?_0x377057(0x118):'ARMOR',_0x1d730e['id']);if(this[_0x377057(0x324)][_0x3d6ba0]!==undefined)return this[_0x377057(0x324)][_0x3d6ba0];let _0x54d440=[];const _0x2ddd0a=_0x1d730e[_0x377057(0x272)]||'';return _0x2ddd0a[_0x377057(0x336)](/<EQUIP(?:|MENT)[ ]REQUIREMENT(?:|S)>\s*([\s\S]*)\s*<\/EQUIP(?:|MENT)[ ]REQUIREMENT(?:|S)>/i)&&(_0x54d440=String(RegExp['$1'])[_0x377057(0x21e)](/[\r\n]+/)),this['_getEquipRequirements'][_0x3d6ba0]=_0x54d440,this['_getEquipRequirements'][_0x3d6ba0];},DataManager[_0x77d410(0x2d2)]=function(_0x5631bc,_0x1d85b8){const _0x20aacd=_0x77d410;if(_0x1d85b8['match'](/(?:LEVEL|LV|LVL)[ ](>|>=|===|<=|<)[ ](\d+)/i)){const _0x5f16cc=String(RegExp['$1'])['trim'](),_0x419041=Number(RegExp['$2']);switch(_0x5f16cc){case'>':return _0x5631bc[_0x20aacd(0x1cc)]>_0x419041;case'>=':return _0x5631bc[_0x20aacd(0x1cc)]>=_0x419041;case _0x20aacd(0x2b2):return _0x5631bc['level']===_0x419041;case'<=':return _0x5631bc[_0x20aacd(0x1cc)]<=_0x419041;case'<':return _0x5631bc[_0x20aacd(0x1cc)]<_0x419041;}return![];}if(_0x1d85b8[_0x20aacd(0x336)](/(MAXHP|MAXMP|MHP|MMP)[ ](>|>=|===|<=|<)[ ](\d+)/i)){const _0xb9d200=String(RegExp['$1'])[_0x20aacd(0x38e)]()[_0x20aacd(0x72)](),_0x57f49a=String(RegExp['$2'])[_0x20aacd(0x72)](),_0x328f59=Number(RegExp['$3']);let _0x2a0a72=0x0;if(['maxmp',_0x20aacd(0x15f)][_0x20aacd(0x26b)](_0xb9d200))_0x2a0a72=0x1;const _0x2756a7=_0x5631bc[_0x20aacd(0x145)][_0x2a0a72]||0x0;switch(_0x57f49a){case'>':return _0x5631bc['paramBase'](_0x2a0a72)+_0x2756a7>_0x328f59;case'>=':return _0x5631bc[_0x20aacd(0x454)](_0x2a0a72)+_0x2756a7>=_0x328f59;case _0x20aacd(0x2b2):return _0x5631bc[_0x20aacd(0x454)](_0x2a0a72)+_0x2756a7===_0x328f59;case'<=':return _0x5631bc['paramBase'](_0x2a0a72)+_0x2756a7<=_0x328f59;case'<':return _0x5631bc[_0x20aacd(0x454)](_0x2a0a72)+_0x2756a7<_0x328f59;}return![];}if(_0x1d85b8[_0x20aacd(0x336)](/(ATK|DEF|MAT|MDF|AGI|LUK)[ ](>|>=|===|<=|<)[ ](\d+)/i)){const _0x306352=String(RegExp['$1'])[_0x20aacd(0x38e)]()['trim'](),_0x443c78=String(RegExp['$2'])['trim'](),_0x336a16=Number(RegExp['$3']),_0xd900d6=[_0x20aacd(0xae),_0x20aacd(0x3e0),_0x20aacd(0x249),_0x20aacd(0x2da),'agi','luk'];let _0x5bc176=_0xd900d6['indexOf'](_0x306352)+0x2;if(_0x5bc176<0x2)return![];const _0x27de93=_0x5631bc[_0x20aacd(0x145)][_0x5bc176]||0x0;switch(_0x443c78){case'>':return _0x5631bc['paramBase'](_0x5bc176)+_0x27de93>_0x336a16;case'>=':return _0x5631bc[_0x20aacd(0x454)](_0x5bc176)+_0x27de93>=_0x336a16;case'===':return _0x5631bc[_0x20aacd(0x454)](_0x5bc176)+_0x27de93===_0x336a16;case'<=':return _0x5631bc[_0x20aacd(0x454)](_0x5bc176)+_0x27de93<=_0x336a16;case'<':return _0x5631bc[_0x20aacd(0x454)](_0x5bc176)+_0x27de93<_0x336a16;}return![];}if(_0x1d85b8['match'](/LEARNED SKILL:[ ](\d+)/i)){const _0x3038f0=Number(RegExp['$1']);return _0x5631bc[_0x20aacd(0x2e7)](_0x3038f0);}else{if(_0x1d85b8[_0x20aacd(0x336)](/LEARNED SKILL:[ ](.*)/i)){const _0x251505=String(RegExp['$1']),_0x119299=this[_0x20aacd(0x441)](_0x251505);return _0x5631bc[_0x20aacd(0x2e7)](_0x119299);}}if(_0x1d85b8['match'](/SWITCH:[ ](\d+)/i)){const _0x57761a=Number(RegExp['$1']);return $gameSwitches[_0x20aacd(0x3b5)](_0x57761a);}return!![];},DataManager[_0x77d410(0xfb)]=function(_0x7fd40a){const _0x5df24f=_0x77d410;return this['isArmor'](_0x7fd40a)?this[_0x5df24f(0x407)](_0x7fd40a):[_0x7fd40a['etypeId']||0x0];},DataManager['getEtypeIDsCache']=function(_0x205355){const _0x5cf7f9=_0x77d410;this[_0x5cf7f9(0x44c)]=this['_cache_etypeIDs']||{};if(this[_0x5cf7f9(0x44c)][_0x205355['id']]!==undefined)return this[_0x5cf7f9(0x44c)][_0x205355['id']];this[_0x5cf7f9(0x44c)][_0x205355['id']]=[_0x205355[_0x5cf7f9(0x44a)]||0x0];const _0x57e2a1=_0x205355[_0x5cf7f9(0x272)]||'';if(_0x57e2a1[_0x5cf7f9(0x336)](/<ADDED ETYPE(?:|S):[ ](.*)>/i)){const _0x307105=String(RegExp['$1'])[_0x5cf7f9(0x21e)](',')[_0x5cf7f9(0x199)](_0x3d418f=>_0x3d418f[_0x5cf7f9(0x72)]());for(const _0x5c150a of _0x307105){const _0x4aaeb5=/^\d+$/['test'](_0x5c150a);let _0x441572=0x0;_0x4aaeb5?_0x441572=Number(_0x5c150a):_0x441572=this[_0x5cf7f9(0x244)](_0x5c150a),_0x441572>0x1&&this[_0x5cf7f9(0x44c)][_0x205355['id']][_0x5cf7f9(0x31f)](_0x441572);}}return this[_0x5cf7f9(0x44c)][_0x205355['id']];},Game_BattlerBase[_0x77d410(0xc6)][_0x77d410(0xd2)]=function(_0x38892f){const _0x22b327=_0x77d410;return this[_0x22b327(0x180)](_0x38892f[_0x22b327(0x80)])&&!this[_0x22b327(0x21a)](_0x38892f[_0x22b327(0x44a)])&&DataManager[_0x22b327(0xfb)](_0x38892f)[_0x22b327(0x34a)](_0x3fe8aa=>!this[_0x22b327(0x21a)](_0x3fe8aa));},DataManager[_0x77d410(0x2e9)]=function(_0x37de9b){const _0x4ba6a8=_0x77d410;if(!this[_0x4ba6a8(0x24d)](_0x37de9b)&&!this[_0x4ba6a8(0x81)](_0x37de9b))return![];if(Imported[_0x4ba6a8(0x106)]&&this['isWeapon'](_0x37de9b))return![];if(!_0x37de9b[_0x4ba6a8(0x272)])return![];return _0x37de9b[_0x4ba6a8(0x272)]['match'](/<CURSED>/i);},DataManager['getPurifyTransformation']=function(_0x2d9de3){const _0x5b2179=_0x77d410;if(!_0x2d9de3)return _0x2d9de3;if(!this[_0x5b2179(0x24d)](_0x2d9de3)&&!this[_0x5b2179(0x81)](_0x2d9de3))return _0x2d9de3;if(_0x2d9de3[_0x5b2179(0x272)][_0x5b2179(0x336)](/<PURIFY TRANSFORM:[ ](.*)>/i)){const _0x46a3bc=String(RegExp['$1'])['trim'](),_0x1a34df=/^\d+$/[_0x5b2179(0x23f)](_0x46a3bc);if(_0x1a34df){if(this[_0x5b2179(0x24d)](_0x2d9de3))return $dataWeapons[Number(_0x46a3bc)];if(this['isArmor'](_0x2d9de3))return $dataArmors[Number(_0x46a3bc)];}else{if(this[_0x5b2179(0x24d)](_0x2d9de3))return $dataWeapons[this[_0x5b2179(0x27c)](_0x46a3bc)];if(this[_0x5b2179(0x81)](_0x2d9de3))return $dataArmors[this[_0x5b2179(0x3e9)](_0x46a3bc)];}}return _0x2d9de3;},Game_Party[_0x77d410(0xc6)][_0x77d410(0x2d7)]=function(){const _0xde5f47=_0x77d410,_0x22faf8=this[_0xde5f47(0x1c0)]();for(const _0x12092f of _0x22faf8){if(!_0x12092f)continue;_0x12092f[_0xde5f47(0x2d7)]();}},Game_Actor[_0x77d410(0xc6)][_0x77d410(0x2d7)]=function(){const _0x37acbd=_0x77d410,_0xac8ac0=this['equipSlots']()['length'];for(let _0x3d2681=0x0;_0x3d2681<_0xac8ac0;_0x3d2681++){const _0x3d2bf2=this[_0x37acbd(0x390)][_0x3d2681];if(!_0x3d2bf2)continue;const _0x5d9966=_0x3d2bf2['object']();if(!DataManager[_0x37acbd(0x2e9)](_0x5d9966))continue;let _0x57183a=DataManager[_0x37acbd(0x37e)](_0x5d9966);this[_0x37acbd(0x115)](_0x5d9966,_0x57183a)?(this['_equips'][_0x3d2681][_0x37acbd(0x29f)](_0x57183a),this[_0x37acbd(0x2b1)]()):this[_0x37acbd(0x413)](_0x3d2681,null);}},Game_Actor['prototype']['isPurifyItemSwapOk']=function(_0x4aa180,_0x360425){const _0x413f7c=_0x77d410;if(_0x4aa180===_0x360425)return![];const _0x1fa285=DataManager['getEtypeIDs'](_0x360425);if(!_0x1fa285[_0x413f7c(0x26b)](_0x4aa180[_0x413f7c(0x44a)]))return![];if(DataManager[_0x413f7c(0x24d)](_0x360425))return this[_0x413f7c(0x3d8)](_0x360425[_0x413f7c(0x201)]);else{if(DataManager['isArmor'](_0x360425))return this[_0x413f7c(0x180)](_0x360425['atypeId']);}return![];},TextManager[_0x77d410(0x3e6)]={'helpDesc':{'equip':VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x96)]['EquipScene'][_0x77d410(0x141)]??_0x77d410(0x44b),'optimize':VisuMZ[_0x77d410(0x1e8)]['Settings'][_0x77d410(0x176)]['optimizeCmdDesc']??_0x77d410(0x3a8),'clear':VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x96)][_0x77d410(0x176)]['clearCmdDesc']??'Remove\x20all\x20available\x20equipment.'}},ColorManager[_0x77d410(0x430)]=function(_0x4108d2){const _0xed037d=_0x77d410;if(!_0x4108d2)return this[_0xed037d(0x88)]();else{if(_0x4108d2['note'][_0xed037d(0x336)](/<COLOR:[ ](\d+)>/i))return this[_0xed037d(0x462)](Number(RegExp['$1'])[_0xed037d(0x45e)](0x0,0x1f));else return _0x4108d2[_0xed037d(0x272)][_0xed037d(0x336)](/<COLOR:[ ]#(.*)>/i)?'#'+String(RegExp['$1']):this[_0xed037d(0x88)]();}},ColorManager[_0x77d410(0x26a)]=function(_0x3ac75a){const _0x8fe874=_0x77d410;return _0x3ac75a=String(_0x3ac75a),_0x3ac75a[_0x8fe874(0x336)](/#(.*)/i)?_0x8fe874(0x3b4)[_0x8fe874(0x290)](String(RegExp['$1'])):this[_0x8fe874(0x462)](Number(_0x3ac75a));},SceneManager['isSceneShop']=function(){const _0xa005e1=_0x77d410;return this[_0xa005e1(0x12a)]&&this['_scene'][_0xa005e1(0x8d)]===Scene_Shop;},Game_Temp['prototype'][_0x77d410(0x27f)]=function(){const _0x342218=_0x77d410;if(this[_0x342218(0x387)])return![];return VisuMZ[_0x342218(0x1e8)][_0x342218(0x96)][_0x342218(0x312)][_0x342218(0x414)];},VisuMZ[_0x77d410(0x11e)]=VisuMZ[_0x77d410(0x1e8)]['Settings'][_0x77d410(0x166)][_0x77d410(0x350)],VisuMZ[_0x77d410(0x1e8)][_0x77d410(0xf9)]=Game_BattlerBase[_0x77d410(0xc6)][_0x77d410(0xb8)],Game_BattlerBase[_0x77d410(0xc6)]['param']=function(_0x301640){const _0x5db268=_0x77d410;return this[_0x5db268(0x3d0)]?this[_0x5db268(0x251)]?VisuMZ[_0x5db268(0x11e)]:0x1:VisuMZ['ItemsEquipsCore'][_0x5db268(0xf9)][_0x5db268(0x200)](this,_0x301640);},VisuMZ['ItemsEquipsCore'][_0x77d410(0x39e)]=Game_BattlerBase[_0x77d410(0xc6)][_0x77d410(0x44f)],Game_BattlerBase[_0x77d410(0xc6)][_0x77d410(0x44f)]=function(_0x1514f2){const _0x4c8460=_0x77d410;if(!_0x1514f2)return![];if(!VisuMZ[_0x4c8460(0x1e8)]['Game_BattlerBase_meetsItemConditions']['call'](this,_0x1514f2))return![];if(!this[_0x4c8460(0x1cb)](_0x1514f2))return![];if(!this[_0x4c8460(0x25b)](_0x1514f2))return![];return!![];},Game_BattlerBase[_0x77d410(0xc6)][_0x77d410(0x1cb)]=function(_0xba26a1){const _0xe976c5=_0x77d410;if(!this[_0xe976c5(0x3e3)](_0xba26a1))return![];return!![];},Game_BattlerBase['prototype'][_0x77d410(0x3e3)]=function(_0x233a63){const _0x35c2b1=_0x77d410,_0x49884f=_0x233a63[_0x35c2b1(0x272)];if(_0x49884f[_0x35c2b1(0x336)](/<ENABLE[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0x4aa927=JSON['parse']('['+RegExp['$1'][_0x35c2b1(0x336)](/\d+/g)+']');for(const _0x3dc0c2 of _0x4aa927){if(!$gameSwitches[_0x35c2b1(0x3b5)](_0x3dc0c2))return![];}return!![];}if(_0x49884f[_0x35c2b1(0x336)](/<ENABLE ALL[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0x41da73=JSON[_0x35c2b1(0x443)]('['+RegExp['$1'][_0x35c2b1(0x336)](/\d+/g)+']');for(const _0x3aeb52 of _0x41da73){if(!$gameSwitches[_0x35c2b1(0x3b5)](_0x3aeb52))return![];}return!![];}if(_0x49884f[_0x35c2b1(0x336)](/<ENABLE ANY[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0x531d01=JSON['parse']('['+RegExp['$1']['match'](/\d+/g)+']');for(const _0x319e24 of _0x531d01){if($gameSwitches[_0x35c2b1(0x3b5)](_0x319e24))return!![];}return![];}if(_0x49884f[_0x35c2b1(0x336)](/<DISABLE[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0x7a9e21=JSON[_0x35c2b1(0x443)]('['+RegExp['$1']['match'](/\d+/g)+']');for(const _0x2990e5 of _0x7a9e21){if(!$gameSwitches[_0x35c2b1(0x3b5)](_0x2990e5))return!![];}return![];}if(_0x49884f['match'](/<DISABLE ALL[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0x3c1bc4=JSON[_0x35c2b1(0x443)]('['+RegExp['$1']['match'](/\d+/g)+']');for(const _0x22d49b of _0x3c1bc4){if(!$gameSwitches[_0x35c2b1(0x3b5)](_0x22d49b))return!![];}return![];}if(_0x49884f['match'](/<DISABLE ANY[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0x3aa088=JSON[_0x35c2b1(0x443)]('['+RegExp['$1'][_0x35c2b1(0x336)](/\d+/g)+']');for(const _0x3874d8 of _0x3aa088){if($gameSwitches['value'](_0x3874d8))return![];}return!![];}return!![];},Game_BattlerBase[_0x77d410(0xc6)][_0x77d410(0x25b)]=function(_0x2cb77f){const _0x44664c=_0x77d410,_0xe8ff96=_0x2cb77f['note'],_0x1cd29f=VisuMZ[_0x44664c(0x1e8)]['itemEnableJS'];return _0x1cd29f[_0x2cb77f['id']]?_0x1cd29f[_0x2cb77f['id']]['call'](this,_0x2cb77f):!![];},Game_Actor[_0x77d410(0xc6)]['initEquips']=function(_0x3d2297){const _0x5c8222=_0x77d410;_0x3d2297=this['convertInitEquipsToItems'](_0x3d2297);const _0x4faca4=this[_0x5c8222(0x30d)]();this[_0x5c8222(0x390)]=[];for(let _0x11eea1=0x0;_0x11eea1<_0x4faca4[_0x5c8222(0xcc)];_0x11eea1++){this['_equips'][_0x11eea1]=new Game_Item();}for(let _0x59c5a4=0x0;_0x59c5a4<_0x4faca4[_0x5c8222(0xcc)];_0x59c5a4++){const _0x1a598e=_0x4faca4[_0x59c5a4],_0x57d671=this[_0x5c8222(0x294)](_0x3d2297,_0x1a598e);if(this['canEquip'](_0x57d671))this[_0x5c8222(0x390)][_0x59c5a4]['setObject'](_0x57d671);}this[_0x5c8222(0x46b)](!![]),this[_0x5c8222(0x2b1)]();},Game_Actor[_0x77d410(0xc6)][_0x77d410(0x370)]=function(_0x33e06b){const _0x2f104e=_0x77d410,_0x583f27=[];for(let _0x21388b=0x0;_0x21388b<_0x33e06b[_0x2f104e(0xcc)];_0x21388b++){const _0x4b755e=_0x33e06b[_0x21388b];if(_0x4b755e<=0x0)continue;const _0x26c165=$dataSystem['equipTypes'][_0x21388b+0x1];if(_0x26c165===$dataSystem[_0x2f104e(0x3f0)][0x1]||_0x21388b===0x1&&this[_0x2f104e(0x1f7)]())_0x583f27[_0x2f104e(0x31f)]($dataWeapons[_0x4b755e]);else{if(BattleManager[_0x2f104e(0x427)]()){const _0x8b3b5f=$dataArmors[_0x4b755e];_0x8b3b5f&&_0x8b3b5f[_0x2f104e(0x44a)]===_0x21388b+0x1&&_0x583f27[_0x2f104e(0x31f)](_0x8b3b5f);}else{const _0x2670d9=$dataArmors[_0x4b755e];_0x2670d9&&_0x2670d9['etypeId']===_0x21388b+0x1&&_0x583f27[_0x2f104e(0x31f)](_0x2670d9);}}}return _0x583f27;},Game_Actor[_0x77d410(0xc6)][_0x77d410(0x294)]=function(_0x1712eb,_0x1d1a4b){const _0x32aad4=_0x77d410;for(const _0xb78ac3 of _0x1712eb){if(!_0xb78ac3)continue;if(_0xb78ac3['etypeId']===_0x1d1a4b)return _0x1712eb[_0x32aad4(0x437)](_0x1712eb[_0x32aad4(0xbd)](_0xb78ac3),0x1),_0xb78ac3;}return null;},Game_Actor[_0x77d410(0xc6)]['equipSlots']=function(){const _0x4193ca=_0x77d410,_0x206e42=VisuMZ[_0x4193ca(0x1e8)]['deepCopy'](this[_0x4193ca(0x45c)]||this['currentClass']()[_0x4193ca(0x30d)]);if(_0x206e42[_0x4193ca(0xcc)]>=0x2&&this[_0x4193ca(0x1f7)]())_0x206e42[0x1]=0x1;return _0x206e42;},Game_Actor[_0x77d410(0xc6)][_0x77d410(0x89)]=function(_0x47a08f){const _0x19d40e=_0x77d410;_0x47a08f['remove'](0x0),_0x47a08f[_0x19d40e(0x393)](-0x1),this[_0x19d40e(0x45c)]=_0x47a08f,this[_0x19d40e(0x2b1)](),this[_0x19d40e(0x2ac)]();},Game_Actor[_0x77d410(0xc6)][_0x77d410(0xc7)]=function(){const _0x17165d=_0x77d410;this[_0x17165d(0x45c)]=undefined,this[_0x17165d(0x2b1)](),this[_0x17165d(0x2ac)]();},Game_Actor[_0x77d410(0xc6)][_0x77d410(0x2ac)]=function(){const _0x4f0150=_0x77d410;let _0x59a2b2=this['equipSlots']()[_0x4f0150(0xcc)];while(this[_0x4f0150(0x390)][_0x4f0150(0xcc)]>_0x59a2b2){const _0x4b9a4f=this[_0x4f0150(0x390)][this[_0x4f0150(0x390)][_0x4f0150(0xcc)]-0x1];_0x4b9a4f&&_0x4b9a4f['object']()&&$gameParty[_0x4f0150(0x375)](_0x4b9a4f[_0x4f0150(0xde)](),0x1),this[_0x4f0150(0x390)][_0x4f0150(0x33b)]();}while(_0x59a2b2>this[_0x4f0150(0x390)]['length']){this[_0x4f0150(0x390)][_0x4f0150(0x31f)](new Game_Item());}},Game_Actor[_0x77d410(0xc6)][_0x77d410(0x2f9)]=function(){const _0x147d26=_0x77d410,_0x42e591=this[_0x147d26(0x30d)]();for(let _0x42fce2=0x0;_0x42fce2<_0x42e591[_0x147d26(0xcc)];_0x42fce2++){if(!this[_0x147d26(0x390)][_0x42fce2])this['_equips'][_0x42fce2]=new Game_Item();}this[_0x147d26(0x46b)](![]),this[_0x147d26(0x2b1)]();},VisuMZ[_0x77d410(0x1e8)]['Game_Actor_changeEquip']=Game_Actor[_0x77d410(0xc6)][_0x77d410(0x413)],Game_Actor[_0x77d410(0xc6)]['changeEquip']=function(_0x373ea1,_0x280f99){const _0x261df8=_0x77d410;if(!this[_0x261df8(0x3fe)]){const _0x58907f=JsonEx['makeDeepCopy'](this);_0x58907f[_0x261df8(0x3fe)]=!![],this[_0x261df8(0x278)](_0x373ea1,_0x280f99),this[_0x261df8(0x1e0)](_0x58907f);}else this[_0x261df8(0x278)](_0x373ea1,_0x280f99);},Game_Actor['prototype']['changeEquipBase']=function(_0x18d1c5,_0x1e9eca){const _0x3fe7df=_0x77d410;if(!this[_0x3fe7df(0x3af)](_0x1e9eca,this[_0x3fe7df(0x3ac)]()[_0x18d1c5]))return;if(_0x1e9eca){const _0x309cbb=DataManager[_0x3fe7df(0xfb)](_0x1e9eca);if(!_0x309cbb['includes'](this[_0x3fe7df(0x30d)]()[_0x18d1c5]))return;}this[_0x3fe7df(0x390)][_0x18d1c5]['setObject'](_0x1e9eca);if(VisuMZ[_0x3fe7df(0x1e8)][_0x3fe7df(0x20d)](_0x1e9eca)){const _0x40447a=VisuMZ['ItemsEquipsCore'][_0x3fe7df(0x96)][_0x3fe7df(0x176)][_0x3fe7df(0x40c)]||'',_0x1af495=this['name'](),_0x5e8d93=_0x3fe7df(0xc1)['format'](_0x1e9eca[_0x3fe7df(0x214)]),_0x5e45f5=_0x1e9eca[_0x3fe7df(0x123)]||'';let _0x42c087=_0x40447a[_0x3fe7df(0x290)](_0x1af495,_0x5e8d93,_0x5e45f5);if(VisuMZ[_0x3fe7df(0x146)][_0x3fe7df(0x3a7)]>=1.79&&_0x42c087[_0x3fe7df(0xcc)]>0x0)$textPopup(_0x42c087);}this[_0x3fe7df(0x2b1)]();},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x20d)]=function(_0x3f6012){const _0x32e346=_0x77d410;if(!_0x3f6012)return![];if(!Imported[_0x32e346(0x257)])return![];if(VisuMZ[_0x32e346(0x146)]['version']<1.79)return![];return DataManager['isCursedItem'](_0x3f6012);},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x1d3)]=Game_Actor[_0x77d410(0xc6)]['forceChangeEquip'],Game_Actor['prototype'][_0x77d410(0x243)]=function(_0x1179e5,_0x238a1c){const _0x40315f=_0x77d410;if(!this[_0x40315f(0x3fe)]){const _0x29d5d3=JsonEx[_0x40315f(0x222)](this);_0x29d5d3[_0x40315f(0x3fe)]=!![],VisuMZ[_0x40315f(0x1e8)]['Game_Actor_forceChangeEquip']['call'](this,_0x1179e5,_0x238a1c),this[_0x40315f(0x1e0)](_0x29d5d3);}else VisuMZ[_0x40315f(0x1e8)]['Game_Actor_forceChangeEquip'][_0x40315f(0x200)](this,_0x1179e5,_0x238a1c);},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x25d)]=Game_Actor['prototype'][_0x77d410(0x1a9)],Game_Actor[_0x77d410(0xc6)]['discardEquip']=function(_0x3c44e3){const _0xd7e044=_0x77d410;if(!this[_0xd7e044(0x3fe)]){const _0x18747e=JsonEx['makeDeepCopy'](this);_0x18747e[_0xd7e044(0x3fe)]=!![],VisuMZ[_0xd7e044(0x1e8)][_0xd7e044(0x25d)][_0xd7e044(0x200)](this,_0x3c44e3),this[_0xd7e044(0x1e0)](_0x18747e);}else VisuMZ[_0xd7e044(0x1e8)][_0xd7e044(0x25d)][_0xd7e044(0x200)](this,_0x3c44e3);},Game_Actor[_0x77d410(0xc6)][_0x77d410(0x46b)]=function(_0x39f5ad){const _0x5ef3eb=_0x77d410;if(this[_0x5ef3eb(0x7a)])return;let _0x219606=0x0;for(;;){_0x219606++;if(_0x219606>0x3)break;const _0x58b9dd=this[_0x5ef3eb(0x30d)](),_0x56e878=this['equips'](),_0x1efc22=_0x56e878[_0x5ef3eb(0xcc)];let _0x414135=![];for(let _0x3e717f=0x0;_0x3e717f<_0x1efc22;_0x3e717f++){const _0x3300f9=_0x56e878[_0x3e717f];if(!_0x3300f9)continue;const _0x2390ca=DataManager[_0x5ef3eb(0xfb)](_0x3300f9);if(!this['canEquip'](_0x3300f9)||!_0x2390ca[_0x5ef3eb(0x26b)](_0x58b9dd[_0x3e717f])){!_0x39f5ad&&this[_0x5ef3eb(0x3af)](null,_0x3300f9);if(!this[_0x5ef3eb(0x3fe)]){const _0x2909f9=JsonEx[_0x5ef3eb(0x222)](this);_0x2909f9[_0x5ef3eb(0x3fe)]=!![],this['_equips'][_0x3e717f][_0x5ef3eb(0x29f)](null),this[_0x5ef3eb(0x7a)]=!![],this[_0x5ef3eb(0x1e0)](_0x2909f9),this[_0x5ef3eb(0x7a)]=undefined;}else{if(this[_0x5ef3eb(0x390)][_0x3e717f])this[_0x5ef3eb(0x390)][_0x3e717f]['setObject'](null);else continue;}_0x414135=!![];}}if(!_0x414135)break;}},Game_Actor[_0x77d410(0xc6)]['equipAdjustHpMp']=function(_0x5c87ec){const _0x219380=_0x77d410;if(this['_tempActor'])return;if(!VisuMZ[_0x219380(0x1e8)][_0x219380(0x96)][_0x219380(0x176)][_0x219380(0x3d1)])return;const _0x5cfb7a=Math[_0x219380(0x317)](_0x5c87ec[_0x219380(0x12c)]()*this['mhp']),_0x5d42db=Math[_0x219380(0x317)](_0x5c87ec[_0x219380(0x323)]()*this['mmp']);if(this['hp']>0x0)this[_0x219380(0x135)](_0x5cfb7a);if(this['mp']>0x0)this[_0x219380(0x366)](_0x5d42db);},Game_Actor[_0x77d410(0xc6)]['clearEquipments']=function(){const _0x1bdccd=_0x77d410,_0x3e009b=this[_0x1bdccd(0x30d)]()[_0x1bdccd(0xcc)];for(let _0x3ff16a=0x0;_0x3ff16a<_0x3e009b;_0x3ff16a++){if(this[_0x1bdccd(0x248)](_0x3ff16a))this[_0x1bdccd(0x413)](_0x3ff16a,null);}},Game_Actor[_0x77d410(0xc6)][_0x77d410(0x248)]=function(_0x51710e){const _0x469c37=_0x77d410;return this[_0x469c37(0x181)]()[_0x469c37(0x26b)](this[_0x469c37(0x30d)]()[_0x51710e])?![]:this[_0x469c37(0x2ab)](_0x51710e);},Game_Actor[_0x77d410(0xc6)]['nonRemovableEtypes']=function(){const _0x5ae568=_0x77d410;return VisuMZ['ItemsEquipsCore']['Settings'][_0x5ae568(0x176)]['NonRemoveETypes'];},Game_Actor['prototype'][_0x77d410(0x2d1)]=function(){const _0x5ca02d=_0x77d410,_0xac466d=this[_0x5ca02d(0x30d)]()[_0x5ca02d(0xcc)];for(let _0x3991b7=0x0;_0x3991b7<_0xac466d;_0x3991b7++){if(this[_0x5ca02d(0x3df)](_0x3991b7))this[_0x5ca02d(0x413)](_0x3991b7,null);}for(let _0xa9f488=0x0;_0xa9f488<_0xac466d;_0xa9f488++){if(this[_0x5ca02d(0x3df)](_0xa9f488))this['changeEquip'](_0xa9f488,this[_0x5ca02d(0x451)](_0xa9f488));}},Game_Actor['prototype'][_0x77d410(0x451)]=function(_0x1373ee){const _0x35179f=_0x77d410,_0x52623b=this['equipSlots']()[_0x1373ee],_0x408a48=$gameParty['equipItems']()[_0x35179f(0x301)](_0x42321a=>DataManager[_0x35179f(0xfb)](_0x42321a)['includes'](_0x52623b)&&this[_0x35179f(0x2c3)](_0x42321a)&&!DataManager[_0x35179f(0x2e9)](_0x42321a));let _0x1c4cc8=null,_0x3a4e76=-0x3e8;for(let _0xe2e82e=0x0;_0xe2e82e<_0x408a48[_0x35179f(0xcc)];_0xe2e82e++){const _0x255ef7=this[_0x35179f(0x467)](_0x408a48[_0xe2e82e]);_0x255ef7>_0x3a4e76&&(_0x3a4e76=_0x255ef7,_0x1c4cc8=_0x408a48[_0xe2e82e]);}return _0x1c4cc8;},Game_Actor[_0x77d410(0xc6)][_0x77d410(0x3df)]=function(_0x3a9e67){const _0x2fb9bb=_0x77d410;return this[_0x2fb9bb(0x29e)]()['includes'](this[_0x2fb9bb(0x30d)]()[_0x3a9e67])?![]:this['isEquipChangeOk'](_0x3a9e67);},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x2d6)]=Game_Actor['prototype']['isEquipChangeOk'],Game_Actor[_0x77d410(0xc6)][_0x77d410(0x2ab)]=function(_0x11bb81){const _0xb47a30=_0x77d410,_0x3b75fd=this[_0xb47a30(0x390)][_0x11bb81];if(_0x3b75fd){const _0x1fab24=_0x3b75fd[_0xb47a30(0xde)]();if(DataManager['isCursedItem'](_0x1fab24))return![];}return VisuMZ[_0xb47a30(0x1e8)][_0xb47a30(0x2d6)]['call'](this,_0x11bb81);},Game_Actor['prototype'][_0x77d410(0x29e)]=function(){const _0x263717=_0x77d410;return VisuMZ['ItemsEquipsCore'][_0x263717(0x96)][_0x263717(0x176)][_0x263717(0x28f)];},VisuMZ['ItemsEquipsCore'][_0x77d410(0x24c)]=Game_Actor[_0x77d410(0xc6)]['tradeItemWithParty'],Game_Actor[_0x77d410(0xc6)][_0x77d410(0x3af)]=function(_0x638c06,_0x508a2e){const _0x369814=_0x77d410;if(this[_0x369814(0x3fe)])return![];$gameTemp['_bypassNewLabel']=!![];const _0x104c88=VisuMZ[_0x369814(0x1e8)][_0x369814(0x24c)][_0x369814(0x200)](this,_0x638c06,_0x508a2e);return $gameTemp['_bypassNewLabel']=![],_0x104c88;},Game_Actor['prototype']['changeEquipById']=function(_0x37b20c,_0x61c343){const _0x4f6509=_0x77d410,_0x4a3124=this['getNextAvailableEtypeId'](_0x37b20c);if(_0x4a3124<0x0)return;const _0x26063a=_0x37b20c===0x1?$dataWeapons[_0x61c343]:$dataArmors[_0x61c343];this[_0x4f6509(0x413)](_0x4a3124,_0x26063a);},Game_Actor[_0x77d410(0xc6)]['getNextAvailableEtypeId']=function(_0x171f22){const _0x13c635=_0x77d410;let _0x388c40=0x0;const _0x476183=this[_0x13c635(0x30d)](),_0x4e7486=this['equips']();for(let _0x13d5da=0x0;_0x13d5da<_0x476183[_0x13c635(0xcc)];_0x13d5da++){if(_0x476183[_0x13d5da]===_0x171f22){_0x388c40=_0x13d5da;if(!_0x4e7486[_0x13d5da])return _0x388c40;}}return _0x388c40;},VisuMZ[_0x77d410(0x1e8)]['Game_Actor_paramPlus']=Game_Actor[_0x77d410(0xc6)][_0x77d410(0xd1)],Game_Actor[_0x77d410(0xc6)]['paramPlus']=function(_0x36ccdd){const _0x39f03d=_0x77d410;let _0x45d638=VisuMZ[_0x39f03d(0x1e8)][_0x39f03d(0x44e)][_0x39f03d(0x200)](this,_0x36ccdd);for(const _0x1ef211 of this['equips']()){if(_0x1ef211)_0x45d638+=this[_0x39f03d(0x3f7)](_0x1ef211,_0x36ccdd);}return _0x45d638;},Game_Actor[_0x77d410(0xc6)][_0x77d410(0x3f7)]=function(_0x3d71ae,_0x39357e){const _0x2a8299=_0x77d410;if(this[_0x2a8299(0xac)])return 0x0;const _0x52f744=(DataManager[_0x2a8299(0x24d)](_0x3d71ae)?'W%1':'A%1')[_0x2a8299(0x290)](_0x3d71ae['id']),_0x3c2a91='%1-%2'[_0x2a8299(0x290)](_0x52f744,_0x39357e);if(VisuMZ[_0x2a8299(0x1e8)][_0x2a8299(0x211)][_0x3c2a91]){this[_0x2a8299(0xac)]=!![];const _0x24aa0d=VisuMZ['ItemsEquipsCore'][_0x2a8299(0x211)][_0x3c2a91][_0x2a8299(0x200)](this,_0x3d71ae,_0x39357e);return this['_calculatingJSParameters']=![],_0x24aa0d;}else return 0x0;},Game_Actor[_0x77d410(0xc6)][_0x77d410(0x28a)]=function(_0x3c6e82){const _0x68419=_0x77d410;this[_0x68419(0x3d0)]=!![],this[_0x68419(0x251)]=_0x3c6e82;},VisuMZ['ItemsEquipsCore'][_0x77d410(0x30b)]=Game_Party['prototype'][_0x77d410(0x335)],Game_Party[_0x77d410(0xc6)][_0x77d410(0x335)]=function(){const _0x35d33c=_0x77d410;VisuMZ[_0x35d33c(0x1e8)][_0x35d33c(0x30b)][_0x35d33c(0x200)](this),this['initNewItemsList'](),this[_0x35d33c(0xee)]();},Game_Party['prototype'][_0x77d410(0x2e0)]=function(){const _0x1e0ca3=_0x77d410;this[_0x1e0ca3(0x15b)]=[];},Game_Party[_0x77d410(0xc6)][_0x77d410(0x22a)]=function(_0x2115d6){const _0x2680f1=_0x77d410;if(!$gameTemp[_0x2680f1(0x27f)]())return![];if(this[_0x2680f1(0x15b)]===undefined)this[_0x2680f1(0x2e0)]();let _0x42d781='';if(DataManager[_0x2680f1(0x19e)](_0x2115d6))_0x42d781=_0x2680f1(0x378)['format'](_0x2115d6['id']);else{if(DataManager[_0x2680f1(0x24d)](_0x2115d6))_0x42d781='weapon-%1'[_0x2680f1(0x290)](_0x2115d6['id']);else{if(DataManager[_0x2680f1(0x81)](_0x2115d6))_0x42d781=_0x2680f1(0x2f3)[_0x2680f1(0x290)](_0x2115d6['id']);else return;}}return this[_0x2680f1(0x15b)]['includes'](_0x42d781);},Game_Party[_0x77d410(0xc6)][_0x77d410(0x252)]=function(_0x4a59d3){const _0x5f509a=_0x77d410;if(!$gameTemp['newLabelEnabled']())return;if(this[_0x5f509a(0x15b)]===undefined)this[_0x5f509a(0x2e0)]();let _0x59be7e='';if(DataManager[_0x5f509a(0x19e)](_0x4a59d3))_0x59be7e=_0x5f509a(0x378)['format'](_0x4a59d3['id']);else{if(DataManager[_0x5f509a(0x24d)](_0x4a59d3))_0x59be7e='weapon-%1'[_0x5f509a(0x290)](_0x4a59d3['id']);else{if(DataManager[_0x5f509a(0x81)](_0x4a59d3))_0x59be7e=_0x5f509a(0x2f3)[_0x5f509a(0x290)](_0x4a59d3['id']);else return;}}if(!this[_0x5f509a(0x15b)][_0x5f509a(0x26b)](_0x59be7e))this['_newItemsList']['push'](_0x59be7e);},Game_Party[_0x77d410(0xc6)]['clearNewItem']=function(_0x7041b){const _0x2c6b74=_0x77d410;if(!$gameTemp[_0x2c6b74(0x27f)]())return;if(this[_0x2c6b74(0x15b)]===undefined)this[_0x2c6b74(0x2e0)]();let _0x45a374='';if(DataManager[_0x2c6b74(0x19e)](_0x7041b))_0x45a374='item-%1'[_0x2c6b74(0x290)](_0x7041b['id']);else{if(DataManager['isWeapon'](_0x7041b))_0x45a374=_0x2c6b74(0x20b)[_0x2c6b74(0x290)](_0x7041b['id']);else{if(DataManager['isArmor'](_0x7041b))_0x45a374=_0x2c6b74(0x2f3)[_0x2c6b74(0x290)](_0x7041b['id']);else return;}}this[_0x2c6b74(0x15b)]['includes'](_0x45a374)&&this[_0x2c6b74(0x15b)][_0x2c6b74(0x437)](this[_0x2c6b74(0x15b)][_0x2c6b74(0xbd)](_0x45a374),0x1);},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x149)]=Game_Party['prototype'][_0x77d410(0x342)],Game_Party[_0x77d410(0xc6)][_0x77d410(0x342)]=function(_0x4c0e37){const _0x187301=_0x77d410;if(DataManager[_0x187301(0x1a5)](_0x4c0e37))_0x4c0e37=DataManager[_0x187301(0x23c)](_0x4c0e37);return VisuMZ[_0x187301(0x1e8)][_0x187301(0x149)][_0x187301(0x200)](this,_0x4c0e37);},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x41e)]=Game_Party[_0x77d410(0xc6)]['gainItem'],Game_Party[_0x77d410(0xc6)][_0x77d410(0x375)]=function(_0x133124,_0x296f3b,_0x1a6765){const _0x206a2f=_0x77d410;if(DataManager['isProxyItem'](_0x133124))_0x133124=null;const _0x28b327=this['numItems'](_0x133124);VisuMZ[_0x206a2f(0x1e8)]['Game_Party_gainItem'][_0x206a2f(0x200)](this,_0x133124,_0x296f3b,_0x1a6765);if(this[_0x206a2f(0x342)](_0x133124)>_0x28b327)this[_0x206a2f(0x252)](_0x133124);},Game_Party[_0x77d410(0xc6)][_0x77d410(0x17b)]=function(_0x49c6c9){const _0x1d4660=_0x77d410;if(DataManager[_0x1d4660(0x1a5)](_0x49c6c9))_0x49c6c9=DataManager[_0x1d4660(0x23c)](_0x49c6c9);return DataManager['maxItemAmount'](_0x49c6c9);},VisuMZ['ItemsEquipsCore'][_0x77d410(0x417)]=Game_Party[_0x77d410(0xc6)][_0x77d410(0x2f6)],Game_Party['prototype'][_0x77d410(0x2f6)]=function(_0x2c69c1){const _0x183140=_0x77d410;if(_0x2c69c1){const _0x243c4f=_0x2c69c1[_0x183140(0x272)]||'';if(_0x243c4f['match'](/<(?:CONSERVE|PRESERVE):[ ](\d+)([%％])>/i)){const _0x29d25a=Number(RegExp['$1'])*0.01;if(Math[_0x183140(0x12b)]()<_0x29d25a)return;}}VisuMZ['ItemsEquipsCore'][_0x183140(0x417)][_0x183140(0x200)](this,_0x2c69c1);},Game_Party[_0x77d410(0xc6)][_0x77d410(0xee)]=function(){const _0x69238d=_0x77d410;this[_0x69238d(0x3fd)]={'buy':{'gold':0x0,'items':{}},'sell':{'gold':0x0,'items':{}}};},Game_Party['prototype'][_0x77d410(0x236)]=function(){const _0x2741f0=_0x77d410;return this['_shopTrackingData']===undefined&&this[_0x2741f0(0xee)](),this[_0x2741f0(0x3fd)];},Game_Party[_0x77d410(0xc6)][_0x77d410(0x3c8)]=function(_0x14b432,_0x1240ed){const _0x26fdd0=_0x77d410;if(!_0x1240ed)return 0x0;this[_0x26fdd0(0x3fd)]===undefined&&this[_0x26fdd0(0xee)]();const _0x6247ee=this[_0x26fdd0(0x236)]();if(!_0x6247ee[_0x14b432])return 0x0;if(_0x1240ed===_0x26fdd0(0xb0))return _0x6247ee[_0x14b432][_0x26fdd0(0xb0)]=_0x6247ee[_0x14b432][_0x26fdd0(0xb0)]||0x0,_0x6247ee[_0x14b432][_0x26fdd0(0xb0)];else{if(DataManager[_0x26fdd0(0x19e)](_0x1240ed))key=_0x26fdd0(0x378)[_0x26fdd0(0x290)](_0x1240ed['id']);else{if(DataManager[_0x26fdd0(0x24d)](_0x1240ed))key='weapon-%1'['format'](_0x1240ed['id']);else{if(DataManager[_0x26fdd0(0x81)](_0x1240ed))key=_0x26fdd0(0x2f3)[_0x26fdd0(0x290)](_0x1240ed['id']);else return 0x0;}}}return _0x6247ee[_0x14b432][_0x26fdd0(0x284)][key]=_0x6247ee[_0x14b432][_0x26fdd0(0x284)][key]||0x0,_0x6247ee[_0x14b432][_0x26fdd0(0x284)][key];},Game_Party[_0x77d410(0xc6)]['getShopTrackingItemBuy']=function(_0x42b1c5){const _0xce49fd=_0x77d410;return this[_0xce49fd(0x3c8)](_0xce49fd(0x94),_0x42b1c5);},Game_Party[_0x77d410(0xc6)][_0x77d410(0x45b)]=function(_0x54d1d9){const _0x4effec=_0x77d410;return this[_0x4effec(0x3c8)](_0x4effec(0x10e),_0x54d1d9);},Game_Party['prototype'][_0x77d410(0x313)]=function(){const _0x2470b2=_0x77d410;return this[_0x2470b2(0x3c8)](_0x2470b2(0x94),'gold');},Game_Party[_0x77d410(0xc6)][_0x77d410(0xa9)]=function(){const _0x527a94=_0x77d410;return this['getShopTrackingItem'](_0x527a94(0x10e),_0x527a94(0xb0));},Game_Party[_0x77d410(0xc6)][_0x77d410(0xc4)]=function(_0x5be6f6,_0x36b6f3,_0x15d184){const _0x2b70ed=_0x77d410;if(!_0x36b6f3)return;if(_0x15d184<=0x0)return;this['_shopTrackingData']===undefined&&this[_0x2b70ed(0xee)]();const _0x356039=this[_0x2b70ed(0x236)]();if(!_0x356039[_0x5be6f6])return;if(_0x36b6f3==='gold'){_0x356039[_0x5be6f6][_0x2b70ed(0xb0)]=_0x356039[_0x5be6f6][_0x2b70ed(0xb0)]||0x0,_0x356039[_0x5be6f6]['gold']+=_0x15d184;return;}else{if(DataManager[_0x2b70ed(0x19e)](_0x36b6f3))key=_0x2b70ed(0x378)[_0x2b70ed(0x290)](_0x36b6f3['id']);else{if(DataManager[_0x2b70ed(0x24d)](_0x36b6f3))key=_0x2b70ed(0x20b)[_0x2b70ed(0x290)](_0x36b6f3['id']);else{if(DataManager[_0x2b70ed(0x81)](_0x36b6f3))key=_0x2b70ed(0x2f3)[_0x2b70ed(0x290)](_0x36b6f3['id']);else return;}}}_0x356039[_0x5be6f6][_0x2b70ed(0x284)][key]=_0x356039[_0x5be6f6]['items'][key]||0x0,_0x356039[_0x5be6f6][_0x2b70ed(0x284)][key]+=_0x15d184;},Game_Party[_0x77d410(0xc6)]['addShopTrackingItemBuy']=function(_0x136a71,_0x24f475){const _0x49951c=_0x77d410;this['addShopTrackingItem'](_0x49951c(0x94),_0x136a71,_0x24f475);},Game_Party[_0x77d410(0xc6)][_0x77d410(0x300)]=function(_0x2d099b,_0xee16a3){const _0x5ea843=_0x77d410;this[_0x5ea843(0xc4)](_0x5ea843(0x10e),_0x2d099b,_0xee16a3);},Game_Party['prototype'][_0x77d410(0x3c9)]=function(_0x3c1c2d){const _0x4c6557=_0x77d410;this[_0x4c6557(0xc4)]('buy',_0x4c6557(0xb0),_0x3c1c2d);},Game_Party[_0x77d410(0xc6)][_0x77d410(0x134)]=function(_0x16c017){const _0x354f08=_0x77d410;this['addShopTrackingItem'](_0x354f08(0x10e),_0x354f08(0xb0),_0x16c017);},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0xb4)]=Scene_ItemBase[_0x77d410(0xc6)][_0x77d410(0x9d)],Scene_ItemBase['prototype'][_0x77d410(0x9d)]=function(){const _0x2798ff=_0x77d410;VisuMZ[_0x2798ff(0x1e8)][_0x2798ff(0xb4)][_0x2798ff(0x200)](this),this[_0x2798ff(0x28c)][_0x2798ff(0x432)]();},Scene_Item[_0x77d410(0xc6)][_0x77d410(0x2d8)]=function(){const _0x19f2af=_0x77d410;if(ConfigManager[_0x19f2af(0x33c)]&&ConfigManager[_0x19f2af(0x9a)]!==undefined)return ConfigManager[_0x19f2af(0x9a)];else return this[_0x19f2af(0x30a)]()?this[_0x19f2af(0x365)]()[_0x19f2af(0x336)](/LOWER/i):Scene_ItemBase[_0x19f2af(0xc6)][_0x19f2af(0x2d8)]['call'](this);},Scene_Item[_0x77d410(0xc6)][_0x77d410(0x2d4)]=function(){const _0x418f7d=_0x77d410;if(ConfigManager['uiMenuStyle']&&ConfigManager[_0x418f7d(0x2cf)]!==undefined)return ConfigManager[_0x418f7d(0x2cf)];else return this[_0x418f7d(0x30a)]()?this[_0x418f7d(0x365)]()['match'](/RIGHT/i):Scene_ItemBase['prototype'][_0x418f7d(0x2d4)][_0x418f7d(0x200)](this);},Scene_Item['prototype']['updatedLayoutStyle']=function(){const _0x12db6f=_0x77d410;return VisuMZ[_0x12db6f(0x1e8)][_0x12db6f(0x96)][_0x12db6f(0x3cc)]['LayoutStyle'];},Scene_Item[_0x77d410(0xc6)][_0x77d410(0x460)]=function(){const _0x1efcdf=_0x77d410;return this[_0x1efcdf(0x2bd)]&&this[_0x1efcdf(0x2bd)][_0x1efcdf(0x460)]();},Scene_Item[_0x77d410(0xc6)][_0x77d410(0x30a)]=function(){const _0x1c4215=_0x77d410;return VisuMZ[_0x1c4215(0x1e8)][_0x1c4215(0x96)][_0x1c4215(0x3cc)][_0x1c4215(0x2e3)];},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x2a1)]=Scene_Item[_0x77d410(0xc6)][_0x77d410(0x3bf)],Scene_Item[_0x77d410(0xc6)][_0x77d410(0x3bf)]=function(){const _0x47b6f6=_0x77d410;VisuMZ[_0x47b6f6(0x1e8)][_0x47b6f6(0x2a1)][_0x47b6f6(0x200)](this),this[_0x47b6f6(0x460)]()&&this[_0x47b6f6(0x1b2)]();},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x374)]=Scene_Item[_0x77d410(0xc6)]['helpWindowRect'],Scene_Item[_0x77d410(0xc6)][_0x77d410(0x37b)]=function(){const _0x39b1bf=_0x77d410;return this['isUseItemsEquipsCoreUpdatedLayout']()?this[_0x39b1bf(0x465)]():VisuMZ[_0x39b1bf(0x1e8)][_0x39b1bf(0x374)][_0x39b1bf(0x200)](this);},Scene_Item[_0x77d410(0xc6)][_0x77d410(0x465)]=function(){const _0xf1f9c8=_0x77d410,_0x131a3b=0x0,_0x542b3d=this[_0xf1f9c8(0x2e5)](),_0x1aa6e9=Graphics[_0xf1f9c8(0x175)],_0x290ab0=this[_0xf1f9c8(0xb3)]();return new Rectangle(_0x131a3b,_0x542b3d,_0x1aa6e9,_0x290ab0);},VisuMZ[_0x77d410(0x1e8)]['Scene_Item_createCategoryWindow']=Scene_Item[_0x77d410(0xc6)][_0x77d410(0x3c3)],Scene_Item[_0x77d410(0xc6)][_0x77d410(0x3c3)]=function(){const _0x38cd3c=_0x77d410;VisuMZ[_0x38cd3c(0x1e8)][_0x38cd3c(0x21d)][_0x38cd3c(0x200)](this),this['isUseModernControls']()&&this['postCreateCategoryWindowItemsEquipsCore']();},Scene_Item['prototype']['postCreateCategoryWindowItemsEquipsCore']=function(){const _0x19d62c=_0x77d410;delete this[_0x19d62c(0x2bd)][_0x19d62c(0x1b0)]['ok'],delete this['_categoryWindow']['_handlers']['cancel'];},VisuMZ[_0x77d410(0x1e8)]['Scene_Item_categoryWindowRect']=Scene_Item[_0x77d410(0xc6)][_0x77d410(0x1c7)],Scene_Item[_0x77d410(0xc6)][_0x77d410(0x1c7)]=function(){const _0x109029=_0x77d410;return this[_0x109029(0x30a)]()?this[_0x109029(0x2d9)]():VisuMZ[_0x109029(0x1e8)][_0x109029(0xe9)][_0x109029(0x200)](this);},Scene_Item['prototype']['categoryWindowRectItemsEquipsCore']=function(){const _0x218bb6=_0x77d410,_0x1c684a=0x0,_0x4c0c97=this['mainAreaTop'](),_0x46dda9=Graphics[_0x218bb6(0x175)],_0x5d8b3c=this[_0x218bb6(0x37a)](0x1,!![]);return new Rectangle(_0x1c684a,_0x4c0c97,_0x46dda9,_0x5d8b3c);},VisuMZ[_0x77d410(0x1e8)]['Scene_Item_createItemWindow']=Scene_Item[_0x77d410(0xc6)][_0x77d410(0x24e)],Scene_Item['prototype'][_0x77d410(0x24e)]=function(){const _0x1d9af1=_0x77d410;VisuMZ[_0x1d9af1(0x1e8)][_0x1d9af1(0x42b)]['call'](this),this['isUseModernControls']()&&this['postCreateItemWindowModernControls'](),this['allowCreateStatusWindow']()&&this[_0x1d9af1(0x344)]();},VisuMZ['ItemsEquipsCore'][_0x77d410(0x18c)]=Scene_Item[_0x77d410(0xc6)][_0x77d410(0x192)],Scene_Item[_0x77d410(0xc6)][_0x77d410(0x192)]=function(){const _0x57d246=_0x77d410;if(this[_0x57d246(0x30a)]())return this[_0x57d246(0x184)]();else{const _0x31e532=VisuMZ[_0x57d246(0x1e8)][_0x57d246(0x18c)][_0x57d246(0x200)](this);return this[_0x57d246(0x25a)]()&&this[_0x57d246(0xd5)]()&&(_0x31e532[_0x57d246(0x28e)]-=this[_0x57d246(0x18e)]()),_0x31e532;}},Scene_Item['prototype'][_0x77d410(0x184)]=function(){const _0x23881d=_0x77d410,_0x3fe304=this[_0x23881d(0x2d4)]()?this[_0x23881d(0x18e)]():0x0,_0x172ce6=this[_0x23881d(0x2bd)]['y']+this[_0x23881d(0x2bd)][_0x23881d(0x2b5)],_0x3223c4=Graphics['boxWidth']-this[_0x23881d(0x18e)](),_0x325127=this[_0x23881d(0x21c)]()-_0x172ce6;return new Rectangle(_0x3fe304,_0x172ce6,_0x3223c4,_0x325127);},Scene_Item['prototype']['postCreateItemWindowModernControls']=function(){const _0x52baca=_0x77d410;this['_itemWindow'][_0x52baca(0x3e1)]('cancel',this['popScene'][_0x52baca(0x1ac)](this));},Scene_Item[_0x77d410(0xc6)][_0x77d410(0x25a)]=function(){const _0x22b36f=_0x77d410;return this[_0x22b36f(0x30a)]()?!![]:VisuMZ[_0x22b36f(0x1e8)][_0x22b36f(0x96)]['ItemScene'][_0x22b36f(0x286)];},Scene_Item[_0x77d410(0xc6)][_0x77d410(0xd5)]=function(){const _0x2229ba=_0x77d410;return VisuMZ['ItemsEquipsCore'][_0x2229ba(0x96)][_0x2229ba(0x3cc)][_0x2229ba(0x208)];},Scene_Item[_0x77d410(0xc6)][_0x77d410(0x344)]=function(){const _0x17b1d9=_0x77d410,_0x428547=this[_0x17b1d9(0x3db)]();this[_0x17b1d9(0x151)]=new Window_ShopStatus(_0x428547),this[_0x17b1d9(0x33a)](this[_0x17b1d9(0x151)]),this[_0x17b1d9(0x28c)][_0x17b1d9(0x1ab)](this[_0x17b1d9(0x151)]);const _0x1c712e=VisuMZ[_0x17b1d9(0x1e8)][_0x17b1d9(0x96)][_0x17b1d9(0x3cc)][_0x17b1d9(0x1cd)];this['_statusWindow']['setBackgroundType'](_0x1c712e||0x0);},Scene_Item[_0x77d410(0xc6)][_0x77d410(0x3db)]=function(){const _0x240aca=_0x77d410;return this[_0x240aca(0x30a)]()?this['statusWindowRectItemsEquipsCore']():VisuMZ[_0x240aca(0x1e8)][_0x240aca(0x96)][_0x240aca(0x3cc)][_0x240aca(0x1e1)][_0x240aca(0x200)](this);},Scene_Item['prototype'][_0x77d410(0x391)]=function(){const _0x817a14=_0x77d410,_0x48ca13=this[_0x817a14(0x18e)](),_0x106586=this[_0x817a14(0x28c)][_0x817a14(0x2b5)],_0x590e33=this[_0x817a14(0x2d4)]()?0x0:Graphics[_0x817a14(0x175)]-this[_0x817a14(0x18e)](),_0x475373=this[_0x817a14(0x28c)]['y'];return new Rectangle(_0x590e33,_0x475373,_0x48ca13,_0x106586);},Scene_Item[_0x77d410(0xc6)][_0x77d410(0x18e)]=function(){const _0xc44112=_0x77d410;return Scene_Shop[_0xc44112(0xc6)][_0xc44112(0x18e)]();},Scene_Item[_0x77d410(0xc6)]['buttonAssistItemListRequirement']=function(){const _0x5c9e87=_0x77d410;if(!this['updatedLayoutStyle']())return![];if(!this[_0x5c9e87(0x460)]())return![];if(!this[_0x5c9e87(0x28c)])return![];if(!this[_0x5c9e87(0x28c)][_0x5c9e87(0x245)])return![];return this['updatedLayoutStyle']()&&this[_0x5c9e87(0x460)]();},Scene_Item[_0x77d410(0xc6)][_0x77d410(0x422)]=function(){const _0x10d4aa=_0x77d410;if(this['buttonAssistItemListRequirement']())return this[_0x10d4aa(0x28c)][_0x10d4aa(0x107)]()===0x1?TextManager['getInputMultiButtonStrings'](_0x10d4aa(0x12d),_0x10d4aa(0x1d4)):TextManager['getInputMultiButtonStrings'](_0x10d4aa(0x2ca),_0x10d4aa(0x2fc));return Scene_ItemBase['prototype'][_0x10d4aa(0x422)][_0x10d4aa(0x200)](this);},Scene_Item[_0x77d410(0xc6)][_0x77d410(0xa7)]=function(){const _0x35d245=_0x77d410;if(this[_0x35d245(0x43e)]())return VisuMZ[_0x35d245(0x1e8)]['Settings']['ItemScene'][_0x35d245(0x193)];return Scene_ItemBase[_0x35d245(0xc6)][_0x35d245(0xa7)][_0x35d245(0x200)](this);},Scene_Equip[_0x77d410(0xc6)]['start']=function(){const _0x56ed26=_0x77d410;Scene_ItemBase['prototype']['start'][_0x56ed26(0x200)](this),this[_0x56ed26(0x1f2)]();},Scene_Equip[_0x77d410(0xc6)]['isBottomHelpMode']=function(){const _0x453998=_0x77d410;if(ConfigManager['uiMenuStyle']&&ConfigManager[_0x453998(0x9a)]!==undefined)return ConfigManager[_0x453998(0x9a)];else{if(this[_0x453998(0x30a)]())return this[_0x453998(0x365)]()[_0x453998(0x336)](/LOWER/i);else Scene_MenuBase['prototype'][_0x453998(0x2d4)][_0x453998(0x200)](this);}},Scene_Equip['prototype'][_0x77d410(0x2d4)]=function(){const _0x35912d=_0x77d410;if(ConfigManager[_0x35912d(0x33c)]&&ConfigManager[_0x35912d(0x2cf)]!==undefined)return ConfigManager[_0x35912d(0x2cf)];else{if(this['isUseItemsEquipsCoreUpdatedLayout']())return this['updatedLayoutStyle']()[_0x35912d(0x336)](/RIGHT/i);else Scene_MenuBase[_0x35912d(0xc6)]['isRightInputMode'][_0x35912d(0x200)](this);}},Scene_Equip[_0x77d410(0xc6)][_0x77d410(0x365)]=function(){const _0x167b05=_0x77d410;return VisuMZ['ItemsEquipsCore'][_0x167b05(0x96)]['EquipScene'][_0x167b05(0x394)];},Scene_Equip[_0x77d410(0xc6)]['isUseModernControls']=function(){const _0x2f5837=_0x77d410;return this[_0x2f5837(0x397)]&&this['_commandWindow'][_0x2f5837(0x460)]();},Scene_Equip[_0x77d410(0xc6)][_0x77d410(0x30a)]=function(){const _0x340fa5=_0x77d410;return VisuMZ[_0x340fa5(0x1e8)]['Settings'][_0x340fa5(0x176)][_0x340fa5(0x2e3)];},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x402)]=Scene_Equip[_0x77d410(0xc6)][_0x77d410(0x3bf)],Scene_Equip['prototype'][_0x77d410(0x3bf)]=function(){const _0x5c7051=_0x77d410;VisuMZ[_0x5c7051(0x1e8)]['Scene_Equip_create']['call'](this),this[_0x5c7051(0x460)]()&&this['commandEquip']();},VisuMZ['ItemsEquipsCore'][_0x77d410(0x187)]=Scene_Equip[_0x77d410(0xc6)][_0x77d410(0x37b)],Scene_Equip[_0x77d410(0xc6)][_0x77d410(0x37b)]=function(){const _0x864fa5=_0x77d410;return this['isUseItemsEquipsCoreUpdatedLayout']()?this['helpWindowRectItemsEquipsCore']():VisuMZ[_0x864fa5(0x1e8)][_0x864fa5(0x187)][_0x864fa5(0x200)](this);},Scene_Equip['prototype'][_0x77d410(0x465)]=function(){const _0x528195=_0x77d410,_0x590c5b=0x0,_0x2128eb=this[_0x528195(0x2e5)](),_0x5d026e=Graphics['boxWidth'],_0xe0b0be=this['helpAreaHeight']();return new Rectangle(_0x590c5b,_0x2128eb,_0x5d026e,_0xe0b0be);},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x346)]=Scene_Equip[_0x77d410(0xc6)]['statusWindowRect'],Scene_Equip['prototype'][_0x77d410(0x3db)]=function(){const _0x526177=_0x77d410;return this[_0x526177(0x30a)]()?this[_0x526177(0x391)]():VisuMZ['ItemsEquipsCore'][_0x526177(0x346)][_0x526177(0x200)](this);},Scene_Equip[_0x77d410(0xc6)][_0x77d410(0x391)]=function(){const _0xe0a113=_0x77d410,_0x1ad6ef=this['isRightInputMode']()?0x0:Graphics[_0xe0a113(0x175)]-this[_0xe0a113(0x18e)](),_0x34c676=this[_0xe0a113(0x31c)](),_0x2627a2=this['statusWidth'](),_0x3b0923=this[_0xe0a113(0x3d2)]();return new Rectangle(_0x1ad6ef,_0x34c676,_0x2627a2,_0x3b0923);},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0xa5)]=Scene_Equip[_0x77d410(0xc6)]['createCommandWindow'],Scene_Equip[_0x77d410(0xc6)][_0x77d410(0x206)]=function(){const _0xaab258=_0x77d410;VisuMZ[_0xaab258(0x1e8)][_0xaab258(0xa5)][_0xaab258(0x200)](this);if(this['_helpWindow'])this[_0xaab258(0x397)][_0xaab258(0x458)](this[_0xaab258(0x2f2)]);},VisuMZ[_0x77d410(0x1e8)]['Scene_Equip_commandWindowRect']=Scene_Equip[_0x77d410(0xc6)][_0x77d410(0x3b7)],Scene_Equip[_0x77d410(0xc6)][_0x77d410(0x3b7)]=function(){const _0x34605b=_0x77d410;return this[_0x34605b(0x30a)]()?this[_0x34605b(0x142)]():VisuMZ[_0x34605b(0x1e8)]['Scene_Equip_commandWindowRect']['call'](this);},Scene_Equip['prototype'][_0x77d410(0x32a)]=function(){const _0x5c9136=_0x77d410,_0x374acb=VisuMZ[_0x5c9136(0x1e8)][_0x5c9136(0x96)][_0x5c9136(0x176)];return _0x374acb[_0x5c9136(0xb1)]||_0x374acb['CommandAddClear'];},Scene_Equip['prototype']['commandWindowRectItemsEquipsCore']=function(){const _0x35a97e=_0x77d410,_0x511df9=this[_0x35a97e(0x32a)](),_0x27b3a1=this[_0x35a97e(0x2d4)]()?this[_0x35a97e(0x18e)]():0x0,_0x1d4f19=this['mainAreaTop'](),_0x111105=Graphics[_0x35a97e(0x175)]-this[_0x35a97e(0x18e)](),_0x5dbe98=_0x511df9?this['calcWindowHeight'](0x1,!![]):0x0;return new Rectangle(_0x27b3a1,_0x1d4f19,_0x111105,_0x5dbe98);},VisuMZ[_0x77d410(0x1e8)]['Scene_Equip_createSlotWindow']=Scene_Equip['prototype']['createSlotWindow'],Scene_Equip[_0x77d410(0xc6)][_0x77d410(0x325)]=function(){const _0x362f0d=_0x77d410;VisuMZ[_0x362f0d(0x1e8)][_0x362f0d(0x386)][_0x362f0d(0x200)](this),this['isUseModernControls']()&&this[_0x362f0d(0x3c0)]();},VisuMZ['ItemsEquipsCore']['Scene_Equip_slotWindowRect']=Scene_Equip[_0x77d410(0xc6)][_0x77d410(0x212)],Scene_Equip[_0x77d410(0xc6)][_0x77d410(0x212)]=function(){const _0x159e6d=_0x77d410;return this[_0x159e6d(0x30a)]()?this['slotWindowRectItemsEquipsCore']():VisuMZ[_0x159e6d(0x1e8)]['Scene_Equip_slotWindowRect'][_0x159e6d(0x200)](this);},Scene_Equip[_0x77d410(0xc6)][_0x77d410(0x281)]=function(){const _0xa54f11=_0x77d410,_0x2732f8=this[_0xa54f11(0x3b7)](),_0x13f040=this[_0xa54f11(0x2d4)]()?this[_0xa54f11(0x18e)]():0x0,_0x27b718=_0x2732f8['y']+_0x2732f8[_0xa54f11(0x2b5)],_0x12605a=Graphics[_0xa54f11(0x175)]-this['statusWidth'](),_0xf1043e=this[_0xa54f11(0x3d2)]()-_0x2732f8[_0xa54f11(0x2b5)];return new Rectangle(_0x13f040,_0x27b718,_0x12605a,_0xf1043e);},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x210)]=Scene_Equip[_0x77d410(0xc6)][_0x77d410(0x192)],Scene_Equip[_0x77d410(0xc6)][_0x77d410(0x192)]=function(){const _0x4e0de7=_0x77d410;return this[_0x4e0de7(0x30a)]()?this[_0x4e0de7(0x212)]():VisuMZ['ItemsEquipsCore']['Scene_Equip_itemWindowRect'][_0x4e0de7(0x200)](this);},Scene_Equip[_0x77d410(0xc6)][_0x77d410(0x18e)]=function(){const _0x4ed6e9=_0x77d410;return this[_0x4ed6e9(0x30a)]()?this[_0x4ed6e9(0x220)]():VisuMZ[_0x4ed6e9(0x1e8)][_0x4ed6e9(0x96)][_0x4ed6e9(0x176)][_0x4ed6e9(0x18b)];},Scene_Equip['prototype']['geUpdatedLayoutStatusWidth']=function(){const _0x2c2479=_0x77d410;return Math[_0x2c2479(0xc9)](Graphics[_0x2c2479(0x175)]/0x2);},Scene_Equip[_0x77d410(0xc6)][_0x77d410(0x3c0)]=function(){const _0x38c77b=_0x77d410;this[_0x38c77b(0xf6)]['setHandler'](_0x38c77b(0x144),this[_0x38c77b(0x16f)][_0x38c77b(0x1ac)](this)),this[_0x38c77b(0xf6)]['setHandler'](_0x38c77b(0x2fc),this['nextActor'][_0x38c77b(0x1ac)](this)),this['_slotWindow'][_0x38c77b(0x3e1)]('pageup',this[_0x38c77b(0x190)]['bind'](this));},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x27e)]=Scene_Equip[_0x77d410(0xc6)]['commandEquip'],Scene_Equip[_0x77d410(0xc6)]['commandEquip']=function(){const _0x541f0d=_0x77d410;this[_0x541f0d(0x460)]()&&(this[_0x541f0d(0x397)][_0x541f0d(0x2a5)](),this[_0x541f0d(0x397)][_0x541f0d(0x2c4)]()),VisuMZ[_0x541f0d(0x1e8)]['Scene_Equip_commandEquip'][_0x541f0d(0x200)](this);},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x31b)]=Scene_Equip['prototype'][_0x77d410(0x283)],Scene_Equip[_0x77d410(0xc6)][_0x77d410(0x283)]=function(){const _0x401400=_0x77d410;this['_slotWindow'][_0x401400(0x418)]()>=0x0?(VisuMZ['ItemsEquipsCore'][_0x401400(0x31b)]['call'](this),this[_0x401400(0x39f)]()):(this[_0x401400(0xf6)][_0x401400(0x85)](0x0),this[_0x401400(0xf6)][_0x401400(0x322)]());},Scene_Equip['prototype'][_0x77d410(0x39f)]=function(){const _0x3ee826=_0x77d410;this['_itemWindow'][_0x3ee826(0x2b1)]();const _0x57f691=this[_0x3ee826(0xf6)][_0x3ee826(0x298)](),_0x9536b8=this['_itemWindow'][_0x3ee826(0x1e9)][_0x3ee826(0xbd)](_0x57f691),_0x45ad3b=Math[_0x3ee826(0xc9)](this[_0x3ee826(0x28c)][_0x3ee826(0x19b)]()/0x2)-0x1;this[_0x3ee826(0x28c)][_0x3ee826(0x85)](_0x9536b8>=0x0?_0x9536b8:0x0),this[_0x3ee826(0x28c)][_0x3ee826(0x41c)]>0x1&&(this[_0x3ee826(0x28c)][_0x3ee826(0x41c)]=0x1,this[_0x3ee826(0x28c)][_0x3ee826(0x373)]()),this[_0x3ee826(0x28c)][_0x3ee826(0x41a)](this[_0x3ee826(0x28c)][_0x3ee826(0x418)]()-_0x45ad3b);},VisuMZ[_0x77d410(0x1e8)]['Scene_Equip_onSlotCancel']=Scene_Equip[_0x77d410(0xc6)][_0x77d410(0x240)],Scene_Equip['prototype'][_0x77d410(0x240)]=function(){const _0x557219=_0x77d410;VisuMZ['ItemsEquipsCore'][_0x557219(0xea)][_0x557219(0x200)](this),this['isUseModernControls']()&&(this['_commandWindow'][_0x557219(0x85)](0x0),this[_0x557219(0xf6)][_0x557219(0x2c4)]());},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0xd0)]=Scene_Equip[_0x77d410(0xc6)][_0x77d410(0x92)],Scene_Equip['prototype'][_0x77d410(0x92)]=function(){const _0x122c91=_0x77d410;VisuMZ[_0x122c91(0x1e8)]['Scene_Equip_onActorChange'][_0x122c91(0x200)](this),this['isUseModernControls']()&&(this[_0x122c91(0x397)][_0x122c91(0x2c4)](),this[_0x122c91(0x397)]['deselect'](),this[_0x122c91(0xf6)][_0x122c91(0x85)](0x0),this['_slotWindow'][_0x122c91(0x322)]());},Scene_Equip['prototype'][_0x77d410(0x11f)]=function(){const _0xf1c9ae=_0x77d410;if(!this[_0xf1c9ae(0xf6)])return![];if(!this[_0xf1c9ae(0xf6)][_0xf1c9ae(0x245)])return![];return this[_0xf1c9ae(0xf6)][_0xf1c9ae(0x140)]();},Scene_Equip[_0x77d410(0xc6)][_0x77d410(0x367)]=function(){const _0x2f374d=_0x77d410;if(this[_0x2f374d(0x11f)]())return TextManager['getInputButtonString'](_0x2f374d(0x2ed));return Scene_MenuBase[_0x2f374d(0xc6)][_0x2f374d(0x367)][_0x2f374d(0x200)](this);},Scene_Equip[_0x77d410(0xc6)][_0x77d410(0x188)]=function(){const _0x5e004d=_0x77d410;if(this[_0x5e004d(0x11f)]())return VisuMZ[_0x5e004d(0x1e8)][_0x5e004d(0x96)][_0x5e004d(0x176)]['buttonAssistRemove'];return Scene_MenuBase[_0x5e004d(0xc6)][_0x5e004d(0x188)]['call'](this);},Scene_Equip[_0x77d410(0xc6)][_0x77d410(0xa1)]=function(){const _0x36040c=_0x77d410;if(this[_0x36040c(0x11f)]())return this[_0x36040c(0x174)]['width']/0x5/-0x3;return Scene_MenuBase['prototype'][_0x36040c(0xa1)]['call'](this);},Scene_Equip[_0x77d410(0xc6)][_0x77d410(0x16f)]=function(){const _0x5d64b4=_0x77d410;SceneManager[_0x5d64b4(0x33b)]();},VisuMZ['ItemsEquipsCore'][_0x77d410(0x3a6)]=Scene_Load[_0x77d410(0xc6)][_0x77d410(0x203)],Scene_Load['prototype'][_0x77d410(0x203)]=function(){const _0x439e38=_0x77d410;VisuMZ[_0x439e38(0x1e8)][_0x439e38(0x3a6)][_0x439e38(0x200)](this),this[_0x439e38(0x84)]();},Scene_Load[_0x77d410(0xc6)][_0x77d410(0x84)]=function(){const _0x2dbc92=_0x77d410;if($gameSystem[_0x2dbc92(0x6a)]()!==$dataSystem[_0x2dbc92(0x6a)])for(const _0xffe377 of $gameActors[_0x2dbc92(0x1e9)]){if(_0xffe377)_0xffe377['prepareNewEquipSlotsOnLoad']();}},Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x2d8)]=function(){const _0x1a13b2=_0x77d410;if(ConfigManager[_0x1a13b2(0x33c)]&&ConfigManager[_0x1a13b2(0x9a)]!==undefined)return ConfigManager['uiHelpPosition'];else{if(this['isUseItemsEquipsCoreUpdatedLayout']())return this[_0x1a13b2(0x365)]()[_0x1a13b2(0x336)](/LOWER/i);else Scene_MenuBase[_0x1a13b2(0xc6)]['isRightInputMode']['call'](this);}},Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x2d4)]=function(){const _0x5d2909=_0x77d410;if(ConfigManager[_0x5d2909(0x33c)]&&ConfigManager['uiInputPosition']!==undefined)return ConfigManager[_0x5d2909(0x2cf)];else{if(this['isUseItemsEquipsCoreUpdatedLayout']())return this[_0x5d2909(0x365)]()[_0x5d2909(0x336)](/RIGHT/i);else Scene_MenuBase[_0x5d2909(0xc6)][_0x5d2909(0x2d4)][_0x5d2909(0x200)](this);}},Scene_Shop['prototype']['updatedLayoutStyle']=function(){const _0xd4b7f2=_0x77d410;return VisuMZ[_0xd4b7f2(0x1e8)][_0xd4b7f2(0x96)][_0xd4b7f2(0x362)][_0xd4b7f2(0x394)];},Scene_Shop['prototype'][_0x77d410(0x460)]=function(){const _0x3c1933=_0x77d410;return this[_0x3c1933(0x2bd)]&&this[_0x3c1933(0x2bd)][_0x3c1933(0x460)]();},Scene_Shop['prototype'][_0x77d410(0x30a)]=function(){const _0x344b31=_0x77d410;return VisuMZ[_0x344b31(0x1e8)][_0x344b31(0x96)][_0x344b31(0x362)][_0x344b31(0x2e3)];},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x2bb)]=Scene_Shop['prototype'][_0x77d410(0x217)],Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x217)]=function(_0x5524f0,_0x1620b9){const _0x56bf19=_0x77d410;_0x5524f0=VisuMZ[_0x56bf19(0x1e8)]['deepCopy'](_0x5524f0),VisuMZ['ItemsEquipsCore'][_0x56bf19(0x2bb)][_0x56bf19(0x200)](this,_0x5524f0,_0x1620b9),this[_0x56bf19(0x1a8)]();},Scene_Shop[_0x77d410(0xc6)]['adjustHiddenShownGoods']=function(){const _0x2bfd00=_0x77d410;this[_0x2bfd00(0x262)]=0x0;const _0x9a44ee=[];for(const _0x26bc8d of this[_0x2bfd00(0x158)]){this[_0x2bfd00(0x239)](_0x26bc8d)?this[_0x2bfd00(0x262)]++:_0x9a44ee[_0x2bfd00(0x31f)](_0x26bc8d);}for(const _0x21d296 of _0x9a44ee){this['_goods'][_0x2bfd00(0x393)](_0x21d296);}},Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x239)]=function(_0x3f3df0){if(_0x3f3df0[0x0]>0x2||_0x3f3df0[0x0]<0x0)return![];const _0x164c21=[$dataItems,$dataWeapons,$dataArmors][_0x3f3df0[0x0]][_0x3f3df0[0x1]];if(!_0x164c21)return![];return!![];},VisuMZ[_0x77d410(0x1e8)]['Scene_Shop_create']=Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x3bf)],Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x3bf)]=function(){const _0x15d10a=_0x77d410;VisuMZ['ItemsEquipsCore'][_0x15d10a(0x95)][_0x15d10a(0x200)](this),this['isUseItemsEquipsCoreUpdatedLayout']()&&this[_0x15d10a(0x170)](),this[_0x15d10a(0x420)]();},Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x170)]=function(){const _0x33b1ea=_0x77d410;this['_dummyWindow']['hide'](),this[_0x33b1ea(0x309)]['show'](),this[_0x33b1ea(0x309)][_0x33b1ea(0x2a5)](),this[_0x33b1ea(0x151)][_0x33b1ea(0x268)]();},VisuMZ['ItemsEquipsCore'][_0x77d410(0xbc)]=Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x37b)],Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x37b)]=function(){const _0x352dbe=_0x77d410;return this[_0x352dbe(0x30a)]()?this[_0x352dbe(0x465)]():VisuMZ[_0x352dbe(0x1e8)]['Scene_Shop_helpWindowRect'][_0x352dbe(0x200)](this);},Scene_Shop['prototype'][_0x77d410(0x465)]=function(){const _0x322baa=_0x77d410,_0x3f6221=0x0,_0x3e4119=this[_0x322baa(0x2e5)](),_0x481a5e=Graphics[_0x322baa(0x175)],_0x1a5773=this[_0x322baa(0xb3)]();return new Rectangle(_0x3f6221,_0x3e4119,_0x481a5e,_0x1a5773);},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0xdc)]=Scene_Shop['prototype'][_0x77d410(0x1ee)],Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x1ee)]=function(){const _0x48c21e=_0x77d410;return this['isUseItemsEquipsCoreUpdatedLayout']()?this[_0x48c21e(0x22b)]():VisuMZ[_0x48c21e(0x1e8)][_0x48c21e(0xdc)][_0x48c21e(0x200)](this);},Scene_Shop['prototype'][_0x77d410(0x22b)]=function(){const _0x3305fd=_0x77d410,_0x485608=this[_0x3305fd(0x434)](),_0x224859=this[_0x3305fd(0x37a)](0x1,!![]),_0x12627e=this[_0x3305fd(0x2d4)]()?0x0:Graphics[_0x3305fd(0x175)]-_0x485608,_0x4a399e=this[_0x3305fd(0x31c)]();return new Rectangle(_0x12627e,_0x4a399e,_0x485608,_0x224859);},VisuMZ['ItemsEquipsCore']['Scene_Shop_commandWindowRect']=Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x3b7)],Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x3b7)]=function(){const _0x38137c=_0x77d410;return this[_0x38137c(0x30a)]()?this[_0x38137c(0x142)]():VisuMZ[_0x38137c(0x1e8)][_0x38137c(0x3b9)][_0x38137c(0x200)](this);},Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x142)]=function(){const _0x292d0f=_0x77d410,_0x289e20=this[_0x292d0f(0x2d4)]()?this['mainCommandWidth']():0x0,_0xb1ace1=this[_0x292d0f(0x31c)](),_0x358055=Graphics['boxWidth']-this['mainCommandWidth'](),_0x26f4f9=this['calcWindowHeight'](0x1,!![]);return new Rectangle(_0x289e20,_0xb1ace1,_0x358055,_0x26f4f9);},VisuMZ['ItemsEquipsCore'][_0x77d410(0x11c)]=Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x177)],Scene_Shop[_0x77d410(0xc6)]['numberWindowRect']=function(){const _0x2b0ce7=_0x77d410;return this[_0x2b0ce7(0x30a)]()?this[_0x2b0ce7(0x415)]():VisuMZ[_0x2b0ce7(0x1e8)]['Scene_Shop_numberWindowRect']['call'](this);},Scene_Shop[_0x77d410(0xc6)]['numberWindowRectItemsEquipsCore']=function(){const _0x59bb7e=_0x77d410,_0x1406cc=this['_commandWindow']['y']+this[_0x59bb7e(0x397)][_0x59bb7e(0x2b5)],_0x38c288=Graphics[_0x59bb7e(0x175)]-this[_0x59bb7e(0x18e)](),_0x19505e=this[_0x59bb7e(0x2d4)]()?Graphics[_0x59bb7e(0x175)]-_0x38c288:0x0,_0x184873=this[_0x59bb7e(0x3d2)]()-this[_0x59bb7e(0x397)][_0x59bb7e(0x2b5)];return new Rectangle(_0x19505e,_0x1406cc,_0x38c288,_0x184873);},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x1d5)]=Scene_Shop['prototype'][_0x77d410(0x3db)],Scene_Shop['prototype'][_0x77d410(0x3db)]=function(){const _0x3f92be=_0x77d410;return this[_0x3f92be(0x30a)]()?this[_0x3f92be(0x391)]():VisuMZ[_0x3f92be(0x1e8)][_0x3f92be(0x1d5)]['call'](this);},Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x391)]=function(){const _0x2f84f3=_0x77d410,_0x5984f3=this[_0x2f84f3(0x18e)](),_0x46a3db=this[_0x2f84f3(0x3d2)]()-this[_0x2f84f3(0x397)]['height'],_0x288b01=this[_0x2f84f3(0x2d4)]()?0x0:Graphics[_0x2f84f3(0x175)]-_0x5984f3,_0x5ef5b8=this['_commandWindow']['y']+this[_0x2f84f3(0x397)][_0x2f84f3(0x2b5)];return new Rectangle(_0x288b01,_0x5ef5b8,_0x5984f3,_0x46a3db);},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x3a2)]=Scene_Shop['prototype'][_0x77d410(0x22e)],Scene_Shop['prototype']['buyWindowRect']=function(){const _0x41a42d=_0x77d410;return this[_0x41a42d(0x30a)]()?this[_0x41a42d(0x361)]():VisuMZ[_0x41a42d(0x1e8)][_0x41a42d(0x3a2)][_0x41a42d(0x200)](this);},Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x361)]=function(){const _0x41f240=_0x77d410,_0x2607ef=this[_0x41f240(0x397)]['y']+this[_0x41f240(0x397)][_0x41f240(0x2b5)],_0x55e269=Graphics[_0x41f240(0x175)]-this['statusWidth'](),_0x5d6d68=this[_0x41f240(0x3d2)]()-this['_commandWindow'][_0x41f240(0x2b5)],_0x1a340a=this[_0x41f240(0x2d4)]()?Graphics[_0x41f240(0x175)]-_0x55e269:0x0;return new Rectangle(_0x1a340a,_0x2607ef,_0x55e269,_0x5d6d68);},VisuMZ['ItemsEquipsCore']['Scene_Shop_createCategoryWindow']=Scene_Shop[_0x77d410(0xc6)]['createCategoryWindow'],Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x3c3)]=function(){const _0xc10f4f=_0x77d410;VisuMZ[_0xc10f4f(0x1e8)][_0xc10f4f(0x1d9)][_0xc10f4f(0x200)](this),this['isUseModernControls']()&&this['postCreateCategoryWindowItemsEquipsCore']();},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x1b6)]=Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x1c7)],Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x1c7)]=function(){const _0x229e34=_0x77d410;return this[_0x229e34(0x30a)]()?this[_0x229e34(0x2d9)]():VisuMZ[_0x229e34(0x1e8)][_0x229e34(0x1b6)][_0x229e34(0x200)](this);},Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x2d9)]=function(){const _0x588af4=_0x77d410,_0x512f70=this[_0x588af4(0x397)]['y'],_0x52be78=this[_0x588af4(0x397)][_0x588af4(0x28e)],_0x59cb3b=this[_0x588af4(0x37a)](0x1,!![]),_0x4f35e1=this[_0x588af4(0x2d4)]()?Graphics[_0x588af4(0x175)]-_0x52be78:0x0;return new Rectangle(_0x4f35e1,_0x512f70,_0x52be78,_0x59cb3b);},Scene_Shop['prototype'][_0x77d410(0x35d)]=function(){const _0x780ab6=_0x77d410;delete this['_categoryWindow'][_0x780ab6(0x1b0)]['ok'],delete this[_0x780ab6(0x2bd)][_0x780ab6(0x1b0)][_0x780ab6(0x144)];},VisuMZ[_0x77d410(0x1e8)]['Scene_Shop_createSellWindow']=Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x2cd)],Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x2cd)]=function(){const _0x4877f5=_0x77d410;VisuMZ[_0x4877f5(0x1e8)][_0x4877f5(0x3ec)][_0x4877f5(0x200)](this),this[_0x4877f5(0x30a)]()&&this[_0x4877f5(0x326)]();},VisuMZ[_0x77d410(0x1e8)]['Scene_Shop_sellWindowRect']=Scene_Shop[_0x77d410(0xc6)]['sellWindowRect'],Scene_Shop[_0x77d410(0xc6)]['sellWindowRect']=function(){const _0x39d492=_0x77d410;return this[_0x39d492(0x30a)]()?this[_0x39d492(0x3a3)]():VisuMZ[_0x39d492(0x1e8)][_0x39d492(0x261)]['call'](this);},Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x3a3)]=function(){const _0x104e05=_0x77d410,_0x475bc6=this[_0x104e05(0x2bd)]['y']+this[_0x104e05(0x2bd)][_0x104e05(0x2b5)],_0x5901c7=Graphics['boxWidth']-this['statusWidth'](),_0x4bd203=this[_0x104e05(0x3d2)]()-this[_0x104e05(0x2bd)][_0x104e05(0x2b5)],_0x11e1b0=this['isRightInputMode']()?Graphics[_0x104e05(0x175)]-_0x5901c7:0x0;return new Rectangle(_0x11e1b0,_0x475bc6,_0x5901c7,_0x4bd203);},Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x326)]=function(){const _0x58a9d6=_0x77d410;this[_0x58a9d6(0x3ff)][_0x58a9d6(0x1ab)](this['_statusWindow']);},Scene_Shop['prototype'][_0x77d410(0x18e)]=function(){const _0x91bc2d=_0x77d410;return VisuMZ[_0x91bc2d(0x1e8)][_0x91bc2d(0x96)][_0x91bc2d(0x166)][_0x91bc2d(0xb7)];},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x156)]=Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x2b0)],Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x2b0)]=function(){const _0x40c2fc=_0x77d410;VisuMZ[_0x40c2fc(0x1e8)][_0x40c2fc(0x156)][_0x40c2fc(0x200)](this),this[_0x40c2fc(0x30a)]()&&this[_0x40c2fc(0x151)]['show'](),this[_0x40c2fc(0x3ff)][_0x40c2fc(0x226)]();},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x32f)]=Scene_Shop['prototype'][_0x77d410(0xf4)],Scene_Shop[_0x77d410(0xc6)][_0x77d410(0xf4)]=function(){const _0x14f445=_0x77d410;VisuMZ[_0x14f445(0x1e8)][_0x14f445(0x32f)][_0x14f445(0x200)](this),this[_0x14f445(0x30a)]()&&this[_0x14f445(0x121)]();},Scene_Shop[_0x77d410(0xc6)]['commandBuyItemsEquipsCore']=function(){const _0x5e1181=_0x77d410;this[_0x5e1181(0x46a)]=this[_0x5e1181(0x46a)]||0x0,this[_0x5e1181(0x309)][_0x5e1181(0x85)](this['_buyWindowLastIndex']);},VisuMZ[_0x77d410(0x1e8)]['Scene_Shop_commandSell']=Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x337)],Scene_Shop['prototype'][_0x77d410(0x337)]=function(){const _0x3a982d=_0x77d410;VisuMZ[_0x3a982d(0x1e8)][_0x3a982d(0x1fd)][_0x3a982d(0x200)](this),this['isUseItemsEquipsCoreUpdatedLayout']()&&this[_0x3a982d(0xf0)](),this[_0x3a982d(0x460)]()&&(this[_0x3a982d(0x2bd)][_0x3a982d(0x85)](0x0),this[_0x3a982d(0x1b2)]());},Scene_Shop['prototype'][_0x77d410(0xf0)]=function(){const _0x4e947e=_0x77d410;this[_0x4e947e(0x309)][_0x4e947e(0x38c)](),this[_0x4e947e(0x397)][_0x4e947e(0x38c)]();},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x376)]=Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x3ba)],Scene_Shop['prototype']['onBuyCancel']=function(){const _0x4a363a=_0x77d410;VisuMZ[_0x4a363a(0x1e8)][_0x4a363a(0x376)][_0x4a363a(0x200)](this),this[_0x4a363a(0x30a)]()&&this[_0x4a363a(0x247)]();},Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x247)]=function(){const _0x5830ab=_0x77d410;this['_buyWindowLastIndex']=this[_0x5830ab(0x309)][_0x5830ab(0x418)](),this[_0x5830ab(0x309)][_0x5830ab(0x268)](),this[_0x5830ab(0x309)][_0x5830ab(0x2a5)](),this[_0x5830ab(0x309)][_0x5830ab(0x3c5)](0x0,0x0),this[_0x5830ab(0x151)][_0x5830ab(0x268)](),this[_0x5830ab(0x17c)]['hide']();},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0xf8)]=Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x37d)],Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x37d)]=function(){const _0x28485b=_0x77d410;VisuMZ[_0x28485b(0x1e8)][_0x28485b(0xf8)]['call'](this),this[_0x28485b(0x30a)]()&&this['onCategoryCancelItemsEquipsCore']();},Scene_Shop[_0x77d410(0xc6)][_0x77d410(0xb6)]=function(){const _0x3b8dc4=_0x77d410;this[_0x3b8dc4(0x309)]['show'](),this[_0x3b8dc4(0x397)][_0x3b8dc4(0x268)]();},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0xfc)]=Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x30e)],Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x30e)]=function(){const _0x26270d=_0x77d410;$gameTemp['_bypassProxy']=!![],VisuMZ[_0x26270d(0x1e8)][_0x26270d(0xfc)][_0x26270d(0x200)](this),$gameTemp[_0x26270d(0x20e)]=![],this[_0x26270d(0x6c)]=this[_0x26270d(0x309)]['item']();},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x1ad)]=Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x3a0)],Scene_Shop['prototype'][_0x77d410(0x3a0)]=function(){const _0x49a435=_0x77d410;$gameTemp['_bypassProxy']=!![],this[_0x49a435(0x6c)]=this[_0x49a435(0x309)][_0x49a435(0x298)]();const _0xe047bb=VisuMZ['ItemsEquipsCore'][_0x49a435(0x1ad)][_0x49a435(0x200)](this);return $gameTemp[_0x49a435(0x20e)]=![],this['_item']=this[_0x49a435(0x309)][_0x49a435(0x298)](),_0xe047bb;},VisuMZ[_0x77d410(0x1e8)]['Scene_Shop_onSellOk']=Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x2de)],Scene_Shop['prototype'][_0x77d410(0x2de)]=function(){const _0xf8d9ae=_0x77d410;VisuMZ[_0xf8d9ae(0x1e8)][_0xf8d9ae(0x2bc)]['call'](this),this[_0xf8d9ae(0x30a)]()&&this['onSellOkItemsEquipsCore']();},Scene_Shop[_0x77d410(0xc6)]['onSellOkItemsEquipsCore']=function(){const _0xe43ad9=_0x77d410;this['_categoryWindow'][_0xe43ad9(0x268)]();},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x246)]=Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x3c2)],Scene_Shop['prototype'][_0x77d410(0x3c2)]=function(){const _0x440841=_0x77d410;VisuMZ[_0x440841(0x1e8)][_0x440841(0x246)][_0x440841(0x200)](this),this[_0x440841(0x460)]()&&this['onCategoryCancel'](),this[_0x440841(0x30a)]()&&this[_0x440841(0x17c)]['hide']();},Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x22f)]=function(_0x20b7df){const _0x236db8=_0x77d410,_0xc1b9cb=this['_item'];this['_item']=_0x20b7df;const _0x293fdf=this[_0x236db8(0x14d)]();return this[_0x236db8(0x6c)]=_0xc1b9cb,_0x293fdf;},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x406)]=Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x14d)],Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x14d)]=function(){const _0xe2b5b1=_0x77d410;let _0x155fe7=this[_0xe2b5b1(0xec)]();const _0x57180d=this[_0xe2b5b1(0x6c)];return _0x155fe7=VisuMZ[_0xe2b5b1(0x1e8)][_0xe2b5b1(0x96)]['ShopScene']['SellPriceJS']['call'](this,_0x57180d,_0x155fe7),_0x155fe7;},Scene_Shop[_0x77d410(0xc6)][_0x77d410(0xec)]=function(){const _0x2d0f42=_0x77d410;let _0x254096=this[_0x2d0f42(0x6c)][_0x2d0f42(0x36a)];if(!this[_0x2d0f42(0x6c)])return 0x0;else{if(this[_0x2d0f42(0x6c)][_0x2d0f42(0x272)]['match'](/<JS SELL PRICE>\s*([\s\S]*)\s*<\/JS SELL PRICE>/i)){const _0x23967f=String(RegExp['$1']);window[_0x2d0f42(0x298)]=this['_item'],window['price']=_0x254096*this[_0x2d0f42(0x1e7)]();try{eval(_0x23967f);}catch(_0x42c026){if($gameTemp['isPlaytest']())console['log'](_0x42c026);}let _0x4f9a52=window[_0x2d0f42(0x36a)];window['item']=undefined,window['price']=undefined;if(isNaN(_0x4f9a52))_0x4f9a52=0x0;return Math['floor'](_0x4f9a52);}else return this[_0x2d0f42(0x6c)][_0x2d0f42(0x272)]['match'](/<SELL PRICE:[ ](\d+)>/i)?parseInt(RegExp['$1']):Math['floor'](this[_0x2d0f42(0x41b)]());}},Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x41b)]=function(){const _0x4c721e=_0x77d410;return this[_0x4c721e(0x6c)][_0x4c721e(0x36a)]*this[_0x4c721e(0x1e7)]();},Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x1e7)]=function(){const _0x3067dd=_0x77d410;return VisuMZ[_0x3067dd(0x1e8)][_0x3067dd(0x96)][_0x3067dd(0x362)][_0x3067dd(0x2a6)];},Scene_Shop[_0x77d410(0xc6)]['buttonAssistItemListRequirement']=function(){const _0x2f688a=_0x77d410;if(!this[_0x2f688a(0x365)]())return![];if(!this[_0x2f688a(0x460)]())return![];if(!this[_0x2f688a(0x3ff)])return![];if(!this[_0x2f688a(0x3ff)][_0x2f688a(0x245)])return![];return this[_0x2f688a(0x365)]()&&this['isUseModernControls']();},Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x422)]=function(){const _0x537e98=_0x77d410;if(this[_0x537e98(0x43e)]())return this[_0x537e98(0x3ff)]['maxCols']()===0x1?TextManager[_0x537e98(0x182)]('left',_0x537e98(0x1d4)):TextManager[_0x537e98(0x182)](_0x537e98(0x2ca),_0x537e98(0x2fc));else{if(this[_0x537e98(0x423)]&&this['_numberWindow']['active'])return TextManager[_0x537e98(0x182)](_0x537e98(0x12d),_0x537e98(0x1d4));}return Scene_MenuBase[_0x537e98(0xc6)][_0x537e98(0x422)][_0x537e98(0x200)](this);},Scene_Shop['prototype'][_0x77d410(0x1a0)]=function(){const _0x3b8360=_0x77d410;if(this['_numberWindow']&&this[_0x3b8360(0x423)][_0x3b8360(0x245)])return TextManager[_0x3b8360(0x182)]('up',_0x3b8360(0x3e2));return Scene_MenuBase[_0x3b8360(0xc6)]['buttonAssistKey2'][_0x3b8360(0x200)](this);},Scene_Shop[_0x77d410(0xc6)][_0x77d410(0xa7)]=function(){const _0x1a59c1=_0x77d410;if(this[_0x1a59c1(0x43e)]())return VisuMZ['ItemsEquipsCore'][_0x1a59c1(0x96)][_0x1a59c1(0x3cc)][_0x1a59c1(0x193)];else{if(this[_0x1a59c1(0x423)]&&this[_0x1a59c1(0x423)][_0x1a59c1(0x245)])return VisuMZ[_0x1a59c1(0x1e8)][_0x1a59c1(0x96)]['ShopScene'][_0x1a59c1(0x9f)];}return Scene_MenuBase[_0x1a59c1(0xc6)][_0x1a59c1(0xa7)][_0x1a59c1(0x200)](this);},Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x2b8)]=function(){const _0x26df5a=_0x77d410;if(this['_numberWindow']&&this['_numberWindow'][_0x26df5a(0x245)])return VisuMZ[_0x26df5a(0x1e8)][_0x26df5a(0x96)][_0x26df5a(0x362)][_0x26df5a(0x1c6)];return Scene_MenuBase[_0x26df5a(0xc6)][_0x26df5a(0x2b8)][_0x26df5a(0x200)](this);},Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x420)]=function(){const _0x2597e5=_0x77d410;if(!SceneManager['isSceneShop']())return;const _0x232866=VisuMZ[_0x2597e5(0x1e8)][_0x2597e5(0x96)][_0x2597e5(0x362)];_0x232866[_0x2597e5(0x461)]&&$gameSwitches[_0x2597e5(0x213)](_0x232866['SwitchBuy'],![]),_0x232866['SwitchSell']&&$gameSwitches[_0x2597e5(0x213)](_0x232866[_0x2597e5(0x2ef)],![]);},VisuMZ[_0x77d410(0x1e8)]['Scene_Shop_doBuy']=Scene_Shop['prototype'][_0x77d410(0xf3)],Scene_Shop[_0x77d410(0xc6)][_0x77d410(0xf3)]=function(_0x108912){const _0x375182=_0x77d410;VisuMZ[_0x375182(0x1e8)][_0x375182(0x97)]['call'](this,_0x108912),this[_0x375182(0x469)](this[_0x375182(0x6c)],_0x108912);if(_0x108912<=0x0)return;const _0x3b377d=VisuMZ[_0x375182(0x1e8)][_0x375182(0x96)]['ShopScene'];_0x3b377d[_0x375182(0x461)]&&$gameSwitches[_0x375182(0x213)](_0x3b377d['SwitchBuy'],!![]),this[_0x375182(0x309)][_0x375182(0x2b1)](),this[_0x375182(0x3ff)]['refresh']();},Scene_Shop[_0x77d410(0xc6)]['onBuyItem']=function(_0x580a2c,_0x2e008e){const _0x13bc8f=_0x77d410;this[_0x13bc8f(0x1fe)](_0x580a2c,_0x2e008e),$gameParty[_0x13bc8f(0x299)](_0x580a2c,_0x2e008e),$gameParty['addShopTrackingGoldBuy'](_0x2e008e*this[_0x13bc8f(0x3a0)]());},Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x1fe)]=function(_0x5857ca,_0x341e69){const _0x7e298a=_0x77d410;if(!_0x5857ca)return;if(!_0x341e69)return;const _0x1c3723=VisuMZ[_0x7e298a(0x1e8)][_0x7e298a(0x160)],_0x382eb6=_0x5857ca[_0x7e298a(0x272)]||'';if(_0x382eb6[_0x7e298a(0x336)](_0x1c3723[_0x7e298a(0xe7)])){const _0x32d325=String(RegExp['$1'])[_0x7e298a(0x21e)](',')[_0x7e298a(0x199)](_0x378f88=>Number(_0x378f88));for(const _0xd3f394 of _0x32d325){$gameSwitches[_0x7e298a(0x213)](_0xd3f394,!![]);}}if(_0x382eb6[_0x7e298a(0x336)](_0x1c3723[_0x7e298a(0x2b7)])){const _0x4c0e69=String(RegExp['$1'])[_0x7e298a(0x21e)](',')[_0x7e298a(0x199)](_0x50d6cb=>Number(_0x50d6cb));for(const _0x13f568 of _0x4c0e69){$gameSwitches[_0x7e298a(0x213)](_0x13f568,![]);}}},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x25c)]=Scene_Shop[_0x77d410(0xc6)]['doSell'],Scene_Shop[_0x77d410(0xc6)]['doSell']=function(_0x11079b){const _0x2a69d=_0x77d410;VisuMZ['ItemsEquipsCore']['Scene_Shop_doSell'][_0x2a69d(0x200)](this,_0x11079b),this[_0x2a69d(0x1ce)](this[_0x2a69d(0x6c)],_0x11079b);if(_0x11079b<=0x0)return;const _0x46f309=VisuMZ[_0x2a69d(0x1e8)][_0x2a69d(0x96)][_0x2a69d(0x362)];_0x46f309[_0x2a69d(0x461)]&&$gameSwitches[_0x2a69d(0x213)](_0x46f309[_0x2a69d(0x2ef)],!![]),this['_buyWindow'][_0x2a69d(0x2b1)](),this[_0x2a69d(0x3ff)][_0x2a69d(0x2b1)]();},Scene_Shop['prototype']['onSellItem']=function(_0x508660,_0x2b7b13){const _0x45b46c=_0x77d410;this['processShopCondListingOnSellItem'](_0x508660,_0x2b7b13),$gameParty[_0x45b46c(0x300)](_0x508660,_0x2b7b13),$gameParty[_0x45b46c(0x134)](_0x2b7b13*this['sellingPrice']());},Scene_Shop[_0x77d410(0xc6)][_0x77d410(0x7e)]=function(_0x22c053,_0x59978f){const _0x494f97=_0x77d410;if(!_0x22c053)return;if(!_0x59978f)return;const _0x1db6a4=VisuMZ[_0x494f97(0x1e8)][_0x494f97(0x160)],_0x28688f=_0x22c053['note']||'';if(_0x28688f['match'](_0x1db6a4[_0x494f97(0x354)])){const _0x595faa=String(RegExp['$1'])['split'](',')[_0x494f97(0x199)](_0x5f5d7a=>Number(_0x5f5d7a));for(const _0x4dfe7d of _0x595faa){$gameSwitches[_0x494f97(0x213)](_0x4dfe7d,!![]);}}if(_0x28688f[_0x494f97(0x336)](_0x1db6a4['SellTurnSwitchOff'])){const _0x173aa5=String(RegExp['$1'])[_0x494f97(0x21e)](',')[_0x494f97(0x199)](_0x1d88dc=>Number(_0x1d88dc));for(const _0x15cf84 of _0x173aa5){$gameSwitches['setValue'](_0x15cf84,![]);}}};function Sprite_NewLabel(){const _0x298df7=_0x77d410;this[_0x298df7(0x335)](...arguments);}function _0xebad(_0x47a7a4,_0x1caf81){const _0x3470cd=_0x3470();return _0xebad=function(_0xebad9b,_0xcdc1e5){_0xebad9b=_0xebad9b-0x68;let _0x268c6b=_0x3470cd[_0xebad9b];return _0x268c6b;},_0xebad(_0x47a7a4,_0x1caf81);}Sprite_NewLabel['prototype']=Object[_0x77d410(0x3bf)](Sprite[_0x77d410(0xc6)]),Sprite_NewLabel[_0x77d410(0xc6)][_0x77d410(0x8d)]=Sprite_NewLabel,Sprite_NewLabel[_0x77d410(0xc6)][_0x77d410(0x335)]=function(){const _0x5ae022=_0x77d410;Sprite['prototype'][_0x5ae022(0x335)][_0x5ae022(0x200)](this),this[_0x5ae022(0x466)]();},Sprite_NewLabel[_0x77d410(0xc6)][_0x77d410(0x466)]=function(){const _0x1bc313=_0x77d410,_0x21c978=ImageManager[_0x1bc313(0x18f)],_0x433a9d=ImageManager[_0x1bc313(0xe6)];this[_0x1bc313(0x15d)]=new Bitmap(_0x21c978,_0x433a9d),this['drawNewLabelIcon'](),this[_0x1bc313(0x216)]();},Sprite_NewLabel[_0x77d410(0xc6)]['drawNewLabelIcon']=function(){const _0x502644=_0x77d410,_0x5d78e1=VisuMZ[_0x502644(0x1e8)]['Settings']['New'][_0x502644(0x426)];if(_0x5d78e1<=0x0)return;const _0x4bf72f=ImageManager[_0x502644(0x2c7)](_0x502644(0x7d)),_0x1fa15f=ImageManager[_0x502644(0x18f)],_0x2fb9c5=ImageManager[_0x502644(0xe6)],_0x50ac2e=_0x5d78e1%0x10*_0x1fa15f,_0x598f5c=Math[_0x502644(0xc9)](_0x5d78e1/0x10)*_0x2fb9c5;this[_0x502644(0x15d)]['blt'](_0x4bf72f,_0x50ac2e,_0x598f5c,_0x1fa15f,_0x2fb9c5,0x0,0x0);},Sprite_NewLabel[_0x77d410(0xc6)][_0x77d410(0x216)]=function(){const _0x7d2ab7=_0x77d410,_0x85bee0=VisuMZ[_0x7d2ab7(0x1e8)][_0x7d2ab7(0x96)][_0x7d2ab7(0x312)],_0x5cb1dc=_0x85bee0[_0x7d2ab7(0x7b)];if(_0x5cb1dc==='')return;const _0x15cd0c=ImageManager['iconWidth'],_0x57793b=ImageManager['iconHeight'];this[_0x7d2ab7(0x15d)][_0x7d2ab7(0x3dc)]=_0x85bee0[_0x7d2ab7(0x109)]||$gameSystem[_0x7d2ab7(0x133)](),this['bitmap'][_0x7d2ab7(0x462)]=this[_0x7d2ab7(0x124)](),this[_0x7d2ab7(0x15d)][_0x7d2ab7(0x43d)]=_0x85bee0['FontSize'],this[_0x7d2ab7(0x15d)][_0x7d2ab7(0x315)](_0x5cb1dc,0x0,_0x57793b/0x2,_0x15cd0c,_0x57793b/0x2,_0x7d2ab7(0x1bb));},Sprite_NewLabel[_0x77d410(0xc6)]['getTextColor']=function(){const _0x190fd6=_0x77d410,_0x180ac0=VisuMZ[_0x190fd6(0x1e8)][_0x190fd6(0x96)]['New'][_0x190fd6(0x150)];return _0x180ac0[_0x190fd6(0x336)](/#(.*)/i)?'#'+String(RegExp['$1']):ColorManager[_0x190fd6(0x462)](_0x180ac0);},Window_Base[_0x77d410(0xc6)][_0x77d410(0x183)]=function(_0x3e8f1c,_0x3d2ab1,_0x3bb5f3,_0x3e8b3e){const _0x4b0a68=_0x77d410;if(_0x3e8f1c){const _0x36a64d=_0x3bb5f3+(this[_0x4b0a68(0x1e2)]()-ImageManager[_0x4b0a68(0xe6)])/0x2,_0x2f9a6a=ImageManager[_0x4b0a68(0x18f)]+0x4,_0xfe9b66=Math['max'](0x0,_0x3e8b3e-_0x2f9a6a);this[_0x4b0a68(0x1f3)](ColorManager[_0x4b0a68(0x430)](_0x3e8f1c)),this['drawIcon'](_0x3e8f1c[_0x4b0a68(0x214)],_0x3d2ab1,_0x36a64d),this[_0x4b0a68(0x315)](_0x3e8f1c[_0x4b0a68(0x123)],_0x3d2ab1+_0x2f9a6a,_0x3bb5f3,_0xfe9b66),this[_0x4b0a68(0x159)]();}},Window_Base['prototype']['drawItemNumber']=function(_0x53f20b,_0x128101,_0x3a1a94,_0x38d682){const _0x5594be=_0x77d410;if(this['isDrawItemNumber'](_0x53f20b)){this['resetFontSettings']();const _0x4415c7=VisuMZ[_0x5594be(0x1e8)][_0x5594be(0x96)][_0x5594be(0x3cc)],_0x5f3af=_0x4415c7['ItemQuantityFmt'],_0x364209=_0x5f3af[_0x5594be(0x290)]($gameParty[_0x5594be(0x342)](_0x53f20b));this[_0x5594be(0x40d)][_0x5594be(0x43d)]=_0x4415c7[_0x5594be(0xad)],this[_0x5594be(0x315)](_0x364209,_0x128101,_0x3a1a94,_0x38d682,_0x5594be(0x1d4)),this[_0x5594be(0x157)]();}},Window_Base[_0x77d410(0xc6)][_0x77d410(0x419)]=function(_0xdddd5){const _0x40aac5=_0x77d410;if(DataManager['isKeyItem'](_0xdddd5))return $dataSystem[_0x40aac5(0x35f)];return!![];},Window_Base[_0x77d410(0xc6)][_0x77d410(0xd7)]=function(_0x104c72,_0x5b6f4c,_0x18af96,_0x587dfb,_0x2702ef){const _0x1e4baf=_0x77d410;_0x2702ef=Math[_0x1e4baf(0x17f)](_0x2702ef||0x1,0x1);while(_0x2702ef--){_0x587dfb=_0x587dfb||this[_0x1e4baf(0x1e2)](),this['contentsBack'][_0x1e4baf(0x3bc)]=0xa0;const _0x497c92=ColorManager['gaugeBackColor']();this[_0x1e4baf(0x291)][_0x1e4baf(0x11b)](_0x104c72+0x1,_0x5b6f4c+0x1,_0x18af96-0x2,_0x587dfb-0x2,_0x497c92),this[_0x1e4baf(0x291)]['paintOpacity']=0xff;}},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x137)]=Window_Selectable['prototype'][_0x77d410(0x335)],Window_Selectable[_0x77d410(0xc6)][_0x77d410(0x335)]=function(_0x250816){const _0xdb06d7=_0x77d410;this[_0xdb06d7(0x3f2)](),VisuMZ[_0xdb06d7(0x1e8)]['Window_Selectable_initialize'][_0xdb06d7(0x200)](this,_0x250816);},Window_Selectable[_0x77d410(0xc6)][_0x77d410(0x3f2)]=function(){const _0xd45495=_0x77d410;this['_newLabelSprites']={},this[_0xd45495(0x138)]=0xff,this[_0xd45495(0x42e)]=VisuMZ[_0xd45495(0x1e8)][_0xd45495(0x96)][_0xd45495(0x312)][_0xd45495(0x25e)],this['_newLabelOpacityUpperLimit']=VisuMZ['ItemsEquipsCore'][_0xd45495(0x96)][_0xd45495(0x312)]['FadeLimit'];},Window_Selectable[_0x77d410(0xc6)][_0x77d410(0x9c)]=function(){return![];},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x204)]=Window_Selectable[_0x77d410(0xc6)][_0x77d410(0x147)],Window_Selectable['prototype']['setHelpWindowItem']=function(_0x51f5ad){const _0x201bf8=_0x77d410;VisuMZ[_0x201bf8(0x1e8)][_0x201bf8(0x204)][_0x201bf8(0x200)](this,_0x51f5ad);if(this[_0x201bf8(0x9c)]())this[_0x201bf8(0x1d1)](_0x51f5ad);},Window_Selectable[_0x77d410(0xc6)][_0x77d410(0x1d1)]=function(_0x49d381){const _0x505fac=_0x77d410;if(!_0x49d381)return;$gameParty[_0x505fac(0x371)](_0x49d381);let _0x5c5d5f='';if(DataManager[_0x505fac(0x19e)](_0x49d381))_0x5c5d5f='item-%1'[_0x505fac(0x290)](_0x49d381['id']);else{if(DataManager[_0x505fac(0x24d)](_0x49d381))_0x5c5d5f=_0x505fac(0x20b)[_0x505fac(0x290)](_0x49d381['id']);else{if(DataManager['isArmor'](_0x49d381))_0x5c5d5f=_0x505fac(0x2f3)[_0x505fac(0x290)](_0x49d381['id']);else return;}}const _0xffe1cb=this[_0x505fac(0x78)][_0x5c5d5f];if(_0xffe1cb)_0xffe1cb[_0x505fac(0x38c)]();},VisuMZ[_0x77d410(0x1e8)]['Window_Selectable_refresh']=Window_Selectable[_0x77d410(0xc6)][_0x77d410(0x2b1)],Window_Selectable[_0x77d410(0xc6)]['refresh']=function(){const _0x1991fe=_0x77d410;this['hideNewLabelSprites'](),VisuMZ[_0x1991fe(0x1e8)][_0x1991fe(0xa0)]['call'](this);},Window_Selectable[_0x77d410(0xc6)][_0x77d410(0x36b)]=function(){const _0x3c14be=_0x77d410;for(const _0x5807e8 of Object[_0x3c14be(0x1b9)](this[_0x3c14be(0x78)])){_0x5807e8[_0x3c14be(0x38c)]();}},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x255)]=Window_Selectable[_0x77d410(0xc6)][_0x77d410(0x10d)],Window_Selectable[_0x77d410(0xc6)][_0x77d410(0x10d)]=function(){const _0xbd1f21=_0x77d410;this['updateNewLabelOpacity'](),VisuMZ[_0xbd1f21(0x1e8)]['Window_Selectable_update'][_0xbd1f21(0x200)](this);},Window_Selectable[_0x77d410(0xc6)]['updateNewLabelOpacity']=function(){const _0x128c48=_0x77d410;if(!this[_0x128c48(0x9c)]())return;const _0x306285=this[_0x128c48(0x35e)];this[_0x128c48(0x138)]+=this[_0x128c48(0x42e)];(this[_0x128c48(0x138)]>=_0x306285||this[_0x128c48(0x138)]<=0x0)&&(this[_0x128c48(0x42e)]*=-0x1);this['_newLabelOpacity']=this[_0x128c48(0x138)][_0x128c48(0x45e)](0x0,_0x306285);for(const _0x1a2089 of Object[_0x128c48(0x1b9)](this[_0x128c48(0x78)])){_0x1a2089[_0x128c48(0x359)]=this[_0x128c48(0x138)];}},Window_Selectable['prototype'][_0x77d410(0x37c)]=function(_0x4e4ba0){const _0x4bbb65=this['_newLabelSprites'];if(_0x4bbb65[_0x4e4ba0])return _0x4bbb65[_0x4e4ba0];else{const _0xa3ccf=new Sprite_NewLabel();return _0x4bbb65[_0x4e4ba0]=_0xa3ccf,this['addInnerChild'](_0xa3ccf),_0xa3ccf;}},Window_Selectable[_0x77d410(0xc6)][_0x77d410(0x197)]=function(_0x28e2f7,_0x49990f,_0x4663b4){const _0xa2a707=_0x77d410;let _0x1cf11a='';if(DataManager['isItem'](_0x28e2f7))_0x1cf11a='item-%1'['format'](_0x28e2f7['id']);else{if(DataManager[_0xa2a707(0x24d)](_0x28e2f7))_0x1cf11a=_0xa2a707(0x20b)[_0xa2a707(0x290)](_0x28e2f7['id']);else{if(DataManager['isArmor'](_0x28e2f7))_0x1cf11a='armor-%1'[_0xa2a707(0x290)](_0x28e2f7['id']);else return;}}const _0x3c6392=this[_0xa2a707(0x37c)](_0x1cf11a);_0x3c6392[_0xa2a707(0x403)](_0x49990f,_0x4663b4),_0x3c6392['show'](),_0x3c6392['opacity']=this['_newLabelOpacity'];},Window_ItemCategory['categoryList']=VisuMZ['ItemsEquipsCore'][_0x77d410(0x96)]['Categories'][_0x77d410(0x2e2)],Window_ItemCategory[_0x77d410(0x3ab)]=[_0x77d410(0x38b),_0x77d410(0x77),_0x77d410(0x302),'Consumable','AlwaysUsable','BattleUsable',_0x77d410(0x349),_0x77d410(0x1cf)],VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x1a7)]=Window_ItemCategory[_0x77d410(0xc6)][_0x77d410(0x335)],Window_ItemCategory[_0x77d410(0xc6)][_0x77d410(0x335)]=function(_0x293910){const _0x580a22=_0x77d410;VisuMZ[_0x580a22(0x1e8)][_0x580a22(0x1a7)]['call'](this,_0x293910),this[_0x580a22(0x194)](_0x293910);},Window_ItemCategory[_0x77d410(0xc6)]['createCategoryNameWindow']=function(_0x3a0148){const _0x3a6329=_0x77d410,_0x27b971=new Rectangle(0x0,0x0,_0x3a0148[_0x3a6329(0x28e)],_0x3a0148[_0x3a6329(0x2b5)]);this[_0x3a6329(0x1be)]=new Window_Base(_0x27b971),this['_categoryNameWindow'][_0x3a6329(0x359)]=0x0,this[_0x3a6329(0x1bc)](this[_0x3a6329(0x1be)]),this[_0x3a6329(0x69)]();},Window_ItemCategory[_0x77d410(0xc6)][_0x77d410(0x460)]=function(){const _0x38a162=_0x77d410;return Imported[_0x38a162(0x257)]&&Window_HorzCommand[_0x38a162(0xc6)]['isUseModernControls'][_0x38a162(0x200)](this);},Window_ItemCategory[_0x77d410(0xc6)][_0x77d410(0x117)]=function(){},Window_ItemCategory['prototype'][_0x77d410(0x105)]=function(){const _0x3e8b0=_0x77d410;if(!this[_0x3e8b0(0x460)]())Window_HorzCommand[_0x3e8b0(0xc6)][_0x3e8b0(0x105)][_0x3e8b0(0x200)](this);},Window_ItemCategory[_0x77d410(0xc6)][_0x77d410(0x107)]=function(){const _0x1d7b5d=_0x77d410;return this[_0x1d7b5d(0x468)]?this[_0x1d7b5d(0x17b)]():0x4;},Window_ItemCategory['prototype']['update']=function(){const _0x140d2b=_0x77d410;Window_HorzCommand[_0x140d2b(0xc6)][_0x140d2b(0x10d)][_0x140d2b(0x200)](this),this['_itemWindow']&&this[_0x140d2b(0x28c)][_0x140d2b(0x3b3)](this['currentExt']());},Window_ItemCategory[_0x77d410(0xc6)][_0x77d410(0x353)]=function(){const _0x44a350=_0x77d410;if(this[_0x44a350(0x405)]()){const _0x29fcda=this['index']();if(this['_itemWindow']&&this[_0x44a350(0x28c)][_0x44a350(0x107)]()<=0x1)Input[_0x44a350(0x1ed)]('right')&&this[_0x44a350(0x1d8)](Input[_0x44a350(0x351)](_0x44a350(0x1d4))),Input[_0x44a350(0x1ed)](_0x44a350(0x12d))&&this[_0x44a350(0x19c)](Input[_0x44a350(0x351)]('left'));else this[_0x44a350(0x28c)]&&this[_0x44a350(0x28c)][_0x44a350(0x107)]()>0x1&&(Input[_0x44a350(0x1ed)](_0x44a350(0x2fc))&&!Input[_0x44a350(0x12f)](_0x44a350(0x2ed))&&this[_0x44a350(0x1d8)](Input[_0x44a350(0x351)](_0x44a350(0x2fc))),Input[_0x44a350(0x1ed)](_0x44a350(0x2ca))&&!Input[_0x44a350(0x12f)](_0x44a350(0x2ed))&&this[_0x44a350(0x19c)](Input[_0x44a350(0x351)](_0x44a350(0x2ca))));this[_0x44a350(0x418)]()!==_0x29fcda&&this['playCursorSound']();}},Window_ItemCategory[_0x77d410(0xc6)]['processHandling']=function(){const _0x253860=_0x77d410;if(this[_0x253860(0x460)]())return;Window_HorzCommand['prototype']['processHandling'][_0x253860(0x200)](this);},Window_ItemCategory[_0x77d410(0xc6)]['isHoverEnabled']=function(){const _0x290191=_0x77d410;return this[_0x290191(0x460)]()?![]:Window_HorzCommand[_0x290191(0xc6)][_0x290191(0x3aa)][_0x290191(0x200)](this);},Window_ItemCategory[_0x77d410(0xc6)][_0x77d410(0x13d)]=function(){const _0x3724dd=_0x77d410;if(this[_0x3724dd(0x130)]()){TouchInput[_0x3724dd(0x351)]()&&this[_0x3724dd(0x29b)](!![]);if(TouchInput[_0x3724dd(0x165)]())this[_0x3724dd(0xcb)]();else TouchInput['isCancelled']()&&this['onTouchCancel']();}},Window_ItemCategory[_0x77d410(0xc6)][_0x77d410(0x29b)]=function(_0x41e504){const _0x32129c=_0x77d410;this['isUseModernControls']()?this[_0x32129c(0x1fc)](!![]):Window_HorzCommand[_0x32129c(0xc6)][_0x32129c(0x29b)]['call'](this,_0x41e504);},Window_ItemCategory[_0x77d410(0xc6)][_0x77d410(0x1fc)]=function(_0x59381b){const _0x332cff=_0x77d410;this[_0x332cff(0x295)]=![];if(this[_0x332cff(0x405)]()){const _0x5c42cb=this[_0x332cff(0x418)](),_0x17c4af=this[_0x332cff(0x125)]();_0x17c4af>=0x0&&_0x17c4af!==this[_0x332cff(0x418)]()&&this['select'](_0x17c4af),_0x59381b&&this['index']()!==_0x5c42cb&&this[_0x332cff(0xc2)]();}},Window_ItemCategory['prototype']['makeCommandList']=function(){this['addItemCategories'](),this['select'](this['index']());},Window_ItemCategory[_0x77d410(0xc6)][_0x77d410(0x2e1)]=function(){const _0x50af66=_0x77d410;for(const _0xacd3f2 of Window_ItemCategory[_0x50af66(0x303)]){this[_0x50af66(0x410)](_0xacd3f2);}},Window_ItemCategory[_0x77d410(0xc6)][_0x77d410(0x410)]=function(_0x37b0ce){const _0x39254c=_0x77d410,_0x960c80=_0x37b0ce[_0x39254c(0x1c4)],_0x1c0380=_0x37b0ce[_0x39254c(0x426)],_0x3d3c91=_0x37b0ce['SwitchID']||0x0;if(_0x3d3c91>0x0&&!$gameSwitches[_0x39254c(0x3b5)](_0x3d3c91))return;let _0x4d00df='',_0x5274de='category',_0x1328ed=_0x960c80;if(_0x960c80[_0x39254c(0x336)](/Category:(.*)/i))_0x4d00df=String(RegExp['$1'])[_0x39254c(0x72)]();else{if(Window_ItemCategory['categoryItemTypes'][_0x39254c(0x26b)](_0x960c80))_0x4d00df=VisuMZ[_0x39254c(0x1e8)]['Settings'][_0x39254c(0x296)][_0x960c80];else{if([_0x39254c(0x316),_0x39254c(0x26d)][_0x39254c(0x26b)](_0x960c80))_0x4d00df=TextManager['item'];else{if(_0x960c80==='KeyItems')_0x4d00df=TextManager[_0x39254c(0x87)];else{if(_0x960c80===_0x39254c(0x292))_0x4d00df=TextManager[_0x39254c(0x27b)];else{if(_0x960c80==='AllArmors')_0x4d00df=TextManager[_0x39254c(0xeb)];else{if(_0x960c80[_0x39254c(0x336)](/WTYPE:(\d+)/i))_0x4d00df=$dataSystem[_0x39254c(0x297)][Number(RegExp['$1'])]||'';else{if(_0x960c80['match'](/ATYPE:(\d+)/i))_0x4d00df=$dataSystem[_0x39254c(0x219)][Number(RegExp['$1'])]||'';else _0x960c80['match'](/ETYPE:(\d+)/i)&&(_0x4d00df=$dataSystem[_0x39254c(0x3f0)][Number(RegExp['$1'])]||'');}}}}}}}_0x1c0380>0x0&&this['categoryStyle']()!==_0x39254c(0x2fe)&&(_0x4d00df=_0x39254c(0x1eb)['format'](_0x1c0380,_0x4d00df)),this['addCommand'](_0x4d00df,_0x5274de,!![],_0x1328ed);},Window_ItemCategory[_0x77d410(0xc6)][_0x77d410(0x357)]=function(){const _0x525d17=_0x77d410;return VisuMZ[_0x525d17(0x1e8)][_0x525d17(0x96)][_0x525d17(0x296)][_0x525d17(0x15e)];},Window_ItemCategory['prototype']['drawItem']=function(_0x907b0f){const _0x585b0a=_0x77d410,_0x2ea531=this['categoryStyleCheck'](_0x907b0f);if(_0x2ea531===_0x585b0a(0x99))this[_0x585b0a(0x3a1)](_0x907b0f);else _0x2ea531==='icon'?this[_0x585b0a(0xc8)](_0x907b0f):Window_HorzCommand[_0x585b0a(0xc6)]['drawItem'][_0x585b0a(0x200)](this,_0x907b0f);},Window_ItemCategory[_0x77d410(0xc6)][_0x77d410(0x2cc)]=function(){const _0x50397f=_0x77d410;return VisuMZ[_0x50397f(0x1e8)]['Settings'][_0x50397f(0x296)][_0x50397f(0xe8)];},Window_ItemCategory[_0x77d410(0xc6)][_0x77d410(0xed)]=function(_0x3c81e5){const _0x422fc7=_0x77d410;if(_0x3c81e5<0x0)return'text';const _0x54a85b=this['categoryStyle']();if(_0x54a85b!==_0x422fc7(0x1ea))return _0x54a85b;else{const _0x3a609c=this[_0x422fc7(0x167)](_0x3c81e5);if(_0x3a609c[_0x422fc7(0x336)](/\\I\[(\d+)\]/i)){const _0x1111e7=this['itemLineRect'](_0x3c81e5),_0x198de3=this[_0x422fc7(0x401)](_0x3a609c)[_0x422fc7(0x28e)];return _0x198de3<=_0x1111e7[_0x422fc7(0x28e)]?_0x422fc7(0x99):'icon';}else return _0x422fc7(0x2fe);}},Window_ItemCategory[_0x77d410(0xc6)]['drawItemStyleIconText']=function(_0x5711f2){const _0x3d57f6=_0x77d410,_0x3e541f=this[_0x3d57f6(0x1e3)](_0x5711f2),_0x160998=this[_0x3d57f6(0x167)](_0x5711f2),_0x57cb92=this['textSizeEx'](_0x160998)[_0x3d57f6(0x28e)];this[_0x3d57f6(0xe0)](this['isCommandEnabled'](_0x5711f2));const _0x2da5ed=this[_0x3d57f6(0x357)]();if(_0x2da5ed==='right')this[_0x3d57f6(0x2cb)](_0x160998,_0x3e541f['x']+_0x3e541f[_0x3d57f6(0x28e)]-_0x57cb92,_0x3e541f['y'],_0x57cb92);else{if(_0x2da5ed===_0x3d57f6(0x1bb)){const _0x119d31=_0x3e541f['x']+Math[_0x3d57f6(0xc9)]((_0x3e541f['width']-_0x57cb92)/0x2);this[_0x3d57f6(0x2cb)](_0x160998,_0x119d31,_0x3e541f['y'],_0x57cb92);}else this[_0x3d57f6(0x2cb)](_0x160998,_0x3e541f['x'],_0x3e541f['y'],_0x57cb92);}},Window_ItemCategory[_0x77d410(0xc6)][_0x77d410(0xc8)]=function(_0x19a805){const _0x43a2f0=_0x77d410,_0x4d2494=this['commandName'](_0x19a805);if(_0x4d2494[_0x43a2f0(0x336)](/\\I\[(\d+)\]/i)){const _0xbc77da=Number(RegExp['$1'])||0x0,_0x1df0e1=this['itemLineRect'](_0x19a805),_0x4e720e=_0x1df0e1['x']+Math[_0x43a2f0(0xc9)]((_0x1df0e1[_0x43a2f0(0x28e)]-ImageManager[_0x43a2f0(0x18f)])/0x2),_0x11c9c8=_0x1df0e1['y']+(_0x1df0e1[_0x43a2f0(0x2b5)]-ImageManager[_0x43a2f0(0xe6)])/0x2;this[_0x43a2f0(0x398)](_0xbc77da,_0x4e720e,_0x11c9c8);}},VisuMZ['ItemsEquipsCore']['Window_ItemCategory_setItemWindow']=Window_ItemCategory[_0x77d410(0xc6)]['setItemWindow'],Window_ItemCategory['prototype'][_0x77d410(0x43a)]=function(_0x44c767){const _0x35b86e=_0x77d410;VisuMZ[_0x35b86e(0x1e8)][_0x35b86e(0x1b5)][_0x35b86e(0x200)](this,_0x44c767),_0x44c767[_0x35b86e(0x2bd)]=this;},Window_ItemCategory[_0x77d410(0xc6)][_0x77d410(0x432)]=function(){const _0x5ca32a=_0x77d410;Window_HorzCommand[_0x5ca32a(0xc6)][_0x5ca32a(0x432)][_0x5ca32a(0x200)](this);if(this['_categoryNameWindow'])this[_0x5ca32a(0x69)]();},Window_ItemCategory[_0x77d410(0xc6)][_0x77d410(0x69)]=function(){const _0x12f4cf=_0x77d410,_0x12881e=this[_0x12f4cf(0x1be)];_0x12881e[_0x12f4cf(0x40d)][_0x12f4cf(0x162)]();const _0x3c14d5=this['categoryStyleCheck'](this['index']());if(_0x3c14d5==='icon'){const _0xe88786=this[_0x12f4cf(0x1e3)](this['index']());let _0x34a580=this[_0x12f4cf(0x167)](this['index']());_0x34a580=_0x34a580['replace'](/\\I\[(\d+)\]/gi,''),_0x12881e[_0x12f4cf(0x157)](),this[_0x12f4cf(0x3bd)](_0x34a580,_0xe88786),this[_0x12f4cf(0x23d)](_0x34a580,_0xe88786),this['categoryNameWindowCenter'](_0x34a580,_0xe88786);}},Window_ItemCategory['prototype']['categoryNameWindowDrawBackground']=function(_0x445a0a,_0x328922){},Window_ItemCategory[_0x77d410(0xc6)][_0x77d410(0x23d)]=function(_0xa943e3,_0x564638){const _0x42cceb=_0x77d410,_0x27ef44=this['_categoryNameWindow'];_0x27ef44[_0x42cceb(0x315)](_0xa943e3,0x0,_0x564638['y'],_0x27ef44[_0x42cceb(0x279)],'center');},Window_ItemCategory['prototype']['categoryNameWindowCenter']=function(_0x24de05,_0x3f5caf){const _0x2c11b4=_0x77d410,_0x50f3aa=this[_0x2c11b4(0x1be)],_0x13e6a5=$gameSystem[_0x2c11b4(0x3cf)](),_0x58de4a=_0x3f5caf['x']+Math[_0x2c11b4(0xc9)](_0x3f5caf['width']/0x2)+_0x13e6a5;_0x50f3aa['x']=_0x50f3aa[_0x2c11b4(0x28e)]/-0x2+_0x58de4a,_0x50f3aa['y']=Math[_0x2c11b4(0xc9)](_0x3f5caf[_0x2c11b4(0x2b5)]/0x2);},Window_ItemList[_0x77d410(0xc6)]['processCursorMoveModernControls']=function(){const _0x19fc78=_0x77d410;if(this[_0x19fc78(0x405)]()){const _0x2073d3=this[_0x19fc78(0x418)]();if(this[_0x19fc78(0x107)]()<=0x1)!this[_0x19fc78(0x139)](_0x19fc78(0x2fc))&&Input['isTriggered'](_0x19fc78(0x2fc))&&this[_0x19fc78(0x287)](),!this[_0x19fc78(0x139)](_0x19fc78(0x2ca))&&Input['isTriggered'](_0x19fc78(0x2ca))&&this[_0x19fc78(0xc3)]();else this[_0x19fc78(0x107)]()>0x1&&(Input['isRepeated'](_0x19fc78(0x1d4))&&this[_0x19fc78(0x1d8)](Input[_0x19fc78(0x351)]('right')),Input[_0x19fc78(0x1ed)](_0x19fc78(0x12d))&&this[_0x19fc78(0x19c)](Input['isTriggered'](_0x19fc78(0x12d))),this['limitedPageUpDownSceneCheck']()?(Input[_0x19fc78(0x351)]('pagedown')&&Input[_0x19fc78(0x12f)](_0x19fc78(0x2ed))&&this[_0x19fc78(0x287)](),Input[_0x19fc78(0x351)]('pageup')&&Input[_0x19fc78(0x12f)]('shift')&&this['cursorPageup']()):(Input['isTriggered'](_0x19fc78(0x2fc))&&this[_0x19fc78(0x287)](),Input[_0x19fc78(0x351)](_0x19fc78(0x2ca))&&this[_0x19fc78(0xc3)]()));Input[_0x19fc78(0x1ed)]('down')&&(Input[_0x19fc78(0x12f)](_0x19fc78(0x2ed))&&this['allowShiftScrolling']()?this[_0x19fc78(0x287)]():this[_0x19fc78(0x16c)](Input[_0x19fc78(0x351)](_0x19fc78(0x3e2)))),Input[_0x19fc78(0x1ed)]('up')&&(Input['isPressed']('shift')&&this['allowShiftScrolling']()?this[_0x19fc78(0xc3)]():this[_0x19fc78(0x1c1)](Input['isTriggered']('up'))),Imported[_0x19fc78(0x257)]&&this[_0x19fc78(0x117)](),this['index']()!==_0x2073d3&&this[_0x19fc78(0xc2)]();}},Window_ItemList[_0x77d410(0xc6)][_0x77d410(0x1d0)]=function(){const _0x1e2934=_0x77d410,_0x22596b=SceneManager[_0x1e2934(0x12a)],_0x48dba8=[Scene_Item,Scene_Shop];return _0x48dba8['includes'](_0x22596b['constructor']);},Window_ItemList[_0x77d410(0xc6)][_0x77d410(0x322)]=function(){const _0x46dbad=_0x77d410;Window_Selectable['prototype'][_0x46dbad(0x322)][_0x46dbad(0x200)](this),this[_0x46dbad(0x2bd)]&&this[_0x46dbad(0x2bd)]['isUseModernControls']()&&this[_0x46dbad(0x2bd)][_0x46dbad(0x322)]();},Window_ItemList[_0x77d410(0xc6)][_0x77d410(0x2c4)]=function(){const _0x3ec838=_0x77d410;Window_Selectable[_0x3ec838(0xc6)]['deactivate'][_0x3ec838(0x200)](this),this[_0x3ec838(0x2bd)]&&this[_0x3ec838(0x2bd)]['isUseModernControls']()&&this[_0x3ec838(0x2bd)][_0x3ec838(0x2c4)]();},Window_ItemList[_0x77d410(0xc6)][_0x77d410(0x3b3)]=function(_0x16c0f6){const _0x5eb18b=_0x77d410;this[_0x5eb18b(0x3ee)]!==_0x16c0f6&&(this[_0x5eb18b(0x3ee)]=_0x16c0f6,this['refresh'](),this[_0x5eb18b(0x2bd)]&&this[_0x5eb18b(0x2bd)][_0x5eb18b(0x460)]()?this['smoothSelect'](0x0):this[_0x5eb18b(0x269)](0x0,0x0));},VisuMZ['ItemsEquipsCore'][_0x77d410(0x2ad)]=Window_ItemList[_0x77d410(0xc6)][_0x77d410(0x107)],Window_ItemList['prototype'][_0x77d410(0x107)]=function(){const _0x326115=_0x77d410;if(SceneManager[_0x326115(0x12a)]['constructor']===Scene_Battle)return VisuMZ[_0x326115(0x1e8)]['Window_ItemList_maxCols'][_0x326115(0x200)](this);else return SceneManager[_0x326115(0x12a)][_0x326115(0x8d)]===Scene_Map?VisuMZ[_0x326115(0x1e8)]['Window_ItemList_maxCols']['call'](this):VisuMZ['ItemsEquipsCore']['Settings'][_0x326115(0x3cc)][_0x326115(0x1bf)];},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x1c2)]=Window_ItemList[_0x77d410(0xc6)]['colSpacing'],Window_ItemList[_0x77d410(0xc6)][_0x77d410(0x2ce)]=function(){const _0x30c61f=_0x77d410;return this['maxCols']()<=0x1?Window_Selectable[_0x30c61f(0xc6)]['colSpacing']['call'](this):VisuMZ[_0x30c61f(0x1e8)][_0x30c61f(0x1c2)]['call'](this);},Window_ItemList[_0x77d410(0xc6)][_0x77d410(0x26b)]=function(_0x82a5cd){const _0x47199f=_0x77d410;switch(this[_0x47199f(0x3ee)]){case _0x47199f(0x316):return DataManager[_0x47199f(0x19e)](_0x82a5cd);case _0x47199f(0x26d):return DataManager[_0x47199f(0x19e)](_0x82a5cd)&&_0x82a5cd['itypeId']===0x1;case'KeyItems':return DataManager[_0x47199f(0x19e)](_0x82a5cd)&&_0x82a5cd[_0x47199f(0x36e)]===0x2;case _0x47199f(0x38b):return DataManager[_0x47199f(0x19e)](_0x82a5cd)&&_0x82a5cd[_0x47199f(0x36e)]===0x3;case _0x47199f(0x77):return DataManager[_0x47199f(0x19e)](_0x82a5cd)&&_0x82a5cd[_0x47199f(0x36e)]===0x4;case'Consumable':return DataManager[_0x47199f(0x19e)](_0x82a5cd)&&_0x82a5cd[_0x47199f(0x1df)];case'Nonconsumable':return DataManager[_0x47199f(0x19e)](_0x82a5cd)&&!_0x82a5cd[_0x47199f(0x1df)];case _0x47199f(0x288):return DataManager['isItem'](_0x82a5cd)&&[0x0][_0x47199f(0x26b)](_0x82a5cd[_0x47199f(0x3fb)]);case _0x47199f(0xb2):return DataManager['isItem'](_0x82a5cd)&&[0x0,0x1][_0x47199f(0x26b)](_0x82a5cd[_0x47199f(0x3fb)]);case'FieldUsable':return DataManager[_0x47199f(0x19e)](_0x82a5cd)&&[0x0,0x2][_0x47199f(0x26b)](_0x82a5cd[_0x47199f(0x3fb)]);case _0x47199f(0x1cf):return DataManager[_0x47199f(0x19e)](_0x82a5cd)&&[0x3][_0x47199f(0x26b)](_0x82a5cd[_0x47199f(0x3fb)]);case _0x47199f(0x292):return DataManager['isWeapon'](_0x82a5cd);case _0x47199f(0x6b):return DataManager[_0x47199f(0x81)](_0x82a5cd);default:if(this[_0x47199f(0x3ee)]['match'](/WTYPE:(\d+)/i))return DataManager[_0x47199f(0x24d)](_0x82a5cd)&&_0x82a5cd[_0x47199f(0x201)]===Number(RegExp['$1']);else{if(this['_category']['match'](/WTYPE:(.*)/i)){const _0x570ce7=$dataSystem['weaponTypes'][_0x47199f(0xbd)](String(RegExp['$1'])['trim']());return DataManager[_0x47199f(0x24d)](_0x82a5cd)&&_0x82a5cd[_0x47199f(0x201)]===_0x570ce7;}else{if(this[_0x47199f(0x3ee)][_0x47199f(0x336)](/ATYPE:(\d+)/i))return DataManager[_0x47199f(0x81)](_0x82a5cd)&&_0x82a5cd['atypeId']===Number(RegExp['$1']);else{if(this['_category'][_0x47199f(0x336)](/ATYPE:(.*)/i)){const _0x4b254b=$dataSystem[_0x47199f(0x219)][_0x47199f(0xbd)](String(RegExp['$1'])[_0x47199f(0x72)]());return DataManager[_0x47199f(0x81)](_0x82a5cd)&&_0x82a5cd[_0x47199f(0x80)]===_0x4b254b;}else{if(this[_0x47199f(0x3ee)][_0x47199f(0x336)](/ETYPE:(\d+)/i))return!!_0x82a5cd&&_0x82a5cd[_0x47199f(0x44a)]===Number(RegExp['$1']);else{if(this[_0x47199f(0x3ee)][_0x47199f(0x336)](/ETYPE:(.*)/i)){const _0x510678=$dataSystem[_0x47199f(0x3f0)][_0x47199f(0xbd)](String(RegExp['$1'])[_0x47199f(0x72)]());return DataManager[_0x47199f(0x81)](_0x82a5cd)&&_0x82a5cd[_0x47199f(0x44a)]===_0x510678;}else{if(this['_category'][_0x47199f(0x336)](/Category:(.*)/i))return!!_0x82a5cd&&_0x82a5cd['categories'][_0x47199f(0x26b)](String(RegExp['$1'])['toUpperCase']()['trim']());}}}}}}}return![];},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x260)]=Window_ItemList[_0x77d410(0xc6)][_0x77d410(0xda)],Window_ItemList['prototype'][_0x77d410(0xda)]=function(){const _0xdb7052=_0x77d410;VisuMZ['ItemsEquipsCore'][_0xdb7052(0x260)]['call'](this);if(this[_0xdb7052(0x205)]())this[_0xdb7052(0xe1)]();},Window_ItemList['prototype'][_0x77d410(0x205)]=function(){const _0x1a90a7=_0x77d410,_0x384d8d=[_0x1a90a7(0x404),_0x1a90a7(0xd8),_0x1a90a7(0x39d),'Scene_Shop'],_0x543fb8=SceneManager['_scene'];return _0x384d8d[_0x1a90a7(0x26b)](_0x543fb8[_0x1a90a7(0x8d)][_0x1a90a7(0x123)]);},Window_ItemList[_0x77d410(0xc6)][_0x77d410(0xe1)]=function(){const _0x42e122=_0x77d410,_0x505c3c=Window_ItemCategory[_0x42e122(0x303)],_0x97bc9f=_0x505c3c['find'](_0x3dd119=>_0x3dd119[_0x42e122(0x1c4)]===this[_0x42e122(0x3ee)]);if(!_0x97bc9f){VisuMZ[_0x42e122(0x1e8)][_0x42e122(0x122)](this[_0x42e122(0x1e9)]);return;}const _0x231c5e=((_0x97bc9f['SortBy']??'ID')||'ID')[_0x42e122(0x143)]()['trim']();_0x231c5e===_0x42e122(0xcf)?this[_0x42e122(0x1e9)][_0x42e122(0x409)]((_0x34cfbf,_0x244dd8)=>{const _0x1080a4=_0x42e122;if(!!_0x34cfbf&&!!_0x244dd8)return _0x34cfbf['name'][_0x1080a4(0x389)](_0x244dd8[_0x1080a4(0x123)]);return 0x0;}):VisuMZ[_0x42e122(0x1e8)][_0x42e122(0x122)](this[_0x42e122(0x1e9)]);},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x122)]=function(_0x973847){const _0x40680d=_0x77d410;return _0x973847[_0x40680d(0x409)]((_0x58af6f,_0xebf400)=>{const _0x2be6c2=_0x40680d;if(!!_0x58af6f&&!!_0xebf400){if(_0x58af6f[_0x2be6c2(0x40a)]===undefined)VisuMZ[_0x2be6c2(0x1e8)][_0x2be6c2(0x2c6)](_0x58af6f);if(_0xebf400[_0x2be6c2(0x40a)]===undefined)VisuMZ[_0x2be6c2(0x1e8)][_0x2be6c2(0x2c6)](_0xebf400);const _0x201e6d=_0x58af6f['sortPriority'],_0xc5c13e=_0xebf400[_0x2be6c2(0x40a)];if(_0x201e6d!==_0xc5c13e)return _0xc5c13e-_0x201e6d;return _0x58af6f['id']-_0xebf400['id'];}return 0x0;}),_0x973847;},Window_ItemList['prototype'][_0x77d410(0x9c)]=function(){return!![];},VisuMZ[_0x77d410(0x1e8)]['Window_ItemList_drawItem']=Window_ItemList[_0x77d410(0xc6)][_0x77d410(0x2a9)],Window_ItemList[_0x77d410(0xc6)]['drawItem']=function(_0xbd9c31){const _0x36bd=_0x77d410;VisuMZ[_0x36bd(0x1e8)][_0x36bd(0x449)][_0x36bd(0x200)](this,_0xbd9c31),this[_0x36bd(0x24a)](_0xbd9c31);},Window_ItemList[_0x77d410(0xc6)][_0x77d410(0x185)]=function(_0x1e7b2e,_0x246d7e,_0x2dcadc,_0x4c87c2){const _0x2f439b=_0x77d410;Window_Selectable[_0x2f439b(0xc6)][_0x2f439b(0x185)][_0x2f439b(0x200)](this,_0x1e7b2e,_0x246d7e,_0x2dcadc,_0x4c87c2);},Window_ItemList[_0x77d410(0xc6)][_0x77d410(0x24a)]=function(_0x13a0c2){const _0x15d88d=_0x77d410,_0x1209c6=this[_0x15d88d(0x3ce)](_0x13a0c2);if(!_0x1209c6||!this['isShowNew']())return;if(!$gameParty[_0x15d88d(0x22a)](_0x1209c6))return;const _0x3e8633=this[_0x15d88d(0x1e3)](_0x13a0c2),_0x3c4922=_0x3e8633['x'],_0x11564c=_0x3e8633['y']+(this[_0x15d88d(0x1e2)]()-ImageManager[_0x15d88d(0xe6)])/0x2,_0x398d88=VisuMZ['ItemsEquipsCore']['Settings'][_0x15d88d(0x312)][_0x15d88d(0x229)],_0x3f00a6=VisuMZ[_0x15d88d(0x1e8)]['Settings'][_0x15d88d(0x312)][_0x15d88d(0x363)];this[_0x15d88d(0x197)](_0x1209c6,_0x3c4922+_0x398d88,_0x11564c+_0x3f00a6);},Window_ItemList[_0x77d410(0xc6)]['setStatusWindow']=function(_0x35f669){const _0x48879f=_0x77d410;this[_0x48879f(0x151)]=_0x35f669,this[_0x48879f(0x432)]();},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x448)]=Window_ItemList['prototype'][_0x77d410(0x226)],Window_ItemList[_0x77d410(0xc6)][_0x77d410(0x226)]=function(){const _0x52e4f1=_0x77d410;VisuMZ[_0x52e4f1(0x1e8)][_0x52e4f1(0x448)][_0x52e4f1(0x200)](this),this['_statusWindow']&&this[_0x52e4f1(0x151)][_0x52e4f1(0x8d)]===Window_ShopStatus&&this[_0x52e4f1(0x151)][_0x52e4f1(0x250)](this['item']());},Window_BattleItem['prototype'][_0x77d410(0x1f0)]=function(_0x513471){const _0x760dd0=_0x77d410;return BattleManager[_0x760dd0(0x1d7)]()?BattleManager[_0x760dd0(0x1d7)]()[_0x760dd0(0x453)](_0x513471):Window_ItemList[_0x760dd0(0xc6)][_0x760dd0(0x1f0)]['call'](this,_0x513471);},Window_EventItem['prototype'][_0x77d410(0x9c)]=function(){return![];},Window_EquipStatus['prototype'][_0x77d410(0x30a)]=function(){const _0x7c7a3a=_0x77d410;return VisuMZ[_0x7c7a3a(0x1e8)][_0x7c7a3a(0x96)][_0x7c7a3a(0x176)][_0x7c7a3a(0x2e3)];},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x2c5)]=Window_EquipStatus['prototype'][_0x77d410(0x2b1)],Window_EquipStatus[_0x77d410(0xc6)][_0x77d410(0x2b1)]=function(){const _0x1c1f7e=_0x77d410;this['hideAdditionalSprites'](),this[_0x1c1f7e(0x157)]();if(this[_0x1c1f7e(0x16a)])this['_actor'][_0x1c1f7e(0x2b1)]();this[_0x1c1f7e(0x30a)]()?this[_0x1c1f7e(0xfe)]():VisuMZ[_0x1c1f7e(0x1e8)]['Window_EquipStatus_refresh']['call'](this);},Window_EquipStatus[_0x77d410(0xc6)][_0x77d410(0xfe)]=function(){const _0x4a21c4=_0x77d410;this[_0x4a21c4(0x40d)]['clear']();if(!this[_0x4a21c4(0x16a)])return;if(this[_0x4a21c4(0x27a)]()){const _0x5004a0=ImageManager[_0x4a21c4(0x18a)](this[_0x4a21c4(0x16a)][_0x4a21c4(0x82)]());_0x5004a0[_0x4a21c4(0xca)](this[_0x4a21c4(0x2b9)]['bind'](this));}else this[_0x4a21c4(0x1bd)]();},Window_EquipStatus['prototype'][_0x77d410(0x27a)]=function(){const _0x54a3fb=_0x77d410;return Imported[_0x54a3fb(0x45d)]&&this['_actor'][_0x54a3fb(0x82)]()!==''&&VisuMZ['ItemsEquipsCore'][_0x54a3fb(0x96)][_0x54a3fb(0x176)]['MenuPortraits'];},Window_EquipStatus['prototype']['onMenuImageLoad']=function(){const _0x5019d2=_0x77d410;VisuMZ[_0x5019d2(0x1e8)][_0x5019d2(0x96)]['EquipScene'][_0x5019d2(0x1ff)][_0x5019d2(0x200)](this),this['drawParamsItemsEquipsCore']();},Window_EquipStatus['prototype'][_0x77d410(0x1bd)]=function(){const _0x1b415c=_0x77d410;VisuMZ['ItemsEquipsCore'][_0x1b415c(0x96)][_0x1b415c(0x176)]['DrawFaceJS']['call'](this),this[_0x1b415c(0x233)]();},Window_EquipStatus['prototype'][_0x77d410(0x233)]=function(){const _0x2ab960=_0x77d410;this['resetFontSettings'](),VisuMZ[_0x2ab960(0x1e8)][_0x2ab960(0x96)][_0x2ab960(0x176)][_0x2ab960(0x3b6)][_0x2ab960(0x200)](this);},Window_EquipStatus[_0x77d410(0xc6)][_0x77d410(0x444)]=function(_0x330aa4,_0x2b4bf6,_0x404cbf,_0x4fc29b,_0x2a61c2){const _0x41fa4a=_0x77d410,_0x411abc=ImageManager['loadPicture'](_0x330aa4[_0x41fa4a(0x82)]()),_0x57d202=this[_0x41fa4a(0x279)]-_0x411abc[_0x41fa4a(0x28e)];_0x2b4bf6+=_0x57d202/0x2;if(_0x57d202<0x0)_0x4fc29b-=_0x57d202;Window_StatusBase[_0x41fa4a(0xc6)][_0x41fa4a(0x444)][_0x41fa4a(0x200)](this,_0x330aa4,_0x2b4bf6,_0x404cbf,_0x4fc29b,_0x2a61c2);},Window_EquipStatus[_0x77d410(0xc6)][_0x77d410(0xf2)]=function(){const _0x44b676=_0x77d410;return Imported[_0x44b676(0x257)]?VisuMZ[_0x44b676(0x146)][_0x44b676(0x96)]['Param'][_0x44b676(0x282)]:[0x0,0x1,0x2,0x3,0x4,0x5,0x6,0x7];},Window_EquipStatus[_0x77d410(0xc6)][_0x77d410(0xbe)]=function(){const _0x521432=_0x77d410;return VisuMZ[_0x521432(0x1e8)]['Settings']['EquipScene']['ParamValueFontSize'];},Window_EquipStatus[_0x77d410(0xc6)][_0x77d410(0x172)]=function(){const _0x52f60a=_0x77d410;return Imported['VisuMZ_0_CoreEngine']&&VisuMZ[_0x52f60a(0x146)][_0x52f60a(0x96)][_0x52f60a(0x26c)][_0x52f60a(0x103)];},Window_EquipStatus[_0x77d410(0xc6)][_0x77d410(0x39c)]=function(_0x40a7c3,_0x3c1354,_0x32b2ce,_0x552825){const _0x4998c2=_0x77d410,_0x56899e=this['itemPadding']();Imported[_0x4998c2(0x257)]?this['drawParamText'](_0x3c1354+_0x56899e,_0x32b2ce,_0x552825,_0x40a7c3,![]):this[_0x4998c2(0x315)](TextManager['param'](_0x40a7c3),_0x3c1354+_0x56899e,_0x32b2ce,_0x552825);},Window_EquipStatus['prototype'][_0x77d410(0x2b4)]=function(_0x2290ec,_0x25c577,_0x405dc1,_0x2d254e){const _0x45f561=_0x77d410,_0x523955=this['itemPadding']();let _0x326734=0x0;Imported[_0x45f561(0x257)]?_0x326734=this[_0x45f561(0x16a)][_0x45f561(0x21b)](_0x2290ec,!![]):_0x326734=this['_actor'][_0x45f561(0xb8)](_0x2290ec);const _0x8fc3f=_0x326734;this[_0x45f561(0x315)](_0x326734,_0x25c577,_0x405dc1,_0x2d254e-_0x523955,'right');},Window_EquipStatus[_0x77d410(0xc6)][_0x77d410(0x126)]=function(_0x16cd25,_0x532526,_0x391924,_0x810576){const _0x5db511=_0x77d410,_0x2728e4=this[_0x5db511(0x355)]();let _0x56115f=0x0,_0x4e35e4=0x0,_0x4475fd='';if(this[_0x5db511(0x3fe)]){Imported[_0x5db511(0x257)]?(_0x56115f=this[_0x5db511(0x16a)]['paramValueByName'](_0x16cd25,![]),_0x4e35e4=this['_tempActor'][_0x5db511(0x21b)](_0x16cd25,![]),_0x4475fd=this[_0x5db511(0x3fe)]['paramValueByName'](_0x16cd25,!![])):(_0x56115f=this[_0x5db511(0x16a)][_0x5db511(0xb8)](_0x16cd25),_0x4e35e4=this[_0x5db511(0x3fe)][_0x5db511(0xb8)](_0x16cd25),_0x4475fd=this[_0x5db511(0x3fe)][_0x5db511(0xb8)](_0x16cd25));const _0x3f26ec=_0x56115f,_0xddcf77=_0x4e35e4;diffValue=_0xddcf77-_0x3f26ec,this[_0x5db511(0x1f3)](ColorManager[_0x5db511(0x1b7)](diffValue)),this['drawText'](_0x4475fd,_0x532526,_0x391924,_0x810576-_0x2728e4,'right');}},Window_EquipStatus['prototype'][_0x77d410(0x198)]=function(_0x23a55e,_0x66c09c,_0x504fbb,_0x232e59){const _0x44d8f8=_0x77d410,_0x48cb67=this[_0x44d8f8(0x355)]();let _0x1c7458=0x0,_0x34eb65=0x0,_0x219961=![];if(this[_0x44d8f8(0x3fe)]){Imported[_0x44d8f8(0x257)]?(_0x1c7458=this[_0x44d8f8(0x16a)][_0x44d8f8(0x21b)](_0x23a55e,![]),_0x34eb65=this[_0x44d8f8(0x3fe)][_0x44d8f8(0x21b)](_0x23a55e,![]),_0x219961=String(this['_actor'][_0x44d8f8(0x21b)](_0x23a55e,!![]))[_0x44d8f8(0x336)](/([%％])/i)):(_0x1c7458=this[_0x44d8f8(0x16a)]['param'](_0x23a55e),_0x34eb65=this[_0x44d8f8(0x3fe)]['param'](_0x23a55e),_0x219961=_0x1c7458%0x1!==0x0||_0x34eb65%0x1!==0x0);const _0xf76e37=_0x1c7458,_0x31bded=_0x34eb65,_0x1b4f89=_0x31bded-_0xf76e37;let _0x387ddd=_0x1b4f89;if(_0x219961)_0x387ddd=Math[_0x44d8f8(0x317)](_0x1b4f89*0x64)+'%';_0x1b4f89!==0x0&&(this[_0x44d8f8(0x1f3)](ColorManager['paramchangeTextColor'](_0x1b4f89)),_0x387ddd=(_0x1b4f89>0x0?_0x44d8f8(0x40e):_0x44d8f8(0x39a))[_0x44d8f8(0x290)](_0x387ddd),this['drawText'](_0x387ddd,_0x66c09c+_0x48cb67,_0x504fbb,_0x232e59,_0x44d8f8(0x12d)));}},Window_EquipStatus[_0x77d410(0xc6)][_0x77d410(0xd7)]=function(_0xb667d5,_0x3fd78a,_0x27ac7d,_0x498e95,_0x1e957a){const _0x1dc308=_0x77d410;if(VisuMZ[_0x1dc308(0x1e8)]['Settings'][_0x1dc308(0x176)][_0x1dc308(0x3eb)]===![])return;_0x1e957a=Math[_0x1dc308(0x17f)](_0x1e957a||0x1,0x1);while(_0x1e957a--){_0x498e95=_0x498e95||this[_0x1dc308(0x1e2)](),this[_0x1dc308(0x40d)][_0x1dc308(0x3bc)]=0xa0;const _0x31a5f3=ColorManager[_0x1dc308(0x270)]();this[_0x1dc308(0x40d)][_0x1dc308(0x11b)](_0xb667d5+0x1,_0x3fd78a+0x1,_0x27ac7d-0x2,_0x498e95-0x2,_0x31a5f3),this[_0x1dc308(0x40d)][_0x1dc308(0x3bc)]=0xff;}},ColorManager['getItemsEquipsCoreBackColor2']=function(){const _0x2f93c2=_0x77d410,_0x3ce4e0=VisuMZ['ItemsEquipsCore']['Settings']['EquipScene'];let _0x2782d1=_0x3ce4e0[_0x2f93c2(0x102)]!==undefined?_0x3ce4e0['BackRectColor']:0x13;return ColorManager[_0x2f93c2(0x26a)](_0x2782d1);},VisuMZ['ItemsEquipsCore']['Window_EquipCommand_initialize']=Window_EquipCommand['prototype'][_0x77d410(0x335)],Window_EquipCommand[_0x77d410(0xc6)][_0x77d410(0x335)]=function(_0x9db69f){const _0x5e8707=_0x77d410;VisuMZ[_0x5e8707(0x1e8)]['Window_EquipCommand_initialize'][_0x5e8707(0x200)](this,_0x9db69f),this[_0x5e8707(0x3d4)](_0x9db69f);},Window_EquipCommand['prototype'][_0x77d410(0x3d4)]=function(_0x875a39){const _0x2be556=_0x77d410,_0x5d4713=new Rectangle(0x0,0x0,_0x875a39[_0x2be556(0x28e)],_0x875a39[_0x2be556(0x2b5)]);this[_0x2be556(0xbf)]=new Window_Base(_0x5d4713),this[_0x2be556(0xbf)][_0x2be556(0x359)]=0x0,this[_0x2be556(0x1bc)](this[_0x2be556(0xbf)]),this[_0x2be556(0xef)]();},Window_EquipCommand[_0x77d410(0xc6)]['callUpdateHelp']=function(){Window_HorzCommand['prototype']['callUpdateHelp']['call'](this);if(this['_commandNameWindow'])this['updateCommandNameWindow']();},Window_EquipCommand['prototype'][_0x77d410(0xef)]=function(){const _0x2100cd=_0x77d410,_0x49182d=this['_commandNameWindow'];_0x49182d['contents']['clear']();const _0x380f17=this['commandStyleCheck'](this[_0x2100cd(0x418)]());if(_0x380f17===_0x2100cd(0x463)){const _0x42b12c=this[_0x2100cd(0x1e3)](this[_0x2100cd(0x418)]());let _0x2bcc05=this[_0x2100cd(0x167)](this['index']());_0x2bcc05=_0x2bcc05[_0x2100cd(0x311)](/\\I\[(\d+)\]/gi,''),_0x49182d[_0x2100cd(0x157)](),this[_0x2100cd(0x71)](_0x2bcc05,_0x42b12c),this[_0x2100cd(0x74)](_0x2bcc05,_0x42b12c),this[_0x2100cd(0x14e)](_0x2bcc05,_0x42b12c);}},Window_EquipCommand[_0x77d410(0xc6)][_0x77d410(0x71)]=function(_0x19f322,_0x31a2f9){},Window_EquipCommand[_0x77d410(0xc6)]['commandNameWindowDrawText']=function(_0x89e21a,_0x408847){const _0x58f7c5=_0x77d410,_0x17f067=this[_0x58f7c5(0xbf)];_0x17f067[_0x58f7c5(0x315)](_0x89e21a,0x0,_0x408847['y'],_0x17f067[_0x58f7c5(0x279)],_0x58f7c5(0x1bb));},Window_EquipCommand[_0x77d410(0xc6)][_0x77d410(0x14e)]=function(_0x2f6401,_0x49fb1a){const _0x4b7c2f=_0x77d410,_0x48b509=this[_0x4b7c2f(0xbf)],_0x1bef43=$gameSystem['windowPadding'](),_0xf4e05c=_0x49fb1a['x']+Math[_0x4b7c2f(0xc9)](_0x49fb1a[_0x4b7c2f(0x28e)]/0x2)+_0x1bef43;_0x48b509['x']=_0x48b509[_0x4b7c2f(0x28e)]/-0x2+_0xf4e05c,_0x48b509['y']=Math[_0x4b7c2f(0xc9)](_0x49fb1a['height']/0x2);},Window_EquipCommand[_0x77d410(0xc6)]['isUseModernControls']=function(){const _0x25a1c3=_0x77d410;return Imported[_0x25a1c3(0x257)]&&Window_HorzCommand[_0x25a1c3(0xc6)]['isUseModernControls']['call'](this);},Window_EquipCommand[_0x77d410(0xc6)][_0x77d410(0x105)]=function(){const _0xee7169=_0x77d410;if(this[_0xee7169(0x3be)]()===_0xee7169(0x36f))Window_HorzCommand[_0xee7169(0xc6)]['playOkSound'][_0xee7169(0x200)](this);},Window_EquipCommand['prototype'][_0x77d410(0x353)]=function(){const _0x255330=_0x77d410;!this[_0x255330(0x264)]()&&Window_HorzCommand[_0x255330(0xc6)][_0x255330(0x353)][_0x255330(0x200)](this);},Window_EquipCommand['prototype'][_0x77d410(0x264)]=function(){const _0x386514=_0x77d410;if(!this[_0x386514(0x405)]())return![];if(SceneManager[_0x386514(0x12a)][_0x386514(0x8d)]!==Scene_Equip)return![];return Input[_0x386514(0x351)](_0x386514(0x3e2))&&this[_0x386514(0x329)](),![];},Window_EquipCommand['prototype'][_0x77d410(0x329)]=function(){const _0x1c95e1=_0x77d410;this[_0x1c95e1(0xc2)](),SceneManager[_0x1c95e1(0x12a)][_0x1c95e1(0x310)](),SceneManager[_0x1c95e1(0x12a)]['_slotWindow'][_0x1c95e1(0x85)](-0x1);},Window_EquipCommand['prototype'][_0x77d410(0x107)]=function(){const _0x5021b3=_0x77d410;return this['_list']?this[_0x5021b3(0x468)][_0x5021b3(0xcc)]:0x3;},Window_EquipCommand['prototype']['processTouchModernControls']=function(){const _0x177436=_0x77d410;if(this['isOpen']()&&this['visible']&&SceneManager[_0x177436(0x12a)]['constructor']===Scene_Equip){if(this[_0x177436(0x3aa)]()&&TouchInput[_0x177436(0x1ef)]())this['onTouchSelectModernControls'](![]);else TouchInput[_0x177436(0x351)]()&&this['onTouchSelectModernControls'](!![]);TouchInput[_0x177436(0x165)]()&&this[_0x177436(0xcb)]();}},Window_EquipCommand[_0x77d410(0xc6)][_0x77d410(0x38a)]=function(_0x301c85){const _0x34dac8=_0x77d410;this[_0x34dac8(0x295)]=![];const _0x3cbd16=this[_0x34dac8(0x418)](),_0x942393=this[_0x34dac8(0x125)](),_0x11a9de=SceneManager[_0x34dac8(0x12a)]['_slotWindow'];if(_0x11a9de[_0x34dac8(0x17e)]()&&_0x11a9de['visible']){if(_0x942393>=0x0)_0x942393===this[_0x34dac8(0x418)]()&&(this['_doubleTouch']=!![]),this[_0x34dac8(0x322)](),this[_0x34dac8(0x464)](_0x942393);else _0x11a9de['hitIndex']()>=0x0&&(this['deactivate'](),this[_0x34dac8(0x2a5)]());}_0x301c85&&this['index']()!==_0x3cbd16&&this[_0x34dac8(0xc2)]();},Window_EquipCommand[_0x77d410(0xc6)]['makeCommandList']=function(){const _0x83d59b=_0x77d410;this[_0x83d59b(0x431)](),this[_0x83d59b(0x1a2)](),this[_0x83d59b(0x1da)]();},Window_EquipCommand[_0x77d410(0xc6)]['refresh']=function(){const _0x5bf6e9=_0x77d410;Window_HorzCommand['prototype']['refresh'][_0x5bf6e9(0x200)](this),this[_0x5bf6e9(0x338)]();},Window_EquipCommand['prototype'][_0x77d410(0x431)]=function(){const _0x48abf4=_0x77d410;if(!this['isEquipCommandAdded']())return;const _0x153230=this['commandStyle'](),_0xfe1e64=VisuMZ[_0x48abf4(0x1e8)][_0x48abf4(0x96)]['EquipScene'][_0x48abf4(0x221)],_0x57bc6b=_0x153230===_0x48abf4(0x2fe)?TextManager['equip2']:'\x5cI[%1]%2'[_0x48abf4(0x290)](_0xfe1e64,TextManager['equip2']),_0x435a61=this[_0x48abf4(0x29a)]();this[_0x48abf4(0x2fd)](_0x57bc6b,_0x48abf4(0x36f),_0x435a61);},Window_EquipCommand[_0x77d410(0xc6)]['isEquipCommandAdded']=function(){const _0x24ef30=_0x77d410;return!this[_0x24ef30(0x460)]();},Window_EquipCommand[_0x77d410(0xc6)][_0x77d410(0x29a)]=function(){return!![];},Window_EquipCommand[_0x77d410(0xc6)]['addOptimizeCommand']=function(){const _0x40f3f1=_0x77d410;if(!this[_0x40f3f1(0x3f9)]())return;const _0x23a7ba=this[_0x40f3f1(0x446)](),_0x258bad=VisuMZ[_0x40f3f1(0x1e8)][_0x40f3f1(0x96)][_0x40f3f1(0x176)]['CmdIconOptimize'],_0x99cdd2=_0x23a7ba===_0x40f3f1(0x2fe)?TextManager[_0x40f3f1(0x32e)]:_0x40f3f1(0x1eb)[_0x40f3f1(0x290)](_0x258bad,TextManager[_0x40f3f1(0x32e)]),_0x25f071=this[_0x40f3f1(0xe3)]();this[_0x40f3f1(0x2fd)](_0x99cdd2,'optimize',_0x25f071);},Window_EquipCommand[_0x77d410(0xc6)]['isOptimizeCommandAdded']=function(){const _0x4b6fa1=_0x77d410;return VisuMZ[_0x4b6fa1(0x1e8)][_0x4b6fa1(0x96)][_0x4b6fa1(0x176)][_0x4b6fa1(0xb1)];},Window_EquipCommand['prototype']['isOptimizeCommandEnabled']=function(){return!![];},Window_EquipCommand[_0x77d410(0xc6)][_0x77d410(0x1da)]=function(){const _0x591cad=_0x77d410;if(!this[_0x591cad(0x3c4)]())return;const _0x1581c3=this[_0x591cad(0x446)](),_0x4eb2bc=VisuMZ[_0x591cad(0x1e8)][_0x591cad(0x96)][_0x591cad(0x176)][_0x591cad(0xa2)],_0x783827=_0x1581c3===_0x591cad(0x2fe)?TextManager[_0x591cad(0x162)]:_0x591cad(0x1eb)['format'](_0x4eb2bc,TextManager[_0x591cad(0x162)]),_0x48dd35=this[_0x591cad(0x2bf)]();this[_0x591cad(0x2fd)](_0x783827,_0x591cad(0x162),_0x48dd35);},Window_EquipCommand[_0x77d410(0xc6)][_0x77d410(0x3c4)]=function(){const _0x21cd2c=_0x77d410;return VisuMZ[_0x21cd2c(0x1e8)][_0x21cd2c(0x96)][_0x21cd2c(0x176)]['CommandAddClear'];},Window_EquipCommand[_0x77d410(0xc6)][_0x77d410(0x2bf)]=function(){return!![];},Window_EquipCommand[_0x77d410(0xc6)][_0x77d410(0x357)]=function(){const _0x5baf36=_0x77d410;return VisuMZ[_0x5baf36(0x1e8)][_0x5baf36(0x96)][_0x5baf36(0x176)][_0x5baf36(0x31e)];},Window_EquipCommand[_0x77d410(0xc6)]['drawItem']=function(_0x269a0b){const _0x29dd2c=_0x77d410,_0x54dcb1=this[_0x29dd2c(0x3f5)](_0x269a0b);if(_0x54dcb1==='iconText')this['drawItemStyleIconText'](_0x269a0b);else _0x54dcb1===_0x29dd2c(0x463)?this['drawItemStyleIcon'](_0x269a0b):Window_HorzCommand['prototype']['drawItem']['call'](this,_0x269a0b);},Window_EquipCommand[_0x77d410(0xc6)]['commandStyle']=function(){const _0xab533d=_0x77d410;return VisuMZ[_0xab533d(0x1e8)][_0xab533d(0x96)][_0xab533d(0x176)]['CmdStyle'];},Window_EquipCommand[_0x77d410(0xc6)][_0x77d410(0x3f5)]=function(_0x5753e2){const _0x1c1b12=_0x77d410;if(_0x5753e2<0x0)return _0x1c1b12(0x2fe);const _0x48d14e=this['commandStyle']();if(_0x48d14e!==_0x1c1b12(0x1ea))return _0x48d14e;else{if(this['maxItems']()>0x0){const _0x4f6f2e=this['commandName'](_0x5753e2);if(_0x4f6f2e[_0x1c1b12(0x336)](/\\I\[(\d+)\]/i)){const _0xf3a50d=this[_0x1c1b12(0x1e3)](_0x5753e2),_0x38a129=this['textSizeEx'](_0x4f6f2e)['width'];return _0x38a129<=_0xf3a50d[_0x1c1b12(0x28e)]?_0x1c1b12(0x99):_0x1c1b12(0x463);}}}return _0x1c1b12(0x2fe);},Window_EquipCommand['prototype']['drawItemStyleIconText']=function(_0x2f1a88){const _0x52f13f=_0x77d410,_0x1b1ce2=this[_0x52f13f(0x1e3)](_0x2f1a88),_0x5941fb=this[_0x52f13f(0x167)](_0x2f1a88),_0x3794d5=this[_0x52f13f(0x401)](_0x5941fb)['width'];this[_0x52f13f(0xe0)](this['isCommandEnabled'](_0x2f1a88));const _0x368055=this[_0x52f13f(0x357)]();if(_0x368055===_0x52f13f(0x1d4))this['drawTextEx'](_0x5941fb,_0x1b1ce2['x']+_0x1b1ce2[_0x52f13f(0x28e)]-_0x3794d5,_0x1b1ce2['y'],_0x3794d5);else{if(_0x368055===_0x52f13f(0x1bb)){const _0x4a36f3=_0x1b1ce2['x']+Math[_0x52f13f(0xc9)]((_0x1b1ce2[_0x52f13f(0x28e)]-_0x3794d5)/0x2);this[_0x52f13f(0x2cb)](_0x5941fb,_0x4a36f3,_0x1b1ce2['y'],_0x3794d5);}else this[_0x52f13f(0x2cb)](_0x5941fb,_0x1b1ce2['x'],_0x1b1ce2['y'],_0x3794d5);}},Window_EquipCommand['prototype'][_0x77d410(0xc8)]=function(_0x345987){const _0x56ca3e=_0x77d410;this[_0x56ca3e(0x167)](_0x345987)[_0x56ca3e(0x336)](/\\I\[(\d+)\]/i);const _0x1a0ede=Number(RegExp['$1'])||0x0,_0x5eb948=this[_0x56ca3e(0x1e3)](_0x345987),_0x2cfcff=_0x5eb948['x']+Math[_0x56ca3e(0xc9)]((_0x5eb948[_0x56ca3e(0x28e)]-ImageManager[_0x56ca3e(0x18f)])/0x2),_0x167a3a=_0x5eb948['y']+(_0x5eb948['height']-ImageManager[_0x56ca3e(0xe6)])/0x2;this[_0x56ca3e(0x398)](_0x1a0ede,_0x2cfcff,_0x167a3a);},Window_EquipCommand[_0x77d410(0xc6)][_0x77d410(0x1d7)]=function(){const _0x2b34ec=_0x77d410,_0x489d3c=SceneManager[_0x2b34ec(0x12a)];if(_0x489d3c&&_0x489d3c[_0x2b34ec(0x254)])return _0x489d3c['user']();return null;},Window_EquipCommand[_0x77d410(0xc6)][_0x77d410(0x226)]=function(){const _0x4e5e16=_0x77d410;Window_Command['prototype'][_0x4e5e16(0x226)][_0x4e5e16(0x200)](this),this[_0x4e5e16(0x2f2)][_0x4e5e16(0x32b)](this['helpDescriptionText']());},Window_EquipCommand[_0x77d410(0xc6)][_0x77d410(0x2ff)]=function(){const _0x1b0a90=_0x77d410,_0x22e28b=this['currentSymbol']();switch(_0x22e28b){case'equip':return TextManager[_0x1b0a90(0x3e6)]['helpDesc'][_0x1b0a90(0x36f)];case _0x1b0a90(0x32e):return TextManager['ITEMS_EQUIPS_CORE'][_0x1b0a90(0x383)]['optimize'];case _0x1b0a90(0x162):return TextManager[_0x1b0a90(0x3e6)][_0x1b0a90(0x383)][_0x1b0a90(0x162)];default:return'';}},Window_EquipSlot['prototype'][_0x77d410(0x460)]=function(){const _0x284a7c=_0x77d410;return Imported['VisuMZ_0_CoreEngine']&&Window_HorzCommand[_0x284a7c(0xc6)]['isUseModernControls'][_0x284a7c(0x200)](this);},Window_EquipSlot[_0x77d410(0xc6)][_0x77d410(0x322)]=function(){const _0x55222f=_0x77d410;Window_StatusBase[_0x55222f(0xc6)][_0x55222f(0x322)][_0x55222f(0x200)](this),this['callUpdateHelp']();},Window_EquipSlot['prototype'][_0x77d410(0x39b)]=function(){const _0x54557d=_0x77d410;Window_StatusBase['prototype'][_0x54557d(0x39b)][_0x54557d(0x200)](this),this[_0x54557d(0x360)]();},Window_EquipSlot[_0x77d410(0xc6)][_0x77d410(0x360)]=function(){const _0x1d3812=_0x77d410;if(!this['isShiftRemoveShortcutEnabled']())return;if(Input['isTriggered'](_0x1d3812(0x2ed))&&this['item']()){const _0x3b592a=SceneManager[_0x1d3812(0x12a)][_0x1d3812(0x16a)];_0x3b592a&&(this[_0x1d3812(0x1e6)](this['index']())?(this[_0x1d3812(0x3bb)](),this[_0x1d3812(0x226)]()):this[_0x1d3812(0x104)]());}},Window_EquipSlot[_0x77d410(0xc6)][_0x77d410(0x1e6)]=function(_0x23c7ca){const _0x131a16=_0x77d410,_0x3818d9=SceneManager['_scene'][_0x131a16(0x16a)];if(!_0x3818d9)return;if(!_0x3818d9[_0x131a16(0x2ab)](_0x23c7ca))return![];const _0x50ec66=_0x3818d9[_0x131a16(0x30d)]()[_0x23c7ca];if(_0x3818d9[_0x131a16(0x181)]()['includes'](_0x50ec66))return![];return!![];;},Window_EquipSlot['prototype'][_0x77d410(0x3bb)]=function(){const _0x21a494=_0x77d410;SoundManager['playEquip']();const _0x2252e2=SceneManager[_0x21a494(0x12a)]['_actor'];_0x2252e2[_0x21a494(0x413)](this[_0x21a494(0x418)](),null),this[_0x21a494(0x2b1)](),this['_itemWindow']['refresh'](),this['callUpdateHelp']();const _0x3a353c=SceneManager[_0x21a494(0x12a)][_0x21a494(0x151)];if(_0x3a353c)_0x3a353c['refresh']();},Window_EquipSlot[_0x77d410(0xc6)][_0x77d410(0x140)]=function(){const _0x17feee=_0x77d410;if(!this['active'])return![];if(!VisuMZ[_0x17feee(0x1e8)][_0x17feee(0x96)][_0x17feee(0x176)][_0x17feee(0x215)])return![];return!![];},Window_EquipSlot['prototype'][_0x77d410(0x353)]=function(){const _0x4a526f=_0x77d410;!this[_0x4a526f(0x264)]()&&Window_StatusBase['prototype'][_0x4a526f(0x353)][_0x4a526f(0x200)](this);},Window_EquipSlot[_0x77d410(0xc6)][_0x77d410(0x264)]=function(){const _0x6bb060=_0x77d410;if(!this[_0x6bb060(0x405)]())return![];if(SceneManager['_scene'][_0x6bb060(0x8d)]!==Scene_Equip)return![];if(this['allowCommandWindowCursorUp']())return this[_0x6bb060(0xc2)](),Input[_0x6bb060(0x162)](),SceneManager[_0x6bb060(0x12a)][_0x6bb060(0x240)](),![];else{if(Input['isRepeated'](_0x6bb060(0x3e2))){const _0x15f622=this[_0x6bb060(0x418)]();return Input[_0x6bb060(0x12f)](_0x6bb060(0x2ed))?this['cursorPagedown']():this[_0x6bb060(0x16c)](Input[_0x6bb060(0x351)](_0x6bb060(0x3e2))),this[_0x6bb060(0x418)]()!==_0x15f622&&this[_0x6bb060(0xc2)](),!![];}else{if(this['isShiftShortcutKeyForRemove']()&&Input[_0x6bb060(0x351)](_0x6bb060(0x2ed)))return!![];}}return![];},Window_EquipSlot[_0x77d410(0xc6)]['allowCommandWindowCursorUp']=function(){const _0x424d69=_0x77d410;if(this['index']()!==0x0)return![];const _0x564c95=VisuMZ[_0x424d69(0x1e8)][_0x424d69(0x96)][_0x424d69(0x176)];if(!_0x564c95[_0x424d69(0xb1)]&&!_0x564c95['CommandAddClear'])return![];return Input[_0x424d69(0x351)]('up');},Window_EquipSlot[_0x77d410(0xc6)][_0x77d410(0x30f)]=function(){const _0x5ed017=_0x77d410;return VisuMZ[_0x5ed017(0x1e8)][_0x5ed017(0x96)][_0x5ed017(0x176)][_0x5ed017(0x215)];},Window_EquipSlot[_0x77d410(0xc6)]['processTouchModernControls']=function(){const _0x2cef4b=_0x77d410;if(this[_0x2cef4b(0x17e)]()&&this[_0x2cef4b(0xaf)]&&SceneManager['_scene'][_0x2cef4b(0x8d)]===Scene_Equip){if(this[_0x2cef4b(0x3aa)]()&&TouchInput[_0x2cef4b(0x1ef)]())this[_0x2cef4b(0x38a)](![]);else TouchInput['isTriggered']()&&this['onTouchSelectModernControls'](!![]);if(TouchInput[_0x2cef4b(0x165)]())this['onTouchOk']();else TouchInput['isCancelled']()&&this[_0x2cef4b(0x1fa)]();}},Window_EquipSlot[_0x77d410(0xc6)][_0x77d410(0x38a)]=function(_0x3c2144){const _0x3a6952=_0x77d410;this[_0x3a6952(0x295)]=![];const _0x241d5c=this['index'](),_0x3e4ab9=this[_0x3a6952(0x125)](),_0xd4144a=SceneManager[_0x3a6952(0x12a)][_0x3a6952(0x397)];if(_0xd4144a[_0x3a6952(0x17e)]()&&_0xd4144a[_0x3a6952(0xaf)]){if(_0x3e4ab9>=0x0)_0x3e4ab9===this[_0x3a6952(0x418)]()&&(this[_0x3a6952(0x295)]=!![]),this[_0x3a6952(0x322)](),this[_0x3a6952(0x464)](_0x3e4ab9);else _0xd4144a['hitIndex']()>=0x0&&(this['deactivate'](),this[_0x3a6952(0x2a5)]());}_0x3c2144&&this[_0x3a6952(0x418)]()!==_0x241d5c&&this[_0x3a6952(0xc2)]();},Window_EquipSlot[_0x77d410(0xc6)][_0x77d410(0x305)]=function(){const _0x20bbba=_0x77d410;return this[_0x20bbba(0x418)]();},VisuMZ['ItemsEquipsCore'][_0x77d410(0x148)]=Window_EquipItem[_0x77d410(0xc6)][_0x77d410(0x26b)],Window_EquipItem[_0x77d410(0xc6)][_0x77d410(0x26b)]=function(_0x3cc26b){const _0x315c24=_0x77d410;if(_0x3cc26b===null&&this[_0x315c24(0x181)]()[_0x315c24(0x26b)](this['etypeId']()))return![];else{$gameTemp['_checkEquipRequirements']=!![];let _0x831b54=VisuMZ[_0x315c24(0x1e8)][_0x315c24(0x148)]['call'](this,_0x3cc26b);if(!_0x831b54&&_0x3cc26b&&DataManager[_0x315c24(0x81)](_0x3cc26b)){const _0x198394=_0x3cc26b['atypeId']||0x0;if(this[_0x315c24(0x16a)]&&this[_0x315c24(0x16a)][_0x315c24(0x180)](_0x198394)){const _0x423b89=DataManager[_0x315c24(0xfb)](_0x3cc26b);_0x423b89[_0x315c24(0x26b)](this[_0x315c24(0x44a)]())&&(_0x831b54=!![]);}}return $gameTemp['_checkEquipRequirements']=undefined,_0x831b54;}},VisuMZ['ItemsEquipsCore'][_0x77d410(0x1aa)]=Window_EquipItem[_0x77d410(0xc6)]['isEnabled'],Window_EquipItem[_0x77d410(0xc6)][_0x77d410(0x1f0)]=function(_0x448b73){const _0x5e0e1b=_0x77d410;if(_0x448b73&&this['_actor']){if(this[_0x5e0e1b(0x21f)](_0x448b73))return![];if(this['isSoleWeaponType'](_0x448b73))return![];if(this[_0x5e0e1b(0xdb)](_0x448b73))return![];if(!this[_0x5e0e1b(0x16a)][_0x5e0e1b(0x2c3)](_0x448b73))return![];}if(!_0x448b73)return!this[_0x5e0e1b(0x181)]()['includes'](this[_0x5e0e1b(0x44a)]());return VisuMZ[_0x5e0e1b(0x1e8)]['Window_EquipItem_isEnabled'][_0x5e0e1b(0x200)](this,_0x448b73);},Window_EquipItem['prototype'][_0x77d410(0x21f)]=function(_0x42ca74){const _0x213b1f=_0x77d410,_0x5c9525=_0x42ca74['note'];if(_0x5c9525[_0x213b1f(0x336)](/<EQUIP COPY LIMIT:[ ](\d+)>/i)){const _0x524c7d=Number(RegExp['$1'])||0x1;let _0x276a04=0x0;const _0x37f6ba=this[_0x213b1f(0x16a)][_0x213b1f(0x3ac)](),_0x284b47=SceneManager[_0x213b1f(0x12a)][_0x213b1f(0xf6)][_0x213b1f(0x305)]();_0x37f6ba[_0x284b47]=null;for(const _0x2e487b of _0x37f6ba){if(!_0x2e487b)continue;if(DataManager[_0x213b1f(0x24d)](_0x42ca74)===DataManager[_0x213b1f(0x24d)](_0x2e487b)){if(_0x42ca74['id']===_0x2e487b['id'])_0x276a04+=0x1;}}return _0x276a04>=_0x524c7d;}else return![];},Window_EquipItem[_0x77d410(0xc6)][_0x77d410(0x17a)]=function(_0x3f57dd){const _0x241b80=_0x77d410;if(!DataManager[_0x241b80(0x24d)](_0x3f57dd))return![];const _0x335fda=/<EQUIP WEAPON TYPE LIMIT:[ ](\d+)>/i;let _0x5e6680=0x0;const _0x5c46ae=this[_0x241b80(0x16a)][_0x241b80(0x3ac)](),_0x36a2b3=SceneManager['_scene']['_slotWindow']['equipSlotIndex']();_0x5c46ae[_0x36a2b3]=null;for(const _0x244dee of _0x5c46ae){if(!_0x244dee)continue;if(!DataManager[_0x241b80(0x24d)](_0x244dee))continue;if(_0x3f57dd['wtypeId']===_0x244dee[_0x241b80(0x201)]){_0x5e6680+=0x1;if(_0x3f57dd[_0x241b80(0x272)][_0x241b80(0x336)](_0x335fda)){const _0x45d2ca=Number(RegExp['$1'])||0x1;if(_0x5e6680>=_0x45d2ca)return!![];}if(_0x244dee['note'][_0x241b80(0x336)](_0x335fda)){const _0x408ebc=Number(RegExp['$1'])||0x1;if(_0x5e6680>=_0x408ebc)return!![];}}}return![];},Window_EquipItem[_0x77d410(0xc6)]['isSoleArmorType']=function(_0x5117fd){const _0x4b80b8=_0x77d410;if(!DataManager['isArmor'](_0x5117fd))return![];const _0x35d867=/<EQUIP ARMOR TYPE LIMIT:[ ](\d+)>/i;let _0x3d9e49=0x0;const _0x4d52bc=this[_0x4b80b8(0x16a)][_0x4b80b8(0x3ac)](),_0x1fc456=SceneManager[_0x4b80b8(0x12a)]['_slotWindow'][_0x4b80b8(0x305)]();_0x4d52bc[_0x1fc456]=null;for(const _0x3b0937 of _0x4d52bc){if(!_0x3b0937)continue;if(!DataManager[_0x4b80b8(0x81)](_0x3b0937))continue;if(_0x5117fd[_0x4b80b8(0x80)]===_0x3b0937[_0x4b80b8(0x80)]){_0x3d9e49+=0x1;if(_0x5117fd[_0x4b80b8(0x272)][_0x4b80b8(0x336)](_0x35d867)){const _0x5dac19=Number(RegExp['$1'])||0x1;if(_0x3d9e49>=_0x5dac19)return!![];}if(_0x3b0937[_0x4b80b8(0x272)][_0x4b80b8(0x336)](_0x35d867)){const _0x127746=Number(RegExp['$1'])||0x1;if(_0x3d9e49>=_0x127746)return!![];}}}return![];},Window_EquipItem['prototype'][_0x77d410(0x181)]=function(){const _0x42f58e=_0x77d410;return VisuMZ[_0x42f58e(0x1e8)][_0x42f58e(0x96)][_0x42f58e(0x176)][_0x42f58e(0x16b)];},Window_EquipItem[_0x77d410(0xc6)][_0x77d410(0x2a9)]=function(_0x14cae7){const _0xec7581=_0x77d410,_0x45d0a9=this[_0xec7581(0x3ce)](_0x14cae7);_0x45d0a9?Window_ItemList[_0xec7581(0xc6)][_0xec7581(0x2a9)][_0xec7581(0x200)](this,_0x14cae7):this[_0xec7581(0x3cb)](_0x14cae7);},Window_EquipItem[_0x77d410(0xc6)][_0x77d410(0x3cb)]=function(_0x253470){const _0x4e38e4=_0x77d410;this[_0x4e38e4(0xe0)](this[_0x4e38e4(0x1f0)](null));const _0x2e26b8=VisuMZ[_0x4e38e4(0x1e8)]['Settings'][_0x4e38e4(0x176)],_0x24db40=this['itemLineRect'](_0x253470),_0x2d73e6=_0x24db40['y']+(this[_0x4e38e4(0x1e2)]()-ImageManager[_0x4e38e4(0xe6)])/0x2,_0x305d08=ImageManager[_0x4e38e4(0x18f)]+0x4,_0x263990=Math[_0x4e38e4(0x17f)](0x0,_0x24db40['width']-_0x305d08);this[_0x4e38e4(0x159)](),this[_0x4e38e4(0x398)](_0x2e26b8['RemoveEquipIcon'],_0x24db40['x'],_0x2d73e6),this[_0x4e38e4(0x315)](_0x2e26b8[_0x4e38e4(0xa4)],_0x24db40['x']+_0x305d08,_0x24db40['y'],_0x263990),this[_0x4e38e4(0xe0)](!![]);},Window_EquipItem['prototype'][_0x77d410(0x226)]=function(){const _0x2e24d6=_0x77d410;Window_ItemList[_0x2e24d6(0xc6)]['updateHelp']['call'](this);if(this['_actor']&&this[_0x2e24d6(0x151)]&&this[_0x2e24d6(0x1e4)]>=0x0){const _0x239953=JsonEx['makeDeepCopy'](this['_actor']);_0x239953[_0x2e24d6(0x3fe)]=!![],_0x239953[_0x2e24d6(0x243)](this[_0x2e24d6(0x1e4)],this[_0x2e24d6(0x298)]()),this[_0x2e24d6(0x151)]['setTempActor'](_0x239953);}},VisuMZ[_0x77d410(0x1e8)]['Window_ShopCommand_initialize']=Window_ShopCommand[_0x77d410(0xc6)][_0x77d410(0x335)],Window_ShopCommand[_0x77d410(0xc6)][_0x77d410(0x335)]=function(_0x5ab864){const _0x1dc4cf=_0x77d410;VisuMZ[_0x1dc4cf(0x1e8)]['Window_ShopCommand_initialize'][_0x1dc4cf(0x200)](this,_0x5ab864),this[_0x1dc4cf(0x3d4)](_0x5ab864);},Window_ShopCommand[_0x77d410(0xc6)]['createCommandNameWindow']=function(_0x427156){const _0x19bfd2=_0x77d410,_0x2b1dd6=new Rectangle(0x0,0x0,_0x427156[_0x19bfd2(0x28e)],_0x427156[_0x19bfd2(0x2b5)]);this['_commandNameWindow']=new Window_Base(_0x2b1dd6),this[_0x19bfd2(0xbf)][_0x19bfd2(0x359)]=0x0,this[_0x19bfd2(0x1bc)](this[_0x19bfd2(0xbf)]),this[_0x19bfd2(0xef)]();},Window_ShopCommand['prototype'][_0x77d410(0x432)]=function(){const _0x4c058a=_0x77d410;Window_HorzCommand[_0x4c058a(0xc6)][_0x4c058a(0x432)][_0x4c058a(0x200)](this);if(this[_0x4c058a(0xbf)])this[_0x4c058a(0xef)]();},Window_ShopCommand[_0x77d410(0xc6)][_0x77d410(0xef)]=function(){const _0x257a55=_0x77d410,_0x388c28=this['_commandNameWindow'];_0x388c28[_0x257a55(0x40d)][_0x257a55(0x162)]();const _0x10bd6f=this['commandStyleCheck'](this[_0x257a55(0x418)]());if(_0x10bd6f===_0x257a55(0x463)){const _0x3bb05f=this[_0x257a55(0x1e3)](this[_0x257a55(0x418)]());let _0x39678e=this[_0x257a55(0x167)](this[_0x257a55(0x418)]());_0x39678e=_0x39678e[_0x257a55(0x311)](/\\I\[(\d+)\]/gi,''),_0x388c28['resetFontSettings'](),this['commandNameWindowDrawBackground'](_0x39678e,_0x3bb05f),this['commandNameWindowDrawText'](_0x39678e,_0x3bb05f),this[_0x257a55(0x14e)](_0x39678e,_0x3bb05f);}},Window_ShopCommand['prototype'][_0x77d410(0x71)]=function(_0x10c734,_0x5deb3f){},Window_ShopCommand[_0x77d410(0xc6)][_0x77d410(0x74)]=function(_0x3949d5,_0xc168f8){const _0x2b5353=_0x77d410,_0x15b0ab=this[_0x2b5353(0xbf)];_0x15b0ab[_0x2b5353(0x315)](_0x3949d5,0x0,_0xc168f8['y'],_0x15b0ab[_0x2b5353(0x279)],_0x2b5353(0x1bb));},Window_ShopCommand[_0x77d410(0xc6)][_0x77d410(0x14e)]=function(_0x919c63,_0xd9aedb){const _0x51e451=_0x77d410,_0xf3161c=this['_commandNameWindow'],_0x4d8a90=$gameSystem['windowPadding'](),_0x468b59=_0xd9aedb['x']+Math[_0x51e451(0xc9)](_0xd9aedb[_0x51e451(0x28e)]/0x2)+_0x4d8a90;_0xf3161c['x']=_0xf3161c[_0x51e451(0x28e)]/-0x2+_0x468b59,_0xf3161c['y']=Math[_0x51e451(0xc9)](_0xd9aedb['height']/0x2);},Window_ShopCommand['prototype'][_0x77d410(0x107)]=function(){const _0x5a1038=_0x77d410;return this[_0x5a1038(0x468)]?this['_list']['length']:0x3;},Window_ShopCommand[_0x77d410(0xc6)]['hideDisabledCommands']=function(){const _0x1451af=_0x77d410;return VisuMZ[_0x1451af(0x1e8)][_0x1451af(0x96)]['ShopScene']['CmdHideDisabled'];},Window_ShopCommand[_0x77d410(0xc6)][_0x77d410(0x127)]=function(){const _0x2becdb=_0x77d410;this[_0x2becdb(0x1f5)](),this[_0x2becdb(0x1fb)](),this['addCancelCommand']();},Window_ShopCommand['prototype'][_0x77d410(0x2b1)]=function(){const _0x463213=_0x77d410;Window_HorzCommand[_0x463213(0xc6)][_0x463213(0x2b1)]['call'](this),this[_0x463213(0x338)]();},Window_ShopCommand[_0x77d410(0xc6)][_0x77d410(0x1f5)]=function(){const _0x2c4ce4=_0x77d410,_0x35c29c=this[_0x2c4ce4(0x446)](),_0x19978b=VisuMZ[_0x2c4ce4(0x1e8)][_0x2c4ce4(0x96)]['ShopScene']['CmdIconBuy'],_0x4670bd=_0x35c29c===_0x2c4ce4(0x2fe)?TextManager[_0x2c4ce4(0x94)]:'\x5cI[%1]%2'[_0x2c4ce4(0x290)](_0x19978b,TextManager[_0x2c4ce4(0x94)]),_0x15bd82=this[_0x2c4ce4(0x1db)]();if(this[_0x2c4ce4(0xf1)]()&&!_0x15bd82)return;this[_0x2c4ce4(0x2fd)](_0x4670bd,_0x2c4ce4(0x94),_0x15bd82);},Window_ShopCommand[_0x77d410(0xc6)][_0x77d410(0x1db)]=function(){const _0x51855c=_0x77d410;return SceneManager['_scene'][_0x51855c(0x8d)]===Scene_Shop?SceneManager[_0x51855c(0x12a)]['_goodsCount']>0x0:!![];},Window_ShopCommand[_0x77d410(0xc6)][_0x77d410(0x1fb)]=function(){const _0x529188=_0x77d410,_0x2f28d2=this[_0x529188(0x446)](),_0x15a74f=VisuMZ[_0x529188(0x1e8)]['Settings']['ShopScene'][_0x529188(0x1b4)],_0x4a33d7=_0x2f28d2===_0x529188(0x2fe)?TextManager[_0x529188(0x10e)]:_0x529188(0x1eb)['format'](_0x15a74f,TextManager[_0x529188(0x10e)]),_0x17e152=this[_0x529188(0x10a)]();if(this[_0x529188(0xf1)]()&&!_0x17e152)return;this[_0x529188(0x2fd)](_0x4a33d7,'sell',_0x17e152);},Window_ShopCommand['prototype'][_0x77d410(0x10a)]=function(){const _0x4b1bea=_0x77d410;return!this[_0x4b1bea(0xc5)];},Window_ShopCommand[_0x77d410(0xc6)][_0x77d410(0x11d)]=function(){const _0x376c28=_0x77d410,_0x3d2b4c=this[_0x376c28(0x446)](),_0xcce5bd=VisuMZ[_0x376c28(0x1e8)][_0x376c28(0x96)][_0x376c28(0x362)][_0x376c28(0x20f)],_0x337316=VisuMZ[_0x376c28(0x1e8)]['Settings'][_0x376c28(0x362)]['CmdCancelRename'],_0x313ca5=_0x3d2b4c===_0x376c28(0x2fe)?_0x337316:_0x376c28(0x1eb)['format'](_0xcce5bd,_0x337316);this[_0x376c28(0x2fd)](_0x313ca5,_0x376c28(0x144));},Window_ShopCommand[_0x77d410(0xc6)][_0x77d410(0x357)]=function(){const _0x34386c=_0x77d410;return VisuMZ['ItemsEquipsCore']['Settings']['ShopScene'][_0x34386c(0x31e)];},Window_ShopCommand[_0x77d410(0xc6)][_0x77d410(0x2a9)]=function(_0x3e4ce6){const _0x3efa89=_0x77d410,_0x369fb9=this[_0x3efa89(0x3f5)](_0x3e4ce6);if(_0x369fb9===_0x3efa89(0x99))this[_0x3efa89(0x3a1)](_0x3e4ce6);else _0x369fb9===_0x3efa89(0x463)?this['drawItemStyleIcon'](_0x3e4ce6):Window_HorzCommand['prototype']['drawItem']['call'](this,_0x3e4ce6);},Window_ShopCommand[_0x77d410(0xc6)][_0x77d410(0x446)]=function(){const _0x3fe712=_0x77d410;return VisuMZ[_0x3fe712(0x1e8)][_0x3fe712(0x96)][_0x3fe712(0x362)][_0x3fe712(0x276)];},Window_ShopCommand[_0x77d410(0xc6)][_0x77d410(0x3f5)]=function(_0x4ec60e){const _0x26693b=_0x77d410;if(_0x4ec60e<0x0)return _0x26693b(0x2fe);const _0x1cc9f7=this[_0x26693b(0x446)]();if(_0x1cc9f7!=='auto')return _0x1cc9f7;else{if(this[_0x26693b(0x17b)]()>0x0){const _0xf0cdfb=this['commandName'](_0x4ec60e);if(_0xf0cdfb[_0x26693b(0x336)](/\\I\[(\d+)\]/i)){const _0x17eb39=this['itemLineRect'](_0x4ec60e),_0x43bc21=this[_0x26693b(0x401)](_0xf0cdfb)[_0x26693b(0x28e)];return _0x43bc21<=_0x17eb39[_0x26693b(0x28e)]?_0x26693b(0x99):'icon';}}}return _0x26693b(0x2fe);},Window_ShopCommand['prototype'][_0x77d410(0x3a1)]=function(_0x3b68e4){const _0x438c6=_0x77d410,_0x4a2841=this[_0x438c6(0x1e3)](_0x3b68e4),_0x5ca548=this[_0x438c6(0x167)](_0x3b68e4),_0x89c5b3=this['textSizeEx'](_0x5ca548)['width'];this['changePaintOpacity'](this['isCommandEnabled'](_0x3b68e4));const _0x5913c7=this[_0x438c6(0x357)]();if(_0x5913c7===_0x438c6(0x1d4))this['drawTextEx'](_0x5ca548,_0x4a2841['x']+_0x4a2841[_0x438c6(0x28e)]-_0x89c5b3,_0x4a2841['y'],_0x89c5b3);else{if(_0x5913c7===_0x438c6(0x1bb)){const _0x34751b=_0x4a2841['x']+Math['floor']((_0x4a2841[_0x438c6(0x28e)]-_0x89c5b3)/0x2);this[_0x438c6(0x2cb)](_0x5ca548,_0x34751b,_0x4a2841['y'],_0x89c5b3);}else this[_0x438c6(0x2cb)](_0x5ca548,_0x4a2841['x'],_0x4a2841['y'],_0x89c5b3);}},Window_ShopCommand[_0x77d410(0xc6)][_0x77d410(0xc8)]=function(_0x1746fd){const _0x1e5a70=_0x77d410;this[_0x1e5a70(0x167)](_0x1746fd)[_0x1e5a70(0x336)](/\\I\[(\d+)\]/i);const _0x4824c0=Number(RegExp['$1'])||0x0,_0x3f1bdb=this[_0x1e5a70(0x1e3)](_0x1746fd),_0x3054e4=_0x3f1bdb['x']+Math[_0x1e5a70(0xc9)]((_0x3f1bdb[_0x1e5a70(0x28e)]-ImageManager[_0x1e5a70(0x18f)])/0x2),_0x30c3b2=_0x3f1bdb['y']+(_0x3f1bdb['height']-ImageManager[_0x1e5a70(0xe6)])/0x2;this[_0x1e5a70(0x398)](_0x4824c0,_0x3054e4,_0x30c3b2);},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0xfd)]=Window_ShopBuy['prototype'][_0x77d410(0x2b1)],Window_ShopBuy[_0x77d410(0xc6)][_0x77d410(0x2b1)]=function(){const _0x4db1ed=_0x77d410;this[_0x4db1ed(0x136)](),VisuMZ[_0x4db1ed(0x1e8)][_0x4db1ed(0xfd)]['call'](this);},Window_ShopBuy[_0x77d410(0xc6)][_0x77d410(0x136)]=function(){const _0x5179b3=_0x77d410;SceneManager['_scene']['constructor']===Scene_Shop&&(this[_0x5179b3(0xa6)]=SceneManager[_0x5179b3(0x12a)][_0x5179b3(0x266)]());},VisuMZ['ItemsEquipsCore'][_0x77d410(0x459)]=Window_ShopBuy[_0x77d410(0xc6)][_0x77d410(0x36a)],Window_ShopBuy[_0x77d410(0xc6)][_0x77d410(0x36a)]=function(_0x4242b2){const _0x24f73d=_0x77d410;if(!_0x4242b2)return 0x0;let _0xf0ec05=VisuMZ[_0x24f73d(0x1e8)]['Window_ShopBuy_price'][_0x24f73d(0x200)](this,_0x4242b2);return Math[_0x24f73d(0x17f)](0x0,this['modifiedBuyPriceItemsEquipsCore'](_0x4242b2,_0xf0ec05));},Window_ShopBuy[_0x77d410(0xc6)]['modifiedBuyPriceItemsEquipsCore']=function(_0x4e6574,_0x53f39c){const _0x1501f4=_0x77d410,_0x4f25f2=_0x4e6574[_0x1501f4(0x272)]||'';if(_0x4f25f2[_0x1501f4(0x336)](/<JS BUY PRICE>\s*([\s\S]*)\s*<\/JS BUY PRICE>/i)){const _0x23108c=String(RegExp['$1']);window[_0x1501f4(0x36a)]=_0x53f39c,window[_0x1501f4(0x298)]=_0x4e6574;try{eval(_0x23108c);}catch(_0x40b52e){if($gameTemp[_0x1501f4(0x3ea)]())console[_0x1501f4(0x2ec)](_0x40b52e);}_0x53f39c=window[_0x1501f4(0x36a)],window[_0x1501f4(0x36a)]=undefined,window[_0x1501f4(0x298)]=undefined;}_0x53f39c=VisuMZ[_0x1501f4(0x1e8)][_0x1501f4(0x96)][_0x1501f4(0x362)][_0x1501f4(0x38f)][_0x1501f4(0x200)](this,_0x4e6574,_0x53f39c);if(isNaN(_0x53f39c))_0x53f39c=0x0;return Math[_0x1501f4(0xc9)](_0x53f39c);},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x293)]=Window_ShopBuy[_0x77d410(0xc6)][_0x77d410(0x334)],Window_ShopBuy[_0x77d410(0xc6)][_0x77d410(0x334)]=function(_0x176aa7){const _0x22aab0=_0x77d410,_0x4ae494=VisuMZ[_0x22aab0(0x1e8)][_0x22aab0(0x293)][_0x22aab0(0x200)](this,_0x176aa7);return _0x4ae494&&!this['meetsShopListingConditions'](_0x4ae494)?null:_0x4ae494;},VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x160)]={'ShowAllSwitches':/<SHOW SHOP (?:ALL |)SWITCH(?:|ES):[ ](.*)>/i,'ShowAnySwitches':/<SHOW SHOP ANY SWITCH(?:|ES):[ ](.*)>/i,'HideAllSwitches':/<HIDE SHOP (?:ALL |)SWITCH(?:|ES):[ ](.*)>/i,'HideAnySwitches':/<HIDE SHOP ANY SWITCH(?:|ES):[ ](.*)>/i,'BuyTurnSwitchOn':/<BUY TURN ON SWITCH(?:|ES):[ ](.*)>/i,'BuyTurnSwitchOff':/<BUY TURN OFF SWITCH(?:|ES):[ ](.*)>/i,'SellTurnSwitchOn':/<SELL TURN ON SWITCH(?:|ES):[ ](.*)>/i,'SellTurnSwitchOff':/<SELL TURN OFF SWITCH(?:|ES):[ ](.*)>/i},Window_ShopBuy[_0x77d410(0xc6)]['meetsShopListingConditions']=function(_0xda898b){const _0x5dae52=_0x77d410;if(!_0xda898b)return![];const _0x516f68=VisuMZ['ItemsEquipsCore']['ShopListingRegExp'],_0x203346=_0xda898b?_0xda898b[_0x5dae52(0x272)]||'':'';if(_0x203346[_0x5dae52(0x336)](_0x516f68[_0x5dae52(0x225)])){const _0x28868e=String(RegExp['$1'])[_0x5dae52(0x21e)](',')['map'](_0x4cc119=>Number(_0x4cc119));if(_0x28868e[_0x5dae52(0x6f)](_0xa16164=>!$gameSwitches['value'](_0xa16164)))return![];}if(_0x203346[_0x5dae52(0x336)](_0x516f68['ShowAnySwitches'])){const _0x522a9e=String(RegExp['$1'])[_0x5dae52(0x21e)](',')[_0x5dae52(0x199)](_0x43d39b=>Number(_0x43d39b));if(_0x522a9e['every'](_0x1f6058=>!$gameSwitches[_0x5dae52(0x3b5)](_0x1f6058)))return![];}if(_0x203346[_0x5dae52(0x336)](_0x516f68['HideAllSwitches'])){const _0x44c929=String(RegExp['$1'])['split'](',')['map'](_0x236047=>Number(_0x236047));if(_0x44c929[_0x5dae52(0x34a)](_0x19d90a=>$gameSwitches[_0x5dae52(0x3b5)](_0x19d90a)))return![];}if(_0x203346['match'](_0x516f68[_0x5dae52(0x436)])){const _0x48a7b1=String(RegExp['$1'])[_0x5dae52(0x21e)](',')[_0x5dae52(0x199)](_0x2193dc=>Number(_0x2193dc));if(_0x48a7b1[_0x5dae52(0x6f)](_0x9c6bc1=>$gameSwitches[_0x5dae52(0x3b5)](_0x9c6bc1)))return![];}return!![];},Window_ShopBuy[_0x77d410(0xc6)][_0x77d410(0x2a9)]=function(_0x1d0f12){const _0x1b2313=_0x77d410;this[_0x1b2313(0x157)]();const _0x4c150f=this[_0x1b2313(0x3ce)](_0x1d0f12),_0x5b136e=this[_0x1b2313(0x1e3)](_0x1d0f12),_0x2ac283=_0x5b136e[_0x1b2313(0x28e)];this[_0x1b2313(0xe0)](this[_0x1b2313(0x1f0)](_0x4c150f)),this[_0x1b2313(0x183)](_0x4c150f,_0x5b136e['x'],_0x5b136e['y'],_0x2ac283),this[_0x1b2313(0x34c)](_0x4c150f,_0x5b136e),this[_0x1b2313(0xe0)](!![]);},Window_ShopBuy[_0x77d410(0xc6)][_0x77d410(0x34c)]=function(_0x5445ef,_0x49b487){const _0x4ff1ea=_0x77d410,_0x3e13db=this[_0x4ff1ea(0x36a)](_0x5445ef);this[_0x4ff1ea(0x450)](_0x3e13db,TextManager[_0x4ff1ea(0x43c)],_0x49b487['x'],_0x49b487['y'],_0x49b487['width']);},Window_ShopSell['prototype'][_0x77d410(0x107)]=function(){const _0x4353ce=_0x77d410;return SceneManager[_0x4353ce(0x12a)]['isUseItemsEquipsCoreUpdatedLayout']()?0x1:0x2;},VisuMZ['ItemsEquipsCore'][_0x77d410(0x364)]=Window_ShopSell[_0x77d410(0xc6)]['isEnabled'],Window_ShopSell[_0x77d410(0xc6)][_0x77d410(0x1f0)]=function(_0x571347){const _0x1c4c76=_0x77d410;if(!_0x571347)return![];const _0x1c01ce=_0x571347[_0x1c4c76(0x272)];if(_0x1c01ce[_0x1c4c76(0x336)](/<CANNOT SELL>/i))return![];if(_0x1c01ce[_0x1c4c76(0x336)](/<CAN SELL>/i))return!![];if(_0x1c01ce[_0x1c4c76(0x336)](/<CANNOT SELL[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0x38b78a=JSON[_0x1c4c76(0x443)]('['+RegExp['$1']['match'](/\d+/g)+']');for(const _0x1da0d6 of _0x38b78a){if(!$gameSwitches[_0x1c4c76(0x3b5)](_0x1da0d6))return![];}}if(_0x1c01ce[_0x1c4c76(0x336)](/<CANNOT SELL ALL[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0x1ae8b2=JSON['parse']('['+RegExp['$1'][_0x1c4c76(0x336)](/\d+/g)+']');for(const _0x540068 of _0x1ae8b2){if(!$gameSwitches[_0x1c4c76(0x3b5)](_0x540068))return![];}}if(_0x1c01ce['match'](/<CANNOT SELL ANY[ ](?:SW|SWITCH|SWITCHES):[ ]*(\d+(?:\s*,\s*\d+)*)>/i)){const _0x24433b=JSON['parse']('['+RegExp['$1']['match'](/\d+/g)+']');for(const _0x898244 of _0x24433b){if($gameSwitches[_0x1c4c76(0x3b5)](_0x898244))return![];}}return VisuMZ['ItemsEquipsCore']['Window_ShopSell_isEnabled'][_0x1c4c76(0x200)](this,_0x571347);},Window_ShopStatus[_0x77d410(0x86)]=VisuMZ[_0x77d410(0x1e8)][_0x77d410(0x96)][_0x77d410(0x166)][_0x77d410(0x10b)]??0xf0,VisuMZ['ItemsEquipsCore']['Window_ShopStatus_setItem']=Window_ShopStatus['prototype']['setItem'],Window_ShopStatus['prototype'][_0x77d410(0x250)]=function(_0x2da2b4){const _0x394402=_0x77d410;_0x2da2b4=DataManager[_0x394402(0x23c)](_0x2da2b4),DataManager[_0x394402(0x24d)](_0x2da2b4)||DataManager['isArmor'](_0x2da2b4)?this[_0x394402(0x253)](_0x2da2b4):VisuMZ[_0x394402(0x1e8)]['Window_ShopStatus_setItem']['call'](this,_0x2da2b4);},Window_ShopStatus['prototype'][_0x77d410(0x253)]=function(_0x4bf956){const _0x2faa08=_0x77d410;this['_item']=_0x4bf956;const _0x1cd9a0=Window_ShopStatus[_0x2faa08(0x86)];setTimeout(this[_0x2faa08(0x13a)]['bind'](this,_0x4bf956),_0x1cd9a0);},Window_ShopStatus[_0x77d410(0xc6)]['refreshDelay']=function(_0x476adc){const _0x5701a1=_0x77d410;this[_0x5701a1(0x6c)]===_0x476adc&&this[_0x5701a1(0x2b1)]();},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x43b)]=function(){return![];},Window_ShopStatus[_0x77d410(0xc6)]['loadFaceImages']=function(){const _0x1cc13e=_0x77d410;Window_StatusBase['prototype'][_0x1cc13e(0x424)][_0x1cc13e(0x200)](this);for(const _0x50168e of $gameParty[_0x1cc13e(0x14c)]()){ImageManager[_0x1cc13e(0x1c8)](_0x50168e['characterName']());}},Window_ShopStatus[_0x77d410(0xc6)]['translucentOpacity']=function(){const _0xafcdcb=_0x77d410;return VisuMZ[_0xafcdcb(0x1e8)][_0xafcdcb(0x96)]['StatusWindow'][_0xafcdcb(0x11a)];},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x2b1)]=function(){const _0x17ca33=_0x77d410;this[_0x17ca33(0x40d)]['clear'](),this[_0x17ca33(0x291)]['clear'](),this['_item']&&(this[_0x17ca33(0x157)](),this[_0x17ca33(0xe0)](!![]),this['prepareItemCustomData'](),this[_0x17ca33(0x3f6)]()?this[_0x17ca33(0x345)]():this[_0x17ca33(0x320)](),this[_0x17ca33(0x196)]());},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x131)]=function(_0x2633ef,_0x5d1dde){const _0x37e266=_0x77d410;if(!this['isEquipItem']()&&!DataManager[_0x37e266(0x19e)](this[_0x37e266(0x6c)]))return;const _0x5b29f1=this[_0x37e266(0x279)]-this[_0x37e266(0x355)]()-_0x2633ef,_0x133a9c=this[_0x37e266(0x8b)](_0x37e266(0x280));this[_0x37e266(0x1f3)](ColorManager[_0x37e266(0xdf)]()),this[_0x37e266(0x315)](TextManager[_0x37e266(0x314)],_0x2633ef+this[_0x37e266(0x355)](),_0x5d1dde,_0x5b29f1-_0x133a9c),this['resetTextColor'](),this['drawItemNumber'](this[_0x37e266(0x6c)],_0x2633ef,_0x5d1dde,_0x5b29f1);},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0xd7)]=function(_0x45f5f8,_0x5d6496,_0x1e8e2c,_0x3d492d,_0x36031b){const _0x45f8fe=_0x77d410;if(VisuMZ[_0x45f8fe(0x1e8)][_0x45f8fe(0x96)]['StatusWindow']['DrawBackRect']===![])return;_0x36031b=Math['max'](_0x36031b||0x1,0x1);while(_0x36031b--){_0x3d492d=_0x3d492d||this[_0x45f8fe(0x1e2)](),this[_0x45f8fe(0x291)][_0x45f8fe(0x3bc)]=0xa0;const _0x1207b5=ColorManager[_0x45f8fe(0xfa)]();this[_0x45f8fe(0x291)]['fillRect'](_0x45f5f8+0x1,_0x5d6496+0x1,_0x1e8e2c-0x2,_0x3d492d-0x2,_0x1207b5),this[_0x45f8fe(0x291)][_0x45f8fe(0x3bc)]=0xff;}},ColorManager[_0x77d410(0xfa)]=function(){const _0x1c9883=_0x77d410,_0x15e358=VisuMZ['ItemsEquipsCore'][_0x1c9883(0x96)][_0x1c9883(0x166)];let _0x7633fd=_0x15e358[_0x1c9883(0x102)]!==undefined?_0x15e358[_0x1c9883(0x102)]:0x13;return ColorManager[_0x1c9883(0x26a)](_0x7633fd);},Window_ShopStatus['prototype']['drawEquipData']=function(){const _0x5eeece=_0x77d410;this[_0x5eeece(0x3fe)]=null;if(VisuMZ['ItemsEquipsCore'][_0x5eeece(0x96)][_0x5eeece(0x166)][_0x5eeece(0x2db)]){VisuMZ[_0x5eeece(0x1e8)][_0x5eeece(0x96)][_0x5eeece(0x166)][_0x5eeece(0x2db)]['call'](this);return;}const _0x3e5009=this[_0x5eeece(0x1e2)](),_0x2fa126=this[_0x5eeece(0x372)]()+0x8;let _0x2fdd67=0x0,_0x2cdb27=0x0,_0xc9c491=this[_0x5eeece(0x279)],_0xc4a0a8=this[_0x5eeece(0x235)],_0x228dee=Math[_0x5eeece(0xc9)](_0xc9c491/0x2),_0x2a1baa=_0x2fdd67+_0xc9c491-_0x228dee;this[_0x5eeece(0x183)](this['_item'],_0x2fdd67+this[_0x5eeece(0x355)](),_0x2cdb27,_0xc9c491-this[_0x5eeece(0x355)]()*0x2),this[_0x5eeece(0xd7)](_0x2fdd67,_0x2cdb27,_0xc9c491),_0x2cdb27+=_0x3e5009;if(this[_0x5eeece(0x3a9)](_0x2fdd67,_0x2cdb27,_0x228dee))_0x2cdb27+=0x0;if(this[_0x5eeece(0x1ca)](_0x2a1baa,_0x2cdb27,_0x228dee))_0x2cdb27+=_0x3e5009;const _0x3c26c6=this['actorParams'](),_0x1182f2=_0x2cdb27;_0x2cdb27=_0xc4a0a8-_0x3c26c6[_0x5eeece(0xcc)]*_0x2fa126-0x4;let _0x3acf0f=_0x2fdd67,_0x34e855=0x0,_0x1bb651=_0x2cdb27;for(const _0x2c05cb of _0x3c26c6){_0x34e855=Math[_0x5eeece(0x17f)](this['drawParamName'](_0x2c05cb,_0x2fdd67+0x4,_0x2cdb27+0x4,_0xc9c491),_0x34e855),_0x2cdb27+=_0x2fa126;}const _0x2a9ad8=$gameParty[_0x5eeece(0x161)](),_0x258d61=Math[_0x5eeece(0xc9)]((_0xc9c491-_0x34e855)/_0x2a9ad8);_0x34e855=_0xc9c491-_0x258d61*_0x2a9ad8;for(const _0x2c1b58 of $gameParty[_0x5eeece(0xf5)]()){const _0x2d6714=$gameParty[_0x5eeece(0xf5)]()['indexOf'](_0x2c1b58),_0x527c66=_0x3acf0f+_0x34e855+_0x2d6714*_0x258d61;this[_0x5eeece(0xe0)](_0x2c1b58[_0x5eeece(0x2c3)](this['_item'])),this[_0x5eeece(0x2d3)](_0x2c1b58,_0x527c66+_0x258d61/0x2,_0x1bb651);let _0x65a35c=_0x1bb651;for(const _0x894ea6 of _0x3c26c6){const _0x570331=_0x65a35c-(_0x3e5009-_0x2fa126)/0x2;this[_0x5eeece(0x32d)](_0x2c1b58,_0x894ea6,_0x527c66,_0x570331,_0x258d61),_0x65a35c+=_0x2fa126;}}this['drawItemDarkRect'](_0x3acf0f,_0x1182f2,_0x34e855,_0x1bb651-_0x1182f2);for(let _0x2c4c69=0x0;_0x2c4c69<_0x2a9ad8;_0x2c4c69++){const _0x208a50=_0x3acf0f+_0x34e855+_0x2c4c69*_0x258d61;this[_0x5eeece(0xd7)](_0x208a50,_0x1182f2,_0x258d61,_0x1bb651-_0x1182f2);}for(const _0x16be5c of _0x3c26c6){this[_0x5eeece(0xd7)](_0x3acf0f,_0x1bb651,_0x34e855,_0x2fa126);for(let _0x2f03e0=0x0;_0x2f03e0<_0x2a9ad8;_0x2f03e0++){const _0x3e28dd=_0x3acf0f+_0x34e855+_0x2f03e0*_0x258d61;this[_0x5eeece(0xd7)](_0x3e28dd,_0x1bb651,_0x258d61,_0x2fa126);}_0x1bb651+=_0x2fa126;}},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x3a9)]=function(_0x54ec88,_0x5720db,_0x20a797){const _0x6df991=_0x77d410;if(!this[_0x6df991(0x3f6)]())return![];const _0x50305d=$dataSystem[_0x6df991(0x3f0)][this[_0x6df991(0x6c)][_0x6df991(0x44a)]];return this['drawItemKeyData'](_0x50305d,_0x54ec88,_0x5720db,_0x20a797,!![]),this[_0x6df991(0xd7)](_0x54ec88,_0x5720db,_0x20a797),this[_0x6df991(0x157)](),!![];},Window_ShopStatus['prototype'][_0x77d410(0xff)]=function(){const _0x5b0700=_0x77d410,_0x1440d5=VisuMZ[_0x5b0700(0x1e8)]['Settings'][_0x5b0700(0x3cc)][_0x5b0700(0x2a3)];return _0x1440d5[_0x5b0700(0x290)]($gameParty[_0x5b0700(0x342)](this[_0x5b0700(0x6c)]));},Window_ShopStatus['prototype'][_0x77d410(0xf2)]=function(){const _0x31c242=_0x77d410;let _0x5eca3a=[0x0,0x1,0x2,0x3,0x4,0x5,0x6,0x7];return Imported[_0x31c242(0x257)]&&(_0x5eca3a=VisuMZ[_0x31c242(0x146)][_0x31c242(0x96)][_0x31c242(0x26c)][_0x31c242(0x282)]),_0x5eca3a=_0x5eca3a[_0x31c242(0x199)](_0xd281f5=>typeof _0xd281f5===_0x31c242(0x277)?_0xd281f5:_0xd281f5['toUpperCase']()[_0x31c242(0x72)]()),_0x5eca3a;},Window_ShopStatus['prototype']['smallParamFontSize']=function(){const _0x3e6b2b=_0x77d410;return VisuMZ['ItemsEquipsCore']['Settings']['StatusWindow'][_0x3e6b2b(0x1f6)];},Window_ShopStatus['prototype']['drawParamName']=function(_0x458f04,_0x484fd0,_0xc4fce6,_0x1108f3){const _0x40a33b=_0x77d410;this[_0x40a33b(0x157)](),this[_0x40a33b(0x40d)][_0x40a33b(0x43d)]=this[_0x40a33b(0x242)]();let _0x44f99e=this[_0x40a33b(0x8b)](TextManager[_0x40a33b(0xb8)](_0x458f04))+0x4+_0x484fd0;return Imported[_0x40a33b(0x257)]?(this[_0x40a33b(0xd3)](_0x484fd0,_0xc4fce6,_0x1108f3,_0x458f04,!![]),VisuMZ[_0x40a33b(0x146)][_0x40a33b(0x96)][_0x40a33b(0x26c)][_0x40a33b(0x103)]&&(_0x44f99e+=ImageManager[_0x40a33b(0x18f)]+0x4)):(this[_0x40a33b(0x1f3)](ColorManager[_0x40a33b(0xdf)]()),this[_0x40a33b(0x315)](TextManager[_0x40a33b(0xb8)](_0x458f04),_0x484fd0,_0xc4fce6,_0x1108f3)),this[_0x40a33b(0x157)](),_0x44f99e;},Window_ShopStatus['prototype'][_0x77d410(0x32d)]=function(_0x533662,_0x281e69,_0x59cf6d,_0xe79501,_0x26badb){const _0x3278b7=_0x77d410;_0x59cf6d+=this[_0x3278b7(0x355)](),_0x26badb-=this['itemPadding']()*0x2;const _0x286f7e=VisuMZ[_0x3278b7(0x1e8)]['Settings'][_0x3278b7(0x166)];this['contents'][_0x3278b7(0x43d)]=_0x286f7e[_0x3278b7(0x1f6)],this[_0x3278b7(0xe0)](_0x533662[_0x3278b7(0x2c3)](this[_0x3278b7(0x6c)]));if(_0x533662['isEquipped'](this[_0x3278b7(0x6c)])&&!_0x533662[_0x3278b7(0x3ef)](this[_0x3278b7(0x6c)])){const _0x70b3f6=_0x286f7e[_0x3278b7(0x2a7)];this['drawText'](_0x70b3f6,_0x59cf6d,_0xe79501,_0x26badb,_0x3278b7(0x1bb));}else{if(_0x533662[_0x3278b7(0x2c3)](this[_0x3278b7(0x6c)])){const _0x71af24=this[_0x3278b7(0x3b0)](_0x533662);let _0x4581d7=0x0,_0x2148f7=0x0,_0x5835f6=0x0;Imported['VisuMZ_0_CoreEngine']?(_0x4581d7=_0x71af24[_0x3278b7(0x21b)](_0x281e69),_0x2148f7=_0x4581d7-_0x533662[_0x3278b7(0x21b)](_0x281e69),this['changeTextColor'](ColorManager[_0x3278b7(0x1b7)](_0x2148f7)),_0x5835f6=(_0x2148f7>=0x0?'+':'')+VisuMZ[_0x3278b7(0xf7)](_0x2148f7,0x0,_0x281e69)):(_0x4581d7=_0x71af24[_0x3278b7(0xb8)](_0x281e69),_0x2148f7=_0x4581d7-_0x533662[_0x3278b7(0xb8)](_0x281e69),this[_0x3278b7(0x1f3)](ColorManager['paramchangeTextColor'](_0x2148f7)),_0x5835f6=(_0x2148f7>=0x0?'+':'')+_0x2148f7),_0x5835f6==='+0'&&(_0x5835f6=_0x286f7e[_0x3278b7(0x24f)]),this[_0x3278b7(0x315)](_0x5835f6,_0x59cf6d,_0xe79501,_0x26badb,_0x3278b7(0x1bb));}else{const _0x330fe5=_0x286f7e[_0x3278b7(0x24b)];this['drawText'](_0x330fe5,_0x59cf6d,_0xe79501,_0x26badb,_0x3278b7(0x1bb));}}this[_0x3278b7(0x157)](),this[_0x3278b7(0xe0)](!![]);},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x3b0)]=function(_0xbf7039){const _0x1153d8=_0x77d410;if(this['needsNewTempActor'](_0xbf7039)){const _0x2bb215=JsonEx['makeDeepCopy'](_0xbf7039);_0x2bb215['_tempActor']=!![];const _0x5a9858=_0x2bb215[_0x1153d8(0x13c)](this['_item']);_0x5a9858>=0x0&&_0x2bb215['forceChangeEquip'](_0x5a9858,this[_0x1153d8(0x6c)]),this[_0x1153d8(0x3fe)]=_0x2bb215;}return this[_0x1153d8(0x3fe)];},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x90)]=function(_0x5b7c7c){const _0x1d01a0=_0x77d410;if(!this[_0x1d01a0(0x3fe)])return!![];return this[_0x1d01a0(0x3fe)]['actorId']()!==_0x5b7c7c['actorId']();},Game_Actor[_0x77d410(0xc6)][_0x77d410(0x3ef)]=function(_0x4de37b){const _0x427055=_0x77d410;if(!_0x4de37b)return![];const _0x4a7c93=_0x4de37b[_0x427055(0x44a)],_0x1a17cb=this[_0x427055(0x30d)]();for(let _0xdc3a84=0x0;_0xdc3a84<_0x1a17cb['length'];_0xdc3a84++){const _0x2d1e4f=_0x1a17cb[_0xdc3a84];if(_0x2d1e4f!==_0x4a7c93)continue;if(!this[_0x427055(0x3ac)]()[_0xdc3a84])return!![];}return![];},Game_Actor[_0x77d410(0xc6)][_0x77d410(0x13c)]=function(_0x2479a5){const _0x28f903=_0x77d410;if(!_0x2479a5)return-0x1;const _0x2d457d=_0x2479a5[_0x28f903(0x44a)],_0x40f82b=this[_0x28f903(0x30d)]();let _0x21fb26=-0x1;for(let _0x1865cb=0x0;_0x1865cb<_0x40f82b[_0x28f903(0xcc)];_0x1865cb++){const _0x4faafb=_0x40f82b[_0x1865cb];if(_0x4faafb!==_0x2d457d)continue;if(!this['equips']()[_0x1865cb])return _0x1865cb;if(_0x21fb26<0x0)_0x21fb26=_0x1865cb;}return _0x21fb26;},Window_ShopStatus[_0x77d410(0xc6)]['drawItemData']=function(){const _0x393282=_0x77d410;VisuMZ[_0x393282(0x1e8)]['Settings'][_0x393282(0x166)][_0x393282(0x231)][_0x393282(0x200)](this);},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x183)]=function(_0x2b8b4c,_0x247298,_0x5ba50e,_0x4a0cd1){const _0x487213=_0x77d410,_0x3c97cf=DataManager['isSkill'](_0x2b8b4c,_0x247298,_0x5ba50e,_0x4a0cd1)&&Imported[_0x487213(0x120)],_0x46e400=_0x2b8b4c?_0x2b8b4c[_0x487213(0x123)]:'';if(_0x3c97cf)Window_SkillList['prototype']['alterSkillName'][_0x487213(0x200)](this,_0x2b8b4c);Window_Base[_0x487213(0xc6)][_0x487213(0x183)][_0x487213(0x200)](this,_0x2b8b4c,_0x247298,_0x5ba50e,_0x4a0cd1);if(_0x3c97cf)_0x2b8b4c[_0x487213(0x123)]=_0x46e400;},Window_ShopStatus[_0x77d410(0xc6)]['prepareItemCustomData']=function(){const _0x103d8a=_0x77d410;this['_customItemInfo']={};if(!this['_item'])return;const _0x565711=this[_0x103d8a(0x6c)][_0x103d8a(0x272)];if(_0x565711[_0x103d8a(0x336)](/<STATUS INFO>\s*([\s\S]*)\s*<\/STATUS INFO>/i)){const _0xe38f4e=String(RegExp['$1'])['split'](/[\r\n]+/);for(const _0x4d289d of _0xe38f4e){if(_0x4d289d[_0x103d8a(0x336)](/(.*):[ ](.*)/i)){const _0xc1e949=String(RegExp['$1'])[_0x103d8a(0x143)]()['trim'](),_0x42a7a8=String(RegExp['$2'])[_0x103d8a(0x72)]();this[_0x103d8a(0x1b3)][_0xc1e949]=_0x42a7a8;}}}},Window_ShopStatus['prototype'][_0x77d410(0x223)]=function(){const _0x239e5e=_0x77d410;return Math[_0x239e5e(0x17f)](0x1,$gameSystem[_0x239e5e(0x1f1)]()-0x4);},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x157)]=function(){const _0x1c740d=_0x77d410;Window_StatusBase[_0x1c740d(0xc6)]['resetFontSettings'][_0x1c740d(0x200)](this),this[_0x1c740d(0x40d)]['fontSize']=this[_0x1c740d(0x191)]||this[_0x1c740d(0x40d)][_0x1c740d(0x43d)],this[_0x1c740d(0x40d)][_0x1c740d(0x462)]=this['_resetFontColor']||this[_0x1c740d(0x40d)][_0x1c740d(0x462)];},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x1a6)]=function(){const _0x4b536b=_0x77d410;return this[_0x4b536b(0x40d)][_0x4b536b(0x43d)]/$gameSystem[_0x4b536b(0x1f1)]();},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x398)]=function(_0x3a0922,_0x15179e,_0x3fa560){const _0x4ff326=_0x77d410,_0x5df3a9=ImageManager[_0x4ff326(0x2c7)](_0x4ff326(0x7d)),_0x1c4a82=ImageManager[_0x4ff326(0x18f)],_0x1c7658=ImageManager[_0x4ff326(0xe6)],_0x255da5=_0x3a0922%0x10*_0x1c4a82,_0x3cf7b8=Math['floor'](_0x3a0922/0x10)*_0x1c7658,_0x960de6=Math[_0x4ff326(0x186)](_0x1c4a82*this[_0x4ff326(0x1a6)]()),_0x2100c1=Math[_0x4ff326(0x186)](_0x1c7658*this[_0x4ff326(0x1a6)]());this[_0x4ff326(0x40d)][_0x4ff326(0x1ec)](_0x5df3a9,_0x255da5,_0x3cf7b8,_0x1c4a82,_0x1c7658,_0x15179e,_0x3fa560,_0x960de6,_0x2100c1);},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x2e6)]=function(_0x300f7f,_0x124d2a){const _0x2aa5f1=_0x77d410;_0x124d2a[_0x2aa5f1(0x440)]&&this['drawIcon'](_0x300f7f,_0x124d2a['x'],_0x124d2a['y']+0x2);_0x124d2a['x']+=Math[_0x2aa5f1(0x186)](ImageManager['iconWidth']*this[_0x2aa5f1(0x1a6)]());if(this[_0x2aa5f1(0x1a6)]()===0x1)_0x124d2a['x']+=0x4;},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x308)]=function(_0x37011f,_0x55cc0f,_0x52b027,_0x47109f,_0xe6c337,_0x117c43){const _0x4493d7=_0x77d410;_0x37011f=_0x37011f||'',_0x117c43=_0x117c43||_0x4493d7(0x12d),this[_0x4493d7(0x191)]=this[_0x4493d7(0x223)](),this[_0x4493d7(0x2ae)]=_0xe6c337?ColorManager[_0x4493d7(0xdf)]():this[_0x4493d7(0x40d)][_0x4493d7(0x462)],_0x55cc0f+=this['itemPadding'](),_0x47109f-=this[_0x4493d7(0x355)]()*0x2;const _0xefb232=this[_0x4493d7(0x401)](_0x37011f);if(_0x117c43===_0x4493d7(0x1bb))_0x55cc0f=_0x55cc0f+Math[_0x4493d7(0xc9)]((_0x47109f-_0xefb232[_0x4493d7(0x28e)])/0x2);else _0x117c43===_0x4493d7(0x1d4)&&(_0x55cc0f=_0x55cc0f+_0x47109f-_0xefb232[_0x4493d7(0x28e)]);_0x52b027+=(this[_0x4493d7(0x1e2)]()-_0xefb232[_0x4493d7(0x2b5)])/0x2,this['drawTextEx'](_0x37011f,_0x55cc0f,_0x52b027,_0x47109f),this['_resetFontSize']=undefined,this['_resetFontColor']=undefined,this[_0x4493d7(0x157)]();},Window_ShopStatus['prototype'][_0x77d410(0x14f)]=function(_0x5f7138,_0x1d255e,_0x51c9e8){const _0x50b714=_0x77d410;if(!DataManager[_0x50b714(0x19e)](this[_0x50b714(0x6c)]))return![];const _0x56f6aa=this[_0x50b714(0xb5)]();this[_0x50b714(0x308)](_0x56f6aa,_0x5f7138,_0x1d255e,_0x51c9e8,!![]);const _0x2bf823=this[_0x50b714(0x232)]();return this[_0x50b714(0x308)](_0x2bf823,_0x5f7138,_0x1d255e,_0x51c9e8,![],_0x50b714(0x1d4)),this[_0x50b714(0xd7)](_0x5f7138,_0x1d255e,_0x51c9e8),this[_0x50b714(0x157)](),!![];},Window_ShopStatus[_0x77d410(0xc6)]['getItemConsumableLabel']=function(){const _0x42ef97=_0x77d410;return VisuMZ['ItemsEquipsCore'][_0x42ef97(0x96)][_0x42ef97(0x166)][_0x42ef97(0x155)];},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x232)]=function(){const _0x1cc7a2=_0x77d410,_0x40a0e8=_0x1cc7a2(0x343);if(this[_0x1cc7a2(0x1b3)][_0x40a0e8])return this[_0x1cc7a2(0x1b3)][_0x40a0e8];return this['canConsumeItem']()?VisuMZ['ItemsEquipsCore'][_0x1cc7a2(0x96)]['StatusWindow']['Consumable']:VisuMZ[_0x1cc7a2(0x1e8)][_0x1cc7a2(0x96)][_0x1cc7a2(0x166)][_0x1cc7a2(0x1a3)];},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x83)]=function(){const _0xd1f182=_0x77d410;return VisuMZ[_0xd1f182(0x146)]&&VisuMZ[_0xd1f182(0x146)][_0xd1f182(0x96)][_0xd1f182(0x132)]['KeyItemProtect']&&DataManager['isKeyItem'](this[_0xd1f182(0x6c)])?![]:this[_0xd1f182(0x6c)][_0xd1f182(0x1df)];},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x1ca)]=function(_0x58c4ba,_0x4dafcf,_0x5e631c){const _0x79c32=_0x77d410;if(!this[_0x79c32(0x3f6)]()&&!DataManager[_0x79c32(0x19e)](this[_0x79c32(0x6c)]))return![];if(DataManager[_0x79c32(0x100)](this[_0x79c32(0x6c)])&&!$dataSystem['optKeyItemsNumber']){const _0x45935a=TextManager[_0x79c32(0x87)];this['drawItemKeyData'](_0x45935a,_0x58c4ba,_0x4dafcf,_0x5e631c,!![],_0x79c32(0x1bb));}else{const _0x5db61e=TextManager[_0x79c32(0x314)];this[_0x79c32(0x308)](_0x5db61e,_0x58c4ba,_0x4dafcf,_0x5e631c,!![]);const _0x39edeb=this[_0x79c32(0xff)]();this[_0x79c32(0x308)](_0x39edeb,_0x58c4ba,_0x4dafcf,_0x5e631c,![],_0x79c32(0x1d4));}return this[_0x79c32(0xd7)](_0x58c4ba,_0x4dafcf,_0x5e631c),this[_0x79c32(0x157)](),!![];},Window_ShopStatus['prototype'][_0x77d410(0xff)]=function(){const _0x57634a=_0x77d410,_0x31bf85=_0x57634a(0x25f);if(this[_0x57634a(0x1b3)][_0x31bf85])return this[_0x57634a(0x1b3)][_0x31bf85];const _0x1f5452=VisuMZ[_0x57634a(0x1e8)][_0x57634a(0x96)][_0x57634a(0x3cc)]['ItemQuantityFmt'];return _0x1f5452[_0x57634a(0x290)]($gameParty[_0x57634a(0x342)](this[_0x57634a(0x6c)]));},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x3e7)]=function(_0x3e91cd,_0x4e59e7,_0x56891e){const _0x413309=_0x77d410,_0x2928a1=this[_0x413309(0x218)]();return this[_0x413309(0x308)](_0x2928a1,_0x3e91cd,_0x4e59e7,_0x56891e,![],_0x413309(0x1bb)),this['drawItemDarkRect'](_0x3e91cd,_0x4e59e7,_0x56891e),this[_0x413309(0x157)](),!![];},Window_ShopStatus['prototype'][_0x77d410(0x218)]=function(){const _0x41ab35=_0x77d410,_0x703cda=_0x41ab35(0x128);if(this['_customItemInfo'][_0x703cda])return this[_0x41ab35(0x1b3)][_0x703cda];const _0xe3fe1d=VisuMZ[_0x41ab35(0x1e8)][_0x41ab35(0x96)][_0x41ab35(0x166)],_0x2b9479=_0x41ab35(0x22d)[_0x41ab35(0x290)](this[_0x41ab35(0x6c)][_0x41ab35(0x3fb)]);return _0xe3fe1d[_0x2b9479];},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x2a2)]=function(_0x4f9937,_0x1add40,_0x1a87db){const _0x32836b=_0x77d410,_0x3a7bcb=this[_0x32836b(0x3da)]();return this['drawItemKeyData'](_0x3a7bcb,_0x4f9937,_0x1add40,_0x1a87db,![],'center'),this['drawItemDarkRect'](_0x4f9937,_0x1add40,_0x1a87db),this[_0x32836b(0x157)](),!![];},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x3da)]=function(){const _0xbb7692=_0x77d410,_0x2eeeac=_0xbb7692(0xcd);if(this[_0xbb7692(0x1b3)][_0x2eeeac])return this[_0xbb7692(0x1b3)][_0x2eeeac];const _0x49db5f=VisuMZ[_0xbb7692(0x1e8)][_0xbb7692(0x96)]['StatusWindow'];if(Imported[_0xbb7692(0x168)]){const _0x13fe01=this[_0xbb7692(0x6c)][_0xbb7692(0x272)];if(_0x13fe01['match'](/<TARGET:[ ](.*)>/i)){const _0x554acd=String(RegExp['$1']);if(_0x554acd[_0xbb7692(0x336)](/(\d+) RANDOM ANY/i))return _0x49db5f[_0xbb7692(0x35a)][_0xbb7692(0x290)](Number(RegExp['$1']));else{if(_0x554acd['match'](/(\d+) RANDOM (?:ENEMY|ENEMIES|FOE|FOES)/i))return _0x49db5f['ScopeRandomEnemies'][_0xbb7692(0x290)](Number(RegExp['$1']));else{if(_0x554acd[_0xbb7692(0x336)](/(\d+) RANDOM (?:ALLY|ALLIES|FRIEND|FRIENDS)/i))return _0x49db5f[_0xbb7692(0xc0)][_0xbb7692(0x290)](Number(RegExp['$1']));else{if(_0x554acd['match'](/ALL (?:ALLY|ALLIES|FRIEND|FRIENDS) (?:BUT|EXCEPT) (?:USER|SELF)/i))return _0x49db5f[_0xbb7692(0x8c)];else{if(_0x554acd[_0xbb7692(0x336)](/ALLY OR ENEMY/i))return _0x49db5f['ScopeAllyOrEnemy']||_0x49db5f['Scope7'];else{if(_0x554acd[_0xbb7692(0x336)](/ENEMY OR ALLY/i))return _0x49db5f[_0xbb7692(0x20a)]||_0x49db5f['Scope1'];}}}}}}}const _0x26aebb=_0xbb7692(0x6e)[_0xbb7692(0x290)](this[_0xbb7692(0x6c)]['scope']);return _0x49db5f[_0x26aebb];},Window_ShopStatus['prototype']['drawItemSpeed']=function(_0x578062,_0x1aba0f,_0x12ca6d){const _0x23866e=_0x77d410,_0x1a1939=this[_0x23866e(0x75)]();this[_0x23866e(0x308)](_0x1a1939,_0x578062,_0x1aba0f,_0x12ca6d,!![]);const _0x858240=this[_0x23866e(0x456)]();return this[_0x23866e(0x308)](_0x858240,_0x578062,_0x1aba0f,_0x12ca6d,![],_0x23866e(0x1d4)),this[_0x23866e(0xd7)](_0x578062,_0x1aba0f,_0x12ca6d),this[_0x23866e(0x157)](),!![];},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x75)]=function(){const _0x15a562=_0x77d410;return VisuMZ['ItemsEquipsCore'][_0x15a562(0x96)][_0x15a562(0x166)][_0x15a562(0x377)];},Window_ShopStatus[_0x77d410(0xc6)]['getItemSpeedText']=function(){const _0x5c16bc=_0x77d410,_0x4b01dc=_0x5c16bc(0x28b);if(this[_0x5c16bc(0x1b3)][_0x4b01dc])return this[_0x5c16bc(0x1b3)][_0x4b01dc];const _0x190399=this[_0x5c16bc(0x6c)][_0x5c16bc(0x3c7)];if(_0x190399>=0x7d0)return VisuMZ['ItemsEquipsCore']['Settings'][_0x5c16bc(0x166)][_0x5c16bc(0x111)];else{if(_0x190399>=0x3e8)return VisuMZ['ItemsEquipsCore'][_0x5c16bc(0x96)]['StatusWindow'][_0x5c16bc(0x9e)];else{if(_0x190399>0x0)return VisuMZ[_0x5c16bc(0x1e8)][_0x5c16bc(0x96)][_0x5c16bc(0x166)][_0x5c16bc(0x3d6)];else{if(_0x190399===0x0)return VisuMZ[_0x5c16bc(0x1e8)][_0x5c16bc(0x96)][_0x5c16bc(0x166)][_0x5c16bc(0xaa)];else{if(_0x190399>-0x3e8)return VisuMZ[_0x5c16bc(0x1e8)][_0x5c16bc(0x96)][_0x5c16bc(0x166)][_0x5c16bc(0x209)];else{if(_0x190399>-0x7d0)return VisuMZ[_0x5c16bc(0x1e8)]['Settings'][_0x5c16bc(0x166)]['SpeedNeg1999'];else return _0x190399<=-0x7d0?VisuMZ[_0x5c16bc(0x1e8)][_0x5c16bc(0x96)][_0x5c16bc(0x166)]['SpeedNeg2000']:_0x5c16bc(0x381);}}}}}},Window_ShopStatus['prototype'][_0x77d410(0x36d)]=function(_0x5e3557,_0x23d281,_0x3e4249){const _0x39ac9e=_0x77d410,_0x4ac502=this[_0x39ac9e(0x2c8)]();this[_0x39ac9e(0x308)](_0x4ac502,_0x5e3557,_0x23d281,_0x3e4249,!![]);const _0x150133=this[_0x39ac9e(0x306)]();return this[_0x39ac9e(0x308)](_0x150133,_0x5e3557,_0x23d281,_0x3e4249,![],_0x39ac9e(0x1d4)),this[_0x39ac9e(0xd7)](_0x5e3557,_0x23d281,_0x3e4249),this[_0x39ac9e(0x157)](),!![];},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x2c8)]=function(){const _0x482f50=_0x77d410;return VisuMZ['ItemsEquipsCore']['Settings']['StatusWindow'][_0x482f50(0x396)];},Window_ShopStatus['prototype'][_0x77d410(0x306)]=function(){const _0x267c69=_0x77d410,_0x4b7f8d=_0x267c69(0x154);if(this['_customItemInfo'][_0x4b7f8d])return this['_customItemInfo'][_0x4b7f8d];if(Imported['VisuMZ_1_BattleCore']){const _0x2fb544=this[_0x267c69(0x6c)][_0x267c69(0x272)];if(_0x2fb544['match'](/<ALWAYS HIT>/i))return'100%';else{if(_0x2fb544['match'](/<ALWAYS HIT RATE: (\d+)([%％])>/i))return _0x267c69(0xce)[_0x267c69(0x290)](Number(RegExp['$1']));}}return _0x267c69(0xce)[_0x267c69(0x290)](this[_0x267c69(0x6c)]['successRate']);},Window_ShopStatus[_0x77d410(0xc6)]['drawItemRepeats']=function(_0x784a2f,_0x4e6239,_0x4c63a0){const _0xa35ed3=_0x77d410,_0x5a517a=this[_0xa35ed3(0x3c1)]();this['drawItemKeyData'](_0x5a517a,_0x784a2f,_0x4e6239,_0x4c63a0,!![]);const _0x48d671=this[_0xa35ed3(0x31a)]();return this[_0xa35ed3(0x308)](_0x48d671,_0x784a2f,_0x4e6239,_0x4c63a0,![],'right'),this[_0xa35ed3(0xd7)](_0x784a2f,_0x4e6239,_0x4c63a0),this[_0xa35ed3(0x157)](),!![];},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x3c1)]=function(){const _0x29c93e=_0x77d410;return VisuMZ[_0x29c93e(0x1e8)][_0x29c93e(0x96)][_0x29c93e(0x166)]['LabelRepeats'];},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x31a)]=function(){const _0x25b7ca=_0x77d410,_0xa15342='REPEAT';if(this['_customItemInfo'][_0xa15342])return this[_0x25b7ca(0x1b3)][_0xa15342];const _0x293dfd=_0x25b7ca(0x384);return _0x293dfd[_0x25b7ca(0x290)](this[_0x25b7ca(0x6c)][_0x25b7ca(0x6d)]);},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x3f1)]=function(_0x371559,_0x33aba4,_0x2da230){const _0x469a92=_0x77d410,_0x1bb029=this[_0x469a92(0x238)]();this[_0x469a92(0x308)](_0x1bb029,_0x371559,_0x33aba4,_0x2da230,!![]);const _0x1f3222=this['getItemHitTypeText']();return this['drawItemKeyData'](_0x1f3222,_0x371559,_0x33aba4,_0x2da230,![],_0x469a92(0x1d4)),this[_0x469a92(0xd7)](_0x371559,_0x33aba4,_0x2da230),this[_0x469a92(0x157)](),!![];},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x238)]=function(){return VisuMZ['ItemsEquipsCore']['Settings']['StatusWindow']['LabelHitType'];},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x237)]=function(){const _0x672ce6=_0x77d410,_0x50456e=_0x672ce6(0x101);if(this['_customItemInfo'][_0x50456e])return this[_0x672ce6(0x1b3)][_0x50456e];const _0x5a0d79=VisuMZ[_0x672ce6(0x1e8)][_0x672ce6(0x96)][_0x672ce6(0x166)],_0x581b7f=_0x672ce6(0x241)[_0x672ce6(0x290)](this['_item']['hitType']);return _0x5a0d79[_0x581b7f];},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x169)]=function(_0x2ac4be,_0x2eb0ab,_0x4fb539){const _0x116ff0=_0x77d410;if(this['_item'][_0x116ff0(0x14a)][_0x116ff0(0x32c)]<=0x0)return _0x2eb0ab;if(this['drawItemDamageElement'](_0x2ac4be,_0x2eb0ab,_0x4fb539))_0x2eb0ab+=this[_0x116ff0(0x1e2)]();if(this[_0x116ff0(0x439)](_0x2ac4be,_0x2eb0ab,_0x4fb539))_0x2eb0ab+=this['lineHeight']();return this[_0x116ff0(0x157)](),_0x2eb0ab;},Window_ShopStatus[_0x77d410(0xc6)]['drawItemDamageElement']=function(_0x435525,_0x1f48f6,_0x2923fe){const _0x42dc59=_0x77d410,_0x58e101=this[_0x42dc59(0x304)]();this[_0x42dc59(0x308)](_0x58e101,_0x435525,_0x1f48f6,_0x2923fe,!![]);const _0x4d79c4=this[_0x42dc59(0x2df)]();return this[_0x42dc59(0x308)](_0x4d79c4,_0x435525,_0x1f48f6,_0x2923fe,![],_0x42dc59(0x1d4)),this[_0x42dc59(0xd7)](_0x435525,_0x1f48f6,_0x2923fe),this['resetFontSettings'](),!![];},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x304)]=function(){const _0x4a606a=_0x77d410;return VisuMZ[_0x4a606a(0x1e8)][_0x4a606a(0x96)][_0x4a606a(0x166)][_0x4a606a(0x321)];},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x2df)]=function(){const _0x344504=_0x77d410,_0x3e26be=_0x344504(0x70);if(this[_0x344504(0x1b3)][_0x3e26be])return this[_0x344504(0x1b3)][_0x3e26be];if(this['_item'][_0x344504(0x14a)][_0x344504(0x33f)]<=-0x1)return VisuMZ[_0x344504(0x1e8)][_0x344504(0x96)][_0x344504(0x166)][_0x344504(0x333)];else return this[_0x344504(0x6c)][_0x344504(0x14a)][_0x344504(0x33f)]===0x0?VisuMZ[_0x344504(0x1e8)]['Settings'][_0x344504(0x166)]['ElementNone']:$dataSystem['elements'][this[_0x344504(0x6c)][_0x344504(0x14a)]['elementId']];},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x439)]=function(_0x504719,_0x5da311,_0x46f430){const _0x29b1c5=_0x77d410,_0x1526ac=this[_0x29b1c5(0x1dc)]();this[_0x29b1c5(0x308)](_0x1526ac,_0x504719,_0x5da311,_0x46f430,!![]),this[_0x29b1c5(0x16d)]();const _0x584a26=this['getItemDamageAmountText'](),_0x1d6787=ColorManager[_0x29b1c5(0x30c)]([0x0,0x0,0x2,0x1,0x3,0x1,0x3][this[_0x29b1c5(0x6c)][_0x29b1c5(0x14a)][_0x29b1c5(0x32c)]]);return this['changeTextColor'](_0x1d6787),this[_0x29b1c5(0x308)](_0x584a26,_0x504719,_0x5da311,_0x46f430,![],_0x29b1c5(0x1d4)),this[_0x29b1c5(0xd7)](_0x504719,_0x5da311,_0x46f430),this[_0x29b1c5(0x157)](),!![];},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x1dc)]=function(){const _0x11a5e8=_0x77d410;return Imported['VisuMZ_1_BattleCore']&&DataManager[_0x11a5e8(0x1af)](this[_0x11a5e8(0x6c)])!==_0x11a5e8(0x163)?this['getItemDamageAmountLabelBattleCore']():this['getItemDamageAmountLabelOriginal']();},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x340)]=function(){const _0x3a8634=_0x77d410,_0x386cfc=VisuMZ[_0x3a8634(0x1e8)][_0x3a8634(0x96)]['StatusWindow'],_0x3b029d='DamageType%1'[_0x3a8634(0x290)](this[_0x3a8634(0x6c)]['damage'][_0x3a8634(0x32c)]),_0x3eaa92=[null,TextManager['hp'],TextManager['mp'],TextManager['hp'],TextManager['mp'],TextManager['hp'],TextManager['mp']][this[_0x3a8634(0x6c)][_0x3a8634(0x14a)][_0x3a8634(0x32c)]];return _0x386cfc[_0x3b029d]['format'](_0x3eaa92);},Window_ShopStatus[_0x77d410(0xc6)]['setupItemDamageTempActors']=function(){const _0x191cd5=_0x77d410,_0x3d96d3=$gameActors['actor'](0x1);this[_0x191cd5(0x13f)]=JsonEx['makeDeepCopy'](_0x3d96d3),this[_0x191cd5(0x15a)]=JsonEx['makeDeepCopy'](_0x3d96d3);},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x19a)]=function(){const _0x5a7f32=_0x77d410,_0x2b04cd='DAMAGE\x20MULTIPLIER';if(this['_customItemInfo'][_0x2b04cd])return this[_0x5a7f32(0x1b3)][_0x2b04cd];return Imported[_0x5a7f32(0x168)]&&DataManager[_0x5a7f32(0x1af)](this[_0x5a7f32(0x6c)])!=='MANUAL'?this['getItemDamageAmountTextBattleCore']():this['getItemDamageAmountTextOriginal']();},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x3cd)]=function(){const _0x5d193c=_0x77d410;window['a']=this['_tempActorA'],window['b']=this[_0x5d193c(0x15a)],this[_0x5d193c(0x13f)][_0x5d193c(0x28a)](!![]),this[_0x5d193c(0x15a)][_0x5d193c(0x28a)]([0x3,0x4][_0x5d193c(0x26b)](this[_0x5d193c(0x6c)][_0x5d193c(0x14a)]['type']));let _0x9229a8=this[_0x5d193c(0x6c)]['damage'][_0x5d193c(0x3fa)];try{const _0x4d9daf=Math[_0x5d193c(0x17f)](eval(_0x9229a8),0x0)/window['a'][_0x5d193c(0xae)];return this[_0x5d193c(0x173)](),isNaN(_0x4d9daf)?_0x5d193c(0x381):_0x5d193c(0xce)['format'](Math[_0x5d193c(0x317)](_0x4d9daf*0x64));}catch(_0x3340b5){return $gameTemp[_0x5d193c(0x3ea)]()&&(console[_0x5d193c(0x2ec)](_0x5d193c(0xa3)[_0x5d193c(0x290)](this[_0x5d193c(0x6c)][_0x5d193c(0x123)])),console[_0x5d193c(0x2ec)](_0x3340b5)),this[_0x5d193c(0x173)](),_0x5d193c(0x381);}},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x173)]=function(){window['a']=undefined,window['b']=undefined;},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x91)]=function(_0x28db77,_0x3c74bf,_0x5585a7){const _0x201ce9=_0x77d410;if(!this[_0x201ce9(0x7c)]())return _0x3c74bf;if(this[_0x201ce9(0x1d2)](_0x28db77,_0x3c74bf,_0x5585a7))_0x3c74bf+=this[_0x201ce9(0x1e2)]();if(this[_0x201ce9(0x330)](_0x28db77,_0x3c74bf,_0x5585a7))_0x3c74bf+=this[_0x201ce9(0x1e2)]();if(this[_0x201ce9(0x152)](_0x28db77,_0x3c74bf,_0x5585a7))_0x3c74bf+=this[_0x201ce9(0x1e2)]();if(this[_0x201ce9(0x352)](_0x28db77,_0x3c74bf,_0x5585a7))_0x3c74bf+=this[_0x201ce9(0x1e2)]();if(this[_0x201ce9(0x227)](_0x28db77,_0x3c74bf,_0x5585a7))_0x3c74bf+=this[_0x201ce9(0x1e2)]();if(this[_0x201ce9(0x34b)](_0x28db77,_0x3c74bf,_0x5585a7))_0x3c74bf+=this['lineHeight']();if(this[_0x201ce9(0x1f9)](_0x28db77,_0x3c74bf,_0x5585a7))_0x3c74bf+=this[_0x201ce9(0x1e2)]();if(this[_0x201ce9(0x31d)](_0x28db77,_0x3c74bf,_0x5585a7))_0x3c74bf+=this[_0x201ce9(0x1e2)]();if(this[_0x201ce9(0x3a4)](_0x28db77,_0x3c74bf,_0x5585a7))_0x3c74bf+=this[_0x201ce9(0x1e2)]();return this[_0x201ce9(0x157)](),_0x3c74bf;},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x22c)]=function(){const _0x17aafa=_0x77d410;return this[_0x17aafa(0x6c)][_0x17aafa(0x40f)];},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x7c)]=function(){const _0x41aaa2=_0x77d410;let _0x363228=![];this[_0x41aaa2(0x12e)]={'rateHP':0x0,'flatHP':0x0,'rateMP':0x0,'flatMP':0x0,'gainTP':0x0,'selfTP':0x0,'addState':[],'removeState':[],'changeBuff':[0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0],'removeBuff':[],'removeDebuff':[],'addStateBuffChanges':![],'removeStateBuffChanges':![]};const _0x3b3168=this[_0x41aaa2(0x22c)]();for(const _0x4dff02 of _0x3b3168){switch(_0x4dff02[_0x41aaa2(0x35c)]){case Game_Action[_0x41aaa2(0x411)]:this[_0x41aaa2(0x12e)][_0x41aaa2(0x3dd)]+=_0x4dff02[_0x41aaa2(0x421)],this[_0x41aaa2(0x12e)][_0x41aaa2(0x447)]+=_0x4dff02[_0x41aaa2(0x1de)],_0x363228=!![];break;case Game_Action[_0x41aaa2(0x20c)]:this[_0x41aaa2(0x12e)][_0x41aaa2(0x14b)]+=_0x4dff02[_0x41aaa2(0x421)],this[_0x41aaa2(0x12e)][_0x41aaa2(0x36c)]+=_0x4dff02[_0x41aaa2(0x1de)],_0x363228=!![];break;case Game_Action['EFFECT_GAIN_TP']:this[_0x41aaa2(0x12e)][_0x41aaa2(0x3fc)]+=_0x4dff02['value1'],_0x363228=!![];break;case Game_Action[_0x41aaa2(0x93)]:this['_itemData'][_0x41aaa2(0x26e)][_0x41aaa2(0x31f)](_0x4dff02[_0x41aaa2(0x2ba)]),_0x363228=!![];break;case Game_Action[_0x41aaa2(0xba)]:this[_0x41aaa2(0x12e)][_0x41aaa2(0x224)][_0x41aaa2(0x31f)](_0x4dff02['dataId']),this[_0x41aaa2(0x12e)][_0x41aaa2(0x9b)]=!![],_0x363228=!![];break;case Game_Action[_0x41aaa2(0x388)]:this['_itemData']['changeBuff'][_0x4dff02['dataId']]+=0x1,_0x363228=!![];break;case Game_Action[_0x41aaa2(0x385)]:this[_0x41aaa2(0x12e)][_0x41aaa2(0x1f8)][_0x4dff02['dataId']]-=0x1,_0x363228=!![];break;case Game_Action[_0x41aaa2(0x2be)]:this[_0x41aaa2(0x12e)][_0x41aaa2(0x3c6)]['push'](_0x4dff02[_0x41aaa2(0x2ba)]),this['_itemData'][_0x41aaa2(0x9b)]=!![],_0x363228=!![];break;case Game_Action['EFFECT_REMOVE_DEBUFF']:this[_0x41aaa2(0x12e)]['removeDebuff'][_0x41aaa2(0x31f)](_0x4dff02[_0x41aaa2(0x2ba)]),this[_0x41aaa2(0x12e)]['removeStateBuffChanges']=!![],_0x363228=!![];break;}}if(this['_itemData'][_0x41aaa2(0x26e)][_0x41aaa2(0xcc)]>0x0)this['_itemData'][_0x41aaa2(0x2ee)]=!![];for(let _0x1754d5=0x0;_0x1754d5<this['_itemData']['changeBuff'][_0x41aaa2(0xcc)];_0x1754d5++){if(this[_0x41aaa2(0x12e)][_0x41aaa2(0x1f8)][_0x1754d5]!==0x0)this[_0x41aaa2(0x12e)][_0x41aaa2(0x2ee)]=!![];}this[_0x41aaa2(0x6c)]['tpGain']!==0x0&&(this['_itemData'][_0x41aaa2(0x34d)]=this[_0x41aaa2(0x6c)][_0x41aaa2(0x108)],_0x363228=!![]);const _0x917510=[_0x41aaa2(0x428),_0x41aaa2(0x2c2),'TP\x20RECOVERY',_0x41aaa2(0xe5),'MP\x20DAMAGE',_0x41aaa2(0x27d),'USER\x20TP\x20GAIN',_0x41aaa2(0x318),_0x41aaa2(0x1d6)];for(const _0x1fb097 of _0x917510){if(this[_0x41aaa2(0x1b3)][_0x1fb097]){_0x363228=!![];break;}}return _0x363228;},Window_ShopStatus[_0x77d410(0xc6)]['drawItemEffectsHpRecovery']=function(_0xb6f43,_0x5c7d6d,_0x263852){const _0x49c29d=_0x77d410,_0x1bb168=_0x49c29d(0x428);if(this[_0x49c29d(0x12e)][_0x49c29d(0x3dd)]<=0x0&&this[_0x49c29d(0x12e)][_0x49c29d(0x447)]<=0x0&&!this[_0x49c29d(0x1b3)][_0x1bb168])return![];const _0x17a5aa=this[_0x49c29d(0x3b8)]();this[_0x49c29d(0x308)](_0x17a5aa,_0xb6f43,_0x5c7d6d,_0x263852,!![]);const _0x2e924f=this[_0x49c29d(0x3f3)]();return this[_0x49c29d(0x1f3)](ColorManager[_0x49c29d(0x30c)](0x1)),this['drawItemKeyData'](_0x2e924f,_0xb6f43,_0x5c7d6d,_0x263852,![],_0x49c29d(0x1d4)),this[_0x49c29d(0xd7)](_0xb6f43,_0x5c7d6d,_0x263852),this['resetFontSettings'](),!![];},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x3b8)]=function(){const _0x1b9b8e=_0x77d410,_0xe49cb7=VisuMZ['ItemsEquipsCore']['Settings'][_0x1b9b8e(0x166)]['LabelRecoverHP'];return _0xe49cb7['format'](TextManager['hp']);},Window_ShopStatus['prototype'][_0x77d410(0x3f3)]=function(){const _0x32081f=_0x77d410,_0x3a9c2b=_0x32081f(0x428);if(this[_0x32081f(0x1b3)][_0x3a9c2b])return this[_0x32081f(0x1b3)][_0x3a9c2b];let _0x82dafa='';if(this[_0x32081f(0x12e)]['rateHP']>0x0)_0x82dafa+=_0x32081f(0x13e)['format'](Math[_0x32081f(0xc9)](this[_0x32081f(0x12e)][_0x32081f(0x3dd)]*0x64));if(this[_0x32081f(0x12e)][_0x32081f(0x3dd)]>0x0&&this[_0x32081f(0x12e)][_0x32081f(0x447)]>0x0)_0x82dafa+='\x20';if(this[_0x32081f(0x12e)][_0x32081f(0x447)]>0x0)_0x82dafa+=_0x32081f(0x457)[_0x32081f(0x290)](this[_0x32081f(0x12e)][_0x32081f(0x447)]);return _0x82dafa;},Window_ShopStatus['prototype'][_0x77d410(0x330)]=function(_0x433c22,_0x8af59d,_0x25aca3){const _0x4f7ee0=_0x77d410,_0x2cf2c6=_0x4f7ee0(0x2c2);if(this[_0x4f7ee0(0x12e)][_0x4f7ee0(0x14b)]<=0x0&&this[_0x4f7ee0(0x12e)][_0x4f7ee0(0x36c)]<=0x0&&!this['_customItemInfo'][_0x2cf2c6])return![];const _0x5479cf=this[_0x4f7ee0(0x1a1)]();this[_0x4f7ee0(0x308)](_0x5479cf,_0x433c22,_0x8af59d,_0x25aca3,!![]);const _0x430382=this['getItemEffectsMpRecoveryText']();return this[_0x4f7ee0(0x1f3)](ColorManager['damageColor'](0x3)),this[_0x4f7ee0(0x308)](_0x430382,_0x433c22,_0x8af59d,_0x25aca3,![],_0x4f7ee0(0x1d4)),this['drawItemDarkRect'](_0x433c22,_0x8af59d,_0x25aca3),this[_0x4f7ee0(0x157)](),!![];},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x1a1)]=function(){const _0x2ba879=_0x77d410,_0x3ac8b2=VisuMZ[_0x2ba879(0x1e8)]['Settings'][_0x2ba879(0x166)][_0x2ba879(0x119)];return _0x3ac8b2[_0x2ba879(0x290)](TextManager['mp']);},Window_ShopStatus['prototype'][_0x77d410(0x416)]=function(){const _0x12bedf=_0x77d410,_0x4c3b68=_0x12bedf(0x2c2);if(this[_0x12bedf(0x1b3)][_0x4c3b68])return this[_0x12bedf(0x1b3)][_0x4c3b68];let _0x249cce='';if(this[_0x12bedf(0x12e)][_0x12bedf(0x14b)]>0x0)_0x249cce+=_0x12bedf(0x13e)[_0x12bedf(0x290)](Math['floor'](this[_0x12bedf(0x12e)][_0x12bedf(0x14b)]*0x64));if(this[_0x12bedf(0x12e)]['rateMP']>0x0&&this['_itemData'][_0x12bedf(0x36c)]>0x0)_0x249cce+='\x20';if(this[_0x12bedf(0x12e)][_0x12bedf(0x36c)]>0x0)_0x249cce+=_0x12bedf(0x457)[_0x12bedf(0x290)](this['_itemData'][_0x12bedf(0x36c)]);return _0x249cce;},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x152)]=function(_0x15c003,_0x22926f,_0x59c7f0){const _0x455428=_0x77d410,_0x87c8c2=_0x455428(0x42c);if(this[_0x455428(0x12e)][_0x455428(0x3fc)]<=0x0&&!this[_0x455428(0x1b3)][_0x87c8c2])return![];const _0x2ee2a1=this[_0x455428(0x2dd)]();this[_0x455428(0x308)](_0x2ee2a1,_0x15c003,_0x22926f,_0x59c7f0,!![]);const _0x2c19fd=this[_0x455428(0x34f)]();return this[_0x455428(0x1f3)](ColorManager['powerUpColor']()),this['drawItemKeyData'](_0x2c19fd,_0x15c003,_0x22926f,_0x59c7f0,![],_0x455428(0x1d4)),this[_0x455428(0xd7)](_0x15c003,_0x22926f,_0x59c7f0),this[_0x455428(0x157)](),!![];},Window_ShopStatus['prototype'][_0x77d410(0x2dd)]=function(){const _0x360273=_0x77d410,_0x4e5e0e=VisuMZ[_0x360273(0x1e8)][_0x360273(0x96)][_0x360273(0x166)][_0x360273(0x2ea)];return _0x4e5e0e[_0x360273(0x290)](TextManager['tp']);},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x34f)]=function(){const _0x448242=_0x77d410,_0x4ded00=_0x448242(0x42c);if(this['_customItemInfo'][_0x4ded00])return this[_0x448242(0x1b3)][_0x4ded00];let _0x22ae1d='';return _0x22ae1d+=_0x448242(0x457)[_0x448242(0x290)](this['_itemData']['gainTP']),_0x22ae1d;},Window_ShopStatus[_0x77d410(0xc6)]['drawItemEffectsSelfTpGain']=function(_0x2408b1,_0x3dd7e2,_0xe1c06f){const _0x7724f3=_0x77d410,_0x3382a5='USER\x20TP\x20GAIN';if(this['_itemData'][_0x7724f3(0x34d)]===0x0&&!this[_0x7724f3(0x1b3)][_0x3382a5])return![];const _0x8aad6b=this[_0x7724f3(0x369)]();this[_0x7724f3(0x308)](_0x8aad6b,_0x2408b1,_0x3dd7e2,_0xe1c06f,!![]);const _0x4e221f=this[_0x7724f3(0x307)]();return this['_itemData']['selfTP']>0x0?this[_0x7724f3(0x1f3)](ColorManager['powerUpColor']()):this['changeTextColor'](ColorManager[_0x7724f3(0x73)]()),this[_0x7724f3(0x308)](_0x4e221f,_0x2408b1,_0x3dd7e2,_0xe1c06f,![],_0x7724f3(0x1d4)),this[_0x7724f3(0xd7)](_0x2408b1,_0x3dd7e2,_0xe1c06f),this['resetFontSettings'](),!![];},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x369)]=function(){const _0x18a601=_0x77d410,_0x4ae6d9=VisuMZ[_0x18a601(0x1e8)]['Settings'][_0x18a601(0x166)]['LabelSelfGainTP'];return _0x4ae6d9[_0x18a601(0x290)](TextManager['tp']);},Window_ShopStatus[_0x77d410(0xc6)]['getItemEffectsSelfTpGainText']=function(){const _0x10fc6a=_0x77d410,_0x517614='USER\x20TP\x20GAIN';if(this[_0x10fc6a(0x1b3)][_0x517614])return this[_0x10fc6a(0x1b3)][_0x517614];let _0x4dad40='';return this[_0x10fc6a(0x12e)]['selfTP']>0x0?_0x4dad40+='+%1'[_0x10fc6a(0x290)](this[_0x10fc6a(0x12e)][_0x10fc6a(0x34d)]):_0x4dad40+='%1'[_0x10fc6a(0x290)](this[_0x10fc6a(0x12e)][_0x10fc6a(0x34d)]),_0x4dad40;},Window_ShopStatus[_0x77d410(0xc6)]['drawItemEffectsHpDamage']=function(_0x563d85,_0x509ca9,_0x2134a5){const _0x52b436=_0x77d410,_0x68146a='HP\x20DAMAGE';if(this[_0x52b436(0x12e)]['rateHP']>=0x0&&this['_itemData'][_0x52b436(0x447)]>=0x0&&!this['_customItemInfo'][_0x68146a])return![];const _0x1eed46=this[_0x52b436(0x2f1)]();this[_0x52b436(0x308)](_0x1eed46,_0x563d85,_0x509ca9,_0x2134a5,!![]);const _0x2b7f90=this['getItemEffectsHpDamageText']();return this[_0x52b436(0x1f3)](ColorManager[_0x52b436(0x30c)](0x0)),this[_0x52b436(0x308)](_0x2b7f90,_0x563d85,_0x509ca9,_0x2134a5,![],_0x52b436(0x1d4)),this[_0x52b436(0xd7)](_0x563d85,_0x509ca9,_0x2134a5),this['resetFontSettings'](),!![];},Window_ShopStatus[_0x77d410(0xc6)]['getItemEffectsHpDamageLabel']=function(){const _0x491df0=_0x77d410,_0x173d97=VisuMZ['ItemsEquipsCore'][_0x491df0(0x96)]['StatusWindow'][_0x491df0(0x289)];return _0x173d97[_0x491df0(0x290)](TextManager['hp']);},Window_ShopStatus[_0x77d410(0xc6)]['getItemEffectsHpDamageText']=function(){const _0x2b094d=_0x77d410,_0x2fc27f=_0x2b094d(0xe5);if(this[_0x2b094d(0x1b3)][_0x2fc27f])return this[_0x2b094d(0x1b3)][_0x2fc27f];let _0x4d1669='';if(this[_0x2b094d(0x12e)]['rateHP']<0x0)_0x4d1669+='%1%'['format'](Math['floor'](this[_0x2b094d(0x12e)][_0x2b094d(0x3dd)]*0x64));if(this['_itemData'][_0x2b094d(0x3dd)]<0x0&&this[_0x2b094d(0x12e)][_0x2b094d(0x447)]<0x0)_0x4d1669+='\x20';if(this[_0x2b094d(0x12e)][_0x2b094d(0x447)]<0x0)_0x4d1669+='%1'[_0x2b094d(0x290)](this[_0x2b094d(0x12e)][_0x2b094d(0x447)]);return _0x4d1669;},Window_ShopStatus['prototype'][_0x77d410(0x227)]=function(_0x39c168,_0x42d89c,_0x1f65ec){const _0x55ea06=_0x77d410,_0x54012b=_0x55ea06(0x3ed);if(this[_0x55ea06(0x12e)][_0x55ea06(0x14b)]>=0x0&&this[_0x55ea06(0x12e)][_0x55ea06(0x36c)]>=0x0&&!this[_0x55ea06(0x1b3)][_0x54012b])return![];const _0x5130e5=this[_0x55ea06(0x429)]();this['drawItemKeyData'](_0x5130e5,_0x39c168,_0x42d89c,_0x1f65ec,!![]);const _0x4e1c8f=this['getItemEffectsMpDamageText']();return this[_0x55ea06(0x1f3)](ColorManager[_0x55ea06(0x30c)](0x2)),this['drawItemKeyData'](_0x4e1c8f,_0x39c168,_0x42d89c,_0x1f65ec,![],_0x55ea06(0x1d4)),this[_0x55ea06(0xd7)](_0x39c168,_0x42d89c,_0x1f65ec),this[_0x55ea06(0x157)](),!![];},Window_ShopStatus['prototype'][_0x77d410(0x429)]=function(){const _0x48e0c7=_0x77d410,_0x511b88=VisuMZ['ItemsEquipsCore'][_0x48e0c7(0x96)][_0x48e0c7(0x166)][_0x48e0c7(0x34e)];return _0x511b88[_0x48e0c7(0x290)](TextManager['mp']);},Window_ShopStatus['prototype']['getItemEffectsMpDamageText']=function(){const _0x28c10e=_0x77d410,_0xdce38c=_0x28c10e(0x3ed);if(this[_0x28c10e(0x1b3)][_0xdce38c])return this[_0x28c10e(0x1b3)][_0xdce38c];let _0x37be4f='';if(this[_0x28c10e(0x12e)]['rateMP']<0x0)_0x37be4f+=_0x28c10e(0xce)['format'](Math[_0x28c10e(0xc9)](this[_0x28c10e(0x12e)][_0x28c10e(0x14b)]*0x64));if(this[_0x28c10e(0x12e)]['rateMP']<0x0&&this[_0x28c10e(0x12e)][_0x28c10e(0x36c)]<0x0)_0x37be4f+='\x20';if(this[_0x28c10e(0x12e)]['flatMP']<0x0)_0x37be4f+='%1'['format'](this[_0x28c10e(0x12e)][_0x28c10e(0x36c)]);return _0x37be4f;},Window_ShopStatus['prototype'][_0x77d410(0x34b)]=function(_0x4bf40c,_0x4f4b28,_0x54f026){const _0x1c0742=_0x77d410,_0x2d608f=_0x1c0742(0x27d);if(this['_itemData'][_0x1c0742(0x3fc)]>=0x0&&!this[_0x1c0742(0x1b3)][_0x2d608f])return![];const _0x272b17=this[_0x1c0742(0x42d)]();this['drawItemKeyData'](_0x272b17,_0x4bf40c,_0x4f4b28,_0x54f026,!![]);const _0x2fd302=this['getItemEffectsTpDamageText']();return this[_0x1c0742(0x1f3)](ColorManager[_0x1c0742(0x73)]()),this[_0x1c0742(0x308)](_0x2fd302,_0x4bf40c,_0x4f4b28,_0x54f026,![],_0x1c0742(0x1d4)),this[_0x1c0742(0xd7)](_0x4bf40c,_0x4f4b28,_0x54f026),this['resetFontSettings'](),!![];},Window_ShopStatus[_0x77d410(0xc6)]['getItemEffectsTpDamageLabel']=function(){const _0x2fb7cb=_0x77d410,_0x57d405=VisuMZ[_0x2fb7cb(0x1e8)][_0x2fb7cb(0x96)][_0x2fb7cb(0x166)][_0x2fb7cb(0x2d0)];return _0x57d405['format'](TextManager['tp']);},Window_ShopStatus[_0x77d410(0xc6)]['getItemEffectsTpDamageText']=function(){const _0x3b239f=_0x77d410,_0x35d67c=_0x3b239f(0x27d);if(this[_0x3b239f(0x1b3)][_0x35d67c])return this[_0x3b239f(0x1b3)][_0x35d67c];let _0x299bd2='';return _0x299bd2+='%1'['format'](this['_itemData'][_0x3b239f(0x3fc)]),_0x299bd2;},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x31d)]=function(_0x49b0ee,_0x29584c,_0x1fa1d1){const _0x4613bd=_0x77d410,_0x10c917='ADDED\x20EFFECTS';if(!this[_0x4613bd(0x12e)]['addStateBuffChanges']&&!this[_0x4613bd(0x1b3)][_0x10c917])return![];const _0x2de5e4=this['getItemEffectsAddedStatesBuffsText']();if(_0x2de5e4[_0x4613bd(0xcc)]<=0x0)return![];const _0x5e4beb=this[_0x4613bd(0x3ae)]();return this[_0x4613bd(0x308)](_0x5e4beb,_0x49b0ee,_0x29584c,_0x1fa1d1,!![]),this[_0x4613bd(0x308)](_0x2de5e4,_0x49b0ee,_0x29584c,_0x1fa1d1,![],_0x4613bd(0x1d4)),this['drawItemDarkRect'](_0x49b0ee,_0x29584c,_0x1fa1d1),this['resetFontSettings'](),!![];},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x3ae)]=function(){const _0x1c6829=_0x77d410;return VisuMZ['ItemsEquipsCore'][_0x1c6829(0x96)]['StatusWindow'][_0x1c6829(0x3f4)];},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x19d)]=function(){const _0x3fc3ef=_0x77d410,_0x2f0d46=_0x3fc3ef(0x318);if(this['_customItemInfo'][_0x2f0d46])return this['_customItemInfo'][_0x2f0d46];let _0x2dab67='',_0x4ab6c0=0x0;const _0xbb6ac=0x8;for(const _0x1c5c41 of this[_0x3fc3ef(0x12e)]['addState']){const _0x86736b=$dataStates[_0x1c5c41];if(_0x86736b&&_0x86736b[_0x3fc3ef(0x214)]>0x0){_0x2dab67+=_0x3fc3ef(0xc1)['format'](_0x86736b[_0x3fc3ef(0x214)]),_0x4ab6c0++;if(_0x4ab6c0>=_0xbb6ac)return _0x2dab67;}}for(let _0x1e1d72=0x0;_0x1e1d72<this[_0x3fc3ef(0x12e)][_0x3fc3ef(0x1f8)][_0x3fc3ef(0xcc)];_0x1e1d72++){const _0x5459ca=this[_0x3fc3ef(0x12e)][_0x3fc3ef(0x1f8)][_0x1e1d72],_0x3e826d=Game_BattlerBase[_0x3fc3ef(0xc6)]['buffIconIndex'](_0x5459ca,_0x1e1d72);if(_0x3e826d>0x0){_0x2dab67+='\x5cI[%1]'['format'](_0x3e826d),_0x4ab6c0++;if(_0x4ab6c0>=_0xbb6ac)return _0x2dab67;}}return _0x2dab67;},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x3a4)]=function(_0x150c0c,_0x38e4e0,_0x1c7798){const _0x22481f=_0x77d410,_0x43f5db=_0x22481f(0x1d6);if(!this[_0x22481f(0x12e)][_0x22481f(0x9b)]&&!this[_0x22481f(0x1b3)][_0x43f5db])return![];const _0x24932b=this[_0x22481f(0x356)]();this['drawItemKeyData'](_0x24932b,_0x150c0c,_0x38e4e0,_0x1c7798,!![]);const _0x15fdc7=this[_0x22481f(0x3e4)]();return this[_0x22481f(0x308)](_0x15fdc7,_0x150c0c,_0x38e4e0,_0x1c7798,![],_0x22481f(0x1d4)),this['drawItemDarkRect'](_0x150c0c,_0x38e4e0,_0x1c7798),this[_0x22481f(0x157)](),!![];},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x356)]=function(){const _0x369d7=_0x77d410;return VisuMZ['ItemsEquipsCore'][_0x369d7(0x96)][_0x369d7(0x166)][_0x369d7(0x18d)];},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x3e4)]=function(){const _0x291b7c=_0x77d410,_0x305d3e=_0x291b7c(0x1d6);if(this[_0x291b7c(0x1b3)][_0x305d3e])return this[_0x291b7c(0x1b3)][_0x305d3e];let _0x2f21e3='',_0x235710=0x0;const _0x150194=VisuMZ['ItemsEquipsCore'][_0x291b7c(0x96)][_0x291b7c(0x166)]['MaxIcons'];for(const _0xc0b097 of this['_itemData']['removeState']){const _0x180602=$dataStates[_0xc0b097];if(_0x180602&&_0x180602[_0x291b7c(0x214)]>0x0){_0x2f21e3+=_0x291b7c(0xc1)[_0x291b7c(0x290)](_0x180602[_0x291b7c(0x214)]),_0x235710++;if(_0x235710>=_0x150194)return _0x2f21e3;}}for(let _0x30a563=0x0;_0x30a563<this[_0x291b7c(0x12e)][_0x291b7c(0x3c6)][_0x291b7c(0xcc)];_0x30a563++){const _0xeff8ad=this[_0x291b7c(0x12e)]['removeBuff'][_0x30a563],_0x1a0edf=Game_BattlerBase[_0x291b7c(0xc6)][_0x291b7c(0x79)](0x1,_0xeff8ad);if(_0x1a0edf>0x0){_0x2f21e3+=_0x291b7c(0xc1)['format'](_0x1a0edf),_0x235710++;if(_0x235710>=_0x150194)return _0x2f21e3;}}for(let _0x1e9c2c=0x0;_0x1e9c2c<this[_0x291b7c(0x12e)][_0x291b7c(0x2c0)][_0x291b7c(0xcc)];_0x1e9c2c++){const _0x718b5f=this[_0x291b7c(0x12e)][_0x291b7c(0x2c0)][_0x1e9c2c],_0x3493db=Game_BattlerBase[_0x291b7c(0xc6)][_0x291b7c(0x79)](-0x1,_0x718b5f);if(_0x3493db>0x0){_0x2f21e3+=_0x291b7c(0xc1)[_0x291b7c(0x290)](_0x3493db),_0x235710++;if(_0x235710>=_0x150194)return _0x2f21e3;}}return _0x2f21e3;},Window_ShopStatus[_0x77d410(0xc6)]['drawItemCustomEntries']=function(_0x1fd63e,_0xa434af,_0x3a7c12){const _0x1e6d50=_0x77d410;if(this[_0x1e6d50(0x6c)][_0x1e6d50(0x272)][_0x1e6d50(0x336)](/<CUSTOM STATUS INFO>\s*([\s\S]*)\s*<\/CUSTOM STATUS INFO>/i)){const _0x43d702=String(RegExp['$1'])[_0x1e6d50(0x21e)](/[\r\n]+/);for(const _0x433acd of _0x43d702){if(_0x433acd[_0x1e6d50(0x336)](/(.*):[ ](.*)/i)){const _0x144e1e=String(RegExp['$1'])[_0x1e6d50(0x72)](),_0x323932=String(RegExp['$2'])['trim']();this[_0x1e6d50(0x3d3)](_0x144e1e,_0x323932,_0x1fd63e,_0xa434af,_0x3a7c12),_0xa434af+=this[_0x1e6d50(0x1e2)]();}}}return this[_0x1e6d50(0x157)](),_0xa434af;},Window_ShopStatus[_0x77d410(0xc6)]['drawItemCustomEntryLine']=function(_0x4f74b0,_0xe28459,_0x2f0d31,_0x4e1b65,_0xf2459e){const _0x3f7f2f=_0x77d410;this[_0x3f7f2f(0x308)](_0x4f74b0,_0x2f0d31,_0x4e1b65,_0xf2459e,!![]),this[_0x3f7f2f(0x308)](_0xe28459,_0x2f0d31,_0x4e1b65,_0xf2459e,![],'right'),this[_0x3f7f2f(0xd7)](_0x2f0d31,_0x4e1b65,_0xf2459e),this[_0x3f7f2f(0x157)]();},Window_ShopStatus[_0x77d410(0xc6)]['drawCustomShopGraphic']=function(){const _0x22d9e9=_0x77d410;if(!this[_0x22d9e9(0x6c)])return;const _0x13e350=this[_0x22d9e9(0x6c)][_0x22d9e9(0x272)],_0x11f751=/<SHOP (?:PICTURE|IMAGE|PICTURE NAME|PICTURE FILENAME|IMAGE NAME|IMAGE FILENAME):[ ](.*)>/gi,_0xd81c7c=_0x13e350[_0x22d9e9(0x336)](_0x11f751);if(_0xd81c7c)for(const _0x14b01b of _0xd81c7c){_0x14b01b[_0x22d9e9(0x336)](_0x11f751);const _0x581c01=String(RegExp['$1'])['trim']()||'';if(_0x581c01==='')continue;const _0x116759=ImageManager[_0x22d9e9(0x18a)](_0x581c01);_0x116759[_0x22d9e9(0xca)](this['drawCustomShopGraphicLoad'][_0x22d9e9(0x1ac)](this,_0x116759,this[_0x22d9e9(0x6c)]));}},Window_ShopStatus[_0x77d410(0xc6)][_0x77d410(0x425)]=function(_0x115976,_0x4c144b){const _0x399944=_0x77d410;if(this[_0x399944(0x6c)]!==_0x4c144b)return;if(!_0x115976)return;if(_0x115976[_0x399944(0x28e)]<=0x0||_0x115976[_0x399944(0x2b5)]<=0x0)return;const _0x5db091=_0x4c144b['note'];let _0x4c18f0='background';_0x5db091[_0x399944(0x336)](/<SHOP (?:PICTURE|IMAGE) LAYER:[ ]FOREGROUND>/i)&&(_0x4c18f0='foreground');const _0x4aed90=_0x4c18f0===_0x399944(0x2d5)?this[_0x399944(0x291)]:this[_0x399944(0x40d)];let _0x2fb151=this[_0x399944(0x279)],_0x5beda1=this['innerHeight'];_0x5db091[_0x399944(0x336)](/<SHOP (?:PICTURE|IMAGE) MAX WIDTH:[ ](\d+)>/i)&&(_0x2fb151=Number(RegExp['$1']));_0x5db091['match'](/<SHOP (?:PICTURE|IMAGE) MAX HEIGHT:[ ](\d+)>/i)&&(_0x5beda1=Number(RegExp['$1']));_0x5db091['match'](/<SHOP (?:PICTURE|IMAGE) MAX DIMENSIONS:[ ](\d+),[ ]*(\d+)>/i)&&(_0x2fb151=Number(RegExp['$1']),_0x5beda1=Number(RegExp['$2']));const _0x3298fa=Math[_0x399944(0x347)](0x1,_0x2fb151/_0x115976[_0x399944(0x28e)],_0x5beda1/_0x115976[_0x399944(0x2b5)]);let _0x39895a=0x0,_0x5952f4=0x0,_0x56418f=Math['floor'](_0x115976[_0x399944(0x28e)]*_0x3298fa),_0x4e8faa=Math[_0x399944(0xc9)](_0x115976[_0x399944(0x2b5)]*_0x3298fa),_0x2d00be=_0x399944(0x1bb);_0x5db091[_0x399944(0x336)](/<SHOP (?:PICTURE|IMAGE) (?:ALIGN|ALIGNMENT):[ ](LEFT|CENTER|RIGHT)>/i)&&(_0x2d00be=String(RegExp['$1'])[_0x399944(0x38e)]()['trim']());if(_0x2d00be===_0x399944(0x12d))_0x39895a=0x0;else _0x2d00be===_0x399944(0x1bb)?_0x39895a=Math[_0x399944(0x317)]((this[_0x399944(0x279)]-_0x56418f)/0x2):_0x39895a=this[_0x399944(0x279)]-_0x56418f;let _0x1d5b55=_0x399944(0x2fa);_0x5db091[_0x399944(0x336)](/<SHOP (?:PICTURE|IMAGE) POSITION:[ ](TOP|MIDDLE|BOTTOM)>/i)&&(_0x1d5b55=String(RegExp['$1'])[_0x399944(0x38e)]()[_0x399944(0x72)]());if(_0x1d5b55===_0x399944(0x331))_0x5952f4=0x0;else _0x1d5b55===_0x399944(0x2fa)?_0x5952f4=Math[_0x399944(0x317)]((this['innerHeight']-_0x4e8faa)/0x2):_0x5952f4=this['innerHeight']-_0x4e8faa;_0x5db091[_0x399944(0x336)](/<SHOP (?:PICTURE|IMAGE) OFFSET X:[ ]([\+\-]\d+)>/i)&&(_0x39895a+=Number(RegExp['$1']));_0x5db091[_0x399944(0x336)](/<SHOP (?:PICTURE|IMAGE) OFFSET Y:[ ]([\+\-]\d+)>/i)&&(_0x5952f4+=Number(RegExp['$1']));_0x5db091[_0x399944(0x336)](/<SHOP (?:PICTURE|IMAGE) OFFSET:[ ]([\+\-]\d+),[ ]*([\+\-]\d+)>/i)&&(_0x39895a+=Number(RegExp['$1']),_0x5952f4+=Number(RegExp['$2']));let _0xbde469=0xff;if(_0x5db091[_0x399944(0x336)](/<SHOP (?:PICTURE|IMAGE) OPACITY:[ ](\d+)>/i))_0xbde469=Number(RegExp['$1']);else _0x5db091[_0x399944(0x336)](/<SHOP (?:PICTURE|IMAGE) OPACITY:[ ](\d+)([%％])>/i)&&(_0xbde469=Math['round'](Number(RegExp['$1'])*0.01*0xff)[_0x399944(0x45e)](0x0,0xff));_0x4aed90[_0x399944(0x3bc)]=_0xbde469,_0x4aed90[_0x399944(0x1ec)](_0x115976,0x0,0x0,_0x115976[_0x399944(0x28e)],_0x115976[_0x399944(0x2b5)],_0x39895a,_0x5952f4,_0x56418f,_0x4e8faa),_0x4aed90[_0x399944(0x3bc)]=0xff;},VisuMZ['ItemsEquipsCore'][_0x77d410(0x271)]=function(_0x138758){const _0x1317d6=_0x77d410;if(_0x138758===null||typeof _0x138758!==_0x1317d6(0xde))return _0x138758;const _0x271577=Array['isArray'](_0x138758)?[]:Object['create'](Object[_0x1317d6(0x339)](_0x138758));for(const _0x388e48 in _0x138758){Object[_0x1317d6(0xc6)][_0x1317d6(0x1b1)][_0x1317d6(0x200)](_0x138758,_0x388e48)&&(_0x271577[_0x388e48]=typeof _0x138758[_0x388e48]===_0x1317d6(0xde)&&_0x138758[_0x388e48]!==null?VisuMZ[_0x1317d6(0x1e8)][_0x1317d6(0x271)](_0x138758[_0x388e48]):_0x138758[_0x388e48]);}return _0x271577;};function _0x3470(){const _0x56aebc=['Scene_Shop_onSellOk','_categoryWindow','EFFECT_REMOVE_BUFF','isClearCommandEnabled','removeDebuff','186716TMsHws','MP\x20RECOVERY','canEquip','deactivate','Window_EquipStatus_refresh','Parse_Notetags_Sorting','loadSystem','getItemSuccessRateLabel','ActorChangeEquipSlots','pageup','drawTextEx','categoryStyle','createSellWindow','colSpacing','uiInputPosition','LabelDamageTP','optimizeEquipments','meetsEquipRequirement','drawActorCharacter','isRightInputMode','background','Game_Actor_isEquipChangeOk','purifyCursedEquips','isBottomHelpMode','categoryWindowRectItemsEquipsCore','mdf','DrawEquipData','NUM','getItemEffectsTpRecoveryLabel','onSellOk','getItemDamageElementText','initNewItemsList','addItemCategories','List','EnableLayout','ARRAYFUNC','helpAreaTop','processDrawIcon','isLearnedSkill','params','isCursedItem','LabelRecoverTP','setupBattleTestItems','log','shift','addStateBuffChanges','SwitchSell','ATK','getItemEffectsHpDamageLabel','_helpWindow','armor-%1','artifactIDs','SetupArtifactItemIDs','consumeItem','Scene_Boot_onDatabaseLoaded','Step1Start','prepareNewEquipSlotsOnLoad','middle','%1\x20is\x20incorrectly\x20placed\x20on\x20the\x20plugin\x20list.\x0aIt\x20is\x20a\x20Tier\x20%2\x20plugin\x20placed\x20over\x20other\x20Tier\x20%3\x20plugins.\x0aPlease\x20reorder\x20the\x20plugin\x20list\x20from\x20smallest\x20to\x20largest\x20tier\x20numbers.','pagedown','addCommand','text','helpDescriptionText','addShopTrackingItemSell','filter','Nonconsumable','categoryList','getItemDamageElementLabel','equipSlotIndex','getItemSuccessRateText','getItemEffectsSelfTpGainText','drawItemKeyData','_buyWindow','isUseItemsEquipsCoreUpdatedLayout','Game_Party_initialize','damageColor','equipSlots','onBuyOk','isShiftShortcutKeyForRemove','commandEquip','replace','New','getShopTrackingGoldBuy','possession','drawText','AllItems','round','ADDED\x20EFFECTS','troopArtifacts','getItemRepeatsText','Scene_Equip_onSlotOk','mainAreaTop','drawItemEffectsAddedStatesBuffs','CmdTextAlign','push','drawItemData','LabelElement','activate','mpRate','_getEquipRequirements','createSlotWindow','postCreateSellWindowItemsEquipsCore','_armorIDs','\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20let\x20enabled\x20=\x20true;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20user\x20=\x20this;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20target\x20=\x20this;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20a\x20=\x20this;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20b\x20=\x20this;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20try\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20%1\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x20catch\x20(e)\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20($gameTemp.isPlaytest())\x20console.log(e);\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20return\x20enabled;\x0a\x20\x20\x20\x20\x20\x20\x20\x20','processDownCursorSpecialCheckModernControls','shouldCommandWindowExist','setText','type','drawActorParamDifference','optimize','Scene_Shop_commandBuy','drawItemEffectsMpRecovery','top','Step1End','ElementWeapon','goodsToItem','initialize','match','commandSell','refreshCursor','getPrototypeOf','addWindow','pop','uiMenuStyle','\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20let\x20MaxHP\x20=\x200;\x20let\x20MaxMP\x20=\x200;\x20let\x20ATK\x20=\x200;\x20let\x20DEF\x20=\x200;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20let\x20MAT\x20=\x200;\x20let\x20MDF\x20=\x200;\x20let\x20AGI\x20=\x200;\x20let\x20LUK\x20=\x200;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20user\x20=\x20this;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20target\x20=\x20this;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20a\x20=\x20this;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20b\x20=\x20this;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20try\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20%1\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x20catch\x20(e)\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20($gameTemp.isPlaytest())\x20console.log(e);\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20return\x20[MaxHP,\x20MaxMP,\x20ATK,\x20DEF,\x20MAT,\x20MDF,\x20AGI,\x20LUK][paramId];\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20','EVAL','elementId','getItemDamageAmountLabelOriginal','%1\x27s\x20version\x20does\x20not\x20match\x20plugin\x27s.\x20Please\x20update\x20it\x20in\x20the\x20Plugin\x20Manager.','numItems','CONSUMABLE','createStatusWindow','drawEquipData','Scene_Equip_statusWindowRect','min','Slots','FieldUsable','every','drawItemEffectsTpDamage','drawItemCost','selfTP','LabelDamageMP','getItemEffectsTpRecoveryText','MultiplierStandard','isTriggered','drawItemEffectsHpDamage','processCursorMoveModernControls','SellTurnSwitchOn','itemPadding','getItemEffectsRemovedStatesBuffsLabel','itemTextAlign','ParseClassNotetags','opacity','ScopeRandomAny','Game_BattlerBase_canEquip_artifact','code','postCreateCategoryWindowItemsEquipsCore','_newLabelOpacityUpperLimit','optKeyItemsNumber','checkShiftRemoveShortcut','buyWindowRectItemsEquipsCore','ShopScene','OffsetY','Window_ShopSell_isEnabled','updatedLayoutStyle','setMp','buttonAssistKey3','isTroopArtifact','getItemEffectsSelfTpGainLabel','price','hideNewLabelSprites','flatMP','drawItemSuccessRate','itypeId','equip','convertInitEquipsToItems','clearNewItem','gaugeLineHeight','updateSmoothScroll','Scene_Item_helpWindowRect','gainItem','Scene_Shop_onBuyCancel','LabelSpeed','item-%1','50AEsBMk','calcWindowHeight','helpWindowRect','createNewLabelSprite','onCategoryCancel','getPurifyTransformation','_itemIDs','ActorResetEquipSlots','?????','ARRAYJSON','helpDesc','×%1','EFFECT_ADD_DEBUFF','Scene_Equip_createSlotWindow','_bypassNewLabel','EFFECT_ADD_BUFF','localeCompare','onTouchSelectModernControls','HiddenItemA','hide','PurifyActors','toLowerCase','BuyPriceJS','_equips','statusWindowRectItemsEquipsCore','Parse_Notetags_EnableJS','remove','LayoutStyle','Game_Item_setObject','LabelSuccessRate','_commandWindow','drawIcon','ARRAYSTRUCT','(%1)','processCursorMove','drawUpdatedParamName','Scene_Equip','Game_BattlerBase_meetsItemConditions','onSlotOkAutoSelect','buyingPrice','drawItemStyleIconText','Scene_Shop_buyWindowRect','sellWindowRectItemsEquipsCore','drawItemEffectsRemovedStatesBuffs','_etypeIDs','Scene_Load_reloadMapIfUpdated','version','Equip\x20the\x20strongest\x20available\x20equipment.','drawItemEquipType','isHoverEnabled','categoryItemTypes','equips','traitObjects','getItemEffectsAddedStatesBuffsLabel','tradeItemWithParty','createTempActorEquips','ParseItemNotetags','partyArtifacts','setCategory','#%1','value','DrawParamJS','commandWindowRect','getItemEffectsHpRecoveryLabel','Scene_Shop_commandWindowRect','onBuyCancel','processShiftRemoveShortcut','paintOpacity','categoryNameWindowDrawBackground','currentSymbol','create','postCreateSlotWindowItemsEquipsCore','getItemRepeatsLabel','onSellCancel','createCategoryWindow','isClearCommandAdded','smoothScrollTo','removeBuff','speed','getShopTrackingItem','addShopTrackingGoldBuy','Blacklist','drawRemoveItem','ItemScene','getItemDamageAmountTextOriginal','itemAt','windowPadding','_shopStatusMenuMode','EquipAdjustHpMp','mainAreaHeight','drawItemCustomEntryLine','createCommandNameWindow','description','Speed1','MaxArmors','isEquipWtypeOk','artifacts','getItemScopeText','statusWindowRect','fontFace','rateHP','Game_BattlerBase_paramPlus_artifact','isOptimizeEquipOk','def','setHandler','down','checkItemConditionsSwitchNotetags','getItemEffectsRemovedStatesBuffsText','DEF','ITEMS_EQUIPS_CORE','drawItemOccasion','W%1','getArmorIdWithName','isPlaytest','DrawBackRect','Scene_Shop_createSellWindow','MP\x20DAMAGE','_category','anyEmptyEquipSlotsOfSameEtype','equipTypes','drawItemHitType','initNewLabelSprites','getItemEffectsHpRecoveryText','LabelApply','commandStyleCheck','isEquipItem','paramPlusItemsEquipsCoreCustomJS','MaxHP','isOptimizeCommandAdded','formula','occasion','gainTP','_shopTrackingData','_tempActor','_sellWindow','status','textSizeEx','Scene_Equip_create','move','Scene_Battle','isCursorMovable','Scene_Shop_sellingPrice','getEtypeIDsCache','SetupProxyItemGroups','sort','sortPriority','Game_Party_gainItem_artifact','CursedTextPopup','contents','(+%1)','effects','addItemCategory','EFFECT_RECOVER_HP','_allowArtifactParamBase','changeEquip','Enable','numberWindowRectItemsEquipsCore','getItemEffectsMpRecoveryText','Game_Party_consumeItem','index','isDrawItemNumber','setTopRow','baseSellingPrice','_scrollDuration','Parse_Notetags_Category','Game_Party_gainItem','getClassRequirements','resetShopSwitches','value1','buttonAssistKey1','_numberWindow','loadFaceImages','drawCustomShopGraphicLoad','Icon','isBattleTest','HP\x20RECOVERY','getItemEffectsMpDamageLabel','Parse_Notetags_EquipSlots','Scene_Item_createItemWindow','TP\x20RECOVERY','getItemEffectsTpDamageLabel','_newLabelOpacityChange','return\x200','getItemColor','addEquipCommand','callUpdateHelp','getEquipRequirements','mainCommandWidth','MaxMP','HideAnySwitches','splice','armors','drawItemDamageAmount','setItemWindow','isPageChangeRequested','currencyUnit','fontSize','buttonAssistItemListRequirement','_weaponIDs','drawing','getSkillIdWithName','fill','parse','drawItemActorMenuImage','_classIDs','commandStyle','flatHP','Window_ItemList_updateHelp','Window_ItemList_drawItem','etypeId','Pick\x20and\x20choose\x20equipment\x20to\x20change.','_cache_etypeIDs','Parse_Notetags_Prices','Game_Actor_paramPlus','meetsItemConditions','drawCurrencyValue','bestEquipItem','_skillIDs','canUse','paramBase','1842276wIQrvT','getItemSpeedText','+%1','setHelpWindow','Window_ShopBuy_price','Step2End','getShopTrackingItemSell','_forcedSlots','VisuMZ_1_MainMenuCore','clamp','Parse_Notetags_ParamValues','isUseModernControls','SwitchBuy','textColor','icon','select','helpWindowRectItemsEquipsCore','createBitmap','calcEquipItemPerformance','_list','onBuyItem','_buyWindowLastIndex','releaseUnequippableItems','exit','updateCategoryNameWindow','versionId','AllArmors','_item','repeats','Scope%1','some','ELEMENT','commandNameWindowDrawBackground','trim','powerDownColor','commandNameWindowDrawText','getItemSpeedLabel','MAT','HiddenItemB','_newLabelSprites','buffIconIndex','_bypassReleaseUnequippableItemsItemsEquipsCore','Text','makeItemData','IconSet','processShopCondListingOnSellItem','process_VisuMZ_ItemsEquipsCore_EquipSlots','atypeId','isArmor','getMenuImage','canConsumeItem','refreshActorEquipSlotsIfUpdated','smoothSelect','EQUIP_DELAY_MS','keyItem','normalColor','forceChangeEquipSlots','ParseWeaponNotetags','textWidth','ScopeAlliesButUser','constructor','A%1','Parse_Notetags_Batch','needsNewTempActor','drawItemEffects','onActorChange','EFFECT_ADD_STATE','buy','Scene_Shop_create','Settings','Scene_Shop_doBuy','Game_Enemy_traitObjects_artifact','iconText','uiHelpPosition','removeStateBuffChanges','isShowNew','activateItemWindow','Speed1000','buttonAssistSmallIncrement','Window_Selectable_refresh','buttonAssistOffset3','CmdIconClear','Damage\x20Formula\x20Error\x20for\x20%1','RemoveEquipText','Scene_Equip_createCommandWindow','_money','buttonAssistText1','JSON','getShopTrackingGoldSell','Speed0','2vgJOcW','_calculatingJSParameters','ItemQuantityFontSize','atk','visible','gold','CommandAddOptimize','BattleUsable','helpAreaHeight','Scene_ItemBase_activateItemWindow','getItemConsumableLabel','onCategoryCancelItemsEquipsCore','Width','param','_allowArtifactTraitObjects','EFFECT_REMOVE_STATE','registerCommand','Scene_Shop_helpWindowRect','indexOf','paramValueFontSize','_commandNameWindow','ScopeRandomAllies','\x5cI[%1]','playCursorSound','cursorPageup','addShopTrackingItem','_purchaseOnly','prototype','forceResetEquipSlots','drawItemStyleIcon','floor','addLoadListener','onTouchOk','length','SCOPE','%1%','NAME','Scene_Equip_onActorChange','paramPlus','canEquipArmor','drawParamText','process_VisuMZ_ItemsEquipsCore_Notetags','adjustItemWidthByStatus','removeBattleTestArtifacts','drawItemDarkRect','Scene_Item','%1-%2','makeItemList','isSoleArmorType','Scene_Shop_goldWindowRect','getClassIdWithName','object','systemColor','changePaintOpacity','sortListItemScene','Step2Start','isOptimizeCommandEnabled','isPartyArtifact','HP\x20DAMAGE','iconHeight','BuyTurnSwitchOn','Style','Scene_Item_categoryWindowRect','Scene_Equip_onSlotCancel','armor','determineBaseSellingPrice','categoryStyleCheck','initShopTrackingData','updateCommandNameWindow','commandSellItemsEquipsCore','hideDisabledCommands','actorParams','doBuy','commandBuy','battleMembers','_slotWindow','ConvertNumberToString','Scene_Shop_onCategoryCancel','Game_BattlerBase_param','getItemsEquipsCoreBackColor1','getEtypeIDs','Scene_Shop_onBuyOk','Window_ShopBuy_refresh','prepareRefreshItemsEquipsCoreLayout','getItemQuantityText','isKeyItem','HIT\x20TYPE','BackRectColor','DrawIcons','playBuzzerSound','playOkSound','VisuMZ_2_WeaponSwapSystem','maxCols','tpGain','FontFace','isSellCommandEnabled','EquipDelayMS','MaxItems','update','sell','PurifyParty','switchProxyItem','Speed2000','Window_ShopBuy_item','IncludeShopItem','ARMOR','isPurifyItemSwapOk','Step3End','processCursorHomeEndTrigger','WEAPON','LabelRecoverMP','Translucent','fillRect','Scene_Shop_numberWindowRect','addCancelCommand','ShopMenuStatusStandard','buttonAssistSlotWindowShift','VisuMZ_1_SkillsStatesCore','commandBuyItemsEquipsCore','SortByIDandPriority','name','getTextColor','hitIndex','drawUpdatedAfterParamValue','makeCommandList','OCCASION','\x5cb%1\x5cb','_scene','random','hpRate','left','_itemData','isPressed','isOpenAndActive','drawPossession','QoL','mainFontFace','addShopTrackingGoldSell','setHp','updateMoneyAmount','Window_Selectable_initialize','_newLabelOpacity','isHandled','refreshDelay','process_VisuMZ_ItemsEquipsCore_RegExp','getEmptyEquipSlotOfSameEtype','processTouchModernControls','+%1%','_tempActorA','isShiftRemoveShortcutEnabled','equipCmdDesc','commandWindowRectItemsEquipsCore','toUpperCase','cancel','_paramPlus','CoreEngine','setHelpWindowItem','Window_EquipItem_includes','Game_Party_numItems','damage','rateMP','members','sellingPrice','commandNameWindowCenter','drawItemConsumable','FontColor','_statusWindow','drawItemEffectsTpRecovery','Window_ItemList_item','SUCCESS\x20RATE','LabelConsume','Scene_Shop_activateSellWindow','resetFontSettings','_goods','resetTextColor','_tempActorB','_newItemsList','_getClassRequirements','bitmap','TextAlign','mmp','ShopListingRegExp','maxBattleMembers','clear','MANUAL','STRUCT','isClicked','StatusWindow','commandName','VisuMZ_1_BattleCore','drawItemDamage','_actor','NonRemoveETypes','cursorDown','setupItemDamageTempActors','%1\x20is\x20missing\x20a\x20required\x20plugin.\x0aPlease\x20install\x20%2\x20into\x20the\x20Plugin\x20Manager.','popScene','postCreateItemsEquipsCore','parameters','isUseParamNamesWithIcons','revertGlobalNamespaceVariables','_buttonAssistWindow','boxWidth','EquipScene','numberWindowRect','LUK','943461OqcfIS','isSoleWeaponType','maxItems','_dummyWindow','inBattle','isOpen','max','isEquipAtypeOk','nonRemovableEtypes','getInputMultiButtonStrings','drawItemName','itemWindowRectItemsEquipsCore','drawItemNumber','ceil','Scene_Equip_helpWindowRect','buttonAssistText3','SetupProxyItemGroup','loadPicture','StatusWindowWidth','Scene_Item_itemWindowRect','LabelRemove','statusWidth','iconWidth','previousActor','_resetFontSize','itemWindowRect','buttonAssistCategory','createCategoryNameWindow','ParseAllNotetags','drawCustomShopGraphic','placeNewLabel','drawUpdatedParamValueDiff','map','getItemDamageAmountText','maxVisibleItems','cursorLeft','getItemEffectsAddedStatesBuffsText','isItem','troopArtifactIDs','buttonAssistKey2','getItemEffectsMpRecoveryLabel','addOptimizeCommand','NotConsumable','5993016GNUnno','isProxyItem','fontSizeRatio','Window_ItemCategory_initialize','adjustHiddenShownGoods','discardEquip','Window_EquipItem_isEnabled','setStatusWindow','bind','Scene_Shop_buyingPrice','4157395GLFBZX','getDamageStyle','_handlers','hasOwnProperty','onCategoryOk','_customItemInfo','CmdIconSell','Window_ItemCategory_setItemWindow','Scene_Shop_categoryWindowRect','paramchangeTextColor','getItemIdWithName','values','paramId','center','addChild','refreshItemsEquipsCoreNoMenuImage','_categoryNameWindow','ListWindowCols','allMembers','cursorUp','Window_ItemList_colSpacing','Whitelist','Type','meetsClassRequirements','buttonAssistLargeIncrement','categoryWindowRect','loadCharacter','partyArtifactIDs','drawItemQuantity','meetsItemConditionsNotetags','level','ItemMenuStatusBgType','onSellItem','NeverUsable','limitedPageUpDownSceneCheck','clearNewLabelFromItem','drawItemEffectsHpRecovery','Game_Actor_forceChangeEquip','right','Scene_Shop_statusWindowRect','REMOVED\x20EFFECTS','actor','cursorRight','Scene_Shop_createCategoryWindow','addClearCommand','isBuyCommandEnabled','getItemDamageAmountLabel','onDatabaseLoaded','value2','consumable','equipAdjustHpMp','ItemMenuStatusRect','lineHeight','itemLineRect','_slotId','Parse_Notetags_ParamJS','canShiftRemoveEquipment','sellPriceRate','ItemsEquipsCore','_data','auto','\x5cI[%1]%2','blt','isRepeated','goldWindowRect','isHovered','isEnabled','mainFontSize','refreshActor','changeTextColor','meetsEquipRequirements','addBuyCommand','ParamChangeFontSize','isDualWield','changeBuff','drawItemEffectsSelfTpGain','onTouchCancel','addSellCommand','onTouchSelectModern','Scene_Shop_commandSell','processShopCondListingOnBuyItem','DrawPortraitJS','call','wtypeId','RegExp','reloadMapIfUpdated','Window_Selectable_setHelpWindowItem','canSortListItemScene','createCommandWindow','hasItem','ItemSceneAdjustItemList','SpeedNeg999','ScopeEnemyOrAlly','weapon-%1','EFFECT_RECOVER_MP','CheckCursedItemMsg','_bypassProxy','CmdIconCancel','Scene_Equip_itemWindowRect','paramJS','slotWindowRect','setValue','iconIndex','ShiftShortcutKey','drawNewLabelText','prepare','getItemOccasionText','armorTypes','isEquipTypeSealed','paramValueByName','mainAreaBottom','Scene_Item_createCategoryWindow','split','itemHasEquipLimit','geUpdatedLayoutStatusWidth','CmdIconEquip','makeDeepCopy','itemDataFontSize','removeState','ShowAllSwitches','updateHelp','drawItemEffectsMpDamage','_checkEquipRequirements','OffsetX','isNewItem','goldWindowRectItemsEquipsCore','getItemEffects','Occasion%1','buyWindowRect','sellPriceOfItem','ARRAYNUM','DrawItemData','getItemConsumableText','drawParamsItemsEquipsCore','concat','innerHeight','getShopTrackingData','getItemHitTypeText','getItemHitTypeLabel','isGoodShown','14ySAMCX','Game_Party_setupBattleTestItems_artifact','getProxyItem','categoryNameWindowDrawText','BatchShop','test','onSlotCancel','HitType%1','smallParamFontSize','forceChangeEquip','getEtypeIdWithName','active','Scene_Shop_onSellCancel','onBuyCancelItemsEquipsCore','isClearEquipOk','mat','placeItemNewLabel','CannotEquipMarker','Game_Actor_tradeItemWithParty','isWeapon','createItemWindow','NoChangeMarker','setItem','_shopStatusMenuAlly','setNewItem','setItemDelay','user','Window_Selectable_update','maxItemAmount','VisuMZ_0_CoreEngine','Game_Actor_artifact','categories','allowCreateStatusWindow','meetsItemConditionsJS','Scene_Shop_doSell','Game_Actor_discardEquip','FadeSpeed','QUANTITY','Window_ItemList_makeItemList','Scene_Shop_sellWindowRect','_goodsCount','Step3Start','processCursorSpecialCheckModernControls','ConvertParams','money','Game_BattlerBase_param_artifact','show','scrollTo','getColor','includes','Param','RegularItems','addState','BorderRegExp','getItemsEquipsCoreBackColor2','deepCopy','note','<%1:[\x20]([\x5c+\x5c-]\x5cd+)>','369746MBSKrp','isArtifact','CmdStyle','number','changeEquipBase','innerWidth','isMainMenuCoreMenuImageOptionAvailable','weapon','getWeaponIdWithName','TP\x20DAMAGE','Scene_Equip_commandEquip','newLabelEnabled','0000','slotWindowRectItemsEquipsCore','ExtDisplayedParams','onSlotOk','items','defaultItemMax','ShowShopStatus','cursorPagedown','AlwaysUsable','LabelDamageHP','setShopStatusWindowMode','SPEED','_itemWindow','904995bCuXul','width','NonOptimizeETypes','format','contentsBack','AllWeapons','Window_ShopBuy_goodsToItem','getMatchingInitEquip','_doubleTouch','Categories','weaponTypes','item','addShopTrackingItemBuy','isEquipCommandEnabled','onTouchSelect','isStackableArtifact','ParseArmorNotetags','nonOptimizeEtypes','setObject','EquipParams','Scene_Item_create','drawItemScope','ItemQuantityFmt','proxyItem','deselect','SellPriceRate','AlreadyEquipMarker','prepareNextScene','drawItem','ARRAYEVAL','isEquipChangeOk','updateChangedSlots','Window_ItemList_maxCols','_resetFontColor','3pbdUla','activateSellWindow','refresh','===','Actors','drawUpdatedBeforeParamValue','height','PurchaseOnly','BuyTurnSwitchOff','buttonAssistText2','onMenuImageLoad','dataId','Scene_Shop_prepare'];_0x3470=function(){return _0x56aebc;};return _0x3470();}