//=============================================================================
// VisuStella MZ - Bestiary
// VisuMZ_2_Bestiary.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_2_Bestiary = true;

var VisuMZ = VisuMZ || {};
VisuMZ.Bestiary = VisuMZ.Bestiary || {};
VisuMZ.Bestiary.version = 1.01;

//=============================================================================
/* ----------------------------------------------------------------------------
 * Category List Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Category:
 *
 * @param Key:str
 * @text ID Key
 * @desc This category's identification key. Categories require
 * unique keys for the plugin to differentiate them.
 * @default (Needs Key)
 *
 * @param Title:str
 * @text Title
 * @desc This category's title.
 * You may use text codes.
 * @default Untitled
 * 
 */
/* ----------------------------------------------------------------------------
 * MainMenu Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~MainMenu:
 *
 * @param Name:str
 * @text Command Name
 * @parent Options
 * @desc Name of the 'Bestiary' option in the Main Menu.
 * @default Bestiary
 *
 * @param ShowMainMenu:eval
 * @text Show in Main Menu?
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Add the 'Bestiary' option to the Main Menu by default?
 * @default true
 *
 * @param EnableMainMenu:eval
 * @text Enable in Main Menu?
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Enable the 'Bestiary' option to the Main Menu by default?
 * @default true
 *
 */
/* ----------------------------------------------------------------------------
 * Background Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~BgSettings:
 *
 * @param SnapshotOpacity:num
 * @text Snapshop Opacity
 * @type number
 * @min 0
 * @max 255
 * @desc Snapshot opacity for the scene.
 * @default 192
 *
 * @param BgFilename1:str
 * @text Background 1
 * @type file
 * @dir img/titles1/
 * @require 1
 * @desc Filename used for the bottom background image.
 * Leave empty if you don't wish to use one.
 * @default 
 *
 * @param BgFilename2:str
 * @text Background 2
 * @type file
 * @dir img/titles2/
 * @require 1
 * @desc Filename used for the upper background image.
 * Leave empty if you don't wish to use one.
 * @default 
 *
 */
/* ----------------------------------------------------------------------------
 * Vocabulary Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Vocab:
 *
 * @param ButtonAssist
 * @text Button Assist Window
 *
 * @param buttonAssist_Collapse:str
 * @text Collapse
 * @parent ButtonAssist
 * @desc Text used to collapse a category.
 * Requires VisuMZ_0_CoreEngine!
 * @default Collapse
 *
 * @param buttonAssist_Expand:str
 * @text Expand
 * @parent ButtonAssist
 * @desc Text used to expand a category.
 * Requires VisuMZ_0_CoreEngine!
 * @default Expand
 *
 * @param buttonAssist_FastScroll:str
 * @text Scroll Fast
 * @parent ButtonAssist
 * @desc Text used to scroll enemy lore quickly.
 * Requires VisuMZ_0_CoreEngine!
 * @default Fast Scroll
 *
 * @param buttonAssist_SlowScroll:str
 * @text Scroll Slow
 * @parent ButtonAssist
 * @desc Text used to scroll enemy lore slowly.
 * Requires VisuMZ_0_CoreEngine!
 * @default Scroll
 *
 * @param buttonAssist_Switch:str
 * @text Switch Enemy
 * @parent ButtonAssist
 * @desc Text used to switch an enemy.
 * Requires VisuMZ_0_CoreEngine!
 * @default Switch Monster
 *
 * @param buttonAssist_View:str
 * @text View
 * @parent ButtonAssist
 * @desc Text used to view an enemy.
 * Requires VisuMZ_0_CoreEngine!
 * @default View
 *
 * @param MainWindows
 * @text Main Windows
 *
 * @param CategoryWindow
 * @text List Window
 * @parent MainWindows
 *
 * @param CategoryWindow_ClosedCategory:str
 * @text Category (Closed)
 * @parent CategoryWindow
 * @desc Text format used for closed categories.
 * %1 - Category Name, %2 - Percent Complete
 * @default + %1 (%2%)
 *
 * @param CategoryWindow_OpenCategory:str
 * @text Category (Opened)
 * @parent CategoryWindow
 * @desc Text format used for opened categories.
 * %1 - Category Name, %2 - Percent Complete
 * @default - %1 (%2%)
 *
 * @param CategoryPercentFixedDigits:num
 * @text Decimal Places
 * @parent CategoryWindow_OpenCategory:str
 * @type number
 * @desc Decimal places for completion percentages.
 * @default 2
 *
 * @param CategoryWindow_MaskChar:str
 * @text Mask Character
 * @parent CategoryWindow
 * @desc Text character used to mask unknown enemy names.
 * @default ?
 *
 * @param NameWindow
 * @text Name Window
 * @parent MainWindows
 *
 * @param NameWindow_CategoryText:str
 * @text Category Text
 * @parent NameWindow
 * @desc Text used when selecting an enemy.
 * @default Please select a monster to view.
 *
 * @param SubWindow
 * @text Sub Window
 * @parent MainWindows
 *
 * @param SubWindow_Completion:str
 * @text Completion Rate
 * @parent SubWindow
 * @desc Text used to announce completion rate.
 * %1 - Percentage, %2 - Defeated, %3 - Total
 * @default Bestiary Completion Rate: %1% (%2/%3 Monsters)
 *
 * @param SubWindowCompleteFixedDigits:num
 * @text Decimal Places
 * @parent SubWindow_Completion:str
 * @type number
 * @desc Decimal places for completion percentage.
 * @default 2
 *
 * @param SubWindow_Defeated:str
 * @text Defeated
 * @parent SubWindow
 * @desc Text used to announce defeated monsters.
 * %1 - Defeated Number
 * @default Defeated: %1
 *
 * @param SubWindow_Encountered:str
 * @text Encountered
 * @parent SubWindow
 * @desc Text used to announce encountered monsters.
 * %1 - Encountered Number
 * @default Encountered: %1
 *
 * @param DataWindows
 * @text Data Windows
 *
 * @param DataCategoryWindow
 * @text Category Window
 * @parent DataWindows
 *
 * @param BasicText:str
 * @text Basic Text
 * @parent DataCategoryWindow
 * @desc Text used for this command.
 * @default Base
 *
 * @param BasicIcon:str
 * @text Icon
 * @parent BasicText:str
 * @desc Icon used for this command.
 * @default 84
 *
 * @param ElementsText:str
 * @text Elements Text
 * @parent DataCategoryWindow
 * @desc Text used for this command.
 * @default Elements
 *
 * @param ElementsIcon:str
 * @text Icon
 * @parent ElementsText:str
 * @desc Icon used for this command.
 * @default 64
 *
 * @param SkillsText:str
 * @text Skills Text
 * @parent DataCategoryWindow
 * @desc Text used for this command.
 * @default Skills
 *
 * @param SkillsIcon:str
 * @text Icon
 * @parent SkillsText:str
 * @desc Icon used for this command.
 * @default 79
 *
 * @param RewardsText:str
 * @text Rewards Text
 * @parent DataCategoryWindow
 * @desc Text used for this command.
 * @default Rewards
 *
 * @param RewardsIcon:str
 * @text Icon
 * @parent RewardsText:str
 * @desc Icon used for this command.
 * @default 87
 *
 * @param TraitsText:str
 * @text Traits Text
 * @parent DataCategoryWindow
 * @desc Text used for this command.
 * @default Properties
 *
 * @param TraitsIcon:str
 * @text Icon
 * @parent TraitsText:str
 * @desc Icon used for this command.
 * @default 83
 *
 * @param LoreText:str
 * @text Lore Text
 * @parent DataCategoryWindow
 * @desc Text used for this command.
 * @default Lore
 *
 * @param LoreIcon:str
 * @text Icon
 * @parent LoreText:str
 * @desc Icon used for this command.
 * @default 80
 *
 * @param BasicWindow
 * @text Basic Window
 * @parent DataWindows
 *
 * @param BasicWindow_LevelUpToMax:str
 * @text Level Up To Max
 * @parent BasicWindow
 * @desc Text used for leveling to max. Text codes allowed.
 * Requires VisuMZ_3_EnemyLevels! %1 - Level Name
 * @default \I[73]Raise %1 Up to Maximum
 *
 * @param BasicWindow_LevelUpByOne:str
 * @text Level Up By One
 * @parent BasicWindow
 * @desc Text used for leveling by one. Text codes allowed.
 * Requires VisuMZ_3_EnemyLevels! %1 - Level Name
 * @default \I[73]Raise %1 Up
 *
 * @param BasicWindow_LevelDownByOne:str
 * @text Level Down By One
 * @parent BasicWindow
 * @desc Text used for deleveling by one. Text codes allowed.
 * Requires VisuMZ_3_EnemyLevels! %1 - Level Name
 * @default \I[74]Lower %1 Down
 *
 * @param BasicWindow_LevelDownToMin:str
 * @text Level Down To Min
 * @parent BasicWindow
 * @desc Text used for deleveling to min. Text codes allowed.
 * Requires VisuMZ_3_EnemyLevels! %1 - Level Name
 * @default \I[74]Lower %1 Down to Minimum
 *
 * @param ElementsWindow
 * @text Elements Window
 * @parent DataWindows
 *
 * @param ElementsWindow_Weak:str
 * @text Weak to Element
 * @parent ElementsWindow
 * @desc Text used when weak to element.
 * Text codes allowed.
 * @default \C[24]Weak
 *
 * @param ElementsWindow_Neutral:str
 * @text Neutral to Element
 * @parent ElementsWindow
 * @desc Text used when neutral to element.
 * Text codes allowed.
 * @default \C[0]Normal
 *
 * @param ElementsWindow_Resist:str
 * @text Resistant to Element
 * @parent ElementsWindow
 * @desc Text used when resistant to element.
 * Text codes allowed.
 * @default \C[25]Resist
 *
 * @param ElementsWindow_Immune:str
 * @text Immune to Element
 * @parent ElementsWindow
 * @desc Text used when immune to element.
 * Text codes allowed.
 * @default \C[7]Immune
 *
 * @param ElementsWindow_Absorb:str
 * @text Absorbs Element
 * @parent ElementsWindow
 * @desc Text used when absorbs element.
 * Text codes allowed.
 * @default \C[27]Absorb
 *
 * @param RewardsWindow
 * @text Rewards Window
 * @parent DataWindows
 *
 * @param RewardsWindow_Chance100:str
 * @text Drop Rate 100%
 * @parent RewardsWindow
 * @desc Text used for 100% drop rates.
 * Text codes allowed.
 * @default \C[24]Guaranteed
 *
 * @param RewardsWindow_Chance50:str
 * @text Drop Rate >= 50%
 * @parent RewardsWindow
 * @desc Text used for greater than 50% drop rates.
 * Text codes allowed.
 * @default \C[21]Common
 *
 * @param RewardsWindow_Chance20:str
 * @text Drop Rate >= 20%
 * @parent RewardsWindow
 * @desc Text used for greater than 20% drop rates.
 * Text codes allowed.
 * @default \C[4]Uncommon
 *
 * @param RewardsWindow_Chance10:str
 * @text Drop Rate >= 10%
 * @parent RewardsWindow
 * @desc Text used for greater than 10% drop rates.
 * Text codes allowed.
 * @default \C[5]Rare
 *
 * @param RewardsWindow_Chance0:str
 * @text Drop Rate < 10%
 * @parent RewardsWindow
 * @desc Text used for less than 10% drop rates.
 * Text codes allowed.
 * @default \C[27]Super Rare
 *
 * @param RewardsWindow_Conditional:str
 * @text Conditional Rate
 * @parent RewardsWindow
 * @desc Text used for conditional drop rates.
 * Requires VisuMZ_4_ExtraEnemyDrops! Text codes allowed.
 * @default \C[17]Conditional
 *
 * @param TraitsWindow
 * @text Traits Window
 * @parent DataWindows
 *
 * @param TraitsWindow_ClosedCategory:str
 * @text Category (Closed)
 * @parent TraitsWindow
 * @desc Text format used for closed categories.
 * Text codes allowed. %1 - Category Name
 * @default + \C[16]%1
 *
 * @param TraitsWindow_OpenCategory:str
 * @text Category (Opened)
 * @parent TraitsWindow
 * @desc Text format used for opened categories.
 * Text codes allowed. %1 - Category Name
 * @default - \C[16]%1
 *
 * @param TraitsWindow_CategoryHelpDesc:json
 * @text Help Description
 * @parent TraitsWindow_OpenCategory:str
 * @type note
 * @desc Help description used for trait categories.
 * Text codes allowed.
 * @default "This is the property type."
 *
 * @param TraitsWindow_NullHelpDesc:json
 * @text Null Help
 * @parent TraitsWindow
 * @type note
 * @desc Help description used for no traits.
 * Text codes allowed.
 * @default "This monster has no special properties."
 *
 * @param LoreWindow
 * @text Lore Window
 * @parent DataWindows
 *
 * @param LoreWindow_Default:json
 * @text Default Lore
 * @parent LoreWindow
 * @type note
 * @desc Text when no lore is found.
 * Text codes allowed.
 * @default "Little is known about this monster."
 *
 */
/* ----------------------------------------------------------------------------
 * Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Window:
 *
 * @param HelpWindow
 * @text Help Window
 *
 * @param HelpWindow_BgType:num
 * @text Background Type
 * @parent HelpWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param HelpWindow_ScaleRatio:eval
 * @text Scale Window
 * @parent HelpWindow
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Scale the help window to fit with the enemy preview window?
 * @default true
 *
 * @param HelpWindow_RectJS:func
 * @text JS: X, Y, W, H
 * @parent HelpWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const ww = Graphics.boxWidth;\nconst wh = this.calcWindowHeight(2, false);\nconst wx = this.imageWindowRect().x;\nconst wy = this.imageWindowRect().y;\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param MainWindows
 * @text Main Windows
 *
 * @param ImageWindow
 * @text Image Window
 * @parent MainWindows
 *
 * @param ImageWindow_BgType:num
 * @text Background Type
 * @parent ImageWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param ImageWindow_BlurStrength:num
 * @text Blur Strength
 * @parent ImageWindow
 * @type number
 * @desc What is the blur strength used for unknown enemies?
 * @default 8
 *
 * @param ImageWindow_Battleback1:str
 * @text Default Battleback 1
 * @parent ImageWindow
 * @type file
 * @dir img/battlebacks1/
 * @require 1
 * @desc Default battleback 1 image used for enemies
 * without <Bestiary Battleback 1: filename> notetag.
 * @default Grassland
 *
 * @param ImageWindow_Battleback2:str
 * @text Default Battleback 2
 * @parent ImageWindow
 * @type file
 * @dir img/battlebacks2/
 * @require 1
 * @desc Default battleback 2 image used for enemies
 * without <Bestiary Battleback 2: filename> notetag.
 * @default Grassland
 *
 * @param ImageWindow_Padding:num
 * @text Padding
 * @parent ImageWindow
 * @type number
 * @desc What is the padding value used for this window?
 * @default 4
 *
 * @param ImageWindow_RectJS:func
 * @text JS: X, Y, W, H
 * @parent ImageWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const ww = Graphics.boxWidth - Math.ceil(Graphics.boxWidth * 4/10);\nconst wh = this.mainAreaHeight() - (this.calcWindowHeight(1, false) * 2);\nconst wx = this.isRightInputMode() ? 0 : (Graphics.boxWidth - ww);\nconst wy = this.mainAreaTop() + this.calcWindowHeight(1, false);\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param ListWindow
 * @text List Window
 * @parent MainWindows
 *
 * @param ListWindow_BgType:num
 * @text Background Type
 * @parent ListWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param ListWindowDelayMS:num
 * @text Delay MS
 * @parent ListWindow
 * @type number
 * @min 1
 * @max 999
 * @desc How many milliseconds (MS) to delay the preview update?
 * This is to prevent lag spikes.
 * @default 240
 *
 * @param ListWindow_MaskUnknown:eval
 * @text Mask Unknown Enemies
 * @parent ListWindow
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Apply a character mask to unknown enemies?
 * @default true
 *
 * @param ListWindow_RectJS:func
 * @text JS: X, Y, W, H
 * @parent ListWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const ww = Math.ceil(Graphics.boxWidth * 4/10);\nconst wh = this.mainAreaHeight() - (this.calcWindowHeight(1, false) * 2);\nconst wx = this.isRightInputMode() ? (Graphics.boxWidth - ww) : 0;\nconst wy = this.mainAreaTop() + this.calcWindowHeight(1, false);\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param NameWindow
 * @text Name Window
 * @parent MainWindows
 *
 * @param NameWindow_BgType:num
 * @text Background Type
 * @parent NameWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param NameWindow_RectJS:func
 * @text JS: X, Y, W, H
 * @parent NameWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const ww = Graphics.boxWidth;\nconst wh = this.calcWindowHeight(1, false);\nconst wx = 0;\nconst wy = this.mainAreaTop();\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param SubWindow
 * @text Sub Window
 * @parent MainWindows
 *
 * @param SubWindow_BgType:num
 * @text Background Type
 * @parent SubWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param SubWindow_RectJS:func
 * @text JS: X, Y, W, H
 * @parent SubWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const ww = Graphics.boxWidth;\nconst wh = this.calcWindowHeight(1, false);\nconst wx = 0;\nconst wy = this.mainAreaBottom() - wh;\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param DataWindows
 * @text Data Window
 *
 * @param DataWindow_RectJS:func
 * @text JS: X, Y, W, H
 * @parent DataWindows
 * @type note
 * @desc Code used to determine the dimensions for all data windows.
 * @default "const ww = this.listWindowRect().width;\nconst wh = this.mainAreaHeight() - this.calcWindowHeight(1, true) - (this.calcWindowHeight(1, false) * 2);\nconst wx = 0;\nconst wy = this.mainAreaTop() + this.calcWindowHeight(1, false) + this.calcWindowHeight(1, true);\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param CategoryWindow
 * @text Category Window
 * @parent DataWindows
 *
 * @param CategoryWindow_BgType:num
 * @text Background Type
 * @parent CategoryWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param CategoryWindow_CommandOrder:arraystr
 * @text Command Order
 * @parent CategoryWindow
 * @type select[]
 * @option Basic - Basic parameter data
 * @value basic
 * @option Elements - Elemental resistances and weaknesses
 * @value elements
 * @option Skills - Usable skills in-battle
 * @value skills
 * @option Rewards - EXP, Gold, Drop Items
 * @value rewards
 * @option Traits - For VisuMZ_1_ElementStatusCore.js
 * @value traits
 * @option Lore - Background Information
 * @value lore
 * @desc What order do you want the commands to appear in?
 * @default ["basic","elements","skills","rewards","traits","lore"]
 *
 * @param CategoryWindow_Style:str
 * @text Style
 * @parent CategoryWindow
 * @type select
 * @option Text Only
 * @value text
 * @option Icon Only
 * @value icon
 * @option Icon + Text
 * @value iconText
 * @option Automatic
 * @value auto
 * @desc How do you wish to draw commands for this window?
 * @default auto
 *
 * @param DataCategoriesWindow_RectJS:func
 * @text JS: X, Y, W, H
 * @parent CategoryWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const ww = this.listWindowRect().width;\nconst wh = this.calcWindowHeight(1, true);\nconst wx = 0;\nconst wy = this.mainAreaTop() + this.calcWindowHeight(1, false);\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param BasicWindow
 * @text Basic Window
 * @parent DataWindows
 *
 * @param BasicWindow_BgType:num
 * @text Background Type
 * @parent BasicWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param BasicWindow_ShowLevelChange:eval
 * @text Show Level Change
 * @parent BasicWindow
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show level change commands?
 * Requires VisuMZ_3_EnemyLevels!
 * @default true
 *
 * @param ElementsWindow
 * @text Elements Window
 * @parent DataWindows
 *
 * @param ElementsWindow_BgType:num
 * @text Background Type
 * @parent ElementsWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param SkillsWindow
 * @text Skills Window
 * @parent DataWindows
 *
 * @param SkillsWindow_BgType:num
 * @text Background Type
 * @parent SkillsWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param RewardsWindow
 * @text Rewards Window
 * @parent DataWindows
 *
 * @param RewardsWindow_BgType:num
 * @text Background Type
 * @parent RewardsWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param RewardsWindow_RewardsOrder:arraystr
 * @text Rewards Order
 * @parent RewardsWindow
 * @type select[]
 * @option EXP - Experience Points
 * @value exp
 * @option Gold - Gold Currency
 * @value gold
 * @option Drop Items - Enemy Drop Items
 * @value items
 * @option AP - For VisuMZ_2_SkillLearnSystem.js
 * @value ap
 * @option CP - For VisuMZ_2_ClassChangeSystem.js
 * @value cp
 * @option JP - For VisuMZ_2_ClassChangeSystem.js
 * @value jp
 * @option SP - For VisuMZ_2_SkillLearnSystem.js
 * @value sp
 * @desc What order do you want the rewards to appear in?
 * @default ["exp","ap","cp","jp","sp","gold","items"]
 *
 * @param EXP_Icon:num
 * @text Reward EXP Icon
 * @parent RewardsWindow
 * @desc Icon used for EXP reward.
 * @default 87
 *
 * @param Gold_Icon:num
 * @text Reward Gold Icon
 * @parent RewardsWindow
 * @desc Icon used for Gold reward.
 * @default 314
 *
 * @param TraitsWindow
 * @text Traits Window
 * @parent DataWindows
 *
 * @param TraitsWindow_BgType:num
 * @text Background Type
 * @parent TraitsWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param TraitsWindow_ShowAllTraits:eval
 * @text Show All Traits
 * @parent TraitsWindow
 * @type boolean
 * @on Include Unused
 * @off Show Only Used
 * @desc Show all traits? Including unused ones?
 * Requires VisuMZ_1_ElementStatusCore!
 * @default false
 *
 * @param LoreWindow
 * @text Lore Window
 * @parent DataWindows
 *
 * @param LoreWindow_AutoWordWrap:eval
 * @text Auto Word Wrap?
 * @parent LoreWindow
 * @type boolean
 * @on Word Wrap
 * @off Normal
 * @desc Automatically enable word wrap?
 * Requires VisuMZ_1_MessageCore!
 * @default false
 *
 * @param LoreWindow_BgType:num
 * @text Background Type
 * @parent LoreWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param LoreWindow_FontSize:num
 * @text Font Size
 * @parent LoreWindow
 * @desc Font size used for Lore Window.
 * @default 22
 *
 * @param Scrolling
 * @parent LoreWindow
 *
 * @param Slow
 * @parent Scrolling
 *
 * @param SlowScrollSpeed:num
 * @text Scroll Speed
 * @parent Slow
 * @type number
 * @min 1
 * @desc What speed will Up/Down scroll the window at?
 * Lower is slower. Higher is faster.
 * @default 8
 *
 * @param SlowSoundFreq:num
 * @text Sound Frequency
 * @parent Slow
 * @type number
 * @min 1
 * @desc How frequent will Up/Down scrolling make sounds?
 * Lower is quicker. Higher is later.
 * @default 8
 *
 * @param Fast
 * @parent Scrolling
 *
 * @param FastScrollSpeed:num
 * @text Scroll Speed
 * @parent Fast
 * @type number
 * @min 1
 * @desc What speed will PageUp/PageDn scroll the window at?
 * Lower is slower. Higher is faster.
 * @default 32
 *
 * @param FastSoundFreq:num
 * @text Sound Frequency
 * @parent Fast
 * @type number
 * @min 1
 * @desc How frequent will PageUp/PageDn scrolling make sounds?
 * Lower is quicker. Higher is later.
 * @default 4
 *
 */
//=============================================================================

const _0x86b5bc=_0x1218;function _0x1218(_0x17d5fa,_0x53f112){const _0x39f6ed=_0x39f6();return _0x1218=function(_0x12183e,_0x26f752){_0x12183e=_0x12183e-0x99;let _0x2fc5c5=_0x39f6ed[_0x12183e];return _0x2fc5c5;},_0x1218(_0x17d5fa,_0x53f112);}(function(_0x422c2e,_0x438eb8){const _0x3d745b=_0x1218,_0x13e2c8=_0x422c2e();while(!![]){try{const _0x1fddb5=parseInt(_0x3d745b(0x2b0))/0x1*(parseInt(_0x3d745b(0x362))/0x2)+-parseInt(_0x3d745b(0x343))/0x3+-parseInt(_0x3d745b(0x334))/0x4+parseInt(_0x3d745b(0xb9))/0x5*(-parseInt(_0x3d745b(0xbd))/0x6)+parseInt(_0x3d745b(0x2fd))/0x7*(-parseInt(_0x3d745b(0x266))/0x8)+parseInt(_0x3d745b(0x137))/0x9*(parseInt(_0x3d745b(0x12f))/0xa)+parseInt(_0x3d745b(0x361))/0xb;if(_0x1fddb5===_0x438eb8)break;else _0x13e2c8['push'](_0x13e2c8['shift']());}catch(_0x3fa066){_0x13e2c8['push'](_0x13e2c8['shift']());}}}(_0x39f6,0xf079e));function _0x39f6(){const _0x28ba1c=['fastScrollSpeed','ListWindow_RectJS','SubElement','minLevel','updatePadding','%1\x20is\x20incorrectly\x20placed\x20on\x20the\x20plugin\x20list.\x0aIt\x20is\x20a\x20Tier\x20%2\x20plugin\x20placed\x20over\x20other\x20Tier\x20%3\x20plugins.\x0aPlease\x20reorder\x20the\x20plugin\x20list\x20from\x20smallest\x20to\x20largest\x20tier\x20numbers.','match','viewEnemy','isBestiaryCommandEnabled','isCategoryOpen','_nameWindow','innerHeight','delayMs','addLevelChangeCommands','Nature','buttonAssistText5','CategoryWindow_CommandOrder','SystemShowBestiaryMenu','members','<WordWrap>','RegExp','trait','iconHeight','commands','hide','setText','chance10','deselect','buttonAssist_Collapse','initBestiarySettings','anchor','1004483dkPjOu','view','Math_random','prototype','itemLineRect','getSkillName','addCategory','battler','_backSprite1','createDataCategoriesWindow','SubWindow_Completion','isEnemyNameMasked','call','\x5cI[73]Raise\x20%1\x20Up','commandStyleCheck','Window_MenuCommand_addOriginalCommands','offsetX','scale','_subWindow','_elementsDataWindow','#%1','drawItemStyleIcon','_enemyBestiaryCategories','battleback2','Variant','fixedPercentage','drawTextEx','_basicDataWindow','getInputMultiButtonStrings','_svBattlerName','STRUCT','maxLevel','battleback1','resetFontSettings','updateEnemyImage','RewardsWindow_Chance20','Skills','commandNameWindowDrawBackground','refresh','processCursorMove','home','battlerName','scrollTo','scaleHelpWindow','height','Settings','setItem','format','addJpCommand','addChild','onSymbolWindowCancel','VisuMZ_2_ClassChangeSystem','updateOrigin','makeCommandList','isItem','floor','FastSoundFreq','isCustomCommandVisible','baseParams','bestiaryEnemyBattlebackData','processFastScroll','setSubWindow','paramValueByName','Scroll','buttonAssistKey1','param','\x5cC[17]Conditional','contents','SkillLearnSystem','ARRAYJSON','addApCommand','inBattle','some','drawText','createImageWindow','HelpWindow_RectJS','Race','91ZakKoI','createNameWindow','Name','processSvActorImage','\x5cC[27]Absorb','_helpWindow','setFrame','onDataCategoriesCancel','ListWindowDelayMS','addSpCommand','+\x20%1\x20(%2%)','LoreWindow_Default','includeEnemy','_tp','VisuMZ_1_ElementStatusCore','nameWindow','visible','addCustomCommand','initBestiaryMainMenu','push','PossibleMassTraitsFromNotetags','Grassland','drawEncounterData','iconIndex','Title','calcWindowHeight','blurFilterStrength','loadEnemy','abilityPointsAbbr','TraitsWindow_CategoryHelpDesc','createHelpWindow','loadArmature','createBattlebackSprites','VisuMZ_2_DragonbonesUnion','_enemySprite','addGoldCommand','LoreWindow_BgType','addTraitCommand','addItemDropCommand','GetItemObj','loadSvActor','addCommand','toggleTraitsCategory','_battlebackSprite1','pagedown','%1\x27s\x20version\x20does\x20not\x20match\x20plugin\x27s.\x20Please\x20update\x20it\x20in\x20the\x20Plugin\x20Manager.','width','abilityPoints','isCustomCommandEnabled','RewardsText','defaultBattleback1','ShowVictory','defaultLoreFmt','This\x20monster\x20has\x20no\x20special\x20properties.','expA','3902272zuxOsa','SubWindow_RectJS','map','setMainMenuBestiaryEnabled','chance100','Key','Bestiary','addBestiaryCommandAutomatically','animations','View','totalDefeatedEnemies','defaultBattleback2','addTimesEnemySeen','TraitsWindow_NullHelpDesc','updateEnemy','5125395MHYBcm','adjustSprite','scrollToBottom','getAbsorbedElements','onDatabaseLoaded','Collapse','\x5cC[24]Guaranteed','SubWindow_Encountered','createDragonbonesSprite','basicWindow','ImageWindow_Battleback2','RewardsWindow_Chance10','bestiary','needsPageButtons','becomeActive','\x5cI[74]Lower\x20%1\x20Down\x20to\x20Minimum','updateEnemyID','\x5cC[21]Common','itemTextAlign','ARRAYNUM','StatusMenu','expand','center','items','onBasicDataLevelChange','dataWindowRect','skillPointsIcon','levelDown','getTraitSetKeys','isEnemy','39242797vdFNpO','2ogGEED','_commandWindow','setColorTone','jobPointsAbbr','traitSet','BgFilename2','buttonAssist_FastScroll','categoryEnemyIDs','hasAnimatedSvActorBattler','createFilters','createCommandNameWindow','BgSettings','makeTraitCommand','svActorHorzCells','Gold_Icon','\x5cI[%1]%2','NameWindow_BgType','DrawIcons','List','ImageWindow_RectJS','isRightInputMode','addCpCommand','max','VisuMZ_1_MessageCore','createSkillsDataWindow','updateArrows','addItemToGroup','ARRAYEVAL','_scene','note','parameters','NameWindow_CategoryText','LoreIcon','fontSize','5IfGMMg','_imageWindow','imageWindowRect','process_VisuMZ_Bestiary_Categories','3994842FtDuhw','_symbolWindows','CategoryData','rewardsOrder','show','Zodiac','createRewardsDataWindow','isEnemyFullyVisible','ImageWindow_Battleback1','Visible','addInnerChild','_blurFilter','traitSetType','Common','armors','status','enemyBestiaryCategories','addEnemyConditionalDrops','isAlive','maxTp','drawItemStyleIconText','CategoryOrder','updateFilters','Element','traits','activateSymbolWindow','lore','ElementsWindow_Absorb','classPointsIcon','Please\x20select\x20a\x20monster\x20to\x20view.','addEnemyDatabaseDrops','levelUp','end','FastScrollSpeed','SnapshotOpacity','ElementsText','Param','\x5cC[24]Weak','hasSvBattler','bind','_categoryStatus','scaleX','scaleSprite','CategoryWindow_OpenCategory','smoothScrollBy','Defeated:\x20%1','addBestiaryCommand','random','mainAreaTop','(needs\x20key)','ExcludeElements','BasicWindow_LevelUpByOne','LoreText','createEnemySprite','buttonAssistKey4','setup','Elements','includesTrait','categoryEnemies','%1\x20is\x20missing\x20a\x20required\x20plugin.\x0aPlease\x20install\x20%2\x20into\x20the\x20Plugin\x20Manager.','gold','ShowMainMenu','deactivate','join','ExtraEnemyDrops','PossibleEnemyTraits','category','filter','-----','-\x20\x5cC[16]%1','isBestiaryCommandVisible','_bestiaryTotalEnemies','drawParamItem','kind','padding','loadSvEnemy','CategoryWindow_BgType','RewardsWindow_RewardsOrder','levelDownToMin','chance20','ImageWindow_Padding','_rewardsDataWindow','setHandler','CategoryWindow_ClosedCategory','right','chance50','isEnemyDefeated','drawItem','subWindow','AbilityPoints','_backSprite2','updateSpriteVisibility','canAddLevelChange','setClickHandler','_dragonbonesSpriteContainer','maxItems','onLoadDragonbones','expIcon','Blessing','Switch\x20Monster','playCursorSound','\x5cC[7]Immune','helpWindow_BgType','mainAreaHeight','SlowSoundFreq','updateHelp','addTimesEnemyDefeated','_showEnemyInBestiary','buttonAssist_Expand','scaleY','Vocab','hideAllSymbolWindows','disposeDragonbones','contentsHeight','2130NfNPti','NUM','ImageWindow_BlurStrength','name','round','prevEnemy','createContents','_dragonbonesBattlerData','51489gGTdAh','loadBattleback1','abs','levelMin','GetParamIcon','toFixed','bestiaryEnemyBattleback1','FUNC','version','active','clear','drawMessageText','currentCategory','constructor','SkillPoints','offsetY','getDefeatedEnemies','_loreDataWindow','_battlebackSprite2','enabled','textColor','createCustomBackgroundImages','BattleManager_setup','isElementIDExcluded','length','addLoadListener','bestiaryEnemyBattleback2','showEnemyInBestiary','Categories','filters','updateBattlebackImages','ARRAYSTR','RewardsWindow_Chance100','isBottomHelpMode','ElementsIcon','createArmature','weapons','skills','isSideView','Reveal','ElementsWindow_Resist','_dragonbonesName','isPlaytest','isCommandEnabled','fastScrollLore','battlerHue','Show','getDatabaseItem','_enemyID','buttonAssistKey2','_bestiaryEnemyCustomImageFilename','removeChild','shouldDrawIcons','addItemsCommand','nullHelp','pageup','This\x20is\x20the\x20property\x20type.','left','openCategoriesFmt','\x5cI[74]Lower\x20%1\x20Down','buttonAssist','ElementsWindow_Neutral','timesEnemyDefeated','setScrollAccel','BasicWindow_LevelUpToMax','SETTINGS','Game_System_initialize','setHue','createSubWindow','dropItems','calculateTextHeight','LoreWindow_AutoWordWrap','updateCommandNameWindow','smoothSelect','setImageWindow','openCloseCurrentCategory','down','createSpecialBattlers','loadBattleback2','listWindowRect','RewardsWindow_Conditional','elementsWindow','dataCategoriesWindowRect','wait','setBackgroundOpacity','maskChar','slowScrollSpeed','_timesEnemyDefeated','createBackground','includes','bestiaryEnemyCustomImageFilename','Gender','SceneOpenBestiary','arePageButtonsEnabled','closedCategoriesFmt','createTraitsDataWindow','drawBestiaryCompletionRate','forceSelect','isWeapon','skillId','helpWindowRect','VisuMZ_4_ExtraEnemyDrops','origin','setEnemyID','update','sort','uiButtonPosition','ConvertParams','Fast\x20Scroll','Window','isAutoColorAffected','Curse','dispose','innerWidth','normalColor','neutral','RewardsWindow_BgType','_traitsDataWindow','createCommandWindow','ClassChangeSystem','BasicWindow_ShowLevelChange','buttonAssist_View','addExpCommand','split','getTraitSet','enemy','timesEnemySeen','setHelpWindow','bitmap','onDataCategoriesOpen','isSkillHidden','Rewards','PossibleSingularTraitsFromNotetags','createPageButtons','\x5cI[73]Raise\x20%1\x20Up\x20to\x20Maximum','changeTextColor','showLevelChange','callUpdateImage','makeEnemyList','includeCategory','clamp','_getBestiaryLore','\x5cC[25]Resist','TraitsWindow_OpenCategory','initialize','playCursor','setBackgroundType','callUpdateHelp','absorb','_text','_Bestiary_MainMenu','_timesEnemySeen','ext','_listWindow','MainMenu','\x5cC[0]Normal','basic','getDatabase','dataId','createLoreDataWindow','categoryWindow','DataWindow_RectJS','rewards','loreWindow','DataCategoriesWindow_RectJS','_pageupButton','hasDragonbonesBattler','createAllWindows','dragonbonesData','_dataCategoriesWindow','_pagedownButton','addNewState','setEnemyName','itemPadding','isTriggered','defaultCategory','ARRAYFUNC','CategoryWindow_Style','completionFmt','SubWindow_BgType','helpWindowRatio','_noRandom','_bestiaryEnemyBattlebackData','process_VisuMZ_Bestiary','buttonAssistText2','bestiaryTotalEnemies','concat','resetWordWrap','buttonAssistText4','maskUndefeatedEnemyNames','min','-\x20%1\x20(%2%)','drawAllText','bgType','Description','skill','nextEnemy','addSortedEnemyDrops','loadTitle1','buttonAssistKey3','processSlowScroll','commandNameWindowDrawText','CategoryWindow_MaskChar','index','trim','processFullEnemyImage','addWindow','createBasicDataWindow','isMainMenuBestiaryVisible','enemyId','VisuMZ_2_SkillLearnSystem','VisuMZ_3_EnemyLevels','originalName','Game_BattlerBase_refresh','addEnemy','RewardsWindow_Chance50','levelMax','VisuMZ_1_BattleCore','SkillsIcon','TraitsWindow_BgType','ListWindow_MaskUnknown','maxCols','createElementsDataWindow','gainLevel','shown','Alignment','Scene_Boot_onDatabaseLoaded','BasicIcon','commandStyle','boxWidth','Scene_Menu_createCommandWindow','SubWindowCompleteFiBasicWindow_LevelDownByOnexedDigits','_list','processEnemyLore','_commandNameWindow','\x5cC[27]Super\x20Rare','currentExt','TraitsWindow_ShowAllTraits','remove','abilityPointsIcon','conditional','replace','registerCommand','CoreEngine','traitsWindow','resist','indexOf','uiMenuStyle','RewardsWindow_Chance0','_allTextHeight','parse','playDragonbonesIdleAnimation','buttonAssistText3','ClassPoints','_enemyDrops','elements','makeEmptyGroups','Enable','exp','BestiaryMenuCommand','HelpWindow_ScaleRatio','rewardsWindow','BESTIARY','_enemy','downArrowVisible','description','EnableMainMenu','RandomizeEnemy','nameWindowRect','toLowerCase','elementRate','DebugFullBestiary','makeTraitList','Bestiary\x20Completion\x20Rate:\x20%1%\x20(%2/%3\x20Monsters)','_categoryEnemyIDs','callUpdateSymbolWindow','setEnemy','mainAreaBottom','cancel','Base','BgFilename1','toggleEnemyCategory','canDebugViewBestiary','Encountered:\x20%1','frameCount','changePaintOpacity','Label','isEnabledEnemy','toUpperCase','addOriginalCommands','ceil','TraitsIcon','setLevel','textSizeEx','level','commandName','_dragonbones','_lastIndex','popScene','isSceneBattle','initCategoryStatus','getBackgroundOpacity','setSymbolWindow','895848hHZZxl','deactivateSymbolWindow','return\x200','traitHelp','_debugViewBestiary','auto','EVAL','iconWidth','svActorVertCells','scrollToTop','commandSymbol','chance0','_cache','ElementsWindow_Weak','subWindowRect','BasicWindow_LevelDownToMin','iconText','Default','playOkSound','icon','autoWordWrap','denominator','create','\x5cC[5]Rare','Expand','GetDropRateText','text','playOk','SubWindowCompleteFixedDigits','drawIcon','currentSymbol','activate','RandomValid','switch','jobPointsIcon','buttonAssistKey5','callUpdateSubWindow','setTraitSet','isPressed','VisuMZ_0_CoreEngine','isMainMenuBestiaryEnabled','changeEnemyTrait','setNoEnemyText'];_0x39f6=function(){return _0x28ba1c;};return _0x39f6();}var label=_0x86b5bc(0x33a),tier=tier||0x0,dependencies=[],pluginData=$plugins[_0x86b5bc(0x100)](function(_0x2827b6){const _0x2c8edd=_0x86b5bc;return _0x2827b6[_0x2c8edd(0xcc)]&&_0x2827b6['description'][_0x2c8edd(0x190)]('['+label+']');})[0x0];VisuMZ[label][_0x86b5bc(0x2dd)]=VisuMZ[label][_0x86b5bc(0x2dd)]||{},VisuMZ[_0x86b5bc(0x1a2)]=function(_0x31348b,_0x110ad2){const _0x5ea0c0=_0x86b5bc;for(const _0x3867ba in _0x110ad2){if(_0x3867ba['match'](/(.*):(.*)/i)){const _0x1eb278=String(RegExp['$1']),_0x1fdd70=String(RegExp['$2'])[_0x5ea0c0(0x257)]()['trim']();let _0x26c255,_0x212113,_0x106dd1;switch(_0x1fdd70){case _0x5ea0c0(0x130):_0x26c255=_0x110ad2[_0x3867ba]!==''?Number(_0x110ad2[_0x3867ba]):0x0;break;case _0x5ea0c0(0x356):_0x212113=_0x110ad2[_0x3867ba]!==''?JSON[_0x5ea0c0(0x231)](_0x110ad2[_0x3867ba]):[],_0x26c255=_0x212113['map'](_0xa7e8e7=>Number(_0xa7e8e7));break;case _0x5ea0c0(0x26c):_0x26c255=_0x110ad2[_0x3867ba]!==''?eval(_0x110ad2[_0x3867ba]):null;break;case _0x5ea0c0(0xb2):_0x212113=_0x110ad2[_0x3867ba]!==''?JSON['parse'](_0x110ad2[_0x3867ba]):[],_0x26c255=_0x212113[_0x5ea0c0(0x336)](_0x265cec=>eval(_0x265cec));break;case'JSON':_0x26c255=_0x110ad2[_0x3867ba]!==''?JSON['parse'](_0x110ad2[_0x3867ba]):'';break;case _0x5ea0c0(0x2f5):_0x212113=_0x110ad2[_0x3867ba]!==''?JSON['parse'](_0x110ad2[_0x3867ba]):[],_0x26c255=_0x212113['map'](_0x62f17a=>JSON[_0x5ea0c0(0x231)](_0x62f17a));break;case _0x5ea0c0(0x13e):_0x26c255=_0x110ad2[_0x3867ba]!==''?new Function(JSON[_0x5ea0c0(0x231)](_0x110ad2[_0x3867ba])):new Function(_0x5ea0c0(0x268));break;case _0x5ea0c0(0x1e7):_0x212113=_0x110ad2[_0x3867ba]!==''?JSON[_0x5ea0c0(0x231)](_0x110ad2[_0x3867ba]):[],_0x26c255=_0x212113[_0x5ea0c0(0x336)](_0x45df83=>new Function(JSON['parse'](_0x45df83)));break;case'STR':_0x26c255=_0x110ad2[_0x3867ba]!==''?String(_0x110ad2[_0x3867ba]):'';break;case _0x5ea0c0(0x156):_0x212113=_0x110ad2[_0x3867ba]!==''?JSON[_0x5ea0c0(0x231)](_0x110ad2[_0x3867ba]):[],_0x26c255=_0x212113[_0x5ea0c0(0x336)](_0x3c7768=>String(_0x3c7768));break;case _0x5ea0c0(0x2ce):_0x106dd1=_0x110ad2[_0x3867ba]!==''?JSON[_0x5ea0c0(0x231)](_0x110ad2[_0x3867ba]):{},_0x26c255=VisuMZ[_0x5ea0c0(0x1a2)]({},_0x106dd1);break;case'ARRAYSTRUCT':_0x212113=_0x110ad2[_0x3867ba]!==''?JSON[_0x5ea0c0(0x231)](_0x110ad2[_0x3867ba]):[],_0x26c255=_0x212113[_0x5ea0c0(0x336)](_0x5ed013=>VisuMZ[_0x5ea0c0(0x1a2)]({},JSON['parse'](_0x5ed013)));break;default:continue;}_0x31348b[_0x1eb278]=_0x26c255;}}return _0x31348b;},(_0x31803a=>{const _0x16363a=_0x86b5bc,_0x307eda=_0x31803a[_0x16363a(0x132)];for(const _0x23badb of dependencies){if(!Imported[_0x23badb]){alert(_0x16363a(0xf8)[_0x16363a(0x2df)](_0x307eda,_0x23badb)),SceneManager['exit']();break;}}const _0x3b6bef=_0x31803a[_0x16363a(0x240)];if(_0x3b6bef['match'](/\[Version[ ](.*?)\]/i)){const _0x59818a=Number(RegExp['$1']);_0x59818a!==VisuMZ[label][_0x16363a(0x13f)]&&(alert(_0x16363a(0x32a)[_0x16363a(0x2df)](_0x307eda,_0x59818a)),SceneManager['exit']());}if(_0x3b6bef[_0x16363a(0x297)](/\[Tier[ ](\d+)\]/i)){const _0xa047ec=Number(RegExp['$1']);_0xa047ec<tier?(alert(_0x16363a(0x296)[_0x16363a(0x2df)](_0x307eda,_0xa047ec,tier)),SceneManager['exit']()):tier=Math['max'](_0xa047ec,tier);}VisuMZ[_0x16363a(0x1a2)](VisuMZ[label][_0x16363a(0x2dd)],_0x31803a[_0x16363a(0xb5)]);})(pluginData),PluginManager[_0x86b5bc(0x229)](pluginData['name'],_0x86b5bc(0x246),_0x19d891=>{const _0x31d299=_0x86b5bc;if(!$gameTemp[_0x31d299(0x161)]())return;VisuMZ[_0x31d299(0x1a2)](_0x19d891,_0x19d891),$gameTemp['setDebugViewBestiary'](_0x19d891[_0x31d299(0x15e)]);}),PluginManager[_0x86b5bc(0x229)](pluginData[_0x86b5bc(0x132)],_0x86b5bc(0x193),_0x13eea6=>{const _0x5e8e06=_0x86b5bc;if($gameParty[_0x5e8e06(0x2f7)]())return;if(SceneManager[_0x5e8e06(0x262)]())return;SceneManager[_0x5e8e06(0x310)](Scene_Bestiary);}),PluginManager['registerCommand'](pluginData[_0x86b5bc(0x132)],'SystemEnableBestiaryMenu',_0x37b4b1=>{const _0x36902b=_0x86b5bc;VisuMZ[_0x36902b(0x1a2)](_0x37b4b1,_0x37b4b1),$gameSystem['setMainMenuBestiaryEnabled'](_0x37b4b1[_0x36902b(0x238)]);}),PluginManager[_0x86b5bc(0x229)](pluginData['name'],_0x86b5bc(0x2a2),_0x21986c=>{const _0x1369a5=_0x86b5bc;VisuMZ[_0x1369a5(0x1a2)](_0x21986c,_0x21986c),$gameSystem['setMainMenuBestiaryVisible'](_0x21986c[_0x1369a5(0x165)]);}),VisuMZ['Bestiary']['RegExp']={'category':/<BESTIARY (?:CATEGORY|CATEGORIES):[ ](.*)>/i,'hideInBestiary':/<HIDE IN BESTIARY>/i,'customPicture':/<BESTIARY CUSTOM (?:IMAGE|PICTURE):[ ](.*)>/i,'battleback1':/<BESTIARY (?:BATTLEBACK|BACKGROUND) 1:[ ](.*)>/i,'battleback2':/<BESTIARY (?:BATTLEBACK|BACKGROUND) 2:[ ](.*)>/i,'lore':/<(?:BESTIARY |)LORE>\s*([\s\S]*)\s*<\/(?:BESTIARY |)LORE>/i,'hideSkill':/<HIDE SKILL IN BESTIARY>/i},VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x219)]=Scene_Boot[_0x86b5bc(0x2b3)]['onDatabaseLoaded'],Scene_Boot['prototype'][_0x86b5bc(0x347)]=function(){const _0x66773e=_0x86b5bc;VisuMZ[_0x66773e(0x33a)][_0x66773e(0x219)][_0x66773e(0x2bc)](this),this[_0x66773e(0x1ee)]();},Scene_Boot['prototype'][_0x86b5bc(0x1ee)]=function(){const _0x7760eb=_0x86b5bc;this[_0x7760eb(0xbc)]();},Scene_Boot[_0x86b5bc(0x2b3)][_0x86b5bc(0xbc)]=function(){const _0x3960f7=_0x86b5bc;VisuMZ[_0x3960f7(0x33a)]['CategoryOrder']=[],VisuMZ[_0x3960f7(0x33a)][_0x3960f7(0xbf)]={};const _0x58d4d7=VisuMZ['Bestiary'][_0x3960f7(0x2dd)][_0x3960f7(0x153)];for(const _0x32e221 of _0x58d4d7){const _0x2efcf5=(_0x32e221[_0x3960f7(0x339)]||'')[_0x3960f7(0x244)]()[_0x3960f7(0x203)]();if(_0x2efcf5==='')continue;if(_0x2efcf5===_0x3960f7(0xee))continue;VisuMZ[_0x3960f7(0x33a)][_0x3960f7(0xd2)][_0x3960f7(0x310)](_0x2efcf5),VisuMZ[_0x3960f7(0x33a)]['CategoryData'][_0x2efcf5]=_0x32e221;}},VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x2b2)]=Math['random'],Math[_0x86b5bc(0xec)]=function(){const _0x483e9e=_0x86b5bc;if(this[_0x483e9e(0x1ec)])return 0.5;return VisuMZ[_0x483e9e(0x33a)][_0x483e9e(0x2b2)]['apply'](this,arguments);},DataManager[_0x86b5bc(0xcd)]=function(_0xc82c11){const _0x246275=_0x86b5bc;if(!_0xc82c11)return[];const _0x188586=_0xc82c11['id'];this[_0x246275(0x2c6)]=this['_enemyBestiaryCategories']||{};if(this['_enemyBestiaryCategories'][_0x188586]!==undefined)return this['_enemyBestiaryCategories'][_0x188586];this[_0x246275(0x2c6)][_0x188586]=[];const _0x15d1db=VisuMZ['Bestiary'][_0x246275(0x2a5)],_0x5cefac=_0xc82c11[_0x246275(0xb4)]||'';return _0x5cefac[_0x246275(0x297)](_0x15d1db[_0x246275(0xff)])&&(this[_0x246275(0x2c6)][_0x188586]=RegExp['$1'][_0x246275(0x1b2)](',')[_0x246275(0x336)](_0x139f98=>_0x139f98['toLowerCase']()[_0x246275(0x203)]())),this[_0x246275(0x2c6)][_0x188586][_0x246275(0x14f)]<=0x0&&(this[_0x246275(0x2c6)][_0x188586]=[Game_Enemy[_0x246275(0x23d)][_0x246275(0x1e6)][_0x246275(0x244)]()[_0x246275(0x203)]()]),this[_0x246275(0x2c6)][_0x188586];},DataManager[_0x86b5bc(0x152)]=function(_0xd3076c){const _0x58827f=_0x86b5bc;if(!_0xd3076c)return![];if(_0xd3076c['name'][_0x58827f(0x203)]()==='')return![];if(_0xd3076c[_0x58827f(0x132)]['includes'](_0x58827f(0x101)))return![];const _0x3db7f2=_0xd3076c['id'];this[_0x58827f(0x128)]=this[_0x58827f(0x128)]||{};if(this['_showEnemyInBestiary'][_0x3db7f2]!==undefined)return this['_showEnemyInBestiary'][_0x3db7f2];let _0x3603f0=!![];const _0x41c3de=VisuMZ[_0x58827f(0x33a)][_0x58827f(0x2a5)],_0x14ab0f=_0xd3076c['note']||'';if(_0x14ab0f['match'](_0x41c3de['hideInBestiary']))_0x3603f0=![];else _0x14ab0f[_0x58827f(0x297)](/<SWAP ENEMIES>\s*([\s\S]*)\s*<\/SWAP ENEMIES>/i)&&(_0x3603f0=![]);return this[_0x58827f(0x128)][_0x3db7f2]=_0x3603f0,this[_0x58827f(0x128)][_0x3db7f2];},DataManager[_0x86b5bc(0xf7)]=function(_0x59ace7){const _0xd3bed9=_0x86b5bc,_0xc2f3cf=this[_0xd3bed9(0x9e)](_0x59ace7);return _0xc2f3cf['map'](_0x132890=>$dataEnemies[_0x132890])['remove'](undefined)[_0xd3bed9(0x225)](null);},DataManager[_0x86b5bc(0x9e)]=function(_0x4dc6b7){const _0x4c3952=_0x86b5bc;this['_categoryEnemyIDs']=this[_0x4c3952(0x249)]||{};if(this[_0x4c3952(0x249)][_0x4dc6b7]!==undefined)return this[_0x4c3952(0x249)][_0x4dc6b7];for(const _0x2504b7 of VisuMZ[_0x4c3952(0x33a)][_0x4c3952(0xd2)]){this[_0x4c3952(0x249)][_0x2504b7]=[];}for(const _0x45c0b0 of $dataEnemies){if(!_0x45c0b0)continue;if(!this[_0x4c3952(0x152)](_0x45c0b0))continue;const _0x181022=this['enemyBestiaryCategories'](_0x45c0b0);for(const _0x239e91 of _0x181022){this['_categoryEnemyIDs'][_0x239e91]=this['_categoryEnemyIDs'][_0x239e91]||[],this[_0x4c3952(0x249)][_0x239e91]['push'](_0x45c0b0['id']);}}for(const _0x3eba0b in this[_0x4c3952(0x249)]){this[_0x4c3952(0x249)][_0x3eba0b][_0x4c3952(0x1a0)]((_0x342538,_0x45e8d9)=>_0x342538-_0x45e8d9);}return this[_0x4c3952(0x249)][_0x4dc6b7];},DataManager[_0x86b5bc(0x1f0)]=function(){const _0x14b0a1=_0x86b5bc;if(this[_0x14b0a1(0x104)]!==undefined)return this[_0x14b0a1(0x104)];let _0x480620=[];for(const _0x15dc27 of VisuMZ[_0x14b0a1(0x33a)]['CategoryOrder']){const _0x57f7cd=this['categoryEnemyIDs'](_0x15dc27);_0x480620=_0x480620[_0x14b0a1(0x1f1)](_0x57f7cd);}return this[_0x14b0a1(0x104)]=_0x480620[_0x14b0a1(0x100)]((_0x21d98f,_0x5c7721,_0x31ee07)=>_0x31ee07['indexOf'](_0x21d98f)===_0x5c7721)[_0x14b0a1(0x14f)],this[_0x14b0a1(0x104)];},ImageManager[_0x86b5bc(0xa4)]=ImageManager[_0x86b5bc(0xa4)]||0x9,ImageManager[_0x86b5bc(0x26e)]=ImageManager['svActorVertCells']||0x6,ImageManager[_0x86b5bc(0x13d)]=function(_0x4ccd2c){const _0x344f67=_0x86b5bc,_0xbb871a=this[_0x344f67(0x2eb)](_0x4ccd2c)[0x0];return _0xbb871a===''?new Bitmap(0x1,0x1):this[_0x344f67(0x138)](_0xbb871a);},ImageManager[_0x86b5bc(0x151)]=function(_0x25a938){const _0x4b0f2a=_0x86b5bc,_0x1f2a34=this[_0x4b0f2a(0x2eb)](_0x25a938)[0x1];return _0x1f2a34===''?new Bitmap(0x1,0x1):this[_0x4b0f2a(0x185)](_0x1f2a34);},ImageManager[_0x86b5bc(0x2eb)]=function(_0x2939a9){const _0xcbfbb1=_0x86b5bc,_0x3bab53=$dataEnemies[_0x2939a9];if(!_0x3bab53)return['',''];this[_0xcbfbb1(0x1ed)]=this[_0xcbfbb1(0x1ed)]||{};if(this[_0xcbfbb1(0x1ed)][_0x2939a9]!==undefined)return this[_0xcbfbb1(0x1ed)][_0x2939a9];this['_bestiaryEnemyBattlebackData'][_0x2939a9]=['',''];const _0x47e354=VisuMZ[_0xcbfbb1(0x33a)][_0xcbfbb1(0x2a5)],_0x4d2126=_0x3bab53[_0xcbfbb1(0xb4)]||'';return _0x4d2126[_0xcbfbb1(0x297)](_0x47e354[_0xcbfbb1(0x2d0)])&&(this['_bestiaryEnemyBattlebackData'][_0x2939a9][0x0]=String(RegExp['$1'])[_0xcbfbb1(0x203)]()),_0x4d2126[_0xcbfbb1(0x297)](_0x47e354[_0xcbfbb1(0x2c7)])&&(this[_0xcbfbb1(0x1ed)][_0x2939a9][0x1]=String(RegExp['$1'])[_0xcbfbb1(0x203)]()),this[_0xcbfbb1(0x1ed)][_0x2939a9][0x0]===''&&this[_0xcbfbb1(0x1ed)][_0x2939a9][0x1]===''&&(this['_bestiaryEnemyBattlebackData'][_0x2939a9]=[Window_BestiaryEnemyImage[_0xcbfbb1(0x178)][_0xcbfbb1(0x32f)],Window_BestiaryEnemyImage[_0xcbfbb1(0x178)][_0xcbfbb1(0x33f)]]),this[_0xcbfbb1(0x1ed)][_0x2939a9];},ImageManager[_0x86b5bc(0x191)]=function(_0x5e2ed4){const _0x5f52b9=_0x86b5bc,_0xfe3bd6=$dataEnemies[_0x5e2ed4];if(!_0xfe3bd6)return'';this[_0x5f52b9(0x169)]=this['_bestiaryEnemyCustomImageFilename']||{};if(this[_0x5f52b9(0x169)][_0x5e2ed4]!==undefined)return this['_bestiaryEnemyCustomImageFilename'][_0x5e2ed4];this['_bestiaryEnemyCustomImageFilename'][_0x5e2ed4]='';const _0x96012=VisuMZ[_0x5f52b9(0x33a)][_0x5f52b9(0x2a5)],_0x3b093c=_0xfe3bd6[_0x5f52b9(0xb4)]||'';return _0x3b093c[_0x5f52b9(0x297)](_0x96012['customPicture'])&&(this[_0x5f52b9(0x169)][_0x5e2ed4]=String(RegExp['$1'])[_0x5f52b9(0x203)]()),this[_0x5f52b9(0x169)][_0x5e2ed4];},TextManager[_0x86b5bc(0x23a)]=VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x2dd)][_0x86b5bc(0x1d1)][_0x86b5bc(0x2ff)],TextManager[_0x86b5bc(0x33a)]={'buttonAssist':{'view':VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x2dd)][_0x86b5bc(0x12b)][_0x86b5bc(0x1b0)]??_0x86b5bc(0x33d),'expand':VisuMZ['Bestiary'][_0x86b5bc(0x2dd)]['Vocab'][_0x86b5bc(0x129)]??_0x86b5bc(0x27e),'collapse':VisuMZ[_0x86b5bc(0x33a)]['Settings'][_0x86b5bc(0x12b)][_0x86b5bc(0x2ad)]??_0x86b5bc(0x348),'switch':VisuMZ['Bestiary'][_0x86b5bc(0x2dd)][_0x86b5bc(0x12b)]['buttonAssist_Switch']??_0x86b5bc(0x120),'fastScrollLore':VisuMZ[_0x86b5bc(0x33a)]['Settings'][_0x86b5bc(0x12b)][_0x86b5bc(0x9d)]??_0x86b5bc(0x1a3),'slowScrollLore':VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x2dd)]['Vocab']['buttonAssist_SlowScroll']??_0x86b5bc(0x2ef)},'categoryWindow':{'maskChar':VisuMZ['Bestiary'][_0x86b5bc(0x2dd)][_0x86b5bc(0x12b)][_0x86b5bc(0x201)]??'?','openCategoriesFmt':VisuMZ[_0x86b5bc(0x33a)]['Settings'][_0x86b5bc(0x12b)][_0x86b5bc(0xe8)]??_0x86b5bc(0x1f6),'closedCategoriesFmt':VisuMZ[_0x86b5bc(0x33a)]['Settings'][_0x86b5bc(0x12b)][_0x86b5bc(0x110)]??_0x86b5bc(0x307),'fixedPercentage':VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x2dd)][_0x86b5bc(0x12b)]['CategoryPercentFixedDigits']??0x2},'nameWindow':{'category':VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x2dd)]['Vocab'][_0x86b5bc(0xb6)]??_0x86b5bc(0xda)},'subWindow':{'defeatedFmt':VisuMZ['Bestiary'][_0x86b5bc(0x2dd)]['Vocab']['SubWindow_Defeated']??_0x86b5bc(0xea),'seenFmt':VisuMZ['Bestiary'][_0x86b5bc(0x2dd)][_0x86b5bc(0x12b)][_0x86b5bc(0x34a)]??_0x86b5bc(0x252),'completionFmt':VisuMZ[_0x86b5bc(0x33a)]['Settings'][_0x86b5bc(0x12b)][_0x86b5bc(0x2ba)]??_0x86b5bc(0x248),'fixedPercentage':VisuMZ['Bestiary'][_0x86b5bc(0x2dd)][_0x86b5bc(0x12b)][_0x86b5bc(0x282)]??0x2},'basicWindow':{'levelUpToMax':VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x2dd)]['Vocab'][_0x86b5bc(0x177)]??_0x86b5bc(0x1bd),'levelUp':VisuMZ[_0x86b5bc(0x33a)]['Settings'][_0x86b5bc(0x12b)][_0x86b5bc(0xf0)]??_0x86b5bc(0x2bd),'levelDown':VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x2dd)]['Vocab'][_0x86b5bc(0x21e)]??_0x86b5bc(0x172),'levelDownToMin':VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x2dd)][_0x86b5bc(0x12b)][_0x86b5bc(0x275)]??_0x86b5bc(0x352)},'elementsWindow':{'weak':VisuMZ['Bestiary']['Settings'][_0x86b5bc(0x12b)][_0x86b5bc(0x273)]??_0x86b5bc(0xe2),'neutral':VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x2dd)]['Vocab'][_0x86b5bc(0x174)]??_0x86b5bc(0x1d2),'resist':VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x2dd)][_0x86b5bc(0x12b)][_0x86b5bc(0x15f)]??_0x86b5bc(0x1c5),'immune':VisuMZ['Bestiary'][_0x86b5bc(0x2dd)][_0x86b5bc(0x12b)]['ElementsWindow_Immune']??_0x86b5bc(0x122),'absorb':VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x2dd)][_0x86b5bc(0x12b)][_0x86b5bc(0xd8)]??_0x86b5bc(0x301)},'rewardsWindow':{'chance100':VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x2dd)][_0x86b5bc(0x12b)][_0x86b5bc(0x157)]??_0x86b5bc(0x349),'chance50':VisuMZ[_0x86b5bc(0x33a)]['Settings'][_0x86b5bc(0x12b)][_0x86b5bc(0x20e)]??_0x86b5bc(0x354),'chance20':VisuMZ['Bestiary'][_0x86b5bc(0x2dd)][_0x86b5bc(0x12b)][_0x86b5bc(0x2d3)]??'\x5cC[4]Uncommon','chance10':VisuMZ['Bestiary'][_0x86b5bc(0x2dd)][_0x86b5bc(0x12b)][_0x86b5bc(0x34e)]??_0x86b5bc(0x27d),'chance0':VisuMZ[_0x86b5bc(0x33a)]['Settings'][_0x86b5bc(0x12b)][_0x86b5bc(0x22f)]??_0x86b5bc(0x222),'conditional':VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x2dd)]['Vocab'][_0x86b5bc(0x187)]??_0x86b5bc(0x2f2)},'traitsWindow':{'openCategoriesFmt':VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x2dd)][_0x86b5bc(0x12b)][_0x86b5bc(0x1c6)]??_0x86b5bc(0x102),'closedCategoriesFmt':VisuMZ['Bestiary'][_0x86b5bc(0x2dd)][_0x86b5bc(0x12b)]['TraitsWindow_ClosedCategory']??'+\x20\x5cC[16]%1','traitHelp':VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x2dd)][_0x86b5bc(0x12b)][_0x86b5bc(0x31a)]??_0x86b5bc(0x16f),'nullHelp':VisuMZ['Bestiary'][_0x86b5bc(0x2dd)]['Vocab'][_0x86b5bc(0x341)]??_0x86b5bc(0x332)},'loreWindow':{'defaultLoreFmt':VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x2dd)][_0x86b5bc(0x12b)][_0x86b5bc(0x308)]??'Little\x20is\x20known\x20about\x20this\x20monster.'}},TextManager['getBestiaryLore']=function(_0x3ed408){const _0x10bb32=_0x86b5bc;if(!_0x3ed408)return'';const _0x27bf14=_0x3ed408['enemy']()['id'];this[_0x10bb32(0x1c4)]=this[_0x10bb32(0x1c4)]||{};if(this[_0x10bb32(0x1c4)][_0x27bf14]!==undefined)return this[_0x10bb32(0x1c4)][_0x27bf14];this[_0x10bb32(0x1c4)][_0x27bf14]=TextManager['Bestiary'][_0x10bb32(0x1da)][_0x10bb32(0x331)][_0x10bb32(0x2df)](_0x3ed408[_0x10bb32(0x20b)]());const _0x246cb0=VisuMZ[_0x10bb32(0x33a)][_0x10bb32(0x2a5)],_0x55a3d4=_0x3ed408[_0x10bb32(0x1b4)]()[_0x10bb32(0xb4)]||'';return _0x55a3d4['match'](_0x246cb0['lore'])&&(this[_0x10bb32(0x1c4)][_0x27bf14]=String(RegExp['$1'])[_0x10bb32(0x203)]()),this[_0x10bb32(0x1c4)][_0x27bf14];},ColorManager['getColor']=function(_0x3401f1){const _0x1cebe9=_0x86b5bc;return _0x3401f1=String(_0x3401f1),_0x3401f1['match'](/#(.*)/i)?_0x1cebe9(0x2c4)[_0x1cebe9(0x2df)](String(RegExp['$1'])):this[_0x1cebe9(0x14b)](Number(_0x3401f1));},SceneManager['isSceneBattle']=function(){const _0x1c61e4=_0x86b5bc;return this[_0x1c61e4(0xb3)]&&this[_0x1c61e4(0xb3)][_0x1c61e4(0x144)]===Scene_Battle;},Game_Temp['prototype'][_0x86b5bc(0x251)]=function(){const _0x546727=_0x86b5bc;return this['isPlaytest']()&&this[_0x546727(0x26a)];},Game_Temp[_0x86b5bc(0x2b3)]['setDebugViewBestiary']=function(_0x4e5ff3){const _0x66f842=_0x86b5bc;this[_0x66f842(0x26a)]=_0x4e5ff3;},VisuMZ['Bestiary'][_0x86b5bc(0x179)]=Game_System[_0x86b5bc(0x2b3)][_0x86b5bc(0x1c7)],Game_System[_0x86b5bc(0x2b3)][_0x86b5bc(0x1c7)]=function(){const _0x15205e=_0x86b5bc;VisuMZ[_0x15205e(0x33a)]['Game_System_initialize'][_0x15205e(0x2bc)](this),this[_0x15205e(0x30f)](),this[_0x15205e(0x2ae)]();},Game_System[_0x86b5bc(0x2b3)]['initBestiaryMainMenu']=function(){const _0x18f9f5=_0x86b5bc;this[_0x18f9f5(0x1cd)]={'shown':VisuMZ[_0x18f9f5(0x33a)][_0x18f9f5(0x2dd)]['MainMenu'][_0x18f9f5(0xfa)],'enabled':VisuMZ[_0x18f9f5(0x33a)][_0x18f9f5(0x2dd)][_0x18f9f5(0x1d1)][_0x18f9f5(0x241)]};},Game_System[_0x86b5bc(0x2b3)][_0x86b5bc(0x207)]=function(){const _0x305e47=_0x86b5bc;if(this[_0x305e47(0x1cd)]===undefined)this[_0x305e47(0x30f)]();return this[_0x305e47(0x1cd)][_0x305e47(0x217)];},Game_System[_0x86b5bc(0x2b3)]['setMainMenuBestiaryVisible']=function(_0x1d0a5f){const _0x6b3439=_0x86b5bc;if(this[_0x6b3439(0x1cd)]===undefined)this[_0x6b3439(0x30f)]();this[_0x6b3439(0x1cd)][_0x6b3439(0x217)]=_0x1d0a5f;},Game_System[_0x86b5bc(0x2b3)][_0x86b5bc(0x28e)]=function(){const _0x2f4d22=_0x86b5bc;if(this[_0x2f4d22(0x1cd)]===undefined)this['initBestiaryMainMenu']();return this[_0x2f4d22(0x1cd)][_0x2f4d22(0x14a)];},Game_System[_0x86b5bc(0x2b3)][_0x86b5bc(0x337)]=function(_0x4b828c){const _0x29c116=_0x86b5bc;if(this['_Bestiary_MainMenu']===undefined)this[_0x29c116(0x30f)]();this[_0x29c116(0x1cd)]['enabled']=_0x4b828c;},Game_System[_0x86b5bc(0x2b3)][_0x86b5bc(0x113)]=function(_0x2d734d){const _0x134822=_0x86b5bc;return Imported['VisuMZ_1_BattleCore']?this[_0x134822(0x147)]()[_0x134822(0x190)](_0x2d734d):this[_0x134822(0x175)](_0x2d734d)>0x0;},Game_System[_0x86b5bc(0x2b3)][_0x86b5bc(0x2ae)]=function(){const _0x39b0f4=_0x86b5bc;this['_timesEnemyDefeated']=this['_timesEnemyDefeated']||{},this[_0x39b0f4(0x1ce)]=this['_timesEnemySeen']||{};},Game_System[_0x86b5bc(0x2b3)][_0x86b5bc(0x175)]=function(_0x17e173){const _0x396d2b=_0x86b5bc;if(this[_0x396d2b(0x18e)]===undefined)this[_0x396d2b(0x2ae)]();return this['_timesEnemyDefeated'][_0x17e173]=this[_0x396d2b(0x18e)][_0x17e173]||0x0,this['_timesEnemyDefeated'][_0x17e173];},Game_System[_0x86b5bc(0x2b3)][_0x86b5bc(0x127)]=function(_0x12e8f5,_0x3543d2){const _0x1d4f96=_0x86b5bc;if(this[_0x1d4f96(0x18e)]===undefined)this['initBestiarySettings']();this[_0x1d4f96(0x18e)][_0x12e8f5]=this[_0x1d4f96(0x18e)][_0x12e8f5]||0x0,this['_timesEnemyDefeated'][_0x12e8f5]+=_0x3543d2||0x1;},Game_System[_0x86b5bc(0x2b3)][_0x86b5bc(0x33e)]=function(){const _0x8c88f7=_0x86b5bc;let _0x3e6acd=0x0;for(const _0x23b665 of $dataEnemies){if(!_0x23b665)continue;DataManager[_0x8c88f7(0x152)](_0x23b665)&&this['timesEnemyDefeated'](_0x23b665['id'])>0x0&&_0x3e6acd++;}return _0x3e6acd;},VisuMZ[_0x86b5bc(0x33a)]['Game_BattlerBase_addNewState']=Game_BattlerBase[_0x86b5bc(0x2b3)][_0x86b5bc(0x1e2)],Game_BattlerBase[_0x86b5bc(0x2b3)][_0x86b5bc(0x1e2)]=function(_0x3891f3){const _0x1e4850=_0x86b5bc,_0x98ee94=this[_0x1e4850(0xcf)]();VisuMZ[_0x1e4850(0x33a)]['Game_BattlerBase_addNewState'][_0x1e4850(0x2bc)](this,_0x3891f3),this[_0x1e4850(0x360)]()&&_0x98ee94&&this['isDead']()&&$gameSystem[_0x1e4850(0x127)](this[_0x1e4850(0x208)](),0x1);},Game_System['prototype'][_0x86b5bc(0x1b5)]=function(_0x5d06db){const _0x192b36=_0x86b5bc;if(this[_0x192b36(0x18e)]===undefined)this[_0x192b36(0x2ae)]();return this[_0x192b36(0x18e)][_0x5d06db]=this[_0x192b36(0x18e)][_0x5d06db]||0x0,this[_0x192b36(0x18e)][_0x5d06db];},Game_System[_0x86b5bc(0x2b3)][_0x86b5bc(0x340)]=function(_0x413e02,_0x399e00){const _0x541546=_0x86b5bc;if(this['_timesEnemySeen']===undefined)this[_0x541546(0x2ae)]();this['_timesEnemySeen'][_0x413e02]=this[_0x541546(0x1ce)][_0x413e02]||0x0,this[_0x541546(0x1ce)][_0x413e02]+=_0x399e00||0x1;},VisuMZ[_0x86b5bc(0x33a)]['BattleManager_setup']=BattleManager['setup'],BattleManager[_0x86b5bc(0xf4)]=function(_0x5d66a6,_0x2e604d,_0x5ee261){const _0x17ef26=_0x86b5bc;VisuMZ[_0x17ef26(0x33a)][_0x17ef26(0x14d)][_0x17ef26(0x2bc)](this,_0x5d66a6,_0x2e604d,_0x5ee261);for(const _0x11aa46 of $gameTroop[_0x17ef26(0x2a3)]()){$gameSystem[_0x17ef26(0x340)](_0x11aa46[_0x17ef26(0x208)](),0x1);}},VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x20c)]=Game_BattlerBase[_0x86b5bc(0x2b3)][_0x86b5bc(0x2d6)],Game_BattlerBase[_0x86b5bc(0x2b3)]['refresh']=function(){const _0x377024=_0x86b5bc;this[_0x377024(0x272)]={},this[_0x377024(0x30a)]=this[_0x377024(0x30a)][_0x377024(0x1c3)](0x0,this[_0x377024(0xd0)]()),VisuMZ['Bestiary'][_0x377024(0x20c)][_0x377024(0x2bc)](this);},Game_Enemy['BESTIARY']={'defaultCategory':VisuMZ['Bestiary'][_0x86b5bc(0x2dd)]['DefaultCategory']??_0x86b5bc(0xca)},Game_Enemy[_0x86b5bc(0x2b3)][_0x86b5bc(0x15c)]=function(){const _0x128d9d=_0x86b5bc,_0x1821c4=[];for(const _0x2be546 of this[_0x128d9d(0x1b4)]()['actions']){const _0x1a7ca7=$dataSkills[_0x2be546[_0x128d9d(0x19a)]];if(_0x1a7ca7&&!_0x1821c4[_0x128d9d(0x190)](_0x1a7ca7))_0x1821c4[_0x128d9d(0x310)](_0x1a7ca7);}return _0x1821c4;},VisuMZ['Bestiary'][_0x86b5bc(0xfe)]=function(_0x4564d2,_0x3479bf){const _0x315a82=_0x86b5bc;let _0x5bd729=[];const _0x31fb4b=_0x3479bf[_0x315a82(0x1b4)]()[_0x315a82(0xb4)]||'';this[_0x315a82(0x311)](_0x5bd729,_0x4564d2,_0x31fb4b),this[_0x315a82(0x1bb)](_0x5bd729,_0x4564d2,_0x31fb4b),this['PossibleRandomSingularTraitsFromNotetags'](_0x5bd729,_0x4564d2,_0x31fb4b);if(_0x5bd729[_0x315a82(0x14f)]<=0x0){const _0xdc38cb=DataManager[_0x315a82(0xc9)](_0x4564d2);if(_0xdc38cb[_0x315a82(0x242)]){_0xdc38cb[_0x315a82(0x277)][_0x315a82(0x286)]&&_0x5bd729[_0x315a82(0x310)](_0xdc38cb['Default'][_0x315a82(0x2ff)]);for(const _0x20dbf6 in _0xdc38cb[_0x315a82(0xa9)]){_0x5bd729[_0x315a82(0x310)](_0xdc38cb[_0x315a82(0xa9)][_0x20dbf6][_0x315a82(0x2ff)]);}return _0x5bd729[_0x315a82(0x336)](_0x1ef545=>String(_0x1ef545)[_0x315a82(0x257)]()[_0x315a82(0x203)]());}}return _0x5bd729[_0x315a82(0x336)](_0x494aec=>String(_0x494aec)[_0x315a82(0x257)]()[_0x315a82(0x203)]());},VisuMZ['Bestiary']['PossibleMassTraitsFromNotetags']=function(_0x38f6d6,_0x21f7f1,_0x4019c6){const _0x5b3510=_0x86b5bc,_0x398bbb={'ELEMENT':_0x5b3510(0xd4),'SUBELEMENT':_0x5b3510(0x293),'GENDER':_0x5b3510(0x192),'RACE':_0x5b3510(0x2fc),'NATURE':_0x5b3510(0x29f),'ALIGNMENT':'Alignment','BLESSING':_0x5b3510(0x11f),'CURSE':_0x5b3510(0x1a6),'ZODIAC':'Zodiac','VARIANT':_0x5b3510(0x2c8)};if(_0x4019c6[_0x5b3510(0x297)](/<TRAIT SETS>\s*([\s\S]*)\s*<\/TRAIT SETS>/i)){const _0x1158bb=String(RegExp['$1'])[_0x5b3510(0x1b2)](/[\r\n]+/);for(const _0x542187 of _0x1158bb){if(_0x542187['match'](/(.*):[ ](.*)/i)){const _0x239731=String(RegExp['$1'])[_0x5b3510(0x257)]()[_0x5b3510(0x203)](),_0x21cd8c=String(RegExp['$2'])[_0x5b3510(0x1b2)](','),_0xadd38e=_0x398bbb[_0x239731];_0xadd38e&&_0xadd38e===_0x21f7f1&&(_0x38f6d6=_0x38f6d6[_0x5b3510(0x1f1)](_0x21cd8c));}}}},VisuMZ['Bestiary'][_0x86b5bc(0x1bb)]=function(_0x4b4d8e,_0x286676,_0x17c0e5){const _0x540958=_0x86b5bc,_0x157f67={'Element':/<ELEMENT:[ ](.*)>/i,'SubElement':/<SUBELEMENT:[ ](.*)>/i,'Gender':/<GENDER:[ ](.*)>/i,'Race':/<RACE:[ ](.*)>/i,'Nature':/<NATURE:[ ](.*)>/i,'Alignment':/<ALIGNMENT:[ ](.*)>/i,'Blessing':/<BLESSING:[ ](.*)>/i,'Curse':/<CURSE:[ ](.*)>/i,'Zodiac':/<ZODIAC:[ ](.*)>/i,'Variant':/<VARIANT:[ ](.*)>/i},_0x2a1a8e=_0x157f67[_0x286676];if(!_0x2a1a8e)return;if(_0x17c0e5['match'](/<ELEMENT:[ ](.*)\/(.*)>/i)){if(_0x286676==='Element')_0x4b4d8e[_0x540958(0x310)](String(RegExp['$1'])['trim']());if(_0x286676===_0x540958(0x293))_0x4b4d8e[_0x540958(0x310)](String(RegExp['$2'])[_0x540958(0x203)]());}else{if(_0x17c0e5[_0x540958(0x297)](_0x2a1a8e)){const _0x88e1fa=String(RegExp['$2'])[_0x540958(0x1b2)](',');_0x4b4d8e=_0x4b4d8e[_0x540958(0x1f1)](_0x88e1fa);}}},VisuMZ[_0x86b5bc(0x33a)]['PossibleRandomSingularTraitsFromNotetags']=function(_0x5f516c,_0x512915,_0x2773c3){const _0x451e49=_0x86b5bc,_0x32cd80={'Element':/<RANDOM ELEMENT>\s*([\s\S]*)\s*<\/RANDOM ELEMENT>/i,'SubElement':/<RANDOM SUBELEMENT>\s*([\s\S]*)\s*<\/RANDOM SUBELEMENT>/i,'Gender':/<RANDOM GENDER>\s*([\s\S]*)\s*<\/RANDOM GENDER>/i,'Race':/<RANDOM RACE>\s*([\s\S]*)\s*<\/RANDOM RACE>/i,'Nature':/<RANDOM NATURE>\s*([\s\S]*)\s*<\/RANDOM NATURE>/i,'Alignment':/<RANDOM ALIGNMENT>\s*([\s\S]*)\s*<\/RANDOM ALIGNMENT>/i,'Blessing':/<RANDOM BLESSING>\s*([\s\S]*)\s*<\/RANDOM BLESSING>/i,'Curse':/<RANDOM CURSE>\s*([\s\S]*)\s*<\/RANDOM CURSE>/i,'Zodiac':/<RANDOM ZODIAC>\s*([\s\S]*)\s*<\/RANDOM ZODIAC>/i,'Variant':/<RANDOM VARIANT>\s*([\s\S]*)\s*<\/RANDOM VARIANT>/i},_0x1724e0=_0x32cd80[_0x512915];if(!_0x1724e0)return;if(_0x2773c3[_0x451e49(0x297)](_0x1724e0)){const _0x431e8=String(RegExp['$1'])[_0x451e49(0x1b2)](/[\r\n]+/)[_0x451e49(0x225)]('');for(const _0x1595c4 of _0x431e8){_0x1595c4[_0x451e49(0x297)](/(.*):[ ](.*)/i)&&_0x5f516c[_0x451e49(0x310)](RegExp['$1'][_0x451e49(0x203)]());}}},VisuMZ['Bestiary'][_0x86b5bc(0x21d)]=Scene_Menu[_0x86b5bc(0x2b3)]['createCommandWindow'],Scene_Menu[_0x86b5bc(0x2b3)][_0x86b5bc(0x1ad)]=function(){const _0x30b194=_0x86b5bc;VisuMZ[_0x30b194(0x33a)][_0x30b194(0x21d)][_0x30b194(0x2bc)](this);const _0x38236a=this[_0x30b194(0x363)];_0x38236a[_0x30b194(0x10f)](_0x30b194(0x34f),this['commandBestiary'][_0x30b194(0xe4)](this));},Scene_Menu[_0x86b5bc(0x2b3)]['commandBestiary']=function(){const _0x12a797=_0x86b5bc;SceneManager[_0x12a797(0x310)](Scene_Bestiary);};function Scene_Bestiary(){const _0x5bdb8d=_0x86b5bc;this[_0x5bdb8d(0x1c7)](...arguments);}Scene_Bestiary['prototype']=Object[_0x86b5bc(0x27c)](Scene_MenuBase[_0x86b5bc(0x2b3)]),Scene_Bestiary['prototype'][_0x86b5bc(0x144)]=Scene_Bestiary,Scene_Bestiary[_0x86b5bc(0x178)]={'helpWindow_BgType':VisuMZ[_0x86b5bc(0x33a)]['Settings'][_0x86b5bc(0x1a4)]['HelpWindow_BgType']??0x0,'scaleHelpWindow':VisuMZ[_0x86b5bc(0x33a)]['Settings'][_0x86b5bc(0x1a4)][_0x86b5bc(0x23b)]??!![]},Scene_Bestiary[_0x86b5bc(0x2b3)][_0x86b5bc(0x1c7)]=function(){const _0x1a94a0=_0x86b5bc;Scene_MenuBase['prototype'][_0x1a94a0(0x1c7)]['call'](this);},Scene_Bestiary[_0x86b5bc(0x2b3)]['helpAreaHeight']=function(){return 0x0;},Scene_Bestiary[_0x86b5bc(0x2b3)][_0x86b5bc(0x350)]=function(){return!![];},Scene_Bestiary['prototype'][_0x86b5bc(0x1bc)]=function(){const _0x4c0577=_0x86b5bc;Scene_MenuBase[_0x4c0577(0x2b3)]['createPageButtons'][_0x4c0577(0x2bc)](this),this[_0x4c0577(0x1dc)][_0x4c0577(0x11a)](this[_0x4c0577(0x134)][_0x4c0577(0xe4)](this)),this[_0x4c0577(0x1e1)][_0x4c0577(0x11a)](this[_0x4c0577(0x1fb)][_0x4c0577(0xe4)](this));},Scene_Bestiary[_0x86b5bc(0x2b3)][_0x86b5bc(0x194)]=function(){const _0x305dc4=_0x86b5bc;return this['_dataCategoriesWindow']&&this[_0x305dc4(0x1e0)][_0x305dc4(0x140)];},Scene_Bestiary[_0x86b5bc(0x2b3)][_0x86b5bc(0x27c)]=function(){const _0x1c11d9=_0x86b5bc;Scene_MenuBase[_0x1c11d9(0x2b3)][_0x1c11d9(0x27c)][_0x1c11d9(0x2bc)](this),this['createEnemy'](),this[_0x1c11d9(0x1de)](),this['updatePageButtons']();},Scene_Bestiary[_0x86b5bc(0x2b3)]['isBottomHelpMode']=function(){const _0x295e8e=_0x86b5bc;if(ConfigManager[_0x295e8e(0x22e)]!==undefined){if(ConfigManager[_0x295e8e(0x22e)])return ConfigManager['uiHelpPosition'];}return Scene_MenuBase[_0x295e8e(0x2b3)][_0x295e8e(0x158)][_0x295e8e(0x2bc)](this);},Scene_Bestiary['prototype']['isRightInputMode']=function(){const _0x4995b6=_0x86b5bc;if(ConfigManager['uiMenuStyle']!==undefined){if(ConfigManager[_0x4995b6(0x22e)])return ConfigManager[_0x4995b6(0x1a1)];}return Scene_MenuBase[_0x4995b6(0x2b3)][_0x4995b6(0xab)][_0x4995b6(0x2bc)](this);},Scene_Bestiary[_0x86b5bc(0x2b3)]['createEnemy']=function(){const _0x726cb9=_0x86b5bc;this[_0x726cb9(0x23e)]=new Game_Enemy(0x1,0x0,0x0);},Scene_Bestiary[_0x86b5bc(0x2b3)][_0x86b5bc(0x1b4)]=function(){const _0x200c5c=_0x86b5bc;return this[_0x200c5c(0x23e)];},Scene_Bestiary[_0x86b5bc(0x2b3)][_0x86b5bc(0x353)]=function(_0x39d59b){const _0x30ae2e=_0x86b5bc;Math[_0x30ae2e(0x1ec)]=!![],this[_0x30ae2e(0x1b4)]()['setup'](_0x39d59b,0x0,0x0),Math[_0x30ae2e(0x1ec)]=![];},Scene_Bestiary['prototype'][_0x86b5bc(0x1de)]=function(){const _0x25cc50=_0x86b5bc;this['createNameWindow'](),this['createSubWindow'](),this['createListWindow'](),this[_0x25cc50(0x2fa)](),this[_0x25cc50(0x2b9)](),this[_0x25cc50(0x31b)](),this[_0x25cc50(0x206)](),this[_0x25cc50(0x215)](),this[_0x25cc50(0xaf)](),this['createRewardsDataWindow'](),this[_0x25cc50(0x196)](),this[_0x25cc50(0x1d6)]();},Scene_Bestiary[_0x86b5bc(0x2b3)][_0x86b5bc(0x31b)]=function(){const _0x5b0646=_0x86b5bc;Scene_MenuBase[_0x5b0646(0x2b3)][_0x5b0646(0x31b)][_0x5b0646(0x2bc)](this);if(Scene_Bestiary[_0x5b0646(0x178)][_0x5b0646(0x2db)]){const _0x1ed372=this[_0x5b0646(0x1eb)]();this[_0x5b0646(0x302)][_0x5b0646(0x2c1)]['x']=this[_0x5b0646(0x302)]['scale']['y']=_0x1ed372;}this[_0x5b0646(0x302)]['setBackgroundType'](Scene_Bestiary[_0x5b0646(0x178)][_0x5b0646(0x123)]),this[_0x5b0646(0x302)][_0x5b0646(0x2a9)]();},Scene_Bestiary[_0x86b5bc(0x2b3)]['helpWindowRatio']=function(){const _0x5e7f04=_0x86b5bc;if(!Scene_Bestiary[_0x5e7f04(0x178)][_0x5e7f04(0x2db)])return 0x1;return this[_0x5e7f04(0xbb)]()['width']/Graphics[_0x5e7f04(0x21c)];},Scene_Bestiary['prototype'][_0x86b5bc(0x19b)]=function(){const _0x5d6462=_0x86b5bc;if(VisuMZ[_0x5d6462(0x33a)][_0x5d6462(0x2dd)][_0x5d6462(0x1a4)][_0x5d6462(0x2fb)])return VisuMZ[_0x5d6462(0x33a)][_0x5d6462(0x2dd)][_0x5d6462(0x1a4)][_0x5d6462(0x2fb)][_0x5d6462(0x2bc)](this);const _0x58b15f=this[_0x5d6462(0xbb)](),_0x25261b=this[_0x5d6462(0x1eb)](),_0x3cbcc8=Graphics[_0x5d6462(0x21c)],_0x5c0e25=this['calcWindowHeight'](0x2,![]),_0x4ff554=_0x58b15f['x'],_0x40482a=_0x58b15f['y']+(this[_0x5d6462(0x158)]()?_0x58b15f['height']-_0x5c0e25*_0x25261b:0x0);return new Rectangle(_0x4ff554,_0x40482a,_0x3cbcc8,_0x5c0e25);},Scene_Bestiary[_0x86b5bc(0x2b3)][_0x86b5bc(0x2fe)]=function(){const _0x7cf6e1=_0x86b5bc,_0x468a40=this[_0x7cf6e1(0x243)](),_0x57e850=new Window_BestiaryName(_0x468a40);_0x57e850[_0x7cf6e1(0x290)](),this[_0x7cf6e1(0x205)](_0x57e850),this[_0x7cf6e1(0x29b)]=_0x57e850,_0x57e850[_0x7cf6e1(0x1c9)](Window_BestiaryName[_0x7cf6e1(0x178)][_0x7cf6e1(0x1f8)]);},Scene_Bestiary['prototype'][_0x86b5bc(0x243)]=function(){const _0x5e6509=_0x86b5bc;if(VisuMZ[_0x5e6509(0x33a)][_0x5e6509(0x2dd)]['Window']['NameWindow_RectJS'])return VisuMZ[_0x5e6509(0x33a)][_0x5e6509(0x2dd)][_0x5e6509(0x1a4)]['NameWindow_RectJS'][_0x5e6509(0x2bc)](this);const _0x28ff1c=Graphics[_0x5e6509(0x21c)],_0x1406a6=this[_0x5e6509(0x316)](0x1,![]),_0xa00249=0x0,_0x3f49c2=this['mainAreaTop']();return new Rectangle(_0xa00249,_0x3f49c2,_0x28ff1c,_0x1406a6);},Scene_Bestiary[_0x86b5bc(0x2b3)][_0x86b5bc(0x17b)]=function(){const _0x38d738=_0x86b5bc,_0x3b8be0=this['subWindowRect'](),_0x3709c9=new Window_BestiarySub(_0x3b8be0);this[_0x38d738(0x205)](_0x3709c9),this['_subWindow']=_0x3709c9,_0x3709c9[_0x38d738(0x1c9)](Window_BestiarySub[_0x38d738(0x178)]['bgType']);},Scene_Bestiary[_0x86b5bc(0x2b3)][_0x86b5bc(0x274)]=function(){const _0x226dba=_0x86b5bc;if(VisuMZ[_0x226dba(0x33a)][_0x226dba(0x2dd)][_0x226dba(0x1a4)][_0x226dba(0x335)])return VisuMZ[_0x226dba(0x33a)][_0x226dba(0x2dd)][_0x226dba(0x1a4)][_0x226dba(0x335)]['call'](this);const _0x4d0797=Graphics[_0x226dba(0x21c)],_0x1d9912=this[_0x226dba(0x316)](0x1,![]),_0x727dcd=0x0,_0x2e4a0a=this[_0x226dba(0x24c)]()-_0x1d9912;return new Rectangle(_0x727dcd,_0x2e4a0a,_0x4d0797,_0x1d9912);},Scene_Bestiary[_0x86b5bc(0x2b3)]['createListWindow']=function(){const _0x116234=_0x86b5bc,_0xa7cff7=this[_0x116234(0x186)](),_0x18c1da=new Window_BestiaryEnemyList(_0xa7cff7);_0x18c1da['setSubWindow'](this[_0x116234(0x2c2)]),_0x18c1da[_0x116234(0x10f)]('category',this['toggleEnemyCategory'][_0x116234(0xe4)](this)),_0x18c1da['setHandler'](_0x116234(0x1b4),this[_0x116234(0x298)]['bind'](this)),_0x18c1da[_0x116234(0x10f)](_0x116234(0x24d),this[_0x116234(0x261)][_0x116234(0xe4)](this)),this[_0x116234(0x205)](_0x18c1da),this['_listWindow']=_0x18c1da,_0x18c1da[_0x116234(0x1c9)](Window_BestiaryEnemyList[_0x116234(0x178)][_0x116234(0x1f8)]);},Scene_Bestiary[_0x86b5bc(0x2b3)][_0x86b5bc(0x186)]=function(){const _0x38d98f=_0x86b5bc;if(VisuMZ[_0x38d98f(0x33a)][_0x38d98f(0x2dd)][_0x38d98f(0x1a4)][_0x38d98f(0x292)])return VisuMZ[_0x38d98f(0x33a)][_0x38d98f(0x2dd)][_0x38d98f(0x1a4)][_0x38d98f(0x292)][_0x38d98f(0x2bc)](this);const _0x2ca97b=Math[_0x38d98f(0x259)](Graphics[_0x38d98f(0x21c)]*0x4/0xa),_0x1c369e=this[_0x38d98f(0x124)]()-this[_0x38d98f(0x316)](0x1,![])*0x2,_0x2ab859=this[_0x38d98f(0xab)]()?Graphics[_0x38d98f(0x21c)]-_0x2ca97b:0x0,_0x44b084=this[_0x38d98f(0xed)]()+this['calcWindowHeight'](0x1,![]);return new Rectangle(_0x2ab859,_0x44b084,_0x2ca97b,_0x1c369e);},Scene_Bestiary[_0x86b5bc(0x2b3)][_0x86b5bc(0x2fa)]=function(){const _0x515252=_0x86b5bc,_0x41e225=this['imageWindowRect'](),_0x1c9ac4=new Window_BestiaryEnemyImage(_0x41e225);this[_0x515252(0x1d0)][_0x515252(0x181)](_0x1c9ac4),this[_0x515252(0x205)](_0x1c9ac4),this[_0x515252(0xba)]=_0x1c9ac4,_0x1c9ac4[_0x515252(0x1c9)](Window_BestiaryEnemyImage[_0x515252(0x178)][_0x515252(0x1f8)]);},Scene_Bestiary['prototype'][_0x86b5bc(0xbb)]=function(){const _0x91d197=_0x86b5bc;if(VisuMZ['Bestiary']['Settings']['Window'][_0x91d197(0xaa)])return VisuMZ[_0x91d197(0x33a)]['Settings']['Window'][_0x91d197(0xaa)]['call'](this);const _0x229b22=Graphics[_0x91d197(0x21c)]-Math[_0x91d197(0x259)](Graphics[_0x91d197(0x21c)]*0x4/0xa),_0x2a4d69=this[_0x91d197(0x124)]()-this[_0x91d197(0x316)](0x1,![])*0x2,_0x10e94c=this[_0x91d197(0xab)]()?0x0:Graphics['boxWidth']-_0x229b22,_0x13660f=this['mainAreaTop']()+this['calcWindowHeight'](0x1,![]);return new Rectangle(_0x10e94c,_0x13660f,_0x229b22,_0x2a4d69);},Scene_Bestiary['prototype'][_0x86b5bc(0x2b9)]=function(){const _0xa88e26=_0x86b5bc,_0x3c36fc=this[_0xa88e26(0x189)](),_0x56c655=new Window_BestiaryDataCategories(_0x3c36fc);_0x56c655[_0xa88e26(0x10f)](_0xa88e26(0x1d3),this[_0xa88e26(0x1b8)]['bind'](this)),_0x56c655[_0xa88e26(0x10f)]('elements',this['onDataCategoriesOpen'][_0xa88e26(0xe4)](this)),_0x56c655[_0xa88e26(0x10f)](_0xa88e26(0x15c),this[_0xa88e26(0x1b8)]['bind'](this)),_0x56c655[_0xa88e26(0x10f)]('rewards',this[_0xa88e26(0x1b8)]['bind'](this)),_0x56c655['setHandler'](_0xa88e26(0xd5),this['onDataCategoriesOpen']['bind'](this)),_0x56c655[_0xa88e26(0x10f)]('lore',this[_0xa88e26(0x1b8)][_0xa88e26(0xe4)](this)),_0x56c655['setHandler']('pageup',this[_0xa88e26(0x134)][_0xa88e26(0xe4)](this)),_0x56c655[_0xa88e26(0x10f)](_0xa88e26(0x329),this[_0xa88e26(0x1fb)]['bind'](this)),_0x56c655[_0xa88e26(0x10f)]('cancel',this[_0xa88e26(0x304)][_0xa88e26(0xe4)](this)),this[_0xa88e26(0x205)](_0x56c655),this[_0xa88e26(0x1e0)]=_0x56c655,_0x56c655[_0xa88e26(0x1c9)](Window_BestiaryDataCategories[_0xa88e26(0x178)][_0xa88e26(0x1f8)]);},Scene_Bestiary[_0x86b5bc(0x2b3)][_0x86b5bc(0x189)]=function(){const _0x3ea527=_0x86b5bc;if(VisuMZ[_0x3ea527(0x33a)][_0x3ea527(0x2dd)][_0x3ea527(0x1a4)][_0x3ea527(0x1db)])return VisuMZ[_0x3ea527(0x33a)][_0x3ea527(0x2dd)]['Window'][_0x3ea527(0x1db)][_0x3ea527(0x2bc)](this);const _0x4053fa=this[_0x3ea527(0x186)]()[_0x3ea527(0x32b)],_0x187b33=this[_0x3ea527(0x316)](0x1,!![]),_0xf8c5b8=this[_0x3ea527(0x186)]()['x'],_0x3d15d4=this[_0x3ea527(0xed)]()+this[_0x3ea527(0x316)](0x1,![]);return new Rectangle(_0xf8c5b8,_0x3d15d4,_0x4053fa,_0x187b33);},Scene_Bestiary['prototype']['dataWindowRect']=function(){const _0x26fb38=_0x86b5bc;if(VisuMZ[_0x26fb38(0x33a)][_0x26fb38(0x2dd)][_0x26fb38(0x1a4)][_0x26fb38(0x1d8)])return VisuMZ['Bestiary'][_0x26fb38(0x2dd)][_0x26fb38(0x1a4)][_0x26fb38(0x1d8)][_0x26fb38(0x2bc)](this);const _0xb639c9=this[_0x26fb38(0x186)]()['width'],_0x5a0e2e=this[_0x26fb38(0x124)]()-this[_0x26fb38(0x316)](0x1,!![])-this[_0x26fb38(0x316)](0x1,![])*0x2,_0x2ddedb=this[_0x26fb38(0x186)]()['x'],_0x1fa068=this[_0x26fb38(0xed)]()+this[_0x26fb38(0x316)](0x1,![])+this[_0x26fb38(0x316)](0x1,!![]);return new Rectangle(_0x2ddedb,_0x1fa068,_0xb639c9,_0x5a0e2e);},Scene_Bestiary[_0x86b5bc(0x2b3)][_0x86b5bc(0x206)]=function(){const _0x431237=_0x86b5bc,_0x59a783=this['dataWindowRect'](),_0x4a1b2=new Window_BestiaryBasic(_0x59a783);this[_0x431237(0x1e0)]['setSymbolWindow'](_0x4a1b2,_0x431237(0x1d3)),_0x4a1b2['setHandler'](_0x431237(0x20f),this['onBasicDataLevelChange'][_0x431237(0xe4)](this,'max')),_0x4a1b2[_0x431237(0x10f)](_0x431237(0xdc),this[_0x431237(0x35b)][_0x431237(0xe4)](this,'up')),_0x4a1b2[_0x431237(0x10f)](_0x431237(0x35e),this[_0x431237(0x35b)]['bind'](this,_0x431237(0x183))),_0x4a1b2[_0x431237(0x10f)](_0x431237(0x13a),this[_0x431237(0x35b)][_0x431237(0xe4)](this,_0x431237(0x1f5))),_0x4a1b2[_0x431237(0x10f)](_0x431237(0x24d),this[_0x431237(0x2e2)]['bind'](this)),this[_0x431237(0x205)](_0x4a1b2),this['_basicDataWindow']=_0x4a1b2,_0x4a1b2[_0x431237(0x1c9)](Window_BestiaryBasic[_0x431237(0x178)][_0x431237(0x1f8)]);},Scene_Bestiary[_0x86b5bc(0x2b3)][_0x86b5bc(0x215)]=function(){const _0x19fd66=_0x86b5bc,_0x27919c=this[_0x19fd66(0x35c)](),_0x15a89c=new Window_BestiaryElements(_0x27919c);this[_0x19fd66(0x1e0)][_0x19fd66(0x265)](_0x15a89c,_0x19fd66(0x236)),_0x15a89c[_0x19fd66(0x10f)](_0x19fd66(0x24d),this['onSymbolWindowCancel'][_0x19fd66(0xe4)](this)),this[_0x19fd66(0x205)](_0x15a89c),this[_0x19fd66(0x2c3)]=_0x15a89c,_0x15a89c[_0x19fd66(0x1c9)](Window_BestiaryElements[_0x19fd66(0x178)]['bgType']);},Scene_Bestiary[_0x86b5bc(0x2b3)][_0x86b5bc(0xaf)]=function(){const _0x541e09=_0x86b5bc,_0x46bc02=this[_0x541e09(0x35c)](),_0x4bcdf0=new Window_BestiarySkills(_0x46bc02);_0x4bcdf0[_0x541e09(0x1b6)](this[_0x541e09(0x302)]),this['_dataCategoriesWindow'][_0x541e09(0x265)](_0x4bcdf0,_0x541e09(0x15c)),_0x4bcdf0[_0x541e09(0x10f)](_0x541e09(0x24d),this[_0x541e09(0x2e2)]['bind'](this)),this[_0x541e09(0x205)](_0x4bcdf0),this['_skillsDataWindow']=_0x4bcdf0,_0x4bcdf0[_0x541e09(0x1c9)](Window_BestiarySkills[_0x541e09(0x178)][_0x541e09(0x1f8)]);},Scene_Bestiary[_0x86b5bc(0x2b3)][_0x86b5bc(0xc3)]=function(){const _0x5d86ec=_0x86b5bc,_0x2c2e64=this[_0x5d86ec(0x35c)](),_0x450eb5=new Window_BestiaryRewards(_0x2c2e64);this[_0x5d86ec(0x1e0)]['setSymbolWindow'](_0x450eb5,'rewards'),_0x450eb5[_0x5d86ec(0x10f)]('cancel',this[_0x5d86ec(0x2e2)][_0x5d86ec(0xe4)](this)),this[_0x5d86ec(0x205)](_0x450eb5),this[_0x5d86ec(0x10e)]=_0x450eb5,_0x450eb5['setBackgroundType'](Window_BestiaryRewards[_0x5d86ec(0x178)][_0x5d86ec(0x1f8)]);},Scene_Bestiary[_0x86b5bc(0x2b3)][_0x86b5bc(0x196)]=function(){const _0x2bb38d=_0x86b5bc;if(!Imported[_0x2bb38d(0x30b)])return;const _0x216d4e=this[_0x2bb38d(0x35c)](),_0x2d63bb=new Window_BestiaryTraits(_0x216d4e);_0x2d63bb[_0x2bb38d(0x1b6)](this[_0x2bb38d(0x302)]),this[_0x2bb38d(0x1e0)]['setSymbolWindow'](_0x2d63bb,_0x2bb38d(0xd5)),_0x2d63bb[_0x2bb38d(0x10f)](_0x2bb38d(0xff),this[_0x2bb38d(0x327)][_0x2bb38d(0xe4)](this)),_0x2d63bb[_0x2bb38d(0x10f)]('trait',this[_0x2bb38d(0x28f)][_0x2bb38d(0xe4)](this)),_0x2d63bb[_0x2bb38d(0x10f)](_0x2bb38d(0x24d),this[_0x2bb38d(0x2e2)]['bind'](this)),this['addWindow'](_0x2d63bb),this[_0x2bb38d(0x1ac)]=_0x2d63bb,_0x2d63bb['setBackgroundType'](Window_BestiaryTraits[_0x2bb38d(0x178)][_0x2bb38d(0x1f8)]);},Scene_Bestiary['prototype']['createLoreDataWindow']=function(){const _0x2426fa=_0x86b5bc,_0x22bf81=this[_0x2426fa(0x35c)](),_0x273186=new Window_BestiaryLore(_0x22bf81);this[_0x2426fa(0x1e0)][_0x2426fa(0x265)](_0x273186,_0x2426fa(0xd7)),_0x273186[_0x2426fa(0x10f)]('cancel',this[_0x2426fa(0x2e2)][_0x2426fa(0xe4)](this)),this['addWindow'](_0x273186),this[_0x2426fa(0x148)]=_0x273186,_0x273186[_0x2426fa(0x1c9)](Window_BestiaryLore['SETTINGS'][_0x2426fa(0x1f8)]);},Scene_Bestiary[_0x86b5bc(0x2b3)][_0x86b5bc(0x250)]=function(){const _0x2e51ed=_0x86b5bc;this['_listWindow'][_0x2e51ed(0x182)](),this[_0x2e51ed(0x1d0)][_0x2e51ed(0x285)]();},Scene_Bestiary[_0x86b5bc(0x2b3)]['viewEnemy']=function(){const _0x76a9f0=_0x86b5bc;this[_0x76a9f0(0x1d0)][_0x76a9f0(0x1c0)](this['_listWindow'][_0x76a9f0(0x202)]()),this[_0x76a9f0(0x1d0)][_0x76a9f0(0x2a9)](),this[_0x76a9f0(0x1e0)][_0x76a9f0(0xc1)](),this[_0x76a9f0(0x1e0)][_0x76a9f0(0x285)]();const _0x1745f2=this[_0x76a9f0(0x1d0)][_0x76a9f0(0x223)](),_0x44c33c=this['enemy']();this[_0x76a9f0(0x29b)][_0x76a9f0(0x1e3)](_0x44c33c),this[_0x76a9f0(0x2c2)]['setEnemy'](_0x1745f2);},Scene_Bestiary['prototype']['onDataCategoriesOpen']=function(){const _0x12b04a=_0x86b5bc;this[_0x12b04a(0x1e0)][_0x12b04a(0xd6)]();},Scene_Bestiary[_0x86b5bc(0x2b3)][_0x86b5bc(0x1fb)]=function(){const _0x4da28d=_0x86b5bc;let _0x6f5878=this[_0x4da28d(0x1d0)][_0x4da28d(0x202)]();const _0x59bca2=this[_0x4da28d(0x1d0)]['currentExt']();for(;;){_0x6f5878>=this[_0x4da28d(0x1d0)][_0x4da28d(0x11c)]()-0x1?_0x6f5878=0x0:_0x6f5878+=0x1;if(this[_0x4da28d(0x1d0)][_0x4da28d(0x162)](_0x6f5878)&&this[_0x4da28d(0x1d0)][_0x4da28d(0x270)](_0x6f5878)===_0x4da28d(0x1b4)){this[_0x4da28d(0x1d0)][_0x4da28d(0x180)](_0x6f5878),this[_0x4da28d(0x353)](this[_0x4da28d(0x1d0)]['currentExt']()),this[_0x4da28d(0x1d0)][_0x4da28d(0x1c0)](this[_0x4da28d(0x1d0)]['index']());break;}}SoundManager[_0x4da28d(0x1c8)]();if(_0x59bca2!==this['_listWindow'][_0x4da28d(0x223)]())this[_0x4da28d(0x342)]();this[_0x4da28d(0x1e0)][_0x4da28d(0x285)]();},Scene_Bestiary[_0x86b5bc(0x2b3)][_0x86b5bc(0x134)]=function(){const _0x47b194=_0x86b5bc;let _0x3ba9b8=this['_listWindow']['index']();const _0x5d5072=this[_0x47b194(0x1d0)]['currentExt']();for(;;){_0x3ba9b8<=0x0?_0x3ba9b8=this[_0x47b194(0x1d0)]['maxItems']()-0x1:_0x3ba9b8-=0x1;if(this[_0x47b194(0x1d0)][_0x47b194(0x162)](_0x3ba9b8)&&this[_0x47b194(0x1d0)][_0x47b194(0x270)](_0x3ba9b8)===_0x47b194(0x1b4)){this[_0x47b194(0x1d0)]['smoothSelect'](_0x3ba9b8),this[_0x47b194(0x353)](this[_0x47b194(0x1d0)]['currentExt']()),this[_0x47b194(0x1d0)][_0x47b194(0x1c0)](this[_0x47b194(0x1d0)][_0x47b194(0x202)]());break;}}SoundManager[_0x47b194(0x1c8)]();if(_0x5d5072!==this['_listWindow'][_0x47b194(0x223)]())this[_0x47b194(0x342)]();this[_0x47b194(0x1e0)][_0x47b194(0x285)]();},Scene_Bestiary[_0x86b5bc(0x2b3)][_0x86b5bc(0x342)]=function(){const _0x349b34=_0x86b5bc;this['_nameWindow']['setEnemyName'](this[_0x349b34(0x1b4)]()),this[_0x349b34(0x2c2)][_0x349b34(0x24b)](this[_0x349b34(0x1b4)]());},Scene_Bestiary['prototype']['onDataCategoriesCancel']=function(){const _0x4c6c8e=_0x86b5bc;this[_0x4c6c8e(0x1e0)][_0x4c6c8e(0x2a9)](),this['_listWindow'][_0x4c6c8e(0xc1)](),this[_0x4c6c8e(0x1d0)]['activate'](),this[_0x4c6c8e(0x29b)][_0x4c6c8e(0x290)](),this['_subWindow'][_0x4c6c8e(0x24b)](0x0);},Scene_Bestiary[_0x86b5bc(0x2b3)]['onSymbolWindowCancel']=function(){const _0x567c6d=_0x86b5bc;this[_0x567c6d(0x1e0)][_0x567c6d(0x285)](),this[_0x567c6d(0x1e0)]['deactivateSymbolWindow'](),this['_helpWindow'][_0x567c6d(0x2a9)]();},Scene_Bestiary[_0x86b5bc(0x2b3)][_0x86b5bc(0x35b)]=function(_0x36db6e){const _0x2f57ba=_0x86b5bc;if(_0x36db6e===_0x2f57ba(0xad))this[_0x2f57ba(0x1b4)]()['setLevel'](this[_0x2f57ba(0x1b4)]()[_0x2f57ba(0x2cf)]());else{if(_0x36db6e==='up')this[_0x2f57ba(0x1b4)]()[_0x2f57ba(0x216)](0x1);else{if(_0x36db6e===_0x2f57ba(0x183))this['enemy']()[_0x2f57ba(0x216)](-0x1);else _0x36db6e===_0x2f57ba(0x1f5)&&this['enemy']()[_0x2f57ba(0x25b)](this[_0x2f57ba(0x1b4)]()['minLevel']());}}this['_nameWindow'][_0x2f57ba(0x1e3)](this['enemy']()),this[_0x2f57ba(0x2cb)]['refresh'](),this['_basicDataWindow'][_0x2f57ba(0x285)]();},Scene_Bestiary[_0x86b5bc(0x2b3)][_0x86b5bc(0x327)]=function(){const _0xbca6ce=_0x86b5bc;this[_0xbca6ce(0x1ac)][_0xbca6ce(0x182)](),this[_0xbca6ce(0x1ac)]['activate']();},Scene_Bestiary[_0x86b5bc(0x2b3)][_0x86b5bc(0x28f)]=function(){const _0x5c877b=_0x86b5bc,_0x29ae66=this[_0x5c877b(0x1ac)]['currentExt']();this[_0x5c877b(0x1b4)]()[_0x5c877b(0x28b)](_0x29ae66[0x0],_0x29ae66[0x1]),this['updateEnemy'](),this[_0x5c877b(0x1b4)]()[_0x5c877b(0x184)](),this[_0x5c877b(0xba)][_0x5c877b(0x2d6)](),this[_0x5c877b(0x1ac)][_0x5c877b(0x2d6)](),this[_0x5c877b(0x1ac)][_0x5c877b(0x285)]();},Scene_Bestiary[_0x86b5bc(0x2b3)][_0x86b5bc(0x2f0)]=function(){const _0x1b9363=_0x86b5bc;return Scene_MenuBase[_0x1b9363(0x2b3)]['buttonAssistKey1'][_0x1b9363(0x2bc)](this);},Scene_Bestiary[_0x86b5bc(0x2b3)][_0x86b5bc(0x168)]=function(){const _0x40ebc7=_0x86b5bc;return Scene_MenuBase[_0x40ebc7(0x2b3)]['buttonAssistKey2'][_0x40ebc7(0x2bc)](this);},Scene_Bestiary[_0x86b5bc(0x2b3)][_0x86b5bc(0x1fe)]=function(){const _0xb4cfc5=_0x86b5bc;if(this[_0xb4cfc5(0x148)]&&this[_0xb4cfc5(0x148)][_0xb4cfc5(0x140)])return TextManager[_0xb4cfc5(0x2cc)]('up','down');return Scene_MenuBase[_0xb4cfc5(0x2b3)][_0xb4cfc5(0x1fe)][_0xb4cfc5(0x2bc)](this);},Scene_Bestiary['prototype'][_0x86b5bc(0xf3)]=function(){const _0x491992=_0x86b5bc;return Scene_MenuBase[_0x491992(0x2b3)][_0x491992(0xf3)][_0x491992(0x2bc)](this);},Scene_Bestiary['prototype'][_0x86b5bc(0x289)]=function(){const _0x505bed=_0x86b5bc;return Scene_MenuBase['prototype'][_0x505bed(0x289)][_0x505bed(0x2bc)](this);},Scene_Bestiary[_0x86b5bc(0x2b3)]['buttonAssistText1']=function(){const _0x450b3d=_0x86b5bc;if(this['_pageupButton']&&this['_pageupButton'][_0x450b3d(0x30d)]){if(this['_dataCategoriesWindow']&&this[_0x450b3d(0x1e0)][_0x450b3d(0x140)])return TextManager[_0x450b3d(0x33a)][_0x450b3d(0x173)][_0x450b3d(0x287)];}else{if(this[_0x450b3d(0x148)]&&this[_0x450b3d(0x148)][_0x450b3d(0x140)])return TextManager[_0x450b3d(0x33a)][_0x450b3d(0x173)][_0x450b3d(0x163)];}return Scene_MenuBase['prototype']['buttonAssistText1'][_0x450b3d(0x2bc)](this);},Scene_Bestiary[_0x86b5bc(0x2b3)][_0x86b5bc(0x1ef)]=function(){const _0x5c5fca=_0x86b5bc;return Scene_MenuBase['prototype'][_0x5c5fca(0x1ef)][_0x5c5fca(0x2bc)](this);},Scene_Bestiary[_0x86b5bc(0x2b3)][_0x86b5bc(0x233)]=function(){const _0x3853dd=_0x86b5bc;if(this[_0x3853dd(0x148)]&&this[_0x3853dd(0x148)][_0x3853dd(0x140)])return TextManager['Bestiary']['buttonAssist']['slowScrollLore'];return Scene_MenuBase[_0x3853dd(0x2b3)][_0x3853dd(0x233)][_0x3853dd(0x2bc)](this);},Scene_Bestiary[_0x86b5bc(0x2b3)]['buttonAssistText4']=function(){const _0x389848=_0x86b5bc;if(this['_listWindow']&&this[_0x389848(0x1d0)][_0x389848(0x140)]){const _0x237c02=this['_listWindow']['currentSymbol']();if(_0x237c02===_0x389848(0x1b4))return TextManager[_0x389848(0x33a)]['buttonAssist'][_0x389848(0x2b1)];else{if(_0x237c02===_0x389848(0xff)){const _0x142944=this['_listWindow'][_0x389848(0x223)]();return this[_0x389848(0x1d0)][_0x389848(0x29a)](_0x142944)?TextManager[_0x389848(0x33a)][_0x389848(0x173)]['collapse']:TextManager[_0x389848(0x33a)]['buttonAssist'][_0x389848(0x358)];}}}else{if(this['_basicDataWindow']&&this[_0x389848(0x2cb)][_0x389848(0x140)]){const _0x185234=this[_0x389848(0x2cb)][_0x389848(0x284)]();if(_0x185234!==_0x389848(0x2f1))return Scene_MenuBase['prototype'][_0x389848(0x1f3)][_0x389848(0x2bc)](this);}}return'';},Scene_Bestiary[_0x86b5bc(0x2b3)][_0x86b5bc(0x2a0)]=function(){const _0x25a685=_0x86b5bc;return Scene_MenuBase[_0x25a685(0x2b3)][_0x25a685(0x2a0)]['call'](this);},Scene_Bestiary['prototype']['createBackground']=function(){const _0x15c790=_0x86b5bc;Scene_MenuBase['prototype'][_0x15c790(0x18f)][_0x15c790(0x2bc)](this),this[_0x15c790(0x18b)](this['getBackgroundOpacity']()),this[_0x15c790(0x14c)]();},Scene_Bestiary[_0x86b5bc(0x2b3)][_0x86b5bc(0x264)]=function(){const _0x3f8d36=_0x86b5bc;return VisuMZ[_0x3f8d36(0x33a)]['Settings'][_0x3f8d36(0xa2)][_0x3f8d36(0xdf)];},Scene_Bestiary['prototype']['createCustomBackgroundImages']=function(){const _0x197bc2=_0x86b5bc,_0x468f76=VisuMZ[_0x197bc2(0x33a)]['Settings']['BgSettings'];_0x468f76&&(_0x468f76['BgFilename1']!==''||_0x468f76[_0x197bc2(0x9c)]!=='')&&(this[_0x197bc2(0x2b8)]=new Sprite(ImageManager[_0x197bc2(0x1fd)](_0x468f76[_0x197bc2(0x24f)])),this[_0x197bc2(0x117)]=new Sprite(ImageManager['loadTitle2'](_0x468f76[_0x197bc2(0x9c)])),this[_0x197bc2(0x2e1)](this['_backSprite1']),this[_0x197bc2(0x2e1)](this['_backSprite2']),this['_backSprite1'][_0x197bc2(0x1b7)]['addLoadListener'](this[_0x197bc2(0x344)][_0x197bc2(0xe4)](this,this['_backSprite1'])),this[_0x197bc2(0x117)][_0x197bc2(0x1b7)][_0x197bc2(0x150)](this[_0x197bc2(0x344)][_0x197bc2(0xe4)](this,this['_backSprite2'])));},Scene_Bestiary[_0x86b5bc(0x2b3)][_0x86b5bc(0x344)]=function(_0x388528){const _0x1d5b1e=_0x86b5bc;this[_0x1d5b1e(0xe7)](_0x388528),this['centerSprite'](_0x388528);},VisuMZ[_0x86b5bc(0x33a)]['Window_MenuCommand_addOriginalCommands']=Window_MenuCommand['prototype'][_0x86b5bc(0x258)],Window_MenuCommand[_0x86b5bc(0x2b3)][_0x86b5bc(0x258)]=function(){const _0x8540f0=_0x86b5bc;VisuMZ[_0x8540f0(0x33a)][_0x8540f0(0x2bf)][_0x8540f0(0x2bc)](this),this[_0x8540f0(0xeb)]();},Window_MenuCommand[_0x86b5bc(0x2b3)]['addBestiaryCommand']=function(){const _0x15cf4d=_0x86b5bc;if(!this[_0x15cf4d(0x33b)]())return;if(!this[_0x15cf4d(0x103)]())return;const _0x5d473e=TextManager[_0x15cf4d(0x23a)],_0x4c1d31=this[_0x15cf4d(0x299)]();this[_0x15cf4d(0x326)](_0x5d473e,_0x15cf4d(0x34f),_0x4c1d31);},Window_MenuCommand[_0x86b5bc(0x2b3)][_0x86b5bc(0x33b)]=function(){return Imported['VisuMZ_1_MainMenuCore']?![]:!![];},Window_MenuCommand['prototype'][_0x86b5bc(0x103)]=function(){const _0x52221a=_0x86b5bc;return $gameSystem[_0x52221a(0x207)]();},Window_MenuCommand[_0x86b5bc(0x2b3)]['isBestiaryCommandEnabled']=function(){const _0x128fc4=_0x86b5bc;return $gameSystem[_0x128fc4(0x28e)]();};function Window_BestiaryName(){const _0x7e3991=_0x86b5bc;this[_0x7e3991(0x1c7)](...arguments);}Window_BestiaryName[_0x86b5bc(0x2b3)]=Object['create'](Window_Base[_0x86b5bc(0x2b3)]),Window_BestiaryName['prototype'][_0x86b5bc(0x144)]=Window_BestiaryName,Window_BestiaryName[_0x86b5bc(0x178)]={'bgType':VisuMZ[_0x86b5bc(0x33a)]['Settings'][_0x86b5bc(0x1a4)][_0x86b5bc(0xa7)]??0x0},Window_BestiaryName['prototype']['initialize']=function(_0x2e5018){const _0x5d8e60=_0x86b5bc;Window_Base[_0x5d8e60(0x2b3)][_0x5d8e60(0x1c7)][_0x5d8e60(0x2bc)](this,_0x2e5018),this[_0x5d8e60(0x1cc)]='';},Window_BestiaryName[_0x86b5bc(0x2b3)][_0x86b5bc(0x2aa)]=function(_0x4be323){const _0x40406f=_0x86b5bc;this[_0x40406f(0x1cc)]!==_0x4be323&&(this[_0x40406f(0x1cc)]=_0x4be323,this[_0x40406f(0x2d6)]());},Window_BestiaryName[_0x86b5bc(0x2b3)][_0x86b5bc(0x1e3)]=function(_0x376fa5){const _0x2c4cdb=_0x86b5bc;this[_0x2c4cdb(0x2aa)](_0x376fa5[_0x2c4cdb(0x132)]());},Window_BestiaryName[_0x86b5bc(0x2b3)]['setNoEnemyText']=function(){const _0x564321=_0x86b5bc;this[_0x564321(0x2aa)](TextManager[_0x564321(0x33a)][_0x564321(0x30c)][_0x564321(0xff)]);},Window_BestiaryName[_0x86b5bc(0x2b3)][_0x86b5bc(0x1a5)]=function(){return![];},Window_BestiaryName[_0x86b5bc(0x2b3)][_0x86b5bc(0x2d6)]=function(){const _0xf9d5e8=_0x86b5bc;this[_0xf9d5e8(0x2f3)][_0xf9d5e8(0x141)]();if(this[_0xf9d5e8(0x1cc)]==='')return;const _0x11d24e=this['baseTextRect'](),_0x1d92c4=this[_0xf9d5e8(0x25c)](this['_text'])[_0xf9d5e8(0x32b)],_0x596428=_0x11d24e['x']+Math['floor']((_0x11d24e['width']-_0x1d92c4)/0x2);this[_0xf9d5e8(0x2ca)](this['_text'],_0x596428,_0x11d24e['y'],_0x11d24e[_0xf9d5e8(0x32b)]);};function Window_BestiarySub(){this['initialize'](...arguments);}Window_BestiarySub[_0x86b5bc(0x2b3)]=Object['create'](Window_Base[_0x86b5bc(0x2b3)]),Window_BestiarySub[_0x86b5bc(0x2b3)][_0x86b5bc(0x144)]=Window_BestiarySub,Window_BestiarySub[_0x86b5bc(0x178)]={'bgType':VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x2dd)][_0x86b5bc(0x1a4)][_0x86b5bc(0x1ea)]??0x0},Window_BestiarySub['prototype'][_0x86b5bc(0x1c7)]=function(_0x6fb548){const _0x8f8a7=_0x86b5bc;Window_Base[_0x8f8a7(0x2b3)][_0x8f8a7(0x1c7)][_0x8f8a7(0x2bc)](this,_0x6fb548),this[_0x8f8a7(0x167)]=null,this[_0x8f8a7(0x2d6)]();},Window_BestiarySub[_0x86b5bc(0x2b3)]['setEnemy']=function(_0x16a75f){const _0x5e8d11=_0x86b5bc;this[_0x5e8d11(0x167)]!==_0x16a75f&&(this[_0x5e8d11(0x167)]=_0x16a75f,this[_0x5e8d11(0x2d6)]());},Window_BestiarySub[_0x86b5bc(0x2b3)]['isAutoColorAffected']=function(){return![];},Window_BestiarySub['prototype'][_0x86b5bc(0x2d6)]=function(){const _0x72aff3=_0x86b5bc;this[_0x72aff3(0x2f3)][_0x72aff3(0x141)](),this[_0x72aff3(0x167)]?this[_0x72aff3(0x313)]():this[_0x72aff3(0x197)]();},Window_BestiarySub['prototype']['drawEncounterData']=function(){const _0x4d5644=_0x86b5bc,_0x18b932=TextManager[_0x4d5644(0x33a)][_0x4d5644(0x115)],_0x416da7=this[_0x4d5644(0x1e4)]()*0x10,_0x164c65=this[_0x4d5644(0x1a8)]-_0x416da7*0x2,_0x2abd07=_0x18b932['seenFmt'],_0x43205d=$gameSystem[_0x4d5644(0x1b5)](this[_0x4d5644(0x167)]),_0x28b1eb=_0x2abd07['format'](_0x43205d);this[_0x4d5644(0x2f9)](_0x28b1eb,_0x416da7,0x0,_0x164c65,'left');const _0x27b3dd=_0x18b932['defeatedFmt'],_0x1e5331=$gameSystem[_0x4d5644(0x175)](this[_0x4d5644(0x167)]),_0x33265f=_0x27b3dd['format'](_0x1e5331);this['drawText'](_0x33265f,_0x416da7,0x0,_0x164c65,_0x4d5644(0x111));},Window_BestiarySub[_0x86b5bc(0x2b3)]['drawBestiaryCompletionRate']=function(){const _0xe6f580=_0x86b5bc,_0x3a2b65=TextManager[_0xe6f580(0x33a)][_0xe6f580(0x115)],_0x677dfb=this[_0xe6f580(0x1e4)]()*0x10,_0x436660=this[_0xe6f580(0x1a8)]-_0x677dfb*0x2,_0x2c8228=_0x3a2b65[_0xe6f580(0x1e9)],_0x7ea6f7=DataManager[_0xe6f580(0x1f0)](),_0x2c2b51=$gameSystem[_0xe6f580(0x33e)](),_0x3c5fce=(_0x2c2b51/_0x7ea6f7*0x64)[_0xe6f580(0x13c)](_0x3a2b65[_0xe6f580(0x2c9)]),_0x5e5ac1=_0x2c8228[_0xe6f580(0x2df)](_0x3c5fce,_0x2c2b51,_0x7ea6f7);this['drawText'](_0x5e5ac1,_0x677dfb,0x0,_0x436660,_0xe6f580(0x359));};function Window_BestiaryEnemyList(){const _0x2401ab=_0x86b5bc;this[_0x2401ab(0x1c7)](...arguments);}Window_BestiaryEnemyList[_0x86b5bc(0x2b3)]=Object[_0x86b5bc(0x27c)](Window_Command[_0x86b5bc(0x2b3)]),Window_BestiaryEnemyList[_0x86b5bc(0x2b3)][_0x86b5bc(0x144)]=Window_BestiaryEnemyList,Window_BestiaryEnemyList[_0x86b5bc(0x178)]={'bgType':VisuMZ[_0x86b5bc(0x33a)]['Settings'][_0x86b5bc(0x1a4)]['ListWindow_BgType']??0x0,'delayMs':VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x2dd)][_0x86b5bc(0x1a4)][_0x86b5bc(0x305)]??0xf0,'maskUndefeatedEnemyNames':VisuMZ[_0x86b5bc(0x33a)]['Settings'][_0x86b5bc(0x1a4)][_0x86b5bc(0x213)]??!![]},Window_BestiaryEnemyList[_0x86b5bc(0x2b3)]['initialize']=function(_0x10c0a8){const _0x2b5d17=_0x86b5bc;this['initCategoryStatus'](),Window_Command[_0x2b5d17(0x2b3)]['initialize'][_0x2b5d17(0x2bc)](this,_0x10c0a8);},Window_BestiaryEnemyList[_0x86b5bc(0x2b3)][_0x86b5bc(0x263)]=function(){const _0x5a8414=_0x86b5bc;this[_0x5a8414(0xe5)]={};const _0x78c839=VisuMZ['Bestiary']['CategoryOrder'];for(const _0x36f896 of _0x78c839){if(!this[_0x5a8414(0x1c2)](_0x36f896))continue;this[_0x5a8414(0xe5)][_0x36f896['toLowerCase']()['trim']()]=!![];}},Window_BestiaryEnemyList[_0x86b5bc(0x2b3)][_0x86b5bc(0x1a5)]=function(){return![];},Window_BestiaryEnemyList[_0x86b5bc(0x2b3)][_0x86b5bc(0x2e5)]=function(){const _0x51e9be=_0x86b5bc,_0x13bab8=VisuMZ[_0x51e9be(0x33a)][_0x51e9be(0xd2)];for(const _0x57077 of _0x13bab8){if(!this[_0x51e9be(0x1c2)](_0x57077))continue;this[_0x51e9be(0x2b6)](_0x57077);}},Window_BestiaryEnemyList['prototype'][_0x86b5bc(0x1c2)]=function(_0x4183db){const _0x476acf=_0x86b5bc;_0x4183db=_0x4183db[_0x476acf(0x244)]()[_0x476acf(0x203)]();const _0x19a88d=DataManager[_0x476acf(0xf7)](_0x4183db);if(_0x19a88d['length']<=0x0)return![];if($gameTemp[_0x476acf(0x251)]())return!![];if(Game_Enemy[_0x476acf(0x23d)][_0x476acf(0x1e6)][_0x476acf(0x244)]()===_0x4183db)return!![];return _0x19a88d[_0x476acf(0x2f8)](_0x574348=>$gameSystem['timesEnemySeen'](_0x574348['id'])>0x0);},Window_BestiaryEnemyList['prototype'][_0x86b5bc(0x29a)]=function(_0x5d4a79){const _0x2f9818=_0x86b5bc;return _0x5d4a79=_0x5d4a79[_0x2f9818(0x244)]()[_0x2f9818(0x203)](),this[_0x2f9818(0xe5)][_0x5d4a79];},Window_BestiaryEnemyList[_0x86b5bc(0x2b3)][_0x86b5bc(0x2b6)]=function(_0x44f314){const _0xebfa26=_0x86b5bc;_0x44f314=_0x44f314['toLowerCase']()['trim']();const _0x33f47b=VisuMZ[_0xebfa26(0x33a)]['CategoryData'][_0x44f314];if(!_0x33f47b)return;const _0x1a9864=this['isCategoryOpen'](_0x44f314)?TextManager[_0xebfa26(0x33a)][_0xebfa26(0x1d7)][_0xebfa26(0x171)]:TextManager[_0xebfa26(0x33a)][_0xebfa26(0x1d7)][_0xebfa26(0x195)],_0x209ce1=DataManager[_0xebfa26(0xf7)](_0x44f314),_0x2d90bc=_0x209ce1[_0xebfa26(0x14f)],_0x5a44b5=_0x209ce1[_0xebfa26(0x100)](_0x4045cc=>$gameSystem[_0xebfa26(0x113)](_0x4045cc['id']))[_0xebfa26(0x14f)],_0x244e37=(_0x5a44b5/_0x2d90bc*0x64)[_0xebfa26(0x1c3)](0x0,0x64)['toFixed'](TextManager[_0xebfa26(0x33a)][_0xebfa26(0x1d7)]['fixedPercentage']),_0x161e13=_0x1a9864['format'](_0x33f47b[_0xebfa26(0x315)],_0x244e37);this[_0xebfa26(0x326)](_0x161e13,_0xebfa26(0xff),!![],_0x44f314),this[_0xebfa26(0x1c1)](_0x44f314);},Window_BestiaryEnemyList['prototype'][_0x86b5bc(0x182)]=function(){const _0x412494=_0x86b5bc,_0x100ff9=this[_0x412494(0x143)]();this[_0x412494(0xe5)][_0x100ff9]=!this[_0x412494(0xe5)][_0x100ff9],this[_0x412494(0x2d6)]();},Window_BestiaryEnemyList[_0x86b5bc(0x2b3)][_0x86b5bc(0x143)]=function(){const _0x196de1=_0x86b5bc;return this['currentSymbol']()===_0x196de1(0xff)?this[_0x196de1(0x223)]():null;},Window_BestiaryEnemyList['prototype'][_0x86b5bc(0x1c1)]=function(_0x1a6178){const _0x24129e=_0x86b5bc;if(!this['isCategoryOpen'](_0x1a6178))return;const _0x24bd32=DataManager[_0x24129e(0xf7)](_0x1a6178);for(const _0x317360 of _0x24bd32){if(!this[_0x24129e(0x309)](_0x317360))continue;this[_0x24129e(0x20d)](_0x317360);}},Window_BestiaryEnemyList[_0x86b5bc(0x2b3)][_0x86b5bc(0x309)]=function(_0x349127){const _0x32a1b5=_0x86b5bc;return DataManager[_0x32a1b5(0x152)](_0x349127);},Window_BestiaryEnemyList['prototype'][_0x86b5bc(0x256)]=function(_0x296abe){const _0x587ce3=_0x86b5bc;if($gameTemp[_0x587ce3(0x251)]())return!![];return $gameSystem['isEnemyDefeated'](_0x296abe['id']);},Window_BestiaryEnemyList[_0x86b5bc(0x2b3)][_0x86b5bc(0x20d)]=function(_0x2fbee5){const _0x5acb2d=_0x86b5bc;let _0x31e1cf=_0x2fbee5[_0x5acb2d(0x132)];this[_0x5acb2d(0x2bb)](_0x2fbee5)&&(_0x31e1cf=Array(_0x2fbee5[_0x5acb2d(0x132)]['length']+0x1)[_0x5acb2d(0xfc)](TextManager[_0x5acb2d(0x33a)][_0x5acb2d(0x1d7)][_0x5acb2d(0x18c)])),this['addCommand']('\x20\x20'+_0x31e1cf,_0x5acb2d(0x1b4),this['isEnabledEnemy'](_0x2fbee5),_0x2fbee5['id']);},Window_BestiaryEnemyList[_0x86b5bc(0x2b3)][_0x86b5bc(0x2bb)]=function(_0x2790e8){const _0x16f1f3=_0x86b5bc;if($gameTemp[_0x16f1f3(0x251)]())return![];if($gameSystem[_0x16f1f3(0x113)](_0x2790e8['id']))return![];if($gameSystem[_0x16f1f3(0x1b5)](_0x2790e8['id'])>0x0)return![];return Window_BestiaryEnemyList[_0x16f1f3(0x178)][_0x16f1f3(0x1f4)];},Window_BestiaryEnemyList[_0x86b5bc(0x2b3)][_0x86b5bc(0x355)]=function(){const _0x31130f=_0x86b5bc;return _0x31130f(0x170);},Window_BestiaryEnemyList[_0x86b5bc(0x2b3)][_0x86b5bc(0x114)]=function(_0x3e4ca1){const _0xf03eb6=_0x86b5bc,_0x390d55=this['itemLineRect'](_0x3e4ca1),_0x1c4914=this[_0xf03eb6(0x25e)](_0x3e4ca1),_0x16edf=this[_0xf03eb6(0x25c)](_0x1c4914)['width'];this[_0xf03eb6(0x254)](this[_0xf03eb6(0x162)](_0x3e4ca1));const _0x3b7e0b=this[_0xf03eb6(0x355)]();if(_0x3b7e0b===_0xf03eb6(0x111))this[_0xf03eb6(0x2ca)](_0x1c4914,_0x390d55['x']+_0x390d55[_0xf03eb6(0x32b)]-_0x16edf,_0x390d55['y'],_0x16edf);else{if(_0x3b7e0b==='center'){const _0xc9895d=_0x390d55['x']+Math[_0xf03eb6(0x2e7)]((_0x390d55['width']-_0x16edf)/0x2);this['drawTextEx'](_0x1c4914,_0xc9895d,_0x390d55['y'],_0x16edf);}else this[_0xf03eb6(0x2ca)](_0x1c4914,_0x390d55['x'],_0x390d55['y'],_0x16edf);}},Window_BestiaryEnemyList[_0x86b5bc(0x2b3)][_0x86b5bc(0x181)]=function(_0x459f86){const _0x3819b5=_0x86b5bc;this['_imageWindow']=_0x459f86,this[_0x3819b5(0x1ca)]();},Window_BestiaryEnemyList[_0x86b5bc(0x2b3)][_0x86b5bc(0x2ed)]=function(_0x4be31f){const _0x4705b2=_0x86b5bc;this['_subWindow']=_0x4be31f,this[_0x4705b2(0x1ca)]();},Window_BestiaryEnemyList[_0x86b5bc(0x2b3)][_0x86b5bc(0x1ca)]=function(){const _0x5131e2=_0x86b5bc;Window_Command[_0x5131e2(0x2b3)][_0x5131e2(0x1ca)][_0x5131e2(0x2bc)](this);const _0x3cd095=this[_0x5131e2(0x202)](),_0x5accc1=Window_BestiaryEnemyList[_0x5131e2(0x178)][_0x5131e2(0x29d)];this[_0x5131e2(0xba)]&&setTimeout(this['callUpdateImage'][_0x5131e2(0xe4)](this,_0x3cd095),_0x5accc1),this[_0x5131e2(0x2c2)]&&setTimeout(this[_0x5131e2(0x28a)][_0x5131e2(0xe4)](this,_0x3cd095),_0x5accc1);},Window_BestiaryEnemyList['prototype']['callUpdateImage']=function(_0x378321){const _0x262b0a=_0x86b5bc;if(_0x378321!==this[_0x262b0a(0x202)]())return;if(this[_0x262b0a(0x260)]===_0x378321)return;this[_0x262b0a(0x260)]=_0x378321;const _0x199e73=this[_0x262b0a(0x284)]();_0x199e73==='enemy'?this[_0x262b0a(0xba)][_0x262b0a(0x19e)](this['currentExt']()):this[_0x262b0a(0xba)]['setEnemyID'](0x0);},Window_BestiaryEnemyList['prototype']['callUpdateSubWindow']=function(_0x2e97f0){const _0x13f7eb=_0x86b5bc;if(_0x2e97f0!==this['index']())return;const _0x31a468=this['currentSymbol']();_0x31a468===_0x13f7eb(0x1b4)?this['_subWindow'][_0x13f7eb(0x24b)](this['currentExt']()):this[_0x13f7eb(0x2c2)][_0x13f7eb(0x24b)](0x0);};function Window_BestiaryEnemyImage(){const _0x538e7e=_0x86b5bc;this[_0x538e7e(0x1c7)](...arguments);}Window_BestiaryEnemyImage[_0x86b5bc(0x2b3)]=Object[_0x86b5bc(0x27c)](Window_Base[_0x86b5bc(0x2b3)]),Window_BestiaryEnemyImage[_0x86b5bc(0x2b3)]['constructor']=Window_BestiaryEnemyImage,Window_BestiaryEnemyImage['SETTINGS']={'bgType':VisuMZ['Bestiary']['Settings']['Window']['ImageWindow_BgType']??0x0,'blurFilterStrength':VisuMZ['Bestiary'][_0x86b5bc(0x2dd)][_0x86b5bc(0x1a4)][_0x86b5bc(0x131)]??0x8,'defaultBattleback1':VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x2dd)]['Window'][_0x86b5bc(0xc5)]??_0x86b5bc(0x312),'defaultBattleback2':VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x2dd)][_0x86b5bc(0x1a4)][_0x86b5bc(0x34d)]??_0x86b5bc(0x312),'padding':VisuMZ['Bestiary']['Settings'][_0x86b5bc(0x1a4)][_0x86b5bc(0x10d)]??0x4},Window_BestiaryEnemyImage['prototype'][_0x86b5bc(0x1c7)]=function(_0x7df844){const _0x3a7e80=_0x86b5bc;Window_Base[_0x3a7e80(0x2b3)][_0x3a7e80(0x1c7)][_0x3a7e80(0x2bc)](this,_0x7df844),this[_0x3a7e80(0x31d)](),this['createEnemySprite'](),this[_0x3a7e80(0x34b)](),this[_0x3a7e80(0xa0)]();},Window_BestiaryEnemyImage['prototype'][_0x86b5bc(0x295)]=function(){const _0x598e46=_0x86b5bc;this[_0x598e46(0x107)]=Window_BestiaryEnemyImage[_0x598e46(0x178)][_0x598e46(0x107)];},Window_BestiaryEnemyImage['prototype'][_0x86b5bc(0x31d)]=function(){const _0x2d0fc5=_0x86b5bc;this[_0x2d0fc5(0x328)]=new Sprite(),this[_0x2d0fc5(0x149)]=new Sprite(),this[_0x2d0fc5(0xc7)](this[_0x2d0fc5(0x328)]),this[_0x2d0fc5(0xc7)](this[_0x2d0fc5(0x149)]),this[_0x2d0fc5(0x328)][_0x2d0fc5(0x2af)]['x']=this[_0x2d0fc5(0x328)][_0x2d0fc5(0x2af)]['y']=0.5,this[_0x2d0fc5(0x149)][_0x2d0fc5(0x2af)]['x']=this['_battlebackSprite2'][_0x2d0fc5(0x2af)]['y']=0.5;},Window_BestiaryEnemyImage[_0x86b5bc(0x2b3)][_0x86b5bc(0xf2)]=function(){const _0x506bec=_0x86b5bc;this['_enemySprite']=new Sprite(),this[_0x506bec(0xc7)](this[_0x506bec(0x31f)]),this[_0x506bec(0x31f)][_0x506bec(0x2af)]['x']=this['_enemySprite'][_0x506bec(0x2af)]['y']=0.5;},Window_BestiaryEnemyImage[_0x86b5bc(0x2b3)][_0x86b5bc(0x34b)]=function(){const _0x23494=_0x86b5bc;if(!Imported[_0x23494(0x31e)])return;this[_0x23494(0x25f)]=null,this[_0x23494(0x11b)]=new Sprite(),this['addInnerChild'](this[_0x23494(0x11b)]);},Window_BestiaryEnemyImage[_0x86b5bc(0x2b3)][_0x86b5bc(0xa0)]=function(){const _0x250b5e=_0x86b5bc,_0xc361ac=Window_BestiaryEnemyImage[_0x250b5e(0x178)][_0x250b5e(0x317)];this[_0x250b5e(0xc8)]=new PIXI[(_0x250b5e(0x154))]['BlurFilter'](_0xc361ac),this[_0x250b5e(0x31f)][_0x250b5e(0x154)]=[this[_0x250b5e(0xc8)]],this['_dragonbonesSpriteContainer']&&(this[_0x250b5e(0x11b)]['filters']=[this[_0x250b5e(0xc8)]]);},Window_BestiaryEnemyImage[_0x86b5bc(0x2b3)]['setEnemyID']=function(_0x2ed31c){const _0x4752ed=_0x86b5bc;if(!SceneManager[_0x4752ed(0xb3)]['updateEnemyID'])return;if(this[_0x4752ed(0x167)]!==_0x2ed31c){if(_0x2ed31c>0x0)SceneManager[_0x4752ed(0xb3)][_0x4752ed(0x353)](_0x2ed31c);this[_0x4752ed(0x167)]=_0x2ed31c,this[_0x4752ed(0x2d6)]();}},Window_BestiaryEnemyImage[_0x86b5bc(0x2b3)][_0x86b5bc(0x2d6)]=function(){const _0x45368a=_0x86b5bc;this[_0x45368a(0x118)]();if(this['_enemyID']<=0x0)return;this[_0x45368a(0x155)](),this['updateEnemyImage']();},Window_BestiaryEnemyImage[_0x86b5bc(0x2b3)][_0x86b5bc(0x118)]=function(){const _0x55c2c1=_0x86b5bc;this[_0x55c2c1(0x31f)]['visible']=this[_0x55c2c1(0x167)]>0x0,this[_0x55c2c1(0x328)]['visible']=this[_0x55c2c1(0x167)]>0x0,this[_0x55c2c1(0x149)]['visible']=this[_0x55c2c1(0x167)]>0x0,this[_0x55c2c1(0x31f)]['x']=Math['round'](this[_0x55c2c1(0x1a8)]/0x2),this[_0x55c2c1(0x31f)]['y']=Math[_0x55c2c1(0x133)](this[_0x55c2c1(0x29c)]/0x2),this[_0x55c2c1(0x31f)][_0x55c2c1(0x2c1)]['x']=Math[_0x55c2c1(0x139)](this[_0x55c2c1(0x31f)][_0x55c2c1(0x2c1)]['x']),this[_0x55c2c1(0x328)]['x']=this[_0x55c2c1(0x149)]['x']=Math[_0x55c2c1(0x133)](this[_0x55c2c1(0x1a8)]/0x2),this[_0x55c2c1(0x328)]['y']=this[_0x55c2c1(0x149)]['y']=Math[_0x55c2c1(0x133)](this['innerHeight']/0x2);},Window_BestiaryEnemyImage[_0x86b5bc(0x2b3)][_0x86b5bc(0x155)]=function(){const _0x231dec=_0x86b5bc;this[_0x231dec(0x328)]['bitmap']=ImageManager[_0x231dec(0x13d)](this['_enemyID']),this[_0x231dec(0x149)]['bitmap']=ImageManager[_0x231dec(0x151)](this[_0x231dec(0x167)]);},Window_BestiaryEnemyImage[_0x86b5bc(0x2b3)][_0x86b5bc(0x2d2)]=function(){const _0x1db157=_0x86b5bc,_0x2fb1aa=SceneManager[_0x1db157(0xb3)][_0x1db157(0x1b4)](),_0x523bb2=_0x2fb1aa[_0x1db157(0x164)]();this['disposeDragonbones']();if(ImageManager['bestiaryEnemyCustomImageFilename'](this[_0x1db157(0x167)])!==''){const _0x29cd70=ImageManager['bestiaryEnemyCustomImageFilename'](this[_0x1db157(0x167)]);_0x29cd70[_0x1db157(0x150)](this[_0x1db157(0x204)][_0x1db157(0xe4)](this,_0x29cd70,0x0));}else{if(this[_0x1db157(0x1dd)]()){const _0x1ba50c=new Bitmap(0x1,0x1);this['processDragonbones'](),this[_0x1db157(0x204)](_0x1ba50c,0x0);}else{if(this[_0x1db157(0x9f)]()){const _0x6b2d27=this[_0x1db157(0x2cd)],_0x8efe4=ImageManager[_0x1db157(0x325)](_0x6b2d27);_0x8efe4[_0x1db157(0x150)](this[_0x1db157(0x300)][_0x1db157(0xe4)](this,_0x6b2d27,_0x8efe4,0x0));}else{if($gameSystem[_0x1db157(0x15d)]()){const _0x2ed5f1=ImageManager[_0x1db157(0x108)](_0x2fb1aa[_0x1db157(0x2d9)]());_0x2ed5f1['addLoadListener'](this[_0x1db157(0x204)][_0x1db157(0xe4)](this,_0x2ed5f1,_0x523bb2));}else{const _0x13bf52=ImageManager[_0x1db157(0x318)](_0x2fb1aa[_0x1db157(0x2d9)]());_0x13bf52[_0x1db157(0x150)](this[_0x1db157(0x204)][_0x1db157(0xe4)](this,_0x13bf52,_0x523bb2));}}}}},Window_BestiaryEnemyImage[_0x86b5bc(0x2b3)][_0x86b5bc(0x1dd)]=function(){const _0x181eff=_0x86b5bc;if(!Imported[_0x181eff(0x31e)])return![];const _0x11fe45=SceneManager[_0x181eff(0xb3)][_0x181eff(0x1b4)]();return _0x11fe45[_0x181eff(0x1df)]()['battler']!==''?(this[_0x181eff(0x136)]=_0x11fe45[_0x181eff(0x1df)](),!![]):![];},Window_BestiaryEnemyImage[_0x86b5bc(0x2b3)][_0x86b5bc(0x9f)]=function(){const _0x1cb848=_0x86b5bc;if(!Imported[_0x1cb848(0x210)])return![];const _0x1dd695=SceneManager[_0x1cb848(0xb3)][_0x1cb848(0x1b4)]();return _0x1dd695[_0x1cb848(0xe3)]()?(this[_0x1cb848(0x2cd)]=_0x1dd695['svBattlerData']()[_0x1cb848(0x132)],!![]):![];},Window_BestiaryEnemyImage[_0x86b5bc(0x2b3)]['processFullEnemyImage']=function(_0x16ec00,_0x27799e){const _0x54a340=_0x86b5bc;this['_enemySprite'][_0x54a340(0x1b7)]=_0x16ec00,this[_0x54a340(0x31f)]['setHue'](_0x27799e),this[_0x54a340(0x31f)][_0x54a340(0x303)](0x0,0x0,_0x16ec00[_0x54a340(0x32b)],_0x16ec00[_0x54a340(0x2dc)]),this['updateFilters'](),this[_0x54a340(0x31f)][_0x54a340(0x19f)]();},Window_BestiaryEnemyImage[_0x86b5bc(0x2b3)][_0x86b5bc(0x300)]=function(_0x56dd81,_0x596b44,_0x14f233){const _0x2a4313=_0x86b5bc;this[_0x2a4313(0x31f)][_0x2a4313(0x1b7)]=_0x596b44,this['_enemySprite'][_0x2a4313(0x17a)](_0x14f233);const _0x54a186=Math['floor'](_0x596b44[_0x2a4313(0x32b)]/ImageManager['svActorHorzCells']),_0x356fe8=Math[_0x2a4313(0x2e7)](_0x596b44[_0x2a4313(0x2dc)]/ImageManager[_0x2a4313(0x26e)]);this['_enemySprite'][_0x2a4313(0x303)](0x0,0x0,_0x54a186,_0x356fe8),this[_0x2a4313(0x31f)]['scale']['x']*=-0x1,this[_0x2a4313(0xd3)](),this[_0x2a4313(0x31f)][_0x2a4313(0x19f)]();},Window_BestiaryEnemyImage['prototype']['processDragonbones']=function(){const _0x1b7be7=_0x86b5bc;this[_0x1b7be7(0x12d)]();const _0x5c9c6b=this[_0x1b7be7(0x136)];this[_0x1b7be7(0x160)]=_0x5c9c6b[_0x1b7be7(0x2b7)],armatureName=_0x5c9c6b[_0x1b7be7(0x2b7)],DragonbonesManager[_0x1b7be7(0x31c)](armatureName,this[_0x1b7be7(0x11d)][_0x1b7be7(0xe4)](this));const _0x22da48=this[_0x1b7be7(0x11b)];_0x22da48&&(_0x22da48['x']=Math[_0x1b7be7(0x133)](this[_0x1b7be7(0x1a8)]/0x2),_0x22da48['y']=Math[_0x1b7be7(0x133)](this[_0x1b7be7(0x29c)]/0x2),_0x22da48['y']+=Math['round'](_0x5c9c6b[_0x1b7be7(0x2dc)]/0x2));},Window_BestiaryEnemyImage[_0x86b5bc(0x2b3)][_0x86b5bc(0x12d)]=function(){const _0xae7aa6=_0x86b5bc;this['_dragonbones']&&(this[_0xae7aa6(0x11b)]&&this['_dragonbonesSpriteContainer'][_0xae7aa6(0x16a)](this['_dragonbones']),this[_0xae7aa6(0x16a)](this['_dragonbones']),this[_0xae7aa6(0x25f)][_0xae7aa6(0x1a7)](),delete this[_0xae7aa6(0x25f)],delete this[_0xae7aa6(0x160)]);},Window_BestiaryEnemyImage['prototype'][_0x86b5bc(0x11d)]=function(){const _0x3e6461=_0x86b5bc,_0x260498=this[_0x3e6461(0x136)];this[_0x3e6461(0x25f)]=DragonbonesManager[_0x3e6461(0x15a)](_0x260498['battler']),!this['_dragonbonesSpriteContainer']&&(this[_0x3e6461(0x11b)]=new Sprite(),this[_0x3e6461(0x11b)][_0x3e6461(0x154)]=[this[_0x3e6461(0xc8)]]),this['_dragonbonesSpriteContainer'][_0x3e6461(0x2e1)](this[_0x3e6461(0x25f)]),this[_0x3e6461(0x232)](),this['_dragonbones']['x']=_0x260498[_0x3e6461(0x2c0)],this[_0x3e6461(0x25f)]['y']=_0x260498[_0x3e6461(0x146)],this[_0x3e6461(0x25f)][_0x3e6461(0x2c1)]['x']=_0x260498[_0x3e6461(0xe6)],this[_0x3e6461(0x25f)][_0x3e6461(0x2c1)]['y']=_0x260498[_0x3e6461(0x12a)];},Window_BestiaryEnemyImage['prototype'][_0x86b5bc(0x232)]=function(){const _0x2d2d34=_0x86b5bc,_0x359fb6=_0x2d2d34(0x18a),_0x536cbb=this[_0x2d2d34(0x25f)]['animation'];_0x536cbb[_0x2d2d34(0x33c)][_0x359fb6]&&_0x536cbb['play'](_0x359fb6);},Window_BestiaryEnemyImage[_0x86b5bc(0x2b3)]['updateFilters']=function(){const _0x1e17c4=_0x86b5bc;this[_0x1e17c4(0xc4)]()?(this[_0x1e17c4(0xc8)][_0x1e17c4(0x14a)]=![],this[_0x1e17c4(0x31f)][_0x1e17c4(0x99)]([0x0,0x0,0x0,0x0]),this[_0x1e17c4(0x11b)]&&this['_dragonbonesSpriteContainer'][_0x1e17c4(0x99)]([0x0,0x0,0x0,0x0])):(this[_0x1e17c4(0xc8)]['enabled']=!![],this[_0x1e17c4(0x31f)]['setColorTone']([-0xff,-0xff,-0xff,0x0]),this[_0x1e17c4(0x11b)]&&this['_dragonbonesSpriteContainer'][_0x1e17c4(0x99)]([-0xff,-0xff,-0xff,0x0]));},Window_BestiaryEnemyImage['prototype'][_0x86b5bc(0xc4)]=function(){const _0x2f1b8f=_0x86b5bc;if($gameTemp['canDebugViewBestiary']())return!![];if($gameSystem[_0x2f1b8f(0x113)](this[_0x2f1b8f(0x167)]))return!![];if($gameSystem[_0x2f1b8f(0x1b5)](this[_0x2f1b8f(0x167)])>0x0)return!![];return![];};function Window_BestiaryDataCategories(){const _0x2f83ad=_0x86b5bc;this[_0x2f83ad(0x1c7)](...arguments);}Window_BestiaryDataCategories[_0x86b5bc(0x2b3)]=Object[_0x86b5bc(0x27c)](Window_HorzCommand[_0x86b5bc(0x2b3)]),Window_BestiaryDataCategories[_0x86b5bc(0x2b3)][_0x86b5bc(0x144)]=Window_BestiaryDataCategories,Window_BestiaryDataCategories[_0x86b5bc(0x178)]={'bgType':VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x2dd)]['Window'][_0x86b5bc(0x109)]??0x0,'commandStyle':VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x2dd)][_0x86b5bc(0x1a4)][_0x86b5bc(0x1e8)]??_0x86b5bc(0x26b),'commandOrder':VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x2dd)][_0x86b5bc(0x1a4)][_0x86b5bc(0x2a1)]??[_0x86b5bc(0x1d3),_0x86b5bc(0x236),_0x86b5bc(0x15c),_0x86b5bc(0x1d9),_0x86b5bc(0xd5),_0x86b5bc(0xd7)],'commands':{'basic':{'show':!![],'text':VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x2dd)][_0x86b5bc(0x12b)]['BasicText']??_0x86b5bc(0x24e),'icon':VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x2dd)][_0x86b5bc(0x12b)][_0x86b5bc(0x21a)]??0x54},'elements':{'show':!![],'text':VisuMZ[_0x86b5bc(0x33a)]['Settings'][_0x86b5bc(0x12b)][_0x86b5bc(0xe0)]??_0x86b5bc(0xf5),'icon':VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x2dd)][_0x86b5bc(0x12b)][_0x86b5bc(0x159)]??0x40},'skills':{'show':!![],'text':VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x2dd)][_0x86b5bc(0x12b)]['SkillsText']??_0x86b5bc(0x2d4),'icon':VisuMZ[_0x86b5bc(0x33a)]['Settings'][_0x86b5bc(0x12b)][_0x86b5bc(0x211)]??0x4f},'rewards':{'show':!![],'text':VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x2dd)]['Vocab'][_0x86b5bc(0x32e)]??_0x86b5bc(0x1ba),'icon':VisuMZ['Bestiary'][_0x86b5bc(0x2dd)][_0x86b5bc(0x12b)]['RewardsIcon']??0x57},'traits':{'show':!![],'text':VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x2dd)]['Vocab']['TraitsText']??'Properties','icon':VisuMZ['Bestiary'][_0x86b5bc(0x2dd)][_0x86b5bc(0x12b)][_0x86b5bc(0x25a)]??0x53},'lore':{'show':!![],'text':VisuMZ['Bestiary'][_0x86b5bc(0x2dd)]['Vocab'][_0x86b5bc(0xf1)]??'Lore','icon':VisuMZ['Bestiary'][_0x86b5bc(0x2dd)][_0x86b5bc(0x12b)][_0x86b5bc(0xb7)]??0x50}}},Window_BestiaryDataCategories[_0x86b5bc(0x2b3)][_0x86b5bc(0x1c7)]=function(_0x47965c){const _0x478ff3=_0x86b5bc;Window_HorzCommand[_0x478ff3(0x2b3)][_0x478ff3(0x1c7)][_0x478ff3(0x2bc)](this,_0x47965c),this[_0x478ff3(0xa1)](_0x47965c),this[_0x478ff3(0xfb)](),this[_0x478ff3(0x2a9)]();},Window_BestiaryDataCategories['prototype'][_0x86b5bc(0x214)]=function(){const _0x2b9779=_0x86b5bc;return this['_list']?this['_list'][_0x2b9779(0x14f)]:0x1;},Window_BestiaryDataCategories[_0x86b5bc(0x2b3)][_0x86b5bc(0x1ca)]=function(){const _0x2bf618=_0x86b5bc;Window_HorzCommand['prototype'][_0x2bf618(0x1ca)][_0x2bf618(0x2bc)](this),this[_0x2bf618(0x221)]&&this[_0x2bf618(0x17f)](),this[_0x2bf618(0x140)]&&this[_0x2bf618(0xbe)]&&this[_0x2bf618(0x24a)]();},Window_BestiaryDataCategories['prototype']['show']=function(){const _0x5af434=_0x86b5bc;Window_HorzCommand[_0x5af434(0x2b3)][_0x5af434(0xc1)][_0x5af434(0x2bc)](this),this[_0x5af434(0x1ca)]();},Window_BestiaryDataCategories[_0x86b5bc(0x2b3)][_0x86b5bc(0x2a9)]=function(){const _0x1391bb=_0x86b5bc;Window_HorzCommand[_0x1391bb(0x2b3)][_0x1391bb(0x2a9)][_0x1391bb(0x2bc)](this),this[_0x1391bb(0x12c)]();},Window_BestiaryDataCategories[_0x86b5bc(0x2b3)]['isUseModernControls']=function(){return![];},Window_BestiaryDataCategories[_0x86b5bc(0x2b3)][_0x86b5bc(0x265)]=function(_0x507159,_0x2ff58f){const _0x2693de=_0x86b5bc;this['_symbolWindows']=this[_0x2693de(0xbe)]||{},this[_0x2693de(0xbe)][_0x2ff58f]=_0x507159,this['callUpdateHelp']();},Window_BestiaryDataCategories['prototype'][_0x86b5bc(0x24a)]=function(){const _0x171e13=_0x86b5bc;this[_0x171e13(0xbe)]=this['_symbolWindows']||{};for(const _0x17507a in this[_0x171e13(0xbe)]){_0x17507a===this[_0x171e13(0x284)]()?(this[_0x171e13(0xbe)][_0x17507a][_0x171e13(0xc1)](),this[_0x171e13(0xbe)][_0x17507a]['refresh'](),this[_0x171e13(0xbe)][_0x17507a][_0x171e13(0xfb)]()):this[_0x171e13(0xbe)][_0x17507a][_0x171e13(0x2a9)]();}},Window_BestiaryDataCategories[_0x86b5bc(0x2b3)]['hideAllSymbolWindows']=function(){const _0x3cdf46=_0x86b5bc;this[_0x3cdf46(0xbe)]=this[_0x3cdf46(0xbe)]||{};for(const _0x3a6dbb in this['_symbolWindows']){this[_0x3cdf46(0xbe)][_0x3a6dbb][_0x3cdf46(0x2a9)]();}},Window_BestiaryDataCategories[_0x86b5bc(0x2b3)][_0x86b5bc(0xd6)]=function(){const _0x4627e1=_0x86b5bc,_0x10d271=this[_0x4627e1(0x284)]();this[_0x4627e1(0xbe)][_0x10d271]?this[_0x4627e1(0xbe)][_0x10d271][_0x4627e1(0x351)]?this['_symbolWindows'][_0x10d271][_0x4627e1(0x351)]():this[_0x4627e1(0xbe)][_0x10d271][_0x4627e1(0x285)]():this['activate']();},Window_BestiaryDataCategories['prototype'][_0x86b5bc(0x267)]=function(){const _0xd8bc81=_0x86b5bc,_0x2e0421=this[_0xd8bc81(0x284)]();this[_0xd8bc81(0xbe)][_0x2e0421]?(this['_symbolWindows'][_0x2e0421][_0xd8bc81(0xfb)](),this['_symbolWindows'][_0x2e0421][_0xd8bc81(0x198)](0x0),this[_0xd8bc81(0xbe)][_0x2e0421][_0xd8bc81(0x2ac)](),this[_0xd8bc81(0xbe)][_0x2e0421]['scrollTo'](0x0,0x0)):this[_0xd8bc81(0x285)]();},Window_BestiaryDataCategories[_0x86b5bc(0x2b3)][_0x86b5bc(0xa1)]=function(_0x27a73b){const _0x5116fc=_0x86b5bc,_0x9635eb=new Rectangle(0x0,0x0,_0x27a73b[_0x5116fc(0x32b)],_0x27a73b[_0x5116fc(0x2dc)]);this[_0x5116fc(0x221)]=new Window_Base(_0x9635eb),this[_0x5116fc(0x221)]['opacity']=0x0,this[_0x5116fc(0x2e1)](this[_0x5116fc(0x221)]),this['updateCommandNameWindow']();},Window_BestiaryDataCategories['prototype']['updateCommandNameWindow']=function(){const _0x593063=_0x86b5bc,_0x1bc7fd=this[_0x593063(0x221)];_0x1bc7fd[_0x593063(0x2f3)][_0x593063(0x141)]();const _0x26a2d5=this[_0x593063(0x2be)](this[_0x593063(0x202)]());if(_0x26a2d5==='icon'){const _0x178139=this['itemLineRect'](this[_0x593063(0x202)]());let _0x412625=this[_0x593063(0x25e)](this[_0x593063(0x202)]());_0x412625=_0x412625[_0x593063(0x228)](/\\I\[(\d+)\]/gi,''),_0x1bc7fd[_0x593063(0x2d1)](),this[_0x593063(0x2d5)](_0x412625,_0x178139),this[_0x593063(0x200)](_0x412625,_0x178139),this['commandNameWindowCenter'](_0x412625,_0x178139);}},Window_BestiaryDataCategories[_0x86b5bc(0x2b3)][_0x86b5bc(0x2d5)]=function(_0x1b72d9,_0x225459){},Window_BestiaryDataCategories[_0x86b5bc(0x2b3)][_0x86b5bc(0x200)]=function(_0x4af3d5,_0x41576a){const _0x29b446=_0x86b5bc,_0x273a67=this[_0x29b446(0x221)];_0x273a67[_0x29b446(0x2f9)](_0x4af3d5,0x0,_0x41576a['y'],_0x273a67[_0x29b446(0x1a8)],_0x29b446(0x359));},Window_BestiaryDataCategories[_0x86b5bc(0x2b3)]['commandNameWindowCenter']=function(_0x2cbaea,_0xbd7eab){const _0x3da209=_0x86b5bc,_0x451c22=this[_0x3da209(0x221)],_0x1d03b8=$gameSystem['windowPadding'](),_0x57eec4=_0xbd7eab['x']+Math[_0x3da209(0x2e7)](_0xbd7eab['width']/0x2)+_0x1d03b8;_0x451c22['x']=_0x451c22['width']/-0x2+_0x57eec4,_0x451c22['y']=Math[_0x3da209(0x2e7)](_0xbd7eab['height']/0x2);},Window_BestiaryDataCategories[_0x86b5bc(0x2b3)][_0x86b5bc(0x2e5)]=function(){const _0x2f4185=_0x86b5bc;for(const _0x5be918 of Window_BestiaryDataCategories[_0x2f4185(0x178)]['commandOrder']){this['addCustomCommand'](_0x5be918);}},Window_BestiaryDataCategories[_0x86b5bc(0x2b3)][_0x86b5bc(0x30e)]=function(_0xe489e4){const _0x252fc3=_0x86b5bc,_0x18e0ae=Window_BestiaryDataCategories[_0x252fc3(0x178)][_0x252fc3(0x2a8)][_0xe489e4];if(!this['isCustomCommandVisible'](_0x18e0ae))return;const _0x384fec=_0xe489e4,_0x4e93b1=Number(_0x18e0ae[_0x252fc3(0x279)]);let _0x4c3ac3=_0x18e0ae[_0x252fc3(0x280)];_0x4e93b1>0x0&&this['commandStyle']()!==_0x252fc3(0x280)&&(_0x4c3ac3=_0x252fc3(0xa6)['format'](_0x4e93b1,_0x4c3ac3));const _0x4d75e7=this[_0x252fc3(0x32d)](_0x18e0ae);this[_0x252fc3(0x326)](_0x4c3ac3,_0x384fec,_0x4d75e7);},Window_BestiaryDataCategories[_0x86b5bc(0x2b3)][_0x86b5bc(0x2e9)]=function(_0x3b4e27){const _0x61a09d=_0x86b5bc;if(_0x3b4e27===Window_BestiaryDataCategories[_0x61a09d(0x178)][_0x61a09d(0x2a8)][_0x61a09d(0xd5)]){if(!Imported[_0x61a09d(0x30b)])return![];}return _0x3b4e27[_0x61a09d(0xc1)];},Window_BestiaryDataCategories[_0x86b5bc(0x2b3)][_0x86b5bc(0x32d)]=function(_0x30179e){return!![];},Window_BestiaryDataCategories['prototype'][_0x86b5bc(0x355)]=function(){const _0x53cad9=_0x86b5bc;return _0x53cad9(0x359);},Window_BestiaryDataCategories[_0x86b5bc(0x2b3)][_0x86b5bc(0x114)]=function(_0x41300e){const _0x3b13d6=_0x86b5bc,_0x1a1e9e=this[_0x3b13d6(0x2be)](_0x41300e);if(_0x1a1e9e===_0x3b13d6(0x276))this[_0x3b13d6(0xd1)](_0x41300e);else _0x1a1e9e===_0x3b13d6(0x279)?this[_0x3b13d6(0x2c5)](_0x41300e):Window_Command[_0x3b13d6(0x2b3)][_0x3b13d6(0x114)][_0x3b13d6(0x2bc)](this,_0x41300e);},Window_BestiaryDataCategories['prototype'][_0x86b5bc(0x21b)]=function(){const _0x56c58c=_0x86b5bc;return Window_BestiaryDataCategories[_0x56c58c(0x178)][_0x56c58c(0x21b)];},Window_BestiaryDataCategories[_0x86b5bc(0x2b3)][_0x86b5bc(0x2be)]=function(_0xa6e77b){const _0x3ca876=_0x86b5bc;if(_0xa6e77b<0x0)return _0x3ca876(0x280);const _0x42b65c=this[_0x3ca876(0x21b)]();if(_0x42b65c!=='auto')return _0x42b65c;else{if(this['maxItems']()>0x0){const _0x7a279b=this['commandName'](_0xa6e77b);if(_0x7a279b['match'](/\\I\[(\d+)\]/i)){const _0x431c9c=this[_0x3ca876(0x2b4)](_0xa6e77b),_0x30ba37=this['textSizeEx'](_0x7a279b)[_0x3ca876(0x32b)];return _0x30ba37<=_0x431c9c[_0x3ca876(0x32b)]?_0x3ca876(0x276):_0x3ca876(0x279);}}}return _0x3ca876(0x280);},Window_BestiaryDataCategories[_0x86b5bc(0x2b3)][_0x86b5bc(0xd1)]=function(_0x26e9fc){const _0x64223c=_0x86b5bc,_0x363b5a=this[_0x64223c(0x2b4)](_0x26e9fc),_0x52cf45=this[_0x64223c(0x25e)](_0x26e9fc),_0x5e59bd=this[_0x64223c(0x25c)](_0x52cf45)[_0x64223c(0x32b)];this['changePaintOpacity'](this[_0x64223c(0x162)](_0x26e9fc));const _0x1be522=this['itemTextAlign']();if(_0x1be522===_0x64223c(0x111))this[_0x64223c(0x2ca)](_0x52cf45,_0x363b5a['x']+_0x363b5a[_0x64223c(0x32b)]-_0x5e59bd,_0x363b5a['y'],_0x5e59bd);else{if(_0x1be522===_0x64223c(0x359)){const _0x3cb485=_0x363b5a['x']+Math['floor']((_0x363b5a['width']-_0x5e59bd)/0x2);this[_0x64223c(0x2ca)](_0x52cf45,_0x3cb485,_0x363b5a['y'],_0x5e59bd);}else this[_0x64223c(0x2ca)](_0x52cf45,_0x363b5a['x'],_0x363b5a['y'],_0x5e59bd);}},Window_BestiaryDataCategories['prototype'][_0x86b5bc(0x2c5)]=function(_0x264538){const _0x5bcb8f=_0x86b5bc;this[_0x5bcb8f(0x25e)](_0x264538)[_0x5bcb8f(0x297)](/\\I\[(\d+)\]/i);const _0x350747=Number(RegExp['$1'])||0x0,_0x22cf59=this[_0x5bcb8f(0x2b4)](_0x264538),_0x14b6c1=_0x22cf59['x']+Math[_0x5bcb8f(0x2e7)]((_0x22cf59[_0x5bcb8f(0x32b)]-ImageManager[_0x5bcb8f(0x26d)])/0x2),_0x22013b=_0x22cf59['y']+(_0x22cf59[_0x5bcb8f(0x2dc)]-ImageManager[_0x5bcb8f(0x2a7)])/0x2;this['drawIcon'](_0x350747,_0x14b6c1,_0x22013b);};function Window_BestiaryBasic(){this['initialize'](...arguments);}Window_BestiaryBasic[_0x86b5bc(0x2b3)]=Object[_0x86b5bc(0x27c)](Window_Command[_0x86b5bc(0x2b3)]),Window_BestiaryBasic[_0x86b5bc(0x2b3)][_0x86b5bc(0x144)]=Window_BestiaryBasic,Window_BestiaryBasic[_0x86b5bc(0x178)]={'bgType':VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x2dd)]['Window']['BasicWindow_BgType']??0x0,'showLevelChange':VisuMZ['Bestiary'][_0x86b5bc(0x2dd)]['Window'][_0x86b5bc(0x1af)]??!![]},Window_BestiaryBasic[_0x86b5bc(0x2b3)]['initialize']=function(_0x2a6a3a){const _0x322afa=_0x86b5bc;Window_Command[_0x322afa(0x2b3)]['initialize'][_0x322afa(0x2bc)](this,_0x2a6a3a),this[_0x322afa(0xfb)](),this['deselect'](),this[_0x322afa(0x2a9)]();},Window_BestiaryBasic[_0x86b5bc(0x2b3)]['becomeActive']=function(){const _0x2985e6=_0x86b5bc;this[_0x2985e6(0x285)](),this['forceSelect'](0x0),this[_0x2985e6(0x2da)](0x0,0x0);},Window_BestiaryBasic[_0x86b5bc(0x2b3)][_0x86b5bc(0x278)]=function(){const _0x4d9ca5=_0x86b5bc;if(this['currentSymbol']()!==_0x4d9ca5(0x2f1))Window_Command[_0x4d9ca5(0x2b3)][_0x4d9ca5(0x278)][_0x4d9ca5(0x2bc)](this);},Window_BestiaryBasic[_0x86b5bc(0x2b3)][_0x86b5bc(0x2e5)]=function(){const _0x597abd=_0x86b5bc;for(const _0x595938 of this[_0x597abd(0x2ea)]()){this[_0x597abd(0x326)](_0x595938,_0x597abd(0x2f1),!![],_0x595938);}this[_0x597abd(0x119)]()&&this[_0x597abd(0x29e)]();},Window_BestiaryBasic[_0x86b5bc(0x2b3)][_0x86b5bc(0x2ea)]=function(){const _0x24691d=_0x86b5bc;return Imported[_0x24691d(0x28d)]?VisuMZ[_0x24691d(0x22a)][_0x24691d(0x2dd)][_0x24691d(0xe1)]['ExtDisplayedParams']:[0x0,0x1,0x2,0x3,0x4,0x5,0x6,0x7];},Window_BestiaryBasic[_0x86b5bc(0x2b3)]['canAddLevelChange']=function(){const _0xe94252=_0x86b5bc;return Imported[_0xe94252(0x20a)]&&Window_BestiaryBasic['SETTINGS'][_0xe94252(0x1bf)];},Window_BestiaryBasic[_0x86b5bc(0x2b3)][_0x86b5bc(0x29e)]=function(){const _0x10579c=_0x86b5bc,_0xa84604=TextManager[_0x10579c(0x33a)][_0x10579c(0x34c)],_0x20c9c6=SceneManager['_scene'][_0x10579c(0x1b4)]();{const _0x4e140b=_0xa84604['levelUpToMax'],_0x194f51=_0x4e140b[_0x10579c(0x2df)](TextManager[_0x10579c(0x25d)]),_0xbaf59b=_0x20c9c6[_0x10579c(0x25d)]<_0x20c9c6[_0x10579c(0x2cf)]();this[_0x10579c(0x326)](_0x194f51,_0x10579c(0x20f),_0xbaf59b);}{const _0x4081b4=_0xa84604[_0x10579c(0xdc)],_0x2a3d84=_0x4081b4[_0x10579c(0x2df)](TextManager[_0x10579c(0x25d)]),_0x5d0e36=_0x20c9c6[_0x10579c(0x25d)]<_0x20c9c6[_0x10579c(0x2cf)]();this[_0x10579c(0x326)](_0x2a3d84,'levelUp',_0x5d0e36);}{const _0x32f7e3=_0xa84604[_0x10579c(0x35e)],_0x18e28c=_0x32f7e3[_0x10579c(0x2df)](TextManager['level']),_0x411ac5=_0x20c9c6[_0x10579c(0x25d)]>_0x20c9c6[_0x10579c(0x294)]();this[_0x10579c(0x326)](_0x18e28c,_0x10579c(0x35e),_0x411ac5);}{const _0x3c4e4f=_0xa84604[_0x10579c(0x10b)],_0x2b1dfd=_0x3c4e4f[_0x10579c(0x2df)](TextManager['level']),_0x15554d=_0x20c9c6[_0x10579c(0x25d)]>_0x20c9c6[_0x10579c(0x294)]();this['addCommand'](_0x2b1dfd,_0x10579c(0x13a),_0x15554d);}},Window_BestiaryBasic[_0x86b5bc(0x2b3)][_0x86b5bc(0x114)]=function(_0x27f7c8){const _0x542bca=_0x86b5bc,_0x20ac15=this[_0x542bca(0x270)](_0x27f7c8);_0x20ac15===_0x542bca(0x2f1)?this[_0x542bca(0x105)](_0x27f7c8):this['drawRegularItem'](_0x27f7c8);},Window_BestiaryBasic['prototype'][_0x86b5bc(0x16b)]=function(){const _0x2dcd88=_0x86b5bc;return Imported[_0x2dcd88(0x28d)]&&VisuMZ[_0x2dcd88(0x22a)]['Settings'][_0x2dcd88(0xe1)][_0x2dcd88(0xa8)];},Window_BestiaryBasic[_0x86b5bc(0x2b3)][_0x86b5bc(0x105)]=function(_0x5ae6ea){const _0x37caad=_0x86b5bc,_0x42dafb=this[_0x37caad(0x2b4)](_0x5ae6ea),_0x404f95=String(this[_0x37caad(0x25e)](_0x5ae6ea))[_0x37caad(0x257)]()[_0x37caad(0x203)](),_0x334e45=SceneManager[_0x37caad(0xb3)][_0x37caad(0x1b4)]();if(!_0x334e45)return;this[_0x37caad(0x2d1)](),this[_0x37caad(0x254)](!![]),this[_0x37caad(0x1be)](ColorManager[_0x37caad(0x1a9)]());if(Imported[_0x37caad(0x28d)]){if(this[_0x37caad(0x16b)]()){const _0x24361a=VisuMZ[_0x37caad(0x13b)](_0x404f95);this[_0x37caad(0x283)](_0x24361a,_0x42dafb['x']+0x2,_0x42dafb['y']+0x2),_0x42dafb['x']+=ImageManager[_0x37caad(0x26d)]+0x4,_0x42dafb[_0x37caad(0x32b)]-=ImageManager[_0x37caad(0x26d)]+0x4;}const _0x57b2e7=TextManager[_0x37caad(0x2f1)](_0x404f95);this[_0x37caad(0x2f9)](_0x57b2e7,_0x42dafb['x'],_0x42dafb['y'],_0x42dafb[_0x37caad(0x32b)],_0x37caad(0x170));}else{const _0x4eeb43=TextManager[_0x37caad(0x2f1)](Number(_0x404f95));this[_0x37caad(0x2f9)](_0x4eeb43,_0x42dafb['x'],_0x42dafb['y'],_0x42dafb[_0x37caad(0x32b)],'left');}this['resetFontSettings'](),this[_0x37caad(0x1be)](ColorManager['normalColor']());if(Imported[_0x37caad(0x28d)]){const _0xdc25e9=_0x334e45[_0x37caad(0x2ee)](_0x404f95,!![]);this[_0x37caad(0x2f9)](_0xdc25e9,_0x42dafb['x'],_0x42dafb['y'],_0x42dafb['width'],'right');}else{const _0x5e261f=_0x334e45[_0x37caad(0x2f1)](Number(_0x404f95));this[_0x37caad(0x2f9)](_0x5e261f,_0x42dafb['x'],_0x42dafb['y'],_0x42dafb[_0x37caad(0x32b)],'right');}},Window_BestiaryBasic[_0x86b5bc(0x2b3)]['itemTextAlign']=function(){return'left';},Window_BestiaryBasic['prototype']['drawRegularItem']=function(_0x3d3143){const _0x5a7cc5=_0x86b5bc,_0x2137e4=this['itemLineRect'](_0x3d3143),_0x3a923b=this[_0x5a7cc5(0x25e)](_0x3d3143),_0x3d6d73=this[_0x5a7cc5(0x25c)](_0x3a923b)[_0x5a7cc5(0x32b)];this[_0x5a7cc5(0x254)](this[_0x5a7cc5(0x162)](_0x3d3143));const _0x26b0a0=this[_0x5a7cc5(0x355)]();if(_0x26b0a0===_0x5a7cc5(0x111))this[_0x5a7cc5(0x2ca)](_0x3a923b,_0x2137e4['x']+_0x2137e4['width']-_0x3d6d73,_0x2137e4['y'],_0x3d6d73);else{if(_0x26b0a0===_0x5a7cc5(0x359)){const _0x25ff1e=_0x2137e4['x']+Math[_0x5a7cc5(0x2e7)]((_0x2137e4['width']-_0x3d6d73)/0x2);this[_0x5a7cc5(0x2ca)](_0x3a923b,_0x25ff1e,_0x2137e4['y'],_0x3d6d73);}else this[_0x5a7cc5(0x2ca)](_0x3a923b,_0x2137e4['x'],_0x2137e4['y'],_0x3d6d73);}};function Window_BestiaryElements(){const _0x349f60=_0x86b5bc;this[_0x349f60(0x1c7)](...arguments);}Window_BestiaryElements['prototype']=Object[_0x86b5bc(0x27c)](Window_Command['prototype']),Window_BestiaryElements[_0x86b5bc(0x2b3)]['constructor']=Window_BestiaryElements,Window_BestiaryElements[_0x86b5bc(0x178)]={'bgType':VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x2dd)][_0x86b5bc(0x1a4)]['ElementsWindow_BgType']??0x0},Window_BestiaryElements['prototype'][_0x86b5bc(0x1c7)]=function(_0x473cdf){const _0x376e18=_0x86b5bc;Window_Command[_0x376e18(0x2b3)][_0x376e18(0x1c7)][_0x376e18(0x2bc)](this,_0x473cdf),this[_0x376e18(0xfb)](),this[_0x376e18(0x2ac)](),this[_0x376e18(0x2a9)]();},Window_BestiaryElements[_0x86b5bc(0x2b3)][_0x86b5bc(0x351)]=function(){const _0x3aa92d=_0x86b5bc;this[_0x3aa92d(0x285)](),this[_0x3aa92d(0x198)](0x0),this['scrollTo'](0x0,0x0);},Window_BestiaryElements[_0x86b5bc(0x2b3)]['playOkSound']=function(){},Window_BestiaryElements[_0x86b5bc(0x2b3)][_0x86b5bc(0x2e5)]=function(){const _0x400eb6=_0x86b5bc;for(let _0xbae83e=0x1;_0xbae83e<$dataSystem[_0x400eb6(0x236)]['length'];_0xbae83e++){if(this[_0x400eb6(0x14e)](_0xbae83e))continue;const _0x10559f=$dataSystem[_0x400eb6(0x236)][_0xbae83e];this[_0x400eb6(0x326)](_0x10559f,_0x400eb6(0x236),!![],_0xbae83e);}},Window_BestiaryElements['prototype']['isElementIDExcluded']=function(_0x169e99){const _0xb471f0=_0x86b5bc;if(_0x169e99<=0x0)return!![];if(Imported[_0xb471f0(0x30b)]){if(VisuMZ['ElementStatusCore'][_0xb471f0(0x2dd)][_0xb471f0(0x357)][_0xb471f0(0xef)][_0xb471f0(0x190)](_0x169e99))return!![];}return![];},Window_BestiaryElements['prototype'][_0x86b5bc(0x114)]=function(_0x4403fb){const _0x286972=_0x86b5bc,_0x1d3c31=this[_0x286972(0x2b4)](_0x4403fb),_0x268d7c=this[_0x286972(0x25e)](_0x4403fb),_0x5c3f00=this[_0x286972(0x21f)][_0x4403fb][_0x286972(0x1cf)];this['resetFontSettings'](),this[_0x286972(0x254)](this[_0x286972(0x162)](_0x4403fb)),this[_0x286972(0x2ca)](_0x268d7c,_0x1d3c31['x'],_0x1d3c31['y'],_0x1d3c31[_0x286972(0x32b)]);const _0x18670d=SceneManager['_scene'][_0x286972(0x1b4)](),_0x27b3b8=_0x18670d[_0x286972(0x245)](_0x5c3f00),_0x33d120=TextManager[_0x286972(0x33a)][_0x286972(0x188)];let _0x6c0af6=_0x33d120[_0x286972(0x1aa)];if(Imported[_0x286972(0x30b)]&&_0x18670d[_0x286972(0x346)]()['includes'](_0x5c3f00))_0x6c0af6=_0x33d120[_0x286972(0x1cb)];else{if(_0x27b3b8>1.05)_0x6c0af6=_0x33d120['weak'];else{if(_0x27b3b8<=0x0)_0x6c0af6=_0x33d120['immune'];else _0x27b3b8<0.95&&(_0x6c0af6=_0x33d120[_0x286972(0x22c)]);}}const _0xfe330d=_0x1d3c31['x']+_0x1d3c31['width']-this[_0x286972(0x25c)](_0x6c0af6)[_0x286972(0x32b)];this[_0x286972(0x2ca)](_0x6c0af6,_0xfe330d,_0x1d3c31['y'],_0x1d3c31[_0x286972(0x32b)]);};function Window_BestiarySkills(){const _0x4f00b3=_0x86b5bc;this[_0x4f00b3(0x1c7)](...arguments);}Window_BestiarySkills[_0x86b5bc(0x2b3)]=Object[_0x86b5bc(0x27c)](Window_Command['prototype']),Window_BestiarySkills[_0x86b5bc(0x2b3)][_0x86b5bc(0x144)]=Window_BestiarySkills,Window_BestiarySkills[_0x86b5bc(0x178)]={'bgType':VisuMZ[_0x86b5bc(0x33a)]['Settings']['Window']['SkillsWindow_BgType']??0x0},Window_BestiarySkills[_0x86b5bc(0x2b3)]['initialize']=function(_0xc595e8){const _0x347839=_0x86b5bc;Window_Command[_0x347839(0x2b3)][_0x347839(0x1c7)][_0x347839(0x2bc)](this,_0xc595e8),this[_0x347839(0xfb)](),this['deselect'](),this[_0x347839(0x2a9)]();},Window_BestiarySkills[_0x86b5bc(0x2b3)]['becomeActive']=function(){const _0x5a9c08=_0x86b5bc;this[_0x5a9c08(0x285)](),this[_0x5a9c08(0x198)](0x0),this[_0x5a9c08(0x2da)](0x0,0x0),this['_helpWindow']&&this[_0x5a9c08(0x302)][_0x5a9c08(0xc1)]();},Window_BestiarySkills['prototype'][_0x86b5bc(0x278)]=function(){},Window_BestiarySkills['prototype'][_0x86b5bc(0x2e5)]=function(){const _0x7b80d6=_0x86b5bc,_0x5c34d9=SceneManager[_0x7b80d6(0xb3)][_0x7b80d6(0x1b4)](),_0x2383ba=_0x5c34d9[_0x7b80d6(0x15c)]()[_0x7b80d6(0x1a0)]((_0x1e60fd,_0x5c1283)=>_0x1e60fd['id']-_0x5c1283['id'])[_0x7b80d6(0x100)]((_0x4c1d8b,_0x230902,_0x42fe08)=>_0x42fe08[_0x7b80d6(0x22d)](_0x4c1d8b)===_0x230902);for(const _0x37406f of _0x2383ba){if(this[_0x7b80d6(0x1b9)](_0x37406f))continue;this['addCommand'](_0x37406f['id'],_0x7b80d6(0x1fa),!![],_0x37406f['id']);}},Window_BestiarySkills['prototype'][_0x86b5bc(0x1b9)]=function(_0x4a9d25){const _0x4f3657=_0x86b5bc;if(!_0x4a9d25)return!![];const _0x41f107=VisuMZ[_0x4f3657(0x33a)][_0x4f3657(0x2a5)],_0x4cee85=_0x4a9d25['note']||'';if(_0x4cee85[_0x4f3657(0x297)](_0x41f107['hideSkill']))return!![];return![];},Window_BestiarySkills[_0x86b5bc(0x2b3)]['drawItem']=function(_0x25e68a){const _0x24a455=_0x86b5bc,_0x488022=this[_0x24a455(0x2b4)](_0x25e68a),_0x1cecdc=this['commandName'](_0x25e68a),_0x19a804=this[_0x24a455(0x2b5)](_0x1cecdc);this[_0x24a455(0x2d1)](),this[_0x24a455(0x254)](this[_0x24a455(0x162)](_0x25e68a)),this[_0x24a455(0x2ca)](_0x19a804,_0x488022['x'],_0x488022['y'],_0x488022[_0x24a455(0x32b)]);},Window_BestiarySkills[_0x86b5bc(0x2b3)][_0x86b5bc(0x2b5)]=function(_0x5e57d9){const _0x3e5022=_0x86b5bc,_0x4fc4fa=$dataSkills[_0x5e57d9];let _0x4f12f2=_0x4fc4fa[_0x3e5022(0x132)],_0x2264d9=_0x4fc4fa[_0x3e5022(0x314)];if(Imported['VisuMZ_1_BattleCore']){const _0x4ecdc9=_0x4fc4fa[_0x3e5022(0xb4)]||'';_0x4ecdc9[_0x3e5022(0x297)](/<DISPLAY ICON: (\d+)>/i)&&(_0x2264d9=Number(RegExp['$1'])),_0x4ecdc9[_0x3e5022(0x297)](/<DISPLAY TEXT: (.*)>/i)&&(_0x4f12f2=String(RegExp['$1']));}return'\x5cI[%2]%1'[_0x3e5022(0x2df)](_0x4f12f2,_0x2264d9);},Window_BestiarySkills[_0x86b5bc(0x2b3)][_0x86b5bc(0x126)]=function(){const _0x50286d=_0x86b5bc,_0x18f488=this[_0x50286d(0x223)]()?$dataSkills[this[_0x50286d(0x223)]()]:null;this['_helpWindow'][_0x50286d(0x2de)](_0x18f488);};function Window_BestiaryRewards(){const _0x134306=_0x86b5bc;this[_0x134306(0x1c7)](...arguments);}Window_BestiaryRewards[_0x86b5bc(0x2b3)]=Object[_0x86b5bc(0x27c)](Window_Command[_0x86b5bc(0x2b3)]),Window_BestiaryRewards['prototype'][_0x86b5bc(0x144)]=Window_BestiaryRewards,Window_BestiaryRewards[_0x86b5bc(0x178)]={'bgType':VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x2dd)][_0x86b5bc(0x1a4)][_0x86b5bc(0x1ab)]??0x0,'rewardsOrder':VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x2dd)]['Window'][_0x86b5bc(0x10a)]??[_0x86b5bc(0x239),'ap','cp','jp','sp',_0x86b5bc(0xf9),_0x86b5bc(0x35a)],'expIcon':VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x2dd)][_0x86b5bc(0x1a4)]['EXP_Icon']??0x57,'goldIcon':VisuMZ[_0x86b5bc(0x33a)]['Settings']['Window'][_0x86b5bc(0xa5)]??0x13a},Window_BestiaryRewards[_0x86b5bc(0x2b3)][_0x86b5bc(0x1c7)]=function(_0x1b5c98){const _0x14cddf=_0x86b5bc;Window_Command[_0x14cddf(0x2b3)]['initialize'][_0x14cddf(0x2bc)](this,_0x1b5c98),this['deactivate'](),this[_0x14cddf(0x2ac)](),this[_0x14cddf(0x2a9)]();},Window_BestiaryRewards['prototype'][_0x86b5bc(0x351)]=function(){const _0x500710=_0x86b5bc;this[_0x500710(0x285)](),this['forceSelect'](0x0),this[_0x500710(0x2da)](0x0,0x0);},Window_BestiaryRewards[_0x86b5bc(0x2b3)][_0x86b5bc(0x278)]=function(){},Window_BestiaryRewards[_0x86b5bc(0x2b3)]['makeCommandList']=function(){const _0x214a82=_0x86b5bc,_0x18588b=Window_BestiaryRewards['SETTINGS'][_0x214a82(0xc0)];Math[_0x214a82(0x1ec)]=!![],SceneManager[_0x214a82(0xb3)][_0x214a82(0x1b4)]()['_visualDrops']=undefined;for(const _0x338600 of _0x18588b){if(_0x338600==='exp')this[_0x214a82(0x1b1)]();if(_0x338600==='ap')this[_0x214a82(0x2f6)]();if(_0x338600==='cp')this[_0x214a82(0xac)]();if(_0x338600==='jp')this['addJpCommand']();if(_0x338600==='sp')this['addSpCommand']();if(_0x338600===_0x214a82(0xf9))this[_0x214a82(0x320)]();if(_0x338600===_0x214a82(0x35a))this[_0x214a82(0x16c)]();}Math['_noRandom']=![];},Window_BestiaryRewards[_0x86b5bc(0x2b3)][_0x86b5bc(0x1b1)]=function(){const _0x3c7449=_0x86b5bc,_0x2e8e89=SceneManager[_0x3c7449(0xb3)][_0x3c7449(0x1b4)](),_0xc16766=_0x2e8e89[_0x3c7449(0x239)](),_0x106bf6=TextManager[_0x3c7449(0x333)],_0x19dd56=Window_BestiaryRewards[_0x3c7449(0x178)][_0x3c7449(0x11e)];let _0x2527cd=_0x19dd56>0x0?_0x3c7449(0xa6)['format'](_0x19dd56,_0x106bf6):_0x106bf6;this[_0x3c7449(0x326)](_0x2527cd,_0x3c7449(0x1d9),!![],_0xc16766);},Window_BestiaryRewards['prototype']['addApCommand']=function(){const _0x4bc76c=_0x86b5bc;if(!Imported['VisuMZ_2_SkillLearnSystem'])return;if(!VisuMZ[_0x4bc76c(0x2f4)][_0x4bc76c(0x2dd)][_0x4bc76c(0x116)][_0x4bc76c(0x330)])return;const _0x395aea=SceneManager[_0x4bc76c(0xb3)][_0x4bc76c(0x1b4)](),_0x3c888d=_0x395aea[_0x4bc76c(0x32c)](),_0x76a615=TextManager[_0x4bc76c(0x319)],_0x40345e=ImageManager[_0x4bc76c(0x226)];let _0x4171a1=_0x40345e>0x0?_0x4bc76c(0xa6)[_0x4bc76c(0x2df)](_0x40345e,_0x76a615):_0x76a615;this['addCommand'](_0x4171a1,_0x4bc76c(0x1d9),!![],_0x3c888d);},Window_BestiaryRewards[_0x86b5bc(0x2b3)][_0x86b5bc(0xac)]=function(){const _0x1626c7=_0x86b5bc;if(!Imported[_0x1626c7(0x2e3)])return;if(!VisuMZ[_0x1626c7(0x1ae)][_0x1626c7(0x2dd)][_0x1626c7(0x234)][_0x1626c7(0x330)])return;const _0x4cfecb=SceneManager[_0x1626c7(0xb3)][_0x1626c7(0x1b4)](),_0x4da118=_0x4cfecb['classPoints'](),_0x36784a=TextManager['classPointsAbbr'],_0xc8c005=ImageManager[_0x1626c7(0xd9)];let _0x3e493f=_0xc8c005>0x0?_0x1626c7(0xa6)[_0x1626c7(0x2df)](_0xc8c005,_0x36784a):_0x36784a;this['addCommand'](_0x3e493f,'rewards',!![],_0x4da118);},Window_BestiaryRewards['prototype'][_0x86b5bc(0x2e0)]=function(){const _0x363677=_0x86b5bc;if(!Imported[_0x363677(0x2e3)])return;if(!VisuMZ['ClassChangeSystem']['Settings']['JobPoints'][_0x363677(0x330)])return;const _0x3a1034=SceneManager[_0x363677(0xb3)]['enemy'](),_0x24abb7=_0x3a1034['jobPoints'](),_0x4df058=TextManager[_0x363677(0x9a)],_0xce66c4=ImageManager[_0x363677(0x288)];let _0x518782=_0xce66c4>0x0?_0x363677(0xa6)[_0x363677(0x2df)](_0xce66c4,_0x4df058):_0x4df058;this[_0x363677(0x326)](_0x518782,'rewards',!![],_0x24abb7);},Window_BestiaryRewards[_0x86b5bc(0x2b3)][_0x86b5bc(0x306)]=function(){const _0x180d2b=_0x86b5bc;if(!Imported[_0x180d2b(0x209)])return;if(!VisuMZ[_0x180d2b(0x2f4)]['Settings'][_0x180d2b(0x145)][_0x180d2b(0x330)])return;const _0x1f9179=SceneManager[_0x180d2b(0xb3)][_0x180d2b(0x1b4)](),_0x3f2713=_0x1f9179['skillPoints'](),_0x57dcd1=TextManager['skillPointsAbbr'],_0x52cef9=ImageManager[_0x180d2b(0x35d)];let _0x269345=_0x52cef9>0x0?_0x180d2b(0xa6)['format'](_0x52cef9,_0x57dcd1):_0x57dcd1;this[_0x180d2b(0x326)](_0x269345,_0x180d2b(0x1d9),!![],_0x3f2713);},Window_BestiaryRewards[_0x86b5bc(0x2b3)]['addGoldCommand']=function(){const _0x47f9b1=_0x86b5bc,_0x525c6f=SceneManager[_0x47f9b1(0xb3)][_0x47f9b1(0x1b4)](),_0x5db7ea=_0x525c6f[_0x47f9b1(0xf9)](),_0x25edef=TextManager['currencyUnit'],_0xe55c97=Window_BestiaryRewards['SETTINGS']['goldIcon'];let _0x22d3dd=_0xe55c97>0x0?_0x47f9b1(0xa6)[_0x47f9b1(0x2df)](_0xe55c97,_0x25edef):_0x25edef;this['addCommand'](_0x22d3dd,_0x47f9b1(0x1d9),!![],_0x5db7ea);},Window_BestiaryRewards['prototype'][_0x86b5bc(0x16c)]=function(){const _0x5dc301=_0x86b5bc;this[_0x5dc301(0x237)](),this['addEnemyDatabaseDrops'](),this[_0x5dc301(0xce)](),this[_0x5dc301(0x1fc)]();},Window_BestiaryRewards[_0x86b5bc(0x2b3)][_0x86b5bc(0x237)]=function(){const _0x41c054=_0x86b5bc;this['_enemyDrops']={};const _0x12c619=[_0x41c054(0x338),'chance50','chance20',_0x41c054(0x2ab),_0x41c054(0x271),_0x41c054(0x227)],_0x4cee90=[_0x41c054(0x35a),_0x41c054(0x15b),'armors'];for(const _0x4be814 of _0x12c619){for(const _0x52b759 of _0x4cee90){this['_enemyDrops'][_0x4be814]=this[_0x41c054(0x235)][_0x4be814]||{},this[_0x41c054(0x235)][_0x4be814][_0x52b759]=this['_enemyDrops'][_0x4be814][_0x52b759]||[];}}},VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x324)]=function(_0x4d89a6,_0x4b0466){if(_0x4d89a6===0x1)return $dataItems[_0x4b0466];if(_0x4d89a6===0x2)return $dataWeapons[_0x4b0466];if(_0x4d89a6===0x3)return $dataArmors[_0x4b0466];return null;},VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x27f)]=function(_0x2eda87){const _0xbbef23=_0x86b5bc,_0x932c17=TextManager[_0xbbef23(0x33a)][_0xbbef23(0x23c)];if(_0x2eda87>=0x1)return _0x932c17[_0xbbef23(0x338)];else{if(_0x2eda87>=0.5)return _0x932c17[_0xbbef23(0x112)];else{if(_0x2eda87>=0.2)return _0x932c17[_0xbbef23(0x10c)];else return _0x2eda87>=0.1?_0x932c17[_0xbbef23(0x2ab)]:_0x932c17[_0xbbef23(0x271)];}}},Window_BestiaryRewards[_0x86b5bc(0x2b3)][_0x86b5bc(0xb1)]=function(_0x5b9a7b,_0x596877){const _0x264835=_0x86b5bc;if(!_0x5b9a7b)return;const _0x5d6d98=TextManager['Bestiary'][_0x264835(0x23c)],_0x2989ae=['chance100',_0x264835(0x112),_0x264835(0x10c),'chance10',_0x264835(0x271),'conditional'];let _0x961d46='';for(const _0x17bf3f of _0x2989ae){if(_0x596877===_0x5d6d98[_0x17bf3f])_0x961d46=_0x17bf3f;}let _0x140c21='';if(DataManager[_0x264835(0x2e6)](_0x5b9a7b))_0x140c21=_0x264835(0x35a);if(DataManager[_0x264835(0x199)](_0x5b9a7b))_0x140c21=_0x264835(0x15b);if(DataManager['isArmor'](_0x5b9a7b))_0x140c21=_0x264835(0xcb);this['_enemyDrops'][_0x961d46][_0x140c21][_0x264835(0x310)](_0x5b9a7b);},Window_BestiaryRewards[_0x86b5bc(0x2b3)][_0x86b5bc(0xdb)]=function(){const _0x42ac39=_0x86b5bc,_0x4dbb81=SceneManager['_scene']['enemy'](),_0x22740e=_0x4dbb81[_0x42ac39(0x1b4)]()[_0x42ac39(0x17c)];if(!_0x22740e)return;for(const _0x1ac3ea of _0x22740e){if(_0x1ac3ea[_0x42ac39(0x106)]<=0x0)continue;const _0x1e8a08=0x1/Math['max'](_0x1ac3ea[_0x42ac39(0x27b)],0x1),_0x4d351b=VisuMZ[_0x42ac39(0x33a)][_0x42ac39(0x324)](_0x1ac3ea[_0x42ac39(0x106)],_0x1ac3ea[_0x42ac39(0x1d5)]),_0x4e45a1=VisuMZ['Bestiary'][_0x42ac39(0x27f)](_0x1e8a08);this[_0x42ac39(0xb1)](_0x4d351b,_0x4e45a1);}},Window_BestiaryRewards[_0x86b5bc(0x2b3)][_0x86b5bc(0xce)]=function(){const _0x55b3e6=_0x86b5bc;if(!Imported[_0x55b3e6(0x19c)])return;const _0x1a7d85=SceneManager['_scene'][_0x55b3e6(0x1b4)](),_0x10277c=_0x1a7d85[_0x55b3e6(0x1b4)]()[_0x55b3e6(0xb4)]||'',_0xcf079f=_0x10277c['split'](/[\r\n]+/),_0x3a4dc0=TextManager['Bestiary'][_0x55b3e6(0x23c)][_0x55b3e6(0x227)];for(const _0x11c29e of _0xcf079f){if(_0x11c29e[_0x55b3e6(0x297)](/<CONDITIONAL (ITEM|WEAPON|ARMOR) (\d+)[ ](?:THROUGH|to)[ ](\d+) (?:DROP|DROPS)>/i)){const _0x1df09a=VisuMZ['ExtraEnemyDrops'][_0x55b3e6(0x1d4)](RegExp['$1']),_0x1ef719=Number(RegExp['$2']),_0x16fce4=Number(RegExp['$3']);for(let _0x585c73=_0x1ef719;_0x585c73<=_0x16fce4;_0x585c73++){const _0x47115d=_0x1df09a[_0x585c73]||null;_0x47115d&&_0x47115d[_0x55b3e6(0x132)][_0x55b3e6(0x203)]()!==''&&!_0x47115d[_0x55b3e6(0x132)][_0x55b3e6(0x297)](/-----/i)&&this[_0x55b3e6(0xb1)](_0x47115d,_0x3a4dc0);}}if(_0x11c29e[_0x55b3e6(0x297)](/<CONDITIONAL (ITEM|WEAPON|ARMOR) (\d+) (?:DROP|DROPS)>/i)){const _0x1fbc27=VisuMZ[_0x55b3e6(0xfd)][_0x55b3e6(0x1d4)](RegExp['$1']),_0x5cf052=Number(RegExp['$2']),_0x143423=_0x1fbc27[_0x5cf052];this[_0x55b3e6(0xb1)](_0x143423,_0x3a4dc0);}if(_0x11c29e[_0x55b3e6(0x297)](/<CONDITIONAL (ITEM|WEAPON|ARMOR) (.*) (?:DROP|DROPS)>/i)){const _0x48e2e5=VisuMZ[_0x55b3e6(0xfd)][_0x55b3e6(0x166)](RegExp['$1'],RegExp['$2']);this['addItemToGroup'](_0x48e2e5,_0x3a4dc0);}}},Window_BestiaryRewards[_0x86b5bc(0x2b3)][_0x86b5bc(0x323)]=function(_0x2db015,_0x4b1f43){const _0x20b416=_0x86b5bc;if(!_0x2db015)return;const _0x2fd218=_0x2db015[_0x20b416(0x132)],_0x56ae44=_0x2db015[_0x20b416(0x314)];let _0x23d121=_0x56ae44>0x0?_0x20b416(0xa6)[_0x20b416(0x2df)](_0x56ae44,_0x2fd218):_0x2fd218;this[_0x20b416(0x326)](_0x23d121,_0x20b416(0x1d9),!![],_0x4b1f43);},Window_BestiaryRewards[_0x86b5bc(0x2b3)][_0x86b5bc(0x1fc)]=function(){const _0x422c2b=_0x86b5bc,_0x11ea51=[_0x422c2b(0x338),_0x422c2b(0x112),'chance20',_0x422c2b(0x2ab),'chance0',_0x422c2b(0x227)],_0x504bd1=['items',_0x422c2b(0x15b),'armors'];for(const _0x52ede2 of _0x11ea51){for(const _0x3a5e13 of _0x504bd1){let _0x2ab2be=this[_0x422c2b(0x235)][_0x52ede2][_0x3a5e13];_0x2ab2be=_0x2ab2be[_0x422c2b(0x1a0)]((_0x3a60be,_0x39ff0d)=>_0x3a60be['id']-_0x39ff0d['id']);for(const _0x462977 of _0x2ab2be){const _0x3520bb=TextManager['Bestiary'][_0x422c2b(0x23c)][_0x52ede2];this[_0x422c2b(0x323)](_0x462977,_0x3520bb);}}}},Window_BestiaryRewards['prototype'][_0x86b5bc(0x114)]=function(_0xde1289){const _0x4ce6d7=_0x86b5bc,_0x1406ee=this[_0x4ce6d7(0x2b4)](_0xde1289),_0x5edc0=this[_0x4ce6d7(0x25e)](_0xde1289),_0x2b37a0=String(this['_list'][_0xde1289][_0x4ce6d7(0x1cf)]);this[_0x4ce6d7(0x2d1)](),this[_0x4ce6d7(0x254)](this['isCommandEnabled'](_0xde1289)),this[_0x4ce6d7(0x2ca)](_0x5edc0,_0x1406ee['x'],_0x1406ee['y'],_0x1406ee[_0x4ce6d7(0x32b)]);const _0x290097=_0x1406ee['x']+(_0x1406ee['width']-this['textSizeEx'](_0x2b37a0)[_0x4ce6d7(0x32b)]);this[_0x4ce6d7(0x2ca)](_0x2b37a0,_0x290097,_0x1406ee['y'],_0x1406ee['width']);};function Window_BestiaryTraits(){const _0x416289=_0x86b5bc;this[_0x416289(0x1c7)](...arguments);}Window_BestiaryTraits[_0x86b5bc(0x2b3)]=Object[_0x86b5bc(0x27c)](Window_Command[_0x86b5bc(0x2b3)]),Window_BestiaryTraits[_0x86b5bc(0x2b3)][_0x86b5bc(0x144)]=Window_BestiaryTraits,Window_BestiaryTraits[_0x86b5bc(0x178)]={'bgType':VisuMZ[_0x86b5bc(0x33a)]['Settings'][_0x86b5bc(0x1a4)][_0x86b5bc(0x212)]??0x0,'displayAllTraitTypes':VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x2dd)][_0x86b5bc(0x1a4)][_0x86b5bc(0x224)]??![]},Window_BestiaryTraits[_0x86b5bc(0x2b3)][_0x86b5bc(0x1c7)]=function(_0x4dbdf5){const _0x182dca=_0x86b5bc;this[_0x182dca(0x263)](),Window_Command[_0x182dca(0x2b3)]['initialize'][_0x182dca(0x2bc)](this,_0x4dbdf5),this[_0x182dca(0xfb)](),this[_0x182dca(0x2ac)](),this['hide']();},Window_BestiaryTraits['prototype'][_0x86b5bc(0x263)]=function(){const _0x7f99de=_0x86b5bc;this['_categoryStatus']={};const _0x180a64=['Element',_0x7f99de(0x293),_0x7f99de(0x192),_0x7f99de(0x2fc),_0x7f99de(0x29f),_0x7f99de(0x218),'Blessing','Curse',_0x7f99de(0xc2),_0x7f99de(0x2c8)];for(const _0x5ab443 of _0x180a64){this[_0x7f99de(0xe5)][_0x5ab443[_0x7f99de(0x244)]()[_0x7f99de(0x203)]()]=!![];}},Window_BestiaryTraits[_0x86b5bc(0x2b3)]['isAutoColorAffected']=function(){return![];},Window_BestiaryTraits[_0x86b5bc(0x2b3)]['becomeActive']=function(){const _0x916079=_0x86b5bc;this[_0x916079(0x285)](),this[_0x916079(0x198)](0x0),this['scrollTo'](0x0,0x0),this[_0x916079(0x302)]&&this[_0x916079(0x302)][_0x916079(0xc1)]();},Window_BestiaryTraits[_0x86b5bc(0x2b3)][_0x86b5bc(0x278)]=function(){const _0x276eca=_0x86b5bc;if(this[_0x276eca(0x284)]()===_0x276eca(0xff))SoundManager[_0x276eca(0x281)]();else{if(this[_0x276eca(0x284)]()===_0x276eca(0x2a6)){const _0x1c48bc=this[_0x276eca(0x223)](),_0x3d5451=SceneManager[_0x276eca(0xb3)]['enemy']();enabled=_0x3d5451[_0x276eca(0x1b3)](_0x1c48bc[0x0])[_0x276eca(0x257)]()[_0x276eca(0x203)]()===_0x1c48bc[0x1]['toUpperCase']()[_0x276eca(0x203)]();if(!enabled)SoundManager['playEquip']();}}},Window_BestiaryTraits['prototype'][_0x86b5bc(0x2e5)]=function(){const _0x4446b3=_0x86b5bc,_0x4394b2=SceneManager[_0x4446b3(0xb3)][_0x4446b3(0x1b4)]();if(!_0x4394b2)return;const _0x55d357=_0x4394b2[_0x4446b3(0x35f)]();for(const _0x31e51b of _0x55d357){if(!this[_0x4446b3(0xf6)](_0x31e51b,_0x4394b2))continue;this[_0x4446b3(0x322)](_0x31e51b),this[_0x4446b3(0x247)](_0x31e51b);}},Window_BestiaryTraits['prototype'][_0x86b5bc(0xf6)]=function(_0x1e4309,_0x4ad2b4){const _0x1052c0=_0x86b5bc,_0x133cf5=DataManager[_0x1052c0(0xc9)](_0x1e4309);if(!_0x133cf5)return![];if(!_0x133cf5[_0x1052c0(0xc6)])return![];return Window_BestiaryTraits['SETTINGS']['displayAllTraitTypes']?!![]:_0x4ad2b4&&_0x4ad2b4[_0x1052c0(0x1b3)](_0x1e4309)!=='';},Window_BestiaryTraits[_0x86b5bc(0x2b3)][_0x86b5bc(0x322)]=function(_0x25ce51){const _0x2ab7dd=_0x86b5bc,_0x254b15=this[_0x2ab7dd(0x29a)](_0x25ce51)?TextManager['Bestiary']['traitsWindow'][_0x2ab7dd(0x171)]:TextManager[_0x2ab7dd(0x33a)][_0x2ab7dd(0x22b)][_0x2ab7dd(0x195)],_0x44d5f4=DataManager[_0x2ab7dd(0xc9)](_0x25ce51),_0x4eb465=_0x254b15['format'](_0x44d5f4[_0x2ab7dd(0x255)]);this[_0x2ab7dd(0x326)](_0x4eb465,_0x2ab7dd(0xff),!![],_0x25ce51);},Window_BestiaryTraits['prototype'][_0x86b5bc(0x29a)]=function(_0x49f2d7){const _0x23ec29=_0x86b5bc;return _0x49f2d7=_0x49f2d7['toLowerCase']()['trim'](),this[_0x23ec29(0xe5)][_0x49f2d7];},Window_BestiaryTraits[_0x86b5bc(0x2b3)]['openCloseCurrentCategory']=function(){const _0x2f0dad=_0x86b5bc,_0x4845a1=this[_0x2f0dad(0x143)]()[_0x2f0dad(0x244)]()[_0x2f0dad(0x203)]();this[_0x2f0dad(0xe5)][_0x4845a1]=!this[_0x2f0dad(0xe5)][_0x4845a1],this['refresh']();},Window_BestiaryTraits[_0x86b5bc(0x2b3)][_0x86b5bc(0x143)]=function(){const _0x358505=_0x86b5bc;return this[_0x358505(0x284)]()==='category'?this[_0x358505(0x223)]():null;},Window_BestiaryTraits[_0x86b5bc(0x2b3)][_0x86b5bc(0x247)]=function(_0x3586a5){const _0x338b6b=_0x86b5bc;if(!this['isCategoryOpen'](_0x3586a5))return;const _0x4a171e=SceneManager[_0x338b6b(0xb3)]['enemy'](),_0x337bdc=VisuMZ[_0x338b6b(0x33a)][_0x338b6b(0xfe)](_0x3586a5,_0x4a171e);if(_0x337bdc[_0x338b6b(0x14f)]<=0x0){const _0x359180=_0x4a171e[_0x338b6b(0x1b3)](_0x3586a5);this[_0x338b6b(0xa3)](_0x3586a5,_0x359180,_0x4a171e);}else for(const _0xd73814 of _0x337bdc){this['makeTraitCommand'](_0x3586a5,_0xd73814,_0x4a171e);}},Window_BestiaryTraits['prototype'][_0x86b5bc(0xa3)]=function(_0x248ca0,_0x488373,_0x45c29f){const _0x398672=_0x86b5bc,_0x4a71a5=DataManager[_0x398672(0x9b)](_0x248ca0,_0x488373);this[_0x398672(0x326)]('\x20\x20'+_0x4a71a5['Display'],_0x398672(0x2a6),!![],[_0x248ca0,_0x488373]);},Window_BestiaryTraits['prototype'][_0x86b5bc(0x114)]=function(_0x5a5eec){const _0x210e6c=_0x86b5bc,_0xb3b837=this[_0x210e6c(0x2b4)](_0x5a5eec),_0x595fbb=this[_0x210e6c(0x25e)](_0x5a5eec);this[_0x210e6c(0x2d1)]();let _0x4e5bba=!![];if(this['commandSymbol'](_0x5a5eec)==='trait'){const _0x2bf4c9=this['_list'][_0x5a5eec][_0x210e6c(0x1cf)],_0xec0824=SceneManager[_0x210e6c(0xb3)][_0x210e6c(0x1b4)]();_0x4e5bba=_0xec0824[_0x210e6c(0x1b3)](_0x2bf4c9[0x0])[_0x210e6c(0x257)]()[_0x210e6c(0x203)]()===_0x2bf4c9[0x1][_0x210e6c(0x257)]()[_0x210e6c(0x203)]();}this[_0x210e6c(0x254)](_0x4e5bba),this[_0x210e6c(0x2ca)](_0x595fbb,_0xb3b837['x'],_0xb3b837['y'],_0xb3b837[_0x210e6c(0x32b)]);},Window_BestiaryTraits['prototype'][_0x86b5bc(0x126)]=function(){const _0x18c8a9=_0x86b5bc;if(this['currentSymbol']()===_0x18c8a9(0xff))this[_0x18c8a9(0x302)][_0x18c8a9(0x2aa)](TextManager['Bestiary'][_0x18c8a9(0x22b)][_0x18c8a9(0x269)]);else{if(this[_0x18c8a9(0x284)]()===_0x18c8a9(0x2a6)){const _0x267209=this[_0x18c8a9(0x223)](),_0x2225f1=DataManager[_0x18c8a9(0x9b)](_0x267209[0x0],_0x267209[0x1]);this[_0x18c8a9(0x302)][_0x18c8a9(0x2aa)](_0x2225f1?_0x2225f1[_0x18c8a9(0x1f9)]||'':'');}else this[_0x18c8a9(0x284)]()===null&&this['_helpWindow'][_0x18c8a9(0x2aa)](TextManager['Bestiary'][_0x18c8a9(0x22b)][_0x18c8a9(0x16d)]);}};function Window_BestiaryLore(){const _0x7becd1=_0x86b5bc;this[_0x7becd1(0x1c7)](...arguments);}Window_BestiaryLore[_0x86b5bc(0x2b3)]=Object['create'](Window_Selectable[_0x86b5bc(0x2b3)]),Window_BestiaryLore['prototype']['constructor']=Window_BestiaryLore,Window_BestiaryLore[_0x86b5bc(0x178)]={'bgType':VisuMZ['Bestiary'][_0x86b5bc(0x2dd)]['Window'][_0x86b5bc(0x321)]??0x0,'fontSize':VisuMZ['Bestiary'][_0x86b5bc(0x2dd)][_0x86b5bc(0x1a4)]['LoreWindow_FontSize']??0x16,'autoWordWrap':VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x2dd)]['Window'][_0x86b5bc(0x17e)]??![],'slowScrollSpeed':VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x2dd)][_0x86b5bc(0x1a4)]['SlowScrollSpeed']??0x8,'fastScrollSpeed':VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x2dd)]['Window'][_0x86b5bc(0xde)]??0x20,'slowSoundFrequency':VisuMZ[_0x86b5bc(0x33a)][_0x86b5bc(0x2dd)][_0x86b5bc(0x1a4)][_0x86b5bc(0x125)]??0x8,'fastSoundFrequency':VisuMZ[_0x86b5bc(0x33a)]['Settings'][_0x86b5bc(0x1a4)][_0x86b5bc(0x2e8)]??0x4},Window_BestiaryLore[_0x86b5bc(0x2b3)][_0x86b5bc(0x1c7)]=function(_0x7bd1f2){const _0x1b48b9=_0x86b5bc;this[_0x1b48b9(0x1cc)]='',Window_Selectable[_0x1b48b9(0x2b3)][_0x1b48b9(0x1c7)][_0x1b48b9(0x2bc)](this,_0x7bd1f2),this[_0x1b48b9(0xfb)](),this[_0x1b48b9(0x2ac)](),this['hide']();},Window_BestiaryLore[_0x86b5bc(0x2b3)][_0x86b5bc(0x2d1)]=function(){const _0x3ec475=_0x86b5bc;Window_Selectable[_0x3ec475(0x2b3)][_0x3ec475(0x2d1)][_0x3ec475(0x2bc)](this),this[_0x3ec475(0x2f3)][_0x3ec475(0xb8)]=Window_BestiaryLore[_0x3ec475(0x178)]['fontSize'];},Window_BestiaryLore['prototype'][_0x86b5bc(0x2d6)]=function(){const _0x1dd184=_0x86b5bc;this['processEnemyLore'](),this[_0x1dd184(0x17d)](),this[_0x1dd184(0x135)](),this[_0x1dd184(0x1f7)]();},Window_BestiaryLore['prototype']['calculateTextHeight']=function(){const _0x1aa529=_0x86b5bc,_0x5b2825=this['_text'];this[_0x1aa529(0x230)]=0x0,this[_0x1aa529(0x230)]=this[_0x1aa529(0x25c)](_0x5b2825)['height'];},Window_BestiaryLore[_0x86b5bc(0x2b3)][_0x86b5bc(0x12e)]=function(){const _0x11476a=_0x86b5bc;return Math['max'](this[_0x11476a(0x230)],0x1);},Window_BestiaryLore[_0x86b5bc(0x2b3)]['becomeActive']=function(){const _0x2e3709=_0x86b5bc;this[_0x2e3709(0x285)](),this['scrollTo'](0x0,0x0);},Window_BestiaryLore[_0x86b5bc(0x2b3)][_0x86b5bc(0x220)]=function(){const _0x2e90e9=_0x86b5bc,_0x5f00d7=SceneManager[_0x2e90e9(0xb3)]['enemy'](),_0x15398e=TextManager['getBestiaryLore'](_0x5f00d7);this[_0x2e90e9(0x2aa)](_0x15398e);},Window_BestiaryLore['prototype'][_0x86b5bc(0x2aa)]=function(_0x500330){const _0x5a21ac=_0x86b5bc;if(_0x500330===this[_0x5a21ac(0x1cc)])return;Imported[_0x5a21ac(0xae)]&&Window_BestiaryLore[_0x5a21ac(0x178)][_0x5a21ac(0x27a)]&&(_0x500330=_0x5a21ac(0x2a4)+_0x500330),this[_0x5a21ac(0x1cc)]=_0x500330;},Window_BestiaryLore[_0x86b5bc(0x2b3)][_0x86b5bc(0x1f7)]=function(){const _0x1103c2=_0x86b5bc,_0x5dd1ad=this[_0x1103c2(0x1cc)];this[_0x1103c2(0x2d1)](),this[_0x1103c2(0x142)](_0x5dd1ad);if(Imported[_0x1103c2(0xae)])this[_0x1103c2(0x1f2)]();this['scrollToTop']();},Window_BestiaryLore[_0x86b5bc(0x2b3)][_0x86b5bc(0x142)]=function(_0x10550b){const _0x311c45=_0x86b5bc;this['drawTextEx'](_0x10550b,0x0,0x0,this[_0x311c45(0x1a8)]);},Window_BestiaryLore[_0x86b5bc(0x2b3)][_0x86b5bc(0x2e4)]=function(){},Window_BestiaryLore[_0x86b5bc(0x2b3)][_0x86b5bc(0x2d7)]=function(){const _0x1d2b13=_0x86b5bc;if(!this[_0x1d2b13(0x140)])return;if(Input[_0x1d2b13(0x28c)](_0x1d2b13(0x183)))this[_0x1d2b13(0x1ff)](!![]);else{if(Input[_0x1d2b13(0x28c)]('up'))this[_0x1d2b13(0x1ff)](![]);else{if(Input['isPressed'](_0x1d2b13(0x329)))this[_0x1d2b13(0x2ec)](!![]);else{if(Input[_0x1d2b13(0x28c)](_0x1d2b13(0x16e)))this[_0x1d2b13(0x2ec)](![]);else{if(Input[_0x1d2b13(0x1e5)](_0x1d2b13(0x2d8)))this[_0x1d2b13(0x26f)](!![]);else Input[_0x1d2b13(0x1e5)](_0x1d2b13(0xdd))&&this[_0x1d2b13(0x345)](!![]);}}}}},Window_BestiaryLore[_0x86b5bc(0x2b3)]['processSlowScroll']=function(_0x5b67e8){const _0x4d576d=_0x86b5bc;let _0x57cbee=this[_0x4d576d(0x19d)]['y'];this['origin']['y']+=(_0x5b67e8?0x1:-0x1)*Window_BestiaryLore[_0x4d576d(0x178)][_0x4d576d(0x18d)];let _0x3cc1f7=Math[_0x4d576d(0xad)](0x0,this[_0x4d576d(0x230)]-this['innerHeight']);this[_0x4d576d(0x19d)]['y']=this[_0x4d576d(0x19d)]['y'][_0x4d576d(0x1c3)](0x0,_0x3cc1f7);if(_0x57cbee!==this[_0x4d576d(0x19d)]['y']&&Graphics[_0x4d576d(0x253)]%Window_BestiaryLore['SETTINGS']['slowSoundFrequency']===0x0)this[_0x4d576d(0x121)]();},Window_BestiaryLore['prototype'][_0x86b5bc(0x2ec)]=function(_0x177465){const _0x1c3766=_0x86b5bc;let _0x5bb8d1=this['origin']['y'];this[_0x1c3766(0x19d)]['y']+=(_0x177465?0x1:-0x1)*Window_BestiaryLore[_0x1c3766(0x178)][_0x1c3766(0x291)];let _0x399288=Math[_0x1c3766(0xad)](0x0,this['_allTextHeight']-this[_0x1c3766(0x29c)]);this['origin']['y']=this[_0x1c3766(0x19d)]['y']['clamp'](0x0,_0x399288);if(_0x5bb8d1!==this[_0x1c3766(0x19d)]['y']&&Graphics['frameCount']%Window_BestiaryLore[_0x1c3766(0x178)]['fastSoundFrequency']===0x0)this['playCursorSound']();},Window_BestiaryLore[_0x86b5bc(0x2b3)][_0x86b5bc(0x26f)]=function(_0x45d39d){const _0x399658=_0x86b5bc;let _0x107c63=this[_0x399658(0x19d)]['y'];this['origin']['y']=0x0;if(_0x45d39d&&_0x107c63!==this[_0x399658(0x19d)]['y'])this[_0x399658(0x121)]();},Window_BestiaryLore[_0x86b5bc(0x2b3)][_0x86b5bc(0x345)]=function(_0x32b08f){const _0x50bf8a=_0x86b5bc;let _0x2a975d=this['origin']['y'],_0x740357=Math[_0x50bf8a(0xad)](0x0,this[_0x50bf8a(0x230)]-this[_0x50bf8a(0x29c)]);this['origin']['y']=_0x740357;if(_0x32b08f&&_0x2a975d!==this[_0x50bf8a(0x19d)]['y'])this[_0x50bf8a(0x121)]();},Window_BestiaryLore[_0x86b5bc(0x2b3)][_0x86b5bc(0xb0)]=function(){const _0x1bb641=_0x86b5bc;this[_0x1bb641(0x23f)]=this[_0x1bb641(0x19d)]['y']<this['_allTextHeight']-this['innerHeight'],this['upArrowVisible']=this[_0x1bb641(0x19d)]['y']>0x0;},Window_BestiaryLore[_0x86b5bc(0x2b3)][_0x86b5bc(0xe9)]=function(_0x292bc5,_0x5a5d8b){const _0x3e44dc=_0x86b5bc;this[_0x3e44dc(0x19d)]['y']+=_0x5a5d8b;let _0x2bd2da=Math[_0x3e44dc(0xad)](0x0,this[_0x3e44dc(0x230)]-this['innerHeight']);this['origin']['y']=this[_0x3e44dc(0x19d)]['y'][_0x3e44dc(0x1c3)](0x0,_0x2bd2da);},Window_BestiaryLore[_0x86b5bc(0x2b3)][_0x86b5bc(0x176)]=function(_0x4a548f,_0xdb3de6){const _0x201e43=_0x86b5bc;this[_0x201e43(0x19d)]['y']+=_0xdb3de6;let _0x4984d8=Math[_0x201e43(0xad)](0x0,this['_allTextHeight']-this[_0x201e43(0x29c)]);this['origin']['y']=this[_0x201e43(0x19d)]['y']['clamp'](0x0,_0x4984d8);};