//=============================================================================
// VisuStella MZ - Equip Medal System
// VisuMZ_2_EquipMedalSys.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_2_EquipMedalSys = true;

var VisuMZ = VisuMZ || {};
VisuMZ.EquipMedalSys = VisuMZ.EquipMedalSys || {};
VisuMZ.EquipMedalSys.version = 1.03;

//=============================================================================
/* ----------------------------------------------------------------------------
 * General Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~General:
 *
 * @param General
 * @text General Settings
 *
 * @param DefaultShowCommand:eval
 * @text Default Show Command
 * @parent General
 * @type boolean
 * @on Show
 * @off Don't
 * @desc Shows Medal Command by default?
 * @default true
 *
 * @param LearnAutoEquip:eval
 * @text Auto-Equip on Learn
 * @parent General
 * @type boolean
 * @on Auto-Equip
 * @off Don't Equip
 * @desc Automatically equips newly learned Medals.
 * @default false
 *
 * @param LearnPopup:eval
 * @text Text Popup on Learn
 * @parent General
 * @type boolean
 * @on Show Popup
 * @off Don't Show
 * @desc Produce a text popup when a Medal is learned?
 * @default true
 *
 * @param TextPopupFmt:str
 * @text Text Popup Format
 * @parent LearnPopup:eval
 * @desc Text format used for text popup.
 * %1 - Actor, %2 - Medal, %3 - Icon
 * @default %1 has acquired %3%2!
 *
 * @param Capacity
 * @text Slot Settings
 *
 * @param CapacityFormula:str
 * @text Slot Formula
 * @parent Capacity
 * @desc What is the formula used to determine current max capacity?
 * @default Math.ceil(user.level / 10)
 *
 * @param DefaultCost:num
 * @text Default Slot Cost
 * @parent Capacity
 * @desc What is the default capacity cost of equipping a Medal?
 * @default 1
 *
 * @param MinimumCost:num
 * @text Minimum Slot Cap
 * @parent Capacity
 * @type number
 * @min 1
 * @desc What is the minimum capacity value?
 * @default 1
 *
 * @param MaximumCost:num
 * @text Maximum Slot Cap
 * @parent Capacity
 * @type number
 * @min 1
 * @desc What is the maximum capacity value?
 * @default 10
 *
 * @param CheckOverCapacity:eval
 * @text Check Over-Capacity
 * @parent Capacity
 * @type boolean
 * @on Check
 * @off Don't
 * @desc Checks over-capacity when EXP changes.
 * @default true
 *
 * @param MedalExp
 * @text Medal EXP Settings
 *
 * @param MedalExpFormula:str
 * @text EXP Formula
 * @parent MedalExp
 * @desc What is the formula used to determine how much exp an
 * enemy gives? Variable 'user' refers to the defeated enemy.
 * @default 1
 *
 * @param AliveActors:eval
 * @text Alive Actors?
 * @parent MedalExpFormula:str
 * @type boolean
 * @on Alive Requirement
 * @off No Requirement
 * @desc Do actors have to be alive to receive Medal EXP from
 * defeated enemies?
 * @default true
 *
 * @param ShowVictory:eval
 * @text Show During Victory?
 * @parent MedalExp
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show how much Medal EXP is earned during victory phase?
 * @default true
 *
 */
/* ----------------------------------------------------------------------------
 * Vocabulary Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Vocab:
 *
 * @param MedalExp
 * @text Medal EXP
 * 
 * @param equipMedalExpName:str
 * @text Medal EXP Name
 * @parent MedalExp
 * @desc Text used to represent Medal EXP.
 * @default Glory
 * 
 * @param equipMedalExpIcon:num
 * @text Medal EXP Icon
 * @parent MedalExp
 * @desc Icon used to represent Medal EXP.
 * @default 147
 * 
 * @param equipMedalDisplayFmt:str
 * @text Medal EXP Name Format
 * @parent MedalExp
 * @desc Text format used to display Medal EXP name.
 * %1 - Name, %2 - Icon
 * @default %2%1
 * 
 * @param rewardMessageFmt:str
 * @text Reward Message Format
 * @parent MedalExp
 * @desc Text format used when Medal EXP is received.
 * %1 - Amount, %2 - Name
 * @default %1 %2 acquired!
 *
 * @param Scene
 * @text Scene_Equip
 *
 * @param CommandName:str
 * @text Command Name
 * @parent Scene
 * @desc Text used for the Medals Command.
 * @default Medals
 *
 * @param CommandIcon:num
 * @text Command Icon
 * @parent CommandName:str
 * @desc Icon used for the Medals command and for any
 * medals that are displayed without any icon.
 * @default 147
 *
 * @param CapacityText:str
 * @text Capacity Text
 * @parent Scene
 * @desc Text used for Medals Capacity.
 * @default Medal Slots
 *
 * @param CapacityIcon:num
 * @text Capacity Icon
 * @parent CapacityText:str
 * @desc Icon used to represent Medals Capacity when
 * displayed as a limited resource.
 * @default 309
 *
 * @param CapacityFmt:str
 * @text Capacity Format
 * @parent CapacityText:str
 * @desc Text format used to representing Capacity.
 * %1 - Current, %2 - Max, %3 - Icon
 * @default %1/%2%3
 *
 * @param CostFmt:str
 * @text Cost Format
 * @parent Scene
 * @desc Text format used for Capacity Cost.
 * %1 - Cost, %2 - Icon
 * @default %1%2
 *
 * @param Unlearned:str
 * @text Unlearned Text
 * @parent CostFmt:str
 * @desc Text displayed instead of cost for unlearned Medals.
 * @default \}Unacquired\{
 * 
 * @param expTextFormat:str
 * @text Gauge EXP Format
 * @parent Scene
 * @desc Text format used when displaying Medal EXP in a gauge.
 * %1 - Current, %2 - Needed, %3 - Percent
 * @default \}%1/%2 (%3%)\{
 * 
 * @param expPercentDigits:num
 * @text Decimal Places
 * @parent expTextFormat:str
 * @type number
 * @min 0
 * @desc How many decimal places should the percent digits
 * go out to for the percent value?
 * @default 2
 * 
 * @param maxExpTextFormat:str
 * @text Mastered Medal Text
 * @parent expTextFormat:str
 * @desc Text used in Medal EXP Gauge for mastered medals.
 * You may use text codes.
 * @default \}MASTERED!\{
 *
 * @param HelpWindow
 * @text Help Window
 *
 * @param HelpFmt:str
 * @text Description Format
 * @parent HelpWindow
 * @desc Text format used to create help descriptions.
 * %1 - Unlocking Conditions
 * @default \C[16]Acquire Conditions:\C[0] %1
 *
 * @param helpWordWrap:eval
 * @text Word Wrap?
 * @parent HelpWindow
 * @type boolean
 * @on Wordwrap
 * @off Normal
 * @desc Apply word wrap to unlock conditions?
 * Requires VisuMZ_1_MessageCore!
 * @default true
 *
 * @param helpSpacing:eval
 * @text Spacing?
 * @parent HelpWindow
 * @type boolean
 * @on Add Spacing
 * @off Don't Add
 * @desc Add spacing between conditions?
 * @default true
 *
 * @param helpSpacer:str
 * @text Spacer
 * @parent HelpWindow
 * @desc Text inserted between conditions.
 * @default ,
 *
 * @param helpNothing:str
 * @text Empty Descriptions
 * @parent HelpWindow
 * @desc Text used when no condition text is made.
 * @default -
 *
 * @param ConditionText
 * @text Unlock Condition Text
 *
 * @param helpMeetConditionColor:num
 * @text Condition Met Color
 * @parent ConditionText
 * @type number
 * @min 0
 * @desc Use text colors from the Window Skin only.
 * @default 24
 * 
 * @param progressFmt:str
 * @text Progress Format
 * @parent ConditionText
 * @desc Text format used to indicate progress amount.
 * %1 - Progress Text
 * @default (Progress %1)
 * 
 * @param progressFraction:str
 * @text Fraction Format
 * @parent progressFmt:str
 * @desc Text format used for progress fraction.
 * %1 - Current, %2 - Goal
 * @default %1/%2
 * 
 * @param progressPercent:str
 * @text Percent Format
 * @parent progressFmt:str
 * @desc Text format used for percentile value.
 * %1 - Percent
 * @default %1%
 * 
 * @param progressLengthLimit:num
 * @text Length Limit
 * @parent progressFmt:str
 * @type number
 * @min 1
 * @desc What is the character limit before a percentage is
 * used instead fractions for progress text?
 * @default 7
 * 
 * @param progressComplete:str
 * @text Complete
 * @parent progressFmt:str
 * @desc Progress text used when unlock condition is fulfilled.
 * @default \I[87]
 * 
 * @param level:str
 * @text Level Format
 * @parent ConditionText
 * @desc Text format used for level conditions.
 * %1 - Level, %2 - Progress
 * @default Reach Level %1 %2
 * 
 * @param battle:str
 * @text Battle Format
 * @parent ConditionText
 * @desc Text format used for fought battles.
 * %1 - Needed, %2 - Progress
 * @default Fight %1 Battles %2
 * 
 * @param victory:str
 * @text Victory Format
 * @parent battle:str
 * @desc Text format used for victorious battles.
 * %1 - Needed, %2 - Progress
 * @default Win %1 Battles %2
 * 
 * @param escapes:str
 * @text Escape Format
 * @parent battle:str
 * @desc Text format used for escaped battles.
 * %1 - Needed, %2 - Progress
 * @default Escape %1 Battles %2
 * 
 * @param defeat:str
 * @text Defeat Format
 * @parent battle:str
 * @desc Text format used for lost battles.
 * %1 - Needed, %2 - Progress
 * @default Lose %1 Battles %2
 * 
 * @param attackTimes:str
 * @text Attack Format
 * @parent ConditionText
 * @desc Text format used for attack times.
 * %1 - Needed, %2 - Progress
 * @default Attack %1 Times %2
 * 
 * @param guardTimes:str
 * @text Guard Format
 * @parent attackTimes:str
 * @desc Text format used for guard times.
 * %1 - Needed, %2 - Progress
 * @default Guard %1 Times %2
 * 
 * @param skillUse:str
 * @text Skill Format
 * @parent attackTimes:str
 * @desc Text format used for skill times.
 * %1 - Needed, %2 - Progress
 * @default Use %1 Skills %2
 * 
 * @param physSkillUse:str
 * @text Physical Skills
 * @parent attackTimes:str
 * @desc Text format used for physical skills.
 * %1 - Needed, %2 - Progress
 * @default Use %1 Physical Skills %2
 * 
 * @param magSkillUse:str
 * @text Magical Skills
 * @parent attackTimes:str
 * @desc Text format used for magical skills.
 * %1 - Needed, %2 - Progress
 * @default Use %1 Magical Skills %2
 * 
 * @param certSkillUse:str
 * @text Certain Hit Skills
 * @parent attackTimes:str
 * @desc Text format used for certain hit skills.
 * %1 - Needed, %2 - Progress
 * @default Use %1 Certain Hit Skills %2
 * 
 * @param itemUse:str
 * @text Item Format
 * @parent attackTimes:str
 * @desc Text format used for item uses.
 * %1 - Needed, %2 - Progress
 * @default Use %1 Items %2
 * 
 * @param critDeal:str
 * @text Deal Criticals
 * @parent ConditionText
 * @desc Text format used for dealing criticals.
 * %1 - Needed, %2 - Progress
 * @default Deal %1 Critical Hits %2
 * 
 * @param critTake:str
 * @text Take Criticals
 * @parent critDeal:str
 * @desc Text format used for taking criticals
 * %1 - Needed, %2 - Progress
 * @default Take %1 Critical Hits %2
 * 
 * @param miss:str
 * @text Miss Format
 * @parent ConditionText
 * @desc Text format for missing attacks.
 * %1 - Needed, %2 - Progress
 * @default Miss %1 Times %2
 * 
 * @param evade:str
 * @text Evade Format
 * @parent miss:str
 * @desc Text format for evading attacks.
 * %1 - Needed, %2 - Progress
 * @default Evade %1 Times %2
 * 
 * @param stypeUse:str
 * @text SType Use
 * @parent ConditionText
 * @desc Text format for using SType Skills.
 * %1 - Needed, %2 - Progress, %3 - Type Text
 * @default Use %1 %3 Skills %2
 * 
 * @param elementDeal:str
 * @text Deal Element DMG
 * @parent ConditionText
 * @desc Text format used for inflicting element damage.
 * %1 - Needed, %2 - Progress, %3 - Element
 * @default Inflict %3 Damage %1 Times %2
 * 
 * @param elementTake:str
 * @text Take Element DMG
 * @parent elementDeal:str
 * @desc Text format used for receiving element damage.
 * %1 - Needed, %2 - Progress, %3 - Element
 * @default Receive %3 Damage %1 Times %2
 * 
 * @param stateDeal:str
 * @text Deal State
 * @parent ConditionText
 * @desc Text format used for inflicting states.
 * %1 - Needed, %2 - Progress, %3 - State
 * @default Inflict %3 %1 Times %2
 * 
 * @param stateTake:str
 * @text Take State
 * @parent stateDeal:str
 * @desc Text format used for receiving states
 * %1 - Needed, %2 - Progress, %3 - State
 * @default Receive %3 %1 Times %2
 * 
 * @param traitSlayer:str
 * @text Trait Slayer
 * @parent ConditionText
 * @desc Text format for slaying trait types.
 * %1 - Needed, %2 - Progress, %3 - Type Text
 * @default Defeat %1 %3 Enemies %2
 * 
 * @param totalDmgDeal:str
 * @text Total Damage Dealt
 * @parent ConditionText
 * @desc Text format for total damage dealt.
 * %1 - Needed, %2 - Progress
 * @default Inflict %1 Total Battle Damage %2
 * 
 * @param totalDmgTake:str
 * @text Total Damage Taken
 * @parent totalDmgDeal:str
 * @desc Text format for total damage received.
 * %1 - Needed, %2 - Progress
 * @default Receive %1 Total Battle Damage %2
 * 
 * @param totalHealDeal:str
 * @text Total Healing Dealt
 * @parent ConditionText
 * @desc Text format for total healing given.
 * %1 - Needed, %2 - Progress
 * @default Perform %1 Total Battle Healing %2
 * 
 * @param totalHealTake:str
 * @text Total Healing Taken
 * @parent totalHealDeal:str
 * @desc Text format for total healing taken.
 * %1 - Needed, %2 - Progress
 * @default Receive %1 Total Battle Healing %2
 * 
 * @param kills:str
 * @text Kills Format
 * @parent ConditionText
 * @desc Text format for kills performed.
 * %1 - Needed, %2 - Progress
 * @default Kill %1 Enemies %2
 * 
 * @param deaths:str
 * @text Deaths Format
 * @parent kills:str
 * @desc Text format for deaths in battle.
 * %1 - Needed, %2 - Progress
 * @default Die %1 Times %2
 * 
 * @param assists:str
 * @text Assists Format
 * @parent kills:str
 * @desc Text format for assists made.
 * %1 - Needed, %2 - Progress
 * @default Assist %1 Times %2
 * 
 * @param haveGold:str
 * @text Reach Gold Total
 * @parent ConditionText
 * @desc Text format for reaching gold quantity.
 * %1 - Needed, %2 - Progress, %3 - Gold
 * @default Possess ×%1%3 %2
 * 
 * @param haveItem:str
 * @text Reach Item Total
 * @parent haveGold:str
 * @desc Text format for reaching item quantity.
 * %1 - Needed, %2 - Progress, %3 - Item
 * @default Possess %3 ×%1 %2
 * 
 * @param haveWeapon:str
 * @text Reach Weapon Total
 * @parent haveGold:str
 * @desc Text format for reaching weapon quantity.
 * %1 - Needed, %2 - Progress, %3 - Weapon
 * @default Possess %3 ×%1 %2
 * 
 * @param haveArmor:str
 * @text Reach Armor Total
 * @parent haveGold:str
 * @desc Text format for reaching armor quantity.
 * %1 - Needed, %2 - Progress, %3 - Armor
 * @default Possess %3 ×%1 %2
 * 
 * @param haveParam:str
 * @text Reach Base Param
 * @parent ConditionText
 * @desc Text format for reaching base Param amount.
 * %1 - Needed, %2 - Progress, %3 - Param Name
 * @default Reach %1 %3 %2
 * 
 * @param haveXParam:str
 * @text Reach XParam Amount
 * @parent haveParam:str
 * @desc Text format for reaching X Param amount.
 * %1 - Needed, %2 - Progress, %3 - XParam Name
 * @default Reach %1% %3 %2
 * 
 * @param haveSParam:str
 * @text Reach SParam Amount
 * @parent haveParam:str
 * @desc Text format for reaching S Param amount.
 * %1 - Needed, %2 - Progress, %3 - SParam Name
 * @default Reach %1% %3 %2
 *
 */
/* ----------------------------------------------------------------------------
 * Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Window:
 *
 * @param Window_EquipMedalList
 * @text Equip Medal List
 *
 * @param EquipMedalList_BgType:num
 * @text Background Type
 * @parent Window_EquipMedalList
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param EquippedColor:str
 * @text Equipped Color
 * @parent Window_EquipMedalList
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 17
 *
 * @param ShowCosts:eval
 * @text Show Capacity Costs?
 * @parent Window_EquipMedalList
 * @type boolean
 * @on Show
 * @off Don't
 * @desc Shows capacity costs on Medals?
 * @default true
 *
 * @param ShowCost0:eval
 * @text Show 0 Costs?
 * @parent ShowCosts:eval
 * @type boolean
 * @on Show
 * @off Don't
 * @desc Shows capacity costs if they cost 0?
 * @default false
 *
 * @param ShowCost1:eval
 * @text Show 1 Costs?
 * @parent ShowCosts:eval
 * @type boolean
 * @on Show
 * @off Don't
 * @desc Shows capacity costs if they only cost 1?
 * @default true
 *
 * @param ShowCostNumber:eval
 * @text Show Cost Numbers?
 * @parent ShowCosts:eval
 * @type boolean
 * @on Show
 * @off Don't
 * @desc Shows capacity cost values?
 * If not, displays multiple icons instead.
 * @default false
 *
 * @param costIconLimit:num
 * @text Cost Icon Limit
 * @parent ShowCostNumber:eval
 * @desc If "Show Cost Numbers" is false, this is how many icons
 * can be displayed max before showing number costs.
 * @default 3
 *
 * @param SortStyle:str
 * @text Sort Style
 * @parent Window_EquipMedalList
 * @type select
 * @option ID - Sort by Armor ID
 * @value id
 * @option Name - Sort by Armor Name
 * @value name
 * @option Type - Sort by Armor Type
 * @value atype
 * @desc How do you wish to sort medals by?
 * @default name
 *
 * @param ShowUnlearned:eval
 * @text Show Unlearned?
 * @parent Window_EquipMedalList
 * @type boolean
 * @on Show
 * @off Don't
 * @desc Shows unlearned medals in the list window?
 * @default true
 *
 * @param SeparateUnlearned:eval
 * @text Separate Unlearned?
 * @parent ShowUnlearned:eval
 * @type boolean
 * @on Separate
 * @off Don't
 * @desc Separate unlearned medals from learned medals?
 * @default true
 *
 * @param MaskUnlearned:eval
 * @text Mask Unlearned?
 * @parent ShowUnlearned:eval
 * @type boolean
 * @on Mask
 * @off Don't
 * @desc Masks unlearned medals in list window?
 * @default true
 *
 * @param MaskIcon:num
 * @text Mask Icon
 * @parent MaskUnlearned:eval
 * @desc What is the icon used for masked medals?
 * @default 161
 *
 * @param MaskLetter:str
 * @text Mask Character
 * @parent MaskUnlearned:eval
 * @desc Text used for masking per individual character.
 * @default ?
 *
 * @param MaskItalics:eval
 * @text Italics?
 * @parent MaskUnlearned:eval
 * @type boolean
 * @on Italics
 * @off Normal
 * @desc Use italics for masked names?
 * @default true
 *
 * @param hideFormerEvolution:eval
 * @text Hide Former Evolved?
 * @parent Window_EquipMedalList
 * @type boolean
 * @on Hide
 * @off Show
 * @desc Hide formerly evolved medals?
 * @default true
 * 
 * @param expGaugeStyleType:str
 * @text Medal EXP Gauge Style
 * @parent Window_EquipMedalList
 * @type select
 * @option -
 * @option Normal
 * @option -
 * @option Arrow
 * @option Dipper
 * @option Flag
 * @option Growth
 * @option Lean
 * @option Quad
 * @option Stagger
 * @option Trapezoid
 * @option -
 * @option HalfStep
 * @option ThirdStep
 * @option FourthStep
 * @option FifthStep
 * @option SixthStep
 * @option EighthStep
 * @option TenthStep
 * @option -
 * @option HalfSection
 * @option ThirdSection
 * @option FourthSection
 * @option FifthSection
 * @option SixthSection
 * @option EighthSection
 * @option TenthSection
 * @option -
 * @option SegmentBy10
 * @option SegmentBy20
 * @option SegmentBy25
 * @option SegmentBy50
 * @option SegmentBy100
 * @option SegmentBy200
 * @option SegmentBy250
 * @option SegmentBy500
 * @option SegmentBy1000
 * @option -
 * @desc Select the gauge style to use for medal EXP.
 * Requires VisuMZ_3_VisualGaugeStyles!
 * @default Growth
 *
 * @param ExpGaugeColor1:str
 * @text EXP Gauge Color 1
 * @parent expGaugeStyleType:str
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 16
 *
 * @param ExpGaugeColor2:str
 * @text EXP Gauge Color 2
 * @parent expGaugeStyleType:str
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 17
 *
 * @param expGaugeWidthModifier:num
 * @text Gauge Width Modifier
 * @parent expGaugeStyleType:str
 * @desc Adjust the gauge width by this amount.
 * @default -104
 *
 * @param expTextOffsetX:num
 * @text EXP Text Offset X
 * @parent expGaugeStyleType:str
 * @desc Offsets the Medal EXP Gauge Text X.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param expTextOffsetY:num
 * @text EXP Text Offset Y
 * @parent expGaugeStyleType:str
 * @desc Offsets the Medal EXP Gauge Text Y.
 * Negative: up. Positive: down.
 * @default +6
 *
 * @param Window_EquipMedalStatus
 * @text Medal Status Window
 *
 * @param showStatusWindow:eval
 * @text Show Window?
 * @parent Window_EquipMedalStatus
 * @type boolean
 * @on Show
 * @off Don't
 * @desc Shows this window in the scene?
 * @default true
 *
 * @param StatusWindow_BgType:num
 * @text Background Type
 * @parent Window_EquipMedalStatus
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param MaxCapacityColor:num
 * @text Max Capacity Color
 * @parent Window_EquipMedalStatus
 * @type number
 * @min 0
 * @desc Use text colors from the Window Skin only.
 * @default 17
 *
 */
//=============================================================================

const _0x5b5488=_0x1c90;(function(_0xfda0fe,_0x42c4e6){const _0x57abc1=_0x1c90,_0x1cd3a7=_0xfda0fe();while(!![]){try{const _0x137ff1=-parseInt(_0x57abc1(0x2be))/0x1*(-parseInt(_0x57abc1(0x37f))/0x2)+parseInt(_0x57abc1(0x1c7))/0x3*(-parseInt(_0x57abc1(0x34b))/0x4)+parseInt(_0x57abc1(0x1f2))/0x5*(parseInt(_0x57abc1(0x157))/0x6)+-parseInt(_0x57abc1(0x2c6))/0x7*(-parseInt(_0x57abc1(0x3db))/0x8)+parseInt(_0x57abc1(0x2b6))/0x9+-parseInt(_0x57abc1(0x3e9))/0xa+-parseInt(_0x57abc1(0x11e))/0xb;if(_0x137ff1===_0x42c4e6)break;else _0x1cd3a7['push'](_0x1cd3a7['shift']());}catch(_0x22b749){_0x1cd3a7['push'](_0x1cd3a7['shift']());}}}(_0x5074,0xd034e));var label=_0x5b5488(0x405),tier=tier||0x0,dependencies=[_0x5b5488(0x192),_0x5b5488(0x1f0)],pluginData=$plugins[_0x5b5488(0x1d2)](function(_0x57624c){const _0x2f5e7d=_0x5b5488;return _0x57624c[_0x2f5e7d(0x197)]&&_0x57624c['description'][_0x2f5e7d(0x2c4)]('['+label+']');})[0x0];VisuMZ[label][_0x5b5488(0x11f)]=VisuMZ[label][_0x5b5488(0x11f)]||{},VisuMZ[_0x5b5488(0x114)]=function(_0x4df0ed,_0x374cc0){const _0x485f14=_0x5b5488;for(const _0x4827f8 in _0x374cc0){if(_0x4827f8[_0x485f14(0x156)](/(.*):(.*)/i)){if(_0x485f14(0x3e8)!=='SiFGy')try{_0x4a56d9=_0x8f2def(_0x4426c4[_0x485f14(0x107)]['expFormula']);}catch(_0x4ce45d){if(_0xab25c5['isPlaytest']())_0x302489[_0x485f14(0x214)](_0x4ce45d);_0x1cd281=0x0;}else{const _0x53be63=String(RegExp['$1']),_0x5edac9=String(RegExp['$2'])['toUpperCase']()['trim']();let _0x4e29fe,_0x570a5a,_0x46afaf;switch(_0x5edac9){case _0x485f14(0x350):_0x4e29fe=_0x374cc0[_0x4827f8]!==''?Number(_0x374cc0[_0x4827f8]):0x0;break;case'ARRAYNUM':_0x570a5a=_0x374cc0[_0x4827f8]!==''?JSON[_0x485f14(0x25e)](_0x374cc0[_0x4827f8]):[],_0x4e29fe=_0x570a5a[_0x485f14(0x32c)](_0x3f47a8=>Number(_0x3f47a8));break;case _0x485f14(0x2c2):_0x4e29fe=_0x374cc0[_0x4827f8]!==''?eval(_0x374cc0[_0x4827f8]):null;break;case'ARRAYEVAL':_0x570a5a=_0x374cc0[_0x4827f8]!==''?JSON[_0x485f14(0x25e)](_0x374cc0[_0x4827f8]):[],_0x4e29fe=_0x570a5a[_0x485f14(0x32c)](_0x435a82=>eval(_0x435a82));break;case _0x485f14(0x1e2):_0x4e29fe=_0x374cc0[_0x4827f8]!==''?JSON[_0x485f14(0x25e)](_0x374cc0[_0x4827f8]):'';break;case _0x485f14(0x1e4):_0x570a5a=_0x374cc0[_0x4827f8]!==''?JSON[_0x485f14(0x25e)](_0x374cc0[_0x4827f8]):[],_0x4e29fe=_0x570a5a[_0x485f14(0x32c)](_0x54b71b=>JSON[_0x485f14(0x25e)](_0x54b71b));break;case _0x485f14(0x27b):_0x4e29fe=_0x374cc0[_0x4827f8]!==''?new Function(JSON[_0x485f14(0x25e)](_0x374cc0[_0x4827f8])):new Function(_0x485f14(0x264));break;case _0x485f14(0x426):_0x570a5a=_0x374cc0[_0x4827f8]!==''?JSON[_0x485f14(0x25e)](_0x374cc0[_0x4827f8]):[],_0x4e29fe=_0x570a5a[_0x485f14(0x32c)](_0xc578c1=>new Function(JSON['parse'](_0xc578c1)));break;case _0x485f14(0x1f6):_0x4e29fe=_0x374cc0[_0x4827f8]!==''?String(_0x374cc0[_0x4827f8]):'';break;case _0x485f14(0x155):_0x570a5a=_0x374cc0[_0x4827f8]!==''?JSON['parse'](_0x374cc0[_0x4827f8]):[],_0x4e29fe=_0x570a5a[_0x485f14(0x32c)](_0x5cff30=>String(_0x5cff30));break;case'STRUCT':_0x46afaf=_0x374cc0[_0x4827f8]!==''?JSON['parse'](_0x374cc0[_0x4827f8]):{},_0x4e29fe=VisuMZ['ConvertParams']({},_0x46afaf);break;case _0x485f14(0x20b):_0x570a5a=_0x374cc0[_0x4827f8]!==''?JSON['parse'](_0x374cc0[_0x4827f8]):[],_0x4e29fe=_0x570a5a[_0x485f14(0x32c)](_0x4aeb5f=>VisuMZ[_0x485f14(0x114)]({},JSON[_0x485f14(0x25e)](_0x4aeb5f)));break;default:continue;}_0x4df0ed[_0x53be63]=_0x4e29fe;}}}return _0x4df0ed;},(_0x16f92a=>{const _0x4fd8dc=_0x5b5488,_0x2d4301=_0x16f92a[_0x4fd8dc(0x24b)];for(const _0x1c9c2a of dependencies){if(!Imported[_0x1c9c2a]){if(_0x4fd8dc(0x102)!=='pYgYB'){alert(_0x4fd8dc(0x129)[_0x4fd8dc(0x24a)](_0x2d4301,_0x1c9c2a)),SceneManager[_0x4fd8dc(0x273)]();break;}else this[_0x4fd8dc(0x22a)](_0x1b3f7d);}}const _0xda1157=_0x16f92a[_0x4fd8dc(0x24c)];if(_0xda1157[_0x4fd8dc(0x156)](/\[Version[ ](.*?)\]/i)){if(_0x4fd8dc(0x105)!=='uDNsp'){const _0x218bb2=Number(RegExp['$1']);_0x218bb2!==VisuMZ[label]['version']&&(alert(_0x4fd8dc(0x151)[_0x4fd8dc(0x24a)](_0x2d4301,_0x218bb2)),SceneManager[_0x4fd8dc(0x273)]());}else{_0x36b99e[_0x4fd8dc(0x156)](_0x15b515[_0x4fd8dc(0x32e)]);let _0xcf8db8=_0x543aa1(_0x7a4f03['$1']);const _0x52dcb0=_0x1eaf01(_0x341376['$2']),_0x5a3591=/^\d+$/[_0x4fd8dc(0x239)](_0xcf8db8);_0xcf8db8=_0x5a3591?_0x478506(_0xcf8db8):_0x505671[_0x4fd8dc(0x143)](_0xcf8db8);if(_0x52dcb0>_0x3cb9fe[_0x4fd8dc(0x22d)](_0x3b99ff,_0x4fd8dc(0x153),_0xcf8db8))return![];_0x1d3e26=!![];}}if(_0xda1157[_0x4fd8dc(0x156)](/\[Tier[ ](\d+)\]/i)){if('ybQaY'===_0x4fd8dc(0x43b)){const _0x2efb34=Number(RegExp['$1']);_0x2efb34<tier?(alert('%1\x20is\x20incorrectly\x20placed\x20on\x20the\x20plugin\x20list.\x0aIt\x20is\x20a\x20Tier\x20%2\x20plugin\x20placed\x20over\x20other\x20Tier\x20%3\x20plugins.\x0aPlease\x20reorder\x20the\x20plugin\x20list\x20from\x20smallest\x20to\x20largest\x20tier\x20numbers.'[_0x4fd8dc(0x24a)](_0x2d4301,_0x2efb34,tier)),SceneManager[_0x4fd8dc(0x273)]()):'iBell'!==_0x4fd8dc(0x135)?tier=Math[_0x4fd8dc(0x2cd)](_0x2efb34,tier):_0x1a6355=_0x3002f1(_0x3840b0[_0x4fd8dc(0x107)][_0x4fd8dc(0x16f)]);}else{const _0x454366=_0x18a2b8(_0x36a803['$1']);if(_0x454366>_0x1fab8f[_0x4fd8dc(0x22d)](_0x11b555,'hp',_0x4fd8dc(0x377)))return![];_0x37cf9d=!![];}}VisuMZ['ConvertParams'](VisuMZ[label][_0x4fd8dc(0x11f)],_0x16f92a[_0x4fd8dc(0x1a6)]);})(pluginData);function _0x5074(){const _0x499089=['Scene_Equip_arePageButtonsEnabled','kvGfG','haveWeapon','paramName','getEquipMedalIcon','onEquipMedalOk','max','ShowCostNumber','elofA','xhEzL','HideLearnedAllID','Use\x20%1\x20Items\x20%2','raShY','maxItems','bfNSN','MCR','RRLfU','MaskIcon','expTextFormat','Win\x20%1\x20Battles\x20%2','defaultExpGaugeColor1','DSRuu','miss','_helpWindow','push','jksLv','getUnlearnedEquippedMedalRawIDs','LearnTotalDmgTake','aSBjg','tdubG','Game_Action_applyGlobal','expTextOffsetY','LearnCountKills','sparam','LearnTotal','yZUDj','capacity','ActorIDs','updateEquipMedalActionElement','haveArmor','dOqvx','showRewards','SLIcP','MMP','_maxValueSegment','_stypeIDs','GxbMs','Game_Battler_addState','hideEquipSetBonusTooltipWindow','_getEquipMedalIcon','optExtraExp','GRD','battle','EquipName','arsVu','Miss\x20%1\x20Times\x20%2','xWwhP','deaths','MAT','equipMedalExpName','defeat','LearnStateTake','BattleDefeatJS','costIconLimit','unlearned','iconIndex','wxAQw','Game_Battler_processBattleCoreJS','VisualGaugeStyles','MedalGaugeColor2','DEF','defaultExpGaugeColor2','remove','expGaugeStyleType','Lose\x20%1\x20Battles\x20%2','certSkillUse','TRG','itemUse','EquipCost','AFfal','VisuMZ_3_VisualGaugeStyles','capacityFmt','in\x20order\x20for\x20VisuMZ_2_EquipMedalSys\x20to\x20work.','equipMedalDisplayFmt','add','SystemShowMedalCommand','DEBUG','UCXpp','_commandWindow','ZUtvc','traitSlayer','DiMbP','equipMedalExpTotal','WBupE','kills','LtmWs','KtpUT','active','CapacityFmt','LearnHaveXParam','contents','map','Game_Battler_onBattleEnd','LearnSTypeUsage','rewardAliveActors','oyevA','Scene_Equip_shouldCommandWindowExist','Reach\x20%1%\x20%3\x20%2','BattleManager_makeRewards','text','Use\x20%1\x20Physical\x20Skills\x20%2','deathStateId','getEquipMedalEvolutionTarget','getWeaponIdWithName','_medalStatusWindow','MDF','learnings','toUpperCase','_getEquipMedalName','_equipMedalSysReleaseUnequippables','actor','lUBWz','maxCols','Scene_Equip_commandEquip','LsxuW','ActorAddMedalExp','EKXRb','VisuMZ_0_CoreEngine\x20needs\x20to\x20be\x20updated\x20','CEV','LearnHaveWeapon','NxaIk','EnemyMedalExp','4jCmknE','dhzAF','Heal','addEquipMedalExpToMedal','commandEquip','NUM','LearnCountDeaths','magSkillUse','GlobalRemoveUnlearnedMedal','_elementIDs','Uzbyc','drawEquippableMedal','ShowVictory','equipMedalExpIcon','drawEquippableMedalMask','BewAQ','commandStyle','callUpdateHelp','victory','createMedalStatusWindow','releaseUnequippableItems','makeItemList','critTake','GetExpGaugeColor2','LearnHaveGold','SysUL','lHUKA','setActor','all','drawTextEx','MAXMP','wsfVw','Receive\x20%3\x20Damage\x20%1\x20Times\x20%2','makeRewards','DefaultShowCommand','ExpGaugeColor2','numItems','Game_Actor_setup','\x5cC[0]','createCommandWindow','clamp','trim','changeTextColor','haveXParam','healTake','hasTraitSet','branchLearnableEquipMedals','processCursorMoveModernControls','updateEquipMedalTraitSlayer','totalDmgDeal','Ekmzy','physSkillUse','959834kORuXf','scrollTo','sVidY','HIT','yjGIB','GetExpGaugeColor1','escape','FoYwn','makeRewardsEquipMedalExp','AGI','isArmor','QziIe','FRYNv','Fxdic','progressLengthLimit','hitIndex','index','FDR','zrWZg','LearnItemUsage','Use\x20%1\x20Certain\x20Hit\x20Skills\x20%2','VtZEH','ELnDO','param','abs','CheckOverCapacity','showCost0','EquipIcon','hMnsI','elementDeal','helpMeetConditionColor','innerWidth','XHmrM','item','Fight\x20%1\x20Battles\x20%2','Use\x20%1\x20Magical\x20Skills\x20%2','\x5cC[%1]','haveParam','isEnabled','drawText','DHBlD','progressFmt','icon','setup','paOZU','getEquipMedalEvolutionEXP','Game_Party_gainItem','niLch','helpDescFmt','yPGnm','maxCapacity','clear','expGaugeWidthModifier','setHelpWindowItem','targetID','_equipSetBonusTooltipWindow','rqotN','totalHealTake','isCertainHit','result','tlfTk','ItemsEquipsCore','General','healDeal','BattleVictoryJS','LearnSkillUsage','slotWindowRect','evade','pKIdo','ASgJZ','VisuMZ_1_ElementStatusCore','jMDnM','hqPqN','rvxXG','cgHXl','wvgOo','NeSRR','updateEquipMedalActionResult','TjNOi','isUseModernControls','pXMJD','CheckCompatibility','sort','LearnEvadeTimes','updateHelp','unequipHiddenMedals','escapes','ThIqx','---','LearnBattles','traitObjects','HasExpGauge','46856PNjxyK','actionTimes','getSkillTypes','VsWKJ','itemPadding','helpFmt','battleMembers','processCursorSpecialCheckModernControls','tkUbU','LearnAttackTimes','GlobalLearnMedal','NoMaskUnlearned','LearnTotalDmgDeal','SiFGy','2223630uZxVZd','ManSI','physicalSkill','ZELWs','Scene_Equip_createCommandWindow','pKogk','_doubleTouch','drawEquippableMedalExpGauge','KlbNE','expPercentDigits','note','critDeal','refresh','Evade\x20%1\x20Times\x20%2','Perform\x20%1\x20Total\x20Battle\x20Healing\x20%2','YEAYF','LearnHaveArmor','MaskName','NcAfd','xfLUo','releaseOverEquipMedalCapacity','bZgFc','Nlknt','updateEquipMedalLearnProgress','rzTMe','MAXHP','ApplyUnlockHelpTextCondition','fJcIw','EquipMedalSys','capacityFormula','MedalEXP','aJrLw','Scene_Equip_onActorChange','equipMedals','Pxfpy','makeDeepCopy','MDR','GfzWf','equippedMedals','Game_Actor_refresh','ShowUnlearned','helpWordWrap','Reach\x20%1\x20%3\x20%2','deactivate','Deal\x20%1\x20Critical\x20Hits\x20%2','elements','SETTINGS','MakeUnlockHelpText','drawEquippableMedalCost','MaxCapacityColor','magicalSkill','playEquip','isEquippableMedalEquipped','helpSpacing','create','fontItalic','MEV','left','qkhKr','calcWindowHeight','uJTJN','ARRAYFUNC','EXR','updateEquipMedalActionState','Escape\x20%1\x20Battles\x20%2','playOkSound','getEquipMedalCost','CustomLearnCondText','_getEquipMedalCost','_equipMedalWindow','Window_EquipCommand_playOkSound','Rhffn','gainItem','updateEquipMedalBattleVictory','getEquipMedalExp','HakHx','stypeUse','_learnedEquippableMedals','oYsdQ','DZmvb','MaskUnlearned','processDownCursorSpecialCheckModernControls','ybQaY','setHandler','availableLearnedEquippableMedals','Scene_Equip_create','xQlQj','helpSpacer','Game_Battler_gainHp','availableItems','_equipMedalLearnProgress','_level','every','attackTimes','CapacityText','textPopupFmt','Vocab','MdKvh','haveSParam','dmgDeal','checkOverCapacityExp','selectSymbol','EscapeSuccessJS','MaximumCost','QyQXs','height','LearnDefeats','BranchLearnable','isAttack','LearnPhysSkill','kda','MeetsLearnConditions','ieRuh','totalHealDeal','CapacityIcon','initEquipMedalSystem','setTempActor','GetElements','ElementStatusCore','\x5cI[%1]','evaded','YaRkx','LearnStateDeal','jQsFw','gold','Window_EquipCommand_onTouchSelectModernControls','QZEoy','updateEquipMedalActionUsage','EQUIP_MEDAL_SYS','isActor','Scene_Boot_onDatabaseLoaded','gaugeBackColor','xBkTf','commandEquipMedals','_equipMedalExp','learnEquippedMedal','LearnTotalHealTake','onDatabaseLoaded','MedalIDs','progressComplete','PDR','ConvertParams','itemAt','call','updateStatusWindow','progressFraction','textSizeEx','rVpCs','Game_Actor_changeExp','getLearnEquippedMedalRawIDs','Receive\x20%1\x20Total\x20Battle\x20Healing\x20%2','1729343govsQn','Settings','EvolutionNext','addEquipMedalExp','%1\x20has\x20acquired\x20%3%2!','Receive\x20%1\x20Total\x20Battle\x20Damage\x20%2','\x5cI[%1]%2','equipMedalWindowRect','drawItem','elementId','\x5cI[87]','%1\x20is\x20missing\x20a\x20required\x20plugin.\x0aPlease\x20install\x20%2\x20into\x20the\x20Plugin\x20Manager.','LinkLearn','rgyYf','setStatusWindow','allowCommandWindowCursorUp','_getEquipMedalEvolutionData','costNumber','YHFMD','currentSymbol','CmUUa','inBattle','Window_EquipCommand_isUseModernControls','JUtVq','CNT','Window_EquipCommand_processDownCursorSpecialCheckModernControls','learnAutoEquip','LjazA','availableUnlearnedEquippableMedals','cLIUL','updateEquipMedalKda','wiXuj','iconHeight','XhkFg','_cache','vDCSh','LearnAny','getStypeIdWithName','tFxrG','CsdsI','getLearnableEquippableMedalsFromObj','qjcvm','resetTextColor','skillUse','arePageButtonsEnabled','atypeId','MHP','LearnVictory','costFmt','processBattleCoreJS','RLABw','%1\x27s\x20version\x20does\x20not\x20match\x20plugin\x27s.\x20Please\x20update\x20it\x20in\x20the\x20Plugin\x20Manager.','displayRewards','stype','isEnemy','ARRAYSTR','match','222UvZGkE','MedalFullGauge','removeEquipMedal','isLearnedEquippedMedal','EquipMedalList_BgType','showUnlearned','LearnCertSkill','SortStyle','stateDeal','_scene','learnShowTextPopup','maskIcon','stypeId','isBattleMember','expParams','helpNothing','LearnCountAssists','phYWJ','gprEn','Take\x20%1\x20Critical\x20Hits\x20%2','round','YXwvs','sjqZL','_slotWindow','expFormula','updateEquipMedalHpChanges','_learnableEquippableMedals','removeUnlearnedEquippableMedal','addUnlearnedEquippableMedal','totalDmgTake','deadMembers','MRG','vduik','equipMedalMaxCapacity','showStatusWindow','PZQpC','medalStatusWindowRect','deselect','SoaFD','setBackgroundType','klTDL','MaskItalics','isrQB','getArmorIdWithName','PHA','MedalExpFormula','meeSo','playCursorSound','getStateIdWithName','selectLast','Inflict\x20%3\x20%1\x20Times\x20%2','exp','drawIcon','RoQwd','progressPercent','LearnElementDeal','Kill\x20%1\x20Enemies\x20%2','ATK','KvgEH','VisuMZ_0_CoreEngine','isAlive','grBBX','haveItem','haveGold','status','Deal','MaskLetter','Window_EquipCommand_isEquipCommandAdded','equipMedalExpVisible','DPGOg','\x5c}MASTERED!\x5c{','systemColor','BFXDq','forceSelect','LearnMagSkill','width','LearnTotalHealDeal','Window','setHelpWindow','parameters','vwbss','setText','allMembers','sortItems','Game_Actor_releaseUnequippableItems','select','iFyoC','resetFontSettings','apply','WKdfA','isMagical','isOptimizeCommandAdded','Dmg','Glory','isEquipCommandAdded','ExpGaugeColor1','-----','Zeqyr','atype','TCR','equipMedalColor','level','guard','separateUnlearned','Guard\x20%1\x20Times\x20%2','RegExp','lineHeight','LearnMissTimes','BattleManager_displayRewards','toFixed','ActorLearnMedal','bwpmi','4070631BmPpxX','missed','pop','HasFullExpGauge','hasEquipMedalCapacityFor','IcUHt','Game_Party_initialize','LeAGg','forgetEquippedMedal','FCQFp','oKmsg','filter','XwaVG','shouldCommandWindowExist','makeCommandList','LearnDefeatTrait','zjwqX','showCost1','GHFgw','VisuMZ_2_EquipSetBonuses','CapacityFormula','isPhysical','_stateIDs','join','isEquipMedalCommandVisible','LearnLevel','getElementIdWithName','JSON','Scene_Equip_refreshActor','ARRAYJSON','CRI','erZlQ','gainHp','pzmdz','subject','fLLUQ','Window_EquipCommand_makeCommandList','zBBPy','TKyAi','branchLearnEquipMedals','getEquipMedalEvolutionData','VisuMZ_1_ItemsEquipsCore','ShowTextPopup','82290yiRspX','isCurrentItemEnabled','HideLearnedAnyName','bgType','STR','LearnGuardTimes','ActorAddUnlearnedMedal','user','_data','LearnTakeCritHitTimes','Inflict\x20%3\x20Damage\x20%1\x20Times\x20%2','LearnedEquipMedals','guardTimes','Show','IsMedalHidden','_tempActor','HideLearnedAllName','Take','maskItalics','Game_Actor_paramPlus','onEquipMedalCancel','FPvdx','_bypassUnequipHiddenMedal','zUmHp','ActorGainMedalExp','ARRAYSTRUCT','MRF','createEquipMedalWindow','updateEquipMedalBattleEscape','maskLetter','gPYnl','DefaultCost','CustomEquipText','dmgTake','log','_lastCurrentSymbol','expTextOffsetX','EVA','TGR','gainRewardsEquipMedalExp','maxExpTextFormat','getColor','HHjdC','LearnDealCritHitTimes','show','lkVSt','MFJoO','HelpFmt','checkLearnNewEquipMedals','Die\x20%1\x20Times\x20%2','heal','_rewards','IsMasked','gainEquipMedalExp','isTriggered','minCapacity','processEquipMedal','equipMedalCurrentCapacity','\x5c}%1/%2\x20(%3%)\x5c{','getEquipMedalLearnProgress','sVCXQ','XARKt','MinimumCost','TOAhz','LearnPopup','skillTypes','fUTkY','isSkill','changeExp','LVzNe','WPBLV','test','stateTake','assists','drawVisualStyleGauge','TextPopupFmt','hasEquipMedalEvolution','\x5cC[%1]%2\x5cC[0]','iconWidth','Imported.VisuMZ_1_ElementStatusCore\x20needs\x20to\x20be\x20updated\x20','Possess\x20%3\x20×%1\x20%2','sortBy','registerCommand','VRGvP','updateForEquipMedals','defaultShowEquipMedal','SeparateUnlearned','paramPlus','format','name','description','LearnEscapes','params','GetGaugeHeight','_equipMedalSys_SceneSkill','ZIwGY','LearnElementTake','displayRewardsEquipMedalExp','updateEquipMedalBattleDefeat','LearnHaveItem','getEquipMedalName','length','BGSid','MAX\x20HP','\x5c}Unacquired\x5c{','executeDamage','initialize','HRG','parse','hideFormerEvolution','tPMFO','Medals','version','bind','return\x200','equipAdjustHpMp','addEquipMedalCommand','equipMedalExp','Evolution','isClearCommandAdded','indexOf','elementTake','UqHbR','reduce','getEquipMedalEvolutionID','ySAEP','constructor','getItemIdWithName','command','exit','isGuard','replace','some','slrKr','VOtrg','QhEhW','YrEaB','FUNC','drawGauge','REC','HideUnlearned','Window_EquipCommand_callUpdateHelp','attack','split','getLearnableEquippableMedalIDs','pVZPa','oZAQJ','LearnHaveParam','prototype','isItem','LearnHaveSParam','JnwCf','Game_Actor_traitObjects','FGcvn','Medal\x20Slots','refreshActor','showWindow','BIYRl','Math.ceil(user.level\x20/\x2010)','setupInitialLearnedEquippableMedals','equipMedalExpRate','initialLevel','concat','XSJPz','skill','rewardMessageFmt','MAX\x20MP','_equippedMedals','DrXKK','UMTRf','xparam','zuPVH','GlobalAddUnlearnedMedal','Possess\x20×%1%3\x20%2','equipColor','onBattleEnd','Game_Action_apply','xmIiK','visible','activate','dmg','_subject','defaultCost','_statusWindow','GcHJD','Use\x20%1\x20%3\x20Skills\x20%2','hide','Game_System_initialize','_cache_actor_getLearnableEquippableMedals','gbpgX','MvTQU','addCommand','certainHitSkill','LUK','%2%1','setupInitialAlreadyEquippedMedals','5547186jMVWzo','Assist\x20%1\x20Times\x20%2','KxUFw','jdJmB','Game_Action_executeDamage','VisuMZ_1_MessageCore','nickname','cancel','2isYTji','_actor','isPlaytest','%1/%2%3','EVAL','IrlNo','includes','setEquipMedalCommandVisible','483pzizVw'];_0x5074=function(){return _0x499089;};return _0x5074();}if(VisuMZ['CoreEngine'][_0x5b5488(0x262)]<1.79){let text='';text+=_0x5b5488(0x346),text+='in\x20order\x20for\x20VisuMZ_2_EquipMedalSys\x20to\x20work.',alert(text),SceneManager[_0x5b5488(0x273)]();}if(VisuMZ[_0x5b5488(0x3bc)][_0x5b5488(0x262)]<1.5){let text='';text+='VisuMZ_1_ItemsEquipsCore\x20needs\x20to\x20be\x20updated\x20',text+='in\x20order\x20for\x20VisuMZ_2_EquipMedalSys\x20to\x20work.',alert(text),SceneManager[_0x5b5488(0x273)]();}PluginManager[_0x5b5488(0x244)](pluginData['name'],_0x5b5488(0x20a),_0x1876ff=>{const _0x4d0fd2=_0x5b5488;VisuMZ[_0x4d0fd2(0x114)](_0x1876ff,_0x1876ff);const _0x1f7e49=_0x1876ff[_0x4d0fd2(0x2ec)]||[],_0x5a0cc9=_0x1876ff['MedalEXP']||[],_0x2346e8=!_0x1876ff[_0x4d0fd2(0x1f1)];for(const _0xcb0e50 of _0x1f7e49){if(_0x4d0fd2(0x3c4)==='ASgJZ'){const _0xbb6797=$gameActors[_0x4d0fd2(0x33f)](_0xcb0e50);if(!_0xbb6797)continue;_0xbb6797['gainEquipMedalExp'](_0x5a0cc9,_0x2346e8);}else this[_0x4d0fd2(0x400)](_0x29b3bf,'actionTimes',_0x4d0fd2(0x280),0x1);}}),PluginManager[_0x5b5488(0x244)](pluginData[_0x5b5488(0x24b)],_0x5b5488(0x344),_0x296e83=>{const _0x108d11=_0x5b5488;VisuMZ[_0x108d11(0x114)](_0x296e83,_0x296e83);const _0x34b1dc=_0x296e83['ActorIDs']||[],_0x2860de=_0x296e83[_0x108d11(0x407)]||[],_0x40a27f=!_0x296e83[_0x108d11(0x1f1)];for(const _0x489a8d of _0x34b1dc){const _0x48c6a1=$gameActors[_0x108d11(0x33f)](_0x489a8d);if(!_0x48c6a1)continue;_0x48c6a1['addEquipMedalExp'](_0x2860de,_0x40a27f);}}),PluginManager['registerCommand'](pluginData[_0x5b5488(0x24b)],_0x5b5488(0x1c5),_0x5be1e0=>{const _0x4b1e4e=_0x5b5488;VisuMZ[_0x4b1e4e(0x114)](_0x5be1e0,_0x5be1e0);const _0x508add=_0x5be1e0[_0x4b1e4e(0x2ec)]||[],_0x5b8cde=_0x5be1e0[_0x4b1e4e(0x111)]||[],_0x1d34ad=!_0x5be1e0[_0x4b1e4e(0x1f1)];for(const _0x362e76 of _0x508add){const _0x596f79=$gameActors['actor'](_0x362e76);if(!_0x596f79)continue;for(const _0x3c8fed of _0x5b8cde){if('cjySx'===_0x4b1e4e(0x3cd)){const _0x4f2857=_0x1d04c2(_0x477931['$1']);_0x4f2857<_0x5c36f6?(_0x4d8f17('%1\x20is\x20incorrectly\x20placed\x20on\x20the\x20plugin\x20list.\x0aIt\x20is\x20a\x20Tier\x20%2\x20plugin\x20placed\x20over\x20other\x20Tier\x20%3\x20plugins.\x0aPlease\x20reorder\x20the\x20plugin\x20list\x20from\x20smallest\x20to\x20largest\x20tier\x20numbers.'[_0x4b1e4e(0x24a)](_0x1cdae8,_0x4f2857,_0x282f2a)),_0x5956f6[_0x4b1e4e(0x273)]()):_0xa94196=_0x571b41[_0x4b1e4e(0x2cd)](_0x4f2857,_0x572422);}else{const _0x4952a0=$dataArmors[_0x3c8fed];if(!_0x4952a0)continue;if(_0x4952a0[_0x4b1e4e(0x24b)][_0x4b1e4e(0x374)]()==='')continue;if(_0x4952a0['name']['includes'](_0x4b1e4e(0x1b7)))continue;_0x596f79[_0x4b1e4e(0x10e)](_0x4952a0,_0x1d34ad);}}}}),PluginManager[_0x5b5488(0x244)](pluginData[_0x5b5488(0x24b)],'ActorForgetMedal',_0x2a21ae=>{const _0x25b359=_0x5b5488;VisuMZ[_0x25b359(0x114)](_0x2a21ae,_0x2a21ae);const _0x456c18=_0x2a21ae['ActorIDs']||[],_0x34de14=_0x2a21ae[_0x25b359(0x111)]||[];for(const _0x2ada19 of _0x456c18){const _0x6c5ec9=$gameActors[_0x25b359(0x33f)](_0x2ada19);if(!_0x6c5ec9)continue;for(const _0x2138bb of _0x34de14){if(_0x25b359(0x3ec)!==_0x25b359(0x3ec))return this[_0x25b359(0x1ef)](_0x3d893c)[_0x25b359(0x18a)]||0x0;else{const _0x5a8a2a=$dataArmors[_0x2138bb];if(!_0x5a8a2a)continue;if(_0x5a8a2a['name'][_0x25b359(0x374)]()==='')continue;if(_0x5a8a2a[_0x25b359(0x24b)]['includes']('-----'))continue;_0x6c5ec9['forgetEquippedMedal'](_0x5a8a2a);}}}}),PluginManager[_0x5b5488(0x244)](pluginData[_0x5b5488(0x24b)],_0x5b5488(0x1f8),_0x548939=>{const _0x566aea=_0x5b5488;VisuMZ['ConvertParams'](_0x548939,_0x548939);const _0x1dc6ed=_0x548939['ActorIDs']||[],_0x4f096f=_0x548939[_0x566aea(0x111)]||[];for(const _0x1ce73a of _0x1dc6ed){const _0x52b330=$gameActors[_0x566aea(0x33f)](_0x1ce73a);if(!_0x52b330)continue;for(const _0x55474b of _0x4f096f){const _0x404ed7=$dataArmors[_0x55474b];if(!_0x404ed7)continue;if(_0x404ed7['name'][_0x566aea(0x374)]()==='')continue;if(_0x404ed7[_0x566aea(0x24b)][_0x566aea(0x2c4)]('-----'))continue;_0x52b330[_0x566aea(0x173)](_0x404ed7);}}}),PluginManager[_0x5b5488(0x244)](pluginData[_0x5b5488(0x24b)],'ActorRemoveUnlearnedMedal',_0xf9c031=>{const _0x4bf5ca=_0x5b5488;VisuMZ[_0x4bf5ca(0x114)](_0xf9c031,_0xf9c031);const _0x4c7abf=_0xf9c031[_0x4bf5ca(0x2ec)]||[],_0x3c7f50=_0xf9c031[_0x4bf5ca(0x111)]||[];for(const _0x45538e of _0x4c7abf){const _0x1f9be3=$gameActors['actor'](_0x45538e);if(!_0x1f9be3)continue;for(const _0x226989 of _0x3c7f50){const _0x3d9943=$dataArmors[_0x226989];if(!_0x3d9943)continue;if(_0x3d9943[_0x4bf5ca(0x24b)][_0x4bf5ca(0x374)]()==='')continue;if(_0x3d9943[_0x4bf5ca(0x24b)][_0x4bf5ca(0x2c4)](_0x4bf5ca(0x1b7)))continue;_0x1f9be3['removeUnlearnedEquippableMedal'](_0x3d9943);}}}),PluginManager[_0x5b5488(0x244)](pluginData[_0x5b5488(0x24b)],_0x5b5488(0x3e5),_0x38edb2=>{const _0x540b0a=_0x5b5488;VisuMZ['ConvertParams'](_0x38edb2,_0x38edb2);const _0x18dbeb=_0x38edb2[_0x540b0a(0x111)]||[],_0x448261=!_0x38edb2[_0x540b0a(0x1f1)];for(const _0x21a4c0 of _0x18dbeb){if('UOFWD'===_0x540b0a(0x100)){const _0xcf947a=_0x54e284[_0x540b0a(0x405)][_0x540b0a(0x418)](this[_0x540b0a(0x2bf)],this['item']());if(this['_helpWindow'])this[_0x540b0a(0x2de)][_0x540b0a(0x1a8)](_0xcf947a);if(this[_0x540b0a(0x2a9)])this[_0x540b0a(0x2a9)][_0x540b0a(0xfb)](null);}else{const _0x35ed27=$dataArmors[_0x21a4c0];if(!_0x35ed27)continue;if(_0x35ed27[_0x540b0a(0x24b)][_0x540b0a(0x374)]()==='')continue;if(_0x35ed27[_0x540b0a(0x24b)]['includes'](_0x540b0a(0x1b7)))continue;$gameParty['learnEquippedMedal'](_0x35ed27,_0x448261);}}}),PluginManager[_0x5b5488(0x244)](pluginData[_0x5b5488(0x24b)],'GlobalForgetMedal',_0xd62aea=>{const _0x2fad06=_0x5b5488;VisuMZ['ConvertParams'](_0xd62aea,_0xd62aea);const _0x237652=_0xd62aea[_0x2fad06(0x111)]||[];for(const _0x280278 of _0x237652){const _0x1b05ee=$dataArmors[_0x280278];if(!_0x1b05ee)continue;if(_0x1b05ee[_0x2fad06(0x24b)][_0x2fad06(0x374)]()==='')continue;if(_0x1b05ee['name'][_0x2fad06(0x2c4)](_0x2fad06(0x1b7)))continue;$gameParty[_0x2fad06(0x1cf)](_0x1b05ee);}}),PluginManager[_0x5b5488(0x244)](pluginData['name'],_0x5b5488(0x29e),_0x4c2734=>{const _0x57d119=_0x5b5488;VisuMZ[_0x57d119(0x114)](_0x4c2734,_0x4c2734);const _0x65831e=_0x4c2734[_0x57d119(0x111)]||[];for(const _0x3410ad of _0x65831e){if(_0x57d119(0x394)!==_0x57d119(0x394)){const _0x1448b7=_0x572a0f(_0x5118d8['$1'])[_0x57d119(0x281)](',')[_0x57d119(0x32c)](_0x22a9f0=>_0x45fecf(_0x22a9f0));if(_0x1448b7[_0x57d119(0x276)](_0x4b4651=>_0x42c477[_0x57d119(0x15a)](_0x2b2e57[_0x4b4651])))return!![];}else{const _0x5842f4=$dataArmors[_0x3410ad];if(!_0x5842f4)continue;if(_0x5842f4[_0x57d119(0x24b)][_0x57d119(0x374)]()==='')continue;if(_0x5842f4[_0x57d119(0x24b)][_0x57d119(0x2c4)]('-----'))continue;$gameParty[_0x57d119(0x173)](_0x5842f4);}}}),PluginManager[_0x5b5488(0x244)](pluginData['name'],_0x5b5488(0x353),_0x2aef00=>{const _0x12c2ca=_0x5b5488;VisuMZ[_0x12c2ca(0x114)](_0x2aef00,_0x2aef00);const _0x4e4a84=_0x2aef00[_0x12c2ca(0x111)]||[];for(const _0x5e2c8a of _0x4e4a84){const _0x4b7d1b=$dataArmors[_0x5e2c8a];if(!_0x4b7d1b)continue;if(_0x4b7d1b[_0x12c2ca(0x24b)][_0x12c2ca(0x374)]()==='')continue;if(_0x4b7d1b[_0x12c2ca(0x24b)][_0x12c2ca(0x2c4)]('-----'))continue;$gameParty[_0x12c2ca(0x172)](_0x4b7d1b);}}),PluginManager[_0x5b5488(0x244)](pluginData[_0x5b5488(0x24b)],_0x5b5488(0x31c),_0x13356d=>{const _0x375e8d=_0x5b5488;VisuMZ['ConvertParams'](_0x13356d,_0x13356d);const _0x5f581b=_0x13356d[_0x375e8d(0x1ff)];$gameSystem['setEquipMedalCommandVisible'](_0x5f581b);}),VisuMZ[_0x5b5488(0x405)]['RegExp']={'EquipCost':/<EQUIP MEDAL (?:COST|SLOTS):[ ](\d+)>/i,'EquipIcon':/<EQUIP MEDAL ICON:[ ](\d+)>/i,'EquipName':/<EQUIP MEDAL NAME:[ ](.*)>/i,'CustomEquipText':/<EQUIP(?:|PED) MEDAL (?:HELP|HELP |)(?:TEXT|DESC|DESCRIPTION)>\s*([\s\S]*)\s*<\/EQUIP(?:|PED) MEDAL (?:HELP|HELP |)(?:TEXT|DESC|DESCRIPTION)>/i,'HideUnlearned':/<HIDE IF NOT LEARNED EQUIP MEDAL>/i,'HideLearnedAllID':/<HIDE IF LEARNED (?:|ALL )EQUIP MEDAL(?:|S):[ ](\d+)>/i,'HideLearnedAnyID':/<HIDE IF LEARNED ANY EQUIP MEDAL(?:|S):[ ](.*)>/i,'HideLearnedAllName':/<HIDE IF LEARNED (?:|ALL )EQUIP MEDAL(?:|S):[ ](.*)>/i,'HideLearnedAnyName':/<HIDE IF LEARNED ANY EQUIP MEDAL(?:|S):[ ](.*)>/i,'MaskUnlearned':/<MASK IF NOT LEARNED EQUIP MEDAL>/i,'NoMaskUnlearned':/<NO MASK IF NOT LEARNED EQUIP MEDAL>/i,'MaskName':/<EQUIP MEDAL MASK NAME: (.*)>/i,'LearnedEquipMedals':/<LEARNED EQUIP(?:|PED) MEDAL(?:|S):[ ](.*)>/i,'AlreadyEquipMedals':/<ALREADY EQUIP(?:|PED) MEDAL(?:|S):[ ](.*)>/i,'LearnableEquipMedalsA':/<LEARNABLE EQUIP(?:|PED) MEDAL(?:|S):[ ](.*)>/i,'LearnableEquipMedalsB':/<LEARNABLE EQUIP(?:|PED) MEDAL(?:|S)>\s*([\s\S]*)\s*<\/LEARNABLE EQUIP(?:|PED) MEDAL(?:|S)>/i,'BranchLearn':/<BRANCH LEARN EQUIP MEDAL(?:|S):[ ](.*)>/i,'BranchLearnable':/<BRANCH LEARNABLE EQUIP MEDAL(?:|S):[ ](.*)>/i,'ItemLinkLearned':/<LINK LEARN EQUIP MEDAL(?:|S):[ ](.*)>/i,'ItemLinkLearnable':/<LINK LEARNABLE EQUIP MEDAL(?:|S):[ ](.*)>/i,'CustomLearnCondText':/<EQUIP(?:|PED) MEDAL LEARN CONDITION TEXT>\s*([\s\S]*)\s*<\/EQUIP(?:|PED) MEDAL LEARN CONDITION TEXT>/i,'LearnAny':/<EQUIP MEDAL LEARN (.*)>/i,'LearnLevel':/<EQUIP MEDAL LEARN LEVEL:[ ](\d+)>/i,'LearnBattles':/<EQUIP MEDAL LEARN BATTLES:[ ](\d+)>/i,'LearnVictory':/<EQUIP MEDAL LEARN VICTORIES:[ ](\d+)>/i,'LearnEscapes':/<EQUIP MEDAL LEARN ESCAPES:[ ](\d+)>/i,'LearnDefeats':/<EQUIP MEDAL LEARN DEFEATS:[ ](\d+)>/i,'LearnAttackTimes':/<EQUIP MEDAL LEARN ATTACK TIMES:[ ](\d+)>/i,'LearnGuardTimes':/<EQUIP MEDAL LEARN GUARD TIMES:[ ](\d+)>/i,'LearnSkillUsage':/<EQUIP MEDAL LEARN USE SKILLS:[ ](\d+)>/i,'LearnPhysSkill':/<EQUIP MEDAL LEARN USE PHYSICAL SKILLS:[ ](\d+)>/i,'LearnMagSkill':/<EQUIP MEDAL LEARN USE MAGICAL SKILLS:[ ](\d+)>/i,'LearnCertSkill':/<EQUIP MEDAL LEARN USE CERTAIN HIT SKILLS:[ ](\d+)>/i,'LearnItemUsage':/<EQUIP MEDAL LEARN USE ITEMS:[ ](\d+)>/i,'LearnDealCritHitTimes':/<EQUIP MEDAL LEARN (?:DEAL|INFLICT) CRIT(?:|S|ICAL)(?:| HIT) TIMES:[ ](\d+)>/i,'LearnTakeCritHitTimes':/<EQUIP MEDAL LEARN (?:TAKE|RECEIVE) CRIT(?:|S|ICAL)(?:| HIT) TIMES:[ ](\d+)>/i,'LearnMissTimes':/<EQUIP MEDAL LEARN (?:MISS|MISSED) TIMES:[ ](\d+)>/i,'LearnEvadeTimes':/<EQUIP MEDAL LEARN (?:EVADE|EVASION) TIMES:[ ](\d+)>/i,'LearnSTypeUsage':/<EQUIP MEDAL LEARN USE STYPE (.*):[ ](\d+)>/gi,'LearnElementDeal':/<EQUIP MEDAL LEARN (?:DEAL|INFLICT) ELEMENT (.*) (?:DMG|DAMAGE):[ ](\d+)>/gi,'LearnElementTake':/<EQUIP MEDAL LEARN (?:TAKE|RECEIVE) ELEMENT (.*) (?:DMG|DAMAGE):[ ](\d+)>/gi,'LearnStateDeal':/<EQUIP MEDAL LEARN (?:DEAL|INFLICT) STATE (.*):[ ](\d+)>/gi,'LearnStateTake':/<EQUIP MEDAL LEARN (?:TAKE|RECEIVE) STATE (.*):[ ](\d+)>/gi,'LearnDefeatTrait':/<EQUIP MEDAL LEARN DEFEAT (.*) TRAIT:[ ](\d+)>/gi,'LearnTotalDmgDeal':/<EQUIP MEDAL LEARN (?:DEAL|INFLICT) TOTAL (?:DMG|DAMAGE):[ ](\d+)>/gi,'LearnTotalDmgTake':/<EQUIP MEDAL LEARN (?:TAKE|RECEIVE) TOTAL (?:DMG|DAMAGE):[ ](\d+)>/gi,'LearnTotalHealDeal':/<EQUIP MEDAL LEARN (?:DEAL|INFLICT) TOTAL (?:HEAL|HEALING):[ ](\d+)>/gi,'LearnTotalHealTake':/<EQUIP MEDAL LEARN (?:TAKE|RECEIVE) TOTAL (?:HEAL|HEALING):[ ](\d+)>/gi,'LearnCountKills':/<EQUIP MEDAL LEARN KILL COUNT:[ ](\d+)>/gi,'LearnCountDeaths':/<EQUIP MEDAL LEARN DEATH COUNT:[ ](\d+)>/gi,'LearnCountAssists':/<EQUIP MEDAL LEARN ASSIST COUNT:[ ](\d+)>/gi,'LearnHaveGold':/<EQUIP MEDAL LEARN (?:HAVE|REACH) GOLD:[ ](\d+)>/i,'LearnHaveItem':/<EQUIP MEDAL LEARN (?:HAVE|REACH) ITEM (.*):[ ](\d+)>/gi,'LearnHaveWeapon':/<EQUIP MEDAL LEARN (?:HAVE|REACH) WEAPON (.*):[ ](\d+)>/gi,'LearnHaveArmor':/<EQUIP MEDAL LEARN (?:HAVE|REACH) ARMOR (.*):[ ](\d+)>/gi,'LearnHaveParam':/<EQUIP MEDAL LEARN (?:HAVE|REACH) (?:|BASE )PARAM[ ](.*):[ ](\d+)>/gi,'LearnHaveXParam':/<EQUIP MEDAL LEARN (?:HAVE|REACH) (?:X|X )PARAM[ ](.*):[ ](\d+)([%％])>/gi,'LearnHaveSParam':/<EQUIP MEDAL LEARN (?:HAVE|REACH) (?:S|S )PARAM[ ](.*):[ ](\d+)([%％])>/gi,'Evolution':/<EQUIP MEDAL EVOLVE(?:|S) (?:INTO |TO |)(.*):[ ](\d+)>/i,'EvolutionNext':/<EQUIP MEDAL EVOLVE(?:|S) (?:INTO |TO |)NEXT:[ ](\d+)>/i,'EnemyMedalExp':/<(?:EQUIP |)MEDAL EXP:[ ](.*)>/i,'MedalExpRate':/<(?:EQUIP |)MEDAL EXP RATE:[ ](\d+)([%％])>/i,'MedalFullGauge':/<(?:EQUIP |)MEDAL FULL EXP GAUGE>/i,'MedalGaugeColor1':/<(?:EQUIP |)MEDAL EXP GAUGE COLOR 1:[ ](.*)>/i,'MedalGaugeColor2':/<(?:EQUIP |)MEDAL EXP GAUGE COLOR 2:[ ](.*)>/i},VisuMZ[_0x5b5488(0x405)]['Scene_Boot_onDatabaseLoaded']=Scene_Boot[_0x5b5488(0x286)]['onDatabaseLoaded'],Scene_Boot[_0x5b5488(0x286)][_0x5b5488(0x110)]=function(){const _0x4a032f=_0x5b5488;VisuMZ[_0x4a032f(0x405)][_0x4a032f(0x109)]['call'](this),VisuMZ[_0x4a032f(0x405)][_0x4a032f(0x3d0)]();},VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x3d0)]=function(){const _0x4e3b7c=_0x5b5488;if(Imported['VisuMZ_1_ElementStatusCore']&&VisuMZ[_0x4e3b7c(0xfd)]['version']<1.23){let _0x46a1f1='';_0x46a1f1+=_0x4e3b7c(0x241),_0x46a1f1+=_0x4e3b7c(0x319),alert(_0x46a1f1),SceneManager[_0x4e3b7c(0x273)]();}},DataManager[_0x5b5488(0x143)]=function(_0xe4eb5){const _0x4f87ff=_0x5b5488;_0xe4eb5=_0xe4eb5[_0x4f87ff(0x33c)]()['trim'](),this[_0x4f87ff(0x2f4)]=this['_stypeIDs']||{};if(this['_stypeIDs'][_0xe4eb5])return this[_0x4f87ff(0x2f4)][_0xe4eb5];for(let _0x2692e3=0x1;_0x2692e3<0x64;_0x2692e3++){if(_0x4f87ff(0x141)!==_0x4f87ff(0x181)){if(!$dataSystem[_0x4f87ff(0x233)][_0x2692e3])continue;let _0x1f2769=$dataSystem[_0x4f87ff(0x233)][_0x2692e3][_0x4f87ff(0x33c)]()['trim']();_0x1f2769=_0x1f2769[_0x4f87ff(0x275)](/\x1I\[(\d+)\]/gi,''),_0x1f2769=_0x1f2769[_0x4f87ff(0x275)](/\\I\[(\d+)\]/gi,''),this[_0x4f87ff(0x2f4)][_0x1f2769]=_0x2692e3;}else _0x4a42ba[_0x6637c1['id']][_0x4f87ff(0x2df)](_0x27476d);}return this[_0x4f87ff(0x2f4)][_0xe4eb5]||0x0;},DataManager[_0x5b5488(0x187)]=function(_0x337e4a){const _0x1ec335=_0x5b5488;_0x337e4a=_0x337e4a['toUpperCase']()[_0x1ec335(0x374)](),this[_0x1ec335(0x1dd)]=this[_0x1ec335(0x1dd)]||{};if(this[_0x1ec335(0x1dd)][_0x337e4a])return this[_0x1ec335(0x1dd)][_0x337e4a];for(const _0x51a9ef of $dataStates){if('mQfks'!=='jXldK'){if(!_0x51a9ef)continue;this[_0x1ec335(0x1dd)][_0x51a9ef[_0x1ec335(0x24b)][_0x1ec335(0x33c)]()[_0x1ec335(0x374)]()]=_0x51a9ef['id'];}else _0x57dd63=_0xc50b62(_0x3193b8['$1'])[_0x1ec335(0x374)]();}return this[_0x1ec335(0x1dd)][_0x337e4a]||0x0;},DataManager['getElementIdWithName']=function(_0x2947fc){const _0x9efa61=_0x5b5488;_0x2947fc=_0x2947fc['toUpperCase']()[_0x9efa61(0x374)](),this['_elementIDs']=this[_0x9efa61(0x354)]||{};if(this[_0x9efa61(0x354)][_0x2947fc])return this[_0x9efa61(0x354)][_0x2947fc];let _0x4167a0=0x1;for(const _0x411d7e of $dataSystem[_0x9efa61(0x416)]){if(_0x9efa61(0x2ea)!==_0x9efa61(0x2d5)){if(!_0x411d7e)continue;let _0x5c4df1=_0x411d7e[_0x9efa61(0x33c)]();_0x5c4df1=_0x5c4df1['replace'](/\x1I\[(\d+)\]/gi,''),_0x5c4df1=_0x5c4df1[_0x9efa61(0x275)](/\\I\[(\d+)\]/gi,''),this[_0x9efa61(0x354)][_0x5c4df1]=_0x4167a0,_0x4167a0++;}else{_0x497b03['ConvertParams'](_0x5d0095,_0x5aed18);const _0x3987ab=_0x215955[_0x9efa61(0x1ff)];_0xf4cf8a[_0x9efa61(0x2c5)](_0x3987ab);}}return this['_elementIDs'][_0x2947fc]||0x0;},DataManager[_0x5b5488(0x42b)]=function(_0x294fe5){const _0x480a70=_0x5b5488;if(!this[_0x480a70(0x389)](_0x294fe5))return 0x0;this[_0x480a70(0x42d)]=this['_getEquipMedalCost']||{};if(this[_0x480a70(0x42d)][_0x294fe5['id']]!==undefined)return this[_0x480a70(0x42d)][_0x294fe5['id']];let _0x66c89d=Game_Actor['EQUIP_MEDAL_SYS'][_0x480a70(0x2a8)]||0x1;const _0x45e134=VisuMZ[_0x480a70(0x405)][_0x480a70(0x1c0)],_0x2266c2=_0x294fe5[_0x480a70(0x3f3)]||'';if(_0x2266c2['match'](_0x45e134[_0x480a70(0x315)])){if(_0x480a70(0x169)===_0x480a70(0x3ae)){const _0x44c758=_0x51e325(_0x461a87['$1']);if(_0x44c758>_0x1a38c8['getEquipMedalLearnProgress'](_0x207d17,_0x480a70(0x2fb),_0x480a70(0x303)))return![];_0x5589c1=!![];}else _0x66c89d=Number(RegExp['$1']);}return this[_0x480a70(0x42d)][_0x294fe5['id']]=_0x66c89d,this[_0x480a70(0x42d)][_0x294fe5['id']];},DataManager[_0x5b5488(0x2cb)]=function(_0x419a49){const _0x35df85=_0x5b5488;if(!this[_0x35df85(0x389)](_0x419a49))return 0x0;this['_getEquipMedalIcon']=this[_0x35df85(0x2f8)]||{};if(this[_0x35df85(0x2f8)][_0x419a49['id']]!==undefined)return this[_0x35df85(0x2f8)][_0x419a49['id']];let _0x540f4f=_0x419a49['iconIndex']||ImageManager[_0x35df85(0x107)]['icon'];const _0x1eea62=VisuMZ[_0x35df85(0x405)][_0x35df85(0x1c0)],_0xf2ae7d=_0x419a49[_0x35df85(0x3f3)]||'';return _0xf2ae7d[_0x35df85(0x156)](_0x1eea62[_0x35df85(0x39a)])&&(_0x540f4f=Number(RegExp['$1'])),this[_0x35df85(0x2f8)][_0x419a49['id']]=_0x540f4f,this['_getEquipMedalIcon'][_0x419a49['id']];},DataManager[_0x5b5488(0x256)]=function(_0x26c6b7){const _0x457245=_0x5b5488;if(!this['isArmor'](_0x26c6b7))return 0x0;this[_0x457245(0x33d)]=this[_0x457245(0x33d)]||{};if(this[_0x457245(0x33d)][_0x26c6b7['id']]!==undefined)return this[_0x457245(0x33d)][_0x26c6b7['id']];let _0x3db991=_0x26c6b7['name']||'';const _0x11279b=VisuMZ[_0x457245(0x405)][_0x457245(0x1c0)],_0x33788d=_0x26c6b7[_0x457245(0x3f3)]||'';if(_0x33788d[_0x457245(0x156)](_0x11279b[_0x457245(0x2fc)])){if(_0x457245(0x2b9)!==_0x457245(0x2b9)){const _0x274fa7=_0x19a72d[_0x457245(0x107)],_0x2a9e63=_0x274fa7[_0x457245(0x3af)];_0x4edf30=_0x26897f[_0x457245(0x373)](0x0,_0x4a19f8);let _0x1d6195='';const _0x3e1af0=_0x2a9e63[_0x457245(0x3a8)],_0x4f4d58=_0x2a9e63[_0x457245(0x118)][_0x457245(0x24a)](_0x116409,_0xbacd9f),_0x7f386=_0x2a9e63[_0x457245(0x18d)][_0x457245(0x24a)](_0x5a2bef[_0x457245(0x16b)](_0x53e071/_0x4078e3*0x64));_0x1d6195=_0x3e1af0[_0x457245(0x24a)](_0x4f4d58[_0x457245(0x257)]>_0x2a9e63[_0x457245(0x38d)]?_0x7f386:_0x4f4d58);if(_0x4dae57[_0x457245(0x257)]>0x0){_0x53490e+=_0x274fa7[_0x457245(0x440)];if(_0x274fa7[_0x457245(0x41e)])_0xc8b06f+='\x20';}return _0x59f6d0>=_0x2fb6bf&&(_0x4dcc51+=_0x457245(0x3a3)[_0x457245(0x24a)](_0x274fa7['helpMeetConditionColor']),_0x1d6195=_0x2a9e63['progressComplete']),_0x32e8fa+=(_0x2a9e63[_0x277cc3]||_0x457245(0x3d7))[_0x457245(0x24a)](_0x1a2ef8,_0x1d6195,_0x1a9b8d||''),_0x2fa38a>=_0x2a7c3c&&(_0x271f40+=_0x457245(0x371)),_0x450cb4;}else _0x3db991=String(RegExp['$1'])['trim']();}return this[_0x457245(0x33d)][_0x26c6b7['id']]=_0x3db991,this[_0x457245(0x33d)][_0x26c6b7['id']];},DataManager[_0x5b5488(0x282)]=function(_0x3524e3){const _0x4db415=_0x5b5488,_0x1c38ce=this[_0x4db415(0x146)](_0x3524e3['actor']()),_0x4e5057=this[_0x4db415(0x146)](_0x3524e3['currentClass']());let _0x232387=_0x1c38ce['concat'](_0x4e5057);return _0x232387=_0x232387['filter']((_0x145626,_0x3cc222,_0x56ccb2)=>_0x56ccb2[_0x4db415(0x26a)](_0x145626)===_0x3cc222),_0x232387;},DataManager[_0x5b5488(0x146)]=function(_0xac2ef5){const _0x7a4578=_0x5b5488;let _0x1635ac=null;this[_0x7a4578(0x2ae)]=this[_0x7a4578(0x2ae)]||{},this['_cache_class_getLearnableEquippableMedals']=this['_cache_class_getLearnableEquippableMedals']||{};if(_0xac2ef5[_0x7a4578(0x293)]!==undefined&&_0xac2ef5[_0x7a4578(0x2bc)]!==undefined)_0x1635ac=this['_cache_actor_getLearnableEquippableMedals'];else{if(_0xac2ef5[_0x7a4578(0x165)]!==undefined&&_0xac2ef5[_0x7a4578(0x33b)]!==undefined){if('ZUtvc'!==_0x7a4578(0x320)){_0x327485['match'](_0x40b435[_0x7a4578(0x18e)]);let _0x1a171a=_0x565e8b(_0xdd1176['$1']);const _0x3b03cc=_0xe75aa2(_0x3f7811['$2']),_0x2f9bc1=/^\d+$/['test'](_0x1a171a);_0x1a171a=_0x2f9bc1?_0x120f76(_0x1a171a):_0x17c313['getElementIdWithName'](_0x1a171a);const _0x31e19a=_0x191db8[_0x7a4578(0x22d)](_0x12c851,'elementDeal',_0x1a171a),_0x2ce747='elementDeal',_0xf05511=_0x1c772a[_0x7a4578(0x416)][_0x1a171a];_0x31a4ba=this[_0x7a4578(0x403)](_0x1434c4,_0x3b03cc,_0x31e19a,_0x2ce747,_0xf05511);}else _0x1635ac=this['_cache_class_getLearnableEquippableMedals'];}else return[];}if(_0x1635ac[_0xac2ef5['id']]!==undefined)return _0x1635ac[_0xac2ef5['id']];_0x1635ac[_0xac2ef5['id']]=[];const _0x4196ca=VisuMZ['EquipMedalSys'][_0x7a4578(0x1c0)],_0x368f14=_0xac2ef5[_0x7a4578(0x3f3)]||'';if(_0x368f14[_0x7a4578(0x156)](_0x4196ca['LearnableEquipMedalsA'])){const _0x265adf=String(RegExp['$1'])['split'](',')[_0x7a4578(0x32c)](_0x165997=>_0x165997['trim']());for(const _0x5c0951 of _0x265adf){const _0x2e5e1e=/^\d+$/[_0x7a4578(0x239)](_0x5c0951);let _0x48a934=0x0;if(_0x2e5e1e){if('DrXKK'===_0x7a4578(0x29a))_0x48a934=Number(_0x5c0951);else{const _0x4ac8a6=_0x3fd97f[_0x7a4578(0x156)](_0x327251[_0x7a4578(0x18e)]);if(_0x4ac8a6)for(const _0xdaeddd of _0x4ac8a6){_0xdaeddd['match'](_0x234783[_0x7a4578(0x18e)]);let _0x50a5ea=_0x1e483b(_0x323ae8['$1']);const _0x1f2a27=_0x20ef80(_0x23e5db['$2']),_0x56a778=/^\d+$/['test'](_0x50a5ea);_0x50a5ea=_0x56a778?_0x1713d9(_0x50a5ea):_0x5d4452['getElementIdWithName'](_0x50a5ea);const _0x3fbf75=_0x388228[_0x7a4578(0x22d)](_0x3bb2f8,_0x7a4578(0x39c),_0x50a5ea),_0x4c0296=_0x7a4578(0x39c),_0x3f8df5=_0x2569b4[_0x7a4578(0x416)][_0x50a5ea];_0x58b1ab=this[_0x7a4578(0x403)](_0x5b5eda,_0x1f2a27,_0x3fbf75,_0x4c0296,_0x3f8df5);}}}else _0x48a934=DataManager['getArmorIdWithName'](_0x5c0951);_0x48a934>0x0&&_0x1635ac[_0xac2ef5['id']][_0x7a4578(0x2df)](_0x48a934);}}if(_0x368f14[_0x7a4578(0x156)](_0x4196ca['LearnableEquipMedalsB'])){const _0x3c7fd9=String(RegExp['$1'])[_0x7a4578(0x281)](/[\r\n]+/);for(const _0x1cd007 of _0x3c7fd9){const _0xfe5633=/^\d+$/['test'](_0x1cd007);let _0x4ab4f4=0x0;_0xfe5633?_0x4ab4f4=Number(_0x1cd007):'oZAQJ'!==_0x7a4578(0x284)?(this[_0x7a4578(0x42e)][_0x7a4578(0x17c)](),this['_equipMedalWindow'][_0x7a4578(0x414)](),this[_0x7a4578(0x31f)][_0x7a4578(0x2a5)](),this[_0x7a4578(0x31f)][_0x7a4578(0x44e)](_0x7a4578(0x40a)),this[_0x7a4578(0x2a9)][_0x7a4578(0xfb)](null)):_0x4ab4f4=DataManager[_0x7a4578(0x182)](_0x1cd007),_0x4ab4f4>0x0&&_0x1635ac[_0xac2ef5['id']][_0x7a4578(0x2df)](_0x4ab4f4);}}return _0x1635ac[_0xac2ef5['id']];},DataManager[_0x5b5488(0x1ef)]=function(_0x342ea0){const _0x4f60f1=_0x5b5488;if(!this['isArmor'](_0x342ea0))return 0x0;this[_0x4f60f1(0x12e)]=this[_0x4f60f1(0x12e)]||{};if(this[_0x4f60f1(0x12e)][_0x342ea0['id']]!==undefined)return this['_getEquipMedalEvolutionData'][_0x342ea0['id']];const _0x60f32d={},_0x499485=VisuMZ[_0x4f60f1(0x405)][_0x4f60f1(0x1c0)],_0x1d3244=_0x342ea0[_0x4f60f1(0x3f3)]||'';if(_0x1d3244[_0x4f60f1(0x156)](_0x499485[_0x4f60f1(0x120)])){if(_0x4f60f1(0x44a)!==_0x4f60f1(0x44a))this['_data']=this['availableItems']();else{const _0x2085c6=Math[_0x4f60f1(0x2cd)](Number(RegExp['$1']),0x1);_0x60f32d[_0x4f60f1(0x3b5)]=_0x342ea0['id']+0x1,_0x60f32d[_0x4f60f1(0x18a)]=_0x2085c6;}}else{if(_0x1d3244['match'](_0x499485[_0x4f60f1(0x268)])){const _0x1ec8f7=String(RegExp['$1'])['trim'](),_0x427fb0=Math[_0x4f60f1(0x2cd)](Number(RegExp['$2']),0x1),_0x4671c8=/^\d+$/[_0x4f60f1(0x239)](_0x1ec8f7);let _0x2b37b2=0x0;_0x4671c8?_0x4f60f1(0x145)!==_0x4f60f1(0x38b)?_0x2b37b2=Number(_0x1ec8f7):this[_0x4f60f1(0x1fa)]=[]:_0x4f60f1(0x345)===_0x4f60f1(0x345)?_0x2b37b2=DataManager[_0x4f60f1(0x182)](_0x1ec8f7):_0x241b61[_0x4f60f1(0x287)]()&&this[_0x4f60f1(0x400)](_0x50c407,_0x4f60f1(0x3dc),_0x4f60f1(0x3a0),0x1);if(_0x2b37b2>0x0){if(_0x4f60f1(0x21c)===_0x4f60f1(0x316)){if(!this[_0x4f60f1(0x389)](_0x23721d))return 0x0;this[_0x4f60f1(0x42d)]=this[_0x4f60f1(0x42d)]||{};if(this[_0x4f60f1(0x42d)][_0x44e019['id']]!==_0x32ac5f)return this[_0x4f60f1(0x42d)][_0x29aed9['id']];let _0x5dd9b1=_0x2af303[_0x4f60f1(0x107)][_0x4f60f1(0x2a8)]||0x1;const _0x3dd382=_0x2de3fc[_0x4f60f1(0x405)]['RegExp'],_0x25410c=_0x151305['note']||'';return _0x25410c['match'](_0x3dd382[_0x4f60f1(0x315)])&&(_0x5dd9b1=_0x3bcee8(_0x330272['$1'])),this[_0x4f60f1(0x42d)][_0xe19f9e['id']]=_0x5dd9b1,this[_0x4f60f1(0x42d)][_0x4aab75['id']];}else _0x60f32d['targetID']=_0x2b37b2,_0x60f32d[_0x4f60f1(0x18a)]=_0x427fb0;}}}return this[_0x4f60f1(0x12e)][_0x342ea0['id']]=_0x60f32d,this[_0x4f60f1(0x12e)][_0x342ea0['id']];},DataManager[_0x5b5488(0x26e)]=function(_0x44c1b0){const _0x2a642f=_0x5b5488;return this['getEquipMedalEvolutionData'](_0x44c1b0)[_0x2a642f(0x3b5)];},DataManager[_0x5b5488(0x3ac)]=function(_0x4fd102){const _0x574175=_0x5b5488;return this[_0x574175(0x1ef)](_0x4fd102)[_0x574175(0x18a)]||0x0;},DataManager['getEquipMedalEvolutionTarget']=function(_0x12c633){const _0x36d5da=_0x5b5488;return $dataArmors[this[_0x36d5da(0x26e)](_0x12c633)];},DataManager[_0x5b5488(0x23e)]=function(_0x426e09){return!!this['getEquipMedalEvolutionTarget'](_0x426e09);},ImageManager[_0x5b5488(0x107)]={'icon':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)][_0x5b5488(0x449)]['CommandIcon']??0x93,'capacity':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)][_0x5b5488(0x449)][_0x5b5488(0x45b)]??0x135},TextManager[_0x5b5488(0x107)]={'command':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)]['Vocab']['CommandName']??_0x5b5488(0x261),'capacity':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)]['Vocab'][_0x5b5488(0x447)]??_0x5b5488(0x28c),'capacityFmt':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)][_0x5b5488(0x449)][_0x5b5488(0x329)]??_0x5b5488(0x2c1),'costFmt':VisuMZ[_0x5b5488(0x405)]['Settings'][_0x5b5488(0x449)]['CostFmt']??'%1%2','unlearned':VisuMZ['EquipMedalSys'][_0x5b5488(0x11f)][_0x5b5488(0x449)]['Unlearned']??_0x5b5488(0x25a),'learnShowTextPopup':VisuMZ['EquipMedalSys'][_0x5b5488(0x11f)][_0x5b5488(0x3bd)][_0x5b5488(0x232)]??!![],'textPopupFmt':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)]['General'][_0x5b5488(0x23d)]??_0x5b5488(0x122),'helpFmt':VisuMZ[_0x5b5488(0x405)]['Settings'][_0x5b5488(0x449)][_0x5b5488(0x221)]??'\x5cC[16]Acquire\x20Conditions:\x5cC[0]\x20%1','helpWordWrap':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)][_0x5b5488(0x449)][_0x5b5488(0x412)]??!![],'helpSpacing':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)][_0x5b5488(0x449)][_0x5b5488(0x41e)]??!![],'helpSpacer':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)]['Vocab'][_0x5b5488(0x440)]??',','helpNothing':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)][_0x5b5488(0x449)]['helpNothing']??'-','helpDescFmt':{'progressFmt':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)][_0x5b5488(0x449)][_0x5b5488(0x3a8)]??'(Progress\x20%1)','progressFraction':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)]['Vocab'][_0x5b5488(0x118)]??'%1/%2','progressPercent':VisuMZ[_0x5b5488(0x405)]['Settings'][_0x5b5488(0x449)][_0x5b5488(0x18d)]??'%1%','progressLengthLimit':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)][_0x5b5488(0x449)][_0x5b5488(0x38d)]??0x7,'progressComplete':VisuMZ['EquipMedalSys'][_0x5b5488(0x11f)][_0x5b5488(0x449)][_0x5b5488(0x112)]??_0x5b5488(0x128),'level':VisuMZ[_0x5b5488(0x405)]['Settings'][_0x5b5488(0x449)][_0x5b5488(0x1bc)]??'Reach\x20Level\x20%1\x20%2','battle':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)]['Vocab'][_0x5b5488(0x2fb)]??_0x5b5488(0x3a1),'victory':VisuMZ[_0x5b5488(0x405)]['Settings'][_0x5b5488(0x449)][_0x5b5488(0x35d)]??_0x5b5488(0x2da),'escapes':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)][_0x5b5488(0x449)][_0x5b5488(0x3d5)]??_0x5b5488(0x429),'defeat':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)][_0x5b5488(0x449)][_0x5b5488(0x303)]??_0x5b5488(0x311),'attackTimes':VisuMZ['EquipMedalSys'][_0x5b5488(0x11f)]['Vocab'][_0x5b5488(0x446)]??'Attack\x20%1\x20Times\x20%2','guardTimes':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)][_0x5b5488(0x449)][_0x5b5488(0x1fe)]??_0x5b5488(0x1bf),'skillUse':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)][_0x5b5488(0x449)]['skillUse']??'Use\x20%1\x20Skills\x20%2','physSkillUse':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)]['Vocab'][_0x5b5488(0x37e)]??_0x5b5488(0x335),'magSkillUse':VisuMZ['EquipMedalSys'][_0x5b5488(0x11f)][_0x5b5488(0x449)]['magSkillUse']??_0x5b5488(0x3a2),'certSkillUse':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)][_0x5b5488(0x449)]['certSkillUse']??_0x5b5488(0x393),'itemUse':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)][_0x5b5488(0x449)][_0x5b5488(0x314)]??_0x5b5488(0x2d2),'critDeal':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)][_0x5b5488(0x449)]['critDeal']??_0x5b5488(0x415),'critTake':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)][_0x5b5488(0x449)][_0x5b5488(0x361)]??_0x5b5488(0x16a),'miss':VisuMZ['EquipMedalSys'][_0x5b5488(0x11f)][_0x5b5488(0x449)][_0x5b5488(0x2dd)]??_0x5b5488(0x2fe),'evade':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)][_0x5b5488(0x449)][_0x5b5488(0x3c2)]??_0x5b5488(0x3f6),'stypeUse':VisuMZ[_0x5b5488(0x405)]['Settings'][_0x5b5488(0x449)]['stypeUse']??_0x5b5488(0x2ab),'elementDeal':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)][_0x5b5488(0x449)][_0x5b5488(0x39c)]??_0x5b5488(0x1fc),'elementTake':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)][_0x5b5488(0x449)][_0x5b5488(0x26b)]??_0x5b5488(0x36b),'stateDeal':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)][_0x5b5488(0x449)]['stateDeal']??_0x5b5488(0x189),'stateTake':VisuMZ['EquipMedalSys'][_0x5b5488(0x11f)][_0x5b5488(0x449)][_0x5b5488(0x23a)]??'Receive\x20%3\x20%1\x20Times\x20%2','traitSlayer':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)][_0x5b5488(0x449)]['traitSlayer']??'Defeat\x20%1\x20%3\x20Enemies\x20%2','totalDmgDeal':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)]['Vocab'][_0x5b5488(0x37c)]??'Inflict\x20%1\x20Total\x20Battle\x20Damage\x20%2','totalDmgTake':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)][_0x5b5488(0x449)][_0x5b5488(0x174)]??_0x5b5488(0x123),'totalHealDeal':VisuMZ['EquipMedalSys'][_0x5b5488(0x11f)][_0x5b5488(0x449)][_0x5b5488(0x45a)]??_0x5b5488(0x3f7),'totalHealTake':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)][_0x5b5488(0x449)][_0x5b5488(0x3b8)]??_0x5b5488(0x11d),'kills':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)][_0x5b5488(0x449)]['kills']??_0x5b5488(0x18f),'deaths':VisuMZ['EquipMedalSys'][_0x5b5488(0x11f)][_0x5b5488(0x449)][_0x5b5488(0x300)]??_0x5b5488(0x223),'assists':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)][_0x5b5488(0x449)][_0x5b5488(0x23b)]??_0x5b5488(0x2b7),'haveGold':VisuMZ[_0x5b5488(0x405)]['Settings'][_0x5b5488(0x449)][_0x5b5488(0x196)]??_0x5b5488(0x29f),'haveItem':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)][_0x5b5488(0x449)][_0x5b5488(0x195)]??_0x5b5488(0x242),'haveWeapon':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)]['Vocab'][_0x5b5488(0x2c9)]??_0x5b5488(0x242),'haveArmor':VisuMZ['EquipMedalSys'][_0x5b5488(0x11f)][_0x5b5488(0x449)]['haveArmor']??_0x5b5488(0x242),'haveParam':VisuMZ['EquipMedalSys']['Settings']['Vocab'][_0x5b5488(0x3a4)]??_0x5b5488(0x413),'haveXParam':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)][_0x5b5488(0x449)][_0x5b5488(0x376)]??'Reach\x20%1%\x20%3\x20%2','haveSParam':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)][_0x5b5488(0x449)][_0x5b5488(0x44b)]??_0x5b5488(0x332)},'helpMeetConditionColor':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)]['Vocab'][_0x5b5488(0x39d)]??0x18,'equipMedalExpName':VisuMZ['EquipMedalSys']['Settings'][_0x5b5488(0x449)][_0x5b5488(0x302)]??_0x5b5488(0x1b4),'equipMedalExpIcon':VisuMZ[_0x5b5488(0x405)]['Settings'][_0x5b5488(0x449)][_0x5b5488(0x358)]??0x93,'equipMedalDisplayFmt':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)][_0x5b5488(0x449)][_0x5b5488(0x31a)]??_0x5b5488(0x2b4),'rewardMessageFmt':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)][_0x5b5488(0x449)]['rewardMessageFmt']??'%1\x20%2\x20acquired!','expTextFormat':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)][_0x5b5488(0x449)][_0x5b5488(0x2d9)]??_0x5b5488(0x22c),'maxExpTextFormat':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)]['Vocab'][_0x5b5488(0x21a)]??_0x5b5488(0x19d),'expPercentDigits':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)][_0x5b5488(0x449)][_0x5b5488(0x3f2)]??0x2},TextManager[_0x5b5488(0x267)]=TextManager[_0x5b5488(0x107)][_0x5b5488(0x302)],ColorManager[_0x5b5488(0x1bb)]=function(){const _0x3ee864=_0x5b5488;return this[_0x3ee864(0x21b)](Window_EquipMedalList[_0x3ee864(0x417)][_0x3ee864(0x2a0)]);},VisuMZ[_0x5b5488(0x405)]['BattleManager_makeRewards']=BattleManager[_0x5b5488(0x36c)],BattleManager[_0x5b5488(0x36c)]=function(){const _0x29f50b=_0x5b5488;VisuMZ[_0x29f50b(0x405)][_0x29f50b(0x333)]['call'](this),this['makeRewardsEquipMedalExp'](),this[_0x29f50b(0x219)]();},VisuMZ[_0x5b5488(0x405)]['BattleManager_displayRewards']=BattleManager['displayRewards'],BattleManager[_0x5b5488(0x152)]=function(){const _0x33bd47=_0x5b5488;VisuMZ[_0x33bd47(0x405)][_0x33bd47(0x1c3)][_0x33bd47(0x116)](this),this[_0x33bd47(0x253)]();},BattleManager[_0x5b5488(0x387)]=function(){const _0x3c41ae=_0x5b5488;this[_0x3c41ae(0x225)]['equipMedalExp']=$gameTroop['equipMedalExpTotal']();},BattleManager['displayRewardsEquipMedalExp']=function(){const _0x2641b3=_0x5b5488;if(!this[_0x2641b3(0x19b)]())return;this[_0x2641b3(0x225)][_0x2641b3(0x267)]=this['_rewards'][_0x2641b3(0x267)]||0x0;const _0x4cb882=TextManager['EQUIP_MEDAL_SYS'],_0x318331=_0x4cb882['rewardMessageFmt'],_0x3ab876='\x5cI[%1]'[_0x2641b3(0x24a)](_0x4cb882[_0x2641b3(0x358)]),_0x32b18a=_0x4cb882[_0x2641b3(0x302)],_0x43420f=_0x4cb882['equipMedalDisplayFmt'],_0x48fb52=_0x43420f['format'](_0x32b18a,_0x3ab876),_0x3a818a=_0x318331[_0x2641b3(0x24a)](this['_rewards'][_0x2641b3(0x267)],_0x48fb52);$gameMessage[_0x2641b3(0x31b)]('\x5c.'+_0x3a818a);},BattleManager['gainRewardsEquipMedalExp']=function(){const _0xe9b0e9=_0x5b5488;this[_0xe9b0e9(0x225)][_0xe9b0e9(0x267)]=this[_0xe9b0e9(0x225)]['equipMedalExp']||0x0;const _0x3f5a8b=Game_Troop['EQUIP_MEDAL_SYS'];let _0x5b23d0=$gameParty[_0xe9b0e9(0x1a9)]();if(_0x3f5a8b[_0xe9b0e9(0x32f)]){if(_0xe9b0e9(0x40b)===_0xe9b0e9(0x364)){_0x23527f['EquipMedalSys']['Game_Actor_refresh']['call'](this);if(this['_bypassUnequipHiddenMedal'])return;this[_0xe9b0e9(0x3d4)]();}else _0x5b23d0=_0x5b23d0[_0xe9b0e9(0x1d2)](_0x5ebb44=>_0x5ebb44[_0xe9b0e9(0x193)]());}for(const _0x14de83 of _0x5b23d0){if(_0xe9b0e9(0x3cb)===_0xe9b0e9(0x3cb)){if(!_0x14de83)continue;if(!$dataSystem[_0xe9b0e9(0x2f9)]&&!_0x14de83[_0xe9b0e9(0x164)]())continue;_0x14de83[_0xe9b0e9(0x227)](this['_rewards'][_0xe9b0e9(0x267)]);}else{const _0x482e17=_0x5e77d3[_0xe9b0e9(0x156)](_0x4d6f7d['LearnHaveParam']);if(_0x482e17)for(const _0x58cbfe of _0x482e17){_0x58cbfe[_0xe9b0e9(0x156)](_0x341e98['LearnHaveParam']);let _0x15dce8=_0x39c31a(_0x15884b['$1'])[_0xe9b0e9(0x33c)]()[_0xe9b0e9(0x374)]();const _0x50da6f=_0x4a6ea9(_0x1ed082['$2']);if(_0x15dce8==='MHP')_0x15dce8='MAXHP';if(_0x15dce8==='MAX\x20HP')_0x15dce8='MAXHP';if(_0x15dce8===_0xe9b0e9(0x2f2))_0x15dce8=_0xe9b0e9(0x369);if(_0x15dce8===_0xe9b0e9(0x298))_0x15dce8=_0xe9b0e9(0x369);const _0x44e1e6=[_0xe9b0e9(0x402),_0xe9b0e9(0x369),'ATK','DEF',_0xe9b0e9(0x301),_0xe9b0e9(0x33a),_0xe9b0e9(0x388),_0xe9b0e9(0x2b3)],_0x143bea=_0x44e1e6[_0xe9b0e9(0x26a)](_0x15dce8),_0x57c62e=_0x39b35a[_0xe9b0e9(0x396)](_0x143bea),_0x1efa3a='haveParam',_0x19591e=_0x1715db[_0xe9b0e9(0x2ca)](_0x15dce8);_0x65c4c8=this[_0xe9b0e9(0x403)](_0x35ac03,_0x50da6f,_0x57c62e,_0x1efa3a,_0x19591e);}}}},BattleManager[_0x5b5488(0x19b)]=function(){const _0x552877=_0x5b5488;return Game_Troop[_0x552877(0x107)][_0x552877(0x2f0)];},VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x2ad)]=Game_System['prototype'][_0x5b5488(0x25c)],Game_System['prototype'][_0x5b5488(0x25c)]=function(){const _0x4b51e6=_0x5b5488;VisuMZ[_0x4b51e6(0x405)][_0x4b51e6(0x2ad)][_0x4b51e6(0x116)](this),this['initEquipMedalSystem']();},Game_System[_0x5b5488(0x286)][_0x5b5488(0xfa)]=function(){const _0x153fec=_0x5b5488;this[_0x153fec(0x250)]=Window_EquipCommand[_0x153fec(0x107)][_0x153fec(0x247)];},Game_System[_0x5b5488(0x286)][_0x5b5488(0x1df)]=function(){const _0x221964=_0x5b5488;return this[_0x221964(0x250)]===undefined&&this[_0x221964(0xfa)](),this['_equipMedalSys_SceneSkill'];},Game_System[_0x5b5488(0x286)][_0x5b5488(0x2c5)]=function(_0x5bbd12){const _0x2d4696=_0x5b5488;this[_0x2d4696(0x250)]===undefined&&('cRRrT'==='cRRrT'?this[_0x2d4696(0xfa)]():(_0x28f7eb[_0x2d4696(0x3b5)]=_0x46cacf,_0x1d3cec['exp']=_0x43ca21)),this['_equipMedalSys_SceneSkill']=_0x5bbd12;},Game_Actor[_0x5b5488(0x107)]={'defaultCost':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)]['General'][_0x5b5488(0x211)]??0x1,'minCapacity':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)][_0x5b5488(0x3bd)][_0x5b5488(0x230)]??0x1,'maxCapacity':VisuMZ['EquipMedalSys']['Settings'][_0x5b5488(0x3bd)][_0x5b5488(0x450)]??0xa,'capacityFormula':VisuMZ['EquipMedalSys'][_0x5b5488(0x11f)][_0x5b5488(0x3bd)][_0x5b5488(0x1db)]??_0x5b5488(0x290),'checkOverCapacityExp':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)][_0x5b5488(0x3bd)][_0x5b5488(0x398)]??!![],'learnAutoEquip':VisuMZ['EquipMedalSys'][_0x5b5488(0x11f)][_0x5b5488(0x3bd)]['LearnAutoEquip']??![]},VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x370)]=Game_Actor[_0x5b5488(0x286)][_0x5b5488(0x3aa)],Game_Actor[_0x5b5488(0x286)][_0x5b5488(0x3aa)]=function(_0x49c5d2){const _0x2b4c8c=_0x5b5488;VisuMZ[_0x2b4c8c(0x405)]['Game_Actor_setup']['call'](this,_0x49c5d2),this[_0x2b4c8c(0xfa)]();},Game_Actor[_0x5b5488(0x286)][_0x5b5488(0xfa)]=function(){const _0x4e3424=_0x5b5488;this[_0x4e3424(0x436)]=[],this[_0x4e3424(0x171)]=[],this[_0x4e3424(0x299)]=[];if(VisuMZ[_0x4e3424(0x405)][_0x4e3424(0x31d)])for(let _0x5ca015=0x2;_0x5ca015<=0x56;_0x5ca015++){if(_0x4e3424(0x438)!==_0x4e3424(0x438))_0x46697f[_0x4e3424(0x1f9)]=this,_0x2ec2e9=_0x680b97(_0x346b93),_0x10f14b[_0x4e3424(0x1f9)]=_0x22961a;else{const _0x93dd16=$dataArmors[_0x5ca015];if(_0x93dd16[_0x4e3424(0x24b)]==='')continue;if(_0x93dd16[_0x4e3424(0x24b)]['includes'](_0x4e3424(0x1b7)))continue;this[_0x4e3424(0x436)][_0x4e3424(0x2df)](_0x5ca015);}}this[_0x4e3424(0x291)](),this[_0x4e3424(0x2b5)](),this[_0x4e3424(0x436)]['sort']((_0x5124cc,_0x3bbf88)=>_0x5124cc-_0x3bbf88);},Game_Actor[_0x5b5488(0x286)][_0x5b5488(0x40f)]=function(){const _0x23d135=_0x5b5488;if(this[_0x23d135(0x299)]===undefined)this[_0x23d135(0xfa)]();return this['_equippedMedals'][_0x23d135(0x32c)](_0x6712ea=>$dataArmors[_0x6712ea])[_0x23d135(0x30f)](null)[_0x23d135(0x30f)](undefined);},Game_Actor['prototype'][_0x5b5488(0x41d)]=function(_0x54374e){const _0x34200c=_0x5b5488;if(!DataManager[_0x34200c(0x389)](_0x54374e))return![];if(this[_0x34200c(0x299)]===undefined)this[_0x34200c(0xfa)]();return this[_0x34200c(0x299)][_0x34200c(0x2c4)](_0x54374e['id']);},Game_Actor[_0x5b5488(0x286)][_0x5b5488(0x22a)]=function(_0x35f80b){const _0x4641c1=_0x5b5488;if(!DataManager[_0x4641c1(0x389)](_0x35f80b))return![];if(this['_equippedMedals']===undefined)this[_0x4641c1(0xfa)]();if(this[_0x4641c1(0x299)][_0x4641c1(0x2c4)](_0x35f80b['id']))return;let _0x3b986e=null;!this[_0x4641c1(0x201)]&&(_0x3b986e=JsonEx[_0x4641c1(0x40c)](this),_0x3b986e['_tempActor']=!![]),this[_0x4641c1(0x299)][_0x4641c1(0x2df)](_0x35f80b['id']),this['_cache']={},this[_0x4641c1(0x3f5)](),!this[_0x4641c1(0x201)]&&this[_0x4641c1(0x265)](_0x3b986e);},Game_Actor[_0x5b5488(0x286)]['removeEquipMedal']=function(_0x1a7c42){const _0xf0782b=_0x5b5488;if(!DataManager[_0xf0782b(0x389)](_0x1a7c42))return![];if(this[_0xf0782b(0x299)]===undefined)this['initEquipMedalSystem']();if(!this['_equippedMedals'][_0xf0782b(0x2c4)](_0x1a7c42['id']))return;let _0x43f988=null;!this['_tempActor']&&(_0xf0782b(0x459)!==_0xf0782b(0x459)?(_0x4521c1[_0xf0782b(0x405)]['Scene_Boot_onDatabaseLoaded'][_0xf0782b(0x116)](this),_0x2b061e['EquipMedalSys'][_0xf0782b(0x3d0)]()):(_0x43f988=JsonEx[_0xf0782b(0x40c)](this),_0x43f988[_0xf0782b(0x201)]=!![]));this[_0xf0782b(0x299)][_0xf0782b(0x30f)](_0x1a7c42['id']),this[_0xf0782b(0x140)]={},this[_0xf0782b(0x3f5)]();if(!this[_0xf0782b(0x201)]){if(_0xf0782b(0x3c6)!==_0xf0782b(0x3c6)){const _0x5970d6=_0x1765c5(_0x24183d['$1']),_0x20c437=_0x346529[_0xf0782b(0x103)](),_0x1e31e3='haveGold',_0x4c5dfe=_0x4db8c3['currencyUnit'];_0x3b2903=this['ApplyUnlockHelpTextCondition'](_0x271080,_0x5970d6,_0x20c437,_0x1e31e3,_0x4c5dfe);}else this['equipAdjustHpMp'](_0x43f988);}},Game_Actor[_0x5b5488(0x286)][_0x5b5488(0x10e)]=function(_0x4f02ee,_0x595ff2){const _0x1a190d=_0x5b5488;if(!DataManager[_0x1a190d(0x389)](_0x4f02ee))return;if(this[_0x1a190d(0x436)]===undefined)this[_0x1a190d(0xfa)]();if(this['_learnedEquippableMedals']['includes'](_0x4f02ee['id']))return;this[_0x1a190d(0x436)][_0x1a190d(0x2df)](_0x4f02ee['id']),this[_0x1a190d(0x436)][_0x1a190d(0x3d1)]((_0x570339,_0x4e3f91)=>_0x570339-_0x4e3f91);if(Game_Actor[_0x1a190d(0x107)][_0x1a190d(0x138)]&&$gameSystem[_0x1a190d(0x1df)]()){if(_0x1a190d(0x423)!==_0x1a190d(0x423))_0x1bd513[_0x1a190d(0x286)][_0x1a190d(0x37a)]['call'](this);else{if(this['hasEquipMedalCapacityFor'](_0x4f02ee)){if(_0x1a190d(0x260)!==_0x1a190d(0x168))this[_0x1a190d(0x22a)](_0x4f02ee);else{const _0x3b32d1=_0x55d284(_0x15008e['$1']);if(_0x3b32d1>_0x51a094['getEquipMedalLearnProgress'](_0x37b01e,_0x1a190d(0x2fb),'victory'))return![];_0x22c853=!![];}}}}if(!_0x595ff2&&TextManager['EQUIP_MEDAL_SYS'][_0x1a190d(0x161)]&&this===$gameActors['actor'](this['actorId']())){const _0x1be9fa=TextManager[_0x1a190d(0x107)][_0x1a190d(0x448)],_0xb28634=DataManager[_0x1a190d(0x256)](_0x4f02ee),_0x233532=_0x1a190d(0xfe)['format'](DataManager['getEquipMedalIcon'](_0x4f02ee)),_0x5dc7d4=_0x1be9fa[_0x1a190d(0x24a)](this[_0x1a190d(0x24b)](),_0xb28634,_0x233532);$textPopup(_0x5dc7d4);}this[_0x1a190d(0x1ee)](_0x4f02ee,_0x595ff2),this[_0x1a190d(0x379)](_0x4f02ee),this[_0x1a190d(0x3f5)]();},Game_Actor[_0x5b5488(0x286)]['forgetEquippedMedal']=function(_0x58ff33){const _0x52e4c8=_0x5b5488;if(!DataManager[_0x52e4c8(0x389)](_0x58ff33))return;if(this[_0x52e4c8(0x436)]===undefined)this['initEquipMedalSystem']();if(!this['_learnedEquippableMedals'][_0x52e4c8(0x2c4)](_0x58ff33['id']))return;this['_learnedEquippableMedals'][_0x52e4c8(0x30f)](_0x58ff33['id']),this[_0x52e4c8(0x299)][_0x52e4c8(0x30f)](_0x58ff33['id']),this[_0x52e4c8(0x436)][_0x52e4c8(0x3d1)]((_0x54a7ca,_0x4c5ab3)=>_0x54a7ca-_0x4c5ab3),this['refresh']();},Game_Actor['prototype'][_0x5b5488(0x15a)]=function(_0x490696){const _0xff63b7=_0x5b5488;if(!DataManager[_0xff63b7(0x389)](_0x490696))return![];if(this[_0xff63b7(0x436)]===undefined)this[_0xff63b7(0xfa)]();return this[_0xff63b7(0x436)]['includes'](_0x490696['id'])||$gameParty[_0xff63b7(0x15a)](_0x490696);},Game_Actor[_0x5b5488(0x286)]['addUnlearnedEquippableMedal']=function(_0x1bf079){const _0x2d09c8=_0x5b5488;if(!DataManager[_0x2d09c8(0x389)](_0x1bf079))return![];if(this[_0x2d09c8(0x171)]===undefined)this[_0x2d09c8(0xfa)]();if(this[_0x2d09c8(0x171)][_0x2d09c8(0x2c4)](_0x1bf079['id']))return;this[_0x2d09c8(0x171)][_0x2d09c8(0x2df)](_0x1bf079['id']),this[_0x2d09c8(0x171)][_0x2d09c8(0x3d1)]((_0x30ab27,_0x280715)=>_0x30ab27-_0x280715);},Game_Actor[_0x5b5488(0x286)][_0x5b5488(0x172)]=function(_0x5ac8e0){const _0x36b485=_0x5b5488;if(!DataManager[_0x36b485(0x389)](_0x5ac8e0))return![];if(this[_0x36b485(0x171)]===undefined)this['initEquipMedalSystem']();if(!this['_learnableEquippableMedals'][_0x36b485(0x2c4)](_0x5ac8e0['id']))return;this[_0x36b485(0x171)][_0x36b485(0x30f)](_0x5ac8e0['id']),this[_0x36b485(0x171)][_0x36b485(0x3d1)]((_0xa1dafc,_0x33586f)=>_0xa1dafc-_0x33586f);},Game_Actor[_0x5b5488(0x286)][_0x5b5488(0x291)]=function(){const _0x2ea76f=_0x5b5488,_0x304566=VisuMZ[_0x2ea76f(0x405)][_0x2ea76f(0x1c0)],_0x34e627=this[_0x2ea76f(0x33f)]()[_0x2ea76f(0x3f3)]||'';if(_0x34e627['match'](_0x304566[_0x2ea76f(0x1fd)])){const _0x32ea95=String(RegExp['$1'])[_0x2ea76f(0x281)](',')['map'](_0x59ca68=>_0x59ca68[_0x2ea76f(0x374)]());for(const _0x5229cd of _0x32ea95){const _0x376a5e=/^\d+$/['test'](_0x5229cd);let _0x5cfb21=0x0;_0x376a5e?_0x2ea76f(0x1d9)==='kfEfs'?this[_0x2ea76f(0x3f5)]():_0x5cfb21=Number(_0x5229cd):_0x5cfb21=DataManager[_0x2ea76f(0x182)](_0x5229cd);if(_0x5cfb21>0x0){if(!this[_0x2ea76f(0x436)]['includes'](_0x5cfb21)){if(_0x2ea76f(0x1e8)===_0x2ea76f(0x1e8))this[_0x2ea76f(0x436)][_0x2ea76f(0x2df)](_0x5cfb21);else return _0x44f60c&&_0x1b9594[_0x2ea76f(0x3f3)]['match'](_0x26f25f)?_0x33cd41*(_0x5c8413(_0x6dda1d['$1'])*0.01):_0x1c1825;}}}}},Game_Actor[_0x5b5488(0x286)][_0x5b5488(0x2b5)]=function(){const _0x2a6399=_0x5b5488,_0x2daa13=VisuMZ[_0x2a6399(0x405)]['RegExp'],_0x363fdb=this['actor']()[_0x2a6399(0x3f3)]||'';if(_0x363fdb['match'](_0x2daa13['AlreadyEquipMedals'])){const _0x363c82=String(RegExp['$1'])[_0x2a6399(0x281)](',')[_0x2a6399(0x32c)](_0x59bc94=>_0x59bc94[_0x2a6399(0x374)]());for(const _0x183f46 of _0x363c82){const _0x1d32d5=/^\d+$/[_0x2a6399(0x239)](_0x183f46);let _0x53dda9=0x0;_0x1d32d5?_0x53dda9=Number(_0x183f46):_0x2a6399(0x237)!==_0x2a6399(0x3c9)?_0x53dda9=DataManager[_0x2a6399(0x182)](_0x183f46):this[_0x2a6399(0xfa)]();if(_0x53dda9>0x0){!this[_0x2a6399(0x436)][_0x2a6399(0x2c4)](_0x53dda9)&&this[_0x2a6399(0x436)][_0x2a6399(0x2df)](_0x53dda9);const _0x574213=$dataArmors[_0x53dda9];if(this[_0x2a6399(0x1cb)](_0x574213)){if(_0x2a6399(0x2e4)!==_0x2a6399(0x3cf))this[_0x2a6399(0x22a)](_0x574213);else{let _0x1d6c7e=_0x3d9785;while(_0x1d6c7e--)_0x32cc27+=_0x2a3236;}}}}}},Game_Actor[_0x5b5488(0x286)][_0x5b5488(0x43d)]=function(){const _0x18cc9c=_0x5b5488;if(this[_0x18cc9c(0x436)]===undefined)this[_0x18cc9c(0xfa)]();let _0x335691=[];return _0x335691=_0x335691[_0x18cc9c(0x294)](this[_0x18cc9c(0x436)]),_0x335691=_0x335691['concat']($gameParty['getLearnEquippedMedalRawIDs']()),_0x335691=_0x335691[_0x18cc9c(0x1d2)]((_0x4c562f,_0x111380,_0x44946a)=>_0x44946a[_0x18cc9c(0x26a)](_0x4c562f)===_0x111380),_0x335691[_0x18cc9c(0x32c)](_0xa59a1b=>$dataArmors[_0xa59a1b])[_0x18cc9c(0x30f)](null)[_0x18cc9c(0x30f)](undefined);},Game_Actor[_0x5b5488(0x286)][_0x5b5488(0x13a)]=function(){const _0x43e1a3=_0x5b5488;if(this['_learnedEquippableMedals']===undefined)this['initEquipMedalSystem']();if(this[_0x43e1a3(0x171)]===undefined)this[_0x43e1a3(0xfa)]();let _0x2014f1=this[_0x43e1a3(0x171)]['clone']();return _0x2014f1=_0x2014f1['concat'](DataManager[_0x43e1a3(0x282)](this)),_0x2014f1=_0x2014f1[_0x43e1a3(0x294)]($gameParty[_0x43e1a3(0x2e1)]()),_0x2014f1=_0x2014f1[_0x43e1a3(0x1d2)](_0x853a91=>!this['_learnedEquippableMedals'][_0x43e1a3(0x2c4)](_0x853a91)),_0x2014f1=_0x2014f1[_0x43e1a3(0x1d2)]((_0xf6496b,_0x38251e,_0xf29e72)=>_0xf29e72[_0x43e1a3(0x26a)](_0xf6496b)===_0x38251e),_0x2014f1[_0x43e1a3(0x32c)](_0x3044d7=>$dataArmors[_0x3044d7])[_0x43e1a3(0x30f)](null)[_0x43e1a3(0x30f)](undefined);},Game_Actor[_0x5b5488(0x286)]['branchLearnEquipMedals']=function(_0x36e828,_0x121b76){const _0x38065b=_0x5b5488,_0x709e71=VisuMZ[_0x38065b(0x405)][_0x38065b(0x1c0)],_0x3a94c9=_0x36e828['note']||'';if(_0x3a94c9['match'](_0x709e71['BranchLearn'])){const _0x54ecd9=String(RegExp['$1'])[_0x38065b(0x281)](',')[_0x38065b(0x32c)](_0x44fafb=>_0x44fafb[_0x38065b(0x374)]());for(const _0xa8602d of _0x54ecd9){if(_0x38065b(0x2e0)===_0x38065b(0x2e0)){const _0x2dc293=/^\d+$/[_0x38065b(0x239)](_0xa8602d);let _0x311c1c=0x0;if(_0x2dc293){if(_0x38065b(0x437)===_0x38065b(0x437))_0x311c1c=Number(_0xa8602d);else{if(!this[_0x38065b(0x2de)])return;const _0x4b984c=_0x266f1e['EquipMedalSys'][_0x38065b(0x1c0)],_0x2d6c68=(_0x434ecf?_0x262b13['note']:'')||'';let _0x3f8839=_0x1547dd?_0x575d3d[_0x38065b(0x24c)]:'';_0x8d5ca5&&_0x2d6c68[_0x38065b(0x156)](_0x4b984c[_0x38065b(0x212)])&&(_0x3f8839=_0x325a65(_0xef0883['$1'])),this['_helpWindow']['setText'](_0x3f8839);}}else _0x311c1c=DataManager[_0x38065b(0x182)](_0xa8602d);_0x311c1c>0x0&&this[_0x38065b(0x10e)]($dataArmors[_0x311c1c],_0x121b76);}else{const _0x23219a=_0x3fae29(_0x3690f4['$1']),_0x482e0b=_0x323d46['getEquipMedalLearnProgress'](_0x558084,_0x38065b(0x2fb),'defeat'),_0x536e3f=_0x38065b(0x303);_0x21e4df=this[_0x38065b(0x403)](_0x1385d4,_0x23219a,_0x482e0b,_0x536e3f);}}}},Game_Actor[_0x5b5488(0x286)][_0x5b5488(0x379)]=function(_0x1c0017){const _0x20f182=_0x5b5488,_0x252e27=VisuMZ['EquipMedalSys'][_0x20f182(0x1c0)],_0x3f679e=_0x1c0017[_0x20f182(0x3f3)]||'';if(_0x3f679e[_0x20f182(0x156)](_0x252e27[_0x20f182(0x454)])){if(_0x20f182(0x383)!=='rLcGs'){const _0x1bee13=String(RegExp['$1'])[_0x20f182(0x281)](',')[_0x20f182(0x32c)](_0x566fdf=>_0x566fdf['trim']());for(const _0x4233c6 of _0x1bee13){const _0x4c83f5=/^\d+$/[_0x20f182(0x239)](_0x4233c6);let _0x57e83e=0x0;if(_0x4c83f5){if(_0x20f182(0x327)!=='VEeHm')_0x57e83e=Number(_0x4233c6);else{const _0x537259=_0x162f1a[_0x20f182(0x156)](_0x8810f0[_0x20f182(0x288)]);if(_0x537259)for(const _0x7edce6 of _0x537259){_0x7edce6['match'](_0x22023d[_0x20f182(0x288)]);let _0x5c5a56=_0x2d460a(_0x58461d['$1'])[_0x20f182(0x33c)]()[_0x20f182(0x374)]();const _0xc04873=_0x5a1c5f(_0x3b6096['$2']),_0x1d4210=[_0x20f182(0x218),'GRD','REC','PHA',_0x20f182(0x2d6),_0x20f182(0x1ba),'PDR',_0x20f182(0x40d),'FDR','EXR'],_0x503991=_0x1d4210['indexOf'](_0x5c5a56),_0x3ca99a=_0x5bec7b[_0x20f182(0x16b)](_0x17281f[_0x20f182(0x2e8)](_0x503991)*0x64),_0x401240=_0x20f182(0x44b),_0x344920=_0x340b91[_0x20f182(0x2ca)](_0x5c5a56);_0x44e17b=this[_0x20f182(0x403)](_0x1cb900,_0xc04873,_0x3ca99a,_0x401240,_0x344920);}}}else{if(_0x20f182(0x2d0)==='xhEzL')_0x57e83e=DataManager['getArmorIdWithName'](_0x4233c6);else{const _0x4e323b=_0xe47643(_0x9a0f93['$1']);if(_0x4e323b>_0xcb0c16[_0x20f182(0x22d)](_0x50e255,_0x20f182(0x457),_0x20f182(0x300)))return![];_0x90c714=!![];}}_0x57e83e>0x0&&this[_0x20f182(0x173)]($dataArmors[_0x57e83e]);}}else return this[_0x20f182(0x21b)](_0xd3bf83[_0x20f182(0x417)]['equipColor']);}},VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x205)]=Game_Actor[_0x5b5488(0x286)][_0x5b5488(0x249)],Game_Actor[_0x5b5488(0x286)][_0x5b5488(0x249)]=function(_0xe55e4f){const _0x3c7d67=_0x5b5488;let _0x57a5d5=VisuMZ[_0x3c7d67(0x405)][_0x3c7d67(0x205)]['call'](this,_0xe55e4f);for(const _0x41cd30 of this[_0x3c7d67(0x40f)]()){_0x3c7d67(0x1a7)===_0x3c7d67(0x1d7)?this[_0x3c7d67(0x225)][_0x3c7d67(0x267)]=_0x299b0a[_0x3c7d67(0x323)]():_0x41cd30&&(_0x57a5d5+=_0x41cd30['params'][_0xe55e4f]);}return _0x57a5d5;},VisuMZ[_0x5b5488(0x405)]['Game_Actor_traitObjects']=Game_Actor[_0x5b5488(0x286)]['traitObjects'],Game_Actor[_0x5b5488(0x286)][_0x5b5488(0x3d9)]=function(){const _0x929509=_0x5b5488,_0x2df781=VisuMZ['EquipMedalSys'][_0x929509(0x28a)][_0x929509(0x116)](this);return _0x2df781[_0x929509(0x294)](this[_0x929509(0x40f)]());},VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x1ab)]=Game_Actor['prototype']['releaseUnequippableItems'],Game_Actor[_0x5b5488(0x286)][_0x5b5488(0x35f)]=function(_0x39fc77){const _0x297250=_0x5b5488;this[_0x297250(0x33e)]=!![],VisuMZ[_0x297250(0x405)][_0x297250(0x1ab)]['call'](this,_0x39fc77),this['_equipMedalSysReleaseUnequippables']=undefined;},Game_Actor[_0x5b5488(0x286)]['equipMedalCurrentCapacity']=function(){const _0x391e3e=_0x5b5488;return this[_0x391e3e(0x40f)]()[_0x391e3e(0x26d)]((_0x6b264d,_0x275ac9)=>_0x6b264d+DataManager['getEquipMedalCost'](_0x275ac9),0x0);},Game_Actor[_0x5b5488(0x286)][_0x5b5488(0x178)]=function(){const _0x106aa4=_0x5b5488,_0x14d54b=Game_Actor['EQUIP_MEDAL_SYS'],_0x198eb7=_0x14d54b[_0x106aa4(0x406)];let _0xd35102=_0x14d54b['minCapacity'];try{'erZlQ'!==_0x106aa4(0x1e6)?this['learnEquippedMedal'](_0x58024d[_0xa6d8e6],_0x9e883b):(window['user']=this,_0xd35102=eval(_0x198eb7),window[_0x106aa4(0x1f9)]=undefined);}catch(_0x473119){if(_0x106aa4(0x404)===_0x106aa4(0x1d3)){_0x49a1e8[_0x106aa4(0x156)](_0x157e83[_0x106aa4(0x101)]);let _0x540c39=_0x3eb475(_0x1da0b2['$1']);const _0x1502c0=_0x14b6f6(_0x1afb77['$2']),_0x4370e1=/^\d+$/[_0x106aa4(0x239)](_0x540c39);_0x540c39=_0x4370e1?_0x1edf7c(_0x540c39):_0x12c8f7[_0x106aa4(0x187)](_0x540c39);if(_0x1502c0>_0x5b3201['getEquipMedalLearnProgress'](_0x5f1292,'stateDeal',_0x540c39))return![];_0x528d20=!![];}else _0xd35102=_0x14d54b[_0x106aa4(0x229)];}return _0xd35102=_0xd35102[_0x106aa4(0x373)](_0x14d54b[_0x106aa4(0x229)],_0x14d54b[_0x106aa4(0x3b1)]),_0xd35102;},Game_Actor[_0x5b5488(0x286)]['hasEquipMedalCapacityFor']=function(_0x2fae41){const _0xb15c65=_0x5b5488;if(this[_0xb15c65(0x299)]===undefined)this[_0xb15c65(0xfa)]();if(this[_0xb15c65(0x299)]['includes'](_0x2fae41['id']))return![];const _0x3d5e63=DataManager[_0xb15c65(0x42b)](_0x2fae41),_0x408047=this[_0xb15c65(0x22b)](),_0x25caf5=this[_0xb15c65(0x178)]();return _0x408047+_0x3d5e63<=_0x25caf5;},Game_Actor['prototype'][_0x5b5488(0x3fd)]=function(){const _0x4aed38=_0x5b5488;if(!Game_Actor[_0x4aed38(0x107)][_0x4aed38(0x44d)])return;let _0x36114c=![];for(;;){if(_0x4aed38(0x1d0)==='FCQFp'){if(this[_0x4aed38(0x40f)]()[_0x4aed38(0x257)]<=0x0)break;if(this[_0x4aed38(0x22b)]()<=this[_0x4aed38(0x178)]())break;const _0x14677b=this[_0x4aed38(0x40f)]()[_0x4aed38(0x1c9)]();this[_0x4aed38(0x159)](_0x14677b),_0x36114c=!![];}else{if(!this['_actor'])return;if(!this[_0x4aed38(0x328)])return;const _0x1c7d87=this[_0x4aed38(0x3a0)]();if(!_0x1c7d87)return;const _0x3bc23e=_0x3bf63d[_0x4aed38(0x40c)](this[_0x4aed38(0x2bf)]);_0x3bc23e['_tempActor']=!![],_0x3bc23e[_0x4aed38(0x41d)](_0x1c7d87)?_0x3bc23e[_0x4aed38(0x159)](_0x1c7d87):_0x3bc23e['processEquipMedal'](_0x1c7d87),this[_0x4aed38(0x2a9)]['setTempActor'](_0x3bc23e);}}_0x36114c&&(_0x4aed38(0x277)!=='RwDGR'?this[_0x4aed38(0x3f5)]():this[_0x4aed38(0x20e)]());},VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11b)]=Game_Actor[_0x5b5488(0x286)][_0x5b5488(0x236)],Game_Actor[_0x5b5488(0x286)]['changeExp']=function(_0x2a5f8c,_0x2488c0){const _0x3bee37=_0x5b5488,_0x38175c=this[_0x3bee37(0x444)];VisuMZ['EquipMedalSys'][_0x3bee37(0x11b)]['call'](this,_0x2a5f8c,_0x2488c0);if(this[_0x3bee37(0x444)]===_0x38175c)return;this[_0x3bee37(0x3fd)](),this[_0x3bee37(0x222)]();},VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x32d)]=Game_Battler[_0x5b5488(0x286)]['onBattleEnd'],Game_Battler[_0x5b5488(0x286)][_0x5b5488(0x2a1)]=function(){const _0x39e54e=_0x5b5488;VisuMZ[_0x39e54e(0x405)]['Game_Battler_onBattleEnd'][_0x39e54e(0x116)](this);if(this['isActor']())this[_0x39e54e(0x222)]();},Game_Actor[_0x5b5488(0x286)][_0x5b5488(0x222)]=function(){const _0x3ad8a7=_0x5b5488,_0x4688d0=this[_0x3ad8a7(0x13a)]();for(const _0x3470b0 of _0x4688d0){if(!_0x3470b0)continue;if(this['isLearnedEquippedMedal'](_0x3470b0))continue;if(VisuMZ[_0x3ad8a7(0x405)][_0x3ad8a7(0x458)](this,_0x3470b0)){if('iyPZg'==='iyPZg')this['learnEquippedMedal'](_0x3470b0);else{const _0x2e9a80=_0x1bb418[_0x3ad8a7(0x337)](_0x140cd2);if(this['_actor'][_0x3ad8a7(0x15a)](_0x2e9a80))return![];}}}},VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x458)]=function(_0x23d8d7,_0x4a40b6){const _0x1616d5=_0x5b5488,_0x3d2280=VisuMZ['EquipMedalSys'][_0x1616d5(0x1c0)],_0x4265d8=_0x4a40b6['note']||'';let _0x2cff20=![];if(!_0x4265d8['match'](_0x3d2280[_0x1616d5(0x142)]))return _0x2cff20;if(_0x4265d8[_0x1616d5(0x156)](_0x3d2280[_0x1616d5(0x1e0)])){const _0x8c8fa8=Number(RegExp['$1']);if(_0x8c8fa8>_0x23d8d7[_0x1616d5(0x1bc)])return![];_0x2cff20=!![];}if(_0x4265d8[_0x1616d5(0x156)](_0x3d2280['LearnBattles'])){if('DPGOg'!==_0x1616d5(0x19c)){const _0x67cc24=_0x243c35(_0x26c1f8['$1']);if(_0x67cc24>_0x2537b0['getEquipMedalLearnProgress'](_0x2266c5,_0x1616d5(0x3dc),'evade'))return![];_0x15c6ca=!![];}else{const _0x286194=Number(RegExp['$1']);if(_0x286194>_0x23d8d7[_0x1616d5(0x22d)](_0x4a40b6,'battle',_0x1616d5(0x367)))return![];_0x2cff20=!![];}}if(_0x4265d8[_0x1616d5(0x156)](_0x3d2280['LearnVictory'])){if('hMnsI'===_0x1616d5(0x39b)){const _0xc28921=Number(RegExp['$1']);if(_0xc28921>_0x23d8d7['getEquipMedalLearnProgress'](_0x4a40b6,_0x1616d5(0x2fb),'victory'))return![];_0x2cff20=!![];}else{const _0x45b066=_0x1e4c22[_0x13d6fc];_0x1345d1[_0x1616d5(0x10e)](_0x45b066);}}if(_0x4265d8['match'](_0x3d2280[_0x1616d5(0x24d)])){const _0x34d310=Number(RegExp['$1']);if(_0x34d310>_0x23d8d7[_0x1616d5(0x22d)](_0x4a40b6,_0x1616d5(0x2fb),'escape'))return![];_0x2cff20=!![];}if(_0x4265d8[_0x1616d5(0x156)](_0x3d2280[_0x1616d5(0x453)])){const _0x538ea8=Number(RegExp['$1']);if(_0x538ea8>_0x23d8d7['getEquipMedalLearnProgress'](_0x4a40b6,_0x1616d5(0x2fb),_0x1616d5(0x303)))return![];_0x2cff20=!![];}if(_0x4265d8[_0x1616d5(0x156)](_0x3d2280[_0x1616d5(0x3e4)])){const _0x2b7e51=Number(RegExp['$1']);if(_0x2b7e51>_0x23d8d7[_0x1616d5(0x22d)](_0x4a40b6,_0x1616d5(0x3dc),_0x1616d5(0x280)))return![];_0x2cff20=!![];}if(_0x4265d8[_0x1616d5(0x156)](_0x3d2280[_0x1616d5(0x1f7)])){if(_0x1616d5(0x430)===_0x1616d5(0x177)){_0x348b3a['match'](_0x4f0c65[_0x1616d5(0x252)]);let _0x13fe3b=_0x187b93(_0x2c9287['$1']);const _0x2590ef=_0xf2470b(_0x4ca4c2['$2']),_0xb669c6=/^\d+$/[_0x1616d5(0x239)](_0x13fe3b);_0x13fe3b=_0xb669c6?_0x2a7b58(_0x13fe3b):_0x1db669['getElementIdWithName'](_0x13fe3b);const _0x31595e=_0x51b312[_0x1616d5(0x22d)](_0x3df20f,_0x1616d5(0x26b),_0x13fe3b),_0x3be13d=_0x1616d5(0x26b),_0x352e17=_0x13e506[_0x1616d5(0x416)][_0x13fe3b];_0x39f2f4=this[_0x1616d5(0x403)](_0x4a2a31,_0x2590ef,_0x31595e,_0x3be13d,_0x352e17);}else{const _0x296e54=Number(RegExp['$1']);if(_0x296e54>_0x23d8d7[_0x1616d5(0x22d)](_0x4a40b6,_0x1616d5(0x3dc),'guard'))return![];_0x2cff20=!![];}}if(_0x4265d8[_0x1616d5(0x156)](_0x3d2280[_0x1616d5(0x3c0)])){const _0x31e928=Number(RegExp['$1']);if(_0x31e928>_0x23d8d7['getEquipMedalLearnProgress'](_0x4a40b6,_0x1616d5(0x3dc),'skill'))return![];_0x2cff20=!![];}if(_0x4265d8['match'](_0x3d2280['LearnPhysSkill'])){const _0x3f58c3=Number(RegExp['$1']);if(_0x3f58c3>_0x23d8d7[_0x1616d5(0x22d)](_0x4a40b6,_0x1616d5(0x3dc),_0x1616d5(0x3eb)))return![];_0x2cff20=!![];}if(_0x4265d8['match'](_0x3d2280['LearnMagSkill'])){const _0x55c4b8=Number(RegExp['$1']);if(_0x55c4b8>_0x23d8d7['getEquipMedalLearnProgress'](_0x4a40b6,_0x1616d5(0x3dc),'magicalSkill'))return![];_0x2cff20=!![];}if(_0x4265d8[_0x1616d5(0x156)](_0x3d2280[_0x1616d5(0x15d)])){if(_0x1616d5(0x3ab)!=='paOZU')(_0x439573[_0x1616d5(0x1c8)]||_0x2b7e79[_0x1616d5(0xff)])&&this[_0x1616d5(0x400)](_0x174d50,_0x1616d5(0x3dc),_0x1b9bcb,0x1);else{const _0x1ee6e0=Number(RegExp['$1']);if(_0x1ee6e0>_0x23d8d7[_0x1616d5(0x22d)](_0x4a40b6,'actionTimes',_0x1616d5(0x2b2)))return![];_0x2cff20=!![];}}if(_0x4265d8[_0x1616d5(0x156)](_0x3d2280[_0x1616d5(0x392)])){if(_0x1616d5(0x324)!=='WBupE'){const _0x431167=_0x3510d3(_0x27d2a9['$1']),_0x7dbb51=_0x3880a9[_0x1616d5(0x22d)](_0x30b428,_0x1616d5(0x2fb),_0x1616d5(0x367)),_0x47132d=_0x1616d5(0x2fb);_0x5a06a8=this[_0x1616d5(0x403)](_0x524e04,_0x431167,_0x7dbb51,_0x47132d);}else{const _0x585792=Number(RegExp['$1']);if(_0x585792>_0x23d8d7[_0x1616d5(0x22d)](_0x4a40b6,_0x1616d5(0x3dc),_0x1616d5(0x3a0)))return![];_0x2cff20=!![];}}if(_0x4265d8[_0x1616d5(0x156)](_0x3d2280[_0x1616d5(0x21d)])){const _0x58d5e0=Number(RegExp['$1']);if(_0x58d5e0>_0x23d8d7[_0x1616d5(0x22d)](_0x4a40b6,_0x1616d5(0x3dc),'critDeal'))return![];_0x2cff20=!![];}if(_0x4265d8[_0x1616d5(0x156)](_0x3d2280[_0x1616d5(0x1fb)])){const _0x212197=Number(RegExp['$1']);if(_0x212197>_0x23d8d7[_0x1616d5(0x22d)](_0x4a40b6,_0x1616d5(0x3dc),_0x1616d5(0x361)))return![];_0x2cff20=!![];}if(_0x4265d8['match'](_0x3d2280[_0x1616d5(0x1c2)])){const _0x412444=Number(RegExp['$1']);if(_0x412444>_0x23d8d7['getEquipMedalLearnProgress'](_0x4a40b6,'actionTimes','miss'))return![];_0x2cff20=!![];}if(_0x4265d8[_0x1616d5(0x156)](_0x3d2280[_0x1616d5(0x3d2)])){const _0x8fb09f=Number(RegExp['$1']);if(_0x8fb09f>_0x23d8d7['getEquipMedalLearnProgress'](_0x4a40b6,_0x1616d5(0x3dc),'evade'))return![];_0x2cff20=!![];}{if(_0x1616d5(0x16c)==='GOMYx'){let _0x2239a4='';_0x2239a4+=_0x1616d5(0x346),_0x2239a4+='in\x20order\x20for\x20VisuMZ_2_EquipMedalSys\x20to\x20work.',_0x2719c6(_0x2239a4),_0x75ce51[_0x1616d5(0x273)]();}else{const _0xbdf369=_0x4265d8[_0x1616d5(0x156)](_0x3d2280[_0x1616d5(0x32e)]);if(_0xbdf369)for(const _0x13de67 of _0xbdf369){_0x13de67['match'](_0x3d2280['LearnSTypeUsage']);let _0x3e6488=String(RegExp['$1']);const _0x2cd98c=Number(RegExp['$2']),_0x5e832a=/^\d+$/[_0x1616d5(0x239)](_0x3e6488);_0x3e6488=_0x5e832a?Number(_0x3e6488):DataManager[_0x1616d5(0x143)](_0x3e6488);if(_0x2cd98c>_0x23d8d7['getEquipMedalLearnProgress'](_0x4a40b6,_0x1616d5(0x153),_0x3e6488))return![];_0x2cff20=!![];}}}{const _0x5a36e4=_0x4265d8[_0x1616d5(0x156)](_0x3d2280['LearnElementDeal']);if(_0x5a36e4)for(const _0x2bf4f2 of _0x5a36e4){_0x2bf4f2['match'](_0x3d2280[_0x1616d5(0x18e)]);let _0x23b2f8=String(RegExp['$1']);const _0x5eb45b=Number(RegExp['$2']),_0x5b6f7a=/^\d+$/[_0x1616d5(0x239)](_0x23b2f8);_0x23b2f8=_0x5b6f7a?Number(_0x23b2f8):DataManager['getElementIdWithName'](_0x23b2f8);if(_0x5eb45b>_0x23d8d7[_0x1616d5(0x22d)](_0x4a40b6,'elementDeal',_0x23b2f8))return![];_0x2cff20=!![];}}{const _0x3fe0b9=_0x4265d8['match'](_0x3d2280[_0x1616d5(0x252)]);if(_0x3fe0b9){if(_0x1616d5(0x18c)!=='RoQwd'){if(!this[_0x1616d5(0x389)](_0x34561c))return 0x0;this[_0x1616d5(0x2f8)]=this[_0x1616d5(0x2f8)]||{};if(this['_getEquipMedalIcon'][_0x5a648e['id']]!==_0xe8a61c)return this['_getEquipMedalIcon'][_0x2327a9['id']];let _0x115ad0=_0x3a247[_0x1616d5(0x308)]||_0xd12d20[_0x1616d5(0x107)][_0x1616d5(0x3a9)];const _0x3ff37c=_0x507d83[_0x1616d5(0x405)][_0x1616d5(0x1c0)],_0x39d5eb=_0x4a34f5['note']||'';return _0x39d5eb['match'](_0x3ff37c[_0x1616d5(0x39a)])&&(_0x115ad0=_0x4989f8(_0x3f79df['$1'])),this[_0x1616d5(0x2f8)][_0x490236['id']]=_0x115ad0,this[_0x1616d5(0x2f8)][_0x5d8843['id']];}else for(const _0x14ed09 of _0x3fe0b9){_0x14ed09[_0x1616d5(0x156)](_0x3d2280['LearnElementTake']);let _0x401f91=String(RegExp['$1']);const _0x37bafd=Number(RegExp['$2']),_0x4e24fa=/^\d+$/[_0x1616d5(0x239)](_0x401f91);_0x401f91=_0x4e24fa?Number(_0x401f91):DataManager[_0x1616d5(0x1e1)](_0x401f91);if(_0x37bafd>_0x23d8d7['getEquipMedalLearnProgress'](_0x4a40b6,_0x1616d5(0x26b),_0x401f91))return![];_0x2cff20=!![];}}}{const _0x50fcff=_0x4265d8[_0x1616d5(0x156)](_0x3d2280[_0x1616d5(0x101)]);if(_0x50fcff){if(_0x1616d5(0x3c7)===_0x1616d5(0x434)){const _0x395d3c=_0x35b875(_0x15be82['$1']),_0x4dd4bc=_0xcbbf66[_0x1616d5(0x22d)](_0x3ed82a,_0x1616d5(0x457),_0x1616d5(0x325)),_0x127e5c=_0x1616d5(0x325);_0xe02170=this['ApplyUnlockHelpTextCondition'](_0x355bfd,_0x395d3c,_0x4dd4bc,_0x127e5c);}else for(const _0x53171a of _0x50fcff){_0x53171a[_0x1616d5(0x156)](_0x3d2280[_0x1616d5(0x101)]);let _0x168d3b=String(RegExp['$1']);const _0x4b43d0=Number(RegExp['$2']),_0x10b514=/^\d+$/[_0x1616d5(0x239)](_0x168d3b);_0x168d3b=_0x10b514?Number(_0x168d3b):DataManager[_0x1616d5(0x187)](_0x168d3b);if(_0x4b43d0>_0x23d8d7['getEquipMedalLearnProgress'](_0x4a40b6,_0x1616d5(0x15f),_0x168d3b))return![];_0x2cff20=!![];}}}{if(_0x1616d5(0x2aa)===_0x1616d5(0x2aa)){const _0x532b1d=_0x4265d8[_0x1616d5(0x156)](_0x3d2280[_0x1616d5(0x304)]);if(_0x532b1d)for(const _0x414753 of _0x532b1d){_0x414753[_0x1616d5(0x156)](_0x3d2280[_0x1616d5(0x304)]);let _0x5f35e4=String(RegExp['$1']);const _0xe6f2c0=Number(RegExp['$2']),_0x58749f=/^\d+$/[_0x1616d5(0x239)](_0x5f35e4);_0x5f35e4=_0x58749f?Number(_0x5f35e4):DataManager[_0x1616d5(0x187)](_0x5f35e4);if(_0xe6f2c0>_0x23d8d7[_0x1616d5(0x22d)](_0x4a40b6,_0x1616d5(0x23a),_0x5f35e4))return![];_0x2cff20=!![];}}else _0x39e9de=_0x2465c9['minCapacity'];}if(Imported['VisuMZ_1_ElementStatusCore']){const _0x2b2272=_0x4265d8[_0x1616d5(0x156)](_0x3d2280[_0x1616d5(0x1d6)]);if(_0x2b2272){if(_0x1616d5(0x2c8)==='tHMbm'){const _0x33513d=(_0x145474['VisualGaugeStyles']['GetGaugeHeight'](_0x28a0f8)??0xc)[_0x1616d5(0x373)](0x1,0x20),_0x25013d=_0x3e1814+this['lineHeight']()-_0x33513d-0x2,_0x4418d7=_0x51d2ff[_0x1616d5(0x10a)]();_0x326e19['VisualGaugeStyles'][_0x1616d5(0x2f3)]=_0x3fb10b,this[_0x1616d5(0x32b)][_0x1616d5(0x23c)](_0x8fe538,_0x5912c9,_0x25013d,_0x3e6e0b,_0x33513d,_0x24b3ed,_0x4418d7,_0x2440de,_0xbbbf36);}else for(const _0x3b5635 of _0x2b2272){_0x3b5635[_0x1616d5(0x156)](_0x3d2280['LearnDefeatTrait']);const _0xbdc104=String(RegExp['$1'])[_0x1616d5(0x33c)]()['trim'](),_0x3481b2=Number(RegExp['$2']);if(_0x3481b2>_0x23d8d7[_0x1616d5(0x22d)](_0x4a40b6,_0x1616d5(0x321),_0xbdc104))return![];_0x2cff20=!![];}}}if(_0x4265d8['match'](_0x3d2280['LearnTotalDmgDeal'])){if(_0x1616d5(0x16d)===_0x1616d5(0x16d)){const _0x4eeb16=Number(RegExp['$1']);if(_0x4eeb16>_0x23d8d7['getEquipMedalLearnProgress'](_0x4a40b6,'hp',_0x1616d5(0x44c)))return![];_0x2cff20=!![];}else{const _0xe86a48=_0x3a9f05(_0x3f4618['$1']),_0x5e80ba=_0x32d30a[_0x1616d5(0x22d)](_0x4c9b6f,'hp',_0x1616d5(0x213)),_0x630377=_0x1616d5(0x174);_0x20b56=this[_0x1616d5(0x403)](_0x1e8e0b,_0xe86a48,_0x5e80ba,_0x630377);}}if(_0x4265d8['match'](_0x3d2280['LearnTotalDmgTake'])){const _0x169814=Number(RegExp['$1']);if(_0x169814>_0x23d8d7[_0x1616d5(0x22d)](_0x4a40b6,'hp',_0x1616d5(0x213)))return![];_0x2cff20=!![];}if(_0x4265d8[_0x1616d5(0x156)](_0x3d2280[_0x1616d5(0x1a3)])){const _0x380c71=Number(RegExp['$1']);if(_0x380c71>_0x23d8d7[_0x1616d5(0x22d)](_0x4a40b6,'hp','healDeal'))return![];_0x2cff20=!![];}if(_0x4265d8[_0x1616d5(0x156)](_0x3d2280[_0x1616d5(0x10f)])){const _0x394b9e=Number(RegExp['$1']);if(_0x394b9e>_0x23d8d7['getEquipMedalLearnProgress'](_0x4a40b6,'hp',_0x1616d5(0x377)))return![];_0x2cff20=!![];}if(_0x4265d8['match'](_0x3d2280[_0x1616d5(0x2e7)])){if(_0x1616d5(0x258)==='BGSid'){const _0x2598ef=Number(RegExp['$1']);if(_0x2598ef>_0x23d8d7[_0x1616d5(0x22d)](_0x4a40b6,'kda','kills'))return![];_0x2cff20=!![];}else this[_0x1616d5(0x360)](),_0xa363d9[_0x1616d5(0x286)][_0x1616d5(0x3f5)][_0x1616d5(0x116)](this);}if(_0x4265d8['match'](_0x3d2280['LearnCountDeaths'])){if(_0x1616d5(0x1cc)===_0x1616d5(0x1cc)){const _0x2d802a=Number(RegExp['$1']);if(_0x2d802a>_0x23d8d7[_0x1616d5(0x22d)](_0x4a40b6,_0x1616d5(0x457),_0x1616d5(0x300)))return![];_0x2cff20=!![];}else _0xa72d36[_0x1616d5(0x405)]['Window_EquipCommand_makeCommandList']['call'](this),this[_0x1616d5(0x266)]();}if(_0x4265d8[_0x1616d5(0x156)](_0x3d2280[_0x1616d5(0x167)])){if('BIYRl'===_0x1616d5(0x28f)){const _0x28dc89=Number(RegExp['$1']);if(_0x28dc89>_0x23d8d7[_0x1616d5(0x22d)](_0x4a40b6,_0x1616d5(0x457),'assists'))return![];_0x2cff20=!![];}else _0x22dcaa=_0x377da4[_0x1616d5(0x40c)](this),_0x541ac6[_0x1616d5(0x201)]=!![];}if(_0x4265d8[_0x1616d5(0x156)](_0x3d2280[_0x1616d5(0x363)])){const _0x26e80a=Number(RegExp['$1']);if(_0x26e80a>$gameParty['gold']())return![];_0x2cff20=!![];}{const _0x48fbe2=_0x4265d8[_0x1616d5(0x156)](_0x3d2280[_0x1616d5(0x255)]);if(_0x48fbe2){if('pVZPa'===_0x1616d5(0x283))for(const _0x51efdd of _0x48fbe2){_0x51efdd[_0x1616d5(0x156)](_0x3d2280['LearnHaveItem']);const _0x49e5ad=String(RegExp['$1']),_0x4bf5be=Number(RegExp['$2']),_0x2e4d65=/^\d+$/[_0x1616d5(0x239)](_0x49e5ad),_0x1a320c=_0x2e4d65?Number(_0x49e5ad):DataManager[_0x1616d5(0x271)](_0x49e5ad),_0x58783c=$dataItems[_0x1a320c];if(!_0x58783c)continue;if(_0x4bf5be>$gameParty[_0x1616d5(0x36f)](_0x58783c))return![];_0x2cff20=!![];}else{if(!this['equipMedalExpVisible']())return;this['_rewards'][_0x1616d5(0x267)]=this[_0x1616d5(0x225)][_0x1616d5(0x267)]||0x0;const _0x53ef0b=_0x380cd1[_0x1616d5(0x107)],_0x5b8dd1=_0x53ef0b[_0x1616d5(0x297)],_0x25daf3=_0x1616d5(0xfe)[_0x1616d5(0x24a)](_0x53ef0b['equipMedalExpIcon']),_0x4c4f9d=_0x53ef0b[_0x1616d5(0x302)],_0xf70feb=_0x53ef0b[_0x1616d5(0x31a)],_0x373ee5=_0xf70feb[_0x1616d5(0x24a)](_0x4c4f9d,_0x25daf3),_0xf77633=_0x5b8dd1[_0x1616d5(0x24a)](this[_0x1616d5(0x225)]['equipMedalExp'],_0x373ee5);_0xfbd424[_0x1616d5(0x31b)]('\x5c.'+_0xf77633);}}}{const _0x5ec43a=_0x4265d8[_0x1616d5(0x156)](_0x3d2280[_0x1616d5(0x348)]);if(_0x5ec43a){if('WatOC'==='WatOC')for(const _0x336534 of _0x5ec43a){_0x336534[_0x1616d5(0x156)](_0x3d2280['LearnHaveWeapon']);const _0x2ed4e9=String(RegExp['$1']),_0x3f6b23=Number(RegExp['$2']),_0x31486c=/^\d+$/[_0x1616d5(0x239)](_0x2ed4e9),_0x220268=_0x31486c?Number(_0x2ed4e9):DataManager['getWeaponIdWithName'](_0x2ed4e9),_0x3809ba=$dataWeapons[_0x220268];if(!_0x3809ba)continue;if(_0x3f6b23>$gameParty[_0x1616d5(0x36f)](_0x3809ba))return![];_0x2cff20=!![];}else return _0x2e6add(_0x508ced['$1'])[_0x1616d5(0x374)]();}}{const _0x3b290e=_0x4265d8[_0x1616d5(0x156)](_0x3d2280[_0x1616d5(0x3f9)]);if(_0x3b290e){if(_0x1616d5(0x38c)!=='gDByh')for(const _0x393bb7 of _0x3b290e){_0x393bb7[_0x1616d5(0x156)](_0x3d2280[_0x1616d5(0x3f9)]);const _0x36f7a7=String(RegExp['$1']),_0x34cc23=Number(RegExp['$2']),_0x5dd106=/^\d+$/[_0x1616d5(0x239)](_0x36f7a7),_0x179e1b=_0x5dd106?Number(_0x36f7a7):DataManager[_0x1616d5(0x182)](_0x36f7a7),_0x53cf2f=$dataArmors[_0x179e1b];if(!_0x53cf2f)continue;if(_0x34cc23>$gameParty[_0x1616d5(0x36f)](_0x53cf2f))return![];_0x2cff20=!![];}else{const _0x77ece=_0x460567[_0x1616d5(0x156)](_0x34c33a[_0x1616d5(0x101)]);if(_0x77ece)for(const _0x2c37c8 of _0x77ece){_0x2c37c8[_0x1616d5(0x156)](_0x592843[_0x1616d5(0x101)]);let _0xda7313=_0x123f98(_0x134a48['$1']);const _0x5aeb54=_0x18731c(_0x2d4a8f['$2']),_0xd7666c=/^\d+$/[_0x1616d5(0x239)](_0xda7313);_0xda7313=_0xd7666c?_0x17fd38(_0xda7313):_0x1c76fe[_0x1616d5(0x187)](_0xda7313);if(_0x5aeb54>_0x4fea67[_0x1616d5(0x22d)](_0x14db4c,_0x1616d5(0x15f),_0xda7313))return![];_0x5cc29b=!![];}}}}{if(_0x1616d5(0x10b)==='xBkTf'){const _0x13e443=_0x4265d8[_0x1616d5(0x156)](_0x3d2280[_0x1616d5(0x285)]);if(_0x13e443){if(_0x1616d5(0x19f)===_0x1616d5(0x27a))for(const _0x3a2502 of _0xd73c05){_0x3a2502['match'](_0x20d858[_0x3b1fe0]);let _0x5ae1a4=_0xa2dbca(_0x57cc57['$1']);const _0x1d5d1f=/^\d+$/['test'](_0x5ae1a4);_0x5ae1a4=_0x1d5d1f?_0x10cb08(_0x5ae1a4):_0x109995[_0x1616d5(0x1e1)](_0x5ae1a4),_0x5246d7[_0x1616d5(0x2c4)](_0x5ae1a4)&&this[_0x1616d5(0x400)](_0x372eee,_0x1f88e7,_0x5ae1a4,0x1);}else for(const _0x52eb91 of _0x13e443){_0x52eb91[_0x1616d5(0x156)](_0x3d2280['LearnHaveParam']);let _0x58caa4=String(RegExp['$1'])[_0x1616d5(0x33c)]()[_0x1616d5(0x374)]();const _0x37efc6=Number(RegExp['$2']);if(_0x58caa4==='MHP')_0x58caa4=_0x1616d5(0x402);if(_0x58caa4==='MAX\x20HP')_0x58caa4=_0x1616d5(0x402);if(_0x58caa4===_0x1616d5(0x2f2))_0x58caa4=_0x1616d5(0x369);if(_0x58caa4===_0x1616d5(0x298))_0x58caa4=_0x1616d5(0x369);const _0x461367=[_0x1616d5(0x402),'MAXMP','ATK',_0x1616d5(0x30d),_0x1616d5(0x301),_0x1616d5(0x33a),_0x1616d5(0x388),'LUK'],_0x23f77c=_0x461367[_0x1616d5(0x26a)](_0x58caa4);if(_0x37efc6>_0x23d8d7[_0x1616d5(0x396)](_0x23f77c))return![];_0x2cff20=!![];}}}else this[_0x1616d5(0x2bf)]!==_0x329ebb&&(this['_actor']=_0x206932,this[_0x1616d5(0x3f5)](),this[_0x1616d5(0x380)](0x0,0x0));}{if(_0x1616d5(0x2a3)!==_0x1616d5(0x185)){const _0x22a5db=_0x4265d8[_0x1616d5(0x156)](_0x3d2280[_0x1616d5(0x32a)]);if(_0x22a5db)for(const _0x1cf0ef of _0x22a5db){_0x1cf0ef['match'](_0x3d2280[_0x1616d5(0x32a)]);let _0x1d9afe=String(RegExp['$1'])[_0x1616d5(0x33c)]()[_0x1616d5(0x374)]();const _0x2bdec2=Number(RegExp['$2'])*0.01,_0xbdcca0=[_0x1616d5(0x382),_0x1616d5(0x217),_0x1616d5(0x1e5),_0x1616d5(0x347),'MEV',_0x1616d5(0x20c),'CNT',_0x1616d5(0x25d),'MRG',_0x1616d5(0x313)],_0x60714=_0xbdcca0[_0x1616d5(0x26a)](_0x1d9afe);if(_0x2bdec2>_0x23d8d7[_0x1616d5(0x29c)](_0x60714))return![];_0x2cff20=!![];}}else{const _0x3b2e34=_0x4bc829[_0x1616d5(0x156)](_0x4dee19[_0x1616d5(0x304)]);if(_0x3b2e34)for(const _0x113842 of _0x3b2e34){_0x113842[_0x1616d5(0x156)](_0x28bd21[_0x1616d5(0x304)]);let _0x454f82=_0x165bdf(_0x29170f['$1']);const _0x11c745=_0x34f07e(_0x256c2c['$2']),_0x179db1=/^\d+$/['test'](_0x454f82);_0x454f82=_0x179db1?_0x2df6ae(_0x454f82):_0x54b3cd[_0x1616d5(0x187)](_0x454f82);const _0x53b22d=_0x4d8b81['getEquipMedalLearnProgress'](_0x5b74bf,_0x1616d5(0x23a),_0x454f82),_0x2e33ba='stateTake',_0x382928=_0x28e30c[_0x454f82],_0x55aa21=_0x1616d5(0x124)['format'](_0x382928['iconIndex'],_0x382928[_0x1616d5(0x24b)]);_0x73c776=this[_0x1616d5(0x403)](_0x53a19d,_0x11c745,_0x53b22d,_0x2e33ba,_0x55aa21);}}}{const _0x2cf74f=_0x4265d8[_0x1616d5(0x156)](_0x3d2280[_0x1616d5(0x288)]);if(_0x2cf74f)for(const _0x3b055f of _0x2cf74f){_0x3b055f[_0x1616d5(0x156)](_0x3d2280[_0x1616d5(0x288)]);let _0x36a1cf=String(RegExp['$1'])['toUpperCase']()[_0x1616d5(0x374)]();const _0x18fa74=Number(RegExp['$2'])*0.01,_0x465a8a=['TGR',_0x1616d5(0x2fa),_0x1616d5(0x27d),_0x1616d5(0x183),_0x1616d5(0x2d6),_0x1616d5(0x1ba),_0x1616d5(0x113),_0x1616d5(0x40d),'FDR',_0x1616d5(0x427)],_0x486460=_0x465a8a[_0x1616d5(0x26a)](_0x36a1cf);if(_0x18fa74>_0x23d8d7[_0x1616d5(0x2e8)](_0x486460))return![];_0x2cff20=!![];}}return _0x2cff20;},Game_Actor[_0x5b5488(0x286)][_0x5b5488(0x22d)]=function(_0x5937af,_0x524e5a,_0x3f2b43){const _0x2836cf=_0x5b5488;return _0x5937af=_0x5937af['id']||_0x5937af,this[_0x2836cf(0x443)]=this['_equipMedalLearnProgress']||{},this[_0x2836cf(0x443)][_0x5937af]=this['_equipMedalLearnProgress'][_0x5937af]||{},this['_equipMedalLearnProgress'][_0x5937af][_0x524e5a]=this[_0x2836cf(0x443)][_0x5937af][_0x524e5a]||{},this[_0x2836cf(0x443)][_0x5937af][_0x524e5a][_0x3f2b43]=this[_0x2836cf(0x443)][_0x5937af][_0x524e5a][_0x3f2b43]||0x0,this['_equipMedalLearnProgress'][_0x5937af][_0x524e5a][_0x3f2b43];},Game_Actor[_0x5b5488(0x286)]['updateEquipMedalLearnProgress']=function(_0x81f11e,_0x17078e,_0x58b40c,_0xf33b6f){const _0xdd8e7=_0x5b5488;_0x81f11e=_0x81f11e['id']||_0x81f11e,this['_equipMedalLearnProgress']=this['_equipMedalLearnProgress']||{},this['_equipMedalLearnProgress'][_0x81f11e]=this['_equipMedalLearnProgress'][_0x81f11e]||{},this[_0xdd8e7(0x443)][_0x81f11e][_0x17078e]=this[_0xdd8e7(0x443)][_0x81f11e][_0x17078e]||{},this[_0xdd8e7(0x443)][_0x81f11e][_0x17078e][_0x58b40c]=this[_0xdd8e7(0x443)][_0x81f11e][_0x17078e][_0x58b40c]||0x0,this[_0xdd8e7(0x443)][_0x81f11e][_0x17078e][_0x58b40c]+=_0xf33b6f;},VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x30a)]=Game_Battler['prototype']['processBattleCoreJS'],Game_Battler[_0x5b5488(0x286)][_0x5b5488(0x14f)]=function(_0x2b1248){const _0x5d8e72=_0x5b5488;VisuMZ['EquipMedalSys'][_0x5d8e72(0x30a)][_0x5d8e72(0x116)](this,_0x2b1248);if(!this['isActor']())return;if(_0x2b1248===_0x5d8e72(0x3bf))this[_0x5d8e72(0x432)]();else{if(_0x2b1248===_0x5d8e72(0x44f))this[_0x5d8e72(0x20e)]();else{if(_0x2b1248===_0x5d8e72(0x305)){if('gbpgX'!==_0x5d8e72(0x2af)){if(!_0x31f3c4['isArmor'](_0x37a1c1))return![];if(this[_0x5d8e72(0x299)]===_0xc19efe)this['initEquipMedalSystem']();return this[_0x5d8e72(0x299)]['includes'](_0x2548ca['id']);}else this[_0x5d8e72(0x254)]();}}}},Game_Actor[_0x5b5488(0x286)]['updateEquipMedalBattleVictory']=function(){const _0x18a3da=_0x5b5488,_0x3c17b4=VisuMZ['EquipMedalSys'][_0x18a3da(0x1c0)],_0x1ade02=this[_0x18a3da(0x13a)]();for(const _0x70278c of _0x1ade02){if(!_0x70278c)continue;const _0x9d5044=_0x70278c[_0x18a3da(0x3f3)]||'';_0x9d5044[_0x18a3da(0x156)](_0x3c17b4[_0x18a3da(0x3d8)])&&this[_0x18a3da(0x400)](_0x70278c,_0x18a3da(0x2fb),_0x18a3da(0x367),0x1),_0x9d5044[_0x18a3da(0x156)](_0x3c17b4['LearnVictory'])&&this['updateEquipMedalLearnProgress'](_0x70278c,'battle',_0x18a3da(0x35d),0x1);}},Game_Actor['prototype'][_0x5b5488(0x20e)]=function(){const _0x4fdae1=_0x5b5488,_0x43c641=VisuMZ[_0x4fdae1(0x405)][_0x4fdae1(0x1c0)],_0x1f07c2=this[_0x4fdae1(0x13a)]();for(const _0xf1a52c of _0x1f07c2){if(_0x4fdae1(0x381)!==_0x4fdae1(0x381))_0xae5a50=_0x6325e2(_0x120e02['$1']);else{if(!_0xf1a52c)continue;const _0x184771=_0xf1a52c[_0x4fdae1(0x3f3)]||'';_0x184771[_0x4fdae1(0x156)](_0x43c641[_0x4fdae1(0x3d8)])&&this[_0x4fdae1(0x400)](_0xf1a52c,_0x4fdae1(0x2fb),_0x4fdae1(0x367),0x1),_0x184771[_0x4fdae1(0x156)](_0x43c641['LearnVictory'])&&this[_0x4fdae1(0x400)](_0xf1a52c,_0x4fdae1(0x2fb),_0x4fdae1(0x385),0x1);}}},Game_Actor[_0x5b5488(0x286)][_0x5b5488(0x254)]=function(){const _0x18b906=_0x5b5488,_0x2c2e83=VisuMZ[_0x18b906(0x405)][_0x18b906(0x1c0)],_0x130b85=this[_0x18b906(0x13a)]();for(const _0x409390 of _0x130b85){if(_0x18b906(0x17f)!==_0x18b906(0x43f)){if(!_0x409390)continue;const _0x58ebb9=_0x409390[_0x18b906(0x3f3)]||'';_0x58ebb9[_0x18b906(0x156)](_0x2c2e83['LearnBattles'])&&(_0x18b906(0x37d)===_0x18b906(0x37d)?this[_0x18b906(0x400)](_0x409390,_0x18b906(0x2fb),'all',0x1):_0x16cc8c[_0x18b906(0x2f7)]());if(_0x58ebb9[_0x18b906(0x156)](_0x2c2e83[_0x18b906(0x14d)])){if(_0x18b906(0x26f)===_0x18b906(0x26f))this['updateEquipMedalLearnProgress'](_0x409390,'battle',_0x18b906(0x303),0x1);else{_0xd85eb8['match'](_0xd43f5d['LearnStateTake']);let _0x3d9233=_0x4e6b32(_0x108185['$1']);const _0x1c32b2=_0x2453b0(_0x564a1a['$2']),_0x2bb230=/^\d+$/[_0x18b906(0x239)](_0x3d9233);_0x3d9233=_0x2bb230?_0x3a2eb7(_0x3d9233):_0x40a6a1[_0x18b906(0x187)](_0x3d9233);if(_0x1c32b2>_0x1e235d[_0x18b906(0x22d)](_0x10d51c,_0x18b906(0x23a),_0x3d9233))return![];_0x21de51=!![];}}}else{let _0x58b104='';_0x58b104+=_0x18b906(0x241),_0x58b104+=_0x18b906(0x319),_0x522c44(_0x58b104),_0x284b6b[_0x18b906(0x273)]();}}},VisuMZ['EquipMedalSys'][_0x5b5488(0x2e5)]=Game_Action[_0x5b5488(0x286)]['applyGlobal'],Game_Action[_0x5b5488(0x286)]['applyGlobal']=function(){const _0x37fbb5=_0x5b5488;VisuMZ[_0x37fbb5(0x405)]['Game_Action_applyGlobal']['call'](this),this[_0x37fbb5(0x1e9)]()&&this['subject']()['isActor']()&&this['subject']()[_0x37fbb5(0x106)](this);},Game_Actor['prototype'][_0x5b5488(0x106)]=function(_0x1c64fc){const _0x4b04e7=_0x5b5488,_0x214c19=VisuMZ[_0x4b04e7(0x405)][_0x4b04e7(0x1c0)],_0x2a09dd=this[_0x4b04e7(0x13a)]();for(const _0x4cea8a of _0x2a09dd){if(!_0x4cea8a)continue;const _0x282330=_0x4cea8a[_0x4b04e7(0x3f3)]||'';if(_0x282330[_0x4b04e7(0x156)](_0x214c19[_0x4b04e7(0x3e4)])){if('cckaI'!=='EEqMr'){if(_0x1c64fc[_0x4b04e7(0x455)]()){if('FoYwn'!==_0x4b04e7(0x386))return _0x5db50f[_0x4b04e7(0x1df)]();else this[_0x4b04e7(0x400)](_0x4cea8a,_0x4b04e7(0x3dc),_0x4b04e7(0x280),0x1);}}else _0x2b0814[_0x4b04e7(0x405)][_0x4b04e7(0x1cd)][_0x4b04e7(0x116)](this),this[_0x4b04e7(0xfa)]();}if(_0x282330[_0x4b04e7(0x156)](_0x214c19['LearnGuardTimes'])){if(_0x4b04e7(0x2b0)!=='kPfuO')_0x1c64fc['isGuard']()&&this[_0x4b04e7(0x400)](_0x4cea8a,_0x4b04e7(0x3dc),_0x4b04e7(0x1bd),0x1);else{const _0x2582ea=_0x53efbc['EQUIP_MEDAL_SYS'],_0x11d16a=_0x2582ea[_0x4b04e7(0x406)];let _0xc36ef7=_0x2582ea['minCapacity'];try{_0x4ef295[_0x4b04e7(0x1f9)]=this,_0xc36ef7=_0x454b6d(_0x11d16a),_0x346ca0[_0x4b04e7(0x1f9)]=_0x51c2e2;}catch(_0x33941f){_0xc36ef7=_0x2582ea[_0x4b04e7(0x229)];}return _0xc36ef7=_0xc36ef7['clamp'](_0x2582ea[_0x4b04e7(0x229)],_0x2582ea[_0x4b04e7(0x3b1)]),_0xc36ef7;}}_0x282330[_0x4b04e7(0x156)](_0x214c19['LearnSkillUsage'])&&(_0x1c64fc[_0x4b04e7(0x235)]()&&!_0x1c64fc[_0x4b04e7(0x455)]()&&!_0x1c64fc[_0x4b04e7(0x274)]()&&this[_0x4b04e7(0x400)](_0x4cea8a,_0x4b04e7(0x3dc),_0x4b04e7(0x296),0x1));_0x282330[_0x4b04e7(0x156)](_0x214c19['LearnPhysSkill'])&&(_0x1c64fc[_0x4b04e7(0x235)]()&&_0x1c64fc[_0x4b04e7(0x1dc)]()&&!_0x1c64fc['isAttack']()&&!_0x1c64fc[_0x4b04e7(0x274)]()&&('dFUMY'===_0x4b04e7(0x365)?this['updateEquipMedalLearnProgress'](_0x445d82,_0x4b04e7(0x3dc),_0x4b04e7(0x41b),0x1):this[_0x4b04e7(0x400)](_0x4cea8a,_0x4b04e7(0x3dc),'physicalSkill',0x1)));if(_0x282330['match'](_0x214c19[_0x4b04e7(0x1a1)])){if(_0x4b04e7(0x3b0)!==_0x4b04e7(0x3b0)){const _0x48559b=_0x502ac1(_0x388a88['$1']);_0x48559b!==_0x58cb7a[_0x4537a2][_0x4b04e7(0x262)]&&(_0x258362(_0x4b04e7(0x151)[_0x4b04e7(0x24a)](_0x37c538,_0x48559b)),_0x4f7e9e[_0x4b04e7(0x273)]());}else{if(_0x1c64fc['isSkill']()&&_0x1c64fc[_0x4b04e7(0x1b1)]()&&!_0x1c64fc[_0x4b04e7(0x455)]()&&!_0x1c64fc[_0x4b04e7(0x274)]()){if('sReAI'==='IioYz'){if(!_0x152435[_0x4b04e7(0x23e)](_0x51c09e))return 0x0;return this[_0x4b04e7(0x10d)]=this[_0x4b04e7(0x10d)]||{},this[_0x4b04e7(0x10d)][_0xd37e0a['id']]=this[_0x4b04e7(0x10d)][_0x1e7f86['id']]||0x0,this[_0x4b04e7(0x10d)][_0x4aad69['id']];}else this[_0x4b04e7(0x400)](_0x4cea8a,'actionTimes',_0x4b04e7(0x41b),0x1);}}}if(_0x282330[_0x4b04e7(0x156)](_0x214c19[_0x4b04e7(0x15d)])){if(_0x1c64fc['isSkill']()&&_0x1c64fc[_0x4b04e7(0x3b9)]()&&!_0x1c64fc[_0x4b04e7(0x455)]()&&!_0x1c64fc[_0x4b04e7(0x274)]()){if(_0x4b04e7(0x34c)!==_0x4b04e7(0x207))this[_0x4b04e7(0x400)](_0x4cea8a,_0x4b04e7(0x3dc),_0x4b04e7(0x2b2),0x1);else{const _0x448d61=_0x572015(_0x2ba758['$1']);if(_0x448d61>_0x2974bd[_0x4b04e7(0x22d)](_0x3a3f62,'hp','dmgDeal'))return![];_0x596c5e=!![];}}}_0x282330[_0x4b04e7(0x156)](_0x214c19['LearnItemUsage'])&&(_0x1c64fc[_0x4b04e7(0x287)]()&&this[_0x4b04e7(0x400)](_0x4cea8a,_0x4b04e7(0x3dc),_0x4b04e7(0x3a0),0x1));{if(_0x4b04e7(0x2dc)!==_0x4b04e7(0x391)){const _0x454210=_0x282330[_0x4b04e7(0x156)](_0x214c19['LearnSTypeUsage']);if(_0x454210&&_0x1c64fc[_0x4b04e7(0x235)]()&&!_0x1c64fc[_0x4b04e7(0x455)]()&&!_0x1c64fc[_0x4b04e7(0x274)]()){if(_0x4b04e7(0x209)!==_0x4b04e7(0x29b))for(const _0x255f0f of _0x454210){_0x255f0f[_0x4b04e7(0x156)](_0x214c19[_0x4b04e7(0x32e)]);let _0x2506a0=String(RegExp['$1']);const _0x1de486=/^\d+$/[_0x4b04e7(0x239)](_0x2506a0);_0x2506a0=_0x1de486?Number(_0x2506a0):DataManager[_0x4b04e7(0x143)](_0x2506a0);if(Imported['VisuMZ_1_SkillsStatesCore']){if(_0x4b04e7(0x3bb)!==_0x4b04e7(0x231)){const _0x4e7c06=DataManager[_0x4b04e7(0x3dd)](_0x1c64fc[_0x4b04e7(0x3a0)]());if(!_0x4e7c06[_0x4b04e7(0x2c4)](_0x2506a0))continue;}else _0x50cb84[_0x4b04e7(0x414)](),_0x302d58[_0x4b04e7(0x17c)](),_0xb7b791[_0x4b04e7(0x2ac)]();}else{if(_0x1c64fc[_0x4b04e7(0x3a0)]()[_0x4b04e7(0x163)]!==_0x2506a0)continue;}this[_0x4b04e7(0x400)](_0x4cea8a,'stype',_0x2506a0,0x1);}else this['equipAdjustHpMp'](_0x178d55);}}else{if(this[_0x4b04e7(0x436)]===_0x206c30)this['initEquipMedalSystem']();return this[_0x4b04e7(0x436)];}}}},VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x2a2)]=Game_Action[_0x5b5488(0x286)]['apply'],Game_Action['prototype'][_0x5b5488(0x1af)]=function(_0x39d841){const _0x3c6e83=_0x5b5488;VisuMZ[_0x3c6e83(0x405)]['Game_Action_apply']['call'](this,_0x39d841);const _0x6e6c68=_0x39d841[_0x3c6e83(0x3ba)]();this[_0x3c6e83(0x1e9)]()['isActor']()&&this['subject']()[_0x3c6e83(0x3cc)](_0x6e6c68,!![]),_0x39d841[_0x3c6e83(0x108)]()&&_0x39d841[_0x3c6e83(0x3cc)](_0x6e6c68,![]);},Game_Actor[_0x5b5488(0x286)][_0x5b5488(0x3cc)]=function(_0x2351bf,_0x34ff7d){const _0x14d395=_0x5b5488,_0x661884=VisuMZ[_0x14d395(0x405)][_0x14d395(0x1c0)],_0x3e4336=this[_0x14d395(0x13a)](),_0x9bbb1=_0x34ff7d?_0x14d395(0x21d):_0x14d395(0x1fb),_0x2a90e1=_0x34ff7d?'critDeal':_0x14d395(0x361),_0x4e0bb7=_0x34ff7d?_0x14d395(0x1c2):_0x14d395(0x3d2),_0x1b2f16=_0x34ff7d?_0x14d395(0x2dd):_0x14d395(0x3c2);for(const _0x5cc9aa of _0x3e4336){if(!_0x5cc9aa)continue;const _0x52f8af=_0x5cc9aa['note']||'';_0x52f8af[_0x14d395(0x156)](_0x661884[_0x9bbb1])&&(_0x2351bf['critical']&&this[_0x14d395(0x400)](_0x5cc9aa,_0x14d395(0x3dc),_0x2a90e1,0x1)),_0x52f8af[_0x14d395(0x156)](_0x661884[_0x4e0bb7])&&((_0x2351bf[_0x14d395(0x1c8)]||_0x2351bf[_0x14d395(0xff)])&&this['updateEquipMedalLearnProgress'](_0x5cc9aa,'actionTimes',_0x1b2f16,0x1));}},VisuMZ[_0x5b5488(0x405)]['Game_Action_executeDamage']=Game_Action['prototype'][_0x5b5488(0x25b)],Game_Action[_0x5b5488(0x286)]['executeDamage']=function(_0x461265,_0x370002){const _0x37333f=_0x5b5488;VisuMZ[_0x37333f(0x405)][_0x37333f(0x2ba)][_0x37333f(0x116)](this,_0x461265,_0x370002);if(_0x370002<=0x0)return;this[_0x37333f(0x1e9)]()[_0x37333f(0x108)]()&&this['subject']()[_0x37333f(0x2ed)](this,!![]),_0x461265['isActor']()&&(_0x37333f(0x13b)!==_0x37333f(0x1ce)?_0x461265[_0x37333f(0x2ed)](this,![]):_0x2388c0+=_0x37333f(0x371));},Game_Actor[_0x5b5488(0x286)][_0x5b5488(0x2ed)]=function(_0x784db9,_0x5ae051){const _0x45245b=_0x5b5488,_0x15b49f=VisuMZ[_0x45245b(0x405)][_0x45245b(0xfc)](_0x784db9);if(_0x15b49f[_0x45245b(0x257)]<=0x0)return;const _0x149d32=_0x5ae051?_0x45245b(0x39c):_0x45245b(0x26b),_0x5b74e0=VisuMZ[_0x45245b(0x405)][_0x45245b(0x1c0)],_0x2ebc8d=_0x5ae051?'LearnElementDeal':_0x45245b(0x252),_0x104bbf=this[_0x45245b(0x13a)]();for(const _0x5b8e62 of _0x104bbf){if(!_0x5b8e62)continue;const _0x1f25bf=_0x5b8e62['note']||'',_0xfb5e14=_0x1f25bf['match'](_0x5b74e0[_0x2ebc8d]);if(_0xfb5e14)for(const _0x49cfba of _0xfb5e14){if(_0x45245b(0x2cf)===_0x45245b(0x2d3)){const _0x267e3e=_0x1cc407[_0x45245b(0x156)](_0x2121d0['LearnHaveXParam']);if(_0x267e3e)for(const _0x51d47c of _0x267e3e){_0x51d47c[_0x45245b(0x156)](_0x4bd76a[_0x45245b(0x32a)]);let _0x1f523e=_0x148d69(_0xf38040['$1'])[_0x45245b(0x33c)]()[_0x45245b(0x374)]();const _0x491d94=_0x14f22d(_0x214d9c['$2']),_0x517318=['HIT',_0x45245b(0x217),_0x45245b(0x1e5),_0x45245b(0x347),_0x45245b(0x421),_0x45245b(0x20c),'CNT',_0x45245b(0x25d),_0x45245b(0x176),_0x45245b(0x313)],_0x9d41b7=_0x517318[_0x45245b(0x26a)](_0x1f523e),_0x388222=_0xe4fb82[_0x45245b(0x16b)](_0x5dd28a[_0x45245b(0x29c)](_0x9d41b7)*0x64),_0x1b88d4=_0x45245b(0x376),_0x3a2af4=_0x5d143c[_0x45245b(0x2ca)](_0x1f523e);_0x3856da=this[_0x45245b(0x403)](_0x324f30,_0x491d94,_0x388222,_0x1b88d4,_0x3a2af4);}}else{_0x49cfba[_0x45245b(0x156)](_0x5b74e0[_0x2ebc8d]);let _0x10f105=String(RegExp['$1']);const _0x37cda9=/^\d+$/[_0x45245b(0x239)](_0x10f105);_0x10f105=_0x37cda9?Number(_0x10f105):DataManager[_0x45245b(0x1e1)](_0x10f105);if(_0x15b49f['includes'](_0x10f105)){if(_0x45245b(0x3ff)===_0x45245b(0x3ff))this[_0x45245b(0x400)](_0x5b8e62,_0x149d32,_0x10f105,0x1);else{_0x3bec11[_0x45245b(0x405)]['Game_Action_apply'][_0x45245b(0x116)](this,_0x2e9747);const _0x2fe2af=_0x585872[_0x45245b(0x3ba)]();this[_0x45245b(0x1e9)]()[_0x45245b(0x108)]()&&this[_0x45245b(0x1e9)]()[_0x45245b(0x3cc)](_0x2fe2af,!![]),_0x1ab1c6[_0x45245b(0x108)]()&&_0x1838f5[_0x45245b(0x3cc)](_0x2fe2af,![]);}}}}}},VisuMZ[_0x5b5488(0x405)][_0x5b5488(0xfc)]=function(_0x51df49){const _0x468ace=_0x5b5488;let _0x221efb=[];if(Imported[_0x468ace(0x3c5)])'xjJAz'==='xjJAz'?_0x221efb=_0x51df49[_0x468ace(0x416)]():this['updateEquipMedalLearnProgress'](_0x5f0795,'hp',_0xdf5198,_0x13ed65[_0x468ace(0x397)](_0x4aaeb6));else{const _0x2628f3=_0x51df49[_0x468ace(0x3a0)]()['damage'][_0x468ace(0x127)];_0x2628f3<0x0?_0x468ace(0x3f8)===_0x468ace(0x3f8)?_0x221efb=_0x51df49[_0x468ace(0x1e9)]()['attackElements']():_0x2872c6=this[_0x468ace(0x2ae)]:_0x221efb=[_0x2628f3];}return _0x221efb;},VisuMZ['EquipMedalSys'][_0x5b5488(0x2f6)]=Game_Battler['prototype']['addState'],Game_Battler[_0x5b5488(0x286)]['addState']=function(_0x49da0b){const _0x1453a1=_0x5b5488;VisuMZ[_0x1453a1(0x405)][_0x1453a1(0x2f6)][_0x1453a1(0x116)](this,_0x49da0b);if(this['isStateAffected'](_0x49da0b)){if(_0x1453a1(0x330)===_0x1453a1(0x28b)){const _0x5f2bbe=_0x569611[_0x1453a1(0x107)][_0x1453a1(0x307)],_0x538089=this['textSizeEx'](_0x5f2bbe)['width'],_0x1d6e59=_0xad614b['x']+_0x3f278a[_0x1453a1(0x1a2)]-_0x538089;this[_0x1453a1(0x368)](_0x5f2bbe,_0x1d6e59,_0x53c877['y']),this[_0x1453a1(0x1ae)]();}else{const _0x85dfb3=BattleManager[_0x1453a1(0x2a7)];$gameParty[_0x1453a1(0x133)]()&&_0x85dfb3&&_0x85dfb3[_0x1453a1(0x108)]()&&_0x85dfb3[_0x1453a1(0x428)](_0x49da0b,!![]);this[_0x1453a1(0x108)]()&&(this[_0x1453a1(0x428)](_0x49da0b,![]),_0x49da0b===this[_0x1453a1(0x336)]()&&this[_0x1453a1(0x13c)](_0x1453a1(0x300)));if(this[_0x1453a1(0x154)]()&&_0x49da0b===this['deathStateId']()&&BattleManager['_subject']&&BattleManager['_subject']['isActor']()){BattleManager[_0x1453a1(0x2a7)][_0x1453a1(0x37b)](this),BattleManager[_0x1453a1(0x2a7)][_0x1453a1(0x13c)]('kills');for(const _0x1c1146 of $gameParty[_0x1453a1(0x3e1)]()){if(_0x1453a1(0x340)!==_0x1453a1(0x340)){const _0x5d0d7a=_0x14becb[_0x1453a1(0x405)][_0x1453a1(0x1c0)],_0x3495cd=_0xce22e5[_0x1453a1(0x3f3)]||'';if(_0x3495cd['match'](_0x5d0d7a[_0x1453a1(0x3fa)]))return _0x58006e(_0x3e2d8a['$1'])[_0x1453a1(0x374)]();const _0x33e786=_0x516517[_0x1453a1(0x417)][_0x1453a1(0x20f)];return _0x21d61f(_0x2e2303[_0x1453a1(0x24b)][_0x1453a1(0x257)]+0x1)[_0x1453a1(0x1de)](_0x33e786);}else{if(!_0x1c1146)continue;if(_0x1c1146===BattleManager[_0x1453a1(0x2a7)])continue;if(!_0x1c1146[_0x1453a1(0x193)]())continue;_0x1c1146[_0x1453a1(0x13c)](_0x1453a1(0x23b));}}}}}},Game_Actor[_0x5b5488(0x286)][_0x5b5488(0x428)]=function(_0x20d10c,_0x41785f){const _0x30fc3d=_0x5b5488;if(!$dataStates[_0x20d10c])return;const _0x4d6636=_0x41785f?'stateDeal':'stateTake',_0x41cfa4=VisuMZ[_0x30fc3d(0x405)][_0x30fc3d(0x1c0)],_0x3e8ec6=_0x41785f?_0x30fc3d(0x101):'LearnStateTake',_0x400844=this[_0x30fc3d(0x13a)]();for(const _0x7a8788 of _0x400844){if(_0x30fc3d(0x147)!==_0x30fc3d(0x147))this[_0x30fc3d(0x1e9)]()[_0x30fc3d(0x2ed)](this,!![]);else{if(!_0x7a8788)continue;const _0x1c3b17=_0x7a8788[_0x30fc3d(0x3f3)]||'',_0xdf4f1=_0x1c3b17['match'](_0x41cfa4[_0x3e8ec6]);if(_0xdf4f1){if(_0x30fc3d(0x1b8)!==_0x30fc3d(0x2b8))for(const _0x5af458 of _0xdf4f1){if(_0x30fc3d(0x191)===_0x30fc3d(0x191)){_0x5af458[_0x30fc3d(0x156)](_0x41cfa4[_0x3e8ec6]);let _0x208708=String(RegExp['$1']);const _0x180d66=/^\d+$/[_0x30fc3d(0x239)](_0x208708);_0x208708=_0x180d66?Number(_0x208708):DataManager['getStateIdWithName'](_0x208708),_0x20d10c===_0x208708&&this[_0x30fc3d(0x400)](_0x7a8788,_0x4d6636,_0x20d10c,0x1);}else{_0x3fd030&&(_0x32386a['deactivate'](),_0x1d3f2b[_0x30fc3d(0x17c)](),_0x8a91ae['hide']());if(this[_0x30fc3d(0x2bf)])this[_0x30fc3d(0x2bf)][_0x30fc3d(0x222)]();_0xa1d7eb['refresh'](),_0x5a5199['show'](),_0x1ecb34&&(_0xc6b297['refresh'](),_0x109ae9[_0x30fc3d(0x21e)]());}}else this[_0x30fc3d(0x2bf)]!==_0x5e0efe&&(this[_0x30fc3d(0x2bf)]=_0x486a28,this['refresh']());}}}},Game_Actor['prototype'][_0x5b5488(0x37b)]=function(_0x2e98ad){const _0x303f35=_0x5b5488;if(!_0x2e98ad)return;if(!Imported['VisuMZ_1_ElementStatusCore'])return;const _0xc37e97=VisuMZ['EquipMedalSys'][_0x303f35(0x1c0)],_0x3a5179=this[_0x303f35(0x13a)]();for(const _0x4fd9c2 of _0x3a5179){if(!_0x4fd9c2)continue;const _0x2ca2ab=_0x4fd9c2[_0x303f35(0x3f3)]||'',_0xfd616d=_0x2ca2ab[_0x303f35(0x156)](_0xc37e97['LearnDefeatTrait']);if(_0xfd616d){if('eFtDS'===_0x303f35(0x425)){const _0x598f32=_0x376ece[_0x303f35(0x107)][_0x303f35(0x448)],_0x4a3ef8=_0x448d4f[_0x303f35(0x256)](_0x249f5c),_0x2622a3=_0x303f35(0xfe)[_0x303f35(0x24a)](_0x2dc6f6[_0x303f35(0x2cb)](_0x206487)),_0x3d0de3=_0x598f32[_0x303f35(0x24a)](this[_0x303f35(0x24b)](),_0x4a3ef8,_0x2622a3);_0xca1ebd(_0x3d0de3);}else for(const _0x58c154 of _0xfd616d){_0x58c154[_0x303f35(0x156)](_0xc37e97['LearnDefeatTrait']);const _0x3037dd=String(RegExp['$1'])['toUpperCase']()[_0x303f35(0x374)]();_0x2e98ad[_0x303f35(0x378)](_0x3037dd)&&(_0x303f35(0x322)!==_0x303f35(0x322)?_0x2585aa=_0x236e86(_0x846071):this[_0x303f35(0x400)](_0x4fd9c2,_0x303f35(0x321),_0x3037dd,0x1));}}}},VisuMZ['EquipMedalSys'][_0x5b5488(0x441)]=Game_Battler[_0x5b5488(0x286)]['gainHp'],Game_Battler[_0x5b5488(0x286)][_0x5b5488(0x1e7)]=function(_0x382274){const _0x1e93d9=_0x5b5488,_0x441ac3=this['hp'];VisuMZ['EquipMedalSys']['Game_Battler_gainHp'][_0x1e93d9(0x116)](this,_0x382274);const _0x445d6c=this['hp']-_0x441ac3;if(_0x445d6c===0x0)return;if(!$gameParty[_0x1e93d9(0x133)]())return;this['isActor']()&&this[_0x1e93d9(0x170)](_0x382274,![]),BattleManager[_0x1e93d9(0x2a7)]&&BattleManager['_subject'][_0x1e93d9(0x108)]()&&BattleManager[_0x1e93d9(0x2a7)][_0x1e93d9(0x170)](_0x382274,!![]);},Game_Actor['prototype']['updateEquipMedalHpChanges']=function(_0x41f46c,_0x20669b){const _0x34d6a9=_0x5b5488;if(!Imported[_0x34d6a9(0x3c5)])return;let _0x1a4ae3=_0x34d6a9(0x2e9);_0x1a4ae3+=_0x41f46c>0x0?_0x34d6a9(0x34d):_0x34d6a9(0x1b3),_0x1a4ae3+=_0x20669b?_0x34d6a9(0x198):_0x34d6a9(0x203);let _0x367605=_0x41f46c>0x0?_0x34d6a9(0x224):_0x34d6a9(0x2a6);_0x367605+=_0x20669b?_0x34d6a9(0x198):_0x34d6a9(0x203);const _0x28cc33=VisuMZ['EquipMedalSys'][_0x34d6a9(0x1c0)],_0x11a32f=this[_0x34d6a9(0x13a)]();for(const _0x3cc708 of _0x11a32f){if(!_0x3cc708)continue;const _0x3ebcb9=_0x3cc708[_0x34d6a9(0x3f3)]||'';_0x3ebcb9[_0x34d6a9(0x156)](_0x28cc33[_0x1a4ae3])&&('KEWNa'==='KEWNa'?this[_0x34d6a9(0x400)](_0x3cc708,'hp',_0x367605,Math[_0x34d6a9(0x397)](_0x41f46c)):(_0x991eea>0x0&&(_0x1ab597*=this['equipMedalExpRate']()),_0x1b51e2=_0x63a547['round'](_0x256948),this['addEquipMedalExp'](_0xcaa235,_0x1393b9)));}},Game_Actor[_0x5b5488(0x286)][_0x5b5488(0x13c)]=function(_0x5634a0){const _0x3cc110=_0x5b5488,_0x504b10=VisuMZ[_0x3cc110(0x405)][_0x3cc110(0x1c0)],_0x42fb8d=this[_0x3cc110(0x13a)](),_0x14d44d={'kills':_0x3cc110(0x2e7),'deaths':_0x3cc110(0x351),'assists':'LearnCountAssists'},_0x4946cd=_0x14d44d[_0x5634a0];for(const _0x1b702c of _0x42fb8d){if(!_0x1b702c)continue;const _0x4460f6=_0x1b702c[_0x3cc110(0x3f3)]||'';if(_0x4460f6[_0x3cc110(0x156)](_0x504b10[_0x4946cd])){if('hVogG'!==_0x3cc110(0x39f))this[_0x3cc110(0x400)](_0x1b702c,_0x3cc110(0x457),_0x5634a0,0x1);else{const _0x119406=_0x4885b7(_0x3e054f['$1']),_0x8a6056=_0x42b819[_0x3cc110(0x22d)](_0x3fc02a,_0x3cc110(0x3dc),'evade'),_0x6a6362=_0x3cc110(0x3c2);_0x2efad7=this[_0x3cc110(0x403)](_0xa25c1c,_0x119406,_0x8a6056,_0x6a6362);}}}},Game_Actor[_0x5b5488(0x286)][_0x5b5488(0x227)]=function(_0x81bbe7,_0x134512){const _0x19196c=_0x5b5488;_0x81bbe7>0x0&&(_0x81bbe7*=this['equipMedalExpRate']()),_0x81bbe7=Math[_0x19196c(0x16b)](_0x81bbe7),this[_0x19196c(0x121)](_0x81bbe7,_0x134512);},Game_Actor[_0x5b5488(0x286)][_0x5b5488(0x292)]=function(){const _0x41133c=_0x5b5488,_0x3f8df3=VisuMZ[_0x41133c(0x405)][_0x41133c(0x1c0)],_0x3c52be=_0x3f8df3['MedalExpRate'];return this['traitObjects']()['reduce']((_0x2456ba,_0x37070f)=>{const _0x563760=_0x41133c;return _0x37070f&&_0x37070f[_0x563760(0x3f3)][_0x563760(0x156)](_0x3c52be)?_0x2456ba*(Number(RegExp['$1'])*0.01):_0x2456ba;},0x1);},Game_Actor[_0x5b5488(0x286)][_0x5b5488(0x121)]=function(_0x3161c5,_0x4565ab){const _0x1b292b=_0x5b5488;if(_0x3161c5<0x0)return;const _0x103b50=this['equippedMedals']();for(const _0x5e3a66 of _0x103b50){if(!_0x5e3a66)continue;this[_0x1b292b(0x34e)](_0x5e3a66,_0x3161c5,_0x4565ab);}},Game_Actor['prototype'][_0x5b5488(0x433)]=function(_0x1e4928){const _0x227ace=_0x5b5488;if(!DataManager[_0x227ace(0x23e)](_0x1e4928))return 0x0;return this['_equipMedalExp']=this['_equipMedalExp']||{},this[_0x227ace(0x10d)][_0x1e4928['id']]=this[_0x227ace(0x10d)][_0x1e4928['id']]||0x0,this[_0x227ace(0x10d)][_0x1e4928['id']];},Game_Actor[_0x5b5488(0x286)]['addEquipMedalExpToMedal']=function(_0x372dcf,_0x890a09,_0x1e8041){const _0xcacae4=_0x5b5488;if(!_0x372dcf)return;if(_0x890a09<0x0)return;if(!DataManager[_0xcacae4(0x23e)](_0x372dcf))return;this[_0xcacae4(0x10d)]=this[_0xcacae4(0x10d)]||{},this[_0xcacae4(0x10d)][_0x372dcf['id']]=this['_equipMedalExp'][_0x372dcf['id']]||0x0,this[_0xcacae4(0x10d)][_0x372dcf['id']]+=_0x890a09;const _0x58cdf9=DataManager[_0xcacae4(0x3ac)](_0x372dcf);if(this[_0xcacae4(0x10d)][_0x372dcf['id']]>=_0x58cdf9){if(_0xcacae4(0x26c)===_0xcacae4(0x26c)){const _0x34946b=this[_0xcacae4(0x10d)][_0x372dcf['id']]-_0x58cdf9,_0x3bd835=DataManager[_0xcacae4(0x337)](_0x372dcf);this[_0xcacae4(0x159)](_0x372dcf),this[_0xcacae4(0x10e)](_0x3bd835,_0x1e8041),this[_0xcacae4(0x1cb)](_0x3bd835)&&this['processEquipMedal'](_0x3bd835),this[_0xcacae4(0x34e)](_0x3bd835,_0x34946b);}else return _0xc46e44;}},VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x410)]=Game_Actor[_0x5b5488(0x286)]['refresh'],Game_Actor[_0x5b5488(0x286)][_0x5b5488(0x3f5)]=function(){const _0x240349=_0x5b5488;VisuMZ[_0x240349(0x405)]['Game_Actor_refresh'][_0x240349(0x116)](this);if(this[_0x240349(0x208)])return;this['unequipHiddenMedals']();},Game_Actor[_0x5b5488(0x286)][_0x5b5488(0x3d4)]=function(){const _0x109c2d=_0x5b5488;this[_0x109c2d(0x208)]=!![];const _0x1346c6=this[_0x109c2d(0x40f)]()[_0x109c2d(0x1d2)](_0x215adc=>VisuMZ[_0x109c2d(0x405)][_0x109c2d(0x200)](this,_0x215adc));for(const _0x572434 of _0x1346c6){this[_0x109c2d(0x159)](_0x572434);}this['_bypassUnequipHiddenMedal']=![];if(_0x1346c6[_0x109c2d(0x257)]>0x0){VisuMZ[_0x109c2d(0x405)]['Game_Actor_refresh'][_0x109c2d(0x116)](this);const _0x2acc17=SceneManager[_0x109c2d(0x160)];if(_0x2acc17&&_0x2acc17['_statusWindow']){if(_0x109c2d(0x194)!==_0x109c2d(0x401))_0x2acc17[_0x109c2d(0x2a9)][_0x109c2d(0x3f5)]();else{_0x10d0a1['match'](_0x18602d[_0x109c2d(0x18e)]);let _0x52c7b2=_0xc2e088(_0x793bb6['$1']);const _0x4bef50=_0x3cc525(_0x4cdf87['$2']),_0x49e257=/^\d+$/[_0x109c2d(0x239)](_0x52c7b2);_0x52c7b2=_0x49e257?_0x3f35f3(_0x52c7b2):_0x74d7f1[_0x109c2d(0x1e1)](_0x52c7b2);if(_0x4bef50>_0x54563b[_0x109c2d(0x22d)](_0x2f5759,'elementDeal',_0x52c7b2))return![];_0xbd42e8=!![];}}}},VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x1cd)]=Game_Party[_0x5b5488(0x286)][_0x5b5488(0x25c)],Game_Party[_0x5b5488(0x286)][_0x5b5488(0x25c)]=function(){const _0x31086f=_0x5b5488;VisuMZ[_0x31086f(0x405)][_0x31086f(0x1cd)][_0x31086f(0x116)](this),this[_0x31086f(0xfa)]();},Game_Party[_0x5b5488(0x286)][_0x5b5488(0xfa)]=function(){const _0x5a5efb=_0x5b5488;this[_0x5a5efb(0x436)]=[],this[_0x5a5efb(0x171)]=[];},Game_Party[_0x5b5488(0x286)][_0x5b5488(0x11c)]=function(){const _0x576f17=_0x5b5488;if(this[_0x576f17(0x436)]===undefined)this[_0x576f17(0xfa)]();return this['_learnedEquippableMedals'];},Game_Party[_0x5b5488(0x286)][_0x5b5488(0x10e)]=function(_0xf7ccb7,_0x57aec1){const _0x61456a=_0x5b5488;if(!DataManager[_0x61456a(0x389)](_0xf7ccb7))return;if(this[_0x61456a(0x436)]===undefined)this['initEquipMedalSystem']();if(this[_0x61456a(0x436)]['includes'](_0xf7ccb7['id']))return;this[_0x61456a(0x436)]['push'](_0xf7ccb7['id']),this[_0x61456a(0x436)][_0x61456a(0x3d1)]((_0xbac130,_0x1b9360)=>_0xbac130-_0x1b9360),this[_0x61456a(0x379)](_0xf7ccb7);if(Game_Actor[_0x61456a(0x107)][_0x61456a(0x138)]&&$gameSystem['isEquipMedalCommandVisible']()){if('wMygh'===_0x61456a(0x130))this[_0x61456a(0x2bf)]=_0x443443,this[_0x61456a(0x3f5)](),this['scrollTo'](0x0,0x0);else for(const _0x1bd20c of this[_0x61456a(0x1a9)]()){if(!_0x1bd20c)continue;_0x1bd20c['refresh'](),_0x1bd20c[_0x61456a(0x1cb)](_0xf7ccb7)&&_0x1bd20c[_0x61456a(0x22a)](_0xf7ccb7);}}if(!_0x57aec1&&TextManager['EQUIP_MEDAL_SYS'][_0x61456a(0x161)]){const _0x21bf7e=TextManager['EQUIP_MEDAL_SYS'][_0x61456a(0x448)],_0x3356a7=DataManager[_0x61456a(0x256)](_0xf7ccb7),_0x3e8d4b='\x5cI[%1]'[_0x61456a(0x24a)](DataManager[_0x61456a(0x2cb)](_0xf7ccb7)),_0x4fb246=_0x21bf7e[_0x61456a(0x24a)](this[_0x61456a(0x24b)](),_0x3356a7,_0x3e8d4b);$textPopup(_0x4fb246);}},Game_Party[_0x5b5488(0x286)][_0x5b5488(0x379)]=function(_0x576814){const _0x3183d7=_0x5b5488,_0x10b223=VisuMZ[_0x3183d7(0x405)][_0x3183d7(0x1c0)],_0x409058=_0x576814['note']||'';if(_0x409058[_0x3183d7(0x156)](_0x10b223[_0x3183d7(0x454)])){if('Azurl'!=='FVunD'){const _0x2819a2=String(RegExp['$1'])[_0x3183d7(0x281)](',')[_0x3183d7(0x32c)](_0x46630c=>_0x46630c[_0x3183d7(0x374)]());for(const _0x278825 of _0x2819a2){if(_0x3183d7(0x2e3)===_0x3183d7(0x2e3)){const _0x5e1299=/^\d+$/[_0x3183d7(0x239)](_0x278825);let _0x1adce8=0x0;if(_0x5e1299)_0x1adce8=Number(_0x278825);else{if('OtwvP'!==_0x3183d7(0x395))_0x1adce8=DataManager[_0x3183d7(0x182)](_0x278825);else{const _0xf5ba13=_0x568219(_0x1b3c7a['$1'])[_0x3183d7(0x281)](',')[_0x3183d7(0x32c)](_0x5c220b=>_0x4dc5ac[_0x3183d7(0x182)](_0x5c220b));if(_0xf5ba13[_0x3183d7(0x276)](_0x2f2474=>_0x213146[_0x3183d7(0x15a)](_0x204f93[_0x2f2474])))return!![];}}_0x1adce8>0x0&&this[_0x3183d7(0x173)]($dataArmors[_0x1adce8]);}else{const _0x2f869b=_0x443e2e[_0x3183d7(0x156)](_0x17dc8e[_0x3183d7(0x32e)]);if(_0x2f869b)for(const _0x30627d of _0x2f869b){_0x30627d[_0x3183d7(0x156)](_0x5f4f29['LearnSTypeUsage']);let _0x2430ad=_0xd434b0(_0x5b327a['$1']);const _0x9d742d=_0x317300(_0x17131c['$2']),_0x54f4fb=/^\d+$/['test'](_0x2430ad);_0x2430ad=_0x54f4fb?_0x5ea259(_0x2430ad):_0x129f0e[_0x3183d7(0x143)](_0x2430ad);const _0xf32712=_0x1c02ef[_0x3183d7(0x22d)](_0x171582,'stype',_0x2430ad),_0x5430ea=_0x3183d7(0x435),_0x312366=_0x200f63['skillTypes'][_0x2430ad];_0xf5798f=this[_0x3183d7(0x403)](_0x4d1513,_0x9d742d,_0xf32712,_0x5430ea,_0x312366);}}}}else _0x84adfa['_subject'][_0x3183d7(0x170)](_0x554f99,!![]);}},Game_Party[_0x5b5488(0x286)][_0x5b5488(0x15a)]=function(_0x19ad94){const _0x525a00=_0x5b5488;if(!DataManager['isArmor'](_0x19ad94))return;if(this[_0x525a00(0x436)]===undefined)this[_0x525a00(0xfa)]();return this[_0x525a00(0x436)][_0x525a00(0x2c4)](_0x19ad94['id']);},Game_Party[_0x5b5488(0x286)][_0x5b5488(0x1cf)]=function(_0x3dfefb){const _0xbc69a2=_0x5b5488;if(!DataManager[_0xbc69a2(0x389)](_0x3dfefb))return;if(this[_0xbc69a2(0x436)]===undefined)this[_0xbc69a2(0xfa)]();this[_0xbc69a2(0x436)][_0xbc69a2(0x2df)](_0x3dfefb['id']),this['_learnedEquippableMedals'][_0xbc69a2(0x3d1)]((_0x4f1421,_0x14361b)=>_0x4f1421-_0x14361b);for(const _0x41df1e of this[_0xbc69a2(0x1a9)]()){if(!_0x41df1e)continue;_0x41df1e[_0xbc69a2(0x1cf)](_0x3dfefb);}},Game_Party[_0x5b5488(0x286)][_0x5b5488(0x2e1)]=function(){const _0x1f21ac=_0x5b5488;if(this[_0x1f21ac(0x171)]===undefined)this[_0x1f21ac(0xfa)]();return this[_0x1f21ac(0x171)];},Game_Party[_0x5b5488(0x286)][_0x5b5488(0x173)]=function(_0x241425){const _0x1bc80d=_0x5b5488;if(!DataManager[_0x1bc80d(0x389)](_0x241425))return;if(this[_0x1bc80d(0x171)]===undefined)this[_0x1bc80d(0xfa)]();if(this[_0x1bc80d(0x171)][_0x1bc80d(0x2c4)](_0x241425['id']))return;this[_0x1bc80d(0x171)][_0x1bc80d(0x2df)](_0x241425['id']),this['_learnableEquippableMedals'][_0x1bc80d(0x3d1)]((_0x2b16a4,_0x52cc78)=>_0x2b16a4-_0x52cc78);},Game_Party[_0x5b5488(0x286)][_0x5b5488(0x172)]=function(_0x14fd42){const _0x50d8f8=_0x5b5488;if(!DataManager['isArmor'](_0x14fd42))return;if(this[_0x50d8f8(0x171)]===undefined)this[_0x50d8f8(0xfa)]();this[_0x50d8f8(0x171)][_0x50d8f8(0x30f)](_0x14fd42['id']),this['_learnableEquippableMedals'][_0x50d8f8(0x3d1)]((_0x888145,_0x32e4a1)=>_0x888145-_0x32e4a1);for(const _0x103945 of this[_0x50d8f8(0x1a9)]()){if(!_0x103945)continue;_0x103945[_0x50d8f8(0x172)](_0x14fd42);}},VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x3ad)]=Game_Party[_0x5b5488(0x286)][_0x5b5488(0x431)],Game_Party[_0x5b5488(0x286)][_0x5b5488(0x431)]=function(_0x35a465,_0x360252,_0x23b60d){const _0x31dcea=_0x5b5488;VisuMZ['EquipMedalSys']['Game_Party_gainItem'][_0x31dcea(0x116)](this,_0x35a465,_0x360252,_0x23b60d);if(!_0x35a465)return;if(_0x360252<=0x0)return;VisuMZ[_0x31dcea(0x405)][_0x31dcea(0x12a)](_0x35a465);},VisuMZ['EquipMedalSys'][_0x5b5488(0x12a)]=function(_0xfa0d7b){const _0x4a4421=_0x5b5488;if(!_0xfa0d7b)return;const _0xd9994e=VisuMZ[_0x4a4421(0x405)][_0x4a4421(0x1c0)],_0x160249=_0xfa0d7b[_0x4a4421(0x3f3)]||'';if(_0x160249[_0x4a4421(0x156)](_0xd9994e['ItemLinkLearned'])){const _0x5064b0=String(RegExp['$1'])[_0x4a4421(0x281)](',')[_0x4a4421(0x32c)](_0x1d6373=>_0x1d6373[_0x4a4421(0x374)]());for(const _0x37b970 of _0x5064b0){const _0x334faf=/^\d+$/[_0x4a4421(0x239)](_0x37b970);let _0x4743f6=0x0;if(_0x334faf){if(_0x4a4421(0x309)==='wxAQw')_0x4743f6=Number(_0x37b970);else{const _0x260c05=_0x2410bb(_0x8078cc['$1']),_0x42c22a=_0x3662c2[_0x4a4421(0x22d)](_0x11846e,'hp',_0x4a4421(0x377)),_0x19e85e=_0x4a4421(0x3b8);_0x4b7bb9=this[_0x4a4421(0x403)](_0x3f4f3d,_0x260c05,_0x42c22a,_0x19e85e);}}else _0x4743f6=DataManager[_0x4a4421(0x182)](_0x37b970);if(_0x4743f6>0x0){if(_0x4a4421(0x3f1)!=='KlbNE')_0x3b5a9c=_0x8916ae(_0x142393);else{const _0x167779=$dataArmors[_0x4743f6];$gameParty[_0x4a4421(0x10e)](_0x167779);}}}}if(_0x160249[_0x4a4421(0x156)](_0xd9994e['ItemLinkLearnable'])){const _0x80b6d8=String(RegExp['$1'])['split'](',')[_0x4a4421(0x32c)](_0x2629cc=>_0x2629cc['trim']());for(const _0x2d4cea of _0x80b6d8){const _0x149da7=/^\d+$/['test'](_0x2d4cea);let _0x1aae77=0x0;if(_0x149da7){if(_0x4a4421(0x289)===_0x4a4421(0x2c3)){if(!_0x13078a['isArmor'](_0x17a504))return![];if(this[_0x4a4421(0x299)]===_0x3cdddd)this[_0x4a4421(0xfa)]();if(this[_0x4a4421(0x299)][_0x4a4421(0x2c4)](_0x3debaa['id']))return;let _0x25cee0=null;!this[_0x4a4421(0x201)]&&(_0x25cee0=_0x16f14e[_0x4a4421(0x40c)](this),_0x25cee0[_0x4a4421(0x201)]=!![]),this[_0x4a4421(0x299)][_0x4a4421(0x2df)](_0x5e1703['id']),this[_0x4a4421(0x140)]={},this[_0x4a4421(0x3f5)](),!this[_0x4a4421(0x201)]&&this['equipAdjustHpMp'](_0x25cee0);}else _0x1aae77=Number(_0x2d4cea);}else _0x1aae77=DataManager[_0x4a4421(0x182)](_0x2d4cea);if(_0x1aae77>0x0){const _0x411359=$dataArmors[_0x1aae77];$gameParty[_0x4a4421(0x173)](_0x411359);}}}},Game_Troop['EQUIP_MEDAL_SYS']={'expFormula':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)][_0x5b5488(0x3bd)][_0x5b5488(0x184)]??'1','showRewards':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)][_0x5b5488(0x3bd)][_0x5b5488(0x357)]??!![],'rewardAliveActors':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)][_0x5b5488(0x3bd)]['AliveActors']??!![]},Game_Troop[_0x5b5488(0x286)][_0x5b5488(0x323)]=function(){const _0x2a166c=_0x5b5488;return this[_0x2a166c(0x175)]()['reduce']((_0x3cfaf0,_0x4dcbf0)=>_0x3cfaf0+_0x4dcbf0['equipMedalExp'](),0x0);},Game_Enemy[_0x5b5488(0x286)][_0x5b5488(0x267)]=function(){const _0x596987=_0x5b5488,_0x5e4df2=VisuMZ[_0x596987(0x405)]['RegExp'],_0x11d472=this['enemy']()[_0x596987(0x3f3)];let _0x48e6cd=0x0;window[_0x596987(0x1f9)]=this,window[_0x596987(0x1bc)]=this[_0x596987(0x1bc)]||0x0;if(_0x11d472[_0x596987(0x156)](_0x5e4df2[_0x596987(0x34a)]))try{_0x48e6cd=eval(RegExp['$1']);}catch(_0x2f23f7){if($gameTemp['isPlaytest']())console[_0x596987(0x214)](_0x2f23f7);_0x48e6cd=0x0;}else{if(_0x596987(0x1b0)!==_0x596987(0x132))try{_0x48e6cd=eval(Game_Troop[_0x596987(0x107)][_0x596987(0x16f)]);}catch(_0x122eed){if($gameTemp[_0x596987(0x2c0)]())console['log'](_0x122eed);_0x48e6cd=0x0;}else{const _0x11b79b=_0x28a474(_0x2d1ff0['$1']),_0x440cb3=_0x15a0dc[_0x596987(0x22d)](_0x12d7a9,_0x596987(0x3dc),_0x596987(0x361)),_0x24121c=_0x596987(0x361);_0x2e506d=this[_0x596987(0x403)](_0x1e4617,_0x11b79b,_0x440cb3,_0x24121c);}}return window[_0x596987(0x1f9)]=undefined,window['level']=undefined,_0x48e6cd;},VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x43e)]=Scene_Equip[_0x5b5488(0x286)][_0x5b5488(0x41f)],Scene_Equip['prototype'][_0x5b5488(0x41f)]=function(){const _0x37cbd4=_0x5b5488;VisuMZ[_0x37cbd4(0x405)][_0x37cbd4(0x43e)]['call'](this),this[_0x37cbd4(0x20d)](),this[_0x37cbd4(0x35e)]();},VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x3ed)]=Scene_Equip[_0x5b5488(0x286)][_0x5b5488(0x372)],Scene_Equip['prototype'][_0x5b5488(0x372)]=function(){const _0x2240ab=_0x5b5488;VisuMZ[_0x2240ab(0x405)][_0x2240ab(0x3ed)][_0x2240ab(0x116)](this),this['_commandWindow'][_0x2240ab(0x43c)](_0x2240ab(0x40a),this[_0x2240ab(0x10c)][_0x2240ab(0x263)](this));},VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x331)]=Scene_Equip[_0x5b5488(0x286)][_0x5b5488(0x1d4)],Scene_Equip[_0x5b5488(0x286)][_0x5b5488(0x1d4)]=function(){const _0x30e36f=_0x5b5488;if($gameSystem['isEquipMedalCommandVisible']())return!![];return VisuMZ[_0x30e36f(0x405)][_0x30e36f(0x331)][_0x30e36f(0x116)](this);},Scene_Equip[_0x5b5488(0x286)]['createEquipMedalWindow']=function(){const _0x3165f8=_0x5b5488,_0x165590=this['equipMedalWindowRect']();this[_0x3165f8(0x42e)]=new Window_EquipMedalList(_0x165590),this[_0x3165f8(0x42e)][_0x3165f8(0x1a5)](this['_helpWindow']),this['_equipMedalWindow'][_0x3165f8(0x43c)]('ok',this['onEquipMedalOk'][_0x3165f8(0x263)](this)),this[_0x3165f8(0x42e)][_0x3165f8(0x43c)](_0x3165f8(0x2bd),this[_0x3165f8(0x206)][_0x3165f8(0x263)](this)),this['addWindow'](this['_equipMedalWindow']);const _0x19d87c=Window_EquipMedalList[_0x3165f8(0x417)][_0x3165f8(0x1f5)];this['_equipMedalWindow'][_0x3165f8(0x17e)](_0x19d87c||0x0),this['_equipMedalWindow'][_0x3165f8(0x12c)](this[_0x3165f8(0x2a9)]);},Scene_Equip['prototype'][_0x5b5488(0x125)]=function(){const _0x324757=_0x5b5488,_0x8e2d89=this[_0x324757(0x3c1)](),_0x317c7c=_0x8e2d89['x'],_0xc71718=_0x8e2d89['y'],_0x170e9a=_0x8e2d89[_0x324757(0x1a2)];let _0x228414=_0x8e2d89['height'];if(Window_EquipMedalStatus['SETTINGS'][_0x324757(0x28e)]){if('uGOZH'!==_0x324757(0x278))_0x228414-=this[_0x324757(0x424)](0x1,![]);else{const _0x37e9c4=_0x2fbfaa[_0x324757(0x405)]['RegExp'],_0x2cb523=_0x2db6ec[_0x324757(0x3f3)]||'';if(_0x2cb523['match'](_0x37e9c4['MedalGaugeColor1']))return _0x47fd25(_0x246380['$1']);return _0x2dee65['SETTINGS'][_0x324757(0x2db)];}}return new Rectangle(_0x317c7c,_0xc71718,_0x170e9a,_0x228414);},Scene_Equip[_0x5b5488(0x286)][_0x5b5488(0x35e)]=function(){const _0x55b670=_0x5b5488;if(!Window_EquipMedalStatus[_0x55b670(0x417)][_0x55b670(0x28e)])return;const _0x39bb67=this[_0x55b670(0x17b)]();this[_0x55b670(0x339)]=new Window_EquipMedalStatus(_0x39bb67),this[_0x55b670(0x339)][_0x55b670(0x366)](this['actor']()),this['addWindow'](this[_0x55b670(0x339)]);const _0x37fb80=Window_EquipMedalStatus['SETTINGS']['bgType'];this[_0x55b670(0x339)][_0x55b670(0x17e)](_0x37fb80||0x0);},Scene_Equip[_0x5b5488(0x286)][_0x5b5488(0x17b)]=function(){const _0x44eab0=_0x5b5488,_0x2aeeef=this['equipMedalWindowRect'](),_0x1fc219=_0x2aeeef['x'],_0x25501c=_0x2aeeef['y']+_0x2aeeef['height'],_0x3e34a2=_0x2aeeef['width'],_0x4fec39=this[_0x44eab0(0x424)](0x1,![]);return new Rectangle(_0x1fc219,_0x25501c,_0x3e34a2,_0x4fec39);},VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x1e3)]=Scene_Equip[_0x5b5488(0x286)][_0x5b5488(0x28d)],Scene_Equip[_0x5b5488(0x286)]['refreshActor']=function(){const _0x4f7f49=_0x5b5488;VisuMZ[_0x4f7f49(0x405)][_0x4f7f49(0x1e3)]['call'](this),this[_0x4f7f49(0x33f)]()[_0x4f7f49(0x222)](),this[_0x4f7f49(0x42e)]&&(this['_equipMedalWindow']['setActor'](this[_0x4f7f49(0x33f)]()),this['_equipMedalWindow'][_0x4f7f49(0x3f5)]()),this['_medalStatusWindow']&&(this[_0x4f7f49(0x339)][_0x4f7f49(0x366)](this['actor']()),this[_0x4f7f49(0x339)]['refresh']());},VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x2c7)]=Scene_Equip[_0x5b5488(0x286)][_0x5b5488(0x14a)],Scene_Equip[_0x5b5488(0x286)]['arePageButtonsEnabled']=function(){const _0x58eba4=_0x5b5488;if(this[_0x58eba4(0x42e)]&&this[_0x58eba4(0x42e)]['active'])return![];return VisuMZ[_0x58eba4(0x405)][_0x58eba4(0x2c7)]['call'](this);},VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x409)]=Scene_Equip[_0x5b5488(0x286)]['onActorChange'],Scene_Equip['prototype']['onActorChange']=function(){const _0x3d0366=_0x5b5488;VisuMZ[_0x3d0366(0x405)][_0x3d0366(0x409)]['call'](this),this[_0x3d0366(0x31f)]&&this[_0x3d0366(0x31f)]['currentSymbol']()===_0x3d0366(0x40a)&&(this[_0x3d0366(0x16e)]['hide'](),this[_0x3d0366(0x16e)][_0x3d0366(0x414)]());},VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x342)]=Scene_Equip['prototype'][_0x5b5488(0x34f)],Scene_Equip[_0x5b5488(0x286)]['commandEquip']=function(){const _0x5a21d2=_0x5b5488;VisuMZ[_0x5a21d2(0x405)]['Scene_Equip_commandEquip'][_0x5a21d2(0x116)](this),this[_0x5a21d2(0x42e)]&&(this[_0x5a21d2(0x42e)][_0x5a21d2(0x414)](),this['_equipMedalWindow'][_0x5a21d2(0x2ac)]());},Scene_Equip[_0x5b5488(0x286)][_0x5b5488(0x10c)]=function(){const _0x1bf0ad=_0x5b5488;this[_0x1bf0ad(0x31f)][_0x1bf0ad(0x44e)](_0x1bf0ad(0x40a)),this['_equipMedalWindow']['activate'](),this['_equipMedalWindow'][_0x1bf0ad(0x188)](),this['_equipMedalWindow']['show'](),this[_0x1bf0ad(0x16e)][_0x1bf0ad(0x414)](),this['_slotWindow'][_0x1bf0ad(0x2ac)]();},Scene_Equip[_0x5b5488(0x286)][_0x5b5488(0x2cc)]=function(){const _0x20d806=_0x5b5488,_0x5ecda0=this[_0x20d806(0x42e)][_0x20d806(0x3a0)]();this['_actor'][_0x20d806(0x41d)](_0x5ecda0)?this[_0x20d806(0x2bf)][_0x20d806(0x159)](_0x5ecda0):this[_0x20d806(0x2bf)][_0x20d806(0x22a)](_0x5ecda0);this[_0x20d806(0x2a9)][_0x20d806(0x3f5)](),this[_0x20d806(0x16e)]['refresh'](),this[_0x20d806(0x42e)][_0x20d806(0x3f5)](),this['_equipMedalWindow'][_0x20d806(0x2a5)]();if(this['_medalStatusWindow'])this[_0x20d806(0x339)]['refresh']();},Scene_Equip[_0x5b5488(0x286)][_0x5b5488(0x206)]=function(){const _0x17dccc=_0x5b5488;this[_0x17dccc(0x42e)][_0x17dccc(0x17c)](),this[_0x17dccc(0x42e)][_0x17dccc(0x414)](),this[_0x17dccc(0x31f)][_0x17dccc(0x2a5)](),this[_0x17dccc(0x31f)][_0x17dccc(0x44e)](_0x17dccc(0x40a)),this[_0x17dccc(0x2a9)][_0x17dccc(0xfb)](null);},Window_Base[_0x5b5488(0x286)][_0x5b5488(0x356)]=function(_0x196537,_0x599c74,_0x4047f9,_0x1cf3ff,_0x51718a){const _0xd4b941=_0x5b5488;if(!_0x196537)return;const _0x4ed537=_0x4047f9+(this['lineHeight']()-ImageManager[_0xd4b941(0x13e)])/0x2,_0xa98f0=ImageManager[_0xd4b941(0x240)]+0x4,_0x43b8f6=Math[_0xd4b941(0x2cd)](0x0,_0x1cf3ff-_0xa98f0);this[_0xd4b941(0x148)](),_0x51718a&&_0x51718a[_0xd4b941(0x40f)]()['includes'](_0x196537)&&(_0xd4b941(0x11a)==='rVpCs'?this[_0xd4b941(0x375)](ColorManager[_0xd4b941(0x1bb)]()):_0x58c20c=_0x5d10e9(_0x149554)),this[_0xd4b941(0x18b)](DataManager[_0xd4b941(0x2cb)](_0x196537),_0x599c74,_0x4ed537),this[_0xd4b941(0x3a6)](DataManager[_0xd4b941(0x256)](_0x196537),_0x599c74+_0xa98f0,_0x4047f9,_0x43b8f6);},Window_Base['prototype'][_0x5b5488(0x419)]=function(_0xd7a439,_0x2de582,_0x5650e3,_0x1b4ed8){const _0x41c07a=_0x5b5488;if(!_0xd7a439)return;const _0x324a99=Window_EquipMedalList['SETTINGS'];if(!_0x324a99['showCostAny'])return;const _0xc5a8f9=DataManager[_0x41c07a(0x42b)](_0xd7a439);if(_0xc5a8f9===0x1&&!_0x324a99[_0x41c07a(0x1d8)])return;if(_0xc5a8f9<0x1&&!_0x324a99[_0x41c07a(0x399)])return;this[_0x41c07a(0x1ae)]();const _0x5b6a85='\x5cI[%1]'[_0x41c07a(0x24a)](ImageManager['EQUIP_MEDAL_SYS'][_0x41c07a(0x2eb)]);let _0x52337e='';if(_0x324a99[_0x41c07a(0x12f)]||_0xc5a8f9>_0x324a99[_0x41c07a(0x306)])_0x52337e=TextManager[_0x41c07a(0x107)][_0x41c07a(0x14e)][_0x41c07a(0x24a)](_0xc5a8f9,_0x5b6a85);else{if(_0x41c07a(0x349)===_0x41c07a(0x17a))for(const _0x51dc87 of _0xb4e72b){_0x51dc87[_0x41c07a(0x156)](_0x2595dd['LearnElementDeal']);let _0x102171=_0x22ba12(_0x281f3c['$1']);const _0x3f098d=_0x42f005(_0x4fe2f0['$2']),_0x99d6fe=/^\d+$/[_0x41c07a(0x239)](_0x102171);_0x102171=_0x99d6fe?_0x1d88bc(_0x102171):_0x52c7e6['getElementIdWithName'](_0x102171);if(_0x3f098d>_0x3e5ca2['getEquipMedalLearnProgress'](_0x5558c3,_0x41c07a(0x39c),_0x102171))return![];_0x4a6124=!![];}else{let _0x2b88b4=_0xc5a8f9;while(_0x2b88b4--)_0x52337e+=_0x5b6a85;}}const _0x17506d=this['textSizeEx'](_0x52337e)[_0x41c07a(0x1a2)],_0x1d368c=_0x2de582+_0x1b4ed8-_0x17506d;this[_0x41c07a(0x368)](_0x52337e,_0x1d368c,_0x5650e3);},Window_Base[_0x5b5488(0x286)][_0x5b5488(0x359)]=function(_0x289339,_0x51f61c,_0x2269f4,_0x1fbd95){const _0x528668=_0x5b5488;if(!_0x289339)return;const _0x3159fc=_0x2269f4+(this[_0x528668(0x1c1)]()-ImageManager['iconHeight'])/0x2,_0x36e2bd=ImageManager['iconWidth']+0x4,_0x424de5=Math[_0x528668(0x2cd)](0x0,_0x1fbd95-_0x36e2bd);this[_0x528668(0x148)]();const _0x1e613e=Window_EquipMedalList[_0x528668(0x417)][_0x528668(0x162)];this[_0x528668(0x18b)](_0x1e613e,_0x51f61c,_0x3159fc);const _0xca3ce1=VisuMZ[_0x528668(0x405)][_0x528668(0x3fa)](_0x289339);this[_0x528668(0x32b)][_0x528668(0x420)]=Window_EquipMedalList['SETTINGS'][_0x528668(0x204)],this[_0x528668(0x3a6)](_0xca3ce1,_0x51f61c+_0x36e2bd,_0x2269f4,_0x424de5),this['contents'][_0x528668(0x420)]=![];},VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x3fa)]=function(_0x5d0c52){const _0x55e5cf=_0x5b5488,_0x5c0c87=VisuMZ['EquipMedalSys'][_0x55e5cf(0x1c0)],_0x8db24c=_0x5d0c52[_0x55e5cf(0x3f3)]||'';if(_0x8db24c[_0x55e5cf(0x156)](_0x5c0c87[_0x55e5cf(0x3fa)])){if('jnFhH'===_0x55e5cf(0x2ef)){if(!this[_0x55e5cf(0x389)](_0x49be98))return 0x0;this[_0x55e5cf(0x33d)]=this[_0x55e5cf(0x33d)]||{};if(this['_getEquipMedalName'][_0x1a0834['id']]!==_0x25fe72)return this[_0x55e5cf(0x33d)][_0x406d2c['id']];let _0x3fa277=_0x504314[_0x55e5cf(0x24b)]||'';const _0x3ec046=_0x92678c[_0x55e5cf(0x405)][_0x55e5cf(0x1c0)],_0x1b906b=_0x45fef0[_0x55e5cf(0x3f3)]||'';return _0x1b906b[_0x55e5cf(0x156)](_0x3ec046[_0x55e5cf(0x2fc)])&&(_0x3fa277=_0x4c9a87(_0x2b70cb['$1'])[_0x55e5cf(0x374)]()),this[_0x55e5cf(0x33d)][_0x1cc60c['id']]=_0x3fa277,this[_0x55e5cf(0x33d)][_0x454b7e['id']];}else return String(RegExp['$1'])[_0x55e5cf(0x374)]();}const _0x42fb8f=Window_EquipMedalList['SETTINGS'][_0x55e5cf(0x20f)];return Array(_0x5d0c52[_0x55e5cf(0x24b)][_0x55e5cf(0x257)]+0x1)[_0x55e5cf(0x1de)](_0x42fb8f);},Window_Base[_0x5b5488(0x286)][_0x5b5488(0x3f0)]=function(_0x2568b0,_0x38a1ce,_0x4a9fee,_0x5ecdde,_0x2aa57d){const _0xa8765b=_0x5b5488,_0x5a0332=Window_EquipMedalList[_0xa8765b(0x417)],_0x15f962=TextManager[_0xa8765b(0x107)],_0x12b6f6=ColorManager[_0xa8765b(0x21b)](VisuMZ[_0xa8765b(0x405)][_0xa8765b(0x384)](_0x2568b0)),_0x50eb87=ColorManager['getColor'](VisuMZ[_0xa8765b(0x405)]['GetExpGaugeColor2'](_0x2568b0)),_0x551229=_0x5a0332['expGaugeStyleType'];_0x5ecdde+=_0x5a0332['expGaugeWidthModifier'];const _0x389f93=_0x2aa57d[_0xa8765b(0x433)](_0x2568b0),_0x1a223a=DataManager[_0xa8765b(0x3ac)](_0x2568b0);let _0x2dbcef=(_0x389f93/_0x1a223a)[_0xa8765b(0x373)](0x0,0x1);if(VisuMZ[_0xa8765b(0x405)][_0xa8765b(0x1ca)](_0x2568b0))_0x2dbcef=0x1;if(Imported['VisuMZ_3_VisualGaugeStyles']){const _0x14f7b9=(VisuMZ[_0xa8765b(0x30b)][_0xa8765b(0x24f)](_0x551229)??0xc)[_0xa8765b(0x373)](0x1,0x20),_0x50ac89=_0x4a9fee+this[_0xa8765b(0x1c1)]()-_0x14f7b9-0x2,_0x3c4298=ColorManager[_0xa8765b(0x10a)]();VisuMZ[_0xa8765b(0x30b)]['_maxValueSegment']=_0x1a223a,this[_0xa8765b(0x32b)][_0xa8765b(0x23c)](_0x551229,_0x38a1ce,_0x50ac89,_0x5ecdde,_0x14f7b9,_0x2dbcef,_0x3c4298,_0x12b6f6,_0x50eb87);}else{if(_0xa8765b(0x3c3)===_0xa8765b(0x36a))return![];else this[_0xa8765b(0x27c)](_0x38a1ce,_0x4a9fee,_0x5ecdde,_0x2dbcef,_0x12b6f6,_0x50eb87);}this[_0xa8765b(0x1ae)]();const _0x51f1e3=(_0x2dbcef*0x64)[_0xa8765b(0x1c4)](_0x15f962[_0xa8765b(0x3f2)]),_0x402c31=_0x15f962[_0xa8765b(0x2d9)];let _0x51970d=_0x402c31[_0xa8765b(0x24a)](_0x389f93,_0x1a223a,_0x51f1e3);if(_0x2dbcef>=0x1)_0x51970d=_0x15f962[_0xa8765b(0x21a)];const _0x2103d2=this[_0xa8765b(0x119)](_0x51970d)[_0xa8765b(0x1a2)],_0x54c4e3=_0x38a1ce+_0x5ecdde-_0x2103d2+_0x5a0332[_0xa8765b(0x216)],_0x100ff6=_0x4a9fee+_0x5a0332[_0xa8765b(0x2e6)];this['drawTextEx'](_0x51970d,_0x54c4e3,_0x100ff6);},VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x384)]=function(_0x593d9f){const _0x50a19c=_0x5b5488,_0x579718=VisuMZ['EquipMedalSys'][_0x50a19c(0x1c0)],_0x505c80=_0x593d9f[_0x50a19c(0x3f3)]||'';if(_0x505c80[_0x50a19c(0x156)](_0x579718['MedalGaugeColor1']))return String(RegExp['$1']);return Window_EquipMedalList[_0x50a19c(0x417)][_0x50a19c(0x2db)];},VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x362)]=function(_0x39a940){const _0x12a444=_0x5b5488,_0x233f2f=VisuMZ[_0x12a444(0x405)][_0x12a444(0x1c0)],_0x761831=_0x39a940['note']||'';if(_0x761831[_0x12a444(0x156)](_0x233f2f[_0x12a444(0x30c)]))return String(RegExp['$1']);return Window_EquipMedalList[_0x12a444(0x417)][_0x12a444(0x30e)];},Window_EquipCommand[_0x5b5488(0x107)]={'defaultShowEquipMedal':VisuMZ['EquipMedalSys'][_0x5b5488(0x11f)][_0x5b5488(0x3bd)][_0x5b5488(0x36d)]??!![]},VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x1eb)]=Window_EquipCommand[_0x5b5488(0x286)]['makeCommandList'],Window_EquipCommand[_0x5b5488(0x286)][_0x5b5488(0x1d5)]=function(){const _0x12f5d2=_0x5b5488;VisuMZ[_0x12f5d2(0x405)][_0x12f5d2(0x1eb)]['call'](this),this[_0x12f5d2(0x266)]();},VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x134)]=Window_EquipCommand['prototype'][_0x5b5488(0x3ce)],Window_EquipCommand[_0x5b5488(0x286)][_0x5b5488(0x3ce)]=function(){const _0x4ce0f=_0x5b5488;if(!this[_0x4ce0f(0x1b2)]()&&!this[_0x4ce0f(0x269)]()&&this[_0x4ce0f(0x1df)]()){if(_0x4ce0f(0x3ca)!==_0x4ce0f(0x3ca))_0x227b47=this[_0x4ce0f(0x1aa)](_0x273eb7);else return![];}return VisuMZ[_0x4ce0f(0x405)][_0x4ce0f(0x134)][_0x4ce0f(0x116)](this);},VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x19a)]=Window_EquipCommand['prototype'][_0x5b5488(0x1b5)],Window_EquipCommand[_0x5b5488(0x286)]['isEquipCommandAdded']=function(){const _0x446a3d=_0x5b5488;if(!this[_0x446a3d(0x1b2)]()&&!this[_0x446a3d(0x269)]()&&this[_0x446a3d(0x1df)]()){if('JIdGJ'!=='JIdGJ')_0x5d0522[_0x446a3d(0x2a9)][_0x446a3d(0x3f5)]();else return!![];}return VisuMZ[_0x446a3d(0x405)][_0x446a3d(0x19a)][_0x446a3d(0x116)](this);},Window_EquipCommand[_0x5b5488(0x286)][_0x5b5488(0x266)]=function(){const _0x58902f=_0x5b5488;if(!this[_0x58902f(0x1df)]())return;let _0x2da3bb=TextManager['EQUIP_MEDAL_SYS'][_0x58902f(0x272)];if(this[_0x58902f(0x35b)]()!==_0x58902f(0x334)){const _0x2d0c74=ImageManager[_0x58902f(0x107)][_0x58902f(0x3a9)];_0x2da3bb=_0x58902f(0x124)[_0x58902f(0x24a)](_0x2d0c74,_0x2da3bb);}this[_0x58902f(0x2b1)](_0x2da3bb,_0x58902f(0x40a));},Window_EquipCommand[_0x5b5488(0x286)]['isEquipMedalCommandVisible']=function(){const _0xe2ceb7=_0x5b5488;return $gameSystem[_0xe2ceb7(0x1df)]();},VisuMZ[_0x5b5488(0x405)]['Window_EquipCommand_callUpdateHelp']=Window_EquipCommand['prototype'][_0x5b5488(0x35c)],Window_EquipCommand['prototype'][_0x5b5488(0x35c)]=function(){const _0x5d6f17=_0x5b5488;VisuMZ[_0x5d6f17(0x405)][_0x5d6f17(0x27f)][_0x5d6f17(0x116)](this),this[_0x5d6f17(0x246)]();},Window_EquipCommand[_0x5b5488(0x286)][_0x5b5488(0x246)]=function(){const _0xcaf7ce=_0x5b5488,_0x414716=this[_0xcaf7ce(0x215)]!==this[_0xcaf7ce(0x131)]();if(!_0x414716)return;const _0x4890d5=SceneManager[_0xcaf7ce(0x160)][_0xcaf7ce(0x42e)];if(_0x4890d5)_0x4890d5[_0xcaf7ce(0x2ac)]();const _0xa04991=SceneManager[_0xcaf7ce(0x160)][_0xcaf7ce(0x339)];if(_0xa04991)_0xa04991[_0xcaf7ce(0x2ac)]();const _0x50af7d=SceneManager['_scene'][_0xcaf7ce(0x16e)];if(_0x50af7d)_0x50af7d[_0xcaf7ce(0x21e)]();this[_0xcaf7ce(0x215)]=this[_0xcaf7ce(0x131)]();if(_0x414716&&_0x4890d5&&this[_0xcaf7ce(0x131)]()===_0xcaf7ce(0x40a)){if(_0x50af7d){if(_0xcaf7ce(0x3d6)!==_0xcaf7ce(0x3d6)){_0x4e2d29[_0xcaf7ce(0x405)][_0xcaf7ce(0x3ad)][_0xcaf7ce(0x116)](this,_0x42f301,_0x3ba8f1,_0x45f372);if(!_0x29412f)return;if(_0x257c71<=0x0)return;_0x140dea[_0xcaf7ce(0x405)][_0xcaf7ce(0x12a)](_0x4a6dc3);}else _0x50af7d[_0xcaf7ce(0x414)](),_0x50af7d[_0xcaf7ce(0x17c)](),_0x50af7d[_0xcaf7ce(0x2ac)]();}if(this[_0xcaf7ce(0x2bf)])this[_0xcaf7ce(0x2bf)]['checkLearnNewEquipMedals']();_0x4890d5[_0xcaf7ce(0x3f5)](),_0x4890d5[_0xcaf7ce(0x21e)]();if(_0xa04991){if(_0xcaf7ce(0x22f)==='VYlkz'){_0x324072+=_0x4cd18d[_0xcaf7ce(0x440)];if(_0x72fdeb[_0xcaf7ce(0x41e)])_0xf40930+='\x20';}else _0xa04991[_0xcaf7ce(0x3f5)](),_0xa04991['show']();}}else _0x4890d5&&(_0x4890d5[_0xcaf7ce(0x414)](),_0x4890d5[_0xcaf7ce(0x17c)]());},VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x137)]=Window_EquipCommand[_0x5b5488(0x286)][_0x5b5488(0x43a)],Window_EquipCommand[_0x5b5488(0x286)][_0x5b5488(0x43a)]=function(){const _0x45348e=_0x5b5488;this[_0x45348e(0x215)]===_0x45348e(0x40a)?(this['playCursorSound'](),this[_0x45348e(0x414)](),this[_0x45348e(0x17c)](),Input[_0x45348e(0x3b2)](),SceneManager[_0x45348e(0x160)][_0x45348e(0x10c)]()):VisuMZ[_0x45348e(0x405)]['Window_EquipCommand_processDownCursorSpecialCheckModernControls'][_0x45348e(0x116)](this);},VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x42f)]=Window_EquipCommand['prototype']['playOkSound'],Window_EquipCommand[_0x5b5488(0x286)][_0x5b5488(0x42a)]=function(){const _0x2693ac=_0x5b5488;VisuMZ[_0x2693ac(0x405)]['Window_EquipCommand_playOkSound'][_0x2693ac(0x116)](this);if(this[_0x2693ac(0x131)]()===_0x2693ac(0x40a))Window_HorzCommand[_0x2693ac(0x286)]['playOkSound'][_0x2693ac(0x116)](this);},VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x104)]=Window_EquipCommand[_0x5b5488(0x286)]['onTouchSelectModernControls'],Window_EquipCommand[_0x5b5488(0x286)]['onTouchSelectModernControls']=function(_0xaf4fd5){const _0x3ffe8e=_0x5b5488;this['_doubleTouch']=![];const _0x377ab8=this[_0x3ffe8e(0x38f)](),_0x22005d=this['hitIndex'](),_0x353193=SceneManager[_0x3ffe8e(0x160)][_0x3ffe8e(0x42e)];if(_0x353193['isOpen']()&&_0x353193[_0x3ffe8e(0x2a4)]){if(_0x22005d>=0x0)_0x22005d===this['index']()&&(this[_0x3ffe8e(0x3ef)]=!![]),this[_0x3ffe8e(0x2a5)](),this[_0x3ffe8e(0x1ac)](_0x22005d),_0x353193[_0x3ffe8e(0x414)](),_0x353193[_0x3ffe8e(0x17c)]();else _0x353193[_0x3ffe8e(0x38e)]()>=0x0&&(this[_0x3ffe8e(0x414)](),_0x353193[_0x3ffe8e(0x2a5)]());}else{if(_0x3ffe8e(0x1c6)===_0x3ffe8e(0x3ee)){if(!_0x5ef2de)return;if(_0xf8ffea<0x0)return;if(!_0x1f7153[_0x3ffe8e(0x23e)](_0x5b5355))return;this[_0x3ffe8e(0x10d)]=this[_0x3ffe8e(0x10d)]||{},this[_0x3ffe8e(0x10d)][_0x4e55ec['id']]=this[_0x3ffe8e(0x10d)][_0x21ec1c['id']]||0x0,this[_0x3ffe8e(0x10d)][_0x516e65['id']]+=_0x448d43;const _0x512170=_0x20f6b4['getEquipMedalEvolutionEXP'](_0x53fd7c);if(this['_equipMedalExp'][_0x45624e['id']]>=_0x512170){const _0x16514c=this[_0x3ffe8e(0x10d)][_0x32cff5['id']]-_0x512170,_0x2ba843=_0x2ddbb5[_0x3ffe8e(0x337)](_0x10c6a3);this[_0x3ffe8e(0x159)](_0x398809),this['learnEquippedMedal'](_0x2ba843,_0x271282),this[_0x3ffe8e(0x1cb)](_0x2ba843)&&this['processEquipMedal'](_0x2ba843),this[_0x3ffe8e(0x34e)](_0x2ba843,_0x16514c);}}else{VisuMZ[_0x3ffe8e(0x405)]['Window_EquipCommand_onTouchSelectModernControls'][_0x3ffe8e(0x116)](this);return;}}_0xaf4fd5&&this[_0x3ffe8e(0x38f)]()!==_0x377ab8&&this[_0x3ffe8e(0x186)]();};function Window_EquipMedalList(){const _0xcb697b=_0x5b5488;this[_0xcb697b(0x25c)](...arguments);}Window_EquipMedalList[_0x5b5488(0x286)]=Object[_0x5b5488(0x41f)](Window_Selectable[_0x5b5488(0x286)]),Window_EquipMedalList['prototype'][_0x5b5488(0x270)]=Window_EquipMedalList,Window_EquipMedalList[_0x5b5488(0x417)]={'bgType':VisuMZ[_0x5b5488(0x405)]['Settings'][_0x5b5488(0x1a4)][_0x5b5488(0x15b)]??0x0,'equipColor':VisuMZ['EquipMedalSys'][_0x5b5488(0x11f)][_0x5b5488(0x1a4)]['EquippedColor']??0x11,'showCostAny':VisuMZ['EquipMedalSys'][_0x5b5488(0x11f)][_0x5b5488(0x1a4)]['ShowCosts']??!![],'showCost1':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)]['Window']['ShowCost1']??!![],'showCost0':VisuMZ[_0x5b5488(0x405)]['Settings']['Window']['ShowCost0']??![],'costNumber':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)]['Window'][_0x5b5488(0x2ce)]??![],'costIconLimit':VisuMZ[_0x5b5488(0x405)]['Settings'][_0x5b5488(0x1a4)]['costIconLimit']??0x3,'sortBy':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)]['Window'][_0x5b5488(0x15e)]??_0x5b5488(0x24b),'showUnlearned':VisuMZ['EquipMedalSys'][_0x5b5488(0x11f)]['Window'][_0x5b5488(0x411)]??!![],'separateUnlearned':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)][_0x5b5488(0x1a4)][_0x5b5488(0x248)]??!![],'maskUnlearned':VisuMZ['EquipMedalSys'][_0x5b5488(0x11f)]['Window'][_0x5b5488(0x439)]??![],'maskItalics':VisuMZ[_0x5b5488(0x405)]['Settings'][_0x5b5488(0x1a4)][_0x5b5488(0x180)]??!![],'maskIcon':VisuMZ[_0x5b5488(0x405)]['Settings'][_0x5b5488(0x1a4)][_0x5b5488(0x2d8)]??0xa1,'maskLetter':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)]['Window'][_0x5b5488(0x199)]??'?','hideFormerEvolution':VisuMZ['EquipMedalSys']['Settings'][_0x5b5488(0x1a4)][_0x5b5488(0x25f)]??!![],'defaultExpGaugeColor1':VisuMZ['EquipMedalSys'][_0x5b5488(0x11f)][_0x5b5488(0x1a4)][_0x5b5488(0x1b6)]??0x10,'defaultExpGaugeColor2':VisuMZ['EquipMedalSys'][_0x5b5488(0x11f)]['Window'][_0x5b5488(0x36e)]??0x11,'expGaugeStyleType':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)][_0x5b5488(0x1a4)]['expGaugeStyleType']??'Growth','expGaugeWidthModifier':VisuMZ[_0x5b5488(0x405)]['Settings'][_0x5b5488(0x1a4)][_0x5b5488(0x3b3)]??-0x68,'expTextOffsetX':VisuMZ[_0x5b5488(0x405)]['Settings'][_0x5b5488(0x1a4)][_0x5b5488(0x216)]??0x0,'expTextOffsetY':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)]['Window']['expTextOffsetY']??0x6},Window_EquipMedalList[_0x5b5488(0x286)][_0x5b5488(0x25c)]=function(_0x5e1d60){const _0x2e8660=_0x5b5488;Window_Selectable[_0x2e8660(0x286)][_0x2e8660(0x25c)]['call'](this,_0x5e1d60),this[_0x2e8660(0x2bf)]=null,this[_0x2e8660(0x1fa)]=[],this[_0x2e8660(0x2ac)]();},Window_EquipMedalList[_0x5b5488(0x286)][_0x5b5488(0x366)]=function(_0x2282bf){const _0x3b39b3=_0x5b5488;this[_0x3b39b3(0x2bf)]!==_0x2282bf&&(this['_actor']=_0x2282bf,this['refresh'](),this[_0x3b39b3(0x380)](0x0,0x0));},Window_EquipMedalList[_0x5b5488(0x286)][_0x5b5488(0x341)]=function(){return 0x1;},Window_EquipMedalList['prototype']['colSpacing']=function(){return 0x8;},Window_EquipMedalList[_0x5b5488(0x286)][_0x5b5488(0x2d4)]=function(){const _0x5eb14d=_0x5b5488;return this[_0x5eb14d(0x1fa)]?this[_0x5eb14d(0x1fa)][_0x5eb14d(0x257)]:0x1;},Window_EquipMedalList[_0x5b5488(0x286)][_0x5b5488(0x3a0)]=function(){const _0x208d69=_0x5b5488;return this[_0x208d69(0x115)](this['index']());},Window_EquipMedalList['prototype']['itemAt']=function(_0x109c44){const _0x2a5f82=_0x5b5488;return this['_data']&&_0x109c44>=0x0?this[_0x2a5f82(0x1fa)][_0x109c44]:null;},Window_EquipMedalList[_0x5b5488(0x286)][_0x5b5488(0x21e)]=function(){const _0x348781=_0x5b5488;Window_Selectable['prototype'][_0x348781(0x21e)][_0x348781(0x116)](this);const _0x5eee8d=SceneManager[_0x348781(0x160)];if(Imported[_0x348781(0x1da)]&&_0x5eee8d[_0x348781(0x3b6)]){if('BruAn'==='BruAn')_0x5eee8d[_0x348781(0x2f7)]();else{if(!this[_0x348781(0x1df)]())return;let _0x1aaa20=_0x1f9e07[_0x348781(0x107)][_0x348781(0x272)];if(this[_0x348781(0x35b)]()!==_0x348781(0x334)){const _0x5d3763=_0x49de49[_0x348781(0x107)]['icon'];_0x1aaa20=_0x348781(0x124)[_0x348781(0x24a)](_0x5d3763,_0x1aaa20);}this[_0x348781(0x2b1)](_0x1aaa20,'equipMedals');}}},Window_EquipMedalList[_0x5b5488(0x286)][_0x5b5488(0x360)]=function(){const _0x43cb56=_0x5b5488;this['_actor']?this[_0x43cb56(0x1fa)]=this[_0x43cb56(0x442)]():this[_0x43cb56(0x1fa)]=[];},Window_EquipMedalList[_0x5b5488(0x286)][_0x5b5488(0x442)]=function(){const _0x1a3d4e=_0x5b5488;if(!this['_actor'])return[];let _0x2864d5=this[_0x1a3d4e(0x2bf)][_0x1a3d4e(0x43d)]();Window_EquipMedalList[_0x1a3d4e(0x417)][_0x1a3d4e(0x1be)]&&(_0x2864d5=this['sortItems'](_0x2864d5));if(Window_EquipMedalList['SETTINGS'][_0x1a3d4e(0x15c)]){if('tlozD'!==_0x1a3d4e(0x2fd)){let _0x33eb03=this[_0x1a3d4e(0x2bf)][_0x1a3d4e(0x13a)]();Window_EquipMedalList['SETTINGS']['separateUnlearned']&&(_0x33eb03=this[_0x1a3d4e(0x1aa)](_0x33eb03)),_0x2864d5=_0x2864d5[_0x1a3d4e(0x294)](_0x33eb03);}else{const _0x35cb07=_0x389c04(_0x3f16da['$1']);if(_0x35cb07>_0x5c12fa[_0x1a3d4e(0x22d)](_0xbe74d2,_0x1a3d4e(0x3dc),_0x1a3d4e(0x3f4)))return![];_0x3c1ee8=!![];}}return _0x2864d5=_0x2864d5[_0x1a3d4e(0x1d2)]((_0x2b3637,_0x4304ed,_0x326e98)=>_0x326e98[_0x1a3d4e(0x26a)](_0x2b3637)===_0x4304ed),!Window_EquipMedalList[_0x1a3d4e(0x417)][_0x1a3d4e(0x1be)]&&(_0x2864d5=this[_0x1a3d4e(0x1aa)](_0x2864d5)),_0x2864d5=_0x2864d5[_0x1a3d4e(0x1d2)](_0x30bba9=>this[_0x1a3d4e(0x2c4)](_0x30bba9)),_0x2864d5;},Window_EquipMedalList['prototype'][_0x5b5488(0x2c4)]=function(_0x1f6ba5){const _0x56f935=_0x5b5488;if(VisuMZ['EquipMedalSys'][_0x56f935(0x200)](this['_actor'],_0x1f6ba5))return![];if(DataManager[_0x56f935(0x23e)](_0x1f6ba5)){const _0x3d043d=DataManager[_0x56f935(0x337)](_0x1f6ba5);if(this[_0x56f935(0x2bf)][_0x56f935(0x15a)](_0x3d043d))return![];}return!![];},VisuMZ['EquipMedalSys'][_0x5b5488(0x200)]=function(_0x20d3b6,_0x4734b3){const _0x3559f7=_0x5b5488,_0x4d85ec=VisuMZ[_0x3559f7(0x405)]['RegExp'],_0x30d221=_0x4734b3[_0x3559f7(0x3f3)]||'';if(_0x30d221[_0x3559f7(0x156)](_0x4d85ec[_0x3559f7(0x27e)])){if(!_0x20d3b6['isLearnedEquippedMedal'](_0x4734b3))return!![];}if(_0x30d221[_0x3559f7(0x156)](_0x4d85ec[_0x3559f7(0x2d1)])){const _0x598230=String(RegExp['$1'])[_0x3559f7(0x281)](',')[_0x3559f7(0x32c)](_0x105ba1=>Number(_0x105ba1));if(_0x598230[_0x3559f7(0x445)](_0x201f3a=>_0x20d3b6['isLearnedEquippedMedal']($dataArmors[_0x201f3a])))return!![];}if(_0x30d221[_0x3559f7(0x156)](_0x4d85ec['HideLearnedAnyID'])){const _0x32ff0d=String(RegExp['$1'])[_0x3559f7(0x281)](',')['map'](_0x341f16=>Number(_0x341f16));if(_0x32ff0d[_0x3559f7(0x276)](_0x18ce1a=>_0x20d3b6[_0x3559f7(0x15a)]($dataArmors[_0x18ce1a])))return!![];}if(_0x30d221[_0x3559f7(0x156)](_0x4d85ec[_0x3559f7(0x202)])){const _0x512d80=String(RegExp['$1'])[_0x3559f7(0x281)](',')[_0x3559f7(0x32c)](_0x49aab9=>DataManager['getArmorIdWithName'](_0x49aab9));if(_0x512d80[_0x3559f7(0x445)](_0x8391fe=>_0x20d3b6[_0x3559f7(0x15a)]($dataArmors[_0x8391fe])))return!![];}if(_0x30d221[_0x3559f7(0x156)](_0x4d85ec[_0x3559f7(0x1f4)])){if(_0x3559f7(0x3ea)!==_0x3559f7(0x220)){const _0x4acb0b=String(RegExp['$1'])[_0x3559f7(0x281)](',')[_0x3559f7(0x32c)](_0x504205=>DataManager[_0x3559f7(0x182)](_0x504205));if(_0x4acb0b[_0x3559f7(0x276)](_0x85d049=>_0x20d3b6['isLearnedEquippedMedal']($dataArmors[_0x85d049])))return!![];}else return _0x78e9ca=_0x2e4cf7['id']||_0x4be908,this[_0x3559f7(0x443)]=this[_0x3559f7(0x443)]||{},this[_0x3559f7(0x443)][_0x773ba6]=this[_0x3559f7(0x443)][_0x2c1529]||{},this[_0x3559f7(0x443)][_0x260af2][_0x577208]=this[_0x3559f7(0x443)][_0x220109][_0x3c3281]||{},this[_0x3559f7(0x443)][_0x4e1e6c][_0x5661c8][_0x22daf6]=this[_0x3559f7(0x443)][_0x36cad0][_0x5d697a][_0x42afe5]||0x0,this[_0x3559f7(0x443)][_0x47270d][_0x263fec][_0x2ac11b];}return![];},Window_EquipMedalList['prototype'][_0x5b5488(0x1aa)]=function(_0x262432){const _0x532b2a=_0x5b5488,_0x311cd8=Window_EquipMedalList[_0x532b2a(0x417)][_0x532b2a(0x243)];if(_0x311cd8==='id'){if(_0x532b2a(0x1ec)===_0x532b2a(0x1ec))return _0x262432['sort']((_0x1372f5,_0x3a8116)=>_0x1372f5['id']-_0x3a8116['id']);else{const _0x4aca28=_0x24a8bf(_0x3b6de9['$1']);if(_0x4aca28>_0x16f737[_0x532b2a(0x22d)](_0x571be9,_0x532b2a(0x3dc),'miss'))return![];_0x50d812=!![];}}else{if(_0x311cd8===_0x532b2a(0x24b))return _0x262432['sort']((_0x19fd36,_0x4d4cfa)=>DataManager[_0x532b2a(0x256)](_0x19fd36)>DataManager[_0x532b2a(0x256)](_0x4d4cfa)?0x1:-0x1);else{if(_0x311cd8===_0x532b2a(0x1b9)){if(_0x532b2a(0x238)!==_0x532b2a(0x343))return _0x262432[_0x532b2a(0x3d1)]((_0xf5661f,_0x48c633)=>_0xf5661f[_0x532b2a(0x14b)]-_0x48c633[_0x532b2a(0x14b)]);else _0x377b48['EquipMedalSys'][_0x532b2a(0x3da)](_0x11ebf1)&&this[_0x532b2a(0x3f0)](_0x2a8af0,_0xa0b5b4['x'],_0x38409a['y'],_0x52157b['width'],this['_actor']),this[_0x532b2a(0x356)](_0x572d8f,_0x3bb7c6['x'],_0x2d1f99['y'],_0x2b74e2[_0x532b2a(0x1a2)],this['_actor']),this['drawEquippableMedalCost'](_0x4afec4,_0xf3b689['x'],_0x33ff89['y'],_0x364c67[_0x532b2a(0x1a2)]);}else{if('oKmsg'===_0x532b2a(0x1d1))return _0x262432;else{if(!this[_0x532b2a(0x328)])return![];if(_0x1cc4ad[_0x532b2a(0x160)][_0x532b2a(0x270)]!==_0x4d8d36)return![];if(this['allowCommandWindowCursorUp']())return this['playCursorSound'](),_0x49fad0[_0x532b2a(0x3b2)](),_0x22d065[_0x532b2a(0x160)][_0x532b2a(0x206)](),![];return![];}}}}},Window_EquipMedalList['prototype'][_0x5b5488(0x188)]=function(){const _0x139f6c=_0x5b5488;this[_0x139f6c(0x1a0)](0x0);},Window_EquipMedalList[_0x5b5488(0x286)][_0x5b5488(0x126)]=function(_0x2104cd){const _0x313bba=_0x5b5488,_0x50cd28=this[_0x313bba(0x115)](_0x2104cd);if(!_0x50cd28)return;const _0x41fd92=this['itemLineRect'](_0x2104cd);this['changePaintOpacity'](this[_0x313bba(0x3a5)](_0x50cd28)),this['_actor']['isLearnedEquippedMedal'](_0x50cd28)?(VisuMZ[_0x313bba(0x405)]['HasExpGauge'](_0x50cd28)&&this['drawEquippableMedalExpGauge'](_0x50cd28,_0x41fd92['x'],_0x41fd92['y'],_0x41fd92[_0x313bba(0x1a2)],this['_actor']),this[_0x313bba(0x356)](_0x50cd28,_0x41fd92['x'],_0x41fd92['y'],_0x41fd92['width'],this[_0x313bba(0x2bf)]),this[_0x313bba(0x419)](_0x50cd28,_0x41fd92['x'],_0x41fd92['y'],_0x41fd92[_0x313bba(0x1a2)])):(VisuMZ[_0x313bba(0x405)][_0x313bba(0x226)](_0x50cd28)?this[_0x313bba(0x359)](_0x50cd28,_0x41fd92['x'],_0x41fd92['y'],_0x41fd92['width']):_0x313bba(0x1ad)!==_0x313bba(0x139)?this[_0x313bba(0x356)](_0x50cd28,_0x41fd92['x'],_0x41fd92['y'],_0x41fd92[_0x313bba(0x1a2)],this[_0x313bba(0x2bf)]):_0x1c3498&&(_0x1e91a1[_0x313bba(0x414)](),_0x4c0e76[_0x313bba(0x17c)]()),this['drawUnlearnedText'](_0x41fd92));},VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x226)]=function(_0xd4841a){const _0x4196a3=_0x5b5488,_0xeb030b=VisuMZ[_0x4196a3(0x405)][_0x4196a3(0x1c0)],_0x3e166d=_0xd4841a['note']||'';if(_0x3e166d[_0x4196a3(0x156)](_0xeb030b[_0x4196a3(0x439)]))return!![];if(_0x3e166d[_0x4196a3(0x156)](_0xeb030b[_0x4196a3(0x3e6)]))return![];return Window_EquipMedalList[_0x4196a3(0x417)]['maskUnlearned'];},VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x3da)]=function(_0x12e25b){const _0x2a2d62=_0x5b5488;if(this[_0x2a2d62(0x1ca)](_0x12e25b))return!![];if(DataManager[_0x2a2d62(0x23e)](_0x12e25b))return!![];return![];},VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x1ca)]=function(_0xadaed6){const _0x28d9cb=_0x5b5488,_0x1a4a12=VisuMZ['EquipMedalSys']['RegExp'],_0x16c732=_0xadaed6['note']||'';if(_0x16c732[_0x28d9cb(0x156)](_0x1a4a12[_0x28d9cb(0x158)]))return!![];return![];},Window_EquipMedalList[_0x5b5488(0x286)]['drawUnlearnedText']=function(_0x555d87){const _0x8062f=_0x5b5488,_0x1c118f=TextManager[_0x8062f(0x107)][_0x8062f(0x307)],_0x8448ed=this[_0x8062f(0x119)](_0x1c118f)[_0x8062f(0x1a2)],_0x5250d6=_0x555d87['x']+_0x555d87[_0x8062f(0x1a2)]-_0x8448ed;this[_0x8062f(0x368)](_0x1c118f,_0x5250d6,_0x555d87['y']),this[_0x8062f(0x1ae)]();},Window_EquipMedalList['prototype'][_0x5b5488(0x3d3)]=function(){const _0xa7802b=_0x5b5488;if(this[_0xa7802b(0x2bf)]&&this['_actor'][_0xa7802b(0x15a)](this[_0xa7802b(0x3a0)]())){this[_0xa7802b(0x3b4)](this[_0xa7802b(0x3a0)]());if(this['_statusWindow'])this[_0xa7802b(0x117)]();}else{if(_0xa7802b(0x22e)===_0xa7802b(0x22e)){const _0x41474d=VisuMZ[_0xa7802b(0x405)]['MakeUnlockHelpText'](this[_0xa7802b(0x2bf)],this[_0xa7802b(0x3a0)]());if(this[_0xa7802b(0x2de)])this[_0xa7802b(0x2de)]['setText'](_0x41474d);if(this['_statusWindow'])this[_0xa7802b(0x2a9)][_0xa7802b(0xfb)](null);}else{let _0x2b8202=_0xd5fe27[_0xa7802b(0x405)]['Game_Actor_paramPlus'][_0xa7802b(0x116)](this,_0x3594c9);for(const _0x4da0d2 of this['equippedMedals']()){_0x4da0d2&&(_0x2b8202+=_0x4da0d2[_0xa7802b(0x24e)][_0x3beb3e]);}return _0x2b8202;}}},Window_EquipMedalList['prototype'][_0x5b5488(0x3b4)]=function(_0xed757a){const _0x544e92=_0x5b5488;if(!this[_0x544e92(0x2de)])return;const _0x46aa7e=VisuMZ[_0x544e92(0x405)][_0x544e92(0x1c0)],_0x4ea9a4=(_0xed757a?_0xed757a[_0x544e92(0x3f3)]:'')||'';let _0x35d85b=_0xed757a?_0xed757a[_0x544e92(0x24c)]:'';if(_0xed757a&&_0x4ea9a4[_0x544e92(0x156)](_0x46aa7e[_0x544e92(0x212)])){if(_0x544e92(0x17d)===_0x544e92(0x144))for(const _0x42bd99 of _0x943202){_0x42bd99[_0x544e92(0x156)](_0x2f8851['LearnHaveParam']);let _0x3bdf54=_0xc7e84d(_0x1242b4['$1'])[_0x544e92(0x33c)]()['trim']();const _0x18b944=_0x2da374(_0x25147d['$2']);if(_0x3bdf54===_0x544e92(0x14c))_0x3bdf54='MAXHP';if(_0x3bdf54===_0x544e92(0x259))_0x3bdf54=_0x544e92(0x402);if(_0x3bdf54===_0x544e92(0x2f2))_0x3bdf54=_0x544e92(0x369);if(_0x3bdf54===_0x544e92(0x298))_0x3bdf54=_0x544e92(0x369);const _0x98736c=[_0x544e92(0x402),_0x544e92(0x369),_0x544e92(0x190),_0x544e92(0x30d),'MAT','MDF',_0x544e92(0x388),_0x544e92(0x2b3)],_0xb28a47=_0x98736c[_0x544e92(0x26a)](_0x3bdf54),_0x3e723f=_0x352aac['param'](_0xb28a47),_0x1f141d=_0x544e92(0x3a4),_0x4bdae2=_0x342185[_0x544e92(0x2ca)](_0x3bdf54);_0x19f923=this['ApplyUnlockHelpTextCondition'](_0x41c742,_0x18b944,_0x3e723f,_0x1f141d,_0x4bdae2);}else _0x35d85b=String(RegExp['$1']);}this[_0x544e92(0x2de)][_0x544e92(0x1a8)](_0x35d85b);},Window_EquipMedalList[_0x5b5488(0x286)]['refresh']=function(){const _0x11d57b=_0x5b5488;this['makeItemList'](),Window_Selectable[_0x11d57b(0x286)][_0x11d57b(0x3f5)][_0x11d57b(0x116)](this);},Window_EquipMedalList[_0x5b5488(0x286)][_0x5b5488(0x42a)]=function(){const _0x1aea1d=_0x5b5488;SoundManager[_0x1aea1d(0x41c)]();},Window_EquipMedalList['prototype'][_0x5b5488(0x1f3)]=function(){const _0x55a5b2=_0x5b5488;return this[_0x55a5b2(0x3a5)](this[_0x55a5b2(0x3a0)]());},Window_EquipMedalList[_0x5b5488(0x286)]['isEnabled']=function(_0x5b4201){const _0x20a808=_0x5b5488;if(!_0x5b4201)return![];if(!this['_actor'])return![];if(this[_0x20a808(0x2bf)][_0x20a808(0x41d)](_0x5b4201))return!![];return this[_0x20a808(0x2bf)][_0x20a808(0x15a)](_0x5b4201)?this['_actor'][_0x20a808(0x1cb)](_0x5b4201):![];},VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x418)]=function(_0x4592d3,_0x52f61f){const _0xcf63f8=_0x5b5488;if(!_0x52f61f)return'';const _0x4c9574=TextManager[_0xcf63f8(0x107)],_0x36795a=VisuMZ[_0xcf63f8(0x405)][_0xcf63f8(0x1c0)],_0x11f88f=_0x52f61f[_0xcf63f8(0x3f3)]||'';let _0x535203='';if(_0x11f88f[_0xcf63f8(0x156)](_0x36795a[_0xcf63f8(0x42c)])){if(_0xcf63f8(0x355)===_0xcf63f8(0x1ea)){const _0x4850c8=_0xe2b7c5(_0x108a3f['$1']);if(_0x4850c8>_0x1c9973[_0xcf63f8(0x22d)](_0x34bac0,_0xcf63f8(0x2fb),_0xcf63f8(0x385)))return![];_0x1b85ae=!![];}else _0x535203=String(RegExp['$1'])[_0xcf63f8(0x374)]();}else{if(_0x11f88f[_0xcf63f8(0x156)](_0x36795a[_0xcf63f8(0x1e0)])){const _0x18704b=Number(RegExp['$1']),_0x7e0d4c=_0x4592d3[_0xcf63f8(0x1bc)],_0x1e4b76='level';_0x535203=this['ApplyUnlockHelpTextCondition'](_0x535203,_0x18704b,_0x7e0d4c,_0x1e4b76);}if(_0x11f88f['match'](_0x36795a[_0xcf63f8(0x3d8)])){const _0xdf177a=Number(RegExp['$1']),_0x5cc76e=_0x4592d3['getEquipMedalLearnProgress'](_0x52f61f,_0xcf63f8(0x2fb),'all'),_0x4631d8=_0xcf63f8(0x2fb);_0x535203=this['ApplyUnlockHelpTextCondition'](_0x535203,_0xdf177a,_0x5cc76e,_0x4631d8);}if(_0x11f88f['match'](_0x36795a[_0xcf63f8(0x14d)])){if(_0xcf63f8(0x13d)!=='wiXuj')_0x41a428[_0xcf63f8(0x455)]()&&this[_0xcf63f8(0x400)](_0x264ba9,_0xcf63f8(0x3dc),_0xcf63f8(0x280),0x1);else{const _0x3c8bce=Number(RegExp['$1']),_0x26e888=_0x4592d3[_0xcf63f8(0x22d)](_0x52f61f,'battle','victory'),_0x1aea41=_0xcf63f8(0x35d);_0x535203=this[_0xcf63f8(0x403)](_0x535203,_0x3c8bce,_0x26e888,_0x1aea41);}}if(_0x11f88f['match'](_0x36795a['LearnEscapes'])){const _0x378e63=Number(RegExp['$1']),_0x8bd91=_0x4592d3['getEquipMedalLearnProgress'](_0x52f61f,'battle',_0xcf63f8(0x385)),_0x4ced79=_0xcf63f8(0x3d5);_0x535203=this[_0xcf63f8(0x403)](_0x535203,_0x378e63,_0x8bd91,_0x4ced79);}if(_0x11f88f[_0xcf63f8(0x156)](_0x36795a['LearnDefeats'])){if(_0xcf63f8(0x38a)!==_0xcf63f8(0x38a)){_0x55b9a4['EquipMedalSys'][_0xcf63f8(0x410)][_0xcf63f8(0x116)](this);const _0x425155=_0x421716[_0xcf63f8(0x160)];_0x425155&&_0x425155[_0xcf63f8(0x2a9)]&&_0x425155[_0xcf63f8(0x2a9)][_0xcf63f8(0x3f5)]();}else{const _0x42cc00=Number(RegExp['$1']),_0x235ccf=_0x4592d3['getEquipMedalLearnProgress'](_0x52f61f,_0xcf63f8(0x2fb),_0xcf63f8(0x303)),_0x2e5232=_0xcf63f8(0x303);_0x535203=this[_0xcf63f8(0x403)](_0x535203,_0x42cc00,_0x235ccf,_0x2e5232);}}if(_0x11f88f[_0xcf63f8(0x156)](_0x36795a[_0xcf63f8(0x3e4)])){if(_0xcf63f8(0x3fb)===_0xcf63f8(0x251)){const _0x1a0210=_0x149b3f(_0x3405f1['$1']),_0x41cd69=_0x3e2145[_0xcf63f8(0x22d)](_0x447db7,'hp','dmgDeal'),_0x456e16=_0xcf63f8(0x37c);_0x50fab6=this[_0xcf63f8(0x403)](_0x3a731f,_0x1a0210,_0x41cd69,_0x456e16);}else{const _0x45c347=Number(RegExp['$1']),_0x2d0046=_0x4592d3[_0xcf63f8(0x22d)](_0x52f61f,_0xcf63f8(0x3dc),_0xcf63f8(0x280)),_0x1dd1e9=_0xcf63f8(0x446);_0x535203=this['ApplyUnlockHelpTextCondition'](_0x535203,_0x45c347,_0x2d0046,_0x1dd1e9);}}if(_0x11f88f[_0xcf63f8(0x156)](_0x36795a[_0xcf63f8(0x1f7)])){if('BewAQ'===_0xcf63f8(0x35a)){const _0x24428e=Number(RegExp['$1']),_0x5b745f=_0x4592d3[_0xcf63f8(0x22d)](_0x52f61f,_0xcf63f8(0x3dc),'guard'),_0x3d1393=_0xcf63f8(0x1fe);_0x535203=this[_0xcf63f8(0x403)](_0x535203,_0x24428e,_0x5b745f,_0x3d1393);}else{_0xcc1a90[_0xcf63f8(0x156)](_0x9c00ef[_0x19a3a4]);let _0x179f31=_0x65c62f(_0x7df8a1['$1']);const _0x87d84b=/^\d+$/['test'](_0x179f31);_0x179f31=_0x87d84b?_0x262139(_0x179f31):_0x497758['getElementIdWithName'](_0x179f31),_0x24393e[_0xcf63f8(0x2c4)](_0x179f31)&&this[_0xcf63f8(0x400)](_0x3d6752,_0x5fb8d5,_0x179f31,0x1);}}if(_0x11f88f['match'](_0x36795a[_0xcf63f8(0x3c0)])){const _0x1424b1=Number(RegExp['$1']),_0x5ae513=_0x4592d3[_0xcf63f8(0x22d)](_0x52f61f,_0xcf63f8(0x3dc),_0xcf63f8(0x296)),_0x572352=_0xcf63f8(0x149);_0x535203=this[_0xcf63f8(0x403)](_0x535203,_0x1424b1,_0x5ae513,_0x572352);}if(_0x11f88f[_0xcf63f8(0x156)](_0x36795a[_0xcf63f8(0x456)])){const _0x379935=Number(RegExp['$1']),_0x12cccf=_0x4592d3['getEquipMedalLearnProgress'](_0x52f61f,_0xcf63f8(0x3dc),'physicalSkill'),_0x35b2f7=_0xcf63f8(0x37e);_0x535203=this['ApplyUnlockHelpTextCondition'](_0x535203,_0x379935,_0x12cccf,_0x35b2f7);}if(_0x11f88f[_0xcf63f8(0x156)](_0x36795a[_0xcf63f8(0x1a1)])){if(_0xcf63f8(0x3fc)!==_0xcf63f8(0x3fc))this[_0xcf63f8(0x31f)]['selectSymbol'](_0xcf63f8(0x40a)),this[_0xcf63f8(0x42e)][_0xcf63f8(0x2a5)](),this[_0xcf63f8(0x42e)][_0xcf63f8(0x188)](),this[_0xcf63f8(0x42e)][_0xcf63f8(0x21e)](),this[_0xcf63f8(0x16e)][_0xcf63f8(0x414)](),this[_0xcf63f8(0x16e)][_0xcf63f8(0x2ac)]();else{const _0x33bfa3=Number(RegExp['$1']),_0x368c94=_0x4592d3[_0xcf63f8(0x22d)](_0x52f61f,_0xcf63f8(0x3dc),_0xcf63f8(0x41b)),_0x22f1e9=_0xcf63f8(0x352);_0x535203=this[_0xcf63f8(0x403)](_0x535203,_0x33bfa3,_0x368c94,_0x22f1e9);}}if(_0x11f88f[_0xcf63f8(0x156)](_0x36795a['LearnCertSkill'])){const _0x136c12=Number(RegExp['$1']),_0x3c17e0=_0x4592d3[_0xcf63f8(0x22d)](_0x52f61f,_0xcf63f8(0x3dc),'certainHitSkill'),_0x94c489=_0xcf63f8(0x312);_0x535203=this['ApplyUnlockHelpTextCondition'](_0x535203,_0x136c12,_0x3c17e0,_0x94c489);}if(_0x11f88f['match'](_0x36795a[_0xcf63f8(0x392)])){if(_0xcf63f8(0x295)!==_0xcf63f8(0x295))_0x113886=_0x2d92ad[_0xcf63f8(0x2cd)](_0xb7ce38,_0x3aff17);else{const _0x5c795d=Number(RegExp['$1']),_0x550d33=_0x4592d3[_0xcf63f8(0x22d)](_0x52f61f,'actionTimes',_0xcf63f8(0x3a0)),_0x3f6b9c=_0xcf63f8(0x314);_0x535203=this[_0xcf63f8(0x403)](_0x535203,_0x5c795d,_0x550d33,_0x3f6b9c);}}if(_0x11f88f[_0xcf63f8(0x156)](_0x36795a[_0xcf63f8(0x21d)])){const _0x4fafe4=Number(RegExp['$1']),_0x2bc116=_0x4592d3[_0xcf63f8(0x22d)](_0x52f61f,_0xcf63f8(0x3dc),'critDeal'),_0x313c75='critDeal';_0x535203=this['ApplyUnlockHelpTextCondition'](_0x535203,_0x4fafe4,_0x2bc116,_0x313c75);}if(_0x11f88f[_0xcf63f8(0x156)](_0x36795a['LearnTakeCritHitTimes'])){const _0x5de431=Number(RegExp['$1']),_0x3eb7eb=_0x4592d3[_0xcf63f8(0x22d)](_0x52f61f,'actionTimes','critTake'),_0x140fb1=_0xcf63f8(0x361);_0x535203=this['ApplyUnlockHelpTextCondition'](_0x535203,_0x5de431,_0x3eb7eb,_0x140fb1);}if(_0x11f88f[_0xcf63f8(0x156)](_0x36795a[_0xcf63f8(0x1c2)])){if(_0xcf63f8(0x3c8)===_0xcf63f8(0x40e)){const _0x2a38b2=this[_0xcf63f8(0x3c1)](),_0x2807ce=_0x2a38b2['x'],_0x134a88=_0x2a38b2['y'],_0x3aab6e=_0x2a38b2[_0xcf63f8(0x1a2)];let _0x344c9a=_0x2a38b2[_0xcf63f8(0x452)];return _0x3c63cf[_0xcf63f8(0x417)][_0xcf63f8(0x28e)]&&(_0x344c9a-=this[_0xcf63f8(0x424)](0x1,![])),new _0x2d54de(_0x2807ce,_0x134a88,_0x3aab6e,_0x344c9a);}else{const _0x4638b9=Number(RegExp['$1']),_0x1a47b8=_0x4592d3[_0xcf63f8(0x22d)](_0x52f61f,'actionTimes',_0xcf63f8(0x2dd)),_0x11a9cd=_0xcf63f8(0x2dd);_0x535203=this[_0xcf63f8(0x403)](_0x535203,_0x4638b9,_0x1a47b8,_0x11a9cd);}}if(_0x11f88f[_0xcf63f8(0x156)](_0x36795a[_0xcf63f8(0x3d2)])){const _0x49a585=Number(RegExp['$1']),_0x5195e6=_0x4592d3[_0xcf63f8(0x22d)](_0x52f61f,_0xcf63f8(0x3dc),_0xcf63f8(0x3c2)),_0x96b5c8=_0xcf63f8(0x3c2);_0x535203=this['ApplyUnlockHelpTextCondition'](_0x535203,_0x49a585,_0x5195e6,_0x96b5c8);}{if(_0xcf63f8(0x3de)===_0xcf63f8(0x234)){_0x9917ad[_0xcf63f8(0x405)][_0xcf63f8(0x32d)][_0xcf63f8(0x116)](this);if(this['isActor']())this[_0xcf63f8(0x222)]();}else{const _0x41b680=_0x11f88f[_0xcf63f8(0x156)](_0x36795a[_0xcf63f8(0x32e)]);if(_0x41b680)for(const _0x45df1e of _0x41b680){_0x45df1e[_0xcf63f8(0x156)](_0x36795a[_0xcf63f8(0x32e)]);let _0x490c03=String(RegExp['$1']);const _0x53cd9c=Number(RegExp['$2']),_0x2fa3b7=/^\d+$/[_0xcf63f8(0x239)](_0x490c03);_0x490c03=_0x2fa3b7?Number(_0x490c03):DataManager[_0xcf63f8(0x143)](_0x490c03);const _0x47ac60=_0x4592d3['getEquipMedalLearnProgress'](_0x52f61f,'stype',_0x490c03),_0x4bb69c=_0xcf63f8(0x435),_0x4e4b4d=$dataSystem[_0xcf63f8(0x233)][_0x490c03];_0x535203=this['ApplyUnlockHelpTextCondition'](_0x535203,_0x53cd9c,_0x47ac60,_0x4bb69c,_0x4e4b4d);}}}{const _0x336899=_0x11f88f['match'](_0x36795a[_0xcf63f8(0x18e)]);if(_0x336899)for(const _0x1b9aae of _0x336899){_0x1b9aae[_0xcf63f8(0x156)](_0x36795a['LearnElementDeal']);let _0x186781=String(RegExp['$1']);const _0x1f3519=Number(RegExp['$2']),_0x52500c=/^\d+$/[_0xcf63f8(0x239)](_0x186781);_0x186781=_0x52500c?Number(_0x186781):DataManager[_0xcf63f8(0x1e1)](_0x186781);const _0x372e10=_0x4592d3[_0xcf63f8(0x22d)](_0x52f61f,_0xcf63f8(0x39c),_0x186781),_0x11252a=_0xcf63f8(0x39c),_0x4b1a13=$dataSystem[_0xcf63f8(0x416)][_0x186781];_0x535203=this[_0xcf63f8(0x403)](_0x535203,_0x1f3519,_0x372e10,_0x11252a,_0x4b1a13);}}{const _0x3162f9=_0x11f88f[_0xcf63f8(0x156)](_0x36795a[_0xcf63f8(0x252)]);if(_0x3162f9)for(const _0x56249e of _0x3162f9){_0x56249e[_0xcf63f8(0x156)](_0x36795a[_0xcf63f8(0x252)]);let _0x33dc9f=String(RegExp['$1']);const _0x45b74b=Number(RegExp['$2']),_0x189f1f=/^\d+$/[_0xcf63f8(0x239)](_0x33dc9f);_0x33dc9f=_0x189f1f?Number(_0x33dc9f):DataManager[_0xcf63f8(0x1e1)](_0x33dc9f);const _0x55e216=_0x4592d3[_0xcf63f8(0x22d)](_0x52f61f,_0xcf63f8(0x26b),_0x33dc9f),_0x561be1=_0xcf63f8(0x26b),_0x3ffd37=$dataSystem['elements'][_0x33dc9f];_0x535203=this[_0xcf63f8(0x403)](_0x535203,_0x45b74b,_0x55e216,_0x561be1,_0x3ffd37);}}{if(_0xcf63f8(0x210)!==_0xcf63f8(0x3e3)){const _0x3b4bba=_0x11f88f[_0xcf63f8(0x156)](_0x36795a['LearnStateDeal']);if(_0x3b4bba){if(_0xcf63f8(0x2f1)===_0xcf63f8(0x2f1))for(const _0x520414 of _0x3b4bba){_0x520414[_0xcf63f8(0x156)](_0x36795a[_0xcf63f8(0x101)]);let _0xa3006=String(RegExp['$1']);const _0x5b093b=Number(RegExp['$2']),_0x31dd24=/^\d+$/[_0xcf63f8(0x239)](_0xa3006);_0xa3006=_0x31dd24?Number(_0xa3006):DataManager[_0xcf63f8(0x187)](_0xa3006);const _0x1f39da=_0x4592d3[_0xcf63f8(0x22d)](_0x52f61f,_0xcf63f8(0x15f),_0xa3006),_0x20010b=_0xcf63f8(0x15f),_0x3d38aa=$dataStates[_0xa3006],_0x115eb9=_0xcf63f8(0x124)[_0xcf63f8(0x24a)](_0x3d38aa[_0xcf63f8(0x308)],_0x3d38aa[_0xcf63f8(0x24b)]);_0x535203=this[_0xcf63f8(0x403)](_0x535203,_0x5b093b,_0x1f39da,_0x20010b,_0x115eb9);}else{if(!_0x51e59f[_0xcf63f8(0x389)](_0x1edf34))return;if(this['_learnedEquippableMedals']===_0x422a19)this[_0xcf63f8(0xfa)]();return this['_learnedEquippableMedals'][_0xcf63f8(0x2c4)](_0x1cf03f['id']);}}}else this[_0xcf63f8(0x400)](_0x16cefc,_0x367881,_0x2339a0,0x1);}{const _0x43f9fb=_0x11f88f[_0xcf63f8(0x156)](_0x36795a[_0xcf63f8(0x304)]);if(_0x43f9fb)for(const _0x4de290 of _0x43f9fb){if(_0xcf63f8(0x408)==='Cqghg'){const _0x4d950d=_0x47cb4c[_0xcf63f8(0x107)][_0xcf63f8(0x3a9)];_0x4a9874='\x5cI[%1]%2'['format'](_0x4d950d,_0xc99ea3);}else{_0x4de290[_0xcf63f8(0x156)](_0x36795a[_0xcf63f8(0x304)]);let _0x15375c=String(RegExp['$1']);const _0x4b4aa1=Number(RegExp['$2']),_0x15966e=/^\d+$/[_0xcf63f8(0x239)](_0x15375c);_0x15375c=_0x15966e?Number(_0x15375c):DataManager[_0xcf63f8(0x187)](_0x15375c);const _0x3653a2=_0x4592d3[_0xcf63f8(0x22d)](_0x52f61f,_0xcf63f8(0x23a),_0x15375c),_0x20d80e=_0xcf63f8(0x23a),_0x4725eb=$dataStates[_0x15375c],_0x1a5e61=_0xcf63f8(0x124)[_0xcf63f8(0x24a)](_0x4725eb[_0xcf63f8(0x308)],_0x4725eb[_0xcf63f8(0x24b)]);_0x535203=this[_0xcf63f8(0x403)](_0x535203,_0x4b4aa1,_0x3653a2,_0x20d80e,_0x1a5e61);}}}if(Imported[_0xcf63f8(0x3c5)]){if(_0xcf63f8(0x13f)==='XhkFg'){const _0x1878e2=_0x11f88f[_0xcf63f8(0x156)](_0x36795a[_0xcf63f8(0x1d6)]);if(_0x1878e2){if(_0xcf63f8(0x2f5)!==_0xcf63f8(0x29d))for(const _0x3b8f05 of _0x1878e2){_0x3b8f05[_0xcf63f8(0x156)](_0x36795a[_0xcf63f8(0x1d6)]);const _0x36ff6e=String(RegExp['$1']),_0x461e19=Number(RegExp['$2']),_0x2175dc=_0x4592d3[_0xcf63f8(0x22d)](_0x52f61f,_0xcf63f8(0x321),_0x36ff6e[_0xcf63f8(0x33c)]()['trim']()),_0x2a4385=_0xcf63f8(0x321),_0x1d7216=_0x36ff6e;_0x535203=this[_0xcf63f8(0x403)](_0x535203,_0x461e19,_0x2175dc,_0x2a4385,_0x1d7216);}else for(const _0xbf0a7e of _0x3cda53){_0xbf0a7e['match'](_0x548985[_0xcf63f8(0x252)]);let _0x2893c2=_0x503527(_0x3d262a['$1']);const _0x2ce704=_0x2e002a(_0xe94735['$2']),_0xd965b6=/^\d+$/[_0xcf63f8(0x239)](_0x2893c2);_0x2893c2=_0xd965b6?_0x5a2edf(_0x2893c2):_0x3a2283[_0xcf63f8(0x1e1)](_0x2893c2);const _0x28afae=_0x5675af[_0xcf63f8(0x22d)](_0x949a37,_0xcf63f8(0x26b),_0x2893c2),_0x5e13a5=_0xcf63f8(0x26b),_0x5a4507=_0x1f3580['elements'][_0x2893c2];_0x31a4ad=this[_0xcf63f8(0x403)](_0x1c2872,_0x2ce704,_0x28afae,_0x5e13a5,_0x5a4507);}}}else this[_0xcf63f8(0x186)](),this[_0xcf63f8(0x414)](),this[_0xcf63f8(0x17c)](),_0x49dcf4[_0xcf63f8(0x3b2)](),_0x4c34d8[_0xcf63f8(0x160)]['commandEquipMedals']();}if(_0x11f88f[_0xcf63f8(0x156)](_0x36795a[_0xcf63f8(0x3e7)])){const _0x41104e=Number(RegExp['$1']),_0x182779=_0x4592d3[_0xcf63f8(0x22d)](_0x52f61f,'hp',_0xcf63f8(0x44c)),_0x9ae3fe=_0xcf63f8(0x37c);_0x535203=this[_0xcf63f8(0x403)](_0x535203,_0x41104e,_0x182779,_0x9ae3fe);}if(_0x11f88f[_0xcf63f8(0x156)](_0x36795a[_0xcf63f8(0x2e2)])){const _0x23bdd5=Number(RegExp['$1']),_0x151765=_0x4592d3['getEquipMedalLearnProgress'](_0x52f61f,'hp',_0xcf63f8(0x213)),_0x127b3d='totalDmgTake';_0x535203=this[_0xcf63f8(0x403)](_0x535203,_0x23bdd5,_0x151765,_0x127b3d);}if(_0x11f88f[_0xcf63f8(0x156)](_0x36795a[_0xcf63f8(0x1a3)])){const _0x336c77=Number(RegExp['$1']),_0x3de6a0=_0x4592d3['getEquipMedalLearnProgress'](_0x52f61f,'hp',_0xcf63f8(0x3be)),_0xfc9da8=_0xcf63f8(0x45a);_0x535203=this[_0xcf63f8(0x403)](_0x535203,_0x336c77,_0x3de6a0,_0xfc9da8);}if(_0x11f88f['match'](_0x36795a[_0xcf63f8(0x10f)])){const _0x46c6c3=Number(RegExp['$1']),_0x370e05=_0x4592d3['getEquipMedalLearnProgress'](_0x52f61f,'hp','healTake'),_0x3b9a8f='totalHealTake';_0x535203=this['ApplyUnlockHelpTextCondition'](_0x535203,_0x46c6c3,_0x370e05,_0x3b9a8f);}if(_0x11f88f['match'](_0x36795a[_0xcf63f8(0x2e7)])){if(_0xcf63f8(0x150)==='RLABw'){const _0x474571=Number(RegExp['$1']),_0x5a472a=_0x4592d3['getEquipMedalLearnProgress'](_0x52f61f,_0xcf63f8(0x457),'kills'),_0x379e8b=_0xcf63f8(0x325);_0x535203=this[_0xcf63f8(0x403)](_0x535203,_0x474571,_0x5a472a,_0x379e8b);}else{const _0xb57aef=_0x4e3abb(_0x18c853['$1'])[_0xcf63f8(0x374)](),_0x1e7f81=_0x380e59[_0xcf63f8(0x2cd)](_0x54c4be(_0xb0a485['$2']),0x1),_0x43ea02=/^\d+$/[_0xcf63f8(0x239)](_0xb57aef);let _0x1811bf=0x0;_0x43ea02?_0x1811bf=_0x24a9d7(_0xb57aef):_0x1811bf=_0x54b880[_0xcf63f8(0x182)](_0xb57aef),_0x1811bf>0x0&&(_0x12cf94[_0xcf63f8(0x3b5)]=_0x1811bf,_0x3c6026['exp']=_0x1e7f81);}}if(_0x11f88f[_0xcf63f8(0x156)](_0x36795a[_0xcf63f8(0x351)])){const _0x28acb1=Number(RegExp['$1']),_0x32c3cf=_0x4592d3[_0xcf63f8(0x22d)](_0x52f61f,_0xcf63f8(0x457),_0xcf63f8(0x300)),_0x3d5260=_0xcf63f8(0x300);_0x535203=this['ApplyUnlockHelpTextCondition'](_0x535203,_0x28acb1,_0x32c3cf,_0x3d5260);}if(_0x11f88f[_0xcf63f8(0x156)](_0x36795a[_0xcf63f8(0x167)])){const _0x3aeb30=Number(RegExp['$1']),_0x405148=_0x4592d3['getEquipMedalLearnProgress'](_0x52f61f,_0xcf63f8(0x457),_0xcf63f8(0x23b)),_0x43fb53=_0xcf63f8(0x23b);_0x535203=this['ApplyUnlockHelpTextCondition'](_0x535203,_0x3aeb30,_0x405148,_0x43fb53);}if(_0x11f88f['match'](_0x36795a['LearnHaveGold'])){const _0x1114d0=Number(RegExp['$1']),_0xc929d3=$gameParty['gold'](),_0x48ebdc='haveGold',_0x458edd=TextManager['currencyUnit'];_0x535203=this[_0xcf63f8(0x403)](_0x535203,_0x1114d0,_0xc929d3,_0x48ebdc,_0x458edd);}{const _0x17b6f5=_0x11f88f[_0xcf63f8(0x156)](_0x36795a[_0xcf63f8(0x255)]);if(_0x17b6f5){if(_0xcf63f8(0x3a7)===_0xcf63f8(0x451))this[_0xcf63f8(0x2bf)]?this[_0xcf63f8(0x1fa)]=this[_0xcf63f8(0x442)]():this['_data']=[];else for(const _0x36f412 of _0x17b6f5){if(_0xcf63f8(0x21f)!=='lkVSt')this[_0xcf63f8(0x16e)][_0xcf63f8(0x2ac)](),this['_slotWindow'][_0xcf63f8(0x414)]();else{_0x36f412[_0xcf63f8(0x156)](_0x36795a['LearnHaveItem']);const _0x4d7433=String(RegExp['$1']),_0xa9fce5=Number(RegExp['$2']),_0x2e06d7=/^\d+$/['test'](_0x4d7433),_0x33c5c8=_0x2e06d7?Number(_0x4d7433):DataManager[_0xcf63f8(0x271)](_0x4d7433),_0x50499b=$dataItems[_0x33c5c8];if(!_0x50499b)continue;const _0x26fa71=$gameParty[_0xcf63f8(0x36f)](_0x50499b),_0x23695a=_0xcf63f8(0x195),_0x253108=_0xcf63f8(0x124)['format'](_0x50499b[_0xcf63f8(0x308)],_0x50499b['name']);_0x535203=this[_0xcf63f8(0x403)](_0x535203,_0xa9fce5,_0x26fa71,_0x23695a,_0x253108);}}}}{const _0x11621a=_0x11f88f[_0xcf63f8(0x156)](_0x36795a['LearnHaveWeapon']);if(_0x11621a)for(const _0x4a2e6f of _0x11621a){if(_0xcf63f8(0x3b7)==='rqotN'){_0x4a2e6f[_0xcf63f8(0x156)](_0x36795a[_0xcf63f8(0x348)]);const _0xfab70=String(RegExp['$1']),_0x2c2a79=Number(RegExp['$2']),_0x807d39=/^\d+$/[_0xcf63f8(0x239)](_0xfab70),_0x1893b4=_0x807d39?Number(_0xfab70):DataManager[_0xcf63f8(0x338)](_0xfab70),_0x417505=$dataWeapons[_0x1893b4];if(!_0x417505)continue;const _0x2a5afd=$gameParty[_0xcf63f8(0x36f)](_0x417505),_0x49e251=_0xcf63f8(0x2c9),_0x286124=_0xcf63f8(0x124)[_0xcf63f8(0x24a)](_0x417505[_0xcf63f8(0x308)],_0x417505[_0xcf63f8(0x24b)]);_0x535203=this['ApplyUnlockHelpTextCondition'](_0x535203,_0x2c2a79,_0x2a5afd,_0x49e251,_0x286124);}else _0xc4b231[_0xcf63f8(0x405)]['Scene_Equip_create'][_0xcf63f8(0x116)](this),this[_0xcf63f8(0x20d)](),this[_0xcf63f8(0x35e)]();}}{const _0x49538c=_0x11f88f['match'](_0x36795a[_0xcf63f8(0x3f9)]);if(_0x49538c){if(_0xcf63f8(0x2ff)===_0xcf63f8(0x326))_0x20aa85[_0xcf63f8(0x405)][_0xcf63f8(0x1e3)]['call'](this),this[_0xcf63f8(0x33f)]()['checkLearnNewEquipMedals'](),this['_equipMedalWindow']&&(this[_0xcf63f8(0x42e)]['setActor'](this[_0xcf63f8(0x33f)]()),this[_0xcf63f8(0x42e)][_0xcf63f8(0x3f5)]()),this[_0xcf63f8(0x339)]&&(this[_0xcf63f8(0x339)][_0xcf63f8(0x366)](this[_0xcf63f8(0x33f)]()),this['_medalStatusWindow'][_0xcf63f8(0x3f5)]());else for(const _0x1974c0 of _0x49538c){_0x1974c0[_0xcf63f8(0x156)](_0x36795a[_0xcf63f8(0x3f9)]);const _0x5a98ba=String(RegExp['$1']),_0x2daf00=Number(RegExp['$2']),_0x1a298a=/^\d+$/[_0xcf63f8(0x239)](_0x5a98ba),_0x5b9a25=_0x1a298a?Number(_0x5a98ba):DataManager['getArmorIdWithName'](_0x5a98ba),_0x2a632a=$dataArmors[_0x5b9a25];if(!_0x2a632a)continue;const _0x4f7062=$gameParty['numItems'](_0x2a632a),_0x1773d7=_0xcf63f8(0x2ee),_0x2c5d2c=_0xcf63f8(0x124)['format'](_0x2a632a[_0xcf63f8(0x308)],_0x2a632a[_0xcf63f8(0x24b)]);_0x535203=this[_0xcf63f8(0x403)](_0x535203,_0x2daf00,_0x4f7062,_0x1773d7,_0x2c5d2c);}}}{if(_0xcf63f8(0x245)!==_0xcf63f8(0x245)){const _0x3c337e=/^\d+$/['test'](_0x1a2669);let _0x1ef40e=0x0;_0x3c337e?_0x1ef40e=_0x3e7923(_0x5a8645):_0x1ef40e=_0x4442a3['getArmorIdWithName'](_0x5239dd),_0x1ef40e>0x0&&_0x212718[_0x19b0f9['id']][_0xcf63f8(0x2df)](_0x1ef40e);}else{const _0x3c6d97=_0x11f88f[_0xcf63f8(0x156)](_0x36795a[_0xcf63f8(0x285)]);if(_0x3c6d97)for(const _0x4b4e52 of _0x3c6d97){_0x4b4e52['match'](_0x36795a[_0xcf63f8(0x285)]);let _0x498c09=String(RegExp['$1'])[_0xcf63f8(0x33c)]()['trim']();const _0xdcd83=Number(RegExp['$2']);if(_0x498c09===_0xcf63f8(0x14c))_0x498c09=_0xcf63f8(0x402);if(_0x498c09===_0xcf63f8(0x259))_0x498c09='MAXHP';if(_0x498c09==='MMP')_0x498c09=_0xcf63f8(0x369);if(_0x498c09===_0xcf63f8(0x298))_0x498c09=_0xcf63f8(0x369);const _0x3ad9d5=[_0xcf63f8(0x402),_0xcf63f8(0x369),_0xcf63f8(0x190),_0xcf63f8(0x30d),'MAT',_0xcf63f8(0x33a),_0xcf63f8(0x388),_0xcf63f8(0x2b3)],_0x2d91ea=_0x3ad9d5[_0xcf63f8(0x26a)](_0x498c09),_0x2c94c7=_0x4592d3[_0xcf63f8(0x396)](_0x2d91ea),_0x36737f=_0xcf63f8(0x3a4),_0x3f4e0a=TextManager[_0xcf63f8(0x2ca)](_0x498c09);_0x535203=this['ApplyUnlockHelpTextCondition'](_0x535203,_0xdcd83,_0x2c94c7,_0x36737f,_0x3f4e0a);}}}{if(_0xcf63f8(0x3fe)!=='bZgFc')this['updateEquipMedalLearnProgress'](_0x94d490,_0xae8194,_0x2e252c,0x1);else{const _0x3ea92b=_0x11f88f[_0xcf63f8(0x156)](_0x36795a['LearnHaveXParam']);if(_0x3ea92b)for(const _0x178de7 of _0x3ea92b){if(_0xcf63f8(0x31e)===_0xcf63f8(0x2d7))return[];else{_0x178de7[_0xcf63f8(0x156)](_0x36795a[_0xcf63f8(0x32a)]);let _0x1283c3=String(RegExp['$1'])[_0xcf63f8(0x33c)]()[_0xcf63f8(0x374)]();const _0x248ce3=Number(RegExp['$2']),_0x1fbe64=[_0xcf63f8(0x382),_0xcf63f8(0x217),_0xcf63f8(0x1e5),_0xcf63f8(0x347),_0xcf63f8(0x421),_0xcf63f8(0x20c),_0xcf63f8(0x136),_0xcf63f8(0x25d),'MRG',_0xcf63f8(0x313)],_0xfbf1e0=_0x1fbe64[_0xcf63f8(0x26a)](_0x1283c3),_0x15a049=Math['round'](_0x4592d3[_0xcf63f8(0x29c)](_0xfbf1e0)*0x64),_0x2a05d1=_0xcf63f8(0x376),_0x3199af=TextManager[_0xcf63f8(0x2ca)](_0x1283c3);_0x535203=this['ApplyUnlockHelpTextCondition'](_0x535203,_0x248ce3,_0x15a049,_0x2a05d1,_0x3199af);}}}}{const _0x3c8bd0=_0x11f88f[_0xcf63f8(0x156)](_0x36795a[_0xcf63f8(0x288)]);if(_0x3c8bd0)for(const _0x6d9218 of _0x3c8bd0){_0x6d9218[_0xcf63f8(0x156)](_0x36795a['LearnHaveSParam']);let _0x439387=String(RegExp['$1'])[_0xcf63f8(0x33c)]()[_0xcf63f8(0x374)]();const _0x440b76=Number(RegExp['$2']),_0x2d8aba=[_0xcf63f8(0x218),_0xcf63f8(0x2fa),'REC',_0xcf63f8(0x183),'MCR',_0xcf63f8(0x1ba),_0xcf63f8(0x113),'MDR',_0xcf63f8(0x390),'EXR'],_0xb91f87=_0x2d8aba[_0xcf63f8(0x26a)](_0x439387),_0x4e313f=Math[_0xcf63f8(0x16b)](_0x4592d3[_0xcf63f8(0x2e8)](_0xb91f87)*0x64),_0x54f276=_0xcf63f8(0x44b),_0xf2516d=TextManager[_0xcf63f8(0x2ca)](_0x439387);_0x535203=this[_0xcf63f8(0x403)](_0x535203,_0x440b76,_0x4e313f,_0x54f276,_0xf2516d);}}}_0x535203===''&&(_0x535203=_0x4c9574[_0xcf63f8(0x166)]);let _0x1dc169=_0x4c9574[_0xcf63f8(0x3e0)][_0xcf63f8(0x24a)](_0x535203);if(_0x4c9574[_0xcf63f8(0x412)]&&Imported[_0xcf63f8(0x2bb)])_0x1dc169='<WordWrap>'+_0x1dc169;return _0x1dc169;},VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x403)]=function(_0xffc4ce,_0x28de4b,_0x1d5602,_0x33b2aa,_0x1d5d89){const _0x834f2c=_0x5b5488,_0xd2f82e=TextManager['EQUIP_MEDAL_SYS'],_0x5accf3=_0xd2f82e['helpDescFmt'];_0x1d5602=_0x1d5602[_0x834f2c(0x373)](0x0,_0x28de4b);let _0x12e67d='';const _0x11dea6=_0x5accf3['progressFmt'],_0x116faa=_0x5accf3[_0x834f2c(0x118)]['format'](_0x1d5602,_0x28de4b),_0x1fc46a=_0x5accf3['progressPercent'][_0x834f2c(0x24a)](Math['round'](_0x1d5602/_0x28de4b*0x64));_0x12e67d=_0x11dea6[_0x834f2c(0x24a)](_0x116faa[_0x834f2c(0x257)]>_0x5accf3[_0x834f2c(0x38d)]?_0x1fc46a:_0x116faa);if(_0xffc4ce[_0x834f2c(0x257)]>0x0){_0xffc4ce+=_0xd2f82e[_0x834f2c(0x440)];if(_0xd2f82e[_0x834f2c(0x41e)])_0xffc4ce+='\x20';}_0x1d5602>=_0x28de4b&&(_0xffc4ce+=_0x834f2c(0x3a3)[_0x834f2c(0x24a)](_0xd2f82e[_0x834f2c(0x39d)]),_0x12e67d=_0x5accf3[_0x834f2c(0x112)]);_0xffc4ce+=(_0x5accf3[_0x33b2aa]||'---')[_0x834f2c(0x24a)](_0x28de4b,_0x12e67d,_0x1d5d89||'');if(_0x1d5602>=_0x28de4b){if(_0x834f2c(0x12b)==='rgyYf')_0xffc4ce+=_0x834f2c(0x371);else{const _0x28e7ca=_0x3d031f[_0x834f2c(0x417)],_0x392764=_0x41e240[_0x834f2c(0x107)],_0xb7be0=_0x4a66da[_0x834f2c(0x21b)](_0x324d66[_0x834f2c(0x405)][_0x834f2c(0x384)](_0x36f303)),_0x45d7bf=_0xac7a8a['getColor'](_0x106484[_0x834f2c(0x405)][_0x834f2c(0x362)](_0x319d86)),_0x2969e9=_0x28e7ca[_0x834f2c(0x310)];_0xa8bd4f+=_0x28e7ca[_0x834f2c(0x3b3)];const _0x35ccc3=_0x103af7['getEquipMedalExp'](_0x46d045),_0x268f6b=_0x32aa22[_0x834f2c(0x3ac)](_0x4f679e);let _0x4990fb=(_0x35ccc3/_0x268f6b)[_0x834f2c(0x373)](0x0,0x1);if(_0x19b370[_0x834f2c(0x405)][_0x834f2c(0x1ca)](_0x275c52))_0x4990fb=0x1;if(_0x1b105f[_0x834f2c(0x317)]){const _0x2c4028=(_0x34f304[_0x834f2c(0x30b)][_0x834f2c(0x24f)](_0x2969e9)??0xc)[_0x834f2c(0x373)](0x1,0x20),_0x55adf4=_0x244000+this[_0x834f2c(0x1c1)]()-_0x2c4028-0x2,_0x31818c=_0x24d858['gaugeBackColor']();_0x3bce1c['VisualGaugeStyles'][_0x834f2c(0x2f3)]=_0x268f6b,this[_0x834f2c(0x32b)][_0x834f2c(0x23c)](_0x2969e9,_0x4d9b03,_0x55adf4,_0xb33f59,_0x2c4028,_0x4990fb,_0x31818c,_0xb7be0,_0x45d7bf);}else this['drawGauge'](_0x1eb5c5,_0x4807b1,_0x96ed77,_0x4990fb,_0xb7be0,_0x45d7bf);this[_0x834f2c(0x1ae)]();const _0x2f0c3a=(_0x4990fb*0x64)[_0x834f2c(0x1c4)](_0x392764['expPercentDigits']),_0x3ba983=_0x392764[_0x834f2c(0x2d9)];let _0x5a8278=_0x3ba983[_0x834f2c(0x24a)](_0x35ccc3,_0x268f6b,_0x2f0c3a);if(_0x4990fb>=0x1)_0x5a8278=_0x392764[_0x834f2c(0x21a)];const _0x5a93a4=this[_0x834f2c(0x119)](_0x5a8278)[_0x834f2c(0x1a2)],_0x5bb2ce=_0x207a42+_0x1036d7-_0x5a93a4+_0x28e7ca[_0x834f2c(0x216)],_0x337f22=_0x269279+_0x28e7ca[_0x834f2c(0x2e6)];this[_0x834f2c(0x368)](_0x5a8278,_0x5bb2ce,_0x337f22);}}return _0xffc4ce;},Window_EquipMedalList[_0x5b5488(0x286)][_0x5b5488(0x12c)]=function(_0x408767){const _0x555a2d=_0x5b5488;this[_0x555a2d(0x2a9)]=_0x408767;},Window_EquipMedalList['prototype'][_0x5b5488(0x117)]=function(){const _0xaeff7=_0x5b5488;if(!this[_0xaeff7(0x2bf)])return;if(!this[_0xaeff7(0x328)])return;const _0x13e130=this[_0xaeff7(0x3a0)]();if(!_0x13e130)return;const _0x3080b1=JsonEx[_0xaeff7(0x40c)](this[_0xaeff7(0x2bf)]);_0x3080b1[_0xaeff7(0x201)]=!![],_0x3080b1[_0xaeff7(0x41d)](_0x13e130)?_0x3080b1[_0xaeff7(0x159)](_0x13e130):_0x3080b1[_0xaeff7(0x22a)](_0x13e130),this[_0xaeff7(0x2a9)]['setTempActor'](_0x3080b1);},Window_EquipMedalList[_0x5b5488(0x286)]['processCursorMoveModernControls']=function(){const _0x2f58ed=_0x5b5488;!this[_0x2f58ed(0x3e2)]()&&Window_Selectable[_0x2f58ed(0x286)][_0x2f58ed(0x37a)][_0x2f58ed(0x116)](this);},Window_EquipMedalList[_0x5b5488(0x286)][_0x5b5488(0x3e2)]=function(){const _0x191312=_0x5b5488;if(!this[_0x191312(0x328)])return![];if(SceneManager[_0x191312(0x160)][_0x191312(0x270)]!==Scene_Equip)return![];if(this[_0x191312(0x12d)]()){if(_0x191312(0x1ed)!==_0x191312(0x1ed)){const _0x3ce68d=_0x1d414b(_0x5b3ed4['$1']);if(_0x3ce68d>_0x50fd0f['getEquipMedalLearnProgress'](_0x207e21,_0x191312(0x3dc),'magicalSkill'))return![];_0x52135b=!![];}else return this[_0x191312(0x186)](),Input[_0x191312(0x3b2)](),SceneManager[_0x191312(0x160)][_0x191312(0x206)](),![];}return![];},Window_EquipMedalList[_0x5b5488(0x286)][_0x5b5488(0x12d)]=function(){const _0x58df2b=_0x5b5488;if(this['index']()!==0x0)return![];return Input[_0x58df2b(0x228)]('up');};function Window_EquipMedalStatus(){const _0x56a1b5=_0x5b5488;this[_0x56a1b5(0x25c)](...arguments);}function _0x1c90(_0x374c65,_0x1a4b8f){const _0x5074ec=_0x5074();return _0x1c90=function(_0x1c90c9,_0x345dc9){_0x1c90c9=_0x1c90c9-0xfa;let _0x851be3=_0x5074ec[_0x1c90c9];return _0x851be3;},_0x1c90(_0x374c65,_0x1a4b8f);}Window_EquipMedalStatus['prototype']=Object[_0x5b5488(0x41f)](Window_Base[_0x5b5488(0x286)]),Window_EquipMedalStatus[_0x5b5488(0x286)][_0x5b5488(0x270)]=Window_EquipMedalStatus,Window_EquipMedalStatus[_0x5b5488(0x417)]={'showWindow':VisuMZ['EquipMedalSys'][_0x5b5488(0x11f)][_0x5b5488(0x1a4)][_0x5b5488(0x179)]??!![],'bgType':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)][_0x5b5488(0x1a4)]['StatusWindow_BgType']??0x0,'maxCapacityTextColor':VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x11f)][_0x5b5488(0x1a4)][_0x5b5488(0x41a)]??0x11},Window_EquipMedalStatus[_0x5b5488(0x286)][_0x5b5488(0x25c)]=function(_0x55c127){const _0x2aba2c=_0x5b5488;Window_Base[_0x2aba2c(0x286)][_0x2aba2c(0x25c)]['call'](this,_0x55c127),this[_0x2aba2c(0x2ac)]();},Window_EquipMedalStatus[_0x5b5488(0x286)]['setActor']=function(_0x4b67b6){const _0x24ac53=_0x5b5488;this[_0x24ac53(0x2bf)]!==_0x4b67b6&&(this['_actor']=_0x4b67b6,this[_0x24ac53(0x3f5)]());},Window_EquipMedalStatus[_0x5b5488(0x286)][_0x5b5488(0x3f5)]=function(){const _0x24422b=_0x5b5488;this[_0x24422b(0x32b)]['clear'](),this[_0x24422b(0x1ae)]();{const _0x532872=TextManager[_0x24422b(0x107)][_0x24422b(0x2eb)];this[_0x24422b(0x375)](ColorManager[_0x24422b(0x19e)]());const _0x512081=this[_0x24422b(0x39e)]-this[_0x24422b(0x3df)]()*0x2;this['drawText'](_0x532872,this[_0x24422b(0x3df)](),0x0,_0x512081,_0x24422b(0x422)),this[_0x24422b(0x1ae)]();}if(this[_0x24422b(0x2bf)]){if(_0x24422b(0x279)!==_0x24422b(0x279))this[_0x24422b(0x3ef)]=!![];else{const _0x1f86cb=TextManager['EQUIP_MEDAL_SYS'][_0x24422b(0x318)];let _0x4e1641=this[_0x24422b(0x2bf)][_0x24422b(0x22b)](),_0x202336=this[_0x24422b(0x2bf)][_0x24422b(0x178)]();const _0x203caa=Window_EquipMedalStatus[_0x24422b(0x417)]['maxCapacityTextColor']||0x0;_0x203caa>0x0&&_0x4e1641>=_0x202336&&(_0x4e1641=_0x24422b(0x23f)[_0x24422b(0x24a)](_0x203caa,_0x4e1641),_0x202336=_0x24422b(0x23f)[_0x24422b(0x24a)](_0x203caa,_0x202336));const _0x4e5952=_0x24422b(0xfe)['format'](ImageManager[_0x24422b(0x107)][_0x24422b(0x2eb)]),_0x53461f=_0x1f86cb['format'](_0x4e1641,_0x202336,_0x4e5952),_0x95f856=this[_0x24422b(0x119)](_0x53461f)[_0x24422b(0x1a2)],_0x501b5f=this['innerWidth']-this[_0x24422b(0x3df)]()-_0x95f856;this[_0x24422b(0x368)](_0x53461f,_0x501b5f,0x0);}}},VisuMZ[_0x5b5488(0x405)][_0x5b5488(0x31d)]=![];