//=============================================================================
// VisuStella MZ - Furniture System
// VisuMZ_2_FurnitureSystem.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_2_FurnitureSystem = true;

var VisuMZ = VisuMZ || {};
VisuMZ.FurnitureSystem = VisuMZ.FurnitureSystem || {};
VisuMZ.FurnitureSystem.version = 1.07;

//=============================================================================
/* ----------------------------------------------------------------------------
 * Default Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Default:
 *
 * @param Maps
 * @text Default Map Settings
 *
 * @param MapsAllowFurniture:eval
 * @text Allow Furniture Mode?
 * @parent Maps
 * @type boolean
 * @on Allow By Default
 * @off Disallow By Default
 * @desc Allow all maps the ability to put furniture on them by
 * default? If not, requires notetags.
 * @default true
 *
 * @param Items
 * @text Default Item Settings
 *
 * @param RegionsAllow:arraynum
 * @text Allowed Regions
 * @parent Items
 * @type number[]
 * @min 0
 * @max 255
 * @desc Furniture with this MUST be placed in these regions.
 * CANNOT be used with Forbid Regions.
 * @default []
 *
 * @param RegionsForbid:arraynum
 * @text Forbid Regions
 * @parent Items
 * @type number[]
 * @min 0
 * @max 255
 * @desc Furniture CANNOT be placed in these regions.
 * CANNOT be used with Allowed Regions
 * @default []
 *
 * @param TerrainTagsAllow:arraynum
 * @text Allowed Terrain Tags
 * @parent Items
 * @type number[]
 * @min 0
 * @max 255
 * @desc Furniture with this MUST be placed in these tags.
 * CANNOT be used with Forbid Terrain Tags.
 * @default []
 *
 * @param TerrainTagsForbid:arraynum
 * @text Forbid Terrain Tags
 * @parent Items
 * @type number[]
 * @min 0
 * @max 255
 * @desc Furniture CANNOT be placed in these tags.
 * CANNOT be used with Allowed Terrain Tags.
 * @default []
 * 
 * @param Checks
 * @text Default Check Settings
 *
 * @param CheckEventCollision:eval
 * @text Event Collision?
 * @parent Checks
 * @type boolean
 * @on Check By Default
 * @off Don't Check By Default
 * @desc Check event collision by default before placement?
 * Recommended to be enabled.
 * @default true
 *
 * @param CheckPassability:eval
 * @text Passability?
 * @parent Checks
 * @type boolean
 * @on Check By Default
 * @off Don't Check By Default
 * @desc Check passability by default before placement?
 * Recommended to be enabled.
 * @default true
 * 
 * @param Misc
 * @text Default Misc Settings
 *
 * @param CommonEvent:num
 * @text Common Event
 * @parent Misc
 * @type common_event
 * @desc Run which Common Event by default after placing furniture?
 * Use 0 for no Common Event.
 * @default 0
 *
 * @param EndOnPlace:eval
 * @text End on Place?
 * @parent Misc
 * @type boolean
 * @on End After Placing 1
 * @off End Until Empty/Cancelled
 * @desc End Furniture Mode after placing 1 item?
 * Or end until items are empty or cancelled?
 * @default false
 *
 */
/* ----------------------------------------------------------------------------
 * Filter Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Filter:
 *
 * @param Tone
 * @text Tone Filter
 *
 * @param AllowTone:eval
 * @text Allowed Tone
 * @parent Tone
 * @desc Tone when furniture is over a placeable tile.
 * Format: [Red, Green, Blue, Gray]
 * @default [0, 0, 0, 0]
 *
 * @param ForbidTone:eval
 * @text Forbidden Tone
 * @parent Tone
 * @desc Tone when furniture is over a forbidden tile.
 * Format: [Red, Green, Blue, Gray]
 * @default [255, -64, -64, 64]
 *
 * @param Outline
 * @text Outline Filter
 *
 * @param OutlineThickness:num
 * @text Thickness
 * @parent Outline
 * @type number
 * @min 1
 * @desc What outline thickness do you want for furniture cursor?
 * Requires Pixi JS Filters.
 * @default 2
 *
 * @param OutlineQuality:num
 * @text Quality
 * @parent Outline
 * @desc Quality level for the outline filter.
 * Requires Pixi JS Filters.
 * @default 0.1
 *
 * @param OutlineAllowedColor:eval
 * @text Allowed Color
 * @parent Outline
 * @desc System hex code color for allowed color.
 * Format: 0xRRGGBB   Requires Pixi JS Filters.
 * @default 0x00ff00
 *
 * @param OutlineForbidColor:eval
 * @text Forbidden Color
 * @parent Outline
 * @desc System hex code color for forbidden color.
 * Format: 0xRRGGBB   Requires Pixi JS Filters.
 * @default 0xff0000
 *
 */
/* ----------------------------------------------------------------------------
 * Sound Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Sound:
 *
 * @param Place
 * @text Place Furniture
 *
 * @param PlaceName:str
 * @text Filename
 * @parent Place
 * @type file
 * @dir audio/se/
 * @require 1
 * @desc Filename of the sound effect played.
 * @default Equip1
 *
 * @param PlaceVolume:num
 * @text Volume
 * @parent Place
 * @type number
 * @max 100
 * @desc Volume of the sound effect played.
 * @default 90
 *
 * @param PlacePitch:num
 * @text Pitch
 * @parent Place
 * @type number
 * @desc Pitch of the sound effect played.
 * @default 100
 *
 * @param PlacePan:num
 * @text Pan
 * @parent Place
 * @desc Pan of the sound effect played.
 * @default 0
 *
 * @param Move
 * @text Move Furniture
 *
 * @param MoveName:str
 * @text Filename
 * @parent Move
 * @type file
 * @dir audio/se/
 * @require 1
 * @desc Filename of the sound effect played.
 * @default Equip2
 *
 * @param MoveVolume:num
 * @text Volume
 * @parent Move
 * @type number
 * @max 100
 * @desc Volume of the sound effect played.
 * @default 90
 *
 * @param MovePitch:num
 * @text Pitch
 * @parent Move
 * @type number
 * @desc Pitch of the sound effect played.
 * @default 100
 *
 * @param MovePan:num
 * @text Pan
 * @parent Move
 * @desc Pan of the sound effect played.
 * @default 0
 *
 */
/* ----------------------------------------------------------------------------
 * Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Window:
 *
 * @param Mechanics
 * @text Mechanical Settings
 *
 * @param HoldTime:num
 * @text Hold Time
 * @parent Mechanics
 * @type number
 * @min 1
 * @desc How many frames must a furniture event be clicked and held before entering move furniture mode?
 * @default 90
 *
 * @param HelpWindow
 * @text Help Window Settings
 *
 * @param HelpWindow_BgType:num
 * @text Background Type
 * @parent HelpWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 1
 *
 * @param HelpWindow_FadeTarget:num
 * @text Fade Target: Opacity
 * @parent HelpWindow
 * @type number
 * @min 1
 * @max 255
 * @desc What opacity value should this window fade to when the mouse cursor is over it?
 * @default 128
 *
 * @param HelpWindow_Col1_OffsetX:num
 * @text Column 1: Offset
 * @parent HelpWindow
 * @desc Offset the column 1 text by how many pixels?
 * Negative: Left; Positive: Right
 * @default +0
 *
 * @param HelpWindow_Col2_OffsetX:num
 * @text Column 2: Offset
 * @parent HelpWindow
 * @desc Offset the column 2 text by how many pixels?
 * Negative: Left; Positive: Right
 * @default -48
 * 
 * @param HelpWindow_DrawJS:func
 * @text JS: Draw
 * @parent HelpWindow
 * @type note
 * @desc Code used to determine what is drawn inside this window.
 * @default "// Declare Variables\nlet x1 = Math.round(this.contents.width * 1/4);\nx1 += Window_FurnitureHelp.OFFSET_COLUMN_1_X;\nlet x2 = Math.round(this.contents.width * 3/4);\nx2 += Window_FurnitureHelp.OFFSET_COLUMN_2_X;\nconst bufferX = this.textWidth(' ');\n\n{ // Draw Position Text\n    this.changePaintOpacity(true);\n    const text1 = TextManager.FurnitureSystem.PositionButtons;\n    const text2 = TextManager.FurnitureSystem.PositionText;\n    const size1 = this.textSizeEx(text1).width;\n    const size2 = this.textSizeEx(text2).width;\n    const y = 0;\n    this.drawTextEx(text1, x1 - size1 - bufferX, y, size1);\n    this.drawTextEx(text2, x1 + bufferX, y, size2);\n} // End Position Text\n\n{ // Draw Variant Text\n    this.changePaintOpacity(this.isHasMultipleVariants());\n    const text1 = TextManager.FurnitureSystem.VariantButtons;\n    const text2 = TextManager.FurnitureSystem.VariantText;\n    const size1 = this.textSizeEx(text1).width;\n    const size2 = this.textSizeEx(text2).width;\n    const y = this.lineHeight();\n    this.drawTextEx(text1, x1 - size1 - bufferX, y, size1);\n    this.drawTextEx(text2, x1 + bufferX, y, size2);\n} // End Variant Text\n\n{ // Draw Confirm Text\n    this.changePaintOpacity(true);\n    const text1 = TextManager.FurnitureSystem.ConfirmButtons;\n    const text2 = TextManager.FurnitureSystem.ConfirmText;\n    const size1 = this.textSizeEx(text1).width;\n    const size2 = this.textSizeEx(text2).width;\n    const y = 0;\n    this.drawTextEx(text1, x2 - size1 - bufferX, y, size1);\n    this.drawTextEx(text2, x2 + bufferX, y, size2);\n} // End Confirm Text\n\n{ // Draw Cancel Text\n    this.changePaintOpacity(this.isCancelExitPrevented());\n    const text1 = TextManager.FurnitureSystem.CancelButtons;\n    const text2 = TextManager.FurnitureSystem.CancelText;\n    const size1 = this.textSizeEx(text1).width;\n    const size2 = this.textSizeEx(text2).width;\n    const y = this.lineHeight();\n    this.drawTextEx(text1, x2 - size1 - bufferX, y, size1);\n    this.drawTextEx(text2, x2 + bufferX, y, size2);\n} // End Cancel Text"
 *
 * @param HelpWindow_RectJS:func
 * @text JS: X, Y, W, H
 * @parent HelpWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "let ww = Graphics.width;\nlet wh = this.calcWindowHeight(2, false);\nlet wx = 0;\nlet wy = Graphics.height - wh;\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param ItemWindow
 * @text Item Window Settings
 *
 * @param ItemWindow_FadeTarget:num
 * @text Fade Target: Opacity
 * @parent ItemWindow
 * @type number
 * @min 1
 * @max 255
 * @desc What opacity value should this window fade to when the mouse cursor is over it?
 * @default 128
 * 
 * @param ItemWindow_DrawJS:func
 * @text JS: Draw
 * @parent ItemWindow
 * @type note
 * @desc Code used to determine what is drawn inside this window.
 * @default "// Declare Variables\nconst color1 = ColorManager.dimColor1();\nconst color2 = ColorManager.dimColor2();\nconst halfX = Math.round(this.innerWidth / 2);\nconst height = this.innerHeight;\nthis.contents.fillRect(0, 0, halfX, height, color1);\nthis.contents.gradientFillRect(0 + halfX, 0, halfX, height, color1, color2);\n\n// Draw Item\n// With VisuMZ_1_ItemsEquipsCore\nif (Imported.VisuMZ_1_ItemsEquipsCore) {\n    const x = this.itemPadding();\n    const y = 0;\n    const w = this.innerWidth - (x * 16);\n    this.drawItemNumber(this._item, x, y, x * 8);\n    this.drawItemName(this._item, x * 10, y, w);\n// Without VisuMZ_1_ItemsEquipsCore\n} else {\n    const x = this.itemPadding();\n    const y = 0;\n    const w = this.innerWidth - (x * 2);\n    this.drawItemName(this._item, x, y, w);\n    this.drawItemNumber(this._item, x, y, w - (x * 8));\n}"
 *
 * @param ItemWindow_RectJS:func
 * @text JS: X, Y, W, H
 * @parent ItemWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "let ww = Math.max(Math.round(Graphics.width / 3), 408);\nlet wh = this.calcWindowHeight(1, false);\nlet wx = -$gameSystem.windowPadding();\nlet wy = Math.round(Graphics.height * 1 / 6);\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param CancelButton
 * @text Cancel Button Settings
 *
 * @param CancelButtonXPositionJS:func
 * @text JS: X Position
 * @parent CancelButton
 * @type note
 * @desc Code used to determine the x coordinate for this button.
 * @default "// Declare Variables\nconst button = arguments[0];\n\n// Return Value\nreturn Graphics.width - button.width - 4;"
 *
 * @param CancelButtonYPositionJS:func
 * @text JS: Y Position
 * @parent CancelButton
 * @type note
 * @desc Code used to determine the y coordinate for this button.
 * @default "// Declare Variables\nconst button = arguments[0];\n\n// Return Value\nreturn Math.round((Graphics.height - Graphics.boxHeight) / 2);"
 *
 * @param Vocab
 * @text Vocabulary Settings
 *
 * @param PositionButtons:str
 * @text Position: Button(s)
 * @parent Vocab
 * @desc Buttons to use for positioning furniture.
 * Text codes allowed.
 * @default Arrows/Mouse
 *
 * @param PositionText:str
 * @text Position: Action
 * @parent Vocab
 * @desc Text to use for positioning furniture.
 * Text codes allowed.
 * @default Position
 *
 * @param VariantButtons:str
 * @text Variant: Button(s)
 * @parent Vocab
 * @desc Buttons to use for changing variants.
 * Text codes allowed.
 * @default Q/W/Scroll Wheel
 *
 * @param VariantText:str
 * @text Variant: Action
 * @parent Vocab
 * @desc Text to use for changing variants.
 * Text codes allowed.
 * @default Swap Variants
 *
 * @param ConfirmButtons:str
 * @text Confirm: Button(s)
 * @parent Vocab
 * @desc Buttons to use for confirming location.
 * Text codes allowed.
 * @default Z/Enter/LMB
 *
 * @param ConfirmText:str
 * @text Confirm: Action
 * @parent Vocab
 * @desc Text to use for confirming location.
 * Text codes allowed.
 * @default Place Object
 *
 * @param CancelButtons:str
 * @text Cancel: Button(s)
 * @parent Vocab
 * @desc Buttons to use for confirming location.
 * Text codes allowed.
 * @default X/ESC/RMB
 *
 * @param CancelText:str
 * @text Cancel: Action
 * @parent Vocab
 * @desc Text to use for confirming location.
 * Text codes allowed.
 * @default Finish Placement
 *
 */
//=============================================================================

const _0x2d7466=_0x30da;(function(_0x30b85c,_0x268796){const _0x1cc468=_0x30da,_0x4be109=_0x30b85c();while(!![]){try{const _0x247206=-parseInt(_0x1cc468(0x1e4))/0x1*(-parseInt(_0x1cc468(0x2bf))/0x2)+-parseInt(_0x1cc468(0x30c))/0x3*(-parseInt(_0x1cc468(0x283))/0x4)+-parseInt(_0x1cc468(0x201))/0x5*(parseInt(_0x1cc468(0x182))/0x6)+-parseInt(_0x1cc468(0x1f2))/0x7+-parseInt(_0x1cc468(0x300))/0x8+-parseInt(_0x1cc468(0x242))/0x9*(parseInt(_0x1cc468(0x240))/0xa)+parseInt(_0x1cc468(0x17c))/0xb;if(_0x247206===_0x268796)break;else _0x4be109['push'](_0x4be109['shift']());}catch(_0x5cc5eb){_0x4be109['push'](_0x4be109['shift']());}}}(_0x4bf0,0x44c12));function _0x30da(_0x349b90,_0x1ed798){const _0x4bf069=_0x4bf0();return _0x30da=function(_0x30daae,_0x515466){_0x30daae=_0x30daae-0x141;let _0x372756=_0x4bf069[_0x30daae];return _0x372756;},_0x30da(_0x349b90,_0x1ed798);}var label=_0x2d7466(0x266),tier=tier||0x0,dependencies=['VisuMZ_1_EventsMoveCore'],pluginData=$plugins[_0x2d7466(0x176)](function(_0x5d7774){const _0x242a5c=_0x2d7466;return _0x5d7774[_0x242a5c(0x1cb)]&&_0x5d7774[_0x242a5c(0x31c)][_0x242a5c(0x279)]('['+label+']');})[0x0];VisuMZ[label][_0x2d7466(0x1ca)]=VisuMZ[label][_0x2d7466(0x1ca)]||{},VisuMZ[_0x2d7466(0x158)]=function(_0x251d64,_0x5f9cdb){const _0x2e2a0e=_0x2d7466;for(const _0x57f687 in _0x5f9cdb){if(_0x2e2a0e(0x235)===_0x2e2a0e(0x235)){if(_0x57f687[_0x2e2a0e(0x2d7)](/(.*):(.*)/i)){const _0x27fa9e=String(RegExp['$1']),_0x1b3b22=String(RegExp['$2'])['toUpperCase']()[_0x2e2a0e(0x2c4)]();let _0x5ea4b7,_0x2a4186,_0x3b0374;switch(_0x1b3b22){case'NUM':_0x5ea4b7=_0x5f9cdb[_0x57f687]!==''?Number(_0x5f9cdb[_0x57f687]):0x0;break;case'ARRAYNUM':_0x2a4186=_0x5f9cdb[_0x57f687]!==''?JSON[_0x2e2a0e(0x2cd)](_0x5f9cdb[_0x57f687]):[],_0x5ea4b7=_0x2a4186[_0x2e2a0e(0x2cf)](_0x2ade18=>Number(_0x2ade18));break;case _0x2e2a0e(0x2c8):_0x5ea4b7=_0x5f9cdb[_0x57f687]!==''?eval(_0x5f9cdb[_0x57f687]):null;break;case _0x2e2a0e(0x1f8):_0x2a4186=_0x5f9cdb[_0x57f687]!==''?JSON[_0x2e2a0e(0x2cd)](_0x5f9cdb[_0x57f687]):[],_0x5ea4b7=_0x2a4186[_0x2e2a0e(0x2cf)](_0x5b1cb2=>eval(_0x5b1cb2));break;case _0x2e2a0e(0x1b4):_0x5ea4b7=_0x5f9cdb[_0x57f687]!==''?JSON[_0x2e2a0e(0x2cd)](_0x5f9cdb[_0x57f687]):'';break;case _0x2e2a0e(0x1da):_0x2a4186=_0x5f9cdb[_0x57f687]!==''?JSON['parse'](_0x5f9cdb[_0x57f687]):[],_0x5ea4b7=_0x2a4186[_0x2e2a0e(0x2cf)](_0x44e548=>JSON[_0x2e2a0e(0x2cd)](_0x44e548));break;case _0x2e2a0e(0x14f):_0x5ea4b7=_0x5f9cdb[_0x57f687]!==''?new Function(JSON[_0x2e2a0e(0x2cd)](_0x5f9cdb[_0x57f687])):new Function('return\x200');break;case _0x2e2a0e(0x210):_0x2a4186=_0x5f9cdb[_0x57f687]!==''?JSON[_0x2e2a0e(0x2cd)](_0x5f9cdb[_0x57f687]):[],_0x5ea4b7=_0x2a4186[_0x2e2a0e(0x2cf)](_0x1445c6=>new Function(JSON[_0x2e2a0e(0x2cd)](_0x1445c6)));break;case _0x2e2a0e(0x1c4):_0x5ea4b7=_0x5f9cdb[_0x57f687]!==''?String(_0x5f9cdb[_0x57f687]):'';break;case'ARRAYSTR':_0x2a4186=_0x5f9cdb[_0x57f687]!==''?JSON[_0x2e2a0e(0x2cd)](_0x5f9cdb[_0x57f687]):[],_0x5ea4b7=_0x2a4186['map'](_0x141a09=>String(_0x141a09));break;case _0x2e2a0e(0x180):_0x3b0374=_0x5f9cdb[_0x57f687]!==''?JSON['parse'](_0x5f9cdb[_0x57f687]):{},_0x5ea4b7=VisuMZ['ConvertParams']({},_0x3b0374);break;case _0x2e2a0e(0x1c7):_0x2a4186=_0x5f9cdb[_0x57f687]!==''?JSON[_0x2e2a0e(0x2cd)](_0x5f9cdb[_0x57f687]):[],_0x5ea4b7=_0x2a4186['map'](_0x48dd46=>VisuMZ['ConvertParams']({},JSON[_0x2e2a0e(0x2cd)](_0x48dd46)));break;default:continue;}_0x251d64[_0x27fa9e]=_0x5ea4b7;}}else{_0xbd1d9a[_0x2e2a0e(0x17f)]=!![];let _0x22bde1='This\x20furniture\x27s\x20settings\x20will\x20softlock\x20the\x20player.\x0aCancel\x20is\x20reenabled.';_0x3cb67a(_0x22bde1);}}return _0x251d64;},(_0x412a30=>{const _0x547930=_0x2d7466,_0x17418d=_0x412a30[_0x547930(0x161)];for(const _0x54b51c of dependencies){if(!Imported[_0x54b51c]){alert('%1\x20is\x20missing\x20a\x20required\x20plugin.\x0aPlease\x20install\x20%2\x20into\x20the\x20Plugin\x20Manager.'[_0x547930(0x301)](_0x17418d,_0x54b51c)),SceneManager[_0x547930(0x2af)]();break;}}const _0x2b4c74=_0x412a30['description'];if(_0x2b4c74[_0x547930(0x2d7)](/\[Version[ ](.*?)\]/i)){const _0x30c021=Number(RegExp['$1']);_0x30c021!==VisuMZ[label]['version']&&(alert(_0x547930(0x268)['format'](_0x17418d,_0x30c021)),SceneManager[_0x547930(0x2af)]());}if(_0x2b4c74[_0x547930(0x2d7)](/\[Tier[ ](\d+)\]/i)){if(_0x547930(0x2b6)===_0x547930(0x26c))return!![];else{const _0x1a17ae=Number(RegExp['$1']);_0x1a17ae<tier?(alert('%1\x20is\x20incorrectly\x20placed\x20on\x20the\x20plugin\x20list.\x0aIt\x20is\x20a\x20Tier\x20%2\x20plugin\x20placed\x20over\x20other\x20Tier\x20%3\x20plugins.\x0aPlease\x20reorder\x20the\x20plugin\x20list\x20from\x20smallest\x20to\x20largest\x20tier\x20numbers.'[_0x547930(0x301)](_0x17418d,_0x1a17ae,tier)),SceneManager['exit']()):'uTYzJ'!=='uTYzJ'?this[_0x547930(0x263)]++:tier=Math[_0x547930(0x23b)](_0x1a17ae,tier);}}VisuMZ[_0x547930(0x158)](VisuMZ[label][_0x547930(0x1ca)],_0x412a30[_0x547930(0x318)]);})(pluginData),PluginManager[_0x2d7466(0x28a)](pluginData[_0x2d7466(0x161)],_0x2d7466(0x2fa),_0x2fe5aa=>{const _0x304fd9=_0x2d7466;if(!SceneManager[_0x304fd9(0x247)]())return;if(!SceneManager[_0x304fd9(0x1a4)]())return;if($gameMap[_0x304fd9(0x169)]())return;VisuMZ[_0x304fd9(0x158)](_0x2fe5aa,_0x2fe5aa);const _0x26104d=_0x2fe5aa['FurnitureItem'],_0x4f2a88=$dataItems[_0x26104d];if(!DataManager['isFurnitureItem'](_0x4f2a88))return;const _0x58b17c=_0x2fe5aa[_0x304fd9(0x1f4)];_0x58b17c&&(_0x304fd9(0x15a)===_0x304fd9(0x15a)?$gameParty['gainItem'](_0x4f2a88,0x1):_0x310f43=_0x54cb81[_0x304fd9(0x23b)](_0x166054,_0x1258d1));if($gameParty[_0x304fd9(0x160)](_0x4f2a88)<=0x0)return;$gameMap[_0x304fd9(0x162)](_0x4f2a88);}),PluginManager['registerCommand'](pluginData[_0x2d7466(0x161)],'FurnitureSpawnAtXY',_0x19df01=>{const _0xa71918=_0x2d7466;if(!SceneManager[_0xa71918(0x247)]())return;if(!SceneManager['canPlaceFurniture']())return;if($gameMap[_0xa71918(0x169)]())return;VisuMZ[_0xa71918(0x158)](_0x19df01,_0x19df01);const _0x14a4cb=_0x19df01[_0xa71918(0x239)],_0x4a8201=$dataItems[_0x14a4cb];if(!DataManager[_0xa71918(0x2f7)](_0x4a8201))return;const _0x8ba59e=_0x19df01[_0xa71918(0x296)],_0xa6429f=_0x19df01[_0xa71918(0x2b0)],_0x275dec=_0x19df01[_0xa71918(0x2f0)],_0x4cac2e=$gameMap[_0xa71918(0x164)](_0x4a8201,_0x8ba59e,_0xa6429f,_0x275dec),_0x44d906=_0x19df01[_0xa71918(0x1bc)]||0x0;_0x44d906&&(_0xa71918(0x24f)===_0xa71918(0x2fd)?this[_0xa71918(0x2ef)]=_0x18ee29[_0xa71918(0x169)]()&&this[_0xa71918(0x326)]:$gameSwitches[_0xa71918(0x185)](_0x44d906,!!_0x4cac2e));}),PluginManager[_0x2d7466(0x28a)](pluginData[_0x2d7466(0x161)],_0x2d7466(0x297),_0x33dc8b=>{const _0x2321be=_0x2d7466;if(!SceneManager[_0x2321be(0x247)]())return;if(!SceneManager[_0x2321be(0x1a4)]())return;if($gameMap[_0x2321be(0x169)]())return;VisuMZ[_0x2321be(0x158)](_0x33dc8b,_0x33dc8b);const _0x44d8b8=_0x33dc8b[_0x2321be(0x239)],_0x1f8257=$dataItems[_0x44d8b8];if(!DataManager[_0x2321be(0x2f7)](_0x1f8257))return;const _0x10e55d=_0x33dc8b[_0x2321be(0x296)],_0x39a7af=_0x33dc8b[_0x2321be(0x22b)],_0x249c56=$gameMap[_0x2321be(0x259)](_0x1f8257,_0x10e55d,_0x39a7af),_0x2a12ef=_0x33dc8b[_0x2321be(0x1bc)]||0x0;_0x2a12ef&&$gameSwitches['setValue'](_0x2a12ef,!!_0x249c56);}),PluginManager[_0x2d7466(0x28a)](pluginData[_0x2d7466(0x161)],_0x2d7466(0x183),_0x5613f5=>{const _0x176d9c=_0x2d7466;if(!SceneManager['isSceneMap']())return;if(!SceneManager[_0x176d9c(0x1a4)]())return;if($gameMap[_0x176d9c(0x169)]())return;VisuMZ['ConvertParams'](_0x5613f5,_0x5613f5);const _0x3ae387=_0x5613f5['FurnitureItem'],_0xd65a1d=$dataItems[_0x3ae387];if(!DataManager['isFurnitureItem'](_0xd65a1d))return;const _0x4c34e1=_0x5613f5[_0x176d9c(0x296)],_0x21b86e=_0x5613f5[_0x176d9c(0x2bd)],_0x3e453f=$gameMap[_0x176d9c(0x145)](_0xd65a1d,_0x4c34e1,_0x21b86e),_0x1ce022=_0x5613f5['SuccessSwitchId']||0x0;_0x1ce022&&$gameSwitches[_0x176d9c(0x185)](_0x1ce022,!!_0x3e453f);}),PluginManager[_0x2d7466(0x28a)](pluginData[_0x2d7466(0x161)],_0x2d7466(0x2c0),_0x165e23=>{const _0x4e205d=_0x2d7466;if(!SceneManager[_0x4e205d(0x247)]())return;if(!SceneManager[_0x4e205d(0x1a4)]())return;const _0x105128=_0x165e23[_0x4e205d(0x2b0)],_0x49922e=_0x165e23[_0x4e205d(0x2f0)],_0x18bad4=$gameMap[_0x4e205d(0x1b9)](_0x105128,_0x49922e);if(_0x18bad4[_0x4e205d(0x1ad)]<=0x0)return;const _0x46fe0a=_0x18bad4[0x0];if(!_0x46fe0a)return;$gameMap[_0x4e205d(0x179)](_0x46fe0a[_0x4e205d(0x241)]());}),PluginManager[_0x2d7466(0x28a)](pluginData[_0x2d7466(0x161)],_0x2d7466(0x2d8),_0xde5f44=>{const _0x35dd04=_0x2d7466;if(!SceneManager[_0x35dd04(0x247)]())return;if(!SceneManager[_0x35dd04(0x1a4)]())return;if($gameMap[_0x35dd04(0x169)]())return;const _0x4307d0=_0xde5f44[_0x35dd04(0x2b0)],_0x40cbd6=_0xde5f44[_0x35dd04(0x2f0)],_0x9630db=$gameMap[_0x35dd04(0x1b9)](_0x4307d0,_0x40cbd6);if(_0x9630db[_0x35dd04(0x1ad)]<=0x0)return;const _0x552efb=_0x9630db[0x0];if(!_0x552efb)return;if(!_0x552efb[_0x35dd04(0x27c)]())return;SceneManager[_0x35dd04(0x20f)]['startMoveFurnitureMode'](_0x552efb);}),PluginManager[_0x2d7466(0x28a)](pluginData[_0x2d7466(0x161)],_0x2d7466(0x2c5),_0x284782=>{const _0x61f979=_0x2d7466;if(!SceneManager[_0x61f979(0x247)]())return;if(!SceneManager[_0x61f979(0x1a4)]())return;const _0x17ff12=_0x284782[_0x61f979(0x2b0)],_0x73c2b1=_0x284782[_0x61f979(0x2f0)],_0x2e84d4=$gameMap['eventsXy'](_0x17ff12,_0x73c2b1);if(_0x2e84d4[_0x61f979(0x1ad)]<=0x0)return;const _0x246526=_0x2e84d4[0x0];if(!_0x246526)return;if(!_0x246526['isSpawnedFurniture']())return;const _0x4374c6=_0x246526['_furnitureSystemSettings'],_0x4f13db=_0x4374c6[_0x61f979(0x174)],_0x18360b=$dataItems[_0x4f13db];if(_0x18360b&&_0x18360b[_0x61f979(0x313)]){if(_0x61f979(0x2b9)!==_0x61f979(0x24e))$gameParty['gainItem'](_0x18360b,0x1);else{const _0x395676=_0x55c753[_0x61f979(0x266)][_0x61f979(0x2e7)](_0x20f7b7,_0x53661f);_0x561548['_spawnData']=_0x395676,this[_0x61f979(0x31f)]=new _0x42cbd3(_0x395676['MapID'],_0x395676[_0x61f979(0x199)]),_0x216a43['_furnitureModeRegisterEvent']=!![],this[_0x61f979(0x31f)][_0x61f979(0x1e1)](_0x395676),_0x1c3830[_0x61f979(0x26d)]=_0x452e90,_0x141d1c[_0x61f979(0x16a)]=_0x47c346,this[_0x61f979(0x31f)]['refresh']();}}$gameMap['despawnEventId'](_0x246526[_0x61f979(0x241)]());}),PluginManager[_0x2d7466(0x28a)](pluginData[_0x2d7466(0x161)],'ThisEventDespawnFurniture',_0x3daa63=>{const _0x5b234b=_0x2d7466;if(!SceneManager['isSceneMap']())return;if(!SceneManager[_0x5b234b(0x1a4)]())return;const _0x4100fc=$gameTemp[_0x5b234b(0x29f)]();if(!_0x4100fc)return;const _0x3a5252=$gameMap[_0x5b234b(0x2b7)](_0x4100fc['eventId']());if(!_0x3a5252)return;$gameMap[_0x5b234b(0x179)](_0x3a5252[_0x5b234b(0x241)]());}),PluginManager[_0x2d7466(0x28a)](pluginData[_0x2d7466(0x161)],_0x2d7466(0x282),_0x2a6b6f=>{const _0x5bd8d7=_0x2d7466;if(!SceneManager[_0x5bd8d7(0x247)]())return;if(!SceneManager[_0x5bd8d7(0x1a4)]())return;if($gameMap[_0x5bd8d7(0x169)]())return;const _0x2898dc=$gameTemp[_0x5bd8d7(0x29f)]();if(!_0x2898dc)return;const _0x44b470=$gameMap[_0x5bd8d7(0x2b7)](_0x2898dc[_0x5bd8d7(0x241)]());if(!_0x44b470)return;if(!_0x44b470[_0x5bd8d7(0x27c)]())return;SceneManager[_0x5bd8d7(0x20f)][_0x5bd8d7(0x1c3)](_0x44b470);}),PluginManager[_0x2d7466(0x28a)](pluginData[_0x2d7466(0x161)],'ThisEventRetrieveFurniture',_0x4da3b8=>{const _0x4f7c77=_0x2d7466;if(!SceneManager[_0x4f7c77(0x247)]())return;if(!SceneManager[_0x4f7c77(0x1a4)]())return;const _0x78d030=$gameTemp['getLastPluginCommandInterpreter']();if(!_0x78d030)return;const _0x1820b2=$gameMap[_0x4f7c77(0x2b7)](_0x78d030[_0x4f7c77(0x241)]());if(!_0x1820b2)return;if(!_0x1820b2[_0x4f7c77(0x27c)]())return;const _0x1ba3a8=_0x1820b2[_0x4f7c77(0x223)],_0x92e5c2=_0x1ba3a8[_0x4f7c77(0x174)],_0xb70bed=$dataItems[_0x92e5c2];_0xb70bed&&_0xb70bed[_0x4f7c77(0x313)]&&$gameParty[_0x4f7c77(0x1be)](_0xb70bed,0x1),$gameMap['despawnEventId'](_0x1820b2[_0x4f7c77(0x241)]());}),VisuMZ['FurnitureSystem'][_0x2d7466(0x2a5)]={'FurnitureTemplates':/<FURNITURE (?:TEMPLATE|TEMPLATES):[ ](.*)>/i,'FurnitureAllowRegions':/<FURNITURE (?:ALLOW|ALLOWED) (?:REGION|REGIONS):[ ](.*)>/i,'FurnitureForbidRegions':/<FURNITURE (?:FORBID|FORBIDDEN) (?:REGION|REGIONS):[ ](.*)>/i,'FurnitureAllowTerrainTags':/<FURNITURE (?:ALLOW|ALLOWED) TERRAIN (?:TAG|TAGS):[ ](.*)>/i,'FurnitureForbidTerrainTags':/<FURNITURE (?:FORBID|FORBIDDEN) TERRAIN (?:TAG|TAGS):[ ](.*)>/i,'FurnitureNeedPassability':/<FURNITURE NEED PASSABILITY>/i,'FurnitureFreePassability':/<FURNITURE FREE PASSABILITY>/i,'FurnitureNeedEventCollisionCheck':/<FURNITURE CHECK EVENT COLLISION>/i,'FurnitureFreeEventCollisionCheck':/<FURNITURE ALLOW EVENT STACKING>/i,'FurnitureOnPlaceCommonEvent':/<FURNITURE PLACE COMMON EVENT:[ ](\d+)>/i,'FurnitureOnPlaceEndOnce':/<FURNITURE PLACE ONCE>/i,'FurnitureOnPlaceEndless':/<FURNITURE PLACE UNTIL EMPTY>/i,'FurniturePreventCancelExit':/<FURNITURE PREVENT CANCEL EXIT>/i,'FurnitureNotMovable':/<FURNITURE NOT MOVABLE>/i,'DisallowFurniture':/<NO FURNITURE>/i,'AllowFurniture':/<ALLOW FURNITURE>/i},DataManager['isFurnitureItem']=function(_0x48cf94){const _0x221ad4=_0x2d7466;if(!_0x48cf94)return![];if(!DataManager['isItem'](_0x48cf94))return![];const _0x1dc185=VisuMZ[_0x221ad4(0x266)][_0x221ad4(0x2a5)],_0x201902=_0x48cf94[_0x221ad4(0x144)];if(_0x201902['match'](_0x1dc185[_0x221ad4(0x147)]))return!![];return![];},SoundManager[_0x2d7466(0x237)]=function(){const _0x5aba9b=_0x2d7466,_0x1b2c11=VisuMZ[_0x5aba9b(0x266)][_0x5aba9b(0x1ca)]['Sound'],_0x205eeb=_0x5aba9b(0x27d),_0x383a49={'name':_0x1b2c11[_0x5aba9b(0x175)['format'](_0x205eeb)],'volume':_0x1b2c11[_0x5aba9b(0x1e5)[_0x5aba9b(0x301)](_0x205eeb)],'pitch':_0x1b2c11[_0x5aba9b(0x159)[_0x5aba9b(0x301)](_0x205eeb)],'pan':_0x1b2c11[_0x5aba9b(0x1ed)[_0x5aba9b(0x301)](_0x205eeb)]};AudioManager[_0x5aba9b(0x273)](_0x383a49);},SoundManager['playMoveFurnitureSound']=function(){const _0x1a090f=_0x2d7466,_0x5ec869=VisuMZ[_0x1a090f(0x266)][_0x1a090f(0x1ca)][_0x1a090f(0x213)],_0x3d5d99=_0x1a090f(0x2ea),_0x2297b4={'name':_0x5ec869[_0x1a090f(0x175)[_0x1a090f(0x301)](_0x3d5d99)],'volume':_0x5ec869[_0x1a090f(0x1e5)[_0x1a090f(0x301)](_0x3d5d99)],'pitch':_0x5ec869['%1Pitch'[_0x1a090f(0x301)](_0x3d5d99)],'pan':_0x5ec869['%1Pant'[_0x1a090f(0x301)](_0x3d5d99)]};AudioManager['playSe'](_0x2297b4);},TextManager['FurnitureSystem']={'PositionButtons':VisuMZ[_0x2d7466(0x266)][_0x2d7466(0x1ca)]['Window'][_0x2d7466(0x234)],'VariantButtons':VisuMZ[_0x2d7466(0x266)][_0x2d7466(0x1ca)][_0x2d7466(0x1fe)]['VariantButtons'],'ConfirmButtons':VisuMZ[_0x2d7466(0x266)]['Settings'][_0x2d7466(0x1fe)]['ConfirmButtons'],'CancelButtons':VisuMZ[_0x2d7466(0x266)]['Settings'][_0x2d7466(0x1fe)][_0x2d7466(0x298)],'PositionText':VisuMZ[_0x2d7466(0x266)][_0x2d7466(0x1ca)][_0x2d7466(0x1fe)][_0x2d7466(0x27b)],'VariantText':VisuMZ[_0x2d7466(0x266)][_0x2d7466(0x1ca)][_0x2d7466(0x1fe)]['VariantText'],'ConfirmText':VisuMZ['FurnitureSystem'][_0x2d7466(0x1ca)][_0x2d7466(0x1fe)][_0x2d7466(0x1cc)],'CancelText':VisuMZ['FurnitureSystem'][_0x2d7466(0x1ca)][_0x2d7466(0x1fe)][_0x2d7466(0x249)]},SceneManager['isSceneMap']=function(){const _0x3bcc67=_0x2d7466;return this[_0x3bcc67(0x20f)]&&this[_0x3bcc67(0x20f)]['constructor']===Scene_Map;},SceneManager[_0x2d7466(0x17d)]=function(){const _0x511a79=_0x2d7466;return this[_0x511a79(0x20f)]&&this['_scene'][_0x511a79(0x26a)]===Scene_Item;},SceneManager[_0x2d7466(0x1a4)]=function(){const _0x16d81a=_0x2d7466;if($gameParty[_0x16d81a(0x253)]())return![];return $gameMap&&$gameMap[_0x16d81a(0x2d4)]()&&(this['isSceneMap']()||this[_0x16d81a(0x17d)]());},VisuMZ[_0x2d7466(0x266)][_0x2d7466(0x26e)]=Game_Action[_0x2d7466(0x1ac)]['isForFriend'],Game_Action[_0x2d7466(0x1ac)][_0x2d7466(0x153)]=function(){const _0x43c9d7=_0x2d7466;if(DataManager['isFurnitureItem'](this['item']())&&SceneManager['canPlaceFurniture']())return![];return VisuMZ[_0x43c9d7(0x266)][_0x43c9d7(0x26e)][_0x43c9d7(0x25d)](this);},Game_Map['DEFAULT_ALLOW_FURNITURE']=VisuMZ[_0x2d7466(0x266)][_0x2d7466(0x1ca)][_0x2d7466(0x25c)][_0x2d7466(0x166)],Game_Map[_0x2d7466(0x19a)]=VisuMZ[_0x2d7466(0x266)][_0x2d7466(0x1ca)][_0x2d7466(0x25c)][_0x2d7466(0x232)],Game_Map['DEFAULT_FURNITURE_FORBID_REGIONS']=VisuMZ[_0x2d7466(0x266)]['Settings'][_0x2d7466(0x25c)]['RegionsForbid'],Game_Map[_0x2d7466(0x24c)]=VisuMZ['FurnitureSystem'][_0x2d7466(0x1ca)][_0x2d7466(0x25c)][_0x2d7466(0x2ac)],Game_Map[_0x2d7466(0x2d2)]=VisuMZ[_0x2d7466(0x266)][_0x2d7466(0x1ca)]['Default'][_0x2d7466(0x24a)],Game_Map[_0x2d7466(0x2aa)]=VisuMZ[_0x2d7466(0x266)]['Settings'][_0x2d7466(0x25c)][_0x2d7466(0x167)],Game_Map[_0x2d7466(0x2ca)]=VisuMZ[_0x2d7466(0x266)][_0x2d7466(0x1ca)][_0x2d7466(0x25c)]['CheckPassability'],Game_Map[_0x2d7466(0x15f)]=VisuMZ[_0x2d7466(0x266)]['Settings']['Default'][_0x2d7466(0x284)],Game_Map[_0x2d7466(0x2ae)]=VisuMZ[_0x2d7466(0x266)][_0x2d7466(0x1ca)][_0x2d7466(0x25c)][_0x2d7466(0x191)],Game_Map[_0x2d7466(0x1ac)][_0x2d7466(0x2d4)]=function(){const _0x11a903=_0x2d7466;if($dataMap){if(_0x11a903(0x1c0)!==_0x11a903(0x1c0)){if(_0x107c59&&_0x66c4b4[_0x11a903(0x169)]())return;_0x471674[_0x11a903(0x266)][_0x11a903(0x17b)][_0x11a903(0x25d)](this);}else{const _0x43ecd4=VisuMZ['FurnitureSystem'][_0x11a903(0x2a5)],_0x2a0f0f=$dataMap[_0x11a903(0x144)];if(_0x2a0f0f[_0x11a903(0x2d7)](_0x43ecd4[_0x11a903(0x280)]))return![];else{if(_0x2a0f0f[_0x11a903(0x2d7)](_0x43ecd4[_0x11a903(0x228)])){if('NFEbo'!=='sGXon')return!![];else{const _0x25174f=_0x3c92df[_0x11a903(0x20f)]['_furnitureCancelButton'];if(_0x25174f&&_0x25174f['isBeingTouched']())return;if(_0x5056de[_0x11a903(0x264)]('ok')||_0xb9fb50['isReleased']()){const _0x4db8c0=_0x3f63f1['isTriggered']('ok');if(this[_0x11a903(0x1a4)](_0x4db8c0)){_0x42bec1[_0x11a903(0x237)](),this[_0x11a903(0x1ce)](_0x4db8c0),_0x4bacab['clear']();const _0x445a07=_0x342dca['x'],_0x3f380c=_0x12b106['y'];_0x1adca8['clear'](),_0x591c09['_x']=_0x445a07,_0x5b3303['_y']=_0x3f380c;}else _0x5b8507['playBuzzer']();}}}}return Game_Map[_0x11a903(0x290)];}}else return![];},VisuMZ[_0x2d7466(0x266)]['extractFurnitureTemplates']=function(_0x3115be){const _0x5d07b8=_0x2d7466,_0x2f31cf=VisuMZ[_0x5d07b8(0x266)]['RegExp'],_0x20eda1=_0x3115be[_0x5d07b8(0x144)];let _0x4dd4de=[];return _0x20eda1[_0x5d07b8(0x2d7)](_0x2f31cf['FurnitureTemplates'])&&(_0x4dd4de=RegExp['$1'][_0x5d07b8(0x14d)](',')[_0x5d07b8(0x2cf)](_0x260207=>_0x260207[_0x5d07b8(0x2b1)]()[_0x5d07b8(0x2c4)]())),_0x4dd4de=VisuMZ['FurnitureSystem']['PurgeNonTemplateData'](_0x4dd4de),_0x4dd4de;},VisuMZ['FurnitureSystem'][_0x2d7466(0x2cc)]=function(_0x5d5313){const _0x5460b7=_0x2d7466,_0x167b3c=VisuMZ[_0x5460b7(0x266)][_0x5460b7(0x2a5)],_0xcf1de0=_0x5d5313['note'];let _0x58764f={'AllowRegions':Game_Map[_0x5460b7(0x19a)]['clone'](),'ForbidRegions':Game_Map['DEFAULT_FURNITURE_FORBID_REGIONS'][_0x5460b7(0x2de)](),'AllowTerrainTags':Game_Map['DEFAULT_FURNITURE_ALLOW_TERRAIN_TAGS'][_0x5460b7(0x2de)](),'ForbidTerrainTags':Game_Map[_0x5460b7(0x2d2)]['clone'](),'CheckPassability':Game_Map['DEFAULT_FURNITURE_CHECK_PASSABILITY'],'CheckEventCollision':Game_Map[_0x5460b7(0x2aa)],'OnPlaceCommonEventID':Game_Map[_0x5460b7(0x15f)],'OnPlaceEndMode':Game_Map['DEFAULT_FURNITURE_END_MODE_ON_PLACE'],'OnPlaceConsumeItem':_0x5d5313['id'],'PreventCancelExit':![]};_0xcf1de0[_0x5460b7(0x2d7)](_0x167b3c[_0x5460b7(0x2a9)])&&(_0x58764f['AllowRegions']=RegExp['$1'][_0x5460b7(0x14d)](',')[_0x5460b7(0x2cf)](_0x42ad3e=>Number(_0x42ad3e)[_0x5460b7(0x209)](0x1,0xff)));if(_0xcf1de0['match'](_0x167b3c[_0x5460b7(0x2e5)])){if(_0x5460b7(0x18c)!==_0x5460b7(0x18c)){const _0x291af8=this[_0x5460b7(0x2c1)]();this[_0x5460b7(0x207)]=new _0x76d78b(_0x291af8),this['addChild'](this['_furnitureHelpWindow']);}else _0x58764f['ForbidRegions']=RegExp['$1'][_0x5460b7(0x14d)](',')['map'](_0x25355f=>Number(_0x25355f)[_0x5460b7(0x209)](0x1,0xff));}_0xcf1de0[_0x5460b7(0x2d7)](_0x167b3c['FurnitureAllowTerrainTags'])&&(_0x58764f['AllowTerrainTags']=RegExp['$1'][_0x5460b7(0x14d)](',')[_0x5460b7(0x2cf)](_0x74cb84=>Number(_0x74cb84)[_0x5460b7(0x209)](0x1,0xff)));_0xcf1de0[_0x5460b7(0x2d7)](_0x167b3c[_0x5460b7(0x2ab)])&&(_0x58764f['ForbidTerrainTags']=RegExp['$1'][_0x5460b7(0x14d)](',')['map'](_0x2b4d5d=>Number(_0x2b4d5d)[_0x5460b7(0x209)](0x1,0xff)));if(_0xcf1de0[_0x5460b7(0x2d7)](_0x167b3c['FurnitureNeedPassability']))_0x58764f[_0x5460b7(0x2c3)]=!![];else{if(_0xcf1de0[_0x5460b7(0x2d7)](_0x167b3c[_0x5460b7(0x1de)])){if(_0x5460b7(0x1f1)!==_0x5460b7(0x1bf))_0x58764f[_0x5460b7(0x2c3)]=![];else{this['changePaintOpacity'](this[_0x5460b7(0x1d2)]());const _0x3277e2=_0x1b5a64[_0x5460b7(0x266)][_0x5460b7(0x31b)],_0x55e0a1=_0x1a975b[_0x5460b7(0x266)]['VariantText'],_0x58554f=this[_0x5460b7(0x171)](_0x3277e2)[_0x5460b7(0x30f)],_0x863194=this['textSizeEx'](_0x55e0a1)['width'],_0x147e55=this[_0x5460b7(0x243)]();this[_0x5460b7(0x31a)](_0x3277e2,_0x35262a-_0x58554f-_0x53ef3d,_0x147e55,_0x58554f),this[_0x5460b7(0x31a)](_0x55e0a1,_0x118dd4+_0x1bf15a,_0x147e55,_0x863194);}}}if(_0xcf1de0[_0x5460b7(0x2d7)](_0x167b3c[_0x5460b7(0x231)])){if('vXLNl'!=='vXLNl'){if(_0x43691f[_0x5460b7(0x247)]()&&_0x519508&&_0x54262c[_0x5460b7(0x169)]())return!![];}else _0x58764f['CheckEventCollision']=!![];}else _0xcf1de0[_0x5460b7(0x2d7)](_0x167b3c['FurnitureFreeEventCollisionCheck'])&&(_0x58764f[_0x5460b7(0x167)]=![]);if(_0xcf1de0[_0x5460b7(0x2d7)](_0x167b3c[_0x5460b7(0x288)])){if(_0x5460b7(0x2f8)!==_0x5460b7(0x2f8)){if(!_0x182b2a[_0x5460b7(0x247)]())return;if(!_0x434661[_0x5460b7(0x1a4)]())return;const _0x1c0748=_0x54c8ec[_0x5460b7(0x29f)]();if(!_0x1c0748)return;const _0x384002=_0x366cd1['event'](_0x1c0748[_0x5460b7(0x241)]());if(!_0x384002)return;if(!_0x384002['isSpawnedFurniture']())return;const _0xeb841f=_0x384002[_0x5460b7(0x223)],_0x122155=_0xeb841f[_0x5460b7(0x174)],_0x3ae3d3=_0x564a22[_0x122155];_0x3ae3d3&&_0x3ae3d3[_0x5460b7(0x313)]&&_0xf8144[_0x5460b7(0x1be)](_0x3ae3d3,0x1),_0x38f02c[_0x5460b7(0x179)](_0x384002[_0x5460b7(0x241)]());}else _0x58764f[_0x5460b7(0x21d)]=Number(RegExp['$1']);}if(_0xcf1de0[_0x5460b7(0x2d7)](_0x167b3c[_0x5460b7(0x143)]))_0x58764f[_0x5460b7(0x295)]=!![];else _0xcf1de0[_0x5460b7(0x2d7)](_0x167b3c[_0x5460b7(0x165)])&&(_0x58764f[_0x5460b7(0x295)]=![]);if(_0xcf1de0['match'](_0x167b3c['FurniturePreventCancelExit'])){_0x58764f[_0x5460b7(0x305)]=!![];const _0xb436b9=$dataItems[_0x58764f['OnPlaceConsumeItem']];if(!_0x58764f[_0x5460b7(0x295)]&&(!_0xb436b9||!_0xb436b9['consumable'])){_0x58764f[_0x5460b7(0x305)]=![];if($gameTemp[_0x5460b7(0x276)]()){if(!$gameTemp[_0x5460b7(0x17f)]){$gameTemp['_furnitureModeAntiSoftlockAlert']=!![];let _0x54ec5a=_0x5460b7(0x238);alert(_0x54ec5a);}}}}return _0x58764f;},VisuMZ[_0x2d7466(0x266)][_0x2d7466(0x19c)]=function(_0x2fdf16){const _0x17d649=_0x2d7466;return _0x2fdf16[_0x17d649(0x176)](_0x246d92=>!!VisuMZ[_0x17d649(0x1e2)][_0x246d92]);},Game_Map[_0x2d7466(0x1ac)][_0x2d7466(0x304)]=function(_0xdeacf4,_0x296d80,_0x45e0b1){const _0xaf2def=_0x2d7466;this[_0xaf2def(0x1f5)]=$gameTemp['_furnitureSystemTemplateIndex']||0x0,this['_furnitureSystemTemplates']=_0xdeacf4[_0xaf2def(0x2de)](),this['_furnitureSystemSettings']=JsonEx[_0xaf2def(0x1ff)](_0x296d80),this[_0xaf2def(0x272)]={'x':Math[_0xaf2def(0x184)]($gamePlayer['x']),'y':Math['round']($gamePlayer['y']),'lastPosX':Math[_0xaf2def(0x184)]($gamePlayer['x']),'lastPosY':Math[_0xaf2def(0x184)]($gamePlayer['y']),'lastCursorX':TouchInput['x'],'lastCursorY':TouchInput['y']};if(_0x45e0b1){const _0x2c0317=$gamePlayer[_0xaf2def(0x2ff)]();if([0x7,0x4,0x1][_0xaf2def(0x279)](_0x2c0317))this[_0xaf2def(0x272)]['x']-=0x1;if([0x9,0x6,0x3][_0xaf2def(0x279)](_0x2c0317))this[_0xaf2def(0x272)]['x']+=0x1;if([0x7,0x8,0x9][_0xaf2def(0x279)](_0x2c0317))this['_furnitureSystemEventPosition']['y']-=0x1;if([0x1,0x2,0x3][_0xaf2def(0x279)](_0x2c0317))this['_furnitureSystemEventPosition']['y']+=0x1;this[_0xaf2def(0x272)][_0xaf2def(0x1bb)]=this[_0xaf2def(0x272)]['x'],this[_0xaf2def(0x272)][_0xaf2def(0x267)]=this[_0xaf2def(0x272)]['y'];}},VisuMZ[_0x2d7466(0x266)][_0x2d7466(0x2e7)]=function(_0x30dc0f,_0x195b29){const _0x2bef2e=_0x2d7466,_0x4259b0=$gameMap[_0x2bef2e(0x22f)](),_0x4fe498={'template':_0x30dc0f[$gameMap[_0x2bef2e(0x1f5)]],'mapId':_0x4259b0['MapID'],'eventId':_0x4259b0[_0x2bef2e(0x199)],'x':$gameMap[_0x2bef2e(0x272)]['x'],'y':$gameMap[_0x2bef2e(0x272)]['y'],'spawnPreserved':![],'spawnEventId':$gameMap[_0x2bef2e(0x316)][_0x2bef2e(0x1ad)]+0x3e8};return _0x4fe498;},Game_Map[_0x2d7466(0x1ac)][_0x2d7466(0x1ab)]=function(_0x1247c3,_0x2578cb){const _0xfe325a=_0x2d7466,_0x1881ad=VisuMZ[_0xfe325a(0x266)]['CreateSpawnData'](_0x1247c3,_0x2578cb);$gameTemp['_spawnData']=_0x1881ad,this['_furnitureSystemEvent']=new Game_Event(_0x1881ad[_0xfe325a(0x1fa)],_0x1881ad[_0xfe325a(0x199)]),$gameTemp[_0xfe325a(0x26d)]=!![],this[_0xfe325a(0x31f)][_0xfe325a(0x1e1)](_0x1881ad),$gameTemp[_0xfe325a(0x26d)]=undefined,$gameTemp[_0xfe325a(0x16a)]=undefined,this[_0xfe325a(0x31f)][_0xfe325a(0x2f9)]();},VisuMZ[_0x2d7466(0x266)][_0x2d7466(0x222)]=function(){const _0x4f3a54=_0x2d7466;SceneManager[_0x4f3a54(0x20f)][_0x4f3a54(0x195)]&&SceneManager[_0x4f3a54(0x20f)][_0x4f3a54(0x195)][_0x4f3a54(0x2d3)]&&SceneManager[_0x4f3a54(0x20f)][_0x4f3a54(0x195)][_0x4f3a54(0x2d3)][_0x4f3a54(0x1eb)]();const _0x302036=SceneManager[_0x4f3a54(0x20f)]['_furnitureHelpWindow'];if(_0x302036)_0x302036[_0x4f3a54(0x2f9)]();VisuMZ['FurnitureSystem'][_0x4f3a54(0x31e)]();},VisuMZ[_0x2d7466(0x266)][_0x2d7466(0x31e)]=function(){const _0x473428=_0x2d7466;if(SceneManager[_0x473428(0x20f)][_0x473428(0x195)]){if(_0x473428(0x327)!==_0x473428(0x198)){const _0x38c6fe=SceneManager[_0x473428(0x20f)][_0x473428(0x195)]['_furnitureEventSprite'];if(_0x38c6fe)_0x38c6fe[_0x473428(0x2ba)]();}else _0x31cc2d[_0x473428(0x1be)](_0x53fbb2,0x1);}},VisuMZ['FurnitureSystem'][_0x2d7466(0x163)]=function(_0x49db15,_0x3ab1b9){const _0x245e32=_0x2d7466,_0x124364=$gameMap[_0x245e32(0x1d8)](),_0x284d00=$gameMap['furnitureEventTemplateName'](),_0x514bfc=VisuMZ['EventTemplates'][_0x284d00],_0x3c95de={'template':_0x284d00,'mapId':_0x514bfc[_0x245e32(0x1fa)],'eventId':_0x514bfc[_0x245e32(0x199)],'x':_0x49db15,'y':_0x3ab1b9,'spawnPreserved':!![],'spawnEventId':$gameMap[_0x245e32(0x316)][_0x245e32(0x1ad)]+0x3e8};let _0x3a27b6=_0x124364[_0x245e32(0x2c3)];if(_0x124364[_0x245e32(0x277)]['length']>0x0||_0x124364['AllowTerrainTags'][_0x245e32(0x1ad)]>0x0){if(_0x245e32(0x2b2)===_0x245e32(0x299)){const _0x11796a=_0x1f5997[_0x245e32(0x2ff)]();if([0x7,0x4,0x1][_0x245e32(0x279)](_0x11796a))this[_0x245e32(0x272)]['x']-=0x1;if([0x9,0x6,0x3]['includes'](_0x11796a))this['_furnitureSystemEventPosition']['x']+=0x1;if([0x7,0x8,0x9][_0x245e32(0x279)](_0x11796a))this[_0x245e32(0x272)]['y']-=0x1;if([0x1,0x2,0x3]['includes'](_0x11796a))this[_0x245e32(0x272)]['y']+=0x1;this[_0x245e32(0x272)][_0x245e32(0x1bb)]=this[_0x245e32(0x272)]['x'],this['_furnitureSystemEventPosition']['lastPosY']=this[_0x245e32(0x272)]['y'];}else _0x3a27b6=![];}const _0x28ade6=$gameMap[_0x245e32(0x2ce)](_0x3c95de,_0x124364[_0x245e32(0x167)],_0x3a27b6),_0x1fc6bf=$gameMap['lastSpawnedEvent']();return _0x1fc6bf[_0x245e32(0x2f3)](),_0x28ade6;},Game_Map[_0x2d7466(0x1ac)][_0x2d7466(0x169)]=function(){const _0x4a0170=_0x2d7466;return this[_0x4a0170(0x25e)]&&this[_0x4a0170(0x25e)][_0x4a0170(0x1ad)]>0x0;},Game_Map[_0x2d7466(0x1ac)][_0x2d7466(0x162)]=function(_0x16ab46){const _0x12e38a=_0x2d7466,_0x4ffcda=VisuMZ[_0x12e38a(0x266)][_0x12e38a(0x187)](_0x16ab46),_0x5bf95f=VisuMZ['FurnitureSystem']['extractFurnitureSettings'](_0x16ab46);this[_0x12e38a(0x29a)](_0x4ffcda,_0x5bf95f);},Game_Map[_0x2d7466(0x1ac)]['startFurnitureSystemMode']=function(_0x27d7b9,_0x5b9b04){const _0x471066=_0x2d7466;_0x27d7b9=VisuMZ[_0x471066(0x266)][_0x471066(0x19c)](_0x27d7b9);if(_0x27d7b9['length']<=0x0)return;this['setupFurnitureData'](_0x27d7b9,_0x5b9b04,!![]),this['setupFurnitureCursor'](_0x27d7b9,_0x5b9b04),VisuMZ[_0x471066(0x266)][_0x471066(0x222)]();},Game_Map['prototype']['endFurnitureSystemMode']=function(){const _0x3f75ec=_0x2d7466;this[_0x3f75ec(0x1f5)]=undefined,this['_furnitureSystemTemplates']=undefined,this[_0x3f75ec(0x223)]=undefined,this['_furnitureSystemEventPosition']=undefined,this[_0x3f75ec(0x31f)]=undefined;},Game_Map['prototype'][_0x2d7466(0x1ce)]=function(_0x86f76a){const _0x5cff38=_0x2d7466;this[_0x5cff38(0x20e)](_0x86f76a);const _0x239b88=this['furnitureSettings']();if(_0x239b88[_0x5cff38(0x295)]){this[_0x5cff38(0x1f6)]();if(_0x239b88['OnPlaceConsumeItem']>0x0){if(_0x5cff38(0x17a)!==_0x5cff38(0x1b8)){const _0x49db64=$dataItems[_0x239b88[_0x5cff38(0x174)]];$gameParty[_0x5cff38(0x2e3)](_0x49db64);}else{const _0x3af4cc=_0xbe8894['FurnitureSystem'][_0x5cff38(0x2a5)],_0x32b500=_0x558b96[_0x5cff38(0x144)];if(_0x32b500[_0x5cff38(0x2d7)](_0x3af4cc[_0x5cff38(0x280)]))return![];else{if(_0x32b500[_0x5cff38(0x2d7)](_0x3af4cc['AllowFurniture']))return!![];}return _0x2b8ada['DEFAULT_ALLOW_FURNITURE'];}}}else{if(_0x239b88['OnPlaceConsumeItem']>0x0){if('AfxpU'!==_0x5cff38(0x154))this[_0x5cff38(0x27e)]();else{const _0x54ddd3=$dataItems[_0x239b88[_0x5cff38(0x174)]];$gameParty[_0x5cff38(0x2e3)](_0x54ddd3),$gameParty[_0x5cff38(0x160)](_0x54ddd3)<=0x0?_0x5cff38(0x25f)!==_0x5cff38(0x15e)?this['endFurnitureSystemMode']():(this[_0x5cff38(0x326)]=_0x39cb80[_0x5cff38(0x174)],this['refresh']()):VisuMZ[_0x5cff38(0x266)][_0x5cff38(0x293)]();}}}},Game_Map[_0x2d7466(0x1ac)][_0x2d7466(0x20e)]=function(_0x2d3393){const _0x41fff3=_0x2d7466;this[_0x41fff3(0x173)](_0x2d3393),this[_0x41fff3(0x2a8)]();},Game_Map['prototype'][_0x2d7466(0x173)]=function(_0xbf2c09){const _0x397835=_0x2d7466,_0x56aa43=this[_0x397835(0x172)](_0xbf2c09),_0x178ca7=_0x56aa43['x'],_0x546e7d=_0x56aa43['y'];return VisuMZ[_0x397835(0x266)][_0x397835(0x163)](_0x178ca7,_0x546e7d);},Game_Map['prototype']['onPlaceFurnitureRunCommonEvent']=function(){const _0x200046=_0x2d7466,_0x155497=this[_0x200046(0x223)],_0x2f45a8=_0x155497[_0x200046(0x21d)],_0x497ebd=$gameMap['lastSpawnedEvent']()[_0x200046(0x241)]();if(_0x2f45a8){if('XGKhn'!==_0x200046(0x1e0)){_0x267334=_0x26aae2[_0x200046(0x266)][_0x200046(0x19c)](_0x4c40e4);if(_0x13f163[_0x200046(0x1ad)]<=0x0)return;this[_0x200046(0x304)](_0x1898dd,_0x58aed7,!![]),this[_0x200046(0x1ab)](_0x25176d,_0x4e2396),_0x4fd288[_0x200046(0x266)][_0x200046(0x222)]();}else{const _0x130efa=$dataCommonEvents[_0x2f45a8];if(_0x130efa){if(_0x200046(0x2d6)!=='POlXZ')_0x56a1bf(_0x200046(0x268)[_0x200046(0x301)](_0x1e1f6b,_0x38fb48)),_0x382e92[_0x200046(0x2af)]();else{if(_0x155497['OnPlaceEndMode']){if('Vrrqt'===_0x200046(0x2db)){if(_0x15e7ec[_0x200046(0x26d)])return;_0x32cfeb[_0x200046(0x266)][_0x200046(0x18e)]['call'](this,_0x4cb87a);}else this[_0x200046(0x21c)]&&this[_0x200046(0x21c)][_0x200046(0x1cf)]()?_0x200046(0x22d)===_0x200046(0x2d0)?(this[_0x200046(0x1e6)]='',this['_mouseMode']=![],_0x3e301e[_0x200046(0x1ac)][_0x200046(0x219)][_0x200046(0x25d)](this,null),this[_0x200046(0x151)]()):this[_0x200046(0x21c)][_0x200046(0x1aa)](_0x130efa[_0x200046(0x233)],_0x497ebd):($gameTemp[_0x200046(0x155)](_0x2f45a8),this['_interpreter'][_0x200046(0x2a2)](),this[_0x200046(0x21c)][_0x200046(0x270)]=_0x497ebd);}else{if(_0x200046(0x2d9)===_0x200046(0x324))this[_0x200046(0x219)](...arguments);else{SceneManager[_0x200046(0x20f)][_0x200046(0x1a8)](_0x2f45a8);const _0x31f57d=SceneManager['_scene']['_onceParallelInterpreters'];if(_0x31f57d&&_0x31f57d[_0x200046(0x1ad)]>0x0){const _0xfe76f5=_0x31f57d[_0x31f57d['length']-0x1];_0xfe76f5[_0x200046(0x270)]=_0x497ebd;}}}}}}}},VisuMZ[_0x2d7466(0x266)][_0x2d7466(0x293)]=function(){const _0x4d351c=_0x2d7466,_0x3f3248=SceneManager[_0x4d351c(0x20f)],_0x3744a9=_0x3f3248[_0x4d351c(0x1d0)];if(_0x3744a9){if(_0x4d351c(0x291)!==_0x4d351c(0x291))return![];else _0x3744a9[_0x4d351c(0x2f9)]();}},Game_Map['prototype'][_0x2d7466(0x164)]=function(_0x222e99,_0x1181f9,_0x543baf,_0xe17bc5){const _0x1bbc2f=_0x2d7466;let _0x3b0069=VisuMZ['FurnitureSystem']['extractFurnitureTemplates'](_0x222e99),_0x57d4d3=VisuMZ[_0x1bbc2f(0x266)]['extractFurnitureSettings'](_0x222e99);_0x3b0069=VisuMZ['FurnitureSystem'][_0x1bbc2f(0x19c)](_0x3b0069),_0x1181f9=_0x1181f9[_0x1bbc2f(0x209)](0x0,_0x3b0069['length']-0x1),this['setupFurnitureData'](_0x3b0069,_0x57d4d3,!![]),this[_0x1bbc2f(0x1ab)](_0x3b0069,_0x57d4d3),this[_0x1bbc2f(0x1f5)]=_0x1181f9,this[_0x1bbc2f(0x15b)]()['x']=_0x543baf,this[_0x1bbc2f(0x15b)]()['y']=_0xe17bc5;const _0xf8bb72=this[_0x1bbc2f(0x173)](!![]);return this[_0x1bbc2f(0x1f6)](),_0xf8bb72;},Game_Map[_0x2d7466(0x1ac)][_0x2d7466(0x259)]=function(_0x10b44d,_0x5c751e,_0x26d146){const _0x224708=_0x2d7466;let _0x168a1b=VisuMZ['FurnitureSystem'][_0x224708(0x187)](_0x10b44d),_0x4beabd=VisuMZ[_0x224708(0x266)]['extractFurnitureSettings'](_0x10b44d);_0x168a1b=VisuMZ[_0x224708(0x266)][_0x224708(0x19c)](_0x168a1b),_0x5c751e=_0x5c751e['clamp'](0x0,_0x168a1b[_0x224708(0x1ad)]-0x1),this['setupFurnitureData'](_0x168a1b,_0x4beabd,!![]),this[_0x224708(0x1ab)](_0x168a1b,_0x4beabd),this[_0x224708(0x1f5)]=_0x5c751e,this['furnitureEvent']()[_0x224708(0x2f9)]();const _0x2b1596=this[_0x224708(0x1f9)]()[_0x224708(0x16b)],_0x122f3d=VisuMZ[_0x224708(0x266)]['CreateSpawnData'](_0x168a1b,_0x4beabd),_0x2baa51=this[_0x224708(0x218)](_0x26d146,_0x122f3d,_0x2b1596,_0x4beabd);if(_0x2baa51[_0x224708(0x1ad)]<=0x0){if(_0x224708(0x227)!==_0x224708(0x227))_0x1a7b1a['OnPlaceEndMode']=![];else return this[_0x224708(0x1f6)](),![];}const _0x3126e5=_0x2baa51[Math[_0x224708(0x236)](_0x2baa51[_0x224708(0x1ad)])],_0x1a2578=_0x3126e5[0x0]||0x0,_0x8d6456=_0x3126e5[0x1]||0x0;this[_0x224708(0x15b)]()['x']=_0x1a2578,this[_0x224708(0x15b)]()['y']=_0x8d6456;const _0x3eb7f1=this['onPlaceFurnitureSpawnEvent'](!![]);return this[_0x224708(0x1f6)](),_0x3eb7f1;},Game_Map['prototype'][_0x2d7466(0x218)]=function(_0xfebbf2,_0xa977cd,_0x55fd03,_0x1b6bb6){const _0x21f373=_0x2d7466,_0x382ac4=[],_0x3611e2=this['width'](),_0x55d9ef=this[_0x21f373(0x16d)]();let _0x532ddf=_0x1b6bb6[_0x21f373(0x2c3)];(_0x1b6bb6[_0x21f373(0x277)]['length']>0x0||_0x1b6bb6[_0x21f373(0x25a)][_0x21f373(0x1ad)]>0x0)&&(_0x532ddf=![]);const _0x450a96=_0x55fd03[_0x21f373(0x142)],_0x37bea5=_0x3611e2-_0x55fd03[_0x21f373(0x262)],_0x309793=_0x55fd03['up'],_0x1b21f5=_0x55d9ef-_0x55fd03[_0x21f373(0x1b5)];for(let _0x50e52e=_0x450a96;_0x50e52e<_0x37bea5;_0x50e52e++){for(let _0xef17ed=_0x309793;_0xef17ed<_0x1b21f5;_0xef17ed++){if(!_0xfebbf2[_0x21f373(0x279)](this['regionId'](_0x50e52e,_0xef17ed)))continue;if(!this[_0x21f373(0x1c2)](_0x50e52e,_0xef17ed))continue;if(_0x1b6bb6[_0x21f373(0x167)]){if(this['checkExistingEntitiesAt'](_0x50e52e,_0xef17ed))continue;if(!this[_0x21f373(0x254)](_0xa977cd,_0x50e52e,_0xef17ed))continue;}if(_0x532ddf){if('cLQJT'===_0x21f373(0x325)){if(!this[_0x21f373(0x28f)](_0x50e52e,_0xef17ed))continue;}else{const _0x18cd07=_0x53f220(_0xe6bfa4['$1']);_0x18cd07<_0x1bc17d?(_0x383d26(_0x21f373(0x14c)[_0x21f373(0x301)](_0x787468,_0x18cd07,_0x5e3e02)),_0x51dc5a[_0x21f373(0x2af)]()):_0x1e8ec2=_0x5fe9fb[_0x21f373(0x23b)](_0x18cd07,_0x16f094);}}_0x382ac4['push']([_0x50e52e,_0xef17ed]);}}return _0x382ac4;},Game_Map[_0x2d7466(0x1ac)][_0x2d7466(0x145)]=function(_0x595d4c,_0x4b992d,_0x35275b){const _0x37b762=_0x2d7466;let _0x2835b1=VisuMZ[_0x37b762(0x266)][_0x37b762(0x187)](_0x595d4c),_0x4896c8=VisuMZ[_0x37b762(0x266)][_0x37b762(0x2cc)](_0x595d4c);_0x2835b1=VisuMZ['FurnitureSystem'][_0x37b762(0x19c)](_0x2835b1),_0x4b992d=_0x4b992d['clamp'](0x0,_0x2835b1['length']-0x1),this['setupFurnitureData'](_0x2835b1,_0x4896c8,!![]),this['setupFurnitureCursor'](_0x2835b1,_0x4896c8),this[_0x37b762(0x1f5)]=_0x4b992d,this['furnitureEvent']()['refresh']();const _0x49d871=this[_0x37b762(0x1f9)]()[_0x37b762(0x16b)],_0x5c992d=VisuMZ[_0x37b762(0x266)][_0x37b762(0x2e7)](_0x2835b1,_0x4896c8),_0x34790b=this[_0x37b762(0x29e)](_0x35275b,_0x5c992d,_0x49d871,_0x4896c8);if(_0x34790b[_0x37b762(0x1ad)]<=0x0)return this[_0x37b762(0x1f6)](),![];const _0x486061=_0x34790b[Math[_0x37b762(0x236)](_0x34790b[_0x37b762(0x1ad)])],_0x70229a=_0x486061[0x0]||0x0,_0x55317a=_0x486061[0x1]||0x0;this[_0x37b762(0x15b)]()['x']=_0x70229a,this[_0x37b762(0x15b)]()['y']=_0x55317a;const _0x5e4e42=this['onPlaceFurnitureSpawnEvent'](!![]);return this['endFurnitureSystemMode'](),_0x5e4e42;},Game_Map[_0x2d7466(0x1ac)]['getSpawnPointsWithTerrainTags']=function(_0x517670,_0xe37f0d,_0x49b2f4,_0x46859c){const _0x3cad79=_0x2d7466,_0x44ceab=[],_0x43d102=this[_0x3cad79(0x30f)](),_0x6f4e60=this[_0x3cad79(0x16d)]();let _0x286f85=_0x46859c[_0x3cad79(0x2c3)];(_0x46859c['AllowRegions'][_0x3cad79(0x1ad)]>0x0||_0x46859c['AllowTerrainTags']['length']>0x0)&&(_0x3cad79(0x212)===_0x3cad79(0x212)?_0x286f85=![]:(_0x53d06b[_0x3cad79(0x162)](this[_0x3cad79(0x271)]()),this['startFadeOut'](this[_0x3cad79(0x2a7)](),![]),_0x228b22[_0x3cad79(0x203)](_0x13973a)));const _0x47c004=_0x49b2f4['left'],_0x3d785b=_0x43d102-_0x49b2f4['right'],_0x5e9ff0=_0x49b2f4['up'],_0x679068=_0x6f4e60-_0x49b2f4[_0x3cad79(0x1b5)];for(let _0xa19357=_0x47c004;_0xa19357<_0x3d785b;_0xa19357++){for(let _0x44cd70=_0x5e9ff0;_0x44cd70<_0x679068;_0x44cd70++){if(!_0x517670[_0x3cad79(0x279)](this[_0x3cad79(0x255)](_0xa19357,_0x44cd70)))continue;if(!this[_0x3cad79(0x1c2)](_0xa19357,_0x44cd70))continue;if(_0x46859c[_0x3cad79(0x167)]){if(_0x3cad79(0x287)==='GQrOf'){if(this[_0x3cad79(0x322)](_0xa19357,_0x44cd70))continue;if(!this[_0x3cad79(0x254)](_0xe37f0d,_0xa19357,_0x44cd70))continue;}else{if(!_0x4e1a7e[_0x3cad79(0x247)]())return;if(!_0x270c73[_0x3cad79(0x1a4)]())return;const _0x4d9161=_0x2a7f94[_0x3cad79(0x2b0)],_0xa0a54a=_0x572040[_0x3cad79(0x2f0)],_0x38c2fa=_0x3944d8['eventsXy'](_0x4d9161,_0xa0a54a);if(_0x38c2fa[_0x3cad79(0x1ad)]<=0x0)return;const _0x4c58de=_0x38c2fa[0x0];if(!_0x4c58de)return;if(!_0x4c58de['isSpawnedFurniture']())return;const _0x4a1127=_0x4c58de[_0x3cad79(0x223)],_0x403dda=_0x4a1127[_0x3cad79(0x174)],_0x5a8a90=_0x81c807[_0x403dda];_0x5a8a90&&_0x5a8a90[_0x3cad79(0x313)]&&_0x4fed78['gainItem'](_0x5a8a90,0x1),_0x36188b[_0x3cad79(0x179)](_0x4c58de[_0x3cad79(0x241)]());}}if(_0x286f85){if(!this[_0x3cad79(0x28f)](_0xa19357,_0x44cd70))continue;}_0x44ceab[_0x3cad79(0x1fd)]([_0xa19357,_0x44cd70]);}}return _0x44ceab;},Game_Map[_0x2d7466(0x1ac)][_0x2d7466(0x14e)]=function(){const _0x4f6611=_0x2d7466;if(this[_0x4f6611(0x1f5)]===undefined)return'';const _0x567967=this[_0x4f6611(0x1f5)];return this[_0x4f6611(0x25e)][_0x567967]||'';},Game_Map[_0x2d7466(0x1ac)][_0x2d7466(0x22f)]=function(){const _0x3b690b=_0x2d7466,_0x4d6fb4=this[_0x3b690b(0x14e)]();return VisuMZ['EventTemplates'][_0x4d6fb4]||null;},Game_Map[_0x2d7466(0x1ac)]['furnitureEvent']=function(){const _0x565e86=_0x2d7466;return this[_0x565e86(0x31f)]||null;},Game_Map[_0x2d7466(0x1ac)][_0x2d7466(0x15b)]=function(){return this['_furnitureSystemEventPosition'];},Game_Map[_0x2d7466(0x1ac)][_0x2d7466(0x1d8)]=function(){return this['_furnitureSystemSettings']||{};},Game_Map[_0x2d7466(0x1ac)]['updateFurnitureModeInput']=function(){const _0x12eb5c=_0x2d7466;this[_0x12eb5c(0x320)](),this[_0x12eb5c(0x2bc)](),this[_0x12eb5c(0x178)](),this[_0x12eb5c(0x275)]();},Game_Map[_0x2d7466(0x1ac)][_0x2d7466(0x320)]=function(){const _0x42cb7f=_0x2d7466,_0x5086c4=0x14;if(Input['isRepeated']('pageup')||TouchInput[_0x42cb7f(0x2fb)]<=-_0x5086c4)this[_0x42cb7f(0x309)](![]);else(Input['isRepeated']('pagedown')||TouchInput[_0x42cb7f(0x2fb)]>=_0x5086c4)&&this[_0x42cb7f(0x309)](!![]);},Game_Map[_0x2d7466(0x1ac)][_0x2d7466(0x309)]=function(_0x2767ab){const _0x1146a1=_0x2d7466,_0x241fe4=this['_furnitureSystemTemplateIndex'],_0x4857e1=this[_0x1146a1(0x25e)][_0x1146a1(0x1ad)];this[_0x1146a1(0x1f5)]+=_0x2767ab?0x1:-0x1;if(this[_0x1146a1(0x1f5)]<0x0)_0x1146a1(0x328)===_0x1146a1(0x28d)?this['initialize'](...arguments):this['_furnitureSystemTemplateIndex']=_0x4857e1-0x1;else this[_0x1146a1(0x1f5)]>=_0x4857e1&&(this['_furnitureSystemTemplateIndex']=0x0);if(_0x241fe4!==this[_0x1146a1(0x1f5)]){if('szWEU'!==_0x1146a1(0x1dc)){SoundManager['playCursor']();const _0x2c91e5=this[_0x1146a1(0x14e)]();this['furnitureEvent']()['morphIntoTemplate'](_0x2c91e5,!![]);}else{if(_0xf22643&&_0x31cef9['isFurnitureSystemMode']())return![];return _0x3c98df[_0x1146a1(0x266)][_0x1146a1(0x1ec)][_0x1146a1(0x25d)](this);}}},Game_Map[_0x2d7466(0x1ac)][_0x2d7466(0x2bc)]=function(){const _0x47eb2e=_0x2d7466,_0x47f533=this[_0x47eb2e(0x15b)]();Input[_0x47eb2e(0x1c8)]!==0x0&&(_0x47f533[_0x47eb2e(0x19d)]!==TouchInput['x']||_0x47f533['lastCursorY']!==TouchInput['y'])&&(_0x47eb2e(0x323)!==_0x47eb2e(0x323)?(this[_0x47eb2e(0x156)](),this['z']=0xa,this[_0x47eb2e(0x17e)]?(this['x']=_0x2d475a['canvasToMapX'](_0x144b48['x'])[_0x47eb2e(0x209)](0x0,_0x10af50[_0x47eb2e(0x30f)]()-0x1),this['y']=_0x4fe754[_0x47eb2e(0x30e)](_0x4de62b['y'])[_0x47eb2e(0x209)](0x0,_0xf92d84[_0x47eb2e(0x16d)]()-0x1)):(this['x']=_0x5300da[_0x47eb2e(0x15b)]()['x'],this['y']=_0x1eba9e[_0x47eb2e(0x15b)]()['y']),this['x']=this[_0x47eb2e(0x188)](this['x']),this['y']=this[_0x47eb2e(0x1cd)](this['y'])):(_0x47f533['x']=_0x47f533[_0x47eb2e(0x1bb)]=$gameMap[_0x47eb2e(0x1e8)](TouchInput['x'])[_0x47eb2e(0x209)](0x0,this[_0x47eb2e(0x30f)]()-0x1),_0x47f533['y']=_0x47f533['lastPosY']=$gameMap[_0x47eb2e(0x30e)](TouchInput['y'])[_0x47eb2e(0x209)](0x0,this['height']()-0x1),_0x47f533[_0x47eb2e(0x19d)]=TouchInput['x'],_0x47f533['lastCursorY']=TouchInput['y']));if(Input[_0x47eb2e(0x1a6)](_0x47eb2e(0x142)))_0x47f533['x']-=0x1;else{if(Input[_0x47eb2e(0x1a6)](_0x47eb2e(0x262)))_0x47eb2e(0x292)!==_0x47eb2e(0x31d)?_0x47f533['x']+=0x1:_0x47b706[_0x47eb2e(0x2f9)]();else{if(Input[_0x47eb2e(0x1a6)]('up'))_0x47eb2e(0x24b)==='JjmML'?_0x47f533['y']-=0x1:this[_0x47eb2e(0x263)]++;else{if(Input['isRepeated'](_0x47eb2e(0x1b5)))_0x47eb2e(0x1b6)===_0x47eb2e(0x1b6)?_0x47f533['y']+=0x1:(_0x44b982[_0x47eb2e(0x266)][_0x47eb2e(0x2eb)]['call'](this),this[_0x47eb2e(0x289)]());else return;}}}const _0x5c43c3=Math[_0x47eb2e(0x23b)](0x0,Math[_0x47eb2e(0x2e6)](this[_0x47eb2e(0x306)])),_0x5b20c9=Math['min'](this[_0x47eb2e(0x30f)]()-0x1,Math[_0x47eb2e(0x2e6)](this[_0x47eb2e(0x306)]+this['screenTileX']())),_0x2d0594=Math[_0x47eb2e(0x23b)](0x0,Math[_0x47eb2e(0x2e6)](this[_0x47eb2e(0x28c)])),_0x183a34=Math['min'](this[_0x47eb2e(0x16d)]()-0x1,Math[_0x47eb2e(0x2e6)](this[_0x47eb2e(0x28c)]+this[_0x47eb2e(0x1d4)]()-0x1));_0x47f533['x']=_0x47f533['x'][_0x47eb2e(0x209)](_0x5c43c3,_0x5b20c9),_0x47f533['y']=_0x47f533['y']['clamp'](_0x2d0594,_0x183a34),(_0x47f533[_0x47eb2e(0x1bb)]!==_0x47f533['x']||_0x47f533[_0x47eb2e(0x267)]!==_0x47f533['y'])&&(SoundManager[_0x47eb2e(0x168)](),_0x47f533[_0x47eb2e(0x1bb)]=_0x47f533['x'],_0x47f533['lastPosY']=_0x47f533['y']);},Game_Map[_0x2d7466(0x1ac)][_0x2d7466(0x178)]=function(){const _0x18ef8f=_0x2d7466,_0x103dcf=this[_0x18ef8f(0x1d8)]();if(_0x103dcf[_0x18ef8f(0x305)])return;(Input[_0x18ef8f(0x264)](_0x18ef8f(0x220))||TouchInput[_0x18ef8f(0x21b)]())&&('VYQhb'===_0x18ef8f(0x2a1)?(SoundManager[_0x18ef8f(0x1ee)](),this[_0x18ef8f(0x1f6)](),Input['clear'](),TouchInput[_0x18ef8f(0x315)]()):_0x25fc6e[_0x18ef8f(0x2c3)]=!![]);},Game_Map['prototype']['updateFurnitureModeInputConfirm']=function(){const _0x46f3c9=_0x2d7466,_0x55c29b=SceneManager[_0x46f3c9(0x20f)][_0x46f3c9(0x27a)];if(_0x55c29b&&_0x55c29b['isBeingTouched']())return;if(Input[_0x46f3c9(0x264)]('ok')||TouchInput[_0x46f3c9(0x1fb)]()){const _0x461f1a=Input[_0x46f3c9(0x264)]('ok');if(this[_0x46f3c9(0x1a4)](_0x461f1a)){SoundManager[_0x46f3c9(0x237)](),this[_0x46f3c9(0x1ce)](_0x461f1a),Input[_0x46f3c9(0x315)]();const _0x4f34d0=TouchInput['x'],_0x3697f1=TouchInput['y'];TouchInput[_0x46f3c9(0x315)](),TouchInput['_x']=_0x4f34d0,TouchInput['_y']=_0x3697f1;}else _0x46f3c9(0x2a4)===_0x46f3c9(0x146)?this['startFadeIn'](this[_0x46f3c9(0x2a7)](),![]):SoundManager[_0x46f3c9(0x286)]();}},Game_Map[_0x2d7466(0x1ac)][_0x2d7466(0x172)]=function(_0xb569af){const _0xb80949=_0x2d7466,_0x5e1401=this['furnitureEventPosition']();let _0x2cfee4=_0x5e1401['x'],_0x8aca88=_0x5e1401['y'];if(_0xb569af){if(_0xb80949(0x19b)===_0xb80949(0x22c))try{_0x130b54['prototype']['drawItemNumber']['call'](this,_0x3f614b,_0x26b69a,_0x1a8dab,_0x5d901c);}catch(_0x4289ff){_0x14c224[_0xb80949(0x266)][_0xb80949(0x21e)][_0xb80949(0x25d)](this,_0x3bd641,_0x3c2b75,_0x3c6f67,_0x559969);}else _0x2cfee4=_0x5e1401['x'],_0x8aca88=_0x5e1401['y'];}else _0x2cfee4=$gameMap[_0xb80949(0x1e8)](TouchInput['x'])[_0xb80949(0x209)](0x0,this['width']()-0x1),_0x8aca88=$gameMap[_0xb80949(0x30e)](TouchInput['y'])[_0xb80949(0x209)](0x0,this[_0xb80949(0x16d)]()-0x1),_0x5e1401['x']=_0x5e1401['lastPosX']=_0x2cfee4,_0x5e1401['y']=_0x5e1401[_0xb80949(0x267)]=_0x8aca88;return{'x':_0x2cfee4,'y':_0x8aca88};},Game_Map[_0x2d7466(0x1ac)]['canPlaceFurniture']=function(_0x1efa63){const _0x4951e5=_0x2d7466,_0x30803e=this[_0x4951e5(0x172)](_0x1efa63),_0x267d72=_0x30803e['x'],_0x5491fe=_0x30803e['y'];return this['canPlaceFurnitureAtLocation'](_0x267d72,_0x5491fe);},Game_Map[_0x2d7466(0x1ac)]['canPlaceFurnitureAtLocation']=function(_0x4cf189,_0x15df41){const _0x365f23=_0x2d7466;if(!this[_0x365f23(0x221)](_0x4cf189,_0x15df41))return![];if(this[_0x365f23(0x18a)](_0x4cf189,_0x15df41))return!![];if(this[_0x365f23(0x28b)](_0x4cf189,_0x15df41))return!![];if(!this[_0x365f23(0x1b3)](_0x4cf189,_0x15df41))return![];if(!this['checkPlaceFurnitureAtForbidTerrainTag'](_0x4cf189,_0x15df41))return![];if(!this['checkPlaceFurniturePassability'](_0x4cf189,_0x15df41))return![];return!![];},Game_Map['prototype'][_0x2d7466(0x18a)]=function(_0x3da5ac,_0x17d433){const _0x1b037b=_0x2d7466,_0x3153dd=this[_0x1b037b(0x1d8)](),_0x291365=this['furnitureEvent']();let _0x2b3d41=_0x3da5ac-_0x291365[_0x1b037b(0x16b)][_0x1b037b(0x142)],_0x198bcc=_0x3da5ac+_0x291365['_addedHitbox']['right'],_0x39fa9b=_0x17d433-_0x291365[_0x1b037b(0x16b)]['up'],_0x3f9308=_0x17d433+_0x291365[_0x1b037b(0x16b)][_0x1b037b(0x1b5)];_0x3153dd[_0x1b037b(0x277)]=_0x3153dd['AllowRegions']||[];if(_0x3153dd[_0x1b037b(0x277)][_0x1b037b(0x1ad)]<=0x0)return![];for(let _0x4d18bb=_0x2b3d41;_0x4d18bb<=_0x198bcc;_0x4d18bb++){for(let _0x2d888d=_0x39fa9b;_0x2d888d<=_0x3f9308;_0x2d888d++){if('JGaMm'!==_0x1b037b(0x2e0)){const _0x4a9aea=this['regionId'](_0x4d18bb,_0x2d888d);if(!_0x3153dd[_0x1b037b(0x277)][_0x1b037b(0x279)](_0x4a9aea)){if(_0x1b037b(0x2e2)===_0x1b037b(0x1af))this[_0x1b037b(0x21f)][_0x1b037b(0x15d)](_0x162707['COLORFILTER_FORBID_TONE']);else return![];}}else{const _0x427482=this[_0x1b037b(0x1a0)](),_0x454e07=0x0,_0x1ad1d6=this[_0x1b037b(0x22e)]-_0x427482*0x2;this[_0x1b037b(0x20c)](this[_0x1b037b(0x1f0)],_0x427482,_0x454e07,_0x1ad1d6),this[_0x1b037b(0x312)](this[_0x1b037b(0x1f0)],_0x427482,_0x454e07,_0x1ad1d6-_0x427482*0x8);}}}return!![];},Game_Map['prototype'][_0x2d7466(0x1b3)]=function(_0x1f62b9,_0x140282){const _0x179a4f=_0x2d7466,_0x2da525=this[_0x179a4f(0x1d8)]();_0x2da525[_0x179a4f(0x277)]=_0x2da525[_0x179a4f(0x277)]||[],_0x2da525[_0x179a4f(0x18d)]=_0x2da525[_0x179a4f(0x18d)]||[];const _0x1c5fd6=this[_0x179a4f(0x1f9)]();let _0x50bd33=_0x1f62b9-_0x1c5fd6[_0x179a4f(0x16b)][_0x179a4f(0x142)],_0x6d08ef=_0x1f62b9+_0x1c5fd6[_0x179a4f(0x16b)]['right'],_0x73d8e0=_0x140282-_0x1c5fd6['_addedHitbox']['up'],_0xe08274=_0x140282+_0x1c5fd6['_addedHitbox']['down'];for(let _0x113826=_0x50bd33;_0x113826<=_0x6d08ef;_0x113826++){if(_0x179a4f(0x2ec)===_0x179a4f(0x257)){const _0x4f994d=this[_0x179a4f(0x2fc)](_0x182a64,_0x10980d);if(!_0x2efe20[_0x179a4f(0x277)][_0x179a4f(0x279)](_0x4f994d))return![];}else for(let _0x981b11=_0x73d8e0;_0x981b11<=_0xe08274;_0x981b11++){const _0x2739e0=this[_0x179a4f(0x2fc)](_0x113826,_0x981b11);if(_0x2da525['ForbidRegions'][_0x179a4f(0x279)](_0x2739e0))return![];if(_0x2da525[_0x179a4f(0x277)][_0x179a4f(0x1ad)]>0x0){if('pomSW'!==_0x179a4f(0x265)){if(!_0x2da525[_0x179a4f(0x277)][_0x179a4f(0x279)](_0x2739e0))return![];}else return![];}}}return!![];},Game_Map[_0x2d7466(0x1ac)][_0x2d7466(0x28b)]=function(_0xa0ca37,_0x88fe52){const _0x257a9b=_0x2d7466,_0x1faa6b=this[_0x257a9b(0x1d8)](),_0x2b1b01=this[_0x257a9b(0x1f9)]();let _0x1eefbe=_0xa0ca37-_0x2b1b01[_0x257a9b(0x16b)][_0x257a9b(0x142)],_0x35a419=_0xa0ca37+_0x2b1b01['_addedHitbox'][_0x257a9b(0x262)],_0x4fd9ea=_0x88fe52-_0x2b1b01[_0x257a9b(0x16b)]['up'],_0x20ce04=_0x88fe52+_0x2b1b01[_0x257a9b(0x16b)][_0x257a9b(0x1b5)];_0x1faa6b[_0x257a9b(0x25a)]=_0x1faa6b['AllowTerrainTags']||[];if(_0x1faa6b['AllowTerrainTags'][_0x257a9b(0x1ad)]<=0x0)return![];for(let _0x4e7ed2=_0x1eefbe;_0x4e7ed2<=_0x35a419;_0x4e7ed2++){for(let _0x530ff7=_0x4fd9ea;_0x530ff7<=_0x20ce04;_0x530ff7++){const _0x225e46=this['terrainTag'](_0x4e7ed2,_0x530ff7);if(!_0x1faa6b['AllowTerrainTags']['includes'](_0x225e46)){if('uInbZ'===_0x257a9b(0x21a))_0x3fb8b1['x']-=0x1;else return![];}}}return!![];},Game_Map['prototype'][_0x2d7466(0x294)]=function(_0x3b3060,_0x9ee500){const _0x5fb7a1=_0x2d7466,_0x1d84c8=this[_0x5fb7a1(0x1d8)]();_0x1d84c8[_0x5fb7a1(0x25a)]=_0x1d84c8[_0x5fb7a1(0x25a)]||[],_0x1d84c8['ForbidTerrainTags']=_0x1d84c8[_0x5fb7a1(0x2e8)]||[];const _0x53d12f=this['furnitureEvent']();let _0x353270=_0x3b3060-_0x53d12f[_0x5fb7a1(0x16b)][_0x5fb7a1(0x142)],_0x50ae17=_0x3b3060+_0x53d12f[_0x5fb7a1(0x16b)]['right'],_0x424e50=_0x9ee500-_0x53d12f[_0x5fb7a1(0x16b)]['up'],_0x4fe6ca=_0x9ee500+_0x53d12f[_0x5fb7a1(0x16b)][_0x5fb7a1(0x1b5)];for(let _0x1a6da0=_0x353270;_0x1a6da0<=_0x50ae17;_0x1a6da0++){for(let _0x1f8dd4=_0x424e50;_0x1f8dd4<=_0x4fe6ca;_0x1f8dd4++){if('hjOCu'===_0x5fb7a1(0x20a))_0x275fef[_0x5fb7a1(0x2c3)]=![];else{const _0x599d86=this[_0x5fb7a1(0x255)](_0x1a6da0,_0x1f8dd4);if(_0x1d84c8[_0x5fb7a1(0x2e8)][_0x5fb7a1(0x279)](_0x599d86)){if(_0x5fb7a1(0x1b1)===_0x5fb7a1(0x1b1))return![];else this[_0x5fb7a1(0x326)]=0x0,this[_0x5fb7a1(0x2f9)]();}if(_0x1d84c8[_0x5fb7a1(0x25a)][_0x5fb7a1(0x1ad)]>0x0){if(_0x5fb7a1(0x1fc)==='PUeYY')_0xeeb3fd[_0x5fb7a1(0x1be)](_0x242d14,0x1);else{if(!_0x1d84c8[_0x5fb7a1(0x25a)]['includes'](_0x599d86))return![];}}}}}return!![];},Game_Map[_0x2d7466(0x1ac)][_0x2d7466(0x321)]=function(_0x5ed28a,_0x528c83){const _0x2232f8=_0x2d7466,_0x2f443a=this['furnitureSettings']();if(_0x2f443a['CheckPassability']){if(!this[_0x2232f8(0x28f)](_0x5ed28a,_0x528c83))return![];}return!![];},Game_Map['prototype'][_0x2d7466(0x221)]=function(_0x51475f,_0x4a9612){const _0x2e8241=_0x2d7466,_0x3cb3ac=this[_0x2e8241(0x1d8)]();if(_0x3cb3ac['CheckEventCollision']){if(this['checkExistingEntitiesAt'](_0x51475f,_0x4a9612))return![];const _0x5e08e4=this['furnitureEventTemplateName'](),_0x408b8e=VisuMZ[_0x2e8241(0x1e2)][_0x5e08e4],_0x55ff18={'template':_0x5e08e4,'mapId':_0x408b8e['MapID'],'eventId':_0x408b8e['EventID'],'x':_0x51475f,'y':_0x4a9612,'spawnPreserved':!![],'spawnEventId':$gameMap[_0x2e8241(0x316)][_0x2e8241(0x1ad)]+0x3e8};if(!this[_0x2e8241(0x254)](_0x55ff18,_0x51475f,_0x4a9612))return![];}return!![];},VisuMZ['FurnitureSystem']['Game_CharacterBase_updateMove']=Game_CharacterBase[_0x2d7466(0x1ac)][_0x2d7466(0x15c)],Game_CharacterBase[_0x2d7466(0x1ac)]['updateMove']=function(){const _0x4564e3=_0x2d7466;if($gameMap&&$gameMap[_0x4564e3(0x169)]())return;VisuMZ['FurnitureSystem']['Game_CharacterBase_updateMove'][_0x4564e3(0x25d)](this);},VisuMZ[_0x2d7466(0x266)][_0x2d7466(0x2bb)]=Game_Player[_0x2d7466(0x1ac)][_0x2d7466(0x202)],Game_Player[_0x2d7466(0x1ac)][_0x2d7466(0x202)]=function(){const _0x46d02b=_0x2d7466;if($gameMap&&$gameMap[_0x46d02b(0x169)]()){$gameMap[_0x46d02b(0x302)]();return;}VisuMZ[_0x46d02b(0x266)][_0x46d02b(0x2bb)][_0x46d02b(0x25d)](this);},VisuMZ['FurnitureSystem'][_0x2d7466(0x30d)]=Game_Player[_0x2d7466(0x1ac)][_0x2d7466(0x2ed)],Game_Player['prototype'][_0x2d7466(0x2ed)]=function(){const _0x23a763=_0x2d7466;if($gameMap&&$gameMap[_0x23a763(0x169)]())return![];return VisuMZ[_0x23a763(0x266)][_0x23a763(0x30d)][_0x23a763(0x25d)](this);},VisuMZ[_0x2d7466(0x266)][_0x2d7466(0x17b)]=Game_Event[_0x2d7466(0x1ac)][_0x2d7466(0x317)],Game_Event[_0x2d7466(0x1ac)][_0x2d7466(0x317)]=function(){const _0x50c1ba=_0x2d7466;if($gameMap&&$gameMap[_0x50c1ba(0x169)]())return;VisuMZ['FurnitureSystem'][_0x50c1ba(0x17b)]['call'](this);},Game_Event[_0x2d7466(0x1ac)][_0x2d7466(0x2f3)]=function(){const _0x3bf223=_0x2d7466;this[_0x3bf223(0x1a7)]=this['canRegisterFurnitureData'](),this[_0x3bf223(0x1f5)]=$gameMap[_0x3bf223(0x1f5)],this[_0x3bf223(0x25e)]=$gameMap[_0x3bf223(0x25e)][_0x3bf223(0x2de)](),this['_furnitureSystemSettings']=JsonEx[_0x3bf223(0x1ff)]($gameMap[_0x3bf223(0x223)]);},Game_Event[_0x2d7466(0x1ac)][_0x2d7466(0x310)]=function(){const _0x4c9161=_0x2d7466,_0x524285=this[_0x4c9161(0x2b7)]();if(_0x524285){const _0xd6bb15=VisuMZ[_0x4c9161(0x266)][_0x4c9161(0x2a5)],_0x213565=_0x524285['note'];if(_0x213565[_0x4c9161(0x2d7)](_0xd6bb15[_0x4c9161(0x208)])){if('SaJFx'===_0x4c9161(0x2a3)){const _0x6d2b4e=_0x4a0437[_0x4c9161(0x266)][_0x4c9161(0x187)](_0x1c3d94),_0x5b998f=_0x181fd0[_0x4c9161(0x266)][_0x4c9161(0x2cc)](_0x205a90);this[_0x4c9161(0x29a)](_0x6d2b4e,_0x5b998f);}else return![];}}return!![];},Game_Event[_0x2d7466(0x1ac)]['isSpawnedFurniture']=function(){const _0x593c71=_0x2d7466;return this[_0x593c71(0x1a7)];},VisuMZ[_0x2d7466(0x266)][_0x2d7466(0x258)]=Game_Interpreter[_0x2d7466(0x1ac)]['updateWaitMode'],Game_Interpreter[_0x2d7466(0x1ac)][_0x2d7466(0x278)]=function(){const _0x187f25=_0x2d7466;if(this[_0x187f25(0x26a)][_0x187f25(0x161)]!==_0x187f25(0x23e)){if(_0x187f25(0x311)!==_0x187f25(0x256)){if(SceneManager[_0x187f25(0x247)]()&&$gameMap&&$gameMap[_0x187f25(0x169)]())return _0x187f25(0x2b4)!==_0x187f25(0x2b4)?![]:!![];}else{if(!_0x1a62bb[_0x187f25(0x247)]())return;if(!_0x56a0a1['canPlaceFurniture']())return;if(_0x92f325['isFurnitureSystemMode']())return;_0x32a65a[_0x187f25(0x158)](_0x360c05,_0x4fb092);const _0x3b2ffd=_0x5b4c64[_0x187f25(0x239)],_0x1a55b4=_0x543e74[_0x3b2ffd];if(!_0x5ca258[_0x187f25(0x2f7)](_0x1a55b4))return;const _0x2432b1=_0x204d1f['TemplateIndex'],_0x4b927a=_0x59db65[_0x187f25(0x22b)],_0x2b758c=_0x278d8c[_0x187f25(0x259)](_0x1a55b4,_0x2432b1,_0x4b927a),_0x2d43d8=_0x54ed02[_0x187f25(0x1bc)]||0x0;_0x2d43d8&&_0x338ac2[_0x187f25(0x185)](_0x2d43d8,!!_0x2b758c);}}return VisuMZ['FurnitureSystem'][_0x187f25(0x258)][_0x187f25(0x25d)](this);},Scene_Map['FURNITURE_TOUCH_HOLD_TIME']=VisuMZ[_0x2d7466(0x266)][_0x2d7466(0x1ca)][_0x2d7466(0x1fe)][_0x2d7466(0x285)]||0x5a,VisuMZ[_0x2d7466(0x266)][_0x2d7466(0x204)]=Scene_Map[_0x2d7466(0x1ac)][_0x2d7466(0x29d)],Scene_Map['prototype']['start']=function(){const _0xdabbc8=_0x2d7466;VisuMZ['FurnitureSystem'][_0xdabbc8(0x204)][_0xdabbc8(0x25d)](this),$gameMap&&$gameMap['isFurnitureSystemMode']()&&(_0xdabbc8(0x1c5)===_0xdabbc8(0x1c5)?this['startFadeIn'](this[_0xdabbc8(0x2a7)](),![]):_0x2a9d9b[_0xdabbc8(0x286)]());},VisuMZ[_0x2d7466(0x266)][_0x2d7466(0x2b8)]=Scene_Map[_0x2d7466(0x1ac)][_0x2d7466(0x214)],Scene_Map[_0x2d7466(0x1ac)][_0x2d7466(0x214)]=function(){const _0x5518d9=_0x2d7466;if($gameMap&&$gameMap[_0x5518d9(0x169)]())return this[_0x5518d9(0x281)](),![];return VisuMZ[_0x5518d9(0x266)][_0x5518d9(0x2b8)][_0x5518d9(0x25d)](this);},VisuMZ[_0x2d7466(0x266)][_0x2d7466(0x2be)]=Scene_Map[_0x2d7466(0x1ac)][_0x2d7466(0x2c6)],Scene_Map[_0x2d7466(0x1ac)]['onMapTouch']=function(){const _0x1eb1a9=_0x2d7466;if($gameMap&&$gameMap[_0x1eb1a9(0x169)]())return;VisuMZ['FurnitureSystem'][_0x1eb1a9(0x2be)]['call'](this);},VisuMZ[_0x2d7466(0x266)][_0x2d7466(0x1ec)]=Scene_Map[_0x2d7466(0x1ac)][_0x2d7466(0x205)],Scene_Map[_0x2d7466(0x1ac)][_0x2d7466(0x205)]=function(){const _0x1234bf=_0x2d7466;if($gameMap&&$gameMap[_0x1234bf(0x169)]())return![];return VisuMZ[_0x1234bf(0x266)]['Scene_Map_isMenuEnabled'][_0x1234bf(0x25d)](this);},VisuMZ[_0x2d7466(0x266)][_0x2d7466(0x215)]=Scene_Map[_0x2d7466(0x1ac)]['createAllWindows'],Scene_Map[_0x2d7466(0x1ac)][_0x2d7466(0x157)]=function(){const _0x3bc943=_0x2d7466;VisuMZ['FurnitureSystem'][_0x3bc943(0x215)][_0x3bc943(0x25d)](this),this[_0x3bc943(0x29c)]();},Scene_Map['prototype'][_0x2d7466(0x29c)]=function(){const _0x15e2a7=_0x2d7466;this[_0x15e2a7(0x196)](),this['createFurnitureItemWindow'](),this['createFurnitureCancelButton']();},Scene_Map[_0x2d7466(0x1ac)][_0x2d7466(0x196)]=function(){const _0x30b3cd=_0x2d7466,_0x4eab6e=this['furnitureHelpWindowRect']();this[_0x30b3cd(0x207)]=new Window_FurnitureHelp(_0x4eab6e),this[_0x30b3cd(0x23c)](this[_0x30b3cd(0x207)]);},Scene_Map[_0x2d7466(0x1ac)][_0x2d7466(0x2c1)]=function(){const _0xb7db29=_0x2d7466;return VisuMZ['FurnitureSystem'][_0xb7db29(0x1ca)][_0xb7db29(0x1fe)][_0xb7db29(0x246)][_0xb7db29(0x25d)](this);let _0x4af68b=Graphics[_0xb7db29(0x30f)],_0x1f93be=this[_0xb7db29(0x149)](0x2,![]),_0x364bba=0x0,_0x50226b=Graphics[_0xb7db29(0x16d)]-_0x1f93be;return new Rectangle(_0x364bba,_0x50226b,_0x4af68b,_0x1f93be);},Scene_Map[_0x2d7466(0x1ac)]['createFurnitureItemWindow']=function(){const _0x4986cf=_0x2d7466,_0x33f10b=this['furnitureItemWindowRect']();this[_0x4986cf(0x1d0)]=new Window_FurnitureItem(_0x33f10b),this[_0x4986cf(0x23c)](this[_0x4986cf(0x1d0)]);},Scene_Map[_0x2d7466(0x1ac)][_0x2d7466(0x216)]=function(){const _0x45e26c=_0x2d7466;return VisuMZ['FurnitureSystem'][_0x45e26c(0x1ca)][_0x45e26c(0x1fe)]['ItemWindow_RectJS'][_0x45e26c(0x25d)](this);let _0x239bdb=Math[_0x45e26c(0x184)](Graphics[_0x45e26c(0x30f)]/0x3),_0x4ff173=this[_0x45e26c(0x149)](0x1,![]),_0x214b0c=-$gameSystem[_0x45e26c(0x27f)](),_0x3fd0fa=Math['round'](Graphics[_0x45e26c(0x16d)]*0x1/0x6);return new Rectangle(_0x214b0c,_0x3fd0fa,_0x239bdb,_0x4ff173);},Scene_Map[_0x2d7466(0x1ac)][_0x2d7466(0x28e)]=function(){const _0x4cedab=_0x2d7466,_0x133752=new Sprite_Button('cancel'),_0x5dfe83=VisuMZ[_0x4cedab(0x266)]['Settings'][_0x4cedab(0x1fe)];_0x133752['x']=_0x5dfe83['CancelButtonXPositionJS'][_0x4cedab(0x25d)](this,_0x133752),_0x133752['y']=_0x5dfe83[_0x4cedab(0x307)][_0x4cedab(0x25d)](this,_0x133752),_0x133752['visible']=![],_0x133752[_0x4cedab(0x2f4)](),this[_0x4cedab(0x23c)](_0x133752),this[_0x4cedab(0x27a)]=_0x133752;},VisuMZ[_0x2d7466(0x266)][_0x2d7466(0x2c2)]=Scene_Map[_0x2d7466(0x1ac)][_0x2d7466(0x170)],Scene_Map['prototype'][_0x2d7466(0x170)]=function(){const _0x317665=_0x2d7466;if($gameMap&&$gameMap[_0x317665(0x169)]())return;if(this[_0x317665(0x263)]>=0x1&&this[_0x317665(0x2f5)]()){if(TouchInput[_0x317665(0x197)]()&&this['_touchCount']>=Scene_Map[_0x317665(0x244)])TouchInput['_preventTouchReleaseOnce']=!![],SoundManager[_0x317665(0x193)](),this['startMoveFurnitureModeByTouch']();else{if(TouchInput[_0x317665(0x197)]())this[_0x317665(0x263)]++;else TouchInput[_0x317665(0x1fb)]()&&this[_0x317665(0x263)]<Scene_Map[_0x317665(0x244)]?this[_0x317665(0x2c6)]():this['_touchCount']=0x0;}}else{if(_0x317665(0x1a5)!==_0x317665(0x1a5)){_0x22c0f6['_scene'][_0x317665(0x1a8)](_0x1163d3);const _0x23943=_0x2f6f9f[_0x317665(0x20f)][_0x317665(0x2b3)];if(_0x23943&&_0x23943[_0x317665(0x1ad)]>0x0){const _0x44bf8f=_0x23943[_0x23943[_0x317665(0x1ad)]-0x1];_0x44bf8f[_0x317665(0x270)]=_0x2da058;}}else TouchInput[_0x317665(0x264)]()&&this[_0x317665(0x263)]===0x0&&this['checkFurnitureAtTouchLocation']()&&('MKrVE'!=='ksqoj'?this[_0x317665(0x263)]++:(this[_0x317665(0x21f)]=new _0x10c829(),this[_0x317665(0x25b)][_0x317665(0x1fd)](this[_0x317665(0x21f)]))),VisuMZ[_0x317665(0x266)]['Scene_Map_processMapTouch']['call'](this);}},VisuMZ[_0x2d7466(0x266)][_0x2d7466(0x314)]=TouchInput['_onRelease'],TouchInput['_onRelease']=function(_0x26f3a7,_0x286cf2){const _0x588e8a=_0x2d7466;if(TouchInput[_0x588e8a(0x2f6)]){TouchInput['_preventTouchReleaseOnce']=![];return;}VisuMZ['FurnitureSystem']['TouchInput_onRelease'][_0x588e8a(0x25d)](this,_0x26f3a7,_0x286cf2);},VisuMZ[_0x2d7466(0x266)][_0x2d7466(0x1ba)]=function(_0x174462,_0x2c7032){const _0x298c1e=_0x2d7466;if(_0x174462===undefined)_0x174462=TouchInput['x'];if(_0x2c7032===undefined)_0x2c7032=TouchInput['y'];return _0x174462=$gameMap[_0x298c1e(0x1e8)](_0x174462),_0x2c7032=$gameMap['canvasToMapY'](_0x2c7032),this[_0x298c1e(0x2e1)](_0x174462,_0x2c7032);},VisuMZ[_0x2d7466(0x266)]['GetFurnitureAtXy']=function(_0x3a073e,_0x4e14bf){const _0x2cb1c5=_0x2d7466,_0x30ff70=$gameMap[_0x2cb1c5(0x1b9)](_0x3a073e,_0x4e14bf);for(const _0x4a62c0 of _0x30ff70){if(!_0x4a62c0)continue;if(_0x4a62c0[_0x2cb1c5(0x251)])continue;if(_0x4a62c0[_0x2cb1c5(0x27c)]())return _0x4a62c0;}return null;},Scene_Map['prototype'][_0x2d7466(0x2f5)]=function(){const _0x35fde1=_0x2d7466;return!!VisuMZ[_0x35fde1(0x266)][_0x35fde1(0x1ba)]();},Scene_Map[_0x2d7466(0x1ac)][_0x2d7466(0x2b5)]=function(){const _0x5384cd=_0x2d7466,_0x248d58=TouchInput['x'],_0x3e8e0e=TouchInput['y'];TouchInput['clear'](),Input[_0x5384cd(0x315)](),TouchInput['_x']=_0x248d58,TouchInput['_y']=_0x3e8e0e;const _0x1715a1=VisuMZ['FurnitureSystem'][_0x5384cd(0x1ba)](_0x248d58,_0x3e8e0e);this['startMoveFurnitureMode'](_0x1715a1);},Scene_Map['prototype'][_0x2d7466(0x1c3)]=function(_0x5ee126){const _0x3eb1c9=_0x2d7466,_0x41937e=_0x5ee126['x'],_0x18d634=_0x5ee126['y'],_0x247652=_0x5ee126[_0x3eb1c9(0x1f5)],_0x2a8255=_0x5ee126[_0x3eb1c9(0x25e)]['clone'](),_0x566965=JsonEx['makeDeepCopy'](_0x5ee126[_0x3eb1c9(0x223)]);_0x566965[_0x3eb1c9(0x295)]=!![],_0x566965[_0x3eb1c9(0x305)]=![];if(_0x566965[_0x3eb1c9(0x174)]>0x0){const _0x2b91c9=$dataItems[_0x566965[_0x3eb1c9(0x174)]];if(_0x2b91c9[_0x3eb1c9(0x313)])$gameParty[_0x3eb1c9(0x1be)](_0x2b91c9,0x1);}$gameMap[_0x3eb1c9(0x179)](_0x5ee126[_0x3eb1c9(0x241)]()),$gameTemp[_0x3eb1c9(0x1f5)]=_0x247652,$gameMap[_0x3eb1c9(0x29a)](_0x2a8255,_0x566965),$gameMap[_0x3eb1c9(0x1f5)]=_0x247652,$gameTemp[_0x3eb1c9(0x1f5)]=undefined;const _0x12bab1=$gameMap[_0x3eb1c9(0x272)];_0x12bab1['x']=_0x12bab1[_0x3eb1c9(0x1bb)]=_0x41937e,_0x12bab1['y']=_0x12bab1[_0x3eb1c9(0x267)]=_0x18d634,_0x12bab1[_0x3eb1c9(0x19d)]=TouchInput['x'],_0x12bab1[_0x3eb1c9(0x1d3)]=TouchInput['y'],VisuMZ['FurnitureSystem'][_0x3eb1c9(0x31e)]();},VisuMZ['FurnitureSystem']['Scene_Item_useItem']=Scene_Item[_0x2d7466(0x1ac)]['useItem'],Scene_Item[_0x2d7466(0x1ac)]['useItem']=function(){const _0x439d0a=_0x2d7466;if(this[_0x439d0a(0x2a0)]())'UAzwC'===_0x439d0a(0x224)?_0x3520ea[_0x439d0a(0x25a)]=_0x1bf1ae['$1'][_0x439d0a(0x14d)](',')[_0x439d0a(0x2cf)](_0x3af729=>_0x1fcc59(_0x3af729)[_0x439d0a(0x209)](0x1,0xff)):this[_0x439d0a(0x27e)]();else{if(_0x439d0a(0x19e)!==_0x439d0a(0x2c9))VisuMZ[_0x439d0a(0x266)][_0x439d0a(0x1b7)][_0x439d0a(0x25d)](this);else return![];}},Scene_Item['prototype'][_0x2d7466(0x2a0)]=function(){const _0x12f0a0=_0x2d7466;return DataManager[_0x12f0a0(0x2f7)](this[_0x12f0a0(0x271)]())&&SceneManager[_0x12f0a0(0x1a4)]();},Scene_Item[_0x2d7466(0x1ac)][_0x2d7466(0x27e)]=function(){const _0x41bc28=_0x2d7466;$gameMap['prepareFurniturePlacementMode'](this[_0x41bc28(0x271)]()),this[_0x41bc28(0x1ef)](this[_0x41bc28(0x2a7)](),![]),SceneManager[_0x41bc28(0x203)](Scene_Map);},VisuMZ[_0x2d7466(0x266)]['Scene_ItemBase_activateItemWindow']=Scene_ItemBase[_0x2d7466(0x1ac)][_0x2d7466(0x1a2)],Scene_ItemBase[_0x2d7466(0x1ac)][_0x2d7466(0x1a2)]=function(){const _0x3e5bac=_0x2d7466;if($gameMap&&$gameMap[_0x3e5bac(0x169)]())return;VisuMZ[_0x3e5bac(0x266)][_0x3e5bac(0x20b)][_0x3e5bac(0x25d)](this);},VisuMZ[_0x2d7466(0x266)][_0x2d7466(0x18b)]=Sprite_Button['prototype']['initialize'],Sprite_Button[_0x2d7466(0x1ac)][_0x2d7466(0x219)]=function(_0x284914){const _0x2e9065=_0x2d7466;VisuMZ[_0x2e9065(0x266)][_0x2e9065(0x18b)][_0x2e9065(0x25d)](this,_0x284914),this['_forFurnitureMode']=![];},Sprite_Button[_0x2d7466(0x1ac)][_0x2d7466(0x2f4)]=function(){const _0x3507a5=_0x2d7466;this[_0x3507a5(0x18f)]=!![];},Sprite_Button[_0x2d7466(0x1ac)][_0x2d7466(0x2f2)]=function(){const _0x13257c=_0x2d7466;return this[_0x13257c(0x18f)];},VisuMZ[_0x2d7466(0x266)][_0x2d7466(0x2eb)]=Sprite_Button['prototype']['update'],Sprite_Button['prototype'][_0x2d7466(0x1eb)]=function(){const _0x3f1229=_0x2d7466;VisuMZ[_0x3f1229(0x266)]['Sprite_Button_update']['call'](this),this[_0x3f1229(0x289)]();},Sprite_Button[_0x2d7466(0x1ac)]['updateFurnitureVisibility']=function(){const _0x3274a3=_0x2d7466;if(!this['isFurnitureButton']())return;if($gameMap&&$gameMap[_0x3274a3(0x169)]()){if(this[_0x3274a3(0x1d6)]===_0x3274a3(0x220)&&$gameMap[_0x3274a3(0x1d8)]()['PreventCancelExit'])this[_0x3274a3(0x2ef)]=![];else{if('dsuDX'!=='dsuDX'){if(_0x3ab8d4&&_0x4b1226[_0x3274a3(0x169)]())return;_0x17800c[_0x3274a3(0x266)][_0x3274a3(0x2be)][_0x3274a3(0x25d)](this);}else this[_0x3274a3(0x2ef)]=!![];}}else this[_0x3274a3(0x2ef)]=![];},VisuMZ[_0x2d7466(0x266)][_0x2d7466(0x23f)]=Sprite_Character[_0x2d7466(0x1ac)][_0x2d7466(0x1f7)],Sprite_Character[_0x2d7466(0x1ac)][_0x2d7466(0x1f7)]=function(){const _0x99eba9=_0x2d7466;if($gameMap&&$gameMap['isFurnitureSystemMode']())return![];return VisuMZ['FurnitureSystem'][_0x99eba9(0x23f)][_0x99eba9(0x25d)](this);};function Sprite_FurnitureCursor(){this['initialize'](...arguments);}Sprite_FurnitureCursor['prototype']=Object[_0x2d7466(0x250)](Sprite_Character[_0x2d7466(0x1ac)]),Sprite_FurnitureCursor[_0x2d7466(0x1ac)]['constructor']=Sprite_FurnitureCursor,Sprite_FurnitureCursor[_0x2d7466(0x261)]=VisuMZ['FurnitureSystem'][_0x2d7466(0x1ca)][_0x2d7466(0x16f)][_0x2d7466(0x1a9)],Sprite_FurnitureCursor[_0x2d7466(0x2cb)]=VisuMZ[_0x2d7466(0x266)][_0x2d7466(0x1ca)]['Filter'][_0x2d7466(0x1e7)],Sprite_FurnitureCursor['OUTLINE_FILTER_ALLOW_COLOR']=VisuMZ[_0x2d7466(0x266)][_0x2d7466(0x1ca)][_0x2d7466(0x16f)][_0x2d7466(0x148)],Sprite_FurnitureCursor[_0x2d7466(0x1a1)]=VisuMZ[_0x2d7466(0x266)][_0x2d7466(0x1ca)][_0x2d7466(0x16f)][_0x2d7466(0x150)],Sprite_FurnitureCursor['COLORFILTER_ALLOW_TONE']=VisuMZ[_0x2d7466(0x266)][_0x2d7466(0x1ca)][_0x2d7466(0x16f)][_0x2d7466(0x23d)][_0x2d7466(0x2de)](),Sprite_FurnitureCursor[_0x2d7466(0x20d)]=VisuMZ[_0x2d7466(0x266)][_0x2d7466(0x1ca)][_0x2d7466(0x16f)][_0x2d7466(0x2fe)][_0x2d7466(0x2de)](),Sprite_FurnitureCursor[_0x2d7466(0x1ac)][_0x2d7466(0x219)]=function(){const _0xdf599a=_0x2d7466;this[_0xdf599a(0x1e6)]='',this[_0xdf599a(0x17e)]=![],Sprite_Character['prototype'][_0xdf599a(0x219)]['call'](this,null),this[_0xdf599a(0x151)]();},Sprite_FurnitureCursor['prototype'][_0x2d7466(0x1ae)]=function(){const _0x25e68d=_0x2d7466;if(this['_lastTemplateName']!==$gameMap[_0x25e68d(0x14e)]()){if(_0x25e68d(0x211)!=='btXli'){this[_0x25e68d(0x1e6)]=$gameMap[_0x25e68d(0x14e)](),this[_0x25e68d(0x1c6)]($gameMap[_0x25e68d(0x1f9)]());if(!this[_0x25e68d(0x1e6)])this[_0x25e68d(0x24d)]=new Bitmap(0x1,0x1);}else{if(!this['checkPlaceFurnitureCollision'](_0x51824f,_0x10a0a4))return![];if(this[_0x25e68d(0x18a)](_0x4b044c,_0xfae29f))return!![];if(this['checkPlaceFurnitureAtAlowTerrainTag'](_0x4029a1,_0x5b6e43))return!![];if(!this['checkPlaceFurnitureAtForbidRegion'](_0x49d85c,_0x49063c))return![];if(!this[_0x25e68d(0x294)](_0x5e5fb1,_0xe7363f))return![];if(!this[_0x25e68d(0x321)](_0x25c771,_0x240eda))return![];return!![];}}},Sprite_FurnitureCursor[_0x2d7466(0x1ac)]['allowUpdate']=function(){const _0x461636=_0x2d7466;return this['_character']!==null&&$gameMap&&$gameMap[_0x461636(0x169)]();},Sprite_FurnitureCursor[_0x2d7466(0x1ac)][_0x2d7466(0x1eb)]=function(){const _0x1ca5d3=_0x2d7466;this[_0x1ca5d3(0x1ae)](),this['allowUpdate']()?(Sprite_Character[_0x1ca5d3(0x1ac)][_0x1ca5d3(0x1eb)]['call'](this),this['updateFilters']()):Sprite['prototype'][_0x1ca5d3(0x1eb)][_0x1ca5d3(0x25d)](this),this[_0x1ca5d3(0x289)]();},Sprite_FurnitureCursor['prototype'][_0x2d7466(0x289)]=function(){const _0x5e8051=_0x2d7466;this[_0x5e8051(0x2ef)]=this[_0x5e8051(0x26f)]();},Sprite_FurnitureCursor[_0x2d7466(0x1ac)]['updatePosition']=function(){const _0x552b3a=_0x2d7466;this[_0x552b3a(0x156)](),this['z']=0xa;if(this['_mouseMode'])this['x']=$gameMap[_0x552b3a(0x1e8)](TouchInput['x'])[_0x552b3a(0x209)](0x0,$gameMap[_0x552b3a(0x30f)]()-0x1),this['y']=$gameMap[_0x552b3a(0x30e)](TouchInput['y'])[_0x552b3a(0x209)](0x0,$gameMap[_0x552b3a(0x16d)]()-0x1);else{if(_0x552b3a(0x308)==='wJuOF')this['x']=$gameMap['furnitureEventPosition']()['x'],this['y']=$gameMap[_0x552b3a(0x15b)]()['y'];else return _0x1d79b9['canPlaceFurniture']();}this['x']=this[_0x552b3a(0x188)](this['x']),this['y']=this[_0x552b3a(0x1cd)](this['y']);},Sprite_FurnitureCursor[_0x2d7466(0x1ac)][_0x2d7466(0x188)]=function(_0x256d6a){const _0x5e0915=_0x2d7466,_0x358eeb=$gameMap[_0x5e0915(0x181)](),_0x195b18=$gameMap[_0x5e0915(0x1a3)](_0x256d6a);return Math[_0x5e0915(0x2e6)](_0x195b18*_0x358eeb+_0x358eeb/0x2);},Sprite_FurnitureCursor[_0x2d7466(0x1ac)]['converScreenPositionY']=function(_0x280f95){const _0x471537=_0x2d7466,_0x29119c=$gameMap[_0x471537(0x22a)](),_0x5262eb=$gameMap[_0x471537(0x190)](_0x280f95);return Math['floor'](_0x5262eb*_0x29119c+_0x29119c);},Sprite_FurnitureCursor[_0x2d7466(0x1ac)][_0x2d7466(0x156)]=function(){const _0x2ee354=_0x2d7466,_0xe5d381=$gameMap['furnitureEventPosition']();this[_0x2ee354(0x17e)]=_0xe5d381[_0x2ee354(0x19d)]!==TouchInput['x']||_0xe5d381[_0x2ee354(0x1d3)]!==TouchInput['y'];},Sprite_FurnitureCursor[_0x2d7466(0x1ac)]['createFilters']=function(){const _0x17a006=_0x2d7466;this[_0x17a006(0x25b)]=this[_0x17a006(0x25b)]||[],this[_0x17a006(0x1d1)](),this['createColorFilter']();},Sprite_FurnitureCursor[_0x2d7466(0x1ac)][_0x2d7466(0x1d1)]=function(){const _0x4ccdcb=_0x2d7466;if(!PIXI[_0x4ccdcb(0x25b)][_0x4ccdcb(0x1c9)])return;!this[_0x4ccdcb(0x2ad)]&&('xOGys'!==_0x4ccdcb(0x248)?(this[_0x4ccdcb(0x2ad)]=new PIXI[(_0x4ccdcb(0x25b))][(_0x4ccdcb(0x1c9))](),this['filters'][_0x4ccdcb(0x1fd)](this['_outlineFilter'])):_0x473946=![]),this[_0x4ccdcb(0x2ad)]['thickness']=Sprite_FurnitureCursor['OUTLINE_FILTER_THICKNESS'],this['_outlineFilter'][_0x4ccdcb(0x1db)]=Sprite_FurnitureCursor['OUTLINE_FILTER_QUALITY'];},Sprite_FurnitureCursor['prototype'][_0x2d7466(0x274)]=function(){const _0x271122=_0x2d7466;this[_0x271122(0x21f)]=new ColorFilter(),this[_0x271122(0x25b)]['push'](this[_0x271122(0x21f)]);},Sprite_FurnitureCursor[_0x2d7466(0x1ac)]['updateFilters']=function(){const _0x353d03=_0x2d7466;this['updateOutlineFilter'](),this[_0x353d03(0x14a)]();},Sprite_FurnitureCursor[_0x2d7466(0x1ac)][_0x2d7466(0x229)]=function(){const _0x144125=_0x2d7466;if(!this[_0x144125(0x2ad)])return;const _0x5851a5=$gameMap['canPlaceFurniture'](!this[_0x144125(0x17e)]);_0x5851a5?this[_0x144125(0x2ad)][_0x144125(0x2da)]=Sprite_FurnitureCursor[_0x144125(0x226)]:this[_0x144125(0x2ad)]['color']=Sprite_FurnitureCursor['OUTLINE_FILTER_FORBID_COLOR'];},Sprite_FurnitureCursor[_0x2d7466(0x1ac)][_0x2d7466(0x14a)]=function(){const _0x49ff7a=_0x2d7466,_0x28fe80=$gameMap[_0x49ff7a(0x1a4)](!this[_0x49ff7a(0x17e)]);_0x28fe80?this[_0x49ff7a(0x21f)][_0x49ff7a(0x15d)](Sprite_FurnitureCursor[_0x49ff7a(0x194)]):_0x49ff7a(0x30b)!==_0x49ff7a(0x186)?this['_colorFilter'][_0x49ff7a(0x15d)](Sprite_FurnitureCursor[_0x49ff7a(0x20d)]):this[_0x49ff7a(0x21c)][_0x49ff7a(0x1aa)](_0x417fca[_0x49ff7a(0x233)],_0x3e6d37);},Sprite_FurnitureCursor[_0x2d7466(0x1ac)][_0x2d7466(0x2ba)]=function(){const _0x2547c2=_0x2d7466;this['_tilesetId']=undefined,this[_0x2547c2(0x19f)]=undefined,this[_0x2547c2(0x2dc)]=undefined,this['_characterIndex']=undefined,this[_0x2547c2(0x17e)]=![],this['updateBitmap'](),this[_0x2547c2(0x1eb)](),this['updatePosition']();},Sprite_FurnitureCursor[_0x2d7466(0x1ac)]['updateScaleBase']=function(){const _0x2da47a=_0x2d7466;this['scale']['x']=this['_character'][_0x2da47a(0x1f3)]??0x1,this['scale']['y']=this[_0x2da47a(0x2c7)][_0x2da47a(0x192)]??0x1;},VisuMZ['FurnitureSystem'][_0x2d7466(0x303)]=Spriteset_Map['prototype'][_0x2d7466(0x2d1)],Spriteset_Map[_0x2d7466(0x1ac)][_0x2d7466(0x2d1)]=function(){const _0x366bee=_0x2d7466;VisuMZ['FurnitureSystem'][_0x366bee(0x303)][_0x366bee(0x25d)](this),this[_0x366bee(0x1d5)]();},Spriteset_Map[_0x2d7466(0x1ac)]['createFurnitureSystemEventSprite']=function(){const _0x1e2232=_0x2d7466;this[_0x1e2232(0x2d3)]=new Sprite_FurnitureCursor(),this[_0x1e2232(0x2d3)][_0x1e2232(0x2ef)]=![],this[_0x1e2232(0x2e9)][_0x1e2232(0x23c)](this['_furnitureEventSprite']);},VisuMZ[_0x2d7466(0x266)][_0x2d7466(0x18e)]=Spriteset_Map[_0x2d7466(0x1ac)]['createSpawnedEvent'],Spriteset_Map[_0x2d7466(0x1ac)]['createSpawnedEvent']=function(_0x24c5d0){const _0x215a83=_0x2d7466;if($gameTemp[_0x215a83(0x26d)])return;VisuMZ[_0x215a83(0x266)][_0x215a83(0x18e)][_0x215a83(0x25d)](this,_0x24c5d0);},VisuMZ[_0x2d7466(0x266)][_0x2d7466(0x16c)]=Window_ItemList['prototype']['isEnabled'],Window_ItemList[_0x2d7466(0x1ac)][_0x2d7466(0x225)]=function(_0x5123a6){const _0x14ae9d=_0x2d7466;return DataManager['isFurnitureItem'](_0x5123a6)?SceneManager['canPlaceFurniture']():_0x14ae9d(0x252)===_0x14ae9d(0x206)?![]:VisuMZ[_0x14ae9d(0x266)][_0x14ae9d(0x16c)][_0x14ae9d(0x25d)](this,_0x5123a6);};function Window_FurnitureHelp(){const _0x33bfc6=_0x2d7466;this[_0x33bfc6(0x219)](...arguments);}Window_FurnitureHelp['prototype']=Object[_0x2d7466(0x250)](Window_Base[_0x2d7466(0x1ac)]),Window_FurnitureHelp[_0x2d7466(0x1ac)][_0x2d7466(0x26a)]=Window_FurnitureHelp,Window_FurnitureHelp[_0x2d7466(0x2df)]=VisuMZ[_0x2d7466(0x266)][_0x2d7466(0x1ca)][_0x2d7466(0x1fe)][_0x2d7466(0x269)],Window_FurnitureHelp[_0x2d7466(0x189)]=VisuMZ[_0x2d7466(0x266)][_0x2d7466(0x1ca)][_0x2d7466(0x1fe)][_0x2d7466(0x1b2)],Window_FurnitureHelp['OFFSET_COLUMN_1_X']=VisuMZ[_0x2d7466(0x266)][_0x2d7466(0x1ca)][_0x2d7466(0x1fe)][_0x2d7466(0x29b)],Window_FurnitureHelp['OFFSET_COLUMN_2_X']=VisuMZ[_0x2d7466(0x266)][_0x2d7466(0x1ca)][_0x2d7466(0x1fe)][_0x2d7466(0x1ea)],Window_FurnitureHelp[_0x2d7466(0x1ac)][_0x2d7466(0x219)]=function(_0x2623d2){const _0x4739eb=_0x2d7466;this['fullRect']=_0x2623d2,Window_Base['prototype'][_0x4739eb(0x219)][_0x4739eb(0x25d)](this,_0x2623d2),this[_0x4739eb(0x260)](Window_FurnitureHelp[_0x4739eb(0x2df)]),this[_0x4739eb(0x2f9)](),this[_0x4739eb(0x2f1)]();},Window_FurnitureHelp[_0x2d7466(0x1ac)]['refresh']=function(){const _0x2d417d=_0x2d7466;this[_0x2d417d(0x1d9)]['clear'](),this[_0x2d417d(0x14b)]();return VisuMZ[_0x2d417d(0x266)]['Settings'][_0x2d417d(0x1fe)][_0x2d417d(0x1dd)]['call'](this);let _0x1309ac=Math[_0x2d417d(0x184)](this[_0x2d417d(0x1d9)][_0x2d417d(0x30f)]*0x1/0x4);_0x1309ac+=Window_FurnitureHelp[_0x2d417d(0x141)];let _0x17a663=Math[_0x2d417d(0x184)](this[_0x2d417d(0x1d9)][_0x2d417d(0x30f)]*0x3/0x4);_0x17a663+=Window_FurnitureHelp['OFFSET_COLUMN_2_X'];const _0x75c7a0=this[_0x2d417d(0x245)]('\x20');{if(_0x2d417d(0x1df)===_0x2d417d(0x1df)){this[_0x2d417d(0x2a6)](!![]);const _0xb4e6e1=TextManager[_0x2d417d(0x266)][_0x2d417d(0x234)],_0x489bd1=TextManager[_0x2d417d(0x266)][_0x2d417d(0x27b)],_0xad468a=this[_0x2d417d(0x171)](_0xb4e6e1)[_0x2d417d(0x30f)],_0x3fb97f=this['textSizeEx'](_0x489bd1)[_0x2d417d(0x30f)],_0x1dc268=0x0;this[_0x2d417d(0x31a)](_0xb4e6e1,_0x1309ac-_0xad468a-_0x75c7a0,_0x1dc268,_0xad468a),this[_0x2d417d(0x31a)](_0x489bd1,_0x1309ac+_0x75c7a0,_0x1dc268,_0x3fb97f);}else return _0x114a57[_0x2d417d(0x1cb)]&&_0x28e9d2[_0x2d417d(0x31c)][_0x2d417d(0x279)]('['+_0x19ed5f+']');}{this[_0x2d417d(0x2a6)](this[_0x2d417d(0x1d2)]());const _0x467730=TextManager[_0x2d417d(0x266)][_0x2d417d(0x31b)],_0x386e37=TextManager[_0x2d417d(0x266)][_0x2d417d(0x30a)],_0x2ec557=this['textSizeEx'](_0x467730)[_0x2d417d(0x30f)],_0x27369e=this['textSizeEx'](_0x386e37)[_0x2d417d(0x30f)],_0x24d546=this[_0x2d417d(0x243)]();this[_0x2d417d(0x31a)](_0x467730,_0x1309ac-_0x2ec557-_0x75c7a0,_0x24d546,_0x2ec557),this[_0x2d417d(0x31a)](_0x386e37,_0x1309ac+_0x75c7a0,_0x24d546,_0x27369e);}{this[_0x2d417d(0x2a6)](!![]);const _0x2c9007=TextManager[_0x2d417d(0x266)][_0x2d417d(0x2d5)],_0x3c197e=TextManager['FurnitureSystem']['ConfirmText'],_0x24bc5d=this[_0x2d417d(0x171)](_0x2c9007)['width'],_0x313fcd=this['textSizeEx'](_0x3c197e)[_0x2d417d(0x30f)],_0x38cdde=0x0;this[_0x2d417d(0x31a)](_0x2c9007,_0x17a663-_0x24bc5d-_0x75c7a0,_0x38cdde,_0x24bc5d),this[_0x2d417d(0x31a)](_0x3c197e,_0x17a663+_0x75c7a0,_0x38cdde,_0x313fcd);}{this[_0x2d417d(0x2a6)](this[_0x2d417d(0x1d7)]());const _0x23c458=TextManager['FurnitureSystem'][_0x2d417d(0x298)],_0x161b41=TextManager[_0x2d417d(0x266)][_0x2d417d(0x249)],_0x28e7c1=this[_0x2d417d(0x171)](_0x23c458)[_0x2d417d(0x30f)],_0x4ef9bf=this[_0x2d417d(0x171)](_0x161b41)[_0x2d417d(0x30f)],_0x5ed6a1=this[_0x2d417d(0x243)]();this[_0x2d417d(0x31a)](_0x23c458,_0x17a663-_0x28e7c1-_0x75c7a0,_0x5ed6a1,_0x28e7c1),this[_0x2d417d(0x31a)](_0x161b41,_0x17a663+_0x75c7a0,_0x5ed6a1,_0x4ef9bf);}},Window_FurnitureHelp[_0x2d7466(0x1ac)]['isHasMultipleVariants']=function(){const _0x277e86=_0x2d7466;return $gameMap[_0x277e86(0x25e)]&&$gameMap['_furnitureSystemTemplates']['length']>0x1;},Window_FurnitureHelp['prototype'][_0x2d7466(0x1d7)]=function(){const _0x5f0eec=_0x2d7466,_0x4c8bf6=$gameMap[_0x5f0eec(0x1d8)]();return!_0x4c8bf6[_0x5f0eec(0x305)];},Window_FurnitureHelp[_0x2d7466(0x1ac)]['update']=function(){const _0x56d1f0=_0x2d7466;Window_Base[_0x56d1f0(0x1ac)][_0x56d1f0(0x1eb)][_0x56d1f0(0x25d)](this),this['updateVisibility'](),this[_0x56d1f0(0x177)]();},Window_FurnitureHelp['prototype'][_0x2d7466(0x1bd)]=function(){const _0x5271fe=_0x2d7466;this['visible']=$gameMap[_0x5271fe(0x169)]();},Window_FurnitureHelp['prototype'][_0x2d7466(0x177)]=function(){const _0x541c17=_0x2d7466,_0x492540=SceneManager['_scene'][_0x541c17(0x195)][_0x541c17(0x2d3)];if(!_0x492540)return;const _0x56b579=SceneManager[_0x541c17(0x20f)][_0x541c17(0x195)]['_baseSprite'],_0x160ae4=_0x56b579['x'],_0x3b3cec=_0x56b579['y'],_0x4b59a5=new Point(_0x492540['x']-_0x160ae4,_0x492540['y']-_0x3b3cec),_0x1214e2=_0x4b59a5['x']-_0x492540['width']/0x2>=this[_0x541c17(0x200)]['x']&&_0x4b59a5['x']+_0x492540[_0x541c17(0x30f)]/0x2<=this[_0x541c17(0x200)]['x']+this[_0x541c17(0x200)][_0x541c17(0x30f)]&&_0x4b59a5['y']>=this[_0x541c17(0x200)]['y']&&_0x4b59a5['y']-_0x492540[_0x541c17(0x16d)]<=this[_0x541c17(0x200)]['y']+this[_0x541c17(0x200)][_0x541c17(0x16d)],_0x2cfc9a=Window_FurnitureHelp['BG_TYPE'],_0x15131f=_0x1214e2?Window_FurnitureHelp[_0x541c17(0x189)]:0xff;this['contentsOpacity']=_0x15131f;if(_0x2cfc9a===0x0)this[_0x541c17(0x152)]=_0x15131f;if(_0x2cfc9a===0x1)this[_0x541c17(0x26b)][_0x541c17(0x152)]=_0x15131f;};function Window_FurnitureItem(){const _0x517aca=_0x2d7466;this[_0x517aca(0x219)](...arguments);}Window_FurnitureItem[_0x2d7466(0x1ac)]=Object[_0x2d7466(0x250)](Window_Base['prototype']),Window_FurnitureItem['prototype'][_0x2d7466(0x26a)]=Window_FurnitureItem,Window_FurnitureItem[_0x2d7466(0x189)]=VisuMZ['FurnitureSystem'][_0x2d7466(0x1ca)][_0x2d7466(0x1fe)][_0x2d7466(0x319)],Window_FurnitureItem['prototype']['initialize']=function(_0x19a71a){const _0xf4add2=_0x2d7466;this[_0xf4add2(0x200)]=_0x19a71a,this[_0xf4add2(0x326)]=0x0,Window_Base[_0xf4add2(0x1ac)][_0xf4add2(0x219)][_0xf4add2(0x25d)](this,_0x19a71a),this['setBackgroundType'](0x2),this[_0xf4add2(0x2f1)]();},Window_FurnitureItem[_0x2d7466(0x1ac)][_0x2d7466(0x2f9)]=function(){const _0x8ed675=_0x2d7466;this[_0x8ed675(0x1d9)][_0x8ed675(0x315)]();if(!this[_0x8ed675(0x326)])return;this[_0x8ed675(0x1f0)]=$dataItems[this['_itemID']];return VisuMZ[_0x8ed675(0x266)][_0x8ed675(0x1ca)][_0x8ed675(0x1fe)][_0x8ed675(0x1e9)]['call'](this);const _0x23f021=ColorManager[_0x8ed675(0x23a)](),_0x5a809c=ColorManager[_0x8ed675(0x2ee)](),_0x4786fa=Math['round'](this[_0x8ed675(0x22e)]/0x2),_0x5698ef=this['innerHeight'];this['contents'][_0x8ed675(0x1b0)](0x0,0x0,_0x4786fa,_0x5698ef,_0x23f021),this[_0x8ed675(0x1d9)][_0x8ed675(0x2e4)](0x0+_0x4786fa,0x0,_0x4786fa,_0x5698ef,_0x23f021,_0x5a809c);if(Imported[_0x8ed675(0x1e3)]){if('WXiSP'==='ffmbl')this[_0x8ed675(0x2ef)]=![];else{const _0x462a67=this[_0x8ed675(0x1a0)](),_0xfd795a=0x0,_0x54e68a=this[_0x8ed675(0x22e)]-_0x462a67*0x10;this[_0x8ed675(0x312)](this[_0x8ed675(0x1f0)],_0x462a67,_0xfd795a,_0x462a67*0x8),this['drawItemName'](this[_0x8ed675(0x1f0)],_0x462a67*0xa,_0xfd795a,_0x54e68a);}}else{const _0x1d2842=this['itemPadding'](),_0x47a3c5=0x0,_0x1c25fe=this['innerWidth']-_0x1d2842*0x2;this[_0x8ed675(0x20c)](this[_0x8ed675(0x1f0)],_0x1d2842,_0x47a3c5,_0x1c25fe),this['drawItemNumber'](this[_0x8ed675(0x1f0)],_0x1d2842,_0x47a3c5,_0x1c25fe-_0x1d2842*0x8);}},VisuMZ[_0x2d7466(0x266)]['Window_ItemList_drawItemNumber']=Window_ItemList[_0x2d7466(0x1ac)][_0x2d7466(0x312)],Window_FurnitureItem['prototype'][_0x2d7466(0x312)]=function(_0x388ba5,_0x334f9f,_0x2c8642,_0x406857){const _0x334736=_0x2d7466;try{Window_ItemList[_0x334736(0x1ac)][_0x334736(0x312)][_0x334736(0x25d)](this,_0x388ba5,_0x334f9f,_0x2c8642,_0x406857);}catch(_0x1b94da){VisuMZ[_0x334736(0x266)][_0x334736(0x21e)][_0x334736(0x25d)](this,_0x388ba5,_0x334f9f,_0x2c8642,_0x406857);}},Window_FurnitureItem[_0x2d7466(0x1ac)][_0x2d7466(0x1eb)]=function(){const _0x1bbffc=_0x2d7466;Window_Base['prototype']['update'][_0x1bbffc(0x25d)](this),this['updateItemType'](),this['updateVisibility'](),this[_0x1bbffc(0x177)]();},Window_FurnitureItem['prototype'][_0x2d7466(0x1c1)]=function(){const _0x43066e=_0x2d7466;if($gameMap[_0x43066e(0x169)]()){if(_0x43066e(0x16e)===_0x43066e(0x2dd)){const _0x1bf519=this[_0x43066e(0x1d8)]();if(_0x1bf519[_0x43066e(0x167)]){if(this[_0x43066e(0x322)](_0x5abae2,_0x2c0092))return![];const _0x31e792=this[_0x43066e(0x14e)](),_0x25dd2f=_0x487054[_0x43066e(0x1e2)][_0x31e792],_0xe9bfa1={'template':_0x31e792,'mapId':_0x25dd2f[_0x43066e(0x1fa)],'eventId':_0x25dd2f['EventID'],'x':_0x93a920,'y':_0x135066,'spawnPreserved':!![],'spawnEventId':_0x522ea6['_spawnedEvents'][_0x43066e(0x1ad)]+0x3e8};if(!this[_0x43066e(0x254)](_0xe9bfa1,_0x507ae1,_0x15c361))return![];}return!![];}else{const _0xe7a64f=$gameMap[_0x43066e(0x1d8)]();this[_0x43066e(0x326)]!==_0xe7a64f[_0x43066e(0x174)]&&(_0x43066e(0x217)===_0x43066e(0x230)?_0x3f6ce9[_0x43066e(0x185)](_0x5d9324,!!_0x31bc7e):(this['_itemID']=_0xe7a64f['OnPlaceConsumeItem'],this[_0x43066e(0x2f9)]()));}}else this[_0x43066e(0x326)]&&(this[_0x43066e(0x326)]=0x0,this['refresh']());},Window_FurnitureItem['prototype']['needsNumber']=function(){return!![];},Window_FurnitureItem[_0x2d7466(0x1ac)][_0x2d7466(0x1bd)]=function(){const _0xf39f9a=_0x2d7466;this[_0xf39f9a(0x2ef)]=$gameMap['isFurnitureSystemMode']()&&this[_0xf39f9a(0x326)];},Window_FurnitureItem['prototype'][_0x2d7466(0x177)]=function(){const _0x569a95=_0x2d7466,_0x4c7bd4=SceneManager['_scene'][_0x569a95(0x195)][_0x569a95(0x2d3)];if(!_0x4c7bd4)return;const _0x2e779d=SceneManager['_scene']['_spriteset'][_0x569a95(0x2e9)],_0x119c4f=_0x2e779d['x'],_0x49612e=_0x2e779d['y'],_0x5553a6=new Point(_0x4c7bd4['x']-_0x119c4f,_0x4c7bd4['y']-_0x49612e),_0x361fcd=_0x5553a6['x']-_0x4c7bd4[_0x569a95(0x30f)]/0x2>this[_0x569a95(0x200)]['x']&&_0x5553a6['x']+_0x4c7bd4[_0x569a95(0x30f)]/0x2<=this['fullRect']['x']+this[_0x569a95(0x200)][_0x569a95(0x30f)]&&_0x5553a6['y']>this[_0x569a95(0x200)]['y']&&_0x5553a6['y']-_0x4c7bd4[_0x569a95(0x16d)]<=this['fullRect']['y']+this['fullRect']['height'],_0x1333da=_0x361fcd?Window_FurnitureItem[_0x569a95(0x189)]:0xff;this['contentsOpacity']=_0x1333da;};function _0x4bf0(){const _0x34a800=['AllowTone','Game_OnceParallelInterpreter','Sprite_Character_isAllowCharacterTilt','10oeWycs','eventId','4375602ljugOF','lineHeight','FURNITURE_TOUCH_HOLD_TIME','textWidth','HelpWindow_RectJS','isSceneMap','uYwze','CancelText','TerrainTagsForbid','JjmML','DEFAULT_FURNITURE_ALLOW_TERRAIN_TAGS','bitmap','tjajh','rlScK','create','_erased','WWKlA','inBattle','isSpawnHitboxCollisionOk','terrainTag','ojEaL','bqxrz','Game_Interpreter_updateWaitMode','devPlaceFurnitureAtRegion','AllowTerrainTags','filters','Default','call','_furnitureSystemTemplates','aEXnq','setBackgroundType','OUTLINE_FILTER_THICKNESS','right','_touchCount','isTriggered','TlRxq','FurnitureSystem','lastPosY','%1\x27s\x20version\x20does\x20not\x20match\x20plugin\x27s.\x20Please\x20update\x20it\x20in\x20the\x20Plugin\x20Manager.','HelpWindow_BgType','constructor','_dimmerSprite','ZjaJI','_furnitureModeRegisterEvent','Game_Action_isForFriend','allowUpdate','_eventId','item','_furnitureSystemEventPosition','playSe','createColorFilter','updateFurnitureModeInputConfirm','isPlaytest','AllowRegions','updateWaitMode','includes','_furnitureCancelButton','PositionText','isSpawnedFurniture','Place','processPlaceFurniture','windowPadding','DisallowFurniture','updateOnceParallelInterpreters','ThisEventMoveFurniture','256CrRMog','CommonEvent','HoldTime','playBuzzer','GQrOf','FurnitureOnPlaceCommonEvent','updateFurnitureVisibility','registerCommand','checkPlaceFurnitureAtAlowTerrainTag','_displayY','ZPruc','createFurnitureCancelButton','isPassableByAnyDirection','DEFAULT_ALLOW_FURNITURE','eLXet','xsoCI','updateFurnitureItemWindowCount','checkPlaceFurnitureAtForbidTerrainTag','OnPlaceEndMode','TemplateIndex','FurnitureSpawnAtRegion','CancelButtons','llNcs','startFurnitureSystemMode','HelpWindow_Col1_OffsetX','createFurnitureSystemDisplayObjects','start','getSpawnPointsWithTerrainTags','getLastPluginCommandInterpreter','checkFurniturePlacement','VYQhb','setupReservedCommonEvent','dyveq','zieEf','RegExp','changePaintOpacity','fadeSpeed','onPlaceFurnitureRunCommonEvent','FurnitureAllowRegions','DEFAULT_FURNITURE_CHECK_EVENT_COLLISION','FurnitureForbidTerrainTags','TerrainTagsAllow','_outlineFilter','DEFAULT_FURNITURE_END_MODE_ON_PLACE','exit','PosX','toUpperCase','erTYs','_onceParallelInterpreters','iabUv','startMoveFurnitureModeByTouch','GfbtL','event','Scene_Map_isSceneChangeOk','Gmhpd','resetForNewFurnitureMode','Game_Player_moveByInput','updateFurnitureModeInputDirection','TerrainTags','Scene_Map_onMapTouch','182948TlUDDu','TargetEventDespawnFurniture','furnitureHelpWindowRect','Scene_Map_processMapTouch','CheckPassability','trim','TargetEventRetrieveFurniture','onMapTouch','_character','EVAL','Abxxz','DEFAULT_FURNITURE_CHECK_PASSABILITY','OUTLINE_FILTER_QUALITY','extractFurnitureSettings','parse','prepareSpawnedEventAtXY','map','wPCUC','createLowerLayer','DEFAULT_FURNITURE_FORBID_TERRAIN_TAGS','_furnitureEventSprite','isAllowFurniture','ConfirmButtons','POlXZ','match','TargetEventMoveFurniture','vCdQM','color','XNGvx','_characterName','mdDBC','clone','BG_TYPE','EfvEg','GetFurnitureAtXy','GJnWF','consumeItem','gradientFillRect','FurnitureForbidRegions','floor','CreateSpawnData','ForbidTerrainTags','_baseSprite','Move','Sprite_Button_update','UbkgX','canStartLocalEvents','dimColor2','visible','PosY','hide','isFurnitureButton','registerFurnitureData','setFurnitureButton','checkFurnitureAtTouchLocation','_preventTouchReleaseOnce','isFurnitureItem','YBCXF','refresh','FurniturePlacement','wheelY','regionId','jvldT','ForbidTone','direction','3356720mdDZVs','format','updateFurnitureModeInput','Spriteset_Map_createLowerLayer','setupFurnitureData','PreventCancelExit','_displayX','CancelButtonYPositionJS','wJuOF','shiftFurnitureTemplateIndex','VariantText','qRNlh','17787ZjEQFh','Game_Player_canStartLocalEvents','canvasToMapY','width','canRegisterFurnitureData','rbYqV','drawItemNumber','consumable','TouchInput_onRelease','clear','_spawnedEvents','updateSelfMovement','parameters','ItemWindow_FadeTarget','drawTextEx','VariantButtons','description','oXHad','RefreshFurnitureCursorBitmap','_furnitureSystemEvent','updateFurnitureModeInputScrollWheel','checkPlaceFurniturePassability','checkExistingEntitiesAt','mhffV','vHQgx','cLQJT','_itemID','nRWEg','aYERd','OFFSET_COLUMN_1_X','left','FurnitureOnPlaceEndOnce','note','devPlaceFurnitureAtTerrainTag','ToKPL','FurnitureTemplates','OutlineAllowedColor','calcWindowHeight','updateColorFilter','resetFontSettings','%1\x20is\x20incorrectly\x20placed\x20on\x20the\x20plugin\x20list.\x0aIt\x20is\x20a\x20Tier\x20%2\x20plugin\x20placed\x20over\x20other\x20Tier\x20%3\x20plugins.\x0aPlease\x20reorder\x20the\x20plugin\x20list\x20from\x20smallest\x20to\x20largest\x20tier\x20numbers.','split','furnitureEventTemplateName','FUNC','OutlineForbidColor','createFilters','opacity','isForFriend','AfxpU','reserveCommonEvent','updateMouseMode','createAllWindows','ConvertParams','%1Pitch','nIbhj','furnitureEventPosition','updateMove','setColorTone','HhZYk','DEFAULT_FURNITURE_ON_PLACE_COMMON_EVENT','numItems','name','prepareFurniturePlacementMode','spawnFurnitureEventAtXy','devPlaceFurnitureAtXY','FurnitureOnPlaceEndless','MapsAllowFurniture','CheckEventCollision','playCursor','isFurnitureSystemMode','_spawnData','_addedHitbox','Window_ItemList_isEnabled','height','exiBI','Filter','processMapTouch','textSizeEx','getTargetFurnitureLocation','onPlaceFurnitureSpawnEvent','OnPlaceConsumeItem','%1Name','filter','updateOpacity','updateFurnitureModeInputCancel','despawnEventId','ZsRrb','Game_Event_updateSelfMovement','13703118BdybkI','isSceneItem','_mouseMode','_furnitureModeAntiSoftlockAlert','STRUCT','tileWidth','135438bHoKjr','FurnitureSpawnAtTerrainTag','round','setValue','hHsua','extractFurnitureTemplates','converScreenPositionX','FADE_OPACITY_TARGET','checkPlaceFurnitureAtAllowRegion','Sprite_Button_initialize','DHteP','ForbidRegions','Spriteset_Map_createSpawnedEvent','_forFurnitureMode','adjustY','EndOnPlace','_scaleY','playMoveFurnitureSound','COLORFILTER_ALLOW_TONE','_spriteset','createFurnitureHelpWindow','isPressed','AkSAG','EventID','DEFAULT_FURNITURE_ALLOW_REGIONS','CRDHJ','PurgeNonTemplateData','lastCursorX','vDtYH','_tileId','itemPadding','OUTLINE_FILTER_FORBID_COLOR','activateItemWindow','adjustX','canPlaceFurniture','FGXDC','isRepeated','_furniture','playOnceParallelInterpreter','OutlineThickness','setupChild','setupFurnitureCursor','prototype','length','checkTemplateChange','XxaPi','fillRect','NJhWC','HelpWindow_FadeTarget','checkPlaceFurnitureAtForbidRegion','JSON','down','IZudI','Scene_Item_useItem','FTTBa','eventsXy','GetFurnitureAtTouchedXy','lastPosX','SuccessSwitchId','updateVisibility','gainItem','DkBKg','pXimt','updateItemType','isValid','startMoveFurnitureMode','STR','bcwhy','setCharacter','ARRAYSTRUCT','dir4','OutlineFilter','Settings','status','ConfirmText','converScreenPositionY','finishFurnitureSystemMode','isRunning','_furnitureItemWindow','createOutlineFilter','isHasMultipleVariants','lastCursorY','screenTileY','createFurnitureSystemEventSprite','_buttonType','isCancelExitPrevented','furnitureSettings','contents','ARRAYJSON','quality','iJwDP','HelpWindow_DrawJS','FurnitureFreePassability','QRliv','XGKhn','setupSpawn','EventTemplates','VisuMZ_1_ItemsEquipsCore','3URILEc','%1Volume','_lastTemplateName','OutlineQuality','canvasToMapX','ItemWindow_DrawJS','HelpWindow_Col2_OffsetX','update','Scene_Map_isMenuEnabled','%1Pant','playCancel','startFadeOut','_item','pxUEa','3721522cdKBFu','_scaleX','GenerateItem','_furnitureSystemTemplateIndex','endFurnitureSystemMode','isAllowCharacterTilt','ARRAYEVAL','furnitureEvent','MapID','isReleased','YARSr','push','Window','makeDeepCopy','fullRect','40EcUjED','moveByInput','goto','Scene_Map_start','isMenuEnabled','BESEk','_furnitureHelpWindow','FurnitureNotMovable','clamp','DphuO','Scene_ItemBase_activateItemWindow','drawItemName','COLORFILTER_FORBID_TONE','onPlaceFurniture','_scene','ARRAYFUNC','EyiKD','HcuBV','Sound','isSceneChangeOk','Scene_Map_createAllWindows','furnitureItemWindowRect','LWCaA','getSpawnPointsInRegion','initialize','PBZJU','isCancelled','_interpreter','OnPlaceCommonEventID','Window_ItemList_drawItemNumber','_colorFilter','cancel','checkPlaceFurnitureCollision','RefreshFurnitureModeVisuals','_furnitureSystemSettings','VMrab','isEnabled','OUTLINE_FILTER_ALLOW_COLOR','BfNQD','AllowFurniture','updateOutlineFilter','tileHeight','Region','HpRlf','WeGkD','innerWidth','furnitureEventTemplateData','CUVEX','FurnitureNeedEventCollisionCheck','RegionsAllow','list','PositionButtons','SKIMy','randomInt','playPlaceFurnitureSound','This\x20furniture\x27s\x20settings\x20will\x20softlock\x20the\x20player.\x0aCancel\x20is\x20reenabled.','FurnitureItem','dimColor1','max','addChild'];_0x4bf0=function(){return _0x34a800;};return _0x4bf0();}