//=============================================================================
// VisuStella MZ - Party System
// VisuMZ_2_PartySystem.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_2_PartySystem = true;

var VisuMZ = VisuMZ || {};
VisuMZ.PartySystem = VisuMZ.PartySystem || {};
VisuMZ.PartySystem.version = 1.30;

//=============================================================================
/* ----------------------------------------------------------------------------
 * General Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~General:
 *
 * @param General
 *
 * @param MaxBattleMembers:num
 * @text Max Battle Members
 * @parent General
 * @type number
 * @min 1
 * @desc Maximum number of battle members.
 * @default 4
 *
 * @param BattleScene
 * @text Battle Scene
 *
 * @param BattlePartyIcon:num
 * @text Battle Party Icon
 * @parent BattleScene
 * @desc Icon used for changing party members.
 * @default 75
 *
 * @param PartyScene
 * @text Party Scene
 *
 * @param AddRemoveCmd:eval
 * @text Add Remove Command
 * @parent PartyScene
 * @type boolean
 * @on Add Command
 * @off Don't Add
 * @desc Add the 'Remove' command to the party scene?
 * @default true
 *
 * @param LockIcon:num
 * @text Locked Member Icon
 * @parent PartyScene
 * @desc Icon used for a locked party member.
 * @default 195
 *
 * @param RequireIcon:num
 * @text Required Member Icon
 * @parent PartyScene
 * @desc Icon used for a required party member.
 * @default 87
 *
 * @param DrawBackRect:eval
 * @text Show Back Rectangles?
 * @parent PartyScene
 * @type boolean
 * @on Draw
 * @off Don't Draw
 * @desc Show back rectangles of darker colors to display information better?
 * @default true
 *
 * @param BackRectColor:str
 * @text Back Rectangle Color
 * @parent DrawBackRect:eval
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 19
 *
 * @param PartyCmdWin
 * @text Party Command Window
 *
 * @param PartyCmdWinAddParty:eval
 * @text Add Party Command
 * @parent PartyCmdWin
 * @type boolean
 * @on Add Command
 * @off Don't Add
 * @desc Add the 'Party' command to the Party Command Window?
 * @default false
 *
 * @param PartyCmdCooldown:num
 * @text Command Cooldown
 * @parent PartyCmdWin
 * @desc Cooldown (in turns) for this command to be available again.
 * @default 1
 *
 * @param ActorCmdWin
 * @text Actor Command Window
 *
 * @param ActorCmdWinAddParty:eval
 * @text Add Switch Command
 * @parent ActorCmdWin
 * @type boolean
 * @on Add Command
 * @off Don't Add
 * @desc Add the 'Switch' command to the Actor Command Window?
 * @default true
 *
 * @param ActorCmdCooldown:num
 * @text Command Cooldown
 * @parent ActorCmdWin
 * @desc Cooldown (in turns) for this command to be available again.
 * @default 1
 *
 * @param SwitchOutAnimation:eval
 * @text Switch Out Animation?
 * @parent ActorCmdWin
 * @type boolean
 * @on Show
 * @off Don't
 * @desc Show the sprites switching out when using individual party member switching?
 * @default true
 *
 * @param tpbImmediateAction:eval
 * @text TPB: Immediate Action
 * @parent ActorCmdWin
 * @type boolean
 * @on Immediate Action
 * @off Empty Gauge
 * @desc Allow actors to immediate act upon switching in for TPB battle systems?
 * @default true
 *
 */
/* ----------------------------------------------------------------------------
 * Vocabulary Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Vocab:
 *
 * @param General
 *
 * @param ActiveParty:str
 * @text Active Party
 * @parent General
 * @desc Vocabulary used to represent the Active Party.
 * @default Active Party
 *
 * @param ReserveParty:str
 * @text Reserve Party
 * @parent General
 * @desc Vocabulary used to represent the Reserve Party.
 * @default Reserve Party
 *
 * @param Status:str
 * @text Status
 * @parent General
 * @desc Vocabulary used to represent the Status Window.
 * @default Status
 *
 * @param PartyScene
 * @text Party Scene
 *
 * @param Windows
 * @parent PartyScene
 *
 * @param Empty:str
 * @text Empty
 * @parent Windows
 * @desc For the party and status windows when no actor is selected.
 * @default - Empty -
 *
 * @param Remove:str
 * @text Remove
 * @parent Windows
 * @desc For the remove option.
 * @default Remove
 *
 * @param ButtonAssist
 * @text Button Assist
 * @parent PartyScene
 *
 * @param AssistSwapPosition:str
 * @text Swap Positions
 * @parent ButtonAssist
 * @desc Button assist text for the page up/down commands.
 * Requires VisuMZ_0_CoreEngine!
 * @default Quick Swap
 *
 * @param AssistRemove:str
 * @text Remove
 * @parent ButtonAssist
 * @desc Button assist text for the removal command.
 * Requires VisuMZ_0_CoreEngine!
 * @default Remove
 *
 * @param AssistSort:str
 * @text Sort
 * @parent ButtonAssist
 * @desc Button assist text for the sort command.
 * Requires VisuMZ_0_CoreEngine!
 * @default Sort
 *
 * @param AssistSwapIn:str
 * @text Swap In
 * @parent ButtonAssist
 * @desc Button assist text for swapping in actors.
 * Requires VisuMZ_0_CoreEngine!
 * @default Swap In
 *
 * @param AssistSwapOut:str
 * @text Swap Out
 * @parent ButtonAssist
 * @desc Button assist text for swapping out actors.
 * Requires VisuMZ_0_CoreEngine!
 * @default Swap Out
 *
 * @param BattleScene
 * @text Battle Scene
 *
 * @param BattlePartyCmd:str
 * @text Party Command
 * @parent BattleScene
 * @desc Command text for entering Party Scene.
 * Requires VisuMZ_1_BattleCore!
 * @default Party
 *
 * @param BattleHelpFormation:json
 * @text Help: Formation
 * @parent BattlePartyCmd:str
 * @type note
 * @desc Help text for Formation command.
 * Requires VisuMZ_1_BattleCore!
 * @default "Change up your party formation."
 *
 * @param QueuePartyScene:str
 * @text Queue Message
 * @parent BattlePartyCmd:str
 * @desc Message to say the Party Scene is queued.
 * Requires VisuMZ_1_BattleCore!
 * @default %1 Menu queued after action is complete.
 *
 * @param BattleSwitchOut:str
 * @text Switch Command
 * @parent BattleScene
 * @desc Command text for switching out members.
 * Requires VisuMZ_1_BattleCore!
 * @default Switch
 *
 * @param BattleHelpSwitch:json
 * @text Help: Switch
 * @parent BattleSwitchOut:str
 * @type note
 * @desc Help text for Switch command.
 * Requires VisuMZ_1_BattleCore!
 * @default "Switch out this party member with another."
 *
 */
/* ----------------------------------------------------------------------------
 * Background Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~BgSettings:
 *
 * @param SnapshotOpacity:num
 * @text Snapshop Opacity
 * @type number
 * @min 0
 * @max 255
 * @desc Snapshot opacity for the scene.
 * @default 192
 *
 * @param BgFilename1:str
 * @text Background 1
 * @type file
 * @dir img/titles1/
 * @desc Filename used for the bottom background image.
 * Leave empty if you don't wish to use one.
 * @default 
 *
 * @param BgFilename2:str
 * @text Background 2
 * @type file
 * @dir img/titles2/
 * @desc Filename used for the upper background image.
 * Leave empty if you don't wish to use one.
 * @default 
 *
 */
/* ----------------------------------------------------------------------------
 * Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Window:
 *
 * @param ActivePartyLabel
 * @text Active Party Label
 *
 * @param ActivePartyLabelBgType:num
 * @text Background Type
 * @parent ActivePartyLabel
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param ActivePartyLabelRect:func
 * @text JS: X, Y, W, H
 * @parent ActivePartyLabel
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const wx = 0;\nconst wy = this.mainAreaTop();\nconst ww = Graphics.boxWidth;\nconst wh = Window_Base.prototype.lineHeight();\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param ActivePartyWindow
 * @text Active Party Window
 *
 * @param ActivePartyWindowBgType:num
 * @text Background Type
 * @parent ActivePartyWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param ActivePartyGraphic:str
 * @text Actor Graphic
 * @parent ActivePartyWindow
 * @type select
 * @option None
 * @value none
 * @option Face
 * @value face
 * @option Map Sprite
 * @value sprite
 * @option Sideview Battler (Requires VisuMZ_1_MainMenuCore)
 * @value svbattler
 * @desc Choose how the actor graphics appear in the active party menu.
 * @default face
 *
 * @param ActivePartyMapSprite
 * @text Map Sprite
 * @parent ActivePartyGraphic:str
 *
 * @param ActiveSpriteOffsetX:num
 * @text Offset X
 * @parent ActivePartyMapSprite
 * @desc If showing map sprites, offset the x coordinate here from center.
 * @default 0
 *
 * @param ActiveSpriteOffsetY:num
 * @text Offset Y
 * @parent ActivePartyMapSprite
 * @desc If showing map sprites, offset the y coordinate here from bottom.
 * @default 4
 *
 * @param ActivePartySvBattler
 * @text Sideview Battler
 * @parent ActivePartyGraphic:str
 *
 * @param ActiveBattlerOffsetX:num
 * @text Offset X
 * @parent ActivePartySvBattler
 * @desc If showing sideview battlers, offset the x coordinate here from center.
 * @default 0
 *
 * @param ActiveBattlerOffsetY:num
 * @text Offset Y
 * @parent ActivePartySvBattler
 * @desc If showing sideview battlers, offset the y coordinate here from bottom.
 * @default 4
 *
 * @param ActivePartyWindowRect:func
 * @text JS: X, Y, W, H
 * @parent ActivePartyWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const wx = 0;\nconst wy = this._activePartyLabel.y + this._activePartyLabel.height;\nconst ww = Graphics.boxWidth;\nconst wh = ImageManager.faceHeight + $gameSystem.windowPadding() * 2 + 2;\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param ReservePartyLabel
 * @text Reserve Party Label
 *
 * @param ReservePartyLabelBgType:num
 * @text Background Type
 * @parent ReservePartyLabel
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param ReservePartyLabelRect:func
 * @text JS: X, Y, W, H
 * @parent ReservePartyLabel
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const ww = Math.max(240, Math.min(Graphics.boxWidth - 576, Math.round(Graphics.boxWidth / 2)));\nconst wx = this.isRightInputMode() ? (Graphics.boxWidth - ww) : 0;\nconst wy = this._activePartyWindow.y + this._activePartyWindow.height;\nconst wh = Window_Base.prototype.lineHeight();\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param ReservePartyWindow
 * @text Reserve Party Window
 *
 * @param ReservePartyWindowBgType:num
 * @text Background Type
 * @parent ReservePartyWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param ReserveCol:num
 * @text Columns
 * @parent ReservePartyWindow
 * @type number
 * @min 1
 * @desc How many columns do you want there to be for the window?
 * @default 1
 *
 * @param ReserveItemThickness:num
 * @text Row Thickness
 * @parent ReservePartyWindow
 * @type number
 * @min 1
 * @desc How many rows thick do you want selectable items to be?
 * @default 2
 *
 * @param ReservePartyGraphic:str
 * @text Actor Graphic
 * @parent ReservePartyWindow
 * @type select
 * @option None
 * @value none
 * @option Face
 * @value face
 * @option Map Sprite
 * @value sprite
 * @option Sideview Battler (Requires VisuMZ_1_MainMenuCore)
 * @value svbattler
 * @desc Choose how the actor graphics appear in the reserve party menu.
 * @default face
 *
 * @param ReservePartyMapSprite
 * @text Map Sprite
 * @parent ReservePartyGraphic:str
 *
 * @param ReserveSpriteOffsetX:num
 * @text Offset X
 * @parent ReservePartyMapSprite
 * @desc If showing map sprites, offset the x coordinate here from left.
 * @default 24
 *
 * @param ReserveSpriteOffsetY:num
 * @text Offset Y
 * @parent ReservePartyMapSprite
 * @desc If showing map sprites, offset the y coordinate here from bottom.
 * @default 4
 *
 * @param ReservePartySvBattler
 * @text Sideview Battler
 * @parent ReservePartyGraphic:str
 *
 * @param ReserveBattlerOffsetX:num
 * @text Offset X
 * @parent ReservePartySvBattler
 * @desc If showing sideview battlers, offset the x coordinate here from left.
 * @default 48
 *
 * @param ReserveBattlerOffsetY:num
 * @text Offset Y
 * @parent ReservePartySvBattler
 * @desc If showing sideview battlers, offset the y coordinate here from bottom.
 * @default 4
 *
 * @param ReservePartyWindowRect:func
 * @text JS: X, Y, W, H
 * @parent ReservePartyWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const ww = this._reservePartyLabel.width;\nconst wx = this._reservePartyLabel.x;\nconst wy = this._reservePartyLabel.y + this._reservePartyLabel.height;\nconst wh = this.mainAreaHeight() - this._reservePartyLabel.height - this._activePartyWindow.height - this._activePartyLabel.height;\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param StatusLabel
 * @text Status Label
 *
 * @param StatusLabelBgType:num
 * @text Background Type
 * @parent StatusLabel
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param StatusLabelRect:func
 * @text JS: X, Y, W, H
 * @parent StatusLabel
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const ww = Graphics.boxWidth - this._reservePartyLabel.width;\nconst wx = this.isRightInputMode() ? 0 : (Graphics.boxWidth - ww);\nconst wy = this._activePartyWindow.y + this._activePartyWindow.height;\nconst wh = Window_Base.prototype.lineHeight();\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param StatusWindow
 * @text Status Window
 *
 * @param StatusWindowBgType:num
 * @text Background Type
 * @parent StatusWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param StatusWindowDraw:func
 * @text JS: Draw Data
 * @parent StatusWindow
 * @type note
 * @desc Code used to draw the display data in the Status Window.
 * @default "// Draw Empty\nif (!this._actor) {\n    this.drawItemDarkRect(0, 0, this.innerWidth, this.innerHeight);\n    const y = Math.round((this.innerHeight - this.lineHeight()) / 2);\n    this.changeTextColor(ColorManager.systemColor());\n    this.drawText(TextManager.emptyPartyMember, 0, y, this.innerWidth, 'center');\n    return;\n}\n\n// Draw Face and Simple Status\nthis.drawActorFace(this._actor, 1, 0, ImageManager.faceWidth, ImageManager.faceHeight);\nthis.drawActorSimpleStatus(this._actor, ImageManager.faceWidth + 36, 0);\n\n// Declare Constants\nconst lineHeight = this.lineHeight();\nconst params = this.actorParams();\nconst paramWidth = Math.round(this.innerWidth / 2);\nconst paramHeight = Math.ceil(params.length / 2) * lineHeight;\nconst baseX = 0;\nlet x = 0;\nlet y = ImageManager.faceHeight + lineHeight / 2;\n\n// Draw Parameters\nfor (const param of params) {\n    this.drawItemDarkRect(x, y, paramWidth, lineHeight);\n    this.drawParamName(param, x, y, paramWidth);\n    this.drawParamValue(param, x, y, paramWidth);\n\n    if (x === baseX) {\n        x += paramWidth;\n    } else {\n        x = baseX;\n        y += lineHeight;\n    }\n}"
 *
 * @param StatusWindowRect:func
 * @text JS: X, Y, W, H
 * @parent StatusWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const ww = this._statusPartyLabel.width;\nconst wx = this.isRightInputMode() ? 0 : (Graphics.boxWidth - ww);\nconst wy = this._reservePartyWindow.y;\nconst wh = this._reservePartyWindow.height;\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param BattleSwitchWindow
 * @text Battle Switch Window
 *
 * @param BattleSwitchWindowBgType:num
 * @text Background Type
 * @parent BattleSwitchWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param BattleSwitchWindowRect:func
 * @text JS: X, Y, W, H
 * @parent BattleSwitchWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * Does not apply to Border Battle Layout style.
 * @default "const padding = $gameSystem.windowPadding() * 2;\nlet ww = 516 + padding;\nlet wh = Window_PartyBattleSwitch.prototype.itemHeight() * 4 + padding;\nlet wx = Math.round(Graphics.boxWidth - ww) / 2;\nlet wy = Math.round(Graphics.boxHeight - wh - this._statusWindow.height) / 2;\nwy = wy.clamp(0, Graphics.boxHeight - wh - this._statusWindow.height);\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 */
//=============================================================================

const _0x259311=_0x245e;(function(_0x3b6196,_0x3f66df){const _0x413ecd=_0x245e,_0x5214b5=_0x3b6196();while(!![]){try{const _0xaa78d8=-parseInt(_0x413ecd(0x257))/0x1*(parseInt(_0x413ecd(0x1b5))/0x2)+-parseInt(_0x413ecd(0x2c3))/0x3+parseInt(_0x413ecd(0x1aa))/0x4+parseInt(_0x413ecd(0x2ea))/0x5*(parseInt(_0x413ecd(0x371))/0x6)+-parseInt(_0x413ecd(0x3a2))/0x7*(-parseInt(_0x413ecd(0x29f))/0x8)+parseInt(_0x413ecd(0x38c))/0x9+-parseInt(_0x413ecd(0x1a0))/0xa*(-parseInt(_0x413ecd(0x318))/0xb);if(_0xaa78d8===_0x3f66df)break;else _0x5214b5['push'](_0x5214b5['shift']());}catch(_0x55b234){_0x5214b5['push'](_0x5214b5['shift']());}}}(_0x2536,0xaa32d));var label='PartySystem',tier=tier||0x0,dependencies=[],pluginData=$plugins[_0x259311(0x1d9)](function(_0x325648){const _0x4e1caf=_0x259311;return _0x325648['status']&&_0x325648[_0x4e1caf(0x25e)]['includes']('['+label+']');})[0x0];VisuMZ[label][_0x259311(0x195)]=VisuMZ[label][_0x259311(0x195)]||{},VisuMZ[_0x259311(0x2cf)]=function(_0x36262f,_0x4fdeea){const _0x450349=_0x259311;for(const _0x5e6a64 in _0x4fdeea){if(_0x5e6a64[_0x450349(0x349)](/(.*):(.*)/i)){const _0x499c21=String(RegExp['$1']),_0x5a53b1=String(RegExp['$2'])[_0x450349(0x1f4)]()[_0x450349(0x269)]();let _0x18f2a,_0x1f65fd,_0x234e53;switch(_0x5a53b1){case _0x450349(0x221):_0x18f2a=_0x4fdeea[_0x5e6a64]!==''?Number(_0x4fdeea[_0x5e6a64]):0x0;break;case _0x450349(0x299):_0x1f65fd=_0x4fdeea[_0x5e6a64]!==''?JSON[_0x450349(0x2fd)](_0x4fdeea[_0x5e6a64]):[],_0x18f2a=_0x1f65fd[_0x450349(0x284)](_0x355e03=>Number(_0x355e03));break;case _0x450349(0x1ef):_0x18f2a=_0x4fdeea[_0x5e6a64]!==''?eval(_0x4fdeea[_0x5e6a64]):null;break;case _0x450349(0x251):_0x1f65fd=_0x4fdeea[_0x5e6a64]!==''?JSON[_0x450349(0x2fd)](_0x4fdeea[_0x5e6a64]):[],_0x18f2a=_0x1f65fd[_0x450349(0x284)](_0x20481e=>eval(_0x20481e));break;case _0x450349(0x358):_0x18f2a=_0x4fdeea[_0x5e6a64]!==''?JSON[_0x450349(0x2fd)](_0x4fdeea[_0x5e6a64]):'';break;case _0x450349(0x248):_0x1f65fd=_0x4fdeea[_0x5e6a64]!==''?JSON['parse'](_0x4fdeea[_0x5e6a64]):[],_0x18f2a=_0x1f65fd[_0x450349(0x284)](_0x262b67=>JSON[_0x450349(0x2fd)](_0x262b67));break;case _0x450349(0x304):_0x18f2a=_0x4fdeea[_0x5e6a64]!==''?new Function(JSON[_0x450349(0x2fd)](_0x4fdeea[_0x5e6a64])):new Function(_0x450349(0x206));break;case _0x450349(0x18b):_0x1f65fd=_0x4fdeea[_0x5e6a64]!==''?JSON[_0x450349(0x2fd)](_0x4fdeea[_0x5e6a64]):[],_0x18f2a=_0x1f65fd['map'](_0x360ceb=>new Function(JSON[_0x450349(0x2fd)](_0x360ceb)));break;case'STR':_0x18f2a=_0x4fdeea[_0x5e6a64]!==''?String(_0x4fdeea[_0x5e6a64]):'';break;case'ARRAYSTR':_0x1f65fd=_0x4fdeea[_0x5e6a64]!==''?JSON[_0x450349(0x2fd)](_0x4fdeea[_0x5e6a64]):[],_0x18f2a=_0x1f65fd['map'](_0x560bd0=>String(_0x560bd0));break;case'STRUCT':_0x234e53=_0x4fdeea[_0x5e6a64]!==''?JSON['parse'](_0x4fdeea[_0x5e6a64]):{},_0x18f2a=VisuMZ[_0x450349(0x2cf)]({},_0x234e53);break;case _0x450349(0x2d7):_0x1f65fd=_0x4fdeea[_0x5e6a64]!==''?JSON[_0x450349(0x2fd)](_0x4fdeea[_0x5e6a64]):[],_0x18f2a=_0x1f65fd[_0x450349(0x284)](_0x5251c7=>VisuMZ[_0x450349(0x2cf)]({},JSON['parse'](_0x5251c7)));break;default:continue;}_0x36262f[_0x499c21]=_0x18f2a;}}return _0x36262f;},(_0x531ce3=>{const _0x7ffef4=_0x259311,_0x4b9db7=_0x531ce3[_0x7ffef4(0x208)];for(const _0x15d88a of dependencies){if(!Imported[_0x15d88a]){alert(_0x7ffef4(0x332)[_0x7ffef4(0x207)](_0x4b9db7,_0x15d88a)),SceneManager[_0x7ffef4(0x302)]();break;}}const _0x42cfda=_0x531ce3['description'];if(_0x42cfda[_0x7ffef4(0x349)](/\[Version[ ](.*?)\]/i)){const _0x4ee499=Number(RegExp['$1']);_0x4ee499!==VisuMZ[label][_0x7ffef4(0x2a9)]&&(alert(_0x7ffef4(0x190)['format'](_0x4b9db7,_0x4ee499)),SceneManager[_0x7ffef4(0x302)]());}if(_0x42cfda[_0x7ffef4(0x349)](/\[Tier[ ](\d+)\]/i)){const _0x510052=Number(RegExp['$1']);_0x510052<tier?(alert(_0x7ffef4(0x347)[_0x7ffef4(0x207)](_0x4b9db7,_0x510052,tier)),SceneManager['exit']()):tier=Math[_0x7ffef4(0x310)](_0x510052,tier);}VisuMZ[_0x7ffef4(0x2cf)](VisuMZ[label]['Settings'],_0x531ce3[_0x7ffef4(0x25f)]);})(pluginData),PluginManager[_0x259311(0x2b9)](pluginData[_0x259311(0x208)],_0x259311(0x2b6),_0x217435=>{const _0x3a27a2=_0x259311;SceneManager[_0x3a27a2(0x30c)](Scene_Party);}),PluginManager[_0x259311(0x2b9)](pluginData[_0x259311(0x208)],_0x259311(0x2e8),_0x56d59c=>{const _0xeb4e7e=_0x259311;if($gameParty['inBattle']())return;VisuMZ[_0xeb4e7e(0x2cf)](_0x56d59c,_0x56d59c);const _0x3c4523=_0x56d59c[_0xeb4e7e(0x294)];$gameParty[_0xeb4e7e(0x1b1)](_0x3c4523);}),PluginManager[_0x259311(0x2b9)](pluginData[_0x259311(0x208)],_0x259311(0x18d),_0x30caac=>{const _0x43dfdb=_0x259311;if(!SceneManager[_0x43dfdb(0x2e0)]())return;VisuMZ[_0x43dfdb(0x2cf)](_0x30caac,_0x30caac);const _0xbd9601=_0x30caac['Actors'];for(const _0x4982ff of _0xbd9601){if(_0x43dfdb(0x218)===_0x43dfdb(0x218))$gameParty['addActorToBattleMembers'](_0x4982ff);else{const _0x1f1def=this[_0x43dfdb(0x378)][_0x43dfdb(0x1f8)](),_0x15d258=this['_activePartyWindow'][_0x43dfdb(0x1d6)]();if(_0x1f1def<0x0){if(_0x15d258)_0x5099f9[_0x43dfdb(0x29d)](_0x15d258['actorId']());}else{const _0x22c820=this[_0x43dfdb(0x378)][_0x43dfdb(0x1d6)]()[_0x43dfdb(0x19e)](),_0x98c946=this['_activePartyWindow']['index']();if(_0x15d258)_0x4f7224[_0x43dfdb(0x29d)](_0x15d258[_0x43dfdb(0x19e)]());_0x24ca94[_0x43dfdb(0x3a3)](_0x22c820,_0x98c946);}this['refreshAllWindows'](),this['onReserveCancel']();}}$gamePlayer[_0x43dfdb(0x36d)]();}),PluginManager['registerCommand'](pluginData[_0x259311(0x208)],_0x259311(0x2bb),_0x57c3a8=>{const _0x34922b=_0x259311;if(!SceneManager[_0x34922b(0x2e0)]())return;VisuMZ[_0x34922b(0x2cf)](_0x57c3a8,_0x57c3a8);const _0x525ffb=_0x57c3a8['Actors'];for(const _0x59466e of _0x525ffb){if(_0x34922b(0x1b4)!==_0x34922b(0x223)){if($gameParty[_0x34922b(0x24f)]()[_0x34922b(0x323)]<=0x1)break;$gameParty['removeActorFromBattleMembers'](_0x59466e);}else this[_0x34922b(0x2c1)]();}$gamePlayer[_0x34922b(0x36d)]();}),PluginManager[_0x259311(0x2b9)](pluginData[_0x259311(0x208)],_0x259311(0x1a1),_0x2aa6cb=>{const _0x28bc6f=_0x259311;if(!SceneManager[_0x28bc6f(0x2e0)]())return;if($gameParty['battleMembers']()[_0x28bc6f(0x323)]<=0x1)return;if(!$gameParty[_0x28bc6f(0x1f6)])return;if($gameParty[_0x28bc6f(0x1f6)][_0x28bc6f(0x323)]<=0x0)return;VisuMZ[_0x28bc6f(0x2cf)](_0x2aa6cb,_0x2aa6cb);const _0x3a0c20=_0x2aa6cb[_0x28bc6f(0x22f)],_0x3af9e1=$gameParty[_0x28bc6f(0x1f6)][_0x3a0c20];$gameParty[_0x28bc6f(0x29d)](_0x3af9e1),$gamePlayer[_0x28bc6f(0x36d)]();}),PluginManager[_0x259311(0x2b9)](pluginData[_0x259311(0x208)],_0x259311(0x3c5),_0x22ce27=>{const _0x481a14=_0x259311;if(!SceneManager[_0x481a14(0x2e0)]())return;if($gameParty[_0x481a14(0x24f)]()[_0x481a14(0x323)]>=$gameParty[_0x481a14(0x25b)]())return;if($gameParty[_0x481a14(0x226)]()[_0x481a14(0x323)]<=0x0)return;const _0x5e1d78=$gameParty['reserveMembers'](),_0x4ad5ea=_0x5e1d78[Math[_0x481a14(0x2e9)](Math[_0x481a14(0x1ae)]()*_0x5e1d78[_0x481a14(0x323)])],_0x4c119e=_0x4ad5ea['actorId']();$gameParty['addActorToBattleMembers'](_0x4c119e),$gamePlayer[_0x481a14(0x36d)]();}),PluginManager[_0x259311(0x2b9)](pluginData[_0x259311(0x208)],_0x259311(0x34a),_0x5cc6f4=>{const _0x104ffa=_0x259311;VisuMZ[_0x104ffa(0x2cf)](_0x5cc6f4,_0x5cc6f4);const _0x5caf56=_0x5cc6f4[_0x104ffa(0x35f)]['map'](_0x54eeb2=>$gameActors['actor'](_0x54eeb2))['remove'](null),_0x42ad34=_0x5cc6f4[_0x104ffa(0x3b2)];for(const _0x4a6a5f of _0x5caf56){if(_0x104ffa(0x21e)===_0x104ffa(0x2f2))this[_0x104ffa(0x19d)](_0x2d31cb,_0x1b8502,_0x30e047);else{if(!_0x4a6a5f)continue;_0x4a6a5f[_0x104ffa(0x2db)](_0x42ad34);}}}),PluginManager['registerCommand'](pluginData[_0x259311(0x208)],_0x259311(0x3c3),_0x1e9ba5=>{const _0x38e1e0=_0x259311;VisuMZ[_0x38e1e0(0x2cf)](_0x1e9ba5,_0x1e9ba5);const _0x2a590b=_0x1e9ba5[_0x38e1e0(0x35f)]['map'](_0x26d615=>$gameActors[_0x38e1e0(0x3ca)](_0x26d615))[_0x38e1e0(0x33c)](null),_0x445a3e=_0x1e9ba5['Require'];for(const _0x271c67 of _0x2a590b){if(!_0x271c67)continue;_0x271c67['setPartyRequirement'](_0x445a3e);}}),ImageManager[_0x259311(0x1f2)]=VisuMZ[_0x259311(0x26b)][_0x259311(0x195)][_0x259311(0x370)]['LockIcon'],ImageManager['requiredPartyMemberIcon']=VisuMZ[_0x259311(0x26b)][_0x259311(0x195)]['General'][_0x259311(0x3bf)],TextManager[_0x259311(0x24a)]=VisuMZ[_0x259311(0x26b)][_0x259311(0x195)]['Vocab'][_0x259311(0x2dd)],TextManager[_0x259311(0x253)]=VisuMZ[_0x259311(0x26b)][_0x259311(0x195)]['Vocab'][_0x259311(0x320)],TextManager['statusParty']=VisuMZ[_0x259311(0x26b)]['Settings']['Vocab'][_0x259311(0x2cb)],TextManager[_0x259311(0x3b6)]=VisuMZ['PartySystem'][_0x259311(0x195)][_0x259311(0x326)][_0x259311(0x3a9)],TextManager[_0x259311(0x30b)]=VisuMZ[_0x259311(0x26b)][_0x259311(0x195)][_0x259311(0x326)][_0x259311(0x3c8)],TextManager[_0x259311(0x367)]=VisuMZ[_0x259311(0x26b)][_0x259311(0x195)]['Vocab'][_0x259311(0x1ea)],TextManager['assistRemovePartyMember']=VisuMZ[_0x259311(0x26b)]['Settings']['Vocab'][_0x259311(0x36b)],TextManager[_0x259311(0x203)]=VisuMZ[_0x259311(0x26b)][_0x259311(0x195)][_0x259311(0x326)]['AssistSort'],TextManager['assistSwapInPartyMember']=VisuMZ['PartySystem']['Settings'][_0x259311(0x326)]['AssistSwapIn'],TextManager['assistSwapOutPartyMember']=VisuMZ['PartySystem'][_0x259311(0x195)][_0x259311(0x326)]['AssistSwapOut'],ColorManager[_0x259311(0x1e6)]=function(_0x2470d2){const _0x38c294=_0x259311;return _0x2470d2=String(_0x2470d2),_0x2470d2[_0x38c294(0x349)](/#(.*)/i)?_0x38c294(0x29c)[_0x38c294(0x207)](String(RegExp['$1'])):_0x38c294(0x315)===_0x38c294(0x315)?this[_0x38c294(0x245)](Number(_0x2470d2)):_0x34424d[_0x38c294(0x226)]()[_0x147201];},SceneManager['isSceneParty']=function(){const _0xf9804b=_0x259311;return this[_0xf9804b(0x39d)]&&this[_0xf9804b(0x39d)][_0xf9804b(0x28c)]===Scene_Party;},SceneManager[_0x259311(0x2e0)]=function(){const _0x42f45e=_0x259311;return this[_0x42f45e(0x39d)]&&this[_0x42f45e(0x39d)][_0x42f45e(0x28c)]===Scene_Map;},VisuMZ[_0x259311(0x26b)][_0x259311(0x33f)]=BattleManager[_0x259311(0x2a6)],BattleManager[_0x259311(0x2a6)]=function(_0x1b9a5a,_0x38f75d,_0x543fa7){const _0x16f893=_0x259311;VisuMZ['PartySystem'][_0x16f893(0x33f)][_0x16f893(0x38a)](this,_0x1b9a5a,_0x38f75d,_0x543fa7),$gameParty[_0x16f893(0x281)]();},BattleManager[_0x259311(0x384)]=function(_0x197473,_0x350b02){const _0x1464c8=_0x259311;if(_0x197473===_0x350b02)return;if(!_0x197473)return;if(!_0x350b02)return;if(this[_0x1464c8(0x24b)]===_0x197473)this[_0x1464c8(0x24b)]=_0x350b02;while(this[_0x1464c8(0x2b5)][_0x1464c8(0x37a)](_0x197473)){const _0x51777e=this[_0x1464c8(0x2b5)][_0x1464c8(0x2dc)](_0x197473);this[_0x1464c8(0x2b5)][_0x51777e]=_0x350b02;}},VisuMZ['PartySystem']['Game_Battler_onBattleStart']=Game_Battler[_0x259311(0x292)][_0x259311(0x28d)],Game_Battler[_0x259311(0x292)][_0x259311(0x28d)]=function(_0xd77b26){const _0x329c50=_0x259311;VisuMZ[_0x329c50(0x26b)][_0x329c50(0x21c)]['call'](this,_0xd77b26);if(this['isActor']())this[_0x329c50(0x3a0)]();this[_0x329c50(0x353)]();},VisuMZ[_0x259311(0x26b)][_0x259311(0x243)]=Game_Battler['prototype'][_0x259311(0x36f)],Game_Battler[_0x259311(0x292)][_0x259311(0x36f)]=function(){const _0x49a055=_0x259311;VisuMZ[_0x49a055(0x26b)][_0x49a055(0x243)][_0x49a055(0x38a)](this);if(this[_0x49a055(0x1c4)]()&&$gameParty[_0x49a055(0x2da)]())this[_0x49a055(0x275)]();},VisuMZ[_0x259311(0x26b)][_0x259311(0x1c5)]=Game_Actor[_0x259311(0x292)][_0x259311(0x2a6)],Game_Actor[_0x259311(0x292)][_0x259311(0x2a6)]=function(_0x1c488c){const _0x2a7335=_0x259311;VisuMZ['PartySystem'][_0x2a7335(0x1c5)][_0x2a7335(0x38a)](this,_0x1c488c),this['initPartySystem'](),this[_0x2a7335(0x3a0)]();},Game_Actor[_0x259311(0x292)][_0x259311(0x35e)]=function(){const _0x16613b=_0x259311;this[_0x16613b(0x2df)]=![],this[_0x16613b(0x232)]=![];},Game_Actor[_0x259311(0x292)]['isFormationChangeOk']=function(){const _0x363364=_0x259311;if(this[_0x363364(0x2df)]===undefined)this['initPartySystem']();return!this['_partyLocked'];},Game_Actor[_0x259311(0x292)][_0x259311(0x2db)]=function(_0xe72a93){const _0x30c026=_0x259311;if(this['_partyLocked']===undefined)this[_0x30c026(0x35e)]();this[_0x30c026(0x2df)]=_0xe72a93;},Game_Actor[_0x259311(0x292)][_0x259311(0x344)]=function(){if(this['_partyRequired']===undefined)this['initPartySystem']();return this['_partyRequired'];},Game_Actor['prototype'][_0x259311(0x233)]=function(_0x35d38c){const _0x42c932=_0x259311;if(this[_0x42c932(0x232)]===undefined)this[_0x42c932(0x35e)]();this[_0x42c932(0x232)]=_0x35d38c;},Game_Actor[_0x259311(0x292)][_0x259311(0x3a0)]=function(){const _0x324d77=_0x259311;this[_0x324d77(0x1e3)]=0x0;},Game_Actor['prototype'][_0x259311(0x191)]=function(){const _0x493370=_0x259311;if(this[_0x493370(0x1e3)]===undefined)this[_0x493370(0x3a0)]();if(!this[_0x493370(0x1fc)]())return![];if(this['isRequiredInParty']())return![];return this[_0x493370(0x1e3)]<=0x0;},Game_Actor['prototype'][_0x259311(0x300)]=function(){const _0x467a2a=_0x259311;if(this['_partySwitchBattleCommandCooldown']===undefined)this[_0x467a2a(0x3a0)]();return this[_0x467a2a(0x1e3)];},Game_Actor['prototype'][_0x259311(0x296)]=function(_0x238ada){const _0x241676=_0x259311;if(this[_0x241676(0x1e3)]===undefined)this[_0x241676(0x3a0)]();this[_0x241676(0x1e3)]=_0x238ada||0x0;},Game_Actor[_0x259311(0x292)]['applyBattlePartySwitchCooldown']=function(){const _0x1202a9=_0x259311;if(this[_0x1202a9(0x1e3)]===undefined)this[_0x1202a9(0x3a0)]();const _0x280f01=VisuMZ[_0x1202a9(0x26b)][_0x1202a9(0x195)]['General']['ActorCmdCooldown'];this['setBattlePartySwitchCooldown'](_0x280f01);},Game_Actor[_0x259311(0x292)]['updateBattlePartySwitchCooldown']=function(){const _0x2aba8d=_0x259311;if(this[_0x2aba8d(0x1e3)]===undefined)this['clearPartySwitchCommandCooldown']();this[_0x2aba8d(0x1e3)]--;},Game_Actor[_0x259311(0x292)][_0x259311(0x1e0)]=function(_0x419d14){const _0x118e19=_0x259311;if(Imported['VisuMZ_2_BattleSystemCTB']&&BattleManager[_0x118e19(0x357)]()){if(_0x118e19(0x309)!==_0x118e19(0x309))return _0xf3f749['PartySystem'][_0x118e19(0x195)][_0x118e19(0x3b4)]['ActivePartyLabelRect'][_0x118e19(0x38a)](this);else BattleManager[_0x118e19(0x1bb)]();}Imported[_0x118e19(0x327)]&&BattleManager[_0x118e19(0x264)]()&&(BattleManager[_0x118e19(0x394)](),BattleManager['_subject']=this,BattleManager[_0x118e19(0x276)]=this);if(Imported[_0x118e19(0x377)]&&BattleManager['isBTB']()){BattleManager[_0x118e19(0x20f)]=undefined,BattleManager[_0x118e19(0x276)]=this;const _0x102a3e=BattleManager[_0x118e19(0x1cb)][_0x118e19(0x2dc)](_0x419d14);BattleManager[_0x118e19(0x1cb)][_0x102a3e]=this,BattleManager[_0x118e19(0x2e7)]();}Imported[_0x118e19(0x227)]&&BattleManager[_0x118e19(0x30a)]()&&(_0x118e19(0x3bb)!==_0x118e19(0x36e)?(BattleManager[_0x118e19(0x20f)]=this,BattleManager[_0x118e19(0x276)]=this,BattleManager['replaceActionBattlersPartySwitch'](_0x419d14,this)):(_0x1284cd[_0x118e19(0x26b)][_0x118e19(0x22a)]['call'](this),this[_0x118e19(0x330)]['setHandler'](_0x118e19(0x283),this[_0x118e19(0x209)][_0x118e19(0x1c1)](this))));Imported[_0x118e19(0x220)]&&BattleManager[_0x118e19(0x279)]()&&(BattleManager['_subject']=this,BattleManager[_0x118e19(0x276)]=this,BattleManager[_0x118e19(0x306)](_0x419d14,this));Imported[_0x118e19(0x287)]&&BattleManager['isPTB']()&&(_0x118e19(0x3b9)===_0x118e19(0x379)?(this[_0x118e19(0x1d7)](_0x5e8cc9,_0x4579ad,_0xb21573,_0x381b15),this[_0x118e19(0x2fc)](_0x28b7f5,_0xdeca99,_0x1b02e7,_0x4fc2c1),this['drawParamValue'](_0x58eaa7,_0x28a0ad,_0x35448,_0x455e16),_0x18540e===_0x4dbe18?_0x1170d6+=_0x4ee429:(_0x1f6077=_0x4e1f10,_0x349d2d+=_0x2fa176)):(BattleManager[_0x118e19(0x20f)]=this,BattleManager['_currentActor']=this,BattleManager[_0x118e19(0x306)](_0x419d14,this)));if(Imported[_0x118e19(0x2d9)]&&BattleManager[_0x118e19(0x356)]()){if(_0x118e19(0x263)!==_0x118e19(0x263))this['initialize'](...arguments);else{BattleManager[_0x118e19(0x20f)]=this,BattleManager[_0x118e19(0x276)]=this;for(let _0x3463b9=0x0;_0x3463b9<BattleManager[_0x118e19(0x1cb)][_0x118e19(0x323)];_0x3463b9++){const _0x26f48d=BattleManager[_0x118e19(0x1cb)][_0x3463b9];if(_0x26f48d===_0x419d14){if(_0x118e19(0x23d)===_0x118e19(0x23d))BattleManager[_0x118e19(0x1cb)][_0x3463b9]=this;else{const _0x3f83dd=this[_0x118e19(0x3ca)](_0x135fc3),_0x157b7c=this[_0x118e19(0x3c1)](_0x395e90),_0x381006=_0x15a583[_0x118e19(0x212)]===0x1;_0x157b7c['x']+=_0x43a908[_0x118e19(0x301)]*(_0x381006?0x2:0x1);const _0x3b5700=_0x418188[_0x118e19(0x26b)]['Settings']['Window'],_0x3ef461=_0x157b7c['x']+_0x3b5700['ReserveSpriteOffsetX']+this[_0x118e19(0x1ba)](),_0x5849ee=_0x157b7c['y']+_0x157b7c['height']-_0x3b5700['ReserveSpriteOffsetY'];this['drawActorCharacter'](_0x3f83dd,_0x3ef461,_0x5849ee);}}}for(let _0x5d2196=0x0;_0x5d2196<BattleManager[_0x118e19(0x290)][_0x118e19(0x323)];_0x5d2196++){if(_0x118e19(0x3c7)==='cbzEZ'){const _0x442fab=BattleManager[_0x118e19(0x290)][_0x5d2196];_0x442fab===_0x419d14&&(BattleManager[_0x118e19(0x290)][_0x5d2196]=this);}else this[_0x118e19(0x398)]=0x0;}}}if(Imported[_0x118e19(0x1a4)]&&BattleManager['isUsingGridSystem']()){if(_0x118e19(0x274)==='HoVEC'){const _0x5d9486=_0x419d14['gridRank'](),_0x18c7b3=_0x419d14['gridFlank']();this[_0x118e19(0x215)](_0x5d9486,_0x18c7b3);}else this[_0x118e19(0x2df)]=![],this[_0x118e19(0x232)]=![];}},BattleManager[_0x259311(0x306)]=function(_0x5c016d,_0x58e92a){const _0x5bd8ea=_0x259311;this['_actionBattlers']=this[_0x5bd8ea(0x1cb)]['map'](_0x59738e=>_0x59738e===_0x5c016d?_0x58e92a:_0x59738e);},VisuMZ[_0x259311(0x26b)][_0x259311(0x1dc)]=Game_Unit[_0x259311(0x292)][_0x259311(0x2da)],Game_Unit['prototype'][_0x259311(0x2da)]=function(){const _0xff48ff=_0x259311;if(SceneManager[_0xff48ff(0x18f)]())return![];return VisuMZ[_0xff48ff(0x26b)]['Game_Unit_inBattle']['call'](this);},Game_Party[_0x259311(0x2c0)]=VisuMZ[_0x259311(0x26b)][_0x259311(0x195)]['General'][_0x259311(0x391)],VisuMZ[_0x259311(0x26b)][_0x259311(0x39f)]=Game_Party['prototype'][_0x259311(0x298)],Game_Party['prototype']['initialize']=function(){const _0x176e09=_0x259311;VisuMZ[_0x176e09(0x26b)][_0x176e09(0x39f)][_0x176e09(0x38a)](this),this[_0x176e09(0x281)](),this[_0x176e09(0x387)](),this[_0x176e09(0x282)]();},Game_Party[_0x259311(0x292)][_0x259311(0x281)]=function(){this['_partySystemBattleCommandCooldown']=0x0;},Game_Party['prototype'][_0x259311(0x191)]=function(){const _0x44f409=_0x259311;if(this[_0x44f409(0x398)]===undefined)this[_0x44f409(0x281)]();return this[_0x44f409(0x398)]<=0x0;},Game_Party[_0x259311(0x292)][_0x259311(0x300)]=function(){const _0x52c369=_0x259311;if(this['_partySystemBattleCommandCooldown']===undefined)this[_0x52c369(0x281)]();return this['_partySystemBattleCommandCooldown'];},Game_Party[_0x259311(0x292)]['setBattlePartySwitchCooldown']=function(_0x4f9a29){const _0x5cbc51=_0x259311;if(this[_0x5cbc51(0x398)]===undefined)this[_0x5cbc51(0x281)]();this[_0x5cbc51(0x398)]=_0x4f9a29;},Game_Party[_0x259311(0x292)][_0x259311(0x1b6)]=function(){const _0x40d2e0=_0x259311;if(this['_partySystemBattleCommandCooldown']===undefined)this[_0x40d2e0(0x281)]();this[_0x40d2e0(0x398)]=VisuMZ[_0x40d2e0(0x26b)][_0x40d2e0(0x195)][_0x40d2e0(0x370)][_0x40d2e0(0x382)]||0x0;},Game_Party[_0x259311(0x292)][_0x259311(0x275)]=function(){const _0x3da3e1=_0x259311;if(this[_0x3da3e1(0x398)]===undefined)this['clearPartyBattleCommandCooldown']();this[_0x3da3e1(0x398)]--;},Game_Party['prototype'][_0x259311(0x387)]=function(){this['_battleMaxSize']=0x0;},Game_Party['prototype'][_0x259311(0x1b1)]=function(_0x5f46df){const _0xdcaceb=_0x259311;this[_0xdcaceb(0x1da)]=_0x5f46df,this['initBattleMembers'](!![]),$gamePlayer&&$gamePlayer[_0xdcaceb(0x210)]()&&('fUCbq'!==_0xdcaceb(0x365)?(this[_0xdcaceb(0x1ab)]=!![],this['_logWindow'][_0xdcaceb(0x240)](_0x2752d8['ActiveTpbFormationMessage'][_0xdcaceb(0x207)](_0xd7e897['formation']))):$gamePlayer['followers']()['changeMaxBattleMembers']());},Game_Followers[_0x259311(0x292)][_0x259311(0x1b1)]=function(){const _0x52455d=_0x259311;if(!SceneManager[_0x52455d(0x2e0)]())return;this[_0x52455d(0x2a6)]();const _0xa7f068=$gameMap['mapId'](),_0x3888f4=$gamePlayer['x'],_0x592d78=$gamePlayer['y'],_0xfb287f=$gamePlayer[_0x52455d(0x3ad)]();$gameTemp[_0x52455d(0x3ac)]=!![],$gamePlayer[_0x52455d(0x1ee)](_0xa7f068,_0x3888f4,_0x592d78,_0xfb287f,0x2),setTimeout(this[_0x52455d(0x250)][_0x52455d(0x1c1)](this),0x7d0);},Game_Followers['prototype'][_0x259311(0x250)]=function(){const _0x461836=_0x259311;$gameTemp[_0x461836(0x3ac)]=![];},VisuMZ[_0x259311(0x26b)][_0x259311(0x21a)]=Scene_Base['prototype']['isAutosaveEnabled'],Scene_Base[_0x259311(0x292)][_0x259311(0x3c6)]=function(){const _0x46df06=_0x259311;if($gameTemp[_0x46df06(0x3ac)])return![];return VisuMZ[_0x46df06(0x26b)]['Scene_Base_isAutosaveEnabled'][_0x46df06(0x38a)](this);},Game_Party[_0x259311(0x292)][_0x259311(0x25b)]=function(){const _0x5db62d=_0x259311;if(this[_0x5db62d(0x1da)]===undefined)this['initBattleMembers']();let _0x2eea9b=this[_0x5db62d(0x1da)]||Game_Party[_0x5db62d(0x2c0)];if(Imported[_0x5db62d(0x1a4)]&&BattleManager[_0x5db62d(0x26c)]()){if(_0x5db62d(0x189)===_0x5db62d(0x2a3)){const _0x515b82=this['_activePartyWindow'],_0x3b7054=this['_reservePartyWindow'];if(_0x515b82&&_0x515b82[_0x5db62d(0x27d)]&&_0x515b82[_0x5db62d(0x1d6)]()&&_0x515b82['isShiftRemoveShortcutEnabled']())return _0x3e4b40[_0x5db62d(0x1d0)];else return _0x3b7054&&_0x3b7054[_0x5db62d(0x27d)]&&_0x55a81a[_0x5db62d(0x226)]()[_0x5db62d(0x323)]>0x0?_0x3448fa[_0x5db62d(0x203)]:'';}else _0x2eea9b=_0x2eea9b[_0x5db62d(0x2bf)](0x1,0x14);}return _0x2eea9b;},Game_Party['prototype'][_0x259311(0x1f9)]=function(){const _0x57412e=_0x259311;if(this[_0x57412e(0x1da)]===undefined)this[_0x57412e(0x282)]();if(!this[_0x57412e(0x1f6)])this[_0x57412e(0x282)]();while(this[_0x57412e(0x1f6)][_0x57412e(0x323)]<this[_0x57412e(0x1da)]){this[_0x57412e(0x1f6)][_0x57412e(0x30c)](0x0);}},Game_Party[_0x259311(0x292)][_0x259311(0x282)]=function(_0x17fcbc){const _0x52a285=_0x259311;if(!_0x17fcbc){if(_0x52a285(0x201)===_0x52a285(0x201))this['_battleMaxSize']=Game_Party[_0x52a285(0x2c0)];else{if(_0x47bb14['allMembers']()[_0x52a285(0x323)]<=0x1)return![];if(!_0x2b0fe3[_0x52a285(0x191)]())return![];return _0x45d580['isFormationEnabled']();}}this[_0x52a285(0x1f6)]=this['_actors']['slice'](0x0,this['_battleMaxSize']);while(this['_battleMembers']['length']<this[_0x52a285(0x1da)]){_0x52a285(0x2d1)!=='EYCtS'?this[_0x52a285(0x36d)]():this[_0x52a285(0x1f6)][_0x52a285(0x30c)](0x0);}if($gamePlayer)$gamePlayer['refresh']();},Game_Party['prototype'][_0x259311(0x24f)]=function(){const _0x5b973c=_0x259311;if(Imported['VisuMZ_2_BattleGridSystem']&&SceneManager['isSceneGridTactics']())return this[_0x5b973c(0x335)](!![]);return this['rawBattleMembers']()[_0x5b973c(0x1d9)](_0x256f6f=>!!_0x256f6f);},Game_Party[_0x259311(0x292)]['rawBattleMembers']=function(_0x3131db){const _0x3ea43c=_0x259311;this[_0x3ea43c(0x1f9)]();const _0x5ed27e=this[_0x3ea43c(0x1f6)][_0x3ea43c(0x284)](_0x3e874b=>$gameActors[_0x3ea43c(0x3ca)](_0x3e874b));if(_0x3131db)return _0x5ed27e;return SceneManager['isSceneParty']()?_0x5ed27e:_0x5ed27e[_0x3ea43c(0x1d9)](_0x4c49cc=>_0x4c49cc&&_0x4c49cc[_0x3ea43c(0x33d)]());},Game_Party[_0x259311(0x292)][_0x259311(0x226)]=function(){const _0x256a5c=_0x259311,_0x46873e=this[_0x256a5c(0x24f)]();return this['allMembers']()[_0x256a5c(0x1d9)](_0x4e99d8=>!_0x46873e[_0x256a5c(0x37a)](_0x4e99d8));},VisuMZ[_0x259311(0x26b)]['Game_Party_setupStartingMembers']=Game_Party[_0x259311(0x292)]['setupStartingMembers'],Game_Party[_0x259311(0x292)][_0x259311(0x24c)]=function(){const _0x10f68b=_0x259311;VisuMZ[_0x10f68b(0x26b)][_0x10f68b(0x213)][_0x10f68b(0x38a)](this),this[_0x10f68b(0x282)]();},VisuMZ[_0x259311(0x26b)]['Game_Party_setupBattleTest']=Game_Party['prototype'][_0x259311(0x20b)],Game_Party[_0x259311(0x292)][_0x259311(0x20b)]=function(){const _0x38298b=_0x259311;VisuMZ['PartySystem'][_0x38298b(0x1e7)]['call'](this),this['addNonBattleTestMembers']();},Game_Party[_0x259311(0x292)][_0x259311(0x1e8)]=function(){const _0x17315f=_0x259311;this[_0x17315f(0x1da)]=Game_Party['defaultMaxBattleMembers'],this[_0x17315f(0x1f6)]=[],this[_0x17315f(0x252)]=[];for(const _0x24a18e of $dataSystem['testBattlers']){const _0x32fd1a=$gameActors[_0x17315f(0x3ca)](_0x24a18e[_0x17315f(0x19e)]);if(!_0x32fd1a)continue;_0x32fd1a[_0x17315f(0x2a1)](_0x24a18e[_0x17315f(0x1ed)],![]),_0x32fd1a[_0x17315f(0x194)](_0x24a18e[_0x17315f(0x199)]),_0x32fd1a['recoverAll'](),this['_battleMembers'][_0x17315f(0x30c)](_0x24a18e[_0x17315f(0x19e)]),this[_0x17315f(0x252)]['push'](_0x24a18e[_0x17315f(0x19e)]);}this[_0x17315f(0x1f6)][_0x17315f(0x33c)](0x0);while(this['_battleMembers'][_0x17315f(0x323)]<this['_battleMaxSize']){'tmajc'==='tmajc'?this[_0x17315f(0x1f6)][_0x17315f(0x30c)](0x0):this[_0x17315f(0x1be)]();}while(this[_0x17315f(0x1f6)][_0x17315f(0x323)]>this[_0x17315f(0x25b)]()){this[_0x17315f(0x1f6)][_0x17315f(0x1c2)]();}if($gamePlayer)$gamePlayer[_0x17315f(0x36d)]();},Game_Party[_0x259311(0x292)][_0x259311(0x247)]=function(){const _0x2094c2=_0x259311,_0x4060b3=this['battleMembers']();for(let _0x351014=0x1;_0x351014<$dataActors[_0x2094c2(0x323)];_0x351014++){if(_0x2094c2(0x1ce)===_0x2094c2(0x1ce)){const _0x5adb41=$gameActors[_0x2094c2(0x3ca)](_0x351014);if(!_0x5adb41)continue;if(_0x5adb41[_0x2094c2(0x208)]()[_0x2094c2(0x323)]<=0x0)continue;if(_0x5adb41[_0x2094c2(0x208)]()[_0x2094c2(0x349)](/-----/i))continue;if(_0x4060b3[_0x2094c2(0x37a)](_0x5adb41))continue;this[_0x2094c2(0x252)]['push'](_0x5adb41[_0x2094c2(0x19e)]());}else{if(_0x3a9cd4['uiMenuStyle']&&_0xf5db09['uiInputPosition']!==_0x4d03f7)return _0x8e2ea7[_0x2094c2(0x392)];else return _0x239544['uiMenuStyle']===![]?![]:_0x3ba645[_0x2094c2(0x292)][_0x2094c2(0x303)]['call'](this);}}},VisuMZ[_0x259311(0x26b)][_0x259311(0x334)]=Game_Party[_0x259311(0x292)][_0x259311(0x38b)],Game_Party[_0x259311(0x292)][_0x259311(0x38b)]=function(_0x12aa6b){const _0x363a25=_0x259311;VisuMZ[_0x363a25(0x26b)][_0x363a25(0x334)][_0x363a25(0x38a)](this,_0x12aa6b),this[_0x363a25(0x3ae)](_0x12aa6b);if(SceneManager[_0x363a25(0x23e)]()){if(Imported[_0x363a25(0x2d9)]&&BattleManager[_0x363a25(0x356)]()){if(_0x363a25(0x22c)==='oxBre')BattleManager['removeActionBattlersOTB'](),BattleManager['otbReturnBattlerToTurnOrders']($gameActors[_0x363a25(0x3ca)](_0x12aa6b));else return _0x1e27db[_0x363a25(0x26b)][_0x363a25(0x195)][_0x363a25(0x2ff)][_0x363a25(0x270)];}}},Game_Party[_0x259311(0x292)]['addActorToBattleMembers']=function(_0x5a69fc){const _0x1f4085=_0x259311;this[_0x1f4085(0x1f9)]();if(this[_0x1f4085(0x1f6)]['includes'](_0x5a69fc))return;if(!this[_0x1f4085(0x252)][_0x1f4085(0x37a)](_0x5a69fc))return;if(!this[_0x1f4085(0x1f6)][_0x1f4085(0x37a)](0x0))return;const _0x1363d4=$gameActors[_0x1f4085(0x3ca)](_0x5a69fc);if(!_0x1363d4)return;const _0x18319a=this['_battleMembers']['indexOf'](0x0);if(_0x18319a<0x0)return;this['_battleMembers'][_0x18319a]=_0x5a69fc,SceneManager[_0x1f4085(0x23e)]()&&(_0x1363d4[_0x1f4085(0x28d)](),_0x1363d4['makeActions']()),this['partyChangeRefresh']();},Game_Party[_0x259311(0x292)][_0x259311(0x3a3)]=function(_0x173f94,_0x42e200){const _0x2facec=_0x259311;this[_0x2facec(0x1f9)]();if(this[_0x2facec(0x1f6)]['includes'](_0x173f94))return;if(!this['_battleMembers']['includes'](0x0))return;const _0x5cf585=$gameActors[_0x2facec(0x3ca)](_0x173f94);if(!_0x5cf585)return;this[_0x2facec(0x1f6)][_0x42e200]=_0x173f94,_0x5cf585[_0x2facec(0x1a8)](),this[_0x2facec(0x2c4)]();},VisuMZ['PartySystem'][_0x259311(0x1b0)]=Game_Party[_0x259311(0x292)][_0x259311(0x2b1)],Game_Party[_0x259311(0x292)][_0x259311(0x2b1)]=function(_0x30a466){const _0x3575e8=_0x259311;this[_0x3575e8(0x29d)](_0x30a466),VisuMZ[_0x3575e8(0x26b)][_0x3575e8(0x1b0)][_0x3575e8(0x38a)](this,_0x30a466);},Game_Party[_0x259311(0x292)][_0x259311(0x29d)]=function(_0x147de4){const _0x12d788=_0x259311;this[_0x12d788(0x1f9)]();if(!this[_0x12d788(0x1f6)][_0x12d788(0x37a)](_0x147de4))return;if(_0x147de4<=0x0)return;const _0xe9d460=this['_battleMembers'][_0x12d788(0x2dc)](_0x147de4);this['_battleMembers'][_0xe9d460]=0x0,this[_0x12d788(0x252)]['remove'](_0x147de4),this[_0x12d788(0x252)][_0x12d788(0x30c)](_0x147de4),this[_0x12d788(0x2c4)]();},Game_Party[_0x259311(0x292)][_0x259311(0x2c4)]=function(){const _0x2f5bfc=_0x259311;this[_0x2f5bfc(0x204)](),$gamePlayer[_0x2f5bfc(0x36d)](),$gameMap[_0x2f5bfc(0x3a6)]();},Game_Party[_0x259311(0x292)][_0x259311(0x204)]=function(){const _0x47af80=_0x259311;this['checkInitBattleMembers']();const _0x76a1df=this[_0x47af80(0x24f)]()['concat'](this[_0x47af80(0x226)]());this[_0x47af80(0x252)]=_0x76a1df['map'](_0x4bd0c2=>_0x4bd0c2?_0x4bd0c2[_0x47af80(0x19e)]():0x0)[_0x47af80(0x33c)](0x0);},Game_Party[_0x259311(0x292)][_0x259311(0x2c7)]=function(){const _0x11aeac=_0x259311;this[_0x11aeac(0x252)]['sort']((_0x14be70,_0x59e2f7)=>_0x14be70-_0x59e2f7),this[_0x11aeac(0x204)](),this['partyChangeRefresh']();},Game_Party[_0x259311(0x292)][_0x259311(0x2eb)]=function(){const _0x5bc907=_0x259311;for(const _0x2e5516 of this[_0x5bc907(0x226)]()){if(!_0x2e5516)continue;if(_0x2e5516['isRequiredInParty']())return!![];}return![];},VisuMZ[_0x259311(0x26b)][_0x259311(0x20d)]=Game_Party[_0x259311(0x292)][_0x259311(0x397)],Game_Party[_0x259311(0x292)][_0x259311(0x397)]=function(_0x4081e6,_0x500f71){const _0x366175=_0x259311;VisuMZ[_0x366175(0x26b)][_0x366175(0x20d)][_0x366175(0x38a)](this,_0x4081e6,_0x500f71),this[_0x366175(0x3b1)](_0x4081e6,_0x500f71);},Game_Party[_0x259311(0x292)][_0x259311(0x3b1)]=function(_0x36efb5,_0x1bcefe){const _0x287cbb=_0x259311;this[_0x287cbb(0x1f6)]=[];for(let _0x473c9b=0x0;_0x473c9b<this[_0x287cbb(0x252)][_0x287cbb(0x323)];_0x473c9b++){if(_0x287cbb(0x26a)===_0x287cbb(0x26a)){if(this[_0x287cbb(0x1f6)]['length']>=this['maxBattleMembers']())break;this[_0x287cbb(0x1f6)][_0x473c9b]=this[_0x287cbb(0x252)][_0x473c9b];}else this[_0x287cbb(0x27c)]();}$gamePlayer[_0x287cbb(0x36d)]();},VisuMZ[_0x259311(0x26b)][_0x259311(0x2b4)]=Game_Troop[_0x259311(0x292)]['increaseTurn'],Game_Troop[_0x259311(0x292)][_0x259311(0x1e5)]=function(){const _0x1258af=_0x259311;VisuMZ[_0x1258af(0x26b)]['Game_Troop_increaseTurn'][_0x1258af(0x38a)](this),$gameParty[_0x1258af(0x275)]();},Scene_Menu[_0x259311(0x292)][_0x259311(0x186)]=function(){const _0x103a81=_0x259311;SceneManager[_0x103a81(0x30c)](Scene_Party);};function Scene_Party(){const _0x480673=_0x259311;this[_0x480673(0x298)](...arguments);}Scene_Party[_0x259311(0x292)]=Object['create'](Scene_MenuBase[_0x259311(0x292)]),Scene_Party[_0x259311(0x292)]['constructor']=Scene_Party,Scene_Party[_0x259311(0x292)][_0x259311(0x298)]=function(){const _0x4a35ff=_0x259311;this[_0x4a35ff(0x1c0)](),Scene_MenuBase[_0x4a35ff(0x292)][_0x4a35ff(0x298)][_0x4a35ff(0x38a)](this);},Scene_Party[_0x259311(0x292)][_0x259311(0x303)]=function(){const _0x56d489=_0x259311;if(ConfigManager['uiMenuStyle']&&ConfigManager['uiInputPosition']!==undefined){if(_0x56d489(0x205)!==_0x56d489(0x205)){const _0x168e52=this[_0x56d489(0x1ad)]();this[_0x56d489(0x1e9)]=new _0x2e588f(_0x168e52),this[_0x56d489(0x3a4)](this[_0x56d489(0x1e9)]),this[_0x56d489(0x1e9)][_0x56d489(0x2e6)]('ok',this[_0x56d489(0x390)]['bind'](this)),this['_partyMemberSwitchWindow'][_0x56d489(0x2e6)]('cancel',this[_0x56d489(0x372)][_0x56d489(0x1c1)](this));}else return ConfigManager[_0x56d489(0x392)];}else return ConfigManager[_0x56d489(0x2ac)]===![]?![]:Scene_MenuBase[_0x56d489(0x292)][_0x56d489(0x303)][_0x56d489(0x38a)](this);},Scene_Party[_0x259311(0x292)][_0x259311(0x1fd)]=function(){return 0x0;},Scene_Party[_0x259311(0x292)]['needsPageButtons']=function(){return!![];},Scene_Party[_0x259311(0x292)][_0x259311(0x37b)]=function(){const _0x2cc9fb=_0x259311;Scene_MenuBase[_0x2cc9fb(0x292)]['createPageButtons']['call'](this),this['_pageupButton'][_0x2cc9fb(0x38e)]=undefined,this['_pagedownButton']['_clickHandler']=undefined;},Scene_Party[_0x259311(0x292)][_0x259311(0x1c0)]=function(){const _0x4f8825=_0x259311;for(const _0x1d0aba of $gameParty[_0x4f8825(0x2cc)]()){ImageManager[_0x4f8825(0x350)](_0x1d0aba[_0x4f8825(0x1ff)]()),ImageManager['loadCharacter'](_0x1d0aba[_0x4f8825(0x23a)]()),ImageManager[_0x4f8825(0x18e)](_0x1d0aba[_0x4f8825(0x1de)]());}},Scene_Party[_0x259311(0x292)]['create']=function(){const _0x34ffa4=_0x259311;Scene_MenuBase['prototype'][_0x34ffa4(0x241)][_0x34ffa4(0x38a)](this),this[_0x34ffa4(0x229)](),this[_0x34ffa4(0x3c2)](),this['createReservePartyLabel'](),this[_0x34ffa4(0x1cd)](),this['createStatusLabel'](),this[_0x34ffa4(0x322)]();},Scene_Party[_0x259311(0x292)][_0x259311(0x229)]=function(){const _0x2d77ab=_0x259311,_0x4a420e=this[_0x2d77ab(0x373)]();this['_activePartyLabel']=new Window_PartyLabel(_0x4a420e,TextManager['activeParty']),this[_0x2d77ab(0x29e)][_0x2d77ab(0x311)](VisuMZ[_0x2d77ab(0x26b)][_0x2d77ab(0x195)][_0x2d77ab(0x3b4)][_0x2d77ab(0x28b)]),this[_0x2d77ab(0x3a4)](this[_0x2d77ab(0x29e)]);},Scene_Party['prototype'][_0x259311(0x373)]=function(){const _0x11c098=_0x259311;return VisuMZ[_0x11c098(0x26b)][_0x11c098(0x195)]['Window'][_0x11c098(0x2ca)]['call'](this);},Scene_Party['prototype'][_0x259311(0x3c2)]=function(){const _0x26e401=_0x259311,_0xa83dc6=this[_0x26e401(0x22e)]();this[_0x26e401(0x342)]=new Window_PartyActive(_0xa83dc6),this[_0x26e401(0x342)]['setBackgroundType'](VisuMZ[_0x26e401(0x26b)][_0x26e401(0x195)][_0x26e401(0x3b4)][_0x26e401(0x31d)]),this['_activePartyWindow'][_0x26e401(0x2e6)]('ok',this[_0x26e401(0x31a)][_0x26e401(0x1c1)](this)),this['_activePartyWindow']['setHandler']('cancel',this[_0x26e401(0x33a)]['bind'](this)),this[_0x26e401(0x3a4)](this[_0x26e401(0x342)]);},Scene_Party[_0x259311(0x292)][_0x259311(0x22e)]=function(){const _0x191779=_0x259311;return VisuMZ[_0x191779(0x26b)][_0x191779(0x195)][_0x191779(0x3b4)][_0x191779(0x193)][_0x191779(0x38a)](this);},Scene_Party[_0x259311(0x292)][_0x259311(0x31a)]=function(){const _0xe340f0=_0x259311;this[_0xe340f0(0x378)][_0xe340f0(0x211)](),this[_0xe340f0(0x378)][_0xe340f0(0x289)]();},Scene_Party[_0x259311(0x292)][_0x259311(0x2d6)]=function(){const _0x146a55=_0x259311,_0x455bf6=this[_0x146a55(0x26d)]();this[_0x146a55(0x32e)]=new Window_PartyLabel(_0x455bf6,TextManager[_0x146a55(0x253)]),this['_reservePartyLabel']['setBackgroundType'](VisuMZ[_0x146a55(0x26b)][_0x146a55(0x195)][_0x146a55(0x3b4)][_0x146a55(0x312)]),this[_0x146a55(0x3a4)](this['_reservePartyLabel']);},Scene_Party['prototype'][_0x259311(0x26d)]=function(){const _0x4e25ec=_0x259311;return VisuMZ[_0x4e25ec(0x26b)]['Settings'][_0x4e25ec(0x3b4)][_0x4e25ec(0x396)][_0x4e25ec(0x38a)](this);},Scene_Party[_0x259311(0x292)][_0x259311(0x1cd)]=function(){const _0x14c851=_0x259311,_0x5972ad=this[_0x14c851(0x374)]();this['_reservePartyWindow']=new Window_PartyReserve(_0x5972ad),this[_0x14c851(0x378)][_0x14c851(0x311)](VisuMZ[_0x14c851(0x26b)][_0x14c851(0x195)][_0x14c851(0x3b4)][_0x14c851(0x2f3)]),this[_0x14c851(0x378)][_0x14c851(0x2e6)]('ok',this['onReserveOk'][_0x14c851(0x1c1)](this)),this[_0x14c851(0x378)][_0x14c851(0x2e6)](_0x14c851(0x35b),this[_0x14c851(0x362)]['bind'](this)),this[_0x14c851(0x3a4)](this[_0x14c851(0x378)]);},Scene_Party[_0x259311(0x292)][_0x259311(0x374)]=function(){const _0x442e7b=_0x259311;return VisuMZ[_0x442e7b(0x26b)][_0x442e7b(0x195)]['Window'][_0x442e7b(0x1bf)][_0x442e7b(0x38a)](this);},Scene_Party[_0x259311(0x292)][_0x259311(0x31b)]=function(){const _0x1d82f0=_0x259311,_0x3a2a3d=this['_reservePartyWindow'][_0x1d82f0(0x1f8)](),_0x5aa89f=this[_0x1d82f0(0x342)]['currentActor']();if(_0x3a2a3d<0x0){if(_0x1d82f0(0x360)!==_0x1d82f0(0x360))return this[_0x1d82f0(0x224)](this['currentActor']());else{if(_0x5aa89f)$gameParty[_0x1d82f0(0x29d)](_0x5aa89f[_0x1d82f0(0x19e)]());}}else{if(_0x1d82f0(0x3bd)==='ZFEpq'){if(this['_partyRequired']===_0x86de3)this['initPartySystem']();return this['_partyRequired'];}else{const _0x4d65ea=this['_reservePartyWindow'][_0x1d82f0(0x1d6)]()['actorId'](),_0x289040=this[_0x1d82f0(0x342)][_0x1d82f0(0x329)]();if(_0x5aa89f)$gameParty[_0x1d82f0(0x29d)](_0x5aa89f[_0x1d82f0(0x19e)]());$gameParty[_0x1d82f0(0x3a3)](_0x4d65ea,_0x289040);}}this[_0x1d82f0(0x20a)](),this[_0x1d82f0(0x362)]();},Scene_Party['prototype'][_0x259311(0x20a)]=function(){const _0x27fbed=_0x259311;this[_0x27fbed(0x342)][_0x27fbed(0x36d)](),this[_0x27fbed(0x378)][_0x27fbed(0x36d)]();},Scene_Party[_0x259311(0x292)][_0x259311(0x362)]=function(){const _0x4e4ace=_0x259311;this['_reservePartyWindow'][_0x4e4ace(0x307)](),this['_reservePartyWindow'][_0x4e4ace(0x1cf)](),this[_0x4e4ace(0x342)]['activate']();},Scene_Party[_0x259311(0x292)][_0x259311(0x346)]=function(){const _0x1a2aee=_0x259311,_0x285bb5=this['statusLabelRect']();this[_0x1a2aee(0x24d)]=new Window_PartyLabel(_0x285bb5,TextManager[_0x1a2aee(0x27b)]),this[_0x1a2aee(0x24d)][_0x1a2aee(0x311)](VisuMZ[_0x1a2aee(0x26b)][_0x1a2aee(0x195)][_0x1a2aee(0x3b4)]['StatusLabelBgType']),this[_0x1a2aee(0x3a4)](this['_statusPartyLabel']);},Scene_Party[_0x259311(0x292)][_0x259311(0x2a0)]=function(){const _0x27f8d6=_0x259311;return VisuMZ['PartySystem'][_0x27f8d6(0x195)][_0x27f8d6(0x3b4)][_0x27f8d6(0x26e)][_0x27f8d6(0x38a)](this);},Scene_Party[_0x259311(0x292)][_0x259311(0x322)]=function(){const _0xbbfa0c=_0x259311,_0x3f4bf2=this[_0xbbfa0c(0x21f)]();this[_0xbbfa0c(0x293)]=new Window_PartyStatus(_0x3f4bf2),this[_0xbbfa0c(0x293)]['setBackgroundType'](VisuMZ[_0xbbfa0c(0x26b)]['Settings'][_0xbbfa0c(0x3b4)][_0xbbfa0c(0x192)]),this['addWindow'](this[_0xbbfa0c(0x293)]),this['_reservePartyWindow'][_0xbbfa0c(0x3a5)](this['_statusPartyWindow']),this[_0xbbfa0c(0x342)][_0xbbfa0c(0x3a5)](this[_0xbbfa0c(0x293)]);},Scene_Party['prototype']['statusWindowRect']=function(){const _0x2b37b8=_0x259311;return VisuMZ['PartySystem'][_0x2b37b8(0x195)][_0x2b37b8(0x3b4)]['StatusWindowRect'][_0x2b37b8(0x38a)](this);},Scene_Party['prototype'][_0x259311(0x340)]=function(){const _0x41b995=_0x259311;return TextManager[_0x41b995(0x2ae)](_0x41b995(0x1d8));},Scene_Party[_0x259311(0x292)][_0x259311(0x317)]=function(){return TextManager['assistSwapPositions'];},Scene_Party[_0x259311(0x292)][_0x259311(0x2ba)]=function(){const _0x35d032=_0x259311,_0x404b27=this[_0x35d032(0x342)],_0x33300e=this[_0x35d032(0x378)];if(_0x404b27&&_0x404b27[_0x35d032(0x27d)]&&_0x404b27[_0x35d032(0x1d6)]()&&_0x404b27[_0x35d032(0x28a)]())return TextManager[_0x35d032(0x1d0)];else return _0x33300e&&_0x33300e[_0x35d032(0x27d)]&&$gameParty['reserveMembers']()['length']>0x0?TextManager[_0x35d032(0x203)]:'';},Scene_Party[_0x259311(0x292)]['buttonAssistText4']=function(){const _0x19adf3=_0x259311;if(this[_0x19adf3(0x342)]&&this[_0x19adf3(0x342)][_0x19adf3(0x27d)])return _0x19adf3(0x200)!==_0x19adf3(0x351)?TextManager['assistSwapOutPartyMember']:_0x3af16c[_0x19adf3(0x216)]();else{if(this[_0x19adf3(0x378)]&&this[_0x19adf3(0x378)][_0x19adf3(0x27d)]){if(_0x19adf3(0x2b2)===_0x19adf3(0x2b2))return TextManager[_0x19adf3(0x197)];else{const _0x242dc7=this['actor'](this[_0x19adf3(0x329)]());return _0x242dc7?_0x242dc7['isFormationChangeOk']():!![];}}else{if(_0x19adf3(0x2ef)===_0x19adf3(0x2a5)){const _0x585467=this[_0x19adf3(0x329)](),_0x54b789=_0x585467-0x1<0x0?this['maxItems']()-0x1:_0x585467-0x1;this['quickSwap'](_0x585467,_0x54b789);}else return Scene_MenuBase[_0x19adf3(0x292)][_0x19adf3(0x337)][_0x19adf3(0x38a)](this);}}},Scene_Party[_0x259311(0x292)][_0x259311(0x34d)]=function(){const _0x5f3d78=_0x259311;Scene_MenuBase['prototype']['createBackground'][_0x5f3d78(0x38a)](this),this['setBackgroundOpacity'](this['getBackgroundOpacity']()),this[_0x5f3d78(0x3b5)]();},Scene_Party[_0x259311(0x292)][_0x259311(0x39e)]=function(){const _0x192752=_0x259311;return VisuMZ[_0x192752(0x26b)][_0x192752(0x195)][_0x192752(0x2ff)]['SnapshotOpacity'];},Scene_Party[_0x259311(0x292)][_0x259311(0x3b5)]=function(){const _0xa30a73=_0x259311,_0x58e4c9={'BgFilename1':VisuMZ[_0xa30a73(0x26b)]['Settings'][_0xa30a73(0x2ff)][_0xa30a73(0x3be)],'BgFilename2':VisuMZ[_0xa30a73(0x26b)]['Settings'][_0xa30a73(0x2ff)]['BgFilename2']};if(_0x58e4c9&&(_0x58e4c9[_0xa30a73(0x3be)]!==''||_0x58e4c9['BgFilename2']!=='')){if(_0xa30a73(0x38d)!=='bGhwa')return'';else this['_backSprite1']=new Sprite(ImageManager['loadTitle1'](_0x58e4c9['BgFilename1'])),this['_backSprite2']=new Sprite(ImageManager[_0xa30a73(0x1ac)](_0x58e4c9[_0xa30a73(0x3bc)])),this['addChild'](this[_0xa30a73(0x1c6)]),this[_0xa30a73(0x2f7)](this[_0xa30a73(0x2ce)]),this[_0xa30a73(0x1c6)][_0xa30a73(0x316)][_0xa30a73(0x27a)](this[_0xa30a73(0x202)][_0xa30a73(0x1c1)](this,this[_0xa30a73(0x1c6)])),this[_0xa30a73(0x2ce)][_0xa30a73(0x316)][_0xa30a73(0x27a)](this['adjustSprite']['bind'](this,this[_0xa30a73(0x2ce)]));}},Scene_Party[_0x259311(0x292)]['adjustSprite']=function(_0x4d849c){const _0x5a4520=_0x259311;this[_0x5a4520(0x2e5)](_0x4d849c),this[_0x5a4520(0x35a)](_0x4d849c);},Scene_Party['prototype'][_0x259311(0x345)]=function(){const _0x30975e=_0x259311;Scene_MenuBase[_0x30975e(0x292)][_0x30975e(0x345)]['call'](this),$gameParty[_0x30975e(0x2c4)]();},Window_StatusBase[_0x259311(0x292)][_0x259311(0x2f6)]=function(_0x459cde,_0x366856,_0x10e89e,_0x834aa3){const _0x57fd84=_0x259311;if(!_0x459cde)return;_0x834aa3?this['drawActorPartyIconsVert'](_0x459cde,_0x366856,_0x10e89e):this[_0x57fd84(0x19d)](_0x459cde,_0x366856,_0x10e89e);},Window_StatusBase[_0x259311(0x292)]['drawActorPartyIconsHorz']=function(_0x2107f2,_0x16df98,_0x4cdbd8){const _0x485291=_0x259311;_0x4cdbd8+=Math[_0x485291(0x38f)]((this[_0x485291(0x1a6)]()-ImageManager['iconHeight'])/0x2);!_0x2107f2[_0x485291(0x1fc)]()&&(_0x485291(0x1f5)!==_0x485291(0x1f5)?_0x357125[_0x485291(0x210)]()[_0x485291(0x1b1)]():(this[_0x485291(0x336)](ImageManager['lockPartyMemberIcon'],_0x16df98,_0x4cdbd8),_0x16df98+=ImageManager[_0x485291(0x301)]+0x4));if(_0x2107f2['isRequiredInParty']()){if('uKDNi'!==_0x485291(0x325))this[_0x485291(0x336)](ImageManager[_0x485291(0x25c)],_0x16df98,_0x4cdbd8),_0x16df98+=ImageManager[_0x485291(0x301)]+0x4;else return _0x133cac[_0x485291(0x1d0)];}},Window_StatusBase[_0x259311(0x292)][_0x259311(0x2d0)]=function(_0x4e3965,_0x4367a7,_0x56c5fe){const _0x144ce0=_0x259311;let _0x4609fb=0x0;if(!_0x4e3965['isFormationChangeOk']())_0x4609fb+=0x1;if(_0x4e3965[_0x144ce0(0x344)]())_0x4609fb+=0x1;if(_0x4609fb<=0x1)return this[_0x144ce0(0x19d)](_0x4e3965,_0x4367a7,_0x56c5fe);_0x56c5fe+=Math[_0x144ce0(0x38f)]((this[_0x144ce0(0x1a6)]()-ImageManager['iconHeight'])/0x2),_0x56c5fe-=Math['round'](this[_0x144ce0(0x1a6)]()/0x2),this['drawIcon'](ImageManager[_0x144ce0(0x1f2)],_0x4367a7,_0x56c5fe),_0x56c5fe+=this[_0x144ce0(0x1a6)](),this[_0x144ce0(0x336)](ImageManager[_0x144ce0(0x25c)],_0x4367a7,_0x56c5fe);};function _0x245e(_0x372b70,_0x2b8539){const _0x2536ca=_0x2536();return _0x245e=function(_0x245e89,_0x1dafd2){_0x245e89=_0x245e89-0x186;let _0x10c062=_0x2536ca[_0x245e89];return _0x10c062;},_0x245e(_0x372b70,_0x2b8539);}function Window_PartyLabel(){const _0x3645a8=_0x259311;this[_0x3645a8(0x298)](...arguments);}Window_PartyLabel['prototype']=Object['create'](Window_Base[_0x259311(0x292)]),Window_PartyLabel[_0x259311(0x292)]['constructor']=Window_PartyLabel,Window_PartyLabel[_0x259311(0x292)][_0x259311(0x298)]=function(_0x51901f,_0x41b42f){const _0x14f57c=_0x259311;Window_Base['prototype'][_0x14f57c(0x298)][_0x14f57c(0x38a)](this,_0x51901f),this['setText'](_0x41b42f);},Window_PartyLabel[_0x259311(0x292)][_0x259311(0x32b)]=function(){const _0x437d5b=_0x259311;this[_0x437d5b(0x328)]=0x0;},Window_PartyLabel['prototype'][_0x259311(0x2f8)]=function(_0x1938af){const _0x27ea49=_0x259311;this[_0x27ea49(0x339)][_0x27ea49(0x29b)](),this['drawText'](_0x1938af,0x0,0x0,this[_0x27ea49(0x376)],_0x27ea49(0x3c9));};function Window_PartyActive(){const _0x588f83=_0x259311;this[_0x588f83(0x298)](...arguments);}Window_PartyActive['prototype']=Object[_0x259311(0x241)](Window_StatusBase[_0x259311(0x292)]),Window_PartyActive['prototype'][_0x259311(0x28c)]=Window_PartyActive,Window_PartyActive[_0x259311(0x319)]=VisuMZ['PartySystem'][_0x259311(0x195)][_0x259311(0x3b4)]['ActivePartyGraphic'],Window_PartyActive[_0x259311(0x292)][_0x259311(0x298)]=function(_0xe7655b){const _0x183711=_0x259311;Window_StatusBase['prototype'][_0x183711(0x298)]['call'](this,_0xe7655b),this[_0x183711(0x36d)](),this[_0x183711(0x211)](),this[_0x183711(0x256)](0x0);},Window_PartyActive['prototype'][_0x259311(0x2af)]=function(){const _0x793915=_0x259311;return VisuMZ['PartySystem'][_0x793915(0x195)]['General']['AddRemoveCmd'];},Window_PartyActive['prototype'][_0x259311(0x305)]=function(){const _0x44e3ab=_0x259311;return $gameParty[_0x44e3ab(0x25b)]();},Window_PartyActive[_0x259311(0x292)][_0x259311(0x333)]=function(){const _0x30f4f0=_0x259311;return $gameParty[_0x30f4f0(0x25b)]();},Window_PartyActive[_0x259311(0x292)]['itemHeight']=function(){const _0x160e9e=_0x259311;return this[_0x160e9e(0x34e)];},Window_PartyActive['prototype'][_0x259311(0x3ca)]=function(_0x143b49){return $gameParty['rawBattleMembers']()[_0x143b49];},Window_PartyActive[_0x259311(0x292)][_0x259311(0x1d6)]=function(){const _0x37c60e=_0x259311;return this[_0x37c60e(0x3ca)](this['index']());},Window_PartyActive['prototype'][_0x259311(0x2a4)]=function(){const _0x4f7a46=_0x259311,_0xa30803=this[_0x4f7a46(0x3ca)](this['index']());return _0xa30803?_0xa30803[_0x4f7a46(0x1fc)]():!![];},Window_PartyActive[_0x259311(0x292)][_0x259311(0x2a2)]=function(){const _0x389082=_0x259311;if($gameParty[_0x389082(0x2cc)]()['length']<=0x0)return!![];if($gameParty['anyRequiredPartyMembersInReserve']())return![];return $gameParty['battleMembers']()[_0x389082(0x323)]>0x0;},Window_PartyActive[_0x259311(0x292)][_0x259311(0x288)]=function(){const _0x132466=_0x259311;Window_StatusBase[_0x132466(0x292)][_0x132466(0x288)][_0x132466(0x38a)](this),this['checkShiftRemoveShortcut']();},Window_PartyActive[_0x259311(0x292)][_0x259311(0x3c0)]=function(_0x1065ac){const _0x1d934c=_0x259311;this[_0x1d934c(0x1bc)]()&&this[_0x1d934c(0x2b7)]();},Window_PartyActive[_0x259311(0x292)]['cursorPagedown']=function(){const _0x566477=_0x259311,_0x4d8814=this['index'](),_0x1ec936=_0x4d8814+0x1>=this['maxItems']()?0x0:_0x4d8814+0x1;this[_0x566477(0x1fb)](_0x4d8814,_0x1ec936);},Window_PartyActive['prototype'][_0x259311(0x225)]=function(){const _0x57e2ba=_0x259311,_0x5368a1=this['index'](),_0xf2fddf=_0x5368a1-0x1<0x0?this[_0x57e2ba(0x305)]()-0x1:_0x5368a1-0x1;this['quickSwap'](_0x5368a1,_0xf2fddf);},Window_PartyActive['prototype'][_0x259311(0x1fb)]=function(_0x3d8cec,_0xb2456d){const _0xbcbaea=_0x259311,_0x410114=this[_0xbcbaea(0x3ca)](_0x3d8cec),_0x21ec6f=this[_0xbcbaea(0x3ca)](_0xb2456d);if(_0x410114&&!_0x410114[_0xbcbaea(0x1fc)]())return;if(_0x21ec6f&&!_0x21ec6f[_0xbcbaea(0x1fc)]())return;const _0x5ec772=$gameParty[_0xbcbaea(0x1f6)];_0x5ec772[_0x3d8cec]=_0x21ec6f?_0x21ec6f[_0xbcbaea(0x19e)]():0x0,_0x5ec772[_0xb2456d]=_0x410114?_0x410114[_0xbcbaea(0x19e)]():0x0,this[_0xbcbaea(0x36d)](),this['playCursorSound'](),this[_0xbcbaea(0x256)](_0xb2456d);},Window_PartyActive['prototype'][_0x259311(0x399)]=function(){const _0x171c28=_0x259311;if(!this[_0x171c28(0x28a)]())return;if(Input[_0x171c28(0x255)](_0x171c28(0x1d8))){if('cnYMW'===_0x171c28(0x37c))while(this['findSymbol'](_0x171c28(0x283))>=0x0){const _0x1fc6f0=this[_0x171c28(0x1a3)]('formation');this[_0x171c28(0x29a)]['splice'](_0x1fc6f0,0x1);}else{const _0x4963a0=this['currentActor']();this[_0x171c28(0x32c)]();}}},Window_PartyActive[_0x259311(0x292)]['processShiftRemoveShortcut']=function(){const _0x3f3de9=_0x259311;SoundManager['playEquip']();const _0x22344a=this[_0x3f3de9(0x1d6)]();$gameParty[_0x3f3de9(0x29d)](_0x22344a[_0x3f3de9(0x19e)]()),this[_0x3f3de9(0x260)](),SceneManager[_0x3f3de9(0x39d)][_0x3f3de9(0x20a)]();},Window_PartyActive[_0x259311(0x292)][_0x259311(0x28a)]=function(){const _0x84a06c=_0x259311;if(!this[_0x84a06c(0x2af)]())return![];const _0x1850ea=this['currentActor']();return this[_0x84a06c(0x27d)]&&_0x1850ea&&_0x1850ea[_0x84a06c(0x1fc)]();},Window_PartyActive[_0x259311(0x292)][_0x259311(0x272)]=function(_0x4bf185){const _0x46a324=_0x259311,_0x281592=this[_0x46a324(0x3ca)](_0x4bf185);if(!_0x281592)return this['drawItemEmpty'](_0x4bf185);this[_0x46a324(0x2ee)]();const _0x1a4917=this['itemRect'](_0x4bf185);this[_0x46a324(0x2e1)](_0x4bf185);const _0x15b668=_0x1a4917['y']+_0x1a4917[_0x46a324(0x3b0)]-this[_0x46a324(0x1a6)]();this[_0x46a324(0x1b2)](_0x1a4917['x'],_0x15b668,_0x1a4917[_0x46a324(0x1e2)],0x2),this[_0x46a324(0x2f6)](_0x281592,_0x1a4917['x']+0x2,_0x1a4917['y']),this[_0x46a324(0x35d)](_0x281592,_0x1a4917['x'],_0x15b668,_0x1a4917[_0x46a324(0x1e2)]);},Window_PartyActive[_0x259311(0x292)][_0x259311(0x219)]=function(_0x2c21ff){const _0x560cdb=_0x259311;this[_0x560cdb(0x2ee)]();const _0x48cec7=this['itemRect'](_0x2c21ff);this[_0x560cdb(0x1d7)](_0x48cec7['x'],_0x48cec7['y'],_0x48cec7[_0x560cdb(0x1e2)],_0x48cec7[_0x560cdb(0x3b0)]);const _0x1bb559=_0x48cec7['y']+Math[_0x560cdb(0x38f)]((_0x48cec7[_0x560cdb(0x3b0)]-this[_0x560cdb(0x1a6)]())/0x2);this[_0x560cdb(0x33b)](ColorManager[_0x560cdb(0x266)]()),this[_0x560cdb(0x198)](TextManager[_0x560cdb(0x3b6)],_0x48cec7['x'],_0x1bb559,_0x48cec7[_0x560cdb(0x1e2)],_0x560cdb(0x3c9));},Window_PartyActive[_0x259311(0x292)][_0x259311(0x1d7)]=function(_0x55f918,_0x18ef9d,_0x427778,_0x150589,_0x1ac19f){const _0x47cdca=_0x259311;_0x1ac19f=Math[_0x47cdca(0x310)](_0x1ac19f||0x1,0x1);while(_0x1ac19f--){_0x150589=_0x150589||this['lineHeight'](),this[_0x47cdca(0x339)]['paintOpacity']=0xa0;const _0x1866cb=ColorManager[_0x47cdca(0x295)]();this[_0x47cdca(0x339)][_0x47cdca(0x231)](_0x55f918+0x1,_0x18ef9d+0x1,_0x427778-0x2,_0x150589-0x2,_0x1866cb),this['contents'][_0x47cdca(0x1a7)]=0xff;}},Window_PartyActive[_0x259311(0x292)][_0x259311(0x2e1)]=function(_0x147b16){const _0x50bdc4=_0x259311;switch(Window_PartyActive[_0x50bdc4(0x319)][_0x50bdc4(0x1af)]()[_0x50bdc4(0x269)]()){case'face':this[_0x50bdc4(0x1e4)](_0x147b16);break;case _0x50bdc4(0x30e):this[_0x50bdc4(0x3b7)](_0x147b16);break;case _0x50bdc4(0x1db):Imported[_0x50bdc4(0x188)]&&this['drawItemImageSvActor'](_0x147b16);break;};},Window_PartyActive['prototype'][_0x259311(0x1e4)]=function(_0x92b9c9){const _0x37dd0e=_0x259311,_0x22872a=this[_0x37dd0e(0x3ca)](_0x92b9c9),_0x11384b=this['itemRect'](_0x92b9c9),_0x33b8e5=Math[_0x37dd0e(0x1f3)](ImageManager['faceWidth'],_0x11384b[_0x37dd0e(0x1e2)]-0x2),_0x38476c=_0x11384b[_0x37dd0e(0x3b0)]-0x2;this[_0x37dd0e(0x2c5)](_0x22872a[_0x37dd0e(0x1fc)]());const _0x208e90=Math['round'](_0x11384b['x']+(_0x11384b[_0x37dd0e(0x1e2)]-_0x33b8e5)/0x2);this[_0x37dd0e(0x3a8)](_0x22872a,_0x208e90,_0x11384b['y']+0x1,_0x33b8e5,_0x38476c),this[_0x37dd0e(0x2c5)](!![]);},Window_PartyActive[_0x259311(0x292)][_0x259311(0x3b7)]=function(_0x1eed7a){const _0x255eb0=_0x259311,_0x263078=this[_0x255eb0(0x3ca)](_0x1eed7a),_0x34c84a=this['itemRect'](_0x1eed7a),_0x17c5d3=VisuMZ[_0x255eb0(0x26b)][_0x255eb0(0x195)][_0x255eb0(0x3b4)],_0x349e61=_0x34c84a['x']+Math[_0x255eb0(0x38f)](_0x34c84a[_0x255eb0(0x1e2)]/0x2)+_0x17c5d3[_0x255eb0(0x27f)],_0x592065=_0x34c84a['y']+_0x34c84a['height']-this['lineHeight']()-_0x17c5d3['ActiveSpriteOffsetY'];this[_0x255eb0(0x2d8)](_0x263078,_0x349e61,_0x592065);},Window_PartyActive[_0x259311(0x292)][_0x259311(0x1d5)]=function(_0x462e5f){const _0x3694c3=_0x259311,_0x2bb5ea=this[_0x3694c3(0x3ca)](_0x462e5f),_0x5284f3=_0x2bb5ea[_0x3694c3(0x1de)](),_0x18a001=this[_0x3694c3(0x3c1)](_0x462e5f),_0x4da2ab=VisuMZ['PartySystem'][_0x3694c3(0x195)][_0x3694c3(0x3b4)],_0x1945db=_0x18a001['x']+Math[_0x3694c3(0x38f)](_0x18a001[_0x3694c3(0x1e2)]/0x2)+_0x4da2ab[_0x3694c3(0x187)],_0x53529e=_0x18a001['y']+_0x18a001[_0x3694c3(0x3b0)]-this[_0x3694c3(0x1a6)]()-_0x4da2ab[_0x3694c3(0x1e1)];this[_0x3694c3(0x368)](_0x5284f3,_0x1945db,_0x53529e);},Window_PartyActive[_0x259311(0x292)]['drawDarkRect']=function(_0x249826,_0x41294d,_0x4ebd58,_0x197d13){const _0x37c9a=_0x259311,_0x14e68b=ColorManager[_0x37c9a(0x258)](),_0x36a4b1=ColorManager[_0x37c9a(0x2ab)](),_0x4c4743=_0x4ebd58/0x2,_0x146c99=this[_0x37c9a(0x1a6)]();while(_0x197d13--){_0x37c9a(0x331)==='Eklni'?this['_battleMaxSize']=0x0:(this[_0x37c9a(0x339)][_0x37c9a(0x217)](_0x249826,_0x41294d,_0x4c4743,_0x146c99,_0x36a4b1,_0x14e68b),this[_0x37c9a(0x339)][_0x37c9a(0x217)](_0x249826+_0x4c4743,_0x41294d,_0x4c4743,_0x146c99,_0x14e68b,_0x36a4b1));}},Window_PartyActive['prototype'][_0x259311(0x35d)]=function(_0x3909b4,_0x3a2a0e,_0x59b0c9,_0x4a6790){const _0x4c4d20=_0x259311;_0x4a6790=_0x4a6790||0xa8,this[_0x4c4d20(0x33b)](ColorManager['hpColor'](_0x3909b4)),this[_0x4c4d20(0x198)](_0x3909b4[_0x4c4d20(0x208)](),_0x3a2a0e,_0x59b0c9,_0x4a6790,_0x4c4d20(0x3c9));},Window_PartyActive['prototype'][_0x259311(0x3a5)]=function(_0x3b0272){const _0x52438c=_0x259311;this[_0x52438c(0x20e)]=_0x3b0272,this[_0x52438c(0x260)]();},Window_PartyActive['prototype'][_0x259311(0x260)]=function(){const _0x1b2eb2=_0x259311;if(this['_statusWindow'])this['_statusWindow'][_0x1b2eb2(0x34c)](this[_0x1b2eb2(0x3ca)](this[_0x1b2eb2(0x329)]()));};function Window_PartyReserve(){const _0xf78e2=_0x259311;this[_0xf78e2(0x298)](...arguments);}function _0x2536(){const _0x40c3ae=['loadFace','JOcco','text','clearDamagePopup','isShowPartySwitchOutAnimation','Bjafc','isOTB','isCTB','JSON','YoWHK','centerSprite','cancel','isAlive','drawActorName','initPartySystem','Actors','HmHLb','FNvAf','onReserveCancel','_actor','snapForBackground','fUCbq','isPreviousScene','assistSwapPositions','drawSvActor','startMove','Scene_Battle_isTimeActive','AssistRemove','isNextSceneBattleTransitionable','refresh','hyZAY','regenerateAll','General','108zuQRAB','onPartySwitchCancel','activePartyLabelRect','reservePartyWindowRect','select','innerWidth','VisuMZ_2_BattleSystemBTB','_reservePartyWindow','SXmBi','includes','createPageButtons','TPXiM','playOkSound','drawActorClass','allMembers','VisuMZ_0_CoreEngine','ReserveSpriteOffsetY','PartyCmdCooldown','rRWQa','updateTargetsForPartySwitch','ctFvv','isPTB','initMaxBattleMembers','atPLi','skillItemWindowRectBorderStyle','call','addActor','9606276QdqlqK','bGhwa','_clickHandler','round','onPartySwitchOk','MaxBattleMembers','uiInputPosition','VMNDs','updateTurnOrderSTB','ActorCmdWinAddParty','ReservePartyLabelRect','swapOrder','_partySystemBattleCommandCooldown','checkShiftRemoveShortcut','_windowLayer','ReserveSpriteOffsetX','battleLayoutStyle','_scene','getBackgroundOpacity','Game_Party_initialize','clearPartySwitchCommandCooldown','teamBasedFirstAvailableMember','7OLnQPT','addActorToBattleMembersAtIndex','addWindow','setStatusWindow','requestRefresh','startOpacity','drawActorFace','Empty','BattlePartyIcon','itemLineRect','_bypassAutoSavePartySystem','direction','addActorToBattleMembers','BattleSwitchOut','height','swapOrderPartySystemPlugin','Lock','DisplayedParams','Window','createCustomBackgroundImages','emptyPartyMember','drawItemImageSprite','SceneManager_isPreviousSceneBattleTransitionable','FGTxM','pfTWs','vVGHh','BgFilename2','lzoms','BgFilename1','RequireIcon','cursorDown','itemRect','createActivePartyWindow','RequirePartyMembers','_partyCommandWindow','MoveRandomToActive','isAutosaveEnabled','cbzEZ','Remove','center','actor','commandFormation','ActiveBattlerOffsetX','VisuMZ_1_MainMenuCore','vDhOm','itemRectWithPadding','ARRAYFUNC','ShyaF','MoveActorsToActive','loadSvActor','isSceneParty','%1\x27s\x20version\x20does\x20not\x20match\x20plugin\x27s.\x20Please\x20update\x20it\x20in\x20the\x20Plugin\x20Manager.','canSwitchPartyInBattle','StatusWindowBgType','ActivePartyWindowRect','initEquips','Settings','setBattler','assistSwapInPartyMember','drawText','equips','placeBasicGauges','isUsingGridSystem','border','drawActorPartyIconsHorz','actorId','SceneManager_isNextSceneBattleTransitionable','490ifPjuG','MovePartyIndexToReserve','paramValueByName','findSymbol','VisuMZ_2_BattleGridSystem','processPartySwitchMember','lineHeight','paintOpacity','makeActions','Param','904956VPtOpI','_callSceneParty','loadTitle2','partySwitchWindowRect','random','toLowerCase','Game_Party_removeActor','changeMaxBattleMembers','drawDarkRect','_spriteset','KiuhV','8kqgSNU','applyBattlePartySwitchCooldown','playCursorSound','battlePartyChangeIcon','QueuePartyScene','itemPadding','updateTurnOrderCTB','isOkEnabled','QFtxM','addFormationCommand','ReservePartyWindowRect','loadPartyImages','bind','pop','isFormationCommandEnabled','isActor','Game_Actor_setup','_backSprite1','Scene_Battle_updateBattleProcess','drawRemoveCommand','removePartyCommand','isPartyCommandEnabled','_actionBattlers','BackRectColor','createReservePartyWindow','xxlXT','deselect','assistRemovePartyMember','cursorUp','battlePartySwitchCmdHelp','yUPmp','partySwitchWindowRectStandard','drawItemImageSvActor','currentActor','drawItemDarkRect','shift','filter','_battleMaxSize','svbattler','Game_Unit_inBattle','visible','battlerName','param','onBattlePartySwitch','ActiveBattlerOffsetY','width','_partySwitchBattleCommandCooldown','drawItemImageFace','increaseTurn','getColor','Game_Party_setupBattleTest','setupBattleTestMembers','_partyMemberSwitchWindow','AssistSwapPosition','CvMrT','charged','level','reserveTransfer','EVAL','ReserveItemThickness','battlePartyChangeCmd','lockPartyMemberIcon','min','toUpperCase','bvHgk','_battleMembers','selectActor','pendingIndex','checkInitBattleMembers','Window_PartyCommand_updateHelp','quickSwap','isFormationChangeOk','helpAreaHeight','partySwitchWindowRectBorder','faceName','Fvhzx','OVMwm','adjustSprite','assistSortPartyMembers','rearrangePartyActors','pGljP','return\x200','format','name','commandPartyMemberSwitch','refreshAllWindows','setupBattleTest','ReserveCol','Game_Party_swapOrder','_statusWindow','_subject','followers','activate','_rowThickness','Game_Party_setupStartingMembers','Window_ActorCommand_updateHelp','gridMoveTo','isActiveTpb','gradientFillRect','ssXEw','drawItemEmpty','Scene_Base_isAutosaveEnabled','isAnyInputWindowActive','Game_Battler_onBattleStart','switchStateIconActor','GDNGV','statusWindowRect','VisuMZ_2_BattleSystemETB','NUM','Scene_Battle_createAllWindows','zliyl','isEnabled','cursorPageup','reserveMembers','VisuMZ_2_BattleSystemFTB','ReserveBattlerOffsetY','createActivePartyLabel','Scene_Battle_createActorCommandWindow','isFormationCommandAdded','oxBre','_helpWindow','activePartyWindowRect','Index','actorParams','fillRect','_partyRequired','setPartyRequirement','faceWidth','tpbImmediateAction','isShiftShortcutEnabled','getPartySystemBackColor','isImmediateTpb','isTimeActive','characterName','createPartyCommandWindowBattleCore','hasBattleSystemIncompatibilities','cvaGW','isSceneBattle','right','addText','create','clearTpbChargeTime','Game_Battler_regenerateAll','battler','textColor','playEquip','addNonBattleTestMembers','ARRAYJSON','Scene_Battle_createPartyCommandWindowBattleCore','activeParty','_target','setupStartingMembers','_statusPartyLabel','isPreviousSceneBattleTransitionable','battleMembers','clearBypassAutoSave','ARRAYEVAL','_actors','reserveParty','_inputting','isTriggered','smoothSelect','118939zwAZNu','dimColor1','OzVpA','isPartyCommandAdded','maxBattleMembers','requiredPartyMemberIcon','gVEOj','description','parameters','callUpdateHelp','updateBattleProcess','isTpb','AEqSv','isSTB','postPartySwitchMenuTurnBased','systemColor','WFPfW','isQueueFormationMenu','trim','MckdP','PartySystem','isUsingBattleGridTactics','reservePartyLabelRect','StatusLabelRect','stepForward','SnapshotOpacity','_logWindow','drawItem','WARNING:\x20Party\x20Change\x20command\x20is\x20unavailable\x20for\x20Window_PartyCommand\x20for\x20this\x20Battle\x20System','HoVEC','updateBattlePartySwitchCooldown','_currentActor','openness','makeActionOrders','isETB','addLoadListener','statusParty','callFormation','active','BattleSwitchWindowBgType','ActiveSpriteOffsetX','updateHelp','clearPartyBattleCommandCooldown','initBattleMembers','formation','map','ZYfJX','open','VisuMZ_2_BattleSystemPTB','processCursorMove','reselect','isShiftRemoveShortcutEnabled','ActivePartyLabelBgType','constructor','onBattleStart','BattleHelpFormation','ceil','_otb_actionBattlersNext','face','prototype','_statusPartyWindow','Value','gaugeBackColor','setBattlePartySwitchCooldown','isBTB','initialize','ARRAYNUM','_list','clear','#%1','removeActorFromBattleMembers','_activePartyLabel','2584096FpuGhD','statusLabelRect','changeLevel','isCancelEnabled','llEmY','isCurrentItemEnabled','tkAWQ','setup','BattleHelpSwitch','drawItemStatus','version','faceHeight','dimColor2','uiMenuStyle','cursorVisible','getInputButtonString','addRemoveCommand','battlePartySwitchCmd','removeActor','dbiSn','ReserveBattlerOffsetX','Game_Troop_increaseTurn','_targets','CallPartyScene','processOk','_battleSystemIncompatibilityError','registerCommand','buttonAssistText3','MoveActorsToReserve','_partySwitchTargetActor','getParamValue','update','clamp','defaultMaxBattleMembers','callPartyMemberSwitch','StatusWindowDraw','2102763kbduoD','partyChangeRefresh','changePaintOpacity','isNextScene','sortActors','WnBEv','DrawBackRect','ActivePartyLabelRect','Status','members','currentSymbol','_backSprite2','ConvertParams','drawActorPartyIconsVert','EYCtS','lVYbF','battlePartyChangeCmdHelp','nameStartPosition','KCXrw','createReservePartyLabel','ARRAYSTRUCT','drawActorCharacter','VisuMZ_2_BattleSystemOTB','inBattle','setPartyLock','indexOf','ActiveParty','splice','_partyLocked','isSceneMap','drawItemImage','processCancel','checkShiftSortShortcut','Scene_Battle_isAnyInputWindowActive','scaleSprite','setHandler','sortActionOrdersBTB','ChangeMaxBattleMembers','floor','1795UHHOrn','anyRequiredPartyMembersInReserve','addCommand','addPartyCommand','resetFontSettings','DxLLh','processShiftSortShortcut','commandStyle','SDvZC','ReservePartyWindowBgType','updatePartySwitch','_partySwitchDuration','drawActorPartyIcons','addChild','setText','createInnerSprite','startSwitchInAnimation','close','drawParamName','parse','tgFqf','BgSettings','battlePartySwitchCooldown','iconWidth','exit','isRightInputMode','FUNC','maxItems','replaceActionBattlersPartySwitch','deactivate','fYpNI','lRlbn','isFTB','removePartyMember','push','_debug','sprite','BattlePartyCmd','max','setBackgroundType','ReservePartyLabelBgType','_lastIndex','ActiveTpbFormationMessage','SqgZL','bitmap','buttonAssistText1','56287QELdVV','_actorGraphic','onActiveOk','onReserveOk','itemHeight','ActivePartyWindowBgType','ReservePartyGraphic','Sprite_Actor_update','ReserveParty','preparePartySwitchMember','createStatusWindow','length','_tpbChargeTime','yMfVT','Vocab','VisuMZ_2_BattleSystemSTB','padding','index','\x5cI[%1]%2','updatePadding','processShiftRemoveShortcut','_partySystemSwitchOut','_reservePartyLabel','startSwitchOutAnimation','_actorCommandWindow','OWHQX','%1\x20is\x20missing\x20a\x20required\x20plugin.\x0aPlease\x20install\x20%2\x20into\x20the\x20Plugin\x20Manager.','maxCols','Game_Party_addActor','rawBattleMembers','drawIcon','buttonAssistText4','_tpbSceneChangeCacheActor','contents','popScene','changeTextColor','remove','isAppeared','drawActorSimpleStatus','BattleManager_setup','buttonAssistKey3','actor%1-stateIcon','_activePartyWindow','_callPartyMemberSwitch','isRequiredInParty','terminate','createStatusLabel','%1\x20is\x20incorrectly\x20placed\x20on\x20the\x20plugin\x20list.\x0aIt\x20is\x20a\x20Tier\x20%2\x20plugin\x20placed\x20over\x20other\x20Tier\x20%3\x20plugins.\x0aPlease\x20reorder\x20the\x20plugin\x20list\x20from\x20smallest\x20to\x20largest\x20tier\x20numbers.','createActorCommandWindow','match','LockPartyMembers','isFormationEnabled','setActor','createBackground','innerHeight','createPartySwitchWindow'];_0x2536=function(){return _0x40c3ae;};return _0x2536();}Window_PartyReserve[_0x259311(0x292)]=Object['create'](Window_StatusBase[_0x259311(0x292)]),Window_PartyReserve[_0x259311(0x292)][_0x259311(0x28c)]=Window_PartyReserve,Window_PartyReserve[_0x259311(0x319)]=VisuMZ[_0x259311(0x26b)][_0x259311(0x195)][_0x259311(0x3b4)][_0x259311(0x31e)],Window_PartyReserve['_rowThickness']=VisuMZ[_0x259311(0x26b)][_0x259311(0x195)][_0x259311(0x3b4)][_0x259311(0x1f0)],Window_PartyReserve['prototype'][_0x259311(0x298)]=function(_0x37d478){const _0xd136ea=_0x259311;Window_StatusBase[_0xd136ea(0x292)]['initialize'][_0xd136ea(0x38a)](this,_0x37d478),this[_0xd136ea(0x313)]=0x0,this[_0xd136ea(0x36d)]();},Window_PartyReserve[_0x259311(0x292)][_0x259311(0x333)]=function(){const _0x19fd1c=_0x259311;return VisuMZ[_0x19fd1c(0x26b)][_0x19fd1c(0x195)]['Window'][_0x19fd1c(0x20c)]||0x1;},Window_PartyReserve[_0x259311(0x292)][_0x259311(0x31c)]=function(){const _0x222895=_0x259311;return this['lineHeight']()*Window_PartyReserve[_0x222895(0x212)]+0x6;},Window_PartyReserve[_0x259311(0x292)][_0x259311(0x2af)]=function(){const _0x4ce7c3=_0x259311;return VisuMZ[_0x4ce7c3(0x26b)][_0x4ce7c3(0x195)][_0x4ce7c3(0x370)]['AddRemoveCmd'];},Window_PartyReserve[_0x259311(0x292)][_0x259311(0x305)]=function(){const _0x309593=_0x259311;let _0x10f388=$gameParty[_0x309593(0x226)]()[_0x309593(0x323)];if(this[_0x309593(0x2af)]())_0x10f388++;return _0x10f388;},Window_PartyReserve['prototype'][_0x259311(0x3ca)]=function(_0x4a163c){const _0x31b5ad=_0x259311;return $gameParty[_0x31b5ad(0x226)]()[_0x4a163c];},Window_PartyReserve['prototype'][_0x259311(0x1d6)]=function(){const _0x5e8bb0=_0x259311;return this['actor'](this[_0x5e8bb0(0x329)]());},Window_PartyReserve[_0x259311(0x292)][_0x259311(0x37d)]=function(){const _0x623d6=_0x259311;SoundManager[_0x623d6(0x246)]();},Window_PartyReserve[_0x259311(0x292)][_0x259311(0x2a4)]=function(){const _0x1a1829=_0x259311,_0x977e54=this[_0x1a1829(0x3ca)](this[_0x1a1829(0x329)]());return _0x977e54?_0x977e54['isFormationChangeOk']():!![];},Window_PartyReserve[_0x259311(0x292)][_0x259311(0x288)]=function(){const _0x544339=_0x259311;Window_StatusBase['prototype']['processCursorMove'][_0x544339(0x38a)](this),this[_0x544339(0x2e3)]();},Window_PartyReserve[_0x259311(0x292)]['cursorUp']=function(_0xdbf137){const _0xcac088=_0x259311;this[_0xcac088(0x329)]()<=0x0&&Input[_0xcac088(0x255)]('up')?this[_0xcac088(0x2e2)]():Window_StatusBase[_0xcac088(0x292)][_0xcac088(0x1d1)]['call'](this,_0xdbf137);},Window_PartyReserve[_0x259311(0x292)]['cursorPagedown']=function(){const _0x24b8cc=_0x259311,_0x2d4b6c=this[_0x24b8cc(0x329)](),_0x128187=_0x2d4b6c+0x1>=this[_0x24b8cc(0x305)]()-0x1?0x0:_0x2d4b6c+0x1;this[_0x24b8cc(0x1fb)](_0x2d4b6c,_0x128187);},Window_PartyReserve[_0x259311(0x292)][_0x259311(0x225)]=function(){const _0x2b346d=_0x259311,_0x1a9f2d=this[_0x2b346d(0x329)](),_0x29e666=_0x1a9f2d-0x1<0x0?this[_0x2b346d(0x305)]()-0x2:_0x1a9f2d-0x1;this[_0x2b346d(0x1fb)](_0x1a9f2d,_0x29e666);},Window_PartyReserve['prototype'][_0x259311(0x1fb)]=function(_0x582b33,_0x1ee813){const _0x4a7ef0=_0x259311,_0x277e49=this[_0x4a7ef0(0x3ca)](_0x582b33),_0x38b4c9=this[_0x4a7ef0(0x3ca)](_0x1ee813);if(!_0x277e49?.[_0x4a7ef0(0x1fc)]()||!_0x38b4c9?.['isFormationChangeOk']()){if(_0x4a7ef0(0x25d)!==_0x4a7ef0(0x361))return;else{if(!_0x549c05[_0x4a7ef0(0x2e0)]())return;if(_0x46fa33[_0x4a7ef0(0x24f)]()[_0x4a7ef0(0x323)]>=_0x9d82f1[_0x4a7ef0(0x25b)]())return;if(_0x575659[_0x4a7ef0(0x226)]()['length']<=0x0)return;const _0x4aa95a=_0x45634c[_0x4a7ef0(0x226)](),_0x37c24f=_0x4aa95a[_0x50f65a[_0x4a7ef0(0x2e9)](_0x40e462[_0x4a7ef0(0x1ae)]()*_0x4aa95a[_0x4a7ef0(0x323)])],_0x15f792=_0x37c24f[_0x4a7ef0(0x19e)]();_0x3dd64e['addActorToBattleMembers'](_0x15f792),_0x4da13f['refresh']();}}else{if(!_0x277e49||!_0x38b4c9)return;}const _0x11866e=$gameParty[_0x4a7ef0(0x252)],_0x3f3cab=_0x11866e['indexOf'](_0x277e49[_0x4a7ef0(0x19e)]()),_0x40d957=_0x11866e[_0x4a7ef0(0x2dc)](_0x38b4c9['actorId']());_0x11866e[_0x3f3cab]=_0x38b4c9?_0x38b4c9['actorId']():0x0,_0x11866e[_0x40d957]=_0x277e49?_0x277e49[_0x4a7ef0(0x19e)]():0x0,this['refresh'](),this[_0x4a7ef0(0x1b7)](),this[_0x4a7ef0(0x256)](_0x1ee813);},Window_PartyReserve[_0x259311(0x292)][_0x259311(0x2e3)]=function(){const _0x18bab3=_0x259311;if(!this['isShiftShortcutEnabled']())return;Input['isTriggered'](_0x18bab3(0x1d8))&&this[_0x18bab3(0x2f0)]();},Window_PartyReserve['prototype']['processShiftSortShortcut']=function(){const _0x8868d7=_0x259311;SoundManager['playEquip'](),$gameParty['sortActors'](),this['smoothSelect'](0x0),SceneManager[_0x8868d7(0x39d)][_0x8868d7(0x20a)]();},Window_PartyReserve[_0x259311(0x292)][_0x259311(0x236)]=function(){const _0x46d90f=_0x259311;return this[_0x46d90f(0x27d)];},Window_PartyReserve[_0x259311(0x292)][_0x259311(0x1f8)]=function(){const _0x35b6c3=_0x259311,_0x1727ee=this['currentActor']();return _0x1727ee?_0x1727ee[_0x35b6c3(0x329)]():-0x1;},Window_PartyReserve[_0x259311(0x292)][_0x259311(0x375)]=function(_0xf1e058){const _0x80870b=_0x259311;Window_StatusBase['prototype'][_0x80870b(0x375)]['call'](this,_0xf1e058);if(_0xf1e058>=0x0)this[_0x80870b(0x313)]=_0xf1e058;},Window_PartyReserve[_0x259311(0x292)][_0x259311(0x289)]=function(){const _0x1c5e3d=_0x259311;this[_0x1c5e3d(0x313)]=Math[_0x1c5e3d(0x1f3)](this[_0x1c5e3d(0x313)],this[_0x1c5e3d(0x305)]()-0x1),this[_0x1c5e3d(0x256)](this[_0x1c5e3d(0x313)]),this['ensureCursorVisible'](!![]),this[_0x1c5e3d(0x2ad)]=!![];},Window_PartyReserve[_0x259311(0x292)][_0x259311(0x272)]=function(_0x548fa4){const _0x1239d5=_0x259311,_0x5c62df=this[_0x1239d5(0x3ca)](_0x548fa4);if(!_0x5c62df)return this['drawRemoveCommand'](_0x548fa4);const _0x39cbcb=this[_0x1239d5(0x3ab)](_0x548fa4);this['drawItemImage'](_0x548fa4);const _0x266944=0xa8,_0x34d290=Window_PartyReserve['_rowThickness']===0x1,_0xe7af12=ImageManager[_0x1239d5(0x301)]*(_0x34d290?0x2:0x1),_0x40114a=this[_0x1239d5(0x2d4)]()+this[_0x1239d5(0x1ba)](),_0x2425ee=_0x39cbcb[_0x1239d5(0x1e2)]-_0x266944,_0x57aa72=_0x39cbcb['x']+_0xe7af12+Math[_0x1239d5(0x1f3)](_0x40114a,_0x2425ee),_0x507b73=_0x34d290?![]:!![];this['changePaintOpacity'](_0x5c62df[_0x1239d5(0x1fc)]()),this[_0x1239d5(0x2f6)](_0x5c62df,_0x39cbcb['x'],_0x39cbcb['y'],_0x507b73),this[_0x1239d5(0x35d)](_0x5c62df,_0x57aa72,_0x39cbcb['y'],_0x266944),this[_0x1239d5(0x2c5)](!![]);},Window_PartyReserve[_0x259311(0x292)][_0x259311(0x2d4)]=function(){const _0x149601=_0x259311,_0x564aea=VisuMZ[_0x149601(0x26b)][_0x149601(0x195)]['Window'];switch(Window_PartyReserve[_0x149601(0x319)]['toLowerCase']()[_0x149601(0x269)]()){case'face':return ImageManager['faceWidth'];case _0x149601(0x30e):return _0x564aea['ReserveSpriteOffsetX']*0x2;case _0x149601(0x1db):return _0x564aea[_0x149601(0x2b3)]*0x2;};},Window_PartyReserve[_0x259311(0x292)][_0x259311(0x1c8)]=function(_0x33ad20){const _0x2d1ab0=_0x259311,_0x48b122=this[_0x2d1ab0(0x3ab)](_0x33ad20);this['changePaintOpacity'](!![]);const _0x4db58d=TextManager[_0x2d1ab0(0x30b)];this[_0x2d1ab0(0x198)](_0x4db58d,_0x48b122['x'],_0x48b122['y'],_0x48b122[_0x2d1ab0(0x1e2)],_0x2d1ab0(0x3c9));},Window_PartyReserve[_0x259311(0x292)][_0x259311(0x2e1)]=function(_0x4e9262){const _0x33ec17=_0x259311;switch(Window_PartyReserve[_0x33ec17(0x319)][_0x33ec17(0x1af)]()[_0x33ec17(0x269)]()){case _0x33ec17(0x291):this[_0x33ec17(0x1e4)](_0x4e9262);break;case _0x33ec17(0x30e):this['drawItemImageSprite'](_0x4e9262);break;case _0x33ec17(0x1db):if(Imported['VisuMZ_1_MainMenuCore']){if('SfqvI'!==_0x33ec17(0x2c8))this['drawItemImageSvActor'](_0x4e9262);else{const _0x187ffa=this[_0x33ec17(0x3ca)](_0x4fcf2d),_0x3d3930=this['itemRectWithPadding'](_0x46c815),_0x77c036=_0x3d3930['x']+_0x1436e4[_0x33ec17(0x234)]+0x24,_0x384899=_0x77c036+0xb4;this[_0x33ec17(0x2c5)](this[_0x33ec17(0x224)](_0x187ffa)),this[_0x33ec17(0x35d)](_0x187ffa,_0x77c036,_0x3d3930['y']),this[_0x33ec17(0x37e)](_0x187ffa,_0x77c036,_0x3d3930['y']+this[_0x33ec17(0x1a6)]()),this[_0x33ec17(0x19a)](_0x187ffa,_0x384899,_0x3d3930['y']),this['changePaintOpacity'](!![]);}}break;};},Window_PartyReserve[_0x259311(0x292)][_0x259311(0x1e4)]=function(_0x31d436){const _0x2bfc3e=_0x259311,_0x211277=this[_0x2bfc3e(0x3ca)](_0x31d436),_0x1e4d7b=this[_0x2bfc3e(0x3c1)](_0x31d436),_0x13e4c0=Window_PartyReserve[_0x2bfc3e(0x212)]===0x1;_0x1e4d7b['x']+=ImageManager['iconWidth']*(_0x13e4c0?0x2:0x1);const _0x4d296d=ImageManager[_0x2bfc3e(0x234)],_0x5df3f6=_0x1e4d7b[_0x2bfc3e(0x3b0)]-0x2;this['changePaintOpacity'](_0x211277[_0x2bfc3e(0x1fc)]()),this[_0x2bfc3e(0x3a8)](_0x211277,_0x1e4d7b['x']+0x1,_0x1e4d7b['y']+0x1,_0x4d296d,_0x5df3f6),this[_0x2bfc3e(0x2c5)](!![]);},Window_PartyReserve[_0x259311(0x292)][_0x259311(0x3b7)]=function(_0x2501e2){const _0x37ab79=_0x259311,_0x49fe05=this[_0x37ab79(0x3ca)](_0x2501e2),_0x4ea99f=this[_0x37ab79(0x3c1)](_0x2501e2),_0x35fe07=Window_PartyReserve[_0x37ab79(0x212)]===0x1;_0x4ea99f['x']+=ImageManager['iconWidth']*(_0x35fe07?0x2:0x1);const _0x2dfa3a=VisuMZ[_0x37ab79(0x26b)][_0x37ab79(0x195)][_0x37ab79(0x3b4)],_0x4839de=_0x4ea99f['x']+_0x2dfa3a[_0x37ab79(0x39b)]+this[_0x37ab79(0x1ba)](),_0x40a27f=_0x4ea99f['y']+_0x4ea99f['height']-_0x2dfa3a[_0x37ab79(0x381)];this['drawActorCharacter'](_0x49fe05,_0x4839de,_0x40a27f);},Window_PartyReserve['prototype'][_0x259311(0x1d5)]=function(_0x2534a6){const _0xe39132=_0x259311,_0x537c80=this[_0xe39132(0x3ca)](_0x2534a6),_0x5cd767=_0x537c80[_0xe39132(0x1de)](),_0x341247=this[_0xe39132(0x3c1)](_0x2534a6),_0x140c9c=Window_PartyReserve[_0xe39132(0x212)]===0x1;_0x341247['x']+=ImageManager[_0xe39132(0x301)]*(_0x140c9c?0x2:0x1);const _0x2ce1a7=VisuMZ[_0xe39132(0x26b)][_0xe39132(0x195)][_0xe39132(0x3b4)],_0x4017a7=_0x341247['x']+_0x2ce1a7[_0xe39132(0x2b3)]+this['itemPadding'](),_0x294233=_0x341247['y']+_0x341247['height']-_0x2ce1a7[_0xe39132(0x228)];this[_0xe39132(0x368)](_0x5cd767,_0x4017a7,_0x294233);},Window_PartyReserve['prototype'][_0x259311(0x3a5)]=function(_0x3105b7){this['_statusWindow']=_0x3105b7,this['callUpdateHelp']();},Window_PartyReserve[_0x259311(0x292)][_0x259311(0x260)]=function(){const _0x51a644=_0x259311;this['_statusWindow']&&this['_statusWindow'][_0x51a644(0x34c)](this[_0x51a644(0x3ca)](this[_0x51a644(0x329)]()));};function Window_PartyStatus(){const _0x5b4a20=_0x259311;this[_0x5b4a20(0x298)](...arguments);}Window_PartyStatus[_0x259311(0x292)]=Object[_0x259311(0x241)](Window_StatusBase[_0x259311(0x292)]),Window_PartyStatus[_0x259311(0x292)][_0x259311(0x28c)]=Window_PartyStatus,Window_PartyStatus[_0x259311(0x292)][_0x259311(0x298)]=function(_0x2f744e){const _0x20894b=_0x259311;this['_actor']=null,Window_StatusBase['prototype'][_0x20894b(0x298)][_0x20894b(0x38a)](this,_0x2f744e);},Window_PartyStatus[_0x259311(0x292)][_0x259311(0x1d7)]=function(_0x501f09,_0x59b802,_0x27e68d,_0x385568,_0x29c038){const _0x4d7932=_0x259311;if(VisuMZ[_0x4d7932(0x26b)][_0x4d7932(0x195)]['General'][_0x4d7932(0x2c9)]===![])return;_0x29c038=Math['max'](_0x29c038||0x1,0x1);while(_0x29c038--){_0x385568=_0x385568||this[_0x4d7932(0x1a6)](),this[_0x4d7932(0x339)]['paintOpacity']=0xa0;const _0x22f4b4=ColorManager['getPartySystemBackColor']();this[_0x4d7932(0x339)][_0x4d7932(0x231)](_0x501f09+0x1,_0x59b802+0x1,_0x27e68d-0x2,_0x385568-0x2,_0x22f4b4),this[_0x4d7932(0x339)][_0x4d7932(0x1a7)]=0xff;}},ColorManager[_0x259311(0x237)]=function(){const _0x310b6d=_0x259311,_0x1804a6=VisuMZ[_0x310b6d(0x26b)][_0x310b6d(0x195)][_0x310b6d(0x370)];let _0x56a39d=_0x1804a6[_0x310b6d(0x1cc)]!==undefined?_0x1804a6[_0x310b6d(0x1cc)]:0x13;return ColorManager[_0x310b6d(0x1e6)](_0x56a39d);},Window_PartyStatus[_0x259311(0x292)][_0x259311(0x34c)]=function(_0x4ab31f){const _0x5a47d2=_0x259311;if(this['_actor']===_0x4ab31f)return;this[_0x5a47d2(0x363)]=_0x4ab31f;if(_0x4ab31f){const _0x2a653e=ImageManager[_0x5a47d2(0x350)](_0x4ab31f[_0x5a47d2(0x1ff)]());_0x2a653e[_0x5a47d2(0x27a)](this[_0x5a47d2(0x36d)]['bind'](this));}else _0x5a47d2(0x3ba)===_0x5a47d2(0x355)?this['callFormation']():this['refresh']();},Window_PartyStatus[_0x259311(0x292)][_0x259311(0x36d)]=function(){const _0x44113a=_0x259311;Window_StatusBase[_0x44113a(0x292)]['refresh']['call'](this),this[_0x44113a(0x339)]['clear'](),this[_0x44113a(0x2ee)](),VisuMZ[_0x44113a(0x26b)]['Settings'][_0x44113a(0x3b4)][_0x44113a(0x2c2)][_0x44113a(0x38a)](this);},Window_PartyStatus['prototype']['refreshOG']=function(){const _0x52e4c5=_0x259311;if(!this[_0x52e4c5(0x363)]){if(_0x52e4c5(0x2d5)!==_0x52e4c5(0x2d2)){this['drawItemDarkRect'](0x0,0x0,this[_0x52e4c5(0x376)],this[_0x52e4c5(0x34e)]);const _0x31d0fc=Math['round']((this[_0x52e4c5(0x34e)]-this[_0x52e4c5(0x1a6)]())/0x2);this[_0x52e4c5(0x33b)](ColorManager[_0x52e4c5(0x266)]()),this['drawText'](TextManager['emptyPartyMember'],0x0,_0x31d0fc,this[_0x52e4c5(0x376)],'center');return;}else this[_0x52e4c5(0x336)](_0x1bbcd0[_0x52e4c5(0x1f2)],_0x36bea9,_0x4f135f),_0x211351+=_0x36c111['iconWidth']+0x4;}this['drawActorFace'](this[_0x52e4c5(0x363)],0x1,0x0,ImageManager[_0x52e4c5(0x234)],ImageManager[_0x52e4c5(0x2aa)]),this[_0x52e4c5(0x33e)](this[_0x52e4c5(0x363)],ImageManager[_0x52e4c5(0x234)]+0x24,0x0);const _0x86b413=this['lineHeight'](),_0x3994c2=this[_0x52e4c5(0x230)](),_0x13083f=Math[_0x52e4c5(0x38f)](this[_0x52e4c5(0x376)]/0x2),_0x451e75=Math[_0x52e4c5(0x28f)](_0x3994c2[_0x52e4c5(0x323)]/0x2)*_0x86b413,_0x25eaaf=0x0;let _0x428c6b=0x0,_0x755272=ImageManager['faceHeight']+_0x86b413/0x2;for(const _0x27fcca of _0x3994c2){this['drawItemDarkRect'](_0x428c6b,_0x755272,_0x13083f,_0x86b413),this['drawParamName'](_0x27fcca,_0x428c6b,_0x755272,_0x13083f),this['drawParamValue'](_0x27fcca,_0x428c6b,_0x755272,_0x13083f);if(_0x428c6b===_0x25eaaf){if(_0x52e4c5(0x388)!==_0x52e4c5(0x388)){if(this['_partySwitchBattleCommandCooldown']===_0x5cb9f1)this[_0x52e4c5(0x3a0)]();if(!this[_0x52e4c5(0x1fc)]())return![];if(this[_0x52e4c5(0x344)]())return![];return this[_0x52e4c5(0x1e3)]<=0x0;}else _0x428c6b+=_0x13083f;}else _0x428c6b=_0x25eaaf,_0x755272+=_0x86b413;}},Window_PartyStatus[_0x259311(0x292)][_0x259311(0x230)]=function(){const _0x559a71=_0x259311;if(Imported[_0x559a71(0x380)]){if(_0x559a71(0x308)!=='fYpNI')_0x426164[_0x559a71(0x26b)][_0x559a71(0x249)][_0x559a71(0x38a)](this),this['_partyCommandWindow'][_0x559a71(0x2e6)](_0x559a71(0x283),this[_0x559a71(0x186)][_0x559a71(0x1c1)](this));else return VisuMZ['CoreEngine']['Settings'][_0x559a71(0x1a9)][_0x559a71(0x3b3)];}else return[0x2,0x3,0x4,0x5,0x6,0x7];},Window_PartyStatus[_0x259311(0x292)][_0x259311(0x2fc)]=function(_0x47ac9e,_0x3aba6c,_0x30d2e4,_0x38750d){const _0x3fa22f=_0x259311,_0x57b074=this[_0x3fa22f(0x1ba)]();_0x38750d-=_0x57b074*0x2;if(Imported[_0x3fa22f(0x380)])this['drawParamText'](_0x3aba6c+_0x57b074,_0x30d2e4,_0x38750d,_0x47ac9e,![]);else{if('YybQR'!=='gCbHE'){const _0x5977fd=TextManager[_0x3fa22f(0x1df)](_0x47ac9e);this[_0x3fa22f(0x33b)](ColorManager['systemColor']()),this[_0x3fa22f(0x198)](_0x5977fd,_0x3aba6c+_0x57b074,_0x30d2e4,_0x38750d);}else{const _0x416d6f=_0xe7f524['PartySystem'][_0x3fa22f(0x195)][_0x3fa22f(0x3b4)];switch(_0x734491[_0x3fa22f(0x319)]['toLowerCase']()[_0x3fa22f(0x269)]()){case _0x3fa22f(0x291):return _0x1d6fe0[_0x3fa22f(0x234)];case _0x3fa22f(0x30e):return _0x416d6f['ReserveSpriteOffsetX']*0x2;case _0x3fa22f(0x1db):return _0x416d6f[_0x3fa22f(0x2b3)]*0x2;};}}},Window_PartyStatus['prototype']['drawParamValue']=function(_0x1fd948,_0x1fb3b6,_0x1b8f07,_0x55be1c){const _0xf61abd=_0x259311;this['resetFontSettings']();const _0x2239de=this[_0xf61abd(0x1ba)](),_0x484afa=this[_0xf61abd(0x2bd)](_0x1fd948);this[_0xf61abd(0x198)](_0x484afa,_0x1fb3b6+_0x2239de,_0x1b8f07,_0x55be1c-_0x2239de*0x2,_0xf61abd(0x23f));},Window_PartyStatus['prototype'][_0x259311(0x2bd)]=function(_0xbde88){const _0x212f92=_0x259311,_0x462170=this['_actor'];if(Imported[_0x212f92(0x380)])return _0x462170[_0x212f92(0x1a2)](_0xbde88,!![]);else{if(_0x212f92(0x1eb)===_0x212f92(0x393)){const _0x2cf662=this[_0x212f92(0x1e9)][_0x212f92(0x1d6)]();_0x2cf662?this['preparePartySwitchMember'](_0x2cf662):(this[_0x212f92(0x1e9)]['deactivate'](),this['_actorCommandWindow'][_0x212f92(0x211)]());}else return _0x462170[_0x212f92(0x1df)](_0xbde88);}};function Window_PartyBattleSwitch(){const _0x55a3d0=_0x259311;this[_0x55a3d0(0x298)](...arguments);}Window_PartyBattleSwitch[_0x259311(0x292)]=Object[_0x259311(0x241)](Window_StatusBase[_0x259311(0x292)]),Window_PartyBattleSwitch['prototype'][_0x259311(0x28c)]=Window_PartyBattleSwitch,Window_PartyBattleSwitch[_0x259311(0x292)][_0x259311(0x298)]=function(_0x821f1d){const _0x302473=_0x259311;Window_StatusBase[_0x302473(0x292)]['initialize']['call'](this,_0x821f1d),this['setBackgroundType'](VisuMZ[_0x302473(0x26b)][_0x302473(0x195)][_0x302473(0x3b4)][_0x302473(0x27e)]),this[_0x302473(0x277)]=0x0;},Window_PartyBattleSwitch['prototype']['loadFaceImages']=function(){const _0x2a9f4f=_0x259311;for(const _0xfb9bf9 of $gameParty[_0x2a9f4f(0x37f)]()){ImageManager[_0x2a9f4f(0x350)](_0xfb9bf9['faceName']());}},Window_PartyBattleSwitch['prototype'][_0x259311(0x333)]=function(){return 0x1;},Window_PartyBattleSwitch['prototype']['actor']=function(_0x3bcf97){return $gameParty['reserveMembers']()[_0x3bcf97];},Window_PartyBattleSwitch[_0x259311(0x292)][_0x259311(0x1d6)]=function(){const _0x5e5564=_0x259311;return this[_0x5e5564(0x3ca)](this[_0x5e5564(0x329)]());},Window_PartyBattleSwitch['prototype']['itemHeight']=function(){const _0x57f01f=_0x259311;return this[_0x57f01f(0x1a6)]()*0x2+0x8;},Window_PartyBattleSwitch['prototype'][_0x259311(0x305)]=function(){const _0x2d389e=_0x259311;return $gameParty[_0x2d389e(0x226)]()[_0x2d389e(0x323)];},Window_PartyBattleSwitch[_0x259311(0x292)][_0x259311(0x211)]=function(){const _0x222e53=_0x259311;Window_StatusBase[_0x222e53(0x292)]['activate'][_0x222e53(0x38a)](this),this[_0x222e53(0x286)](),this['refresh'](),this[_0x222e53(0x256)](0x0);},Window_PartyBattleSwitch[_0x259311(0x292)][_0x259311(0x307)]=function(){const _0x2b73aa=_0x259311;Window_StatusBase[_0x2b73aa(0x292)]['deactivate']['call'](this),this[_0x2b73aa(0x2fb)]();},Window_PartyBattleSwitch[_0x259311(0x292)][_0x259311(0x2a4)]=function(){const _0x6ae30a=_0x259311;return this[_0x6ae30a(0x224)](this[_0x6ae30a(0x1d6)]());},Window_PartyBattleSwitch[_0x259311(0x292)][_0x259311(0x224)]=function(_0x5c56f3){const _0xdeec5f=_0x259311;if(!_0x5c56f3)return![];return _0x5c56f3[_0xdeec5f(0x1fc)]()&&_0x5c56f3[_0xdeec5f(0x35c)]();},Window_PartyBattleSwitch[_0x259311(0x292)][_0x259311(0x272)]=function(_0x5ea89e){const _0x5c9cef=_0x259311,_0x3f252c=this[_0x5c9cef(0x3ca)](_0x5ea89e);if(!_0x3f252c)return;const _0x34ccac=ImageManager['loadFace'](_0x3f252c[_0x5c9cef(0x1ff)]());_0x34ccac['addLoadListener'](this['processDrawItem'][_0x5c9cef(0x1c1)](this,_0x5ea89e));},Window_PartyBattleSwitch[_0x259311(0x292)]['processDrawItem']=function(_0x1d3716){const _0x419900=_0x259311;this[_0x419900(0x2e1)](_0x1d3716),this[_0x419900(0x2a8)](_0x1d3716);},Window_PartyBattleSwitch[_0x259311(0x292)][_0x259311(0x2e1)]=function(_0xcb415a){const _0x14b304=_0x259311,_0x205802=this[_0x14b304(0x3ca)](_0xcb415a),_0x143cac=this[_0x14b304(0x3c1)](_0xcb415a);this[_0x14b304(0x2c5)](this[_0x14b304(0x224)](_0x205802)),this[_0x14b304(0x3a8)](_0x205802,_0x143cac['x']+0x1,_0x143cac['y']+0x1,ImageManager[_0x14b304(0x234)],_0x143cac[_0x14b304(0x3b0)]-0x2),this[_0x14b304(0x2c5)](!![]);},Window_PartyBattleSwitch[_0x259311(0x292)][_0x259311(0x2a8)]=function(_0x16e708){const _0x2ca539=_0x259311,_0x55b7ad=this[_0x2ca539(0x3ca)](_0x16e708),_0x271bea=this[_0x2ca539(0x18a)](_0x16e708),_0x133016=_0x271bea['x']+ImageManager['faceWidth']+0x24,_0x455c1a=_0x133016+0xb4;this['changePaintOpacity'](this[_0x2ca539(0x224)](_0x55b7ad)),this[_0x2ca539(0x35d)](_0x55b7ad,_0x133016,_0x271bea['y']),this[_0x2ca539(0x37e)](_0x55b7ad,_0x133016,_0x271bea['y']+this[_0x2ca539(0x1a6)]()),this['placeBasicGauges'](_0x55b7ad,_0x455c1a,_0x271bea['y']),this['changePaintOpacity'](!![]);};Imported['VisuMZ_1_BattleCore']&&(ImageManager[_0x259311(0x1b8)]=VisuMZ['PartySystem'][_0x259311(0x195)][_0x259311(0x370)][_0x259311(0x3aa)]??0x4b,TextManager[_0x259311(0x1f1)]=VisuMZ[_0x259311(0x26b)]['Settings'][_0x259311(0x326)][_0x259311(0x30f)],TextManager['battlePartyChangeCmdHelp']=VisuMZ[_0x259311(0x26b)]['Settings'][_0x259311(0x326)][_0x259311(0x28e)],TextManager[_0x259311(0x2b0)]=VisuMZ[_0x259311(0x26b)][_0x259311(0x195)][_0x259311(0x326)][_0x259311(0x3af)],TextManager[_0x259311(0x1d2)]=VisuMZ[_0x259311(0x26b)]['Settings']['Vocab'][_0x259311(0x2a7)],TextManager[_0x259311(0x314)]=VisuMZ[_0x259311(0x26b)][_0x259311(0x195)]['Vocab'][_0x259311(0x1b9)],VisuMZ['PartySystem'][_0x259311(0x3b8)]=SceneManager[_0x259311(0x24e)],SceneManager['isPreviousSceneBattleTransitionable']=function(){const _0xa8d4d2=_0x259311;if(SceneManager[_0xa8d4d2(0x366)](Scene_Party))return!![];return VisuMZ[_0xa8d4d2(0x26b)]['SceneManager_isPreviousSceneBattleTransitionable'][_0xa8d4d2(0x38a)](this);},VisuMZ[_0x259311(0x26b)][_0x259311(0x19f)]=SceneManager['isNextSceneBattleTransitionable'],SceneManager[_0x259311(0x36c)]=function(){const _0x3eb9b5=_0x259311;if(SceneManager[_0x3eb9b5(0x2c6)](Scene_Party))return!![];return VisuMZ['PartySystem'][_0x3eb9b5(0x19f)][_0x3eb9b5(0x38a)](this);},SceneManager[_0x259311(0x2e0)]=function(){const _0xc52566=_0x259311;return this[_0xc52566(0x39d)]&&this[_0xc52566(0x39d)][_0xc52566(0x28c)]===Scene_Map;},VisuMZ[_0x259311(0x26b)][_0x259311(0x222)]=Scene_Battle[_0x259311(0x292)]['createAllWindows'],Scene_Battle[_0x259311(0x292)]['createAllWindows']=function(){const _0x260aa6=_0x259311;VisuMZ[_0x260aa6(0x26b)][_0x260aa6(0x222)][_0x260aa6(0x38a)](this),this['createPartySwitchWindow'](),this['postPartySwitchMenuTpb'](),this[_0x260aa6(0x265)]();},Scene_Battle[_0x259311(0x292)][_0x259311(0x34f)]=function(){const _0x474ccd=_0x259311,_0x5a4d13=this[_0x474ccd(0x1ad)]();this['_partyMemberSwitchWindow']=new Window_PartyBattleSwitch(_0x5a4d13),this['addWindow'](this[_0x474ccd(0x1e9)]),this['_partyMemberSwitchWindow']['setHandler']('ok',this[_0x474ccd(0x390)]['bind'](this)),this[_0x474ccd(0x1e9)][_0x474ccd(0x2e6)](_0x474ccd(0x35b),this[_0x474ccd(0x372)][_0x474ccd(0x1c1)](this));},Scene_Battle[_0x259311(0x292)][_0x259311(0x1ad)]=function(){const _0x365638=_0x259311,_0x5ed4db=this[_0x365638(0x39c)]();if(_0x5ed4db===_0x365638(0x19c))return this['partySwitchWindowRectBorder']();else{if(_0x365638(0x267)!==_0x365638(0x267)){if(!this[_0x365638(0x28a)]())return;if(_0x364efa[_0x365638(0x255)](_0x365638(0x1d8))){const _0x52cc4c=this['currentActor']();this['processShiftRemoveShortcut']();}}else return this[_0x365638(0x1d4)]();}},Scene_Battle['prototype'][_0x259311(0x1d4)]=function(){const _0x38f31d=_0x259311;return VisuMZ[_0x38f31d(0x26b)][_0x38f31d(0x195)][_0x38f31d(0x3b4)]['BattleSwitchWindowRect'][_0x38f31d(0x38a)](this);},Scene_Battle[_0x259311(0x292)][_0x259311(0x1fe)]=function(){const _0x46efc3=_0x259311,_0x480f3f=this[_0x46efc3(0x389)](),_0x451289=$gameSystem['windowPadding']()*0x2;return _0x480f3f[_0x46efc3(0x1e2)]=0x204+_0x451289,_0x480f3f;},VisuMZ[_0x259311(0x26b)][_0x259311(0x2e4)]=Scene_Battle[_0x259311(0x292)][_0x259311(0x21b)],Scene_Battle[_0x259311(0x292)][_0x259311(0x21b)]=function(){const _0x549f27=_0x259311;if(this[_0x549f27(0x1e9)]&&this[_0x549f27(0x1e9)]['active'])return!![];if(this[_0x549f27(0x32d)])return!![];if(this['_callPartyMemberSwitch'])return!![];if(this['_callSceneParty'])return!![];return VisuMZ[_0x549f27(0x26b)]['Scene_Battle_isAnyInputWindowActive']['call'](this);},VisuMZ[_0x259311(0x26b)][_0x259311(0x249)]=Scene_Battle[_0x259311(0x292)][_0x259311(0x23b)],Scene_Battle['prototype'][_0x259311(0x23b)]=function(){const _0x5af45c=_0x259311;VisuMZ[_0x5af45c(0x26b)]['Scene_Battle_createPartyCommandWindowBattleCore'][_0x5af45c(0x38a)](this),this[_0x5af45c(0x3c4)][_0x5af45c(0x2e6)](_0x5af45c(0x283),this[_0x5af45c(0x186)][_0x5af45c(0x1c1)](this));},Scene_Battle[_0x259311(0x292)]['commandFormation']=function(){const _0x30ab0a=_0x259311;this[_0x30ab0a(0x268)]()?_0x30ab0a(0x2fe)===_0x30ab0a(0x285)?this[_0x30ab0a(0x298)](...arguments):(this[_0x30ab0a(0x1ab)]=!![],this[_0x30ab0a(0x271)][_0x30ab0a(0x240)](TextManager[_0x30ab0a(0x314)]['format'](TextManager['formation']))):this['callFormation']();},Scene_Battle[_0x259311(0x292)][_0x259311(0x268)]=function(){return BattleManager['isActiveTpb']();},Scene_Battle[_0x259311(0x292)][_0x259311(0x27c)]=function(){const _0x5bda32=_0x259311;this[_0x5bda32(0x1ab)]=![],this[_0x5bda32(0x1b3)]['update'](),this[_0x5bda32(0x39a)][_0x5bda32(0x1dd)]=![],SceneManager[_0x5bda32(0x364)](),SceneManager[_0x5bda32(0x30c)](Scene_Party),$gameParty[_0x5bda32(0x1b6)](),BattleManager['isTpb']()&&(BattleManager[_0x5bda32(0x338)]=BattleManager[_0x5bda32(0x3ca)]());},VisuMZ[_0x259311(0x26b)][_0x259311(0x1c7)]=Scene_Battle['prototype'][_0x259311(0x261)],Scene_Battle['prototype'][_0x259311(0x261)]=function(){const _0x207e21=_0x259311;VisuMZ[_0x207e21(0x26b)][_0x207e21(0x1c7)][_0x207e21(0x38a)](this);this[_0x207e21(0x1ab)]&&!BattleManager[_0x207e21(0x20f)]&&this[_0x207e21(0x27c)]();if(this[_0x207e21(0x343)]&&!BattleManager[_0x207e21(0x20f)]){if('JAaxM'!==_0x207e21(0x383))this[_0x207e21(0x2c1)]();else{if(!_0x467f5e[_0x207e21(0x2e0)]())return;if(_0x3f8011[_0x207e21(0x24f)]()[_0x207e21(0x323)]<=0x1)return;if(!_0xb40386[_0x207e21(0x1f6)])return;if(_0x3f454c['_battleMembers'][_0x207e21(0x323)]<=0x0)return;_0x1df530['ConvertParams'](_0xa78e49,_0x176fbb);const _0x41c512=_0x5ab933['Index'],_0x442ced=_0x198e0f[_0x207e21(0x1f6)][_0x41c512];_0x238c7b[_0x207e21(0x29d)](_0x442ced),_0x2f67b6[_0x207e21(0x36d)]();}}},VisuMZ['PartySystem']['Scene_Battle_isTimeActive']=Scene_Battle[_0x259311(0x292)]['isTimeActive'],Scene_Battle[_0x259311(0x292)][_0x259311(0x239)]=function(){const _0x65001f=_0x259311;if(BattleManager['isActiveTpb']()){if(this[_0x65001f(0x1e9)]&&this[_0x65001f(0x1e9)][_0x65001f(0x27d)])return'ELQkN'!==_0x65001f(0x18c)?![]:this[_0x65001f(0x245)](_0x24071e(_0x559863));}return VisuMZ[_0x65001f(0x26b)][_0x65001f(0x36a)]['call'](this);},VisuMZ['PartySystem'][_0x259311(0x22a)]=Scene_Battle[_0x259311(0x292)]['createActorCommandWindow'],Scene_Battle[_0x259311(0x292)][_0x259311(0x348)]=function(){const _0x5327bd=_0x259311;VisuMZ[_0x5327bd(0x26b)][_0x5327bd(0x22a)][_0x5327bd(0x38a)](this),this['_actorCommandWindow']['setHandler']('formation',this[_0x5327bd(0x209)][_0x5327bd(0x1c1)](this));},Scene_Battle[_0x259311(0x292)][_0x259311(0x209)]=function(){const _0x2936b2=_0x259311;this[_0x2936b2(0x268)]()?(this[_0x2936b2(0x343)]=!![],this[_0x2936b2(0x271)]['addText'](TextManager['ActiveTpbFormationMessage'][_0x2936b2(0x207)](TextManager['formation']))):this[_0x2936b2(0x2c1)]();},Scene_Battle[_0x259311(0x292)][_0x259311(0x2c1)]=function(){const _0x36090e=_0x259311;this[_0x36090e(0x343)]=![],this[_0x36090e(0x271)][_0x36090e(0x29b)](),BattleManager['actor']()&&this[_0x36090e(0x1e9)][_0x36090e(0x211)]();},Scene_Battle['prototype'][_0x259311(0x390)]=function(){const _0x2fa7f6=_0x259311,_0x21af0f=this[_0x2fa7f6(0x1e9)][_0x2fa7f6(0x1d6)]();_0x21af0f?this[_0x2fa7f6(0x321)](_0x21af0f):(this[_0x2fa7f6(0x1e9)]['deactivate'](),this[_0x2fa7f6(0x330)][_0x2fa7f6(0x211)]());},Scene_Battle[_0x259311(0x292)][_0x259311(0x321)]=function(_0x195e31){const _0xad0272=_0x259311,_0x380e28=BattleManager[_0xad0272(0x3ca)](),_0x556312=_0x380e28[_0xad0272(0x244)]();this[_0xad0272(0x1e9)][_0xad0272(0x307)]();if(this[_0xad0272(0x354)]()&&_0x556312)this['_partySystemSwitchOut']=!![],_0x556312[_0xad0272(0x32f)](_0x195e31);else{if('CmAAS'===_0xad0272(0x1d3)){const _0xd7ece1=_0x2ed02d['loadFace'](_0x52ad56[_0xad0272(0x1ff)]());_0xd7ece1['addLoadListener'](this[_0xad0272(0x36d)][_0xad0272(0x1c1)](this));}else this[_0xad0272(0x1a5)](_0x195e31);}},Scene_Battle[_0x259311(0x292)][_0x259311(0x354)]=function(){const _0x581da3=_0x259311;return VisuMZ[_0x581da3(0x26b)][_0x581da3(0x195)][_0x581da3(0x370)]['SwitchOutAnimation'];},Scene_Battle[_0x259311(0x292)][_0x259311(0x1a5)]=function(_0x4c5df9){const _0x17f67a=_0x259311;this[_0x17f67a(0x32d)]=![];const _0xdf5e96=BattleManager[_0x17f67a(0x3ca)](),_0x2fe431=_0xdf5e96['battler'](),_0x2a5b3d=$gameParty[_0x17f67a(0x1f6)][_0x17f67a(0x2dc)](_0xdf5e96[_0x17f67a(0x19e)]());$gameParty[_0x17f67a(0x1f6)][_0x2a5b3d]=_0x4c5df9[_0x17f67a(0x19e)](),$gameParty[_0x17f67a(0x2c4)]();if(this['isImmediateTpb']())_0x4c5df9['_tpbChargeTime']=_0xdf5e96[_0x17f67a(0x324)],_0x4c5df9['_tpbState']=_0x17f67a(0x1ec);else BattleManager[_0x17f67a(0x262)]()&&_0x4c5df9[_0x17f67a(0x242)]();BattleManager[_0x17f67a(0x276)]=_0x4c5df9,BattleManager[_0x17f67a(0x384)](_0xdf5e96,_0x4c5df9),_0x4c5df9[_0x17f67a(0x1b6)](),_0x4c5df9[_0x17f67a(0x1a8)](),_0x4c5df9['onBattlePartySwitch'](_0xdf5e96),_0x2fe431&&_0x2fe431[_0x17f67a(0x196)](_0x4c5df9),this[_0x17f67a(0x20e)]['switchStateIconActor'](_0xdf5e96,_0x4c5df9),this[_0x17f67a(0x20e)][_0x17f67a(0x36d)](),this[_0x17f67a(0x330)]['setup'](_0x4c5df9),this[_0x17f67a(0x330)][_0x17f67a(0x256)](0x0),this[_0x17f67a(0x330)][_0x17f67a(0x211)](),this[_0x17f67a(0x330)][_0x17f67a(0x30d)]=!![];},Scene_Battle[_0x259311(0x292)][_0x259311(0x238)]=function(){const _0x5d6949=_0x259311;if(!BattleManager[_0x5d6949(0x262)]())return![];const _0xc16cab=VisuMZ[_0x5d6949(0x26b)][_0x5d6949(0x195)][_0x5d6949(0x370)];return _0xc16cab[_0x5d6949(0x235)]===undefined&&(_0xc16cab[_0x5d6949(0x235)]=!![]),_0xc16cab['tpbImmediateAction'];},Window_StatusBase['prototype'][_0x259311(0x21d)]=function(_0x57150f,_0x4dd583){const _0x4e5fdb=_0x259311,_0x9734e2=_0x4e5fdb(0x341)[_0x4e5fdb(0x207)](_0x57150f[_0x4e5fdb(0x19e)]()),_0x5e1001=this[_0x4e5fdb(0x2f9)](_0x9734e2,Sprite_StateIcon);_0x5e1001[_0x4e5fdb(0x2a6)](_0x4dd583);},Scene_Battle[_0x259311(0x292)]['onPartySwitchCancel']=function(){const _0x18a2ad=_0x259311;this['_partyMemberSwitchWindow'][_0x18a2ad(0x307)](),this['_actorCommandWindow'][_0x18a2ad(0x211)](),this[_0x18a2ad(0x330)][_0x18a2ad(0x36d)]();},Scene_Battle[_0x259311(0x292)]['postPartySwitchMenuTpb']=function(){const _0x473a22=_0x259311;if(!BattleManager[_0x473a22(0x262)]())return;if(!SceneManager[_0x473a22(0x366)](Scene_Party))return;this[_0x473a22(0x3c4)][_0x473a22(0x307)](),this[_0x473a22(0x3c4)][_0x473a22(0x2fb)](),this[_0x473a22(0x330)][_0x473a22(0x307)](),this[_0x473a22(0x330)]['close'](),BattleManager[_0x473a22(0x276)]=null,BattleManager[_0x473a22(0x254)]=![];},Scene_Battle['prototype'][_0x259311(0x265)]=function(){const _0x2a038a=_0x259311;if(BattleManager[_0x2a038a(0x262)]())return;if(!SceneManager[_0x2a038a(0x366)](Scene_Party))return;Imported[_0x2a038a(0x377)]&&BattleManager[_0x2a038a(0x297)]()&&BattleManager[_0x2a038a(0x278)]();Imported[_0x2a038a(0x227)]&&BattleManager[_0x2a038a(0x30a)]()&&(BattleManager[_0x2a038a(0x278)](),BattleManager['_currentActor']=$gameParty[_0x2a038a(0x3a1)](),BattleManager[_0x2a038a(0x20f)]=BattleManager[_0x2a038a(0x3ca)](),BattleManager[_0x2a038a(0x254)]=!![],this[_0x2a038a(0x330)][_0x2a038a(0x2a6)](BattleManager[_0x2a038a(0x3ca)]()),this['_statusWindow']['selectActor'](BattleManager[_0x2a038a(0x3ca)]()));Imported[_0x2a038a(0x220)]&&BattleManager[_0x2a038a(0x279)]()&&(BattleManager[_0x2a038a(0x278)](),BattleManager[_0x2a038a(0x276)]=$gameParty[_0x2a038a(0x3a1)](),BattleManager[_0x2a038a(0x20f)]=BattleManager['actor'](),BattleManager[_0x2a038a(0x254)]=!![],this['_actorCommandWindow']['setup'](BattleManager['actor']()),this[_0x2a038a(0x20e)][_0x2a038a(0x1f7)](BattleManager[_0x2a038a(0x3ca)]()));if(Imported['VisuMZ_2_BattleSystemPTB']&&BattleManager[_0x2a038a(0x386)]()){if('QtskR'!==_0x2a038a(0x1bd))BattleManager[_0x2a038a(0x278)](),BattleManager['_currentActor']=$gameParty['teamBasedFirstAvailableMember'](),BattleManager[_0x2a038a(0x20f)]=BattleManager['actor'](),BattleManager[_0x2a038a(0x254)]=!![],this['_actorCommandWindow'][_0x2a038a(0x2a6)](BattleManager[_0x2a038a(0x3ca)]()),this[_0x2a038a(0x20e)]['selectActor'](BattleManager[_0x2a038a(0x3ca)]());else{!_0x2c510e&&(this[_0x2a038a(0x1da)]=_0x28d3fc[_0x2a038a(0x2c0)]);this[_0x2a038a(0x1f6)]=this[_0x2a038a(0x252)]['slice'](0x0,this['_battleMaxSize']);while(this[_0x2a038a(0x1f6)][_0x2a038a(0x323)]<this[_0x2a038a(0x1da)]){this[_0x2a038a(0x1f6)][_0x2a038a(0x30c)](0x0);}if(_0x4db18a)_0x229a36[_0x2a038a(0x36d)]();}}},Game_Party[_0x259311(0x292)][_0x259311(0x3a1)]=function(){const _0x49914c=_0x259311;let _0x47010f=this[_0x49914c(0x24f)]();return _0x47010f[0x0];},Sprite_Actor[_0x259311(0x2f5)]=0xc,Sprite_Actor[_0x259311(0x292)][_0x259311(0x32f)]=function(_0x42a0d9){const _0x52761f=_0x259311;this[_0x52761f(0x2bc)]=_0x42a0d9;const _0xc35dda=Sprite_Actor[_0x52761f(0x2f5)];this[_0x52761f(0x369)](0x12c,0x0,_0xc35dda),this[_0x52761f(0x3a7)](0x0,_0xc35dda),this[_0x52761f(0x2f5)]=_0xc35dda;},Sprite_Actor[_0x259311(0x292)][_0x259311(0x2fa)]=function(_0x56fde8){const _0x2dc7e8=_0x259311;if(SceneManager[_0x2dc7e8(0x23e)]()){SceneManager[_0x2dc7e8(0x39d)]['processPartySwitchMember'](_0x56fde8);const _0x269f1a=Sprite_Actor['_partySwitchDuration'];this[_0x2dc7e8(0x26f)](),this[_0x2dc7e8(0x3a7)](0xff,_0x269f1a);}this[_0x2dc7e8(0x2bc)]=null;},VisuMZ[_0x259311(0x26b)]['Sprite_Actor_update']=Sprite_Actor['prototype']['update'],Sprite_Actor[_0x259311(0x292)][_0x259311(0x2be)]=function(){const _0x103b77=_0x259311;VisuMZ[_0x103b77(0x26b)][_0x103b77(0x31f)][_0x103b77(0x38a)](this);if(this[_0x103b77(0x2f5)])this[_0x103b77(0x2f4)]();},Sprite_Actor[_0x259311(0x292)]['updatePartySwitch']=function(){const _0x10cb2b=_0x259311;this['_partySwitchDuration']=this[_0x10cb2b(0x2f5)]||0x0,this[_0x10cb2b(0x2f5)]--;if(this[_0x10cb2b(0x2f5)]<=0x0){if(_0x10cb2b(0x385)!=='ctFvv'){const _0x4282df=_0x296ca0(_0x2a80eb['$1']);_0x4282df!==_0x571aec[_0x3e02aa][_0x10cb2b(0x2a9)]&&(_0x163fee(_0x10cb2b(0x190)[_0x10cb2b(0x207)](_0x2e265b,_0x4282df)),_0x5d2579['exit']());}else this[_0x10cb2b(0x2fa)](this[_0x10cb2b(0x2bc)]);}},Window_PartyCommand[_0x259311(0x292)]['addCustomCommands']=function(){const _0x1e72b4=_0x259311;this[_0x1e72b4(0x1be)]();},Window_PartyCommand[_0x259311(0x292)]['addFormationCommand']=function(){const _0x2963e5=_0x259311;if(!this['isFormationCommandAdded']())return;if(this[_0x2963e5(0x23c)]()){if(_0x2963e5(0x259)===_0x2963e5(0x359))this[_0x2963e5(0x378)]['activate'](),this[_0x2963e5(0x378)][_0x2963e5(0x289)]();else{$gameTemp['isPlaytest']()&&!BattleManager[_0x2963e5(0x2b8)]&&(console['log'](_0x2963e5(0x273)),BattleManager[_0x2963e5(0x2b8)]=!![]);return;}}const _0x4b6aea=this[_0x2963e5(0x2f1)](),_0xfb6416=ImageManager[_0x2963e5(0x1b8)],_0x4c554c=_0x4b6aea===_0x2963e5(0x352)?TextManager[_0x2963e5(0x1f1)]:_0x2963e5(0x32a)['format'](_0xfb6416,TextManager[_0x2963e5(0x1f1)]),_0xb1a495=this[_0x2963e5(0x1c3)]();this[_0x2963e5(0x2ec)](_0x4c554c,_0x2963e5(0x283),_0xb1a495);},Window_PartyCommand[_0x259311(0x292)][_0x259311(0x22b)]=function(){const _0x11ad97=_0x259311;if(Imported[_0x11ad97(0x2d9)]&&BattleManager[_0x11ad97(0x356)]())return![];if(Imported[_0x11ad97(0x327)]&&BattleManager['isSTB']())return![];if(Imported[_0x11ad97(0x1a4)]&&BattleManager[_0x11ad97(0x19b)]())return![];return VisuMZ['PartySystem'][_0x11ad97(0x195)][_0x11ad97(0x370)]['PartyCmdWinAddParty'];},Window_PartyCommand[_0x259311(0x292)][_0x259311(0x23c)]=function(){return![];},Window_PartyCommand['prototype'][_0x259311(0x1c3)]=function(){const _0x110684=_0x259311;if($gameParty[_0x110684(0x37f)]()[_0x110684(0x323)]<=0x1)return![];if(!$gameParty[_0x110684(0x191)]())return![];return $gameSystem[_0x110684(0x34b)]();},VisuMZ[_0x259311(0x26b)][_0x259311(0x195)][_0x259311(0x1fa)]=Window_PartyCommand[_0x259311(0x292)][_0x259311(0x280)],Window_PartyCommand['prototype'][_0x259311(0x280)]=function(){const _0x912263=_0x259311,_0x1bdda7=this[_0x912263(0x2cd)]();switch(_0x1bdda7){case _0x912263(0x283):this[_0x912263(0x22d)][_0x912263(0x2f8)](TextManager[_0x912263(0x2d3)]);break;default:VisuMZ[_0x912263(0x26b)][_0x912263(0x195)][_0x912263(0x1fa)][_0x912263(0x38a)](this);break;}},Window_ActorCommand[_0x259311(0x292)][_0x259311(0x2ed)]=function(){const _0x25b056=_0x259311;if(!this[_0x25b056(0x25a)]())return;this['findSymbol'](_0x25b056(0x283))>=0x0&&this['removePartyCommand']();const _0x8feb20=this['commandStyle'](),_0x3ebe8d=ImageManager[_0x25b056(0x1b8)],_0x364690=_0x8feb20===_0x25b056(0x352)?TextManager[_0x25b056(0x2b0)]:'\x5cI[%1]%2'[_0x25b056(0x207)](_0x3ebe8d,TextManager[_0x25b056(0x1f1)]),_0x5da37e=this[_0x25b056(0x1ca)]();this[_0x25b056(0x2ec)](_0x364690,_0x25b056(0x283),_0x5da37e);},Window_ActorCommand['prototype'][_0x259311(0x25a)]=function(){const _0x495978=_0x259311;if(!this[_0x495978(0x363)])return![];return VisuMZ[_0x495978(0x26b)]['Settings'][_0x495978(0x370)][_0x495978(0x395)];},Window_ActorCommand[_0x259311(0x292)]['isPartyCommandEnabled']=function(){const _0x342291=_0x259311;if($gameParty[_0x342291(0x37f)]()[_0x342291(0x323)]<=0x1)return![];if(!this[_0x342291(0x363)])return![];if(!this[_0x342291(0x363)][_0x342291(0x191)]())return![];return this[_0x342291(0x363)]['isFormationChangeOk']();},VisuMZ['PartySystem']['Settings'][_0x259311(0x214)]=Window_ActorCommand['prototype']['updateHelp'],Window_ActorCommand[_0x259311(0x292)][_0x259311(0x280)]=function(){const _0x11e664=_0x259311,_0x1bea9b=this[_0x11e664(0x2cd)]();if(!_0x1bea9b)return;switch(_0x1bea9b[_0x11e664(0x1af)]()){case _0x11e664(0x283):this['_helpWindow'][_0x11e664(0x2f8)](TextManager[_0x11e664(0x1d2)]);break;default:VisuMZ[_0x11e664(0x26b)][_0x11e664(0x195)][_0x11e664(0x214)][_0x11e664(0x38a)](this);break;}},Window_ActorCommand[_0x259311(0x292)][_0x259311(0x1c9)]=function(){const _0x3614f0=_0x259311;while(this[_0x3614f0(0x1a3)](_0x3614f0(0x283))>=0x0){const _0x583ae2=this['findSymbol']('formation');this[_0x3614f0(0x29a)][_0x3614f0(0x2de)](_0x583ae2,0x1);}});;