//=============================================================================
// VisuStella MZ - QTE & Trigger System
// VisuMZ_2_QTE_TriggerSys.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_2_QTE_TriggerSys = true;

var VisuMZ = VisuMZ || {};
VisuMZ.QTE_TriggerSys = VisuMZ.QTE_TriggerSys || {};
VisuMZ.QTE_TriggerSys.version = 1.00;

//=============================================================================
/* ----------------------------------------------------------------------------
 * Game Over Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~GameOver:
 * 
 * @param DefaultGameOverEvent:num
 * @text Default Common Event
 * @parent GameOver
 * @type common_event
 * @desc Do you want there to be a Default Common Event?
 * It can be changed later. 0 to not use.
 * @default 0
 *
 * @param HealOnEvent:eval
 * @text Heal on Common Event?
 * @parent GameOver
 * @type boolean
 * @on Heal
 * @off Don't Heal
 * @desc Do you want to heal 1 HP for all dead members after
 * running the Game Over Common Event?
 * @default true
 *
 * @param ClearOnEvent:eval
 * @text Clear After?
 * @parent GameOver
 * @type boolean
 * @on Clear
 * @off Don't Clear
 * @desc Do you wish to clear the Game Over Common Event after
 * it launches or not?
 * @default false
 *
 */
/* ----------------------------------------------------------------------------
 * QTE Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~QTE:
 *
 * @param EarlyFinishDuration:num
 * @text Early Finish Duration
 * @type number
 * @min 1
 * @desc How many frames should the game wait if the player finishes a QTE early?
 * @default 40
 *
 * @param ShowQteTimer:eval
 * @text Show QTE Timer?
 * @type boolean
 * @on Show
 * @off Don't Show
 * @desc Do you wish to show a QTE Timer over each QTE window?
 * @default true
 * 
 * @param qteTimerGaugeStyleType:str
 * @text Timer Gauge Style
 * @parent ShowQteTimer:eval
 * @type select
 * @option -
 * @option Normal
 * @option -
 * @option Arrow
 * @option Dipper
 * @option Flag
 * @option Growth
 * @option Lean
 * @option Quad
 * @option Stagger
 * @option Trapezoid
 * @option -
 * @option HalfStep
 * @option ThirdStep
 * @option FourthStep
 * @option FifthStep
 * @option SixthStep
 * @option EighthStep
 * @option TenthStep
 * @option -
 * @option HalfSection
 * @option ThirdSection
 * @option FourthSection
 * @option FifthSection
 * @option SixthSection
 * @option EighthSection
 * @option TenthSection
 * @option -
 * @option SegmentBy10
 * @option SegmentBy20
 * @option SegmentBy25
 * @option SegmentBy50
 * @option SegmentBy100
 * @option SegmentBy200
 * @option SegmentBy250
 * @option SegmentBy500
 * @option SegmentBy1000
 * @option -
 * @desc Select the gauge style to use for QTE Timer.
 * Requires VisuMZ_3_VisualGaugeStyles!
 * @default Dipper
 *
 * @param QteTimerColor1:str
 * @text Gauge Color 1
 * @parent ShowQteTimer:eval
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 26
 *
 * @param QteTimerColor2:str
 * @text Gauge Color 2
 * @parent ShowQteTimer:eval
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 27
 *
 * @param QteTimerWindowRectJS:func
 * @text JS: X, Y, W, H
 * @parent ShowQteTimer:eval
 * @type note
 * @desc Code used to determine the position and dimensions for this window containing the gauge.
 * @default "// Declare Dimensions\nlet width = Math.ceil(Graphics.width / 2);\nlet height = Scene_Base.prototype.calcWindowHeight(1);\nlet x = Math.floor((Graphics.width - width) / 2);\nlet y = Graphics.height - Math.floor(height * 0.6);\ny -= Scene_Base.prototype.calcWindowHeight(4, true);\n\n// Return Rectangle\nreturn new Rectangle(x, y, width, height);"
 *
 * @param ShowQteProgress:eval
 * @text Show QTE Progress?
 * @type boolean
 * @on Show
 * @off Don't Show
 * @desc Show a progress gauge for certain types of QTE's?
 * @default true
 * 
 * @param qteProgressGaugeStyleType:str
 * @text Progress Gauge Style
 * @parent ShowQteProgress:eval
 * @type select
 * @option -
 * @option Normal
 * @option -
 * @option Arrow
 * @option Dipper
 * @option Flag
 * @option Growth
 * @option Lean
 * @option Quad
 * @option Stagger
 * @option Trapezoid
 * @option -
 * @option HalfStep
 * @option ThirdStep
 * @option FourthStep
 * @option FifthStep
 * @option SixthStep
 * @option EighthStep
 * @option TenthStep
 * @option -
 * @option HalfSection
 * @option ThirdSection
 * @option FourthSection
 * @option FifthSection
 * @option SixthSection
 * @option EighthSection
 * @option TenthSection
 * @option -
 * @option SegmentBy10
 * @option SegmentBy20
 * @option SegmentBy25
 * @option SegmentBy50
 * @option SegmentBy100
 * @option SegmentBy200
 * @option SegmentBy250
 * @option SegmentBy500
 * @option SegmentBy1000
 * @option -
 * @desc Select the gauge style to use for QTE Timer.
 * Requires VisuMZ_3_VisualGaugeStyles!
 * @default Growth
 *
 * @param QteProgressColor1:str
 * @text Gauge Color 1
 * @parent ShowQteProgress:eval
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 17
 *
 * @param QteProgressColor2:str
 * @text Gauge Color 2
 * @parent ShowQteProgress:eval
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 24
 *
 * @param QteProgressWindowRectJS:func
 * @text JS: X, Y, W, H
 * @parent ShowQteProgress:eval
 * @type note
 * @desc Code used to determine the position and dimensions for this window containing the gauge.
 * @default "// Declare Dimensions\nlet width = Math.ceil(Graphics.width / 3);\nlet height = Scene_Base.prototype.calcWindowHeight(1);\nlet x = Math.floor((Graphics.width - width) / 2);\nlet y = Graphics.height - Scene_Base.prototype.calcWindowHeight(3, false);\ny -= Scene_Base.prototype.calcWindowHeight(4, true);\n\n// Return Rectangle\nreturn new Rectangle(x, y, width, height);"
 *
 * @param TimedHitSuccessFrames:num
 * @text Timed Hit Leeway
 * @type number
 * @min 1
 * @desc How many frames of leeway should be granted to Timed Hit QTE?
 * @default 12
 *
 * @param TimedHitOpacity:num
 * @text Overlay Opacity
 * @parent TimedHitSuccessFrames:num
 * @type number
 * @min 0
 * @max 255
 * @desc Timed Hit overlay sprite opacity.
 * @default 128
 *
 * @param TimedHitMaxSize:num
 * @text Max Scaling
 * @parent TimedHitSuccessFrames:num
 * @desc What's the max scaling for Timed Hit QTE indicators?
 * @default 4.0
 *
 * @param TimedSeqSuccessFrames:num
 * @text Timed Sequence Leeway
 * @type number
 * @min 1
 * @desc How many frames of leeway should be granted to Timed Sequence QTE?
 * @default 8
 *
 * @param TimedSequenceLandPosition:num
 * @text Sequence Position
 * @parent TimedSeqSuccessFrames:num
 * @type number
 * @min 0
 * @max 100
 * @desc What is the position for the Timed Sequence Landing Icon?
 * Use a number between 0 and 100.
 * @default 30
 *
 * @param QteTimingBarWidth:num
 * @text QTE Timing Bar Width
 * @type number
 * @min 1
 * @desc This is the width of the Timing Bar in pixels.
 * @default 600
 *
 * @param TimingBarCursorOffsetX:num
 * @text Cursor Offset X
 * @parent QteTimingBarWidth:num
 * @desc Offsets the cursor x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param TimingBarCursorOffsetY:num
 * @text Cursor Offset Y
 * @parent QteTimingBarWidth:num
 * @desc Offsets the cursor y position.
 * Negative: up. Positive: down.
 * @default +6
 *
 * @param TimingBarFontSize:num
 * @text Label Font Size
 * @parent QteTimingBarWidth:num
 * @number
 * @min 1
 * @desc What is the font size used to display timing bar labels?
 * @default 20
 *
 * @param TimingBarLabelOffsetX:num
 * @text Label Offset X
 * @parent QteTimingBarWidth:num
 * @desc Offsets the label x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param TimingBarLabelOffsetY:num
 * @text Label Offset Y
 * @parent QteTimingBarWidth:num
 * @desc Offsets the label y position.
 * Negative: up. Positive: down.
 * @default +4
 *
 * @param TimingBarColor1:str
 * @text Timing Bar Color 1
 * @parent QteTimingBarWidth:num
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 6
 *
 * @param TimingBarColor2:str
 * @text Timing Bar Color 2
 * @parent QteTimingBarWidth:num
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 14
 *
 */
/* ----------------------------------------------------------------------------
 * Vocabulary Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Vocab:
 *
 * @param MsgTextAlign:str
 * @text Text Alignment
 * @type select
 * @option left
 * @option center
 * @option right
 * @desc What is the text alignment? Requires VisuMZ_1_MessageCore!
 * Otherwise, defaults to left alignment.
 * @default center
 * 
 * @param Message
 * @text Message Settings
 * 
 * @param ButtonMashTextMsg:json
 * @text Button Mash Text
 * @parent Message
 * @type note
 * @desc Alter the text that appears for the QTE Window.
 * Text codes are supported. Leave empty for no window.
 * @default "Press \\C[27]<OK Button>\\C[0] or \\C[27]Screen Tap\\C[0]\nas many times as you can!"
 * 
 * @param ButtonSeqTextMsg:json
 * @text Button Sequence Text
 * @parent Message
 * @type note
 * @desc Alter the text that appears for the QTE Window.
 * Text codes are supported.
 * @default "Press the above \\C[27]Button Sequence\\c[0] before time runs out!"
 * 
 * @param DirectionStruggleTextMsg:json
 * @text Direction Struggle
 * @parent Message
 * @type note
 * @desc Alter the text that appears for the QTE Window.
 * Text codes are supported. Leave empty for no window.
 * @default "Cycle through \\C[27]<Left Button>\\c[0] \\C[27]<Right Button>\\c[0] \\C[27]<Up Button>\\c[0] \\C[27]<Down Button>\\c[0] buttons\nrepeatedly to fill the above gauge!"
 * 
 * @param FillGaugeTextMsg:json
 * @text Fill Gauge Text
 * @parent Message
 * @type note
 * @desc Alter the text that appears for the QTE Window.
 * Text codes are supported. Leave empty for no window.
 * @default "Press \\C[27]<OK Button>\\C[0] or \\C[27]Screen Tap\\C[0]\nrepeatedly to fill the above gauge!"
 * 
 * @param HoldReleaseTextMsg:json
 * @text Hold & Release Text
 * @parent Message
 * @type note
 * @desc Alter the text that appears for the QTE Window.
 * Text codes are supported. Leave empty for no window.
 * @default "Hold \\C[27]<OK Button>\\C[0] or \\C[27]Press Screen\\C[0] until the\nabove gauge is nearly full, then \\C[27]release\\c[0]!"
 * 
 * @param MarcherTextMsg:json
 * @text Marcher Text
 * @parent Message
 * @type note
 * @desc Alter the text that appears for the QTE Window.
 * Text codes are supported. Leave empty for no window.
 * @default "Alternate between \\C[27]<Page Up Button>\\c[0] and \\C[27]<Page Down Button>\\c[0] buttons\nrepeatedly to fill the above gauge!"
 * 
 * @param SwapperTextMsg:json
 * @text Swapper Text
 * @parent Message
 * @type note
 * @desc Alter the text that appears for the QTE Window.
 * Text codes are supported. Leave empty for no window.
 * @default "Alternate between \\C[27]<OK Button>\\c[0] and \\C[27]<Cancel Button>\\c[0] buttons\nrepeatedly to fill the above gauge!"
 * 
 * @param TimedHitTextMsg:json
 * @text Timed Hit Text
 * @parent Message
 * @type note
 * @desc Alter the text that appears for the QTE Window.
 * Text codes are supported. Leave empty for no window.
 * @default "Press \\C[27]<OK Button>\\C[0] or \\C[27]Screen Tap\\C[0]\nat the right time!"
 * 
 * @param TimedSeqTextMsg:json
 * @text Timed Sequence Text
 * @parent Message
 * @type note
 * @desc Alter the text that appears for the QTE Window.
 * Text codes are supported.
 * @default "Press the \\C[27]Button Sequence\\C[0] at the right time!"
 * 
 * @param TimingBarTextMsg:json
 * @text Timing Bar Text
 * @parent Message
 * @type note
 * @desc Alter the text that appears for the QTE Window.
 * Text codes are supported.
 * @default "Press \\C[27]<OK Button>\\C[0] or \\C[27]Screen Tap\\C[0] to stop the cursor!"
 * 
 * @param MessageWindow
 * @text Message Window
 *
 * @param MsgWindowBgType:num
 * @text Background Type
 * @parent MessageWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 1
 *
 * @param MsgWindowRectJS:func
 * @text JS: X, Y, W, H
 * @parent MessageWindow
 * @type note
 * @desc Code used to determine the position and dimensions for this window.
 * @default "// Declare Lines\nlet lines = 2;\n\n// Declare Dimensions\nlet width = Graphics.width;\nlet height = Scene_Base.prototype.calcWindowHeight(lines);\nlet x = 0;\nlet y = Graphics.height - height;\ny -= Scene_Base.prototype.calcWindowHeight(4, true);\n\n// Return Rectangle\nreturn new Rectangle(x, y, width, height);"
 *
 */
/* ----------------------------------------------------------------------------
 * Sound Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Sound:
 *
 * @param name:str
 * @text Filename
 * @type file
 * @dir audio/se/
 * @require 1
 * @desc Filename of the sound effect played.
 * @default Skill2
 *
 * @param volume:num
 * @text Volume
 * @type number
 * @max 100
 * @desc Volume of the sound effect played.
 * @default 90
 *
 * @param pitch:num
 * @text Pitch
 * @type number
 * @desc Pitch of the sound effect played.
 * @default 100
 *
 * @param pan:num
 * @text Pan
 * @desc Pan of the sound effect played.
 * @default 0
 *
 */
/* ----------------------------------------------------------------------------
 * Hit Zones Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~HitZone:
 *
 * @param HitArea
 * @text Hit Area
 *
 * @param Start:eval
 * @text Start
 * @parent HitArea
 * @desc This is the starting location of the hit area.
 * Use numbers between 0 and 100. You may use code.
 * @default 40
 *
 * @param End:eval
 * @text End
 * @parent HitArea
 * @desc This is the ending location of the hit area.
 * Use numbers between 0 and 100. You may use code.
 * @default 60
 *
 * @param Label:str
 * @text Label
 * @parent HitArea
 * @desc Text displayed for this hit area (centered).
 * Text codes are supported. Leave empty to not use.
 * @default +5
 *
 * @param Mechanics
 * @text Mechanic Settings
 *
 * @param Points:eval
 * @text Variable Points
 * @parent Mechanics
 * @desc If the cursor lands in this zone, then assign this
 * many points to the results variable. You may use code.
 * @default 5
 *
 * @param CommonEventID:num
 * @text Hit Common Event
 * @parent Mechanics
 * @type common_event
 * @desc Select a Common Event to play when this zone is hit.
 * Use 0 to not play a Common Event.
 * @default 0
 *
 * @param Color
 * @text Color Settings
 *
 * @param AreaColor1:str
 * @text Area Color 1
 * @parent Color
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 29
 *
 * @param AreaColor2:str
 * @text Area Color 2
 * @parent Color
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 28
 *
 */
/* ----------------------------------------------------------------------------
 * Timing Sequence Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Timing:
 *
 * @param Button:str
 * @text Button
 * @type select
 * @option 
 * @option down
 * @option left
 * @option right
 * @option up
 * @option 
 * @option ok
 * @option cancel
 * @option pageup
 * @option pagedown
 * @option shift
 * @option 
 * @desc What button is needed to be pressed?
 * @default ok
 * 
 * @param Timing:eval
 * @text Press in X Frames
 * @parent Button:str
 * @desc Press the button by these frames (60 frames = 1 sec)
 * with some leeway. You may use code. 
 * @default 60
 *
 * @param Mechanics
 * @text Mechanic Settings
 * 
 * @param SwitchID:num
 * @text Success Switch ID
 * @parent Mechanics
 * @type switch
 * @desc Select which Switch ID to turn ON if the button is
 * successfully hit. Use 0 to not change a switch.
 * @default 0
 *
 * @param CommonEventID:num
 * @text Hit Common Event
 * @parent Mechanics
 * @type common_event
 * @desc Select a Common Event to play when this button is hit.
 * Use 0 to not play a Common Event.
 * @default 0
 *
 * @param Sound:struct
 * @text Button Press Sound
 * @parent Mechanics
 * @type struct<Sound>
 * @desc Adjust the sound effect played when a button is pressed.
 * @default {"name:str":"Skill2","volume:num":"90","pitch:num":"150","pan:num":"0"}
 *
 */
//=============================================================================

const _0x2ec946=_0x55c2;(function(_0x28bde5,_0x25f7eb){const _0x16a163=_0x55c2,_0x53ef8c=_0x28bde5();while(!![]){try{const _0x445cf8=parseInt(_0x16a163(0x267))/0x1*(-parseInt(_0x16a163(0x285))/0x2)+parseInt(_0x16a163(0x1b5))/0x3+-parseInt(_0x16a163(0x148))/0x4*(-parseInt(_0x16a163(0xfb))/0x5)+parseInt(_0x16a163(0x234))/0x6+parseInt(_0x16a163(0x1ad))/0x7*(parseInt(_0x16a163(0x150))/0x8)+parseInt(_0x16a163(0x247))/0x9*(-parseInt(_0x16a163(0x1f3))/0xa)+-parseInt(_0x16a163(0x11e))/0xb;if(_0x445cf8===_0x25f7eb)break;else _0x53ef8c['push'](_0x53ef8c['shift']());}catch(_0x38c441){_0x53ef8c['push'](_0x53ef8c['shift']());}}}(_0x5584,0xa824a));var label='QTE_TriggerSys',tier=tier||0x0,dependencies=['VisuMZ_0_CoreEngine',_0x2ec946(0x242)],pluginData=$plugins[_0x2ec946(0xe0)](function(_0x3d1e53){const _0x8388c8=_0x2ec946;return _0x3d1e53['status']&&_0x3d1e53['description'][_0x8388c8(0x31b)]('['+label+']');})[0x0];VisuMZ[label]['Settings']=VisuMZ[label][_0x2ec946(0x1c2)]||{},VisuMZ[_0x2ec946(0x253)]=function(_0x35cb34,_0x4cb432){const _0x561fb3=_0x2ec946;for(const _0x537804 in _0x4cb432){if(_0x537804[_0x561fb3(0x2be)](/(.*):(.*)/i)){if(_0x561fb3(0xd1)!==_0x561fb3(0xd1)){if(_0x3a0f66[_0x561fb3(0x2ef)]())return;_0x1bc7f8[_0x561fb3(0x253)](_0xe97fe5,_0x5c3cd4);const _0x4c376b={'type':_0x561fb3(0x15c),'sequence':_0x5275eb[_0x561fb3(0x251)]||[],'progress':0x0,'icon':_0x329b00[_0x561fb3(0x317)]||0x0,'direction':_0x5453e3[_0x561fb3(0x2cb)]||_0x561fb3(0x113),'varID':_0x19c009[_0x561fb3(0x17d)]||0x0,'missCommonEventID':_0x47ae5b[_0x561fb3(0x27d)]||0x0,'missSound':_0x1bc04b[_0x561fb3(0x1dc)]||{'name':'','volume':0x0,'pitch':0x64,'pan':0x0},'inputStartDelay':_0x2300b7[_0x561fb3(0x206)]||0x0,'duration':_0x49474d[_0x561fb3(0x210)]||0x1},_0x136a8d=_0x1cda64[_0x561fb3(0x12b)];_0x4c376b[_0x561fb3(0x2a9)]=_0x4c376b[_0x561fb3(0x2a9)][_0x561fb3(0xe0)](_0x3745d1=>_0x3745d1[_0x561fb3(0x2b0)]!==''),_0x4c376b[_0x561fb3(0x2a9)]=_0x4c376b['sequence']['sort']((_0x119935,_0x42b3d2)=>{const _0x15160e=_0x561fb3;if(_0x119935[_0x15160e(0x2c6)]!==_0x42b3d2[_0x15160e(0x2c6)])return _0x119935[_0x15160e(0x2c6)]-_0x42b3d2[_0x15160e(0x2c6)];return 0x0;}),_0x4c376b['remainingSequence']=_0x4c376b[_0x561fb3(0x2a9)][_0x561fb3(0x32d)](),_0x4c376b['duration']=_0x4c376b[_0x561fb3(0x2a9)][_0x4c376b[_0x561fb3(0x2a9)][_0x561fb3(0x326)]-0x1][_0x561fb3(0x2c6)],_0x4c376b[_0x561fb3(0x30d)]+=_0x216ad7['QTE_TriggerSys'][_0x561fb3(0x1c2)][_0x561fb3(0x207)][_0x561fb3(0x10c)],_0x209783[_0x561fb3(0x2d2)](_0x4c376b);if(_0x136a8d){const _0x447c51=_0x13c36a[_0x561fb3(0x187)]();if(_0x447c51)_0x447c51[_0x561fb3(0x108)](_0x561fb3(0x207));}}else{const _0x372c03=String(RegExp['$1']),_0x24d707=String(RegExp['$2'])['toUpperCase']()[_0x561fb3(0x249)]();let _0x258413,_0x41d110,_0x33ecbc;switch(_0x24d707){case _0x561fb3(0x28c):_0x258413=_0x4cb432[_0x537804]!==''?Number(_0x4cb432[_0x537804]):0x0;break;case _0x561fb3(0x24c):_0x41d110=_0x4cb432[_0x537804]!==''?JSON[_0x561fb3(0x167)](_0x4cb432[_0x537804]):[],_0x258413=_0x41d110[_0x561fb3(0x1d8)](_0x3b4928=>Number(_0x3b4928));break;case _0x561fb3(0xea):_0x258413=_0x4cb432[_0x537804]!==''?eval(_0x4cb432[_0x537804]):null;break;case _0x561fb3(0x240):_0x41d110=_0x4cb432[_0x537804]!==''?JSON[_0x561fb3(0x167)](_0x4cb432[_0x537804]):[],_0x258413=_0x41d110['map'](_0x59eab6=>eval(_0x59eab6));break;case _0x561fb3(0x135):_0x258413=_0x4cb432[_0x537804]!==''?JSON[_0x561fb3(0x167)](_0x4cb432[_0x537804]):'';break;case _0x561fb3(0x1fb):_0x41d110=_0x4cb432[_0x537804]!==''?JSON[_0x561fb3(0x167)](_0x4cb432[_0x537804]):[],_0x258413=_0x41d110['map'](_0x2cbefb=>JSON['parse'](_0x2cbefb));break;case _0x561fb3(0x1f5):_0x258413=_0x4cb432[_0x537804]!==''?new Function(JSON['parse'](_0x4cb432[_0x537804])):new Function(_0x561fb3(0x1d7));break;case _0x561fb3(0xfd):_0x41d110=_0x4cb432[_0x537804]!==''?JSON[_0x561fb3(0x167)](_0x4cb432[_0x537804]):[],_0x258413=_0x41d110[_0x561fb3(0x1d8)](_0x3addf9=>new Function(JSON[_0x561fb3(0x167)](_0x3addf9)));break;case'STR':_0x258413=_0x4cb432[_0x537804]!==''?String(_0x4cb432[_0x537804]):'';break;case _0x561fb3(0x1f0):_0x41d110=_0x4cb432[_0x537804]!==''?JSON['parse'](_0x4cb432[_0x537804]):[],_0x258413=_0x41d110[_0x561fb3(0x1d8)](_0x478b39=>String(_0x478b39));break;case'STRUCT':_0x33ecbc=_0x4cb432[_0x537804]!==''?JSON[_0x561fb3(0x167)](_0x4cb432[_0x537804]):{},_0x258413=VisuMZ[_0x561fb3(0x253)]({},_0x33ecbc);break;case'ARRAYSTRUCT':_0x41d110=_0x4cb432[_0x537804]!==''?JSON[_0x561fb3(0x167)](_0x4cb432[_0x537804]):[],_0x258413=_0x41d110[_0x561fb3(0x1d8)](_0x277ef3=>VisuMZ[_0x561fb3(0x253)]({},JSON[_0x561fb3(0x167)](_0x277ef3)));break;default:continue;}_0x35cb34[_0x372c03]=_0x258413;}}}return _0x35cb34;},(_0x4b90b8=>{const _0x3210bb=_0x2ec946,_0x88ddc3=_0x4b90b8['name'];for(const _0x548495 of dependencies){if(!Imported[_0x548495]){alert(_0x3210bb(0x24d)['format'](_0x88ddc3,_0x548495)),SceneManager[_0x3210bb(0x23b)]();break;}}const _0x4b7170=_0x4b90b8[_0x3210bb(0x168)];if(_0x4b7170[_0x3210bb(0x2be)](/\[Version[ ](.*?)\]/i)){const _0x3ed5f9=Number(RegExp['$1']);_0x3ed5f9!==VisuMZ[label][_0x3210bb(0xfe)]&&(alert(_0x3210bb(0x199)[_0x3210bb(0x1dd)](_0x88ddc3,_0x3ed5f9)),SceneManager[_0x3210bb(0x23b)]());}if(_0x4b7170[_0x3210bb(0x2be)](/\[Tier[ ](\d+)\]/i)){const _0x1ad2f3=Number(RegExp['$1']);_0x1ad2f3<tier?(alert(_0x3210bb(0x189)[_0x3210bb(0x1dd)](_0x88ddc3,_0x1ad2f3,tier)),SceneManager[_0x3210bb(0x23b)]()):tier=Math[_0x3210bb(0x202)](_0x1ad2f3,tier);}VisuMZ['ConvertParams'](VisuMZ[label][_0x3210bb(0x1c2)],_0x4b90b8[_0x3210bb(0x15e)]);})(pluginData);if(VisuMZ['CoreEngine'][_0x2ec946(0xfe)]<1.79){let text='';text+=_0x2ec946(0x12e),text+=_0x2ec946(0x22f),alert(text),SceneManager[_0x2ec946(0x23b)]();}if(VisuMZ[_0x2ec946(0x32b)][_0x2ec946(0xfe)]<1.5){let text='';text+=_0x2ec946(0x263),text+='in\x20order\x20for\x20VisuMZ_2_QTE_TriggerSys\x20to\x20work.',alert(text),SceneManager[_0x2ec946(0x23b)]();}PluginManager[_0x2ec946(0x2b9)](pluginData['name'],_0x2ec946(0x209),_0x466a29=>{const _0x46ec63=_0x2ec946;VisuMZ['ConvertParams'](_0x466a29,_0x466a29);const _0x1e2050=_0x466a29[_0x46ec63(0x27c)]||0x0;$gameSystem['setGameOverCommonEventID'](_0x1e2050);}),PluginManager[_0x2ec946(0x2b9)](pluginData['name'],'GameOverCommonEventClear',_0x1f21cd=>{const _0x51b5a0=_0x2ec946;VisuMZ[_0x51b5a0(0x253)](_0x1f21cd,_0x1f21cd),$gameSystem['setGameOverCommonEventID'](0x0);}),PluginManager[_0x2ec946(0x2b9)](pluginData[_0x2ec946(0x154)],_0x2ec946(0x282),_0x132557=>{const _0x3a554c=_0x2ec946;VisuMZ[_0x3a554c(0x253)](_0x132557,_0x132557);const _0x3f7e4f=_0x132557[_0x3a554c(0x21c)]||0x0;if(_0x3f7e4f<=0x0)return;const _0x3d42b0=_0x132557[_0x3a554c(0x30e)]||[],_0x1c8b09='switches';$gameSystem[_0x3a554c(0x229)](_0x1c8b09,_0x3f7e4f,_0x3d42b0);}),PluginManager[_0x2ec946(0x2b9)](pluginData[_0x2ec946(0x154)],_0x2ec946(0x218),_0x24d9a2=>{const _0x21c2a5=_0x2ec946;VisuMZ[_0x21c2a5(0x253)](_0x24d9a2,_0x24d9a2);const _0x20e810=_0x24d9a2[_0x21c2a5(0x21c)]||0x0;if(_0x20e810<=0x0)return;const _0x261bce=_0x24d9a2[_0x21c2a5(0x30e)]||[],_0x284920=_0x21c2a5(0x2cc);$gameSystem[_0x21c2a5(0x229)](_0x284920,_0x20e810,_0x261bce);}),PluginManager[_0x2ec946(0x2b9)](pluginData[_0x2ec946(0x154)],_0x2ec946(0x227),_0xbf9b01=>{const _0x5c5d83=_0x2ec946;VisuMZ[_0x5c5d83(0x253)](_0xbf9b01,_0xbf9b01);const _0x5e78f=_0xbf9b01[_0x5c5d83(0x21c)]||0x0;if(_0x5e78f<=0x0)return;const _0x47fdb6=_0xbf9b01[_0x5c5d83(0x30e)]||[],_0x25477f=_0x5c5d83(0x1be);$gameSystem[_0x5c5d83(0x229)](_0x25477f,_0x5e78f,_0x47fdb6);}),PluginManager[_0x2ec946(0x2b9)](pluginData[_0x2ec946(0x154)],'PromiseWeapon',_0xe5d06a=>{const _0x18ed73=_0x2ec946;VisuMZ[_0x18ed73(0x253)](_0xe5d06a,_0xe5d06a);const _0x16c944=_0xe5d06a[_0x18ed73(0x21c)]||0x0;if(_0x16c944<=0x0)return;const _0x1b54a7=_0xe5d06a[_0x18ed73(0x30e)]||[],_0x4ae186='weapons';$gameSystem['addQTE_TriggerSysPromiseToSet'](_0x4ae186,_0x16c944,_0x1b54a7);}),PluginManager[_0x2ec946(0x2b9)](pluginData['name'],_0x2ec946(0x2b4),_0x211af7=>{const _0x508b2a=_0x2ec946;VisuMZ[_0x508b2a(0x253)](_0x211af7,_0x211af7);const _0x1958d7=_0x211af7['dataID']||0x0;if(_0x1958d7<=0x0)return;const _0xbd1de8=_0x211af7[_0x508b2a(0x30e)]||[],_0x1a41ef='armors';$gameSystem['addQTE_TriggerSysPromiseToSet'](_0x1a41ef,_0x1958d7,_0xbd1de8);}),PluginManager[_0x2ec946(0x2b9)](pluginData[_0x2ec946(0x154)],_0x2ec946(0x26d),_0x1bcc6b=>{const _0x350f42=_0x2ec946;if(SceneManager[_0x350f42(0x2ef)]())return;VisuMZ[_0x350f42(0x253)](_0x1bcc6b,_0x1bcc6b);const _0x44c5bb={'type':_0x350f42(0x19d),'varID':_0x1bcc6b['VariableID']||0x0,'commonEventID':_0x1bcc6b['CommonEventID']||0x0,'sound':_0x1bcc6b['Sound']||{'name':'','volume':0x0,'pitch':0x64,'pan':0x0},'inputStartDelay':_0x1bcc6b['InputStartDelay']||0x0,'duration':(_0x1bcc6b[_0x350f42(0x210)]||0x1)[_0x350f42(0x196)](0x1,0xf423f)},_0x4a2747=_0x1bcc6b['WaitForQTE'];SceneManager[_0x350f42(0x2d2)](_0x44c5bb);if(_0x4a2747){if('AyZMD'!==_0x350f42(0x1df)){const _0x2e01a3=$gameTemp[_0x350f42(0x187)]();if(_0x2e01a3)_0x2e01a3[_0x350f42(0x108)](_0x350f42(0x207));}else return _0x5710d0['status']&&_0x1677e8[_0x350f42(0x168)][_0x350f42(0x31b)]('['+_0x408cb9+']');}}),PluginManager['registerCommand'](pluginData[_0x2ec946(0x154)],_0x2ec946(0x123),_0x11a5f7=>{const _0xcbc18d=_0x2ec946;if(SceneManager[_0xcbc18d(0x2ef)]())return;VisuMZ[_0xcbc18d(0x253)](_0x11a5f7,_0x11a5f7);const _0x5cf273={'type':_0xcbc18d(0x178),'sequence':(_0x11a5f7[_0xcbc18d(0x280)]||[])['clone'](),'shuffle':_0x11a5f7['Shuffle']||![],'progress':0x0,'switchID':_0x11a5f7[_0xcbc18d(0x293)]||0x0,'varID':_0x11a5f7['VariableID']||0x0,'commonEventID':_0x11a5f7[_0xcbc18d(0x27c)]||0x0,'sound':_0x11a5f7[_0xcbc18d(0x314)]||{'name':'','volume':0x0,'pitch':0x64,'pan':0x0},'inputStartDelay':_0x11a5f7[_0xcbc18d(0x206)]||0x0,'duration':_0x11a5f7[_0xcbc18d(0x210)]||0x1},_0x233180=_0x11a5f7[_0xcbc18d(0x12b)];_0x5cf273[_0xcbc18d(0x181)]&&(_0x5cf273[_0xcbc18d(0x2a9)]=VisuMZ[_0xcbc18d(0x310)][_0xcbc18d(0xf0)](_0x5cf273[_0xcbc18d(0x2a9)]));SceneManager[_0xcbc18d(0x2d2)](_0x5cf273);if(_0x233180){if(_0xcbc18d(0x27f)!==_0xcbc18d(0x22e)){const _0xa9bde4=$gameTemp['getLastPluginCommandInterpreter']();if(_0xa9bde4)_0xa9bde4['setWaitMode']('QTE');}else this['anchor']['x']=0.5,this['anchor']['y']=0x1,this[_0xcbc18d(0x129)]=_0x331536[_0xcbc18d(0x23e)][_0xcbc18d(0xde)]||0x1,this[_0xcbc18d(0x144)]=0x0,this[_0xcbc18d(0x25a)]=0x1;}}),PluginManager[_0x2ec946(0x2b9)](pluginData[_0x2ec946(0x154)],_0x2ec946(0x216),_0x4e637b=>{const _0x35190a=_0x2ec946;if(SceneManager[_0x35190a(0x2ef)]())return;VisuMZ[_0x35190a(0x253)](_0x4e637b,_0x4e637b);const _0x5d1849={'type':_0x35190a(0x178),'buttons':(_0x4e637b[_0x35190a(0x1b8)]||[])[_0x35190a(0x193)]('')[_0x35190a(0x32d)](),'sequence':[],'length':_0x4e637b['SequenceLength']||0x1,'progress':0x0,'switchID':_0x4e637b[_0x35190a(0x293)]||0x0,'varID':_0x4e637b[_0x35190a(0x17d)]||0x0,'commonEventID':_0x4e637b[_0x35190a(0x27c)]||0x0,'sound':_0x4e637b['Sound']||{'name':'','volume':0x0,'pitch':0x64,'pan':0x0},'inputStartDelay':_0x4e637b[_0x35190a(0x206)]||0x0,'duration':_0x4e637b['Duration']||0x1},_0x1bcf7e=_0x4e637b[_0x35190a(0x12b)];let _0x35e261=_0x5d1849[_0x35190a(0x326)];while(_0x35e261--){const _0x28b3fc=_0x5d1849[_0x35190a(0x2dd)][Math[_0x35190a(0x1e0)](_0x5d1849['buttons'][_0x35190a(0x326)])];_0x5d1849[_0x35190a(0x2a9)]['push'](_0x28b3fc||'ok');}SceneManager[_0x35190a(0x2d2)](_0x5d1849);if(_0x1bcf7e){const _0x3ce8a8=$gameTemp[_0x35190a(0x187)]();if(_0x3ce8a8)_0x3ce8a8[_0x35190a(0x108)](_0x35190a(0x207));}}),PluginManager['registerCommand'](pluginData[_0x2ec946(0x154)],_0x2ec946(0x302),_0x9bcd64=>{const _0x260f86=_0x2ec946;if(SceneManager[_0x260f86(0x2ef)]())return;VisuMZ[_0x260f86(0x253)](_0x9bcd64,_0x9bcd64);const _0x296d13={'type':_0x260f86(0x2f2),'goal':_0x9bcd64[_0x260f86(0x1d9)]||0x1,'progress':0x0,'switchID':_0x9bcd64['SwitchID']||0x0,'varID':_0x9bcd64[_0x260f86(0x17d)]||0x0,'commonEventID':_0x9bcd64[_0x260f86(0x27c)]||0x0,'sound':_0x9bcd64[_0x260f86(0x314)]||{'name':'','volume':0x0,'pitch':0x64,'pan':0x0},'inputStartDelay':_0x9bcd64[_0x260f86(0x206)]||0x0,'duration':_0x9bcd64['Duration']||0x1},_0x429db9=_0x9bcd64[_0x260f86(0x12b)];SceneManager[_0x260f86(0x2d2)](_0x296d13);if(_0x429db9){const _0x147d99=$gameTemp[_0x260f86(0x187)]();if(_0x147d99)_0x147d99[_0x260f86(0x108)](_0x260f86(0x207));}}),PluginManager[_0x2ec946(0x2b9)](pluginData['name'],_0x2ec946(0x283),_0x43b16c=>{const _0x19caa1=_0x2ec946;if(SceneManager[_0x19caa1(0x2ef)]())return;VisuMZ[_0x19caa1(0x253)](_0x43b16c,_0x43b16c);const _0x1d1dfc={'type':'fillGauge','goal':_0x43b16c['FillRequirement']||0x1,'progress':0x0,'switchID':_0x43b16c[_0x19caa1(0x293)]||0x0,'varID':_0x43b16c[_0x19caa1(0x17d)]||0x0,'commonEventID':_0x43b16c[_0x19caa1(0x27c)]||0x0,'sound':_0x43b16c[_0x19caa1(0x314)]||{'name':'','volume':0x0,'pitch':0x64,'pan':0x0},'inputStartDelay':_0x43b16c[_0x19caa1(0x206)]||0x0,'duration':_0x43b16c['Duration']||0x1},_0x33c26d=_0x43b16c['WaitForQTE'];SceneManager['setupQTE'](_0x1d1dfc);if(_0x33c26d){if(_0x19caa1(0x141)===_0x19caa1(0x2d8))_0x1ce1bb[_0x19caa1(0x14d)](_0x891c52);else{const _0x18f9ff=$gameTemp[_0x19caa1(0x187)]();if(_0x18f9ff)_0x18f9ff[_0x19caa1(0x108)](_0x19caa1(0x207));}}}),PluginManager[_0x2ec946(0x2b9)](pluginData['name'],_0x2ec946(0x2da),_0x559deb=>{const _0x395e38=_0x2ec946;if(SceneManager['checkPlayingQTE']())return;VisuMZ[_0x395e38(0x253)](_0x559deb,_0x559deb);const _0x546178={'type':_0x395e38(0x1bf),'goal':(_0x559deb[_0x395e38(0x235)]||0x1)[_0x395e38(0x196)](0x1,0xf423f),'progress':0x0,'switchID':_0x559deb[_0x395e38(0x293)]||0x0,'varID':_0x559deb[_0x395e38(0x17d)]||0x0,'releaseSound':_0x559deb[_0x395e38(0x1ce)]||{'name':'','volume':0x0,'pitch':0x64,'pan':0x0},'overloadSound':_0x559deb[_0x395e38(0x110)]||{'name':'','volume':0x0,'pitch':0x64,'pan':0x0},'inputStartDelay':_0x559deb[_0x395e38(0x206)]||0x0,'duration':0x1f40},_0x3de134=_0x559deb[_0x395e38(0x12b)];SceneManager[_0x395e38(0x2d2)](_0x546178);if(_0x3de134){const _0x322086=$gameTemp[_0x395e38(0x187)]();if(_0x322086)_0x322086[_0x395e38(0x108)]('QTE');}}),PluginManager['registerCommand'](pluginData[_0x2ec946(0x154)],_0x2ec946(0x33b),_0xd4d6e6=>{const _0x59f117=_0x2ec946;if(SceneManager[_0x59f117(0x2ef)]())return;VisuMZ[_0x59f117(0x253)](_0xd4d6e6,_0xd4d6e6);const _0x5b794b={'type':'marcher','goal':_0xd4d6e6['ToggleRequirement']||0x1,'progress':0x0,'switchID':_0xd4d6e6[_0x59f117(0x293)]||0x0,'varID':_0xd4d6e6['VariableID']||0x0,'pageUpCommonEventID':_0xd4d6e6[_0x59f117(0x17b)]||0x0,'pageDownCommonEventID':_0xd4d6e6[_0x59f117(0x147)]||0x0,'sound':_0xd4d6e6[_0x59f117(0x314)]||{'name':'','volume':0x0,'pitch':0x64,'pan':0x0},'inputStartDelay':_0xd4d6e6[_0x59f117(0x206)]||0x0,'duration':_0xd4d6e6[_0x59f117(0x210)]||0x1},_0x20c5ca=_0xd4d6e6[_0x59f117(0x12b)];SceneManager[_0x59f117(0x2d2)](_0x5b794b);if(_0x20c5ca){const _0x2f0fed=$gameTemp['getLastPluginCommandInterpreter']();if(_0x2f0fed)_0x2f0fed['setWaitMode'](_0x59f117(0x207));}}),PluginManager[_0x2ec946(0x2b9)](pluginData[_0x2ec946(0x154)],'QTE_Swapper',_0x1d447d=>{const _0x1ff394=_0x2ec946;if(SceneManager[_0x1ff394(0x2ef)]())return;VisuMZ[_0x1ff394(0x253)](_0x1d447d,_0x1d447d);const _0x2a85c9={'type':'swapper','goal':_0x1d447d[_0x1ff394(0x279)]||0x1,'progress':0x0,'switchID':_0x1d447d[_0x1ff394(0x293)]||0x0,'varID':_0x1d447d[_0x1ff394(0x17d)]||0x0,'okCommonEventID':_0x1d447d[_0x1ff394(0x311)]||0x0,'cancelCommonEventID':_0x1d447d[_0x1ff394(0x19b)]||0x0,'sound':_0x1d447d['Sound']||{'name':'','volume':0x0,'pitch':0x64,'pan':0x0},'inputStartDelay':_0x1d447d[_0x1ff394(0x206)]||0x0,'duration':_0x1d447d[_0x1ff394(0x210)]||0x1},_0x976eee=_0x1d447d[_0x1ff394(0x12b)];SceneManager[_0x1ff394(0x2d2)](_0x2a85c9);if(_0x976eee){if(_0x1ff394(0x1e2)===_0x1ff394(0x1e2)){const _0x3f3156=$gameTemp[_0x1ff394(0x187)]();if(_0x3f3156)_0x3f3156[_0x1ff394(0x108)](_0x1ff394(0x207));}else{if(_0x2c758a[_0x1ff394(0x22d)]())return;this[_0x1ff394(0x157)]&&(this[_0x1ff394(0x262)](this[_0x1ff394(0x157)]),this[_0x1ff394(0x157)]=_0x201775),this['_qteProgressWindow']&&(this[_0x1ff394(0x262)](this['_qteProgressWindow']),this[_0x1ff394(0x1a7)]=_0x4b65d4),this[_0x1ff394(0x33a)]&&(this['_qteTimedHitSprite'][_0x1ff394(0x120)](),this['_qteTimedHitSprite']=_0x9666a1);}}}),PluginManager[_0x2ec946(0x2b9)](pluginData['name'],_0x2ec946(0x340),_0x5d296f=>{const _0x240883=_0x2ec946;if(SceneManager['checkPlayingQTE']())return;VisuMZ[_0x240883(0x253)](_0x5d296f,_0x5d296f);const _0x14fd3a={'type':_0x240883(0x208),'picture':_0x5d296f[_0x240883(0xe1)]||'','pointX':_0x5d296f[_0x240883(0x16a)]||0x0,'pointY':_0x5d296f['pointY']||0x0,'switchID':_0x5d296f[_0x240883(0x293)]||0x0,'varID':_0x5d296f['VariableID']||0x0,'hitCommonEventID':_0x5d296f[_0x240883(0x177)]||0x0,'hitSound':_0x5d296f['HitSound']||{'name':'','volume':0x0,'pitch':0x64,'pan':0x0},'missCommonEventID':_0x5d296f[_0x240883(0x27d)]||0x0,'missSound':_0x5d296f[_0x240883(0x1dc)]||{'name':'','volume':0x0,'pitch':0x64,'pan':0x0},'inputStartDelay':_0x5d296f['InputStartDelay']||0x0,'duration':_0x5d296f[_0x240883(0x210)]||0x1},_0x4f7659=_0x5d296f['WaitForQTE'];_0x14fd3a[_0x240883(0x215)]['toUpperCase']()['trim']()===_0x240883(0x1bc)&&(_0x14fd3a['picture']='');SceneManager[_0x240883(0x2d2)](_0x14fd3a);if(_0x4f7659){if(_0x240883(0x1af)==='nBLiW'){const _0x13cf01=$gameTemp[_0x240883(0x187)]();if(_0x13cf01)_0x13cf01['setWaitMode'](_0x240883(0x207));}else{const _0x2319ba=new _0x404e4c(_0x31fe93);this[_0x240883(0x1e3)][_0x2fc75b['id']][_0x240883(0x175)](_0x2319ba),_0x16686d='';}}}),PluginManager[_0x2ec946(0x2b9)](pluginData[_0x2ec946(0x154)],_0x2ec946(0xcf),_0x3de599=>{const _0x477851=_0x2ec946;if(SceneManager[_0x477851(0x2ef)]())return;VisuMZ[_0x477851(0x253)](_0x3de599,_0x3de599);const _0x378e9b={'type':_0x477851(0x15c),'sequence':_0x3de599[_0x477851(0x251)]||[],'progress':0x0,'icon':_0x3de599[_0x477851(0x317)]||0x0,'direction':_0x3de599[_0x477851(0x2cb)]||_0x477851(0x113),'varID':_0x3de599['VariableID']||0x0,'missCommonEventID':_0x3de599[_0x477851(0x27d)]||0x0,'missSound':_0x3de599[_0x477851(0x1dc)]||{'name':'','volume':0x0,'pitch':0x64,'pan':0x0},'inputStartDelay':_0x3de599[_0x477851(0x206)]||0x0,'duration':_0x3de599[_0x477851(0x210)]||0x1},_0x423bec=_0x3de599[_0x477851(0x12b)];_0x378e9b[_0x477851(0x2a9)]=_0x378e9b['sequence'][_0x477851(0xe0)](_0x3c75ac=>_0x3c75ac[_0x477851(0x2b0)]!==''),_0x378e9b[_0x477851(0x2a9)]=_0x378e9b[_0x477851(0x2a9)][_0x477851(0x2af)]((_0x2c1a3a,_0x3997b5)=>{const _0x54901a=_0x477851;if(_0x2c1a3a[_0x54901a(0x2c6)]!==_0x3997b5[_0x54901a(0x2c6)])return _0x2c1a3a[_0x54901a(0x2c6)]-_0x3997b5[_0x54901a(0x2c6)];return 0x0;}),_0x378e9b['remainingSequence']=_0x378e9b[_0x477851(0x2a9)][_0x477851(0x32d)](),_0x378e9b['duration']=_0x378e9b[_0x477851(0x2a9)][_0x378e9b[_0x477851(0x2a9)][_0x477851(0x326)]-0x1][_0x477851(0x2c6)],_0x378e9b[_0x477851(0x30d)]+=VisuMZ['QTE_TriggerSys']['Settings'][_0x477851(0x207)][_0x477851(0x10c)],SceneManager[_0x477851(0x2d2)](_0x378e9b);if(_0x423bec){if(_0x477851(0xca)===_0x477851(0x297))this['fulfillOnTriggerPromises'](_0x477851(0x1be),_0x1da02e['id']);else{const _0x2b9318=$gameTemp[_0x477851(0x187)]();if(_0x2b9318)_0x2b9318[_0x477851(0x108)](_0x477851(0x207));}}}),PluginManager['registerCommand'](pluginData[_0x2ec946(0x154)],'QTE_TimingBar',_0x41e720=>{const _0x3f8267=_0x2ec946;if(SceneManager[_0x3f8267(0x2ef)]())return;VisuMZ[_0x3f8267(0x253)](_0x41e720,_0x41e720);const _0x3fdb70={'type':'timingBar','zones':_0x41e720[_0x3f8267(0x2c7)]||[],'cursorIcon':_0x41e720[_0x3f8267(0x271)]||0x0,'cursorSpeed':_0x41e720['CursorSpeed']||0x1,'switchID':_0x41e720[_0x3f8267(0x293)]||0x0,'varID':_0x41e720[_0x3f8267(0x17d)]||0x0,'hitSound':_0x41e720[_0x3f8267(0x176)]||{'name':'','volume':0x0,'pitch':0x64,'pan':0x0},'missSound':_0x41e720[_0x3f8267(0x1dc)]||{'name':'','volume':0x0,'pitch':0x64,'pan':0x0},'missCommonEventID':_0x41e720['MissCommonEventID']||0x0,'inputStartDelay':_0x41e720[_0x3f8267(0x206)]||0x0,'duration':_0x41e720[_0x3f8267(0x210)]||0x1},_0x5854a8=_0x41e720[_0x3f8267(0x12b)];SceneManager[_0x3f8267(0x2d2)](_0x3fdb70);if(_0x5854a8){const _0x1a4f00=$gameTemp[_0x3f8267(0x187)]();if(_0x1a4f00)_0x1a4f00['setWaitMode']('QTE');}}),VisuMZ[_0x2ec946(0x310)][_0x2ec946(0x23d)]={'OnChange':/<(?:|TOGGLE |CHANGE )TRIGGER COMMON EVENT(?:|S):[ ](.*?)>/gi,'OnSwitch':/<TRIGGER ON SW(?:|ITCH)(?:|ES):[ ](.*?)>/gi,'OnVariable':/<TRIGGER ON VAR(?:|IABLE)(?:|S):[ ](.*?)>/gi,'gameOverCommonEvent':/<GAME OVER COMMON EVENT:[ ](\d+)>/i},VisuMZ[_0x2ec946(0x310)][_0x2ec946(0x236)]=Scene_Boot[_0x2ec946(0x28a)][_0x2ec946(0x1e4)],Scene_Boot[_0x2ec946(0x28a)]['onDatabaseLoaded']=function(){const _0x540910=_0x2ec946;VisuMZ['QTE_TriggerSys'][_0x540910(0x236)][_0x540910(0xf1)](this),VisuMZ[_0x540910(0x310)][_0x540910(0xec)](),VisuMZ[_0x540910(0x310)]['CheckCompatibility']();},VisuMZ[_0x2ec946(0x310)][_0x2ec946(0x2c2)]=function(){const _0x2a0caa=_0x2ec946;if(Imported['VisuMZ_2_ExtMessageFunc']&&VisuMZ[_0x2a0caa(0xfc)][_0x2a0caa(0xfe)]<1.15){if(_0x2a0caa(0x1cf)==='DxyWV')_0x274c66[_0x2a0caa(0x26b)]++;else{let _0x54b10b='';_0x54b10b+=_0x2a0caa(0x1b7),_0x54b10b+=_0x2a0caa(0x22f),alert(_0x54b10b),SceneManager[_0x2a0caa(0x23b)]();}}},VisuMZ[_0x2ec946(0x310)][_0x2ec946(0x1d4)]={},VisuMZ[_0x2ec946(0x310)]['_triggerVariables']={},0x3,VisuMZ['QTE_TriggerSys'][_0x2ec946(0x190)]=[],VisuMZ[_0x2ec946(0x310)]['_jsCommonEvents']=[],VisuMZ[_0x2ec946(0x310)][_0x2ec946(0x1e3)]={},VisuMZ[_0x2ec946(0x310)][_0x2ec946(0x327)]={},VisuMZ[_0x2ec946(0x310)][_0x2ec946(0x25e)]={},VisuMZ[_0x2ec946(0x310)]['registerData']=function(){const _0x181869=_0x2ec946;this['registerSwitches'](),this[_0x181869(0x277)](),this[_0x181869(0xf5)]();},VisuMZ[_0x2ec946(0x310)][_0x2ec946(0x21f)]=function(){const _0x9c082f=_0x2ec946,_0x29b6ba=$dataSystem[_0x9c082f(0x126)],_0x2f15ff=_0x29b6ba['length'],_0x485daa=VisuMZ['QTE_TriggerSys']['RegExp'];for(let _0x4a8b51=0x1;_0x4a8b51<_0x2f15ff;_0x4a8b51++){const _0x295fda=_0x29b6ba[_0x4a8b51]||'';if(_0x295fda[_0x9c082f(0x2be)](_0x485daa[_0x9c082f(0x2c3)])){const _0x49c48b=String(RegExp['$1'])['split'](',')[_0x9c082f(0x1d8)](_0xb2a628=>Number(_0xb2a628));this[_0x9c082f(0x1d4)][_0x4a8b51]=this['_triggerSwitches'][_0x4a8b51]||[];for(const _0x96b548 of _0x49c48b){if(_0x9c082f(0x224)!==_0x9c082f(0xe7))this[_0x9c082f(0x1d4)][_0x4a8b51]['push'](_0x96b548);else{if(_0x171dab[_0x9c082f(0x2ef)]())return;_0x56a279[_0x9c082f(0x253)](_0x2f740b,_0x443b6a);const _0x26cfe7={'type':_0x9c082f(0x309),'goal':_0x1763e8['FillRequirement']||0x1,'progress':0x0,'switchID':_0x2fcb97[_0x9c082f(0x293)]||0x0,'varID':_0x59253f[_0x9c082f(0x17d)]||0x0,'commonEventID':_0x5f243e[_0x9c082f(0x27c)]||0x0,'sound':_0x291caa[_0x9c082f(0x314)]||{'name':'','volume':0x0,'pitch':0x64,'pan':0x0},'inputStartDelay':_0x64d86[_0x9c082f(0x206)]||0x0,'duration':_0xad6953[_0x9c082f(0x210)]||0x1},_0x46f085=_0x5c1d00[_0x9c082f(0x12b)];_0x7688[_0x9c082f(0x2d2)](_0x26cfe7);if(_0x46f085){const _0x279a52=_0x1afc3b[_0x9c082f(0x187)]();if(_0x279a52)_0x279a52[_0x9c082f(0x108)](_0x9c082f(0x207));}}}DataManager[_0x9c082f(0x1f1)](_0x4a8b51)&&(VisuMZ[_0x9c082f(0x310)][_0x9c082f(0x327)][_0x4a8b51]=![]),$dataSystem['switches'][_0x4a8b51]=_0x295fda[_0x9c082f(0x1f8)](_0x485daa[_0x9c082f(0x2c3)],'');}}},VisuMZ[_0x2ec946(0x310)]['registerVariables']=function(){const _0x1bdfc0=_0x2ec946,_0x4f5b3e=$dataSystem[_0x1bdfc0(0x2cc)],_0x53fd95=_0x4f5b3e[_0x1bdfc0(0x326)],_0x3466c5=VisuMZ[_0x1bdfc0(0x310)][_0x1bdfc0(0x23d)];for(let _0x4ad423=0x1;_0x4ad423<_0x53fd95;_0x4ad423++){const _0x5790de=_0x4f5b3e[_0x4ad423]||'';if(_0x5790de['match'](_0x3466c5['OnChange'])){if(_0x1bdfc0(0x10a)!==_0x1bdfc0(0x1d5)){const _0x12de1e=String(RegExp['$1'])[_0x1bdfc0(0x2e2)](',')[_0x1bdfc0(0x1d8)](_0x21a643=>Number(_0x21a643));this[_0x1bdfc0(0x28f)][_0x4ad423]=this[_0x1bdfc0(0x28f)][_0x4ad423]||[];for(const _0x59a915 of _0x12de1e){_0x1bdfc0(0x2ed)===_0x1bdfc0(0x2ed)?this[_0x1bdfc0(0x28f)][_0x4ad423]['push'](_0x59a915):this[_0x1bdfc0(0x18a)](...arguments);}DataManager['isTriggerWatchedVariable'](_0x4ad423)&&(_0x1bdfc0(0x195)!==_0x1bdfc0(0xd3)?VisuMZ[_0x1bdfc0(0x310)]['_watchedJsVariables'][_0x4ad423]=0x0:_0x1b872c[_0x1bdfc0(0x31a)](_0xe07887,_0x4222b1[_0x1bdfc0(0x26b)]>0x0)),$dataSystem[_0x1bdfc0(0x2cc)][_0x4ad423]=_0x5790de[_0x1bdfc0(0x1f8)](_0x3466c5[_0x1bdfc0(0x2c3)],'');}else this[_0x1bdfc0(0x1fa)](),this['init_QTE_TriggerSysPromise']();}}},VisuMZ[_0x2ec946(0x310)]['registerCommonEvents']=function(){const _0x5e367c=_0x2ec946;for(const _0x3917e4 of $dataCommonEvents){if(!_0x3917e4)continue;this[_0x5e367c(0x10f)](_0x3917e4),delete _0x3917e4[_0x5e367c(0x248)];}},VisuMZ[_0x2ec946(0x310)][_0x2ec946(0x10f)]=function(_0x362b8f){const _0x254997=_0x2ec946,_0x2932e6=VisuMZ[_0x254997(0x310)]['RegExp'];let _0x2a37b0=_0x362b8f[_0x254997(0x154)]||'';const _0x7bcf2a=_0x362b8f['id']||0x0;if(_0x2a37b0['match'](_0x2932e6['OnSwitch'])){const _0x4b3b44=String(RegExp['$1'])[_0x254997(0x2e2)](',')[_0x254997(0x1d8)](_0x2145ed=>Number(_0x2145ed));for(const _0x390ddf of _0x4b3b44){if(_0x254997(0x114)!==_0x254997(0x114)){const _0x269a40=this['_qteSettings'],_0x282318=_0x269a40['varID']||0x0;if(_0x282318>0x0){const _0x24777d=_0x51c281[_0x254997(0x1d0)](_0x282318);_0x4361d8[_0x254997(0x31a)](_0x282318,_0x24777d+0x1);}const _0x24b960=_0x269a40['commonEventID']||0x0;_0x24b960>0x0&&_0x3469a9(_0x24b960);const _0x333be5=_0x269a40[_0x254997(0x142)];_0x333be5&&_0x333be5[_0x254997(0x154)]&&_0x8247d7['playSe'](_0x333be5);}else{this[_0x254997(0x1d4)][_0x390ddf]=this[_0x254997(0x1d4)][_0x390ddf]||[];if(this['_triggerSwitches'][_0x390ddf][_0x254997(0x31b)](_0x7bcf2a))continue;this[_0x254997(0x1d4)][_0x390ddf]['push'](_0x7bcf2a),DataManager['isTriggerWatchedSwitch'](_0x390ddf)&&(VisuMZ[_0x254997(0x310)]['_watchedJsSwitches'][_0x390ddf]=![]);}}_0x2a37b0=_0x2a37b0['replace'](_0x2932e6[_0x254997(0x146)],'');}if(_0x2a37b0['match'](_0x2932e6['OnVariable'])){const _0x5d8b1b=String(RegExp['$1'])[_0x254997(0x2e2)](',')[_0x254997(0x1d8)](_0x4e5f04=>Number(_0x4e5f04));for(const _0xde96c2 of _0x5d8b1b){if('dfTvL'!==_0x254997(0x24b))_0x4b67e3[_0x254997(0x14d)](_0x40e4a4);else{this[_0x254997(0x28f)][_0xde96c2]=this[_0x254997(0x28f)][_0xde96c2]||[];if(this[_0x254997(0x28f)][_0xde96c2][_0x254997(0x31b)](_0x7bcf2a))continue;this[_0x254997(0x28f)][_0xde96c2]['push'](_0x7bcf2a),DataManager[_0x254997(0x281)](_0xde96c2)&&(VisuMZ[_0x254997(0x310)][_0x254997(0x25e)][_0xde96c2]=0x0);}}_0x2a37b0=_0x2a37b0['replace'](_0x2932e6[_0x254997(0xdd)],'');}_0x362b8f[_0x254997(0x154)]=_0x2a37b0[_0x254997(0x249)]();},VisuMZ[_0x2ec946(0x310)]['defineCommonEventType']=function(_0x51d0e8){const _0x4731c8=_0x2ec946;if(!_0x51d0e8)return;if(this[_0x4731c8(0x190)][_0x4731c8(0x31b)](_0x51d0e8['id']))return;if(this[_0x4731c8(0x315)]['includes'](_0x51d0e8['id']))return;const _0x169d1f=_0x51d0e8['list'];let _0x32c465=![];for(const _0x44927f of _0x169d1f){if(_0x4731c8(0x289)===_0x4731c8(0x289)){if([0x0,0x6c,0x198][_0x4731c8(0x31b)](_0x44927f[_0x4731c8(0x2d1)]))continue;if([0x163,0x28f][_0x4731c8(0x31b)](_0x44927f[_0x4731c8(0x2d1)])){_0x32c465=!![];continue;}_0x32c465=![];break;}else _0x575ae3[_0x4731c8(0x2cc)][_0x42ccaa]=_0x11ae47['value'](_0x101ba1),this[_0x4731c8(0x1c5)](_0x4731c8(0x2cc),_0x53775e),_0x50991a['push'](_0x5589b6);}_0x32c465?(this[_0x4731c8(0x315)][_0x4731c8(0x175)](_0x51d0e8['id']),this['createJsFunctionsForCommonEvent'](_0x51d0e8)):_0x4731c8(0x22a)!==_0x4731c8(0xd4)?this['_normalCommonEvents'][_0x4731c8(0x175)](_0x51d0e8['id']):(_0x24617f['prototype'][_0x4731c8(0x18a)][_0x4731c8(0xf1)](this,_0x4bf247),this['createTimingBarSprite']());},VisuMZ['QTE_TriggerSys'][_0x2ec946(0x183)]=function(_0x260031){const _0x5d0e0a=_0x2ec946;this['_jsFuncs']=this[_0x5d0e0a(0x1e3)]||{},this[_0x5d0e0a(0x1e3)][_0x260031['id']]=this[_0x5d0e0a(0x1e3)][_0x260031['id']]||[];let _0x17abec='';const _0xaff5d9=_0x260031['list'];for(const _0x895652 of _0xaff5d9){if(_0x5d0e0a(0x180)===_0x5d0e0a(0x1fc)){_0x19a116[_0x5d0e0a(0x310)][_0x5d0e0a(0x2a2)]();if(_0x1e0a1e)_0x454f43[_0x5d0e0a(0x2a2)]();}else{if(_0x895652[_0x5d0e0a(0x2d1)]===0x163){if(_0x17abec!==''){const _0x49f2e0=new Function(_0x17abec);this[_0x5d0e0a(0x1e3)][_0x260031['id']][_0x5d0e0a(0x175)](_0x49f2e0),_0x17abec='';}_0x17abec+=_0x895652[_0x5d0e0a(0x15e)][0x0]+'\x0a';}else{if(_0x895652['code']===0x28f){if('qNeiK'===_0x5d0e0a(0x299))_0x17abec+=_0x895652[_0x5d0e0a(0x15e)][0x0]+'\x0a';else{if(!_0x1a5318[_0x5d0e0a(0x313)]())return;const _0x47bf0d=_0x5c76f5['QTE_TriggerSys']['Settings'][_0x5d0e0a(0x207)],_0x50f69b=_0x4cd084['ceil'](_0x47bf0d[_0x5d0e0a(0x274)]/0x2);if(_0x188b09['_qteEarlyFinishDuration']>_0x50f69b)return;const _0x5e41fd=_0x33e31d[_0x5d0e0a(0x338)](0xff/_0x50f69b);this[_0x5d0e0a(0x28d)]-=_0x5e41fd;}}else{if(_0x895652[_0x5d0e0a(0x2d1)]===0x0&&_0x17abec!==''){if('oOtcO'!=='haIKU'){const _0x4f8a95=new Function(_0x17abec);this[_0x5d0e0a(0x1e3)][_0x260031['id']][_0x5d0e0a(0x175)](_0x4f8a95),_0x17abec='';}else{_0x431811[_0x5d0e0a(0x253)](_0x2f32b9,_0xd90fe3);const _0xa0592d=_0x369620[_0x5d0e0a(0x27c)]||0x0;_0x315460[_0x5d0e0a(0x12a)](_0xa0592d);}}}}}}},VisuMZ[_0x2ec946(0x310)][_0x2ec946(0x1c6)]=function(_0x1c5e05){const _0x68f94f=_0x2ec946;this[_0x68f94f(0x2fa)]($dataCommonEvents[_0x1c5e05]);if(this['_normalCommonEvents']['includes'](_0x1c5e05))$gameSystem['reserveOnceParallel'](_0x1c5e05);else this['_jsCommonEvents'][_0x68f94f(0x31b)](_0x1c5e05)&&this['processJavaScriptFuncs'](_0x1c5e05);},VisuMZ[_0x2ec946(0x310)]['processJavaScriptFuncs']=function(_0x59d91f){const _0x356569=_0x2ec946;this[_0x356569(0x1e3)]=this[_0x356569(0x1e3)]||{},this['_jsFuncs'][_0x59d91f]=this['_jsFuncs'][_0x59d91f]||[];const _0x2e1d36=this['_jsFuncs'][_0x59d91f];for(const _0x25bca0 of _0x2e1d36){if(_0x356569(0x2d3)!==_0x356569(0xe4))try{_0x356569(0x303)===_0x356569(0x303)?_0x25bca0():_0x5a38c1['sequence']=_0x455d9a['QTE_TriggerSys'][_0x356569(0xf0)](_0x2e2ae3[_0x356569(0x2a9)]);}catch(_0x4a362a){if(_0x356569(0xf3)!==_0x356569(0x325))console['log'](_0x4a362a);else{const _0x22f5e9=_0x351082(_0x35b07e);_0x4b9d5c['value'](_0x22f5e9)!==_0x349abc[_0x356569(0x126)][_0x2397b8]&&(_0x56b1b7[_0x356569(0x126)][_0x14d762]=_0x15ff72[_0x356569(0x1d0)](_0x22f5e9),this[_0x356569(0x1c5)](_0x356569(0x126),_0x22f5e9),_0x17799f[_0x356569(0x175)](_0x22f5e9));}}else for(const _0x5f1d5d in this[_0x356569(0x25e)]){const _0x14bb01=_0x58ff94(_0x5f1d5d);_0xa40254[_0x356569(0x1d0)](_0x14bb01)!==this[_0x356569(0x25e)][_0x5f1d5d]&&(this['_watchedJsVariables'][_0x5f1d5d]=_0x2eb108[_0x356569(0x1d0)](_0x14bb01),_0x2ab3d8['QTE_TriggerSys'][_0x356569(0x287)](_0x14bb01));}}},VisuMZ[_0x2ec946(0x310)][_0x2ec946(0x20d)]=function(_0x1d9d60){const _0x210726=_0x2ec946;if(!this[_0x210726(0x1d4)][_0x1d9d60])return;const _0x5e3c52=this[_0x210726(0x1d4)][_0x1d9d60];for(const _0x4464b3 of _0x5e3c52){this[_0x210726(0x1c6)](_0x4464b3);}},VisuMZ[_0x2ec946(0x310)]['processVariableTrigger']=function(_0x226bb0){const _0x589fd7=_0x2ec946;if(!this[_0x589fd7(0x28f)][_0x226bb0])return;const _0x25ff6e=this[_0x589fd7(0x28f)][_0x226bb0];for(const _0x11c708 of _0x25ff6e){this[_0x589fd7(0x1c6)](_0x11c708);}},VisuMZ['QTE_TriggerSys'][_0x2ec946(0x1ed)]=function(_0x29771e){const _0x17e036=_0x2ec946,_0x1fa65d=DataManager['getOnChangeCommonEventTriggers'](_0x29771e);for(const _0x312dd5 of _0x1fa65d){if(_0x17e036(0x21b)!==_0x17e036(0x32a))this[_0x17e036(0x1c6)](_0x312dd5);else try{_0x2fa019();}catch(_0x2b1398){_0x4ca0ff[_0x17e036(0x238)](_0x2b1398);}}},DataManager[_0x2ec946(0x1f1)]=function(_0x4aad39){const _0x5904c5=_0x2ec946;return DataManager[_0x5904c5(0x17a)](_0x4aad39);},DataManager[_0x2ec946(0x281)]=function(_0x1805ef){const _0x2491bb=_0x2ec946;return DataManager[_0x2491bb(0x100)](_0x1805ef);},DataManager[_0x2ec946(0x30f)]=function(_0x5ba562){const _0x49e5d1=_0x2ec946;if(!_0x5ba562)return![];return this['getOnChangeCommonEventTriggers'](_0x5ba562)[_0x49e5d1(0x326)]>0x0;},DataManager[_0x2ec946(0x308)]=function(_0x4bf6e1){const _0xacf582=_0x2ec946;if(!_0x4bf6e1)return[];this[_0xacf582(0x130)]=this[_0xacf582(0x130)]||{};const _0x5af6d2=VisuMZ[_0xacf582(0x310)][_0xacf582(0x173)](_0x4bf6e1,_0xacf582(0x1a3));if(this[_0xacf582(0x130)][_0x5af6d2]!==undefined){if(_0xacf582(0x2d9)!=='mzBdb')return this['_cache_onChangeCommonEventTrigger'][_0x5af6d2];else{this['_labelMode']=!![];const _0x1e1762=this[_0xacf582(0xd7)](_0xb63c33)['width'],_0x31e1a9=_0x58ebbf+_0x2e66f4[_0xacf582(0x116)](_0x584665/0x2),_0x3d5d4c=_0x31e1a9-_0x1e81c1['ceil'](_0x1e1762/0x2)+(_0x4beb37[_0xacf582(0x1c9)]||0x0),_0xb0b1cc=_0x4efbd8[_0xacf582(0x316)]||0x0;this[_0xacf582(0x20e)](_0x4015ee,_0x3d5d4c,_0xb0b1cc),this[_0xacf582(0x294)]=![];}}this[_0xacf582(0x130)][_0x5af6d2]=[];const _0x28dc15=VisuMZ[_0xacf582(0x310)][_0xacf582(0x23d)],_0x23f1d3=_0x4bf6e1[_0xacf582(0x20b)]||'';if(_0x23f1d3[_0xacf582(0x2be)](_0x28dc15[_0xacf582(0x2c3)])){const _0x44e12b=String(RegExp['$1'])[_0xacf582(0x2e2)](',')['map'](_0x5bc663=>Number(_0x5bc663));for(const _0x3bc365 of _0x44e12b){this[_0xacf582(0x130)][_0x5af6d2]['push'](_0x3bc365);}}return this[_0xacf582(0x130)][_0x5af6d2];},VisuMZ[_0x2ec946(0x310)][_0x2ec946(0x173)]=function(_0x1e03fc,_0x48a511){const _0x1c08b8=_0x2ec946;if(VisuMZ[_0x1c08b8(0x173)])return VisuMZ['createKeyJS'](_0x1e03fc,_0x48a511);let _0x472fb6='';if($dataActors[_0x1c08b8(0x31b)](_0x1e03fc))_0x472fb6=_0x1c08b8(0x192)[_0x1c08b8(0x1dd)](_0x1e03fc['id'],_0x48a511);if($dataClasses['includes'](_0x1e03fc))_0x472fb6=_0x1c08b8(0x1ae)['format'](_0x1e03fc['id'],_0x48a511);if($dataSkills[_0x1c08b8(0x31b)](_0x1e03fc))_0x472fb6=_0x1c08b8(0x2ab)[_0x1c08b8(0x1dd)](_0x1e03fc['id'],_0x48a511);if($dataItems[_0x1c08b8(0x31b)](_0x1e03fc))_0x472fb6=_0x1c08b8(0x140)[_0x1c08b8(0x1dd)](_0x1e03fc['id'],_0x48a511);if($dataWeapons['includes'](_0x1e03fc))_0x472fb6=_0x1c08b8(0x132)['format'](_0x1e03fc['id'],_0x48a511);if($dataArmors[_0x1c08b8(0x31b)](_0x1e03fc))_0x472fb6='Armor-%1-%2'['format'](_0x1e03fc['id'],_0x48a511);if($dataEnemies['includes'](_0x1e03fc))_0x472fb6=_0x1c08b8(0xdb)[_0x1c08b8(0x1dd)](_0x1e03fc['id'],_0x48a511);if($dataStates[_0x1c08b8(0x31b)](_0x1e03fc))_0x472fb6='State-%1-%2'['format'](_0x1e03fc['id'],_0x48a511);return _0x472fb6;},VisuMZ[_0x2ec946(0x310)][_0x2ec946(0x2bb)]=SceneManager[_0x2ec946(0x2c8)],SceneManager['updateFrameCount']=function(){const _0x4d68c1=_0x2ec946;VisuMZ[_0x4d68c1(0x310)][_0x4d68c1(0x2bb)][_0x4d68c1(0xf1)](this);const _0x8ad9f8=VisuMZ['QTE_TriggerSys'][_0x4d68c1(0x1c2)][_0x4d68c1(0x1b0)]||0x3c;if(Graphics[_0x4d68c1(0x2e5)]%_0x8ad9f8===0x0){VisuMZ[_0x4d68c1(0x310)][_0x4d68c1(0x2a2)]();if($gameSystem)$gameSystem[_0x4d68c1(0x2a2)]();}},VisuMZ[_0x2ec946(0x310)][_0x2ec946(0x2a2)]=function(){const _0x52715b=_0x2ec946;{if(_0x52715b(0x213)!==_0x52715b(0x166))for(const _0x628db9 in this[_0x52715b(0x327)]){const _0x4aacf7=Number(_0x628db9);$gameSwitches[_0x52715b(0x1d0)](_0x4aacf7)!==this[_0x52715b(0x327)][_0x628db9]&&(_0x52715b(0x275)!=='wWcqT'?(this[_0x52715b(0x327)][_0x628db9]=$gameSwitches[_0x52715b(0x1d0)](_0x4aacf7),VisuMZ[_0x52715b(0x310)][_0x52715b(0x20d)](_0x4aacf7)):_0x54b11d[_0x52715b(0x28a)][_0x52715b(0x18a)][_0x52715b(0xf1)](this,_0x1ca1b5));}else _0x53a512['picture']='';}{for(const _0x405b61 in this[_0x52715b(0x25e)]){if(_0x52715b(0x136)!==_0x52715b(0x1bb)){const _0xd070df=Number(_0x405b61);$gameVariables[_0x52715b(0x1d0)](_0xd070df)!==this['_watchedJsVariables'][_0x405b61]&&(_0x52715b(0x290)!==_0x52715b(0x290)?(_0x1772d7(_0x52715b(0x189)[_0x52715b(0x1dd)](_0x3a6843,_0xecd0a2,_0xfbd95d)),_0x53c14f['exit']()):(this[_0x52715b(0x25e)][_0x405b61]=$gameVariables['value'](_0xd070df),VisuMZ['QTE_TriggerSys'][_0x52715b(0x287)](_0xd070df)));}else{if(_0x5e9f03['_inputComboSkillMode']){const _0xed53f9=_0x52715b(0xf7);return _0x587fe4[_0x52715b(0x238)](_0xed53f9),!![];}}}}},VisuMZ['QTE_TriggerSys'][_0x2ec946(0x125)]=SceneManager['initialize'],SceneManager[_0x2ec946(0x18a)]=function(){const _0x24142e=_0x2ec946;VisuMZ['QTE_TriggerSys']['SceneManager_initialize']['call'](this),this[_0x24142e(0x2b5)]();},SceneManager[_0x2ec946(0x2b5)]=function(){const _0x3d3259=_0x2ec946;this[_0x3d3259(0x10e)]='',this[_0x3d3259(0xd9)]=0x0,this[_0x3d3259(0x205)]=0x0,this['_qteWholeDuration']=0x0,this[_0x3d3259(0x204)]=0x0,this[_0x3d3259(0xeb)]=0x0,this['_qteSettings']={},this[_0x3d3259(0xee)]=0x0,this['_afterQteSessionDelay']=0x3c;},SceneManager['isPlayingQTE']=function(){return this['_qteType']!=='';},SceneManager[_0x2ec946(0x2ef)]=function(){const _0x22a627=_0x2ec946;if(this[_0x22a627(0x22d)]()){if(_0x22a627(0x2f7)===_0x22a627(0x2f7)){if($gameTemp[_0x22a627(0x296)]()){if(_0x22a627(0x1e7)!==_0x22a627(0x2bd)){const _0x57170f=_0x22a627(0x268);console['log'](_0x57170f);}else _0xc371ec['setValue'](_0x46ff77,!![]);}return!![];}else{const _0x5d892d=_0x21c309[_0x22a627(0x310)][_0x22a627(0x1c2)][_0x22a627(0x207)],_0x4c8f89=_0x5d892d[_0x22a627(0x2cd)]||0x64,_0xffccf=0xc,_0x3682ff=_0x2f1cc6[_0x22a627(0x138)]((this[_0x22a627(0x29d)]-_0x4c8f89)/0x2),_0x130ac0=this['lineHeight']()-_0xffccf-0x2,_0xfdc8a3=_0x106840[_0x22a627(0x23e)],_0x43e7fb=_0xfdc8a3[_0x22a627(0x1a0)];for(const _0x826687 of _0x43e7fb){const _0x4ad4da=_0x2982a0[_0x22a627(0x161)](_0x826687[_0x22a627(0x295)],_0x826687[_0x22a627(0x2fe)])[_0x22a627(0x196)](0x0,0x64),_0x1a649a=_0x32aa7f[_0x22a627(0x202)](_0x826687['Start'],_0x826687[_0x22a627(0x2fe)])[_0x22a627(0x196)](0x0,0x64),_0x86db0b=_0x1f2c5f[_0x22a627(0x338)](_0x4ad4da*0.01*_0x4c8f89),_0x228b12=_0x5beb0e[_0x22a627(0x138)](_0x1a649a*0.01*_0x4c8f89),_0xf8adaf=_0x86db0b+_0x3682ff,_0x59db62=_0x228b12-_0x86db0b,_0x1ffb1d=_0x3f1a67['getColor'](_0x826687[_0x22a627(0x186)]),_0x55ca1a=_0x4585c7['getColor'](_0x826687['AreaColor2']);this['contents'][_0x22a627(0x245)](_0xf8adaf,_0x130ac0,_0x59db62,_0xffccf,_0x1ffb1d,_0x55ca1a,!![]);const _0x1c9b81=_0x826687['Label']||'';if(_0x1c9b81[_0x22a627(0x326)]>0x0){this[_0x22a627(0x294)]=!![];const _0x3c6f36=this[_0x22a627(0xd7)](_0x1c9b81)[_0x22a627(0x11d)],_0x52e414=_0xf8adaf+_0x2abfa7[_0x22a627(0x116)](_0x59db62/0x2),_0x33bebb=_0x52e414-_0x26d429[_0x22a627(0x338)](_0x3c6f36/0x2)+(_0x5d892d[_0x22a627(0x1c9)]||0x0),_0xe1e24e=_0x5d892d[_0x22a627(0x316)]||0x0;this['drawTextEx'](_0x1c9b81,_0x33bebb,_0xe1e24e),this[_0x22a627(0x294)]=![];}}}}if(SceneManager['isRollingDice']){if(SceneManager[_0x22a627(0x26e)]()){if(_0x22a627(0x2a4)===_0x22a627(0x2a4)){if($gameTemp[_0x22a627(0x296)]()){const _0x4aecaf=_0x22a627(0x2f3);console[_0x22a627(0x238)](_0x4aecaf);}return!![];}else _0x448443[_0x22a627(0x328)](),_0x231e0b[_0x22a627(0x328)](),this[_0x22a627(0x276)]();}}if(this['isSceneBattle']()){const _0x24d9f2=this[_0x22a627(0x1b4)][_0x22a627(0x24e)];if(Imported[_0x22a627(0x13b)]){if(this[_0x22a627(0x1b4)]['isActiveChainSkillsUiVisible']()){const _0x1f1462=_0x22a627(0x1cc);return console[_0x22a627(0x238)](_0x1f1462),!![];}}if(Imported[_0x22a627(0x155)]){if(_0x22a627(0x18b)!==_0x22a627(0x18b)){let _0x10113a='';_0x10113a+=_0x22a627(0x12e),_0x10113a+=_0x22a627(0x22f),_0x24f202(_0x10113a),_0x508412[_0x22a627(0x23b)]();}else{if(_0x24d9f2[_0x22a627(0x291)]){const _0xeb5a0d=_0x22a627(0xf7);return console['log'](_0xeb5a0d),!![];}}}if(Imported['VisuMZ_3_EvoMatrixSkills']){if(_0x24d9f2[_0x22a627(0x1ff)]){const _0x23c653=_0x22a627(0x1d6);return console[_0x22a627(0x238)](_0x23c653),!![];}}}return![];},SceneManager['getTypeQTE']=function(){return this['_qteType'];},SceneManager[_0x2ec946(0x2d2)]=function(_0x4589dc){const _0x456e32=_0x2ec946;this['_qteType']=_0x4589dc['type']||'';if(this[_0x456e32(0x10e)]==='')return;Input[_0x456e32(0x328)](),TouchInput[_0x456e32(0x328)](),this[_0x456e32(0xd9)]=_0x4589dc[_0x456e32(0x286)]||0x0,this['_qteDuration']=_0x4589dc[_0x456e32(0x30d)],this['_qteWholeDuration']=_0x4589dc['duration'],this['_qteSettings']=JSON[_0x456e32(0x167)](JSON['stringify'](_0x4589dc));_0x4589dc[_0x456e32(0x2e6)]===_0x456e32(0x208)&&_0x4589dc['picture']&&this['_scene'][_0x456e32(0x2e4)]();if(this[_0x456e32(0x1b4)]){if(_0x456e32(0x1a8)==='NRBnl')this[_0x456e32(0x1b4)][_0x456e32(0x306)](this['_qteType']);else return this[_0x456e32(0x2d0)]('items',_0x4420ce['id']);}_0x4589dc['switchID']&&_0x4589dc[_0x456e32(0x106)]>0x0&&$gameSwitches[_0x456e32(0x31a)](_0x4589dc[_0x456e32(0x106)],![]),_0x4589dc['varID']&&_0x4589dc['varID']>0x0&&$gameVariables[_0x456e32(0x31a)](_0x4589dc[_0x456e32(0x17c)],0x0);},SceneManager['updateQTEDuration']=function(){const _0x27b53a=_0x2ec946;if(this[_0x27b53a(0xd9)]>0x0){this[_0x27b53a(0xd9)]--;return;}if(this[_0x27b53a(0xee)]>0x0){if(_0x27b53a(0x323)!==_0x27b53a(0x323))return this[_0x27b53a(0x21a)]!==null&&this['_pressedTime']===0x0;else{this['_qteEarlyFinishDuration']--;this[_0x27b53a(0xee)]<=0x0&&this['clear_QTE_Settings']();return;}}this[_0x27b53a(0x205)]<0xf4240&&(_0x27b53a(0x332)!==_0x27b53a(0xe2)?this[_0x27b53a(0x205)]--:this[_0x27b53a(0x1c6)](_0x30ecf8)),this[_0x27b53a(0x205)]<=0x0&&this[_0x27b53a(0x2b5)]();},SceneManager[_0x2ec946(0x276)]=function(){const _0x3d1739=_0x2ec946,_0x592a13=VisuMZ[_0x3d1739(0x310)][_0x3d1739(0x1c2)][_0x3d1739(0x207)];this[_0x3d1739(0xee)]=_0x592a13[_0x3d1739(0x274)]??0x28;},SceneManager[_0x2ec946(0x313)]=function(){const _0x6a068b=_0x2ec946;return this[_0x6a068b(0xee)]>0x0;},VisuMZ[_0x2ec946(0x310)][_0x2ec946(0x124)]=SceneManager[_0x2ec946(0x2fc)],SceneManager[_0x2ec946(0x2fc)]=function(){const _0x3d356f=_0x2ec946;VisuMZ[_0x3d356f(0x310)][_0x3d356f(0x124)][_0x3d356f(0xf1)](this),this[_0x3d356f(0x22d)]()&&this[_0x3d356f(0x1b4)]['isActive']()&&this[_0x3d356f(0x1db)](),this[_0x3d356f(0x335)]>0x0&&this[_0x3d356f(0x335)]--;},SceneManager[_0x2ec946(0x1db)]=function(){const _0x517a45=_0x2ec946;if(this[_0x517a45(0xee)]>0x0)return;const _0xabdbcf=this[_0x517a45(0x18c)]();switch(_0xabdbcf){case'buttonMash':if(this[_0x517a45(0xd9)]>0x0)return;this[_0x517a45(0x273)]();break;case _0x517a45(0x178):this[_0x517a45(0x2bf)]();break;case'directionStruggle':if(this[_0x517a45(0xd9)]>0x0)return;this[_0x517a45(0x2e1)]();break;case _0x517a45(0x309):if(this['_qteInputDelay']>0x0)return;this['updateFillGaugeQTE']();break;case _0x517a45(0x1bf):if(this[_0x517a45(0xd9)]>0x0){(VisuMZ[_0x517a45(0x310)][_0x517a45(0x145)]()||Input['isTriggered']('ok')||TouchInput[_0x517a45(0x2aa)]())&&(this['_qteInputDelay']=0x0);return;}this[_0x517a45(0x26f)]();break;case _0x517a45(0x1f2):if(this[_0x517a45(0xd9)]>0x0)return;this[_0x517a45(0x25b)]();break;case _0x517a45(0x288):if(this['_qteInputDelay']>0x0)return;this[_0x517a45(0x2d4)]();break;case'timedHit':if(this[_0x517a45(0xd9)]>0x0)return;this[_0x517a45(0x260)]();break;case _0x517a45(0x15c):if(this[_0x517a45(0xd9)]>0x0)return;this[_0x517a45(0x122)]();break;case'timingBar':if(this[_0x517a45(0xd9)]>0x0)return;this[_0x517a45(0xd8)]();break;}},VisuMZ['QTE_TriggerSys'][_0x2ec946(0x145)]=function(_0x3ddf19){const _0x12456d=_0x2ec946;if(_0x3ddf19){if(Input[_0x12456d(0x214)](_0x12456d(0x22b))&&Input[_0x12456d(0x214)]('control'))return!![];return $gameTemp['isPlaytest']()&&Input[_0x12456d(0x214)](_0x12456d(0x13f));}else{if(_0x12456d(0xf9)==='oozYI'){if(Input['isPressed'](_0x12456d(0x22b))&&Input[_0x12456d(0x1ec)](_0x12456d(0x13f)))return!![];return $gameTemp[_0x12456d(0x296)]()&&Input[_0x12456d(0x1ec)](_0x12456d(0x13f));}else{if(_0x571846[_0x12456d(0x214)](_0x12456d(0x22b))&&_0x6847f7[_0x12456d(0x214)](_0x12456d(0x13f)))return!![];return _0x2ac5c0[_0x12456d(0x296)]()&&_0x2cd5cc['isPressed'](_0x12456d(0x13f));}}},Input[_0x2ec946(0x14a)]=function(){return this['_latestButton']!==null&&this['_pressedTime']===0x0;},SceneManager[_0x2ec946(0x273)]=function(){const _0x396e76=_0x2ec946;if(VisuMZ[_0x396e76(0x310)][_0x396e76(0x145)]()||Input['isTriggered']('ok')||TouchInput[_0x396e76(0x2aa)]()){const _0x3af799=this[_0x396e76(0x23e)],_0xa177ae=_0x3af799[_0x396e76(0x17c)]||0x0;if(_0xa177ae>0x0){if(_0x396e76(0x2f6)===_0x396e76(0x2f6)){const _0x28f612=$gameVariables[_0x396e76(0x1d0)](_0xa177ae);$gameVariables[_0x396e76(0x31a)](_0xa177ae,_0x28f612+0x1);}else{_0x3a0b9a['prototype'][_0x396e76(0x30a)][_0x396e76(0xf1)](this);if(this['needsRefresh']())this[_0x396e76(0x211)]();if(this[_0x396e76(0x143)]())this[_0x396e76(0x30c)]();else(_0x2051b4[_0x396e76(0x313)]()||this[_0x396e76(0x112)])&&this[_0x396e76(0x29a)]();}}const _0x219f29=_0x3af799[_0x396e76(0x333)]||0x0;_0x219f29>0x0&&(_0x396e76(0x2e3)===_0x396e76(0x2e3)?$onceParallel(_0x219f29):this['fulfillOnTriggerPromises']('armors',_0x22d8bd['id']));const _0xe98509=_0x3af799[_0x396e76(0x142)];_0xe98509&&_0xe98509[_0x396e76(0x154)]&&AudioManager['playSe'](_0xe98509);}},SceneManager[_0x2ec946(0x2bf)]=function(){const _0x1c1b21=_0x2ec946,_0x453a0a=this[_0x1c1b21(0x23e)],_0x5a789f=this[_0x1c1b21(0x23e)]['sequence'],_0x3e7b2c=this['_qteSettings']['progress']||0x0,_0x4debf3=_0x5a789f[_0x3e7b2c];if(this['_qteInputBuffer']>0x0)this[_0x1c1b21(0x204)]--;if(VisuMZ[_0x1c1b21(0x310)][_0x1c1b21(0x145)]()||Input[_0x1c1b21(0x2aa)](_0x4debf3)){if(Input[_0x1c1b21(0x2aa)](_0x4debf3))Input[_0x1c1b21(0x328)]();this['_qteInputBuffer']=0x14,this[_0x1c1b21(0xd9)]=0x0;const _0x4e42dd=_0x453a0a[_0x1c1b21(0x333)]||0x0;_0x4e42dd>0x0&&$onceParallel(_0x4e42dd);const _0x3a96ae=_0x453a0a[_0x1c1b21(0x142)];_0x3a96ae&&_0x3a96ae[_0x1c1b21(0x154)]&&AudioManager[_0x1c1b21(0x14d)](_0x3a96ae);_0x453a0a[_0x1c1b21(0x26b)]++;if(_0x453a0a['progress']>=_0x5a789f[_0x1c1b21(0x326)]){Input[_0x1c1b21(0x328)](),TouchInput['clear']();const _0x556d3d=_0x453a0a[_0x1c1b21(0x106)]||0x0;if(_0x556d3d>0x0){if('jVugw'===_0x1c1b21(0x2c1))$gameSwitches['setValue'](_0x556d3d,!![]);else{const _0x2c7af2=_0x417131[_0x1c1b21(0x310)][_0x1c1b21(0x1c2)][_0x1c1b21(0x207)];return _0x24a9ff[_0x1c1b21(0xcb)](_0x2c7af2[_0x1c1b21(0x2ba)]);}}const _0x3151a9=_0x453a0a['varID']||0x0;_0x3151a9>0x0&&$gameVariables[_0x1c1b21(0x31a)](_0x3151a9,this[_0x1c1b21(0x205)]),this[_0x1c1b21(0x276)]();}}else _0x3e7b2c>0x0&&this[_0x1c1b21(0x204)]<=0x0&&Input[_0x1c1b21(0x14a)]()&&(SoundManager[_0x1c1b21(0x1d1)](),_0x453a0a[_0x1c1b21(0x26b)]=0x0);},SceneManager[_0x2ec946(0x2e1)]=function(){const _0x3ab0b1=_0x2ec946;if(VisuMZ[_0x3ab0b1(0x310)]['PlaytestInput']()||Input[_0x3ab0b1(0x298)]>0x0){if(Input[_0x3ab0b1(0x298)]>0x0){if(_0x3ab0b1(0x2a0)==='IWAWy'){if(this[_0x3ab0b1(0xeb)]===Input[_0x3ab0b1(0x298)])return;this[_0x3ab0b1(0xeb)]=Input['dir4'];}else{if(!this[_0x3ab0b1(0x15f)])return![];if(_0xa72644[_0x3ab0b1(0xd9)]>0x0)return![];if(this[_0x3ab0b1(0x20a)])return![];return!![];}}const _0x539507=this[_0x3ab0b1(0x23e)],_0x4c71ae=_0x539507[_0x3ab0b1(0x333)]||0x0;_0x4c71ae>0x0&&$onceParallel(_0x4c71ae);const _0x2b9166=_0x539507[_0x3ab0b1(0x142)];_0x2b9166&&_0x2b9166[_0x3ab0b1(0x154)]&&(_0x3ab0b1(0x2ad)!==_0x3ab0b1(0x2ad)?this[_0x3ab0b1(0x18a)](...arguments):AudioManager['playSe'](_0x2b9166));_0x539507[_0x3ab0b1(0x26b)]++;if(_0x539507[_0x3ab0b1(0x26b)]>=_0x539507[_0x3ab0b1(0x32c)]){Input[_0x3ab0b1(0x328)](),TouchInput['clear']();const _0x557e19=_0x539507[_0x3ab0b1(0x106)]||0x0;_0x557e19>0x0&&$gameSwitches[_0x3ab0b1(0x31a)](_0x557e19,!![]);const _0x146fbc=_0x539507['varID']||0x0;_0x146fbc>0x0&&$gameVariables[_0x3ab0b1(0x31a)](_0x146fbc,this['_qteDuration']),this[_0x3ab0b1(0x276)]();}}},SceneManager[_0x2ec946(0x13c)]=function(){const _0x55fcaf=_0x2ec946;if(VisuMZ['QTE_TriggerSys'][_0x55fcaf(0x145)]()||Input[_0x55fcaf(0x2aa)]('ok')||TouchInput['isTriggered']()){const _0x567699=this[_0x55fcaf(0x23e)],_0x1cc28c=_0x567699[_0x55fcaf(0x333)]||0x0;_0x1cc28c>0x0&&$onceParallel(_0x1cc28c);const _0x54d31f=_0x567699['sound'];if(_0x54d31f&&_0x54d31f[_0x55fcaf(0x154)]){if(_0x55fcaf(0x2b2)===_0x55fcaf(0x2b2))AudioManager[_0x55fcaf(0x14d)](_0x54d31f);else{if(this[_0x55fcaf(0x1d3)]!==_0x359bdc['_qteDuration'])return!![];if(this['_lastWholeDuration']!==_0x23db09['_qteWholeDuration'])return!![];return![];}}_0x567699[_0x55fcaf(0x26b)]++;if(_0x567699[_0x55fcaf(0x26b)]>=_0x567699['goal']){Input[_0x55fcaf(0x328)](),TouchInput[_0x55fcaf(0x328)]();const _0x162c00=_0x567699['switchID']||0x0;if(_0x162c00>0x0){if(_0x55fcaf(0x33d)===_0x55fcaf(0x33d))$gameSwitches[_0x55fcaf(0x31a)](_0x162c00,!![]);else{const _0x4fb4a4=_0x55fcaf(0x2f3);_0x26b21e['log'](_0x4fb4a4);}}const _0xba833c=_0x567699[_0x55fcaf(0x17c)]||0x0;_0xba833c>0x0&&(_0x55fcaf(0x1e8)!==_0x55fcaf(0x1e8)?_0x4c6067(_0x2da143):$gameVariables[_0x55fcaf(0x31a)](_0xba833c,this[_0x55fcaf(0x205)])),this['finishEarlyQTE']();}}},SceneManager[_0x2ec946(0x26f)]=function(){const _0x132021=_0x2ec946,_0x26d332=this[_0x132021(0x23e)];this[_0x132021(0x205)]=0x1f40;if(VisuMZ[_0x132021(0x310)][_0x132021(0x145)](!![])||Input[_0x132021(0x214)]('ok')||TouchInput[_0x132021(0x214)]()){if(_0x132021(0x1eb)===_0x132021(0x1eb)){VisuMZ[_0x132021(0x310)][_0x132021(0x145)](!![])?_0x26d332[_0x132021(0x26b)]+=Math[_0x132021(0x138)](_0x26d332[_0x132021(0x32c)]/0x14):_0x26d332[_0x132021(0x26b)]++;if(_0x26d332[_0x132021(0x26b)]>=_0x26d332['goal']){if(VisuMZ['QTE_TriggerSys'][_0x132021(0x145)](!![]))Input['clear'](),TouchInput[_0x132021(0x328)]();else{if(_0x132021(0x22c)===_0x132021(0x22c)){Input['clear'](),TouchInput[_0x132021(0x328)]();const _0x54b188=_0x26d332[_0x132021(0x1cd)];_0x54b188&&_0x54b188[_0x132021(0x154)]&&('RItvO'===_0x132021(0x2ff)?AudioManager[_0x132021(0x14d)](_0x54b188):this[_0x132021(0xd9)]=0x0);const _0x33f1dd=_0x26d332[_0x132021(0x106)]||0x0;_0x33f1dd>0x0&&$gameSwitches[_0x132021(0x31a)](_0x33f1dd,![]);const _0x4e7f5a=_0x26d332[_0x132021(0x17c)]||0x0;_0x4e7f5a>0x0&&(_0x132021(0x2f9)===_0x132021(0x2f9)?$gameVariables['setValue'](_0x4e7f5a,0x0):this['_scene'][_0x132021(0x306)](this[_0x132021(0x10e)])),this[_0x132021(0x276)]();}else this['_qteCursorSprite'][_0x132021(0x2ae)]();}}}else{if(this[_0x132021(0xfa)]===_0x41ee18)this[_0x132021(0x14c)]();this['_gameOverCommonEventID']=_0x14e6fd;}}else{if(!VisuMZ[_0x132021(0x310)][_0x132021(0x145)](!![])&&!Input[_0x132021(0x214)]('ok')&&!TouchInput[_0x132021(0x214)]()){Input['clear'](),TouchInput[_0x132021(0x328)]();const _0x238d31=_0x26d332[_0x132021(0x26b)]>0x0?_0x26d332[_0x132021(0x2a8)]:_0x26d332['overloadSound'];_0x238d31&&_0x238d31[_0x132021(0x154)]&&AudioManager[_0x132021(0x14d)](_0x238d31);const _0x471bd3=_0x26d332[_0x132021(0x106)]||0x0;_0x471bd3>0x0&&$gameSwitches['setValue'](_0x471bd3,_0x26d332['progress']>0x0);const _0x13f9cb=_0x26d332[_0x132021(0x17c)]||0x0;_0x13f9cb>0x0&&(_0x132021(0x29f)!==_0x132021(0x272)?(_0x26d332[_0x132021(0x26b)]=Math[_0x132021(0x161)](_0x26d332[_0x132021(0x26b)],_0x26d332['goal']),$gameVariables[_0x132021(0x31a)](_0x13f9cb,_0x26d332[_0x132021(0x26b)])):_0x4fbbfd[_0x132021(0x1c5)](_0x132021(0x2cc),_0x3b4c7e)),this[_0x132021(0x276)]();}}},SceneManager[_0x2ec946(0x25b)]=function(){const _0x239512=_0x2ec946;if(VisuMZ['QTE_TriggerSys']['PlaytestInput']()||Input[_0x239512(0x2aa)]('pageup')||Input[_0x239512(0x2aa)](_0x239512(0x239))){const _0x3b0d15=this[_0x239512(0x23e)];if(Input['isTriggered'](_0x239512(0x20f))){if(this[_0x239512(0xeb)]===_0x239512(0x20f))return;this['_qteLastInput']='pageup';}if(Input[_0x239512(0x2aa)](_0x239512(0x239))){if(this[_0x239512(0xeb)]===_0x239512(0x239))return;this[_0x239512(0xeb)]=_0x239512(0x239);}VisuMZ[_0x239512(0x310)][_0x239512(0x145)]()&&(this[_0x239512(0xeb)]=this[_0x239512(0xeb)]===_0x239512(0x20f)?_0x239512(0x239):'pageup');const _0x56a2ca=this[_0x239512(0xeb)]==='pageup'?_0x3b0d15[_0x239512(0x330)]||0x0:_0x3b0d15[_0x239512(0x117)]||0x0;_0x56a2ca>0x0&&$onceParallel(_0x56a2ca);const _0x5de64b=_0x3b0d15[_0x239512(0x142)];_0x5de64b&&_0x5de64b[_0x239512(0x154)]&&('RAELy'!=='NQmsT'?AudioManager[_0x239512(0x14d)](_0x5de64b):this[_0x239512(0x130)][_0x35dab2][_0x239512(0x175)](_0x139c21));_0x3b0d15[_0x239512(0x26b)]++;if(_0x3b0d15[_0x239512(0x26b)]>=_0x3b0d15['goal']){Input['clear'](),TouchInput[_0x239512(0x328)]();const _0x4396f1=_0x3b0d15[_0x239512(0x106)]||0x0;_0x4396f1>0x0&&('zCumT'===_0x239512(0x2ac)?_0x1ab565[_0x239512(0x31a)](_0x331191,!![]):$gameSwitches[_0x239512(0x31a)](_0x4396f1,!![]));const _0x29b6bf=_0x3b0d15[_0x239512(0x17c)]||0x0;_0x29b6bf>0x0&&$gameVariables[_0x239512(0x31a)](_0x29b6bf,this[_0x239512(0x205)]),this[_0x239512(0x276)]();}}},SceneManager[_0x2ec946(0x2d4)]=function(){const _0xedf65a=_0x2ec946;if(VisuMZ[_0xedf65a(0x310)][_0xedf65a(0x145)]()||Input[_0xedf65a(0x2aa)]('ok')||Input[_0xedf65a(0x2aa)](_0xedf65a(0x321))){const _0x26d356=this['_qteSettings'];if(Input[_0xedf65a(0x2aa)]('ok')){if(this[_0xedf65a(0xeb)]==='ok')return;this[_0xedf65a(0xeb)]='ok';}if(Input[_0xedf65a(0x2aa)](_0xedf65a(0x321))){if(this[_0xedf65a(0xeb)]===_0xedf65a(0x321))return;this[_0xedf65a(0xeb)]=_0xedf65a(0x321);}VisuMZ[_0xedf65a(0x310)][_0xedf65a(0x145)]()&&('CnADA'!==_0xedf65a(0x24f)?_0x2699a0[_0xedf65a(0x14d)](_0x5c17bc):this[_0xedf65a(0xeb)]=this[_0xedf65a(0xeb)]==='ok'?_0xedf65a(0x321):'ok');const _0x6620b=this[_0xedf65a(0xeb)]==='ok'?_0x26d356[_0xedf65a(0x1c3)]||0x0:_0x26d356[_0xedf65a(0x107)]||0x0;_0x6620b>0x0&&$onceParallel(_0x6620b);const _0x16463b=_0x26d356[_0xedf65a(0x142)];_0x16463b&&_0x16463b[_0xedf65a(0x154)]&&AudioManager[_0xedf65a(0x14d)](_0x16463b);_0x26d356[_0xedf65a(0x26b)]++;if(_0x26d356['progress']>=_0x26d356[_0xedf65a(0x32c)]){Input[_0xedf65a(0x328)](),TouchInput[_0xedf65a(0x328)]();const _0x22cd28=_0x26d356['switchID']||0x0;_0x22cd28>0x0&&$gameSwitches[_0xedf65a(0x31a)](_0x22cd28,!![]);const _0x1bf5e6=_0x26d356[_0xedf65a(0x17c)]||0x0;if(_0x1bf5e6>0x0){if(_0xedf65a(0x212)!==_0xedf65a(0x1e9))$gameVariables[_0xedf65a(0x31a)](_0x1bf5e6,this[_0xedf65a(0x205)]);else{this[_0xedf65a(0x257)]===_0x39144e&&this[_0xedf65a(0x1fa)]();while(this[_0xedf65a(0x257)][_0xedf65a(0x326)]){const _0x565685=this[_0xedf65a(0x257)][_0xedf65a(0x22b)]();_0x40bb49(_0x565685);}}}this[_0xedf65a(0x276)]();}}},SceneManager['updateTimedHitQTE']=function(){const _0xefa4f0=_0x2ec946;if(VisuMZ[_0xefa4f0(0x310)][_0xefa4f0(0x145)](!![])||Input[_0xefa4f0(0x2aa)]('ok')||TouchInput[_0xefa4f0(0x2aa)]()){if(_0xefa4f0(0xce)===_0xefa4f0(0xce)){const _0x1bfabc=this[_0xefa4f0(0x23e)],_0x47fb59=VisuMZ['QTE_TriggerSys'][_0xefa4f0(0x1c2)][_0xefa4f0(0x207)],_0xcb9eee=this['_qteDuration'];if(VisuMZ['QTE_TriggerSys'][_0xefa4f0(0x145)](!![])&&_0xcb9eee>0x1)return;Input[_0xefa4f0(0x328)](),TouchInput[_0xefa4f0(0x328)]();const _0x495649=_0x47fb59[_0xefa4f0(0x10c)]??0x10,_0x4ca4ed=_0x495649+0x1>=_0xcb9eee,_0x1137a4=_0x1bfabc[_0xefa4f0(0x106)]||0x0;_0x1137a4>0x0&&$gameSwitches[_0xefa4f0(0x31a)](_0x1137a4,_0x4ca4ed);const _0x4dcb7a=_0x1bfabc[_0xefa4f0(0x17c)]||0x0;_0x4dcb7a>0x0&&$gameVariables[_0xefa4f0(0x31a)](_0x4dcb7a,_0xcb9eee-0x1);if(_0x4ca4ed){if(_0xefa4f0(0x16f)==='KPTtd'){const _0x50e5d5=_0x1bfabc['hitSound'];_0x50e5d5&&_0x50e5d5[_0xefa4f0(0x154)]&&AudioManager['playSe'](_0x50e5d5);const _0x5c6814=_0x1bfabc[_0xefa4f0(0x1b3)]||0x0;_0x5c6814>0x0&&$onceParallel(_0x5c6814);}else return _0x2e241e[_0xefa4f0(0x1fd)]();}else{const _0x5d5094=_0x1bfabc[_0xefa4f0(0x2e8)];_0x5d5094&&_0x5d5094[_0xefa4f0(0x154)]&&(_0xefa4f0(0x127)!=='GVxSC'?AudioManager['playSe'](_0x5d5094):_0x36e2b3[_0xefa4f0(0x319)]());const _0x5ac991=_0x1bfabc[_0xefa4f0(0x1c4)]||0x0;if(_0x5ac991>0x0){if(_0xefa4f0(0x159)===_0xefa4f0(0x24a)){_0x176d98[_0xefa4f0(0x253)](_0x334e66,_0x1b565e);const _0x29af5f=_0x4ed33c[_0xefa4f0(0x21c)]||0x0;if(_0x29af5f<=0x0)return;const _0x82dfab=_0xb85caa[_0xefa4f0(0x30e)]||[],_0x18cce7='weapons';_0x370419[_0xefa4f0(0x229)](_0x18cce7,_0x29af5f,_0x82dfab);}else $onceParallel(_0x5ac991);}}this['finishEarlyQTE']();}else this[_0xefa4f0(0x2f8)]=_0x3f41b4(_0x271325['$1']);}},SceneManager[_0x2ec946(0x122)]=function(){const _0x4a63c9=_0x2ec946;if(VisuMZ[_0x4a63c9(0x310)][_0x4a63c9(0x145)](!![])||Input[_0x4a63c9(0x14a)]()){const _0x370faf=this[_0x4a63c9(0x23e)],_0x16a6de=VisuMZ[_0x4a63c9(0x310)][_0x4a63c9(0x1c2)][_0x4a63c9(0x207)],_0xd76185=this[_0x4a63c9(0x19f)]-this['_qteDuration'],_0x115db0=_0x370faf['remainingSequence'][0x0];if(!_0x115db0)return;const _0x33db52=_0x115db0['Timing'],_0x35383c=Math['abs'](_0x33db52-_0xd76185),_0x11d3c8=_0x16a6de[_0x4a63c9(0x11f)]??0x8;if(_0x35383c>_0x11d3c8*0x2)return;if(VisuMZ[_0x4a63c9(0x310)][_0x4a63c9(0x145)](!![])){if(_0x35383c!==0x1)return;}else Input[_0x4a63c9(0x328)](),TouchInput[_0x4a63c9(0x328)]();const _0x427369=_0x35383c<=_0x11d3c8;if(_0x427369){if(_0x4a63c9(0x221)!==_0x4a63c9(0x1b2)){const _0x36fda4=_0x115db0[_0x4a63c9(0x314)];if(_0x36fda4&&_0x36fda4[_0x4a63c9(0x154)]){if(_0x4a63c9(0x254)===_0x4a63c9(0x16e))return this[_0x4a63c9(0x198)]['getCursorPosition']();else AudioManager[_0x4a63c9(0x14d)](_0x36fda4);}const _0x23a949=_0x115db0['SwitchID']||0x0;_0x23a949>0x0&&$gameSwitches['setValue'](_0x23a949,!![]);const _0x4409cf=_0x370faf[_0x4a63c9(0x17c)]||0x0;if(_0x4409cf>0x0){const _0x53c60e=$gameVariables[_0x4a63c9(0x1d0)](_0x4409cf);$gameVariables[_0x4a63c9(0x31a)](_0x4409cf,_0x53c60e+0x1);}const _0x1c237a=_0x115db0['CommonEventID']||0x0;_0x1c237a>0x0&&$onceParallel(_0x1c237a);}else _0x43f316[_0x4a63c9(0x126)][_0x3ad8f2]=_0x4d1f1d[_0x4a63c9(0x1d0)](_0xe6ebd8),this['fulfillOnTriggerPromises'](_0x4a63c9(0x126),_0x390b6b),_0x17b45e[_0x4a63c9(0x175)](_0xdb53b5);}else{if(_0x4a63c9(0x2ce)==='QHqiO'){const _0x367782=_0x370faf[_0x4a63c9(0x2e8)];if(_0x367782&&_0x367782[_0x4a63c9(0x154)]){if(_0x4a63c9(0x2c4)!==_0x4a63c9(0x2c4)){const _0x2b9ff8=_0x3f6a93[_0x4a63c9(0x187)]();if(_0x2b9ff8)_0x2b9ff8[_0x4a63c9(0x108)](_0x4a63c9(0x207));}else AudioManager[_0x4a63c9(0x14d)](_0x367782);}const _0x573db8=_0x370faf[_0x4a63c9(0x1c4)]||0x0;if(_0x573db8>0x0){if('qUmYp'===_0x4a63c9(0x19a)){const _0x22a5be=_0x3f5764(_0x231c62['$1'])[_0x4a63c9(0x2e2)](',')[_0x4a63c9(0x1d8)](_0x5c509d=>_0x23c784(_0x5c509d));this[_0x4a63c9(0x1d4)][_0x45b4fb]=this[_0x4a63c9(0x1d4)][_0x258ad5]||[];for(const _0x4d1f04 of _0x22a5be){this['_triggerSwitches'][_0x6b65f9][_0x4a63c9(0x175)](_0x4d1f04);}_0xee9dfe[_0x4a63c9(0x1f1)](_0x4a7580)&&(_0x51aac8['QTE_TriggerSys'][_0x4a63c9(0x327)][_0x121275]=![]),_0x5cd36b[_0x4a63c9(0x126)][_0x502194]=_0x464e69[_0x4a63c9(0x1f8)](_0x5a3dce['OnChange'],'');}else $onceParallel(_0x573db8);}}else{this[_0x4a63c9(0x30b)]['x']=0.5,this[_0x4a63c9(0x30b)]['y']=0.5;const _0x551074=_0x29dd75[_0x4a63c9(0x23e)];this['x']=_0x551074[_0x4a63c9(0x16a)],this['y']=_0x551074[_0x4a63c9(0x304)],this['_duration']=_0x551074[_0x4a63c9(0x30d)]||0x1,this[_0x4a63c9(0x1fe)]=_0x551074[_0x4a63c9(0x1f6)]||0x1;}}_0x370faf['remainingSequence'][_0x4a63c9(0x193)](_0x115db0),_0x370faf['remainingSequence'][_0x4a63c9(0x326)]<=0x0&&(Input[_0x4a63c9(0x328)](),TouchInput[_0x4a63c9(0x328)](),this[_0x4a63c9(0x276)]());}},SceneManager['updateTimingBarQTE']=function(){const _0x573ead=_0x2ec946,_0x4f8195=this[_0x573ead(0x23e)];if(VisuMZ[_0x573ead(0x310)][_0x573ead(0x145)]()||Input['isTriggered']('ok')||TouchInput[_0x573ead(0x2aa)]()){const _0x4844bc=this[_0x573ead(0x1b4)]['_qteWindow'];_0x4844bc[_0x573ead(0x2ae)]();const _0x40a47e=_0x4844bc[_0x573ead(0x182)](),_0x5c0974=_0x4f8195[_0x573ead(0x1a0)],_0x58ddcc=VisuMZ[_0x573ead(0x310)][_0x573ead(0x145)]()?_0x5c0974[_0x573ead(0x32d)]():_0x5c0974[_0x573ead(0xe0)](_0x15c527=>_0x40a47e>=_0x15c527['Start']&&_0x40a47e<=_0x15c527[_0x573ead(0x2fe)]);Input['clear'](),TouchInput['clear']();if(_0x58ddcc['length']>0x0){const _0x5bce6c=_0x58ddcc['reduce']((_0x28159f,_0x4c4fe3)=>_0x4c4fe3['Points']>_0x28159f['Points']?_0x4c4fe3:_0x28159f),_0x5bbedf=_0x4f8195[_0x573ead(0x1f4)];_0x5bbedf&&_0x5bbedf['name']&&AudioManager[_0x573ead(0x14d)](_0x5bbedf);const _0x155e14=_0x4f8195['switchID']||0x0;_0x155e14>0x0&&$gameSwitches[_0x573ead(0x31a)](_0x155e14,!![]);const _0x33db4f=_0x4f8195[_0x573ead(0x17c)]||0x0;_0x33db4f>0x0&&$gameVariables[_0x573ead(0x31a)](_0x33db4f,_0x5bce6c[_0x573ead(0x1f7)]);const _0x251693=_0x5bce6c[_0x573ead(0x27c)]||0x0;_0x251693>0x0&&$onceParallel(_0x251693);}else{const _0x40ac03=_0x4f8195[_0x573ead(0x2e8)];_0x40ac03&&_0x40ac03[_0x573ead(0x154)]&&AudioManager[_0x573ead(0x14d)](_0x40ac03);const _0x50a4c1=_0x4f8195[_0x573ead(0x106)]||0x0;_0x50a4c1>0x0&&$gameSwitches[_0x573ead(0x31a)](_0x50a4c1,![]);const _0x5c7e38=_0x4f8195[_0x573ead(0x17c)]||0x0;_0x5c7e38>0x0&&$gameVariables[_0x573ead(0x31a)](_0x5c7e38,0x0);const _0x59d6cf=_0x4f8195[_0x573ead(0x1c4)]||0x0;_0x59d6cf>0x0&&$onceParallel(_0x59d6cf);}this[_0x573ead(0x276)]();}},VisuMZ[_0x2ec946(0x310)][_0x2ec946(0x158)]=Game_System[_0x2ec946(0x28a)][_0x2ec946(0x18a)],Game_System[_0x2ec946(0x28a)][_0x2ec946(0x18a)]=function(){const _0x21b23b=_0x2ec946;VisuMZ[_0x21b23b(0x310)]['Game_System_initialize'][_0x21b23b(0xf1)](this),this[_0x21b23b(0x2df)](),this[_0x21b23b(0x14c)]();},Game_System[_0x2ec946(0x28a)][_0x2ec946(0x2df)]=function(){this['init_QTE_TriggerSysReservations'](),this['init_QTE_TriggerSysPromise']();},Game_System[_0x2ec946(0x28a)][_0x2ec946(0x1fa)]=function(){this['_onceParallelQueue']=[];},Game_System['prototype']['reserveOnceParallel']=function(_0x296e90){const _0x476888=_0x2ec946;this[_0x476888(0x257)]===undefined&&(_0x476888(0x2b1)===_0x476888(0xed)?_0x7a4880['playSe'](_0x4d13d9):this[_0x476888(0x1fa)]());if(this[_0x476888(0x257)]['includes'](_0x296e90))return;this['_onceParallelQueue'][_0x476888(0x175)](_0x296e90);},Game_System['prototype'][_0x2ec946(0x1ee)]=function(){const _0x32e539=_0x2ec946;return this[_0x32e539(0x257)]===undefined&&(_0x32e539(0x23c)===_0x32e539(0x197)?_0x4bffc9[_0x32e539(0x14d)](_0x5b3b37):this['init_QTE_TriggerSysReservations']()),this[_0x32e539(0x257)][_0x32e539(0x326)]>0x0;},Game_System[_0x2ec946(0x28a)][_0x2ec946(0x25c)]=function(){const _0x2bd0b5=_0x2ec946;this[_0x2bd0b5(0x257)]===undefined&&this['init_QTE_TriggerSysReservations']();while(this[_0x2bd0b5(0x257)]['length']){const _0x57dc57=this['_onceParallelQueue']['shift']();$onceParallel(_0x57dc57);}},Game_System[_0x2ec946(0x28a)]['init_QTE_TriggerSysPromise']=function(){const _0x2c458a=_0x2ec946;this[_0x2c458a(0x25d)]={'switches':{},'variables':{},'items':{},'weapons':{},'armors':{}},this['_watchedPromises']={'switches':{},'variables':{}};},Game_System['prototype'][_0x2ec946(0x162)]=function(){const _0x2b4027=_0x2ec946;if(this[_0x2b4027(0x25d)]===undefined)this[_0x2b4027(0x1a9)]();return this[_0x2b4027(0x25d)];},Game_System[_0x2ec946(0x28a)][_0x2ec946(0x31f)]=function(){const _0x4617b9=_0x2ec946;if(this[_0x4617b9(0x2a1)]===undefined)this['init_QTE_TriggerSysPromise']();return this[_0x4617b9(0x2a1)];},Game_System[_0x2ec946(0x28a)]['addQTE_TriggerSysPromiseToSet']=function(_0x203253,_0x108f53,_0x2253a5){const _0x13cfc4=_0x2ec946,_0x390c7e=this[_0x13cfc4(0x162)]()[_0x203253];if(!_0x390c7e)return;_0x390c7e[_0x108f53]=_0x390c7e[_0x108f53]||[];for(const _0x38d717 of _0x2253a5){if(_0x390c7e[_0x108f53]['includes'](_0x38d717))continue;_0x390c7e[_0x108f53][_0x13cfc4(0x175)](_0x38d717);}_0x203253==='switches'&&DataManager[_0x13cfc4(0x1f1)](_0x108f53)&&(this['_watchedPromises'][_0x13cfc4(0x126)][_0x108f53]=$gameSwitches['value'](_0x108f53));if(_0x203253===_0x13cfc4(0x2cc)&&DataManager[_0x13cfc4(0x281)](_0x108f53)){if('jBkEg'==='jBkEg')this[_0x13cfc4(0x2a1)]['variables'][_0x108f53]=$gameVariables[_0x13cfc4(0x1d0)](_0x108f53);else{_0x138efa[_0x13cfc4(0x179)]=this[_0x13cfc4(0x33f)],_0x2f2aa7['_baseY']=this[_0x13cfc4(0xda)];const _0x2d64bf=new _0x4b4256(_0x26731a);this['addChild'](_0x2d64bf),this[_0x13cfc4(0x220)][_0x13cfc4(0x18d)](_0x2d64bf);}}},Game_System[_0x2ec946(0x28a)][_0x2ec946(0x2a2)]=function(){const _0x1c34a3=_0x2ec946,_0x3ae06c=this[_0x1c34a3(0x31f)]();{const _0x2e8d80=[];for(const _0x310166 in _0x3ae06c[_0x1c34a3(0x126)]){if(_0x1c34a3(0x2b3)===_0x1c34a3(0x2b3)){const _0x4fc2bc=Number(_0x310166);$gameSwitches[_0x1c34a3(0x1d0)](_0x4fc2bc)!==_0x3ae06c['switches'][_0x310166]&&(_0x3ae06c['switches'][_0x310166]=$gameSwitches[_0x1c34a3(0x1d0)](_0x4fc2bc),this['fulfillOnTriggerPromises'](_0x1c34a3(0x126),_0x4fc2bc),_0x2e8d80[_0x1c34a3(0x175)](_0x4fc2bc));}else _0x39e730[_0x1c34a3(0x28a)][_0x1c34a3(0x1c8)][_0x1c34a3(0xf1)](this),this['_labelMode']&&(this[_0x1c34a3(0x2c0)][_0x1c34a3(0x171)]=_0x48b0a9[_0x1c34a3(0x164)](),this[_0x1c34a3(0x2c0)][_0x1c34a3(0x2f1)]=_0xffcab1['QTE_TriggerSys']['Settings'][_0x1c34a3(0x207)][_0x1c34a3(0x331)]||_0x198913[_0x1c34a3(0x101)]());}while(_0x2e8d80[_0x1c34a3(0x326)]>0x0){if(_0x1c34a3(0x17e)!==_0x1c34a3(0x2f0)){const _0x3166f9=_0x2e8d80[_0x1c34a3(0x22b)]();$gameSystem[_0x1c34a3(0x153)](_0x1c34a3(0x126),_0x3166f9);}else this[_0x1c34a3(0x262)](this['_qteTimerWindow']),this[_0x1c34a3(0x157)]=_0x1f75ea;}}{if('WCCRa'==='axqeK')_0x417a99[_0x1c34a3(0x310)][_0x1c34a3(0x25e)][_0x38f26d]=0x0;else{const _0x211f58=[];for(const _0x24ae65 in _0x3ae06c[_0x1c34a3(0x2cc)]){const _0x538663=Number(_0x24ae65);0x4d;if($gameVariables[_0x1c34a3(0x1d0)](_0x538663)!==_0x3ae06c['variables'][_0x24ae65]){if(_0x1c34a3(0xe5)==='iTLcN'){const _0x46c5fb=_0x5c44dd[_0x1c34a3(0x310)][_0x1c34a3(0x1c2)][_0x1c34a3(0x207)],_0x2edbd5=_0x46c5fb[_0x1c34a3(0x2cd)]||0x64,_0x5194d9=0xc,_0x4cb501=_0x5e30e1[_0x1c34a3(0x138)]((this['parent']['innerWidth']-_0x2edbd5)/0x2)+this[_0x1c34a3(0x15f)][_0x1c34a3(0x19c)],_0x1d64ec=this[_0x1c34a3(0x15f)][_0x1c34a3(0x320)]()-_0x5194d9-0x2+this['parent'][_0x1c34a3(0x19c)],_0x1363af=_0x46c5fb[_0x1c34a3(0x31d)]||0x0,_0xfe608a=_0x46c5fb[_0x1c34a3(0x33c)]||0x0;this['x']=_0x4cb501+this[_0x1c34a3(0x144)]+_0x1363af,this['y']=_0x1d64ec+_0xfe608a;}else _0x3ae06c[_0x1c34a3(0x2cc)][_0x24ae65]=$gameVariables[_0x1c34a3(0x1d0)](_0x538663),this[_0x1c34a3(0x1c5)](_0x1c34a3(0x2cc),_0x538663),_0x211f58[_0x1c34a3(0x175)](_0x538663);}}while(_0x211f58[_0x1c34a3(0x326)]>0x0){const _0x144e39=_0x211f58[_0x1c34a3(0x22b)]();$gameSystem['clearWatchedTrigger']('variables',_0x144e39);}}}},Game_System[_0x2ec946(0x28a)]['hasOnTriggerPromise']=function(_0x49464a,_0x4740ce){const _0x3b2315=_0x2ec946,_0x5a14f4=this[_0x3b2315(0x162)]()[_0x49464a];if(!_0x5a14f4)return![];return _0x5a14f4[_0x4740ce]=_0x5a14f4[_0x4740ce]||[],_0x5a14f4[_0x4740ce][_0x3b2315(0x326)]>0x0;},Game_System[_0x2ec946(0x28a)]['hasOnTriggerPromiseItem']=function(_0x2f15ea){const _0xb66d31=_0x2ec946;if(DataManager['isItem'](_0x2f15ea))return'aSXeE'!==_0xb66d31(0x2eb)?this[_0xb66d31(0x2d0)](_0xb66d31(0x1be),_0x2f15ea['id']):!![];else{if(DataManager[_0xb66d31(0x14b)](_0x2f15ea)){if('TRmIR'!==_0xb66d31(0x284))this[_0xb66d31(0x1d4)][_0x1a3237][_0xb66d31(0x175)](_0x4ed087);else return this[_0xb66d31(0x2d0)](_0xb66d31(0x25f),_0x2f15ea['id']);}else{if(DataManager[_0xb66d31(0x1ab)](_0x2f15ea)){if(_0xb66d31(0x1bd)!==_0xb66d31(0xff))return this[_0xb66d31(0x2d0)](_0xb66d31(0x1a5),_0x2f15ea['id']);else _0x18a38a['reserveOnceParallel'](_0x4b17ed);}}}return![];},Game_System[_0x2ec946(0x28a)][_0x2ec946(0x1c5)]=function(_0x4d00c3,_0xc9b6){const _0x54d2af=_0x2ec946,_0x1862c2=this['getQTE_TriggerSysPromises']()[_0x4d00c3];if(!_0x1862c2)return![];const _0x38f2ba=_0x1862c2[_0xc9b6]||[];for(const _0x29f52c of _0x38f2ba){if(_0x54d2af(0x31c)===_0x54d2af(0x118)){const _0x7a60f3=_0x3d8f00[_0x54d2af(0x1f4)];_0x7a60f3&&_0x7a60f3[_0x54d2af(0x154)]&&_0x5383e5[_0x54d2af(0x14d)](_0x7a60f3);const _0x9a6f84=_0x4f6592[_0x54d2af(0x1b3)]||0x0;_0x9a6f84>0x0&&_0x22c05c(_0x9a6f84);}else VisuMZ[_0x54d2af(0x310)][_0x54d2af(0x1c6)](_0x29f52c);}delete _0x1862c2[_0xc9b6];},Game_System[_0x2ec946(0x28a)][_0x2ec946(0x1b9)]=function(_0xbdc609){const _0x5a2da4=_0x2ec946;if(DataManager[_0x5a2da4(0x1c0)](_0xbdc609))this['fulfillOnTriggerPromises']('items',_0xbdc609['id']);else{if(DataManager[_0x5a2da4(0x14b)](_0xbdc609))this[_0x5a2da4(0x1c5)]('weapons',_0xbdc609['id']);else{if(DataManager[_0x5a2da4(0x1ab)](_0xbdc609)){if(_0x5a2da4(0x1a4)!==_0x5a2da4(0x18e))this[_0x5a2da4(0x1c5)](_0x5a2da4(0x1a5),_0xbdc609['id']);else{this[_0x5a2da4(0x2f8)]=0x0;const _0x537be2=_0x19c563[_0x5a2da4(0x310)][_0x5a2da4(0x23d)],_0x27c751=_0x1b003e?_0x3aff1f['note']||'':'';_0x27c751[_0x5a2da4(0x2be)](_0x537be2[_0x5a2da4(0x2d5)])&&(this[_0x5a2da4(0x2f8)]=_0xa17065(_0x58235d['$1']));}}}}},Game_System[_0x2ec946(0x28a)][_0x2ec946(0x153)]=function(_0x5bec45,_0x5daabd){const _0x153ce0=this['getWatchedTriggerPromises']()[_0x5bec45];if(!_0x153ce0)return;delete _0x153ce0[_0x5daabd];},Game_System[_0x2ec946(0x28a)][_0x2ec946(0x14c)]=function(){const _0x2253e0=_0x2ec946;this['_gameOverCommonEventID']=VisuMZ[_0x2253e0(0x310)][_0x2253e0(0x1c2)][_0x2253e0(0x250)][_0x2253e0(0x12f)]||0x0;},Game_System[_0x2ec946(0x28a)][_0x2ec946(0x11b)]=function(){const _0x5c18a3=_0x2ec946;if(this[_0x5c18a3(0xfa)]===undefined)this[_0x5c18a3(0x14c)]();return this[_0x5c18a3(0xfa)];},Game_System[_0x2ec946(0x28a)][_0x2ec946(0x12a)]=function(_0x134fa3){const _0x42be38=_0x2ec946;if(this[_0x42be38(0xfa)]===undefined)this[_0x42be38(0x14c)]();this[_0x42be38(0xfa)]=_0x134fa3;},VisuMZ[_0x2ec946(0x310)][_0x2ec946(0x2ca)]=Game_Switches[_0x2ec946(0x28a)]['setValue'],Game_Switches['prototype'][_0x2ec946(0x31a)]=function(_0x40f830,_0x105cbc){const _0x32443d=_0x2ec946,_0x675ff3=this[_0x32443d(0x1d0)](_0x40f830);VisuMZ[_0x32443d(0x310)][_0x32443d(0x2ca)][_0x32443d(0xf1)](this,_0x40f830,_0x105cbc),_0x675ff3!==this[_0x32443d(0x1d0)](_0x40f830)&&(VisuMZ[_0x32443d(0x310)][_0x32443d(0x20d)](_0x40f830),$gameSystem[_0x32443d(0x2d0)]('switches',_0x40f830)&&$gameSystem[_0x32443d(0x1c5)]('switches',_0x40f830));},VisuMZ['QTE_TriggerSys'][_0x2ec946(0x2db)]=Game_Variables[_0x2ec946(0x28a)][_0x2ec946(0x31a)],Game_Variables['prototype']['setValue']=function(_0x5a31cb,_0x210600){const _0x48468d=_0x2ec946,_0x55f7ad=this[_0x48468d(0x1d0)](_0x5a31cb);VisuMZ[_0x48468d(0x310)]['Game_Variables_setValue'][_0x48468d(0xf1)](this,_0x5a31cb,_0x210600),_0x55f7ad!==this[_0x48468d(0x1d0)](_0x5a31cb)&&(VisuMZ[_0x48468d(0x310)][_0x48468d(0x287)](_0x5a31cb),$gameSystem[_0x48468d(0x2d0)](_0x48468d(0x2cc),_0x5a31cb)&&$gameSystem[_0x48468d(0x1c5)](_0x48468d(0x2cc),_0x5a31cb));},VisuMZ[_0x2ec946(0x310)][_0x2ec946(0xef)]=Game_Party[_0x2ec946(0x28a)][_0x2ec946(0x13a)],Game_Party[_0x2ec946(0x28a)][_0x2ec946(0x13a)]=function(_0x5d2d72,_0x4cd071,_0x16f4ae){const _0x1e3eec=_0x2ec946,_0x4feeed=_0x5d2d72?this[_0x1e3eec(0x225)](_0x5d2d72):0x0;VisuMZ[_0x1e3eec(0x310)][_0x1e3eec(0xef)][_0x1e3eec(0xf1)](this,_0x5d2d72,_0x4cd071,_0x16f4ae);if(_0x5d2d72&&_0x4feeed!==this[_0x1e3eec(0x225)](_0x5d2d72)){if(_0x1e3eec(0xf2)!=='rASJx'){DataManager[_0x1e3eec(0x30f)](_0x5d2d72)&&VisuMZ[_0x1e3eec(0x310)][_0x1e3eec(0x1ed)](_0x5d2d72);if($gameSystem['hasOnTriggerPromiseItem'](_0x5d2d72)){if(_0x1e3eec(0x16c)!==_0x1e3eec(0x2c5))$gameSystem['fulfillOnTriggerPromisesItem'](_0x5d2d72);else{if(!this['_triggerSwitches'][_0x1baa6c])return;const _0x1330c9=this[_0x1e3eec(0x1d4)][_0x333087];for(const _0x5e2863 of _0x1330c9){this['processCommonEvent'](_0x5e2863);}}}}else{_0x57d688[_0x1e3eec(0x193)](_0x4956b1);const _0x88e1b6=_0x1100c0[_0x1e3eec(0x2e8)];_0x88e1b6&&_0x88e1b6[_0x1e3eec(0x154)]&&_0x3d6002[_0x1e3eec(0x14d)](_0x88e1b6);const _0x28c9a6=_0x2a1bf7[_0x1e3eec(0x1c4)]||0x0;_0x28c9a6>0x0&&_0x167f63(_0x28c9a6);}}},VisuMZ['QTE_TriggerSys']['Game_Map_setup']=Game_Map[_0x2ec946(0x28a)]['setup'],Game_Map[_0x2ec946(0x28a)][_0x2ec946(0x264)]=function(_0x137fe3){const _0x10c400=_0x2ec946;VisuMZ[_0x10c400(0x310)][_0x10c400(0x1ea)][_0x10c400(0xf1)](this,_0x137fe3),this[_0x10c400(0x1e6)]();},Game_Map[_0x2ec946(0x28a)][_0x2ec946(0x1e6)]=function(){const _0x15869c=_0x2ec946;this[_0x15869c(0x2f8)]=0x0;const _0x5c7e6e=VisuMZ[_0x15869c(0x310)]['RegExp'],_0x44be20=$dataMap?$dataMap[_0x15869c(0x20b)]||'':'';_0x44be20['match'](_0x5c7e6e[_0x15869c(0x2d5)])&&(_0x15869c(0x115)!==_0x15869c(0x115)?_0x2d2456['setValue'](_0x435f9f,_0x198e3c-0x1):this['_mapGameOverCommonEventID']=Number(RegExp['$1']));},Game_Map[_0x2ec946(0x28a)][_0x2ec946(0x11b)]=function(){const _0x56cc7d=_0x2ec946;if(this[_0x56cc7d(0x2f8)]===undefined)this['setupGameOverCommonEvent']();return this[_0x56cc7d(0x2f8)];},Game_Player[_0x2ec946(0x28a)]['getGameOverCommonEventID']=function(){const _0x115ab0=_0x2ec946;if(BattleManager[_0x115ab0(0x1cb)]())return 0x0;if($gameTroop&&$gameTroop[_0x115ab0(0x11b)]()){if(_0x115ab0(0x2dc)!==_0x115ab0(0x2f4))return $gameTroop[_0x115ab0(0x11b)]();else{_0x4c12e3[_0x115ab0(0x253)](_0x3f80d3,_0x336bad);const _0x50cedf=_0x471185[_0x115ab0(0x21c)]||0x0;if(_0x50cedf<=0x0)return;const _0x150a14=_0x1d0851['CommonEventIDs']||[],_0xbe3cc4=_0x115ab0(0x1a5);_0x1fc56f[_0x115ab0(0x229)](_0xbe3cc4,_0x50cedf,_0x150a14);}}if($gameMap&&$gameMap[_0x115ab0(0x11b)]())return $gameMap[_0x115ab0(0x11b)]();if($gameSystem&&$gameSystem[_0x115ab0(0x11b)]()){if(_0x115ab0(0x2cf)===_0x115ab0(0x2cf))return $gameSystem[_0x115ab0(0x11b)]();else this[_0x115ab0(0x1fa)]();}return 0x0;},Game_Party[_0x2ec946(0x28a)][_0x2ec946(0x319)]=function(){const _0x2aae73=_0x2ec946;if(!VisuMZ[_0x2aae73(0x310)][_0x2aae73(0x1c2)][_0x2aae73(0x250)][_0x2aae73(0x185)])return;for(const _0x26750c of this[_0x2aae73(0x2a5)]()){if('vuopo'===_0x2aae73(0x1c7)){_0x3831b6[_0x2aae73(0x328)](),_0x2aa7fc[_0x2aae73(0x328)]();const _0x58a83a=_0x940184[_0x2aae73(0x1cd)];_0x58a83a&&_0x58a83a[_0x2aae73(0x154)]&&_0x4e509f[_0x2aae73(0x14d)](_0x58a83a);const _0x31b870=_0x164379[_0x2aae73(0x106)]||0x0;_0x31b870>0x0&&_0x1766bc[_0x2aae73(0x31a)](_0x31b870,![]);const _0x5c5a9e=_0x573585['varID']||0x0;_0x5c5a9e>0x0&&_0x3c784a['setValue'](_0x5c5a9e,0x0),this[_0x2aae73(0x276)]();}else _0x26750c['setHp'](0x1);}},Game_Troop[_0x2ec946(0x28a)][_0x2ec946(0x11b)]=function(){const _0x117add=_0x2ec946,_0x353662=VisuMZ[_0x117add(0x310)]['RegExp'],_0x42b0b5=this['troop']()?this[_0x117add(0x14e)]()[_0x117add(0x154)]||'':'';if(_0x42b0b5[_0x117add(0x2be)](_0x353662[_0x117add(0x2d5)])){if(_0x117add(0x307)===_0x117add(0x1ba))_0x172058(_0x3c681f);else return Number(RegExp['$1']);}return 0x0;},VisuMZ[_0x2ec946(0x310)][_0x2ec946(0xdf)]=Game_Interpreter[_0x2ec946(0x28a)]['setupReservedCommonEvent'],Game_Interpreter[_0x2ec946(0x28a)][_0x2ec946(0x121)]=function(){const _0x39a162=_0x2ec946;return $gameSystem['isOnceParallelReserved']()&&$gameSystem[_0x39a162(0x25c)](),VisuMZ[_0x39a162(0x310)][_0x39a162(0xdf)][_0x39a162(0xf1)](this);},VisuMZ[_0x2ec946(0x310)][_0x2ec946(0x109)]=Game_Interpreter[_0x2ec946(0x28a)][_0x2ec946(0x1b1)],Game_Interpreter[_0x2ec946(0x28a)][_0x2ec946(0x1b1)]=function(){const _0x19b2f4=_0x2ec946;if(this[_0x19b2f4(0x318)][_0x19b2f4(0x2be)](/QTE/i)){if('qixwf'!==_0x19b2f4(0x11c))return this[_0x19b2f4(0x2d0)]('armors',_0x58ec14['id']);else{if(SceneManager['isPlayingQTE']()){if(_0x19b2f4(0x131)===_0x19b2f4(0x131))return!![];else this[_0x19b2f4(0x14f)]();}else{if(_0x19b2f4(0x222)===_0x19b2f4(0x339)){if(!this[_0x19b2f4(0x28f)][_0x563153])return;const _0x2a4d9f=this[_0x19b2f4(0x28f)][_0x489c82];for(const _0x400b81 of _0x2a4d9f){this['processCommonEvent'](_0x400b81);}}else this[_0x19b2f4(0x318)]='';}}}return VisuMZ[_0x19b2f4(0x310)][_0x19b2f4(0x109)][_0x19b2f4(0xf1)](this);},Scene_Base[_0x2ec946(0x28a)]['setupMessageForQTE']=function(_0x2c8784){const _0x28b43e=_0x2ec946,_0x3e48e3=VisuMZ[_0x28b43e(0x310)]['Settings'][_0x28b43e(0x258)],_0x307321={};_0x307321[_0x28b43e(0x2bc)]=_0x3e48e3[_0x28b43e(0x265)]||_0x28b43e(0x201),_0x307321[_0x28b43e(0x170)]=_0x3e48e3[_0x28b43e(0x226)],_0x307321[_0x28b43e(0x26c)]=_0x3e48e3[_0x28b43e(0x13e)]||0x0;switch(_0x2c8784){case _0x28b43e(0x19d):_0x307321['text']=_0x3e48e3[_0x28b43e(0x244)]||'';break;case _0x28b43e(0x178):_0x307321[_0x28b43e(0x15b)]=_0x3e48e3[_0x28b43e(0xe6)]||'';break;case _0x28b43e(0x2f2):_0x307321['text']=_0x3e48e3[_0x28b43e(0x269)]||'';break;case _0x28b43e(0x309):_0x307321[_0x28b43e(0x15b)]=_0x3e48e3[_0x28b43e(0x232)]||'';break;case _0x28b43e(0x1bf):_0x307321[_0x28b43e(0x15b)]=_0x3e48e3[_0x28b43e(0x1e1)]||'';break;case _0x28b43e(0x1f2):_0x307321[_0x28b43e(0x15b)]=_0x3e48e3[_0x28b43e(0x2a7)]||'';break;case _0x28b43e(0x288):_0x307321[_0x28b43e(0x15b)]=_0x3e48e3[_0x28b43e(0x223)]||'';break;case _0x28b43e(0x208):_0x307321[_0x28b43e(0x15b)]=_0x3e48e3[_0x28b43e(0x16b)]||'';break;case _0x28b43e(0x15c):_0x307321[_0x28b43e(0x15b)]=_0x3e48e3[_0x28b43e(0x103)]||'';break;case _0x28b43e(0xf6):_0x307321[_0x28b43e(0x15b)]=_0x3e48e3['TimingBarTextMsg']||'';break;default:return;}this['createMessageWindowForQTE'](_0x2c8784,_0x307321),this['createGaugeTimerWindowForQTE'](_0x2c8784),this[_0x28b43e(0x255)](_0x2c8784),this['updateQteWindowText']();},Scene_Base[_0x2ec946(0x28a)]['createMessageWindowForQTE']=function(_0x355438,_0x2d47e0){const _0x5e2a25=_0x2ec946;this['_qteSettings']=_0x2d47e0;const _0x486e7e=_0x2d47e0[_0x5e2a25(0x170)]['call'](this);let _0x50c024=null;switch(_0x355438){case _0x5e2a25(0x19d):case _0x5e2a25(0x2f2):case _0x5e2a25(0x309):case _0x5e2a25(0x1bf):case _0x5e2a25(0x1f2):case _0x5e2a25(0x288):case _0x5e2a25(0x208):if(_0x2d47e0[_0x5e2a25(0x15b)]==='')return;_0x50c024=new Window_Help(_0x486e7e);break;case _0x5e2a25(0x178):_0x50c024=new Window_QTE_ButtonSequence(_0x486e7e);break;case'timedSequence':_0x50c024=new Window_QTE_TimedSequence(_0x486e7e);break;case _0x5e2a25(0xf6):_0x50c024=new Window_QTE_TimingBar(_0x486e7e);break;default:return;}_0x50c024['setBackgroundType'](_0x2d47e0[_0x5e2a25(0x26c)]),this['addChild'](_0x50c024),this['_qteWindow']=_0x50c024;},Scene_Base[_0x2ec946(0x28a)]['updateQteWindowText']=function(){const _0x13f6b8=_0x2ec946,_0x184674=this[_0x13f6b8(0x23e)];let _0x42e0bf=_0x184674[_0x13f6b8(0x15b)];_0x42e0bf=_0x42e0bf[_0x13f6b8(0x1f8)](/<UP BUTTON>/gi,TextManager[_0x13f6b8(0x27a)]('up')),_0x42e0bf=_0x42e0bf[_0x13f6b8(0x1f8)](/<DOWN BUTTON>/gi,TextManager['getInputButtonString']('down')),_0x42e0bf=_0x42e0bf['replace'](/<LEFT BUTTON>/gi,TextManager[_0x13f6b8(0x27a)](_0x13f6b8(0x113))),_0x42e0bf=_0x42e0bf[_0x13f6b8(0x1f8)](/<RIGHT BUTTON>/gi,TextManager[_0x13f6b8(0x27a)](_0x13f6b8(0x1d2))),_0x42e0bf=_0x42e0bf['replace'](/<OK BUTTON>/gi,TextManager[_0x13f6b8(0x27a)]('ok')),_0x42e0bf=_0x42e0bf[_0x13f6b8(0x1f8)](/<CANCEL BUTTON>/gi,TextManager[_0x13f6b8(0x27a)]('cancel')),_0x42e0bf=_0x42e0bf[_0x13f6b8(0x1f8)](/<SHIFT BUTTON>/gi,TextManager[_0x13f6b8(0x27a)](_0x13f6b8(0x22b))),_0x42e0bf=_0x42e0bf[_0x13f6b8(0x1f8)](/<MENU BUTTON>/gi,TextManager[_0x13f6b8(0x27a)](_0x13f6b8(0xcc))),_0x42e0bf=_0x42e0bf[_0x13f6b8(0x1f8)](/<PAGE UP BUTTON>/gi,TextManager[_0x13f6b8(0x27a)](_0x13f6b8(0x20f))),_0x42e0bf=_0x42e0bf[_0x13f6b8(0x1f8)](/<PAGE DOWN BUTTON>/gi,TextManager['getInputButtonString'](_0x13f6b8(0x239))),this[_0x13f6b8(0x300)]=Input[_0x13f6b8(0x324)]();if(Imported[_0x13f6b8(0x105)]){if(_0x13f6b8(0x13d)===_0x13f6b8(0x13d))_0x42e0bf='<%1>%2'['format'](_0x184674[_0x13f6b8(0x2bc)],_0x42e0bf);else{if(_0x45e89e!==0x1)return;}}const _0x4a7aa6=this[_0x13f6b8(0x15a)];if(_0x4a7aa6)_0x4a7aa6[_0x13f6b8(0x12d)](_0x42e0bf);},Scene_Base['prototype'][_0x2ec946(0x28e)]=function(_0x4074ff){const _0x3e0c6e=_0x2ec946,_0x33109f=VisuMZ[_0x3e0c6e(0x310)][_0x3e0c6e(0x1c2)][_0x3e0c6e(0x207)];if(!_0x33109f[_0x3e0c6e(0x312)])return;if([_0x3e0c6e(0x1bf),_0x3e0c6e(0x208),_0x3e0c6e(0x15c)]['includes'](_0x4074ff))return;if(SceneManager[_0x3e0c6e(0x19f)]>=0xf4240)return;const _0x5c4395=_0x33109f[_0x3e0c6e(0x1ac)][_0x3e0c6e(0xf1)](this),_0x1db62d=new Window_QTE_Timer(_0x5c4395);this[_0x3e0c6e(0x160)](_0x1db62d),this['_qteTimerWindow']=_0x1db62d;},Scene_Base[_0x2ec946(0x28a)]['createGaugeProgressWindowForQTE']=function(_0x28cc19){const _0x25a086=_0x2ec946,_0x45b987=VisuMZ['QTE_TriggerSys'][_0x25a086(0x1c2)][_0x25a086(0x207)];if(!_0x45b987[_0x25a086(0x217)]&&![_0x25a086(0x1bf)][_0x25a086(0x31b)](_0x28cc19))return;if(!SceneManager[_0x25a086(0x23e)][_0x25a086(0x32c)])return;const _0x379843=_0x45b987[_0x25a086(0x1aa)][_0x25a086(0xf1)](this),_0x289d44=new Window_QTE_Progress(_0x379843);this[_0x25a086(0x160)](_0x289d44),this[_0x25a086(0x1a7)]=_0x289d44;},Scene_Base[_0x2ec946(0x28a)]['createTimedHitSpriteQTE']=function(){const _0x7c0747=_0x2ec946,_0x166a79=new Sprite_QTE_TimedHit();this['addChild'](_0x166a79),this[_0x7c0747(0x33a)]=_0x166a79;},VisuMZ[_0x2ec946(0x310)][_0x2ec946(0x219)]=Scene_Base[_0x2ec946(0x28a)][_0x2ec946(0x30a)],Scene_Base[_0x2ec946(0x28a)][_0x2ec946(0x30a)]=function(){const _0x802b44=_0x2ec946;this['updateQteWindow'](),VisuMZ[_0x802b44(0x310)]['Scene_Base_update'][_0x802b44(0xf1)](this),this[_0x802b44(0x2a6)](),this[_0x802b44(0x10b)]();},Scene_Base['prototype']['updateQteWindow']=function(){const _0x393a8c=_0x2ec946;if(!this['_qteWindow'])return;this[_0x393a8c(0x300)]!==Input[_0x393a8c(0x324)]()&&this[_0x393a8c(0x14f)](),!SceneManager['isPlayingQTE']()&&this[_0x393a8c(0x261)]();},Scene_Base['prototype'][_0x2ec946(0x261)]=function(){const _0x436824=_0x2ec946;if(!this['_qteWindow'])return;this[_0x436824(0x262)](this[_0x436824(0x15a)]),this['_qteWindow']=undefined;},Scene_Base[_0x2ec946(0x28a)][_0x2ec946(0x2a6)]=function(){const _0x19a993=_0x2ec946;if(!SceneManager[_0x19a993(0x22d)]())return;SceneManager[_0x19a993(0x21d)]();},Scene_Base[_0x2ec946(0x28a)]['updateQteGaugeWindows']=function(){const _0x38029d=_0x2ec946;if(SceneManager[_0x38029d(0x22d)]())return;this[_0x38029d(0x157)]&&(this[_0x38029d(0x262)](this[_0x38029d(0x157)]),this['_qteTimerWindow']=undefined),this['_qteProgressWindow']&&(_0x38029d(0x2a3)!==_0x38029d(0x2a3)?this[_0x38029d(0x1db)]():(this['removeChild'](this[_0x38029d(0x1a7)]),this[_0x38029d(0x1a7)]=undefined)),this['_qteTimedHitSprite']&&(this[_0x38029d(0x33a)][_0x38029d(0x120)](),this['_qteTimedHitSprite']=undefined);},VisuMZ[_0x2ec946(0x310)]['Scene_Map_start']=Scene_Map['prototype'][_0x2ec946(0x20c)],Scene_Map[_0x2ec946(0x28a)][_0x2ec946(0x20c)]=function(){const _0x548c24=_0x2ec946;VisuMZ['QTE_TriggerSys'][_0x548c24(0x1b6)]['call'](this);if($gameTroop)$gameTroop[_0x548c24(0x328)]();},VisuMZ[_0x2ec946(0x310)][_0x2ec946(0xe9)]=Scene_Map[_0x2ec946(0x28a)]['needsFadeIn'],Scene_Map[_0x2ec946(0x28a)][_0x2ec946(0x194)]=function(){const _0x178ed8=_0x2ec946;return VisuMZ[_0x178ed8(0x310)][_0x178ed8(0xe9)]['call'](this)||SceneManager[_0x178ed8(0x27b)](Scene_Gameover);},VisuMZ['QTE_TriggerSys']['Scene_Gameover_create']=Scene_Gameover[_0x2ec946(0x28a)][_0x2ec946(0x2e7)],Scene_Gameover[_0x2ec946(0x28a)][_0x2ec946(0x2e7)]=function(){const _0x261b2b=_0x2ec946;if(this[_0x261b2b(0x1ca)]())return;VisuMZ[_0x261b2b(0x310)][_0x261b2b(0xf4)]['call'](this);},VisuMZ[_0x2ec946(0x310)][_0x2ec946(0x1e5)]=Scene_Gameover[_0x2ec946(0x28a)][_0x2ec946(0x20c)],Scene_Gameover[_0x2ec946(0x28a)]['start']=function(){const _0x34e211=_0x2ec946;if(this['hasGameOverEvent']())this[_0x34e211(0x2ea)]();else{if(_0x34e211(0xe8)===_0x34e211(0xe8))VisuMZ[_0x34e211(0x310)][_0x34e211(0x1e5)][_0x34e211(0xf1)](this);else return this[_0x34e211(0x257)]===_0x429bb4&&this['init_QTE_TriggerSysReservations'](),this[_0x34e211(0x257)][_0x34e211(0x326)]>0x0;}},Scene_Gameover[_0x2ec946(0x28a)][_0x2ec946(0x1ca)]=function(){const _0x4cefbe=_0x2ec946;return $gamePlayer&&$gamePlayer[_0x4cefbe(0x11b)]()>0x0;},Scene_Gameover[_0x2ec946(0x28a)][_0x2ec946(0x2ea)]=function(){const _0x1389fd=_0x2ec946;Scene_Base['prototype']['start'][_0x1389fd(0xf1)](this);if($gameParty){if(_0x1389fd(0x102)===_0x1389fd(0x102))$gameParty[_0x1389fd(0x319)]();else{if(this[_0x1389fd(0x25d)]===_0x5bdb96)this[_0x1389fd(0x1a9)]();return this[_0x1389fd(0x25d)];}}$gameMap&&$gameMap['_interpreter']['clear']();SceneManager['goto'](Scene_Map);const _0x30876d=$gamePlayer[_0x1389fd(0x11b)]();$gameTemp['reserveCommonEvent'](_0x30876d);$gameTroop&&$gameTroop[_0x1389fd(0x328)]();if(VisuMZ['QTE_TriggerSys'][_0x1389fd(0x1c2)][_0x1389fd(0x250)]['ClearOnEvent']){if(_0x1389fd(0x2b7)===_0x1389fd(0x2fb)){const _0x3f9e5e=this[_0x1389fd(0x31f)]()[_0x3e3d47];if(!_0x3f9e5e)return;delete _0x3f9e5e[_0x400353];}else $gameSystem[_0x1389fd(0x12a)](0x0);}};function Sprite_QTE_TimedHit(){const _0x48aebd=_0x2ec946;this[_0x48aebd(0x18a)](...arguments);}Sprite_QTE_TimedHit[_0x2ec946(0x28a)]=Object[_0x2ec946(0x2e7)](Sprite[_0x2ec946(0x28a)]),Sprite_QTE_TimedHit[_0x2ec946(0x28a)]['constructor']=Sprite_QTE_TimedHit,Sprite_QTE_TimedHit[_0x2ec946(0x28a)]['initialize']=function(){const _0x231ffb=_0x2ec946;Sprite['prototype'][_0x231ffb(0x18a)][_0x231ffb(0xf1)](this),this[_0x231ffb(0x10d)](),this[_0x231ffb(0x334)](),this[_0x231ffb(0x27e)]();},Sprite_QTE_TimedHit['prototype'][_0x2ec946(0x10d)]=function(){const _0x4156e5=_0x2ec946;this[_0x4156e5(0x30b)]['x']=0.5,this[_0x4156e5(0x30b)]['y']=0.5;const _0x3dc26a=SceneManager[_0x4156e5(0x23e)];this['x']=_0x3dc26a[_0x4156e5(0x16a)],this['y']=_0x3dc26a[_0x4156e5(0x304)],this[_0x4156e5(0x16d)]=_0x3dc26a['duration']||0x1,this['_wholeDuration']=_0x3dc26a[_0x4156e5(0x1f6)]||0x1;},Sprite_QTE_TimedHit['prototype'][_0x2ec946(0x334)]=function(){const _0x172c94=_0x2ec946,_0xbe20be=SceneManager[_0x172c94(0x23e)];this[_0x172c94(0x233)]=ImageManager[_0x172c94(0x29e)](_0xbe20be[_0x172c94(0x215)]);},Sprite_QTE_TimedHit['prototype'][_0x2ec946(0x27e)]=function(){const _0x5c3b13=_0x2ec946,_0x57c50a=VisuMZ['QTE_TriggerSys'][_0x5c3b13(0x1c2)][_0x5c3b13(0x207)],_0x170518=new Sprite(),_0x3c9b3d=SceneManager[_0x5c3b13(0x23e)][_0x5c3b13(0x215)];_0x170518[_0x5c3b13(0x233)]=ImageManager['loadPicture'](_0x3c9b3d),_0x170518[_0x5c3b13(0x133)]=_0x57c50a['TimedHitOpacity']??0x80,_0x170518[_0x5c3b13(0x30b)]['x']=0.5,_0x170518[_0x5c3b13(0x30b)]['y']=0.5,_0x170518['scale']['x']=_0x57c50a['TimedHitMaxSize']??0x4,_0x170518['scale']['y']=_0x57c50a[_0x5c3b13(0x152)]??0x4,this[_0x5c3b13(0x160)](_0x170518),this['_overlaySprite']=_0x170518;},Sprite_QTE_TimedHit[_0x2ec946(0x28a)][_0x2ec946(0x30a)]=function(){const _0xf919f5=_0x2ec946;Sprite[_0xf919f5(0x28a)][_0xf919f5(0x30a)][_0xf919f5(0xf1)](this);if(this[_0xf919f5(0x143)]())'vUIYS'!==_0xf919f5(0x2e0)?this[_0xf919f5(0x190)][_0xf919f5(0x175)](_0x14f051['id']):(this[_0xf919f5(0x23f)](),this[_0xf919f5(0x32f)]());else(SceneManager['isEarlyFinishQTE']()||this[_0xf919f5(0x112)])&&('NZMbr'!=='NZMbr'?_0x7a315c[_0xf919f5(0x310)][_0xf919f5(0x1c6)](_0x4ee154):this[_0xf919f5(0x29a)]());},Sprite_QTE_TimedHit['prototype'][_0x2ec946(0x143)]=function(){const _0x1eade3=_0x2ec946;if(!this[_0x1eade3(0x15f)])return![];if(SceneManager[_0x1eade3(0xd9)]>0x0)return![];if(this[_0x1eade3(0x20a)])return![];return!![];},Sprite_QTE_TimedHit[_0x2ec946(0x28a)]['updateOverlayScale']=function(){const _0x169a34=_0x2ec946;if(this[_0x169a34(0x16d)]<=0x0)return;const _0x52d5a4=this[_0x169a34(0x231)],_0x5df150=this[_0x169a34(0x16d)];_0x52d5a4[_0x169a34(0xcd)]['x']=(_0x52d5a4['scale']['x']*(_0x5df150-0x1)+0x1)/_0x5df150,_0x52d5a4[_0x169a34(0xcd)]['y']=(_0x52d5a4[_0x169a34(0xcd)]['y']*(_0x5df150-0x1)+0x1)/_0x5df150,this[_0x169a34(0x16d)]--,this['_duration']<=0x0&&(_0x52d5a4[_0x169a34(0x133)]=0x0,_0x52d5a4[_0x169a34(0xcd)]['x']=0x1,_0x52d5a4[_0x169a34(0xcd)]['y']=0x1);},Sprite_QTE_TimedHit[_0x2ec946(0x28a)]['checkEarlyFinishQTE']=function(){const _0x2bd5f9=_0x2ec946;if(!SceneManager[_0x2bd5f9(0x313)]())return;this[_0x2bd5f9(0x20a)]=!![];},Sprite_QTE_TimedHit[_0x2ec946(0x28a)]['updateEarlyFinish']=function(){const _0x10123c=_0x2ec946,_0x54c257=VisuMZ[_0x10123c(0x310)]['Settings']['QTE'],_0x56e22f=Math[_0x10123c(0x338)](_0x54c257[_0x10123c(0x274)]/0x2),_0x2a4770=Math[_0x10123c(0x338)](0xff/_0x56e22f);this['opacity']-=_0x2a4770;if(this['opacity']<=0x0&&this[_0x10123c(0x15f)]){if(_0x10123c(0x15d)===_0x10123c(0x15d))this[_0x10123c(0x15f)][_0x10123c(0x262)](this);else{const _0x53e37a=_0x42f1b8[_0x10123c(0x310)][_0x10123c(0x1c2)][_0x10123c(0x207)];if(!_0x53e37a[_0x10123c(0x312)])return;if([_0x10123c(0x1bf),_0x10123c(0x208),'timedSequence'][_0x10123c(0x31b)](_0x309787))return;if(_0x265770[_0x10123c(0x19f)]>=0xf4240)return;const _0xff5309=_0x53e37a['QteTimerWindowRectJS'][_0x10123c(0xf1)](this),_0x21fca3=new _0x1713db(_0xff5309);this[_0x10123c(0x160)](_0x21fca3),this[_0x10123c(0x157)]=_0x21fca3;}}},Sprite_QTE_TimedHit['prototype'][_0x2ec946(0x120)]=function(){const _0x315e34=_0x2ec946;this[_0x315e34(0x20a)]=!![],this[_0x315e34(0x112)]=!![];};function Sprite_QTE_TimedSequence(){const _0x2c4140=_0x2ec946;this[_0x2c4140(0x18a)](...arguments);}Sprite_QTE_TimedSequence[_0x2ec946(0x28a)]=Object['create'](Sprite[_0x2ec946(0x28a)]),Sprite_QTE_TimedSequence[_0x2ec946(0x28a)][_0x2ec946(0x329)]=Sprite_QTE_TimedSequence,Sprite_QTE_TimedSequence['prototype']['initialize']=function(_0x2ae3dc){const _0x2f8f53=_0x2ec946;Sprite[_0x2f8f53(0x28a)][_0x2f8f53(0x18a)][_0x2f8f53(0xf1)](this),this[_0x2f8f53(0x228)]=_0x2ae3dc,this[_0x2f8f53(0x10d)](),this[_0x2f8f53(0x1de)](),this['refreshBitmap']();},Sprite_QTE_TimedSequence[_0x2ec946(0x28a)][_0x2ec946(0x10d)]=function(){const _0x5748b1=_0x2ec946;this['anchor']['x']=0.5,this[_0x5748b1(0x30b)]['y']=0.5,this[_0x5748b1(0x144)]=this[_0x5748b1(0x228)][_0x5748b1(0x2c6)]||0x1,this['_direction']=SceneManager[_0x5748b1(0x23e)][_0x5748b1(0x259)]||_0x5748b1(0x113),this['x']=this[_0x5748b1(0x228)][_0x5748b1(0x179)]+(this['_direction']===_0x5748b1(0x113)?this['_position']:-this[_0x5748b1(0x144)]),this['y']=this['_data'][_0x5748b1(0x1ef)],this[_0x5748b1(0x300)]=Input['getLastUsedGamepadType'](),this[_0x5748b1(0x2e9)]=$gameParty['inBattle']()?0x0:-0x2;},Sprite_QTE_TimedSequence[_0x2ec946(0x28a)][_0x2ec946(0x1de)]=function(){const _0x2017fc=_0x2ec946,_0x110148=new Rectangle(0x0,0x0,0x12c,Window_Base['prototype'][_0x2017fc(0x320)]());_0x110148[_0x2017fc(0x11d)]+=$gameSystem[_0x2017fc(0x156)]()*0x2,_0x110148[_0x2017fc(0x2b8)]+=$gameSystem['windowPadding']()*0x2,this[_0x2017fc(0x246)]=new Window_Base(_0x110148);},Sprite_QTE_TimedSequence[_0x2ec946(0x28a)]['refreshBitmap']=function(){const _0x8dec4e=_0x2ec946;this[_0x8dec4e(0x300)]=Input[_0x8dec4e(0x324)]();const _0x36a53d=this[_0x8dec4e(0x228)][_0x8dec4e(0x2b0)]||'ok',_0x29ea5d=TextManager[_0x8dec4e(0x27a)](_0x36a53d),_0xb8204d=this[_0x8dec4e(0x246)][_0x8dec4e(0xd7)](_0x29ea5d)[_0x8dec4e(0x11d)],_0x246735=Math[_0x8dec4e(0x138)]((this[_0x8dec4e(0x246)]['innerWidth']-_0xb8204d)/0x2);this[_0x8dec4e(0x246)][_0x8dec4e(0x2c0)]['clear'](),this[_0x8dec4e(0x246)][_0x8dec4e(0x20e)](_0x29ea5d,_0x246735,0x0),this[_0x8dec4e(0x233)]=this[_0x8dec4e(0x246)][_0x8dec4e(0x2c0)];},Sprite_QTE_TimedSequence[_0x2ec946(0x28a)][_0x2ec946(0x134)]=function(){const _0x47579b=_0x2ec946;return this[_0x47579b(0x300)]!==Input[_0x47579b(0x324)]();},Sprite_QTE_TimedSequence[_0x2ec946(0x28a)][_0x2ec946(0x30a)]=function(){const _0x599783=_0x2ec946;Sprite[_0x599783(0x28a)][_0x599783(0x30a)][_0x599783(0xf1)](this);if(this[_0x599783(0x134)]())this[_0x599783(0x211)]();if(this[_0x599783(0x143)]())_0x599783(0x191)!==_0x599783(0xd2)?this[_0x599783(0x30c)]():_0xcee9be[_0x599783(0x28a)][_0x599783(0x18a)][_0x599783(0xf1)](this,_0x16b755);else(SceneManager[_0x599783(0x313)]()||this[_0x599783(0x112)])&&(_0x599783(0x139)==='IjDCd'?(this[_0x599783(0x1d3)]=_0xbd4576['_qteDuration'],this[_0x599783(0xf8)]=_0x4ba7ea[_0x599783(0x19f)]):this[_0x599783(0x29a)]());},Sprite_QTE_TimedSequence['prototype'][_0x2ec946(0x143)]=function(){const _0x204d24=_0x2ec946;if(!this[_0x204d24(0x15f)])return![];if(SceneManager[_0x204d24(0xd9)]>0x0)return![];if(this[_0x204d24(0x20a)])return![];return!![];},Sprite_QTE_TimedSequence['prototype'][_0x2ec946(0x30c)]=function(){const _0x3f492c=_0x2ec946,_0x22fa36=this['_leeway'];if(this[_0x3f492c(0x144)]<=_0x22fa36)return;const _0x3fbd87=Math[_0x3f492c(0x202)](0x0,this[_0x3f492c(0x144)]);this['x']=this[_0x3f492c(0x228)][_0x3f492c(0x179)]+(this[_0x3f492c(0x25a)]===_0x3f492c(0x113)?_0x3fbd87:-_0x3fbd87),this[_0x3f492c(0x144)]--,this[_0x3f492c(0x144)]<=this[_0x3f492c(0x2e9)]&&this[_0x3f492c(0x120)]();},Sprite_QTE_TimedSequence[_0x2ec946(0x28a)][_0x2ec946(0x29a)]=function(){const _0x34d2cb=_0x2ec946,_0x42c96e=VisuMZ[_0x34d2cb(0x310)]['Settings'][_0x34d2cb(0x207)],_0x1ba4f2=Math['ceil'](_0x42c96e[_0x34d2cb(0x274)]/0x2),_0x36f6c1=Math[_0x34d2cb(0x338)](0xff/_0x1ba4f2);this[_0x34d2cb(0x133)]-=_0x36f6c1,this[_0x34d2cb(0x133)]<=0x0&&this[_0x34d2cb(0x15f)]&&(_0x34d2cb(0x12c)===_0x34d2cb(0x252)?(_0x2af47a['ConvertParams'](_0x254064,_0x586733),_0x254fe8['setGameOverCommonEventID'](0x0)):this['parent'][_0x34d2cb(0x262)](this));},Sprite_QTE_TimedSequence['prototype'][_0x2ec946(0x120)]=function(){const _0x49b727=_0x2ec946;this[_0x49b727(0x20a)]=!![],this[_0x49b727(0x112)]=!![];const _0x9ead7d=SceneManager[_0x49b727(0x23e)],_0x40773d=_0x9ead7d[_0x49b727(0x31e)],_0x55aab3=_0x40773d[_0x49b727(0x174)](_0x2fe448=>_0x2fe448[_0x49b727(0x2c6)]===this['_data']['Timing']&&_0x2fe448[_0x49b727(0x2b0)]===this['_data'][_0x49b727(0x2b0)]);if(_0x55aab3){if(_0x49b727(0x2c9)!==_0x49b727(0x119)){_0x40773d[_0x49b727(0x193)](_0x55aab3);const _0x5089e6=_0x9ead7d[_0x49b727(0x2e8)];_0x5089e6&&_0x5089e6[_0x49b727(0x154)]&&AudioManager[_0x49b727(0x14d)](_0x5089e6);const _0x7dea57=_0x9ead7d[_0x49b727(0x1c4)]||0x0;_0x7dea57>0x0&&$onceParallel(_0x7dea57);}else{if(this[_0x49b727(0x1b4)]['isActiveChainSkillsUiVisible']()){const _0x758d6c=_0x49b727(0x1cc);return _0x47afa5[_0x49b727(0x238)](_0x758d6c),!![];}}}};function Sprite_QTE_TimingBarCursor(){const _0x48780b=_0x2ec946;this[_0x48780b(0x18a)](...arguments);}Sprite_QTE_TimingBarCursor[_0x2ec946(0x28a)]=Object[_0x2ec946(0x2e7)](Sprite['prototype']),Sprite_QTE_TimingBarCursor[_0x2ec946(0x28a)]['constructor']=Sprite_QTE_TimingBarCursor,Sprite_QTE_TimingBarCursor['prototype'][_0x2ec946(0x18a)]=function(){const _0x3d3d90=_0x2ec946;Sprite['prototype'][_0x3d3d90(0x18a)][_0x3d3d90(0xf1)](this),this['initMembers'](),this['createBitmap'](),this[_0x3d3d90(0x133)]=0x0;},Sprite_QTE_TimingBarCursor['prototype'][_0x2ec946(0x10d)]=function(){const _0x312a20=_0x2ec946;this[_0x312a20(0x30b)]['x']=0.5,this[_0x312a20(0x30b)]['y']=0x1,this[_0x312a20(0x129)]=SceneManager[_0x312a20(0x23e)][_0x312a20(0xde)]||0x1,this[_0x312a20(0x144)]=0x0,this[_0x312a20(0x25a)]=0x1;},Sprite_QTE_TimingBarCursor[_0x2ec946(0x28a)][_0x2ec946(0x334)]=function(){const _0x1ceaef=_0x2ec946;this[_0x1ceaef(0x233)]=ImageManager[_0x1ceaef(0x104)](_0x1ceaef(0x2fd)),this[_0x1ceaef(0xdc)]=SceneManager[_0x1ceaef(0x23e)][_0x1ceaef(0x1c1)]||0x0,this[_0x1ceaef(0x18f)]();},Sprite_QTE_TimingBarCursor['prototype'][_0x2ec946(0x18f)]=function(){const _0x54968c=_0x2ec946,_0x4cd2e4=ImageManager['iconWidth'],_0x2ccf65=ImageManager['iconHeight'],_0x71799f=this['_iconIndex']%0x10*_0x4cd2e4,_0x1f0a90=Math[_0x54968c(0x138)](this[_0x54968c(0xdc)]/0x10)*_0x2ccf65;this['setFrame'](_0x71799f,_0x1f0a90,_0x4cd2e4,_0x2ccf65);},Sprite_QTE_TimingBarCursor[_0x2ec946(0x28a)][_0x2ec946(0x30a)]=function(){const _0x1bb88f=_0x2ec946;Sprite[_0x1bb88f(0x28a)][_0x1bb88f(0x30a)][_0x1bb88f(0xf1)](this);if(!this[_0x1bb88f(0x143)]())return;this[_0x1bb88f(0x133)]=0xff,this[_0x1bb88f(0x1a6)](),this[_0x1bb88f(0x30c)]();},Sprite_QTE_TimingBarCursor['prototype']['canUpdate']=function(){const _0x3f475a=_0x2ec946;if(!this[_0x3f475a(0x15f)])return![];if(SceneManager[_0x3f475a(0xd9)]>0x0)return![];if(this[_0x3f475a(0x301)])return![];return!![];},Sprite_QTE_TimingBarCursor[_0x2ec946(0x28a)]['movePosition']=function(){const _0x24311c=_0x2ec946,_0x4acfb2=VisuMZ[_0x24311c(0x310)][_0x24311c(0x1c2)][_0x24311c(0x207)],_0x5a246c=_0x4acfb2[_0x24311c(0x2cd)]||0x64;this['_position']+=this[_0x24311c(0x129)]*this[_0x24311c(0x25a)];if(this[_0x24311c(0x144)]<0x0){if('fwNgu'===_0x24311c(0x19e)){const _0x30f12f=_0xcb33e[_0x24311c(0x187)]();if(_0x30f12f)_0x30f12f[_0x24311c(0x108)](_0x24311c(0x207));}else this[_0x24311c(0x144)]=0x0,this[_0x24311c(0x25a)]=0x1;}else this['_position']>_0x5a246c&&(_0x24311c(0x305)!==_0x24311c(0x305)?this[_0x24311c(0x29a)]():(this[_0x24311c(0x144)]=_0x5a246c,this['_direction']=-0x1));},Sprite_QTE_TimingBarCursor[_0x2ec946(0x28a)][_0x2ec946(0x30c)]=function(){const _0x90f0a0=_0x2ec946,_0x5ed615=VisuMZ[_0x90f0a0(0x310)][_0x90f0a0(0x1c2)][_0x90f0a0(0x207)],_0x5afc33=_0x5ed615[_0x90f0a0(0x2cd)]||0x64,_0x546d57=0xc,_0x4c109d=Math[_0x90f0a0(0x138)]((this[_0x90f0a0(0x15f)][_0x90f0a0(0x29d)]-_0x5afc33)/0x2)+this['parent'][_0x90f0a0(0x19c)],_0x2d89ac=this[_0x90f0a0(0x15f)][_0x90f0a0(0x320)]()-_0x546d57-0x2+this['parent'][_0x90f0a0(0x19c)],_0x1b6019=_0x5ed615[_0x90f0a0(0x31d)]||0x0,_0x36a698=_0x5ed615[_0x90f0a0(0x33c)]||0x0;this['x']=_0x4c109d+this['_position']+_0x1b6019,this['y']=_0x2d89ac+_0x36a698;},Sprite_QTE_TimingBarCursor[_0x2ec946(0x28a)]['stopCursor']=function(){this['_stopCursor']=!![];},Sprite_QTE_TimingBarCursor['prototype']['getCursorPosition']=function(){const _0x1a0119=_0x2ec946,_0x19bb7c=VisuMZ[_0x1a0119(0x310)][_0x1a0119(0x1c2)][_0x1a0119(0x207)],_0x1ad531=_0x19bb7c['QteTimingBarWidth']||0x64,_0x41678f=Math[_0x1a0119(0x116)](this[_0x1a0119(0x144)]/_0x1ad531*0x64);return _0x41678f;};function Window_QTE_GaugeBase(){const _0x1152ec=_0x2ec946;this[_0x1152ec(0x18a)](...arguments);}Window_QTE_GaugeBase['prototype']=Object[_0x2ec946(0x2e7)](Window_Base[_0x2ec946(0x28a)]),Window_QTE_GaugeBase[_0x2ec946(0x28a)]['constructor']=Window_QTE_GaugeBase,Window_QTE_GaugeBase[_0x2ec946(0x28a)][_0x2ec946(0x18a)]=function(_0x3b7986){const _0x2a7657=_0x2ec946;this[_0x2a7657(0x2f5)](),Window_Base['prototype'][_0x2a7657(0x18a)][_0x2a7657(0xf1)](this,_0x3b7986),this[_0x2a7657(0x28b)](0x2),this[_0x2a7657(0x111)]();},Window_QTE_GaugeBase['prototype']['cacheData']=function(){},Window_QTE_GaugeBase[_0x2ec946(0x28a)][_0x2ec946(0x30a)]=function(){const _0x13efa6=_0x2ec946;Window_Base['prototype']['update']['call'](this),this['needsRefresh']()&&(this[_0x13efa6(0x2f5)](),this[_0x13efa6(0x111)]()),this['updateEarlyFinish']();},Window_QTE_GaugeBase['prototype'][_0x2ec946(0x134)]=function(){return![];},Window_QTE_GaugeBase['prototype'][_0x2ec946(0x32e)]=function(){const _0xdf8b59=_0x2ec946;return ColorManager[_0xdf8b59(0x29c)]();},Window_QTE_GaugeBase[_0x2ec946(0x28a)]['gaugeColor2']=function(){const _0x3d7990=_0x2ec946;return ColorManager[_0x3d7990(0x1fd)]();},Window_QTE_GaugeBase['prototype'][_0x2ec946(0x256)]=function(){const _0x4a6181=_0x2ec946;return _0x4a6181(0x292);},Window_QTE_GaugeBase[_0x2ec946(0x28a)]['gaugeCurrentValue']=function(){return 0x0;},Window_QTE_GaugeBase[_0x2ec946(0x28a)][_0x2ec946(0x169)]=function(){return 0x1;},Window_QTE_GaugeBase[_0x2ec946(0x28a)]['refresh']=function(){const _0x43dbbf=_0x2ec946;this[_0x43dbbf(0x2c0)]['clear']();const _0x12f04b=this[_0x43dbbf(0x32e)](),_0x913166=this[_0x43dbbf(0x128)](),_0x13ced6=this[_0x43dbbf(0x256)](),_0x44fd2d=this[_0x43dbbf(0x29d)],_0x4540d0=0x0,_0x35aa84=0x0,_0x6bbe8=this[_0x43dbbf(0x2ee)](),_0xdddf39=this['gaugeMaxValue'](),_0x48bde6=(_0x6bbe8/_0xdddf39)[_0x43dbbf(0x196)](0x0,0x1);if(Imported[_0x43dbbf(0xd0)]){if(_0x43dbbf(0x203)===_0x43dbbf(0x2de)){const _0x196813=_0xda1b03[_0x43dbbf(0x1d0)](_0x4dd775);_0x599bee[_0x43dbbf(0x31a)](_0x14b05e,_0x196813+0x1);}else{const _0x5843d7=(VisuMZ[_0x43dbbf(0x237)]['GetGaugeHeight'](_0x13ced6)??0xc)[_0x43dbbf(0x196)](0x1,0x20),_0x29203e=_0x35aa84+this['lineHeight']()-_0x5843d7-0x2,_0x2ddefd=ColorManager[_0x43dbbf(0xd6)]();VisuMZ[_0x43dbbf(0x237)][_0x43dbbf(0x1da)]=this[_0x43dbbf(0x169)](),this[_0x43dbbf(0x2c0)][_0x43dbbf(0x26a)](_0x13ced6,_0x4540d0,_0x29203e,_0x44fd2d,_0x5843d7,_0x48bde6,_0x2ddefd,_0x12f04b,_0x913166);}}else this[_0x43dbbf(0x241)](_0x4540d0,_0x35aa84,_0x44fd2d,_0x48bde6,_0x12f04b,_0x913166);},Window_QTE_GaugeBase[_0x2ec946(0x28a)][_0x2ec946(0x29a)]=function(){const _0x24398c=_0x2ec946;if(!SceneManager[_0x24398c(0x313)]())return;const _0x589e58=VisuMZ['QTE_TriggerSys'][_0x24398c(0x1c2)]['QTE'],_0x35555a=Math['ceil'](_0x589e58['EarlyFinishDuration']/0x2);if(SceneManager[_0x24398c(0xee)]>_0x35555a)return;const _0x4ef0bd=Math['ceil'](0xff/_0x35555a);this[_0x24398c(0x28d)]-=_0x4ef0bd;};function Window_QTE_Timer(){const _0x17fe40=_0x2ec946;this[_0x17fe40(0x18a)](...arguments);}Window_QTE_Timer['prototype']=Object['create'](Window_QTE_GaugeBase[_0x2ec946(0x28a)]),Window_QTE_Timer[_0x2ec946(0x28a)][_0x2ec946(0x329)]=Window_QTE_Timer,Window_QTE_Timer[_0x2ec946(0x28a)][_0x2ec946(0x18a)]=function(_0x1d24e1){const _0x2309a5=_0x2ec946;Window_QTE_GaugeBase[_0x2309a5(0x28a)]['initialize'][_0x2309a5(0xf1)](this,_0x1d24e1);},Window_QTE_Timer[_0x2ec946(0x28a)][_0x2ec946(0x2f5)]=function(){const _0x409683=_0x2ec946;this[_0x409683(0x1d3)]=SceneManager[_0x409683(0x205)],this[_0x409683(0xf8)]=SceneManager[_0x409683(0x19f)];},Window_QTE_Timer[_0x2ec946(0x28a)][_0x2ec946(0x134)]=function(){const _0x388913=_0x2ec946;if(this['_lastDuration']!==SceneManager[_0x388913(0x205)])return!![];if(this[_0x388913(0xf8)]!==SceneManager[_0x388913(0x19f)])return!![];return![];},Window_QTE_Timer[_0x2ec946(0x28a)][_0x2ec946(0x32e)]=function(){const _0x449067=_0x2ec946,_0x17dba8=VisuMZ[_0x449067(0x310)][_0x449067(0x1c2)][_0x449067(0x207)];return ColorManager[_0x449067(0xcb)](_0x17dba8[_0x449067(0x230)]);},Window_QTE_Timer[_0x2ec946(0x28a)][_0x2ec946(0x128)]=function(){const _0x3c0349=_0x2ec946,_0x40f95c=VisuMZ[_0x3c0349(0x310)][_0x3c0349(0x1c2)][_0x3c0349(0x207)];return ColorManager[_0x3c0349(0xcb)](_0x40f95c[_0x3c0349(0x23a)]);},Window_QTE_Timer['prototype']['gaugeStyle']=function(){const _0x2d1546=_0x2ec946,_0x3c671c=VisuMZ[_0x2d1546(0x310)][_0x2d1546(0x1c2)]['QTE'];return _0x3c671c[_0x2d1546(0x336)];},Window_QTE_Timer[_0x2ec946(0x28a)][_0x2ec946(0x2ee)]=function(){const _0x5307d2=_0x2ec946;return this[_0x5307d2(0x1d3)]||0x0;},Window_QTE_Timer[_0x2ec946(0x28a)][_0x2ec946(0x169)]=function(){const _0x473e75=_0x2ec946;return this[_0x473e75(0xf8)]||0x0;};function Window_QTE_Progress(){const _0x21e1cc=_0x2ec946;this[_0x21e1cc(0x18a)](...arguments);}Window_QTE_Progress[_0x2ec946(0x28a)]=Object[_0x2ec946(0x2e7)](Window_QTE_GaugeBase[_0x2ec946(0x28a)]),Window_QTE_Progress['prototype'][_0x2ec946(0x329)]=Window_QTE_Progress,Window_QTE_Progress[_0x2ec946(0x28a)][_0x2ec946(0x18a)]=function(_0xe35d6c){const _0x59c3d5=_0x2ec946;Window_QTE_GaugeBase[_0x59c3d5(0x28a)][_0x59c3d5(0x18a)]['call'](this,_0xe35d6c);},Window_QTE_Progress['prototype']['cacheData']=function(){const _0x247e6c=_0x2ec946;this['_lastProgress']=SceneManager[_0x247e6c(0x23e)][_0x247e6c(0x26b)],this['_lastGoal']=SceneManager['_qteSettings'][_0x247e6c(0x32c)];},Window_QTE_Progress[_0x2ec946(0x28a)]['needsRefresh']=function(){const _0x1e0cd4=_0x2ec946;if(this[_0x1e0cd4(0x151)]!==SceneManager[_0x1e0cd4(0x23e)][_0x1e0cd4(0x26b)])return!![];if(this[_0x1e0cd4(0x2b6)]!==SceneManager['_qteSettings'][_0x1e0cd4(0x32c)])return!![];return![];},Window_QTE_Progress[_0x2ec946(0x28a)]['gaugeColor1']=function(){const _0x169cba=_0x2ec946,_0x25de30=VisuMZ[_0x169cba(0x310)][_0x169cba(0x1c2)][_0x169cba(0x207)];return ColorManager[_0x169cba(0xcb)](_0x25de30[_0x169cba(0x2ba)]);},Window_QTE_Progress[_0x2ec946(0x28a)][_0x2ec946(0x128)]=function(){const _0x516869=_0x2ec946,_0x3838a4=VisuMZ[_0x516869(0x310)]['Settings']['QTE'];return ColorManager[_0x516869(0xcb)](_0x3838a4[_0x516869(0x2d6)]);},Window_QTE_Progress[_0x2ec946(0x28a)]['gaugeStyle']=function(){const _0x2a63f3=_0x2ec946,_0x2b1c38=VisuMZ['QTE_TriggerSys'][_0x2a63f3(0x1c2)]['QTE'];return _0x2b1c38['qteProgressGaugeStyleType'];},Window_QTE_Progress[_0x2ec946(0x28a)]['gaugeCurrentValue']=function(){const _0x1dcf16=_0x2ec946;return this[_0x1dcf16(0x151)]||0x0;},Window_QTE_Progress[_0x2ec946(0x28a)]['gaugeMaxValue']=function(){return this['_lastGoal']||0x0;};function Window_QTE_HelpBase(){const _0x660aa6=_0x2ec946;this[_0x660aa6(0x18a)](...arguments);}Window_QTE_HelpBase['prototype']=Object[_0x2ec946(0x2e7)](Window_Help['prototype']),Window_QTE_HelpBase[_0x2ec946(0x28a)]['constructor']=Window_QTE_HelpBase,Window_QTE_HelpBase[_0x2ec946(0x28a)][_0x2ec946(0x18a)]=function(_0xa0141a){const _0x4d36e3=_0x2ec946;this['cacheData'](),Window_Help[_0x4d36e3(0x28a)][_0x4d36e3(0x18a)]['call'](this,_0xa0141a);},Window_QTE_HelpBase[_0x2ec946(0x28a)]['cacheData']=function(){const _0x54cacf=_0x2ec946;this[_0x54cacf(0x151)]=this['buttonProgress'](),this['_lastQteInputType']=Input[_0x54cacf(0x324)]();},Window_QTE_HelpBase[_0x2ec946(0x28a)]['update']=function(){const _0x1cdce4=_0x2ec946;Window_Help[_0x1cdce4(0x28a)][_0x1cdce4(0x30a)][_0x1cdce4(0xf1)](this),this['needsRefresh']()&&(this[_0x1cdce4(0x2f5)](),this[_0x1cdce4(0x111)]());},Window_QTE_HelpBase['prototype'][_0x2ec946(0x134)]=function(){const _0x247d83=_0x2ec946;return this[_0x247d83(0x300)]!==Input[_0x247d83(0x324)]();},Window_QTE_HelpBase[_0x2ec946(0x28a)][_0x2ec946(0x111)]=function(){const _0xa998f0=_0x2ec946;this[_0xa998f0(0x2c0)]['clear'](),this[_0xa998f0(0x137)](),this[_0xa998f0(0x1c8)](),this['changePaintOpacity'](!![]);const _0x3787ac=this[_0xa998f0(0x270)]();this[_0xa998f0(0x20e)](this[_0xa998f0(0x322)],_0x3787ac['x'],_0x3787ac['y']+this['lineHeight'](),_0x3787ac[_0xa998f0(0x11d)]);},Window_QTE_HelpBase[_0x2ec946(0x28a)][_0x2ec946(0x163)]=function(){const _0x416b90=_0x2ec946;return SceneManager[_0x416b90(0x23e)][_0x416b90(0x26b)]||0x0;},Window_QTE_HelpBase[_0x2ec946(0x28a)][_0x2ec946(0x137)]=function(){};function Window_QTE_ButtonSequence(){const _0x3c75f1=_0x2ec946;this[_0x3c75f1(0x18a)](...arguments);}Window_QTE_ButtonSequence[_0x2ec946(0x28a)]=Object[_0x2ec946(0x2e7)](Window_QTE_HelpBase[_0x2ec946(0x28a)]),Window_QTE_ButtonSequence[_0x2ec946(0x28a)]['constructor']=Window_QTE_ButtonSequence,Window_QTE_ButtonSequence[_0x2ec946(0x28a)][_0x2ec946(0x18a)]=function(_0x5d8418){const _0x4bcc19=_0x2ec946;Window_QTE_HelpBase[_0x4bcc19(0x28a)][_0x4bcc19(0x18a)][_0x4bcc19(0xf1)](this,_0x5d8418);},Window_QTE_ButtonSequence[_0x2ec946(0x28a)][_0x2ec946(0x2f5)]=function(){const _0x31dce9=_0x2ec946;Window_QTE_HelpBase[_0x31dce9(0x28a)][_0x31dce9(0x2f5)][_0x31dce9(0xf1)](this),this[_0x31dce9(0x151)]=this[_0x31dce9(0x163)]();},Window_QTE_ButtonSequence[_0x2ec946(0x28a)][_0x2ec946(0x134)]=function(){const _0x2c32d2=_0x2ec946;if(this[_0x2c32d2(0x151)]!==this[_0x2c32d2(0x163)]())return!![];return Window_QTE_HelpBase[_0x2c32d2(0x28a)][_0x2c32d2(0x134)][_0x2c32d2(0xf1)](this);},Window_QTE_ButtonSequence[_0x2ec946(0x28a)]['refreshDrawSpecialData']=function(){const _0x1dfeda=_0x2ec946,_0x570b61=SceneManager[_0x1dfeda(0x23e)][_0x1dfeda(0x2a9)]['clone'](),_0x5095be=_0x570b61[_0x1dfeda(0x193)]('')[_0x1dfeda(0x1d8)](_0x4ce17a=>TextManager[_0x1dfeda(0x27a)](_0x4ce17a)),_0x10891b=_0x5095be[_0x1dfeda(0x2ec)]('\x20'),_0x3b8301=this['textSizeEx'](_0x10891b)[_0x1dfeda(0x11d)],_0x391d63=SceneManager['_qteSettings'][_0x1dfeda(0x26b)];let _0x2f204a=Math[_0x1dfeda(0x138)]((this['innerWidth']-_0x3b8301)/0x2);this[_0x1dfeda(0x1c8)]();const _0x4a125f=_0x5095be['length'];for(let _0x3343fc=0x0;_0x3343fc<_0x4a125f;_0x3343fc++){const _0x41ede9=_0x5095be[_0x3343fc];this[_0x1dfeda(0x29b)](_0x3343fc>=_0x391d63),this[_0x1dfeda(0x20e)](_0x41ede9,_0x2f204a,0x0),_0x2f204a+=this[_0x1dfeda(0xd7)](_0x41ede9+'\x20')[_0x1dfeda(0x11d)];}};function _0x55c2(_0x49ed0e,_0x1a83bf){const _0x55840f=_0x5584();return _0x55c2=function(_0x55c25f,_0x13df58){_0x55c25f=_0x55c25f-0xca;let _0x3564b6=_0x55840f[_0x55c25f];return _0x3564b6;},_0x55c2(_0x49ed0e,_0x1a83bf);}function Window_QTE_TimedSequence(){const _0x144de9=_0x2ec946;this[_0x144de9(0x18a)](...arguments);}Window_QTE_TimedSequence[_0x2ec946(0x28a)]=Object[_0x2ec946(0x2e7)](Window_QTE_HelpBase[_0x2ec946(0x28a)]),Window_QTE_TimedSequence['prototype']['constructor']=Window_QTE_TimedSequence,Window_QTE_TimedSequence[_0x2ec946(0x28a)]['initialize']=function(_0x4c3979){const _0x30cfa9=_0x2ec946;Window_QTE_HelpBase[_0x30cfa9(0x28a)][_0x30cfa9(0x18a)][_0x30cfa9(0xf1)](this,_0x4c3979),this[_0x30cfa9(0x243)](),this[_0x30cfa9(0x278)]();},Window_QTE_TimedSequence[_0x2ec946(0x28a)][_0x2ec946(0x243)]=function(){const _0x539a25=_0x2ec946,_0x48b5d8=VisuMZ[_0x539a25(0x310)][_0x539a25(0x1c2)][_0x539a25(0x207)],_0x488cfa=_0x48b5d8['TimedSequenceLandPosition']||0x0,_0x3f3848=SceneManager[_0x539a25(0x23e)],_0x1edc0a=_0x3f3848['icon']||0x0,_0x1c5980=_0x3f3848[_0x539a25(0x259)]||_0x539a25(0x113),_0x3bac95=new Sprite();_0x3bac95['bitmap']=ImageManager['loadSystem'](_0x539a25(0x2fd)),_0x3bac95[_0x539a25(0x30b)]['x']=0.5,_0x3bac95[_0x539a25(0x30b)]['y']=0.5;{const _0x4a82aa=ImageManager[_0x539a25(0x337)],_0x2b9412=ImageManager[_0x539a25(0x2d7)],_0x287d7a=_0x1edc0a%0x10*_0x4a82aa,_0x5d70f1=Math[_0x539a25(0x138)](_0x1edc0a/0x10)*_0x2b9412;_0x3bac95[_0x539a25(0x165)](_0x287d7a,_0x5d70f1,_0x4a82aa,_0x2b9412);}const _0x2e0780=(_0x1c5980==='left'?_0x488cfa:0x64-_0x488cfa)*0.01;this[_0x539a25(0x33f)]=this[_0x539a25(0x19c)]+Math[_0x539a25(0x116)](this['innerWidth']*_0x2e0780),this[_0x539a25(0xda)]=this[_0x539a25(0x19c)]+Math[_0x539a25(0x116)](this[_0x539a25(0x320)]()/0x2),_0x3bac95['x']=this[_0x539a25(0x33f)],_0x3bac95['y']=this['_landingPositionY'],this[_0x539a25(0x160)](_0x3bac95),this['_landingSprite']=_0x3bac95;},Window_QTE_TimedSequence['prototype'][_0x2ec946(0x278)]=function(){const _0x3f0fc5=_0x2ec946,_0x1907fb=SceneManager[_0x3f0fc5(0x23e)],_0x497d73=_0x1907fb[_0x3f0fc5(0x2a9)][_0x3f0fc5(0x32d)]()['reverse']();this['_sequenceSprites']=[];for(const _0x200af0 of _0x497d73){_0x200af0[_0x3f0fc5(0x179)]=this[_0x3f0fc5(0x33f)],_0x200af0[_0x3f0fc5(0x1ef)]=this['_landingPositionY'];const _0x27adf3=new Sprite_QTE_TimedSequence(_0x200af0);this[_0x3f0fc5(0x160)](_0x27adf3),this[_0x3f0fc5(0x220)][_0x3f0fc5(0x18d)](_0x27adf3);}},Window_QTE_TimedSequence['prototype'][_0x2ec946(0xe3)]=function(){const _0x4cb045=_0x2ec946;Window_QTE_HelpBase[_0x4cb045(0x28a)][_0x4cb045(0xe3)][_0x4cb045(0xf1)](this);if(!this[_0x4cb045(0x220)])return;while(this[_0x4cb045(0x220)][_0x4cb045(0x326)]>0x0){const _0x952c1f=this['_sequenceSprites'][_0x4cb045(0xd5)]();if(!_0x952c1f)continue;if(!_0x952c1f[_0x4cb045(0x233)])continue;_0x952c1f[_0x4cb045(0x233)][_0x4cb045(0x172)]();}};function Window_QTE_TimingBar(){this['initialize'](...arguments);}function _0x5584(){const _0x2b45e9=['align','rmYWZ','match','updateButtonSequenceQTE','contents','jVugw','CheckCompatibility','OnChange','mPqlY','uvvRs','Timing','Zones','updateFrameCount','RjHqe','Game_Switches_setValue','Direction','variables','QteTimingBarWidth','QHqiO','ciCoC','hasOnTriggerPromise','code','setupQTE','zRueE','updateSwapperQTE','gameOverCommonEvent','QteProgressColor2','iconHeight','zhyPo','MdySl','QTE_HoldRelease','Game_Variables_setValue','Dluqh','buttons','rxuff','init_QTE_TriggerSys','vUIYS','updateDirectionStruggleQTE','split','OprsJ','createTimedHitSpriteQTE','frameCount','type','create','missSound','_leeway','processGameOverEvent','lLDBu','join','aLxFq','gaugeCurrentValue','checkPlayingQTE','ULIAn','fontSize','directionStruggle','Cannot\x20start\x20QTE\x20during\x20a\x20dice\x20roll.','axmBq','cacheData','naVQW','LUXLo','_mapGameOverCommonEventID','nFmEE','defineCommonEventType','EPFgm','updateInputData','IconSet','End','RItvO','_lastQteInputType','_stopCursor','QTE_DirectionStruggle','sWIou','pointY','rvINv','setupMessageForQTE','aZeru','getOnChangeCommonEventTriggers','fillGauge','update','anchor','updatePosition','duration','CommonEventIDs','hasOnChangeCommonEventTrigger','QTE_TriggerSys','CommonEventID_Ok','ShowQteTimer','isEarlyFinishQTE','Sound','_jsCommonEvents','TimingBarLabelOffsetY','LandingIcon','_waitMode','gameOverCommonEventHeal','setValue','includes','vzRcu','TimingBarCursorOffsetX','remainingSequence','getWatchedTriggerPromises','lineHeight','cancel','_text','IWxaf','getLastUsedGamepadType','IGdNu','length','_watchedJsSwitches','clear','constructor','bhLCe','EventsMoveCore','goal','clone','gaugeColor1','checkEarlyFinishQTE','pageUpCommonEventID','TimingBarFontSize','JiwrT','commonEventID','createBitmap','_afterQteSessionDelay','qteTimerGaugeStyleType','iconWidth','ceil','MfLXL','_qteTimedHitSprite','QTE_Marcher','TimingBarCursorOffsetY','MrNzs','drawBaseGauge','_landingPositionX','QTE_TimedHit','hCsUD','getColor','menu','scale','TNqWa','QTE_TimedSequence','VisuMZ_3_VisualGaugeStyles','IxPWG','KvCzA','lIgAZ','sgDBD','pop','gaugeBackColor','textSizeEx','updateTimingBarQTE','_qteInputDelay','_landingPositionY','Enemy-%1-%2','_iconIndex','OnVariable','cursorSpeed','Game_Interpreter_setupReservedCommonEvent','filter','TimedHitPicture','SmRfI','destroyContents','fmJvk','ofoWy','ButtonSeqTextMsg','ANIkQ','BAvOk','Scene_Map_needsFadeIn','EVAL','_qteLastInput','registerData','HdWco','_qteEarlyFinishDuration','Game_Party_gainItem','ShuffleArray','call','jrLZL','KfaXS','Scene_Gameover_create','registerCommonEvents','timingBar','Cannot\x20run\x20QTE\x20during\x20Input\x20Combo\x20Skills.','_lastWholeDuration','oozYI','_gameOverCommonEventID','50beyLib','ExtMessageFunc','ARRAYFUNC','version','oKAoh','isAdvancedVariable','mainFontSize','btOEC','TimedSeqTextMsg','loadSystem','VisuMZ_1_MessageCore','switchID','cancelCommonEventID','setWaitMode','Game_Interpreter_updateWaitMode','YTOIY','updateQteGaugeWindows','TimedHitSuccessFrames','initMembers','_qteType','parseCommonEventNotetags','OverloadSound','refresh','_finishing','left','GoHVx','cEhSM','round','pageDownCommonEventID','fRoLv','sRipe','TimingBarColor2','getGameOverCommonEventID','qixwf','width','11637648ZNVRVG','TimedSeqSuccessFrames','startFinishing','setupReservedCommonEvent','updateTimedSequenceQTE','QTE_ButtonSequenceNormal','SceneManager_updateInputData','SceneManager_initialize','switches','JZmUh','gaugeColor2','_speed','setGameOverCommonEventID','WaitForQTE','NrgaG','setText','VisuMZ_0_CoreEngine\x20needs\x20to\x20be\x20updated\x20','DefaultGameOverEvent','_cache_onChangeCommonEventTrigger','yXYHX','Weapon-%1-%2','opacity','needsRefresh','JSON','QLUiJ','refreshDrawSpecialData','floor','kyTtN','gainItem','VisuMZ_3_ActiveChainSkills','updateFillGaugeQTE','WIEnN','MsgWindowBgType','control','Item-%1-%2','CpILU','sound','canUpdate','_position','PlaytestInput','OnSwitch','CommonEventID_PageDown','284828zlzzyl','HupaV','isAnyTriggered','isWeapon','initGameOverEventSettings','playSe','troop','updateQteWindowText','49256rxYgfK','_lastProgress','TimedHitMaxSize','clearWatchedTrigger','name','VisuMZ_3_InputComboSkills','windowPadding','_qteTimerWindow','Game_System_initialize','GiZeD','_qteWindow','text','timedSequence','NNqGP','parameters','parent','addChild','min','getQTE_TriggerSysPromises','buttonProgress','numberFontFace','setFrame','hOosO','parse','description','gaugeMaxValue','pointX','TimedHitTextMsg','nLpUj','_duration','EfphA','KPTtd','rectJS','fontFace','destroy','createKeyJS','find','push','HitSound','HitCommonEventID','buttonSequence','_baseX','isAdvancedSwitch','CommonEventID_PageUp','varID','VariableID','XwFej','Label','EUmtE','shuffle','getCursorPosition','createJsFunctionsForCommonEvent','drawHitZones','HealOnEvent','AreaColor1','getLastPluginCommandInterpreter','LimLG','%1\x20is\x20incorrectly\x20placed\x20on\x20the\x20plugin\x20list.\x0aIt\x20is\x20a\x20Tier\x20%2\x20plugin\x20placed\x20over\x20other\x20Tier\x20%3\x20plugins.\x0aPlease\x20reorder\x20the\x20plugin\x20list\x20from\x20smallest\x20to\x20largest\x20tier\x20numbers.','initialize','Mltvy','getTypeQTE','unshift','VvcWG','updateFrame','_normalCommonEvents','jhsaG','Actor-%1-%2','remove','needsFadeIn','CqZKf','clamp','kyZqV','_qteCursorSprite','%1\x27s\x20version\x20does\x20not\x20match\x20plugin\x27s.\x20Please\x20update\x20it\x20in\x20the\x20Plugin\x20Manager.','afZod','CommonEventID_Cancel','padding','buttonMash','wvKRJ','_qteWholeDuration','zones','random','fillRect','onChangeTrigger','mDmFZ','armors','movePosition','_qteProgressWindow','NRBnl','init_QTE_TriggerSysPromise','QteProgressWindowRectJS','isArmor','QteTimerWindowRectJS','371WIhUJY','Class-%1-%2','nBLiW','WatchDelay','updateWaitMode','mqIuz','hitCommonEventID','_scene','2731170ZtdUEJ','Scene_Map_start','VisuMZ_2_ExtMessageFunc\x20needs\x20to\x20be\x20updated\x20','Buttons','fulfillOnTriggerPromisesItem','zBFwL','MKHAE','>>>ATTENTION<<<','wpCvI','items','holdRelease','isItem','cursorIcon','Settings','okCommonEventID','missCommonEventID','fulfillOnTriggerPromises','processCommonEvent','XqZOP','resetFontSettings','TimingBarLabelOffsetX','hasGameOverEvent','isBattleTest','Cannot\x20run\x20QTE\x20during\x20Active\x20Chain\x20Skills.','overloadSound','ReleaseSound','UhJAB','value','playBuzzer','right','_lastDuration','_triggerSwitches','gjWbk','Cannot\x20run\x20QTE\x20during\x20Evolution\x20Matrix\x20Skills.','return\x200','map','StruggleRequirement','_maxValueSegment','updateQTEInputs','MissSound','format','createDummyWindow','ljUyk','randomInt','HoldReleaseTextMsg','rjDMR','_jsFuncs','onDatabaseLoaded','Scene_Gameover_start','setupGameOverCommonEvent','axCyi','OOOgB','NEbiQ','Game_Map_setup','zommJ','isRepeated','processItemTrigger','isOnceParallelReserved','_baseY','ARRAYSTR','isTriggerWatchedSwitch','marcher','6207280KyCwKK','hitSound','FUNC','wholeDuration','Points','replace','AreaColor2','init_QTE_TriggerSysReservations','ARRAYJSON','cuTwF','systemColor','_wholeDuration','_evoMatrixSkillMode','TimingBarColor1','center','max','BxVpl','_qteInputBuffer','_qteDuration','InputStartDelay','QTE','timedHit','GameOverCommonEventSetup','_stopOverlay','note','start','processSwitchTrigger','drawTextEx','pageup','Duration','refreshBitmap','TtVBr','Ubpev','isPressed','picture','QTE_ButtonSequenceRandom','ShowQteProgress','PromiseVariable','Scene_Base_update','_latestButton','PiKry','dataID','updateQTEDuration','SbsZI','registerSwitches','_sequenceSprites','ZMfoT','rvOaT','SwapperTextMsg','mdqHb','numItems','MsgWindowRectJS','PromiseItem','_data','addQTE_TriggerSysPromiseToSet','JpgQw','shift','KGcOL','isPlayingQTE','fEBqN','in\x20order\x20for\x20VisuMZ_2_QTE_TriggerSys\x20to\x20work.','QteTimerColor1','_overlaySprite','FillGaugeTextMsg','bitmap','3402996uXrdcn','MaxDuration','Scene_Boot_onDatabaseLoaded','VisualGaugeStyles','log','pagedown','QteTimerColor2','exit','aZUiM','RegExp','_qteSettings','updateOverlayScale','ARRAYEVAL','drawGauge','VisuMZ_1_EventsMoveCore','createLandingIconSprite','ButtonMashTextMsg','gradientFillRect','_dummyWindow','9LgajPq','triggerProcessed','trim','hnCVf','dfTvL','ARRAYNUM','%1\x20is\x20missing\x20a\x20required\x20plugin.\x0aPlease\x20install\x20%2\x20into\x20the\x20Plugin\x20Manager.','_logWindow','CnADA','GameOver','Sequence','wcAlJ','ConvertParams','MqJbY','createGaugeProgressWindowForQTE','gaugeStyle','_onceParallelQueue','Vocab','direction','_direction','updateMarcherQTE','processAllOnceParallels','_triggerPromises','_watchedJsVariables','weapons','updateTimedHitQTE','removeQteWindow','removeChild','VisuMZ_1_EventsMoveCore\x20needs\x20to\x20be\x20updated\x20','setup','MsgTextAlign','createTimingBarSprite','1PVKgYt','Only\x20one\x20QTE\x20can\x20be\x20running\x20at\x20a\x20time.','DirectionStruggleTextMsg','drawVisualStyleGauge','progress','bgType','QTE_ButtonMash','isRollingDice','updateHoldReleaseQTE','baseTextRect','CursorIcon','JKvTR','updateButtonMashQTE','EarlyFinishDuration','sADpK','finishEarlyQTE','registerVariables','createSequenceSprites','ToggleRequirement','getInputButtonString','isPreviousScene','CommonEventID','MissCommonEventID','createOverlaySprite','aBjbN','InputSequence','isTriggerWatchedVariable','PromiseSwitch','QTE_FillGauge','TRmIR','297074qhgzmi','inputStartDelay','processVariableTrigger','swapper','Spdja','prototype','setBackgroundType','NUM','contentsOpacity','createGaugeTimerWindowForQTE','_triggerVariables','faYAM','_inputComboSkillMode','normal','SwitchID','_labelMode','Start','isPlaytest','crtgB','dir4','qNeiK','updateEarlyFinish','changePaintOpacity','normalColor','innerWidth','loadPicture','RuxWy','IWAWy','_watchedPromises','checkWatchedTriggers','HWZnP','nAddV','deadMembers','updateQteDuration','MarcherTextMsg','releaseSound','sequence','isTriggered','Skill-%1-%2','HgXUX','ZVXiI','stopCursor','sort','Button','MudCQ','RqIWV','ZkGrj','PromiseArmor','clear_QTE_Settings','_lastGoal','ekFss','height','registerCommand','QteProgressColor1','SceneManager_updateFrameCount'];_0x5584=function(){return _0x2b45e9;};return _0x5584();}Window_QTE_TimingBar['prototype']=Object['create'](Window_QTE_HelpBase['prototype']),Window_QTE_TimingBar['prototype'][_0x2ec946(0x329)]=Window_QTE_TimingBar,Window_QTE_TimingBar[_0x2ec946(0x28a)]['initialize']=function(_0x1ec311){const _0x41ff3a=_0x2ec946;Window_QTE_HelpBase[_0x41ff3a(0x28a)][_0x41ff3a(0x18a)][_0x41ff3a(0xf1)](this,_0x1ec311),this[_0x41ff3a(0x266)]();},Window_QTE_TimingBar[_0x2ec946(0x28a)][_0x2ec946(0x266)]=function(){const _0x194fe4=_0x2ec946;this[_0x194fe4(0x198)]=new Sprite_QTE_TimingBarCursor(),this[_0x194fe4(0x160)](this['_qteCursorSprite']);},Window_QTE_TimingBar[_0x2ec946(0x28a)][_0x2ec946(0x137)]=function(){const _0x3bb0ab=_0x2ec946;this[_0x3bb0ab(0x33e)](),this[_0x3bb0ab(0x184)]();},Window_QTE_TimingBar[_0x2ec946(0x28a)]['drawBaseGauge']=function(){const _0x2446d0=_0x2ec946,_0x34ee1d=VisuMZ[_0x2446d0(0x310)][_0x2446d0(0x1c2)][_0x2446d0(0x207)],_0x311d2b=_0x34ee1d[_0x2446d0(0x2cd)]||0x64,_0x3cd694=0xc,_0x1f47e6=Math[_0x2446d0(0x138)]((this[_0x2446d0(0x29d)]-_0x311d2b)/0x2),_0x48346b=this['lineHeight']()-_0x3cd694-0x2,_0xe41321=ColorManager['getColor'](_0x34ee1d[_0x2446d0(0x200)]),_0x29d87d=ColorManager[_0x2446d0(0xcb)](_0x34ee1d[_0x2446d0(0x11a)]);this[_0x2446d0(0x2c0)][_0x2446d0(0x1a2)](_0x1f47e6-0x1,_0x48346b-0x1,_0x311d2b+0x2,_0x3cd694+0x2,ColorManager['gaugeBackColor']()),this[_0x2446d0(0x2c0)][_0x2446d0(0x245)](_0x1f47e6,_0x48346b,_0x311d2b,_0x3cd694,_0xe41321,_0x29d87d,!![]);},Window_QTE_TimingBar[_0x2ec946(0x28a)]['drawHitZones']=function(){const _0x55d52d=_0x2ec946,_0x19b428=VisuMZ['QTE_TriggerSys']['Settings'][_0x55d52d(0x207)],_0x5b2617=_0x19b428['QteTimingBarWidth']||0x64,_0xae50e9=0xc,_0x5df4fc=Math[_0x55d52d(0x138)]((this[_0x55d52d(0x29d)]-_0x5b2617)/0x2),_0xc2a0b2=this[_0x55d52d(0x320)]()-_0xae50e9-0x2,_0x43fc5f=SceneManager[_0x55d52d(0x23e)],_0x388ee3=_0x43fc5f[_0x55d52d(0x1a0)];for(const _0x3b08d8 of _0x388ee3){const _0x840842=Math[_0x55d52d(0x161)](_0x3b08d8['Start'],_0x3b08d8['End'])[_0x55d52d(0x196)](0x0,0x64),_0x3cad8d=Math[_0x55d52d(0x202)](_0x3b08d8['Start'],_0x3b08d8[_0x55d52d(0x2fe)])['clamp'](0x0,0x64),_0x47e97e=Math[_0x55d52d(0x338)](_0x840842*0.01*_0x5b2617),_0x29bc6a=Math[_0x55d52d(0x138)](_0x3cad8d*0.01*_0x5b2617),_0x18ab3e=_0x47e97e+_0x5df4fc,_0x3bbfe4=_0x29bc6a-_0x47e97e,_0x37ba20=ColorManager['getColor'](_0x3b08d8[_0x55d52d(0x186)]),_0x1ec4c4=ColorManager[_0x55d52d(0xcb)](_0x3b08d8[_0x55d52d(0x1f9)]);this[_0x55d52d(0x2c0)][_0x55d52d(0x245)](_0x18ab3e,_0xc2a0b2,_0x3bbfe4,_0xae50e9,_0x37ba20,_0x1ec4c4,!![]);const _0x39f6c3=_0x3b08d8[_0x55d52d(0x17f)]||'';if(_0x39f6c3[_0x55d52d(0x326)]>0x0){if(_0x55d52d(0x21e)===_0x55d52d(0x21e)){this[_0x55d52d(0x294)]=!![];const _0x551d8f=this[_0x55d52d(0xd7)](_0x39f6c3)['width'],_0x4a0af9=_0x18ab3e+Math[_0x55d52d(0x116)](_0x3bbfe4/0x2),_0x4a3e50=_0x4a0af9-Math[_0x55d52d(0x338)](_0x551d8f/0x2)+(_0x19b428[_0x55d52d(0x1c9)]||0x0),_0x3fd23a=_0x19b428['TimingBarLabelOffsetY']||0x0;this[_0x55d52d(0x20e)](_0x39f6c3,_0x4a3e50,_0x3fd23a),this[_0x55d52d(0x294)]=![];}else{const _0x3a3650=_0x4b444d[_0x55d52d(0x310)][_0x55d52d(0x1c2)][_0x55d52d(0x207)],_0xee49db=_0x10038c[_0x55d52d(0x338)](_0x3a3650[_0x55d52d(0x274)]/0x2),_0x3abec9=_0x44d1dd['ceil'](0xff/_0xee49db);this[_0x55d52d(0x133)]-=_0x3abec9,this[_0x55d52d(0x133)]<=0x0&&this['parent']&&this[_0x55d52d(0x15f)]['removeChild'](this);}}}},Window_QTE_TimingBar[_0x2ec946(0x28a)][_0x2ec946(0x1c8)]=function(){const _0x1f7916=_0x2ec946;Window_QTE_HelpBase['prototype'][_0x1f7916(0x1c8)][_0x1f7916(0xf1)](this),this[_0x1f7916(0x294)]&&(_0x1f7916(0x188)!==_0x1f7916(0x149)?(this[_0x1f7916(0x2c0)][_0x1f7916(0x171)]=$gameSystem[_0x1f7916(0x164)](),this[_0x1f7916(0x2c0)][_0x1f7916(0x2f1)]=VisuMZ['QTE_TriggerSys'][_0x1f7916(0x1c2)][_0x1f7916(0x207)][_0x1f7916(0x331)]||$gameSystem[_0x1f7916(0x101)]()):(this['cacheData'](),_0x67c490[_0x1f7916(0x28a)][_0x1f7916(0x18a)][_0x1f7916(0xf1)](this,_0x11c5f2)));},Window_QTE_TimingBar[_0x2ec946(0x28a)]['stopCursor']=function(){const _0x5a0a5a=_0x2ec946;this[_0x5a0a5a(0x198)][_0x5a0a5a(0x2ae)]();},Window_QTE_TimingBar['prototype'][_0x2ec946(0x182)]=function(){const _0x2cbfe9=_0x2ec946;return this[_0x2cbfe9(0x198)]['getCursorPosition']();},VisuMZ[_0x2ec946(0x310)][_0x2ec946(0xf0)]=function(_0x5a210d){const _0x26f133=_0x2ec946;var _0x465ce1,_0x7f96d9,_0xa10c2d;for(_0xa10c2d=_0x5a210d[_0x26f133(0x326)]-0x1;_0xa10c2d>0x0;_0xa10c2d--){_0x465ce1=Math[_0x26f133(0x138)](Math[_0x26f133(0x1a1)]()*(_0xa10c2d+0x1)),_0x7f96d9=_0x5a210d[_0xa10c2d],_0x5a210d[_0xa10c2d]=_0x5a210d[_0x465ce1],_0x5a210d[_0x465ce1]=_0x7f96d9;}return _0x5a210d;};