//=============================================================================
// VisuStella MZ - Tutorial Panel System
// VisuMZ_2_TutorialPanelSys.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_2_TutorialPanelSys = true;

var VisuMZ = VisuMZ || {};
VisuMZ.TutorialPanelSys = VisuMZ.TutorialPanelSys || {};
VisuMZ.TutorialPanelSys.version = 1.01;

//=============================================================================
/* ----------------------------------------------------------------------------
 * Category List Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Category:
 *
 * @param Key:str
 * @text ID Key
 * @desc This category's identification key. Categories require
 * unique keys for the plugin to differentiate them.
 * @default (Needs Key)
 *
 * @param Title:str
 * @text Title
 * @desc This category's title.
 * You may use text codes.
 * @default Untitled
 * 
 */
/* ----------------------------------------------------------------------------
 * Tutorial List Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Tutorial:
 *
 * @param Key:str
 * @text ID Key
 * @desc This tutorial's identification key. Tutorials require
 * unique keys for the plugin to differentiate them.
 * @default (Needs Key)
 *
 * @param Title:str
 * @text Title
 * @desc This tutorial's title. Displayed in a separate window.
 * You may use text codes.
 * @default Untitled
 *
 * @param Category:str
 * @text Category
 * @desc The category this tutorial is listed under.
 * If unlisted, the tutorial will be listed under "Unlisted".
 * @default Unlisted
 *
 * @param Pages:arraystruct
 * @text Pages
 * @type struct<Page>[]
 * @desc List of pages that are shown for this tutorial.
 * Pages are displayed in the order listed.
 * @default []
 *
 */
/* ----------------------------------------------------------------------------
 * Page Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Page:
 *
 * @param Filename:str
 * @text Filename
 * @type file
 * @dir img/pictures/
 * @require 1
 * @desc Displayed image associated with this page.
 * Found in the game project's /img/pictures/ folder.
 * @default Untitled
 *
 * @param Description:json
 * @text Description
 * @type note
 * @desc The description text displayed for this page.
 * Text codes are allowed.
 * @default "Line 1\nLine 2\nLine 3"
 *
 */
/* ----------------------------------------------------------------------------
 * Scene_TutorialData Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~SceneTutorialData:
 *
 * @param Background
 *
 * @param SnapshotOpacity:num
 * @text Snapshop Opacity
 * @parent Background
 * @type number
 * @min 0
 * @max 255
 * @desc Snapshot opacity for the scene.
 * @default 192
 *
 * @param BgFilename1:str
 * @text Background 1
 * @parent Background
 * @type file
 * @dir img/titles1/
 * @require 1
 * @desc Filename used for the bottom background image.
 * Leave empty if you don't wish to use one.
 * @default 
 *
 * @param BgFilename2:str
 * @text Background 2
 * @parent Background
 * @type file
 * @dir img/titles2/
 * @require 1
 * @desc Filename used for the upper background image.
 * Leave empty if you don't wish to use one.
 * @default 
 * 
 * @param Vocab
 * @text Button Assist Vocab
 *
 * @param VocabChangePage:str
 * @text Change Page
 * @parent Vocab
 * @desc Vocabulary used for changing pages.
 * You may use text codes.
 * @default Change Page
 *
 * @param VocabNextPage:str
 * @text Next Page
 * @parent Vocab
 * @desc Vocabulary used for moving to the next page.
 * You may use text codes.
 * @default Next
 *
 * @param VocabDoneTutorial:str
 * @text Done Tutorial
 * @parent Vocab
 * @desc Vocabulary used for being done with the tutorial.
 * You may use text codes.
 * @default Done
 * 
 * @param Windows
 * 
 * @param Window_TutorialPages
 * @text Pages Window
 * @parent Windows
 *
 * @param VocabActivePage:str
 * @text Active Page Text
 * @parent Window_TutorialPages
 * @desc Vocabulary used for active page.
 * You may use text codes.
 * @default \I[163]
 *
 * @param VocabInactivePage:str
 * @text Inactive Page Text
 * @parent Window_TutorialPages
 * @desc Vocabulary used for inactive page.
 * You may use text codes.
 * @default \I[161]
 *
 * @param PageWindow_BgType:num
 * @text Background Type
 * @parent Window_TutorialPages
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 2
 *
 * @param PageWindow_RectJS:func
 * @text JS: X, Y, W, H
 * @parent Window_TutorialPages
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const ww = Math.max(720, Math.floor(Graphics.boxWidth * 0.75));\nconst wh = this.calcWindowHeight(1, true);\nconst wx = Math.floor((Graphics.boxWidth - ww) / 2);\nconst wy = this.mainAreaBottom() - wh;\nreturn new Rectangle(wx, wy, ww, wh);"
 * 
 * @param Window_TutorialDescription
 * @text Description Window
 * @parent Windows
 *
 * @param DescWindow_BgType:num
 * @text Background Type
 * @parent Window_TutorialDescription
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param DescWindow_RectJS:func
 * @text JS: X, Y, W, H
 * @parent Window_TutorialDescription
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const ww = Math.max(720, Math.floor(Graphics.boxWidth * 0.75));\nconst wh = this.calcWindowHeight(4, false);\nconst wx = Math.floor((Graphics.boxWidth - ww) / 2);\nconst wy = this.mainAreaBottom() - wh - this.calcWindowHeight(1, true);\nreturn new Rectangle(wx, wy, ww, wh);"
 * 
 * @param Window_TutorialPicture
 * @text Picture Window
 * @parent Windows
 *
 * @param PictureWindow_BgType:num
 * @text Background Type
 * @parent Window_TutorialPicture
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 2
 *
 * @param PictureWindow_RectJS:func
 * @text JS: X, Y, W, H
 * @parent Window_TutorialPicture
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const descWindow = arguments[0];\n\nconst ww = descWindow.width;\nconst wh = this.mainAreaHeight() - descWindow.height - this.calcWindowHeight(1, true);\nconst wx = descWindow.x;\nconst wy = this.mainAreaTop();\n\nreturn new Rectangle(wx, wy, ww, wh);"
 * 
 * @param Window_TutorialTitle
 * @text Title Window
 * @parent Windows
 *
 * @param TitleWindow_BgType:num
 * @text Background Type
 * @parent Window_TutorialTitle
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param TitleWindow_RectJS:func
 * @text JS: X, Y, W, H
 * @parent Window_TutorialTitle
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const descWindow = arguments[0];\n\nconst ww = Math.max(descWindow.width - 300, 480);\nconst wh = this.calcWindowHeight(1, false);\nconst wx = Math.floor((Graphics.boxWidth - ww) / 2);\nconst wy = descWindow.y - Math.floor(wh / 2);\n\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 */
/* ----------------------------------------------------------------------------
 * Scene_TutorialList Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~SceneTutorialList:
 *
 * @param MainMenu
 * @text Main Menu Settings
 *
 * @param MainMenuName:str
 * @text Command Name
 * @parent MainMenu
 * @desc Name of the 'Tutorials' option in the Main Menu.
 * @default Tutorials
 *
 * @param ShowMainMenu:eval
 * @text Show in Main Menu?
 * @parent MainMenu
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Add the 'Tutorials' option to the Main Menu by default?
 * @default true
 *
 * @param EnableMainMenu:eval
 * @text Enable in Main Menu?
 * @parent MainMenu
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Enable the 'Tutorials' option to the Main Menu by default?
 * @default true
 *
 * @param Background
 *
 * @param SnapshotOpacity:num
 * @text Snapshop Opacity
 * @parent Background
 * @type number
 * @min 0
 * @max 255
 * @desc Snapshot opacity for the scene.
 * @default 192
 *
 * @param BgFilename1:str
 * @text Background 1
 * @parent Background
 * @type file
 * @dir img/titles1/
 * @require 1
 * @desc Filename used for the bottom background image.
 * Leave empty if you don't wish to use one.
 * @default 
 *
 * @param BgFilename2:str
 * @text Background 2
 * @parent Background
 * @type file
 * @dir img/titles2/
 * @require 1
 * @desc Filename used for the upper background image.
 * Leave empty if you don't wish to use one.
 * @default 
 * 
 * @param Vocab
 * @text Button Assist Vocab
 * 
 * @param VocabView:str
 * @text View Tutorial
 * @parent Vocab
 * @desc Text for viewing tutorial.
 * @default View
 * 
 * @param VocabExpand:str
 * @text Expand Category
 * @parent Vocab
 * @desc Text for expanding categories.
 * @default Expand
 *
 * @param VocabCollapse:str
 * @text Collapse Category
 * @parent Vocab
 * @desc Text for collapsing categories.
 * @default Collapse
 * 
 * @param Windows
 * 
 * @param Window_TutorialList
 * @text List Window
 * @parent Windows
 *
 * @param VocabOpenCategory:str
 * @text Open Categories
 * @parent Window_TutorialList
 * @desc Text format for an open category.
 * %1 - Category Name, %2 - Quest Amount
 * @default - %1(%2)
 *
 * @param VocabClosedCategory:str
 * @text Closed Categories
 * @parent Window_TutorialList
 * @desc Text format for an open category.
 * %1 - Category Name, %2 - Quest Amount
 * @default + %1(%2)
 *
 * @param VocabUnlisted:str
 * @text Unlisted Category
 * @parent Window_TutorialList
 * @desc Text used for "unlisted" category.
 * You may use text codes.
 * @default \C[8]Uncategorized
 *
 * @param ListWindow_BgType:num
 * @text Background Type
 * @parent Window_TutorialList
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param ListWindow_RectJS:func
 * @text JS: X, Y, W, H
 * @parent Window_TutorialList
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const fw = Math.max(720, Math.floor(Graphics.boxWidth * 0.75));\nconst ww = Math.max(fw - 300, 480);\nconst wh = this.calcWindowHeight(10, true);\nconst wx = Math.floor((Graphics.boxWidth - ww) / 2);\nconst wy = Math.floor((Graphics.boxHeight - wh) / 2);\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 */
/* ----------------------------------------------------------------------------
 * Scene_Battle Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~SceneBattle:
 *
 * @param Windows
 * 
 * @param Window_BattleStatus
 * @text Battle Status Window
 * @parent Windows
 *
 * @param HideDuring:eval
 * @text Hide During?
 * @parent Window_BattleStatus
 * @type boolean
 * @on Hide
 * @off Normal
 * @desc Hide the battle status window during tutorials?
 * Does NOT affect VisuMZ_3_SideviewBattleUI!
 * @default true
 * 
 * @param Window_TutorialPages
 * @text Pages Window
 * @parent Windows
 *
 * @param PageWindow_BgType:num
 * @text Background Type
 * @parent Window_TutorialPages
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 2
 *
 * @param PageWindow_RectJS:func
 * @text JS: X, Y, W, H
 * @parent Window_TutorialPages
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const ww = Math.max(720, Math.floor(Graphics.boxWidth * 0.75));\nconst wh = this.calcWindowHeight(1, true);\nconst wx = Math.floor((Graphics.boxWidth - ww) / 2);\nconst wy = Graphics.boxHeight - wh;\nreturn new Rectangle(wx, wy, ww, wh);"
 * 
 * @param Window_TutorialDescription
 * @text Description Window
 * @parent Windows
 *
 * @param DescWindow_BgType:num
 * @text Background Type
 * @parent Window_TutorialDescription
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param DescWindow_RectJS:func
 * @text JS: X, Y, W, H
 * @parent Window_TutorialDescription
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const ww = Math.max(720, Math.floor(Graphics.boxWidth * 0.75));\nconst wh = this.calcWindowHeight(4, false);\nconst wx = Math.floor((Graphics.boxWidth - ww) / 2);\nconst wy = Graphics.boxHeight - wh - this.calcWindowHeight(1, true);\nreturn new Rectangle(wx, wy, ww, wh);"
 * 
 * @param Window_TutorialPicture
 * @text Picture Window
 * @parent Windows
 *
 * @param PictureWindow_BgType:num
 * @text Background Type
 * @parent Window_TutorialPicture
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 2
 *
 * @param PictureWindow_RectJS:func
 * @text JS: X, Y, W, H
 * @parent Window_TutorialPicture
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const descWindow = arguments[0];\n\nconst ww = descWindow.width;\nconst wh = (Graphics.boxHeight - this.buttonAreaHeight()) - descWindow.height - this.calcWindowHeight(1, true);\nconst wx = descWindow.x;\nconst wy = this.buttonAreaHeight();\n\nreturn new Rectangle(wx, wy, ww, wh);"
 * 
 * @param Window_TutorialTitle
 * @text Title Window
 * @parent Windows
 *
 * @param TitleWindow_BgType:num
 * @text Background Type
 * @parent Window_TutorialTitle
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param TitleWindow_RectJS:func
 * @text JS: X, Y, W, H
 * @parent Window_TutorialTitle
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const descWindow = arguments[0];\n\nconst ww = Math.max(descWindow.width - 300, 480);\nconst wh = this.calcWindowHeight(1, false);\nconst wx = Math.floor((Graphics.boxWidth - ww) / 2);\nconst wy = descWindow.y - Math.floor(wh / 2);\n\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 */
/* ----------------------------------------------------------------------------
 * Options Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Options:
 *
 * @param Options
 * @text Options
 *
 * @param AddTutorialsOption:eval
 * @text Add Option?
 * @parent Options
 * @type boolean
 * @on Add
 * @off Don't Add
 * @desc Add the 'Tutorials' option to the Options menu?
 * @default true
 *
 * @param AdjustRect:eval
 * @text Adjust Window Height
 * @parent Options
 * @type boolean
 * @on Adjust
 * @off Don't
 * @desc Automatically adjust the options window height?
 * @default true
 *
 * @param Name:str
 * @text Option Name
 * @parent Options
 * @desc Command name of the option.
 * @default Tutorials
 *
 */
/* ----------------------------------------------------------------------------
 * Sound Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Sound:
 *
 * @param name:str
 * @text Filename
 * @type file
 * @dir audio/se/
 * @require 1
 * @desc Filename of the sound effect played.
 * @default Book1
 *
 * @param volume:num
 * @text Volume
 * @type number
 * @max 100
 * @desc Volume of the sound effect played.
 * @default 90
 *
 * @param pitch:num
 * @text Pitch
 * @type number
 * @desc Pitch of the sound effect played.
 * @default 120
 *
 * @param pan:num
 * @text Pan
 * @desc Pan of the sound effect played.
 * @default 0
 *
 */
//=============================================================================

const _0x48a455=_0x4f25;(function(_0x1c359e,_0x338045){const _0x566fb2=_0x4f25,_0x26f864=_0x1c359e();while(!![]){try{const _0x3c5e0c=parseInt(_0x566fb2(0x29a))/0x1*(-parseInt(_0x566fb2(0x2b9))/0x2)+-parseInt(_0x566fb2(0x33a))/0x3+-parseInt(_0x566fb2(0x28d))/0x4*(-parseInt(_0x566fb2(0x1e9))/0x5)+parseInt(_0x566fb2(0x22a))/0x6+-parseInt(_0x566fb2(0x2e7))/0x7*(-parseInt(_0x566fb2(0x355))/0x8)+parseInt(_0x566fb2(0x320))/0x9*(-parseInt(_0x566fb2(0x26e))/0xa)+-parseInt(_0x566fb2(0x319))/0xb*(-parseInt(_0x566fb2(0x290))/0xc);if(_0x3c5e0c===_0x338045)break;else _0x26f864['push'](_0x26f864['shift']());}catch(_0x10d8ee){_0x26f864['push'](_0x26f864['shift']());}}}(_0x6787,0x4739b));var label='TutorialPanelSys',tier=tier||0x0,dependencies=[],pluginData=$plugins[_0x48a455(0x317)](function(_0x22eed9){const _0x4e572b=_0x48a455;return _0x22eed9[_0x4e572b(0x222)]&&_0x22eed9[_0x4e572b(0x1da)]['includes']('['+label+']');})[0x0];VisuMZ[label]['Settings']=VisuMZ[label][_0x48a455(0x32f)]||{},VisuMZ['ConvertParams']=function(_0x4b0cbe,_0x12045a){const _0x1d73ba=_0x48a455;for(const _0x17dcca in _0x12045a){if(_0x17dcca['match'](/(.*):(.*)/i)){if(_0x1d73ba(0x2c5)===_0x1d73ba(0x2c5)){const _0x2d3af6=String(RegExp['$1']),_0x82c104=String(RegExp['$2'])['toUpperCase']()['trim']();let _0x245b42,_0x23c484,_0x5494d1;switch(_0x82c104){case'NUM':_0x245b42=_0x12045a[_0x17dcca]!==''?Number(_0x12045a[_0x17dcca]):0x0;break;case'ARRAYNUM':_0x23c484=_0x12045a[_0x17dcca]!==''?JSON[_0x1d73ba(0x2d4)](_0x12045a[_0x17dcca]):[],_0x245b42=_0x23c484[_0x1d73ba(0x28b)](_0x491955=>Number(_0x491955));break;case'EVAL':_0x245b42=_0x12045a[_0x17dcca]!==''?eval(_0x12045a[_0x17dcca]):null;break;case _0x1d73ba(0x2f4):_0x23c484=_0x12045a[_0x17dcca]!==''?JSON['parse'](_0x12045a[_0x17dcca]):[],_0x245b42=_0x23c484['map'](_0x1f5215=>eval(_0x1f5215));break;case _0x1d73ba(0x35b):_0x245b42=_0x12045a[_0x17dcca]!==''?JSON['parse'](_0x12045a[_0x17dcca]):'';break;case _0x1d73ba(0x2e8):_0x23c484=_0x12045a[_0x17dcca]!==''?JSON[_0x1d73ba(0x2d4)](_0x12045a[_0x17dcca]):[],_0x245b42=_0x23c484[_0x1d73ba(0x28b)](_0x5f0bd2=>JSON[_0x1d73ba(0x2d4)](_0x5f0bd2));break;case _0x1d73ba(0x252):_0x245b42=_0x12045a[_0x17dcca]!==''?new Function(JSON[_0x1d73ba(0x2d4)](_0x12045a[_0x17dcca])):new Function(_0x1d73ba(0x1d8));break;case _0x1d73ba(0x1eb):_0x23c484=_0x12045a[_0x17dcca]!==''?JSON[_0x1d73ba(0x2d4)](_0x12045a[_0x17dcca]):[],_0x245b42=_0x23c484[_0x1d73ba(0x28b)](_0xd4138e=>new Function(JSON[_0x1d73ba(0x2d4)](_0xd4138e)));break;case'STR':_0x245b42=_0x12045a[_0x17dcca]!==''?String(_0x12045a[_0x17dcca]):'';break;case _0x1d73ba(0x295):_0x23c484=_0x12045a[_0x17dcca]!==''?JSON[_0x1d73ba(0x2d4)](_0x12045a[_0x17dcca]):[],_0x245b42=_0x23c484[_0x1d73ba(0x28b)](_0x62f157=>String(_0x62f157));break;case _0x1d73ba(0x2ad):_0x5494d1=_0x12045a[_0x17dcca]!==''?JSON[_0x1d73ba(0x2d4)](_0x12045a[_0x17dcca]):{},_0x245b42=VisuMZ[_0x1d73ba(0x272)]({},_0x5494d1);break;case _0x1d73ba(0x208):_0x23c484=_0x12045a[_0x17dcca]!==''?JSON[_0x1d73ba(0x2d4)](_0x12045a[_0x17dcca]):[],_0x245b42=_0x23c484[_0x1d73ba(0x28b)](_0x3406a7=>VisuMZ['ConvertParams']({},JSON['parse'](_0x3406a7)));break;default:continue;}_0x4b0cbe[_0x2d3af6]=_0x245b42;}else this[_0x1d73ba(0x2b6)]();}}return _0x4b0cbe;},(_0x41c628=>{const _0x2359d3=_0x48a455,_0x45d50f=_0x41c628[_0x2359d3(0x1e4)];for(const _0x224d35 of dependencies){if(!Imported[_0x224d35]){alert(_0x2359d3(0x20a)['format'](_0x45d50f,_0x224d35)),SceneManager[_0x2359d3(0x304)]();break;}}const _0x34b96f=_0x41c628[_0x2359d3(0x1da)];if(_0x34b96f[_0x2359d3(0x21f)](/\[Version[ ](.*?)\]/i)){if(_0x2359d3(0x2f0)===_0x2359d3(0x2f0)){const _0x4fb9dd=Number(RegExp['$1']);if(_0x4fb9dd!==VisuMZ[label]['version']){if(_0x2359d3(0x239)==='eDsPj'){if(_0x62cf56['TutorialPanelSys']['Settings']['SceneBattle'][_0x2359d3(0x343)])return _0x5d7ee0[_0x2359d3(0x21d)][_0x2359d3(0x32f)][_0x2359d3(0x228)][_0x2359d3(0x343)][_0x2359d3(0x2b5)](this);const _0x54317b=_0x21c291['max'](0x2d0,_0x308fed[_0x2359d3(0x2db)](_0x464ce6[_0x2359d3(0x287)]*0.75)),_0x350d8c=this[_0x2359d3(0x28f)](0x4,![]),_0x26cdf3=_0x3e9b49[_0x2359d3(0x2db)]((_0x3b3a99['boxWidth']-_0x54317b)/0x2),_0x487088=_0x5b3cda['boxHeight']-_0x350d8c-this['calcWindowHeight'](0x1,!![]);return new _0xe1f34(_0x26cdf3,_0x487088,_0x54317b,_0x350d8c);}else alert(_0x2359d3(0x2c0)[_0x2359d3(0x318)](_0x45d50f,_0x4fb9dd)),SceneManager['exit']();}}else _0x1241dc[_0x2359d3(0x2f9)](_0x1541ac);}if(_0x34b96f[_0x2359d3(0x21f)](/\[Tier[ ](\d+)\]/i)){if('aiuwh'!==_0x2359d3(0x353)){const _0x54242a=Number(RegExp['$1']);if(_0x54242a<tier)alert(_0x2359d3(0x1d9)[_0x2359d3(0x318)](_0x45d50f,_0x54242a,tier)),SceneManager['exit']();else{if(_0x2359d3(0x285)!==_0x2359d3(0x285)){if(_0x26214a[_0x2359d3(0x21d)]['Settings']['SceneBattle'][_0x2359d3(0x1f9)])return _0x541d04[_0x2359d3(0x21d)][_0x2359d3(0x32f)]['SceneBattle']['PageWindow_RectJS'][_0x2359d3(0x2b5)](this);const _0x956080=_0x5cc324[_0x2359d3(0x31f)](0x2d0,_0x35ba09[_0x2359d3(0x2db)](_0x14ab24['boxWidth']*0.75)),_0x5a3cfc=this[_0x2359d3(0x28f)](0x1,!![]),_0x18891=_0x3585d3[_0x2359d3(0x2db)]((_0x37f8bf[_0x2359d3(0x287)]-_0x956080)/0x2),_0x1469d5=_0x161e9d[_0x2359d3(0x2c6)]-_0x5a3cfc;return new _0x15a19d(_0x18891,_0x1469d5,_0x956080,_0x5a3cfc);}else tier=Math[_0x2359d3(0x31f)](_0x54242a,tier);}}else this[_0x2359d3(0x2d3)](0x0,0x0,0x0,0x0);}VisuMZ[_0x2359d3(0x272)](VisuMZ[label]['Settings'],_0x41c628['parameters']);})(pluginData),PluginManager['registerCommand'](pluginData[_0x48a455(0x1e4)],'TutorialCall',_0x1d7d7a=>{const _0x1de90f=_0x48a455;VisuMZ[_0x1de90f(0x272)](_0x1d7d7a,_0x1d7d7a);const _0x3681a4=_0x1d7d7a[_0x1de90f(0x348)],_0x56c7ca=_0x1d7d7a[_0x1de90f(0x288)],_0x236ae6=_0x1d7d7a[_0x1de90f(0x26d)],_0x15fc37=_0x1d7d7a[_0x1de90f(0x236)];if(VisuMZ[_0x1de90f(0x21d)][_0x1de90f(0x1f3)](_0x3681a4)){if(!_0x56c7ca&&_0x236ae6&&$gameSystem[_0x1de90f(0x336)](_0x3681a4))return;(_0x56c7ca||ConfigManager[_0x1de90f(0x2f1)])&&$gameTemp['openTutorial'](_0x3681a4),_0x15fc37&&$gameSystem[_0x1de90f(0x2f9)](_0x3681a4);}}),PluginManager[_0x48a455(0x31c)](pluginData[_0x48a455(0x1e4)],_0x48a455(0x1de),_0x5eba18=>{const _0x58ea5d=_0x48a455;VisuMZ['ConvertParams'](_0x5eba18,_0x5eba18);const _0x3ae6db=_0x5eba18[_0x58ea5d(0x240)];for(const _0x780440 of _0x3ae6db){if('iwEKi'===_0x58ea5d(0x2f5))$gameSystem['registerTutorialKey'](_0x780440);else{_0x2b6796['TutorialPanelSys']['Scene_Menu_createCommandWindow'][_0x58ea5d(0x2b5)](this);const _0x1a39e1=this[_0x58ea5d(0x1fb)];_0x1a39e1[_0x58ea5d(0x2ed)]('tutorialList',this[_0x58ea5d(0x2a7)][_0x58ea5d(0x274)](this));}}}),PluginManager[_0x48a455(0x31c)](pluginData[_0x48a455(0x1e4)],'DebugFullTutorial',_0x17b91c=>{const _0x1e0726=_0x48a455;if(!$gameTemp[_0x1e0726(0x2e9)]())return;VisuMZ['ConvertParams'](_0x17b91c,_0x17b91c),$gameTemp[_0x1e0726(0x1e8)](_0x17b91c[_0x1e0726(0x267)]);}),PluginManager['registerCommand'](pluginData['name'],_0x48a455(0x271),_0x23e021=>{const _0x1ac3b1=_0x48a455;VisuMZ[_0x1ac3b1(0x272)](_0x23e021,_0x23e021),$gameSystem['setMainMenuTutorialLabelEnabled'](_0x23e021[_0x1ac3b1(0x1f2)]);}),PluginManager[_0x48a455(0x31c)](pluginData[_0x48a455(0x1e4)],_0x48a455(0x309),_0x49f68b=>{const _0x16babc=_0x48a455;VisuMZ[_0x16babc(0x272)](_0x49f68b,_0x49f68b),$gameSystem[_0x16babc(0x1e2)](_0x49f68b['Show']);}),VisuMZ[_0x48a455(0x21d)]['Scene_Boot_onDatabaseLoaded']=Scene_Boot[_0x48a455(0x341)]['onDatabaseLoaded'],Scene_Boot['prototype']['onDatabaseLoaded']=function(){const _0x2b1ad5=_0x48a455;VisuMZ[_0x2b1ad5(0x21d)][_0x2b1ad5(0x2a9)][_0x2b1ad5(0x2b5)](this),this[_0x2b1ad5(0x2ae)]();},Scene_Boot['prototype'][_0x48a455(0x2ae)]=function(){const _0x25dcd0=_0x48a455;this[_0x25dcd0(0x346)](),this['process_VisuMZ_TutorialData']();},Scene_Boot['prototype'][_0x48a455(0x346)]=function(){const _0x14efdd=_0x48a455;VisuMZ[_0x14efdd(0x21d)][_0x14efdd(0x26a)]=[_0x14efdd(0x35f)],VisuMZ[_0x14efdd(0x21d)][_0x14efdd(0x2f8)]={},VisuMZ[_0x14efdd(0x21d)][_0x14efdd(0x22c)]={},VisuMZ['TutorialPanelSys'][_0x14efdd(0x22c)][_0x14efdd(0x35f)]=[];const _0x1c6fd7=VisuMZ[_0x14efdd(0x21d)][_0x14efdd(0x32f)]['Categories'];for(const _0x4f6bd4 of _0x1c6fd7){const _0x48ffe5=(_0x4f6bd4['Key']||'')[_0x14efdd(0x1fa)]()[_0x14efdd(0x280)]();if(_0x48ffe5==='')continue;if(_0x48ffe5===_0x14efdd(0x250))continue;VisuMZ[_0x14efdd(0x21d)][_0x14efdd(0x26a)][_0x14efdd(0x23b)](_0x48ffe5),VisuMZ['TutorialPanelSys'][_0x14efdd(0x2f8)][_0x48ffe5]=_0x4f6bd4,VisuMZ[_0x14efdd(0x21d)][_0x14efdd(0x22c)][_0x48ffe5]=[];}},Scene_Boot[_0x48a455(0x341)][_0x48a455(0x243)]=function(){const _0x4ec484=_0x48a455;VisuMZ[_0x4ec484(0x21d)][_0x4ec484(0x206)]={},VisuMZ[_0x4ec484(0x21d)][_0x4ec484(0x1f5)]=[];const _0x145955=VisuMZ['TutorialPanelSys'][_0x4ec484(0x32f)][_0x4ec484(0x206)];for(const _0x4a4fcc of _0x145955){const _0xcdcf6b=(_0x4a4fcc[_0x4ec484(0x348)]||'')[_0x4ec484(0x1fa)]()[_0x4ec484(0x280)]();if(_0xcdcf6b==='')continue;if(_0xcdcf6b===_0x4ec484(0x250))continue;VisuMZ['TutorialPanelSys'][_0x4ec484(0x206)][_0xcdcf6b]=_0x4a4fcc,VisuMZ[_0x4ec484(0x21d)][_0x4ec484(0x1f5)]['push'](_0xcdcf6b);const _0x4a7614=(_0x4a4fcc[_0x4ec484(0x253)]||'')['toLowerCase']()['trim']();VisuMZ[_0x4ec484(0x21d)][_0x4ec484(0x22c)][_0x4a7614]?VisuMZ['TutorialPanelSys'][_0x4ec484(0x22c)][_0x4a7614]['push'](_0xcdcf6b):_0x4ec484(0x30e)!==_0x4ec484(0x202)?VisuMZ[_0x4ec484(0x21d)][_0x4ec484(0x22c)][_0x4ec484(0x35f)][_0x4ec484(0x23b)](_0xcdcf6b):this[_0x4ec484(0x31b)]();}},VisuMZ['TutorialPanelSys'][_0x48a455(0x1f3)]=function(_0x509121){const _0x19cd7=_0x48a455;return _0x509121=_0x509121[_0x19cd7(0x1fa)]()[_0x19cd7(0x280)](),VisuMZ[_0x19cd7(0x21d)][_0x19cd7(0x1f5)][_0x19cd7(0x22f)](_0x509121);},ConfigManager[_0x48a455(0x2f1)]=!![],VisuMZ['TutorialPanelSys'][_0x48a455(0x213)]=ConfigManager[_0x48a455(0x2e2)],ConfigManager['makeData']=function(){const _0xa1909d=_0x48a455,_0x16cd67=VisuMZ[_0xa1909d(0x21d)][_0xa1909d(0x213)][_0xa1909d(0x2b5)](this);return _0x16cd67[_0xa1909d(0x2f1)]=this[_0xa1909d(0x2f1)],_0x16cd67;},VisuMZ[_0x48a455(0x21d)][_0x48a455(0x1d7)]=ConfigManager['applyData'],ConfigManager[_0x48a455(0x1ea)]=function(_0x1a2cfd){const _0x3bf74f=_0x48a455;VisuMZ[_0x3bf74f(0x21d)][_0x3bf74f(0x1d7)][_0x3bf74f(0x2b5)](this,_0x1a2cfd),this[_0x3bf74f(0x256)](_0x1a2cfd,_0x3bf74f(0x2f1),!![]);if('showTutorials'in _0x1a2cfd)this[_0x3bf74f(0x2f1)]=_0x1a2cfd[_0x3bf74f(0x2f1)];else{if(_0x3bf74f(0x32a)!=='LOEfP')this['showTutorials']=!![];else{this[_0x3bf74f(0x224)]['activate']();return;}}},SoundManager[_0x48a455(0x2bd)]=function(){const _0x8f8542=_0x48a455,_0x2c4744=VisuMZ['TutorialPanelSys'][_0x8f8542(0x32f)][_0x8f8542(0x2a5)],_0x270e51={'name':_0x2c4744[_0x8f8542(0x1e4)],'volume':_0x2c4744[_0x8f8542(0x23c)],'pitch':_0x2c4744[_0x8f8542(0x2d5)],'pan':_0x2c4744[_0x8f8542(0x25d)]};AudioManager['playSe'](_0x270e51);},TextManager['tutorial']={'changePage':VisuMZ[_0x48a455(0x21d)][_0x48a455(0x32f)][_0x48a455(0x2e5)][_0x48a455(0x22e)],'nextPage':VisuMZ['TutorialPanelSys'][_0x48a455(0x32f)]['SceneTutorialData'][_0x48a455(0x344)],'finish':VisuMZ[_0x48a455(0x21d)][_0x48a455(0x32f)][_0x48a455(0x2e5)][_0x48a455(0x291)],'view':VisuMZ['TutorialPanelSys'][_0x48a455(0x32f)][_0x48a455(0x357)]['VocabView'],'expand':VisuMZ[_0x48a455(0x21d)][_0x48a455(0x32f)]['SceneTutorialList'][_0x48a455(0x293)],'collapse':VisuMZ[_0x48a455(0x21d)][_0x48a455(0x32f)][_0x48a455(0x357)][_0x48a455(0x2d1)],'activePage':VisuMZ[_0x48a455(0x21d)]['Settings'][_0x48a455(0x2e5)][_0x48a455(0x2e1)],'inactivePage':VisuMZ[_0x48a455(0x21d)]['Settings'][_0x48a455(0x2e5)][_0x48a455(0x314)],'optionsCmd':VisuMZ[_0x48a455(0x21d)][_0x48a455(0x32f)][_0x48a455(0x1e7)][_0x48a455(0x331)],'menuCmd':VisuMZ['TutorialPanelSys'][_0x48a455(0x32f)][_0x48a455(0x357)]['MainMenuName'],'openCategoriesFmt':VisuMZ[_0x48a455(0x21d)][_0x48a455(0x32f)]['SceneTutorialList'][_0x48a455(0x324)],'closedCategoriesFmt':VisuMZ['TutorialPanelSys']['Settings'][_0x48a455(0x357)][_0x48a455(0x2d2)],'unlisted':VisuMZ[_0x48a455(0x21d)][_0x48a455(0x32f)][_0x48a455(0x357)]['VocabUnlisted']},SceneManager['isSceneBattle']=function(){const _0x41ddc3=_0x48a455;return this[_0x41ddc3(0x1fe)]&&this[_0x41ddc3(0x1fe)]['constructor']===Scene_Battle;},SceneManager[_0x48a455(0x306)]=function(){const _0x222449=_0x48a455;return this[_0x222449(0x1fe)]&&this[_0x222449(0x1fe)][_0x222449(0x2aa)]===Scene_Map;},Game_Temp[_0x48a455(0x341)][_0x48a455(0x35d)]=function(_0x170768){const _0x38c92a=_0x48a455;if(!VisuMZ[_0x38c92a(0x21d)][_0x38c92a(0x1f3)](_0x170768))return;this[_0x38c92a(0x2b8)]=_0x170768;if(SceneManager[_0x38c92a(0x1ef)]()){if(_0x38c92a(0x24f)!=='HFBbx')_0x4b1b6c['playCancel'](),this[_0x38c92a(0x20d)]();else{const _0xada290=SceneManager[_0x38c92a(0x1fe)];_0xada290['openTutorial'](_0x170768);}}else{if(_0x38c92a(0x2df)===_0x38c92a(0x2b3)){if(this[_0x38c92a(0x338)]===_0x4f67dd)this['initTutorialPanelSysMainMenu']();if(!this[_0x38c92a(0x25f)])return![];if(this[_0x38c92a(0x25f)]['length']<=0x0)return![];return this[_0x38c92a(0x338)][_0x38c92a(0x28e)];}else{SceneManager[_0x38c92a(0x23b)](Scene_TutorialData);const _0x5ee496=this['getLastPluginCommandInterpreter']();_0x5ee496&&_0x5ee496[_0x38c92a(0x297)](0xa);}}},Game_Temp['prototype'][_0x48a455(0x21a)]=function(_0x10e575){const _0x2167a8=_0x48a455;this[_0x2167a8(0x352)]=_0x10e575;},Game_Temp['prototype'][_0x48a455(0x34f)]=function(){const _0x37ae66=_0x48a455;return this[_0x37ae66(0x352)];},VisuMZ['TutorialPanelSys'][_0x48a455(0x34d)]=Game_Interpreter[_0x48a455(0x341)][_0x48a455(0x23a)],Game_Interpreter[_0x48a455(0x341)]['command357']=function(_0x4d009b){const _0x288a2f=_0x48a455;return $gameTemp[_0x288a2f(0x21a)](this),VisuMZ[_0x288a2f(0x21d)][_0x288a2f(0x34d)][_0x288a2f(0x2b5)](this,_0x4d009b);},Game_Temp[_0x48a455(0x341)][_0x48a455(0x2d6)]=function(){return this['isPlaytest']()&&this['_debugViewTutorialList'];},Game_Temp[_0x48a455(0x341)][_0x48a455(0x1e8)]=function(_0x123f6b){const _0x34f27f=_0x48a455;this[_0x34f27f(0x2ef)]=_0x123f6b;},VisuMZ['TutorialPanelSys'][_0x48a455(0x2b0)]=Game_System[_0x48a455(0x341)]['initialize'],Game_System['prototype'][_0x48a455(0x1f8)]=function(){const _0x5e5a21=_0x48a455;VisuMZ['TutorialPanelSys']['Game_System_initialize'][_0x5e5a21(0x2b5)](this),this[_0x5e5a21(0x234)](),this[_0x5e5a21(0x257)]();},Game_System[_0x48a455(0x341)]['initTutorialPanelSysMainMenu']=function(){const _0x55372b=_0x48a455;this[_0x55372b(0x338)]={'shown':VisuMZ[_0x55372b(0x21d)][_0x55372b(0x32f)][_0x55372b(0x357)][_0x55372b(0x29f)],'enabled':VisuMZ[_0x55372b(0x21d)][_0x55372b(0x32f)]['SceneTutorialList'][_0x55372b(0x27a)]};},Game_System['prototype'][_0x48a455(0x30a)]=function(){const _0x270260=_0x48a455;if(this[_0x270260(0x338)]===undefined)this[_0x270260(0x234)]();return this['_TutorialPanelSys_MainMenu'][_0x270260(0x33e)];},Game_System['prototype'][_0x48a455(0x1e2)]=function(_0x10670c){const _0x596f5c=_0x48a455;if(this['_TutorialPanelSys_MainMenu']===undefined)this[_0x596f5c(0x234)]();this[_0x596f5c(0x338)][_0x596f5c(0x33e)]=_0x10670c;},Game_System[_0x48a455(0x341)][_0x48a455(0x28a)]=function(){const _0x3457d0=_0x48a455;if(this['_TutorialPanelSys_MainMenu']===undefined)this[_0x3457d0(0x234)]();if(!this['_visibleTutorialKeys'])return![];if(this['_visibleTutorialKeys'][_0x3457d0(0x22d)]<=0x0)return![];return this[_0x3457d0(0x338)]['enabled'];},Game_System[_0x48a455(0x341)][_0x48a455(0x334)]=function(_0x46f144){const _0x4c3016=_0x48a455;if(this[_0x4c3016(0x338)]===undefined)this[_0x4c3016(0x234)]();this[_0x4c3016(0x338)][_0x4c3016(0x28e)]=_0x46f144;},Game_System[_0x48a455(0x341)][_0x48a455(0x257)]=function(){const _0x521369=_0x48a455;this['_visibleTutorialKeys']=this['_visibleTutorialKeys']||[];const _0x3b9c9e=VisuMZ[_0x521369(0x21d)][_0x521369(0x32f)]['DefaultUnlocked'];for(const _0x34c797 of _0x3b9c9e){this[_0x521369(0x2f9)](_0x34c797);}},Game_System[_0x48a455(0x341)]['registerTutorialKey']=function(_0x145daf){const _0x5c5caf=_0x48a455;if(this['_visibleTutorialKeys']===undefined)this['initTutorialPanelSysSettings']();_0x145daf=_0x145daf[_0x5c5caf(0x1fa)]()[_0x5c5caf(0x280)](),VisuMZ[_0x5c5caf(0x21d)]['isValidTutorial'](_0x145daf)&&!this[_0x5c5caf(0x336)](_0x145daf)&&this[_0x5c5caf(0x25f)][_0x5c5caf(0x23b)](_0x145daf);},Game_System[_0x48a455(0x341)][_0x48a455(0x227)]=function(_0x4c9577){const _0x535a8d=_0x48a455;if(this[_0x535a8d(0x25f)]===undefined)this[_0x535a8d(0x257)]();_0x4c9577=_0x4c9577[_0x535a8d(0x1fa)]()[_0x535a8d(0x280)](),this[_0x535a8d(0x25f)][_0x535a8d(0x286)](_0x4c9577);},Game_System['prototype'][_0x48a455(0x336)]=function(_0x21ee48){const _0x40c8ad=_0x48a455;if(this['_visibleTutorialKeys']===undefined)this[_0x40c8ad(0x257)]();return _0x21ee48=_0x21ee48[_0x40c8ad(0x1fa)]()[_0x40c8ad(0x280)](),this[_0x40c8ad(0x25f)][_0x40c8ad(0x22f)](_0x21ee48);},Game_System[_0x48a455(0x341)]['isTutorialCategoryPopulated']=function(_0x4ffbb4){const _0x266f92=_0x48a455;_0x4ffbb4=_0x4ffbb4[_0x266f92(0x1fa)]()[_0x266f92(0x280)]();if(!VisuMZ[_0x266f92(0x21d)][_0x266f92(0x22c)][_0x4ffbb4])return![];const _0x149475=VisuMZ['TutorialPanelSys'][_0x266f92(0x22c)][_0x4ffbb4];for(const _0x523254 of _0x149475){if(this[_0x266f92(0x336)](_0x523254))return!![];}return![];},Game_System[_0x48a455(0x341)][_0x48a455(0x242)]=function(_0x9b37c5){const _0x1d17f2=_0x48a455;_0x9b37c5=_0x9b37c5['toLowerCase']()[_0x1d17f2(0x280)]();if(!VisuMZ[_0x1d17f2(0x21d)][_0x1d17f2(0x22c)][_0x9b37c5])return 0x0;let _0xd3f2b3=0x0;const _0x5dcf6f=VisuMZ[_0x1d17f2(0x21d)]['CategoryTutorials'][_0x9b37c5];for(const _0x3ee6ac of _0x5dcf6f){if(_0x1d17f2(0x342)===_0x1d17f2(0x219)){if(_0x266466[_0x1d17f2(0x21d)][_0x1d17f2(0x32f)]['SceneBattle']['TitleWindow_RectJS'])return _0x13623a[_0x1d17f2(0x21d)][_0x1d17f2(0x32f)]['SceneBattle'][_0x1d17f2(0x24b)]['call'](this,this[_0x1d17f2(0x34c)]);const _0x53f12c=this[_0x1d17f2(0x34c)],_0x1c8b0e=_0x4b5e79[_0x1d17f2(0x31f)](_0x53f12c['width']-0x12c,0x1e0),_0x310dde=this['calcWindowHeight'](0x1,![]),_0x4105c5=_0x36c3c6[_0x1d17f2(0x2db)]((_0x5e25ff['boxWidth']-_0x1c8b0e)/0x2),_0x166e3c=_0x53f12c['y']-_0x25d6be[_0x1d17f2(0x2db)](_0x310dde/0x2);return new _0x5a5a2f(_0x4105c5,_0x166e3c,_0x1c8b0e,_0x310dde);}else{if($gameTemp[_0x1d17f2(0x2d6)]()){if(_0x1d17f2(0x254)!==_0x1d17f2(0x310)){_0xd3f2b3++;continue;}else return _0x3ef345=_0x3e7225['toLowerCase']()[_0x1d17f2(0x280)](),this[_0x1d17f2(0x2a8)][_0x3f8926];}if(this[_0x1d17f2(0x336)](_0x3ee6ac))_0xd3f2b3++;}}return _0xd3f2b3;},VisuMZ[_0x48a455(0x21d)][_0x48a455(0x1f4)]=Game_Interpreter['prototype'][_0x48a455(0x2fc)],Game_Interpreter[_0x48a455(0x341)][_0x48a455(0x2fc)]=function(){const _0x5e1c75=_0x48a455;if(this[_0x5e1c75(0x300)]==='tutorial')return!![];return VisuMZ['TutorialPanelSys']['Game_Interpreter_updateWaitMode'][_0x5e1c75(0x2b5)](this);},VisuMZ['TutorialPanelSys'][_0x48a455(0x230)]=Scene_Menu[_0x48a455(0x341)][_0x48a455(0x2cd)],Scene_Menu['prototype'][_0x48a455(0x2cd)]=function(){const _0x24d9a3=_0x48a455;VisuMZ[_0x24d9a3(0x21d)]['Scene_Menu_createCommandWindow'][_0x24d9a3(0x2b5)](this);const _0x8ec4a5=this[_0x24d9a3(0x1fb)];_0x8ec4a5[_0x24d9a3(0x2ed)]('tutorialList',this[_0x24d9a3(0x2a7)][_0x24d9a3(0x274)](this));},Scene_Menu[_0x48a455(0x341)]['commandTutorialList']=function(){const _0x49fa6d=_0x48a455;SceneManager[_0x49fa6d(0x23b)](Scene_TutorialList);},VisuMZ[_0x48a455(0x21d)][_0x48a455(0x1fd)]=Scene_Options[_0x48a455(0x341)][_0x48a455(0x2cf)],Scene_Options[_0x48a455(0x341)][_0x48a455(0x2cf)]=function(){const _0x14b1f8=_0x48a455;let _0x52f4e0=VisuMZ['TutorialPanelSys'][_0x14b1f8(0x1fd)][_0x14b1f8(0x2b5)](this);const _0x3de7cc=VisuMZ[_0x14b1f8(0x21d)][_0x14b1f8(0x32f)][_0x14b1f8(0x1e7)];if(_0x3de7cc[_0x14b1f8(0x1f0)]&&_0x3de7cc[_0x14b1f8(0x214)])_0x52f4e0++;return _0x52f4e0;},VisuMZ[_0x48a455(0x21d)]['Scene_Battle_initialize']=Scene_Battle[_0x48a455(0x341)]['initialize'],Scene_Battle[_0x48a455(0x341)]['initialize']=function(){const _0x12a5da=_0x48a455;VisuMZ[_0x12a5da(0x21d)]['Scene_Battle_initialize'][_0x12a5da(0x2b5)](this),this[_0x12a5da(0x229)]();},Scene_Battle[_0x48a455(0x341)][_0x48a455(0x229)]=function(){const _0x132f0e=_0x48a455;this[_0x132f0e(0x2b8)]='',this[_0x132f0e(0x21e)]=VisuMZ[_0x132f0e(0x21d)][_0x132f0e(0x206)][this[_0x132f0e(0x2b8)]],this[_0x132f0e(0x247)]=0x0;},Scene_Battle[_0x48a455(0x341)][_0x48a455(0x25e)]=function(){const _0x8f0031=_0x48a455;return this[_0x8f0031(0x2b8)];},Scene_Battle[_0x48a455(0x341)]['tutorialData']=function(){return this['_tutorialData']||{};},Scene_Battle['prototype'][_0x48a455(0x245)]=function(){const _0xa16861=_0x48a455;return this[_0xa16861(0x23d)]()[_0xa16861(0x210)]||'';},Scene_Battle[_0x48a455(0x341)]['tutorialPages']=function(){const _0x47c0bb=_0x48a455;return this[_0x47c0bb(0x23d)]()[_0x47c0bb(0x321)]||[];},Scene_Battle[_0x48a455(0x341)][_0x48a455(0x1df)]=function(){return this['_tutorialPageIndex'];},Scene_Battle['prototype'][_0x48a455(0x2cb)]=function(){const _0xfec6bb=_0x48a455;return this[_0xfec6bb(0x2c1)]()[this[_0xfec6bb(0x1df)]()];},VisuMZ[_0x48a455(0x21d)][_0x48a455(0x244)]=Scene_Battle[_0x48a455(0x341)][_0x48a455(0x231)],Scene_Battle['prototype']['createAllWindows']=function(){const _0x156197=_0x48a455;VisuMZ[_0x156197(0x21d)][_0x156197(0x244)]['call'](this),this[_0x156197(0x2d7)]();},Scene_Battle['prototype'][_0x48a455(0x2d7)]=function(){const _0x51763e=_0x48a455;this[_0x51763e(0x2b7)](),this['createTutorialDescriptionWindow'](),this[_0x51763e(0x24d)](),this[_0x51763e(0x325)]();},Scene_Battle[_0x48a455(0x341)][_0x48a455(0x2b7)]=function(){const _0x7cefa=_0x48a455,_0x4c236d=this[_0x7cefa(0x33c)](),_0x476281=new Window_TutorialPages(_0x4c236d);this[_0x7cefa(0x2fe)](_0x476281),this[_0x7cefa(0x200)]=_0x476281,_0x476281[_0x7cefa(0x201)](),_0x476281[_0x7cefa(0x2cc)](),_0x476281['setHandler'](_0x7cefa(0x2ff),this[_0x7cefa(0x20d)][_0x7cefa(0x274)](this)),_0x476281[_0x7cefa(0x2ed)]('page',this['nextTutorialPage']['bind'](this)),_0x476281['setBackgroundType'](VisuMZ[_0x7cefa(0x21d)]['Settings']['SceneBattle'][_0x7cefa(0x2be)]);},Scene_Battle[_0x48a455(0x341)][_0x48a455(0x33c)]=function(){const _0x5d3159=_0x48a455;if(VisuMZ[_0x5d3159(0x21d)]['Settings'][_0x5d3159(0x228)][_0x5d3159(0x1f9)])return VisuMZ[_0x5d3159(0x21d)][_0x5d3159(0x32f)][_0x5d3159(0x228)][_0x5d3159(0x1f9)]['call'](this);const _0x13747f=Math[_0x5d3159(0x31f)](0x2d0,Math['floor'](Graphics[_0x5d3159(0x287)]*0.75)),_0x33a152=this[_0x5d3159(0x28f)](0x1,!![]),_0x559c88=Math[_0x5d3159(0x2db)]((Graphics[_0x5d3159(0x287)]-_0x13747f)/0x2),_0x74f98b=Graphics[_0x5d3159(0x2c6)]-_0x33a152;return new Rectangle(_0x559c88,_0x74f98b,_0x13747f,_0x33a152);},Scene_Battle[_0x48a455(0x341)][_0x48a455(0x292)]=function(){const _0x400881=_0x48a455,_0x5ef762=this[_0x400881(0x32c)](),_0x4c0e41=new Window_TutorialDescription(_0x5ef762);this[_0x400881(0x2fe)](_0x4c0e41),this[_0x400881(0x34c)]=_0x4c0e41,_0x4c0e41[_0x400881(0x201)](),_0x4c0e41[_0x400881(0x2a6)](VisuMZ[_0x400881(0x21d)][_0x400881(0x32f)][_0x400881(0x228)][_0x400881(0x1ec)]);},Scene_Battle[_0x48a455(0x341)][_0x48a455(0x32c)]=function(){const _0x409f8b=_0x48a455;if(VisuMZ[_0x409f8b(0x21d)]['Settings'][_0x409f8b(0x228)][_0x409f8b(0x343)]){if(_0x409f8b(0x25b)===_0x409f8b(0x25b))return VisuMZ[_0x409f8b(0x21d)][_0x409f8b(0x32f)][_0x409f8b(0x228)][_0x409f8b(0x343)][_0x409f8b(0x2b5)](this);else{const _0x153bb9=this[_0x409f8b(0x2b4)](),_0x520bed=new _0x369c2d(_0x153bb9);this['addWindow'](_0x520bed),this[_0x409f8b(0x302)]=_0x520bed,_0x520bed[_0x409f8b(0x2a6)](_0x26619b['TutorialPanelSys'][_0x409f8b(0x32f)][_0x409f8b(0x2e5)]['PictureWindow_BgType']),this['addWindow'](this[_0x409f8b(0x289)]);}}const _0x167229=Math[_0x409f8b(0x31f)](0x2d0,Math[_0x409f8b(0x2db)](Graphics['boxWidth']*0.75)),_0x5db090=this[_0x409f8b(0x28f)](0x4,![]),_0x4e031f=Math[_0x409f8b(0x2db)]((Graphics[_0x409f8b(0x287)]-_0x167229)/0x2),_0x3d1572=Graphics['boxHeight']-_0x5db090-this[_0x409f8b(0x28f)](0x1,!![]);return new Rectangle(_0x4e031f,_0x3d1572,_0x167229,_0x5db090);},Scene_Battle[_0x48a455(0x341)][_0x48a455(0x24d)]=function(){const _0x34750a=_0x48a455,_0xab9b6f=this[_0x34750a(0x2c9)](),_0xe9bda=new Window_TutorialPicture(_0xab9b6f);this[_0x34750a(0x2fe)](_0xe9bda),this[_0x34750a(0x273)]=_0xe9bda,_0xe9bda[_0x34750a(0x201)](),_0xe9bda[_0x34750a(0x2a6)](VisuMZ[_0x34750a(0x21d)][_0x34750a(0x32f)][_0x34750a(0x228)][_0x34750a(0x322)]),this[_0x34750a(0x2fe)](this['_tutorialDescriptionWindow']);},Scene_Battle[_0x48a455(0x341)][_0x48a455(0x2c9)]=function(){const _0x1461dc=_0x48a455;if(VisuMZ['TutorialPanelSys'][_0x1461dc(0x32f)][_0x1461dc(0x228)][_0x1461dc(0x333)])return VisuMZ[_0x1461dc(0x21d)][_0x1461dc(0x32f)][_0x1461dc(0x228)][_0x1461dc(0x333)]['call'](this,this[_0x1461dc(0x34c)]);const _0x3a04cb=this['_tutorialDescriptionWindow'],_0x3cb9a3=_0x3a04cb[_0x1461dc(0x31a)],_0x234e3e=Graphics[_0x1461dc(0x2c6)]-this[_0x1461dc(0x2de)]()-_0x3a04cb[_0x1461dc(0x2ab)]-this[_0x1461dc(0x28f)](0x1,!![]),_0x3277b1=_0x3a04cb['x'],_0xe57273=this[_0x1461dc(0x2de)]();return new Rectangle(_0x3277b1,_0xe57273,_0x3cb9a3,_0x234e3e);},Scene_Battle['prototype']['createTutorialTitleWindow']=function(){const _0x559437=_0x48a455,_0x5a1606=this[_0x559437(0x1e5)](),_0x54fdd5=new Window_TutorialTitle(_0x5a1606);this['addWindow'](_0x54fdd5),this[_0x559437(0x2c7)]=_0x54fdd5,_0x54fdd5[_0x559437(0x201)](),_0x54fdd5[_0x559437(0x2a6)](VisuMZ[_0x559437(0x21d)][_0x559437(0x32f)][_0x559437(0x228)][_0x559437(0x33d)]);},Scene_Battle[_0x48a455(0x341)][_0x48a455(0x1e5)]=function(){const _0x1e2252=_0x48a455;if(VisuMZ['TutorialPanelSys']['Settings']['SceneBattle'][_0x1e2252(0x24b)])return VisuMZ[_0x1e2252(0x21d)]['Settings'][_0x1e2252(0x228)][_0x1e2252(0x24b)][_0x1e2252(0x2b5)](this,this['_tutorialDescriptionWindow']);const _0x4a9143=this['_tutorialDescriptionWindow'],_0x5bcc52=Math[_0x1e2252(0x31f)](_0x4a9143[_0x1e2252(0x31a)]-0x12c,0x1e0),_0x5dc44d=this['calcWindowHeight'](0x1,![]),_0x4213b1=Math[_0x1e2252(0x2db)]((Graphics['boxWidth']-_0x5bcc52)/0x2),_0x1b5458=_0x4a9143['y']-Math[_0x1e2252(0x2db)](_0x5dc44d/0x2);return new Rectangle(_0x4213b1,_0x1b5458,_0x5bcc52,_0x5dc44d);},Scene_Battle['prototype']['nextTutorialPage']=function(){const _0x3ab40e=_0x48a455;let _0x1f8486=this[_0x3ab40e(0x200)][_0x3ab40e(0x282)]()+0x1;if(_0x1f8486>=this[_0x3ab40e(0x2c1)]()[_0x3ab40e(0x22d)]){if(_0x3ab40e(0x248)!=='DNSyE'){const _0x4129f1=0x14;if(_0x6eae7['wheelY']>=_0x4129f1){const _0x381177=_0x1fe4a5[_0x3ab40e(0x303)](this[_0x3ab40e(0x282)]()+0x1,this['maxCols']()-0x1);this['select'](_0x381177);}if(_0x53b819['wheelY']<=-_0x4129f1){const _0x38e5a6=_0x2c1d84[_0x3ab40e(0x31f)](this[_0x3ab40e(0x282)]()-0x1,0x0);this['select'](_0x38e5a6);}}else SoundManager[_0x3ab40e(0x203)](),this['closeTutorial']();}else this[_0x3ab40e(0x200)][_0x3ab40e(0x238)](),this[_0x3ab40e(0x200)][_0x3ab40e(0x35a)](_0x1f8486);},Scene_Battle[_0x48a455(0x341)][_0x48a455(0x35d)]=function(_0x1977dc){const _0x17558b=_0x48a455;if(!VisuMZ['TutorialPanelSys'][_0x17558b(0x1f3)](_0x1977dc))return;this[_0x17558b(0x2b8)]=_0x1977dc[_0x17558b(0x1fa)]()[_0x17558b(0x280)](),this[_0x17558b(0x21e)]=VisuMZ[_0x17558b(0x21d)][_0x17558b(0x206)][this[_0x17558b(0x2b8)]],this[_0x17558b(0x247)]=0x0,this[_0x17558b(0x200)]&&(this[_0x17558b(0x200)][_0x17558b(0x1db)](),this[_0x17558b(0x200)][_0x17558b(0x238)](),this[_0x17558b(0x200)][_0x17558b(0x2ee)](),this[_0x17558b(0x200)][_0x17558b(0x2f6)]()),this['_tutorialDescriptionWindow']&&(this['_tutorialDescriptionWindow'][_0x17558b(0x1db)](),this[_0x17558b(0x34c)]['updatePage'](!![]),this[_0x17558b(0x34c)]['refresh']()),this[_0x17558b(0x273)]&&(this['_tutorialPictureWindow'][_0x17558b(0x1db)](),this[_0x17558b(0x273)]['updatePage'](!![]),this[_0x17558b(0x273)][_0x17558b(0x2f6)]()),this[_0x17558b(0x2c7)]&&(this[_0x17558b(0x2c7)]['show'](),this[_0x17558b(0x2c7)][_0x17558b(0x275)](this[_0x17558b(0x245)]())),$gameTroop['_interpreter'][_0x17558b(0x2ac)](_0x17558b(0x35e));},Scene_Battle[_0x48a455(0x341)][_0x48a455(0x20d)]=function(){const _0x81188c=_0x48a455;if(this['_tutorialPageWindow']){if(_0x81188c(0x24c)!=='swzEg'){const _0xf817dc=this[_0x81188c(0x2b2)](),_0x594778=new _0x154dcd(_0xf817dc);this[_0x81188c(0x2fe)](_0x594778),this[_0x81188c(0x289)]=_0x594778,_0x594778[_0x81188c(0x2a6)](_0x2d9bd9[_0x81188c(0x21d)]['Settings'][_0x81188c(0x2e5)][_0x81188c(0x1ec)]);}else this[_0x81188c(0x200)][_0x81188c(0x201)](),this['_tutorialPageWindow'][_0x81188c(0x2cc)]();}this[_0x81188c(0x34c)]&&this['_tutorialDescriptionWindow'][_0x81188c(0x201)]();this[_0x81188c(0x273)]&&this[_0x81188c(0x273)][_0x81188c(0x201)]();if(this[_0x81188c(0x2c7)]){if('AAwLH'===_0x81188c(0x2d9))this[_0x81188c(0x2c7)][_0x81188c(0x201)]();else{if(this[_0x81188c(0x336)](_0x77b1f7))return!![];}}$gameTroop[_0x81188c(0x35c)]['setWaitMode']('');},VisuMZ[_0x48a455(0x21d)]['Scene_Battle_updateStatusWindowVisibility']=Scene_Battle[_0x48a455(0x341)][_0x48a455(0x313)],Scene_Battle['prototype'][_0x48a455(0x313)]=function(){const _0x3e92d1=_0x48a455;if(this[_0x3e92d1(0x294)]())this['_statusWindow'][_0x3e92d1(0x255)]();else{if('WFvaJ'===_0x3e92d1(0x326)){const _0x43a610=this[_0x3e92d1(0x1dc)](_0x4d7584),_0x5cd88a=this['commandName'](_0x2cb845),_0x1c67ff=this['textSizeEx'](_0x5cd88a)[_0x3e92d1(0x31a)];this['changePaintOpacity'](this[_0x3e92d1(0x308)](_0x2e9626));const _0x1e42a4=this[_0x3e92d1(0x2ca)]();if(_0x1e42a4===_0x3e92d1(0x24a))this[_0x3e92d1(0x2c2)](_0x5cd88a,_0x43a610['x']+_0x43a610[_0x3e92d1(0x31a)]-_0x1c67ff,_0x43a610['y'],_0x1c67ff);else{if(_0x1e42a4===_0x3e92d1(0x235)){const _0x2d0834=_0x43a610['x']+_0x213a38[_0x3e92d1(0x2db)]((_0x43a610[_0x3e92d1(0x31a)]-_0x1c67ff)/0x2);this['drawTextEx'](_0x5cd88a,_0x2d0834,_0x43a610['y'],_0x1c67ff);}else this[_0x3e92d1(0x2c2)](_0x5cd88a,_0x43a610['x'],_0x43a610['y'],_0x1c67ff);}}else VisuMZ[_0x3e92d1(0x21d)][_0x3e92d1(0x298)][_0x3e92d1(0x2b5)](this);}},Scene_Battle[_0x48a455(0x341)][_0x48a455(0x294)]=function(){const _0x10d946=_0x48a455;if(!VisuMZ[_0x10d946(0x21d)]['Settings'][_0x10d946(0x228)]['HideDuring'])return![];return this[_0x10d946(0x200)]&&this[_0x10d946(0x200)][_0x10d946(0x281)];},VisuMZ['TutorialPanelSys'][_0x48a455(0x1ee)]=Scene_Battle[_0x48a455(0x341)][_0x48a455(0x34e)],Scene_Battle[_0x48a455(0x341)][_0x48a455(0x34e)]=function(){const _0x824edd=_0x48a455;if(this[_0x824edd(0x200)]&&this[_0x824edd(0x200)][_0x824edd(0x281)])return _0x824edd(0x241)===_0x824edd(0x241)?!![]:0x0;return VisuMZ[_0x824edd(0x21d)]['Scene_Battle_isAnyInputWindowActive'][_0x824edd(0x2b5)](this);};function Scene_TutorialData(){const _0x75737=_0x48a455;this[_0x75737(0x1f8)](...arguments);}Scene_TutorialData['prototype']=Object[_0x48a455(0x232)](Scene_MenuBase['prototype']),Scene_TutorialData[_0x48a455(0x341)][_0x48a455(0x2aa)]=Scene_TutorialData,Scene_TutorialData[_0x48a455(0x341)][_0x48a455(0x1f8)]=function(){const _0x4254f4=_0x48a455;Scene_MenuBase[_0x4254f4(0x341)][_0x4254f4(0x1f8)][_0x4254f4(0x2b5)](this),this[_0x4254f4(0x229)]();},Scene_TutorialData[_0x48a455(0x341)][_0x48a455(0x229)]=function(){const _0x21541d=_0x48a455;this[_0x21541d(0x2b8)]=$gameTemp[_0x21541d(0x2b8)][_0x21541d(0x1fa)]()[_0x21541d(0x280)](),this[_0x21541d(0x21e)]=VisuMZ[_0x21541d(0x21d)][_0x21541d(0x206)][this[_0x21541d(0x2b8)]],this[_0x21541d(0x247)]=0x0;},Scene_TutorialData[_0x48a455(0x341)][_0x48a455(0x25e)]=function(){const _0x49aaa6=_0x48a455;return this[_0x49aaa6(0x2b8)];},Scene_TutorialData[_0x48a455(0x341)][_0x48a455(0x23d)]=function(){const _0x148138=_0x48a455;return this[_0x148138(0x21e)]||{};},Scene_TutorialData[_0x48a455(0x341)]['tutorialTitle']=function(){const _0x2d9bcd=_0x48a455;return this[_0x2d9bcd(0x23d)]()[_0x2d9bcd(0x210)]||'';},Scene_TutorialData[_0x48a455(0x341)][_0x48a455(0x2c1)]=function(){const _0x4513c4=_0x48a455;return this[_0x4513c4(0x23d)]()[_0x4513c4(0x321)]||[];},Scene_TutorialData['prototype'][_0x48a455(0x1df)]=function(){return this['_tutorialPageIndex'];},Scene_TutorialData['prototype'][_0x48a455(0x2cb)]=function(){const _0x306923=_0x48a455;return this[_0x306923(0x2c1)]()[this['tutorialPageIndex']()];},Scene_TutorialData[_0x48a455(0x341)]['helpAreaHeight']=function(){return 0x0;},Scene_TutorialData['prototype'][_0x48a455(0x2ea)]=function(){const _0x26738e=_0x48a455;Scene_MenuBase['prototype'][_0x26738e(0x2ea)][_0x26738e(0x2b5)](this),this[_0x26738e(0x2bb)](this[_0x26738e(0x216)]()),this[_0x26738e(0x25a)]();},Scene_TutorialData[_0x48a455(0x341)]['getBackgroundOpacity']=function(){const _0x5095a2=_0x48a455;return VisuMZ[_0x5095a2(0x21d)]['Settings'][_0x5095a2(0x2e5)][_0x5095a2(0x260)];},Scene_TutorialData['prototype'][_0x48a455(0x25a)]=function(){const _0x42becb=_0x48a455,_0x53aa92=VisuMZ['TutorialPanelSys']['Settings'][_0x42becb(0x2e5)];if(_0x53aa92&&(_0x53aa92['BgFilename1']!==''||_0x53aa92[_0x42becb(0x25c)]!=='')){if(_0x42becb(0x1ff)===_0x42becb(0x30f)){if(_0x235db4[_0x42becb(0x2d6)]())return!![];return _0x416ae0[_0x42becb(0x32d)](_0x3a63f6);}else this[_0x42becb(0x359)]=new Sprite(ImageManager[_0x42becb(0x29b)](_0x53aa92[_0x42becb(0x24e)])),this[_0x42becb(0x265)]=new Sprite(ImageManager[_0x42becb(0x361)](_0x53aa92[_0x42becb(0x25c)])),this[_0x42becb(0x349)](this[_0x42becb(0x359)]),this['addChild'](this['_backSprite2']),this[_0x42becb(0x359)]['bitmap'][_0x42becb(0x356)](this['adjustSprite'][_0x42becb(0x274)](this,this[_0x42becb(0x359)])),this['_backSprite2'][_0x42becb(0x2eb)][_0x42becb(0x356)](this[_0x42becb(0x2a4)][_0x42becb(0x274)](this,this[_0x42becb(0x265)]));}},Scene_TutorialData[_0x48a455(0x341)]['adjustSprite']=function(_0x480640){this['scaleSprite'](_0x480640),this['centerSprite'](_0x480640);},Scene_TutorialData['prototype'][_0x48a455(0x339)]=function(){const _0x447e83=_0x48a455;return this[_0x447e83(0x2c1)]()[_0x447e83(0x22d)]>0x0?TextManager[_0x447e83(0x20e)](_0x447e83(0x221),_0x447e83(0x24a)):Scene_MenuBase['prototype'][_0x447e83(0x339)][_0x447e83(0x2b5)](this);},Scene_TutorialData[_0x48a455(0x341)]['buttonAssistText1']=function(){return TextManager['tutorial']['changePage'];},Scene_TutorialData['prototype'][_0x48a455(0x2af)]=function(){const _0x1a575a=_0x48a455;if(this['_tutorialPageIndex']===this[_0x1a575a(0x2c1)]()[_0x1a575a(0x22d)]-0x1)return TextManager[_0x1a575a(0x35e)][_0x1a575a(0x316)];else{if(_0x1a575a(0x2dd)===_0x1a575a(0x2dd))return TextManager['tutorial'][_0x1a575a(0x1d6)];else _0x286d73[_0x1a575a(0x341)][_0x1a575a(0x232)][_0x1a575a(0x2b5)](this),this[_0x1a575a(0x262)](),this[_0x1a575a(0x233)](),this[_0x1a575a(0x1dd)](),this[_0x1a575a(0x358)]();}},Scene_TutorialData[_0x48a455(0x341)][_0x48a455(0x2a0)]=function(){const _0x4caa0d=_0x48a455;return TextManager[_0x4caa0d(0x35e)]['finish'];},Scene_TutorialData[_0x48a455(0x341)][_0x48a455(0x232)]=function(){const _0x598d7f=_0x48a455;Scene_MenuBase['prototype']['create'][_0x598d7f(0x2b5)](this),this[_0x598d7f(0x262)](),this[_0x598d7f(0x233)](),this[_0x598d7f(0x1dd)](),this[_0x598d7f(0x358)]();},Scene_TutorialData['prototype'][_0x48a455(0x262)]=function(){const _0x44a859=_0x48a455,_0x513722=this[_0x44a859(0x2da)](),_0x28acd8=new Window_TutorialPages(_0x513722);this[_0x44a859(0x2fe)](_0x28acd8),this[_0x44a859(0x299)]=_0x28acd8,_0x28acd8['setHandler']('cancel',this[_0x44a859(0x32b)][_0x44a859(0x274)](this)),_0x28acd8['setHandler'](_0x44a859(0x270),this[_0x44a859(0x1d6)][_0x44a859(0x274)](this)),_0x28acd8['setBackgroundType'](VisuMZ[_0x44a859(0x21d)][_0x44a859(0x32f)][_0x44a859(0x2e5)]['PageWindow_BgType']);},Scene_TutorialData[_0x48a455(0x341)]['pageWindowRect']=function(){const _0xc2f99=_0x48a455;if(VisuMZ[_0xc2f99(0x21d)][_0xc2f99(0x32f)][_0xc2f99(0x2e5)][_0xc2f99(0x1f9)]){if(_0xc2f99(0x327)===_0xc2f99(0x211))this[_0xc2f99(0x2c7)][_0xc2f99(0x201)]();else return VisuMZ['TutorialPanelSys'][_0xc2f99(0x32f)][_0xc2f99(0x2e5)][_0xc2f99(0x1f9)]['call'](this);}const _0x1920e8=Math[_0xc2f99(0x31f)](0x2d0,Math[_0xc2f99(0x2db)](Graphics[_0xc2f99(0x287)]*0.75)),_0x270fd8=this['calcWindowHeight'](0x1,!![]),_0x1c449a=Math['floor']((Graphics[_0xc2f99(0x287)]-_0x1920e8)/0x2),_0x32af02=this[_0xc2f99(0x23e)]()-_0x270fd8;return new Rectangle(_0x1c449a,_0x32af02,_0x1920e8,_0x270fd8);},Scene_TutorialData['prototype']['createDescriptionWindow']=function(){const _0x3b5e82=_0x48a455,_0x4625ea=this[_0x3b5e82(0x2b2)](),_0x5a3c1e=new Window_TutorialDescription(_0x4625ea);this['addWindow'](_0x5a3c1e),this[_0x3b5e82(0x289)]=_0x5a3c1e,_0x5a3c1e[_0x3b5e82(0x2a6)](VisuMZ['TutorialPanelSys'][_0x3b5e82(0x32f)]['SceneTutorialData']['DescWindow_BgType']);},Scene_TutorialData[_0x48a455(0x341)][_0x48a455(0x2b2)]=function(){const _0xcab60b=_0x48a455;if(VisuMZ['TutorialPanelSys'][_0xcab60b(0x32f)][_0xcab60b(0x2e5)][_0xcab60b(0x343)])return _0xcab60b(0x2f3)!==_0xcab60b(0x2f3)?_0xf8450c[_0xcab60b(0x21d)][_0xcab60b(0x32f)][_0xcab60b(0x2e5)]['SnapshotOpacity']:VisuMZ[_0xcab60b(0x21d)][_0xcab60b(0x32f)][_0xcab60b(0x2e5)][_0xcab60b(0x343)]['call'](this);const _0x310402=Math[_0xcab60b(0x31f)](0x2d0,Math[_0xcab60b(0x2db)](Graphics[_0xcab60b(0x287)]*0.75)),_0x2856e2=this[_0xcab60b(0x28f)](0x4,![]),_0x14867d=Math[_0xcab60b(0x2db)]((Graphics[_0xcab60b(0x287)]-_0x310402)/0x2),_0x5994a2=this['mainAreaBottom']()-_0x2856e2-this[_0xcab60b(0x28f)](0x1,!![]);return new Rectangle(_0x14867d,_0x5994a2,_0x310402,_0x2856e2);},Scene_TutorialData[_0x48a455(0x341)][_0x48a455(0x1dd)]=function(){const _0x48811d=_0x48a455,_0x509ece=this[_0x48811d(0x2b4)](),_0x452a99=new Window_TutorialPicture(_0x509ece);this[_0x48811d(0x2fe)](_0x452a99),this[_0x48811d(0x302)]=_0x452a99,_0x452a99[_0x48811d(0x2a6)](VisuMZ[_0x48811d(0x21d)][_0x48811d(0x32f)][_0x48811d(0x2e5)][_0x48811d(0x322)]),this[_0x48811d(0x2fe)](this['_descriptionWindow']);},Scene_TutorialData[_0x48a455(0x341)][_0x48a455(0x2b4)]=function(){const _0x5d0332=_0x48a455;if(VisuMZ[_0x5d0332(0x21d)]['Settings'][_0x5d0332(0x2e5)]['PictureWindow_RectJS'])return'OGRKO'!=='kEBua'?VisuMZ[_0x5d0332(0x21d)][_0x5d0332(0x32f)][_0x5d0332(0x2e5)][_0x5d0332(0x333)][_0x5d0332(0x2b5)](this,this[_0x5d0332(0x289)]):this[_0x5d0332(0x1fe)]&&this['_scene'][_0x5d0332(0x2aa)]===_0x1395d1;const _0x3bf869=this[_0x5d0332(0x289)],_0x5e687e=_0x3bf869[_0x5d0332(0x31a)],_0x135857=this[_0x5d0332(0x32e)]()-_0x3bf869[_0x5d0332(0x2ab)]-this['calcWindowHeight'](0x1,!![]),_0x527fb0=_0x3bf869['x'],_0x1e8e3e=this[_0x5d0332(0x259)]();return new Rectangle(_0x527fb0,_0x1e8e3e,_0x5e687e,_0x135857);},Scene_TutorialData[_0x48a455(0x341)][_0x48a455(0x358)]=function(){const _0x2842a2=_0x48a455,_0x230921=this[_0x2842a2(0x2ba)](),_0x161fe5=new Window_TutorialTitle(_0x230921);this[_0x2842a2(0x2fe)](_0x161fe5),this[_0x2842a2(0x332)]=_0x161fe5,_0x161fe5['setBackgroundType'](VisuMZ[_0x2842a2(0x21d)][_0x2842a2(0x32f)][_0x2842a2(0x2e5)]['TitleWindow_BgType']),_0x161fe5[_0x2842a2(0x275)](this[_0x2842a2(0x245)]());},Scene_TutorialData[_0x48a455(0x341)][_0x48a455(0x2ba)]=function(){const _0xc02d56=_0x48a455;if(VisuMZ[_0xc02d56(0x21d)][_0xc02d56(0x32f)][_0xc02d56(0x2e5)]['TitleWindow_RectJS']){if(_0xc02d56(0x27d)!==_0xc02d56(0x27b))return VisuMZ[_0xc02d56(0x21d)]['Settings']['SceneTutorialData']['TitleWindow_RectJS']['call'](this,this[_0xc02d56(0x289)]);else _0x452529[_0xc02d56(0x341)][_0xc02d56(0x1f8)][_0xc02d56(0x2b5)](this);}const _0x5f24cd=this[_0xc02d56(0x289)],_0x1f4f00=Math[_0xc02d56(0x31f)](_0x5f24cd[_0xc02d56(0x31a)]-0x12c,0x1e0),_0x4b235f=this[_0xc02d56(0x28f)](0x1,![]),_0x2c9f8b=Math[_0xc02d56(0x2db)]((Graphics['boxWidth']-_0x1f4f00)/0x2),_0x21a861=_0x5f24cd['y']-Math['floor'](_0x4b235f/0x2);return new Rectangle(_0x2c9f8b,_0x21a861,_0x1f4f00,_0x4b235f);},Scene_TutorialData[_0x48a455(0x341)]['nextPage']=function(){const _0x4eaecf=_0x48a455;let _0x32e73e=this[_0x4eaecf(0x299)]['index']()+0x1;_0x32e73e>=this[_0x4eaecf(0x2c1)]()['length']?(SoundManager[_0x4eaecf(0x203)](),this[_0x4eaecf(0x32b)]()):(this[_0x4eaecf(0x299)]['activate'](),this[_0x4eaecf(0x299)][_0x4eaecf(0x35a)](_0x32e73e));};function Scene_TutorialList(){const _0x3cbc8d=_0x48a455;this[_0x3cbc8d(0x1f8)](...arguments);}Scene_TutorialList[_0x48a455(0x341)]=Object['create'](Scene_MenuBase[_0x48a455(0x341)]),Scene_TutorialList[_0x48a455(0x341)][_0x48a455(0x2aa)]=Scene_TutorialList,Scene_TutorialList['prototype'][_0x48a455(0x1f8)]=function(){const _0x218965=_0x48a455;Scene_MenuBase[_0x218965(0x341)][_0x218965(0x1f8)]['call'](this);},Scene_TutorialList['prototype'][_0x48a455(0x2ea)]=function(){const _0x4587c3=_0x48a455;Scene_MenuBase[_0x4587c3(0x341)][_0x4587c3(0x2ea)][_0x4587c3(0x2b5)](this),this[_0x4587c3(0x2bb)](this[_0x4587c3(0x216)]()),this[_0x4587c3(0x25a)]();},Scene_TutorialList[_0x48a455(0x341)][_0x48a455(0x216)]=function(){const _0x20b6fe=_0x48a455;return VisuMZ['TutorialPanelSys']['Settings'][_0x20b6fe(0x357)]['SnapshotOpacity'];},Scene_TutorialList[_0x48a455(0x341)][_0x48a455(0x25a)]=function(){const _0x24f25e=_0x48a455,_0xfb8e77=VisuMZ[_0x24f25e(0x21d)]['Settings'][_0x24f25e(0x357)];if(_0xfb8e77&&(_0xfb8e77[_0x24f25e(0x24e)]!==''||_0xfb8e77[_0x24f25e(0x25c)]!=='')){if(_0x24f25e(0x212)===_0x24f25e(0x315)){const _0x624b58=this[_0x24f25e(0x237)]();this[_0x24f25e(0x2a8)][_0x624b58]=!this[_0x24f25e(0x2a8)][_0x624b58],this[_0x24f25e(0x2f6)]();}else this[_0x24f25e(0x359)]=new Sprite(ImageManager[_0x24f25e(0x29b)](_0xfb8e77[_0x24f25e(0x24e)])),this[_0x24f25e(0x265)]=new Sprite(ImageManager[_0x24f25e(0x361)](_0xfb8e77['BgFilename2'])),this[_0x24f25e(0x349)](this[_0x24f25e(0x359)]),this[_0x24f25e(0x349)](this[_0x24f25e(0x265)]),this[_0x24f25e(0x359)][_0x24f25e(0x2eb)][_0x24f25e(0x356)](this[_0x24f25e(0x2a4)][_0x24f25e(0x274)](this,this[_0x24f25e(0x359)])),this['_backSprite2'][_0x24f25e(0x2eb)]['addLoadListener'](this[_0x24f25e(0x2a4)]['bind'](this,this[_0x24f25e(0x265)]));}},Scene_TutorialList['prototype'][_0x48a455(0x2a4)]=function(_0x4996a1){const _0x89ed8d=_0x48a455;this[_0x89ed8d(0x2ce)](_0x4996a1),this[_0x89ed8d(0x347)](_0x4996a1);},Scene_TutorialList[_0x48a455(0x341)]['buttonAssistText4']=function(){const _0x42369c=_0x48a455;if(this['_listWindow']&&this[_0x42369c(0x224)][_0x42369c(0x281)]){const _0x14f051=this[_0x42369c(0x224)][_0x42369c(0x29e)]();if(_0x14f051===_0x42369c(0x28c))return'hDEeB'==='hDEeB'?this[_0x42369c(0x224)]['isCategoryOpen'](this[_0x42369c(0x224)]['currentCategory']())?TextManager['tutorial']['collapse']:TextManager[_0x42369c(0x35e)][_0x42369c(0x258)]:this[_0x42369c(0x2c1)]()[_0x42369c(0x22d)]>0x0?_0x4f1e97[_0x42369c(0x20e)](_0x42369c(0x221),_0x42369c(0x24a)):_0x4c9632[_0x42369c(0x341)]['buttonAssistKey1'][_0x42369c(0x2b5)](this);else{if(_0x14f051===_0x42369c(0x35e))return TextManager[_0x42369c(0x35e)][_0x42369c(0x312)];}}return Scene_MenuBase[_0x42369c(0x341)]['buttonAssistText4'][_0x42369c(0x2b5)](this);},Scene_TutorialList[_0x48a455(0x341)][_0x48a455(0x232)]=function(){const _0x3585ff=_0x48a455;Scene_MenuBase[_0x3585ff(0x341)]['create'][_0x3585ff(0x2b5)](this),this[_0x3585ff(0x215)]();if(this['_buttonAssistWindow'])this['_buttonAssistWindow']['update']();},Scene_TutorialList[_0x48a455(0x341)][_0x48a455(0x215)]=function(){const _0x4d7e61=_0x48a455,_0xf51194=this[_0x4d7e61(0x20c)](),_0x4a9f00=new Window_TutorialList(_0xf51194);this['addWindow'](_0x4a9f00),this['_listWindow']=_0x4a9f00,_0x4a9f00[_0x4d7e61(0x2ed)](_0x4d7e61(0x2ff),this[_0x4d7e61(0x32b)][_0x4d7e61(0x274)](this)),_0x4a9f00['setHandler']('category',this[_0x4d7e61(0x20b)]['bind'](this)),_0x4a9f00[_0x4d7e61(0x2ed)](_0x4d7e61(0x35e),this[_0x4d7e61(0x261)][_0x4d7e61(0x274)](this)),_0x4a9f00[_0x4d7e61(0x2a6)](VisuMZ[_0x4d7e61(0x21d)]['Settings'][_0x4d7e61(0x357)][_0x4d7e61(0x246)]);},Scene_TutorialList[_0x48a455(0x341)][_0x48a455(0x20c)]=function(){const _0x8543fd=_0x48a455;if(VisuMZ[_0x8543fd(0x21d)][_0x8543fd(0x32f)][_0x8543fd(0x357)][_0x8543fd(0x2a2)])return VisuMZ['TutorialPanelSys'][_0x8543fd(0x32f)][_0x8543fd(0x357)][_0x8543fd(0x2a2)]['call'](this);const _0x5471ef=Math[_0x8543fd(0x31f)](0x2d0,Math[_0x8543fd(0x2db)](Graphics['boxWidth']*0.75)),_0x381a4e=Math['max'](_0x5471ef-0x12c,0x1e0),_0x306b9a=this[_0x8543fd(0x28f)](0xa,!![]),_0x536361=Math[_0x8543fd(0x2db)]((Graphics['boxWidth']-_0x381a4e)/0x2),_0x50a0aa=Math[_0x8543fd(0x2db)]((Graphics['boxHeight']-_0x306b9a)/0x2);return new Rectangle(_0x536361,_0x50a0aa,_0x381a4e,_0x306b9a);},Scene_TutorialList[_0x48a455(0x341)][_0x48a455(0x20b)]=function(){const _0xae7334=_0x48a455;this[_0xae7334(0x224)][_0xae7334(0x1e6)](),this[_0xae7334(0x224)][_0xae7334(0x238)]();},Scene_TutorialList[_0x48a455(0x341)][_0x48a455(0x261)]=function(){const _0x4e8628=_0x48a455,_0x2abe80=this[_0x4e8628(0x224)][_0x4e8628(0x1e3)]()||'';if(_0x2abe80===''){if(_0x4e8628(0x268)!=='cPZoC'){this['_listWindow'][_0x4e8628(0x238)]();return;}else _0x1c47b5(_0x4e8628(0x1d9)[_0x4e8628(0x318)](_0x2b7a95,_0x3b5016,_0x4b56d9)),_0x5edf59['exit']();}$gameTemp[_0x4e8628(0x354)]=_0x2abe80,$gameTemp[_0x4e8628(0x35d)](_0x2abe80);},VisuMZ['TutorialPanelSys'][_0x48a455(0x2b1)]=Window_MenuCommand[_0x48a455(0x341)][_0x48a455(0x2e3)],Window_MenuCommand[_0x48a455(0x341)]['addOriginalCommands']=function(){const _0x2add57=_0x48a455;VisuMZ[_0x2add57(0x21d)]['Window_MenuCommand_addOriginalCommands'][_0x2add57(0x2b5)](this),this[_0x2add57(0x30c)]();},Window_MenuCommand[_0x48a455(0x341)]['addTutorialListCommand']=function(){const _0x2f436f=_0x48a455;if(!this[_0x2f436f(0x31e)]())return;if(!this['isTutorialListCommandVisible']())return;const _0x482dac=TextManager[_0x2f436f(0x35e)][_0x2f436f(0x328)],_0x112daf=this[_0x2f436f(0x2d0)]();this['addCommand'](_0x482dac,_0x2f436f(0x296),_0x112daf);},Window_MenuCommand[_0x48a455(0x341)][_0x48a455(0x31e)]=function(){const _0xb820ac=_0x48a455;return Imported[_0xb820ac(0x2ec)]?![]:!![];},Window_MenuCommand[_0x48a455(0x341)][_0x48a455(0x1e1)]=function(){const _0x49fddc=_0x48a455;if($gameTemp['canDebugViewTutorialList']())return!![];return $gameSystem[_0x49fddc(0x30a)]();},Window_MenuCommand['prototype']['isTutorialListCommandEnabled']=function(){const _0x214473=_0x48a455;if($gameTemp[_0x214473(0x2d6)]())return!![];return $gameSystem[_0x214473(0x28a)]();},VisuMZ[_0x48a455(0x21d)][_0x48a455(0x2f2)]=Window_Options[_0x48a455(0x341)][_0x48a455(0x209)],Window_Options[_0x48a455(0x341)]['addGeneralOptions']=function(){const _0x1455fc=_0x48a455;VisuMZ[_0x1455fc(0x21d)][_0x1455fc(0x2f2)]['call'](this),this[_0x1455fc(0x225)]();},Window_Options['prototype'][_0x48a455(0x225)]=function(){const _0x42b865=_0x48a455;VisuMZ[_0x42b865(0x21d)]['Settings'][_0x42b865(0x1e7)][_0x42b865(0x1f0)]&&this[_0x42b865(0x301)]();},Window_Options[_0x48a455(0x341)][_0x48a455(0x301)]=function(){const _0x2a6037=_0x48a455,_0x300857=TextManager[_0x2a6037(0x35e)][_0x2a6037(0x31d)],_0x259c25=_0x2a6037(0x2f1);this[_0x2a6037(0x2c8)](_0x300857,_0x259c25);};function Window_TutorialPages(){const _0x4f3df9=_0x48a455;this[_0x4f3df9(0x1f8)](...arguments);}Window_TutorialPages[_0x48a455(0x341)]=Object[_0x48a455(0x232)](Window_HorzCommand['prototype']),Window_TutorialPages[_0x48a455(0x341)][_0x48a455(0x2aa)]=Window_TutorialPages,Window_TutorialPages[_0x48a455(0x341)][_0x48a455(0x1f8)]=function(_0x3fef0f){const _0x262ba7=_0x48a455;this[_0x262ba7(0x26b)]=0x0,Window_HorzCommand['prototype'][_0x262ba7(0x1f8)][_0x262ba7(0x2b5)](this,_0x3fef0f),this[_0x262ba7(0x35a)](0x0),this[_0x262ba7(0x2f6)]();},Window_TutorialPages['prototype'][_0x48a455(0x2ee)]=function(){const _0x1ad16b=_0x48a455;delete this[_0x1ad16b(0x30d)],delete this['_itemWidthCache'],this[_0x1ad16b(0x26b)]=0x0,this[_0x1ad16b(0x2dc)]=0x0;},Window_TutorialPages[_0x48a455(0x341)]['maxCols']=function(){const _0x27158b=_0x48a455;if(this[_0x27158b(0x30d)]!==undefined)return this[_0x27158b(0x30d)];return this['_maxColCache']=SceneManager[_0x27158b(0x1fe)][_0x27158b(0x2c1)]()[_0x27158b(0x22d)],this[_0x27158b(0x30d)];},Window_TutorialPages[_0x48a455(0x341)]['colSpacing']=function(){return 0x0;},Window_TutorialPages[_0x48a455(0x341)]['itemWidth']=function(){const _0x36d624=_0x48a455;if(this[_0x36d624(0x2bc)]!==undefined)return this[_0x36d624(0x2bc)];const _0x445986=TextManager['tutorial'][_0x36d624(0x251)],_0x5a789f=TextManager[_0x36d624(0x35e)][_0x36d624(0x220)],_0x81afc1=Math['max'](this[_0x36d624(0x2fb)](_0x445986)['width'],this[_0x36d624(0x2fb)](_0x5a789f)[_0x36d624(0x31a)]);return this['_itemWidthCache']=Math['ceil'](_0x81afc1+0x1*this[_0x36d624(0x1f7)]()),this['_itemWidthCache'];},Window_TutorialPages[_0x48a455(0x341)][_0x48a455(0x1fc)]=function(_0x5ef242){const _0x3e8469=_0x48a455,_0x5b4f7d=this[_0x3e8469(0x34a)](),_0x5ab229=this[_0x3e8469(0x337)](),_0x461bcb=this[_0x3e8469(0x2c4)](),_0x57486d=_0x5ab229*_0x5b4f7d,_0x459f8b=Math['floor']((this[_0x3e8469(0x21c)]-_0x57486d)/0x2)+_0x5ef242*_0x5ab229,_0x2cffac=0x0,_0x16c345=_0x5ab229,_0x450550=_0x461bcb;return new Rectangle(_0x459f8b,_0x2cffac,_0x16c345,_0x450550);},Window_TutorialPages[_0x48a455(0x341)][_0x48a455(0x217)]=function(){const _0x30c099=_0x48a455;let _0x218e8e=this[_0x30c099(0x34a)]();while(_0x218e8e--){this[_0x30c099(0x2c8)]('',_0x30c099(0x270),!![],this['_list'][_0x30c099(0x22d)]);}},Window_TutorialPages['prototype']['drawItemBackground']=function(_0x203bf8){},Window_TutorialPages[_0x48a455(0x341)]['drawItem']=function(_0x1781d2){const _0x538896=_0x48a455,_0xe1b15c=this[_0x538896(0x1dc)](_0x1781d2),_0x2f1c21=this[_0x538896(0x1f1)](_0x1781d2),_0x1bf2f1=this[_0x538896(0x2fb)](_0x2f1c21)[_0x538896(0x31a)];this['changePaintOpacity'](this[_0x538896(0x308)](_0x1781d2));const _0x2f63bc=this['itemTextAlign']();if(_0x2f63bc==='right')'hbUGO'===_0x538896(0x34b)?_0x1bfb3d[_0x538896(0x2bd)]():this[_0x538896(0x2c2)](_0x2f1c21,_0xe1b15c['x']+_0xe1b15c[_0x538896(0x31a)]-_0x1bf2f1,_0xe1b15c['y'],_0x1bf2f1);else{if(_0x2f63bc==='center'){if('ZqrTt'==='bCZlq')this[_0x538896(0x1f8)](...arguments);else{const _0x27ffba=_0xe1b15c['x']+Math[_0x538896(0x2db)]((_0xe1b15c['width']-_0x1bf2f1)/0x2);this[_0x538896(0x2c2)](_0x2f1c21,_0x27ffba,_0xe1b15c['y'],_0x1bf2f1);}}else{if(_0x538896(0x329)==='lyTAe')this['drawTextEx'](_0x2f1c21,_0xe1b15c['x'],_0xe1b15c['y'],_0x1bf2f1);else return _0x1c08a1['prototype']['buttonAssistKey1'][_0x538896(0x2b5)](this);}}},Window_TutorialPages['prototype']['commandName']=function(_0x14b64b){const _0xa7d0cb=_0x48a455;if(_0x14b64b===SceneManager['_scene'][_0xa7d0cb(0x1df)]())return TextManager[_0xa7d0cb(0x35e)]['activePage'];else{if(_0xa7d0cb(0x350)!==_0xa7d0cb(0x283))return TextManager[_0xa7d0cb(0x35e)][_0xa7d0cb(0x220)];else{_0x15bea1[_0xa7d0cb(0x341)][_0xa7d0cb(0x232)]['call'](this),this[_0xa7d0cb(0x215)]();if(this[_0xa7d0cb(0x2a3)])this[_0xa7d0cb(0x2a3)]['update']();}}},Window_TutorialPages[_0x48a455(0x341)]['select']=function(_0x28120f){const _0xc689df=_0x48a455;Window_HorzCommand['prototype'][_0xc689df(0x35a)][_0xc689df(0x2b5)](this,_0x28120f);if(this[_0xc689df(0x26b)]!==this['_index']){if('qCXrt'===_0xc689df(0x2a1)){if(this['_lastIndex']>=0x0&&this[_0xc689df(0x2dc)]>=0x0){if(_0xc689df(0x22b)===_0xc689df(0x2fd))return _0x279aa5['TutorialPanelSys'][_0xc689df(0x32f)][_0xc689df(0x228)][_0xc689df(0x333)][_0xc689df(0x2b5)](this,this[_0xc689df(0x34c)]);else SoundManager['playTutorialPageChange']();}this[_0xc689df(0x26b)]=this[_0xc689df(0x2dc)],SceneManager[_0xc689df(0x1fe)][_0xc689df(0x247)]=this[_0xc689df(0x2dc)],this[_0xc689df(0x2f6)]();}else this[_0xc689df(0x2ef)]=_0x15e75f;}},Window_TutorialPages['prototype'][_0x48a455(0x335)]=function(){const _0x32f162=_0x48a455;this[_0x32f162(0x2d3)](0x0,0x0,0x0,0x0);},Window_TutorialPages[_0x48a455(0x341)][_0x48a455(0x2ca)]=function(){return'center';},Window_TutorialPages[_0x48a455(0x341)]['isMenuCursorBlacklisted']=function(){return!![];},Window_TutorialPages[_0x48a455(0x341)][_0x48a455(0x2e6)]=function(){},Window_TutorialPages[_0x48a455(0x341)][_0x48a455(0x29d)]=function(){},Window_TutorialPages[_0x48a455(0x341)][_0x48a455(0x27f)]=function(){return![];},Window_TutorialPages[_0x48a455(0x341)][_0x48a455(0x2b6)]=function(_0x4fa7cc){const _0x2783c1=_0x48a455;Window_HorzCommand[_0x2783c1(0x341)][_0x2783c1(0x2b6)][_0x2783c1(0x2b5)](this,![]);},Window_TutorialPages[_0x48a455(0x341)][_0x48a455(0x31b)]=function(_0xb7dabb){const _0x2795da=_0x48a455;Window_HorzCommand[_0x2795da(0x341)]['cursorLeft'][_0x2795da(0x2b5)](this,![]);},Window_TutorialPages[_0x48a455(0x341)][_0x48a455(0x30b)]=function(){const _0x252d62=_0x48a455;this[_0x252d62(0x2b6)]();},Window_TutorialPages[_0x48a455(0x341)]['cursorPageup']=function(){const _0x3424b7=_0x48a455;this[_0x3424b7(0x31b)]();},Window_TutorialPages['prototype'][_0x48a455(0x1ed)]=function(_0x27a646){const _0x53db30=_0x48a455;if(_0x27a646)return;Window_HorzCommand[_0x53db30(0x341)][_0x53db30(0x1ed)][_0x53db30(0x2b5)](this,_0x27a646);},Window_TutorialPages[_0x48a455(0x341)][_0x48a455(0x330)]=function(){const _0x69089d=_0x48a455,_0x2bdfdc=this[_0x69089d(0x305)]();if(_0x2bdfdc>=0x0)return;const _0x46bb92=0x3c;if(TouchInput['y']<_0x46bb92||TouchInput['y']>Graphics['height']-_0x46bb92)return;if(TouchInput['x']>=Graphics[_0x69089d(0x31a)]/0x2){const _0x113a3b=Math[_0x69089d(0x303)](this[_0x69089d(0x282)]()+0x1,this[_0x69089d(0x34a)]()-0x1);this[_0x69089d(0x35a)](_0x113a3b);}else{if(TouchInput['x']<Graphics[_0x69089d(0x31a)]/0x2){const _0x27ab5d=Math[_0x69089d(0x31f)](this[_0x69089d(0x282)]()-0x1,0x0);this[_0x69089d(0x35a)](_0x27ab5d);}}},Window_TutorialPages['prototype'][_0x48a455(0x351)]=function(){const _0x451d62=_0x48a455;if(this['isWheelScrollEnabled']()&&!this[_0x451d62(0x27c)]()){const _0x59a05c=0x14;if(TouchInput[_0x451d62(0x33b)]>=_0x59a05c){const _0x27338e=Math[_0x451d62(0x303)](this[_0x451d62(0x282)]()+0x1,this[_0x451d62(0x34a)]()-0x1);this[_0x451d62(0x35a)](_0x27338e);}if(TouchInput[_0x451d62(0x33b)]<=-_0x59a05c){if(_0x451d62(0x360)===_0x451d62(0x360)){const _0x1fe1de=Math[_0x451d62(0x31f)](this[_0x451d62(0x282)]()-0x1,0x0);this[_0x451d62(0x35a)](_0x1fe1de);}else{const _0xd74e0=_0x197bed[_0x451d62(0x303)](this[_0x451d62(0x282)]()+0x1,this[_0x451d62(0x34a)]()-0x1);this[_0x451d62(0x35a)](_0xd74e0);}}}};function Window_TutorialDescription(){const _0x1fe18b=_0x48a455;this[_0x1fe18b(0x1f8)](...arguments);}function _0x6787(){const _0x1dea6e=['_listWindow','addTutorialListCommands','contents','removeTutorialKey','SceneBattle','initTutorialMembers','442494DEVanp','reCPm','CategoryTutorials','length','VocabChangePage','includes','Scene_Menu_createCommandWindow','createAllWindows','create','createDescriptionWindow','initTutorialPanelSysMainMenu','center','RegisterTutorial','currentCategory','activate','VRyxC','command357','push','volume','tutorialData','mainAreaBottom','symbol','KeyIDs','XZPjK','getTutorialCategoryPopulation','process_VisuMZ_TutorialData','Scene_Battle_createAllWindows','tutorialTitle','ListWindow_BgType','_tutorialPageIndex','DNSyE','clear','right','TitleWindow_RectJS','swzEg','createTutorialPictureWindow','BgFilename1','HFBbx','(needs\x20key)','activePage','FUNC','Category','zAbAq','close','readFlag','initTutorialPanelSysSettings','expand','mainAreaTop','createCustomBackgroundImages','mOaBx','BgFilename2','pan','tutorialKey','_visibleTutorialKeys','SnapshotOpacity','onListTutorial','createPageWindow','initCategoryStatus','closedCategoriesFmt','_backSprite2','qhaYJ','Reveal','tTQPP','findIndex','CategoryOrder','_lastIndex','update','BypassIfRegistered','60pnLSnR','makeTutorialList','page','SystemEnableTutorialListMenu','ConvertParams','_tutorialPictureWindow','bind','setText','smoothSelect','_lastPage','_filename','anchor','EnableMainMenu','vdGpr','isTouchedInsideFrame','raSDN','LrUdZ','isUseModernControls','trim','active','index','sTKCl','includeCategory','Wazcr','remove','boxWidth','ForceView','_descriptionWindow','isMainMenuTutorialListEnabled','map','category','4ReZvsF','enabled','calcWindowHeight','12eZgNqd','VocabDoneTutorial','createTutorialDescriptionWindow','VocabExpand','isHideStatusWindowTutorial','ARRAYSTR','tutorialList','wait','Scene_Battle_updateStatusWindowVisibility','_pageWindow','1273NGZaHD','loadTitle1','addTutorial','playOkSound','currentSymbol','ShowMainMenu','buttonAssistText5','qCXrt','ListWindow_RectJS','_buttonAssistWindow','adjustSprite','Sound','setBackgroundType','commandTutorialList','_categoryStatus','Scene_Boot_onDatabaseLoaded','constructor','height','setWaitMode','STRUCT','process_VisuMZ_TutorialPanelSys','buttonAssistText4','Game_System_initialize','Window_MenuCommand_addOriginalCommands','descriptionWindowRect','llJqd','pictureWindowRect','call','cursorRight','createTutorialPageWindow','_tutorialKey','242oKgOPh','titleWindowRect','setBackgroundOpacity','_itemWidthCache','playTutorialPageChange','PageWindow_BgType','_list','%1\x27s\x20version\x20does\x20not\x20match\x20plugin\x27s.\x20Please\x20update\x20it\x20in\x20the\x20Plugin\x20Manager.','tutorialPages','drawTextEx','updateSmoothScroll','itemHeight','ZYRXP','boxHeight','_tutorialTitleWindow','addCommand','tutorialPictureWindowRect','itemTextAlign','currentTutorialPage','deactivate','createCommandWindow','scaleSprite','maxCommands','isTutorialListCommandEnabled','VocabCollapse','VocabClosedCategory','setCursorRect','parse','pitch','canDebugViewTutorialList','createTutorialWindows','findSymbolExt','AAwLH','pageWindowRect','floor','_index','RiPLD','buttonAreaHeight','ottqP','addCategory','VocabActivePage','makeData','addOriginalCommands','_scrollDuration','SceneTutorialData','playCursorSound','276514cVapxi','ARRAYJSON','isPlaytest','createBackground','bitmap','VisuMZ_1_MainMenuCore','setHandler','clearCache','_debugViewTutorialList','pQovM','showTutorials','Window_Options_addGeneralOptions','BFVBU','ARRAYEVAL','iwEKi','refresh','drawItem','CategoryData','registerTutorialKey','maxVisibleItems','textSizeEx','updateWaitMode','Ioqoj','addWindow','cancel','_waitMode','addTutorialPanelSysNewOptionCommand','_pictureWindow','min','exit','hitIndex','isSceneMap','loadPicture','isCommandEnabled','SystemShowTutorialListMenu','isMainMenuTutorialListVisible','cursorPagedown','addTutorialListCommand','_maxColCache','eVmXe','OzESz','EUftH','innerHeight','view','updateStatusWindowVisibility','VocabInactivePage','kTqDW','finish','filter','format','187814JCJBZL','width','cursorLeft','registerCommand','optionsCmd','addTutorialListCommandAutomatically','max','668313vHHrWJ','Pages','PictureWindow_BgType','_text','VocabOpenCategory','createTutorialTitleWindow','cnwKk','BLTpB','menuCmd','lyTAe','HmwPJ','popScene','tutorialDescriptionWindowRect','isTutorialCategoryPopulated','mainAreaHeight','Settings','onTouchOk','Name','_titleWindow','PictureWindow_RectJS','setMainMenuTutorialLabelEnabled','refreshCursor','isTutorialKeyRegistered','itemWidth','_TutorialPanelSys_MainMenu','buttonAssistKey1','847395FYWqFY','wheelY','tutorialPageWindowRect','TitleWindow_BgType','shown','updatePage','setFilename','prototype','KwVOL','DescWindow_RectJS','VocabNextPage','openCategoriesFmt','process_VisuMZ_TutorialCategories','centerSprite','Key','addChild','maxCols','GBwmC','_tutorialDescriptionWindow','Game_Interpreter_PluginCommand','isAnyInputWindowActive','getLastPluginCommandInterpreter','PlLhb','processWheelScroll','_lastPluginCommandInterpreter','EkdNL','_returnTutorialKey','112OwSwFj','addLoadListener','SceneTutorialList','createTitleWindow','_backSprite1','select','JSON','_interpreter','openTutorial','tutorial','unlisted','cDkPa','loadTitle2','nextPage','ConfigManager_applyData','return\x200','%1\x20is\x20incorrectly\x20placed\x20on\x20the\x20plugin\x20list.\x0aIt\x20is\x20a\x20Tier\x20%2\x20plugin\x20placed\x20over\x20other\x20Tier\x20%3\x20plugins.\x0aPlease\x20reorder\x20the\x20plugin\x20list\x20from\x20smallest\x20to\x20largest\x20tier\x20numbers.','description','show','itemLineRect','createPictureWindow','TutorialRegisterKeys','tutorialPageIndex','isCategoryOpen','isTutorialListCommandVisible','setMainMenuTutorialListVisible','currentExt','name','tutorialTitleWindowRect','openCloseCurrentCategory','Options','setDebugViewTutorialList','2649640aPAmuj','applyData','ARRAYFUNC','DescWindow_BgType','onTouchSelect','Scene_Battle_isAnyInputWindowActive','isSceneBattle','AddTutorialsOption','commandName','Enable','isValidTutorial','Game_Interpreter_updateWaitMode','TutorialList','Filename','itemPadding','initialize','PageWindow_RectJS','toLowerCase','_commandWindow','itemRect','Scene_Options_maxCommands','_scene','gkvdd','_tutorialPageWindow','hide','gcknC','playCancel','Description','qLCTF','Tutorials','_pictureSprite','ARRAYSTRUCT','addGeneralOptions','%1\x20is\x20missing\x20a\x20required\x20plugin.\x0aPlease\x20install\x20%2\x20into\x20the\x20Plugin\x20Manager.','onListCategory','listWindowRect','closeTutorial','getInputMultiButtonStrings','wCSXJ','Title','RgIze','lUbrY','ConfigManager_makeData','AdjustRect','createListWindow','getBackgroundOpacity','makeCommandList','setTopRow','pyBfS','setLastPluginCommandInterpreter','includeTutorial','innerWidth','TutorialPanelSys','_tutorialData','match','inactivePage','left','status','reselectReturnTutorialKey'];_0x6787=function(){return _0x1dea6e;};return _0x6787();}Window_TutorialDescription[_0x48a455(0x341)]=Object[_0x48a455(0x232)](Window_Base[_0x48a455(0x341)]),Window_TutorialDescription[_0x48a455(0x341)][_0x48a455(0x2aa)]=Window_TutorialDescription,Window_TutorialDescription[_0x48a455(0x341)][_0x48a455(0x1f8)]=function(_0x1b44fe){const _0x2a7967=_0x48a455;Window_Base[_0x2a7967(0x341)][_0x2a7967(0x1f8)][_0x2a7967(0x2b5)](this,_0x1b44fe),this[_0x2a7967(0x323)]='',this[_0x2a7967(0x277)]=-0x1;},Window_TutorialDescription['prototype'][_0x48a455(0x275)]=function(_0xf9ecba){const _0x399ffa=_0x48a455;this[_0x399ffa(0x323)]!==_0xf9ecba&&(this[_0x399ffa(0x323)]=_0xf9ecba,this[_0x399ffa(0x2f6)]());},Window_TutorialDescription[_0x48a455(0x341)][_0x48a455(0x2f6)]=function(){const _0xb9d518=_0x48a455;this[_0xb9d518(0x226)][_0xb9d518(0x249)]();const _0x30ddad=this[_0xb9d518(0x323)],_0x5ed88e=this['textSizeEx'](_0x30ddad),_0x5aa7e8=Math[_0xb9d518(0x2db)]((this[_0xb9d518(0x21c)]-_0x5ed88e[_0xb9d518(0x31a)])/0x2),_0x4a0155=Math['floor']((this[_0xb9d518(0x311)]-_0x5ed88e[_0xb9d518(0x2ab)])/0x2);this[_0xb9d518(0x2c2)](_0x30ddad,_0x5aa7e8,_0x4a0155);},Window_TutorialDescription['prototype'][_0x48a455(0x26c)]=function(){const _0x5371ff=_0x48a455;Window_Base['prototype'][_0x5371ff(0x26c)][_0x5371ff(0x2b5)](this),this[_0x5371ff(0x33f)]();},Window_TutorialDescription[_0x48a455(0x341)]['updatePage']=function(_0x4b421c){const _0x52c2d5=_0x48a455;if(!_0x4b421c&&this['_lastPage']===SceneManager[_0x52c2d5(0x1fe)]['tutorialPageIndex']())return;const _0x274a14=SceneManager[_0x52c2d5(0x1fe)];this[_0x52c2d5(0x277)]=_0x274a14[_0x52c2d5(0x1df)]();const _0x2d202d=_0x274a14[_0x52c2d5(0x2cb)]()?_0x274a14[_0x52c2d5(0x2cb)]()[_0x52c2d5(0x204)]||'':'';this[_0x52c2d5(0x275)](_0x2d202d[_0x52c2d5(0x280)]());};function Window_TutorialPicture(){const _0x3b1deb=_0x48a455;this[_0x3b1deb(0x1f8)](...arguments);}Window_TutorialPicture[_0x48a455(0x341)]=Object[_0x48a455(0x232)](Window_Base[_0x48a455(0x341)]),Window_TutorialPicture[_0x48a455(0x341)][_0x48a455(0x2aa)]=Window_TutorialPicture,Window_TutorialPicture[_0x48a455(0x341)][_0x48a455(0x1f8)]=function(_0x4c058f){const _0x3bf643=_0x48a455;Window_Base[_0x3bf643(0x341)][_0x3bf643(0x1f8)][_0x3bf643(0x2b5)](this,_0x4c058f),this['createPictureSprite'](),this[_0x3bf643(0x278)]='',this[_0x3bf643(0x277)]=-0x1;},Window_TutorialPicture['prototype']['createPictureSprite']=function(){const _0x21b3c4=_0x48a455;this[_0x21b3c4(0x207)]=new Sprite(),this[_0x21b3c4(0x349)](this[_0x21b3c4(0x207)]),this[_0x21b3c4(0x207)][_0x21b3c4(0x279)]['x']=0.5,this[_0x21b3c4(0x207)][_0x21b3c4(0x279)]['y']=0.5,this[_0x21b3c4(0x207)]['x']=Math[_0x21b3c4(0x2db)](this[_0x21b3c4(0x31a)]/0x2),this[_0x21b3c4(0x207)]['y']=Math[_0x21b3c4(0x2db)](this[_0x21b3c4(0x2ab)]/0x2);},Window_TutorialPicture[_0x48a455(0x341)][_0x48a455(0x340)]=function(_0x2d63e8){const _0x5a0986=_0x48a455;if(!this[_0x5a0986(0x207)])return;this['_filename']!==_0x2d63e8&&(this[_0x5a0986(0x278)]=_0x2d63e8,this[_0x5a0986(0x2f6)]());},Window_TutorialPicture['prototype'][_0x48a455(0x2f6)]=function(){const _0x5bd4e3=_0x48a455;if(this[_0x5bd4e3(0x278)]!==''){if(_0x5bd4e3(0x20f)!==_0x5bd4e3(0x20f)){const _0x4837e7=_0xc4f1ad['x']+_0x2a11a1[_0x5bd4e3(0x2db)]((_0x56adb6['width']-_0xad5c78)/0x2);this[_0x5bd4e3(0x2c2)](_0x179598,_0x4837e7,_0x431760['y'],_0x50c6ef);}else this[_0x5bd4e3(0x207)]['bitmap']=ImageManager[_0x5bd4e3(0x307)](this[_0x5bd4e3(0x278)]);}else{if(_0x5bd4e3(0x266)===_0x5bd4e3(0x266))this[_0x5bd4e3(0x207)]['bitmap']=new Bitmap(0x1,0x1);else{const _0x20a13a=this[_0x5bd4e3(0x20c)](),_0x589c20=new _0x461708(_0x20a13a);this[_0x5bd4e3(0x2fe)](_0x589c20),this[_0x5bd4e3(0x224)]=_0x589c20,_0x589c20[_0x5bd4e3(0x2ed)](_0x5bd4e3(0x2ff),this[_0x5bd4e3(0x32b)][_0x5bd4e3(0x274)](this)),_0x589c20['setHandler']('category',this[_0x5bd4e3(0x20b)][_0x5bd4e3(0x274)](this)),_0x589c20[_0x5bd4e3(0x2ed)]('tutorial',this[_0x5bd4e3(0x261)][_0x5bd4e3(0x274)](this)),_0x589c20[_0x5bd4e3(0x2a6)](_0x507a3b[_0x5bd4e3(0x21d)][_0x5bd4e3(0x32f)][_0x5bd4e3(0x357)]['ListWindow_BgType']);}}},Window_TutorialPicture[_0x48a455(0x341)][_0x48a455(0x26c)]=function(){const _0x31039f=_0x48a455;Window_Base[_0x31039f(0x341)][_0x31039f(0x26c)][_0x31039f(0x2b5)](this),this[_0x31039f(0x33f)]();},Window_TutorialPicture['prototype'][_0x48a455(0x33f)]=function(_0x4705e1){const _0x4331ca=_0x48a455;if(!_0x4705e1&&this[_0x4331ca(0x277)]===SceneManager[_0x4331ca(0x1fe)]['tutorialPageIndex']())return;const _0x5e9527=SceneManager['_scene'];this[_0x4331ca(0x277)]=_0x5e9527[_0x4331ca(0x1df)]();const _0x210cce=_0x5e9527[_0x4331ca(0x2cb)]()?_0x5e9527[_0x4331ca(0x2cb)]()[_0x4331ca(0x1f6)]||'':'';this[_0x4331ca(0x340)](_0x210cce);};function _0x4f25(_0x33f26e,_0x1f3f65){const _0x678755=_0x6787();return _0x4f25=function(_0x4f25a7,_0x528ac5){_0x4f25a7=_0x4f25a7-0x1d6;let _0x5abd73=_0x678755[_0x4f25a7];return _0x5abd73;},_0x4f25(_0x33f26e,_0x1f3f65);}function Window_TutorialTitle(){this['initialize'](...arguments);}Window_TutorialTitle[_0x48a455(0x341)]=Object[_0x48a455(0x232)](Window_Base[_0x48a455(0x341)]),Window_TutorialTitle['prototype'][_0x48a455(0x2aa)]=Window_TutorialTitle,Window_TutorialTitle[_0x48a455(0x341)]['initialize']=function(_0x4841d3){const _0x1131b6=_0x48a455;Window_Base[_0x1131b6(0x341)][_0x1131b6(0x1f8)]['call'](this,_0x4841d3),this[_0x1131b6(0x323)]='';},Window_TutorialTitle[_0x48a455(0x341)][_0x48a455(0x275)]=function(_0x59f2e7){const _0x2fe1cd=_0x48a455;this['_text']!==_0x59f2e7&&('LrUdZ'!==_0x2fe1cd(0x27e)?(this[_0x2fe1cd(0x2ce)](_0x4eb655),this[_0x2fe1cd(0x347)](_0x3fce1d)):(this[_0x2fe1cd(0x323)]=_0x59f2e7,this[_0x2fe1cd(0x2f6)]()));},Window_TutorialTitle[_0x48a455(0x341)][_0x48a455(0x249)]=function(){const _0x412154=_0x48a455;this[_0x412154(0x275)]('');},Window_TutorialTitle[_0x48a455(0x341)][_0x48a455(0x2f6)]=function(){const _0xd6c362=_0x48a455;this[_0xd6c362(0x226)][_0xd6c362(0x249)]();const _0x511f9d=this['_text'],_0x137b08=this[_0xd6c362(0x2fb)](_0x511f9d),_0x3f3849=Math[_0xd6c362(0x2db)]((this[_0xd6c362(0x21c)]-_0x137b08[_0xd6c362(0x31a)])/0x2),_0x346fd0=Math['floor']((this[_0xd6c362(0x311)]-_0x137b08[_0xd6c362(0x2ab)])/0x2);this['drawTextEx'](_0x511f9d,_0x3f3849,_0x346fd0);};function Window_TutorialList(){const _0x3e5556=_0x48a455;this[_0x3e5556(0x1f8)](...arguments);}Window_TutorialList['prototype']=Object[_0x48a455(0x232)](Window_Command[_0x48a455(0x341)]),Window_TutorialList[_0x48a455(0x341)][_0x48a455(0x2aa)]=Window_TutorialList,Window_TutorialList[_0x48a455(0x341)]['initialize']=function(_0x5efed9){const _0x1a363f=_0x48a455;this['initCategoryStatus'](),Window_Command[_0x1a363f(0x341)][_0x1a363f(0x1f8)][_0x1a363f(0x2b5)](this,_0x5efed9),this[_0x1a363f(0x223)]();},Window_TutorialList[_0x48a455(0x341)][_0x48a455(0x263)]=function(){const _0x5a06e0=_0x48a455;this['_categoryStatus']={};const _0x52e915=VisuMZ[_0x5a06e0(0x21d)]['CategoryOrder'];for(const _0x427139 of _0x52e915){if(!this['includeCategory'](_0x427139))continue;this[_0x5a06e0(0x2a8)][_0x427139[_0x5a06e0(0x1fa)]()[_0x5a06e0(0x280)]()]=!![];}},Window_TutorialList[_0x48a455(0x341)]['reselectReturnTutorialKey']=function(){const _0x29c748=_0x48a455;if($gameTemp[_0x29c748(0x354)]===undefined)return;const _0x282d21=$gameTemp[_0x29c748(0x354)];$gameTemp[_0x29c748(0x354)]=undefined;const _0x4a341a=this[_0x29c748(0x2d8)](_0x29c748(0x35e),_0x282d21),_0x6e63d7=Math[_0x29c748(0x2db)](this[_0x29c748(0x2fa)]()/0x2)-0x1;this[_0x29c748(0x276)](_0x4a341a),this[_0x29c748(0x2e4)]>0x1&&(this[_0x29c748(0x2e4)]=0x1,this[_0x29c748(0x2c3)]()),this[_0x29c748(0x218)](_0x4a341a-_0x6e63d7),this['callUpdateHelp']();},Window_TutorialList[_0x48a455(0x341)]['findSymbolExt']=function(_0x39b04d,_0x3b9f39){const _0x5d87f3=_0x48a455;return this[_0x5d87f3(0x2bf)][_0x5d87f3(0x269)](_0x47549e=>_0x47549e[_0x5d87f3(0x23f)]===_0x39b04d&&_0x47549e['ext']===_0x3b9f39);},Window_TutorialList[_0x48a455(0x341)]['makeCommandList']=function(){const _0x33d344=_0x48a455,_0x401795=VisuMZ[_0x33d344(0x21d)][_0x33d344(0x26a)];for(const _0x2ea74 of _0x401795){if(!this[_0x33d344(0x284)](_0x2ea74))continue;this[_0x33d344(0x2e0)](_0x2ea74);}},Window_TutorialList[_0x48a455(0x341)][_0x48a455(0x284)]=function(_0x21b3c1){const _0x3c1fa6=_0x48a455;if($gameTemp[_0x3c1fa6(0x2d6)]())return!![];return $gameSystem[_0x3c1fa6(0x32d)](_0x21b3c1);},Window_TutorialList[_0x48a455(0x341)][_0x48a455(0x1e0)]=function(_0x59ada8){const _0x5142ea=_0x48a455;return _0x59ada8=_0x59ada8[_0x5142ea(0x1fa)]()['trim'](),this['_categoryStatus'][_0x59ada8];},Window_TutorialList[_0x48a455(0x341)]['addCategory']=function(_0x4af335){const _0xb883f3=_0x48a455;_0x4af335=_0x4af335[_0xb883f3(0x1fa)]()[_0xb883f3(0x280)]();const _0x1fc260=_0x4af335===_0xb883f3(0x35f),_0x21a7da=this[_0xb883f3(0x1e0)](_0x4af335)?TextManager[_0xb883f3(0x35e)][_0xb883f3(0x345)]:TextManager[_0xb883f3(0x35e)][_0xb883f3(0x264)],_0xb3480f=_0x1fc260?{}:VisuMZ[_0xb883f3(0x21d)]['CategoryData'][_0x4af335];if(!_0xb3480f)return;const _0x3fc1ba=_0x1fc260?TextManager['tutorial'][_0xb883f3(0x35f)]:_0xb3480f[_0xb883f3(0x210)],_0x4b6053=$gameSystem[_0xb883f3(0x242)](_0x4af335);if(_0x4b6053<=0x0)return;const _0x273e6c=_0x21a7da['format'](_0x3fc1ba,_0x4b6053);this['addCommand'](_0x273e6c,'category',!![],_0x4af335),this['makeTutorialList'](_0x4af335);},Window_TutorialList[_0x48a455(0x341)]['openCloseCurrentCategory']=function(){const _0x213e68=_0x48a455,_0x5a95d2=this[_0x213e68(0x237)]();this[_0x213e68(0x2a8)][_0x5a95d2]=!this['_categoryStatus'][_0x5a95d2],this[_0x213e68(0x2f6)]();},Window_TutorialList[_0x48a455(0x341)][_0x48a455(0x237)]=function(){const _0x8fbe5d=_0x48a455;return this[_0x8fbe5d(0x29e)]()==='category'?this[_0x8fbe5d(0x1e3)]():null;},Window_TutorialList[_0x48a455(0x341)][_0x48a455(0x26f)]=function(_0x5d4b90){const _0x16af44=_0x48a455;if(!this[_0x16af44(0x1e0)](_0x5d4b90))return;const _0x30c460=VisuMZ['TutorialPanelSys']['CategoryTutorials'][_0x5d4b90];for(const _0x77dfd9 of _0x30c460){if(!this[_0x16af44(0x21b)](_0x77dfd9))continue;this[_0x16af44(0x29c)](_0x77dfd9);}},Window_TutorialList['prototype']['includeTutorial']=function(_0x2f3bc7){const _0x22e95d=_0x48a455;if(!VisuMZ[_0x22e95d(0x21d)][_0x22e95d(0x1f3)](_0x2f3bc7))return![];if($gameTemp[_0x22e95d(0x2d6)]())return!![];return $gameSystem[_0x22e95d(0x336)](_0x2f3bc7);},Window_TutorialList['prototype'][_0x48a455(0x29c)]=function(_0x4aa9a7){const _0x194c32=_0x48a455;_0x4aa9a7=_0x4aa9a7[_0x194c32(0x1fa)]()[_0x194c32(0x280)]();const _0x1be18c=VisuMZ[_0x194c32(0x21d)][_0x194c32(0x206)][_0x4aa9a7];if(!_0x1be18c)return;const _0x29f3ff=_0x1be18c[_0x194c32(0x210)];this[_0x194c32(0x2c8)](_0x29f3ff,_0x194c32(0x35e),!![],_0x4aa9a7);},Window_TutorialList[_0x48a455(0x341)]['itemTextAlign']=function(){return'left';},Window_TutorialList['prototype'][_0x48a455(0x2f7)]=function(_0x220f95){const _0x4af4a5=_0x48a455,_0x5f12bd=this[_0x4af4a5(0x1dc)](_0x220f95),_0x4a0740=this['commandName'](_0x220f95),_0x118202=this[_0x4af4a5(0x2fb)](_0x4a0740)[_0x4af4a5(0x31a)];this['changePaintOpacity'](this['isCommandEnabled'](_0x220f95));const _0x4951e5=this[_0x4af4a5(0x2ca)]();if(_0x4951e5==='right')this[_0x4af4a5(0x2c2)](_0x4a0740,_0x5f12bd['x']+_0x5f12bd[_0x4af4a5(0x31a)]-_0x118202,_0x5f12bd['y'],_0x118202);else{if(_0x4951e5===_0x4af4a5(0x235)){if(_0x4af4a5(0x205)===_0x4af4a5(0x205)){const _0x4d43b5=_0x5f12bd['x']+Math[_0x4af4a5(0x2db)]((_0x5f12bd[_0x4af4a5(0x31a)]-_0x118202)/0x2);this[_0x4af4a5(0x2c2)](_0x4a0740,_0x4d43b5,_0x5f12bd['y'],_0x118202);}else{let _0x2c4636=this[_0x4af4a5(0x200)][_0x4af4a5(0x282)]()+0x1;_0x2c4636>=this[_0x4af4a5(0x2c1)]()[_0x4af4a5(0x22d)]?(_0x5062c6[_0x4af4a5(0x203)](),this['closeTutorial']()):(this[_0x4af4a5(0x200)][_0x4af4a5(0x238)](),this[_0x4af4a5(0x200)][_0x4af4a5(0x35a)](_0x2c4636));}}else this[_0x4af4a5(0x2c2)](_0x4a0740,_0x5f12bd['x'],_0x5f12bd['y'],_0x118202);}};