//=============================================================================
// VisuStella MZ - Active Chain Skills
// VisuMZ_3_ActiveChainSkills.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_3_ActiveChainSkills = true;

var VisuMZ = VisuMZ || {};
VisuMZ.ActiveChainSkills = VisuMZ.ActiveChainSkills || {};
VisuMZ.ActiveChainSkills.version = 1.03;

//=============================================================================
/* ----------------------------------------------------------------------------
 * Effect Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Effect:
 *
 * @param Animation
 *
 * @param AnimationID:num
 * @text Animation ID
 * @parent Animation
 * @type animation
 * @desc Play this animation when the effect activates.
 * Requires VisuMZ_0_CoreEngine.
 * @default 12
 *
 * @param Mirror:eval
 * @text Mirror Animation
 * @parent Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the effect animation?
 * Requires VisuMZ_0_CoreEngine.
 * @default false
 *
 * @param Mute:eval
 * @text Mute Animation
 * @parent Animation
 * @type boolean
 * @on Mute
 * @off Normal
 * @desc Mute the effect animation?
 * Requires VisuMZ_0_CoreEngine.
 * @default true
 *
 * @param Popups
 *
 * @param PopupText:str
 * @text Text
 * @parent Popups
 * @desc Text displayed upon the effect activating.
 * @default CHAIN
 *
 * @param TextColor:str
 * @text Text Color
 * @parent Popups
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 0
 *
 * @param FlashColor:eval
 * @text Flash Color
 * @parent Popups
 * @desc Adjust the popup's flash color.
 * Format: [red, green, blue, alpha]
 * @default [255, 255, 255, 160]
 * 
 * @param FlashDuration:num
 * @text Flash Duration
 * @parent Popups
 * @type number
 * @desc What is the frame duration of the flash effect?
 * @default 60
 *
 */
/* ----------------------------------------------------------------------------
 * Sound Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Sound:
 *
 * @param name:str
 * @text Filename
 * @type file
 * @dir audio/se/
 * @require 1
 * @desc Filename of the sound effect played.
 * @default Skill3
 *
 * @param volume:num
 * @text Volume
 * @type number
 * @max 100
 * @desc Volume of the sound effect played.
 * @default 90
 *
 * @param pitch:num
 * @text Pitch
 * @type number
 * @desc Pitch of the sound effect played.
 * @default 100
 *
 * @param pan:num
 * @text Pan
 * @desc Pan of the sound effect played.
 * @default 0
 *
 */
/* ----------------------------------------------------------------------------
 * UI Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~UI:
 *
 * @param General
 *
 * @param BackgroundImage:str
 * @text Custom BG Image
 * @parent General
 * @type file
 * @dir img/system/
 * @require 1
 * @desc Do you want to use a custom background image?
 * Located in /img/system/ folder. Covers whole screen.
 * @default 
 *
 * @param LargeIconSmoothing:eval
 * @text Icon Smoothing?
 * @parent General
 * @type boolean
 * @on Smooth
 * @off Pixelate
 * @desc Smooth the display for icons?
 * Or pixelate them?
 * @default false
 *
 * @param OpacityDisable:num
 * @text Disabled Opacity
 * @parent General
 * @desc What is the opacity level for disabled UI elements?
 * @default 128
 *
 * @param OpacityRate:num
 * @text Opacity Rate
 * @parent General
 * @desc Fade in/out the background at what opacity rate?
 * Lower is slower. Higher is faster.
 * @default 16
 *
 * @param Scale:num
 * @text Scale
 * @parent General
 * @desc What is the scale of UI buttons?
 * 0.50 = 50%; 1.00 = 100%; 1.50 = 150%;
 * @default 0.50
 *
 * @param contentDrawJS:func
 * @text JS: Draw Skill Data
 * @parent General
 * @type note
 * @desc Code used to draw the skill data layer while
 * Active Chain Skill inputs are active.
 * @default "// Declare Constants\nconst skill = arguments[0];\nconst keyIcon = arguments[1];\nconst costText = arguments[2];\nconst bitmap = this.contents;\nconst lineHeight = this.lineHeight();\nconst iconIndex = skill.iconIndex;\nconst iconSize = ImageManager.iconWidth * 2;\n\n// Draw Large Icon\nconst hx = Math.ceil(bitmap.width / 2);\nthis.drawActiveChainLargeIcon(iconIndex, hx, 0, iconSize);\n\n// Draw Keybind Icon\nconst kx = hx - iconSize;\nthis.drawActiveChainLargeIcon(keyIcon, kx, 0, iconSize);\n\n// Draw Rounded Rectangle\nconst rx = 0;\nconst ry = Math.round(iconSize + lineHeight * 0.25);\nconst rw = bitmap.width;\nconst rh = Math.round(lineHeight * 1.75);\nconst radius = 20;\nconst rcolor = ColorManager.dimColor1();\nbitmap.fillRoundRect(rx, ry, rw, rh, radius, rcolor);\n\n// Draw Skill Name\nconst name = skill.name;\nconst ny = ry + ((costText.length > 0) ? 0 : Math.floor((rh - lineHeight) / 2));\nthis.drawText(name, 0, ny, bitmap.width, 'center');\n\n// Draw Cost Text\nconst cw = this.textSizeEx(costText).width;\nconst cx = Math.floor((bitmap.width - cw) / 2);\nconst cy = ry + Math.ceil(lineHeight * 0.75);\nthis.drawTextEx(costText, cx, cy);"
 *
 * @param backgroundDrawJS:func
 * @text JS: Draw Background
 * @parent General
 * @type note
 * @desc Code used to draw the background layer while
 * Active Chain Skill inputs are active.
 * @default "// Declare Constants\nconst bitmap = this;\nconst width = bitmap.width / 4;\nconst height = bitmap.height;\nconst x = bitmap.width - width;\nconst y = 0;\nconst color1 = ColorManager.dimColor1();\nconst color2 = ColorManager.dimColor2();\n\n// Draw Gradient Background\nbitmap.gradientFillRect(x, y, width, height, color2, color1);"
 * 
 * @param Keybinds
 * @text Key Binds
 * 
 * @param KeybindOffsets
 * @text Offsets
 * @parent Keybinds
 *
 * @param KeybindUiOffsetX:num
 * @text Key Bind Offset X
 * @parent KeybindOffsets
 * @desc Offset the x coordinate all of key bind buttons.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param KeybindUiOffsetY:num
 * @text Key Bind Offset Y
 * @parent KeybindOffsets
 * @desc Offset the y coordinate all of key bind buttons.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @param KeybindPressed
 * @text Pressed
 * @parent Keybinds
 *
 * @param KeypressUiOffsetX:num
 * @text Key Press Offset X
 * @parent KeybindPressed
 * @desc Offset the x coordinate when the key is pressed.
 * Negative: left. Positive: right.
 * @default -4
 *
 * @param KeypressUiOffsetY:num
 * @text Key Press Offset Y
 * @parent KeybindPressed
 * @desc Offset the y coordinate when the key is pressed.
 * Negative: up. Positive: down.
 * @default +4
 * 
 * @param Down
 * @parent Keybinds
 *
 * @param downKeyIcon:num
 * @text Key Icon
 * @parent Down
 * @desc What is the icon used to mark this key bind?
 * Takes priority over Core Engine's Button Assist.
 * @default 0
 *
 * @param downBackgroundImage:str
 * @text Custom BG Image
 * @parent Down
 * @type file
 * @dir img/system/
 * @require 1
 * @desc Do you want to use a custom background image?
 * Located in /img/system/ folder. Ignores scaling.
 * @default 
 * 
 * @param downRectJS:func
 * @text JS: X, Y, W, H
 * @parent Down
 * @type note
 * @desc Code used to determine the dimensions for this button.
 * @default "// Declare Constants\nconst uiWidth = Math.floor(Graphics.width / 3);\nconst spacing = 8;\nconst lines = 4;\n\n// Calculate Dimensions\nconst w = Math.floor(uiWidth / 3) - (spacing * 2);\nconst h = lines * Window_Base.prototype.lineHeight();\nconst x = Graphics.width - Math.floor(uiWidth / 2);\nconst y = Math.floor(Graphics.height / 2) + h + spacing;\n\n// Return Rectangle\nconst rectWidth = Math.max(192, w);\nreturn new Rectangle(x, y, rectWidth, h);"
 * 
 * @param Left
 * @parent Keybinds
 *
 * @param leftKeyIcon:num
 * @text Key Icon
 * @parent Left
 * @desc What is the icon used to mark this key bind?
 * Takes priority over Core Engine's Button Assist.
 * @default 0
 *
 * @param leftBackgroundImage:str
 * @text Custom BG Image
 * @parent Left
 * @type file
 * @dir img/system/
 * @require 1
 * @desc Do you want to use a custom background image?
 * Located in /img/system/ folder. Ignores scaling.
 * @default 
 * 
 * @param leftRectJS:func
 * @text JS: X, Y, W, H
 * @parent Left
 * @type note
 * @desc Code used to determine the dimensions for this button.
 * @default "// Declare Constants\nconst uiWidth = Math.floor(Graphics.width / 3);\nconst spacing = 8;\nconst lines = 4;\n\n// Calculate Dimensions\nconst w = Math.floor(uiWidth / 3) - (spacing * 2);\nconst h = lines * Window_Base.prototype.lineHeight();\nconst x = Graphics.width - Math.floor(uiWidth / 2) - w - spacing;\nconst y = Math.floor(Graphics.height / 2);\n\n// Return Rectangle\nconst rectWidth = Math.max(192, w);\nreturn new Rectangle(x, y, rectWidth, h);"
 * 
 * @param Right
 * @parent Keybinds
 *
 * @param rightKeyIcon:num
 * @text Key Icon
 * @parent Right
 * @desc What is the icon used to mark this key bind?
 * Takes priority over Core Engine's Button Assist.
 * @default 0
 *
 * @param rightBackgroundImage:str
 * @text Custom BG Image
 * @parent Right
 * @type file
 * @dir img/system/
 * @require 1
 * @desc Do you want to use a custom background image?
 * Located in /img/system/ folder. Ignores scaling.
 * @default 
 * 
 * @param rightRectJS:func
 * @text JS: X, Y, W, H
 * @parent Right
 * @type note
 * @desc Code used to determine the dimensions for this button.
 * @default "// Declare Constants\nconst uiWidth = Math.floor(Graphics.width / 3);\nconst spacing = 8;\nconst lines = 4;\n\n// Calculate Dimensions\nconst w = Math.floor(uiWidth / 3) - (spacing * 2);\nconst h = lines * Window_Base.prototype.lineHeight();\nconst x = Graphics.width - Math.floor(uiWidth / 2) + w + spacing;\nconst y = Math.floor(Graphics.height / 2);\n\n// Return Rectangle\nconst rectWidth = Math.max(192, w);\nreturn new Rectangle(x, y, rectWidth, h);"
 * 
 * @param Up
 * @parent Keybinds
 *
 * @param upKeyIcon:num
 * @text Key Icon
 * @parent Up
 * @desc What is the icon used to mark this key bind?
 * Takes priority over Core Engine's Button Assist.
 * @default 0
 *
 * @param upBackgroundImage:str
 * @text Custom BG Image
 * @parent Up
 * @type file
 * @dir img/system/
 * @require 1
 * @desc Do you want to use a custom background image?
 * Located in /img/system/ folder. Ignores scaling.
 * @default 
 * 
 * @param upRectJS:func
 * @text JS: X, Y, W, H
 * @parent Up
 * @type note
 * @desc Code used to determine the dimensions for this button.
 * @default "// Declare Constants\nconst uiWidth = Math.floor(Graphics.width / 3);\nconst spacing = 8;\nconst lines = 4;\n\n// Calculate Dimensions\nconst w = Math.floor(uiWidth / 3) - (spacing * 2);\nconst h = lines * Window_Base.prototype.lineHeight();\nconst x = Graphics.width - Math.floor(uiWidth / 2);\nconst y = Math.floor(Graphics.height / 2) - h - spacing;\n\n// Return Rectangle\nconst rectWidth = Math.max(192, w);\nreturn new Rectangle(x, y, rectWidth, h);"
 * 
 * @param Ok
 * @parent Keybinds
 *
 * @param okKeyIcon:num
 * @text Key Icon
 * @parent Ok
 * @desc What is the icon used to mark this key bind?
 * Takes priority over Core Engine's Button Assist.
 * @default 0
 *
 * @param okBackgroundImage:str
 * @text Custom BG Image
 * @parent Ok
 * @type file
 * @dir img/system/
 * @require 1
 * @desc Do you want to use a custom background image?
 * Located in /img/system/ folder. Ignores scaling.
 * @default 
 * 
 * @param okRectJS:func
 * @text JS: X, Y, W, H
 * @parent Ok
 * @type note
 * @desc Code used to determine the dimensions for this button.
 * @default "// Declare Constants\nconst uiWidth = Math.floor(Graphics.width / 3);\nconst spacing = 8;\nconst lineHeight = Window_Base.prototype.lineHeight();\nconst lines = 4;\n\n// Calculate Dimensions\nconst w = Math.floor(uiWidth / 3) - (spacing * 2);\nconst rectWidth = Math.max(192, w);\nconst h = lines * lineHeight;\nconst x = Graphics.width - Math.floor(uiWidth / 2) - w - spacing;\nconst y = Math.floor(Graphics.height / 2) + h + spacing;\n\n// Return Rectangle\nreturn new Rectangle(x, y, rectWidth, h);"
 * 
 * @param Cancel
 * @parent Keybinds
 *
 * @param cancelKeyIcon:num
 * @text Key Icon
 * @parent Cancel
 * @desc What is the icon used to mark this key bind?
 * Takes priority over Core Engine's Button Assist.
 * @default 0
 *
 * @param cancelBackgroundImage:str
 * @text Custom BG Image
 * @parent Cancel
 * @type file
 * @dir img/system/
 * @require 1
 * @desc Do you want to use a custom background image?
 * Located in /img/system/ folder. Ignores scaling.
 * @default 
 * 
 * @param cancelRectJS:func
 * @text JS: X, Y, W, H
 * @parent Cancel
 * @type note
 * @desc Code used to determine the dimensions for this button.
 * @default "// Declare Constants\nconst uiWidth = Math.floor(Graphics.width / 3);\nconst spacing = 8;\nconst lineHeight = Window_Base.prototype.lineHeight();\nconst lines = 4;\n\n// Calculate Dimensions\nconst w = Math.floor(uiWidth / 3) - (spacing * 2);\nconst rectWidth = Math.max(192, w);\nconst h = lines * lineHeight;\nconst x = Graphics.width - Math.floor(uiWidth / 2) + w + spacing;\nconst y = Math.floor(Graphics.height / 2) + h + spacing;\n\n// Return Rectangle\nreturn new Rectangle(x, y, rectWidth, h);"
 * 
 * @param PageUp
 * @parent Keybinds
 *
 * @param pageupKeyIcon:num
 * @text Key Icon
 * @parent PageUp
 * @desc What is the icon used to mark this key bind?
 * Takes priority over Core Engine's Button Assist.
 * @default 0
 *
 * @param pageupBackgroundImage:str
 * @text Custom BG Image
 * @parent PageUp
 * @type file
 * @dir img/system/
 * @require 1
 * @desc Do you want to use a custom background image?
 * Located in /img/system/ folder. Ignores scaling.
 * @default 
 * 
 * @param pageupRectJS:func
 * @text JS: X, Y, W, H
 * @parent PageUp
 * @type note
 * @desc Code used to determine the dimensions for this button.
 * @default "// Declare Constants\nconst uiWidth = Math.floor(Graphics.width / 3);\nconst spacing = 8;\nconst lineHeight = Window_Base.prototype.lineHeight();\nconst lines = 4;\n\n// Calculate Dimensions\nconst w = Math.floor(uiWidth / 3) - (spacing * 2);\nconst rectWidth = Math.max(192, w);\nconst h = lines * lineHeight;\nconst x = Graphics.width - Math.floor(uiWidth / 2) - w - spacing;\nconst y = Math.floor(Graphics.height / 2) - h - spacing;\n\n// Return Rectangle\nreturn new Rectangle(x, y, rectWidth, h);"
 * 
 * @param PageDown
 * @parent Keybinds
 *
 * @param pagedownKeyIcon:num
 * @text Key Icon
 * @parent PageDown
 * @desc What is the icon used to mark this key bind?
 * Takes priority over Core Engine's Button Assist.
 * @default 0
 *
 * @param pagedownBackgroundImage:str
 * @text Custom BG Image
 * @parent PageDown
 * @type file
 * @dir img/system/
 * @require 1
 * @desc Do you want to use a custom background image?
 * Located in /img/system/ folder. Ignores scaling.
 * @default 
 * 
 * @param pagedownRectJS:func
 * @text JS: X, Y, W, H
 * @parent PageDown
 * @type note
 * @desc Code used to determine the dimensions for this button.
 * @default "// Declare Constants\nconst uiWidth = Math.floor(Graphics.width / 3);\nconst spacing = 8;\nconst lineHeight = Window_Base.prototype.lineHeight();\nconst lines = 4;\n\n// Calculate Dimensions\nconst w = Math.floor(uiWidth / 3) - (spacing * 2);\nconst rectWidth = Math.max(192, w);\nconst h = lines * lineHeight;\nconst x = Graphics.width - Math.floor(uiWidth / 2) + w + spacing;\nconst y = Math.floor(Graphics.height / 2) - h - spacing;\n\n// Return Rectangle\nreturn new Rectangle(x, y, rectWidth, h);"
 * 
 * @param Shift
 * @parent Keybinds
 *
 * @param shiftKeyIcon:num
 * @text Key Icon
 * @parent Shift
 * @desc What is the icon used to mark this key bind?
 * Takes priority over Core Engine's Button Assist.
 * @default 0
 *
 * @param shiftBackgroundImage:str
 * @text Custom BG Image
 * @parent Shift
 * @type file
 * @dir img/system/
 * @require 1
 * @desc Do you want to use a custom background image?
 * Located in /img/system/ folder. Ignores scaling.
 * @default 
 * 
 * @param shiftRectJS:func
 * @text JS: X, Y, W, H
 * @parent Shift
 * @type note
 * @desc Code used to determine the dimensions for this button.
 * @default "// Declare Constants\nconst uiWidth = Math.floor(Graphics.width / 3);\nconst spacing = 8;\nconst lines = 4;\n\n// Calculate Dimensions\nconst w = Math.floor(uiWidth / 3) - (spacing * 2);\nconst h = lines * Window_Base.prototype.lineHeight();\nconst x = Graphics.width - Math.floor(uiWidth / 2);\nconst y = Math.floor(Graphics.height / 2);\n\n// Return Rectangle\nconst rectWidth = Math.max(192, w);\nreturn new Rectangle(x, y, rectWidth, h);"
 *
 */
/* ----------------------------------------------------------------------------
 * Tooltip Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Tooltip:
 *
 * @param enabled:eval
 * @text Enabled?
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Are tooltips enabled?
 * Requires VisuMZ_1_MessageCore!
 * @default true
 *
 * @param Appearance
 *
 * @param Scale:num
 * @text Scale
 * @parent Appearance
 * @desc What scale size do you want for the tooltip?
 * Use 1.0 for normal size.
 * @default 0.6
 *
 * @param WindowSkin:str
 * @text Skin Filename
 * @parent Appearance
 * @type file
 * @dir img/system/
 * @desc What window skin do you want to use for the tooltip?
 * @default Window
 *
 * @param WindowOpacity:num
 * @text Skin Opacity
 * @parent Appearance
 * @type number
 * @min 0
 * @max 255
 * @desc What opacity setting is used for the tooltip?
 * Use a number between 0 and 255.
 * @default 240
 *
 * @param Offset
 *
 * @param OffsetX:num
 * @text Offset X
 * @parent Offset
 * @desc Offset the tooltip X position from the mouse?
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param OffsetY:num
 * @text Offset Y
 * @parent Offset
 * @desc Offset the tooltip Y position from the mouse?
 * Negative: up. Positive: down.
 * @default +0
 *
 */
//=============================================================================

const _0x2fc34f=_0x547a;(function(_0x1fe486,_0x470238){const _0x18c1a5=_0x547a,_0x16fe0a=_0x1fe486();while(!![]){try{const _0x3553a1=parseInt(_0x18c1a5(0x294))/0x1+parseInt(_0x18c1a5(0x1da))/0x2+parseInt(_0x18c1a5(0x254))/0x3*(parseInt(_0x18c1a5(0x20d))/0x4)+parseInt(_0x18c1a5(0x2d5))/0x5*(-parseInt(_0x18c1a5(0x2db))/0x6)+-parseInt(_0x18c1a5(0x1e0))/0x7*(parseInt(_0x18c1a5(0x1ae))/0x8)+-parseInt(_0x18c1a5(0x2e9))/0x9*(parseInt(_0x18c1a5(0x2c5))/0xa)+parseInt(_0x18c1a5(0x2e6))/0xb;if(_0x3553a1===_0x470238)break;else _0x16fe0a['push'](_0x16fe0a['shift']());}catch(_0x261d89){_0x16fe0a['push'](_0x16fe0a['shift']());}}}(_0x31dc,0x6e65d));var label=_0x2fc34f(0x1dc),tier=tier||0x0,dependencies=[_0x2fc34f(0x2e5),_0x2fc34f(0x1cd)],pluginData=$plugins['filter'](function(_0x5a23de){const _0x4419d8=_0x2fc34f;return _0x5a23de[_0x4419d8(0x1a7)]&&_0x5a23de[_0x4419d8(0x1cb)][_0x4419d8(0x1ff)]('['+label+']');})[0x0];VisuMZ[label][_0x2fc34f(0x1d0)]=VisuMZ[label][_0x2fc34f(0x1d0)]||{},VisuMZ[_0x2fc34f(0x1d8)]=function(_0x2b5146,_0x1938e8){const _0xe8a916=_0x2fc34f;for(const _0x1e9e1d in _0x1938e8){if(_0x1e9e1d[_0xe8a916(0x21b)](/(.*):(.*)/i)){const _0x48332e=String(RegExp['$1']),_0x11b06f=String(RegExp['$2'])['toUpperCase']()['trim']();let _0x4726ac,_0x51b459,_0x43319e;switch(_0x11b06f){case _0xe8a916(0x280):_0x4726ac=_0x1938e8[_0x1e9e1d]!==''?Number(_0x1938e8[_0x1e9e1d]):0x0;break;case _0xe8a916(0x19e):_0x51b459=_0x1938e8[_0x1e9e1d]!==''?JSON[_0xe8a916(0x2ae)](_0x1938e8[_0x1e9e1d]):[],_0x4726ac=_0x51b459['map'](_0xf52f8=>Number(_0xf52f8));break;case _0xe8a916(0x2ba):_0x4726ac=_0x1938e8[_0x1e9e1d]!==''?eval(_0x1938e8[_0x1e9e1d]):null;break;case _0xe8a916(0x2c1):_0x51b459=_0x1938e8[_0x1e9e1d]!==''?JSON['parse'](_0x1938e8[_0x1e9e1d]):[],_0x4726ac=_0x51b459[_0xe8a916(0x257)](_0x42d616=>eval(_0x42d616));break;case _0xe8a916(0x204):_0x4726ac=_0x1938e8[_0x1e9e1d]!==''?JSON[_0xe8a916(0x2ae)](_0x1938e8[_0x1e9e1d]):'';break;case _0xe8a916(0x2a8):_0x51b459=_0x1938e8[_0x1e9e1d]!==''?JSON[_0xe8a916(0x2ae)](_0x1938e8[_0x1e9e1d]):[],_0x4726ac=_0x51b459['map'](_0x52a363=>JSON[_0xe8a916(0x2ae)](_0x52a363));break;case'FUNC':_0x4726ac=_0x1938e8[_0x1e9e1d]!==''?new Function(JSON['parse'](_0x1938e8[_0x1e9e1d])):new Function(_0xe8a916(0x2d3));break;case _0xe8a916(0x1c6):_0x51b459=_0x1938e8[_0x1e9e1d]!==''?JSON[_0xe8a916(0x2ae)](_0x1938e8[_0x1e9e1d]):[],_0x4726ac=_0x51b459[_0xe8a916(0x257)](_0x4e4ea4=>new Function(JSON['parse'](_0x4e4ea4)));break;case _0xe8a916(0x258):_0x4726ac=_0x1938e8[_0x1e9e1d]!==''?String(_0x1938e8[_0x1e9e1d]):'';break;case _0xe8a916(0x277):_0x51b459=_0x1938e8[_0x1e9e1d]!==''?JSON[_0xe8a916(0x2ae)](_0x1938e8[_0x1e9e1d]):[],_0x4726ac=_0x51b459['map'](_0x4a9c5c=>String(_0x4a9c5c));break;case _0xe8a916(0x288):_0x43319e=_0x1938e8[_0x1e9e1d]!==''?JSON[_0xe8a916(0x2ae)](_0x1938e8[_0x1e9e1d]):{},_0x4726ac=VisuMZ['ConvertParams']({},_0x43319e);break;case'ARRAYSTRUCT':_0x51b459=_0x1938e8[_0x1e9e1d]!==''?JSON[_0xe8a916(0x2ae)](_0x1938e8[_0x1e9e1d]):[],_0x4726ac=_0x51b459[_0xe8a916(0x257)](_0x4cca48=>VisuMZ[_0xe8a916(0x1d8)]({},JSON['parse'](_0x4cca48)));break;default:continue;}_0x2b5146[_0x48332e]=_0x4726ac;}}return _0x2b5146;},(_0x3d04bc=>{const _0x341b74=_0x2fc34f,_0x3307f4=_0x3d04bc[_0x341b74(0x28a)];for(const _0x517160 of dependencies){if(_0x341b74(0x1ec)!==_0x341b74(0x1c8)){if(!Imported[_0x517160]){alert(_0x341b74(0x1be)['format'](_0x3307f4,_0x517160)),SceneManager['exit']();break;}}else return _0x120cea;}const _0x498230=_0x3d04bc[_0x341b74(0x1cb)];if(_0x498230['match'](/\[Version[ ](.*?)\]/i)){const _0x4049c8=Number(RegExp['$1']);if(_0x4049c8!==VisuMZ[label]['version']){if(_0x341b74(0x1bf)!==_0x341b74(0x25b))alert(_0x341b74(0x1c1)[_0x341b74(0x2a0)](_0x3307f4,_0x4049c8)),SceneManager[_0x341b74(0x2a5)]();else{const _0x749fd4=new _0x136aec(0x0,0x0,_0x2990fe['width'],_0xacc6e4['height']);_0x44ae2d[_0x341b74(0x2d1)][_0x341b74(0x1a0)][_0x341b74(0x1ca)](this,_0x749fd4),this[_0x341b74(0x24a)]['x']=this[_0x341b74(0x24a)]['y']=_0x5c2bec[_0x341b74(0x27c)],this[_0x341b74(0x2d6)](),this[_0x341b74(0x2bb)]=null;}}}if(_0x498230[_0x341b74(0x21b)](/\[Tier[ ](\d+)\]/i)){const _0x439db5=Number(RegExp['$1']);_0x439db5<tier?(alert(_0x341b74(0x2cf)[_0x341b74(0x2a0)](_0x3307f4,_0x439db5,tier)),SceneManager['exit']()):tier=Math[_0x341b74(0x1ba)](_0x439db5,tier);}VisuMZ[_0x341b74(0x1d8)](VisuMZ[label]['Settings'],_0x3d04bc[_0x341b74(0x1d3)]);})(pluginData),VisuMZ['ActiveChainSkills'][_0x2fc34f(0x2b4)]={'AvailableChainSkill':/<(?:AVAILABLE CHAIN|CHAIN) SKILL[ ](.*):[ ](.*)>/gi,'ForcedChainSkill':/<(?:ALWAYS|FORCE|FORCED) CHAIN SKILL[ ](.*):[ ](.*)>/gi,'LearnedChainSkill':/<(?:LEARNED|KNOWN) CHAIN SKILL[ ](.*):[ ](.*)>/gi,'ChainOnly':/<(?:ACTIVE CHAIN|CHAIN) ONLY>/i,'ConfirmAnimation':/<(?:CHAIN|ACTIVE CHAIN) CONFIRM (?:ANI|ANIMATION):[ ](\d+)>/i},VisuMZ[_0x2fc34f(0x1dc)][_0x2fc34f(0x25c)]=['down',_0x2fc34f(0x206),_0x2fc34f(0x1d2),'up','ok',_0x2fc34f(0x26d),_0x2fc34f(0x1ab),_0x2fc34f(0x1ed),_0x2fc34f(0x228)],VisuMZ['ActiveChainSkills']['applyKeyAlternatives']=function(_0x21394f){const _0x4d07f8=_0x2fc34f;_0x21394f=_0x21394f[_0x4d07f8(0x2dc)]()[_0x4d07f8(0x1e3)]();switch(_0x21394f){case'2':return _0x4d07f8(0x246);case'4':return'left';case'6':return'right';case'8':return'up';case's':return'shift';case'z':return'ok';case'x':return'cancel';case'q':return _0x4d07f8(0x1ab);case'w':return _0x4d07f8(0x1ed);}return _0x21394f;},DataManager['hasActiveChainSkillsConflicts']=function(_0x4eeb02){const _0x217543=_0x2fc34f;if(!_0x4eeb02)return!![];if(!DataManager[_0x217543(0x1fd)](_0x4eeb02))return!![];this[_0x217543(0x2e3)]=this[_0x217543(0x2e3)]||{};if(this[_0x217543(0x2e3)][_0x4eeb02['id']])return this[_0x217543(0x2e3)][_0x4eeb02['id']];const _0x62865c=_0x4eeb02[_0x217543(0x2b0)]||'',_0xa25892=[_0x217543(0x1a6),_0x217543(0x28f),_0x217543(0x234)];this[_0x217543(0x2e3)][_0x4eeb02['id']]=![];for(const _0x59a2f3 of _0xa25892){if('CJOzx'==='CJOzx'){if(!VisuMZ[_0x59a2f3])continue;const _0x223653=VisuMZ[_0x59a2f3][_0x217543(0x2b4)];for(const _0x5a8692 in _0x223653){if(_0x217543(0x284)!=='oJAnU')_0x66dd46[_0x217543(0x262)]=_0x133c8b,_0x183c9d['ActiveChainSkills'][_0x217543(0x19f)][_0x217543(0x1ca)](this);else{if(_0x62865c[_0x217543(0x21b)](_0x223653[_0x5a8692])){this[_0x217543(0x2e3)][_0x4eeb02['id']]=!![];break;}}}if(this[_0x217543(0x2e3)][_0x4eeb02['id']])break;}else{if(this[_0x217543(0x2bd)]!==_0x108334[_0x217543(0x1db)]())return!![];}}return this['_hasActiveChainSkillsConflict'][_0x4eeb02['id']];},DataManager[_0x2fc34f(0x253)]=function(_0x2ae9ab){const _0x7e82f=_0x2fc34f,_0x41a1b=VisuMZ[_0x7e82f(0x1dc)][_0x7e82f(0x1d0)]['Effect'][_0x7e82f(0x248)];if(!_0x2ae9ab)return _0x41a1b;const _0x287193=VisuMZ['ActiveChainSkills'][_0x7e82f(0x2b4)],_0x5005c5=_0x2ae9ab[_0x7e82f(0x2b0)]||'';if(_0x5005c5[_0x7e82f(0x21b)](_0x287193['ConfirmAnimation'])){if('MCDoq'!==_0x7e82f(0x2b9))return Number(RegExp['$1']);else{const _0x294e36=_0x245f5b[_0x7e82f(0x1dc)]['Settings']['UI'];this['x']=this[_0x7e82f(0x1df)]['x']+(_0x294e36[_0x7e82f(0x1dd)]||0x0),this['y']=this[_0x7e82f(0x1df)]['y']+(_0x294e36['KeybindUiOffsetY']||0x0),this[_0x7e82f(0x1b9)]&&(this[_0x7e82f(0x250)]=0x4),this['_pressedDuration']-->0x0&&(this['x']+=_0x5ecbdf[_0x7e82f(0x28b)],this['y']+=_0x4f5ece[_0x7e82f(0x2b5)]);}}return _0x41a1b;},Bitmap['prototype']['fillRoundRect']=function(_0x107144,_0x1acd23,_0x422dd4,_0x497e3f,_0x3b8e79,_0x4bfaa7){const _0x1f4a91=_0x2fc34f,_0x1fbeb9=_0x107144+_0x422dd4,_0x55f897=_0x1acd23+_0x497e3f,_0x4eae3c=this[_0x1f4a91(0x2a9)];_0x4eae3c[_0x1f4a91(0x2d7)](),_0x4eae3c[_0x1f4a91(0x23c)]=_0x4bfaa7,_0x4eae3c[_0x1f4a91(0x1c2)](),_0x4eae3c[_0x1f4a91(0x2c3)](_0x107144+_0x3b8e79,_0x1acd23),_0x4eae3c[_0x1f4a91(0x2a7)](_0x1fbeb9-_0x3b8e79,_0x1acd23),_0x4eae3c[_0x1f4a91(0x208)](_0x1fbeb9,_0x1acd23,_0x1fbeb9,_0x1acd23+_0x3b8e79),_0x4eae3c[_0x1f4a91(0x2a7)](_0x1fbeb9,_0x1acd23+_0x497e3f-_0x3b8e79),_0x4eae3c[_0x1f4a91(0x208)](_0x1fbeb9,_0x55f897,_0x1fbeb9-_0x3b8e79,_0x55f897),_0x4eae3c[_0x1f4a91(0x2a7)](_0x107144+_0x3b8e79,_0x55f897),_0x4eae3c[_0x1f4a91(0x208)](_0x107144,_0x55f897,_0x107144,_0x55f897-_0x3b8e79),_0x4eae3c['lineTo'](_0x107144,_0x1acd23+_0x3b8e79),_0x4eae3c['quadraticCurveTo'](_0x107144,_0x1acd23,_0x107144+_0x3b8e79,_0x1acd23),_0x4eae3c[_0x1f4a91(0x20e)](),_0x4eae3c[_0x1f4a91(0x1e1)](),this['_baseTexture'][_0x1f4a91(0x1e2)]();},SoundManager[_0x2fc34f(0x231)]=function(){const _0x51cdd3=_0x2fc34f,_0x39c471=VisuMZ[_0x51cdd3(0x1dc)][_0x51cdd3(0x1d0)][_0x51cdd3(0x1f5)],_0x21487c={'name':_0x39c471['name'],'volume':_0x39c471[_0x51cdd3(0x2da)],'pitch':_0x39c471[_0x51cdd3(0x261)],'pan':_0x39c471[_0x51cdd3(0x276)]};AudioManager['playSe'](_0x21487c);},Game_Temp[_0x2fc34f(0x2d1)][_0x2fc34f(0x24d)]=function(){const _0x373cb5=_0x2fc34f;this[_0x373cb5(0x2c2)]=undefined,this['_activeChainSkillSelected']=undefined;},Game_Temp[_0x2fc34f(0x2d1)][_0x2fc34f(0x275)]=function(){const _0x222b7c=_0x2fc34f;if(!BattleManager[_0x222b7c(0x19d)])return![];if(!BattleManager[_0x222b7c(0x19d)][_0x222b7c(0x1c0)]())return![];if(!BattleManager['_subject']['isAlive']())return![];if(BattleManager[_0x222b7c(0x19d)][_0x222b7c(0x2d8)]())return![];if(BattleManager['isInputting']())return![];if(BattleManager[_0x222b7c(0x1b7)])return![];if($gameTroop['aliveMembers']()['length']<=0x0)return![];if($gameMessage[_0x222b7c(0x295)]())return![];return this[_0x222b7c(0x2c2)]!==undefined;},Game_Temp[_0x2fc34f(0x2d1)][_0x2fc34f(0x24f)]=function(_0x2f56a4,_0x5e8ba6){const _0x46882b=_0x2fc34f;if(_0x5e8ba6<=0x0)return;this[_0x46882b(0x2c2)]=this[_0x46882b(0x2c2)]||{},this['_activeChainSkillKeys'][_0x2f56a4]=_0x5e8ba6,this[_0x46882b(0x1a9)]=null;},Game_Temp['prototype'][_0x2fc34f(0x242)]=function(_0x4401d2){const _0x661322=_0x2fc34f;if(!this[_0x661322(0x2c2)])return null;return this[_0x661322(0x2c2)][_0x4401d2];},Game_Temp['prototype'][_0x2fc34f(0x282)]=function(_0x239c18){const _0x3d5acc=_0x2fc34f;return!!this[_0x3d5acc(0x242)](_0x239c18);},Game_Temp[_0x2fc34f(0x2d1)]['setActiveChainSkillSelected']=function(_0x29c9e8){const _0x3a93be=_0x2fc34f;this[_0x3a93be(0x1a9)]=_0x29c9e8['id'];},Game_Temp[_0x2fc34f(0x2d1)]['getActiveChainSkillSelected']=function(){return this['_activeChainSkillSelected'];},Game_Temp[_0x2fc34f(0x2d1)][_0x2fc34f(0x2d0)]=function(){const _0x33d736=_0x2fc34f,_0x39a289=VisuMZ[_0x33d736(0x1dc)][_0x33d736(0x1d0)][_0x33d736(0x274)];if(_0x39a289>0x0)$gameSwitches[_0x33d736(0x236)](_0x39a289,![]);},Game_Temp[_0x2fc34f(0x2d1)][_0x2fc34f(0x1c3)]=function(){const _0x244b48=_0x2fc34f,_0x3a14db=VisuMZ[_0x244b48(0x1dc)][_0x244b48(0x1d0)][_0x244b48(0x274)];if(_0x3a14db>0x0)$gameSwitches[_0x244b48(0x236)](_0x3a14db,!![]);},VisuMZ['ActiveChainSkills'][_0x2fc34f(0x2d2)]=Game_Action[_0x2fc34f(0x2d1)][_0x2fc34f(0x1d4)],Game_Action[_0x2fc34f(0x2d1)][_0x2fc34f(0x1d4)]=function(){const _0x1fdfb5=_0x2fc34f;VisuMZ['ActiveChainSkills']['Game_Action_applyGlobal'][_0x1fdfb5(0x1ca)](this),this[_0x1fdfb5(0x29f)]();},Game_Action[_0x2fc34f(0x2d1)]['applyActiveChainSkills']=function(){const _0x2663b4=_0x2fc34f;$gameTemp['clearActiveChainSkills'](),$gameTemp[_0x2663b4(0x2d0)]();if(this[_0x2663b4(0x2c6)]())return;this[_0x2663b4(0x25a)](_0x2663b4(0x222)),this['processActiveChainSkillKeyBinds'](_0x2663b4(0x244)),this['processActiveChainSkillKeyBinds'](_0x2663b4(0x266)),this['subject']()[_0x2663b4(0x2bc)]()&&this[_0x2663b4(0x243)]();},Game_Action[_0x2fc34f(0x2d1)][_0x2fc34f(0x2c6)]=function(){const _0x4fa0b5=_0x2fc34f;if(!this[_0x4fa0b5(0x1ac)]())return!![];if(!this[_0x4fa0b5(0x1fd)]())return!![];if(!this[_0x4fa0b5(0x29d)]())return!![];if(!this[_0x4fa0b5(0x29d)]()['isActor']())return!![];if(DataManager['hasActiveChainSkillsConflicts'](this[_0x4fa0b5(0x1ac)]()))return!![];if(Imported[_0x4fa0b5(0x296)]&&BattleManager[_0x4fa0b5(0x239)]())return!![];return![];},Game_Action[_0x2fc34f(0x2d1)][_0x2fc34f(0x25a)]=function(_0x5737e7){const _0x2853e7=_0x2fc34f,_0x280b7c=this['subject'](),_0x493fc2=VisuMZ[_0x2853e7(0x1dc)][_0x2853e7(0x25c)]['clone'](),_0x6cc428=VisuMZ[_0x2853e7(0x1dc)][_0x2853e7(0x2b4)],_0x2618cb=this['item']()[_0x2853e7(0x2b0)]||'',_0x5c234c=_0x2618cb[_0x2853e7(0x21b)](_0x6cc428[_0x5737e7]);if(_0x5c234c)for(const _0x581a12 of _0x5c234c){_0x581a12['match'](_0x6cc428[_0x5737e7]);let _0x200e1e=String(RegExp['$1'])[_0x2853e7(0x2dc)]()[_0x2853e7(0x1e3)]();const _0x354a7d=String(RegExp['$2']);_0x200e1e=VisuMZ['ActiveChainSkills'][_0x2853e7(0x24b)](_0x200e1e);if(!_0x493fc2['includes'](_0x200e1e))continue;const _0x28d6e4=/^\d+$/[_0x2853e7(0x229)](_0x354a7d);let _0x53bccc=0x0;if(_0x28d6e4){if(_0x2853e7(0x1b6)!==_0x2853e7(0x2b6))_0x53bccc=Number(_0x354a7d);else{if(_0x1143af[_0x2853e7(0x2de)]&&this[_0x2853e7(0x20c)]){if(this[_0x2853e7(0x20c)][_0x2853e7(0x19c)])return;}_0x3ed020[_0x2853e7(0x1dc)][_0x2853e7(0x2c7)][_0x2853e7(0x1ca)](this);}}else _0x2853e7(0x2ab)===_0x2853e7(0x26a)?this[_0x2853e7(0x2d6)]():_0x53bccc=DataManager[_0x2853e7(0x1f9)](_0x354a7d);if(_0x53bccc<=0x0)continue;if(_0x5737e7==='AvailableChainSkill'&&!_0x280b7c[_0x2853e7(0x29c)](_0x53bccc))continue;if(_0x5737e7===_0x2853e7(0x266)&&!_0x280b7c[_0x2853e7(0x1d1)](_0x53bccc))continue;$gameTemp[_0x2853e7(0x24f)](_0x200e1e,_0x53bccc);}},Game_Action[_0x2fc34f(0x2d1)]['setAutoBattleActiveChainSkill']=function(){const _0x1c1c0c=_0x2fc34f,_0x5627e6=VisuMZ['ActiveChainSkills'][_0x1c1c0c(0x25c)][_0x1c1c0c(0x1f4)](),_0x4b6021=_0x5627e6[_0x1c1c0c(0x257)](_0x102783=>$gameTemp['getActiveChainSkillsKey'](_0x102783))[_0x1c1c0c(0x265)](null)[_0x1c1c0c(0x257)](_0x38981e=>$dataSkills[_0x38981e])['filter'](_0x2ddd4b=>this[_0x1c1c0c(0x29d)]()[_0x1c1c0c(0x1d9)](_0x2ddd4b));if(_0x4b6021[_0x1c1c0c(0x26c)]<=0x0)return;const _0x3b2d66=_0x4b6021[Math[_0x1c1c0c(0x21d)](_0x4b6021[_0x1c1c0c(0x26c)])];this[_0x1c1c0c(0x29d)]()['queueActiveChainSkill'](_0x3b2d66);},VisuMZ[_0x2fc34f(0x1dc)][_0x2fc34f(0x1bc)]=Game_BattlerBase[_0x2fc34f(0x2d1)][_0x2fc34f(0x212)],Game_BattlerBase[_0x2fc34f(0x2d1)][_0x2fc34f(0x212)]=function(_0x4326b0){const _0x27d6ff=_0x2fc34f;if(!this[_0x27d6ff(0x217)](_0x4326b0))return![];return VisuMZ[_0x27d6ff(0x1dc)]['Game_BattlerBase_meetsSkillConditions'][_0x27d6ff(0x1ca)](this,_0x4326b0);},Game_BattlerBase[_0x2fc34f(0x2d1)][_0x2fc34f(0x217)]=function(_0x1633b0){const _0x40f1d7=_0x2fc34f;if(!_0x1633b0)return![];const _0x4a7272=VisuMZ[_0x40f1d7(0x1dc)][_0x40f1d7(0x2b4)],_0x3ec5e2=_0x1633b0[_0x40f1d7(0x2b0)]||'';if(_0x3ec5e2['match'](_0x4a7272['ChainOnly'])){if(!this['isActor']())return![];if(!SceneManager[_0x40f1d7(0x22e)]())return![];if(!$gameTemp[_0x40f1d7(0x275)]())return![];}return!![];},Game_Actor['prototype'][_0x2fc34f(0x2ce)]=function(_0x290a17){const _0x32019a=_0x2fc34f;this[_0x32019a(0x1d5)](_0x290a17),this['playActiveChainSkillEffects'](_0x290a17),$gameTemp[_0x32019a(0x24c)](_0x290a17),$gameTemp[_0x32019a(0x1c3)](),Sprite_Actor['ACTIVE_CHAIN_REDUCE_BACK_FORTH']&&('NDRJL'==='NDRJL'?(this[_0x32019a(0x1d7)]=!![],this[_0x32019a(0x19c)]=!![]):(_0x1422ae(_0x32019a(0x1c1)[_0x32019a(0x2a0)](_0x59bd26,_0x41b2fb)),_0x4d52eb[_0x32019a(0x2a5)]())),SoundManager[_0x32019a(0x231)]();},Game_Actor[_0x2fc34f(0x2d1)]['queueActiveChainSkillForceAction']=function(_0x3f046b){const _0x47cfb1=_0x2fc34f,_0x3f0c7d=BattleManager[_0x47cfb1(0x1f6)][0x0],_0x1b984d=$gameTroop['members']()[_0x47cfb1(0x202)](_0x3f0c7d);this[_0x47cfb1(0x2e4)](_0x3f046b['id'],_0x1b984d),BattleManager[_0x47cfb1(0x2e4)](this);},Game_Actor[_0x2fc34f(0x2d1)][_0x2fc34f(0x2af)]=function(_0x284fce){const _0x65ab2e=_0x2fc34f,_0x4ac71d=VisuMZ[_0x65ab2e(0x1dc)][_0x65ab2e(0x1d0)]['Effect'];if(Imported[_0x65ab2e(0x1e5)]){if(_0x65ab2e(0x20b)!==_0x65ab2e(0x20b)){_0x137a4c['clearActiveChainSkills'](),_0x4c0415[_0x65ab2e(0x2d0)]();if(this[_0x65ab2e(0x2c6)]())return;this[_0x65ab2e(0x25a)](_0x65ab2e(0x222)),this[_0x65ab2e(0x25a)](_0x65ab2e(0x244)),this[_0x65ab2e(0x25a)](_0x65ab2e(0x266)),this[_0x65ab2e(0x29d)]()[_0x65ab2e(0x2bc)]()&&this[_0x65ab2e(0x243)]();}else{const _0x7d83ff=[this],_0x49e6ff=DataManager['getActiveChainSkillAnimation'](_0x284fce),_0x416355=_0x4ac71d[_0x65ab2e(0x221)],_0x48fbfe=_0x4ac71d[_0x65ab2e(0x27e)];$gameTemp[_0x65ab2e(0x26f)](_0x7d83ff,_0x49e6ff,_0x416355,_0x48fbfe);}}if(_0x4ac71d[_0x65ab2e(0x267)]!==''){const _0xb23765={'textColor':_0x4ac71d[_0x65ab2e(0x2e1)],'flashColor':_0x4ac71d[_0x65ab2e(0x1fe)],'flashDuration':_0x4ac71d[_0x65ab2e(0x29e)]};this[_0x65ab2e(0x225)](_0x4ac71d[_0x65ab2e(0x267)],_0xb23765);}},VisuMZ['ActiveChainSkills'][_0x2fc34f(0x268)]=Scene_Battle[_0x2fc34f(0x2d1)][_0x2fc34f(0x1e9)],Scene_Battle['prototype'][_0x2fc34f(0x1e9)]=function(){const _0x18e28b=_0x2fc34f;VisuMZ[_0x18e28b(0x1dc)][_0x18e28b(0x268)][_0x18e28b(0x1ca)](this),this[_0x18e28b(0x2b3)]();},Scene_Battle[_0x2fc34f(0x2d1)][_0x2fc34f(0x2b3)]=function(){const _0x44aeed=_0x2fc34f;this['createActiveChainSkillUiContainer'](),this['createActiveChainSkillUiBackground'](),this[_0x44aeed(0x1e4)](),this[_0x44aeed(0x24e)](),this[_0x44aeed(0x1ce)]();},Scene_Battle[_0x2fc34f(0x2d1)][_0x2fc34f(0x224)]=function(){const _0xa9f3ca=_0x2fc34f;this[_0xa9f3ca(0x1bb)]=new Sprite(),this['addChild'](this[_0xa9f3ca(0x1bb)]),this[_0xa9f3ca(0x1bb)][_0xa9f3ca(0x299)]=0x0;},Scene_Battle['prototype']['createActiveChainSkillUiBackground']=function(){const _0x27b0c7=_0x2fc34f,_0x57c297=VisuMZ['ActiveChainSkills'][_0x27b0c7(0x1d0)]['UI'];if(_0x57c297[_0x27b0c7(0x2a4)]){if(_0x27b0c7(0x21c)!==_0x27b0c7(0x21c)){const _0x4d8375=new _0x301f15();this[_0x27b0c7(0x1bb)][_0x27b0c7(0x251)](_0x4d8375);const _0x14fe0e=new _0x2e2b41(_0x3501aa['width'],_0x57e314[_0x27b0c7(0x241)]);_0x4d8375[_0x27b0c7(0x1e7)]=_0x14fe0e;const _0x9134e3=_0xd71126['backgroundDrawJS'];_0x9134e3[_0x27b0c7(0x1ca)](_0x4d8375[_0x27b0c7(0x1e7)]);}else{const _0x3bea6b=new Sprite();this['_activeChainSkillUiContainer'][_0x27b0c7(0x251)](_0x3bea6b);const _0x2accec=new Bitmap(Graphics[_0x27b0c7(0x286)],Graphics[_0x27b0c7(0x241)]);_0x3bea6b[_0x27b0c7(0x1e7)]=_0x2accec;const _0xdd0a08=_0x57c297[_0x27b0c7(0x2a4)];_0xdd0a08['call'](_0x3bea6b[_0x27b0c7(0x1e7)]);}}if(_0x57c297[_0x27b0c7(0x2c9)]!==''){if(_0x27b0c7(0x21a)!==_0x27b0c7(0x21a)){const _0x5df984='VisuStella\x20MZ\x20Auto\x20Skill\x20Triggers\x20needs\x20to\x20be\x20updated!';_0xbe937e(_0x5df984),_0x177240['exit']();}else{const _0x116708=new Sprite();this[_0x27b0c7(0x1bb)]['addChild'](_0x116708);const _0x3362db=ImageManager[_0x27b0c7(0x2a6)](_0x57c297[_0x27b0c7(0x2c9)]);_0x116708['bitmap']=_0x3362db;}}},Scene_Battle[_0x2fc34f(0x2d1)][_0x2fc34f(0x1e4)]=function(){const _0x2f5a78=_0x2fc34f;this[_0x2f5a78(0x1ad)]={};const _0x3df978=VisuMZ[_0x2f5a78(0x1dc)][_0x2f5a78(0x25c)]['clone']();for(const _0x1ba861 of _0x3df978){const _0x4f3a1d=new Sprite_ActiveChainButton(_0x1ba861);this[_0x2f5a78(0x1bb)][_0x2f5a78(0x251)](_0x4f3a1d),this[_0x2f5a78(0x1ad)][_0x1ba861]=_0x4f3a1d;}},Scene_Battle[_0x2fc34f(0x2d1)][_0x2fc34f(0x24e)]=function(){const _0x5243ad=_0x2fc34f;if(!Imported['VisuMZ_1_MessageCore'])return;if(!Window_ActiveChainSkillsTooltip[_0x5243ad(0x1a3)])return;this['_activeChainSkillsUiTooltipWindow']=new Window_ActiveChainSkillsTooltip(),this['addChild'](this[_0x5243ad(0x1f1)]);},Scene_Battle[_0x2fc34f(0x2d1)][_0x2fc34f(0x1ce)]=function(){const _0x209c07=_0x2fc34f;if(Imported[_0x209c07(0x1b0)]&&VisuMZ['AutoSkillTriggers'][_0x209c07(0x2e7)]<1.12){const _0x404555=_0x209c07(0x23a);alert(_0x404555),SceneManager['exit']();}},VisuMZ[_0x2fc34f(0x1dc)]['Scene_Battle_update']=Scene_Battle[_0x2fc34f(0x2d1)][_0x2fc34f(0x1e2)],Scene_Battle[_0x2fc34f(0x2d1)][_0x2fc34f(0x1e2)]=function(){const _0x396f08=_0x2fc34f;VisuMZ[_0x396f08(0x1dc)][_0x396f08(0x25e)]['call'](this);if(this['canPerformActiveChainSkills']())this['updateActiveChainSkills']();this['updateActiveChainSkillsUiOpacity']();},Scene_Battle[_0x2fc34f(0x2d1)][_0x2fc34f(0x2cd)]=function(){const _0x1533a8=_0x2fc34f;if($gameTemp[_0x1533a8(0x262)])return![];return $gameTemp[_0x1533a8(0x275)]()&&$gameTemp[_0x1533a8(0x1b2)]()===null;},Scene_Battle[_0x2fc34f(0x2d1)]['updateActiveChainSkills']=function(){const _0x5ac9d1=_0x2fc34f,_0x2dba0b=BattleManager[_0x5ac9d1(0x19d)],_0x1cd69a=VisuMZ['ActiveChainSkills'][_0x5ac9d1(0x25c)]['clone']();for(const _0x3d8fbb of _0x1cd69a){if(!$gameTemp[_0x5ac9d1(0x282)](_0x3d8fbb))continue;const _0xda4c5f=$dataSkills[$gameTemp['getActiveChainSkillsKey'](_0x3d8fbb)];if(!_0xda4c5f)continue;if(!_0x2dba0b['canUse'](_0xda4c5f))continue;if(!Input[_0x5ac9d1(0x227)](_0x3d8fbb))continue;this['_activeChainSkillButtons'][_0x3d8fbb]['_pressedDuration']=0x4,_0x2dba0b[_0x5ac9d1(0x2ce)](_0xda4c5f);break;}},Scene_Battle[_0x2fc34f(0x2d1)]['isActiveChainSkillsUiVisible']=function(){const _0x4facf8=_0x2fc34f;return $gameTemp[_0x4facf8(0x275)]()&&$gameTemp[_0x4facf8(0x1a9)]!==undefined;},Scene_Battle[_0x2fc34f(0x2d1)][_0x2fc34f(0x252)]=function(){const _0x6b8375=_0x2fc34f,_0xfd064c=VisuMZ['ActiveChainSkills']['Settings']['UI'],_0x4c699f=this[_0x6b8375(0x220)]();if(this[_0x6b8375(0x1bb)]){const _0x171916=_0xfd064c[_0x6b8375(0x292)]*(_0x4c699f?0x1:-0x1);this[_0x6b8375(0x1bb)][_0x6b8375(0x299)]+=_0x171916;}},VisuMZ['ActiveChainSkills'][_0x2fc34f(0x19f)]=BattleManager['startAction'],BattleManager[_0x2fc34f(0x23d)]=function(){const _0x1696b0=_0x2fc34f;$gameTemp[_0x1696b0(0x262)]=undefined,VisuMZ[_0x1696b0(0x1dc)][_0x1696b0(0x19f)][_0x1696b0(0x1ca)](this);},VisuMZ[_0x2fc34f(0x1dc)][_0x2fc34f(0x209)]=Game_Battler[_0x2fc34f(0x2d1)]['performActionEnd'],Game_Battler[_0x2fc34f(0x2d1)]['performActionEnd']=function(){const _0x385c92=_0x2fc34f;$gameTemp[_0x385c92(0x262)]=!![],VisuMZ[_0x385c92(0x1dc)][_0x385c92(0x209)][_0x385c92(0x1ca)](this);},VisuMZ['ActiveChainSkills'][_0x2fc34f(0x22c)]=Window_BattleLog['prototype'][_0x2fc34f(0x1f7)],Window_BattleLog['prototype'][_0x2fc34f(0x1f7)]=function(_0x2c3226){const _0x3707d1=_0x2fc34f;$gameTemp[_0x3707d1(0x262)]=!![],VisuMZ[_0x3707d1(0x1dc)][_0x3707d1(0x22c)][_0x3707d1(0x1ca)](this,_0x2c3226);},Sprite_Actor[_0x2fc34f(0x2de)]=VisuMZ[_0x2fc34f(0x1dc)][_0x2fc34f(0x1d0)][_0x2fc34f(0x1de)]??!![],VisuMZ[_0x2fc34f(0x1dc)][_0x2fc34f(0x2ad)]=Sprite_Actor[_0x2fc34f(0x2d1)][_0x2fc34f(0x291)],Sprite_Actor[_0x2fc34f(0x2d1)][_0x2fc34f(0x291)]=function(){const _0x4f7f01=_0x2fc34f;if(Sprite_Actor['ACTIVE_CHAIN_REDUCE_BACK_FORTH']&&this['_battler']){if(this['_battler'][_0x4f7f01(0x1d7)]){if(_0x4f7f01(0x28c)!==_0x4f7f01(0x29a))return;else this[_0x4f7f01(0x2d6)]();}}VisuMZ[_0x4f7f01(0x1dc)][_0x4f7f01(0x2ad)][_0x4f7f01(0x1ca)](this);},VisuMZ['ActiveChainSkills'][_0x2fc34f(0x2c7)]=Sprite_Actor[_0x2fc34f(0x2d1)][_0x2fc34f(0x210)],Sprite_Actor[_0x2fc34f(0x2d1)][_0x2fc34f(0x210)]=function(){const _0x4f403d=_0x2fc34f;if(Sprite_Actor[_0x4f403d(0x2de)]&&this[_0x4f403d(0x20c)]){if(_0x4f403d(0x200)===_0x4f403d(0x278))this['x']+=_0x309a45['KEY_PRESS_OFFSET_X'],this['y']+=_0x5e0b8d[_0x4f403d(0x2b5)];else{if(this[_0x4f403d(0x20c)][_0x4f403d(0x19c)])return;}}VisuMZ[_0x4f403d(0x1dc)]['Sprite_Actor_stepBack'][_0x4f403d(0x1ca)](this);},VisuMZ[_0x2fc34f(0x1dc)][_0x2fc34f(0x259)]=BattleManager[_0x2fc34f(0x22d)],BattleManager['endAction']=function(){const _0x3c51a0=_0x2fc34f;if(Sprite_Actor[_0x3c51a0(0x2de)]&&this[_0x3c51a0(0x19d)]&&this['_subject'][_0x3c51a0(0x1c0)]()){if(_0x3c51a0(0x2dd)===_0x3c51a0(0x2dd))this[_0x3c51a0(0x19d)]['_bypassStepForward_ActiveChainSkill']=this[_0x3c51a0(0x19d)][_0x3c51a0(0x19c)],this[_0x3c51a0(0x19d)][_0x3c51a0(0x19c)]=![];else{const _0x33fc49=this[_0x3c51a0(0x271)](this['_text']);this[_0x3c51a0(0x286)]=_0x33fc49['width']+(this[_0x3c51a0(0x21e)]()+this[_0x3c51a0(0x1f3)])*0x2,this['height']=_0x33fc49[_0x3c51a0(0x241)]+this['padding']*0x2,this['createContents'](),this['resetFontSettings']();}}VisuMZ[_0x3c51a0(0x1dc)][_0x3c51a0(0x259)][_0x3c51a0(0x1ca)](this);};function _0x31dc(){const _0x339a54=['constructor','OffsetY','InputComboSkills','status','WINDOW_SKIN_OPACITY','_activeChainSkillSelected','refresh','pageup','item','_activeChainSkillButtons','55952YcigFY','setupText','VisuMZ_3_AutoSkillTriggers','isBeingTouched','getActiveChainSkillSelected','waitForMovement','Tooltip','setupDescriptionText','BBqsP','_victoryPhase','tooltipWindow','_pressed','max','_activeChainSkillUiContainer','Game_BattlerBase_meetsSkillConditions','contents','%1\x20is\x20missing\x20a\x20required\x20plugin.\x0aPlease\x20install\x20%2\x20into\x20the\x20Plugin\x20Manager.','OlkbG','isActor','%1\x27s\x20version\x20does\x20not\x20match\x20plugin\x27s.\x20Please\x20update\x20it\x20in\x20the\x20Plugin\x20Manager.','beginPath','activateActiveChainConfirmSwitch','windowskin','onMouseExit','ARRAYFUNC','updateBitmap','HcYMJ','walk','call','description','createContents','VisuMZ_1_SkillsStatesCore','checkActiveChainSkillIncompatibility','_context','Settings','isLearnedSkill','right','parameters','applyGlobal','queueActiveChainSkillForceAction','KeybindUiOffsetY','_bypassStepForward_ActiveChainSkill','ConvertParams','canUse','911414RGkmyg','getLastUsedGamepadType','ActiveChainSkills','KeybindUiOffsetX','ReduceBackForth','_dimensions','714oSWHTx','restore','update','trim','createActiveChainSkillUiButtons','VisuMZ_0_CoreEngine','imageSmoothingEnabled','bitmap','IconSet','createDisplayObjects','_key','resizeWindow','LoPVS','pagedown','updateBackOpacity','_text','createAllSkillCostText','_activeChainSkillsUiTooltipWindow','Linear','padding','clone','Sound','_targets','performActionEnd','baseTextRect','getSkillIdWithName','%1RectJS','performMoveToPoint','WindowOpacity','isSkill','FlashColor','includes','ZzgnQ','OffsetX','indexOf','onClick','JSON','clampPosition','left','battler','quadraticCurveTo','Game_Battler_performActionEnd','fillRect','eLLXi','_battler','1003924VeNwGM','fill','worldTransform','stepBack','performJump','meetsSkillConditions','onMouseEnter','setSkill','isActiveChainSkillQueued','convertMessageKeywords','meetsActiveChainSkillConditions','LargeIconSmoothing','createContentSprite','uVLvD','match','LxXrk','randomInt','itemPadding','applyInverse','isActiveChainSkillsUiVisible','Mirror','AvailableChainSkill','_requestRefresh','createActiveChainSkillUiContainer','setupTextPopup','_scene','isTriggered','shift','test','_lastSkillID','isSupportMessageKeywords','Window_BattleLog_performActionEnd','endAction','isSceneBattle','WINDOW_SKIN_FILENAME','isAlive','playActiveChainSkillsRegister','windowPadding','KeypressUiOffsetX','QuirkFusionSkills','hFqSr','setValue','Scale','debugFillRect','isBTB','VisuStella\x20MZ\x20Auto\x20Skill\x20Triggers\x20needs\x20to\x20be\x20updated!','refreshBitmap','fillStyle','startAction','initMembers','Tjksr','opacityLevel','height','getActiveChainSkillsKey','setAutoBattleActiveChainSkill','ForcedChainSkill','MOUSE_OFFSET_Y','down','addMeleeReturnActionSet','AnimationID','visible','scale','applyKeyAlternatives','setActiveChainSkillSelected','clearActiveChainSkills','createActiveChainSkillsUiTooltipWindow','setActiveChainSkill','_pressedDuration','addChild','updateActiveChainSkillsUiOpacity','getActiveChainSkillAnimation','9vayIcl','blt','setPerformActionEnd','map','STR','BattleManager_endAction','processActiveChainSkillKeyBinds','HlAZA','Keys','updatePosition','Scene_Battle_update','BSzBX','requestRefresh','pitch','_performActionEnd','Window_BattleLog_addMeleeReturnActionSet','requestMotionActiveChain','remove','LearnedChainSkill','PopupText','Scene_Battle_createDisplayObjects','WindowSkin','fVGkd','push','length','cancel','callNextMethod','requestFauxAnimation','enabled','textSizeEx','_homeY','evade','ConfirmSwitch','canActiveChainSkill','pan','ARRAYSTR','qUzRq','performMoveToPointActiveChain','getButtonIcon','_hovered','WINDOW_SCALE','clamp','Mute','ecDLy','NUM','show','hasActiveChainSkillsKey','aliveMembers','oJAnU','resetFontSettings','width','updateOpacity','STRUCT','_hoverState','name','KEY_PRESS_OFFSET_X','epqNW','createContentWindow','NhCtk','EvoMatrixSkills','contentDrawJS','stepForward','OpacityRate','requestMotion','598177WQxalx','isBusy','VisuMZ_2_BattleSystemBTB','_contentWindow','KeypressUiOffsetY','opacity','UprUq','addActiveChainMeleeReturnActionSet','hasSkill','subject','FlashDuration','applyActiveChainSkills','format','clear','performJumpActiveChain','waitForMovementActiveChain','backgroundDrawJS','exit','loadSystem','lineTo','ARRAYJSON','context','dvNuR','jekaJ','drawTextEx','Sprite_Actor_stepForward','parse','playActiveChainSkillEffects','note','round','isReleased','createActiveChainSkillUiElements','RegExp','KEY_PRESS_OFFSET_Y','fdyub','_homeX','MOUSE_OFFSET_X','SItmQ','EVAL','_skill','isAutoBattle','_lastInputType','createBackgroundSprite','iconHeight','create','ARRAYEVAL','_activeChainSkillKeys','moveTo','hitTest','193930DLuQhe','willConflictActiveChainSkills','Sprite_Actor_stepBack','emKmQ','BackgroundImage','meetsUpdateBitmapConditions','getInputButtonString','floor','canPerformActiveChainSkills','queueActiveChainSkill','%1\x20is\x20incorrectly\x20placed\x20on\x20the\x20plugin\x20list.\x0aIt\x20is\x20a\x20Tier\x20%2\x20plugin\x20placed\x20over\x20other\x20Tier\x20%3\x20plugins.\x0aPlease\x20reorder\x20the\x20plugin\x20list\x20from\x20smallest\x20to\x20largest\x20tier\x20numbers.','clearActiveChainConfirmSwitch','prototype','Game_Action_applyGlobal','return\x200','anchor','1790sBExQH','hide','save','isRestricted','red','volume','9048ONiqus','toLowerCase','JdngG','ACTIVE_CHAIN_REDUCE_BACK_FORTH','eQqLo','_lastActor','TextColor','dimColor2','_hasActiveChainSkillsConflict','forceAction','VisuMZ_1_BattleCore','5497767qFwvCY','version','fstNN','279OPhijC','_bypassStepBackward_ActiveChainSkill','_subject','ARRAYNUM','BattleManager_startAction','initialize','_contentSprite','processTouch','ENABLED'];_0x31dc=function(){return _0x339a54;};return _0x31dc();}function _0x547a(_0x1f781d,_0x11b1be){const _0x31dcc7=_0x31dc();return _0x547a=function(_0x547afa,_0x2e0bf6){_0x547afa=_0x547afa-0x19c;let _0xc4e0a4=_0x31dcc7[_0x547afa];return _0xc4e0a4;},_0x547a(_0x1f781d,_0x11b1be);}function Sprite_ActiveChainButton(){this['initialize'](...arguments);}Sprite_ActiveChainButton[_0x2fc34f(0x2d1)]=Object[_0x2fc34f(0x2c0)](Sprite_Clickable[_0x2fc34f(0x2d1)]),Sprite_ActiveChainButton['prototype']['constructor']=Sprite_ActiveChainButton,Sprite_ActiveChainButton[_0x2fc34f(0x28b)]=VisuMZ[_0x2fc34f(0x1dc)][_0x2fc34f(0x1d0)]['UI'][_0x2fc34f(0x233)]??-0x4,Sprite_ActiveChainButton['KEY_PRESS_OFFSET_Y']=VisuMZ[_0x2fc34f(0x1dc)]['Settings']['UI'][_0x2fc34f(0x298)]??+0x4,Sprite_ActiveChainButton['prototype'][_0x2fc34f(0x1a0)]=function(_0x589e19){const _0x297425=_0x2fc34f;this[_0x297425(0x1ea)]=_0x589e19,Sprite_Clickable[_0x297425(0x2d1)]['initialize'][_0x297425(0x1ca)](this),this[_0x297425(0x23e)](),this[_0x297425(0x238)](),this[_0x297425(0x2be)](),this['createContentSprite'](),this[_0x297425(0x28d)]();},Sprite_ActiveChainButton[_0x2fc34f(0x2d1)]['initMembers']=function(){const _0x53b3de=_0x2fc34f,_0x28d4f9=VisuMZ[_0x53b3de(0x1dc)][_0x53b3de(0x1d0)]['UI'],_0xb71aa4=_0x53b3de(0x1fa)[_0x53b3de(0x2a0)](this[_0x53b3de(0x1ea)]);_0x28d4f9[_0xb71aa4]?this[_0x53b3de(0x1df)]=_0x28d4f9[_0xb71aa4]():this[_0x53b3de(0x1df)]=new Rectangle(0x0,0x0,0x0,0x0),this['x']=this[_0x53b3de(0x1df)]['x']+(_0x28d4f9[_0x53b3de(0x1dd)]||0x0),this['y']=this['_dimensions']['y']+(_0x28d4f9['KeybindUiOffsetY']||0x0),this['anchor']['x']=0.5,this[_0x53b3de(0x2d4)]['y']=0.5,this[_0x53b3de(0x24a)]['x']=_0x28d4f9['Scale'],this[_0x53b3de(0x24a)]['y']=_0x28d4f9[_0x53b3de(0x237)],this[_0x53b3de(0x299)]=0x0,this[_0x53b3de(0x2e0)]=null,this[_0x53b3de(0x22a)]=null,this[_0x53b3de(0x2bd)]=null;},Sprite_ActiveChainButton['prototype'][_0x2fc34f(0x238)]=function(){const _0x42ae9b=_0x2fc34f,_0x1cd2cc=![],_0x4ad759=_0x1cd2cc?_0x42ae9b(0x2d9):ColorManager[_0x42ae9b(0x2e2)]();this[_0x42ae9b(0x1e7)]=new Bitmap(this[_0x42ae9b(0x1df)][_0x42ae9b(0x286)],this[_0x42ae9b(0x1df)][_0x42ae9b(0x241)]),this[_0x42ae9b(0x1e7)][_0x42ae9b(0x20a)](0x0,0x0,this[_0x42ae9b(0x1e7)][_0x42ae9b(0x286)],this[_0x42ae9b(0x1e7)]['height'],_0x4ad759);},Sprite_ActiveChainButton[_0x2fc34f(0x2d1)]['createBackgroundSprite']=function(){const _0x553eca=_0x2fc34f,_0x188e11=VisuMZ['ActiveChainSkills']['Settings']['UI'],_0x1ed522=_0x188e11['%1BackgroundImage'[_0x553eca(0x2a0)](this[_0x553eca(0x1ea)])];if(!_0x1ed522)return;const _0x56c00d=new Sprite();this[_0x553eca(0x251)](_0x56c00d),_0x56c00d[_0x553eca(0x1e7)]=ImageManager[_0x553eca(0x2a6)](_0x1ed522),_0x56c00d[_0x553eca(0x2d4)]['x']=0.5,_0x56c00d[_0x553eca(0x2d4)]['y']=0.5,_0x56c00d[_0x553eca(0x24a)]['x']=0x1/(this[_0x553eca(0x24a)]['x']||0.01),_0x56c00d[_0x553eca(0x24a)]['y']=0x1/(this[_0x553eca(0x24a)]['y']||0.01);},Sprite_ActiveChainButton[_0x2fc34f(0x2d1)][_0x2fc34f(0x219)]=function(){const _0x22b5fd=_0x2fc34f;this['_contentSprite']=new Sprite(),this[_0x22b5fd(0x251)](this[_0x22b5fd(0x1a1)]),this[_0x22b5fd(0x1a1)][_0x22b5fd(0x2d4)]['x']=0.5,this[_0x22b5fd(0x1a1)][_0x22b5fd(0x2d4)]['y']=0.5;},Sprite_ActiveChainButton[_0x2fc34f(0x2d1)][_0x2fc34f(0x28d)]=function(){const _0x59cb58=_0x2fc34f,_0x56cacf=$gameSystem[_0x59cb58(0x232)](),_0x10df7e=this[_0x59cb58(0x1df)][_0x59cb58(0x286)]+_0x56cacf*0x2,_0x4b26e3=this[_0x59cb58(0x1df)][_0x59cb58(0x241)]+_0x56cacf*0x2,_0x2bf732=new Rectangle(0x0,0x0,_0x10df7e,_0x4b26e3);this[_0x59cb58(0x297)]=new Window_Base(_0x2bf732);},Sprite_ActiveChainButton['prototype'][_0x2fc34f(0x1e2)]=function(){const _0x1d3763=_0x2fc34f;Sprite_Clickable['prototype']['update']['call'](this),this[_0x1d3763(0x287)](),this[_0x1d3763(0x25d)]();if(this[_0x1d3763(0x2ca)]())this[_0x1d3763(0x1c7)]();},Sprite_ActiveChainButton[_0x2fc34f(0x2d1)]['updateOpacity']=function(){const _0x8e86d3=_0x2fc34f;this['opacity']=this[_0x8e86d3(0x240)]();},Sprite_ActiveChainButton[_0x2fc34f(0x2d1)][_0x2fc34f(0x240)]=function(){const _0xa16c7=_0x2fc34f;if(!$gameTemp[_0xa16c7(0x275)]())return 0x0;if(!$gameTemp['hasActiveChainSkillsKey'](this['_key']))return 0x0;const _0x5ce9b3=VisuMZ[_0xa16c7(0x1dc)][_0xa16c7(0x1d0)]['UI']['OpacityDisable'],_0x2b1c92=$gameTemp['getActiveChainSkillSelected'](),_0x48291a=$gameTemp[_0xa16c7(0x242)](this[_0xa16c7(0x1ea)]);if(_0x2b1c92!==null&&_0x2b1c92!==_0x48291a)return _0x5ce9b3;if($gameTemp[_0xa16c7(0x262)]&&_0x2b1c92!==_0x48291a)return _0x5ce9b3;const _0x165f20=BattleManager[_0xa16c7(0x19d)];if(!_0x165f20)return _0x5ce9b3;const _0x20803d=$dataSkills[_0x48291a];if(!_0x165f20['canUse'](_0x20803d))return _0x5ce9b3;return 0xff;},Sprite_ActiveChainButton[_0x2fc34f(0x2d1)][_0x2fc34f(0x25d)]=function(){const _0x4c9f24=_0x2fc34f,_0x1c2eae=VisuMZ[_0x4c9f24(0x1dc)][_0x4c9f24(0x1d0)]['UI'];this['x']=this['_dimensions']['x']+(_0x1c2eae[_0x4c9f24(0x1dd)]||0x0),this['y']=this[_0x4c9f24(0x1df)]['y']+(_0x1c2eae[_0x4c9f24(0x1d6)]||0x0),this[_0x4c9f24(0x1b9)]&&(this['_pressedDuration']=0x4),this['_pressedDuration']-->0x0&&(this['x']+=Sprite_ActiveChainButton[_0x4c9f24(0x28b)],this['y']+=Sprite_ActiveChainButton[_0x4c9f24(0x2b5)]);},Sprite_ActiveChainButton['prototype'][_0x2fc34f(0x1c7)]=function(){const _0x371e4b=_0x2fc34f;this[_0x371e4b(0x2e0)]=BattleManager[_0x371e4b(0x19d)],this[_0x371e4b(0x22a)]=$gameTemp[_0x371e4b(0x242)](this[_0x371e4b(0x1ea)]);if(Imported[_0x371e4b(0x1e5)]&&Input['getLastUsedGamepadType']){if(_0x371e4b(0x235)===_0x371e4b(0x235))this['_lastInputType']=Input[_0x371e4b(0x1db)]();else{if(this['_battler'][_0x371e4b(0x1d7)])return;}}this[_0x371e4b(0x23b)]();},Sprite_ActiveChainButton[_0x2fc34f(0x2d1)]['meetsUpdateBitmapConditions']=function(){const _0x2c105c=_0x2fc34f;if(this[_0x2c105c(0x2e0)]!==BattleManager['_subject'])return!![];if(this[_0x2c105c(0x22a)]!==$gameTemp['getActiveChainSkillsKey'](this[_0x2c105c(0x1ea)]))return!![];if(Imported[_0x2c105c(0x1e5)]&&Input[_0x2c105c(0x1db)]){if(this['_lastInputType']!==Input[_0x2c105c(0x1db)]())return!![];}return![];},Sprite_ActiveChainButton[_0x2fc34f(0x2d1)]['refreshBitmap']=function(){const _0x10b685=_0x2fc34f,_0x2d30f8=VisuMZ[_0x10b685(0x1dc)][_0x10b685(0x1d0)]['UI'],_0x309686=this[_0x10b685(0x297)]['contents'],_0x240f28=$dataSkills[this[_0x10b685(0x22a)]];if(!_0x240f28)return;if(!BattleManager[_0x10b685(0x19d)])return;_0x309686['clear'](),this[_0x10b685(0x297)]['resetFontSettings']();const _0x5c3d77=this['getButtonIcon'](),_0x1b58e1=BattleManager['_subject'],_0x736699=this[_0x10b685(0x297)][_0x10b685(0x1f0)](_0x1b58e1,_0x240f28);_0x2d30f8[_0x10b685(0x290)]['call'](this[_0x10b685(0x297)],_0x240f28,_0x5c3d77,_0x736699),this[_0x10b685(0x1a1)][_0x10b685(0x1e7)]=_0x309686;},Sprite_ActiveChainButton['prototype'][_0x2fc34f(0x27a)]=function(){const _0x39adeb=_0x2fc34f,_0x27a9b3=VisuMZ[_0x39adeb(0x1dc)][_0x39adeb(0x1d0)]['UI'],_0x3e505a='%1KeyIcon'[_0x39adeb(0x2a0)](this[_0x39adeb(0x1ea)]);if(_0x27a9b3[_0x3e505a])return _0x27a9b3[_0x3e505a];if(Imported[_0x39adeb(0x1e5)]){if(_0x39adeb(0x2e8)!==_0x39adeb(0x2e8))_0x553a1d(_0x39adeb(0x2cf)[_0x39adeb(0x2a0)](_0x280a73,_0x23169f,_0x479ee7)),_0x56c0b3[_0x39adeb(0x2a5)]();else{const _0x57f5ed=TextManager[_0x39adeb(0x2cb)](this[_0x39adeb(0x1ea)]);if(_0x57f5ed&&_0x57f5ed[_0x39adeb(0x21b)](/\\I\[(\d+)\]/i))return Number(RegExp['$1']);}}return 0x0;},Sprite_ActiveChainButton[_0x2fc34f(0x2d1)][_0x2fc34f(0x203)]=function(){const _0x3959b2=_0x2fc34f;Sprite_Clickable[_0x3959b2(0x2d1)][_0x3959b2(0x203)]['call'](this);const _0x20c6e0=$dataSkills[$gameTemp[_0x3959b2(0x242)](this[_0x3959b2(0x1ea)])];BattleManager[_0x3959b2(0x19d)]&&_0x20c6e0&&(_0x3959b2(0x23f)!==_0x3959b2(0x23f)?this[_0x3959b2(0x1df)]=new _0x65980c(0x0,0x0,0x0,0x0):BattleManager[_0x3959b2(0x19d)][_0x3959b2(0x2ce)](_0x20c6e0));const _0x19f73a=this[_0x3959b2(0x1b8)]();_0x19f73a&&_0x19f73a[_0x3959b2(0x214)](null);},Sprite_ActiveChainButton[_0x2fc34f(0x2d1)]['isClickEnabled']=function(){const _0xa297b0=_0x2fc34f;if(this[_0xa297b0(0x299)]<=0x0)return![];const _0x402ce3=SceneManager[_0xa297b0(0x226)];if(!_0x402ce3)return![];if(!_0x402ce3[_0xa297b0(0x2cd)])return![];if(!_0x402ce3[_0xa297b0(0x2cd)]())return![];if(!$gameTemp[_0xa297b0(0x282)](this[_0xa297b0(0x1ea)]))return![];const _0x2ac1c1=$dataSkills[$gameTemp['getActiveChainSkillsKey'](this[_0xa297b0(0x1ea)])];if(!_0x2ac1c1)return![];if(!BattleManager[_0xa297b0(0x19d)][_0xa297b0(0x1d9)](_0x2ac1c1))return![];return Sprite_Clickable[_0xa297b0(0x2d1)]['isClickEnabled']['call'](this);},Sprite_ActiveChainButton[_0x2fc34f(0x2d1)]['tooltipWindow']=function(){const _0x45706d=_0x2fc34f;return SceneManager[_0x45706d(0x226)][_0x45706d(0x1f1)];},Sprite_ActiveChainButton['prototype'][_0x2fc34f(0x213)]=function(){const _0x5615be=_0x2fc34f;Sprite_Clickable[_0x5615be(0x2d1)][_0x5615be(0x213)][_0x5615be(0x1ca)](this);const _0x34476e=this[_0x5615be(0x1b8)]();if(!_0x34476e)return;const _0x318b87=SceneManager[_0x5615be(0x226)],_0x42612b=_0x318b87&&_0x318b87[_0x5615be(0x220)]?_0x318b87['isActiveChainSkillsUiVisible']():![];if(_0x34476e&&_0x42612b){const _0x25393b=$dataSkills[this['_lastSkillID']];_0x34476e['setSkill'](_0x25393b);}},Sprite_ActiveChainButton[_0x2fc34f(0x2d1)]['onMouseExit']=function(){const _0x4ebb5b=_0x2fc34f;Sprite_Clickable[_0x4ebb5b(0x2d1)][_0x4ebb5b(0x1c5)][_0x4ebb5b(0x1ca)](this);const _0x9f17a6=this[_0x4ebb5b(0x1b8)]();if(!_0x9f17a6)return;const _0x3744d9=$dataSkills[this[_0x4ebb5b(0x22a)]],_0x29f961=SceneManager[_0x4ebb5b(0x226)],_0x3a6e8d=_0x29f961&&_0x29f961[_0x4ebb5b(0x220)]?_0x29f961['isActiveChainSkillsUiVisible']():![];(!_0x3a6e8d||_0x9f17a6['_skill']===_0x3744d9)&&_0x9f17a6[_0x4ebb5b(0x214)](null);},Sprite_ActiveChainButton[_0x2fc34f(0x2d1)][_0x2fc34f(0x1a2)]=function(){const _0x29b08e=_0x2fc34f,_0x3c4bfb=this[_0x29b08e(0x289)];this[_0x29b08e(0x289)]=this[_0x29b08e(0x1b1)]();if(this['_hoverState']!==_0x3c4bfb){if(this[_0x29b08e(0x289)]){if(_0x29b08e(0x27f)!==_0x29b08e(0x27f))return![];else this[_0x29b08e(0x213)]();}else this[_0x29b08e(0x1c5)]();}this['isClickEnabled']()?(this[_0x29b08e(0x1b1)]()?TouchInput['isTriggered']()&&(this[_0x29b08e(0x1b9)]=!![],this['onPress']()):(this[_0x29b08e(0x1b9)]=![],this[_0x29b08e(0x27b)]=![]),this[_0x29b08e(0x1b9)]&&TouchInput[_0x29b08e(0x2b2)]()&&(this[_0x29b08e(0x1b9)]=![],this['onClick']())):(this['_pressed']=![],this[_0x29b08e(0x27b)]=![]);},Sprite_ActiveChainButton[_0x2fc34f(0x2d1)][_0x2fc34f(0x1b1)]=function(){const _0x2c7d45=_0x2fc34f,_0x32186a=new Point(TouchInput['x'],TouchInput['y']),_0x38c35d=this[_0x2c7d45(0x20f)][_0x2c7d45(0x21f)](_0x32186a);return this[_0x2c7d45(0x2c4)](_0x38c35d['x'],_0x38c35d['y']);},Window_Base[_0x2fc34f(0x2d1)]['drawActiveChainLargeIcon']=function(_0x2508bf,_0x2450c2,_0x338d8c,_0x2f1668){const _0x269efd=_0x2fc34f,_0x2a5b77=VisuMZ[_0x269efd(0x1dc)][_0x269efd(0x1d0)]['UI'];_0x2f1668=_0x2f1668||0x20,_0x2450c2-=Math['round'](_0x2f1668/0x2);const _0x47bb07=ImageManager['loadSystem'](_0x269efd(0x1e8)),_0x2a9876=ImageManager['iconWidth'],_0x2ad274=ImageManager[_0x269efd(0x2bf)],_0x15df95=_0x2508bf%0x10*_0x2a9876,_0x49fd3a=Math[_0x269efd(0x2cc)](_0x2508bf/0x10)*_0x2ad274;this[_0x269efd(0x1bd)][_0x269efd(0x1cf)][_0x269efd(0x1e6)]=_0x2a5b77[_0x269efd(0x218)],this[_0x269efd(0x1bd)][_0x269efd(0x255)](_0x47bb07,_0x15df95,_0x49fd3a,_0x2a9876,_0x2ad274,_0x2450c2,_0x338d8c,_0x2f1668,_0x2f1668),this[_0x269efd(0x1bd)]['_context'][_0x269efd(0x1e6)]=!![];},VisuMZ['ActiveChainSkills'][_0x2fc34f(0x263)]=Window_BattleLog[_0x2fc34f(0x2d1)][_0x2fc34f(0x247)],Window_BattleLog['prototype']['addMeleeReturnActionSet']=function(_0x285c35,_0x157014,_0x177593,_0x5d41c1){const _0xc1f709=_0x2fc34f;if(Sprite_Actor[_0xc1f709(0x2de)])_0xc1f709(0x28e)!==_0xc1f709(0x2c8)?this[_0xc1f709(0x29b)](_0x285c35,_0x157014,_0x177593,_0x5d41c1):(this['_bypassStepForward_ActiveChainSkill']=!![],this['_bypassStepBackward_ActiveChainSkill']=!![]);else{if(_0xc1f709(0x2aa)==='dvNuR')VisuMZ['ActiveChainSkills'][_0xc1f709(0x263)][_0xc1f709(0x1ca)](this,_0x285c35,_0x157014,_0x177593,_0x5d41c1);else{if(!_0x5f1750[_0xc1f709(0x19d)])return![];if(!_0x3bff95[_0xc1f709(0x19d)]['isActor']())return![];if(!_0x1f5b31[_0xc1f709(0x19d)][_0xc1f709(0x230)]())return![];if(_0x208484[_0xc1f709(0x19d)]['isRestricted']())return![];if(_0x1a358f['isInputting']())return![];if(_0x5b393b['_victoryPhase'])return![];if(_0x4471d7[_0xc1f709(0x283)]()[_0xc1f709(0x26c)]<=0x0)return![];if(_0x14c838[_0xc1f709(0x295)]())return![];return this[_0xc1f709(0x2c2)]!==_0x207389;}}},Window_BattleLog[_0x2fc34f(0x2d1)][_0x2fc34f(0x247)]=function(_0x4b0106,_0x4dcf46,_0x67345b,_0x504538){const _0x512b9c=_0x2fc34f;if(_0x4dcf46){const _0x1826c3=_0x4b0106[_0x512b9c(0x207)]();this[_0x512b9c(0x26b)](_0x512b9c(0x256),!![]),this[_0x512b9c(0x26b)](_0x512b9c(0x2a2),[_0x4b0106],_0x67345b,_0x504538),this[_0x512b9c(0x26b)](_0x512b9c(0x279),_0x4b0106,_0x1826c3[_0x512b9c(0x2b7)],_0x1826c3[_0x512b9c(0x272)],_0x504538,![],_0x512b9c(0x1f2)),this[_0x512b9c(0x26b)](_0x512b9c(0x264),[_0x4b0106],_0x512b9c(0x273)),this[_0x512b9c(0x26b)](_0x512b9c(0x2a3)),this['push'](_0x512b9c(0x264),[_0x4b0106],_0x512b9c(0x1c9));}},Window_BattleLog[_0x2fc34f(0x2d1)][_0x2fc34f(0x215)]=function(){const _0x27ffe6=_0x2fc34f,_0x4ed550=$gameTemp[_0x27ffe6(0x1b2)]();return _0x4ed550!==null;},Window_BattleLog[_0x2fc34f(0x2d1)][_0x2fc34f(0x256)]=function(_0x23f966){$gameTemp['_performActionEnd']=_0x23f966;},Window_BattleLog['prototype'][_0x2fc34f(0x2a2)]=function(_0x5e3e05,_0x41bcc1,_0x1e5817){const _0xd683c4=_0x2fc34f;this[_0xd683c4(0x215)]()?this[_0xd683c4(0x26e)]():this[_0xd683c4(0x211)](_0x5e3e05,_0x41bcc1,_0x1e5817);},Window_BattleLog[_0x2fc34f(0x2d1)][_0x2fc34f(0x279)]=function(_0x220760,_0x263022,_0x6c1739,_0x46e090,_0x153617,_0x4b5bf0){const _0x2ddf08=_0x2fc34f;this[_0x2ddf08(0x215)]()?this[_0x2ddf08(0x26e)]():this[_0x2ddf08(0x1fb)](_0x220760,_0x263022,_0x6c1739,_0x46e090,_0x153617,_0x4b5bf0);},Window_BattleLog[_0x2fc34f(0x2d1)][_0x2fc34f(0x264)]=function(_0x212692,_0x33c0fb){const _0x17f91f=_0x2fc34f;this[_0x17f91f(0x215)]()?this[_0x17f91f(0x26e)]():this[_0x17f91f(0x293)](_0x212692,_0x33c0fb);},Window_BattleLog[_0x2fc34f(0x2d1)][_0x2fc34f(0x2a3)]=function(){const _0x155717=_0x2fc34f;if(this[_0x155717(0x215)]())this[_0x155717(0x26e)]();else{if(_0x155717(0x2df)==='eQqLo')this[_0x155717(0x1b3)]();else{if(this[_0x155717(0x2bb)]===_0x33c580)return;this[_0x155717(0x2bb)]=_0x8d3ea2,this['_skill']&&this[_0x155717(0x2bb)][_0x155717(0x1cb)][_0x155717(0x1e3)]()['length']>0x0?this[_0x155717(0x1aa)]():this[_0x155717(0x2d6)]();}}};function Window_ActiveChainSkillsTooltip(){const _0x38cc99=_0x2fc34f;this[_0x38cc99(0x1a0)](...arguments);}Window_ActiveChainSkillsTooltip[_0x2fc34f(0x2d1)]=Object[_0x2fc34f(0x2c0)](Window_Base[_0x2fc34f(0x2d1)]),Window_ActiveChainSkillsTooltip['prototype'][_0x2fc34f(0x1a4)]=Window_ActiveChainSkillsTooltip,Window_ActiveChainSkillsTooltip[_0x2fc34f(0x1a3)]=VisuMZ[_0x2fc34f(0x1dc)][_0x2fc34f(0x1d0)][_0x2fc34f(0x1b4)][_0x2fc34f(0x270)]??!![],Window_ActiveChainSkillsTooltip['WINDOW_SCALE']=VisuMZ[_0x2fc34f(0x1dc)]['Settings'][_0x2fc34f(0x1b4)][_0x2fc34f(0x237)],Window_ActiveChainSkillsTooltip[_0x2fc34f(0x22f)]=VisuMZ['ActiveChainSkills'][_0x2fc34f(0x1d0)][_0x2fc34f(0x1b4)][_0x2fc34f(0x269)],Window_ActiveChainSkillsTooltip[_0x2fc34f(0x1a8)]=VisuMZ[_0x2fc34f(0x1dc)][_0x2fc34f(0x1d0)]['Tooltip'][_0x2fc34f(0x1fc)],Window_ActiveChainSkillsTooltip[_0x2fc34f(0x2b8)]=VisuMZ[_0x2fc34f(0x1dc)]['Settings'][_0x2fc34f(0x1b4)][_0x2fc34f(0x201)],Window_ActiveChainSkillsTooltip[_0x2fc34f(0x245)]=VisuMZ[_0x2fc34f(0x1dc)][_0x2fc34f(0x1d0)][_0x2fc34f(0x1b4)][_0x2fc34f(0x1a5)],Window_ActiveChainSkillsTooltip[_0x2fc34f(0x2d1)][_0x2fc34f(0x1a0)]=function(){const _0x260b9e=_0x2fc34f,_0x5e128a=new Rectangle(0x0,0x0,Graphics['width'],Graphics[_0x260b9e(0x241)]);Window_Base['prototype'][_0x260b9e(0x1a0)][_0x260b9e(0x1ca)](this,_0x5e128a),this[_0x260b9e(0x24a)]['x']=this['scale']['y']=Window_ActiveChainSkillsTooltip[_0x260b9e(0x27c)],this['hide'](),this['_skill']=null;},Window_ActiveChainSkillsTooltip[_0x2fc34f(0x2d1)]['loadWindowskin']=function(){const _0x211099=_0x2fc34f;this[_0x211099(0x1c4)]=ImageManager['loadSystem'](Window_ActiveChainSkillsTooltip[_0x211099(0x22f)]);},Window_ActiveChainSkillsTooltip[_0x2fc34f(0x2d1)][_0x2fc34f(0x1ee)]=function(){const _0x26665b=_0x2fc34f;this['backOpacity']=Window_ActiveChainSkillsTooltip[_0x26665b(0x1a8)];},Window_ActiveChainSkillsTooltip[_0x2fc34f(0x2d1)]['setSkill']=function(_0x4993c8){const _0x1e2de6=_0x2fc34f;if(this['_skill']===_0x4993c8)return;this[_0x1e2de6(0x2bb)]=_0x4993c8,this[_0x1e2de6(0x2bb)]&&this[_0x1e2de6(0x2bb)]['description'][_0x1e2de6(0x1e3)]()[_0x1e2de6(0x26c)]>0x0?this[_0x1e2de6(0x1aa)]():this[_0x1e2de6(0x2d6)]();},Window_ActiveChainSkillsTooltip['prototype'][_0x2fc34f(0x1aa)]=function(){const _0x200ec2=_0x2fc34f;this['contents'][_0x200ec2(0x2a1)](),this[_0x200ec2(0x1af)]();if(this[_0x200ec2(0x1ef)][_0x200ec2(0x26c)]>0x0){this[_0x200ec2(0x1eb)]();const _0x3da4a3=this[_0x200ec2(0x1f8)]();this[_0x200ec2(0x2ac)](this[_0x200ec2(0x1ef)],_0x3da4a3['x'],_0x3da4a3['y'],_0x3da4a3[_0x200ec2(0x286)]),this[_0x200ec2(0x281)]();}else this[_0x200ec2(0x2d6)]();},Window_ActiveChainSkillsTooltip[_0x2fc34f(0x2d1)]['isWordWrapEnabled']=function(){return![];},Window_ActiveChainSkillsTooltip['prototype'][_0x2fc34f(0x216)]=function(_0x1ba9ac){return _0x1ba9ac;},Window_ActiveChainSkillsTooltip[_0x2fc34f(0x2d1)][_0x2fc34f(0x22b)]=function(){return![];},Window_ActiveChainSkillsTooltip[_0x2fc34f(0x2d1)][_0x2fc34f(0x1af)]=function(){const _0x52e905=_0x2fc34f;this['_text']='';if(!this['_skill'])return;this['setupDescriptionText'](),this[_0x52e905(0x1ef)]=this[_0x52e905(0x1ef)][_0x52e905(0x1e3)]();},Window_ActiveChainSkillsTooltip[_0x2fc34f(0x2d1)][_0x2fc34f(0x1b5)]=function(){const _0x1e088e=_0x2fc34f;this[_0x1e088e(0x1ef)]=this[_0x1e088e(0x2bb)]['description']||'';},Window_ActiveChainSkillsTooltip['prototype'][_0x2fc34f(0x1eb)]=function(){const _0xe7b448=_0x2fc34f,_0x493e07=this[_0xe7b448(0x271)](this[_0xe7b448(0x1ef)]);this[_0xe7b448(0x286)]=_0x493e07[_0xe7b448(0x286)]+(this[_0xe7b448(0x21e)]()+this[_0xe7b448(0x1f3)])*0x2,this['height']=_0x493e07[_0xe7b448(0x241)]+this[_0xe7b448(0x1f3)]*0x2,this[_0xe7b448(0x1cc)](),this[_0xe7b448(0x285)]();},Window_ActiveChainSkillsTooltip['prototype'][_0x2fc34f(0x1e2)]=function(){const _0x47887c=_0x2fc34f;Window_Base[_0x47887c(0x2d1)]['update']['call'](this),this[_0x47887c(0x223)]&&('bYlqL'!==_0x47887c(0x25f)?(this[_0x47887c(0x223)]=![],this[_0x47887c(0x1aa)]()):this['onMouseEnter']()),this[_0x47887c(0x25d)](),this[_0x47887c(0x287)]();},Window_ActiveChainSkillsTooltip[_0x2fc34f(0x2d1)][_0x2fc34f(0x260)]=function(){this['_requestRefresh']=!![];},Window_ActiveChainSkillsTooltip[_0x2fc34f(0x2d1)]['updatePosition']=function(){const _0x319dfa=_0x2fc34f;if(!this[_0x319dfa(0x249)])return;this['x']=TouchInput['x']+Window_ActiveChainSkillsTooltip['MOUSE_OFFSET_X'],this['y']=TouchInput['y']+Window_ActiveChainSkillsTooltip[_0x319dfa(0x245)],this[_0x319dfa(0x205)]();},Window_ActiveChainSkillsTooltip['prototype'][_0x2fc34f(0x205)]=function(){const _0x42fc2b=_0x2fc34f,_0x59c156=this[_0x42fc2b(0x286)]*(Window_ActiveChainSkillsTooltip['WINDOW_SCALE']||0.01),_0x269e8b=this[_0x42fc2b(0x241)]*(Window_ActiveChainSkillsTooltip['WINDOW_SCALE']||0.01);this['x']=Math[_0x42fc2b(0x2b1)](this['x']['clamp'](0x0,Graphics[_0x42fc2b(0x286)]-_0x59c156)),this['y']=Math[_0x42fc2b(0x2b1)](this['y'][_0x42fc2b(0x27d)](0x0,Graphics[_0x42fc2b(0x241)]-_0x269e8b));},Window_ActiveChainSkillsTooltip['prototype']['updateOpacity']=function(){const _0x2eb085=_0x2fc34f;let _0x4e90dc=0xff;if(TouchInput['x']<=0x0)_0x4e90dc=0x0;if(TouchInput['x']>=Graphics[_0x2eb085(0x286)])_0x4e90dc=0x0;if(TouchInput['y']<=0x0)_0x4e90dc=0x0;if(TouchInput['y']>=Graphics[_0x2eb085(0x241)])_0x4e90dc=0x0;this['opacity']=_0x4e90dc;};