//=============================================================================
// VisuStella MZ - Battle Voices
// VisuMZ_3_BattleVoices.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_3_BattleVoices = true;

var VisuMZ = VisuMZ || {};
VisuMZ.BattleVoices = VisuMZ.BattleVoices || {};
VisuMZ.BattleVoices.version = 1.02;

//=============================================================================
/* ----------------------------------------------------------------------------
 * Voice Set Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~VoiceSet:
 *
 * @param Name:str
 * @text Name
 * @desc Name of this Voice Set. The name will be used as the name
 * for the <Voice Set: name> notetag.
 * @default Untitled
 * 
 * @param BattlePhases
 * @text Battle Phases
 *
 * @param BattleStart:arraystr
 * @text On Battle Start
 * @parent BattlePhases
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file for a random party member
 * speaking at the start of battle.
 * @default []
 *
 * @param BattleInput:arraystr
 * @text On Battle Input
 * @parent BattlePhases
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file for a party member that
 * is ready to input actions.
 * @default []
 *
 * @param BattleVictory:arraystr
 * @text On Battle Victory
 * @parent BattlePhases
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file for a random party member
 * speaking upon battle victory.
 * @default []
 *
 * @param BattleVictoryLevelUp:arraystr
 * @text Victory => Level Up
 * @parent BattlePhases
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file for party members that
 * level up in battle. Requires VisuMZ_3_VictoryAftermath!
 * @default []
 *
 * @param BattleEscapeSuccess:arraystr
 * @text Escape => Success
 * @parent BattlePhases
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file for a random party member
 * speaking upon successfully escaping battle.
 * @default []
 *
 * @param BattleEscapeFailure:arraystr
 * @text Escape => Failure
 * @parent BattlePhases
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file for a random party member
 * speaking upon failing to escaping battle.
 * @default []
 * 
 * @param ActionStart
 * @text On Action Start
 * 
 * @param ActionStartBasic
 * @text Basic Action
 * @parent ActionStart
 *
 * @param ActionStartBasicAttack:arraystr
 * @text Regular Attack
 * @parent ActionStartBasic
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file for performing the start
 * of a basic regular attack.
 * @default []
 *
 * @param ActionStartBasicGuard:arraystr
 * @text Regular Guard
 * @parent ActionStartBasic
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file for performing the start
 * of a basic regular guard.
 * @default []
 * 
 * @param ActionStartSkill
 * @text Skill Usage
 * @parent ActionStart
 * 
 * @param ActionStartSkillAlly
 * @text For Allies
 * @parent ActionStartSkill
 *
 * @param ActionStartSkillAllyCertainHit:arraystr
 * @text Certain Hit
 * @parent ActionStartSkillAlly
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file for performing the start
 * of a skill-based certain hit action for allies.
 * @default []
 *
 * @param ActionStartSkillAllyPhysical:arraystr
 * @text Physical
 * @parent ActionStartSkillAlly
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file for performing the start
 * of a skill-based physical hit action for allies.
 * @default []
 *
 * @param ActionStartSkillAllyMagical:arraystr
 * @text Magical
 * @parent ActionStartSkillAlly
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file for performing the start
 * of a skill-based magical hit action for allies.
 * @default []
 * 
 * @param ActionStartSkillEnemy
 * @text For Enemies
 * @parent ActionStartSkill
 *
 * @param ActionStartSkillEnemyCertainHit:arraystr
 * @text Certain Hit
 * @parent ActionStartSkillEnemy
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file for performing the start
 * of a skill-based certain hit action for enemies.
 * @default []
 *
 * @param ActionStartSkillEnemyPhysical:arraystr
 * @text Physical
 * @parent ActionStartSkillEnemy
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file for performing the start
 * of a skill-based physical hit action for enemies.
 * @default []
 *
 * @param ActionStartSkillEnemyMagical:arraystr
 * @text Magical
 * @parent ActionStartSkillEnemy
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file for performing the start
 * of a skill-based magical hit action for enemies.
 * @default []
 * 
 * @param ActionStartItem
 * @text Item Usage
 * @parent ActionStart
 *
 * @param ActionStartItemAlly:arraystr
 * @text For Allies
 * @parent ActionStartItem
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file for performing the start
 * of an item-based action for allies.
 * @default []
 *
 * @param ActionStartItemEnemy:arraystr
 * @text For Enemies
 * @parent ActionStartItem
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file for performing the start
 * of an item-based action for enemies.
 * @default []
 * 
 * @param PerformAction
 * @text Perform Action
 * 
 * @param PerformActionBasic
 * @text Basic Action
 * @parent PerformAction
 *
 * @param PerformActionBasicAttack:arraystr
 * @text Attack Motion
 * @parent PerformActionBasic
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file for performing an
 * attack's action.
 * @default []
 *
 * @param PerformActionCritical:arraystr
 * @text Critical Action
 * @parent PerformActionBasic
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file for performing an
 * action and landing a critical hit.
 * @default []
 *
 * @param PerformActionDefeatFoe:arraystr
 * @text Defeat Opponent
 * @parent PerformActionBasic
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file for performing an
 * action and defeating an opponent.
 * @default []
 *
 * @param PerformActionMiss:arraystr
 * @text Missed Action
 * @parent PerformActionBasic
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file for performing an
 * action but missing.
 * @default []
 * 
 * @param PerformActionSkill
 * @text Skill Usage
 * @parent PerformAction
 *
 * @param PerformActionSkillCertainHit:arraystr
 * @text Certain Hit
 * @parent PerformActionSkill
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file for performing the action
 * of a Certain Hit type skill.
 * @default []
 *
 * @param PerformActionSkillPhysical:arraystr
 * @text Physical
 * @parent PerformActionSkill
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file for performing the action
 * of a physical hit type skill.
 * @default []
 *
 * @param PerformActionSkillMagical:arraystr
 * @text Magical
 * @parent PerformActionSkill
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file for performing the action
 * of a magical hit type skill.
 * @default []
 * 
 * @param HpChange
 * @text On HP Change
 * 
 * @param HpChangeLifeState
 * @text Life State
 * @parent HpChange
 *
 * @param HpChangeDeath:arraystr
 * @text On Death
 * @parent HpChangeLifeState
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file when the battler receives
 * enough damage to be fatal.
 * @default []
 *
 * @param HpChangeRevive:arraystr
 * @text On Revive
 * @parent HpChangeLifeState
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file when the battler receives
 * healing and revives.
 * @default []
 * 
 * @param HpChangeDamage
 * @text On Damage
 * @parent HpChange
 *
 * @param HpChangeDamageNone:arraystr
 * @text Damage <= 0%
 * @parent HpChangeDamage
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file when the battler receives
 * no damage whatsoever.
 * @default []
 *
 * @param HpChangeDamageLight:arraystr
 * @text Damage < 25%
 * @parent HpChangeDamage
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file when the battler receives
 * damage less than 25% of MaxHP.
 * @default []
 *
 * @param HpChangeDamageMedium:arraystr
 * @text Damage < 50%
 * @parent HpChangeDamage
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file when the battler receives
 * damage less than 50% of MaxHP.
 * @default []
 *
 * @param HpChangeDamageHeavy:arraystr
 * @text Damage >= 50%
 * @parent HpChangeDamage
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file when the battler receives
 * damage more than 50% of MaxHP.
 * @default []
 *
 * @param HpChangeDamageGuard:arraystr
 * @text Guarding Damage
 * @parent HpChangeDamage
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file when the battler receives
 * damage while guarding.
 * @default []
 * 
 * @param HpChangeRecover
 * @text On Recovery
 * @parent HpChange
 *
 * @param HpChangeRecoverLight:arraystr
 * @text Recovery < 25%
 * @parent HpChangeRecover
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file when the battler receives
 * healing more than 25% of MaxHP.
 * @default []
 *
 * @param HpChangeRecoverMedium:arraystr
 * @text Recovery < 50%
 * @parent HpChangeRecover
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file when the battler receives
 * healing more than 25% of MaxHP.
 * @default []
 *
 * @param HpChangeRecoverHeavy:arraystr
 * @text Recovery >= 50%
 * @parent HpChangeRecover
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file when the battler receives
 * healing more than 25% of MaxHP.
 * @default []
 * 
 * @param ActionResult
 * @text On Action Result
 *
 * @param ActionResultEvasion:arraystr
 * @text On Miss/Evasion
 * @parent ActionResult
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file when the battler evades
 * a physical or certain hit action.
 * @default []
 *
 * @param ActionResultMagicEvasion:arraystr
 * @text On Magic Evasion
 * @parent ActionResult
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file when the battler evades
 * a magical action.
 * @default []
 *
 * @param ActionResultCounter:arraystr
 * @text On Counter
 * @parent ActionResult
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file when the battler counters
 * an action.
 * @default []
 *
 * @param ActionResultReflection:arraystr
 * @text On Reflection
 * @parent ActionResult
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file when the battler reflects
 * an action.
 * @default []
 *
 * @param ActionResultSubstitute:arraystr
 * @text On Substitute
 * @parent ActionResult
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file when the battler
 * substitutes for an action.
 * @default []
 * 
 * @param BuffRelated
 * @text Buff/Debuff Related
 *
 * @param BuffAdd:arraystr
 * @text On Buff Apply
 * @parent BuffRelated
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file when the battler receives
 * a buff or stacks a buff to a higher degree.
 * @default []
 *
 * @param BuffRemove:arraystr
 * @text On Buff Remove
 * @parent BuffRelated
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file when the battler has
 * a buff removed.
 * @default []
 *
 * @param DebuffAdd:arraystr
 * @text On Debuff Apply
 * @parent BuffRelated
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file when the battler receives
 * a debuff or stacks a debuff to a higher degree.
 * @default []
 *
 * @param DebuffRemove:arraystr
 * @text On Debuff Remove
 * @parent BuffRelated
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file when the battler has
 * a debuff removed.
 * @default []
 * 
 * @param StateRelated
 * @text State Related
 * 
 * @param StatePositive
 * @text Positive States
 * @parent StateRelated
 *
 * @param StatePositiveAdd:arraystr
 * @text On State Apply
 * @parent StatePositive
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file when the battler receives
 * a positive state. Requires VisuMZ_1_SkillsStatesCore!
 * @default []
 *
 * @param StatePositiveRemove:arraystr
 * @text On State Remove
 * @parent StatePositive
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file when the battler loses a
 * positive state. Requires VisuMZ_1_SkillsStatesCore!
 * @default []
 * 
 * @param StateNegative
 * @text Negative States
 * @parent StateRelated
 *
 * @param StateNegativeAdd:arraystr
 * @text On State Apply
 * @parent StateNegative
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file when the battler receives
 * a negative state. Requires VisuMZ_1_SkillsStatesCore!
 * @default []
 *
 * @param StateNegativeRemove:arraystr
 * @text On State Remove
 * @parent StateNegative
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file when the battler loses a
 * negative state. Requires VisuMZ_1_SkillsStatesCore!
 * @default []
 * 
 * @param StateNeutral
 * @text Neutral States
 * @parent StateRelated
 *
 * @param StateNeutralAdd:arraystr
 * @text On State Apply
 * @parent StateNeutral
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file when the battler receives
 * a neutral state.
 * @default []
 *
 * @param StateNeutralRemove:arraystr
 * @text On State Remove
 * @parent StateNeutral
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file when the battler loses a
 * neutral state.
 * @default []
 * 
 * @param Compatibility
 * @text Plugin Compatibility
 * 
 * @param CharaCreate
 * @text Character Create
 * @parent Compatibility
 * @default VisuMZ_2_CharaCreationSys
 *
 * @param CharaCreateDisplayName:str
 * @text Display Name
 * @parent CharaCreate
 * @desc How does this voice set appear?
 * Requires VisuMZ_2_CharaCreationSys!
 * @default Untitled
 *
 * @param CharaCreateSelect:eval
 * @text Selectable?
 * @parent CharaCreate
 * @type boolean
 * @on Selectable
 * @off Non-Selectable
 * @desc Is voice set selectable in the Character Creation System?
 * Requires VisuMZ_2_CharaCreationSys!
 * @default true
 *
 * @param CharaCreatePreview:arraystr
 * @text Voice Preview
 * @parent CharaCreate
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to preview.
 * Requires VisuMZ_2_CharaCreationSys!
 * @default []
 *
 */
/* ----------------------------------------------------------------------------
 * Action Name Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ActionName:
 *
 * @param Name:str
 * @text Name
 * @desc Name of this Voice Set. The name will be used as the name
 * for the <Voice Set: name> notetag.
 * @default Untitled
 * 
 * @param ActionName
 * @text Action Names
 *
 * @param ActionNameA:arraystr
 * @text Action Name A
 * @parent ActionName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Action Name: x> notetag.
 * @default []
 *
 * @param ActionNameB:arraystr
 * @text Action Name B
 * @parent ActionName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Action Name: x> notetag.
 * @default []
 *
 * @param ActionNameC:arraystr
 * @text Action Name C
 * @parent ActionName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Action Name: x> notetag.
 * @default []
 *
 * @param ActionNameD:arraystr
 * @text Action Name D
 * @parent ActionName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Action Name: x> notetag.
 * @default []
 *
 * @param ActionNameE:arraystr
 * @text Action Name E
 * @parent ActionName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Action Name: x> notetag.
 * @default []
 *
 * @param ActionNameF:arraystr
 * @text Action Name F
 * @parent ActionName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Action Name: x> notetag.
 * @default []
 *
 * @param ActionNameG:arraystr
 * @text Action Name G
 * @parent ActionName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Action Name: x> notetag.
 * @default []
 *
 * @param ActionNameH:arraystr
 * @text Action Name H
 * @parent ActionName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Action Name: x> notetag.
 * @default []
 *
 * @param ActionNameI:arraystr
 * @text Action Name I
 * @parent ActionName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Action Name: x> notetag.
 * @default []
 *
 * @param ActionNameJ:arraystr
 * @text Action Name J
 * @parent ActionName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Action Name: x> notetag.
 * @default []
 *
 * @param ActionNameK:arraystr
 * @text Action Name K
 * @parent ActionName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Action Name: x> notetag.
 * @default []
 *
 * @param ActionNameL:arraystr
 * @text Action Name L
 * @parent ActionName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Action Name: x> notetag.
 * @default []
 *
 * @param ActionNameM:arraystr
 * @text Action Name M
 * @parent ActionName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Action Name: x> notetag.
 * @default []
 *
 * @param ActionNameN:arraystr
 * @text Action Name N
 * @parent ActionName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Action Name: x> notetag.
 * @default []
 *
 * @param ActionNameO:arraystr
 * @text Action Name O
 * @parent ActionName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Action Name: x> notetag.
 * @default []
 *
 * @param ActionNameP:arraystr
 * @text Action Name P
 * @parent ActionName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Action Name: x> notetag.
 * @default []
 *
 * @param ActionNameQ:arraystr
 * @text Action Name Q
 * @parent ActionName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Action Name: x> notetag.
 * @default []
 *
 * @param ActionNameR:arraystr
 * @text Action Name R
 * @parent ActionName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Action Name: x> notetag.
 * @default []
 *
 * @param ActionNameS:arraystr
 * @text Action Name S
 * @parent ActionName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Action Name: x> notetag.
 * @default []
 *
 * @param ActionNameT:arraystr
 * @text Action Name T
 * @parent ActionName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Action Name: x> notetag.
 * @default []
 *
 * @param ActionNameU:arraystr
 * @text Action Name U
 * @parent ActionName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Action Name: x> notetag.
 * @default []
 *
 * @param ActionNameV:arraystr
 * @text Action Name V
 * @parent ActionName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Action Name: x> notetag.
 * @default []
 *
 * @param ActionNameW:arraystr
 * @text Action Name W
 * @parent ActionName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Action Name: x> notetag.
 * @default []
 *
 * @param ActionNameX:arraystr
 * @text Action Name X
 * @parent ActionName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Action Name: x> notetag.
 * @default []
 *
 * @param ActionNameY:arraystr
 * @text Action Name Y
 * @parent ActionName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Action Name: x> notetag.
 * @default []
 *
 * @param ActionNameZ:arraystr
 * @text Action Name Z
 * @parent ActionName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Action Name: x> notetag.
 * @default []
 *
 */
/* ----------------------------------------------------------------------------
 * Chant Line Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ChantLine:
 *
 * @param Name:str
 * @text Name
 * @desc Name of this Voice Set. The name will be used as the name
 * for the <Voice Set: name> notetag.
 * @default Untitled
 * 
 * @param ChantLine
 * @text Chant Lines
 *
 * @param ChantLineA:arraystr
 * @text Chant Line A
 * @parent ChantLine
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Chant Line: x> notetag.
 * @default []
 *
 * @param ChantLineB:arraystr
 * @text Chant Line B
 * @parent ChantLine
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Chant Line: x> notetag.
 * @default []
 *
 * @param ChantLineC:arraystr
 * @text Chant Line C
 * @parent ChantLine
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Chant Line: x> notetag.
 * @default []
 *
 * @param ChantLineD:arraystr
 * @text Chant Line D
 * @parent ChantLine
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Chant Line: x> notetag.
 * @default []
 *
 * @param ChantLineE:arraystr
 * @text Chant Line E
 * @parent ChantLine
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Chant Line: x> notetag.
 * @default []
 *
 * @param ChantLineF:arraystr
 * @text Chant Line F
 * @parent ChantLine
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Chant Line: x> notetag.
 * @default []
 *
 * @param ChantLineG:arraystr
 * @text Chant Line G
 * @parent ChantLine
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Chant Line: x> notetag.
 * @default []
 *
 * @param ChantLineH:arraystr
 * @text Chant Line H
 * @parent ChantLine
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Chant Line: x> notetag.
 * @default []
 *
 * @param ChantLineI:arraystr
 * @text Chant Line I
 * @parent ChantLine
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Chant Line: x> notetag.
 * @default []
 *
 * @param ChantLineJ:arraystr
 * @text Chant Line J
 * @parent ChantLine
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Chant Line: x> notetag.
 * @default []
 *
 * @param ChantLineK:arraystr
 * @text Chant Line K
 * @parent ChantLine
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Chant Line: x> notetag.
 * @default []
 *
 * @param ChantLineL:arraystr
 * @text Chant Line L
 * @parent ChantLine
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Chant Line: x> notetag.
 * @default []
 *
 * @param ChantLineM:arraystr
 * @text Chant Line M
 * @parent ChantLine
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Chant Line: x> notetag.
 * @default []
 *
 * @param ChantLineN:arraystr
 * @text Chant Line N
 * @parent ChantLine
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Chant Line: x> notetag.
 * @default []
 *
 * @param ChantLineO:arraystr
 * @text Chant Line O
 * @parent ChantLine
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Chant Line: x> notetag.
 * @default []
 *
 * @param ChantLineP:arraystr
 * @text Chant Line P
 * @parent ChantLine
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Chant Line: x> notetag.
 * @default []
 *
 * @param ChantLineQ:arraystr
 * @text Chant Line Q
 * @parent ChantLine
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Chant Line: x> notetag.
 * @default []
 *
 * @param ChantLineR:arraystr
 * @text Chant Line R
 * @parent ChantLine
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Chant Line: x> notetag.
 * @default []
 *
 * @param ChantLineS:arraystr
 * @text Chant Line S
 * @parent ChantLine
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Chant Line: x> notetag.
 * @default []
 *
 * @param ChantLineT:arraystr
 * @text Chant Line T
 * @parent ChantLine
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Chant Line: x> notetag.
 * @default []
 *
 * @param ChantLineU:arraystr
 * @text Chant Line U
 * @parent ChantLine
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Chant Line: x> notetag.
 * @default []
 *
 * @param ChantLineV:arraystr
 * @text Chant Line V
 * @parent ChantLine
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Chant Line: x> notetag.
 * @default []
 *
 * @param ChantLineW:arraystr
 * @text Chant Line W
 * @parent ChantLine
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Chant Line: x> notetag.
 * @default []
 *
 * @param ChantLineX:arraystr
 * @text Chant Line X
 * @parent ChantLine
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Chant Line: x> notetag.
 * @default []
 *
 * @param ChantLineY:arraystr
 * @text Chant Line Y
 * @parent ChantLine
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Chant Line: x> notetag.
 * @default []
 *
 * @param ChantLineZ:arraystr
 * @text Chant Line Z
 * @parent ChantLine
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Chant Line: x> notetag.
 * @default []
 *
 */
/* ----------------------------------------------------------------------------
 * Item Name Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ItemName:
 *
 * @param Name:str
 * @text Name
 * @desc Name of this Voice Set. The name will be used as the name
 * for the <Voice Set: name> notetag.
 * @default Untitled
 * 
 * @param ItemName
 * @text Item Names
 *
 * @param ItemNameA:arraystr
 * @text Item Name A
 * @parent ItemName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Item Name: x> notetag.
 * @default []
 *
 * @param ItemNameB:arraystr
 * @text Item Name B
 * @parent ItemName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Item Name: x> notetag.
 * @default []
 *
 * @param ItemNameC:arraystr
 * @text Item Name C
 * @parent ItemName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Item Name: x> notetag.
 * @default []
 *
 * @param ItemNameD:arraystr
 * @text Item Name D
 * @parent ItemName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Item Name: x> notetag.
 * @default []
 *
 * @param ItemNameE:arraystr
 * @text Item Name E
 * @parent ItemName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Item Name: x> notetag.
 * @default []
 *
 * @param ItemNameF:arraystr
 * @text Item Name F
 * @parent ItemName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Item Name: x> notetag.
 * @default []
 *
 * @param ItemNameG:arraystr
 * @text Item Name G
 * @parent ItemName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Item Name: x> notetag.
 * @default []
 *
 * @param ItemNameH:arraystr
 * @text Item Name H
 * @parent ItemName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Item Name: x> notetag.
 * @default []
 *
 * @param ItemNameI:arraystr
 * @text Item Name I
 * @parent ItemName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Item Name: x> notetag.
 * @default []
 *
 * @param ItemNameJ:arraystr
 * @text Item Name J
 * @parent ItemName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Item Name: x> notetag.
 * @default []
 *
 * @param ItemNameK:arraystr
 * @text Item Name K
 * @parent ItemName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Item Name: x> notetag.
 * @default []
 *
 * @param ItemNameL:arraystr
 * @text Item Name L
 * @parent ItemName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Item Name: x> notetag.
 * @default []
 *
 * @param ItemNameM:arraystr
 * @text Item Name M
 * @parent ItemName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Item Name: x> notetag.
 * @default []
 *
 * @param ItemNameN:arraystr
 * @text Item Name N
 * @parent ItemName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Item Name: x> notetag.
 * @default []
 *
 * @param ItemNameO:arraystr
 * @text Item Name O
 * @parent ItemName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Item Name: x> notetag.
 * @default []
 *
 * @param ItemNameP:arraystr
 * @text Item Name P
 * @parent ItemName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Item Name: x> notetag.
 * @default []
 *
 * @param ItemNameQ:arraystr
 * @text Item Name Q
 * @parent ItemName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Item Name: x> notetag.
 * @default []
 *
 * @param ItemNameR:arraystr
 * @text Item Name R
 * @parent ItemName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Item Name: x> notetag.
 * @default []
 *
 * @param ItemNameS:arraystr
 * @text Item Name S
 * @parent ItemName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Item Name: x> notetag.
 * @default []
 *
 * @param ItemNameT:arraystr
 * @text Item Name T
 * @parent ItemName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Item Name: x> notetag.
 * @default []
 *
 * @param ItemNameU:arraystr
 * @text Item Name U
 * @parent ItemName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Item Name: x> notetag.
 * @default []
 *
 * @param ItemNameV:arraystr
 * @text Item Name V
 * @parent ItemName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Item Name: x> notetag.
 * @default []
 *
 * @param ItemNameW:arraystr
 * @text Item Name W
 * @parent ItemName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Item Name: x> notetag.
 * @default []
 *
 * @param ItemNameX:arraystr
 * @text Item Name X
 * @parent ItemName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Item Name: x> notetag.
 * @default []
 *
 * @param ItemNameY:arraystr
 * @text Item Name Y
 * @parent ItemName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Item Name: x> notetag.
 * @default []
 *
 * @param ItemNameZ:arraystr
 * @text Item Name Z
 * @parent ItemName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Item Name: x> notetag.
 * @default []
 *
 */
/* ----------------------------------------------------------------------------
 * Skill Name Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~SkillName:
 *
 * @param Name:str
 * @text Name
 * @desc Name of this Voice Set. The name will be used as the name
 * for the <Voice Set: name> notetag.
 * @default Untitled
 * 
 * @param SkillName
 * @text Skill Names
 *
 * @param SkillNameA:arraystr
 * @text Skill Name A
 * @parent SkillName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Skill Name: x> notetag.
 * @default []
 *
 * @param SkillNameB:arraystr
 * @text Skill Name B
 * @parent SkillName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Skill Name: x> notetag.
 * @default []
 *
 * @param SkillNameC:arraystr
 * @text Skill Name C
 * @parent SkillName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Skill Name: x> notetag.
 * @default []
 *
 * @param SkillNameD:arraystr
 * @text Skill Name D
 * @parent SkillName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Skill Name: x> notetag.
 * @default []
 *
 * @param SkillNameE:arraystr
 * @text Skill Name E
 * @parent SkillName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Skill Name: x> notetag.
 * @default []
 *
 * @param SkillNameF:arraystr
 * @text Skill Name F
 * @parent SkillName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Skill Name: x> notetag.
 * @default []
 *
 * @param SkillNameG:arraystr
 * @text Skill Name G
 * @parent SkillName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Skill Name: x> notetag.
 * @default []
 *
 * @param SkillNameH:arraystr
 * @text Skill Name H
 * @parent SkillName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Skill Name: x> notetag.
 * @default []
 *
 * @param SkillNameI:arraystr
 * @text Skill Name I
 * @parent SkillName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Skill Name: x> notetag.
 * @default []
 *
 * @param SkillNameJ:arraystr
 * @text Skill Name J
 * @parent SkillName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Skill Name: x> notetag.
 * @default []
 *
 * @param SkillNameK:arraystr
 * @text Skill Name K
 * @parent SkillName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Skill Name: x> notetag.
 * @default []
 *
 * @param SkillNameL:arraystr
 * @text Skill Name L
 * @parent SkillName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Skill Name: x> notetag.
 * @default []
 *
 * @param SkillNameM:arraystr
 * @text Skill Name M
 * @parent SkillName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Skill Name: x> notetag.
 * @default []
 *
 * @param SkillNameN:arraystr
 * @text Skill Name N
 * @parent SkillName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Skill Name: x> notetag.
 * @default []
 *
 * @param SkillNameO:arraystr
 * @text Skill Name O
 * @parent SkillName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Skill Name: x> notetag.
 * @default []
 *
 * @param SkillNameP:arraystr
 * @text Skill Name P
 * @parent SkillName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Skill Name: x> notetag.
 * @default []
 *
 * @param SkillNameQ:arraystr
 * @text Skill Name Q
 * @parent SkillName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Skill Name: x> notetag.
 * @default []
 *
 * @param SkillNameR:arraystr
 * @text Skill Name R
 * @parent SkillName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Skill Name: x> notetag.
 * @default []
 *
 * @param SkillNameS:arraystr
 * @text Skill Name S
 * @parent SkillName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Skill Name: x> notetag.
 * @default []
 *
 * @param SkillNameT:arraystr
 * @text Skill Name T
 * @parent SkillName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Skill Name: x> notetag.
 * @default []
 *
 * @param SkillNameU:arraystr
 * @text Skill Name U
 * @parent SkillName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Skill Name: x> notetag.
 * @default []
 *
 * @param SkillNameV:arraystr
 * @text Skill Name V
 * @parent SkillName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Skill Name: x> notetag.
 * @default []
 *
 * @param SkillNameW:arraystr
 * @text Skill Name W
 * @parent SkillName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Skill Name: x> notetag.
 * @default []
 *
 * @param SkillNameX:arraystr
 * @text Skill Name X
 * @parent SkillName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Skill Name: x> notetag.
 * @default []
 *
 * @param SkillNameY:arraystr
 * @text Skill Name Y
 * @parent SkillName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Skill Name: x> notetag.
 * @default []
 *
 * @param SkillNameZ:arraystr
 * @text Skill Name Z
 * @parent SkillName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Skill Name: x> notetag.
 * @default []
 *
 */
/* ----------------------------------------------------------------------------
 * Spell Name Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~SpellName:
 *
 * @param Name:str
 * @text Name
 * @desc Name of this Voice Set. The name will be used as the name
 * for the <Voice Set: name> notetag.
 * @default Untitled
 * 
 * @param SpellName
 * @text Spell Names
 *
 * @param SpellNameA:arraystr
 * @text Spell Name A
 * @parent SpellName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Spell Name: x> notetag.
 * @default []
 *
 * @param SpellNameB:arraystr
 * @text Spell Name B
 * @parent SpellName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Spell Name: x> notetag.
 * @default []
 *
 * @param SpellNameC:arraystr
 * @text Spell Name C
 * @parent SpellName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Spell Name: x> notetag.
 * @default []
 *
 * @param SpellNameD:arraystr
 * @text Spell Name D
 * @parent SpellName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Spell Name: x> notetag.
 * @default []
 *
 * @param SpellNameE:arraystr
 * @text Spell Name E
 * @parent SpellName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Spell Name: x> notetag.
 * @default []
 *
 * @param SpellNameF:arraystr
 * @text Spell Name F
 * @parent SpellName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Spell Name: x> notetag.
 * @default []
 *
 * @param SpellNameG:arraystr
 * @text Spell Name G
 * @parent SpellName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Spell Name: x> notetag.
 * @default []
 *
 * @param SpellNameH:arraystr
 * @text Spell Name H
 * @parent SpellName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Spell Name: x> notetag.
 * @default []
 *
 * @param SpellNameI:arraystr
 * @text Spell Name I
 * @parent SpellName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Spell Name: x> notetag.
 * @default []
 *
 * @param SpellNameJ:arraystr
 * @text Spell Name J
 * @parent SpellName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Spell Name: x> notetag.
 * @default []
 *
 * @param SpellNameK:arraystr
 * @text Spell Name K
 * @parent SpellName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Spell Name: x> notetag.
 * @default []
 *
 * @param SpellNameL:arraystr
 * @text Spell Name L
 * @parent SpellName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Spell Name: x> notetag.
 * @default []
 *
 * @param SpellNameM:arraystr
 * @text Spell Name M
 * @parent SpellName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Spell Name: x> notetag.
 * @default []
 *
 * @param SpellNameN:arraystr
 * @text Spell Name N
 * @parent SpellName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Spell Name: x> notetag.
 * @default []
 *
 * @param SpellNameO:arraystr
 * @text Spell Name O
 * @parent SpellName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Spell Name: x> notetag.
 * @default []
 *
 * @param SpellNameP:arraystr
 * @text Spell Name P
 * @parent SpellName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Spell Name: x> notetag.
 * @default []
 *
 * @param SpellNameQ:arraystr
 * @text Spell Name Q
 * @parent SpellName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Spell Name: x> notetag.
 * @default []
 *
 * @param SpellNameR:arraystr
 * @text Spell Name R
 * @parent SpellName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Spell Name: x> notetag.
 * @default []
 *
 * @param SpellNameS:arraystr
 * @text Spell Name S
 * @parent SpellName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Spell Name: x> notetag.
 * @default []
 *
 * @param SpellNameT:arraystr
 * @text Spell Name T
 * @parent SpellName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Spell Name: x> notetag.
 * @default []
 *
 * @param SpellNameU:arraystr
 * @text Spell Name U
 * @parent SpellName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Spell Name: x> notetag.
 * @default []
 *
 * @param SpellNameV:arraystr
 * @text Spell Name V
 * @parent SpellName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Spell Name: x> notetag.
 * @default []
 *
 * @param SpellNameW:arraystr
 * @text Spell Name W
 * @parent SpellName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Spell Name: x> notetag.
 * @default []
 *
 * @param SpellNameX:arraystr
 * @text Spell Name X
 * @parent SpellName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Spell Name: x> notetag.
 * @default []
 *
 * @param SpellNameY:arraystr
 * @text Spell Name Y
 * @parent SpellName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Spell Name: x> notetag.
 * @default []
 *
 * @param SpellNameZ:arraystr
 * @text Spell Name Z
 * @parent SpellName
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for <Voice Spell Name: x> notetag.
 * @default []
 *
 */
/* ----------------------------------------------------------------------------
 * Unique Line Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~UniqueLine:
 *
 * @param Name:str
 * @text Name
 * @desc Name of this Voice Set. The name will be used as the name
 * for the <Voice Set: name> notetag.
 * @default Untitled
 * 
 * @param Unique
 * @text Unique Lines
 *
 * @param UniqueLineA:arraystr
 * @text Unique Line A
 * @parent Unique
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for Plugin Commands.
 * @default []
 *
 * @param UniqueLineB:arraystr
 * @text Unique Line B
 * @parent Unique
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for Plugin Commands.
 * @default []
 *
 * @param UniqueLineC:arraystr
 * @text Unique Line C
 * @parent Unique
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for Plugin Commands.
 * @default []
 *
 * @param UniqueLineD:arraystr
 * @text Unique Line D
 * @parent Unique
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for Plugin Commands.
 * @default []
 *
 * @param UniqueLineE:arraystr
 * @text Unique Line E
 * @parent Unique
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for Plugin Commands.
 * @default []
 *
 * @param UniqueLineF:arraystr
 * @text Unique Line F
 * @parent Unique
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for Plugin Commands.
 * @default []
 *
 * @param UniqueLineG:arraystr
 * @text Unique Line G
 * @parent Unique
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for Plugin Commands.
 * @default []
 *
 * @param UniqueLineH:arraystr
 * @text Unique Line H
 * @parent Unique
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for Plugin Commands.
 * @default []
 *
 * @param UniqueLineI:arraystr
 * @text Unique Line I
 * @parent Unique
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for Plugin Commands.
 * @default []
 *
 * @param UniqueLineJ:arraystr
 * @text Unique Line J
 * @parent Unique
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for Plugin Commands.
 * @default []
 *
 * @param UniqueLineK:arraystr
 * @text Unique Line K
 * @parent Unique
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for Plugin Commands.
 * @default []
 *
 * @param UniqueLineL:arraystr
 * @text Unique Line L
 * @parent Unique
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for Plugin Commands.
 * @default []
 *
 * @param UniqueLineM:arraystr
 * @text Unique Line M
 * @parent Unique
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for Plugin Commands.
 * @default []
 *
 * @param UniqueLineN:arraystr
 * @text Unique Line N
 * @parent Unique
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for Plugin Commands.
 * @default []
 *
 * @param UniqueLineO:arraystr
 * @text Unique Line O
 * @parent Unique
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for Plugin Commands.
 * @default []
 *
 * @param UniqueLineP:arraystr
 * @text Unique Line P
 * @parent Unique
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for Plugin Commands.
 * @default []
 *
 * @param UniqueLineQ:arraystr
 * @text Unique Line Q
 * @parent Unique
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for Plugin Commands.
 * @default []
 *
 * @param UniqueLineR:arraystr
 * @text Unique Line R
 * @parent Unique
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for Plugin Commands.
 * @default []
 *
 * @param UniqueLineS:arraystr
 * @text Unique Line S
 * @parent Unique
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for Plugin Commands.
 * @default []
 *
 * @param UniqueLineT:arraystr
 * @text Unique Line T
 * @parent Unique
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for Plugin Commands.
 * @default []
 *
 * @param UniqueLineU:arraystr
 * @text Unique Line U
 * @parent Unique
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for Plugin Commands.
 * @default []
 *
 * @param UniqueLineV:arraystr
 * @text Unique Line V
 * @parent Unique
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for Plugin Commands.
 * @default []
 *
 * @param UniqueLineW:arraystr
 * @text Unique Line W
 * @parent Unique
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for Plugin Commands.
 * @default []
 *
 * @param UniqueLineX:arraystr
 * @text Unique Line X
 * @parent Unique
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for Plugin Commands.
 * @default []
 *
 * @param UniqueLineY:arraystr
 * @text Unique Line Y
 * @parent Unique
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for Plugin Commands.
 * @default []
 *
 * @param UniqueLineZ:arraystr
 * @text Unique Line Z
 * @parent Unique
 * @type file[]
 * @dir audio/se/
 * @require 1
 * @desc Filename of the voice sound file to speak.
 * Used for Plugin Commands.
 * @default []
 *
 */
/* ----------------------------------------------------------------------------
 * Options Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Options:
 *
 * @param Options
 * @text Options
 *
 * @param AddOption:eval
 * @text Add Option?
 * @parent Options
 * @type boolean
 * @on Add
 * @off Don't Add
 * @desc Add the 'Battle Voices' option to the Options menu?
 * @default true
 *
 * @param AdjustRect:eval
 * @text Adjust Window Height
 * @parent Options
 * @type boolean
 * @on Adjust
 * @off Don't
 * @desc Automatically adjust the options window height?
 * @default true
 *
 * @param Name:str
 * @text Option Name
 * @parent Options
 * @desc Command name of the option.
 * @default Battle Voices
 *
 */
/* ----------------------------------------------------------------------------
 * Voice Language Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~VoiceLang:
 *
 * @param Bengali:str
 * @text Bengali
 * @desc What voice set is played with this voice language?
 * @default
 * 
 * @param Chinese:str
 * @text Chinese
 * @desc What voice set is played with this voice language?
 * @default
 * 
 * @param Czech:str
 * @text Czech
 * @desc What voice set is played with this voice language?
 * @default
 * 
 * @param Danish:str
 * @text Danish
 * @desc What voice set is played with this voice language?
 * @default
 * 
 * @param Dutch:str
 * @text Dutch
 * @desc What voice set is played with this voice language?
 * @default
 * 
 * @param English:str
 * @text English
 * @desc What voice set is played with this voice language?
 * @default
 * 
 * @param Finnish:str
 * @text Finnish
 * @desc What voice set is played with this voice language?
 * @default
 * 
 * @param French:str
 * @text French
 * @desc What voice set is played with this voice language?
 * @default
 * 
 * @param German:str
 * @text German
 * @desc What voice set is played with this voice language?
 * @default
 * 
 * @param Greek:str
 * @text Greek
 * @desc What voice set is played with this voice language?
 * @default
 * 
 * @param Hindi:str
 * @text Hindi
 * @desc What voice set is played with this voice language?
 * @default
 * 
 * @param Hungarian:str
 * @text Hungarian
 * @desc What voice set is played with this voice language?
 * @default
 * 
 * @param Indonesian:str
 * @text Indonesian
 * @desc What voice set is played with this voice language?
 * @default
 * 
 * @param Italian:str
 * @text Italian
 * @desc What voice set is played with this voice language?
 * @default
 * 
 * @param Japanese:str
 * @text Japanese
 * @desc What voice set is played with this voice language?
 * @default
 * 
 * @param Korean:str
 * @text Korean
 * @desc What voice set is played with this voice language?
 * @default
 * 
 * @param Norwegian:str
 * @text Norwegian
 * @desc What voice set is played with this voice language?
 * @default
 * 
 * @param Polish:str
 * @text Polish
 * @desc What voice set is played with this voice language?
 * @default
 * 
 * @param Portuguese:str
 * @text Portuguese
 * @desc What voice set is played with this voice language?
 * @default
 * 
 * @param Romanian:str
 * @text Romanian
 * @desc What voice set is played with this voice language?
 * @default
 * 
 * @param Russian:str
 * @text Russian
 * @desc What voice set is played with this voice language?
 * @default
 * 
 * @param Slovak:str
 * @text Slovak
 * @desc What voice set is played with this voice language?
 * @default
 * 
 * @param Spanish:str
 * @text Spanish
 * @desc What voice set is played with this voice language?
 * @default
 * 
 * @param Swedish:str
 * @text Swedish
 * @desc What voice set is played with this voice language?
 * @default
 * 
 * @param Tamil:str
 * @text Tamil
 * @desc What voice set is played with this voice language?
 * @default
 * 
 * @param Thai:str
 * @text Thai
 * @desc What voice set is played with this voice language?
 * @default
 * 
 * @param Turkish:str
 * @text Turkish
 * @desc What voice set is played with this voice language?
 * @default
 *
 */
//=============================================================================

const _0x2f7f84=_0x416a;(function(_0x364e0a,_0x2be0cc){const _0x17871f=_0x416a,_0x522fb0=_0x364e0a();while(!![]){try{const _0x32a13f=-parseInt(_0x17871f(0x310))/0x1+parseInt(_0x17871f(0x224))/0x2+parseInt(_0x17871f(0x263))/0x3+-parseInt(_0x17871f(0x280))/0x4+-parseInt(_0x17871f(0x22d))/0x5+parseInt(_0x17871f(0x238))/0x6*(-parseInt(_0x17871f(0x246))/0x7)+-parseInt(_0x17871f(0x29b))/0x8*(-parseInt(_0x17871f(0x21f))/0x9);if(_0x32a13f===_0x2be0cc)break;else _0x522fb0['push'](_0x522fb0['shift']());}catch(_0x1dfc6d){_0x522fb0['push'](_0x522fb0['shift']());}}}(_0x4bf7,0xbf766));var label=_0x2f7f84(0x24f),tier=tier||0x0,dependencies=[_0x2f7f84(0x2ff),_0x2f7f84(0x26a)],pluginData=$plugins[_0x2f7f84(0x218)](function(_0x78269){const _0x5b60c1=_0x2f7f84;return _0x78269[_0x5b60c1(0x231)]&&_0x78269['description'][_0x5b60c1(0x2d5)]('['+label+']');})[0x0];function _0x416a(_0x2ea575,_0x3c3478){const _0x4bf7f2=_0x4bf7();return _0x416a=function(_0x416a95,_0x5aa835){_0x416a95=_0x416a95-0x1e5;let _0x428e10=_0x4bf7f2[_0x416a95];return _0x428e10;},_0x416a(_0x2ea575,_0x3c3478);}function _0x4bf7(){const _0x29d18c=['_getSkillHaveVoiceChantLine','BattleManager_onEscapeSuccess','performSubstitute','clamp','Battle\x20Voices','ConfigManager_applyData','SpellName','_getTraitVoiceSets','isActor','evaded','EYvsq','Override','Recover','Damage','VisuMZ_0_CoreEngine','VCvER','UEbcW','Settings','pdikZ','isVisuMzLocalizationEnabled','aliveMembers','randomInt','set','ActorChangeBattleVoiceSet','PSiGi','exit','_getSkillHaveVoiceSpellName','frameCount','_phase','removeStateVoice','qnkSG','398029WOBxbm','performAction','playBattleVoice','removeStatesAuto','addStateVoice','performAttack','State','BattleInput','Game_Battler_addDebuff','pitch','setupBattleVoice','startBattle','nTlTH','changeBattleVoicePan','destroy','Heavy','ActionResultReflection','isSceneBattle','BqKLV','getSkillHaveVoiceSkillName','VoiceSets','onEscapeFailure','Physical','Neutral','Game_Battler_performMiss','removeBuffsAuto','JnmrL','TraitVoiceSet','_battleVoiceFrameCount','isMagical','isInputting','isCertainHit','BattleManager_startBattle','FKrmc','onEscapeSuccess','isSkill','Game_Battler_removeState','performMagicEvasion','enemy','AiTXh','ActionResultCounter','addGeneralOptions','UmTmi','addDebuff','_subject','_getSkillHaveVoiceItemName','subject','ActionResultEvasion','BasicGuard','AllowSelfResponse','Enemy','Window_ActorCommand_setup','getSkillHaveVoiceChantLine','PerformActionBasicAttack','changeBattleVoiceSet','wGWwi','in\x20order\x20for\x20VisuMZ_3_BattleVoices\x20to\x20work.','xNMcF','FuSJQ','Game_BattlerBase_setHp','pMecg','VisuMZ_2_VoiceActControl','VoiceVolume','filter','VisuMZ_1_BattleCore\x20needs\x20to\x20be\x20updated\x20','DamageNone','_getSkillHaveVoiceSkillName','NUM','match','languages','7858476IrFBCJ','setHp','eWUVl','removeState','JSON','845686zDPMRR','setupBattleVoiceForTraits','getSkillHaveVoiceItemName','Death','PerformActionMiss','Game_Action_apply','allowSelfResponseVoice','Game_Battler_performEvasion','performReflection','5153445ZYvvac','%1\x20is\x20missing\x20a\x20required\x20plugin.\x0aPlease\x20install\x20%2\x20into\x20the\x20Plugin\x20Manager.','VisuMZ_1_SkillsStatesCore','isForEveryone','status','getVoiceSet','Game_Battler_removeBuff','BattleEscapeFailure','BattleCore','qiSih','battleVoices','3437436QzCbgf','changeBattleVoiceLangSet','_hp','doesSkillHaveVoiceActionName','_voiceBuffers','getBattleVoiceData','ActionStart','pan','_expireStatesAuto','return\x200','%1\x27s\x20version\x20does\x20not\x20match\x20plugin\x27s.\x20Please\x20update\x20it\x20in\x20the\x20Plugin\x20Manager.','canPlayDifferentLanguageBattleVoices','version','%1\x20is\x20incorrectly\x20placed\x20on\x20the\x20plugin\x20list.\x0aIt\x20is\x20a\x20Tier\x20%2\x20plugin\x20placed\x20over\x20other\x20Tier\x20%3\x20plugins.\x0aPlease\x20reorder\x20the\x20plugin\x20list\x20from\x20smallest\x20to\x20largest\x20tier\x20numbers.','7WJJoVg','Game_Actor_performAttack','actor','ItemNames','Game_Battler_performMagicEvasion','custom','Negative','rbycy','PerformActionDefeatFoe','BattleVoices','Game_Actor_setup','registerCommand','ActionResultSubstitute','ActionNames','addBuff','svsVE','result','log','ARRAYEVAL','performCounter','Game_Battler_performReflection','getTraitVoiceSets','playSe','VoiceSet','STRUCT','isAttack','wWhAD','trim','setup','4495272mZjejz','applyGameActionVoice','AddOption','Game_Enemy_performAttack','DrkPV','Window_Options_addGeneralOptions','Pan','VisuMZ_1_BattleCore','Language','doesSkillHaveVoiceItemName','Ally','GTLMm','find','traitSet','_getSkillHaveVoiceActionName','readFlag','Game_Battler_performActionStart','battlerKey','CertainHit','STR','FUNC','getSkillHaveVoiceSpellName','BattleStart','performActionStartVoice','name','addBattleVoicesCommand','ActionResultMagicEvasion','performActionVoice','DebuffRemove','3526964EjoCYr','ActorID','BattleManager_processVictory','max','Magical','Game_Battler_performAction','hVptl','ConvertParams','prototype','Skill','playVoiceLine','Medium','_expireBuffsAuto','Scene_Options_maxCommands','applyData','awGWb','Guard','Name','hzDVP','onDatabaseLoaded','note','parameters','zSzRd','makeData','process_VisuMZ_BattleVoices','isItem','performMiss','16falqFU','BuffAdd','LangVoiceSet','Game_Battler_removeBuffsAuto','AdjustRect','_seBuffers','UeOhP','action','LLslr','performHpChangeVoice','VoicePan','parse','Add','ARRAYSTR','ConfigManager_makeData','Game_Battler_performSubstitute','_defeatedTargetsVoiced','remove','mhp','evRdk','ChantLines','Game_Battler_addState','applyLatestBufferBattlerKey','BIVRU','SkillName','processVictory','pwoDR','ChantLine','BATTLE_VOICE_DEBUG','_currentActor','EVAL','hasBattleVoiceKey','SubElement','RegExp','isGuard','RSrbS','Light','changeBattleVoiceVolume','toUpperCase','VoicePitch','getSkillHaveVoiceActionName','removeBuff','Scene_Boot_onDatabaseLoaded','push','ItemName','xXduk','voiceLocale','PerformActionCritical','performEvasion','addState','clearBattleVoice','nqvno','jBNPb','KafVl','StASq','performActionStartBaseVoice','hXmxb','BuffRemove','includes','UNTITLED','missed','changeBattleVoicePitch','SpellNames','doesSkillHaveVoiceSkillName','oQWAz','bEVID','VisuMZ_1_ElementStatusCore','Remove','volume','critical','BattleEscapeSuccess','MoWwr','BattleVictory','Options','xwTpe','_battleVoice','call','format','maxCommands','item','doesSkillHaveVoiceChantLine','doesSkillHaveVoiceSpellName','Positive','DebuffAdd','length','map'];_0x4bf7=function(){return _0x29d18c;};return _0x4bf7();}VisuMZ[label][_0x2f7f84(0x302)]=VisuMZ[label][_0x2f7f84(0x302)]||{},VisuMZ['ConvertParams']=function(_0x2cf7bf,_0xbc0146){const _0x4e32d7=_0x2f7f84;for(const _0x53a00e in _0xbc0146){if(_0x53a00e[_0x4e32d7(0x21d)](/(.*):(.*)/i)){if('XAnKQ'!==_0x4e32d7(0x296)){const _0x41c0c1=String(RegExp['$1']),_0xdb0b23=String(RegExp['$2'])[_0x4e32d7(0x2c1)]()[_0x4e32d7(0x261)]();let _0x214a74,_0x5d244f,_0x291150;switch(_0xdb0b23){case _0x4e32d7(0x21c):_0x214a74=_0xbc0146[_0x53a00e]!==''?Number(_0xbc0146[_0x53a00e]):0x0;break;case'ARRAYNUM':_0x5d244f=_0xbc0146[_0x53a00e]!==''?JSON['parse'](_0xbc0146[_0x53a00e]):[],_0x214a74=_0x5d244f[_0x4e32d7(0x2f0)](_0x243ba9=>Number(_0x243ba9));break;case _0x4e32d7(0x2b9):_0x214a74=_0xbc0146[_0x53a00e]!==''?eval(_0xbc0146[_0x53a00e]):null;break;case _0x4e32d7(0x258):_0x5d244f=_0xbc0146[_0x53a00e]!==''?JSON['parse'](_0xbc0146[_0x53a00e]):[],_0x214a74=_0x5d244f['map'](_0x3909ec=>eval(_0x3909ec));break;case _0x4e32d7(0x223):_0x214a74=_0xbc0146[_0x53a00e]!==''?JSON[_0x4e32d7(0x2a6)](_0xbc0146[_0x53a00e]):'';break;case'ARRAYJSON':_0x5d244f=_0xbc0146[_0x53a00e]!==''?JSON[_0x4e32d7(0x2a6)](_0xbc0146[_0x53a00e]):[],_0x214a74=_0x5d244f[_0x4e32d7(0x2f0)](_0x403c6a=>JSON[_0x4e32d7(0x2a6)](_0x403c6a));break;case _0x4e32d7(0x277):_0x214a74=_0xbc0146[_0x53a00e]!==''?new Function(JSON[_0x4e32d7(0x2a6)](_0xbc0146[_0x53a00e])):new Function(_0x4e32d7(0x241));break;case'ARRAYFUNC':_0x5d244f=_0xbc0146[_0x53a00e]!==''?JSON[_0x4e32d7(0x2a6)](_0xbc0146[_0x53a00e]):[],_0x214a74=_0x5d244f[_0x4e32d7(0x2f0)](_0x3c2b1d=>new Function(JSON[_0x4e32d7(0x2a6)](_0x3c2b1d)));break;case _0x4e32d7(0x276):_0x214a74=_0xbc0146[_0x53a00e]!==''?String(_0xbc0146[_0x53a00e]):'';break;case _0x4e32d7(0x2a8):_0x5d244f=_0xbc0146[_0x53a00e]!==''?JSON[_0x4e32d7(0x2a6)](_0xbc0146[_0x53a00e]):[],_0x214a74=_0x5d244f['map'](_0x163906=>String(_0x163906));break;case _0x4e32d7(0x25e):_0x291150=_0xbc0146[_0x53a00e]!==''?JSON[_0x4e32d7(0x2a6)](_0xbc0146[_0x53a00e]):{},_0x214a74=VisuMZ['ConvertParams']({},_0x291150);break;case'ARRAYSTRUCT':_0x5d244f=_0xbc0146[_0x53a00e]!==''?JSON[_0x4e32d7(0x2a6)](_0xbc0146[_0x53a00e]):[],_0x214a74=_0x5d244f[_0x4e32d7(0x2f0)](_0x229511=>VisuMZ['ConvertParams']({},JSON['parse'](_0x229511)));break;default:continue;}_0x2cf7bf[_0x41c0c1]=_0x214a74;}else{_0x4f4e83[_0x4e32d7(0x24f)][_0x4e32d7(0x229)][_0x4e32d7(0x2e7)](this,_0x4eda9c);if(!_0xed963c[_0x4e32d7(0x1ea)]())return;if(!_0x1e2d7a[_0x4e32d7(0x205)])return;if(!_0x37f282)return;this[_0x4e32d7(0x207)]()[_0x4e32d7(0x264)](this,_0x5ed1d9);}}}return _0x2cf7bf;},(_0x185200=>{const _0x3463b9=_0x2f7f84,_0x4b0ee1=_0x185200[_0x3463b9(0x27b)];for(const _0x385bca of dependencies){if(!Imported[_0x385bca]){alert(_0x3463b9(0x22e)['format'](_0x4b0ee1,_0x385bca)),SceneManager[_0x3463b9(0x30a)]();break;}}const _0x5554ee=_0x185200['description'];if(_0x5554ee[_0x3463b9(0x21d)](/\[Version[ ](.*?)\]/i)){const _0x446af0=Number(RegExp['$1']);_0x446af0!==VisuMZ[label][_0x3463b9(0x244)]&&(alert(_0x3463b9(0x242)[_0x3463b9(0x2e8)](_0x4b0ee1,_0x446af0)),SceneManager[_0x3463b9(0x30a)]());}if(_0x5554ee[_0x3463b9(0x21d)](/\[Tier[ ](\d+)\]/i)){if(_0x3463b9(0x267)!=='SQgcI'){const _0x590637=Number(RegExp['$1']);if(_0x590637<tier){if(_0x3463b9(0x1e5)!==_0x3463b9(0x255))alert(_0x3463b9(0x245)[_0x3463b9(0x2e8)](_0x4b0ee1,_0x590637,tier)),SceneManager['exit']();else{if(this[_0x3463b9(0x2e6)]===_0x1e0e51)this[_0x3463b9(0x31a)]();this[_0x3463b9(0x2e6)]['set']=_0x1a3670;}}else tier=Math[_0x3463b9(0x283)](_0x590637,tier);}else _0x38f212[_0x3463b9(0x312)](_0x3463b9(0x234));}VisuMZ[_0x3463b9(0x287)](VisuMZ[label][_0x3463b9(0x302)],_0x185200[_0x3463b9(0x295)]);})(pluginData);if(VisuMZ[_0x2f7f84(0x235)][_0x2f7f84(0x244)]<1.77){let text='';text+=_0x2f7f84(0x219),text+=_0x2f7f84(0x211),alert(text),SceneManager[_0x2f7f84(0x30a)]();}PluginManager[_0x2f7f84(0x251)](pluginData[_0x2f7f84(0x27b)],_0x2f7f84(0x308),_0x3e764a=>{const _0x4a152d=_0x2f7f84;VisuMZ[_0x4a152d(0x287)](_0x3e764a,_0x3e764a);const _0xa42a2f=_0x3e764a[_0x4a152d(0x281)]||0x1,_0x148ffa=_0x3e764a['VoiceSet']||'',_0x23cc31=Number(_0x3e764a['volume']||0x0)['clamp'](0x0,0x64),_0x9c2511=Math[_0x4a152d(0x283)](Number(_0x3e764a['pitch']||0x0),0x0),_0x3e2bd9=Number(_0x3e764a['Pan']),_0x40c4e3=$gameActors[_0x4a152d(0x248)](_0xa42a2f);_0x40c4e3&&('opmJR'==='opmJR'?(_0x40c4e3[_0x4a152d(0x20f)](_0x148ffa),_0x40c4e3[_0x4a152d(0x2c0)](_0x23cc31),_0x40c4e3[_0x4a152d(0x2d8)](_0x9c2511),_0x40c4e3[_0x4a152d(0x1e6)](_0x3e2bd9)):_0x4a1b9c[_0x4b6c4d]=_0x1c0364[_0x135ac7]);}),PluginManager[_0x2f7f84(0x251)](pluginData[_0x2f7f84(0x27b)],'ActorChangeBattleVoiceSetLang',_0x120836=>{const _0x853d51=_0x2f7f84;VisuMZ[_0x853d51(0x287)](_0x120836,_0x120836);const _0x50d1b8=_0x120836[_0x853d51(0x281)]||0x1,_0x3d9e31=_0x120836[_0x853d51(0x25d)]||'',_0x2d1b80=Number(_0x120836[_0x853d51(0x2df)]||0x0)[_0x853d51(0x2f4)](0x0,0x64),_0x2e54f8=Math[_0x853d51(0x283)](Number(_0x120836[_0x853d51(0x319)]||0x0),0x0),_0x3b69b4=Number(_0x120836[_0x853d51(0x269)]),_0x1cdebf={},_0x397db2=_0x120836[_0x853d51(0x26b)]||{};for(const _0x5816d2 in _0x397db2){_0x1cdebf[_0x5816d2]=_0x397db2[_0x5816d2];}const _0x5f0f16=$gameActors[_0x853d51(0x248)](_0x50d1b8);_0x5f0f16&&('xNMcF'===_0x853d51(0x212)?(_0x5f0f16[_0x853d51(0x20f)](_0x3d9e31),_0x5f0f16[_0x853d51(0x2c0)](_0x2d1b80),_0x5f0f16['changeBattleVoicePitch'](_0x2e54f8),_0x5f0f16[_0x853d51(0x1e6)](_0x3b69b4),_0x5f0f16[_0x853d51(0x239)](_0x1cdebf)):(_0x5d8cc8[_0x853d51(0x24f)][_0x853d51(0x1f9)][_0x853d51(0x2e7)](this),_0x28f7c2[_0x853d51(0x312)](_0x853d51(0x279))));}),VisuMZ[_0x2f7f84(0x24f)]['RegExp']={'VoiceSet':/<VOICE(?:|SET| SET):[ ](.*?)>/i,'LangVoiceSet':/<(?:LANG|LANGUAGE)[ ](.*?)[ ]VOICE(?:|SET| SET):[ ](.*?)>/gi,'VoiceVolume':/<VOICE(?:|SET| SET) VOLUME:[ ](\d+)>/i,'VoicePitch':/<VOICE(?:|SET| SET) PITCH:[ ](\d+)>/i,'VoicePan':/<VOICE(?:|SET| SET) PAN:[ ](.*?)>/i,'ActionName':/<VOICE ACTION(?:|NAME| NAME):[ ](.*?)>/i,'ChantLine':/<VOICE CHANT(?:|LINE| LINE):[ ](.*?)>/i,'ItemName':/<VOICE ITEM(?:|NAME| NAME):[ ](.*?)>/i,'SkillName':/<VOICE SKILL(?:|NAME| NAME):[ ](.*?)>/i,'SpellName':/<VOICE SPELL(?:|NAME| NAME):[ ](.*?)>/i,'TraitVoiceSet':/<TRAIT VOICE(?:|SET| SET)(?:|S)>\s*([\s\S]*?)\s*<\/TRAIT VOICE(?:|SET| SET)(?:|S)>/i},VisuMZ[_0x2f7f84(0x24f)]['Scene_Boot_onDatabaseLoaded']=Scene_Boot[_0x2f7f84(0x288)][_0x2f7f84(0x293)],Scene_Boot[_0x2f7f84(0x288)][_0x2f7f84(0x293)]=function(){const _0x4c59be=_0x2f7f84;VisuMZ['BattleVoices'][_0x4c59be(0x2c5)][_0x4c59be(0x2e7)](this),this[_0x4c59be(0x298)]();},VisuMZ[_0x2f7f84(0x24f)][_0x2f7f84(0x25d)]={},Scene_Boot[_0x2f7f84(0x288)]['process_VisuMZ_BattleVoices']=function(){const _0x26b022=_0x2f7f84,_0xa65891=VisuMZ[_0x26b022(0x24f)][_0x26b022(0x302)],_0x4f973b=[_0x26b022(0x1ed),_0x26b022(0x253),_0x26b022(0x2af),_0x26b022(0x249),'SkillNames',_0x26b022(0x2d9),'UniqueLines'];for(const _0x486f6a of _0x4f973b){for(const _0x4f6dae of _0xa65891[_0x486f6a]){const _0x5e4126=(_0x4f6dae['Name']||'')['toUpperCase']()[_0x26b022(0x261)]();if(_0x5e4126['length']<=0x0)continue;if(_0x5e4126===_0x26b022(0x2d6))continue;VisuMZ[_0x26b022(0x24f)]['VoiceSet'][_0x5e4126]=VisuMZ[_0x26b022(0x24f)][_0x26b022(0x25d)][_0x5e4126]||{};for(const _0xa7191f in _0x4f6dae){if(_0x26b022(0x215)!==_0x26b022(0x30f)){if(_0xa7191f===_0x26b022(0x291))continue;VisuMZ[_0x26b022(0x24f)]['VoiceSet'][_0x5e4126][_0xa7191f]=_0x4f6dae[_0xa7191f];}else _0x49d06c[_0x26b022(0x20f)](_0x318861),_0x56384a[_0x26b022(0x2c0)](_0x1b31cd),_0x279eb8[_0x26b022(0x2d8)](_0x5d14fc),_0x17e8cb['changeBattleVoicePan'](_0x3ded0d),_0x3c51de['changeBattleVoiceLangSet'](_0x497f97);}}}},DataManager[_0x2f7f84(0x2c3)]=function(_0x4bf0ec){const _0x12e25e=_0x2f7f84;if(!_0x4bf0ec)return'';const _0x412550=_0x4bf0ec['id'];this['_getSkillHaveVoiceActionName']=this['_getSkillHaveVoiceActionName']||{};if(this[_0x12e25e(0x271)][_0x412550]!==undefined)return this[_0x12e25e(0x271)][_0x412550];let _0xbe9452='';const _0x2e88a0=VisuMZ[_0x12e25e(0x24f)][_0x12e25e(0x2bc)],_0x3dfa01=_0x4bf0ec[_0x12e25e(0x294)]||'';return _0x3dfa01[_0x12e25e(0x21d)](_0x2e88a0['ActionName'])&&(_0xbe9452='ActionName'+String(RegExp['$1'])[_0x12e25e(0x261)]()),this[_0x12e25e(0x271)][_0x412550]=_0xbe9452,this[_0x12e25e(0x271)][_0x412550];},DataManager['doesSkillHaveVoiceActionName']=function(_0x2c1dac){const _0x329d1c=_0x2f7f84,_0x592dc8=this['getSkillHaveVoiceActionName'](_0x2c1dac);return _0x592dc8[_0x329d1c(0x2ef)]>0x0;},DataManager['getSkillHaveVoiceChantLine']=function(_0x5cc31d){const _0x4e346b=_0x2f7f84;if(!_0x5cc31d)return'';const _0xd5c7e6=_0x5cc31d['id'];this[_0x4e346b(0x2f1)]=this[_0x4e346b(0x2f1)]||{};if(this[_0x4e346b(0x2f1)][_0xd5c7e6]!==undefined){if(_0x4e346b(0x213)!==_0x4e346b(0x2a3))return this['_getSkillHaveVoiceChantLine'][_0xd5c7e6];else{if(!_0x1b9067)return'';const _0x288abe=_0x3a6167['id'];this['_getSkillHaveVoiceChantLine']=this['_getSkillHaveVoiceChantLine']||{};if(this[_0x4e346b(0x2f1)][_0x288abe]!==_0x5df448)return this[_0x4e346b(0x2f1)][_0x288abe];let _0x1c7d3f='';const _0x1641e0=_0x10aca6[_0x4e346b(0x24f)]['RegExp'],_0x20f181=_0x1270de[_0x4e346b(0x294)]||'';return _0x20f181[_0x4e346b(0x21d)](_0x1641e0[_0x4e346b(0x2b6)])&&(_0x1c7d3f=_0x4e346b(0x2b6)+_0x8130f9(_0xff7ce3['$1'])['trim']()),this[_0x4e346b(0x2f1)][_0x288abe]=_0x1c7d3f,this[_0x4e346b(0x2f1)][_0x288abe];}}let _0x5ed892='';const _0x2b7ed0=VisuMZ[_0x4e346b(0x24f)][_0x4e346b(0x2bc)],_0xa45649=_0x5cc31d[_0x4e346b(0x294)]||'';return _0xa45649[_0x4e346b(0x21d)](_0x2b7ed0[_0x4e346b(0x2b6)])&&(_0x5ed892='ChantLine'+String(RegExp['$1'])[_0x4e346b(0x261)]()),this[_0x4e346b(0x2f1)][_0xd5c7e6]=_0x5ed892,this[_0x4e346b(0x2f1)][_0xd5c7e6];},DataManager[_0x2f7f84(0x2eb)]=function(_0x2b1349){const _0x1f7117=_0x2f7f84,_0xfdd8be=this[_0x1f7117(0x20d)](_0x2b1349);return _0xfdd8be[_0x1f7117(0x2ef)]>0x0;},DataManager[_0x2f7f84(0x226)]=function(_0x4d342b){const _0x3f45d0=_0x2f7f84;if(!_0x4d342b)return'';const _0x130020=_0x4d342b['id'];this[_0x3f45d0(0x206)]=this[_0x3f45d0(0x206)]||{};if(this['_getSkillHaveVoiceItemName'][_0x130020]!==undefined)return this[_0x3f45d0(0x206)][_0x130020];let _0x49306e='';const _0x44d34e=VisuMZ[_0x3f45d0(0x24f)][_0x3f45d0(0x2bc)],_0x59e47d=_0x4d342b[_0x3f45d0(0x294)]||'';return _0x59e47d[_0x3f45d0(0x21d)](_0x44d34e[_0x3f45d0(0x2c7)])&&(_0x49306e=_0x3f45d0(0x2c7)+String(RegExp['$1'])[_0x3f45d0(0x261)]()),this[_0x3f45d0(0x206)][_0x130020]=_0x49306e,this[_0x3f45d0(0x206)][_0x130020];},DataManager[_0x2f7f84(0x26c)]=function(_0x691e28){const _0x12d504=_0x2f7f84,_0x1b76f2=this[_0x12d504(0x226)](_0x691e28);return _0x1b76f2['length']>0x0;},DataManager['getSkillHaveVoiceSkillName']=function(_0xde8cf4){const _0x119584=_0x2f7f84;if(!_0xde8cf4)return'';const _0x53054e=_0xde8cf4['id'];this['_getSkillHaveVoiceSkillName']=this[_0x119584(0x21b)]||{};if(this[_0x119584(0x21b)][_0x53054e]!==undefined)return this['_getSkillHaveVoiceSkillName'][_0x53054e];let _0x52393d='';const _0x2c8aed=VisuMZ['BattleVoices']['RegExp'],_0x572949=_0xde8cf4[_0x119584(0x294)]||'';return _0x572949[_0x119584(0x21d)](_0x2c8aed[_0x119584(0x2b3)])&&(_0x52393d='SkillName'+String(RegExp['$1'])['trim']()),this[_0x119584(0x21b)][_0x53054e]=_0x52393d,this[_0x119584(0x21b)][_0x53054e];},DataManager[_0x2f7f84(0x2da)]=function(_0xf18ca3){const _0x1d520d=_0x2f7f84,_0x2b9f26=this[_0x1d520d(0x1ec)](_0xf18ca3);return _0x2b9f26[_0x1d520d(0x2ef)]>0x0;},DataManager[_0x2f7f84(0x278)]=function(_0x40039d){const _0x17b7c2=_0x2f7f84;if(!_0x40039d)return'';const _0x4f3f80=_0x40039d['id'];this['_getSkillHaveVoiceSpellName']=this[_0x17b7c2(0x30b)]||{};if(this[_0x17b7c2(0x30b)][_0x4f3f80]!==undefined){if(_0x17b7c2(0x260)===_0x17b7c2(0x260))return this[_0x17b7c2(0x30b)][_0x4f3f80];else _0xf19287+=_0x17b7c2(0x28b);}let _0x391321='';const _0x25ae33=VisuMZ[_0x17b7c2(0x24f)]['RegExp'],_0x14abcb=_0x40039d[_0x17b7c2(0x294)]||'';return _0x14abcb['match'](_0x25ae33[_0x17b7c2(0x2f7)])&&(_0x391321=_0x17b7c2(0x2f7)+String(RegExp['$1'])[_0x17b7c2(0x261)]()),this[_0x17b7c2(0x30b)][_0x4f3f80]=_0x391321,this[_0x17b7c2(0x30b)][_0x4f3f80];},DataManager[_0x2f7f84(0x2ec)]=function(_0x4897f9){const _0x1c4220=_0x2f7f84,_0x3b4beb=this[_0x1c4220(0x278)](_0x4897f9);return _0x3b4beb[_0x1c4220(0x2ef)]>0x0;},DataManager[_0x2f7f84(0x25b)]=function(_0x1a3ae9){const _0x56f115=_0x2f7f84;if(!_0x1a3ae9)return{};const _0x20bf23=_0x1a3ae9['id'];this[_0x56f115(0x2f8)]=this[_0x56f115(0x2f8)]||{};if(this[_0x56f115(0x2f8)][_0x20bf23]!==undefined){if(_0x56f115(0x28f)!==_0x56f115(0x2b2))return this[_0x56f115(0x2f8)][_0x20bf23];else{if(_0x2ccaf4[_0x56f115(0x21e)]){const _0x1f478d=_0x18cbd1[_0x56f115(0x2c9)],_0x316c47=_0x54efce[_0x56f115(0x21e)][_0x1f478d];if(_0x316c47)_0x43e26b=_0x316c47;}}}const _0x2b1f65={},_0x5157ec=VisuMZ[_0x56f115(0x24f)][_0x56f115(0x2bc)],_0x1b60b4=_0x1a3ae9[_0x56f115(0x294)]||'';if(_0x1b60b4['match'](_0x5157ec[_0x56f115(0x1f4)])){const _0x23c53f=String(RegExp['$1'])['split'](/[\r\n]+/);for(const _0xd043b7 of _0x23c53f){if(_0x56f115(0x2d3)!==_0x56f115(0x203)){if(_0xd043b7['match'](/(.*)[ ]SET:[ ](.*)/i)){if(_0x56f115(0x2b5)===_0x56f115(0x2b5)){const _0x1f95f3=String(RegExp['$1'])['toUpperCase']()[_0x56f115(0x261)](),_0x4990b9=String(RegExp['$2']);_0x2b1f65[_0x1f95f3]=_0x2b1f65[_0x1f95f3]||{},_0x2b1f65[_0x1f95f3][_0x56f115(0x307)]=_0x4990b9;}else{const _0x445aed=_0x871167[_0x56f115(0x1ec)](_0x752cce[_0x56f115(0x2ea)]());if(this[_0x56f115(0x2ba)](_0x445aed)){this[_0x56f115(0x312)](_0x445aed);return;}}}if(_0xd043b7[_0x56f115(0x21d)](/(.*)[ ]VOLUME:[ ](.*)/i)){if(_0x56f115(0x2d0)!==_0x56f115(0x210)){const _0x35da08=String(RegExp['$1'])[_0x56f115(0x2c1)]()['trim'](),_0x2a7238=Number(RegExp['$2']||0x0)[_0x56f115(0x2f4)](0x0,0x64);_0x2b1f65[_0x35da08]=_0x2b1f65[_0x35da08]||{},_0x2b1f65[_0x35da08]['volume']=_0x2a7238;}else{if(!_0x230a32)return;if(!_0x5e3628)return;if(_0x34d2de[_0x56f115(0x23a)]<=0x0){_0x207035[_0x56f115(0x2ab)]=_0x9324c2['_defeatedTargetsVoiced']||{};const _0x58c1df=_0x2abfb0['battlerKey']();if(_0x55c847[_0x56f115(0x2ab)][_0x58c1df])return;_0x838f0[_0x56f115(0x2ab)][_0x58c1df]=!![],this['playBattleVoice'](_0x56f115(0x24e));return;}const _0x4d0a0a=_0x3ff128[_0x56f115(0x256)]();if(!_0x4d0a0a)return;if(_0x4d0a0a[_0x56f115(0x2e0)]){this['playBattleVoice'](_0x56f115(0x2ca));return;}if(_0x4d0a0a[_0x56f115(0x2d7)]||_0x4d0a0a[_0x56f115(0x2fa)]){this[_0x56f115(0x312)](_0x56f115(0x228));return;}}}if(_0xd043b7[_0x56f115(0x21d)](/(.*)[ ]PITCH:[ ](.*)/i)){if(_0x56f115(0x300)===_0x56f115(0x301))_0x498b68=_0x56f115(0x2f7)+_0x5d397e(_0x1987de['$1'])['trim']();else{const _0x196cc=String(RegExp['$1'])[_0x56f115(0x2c1)]()['trim'](),_0x2df0ce=Math['max'](Number(RegExp['$2']||0x0),0x0);_0x2b1f65[_0x196cc]=_0x2b1f65[_0x196cc]||{},_0x2b1f65[_0x196cc][_0x56f115(0x319)]=_0x2df0ce;}}if(_0xd043b7[_0x56f115(0x21d)](/(.*)[ ]PAN:[ ](.*)/i)){if(_0x56f115(0x2c8)!=='xXduk'){if(_0x4118e0[_0x56f115(0x205)]===this){if(_0x1cc103[_0x56f115(0x24f)][_0x56f115(0x302)][_0x56f115(0x20a)])return![];}return!![];}else{const _0x4efee9=String(RegExp['$1'])[_0x56f115(0x2c1)]()[_0x56f115(0x261)](),_0x241084=Number(RegExp['$2']||0x0);_0x2b1f65[_0x4efee9]=_0x2b1f65[_0x4efee9]||{},_0x2b1f65[_0x4efee9][_0x56f115(0x23f)]=_0x241084;}}}else this[_0x56f115(0x2b8)][_0x56f115(0x312)]('BattleEscapeFailure');}}return this[_0x56f115(0x2f8)][_0x20bf23]=_0x2b1f65,this[_0x56f115(0x2f8)][_0x20bf23];},ConfigManager[_0x2f7f84(0x237)]=!![],VisuMZ['BattleVoices']['ConfigManager_makeData']=ConfigManager[_0x2f7f84(0x297)],ConfigManager[_0x2f7f84(0x297)]=function(){const _0x2dc029=_0x2f7f84,_0x28f3e8=VisuMZ[_0x2dc029(0x24f)][_0x2dc029(0x2a9)][_0x2dc029(0x2e7)](this);return _0x28f3e8[_0x2dc029(0x237)]=this['battleVoices'],_0x28f3e8;},VisuMZ[_0x2f7f84(0x24f)][_0x2f7f84(0x2f6)]=ConfigManager[_0x2f7f84(0x28e)],ConfigManager[_0x2f7f84(0x28e)]=function(_0x74a5a5){const _0x2a5ae5=_0x2f7f84;VisuMZ[_0x2a5ae5(0x24f)][_0x2a5ae5(0x2f6)][_0x2a5ae5(0x2e7)](this,_0x74a5a5),this[_0x2a5ae5(0x272)](_0x74a5a5,_0x2a5ae5(0x237),!![]),_0x2a5ae5(0x237)in _0x74a5a5?this['battleVoices']=_0x74a5a5[_0x2a5ae5(0x237)]:this[_0x2a5ae5(0x237)]=!![];},TextManager[_0x2f7f84(0x237)]=VisuMZ['BattleVoices'][_0x2f7f84(0x302)][_0x2f7f84(0x2e4)][_0x2f7f84(0x291)]??_0x2f7f84(0x2f5),AudioManager['getVoiceSet']=function(_0x5ef5aa){const _0x187c88=_0x2f7f84;return VisuMZ[_0x187c88(0x24f)][_0x187c88(0x25d)][_0x5ef5aa[_0x187c88(0x2c1)]()['trim']()];},AudioManager[_0x2f7f84(0x2cd)]=function(_0x502759){const _0x170dc0=_0x2f7f84;if(!_0x502759)return;const _0x46da56=Imported['VisuMZ_2_VoiceActControl']?this['_voiceBuffers']:this[_0x170dc0(0x2a0)],_0x25b26a=_0x46da56[_0x170dc0(0x218)](_0x5de0fa=>_0x5de0fa[_0x170dc0(0x274)]===_0x502759['battlerKey']());for(const _0x18bb34 of _0x25b26a){_0x18bb34[_0x170dc0(0x1e7)](),_0x46da56['remove'](_0x18bb34);}},AudioManager['playBattleVoice']=function(_0x188f9b,_0x13c5cb){const _0x58190b=_0x2f7f84;if(!ConfigManager[_0x58190b(0x237)])return;if(!_0x188f9b)return;if(!_0x13c5cb)return;this[_0x58190b(0x1f5)]=this[_0x58190b(0x1f5)]||{};const _0x58ef7f=_0x13c5cb['battlerKey']();if(this[_0x58190b(0x1f5)][_0x58ef7f]===Graphics[_0x58190b(0x30c)])return;this[_0x58190b(0x1f5)][_0x58ef7f]=Graphics[_0x58190b(0x30c)];VisuMZ[_0x58190b(0x24f)][_0x58190b(0x302)][_0x58190b(0x2fc)]&&(_0x58190b(0x2fb)!==_0x58190b(0x309)?AudioManager[_0x58190b(0x2cd)](_0x13c5cb):(_0x355257[_0x58190b(0x24f)][_0x58190b(0x2f2)][_0x58190b(0x2e7)](this),this['_currentActor']?this['_currentActor']['playBattleVoice'](_0x58190b(0x2e1)):_0x487c30[_0x58190b(0x312)](_0x58190b(0x2e1))));if(Imported[_0x58190b(0x216)]){if(_0x58190b(0x1eb)!=='BqKLV'){if(!_0x424347['battleVoices'])return![];const _0x55889e=this[_0x58190b(0x23d)]();let _0x4c96f1=_0x55889e[_0x58190b(0x307)];if(_0x44be0c['canPlayDifferentLanguageBattleVoices']()){if(_0x55889e['languages']){const _0x1316e9=_0x847e0a[_0x58190b(0x2c9)],_0x3c3031=_0x55889e[_0x58190b(0x21e)][_0x1316e9];if(_0x3c3031)_0x4c96f1=_0x3c3031;}}if(!_0x4c96f1)return![];const _0x3ad7e4=_0x308f02['getVoiceSet'](_0x4c96f1);if(!_0x3ad7e4)return![];const _0x3681a4=_0x3ad7e4[_0x55af94];return _0x3681a4&&_0x3681a4['length']>0x0;}else this[_0x58190b(0x28a)](_0x188f9b);}else this[_0x58190b(0x25c)](_0x188f9b);this[_0x58190b(0x2b1)](_0x188f9b,_0x13c5cb);},AudioManager[_0x2f7f84(0x2b1)]=function(_0x5a0bfa,_0x562535){const _0x5a456f=_0x2f7f84;if(!_0x562535)return;const _0x36ebe5=Imported[_0x5a456f(0x216)]?this[_0x5a456f(0x23c)]:this['_seBuffers'],_0x194e91=_0x36ebe5[_0x5a456f(0x26f)](_0x2f0b59=>_0x2f0b59['name']===_0x5a0bfa[_0x5a456f(0x27b)]&&_0x2f0b59[_0x5a456f(0x30c)]===Graphics['frameCount']);if(!_0x194e91)return;_0x194e91['battlerKey']=_0x562535[_0x5a456f(0x274)]();},VisuMZ[_0x2f7f84(0x24f)]['BattleManager_startBattle']=BattleManager[_0x2f7f84(0x31b)],BattleManager[_0x2f7f84(0x31b)]=function(){const _0x29d338=_0x2f7f84;VisuMZ[_0x29d338(0x24f)][_0x29d338(0x1f9)]['call'](this),$gameParty['playBattleVoice'](_0x29d338(0x279));},VisuMZ[_0x2f7f84(0x24f)]['BattleManager_processVictory']=BattleManager[_0x2f7f84(0x2b4)],BattleManager[_0x2f7f84(0x2b4)]=function(){const _0x6c3041=_0x2f7f84;VisuMZ['BattleVoices'][_0x6c3041(0x282)][_0x6c3041(0x2e7)](this);if(Imported['VisuMZ_3_VictoryAftermath'])return;$gameParty[_0x6c3041(0x312)](_0x6c3041(0x2e3));},VisuMZ['BattleVoices'][_0x2f7f84(0x2f2)]=BattleManager[_0x2f7f84(0x1fb)],BattleManager[_0x2f7f84(0x1fb)]=function(){const _0x3f2383=_0x2f7f84;VisuMZ[_0x3f2383(0x24f)]['BattleManager_onEscapeSuccess'][_0x3f2383(0x2e7)](this);if(this[_0x3f2383(0x2b8)])this[_0x3f2383(0x2b8)][_0x3f2383(0x312)]('BattleEscapeSuccess');else{if(_0x3f2383(0x286)===_0x3f2383(0x286))$gameParty[_0x3f2383(0x312)](_0x3f2383(0x2e1));else{if(!_0x5dd4ac)return;const _0x290728=_0x318364[_0x3f2383(0x216)]?this[_0x3f2383(0x23c)]:this[_0x3f2383(0x2a0)],_0x356e7b=_0x290728[_0x3f2383(0x218)](_0x132bee=>_0x132bee[_0x3f2383(0x274)]===_0x501f39[_0x3f2383(0x274)]());for(const _0x46318e of _0x356e7b){_0x46318e[_0x3f2383(0x1e7)](),_0x290728[_0x3f2383(0x2ac)](_0x46318e);}}}},VisuMZ['BattleVoices']['BattleManager_onEscapeFailure']=BattleManager[_0x2f7f84(0x1ee)],BattleManager[_0x2f7f84(0x1ee)]=function(){const _0x49943c=_0x2f7f84;VisuMZ['BattleVoices']['BattleManager_onEscapeFailure'][_0x49943c(0x2e7)](this),this[_0x49943c(0x2b8)]?this[_0x49943c(0x2b8)]['playBattleVoice'](_0x49943c(0x234)):$gameParty[_0x49943c(0x312)]('BattleEscapeFailure');},VisuMZ[_0x2f7f84(0x24f)][_0x2f7f84(0x20c)]=Window_ActorCommand['prototype'][_0x2f7f84(0x262)],Window_ActorCommand[_0x2f7f84(0x288)][_0x2f7f84(0x262)]=function(_0x252329){const _0x361385=_0x2f7f84;VisuMZ[_0x361385(0x24f)]['Window_ActorCommand_setup'][_0x361385(0x2e7)](this,_0x252329),_0x252329&&_0x252329===BattleManager['_currentActor']&&_0x252329[_0x361385(0x1f7)]()&&_0x252329[_0x361385(0x312)](_0x361385(0x317));},VisuMZ['BattleVoices']['Game_Action_apply']=Game_Action[_0x2f7f84(0x288)]['apply'],Game_Action[_0x2f7f84(0x288)]['apply']=function(_0x289c98){const _0x3e9986=_0x2f7f84;VisuMZ[_0x3e9986(0x24f)][_0x3e9986(0x229)][_0x3e9986(0x2e7)](this,_0x289c98);if(!SceneManager['isSceneBattle']())return;if(!BattleManager[_0x3e9986(0x205)])return;if(!_0x289c98)return;this[_0x3e9986(0x207)]()[_0x3e9986(0x264)](this,_0x289c98);},Game_BattlerBase['prototype']['setupBattleVoice']=function(){const _0x31ace1=_0x2f7f84,_0x15279b=VisuMZ[_0x31ace1(0x24f)][_0x31ace1(0x302)],_0x23c2cf=VisuMZ[_0x31ace1(0x24f)]['RegExp'],_0x41076=this[_0x31ace1(0x2f9)]()?this['actor']():this[_0x31ace1(0x1ff)](),_0x31f642=_0x41076[_0x31ace1(0x294)]||'';this[_0x31ace1(0x2e6)]={'set':'','volume':_0x15279b[_0x31ace1(0x2df)]??0x64,'pitch':_0x15279b[_0x31ace1(0x319)]??0x64,'pan':_0x15279b[_0x31ace1(0x23f)]??0x0};_0x31f642[_0x31ace1(0x21d)](_0x23c2cf[_0x31ace1(0x25d)])&&(_0x31ace1(0x24d)!==_0x31ace1(0x24d)?_0x5af86b+=_0x31ace1(0x1e8):this[_0x31ace1(0x2e6)][_0x31ace1(0x307)]=String(RegExp['$1'])[_0x31ace1(0x261)]());_0x31f642[_0x31ace1(0x21d)](_0x23c2cf[_0x31ace1(0x217)])&&(this['_battleVoice'][_0x31ace1(0x2df)]=(Number(RegExp['$1'])||0x0)[_0x31ace1(0x2f4)](0x0,0x64));_0x31f642[_0x31ace1(0x21d)](_0x23c2cf[_0x31ace1(0x2c2)])&&(_0x31ace1(0x1fa)!==_0x31ace1(0x1fa)?this[_0x31ace1(0x225)]():this[_0x31ace1(0x2e6)][_0x31ace1(0x319)]=Math['max'](Number(RegExp['$1'])||0x0,0x0));_0x31f642[_0x31ace1(0x21d)](_0x23c2cf[_0x31ace1(0x2a5)])&&(_0x31ace1(0x2a1)==='UeOhP'?this['_battleVoice'][_0x31ace1(0x23f)]=Number(RegExp['$1'])||0x0:_0x217f24+=_0x31ace1(0x1e8));const _0x196a3a=_0x31f642[_0x31ace1(0x21d)](_0x23c2cf[_0x31ace1(0x29d)]);if(_0x196a3a){if(_0x31ace1(0x292)===_0x31ace1(0x292)){this[_0x31ace1(0x2e6)]['languages']={};for(const _0x252ce7 of _0x196a3a){_0x252ce7[_0x31ace1(0x21d)](_0x23c2cf['LangVoiceSet']);const _0xbc8a76=String(RegExp['$1'])['trim'](),_0x2549a8=String(RegExp['$2'])[_0x31ace1(0x261)]();this['_battleVoice'][_0x31ace1(0x21e)][_0xbc8a76]=_0x2549a8;}}else _0x3ad02c+='Death';}},VisuMZ[_0x2f7f84(0x24f)][_0x2f7f84(0x250)]=Game_Actor[_0x2f7f84(0x288)][_0x2f7f84(0x262)],Game_Actor[_0x2f7f84(0x288)][_0x2f7f84(0x262)]=function(_0x1ecfb4){const _0x196e1e=_0x2f7f84;VisuMZ[_0x196e1e(0x24f)][_0x196e1e(0x250)]['call'](this,_0x1ecfb4),this[_0x196e1e(0x31a)]();},Game_BattlerBase[_0x2f7f84(0x288)][_0x2f7f84(0x23d)]=function(){const _0x4e6e6a=_0x2f7f84;if(this[_0x4e6e6a(0x2e6)]===undefined)this['setupBattleVoice']();return this[_0x4e6e6a(0x2e6)];},Game_BattlerBase[_0x2f7f84(0x288)][_0x2f7f84(0x22a)]=function(){const _0x5e0b89=_0x2f7f84;if(BattleManager['_subject']===this){if(VisuMZ[_0x5e0b89(0x24f)]['Settings'][_0x5e0b89(0x20a)])return![];}return!![];},Game_Enemy[_0x2f7f84(0x288)][_0x2f7f84(0x31a)]=function(){const _0x252a74=_0x2f7f84;Game_Battler[_0x252a74(0x288)]['setupBattleVoice']['call'](this),Imported[_0x252a74(0x2dd)]&&this[_0x252a74(0x225)]();},Game_Enemy[_0x2f7f84(0x288)][_0x2f7f84(0x225)]=function(){const _0x5be358=_0x2f7f84,_0x2085c0=this['getTraitSetKeys']()[_0x5be358(0x2ac)](_0x5be358(0x2bb)),_0x234142=DataManager[_0x5be358(0x25b)](this[_0x5be358(0x1ff)]());for(const _0x26e547 of _0x2085c0){const _0xe8ba32=this[_0x5be358(0x270)](_0x26e547)['Name']['toUpperCase']()[_0x5be358(0x261)]();traitData=_0x234142[_0xe8ba32];if(traitData){if(traitData['set'])this[_0x5be358(0x2e6)][_0x5be358(0x307)]=traitData['set'][_0x5be358(0x2c1)]()[_0x5be358(0x261)]();if(traitData[_0x5be358(0x2df)])this['_battleVoice'][_0x5be358(0x307)]=traitData[_0x5be358(0x2df)];if(traitData[_0x5be358(0x319)])this[_0x5be358(0x2e6)][_0x5be358(0x307)]=traitData[_0x5be358(0x319)];if(traitData['pan'])this[_0x5be358(0x2e6)]['set']=traitData['pan'];}}},Game_BattlerBase[_0x2f7f84(0x288)][_0x2f7f84(0x20f)]=function(_0x28e359){const _0x3283fe=_0x2f7f84;if(this['_battleVoice']===undefined)this[_0x3283fe(0x31a)]();this[_0x3283fe(0x2e6)][_0x3283fe(0x307)]=_0x28e359;},Game_BattlerBase[_0x2f7f84(0x288)][_0x2f7f84(0x2c0)]=function(_0x30540a){const _0x419e8f=_0x2f7f84;if(this['_battleVoice']===undefined)this[_0x419e8f(0x31a)]();this[_0x419e8f(0x2e6)][_0x419e8f(0x2df)]=_0x30540a[_0x419e8f(0x2f4)](0x0,0x64);},Game_BattlerBase['prototype']['changeBattleVoicePitch']=function(_0x29a9ee){const _0x182b8b=_0x2f7f84;if(this[_0x182b8b(0x2e6)]===undefined)this[_0x182b8b(0x31a)]();this[_0x182b8b(0x2e6)][_0x182b8b(0x319)]=Math['max'](_0x29a9ee,0x0);},Game_BattlerBase[_0x2f7f84(0x288)][_0x2f7f84(0x1e6)]=function(_0x4595fa){const _0x3e32ce=_0x2f7f84;if(this[_0x3e32ce(0x2e6)]===undefined)this[_0x3e32ce(0x31a)]();this[_0x3e32ce(0x2e6)]['pan']=_0x4595fa;},Game_BattlerBase[_0x2f7f84(0x288)][_0x2f7f84(0x239)]=function(_0x4cdce1){const _0x2f306f=_0x2f7f84;if(this[_0x2f306f(0x2e6)]===undefined)this['setupBattleVoice']();this[_0x2f306f(0x2e6)][_0x2f306f(0x21e)]=_0x4cdce1;},VisuMZ[_0x2f7f84(0x24f)][_0x2f7f84(0x214)]=Game_BattlerBase['prototype'][_0x2f7f84(0x220)],Game_BattlerBase[_0x2f7f84(0x288)][_0x2f7f84(0x220)]=function(_0x6a3aa5){const _0x525b60=_0x2f7f84,_0xdac2e1=this[_0x525b60(0x23a)];VisuMZ[_0x525b60(0x24f)][_0x525b60(0x214)]['call'](this,_0x6a3aa5);const _0x1f5783=this[_0x525b60(0x23a)];this[_0x525b60(0x2a4)](_0xdac2e1,_0x1f5783);},AudioManager[_0x2f7f84(0x2b7)]=![],AudioManager[_0x2f7f84(0x243)]=function(){const _0x319f83=_0x2f7f84;if(!Imported[_0x319f83(0x216)])return![];if(!AudioManager[_0x319f83(0x304)])return![];if(!AudioManager[_0x319f83(0x304)]())return![];return!![];},Game_BattlerBase[_0x2f7f84(0x288)][_0x2f7f84(0x312)]=function(_0x27b42d){const _0x6eb92e=_0x2f7f84;if(!ConfigManager[_0x6eb92e(0x237)])return;const _0x1e448f=this[_0x6eb92e(0x23d)]();let _0x348ec7=_0x1e448f[_0x6eb92e(0x307)];if(AudioManager[_0x6eb92e(0x243)]()){if(_0x1e448f['languages']){if(_0x6eb92e(0x2db)!==_0x6eb92e(0x2db))_0x26be95+='Light';else{const _0x255de8=ConfigManager[_0x6eb92e(0x2c9)],_0x2b7bc1=_0x1e448f['languages'][_0x255de8];if(_0x2b7bc1)_0x348ec7=_0x2b7bc1;}}}if(!_0x348ec7)return;const _0xa4cfbf=AudioManager[_0x6eb92e(0x232)](_0x348ec7);if(!_0xa4cfbf)return;const _0x59a52e=_0xa4cfbf[_0x27b42d];if(!_0x59a52e)return;if(_0x59a52e[_0x6eb92e(0x2ef)]<=0x0)return;const _0x487936=_0x59a52e[Math[_0x6eb92e(0x306)](_0x59a52e[_0x6eb92e(0x2ef)])],_0x203a9f={'name':_0x487936,'volume':_0x1e448f[_0x6eb92e(0x2df)],'pitch':_0x1e448f[_0x6eb92e(0x319)],'pan':_0x1e448f['pan']};AudioManager['playBattleVoice'](_0x203a9f,this),AudioManager[_0x6eb92e(0x2b7)]&&console[_0x6eb92e(0x257)]('Battler:\x20%1\x0aKey:\x20%2\x0aFilename:\x20%3'[_0x6eb92e(0x2e8)](this[_0x6eb92e(0x27b)](),_0x27b42d,_0x203a9f['name']));},Game_BattlerBase['prototype'][_0x2f7f84(0x2ba)]=function(_0x158d12){const _0x1e3b53=_0x2f7f84;if(!ConfigManager[_0x1e3b53(0x237)])return![];const _0x13d120=this[_0x1e3b53(0x23d)]();let _0x4cb17b=_0x13d120['set'];if(AudioManager[_0x1e3b53(0x243)]()){if(_0x13d120[_0x1e3b53(0x21e)]){const _0x51f37a=ConfigManager[_0x1e3b53(0x2c9)],_0x4c52aa=_0x13d120[_0x1e3b53(0x21e)][_0x51f37a];if(_0x4c52aa)_0x4cb17b=_0x4c52aa;}}if(!_0x4cb17b)return![];const _0x34a7ba=AudioManager['getVoiceSet'](_0x4cb17b);if(!_0x34a7ba)return![];const _0x32e215=_0x34a7ba[_0x158d12];return _0x32e215&&_0x32e215[_0x1e3b53(0x2ef)]>0x0;},VisuMZ[_0x2f7f84(0x24f)]['Game_Battler_performActionStart']=Game_Battler['prototype']['performActionStart'],Game_Battler[_0x2f7f84(0x288)]['performActionStart']=function(_0xa60826){const _0x24fe1f=_0x2f7f84;VisuMZ[_0x24fe1f(0x24f)][_0x24fe1f(0x273)]['call'](this,_0xa60826);if(!SceneManager[_0x24fe1f(0x1ea)]())return;if(!_0xa60826)return;this[_0x24fe1f(0x27a)](_0xa60826);},Game_Battler[_0x2f7f84(0x288)][_0x2f7f84(0x27a)]=function(_0x379439){const _0x5b787b=_0x2f7f84;if(DataManager[_0x5b787b(0x23b)](_0x379439[_0x5b787b(0x2ea)]())){const _0x58c2c2=DataManager['getSkillHaveVoiceActionName'](_0x379439['item']());if(this[_0x5b787b(0x2ba)](_0x58c2c2)){this['playBattleVoice'](_0x58c2c2);return;}}if(DataManager['doesSkillHaveVoiceChantLine'](_0x379439[_0x5b787b(0x2ea)]())){const _0x3f682e=DataManager[_0x5b787b(0x20d)](_0x379439['item']());if(this[_0x5b787b(0x2ba)](_0x3f682e)){this[_0x5b787b(0x312)](_0x3f682e);return;}}if(DataManager[_0x5b787b(0x26c)](_0x379439[_0x5b787b(0x2ea)]())){const _0x2227a6=DataManager[_0x5b787b(0x226)](_0x379439[_0x5b787b(0x2ea)]());if(this[_0x5b787b(0x2ba)](_0x2227a6)){if(_0x5b787b(0x2dc)==='dowOx'){if(!_0x1a53a2)return'';const _0x53cb7c=_0x2ac69c['id'];this[_0x5b787b(0x206)]=this[_0x5b787b(0x206)]||{};if(this[_0x5b787b(0x206)][_0x53cb7c]!==_0x1a4792)return this[_0x5b787b(0x206)][_0x53cb7c];let _0x441e1e='';const _0xcd4823=_0x536711[_0x5b787b(0x24f)][_0x5b787b(0x2bc)],_0x1b91fe=_0x393a50[_0x5b787b(0x294)]||'';return _0x1b91fe[_0x5b787b(0x21d)](_0xcd4823[_0x5b787b(0x2c7)])&&(_0x441e1e=_0x5b787b(0x2c7)+_0x1ae09c(_0x58c51f['$1'])[_0x5b787b(0x261)]()),this['_getSkillHaveVoiceItemName'][_0x53cb7c]=_0x441e1e,this[_0x5b787b(0x206)][_0x53cb7c];}else{this[_0x5b787b(0x312)](_0x2227a6);return;}}}if(DataManager[_0x5b787b(0x2da)](_0x379439[_0x5b787b(0x2ea)]())){const _0x53c845=DataManager[_0x5b787b(0x1ec)](_0x379439[_0x5b787b(0x2ea)]());if(this['hasBattleVoiceKey'](_0x53c845)){this['playBattleVoice'](_0x53c845);return;}}if(DataManager['doesSkillHaveVoiceSpellName'](_0x379439['item']())){if('itDZz'==='itDZz'){const _0x1f7f22=DataManager[_0x5b787b(0x278)](_0x379439[_0x5b787b(0x2ea)]());if(this['hasBattleVoiceKey'](_0x1f7f22)){this[_0x5b787b(0x312)](_0x1f7f22);return;}}else{if(_0x2e5da4[_0x5b787b(0x21e)]){const _0x224eef=_0x382d93[_0x5b787b(0x2c9)],_0x433bfb=_0x5c2439[_0x5b787b(0x21e)][_0x224eef];if(_0x433bfb)_0x3bf91e=_0x433bfb;}}}this[_0x5b787b(0x2d2)](_0x379439);},Game_Battler[_0x2f7f84(0x288)][_0x2f7f84(0x2d2)]=function(_0xbb50b4){const _0x50b7c7=_0x2f7f84;let _0x545a1e=_0x50b7c7(0x23e);if(_0xbb50b4[_0x50b7c7(0x25f)]()){if(_0x50b7c7(0x2ce)===_0x50b7c7(0x2ce))_0x545a1e+='BasicAttack';else{if(this[_0x50b7c7(0x2e6)]===_0x197fad)this[_0x50b7c7(0x31a)]();return this[_0x50b7c7(0x2e6)];}}else{if(_0xbb50b4[_0x50b7c7(0x2bd)]())_0x545a1e+=_0x50b7c7(0x209);else{if(_0xbb50b4[_0x50b7c7(0x1fc)]()){_0x545a1e+=_0x50b7c7(0x289),_0x545a1e+=_0xbb50b4['isForFriend']()&&!_0xbb50b4['isForEveryone']()?_0x50b7c7(0x26d):_0x50b7c7(0x20b);if(_0xbb50b4['isCertainHit']())_0x545a1e+=_0x50b7c7(0x275);if(_0xbb50b4['isPhysical']())_0x545a1e+=_0x50b7c7(0x1ef);if(_0xbb50b4[_0x50b7c7(0x1f6)]())_0x545a1e+=_0x50b7c7(0x284);}else{if(_0xbb50b4[_0x50b7c7(0x299)]()){if('gAySs'===_0x50b7c7(0x236)){const _0x30bd4d=_0x1d1317['voiceLocale'],_0x53efdf=_0x16767f[_0x50b7c7(0x21e)][_0x30bd4d];if(_0x53efdf)_0x4dcd4e=_0x53efdf;}else _0x545a1e+='Item',_0x545a1e+=_0xbb50b4['isForFriend']()&&!_0xbb50b4[_0x50b7c7(0x230)]()?_0x50b7c7(0x26d):'Enemy';}}}}this['playBattleVoice'](_0x545a1e);},VisuMZ[_0x2f7f84(0x24f)]['Game_Battler_performAction']=Game_Battler[_0x2f7f84(0x288)][_0x2f7f84(0x311)],Game_Battler[_0x2f7f84(0x288)][_0x2f7f84(0x311)]=function(_0x427d8a){const _0x273dd5=_0x2f7f84;VisuMZ[_0x273dd5(0x24f)][_0x273dd5(0x285)][_0x273dd5(0x2e7)](this,_0x427d8a);if(!SceneManager[_0x273dd5(0x1ea)]())return;if(!_0x427d8a)return;this[_0x273dd5(0x27e)](_0x427d8a);},Game_Battler[_0x2f7f84(0x288)][_0x2f7f84(0x27e)]=function(_0x53dd03){const _0x2c9172=_0x2f7f84;let _0x4476e4='PerformAction';if(_0x53dd03[_0x2c9172(0x25f)]()||_0x53dd03[_0x2c9172(0x2bd)]()||_0x53dd03['isItem']())return;else{if(_0x53dd03[_0x2c9172(0x1fc)]()){_0x4476e4+=_0x2c9172(0x289);if(_0x53dd03[_0x2c9172(0x1f8)]())_0x4476e4+='CertainHit';if(_0x53dd03['isPhysical']())_0x4476e4+=_0x2c9172(0x1ef);if(_0x53dd03[_0x2c9172(0x1f6)]())_0x4476e4+=_0x2c9172(0x284);}}this[_0x2c9172(0x312)](_0x4476e4);},VisuMZ[_0x2f7f84(0x24f)][_0x2f7f84(0x247)]=Game_Actor[_0x2f7f84(0x288)]['performAttack'],Game_Actor[_0x2f7f84(0x288)][_0x2f7f84(0x315)]=function(){const _0x379467=_0x2f7f84;VisuMZ[_0x379467(0x24f)][_0x379467(0x247)][_0x379467(0x2e7)](this);if(!SceneManager[_0x379467(0x1ea)]())return;this['playBattleVoice'](_0x379467(0x20e));},VisuMZ[_0x2f7f84(0x24f)][_0x2f7f84(0x266)]=Game_Enemy[_0x2f7f84(0x288)]['performAttack'],Game_Enemy[_0x2f7f84(0x288)][_0x2f7f84(0x315)]=function(){const _0x1c45bd=_0x2f7f84;VisuMZ[_0x1c45bd(0x24f)][_0x1c45bd(0x266)][_0x1c45bd(0x2e7)](this);if(!SceneManager['isSceneBattle']())return;this[_0x1c45bd(0x312)](_0x1c45bd(0x20e));},Game_Battler[_0x2f7f84(0x288)][_0x2f7f84(0x264)]=function(_0x4156de,_0xc52387){const _0x37bee9=_0x2f7f84;if(!_0x4156de)return;if(!_0xc52387)return;if(_0xc52387[_0x37bee9(0x23a)]<=0x0){_0x4156de[_0x37bee9(0x2ab)]=_0x4156de['_defeatedTargetsVoiced']||{};const _0x46e4ec=_0xc52387[_0x37bee9(0x274)]();if(_0x4156de[_0x37bee9(0x2ab)][_0x46e4ec])return;_0x4156de[_0x37bee9(0x2ab)][_0x46e4ec]=!![],this['playBattleVoice'](_0x37bee9(0x24e));return;}const _0x55fdb2=_0xc52387[_0x37bee9(0x256)]();if(!_0x55fdb2)return;if(_0x55fdb2[_0x37bee9(0x2e0)]){if('pWvdx'!==_0x37bee9(0x303)){this['playBattleVoice']('PerformActionCritical');return;}else{const _0x12469f=_0x1860ef[_0x55d320];if(!_0x12469f)return;let _0x1281e1=_0x37bee9(0x316);if(_0xcec2fd[_0x37bee9(0x22f)]&&_0x12469f['note']['match'](/<POSITIVE STATE>/i))_0x1281e1+='Positive';else _0x2558e7[_0x37bee9(0x22f)]&&_0x12469f[_0x37bee9(0x294)][_0x37bee9(0x21d)](/<NEGATIVE STATE>/i)?_0x1281e1+='Negative':_0x1281e1+='Neutral';_0x1281e1+='Remove',this[_0x37bee9(0x312)](_0x1281e1);}}if(_0x55fdb2[_0x37bee9(0x2d7)]||_0x55fdb2[_0x37bee9(0x2fa)]){if('AlCqL'===_0x37bee9(0x2d1))_0x3f3c32+='Positive';else{this[_0x37bee9(0x312)](_0x37bee9(0x228));return;}}},Game_Battler[_0x2f7f84(0x288)][_0x2f7f84(0x2a4)]=function(_0x188814,_0x158dbc){const _0x4c0da6=_0x2f7f84;if(!SceneManager[_0x4c0da6(0x1ea)]())return;if(![_0x4c0da6(0x2a2),_0x4c0da6(0x24b)][_0x4c0da6(0x2d5)](BattleManager[_0x4c0da6(0x30d)]))return;if(!BattleManager['_subject'])return;if(!this[_0x4c0da6(0x22a)]())return;let _0x165223='HpChange';if(_0x188814>0x0&&_0x158dbc<=0x0){if(_0x4c0da6(0x26e)==='GTLMm')_0x165223+=_0x4c0da6(0x227);else{const _0x725165=this[_0x4c0da6(0x2c3)](_0x2c91dc);return _0x725165[_0x4c0da6(0x2ef)]>0x0;}}else{if(_0x188814<=0x0&&_0x158dbc>0x1)_0x165223+='Revive';else{if(_0x188814>_0x158dbc){const _0x9339ed=_0x188814-_0x158dbc,_0x42739d=_0x9339ed/this[_0x4c0da6(0x2ad)];_0x165223+=_0x4c0da6(0x2fe);if(this[_0x4c0da6(0x2bd)]())_0x165223+=_0x4c0da6(0x290);else{if(_0x42739d>=0.5)_0x165223+=_0x4c0da6(0x1e8);else{if(_0x42739d>=0.25)_0x165223+=_0x4c0da6(0x28b);else{if(_0x4c0da6(0x221)===_0x4c0da6(0x221))_0x165223+=_0x4c0da6(0x2bf);else{_0x499746[_0x4c0da6(0x24f)][_0x4c0da6(0x1f1)][_0x4c0da6(0x2e7)](this);if(!_0x523083['isSceneBattle']())return;if(!this[_0x4c0da6(0x22a)]())return;this[_0x4c0da6(0x312)]('ActionResultEvasion');}}}}}else{if(_0x188814<_0x158dbc){if('MNSVx'===_0x4c0da6(0x2e5)){const _0xa61821=_0x424fb7[_0x4c0da6(0x2c3)](_0x446a07['item']());if(this['hasBattleVoiceKey'](_0xa61821)){this[_0x4c0da6(0x312)](_0xa61821);return;}}else{const _0x42ee2f=_0x158dbc-_0x188814,_0x501b66=_0x42ee2f/this[_0x4c0da6(0x2ad)];_0x165223+=_0x4c0da6(0x2fd);if(_0x501b66>=0.5){if(_0x4c0da6(0x1f3)===_0x4c0da6(0x2cf)){this[_0x4c0da6(0x312)](_0x4c0da6(0x2ca));return;}else _0x165223+=_0x4c0da6(0x1e8);}else{if(_0x501b66>=0.25)_0x165223+='Medium';else{if(_0x4c0da6(0x2e2)===_0x4c0da6(0x200)){const _0x3f3010=this['getTraitSetKeys']()[_0x4c0da6(0x2ac)]('SubElement'),_0x109463=_0x69f3a8['getTraitVoiceSets'](this[_0x4c0da6(0x1ff)]());for(const _0x1b7fd2 of _0x3f3010){const _0x17a6cd=this[_0x4c0da6(0x270)](_0x1b7fd2)[_0x4c0da6(0x291)][_0x4c0da6(0x2c1)]()[_0x4c0da6(0x261)]();_0x16011c=_0x109463[_0x17a6cd];if(_0x1e14a0){if(_0x349451[_0x4c0da6(0x307)])this[_0x4c0da6(0x2e6)][_0x4c0da6(0x307)]=_0x5e7faa['set'][_0x4c0da6(0x2c1)]()['trim']();if(_0x3b3cd4[_0x4c0da6(0x2df)])this[_0x4c0da6(0x2e6)]['set']=_0x271c05[_0x4c0da6(0x2df)];if(_0x358014['pitch'])this[_0x4c0da6(0x2e6)][_0x4c0da6(0x307)]=_0x5aaf26[_0x4c0da6(0x319)];if(_0x44328f[_0x4c0da6(0x23f)])this[_0x4c0da6(0x2e6)]['set']=_0x1f4155[_0x4c0da6(0x23f)];}}}else _0x165223+='Light';}}}}else{if(_0x188814===_0x158dbc){if(_0x4c0da6(0x2be)===_0x4c0da6(0x2be))_0x165223+=_0x4c0da6(0x21a);else{this[_0x4c0da6(0x2e6)][_0x4c0da6(0x21e)]={};for(const _0x219215 of _0x312c96){_0x219215[_0x4c0da6(0x21d)](_0x17f4cb[_0x4c0da6(0x29d)]);const _0x492221=_0x44b2fc(_0x36781a['$1'])[_0x4c0da6(0x261)](),_0x369a97=_0x368c27(_0x4d642e['$2'])[_0x4c0da6(0x261)]();this[_0x4c0da6(0x2e6)][_0x4c0da6(0x21e)][_0x492221]=_0x369a97;}}}else return;}}}}this[_0x4c0da6(0x312)](_0x165223);},VisuMZ[_0x2f7f84(0x24f)][_0x2f7f84(0x1f1)]=Game_Battler[_0x2f7f84(0x288)]['performMiss'],Game_Battler['prototype'][_0x2f7f84(0x29a)]=function(){const _0x411b6b=_0x2f7f84;VisuMZ[_0x411b6b(0x24f)][_0x411b6b(0x1f1)][_0x411b6b(0x2e7)](this);if(!SceneManager[_0x411b6b(0x1ea)]())return;if(!this[_0x411b6b(0x22a)]())return;this[_0x411b6b(0x312)](_0x411b6b(0x208));},VisuMZ[_0x2f7f84(0x24f)][_0x2f7f84(0x22b)]=Game_Battler[_0x2f7f84(0x288)][_0x2f7f84(0x2cb)],Game_Battler[_0x2f7f84(0x288)][_0x2f7f84(0x2cb)]=function(){const _0x43198a=_0x2f7f84;VisuMZ[_0x43198a(0x24f)][_0x43198a(0x22b)][_0x43198a(0x2e7)](this);if(!SceneManager[_0x43198a(0x1ea)]())return;if(!this[_0x43198a(0x22a)]())return;this[_0x43198a(0x312)](_0x43198a(0x208));},VisuMZ[_0x2f7f84(0x24f)][_0x2f7f84(0x24a)]=Game_Battler['prototype'][_0x2f7f84(0x1fe)],Game_Battler[_0x2f7f84(0x288)][_0x2f7f84(0x1fe)]=function(){const _0x1d355d=_0x2f7f84;VisuMZ['BattleVoices'][_0x1d355d(0x24a)][_0x1d355d(0x2e7)](this);if(!SceneManager[_0x1d355d(0x1ea)]())return;if(!this['allowSelfResponseVoice']())return;this[_0x1d355d(0x312)](_0x1d355d(0x27d));},VisuMZ[_0x2f7f84(0x24f)]['Game_Battler_performCounter']=Game_Battler[_0x2f7f84(0x288)]['performCounter'],Game_Battler['prototype'][_0x2f7f84(0x259)]=function(){const _0x400731=_0x2f7f84;VisuMZ[_0x400731(0x24f)]['Game_Battler_performCounter'][_0x400731(0x2e7)](this);if(!SceneManager[_0x400731(0x1ea)]())return;if(!this[_0x400731(0x22a)]())return;this[_0x400731(0x312)](_0x400731(0x201));},VisuMZ[_0x2f7f84(0x24f)][_0x2f7f84(0x25a)]=Game_Battler[_0x2f7f84(0x288)][_0x2f7f84(0x22c)],Game_Battler[_0x2f7f84(0x288)][_0x2f7f84(0x22c)]=function(){const _0x58d04c=_0x2f7f84;VisuMZ[_0x58d04c(0x24f)][_0x58d04c(0x25a)][_0x58d04c(0x2e7)](this);if(!SceneManager[_0x58d04c(0x1ea)]())return;if(!this[_0x58d04c(0x22a)]())return;this[_0x58d04c(0x312)](_0x58d04c(0x1e9));},VisuMZ['BattleVoices'][_0x2f7f84(0x2aa)]=Game_Battler['prototype'][_0x2f7f84(0x2f3)],Game_Battler['prototype']['performSubstitute']=function(_0x20f049){const _0x407eac=_0x2f7f84;VisuMZ[_0x407eac(0x24f)][_0x407eac(0x2aa)][_0x407eac(0x2e7)](this,_0x20f049);if(!SceneManager['isSceneBattle']())return;if(!this[_0x407eac(0x22a)]())return;this['playBattleVoice'](_0x407eac(0x252));},VisuMZ[_0x2f7f84(0x24f)]['Game_Battler_addBuff']=Game_Battler[_0x2f7f84(0x288)][_0x2f7f84(0x254)],Game_Battler[_0x2f7f84(0x288)][_0x2f7f84(0x254)]=function(_0x2c7915,_0x5c1194){const _0x1c4ed5=_0x2f7f84;VisuMZ[_0x1c4ed5(0x24f)]['Game_Battler_addBuff'][_0x1c4ed5(0x2e7)](this,_0x2c7915,_0x5c1194);if(!SceneManager[_0x1c4ed5(0x1ea)]())return;if(!BattleManager[_0x1c4ed5(0x205)])return;if(!this[_0x1c4ed5(0x22a)]())return;this[_0x1c4ed5(0x312)](_0x1c4ed5(0x29c));},VisuMZ['BattleVoices']['Game_Battler_removeBuffsAuto']=Game_Battler[_0x2f7f84(0x288)][_0x2f7f84(0x1f2)],Game_Battler['prototype'][_0x2f7f84(0x1f2)]=function(){const _0x3459b3=_0x2f7f84;this[_0x3459b3(0x28c)]=!![],VisuMZ[_0x3459b3(0x24f)][_0x3459b3(0x29e)][_0x3459b3(0x2e7)](this),this[_0x3459b3(0x28c)]=undefined;},VisuMZ[_0x2f7f84(0x24f)][_0x2f7f84(0x318)]=Game_Battler[_0x2f7f84(0x288)]['addDebuff'],Game_Battler[_0x2f7f84(0x288)][_0x2f7f84(0x204)]=function(_0x26bb7e,_0x684970){const _0x23ee21=_0x2f7f84;VisuMZ['BattleVoices'][_0x23ee21(0x318)]['call'](this,_0x26bb7e,_0x684970);if(!SceneManager['isSceneBattle']())return;if(!BattleManager[_0x23ee21(0x205)])return;if(!this[_0x23ee21(0x22a)]())return;this['playBattleVoice'](_0x23ee21(0x2ee));},VisuMZ['BattleVoices']['Game_Battler_removeBuff']=Game_Battler[_0x2f7f84(0x288)][_0x2f7f84(0x2c4)],Game_Battler[_0x2f7f84(0x288)][_0x2f7f84(0x2c4)]=function(_0x7fb3c7){const _0x37e596=_0x2f7f84,_0x2fd80c=this['isBuffAffected'](_0x7fb3c7),_0x13a820=this['isDebuffAffected'](_0x7fb3c7);VisuMZ[_0x37e596(0x24f)][_0x37e596(0x233)][_0x37e596(0x2e7)](this,_0x7fb3c7);if(!SceneManager[_0x37e596(0x1ea)]())return;if(!BattleManager[_0x37e596(0x205)])return;if(this['_expireBuffsAuto'])return;if(!this[_0x37e596(0x22a)]())return;if(_0x2fd80c)this['playBattleVoice'](_0x37e596(0x2d4));if(_0x13a820)this[_0x37e596(0x312)](_0x37e596(0x27f));},VisuMZ[_0x2f7f84(0x24f)][_0x2f7f84(0x2b0)]=Game_Battler[_0x2f7f84(0x288)][_0x2f7f84(0x2cc)],Game_Battler[_0x2f7f84(0x288)][_0x2f7f84(0x2cc)]=function(_0x2e3fd8){const _0x39b737=_0x2f7f84;VisuMZ[_0x39b737(0x24f)]['Game_Battler_addState'][_0x39b737(0x2e7)](this,_0x2e3fd8);if(!SceneManager[_0x39b737(0x1ea)]())return;if(!BattleManager[_0x39b737(0x205)])return;if(!this[_0x39b737(0x22a)]())return;if(!this['isStateAffected'](_0x2e3fd8))return;this[_0x39b737(0x314)](_0x2e3fd8);},Game_Battler['prototype']['addStateVoice']=function(_0x2690ca){const _0xc7b2f4=_0x2f7f84,_0x1b5935=$dataStates[_0x2690ca];if(!_0x1b5935)return;let _0x1b35b9=_0xc7b2f4(0x316);if(Imported[_0xc7b2f4(0x22f)]&&_0x1b5935['note'][_0xc7b2f4(0x21d)](/<POSITIVE STATE>/i))_0x1b35b9+='Positive';else Imported[_0xc7b2f4(0x22f)]&&_0x1b5935[_0xc7b2f4(0x294)][_0xc7b2f4(0x21d)](/<NEGATIVE STATE>/i)?'auvln'!==_0xc7b2f4(0x2ae)?_0x1b35b9+='Negative':(_0x465db8[_0xc7b2f4(0x20f)](_0x1e4909),_0x87c099[_0xc7b2f4(0x2c0)](_0x160190),_0x29aa07[_0xc7b2f4(0x2d8)](_0x1f35ff),_0x27199d['changeBattleVoicePan'](_0x35a9a7)):_0x1b35b9+=_0xc7b2f4(0x1f0);_0x1b35b9+=_0xc7b2f4(0x2a7),this[_0xc7b2f4(0x312)](_0x1b35b9);},VisuMZ['BattleVoices']['Game_Battler_removeStatesAuto']=Game_Battler[_0x2f7f84(0x288)][_0x2f7f84(0x313)],Game_Battler['prototype']['removeStatesAuto']=function(_0x36e164){const _0x440ca6=_0x2f7f84;this['_expireStatesAuto']=!![],VisuMZ[_0x440ca6(0x24f)]['Game_Battler_removeStatesAuto']['call'](this,_0x36e164),this[_0x440ca6(0x240)]=undefined;},VisuMZ[_0x2f7f84(0x24f)][_0x2f7f84(0x1fd)]=Game_Battler[_0x2f7f84(0x288)][_0x2f7f84(0x222)],Game_Battler[_0x2f7f84(0x288)]['removeState']=function(_0x1c9783){const _0x58a9cd=_0x2f7f84,_0x2e4aa7=this['isStateAffected'](_0x1c9783);VisuMZ[_0x58a9cd(0x24f)][_0x58a9cd(0x1fd)][_0x58a9cd(0x2e7)](this,_0x1c9783);if(!SceneManager[_0x58a9cd(0x1ea)]())return;if(!BattleManager[_0x58a9cd(0x205)])return;if(this[_0x58a9cd(0x240)])return;if(!this[_0x58a9cd(0x22a)]())return;if(!_0x2e4aa7)return;this[_0x58a9cd(0x30e)](_0x1c9783);},Game_Battler[_0x2f7f84(0x288)][_0x2f7f84(0x30e)]=function(_0x2029a2){const _0x336bbe=_0x2f7f84,_0x1d6d45=$dataStates[_0x2029a2];if(!_0x1d6d45)return;let _0x511294=_0x336bbe(0x316);if(Imported[_0x336bbe(0x22f)]&&_0x1d6d45['note'][_0x336bbe(0x21d)](/<POSITIVE STATE>/i))_0x511294+=_0x336bbe(0x2ed);else Imported[_0x336bbe(0x22f)]&&_0x1d6d45[_0x336bbe(0x294)][_0x336bbe(0x21d)](/<NEGATIVE STATE>/i)?_0x511294+=_0x336bbe(0x24c):_0x511294+=_0x336bbe(0x1f0);_0x511294+=_0x336bbe(0x2de),this[_0x336bbe(0x312)](_0x511294);},Game_Party[_0x2f7f84(0x288)]['playBattleVoice']=function(_0x48291b){const _0x3e9fa1=_0x2f7f84,_0x557b92=[];for(const _0xdc954 of this[_0x3e9fa1(0x305)]()){const _0x46ffae=_0xdc954['getBattleVoiceData']();if(!_0x46ffae)continue;const _0x3296e2=AudioManager['getVoiceSet'](_0x46ffae['set']);if(!_0x3296e2)continue;const _0x1e0160=_0x3296e2[_0x48291b];if(!_0x1e0160)continue;if(_0x1e0160[_0x3e9fa1(0x2ef)]<=0x0)return;_0x557b92[_0x3e9fa1(0x2c6)](_0xdc954);}const _0x4a1b27=_0x557b92[Math[_0x3e9fa1(0x306)](_0x557b92[_0x3e9fa1(0x2ef)])];_0x4a1b27&&_0x4a1b27[_0x3e9fa1(0x312)](_0x48291b);},VisuMZ['BattleVoices'][_0x2f7f84(0x28d)]=Scene_Options[_0x2f7f84(0x288)][_0x2f7f84(0x2e9)],Scene_Options[_0x2f7f84(0x288)][_0x2f7f84(0x2e9)]=function(){const _0x112e6e=_0x2f7f84;let _0x599fae=VisuMZ['BattleVoices'][_0x112e6e(0x28d)][_0x112e6e(0x2e7)](this);const _0x5e1f6d=VisuMZ[_0x112e6e(0x24f)]['Settings'];if(_0x5e1f6d[_0x112e6e(0x2e4)][_0x112e6e(0x265)]&&_0x5e1f6d[_0x112e6e(0x2e4)][_0x112e6e(0x29f)])_0x599fae++;return _0x599fae;},VisuMZ['BattleVoices']['Window_Options_addGeneralOptions']=Window_Options[_0x2f7f84(0x288)][_0x2f7f84(0x202)],Window_Options['prototype'][_0x2f7f84(0x202)]=function(){const _0x190396=_0x2f7f84;VisuMZ[_0x190396(0x24f)][_0x190396(0x268)][_0x190396(0x2e7)](this),this[_0x190396(0x27c)]();},Window_Options[_0x2f7f84(0x288)][_0x2f7f84(0x27c)]=function(){const _0x1f729f=_0x2f7f84;if(!VisuMZ['BattleVoices']['Settings'][_0x1f729f(0x2e4)][_0x1f729f(0x265)])return;const _0x53e279=TextManager[_0x1f729f(0x237)],_0x5a7604=_0x1f729f(0x237);this['addCommand'](_0x53e279,_0x5a7604);};