//=============================================================================
// VisuStella MZ - Evolution Matrix Skills
// VisuMZ_3_EvoMatrixSkills.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_3_EvoMatrixSkills = true;

var VisuMZ = VisuMZ || {};
VisuMZ.EvoMatrixSkills = VisuMZ.EvoMatrixSkills || {};
VisuMZ.EvoMatrixSkills.version = 1.02;

//=============================================================================
/* ----------------------------------------------------------------------------
 * Sound Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Sound:
 *
 * @param name:str
 * @text Filename
 * @type file
 * @dir audio/se/
 * @require 1
 * @desc Filename of the sound effect played.
 * @default Skill3
 *
 * @param volume:num
 * @text Volume
 * @type number
 * @max 100
 * @desc Volume of the sound effect played.
 * @default 90
 *
 * @param pitch:num
 * @text Pitch
 * @type number
 * @desc Pitch of the sound effect played.
 * @default 100
 *
 * @param pan:num
 * @text Pan
 * @desc Pan of the sound effect played.
 * @default 0
 *
 */
/* ----------------------------------------------------------------------------
 * UI Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~UI:
 *
 * @param General
 *
 * @param BackgroundImage:str
 * @text Custom BG Image
 * @parent General
 * @type file
 * @dir img/system/
 * @require 1
 * @desc Do you want to use a custom background image?
 * Located in /img/system/ folder. Covers whole screen.
 * @default 
 *
 * @param EvoMatrixText:str
 * @text Evo Matrix Text
 * @parent General
 * @desc What text do you want displayed when starting an Evolution Matrix sequence?
 * @default Select Skill Evolution
 *
 * @param EvoMatrixAnimation:num
 * @text Matrix Animation
 * @parent EvoMatrixText:str
 * @type animation
 * @desc What animation should be played when evolving skills?
 * Requires VisuMZ_0_CoreEngine!
 * @default 58
 *
 * @param LargeIconSmoothing:eval
 * @text Icon Smoothing?
 * @parent General
 * @type boolean
 * @on Smooth
 * @off Pixelate
 * @desc Smooth the display for icons?
 * Or pixelate them?
 * @default false
 *
 * @param OpacityDisable:num
 * @text Disabled Opacity
 * @parent General
 * @desc What is the opacity level for disabled UI elements?
 * @default 128
 *
 * @param OpacityRate:num
 * @text Opacity Rate
 * @parent General
 * @desc Fade in/out the background at what opacity rate?
 * Lower is slower. Higher is faster.
 * @default 16
 *
 * @param Scale:num
 * @text Scale
 * @parent General
 * @desc What is the scale of UI buttons?
 * 0.50 = 50%; 1.00 = 100%; 1.50 = 150%;
 * @default 0.50
 *
 * @param contentDrawJS:func
 * @text JS: Draw Skill Data
 * @parent General
 * @type note
 * @desc Code used to draw the skill data layer while
 * Input Combo Skill inputs are active.
 * @default "// Declare Constants\nconst skill = arguments[0];\nconst keyIcon = arguments[1];\nconst costText = arguments[2];\nconst bitmap = this.contents;\nconst lineHeight = this.lineHeight();\nconst iconIndex = skill.iconIndex;\nconst iconSize = ImageManager.iconWidth * 2;\n\n// Draw Large Icon\nconst hx = Math.ceil(bitmap.width / 2);\nthis.drawEvoMatrixLargeIcon(iconIndex, hx, 0, iconSize);\n\n// Draw Keybind Icon\nconst kx = hx - iconSize;\nthis.drawEvoMatrixLargeIcon(keyIcon, kx, 0, iconSize);\n\n// Draw Rounded Rectangle\nconst rx = 0;\nconst ry = Math.round(iconSize + lineHeight * 0.25);\nconst rw = bitmap.width;\nconst rh = Math.round(lineHeight * 1.75);\nconst radius = 20;\nconst rcolor = ColorManager.dimColor1();\nbitmap.fillRoundRect(rx, ry, rw, rh, radius, rcolor);\n\n// Draw Skill Name\nconst name = skill.name;\nconst ny = ry + ((costText.length > 0) ? 0 : Math.floor((rh - lineHeight) / 2));\nthis.drawText(name, 0, ny, bitmap.width, 'center');\n\n// Draw Cost Text\nconst cw = this.textSizeEx(costText).width;\nconst cx = Math.floor((bitmap.width - cw) / 2);\nconst cy = ry + Math.ceil(lineHeight * 0.75);\nthis.drawTextEx(costText, cx, cy);"
 *
 * @param backgroundDrawJS:func
 * @text JS: Draw Background
 * @parent General
 * @type note
 * @desc Code used to draw the background layer while
 * Input Combo Skill inputs are active.
 * @default "// Declare Constants\nconst bitmap = this;\nconst width = bitmap.width / 2;\nconst height = bitmap.height;\nconst x1 = 0;\nconst x2 = Math.floor(width);\nconst y = 0;\nconst color1 = ColorManager.dimColor1();\nconst color2 = ColorManager.dimColor2();\n\n// Draw Gradient Background\nbitmap.gradientFillRect(x1, y, Math.floor(width), height, color1, color2);\nbitmap.gradientFillRect(x2, y, Math.ceil(width), height, color2, color1);"
 *
 * @param Movement
 *
 * @param MoveDuration:num
 * @text Move Duration
 * @parent Movement
 * @type number
 * @min 1
 * @desc How many frames should it take to move the buttons into place?
 * @default 20
 *
 * @param MoveInEasing:str
 * @text In Easing
 * @parent Movement
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine!
 * @default OutSine
 *
 * @param MoveOutEasing:str
 * @text Out Easing
 * @parent Movement
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine!
 * @default InSine
 * 
 * @param Keybinds
 * @text Key Binds
 * 
 * @param KeybindOffsets
 * @text Offsets
 * @parent Keybinds
 *
 * @param KeybindUiOffsetX:num
 * @text Key Bind Offset X
 * @parent KeybindOffsets
 * @desc Offset the x coordinate all of key bind buttons.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param KeybindUiOffsetY:num
 * @text Key Bind Offset Y
 * @parent KeybindOffsets
 * @desc Offset the y coordinate all of key bind buttons.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @param KeybindPressed
 * @text Pressed
 * @parent Keybinds
 *
 * @param KeypressUiOffsetX:num
 * @text Key Press Offset X
 * @parent KeybindPressed
 * @desc Offset the x coordinate when the key is pressed.
 * Negative: left. Positive: right.
 * @default -4
 *
 * @param KeypressUiOffsetY:num
 * @text Key Press Offset Y
 * @parent KeybindPressed
 * @desc Offset the y coordinate when the key is pressed.
 * Negative: up. Positive: down.
 * @default +4
 * 
 * @param Down
 * @parent Keybinds
 *
 * @param downKeyIcon:num
 * @text Key Icon
 * @parent Down
 * @desc What is the icon used to mark this key bind?
 * Takes priority over Core Engine's Button Assist.
 * @default 0
 *
 * @param downBackgroundImage:str
 * @text Custom BG Image
 * @parent Down
 * @type file
 * @dir img/system/
 * @require 1
 * @desc Do you want to use a custom background image?
 * Located in /img/system/ folder. Ignores scaling.
 * @default 
 * 
 * @param downRectJS:func
 * @text JS: X, Y, W, H
 * @parent Down
 * @type note
 * @desc Code used to determine the dimensions for this button.
 * @default "// Declare Constants\nconst uiWidth = Math.floor(Graphics.width / 3);\nconst spacing = 8;\nconst lineHeight = Window_Base.prototype.lineHeight();\nconst lines = 4;\n\n// Calculate Dimensions\nconst w = Math.floor(uiWidth / 3) - (spacing * 2);\nconst rectWidth = Math.max(192, w);\nconst h = lines * lineHeight;\nconst x = Math.floor(Graphics.width / 2);\nconst y = Math.floor(Graphics.height / 2) + Math.floor(Graphics.height / 4);\n\n// Return Rectangle\nreturn new Rectangle(x, y, rectWidth, h);"
 * 
 * @param Left
 * @parent Keybinds
 *
 * @param leftKeyIcon:num
 * @text Key Icon
 * @parent Left
 * @desc What is the icon used to mark this key bind?
 * Takes priority over Core Engine's Button Assist.
 * @default 0
 *
 * @param leftBackgroundImage:str
 * @text Custom BG Image
 * @parent Left
 * @type file
 * @dir img/system/
 * @require 1
 * @desc Do you want to use a custom background image?
 * Located in /img/system/ folder. Ignores scaling.
 * @default 
 * 
 * @param leftRectJS:func
 * @text JS: X, Y, W, H
 * @parent Left
 * @type note
 * @desc Code used to determine the dimensions for this button.
 * @default "// Declare Constants\nconst uiWidth = Math.floor(Graphics.width / 3);\nconst spacing = 8;\nconst lineHeight = Window_Base.prototype.lineHeight();\nconst lines = 4;\n\n// Calculate Dimensions\nconst w = Math.floor(uiWidth / 3) - (spacing * 2);\nconst rectWidth = Math.max(192, w);\nconst h = lines * lineHeight;\nconst x = Math.floor(Graphics.width / 2) - Math.floor(Graphics.width / 4);\nconst y = Math.floor(Graphics.height / 2);\n\n// Return Rectangle\nreturn new Rectangle(x, y, rectWidth, h);"
 * 
 * @param Right
 * @parent Keybinds
 *
 * @param rightKeyIcon:num
 * @text Key Icon
 * @parent Right
 * @desc What is the icon used to mark this key bind?
 * Takes priority over Core Engine's Button Assist.
 * @default 0
 *
 * @param rightBackgroundImage:str
 * @text Custom BG Image
 * @parent Right
 * @type file
 * @dir img/system/
 * @require 1
 * @desc Do you want to use a custom background image?
 * Located in /img/system/ folder. Ignores scaling.
 * @default 
 * 
 * @param rightRectJS:func
 * @text JS: X, Y, W, H
 * @parent Right
 * @type note
 * @desc Code used to determine the dimensions for this button.
 * @default "// Declare Constants\nconst uiWidth = Math.floor(Graphics.width / 3);\nconst spacing = 8;\nconst lineHeight = Window_Base.prototype.lineHeight();\nconst lines = 4;\n\n// Calculate Dimensions\nconst w = Math.floor(uiWidth / 3) - (spacing * 2);\nconst rectWidth = Math.max(192, w);\nconst h = lines * lineHeight;\nconst x = Math.floor(Graphics.width / 2) + Math.floor(Graphics.width / 4);\nconst y = Math.floor(Graphics.height / 2);\n\n// Return Rectangle\nreturn new Rectangle(x, y, rectWidth, h);"
 * 
 * @param Up
 * @parent Keybinds
 *
 * @param upKeyIcon:num
 * @text Key Icon
 * @parent Up
 * @desc What is the icon used to mark this key bind?
 * Takes priority over Core Engine's Button Assist.
 * @default 0
 *
 * @param upBackgroundImage:str
 * @text Custom BG Image
 * @parent Up
 * @type file
 * @dir img/system/
 * @require 1
 * @desc Do you want to use a custom background image?
 * Located in /img/system/ folder. Ignores scaling.
 * @default 
 * 
 * @param upRectJS:func
 * @text JS: X, Y, W, H
 * @parent Up
 * @type note
 * @desc Code used to determine the dimensions for this button.
 * @default "// Declare Constants\nconst uiWidth = Math.floor(Graphics.width / 3);\nconst spacing = 8;\nconst lineHeight = Window_Base.prototype.lineHeight();\nconst lines = 4;\n\n// Calculate Dimensions\nconst w = Math.floor(uiWidth / 3) - (spacing * 2);\nconst rectWidth = Math.max(192, w);\nconst h = lines * lineHeight;\nconst x = Math.floor(Graphics.width / 2);\nconst y = Math.floor(Graphics.height / 2) - Math.floor(Graphics.height / 4);\n\n// Return Rectangle\nreturn new Rectangle(x, y, rectWidth, h);"
 * 
 * @param Ok
 * @parent Keybinds
 *
 * @param okKeyIcon:num
 * @text Key Icon
 * @parent Ok
 * @desc What is the icon used to mark this key bind?
 * Takes priority over Core Engine's Button Assist.
 * @default 0
 *
 * @param okBackgroundImage:str
 * @text Custom BG Image
 * @parent Ok
 * @type file
 * @dir img/system/
 * @require 1
 * @desc Do you want to use a custom background image?
 * Located in /img/system/ folder. Ignores scaling.
 * @default 
 *
 * @param okCostText:str
 * @text Cost Text
 * @parent Ok
 * @desc What text do you wish to display for this skill's cost?
 * Text codes allowed.
 * @default \C[17]DONE\C[0]
 * 
 * @param okRectJS:func
 * @text JS: X, Y, W, H
 * @parent Ok
 * @type note
 * @desc Code used to determine the dimensions for this button.
 * @default "// Declare Constants\nconst uiWidth = Math.floor(Graphics.width / 3);\nconst spacing = 8;\nconst lineHeight = Window_Base.prototype.lineHeight();\nconst lines = 4;\n\n// Calculate Dimensions\nconst w = Math.floor(uiWidth / 3) - (spacing * 2);\nconst rectWidth = Math.max(192, w);\nconst h = lines * lineHeight;\nconst x = Math.floor(Graphics.width / 2);\nconst y = Math.floor(Graphics.height / 2);\n\n// Return Rectangle\nreturn new Rectangle(x, y, rectWidth, h);"
 * 
 * @param Cancel
 * @parent Keybinds
 *
 * @param cancelKeyIcon:num
 * @text Key Icon
 * @parent Cancel
 * @desc What is the icon used to mark this key bind?
 * Takes priority over Core Engine's Button Assist.
 * @default 0
 *
 * @param cancelBackgroundImage:str
 * @text Custom BG Image
 * @parent Cancel
 * @type file
 * @dir img/system/
 * @require 1
 * @desc Do you want to use a custom background image?
 * Located in /img/system/ folder. Ignores scaling.
 * @default 
 * 
 * @param cancelRectJS:func
 * @text JS: X, Y, W, H
 * @parent Cancel
 * @type note
 * @desc Code used to determine the dimensions for this button.
 * @default "// Declare Constants\nconst uiWidth = Math.floor(Graphics.width / 3);\nconst spacing = 8;\nconst lineHeight = Window_Base.prototype.lineHeight();\nconst lines = 4;\n\n// Calculate Dimensions\nconst w = Math.floor(uiWidth / 3) - (spacing * 2);\nconst rectWidth = Math.max(192, w);\nconst h = lines * lineHeight;\nconst x = Math.floor(Graphics.width / 2) + Math.floor(Graphics.width / 4);\nconst y = Math.floor(Graphics.height / 2) + Math.floor(Graphics.height / 4);\n\n// Return Rectangle\nreturn new Rectangle(x, y, rectWidth, h);"
 * 
 * @param PageUp
 * @parent Keybinds
 *
 * @param pageupKeyIcon:num
 * @text Key Icon
 * @parent PageUp
 * @desc What is the icon used to mark this key bind?
 * Takes priority over Core Engine's Button Assist.
 * @default 0
 *
 * @param pageupBackgroundImage:str
 * @text Custom BG Image
 * @parent PageUp
 * @type file
 * @dir img/system/
 * @require 1
 * @desc Do you want to use a custom background image?
 * Located in /img/system/ folder. Ignores scaling.
 * @default 
 * 
 * @param pageupRectJS:func
 * @text JS: X, Y, W, H
 * @parent PageUp
 * @type note
 * @desc Code used to determine the dimensions for this button.
 * @default "// Declare Constants\nconst uiWidth = Math.floor(Graphics.width / 3);\nconst spacing = 8;\nconst lineHeight = Window_Base.prototype.lineHeight();\nconst lines = 4;\n\n// Calculate Dimensions\nconst w = Math.floor(uiWidth / 3) - (spacing * 2);\nconst rectWidth = Math.max(192, w);\nconst h = lines * lineHeight;\nconst x = Math.floor(Graphics.width / 2) - Math.floor(Graphics.width / 4);\nconst y = Math.floor(Graphics.height / 2) - Math.floor(Graphics.height / 4);\n\n// Return Rectangle\nreturn new Rectangle(x, y, rectWidth, h);"
 * 
 * @param PageDown
 * @parent Keybinds
 *
 * @param pagedownKeyIcon:num
 * @text Key Icon
 * @parent PageDown
 * @desc What is the icon used to mark this key bind?
 * Takes priority over Core Engine's Button Assist.
 * @default 0
 *
 * @param pagedownBackgroundImage:str
 * @text Custom BG Image
 * @parent PageDown
 * @type file
 * @dir img/system/
 * @require 1
 * @desc Do you want to use a custom background image?
 * Located in /img/system/ folder. Ignores scaling.
 * @default 
 * 
 * @param pagedownRectJS:func
 * @text JS: X, Y, W, H
 * @parent PageDown
 * @type note
 * @desc Code used to determine the dimensions for this button.
 * @default "// Declare Constants\nconst uiWidth = Math.floor(Graphics.width / 3);\nconst spacing = 8;\nconst lineHeight = Window_Base.prototype.lineHeight();\nconst lines = 4;\n\n// Calculate Dimensions\nconst w = Math.floor(uiWidth / 3) - (spacing * 2);\nconst rectWidth = Math.max(192, w);\nconst h = lines * lineHeight;\nconst x = Math.floor(Graphics.width / 2) + Math.floor(Graphics.width / 4);\nconst y = Math.floor(Graphics.height / 2) - Math.floor(Graphics.height / 4);\n\n// Return Rectangle\nreturn new Rectangle(x, y, rectWidth, h);"
 * 
 * @param Shift
 * @parent Keybinds
 *
 * @param shiftKeyIcon:num
 * @text Key Icon
 * @parent Shift
 * @desc What is the icon used to mark this key bind?
 * Takes priority over Core Engine's Button Assist.
 * @default 0
 *
 * @param shiftBackgroundImage:str
 * @text Custom BG Image
 * @parent Shift
 * @type file
 * @dir img/system/
 * @require 1
 * @desc Do you want to use a custom background image?
 * Located in /img/system/ folder. Ignores scaling.
 * @default 
 * 
 * @param shiftRectJS:func
 * @text JS: X, Y, W, H
 * @parent Shift
 * @type note
 * @desc Code used to determine the dimensions for this button.
 * @default "// Declare Constants\nconst uiWidth = Math.floor(Graphics.width / 3);\nconst spacing = 8;\nconst lineHeight = Window_Base.prototype.lineHeight();\nconst lines = 4;\n\n// Calculate Dimensions\nconst w = Math.floor(uiWidth / 3) - (spacing * 2);\nconst rectWidth = Math.max(192, w);\nconst h = lines * lineHeight;\nconst x = Math.floor(Graphics.width / 2) - Math.floor(Graphics.width / 4);\nconst y = Math.floor(Graphics.height / 2) + Math.floor(Graphics.height / 4);\n\n// Return Rectangle\nreturn new Rectangle(x, y, rectWidth, h);"
 *
 */
/* ----------------------------------------------------------------------------
 * Tooltip Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Tooltip:
 *
 * @param enabled:eval
 * @text Enabled?
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Are tooltips enabled?
 * Requires VisuMZ_1_MessageCore!
 * @default true
 *
 * @param Appearance
 *
 * @param Scale:num
 * @text Scale
 * @parent Appearance
 * @desc What scale size do you want for the tooltip?
 * Use 1.0 for normal size.
 * @default 0.6
 *
 * @param WindowSkin:str
 * @text Skin Filename
 * @parent Appearance
 * @type file
 * @dir img/system/
 * @desc What window skin do you want to use for the tooltip?
 * @default Window
 *
 * @param WindowOpacity:num
 * @text Skin Opacity
 * @parent Appearance
 * @type number
 * @min 0
 * @max 255
 * @desc What opacity setting is used for the tooltip?
 * Use a number between 0 and 255.
 * @default 240
 *
 * @param Offset
 *
 * @param OffsetX:num
 * @text Offset X
 * @parent Offset
 * @desc Offset the tooltip X position from the mouse?
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param OffsetY:num
 * @text Offset Y
 * @parent Offset
 * @desc Offset the tooltip Y position from the mouse?
 * Negative: up. Positive: down.
 * @default +0
 *
 */
//=============================================================================

const _0x487f57=_0x3f6b;function _0x3f6b(_0xf695e1,_0xd246ba){const _0x655a82=_0x655a();return _0x3f6b=function(_0x3f6b40,_0x3300d8){_0x3f6b40=_0x3f6b40-0x1af;let _0x2e9df3=_0x655a82[_0x3f6b40];return _0x2e9df3;},_0x3f6b(_0xf695e1,_0xd246ba);}(function(_0x241bfe,_0x4a843e){const _0x3bae37=_0x3f6b,_0x3f47f4=_0x241bfe();while(!![]){try{const _0x56d386=-parseInt(_0x3bae37(0x27e))/0x1+parseInt(_0x3bae37(0x2f0))/0x2*(-parseInt(_0x3bae37(0x1c4))/0x3)+-parseInt(_0x3bae37(0x269))/0x4+parseInt(_0x3bae37(0x24f))/0x5*(parseInt(_0x3bae37(0x1f1))/0x6)+parseInt(_0x3bae37(0x2dc))/0x7+-parseInt(_0x3bae37(0x1f8))/0x8*(parseInt(_0x3bae37(0x27a))/0x9)+parseInt(_0x3bae37(0x213))/0xa*(parseInt(_0x3bae37(0x2dd))/0xb);if(_0x56d386===_0x4a843e)break;else _0x3f47f4['push'](_0x3f47f4['shift']());}catch(_0x744f79){_0x3f47f4['push'](_0x3f47f4['shift']());}}}(_0x655a,0x494bc));var label=_0x487f57(0x1bc),tier=tier||0x0,dependencies=[_0x487f57(0x1d6),_0x487f57(0x26a)],pluginData=$plugins[_0x487f57(0x297)](function(_0x5c11c5){const _0xad074e=_0x487f57;return _0x5c11c5[_0xad074e(0x254)]&&_0x5c11c5[_0xad074e(0x2fd)][_0xad074e(0x2cb)]('['+label+']');})[0x0];VisuMZ[label]['Settings']=VisuMZ[label][_0x487f57(0x21d)]||{},VisuMZ[_0x487f57(0x1fc)]=function(_0x21db8f,_0x43bbbf){const _0x505124=_0x487f57;for(const _0x5b3b63 in _0x43bbbf){if(_0x5b3b63['match'](/(.*):(.*)/i)){const _0x396951=String(RegExp['$1']),_0x4515b5=String(RegExp['$2'])[_0x505124(0x1ca)]()[_0x505124(0x2ce)]();let _0x1500a6,_0x3e7130,_0x5be0b2;switch(_0x4515b5){case'NUM':_0x1500a6=_0x43bbbf[_0x5b3b63]!==''?Number(_0x43bbbf[_0x5b3b63]):0x0;break;case _0x505124(0x27c):_0x3e7130=_0x43bbbf[_0x5b3b63]!==''?JSON['parse'](_0x43bbbf[_0x5b3b63]):[],_0x1500a6=_0x3e7130[_0x505124(0x1e3)](_0x2531f3=>Number(_0x2531f3));break;case _0x505124(0x2a4):_0x1500a6=_0x43bbbf[_0x5b3b63]!==''?eval(_0x43bbbf[_0x5b3b63]):null;break;case _0x505124(0x1cf):_0x3e7130=_0x43bbbf[_0x5b3b63]!==''?JSON[_0x505124(0x2af)](_0x43bbbf[_0x5b3b63]):[],_0x1500a6=_0x3e7130[_0x505124(0x1e3)](_0x581a24=>eval(_0x581a24));break;case _0x505124(0x240):_0x1500a6=_0x43bbbf[_0x5b3b63]!==''?JSON[_0x505124(0x2af)](_0x43bbbf[_0x5b3b63]):'';break;case'ARRAYJSON':_0x3e7130=_0x43bbbf[_0x5b3b63]!==''?JSON[_0x505124(0x2af)](_0x43bbbf[_0x5b3b63]):[],_0x1500a6=_0x3e7130[_0x505124(0x1e3)](_0x3eff90=>JSON[_0x505124(0x2af)](_0x3eff90));break;case _0x505124(0x2c1):_0x1500a6=_0x43bbbf[_0x5b3b63]!==''?new Function(JSON[_0x505124(0x2af)](_0x43bbbf[_0x5b3b63])):new Function(_0x505124(0x29b));break;case _0x505124(0x247):_0x3e7130=_0x43bbbf[_0x5b3b63]!==''?JSON[_0x505124(0x2af)](_0x43bbbf[_0x5b3b63]):[],_0x1500a6=_0x3e7130[_0x505124(0x1e3)](_0x476d07=>new Function(JSON['parse'](_0x476d07)));break;case _0x505124(0x293):_0x1500a6=_0x43bbbf[_0x5b3b63]!==''?String(_0x43bbbf[_0x5b3b63]):'';break;case _0x505124(0x1d0):_0x3e7130=_0x43bbbf[_0x5b3b63]!==''?JSON[_0x505124(0x2af)](_0x43bbbf[_0x5b3b63]):[],_0x1500a6=_0x3e7130[_0x505124(0x1e3)](_0x55b69d=>String(_0x55b69d));break;case'STRUCT':_0x5be0b2=_0x43bbbf[_0x5b3b63]!==''?JSON['parse'](_0x43bbbf[_0x5b3b63]):{},_0x1500a6=VisuMZ['ConvertParams']({},_0x5be0b2);break;case'ARRAYSTRUCT':_0x3e7130=_0x43bbbf[_0x5b3b63]!==''?JSON[_0x505124(0x2af)](_0x43bbbf[_0x5b3b63]):[],_0x1500a6=_0x3e7130['map'](_0x197105=>VisuMZ[_0x505124(0x1fc)]({},JSON[_0x505124(0x2af)](_0x197105)));break;default:continue;}_0x21db8f[_0x396951]=_0x1500a6;}}return _0x21db8f;},(_0x3047ef=>{const _0x2fa827=_0x487f57,_0x161893=_0x3047ef[_0x2fa827(0x28b)];for(const _0x4204e2 of dependencies){if(!Imported[_0x4204e2]){alert(_0x2fa827(0x1e5)[_0x2fa827(0x1d1)](_0x161893,_0x4204e2)),SceneManager[_0x2fa827(0x1df)]();break;}}const _0x4d5c2b=_0x3047ef[_0x2fa827(0x2fd)];if(_0x4d5c2b['match'](/\[Version[ ](.*?)\]/i)){const _0x425d4b=Number(RegExp['$1']);_0x425d4b!==VisuMZ[label]['version']&&('lAKhi'!==_0x2fa827(0x1bb)?(alert('%1\x27s\x20version\x20does\x20not\x20match\x20plugin\x27s.\x20Please\x20update\x20it\x20in\x20the\x20Plugin\x20Manager.'[_0x2fa827(0x1d1)](_0x161893,_0x425d4b)),SceneManager[_0x2fa827(0x1df)]()):this[_0x2fa827(0x1fe)](...arguments));}if(_0x4d5c2b[_0x2fa827(0x258)](/\[Tier[ ](\d+)\]/i)){const _0x566b41=Number(RegExp['$1']);if(_0x566b41<tier){if('JNzNO'!==_0x2fa827(0x1ce)){const _0x2aa7dc=new _0x25172b();this['_evoMatrixSkillsUiContainer'][_0x2fa827(0x2ae)](_0x2aa7dc);const _0x2f7ad0=_0x55670d['loadSystem'](_0x4f871b[_0x2fa827(0x29e)]);_0x2aa7dc[_0x2fa827(0x278)]=_0x2f7ad0;}else alert(_0x2fa827(0x212)[_0x2fa827(0x1d1)](_0x161893,_0x566b41,tier)),SceneManager[_0x2fa827(0x1df)]();}else tier=Math[_0x2fa827(0x25a)](_0x566b41,tier);}VisuMZ['ConvertParams'](VisuMZ[label][_0x2fa827(0x21d)],_0x3047ef['parameters']);})(pluginData),VisuMZ['EvoMatrixSkills'][_0x487f57(0x226)]={'AvailableMatrix':/<(?:AVAILABLE EVO MATRIX|AVAILABLE MATRIX|EVO MATRIX|MATRIX) SKILL[ ](.*):[ ](.*)>/gi,'ForcedMatrix':/<(?:ALWAYS|FORCE|FORCED) (?:EVO MATRIX|MATRIX) SKILL[ ](.*):[ ](.*)>/gi,'LearnedMatrix':/<(?:LEARNED|KNOWN) (?:EVO MATRIX|MATRIX) SKILL[ ](.*):[ ](.*)>/gi,'MatrixOnly':/<(?:EVO MATRIX|MATRIX) ONLY>/i,'StartAni':/<(?:EVO MATRIX|MATRIX) (?:ANI|ANIMATION):[ ](\d+)>/i},VisuMZ['EvoMatrixSkills'][_0x487f57(0x2d9)]=[_0x487f57(0x2bd),_0x487f57(0x2d6),_0x487f57(0x22b),'up','ok',_0x487f57(0x2f1),'pageup',_0x487f57(0x224),_0x487f57(0x1ff)],VisuMZ['EvoMatrixSkills'][_0x487f57(0x27d)]=function(_0x47fca8){const _0x5b0730=_0x487f57;_0x47fca8=_0x47fca8[_0x5b0730(0x1c7)]()[_0x5b0730(0x2ce)]();switch(_0x47fca8){case'2':return _0x5b0730(0x2bd);case'4':return _0x5b0730(0x2d6);case'6':return _0x5b0730(0x22b);case'8':return'up';case's':return _0x5b0730(0x1ff);case'z':return'ok';case'x':return _0x5b0730(0x2f1);case'q':return'pageup';case'w':return _0x5b0730(0x224);}return _0x47fca8;},DataManager[_0x487f57(0x211)]=function(_0x54a2ad){const _0x5c7355=_0x487f57;if(!_0x54a2ad)return!![];if(!DataManager[_0x5c7355(0x2b8)](_0x54a2ad))return!![];this['_hasEvoMatrixSkillsConflict']=this[_0x5c7355(0x1c6)]||{};if(this['_hasEvoMatrixSkillsConflict'][_0x54a2ad['id']])return this[_0x5c7355(0x1c6)][_0x54a2ad['id']];const _0x434287=_0x54a2ad[_0x5c7355(0x257)]||'',_0x4ccedf=[_0x5c7355(0x234),_0x5c7355(0x27f),_0x5c7355(0x223)];this[_0x5c7355(0x1c6)][_0x54a2ad['id']]=![];for(const _0x146bc5 of _0x4ccedf){if(!VisuMZ[_0x146bc5])continue;const _0x5d7ffd=VisuMZ[_0x146bc5]['RegExp'];for(const _0x28a369 in _0x5d7ffd){if(_0x434287[_0x5c7355(0x258)](_0x5d7ffd[_0x28a369])){if(_0x5c7355(0x2cd)===_0x5c7355(0x2cd)){this[_0x5c7355(0x1c6)][_0x54a2ad['id']]=!![];break;}else this[_0x5c7355(0x2a6)]=!![],this[_0x5c7355(0x2e6)]();}}if(this[_0x5c7355(0x1c6)][_0x54a2ad['id']])break;}return this[_0x5c7355(0x1c6)][_0x54a2ad['id']];},DataManager[_0x487f57(0x1b5)]=function(_0x3ba56a,_0xcc9e85){const _0x5bbad8=_0x487f57;return this[_0x5bbad8(0x210)](_0x3ba56a,_0xcc9e85)[_0x5bbad8(0x22a)]>0x0;},DataManager[_0x487f57(0x210)]=function(_0x9bada1,_0x1c8fe1){const _0x4c8651=_0x487f57;if(!_0x1c8fe1)return[];if(!_0x9bada1)return[];if(!DataManager[_0x4c8651(0x2b8)](_0x1c8fe1))return[];if(DataManager[_0x4c8651(0x211)](_0x1c8fe1))return[];const _0xfcce73=VisuMZ[_0x4c8651(0x1bc)]['RegExp'],_0x35f126=[_0x4c8651(0x294),'ForcedMatrix','LearnedMatrix'],_0x49566f=_0x1c8fe1[_0x4c8651(0x257)]||'',_0x705f91=[];for(const _0x17b490 of _0x35f126){const _0xd0d2c8=_0x49566f[_0x4c8651(0x258)](_0xfcce73[_0x17b490]);if(_0xd0d2c8)for(const _0x2aec5d of _0xd0d2c8){_0x2aec5d['match'](_0xfcce73[_0x17b490]);const _0x3701c7=String(RegExp['$1'])['toUpperCase']()[_0x4c8651(0x2ce)](),_0x119ad8=String(RegExp['$2']);if(_0x3701c7==='OK'||_0x3701c7==='Z')continue;let _0x4398a4=0x0;const _0x5bbe50=/^\d+$/[_0x4c8651(0x2a1)](_0x119ad8);if(_0x5bbe50){if('NfgzS'!==_0x4c8651(0x26e))_0x4398a4=Number(_0x119ad8);else{if(!_0x3e0a91)return _0x5075c2[_0x4c8651(0x2b3)];if(!_0x515a7d[_0x4c8651(0x2b8)](_0x3d47d1))return _0x320913[_0x4c8651(0x2b3)];const _0x43f049=_0x328113['EvoMatrixSkills'][_0x4c8651(0x226)],_0x1c6d4a=_0x473e5f[_0x4c8651(0x257)]||'';if(_0x1c6d4a[_0x4c8651(0x258)](_0x43f049[_0x4c8651(0x1ea)]))return _0x21e1c2(_0x543670['$1']);return _0x53a963[_0x4c8651(0x2b3)];}}else _0x4398a4=DataManager[_0x4c8651(0x280)](_0x119ad8);if(_0x4398a4<=0x0)continue;if(_0x17b490===_0x4c8651(0x294)&&!_0x9bada1[_0x4c8651(0x25e)](_0x4398a4))continue;if(_0x17b490===_0x4c8651(0x2e8)&&!_0x9bada1[_0x4c8651(0x1c8)](_0x4398a4))continue;const _0x3b960d=$dataSkills[_0x4398a4];if(_0x3b960d)_0x705f91[_0x4c8651(0x25c)](_0x3b960d);}}return _0x705f91;},DataManager[_0x487f57(0x2ea)]=function(_0xca37e2){const _0x2115f2=_0x487f57;if(!_0xca37e2)return Window_BattleLog[_0x2115f2(0x2b3)];if(!DataManager[_0x2115f2(0x2b8)](_0xca37e2))return Window_BattleLog['EVO_MATRIX_ANIMATION'];const _0x54a20d=VisuMZ[_0x2115f2(0x1bc)][_0x2115f2(0x226)],_0x228a4d=_0xca37e2[_0x2115f2(0x257)]||'';if(_0x228a4d[_0x2115f2(0x258)](_0x54a20d[_0x2115f2(0x1ea)]))return Number(RegExp['$1']);return Window_BattleLog[_0x2115f2(0x2b3)];},Bitmap['prototype']['fillRoundRect']=function(_0x1bb30d,_0x5f2141,_0x484129,_0x323426,_0x2d26f0,_0xc7bf15){const _0x40b285=_0x487f57,_0x5067c7=_0x1bb30d+_0x484129,_0x4f7bdf=_0x5f2141+_0x323426,_0x5862e3=this[_0x40b285(0x281)];_0x5862e3[_0x40b285(0x2a8)](),_0x5862e3[_0x40b285(0x2d3)]=_0xc7bf15,_0x5862e3[_0x40b285(0x292)](),_0x5862e3[_0x40b285(0x214)](_0x1bb30d+_0x2d26f0,_0x5f2141),_0x5862e3[_0x40b285(0x1cd)](_0x5067c7-_0x2d26f0,_0x5f2141),_0x5862e3[_0x40b285(0x2a2)](_0x5067c7,_0x5f2141,_0x5067c7,_0x5f2141+_0x2d26f0),_0x5862e3[_0x40b285(0x1cd)](_0x5067c7,_0x5f2141+_0x323426-_0x2d26f0),_0x5862e3[_0x40b285(0x2a2)](_0x5067c7,_0x4f7bdf,_0x5067c7-_0x2d26f0,_0x4f7bdf),_0x5862e3[_0x40b285(0x1cd)](_0x1bb30d+_0x2d26f0,_0x4f7bdf),_0x5862e3['quadraticCurveTo'](_0x1bb30d,_0x4f7bdf,_0x1bb30d,_0x4f7bdf-_0x2d26f0),_0x5862e3[_0x40b285(0x1cd)](_0x1bb30d,_0x5f2141+_0x2d26f0),_0x5862e3['quadraticCurveTo'](_0x1bb30d,_0x5f2141,_0x1bb30d+_0x2d26f0,_0x5f2141),_0x5862e3['fill'](),_0x5862e3[_0x40b285(0x2e2)](),this[_0x40b285(0x230)][_0x40b285(0x23c)]();},SoundManager['playEvoMatrixSkillsSound']=function(){const _0x26e55f=_0x487f57,_0x2c02bb=VisuMZ['EvoMatrixSkills'][_0x26e55f(0x21d)][_0x26e55f(0x2be)],_0x35fe75={'name':_0x2c02bb[_0x26e55f(0x28b)],'volume':_0x2c02bb['volume'],'pitch':_0x2c02bb[_0x26e55f(0x243)],'pan':_0x2c02bb[_0x26e55f(0x272)]};AudioManager[_0x26e55f(0x2c0)](_0x35fe75);},VisuMZ[_0x487f57(0x1bc)][_0x487f57(0x2b6)]=BattleManager[_0x487f57(0x266)],BattleManager[_0x487f57(0x266)]=function(){const _0x2a6087=_0x487f57;$gameVariables[_0x2a6087(0x2d1)]();const _0x230b95=DataManager['hasEvoMatrixSkillPath'](this[_0x2a6087(0x1e9)],this[_0x2a6087(0x1e9)][_0x2a6087(0x2cf)]()[_0x2a6087(0x285)]());if(_0x230b95){if(_0x2a6087(0x2fa)===_0x2a6087(0x2db))return this[_0x2a6087(0x2c9)]||null;else this['_subject']['currentAction']()['removeApplyGlobalEvoMatrix']();}VisuMZ[_0x2a6087(0x1bc)]['BattleManager_startAction'][_0x2a6087(0x25b)](this);if(_0x230b95){if(_0x2a6087(0x207)===_0x2a6087(0x24b)){const _0x44435d=_0x1c8851[_0x2a6087(0x29d)](),_0x5bddaa=this[_0x2a6087(0x23d)][_0x2a6087(0x2c7)]+_0x44435d*0x2,_0x30eece=this['_dimensions'][_0x2a6087(0x2e5)]+_0x44435d*0x2,_0x706540=new _0x392faf(0x0,0x0,_0x5bddaa,_0x30eece);this[_0x2a6087(0x217)]=new _0x28ecf1(_0x706540);}else this[_0x2a6087(0x1e9)][_0x2a6087(0x2cf)]()['restoreApplyGlobalEvoMatrix']();}},VisuMZ[_0x487f57(0x1bc)][_0x487f57(0x253)]=BattleManager[_0x487f57(0x1cc)],BattleManager[_0x487f57(0x1cc)]=function(){const _0x49918d=_0x487f57;$gameVariables[_0x49918d(0x2d1)](),VisuMZ[_0x49918d(0x1bc)][_0x49918d(0x253)][_0x49918d(0x25b)](this);},VisuMZ[_0x487f57(0x1bc)]['Game_Temp_initialize']=Game_Temp[_0x487f57(0x282)][_0x487f57(0x1fe)],Game_Temp['prototype'][_0x487f57(0x1fe)]=function(){const _0x6c99ef=_0x487f57;VisuMZ['EvoMatrixSkills'][_0x6c99ef(0x1c2)][_0x6c99ef(0x25b)](this),this[_0x6c99ef(0x1e1)]();},Game_Temp[_0x487f57(0x282)][_0x487f57(0x1e1)]=function(){const _0x292bef=_0x487f57;this[_0x292bef(0x2c9)]=null;},Game_Temp[_0x487f57(0x282)]['prepareEvoMatrixSkills']=function(_0x199381,_0x323a42){const _0x140d14=_0x487f57;$gameVariables[_0x140d14(0x2d1)](),this[_0x140d14(0x2d5)](_0x199381,_0x323a42);},Game_Temp[_0x487f57(0x282)]['updateEvoMatrixSkills']=function(_0x17c20c,_0x245716){$gameVariables['updateEvoMatrixTimes'](),this['registerEvoMatrixSkillBase'](_0x17c20c,_0x245716);},Game_Temp['prototype'][_0x487f57(0x2d5)]=function(_0x2040c7,_0x54246e){const _0x1ff7cc=_0x487f57;this[_0x1ff7cc(0x1e1)](),this[_0x1ff7cc(0x2ef)](_0x2040c7),this['registerEvoMatrixSkillsAll'](_0x54246e);if(Imported['VisuMZ_0_CoreEngine']){if(_0x1ff7cc(0x206)===_0x1ff7cc(0x279)){const _0x544863=_0x34161b[_0x1ff7cc(0x1bc)]['Settings']['UI'],_0x5e5359=_0x1ff7cc(0x2b2)[_0x1ff7cc(0x1d1)](this['_key']);_0x544863[_0x5e5359]?this[_0x1ff7cc(0x23d)]=_0x544863[_0x5e5359]():this['_dimensions']=new _0x4d0695(0x0,0x0,0x0,0x0),this[_0x1ff7cc(0x1ed)]=_0x544863[_0x1ff7cc(0x216)](),this['x']=this['_dimensions']['x']+(_0x544863[_0x1ff7cc(0x1d4)]||0x0),this['y']=this[_0x1ff7cc(0x23d)]['y']+(_0x544863[_0x1ff7cc(0x1f7)]||0x0),this['anchor']['x']=0.5,this['anchor']['y']=0.5,this[_0x1ff7cc(0x2c2)]['x']=_0x544863[_0x1ff7cc(0x2fc)],this[_0x1ff7cc(0x2c2)]['y']=_0x544863['Scale'],this[_0x1ff7cc(0x264)]=0x0,this[_0x1ff7cc(0x28d)]=(this[_0x1ff7cc(0x23d)]['x']-this[_0x1ff7cc(0x1ed)]['x'])*0x2+this[_0x1ff7cc(0x1ed)]['x'],this[_0x1ff7cc(0x273)]=(this['_dimensions']['y']-this[_0x1ff7cc(0x1ed)]['y'])*0x2+this[_0x1ff7cc(0x1ed)]['y'],this[_0x1ff7cc(0x28d)]+=_0x544863['KeybindUiOffsetX']||0x0,this[_0x1ff7cc(0x273)]+=_0x544863[_0x1ff7cc(0x1f7)]||0x0,this[_0x1ff7cc(0x29c)]=0x0,this['_movementWholeDuration']=0x0,this[_0x1ff7cc(0x1d3)]=this['x'],this[_0x1ff7cc(0x1d5)]=this['y'],this['_moveEasingType']=_0x1ff7cc(0x1e4),this['_moveOpacity']=0xff,this[_0x1ff7cc(0x1fa)]=0xff,this[_0x1ff7cc(0x28f)]='',this[_0x1ff7cc(0x1ee)]=null,this[_0x1ff7cc(0x24c)]=null,this[_0x1ff7cc(0x268)]=null;}else{const _0x3a9dbd=DataManager[_0x1ff7cc(0x2ea)](_0x54246e);$gameTemp[_0x1ff7cc(0x255)]([_0x2040c7],_0x3a9dbd,![],![]);}}},Game_Temp[_0x487f57(0x282)][_0x487f57(0x2ef)]=function(_0x429876){const _0x279487=_0x487f57;this[_0x279487(0x2c9)]=_0x429876,this[_0x279487(0x22f)]={};},Game_Temp['prototype']['registerEvoMatrixSkillsAll']=function(_0x42ed79){const _0x49cad2=_0x487f57;this[_0x49cad2(0x22f)]={},this[_0x49cad2(0x296)](_0x42ed79,_0x49cad2(0x294)),this[_0x49cad2(0x296)](_0x42ed79,_0x49cad2(0x22c)),this[_0x49cad2(0x296)](_0x42ed79,_0x49cad2(0x2e8)),this[_0x49cad2(0x22f)]['ok']=_0x42ed79['id'];},Game_Temp[_0x487f57(0x282)][_0x487f57(0x296)]=function(_0x59112c,_0x176a5c){const _0x477980=_0x487f57,_0x5965e3=VisuMZ[_0x477980(0x1bc)]['RegExp'],_0x222e12=VisuMZ[_0x477980(0x1bc)][_0x477980(0x2d9)][_0x477980(0x2b9)](),_0x5f2c20=_0x59112c['note']||'',_0x50d332=this['_evoMatrixSkillUser'],_0x4ed8be=_0x5f2c20[_0x477980(0x258)](_0x5965e3[_0x176a5c]);if(_0x4ed8be){if(_0x477980(0x1d9)===_0x477980(0x1d9))for(const _0x34f587 of _0x4ed8be){_0x34f587[_0x477980(0x258)](_0x5965e3[_0x176a5c]);let _0x3a16c9=String(RegExp['$1'])['toUpperCase']()['trim']();const _0x33db96=String(RegExp['$2']);_0x3a16c9=VisuMZ['EvoMatrixSkills'][_0x477980(0x27d)](_0x3a16c9);if(!_0x222e12[_0x477980(0x2cb)](_0x3a16c9))continue;const _0x2944a5=/^\d+$/['test'](_0x33db96);let _0x353ab7=0x0;if(_0x2944a5){if(_0x477980(0x2b5)===_0x477980(0x2b5))_0x353ab7=Number(_0x33db96);else{const _0x44bc1d=_0x42f6b8[_0x477980(0x2ea)](_0x9dd4a7);_0x502ac2[_0x477980(0x255)]([_0x15c069],_0x44bc1d,![],![]);}}else{if(_0x477980(0x299)!==_0x477980(0x26d))_0x353ab7=DataManager[_0x477980(0x280)](_0x33db96);else return _0x27e200;}if(_0x353ab7<=0x0)continue;if(_0x176a5c===_0x477980(0x294)&&!_0x50d332[_0x477980(0x25e)](_0x353ab7))continue;if(_0x176a5c===_0x477980(0x2e8)&&!_0x50d332[_0x477980(0x1c8)](_0x353ab7))continue;this[_0x477980(0x22f)][_0x3a16c9]=_0x353ab7;}else this[_0x477980(0x1e9)][_0x477980(0x2cf)]()[_0x477980(0x220)]();}},Game_Temp[_0x487f57(0x282)][_0x487f57(0x1e6)]=function(){const _0x1bef6a=_0x487f57;return this[_0x1bef6a(0x2c9)]||null;},Game_Temp[_0x487f57(0x282)]['getEvoMatrixSkillsKey']=function(_0x31863c){const _0x438251=_0x487f57;if(!this[_0x438251(0x22f)])return null;return this[_0x438251(0x22f)][_0x31863c];},Game_Temp[_0x487f57(0x282)][_0x487f57(0x250)]=function(_0x5bc8ea){const _0x4a1073=_0x487f57;return!!this[_0x4a1073(0x21e)](_0x5bc8ea);},Game_Temp[_0x487f57(0x282)][_0x487f57(0x270)]=function(){const _0x7bfff3=_0x487f57,_0x3760d1=BattleManager[_0x7bfff3(0x1e9)],_0x1629ba=[],_0xa53c6f=VisuMZ[_0x7bfff3(0x1bc)][_0x7bfff3(0x2d9)][_0x7bfff3(0x2b9)]();_0xa53c6f[_0x7bfff3(0x2e4)]('ok');for(const _0x110696 of _0xa53c6f){if(_0x7bfff3(0x20c)===_0x7bfff3(0x288))_0x52f76b[_0x7bfff3(0x219)](null);else{if(!this[_0x7bfff3(0x250)](_0x110696))continue;const _0x22ec80=this[_0x7bfff3(0x21e)](_0x110696),_0x1d18a1=$dataSkills[_0x22ec80];if(!_0x3760d1[_0x7bfff3(0x24e)](_0x1d18a1))continue;_0x1629ba[_0x7bfff3(0x25c)](_0x110696);}}return _0x1629ba['length']<=0x0&&_0x1629ba['push']('ok'),_0x1629ba;},Game_Variables[_0x487f57(0x1b3)]=VisuMZ['EvoMatrixSkills'][_0x487f57(0x21d)]['EvoVariable'],Game_Variables[_0x487f57(0x282)]['clearEvoMatrixTimes']=function(){const _0x41c93f=_0x487f57,_0x51f3da=Game_Variables[_0x41c93f(0x1b3)];_0x51f3da>0x0&&this[_0x41c93f(0x24d)](_0x51f3da,0x0);},Game_Variables[_0x487f57(0x282)][_0x487f57(0x2bf)]=function(){const _0x184fe0=_0x487f57,_0x5db4b3=Game_Variables[_0x184fe0(0x1b3)];if(_0x5db4b3>0x0){const _0x5bd3b0=this[_0x184fe0(0x29f)](_0x5db4b3);this[_0x184fe0(0x24d)](_0x5db4b3,_0x5bd3b0+0x1);}},Game_Action['prototype'][_0x487f57(0x220)]=function(){const _0x184c6c=_0x487f57;this[_0x184c6c(0x1b6)]=function(){};},Game_Action[_0x487f57(0x282)]['restoreApplyGlobalEvoMatrix']=function(){const _0x27e122=_0x487f57;this[_0x27e122(0x1b6)]=Game_Action[_0x27e122(0x282)][_0x27e122(0x1b6)];},VisuMZ['EvoMatrixSkills'][_0x487f57(0x23f)]=Game_BattlerBase[_0x487f57(0x282)][_0x487f57(0x1d2)],Game_BattlerBase[_0x487f57(0x282)][_0x487f57(0x1d2)]=function(_0xf74f0b){const _0x3ab19b=_0x487f57;if(!this[_0x3ab19b(0x222)](_0xf74f0b))return![];return VisuMZ[_0x3ab19b(0x1bc)][_0x3ab19b(0x23f)][_0x3ab19b(0x25b)](this,_0xf74f0b);},Game_BattlerBase['prototype'][_0x487f57(0x222)]=function(_0x2a2026){const _0xc72e2f=_0x487f57;if(!_0x2a2026)return![];const _0x47c90c=VisuMZ[_0xc72e2f(0x1bc)][_0xc72e2f(0x226)],_0xef8789=_0x2a2026[_0xc72e2f(0x257)]||'';if(_0xef8789[_0xc72e2f(0x258)](_0x47c90c[_0xc72e2f(0x1bf)])){if('YMuqe'===_0xc72e2f(0x2e1))this[_0xc72e2f(0x284)][_0x374c11][_0xc72e2f(0x274)]();else{if(!this[_0xc72e2f(0x2c6)]())return![];if(!SceneManager[_0xc72e2f(0x1ef)]())return![];const _0x573c30=SceneManager[_0xc72e2f(0x2b0)]['_logWindow'];if(_0x573c30&&!_0x573c30['_evoMatrixSkillMode'])return![];}}return!![];},Game_Actor[_0x487f57(0x282)][_0x487f57(0x1ba)]=function(_0x44803c){const _0x3c068e=_0x487f57;BattleManager[_0x3c068e(0x236)][_0x3c068e(0x219)](_0x44803c['id']),BattleManager[_0x3c068e(0x2da)]=BattleManager[_0x3c068e(0x236)]['makeTargets'](),this[_0x3c068e(0x2f2)](_0x44803c);},VisuMZ[_0x487f57(0x1bc)][_0x487f57(0x1b8)]=Scene_Battle['prototype'][_0x487f57(0x22d)],Scene_Battle[_0x487f57(0x282)][_0x487f57(0x22d)]=function(){const _0x2c9f7c=_0x487f57;VisuMZ[_0x2c9f7c(0x1bc)][_0x2c9f7c(0x1b8)]['call'](this),this[_0x2c9f7c(0x29a)]();},Scene_Battle[_0x487f57(0x282)][_0x487f57(0x29a)]=function(){const _0x562a34=_0x487f57;this[_0x562a34(0x237)](),this['createEvoMatrixSkillsUiBackground'](),this['createEvoMatrixSkillsUiButtons'](),this[_0x562a34(0x20f)]();},Scene_Battle['prototype'][_0x487f57(0x237)]=function(){const _0x5317a8=_0x487f57;this[_0x5317a8(0x260)]=new Sprite(),this[_0x5317a8(0x2ae)](this[_0x5317a8(0x260)]),this[_0x5317a8(0x260)][_0x5317a8(0x264)]=0x0,this[_0x5317a8(0x2a0)]=0x0;},Scene_Battle[_0x487f57(0x282)][_0x487f57(0x2fe)]=function(){const _0x2aa142=_0x487f57,_0x4a9b3d=VisuMZ['EvoMatrixSkills']['Settings']['UI'];if(_0x4a9b3d[_0x2aa142(0x1e8)]){const _0x20fff5=new Sprite();this[_0x2aa142(0x260)][_0x2aa142(0x2ae)](_0x20fff5);const _0x239053=new Bitmap(Graphics[_0x2aa142(0x2c7)],Graphics[_0x2aa142(0x2e5)]);_0x20fff5[_0x2aa142(0x278)]=_0x239053;const _0x44240d=_0x4a9b3d['backgroundDrawJS'];_0x44240d['call'](_0x20fff5[_0x2aa142(0x278)]);}if(_0x4a9b3d['BackgroundImage']!==''){const _0x34790d=new Sprite();this[_0x2aa142(0x260)]['addChild'](_0x34790d);const _0x347c39=ImageManager[_0x2aa142(0x23a)](_0x4a9b3d[_0x2aa142(0x29e)]);_0x34790d[_0x2aa142(0x278)]=_0x347c39;}},Scene_Battle[_0x487f57(0x282)][_0x487f57(0x295)]=function(){const _0x537b48=_0x487f57;this[_0x537b48(0x284)]={};const _0x36debe=VisuMZ[_0x537b48(0x1bc)][_0x537b48(0x2d9)][_0x537b48(0x2b9)]();_0x36debe[_0x537b48(0x2e4)]('ok'),_0x36debe[_0x537b48(0x25c)]('ok');for(const _0x56b51b of _0x36debe){const _0x58c22f=new Sprite_EvoMatrixButton(_0x56b51b);this[_0x537b48(0x260)][_0x537b48(0x2ae)](_0x58c22f),this[_0x537b48(0x284)][_0x56b51b]=_0x58c22f;}},Scene_Battle[_0x487f57(0x282)][_0x487f57(0x20f)]=function(){const _0x53e1c8=_0x487f57;if(!Imported[_0x53e1c8(0x252)])return;if(!Window_EvoMatrixSkillsTooltip[_0x53e1c8(0x1c5)])return;this[_0x53e1c8(0x2d8)]=new Window_EvoMatrixSkillsTooltip(),this['addChild'](this[_0x53e1c8(0x2d8)]);},VisuMZ[_0x487f57(0x1bc)]['Scene_Battle_update']=Scene_Battle[_0x487f57(0x282)][_0x487f57(0x23c)],Scene_Battle['prototype'][_0x487f57(0x23c)]=function(){const _0x1e4fec=_0x487f57;VisuMZ[_0x1e4fec(0x1bc)][_0x1e4fec(0x1ec)]['call'](this);if(this[_0x1e4fec(0x2de)]())this[_0x1e4fec(0x1b2)]();this['updateEvoMatrixSkillsUiOpacity']();},Scene_Battle[_0x487f57(0x282)][_0x487f57(0x1b2)]=function(){const _0x7596f1=_0x487f57,_0x554d4c=BattleManager[_0x7596f1(0x1e9)],_0x1c0ec0=VisuMZ[_0x7596f1(0x1bc)][_0x7596f1(0x2d9)][_0x7596f1(0x2b9)]();if(this[_0x7596f1(0x2a0)]-->0x0)return;if(_0x554d4c[_0x7596f1(0x290)]()){this[_0x7596f1(0x2f3)]();return;}for(const _0x1b2b40 of _0x1c0ec0){if(!$gameTemp[_0x7596f1(0x250)](_0x1b2b40))continue;const _0x222184=$dataSkills[$gameTemp['getEvoMatrixSkillsKey'](_0x1b2b40)];if(!_0x222184)continue;if(_0x1b2b40!=='ok'&&!_0x554d4c[_0x7596f1(0x24e)](_0x222184))continue;if(!Input['isTriggered'](_0x1b2b40))continue;this[_0x7596f1(0x228)](_0x1b2b40,_0x222184);break;}},Scene_Battle[_0x487f57(0x282)][_0x487f57(0x2de)]=function(){const _0x361757=_0x487f57;return this['_logWindow']&&this[_0x361757(0x1e0)][_0x361757(0x232)];},Scene_Battle[_0x487f57(0x282)][_0x487f57(0x1f3)]=function(){const _0x47c5a3=_0x487f57,_0x4cddb0=VisuMZ[_0x47c5a3(0x1bc)][_0x47c5a3(0x21d)]['UI'],_0x27e019=this['canPerformEvoMatrixSkills']();if(this[_0x47c5a3(0x260)]){const _0x3e48fa=_0x4cddb0[_0x47c5a3(0x261)]*(_0x27e019?0x1:-0x1);this[_0x47c5a3(0x260)][_0x47c5a3(0x264)]+=_0x3e48fa;}},Scene_Battle[_0x487f57(0x282)]['processEvoMatrixSkillsKey']=function(_0x1d6a00,_0x41c7f4){const _0x188451=_0x487f57;this[_0x188451(0x284)][_0x1d6a00][_0x188451(0x248)]=0x4,SoundManager['playEvoMatrixSkillsSound']();const _0xab70bd=BattleManager[_0x188451(0x1e9)];if(_0x1d6a00==='ok')this[_0x188451(0x1e0)][_0x188451(0x1dc)](),this[_0x188451(0x2bc)](_0x1d6a00);else{if(_0xab70bd){if(_0x188451(0x2ab)===_0x188451(0x2ab)){_0xab70bd['updateEvoMatrixSkill'](_0x41c7f4);if(DataManager[_0x188451(0x1b5)](_0xab70bd,_0x41c7f4))this[_0x188451(0x21f)](_0x1d6a00),$gameTemp[_0x188451(0x1b2)](_0xab70bd,_0x41c7f4);else{if(_0x188451(0x2b4)===_0x188451(0x2b4))this['_logWindow'][_0x188451(0x1dc)](),this[_0x188451(0x2bc)](_0x1d6a00);else{_0x5313f3[_0x188451(0x282)][_0x188451(0x23c)][_0x188451(0x25b)](this),this[_0x188451(0x262)](),this[_0x188451(0x244)](),this[_0x188451(0x2e7)]();if(this[_0x188451(0x2d7)]())this[_0x188451(0x267)]();}}}else _0x163b91=_0x3e2e6b[_0x188451(0x280)](_0x1498ef);}}},Scene_Battle['prototype'][_0x487f57(0x2f3)]=function(){const _0x481048=_0x487f57,_0x570b26=$gameTemp['getEvoMatrixAutoBattleKeys'](),_0x4f6331=_0x570b26[Math[_0x481048(0x2f5)](_0x570b26[_0x481048(0x22a)])],_0x3cc306=$dataSkills[$gameTemp[_0x481048(0x21e)](_0x4f6331)];this[_0x481048(0x228)](_0x4f6331,_0x3cc306);},Scene_Battle[_0x487f57(0x282)][_0x487f57(0x20d)]=function(){const _0x3490ab=_0x487f57;this[_0x3490ab(0x2a0)]=Sprite_EvoMatrixButton['MOVE_DURATION'];const _0x21d8fa=VisuMZ[_0x3490ab(0x1bc)][_0x3490ab(0x2d9)][_0x3490ab(0x2b9)]();for(const _0x4ed1e5 of _0x21d8fa){this[_0x3490ab(0x284)][_0x4ed1e5][_0x3490ab(0x229)]();}},Scene_Battle[_0x487f57(0x282)]['evoMatrixButtonsBranch']=function(_0x4a9e69){const _0x23df87=_0x487f57;this[_0x23df87(0x2a0)]=Sprite_EvoMatrixButton['MOVE_DURATION'],this[_0x23df87(0x2a0)]*=0x2;const _0x35bc75=VisuMZ[_0x23df87(0x1bc)]['Keys'][_0x23df87(0x2b9)]();for(const _0x534387 of _0x35bc75){if(_0x534387===_0x4a9e69)this[_0x23df87(0x284)][_0x534387][_0x23df87(0x274)]();else{if(_0x23df87(0x215)!=='xyVQG')this[_0x23df87(0x284)][_0x534387][_0x23df87(0x1db)]();else{const _0x5999e8=new _0x5c322c();this[_0x23df87(0x260)][_0x23df87(0x2ae)](_0x5999e8);const _0x616675=new _0x1b3373(_0x5ef3e6[_0x23df87(0x2c7)],_0x151354[_0x23df87(0x2e5)]);_0x5999e8[_0x23df87(0x278)]=_0x616675;const _0x1fe114=_0x4463a9['backgroundDrawJS'];_0x1fe114[_0x23df87(0x25b)](_0x5999e8['bitmap']);}}}},Scene_Battle[_0x487f57(0x282)][_0x487f57(0x2bc)]=function(_0x3d215c){const _0x15c969=_0x487f57;this[_0x15c969(0x2a0)]=Sprite_EvoMatrixButton[_0x15c969(0x2c3)];const _0x4b91c2=VisuMZ[_0x15c969(0x1bc)][_0x15c969(0x2d9)][_0x15c969(0x2b9)]();for(const _0x3d982f of _0x4b91c2){if(_0x3d982f===_0x3d215c)continue;this['_evoMatrixSkillButtons'][_0x3d982f]['moveToOuterFin']();}};function Sprite_EvoMatrixButton(){const _0x3aa7fe=_0x487f57;this[_0x3aa7fe(0x1fe)](...arguments);}Sprite_EvoMatrixButton[_0x487f57(0x282)]=Object[_0x487f57(0x265)](Sprite_Clickable[_0x487f57(0x282)]),Sprite_EvoMatrixButton[_0x487f57(0x282)][_0x487f57(0x2b7)]=Sprite_EvoMatrixButton,Sprite_EvoMatrixButton[_0x487f57(0x21c)]=VisuMZ[_0x487f57(0x1bc)]['Settings']['UI']['okCostText']??_0x487f57(0x2d0),Sprite_EvoMatrixButton[_0x487f57(0x1d8)]=VisuMZ[_0x487f57(0x1bc)][_0x487f57(0x21d)]['UI'][_0x487f57(0x205)]??-0x4,Sprite_EvoMatrixButton[_0x487f57(0x209)]=VisuMZ[_0x487f57(0x1bc)]['Settings']['UI'][_0x487f57(0x1f4)]??+0x4,Sprite_EvoMatrixButton['MOVE_DURATION']=VisuMZ[_0x487f57(0x1bc)][_0x487f57(0x21d)]['UI'][_0x487f57(0x2ac)]||0x1,Sprite_EvoMatrixButton[_0x487f57(0x275)]=VisuMZ[_0x487f57(0x1bc)][_0x487f57(0x21d)]['UI']['MoveInEasing']||_0x487f57(0x1e4),Sprite_EvoMatrixButton[_0x487f57(0x271)]=VisuMZ[_0x487f57(0x1bc)][_0x487f57(0x21d)]['UI'][_0x487f57(0x241)]||_0x487f57(0x1e4),Sprite_EvoMatrixButton[_0x487f57(0x282)][_0x487f57(0x1fe)]=function(_0x5ed242){const _0x328a2a=_0x487f57;this['_key']=_0x5ed242,Sprite_Clickable[_0x328a2a(0x282)][_0x328a2a(0x1fe)][_0x328a2a(0x25b)](this),this[_0x328a2a(0x2e9)](),this['debugFillRect'](),this['createBackgroundSprite'](),this['createContentSprite'](),this[_0x328a2a(0x218)]();},Sprite_EvoMatrixButton[_0x487f57(0x282)][_0x487f57(0x2e9)]=function(){const _0x23d747=_0x487f57,_0x38672e=VisuMZ['EvoMatrixSkills'][_0x23d747(0x21d)]['UI'],_0x27af74=_0x23d747(0x2b2)[_0x23d747(0x1d1)](this['_key']);_0x38672e[_0x27af74]?_0x23d747(0x298)!==_0x23d747(0x22e)?this[_0x23d747(0x23d)]=_0x38672e[_0x27af74]():this[_0x23d747(0x1fe)](...arguments):this[_0x23d747(0x23d)]=new Rectangle(0x0,0x0,0x0,0x0),this[_0x23d747(0x1ed)]=_0x38672e['okRectJS'](),this['x']=this['_dimensions']['x']+(_0x38672e[_0x23d747(0x1d4)]||0x0),this['y']=this[_0x23d747(0x23d)]['y']+(_0x38672e['KeybindUiOffsetY']||0x0),this['anchor']['x']=0.5,this[_0x23d747(0x283)]['y']=0.5,this['scale']['x']=_0x38672e[_0x23d747(0x2fc)],this[_0x23d747(0x2c2)]['y']=_0x38672e['Scale'],this[_0x23d747(0x264)]=0x0,this[_0x23d747(0x28d)]=(this[_0x23d747(0x23d)]['x']-this[_0x23d747(0x1ed)]['x'])*0x2+this['_centerDimensions']['x'],this[_0x23d747(0x273)]=(this['_dimensions']['y']-this[_0x23d747(0x1ed)]['y'])*0x2+this[_0x23d747(0x1ed)]['y'],this[_0x23d747(0x28d)]+=_0x38672e[_0x23d747(0x1d4)]||0x0,this[_0x23d747(0x273)]+=_0x38672e[_0x23d747(0x1f7)]||0x0,this['_movementDuration']=0x0,this[_0x23d747(0x1d7)]=0x0,this[_0x23d747(0x1d3)]=this['x'],this[_0x23d747(0x1d5)]=this['y'],this[_0x23d747(0x1be)]=_0x23d747(0x1e4),this['_moveOpacity']=0xff,this[_0x23d747(0x1fa)]=0xff,this[_0x23d747(0x28f)]='',this[_0x23d747(0x1ee)]=null,this[_0x23d747(0x24c)]=null,this['_lastInputType']=null;},Sprite_EvoMatrixButton[_0x487f57(0x282)]['debugFillRect']=function(){const _0x397ca0=_0x487f57,_0x332d24=![],_0x5cf80c=_0x332d24?_0x397ca0(0x23b):ColorManager['dimColor2']();this[_0x397ca0(0x278)]=new Bitmap(this[_0x397ca0(0x23d)][_0x397ca0(0x2c7)],this[_0x397ca0(0x23d)]['height']),this[_0x397ca0(0x278)][_0x397ca0(0x231)](0x0,0x0,this[_0x397ca0(0x278)][_0x397ca0(0x2c7)],this[_0x397ca0(0x278)]['height'],_0x5cf80c);},Sprite_EvoMatrixButton['prototype']['createBackgroundSprite']=function(){const _0x137d73=_0x487f57,_0x34077a=VisuMZ[_0x137d73(0x1bc)][_0x137d73(0x21d)]['UI'],_0x4d915e=_0x34077a['%1BackgroundImage'[_0x137d73(0x1d1)](this[_0x137d73(0x2c5)])];if(!_0x4d915e)return;const _0x3d6105=new Sprite();this['addChild'](_0x3d6105),_0x3d6105[_0x137d73(0x278)]=ImageManager[_0x137d73(0x23a)](_0x4d915e),_0x3d6105[_0x137d73(0x283)]['x']=0.5,_0x3d6105['anchor']['y']=0.5,_0x3d6105[_0x137d73(0x2c2)]['x']=0x1/(this[_0x137d73(0x2c2)]['x']||0.01),_0x3d6105[_0x137d73(0x2c2)]['y']=0x1/(this[_0x137d73(0x2c2)]['y']||0.01);},Sprite_EvoMatrixButton['prototype'][_0x487f57(0x21b)]=function(){const _0x579c44=_0x487f57;this[_0x579c44(0x2e0)]=new Sprite(),this[_0x579c44(0x2ae)](this[_0x579c44(0x2e0)]),this['_contentSprite'][_0x579c44(0x283)]['x']=0.5,this[_0x579c44(0x2e0)][_0x579c44(0x283)]['y']=0.5;},Sprite_EvoMatrixButton[_0x487f57(0x282)][_0x487f57(0x218)]=function(){const _0x2388b7=_0x487f57,_0x2f3aa6=$gameSystem['windowPadding'](),_0x1c0be7=this['_dimensions']['width']+_0x2f3aa6*0x2,_0x206913=this[_0x2388b7(0x23d)]['height']+_0x2f3aa6*0x2,_0x277454=new Rectangle(0x0,0x0,_0x1c0be7,_0x206913);this[_0x2388b7(0x217)]=new Window_Base(_0x277454);},Sprite_EvoMatrixButton[_0x487f57(0x282)][_0x487f57(0x23c)]=function(){const _0x40d43b=_0x487f57;Sprite_Clickable[_0x40d43b(0x282)][_0x40d43b(0x23c)][_0x40d43b(0x25b)](this),this[_0x40d43b(0x262)](),this[_0x40d43b(0x244)](),this[_0x40d43b(0x2e7)]();if(this[_0x40d43b(0x2d7)]())this[_0x40d43b(0x267)]();},Sprite_EvoMatrixButton['prototype'][_0x487f57(0x262)]=function(){const _0x11ee25=_0x487f57;this[_0x11ee25(0x264)]=Math[_0x11ee25(0x246)](this[_0x11ee25(0x27b)],this[_0x11ee25(0x1f0)]());},Sprite_EvoMatrixButton[_0x487f57(0x282)][_0x487f57(0x1f0)]=function(){const _0x298c3d=_0x487f57;if(this[_0x298c3d(0x29c)]>0x0&&this['_moveFinishFunc']!=='')return this[_0x298c3d(0x264)];if(this['_key']==='ok')return 0xff;if(!$gameTemp['hasEvoMatrixSkillsKey'](this['_key']))return 0x0;const _0x3f30f5=VisuMZ[_0x298c3d(0x1bc)][_0x298c3d(0x21d)]['UI'][_0x298c3d(0x1bd)],_0x525102=$gameTemp[_0x298c3d(0x21e)](this[_0x298c3d(0x2c5)]);if(_0x525102===null)return _0x3f30f5;const _0x6ea1bf=BattleManager['_subject'];if(!_0x6ea1bf)return _0x3f30f5;const _0x6c9163=$dataSkills[_0x525102];if(!_0x6ea1bf[_0x298c3d(0x24e)](_0x6c9163))return _0x3f30f5;return 0xff;},Sprite_EvoMatrixButton[_0x487f57(0x282)]['updatePosition']=function(){const _0x1fc157=_0x487f57;if(this['_movementDuration']>0x0)return;const _0x89dfab=VisuMZ[_0x1fc157(0x1bc)][_0x1fc157(0x21d)]['UI'];this['x']=this[_0x1fc157(0x23d)]['x']+(_0x89dfab[_0x1fc157(0x1d4)]||0x0),this['y']=this[_0x1fc157(0x23d)]['y']+(_0x89dfab['KeybindUiOffsetY']||0x0);if(this[_0x1fc157(0x2a6)]){if(_0x1fc157(0x287)===_0x1fc157(0x287))this['_pressedDuration']=0x4;else{this[_0x1fc157(0x232)]=![],this[_0x1fc157(0x2a5)]();const _0x2a7dbe=_0x13361c[_0x1fc157(0x1e9)],_0x8bd3f3=_0x11e555['_action'],_0x124b1b=_0x1b1b46[_0x1fc157(0x2da)];_0x18b774[_0x1fc157(0x1bc)][_0x1fc157(0x202)][_0x1fc157(0x25b)](this,_0x2a7dbe,_0x8bd3f3,_0x124b1b),_0x8bd3f3['applyGlobal']();}}this[_0x1fc157(0x248)]-->0x0&&(this['x']+=Sprite_EvoMatrixButton[_0x1fc157(0x1d8)],this['y']+=Sprite_EvoMatrixButton[_0x1fc157(0x209)]);},Sprite_EvoMatrixButton[_0x487f57(0x282)][_0x487f57(0x2e7)]=function(){const _0xb8f8f9=_0x487f57;if(this['_movementDuration']<=0x0)return;const _0x2ea865=this[_0xb8f8f9(0x29c)],_0x16e940=this[_0xb8f8f9(0x1d7)],_0x7fc035=this[_0xb8f8f9(0x1be)];this['x']=this['applyEasing'](this['x'],this['_moveTargetX'],_0x2ea865,_0x16e940,_0x7fc035),this['y']=this[_0xb8f8f9(0x28c)](this['y'],this[_0xb8f8f9(0x1d5)],_0x2ea865,_0x16e940,_0x7fc035),this[_0xb8f8f9(0x27b)]=this['applyEasing'](this[_0xb8f8f9(0x27b)],this['_moveOpacityTarget'],_0x2ea865,_0x16e940,_0x7fc035),this[_0xb8f8f9(0x29c)]--,this['_movementDuration']<=0x0&&(_0xb8f8f9(0x2ca)!==_0xb8f8f9(0x23e)?(this['x']=this[_0xb8f8f9(0x1d3)],this['y']=this['_moveTargetY'],this['_moveFinishFunc']!==''&&this[this['_moveFinishFunc']]&&this[this[_0xb8f8f9(0x28f)]]()):this[_0xb8f8f9(0x221)]=_0x109b06[_0xb8f8f9(0x23a)](_0x571bcc['WINDOW_SKIN_FILENAME']));},Sprite_EvoMatrixButton[_0x487f57(0x282)][_0x487f57(0x28c)]=function(_0x9df440,_0x3ddf25,_0x479cb4,_0x485f6e,_0x49ac3e){const _0x38184e=_0x487f57,_0x19106c=VisuMZ[_0x38184e(0x1de)]((_0x485f6e-_0x479cb4)/_0x485f6e,_0x49ac3e||_0x38184e(0x1e4)),_0x55727c=VisuMZ[_0x38184e(0x1de)]((_0x485f6e-_0x479cb4+0x1)/_0x485f6e,_0x49ac3e||_0x38184e(0x1e4)),_0x494222=(_0x9df440-_0x3ddf25*_0x19106c)/(0x1-_0x19106c);return _0x494222+(_0x3ddf25-_0x494222)*_0x55727c;},Sprite_EvoMatrixButton[_0x487f57(0x282)][_0x487f57(0x259)]=function(_0x254c43,_0x409364,_0x28a9a6,_0x196e1a,_0x273e76){const _0x59cc67=_0x487f57;this[_0x59cc67(0x29c)]=Sprite_EvoMatrixButton['MOVE_DURATION'],this[_0x59cc67(0x1d7)]=Sprite_EvoMatrixButton['MOVE_DURATION'],this['_pressedDuration']=0x0,this[_0x59cc67(0x1d3)]=_0x254c43,this[_0x59cc67(0x1d5)]=_0x409364,this[_0x59cc67(0x1fa)]=_0x28a9a6,this[_0x59cc67(0x1be)]=_0x196e1a||_0x59cc67(0x1e4),this['_moveFinishFunc']=_0x273e76||'';},Sprite_EvoMatrixButton['prototype'][_0x487f57(0x229)]=function(){const _0x408a4f=_0x487f57,_0x2b40d2=VisuMZ[_0x408a4f(0x1bc)][_0x408a4f(0x21d)]['UI'];this['x']=this[_0x408a4f(0x1ed)]['x']+(_0x2b40d2[_0x408a4f(0x1d4)]||0x0),this['y']=this[_0x408a4f(0x1ed)]['y']+(_0x2b40d2[_0x408a4f(0x1f7)]||0x0),this['_moveOpacity']=0x0,this['opacity']=0x0;const _0x114d3e=this[_0x408a4f(0x23d)]['x']+(_0x2b40d2[_0x408a4f(0x1d4)]||0x0),_0x14758b=this['_dimensions']['y']+(_0x2b40d2['KeybindUiOffsetY']||0x0),_0x195af5=0xff,_0x15fc73=_0x2b40d2[_0x408a4f(0x241)]||_0x408a4f(0x1e4);this[_0x408a4f(0x259)](_0x114d3e,_0x14758b,_0x195af5,_0x15fc73);},Sprite_EvoMatrixButton['prototype'][_0x487f57(0x274)]=function(){const _0x9b206d=_0x487f57,_0x33d923=VisuMZ[_0x9b206d(0x1bc)][_0x9b206d(0x21d)]['UI'],_0x9aef6c=this[_0x9b206d(0x1ed)]['x']+(_0x33d923['KeybindUiOffsetX']||0x0),_0x4dfb45=this[_0x9b206d(0x1ed)]['y']+(_0x33d923[_0x9b206d(0x1f7)]||0x0),_0x14a9cb=0xff,_0x325773=_0x33d923['MoveInEasing']||_0x9b206d(0x1e4),_0x50d3ad=_0x9b206d(0x229);this['startMove'](_0x9aef6c,_0x4dfb45,_0x14a9cb,_0x325773,_0x50d3ad);},Sprite_EvoMatrixButton[_0x487f57(0x282)]['moveToOuter']=function(){const _0xb27aca=_0x487f57,_0x3112cc=VisuMZ[_0xb27aca(0x1bc)][_0xb27aca(0x21d)]['UI'],_0x5dc589=this[_0xb27aca(0x28d)],_0x2c70db=this[_0xb27aca(0x273)],_0x142e28=0x0,_0x2c3649=_0x3112cc[_0xb27aca(0x25d)]||_0xb27aca(0x1e4),_0x459133=this['_key']==='ok'?_0xb27aca(0x1fb):_0xb27aca(0x229);this[_0xb27aca(0x259)](_0x5dc589,_0x2c70db,_0x142e28,_0x2c3649,_0x459133);},Sprite_EvoMatrixButton[_0x487f57(0x282)][_0x487f57(0x1fb)]=function(){const _0x502519=_0x487f57;this[_0x502519(0x229)](),this[_0x502519(0x27b)]=0xff,this['opacity']=0xff;},Sprite_EvoMatrixButton[_0x487f57(0x282)]['moveToOuterFin']=function(){this['moveToOuter'](),this['_moveFinishFunc']='';},Sprite_EvoMatrixButton[_0x487f57(0x282)][_0x487f57(0x267)]=function(){const _0x25d61b=_0x487f57;this[_0x25d61b(0x1ee)]=BattleManager[_0x25d61b(0x1e9)],this[_0x25d61b(0x24c)]=$gameTemp[_0x25d61b(0x21e)](this['_key']),Imported[_0x25d61b(0x227)]&&Input[_0x25d61b(0x1fd)]&&(this[_0x25d61b(0x268)]=Input[_0x25d61b(0x1fd)]()),this[_0x25d61b(0x1b0)]();},Sprite_EvoMatrixButton[_0x487f57(0x282)]['meetsUpdateBitmapConditions']=function(){const _0x52320a=_0x487f57;if(this[_0x52320a(0x29c)]>0x0&&this['_moveFinishFunc']!=='')return![];if(this[_0x52320a(0x1ee)]!==BattleManager[_0x52320a(0x1e9)])return!![];if(this[_0x52320a(0x24c)]!==$gameTemp[_0x52320a(0x21e)](this[_0x52320a(0x2c5)]))return!![];if(Imported['VisuMZ_0_CoreEngine']&&Input['getLastUsedGamepadType']){if(_0x52320a(0x1e7)!==_0x52320a(0x24a)){if(this[_0x52320a(0x268)]!==Input[_0x52320a(0x1fd)]())return!![];}else{if(!this['isActor']())return![];if(!_0xdb13ee[_0x52320a(0x1ef)]())return![];const _0x317d54=_0x156350[_0x52320a(0x2b0)][_0x52320a(0x1e0)];if(_0x317d54&&!_0x317d54[_0x52320a(0x232)])return![];}}return![];},Sprite_EvoMatrixButton['prototype']['refreshBitmap']=function(){const _0x16bc61=_0x487f57,_0x44ed62=VisuMZ['EvoMatrixSkills']['Settings']['UI'],_0x5626eb=this['_contentWindow'][_0x16bc61(0x251)],_0x24825d=$dataSkills[this[_0x16bc61(0x24c)]];if(!_0x24825d)return;if(!BattleManager[_0x16bc61(0x1e9)])return;_0x5626eb[_0x16bc61(0x2a5)](),this['_contentWindow'][_0x16bc61(0x2ec)]();const _0xf03c4d=this[_0x16bc61(0x20e)](),_0x52edad=BattleManager[_0x16bc61(0x1e9)],_0x2b5506=this[_0x16bc61(0x2c5)]==='ok'?Sprite_EvoMatrixButton[_0x16bc61(0x21c)]:this[_0x16bc61(0x217)][_0x16bc61(0x25f)](_0x52edad,_0x24825d);_0x44ed62[_0x16bc61(0x2fb)][_0x16bc61(0x25b)](this['_contentWindow'],_0x24825d,_0xf03c4d,_0x2b5506),this['_contentSprite'][_0x16bc61(0x278)]=_0x5626eb;},Sprite_EvoMatrixButton[_0x487f57(0x282)][_0x487f57(0x20e)]=function(){const _0x98ef5a=_0x487f57,_0x2227e2=VisuMZ['EvoMatrixSkills']['Settings']['UI'],_0x5df0ab=_0x98ef5a(0x2ba)[_0x98ef5a(0x1d1)](this[_0x98ef5a(0x2c5)]);if(_0x2227e2[_0x5df0ab])return _0x2227e2[_0x5df0ab];if(Imported['VisuMZ_0_CoreEngine']){if('jnmXC'!=='jnmXC')this['hide']();else{const _0x2bfedf=TextManager['getInputButtonString'](this[_0x98ef5a(0x2c5)]);if(_0x2bfedf&&_0x2bfedf['match'](/\\I\[(\d+)\]/i))return Number(RegExp['$1']);}}return 0x0;},Sprite_EvoMatrixButton[_0x487f57(0x282)][_0x487f57(0x2b1)]=function(){const _0x152051=_0x487f57;Sprite_Clickable[_0x152051(0x282)]['onClick']['call'](this);if(BattleManager[_0x152051(0x1e9)]&&BattleManager[_0x152051(0x1e9)][_0x152051(0x290)]())return;const _0x510fd3=$dataSkills[$gameTemp[_0x152051(0x21e)](this[_0x152051(0x2c5)])];if(BattleManager[_0x152051(0x1e9)]&&_0x510fd3){const _0x1ab06d=SceneManager[_0x152051(0x2b0)];_0x1ab06d&&_0x1ab06d[_0x152051(0x228)]&&_0x1ab06d[_0x152051(0x228)](this[_0x152051(0x2c5)],_0x510fd3);}const _0xc329d0=this[_0x152051(0x242)]();_0xc329d0&&_0xc329d0[_0x152051(0x219)](null);},Sprite_EvoMatrixButton['prototype'][_0x487f57(0x1f6)]=function(){const _0x33ebbf=_0x487f57;if(this['opacity']<=0x0)return![];if(this[_0x33ebbf(0x29c)]>0x0)return![];const _0x1e4e73=SceneManager[_0x33ebbf(0x2b0)];if(!_0x1e4e73)return![];if(!_0x1e4e73[_0x33ebbf(0x2de)])return![];if(!_0x1e4e73['canPerformEvoMatrixSkills']())return![];if(this[_0x33ebbf(0x2c5)]==='ok')return!![];if(!$gameTemp[_0x33ebbf(0x250)](this[_0x33ebbf(0x2c5)]))return![];const _0xe16152=$dataSkills[$gameTemp['getEvoMatrixSkillsKey'](this['_key'])];if(!_0xe16152)return![];if(!BattleManager[_0x33ebbf(0x1e9)]['canUse'](_0xe16152))return![];return Sprite_Clickable['prototype'][_0x33ebbf(0x1f6)]['call'](this);},Sprite_EvoMatrixButton['prototype'][_0x487f57(0x242)]=function(){const _0x5d4597=_0x487f57;return SceneManager[_0x5d4597(0x2b0)][_0x5d4597(0x2d8)];},Sprite_EvoMatrixButton[_0x487f57(0x282)][_0x487f57(0x2d2)]=function(){const _0xe67c24=_0x487f57;Sprite_Clickable[_0xe67c24(0x282)][_0xe67c24(0x2d2)][_0xe67c24(0x25b)](this);const _0xed76bc=this[_0xe67c24(0x242)]();if(!_0xed76bc)return;const _0x5d8534=SceneManager['_scene'],_0x1797fb=_0x5d8534&&_0x5d8534[_0xe67c24(0x2de)]?_0x5d8534[_0xe67c24(0x2de)]():![];if(_0xed76bc&&_0x1797fb){const _0x225977=$dataSkills[this[_0xe67c24(0x24c)]];_0xed76bc[_0xe67c24(0x219)](_0x225977);}},Sprite_EvoMatrixButton['prototype']['onMouseExit']=function(){const _0x34b3c5=_0x487f57;Sprite_Clickable['prototype'][_0x34b3c5(0x249)]['call'](this);const _0x19e76d=this[_0x34b3c5(0x242)]();if(!_0x19e76d)return;const _0x402b1c=$dataSkills[this[_0x34b3c5(0x24c)]],_0x57b84b=SceneManager['_scene'],_0x18c898=_0x57b84b&&_0x57b84b[_0x34b3c5(0x2de)]?_0x57b84b[_0x34b3c5(0x2de)]():![];(!_0x18c898||_0x19e76d&&_0x19e76d[_0x34b3c5(0x1b7)]===_0x402b1c)&&(_0x34b3c5(0x1f2)===_0x34b3c5(0x1f2)?_0x19e76d[_0x34b3c5(0x219)](null):(this[_0x34b3c5(0x22f)]={},this['registerEvoMatrixSkillsType'](_0x8f3693,'AvailableMatrix'),this[_0x34b3c5(0x296)](_0x592469,_0x34b3c5(0x22c)),this[_0x34b3c5(0x296)](_0x12d721,_0x34b3c5(0x2e8)),this[_0x34b3c5(0x22f)]['ok']=_0x27e31a['id']));},Sprite_EvoMatrixButton['prototype'][_0x487f57(0x1c3)]=function(){const _0x293769=_0x487f57,_0x53da4f=this[_0x293769(0x208)];this[_0x293769(0x208)]=this[_0x293769(0x26c)]();this[_0x293769(0x208)]!==_0x53da4f&&(this[_0x293769(0x208)]?this[_0x293769(0x2d2)]():this[_0x293769(0x249)]());if(this[_0x293769(0x1f6)]()){if('coGYY'==='hSQim')this[_0x293769(0x2d2)]();else{if(this[_0x293769(0x26c)]()){if(_0x293769(0x28a)===_0x293769(0x28a))TouchInput[_0x293769(0x1dd)]()&&(this['_pressed']=!![],this[_0x293769(0x2e6)]());else{this[_0x293769(0x2a0)]=_0x2fc543[_0x293769(0x2c3)];const _0x2e2133=_0x4264ce[_0x293769(0x1bc)]['Keys']['clone']();for(const _0x24f3dd of _0x2e2133){this[_0x293769(0x284)][_0x24f3dd][_0x293769(0x229)]();}}}else this[_0x293769(0x2a6)]=![],this['_hovered']=![];this[_0x293769(0x2a6)]&&TouchInput[_0x293769(0x239)]()&&(this['_pressed']=![],this[_0x293769(0x2b1)]());}}else this[_0x293769(0x2a6)]=![],this[_0x293769(0x26b)]=![];},Sprite_EvoMatrixButton[_0x487f57(0x282)][_0x487f57(0x26c)]=function(){const _0x5919b3=_0x487f57,_0x352bb1=new Point(TouchInput['x'],TouchInput['y']),_0x22297d=this[_0x5919b3(0x289)][_0x5919b3(0x2c8)](_0x352bb1);return this['hitTest'](_0x22297d['x'],_0x22297d['y']);},Window_Base[_0x487f57(0x282)][_0x487f57(0x1f9)]=function(_0x4df323,_0x5d727e,_0x15f021,_0x522d96){const _0xfdf0d5=_0x487f57,_0x4573bb=VisuMZ['EvoMatrixSkills'][_0xfdf0d5(0x21d)]['UI'];_0x522d96=_0x522d96||0x20,_0x5d727e-=Math[_0xfdf0d5(0x2f4)](_0x522d96/0x2);const _0x20e173=ImageManager[_0xfdf0d5(0x23a)](_0xfdf0d5(0x263)),_0x2b9661=ImageManager[_0xfdf0d5(0x201)],_0x15f7b3=ImageManager[_0xfdf0d5(0x2ad)],_0x1615e4=_0x4df323%0x10*_0x2b9661,_0x4f347c=Math['floor'](_0x4df323/0x10)*_0x15f7b3;this[_0xfdf0d5(0x251)][_0xfdf0d5(0x2a9)]['imageSmoothingEnabled']=_0x4573bb[_0xfdf0d5(0x1b9)],this[_0xfdf0d5(0x251)][_0xfdf0d5(0x200)](_0x20e173,_0x1615e4,_0x4f347c,_0x2b9661,_0x15f7b3,_0x5d727e,_0x15f021,_0x522d96,_0x522d96),this['contents']['_context'][_0xfdf0d5(0x1da)]=!![];},Window_BattleLog[_0x487f57(0x1c0)]=VisuMZ['EvoMatrixSkills'][_0x487f57(0x21d)]['UI'][_0x487f57(0x2ee)]||'',Window_BattleLog[_0x487f57(0x2b3)]=VisuMZ[_0x487f57(0x1bc)][_0x487f57(0x21d)]['UI'][_0x487f57(0x21a)]||0x3a,VisuMZ[_0x487f57(0x1bc)][_0x487f57(0x1c9)]=Window_BattleLog[_0x487f57(0x282)]['isBusy'],Window_BattleLog[_0x487f57(0x282)][_0x487f57(0x291)]=function(){const _0x2c3752=_0x487f57;if(this[_0x2c3752(0x232)])return!![];return VisuMZ[_0x2c3752(0x1bc)][_0x2c3752(0x1c9)]['call'](this);},VisuMZ['EvoMatrixSkills'][_0x487f57(0x202)]=Window_BattleLog[_0x487f57(0x282)][_0x487f57(0x266)],Window_BattleLog[_0x487f57(0x282)][_0x487f57(0x266)]=function(_0xd0838c,_0x967864,_0x1cb1d7){const _0x4da170=_0x487f57;this[_0x4da170(0x286)](_0xd0838c,_0x967864)?this[_0x4da170(0x2e3)](_0xd0838c,_0x967864):VisuMZ[_0x4da170(0x1bc)][_0x4da170(0x202)][_0x4da170(0x25b)](this,_0xd0838c,_0x967864,_0x1cb1d7);},Window_BattleLog[_0x487f57(0x282)]['canStartEvoSkillMatrixSkill']=function(_0x4e06fa,_0x31abc4){const _0x5d1836=_0x487f57;if(!_0x4e06fa)return![];if(!_0x4e06fa[_0x5d1836(0x2c6)]())return![];if(Imported[_0x5d1836(0x238)]&&BattleManager[_0x5d1836(0x28e)]())return![];return DataManager['hasEvoMatrixSkillPath'](_0x4e06fa,_0x31abc4['item']());},Window_BattleLog[_0x487f57(0x282)][_0x487f57(0x2e3)]=function(_0x331019,_0x3997ee){const _0xe2ad33=_0x487f57;this['_evoMatrixSkillMode']=!![],$gameTemp[_0xe2ad33(0x1af)](_0x331019,_0x3997ee[_0xe2ad33(0x285)]());if(Window_BattleLog[_0xe2ad33(0x1c0)][_0xe2ad33(0x22a)]>0x0){if('TqffJ'==='jjoMC')return![];else this[_0xe2ad33(0x25c)]('addText',Window_BattleLog[_0xe2ad33(0x1c0)]);}this['push'](_0xe2ad33(0x1cb),_0x331019,_0x3997ee),this[_0xe2ad33(0x25c)](_0xe2ad33(0x203));if(SceneManager[_0xe2ad33(0x2b0)][_0xe2ad33(0x20d)]){if(_0xe2ad33(0x2a7)===_0xe2ad33(0x2a7))SceneManager[_0xe2ad33(0x2b0)][_0xe2ad33(0x20d)]();else{if(this[_0xe2ad33(0x29c)]>0x0)return;const _0x478b39=_0xc0ea2a[_0xe2ad33(0x1bc)][_0xe2ad33(0x21d)]['UI'];this['x']=this[_0xe2ad33(0x23d)]['x']+(_0x478b39[_0xe2ad33(0x1d4)]||0x0),this['y']=this[_0xe2ad33(0x23d)]['y']+(_0x478b39[_0xe2ad33(0x1f7)]||0x0),this[_0xe2ad33(0x2a6)]&&(this['_pressedDuration']=0x4),this['_pressedDuration']-->0x0&&(this['x']+=_0x44992f[_0xe2ad33(0x1d8)],this['y']+=_0x5a011a[_0xe2ad33(0x209)]);}}},Window_BattleLog[_0x487f57(0x282)][_0x487f57(0x1dc)]=function(){const _0x37afbe=_0x487f57;this[_0x37afbe(0x232)]=![],this[_0x37afbe(0x2a5)]();const _0x3399c3=BattleManager['_subject'],_0x156d92=BattleManager[_0x37afbe(0x236)],_0xcb0182=BattleManager['_targets'];VisuMZ[_0x37afbe(0x1bc)]['Window_BattleLog_startAction'][_0x37afbe(0x25b)](this,_0x3399c3,_0x156d92,_0xcb0182),_0x156d92[_0x37afbe(0x1b6)]();};function _0x655a(){const _0x298281=['BattleManager_startAction','constructor','isSkill','clone','%1KeyIcon','resizeWindow','evoMatrixButtonsFinish','down','Sound','updateEvoMatrixTimes','playSe','FUNC','scale','MOVE_DURATION','isWordWrapEnabled','_key','isActor','width','applyInverse','_evoMatrixSkillUser','yOdAH','includes','isSupportMessageKeywords','ZdUOf','trim','currentAction','\x5cC[17]DONE\x5cC[0]','clearEvoMatrixTimes','onMouseEnter','fillStyle','WindowSkin','registerEvoMatrixSkillBase','left','meetsUpdateBitmapConditions','_evoMatrixSkillsUiTooltipWindow','Keys','_targets','VNiGc','2613632nAvyzB','11928268XYrUJW','canPerformEvoMatrixSkills','enabled','_contentSprite','IFmaf','restore','startEvoMatrixSkill','remove','height','onPress','updateMovement','LearnedMatrix','initMembers','getEvoMatrixStartAnimation','WINDOW_SKIN_FILENAME','resetFontSettings','setupDescriptionText','EvoMatrixText','registerEvoMatrixSkillsActor','1077232zkgAKS','cancel','useItem','updateEvoMatrixSkillAutoBattle','round','randomInt','padding','textSizeEx','loadWindowskin','WINDOW_SCALE','jngmI','contentDrawJS','Scale','description','createEvoMatrixSkillsUiBackground','prepareEvoMatrixSkills','refreshBitmap','visible','updateEvoMatrixSkills','EVO_MATRIX_TIMES_VARIABLE','MOUSE_OFFSET_Y','hasEvoMatrixSkillPath','applyGlobal','_skill','Scene_Battle_createDisplayObjects','LargeIconSmoothing','updateEvoMatrixSkill','DofYh','EvoMatrixSkills','OpacityDisable','_moveEasingType','MatrixOnly','EVO_MATRIX_TEXT','baseTextRect','Game_Temp_initialize','processTouch','3wjopBO','ENABLED','_hasEvoMatrixSkillsConflict','toLowerCase','isLearnedSkill','Window_BattleLog_isBusy','toUpperCase','performActionStart','endAction','lineTo','JNzNO','ARRAYEVAL','ARRAYSTR','format','meetsSkillConditions','_moveTargetX','KeybindUiOffsetX','_moveTargetY','VisuMZ_1_BattleCore','_movementWholeDuration','KEY_PRESS_OFFSET_X','qUgHn','imageSmoothingEnabled','moveToOuter','endEvoMatrixSkillMode','isTriggered','ApplyEasing','exit','_logWindow','clearEvoMatrixSkills','WindowOpacity','map','Linear','%1\x20is\x20missing\x20a\x20required\x20plugin.\x0aPlease\x20install\x20%2\x20into\x20the\x20Plugin\x20Manager.','getEvoMatrixSkillsUser','OZEmF','backgroundDrawJS','_subject','StartAni','clamp','Scene_Battle_update','_centerDimensions','_lastActor','isSceneBattle','opacityLevel','6630JJAYnm','mWsNe','updateEvoMatrixSkillsUiOpacity','KeypressUiOffsetY','setupText','isClickEnabled','KeybindUiOffsetY','8dsTNvn','drawEvoMatrixLargeIcon','_moveOpacityTarget','moveFromCenterOpaque','ConvertParams','getLastUsedGamepadType','initialize','shift','blt','iconWidth','Window_BattleLog_startAction','waitForMovement','Tooltip','KeypressUiOffsetX','OWuzB','BVVeL','_hoverState','KEY_PRESS_OFFSET_Y','refresh','show','tknyV','evoMatrixButtonsFromCenter','getButtonIcon','createEvoMatrixSkillsUiTooltipWindow','getEvoMatrixSkills','hasEvoMatrixSkillsConflicts','%1\x20is\x20incorrectly\x20placed\x20on\x20the\x20plugin\x20list.\x0aIt\x20is\x20a\x20Tier\x20%2\x20plugin\x20placed\x20over\x20other\x20Tier\x20%3\x20plugins.\x0aPlease\x20reorder\x20the\x20plugin\x20list\x20from\x20smallest\x20to\x20largest\x20tier\x20numbers.','10BRwdHV','moveTo','IxbxW','okRectJS','_contentWindow','createContentWindow','setSkill','EvoMatrixAnimation','createContentSprite','USE_SKILL_TEXT','Settings','getEvoMatrixSkillsKey','evoMatrixButtonsBranch','removeApplyGlobalEvoMatrix','windowskin','meetsEvoMatrixSkillConditions','QuirkFusionSkills','pagedown','hide','RegExp','VisuMZ_0_CoreEngine','processEvoMatrixSkillsKey','moveFromCenter','length','right','ForcedMatrix','createDisplayObjects','pngiP','_evoMatrixSkillKeys','_baseTexture','fillRect','_evoMatrixSkillMode','backOpacity','ActiveChainSkills','_text','_action','createEvoMatrixSkillsUiContainer','VisuMZ_2_BattleSystemBTB','isReleased','loadSystem','red','update','_dimensions','iIASI','Game_BattlerBase_meetsSkillConditions','JSON','MoveOutEasing','tooltipWindow','pitch','updatePosition','updateBackOpacity','min','ARRAYFUNC','_pressedDuration','onMouseExit','guQSV','ypoEk','_lastSkillID','setValue','canUse','995hTIcWq','hasEvoMatrixSkillsKey','contents','VisuMZ_1_MessageCore','BattleManager_endAction','status','requestFauxAnimation','requestRefresh','note','match','startMove','max','call','push','MoveInEasing','hasSkill','createAllSkillCostText','_evoMatrixSkillsUiContainer','OpacityRate','updateOpacity','IconSet','opacity','create','startAction','updateBitmap','_lastInputType','331328ZjRzsj','VisuMZ_1_SkillsStatesCore','_hovered','isBeingTouched','gCaIL','eCMoB','drawTextEx','getEvoMatrixAutoBattleKeys','MOVE_OUT_EASING','pan','_outerY','moveToCenter','MOVE_IN_EASING','WINDOW_SKIN_OPACITY','_requestRefresh','bitmap','UAQwl','4596957xFwqfQ','_moveOpacity','ARRAYNUM','applyKeyAlternatives','245218IIsiKZ','InputComboSkills','getSkillIdWithName','context','prototype','anchor','_evoMatrixSkillButtons','item','canStartEvoSkillMatrixSkill','UngGl','LoLLm','worldTransform','cLDzL','name','applyEasing','_outerX','isBTB','_moveFinishFunc','isAutoBattle','isBusy','beginPath','STR','AvailableMatrix','createEvoMatrixSkillsUiButtons','registerEvoMatrixSkillsType','filter','RIUQt','aeseP','createEvoMatrixSkillsUiElements','return\x200','_movementDuration','windowPadding','BackgroundImage','value','_evoMatrixSkillsUiMoveDuration','test','quadraticCurveTo','clampPosition','EVAL','clear','_pressed','gPYXE','save','_context','MOUSE_OFFSET_X','CSiJR','MoveDuration','iconHeight','addChild','parse','_scene','onClick','%1RectJS','EVO_MATRIX_ANIMATION','IjtVl','huQEf'];_0x655a=function(){return _0x298281;};return _0x655a();}function Window_EvoMatrixSkillsTooltip(){const _0x589c0c=_0x487f57;this[_0x589c0c(0x1fe)](...arguments);}Window_EvoMatrixSkillsTooltip[_0x487f57(0x282)]=Object[_0x487f57(0x265)](Window_Base['prototype']),Window_EvoMatrixSkillsTooltip[_0x487f57(0x282)][_0x487f57(0x2b7)]=Window_EvoMatrixSkillsTooltip,Window_EvoMatrixSkillsTooltip[_0x487f57(0x1c5)]=VisuMZ[_0x487f57(0x1bc)][_0x487f57(0x21d)][_0x487f57(0x204)][_0x487f57(0x2df)]??!![],Window_EvoMatrixSkillsTooltip[_0x487f57(0x2f9)]=VisuMZ[_0x487f57(0x1bc)][_0x487f57(0x21d)][_0x487f57(0x204)][_0x487f57(0x2fc)],Window_EvoMatrixSkillsTooltip[_0x487f57(0x2eb)]=VisuMZ['EvoMatrixSkills'][_0x487f57(0x21d)][_0x487f57(0x204)][_0x487f57(0x2d4)],Window_EvoMatrixSkillsTooltip[_0x487f57(0x276)]=VisuMZ[_0x487f57(0x1bc)][_0x487f57(0x21d)][_0x487f57(0x204)][_0x487f57(0x1e2)],Window_EvoMatrixSkillsTooltip[_0x487f57(0x2aa)]=VisuMZ[_0x487f57(0x1bc)][_0x487f57(0x21d)][_0x487f57(0x204)]['OffsetX'],Window_EvoMatrixSkillsTooltip[_0x487f57(0x1b4)]=VisuMZ[_0x487f57(0x1bc)][_0x487f57(0x21d)][_0x487f57(0x204)]['OffsetY'],Window_EvoMatrixSkillsTooltip[_0x487f57(0x282)]['initialize']=function(){const _0x3b770e=_0x487f57,_0x3cd2e8=new Rectangle(0x0,0x0,Graphics[_0x3b770e(0x2c7)],Graphics['height']);Window_Base[_0x3b770e(0x282)][_0x3b770e(0x1fe)]['call'](this,_0x3cd2e8),this['scale']['x']=this[_0x3b770e(0x2c2)]['y']=Window_EvoMatrixSkillsTooltip[_0x3b770e(0x2f9)],this[_0x3b770e(0x225)](),this[_0x3b770e(0x1b7)]=null;},Window_EvoMatrixSkillsTooltip['prototype'][_0x487f57(0x2f8)]=function(){const _0x39530e=_0x487f57;this['windowskin']=ImageManager[_0x39530e(0x23a)](Window_EvoMatrixSkillsTooltip[_0x39530e(0x2eb)]);},Window_EvoMatrixSkillsTooltip[_0x487f57(0x282)][_0x487f57(0x245)]=function(){const _0xd0919a=_0x487f57;this[_0xd0919a(0x233)]=Window_EvoMatrixSkillsTooltip[_0xd0919a(0x276)];},Window_EvoMatrixSkillsTooltip[_0x487f57(0x282)]['setSkill']=function(_0xf92ee1){const _0x39bf39=_0x487f57;if(this[_0x39bf39(0x1b7)]===_0xf92ee1)return;this[_0x39bf39(0x1b7)]=_0xf92ee1,this['_skill']&&this[_0x39bf39(0x1b7)][_0x39bf39(0x2fd)][_0x39bf39(0x2ce)]()[_0x39bf39(0x22a)]>0x0?this[_0x39bf39(0x20a)]():this[_0x39bf39(0x225)]();},Window_EvoMatrixSkillsTooltip[_0x487f57(0x282)]['refresh']=function(){const _0x403925=_0x487f57;this[_0x403925(0x251)][_0x403925(0x2a5)](),this[_0x403925(0x1f5)]();if(this['_text'][_0x403925(0x22a)]>0x0){this[_0x403925(0x2bb)]();const _0x3654be=this[_0x403925(0x1c1)]();this[_0x403925(0x26f)](this['_text'],_0x3654be['x'],_0x3654be['y'],_0x3654be['width']),this[_0x403925(0x20b)]();}else this[_0x403925(0x225)]();},Window_EvoMatrixSkillsTooltip[_0x487f57(0x282)][_0x487f57(0x2c4)]=function(){return![];},Window_EvoMatrixSkillsTooltip[_0x487f57(0x282)]['convertMessageKeywords']=function(_0x18b9f5){return _0x18b9f5;},Window_EvoMatrixSkillsTooltip[_0x487f57(0x282)][_0x487f57(0x2cc)]=function(){return![];},Window_EvoMatrixSkillsTooltip['prototype']['setupText']=function(){const _0x892419=_0x487f57;this[_0x892419(0x235)]='';if(!this[_0x892419(0x1b7)])return;this[_0x892419(0x2ed)](),this['_text']=this[_0x892419(0x235)][_0x892419(0x2ce)]();},Window_EvoMatrixSkillsTooltip[_0x487f57(0x282)][_0x487f57(0x2ed)]=function(){const _0x5cddce=_0x487f57;this['_text']=this[_0x5cddce(0x1b7)]['description']||'';},Window_EvoMatrixSkillsTooltip[_0x487f57(0x282)][_0x487f57(0x2bb)]=function(){const _0x1dff5e=_0x487f57,_0x499103=this[_0x1dff5e(0x2f7)](this['_text']);this[_0x1dff5e(0x2c7)]=_0x499103[_0x1dff5e(0x2c7)]+(this['itemPadding']()+this['padding'])*0x2,this[_0x1dff5e(0x2e5)]=_0x499103[_0x1dff5e(0x2e5)]+this[_0x1dff5e(0x2f6)]*0x2,this['createContents'](),this['resetFontSettings']();},Window_EvoMatrixSkillsTooltip[_0x487f57(0x282)]['update']=function(){const _0x50400f=_0x487f57;Window_Base[_0x50400f(0x282)][_0x50400f(0x23c)]['call'](this),this[_0x50400f(0x277)]&&(this['_requestRefresh']=![],this[_0x50400f(0x20a)]()),this['updatePosition'](),this[_0x50400f(0x262)]();},Window_EvoMatrixSkillsTooltip[_0x487f57(0x282)][_0x487f57(0x256)]=function(){const _0x2c1381=_0x487f57;this[_0x2c1381(0x277)]=!![];},Window_EvoMatrixSkillsTooltip[_0x487f57(0x282)][_0x487f57(0x244)]=function(){const _0x547ce3=_0x487f57;if(!this[_0x547ce3(0x1b1)])return;this['x']=TouchInput['x']+Window_EvoMatrixSkillsTooltip[_0x547ce3(0x2aa)],this['y']=TouchInput['y']+Window_EvoMatrixSkillsTooltip[_0x547ce3(0x1b4)],this['clampPosition']();},Window_EvoMatrixSkillsTooltip[_0x487f57(0x282)][_0x487f57(0x2a3)]=function(){const _0xf20fed=_0x487f57,_0x4872e8=this['width']*(Window_EvoMatrixSkillsTooltip[_0xf20fed(0x2f9)]||0.01),_0xb3ffa1=this[_0xf20fed(0x2e5)]*(Window_EvoMatrixSkillsTooltip['WINDOW_SCALE']||0.01);this['x']=Math[_0xf20fed(0x2f4)](this['x'][_0xf20fed(0x1eb)](0x0,Graphics[_0xf20fed(0x2c7)]-_0x4872e8)),this['y']=Math[_0xf20fed(0x2f4)](this['y']['clamp'](0x0,Graphics[_0xf20fed(0x2e5)]-_0xb3ffa1));},Window_EvoMatrixSkillsTooltip[_0x487f57(0x282)][_0x487f57(0x262)]=function(){const _0x4bca2a=_0x487f57;let _0x3f2a5d=0xff;if(TouchInput['x']<=0x0)_0x3f2a5d=0x0;if(TouchInput['x']>=Graphics[_0x4bca2a(0x2c7)])_0x3f2a5d=0x0;if(TouchInput['y']<=0x0)_0x3f2a5d=0x0;if(TouchInput['y']>=Graphics[_0x4bca2a(0x2e5)])_0x3f2a5d=0x0;this['opacity']=_0x3f2a5d;};