//=============================================================================
// VisuStella MZ - Input Combo Skills
// VisuMZ_3_InputComboSkills.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_3_InputComboSkills = true;

var VisuMZ = VisuMZ || {};
VisuMZ.InputComboSkills = VisuMZ.InputComboSkills || {};
VisuMZ.InputComboSkills.version = 1.01;

//=============================================================================
/* ----------------------------------------------------------------------------
 * Sound Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Sound:
 *
 * @param Input
 * @text Input Sound
 *
 * @param inputName:str
 * @text Filename
 * @parent Input
 * @type file
 * @dir audio/se/
 * @require 1
 * @desc Filename of the sound effect played.
 * @default Skill2
 *
 * @param inputVolume:num
 * @text Volume
 * @parent Input
 * @type number
 * @max 100
 * @desc Volume of the sound effect played.
 * @default 90
 *
 * @param inputPitch:num
 * @text Pitch
 * @parent Input
 * @type number
 * @desc Pitch of the sound effect played.
 * @default 100
 *
 * @param inputPan:num
 * @text Pan
 * @parent Input
 * @desc Pan of the sound effect played.
 * @default 0
 * 
 * @param Special
 * @text Special Sound
 *
 * @param specialName:str
 * @text Filename
 * @parent Special
 * @type file
 * @dir audio/se/
 * @require 1
 * @desc Filename of the sound effect played.
 * @default Skill3
 *
 * @param specialVolume:num
 * @text Volume
 * @parent Special
 * @type number
 * @max 100
 * @desc Volume of the sound effect played.
 * @default 90
 *
 * @param specialPitch:num
 * @text Pitch
 * @parent Special
 * @type number
 * @desc Pitch of the sound effect played.
 * @default 100
 *
 * @param specialPan:num
 * @text Pan
 * @parent Special
 * @desc Pan of the sound effect played.
 * @default 0
 *
 */
/* ----------------------------------------------------------------------------
 * UI Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~UI:
 *
 * @param General
 *
 * @param BackgroundImage:str
 * @text Custom BG Image
 * @parent General
 * @type file
 * @dir img/system/
 * @require 1
 * @desc Do you want to use a custom background image?
 * Located in /img/system/ folder. Covers whole screen.
 * @default 
 *
 * @param LargeIconSmoothing:eval
 * @text Icon Smoothing?
 * @parent General
 * @type boolean
 * @on Smooth
 * @off Pixelate
 * @desc Smooth the display for icons?
 * Or pixelate them?
 * @default false
 *
 * @param InputComboText:str
 * @text Input Combo Text
 * @parent General
 * @desc What text do you want displayed when starting an Input Combo sequence?
 * @default Input Combo Sequence
 *
 * @param InputComboAnimation:num
 * @text Sequence Animation
 * @parent InputComboText:str
 * @type animation
 * @desc What animation should be played when starting the Input Combo sequence?
 * @default 49
 *
 * @param OpacityDisable:num
 * @text Disabled Opacity
 * @parent General
 * @desc What is the opacity level for disabled UI elements?
 * @default 128
 *
 * @param OpacityRate:num
 * @text Opacity Rate
 * @parent General
 * @desc Fade in/out the background at what opacity rate?
 * Lower is slower. Higher is faster.
 * @default 16
 *
 * @param Scale:num
 * @text Scale
 * @parent General
 * @desc What is the scale of UI buttons?
 * 0.50 = 50%; 1.00 = 100%; 1.50 = 150%;
 * @default 0.50
 *
 * @param contentDrawJS:func
 * @text JS: Draw Skill Data
 * @parent General
 * @type note
 * @desc Code used to draw the skill data layer while
 * Input Combo Skill inputs are active.
 * @default "// Declare Constants\nconst skill = arguments[0];\nconst keyIcon = arguments[1];\nconst costText = arguments[2];\nconst bitmap = this.contents;\nconst lineHeight = this.lineHeight();\nconst iconIndex = skill.iconIndex;\nconst iconSize = ImageManager.iconWidth * 2;\n\n// Draw Large Icon\nconst hx = Math.ceil(bitmap.width / 2);\nthis.drawInputComboLargeIcon(iconIndex, hx, 0, iconSize);\n\n// Draw Keybind Icon\nconst kx = hx - iconSize;\nthis.drawInputComboLargeIcon(keyIcon, kx, 0, iconSize);\n\n// Draw Rounded Rectangle\nconst rx = 0;\nconst ry = Math.round(iconSize + lineHeight * 0.25);\nconst rw = bitmap.width;\nconst rh = Math.round(lineHeight * 1.75);\nconst radius = 20;\nconst rcolor = ColorManager.dimColor1();\nbitmap.fillRoundRect(rx, ry, rw, rh, radius, rcolor);\n\n// Draw Skill Name\nconst name = skill.name;\nconst ny = ry + ((costText.length > 0) ? 0 : Math.floor((rh - lineHeight) / 2));\nthis.drawText(name, 0, ny, bitmap.width, 'center');\n\n// Draw Cost Text\nconst cw = this.textSizeEx(costText).width;\nconst cx = Math.floor((bitmap.width - cw) / 2);\nconst cy = ry + Math.ceil(lineHeight * 0.75);\nthis.drawTextEx(costText, cx, cy);"
 *
 * @param backgroundDrawJS:func
 * @text JS: Draw Background
 * @parent General
 * @type note
 * @desc Code used to draw the background layer while
 * Input Combo Skill inputs are active.
 * @default "// Declare Constants\nconst bitmap = this;\nconst width = bitmap.width;\nconst height = Math.ceil(bitmap.height / 2);\nconst x = 0;\nconst y = bitmap.height - height;\nconst color1 = ColorManager.dimColor1();\nconst color2 = ColorManager.dimColor2();\n\n// Draw Gradient Background\nconst vert = true;\nbitmap.gradientFillRect(x, y, width, height, color2, color1, vert);"
 * 
 * @param QueueUI
 * @text Queue List UI
 * 
 * @param queueBackgroundImage:str
 * @text Custom BG Image
 * @parent QueueUI
 * @type file
 * @dir img/system/
 * @require 1
 * @desc Use a custom background image for Queue UI?
 * Located in /img/system/ folder.
 * @default 
 *
 * @param queueVisibilityFrames:num
 * @text Visibility Frames
 * @parent QueueUI
 * @type number
 * @min 1
 * @desc How long does the Queue List stay visible for after
 * the player finishes input? 60 frames = 1 second.
 * @default 90
 *
 * @param queueDrawJS:func
 * @text JS: Draw Content
 * @parent QueueUI
 * @type note
 * @desc Code used to draw the list data while inputting skills.
 * @default "// Declare Constants\nconst skillList = arguments[0];\nconst specialSkill = arguments[1];\nconst maxCombo = arguments[2];\nconst drawBackRect = arguments[3];\nconst bitmap = this.contents;\nconst lineHeight = this.lineHeight();\nconst iconSize = ImageManager.iconWidth * 2;\n\n// Draw Background Rect\nif (drawBackRect) {\n    const radius = 20;\n    const bgColor = ColorManager.dimColor1();\n    bitmap.fillRoundRect(0, 0, bitmap.width, bitmap.height, radius, bgColor);\n}\n\n// Draw Skill List\nconst iw = maxCombo * iconSize;\nconst ih = iconSize;\nconst ix = Math.floor((bitmap.width - iw) / 2);\nconst iy = Math.floor(lineHeight / 4);\nlet dx = Math.floor(iconSize / 2);\nfor (const skill of skillList) {\n    const iconIndex = skill.iconIndex;\n    this.drawInputComboLargeIcon(iconIndex, ix + dx, iy, iconSize);\n    dx += iconSize;\n}\n\n// Draw Special Skill\nif (specialSkill) {\n    const text = '\\\\I[%1]%2'.format(specialSkill.iconIndex, specialSkill.name);\n    const textWidth = this.textSizeEx(text).width;\n    const tx = Math.floor((bitmap.width - textWidth) / 2);\n    const ty = iy + ih + Math.floor(lineHeight / 2);\n    this.drawTextEx(text, tx, ty);\n}"
 *
 * @param queueDrawBackRect:eval
 * @text Draw Back Rectangle?
 * @parent queueDrawJS:func
 * @type boolean
 * @on Draw Rectangle
 * @off Don't Draw
 * @desc Draw a rectangle in the back to make the contents easier to read?
 * @default true
 * 
 * @param queueRectJS:func
 * @text JS: X, Y, W, H
 * @parent QueueUI
 * @type note
 * @desc Code used to determine the dimensions for this list UI element.
 * @default "// Declare Constants\nconst iconHeight = ImageManager.iconHeight;\nconst lineHeight = Window_Base.prototype.lineHeight();\nconst padding = $gameSystem.windowPadding();\n\n// Calculate Dimensions\nconst x = Math.round(Graphics.width / 2);\nconst y = Math.round(Graphics.height / 2);\nconst w = Math.round(Graphics.width / 3);\nconst h = (iconHeight + lineHeight + padding) * 2;\n\n// Return Rectangle\nreturn new Rectangle(x, y, w, h);"
 * 
 * @param Keybinds
 * @text Key Binds
 * 
 * @param KeybindOffsets
 * @text Offsets
 * @parent Keybinds
 *
 * @param KeybindUiOffsetX:num
 * @text Key Bind Offset X
 * @parent KeybindOffsets
 * @desc Offset the x coordinate all of key bind buttons.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param KeybindUiOffsetY:num
 * @text Key Bind Offset Y
 * @parent KeybindOffsets
 * @desc Offset the y coordinate all of key bind buttons.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @param KeybindPressed
 * @text Pressed
 * @parent Keybinds
 *
 * @param KeypressUiOffsetX:num
 * @text Key Press Offset X
 * @parent KeybindPressed
 * @desc Offset the x coordinate when the key is pressed.
 * Negative: left. Positive: right.
 * @default -4
 *
 * @param KeypressUiOffsetY:num
 * @text Key Press Offset Y
 * @parent KeybindPressed
 * @desc Offset the y coordinate when the key is pressed.
 * Negative: up. Positive: down.
 * @default +4
 * 
 * @param Down
 * @parent Keybinds
 *
 * @param downKeyIcon:num
 * @text Key Icon
 * @parent Down
 * @desc What is the icon used to mark this key bind?
 * Takes priority over Core Engine's Button Assist.
 * @default 0
 *
 * @param downBackgroundImage:str
 * @text Custom BG Image
 * @parent Down
 * @type file
 * @dir img/system/
 * @require 1
 * @desc Do you want to use a custom background image?
 * Located in /img/system/ folder. Ignores scaling.
 * @default 
 * 
 * @param downRectJS:func
 * @text JS: X, Y, W, H
 * @parent Down
 * @type note
 * @desc Code used to determine the dimensions for this button.
 * @default "// Declare Constants\nconst uiWidth = Math.floor(Graphics.width / 3);\nconst spacing = 8;\nconst lineHeight = Window_Base.prototype.lineHeight();\nconst lines = 4;\n\n// Calculate Dimensions\nconst w = Math.floor(uiWidth / 3) - (spacing * 2);\nconst rectWidth = Math.max(192, w);\nconst h = lines * lineHeight;\nconst x = Graphics.width - 48 - Math.floor(uiWidth / 2);\nconst y = Math.floor(Graphics.height * 3 / 4) + Math.ceil(h / 2) + spacing;\n\n// Return Rectangle\nreturn new Rectangle(x, y, rectWidth, h);"
 * 
 * @param Left
 * @parent Keybinds
 *
 * @param leftKeyIcon:num
 * @text Key Icon
 * @parent Left
 * @desc What is the icon used to mark this key bind?
 * Takes priority over Core Engine's Button Assist.
 * @default 0
 *
 * @param leftBackgroundImage:str
 * @text Custom BG Image
 * @parent Left
 * @type file
 * @dir img/system/
 * @require 1
 * @desc Do you want to use a custom background image?
 * Located in /img/system/ folder. Ignores scaling.
 * @default 
 * 
 * @param leftRectJS:func
 * @text JS: X, Y, W, H
 * @parent Left
 * @type note
 * @desc Code used to determine the dimensions for this button.
 * @default "// Declare Constants\nconst uiWidth = Math.floor(Graphics.width / 3);\nconst spacing = 8;\nconst lines = 4;\n\n// Calculate Dimensions\nconst w = Math.floor(uiWidth / 3) - (spacing * 2);\nconst h = lines * Window_Base.prototype.lineHeight();\nconst x = Graphics.width - 48 - Math.floor(uiWidth / 2) - w - spacing;\nconst y = Math.floor(Graphics.height * 3 / 4);\n\n// Return Rectangle\nconst rectWidth = Math.max(192, w);\nreturn new Rectangle(x, y, rectWidth, h);"
 * 
 * @param Right
 * @parent Keybinds
 *
 * @param rightKeyIcon:num
 * @text Key Icon
 * @parent Right
 * @desc What is the icon used to mark this key bind?
 * Takes priority over Core Engine's Button Assist.
 * @default 0
 *
 * @param rightBackgroundImage:str
 * @text Custom BG Image
 * @parent Right
 * @type file
 * @dir img/system/
 * @require 1
 * @desc Do you want to use a custom background image?
 * Located in /img/system/ folder. Ignores scaling.
 * @default 
 * 
 * @param rightRectJS:func
 * @text JS: X, Y, W, H
 * @parent Right
 * @type note
 * @desc Code used to determine the dimensions for this button.
 * @default "// Declare Constants\nconst uiWidth = Math.floor(Graphics.width / 3);\nconst spacing = 8;\nconst lines = 4;\n\n// Calculate Dimensions\nconst w = Math.floor(uiWidth / 3) - (spacing * 2);\nconst h = lines * Window_Base.prototype.lineHeight();\nconst x = Graphics.width - 48 - Math.floor(uiWidth / 2) + w + spacing;\nconst y = Math.floor(Graphics.height * 3 / 4);\n\n// Return Rectangle\nconst rectWidth = Math.max(192, w);\nreturn new Rectangle(x, y, rectWidth, h);"
 * 
 * @param Up
 * @parent Keybinds
 *
 * @param upKeyIcon:num
 * @text Key Icon
 * @parent Up
 * @desc What is the icon used to mark this key bind?
 * Takes priority over Core Engine's Button Assist.
 * @default 0
 *
 * @param upBackgroundImage:str
 * @text Custom BG Image
 * @parent Up
 * @type file
 * @dir img/system/
 * @require 1
 * @desc Do you want to use a custom background image?
 * Located in /img/system/ folder. Ignores scaling.
 * @default 
 * 
 * @param upRectJS:func
 * @text JS: X, Y, W, H
 * @parent Up
 * @type note
 * @desc Code used to determine the dimensions for this button.
 * @default "// Declare Constants\nconst uiWidth = Math.floor(Graphics.width / 3);\nconst spacing = 8;\nconst lineHeight = Window_Base.prototype.lineHeight();\nconst lines = 4;\n\n// Calculate Dimensions\nconst w = Math.floor(uiWidth / 3) - (spacing * 2);\nconst rectWidth = Math.max(192, w);\nconst h = lines * lineHeight;\nconst x = Graphics.width - 48 - Math.floor(uiWidth / 2);\nconst y = Math.floor(Graphics.height * 3 / 4) - Math.ceil(h / 2) - spacing;\n\n// Return Rectangle\nreturn new Rectangle(x, y, rectWidth, h);"
 * 
 * @param Ok
 * @parent Keybinds
 *
 * @param okKeyIcon:num
 * @text Key Icon
 * @parent Ok
 * @desc What is the icon used to mark this key bind?
 * Takes priority over Core Engine's Button Assist.
 * @default 0
 *
 * @param okBackgroundImage:str
 * @text Custom BG Image
 * @parent Ok
 * @type file
 * @dir img/system/
 * @require 1
 * @desc Do you want to use a custom background image?
 * Located in /img/system/ folder. Ignores scaling.
 * @default 
 * 
 * @param okRectJS:func
 * @text JS: X, Y, W, H
 * @parent Ok
 * @type note
 * @desc Code used to determine the dimensions for this button.
 * @default "// Declare Constants\nconst uiWidth = Math.floor(Graphics.width / 3);\nconst spacing = 8;\nconst lineHeight = Window_Base.prototype.lineHeight();\nconst lines = 4;\n\n// Calculate Dimensions\nconst w = Math.floor(uiWidth / 3) - (spacing * 2);\nconst rectWidth = Math.max(192, w);\nconst h = lines * lineHeight;\nconst x = Math.floor(uiWidth / 2) + 48;\nconst y = Math.floor(Graphics.height * 3 / 4);\n\n// Return Rectangle\nreturn new Rectangle(x, y, rectWidth, h);"
 * 
 * @param Cancel
 * @parent Keybinds
 *
 * @param cancelKeyIcon:num
 * @text Key Icon
 * @parent Cancel
 * @desc What is the icon used to mark this key bind?
 * Takes priority over Core Engine's Button Assist.
 * @default 0
 *
 * @param cancelBackgroundImage:str
 * @text Custom BG Image
 * @parent Cancel
 * @type file
 * @dir img/system/
 * @require 1
 * @desc Do you want to use a custom background image?
 * Located in /img/system/ folder. Ignores scaling.
 * @default 
 * 
 * @param cancelRectJS:func
 * @text JS: X, Y, W, H
 * @parent Cancel
 * @type note
 * @desc Code used to determine the dimensions for this button.
 * @default "// Declare Constants\nconst uiWidth = Math.floor(Graphics.width / 3);\nconst spacing = 8;\nconst lineHeight = Window_Base.prototype.lineHeight();\nconst lines = 4;\n\n// Calculate Dimensions\nconst w = Math.floor(uiWidth / 3) - (spacing * 2);\nconst rectWidth = Math.max(192, w);\nconst h = lines * lineHeight;\nconst x = Math.floor(uiWidth / 2) + 48 + w + spacing;\nconst y = Math.floor(Graphics.height * 3 / 4);\n\n// Return Rectangle\nreturn new Rectangle(x, y, rectWidth, h);"
 * 
 * @param PageUp
 * @parent Keybinds
 *
 * @param pageupKeyIcon:num
 * @text Key Icon
 * @parent PageUp
 * @desc What is the icon used to mark this key bind?
 * Takes priority over Core Engine's Button Assist.
 * @default 0
 *
 * @param pageupBackgroundImage:str
 * @text Custom BG Image
 * @parent PageUp
 * @type file
 * @dir img/system/
 * @require 1
 * @desc Do you want to use a custom background image?
 * Located in /img/system/ folder. Ignores scaling.
 * @default 
 * 
 * @param pageupRectJS:func
 * @text JS: X, Y, W, H
 * @parent PageUp
 * @type note
 * @desc Code used to determine the dimensions for this button.
 * @default "// Declare Constants\nconst uiWidth = Math.floor(Graphics.width / 3);\nconst spacing = 8;\nconst lineHeight = Window_Base.prototype.lineHeight();\nconst lines = 4;\n\n// Calculate Dimensions\nconst w = Math.floor(uiWidth / 3) - (spacing * 2);\nconst rectWidth = Math.max(192, w);\nconst h = lines * lineHeight;\nconst x = Math.floor(uiWidth / 2) + 48 - Math.ceil((w + spacing) / 2);\nconst y = Math.floor(Graphics.height * 3 / 4) - Math.ceil(h / 2) - spacing;\n\n// Return Rectangle\nreturn new Rectangle(x, y, rectWidth, h);"
 * 
 * @param PageDown
 * @parent Keybinds
 *
 * @param pagedownKeyIcon:num
 * @text Key Icon
 * @parent PageDown
 * @desc What is the icon used to mark this key bind?
 * Takes priority over Core Engine's Button Assist.
 * @default 0
 *
 * @param pagedownBackgroundImage:str
 * @text Custom BG Image
 * @parent PageDown
 * @type file
 * @dir img/system/
 * @require 1
 * @desc Do you want to use a custom background image?
 * Located in /img/system/ folder. Ignores scaling.
 * @default 
 * 
 * @param pagedownRectJS:func
 * @text JS: X, Y, W, H
 * @parent PageDown
 * @type note
 * @desc Code used to determine the dimensions for this button.
 * @default "// Declare Constants\nconst uiWidth = Math.floor(Graphics.width / 3);\nconst spacing = 8;\nconst lineHeight = Window_Base.prototype.lineHeight();\nconst lines = 4;\n\n// Calculate Dimensions\nconst w = Math.floor(uiWidth / 3) - (spacing * 2);\nconst rectWidth = Math.max(192, w);\nconst h = lines * lineHeight;\nconst x = Math.floor(uiWidth / 2) + 48 + Math.ceil((w + spacing) / 2);\nconst y = Math.floor(Graphics.height * 3 / 4) - Math.ceil(h / 2) - spacing;\n\n// Return Rectangle\nreturn new Rectangle(x, y, rectWidth, h);"
 * 
 * @param Shift
 * @parent Keybinds
 *
 * @param shiftKeyIcon:num
 * @text Key Icon
 * @parent Shift
 * @desc What is the icon used to mark this key bind?
 * Takes priority over Core Engine's Button Assist.
 * @default 0
 *
 * @param shiftBackgroundImage:str
 * @text Custom BG Image
 * @parent Shift
 * @type file
 * @dir img/system/
 * @require 1
 * @desc Do you want to use a custom background image?
 * Located in /img/system/ folder. Ignores scaling.
 * @default 
 * 
 * @param shiftRectJS:func
 * @text JS: X, Y, W, H
 * @parent Shift
 * @type note
 * @desc Code used to determine the dimensions for this button.
 * @default "// Declare Constants\nconst uiWidth = Math.floor(Graphics.width / 3);\nconst spacing = 8;\nconst lineHeight = Window_Base.prototype.lineHeight();\nconst lines = 4;\n\n// Calculate Dimensions\nconst w = Math.floor(uiWidth / 3) - (spacing * 2);\nconst rectWidth = Math.max(192, w);\nconst h = lines * lineHeight;\nconst x = Math.floor(uiWidth / 2) + 48 - w - spacing;\nconst y = Math.floor(Graphics.height * 3 / 4);\n\n// Return Rectangle\nreturn new Rectangle(x, y, rectWidth, h);"
 *
 */
/* ----------------------------------------------------------------------------
 * Tooltip Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Tooltip:
 *
 * @param enabled:eval
 * @text Enabled?
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Are tooltips enabled?
 * Requires VisuMZ_1_MessageCore!
 * @default true
 *
 * @param Appearance
 *
 * @param Scale:num
 * @text Scale
 * @parent Appearance
 * @desc What scale size do you want for the tooltip?
 * Use 1.0 for normal size.
 * @default 0.6
 *
 * @param WindowSkin:str
 * @text Skin Filename
 * @parent Appearance
 * @type file
 * @dir img/system/
 * @desc What window skin do you want to use for the tooltip?
 * @default Window
 *
 * @param WindowOpacity:num
 * @text Skin Opacity
 * @parent Appearance
 * @type number
 * @min 0
 * @max 255
 * @desc What opacity setting is used for the tooltip?
 * Use a number between 0 and 255.
 * @default 240
 *
 * @param Offset
 *
 * @param OffsetX:num
 * @text Offset X
 * @parent Offset
 * @desc Offset the tooltip X position from the mouse?
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param OffsetY:num
 * @text Offset Y
 * @parent Offset
 * @desc Offset the tooltip Y position from the mouse?
 * Negative: up. Positive: down.
 * @default +0
 *
 */
//=============================================================================

const _0x2b276d=_0x3fe0;(function(_0x2da23b,_0x35fc4c){const _0x392844=_0x3fe0,_0x28f343=_0x2da23b();while(!![]){try{const _0x3f7eed=parseInt(_0x392844(0x288))/0x1+parseInt(_0x392844(0x20f))/0x2*(parseInt(_0x392844(0x2b9))/0x3)+parseInt(_0x392844(0x1e2))/0x4+parseInt(_0x392844(0x2a3))/0x5+-parseInt(_0x392844(0x2c2))/0x6+-parseInt(_0x392844(0x19f))/0x7+-parseInt(_0x392844(0x1da))/0x8*(parseInt(_0x392844(0x17b))/0x9);if(_0x3f7eed===_0x35fc4c)break;else _0x28f343['push'](_0x28f343['shift']());}catch(_0x48c3a6){_0x28f343['push'](_0x28f343['shift']());}}}(_0x4880,0x2a0e0));var label=_0x2b276d(0x2a8),tier=tier||0x0,dependencies=[_0x2b276d(0x282),_0x2b276d(0x2ba)],pluginData=$plugins['filter'](function(_0x58babb){const _0x41a17d=_0x2b276d;return _0x58babb[_0x41a17d(0x1c0)]&&_0x58babb['description']['includes']('['+label+']');})[0x0];VisuMZ[label][_0x2b276d(0x214)]=VisuMZ[label][_0x2b276d(0x214)]||{},VisuMZ[_0x2b276d(0x26c)]=function(_0x48ca24,_0x5cb4b7){const _0x32a83e=_0x2b276d;for(const _0x3dea6a in _0x5cb4b7){if(_0x3dea6a[_0x32a83e(0x1e8)](/(.*):(.*)/i)){if(_0x32a83e(0x20c)!==_0x32a83e(0x20c)){const _0x438771=_0x4132ae[_0x32a83e(0x1cf)];this[_0x32a83e(0x29c)](_0x438771,_0x22508c+_0x12baf9,_0x5470c0,_0x339bb5),_0x3689e1+=_0x16df3a;}else{const _0xdc5a99=String(RegExp['$1']),_0x3d02de=String(RegExp['$2'])[_0x32a83e(0x239)]()[_0x32a83e(0x296)]();let _0x3a1c2b,_0x4868bb,_0x370eaa;switch(_0x3d02de){case _0x32a83e(0x177):_0x3a1c2b=_0x5cb4b7[_0x3dea6a]!==''?Number(_0x5cb4b7[_0x3dea6a]):0x0;break;case _0x32a83e(0x1ab):_0x4868bb=_0x5cb4b7[_0x3dea6a]!==''?JSON['parse'](_0x5cb4b7[_0x3dea6a]):[],_0x3a1c2b=_0x4868bb[_0x32a83e(0x19b)](_0x211bf3=>Number(_0x211bf3));break;case _0x32a83e(0x215):_0x3a1c2b=_0x5cb4b7[_0x3dea6a]!==''?eval(_0x5cb4b7[_0x3dea6a]):null;break;case _0x32a83e(0x225):_0x4868bb=_0x5cb4b7[_0x3dea6a]!==''?JSON[_0x32a83e(0x28b)](_0x5cb4b7[_0x3dea6a]):[],_0x3a1c2b=_0x4868bb[_0x32a83e(0x19b)](_0x533a42=>eval(_0x533a42));break;case'JSON':_0x3a1c2b=_0x5cb4b7[_0x3dea6a]!==''?JSON['parse'](_0x5cb4b7[_0x3dea6a]):'';break;case _0x32a83e(0x262):_0x4868bb=_0x5cb4b7[_0x3dea6a]!==''?JSON[_0x32a83e(0x28b)](_0x5cb4b7[_0x3dea6a]):[],_0x3a1c2b=_0x4868bb[_0x32a83e(0x19b)](_0x1cce08=>JSON[_0x32a83e(0x28b)](_0x1cce08));break;case _0x32a83e(0x1a3):_0x3a1c2b=_0x5cb4b7[_0x3dea6a]!==''?new Function(JSON[_0x32a83e(0x28b)](_0x5cb4b7[_0x3dea6a])):new Function(_0x32a83e(0x1a0));break;case _0x32a83e(0x184):_0x4868bb=_0x5cb4b7[_0x3dea6a]!==''?JSON[_0x32a83e(0x28b)](_0x5cb4b7[_0x3dea6a]):[],_0x3a1c2b=_0x4868bb['map'](_0x2b2310=>new Function(JSON['parse'](_0x2b2310)));break;case _0x32a83e(0x172):_0x3a1c2b=_0x5cb4b7[_0x3dea6a]!==''?String(_0x5cb4b7[_0x3dea6a]):'';break;case _0x32a83e(0x1d0):_0x4868bb=_0x5cb4b7[_0x3dea6a]!==''?JSON['parse'](_0x5cb4b7[_0x3dea6a]):[],_0x3a1c2b=_0x4868bb[_0x32a83e(0x19b)](_0x1fdfb0=>String(_0x1fdfb0));break;case'STRUCT':_0x370eaa=_0x5cb4b7[_0x3dea6a]!==''?JSON['parse'](_0x5cb4b7[_0x3dea6a]):{},_0x3a1c2b=VisuMZ['ConvertParams']({},_0x370eaa);break;case'ARRAYSTRUCT':_0x4868bb=_0x5cb4b7[_0x3dea6a]!==''?JSON[_0x32a83e(0x28b)](_0x5cb4b7[_0x3dea6a]):[],_0x3a1c2b=_0x4868bb['map'](_0x134c04=>VisuMZ['ConvertParams']({},JSON[_0x32a83e(0x28b)](_0x134c04)));break;default:continue;}_0x48ca24[_0xdc5a99]=_0x3a1c2b;}}}return _0x48ca24;},(_0x3264b7=>{const _0x96ff20=_0x2b276d,_0x3c16fe=_0x3264b7[_0x96ff20(0x2c9)];for(const _0x4d1b8a of dependencies){if(!Imported[_0x4d1b8a]){if(_0x96ff20(0x17c)!=='zgKbi'){alert(_0x96ff20(0x186)[_0x96ff20(0x2aa)](_0x3c16fe,_0x4d1b8a)),SceneManager['exit']();break;}else{this[_0x96ff20(0x221)]=!![],_0x3e27f5[_0x96ff20(0x1c6)](_0x1a2274,_0x33d311[_0x96ff20(0x293)]());_0x26bd81['INPUT_COMBO_TEXT'][_0x96ff20(0x2d8)]>0x0&&this[_0x96ff20(0x1a9)]('addText',_0x124886[_0x96ff20(0x232)]);this['push']('performActionStart',_0x41d92d,_0x2fcba2),this[_0x96ff20(0x1a9)](_0x96ff20(0x185));const _0x22a760=_0x57a672[_0x96ff20(0x1f1)](_0x286bb8['item']());_0x22a760>0x0&&this[_0x96ff20(0x1a9)](_0x96ff20(0x1d8),_0x1e3ce0,[_0x27ba5d],_0x22a760);}}}const _0x4778c5=_0x3264b7[_0x96ff20(0x207)];if(_0x4778c5[_0x96ff20(0x1e8)](/\[Version[ ](.*?)\]/i)){const _0x834744=Number(RegExp['$1']);_0x834744!==VisuMZ[label]['version']&&(_0x96ff20(0x250)===_0x96ff20(0x250)?(alert(_0x96ff20(0x218)[_0x96ff20(0x2aa)](_0x3c16fe,_0x834744)),SceneManager[_0x96ff20(0x220)]()):this[_0x96ff20(0x2be)]?this[_0x96ff20(0x1d6)]():this['onMouseExit']());}if(_0x4778c5[_0x96ff20(0x1e8)](/\[Tier[ ](\d+)\]/i)){if(_0x96ff20(0x294)!=='psrQg')return!!this[_0x96ff20(0x247)](_0x2a1208);else{const _0x4877ad=Number(RegExp['$1']);_0x4877ad<tier?(alert(_0x96ff20(0x1a5)[_0x96ff20(0x2aa)](_0x3c16fe,_0x4877ad,tier)),SceneManager[_0x96ff20(0x220)]()):tier=Math[_0x96ff20(0x236)](_0x4877ad,tier);}}VisuMZ[_0x96ff20(0x26c)](VisuMZ[label][_0x96ff20(0x214)],_0x3264b7[_0x96ff20(0x21f)]);})(pluginData),VisuMZ['InputComboSkills'][_0x2b276d(0x2d5)]={'InputKey':/<(?:INPUT COMBO|COMBO) SKILL[ ](.*):[ ](.*)>/gi,'AvailableSpecial':/<(?:AVAILABLE INPUT COMBO|AVAILABLE COMBO|INPUT COMBO|COMBO) SPECIAL[ ](.*):[ ](.*)>/gi,'ForcedSpecial':/<(?:ALWAYS|FORCE|FORCED) (?:INPUT COMBO|COMBO) SPECIAL[ ](.*):[ ](.*)>/gi,'LearnedSpecial':/<(?:LEARNED|KNOWN) (?:INPUT COMBO|COMBO) SPECIAL[ ](.*):[ ](.*)>/gi,'ComboOnly':/<(?:INPUT COMBO|COMBO) ONLY>/i,'ComboMax':/<(?:INPUT COMBO|COMBO) MAX:[ ](\d+)>/i,'ComboStartAni':/<(?:INPUT COMBO|COMBO) START (?:ANI|ANIMATION):[ ](\d+)>/i},VisuMZ[_0x2b276d(0x2a8)][_0x2b276d(0x270)]=VisuMZ['InputComboSkills']['Settings'][_0x2b276d(0x1ec)]||0x1,VisuMZ[_0x2b276d(0x2a8)]['Keys']=[_0x2b276d(0x1dd),_0x2b276d(0x2dd),_0x2b276d(0x25c),'up','ok',_0x2b276d(0x1ca),_0x2b276d(0x283),_0x2b276d(0x24b),_0x2b276d(0x16d)],VisuMZ[_0x2b276d(0x2a8)][_0x2b276d(0x1ce)]=function(_0x8243e0){const _0x554b43=_0x2b276d;_0x8243e0=_0x8243e0[_0x554b43(0x195)]()[_0x554b43(0x296)]();switch(_0x8243e0){case'2':return'down';case'4':return _0x554b43(0x2dd);case'6':return'right';case'8':return'up';case's':return _0x554b43(0x16d);case'z':return'ok';case'x':return _0x554b43(0x1ca);case'q':return _0x554b43(0x283);case'w':return _0x554b43(0x24b);}return _0x8243e0;},DataManager[_0x2b276d(0x20d)]=function(_0x1795b4){const _0x2f94ad=_0x2b276d;if(!_0x1795b4)return!![];if(!DataManager['isSkill'](_0x1795b4))return!![];this[_0x2f94ad(0x285)]=this[_0x2f94ad(0x285)]||{};if(this[_0x2f94ad(0x285)][_0x1795b4['id']])return this['_hasInputComboSkillsConflict'][_0x1795b4['id']];const _0x3e6554=_0x1795b4['note']||'',_0x5a8692=['ActiveChainSkills',_0x2f94ad(0x206),'QuirkFusionSkills'];this['_hasInputComboSkillsConflict'][_0x1795b4['id']]=![];for(const _0x29077c of _0x5a8692){if(!VisuMZ[_0x29077c])continue;const _0x140693=VisuMZ[_0x29077c][_0x2f94ad(0x2d5)];for(const _0x342269 in _0x140693){if(_0x3e6554[_0x2f94ad(0x1e8)](_0x140693[_0x342269])){this['_hasInputComboSkillsConflict'][_0x1795b4['id']]=!![];break;}}if(this[_0x2f94ad(0x285)][_0x1795b4['id']])break;}return this[_0x2f94ad(0x285)][_0x1795b4['id']];},DataManager[_0x2b276d(0x227)]=function(_0x55c42a){const _0x39af66=_0x2b276d;if(!_0x55c42a)return![];if(!DataManager[_0x39af66(0x265)](_0x55c42a))return![];if(DataManager[_0x39af66(0x20d)](_0x55c42a))return![];const _0x1d7d33=VisuMZ['InputComboSkills'][_0x39af66(0x2d5)],_0x5ee442=_0x55c42a[_0x39af66(0x19d)]||'';if(_0x5ee442[_0x39af66(0x1e8)](_0x1d7d33[_0x39af66(0x216)]))return!![];return![];},DataManager[_0x2b276d(0x1f1)]=function(_0x113ad6){const _0x564ba2=_0x2b276d;if(!_0x113ad6)return Window_BattleLog[_0x564ba2(0x2ca)];if(!DataManager[_0x564ba2(0x265)](_0x113ad6))return Window_BattleLog['INPUT_COMBO_ANIMATION'];const _0x1995e2=VisuMZ[_0x564ba2(0x2a8)][_0x564ba2(0x2d5)],_0x26eaeb=_0x113ad6[_0x564ba2(0x19d)]||'';if(_0x26eaeb[_0x564ba2(0x1e8)](_0x1995e2[_0x564ba2(0x2e1)])){if(_0x564ba2(0x208)==='EDacB'){if(_0xb6f27b[_0x564ba2(0x1a7)]&&this[_0x564ba2(0x1d4)]){if(this[_0x564ba2(0x1d4)][_0x564ba2(0x1be)])return;}_0x5b0c13['InputComboSkills'][_0x564ba2(0x1cc)][_0x564ba2(0x268)](this);}else return Number(RegExp['$1']);}return Window_BattleLog[_0x564ba2(0x2ca)];},DataManager['getInputComboMax']=function(_0x5db13a){const _0x1a6aca=_0x2b276d;if(!_0x5db13a)return VisuMZ[_0x1a6aca(0x2a8)][_0x1a6aca(0x270)];if(!DataManager[_0x1a6aca(0x265)](_0x5db13a))return VisuMZ[_0x1a6aca(0x2a8)]['INPUT_COMBO_DEFAULT_MAX'];this[_0x1a6aca(0x22b)]=this['_inputComboMax']||{};if(this[_0x1a6aca(0x22b)][_0x5db13a['id']])return this['_inputComboMax'][_0x5db13a['id']];const _0x4576c8=VisuMZ[_0x1a6aca(0x2a8)][_0x1a6aca(0x2d5)],_0x26118f=_0x5db13a[_0x1a6aca(0x19d)]||'';return this[_0x1a6aca(0x22b)][_0x5db13a['id']]=VisuMZ[_0x1a6aca(0x2a8)][_0x1a6aca(0x270)],_0x26118f[_0x1a6aca(0x1e8)](_0x4576c8[_0x1a6aca(0x16a)])&&('HZWYb'===_0x1a6aca(0x1e5)?this['_inputComboMax'][_0x5db13a['id']]=Math['max'](Number(RegExp['$1']),0x1):this[_0x1a6aca(0x1a9)]('showAnimation',_0x525ce3,[_0x274b90],_0x5ccdad)),this[_0x1a6aca(0x22b)][_0x5db13a['id']];},Bitmap['prototype'][_0x2b276d(0x1c5)]=function(_0xe5a3ee,_0x5b0ec3,_0x711208,_0x485c0d,_0x4fab92,_0x3733ca){const _0x164547=_0x2b276d,_0x4e338a=_0xe5a3ee+_0x711208,_0x406b7a=_0x5b0ec3+_0x485c0d,_0x4de140=this[_0x164547(0x21d)];_0x4de140['save'](),_0x4de140['fillStyle']=_0x3733ca,_0x4de140[_0x164547(0x19c)](),_0x4de140[_0x164547(0x1a6)](_0xe5a3ee+_0x4fab92,_0x5b0ec3),_0x4de140[_0x164547(0x1b5)](_0x4e338a-_0x4fab92,_0x5b0ec3),_0x4de140[_0x164547(0x297)](_0x4e338a,_0x5b0ec3,_0x4e338a,_0x5b0ec3+_0x4fab92),_0x4de140[_0x164547(0x1b5)](_0x4e338a,_0x5b0ec3+_0x485c0d-_0x4fab92),_0x4de140[_0x164547(0x297)](_0x4e338a,_0x406b7a,_0x4e338a-_0x4fab92,_0x406b7a),_0x4de140[_0x164547(0x1b5)](_0xe5a3ee+_0x4fab92,_0x406b7a),_0x4de140[_0x164547(0x297)](_0xe5a3ee,_0x406b7a,_0xe5a3ee,_0x406b7a-_0x4fab92),_0x4de140[_0x164547(0x1b5)](_0xe5a3ee,_0x5b0ec3+_0x4fab92),_0x4de140[_0x164547(0x297)](_0xe5a3ee,_0x5b0ec3,_0xe5a3ee+_0x4fab92,_0x5b0ec3),_0x4de140[_0x164547(0x1fe)](),_0x4de140[_0x164547(0x266)](),this['_baseTexture'][_0x164547(0x1d5)]();},SoundManager['playInputComboSkillsSound']=function(_0x556d9f){const _0x208d1e=_0x2b276d,_0x178b44=VisuMZ[_0x208d1e(0x2a8)]['Settings'][_0x208d1e(0x165)],_0x30be16={'name':_0x178b44[_0x208d1e(0x259)['format'](_0x556d9f)]||'','volume':_0x178b44[_0x208d1e(0x2a9)[_0x208d1e(0x2aa)](_0x556d9f)]||0x0,'pitch':_0x178b44[_0x208d1e(0x2a1)['format'](_0x556d9f)]||0x0,'pan':_0x178b44[_0x208d1e(0x211)[_0x208d1e(0x2aa)](_0x556d9f)]||0x0};AudioManager['playSe'](_0x30be16);},VisuMZ[_0x2b276d(0x2a8)][_0x2b276d(0x2bd)]=Game_Temp[_0x2b276d(0x1eb)]['initialize'],Game_Temp[_0x2b276d(0x1eb)]['initialize']=function(){const _0x1d4074=_0x2b276d;VisuMZ[_0x1d4074(0x2a8)][_0x1d4074(0x2bd)][_0x1d4074(0x268)](this),this[_0x1d4074(0x228)]();},Game_Temp['prototype']['clearInputComboSkills']=function(){const _0x1de877=_0x2b276d;this[_0x1de877(0x253)]=null,this[_0x1de877(0x246)]=[],this['_inputComboSkillKeys']={},this[_0x1de877(0x1d2)]={},this[_0x1de877(0x1b6)]='',this['_inputComboSkillSpecialSkillID']=0x0,this[_0x1de877(0x27f)]=0x0;},Game_Temp['prototype'][_0x2b276d(0x1c6)]=function(_0x1046e3,_0x2c0316){const _0x47de49=_0x2b276d;this[_0x47de49(0x228)](),this[_0x47de49(0x212)](_0x1046e3),this[_0x47de49(0x251)](_0x2c0316),this[_0x47de49(0x2d3)](_0x2c0316,_0x47de49(0x1b9)),this[_0x47de49(0x2d3)](_0x2c0316,_0x47de49(0x231)),this['registerInputComboSpecials'](_0x2c0316,_0x47de49(0x1e3)),this[_0x47de49(0x2df)](_0x2c0316);},Game_Temp[_0x2b276d(0x1eb)]['registerInputComboSkillsActor']=function(_0x2c6a29){const _0x21990d=_0x2b276d;this[_0x21990d(0x253)]=_0x2c6a29;},Game_Temp[_0x2b276d(0x1eb)]['registerInputComboSkills']=function(_0x56d6c3){const _0x609910=_0x2b276d,_0x210a78=VisuMZ[_0x609910(0x2a8)][_0x609910(0x2d5)],_0x17d527=VisuMZ[_0x609910(0x2a8)][_0x609910(0x257)][_0x609910(0x2a5)](),_0x3432ea=_0x56d6c3[_0x609910(0x19d)]||'',_0x58122a=_0x3432ea[_0x609910(0x1e8)](_0x210a78[_0x609910(0x216)]);if(_0x58122a)for(const _0x446494 of _0x58122a){if(_0x609910(0x2c3)===_0x609910(0x1f5))this[_0x609910(0x27c)]=this['_skill']['description']||'';else{_0x446494['match'](_0x210a78['InputKey']);let _0x11a1af=String(RegExp['$1'])[_0x609910(0x195)]()[_0x609910(0x296)]();const _0x4e8685=String(RegExp['$2']);_0x11a1af=VisuMZ[_0x609910(0x2a8)][_0x609910(0x1ce)](_0x11a1af);if(!_0x17d527[_0x609910(0x240)](_0x11a1af))continue;const _0x3809d5=/^\d+$/[_0x609910(0x192)](_0x4e8685);let _0x3ab13d=0x0;if(_0x3809d5){if(_0x609910(0x28c)!==_0x609910(0x2bf))_0x3ab13d=Number(_0x4e8685);else{_0x52d669[_0x609910(0x1eb)]['onMouseEnter'][_0x609910(0x268)](this);const _0x3795d3=this['tooltipWindow']();if(!_0x3795d3)return;const _0x153988=_0x2dad1f[_0x609910(0x20e)],_0x233542=_0x153988&&_0x153988[_0x609910(0x286)]?_0x153988[_0x609910(0x286)]():![];if(_0x3795d3&&_0x233542){const _0x2c1c49=_0x4ac43e[this['_lastSkillID']];_0x3795d3[_0x609910(0x2ae)](_0x2c1c49);}}}else _0x3ab13d=DataManager['getSkillIdWithName'](_0x4e8685);if(_0x3ab13d<=0x0)continue;this[_0x609910(0x18e)][_0x11a1af]=_0x3ab13d;}}},Game_Temp['prototype'][_0x2b276d(0x2d3)]=function(_0x3c7787,_0x4c18bb){const _0x18f387=_0x2b276d,_0x362800=VisuMZ[_0x18f387(0x2a8)][_0x18f387(0x2d5)],_0x28dccd=_0x3c7787[_0x18f387(0x19d)]||'',_0x1d19d1=this['_inputComboSkillUser'],_0x3da76f=_0x28dccd['match'](_0x362800[_0x4c18bb]);if(_0x3da76f){if(_0x18f387(0x2cf)==='xLMvH')for(const _0x100f5a of _0x3da76f){_0x100f5a[_0x18f387(0x1e8)](_0x362800[_0x4c18bb]);let _0x57b165=String(RegExp['$1'])['toUpperCase']()['trim']();const _0x3d0538=String(RegExp['$2']);_0x57b165=_0x57b165['replace'](/D/gi,'2'),_0x57b165=_0x57b165['replace'](/L/gi,'4'),_0x57b165=_0x57b165['replace'](/R/gi,'6'),_0x57b165=_0x57b165[_0x18f387(0x27a)](/U/gi,'8');const _0x2b1409=/^\d+$/[_0x18f387(0x192)](_0x3d0538);let _0x530ec8=0x0;_0x2b1409?_0x530ec8=Number(_0x3d0538):_0x530ec8=DataManager['getSkillIdWithName'](_0x3d0538);if(_0x530ec8<=0x0)continue;if(_0x4c18bb===_0x18f387(0x1b9)&&!_0x1d19d1['hasSkill'](_0x530ec8))continue;if(_0x4c18bb===_0x18f387(0x1e3)&&!_0x1d19d1[_0x18f387(0x1ed)](_0x530ec8))continue;this[_0x18f387(0x1d2)][_0x57b165]=_0x530ec8;}else{if(!_0x340754[_0x18f387(0x2cd)])return;if(!_0x245e29['_subject'][_0x18f387(0x199)]())return;if(!_0x5ce419[_0x18f387(0x2cd)][_0x18f387(0x295)])return;_0xd0f2ae[_0x18f387(0x2cd)][_0x18f387(0x295)]=_0x1b17f0,_0x47ed32[_0x18f387(0x2cd)]['queueNextInputComboSkill']();}}},Game_Temp[_0x2b276d(0x1eb)][_0x2b276d(0x2df)]=function(_0x36cd5e){const _0x334a16=_0x2b276d;this[_0x334a16(0x27f)]=DataManager[_0x334a16(0x2b6)](_0x36cd5e);},Game_Temp[_0x2b276d(0x1eb)]['getInputComboSkillsUser']=function(){const _0x59ccde=_0x2b276d;return this[_0x59ccde(0x253)]||null;},Game_Temp['prototype'][_0x2b276d(0x247)]=function(_0x2f64fd){const _0x425a6c=_0x2b276d;if(!this[_0x425a6c(0x18e)])return null;return this[_0x425a6c(0x18e)][_0x2f64fd];},Game_Temp[_0x2b276d(0x1eb)][_0x2b276d(0x187)]=function(_0x364ad0){const _0x4fdc0c=_0x2b276d;return!!this[_0x4fdc0c(0x247)](_0x364ad0);},Game_Temp['prototype'][_0x2b276d(0x277)]=function(){const _0x17ecb7=_0x2b276d;return(this[_0x17ecb7(0x246)]||[])['length']>0x0;},Game_Temp[_0x2b276d(0x1eb)][_0x2b276d(0x1ac)]=function(_0x10ded7){const _0x1f744a=_0x2b276d;this['addToInputComboSkillsQueueFromKey'](_0x10ded7),this[_0x1f744a(0x21e)](),this[_0x1f744a(0x271)](_0x10ded7);if(this[_0x1f744a(0x254)]()){if('SMpfO'!=='SMpfO'){const _0x376575=_0x62b3dc[_0x1f744a(0x2a8)][_0x1f744a(0x214)]['UI'];this[_0x1f744a(0x1f2)]=_0x376575[_0x1f744a(0x273)](),this['x']=this[_0x1f744a(0x1f2)]['x'],this['y']=this[_0x1f744a(0x1f2)]['y'],this[_0x1f744a(0x25e)]['x']=0.5,this[_0x1f744a(0x25e)]['y']=0.5,this[_0x1f744a(0x210)]=[],this[_0x1f744a(0x1e6)]=0x0,this[_0x1f744a(0x2bc)]=0x0,this[_0x1f744a(0x1bf)]=0x0,this[_0x1f744a(0x166)]=0x0;}else SceneManager['_scene'][_0x1f744a(0x269)]['endInputComboSkill']();}},Game_Temp[_0x2b276d(0x1eb)][_0x2b276d(0x1db)]=function(_0x16201a){const _0x16a7d4=_0x2b276d,_0x18b876=$dataSkills[$gameTemp[_0x16a7d4(0x247)](_0x16201a)];this['_inputComboSkillQueue'][_0x16a7d4(0x1a9)](_0x18b876['id']);},Game_Temp['prototype'][_0x2b276d(0x21e)]=function(){const _0x14eae3=_0x2b276d,_0x4ebfb0=this['getInputComboSkillsUser'](),_0xec72b7=this[_0x14eae3(0x246)][this[_0x14eae3(0x246)]['length']-0x1],_0x500641=$dataSkills[_0xec72b7];_0x4ebfb0['paySkillCost'](_0x500641);},Game_Temp[_0x2b276d(0x1eb)][_0x2b276d(0x271)]=function(_0x587b73){const _0x4ca991=_0x2b276d;if(_0x587b73===_0x4ca991(0x1dd))this[_0x4ca991(0x1b6)]+='2';if(_0x587b73===_0x4ca991(0x2dd))this['_inputComboSkillSpecialString']+='4';if(_0x587b73==='right')this[_0x4ca991(0x1b6)]+='6';if(_0x587b73==='up')this[_0x4ca991(0x1b6)]+='8';if(_0x587b73==='ok')this['_inputComboSkillSpecialString']+='Z';if(_0x587b73===_0x4ca991(0x1ca))this[_0x4ca991(0x1b6)]+='X';if(_0x587b73===_0x4ca991(0x283))this[_0x4ca991(0x1b6)]+='Q';if(_0x587b73===_0x4ca991(0x24b))this[_0x4ca991(0x1b6)]+='W';if(_0x587b73===_0x4ca991(0x16d))this['_inputComboSkillSpecialString']+='S';},Game_Temp[_0x2b276d(0x1eb)]['checkForInputComboSkillsEnd']=function(){const _0x5e3080=_0x2b276d,_0x43d11f=this['_inputComboSkillSpecialString'][_0x5e3080(0x239)]()['trim']();if(this[_0x5e3080(0x1d2)][_0x43d11f]){const _0x5bd7bc=this[_0x5e3080(0x1d2)][_0x43d11f];return this[_0x5e3080(0x246)][_0x5e3080(0x1a9)](_0x5bd7bc),SoundManager[_0x5e3080(0x25b)](_0x5e3080(0x18b)),this[_0x5e3080(0x1c1)]=_0x5bd7bc,!![];}return SoundManager['playInputComboSkillsSound'](_0x5e3080(0x256)),this['_inputComboSkillQueue'][_0x5e3080(0x2d8)]>=this[_0x5e3080(0x27f)];},Game_Temp['prototype'][_0x2b276d(0x176)]=function(){const _0x12d2c0=_0x2b276d;this[_0x12d2c0(0x205)]={'user':null,'skillID':-0x1};},Game_Temp[_0x2b276d(0x1eb)][_0x2b276d(0x24e)]=function(_0x1a08b4,_0x7cb3c){const _0x34a41b=_0x2b276d;if(this[_0x34a41b(0x205)]===undefined)this[_0x34a41b(0x176)]();this[_0x34a41b(0x205)][_0x34a41b(0x2c8)]=_0x1a08b4,this[_0x34a41b(0x205)]['skillID']=_0x7cb3c;},Game_Temp['prototype']['checkInputComboSkillCostBypass']=function(_0x301f3e,_0x1e3f46){const _0x52c465=_0x2b276d;if(this[_0x52c465(0x205)]===undefined)this[_0x52c465(0x176)]();return this[_0x52c465(0x205)][_0x52c465(0x2c8)]===_0x301f3e&&this['_inputComboSkillCostBypass']['skillID']===_0x1e3f46;},VisuMZ[_0x2b276d(0x2a8)][_0x2b276d(0x28e)]=Game_Battler[_0x2b276d(0x1eb)][_0x2b276d(0x2c0)],Game_Battler['prototype'][_0x2b276d(0x2c0)]=function(_0x18f6b6){const _0xd2c852=_0x2b276d;$gameTemp['checkInputComboSkillCostBypass'](this,_0x18f6b6?_0x18f6b6['id']:0x0)&&('gXJdP'!==_0xd2c852(0x2e3)?DataManager[_0xd2c852(0x22f)]=!![]:(this[_0xd2c852(0x19a)]=![],this[_0xd2c852(0x2b0)]=![])),VisuMZ['InputComboSkills'][_0xd2c852(0x28e)][_0xd2c852(0x268)](this,_0x18f6b6),DataManager[_0xd2c852(0x22f)]=![];},VisuMZ[_0x2b276d(0x2a8)][_0x2b276d(0x2d7)]=DataManager[_0x2b276d(0x265)],DataManager[_0x2b276d(0x265)]=function(_0xe1eb7d){const _0x1915eb=_0x2b276d;if(DataManager[_0x1915eb(0x22f)])return![];return VisuMZ[_0x1915eb(0x2a8)][_0x1915eb(0x2d7)][_0x1915eb(0x268)](this,_0xe1eb7d);},Game_Temp[_0x2b276d(0x1eb)][_0x2b276d(0x1f6)]=function(){const _0x12b7a7=_0x2b276d,_0x572b7a=BattleManager[_0x12b7a7(0x2cd)];if(!_0x572b7a)return!![];const _0x134667=VisuMZ[_0x12b7a7(0x2a8)]['Keys'][_0x12b7a7(0x2a5)](),_0x2c61e2=_0x134667[_0x12b7a7(0x17a)](_0x425ea5=>this[_0x12b7a7(0x187)](_0x425ea5))['map'](_0x2f7c9c=>this[_0x12b7a7(0x247)](_0x2f7c9c))['map'](_0x39cb0d=>$dataSkills[_0x39cb0d])[_0x12b7a7(0x17a)](_0x5cd80c=>_0x572b7a[_0x12b7a7(0x1bd)](_0x5cd80c));return _0x2c61e2[_0x12b7a7(0x2d8)]<=0x0;},Game_Switches[_0x2b276d(0x1eb)]['updateInputComboSkillSwitch']=function(_0x58ac46){const _0x3e529a=_0x2b276d,_0x10fceb=VisuMZ[_0x3e529a(0x2a8)]['Settings'][_0x3e529a(0x1c2)];if(_0x10fceb<=0x0)return;const _0x42ec1b=this[_0x3e529a(0x253)]===_0x58ac46&&this[_0x3e529a(0x246)][_0x3e529a(0x2d8)]>0x0;this['setValue'](_0x10fceb,_0x42ec1b);},VisuMZ[_0x2b276d(0x2a8)]['Game_Action_applyGlobal']=Game_Action[_0x2b276d(0x1eb)][_0x2b276d(0x2af)],Game_Action[_0x2b276d(0x1eb)]['applyGlobal']=function(){const _0x2ae190=_0x2b276d;VisuMZ[_0x2ae190(0x2a8)]['Game_Action_applyGlobal'][_0x2ae190(0x268)](this),$gameTemp['clearInputComboSkillCostBypass'](),this[_0x2ae190(0x22e)]();},Game_Action['prototype'][_0x2b276d(0x22e)]=function(){const _0x2bab2=_0x2b276d;if(!$gameTemp[_0x2bab2(0x277)]())return;if(this[_0x2bab2(0x167)]()!==$gameTemp[_0x2bab2(0x253)]){if(_0x2bab2(0x196)===_0x2bab2(0x196)){$gameTemp[_0x2bab2(0x228)]();return;}else this['_cacheQueue']=_0x2038cf[_0x2bab2(0x246)]['clone'](),this['_cacheSpecialSkillID']=_0xc8fb1a[_0x2bab2(0x1c1)],this[_0x2bab2(0x2bc)]=_0x2cf825[_0x2bab2(0x27f)],this['refreshBitmap']();}this[_0x2bab2(0x167)]()[_0x2bab2(0x295)]=!![];},VisuMZ['InputComboSkills'][_0x2b276d(0x1e0)]=Game_BattlerBase[_0x2b276d(0x1eb)]['meetsSkillConditions'],Game_BattlerBase['prototype'][_0x2b276d(0x2b1)]=function(_0x551106){const _0x2a177e=_0x2b276d;if(!this[_0x2a177e(0x2b4)](_0x551106))return![];return VisuMZ[_0x2a177e(0x2a8)]['Game_BattlerBase_meetsSkillConditions'][_0x2a177e(0x268)](this,_0x551106);},Game_BattlerBase['prototype'][_0x2b276d(0x2b4)]=function(_0x50e730){const _0x3e7dcf=_0x2b276d;if(!_0x50e730)return![];const _0x4dccae=VisuMZ[_0x3e7dcf(0x2a8)][_0x3e7dcf(0x2d5)],_0x45c123=_0x50e730[_0x3e7dcf(0x19d)]||'';if(_0x45c123[_0x3e7dcf(0x1e8)](_0x4dccae[_0x3e7dcf(0x2ab)])){if(!this[_0x3e7dcf(0x199)]())return![];if(!SceneManager['isSceneBattle']())return![];const _0x466286=SceneManager['_scene'][_0x3e7dcf(0x269)];if(_0x466286&&!_0x466286[_0x3e7dcf(0x221)])return![];return this[_0x3e7dcf(0x189)];}return!![];},Game_Actor[_0x2b276d(0x1eb)][_0x2b276d(0x2d4)]=function(){const _0x446d94=_0x2b276d;if($gameTemp[_0x446d94(0x253)]!==this)return;this[_0x446d94(0x241)](),$gameSwitches[_0x446d94(0x2db)](this),this[_0x446d94(0x2c4)]();},Game_Actor[_0x2b276d(0x1eb)]['forceActionInputComboSkill']=function(){const _0x4c63c4=_0x2b276d;Sprite_Actor[_0x4c63c4(0x1a7)]&&(this['_bypassStepBackward_InputComboSkill']=$gameTemp[_0x4c63c4(0x246)][_0x4c63c4(0x2d8)]>0x0);while($gameTemp[_0x4c63c4(0x246)]['length']>0x0){if(_0x4c63c4(0x290)==='UxSkq'){const _0x284d8f=$gameTemp[_0x4c63c4(0x246)]['shift'](),_0x205240=$dataSkills[_0x284d8f];if(!_0x205240)continue;this[_0x4c63c4(0x189)]=!![];if(!this[_0x4c63c4(0x1b8)](_0x205240)){this['_checkInputComboOnlySkill']=![];continue;}if(this[_0x4c63c4(0x1c7)](_0x205240['id']))continue;if(this['isSkillTypeSealed'](_0x205240[_0x4c63c4(0x1f7)]))continue;const _0x5bf79=BattleManager[_0x4c63c4(0x2b2)][0x0],_0x2db36c=$gameTroop[_0x4c63c4(0x299)]()[_0x4c63c4(0x21c)](_0x5bf79);this[_0x4c63c4(0x1af)](_0x284d8f,_0x2db36c),BattleManager[_0x4c63c4(0x1af)](this),$gameTemp[_0x4c63c4(0x24e)](this,_0x205240['id']);Sprite_Actor[_0x4c63c4(0x1a7)]&&(this[_0x4c63c4(0x1be)]=!![]);return;}else{_0x19159a=_0x5da467['toLowerCase']()[_0x4c63c4(0x296)]();switch(_0x137b78){case'2':return _0x4c63c4(0x1dd);case'4':return _0x4c63c4(0x2dd);case'6':return _0x4c63c4(0x25c);case'8':return'up';case's':return'shift';case'z':return'ok';case'x':return _0x4c63c4(0x1ca);case'q':return _0x4c63c4(0x283);case'w':return'pagedown';}return _0x2973d2;}}Sprite_Actor['INPUT_COMBO_REDUCE_BACK_FORTH']&&(this[_0x4c63c4(0x16f)]=![]);},Game_Actor[_0x2b276d(0x1eb)]['clearInputComboSkillQueue']=function(){const _0x5daefd=_0x2b276d;if($gameTemp['_inputComboSkillQueue'][_0x5daefd(0x2d8)]>=0x0)return;$gameTemp[_0x5daefd(0x228)]();},Game_Actor[_0x2b276d(0x1eb)][_0x2b276d(0x2b3)]=function(){const _0x126af2=_0x2b276d,_0xc26f29=Object[_0x126af2(0x1a8)]($gameTemp[_0x126af2(0x1d2)]);if(_0xc26f29[_0x126af2(0x2d8)]>0x0){if(_0x126af2(0x18c)!==_0x126af2(0x18c))this[_0x126af2(0x16f)]=_0x267445['_inputComboSkillQueue'][_0x126af2(0x2d8)]>0x0;else{const _0x102cb7=_0xc26f29[Math[_0x126af2(0x2de)](_0xc26f29[_0x126af2(0x2d8)])],_0x54af50=VisuMZ[_0x126af2(0x2a8)][_0x126af2(0x19e)](_0x102cb7);this['autoQueueInputComboSpecial'](_0x54af50);}}else _0x126af2(0x2bb)!==_0x126af2(0x1ae)?this[_0x126af2(0x2cc)]():_0x229d5a=_0x4fccb2(_0x27d92b);},Game_Actor['prototype'][_0x2b276d(0x2cc)]=function(){const _0x10a679=_0x2b276d,_0x56f4f1=SceneManager[_0x10a679(0x20e)][_0x10a679(0x269)];if(!_0x56f4f1[_0x10a679(0x221)])return;const _0x4c288a=VisuMZ[_0x10a679(0x2a8)][_0x10a679(0x257)]['clone'](),_0x24cf3f=_0x4c288a[_0x10a679(0x17a)](_0x47984b=>$gameTemp[_0x10a679(0x187)](_0x47984b))[_0x10a679(0x17a)](_0x2b524d=>this[_0x10a679(0x1bd)]($dataSkills[$gameTemp[_0x10a679(0x247)](_0x2b524d)]));if(_0x24cf3f[_0x10a679(0x2d8)]>0x0){const _0x383537=_0x24cf3f[Math[_0x10a679(0x2de)](_0x24cf3f[_0x10a679(0x2d8)])];$gameTemp['queueInputComboSkillsFromKey'](_0x383537),setTimeout(this[_0x10a679(0x2cc)]['bind'](this),0xc8);}},Game_Actor[_0x2b276d(0x1eb)][_0x2b276d(0x169)]=function(_0x505811){const _0x17f8df=_0x2b276d,_0x3c6eba=SceneManager[_0x17f8df(0x20e)]['_logWindow'];if(!_0x3c6eba['_inputComboSkillMode'])return;const _0xc5f161=_0x505811[_0x17f8df(0x16d)](),_0x5675e6=$dataSkills[$gameTemp['getInputComboSkillsKey'](_0xc5f161)];this[_0x17f8df(0x1bd)](_0x5675e6)?($gameTemp['queueInputComboSkillsFromKey'](_0xc5f161),setTimeout(this['autoQueueInputComboSpecial'][_0x17f8df(0x2d1)](this,_0x505811),0xc8)):setTimeout(this[_0x17f8df(0x2cc)][_0x17f8df(0x2d1)](this),0xc8);},VisuMZ[_0x2b276d(0x2a8)][_0x2b276d(0x19e)]=function(_0x181f76){const _0x3705ba=_0x2b276d,_0x14ca96=[],_0x23f013=_0x181f76[_0x3705ba(0x1bc)]('');for(const _0x3a1a55 of _0x23f013){if(_0x3705ba(0x1c9)!==_0x3705ba(0x1c9)){const _0x5a44b2=_0x4f4712[this[_0x3705ba(0x1ee)]];_0xd47218[_0x3705ba(0x2ae)](_0x5a44b2);}else{if(_0x3a1a55==='2')_0x14ca96[_0x3705ba(0x1a9)](_0x3705ba(0x1dd));if(_0x3a1a55==='4')_0x14ca96[_0x3705ba(0x1a9)](_0x3705ba(0x2dd));if(_0x3a1a55==='6')_0x14ca96['push'](_0x3705ba(0x25c));if(_0x3a1a55==='8')_0x14ca96[_0x3705ba(0x1a9)]('up');if(_0x3a1a55==='Z')_0x14ca96['push']('ok');if(_0x3a1a55==='X')_0x14ca96[_0x3705ba(0x1a9)](_0x3705ba(0x1ca));if(_0x3a1a55==='Q')_0x14ca96[_0x3705ba(0x1a9)](_0x3705ba(0x283));if(_0x3a1a55==='W')_0x14ca96[_0x3705ba(0x1a9)](_0x3705ba(0x24b));if(_0x3a1a55==='S')_0x14ca96[_0x3705ba(0x1a9)]('shift');}}return _0x14ca96;},VisuMZ[_0x2b276d(0x2a8)][_0x2b276d(0x2d9)]=Scene_Battle['prototype']['createDisplayObjects'],Scene_Battle['prototype'][_0x2b276d(0x249)]=function(){const _0x69f70=_0x2b276d;VisuMZ[_0x69f70(0x2a8)][_0x69f70(0x2d9)][_0x69f70(0x268)](this),this[_0x69f70(0x23c)]();},Scene_Battle[_0x2b276d(0x1eb)][_0x2b276d(0x23c)]=function(){const _0x328eb7=_0x2b276d;this[_0x328eb7(0x1de)](),this[_0x328eb7(0x1b4)](),this[_0x328eb7(0x274)](),this[_0x328eb7(0x203)](),this[_0x328eb7(0x1fb)](),this[_0x328eb7(0x1f9)]();},Scene_Battle['prototype']['createInputComboSkillsUiContainer']=function(){const _0x3aab4c=_0x2b276d;this[_0x3aab4c(0x171)]=new Sprite(),this[_0x3aab4c(0x23d)](this[_0x3aab4c(0x171)]),this[_0x3aab4c(0x171)]['opacity']=0x0;},Scene_Battle['prototype'][_0x2b276d(0x1b4)]=function(){const _0x14fcd6=_0x2b276d,_0x297868=VisuMZ[_0x14fcd6(0x2a8)][_0x14fcd6(0x214)]['UI'];if(_0x297868[_0x14fcd6(0x238)]){if(_0x14fcd6(0x213)!==_0x14fcd6(0x2d6)){const _0x440014=new Sprite();this[_0x14fcd6(0x171)][_0x14fcd6(0x23d)](_0x440014);const _0x1e7d07=new Bitmap(Graphics['width'],Graphics[_0x14fcd6(0x1b3)]);_0x440014[_0x14fcd6(0x182)]=_0x1e7d07;const _0x167403=_0x297868[_0x14fcd6(0x238)];_0x167403[_0x14fcd6(0x268)](_0x440014['bitmap']);}else this['onMouseExit']();}if(_0x297868[_0x14fcd6(0x2ad)]!==''){if(_0x14fcd6(0x27b)===_0x14fcd6(0x244)){if(!_0x4a656e)return _0x1526aa[_0x14fcd6(0x2ca)];if(!_0x2cede7[_0x14fcd6(0x265)](_0x288c83))return _0x398af4[_0x14fcd6(0x2ca)];const _0x1b4443=_0x2be0ba[_0x14fcd6(0x2a8)][_0x14fcd6(0x2d5)],_0x4cc5b4=_0x3bc324['note']||'';if(_0x4cc5b4[_0x14fcd6(0x1e8)](_0x1b4443[_0x14fcd6(0x2e1)]))return _0x1c90a2(_0x247e77['$1']);return _0x464901['INPUT_COMBO_ANIMATION'];}else{const _0x14a2fd=new Sprite();this[_0x14fcd6(0x171)][_0x14fcd6(0x23d)](_0x14a2fd);const _0x41bf6d=ImageManager['loadSystem'](_0x297868[_0x14fcd6(0x2ad)]);_0x14a2fd[_0x14fcd6(0x182)]=_0x41bf6d;}}},Scene_Battle['prototype'][_0x2b276d(0x274)]=function(){const _0x31df7e=_0x2b276d;this[_0x31df7e(0x2a0)]={};const _0x795c04=VisuMZ[_0x31df7e(0x2a8)][_0x31df7e(0x257)][_0x31df7e(0x2a5)]();for(const _0x5002f3 of _0x795c04){const _0x3dc842=new Sprite_InputComboButton(_0x5002f3);this[_0x31df7e(0x171)][_0x31df7e(0x23d)](_0x3dc842),this[_0x31df7e(0x2a0)][_0x5002f3]=_0x3dc842;}},Scene_Battle[_0x2b276d(0x1eb)]['createInputComboSkillsUiQueueList']=function(){const _0x2daed3=_0x2b276d;this[_0x2daed3(0x1aa)]=new Sprite_InputComboQueueList(),this[_0x2daed3(0x23d)](this['_inputComboSkillQueueListSprite']);},Scene_Battle[_0x2b276d(0x1eb)][_0x2b276d(0x1fb)]=function(){const _0x312b8e=_0x2b276d;if(!Imported[_0x312b8e(0x198)])return;if(!Window_InputComboSkillsTooltip['ENABLED'])return;this[_0x312b8e(0x2ac)]=new Window_InputComboSkillsTooltip(),this[_0x312b8e(0x23d)](this[_0x312b8e(0x2ac)]);},Scene_Battle['prototype']['checkInputComboSkillsIncompatibility']=function(){const _0x2decd9=_0x2b276d;if(Imported[_0x2decd9(0x193)]&&VisuMZ[_0x2decd9(0x245)][_0x2decd9(0x2b8)]<1.12){if(_0x2decd9(0x24d)!=='UgDvb'){const _0x5e14c3=_0x2decd9(0x28a);alert(_0x5e14c3),SceneManager[_0x2decd9(0x220)]();}else return;}},VisuMZ[_0x2b276d(0x2a8)]['Scene_Battle_update']=Scene_Battle[_0x2b276d(0x1eb)][_0x2b276d(0x1d5)],Scene_Battle[_0x2b276d(0x1eb)][_0x2b276d(0x1d5)]=function(){const _0x416b44=_0x2b276d;VisuMZ['InputComboSkills']['Scene_Battle_update']['call'](this);if(this[_0x416b44(0x286)]())this[_0x416b44(0x201)]();this[_0x416b44(0x1c8)](),this[_0x416b44(0x2da)]();},Scene_Battle[_0x2b276d(0x1eb)][_0x2b276d(0x201)]=function(){const _0x2de058=_0x2b276d;if($gameTemp[_0x2de058(0x1f6)]()){this['_logWindow'][_0x2de058(0x233)]();return;}const _0x255c16=BattleManager[_0x2de058(0x2cd)],_0x7855c3=VisuMZ[_0x2de058(0x2a8)][_0x2de058(0x257)][_0x2de058(0x2a5)]();if(_0x255c16[_0x2de058(0x267)]())return;for(const _0x2a9391 of _0x7855c3){if(!$gameTemp[_0x2de058(0x187)](_0x2a9391))continue;const _0xdd9936=$dataSkills[$gameTemp[_0x2de058(0x247)](_0x2a9391)];if(!_0xdd9936)continue;if(!_0x255c16[_0x2de058(0x1bd)](_0xdd9936))continue;if(!Input[_0x2de058(0x264)](_0x2a9391))continue;this[_0x2de058(0x2a0)][_0x2a9391][_0x2de058(0x24f)]=0x4,$gameTemp[_0x2de058(0x1ac)](_0x2a9391);break;}},Scene_Battle['prototype'][_0x2b276d(0x286)]=function(){return this['_logWindow']&&this['_logWindow']['_inputComboSkillMode'];},Scene_Battle[_0x2b276d(0x1eb)][_0x2b276d(0x1c8)]=function(){const _0x16c9ab=_0x2b276d,_0x352f26=VisuMZ[_0x16c9ab(0x2a8)][_0x16c9ab(0x214)]['UI'],_0xefc438=this[_0x16c9ab(0x286)]();if(this['_inputComboSkillsUiContainer']){const _0x419de2=_0x352f26[_0x16c9ab(0x2ce)]*(_0xefc438?0x1:-0x1);this[_0x16c9ab(0x171)][_0x16c9ab(0x166)]+=_0x419de2;}},Scene_Battle['prototype'][_0x2b276d(0x2da)]=function(){const _0x5986b5=_0x2b276d;if(!BattleManager['_subject'])return;if(!BattleManager[_0x5986b5(0x2cd)][_0x5986b5(0x199)]())return;if(!BattleManager[_0x5986b5(0x2cd)][_0x5986b5(0x295)])return;BattleManager[_0x5986b5(0x2cd)][_0x5986b5(0x295)]=undefined,BattleManager['_subject'][_0x5986b5(0x2d4)]();},Sprite_Actor[_0x2b276d(0x1a7)]=VisuMZ[_0x2b276d(0x2a8)]['Settings'][_0x2b276d(0x1b2)]??!![],VisuMZ[_0x2b276d(0x2a8)][_0x2b276d(0x1cc)]=Sprite_Actor[_0x2b276d(0x1eb)]['stepForward'],Sprite_Actor[_0x2b276d(0x1eb)][_0x2b276d(0x1b7)]=function(){const _0x1209a7=_0x2b276d;if(Sprite_Actor[_0x1209a7(0x1a7)]&&this['_battler']){if(this['_battler'][_0x1209a7(0x1be)]){if(_0x1209a7(0x194)==='LBcta'){_0x3cf745['InputComboSkills'][_0x1209a7(0x26a)][_0x1209a7(0x268)](this);if(this[_0x1209a7(0x286)]())this[_0x1209a7(0x201)]();this[_0x1209a7(0x1c8)](),this[_0x1209a7(0x2da)]();}else return;}}VisuMZ[_0x1209a7(0x2a8)][_0x1209a7(0x1cc)][_0x1209a7(0x268)](this);},VisuMZ[_0x2b276d(0x2a8)]['Sprite_Actor_stepBack']=Sprite_Actor[_0x2b276d(0x1eb)]['stepBack'],Sprite_Actor[_0x2b276d(0x1eb)][_0x2b276d(0x181)]=function(){const _0x2f0462=_0x2b276d;if(Sprite_Actor[_0x2f0462(0x1a7)]&&this[_0x2f0462(0x1d4)]){if(this['_battler'][_0x2f0462(0x16f)]){if(_0x2f0462(0x183)===_0x2f0462(0x22a)){if(_0x1549da[_0x2f0462(0x253)]!==this)return;this['forceActionInputComboSkill'](),_0x4f2297[_0x2f0462(0x2db)](this),this[_0x2f0462(0x2c4)]();}else return;}}VisuMZ[_0x2f0462(0x2a8)][_0x2f0462(0x2d0)][_0x2f0462(0x268)](this);},VisuMZ['InputComboSkills'][_0x2b276d(0x260)]=BattleManager['endAction'],BattleManager[_0x2b276d(0x2b5)]=function(){const _0x545adb=_0x2b276d;Sprite_Actor[_0x545adb(0x1a7)]&&this[_0x545adb(0x2cd)]&&this[_0x545adb(0x2cd)][_0x545adb(0x199)]()&&(this[_0x545adb(0x2cd)][_0x545adb(0x1be)]=this[_0x545adb(0x2cd)][_0x545adb(0x16f)],this[_0x545adb(0x2cd)]['_bypassStepBackward_InputComboSkill']=![]),VisuMZ[_0x545adb(0x2a8)][_0x545adb(0x260)][_0x545adb(0x268)](this);};function Sprite_InputComboButton(){this['initialize'](...arguments);}Sprite_InputComboButton[_0x2b276d(0x1eb)]=Object[_0x2b276d(0x1d3)](Sprite_Clickable[_0x2b276d(0x1eb)]),Sprite_InputComboButton[_0x2b276d(0x1eb)]['constructor']=Sprite_InputComboButton,Sprite_InputComboButton[_0x2b276d(0x27e)]=VisuMZ[_0x2b276d(0x2a8)][_0x2b276d(0x214)]['UI']['KeypressUiOffsetX']??-0x4,Sprite_InputComboButton['KEY_PRESS_OFFSET_Y']=VisuMZ[_0x2b276d(0x2a8)][_0x2b276d(0x214)]['UI'][_0x2b276d(0x26e)]??+0x4,Sprite_InputComboButton[_0x2b276d(0x1eb)]['initialize']=function(_0x331ce8){const _0x245046=_0x2b276d;this[_0x245046(0x1ff)]=_0x331ce8,Sprite_Clickable[_0x245046(0x1eb)][_0x245046(0x1c3)][_0x245046(0x268)](this),this[_0x245046(0x25d)](),this['debugFillRect'](),this['createBackgroundSprite'](),this[_0x245046(0x1e9)](),this['createContentWindow']();},Sprite_InputComboButton['prototype'][_0x2b276d(0x25d)]=function(){const _0x2cbf2e=_0x2b276d,_0x46e675=VisuMZ[_0x2cbf2e(0x2a8)]['Settings']['UI'],_0xa10a46=_0x2cbf2e(0x1f4)[_0x2cbf2e(0x2aa)](this['_key']);if(_0x46e675[_0xa10a46])this[_0x2cbf2e(0x1f2)]=_0x46e675[_0xa10a46]();else{if('wKDVs'===_0x2cbf2e(0x1b1))this['_dimensions']=new Rectangle(0x0,0x0,0x0,0x0);else{const _0x14a895=this['getInputComboSkillsUser'](),_0x4a45a2=this[_0x2cbf2e(0x246)][this[_0x2cbf2e(0x246)]['length']-0x1],_0x3dab66=_0x41ca25[_0x4a45a2];_0x14a895['paySkillCost'](_0x3dab66);}}this['x']=this['_dimensions']['x']+(_0x46e675[_0x2cbf2e(0x29a)]||0x0),this['y']=this['_dimensions']['y']+(_0x46e675[_0x2cbf2e(0x24a)]||0x0),this[_0x2cbf2e(0x25e)]['x']=0.5,this[_0x2cbf2e(0x25e)]['y']=0.5,this[_0x2cbf2e(0x2c5)]['x']=_0x46e675[_0x2cbf2e(0x289)],this[_0x2cbf2e(0x2c5)]['y']=_0x46e675['Scale'],this['opacity']=0x0,this['_lastActor']=null,this[_0x2cbf2e(0x1ee)]=null,this['_lastInputType']=null;},Sprite_InputComboButton[_0x2b276d(0x1eb)][_0x2b276d(0x1f8)]=function(){const _0x239495=_0x2b276d,_0x5b8100=![],_0x2b12ed=_0x5b8100?_0x239495(0x1e1):ColorManager['dimColor2']();this[_0x239495(0x182)]=new Bitmap(this[_0x239495(0x1f2)]['width'],this[_0x239495(0x1f2)][_0x239495(0x1b3)]),this[_0x239495(0x182)][_0x239495(0x1f3)](0x0,0x0,this[_0x239495(0x182)][_0x239495(0x217)],this[_0x239495(0x182)][_0x239495(0x1b3)],_0x2b12ed);},Sprite_InputComboButton[_0x2b276d(0x1eb)]['createBackgroundSprite']=function(){const _0x4d7804=_0x2b276d,_0x1b7807=VisuMZ[_0x4d7804(0x2a8)][_0x4d7804(0x214)]['UI'],_0x7b2716=_0x1b7807[_0x4d7804(0x204)[_0x4d7804(0x2aa)](this[_0x4d7804(0x1ff)])];if(!_0x7b2716)return;const _0x2da25e=new Sprite();this[_0x4d7804(0x23d)](_0x2da25e),_0x2da25e['bitmap']=ImageManager['loadSystem'](_0x7b2716),_0x2da25e[_0x4d7804(0x25e)]['x']=0.5,_0x2da25e[_0x4d7804(0x25e)]['y']=0.5,_0x2da25e['scale']['x']=0x1/(this[_0x4d7804(0x2c5)]['x']||0.01),_0x2da25e[_0x4d7804(0x2c5)]['y']=0x1/(this[_0x4d7804(0x2c5)]['y']||0.01);},Sprite_InputComboButton[_0x2b276d(0x1eb)][_0x2b276d(0x1e9)]=function(){const _0x148606=_0x2b276d;this[_0x148606(0x1d7)]=new Sprite(),this['addChild'](this['_contentSprite']),this[_0x148606(0x1d7)][_0x148606(0x25e)]['x']=0.5,this[_0x148606(0x1d7)][_0x148606(0x25e)]['y']=0.5;},Sprite_InputComboButton[_0x2b276d(0x1eb)][_0x2b276d(0x170)]=function(){const _0x1b570d=_0x2b276d,_0x5a963d=$gameSystem[_0x1b570d(0x18a)](),_0x437a1e=this[_0x1b570d(0x1f2)]['width']+_0x5a963d*0x2,_0x29f6b6=this['_dimensions']['height']+_0x5a963d*0x2,_0x414528=new Rectangle(0x0,0x0,_0x437a1e,_0x29f6b6);this[_0x1b570d(0x222)]=new Window_Base(_0x414528);},Sprite_InputComboButton[_0x2b276d(0x1eb)][_0x2b276d(0x1d5)]=function(){const _0x8561fe=_0x2b276d;Sprite_Clickable[_0x8561fe(0x1eb)][_0x8561fe(0x1d5)]['call'](this),this['updateOpacity'](),this[_0x8561fe(0x1d1)]();if(this[_0x8561fe(0x202)]())this[_0x8561fe(0x281)]();},Sprite_InputComboButton[_0x2b276d(0x1eb)][_0x2b276d(0x24c)]=function(){const _0x326e46=_0x2b276d;this[_0x326e46(0x166)]=this[_0x326e46(0x21b)]();},Sprite_InputComboButton[_0x2b276d(0x1eb)][_0x2b276d(0x21b)]=function(){const _0x3bb9e5=_0x2b276d;if(!$gameTemp[_0x3bb9e5(0x187)](this[_0x3bb9e5(0x1ff)]))return 0x0;const _0x54bcee=VisuMZ[_0x3bb9e5(0x2a8)][_0x3bb9e5(0x214)]['UI']['OpacityDisable'],_0x1dabaa=$gameTemp['getInputComboSkillsKey'](this[_0x3bb9e5(0x1ff)]);if(_0x1dabaa===null)return _0x54bcee;const _0xeec55d=BattleManager['_subject'];if(!_0xeec55d)return _0x54bcee;const _0x30afbd=$dataSkills[_0x1dabaa];if(!_0xeec55d['canUse'](_0x30afbd))return _0x54bcee;return 0xff;},Sprite_InputComboButton[_0x2b276d(0x1eb)][_0x2b276d(0x1d1)]=function(){const _0x1981a2=_0x2b276d,_0x5282be=VisuMZ['InputComboSkills'][_0x1981a2(0x214)]['UI'];this['x']=this['_dimensions']['x']+(_0x5282be[_0x1981a2(0x29a)]||0x0),this['y']=this[_0x1981a2(0x1f2)]['y']+(_0x5282be['KeybindUiOffsetY']||0x0),this['_pressed']&&(this['_pressedDuration']=0x4),this['_pressedDuration']-->0x0&&(this['x']+=Sprite_InputComboButton[_0x1981a2(0x27e)],this['y']+=Sprite_InputComboButton['KEY_PRESS_OFFSET_Y']);},Sprite_InputComboButton[_0x2b276d(0x1eb)][_0x2b276d(0x281)]=function(){const _0x2b2436=_0x2b276d;this[_0x2b2436(0x2a4)]=BattleManager['_subject'],this[_0x2b2436(0x1ee)]=$gameTemp['getInputComboSkillsKey'](this[_0x2b2436(0x1ff)]),Imported['VisuMZ_0_CoreEngine']&&Input[_0x2b2436(0x23b)]&&(this[_0x2b2436(0x1e4)]=Input[_0x2b2436(0x23b)]()),this[_0x2b2436(0x219)]();},Sprite_InputComboButton[_0x2b276d(0x1eb)]['meetsUpdateBitmapConditions']=function(){const _0x5409b0=_0x2b276d;if(this[_0x5409b0(0x2a4)]!==BattleManager[_0x5409b0(0x2cd)])return!![];if(this[_0x5409b0(0x1ee)]!==$gameTemp[_0x5409b0(0x247)](this[_0x5409b0(0x1ff)]))return!![];if(Imported[_0x5409b0(0x278)]&&Input[_0x5409b0(0x23b)]){if(this[_0x5409b0(0x1e4)]!==Input[_0x5409b0(0x23b)]())return!![];}return![];},Sprite_InputComboButton[_0x2b276d(0x1eb)][_0x2b276d(0x219)]=function(){const _0x363fee=_0x2b276d,_0x5d2e5a=VisuMZ[_0x363fee(0x2a8)][_0x363fee(0x214)]['UI'],_0x368712=this['_contentWindow']['contents'],_0x3e4583=$dataSkills[this[_0x363fee(0x1ee)]];if(!_0x3e4583)return;if(!BattleManager[_0x363fee(0x2cd)])return;_0x368712[_0x363fee(0x1a4)](),this[_0x363fee(0x222)][_0x363fee(0x25a)]();const _0x142c2b=this['getButtonIcon'](),_0x5e7708=BattleManager[_0x363fee(0x2cd)],_0x50fc36=this[_0x363fee(0x222)][_0x363fee(0x23a)](_0x5e7708,_0x3e4583);_0x5d2e5a[_0x363fee(0x1a1)]['call'](this['_contentWindow'],_0x3e4583,_0x142c2b,_0x50fc36),this[_0x363fee(0x1d7)][_0x363fee(0x182)]=_0x368712;},Sprite_InputComboButton[_0x2b276d(0x1eb)][_0x2b276d(0x23e)]=function(){const _0x196ae8=_0x2b276d,_0x38dfe6=VisuMZ[_0x196ae8(0x2a8)][_0x196ae8(0x214)]['UI'],_0x5cec7b=_0x196ae8(0x276)[_0x196ae8(0x2aa)](this[_0x196ae8(0x1ff)]);if(_0x38dfe6[_0x5cec7b])return _0x38dfe6[_0x5cec7b];if(Imported[_0x196ae8(0x278)]){const _0x3c3121=TextManager[_0x196ae8(0x1e7)](this[_0x196ae8(0x1ff)]);if(_0x3c3121&&_0x3c3121[_0x196ae8(0x1e8)](/\\I\[(\d+)\]/i))return Number(RegExp['$1']);}return 0x0;},Sprite_InputComboButton[_0x2b276d(0x1eb)]['onClick']=function(){const _0x239d04=_0x2b276d;Sprite_Clickable[_0x239d04(0x1eb)]['onClick'][_0x239d04(0x268)](this);const _0x5b55a4=$dataSkills[$gameTemp[_0x239d04(0x247)](this[_0x239d04(0x1ff)])];BattleManager[_0x239d04(0x2cd)]&&_0x5b55a4&&$gameTemp[_0x239d04(0x1ac)](this['_key']);const _0xfe083c=this['tooltipWindow']();_0xfe083c&&(_0x239d04(0x2d2)!==_0x239d04(0x2e2)?_0xfe083c[_0x239d04(0x2ae)](null):(this[_0x239d04(0x19a)]=!![],this[_0x239d04(0x20a)]()));},Sprite_InputComboButton[_0x2b276d(0x1eb)]['isClickEnabled']=function(){const _0x4948c8=_0x2b276d;if(this[_0x4948c8(0x166)]<=0x0)return![];const _0x58cf67=SceneManager[_0x4948c8(0x20e)];if(!_0x58cf67)return![];if(!_0x58cf67[_0x4948c8(0x286)])return![];if(!_0x58cf67[_0x4948c8(0x286)]())return![];if(!$gameTemp['hasInputComboSkillsKey'](this[_0x4948c8(0x1ff)]))return![];const _0x54148e=$dataSkills[$gameTemp[_0x4948c8(0x247)](this['_key'])];if(!_0x54148e)return![];if(!BattleManager['_subject']['canUse'](_0x54148e))return![];return Sprite_Clickable[_0x4948c8(0x1eb)]['isClickEnabled']['call'](this);},Sprite_InputComboButton[_0x2b276d(0x1eb)][_0x2b276d(0x209)]=function(){const _0x14d40a=_0x2b276d;return SceneManager[_0x14d40a(0x20e)][_0x14d40a(0x2ac)];},Sprite_InputComboButton['prototype'][_0x2b276d(0x1d6)]=function(){const _0x3980ba=_0x2b276d;Sprite_Clickable['prototype'][_0x3980ba(0x1d6)]['call'](this);const _0x35bd76=this[_0x3980ba(0x209)]();if(!_0x35bd76)return;const _0x2fb6a8=SceneManager[_0x3980ba(0x20e)],_0x230591=_0x2fb6a8&&_0x2fb6a8['canPerformInputComboSkills']?_0x2fb6a8['canPerformInputComboSkills']():![];if(_0x35bd76&&_0x230591){const _0x48d175=$dataSkills[this[_0x3980ba(0x1ee)]];_0x35bd76[_0x3980ba(0x2ae)](_0x48d175);}},Sprite_InputComboButton[_0x2b276d(0x1eb)][_0x2b276d(0x178)]=function(){const _0x16c689=_0x2b276d;Sprite_Clickable['prototype'][_0x16c689(0x178)][_0x16c689(0x268)](this);const _0x5d8c83=this[_0x16c689(0x209)]();if(!_0x5d8c83)return;const _0x544d72=$dataSkills[this['_lastSkillID']],_0x5c273e=SceneManager[_0x16c689(0x20e)],_0x51b6a3=_0x5c273e&&_0x5c273e[_0x16c689(0x286)]?_0x5c273e[_0x16c689(0x286)]():![];if(!_0x51b6a3||_0x5d8c83&&_0x5d8c83[_0x16c689(0x1dc)]===_0x544d72){if('aqQhM'!==_0x16c689(0x1fa))_0x5d8c83[_0x16c689(0x2ae)](null);else{const _0x175f10=_0x1692ae['keys'](_0xb06f81['_inputComboSkillSpecials']);if(_0x175f10[_0x16c689(0x2d8)]>0x0){const _0x2d5879=_0x175f10[_0x2f1b74['randomInt'](_0x175f10['length'])],_0x1c872b=_0x1ebfd9['InputComboSkills'][_0x16c689(0x19e)](_0x2d5879);this['autoQueueInputComboSpecial'](_0x1c872b);}else this['autoQueueRandomInputComboSkills']();}}},Sprite_InputComboButton[_0x2b276d(0x1eb)][_0x2b276d(0x2a6)]=function(){const _0x1eb4a9=_0x2b276d,_0xb750c9=this['_hoverState'];this[_0x1eb4a9(0x2be)]=this[_0x1eb4a9(0x16e)]();if(this[_0x1eb4a9(0x2be)]!==_0xb750c9){if(this['_hoverState']){if(_0x1eb4a9(0x1cd)!=='bRuKX')this[_0x1eb4a9(0x1d6)]();else{if(this['_inputComboSkillCostBypass']===_0x5a6265)this[_0x1eb4a9(0x176)]();return this[_0x1eb4a9(0x205)][_0x1eb4a9(0x2c8)]===_0xe6cf1b&&this[_0x1eb4a9(0x205)]['skillID']===_0x5c1f39;}}else _0x1eb4a9(0x173)!==_0x1eb4a9(0x173)?this[_0x1eb4a9(0x1d6)]():this[_0x1eb4a9(0x178)]();}if(this[_0x1eb4a9(0x21a)]()){if(_0x1eb4a9(0x26f)===_0x1eb4a9(0x26f)){if(this['isBeingTouched']()){if(TouchInput[_0x1eb4a9(0x264)]()){if(_0x1eb4a9(0x25f)!=='QQvpi'){if(!_0x4ecf11)return![];const _0x599563=_0x53f16a['InputComboSkills'][_0x1eb4a9(0x2d5)],_0x13afb4=_0x5c052e[_0x1eb4a9(0x19d)]||'';if(_0x13afb4['match'](_0x599563[_0x1eb4a9(0x2ab)])){if(!this[_0x1eb4a9(0x199)]())return![];if(!_0x53d0eb[_0x1eb4a9(0x280)]())return![];const _0x1922b1=_0x2835f7['_scene']['_logWindow'];if(_0x1922b1&&!_0x1922b1[_0x1eb4a9(0x221)])return![];return this[_0x1eb4a9(0x189)];}return!![];}else this[_0x1eb4a9(0x19a)]=!![],this[_0x1eb4a9(0x20a)]();}}else{if(_0x1eb4a9(0x223)===_0x1eb4a9(0x291)){this[_0x1eb4a9(0x28d)]();const _0x2352a6=this['baseTextRect']();this[_0x1eb4a9(0x2a7)](this[_0x1eb4a9(0x27c)],_0x2352a6['x'],_0x2352a6['y'],_0x2352a6['width']),this['show']();}else this[_0x1eb4a9(0x19a)]=![],this[_0x1eb4a9(0x2b0)]=![];}if(this['_pressed']&&TouchInput[_0x1eb4a9(0x168)]()){if(_0x1eb4a9(0x18d)!=='ShueE')this['_pressed']=![],this[_0x1eb4a9(0x16b)]();else{const _0x5cf4bd=_0x5db916[_0x1eb4a9(0x20e)][_0x1eb4a9(0x269)];if(!_0x5cf4bd[_0x1eb4a9(0x221)])return;const _0x30935f=_0x391f7a[_0x1eb4a9(0x2a8)][_0x1eb4a9(0x257)][_0x1eb4a9(0x2a5)](),_0x3f4d29=_0x30935f[_0x1eb4a9(0x17a)](_0x12fca4=>_0x4e0fe6[_0x1eb4a9(0x187)](_0x12fca4))[_0x1eb4a9(0x17a)](_0x5c3c83=>this[_0x1eb4a9(0x1bd)](_0x56ce45[_0x39b1ee[_0x1eb4a9(0x247)](_0x5c3c83)]));if(_0x3f4d29[_0x1eb4a9(0x2d8)]>0x0){const _0x59421b=_0x3f4d29[_0x14168a[_0x1eb4a9(0x2de)](_0x3f4d29[_0x1eb4a9(0x2d8)])];_0x2b177c[_0x1eb4a9(0x1ac)](_0x59421b),_0x145d9a(this[_0x1eb4a9(0x2cc)][_0x1eb4a9(0x2d1)](this),0xc8);}}}}else this['_inputComboSkillUser']=_0x481ca6;}else this['_pressed']=![],this[_0x1eb4a9(0x2b0)]=![];},Sprite_InputComboButton[_0x2b276d(0x1eb)][_0x2b276d(0x16e)]=function(){const _0x5c3a85=_0x2b276d,_0x3dbf81=new Point(TouchInput['x'],TouchInput['y']),_0x349710=this['worldTransform']['applyInverse'](_0x3dbf81);return this[_0x5c3a85(0x2cb)](_0x349710['x'],_0x349710['y']);};function Sprite_InputComboQueueList(){const _0x4efcf8=_0x2b276d;this[_0x4efcf8(0x1c3)](...arguments);}Sprite_InputComboQueueList[_0x2b276d(0x1eb)]=Object[_0x2b276d(0x1d3)](Sprite[_0x2b276d(0x1eb)]),Sprite_InputComboQueueList[_0x2b276d(0x1eb)][_0x2b276d(0x16c)]=Sprite_InputComboQueueList,Sprite_InputComboQueueList[_0x2b276d(0x1eb)]['initialize']=function(){const _0x19c19e=_0x2b276d;Sprite['prototype'][_0x19c19e(0x1c3)][_0x19c19e(0x268)](this),this['initMembers'](),this[_0x19c19e(0x180)](),this[_0x19c19e(0x1e9)](),this[_0x19c19e(0x170)]();},Sprite_InputComboQueueList[_0x2b276d(0x1eb)]['initMembers']=function(){const _0x4e432a=_0x2b276d,_0x3ead3d=VisuMZ[_0x4e432a(0x2a8)][_0x4e432a(0x214)]['UI'];this['_dimensions']=_0x3ead3d[_0x4e432a(0x273)](),this['x']=this[_0x4e432a(0x1f2)]['x'],this['y']=this[_0x4e432a(0x1f2)]['y'],this['anchor']['x']=0.5,this[_0x4e432a(0x25e)]['y']=0.5,this['_cacheQueue']=[],this['_cacheSpecialSkillID']=0x0,this[_0x4e432a(0x2bc)]=0x0,this[_0x4e432a(0x1bf)]=0x0,this[_0x4e432a(0x166)]=0x0;},Sprite_InputComboQueueList[_0x2b276d(0x1eb)][_0x2b276d(0x180)]=function(){const _0xbe8b95=_0x2b276d,_0x46998b=VisuMZ[_0xbe8b95(0x2a8)][_0xbe8b95(0x214)]['UI'],_0x26d7f3=_0x46998b[_0xbe8b95(0x2a2)]||'';if(!_0x26d7f3)return;const _0x496ac1=new Sprite();this[_0xbe8b95(0x23d)](_0x496ac1),_0x496ac1['bitmap']=ImageManager['loadSystem'](_0x26d7f3),_0x496ac1['anchor']['x']=0.5,_0x496ac1[_0xbe8b95(0x25e)]['y']=0.5,_0x496ac1[_0xbe8b95(0x2c5)]['x']=0x1/(this[_0xbe8b95(0x2c5)]['x']||0.01),_0x496ac1['scale']['y']=0x1/(this[_0xbe8b95(0x2c5)]['y']||0.01);},Sprite_InputComboQueueList['prototype'][_0x2b276d(0x1e9)]=function(){const _0x4673c0=_0x2b276d;this[_0x4673c0(0x1d7)]=new Sprite(),this[_0x4673c0(0x23d)](this[_0x4673c0(0x1d7)]),this[_0x4673c0(0x1d7)][_0x4673c0(0x25e)]['x']=0.5,this[_0x4673c0(0x1d7)][_0x4673c0(0x25e)]['y']=0.5;},Sprite_InputComboQueueList[_0x2b276d(0x1eb)][_0x2b276d(0x170)]=function(){const _0x367e1c=_0x2b276d,_0xeaa17e=$gameSystem['windowPadding'](),_0x3411c4=this[_0x367e1c(0x1f2)][_0x367e1c(0x217)]+_0xeaa17e*0x2,_0x5e24c8=this[_0x367e1c(0x1f2)]['height']+_0xeaa17e*0x2,_0x545174=new Rectangle(0x0,0x0,_0x3411c4,_0x5e24c8);this[_0x367e1c(0x222)]=new Window_Base(_0x545174);},Sprite_InputComboQueueList['prototype'][_0x2b276d(0x1d5)]=function(){const _0x4d94ad=_0x2b276d;Sprite[_0x4d94ad(0x1eb)][_0x4d94ad(0x1d5)][_0x4d94ad(0x268)](this),this[_0x4d94ad(0x24c)]();if(this['meetsUpdateBitmapConditions']())this['updateBitmap']();},Sprite_InputComboQueueList[_0x2b276d(0x1eb)][_0x2b276d(0x24c)]=function(){const _0x42d841=_0x2b276d,_0x2e98ac=VisuMZ['InputComboSkills'][_0x42d841(0x214)]['UI'][_0x42d841(0x2ce)];this[_0x42d841(0x166)]+=(this[_0x42d841(0x29e)]()?0x1:-0x1)*_0x2e98ac;},Sprite_InputComboQueueList[_0x2b276d(0x1eb)][_0x2b276d(0x29e)]=function(){const _0x47650e=_0x2b276d,_0x288531=SceneManager['_scene'][_0x47650e(0x269)];return _0x288531&&_0x288531[_0x47650e(0x221)]&&(this[_0x47650e(0x1bf)]=0x3c),this[_0x47650e(0x1bf)]-->=0x0;},Sprite_InputComboQueueList['prototype'][_0x2b276d(0x281)]=function(){const _0x275a72=_0x2b276d;this['_cacheQueue']=$gameTemp[_0x275a72(0x246)][_0x275a72(0x2a5)](),this[_0x275a72(0x1e6)]=$gameTemp[_0x275a72(0x1c1)],this[_0x275a72(0x2bc)]=$gameTemp[_0x275a72(0x27f)],this[_0x275a72(0x219)]();},Sprite_InputComboQueueList[_0x2b276d(0x1eb)][_0x2b276d(0x202)]=function(){const _0x318913=_0x2b276d,_0x14db1e=SceneManager[_0x318913(0x20e)][_0x318913(0x269)];if(_0x14db1e&&_0x14db1e[_0x318913(0x221)]){if(JSON['stringify'](this[_0x318913(0x210)])!==JSON['stringify']($gameTemp[_0x318913(0x246)]))return!![];if(this['_cacheSpecialSkillID']!==$gameTemp[_0x318913(0x1c1)])return!![];if(this[_0x318913(0x2bc)]!==$gameTemp[_0x318913(0x27f)])return!![];}return![];},Sprite_InputComboQueueList[_0x2b276d(0x1eb)][_0x2b276d(0x219)]=function(){const _0x4bb756=_0x2b276d,_0x1f6e42=VisuMZ['InputComboSkills'][_0x4bb756(0x214)]['UI'],_0x7997bf=this[_0x4bb756(0x222)][_0x4bb756(0x1ba)];_0x7997bf[_0x4bb756(0x1a4)](),this[_0x4bb756(0x222)]['resetFontSettings']();const _0x2a2254=this[_0x4bb756(0x210)][_0x4bb756(0x19b)](_0x25c7c6=>$dataSkills[_0x25c7c6])[_0x4bb756(0x1df)](null)[_0x4bb756(0x1df)](undefined),_0x1a182c=$dataSkills[this[_0x4bb756(0x1e6)]];if(_0x1a182c)_0x2a2254[_0x4bb756(0x2dc)]();const _0x319dfe=this[_0x4bb756(0x2bc)],_0x1e4c7b=_0x1f6e42[_0x4bb756(0x243)];Sprite_InputComboQueueList[_0x4bb756(0x1eb)][_0x4bb756(0x28f)][_0x4bb756(0x268)](this[_0x4bb756(0x222)],_0x2a2254,_0x1a182c,_0x319dfe,_0x1e4c7b),this[_0x4bb756(0x1d7)]['bitmap']=_0x7997bf;},Sprite_InputComboQueueList['prototype'][_0x2b276d(0x28f)]=function(){const _0x3819c0=_0x2b276d,_0x2df4ad=arguments[0x0],_0xde34b8=arguments[0x1],_0x17ae36=arguments[0x2],_0x250b92=arguments[0x3],_0x47adcd=this['contents'],_0x2b9233=this[_0x3819c0(0x17d)](),_0x2753fc=ImageManager[_0x3819c0(0x1fc)]*0x2;if(_0x250b92){if(_0x3819c0(0x234)!==_0x3819c0(0x234)){if(!_0x2f8aeb[_0x3819c0(0x277)]())return;if(this[_0x3819c0(0x167)]()!==_0x5b0153[_0x3819c0(0x253)]){_0x383430['clearInputComboSkills']();return;}this[_0x3819c0(0x167)]()[_0x3819c0(0x295)]=!![];}else{const _0x165b42=0x14,_0x437884=ColorManager['dimColor1']();_0x47adcd[_0x3819c0(0x1c5)](0x0,0x0,_0x47adcd[_0x3819c0(0x217)],_0x47adcd[_0x3819c0(0x1b3)],_0x165b42,_0x437884);}}const _0x54cd06=_0x17ae36*_0x2753fc,_0x4f2cc5=_0x2753fc,_0x44007f=Math['floor']((_0x47adcd['width']-_0x54cd06)/0x2),_0x313805=Math[_0x3819c0(0x175)](_0x2b9233/0x4);let _0x306801=Math[_0x3819c0(0x175)](_0x2753fc/0x2);for(const _0x8fab3d of _0x2df4ad){const _0x5db032=_0x8fab3d['iconIndex'];this[_0x3819c0(0x29c)](_0x5db032,_0x44007f+_0x306801,_0x313805,_0x2753fc),_0x306801+=_0x2753fc;}if(_0xde34b8){if(_0x3819c0(0x197)===_0x3819c0(0x197)){const _0x159770=_0x3819c0(0x229)[_0x3819c0(0x2aa)](_0xde34b8[_0x3819c0(0x1cf)],_0xde34b8[_0x3819c0(0x2c9)]),_0xe00805=this['textSizeEx'](_0x159770)[_0x3819c0(0x217)],_0x22d7de=Math['floor']((_0x47adcd[_0x3819c0(0x217)]-_0xe00805)/0x2),_0x526530=_0x313805+_0x4f2cc5+Math[_0x3819c0(0x175)](_0x2b9233/0x2);this[_0x3819c0(0x2a7)](_0x159770,_0x22d7de,_0x526530);}else this[_0x3819c0(0x22c)]();}},Window_Base[_0x2b276d(0x1eb)][_0x2b276d(0x29c)]=function(_0xe30748,_0x43b238,_0x30aec8,_0x1e80ac){const _0x1e7e14=_0x2b276d,_0x267bac=VisuMZ[_0x1e7e14(0x2a8)][_0x1e7e14(0x214)]['UI'];_0x1e80ac=_0x1e80ac||0x20,_0x43b238-=Math[_0x1e7e14(0x226)](_0x1e80ac/0x2);const _0x589791=ImageManager[_0x1e7e14(0x263)](_0x1e7e14(0x200)),_0x3f4eec=ImageManager[_0x1e7e14(0x1fc)],_0x831d42=ImageManager[_0x1e7e14(0x1ef)],_0x5df001=_0xe30748%0x10*_0x3f4eec,_0x416875=Math[_0x1e7e14(0x175)](_0xe30748/0x10)*_0x831d42;this[_0x1e7e14(0x1ba)][_0x1e7e14(0x2e0)][_0x1e7e14(0x17f)]=_0x267bac['LargeIconSmoothing'],this['contents'][_0x1e7e14(0x1f0)](_0x589791,_0x5df001,_0x416875,_0x3f4eec,_0x831d42,_0x43b238,_0x30aec8,_0x1e80ac,_0x1e80ac),this[_0x1e7e14(0x1ba)][_0x1e7e14(0x2e0)][_0x1e7e14(0x17f)]=!![];},Window_BattleLog[_0x2b276d(0x232)]=VisuMZ['InputComboSkills'][_0x2b276d(0x214)]['UI'][_0x2b276d(0x27d)]||'',Window_BattleLog[_0x2b276d(0x2ca)]=VisuMZ[_0x2b276d(0x2a8)][_0x2b276d(0x214)]['UI'][_0x2b276d(0x2c1)]||0x0,VisuMZ[_0x2b276d(0x2a8)]['Window_BattleLog_isBusy']=Window_BattleLog[_0x2b276d(0x1eb)]['isBusy'],Window_BattleLog['prototype'][_0x2b276d(0x1a2)]=function(){const _0x55a087=_0x2b276d;if(this[_0x55a087(0x221)])return!![];return VisuMZ[_0x55a087(0x2a8)]['Window_BattleLog_isBusy'][_0x55a087(0x268)](this);},VisuMZ[_0x2b276d(0x2a8)][_0x2b276d(0x272)]=Window_BattleLog[_0x2b276d(0x1eb)]['startAction'],Window_BattleLog['prototype'][_0x2b276d(0x1fd)]=function(_0x17bc7e,_0x3afa0c,_0x19bcd4){const _0x5305fb=_0x2b276d;if(this['canStartInputComboSkill'](_0x17bc7e,_0x3afa0c)){if(_0x5305fb(0x179)!==_0x5305fb(0x179)){let _0xcd9cde=0xff;if(_0x366577['x']<=0x0)_0xcd9cde=0x0;if(_0x9d8933['x']>=_0x33b5d1[_0x5305fb(0x217)])_0xcd9cde=0x0;if(_0x27cfcc['y']<=0x0)_0xcd9cde=0x0;if(_0x474f7b['y']>=_0x25a406[_0x5305fb(0x1b3)])_0xcd9cde=0x0;this['opacity']=_0xcd9cde;}else{this[_0x5305fb(0x22d)](_0x17bc7e,_0x3afa0c);if(_0x17bc7e[_0x5305fb(0x267)]())_0x17bc7e['queueAutoBattleInputComboSkills']();}}else{if(_0x5305fb(0x279)===_0x5305fb(0x1ea)){_0x5b63f4['prototype'][_0x5305fb(0x1d5)][_0x5305fb(0x268)](this),this['updateOpacity']();if(this[_0x5305fb(0x202)]())this['updateBitmap']();}else VisuMZ[_0x5305fb(0x2a8)][_0x5305fb(0x272)]['call'](this,_0x17bc7e,_0x3afa0c,_0x19bcd4);}},Window_BattleLog[_0x2b276d(0x1eb)][_0x2b276d(0x191)]=function(_0x35da42,_0x440011){const _0x57d0df=_0x2b276d;if(!_0x35da42)return![];if(!_0x35da42[_0x57d0df(0x199)]())return![];if(Imported[_0x57d0df(0x1b0)]&&BattleManager[_0x57d0df(0x1c4)]())return![];return DataManager[_0x57d0df(0x227)](_0x440011[_0x57d0df(0x293)]());},Window_BattleLog[_0x2b276d(0x1eb)][_0x2b276d(0x22d)]=function(_0x413a55,_0x4f8e2b){const _0x5e59a1=_0x2b276d;this[_0x5e59a1(0x221)]=!![],$gameTemp[_0x5e59a1(0x1c6)](_0x413a55,_0x4f8e2b[_0x5e59a1(0x293)]());if(Window_BattleLog[_0x5e59a1(0x232)][_0x5e59a1(0x2d8)]>0x0){if(_0x5e59a1(0x1d9)!==_0x5e59a1(0x1d9)){const _0x46bf0f=_0x5a08af[_0x5e59a1(0x20e)][_0x5e59a1(0x269)];return _0x46bf0f&&_0x46bf0f['_inputComboSkillMode']&&(this[_0x5e59a1(0x1bf)]=0x3c),this[_0x5e59a1(0x1bf)]-->=0x0;}else this[_0x5e59a1(0x1a9)](_0x5e59a1(0x29f),Window_BattleLog[_0x5e59a1(0x232)]);}this[_0x5e59a1(0x1a9)](_0x5e59a1(0x1cb),_0x413a55,_0x4f8e2b),this[_0x5e59a1(0x1a9)]('waitForMovement');const _0x7a124b=DataManager[_0x5e59a1(0x1f1)](_0x4f8e2b[_0x5e59a1(0x293)]());_0x7a124b>0x0&&this[_0x5e59a1(0x1a9)](_0x5e59a1(0x1d8),_0x413a55,[_0x413a55],_0x7a124b);},Window_BattleLog[_0x2b276d(0x1eb)][_0x2b276d(0x233)]=function(){const _0x38237b=_0x2b276d,_0x43af31=SceneManager[_0x38237b(0x20e)][_0x38237b(0x1aa)];if(_0x43af31)_0x43af31[_0x38237b(0x1d5)]();this['_inputComboSkillMode']=![],this['clear']();const _0x59eb56=BattleManager['_subject'],_0x2ca68b=BattleManager[_0x38237b(0x1bb)],_0x1eab58=BattleManager[_0x38237b(0x2b2)];VisuMZ[_0x38237b(0x2a8)][_0x38237b(0x272)][_0x38237b(0x268)](this,_0x59eb56,_0x2ca68b,_0x1eab58),_0x59eb56[_0x38237b(0x2d4)]();};function _0x3fe0(_0x16d81c,_0x4bb65e){const _0x488073=_0x4880();return _0x3fe0=function(_0x3fe0d8,_0x182470){_0x3fe0d8=_0x3fe0d8-0x165;let _0x40e7ab=_0x488073[_0x3fe0d8];return _0x40e7ab;},_0x3fe0(_0x16d81c,_0x4bb65e);}function _0x4880(){const _0xd446ed=['clamp','members','KeybindUiOffsetX','OffsetY','drawInputComboLargeIcon','setupText','isVisible','addText','_inputComboSkillButtons','%1Pitch','queueBackgroundImage','1691330fzWuGp','_lastActor','clone','processTouch','drawTextEx','InputComboSkills','%1Volume','format','ComboOnly','_inputComboSkillsUiTooltipWindow','BackgroundImage','setSkill','applyGlobal','_hovered','meetsSkillConditions','_targets','queueAutoBattleInputComboSkills','meetsInputComboSkillConditions','endAction','getInputComboMax','backOpacity','version','33LObOuc','VisuMZ_1_SkillsStatesCore','eEiEa','_cacheComboMax','Game_Temp_initialize','_hoverState','fBofM','useItem','InputComboAnimation','1554918exdkFM','oBniZ','clearInputComboSkillQueue','scale','WINDOW_SKIN_OPACITY','textSizeEx','user','name','INPUT_COMBO_ANIMATION','hitTest','autoQueueRandomInputComboSkills','_subject','OpacityRate','xLMvH','Sprite_Actor_stepBack','bind','Khymm','registerInputComboSpecials','queueNextInputComboSkill','RegExp','wPmpR','DataManager_isSkill','length','Scene_Battle_createDisplayObjects','updateInputComboSkillQueue','updateInputComboSkillSwitch','pop','left','randomInt','registerInputComboSkillsMax','_context','ComboStartAni','LIknY','mNLdU','Sound','opacity','subject','isReleased','autoQueueInputComboSpecial','ComboMax','onClick','constructor','shift','isBeingTouched','_bypassStepBackward_InputComboSkill','createContentWindow','_inputComboSkillsUiContainer','STR','zZSmq','clampPosition','floor','clearInputComboSkillCostBypass','NUM','onMouseExit','XaTxl','filter','270vdyOoH','RdyXR','lineHeight','WindowOpacity','imageSmoothingEnabled','createBackgroundSprite','stepBack','bitmap','XvpTE','ARRAYFUNC','waitForMovement','%1\x20is\x20missing\x20a\x20required\x20plugin.\x0aPlease\x20install\x20%2\x20into\x20the\x20Plugin\x20Manager.','hasInputComboSkillsKey','loadWindowskin','_checkInputComboOnlySkill','windowPadding','special','kuhFy','fhLCs','_inputComboSkillKeys','Tooltip','MOUSE_OFFSET_Y','canStartInputComboSkill','test','VisuMZ_3_AutoSkillTriggers','aaNRe','toLowerCase','bvVdU','tdBlq','VisuMZ_1_MessageCore','isActor','_pressed','map','beginPath','note','specialStringToKeys','1411284LuNRGK','return\x200','contentDrawJS','isBusy','FUNC','clear','%1\x20is\x20incorrectly\x20placed\x20on\x20the\x20plugin\x20list.\x0aIt\x20is\x20a\x20Tier\x20%2\x20plugin\x20placed\x20over\x20other\x20Tier\x20%3\x20plugins.\x0aPlease\x20reorder\x20the\x20plugin\x20list\x20from\x20smallest\x20to\x20largest\x20tier\x20numbers.','moveTo','INPUT_COMBO_REDUCE_BACK_FORTH','keys','push','_inputComboSkillQueueListSprite','ARRAYNUM','queueInputComboSkillsFromKey','requestRefresh','iuTuh','forceAction','VisuMZ_2_BattleSystemBTB','wKDVs','ReduceBackForth','height','createInputComboSkillsUiBackground','lineTo','_inputComboSkillSpecialString','stepForward','meetsUsableItemConditions','AvailableSpecial','contents','_action','split','canUse','_bypassStepForward_InputComboSkill','_visibleFrameCount','status','_inputComboSkillSpecialSkillID','QueueSwitchID','initialize','isBTB','fillRoundRect','prepareInputComboSkills','isSkillSealed','updateInputComboSkillsUiOpacity','xCiWz','cancel','performActionStart','Sprite_Actor_stepForward','WtzOI','applyKeyAlternatives','iconIndex','ARRAYSTR','updatePosition','_inputComboSkillSpecials','create','_battler','update','onMouseEnter','_contentSprite','showAnimation','xbUxP','75472zgCDkg','addToInputComboSkillsQueueFromKey','_skill','down','createInputComboSkillsUiContainer','remove','Game_BattlerBase_meetsSkillConditions','red','533424ROokBS','LearnedSpecial','_lastInputType','HZWYb','_cacheSpecialSkillID','getInputButtonString','match','createContentSprite','aXiIE','prototype','DefaultMaxCombo','isLearnedSkill','_lastSkillID','iconHeight','blt','getInputComboStartAnimation','_dimensions','fillRect','%1RectJS','hBall','noValidInputComboSkills','stypeId','debugFillRect','checkInputComboSkillsIncompatibility','Keqps','createInputComboSkillsUiTooltipWindow','iconWidth','startAction','fill','_key','IconSet','updateInputComboSkills','meetsUpdateBitmapConditions','createInputComboSkillsUiQueueList','%1BackgroundImage','_inputComboSkillCostBypass','EvoMatrixSkills','description','pymjF','tooltipWindow','onPress','isSupportMessageKeywords','CjDIi','hasInputComboSkillsConflicts','_scene','54674jiEKrY','_cacheQueue','%1Pan','registerInputComboSkillsActor','WkkTw','Settings','EVAL','InputKey','width','%1\x27s\x20version\x20does\x20not\x20match\x20plugin\x27s.\x20Please\x20update\x20it\x20in\x20the\x20Plugin\x20Manager.','refreshBitmap','isClickEnabled','opacityLevel','indexOf','context','payCostInputComboSkillQueueLatest','parameters','exit','_inputComboSkillMode','_contentWindow','LNpAY','OffsetX','ARRAYEVAL','round','isInputComboOriginSkill','clearInputComboSkills','\x5cI[%1]%2','SSVtW','_inputComboMax','hide','startInputComboSkill','applyInputComboSkillQueue','_skillCostBypass','refresh','ForcedSpecial','INPUT_COMBO_TEXT','endInputComboSkill','PFlNV','updateBackOpacity','max','isWordWrapEnabled','backgroundDrawJS','toUpperCase','createAllSkillCostText','getLastUsedGamepadType','createInputComboSkillsUiElements','addChild','getButtonIcon','WJYGC','includes','forceActionInputComboSkill','setupDescriptionText','queueDrawBackRect','lDNUw','AutoSkillTriggers','_inputComboSkillQueue','getInputComboSkillsKey','WINDOW_SKIN_FILENAME','createDisplayObjects','KeybindUiOffsetY','pagedown','updateOpacity','PVuzK','registerInputComboSkillCostBypass','_pressedDuration','MQhyq','registerInputComboSkills','_requestRefresh','_inputComboSkillUser','checkForInputComboSkillsEnd','windowskin','input','Keys','MOUSE_OFFSET_X','%1Name','resetFontSettings','playInputComboSkillsSound','right','initMembers','anchor','QQvpi','BattleManager_endAction','padding','ARRAYJSON','loadSystem','isTriggered','isSkill','restore','isAutoBattle','call','_logWindow','Scene_Battle_update','convertMessageKeywords','ConvertParams','ENABLED','KeypressUiOffsetY','rkFKM','INPUT_COMBO_DEFAULT_MAX','addToInputComboSkillsStringFromKey','Window_BattleLog_startAction','queueRectJS','createInputComboSkillsUiButtons','enabled','%1KeyIcon','hasInputComboQueue','VisuMZ_0_CoreEngine','GUDdV','replace','CEYSB','_text','InputComboText','KEY_PRESS_OFFSET_X','_inputComboSkillMax','isSceneBattle','updateBitmap','VisuMZ_1_BattleCore','pageup','worldTransform','_hasInputComboSkillsConflict','canPerformInputComboSkills','visible','143712JHoDTE','Scale','VisuStella\x20MZ\x20Auto\x20Skill\x20Triggers\x20needs\x20to\x20be\x20updated!','parse','xCZjd','resizeWindow','Game_Battler_useItem','drawContentJS','UxSkq','LHfsv','WINDOW_SCALE','item','psrQg','_queueNextInputComboSkill','trim','quadraticCurveTo'];_0x4880=function(){return _0xd446ed;};return _0x4880();}function Window_InputComboSkillsTooltip(){const _0xa25ba7=_0x2b276d;this[_0xa25ba7(0x1c3)](...arguments);}Window_InputComboSkillsTooltip[_0x2b276d(0x1eb)]=Object[_0x2b276d(0x1d3)](Window_Base[_0x2b276d(0x1eb)]),Window_InputComboSkillsTooltip[_0x2b276d(0x1eb)][_0x2b276d(0x16c)]=Window_InputComboSkillsTooltip,Window_InputComboSkillsTooltip[_0x2b276d(0x26d)]=VisuMZ[_0x2b276d(0x2a8)][_0x2b276d(0x214)][_0x2b276d(0x18f)][_0x2b276d(0x275)]??!![],Window_InputComboSkillsTooltip['WINDOW_SCALE']=VisuMZ[_0x2b276d(0x2a8)][_0x2b276d(0x214)][_0x2b276d(0x18f)][_0x2b276d(0x289)],Window_InputComboSkillsTooltip[_0x2b276d(0x248)]=VisuMZ['InputComboSkills'][_0x2b276d(0x214)]['Tooltip']['WindowSkin'],Window_InputComboSkillsTooltip[_0x2b276d(0x2c6)]=VisuMZ[_0x2b276d(0x2a8)][_0x2b276d(0x214)][_0x2b276d(0x18f)][_0x2b276d(0x17e)],Window_InputComboSkillsTooltip[_0x2b276d(0x258)]=VisuMZ[_0x2b276d(0x2a8)]['Settings']['Tooltip'][_0x2b276d(0x224)],Window_InputComboSkillsTooltip[_0x2b276d(0x190)]=VisuMZ[_0x2b276d(0x2a8)][_0x2b276d(0x214)]['Tooltip'][_0x2b276d(0x29b)],Window_InputComboSkillsTooltip['prototype']['initialize']=function(){const _0x4c1391=_0x2b276d,_0x4b9119=new Rectangle(0x0,0x0,Graphics[_0x4c1391(0x217)],Graphics[_0x4c1391(0x1b3)]);Window_Base[_0x4c1391(0x1eb)]['initialize']['call'](this,_0x4b9119),this[_0x4c1391(0x2c5)]['x']=this[_0x4c1391(0x2c5)]['y']=Window_InputComboSkillsTooltip[_0x4c1391(0x292)],this[_0x4c1391(0x22c)](),this[_0x4c1391(0x1dc)]=null;},Window_InputComboSkillsTooltip[_0x2b276d(0x1eb)][_0x2b276d(0x188)]=function(){const _0x1a0129=_0x2b276d;this[_0x1a0129(0x255)]=ImageManager[_0x1a0129(0x263)](Window_InputComboSkillsTooltip['WINDOW_SKIN_FILENAME']);},Window_InputComboSkillsTooltip[_0x2b276d(0x1eb)][_0x2b276d(0x235)]=function(){const _0x1a89dd=_0x2b276d;this[_0x1a89dd(0x2b7)]=Window_InputComboSkillsTooltip[_0x1a89dd(0x2c6)];},Window_InputComboSkillsTooltip['prototype'][_0x2b276d(0x2ae)]=function(_0x9bfcc3){const _0x462fa1=_0x2b276d;if(this[_0x462fa1(0x1dc)]===_0x9bfcc3)return;this[_0x462fa1(0x1dc)]=_0x9bfcc3;if(this[_0x462fa1(0x1dc)]&&this[_0x462fa1(0x1dc)][_0x462fa1(0x207)][_0x462fa1(0x296)]()[_0x462fa1(0x2d8)]>0x0)this[_0x462fa1(0x230)]();else{if('MHXEv'!==_0x462fa1(0x23f))this['hide']();else{const _0x227aa6=new _0x2bdcb2(_0x117658['x'],_0x56dfba['y']),_0x45302b=this[_0x462fa1(0x284)]['applyInverse'](_0x227aa6);return this[_0x462fa1(0x2cb)](_0x45302b['x'],_0x45302b['y']);}}},Window_InputComboSkillsTooltip[_0x2b276d(0x1eb)][_0x2b276d(0x230)]=function(){const _0x46bf19=_0x2b276d;this[_0x46bf19(0x1ba)][_0x46bf19(0x1a4)](),this[_0x46bf19(0x29d)]();if(this[_0x46bf19(0x27c)][_0x46bf19(0x2d8)]>0x0){this[_0x46bf19(0x28d)]();const _0x175da5=this['baseTextRect']();this[_0x46bf19(0x2a7)](this[_0x46bf19(0x27c)],_0x175da5['x'],_0x175da5['y'],_0x175da5[_0x46bf19(0x217)]),this['show']();}else this[_0x46bf19(0x22c)]();},Window_InputComboSkillsTooltip[_0x2b276d(0x1eb)][_0x2b276d(0x237)]=function(){return![];},Window_InputComboSkillsTooltip[_0x2b276d(0x1eb)][_0x2b276d(0x26b)]=function(_0x14da64){return _0x14da64;},Window_InputComboSkillsTooltip['prototype'][_0x2b276d(0x20b)]=function(){return![];},Window_InputComboSkillsTooltip['prototype']['setupText']=function(){const _0x291a9f=_0x2b276d;this[_0x291a9f(0x27c)]='';if(!this['_skill'])return;this[_0x291a9f(0x242)](),this[_0x291a9f(0x27c)]=this[_0x291a9f(0x27c)][_0x291a9f(0x296)]();},Window_InputComboSkillsTooltip[_0x2b276d(0x1eb)][_0x2b276d(0x242)]=function(){const _0x241d5c=_0x2b276d;this['_text']=this[_0x241d5c(0x1dc)][_0x241d5c(0x207)]||'';},Window_InputComboSkillsTooltip[_0x2b276d(0x1eb)][_0x2b276d(0x28d)]=function(){const _0x127b24=_0x2b276d,_0x4d8537=this[_0x127b24(0x2c7)](this['_text']);this['width']=_0x4d8537[_0x127b24(0x217)]+(this['itemPadding']()+this[_0x127b24(0x261)])*0x2,this[_0x127b24(0x1b3)]=_0x4d8537[_0x127b24(0x1b3)]+this[_0x127b24(0x261)]*0x2,this['createContents'](),this[_0x127b24(0x25a)]();},Window_InputComboSkillsTooltip[_0x2b276d(0x1eb)]['update']=function(){const _0x1f4ba2=_0x2b276d;Window_Base[_0x1f4ba2(0x1eb)][_0x1f4ba2(0x1d5)][_0x1f4ba2(0x268)](this),this[_0x1f4ba2(0x252)]&&(this[_0x1f4ba2(0x252)]=![],this[_0x1f4ba2(0x230)]()),this[_0x1f4ba2(0x1d1)](),this[_0x1f4ba2(0x24c)]();},Window_InputComboSkillsTooltip[_0x2b276d(0x1eb)][_0x2b276d(0x1ad)]=function(){this['_requestRefresh']=!![];},Window_InputComboSkillsTooltip['prototype'][_0x2b276d(0x1d1)]=function(){const _0x8a594b=_0x2b276d;if(!this[_0x8a594b(0x287)])return;this['x']=TouchInput['x']+Window_InputComboSkillsTooltip[_0x8a594b(0x258)],this['y']=TouchInput['y']+Window_InputComboSkillsTooltip['MOUSE_OFFSET_Y'],this[_0x8a594b(0x174)]();},Window_InputComboSkillsTooltip[_0x2b276d(0x1eb)][_0x2b276d(0x174)]=function(){const _0x1f9fee=_0x2b276d,_0x4594a9=this[_0x1f9fee(0x217)]*(Window_InputComboSkillsTooltip['WINDOW_SCALE']||0.01),_0x1522d7=this[_0x1f9fee(0x1b3)]*(Window_InputComboSkillsTooltip[_0x1f9fee(0x292)]||0.01);this['x']=Math['round'](this['x']['clamp'](0x0,Graphics[_0x1f9fee(0x217)]-_0x4594a9)),this['y']=Math[_0x1f9fee(0x226)](this['y'][_0x1f9fee(0x298)](0x0,Graphics['height']-_0x1522d7));},Window_InputComboSkillsTooltip['prototype'][_0x2b276d(0x24c)]=function(){const _0x4d2be8=_0x2b276d;let _0x493354=0xff;if(TouchInput['x']<=0x0)_0x493354=0x0;if(TouchInput['x']>=Graphics[_0x4d2be8(0x217)])_0x493354=0x0;if(TouchInput['y']<=0x0)_0x493354=0x0;if(TouchInput['y']>=Graphics[_0x4d2be8(0x1b3)])_0x493354=0x0;this[_0x4d2be8(0x166)]=_0x493354;};