//=============================================================================
// VisuStella MZ - CG Gallery
// VisuMZ_4_CGGallery.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_4_CGGallery = true;

var VisuMZ = VisuMZ || {};
VisuMZ.CGGallery = VisuMZ.CGGallery || {};
VisuMZ.CGGallery.version = 1.01;

//=============================================================================
/* ----------------------------------------------------------------------------
 * Category List Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Category:
 *
 * @param Key:str
 * @text ID Key
 * @desc This category's identification key. Categories require
 * unique keys for the plugin to differentiate them.
 * @default (Needs Key)
 *
 * @param Text:str
 * @text Text
 * @desc This category's command text.
 * @default Untitled
 *
 * @param Icon:num
 * @text Icon
 * @desc Icon used for this category.
 * Use 0 for no icon.
 * @default 0
 *
 * @param Description:json
 * @text Help Description
 * @type note
 * @desc A description of the CG Gallery listing.
 * Text codes allowed.
 * @default "Line1\nLine2"
 * 
 */
/* ----------------------------------------------------------------------------
 * Listing Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Listing:
 *
 * @param Filename:str
 * @text Filename
 * @type file
 * @dir img/pictures/
 * @require 1
 * @desc Filename used for the CG Gallery listing.
 * This will be used as the CG Gallery thumbnail, too.
 * @default Untitled
 *
 * @param Variations:arraystr
 * @text Variations
 * @parent Filename:str
 * @type file[]
 * @dir img/pictures/
 * @require 1
 * @desc Variations of the CG Gallery listing.
 * @default []
 *
 * @param Category:str
 * @text Category
 * @desc The category this image is listed under.
 * If unlisted, the image will be listed under "Unlisted".
 * @default Unlisted
 *
 * @param Description:json
 * @text Help Description
 * @type note
 * @desc A description of the CG Gallery listing.
 * Text codes allowed.
 * @default "Line1\nLine2"
 *
 */
/* ----------------------------------------------------------------------------
 * System Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~System:
 *
 * @param AutoUnlocks
 * @text Auto-Unlocks
 *
 * @param AutoUnlockShowPicture:eval
 * @text Show Picture?
 * @parent AutoUnlocks
 * @type boolean
 * @on Auto-Unlock
 * @off Ignore
 * @desc Auto-unlock listings for the CG Gallery when using
 * "Show Picture" event commands?
 * @default true
 *
 * @param AutoUnlockVariations:eval
 * @text Variations?
 * @parent AutoUnlocks
 * @type boolean
 * @on Auto-Unlock
 * @off Ignore
 * @desc Auto-unlock variations for listings for the CG Gallery?
 * @default false
 * 
 * @param Scene_CG_Gallery
 *
 * @param MoveDistance:num
 * @text Move Distance
 * @parent Scene_CG_Gallery
 * @desc How many pixels should pictures move per frame?
 * @default 4
 *
 */
/* ----------------------------------------------------------------------------
 * MainMenu Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~MainMenu:
 *
 * @param Name:str
 * @text Command Name
 * @parent Options
 * @desc Name of the 'CG Gallery' option in the Main Menu.
 * @default CG Gallery
 *
 * @param ShowMainMenu:eval
 * @text Show in Main Menu?
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Add the 'CG Gallery' option to the Main Menu by default?
 * @default true
 *
 * @param EnableMainMenu:eval
 * @text Enable in Main Menu?
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Enable the 'CG Gallery' option to the Main Menu by default?
 * @default true
 *
 * @param ShowTitleCommand:eval
 * @text Show in Title Command?
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Add the "CG Gallery" the Title Command Window?
 * @default true
 *
 */
/* ----------------------------------------------------------------------------
 * Background Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~BgSettings:
 *
 * @param SnapshotOpacity:num
 * @text Snapshop Opacity
 * @type number
 * @min 0
 * @max 255
 * @desc Snapshot opacity for the scene.
 * @default 192
 *
 * @param BgFilename1:str
 * @text Background 1
 * @type file
 * @dir img/titles1/
 * @require 1
 * @desc Filename used for the bottom background image.
 * Leave empty if you don't wish to use one.
 * @default 
 *
 * @param BgFilename2:str
 * @text Background 2
 * @type file
 * @dir img/titles2/
 * @require 1
 * @desc Filename used for the upper background image.
 * Leave empty if you don't wish to use one.
 * @default 
 *
 */
/* ----------------------------------------------------------------------------
 * Sound Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Sound:
 *
 * @param View
 * @text Select Image
 * 
 * @param viewName:str
 * @text Filename
 * @parent View
 * @type file
 * @dir audio/se/
 * @require 1
 * @desc Filename of the sound effect played.
 * @default Book1
 *
 * @param viewVolume:num
 * @text Volume
 * @parent View
 * @type number
 * @max 100
 * @desc Volume of the sound effect played.
 * @default 90
 *
 * @param viewPitch:num
 * @text Pitch
 * @parent View
 * @type number
 * @desc Pitch of the sound effect played.
 * @default 100
 *
 * @param viewPan:num
 * @text Pan
 * @parent View
 * @desc Pan of the sound effect played.
 * @default 0
 *
 * @param Change
 * @text Change Variation
 * 
 * @param changeName:str
 * @text Filename
 * @parent Change
 * @type file
 * @dir audio/se/
 * @require 1
 * @desc Filename of the sound effect played.
 * @default Book2
 *
 * @param changeVolume:num
 * @text Volume
 * @parent Change
 * @type number
 * @max 100
 * @desc Volume of the sound effect played.
 * @default 90
 *
 * @param changePitch:num
 * @text Pitch
 * @parent Change
 * @type number
 * @desc Pitch of the sound effect played.
 * @default 100
 *
 * @param changePan:num
 * @text Pan
 * @parent Change
 * @desc Pan of the sound effect played.
 * @default 0
 *
 */
/* ----------------------------------------------------------------------------
 * Vocabulary Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Vocab:
 *
 * @param CategoryWindowCommands
 * @text Special Categories
 *
 * @param AllCommandText:str
 * @text "All" Command
 * @parent CategoryWindowCommands
 * @desc Text used for the "All" Category.
 * @default All
 *
 * @param UnlistedCommandText:str
 * @text "Unlisted" Command
 * @parent CategoryWindowCommands
 * @desc Text used for the "Unlisted" Category.
 * @default Unlisted
 *
 * @param HelpDesc
 * @text Help Descriptions
 *
 * @param AllCommandDescription:json
 * @text "All" Category
 * @parent HelpDesc
 * @type note
 * @desc A description used for the "All" Category.
 * Text codes allowed.
 * @default "View all types of images for this gallery."
 *
 * @param UnlistedCommandDescription:json
 * @text "Unlisted" Category
 * @parent HelpDesc
 * @type note
 * @desc A description used for the "Unlisted" Category.
 * Text codes allowed.
 * @default "These images do not have a category."
 *
 * @param LockedHelpDescription:json
 * @text Not Unlocked Image
 * @parent HelpDesc
 * @type note
 * @desc A description used for yet to be unlocked images.
 * Text codes allowed.
 * @default "You have not unlocked this image yet."
 * 
 * @param GalleryWindow
 * @text Gallery Window
 * 
 * @param GalleryWindowVariations
 * @text Variations
 * @parent GalleryWindow
 *
 * @param GalleryWindow_Text_VariationComplete:str
 * @text Complete Text
 * @parent GalleryWindowVariations
 * @desc Text displayed for listings with complete unlocks.
 * Leave empty to not use.
 * @default \}★
 *
 * @param GalleryWindow_Text_VariationFmt:str
 * @text Text Format
 * @parent GalleryWindowVariations
 * @desc Text format for listings with variations left.
 * %1 - Percent, %2 - Unlocked, %3 - Total
 * @default \}%2/%3
 * 
 * @param GalleryWindowCompletion
 * @text Completion
 * @parent GalleryWindow
 *
 * @param GalleryWindow_Text_CompletionVocab:str
 * @text Vocabulary
 * @parent GalleryWindowCompletion
 * @desc Main vocabulary used for this text.
 * @default Completion
 *
 * @param GalleryWindow_Text_CompletionFmt:str
 * @text Percentage Format
 * @parent GalleryWindowCompletion
 * @desc Text format used for completion percentage.
 * %1 - Percent, %2 - Unlocked, %3 - Total
 * @default %1%
 * 
 * @param GalleryWindowProgress
 * @text Progress
 * @parent GalleryWindow
 *
 * @param GalleryWindow_Text_ProgressVocab:str
 * @text Vocabulary
 * @parent GalleryWindowProgress
 * @desc Main vocabulary used for this text.
 * @default Progress
 *
 * @param GalleryWindow_Text_ProgressFmt:str
 * @text Progress Format
 * @parent GalleryWindowProgress
 * @desc Text format used for progress unlocked.
 * %1 - Percent, %2 - Unlocked, %3 - Total
 * @default %2/%3
 *
 * @param ButtonAssist
 * @text Button Assist Window
 *
 * @param ButtonAssistVocab_Border:str
 * @text Border
 * @parent ButtonAssist
 * @desc Text used for toggling border and borderless.
 * Requires VisuMZ_0_CoreEngine!
 * @default Border
 *
 * @param ButtonAssistVocab_Gallery:str
 * @text Gallery
 * @parent ButtonAssist
 * @desc Text used for returning back to the gallery.
 * Requires VisuMZ_0_CoreEngine!
 * @default Gallery
 *
 * @param ButtonAssistVocab_Next:str
 * @text Next Variation
 * @parent ButtonAssist
 * @desc Text used for going to next variation.
 * Requires VisuMZ_0_CoreEngine!
 * @default Next
 *
 * @param ButtonAssistVocab_Prev:str
 * @text Previous Variation
 * @parent ButtonAssist
 * @desc Text used for going to previous variation.
 * Requires VisuMZ_0_CoreEngine!
 * @default Prev
 *
 * @param ButtonAssistVocab_Reset:str
 * @text Reset Zoom/Position
 * @parent ButtonAssist
 * @desc Text used for resetting the zoom and position.
 * Requires VisuMZ_0_CoreEngine!
 * @default Reset
 *
 * @param ButtonAssistVocab_Zoom:str
 * @text Zoom Change
 * @parent ButtonAssist
 * @desc Text used for changing the zoom scale.
 * Requires VisuMZ_0_CoreEngine!
 * @default Zoom
 *
 */
/* ----------------------------------------------------------------------------
 * Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Window:
 *
 * @param HelpWindow
 * @text Window_Help
 *
 * @param HelpWindow_BgType:num
 * @text Background Type
 * @parent HelpWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param HelpWindow_RectJS:func
 * @text JS: X, Y, W, H
 * @parent HelpWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const wx = 0;\nconst wy = this.helpAreaTop();\nconst ww = Graphics.boxWidth;\nconst wh = this.helpAreaHeight();\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param CategoryWindow
 * @text Window_CG_Category
 *
 * @param CategoryWindow_BgType:num
 * @text Background Type
 * @parent CategoryWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 * 
 * @param CategoryWindowCommands
 * @text Special Categories
 * @parent CategoryWindow
 *
 * @param CategoryWindow_AddAllCommand:eval
 * @text Add All Command?
 * @parent CategoryWindowCommands
 * @type boolean
 * @on Add
 * @off Ignore
 * @desc Add the "All" command for the CG Gallery Category window.
 * @default true
 *
 * @param AllCommandIcon:num
 * @text "All" Icon
 * @parent CategoryWindow_AddAllCommand:eval
 * @desc Icon used for the "All" Category.
 * @default 307
 *
 * @param CategoryWindow_ShowUnlistedCommand:eval
 * @text Show Unlisted?
 * @parent CategoryWindowCommands
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show the "Unlisted" command for the CG Gallery Category window if applicable.
 * @default true
 *
 * @param UnlistedCommandIcon:num
 * @text "Unlisted" Icon
 * @parent CategoryWindow_ShowUnlistedCommand:eval
 * @desc Icon used for the "Unlisted" Category.
 * @default 308
 *
 * @param CategoryWindow_Style:str
 * @text Style
 * @parent CategoryWindow
 * @type select
 * @option Text Only
 * @value text
 * @option Icon Only
 * @value icon
 * @option Icon + Text
 * @value iconText
 * @option Automatic
 * @value auto
 * @desc How do you wish to draw commands for this window?
 * @default auto
 *
 * @param CategoryWindow_TextAlign:str
 * @text Text Align
 * @parent CategoryWindow
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for this window?
 * @default center
 *
 * @param CategoryWindow_RectJS:func
 * @text JS: X, Y, W, H
 * @parent CategoryWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const ww = Graphics.boxWidth;\nconst wh = this.calcWindowHeight(1, false);\nconst wx = 0;\nconst wy = this.mainAreaTop();\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param GalleryWindow
 * @text Window_CG_Gallery
 *
 * @param GalleryWindow_BgType:num
 * @text Background Type
 * @parent GalleryWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param LockedImgFilename:str
 * @text Custom Locked Image
 * @parent GalleryWindow
 * @type file
 * @dir img/pictures/
 * @require 1
 * @desc Custom picture graphic used for entries that have yet to be unlocked.
 * @default 
 *
 * @param GalleryWindow_ImageBuffer:num
 * @text Image Buffer
 * @parent GalleryWindow
 * @type number
 * @desc How many pixels of buffer range should there be for selected images?
 * @default 4
 *
 * @param GalleryWindow_ListingBack:eval
 * @text Listing Background?
 * @parent GalleryWindow
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show the dark background for listings?
 * @default true
 *
 * @param GalleryWindow_MaxCols:num
 * @text Max Columns
 * @parent GalleryWindow
 * @type number
 * @min 1
 * @desc Max columns used for this window.
 * @default 4
 *
 * @param GalleryWindow_SpacingCols:num
 * @text Spacing
 * @parent GalleryWindow_MaxCols:num
 * @type number
 * @min 0
 * @desc Column spacing for this window.
 * @default 4
 *
 * @param GalleryWindow_MaxRows:num
 * @text Max Rows
 * @parent GalleryWindow
 * @type number
 * @min 1
 * @desc Max rows used for this window.
 * @default 3
 *
 * @param GalleryWindow_SpacingRows:num
 * @text Spacing
 * @parent GalleryWindow_MaxRows:num
 * @type number
 * @min 0
 * @desc Row spacing for this window.
 * @default 4
 *
 * @param GalleryWindow_Stagger:num
 * @text Stagger
 * @parent GalleryWindow
 * @type number
 * @desc How many pixels should the gallery entries stagger by?
 * This is the diagonal listing effect.
 * @default 160
 *
 * @param GalleryWindow_StaggerToLeft:eval
 * @text Towards Left?
 * @parent GalleryWindow_Stagger:num
 * @type boolean
 * @on Towards Left
 * @off Towards Right
 * @desc Which direction should the stagger be going towards?
 * @default true
 * 
 * @param GalleryWindow_Text
 * @text Text
 * @parent GalleryWindow
 * 
 * @param GalleryWindow_Text_Variations
 * @text Variations
 * @parent GalleryWindow_Text
 *
 * @param GalleryWindow_Text_VariationsShow:eval
 * @text Show?
 * @parent GalleryWindow_Text_Variations
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show variations on the gallery thumbnail?
 * @default true
 *
 * @param GalleryWindow_Text_VariationsShowSingles:eval
 * @text Display Singles?
 * @parent GalleryWindow_Text_Variations
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show text on listings with no variations?
 * @default false
 *
 * @param GalleryWindow_Text_VariationsAlignX:str
 * @text Horz Text Align
 * @parent GalleryWindow_Text_Variations
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Horizontal alignment for this text?
 * @default right
 *
 * @param GalleryWindow_Text_VariationsAlignY:str
 * @text Vert Text Align
 * @parent GalleryWindow_Text_Variations
 * @type combo
 * @option top
 * @option middle
 * @option bottom
 * @desc Vertical alignment for this text?
 * @default bottom
 * 
 * @param GalleryWindow_Text_Completion
 * @text Completion
 * @parent GalleryWindow_Text
 *
 * @param GalleryWindow_Text_CompletionShow:eval
 * @text Show?
 * @parent GalleryWindow_Text_Completion
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show this text?
 * @default true
 *
 * @param GalleryWindow_Text_CompletionDecimals:num
 * @text Decimal Places
 * @parent GalleryWindow_Text_Completion
 * @type number
 * @desc How many decimal places should the percentage value go to?
 * @default 2
 *
 * @param GalleryWindow_Text_CompletionFontFace:str
 * @text Font Name
 * @parent GalleryWindow_Text_Completion
 * @desc What is the font family name (NOT filename) of the font?
 * Look up the name via Windows Font Preview.
 * @default Arial
 *
 * @param GalleryWindow_Text_CompletionFontSize1:num
 * @text Font Size: Vocab
 * @parent GalleryWindow_Text_CompletionFontFace:str
 * @type number
 * @desc What is the font size of the main vocabulary?
 * @default 26
 *
 * @param GalleryWindow_Text_CompletionFontSize2:num
 * @text Font Size: Value
 * @parent GalleryWindow_Text_CompletionFontFace:str
 * @type number
 * @desc What is the font size of the value?
 * @default 36
 *
 * @param GalleryWindow_Text_CompletionOffset
 * @text Offset
 * @parent GalleryWindow_Text_Completion
 *
 * @param GalleryWindow_Text_CompletionAngle:num
 * @text Angle
 * @parent GalleryWindow_Text_CompletionOffset
 * @desc What angle should this text be shown at?
 * @default 20
 *
 * @param GalleryWindow_Text_CompletionOffsetX:num
 * @text Offset X
 * @parent GalleryWindow_Text_CompletionOffset
 * @desc How many pixels to offset the x position?
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param GalleryWindow_Text_CompletionOffsetY:num
 * @text Offset Y
 * @parent GalleryWindow_Text_CompletionOffset
 * @desc How many pixels to offset the y position?
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @param GalleryWindow_Text_Progress
 * @text Progress
 * @parent GalleryWindow_Text
 *
 * @param GalleryWindow_Text_ProgressShow:eval
 * @text Show?
 * @parent GalleryWindow_Text_Progress
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show this text?
 * @default true
 *
 * @param GalleryWindow_Text_ProgressDecimals:num
 * @text Decimal Places
 * @parent GalleryWindow_Text_Progress
 * @type number
 * @desc How many decimal places should the percentage value go to?
 * @default 2
 *
 * @param GalleryWindow_Text_ProgressFontFace:str
 * @text Font Name
 * @parent GalleryWindow_Text_Progress
 * @desc What is the font family name (NOT filename) of the font?
 * Look up the name via Windows Font Preview.
 * @default Arial
 *
 * @param GalleryWindow_Text_ProgressFontSize1:num
 * @text Font Size: Vocab
 * @parent GalleryWindow_Text_ProgressFontFace:str
 * @type number
 * @desc What is the font size of the main vocabulary?
 * @default 26
 *
 * @param GalleryWindow_Text_ProgressFontSize2:num
 * @text Font Size: Value
 * @parent GalleryWindow_Text_ProgressFontFace:str
 * @type number
 * @desc What is the font size of the value?
 * @default 48
 *
 * @param GalleryWindow_Text_ProgressOffset
 * @text Offset
 * @parent GalleryWindow_Text_Progress
 *
 * @param GalleryWindow_Text_ProgressAngle:num
 * @text Angle
 * @parent GalleryWindow_Text_ProgressOffset
 * @desc What angle should this text be shown at?
 * @default -20
 *
 * @param GalleryWindow_Text_ProgressOffsetX:num
 * @text Offset X
 * @parent GalleryWindow_Text_ProgressOffset
 * @desc How many pixels to offset the x position?
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param GalleryWindow_Text_ProgressOffsetY:num
 * @text Offset Y
 * @parent GalleryWindow_Text_ProgressOffset
 * @desc How many pixels to offset the y position?
 * Negative: up. Positive: down.
 * @default +0
 *
 * @param GalleryWindow_RectJS:func
 * @text JS: X, Y, W, H
 * @parent GalleryWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const ww = Graphics.boxWidth;\nconst wh = this.mainAreaHeight() - this.calcWindowHeight(1, false);\nconst wx = 0;\nconst wy = this.mainAreaTop() + this.calcWindowHeight(1, false);\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 */
//=============================================================================

const _0x53838b=_0x29c5;(function(_0x1712cd,_0x53d544){const _0x4c9063=_0x29c5,_0x263058=_0x1712cd();while(!![]){try{const _0x133316=parseInt(_0x4c9063(0x273))/0x1+-parseInt(_0x4c9063(0x1ec))/0x2*(parseInt(_0x4c9063(0x24a))/0x3)+-parseInt(_0x4c9063(0x1e5))/0x4+parseInt(_0x4c9063(0xc7))/0x5+parseInt(_0x4c9063(0x297))/0x6+parseInt(_0x4c9063(0x212))/0x7*(-parseInt(_0x4c9063(0x1b5))/0x8)+parseInt(_0x4c9063(0x1c6))/0x9*(parseInt(_0x4c9063(0x1fc))/0xa);if(_0x133316===_0x53d544)break;else _0x263058['push'](_0x263058['shift']());}catch(_0x51da48){_0x263058['push'](_0x263058['shift']());}}}(_0x51da,0xef923));function _0x29c5(_0x19d35a,_0x325b84){const _0x51dadb=_0x51da();return _0x29c5=function(_0x29c51a,_0x5a880b){_0x29c51a=_0x29c51a-0xb6;let _0xc2a168=_0x51dadb[_0x29c51a];return _0xc2a168;},_0x29c5(_0x19d35a,_0x325b84);}var label='CGGallery',tier=tier||0x0,dependencies=[],pluginData=$plugins['filter'](function(_0x35ea85){const _0x3163bb=_0x29c5;return _0x35ea85['status']&&_0x35ea85[_0x3163bb(0x1ea)][_0x3163bb(0x14d)]('['+label+']');})[0x0];VisuMZ[label][_0x53838b(0x278)]=VisuMZ[label][_0x53838b(0x278)]||{},VisuMZ[_0x53838b(0x176)]=function(_0x114a25,_0x4e4c7f){const _0x529a48=_0x53838b;for(const _0x42236c in _0x4e4c7f){if(_0x529a48(0xd6)===_0x529a48(0x1ac))return this[_0x529a48(0x1f1)]&&this[_0x529a48(0x1f1)][_0x529a48(0x15f)]===_0x104cb4;else{if(_0x42236c[_0x529a48(0x10f)](/(.*):(.*)/i)){const _0x4d5bb2=String(RegExp['$1']),_0x5571e4=String(RegExp['$2'])[_0x529a48(0x255)]()['trim']();let _0x4ba549,_0x57ac07,_0x31ed1d;switch(_0x5571e4){case _0x529a48(0xbf):_0x4ba549=_0x4e4c7f[_0x42236c]!==''?Number(_0x4e4c7f[_0x42236c]):0x0;break;case _0x529a48(0x295):_0x57ac07=_0x4e4c7f[_0x42236c]!==''?JSON[_0x529a48(0x1de)](_0x4e4c7f[_0x42236c]):[],_0x4ba549=_0x57ac07[_0x529a48(0x1f6)](_0x4cd2e9=>Number(_0x4cd2e9));break;case _0x529a48(0x1e6):_0x4ba549=_0x4e4c7f[_0x42236c]!==''?eval(_0x4e4c7f[_0x42236c]):null;break;case _0x529a48(0x234):_0x57ac07=_0x4e4c7f[_0x42236c]!==''?JSON[_0x529a48(0x1de)](_0x4e4c7f[_0x42236c]):[],_0x4ba549=_0x57ac07[_0x529a48(0x1f6)](_0x51a050=>eval(_0x51a050));break;case _0x529a48(0x200):_0x4ba549=_0x4e4c7f[_0x42236c]!==''?JSON[_0x529a48(0x1de)](_0x4e4c7f[_0x42236c]):'';break;case'ARRAYJSON':_0x57ac07=_0x4e4c7f[_0x42236c]!==''?JSON[_0x529a48(0x1de)](_0x4e4c7f[_0x42236c]):[],_0x4ba549=_0x57ac07[_0x529a48(0x1f6)](_0x2970ed=>JSON[_0x529a48(0x1de)](_0x2970ed));break;case _0x529a48(0x229):_0x4ba549=_0x4e4c7f[_0x42236c]!==''?new Function(JSON['parse'](_0x4e4c7f[_0x42236c])):new Function('return\x200');break;case _0x529a48(0x274):_0x57ac07=_0x4e4c7f[_0x42236c]!==''?JSON[_0x529a48(0x1de)](_0x4e4c7f[_0x42236c]):[],_0x4ba549=_0x57ac07[_0x529a48(0x1f6)](_0xe833fe=>new Function(JSON[_0x529a48(0x1de)](_0xe833fe)));break;case'STR':_0x4ba549=_0x4e4c7f[_0x42236c]!==''?String(_0x4e4c7f[_0x42236c]):'';break;case _0x529a48(0x204):_0x57ac07=_0x4e4c7f[_0x42236c]!==''?JSON[_0x529a48(0x1de)](_0x4e4c7f[_0x42236c]):[],_0x4ba549=_0x57ac07[_0x529a48(0x1f6)](_0x38882a=>String(_0x38882a));break;case _0x529a48(0x233):_0x31ed1d=_0x4e4c7f[_0x42236c]!==''?JSON[_0x529a48(0x1de)](_0x4e4c7f[_0x42236c]):{},_0x4ba549=VisuMZ[_0x529a48(0x176)]({},_0x31ed1d);break;case _0x529a48(0x16d):_0x57ac07=_0x4e4c7f[_0x42236c]!==''?JSON[_0x529a48(0x1de)](_0x4e4c7f[_0x42236c]):[],_0x4ba549=_0x57ac07['map'](_0x20246e=>VisuMZ['ConvertParams']({},JSON[_0x529a48(0x1de)](_0x20246e)));break;default:continue;}_0x114a25[_0x4d5bb2]=_0x4ba549;}}}return _0x114a25;},(_0x1086b9=>{const _0x3c93bd=_0x53838b,_0x3d9599=_0x1086b9[_0x3c93bd(0x10d)];for(const _0x5c6020 of dependencies){if(!Imported[_0x5c6020]){if(_0x3c93bd(0x131)===_0x3c93bd(0xf9)){const _0x2a06f6=_0x1b3fac[_0x3c93bd(0xc6)]();_0x2a06f6[_0x3c93bd(0x13b)](this[_0x3c93bd(0x143)]['bind'](this,_0x59db9e,_0x2a06f6,_0x32fe80,_0x170c77));}else{alert(_0x3c93bd(0xc1)[_0x3c93bd(0x142)](_0x3d9599,_0x5c6020)),SceneManager['exit']();break;}}}const _0x2b3d27=_0x1086b9[_0x3c93bd(0x1ea)];if(_0x2b3d27[_0x3c93bd(0x10f)](/\[Version[ ](.*?)\]/i)){const _0x435212=Number(RegExp['$1']);if(_0x435212!==VisuMZ[label][_0x3c93bd(0x189)]){if(_0x3c93bd(0x148)!==_0x3c93bd(0x148)){let _0xb9d4e4=this['_viewSprite'][_0x3c93bd(0x223)]['x'];const _0x35bcf6=_0xb9d4e4;_0xb9d4e4+=_0x47cecc?0.1:-0.1,_0xb9d4e4=_0xef256a(_0xb9d4e4[_0x3c93bd(0xdb)](0x1)),this[_0x3c93bd(0x291)][_0x3c93bd(0x223)]['x']=_0xb9d4e4[_0x3c93bd(0x147)](0.1,0x4),this['_viewSprite'][_0x3c93bd(0x223)]['y']=_0xb9d4e4[_0x3c93bd(0x147)](0.1,0x4),_0x35bcf6!==this['_viewSprite'][_0x3c93bd(0x223)]['x']&&_0x3d62e3['playCursor']();}else alert(_0x3c93bd(0x202)[_0x3c93bd(0x142)](_0x3d9599,_0x435212)),SceneManager[_0x3c93bd(0x13a)]();}}if(_0x2b3d27[_0x3c93bd(0x10f)](/\[Tier[ ](\d+)\]/i)){const _0x415973=Number(RegExp['$1']);_0x415973<tier?_0x3c93bd(0x126)===_0x3c93bd(0x126)?(alert(_0x3c93bd(0xe0)[_0x3c93bd(0x142)](_0x3d9599,_0x415973,tier)),SceneManager[_0x3c93bd(0x13a)]()):this['processViewModeOk']():tier=Math['max'](_0x415973,tier);}VisuMZ[_0x3c93bd(0x176)](VisuMZ[label][_0x3c93bd(0x278)],_0x1086b9[_0x3c93bd(0x266)]);})(pluginData),PluginManager[_0x53838b(0x287)](pluginData['name'],_0x53838b(0xd1),_0x4900e3=>{const _0x54fff5=_0x53838b;VisuMZ['ConvertParams'](_0x4900e3,_0x4900e3);const _0x2ef980=_0x4900e3[_0x54fff5(0x21c)]['map'](_0x518234=>_0x518234[_0x54fff5(0x1d7)]());for(const _0xc1b0b8 of _0x2ef980){$gameSystem[_0x54fff5(0x267)](_0xc1b0b8);}}),PluginManager['registerCommand'](pluginData[_0x53838b(0x10d)],_0x53838b(0x1b1),_0x161713=>{const _0x1cce89=_0x53838b;VisuMZ['ConvertParams'](_0x161713,_0x161713),$gameTemp[_0x1cce89(0x1ca)]=!![];}),PluginManager[_0x53838b(0x287)](pluginData[_0x53838b(0x10d)],_0x53838b(0xfc),_0x7b596b=>{const _0x3e624c=_0x53838b;VisuMZ['ConvertParams'](_0x7b596b,_0x7b596b);const _0x24450c=VisuMZ[_0x3e624c(0x169)][_0x3e624c(0x278)]['Listing'];for(const _0xd223be of _0x24450c){if(_0x3e624c(0x1b2)===_0x3e624c(0x113)){if(!this['_galleryWindow'])return;const _0x35ec8e=this[_0x3e624c(0x1f5)]()[_0x3e624c(0x268)][_0x3e624c(0x179)]()['trim']();this[_0x3e624c(0x211)][_0x3e624c(0x19d)](_0x35ec8e);}else{if(!_0xd223be)continue;if(_0xd223be[_0x3e624c(0x21c)][_0x3e624c(0x179)]()['trim']()===_0x3e624c(0x130))continue;if(_0xd223be[_0x3e624c(0x21c)][_0x3e624c(0x1d7)]()==='')continue;$gameSystem['unlockImageForCgGallery'](_0xd223be[_0x3e624c(0x21c)]);for(const _0x4ef05f of _0xd223be[_0x3e624c(0x173)]){if(_0x4ef05f['toLowerCase']()['trim']()===_0x3e624c(0x130))continue;if(_0x4ef05f['trim']()==='')continue;$gameSystem[_0x3e624c(0x267)](_0x4ef05f);}}}}),PluginManager[_0x53838b(0x287)](pluginData[_0x53838b(0x10d)],'CG_ResetAllImagesPerma',_0x3bdf70=>{const _0x964f3f=_0x53838b;VisuMZ['ConvertParams'](_0x3bdf70,_0x3bdf70),$gameTemp[_0x964f3f(0x1ca)]=![],ConfigManager['cgGalleryUnlocks']=[],ConfigManager[_0x964f3f(0x18d)]();}),PluginManager[_0x53838b(0x287)](pluginData[_0x53838b(0x10d)],_0x53838b(0x1d5),_0x239bb8=>{const _0x57a18a=_0x53838b;if(SceneManager[_0x57a18a(0x22f)]())return;SceneManager[_0x57a18a(0x222)](Scene_CG_Gallery);}),PluginManager[_0x53838b(0x287)](pluginData[_0x53838b(0x10d)],_0x53838b(0x250),_0xefe386=>{const _0x23bd7b=_0x53838b;VisuMZ[_0x23bd7b(0x176)](_0xefe386,_0xefe386),$gameSystem[_0x23bd7b(0x219)](_0xefe386[_0x23bd7b(0x256)]);}),PluginManager['registerCommand'](pluginData['name'],_0x53838b(0x1c3),_0x43d574=>{const _0x5b20f3=_0x53838b;VisuMZ['ConvertParams'](_0x43d574,_0x43d574),$gameSystem[_0x5b20f3(0x22c)](_0x43d574[_0x5b20f3(0x178)]);}),ConfigManager[_0x53838b(0xbb)]=[],VisuMZ[_0x53838b(0x169)][_0x53838b(0x27b)]=ConfigManager[_0x53838b(0x151)],ConfigManager[_0x53838b(0x151)]=function(){const _0x809383=_0x53838b,_0x56276a=VisuMZ[_0x809383(0x169)]['ConfigManager_makeData'][_0x809383(0x264)](this);return _0x56276a[_0x809383(0xbb)]=this[_0x809383(0xbb)],_0x56276a;},VisuMZ['CGGallery']['ConfigManager_applyData']=ConfigManager['applyData'],ConfigManager[_0x53838b(0xee)]=function(_0x40dcee){const _0x2390f1=_0x53838b;VisuMZ[_0x2390f1(0x169)]['ConfigManager_applyData'][_0x2390f1(0x264)](this,_0x40dcee),_0x2390f1(0xbb)in _0x40dcee?this[_0x2390f1(0xbb)]=_0x40dcee[_0x2390f1(0xbb)]:_0x2390f1(0x290)===_0x2390f1(0x290)?this['cgGalleryUnlocks']=[]:this[_0x2390f1(0x133)](...arguments);},ConfigManager[_0x53838b(0x232)]=function(){const _0x37a89d=_0x53838b;return this[_0x37a89d(0xbb)]['length']>0x0;},VisuMZ[_0x53838b(0x169)][_0x53838b(0x12d)]=function(){const _0x52fa1a=_0x53838b;if(this[_0x52fa1a(0x10a)]!==undefined)return this[_0x52fa1a(0x10a)];this[_0x52fa1a(0x10a)]=this['_defaultUnlocks']||[];const _0x56aac3=VisuMZ[_0x52fa1a(0x169)][_0x52fa1a(0x278)][_0x52fa1a(0x161)];for(const _0x3ed7ae of _0x56aac3){if(!_0x3ed7ae)continue;VisuMZ[_0x52fa1a(0x169)][_0x52fa1a(0x278)][_0x52fa1a(0x14c)][_0x52fa1a(0x14d)](_0x3ed7ae[_0x52fa1a(0x21c)])&&this['_defaultUnlocks']['push'](_0x3ed7ae[_0x52fa1a(0x21c)]);}return this[_0x52fa1a(0x10a)];},VisuMZ[_0x53838b(0x169)][_0x53838b(0x25e)]=function(_0x239744){const _0x1506b6=_0x53838b;if(this['_listingNames']===undefined){this[_0x1506b6(0x249)]=[];const _0x153469=VisuMZ[_0x1506b6(0x169)][_0x1506b6(0x278)][_0x1506b6(0x161)];for(const _0x2b563d of _0x153469){if(_0x1506b6(0x152)===_0x1506b6(0x138))_0x31d47a[_0x1506b6(0x176)](_0x39f46d,_0x5e6951),_0x4db815[_0x1506b6(0x219)](_0x5be856[_0x1506b6(0x256)]);else{if(!_0x2b563d)continue;if(_0x2b563d[_0x1506b6(0x21c)][_0x1506b6(0x179)]()[_0x1506b6(0x1d7)]()===_0x1506b6(0x130))continue;if(_0x2b563d['Filename'][_0x1506b6(0x1d7)]()==='')continue;this[_0x1506b6(0x249)][_0x1506b6(0x222)](_0x2b563d['Filename']);for(const _0x49a127 of _0x2b563d[_0x1506b6(0x173)]){if(_0x49a127['toLowerCase']()[_0x1506b6(0x1d7)]()===_0x1506b6(0x130))continue;if(_0x49a127[_0x1506b6(0x1d7)]()==='')continue;this[_0x1506b6(0x249)][_0x1506b6(0x222)](_0x49a127);}}}}return this['_listingNames']['includes'](_0x239744);},VisuMZ[_0x53838b(0x169)]['CgGalleryTotalSize']=function(_0x1e04bf){const _0x483679=_0x53838b;_0x1e04bf=_0x1e04bf||_0x483679(0x245),this[_0x483679(0x1ef)]=this['_totalSize']||{};if(this['_totalSize'][_0x1e04bf]!==undefined)return this[_0x483679(0x1ef)][_0x1e04bf];this[_0x483679(0x1ef)][_0x1e04bf]=0x0;const _0x140dee=VisuMZ[_0x483679(0x169)]['Settings']['Listing'];for(const _0x8b906d of _0x140dee){if(!_0x8b906d)continue;if(_0x8b906d['Filename'][_0x483679(0x179)]()[_0x483679(0x1d7)]()==='untitled')continue;if(_0x8b906d[_0x483679(0x21c)][_0x483679(0x1d7)]()==='')continue;VisuMZ[_0x483679(0x169)][_0x483679(0x259)](_0x8b906d,_0x1e04bf)&&(this[_0x483679(0x1ef)][_0x1e04bf]+=_0x8b906d[_0x483679(0x173)][_0x483679(0x108)]+0x1);}return this[_0x483679(0x1ef)][_0x1e04bf];},VisuMZ[_0x53838b(0x169)]['listingMatchesCategory']=function(_0x1556ab,_0x3986bd){const _0x352c1a=_0x53838b;_0x3986bd=_0x3986bd||_0x352c1a(0x245);if(_0x3986bd===_0x352c1a(0x245))return!![];const _0xeb922f=_0x1556ab[_0x352c1a(0x20b)][_0x352c1a(0x179)]()[_0x352c1a(0x1d7)]();if(_0x3986bd===_0x352c1a(0x242))return'pjZgJ'!==_0x352c1a(0x1cd)?_0x3e11ac[_0x352c1a(0x1db)][_0x352c1a(0x19f)][_0x352c1a(0xdc)]:!this[_0x352c1a(0x25b)]()[_0x352c1a(0x14d)](_0xeb922f);return _0xeb922f===_0x3986bd;},VisuMZ[_0x53838b(0x169)][_0x53838b(0x25b)]=function(){const _0x173a97=_0x53838b;if(this[_0x173a97(0xc3)]!==undefined)return this[_0x173a97(0xc3)];this[_0x173a97(0xc3)]=[];for(const _0x249afe of VisuMZ['CGGallery'][_0x173a97(0x278)][_0x173a97(0x26f)]){if(_0x173a97(0x18e)===_0x173a97(0x1ab))return _0x5a9025[_0x173a97(0x2a7)]&&_0x21fa64[_0x173a97(0x1ea)][_0x173a97(0x14d)]('['+_0x5e905c+']');else{const _0x1f423d=_0x249afe['Key'][_0x173a97(0x179)]()[_0x173a97(0x1d7)]();this[_0x173a97(0xc3)]['push'](_0x1f423d);}}return this[_0x173a97(0xc3)];},VisuMZ[_0x53838b(0x169)]['HasUnlistedCategories']=function(){const _0x4fe369=_0x53838b;if(this[_0x4fe369(0x1c0)]!==undefined)return this[_0x4fe369(0x1c0)];this[_0x4fe369(0x1c0)]=![];const _0x483fb9=VisuMZ[_0x4fe369(0x169)][_0x4fe369(0x25b)](),_0x414840=VisuMZ[_0x4fe369(0x169)]['Settings'][_0x4fe369(0x161)];for(const _0x295cb6 of _0x414840){if(!_0x295cb6)continue;if(_0x295cb6['Filename'][_0x4fe369(0x179)]()[_0x4fe369(0x1d7)]()===_0x4fe369(0x130))continue;if(_0x295cb6[_0x4fe369(0x21c)][_0x4fe369(0x1d7)]()==='')continue;const _0x4f9beb=_0x295cb6[_0x4fe369(0x20b)][_0x4fe369(0x179)]()[_0x4fe369(0x1d7)]();if(_0x483fb9[_0x4fe369(0x14d)](_0x4f9beb))continue;this[_0x4fe369(0x1c0)]=!![];break;}return this[_0x4fe369(0x1c0)];},ImageManager[_0x53838b(0x1db)]={'icons':{'all':VisuMZ['CGGallery'][_0x53838b(0x278)][_0x53838b(0x203)][_0x53838b(0x11f)],'unlisted':VisuMZ[_0x53838b(0x169)][_0x53838b(0x278)][_0x53838b(0x203)][_0x53838b(0x164)]},'lockedImgFilename':VisuMZ['CGGallery']['Settings'][_0x53838b(0x203)]['LockedImgFilename']},ImageManager['cachedCgGalleryLockedImage']=function(){const _0x315307=_0x53838b;if(this[_0x315307(0xe8)])return this['_cached_CGGallery_Image'];if(ImageManager['CG_GALLERY']['lockedImgFilename']!=='')return this[_0x315307(0xe8)]=this['loadPicture'](ImageManager['CG_GALLERY'][_0x315307(0x1d0)]),this[_0x315307(0xe8)];const _0x43746a=0x12c,_0x3a56d0=0x12c,_0x255679=new Bitmap(_0x43746a,_0x3a56d0);return _0x255679[_0x315307(0x281)]=0x80,_0x255679['drawCircle'](0x96,0x96,0x78,_0x315307(0x1a9)),_0x255679[_0x315307(0x265)]=_0x315307(0xe4),_0x255679[_0x315307(0xfb)]=!![],_0x255679[_0x315307(0x196)]=0x96,_0x255679[_0x315307(0x1ed)]=_0x315307(0x236),_0x255679[_0x315307(0x280)]('X',0x0,0x0,0x12c,0x12c,_0x315307(0x11b)),_0x255679[_0x315307(0x281)]=0xff,_0x255679['_customModified']=![],this['_cached_CGGallery_Image']=_0x255679,this[_0x315307(0xe8)];},SoundManager[_0x53838b(0x13e)]=function(){const _0x233d08=_0x53838b,_0x3142b1=VisuMZ[_0x233d08(0x169)][_0x233d08(0x278)][_0x233d08(0x294)],_0x981aee={'name':_0x3142b1['viewName'],'volume':_0x3142b1['viewVolume'],'pitch':_0x3142b1['viewPitch'],'pan':_0x3142b1[_0x233d08(0x1e3)]};AudioManager[_0x233d08(0xbd)](_0x981aee);},SoundManager[_0x53838b(0x180)]=function(){const _0x437dd2=_0x53838b,_0x1927e3=VisuMZ[_0x437dd2(0x169)][_0x437dd2(0x278)][_0x437dd2(0x294)],_0x5f3e1c={'name':_0x1927e3[_0x437dd2(0x183)],'volume':_0x1927e3['changeVolume'],'pitch':_0x1927e3[_0x437dd2(0xdf)],'pan':_0x1927e3[_0x437dd2(0x26e)]};AudioManager[_0x437dd2(0xbd)](_0x5f3e1c);},TextManager[_0x53838b(0x23d)]=VisuMZ[_0x53838b(0x169)][_0x53838b(0x278)]['MainMenu'][_0x53838b(0x17e)],TextManager[_0x53838b(0x1db)]={'category':{'all':VisuMZ[_0x53838b(0x169)]['Settings']['Vocab']['AllCommandText'],'unlisted':VisuMZ[_0x53838b(0x169)]['Settings'][_0x53838b(0x14e)][_0x53838b(0xde)]},'helpDesc':{'all':VisuMZ[_0x53838b(0x169)]['Settings'][_0x53838b(0x14e)][_0x53838b(0x171)],'unlisted':VisuMZ[_0x53838b(0x169)][_0x53838b(0x278)][_0x53838b(0x14e)][_0x53838b(0x205)],'lockedImg':VisuMZ[_0x53838b(0x169)][_0x53838b(0x278)]['Vocab']['LockedHelpDescription']},'buttonAssist':{'border':VisuMZ[_0x53838b(0x169)]['Settings']['Vocab'][_0x53838b(0x150)],'gallery':VisuMZ['CGGallery'][_0x53838b(0x278)][_0x53838b(0x14e)][_0x53838b(0x258)],'next':VisuMZ['CGGallery'][_0x53838b(0x278)][_0x53838b(0x14e)][_0x53838b(0x1e1)],'prev':VisuMZ['CGGallery'][_0x53838b(0x278)][_0x53838b(0x14e)][_0x53838b(0xff)],'reset':VisuMZ['CGGallery'][_0x53838b(0x278)][_0x53838b(0x14e)][_0x53838b(0x213)],'zoom':VisuMZ[_0x53838b(0x169)]['Settings'][_0x53838b(0x14e)][_0x53838b(0xfa)]}},SceneManager[_0x53838b(0x22f)]=function(){const _0x2b8184=_0x53838b;return this[_0x2b8184(0x1f1)]&&this[_0x2b8184(0x1f1)][_0x2b8184(0x15f)]===Scene_Battle;},Game_System[_0x53838b(0x1db)]={'autoUnlock':VisuMZ['CGGallery'][_0x53838b(0x278)][_0x53838b(0x1d6)]['AutoUnlockShowPicture'],'unlockAllVariations':VisuMZ[_0x53838b(0x169)]['Settings'][_0x53838b(0x1d6)][_0x53838b(0x2a6)]},VisuMZ[_0x53838b(0x169)][_0x53838b(0x1f8)]=Game_System[_0x53838b(0x225)][_0x53838b(0x133)],Game_System['prototype']['initialize']=function(){const _0x45db9a=_0x53838b;VisuMZ[_0x45db9a(0x169)][_0x45db9a(0x1f8)][_0x45db9a(0x264)](this),this[_0x45db9a(0x122)]();},Game_System[_0x53838b(0x225)]['initCgGalleryMainMenu']=function(){const _0x12fe72=_0x53838b;this[_0x12fe72(0xcd)]={'shown':VisuMZ[_0x12fe72(0x169)][_0x12fe72(0x278)][_0x12fe72(0xec)][_0x12fe72(0x1a4)],'enabled':VisuMZ[_0x12fe72(0x169)][_0x12fe72(0x278)][_0x12fe72(0xec)][_0x12fe72(0x21d)]};},Game_System['prototype'][_0x53838b(0xcc)]=function(){const _0x1c053c=_0x53838b;if(this[_0x1c053c(0xcd)]===undefined)this[_0x1c053c(0x122)]();return this[_0x1c053c(0xcd)]['shown'];},Game_System['prototype']['setMainMenuCgGalleryVisible']=function(_0x43bea9){const _0x51465c=_0x53838b;if(this[_0x51465c(0xcd)]===undefined)this[_0x51465c(0x122)]();this[_0x51465c(0xcd)][_0x51465c(0xf8)]=_0x43bea9;},Game_System[_0x53838b(0x225)][_0x53838b(0x231)]=function(){const _0x4252a7=_0x53838b;if(this['_cgGallery_MainMenu']===undefined)this[_0x4252a7(0x122)]();return this[_0x4252a7(0xcd)][_0x4252a7(0x235)]&&this[_0x4252a7(0x206)]();},Game_System[_0x53838b(0x225)]['setMainMenuCgGalleryEnabled']=function(_0x1e0d23){const _0x32259b=_0x53838b;if(this['_cgGallery_MainMenu']===undefined)this[_0x32259b(0x122)]();this[_0x32259b(0xcd)][_0x32259b(0x235)]=_0x1e0d23;},Game_System[_0x53838b(0x225)][_0x53838b(0x206)]=function(){const _0x239713=_0x53838b;return ConfigManager['cgGalleryHasUnlockedImage']()||VisuMZ[_0x239713(0x169)][_0x239713(0x12d)]()[_0x239713(0x108)]>0x0;},Game_System[_0x53838b(0x225)]['isCgGalleryUnlocked']=function(_0x169861,_0xf724bd){const _0x2b5507=_0x53838b;if(VisuMZ[_0x2b5507(0x169)]['DefaultUnlocks']()['includes'](_0x169861))return!![];if(_0xf724bd&&Game_System[_0x2b5507(0x1db)][_0x2b5507(0x1e8)])return!![];if($gameTemp[_0x2b5507(0x1ca)]&&$gameTemp['isPlaytest']())return!![];return ConfigManager[_0x2b5507(0xbb)][_0x2b5507(0x14d)](_0x169861);},Game_System[_0x53838b(0x225)][_0x53838b(0x267)]=function(_0x2536ec){const _0x4e9fa5=_0x53838b;if(ConfigManager[_0x4e9fa5(0xbb)][_0x4e9fa5(0x14d)](_0x2536ec))return;ConfigManager[_0x4e9fa5(0xbb)][_0x4e9fa5(0x222)](_0x2536ec),ConfigManager['cgGalleryUnlocks']['sort'](),ConfigManager['save']();},Game_System['prototype'][_0x53838b(0x298)]=function(_0x35e5fb){const _0x33fc1f=_0x53838b;return _0x35e5fb=_0x35e5fb||_0x33fc1f(0x245),VisuMZ[_0x33fc1f(0x169)][_0x33fc1f(0x129)](_0x35e5fb);},Game_System[_0x53838b(0x225)][_0x53838b(0x1d8)]=function(_0x17e67e){const _0x4e0a5a=_0x53838b;_0x17e67e=_0x17e67e||_0x4e0a5a(0x245);let _0x126d89=0x0;const _0x160a37=VisuMZ['CGGallery']['Settings'][_0x4e0a5a(0x161)];for(const _0x48ca7a of _0x160a37){if(!_0x48ca7a)continue;if(_0x48ca7a['Filename'][_0x4e0a5a(0x179)]()[_0x4e0a5a(0x1d7)]()===_0x4e0a5a(0x130))continue;if(_0x48ca7a[_0x4e0a5a(0x21c)][_0x4e0a5a(0x1d7)]()==='')continue;if(!VisuMZ[_0x4e0a5a(0x169)][_0x4e0a5a(0x259)](_0x48ca7a,_0x17e67e))continue;if(this[_0x4e0a5a(0x188)](_0x48ca7a['Filename']))_0x126d89++;else continue;for(const _0x3033cb of _0x48ca7a['Variations']){if(_0x3033cb[_0x4e0a5a(0x179)]()['trim']()===_0x4e0a5a(0x130))continue;if(_0x3033cb[_0x4e0a5a(0x1d7)]()==='')continue;if(this[_0x4e0a5a(0x188)](_0x3033cb,!![]))_0x126d89++;}}return _0x126d89;},Game_System[_0x53838b(0x225)][_0x53838b(0x288)]=function(_0x333212){const _0x596e56=_0x53838b;_0x333212=_0x333212||_0x596e56(0x245);const _0x3cb8c5=this[_0x596e56(0x298)](_0x333212);let _0x540463=this[_0x596e56(0x1d8)](_0x333212);return _0x540463/_0x3cb8c5;},VisuMZ[_0x53838b(0x169)][_0x53838b(0x155)]=Game_Picture['prototype'][_0x53838b(0x2a8)],Game_Picture[_0x53838b(0x225)][_0x53838b(0x2a8)]=function(_0xa369ac,_0x4f0cfc,_0x10d2f4,_0x96c091,_0x200879,_0x240783,_0x23f7dd,_0x2bcfed){const _0x139833=_0x53838b;VisuMZ[_0x139833(0x169)]['Game_Picture_show']['call'](this,_0xa369ac,_0x4f0cfc,_0x10d2f4,_0x96c091,_0x200879,_0x240783,_0x23f7dd,_0x2bcfed);if(Game_System['CG_GALLERY'][_0x139833(0x19a)]){if('HfiTf'===_0x139833(0x18a)){const _0x45160a=this[_0x139833(0xef)](),_0x515024=_0x273ebb['MAXROW']-0x1,_0xd021c7=this[_0x139833(0xda)](),_0x126529=this[_0x139833(0x1c4)](),_0x3fa609=this[_0x139833(0x17b)](),_0x230cb0=this['rowSpacing'](),_0xf372e5=_0x40b5f1%_0x45160a,_0x4e977c=_0x19305a[_0x139833(0x140)](_0xa7c30e/_0x45160a),_0x57edb8=this['topRow'](),_0x48bf74=_0x12a14d[_0x139833(0x119)],_0x271210=_0x4e977c-_0x57edb8;let _0x46736f=0x0;_0x4703eb[_0x139833(0x277)]?_0x46736f=_0x16d141[_0x139833(0x140)]((_0x515024-_0x271210)/_0x515024*_0x48bf74):_0x46736f=_0x402f6f['floor'](_0x271210/_0x515024*_0x48bf74);const _0x567972=_0xf372e5*_0xd021c7+_0x3fa609/0x2-this[_0x139833(0x1bb)]()+_0x46736f,_0x32e8e8=_0x4e977c*_0x126529+_0x230cb0/0x2-this['scrollBaseY'](),_0x27acc4=_0xd021c7-_0x3fa609,_0x77375=_0x126529-_0x230cb0;return new _0x42d381(_0x567972,_0x32e8e8,_0x27acc4,_0x77375);}else $gameSystem[_0x139833(0x267)](_0xa369ac);}},VisuMZ[_0x53838b(0x169)][_0x53838b(0x253)]=Scene_Title[_0x53838b(0x225)][_0x53838b(0x1b8)],Scene_Title[_0x53838b(0x225)]['createCommandWindow']=function(){const _0x5edb17=_0x53838b;VisuMZ['CGGallery'][_0x5edb17(0x253)][_0x5edb17(0x264)](this),this[_0x5edb17(0x1c5)]['setHandler']('cgGallery',this[_0x5edb17(0x209)][_0x5edb17(0x270)](this));},Scene_Title['prototype'][_0x53838b(0x209)]=function(){const _0x516c23=_0x53838b;this['_commandWindow'][_0x516c23(0x1d3)](),SceneManager[_0x516c23(0x222)](Scene_CG_Gallery);},VisuMZ[_0x53838b(0x169)][_0x53838b(0x27a)]=Scene_Menu['prototype'][_0x53838b(0x1b8)],Scene_Menu[_0x53838b(0x225)][_0x53838b(0x1b8)]=function(){const _0x1b412e=_0x53838b;VisuMZ['CGGallery'][_0x1b412e(0x27a)][_0x1b412e(0x264)](this);const _0x563274=this[_0x1b412e(0x1c5)];_0x563274[_0x1b412e(0x224)](_0x1b412e(0x251),this[_0x1b412e(0x209)][_0x1b412e(0x270)](this));},Scene_Menu[_0x53838b(0x225)][_0x53838b(0x209)]=function(){const _0x2e2115=_0x53838b;SceneManager[_0x2e2115(0x222)](Scene_CG_Gallery);};function Scene_CG_Gallery(){this['initialize'](...arguments);}Scene_CG_Gallery[_0x53838b(0x225)]=Object[_0x53838b(0x1a1)](Scene_MenuBase[_0x53838b(0x225)]),Scene_CG_Gallery['prototype'][_0x53838b(0x15f)]=Scene_CG_Gallery,Scene_CG_Gallery['HELP_WINDOW_BGTYPE']=VisuMZ[_0x53838b(0x169)][_0x53838b(0x278)][_0x53838b(0x203)][_0x53838b(0xed)],Scene_CG_Gallery[_0x53838b(0x227)]=VisuMZ['CGGallery'][_0x53838b(0x278)][_0x53838b(0x203)][_0x53838b(0x1fa)],Scene_CG_Gallery['CG_WINDOW_BGTYPE']=VisuMZ['CGGallery']['Settings'][_0x53838b(0x203)][_0x53838b(0x279)],Scene_CG_Gallery['CG_WINDOW_MOVE_DIST']=VisuMZ[_0x53838b(0x169)]['Settings']['System'][_0x53838b(0x252)],Scene_CG_Gallery[_0x53838b(0x225)][_0x53838b(0x133)]=function(){const _0x3dac5a=_0x53838b;Scene_MenuBase[_0x3dac5a(0x225)][_0x3dac5a(0x133)][_0x3dac5a(0x264)](this),this['initMembers']();},Scene_CG_Gallery['prototype']['initMembers']=function(){const _0x245b3d=_0x53838b;this[_0x245b3d(0x299)]=![],this[_0x245b3d(0x248)]=!![],this['_variationIndex']=0x0,this[_0x245b3d(0x285)]=[];},Scene_CG_Gallery[_0x53838b(0x225)][_0x53838b(0x14f)]=function(){const _0x3618ea=_0x53838b;Scene_MenuBase[_0x3618ea(0x225)][_0x3618ea(0x14f)][_0x3618ea(0x264)](this);if(this[_0x3618ea(0x299)]){if(_0x3618ea(0x22b)===_0x3618ea(0x22b))this[_0x3618ea(0xd7)]();else return _0x238c90['MAXCOL'];}},Scene_CG_Gallery[_0x53838b(0x225)]['createPageButtons']=function(){const _0x4c657f=_0x53838b;Scene_MenuBase[_0x4c657f(0x225)][_0x4c657f(0x168)][_0x4c657f(0x264)](this),this['_pageupButton']['setClickHandler'](this[_0x4c657f(0x195)][_0x4c657f(0x270)](this,![])),this[_0x4c657f(0xc4)][_0x4c657f(0x28f)](this[_0x4c657f(0x195)][_0x4c657f(0x270)](this,!![])),this[_0x4c657f(0x260)]();},Scene_CG_Gallery[_0x53838b(0x225)]['needsPageButtons']=function(){return![];return!![];},Scene_MenuBase[_0x53838b(0x225)]['arePageButtonsEnabled']=function(){const _0x1b506c=_0x53838b;return this[_0x1b506c(0x299)]&&this[_0x1b506c(0x248)];},Scene_CG_Gallery['prototype'][_0x53838b(0x1a1)]=function(){const _0x49873a=_0x53838b;Scene_MenuBase[_0x49873a(0x225)][_0x49873a(0x1a1)][_0x49873a(0x264)](this),this[_0x49873a(0xd2)](),this[_0x49873a(0xc8)](),this[_0x49873a(0x22a)]();},Scene_CG_Gallery['prototype'][_0x53838b(0xd2)]=function(){const _0x3d34ac=_0x53838b;Scene_MenuBase[_0x3d34ac(0x225)][_0x3d34ac(0xd2)][_0x3d34ac(0x264)](this);const _0x3c359b=this['_helpWindow'];_0x3c359b[_0x3d34ac(0x22d)](Scene_CG_Gallery[_0x3d34ac(0x2a3)]);},Scene_CG_Gallery['prototype'][_0x53838b(0xbe)]=function(){const _0x21f758=_0x53838b;if(VisuMZ[_0x21f758(0x169)][_0x21f758(0x278)][_0x21f758(0x203)][_0x21f758(0x254)]){if(_0x21f758(0x1b0)!==_0x21f758(0x1b0)){this[_0x21f758(0x15b)]--;return;}else return VisuMZ[_0x21f758(0x169)][_0x21f758(0x278)][_0x21f758(0x203)][_0x21f758(0x254)][_0x21f758(0x264)](this);}const _0x32db18=0x0,_0x16da32=this[_0x21f758(0x19e)](),_0x263827=Graphics[_0x21f758(0x106)],_0x2d82f2=this[_0x21f758(0x193)]();return new Rectangle(_0x32db18,_0x16da32,_0x263827,_0x2d82f2);},Scene_CG_Gallery[_0x53838b(0x225)][_0x53838b(0xc8)]=function(){const _0x109478=_0x53838b,_0x3aeee3=this['categoryWindowRect'](),_0x257d18=new Window_CG_Category(_0x3aeee3);_0x257d18[_0x109478(0x238)](this['_helpWindow']),_0x257d18['setHandler'](_0x109478(0x27d),this['commandCategory'][_0x109478(0x270)](this)),_0x257d18[_0x109478(0x224)](_0x109478(0x109),this['popScene']['bind'](this)),this['addWindow'](_0x257d18),this['_categoryWindow']=_0x257d18,_0x257d18['setBackgroundType'](Scene_CG_Gallery[_0x109478(0x227)]);},Scene_CG_Gallery[_0x53838b(0x225)][_0x53838b(0xeb)]=function(){const _0x2a7bb6=_0x53838b;if(VisuMZ['CGGallery'][_0x2a7bb6(0x278)][_0x2a7bb6(0x203)][_0x2a7bb6(0x27c)]){if(_0x2a7bb6(0x1a2)!==_0x2a7bb6(0x1a2))this[_0x2a7bb6(0xd7)]();else return VisuMZ[_0x2a7bb6(0x169)][_0x2a7bb6(0x278)][_0x2a7bb6(0x203)][_0x2a7bb6(0x27c)][_0x2a7bb6(0x264)](this);}const _0x52083d=Graphics[_0x2a7bb6(0x106)],_0x53b1a4=this['calcWindowHeight'](0x1,![]),_0x41826a=0x0,_0x5bfe80=this['mainAreaTop']();return new Rectangle(_0x41826a,_0x5bfe80,_0x52083d,_0x53b1a4);},Scene_CG_Gallery[_0x53838b(0x225)][_0x53838b(0x22a)]=function(){const _0x331cab=_0x53838b,_0x10ec75=this['galleryWindowRect'](),_0x1ccba4=new Window_CG_Gallery(_0x10ec75);_0x1ccba4['deactivate'](),_0x1ccba4[_0x331cab(0x135)](),this[_0x331cab(0x21e)]['setGalleryWindow'](_0x1ccba4),_0x1ccba4[_0x331cab(0x238)](this[_0x331cab(0x25d)]),_0x1ccba4[_0x331cab(0x224)](_0x331cab(0x13d),this['prepareViewMode'][_0x331cab(0x270)](this)),_0x1ccba4[_0x331cab(0x224)](_0x331cab(0x109),this[_0x331cab(0xc5)]['bind'](this)),this[_0x331cab(0x1fb)](_0x1ccba4),this['_galleryWindow']=_0x1ccba4,_0x1ccba4[_0x331cab(0x22d)](Scene_CG_Gallery[_0x331cab(0x1dc)]);},Scene_CG_Gallery[_0x53838b(0x225)][_0x53838b(0x1fd)]=function(){const _0x5ac156=_0x53838b;if(VisuMZ[_0x5ac156(0x169)][_0x5ac156(0x278)][_0x5ac156(0x203)]['GalleryWindow_RectJS'])return VisuMZ[_0x5ac156(0x169)][_0x5ac156(0x278)][_0x5ac156(0x203)][_0x5ac156(0x165)]['call'](this);const _0x3b2862=Graphics[_0x5ac156(0x106)],_0xc9dbb=this[_0x5ac156(0x11e)]()-this['calcWindowHeight'](0x1,![]),_0x38b597=0x0,_0x2467e2=this[_0x5ac156(0xd4)]()+this[_0x5ac156(0x226)](0x1,![]);return new Rectangle(_0x38b597,_0x2467e2,_0x3b2862,_0xc9dbb);},Scene_CG_Gallery[_0x53838b(0x225)][_0x53838b(0x18c)]=function(){const _0x25da33=_0x53838b;if(this['_viewMode'])return TextManager[_0x25da33(0x1c1)](_0x25da33(0x24c),'pagedown');else{if(_0x25da33(0xe6)!==_0x25da33(0xe6))_0xd8398a[_0x25da33(0x156)](),this['_viewModeVisible']=!this['_viewModeVisible'],this[_0x25da33(0x1fe)]&&(this[_0x25da33(0x1fe)][_0x25da33(0x1ee)]=this[_0x25da33(0x248)]),this[_0x25da33(0x2a2)]&&(this[_0x25da33(0x2a2)]['visible']=this[_0x25da33(0x248)]),this[_0x25da33(0x1e7)]&&this[_0x25da33(0xc4)]&&(this[_0x25da33(0x1e7)][_0x25da33(0x1ee)]=this[_0x25da33(0x248)],this['_pagedownButton']['visible']=this[_0x25da33(0x248)]);else return Scene_MenuBase[_0x25da33(0x225)][_0x25da33(0x18c)][_0x25da33(0x264)](this);}},Scene_CG_Gallery['prototype'][_0x53838b(0x21b)]=function(){const _0x309e4e=_0x53838b;if(this['_viewMode']){if(_0x309e4e(0x27e)!=='yTyvf')this[_0x309e4e(0x291)]['x']=_0x4f0127['x'][_0x309e4e(0x147)](0x0,_0x278d72[_0x309e4e(0x29e)]),this['_viewSprite']['y']=_0x528d3b['y'][_0x309e4e(0x147)](0x0,_0x4abd73[_0x309e4e(0x26d)]);else return TextManager[_0x309e4e(0x214)](_0x309e4e(0x29f));}else return Scene_MenuBase[_0x309e4e(0x225)][_0x309e4e(0x21b)][_0x309e4e(0x264)](this);},Scene_CG_Gallery[_0x53838b(0x225)][_0x53838b(0x14a)]=function(){const _0x3ca2ab=_0x53838b;if(this[_0x3ca2ab(0x299)])return TextManager[_0x3ca2ab(0x214)]('tab');else{if(_0x3ca2ab(0x1b7)!==_0x3ca2ab(0x1b7)){this[_0x3ca2ab(0x211)][_0x3ca2ab(0x170)]();return;}else return Scene_MenuBase[_0x3ca2ab(0x225)][_0x3ca2ab(0x14a)]['call'](this);}},Scene_CG_Gallery['prototype'][_0x53838b(0x154)]=function(){const _0x30127f=_0x53838b;if(this[_0x30127f(0x299)]){if(_0x30127f(0x1ae)!==_0x30127f(0x1ae))_0x599635[_0x30127f(0x169)]['Window_MenuCommand_addOriginalCommands']['call'](this),this[_0x30127f(0x1e0)]();else return TextManager[_0x30127f(0x1db)][_0x30127f(0x19f)][_0x30127f(0x191)];}else return Scene_MenuBase[_0x30127f(0x225)]['buttonAssistText1']['call'](this);},Scene_CG_Gallery[_0x53838b(0x225)]['buttonAssistText2']=function(){const _0x4159a8=_0x53838b;if(this[_0x4159a8(0x299)])return TextManager['CG_GALLERY'][_0x4159a8(0x19f)][_0x4159a8(0x1f9)];else{if(_0x4159a8(0x194)===_0x4159a8(0x194))return Scene_MenuBase['prototype'][_0x4159a8(0xf6)][_0x4159a8(0x264)](this);else{if(this[_0x4159a8(0xcd)]===_0x577d81)this[_0x4159a8(0x122)]();return this[_0x4159a8(0xcd)][_0x4159a8(0x235)]&&this[_0x4159a8(0x206)]();}}},Scene_CG_Gallery[_0x53838b(0x225)][_0x53838b(0x2a5)]=function(){const _0x3da6d5=_0x53838b;if(this[_0x3da6d5(0x299)])return TextManager[_0x3da6d5(0x1db)][_0x3da6d5(0x19f)][_0x3da6d5(0x136)];else{if('YRTkN'!==_0x3da6d5(0x282))_0x4b6e21['unlockImageForCgGallery'](_0x2bc4a3);else return Scene_MenuBase[_0x3da6d5(0x225)]['buttonAssistText3']['call'](this);}},Scene_CG_Gallery[_0x53838b(0x225)][_0x53838b(0x1f4)]=function(){const _0x920706=_0x53838b;if(this['_viewMode']){if(_0x920706(0xca)!=='OZYfu')this[_0x920706(0x133)](...arguments);else{if(this[_0x920706(0x269)]>=this[_0x920706(0x285)][_0x920706(0x108)]-0x1){if(_0x920706(0x230)==='srWBI')return TextManager[_0x920706(0x1db)][_0x920706(0x19f)][_0x920706(0x198)];else this[_0x920706(0x299)]=![],this[_0x920706(0x248)]=!![],this[_0x920706(0x269)]=0x0,this[_0x920706(0x285)]=[];}else{if(_0x920706(0x1a3)!==_0x920706(0x1a3))this[_0x920706(0x133)](...arguments);else return TextManager[_0x920706(0x1db)][_0x920706(0x19f)][_0x920706(0xdc)];}}}else return Scene_MenuBase[_0x920706(0x225)][_0x920706(0x1f4)][_0x920706(0x264)](this);},Scene_CG_Gallery[_0x53838b(0x225)]['buttonAssistText5']=function(){const _0x389f3f=_0x53838b;return this[_0x389f3f(0x299)]?this['_variationIndex']<=0x0?TextManager[_0x389f3f(0x1db)][_0x389f3f(0x19f)][_0x389f3f(0x198)]:TextManager[_0x389f3f(0x1db)][_0x389f3f(0x19f)]['prev']:Scene_MenuBase[_0x389f3f(0x225)][_0x389f3f(0x26c)][_0x389f3f(0x264)](this);},Scene_CG_Gallery[_0x53838b(0x225)][_0x53838b(0x271)]=function(){const _0xcdf1e3=_0x53838b;Scene_MenuBase[_0xcdf1e3(0x225)][_0xcdf1e3(0x271)][_0xcdf1e3(0x264)](this),this[_0xcdf1e3(0xfe)](this[_0xcdf1e3(0xc0)]()),this[_0xcdf1e3(0xf2)](),this[_0xcdf1e3(0x10b)](),this['createViewSprite']();},Scene_CG_Gallery['prototype']['getBackgroundOpacity']=function(){const _0x5637f2=_0x53838b;return VisuMZ[_0x5637f2(0x169)][_0x5637f2(0x278)][_0x5637f2(0x12f)]['SnapshotOpacity'];},Scene_CG_Gallery[_0x53838b(0x225)]['createCustomBackgroundImages']=function(){const _0x3352e0=_0x53838b,_0x221b85=VisuMZ[_0x3352e0(0x169)][_0x3352e0(0x278)][_0x3352e0(0x12f)];_0x221b85&&(_0x221b85[_0x3352e0(0x172)]!==''||_0x221b85[_0x3352e0(0xf5)]!=='')&&(this[_0x3352e0(0x10e)]=new Sprite(ImageManager[_0x3352e0(0x261)](_0x221b85[_0x3352e0(0x172)])),this['_backSprite2']=new Sprite(ImageManager['loadTitle2'](_0x221b85[_0x3352e0(0xf5)])),this[_0x3352e0(0xe5)](this[_0x3352e0(0x10e)]),this[_0x3352e0(0xe5)](this[_0x3352e0(0x292)]),this[_0x3352e0(0x10e)][_0x3352e0(0x241)][_0x3352e0(0x13b)](this[_0x3352e0(0xb6)][_0x3352e0(0x270)](this,this[_0x3352e0(0x10e)])),this[_0x3352e0(0x292)]['bitmap'][_0x3352e0(0x13b)](this[_0x3352e0(0xb6)][_0x3352e0(0x270)](this,this[_0x3352e0(0x292)])));},Scene_CG_Gallery[_0x53838b(0x225)][_0x53838b(0x10b)]=function(){const _0x387fd5=_0x53838b;this[_0x387fd5(0x29d)]=new Sprite(),this[_0x387fd5(0xe5)](this[_0x387fd5(0x29d)]),this[_0x387fd5(0x29d)]['bitmap']=new Bitmap(0x1,0x1),this[_0x387fd5(0x29d)][_0x387fd5(0x241)][_0x387fd5(0x23e)](0x0,0x0,0x1,0x1,'black'),this['_blackBgSprite']['scale']['x']=Graphics[_0x387fd5(0x29e)],this[_0x387fd5(0x29d)]['scale']['y']=Graphics[_0x387fd5(0x26d)],this[_0x387fd5(0x29d)][_0x387fd5(0x1cc)]=0x0;},Scene_CG_Gallery['prototype']['createViewSprite']=function(){const _0xea3aeb=_0x53838b,_0x154131=new Sprite();_0x154131['bitmap']=new Bitmap(0x64,0x64),_0x154131['opacity']=0x0,this['_viewSprite']=_0x154131,this[_0xea3aeb(0xe5)](_0x154131),this['adjustSpriteDown'](_0x154131);},Scene_CG_Gallery[_0x53838b(0x225)][_0x53838b(0xb6)]=function(_0xf43035){const _0x28a67d=_0x53838b;this[_0x28a67d(0x26a)](_0xf43035),this['centerSprite'](_0xf43035);},Scene_CG_Gallery[_0x53838b(0x225)]['adjustSpriteDown']=function(_0x383e98){const _0xefa760=_0x53838b;this[_0xefa760(0x263)](_0x383e98),this[_0xefa760(0x276)](_0x383e98);},Scene_CG_Gallery[_0x53838b(0x225)][_0x53838b(0x263)]=function(_0x4bbc0e){const _0x12a25a=_0x53838b,_0x26cc6c=Graphics[_0x12a25a(0x29e)]/_0x4bbc0e[_0x12a25a(0x241)][_0x12a25a(0x29e)],_0x4cedce=Graphics['height']/_0x4bbc0e['bitmap'][_0x12a25a(0x26d)],_0x27fa2b=Math[_0x12a25a(0x1d1)](_0x26cc6c,_0x4cedce,0x1);_0x4bbc0e[_0x12a25a(0x223)]['x']=_0x27fa2b,_0x4bbc0e[_0x12a25a(0x223)]['y']=_0x27fa2b;},Scene_CG_Gallery['prototype'][_0x53838b(0x175)]=function(){const _0xbfe190=_0x53838b;this['_categoryWindow']['deactivate'](),this[_0xbfe190(0x211)][_0xbfe190(0x170)](),this['_galleryWindow'][_0xbfe190(0xe1)](),this['_galleryWindow']['index']()<0x0&&this['_galleryWindow']['select'](0x0);},Scene_CG_Gallery[_0x53838b(0x225)][_0x53838b(0xc5)]=function(){const _0x2d05ad=_0x53838b;this[_0x2d05ad(0x21e)][_0x2d05ad(0x170)](),this[_0x2d05ad(0x211)]['deactivate']();},Scene_CG_Gallery[_0x53838b(0x225)][_0x53838b(0xb8)]=function(){const _0xa19c78=_0x53838b,_0x4d159c=this[_0xa19c78(0x211)][_0xa19c78(0x1f5)]();if(!_0x4d159c){if(_0xa19c78(0xce)===_0xa19c78(0xce)){this['_galleryWindow']['activate']();return;}else this[_0xa19c78(0xc9)](_0x34f163,_0x4cdfce['x'],_0x2544c0['y'],_0x2e9490);}this[_0xa19c78(0x285)]=[_0x4d159c[_0xa19c78(0x21c)]];for(const _0x1b09e8 of _0x4d159c[_0xa19c78(0x173)]){if(_0xa19c78(0x24b)===_0xa19c78(0x24b)){if(_0x1b09e8[_0xa19c78(0x179)]()[_0xa19c78(0x1d7)]()===_0xa19c78(0x130))continue;if(_0x1b09e8[_0xa19c78(0x1d7)]()==='')continue;$gameSystem[_0xa19c78(0x188)](_0x1b09e8,!![])&&this[_0xa19c78(0x285)]['push'](_0x1b09e8);}else{const _0x18fe8f=_0xaf9f8e(_0x4e3b7b['$1']);_0x18fe8f!==_0x508521[_0x10c4da][_0xa19c78(0x189)]&&(_0x29ea91(_0xa19c78(0x202)[_0xa19c78(0x142)](_0x3050c4,_0x18fe8f)),_0x39ca7e[_0xa19c78(0x13a)]());}}this[_0xa19c78(0x291)]['bitmap']=ImageManager[_0xa19c78(0x1ad)](_0x4d159c[_0xa19c78(0x21c)]),this[_0xa19c78(0x291)][_0xa19c78(0x241)][_0xa19c78(0x13b)](this['startViewMode'][_0xa19c78(0x270)](this)),Input[_0xa19c78(0x27f)](),TouchInput[_0xa19c78(0x27f)]();},Scene_CG_Gallery[_0x53838b(0x225)][_0x53838b(0x157)]=function(){const _0x5cf7ec=_0x53838b;this[_0x5cf7ec(0x299)]=!![],this['_variationIndex']=0x0,this[_0x5cf7ec(0x248)]=!![],this[_0x5cf7ec(0x25d)][_0x5cf7ec(0xe9)](),this['_categoryWindow'][_0x5cf7ec(0xe9)](),this[_0x5cf7ec(0x211)][_0x5cf7ec(0xe9)](),this[_0x5cf7ec(0x24f)](this[_0x5cf7ec(0x291)]),this['_viewSprite'][_0x5cf7ec(0x1cc)]=0xff,this[_0x5cf7ec(0x29d)]['opacity']=0xff;},Scene_CG_Gallery[_0x53838b(0x225)][_0x53838b(0x153)]=function(){const _0x3bb8c2=_0x53838b;this[_0x3bb8c2(0x299)]=![],this[_0x3bb8c2(0x269)]=0x0,this[_0x3bb8c2(0x248)]=![],this[_0x3bb8c2(0x260)](),this['_helpWindow'][_0x3bb8c2(0x2a8)](),this['_categoryWindow'][_0x3bb8c2(0x2a8)](),this[_0x3bb8c2(0x211)][_0x3bb8c2(0x2a8)](),this[_0x3bb8c2(0x211)][_0x3bb8c2(0x170)]();if(this[_0x3bb8c2(0x1fe)])this[_0x3bb8c2(0x1fe)][_0x3bb8c2(0x1ee)]=!![];if(this[_0x3bb8c2(0x2a2)])this[_0x3bb8c2(0x2a2)][_0x3bb8c2(0x1ee)]=!![];this[_0x3bb8c2(0x291)][_0x3bb8c2(0x1cc)]=0x0,this[_0x3bb8c2(0x29d)]['opacity']=0x0,Input['clear'](),TouchInput[_0x3bb8c2(0x27f)]();},Scene_CG_Gallery[_0x53838b(0x225)]['updateViewMode']=function(){const _0x528a9c=_0x53838b,_0x13a06c=0x14;if(Input[_0x528a9c(0x1eb)](_0x528a9c(0x109))){if(_0x528a9c(0x28a)===_0x528a9c(0x28a))this['processViewModeCancel']();else{if(_0x11c03b[_0x528a9c(0x169)][_0x528a9c(0x278)][_0x528a9c(0x203)]['HelpWindow_RectJS'])return _0x1ad95d['CGGallery'][_0x528a9c(0x278)][_0x528a9c(0x203)][_0x528a9c(0x254)][_0x528a9c(0x264)](this);const _0x57a83c=0x0,_0x2657ed=this[_0x528a9c(0x19e)](),_0x33bb98=_0x2da10b[_0x528a9c(0x106)],_0x89e64a=this[_0x528a9c(0x193)]();return new _0x1355b0(_0x57a83c,_0x2657ed,_0x33bb98,_0x89e64a);}}else{if(Input[_0x528a9c(0x1eb)]('ok'))this[_0x528a9c(0x216)]();else{if(Input['isRepeated'](_0x528a9c(0x24d)))this[_0x528a9c(0x117)]();else{if(Input[_0x528a9c(0x1eb)](_0x528a9c(0x29f))){if(_0x528a9c(0xcb)!==_0x528a9c(0x112))this[_0x528a9c(0x15a)]();else{const _0x49369f=this[_0x528a9c(0x29a)],_0x54db4f=_0x2795ed['windowPadding'](),_0x4a1f37=_0x5de757['x']+_0xdedf8a['floor'](_0x331f34[_0x528a9c(0x29e)]/0x2)+_0x54db4f;_0x49369f['x']=_0x49369f[_0x528a9c(0x29e)]/-0x2+_0x4a1f37,_0x49369f['y']=_0x340904[_0x528a9c(0x140)](_0x4b9606[_0x528a9c(0x26d)]/0x2);}}else{if(Input[_0x528a9c(0x1eb)]('pageup')||TouchInput[_0x528a9c(0x1f2)]<=-_0x13a06c)_0x528a9c(0xb7)!=='GrVeg'?this[_0x528a9c(0x208)](!![]):_0x54661a[_0x528a9c(0x181)]();else{if(Input['isRepeated'](_0x528a9c(0x104))||TouchInput['wheelY']>=_0x13a06c)'hHvcK'===_0x528a9c(0x1bf)?this[_0x528a9c(0x208)](![]):(_0x27f02a[_0x528a9c(0x169)]['ConfigManager_applyData']['call'](this,_0x3d5988),'cgGalleryUnlocks'in _0x1fc9ac?this['cgGalleryUnlocks']=_0x2d0777[_0x528a9c(0xbb)]:this[_0x528a9c(0xbb)]=[]);else{if(Input[_0x528a9c(0x1dd)]>0x0)this[_0x528a9c(0x283)](Input[_0x528a9c(0x1dd)]);else{if(TouchInput[_0x528a9c(0xbc)]())_0x528a9c(0x228)!=='GXXMC'?this[_0x528a9c(0x2a0)]():_0x50067c['isCgGalleryUnlocked'](_0x405d5b[_0x528a9c(0x21c)])?this[_0x528a9c(0x25d)][_0x528a9c(0x177)](_0x2eccfe[_0x528a9c(0x21f)]||''):this[_0x528a9c(0x25d)]['setText'](_0x1b6a1f[_0x528a9c(0x1db)][_0x528a9c(0x218)]['lockedImg']);else{if(TouchInput[_0x528a9c(0x102)]()){if(_0x528a9c(0x201)==='cIObw')this['processViewModeTouchRelease']();else{if(_0x29ecf6[_0x528a9c(0x169)][_0x528a9c(0x278)]['Window'][_0x528a9c(0x165)])return _0x19616f[_0x528a9c(0x169)][_0x528a9c(0x278)][_0x528a9c(0x203)]['GalleryWindow_RectJS'][_0x528a9c(0x264)](this);const _0x3a1b05=_0x4d3727[_0x528a9c(0x106)],_0x2b544d=this[_0x528a9c(0x11e)]()-this[_0x528a9c(0x226)](0x1,![]),_0x5d9b84=0x0,_0x17054f=this[_0x528a9c(0xd4)]()+this[_0x528a9c(0x226)](0x1,![]);return new _0x235c53(_0x5d9b84,_0x17054f,_0x3a1b05,_0x2b544d);}}}}}}}}}}},Scene_CG_Gallery[_0x53838b(0x225)][_0x53838b(0xba)]=function(){const _0x989fc2=_0x53838b;if(this[_0x989fc2(0x269)]<=0x0){if(_0x989fc2(0x190)===_0x989fc2(0x101))return this['_viewMode']?_0x3669c7['getInputButtonString'](_0x989fc2(0x24d)):_0x47beeb[_0x989fc2(0x225)][_0x989fc2(0x14a)][_0x989fc2(0x264)](this);else SoundManager[_0x989fc2(0x14b)](),this['exitViewMode']();}else this['processVariationChange'](![]);},Scene_CG_Gallery['prototype']['processVariationChange']=function(_0x17e1c0){const _0x5a53e6=_0x53838b,_0x3078cc=this[_0x5a53e6(0x269)];this[_0x5a53e6(0x269)]+=_0x17e1c0?0x1:-0x1,this[_0x5a53e6(0x269)]=this[_0x5a53e6(0x269)]['clamp'](0x0,this[_0x5a53e6(0x285)][_0x5a53e6(0x108)]-0x1);if(_0x3078cc!==this[_0x5a53e6(0x269)]){const _0x48687=this[_0x5a53e6(0x285)][this['_variationIndex']];this[_0x5a53e6(0x291)][_0x5a53e6(0x241)]=ImageManager[_0x5a53e6(0x1ad)](_0x48687),SoundManager[_0x5a53e6(0x180)](),this['adjustSpriteDown'](this['_viewSprite']);}},Scene_CG_Gallery[_0x53838b(0x225)][_0x53838b(0x216)]=function(){const _0x19ff00=_0x53838b;this['_variationIndex']>=this['_variationList'][_0x19ff00(0x108)]-0x1?_0x19ff00(0x1d4)===_0x19ff00(0x1d4)?(SoundManager[_0x19ff00(0x14b)](),this[_0x19ff00(0x153)]()):this[_0x19ff00(0x2a2)][_0x19ff00(0x1ee)]=this[_0x19ff00(0x248)]:this[_0x19ff00(0x195)](!![]);},Scene_CG_Gallery[_0x53838b(0x225)]['processViewModeReset']=function(){const _0x3a8e55=_0x53838b;SoundManager[_0x3a8e55(0x156)](),this['adjustSpriteDown'](this['_viewSprite']),this[_0x3a8e55(0x291)][_0x3a8e55(0x1cc)]=0xff,this['_blackBgSprite'][_0x3a8e55(0x1cc)]=0xff;},Scene_CG_Gallery[_0x53838b(0x225)]['processViewModeBorderless']=function(){const _0x2c92b5=_0x53838b;SoundManager[_0x2c92b5(0x156)](),this['_viewModeVisible']=!this[_0x2c92b5(0x248)];if(this[_0x2c92b5(0x1fe)]){if(_0x2c92b5(0x1f7)!=='ANvZr'){const _0x4eae08=0x14;_0x1f8459[_0x2c92b5(0x1f2)]>=_0x4eae08&&(this['cursorDown'](![]),this['_wheelCooldown']=0x8),_0x9913d[_0x2c92b5(0x1f2)]<=-_0x4eae08&&(this['cursorUp'](![]),this['_wheelCooldown']=0x8);}else this[_0x2c92b5(0x1fe)][_0x2c92b5(0x1ee)]=this[_0x2c92b5(0x248)];}if(this['_cancelButton']){if(_0x2c92b5(0x1e4)===_0x2c92b5(0x1e4))this[_0x2c92b5(0x2a2)][_0x2c92b5(0x1ee)]=this['_viewModeVisible'];else return _0x17b513[_0x2c92b5(0x1c1)](_0x2c92b5(0x24c),_0x2c92b5(0x104));}this['_pageupButton']&&this[_0x2c92b5(0xc4)]&&(_0x2c92b5(0x146)===_0x2c92b5(0x146)?(this[_0x2c92b5(0x1e7)]['visible']=this['_viewModeVisible'],this[_0x2c92b5(0xc4)]['visible']=this[_0x2c92b5(0x248)]):this['processViewModeReset']());},Scene_CG_Gallery['prototype'][_0x53838b(0x208)]=function(_0x26495){const _0x4e3bc9=_0x53838b;let _0x4ef4fa=this[_0x4e3bc9(0x291)][_0x4e3bc9(0x223)]['x'];const _0x470a9a=_0x4ef4fa;_0x4ef4fa+=_0x26495?0.1:-0.1,_0x4ef4fa=Number(_0x4ef4fa[_0x4e3bc9(0xdb)](0x1)),this[_0x4e3bc9(0x291)][_0x4e3bc9(0x223)]['x']=_0x4ef4fa[_0x4e3bc9(0x147)](0.1,0x4),this[_0x4e3bc9(0x291)][_0x4e3bc9(0x223)]['y']=_0x4ef4fa['clamp'](0.1,0x4),_0x470a9a!==this[_0x4e3bc9(0x291)]['scale']['x']&&(_0x4e3bc9(0x13f)!==_0x4e3bc9(0x110)?SoundManager[_0x4e3bc9(0x181)]():this[_0x4e3bc9(0x195)](!![]));},Scene_CG_Gallery['prototype'][_0x53838b(0x283)]=function(_0x961637){const _0x2172b9=_0x53838b,_0x21f2e9=Scene_CG_Gallery[_0x2172b9(0x28c)];switch(_0x961637){case 0x7:case 0x4:case 0x1:this[_0x2172b9(0x291)]['x']-=_0x21f2e9;break;case 0x9:case 0x6:case 0x3:this[_0x2172b9(0x291)]['x']+=_0x21f2e9;break;}switch(_0x961637){case 0x1:case 0x2:case 0x3:this[_0x2172b9(0x291)]['y']+=_0x21f2e9;break;case 0x7:case 0x8:case 0x9:this[_0x2172b9(0x291)]['y']-=_0x21f2e9;break;}this[_0x2172b9(0x291)]['x']=this[_0x2172b9(0x291)]['x']['clamp'](0x0,Graphics[_0x2172b9(0x29e)]),this[_0x2172b9(0x291)]['y']=this[_0x2172b9(0x291)]['y'][_0x2172b9(0x147)](0x0,Graphics[_0x2172b9(0x26d)]);},Scene_CG_Gallery[_0x53838b(0x225)][_0x53838b(0x2a0)]=function(){const _0x6e124d=_0x53838b,_0x128b7a=this[_0x6e124d(0x2a2)]?Math[_0x6e124d(0xf4)](this[_0x6e124d(0x2a2)][_0x6e124d(0x29e)]*1.3):0x0;TouchInput['x']>_0x128b7a&&TouchInput['x']<Graphics['width']-_0x128b7a&&(TouchInput['y']>_0x128b7a&&TouchInput['y']<Graphics[_0x6e124d(0x26d)]-_0x128b7a&&(this[_0x6e124d(0x291)]['x']=TouchInput['x'][_0x6e124d(0x147)](0x0,Graphics[_0x6e124d(0x29e)]),this[_0x6e124d(0x291)]['y']=TouchInput['y'][_0x6e124d(0x147)](0x0,Graphics['height'])));},Scene_CG_Gallery[_0x53838b(0x225)]['processViewModeTouchRelease']=function(){const _0x2d7f2b=_0x53838b,_0x2f43e5=this[_0x2d7f2b(0x2a2)]?Math['round'](this[_0x2d7f2b(0x2a2)][_0x2d7f2b(0x29e)]*1.05):0x0;if(TouchInput['x']>_0x2f43e5&&TouchInput['x']<Graphics[_0x2d7f2b(0x29e)]-_0x2f43e5){if(TouchInput['y']<_0x2f43e5||TouchInput['y']>Graphics[_0x2d7f2b(0x26d)]-_0x2f43e5){if(_0x2d7f2b(0x22e)!=='tyBMQ'){_0x46ea12=_0x38e8da||_0x2d7f2b(0x245);const _0x2ac37a=this[_0x2d7f2b(0x298)](_0x32962f);let _0x1b7e41=this[_0x2d7f2b(0x1d8)](_0x28a55c);return _0x1b7e41/_0x2ac37a;}else this['processViewModeBorderless']();}}},VisuMZ[_0x53838b(0x169)][_0x53838b(0x23c)]=Window_MenuCommand['prototype'][_0x53838b(0xc2)],Window_MenuCommand[_0x53838b(0x225)][_0x53838b(0xc2)]=function(){const _0xeb8e3a=_0x53838b;VisuMZ[_0xeb8e3a(0x169)][_0xeb8e3a(0x23c)]['call'](this),this[_0xeb8e3a(0x1e0)]();},Window_MenuCommand['prototype'][_0x53838b(0x1e0)]=function(){const _0xa7c9b8=_0x53838b;if(!this[_0xa7c9b8(0x124)]())return;if(!this[_0xa7c9b8(0x19c)]())return;const _0xba0ba=TextManager['cgGalleryMenuCommand'],_0x201f17=this['isCgGalleryCommandEnabled']();this[_0xa7c9b8(0x29b)](_0xba0ba,_0xa7c9b8(0x251),_0x201f17);},Window_MenuCommand[_0x53838b(0x225)]['addCgGalleryCommandAutomatically']=function(){const _0x3b4933=_0x53838b;return Imported[_0x3b4933(0x1af)]?![]:!![];},Window_MenuCommand['prototype'][_0x53838b(0x19c)]=function(){const _0x1021c7=_0x53838b;return $gameSystem[_0x1021c7(0xcc)]();},Window_MenuCommand[_0x53838b(0x225)]['isCgGalleryCommandEnabled']=function(){const _0xc3015=_0x53838b;return $gameSystem[_0xc3015(0x231)]();},Window_TitleCommand['CG_GALLERY_ADD_COMMAND']=VisuMZ[_0x53838b(0x169)]['Settings'][_0x53838b(0xec)][_0x53838b(0xd3)],VisuMZ[_0x53838b(0x169)][_0x53838b(0x289)]=Window_TitleCommand['prototype']['makeCommandList'],Window_TitleCommand[_0x53838b(0x225)]['makeCommandList']=function(){const _0x4e510f=_0x53838b;VisuMZ[_0x4e510f(0x169)][_0x4e510f(0x289)][_0x4e510f(0x264)](this),this[_0x4e510f(0x1e0)]();},Window_TitleCommand[_0x53838b(0x225)][_0x53838b(0x1e0)]=function(){const _0x8b253d=_0x53838b;if(!Window_TitleCommand[_0x8b253d(0x1ff)])return;if(this[_0x8b253d(0x1da)]('cgGallery')>=0x0)return;const _0x430b2e=TextManager['cgGalleryMenuCommand'],_0x10e903=$gameSystem[_0x8b253d(0x206)]();this[_0x8b253d(0x29b)](_0x430b2e,_0x8b253d(0x251),_0x10e903);const _0x24d579=this[_0x8b253d(0x1da)](_0x8b253d(0x2a4));if(_0x24d579>0x0){const _0x4c4b8f=this['_list'][_0x8b253d(0x1b9)]();this[_0x8b253d(0xd8)]['splice'](_0x24d579,0x0,_0x4c4b8f);}};function Window_CG_Category(){const _0x34d637=_0x53838b;this[_0x34d637(0x133)](...arguments);}function _0x51da(){const _0x3d7114=['round','BgFilename2','buttonAssistText2','ceil','shown','fQhEh','ButtonAssistVocab_Zoom','fontBold','CG_UnlockAllImagesPerma','GalleryWindow_MaxCols','setBackgroundOpacity','ButtonAssistVocab_Prev','GalleryWindow_SpacingCols','NTehh','isReleased','EZkbU','pagedown','updateCommandNameWindow','boxWidth','GalleryWindow_Text_ProgressFontSize2','length','cancel','_defaultUnlocks','createBlackBackgroundImage','updateSmoothScroll','name','_backSprite1','match','qMiGR','MAXCOL','KbDyA','yaXrj','GalleryWindow_Text_CompletionVocab','Untitled','_context','processViewModeReset','COMMAND_LIST','STAGGER_FULL','CategoryWindow_TextAlign','center','HasUnlistedCategories','GPbbq','mainAreaHeight','AllCommandIcon','GalleryWindow_Text_CompletionFmt','GalleryWindow_MaxRows','initCgGalleryMainMenu','variantComplete','addCgGalleryCommandAutomatically','auto','lVsYq','fontSize1','text','CgGalleryTotalSize','itemLineRect','replace','maxScrollX','DefaultUnlocks','GalleryWindow_Text_ProgressAngle','BgSettings','untitled','uYBCR','GalleryWindow_Text_VariationsAlignY','initialize','innerHeight','deselect','reset','PSlfx','gYVxS','drawItemStyleIcon','exit','addLoadListener','commandNameWindowDrawBackground','listing','playViewCgImage','gpfth','floor','bottom','format','drawPicture','ayBHC','updateGalleryWindow','rgTsy','clamp','MAFTg','drawVariationCount','buttonAssistKey3','playCancel','DefaultUnlocked','includes','Vocab','update','ButtonAssistVocab_Border','makeData','DHEZr','exitViewMode','buttonAssistText1','Game_Picture_show','playEquip','startViewMode','itemTextAlign','createProgressSprite','processViewModeBorderless','_wheelCooldown','TEXT_ALIGN','playOkSound','padding','constructor','innerWidth','Listing','ADD_ALL_COMMAND','iconHeight','UnlistedCommandIcon','GalleryWindow_RectJS','itemRectWithPadding','imageSmoothingEnabled','createPageButtons','CGGallery','refreshCursor','rowSpacing','yAlign','ARRAYSTRUCT','IMG_BUFFER','GalleryWindow_Text_ProgressFmt','activate','AllCommandDescription','BgFilename1','Variations','kknSr','commandCategory','ConvertParams','setText','Show','toLowerCase','_category','colSpacing','changePaintOpacity','MAXROW','Name','blt','playNextCgVariation','playCursor','drawIcon','changeName','COMMAND_STYLE','_itemWidth','GalleryWindow_Text_CompletionFontFace','updateHelp','isCgGalleryUnlocked','version','epQCY','angle','buttonAssistKey1','save','pndlj','textFmt','mPlrj','zoom','GalleryWindow_Text_CompletionShow','helpAreaHeight','VGUoL','processVariationChange','fontSize','icons','gallery','setTopRow','autoUnlock','CategoryWindow_ShowUnlistedCommand','isCgGalleryCommandVisible','setCategory','helpAreaTop','buttonAssist','VomiX','create','BMpGG','JgRTq','ShowMainMenu','topRow','GalleryWindow_Text_CompletionDecimals','iconText','_progressSprite','gray','commandNameWindowCenter','mQhOG','wZWht','loadPicture','nnDMo','VisuMZ_1_MainMenuCore','LnQHW','CG_UnlockAllImagesDebug','WIGDG','offset','updateProgressSpriteBitmap','127016zXXWTC','URhgL','SzNzG','createCommandWindow','pop','commandName','scrollBaseX','PvkRk','xAlign','active','hHvcK','_hasUnlistedCategories','getInputMultiButtonStrings','createCompletionSprite','SystemShowCGGalleryMenu','itemHeight','_commandWindow','18950913LXElIt','icon','ArlxZ','fontSize2','_cgGalleryFullUnlock','anchor','opacity','pjZgJ','contents','smoothScrollTo','lockedImgFilename','min','processWheelScroll','close','BtYUh','SceneOpenCgGallery','System','trim','cgGalleryCurrentCount','GalleryWindow_Text_ProgressOffsetY','findSymbol','CG_GALLERY','CG_WINDOW_BGTYPE','dir8','parse','GalleryWindow_ListingBack','addCgGalleryCommand','ButtonAssistVocab_Next','\x5cI[%1]%2','viewPan','BetrX','7410236gCAaks','EVAL','_pageupButton','unlockAllVariations','GalleryWindow_Text_ProgressFontSize1','description','isRepeated','186694YnDUht','outlineColor','visible','_totalSize','GalleryWindow_Text_CompletionOffsetY','_scene','wheelY','_itemHeight','buttonAssistText4','currentExt','map','ANvZr','Game_System_initialize','border','CategoryWindow_BgType','addWindow','10gFKVuM','galleryWindowRect','_buttonAssistWindow','CG_GALLERY_ADD_COMMAND','JSON','cIObw','%1\x27s\x20version\x20does\x20not\x20match\x20plugin\x27s.\x20Please\x20update\x20it\x20in\x20the\x20Plugin\x20Manager.','Window','ARRAYSTR','UnlistedCommandDescription','hasCgUnlockedImage','windowPadding','processViewModeScale','commandCgGallery','maxItems','Category','itemRect','index','SHOW_UNLISTED_COMMAND','tvZKG','addUnlistedCommand','_galleryWindow','728qVHCAR','ButtonAssistVocab_Reset','getInputButtonString','callUpdateHelp','processViewModeOk','DRAW_VARIATION','helpDesc','setMainMenuCgGalleryEnabled','textSizeEx','buttonAssistKey2','Filename','EnableMainMenu','_categoryWindow','Description','createCommandNameWindow','COL_SPACING','push','scale','setHandler','prototype','calcWindowHeight','CATEGORY_WINDOW_BGTYPE','lUOyP','FUNC','createGalleryWindow','WdcbD','setMainMenuCgGalleryVisible','setBackgroundType','tyBMQ','isSceneBattle','srWBI','isMainMenuCgGalleryEnabled','cgGalleryHasUnlockedImage','STRUCT','ARRAYEVAL','enabled','rgba(0,\x200,\x200,\x200)','nPABo','setHelpWindow','PROGRESS_SPRITE','qdNRw','drawItem','Window_MenuCommand_addOriginalCommands','cgGalleryMenuCommand','fillRect','GalleryWindow_Text_VariationsShow','GalleryWindow_ImageBuffer','bitmap','unlisted','kUhiT','gOsle','all','lineHeight','right','_viewModeVisible','_listingNames','24GknJza','lsLCF','pageup','tab','GalleryWindow_Text_ProgressShow','adjustSpriteDown','SystemEnableCGGalleryMenu','cgGallery','MoveDistance','Scene_Title_createCommandWindow','HelpWindow_RectJS','toUpperCase','Enable','GalleryWindow_Text_CompletionFontSize1','ButtonAssistVocab_Gallery','listingMatchesCategory','GalleryWindow_Text_VariationFmt','CgGalleryCategories','loadTitle2','_helpWindow','IsCgGalleryListing','COMPLETION_SPRITE','updatePageButtons','loadTitle1','iconWidth','scaleSpriteDown','call','fontFace','parameters','unlockImageForCgGallery','Key','_variationIndex','scaleSprite','resetFontSettings','buttonAssistText5','height','changePan','Categories','bind','createBackground','decimals','1132839UMfwUF','ARRAYFUNC','ROW_SPACING','centerSprite','STAGGER_LEFT','Settings','GalleryWindow_BgType','Scene_Menu_createCommandWindow','ConfigManager_makeData','CategoryWindow_RectJS','category','yTyvf','clear','drawText','paintOpacity','YRTkN','processViewModeMove','drawItemStyleIconText','_variationList','GalleryWindow_Text_VariationComplete','registerCommand','cgGalleryCompletionRate','Window_TitleCommand_makeCommandList','kRynm','onTouchSelect','CG_WINDOW_MOVE_DIST','refresh','commandNameWindowDrawText','setClickHandler','oQnzx','_viewSprite','_backSprite2','GalleryWindow_StaggerToLeft','Sound','ARRAYNUM','isCommandEnabled','3061458mOFaun','cgGalleryTotalSize','_viewMode','_commandNameWindow','addCommand','isWheelScrollEnabled','_blackBgSprite','width','shift','processViewModeMouseMove','drawItemBackground','_cancelButton','HELP_WINDOW_BGTYPE','options','buttonAssistText3','AutoUnlockVariations','status','show','GalleryWindow_SpacingRows','setGalleryWindow','VlaIw','adjustSprite','lGqSR','prepareViewMode','updateCompletionSpriteBitmap','processViewModeCancel','cgGalleryUnlocks','isPressed','playSe','helpWindowRect','NUM','getBackgroundOpacity','%1\x20is\x20missing\x20a\x20required\x20plugin.\x0aPlease\x20install\x20%2\x20into\x20the\x20Plugin\x20Manager.','addOriginalCommands','_categories','_pagedownButton','onCategoryCancel','cachedCgGalleryLockedImage','7415435egbUvm','createCategoryWindow','drawTextEx','OZYfu','gLDtd','isMainMenuCgGalleryVisible','_cgGallery_MainMenu','tzgao','stringify','commandStyle','CG_UnlockImages','createHelpWindow','ShowTitleCommand','mainAreaTop','percentFmt','jLlLj','updateViewMode','_list','commandStyleCheck','itemWidth','toFixed','next','max','UnlistedCommandText','changePitch','%1\x20is\x20incorrectly\x20placed\x20on\x20the\x20plugin\x20list.\x0aIt\x20is\x20a\x20Tier\x20%2\x20plugin\x20placed\x20over\x20other\x20Tier\x20%3\x20plugins.\x0aPlease\x20reorder\x20the\x20plugin\x20list\x20from\x20smallest\x20to\x20largest\x20tier\x20numbers.','reselect','middle','GalleryWindow_Text_ProgressFontFace','Arial','addChild','XnogG','cursorUp','_cached_CGGallery_Image','hide','GalleryWindow_Stagger','categoryWindowRect','MainMenu','HelpWindow_BgType','applyData','maxCols','lockedImg','Text','createCustomBackgroundImages','_completionSprite'];_0x51da=function(){return _0x3d7114;};return _0x51da();}Window_CG_Category[_0x53838b(0x225)]=Object[_0x53838b(0x1a1)](Window_HorzCommand[_0x53838b(0x225)]),Window_CG_Category[_0x53838b(0x225)][_0x53838b(0x15f)]=Window_CG_Category,Window_CG_Category[_0x53838b(0x118)]=VisuMZ[_0x53838b(0x169)]['Settings'][_0x53838b(0x26f)],Window_CG_Category[_0x53838b(0x184)]=VisuMZ['CGGallery'][_0x53838b(0x278)][_0x53838b(0x203)]['CategoryWindow_Style'],Window_CG_Category[_0x53838b(0x15c)]=VisuMZ['CGGallery']['Settings'][_0x53838b(0x203)][_0x53838b(0x11a)],Window_CG_Category[_0x53838b(0x162)]=VisuMZ['CGGallery'][_0x53838b(0x278)]['Window']['CategoryWindow_AddAllCommand'],Window_CG_Category[_0x53838b(0x20e)]=VisuMZ[_0x53838b(0x169)][_0x53838b(0x278)]['Window'][_0x53838b(0x19b)],Window_CG_Category[_0x53838b(0x225)][_0x53838b(0x133)]=function(_0x1a112b){const _0x3423e9=_0x53838b;Window_HorzCommand[_0x3423e9(0x225)][_0x3423e9(0x133)][_0x3423e9(0x264)](this,_0x1a112b),this[_0x3423e9(0x220)](_0x1a112b);},Window_CG_Category[_0x53838b(0x225)][_0x53838b(0x1c4)]=function(){const _0x4e1910=_0x53838b;return this[_0x4e1910(0x246)]();},Window_CG_Category[_0x53838b(0x225)][_0x53838b(0x220)]=function(_0x455548){const _0x5cd56a=_0x53838b,_0x1d3a28=new Rectangle(0x0,0x0,_0x455548[_0x5cd56a(0x29e)],_0x455548[_0x5cd56a(0x26d)]);this[_0x5cd56a(0x29a)]=new Window_Base(_0x1d3a28),this['_commandNameWindow'][_0x5cd56a(0x1cc)]=0x0,this[_0x5cd56a(0xe5)](this[_0x5cd56a(0x29a)]),this[_0x5cd56a(0x105)]();},Window_CG_Category[_0x53838b(0x225)]['callUpdateHelp']=function(){const _0x2c3155=_0x53838b;Window_HorzCommand[_0x2c3155(0x225)][_0x2c3155(0x215)][_0x2c3155(0x264)](this);if(this[_0x2c3155(0x29a)])this['updateCommandNameWindow']();},Window_CG_Category[_0x53838b(0x225)]['updateCommandNameWindow']=function(){const _0x5d2255=_0x53838b,_0x4e9238=this[_0x5d2255(0x29a)];_0x4e9238['contents'][_0x5d2255(0x27f)]();const _0x2a04fc=this[_0x5d2255(0xd9)](this[_0x5d2255(0x20d)]());if(_0x2a04fc==='icon'){const _0x50c54f=this['itemLineRect'](this[_0x5d2255(0x20d)]());let _0x53bad8=this[_0x5d2255(0x1ba)](this[_0x5d2255(0x20d)]());_0x53bad8=_0x53bad8[_0x5d2255(0x12b)](/\\I\[(\d+)\]/gi,''),_0x4e9238[_0x5d2255(0x26b)](),this[_0x5d2255(0x13c)](_0x53bad8,_0x50c54f),this['commandNameWindowDrawText'](_0x53bad8,_0x50c54f),this[_0x5d2255(0x1aa)](_0x53bad8,_0x50c54f);}},Window_CG_Category[_0x53838b(0x225)]['commandNameWindowDrawBackground']=function(_0xfa2d9a,_0x579b8d){},Window_CG_Category[_0x53838b(0x225)][_0x53838b(0x28e)]=function(_0x4e6c95,_0x30fc47){const _0x11ad51=_0x53838b,_0x4eb177=this[_0x11ad51(0x29a)];_0x4eb177[_0x11ad51(0x280)](_0x4e6c95,0x0,_0x30fc47['y'],_0x4eb177[_0x11ad51(0x160)],_0x11ad51(0x11b));},Window_CG_Category[_0x53838b(0x225)]['commandNameWindowCenter']=function(_0x4b364c,_0x1dbb2a){const _0x244325=_0x53838b,_0x4197c7=this[_0x244325(0x29a)],_0x494e61=$gameSystem[_0x244325(0x207)](),_0x3aaaee=_0x1dbb2a['x']+Math[_0x244325(0x140)](_0x1dbb2a[_0x244325(0x29e)]/0x2)+_0x494e61;_0x4197c7['x']=_0x4197c7['width']/-0x2+_0x3aaaee,_0x4197c7['y']=Math[_0x244325(0x140)](_0x1dbb2a['height']/0x2);},Window_CG_Category[_0x53838b(0x225)][_0x53838b(0xef)]=function(){const _0x155331=_0x53838b;let _0x4f7953=Window_CG_Category['COMMAND_LIST'][_0x155331(0x108)];if(Window_CG_Category[_0x155331(0x162)])_0x4f7953+=0x1;if(VisuMZ['CGGallery'][_0x155331(0x11c)]())_0x4f7953+=0x1;return _0x4f7953;},Window_CG_Category[_0x53838b(0x225)]['makeCommandList']=function(){const _0x5c4b95=_0x53838b;this['addAllCommand'](),this['addCommandListCommands'](),this[_0x5c4b95(0x210)]();},Window_CG_Category[_0x53838b(0x225)]['addAllCommand']=function(){const _0x5f25b8=_0x53838b;if(!Window_CG_Category['ADD_ALL_COMMAND'])return;const _0xed8a4c=_0x5f25b8(0x27d),_0x5aebd8=ImageManager[_0x5f25b8(0x1db)][_0x5f25b8(0x197)][_0x5f25b8(0x245)];let _0x21eac6=TextManager[_0x5f25b8(0x1db)][_0x5f25b8(0x27d)][_0x5f25b8(0x245)];if(_0x5aebd8>0x0&&this[_0x5f25b8(0xd0)]()!==_0x5f25b8(0x128)){if('oEULZ'!==_0x5f25b8(0x243))_0x21eac6=_0x5f25b8(0x1e2)[_0x5f25b8(0x142)](_0x5aebd8,_0x21eac6);else return'iconText';}const _0x18922e={'Key':_0x5f25b8(0x245),'Description':TextManager[_0x5f25b8(0x1db)][_0x5f25b8(0x218)]['all']};this[_0x5f25b8(0x29b)](_0x21eac6,_0xed8a4c,!![],_0x18922e);},Window_CG_Category[_0x53838b(0x225)]['addCommandListCommands']=function(){const _0x30453b=_0x53838b;for(const _0x3634aa of Window_CG_Category[_0x30453b(0x118)]){const _0x2b601e=_0x30453b(0x27d),_0x472968=_0x3634aa['Icon'];let _0x264260=_0x3634aa[_0x30453b(0xf1)];if(['',_0x30453b(0x115)][_0x30453b(0x14d)](_0x264260))continue;_0x472968>0x0&&this[_0x30453b(0xd0)]()!==_0x30453b(0x128)&&(_0x264260=_0x30453b(0x1e2)[_0x30453b(0x142)](_0x472968,_0x264260)),this[_0x30453b(0x29b)](_0x264260,_0x2b601e,!![],_0x3634aa);}},Window_CG_Category[_0x53838b(0x225)][_0x53838b(0x210)]=function(){const _0x40f72e=_0x53838b;if(!Window_CG_Category[_0x40f72e(0x20e)])return;if(!VisuMZ[_0x40f72e(0x169)][_0x40f72e(0x11c)]())return;const _0x11ad57=_0x40f72e(0x27d),_0x51d254=ImageManager[_0x40f72e(0x1db)][_0x40f72e(0x197)][_0x40f72e(0x242)];let _0x4fab18=TextManager['CG_GALLERY'][_0x40f72e(0x27d)][_0x40f72e(0x242)];_0x51d254>0x0&&this[_0x40f72e(0xd0)]()!=='text'&&(_0x4fab18=_0x40f72e(0x1e2)[_0x40f72e(0x142)](_0x51d254,_0x4fab18));const _0x5deac4={'Key':_0x40f72e(0x245),'Description':TextManager[_0x40f72e(0x1db)][_0x40f72e(0x218)][_0x40f72e(0x242)]};this[_0x40f72e(0x29b)](_0x4fab18,_0x11ad57,!![],_0x5deac4);},Window_CG_Category[_0x53838b(0x225)][_0x53838b(0x187)]=function(){const _0xb7bca4=_0x53838b;this['_helpWindow'][_0xb7bca4(0x177)](this[_0xb7bca4(0x1f5)]()?this[_0xb7bca4(0x1f5)]()[_0xb7bca4(0x21f)]:''),this[_0xb7bca4(0x145)]();},Window_CG_Category[_0x53838b(0x225)][_0x53838b(0x158)]=function(){return Window_CG_Category['TEXT_ALIGN'];},Window_CG_Category[_0x53838b(0x225)][_0x53838b(0x23b)]=function(_0x451cca){const _0x5f3400=_0x53838b,_0x53d7b3=this['commandStyleCheck'](_0x451cca);if(_0x53d7b3===_0x5f3400(0x1a7))this[_0x5f3400(0x284)](_0x451cca);else _0x53d7b3==='icon'?this['drawItemStyleIcon'](_0x451cca):Window_HorzCommand[_0x5f3400(0x225)][_0x5f3400(0x23b)][_0x5f3400(0x264)](this,_0x451cca);},Window_CG_Category[_0x53838b(0x225)]['commandStyle']=function(){return Window_CG_Category['COMMAND_STYLE'];},Window_CG_Category[_0x53838b(0x225)][_0x53838b(0xd9)]=function(_0x3ed045){const _0x532ebd=_0x53838b;if(_0x3ed045<0x0)return _0x532ebd(0x128);const _0x3185fa=this[_0x532ebd(0xd0)]();if(_0x3185fa!==_0x532ebd(0x125))return _0x532ebd(0x1bc)===_0x532ebd(0x1bc)?_0x3185fa:this['_variationIndex']<=0x0?_0x2119cb['CG_GALLERY'][_0x532ebd(0x19f)][_0x532ebd(0x198)]:_0x42e9c4[_0x532ebd(0x1db)][_0x532ebd(0x19f)]['prev'];else{if(this[_0x532ebd(0x20a)]()>0x0){const _0x4d11ad=this[_0x532ebd(0x1ba)](_0x3ed045);if(_0x4d11ad[_0x532ebd(0x10f)](/\\I\[(\d+)\]/i)){const _0x58b6f1=this[_0x532ebd(0x12a)](_0x3ed045),_0x209017=this['textSizeEx'](_0x4d11ad)[_0x532ebd(0x29e)];if(_0x209017<=_0x58b6f1[_0x532ebd(0x29e)])return _0x532ebd(0x1a7);else{if(_0x532ebd(0x174)===_0x532ebd(0x11d))this[_0x532ebd(0xbb)]=_0x5c03ff[_0x532ebd(0xbb)];else return _0x532ebd(0x1c7);}}}}return _0x532ebd(0x128);},Window_CG_Category[_0x53838b(0x225)][_0x53838b(0x284)]=function(_0x5c7917){const _0x3c635c=_0x53838b,_0x1e8753=this[_0x3c635c(0x12a)](_0x5c7917),_0x50b014=this['commandName'](_0x5c7917),_0x5bce45=this[_0x3c635c(0x21a)](_0x50b014)[_0x3c635c(0x29e)];this[_0x3c635c(0x17c)](this[_0x3c635c(0x296)](_0x5c7917));const _0x4dabed=this[_0x3c635c(0x158)]();if(_0x4dabed===_0x3c635c(0x247))_0x3c635c(0x244)==='ojEmE'?_0x5c2649['x']=this['padding']+_0x54a532[_0x3c635c(0x140)](_0x10689b['STAGGER_FULL']/0x2):this[_0x3c635c(0xc9)](_0x50b014,_0x1e8753['x']+_0x1e8753[_0x3c635c(0x29e)]-_0x5bce45,_0x1e8753['y'],_0x5bce45);else{if(_0x4dabed==='center'){if(_0x3c635c(0x144)===_0x3c635c(0x137))this[_0x3c635c(0x1fe)]['visible']=this['_viewModeVisible'];else{const _0x690b98=_0x1e8753['x']+Math[_0x3c635c(0x140)]((_0x1e8753['width']-_0x5bce45)/0x2);this[_0x3c635c(0xc9)](_0x50b014,_0x690b98,_0x1e8753['y'],_0x5bce45);}}else this[_0x3c635c(0xc9)](_0x50b014,_0x1e8753['x'],_0x1e8753['y'],_0x5bce45);}},Window_CG_Category[_0x53838b(0x225)][_0x53838b(0x139)]=function(_0x92958b){const _0x1455b8=_0x53838b;this['commandName'](_0x92958b)[_0x1455b8(0x10f)](/\\I\[(\d+)\]/i);const _0x35f883=Number(RegExp['$1'])||0x0,_0x2e0264=this[_0x1455b8(0x12a)](_0x92958b),_0x2fe589=_0x2e0264['x']+Math[_0x1455b8(0x140)]((_0x2e0264['width']-ImageManager[_0x1455b8(0x262)])/0x2),_0x55cd34=_0x2e0264['y']+(_0x2e0264[_0x1455b8(0x26d)]-ImageManager[_0x1455b8(0x163)])/0x2;this[_0x1455b8(0x182)](_0x35f883,_0x2fe589,_0x55cd34);},Window_CG_Category[_0x53838b(0x225)][_0x53838b(0x2aa)]=function(_0x1b16e9){const _0xb7a91f=_0x53838b;this[_0xb7a91f(0x211)]=_0x1b16e9,this[_0xb7a91f(0x145)]();},Window_CG_Category[_0x53838b(0x225)]['updateGalleryWindow']=function(){const _0x479bbf=_0x53838b;if(!this[_0x479bbf(0x211)])return;const _0xc35618=this[_0x479bbf(0x1f5)]()[_0x479bbf(0x268)][_0x479bbf(0x179)]()[_0x479bbf(0x1d7)]();this[_0x479bbf(0x211)]['setCategory'](_0xc35618);};function Window_CG_Gallery(){this['initialize'](...arguments);}Window_CG_Gallery[_0x53838b(0x225)]=Object['create'](Window_Command[_0x53838b(0x225)]),Window_CG_Gallery[_0x53838b(0x225)][_0x53838b(0x15f)]=Window_CG_Gallery,Window_CG_Gallery[_0x53838b(0x111)]=VisuMZ[_0x53838b(0x169)][_0x53838b(0x278)][_0x53838b(0x203)][_0x53838b(0xfd)],Window_CG_Gallery['MAXROW']=VisuMZ['CGGallery'][_0x53838b(0x278)][_0x53838b(0x203)][_0x53838b(0x121)],Window_CG_Gallery[_0x53838b(0x221)]=VisuMZ[_0x53838b(0x169)][_0x53838b(0x278)][_0x53838b(0x203)][_0x53838b(0x100)],Window_CG_Gallery[_0x53838b(0x275)]=VisuMZ[_0x53838b(0x169)][_0x53838b(0x278)][_0x53838b(0x203)][_0x53838b(0x2a9)],Window_CG_Gallery['IMG_BUFFER']=VisuMZ['CGGallery']['Settings']['Window'][_0x53838b(0x240)],Window_CG_Gallery[_0x53838b(0x119)]=VisuMZ[_0x53838b(0x169)][_0x53838b(0x278)]['Window'][_0x53838b(0xea)],Window_CG_Gallery['STAGGER_LEFT']=VisuMZ[_0x53838b(0x169)][_0x53838b(0x278)][_0x53838b(0x203)][_0x53838b(0x293)],Window_CG_Gallery['DRAW_ITEM_BACKGROUND']=VisuMZ[_0x53838b(0x169)][_0x53838b(0x278)]['Window'][_0x53838b(0x1df)],Window_CG_Gallery[_0x53838b(0x217)]={'show':VisuMZ[_0x53838b(0x169)][_0x53838b(0x278)][_0x53838b(0x203)][_0x53838b(0x23f)],'hideForSingles':!VisuMZ['CGGallery'][_0x53838b(0x278)][_0x53838b(0x203)]['GalleryWindow_Text_VariationsShowSingles'],'xAlign':VisuMZ[_0x53838b(0x169)][_0x53838b(0x278)][_0x53838b(0x203)]['GalleryWindow_Text_VariationsAlignX'],'yAlign':VisuMZ[_0x53838b(0x169)][_0x53838b(0x278)]['Window'][_0x53838b(0x132)],'variantComplete':VisuMZ[_0x53838b(0x169)]['Settings'][_0x53838b(0x14e)][_0x53838b(0x286)],'textFmt':VisuMZ['CGGallery']['Settings'][_0x53838b(0x14e)][_0x53838b(0x25a)]},Window_CG_Gallery[_0x53838b(0x25f)]={'show':VisuMZ[_0x53838b(0x169)][_0x53838b(0x278)][_0x53838b(0x203)][_0x53838b(0x192)],'text':VisuMZ[_0x53838b(0x169)][_0x53838b(0x278)]['Vocab'][_0x53838b(0x114)],'percentFmt':VisuMZ[_0x53838b(0x169)]['Settings']['Vocab'][_0x53838b(0x120)],'decimals':VisuMZ['CGGallery'][_0x53838b(0x278)][_0x53838b(0x203)][_0x53838b(0x1a6)],'fontFace':VisuMZ['CGGallery']['Settings']['Window'][_0x53838b(0x186)],'fontSize1':VisuMZ[_0x53838b(0x169)][_0x53838b(0x278)][_0x53838b(0x203)][_0x53838b(0x257)],'fontSize2':VisuMZ[_0x53838b(0x169)][_0x53838b(0x278)]['Window']['GalleryWindow_Text_CompletionFontSize2'],'offset':{'x':VisuMZ['CGGallery']['Settings'][_0x53838b(0x203)]['GalleryWindow_Text_CompletionOffsetX'],'y':VisuMZ['CGGallery'][_0x53838b(0x278)][_0x53838b(0x203)][_0x53838b(0x1f0)]},'angle':VisuMZ[_0x53838b(0x169)][_0x53838b(0x278)][_0x53838b(0x203)]['GalleryWindow_Text_CompletionAngle']},Window_CG_Gallery['PROGRESS_SPRITE']={'show':VisuMZ[_0x53838b(0x169)][_0x53838b(0x278)][_0x53838b(0x203)][_0x53838b(0x24e)],'text':VisuMZ[_0x53838b(0x169)][_0x53838b(0x278)][_0x53838b(0x14e)]['GalleryWindow_Text_ProgressVocab'],'percentFmt':VisuMZ['CGGallery'][_0x53838b(0x278)]['Vocab'][_0x53838b(0x16f)],'decimals':VisuMZ['CGGallery'][_0x53838b(0x278)][_0x53838b(0x203)]['GalleryWindow_Text_ProgressDecimals'],'fontFace':VisuMZ[_0x53838b(0x169)][_0x53838b(0x278)][_0x53838b(0x203)][_0x53838b(0xe3)],'fontSize1':VisuMZ[_0x53838b(0x169)][_0x53838b(0x278)][_0x53838b(0x203)][_0x53838b(0x1e9)],'fontSize2':VisuMZ[_0x53838b(0x169)][_0x53838b(0x278)]['Window'][_0x53838b(0x107)],'offset':{'x':VisuMZ[_0x53838b(0x169)][_0x53838b(0x278)][_0x53838b(0x203)]['GalleryWindow_Text_ProgressOffsetX'],'y':VisuMZ['CGGallery']['Settings'][_0x53838b(0x203)][_0x53838b(0x1d9)]},'angle':VisuMZ[_0x53838b(0x169)]['Settings']['Window'][_0x53838b(0x12e)]},Window_CG_Gallery[_0x53838b(0x225)]['initialize']=function(_0xc07081){const _0x4eb91b=_0x53838b;this['_category']='',Window_Command[_0x4eb91b(0x225)][_0x4eb91b(0x133)]['call'](this,_0xc07081),this[_0x4eb91b(0x1c2)](),this[_0x4eb91b(0x159)]();},Window_CG_Gallery[_0x53838b(0x225)][_0x53838b(0xda)]=function(){const _0x55db5d=_0x53838b;if(this['_itemWidth']!==undefined)return this[_0x55db5d(0x185)];const _0x45d252=(this[_0x55db5d(0x160)]-Window_CG_Gallery[_0x55db5d(0x119)])/this[_0x55db5d(0xef)]();return this[_0x55db5d(0x185)]=Math['floor'](_0x45d252),this['_itemWidth'];},Window_CG_Gallery[_0x53838b(0x225)][_0x53838b(0x1c4)]=function(){const _0x565eee=_0x53838b;if(this['_itemHeight']!==undefined)return this[_0x565eee(0x1f3)];const _0x340843=this[_0x565eee(0x134)]/Window_CG_Gallery[_0x565eee(0x17d)];return this[_0x565eee(0x1f3)]=Math[_0x565eee(0xf7)](_0x340843),this[_0x565eee(0x1f3)];},Window_CG_Gallery[_0x53838b(0x225)][_0x53838b(0x17b)]=function(){const _0x5c4e16=_0x53838b;return Window_CG_Gallery[_0x5c4e16(0x221)];},Window_CG_Gallery[_0x53838b(0x225)][_0x53838b(0x16b)]=function(){return Window_CG_Gallery['ROW_SPACING'];},Window_CG_Gallery['prototype']['maxCols']=function(){const _0x28a5f5=_0x53838b;return Window_CG_Gallery[_0x28a5f5(0x111)];},Window_CG_Gallery[_0x53838b(0x225)][_0x53838b(0x20c)]=function(_0x1b8a82){const _0x35966a=_0x53838b,_0x4037a9=this[_0x35966a(0xef)](),_0x36e513=Window_CG_Gallery[_0x35966a(0x17d)]-0x1,_0x543a05=this[_0x35966a(0xda)](),_0x5991ef=this['itemHeight'](),_0x7624ed=this['colSpacing'](),_0x488544=this[_0x35966a(0x16b)](),_0xcf915f=_0x1b8a82%_0x4037a9,_0x4eedc6=Math['floor'](_0x1b8a82/_0x4037a9),_0x1f8252=this[_0x35966a(0x1a5)](),_0x570c52=Window_CG_Gallery['STAGGER_FULL'],_0x1c7ae3=_0x4eedc6-_0x1f8252;let _0x20d424=0x0;if(Window_CG_Gallery[_0x35966a(0x277)]){if(_0x35966a(0x1a0)!==_0x35966a(0x1b6))_0x20d424=Math[_0x35966a(0x140)]((_0x36e513-_0x1c7ae3)/_0x36e513*_0x570c52);else return this[_0x35966a(0x299)]?_0x463272[_0x35966a(0x1db)][_0x35966a(0x19f)]['zoom']:_0x824dda[_0x35966a(0x225)]['buttonAssistText1'][_0x35966a(0x264)](this);}else _0x20d424=Math[_0x35966a(0x140)](_0x1c7ae3/_0x36e513*_0x570c52);const _0x537783=_0xcf915f*_0x543a05+_0x7624ed/0x2-this[_0x35966a(0x1bb)]()+_0x20d424,_0x393921=_0x4eedc6*_0x5991ef+_0x488544/0x2-this['scrollBaseY'](),_0xf04894=_0x543a05-_0x7624ed,_0x427eef=_0x5991ef-_0x488544;return new Rectangle(_0x537783,_0x393921,_0xf04894,_0x427eef);},Window_CG_Gallery[_0x53838b(0x225)][_0x53838b(0x1cf)]=function(_0x1265a4,_0x15c9e4){const _0x23a19d=_0x53838b;if(Window_CG_Gallery['STAGGER_FULL']<=0x0)return Window_Command['prototype'][_0x23a19d(0x1cf)][_0x23a19d(0x264)](this,_0x1265a4,_0x15c9e4);this['_scrollTargetX']=_0x1265a4[_0x23a19d(0x147)](0x0,this[_0x23a19d(0x12c)]()),this['_scrollTargetY']=_0x15c9e4['clamp'](0x0,this['maxScrollY']()),this['_scrollDuration']=0x1,this[_0x23a19d(0x10c)](),this[_0x23a19d(0x16a)]();},Window_CG_Gallery[_0x53838b(0x225)][_0x53838b(0x1d2)]=function(){const _0x31dc47=_0x53838b;if(this[_0x31dc47(0x29c)]()&&this[_0x31dc47(0x1be)]){if(_0x31dc47(0x2ab)==='VlaIw'){const _0x25babe=0x14;TouchInput['wheelY']>=_0x25babe&&(this['cursorDown'](![]),this[_0x31dc47(0x15b)]=0x8),TouchInput['wheelY']<=-_0x25babe&&(this[_0x31dc47(0xe7)](![]),this[_0x31dc47(0x15b)]=0x8);}else return _0x328041[_0x31dc47(0x225)][_0x31dc47(0x2a5)][_0x31dc47(0x264)](this);}},Window_CG_Gallery['prototype'][_0x53838b(0x28b)]=function(_0x3fa506){const _0x4915e0=_0x53838b;if(this[_0x4915e0(0x15b)]){this[_0x4915e0(0x15b)]--;return;}Window_Command['prototype'][_0x4915e0(0x28b)][_0x4915e0(0x264)](this,_0x3fa506);},Window_CG_Gallery[_0x53838b(0x225)][_0x53838b(0x15d)]=function(){SoundManager['playViewCgImage']();},Window_CG_Gallery[_0x53838b(0x225)][_0x53838b(0x19d)]=function(_0x11983e){const _0x537c5f=_0x53838b;_0x11983e=_0x11983e[_0x537c5f(0x179)]()[_0x537c5f(0x1d7)]();if(this[_0x537c5f(0x17a)]===_0x11983e)return;this[_0x537c5f(0x17a)]=_0x11983e,this[_0x537c5f(0x28d)](),this[_0x537c5f(0x199)](0x0),this[_0x537c5f(0x135)](),this[_0x537c5f(0xb9)](),this[_0x537c5f(0x1b4)]();},Window_CG_Gallery[_0x53838b(0x225)]['makeCommandList']=function(){const _0x22bbeb=_0x53838b,_0x35cd65=VisuMZ[_0x22bbeb(0x169)][_0x22bbeb(0x278)][_0x22bbeb(0x161)];for(const _0x54b055 of _0x35cd65){if(!this['includes'](_0x54b055))continue;const _0x2edc2a=$gameSystem['isCgGalleryUnlocked'](_0x54b055[_0x22bbeb(0x21c)]);this[_0x22bbeb(0x29b)]('',_0x22bbeb(0x13d),_0x2edc2a,_0x54b055);}},Window_CG_Gallery[_0x53838b(0x225)][_0x53838b(0x14d)]=function(_0xb04e16){const _0x492d7f=_0x53838b;if(!_0xb04e16)return![];if(_0xb04e16[_0x492d7f(0x21c)][_0x492d7f(0x179)]()[_0x492d7f(0x1d7)]()==='undefined')return![];if(_0xb04e16[_0x492d7f(0x21c)][_0x492d7f(0x1d7)]()==='')return![];if(this[_0x492d7f(0x17a)]===_0x492d7f(0x245))return!![];const _0x33fc95=_0xb04e16[_0x492d7f(0x20b)][_0x492d7f(0x179)]()['trim']();if(this[_0x492d7f(0x17a)]==='unlisted'){if('GAaje'!=='GAaje'){const _0x33a2c5=_0x1406de[_0x492d7f(0x169)][_0x492d7f(0x278)]['BgSettings'];_0x33a2c5&&(_0x33a2c5[_0x492d7f(0x172)]!==''||_0x33a2c5[_0x492d7f(0xf5)]!=='')&&(this[_0x492d7f(0x10e)]=new _0x50a3bd(_0x5f0583[_0x492d7f(0x261)](_0x33a2c5['BgFilename1'])),this[_0x492d7f(0x292)]=new _0x293361(_0x5f39dc[_0x492d7f(0x25c)](_0x33a2c5[_0x492d7f(0xf5)])),this['addChild'](this[_0x492d7f(0x10e)]),this[_0x492d7f(0xe5)](this[_0x492d7f(0x292)]),this['_backSprite1'][_0x492d7f(0x241)][_0x492d7f(0x13b)](this[_0x492d7f(0xb6)][_0x492d7f(0x270)](this,this[_0x492d7f(0x10e)])),this[_0x492d7f(0x292)][_0x492d7f(0x241)][_0x492d7f(0x13b)](this['adjustSprite'][_0x492d7f(0x270)](this,this['_backSprite2'])));}else{const _0x2bb700=VisuMZ['CGGallery'][_0x492d7f(0x25b)]();return!_0x2bb700[_0x492d7f(0x14d)](_0x33fc95);}}else{if(_0x492d7f(0x20f)===_0x492d7f(0x20f))return this['_category']===_0x33fc95;else{if(_0x5df602[_0x492d7f(0x188)](_0x360bfc,!![]))_0x1369c4+=0x1;}}},Window_CG_Gallery[_0x53838b(0x225)][_0x53838b(0x187)]=function(){const _0x41fbad=_0x53838b;Window_Command[_0x41fbad(0x225)][_0x41fbad(0x187)][_0x41fbad(0x264)](this);const _0x3ffeb2=this[_0x41fbad(0x1f5)]();if(_0x3ffeb2){if($gameSystem[_0x41fbad(0x188)](_0x3ffeb2['Filename'])){if(_0x41fbad(0x23a)!==_0x41fbad(0x23a))return this['_viewMode']?_0x5bedda['getInputMultiButtonStrings'](_0x41fbad(0x24c),_0x41fbad(0x104)):_0x3ad773[_0x41fbad(0x225)][_0x41fbad(0x18c)][_0x41fbad(0x264)](this);else this[_0x41fbad(0x25d)][_0x41fbad(0x177)](_0x3ffeb2[_0x41fbad(0x21f)]||'');}else _0x41fbad(0x103)!==_0x41fbad(0x103)?_0x10fa6c[_0x41fbad(0x222)](_0x5e638b):this[_0x41fbad(0x25d)][_0x41fbad(0x177)](TextManager[_0x41fbad(0x1db)][_0x41fbad(0x218)][_0x41fbad(0xf0)]);}},Window_CG_Gallery[_0x53838b(0x225)]['drawItemBackground']=function(_0x48321a){const _0x2ca740=_0x53838b;if(!Window_CG_Gallery['DRAW_ITEM_BACKGROUND'])return;Window_Command['prototype'][_0x2ca740(0x2a1)][_0x2ca740(0x264)](this,_0x48321a);},Window_CG_Gallery[_0x53838b(0x225)][_0x53838b(0x23b)]=function(_0xe6c4ca){const _0x45e9ce=_0x53838b;if(!this[_0x45e9ce(0xd8)])return;if(!this['_list'][_0xe6c4ca])return;const _0x34fdf7=this[_0x45e9ce(0xd8)][_0xe6c4ca]['ext'];if(!_0x34fdf7)return;const _0x532d73=this[_0x45e9ce(0x20c)](_0xe6c4ca),_0x1b8e55=_0x34fdf7['Filename'];if($gameSystem['isCgGalleryUnlocked'](_0x1b8e55)){if('Wwvxd'!=='Wwvxd')return _0x30fdb6[_0x45e9ce(0x1db)]['buttonAssist']['zoom'];else{const _0x2969a9=ImageManager[_0x45e9ce(0x1ad)](_0x1b8e55);_0x2969a9[_0x45e9ce(0x13b)](this[_0x45e9ce(0x143)][_0x45e9ce(0x270)](this,_0x34fdf7,_0x2969a9,_0xe6c4ca,_0x532d73));}}else{const _0x1a9c05=ImageManager['cachedCgGalleryLockedImage']();_0x1a9c05[_0x45e9ce(0x13b)](this[_0x45e9ce(0x143)][_0x45e9ce(0x270)](this,_0x34fdf7,_0x1a9c05,_0xe6c4ca,_0x532d73));}},Window_CG_Gallery[_0x53838b(0x225)][_0x53838b(0x143)]=function(_0x45ecbf,_0x1cfe11,_0x3a5e1a,_0x6bcea3){const _0x1eb3a4=_0x53838b,_0x5cd506=this[_0x1eb3a4(0x20c)](_0x3a5e1a);if(JSON[_0x1eb3a4(0xcf)](_0x5cd506)!==JSON[_0x1eb3a4(0xcf)](_0x6bcea3))return;_0x5cd506[_0x1eb3a4(0x29e)]-=Window_CG_Gallery[_0x1eb3a4(0x16e)]*0x2,_0x5cd506[_0x1eb3a4(0x26d)]-=Window_CG_Gallery[_0x1eb3a4(0x16e)]*0x2,_0x5cd506['x']+=Window_CG_Gallery[_0x1eb3a4(0x16e)],_0x5cd506['y']+=Window_CG_Gallery[_0x1eb3a4(0x16e)];let _0x473867=_0x5cd506['x'],_0x5c306b=_0x5cd506['y'];const _0x2ab1e0=_0x5cd506[_0x1eb3a4(0x29e)]/_0x1cfe11['width'],_0x1f02a2=_0x5cd506['height']/_0x1cfe11['height'],_0x2b011e=Math['min'](_0x2ab1e0,_0x1f02a2,0x1),_0x1761ba=Math[_0x1eb3a4(0xf4)](_0x1cfe11['width']*_0x2b011e),_0x11b2e3=Math[_0x1eb3a4(0xf4)](_0x1cfe11[_0x1eb3a4(0x26d)]*_0x2b011e);_0x473867+=Math[_0x1eb3a4(0xf4)]((_0x5cd506[_0x1eb3a4(0x29e)]-_0x1761ba)/0x2),_0x5c306b+=Math[_0x1eb3a4(0xf4)]((_0x5cd506[_0x1eb3a4(0x26d)]-_0x11b2e3)/0x2);const _0x50f5d4=_0x1cfe11[_0x1eb3a4(0x29e)],_0x4a113e=_0x1cfe11[_0x1eb3a4(0x26d)];this[_0x1eb3a4(0x1ce)][_0x1eb3a4(0x116)][_0x1eb3a4(0x167)]=!![],this[_0x1eb3a4(0x1ce)][_0x1eb3a4(0x17f)](_0x1cfe11,0x0,0x0,_0x50f5d4,_0x4a113e,_0x473867,_0x5c306b,_0x1761ba,_0x11b2e3),this[_0x1eb3a4(0x1ce)][_0x1eb3a4(0x116)]['imageSmoothingEnabled']=!![],this[_0x1eb3a4(0x149)](_0x45ecbf,_0x3a5e1a);},Window_CG_Gallery[_0x53838b(0x225)][_0x53838b(0x149)]=function(_0x42055f,_0x4e48c4){const _0x2ed61b=_0x53838b;if(!Window_CG_Gallery[_0x2ed61b(0x217)][_0x2ed61b(0x2a8)])return;if(!$gameSystem[_0x2ed61b(0x188)](_0x42055f[_0x2ed61b(0x21c)],![]))return;const _0x3761bd=_0x42055f['Variations']['length']+0x1;if(Window_CG_Gallery[_0x2ed61b(0x217)]['hideForSingles']&&_0x3761bd===0x1)return;let _0x41c071=0x1;for(let _0x25bbc4 of _0x42055f[_0x2ed61b(0x173)]){if($gameSystem[_0x2ed61b(0x188)](_0x25bbc4,!![]))_0x41c071+=0x1;}let _0x786227='';if(_0x3761bd===_0x41c071&&Window_CG_Gallery[_0x2ed61b(0x217)]['variantComplete']!=='')_0x786227=Window_CG_Gallery['DRAW_VARIATION'][_0x2ed61b(0x123)];else{const _0x379829=Window_CG_Gallery[_0x2ed61b(0x217)][_0x2ed61b(0x18f)],_0x586e70=Window_CG_Gallery[_0x2ed61b(0x217)]['decimals'],_0x451e18=Math[_0x2ed61b(0xf4)](_0x41c071/_0x3761bd*0x64);_0x786227=_0x379829[_0x2ed61b(0x142)](_0x451e18,_0x41c071,_0x3761bd);}const _0x561138=this[_0x2ed61b(0x166)](_0x4e48c4);let _0x478471=_0x561138['x'],_0xbbafbf=_0x561138['y'];const _0x31c6f2=this[_0x2ed61b(0x21a)](_0x786227)[_0x2ed61b(0x29e)],_0x2bb810=this['textSizeEx'](_0x786227)[_0x2ed61b(0x26d)],_0x3c673e=Window_CG_Gallery[_0x2ed61b(0x217)][_0x2ed61b(0x1bd)]['toLowerCase']()[_0x2ed61b(0x1d7)]();switch(_0x3c673e){case _0x2ed61b(0x11b):_0x478471+=Math[_0x2ed61b(0x140)](_0x561138[_0x2ed61b(0x29e)]-_0x31c6f2)/0x2;break;case'right':_0x478471+=_0x561138[_0x2ed61b(0x29e)]-_0x31c6f2;break;}switch(Window_CG_Gallery[_0x2ed61b(0x217)][_0x2ed61b(0x16c)][_0x2ed61b(0x179)]()[_0x2ed61b(0x1d7)]()){case _0x2ed61b(0xe2):_0xbbafbf+=Math[_0x2ed61b(0x140)](_0x561138[_0x2ed61b(0x26d)]-_0x2bb810)/0x2;break;case _0x2ed61b(0x141):_0xbbafbf+=_0x561138[_0x2ed61b(0x26d)]-_0x2bb810;break;}this[_0x2ed61b(0xc9)](_0x786227,_0x478471,_0xbbafbf);},Window_CG_Gallery[_0x53838b(0x225)][_0x53838b(0x1c2)]=function(){const _0x13f3fd=_0x53838b;if(!Window_CG_Gallery[_0x13f3fd(0x25f)][_0x13f3fd(0x2a8)])return;const _0x340d60=new Sprite();this[_0x13f3fd(0xe5)](_0x340d60);const _0x411225=Math['max'](Window_CG_Gallery[_0x13f3fd(0x119)],0x64);_0x340d60[_0x13f3fd(0x241)]=new Bitmap(_0x411225,this[_0x13f3fd(0x1c4)]()),_0x340d60[_0x13f3fd(0x1cb)]['x']=0.5,_0x340d60[_0x13f3fd(0x1cb)]['y']=0.5,this['_completionSprite']=_0x340d60,this['updateCompletionSpriteBitmap'](),Window_CG_Gallery[_0x13f3fd(0x277)]?_0x340d60['x']=this[_0x13f3fd(0x15e)]+Math[_0x13f3fd(0x140)](Window_CG_Gallery['STAGGER_FULL']/0x2):_0x340d60['x']=this[_0x13f3fd(0x29e)]-(this[_0x13f3fd(0x15e)]+Math[_0x13f3fd(0x140)](Window_CG_Gallery[_0x13f3fd(0x119)]/0x2)),_0x340d60['y']=this[_0x13f3fd(0x15e)]+Math[_0x13f3fd(0x140)](this[_0x13f3fd(0x1c4)]()/0x2),_0x340d60['x']+=Window_CG_Gallery['COMPLETION_SPRITE']['offset']['x'],_0x340d60['y']+=Window_CG_Gallery[_0x13f3fd(0x25f)][_0x13f3fd(0x1b3)]['y'],_0x340d60['angle']=-Window_CG_Gallery['COMPLETION_SPRITE'][_0x13f3fd(0x18b)];},Window_CG_Gallery[_0x53838b(0x225)][_0x53838b(0xb9)]=function(){const _0x4169cc=_0x53838b,_0x3d4a88=this[_0x4169cc(0xf3)],_0x336719=_0x3d4a88['bitmap'];_0x336719[_0x4169cc(0x27f)]();const _0x55d840=Window_CG_Gallery[_0x4169cc(0x25f)][_0x4169cc(0x128)];_0x336719[_0x4169cc(0x265)]=Window_CG_Gallery[_0x4169cc(0x25f)][_0x4169cc(0x265)],_0x336719[_0x4169cc(0x196)]=Window_CG_Gallery['COMPLETION_SPRITE'][_0x4169cc(0x127)];const _0x5e1e67=Math[_0x4169cc(0xf4)](_0x336719[_0x4169cc(0x26d)]/0x2)-(_0x336719[_0x4169cc(0x196)]+0x4);_0x336719['drawText'](_0x55d840,0x0,_0x5e1e67,_0x336719['width'],_0x336719[_0x4169cc(0x196)]+0x4,_0x4169cc(0x11b));const _0x43b53f=$gameSystem[_0x4169cc(0x288)](this[_0x4169cc(0x17a)]),_0x1b90c3=Window_CG_Gallery['COMPLETION_SPRITE'][_0x4169cc(0x272)],_0x49c3fd=(_0x43b53f*0x64)['toFixed'](_0x1b90c3),_0x299412=$gameSystem[_0x4169cc(0x1d8)](this[_0x4169cc(0x17a)]),_0x39c5a6=$gameSystem[_0x4169cc(0x298)](this[_0x4169cc(0x17a)]),_0x250975=Window_CG_Gallery[_0x4169cc(0x25f)][_0x4169cc(0xd5)]['format'](_0x49c3fd,_0x299412,_0x39c5a6);_0x336719[_0x4169cc(0x265)]=Window_CG_Gallery['COMPLETION_SPRITE'][_0x4169cc(0x265)],_0x336719[_0x4169cc(0x196)]=Window_CG_Gallery[_0x4169cc(0x25f)][_0x4169cc(0x1c9)];const _0x1c8d11=Math[_0x4169cc(0xf4)](_0x336719['height']/0x2);_0x336719[_0x4169cc(0x280)](_0x250975,0x0,_0x1c8d11,_0x336719[_0x4169cc(0x29e)],_0x336719[_0x4169cc(0x196)]+0x4,_0x4169cc(0x11b));},Window_CG_Gallery[_0x53838b(0x225)][_0x53838b(0x159)]=function(){const _0xeafccb=_0x53838b;if(!Window_CG_Gallery[_0xeafccb(0x239)][_0xeafccb(0x2a8)])return;const _0x44079a=new Sprite();this['addChild'](_0x44079a);const _0x3a908b=Math[_0xeafccb(0xdd)](Window_CG_Gallery[_0xeafccb(0x119)],0x64);_0x44079a['bitmap']=new Bitmap(_0x3a908b,this[_0xeafccb(0x1c4)]()),_0x44079a[_0xeafccb(0x1cb)]['x']=0.5,_0x44079a[_0xeafccb(0x1cb)]['y']=0.5,this[_0xeafccb(0x1a8)]=_0x44079a,this[_0xeafccb(0x1b4)](),Window_CG_Gallery['STAGGER_LEFT']?_0xeafccb(0x1c8)!==_0xeafccb(0x237)?_0x44079a['x']=this['width']-(this[_0xeafccb(0x15e)]+Math[_0xeafccb(0x140)](Window_CG_Gallery['STAGGER_FULL']/0x2)):_0x1ce252=_0x58c79e[_0xeafccb(0x217)]['variantComplete']:_0x44079a['x']=this['padding']+Math[_0xeafccb(0x140)](Window_CG_Gallery[_0xeafccb(0x119)]/0x2),_0x44079a['y']=this[_0xeafccb(0x26d)]-this[_0xeafccb(0x15e)]-Math[_0xeafccb(0x140)](this['itemHeight']()/0x2),_0x44079a['x']+=Window_CG_Gallery[_0xeafccb(0x239)][_0xeafccb(0x1b3)]['x'],_0x44079a['y']+=Window_CG_Gallery[_0xeafccb(0x239)][_0xeafccb(0x1b3)]['y'],_0x44079a[_0xeafccb(0x18b)]=-Window_CG_Gallery['PROGRESS_SPRITE'][_0xeafccb(0x18b)];},Window_CG_Gallery[_0x53838b(0x225)]['updateProgressSpriteBitmap']=function(){const _0x538b02=_0x53838b,_0x57af79=this[_0x538b02(0x1a8)],_0x379c36=_0x57af79[_0x538b02(0x241)];_0x379c36[_0x538b02(0x27f)]();const _0x30c785=Window_CG_Gallery[_0x538b02(0x239)][_0x538b02(0x128)];_0x379c36[_0x538b02(0x265)]=Window_CG_Gallery[_0x538b02(0x239)][_0x538b02(0x265)],_0x379c36['fontSize']=Window_CG_Gallery[_0x538b02(0x239)][_0x538b02(0x127)];const _0x41b6db=Math['round'](_0x379c36[_0x538b02(0x26d)]/0x2)-(_0x379c36[_0x538b02(0x196)]+0x4);_0x379c36[_0x538b02(0x280)](_0x30c785,0x0,_0x41b6db,_0x379c36['width'],_0x379c36[_0x538b02(0x196)]+0x4,'center');const _0x38a51d=$gameSystem['cgGalleryCompletionRate'](this[_0x538b02(0x17a)]),_0xfc98cb=Window_CG_Gallery[_0x538b02(0x239)][_0x538b02(0x272)],_0x7084cb=(_0x38a51d*0x64)[_0x538b02(0xdb)](_0xfc98cb),_0x7b812c=$gameSystem[_0x538b02(0x1d8)](this[_0x538b02(0x17a)]),_0x11a91d=$gameSystem[_0x538b02(0x298)](this[_0x538b02(0x17a)]),_0x214aa4=Window_CG_Gallery['PROGRESS_SPRITE'][_0x538b02(0xd5)][_0x538b02(0x142)](_0x7084cb,_0x7b812c,_0x11a91d);_0x379c36[_0x538b02(0x265)]=Window_CG_Gallery['PROGRESS_SPRITE'][_0x538b02(0x265)],_0x379c36[_0x538b02(0x196)]=Window_CG_Gallery['PROGRESS_SPRITE'][_0x538b02(0x1c9)];const _0x182ca0=Math[_0x538b02(0xf4)](_0x379c36[_0x538b02(0x26d)]/0x2);_0x379c36['drawText'](_0x214aa4,0x0,_0x182ca0,_0x379c36[_0x538b02(0x29e)],_0x379c36['fontSize']+0x4,_0x538b02(0x11b));};