//=============================================================================
// VisuStella MZ - Dice Rolls & RNG Seeds
// VisuMZ_4_DiceRollsRngSeeds.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_4_DiceRollsRngSeeds = true;

var VisuMZ = VisuMZ || {};
VisuMZ.DiceRollsRngSeeds = VisuMZ.DiceRollsRngSeeds || {};
VisuMZ.DiceRollsRngSeeds.version = 1.01;

//=============================================================================
/* ----------------------------------------------------------------------------
 * Dice Roll Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Dice:
 *
 * @param Mechanics
 * @text Mechanics
 *
 * @param MaxDiceCount:num
 * @text Max Dice Count
 * @parent Mechanics
 * @type number
 * @min 1
 * @desc What is the maximum number of dice that can be thrown at a time?
 * @default 10
 *
 * @param Appearances
 * @text Dice Appearances
 *
 * @param D4:struct
 * @text D4 Appearance
 * @parent Appearances
 * @type struct<DiceType>
 * @desc Adjust the Dice Appearance settings for the D4 here.
 * @default {"filenames:arraystr":"[]","colors:arraystr":"[\"#ff7479\",\"#ffa67b\",\"#f7941d\",\"#fff200\",\"#d3a87d\",\"#8dc63f\",\"#6cf77f\",\"#2aec88\",\"#22e6d8\",\"#6bd6ff\",\"#2eacfe\",\"#2895ff\",\"#7477e4\",\"#af70df\",\"#e16ede\",\"#ff8bd0\"]","NumberSettings":"","fontSize:num":"60","outlineWidth:num":"4","fontOffsetX:num":"+0","fontOffsetY:num":"+18","PositionSettings":"","positionOffsetX:num":"+0","positionOffsetY:num":"+8"}
 *
 * @param D6:struct
 * @text D6 Appearance
 * @parent Appearances
 * @type struct<DiceType>
 * @desc Adjust the Dice Appearance settings for the D6 here.
 * @default {"filenames:arraystr":"[]","colors:arraystr":"[\"#ff7479\",\"#ffa67b\",\"#f7941d\",\"#fff200\",\"#d3a87d\",\"#8dc63f\",\"#6cf77f\",\"#2aec88\",\"#22e6d8\",\"#6bd6ff\",\"#2eacfe\",\"#2895ff\",\"#7477e4\",\"#af70df\",\"#e16ede\",\"#ff8bd0\"]","NumberSettings":"","fontSize:num":"72","outlineWidth:num":"4","fontOffsetX:num":"+4","fontOffsetY:num":"+4","PositionSettings":"","positionOffsetX:num":"+0","positionOffsetY:num":"+0"}
 *
 * @param D8:struct
 * @text D8 Appearance
 * @parent Appearances
 * @type struct<DiceType>
 * @desc Adjust the Dice Appearance settings for the D8 here.
 * @default {"filenames:arraystr":"[]","colors:arraystr":"[\"#ff7479\",\"#ffa67b\",\"#f7941d\",\"#fff200\",\"#d3a87d\",\"#8dc63f\",\"#6cf77f\",\"#2aec88\",\"#22e6d8\",\"#6bd6ff\",\"#2eacfe\",\"#2895ff\",\"#7477e4\",\"#af70df\",\"#e16ede\",\"#ff8bd0\"]","NumberSettings":"","fontSize:num":"40","outlineWidth:num":"4","fontOffsetX:num":"+0","fontOffsetY:num":"+0","PositionSettings":"","positionOffsetX:num":"+0","positionOffsetY:num":"+0"}
 *
 * @param D10:struct
 * @text D10 Appearance
 * @parent Appearances
 * @type struct<DiceType>
 * @desc Adjust the Dice Appearance settings for the D10 here.
 * @default {"filenames:arraystr":"[]","colors:arraystr":"[\"#ff7479\",\"#ffa67b\",\"#f7941d\",\"#fff200\",\"#d3a87d\",\"#8dc63f\",\"#6cf77f\",\"#2aec88\",\"#22e6d8\",\"#6bd6ff\",\"#2eacfe\",\"#2895ff\",\"#7477e4\",\"#af70df\",\"#e16ede\",\"#ff8bd0\"]","NumberSettings":"","fontSize:num":"40","outlineWidth:num":"4","fontOffsetX:num":"+0","fontOffsetY:num":"+8","PositionSettings":"","positionOffsetX:num":"+0","positionOffsetY:num":"+0"}
 *
 * @param D12:struct
 * @text D12 Appearance
 * @parent Appearances
 * @type struct<DiceType>
 * @desc Adjust the Dice Appearance settings for the D12 here.
 * @default {"filenames:arraystr":"[]","colors:arraystr":"[\"#ff7479\",\"#ffa67b\",\"#f7941d\",\"#fff200\",\"#d3a87d\",\"#8dc63f\",\"#6cf77f\",\"#2aec88\",\"#22e6d8\",\"#6bd6ff\",\"#2eacfe\",\"#2895ff\",\"#7477e4\",\"#af70df\",\"#e16ede\",\"#ff8bd0\"]","NumberSettings":"","fontSize:num":"40","outlineWidth:num":"4","fontOffsetX:num":"+0","fontOffsetY:num":"+0","PositionSettings":"","positionOffsetX:num":"+0","positionOffsetY:num":"+0"}
 *
 * @param D20:struct
 * @text D20 Appearance
 * @parent Appearances
 * @type struct<DiceType>
 * @desc Adjust the Dice Appearance settings for the D20 here.
 * @default {"filenames:arraystr":"[]","colors:arraystr":"[\"#ff7479\",\"#ffa67b\",\"#f7941d\",\"#fff200\",\"#d3a87d\",\"#8dc63f\",\"#6cf77f\",\"#2aec88\",\"#22e6d8\",\"#6bd6ff\",\"#2eacfe\",\"#2895ff\",\"#7477e4\",\"#af70df\",\"#e16ede\",\"#ff8bd0\"]","NumberSettings":"","fontSize:num":"32","outlineWidth:num":"4","fontOffsetX:num":"+0","fontOffsetY:num":"+0","PositionSettings":"","positionOffsetX:num":"+0","positionOffsetY:num":"+0"}
 *
 * @param ColorRatio
 * @text Color Ratios
 *
 * @param ColorBorderRatio:num
 * @text Border Ratio
 * @parent ColorRatio
 * @desc Used for generated colors.
 * Darkness ratio for border color.
 * @default 0.30
 *
 * @param Color1Ratio:num
 * @text Color 1 Ratio
 * @parent ColorRatio
 * @desc Used for generated colors.
 * Darkness ratio for darker color.
 * @default 0.60
 *
 * @param Color2Ratio:num
 * @text Color 2 Ratio
 * @parent ColorRatio
 * @desc Used for generated colors.
 * Darkness ratio for middle color.
 * @default 0.80
 *
 * @param Color3Ratio:num
 * @text Color 3 Ratio
 * @parent ColorRatio
 * @desc Used for generated colors.
 * Darkness ratio for main color.
 * @default 1.00
 *
 * @param ArrangeOffset
 * @text Arrange Offset
 *
 * @param ArrangeOffsetX:num
 * @text Offset X
 * @parent ArrangeOffset
 * @desc Offsets the dice arrangement x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param ArrangeOffsetY:num
 * @text Offset Y
 * @parent ArrangeOffset
 * @desc Offsets the dice arrangement y position.
 * Negative: up. Positive: down.
 * @default +0
 *
 * @param FadeSettings
 * @text Fade Settings
 *
 * @param fadeInDuration:num
 * @text Fade In Duration
 * @parent FadeSettings
 * @type number
 * @min 1
 * @desc How many frames it takes to fade in dice?
 * 60 frames = 1 second.
 * @default 30
 *
 * @param fadeOutDuration:num
 * @text Fade Out Duration
 * @parent FadeSettings
 * @type number
 * @min 1
 * @desc How many frames it takes to fade out dice?
 * 60 frames = 1 second.
 * @default 20
 *
 * @param finalizeDelay:num
 * @text Finalize Delay
 * @parent FadeSettings
 * @type number
 * @min 1
 * @desc How many frames to wait before fading out?
 * 60 frames = 1 second.
 * @default 60
 *
 * @param RollSettings
 * @text Rolling Effect
 *
 * @param rollDuration:num
 * @text Dice Roll Duration
 * @parent RollSettings
 * @type number
 * @min 1
 * @desc How many frames it takes to roll a dice?
 * 60 frames = 1 second.
 * @default 60
 *
 * @param rollDelay:num
 * @text Between Roll Delay
 * @parent RollSettings
 * @type number
 * @min 1
 * @desc How many frames between multiple dice rolls?
 * 60 frames = 1 second.
 * @default 10
 *
 * @param rollHeight:num
 * @text Dice Roll Height
 * @parent RollSettings
 * @type number
 * @min 1
 * @desc How high should the dice jump up for its roll in pixels?
 * @default 160
 *
 * @param rotateSpeed:num
 * @text Dice Rotate Speed
 * @parent RollSettings
 * @desc How many degrees does the dice rotate per frame while rolling?
 * @default +15
 *
 * @param MoveSettings
 * @text Movement Settings
 *
 * @param moveDuration:num
 * @text Move Duration
 * @parent MoveSettings
 * @type number
 * @min 1
 * @desc How many frames it takes to move dice?
 * 60 frames = 1 second.
 * @default 20
 *
 * @param scaleDuration:num
 * @text Scaling Duration
 * @parent MoveSettings
 * @type number
 * @min 1
 * @desc How many frames it takes to change dice scale?
 * 60 frames = 1 second.
 * @default 40
 *
 * @param numberDuration:num
 * @text Number Climb Tick
 * @parent MoveSettings
 * @type number
 * @min 1
 * @desc How many frames are there between number ticks?
 * 60 frames = 1 second.
 * @default 4
 *
 * @param maxNumberDuration:num
 * @text Max Number Duration
 * @parent MoveSettings
 * @type number
 * @min 1
 * @desc Max number of frames to process number ticks?
 * 60 frames = 1 second.
 * @default 80
 *
 * @param numberColorShift:eval
 * @text Number Color Shift
 * @parent MoveSettings
 * @type boolean
 * @on Shift Color
 * @off Don't Shift
 * @desc Allow dice number colors to change due to modifiers?
 * @default true
 *
 * @param rollModDelay:num
 * @text Pre-Modifier Delay
 * @parent MoveSettings
 * @type number
 * @min 1
 * @desc Delay frames before applying modifiers?
 * 60 frames = 1 second.
 * @default 60
 *
 */
/* ----------------------------------------------------------------------------
 * Dice Type Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~DiceType:
 *
 * @param filenames:arraystr
 * @text Image Filename(s)
 * @type file[]
 * @dir img/pictures/
 * @require 1
 * @desc Use custom images for this dice? Priority over colors.
 * Location: img/pictures/
 * @default []
 *
 * @param colors:arraystr
 * @text Dice Colors(s)
 * @type string[]
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default ["#ff7479","#ffa67b","#f7941d","#fff200","#d3a87d","#8dc63f","#6cf77f","#2aec88","#22e6d8","#6bd6ff","#2eacfe","#2895ff","#7477e4","#af70df","#e16ede","#ff8bd0"]
 * 
 * @param NumberSettings
 * @text Number Settings
 *
 * @param fontSize:num
 * @text Font Size
 * @parent NumberSettings
 * @type number
 * @min 1
 * @desc Font size used for dice number.
 * @default 40
 *
 * @param outlineWidth:num
 * @text Number Outline
 * @parent NumberSettings
 * @type number
 * @min 0
 * @desc What width to use for number outline?
 * Use 0 to not use an outline.
 * @default 4
 *
 * @param fontOffsetX:num
 * @text Offset X
 * @parent NumberSettings
 * @desc Offsets the number x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param fontOffsetY:num
 * @text Offset Y
 * @parent NumberSettings
 * @desc Offsets the number y position.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @param PositionSettings
 * @text Position Settings
 *
 * @param positionOffsetX:num
 * @text Offset X
 * @parent PositionSettings
 * @desc Offsets the sprite x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param positionOffsetY:num
 * @text Offset Y
 * @parent PositionSettings
 * @desc Offsets the sprite y position.
 * Negative: up. Positive: down.
 * @default +0
 *
 */
/* ----------------------------------------------------------------------------
 * RNG Seed Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~RngSeed:
 * 
 * @param LCG
 * @text Linear Congruential
 *
 * @param modulus:num
 * @text Modulus
 * @parent LCG
 * @desc The linear congruential generator modulus.
 * Do not change unless you know what you're doing.
 * @default 2147483648
 *
 * @param multiplier:num
 * @text Multiplier
 * @parent LCG
 * @desc The linear congruential generator multiplier.
 * Do not change unless you know what you're doing.
 * @default 1103515245
 *
 * @param increment:num
 * @text Increment
 * @parent LCG
 * @desc The linear congruential generator increment.
 * Do not change unless you know what you're doing.
 * @default 12345
 * 
 * @param Action
 * @text Action Defaults
 *
 * @param DefaultRngSeed:str
 * @text Default RNG Seed?
 * @parent Action
 * @desc Default seed used for actions. Use 'auto' to auto seed.
 * Leave empty or 'none' to not use.
 * @default none
 *
 */
/* ----------------------------------------------------------------------------
 * Sound Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Sound:
 *
 * @param Throw
 * @text Dice Throw Sound
 * 
 * @param throw_name:str
 * @text Filename
 * @parent Throw
 * @type file
 * @dir audio/se/
 * @require 1
 * @desc Filename of the sound effect played.
 * @default Bow2
 *
 * @param throw_volume:num
 * @text Volume
 * @parent Throw
 * @type number
 * @max 100
 * @desc Volume of the sound effect played.
 * @default 90
 *
 * @param throw_pitch:num
 * @text Pitch
 * @parent Throw
 * @type number
 * @desc Pitch of the sound effect played.
 * @default 120
 *
 * @param throw_pan:num
 * @text Pan
 * @parent Throw
 * @desc Pan of the sound effect played.
 * @default 0
 *
 * @param Tick
 * @text Increment Tick Sound
 * 
 * @param tick_name:str
 * @text Filename
 * @parent Tick
 * @type file
 * @dir audio/se/
 * @require 1
 * @desc Filename of the sound effect played.
 * @default Cursor1
 *
 * @param tick_volume:num
 * @text Volume
 * @parent Tick
 * @type number
 * @max 100
 * @desc Volume of the sound effect played.
 * @default 90
 *
 * @param tick_pitch:num
 * @text Pitch
 * @parent Tick
 * @type number
 * @desc Pitch of the sound effect played.
 * @default 150
 *
 * @param tick_pan:num
 * @text Pan
 * @parent Tick
 * @desc Pan of the sound effect played.
 * @default 0
 *
 * @param Bonus
 * @text Bonus Use Sound
 * 
 * @param bonus_name:str
 * @text Filename
 * @parent Bonus
 * @type file
 * @dir audio/se/
 * @require 1
 * @desc Filename of the sound effect played.
 * @default Skill3
 *
 * @param bonus_volume:num
 * @text Volume
 * @parent Bonus
 * @type number
 * @max 100
 * @desc Volume of the sound effect played.
 * @default 90
 *
 * @param bonus_pitch:num
 * @text Pitch
 * @parent Bonus
 * @type number
 * @desc Pitch of the sound effect played.
 * @default 120
 *
 * @param bonus_pan:num
 * @text Pan
 * @parent Bonus
 * @desc Pan of the sound effect played.
 * @default 0
 *
 * @param Success
 * @text Roll Success Sound
 * 
 * @param success_name:str
 * @text Filename
 * @parent Success
 * @type file
 * @dir audio/se/
 * @require 1
 * @desc Filename of the sound effect played.
 * @default Chime2
 *
 * @param success_volume:num
 * @text Volume
 * @parent Success
 * @type number
 * @max 100
 * @desc Volume of the sound effect played.
 * @default 90
 *
 * @param success_pitch:num
 * @text Pitch
 * @parent Success
 * @type number
 * @desc Pitch of the sound effect played.
 * @default 100
 *
 * @param success_pan:num
 * @text Pan
 * @parent Success
 * @desc Pan of the sound effect played.
 * @default 0
 *
 * @param Failure
 * @text Roll Failure Sound
 * 
 * @param failure_name:str
 * @text Filename
 * @parent Failure
 * @type file
 * @dir audio/se/
 * @require 1
 * @desc Filename of the sound effect played.
 * @default Buzzer2
 *
 * @param failure_volume:num
 * @text Volume
 * @parent Failure
 * @type number
 * @max 100
 * @desc Volume of the sound effect played.
 * @default 90
 *
 * @param failure_pitch:num
 * @text Pitch
 * @parent Failure
 * @type number
 * @desc Pitch of the sound effect played.
 * @default 100
 *
 * @param failure_pan:num
 * @text Pan
 * @parent Failure
 * @desc Pan of the sound effect played.
 * @default 0
 *
 * @param CritSuccess
 * @text Critical Success Sound
 * 
 * @param crit_success_name:str
 * @text Filename
 * @parent CritSuccess
 * @type file
 * @dir audio/se/
 * @require 1
 * @desc Filename of the sound effect played.
 * @default Bell1
 *
 * @param crit_success_volume:num
 * @text Volume
 * @parent CritSuccess
 * @type number
 * @max 100
 * @desc Volume of the sound effect played.
 * @default 90
 *
 * @param crit_success_pitch:num
 * @text Pitch
 * @parent CritSuccess
 * @type number
 * @desc Pitch of the sound effect played.
 * @default 100
 *
 * @param crit_success_pan:num
 * @text Pan
 * @parent CritSuccess
 * @desc Pan of the sound effect played.
 * @default 0
 *
 * @param CritFailure
 * @text Critical Failure Sound
 * 
 * @param crit_failure_name:str
 * @text Filename
 * @parent CritFailure
 * @type file
 * @dir audio/se/
 * @require 1
 * @desc Filename of the sound effect played.
 * @default Battle2
 *
 * @param crit_failure_volume:num
 * @text Volume
 * @parent CritFailure
 * @type number
 * @max 100
 * @desc Volume of the sound effect played.
 * @default 90
 *
 * @param crit_failure_pitch:num
 * @text Pitch
 * @parent CritFailure
 * @type number
 * @desc Pitch of the sound effect played.
 * @default 100
 *
 * @param crit_failure_pan:num
 * @text Pan
 * @parent CritFailure
 * @desc Pan of the sound effect played.
 * @default 0
 *
 */
/* ----------------------------------------------------------------------------
 * Vocabulary Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Vocab:
 *
 * @param CommandWindow
 * @text Command Window
 *
 * @param CommandRoll:str
 * @text Roll Command
 * @parent CommandWindow
 * @desc Text used for the Roll Dice command.
 * Text codes allowed.
 * @default Roll Dice
 *
 * @param CommandEffects:str
 * @text Effects Command
 * @parent CommandWindow
 * @desc Text used for the View Effects command.
 * Text codes allowed.
 * @default View Effects
 *
 * @param CommandBonus:str
 * @text Bonus Command
 * @parent CommandWindow
 * @desc Text used for the Add Bonus command.
 * Text codes allowed.
 * @default Add Bonus
 *
 * @param TextColors
 * @text Text Colors
 *
 * @param diceUpColor:num
 * @text Dice Count Up
 * @parent TextColors
 * @type number
 * @min 0
 * @max 31
 * @desc Text color used for this effect type.
 * Insert number for text colors from the Window Skin.
 * @default 24
 *
 * @param diceDownColor:num
 * @text Dice Count Down
 * @parent TextColors
 * @type number
 * @min 0
 * @max 31
 * @desc Text color used for this effect type.
 * Insert number for text colors from the Window Skin.
 * @default 27
 *
 * @param rankUpColor:num
 * @text Dice Rank Up
 * @parent TextColors
 * @type number
 * @min 0
 * @max 31
 * @desc Text color used for this effect type.
 * Insert number for text colors from the Window Skin.
 * @default 21
 *
 * @param rankDownColor:num
 * @text Dice Rank Down
 * @parent TextColors
 * @type number
 * @min 0
 * @max 31
 * @desc Text color used for this effect type.
 * Insert number for text colors from the Window Skin.
 * @default 4
 *
 * @param modUpColor:num
 * @text Roll Modifier Up
 * @parent TextColors
 * @type number
 * @min 0
 * @max 31
 * @desc Text color used for this effect type.
 * Insert number for text colors from the Window Skin.
 * @default 6
 *
 * @param modDownColor:num
 * @text Roll Modifier Down
 * @parent TextColors
 * @type number
 * @min 0
 * @max 31
 * @desc Text color used for this effect type.
 * Insert number for text colors from the Window Skin.
 * @default 2
 *
 * @param DataWindows
 * @text Data Window Labels
 *
 * @param DataDiceCount:str
 * @text Dice Count
 * @parent DataWindows
 * @desc Text used to display this data label.
 * Text codes allowed.
 * @default \C[16]Dice Count:
 *
 * @param DataAdvantage:str
 * @text Advantage
 * @parent DataWindows
 * @desc Text used to display this data label.
 * Text codes allowed.
 * @default \C[24]Advantage:
 *
 * @param DataDisadvantage:str
 * @text Disadvantage
 * @parent DataWindows
 * @desc Text used to display this data label.
 * Text codes allowed.
 * @default \C[27]Disadvantage:
 *
 * @param DataDiceRank:str
 * @text Dice Rank
 * @parent DataWindows
 * @desc Text used to display this data label.
 * Text codes allowed.
 * @default \C[16]Dice Rank:
 *
 * @param DataModifiers:str
 * @text Modifiers
 * @parent DataWindows
 * @desc Text used to display this data label.
 * Text codes allowed.
 * @default \C[16]Modifiers:
 *
 * @param DataWindowRanks
 * @text Data Window Ranks
 *
 * @param DataRank1:str
 * @text Rank 1: D4
 * @parent DataWindowRanks
 * @desc Text used to display this dice rank.
 * Text codes allowed.
 * @default D4
 *
 * @param DataRank2:str
 * @text Rank 2: D6
 * @parent DataWindowRanks
 * @desc Text used to display this dice rank.
 * Text codes allowed.
 * @default D6
 *
 * @param DataRank3:str
 * @text Rank 3: D8
 * @parent DataWindowRanks
 * @desc Text used to display this dice rank.
 * Text codes allowed.
 * @default D8
 *
 * @param DataRank4:str
 * @text Rank 4: D10
 * @parent DataWindowRanks
 * @desc Text used to display this dice rank.
 * Text codes allowed.
 * @default D10
 *
 * @param DataRank5:str
 * @text Rank 5: D12
 * @parent DataWindowRanks
 * @desc Text used to display this dice rank.
 * Text codes allowed.
 * @default D12
 *
 * @param DataRank6:str
 * @text Rank 6: D20
 * @parent DataWindowRanks
 * @desc Text used to display this dice rank.
 * Text codes allowed.
 * @default D20
 *
 * @param DiceEffects
 * @text Dice Effects
 *
 * @param DiceDisplayFormat:str
 * @text Dice Display Format
 * @parent DiceEffects
 * @desc How the overall dice effect is displayed.
 * %1 - Effect
 * @default \}%1\{
 *
 * @param DicePrePostFormat:str
 * @text Pre/Post-Effect
 * @parent DiceEffects
 * @desc How pre/post effect is displayed.
 * %1 - Prev; %2 - Post
 * @default %1 %2
 *
 * @param DiceOrderFmt:str
 * @text Order Format
 * @parent DiceEffects
 * @desc Order format used for dice effects.
 * %1 - Count; %2 - Rank; %3 - Modifier
 * @default %1 %2 %3
 *
 * @param DicePlusSigns:eval
 * @text Positive Plus Sign?
 * @parent DiceEffects
 * @type boolean
 * @on Use +
 * @off Don't Use
 * @desc Show + sign for positive numbers?
 * @default true
 *
 * @param DiceCount:str
 * @text Dice Count Format
 * @parent DiceEffects
 * @desc Text format used for Dice Count effect.
 * %1 - Effect Number
 * @default Dice%1
 *
 * @param DiceAdvantage:str
 * @text Advantage Format
 * @parent DiceEffects
 * @desc Text format used for Advantage effect.
 * %1 - Effect Number
 * @default Adv%1
 *
 * @param DiceDisadvantage:str
 * @text Disadvantage Format
 * @parent DiceEffects
 * @desc Text format used for Disdvantage effect.
 * %1 - Effect Number
 * @default Dis%1
 *
 * @param DiceRank:str
 * @text Dice Rank Format
 * @parent DiceEffects
 * @desc Text format used for Dice Rank effect.
 * %1 - Effect Number
 * @default Rank%1
 *
 * @param DiceModifier:str
 * @text Roll Modifier Format
 * @parent DiceEffects
 * @desc Text format used for Roll Modifier effect.
 * %1 - Effect Number
 * @default Roll%1
 *
 * @param EffectCosts
 * @text Effect Costs
 *
 * @param CostDisplayFormat:str
 * @text Cost Display Format
 * @parent EffectCosts
 * @desc How the overall cost is displayed.
 * %1 - Cost Text
 * @default \}%1\{
 *
 * @param CostPrePostFormat:str
 * @text Pre/Post-Cost
 * @parent EffectCosts
 * @desc How pre/post cost text is displayed.
 * %1 - Prev; %2 - Post
 * @default %1 %2
 *
 * @param CostUsedUp:str
 * @text Used Up
 * @parent EffectCosts
 * @desc How a cost is displayed when its uses are spent.
 * Text codes allowed.
 * @default USED!
 *
 * @param CostUseTimesFmt:str
 * @text Use Times Format
 * @parent EffectCosts
 * @desc How use times are formated.
 * %1 - Current; %2 - Max Uses; %3 - Remaining
 * @default (×%1/%2)
 *
 * @param CostShowMaxUse1:eval
 * @text Show Max Use of 1?
 * @parent CostUseTimesFmt:str
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show the use cost when there's only 1 max use?
 * @default false
 *
 * @param CostUnlimitedUse:str
 * @text Unlimited Uses
 * @parent CostUseTimesFmt:str
 * @desc Text used to indicate unlimited usage.
 * Text codes allowed.
 * @default ∞
 *
 * @param CostVarFormat:str
 * @text Variable Cost Format
 * @parent EffectCosts
 * @desc How variable cost is displayed.
 * %1 - Cost; %2 - Quantity
 * @default (×%2-%1)
 *
 * @param CostItemFormat:str
 * @text Item Cost Format
 * @parent EffectCosts
 * @desc How item cost is displayed.
 * %1 - Cost; %2 - Quantity
 * @default (×%2-%1)
 *
 * @param CostWeaponFormat:str
 * @text Weapon Cost Format
 * @parent EffectCosts
 * @desc How weapon cost is displayed.
 * %1 - Cost; %2 - Quantity
 * @default (×%2-%1)
 *
 * @param CostArmorFormat:str
 * @text Armor Cost Format
 * @parent EffectCosts
 * @desc How armor cost is displayed.
 * %1 - Cost; %2 - Quantity
 * @default (×%2-%1)
 *
 * @param CostSkillUserName:str
 * @text Skill User's Name
 * @parent EffectCosts
 * @desc How the skill user's name is displayed.
 * %1 - Name
 * @default [%1]
 *
 * @param CostSkillUserFmt:str
 * @text User to Cost Format
 * @parent CostSkillUserName:str
 * @desc How the skill user's name is displayed to cost.
 * %1 - Name; %2 - Skill Cost
 * @default %1➤%2
 *
 * @param Subtitle
 * @text Subtitle Window
 *
 * @param SubtitleTotal:str
 * @text Roll for Total
 * @parent Subtitle
 * @desc Subtitle text for a roll total.
 * @default Roll for \C[23]total\C[0] number
 *
 * @param SubtitleHighest:str
 * @text Roll for Highest
 * @parent Subtitle
 * @desc Subtitle text to roll for highest.
 * @default Roll for \C[24]highest\C[0] number
 *
 * @param SubtitleAverage:str
 * @text Roll for Average
 * @parent Subtitle
 * @desc Subtitle text to roll for average.
 * @default Roll for \C[21]average\C[0] number
 *
 * @param SubtitleLowest:str
 * @text Roll for Lowest
 * @parent Subtitle
 * @desc Subtitle text to roll for lowest.
 * @default Roll for \C[21]lowest\C[0] number
 *
 * @param SubtitleAboveTarget:str
 * @text Roll: > Target
 * @parent Subtitle
 * @desc Subtitle text to roll for above target.
 * %1 - Target Roll
 * @default \C[5]Difficulty Class:\C[0] Above \C[24]%1\C[0]
 *
 * @param SubtitleAboveEqualTarget:str
 * @text Roll: >= Target
 * @parent Subtitle
 * @desc Subtitle text to roll for above/equal target.
 * %1 - Target Roll
 * @default \C[5]Difficulty Class:\C[0] At least \C[24]%1\C[0]
 *
 * @param SubtitleBelowEqualTarget:str
 * @text Roll: <= Target
 * @parent Subtitle
 * @desc Subtitle text to roll for below/equal target.
 * %1 - Target Roll
 * @default \C[5]Difficulty Class:\C[0] At most \C[24]%1\C[0]
 *
 * @param SubtitleBelowTarget:str
 * @text Roll: < Target
 * @parent Subtitle
 * @desc Subtitle text to roll for below target.
 * %1 - Target Roll
 * @default \C[5]Difficulty Class:\C[0] Below \C[24]%1\C[0]
 *
 * @param SubtitleCritSuccess:str
 * @text Critical Success
 * @parent Subtitle
 * @desc Subtitle text for a Critical Success on a Natural Roll.
 * @default \C[17]CRITICAL SUCCESS!
 *
 * @param SubtitleCritFailure:str
 * @text Critical Failure
 * @parent Subtitle
 * @desc Subtitle text for a Critical Failure on a Natural Roll.
 * @default \C[2]CRITICAL FAILURE!
 *
 */
/* ----------------------------------------------------------------------------
 * Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Window:
 *
 * @param Container
 * @text Sprite Container
 *
 * @param Container_RectJS:func
 * @text JS: X, Y, W, H
 * @parent Container
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const ww = Math.min(Math.round(Graphics.width * 0.90), 816);\nconst wx = Math.round((Graphics.width - ww) / 2);\nconst wy = this.calcWindowHeight(2, false) + this.calcWindowHeight(1, false);\nconst wh = Graphics.height - wy - this.calcWindowHeight(4, true) - this.calcWindowHeight(1, false);\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param TitleWindow
 * @text Title Window
 *
 * @param Title_BgType:num
 * @text Background Type
 * @parent TitleWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param Title_RectJS:func
 * @text JS: X, Y, W, H
 * @parent TitleWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const ww = Math.min(Math.round(Graphics.width * 0.80), 716);\nconst wh = this.calcWindowHeight(1, false);\nconst wx = Math.round((Graphics.width - ww) / 2);\nconst wy = this.calcWindowHeight(2, false) - wh;\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param SubtitleWindow
 * @text Subtitle Window
 *
 * @param Subtitle_BgType:num
 * @text Background Type
 * @parent SubtitleWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param Subtitle_RectJS:func
 * @text JS: X, Y, W, H
 * @parent SubtitleWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const ww = Math.min(Math.round(Graphics.width * 0.80), 716);\nconst wh = this.calcWindowHeight(1, false);\nconst wx = Math.round((Graphics.width - ww) / 2);\nconst wy = Graphics.height - this.calcWindowHeight(4, true) - wh;\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param DataWindows
 * @text Data Windows
 *
 * @param DataCount_BgType:num
 * @text Dice Count: BG Type
 * @parent DataWindows
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param DataCount_RectJS:func
 * @text JS: X, Y, W, H
 * @parent DataCount_BgType:num
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const base = Math.min(Math.round(Graphics.width * 0.90), 816);\nconst ww = Math.floor(base / 3);\nconst wh = this.calcWindowHeight(1, false);\nconst wx = Math.round((Graphics.width - base) / 2);\nconst wy = this.calcWindowHeight(2, false);\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param DataRank_BgType:num
 * @text Dice Rank: BG Type
 * @parent DataWindows
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param DataRank_RectJS:func
 * @text JS: X, Y, W, H
 * @parent DataRank_BgType:num
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const base = Math.min(Math.round(Graphics.width * 0.90), 816);\nconst ww = Math.ceil(base / 3);\nconst wh = this.calcWindowHeight(1, false);\nconst wx = Math.round((Graphics.width - ww) / 2);\nconst wy = this.calcWindowHeight(2, false);\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param DataMod_BgType:num
 * @text Modifier: BG Type
 * @parent DataWindows
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param DataMod_RectJS:func
 * @text JS: X, Y, W, H
 * @parent DataMod_BgType:num
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const base = Math.min(Math.round(Graphics.width * 0.90), 816);\nconst ww = Math.floor(base / 3);\nconst wh = this.calcWindowHeight(1, false);\nconst wx = Math.round((Graphics.width + ww) / 2);\nconst wy = this.calcWindowHeight(2, false);\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param CommandWindow
 * @text Command Window
 *
 * @param Command_BgType:num
 * @text Background Type
 * @parent CommandWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param CommandShowEffects:eval
 * @text Show "View Effects"?
 * @parent Animation
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show "View Effects" command?
 * @default true
 *
 * @param CommandShowBonus:eval
 * @text Show "Add Bonus"?
 * @parent Animation
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show "Add Bonus" command?
 * @default true
 *
 * @param Command_TextAlign:str
 * @text Text Align
 * @parent CommandWindow
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for this window?
 * @default center
 *
 * @param Command_RectJS:func
 * @text JS: X, Y, W, H
 * @parent CommandWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const ww = Math.min(Math.round(Graphics.width * 0.50), 360);\nconst wh = this.calcWindowHeight(this.totalDiceRollChoices(), true);\nconst wx = Math.round((Graphics.width - ww) / 2);\nconst wy = Graphics.height - this.calcWindowHeight(4, true) + Math.round((this.calcWindowHeight(4, true) - this.calcWindowHeight(3, true)) / 2);\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param ListWindows
 * @text List Windows
 *
 * @param EffectList_BgType:num
 * @text Effect List: BG Type
 * @parent ListWindows
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param BonusList_BgType:num
 * @text Bonus List: BG Type
 * @parent ListWindows
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param ListColumns:num
 * @text Window Columns
 * @parent ListWindows
 * @type number
 * @min 1
 * @desc How many columns are used for these windows?
 * @default 2
 *
 * @param ListColSpacing:num
 * @text Column Spacing
 * @parent ListWindows
 * @type number
 * @min 0
 * @desc How much spacing is there between columns?
 * @default 16
 *
 * @param List_RectJS:func
 * @text JS: X, Y, W, H
 * @parent ListWindows
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const ww = Math.min(Graphics.width, 1016);\nconst wh = this.calcWindowHeight(4, true);\nconst wx = Math.round((Graphics.width - ww) / 2);\nconst wy = Graphics.height - wh;\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 */
/* ----------------------------------------------------------------------------
 * Dice Seed Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~DiceSeed:
 *
 * @param Appearance
 * @text Appearance Overrides
 * 
 * @param d4_filenames:arraystr
 * @text D4 Image Filename(s)
 * @parent Appearance
 * @type file[]
 * @dir img/pictures/
 * @require 1
 * @desc Use custom images for this dice? Priority over colors.
 * Overrides default parameters. Location: img/pictures/
 * @default []
 * 
 * @param d6_filenames:arraystr
 * @text D6 Image Filename(s)
 * @parent Appearance
 * @type file[]
 * @dir img/pictures/
 * @require 1
 * @desc Use custom images for this dice? Priority over colors.
 * Overrides default parameters. Location: img/pictures/
 * @default []
 * 
 * @param d8_filenames:arraystr
 * @text D8 Image Filename(s)
 * @parent Appearance
 * @type file[]
 * @dir img/pictures/
 * @require 1
 * @desc Use custom images for this dice? Priority over colors.
 * Overrides default parameters. Location: img/pictures/
 * @default []
 * 
 * @param d10_filenames:arraystr
 * @text D10 Image Filename(s)
 * @parent Appearance
 * @type file[]
 * @dir img/pictures/
 * @require 1
 * @desc Use custom images for this dice? Priority over colors.
 * Overrides default parameters. Location: img/pictures/
 * @default []
 * 
 * @param d12_filenames:arraystr
 * @text D12 Image Filename(s)
 * @parent Appearance
 * @type file[]
 * @dir img/pictures/
 * @require 1
 * @desc Use custom images for this dice? Priority over colors.
 * Overrides default parameters. Location: img/pictures/
 * @default []
 * 
 * @param d20_filenames:arraystr
 * @text D20 Image Filename(s)
 * @parent Appearance
 * @type file[]
 * @dir img/pictures/
 * @require 1
 * @desc Use custom images for this dice? Priority over colors.
 * Overrides default parameters. Location: img/pictures/
 * @default []
 *
 * @param colors:arraystr
 * @text Dice Colors(s)
 * @parent Appearance
 * @type string[]
 * @desc Use #rrggbb for custom colors or regular numbers for text
 * colors from the Window Skin. Overrides default parameters.
 * @default []
 *
 * @param Seed:str
 * @text Seed
 * @desc What is the Random Number Seed used for this Dice Roll?
 * Use numbers or text. Use "none" to not use a seed.
 * @default none
 *
 * @param ApplyDaily:eval
 * @text Daily Marker
 * @parent Seed:str
 * @type boolean
 * @on Apply To Seed
 * @off Don't Apply
 * @desc Apply daily marker to Random Number results?
 * @default false
 *
 * @param ApplyUnique:eval
 * @text Save-Unique Marker
 * @parent Seed:str
 * @type boolean
 * @on Apply To Seed
 * @off Don't Apply
 * @desc Apply save-unique marker to Random Number results?
 * @default false
 *
 */
/* ----------------------------------------------------------------------------
 * Auto Dice Effects Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~AutoMods:
 *
 * @param GeneralEffects:arraystruct
 * @text General Auto-Effects
 * @type struct<GeneralAutoEffect>[]
 * @desc These auto-effects will be automatically activated as long
 * its conditions are met at the start of the dice-roll.
 * @default []
 *
 * @param VariableEffects:arraystruct
 * @text Variable Requirements
 * @type struct<VariableAutoEffect>[]
 * @desc These auto-effects require a variable(s) to be at least a
 * certain value to automatically activate.
 * @default []
 *
 * @param ItemEffects:arraystruct
 * @text Item Requirements
 * @type struct<ItemAutoEffect>[]
 * @desc These auto-effects require an item(s) to have a certain
 * quantity to automatically activate.
 * @default []
 *
 * @param WeaponEffects:arraystruct
 * @text Weapon Requirements
 * @type struct<WeaponAutoEffect>[]
 * @desc These auto-effects require a weapon(s) to be in party
 * possession or is equipped to automatically activate.
 * @default []
 *
 * @param ArmorEffects:arraystruct
 * @text Armor Requirements
 * @type struct<ArmorAutoEffect>[]
 * @desc These auto-effects require an armor(s) to be in party
 * possession or is equipped to automatically activate.
 * @default []
 *
 * @param SkillEffects:arraystruct
 * @text Skill Requirements
 * @type struct<SkillAutoEffect>[]
 * @desc These auto-effects require a skill(s) to be available
 * within the party to automatically activate.
 * @default []
 *
 */
/* ----------------------------------------------------------------------------
 * Bonus Dice Effects Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~BonusMods:
 *
 * @param GeneralEffects:arraystruct
 * @text General Bonus Effects
 * @type struct<GeneralBonusEffect>[]
 * @desc Add general bonus dice effects here that the player can
 * select to use the effect.
 * @default []
 *
 * @param VariableEffects:arraystruct
 * @text Variable Cost Effects
 * @type struct<VariableBonusEffect>[]
 * @desc Variable Bonus Effects require deducting from variable(s)
 * as a cost to use the effect.
 * @default []
 *
 * @param ItemEffects:arraystruct
 * @text Item Cost Effects
 * @type struct<ItemBonusEffect>[]
 * @desc Item Bonus Effects require consuming the target item(s)
 * as a cost to use the effect.
 * @default []
 *
 * @param WeaponEffects:arraystruct
 * @text Weapon Cost Effects
 * @type struct<WeaponBonusEffect>[]
 * @desc Weapon Bonus Effects require consuming the target
 * weapon(s) as a cost to use the effect.
 * @default []
 *
 * @param ArmorEffects:arraystruct
 * @text Armor Cost Effects
 * @type struct<ArmorBonusEffect>[]
 * @desc Armor Bonus Effects require consuming target the armor(s)
 * as a cost to use the effect.
 * @default []
 *
 * @param SkillEffects:arraystruct
 * @text Skill Cost Effects
 * @type struct<SkillBonusEffect>[]
 * @desc Skill Bonus Effects require paying skill costs to
 * activate and use the effect.
 * @default []
 *
 */
/* ----------------------------------------------------------------------------
 * General Auto Effects Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~GeneralAutoEffect:
 *
 * @param Name:str
 * @text Auto Effect Name
 * @desc What is the name of this effect?
 * Text codes allowed.
 * @default Untitled
 *
 * @param Icon:num
 * @text Auto Effect Icon
 * @parent Name:str
 * @desc The icon used for this effect.
 * @default 87
 * 
 * @param DiceEffects
 * @text Dice Effects
 *
 * @param Advantage:eval
 * @text Count/Advantage
 * @parent DiceEffects
 * @desc Change dice count (roll value) or advantage/disadvantage
 * (target value). You may use code.
 * @default +0
 *
 * @param DiceRank:eval
 * @text Rank/Type
 * @parent DiceEffects
 * @desc Raises/lowers dice rank: D4, D6, D8, D10, D12, D20.
 * You may use code. Higher rank = more sides.
 * @default +0
 *
 * @param DiceModifier:eval
 * @text Modifier (Static)
 * @parent DiceEffects
 * @desc Alters the finalized rolled dice value.
 * You may use code.
 * @default +0
 *
 * @param DiceModifierRand:eval
 * @text Modifier (Random)
 * @parent DiceEffects
 * @desc Adds a random element to the dice value.
 * You may use code.
 * @default +0
 * 
 * @param Text
 * @text Additional Text
 *
 * @param PreEffectText:str
 * @text Pre-Effect Text
 * @parent Text
 * @desc What text is added before the dice effects text?
 * Text codes allowed.
 * @default 
 *
 * @param PostEffectText:str
 * @text Post-Effect Text
 * @parent Text
 * @desc What text is added after the dice effects text?
 * Text codes allowed.
 * @default 
 * 
 * @param Conditions
 * @text Effect Conditions
 *
 * @param SwitchID:num
 * @text Switch ID
 * @parent Conditions
 * @type switch
 * @desc This Switch is required to be ON to meet conditions.
 * Use 0 to not use. Does not reveal mid-Dice Roll.
 * @default 0
 *
 * @param ConditionJS:func
 * @text JS: Condition
 * @parent Conditions
 * @type note
 * @desc JavaScript code used to determine the conditions for
 * this dice effect to be automatically activated.
 * @default "// Does not reveal mid-Dice Roll.\nreturn true;"
 *
 */
/* ----------------------------------------------------------------------------
 * General Bonus Effects Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~GeneralBonusEffect:
 *
 * @param Name:str
 * @text Bonus Effect Name
 * @desc What is the name of this effect?
 * Text codes allowed.
 * @default Untitled
 *
 * @param Icon:num
 * @text Bonus Effect Icon
 * @parent Name:str
 * @desc The icon used for this effect.
 * @default 87
 *
 * @param AnimationID:num
 * @text Animation ID
 * @parent Name:str
 * @type animation
 * @desc Play this animation when the effect activates.
 * Animation will play on the player character.
 * @default 0
 * 
 * @param Costs
 * @text Effect Costs
 *
 * @param MaxUses:eval
 * @text Maximum Uses
 * @parent Costs
 * @desc How many times can this effect be used?
 * You may use code. Over 1000000 for unlimited.
 * @default 1
 *
 * @param ShowUses:eval
 * @text Show Uses Left?
 * @parent MaxUses:eval
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show how many uses are left?
 * @default true
 * 
 * @param DiceEffects
 * @text Dice Effects
 *
 * @param Advantage:eval
 * @text Count/Advantage
 * @parent DiceEffects
 * @desc Change dice count (roll value) or advantage/disadvantage
 * (target value). You may use code.
 * @default +0
 *
 * @param DiceRank:eval
 * @text Rank/Type
 * @parent DiceEffects
 * @desc Raises/lowers dice rank: D4, D6, D8, D10, D12, D20.
 * You may use code. Higher rank = more sides.
 * @default +0
 *
 * @param DiceModifier:eval
 * @text Modifier (Static)
 * @parent DiceEffects
 * @desc Alters the finalized rolled dice value.
 * You may use code.
 * @default +0
 *
 * @param DiceModifierRand:eval
 * @text Modifier (Random)
 * @parent DiceEffects
 * @desc Adds a random element to the dice value.
 * You may use code.
 * @default +0
 * 
 * @param Text
 * @text Additional Text
 *
 * @param PreCostText:str
 * @text Pre-Cost Text
 * @parent Text
 * @desc What text is added before the dice cost text?
 * Text codes allowed.
 * @default 
 *
 * @param PostCostText:str
 * @text Post-Cost Text
 * @parent Text
 * @desc What text is added after the dice cost text?
 * Text codes allowed.
 * @default 
 *
 * @param PreEffectText:str
 * @text Pre-Effect Text
 * @parent Text
 * @desc What text is added before the dice effects text?
 * Text codes allowed.
 * @default 
 *
 * @param PostEffectText:str
 * @text Post-Effect Text
 * @parent Text
 * @desc What text is added after the dice effects text?
 * Text codes allowed.
 * @default 
 * 
 * @param Conditions
 * @text Effect Conditions
 *
 * @param ShowSwitchID:num
 * @text Show Switch ID
 * @parent Conditions
 * @type switch
 * @desc This Switch is required to be ON to show effect.
 * Use 0 to not use. Does not reveal mid-Dice Roll.
 * @default 0
 *
 * @param EnableSwitchID:num
 * @text Enable Switch ID
 * @parent Conditions
 * @type switch
 * @desc This Switch is required to be ON to enable effect.
 * Use 0 to not use.
 * @default 0
 *
 * @param ShowJS:func
 * @text JS: Show
 * @parent Conditions
 * @type note
 * @desc JavaScript code used to determine show conditions for
 * this dice effect to become available for use.
 * @default "// Does not reveal mid-Dice Roll.\nreturn true;"
 *
 * @param EnableJS:func
 * @text JS: Enable
 * @parent Conditions
 * @type note
 * @desc JavaScript code used to determine enable conditions for
 * this dice effect to become usable.
 * @default "return true;"
 *
 * @param ActivateJS:func
 * @text JS: On Select
 * @parent Conditions
 * @type note
 * @desc JavaScript code used to determine what happens when this
 * dice effect is selected and activated.
 * @default "// Do Nothing"
 *
 */
/* ----------------------------------------------------------------------------
 * Variable Auto Effects Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~VariableAutoEffect:
 *
 * @param Name:str
 * @text Auto Effect Name
 * @desc What is the name of this effect?
 * Text codes allowed.
 * @default Untitled
 *
 * @param Icon:num
 * @text Auto Effect Icon
 * @parent Name:str
 * @desc The icon used for this effect.
 * @default 87
 * 
 * @param RefData
 * @text Reference Data
 *
 * @param VariableReqID:num
 * @text Required Variable ID
 * @parent RefData
 * @type variable
 * @desc This variable is to be checked from.
 * Changes don't affect effect mid-roll.
 * @default 2
 *
 * @param VariableReqValue:eval
 * @text Required Value
 * @parent VariableReqID:num
 * @desc Variable requires at least this much in value.
 * You may use code. Changes don't affect effect mid-roll.
 * @default 1
 * 
 * @param DiceEffects
 * @text Dice Effects
 *
 * @param Advantage:eval
 * @text Count/Advantage
 * @parent DiceEffects
 * @desc Change dice count (roll value) or advantage/disadvantage
 * (target value). You may use code.
 * @default +0
 *
 * @param DiceRank:eval
 * @text Rank/Type
 * @parent DiceEffects
 * @desc Raises/lowers dice rank: D4, D6, D8, D10, D12, D20.
 * You may use code. Higher rank = more sides.
 * @default +0
 *
 * @param DiceModifier:eval
 * @text Modifier (Static)
 * @parent DiceEffects
 * @desc Alters the finalized rolled dice value.
 * You may use code.
 * @default +0
 *
 * @param DiceModifierRand:eval
 * @text Modifier (Random)
 * @parent DiceEffects
 * @desc Adds a random element to the dice value.
 * You may use code.
 * @default +0
 * 
 * @param Text
 * @text Additional Text
 *
 * @param PreEffectText:str
 * @text Pre-Effect Text
 * @parent Text
 * @desc What text is added before the dice effects text?
 * Text codes allowed.
 * @default 
 *
 * @param PostEffectText:str
 * @text Post-Effect Text
 * @parent Text
 * @desc What text is added after the dice effects text?
 * Text codes allowed.
 * @default 
 * 
 * @param Conditions
 * @text Effect Conditions
 *
 * @param SwitchID:num
 * @text Switch ID
 * @parent Conditions
 * @type switch
 * @desc This Switch is required to be ON to meet conditions.
 * Use 0 to not use. Does not reveal mid-Dice Roll.
 * @default 0
 *
 * @param ConditionJS:func
 * @text JS: Condition
 * @parent Conditions
 * @type note
 * @desc JavaScript code used to determine the conditions for
 * this dice effect to be automatically activated.
 * @default "// Does not reveal mid-Dice Roll.\nreturn true;"
 *
 */
/* ----------------------------------------------------------------------------
 * Variable Bonus Effects Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~VariableBonusEffect:
 *
 * @param Name:str
 * @text Bonus Effect Name
 * @desc What is the name of this effect?
 * Text codes allowed.
 * @default Untitled
 *
 * @param Icon:num
 * @text Bonus Effect Icon
 * @parent Name:str
 * @desc The icon used for this effect.
 * @default 87
 *
 * @param AnimationID:num
 * @text Animation ID
 * @parent Name:str
 * @type animation
 * @desc Play this animation when the effect activates.
 * Animation will play on the player character.
 * @default 0
 * 
 * @param Costs
 * @text Effect Costs
 *
 * @param VariableCostID:num
 * @text Variable Cost ID
 * @parent Costs
 * @type variable
 * @desc This variable is to be deducted from.
 * Changes do not reveal effect mid-Dice Roll.
 * @default 2
 *
 * @param VariableCostValue:eval
 * @text Cost Value
 * @parent VariableCostID:num
 * @desc Deduct this much from the target variable.
 * You may use code.
 * @default 1
 *
 * @param ShowVariableCost:eval
 * @text Show Variable Cost?
 * @parent VariableCostID:num
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show variable cost?
 * @default true
 *
 * @param MaxUses:eval
 * @text Maximum Uses
 * @parent Costs
 * @desc How many times can this effect be used?
 * You may use code. Over 1000000 for unlimited.
 * @default 1
 *
 * @param ShowUses:eval
 * @text Show Uses Left?
 * @parent MaxUses:eval
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show how many uses are left?
 * @default true
 * 
 * @param DiceEffects
 * @text Dice Effects
 *
 * @param Advantage:eval
 * @text Count/Advantage
 * @parent DiceEffects
 * @desc Change dice count (roll value) or advantage/disadvantage
 * (target value). You may use code.
 * @default +0
 *
 * @param DiceRank:eval
 * @text Rank/Type
 * @parent DiceEffects
 * @desc Raises/lowers dice rank: D4, D6, D8, D10, D12, D20.
 * You may use code. Higher rank = more sides.
 * @default +0
 *
 * @param DiceModifier:eval
 * @text Modifier (Static)
 * @parent DiceEffects
 * @desc Alters the finalized rolled dice value.
 * You may use code.
 * @default +0
 *
 * @param DiceModifierRand:eval
 * @text Modifier (Random)
 * @parent DiceEffects
 * @desc Adds a random element to the dice value.
 * You may use code.
 * @default +0
 * 
 * @param Text
 * @text Additional Text
 *
 * @param PreCostText:str
 * @text Pre-Cost Text
 * @parent Text
 * @desc What text is added before the dice cost text?
 * Text codes allowed.
 * @default 
 *
 * @param PostCostText:str
 * @text Post-Cost Text
 * @parent Text
 * @desc What text is added after the dice cost text?
 * Text codes allowed.
 * @default 
 *
 * @param PreEffectText:str
 * @text Pre-Effect Text
 * @parent Text
 * @desc What text is added before the dice effects text?
 * Text codes allowed.
 * @default 
 *
 * @param PostEffectText:str
 * @text Post-Effect Text
 * @parent Text
 * @desc What text is added after the dice effects text?
 * Text codes allowed.
 * @default 
 * 
 * @param Conditions
 * @text Effect Conditions
 *
 * @param ShowSwitchID:num
 * @text Show Switch ID
 * @parent Conditions
 * @type switch
 * @desc This Switch is required to be ON to show effect.
 * Use 0 to not use. Does not reveal mid-Dice Roll.
 * @default 0
 *
 * @param EnableSwitchID:num
 * @text Enable Switch ID
 * @parent Conditions
 * @type switch
 * @desc This Switch is required to be ON to enable effect.
 * Use 0 to not use.
 * @default 0
 *
 * @param ShowJS:func
 * @text JS: Show
 * @parent Conditions
 * @type note
 * @desc JavaScript code used to determine show conditions for
 * this dice effect to become available for use.
 * @default "// Does not reveal mid-Dice Roll.\nreturn true;"
 *
 * @param EnableJS:func
 * @text JS: Enable
 * @parent Conditions
 * @type note
 * @desc JavaScript code used to determine enable conditions for
 * this dice effect to become usable.
 * @default "return true;"
 *
 * @param ActivateJS:func
 * @text JS: On Select
 * @parent Conditions
 * @type note
 * @desc JavaScript code used to determine what happens when this
 * dice effect is selected and activated.
 * @default "// Do Nothing"
 *
 */
/* ----------------------------------------------------------------------------
 * Item Auto Effects Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ItemAutoEffect:
 *
 * @param Name:str
 * @text Auto Effect Name
 * @desc What is the name of this effect?
 * Text codes allowed. Use "AutoName" to auto-name.
 * @default AutoName
 *
 * @param Icon:num
 * @text Auto Effect Icon
 * @parent Name:str
 * @desc The icon used for this effect.
 * Use 1000000 to auto-select icon.
 * @default 1000000
 * 
 * @param RefData
 * @text Reference Data
 *
 * @param ItemReqID:num
 * @text Required Item ID
 * @parent RefData
 * @type item
 * @desc This is the item whose quantity is checked.
 * Changes don't affect effect mid-roll.
 * @default 7
 *
 * @param ItemReqValue:eval
 * @text Required Value
 * @parent ItemReqID:num
 * @desc Quantity requires at least this much in value.
 * You may use code. Changes don't affect effect mid-roll.
 * @default 1
 * 
 * @param DiceEffects
 * @text Dice Effects
 *
 * @param Advantage:eval
 * @text Count/Advantage
 * @parent DiceEffects
 * @desc Change dice count (roll value) or advantage/disadvantage
 * (target value). You may use code.
 * @default +0
 *
 * @param DiceRank:eval
 * @text Rank/Type
 * @parent DiceEffects
 * @desc Raises/lowers dice rank: D4, D6, D8, D10, D12, D20.
 * You may use code. Higher rank = more sides.
 * @default +0
 *
 * @param DiceModifier:eval
 * @text Modifier (Static)
 * @parent DiceEffects
 * @desc Alters the finalized rolled dice value.
 * You may use code.
 * @default +0
 *
 * @param DiceModifierRand:eval
 * @text Modifier (Random)
 * @parent DiceEffects
 * @desc Adds a random element to the dice value.
 * You may use code.
 * @default +0
 * 
 * @param Text
 * @text Additional Text
 *
 * @param PreEffectText:str
 * @text Pre-Effect Text
 * @parent Text
 * @desc What text is added before the dice effects text?
 * Text codes allowed.
 * @default 
 *
 * @param PostEffectText:str
 * @text Post-Effect Text
 * @parent Text
 * @desc What text is added after the dice effects text?
 * Text codes allowed.
 * @default 
 * 
 * @param Conditions
 * @text Effect Conditions
 *
 * @param SwitchID:num
 * @text Switch ID
 * @parent Conditions
 * @type switch
 * @desc This Switch is required to be ON to meet conditions.
 * Use 0 to not use. Does not reveal mid-Dice Roll.
 * @default 0
 *
 * @param ConditionJS:func
 * @text JS: Condition
 * @parent Conditions
 * @type note
 * @desc JavaScript code used to determine the conditions for
 * this dice effect to be automatically activated.
 * @default "// Does not reveal mid-Dice Roll.\nreturn true;"
 *
 */
/* ----------------------------------------------------------------------------
 * Item Bonus Effects Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ItemBonusEffect:
 *
 * @param Name:str
 * @text Bonus Effect Name
 * @desc What is the name of this effect?
 * Text codes allowed. Use "AutoName" to auto-name.
 * @default AutoName
 *
 * @param Icon:num
 * @text Bonus Effect Icon
 * @parent Name:str
 * @desc The icon used for this effect.
 * Use 1000000 to auto-select icon.
 * @default 1000000
 *
 * @param AnimationID:num
 * @text Animation ID
 * @parent Name:str
 * @type animation
 * @desc Play this animation when the effect activates.
 * Animation will play on the player character.
 * @default 0
 * 
 * @param Costs
 * @text Effect Costs
 *
 * @param ItemCostID:num
 * @text Item Cost ID
 * @parent Costs
 * @type item
 * @desc This item is to be deducted from.
 * Changes do not reveal effect mid-Dice Roll.
 * @default 7
 *
 * @param ItemCostValue:eval
 * @text Cost Value
 * @parent ItemCostID:num
 * @desc Deduct this much from the target item.
 * You may use code.
 * @default 1
 *
 * @param ShowItemCost:eval
 * @text Show Item Cost?
 * @parent ItemCostID:num
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show item cost?
 * @default true
 *
 * @param MaxUses:eval
 * @text Maximum Uses
 * @parent Costs
 * @desc How many times can this effect be used?
 * You may use code. Over 1000000 for unlimited.
 * @default 1
 *
 * @param ShowUses:eval
 * @text Show Uses Left?
 * @parent MaxUses:eval
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show how many uses are left?
 * @default true
 * 
 * @param DiceEffects
 * @text Dice Effects
 *
 * @param Advantage:eval
 * @text Count/Advantage
 * @parent DiceEffects
 * @desc Change dice count (roll value) or advantage/disadvantage
 * (target value). You may use code.
 * @default +0
 *
 * @param DiceRank:eval
 * @text Rank/Type
 * @parent DiceEffects
 * @desc Raises/lowers dice rank: D4, D6, D8, D10, D12, D20.
 * You may use code. Higher rank = more sides.
 * @default +0
 *
 * @param DiceModifier:eval
 * @text Modifier (Static)
 * @parent DiceEffects
 * @desc Alters the finalized rolled dice value.
 * You may use code.
 * @default +0
 *
 * @param DiceModifierRand:eval
 * @text Modifier (Random)
 * @parent DiceEffects
 * @desc Adds a random element to the dice value.
 * You may use code.
 * @default +0
 * 
 * @param Text
 * @text Additional Text
 *
 * @param PreCostText:str
 * @text Pre-Cost Text
 * @parent Text
 * @desc What text is added before the dice cost text?
 * Text codes allowed.
 * @default 
 *
 * @param PostCostText:str
 * @text Post-Cost Text
 * @parent Text
 * @desc What text is added after the dice cost text?
 * Text codes allowed.
 * @default 
 *
 * @param PreEffectText:str
 * @text Pre-Effect Text
 * @parent Text
 * @desc What text is added before the dice effects text?
 * Text codes allowed.
 * @default 
 *
 * @param PostEffectText:str
 * @text Post-Effect Text
 * @parent Text
 * @desc What text is added after the dice effects text?
 * Text codes allowed.
 * @default 
 * 
 * @param Conditions
 * @text Effect Conditions
 *
 * @param ShowSwitchID:num
 * @text Show Switch ID
 * @parent Conditions
 * @type switch
 * @desc This Switch is required to be ON to show effect.
 * Use 0 to not use. Does not reveal mid-Dice Roll.
 * @default 0
 *
 * @param EnableSwitchID:num
 * @text Enable Switch ID
 * @parent Conditions
 * @type switch
 * @desc This Switch is required to be ON to enable effect.
 * Use 0 to not use.
 * @default 0
 *
 * @param ShowJS:func
 * @text JS: Show
 * @parent Conditions
 * @type note
 * @desc JavaScript code used to determine show conditions for
 * this dice effect to become available for use.
 * @default "// Does not reveal mid-Dice Roll.\nreturn true;"
 *
 * @param EnableJS:func
 * @text JS: Enable
 * @parent Conditions
 * @type note
 * @desc JavaScript code used to determine enable conditions for
 * this dice effect to become usable.
 * @default "return true;"
 *
 * @param ActivateJS:func
 * @text JS: On Select
 * @parent Conditions
 * @type note
 * @desc JavaScript code used to determine what happens when this
 * dice effect is selected and activated.
 * @default "// Do Nothing"
 *
 */
/* ----------------------------------------------------------------------------
 * Weapon Auto Effects Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~WeaponAutoEffect:
 *
 * @param Name:str
 * @text Auto Effect Name
 * @desc What is the name of this effect?
 * Text codes allowed. Use "AutoName" to auto-name.
 * @default AutoName
 *
 * @param Icon:num
 * @text Auto Effect Icon
 * @parent Name:str
 * @desc The icon used for this effect.
 * Use 1000000 to auto-select icon.
 * @default 1000000
 * 
 * @param RefData
 * @text Reference Data
 *
 * @param WeaponReqID:num
 * @text Required Weapon ID
 * @parent RefData
 * @type weapon
 * @desc This is the weapon whose presence is checked.
 * Changes don't affect effect mid-roll.
 * @default 1
 *
 * @param WeaponIncludeEquip:eval
 * @text Include Equipped?
 * @type boolean
 * @parent WeaponReqID:num
 * @on Include Equipped
 * @off Unequipped Only
 * @desc Allow equipped weapons to be included in the count.
 * @default true
 * 
 * @param DiceEffects
 * @text Dice Effects
 *
 * @param Advantage:eval
 * @text Count/Advantage
 * @parent DiceEffects
 * @desc Change dice count (roll value) or advantage/disadvantage
 * (target value). You may use code.
 * @default +0
 *
 * @param DiceRank:eval
 * @text Rank/Type
 * @parent DiceEffects
 * @desc Raises/lowers dice rank: D4, D6, D8, D10, D12, D20.
 * You may use code. Higher rank = more sides.
 * @default +0
 *
 * @param DiceModifier:eval
 * @text Modifier (Static)
 * @parent DiceEffects
 * @desc Alters the finalized rolled dice value.
 * You may use code.
 * @default +0
 *
 * @param DiceModifierRand:eval
 * @text Modifier (Random)
 * @parent DiceEffects
 * @desc Adds a random element to the dice value.
 * You may use code.
 * @default +0
 * 
 * @param Text
 * @text Additional Text
 *
 * @param PreEffectText:str
 * @text Pre-Effect Text
 * @parent Text
 * @desc What text is added before the dice effects text?
 * Text codes allowed.
 * @default 
 *
 * @param PostEffectText:str
 * @text Post-Effect Text
 * @parent Text
 * @desc What text is added after the dice effects text?
 * Text codes allowed.
 * @default 
 * 
 * @param Conditions
 * @text Effect Conditions
 *
 * @param SwitchID:num
 * @text Switch ID
 * @parent Conditions
 * @type switch
 * @desc This Switch is required to be ON to meet conditions.
 * Use 0 to not use. Does not reveal mid-Dice Roll.
 * @default 0
 *
 * @param ConditionJS:func
 * @text JS: Condition
 * @parent Conditions
 * @type note
 * @desc JavaScript code used to determine the conditions for
 * this dice effect to be automatically activated.
 * @default "// Does not reveal mid-Dice Roll.\nreturn true;"
 *
 */
/* ----------------------------------------------------------------------------
 * Weapon Bonus Effects Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~WeaponBonusEffect:
 *
 * @param Name:str
 * @text Bonus Effect Name
 * @desc What is the name of this effect?
 * Text codes allowed. Use "AutoName" to auto-name.
 * @default AutoName
 *
 * @param Icon:num
 * @text Bonus Effect Icon
 * @parent Name:str
 * @desc The icon used for this effect.
 * Use 1000000 to auto-select icon.
 * @default 1000000
 *
 * @param AnimationID:num
 * @text Animation ID
 * @parent Name:str
 * @type animation
 * @desc Play this animation when the effect activates.
 * Animation will play on the player character.
 * @default 0
 * 
 * @param Costs
 * @text Effect Costs
 *
 * @param WeaponCostID:num
 * @text Weapon Cost ID
 * @parent Costs
 * @type weapon
 * @desc This weapon is to be deducted from.
 * Changes do not reveal effect mid-Dice Roll.
 * @default 1
 *
 * @param WeaponCostValue:eval
 * @text Cost Value
 * @parent WeaponCostID:num
 * @desc Deduct this much from the target weapon.
 * You may use code.
 * @default 1
 *
 * @param ShowWeaponCost:eval
 * @text Show Weapon Cost?
 * @parent WeaponCostID:num
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show weapon cost?
 * @default true
 *
 * @param MaxUses:eval
 * @text Maximum Uses
 * @parent Costs
 * @desc How many times can this effect be used?
 * You may use code. Over 1000000 for unlimited.
 * @default 1
 *
 * @param ShowUses:eval
 * @text Show Uses Left?
 * @parent MaxUses:eval
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show how many uses are left?
 * @default true
 * 
 * @param DiceEffects
 * @text Dice Effects
 *
 * @param Advantage:eval
 * @text Count/Advantage
 * @parent DiceEffects
 * @desc Change dice count (roll value) or advantage/disadvantage
 * (target value). You may use code.
 * @default +0
 *
 * @param DiceRank:eval
 * @text Rank/Type
 * @parent DiceEffects
 * @desc Raises/lowers dice rank: D4, D6, D8, D10, D12, D20.
 * You may use code. Higher rank = more sides.
 * @default +0
 *
 * @param DiceModifier:eval
 * @text Modifier (Static)
 * @parent DiceEffects
 * @desc Alters the finalized rolled dice value.
 * You may use code.
 * @default +0
 *
 * @param DiceModifierRand:eval
 * @text Modifier (Random)
 * @parent DiceEffects
 * @desc Adds a random element to the dice value.
 * You may use code.
 * @default +0
 * 
 * @param Text
 * @text Additional Text
 *
 * @param PreCostText:str
 * @text Pre-Cost Text
 * @parent Text
 * @desc What text is added before the dice cost text?
 * Text codes allowed.
 * @default 
 *
 * @param PostCostText:str
 * @text Post-Cost Text
 * @parent Text
 * @desc What text is added after the dice cost text?
 * Text codes allowed.
 * @default 
 *
 * @param PreEffectText:str
 * @text Pre-Effect Text
 * @parent Text
 * @desc What text is added before the dice effects text?
 * Text codes allowed.
 * @default 
 *
 * @param PostEffectText:str
 * @text Post-Effect Text
 * @parent Text
 * @desc What text is added after the dice effects text?
 * Text codes allowed.
 * @default 
 * 
 * @param Conditions
 * @text Effect Conditions
 *
 * @param ShowSwitchID:num
 * @text Show Switch ID
 * @parent Conditions
 * @type switch
 * @desc This Switch is required to be ON to show effect.
 * Use 0 to not use. Does not reveal mid-Dice Roll.
 * @default 0
 *
 * @param EnableSwitchID:num
 * @text Enable Switch ID
 * @parent Conditions
 * @type switch
 * @desc This Switch is required to be ON to enable effect.
 * Use 0 to not use.
 * @default 0
 *
 * @param ShowJS:func
 * @text JS: Show
 * @parent Conditions
 * @type note
 * @desc JavaScript code used to determine show conditions for
 * this dice effect to become available for use.
 * @default "// Does not reveal mid-Dice Roll.\nreturn true;"
 *
 * @param EnableJS:func
 * @text JS: Enable
 * @parent Conditions
 * @type note
 * @desc JavaScript code used to determine enable conditions for
 * this dice effect to become usable.
 * @default "return true;"
 *
 * @param ActivateJS:func
 * @text JS: On Select
 * @parent Conditions
 * @type note
 * @desc JavaScript code used to determine what happens when this
 * dice effect is selected and activated.
 * @default "// Do Nothing"
 *
 */
/* ----------------------------------------------------------------------------
 * Armor Auto Effects Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ArmorAutoEffect:
 *
 * @param Name:str
 * @text Auto Effect Name
 * @desc What is the name of this effect?
 * Text codes allowed. Use "AutoName" to auto-name.
 * @default AutoName
 *
 * @param Icon:num
 * @text Auto Effect Icon
 * @parent Name:str
 * @desc The icon used for this effect.
 * Use 1000000 to auto-select icon.
 * @default 1000000
 * 
 * @param RefData
 * @text Reference Data
 *
 * @param ArmorReqID:num
 * @text Required Armor ID
 * @parent RefData
 * @type armor
 * @desc This is the armor whose presence is checked.
 * Changes don't affect effect mid-roll.
 * @default 1
 *
 * @param ArmorIncludeEquip:eval
 * @text Include Equipped?
 * @type boolean
 * @parent ArmorReqID:num
 * @on Include Equipped
 * @off Unequipped Only
 * @desc Allow equipped armors to be included in the count.
 * @default true
 * 
 * @param DiceEffects
 * @text Dice Effects
 *
 * @param Advantage:eval
 * @text Count/Advantage
 * @parent DiceEffects
 * @desc Change dice count (roll value) or advantage/disadvantage
 * (target value). You may use code.
 * @default +0
 *
 * @param DiceRank:eval
 * @text Rank/Type
 * @parent DiceEffects
 * @desc Raises/lowers dice rank: D4, D6, D8, D10, D12, D20.
 * You may use code. Higher rank = more sides.
 * @default +0
 *
 * @param DiceModifier:eval
 * @text Modifier (Static)
 * @parent DiceEffects
 * @desc Alters the finalized rolled dice value.
 * You may use code.
 * @default +0
 *
 * @param DiceModifierRand:eval
 * @text Modifier (Random)
 * @parent DiceEffects
 * @desc Adds a random element to the dice value.
 * You may use code.
 * @default +0
 * 
 * @param Text
 * @text Additional Text
 *
 * @param PreEffectText:str
 * @text Pre-Effect Text
 * @parent Text
 * @desc What text is added before the dice effects text?
 * Text codes allowed.
 * @default 
 *
 * @param PostEffectText:str
 * @text Post-Effect Text
 * @parent Text
 * @desc What text is added after the dice effects text?
 * Text codes allowed.
 * @default 
 * 
 * @param Conditions
 * @text Effect Conditions
 *
 * @param SwitchID:num
 * @text Switch ID
 * @parent Conditions
 * @type switch
 * @desc This Switch is required to be ON to meet conditions.
 * Use 0 to not use. Does not reveal mid-Dice Roll.
 * @default 0
 *
 * @param ConditionJS:func
 * @text JS: Condition
 * @parent Conditions
 * @type note
 * @desc JavaScript code used to determine the conditions for
 * this dice effect to be automatically activated.
 * @default "// Does not reveal mid-Dice Roll.\nreturn true;"
 *
 */
/* ----------------------------------------------------------------------------
 * Armor Bonus Effects Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ArmorBonusEffect:
 *
 * @param Name:str
 * @text Bonus Effect Name
 * @desc What is the name of this effect?
 * Text codes allowed. Use "AutoName" to auto-name.
 * @default AutoName
 *
 * @param Icon:num
 * @text Bonus Effect Icon
 * @parent Name:str
 * @desc The icon used for this effect.
 * Use 1000000 to auto-select icon.
 * @default 1000000
 *
 * @param AnimationID:num
 * @text Animation ID
 * @parent Name:str
 * @type animation
 * @desc Play this animation when the effect activates.
 * Animation will play on the player character.
 * @default 0
 * 
 * @param Costs
 * @text Effect Costs
 *
 * @param ArmorCostID:num
 * @text Armor Cost ID
 * @parent Costs
 * @type armor
 * @desc This armor is to be deducted from.
 * Changes do not reveal effect mid-Dice Roll.
 * @default 2
 *
 * @param ArmorCostValue:eval
 * @text Cost Value
 * @parent ArmorCostID:num
 * @desc Deduct this much from the target armor.
 * You may use code.
 * @default 1
 *
 * @param ShowArmorCost:eval
 * @text Show Armor Cost?
 * @parent ArmorCostID:num
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show armor cost?
 * @default true
 *
 * @param MaxUses:eval
 * @text Maximum Uses
 * @parent Costs
 * @desc How many times can this effect be used?
 * You may use code. Over 1000000 for unlimited.
 * @default 1
 *
 * @param ShowUses:eval
 * @text Show Uses Left?
 * @parent MaxUses:eval
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show how many uses are left?
 * @default true
 * 
 * @param DiceEffects
 * @text Dice Effects
 *
 * @param Advantage:eval
 * @text Count/Advantage
 * @parent DiceEffects
 * @desc Change dice count (roll value) or advantage/disadvantage
 * (target value). You may use code.
 * @default +0
 *
 * @param DiceRank:eval
 * @text Rank/Type
 * @parent DiceEffects
 * @desc Raises/lowers dice rank: D4, D6, D8, D10, D12, D20.
 * You may use code. Higher rank = more sides.
 * @default +0
 *
 * @param DiceModifier:eval
 * @text Modifier (Static)
 * @parent DiceEffects
 * @desc Alters the finalized rolled dice value.
 * You may use code.
 * @default +0
 *
 * @param DiceModifierRand:eval
 * @text Modifier (Random)
 * @parent DiceEffects
 * @desc Adds a random element to the dice value.
 * You may use code.
 * @default +0
 * 
 * @param Text
 * @text Additional Text
 *
 * @param PreCostText:str
 * @text Pre-Cost Text
 * @parent Text
 * @desc What text is added before the dice cost text?
 * Text codes allowed.
 * @default 
 *
 * @param PostCostText:str
 * @text Post-Cost Text
 * @parent Text
 * @desc What text is added after the dice cost text?
 * Text codes allowed.
 * @default 
 *
 * @param PreEffectText:str
 * @text Pre-Effect Text
 * @parent Text
 * @desc What text is added before the dice effects text?
 * Text codes allowed.
 * @default 
 *
 * @param PostEffectText:str
 * @text Post-Effect Text
 * @parent Text
 * @desc What text is added after the dice effects text?
 * Text codes allowed.
 * @default 
 * 
 * @param Conditions
 * @text Effect Conditions
 *
 * @param ShowSwitchID:num
 * @text Show Switch ID
 * @parent Conditions
 * @type switch
 * @desc This Switch is required to be ON to show effect.
 * Use 0 to not use. Does not reveal mid-Dice Roll.
 * @default 0
 *
 * @param EnableSwitchID:num
 * @text Enable Switch ID
 * @parent Conditions
 * @type switch
 * @desc This Switch is required to be ON to enable effect.
 * Use 0 to not use.
 * @default 0
 *
 * @param ShowJS:func
 * @text JS: Show
 * @parent Conditions
 * @type note
 * @desc JavaScript code used to determine show conditions for
 * this dice effect to become available for use.
 * @default "// Does not reveal mid-Dice Roll.\nreturn true;"
 *
 * @param EnableJS:func
 * @text JS: Enable
 * @parent Conditions
 * @type note
 * @desc JavaScript code used to determine enable conditions for
 * this dice effect to become usable.
 * @default "return true;"
 *
 * @param ActivateJS:func
 * @text JS: On Select
 * @parent Conditions
 * @type note
 * @desc JavaScript code used to determine what happens when this
 * dice effect is selected and activated.
 * @default "// Do Nothing"
 *
 */
/* ----------------------------------------------------------------------------
 * Skill Auto Effects Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~SkillAutoEffect:
 *
 * @param Name:str
 * @text Auto Effect Name
 * @desc What is the name of this effect?
 * Text codes allowed. Use "AutoName" to auto-name.
 * @default AutoName
 *
 * @param Icon:num
 * @text Auto Effect Icon
 * @parent Name:str
 * @desc The icon used for this effect.
 * Use 1000000 to auto-select icon.
 * @default 1000000
 * 
 * @param RefData
 * @text Reference Data
 *
 * @param SkillReqID:num
 * @text Required Skill ID
 * @parent RefData
 * @type skill
 * @desc This is the skill whose presence is checked.
 * Changes don't affect effect mid-roll.
 * @default 52
 *
 * @param SkillLearnedOnly:eval
 * @text Skill Learned Only?
 * @parent SkillReqID:num
 * @type boolean
 * @on Learned Only
 * @off Temp Skills Allowed
 * @desc Require the skill to be learned only or allow temporary skills?
 * @default false
 *
 * @param SkillUser:str
 * @text Skill User(s)
 * @parent SkillReqID:num
 * @type select
 * @option Party Leader
 * @value leader
 * @option Any Party Member
 * @value anyMember
 * @option Every Party Member
 * @value everyMember
 * @option Any Battle Member
 * @value anyBattleMember
 * @option Every Battle Member
 * @value everyBattleMember
 * @option Any Specific Actor(s)
 * @value anySpecificActor
 * @option Every Specific Actor(s)
 * @value everySpecificActor
 * @desc Select which actor(s) to check for the required skill.
 * @default everyBattleMember
 *
 * @param SpecificActorIDs:arraynum
 * @text Specific Actor ID(s)
 * @parent SkillReqID:num
 * @type actor[]
 * @desc Determine which "Specific Actor(s)" to pick from.
 * Specific actor(s) must be in the party, main or reserve.
 * @default ["1"]
 *
 * @param SkillListUserName:eval
 * @text Show User Name?
 * @parent SkillReqID:num
 * @type boolean
 * @on Show Name
 * @off Don't Show
 * @desc Shows the skill user's name next to the skill name?
 * @default true
 *
 * @param SkillUserAlive:eval
 * @text Require User Alive?
 * @parent SkillReqID:num
 * @type boolean
 * @on Must Be Alive
 * @off Can Be Dead
 * @desc Requires the skill user to be alive?
 * Or can they be dead or alive?
 * @default true
 * 
 * @param DiceEffects
 * @text Dice Effects
 *
 * @param Advantage:eval
 * @text Count/Advantage
 * @parent DiceEffects
 * @desc Change dice count (roll value) or advantage/disadvantage
 * (target value). You may use code.
 * @default +0
 *
 * @param DiceRank:eval
 * @text Rank/Type
 * @parent DiceEffects
 * @desc Raises/lowers dice rank: D4, D6, D8, D10, D12, D20.
 * You may use code. Higher rank = more sides.
 * @default +0
 *
 * @param DiceModifier:eval
 * @text Modifier (Static)
 * @parent DiceEffects
 * @desc Alters the finalized rolled dice value.
 * You may use code.
 * @default +0
 *
 * @param DiceModifierRand:eval
 * @text Modifier (Random)
 * @parent DiceEffects
 * @desc Adds a random element to the dice value.
 * You may use code.
 * @default +0
 * 
 * @param Text
 * @text Additional Text
 *
 * @param PreEffectText:str
 * @text Pre-Effect Text
 * @parent Text
 * @desc What text is added before the dice effects text?
 * Text codes allowed.
 * @default 
 *
 * @param PostEffectText:str
 * @text Post-Effect Text
 * @parent Text
 * @desc What text is added after the dice effects text?
 * Text codes allowed.
 * @default 
 * 
 * @param Conditions
 * @text Effect Conditions
 *
 * @param SwitchID:num
 * @text Switch ID
 * @parent Conditions
 * @type switch
 * @desc This Switch is required to be ON to meet conditions.
 * Use 0 to not use. Does not reveal mid-Dice Roll.
 * @default 0
 *
 * @param ConditionJS:func
 * @text JS: Condition
 * @parent Conditions
 * @type note
 * @desc JavaScript code used to determine the conditions for
 * this dice effect to be automatically activated.
 * @default "// Does not reveal mid-Dice Roll.\nreturn true;"
 *
 */
/* ----------------------------------------------------------------------------
 * Skill Bonus Effects Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~SkillBonusEffect:
 *
 * @param Name:str
 * @text Bonus Effect Name
 * @desc What is the name of this effect?
 * Text codes allowed. Use "AutoName" to auto-name.
 * @default AutoName
 *
 * @param Icon:num
 * @text Bonus Effect Icon
 * @parent Name:str
 * @desc The icon used for this effect.
 * Use 1000000 to auto-select icon.
 * @default 1000000
 *
 * @param AnimationID:num
 * @text Animation ID
 * @parent Name:str
 * @type animation
 * @desc Play this animation when the effect activates.
 * Animation will play on the player character.
 * @default 0
 * 
 * @param Costs
 * @text Effect Costs
 *
 * @param SkillCostID:num
 * @text Skill Cost ID
 * @parent Costs
 * @type skill
 * @desc This skill's cost is to be paid by an actor.
 * Changes do not reveal effect mid-Dice Roll.
 * @default 52
 *
 * @param SkillLearnedOnly:eval
 * @text Skill Learned Only?
 * @parent SkillCostID:num
 * @type boolean
 * @on Learned Only
 * @off Temp Skills Allowed
 * @desc Require the skill to be learned only or allow temporary skills?
 * @default false
 *
 * @param SkillUser:str
 * @text Skill User(s)
 * @parent SkillCostID:num
 * @type select
 * @option Party Leader
 * @value leader
 * @option Any Party Member
 * @value anyMember
 * @option Every Party Member
 * @value everyMember
 * @option Any Battle Member
 * @value anyBattleMember
 * @option Every Battle Member
 * @value everyBattleMember
 * @option Any Specific Actor(s)
 * @value anySpecificActor
 * @option Every Specific Actor(s)
 * @value everySpecificActor
 * @desc Select which actor(s) to check for the required skill.
 * @default everyBattleMember
 *
 * @param SpecificActorIDs:arraynum
 * @text Specific Actor ID(s)
 * @parent SkillCostID:num
 * @type actor[]
 * @desc Determine which "Specific Actor(s)" to pick from.
 * Specific actor(s) must be in the party, main or reserve.
 * @default ["1"]
 *
 * @param SkillListUserName:eval
 * @text Show User Name?
 * @parent SkillCostID:num
 * @type boolean
 * @on Show Name
 * @off Don't Show
 * @desc Shows the skill user's name next to the skill name?
 * @default true
 *
 * @param SkillUserAlive:eval
 * @text Require User Alive?
 * @parent SkillCostID:num
 * @type boolean
 * @on Must Be Alive
 * @off Can Be Dead
 * @desc Requires the skill user to be alive?
 * Or can they be dead or alive?
 * @default true
 *
 * @param ShowSkillCost:eval
 * @text Show Skill Cost?
 * @parent SkillCostID:num
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show skill cost?
 * @default true
 *
 * @param MaxUses:eval
 * @text Maximum Uses
 * @parent Costs
 * @desc How many times can this effect be used?
 * You may use code. Over 1000000 for unlimited.
 * @default 1
 *
 * @param ShowUses:eval
 * @text Show Uses Left?
 * @parent MaxUses:eval
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show how many uses are left?
 * @default true
 * 
 * @param DiceEffects
 * @text Dice Effects
 *
 * @param Advantage:eval
 * @text Count/Advantage
 * @parent DiceEffects
 * @desc Change dice count (roll value) or advantage/disadvantage
 * (target value). You may use code.
 * @default +0
 *
 * @param DiceRank:eval
 * @text Rank/Type
 * @parent DiceEffects
 * @desc Raises/lowers dice rank: D4, D6, D8, D10, D12, D20.
 * You may use code. Higher rank = more sides.
 * @default +0
 *
 * @param DiceModifier:eval
 * @text Modifier (Static)
 * @parent DiceEffects
 * @desc Alters the finalized rolled dice value.
 * You may use code.
 * @default +0
 *
 * @param DiceModifierRand:eval
 * @text Modifier (Random)
 * @parent DiceEffects
 * @desc Adds a random element to the dice value.
 * You may use code.
 * @default +0
 * 
 * @param Text
 * @text Additional Text
 *
 * @param PreCostText:str
 * @text Pre-Cost Text
 * @parent Text
 * @desc What text is added before the dice cost text?
 * Text codes allowed.
 * @default 
 *
 * @param PostCostText:str
 * @text Post-Cost Text
 * @parent Text
 * @desc What text is added after the dice cost text?
 * Text codes allowed.
 * @default 
 *
 * @param PreEffectText:str
 * @text Pre-Effect Text
 * @parent Text
 * @desc What text is added before the dice effects text?
 * Text codes allowed.
 * @default 
 *
 * @param PostEffectText:str
 * @text Post-Effect Text
 * @parent Text
 * @desc What text is added after the dice effects text?
 * Text codes allowed.
 * @default 
 * 
 * @param Conditions
 * @text Effect Conditions
 *
 * @param ShowSwitchID:num
 * @text Show Switch ID
 * @parent Conditions
 * @type switch
 * @desc This Switch is required to be ON to show effect.
 * Use 0 to not use. Does not reveal mid-Dice Roll.
 * @default 0
 *
 * @param EnableSwitchID:num
 * @text Enable Switch ID
 * @parent Conditions
 * @type switch
 * @desc This Switch is required to be ON to enable effect.
 * Use 0 to not use.
 * @default 0
 *
 * @param ShowJS:func
 * @text JS: Show
 * @parent Conditions
 * @type note
 * @desc JavaScript code used to determine show conditions for
 * this dice effect to become available for use.
 * @default "// Does not reveal mid-Dice Roll.\nreturn true;"
 *
 * @param EnableJS:func
 * @text JS: Enable
 * @parent Conditions
 * @type note
 * @desc JavaScript code used to determine enable conditions for
 * this dice effect to become usable.
 * @default "return true;"
 *
 * @param ActivateJS:func
 * @text JS: On Select
 * @parent Conditions
 * @type note
 * @desc JavaScript code used to determine what happens when this
 * dice effect is selected and activated.
 * @default "// Do Nothing"
 *
 */
//=============================================================================

const _0x5db7a1=_0x2d89;(function(_0x34885b,_0x2ba793){const _0x134b1b=_0x2d89,_0x3226c1=_0x34885b();while(!![]){try{const _0x5ac8ad=parseInt(_0x134b1b(0xf0))/(-0x218f+-0x12c*0x5+-0xae*-0x3a)*(parseInt(_0x134b1b(0x3e6))/(-0x3f8+0x166*0x1+0x14a*0x2))+parseInt(_0x134b1b(0x4f2))/(0xec8+-0x59*-0x13+-0x1560)*(parseInt(_0x134b1b(0x173))/(0x1be*0xb+-0x1897+0x571))+parseInt(_0x134b1b(0x223))/(0x12bb+0x2dd+0x7*-0x315)*(parseInt(_0x134b1b(0x332))/(0x84b+-0x1c0+0x1*-0x685))+parseInt(_0x134b1b(0x338))/(-0x111d+0xdcf+0x355)+-parseInt(_0x134b1b(0x192))/(-0x6*0x38b+0x26a*0x2+-0xe*-0x12d)+-parseInt(_0x134b1b(0x57e))/(0x9ee+-0x25db+-0x2*-0xdfb)*(-parseInt(_0x134b1b(0x3fe))/(-0x6f4+-0x1*0x6fb+0xdf9))+-parseInt(_0x134b1b(0xcb))/(0x8e*0x2f+-0x25be+0xbb7);if(_0x5ac8ad===_0x2ba793)break;else _0x3226c1['push'](_0x3226c1['shift']());}catch(_0x51b1b4){_0x3226c1['push'](_0x3226c1['shift']());}}}(_0x42c9,-0x2*-0x19501+0x1183*0x6d+-0x64de9*0x1));var label=_0x5db7a1(0x50f)+_0x5db7a1(0x20a),tier=tier||0x1*0xd70+-0x7cf+-0x5a1,dependencies=[],pluginData=$plugins[_0x5db7a1(0x524)](function(_0x4f9914){const _0x1872c4=_0x5db7a1,_0x21b6e4={'gwEHZ':function(_0x9583b5,_0xc090c1){return _0x9583b5+_0xc090c1;},'wedJS':function(_0x1387f7,_0x531839){return _0x1387f7+_0x531839;}};return _0x4f9914[_0x1872c4(0x426)]&&_0x4f9914['descriptio'+'n'][_0x1872c4(0x135)](_0x21b6e4['gwEHZ'](_0x21b6e4[_0x1872c4(0x25c)]('[',label),']'));})[0x705*-0x3+0xe27*0x1+0x6e8];VisuMZ[label]['Settings']=VisuMZ[label]['Settings']||{},VisuMZ[_0x5db7a1(0x334)+_0x5db7a1(0x497)]=function(_0x481cb6,_0x3f84f3){const _0x156e8e=_0x5db7a1,_0x5cb8ae={'BCQfz':function(_0x647963,_0x5cb0a8){return _0x647963(_0x5cb0a8);},'Ezame':function(_0x181624,_0x3d892e){return _0x181624(_0x3d892e);},'sWpxw':'NUM','TIXJP':function(_0x200a94,_0x2da13b){return _0x200a94!==_0x2da13b;},'SkEPP':'ARRAYNUM','eQZyY':_0x156e8e(0x5e9),'TiYhQ':function(_0x365b3e,_0x1ecb00){return _0x365b3e!==_0x1ecb00;},'DVyCn':function(_0x4a9bb1,_0x2b186a){return _0x4a9bb1(_0x2b186a);},'xeZYF':_0x156e8e(0x271),'PszJW':_0x156e8e(0x384),'MLAcB':'ARRAYJSON','hMdMp':function(_0x2c1585,_0x2aa57b){return _0x2c1585!==_0x2aa57b;},'dLfnd':'FUNC','uLnCy':_0x156e8e(0x32a),'PhXaV':_0x156e8e(0x225),'zUtgC':function(_0x512db3,_0x4ce48b){return _0x512db3!==_0x4ce48b;},'WbTXi':_0x156e8e(0x23c),'tFqTa':'ARRAYSTR','GBtwn':function(_0x72eb82,_0xbbddc3){return _0x72eb82!==_0xbbddc3;},'zcFcj':_0x156e8e(0x3f4),'yilkh':function(_0x1e8eb0,_0x54c65d){return _0x1e8eb0!==_0x54c65d;},'ATisf':_0x156e8e(0x273)+'T','DQlLs':function(_0x4a874a,_0x259e8d){return _0x4a874a!==_0x259e8d;}};for(const _0x334522 in _0x3f84f3){if(_0x334522['match'](/(.*):(.*)/i)){const _0x19e165=_0x5cb8ae[_0x156e8e(0x58b)](String,RegExp['$1']),_0x58811b=_0x5cb8ae[_0x156e8e(0x123)](String,RegExp['$2'])[_0x156e8e(0x3bf)+'e']()['trim']();let _0x3a0dfc,_0x30976a,_0xc7ec8e;switch(_0x58811b){case _0x5cb8ae[_0x156e8e(0x2d1)]:_0x3a0dfc=_0x5cb8ae[_0x156e8e(0x37a)](_0x3f84f3[_0x334522],'')?_0x5cb8ae[_0x156e8e(0x123)](Number,_0x3f84f3[_0x334522]):0x1*0xe0b+-0x31d*-0x6+-0x20b9;break;case _0x5cb8ae['SkEPP']:_0x30976a=_0x5cb8ae[_0x156e8e(0x37a)](_0x3f84f3[_0x334522],'')?JSON[_0x156e8e(0x350)](_0x3f84f3[_0x334522]):[],_0x3a0dfc=_0x30976a[_0x156e8e(0x3fc)](_0x4fb8a6=>Number(_0x4fb8a6));break;case _0x5cb8ae[_0x156e8e(0x51d)]:_0x3a0dfc=_0x5cb8ae[_0x156e8e(0x46e)](_0x3f84f3[_0x334522],'')?_0x5cb8ae[_0x156e8e(0x4af)](eval,_0x3f84f3[_0x334522]):null;break;case _0x5cb8ae[_0x156e8e(0x136)]:_0x30976a=_0x5cb8ae['TiYhQ'](_0x3f84f3[_0x334522],'')?JSON[_0x156e8e(0x350)](_0x3f84f3[_0x334522]):[],_0x3a0dfc=_0x30976a[_0x156e8e(0x3fc)](_0x59448b=>eval(_0x59448b));break;case _0x5cb8ae[_0x156e8e(0x56c)]:_0x3a0dfc=_0x5cb8ae[_0x156e8e(0x46e)](_0x3f84f3[_0x334522],'')?JSON['parse'](_0x3f84f3[_0x334522]):'';break;case _0x5cb8ae[_0x156e8e(0x26d)]:_0x30976a=_0x5cb8ae[_0x156e8e(0x303)](_0x3f84f3[_0x334522],'')?JSON['parse'](_0x3f84f3[_0x334522]):[],_0x3a0dfc=_0x30976a[_0x156e8e(0x3fc)](_0x3391ca=>JSON[_0x156e8e(0x350)](_0x3391ca));break;case _0x5cb8ae[_0x156e8e(0x2be)]:_0x3a0dfc=_0x5cb8ae['TiYhQ'](_0x3f84f3[_0x334522],'')?new Function(JSON[_0x156e8e(0x350)](_0x3f84f3[_0x334522])):new Function(_0x5cb8ae[_0x156e8e(0x37d)]);break;case _0x5cb8ae[_0x156e8e(0x5ae)]:_0x30976a=_0x5cb8ae[_0x156e8e(0x538)](_0x3f84f3[_0x334522],'')?JSON[_0x156e8e(0x350)](_0x3f84f3[_0x334522]):[],_0x3a0dfc=_0x30976a[_0x156e8e(0x3fc)](_0x30236b=>new Function(JSON[_0x156e8e(0x350)](_0x30236b)));break;case _0x5cb8ae['WbTXi']:_0x3a0dfc=_0x5cb8ae['TiYhQ'](_0x3f84f3[_0x334522],'')?_0x5cb8ae['BCQfz'](String,_0x3f84f3[_0x334522]):'';break;case _0x5cb8ae['tFqTa']:_0x30976a=_0x5cb8ae['GBtwn'](_0x3f84f3[_0x334522],'')?JSON[_0x156e8e(0x350)](_0x3f84f3[_0x334522]):[],_0x3a0dfc=_0x30976a[_0x156e8e(0x3fc)](_0x121281=>String(_0x121281));break;case _0x5cb8ae['zcFcj']:_0xc7ec8e=_0x5cb8ae[_0x156e8e(0x333)](_0x3f84f3[_0x334522],'')?JSON[_0x156e8e(0x350)](_0x3f84f3[_0x334522]):{},_0x3a0dfc=VisuMZ[_0x156e8e(0x334)+'ams']({},_0xc7ec8e);break;case _0x5cb8ae['ATisf']:_0x30976a=_0x5cb8ae['DQlLs'](_0x3f84f3[_0x334522],'')?JSON[_0x156e8e(0x350)](_0x3f84f3[_0x334522]):[],_0x3a0dfc=_0x30976a[_0x156e8e(0x3fc)](_0x48a979=>VisuMZ[_0x156e8e(0x334)+_0x156e8e(0x497)]({},JSON[_0x156e8e(0x350)](_0x48a979)));break;default:continue;}_0x481cb6[_0x19e165]=_0x3a0dfc;}}return _0x481cb6;},(_0x47b1b6=>{const _0x46ee6b=_0x5db7a1,_0x3969f8={'lmCHm':function(_0x1300be,_0x214305){return _0x1300be(_0x214305);},'Zmpod':'%1\x20is\x20miss'+_0x46ee6b(0x4b5)+'ired\x20plugi'+_0x46ee6b(0x1e3)+_0x46ee6b(0xba)+_0x46ee6b(0x2d0)+'Plugin\x20Man'+_0x46ee6b(0x3d6),'FskOa':function(_0x5953e7,_0xf3f451){return _0x5953e7!==_0xf3f451;},'eFfUe':_0x46ee6b(0xf6)+'on\x20does\x20no'+_0x46ee6b(0x131)+'ugin\x27s.\x20Pl'+_0x46ee6b(0x492)+_0x46ee6b(0x261)+_0x46ee6b(0x5f2)+'anager.','hxRNC':function(_0x19cef2,_0x4e6fb5){return _0x19cef2(_0x4e6fb5);},'qXKOD':function(_0x470b71,_0x3d816b){return _0x470b71<_0x3d816b;},'gbnDU':_0x46ee6b(0x3c1)+_0x46ee6b(0x22f)+_0x46ee6b(0x295)+_0x46ee6b(0x161)+_0x46ee6b(0x2c7)+_0x46ee6b(0x55a)+'\x20plugin\x20pl'+_0x46ee6b(0x468)+'other\x20Tier'+'\x20%3\x20plugin'+_0x46ee6b(0x437)+'reorder\x20th'+_0x46ee6b(0x161)+'ist\x20from\x20s'+_0x46ee6b(0x321)+_0x46ee6b(0x3c4)+_0x46ee6b(0x5c4)+'s.'},_0x21c13c=_0x47b1b6[_0x46ee6b(0x5a2)];for(const _0x4eddea of dependencies){if(!Imported[_0x4eddea]){_0x3969f8[_0x46ee6b(0x330)](alert,_0x3969f8[_0x46ee6b(0x5f3)][_0x46ee6b(0x13e)](_0x21c13c,_0x4eddea)),SceneManager[_0x46ee6b(0xbc)]();break;}}const _0x174c0c=_0x47b1b6[_0x46ee6b(0x382)+'n'];if(_0x174c0c[_0x46ee6b(0x316)](/\[Version[ ](.*?)\]/i)){const _0x3d65a8=_0x3969f8[_0x46ee6b(0x330)](Number,RegExp['$1']);_0x3969f8[_0x46ee6b(0x4de)](_0x3d65a8,VisuMZ[label][_0x46ee6b(0x42f)])&&(_0x3969f8['lmCHm'](alert,_0x3969f8[_0x46ee6b(0x112)][_0x46ee6b(0x13e)](_0x21c13c,_0x3d65a8)),SceneManager[_0x46ee6b(0xbc)]());}if(_0x174c0c[_0x46ee6b(0x316)](/\[Tier[ ](\d+)\]/i)){const _0x11318f=_0x3969f8[_0x46ee6b(0x496)](Number,RegExp['$1']);_0x3969f8[_0x46ee6b(0x49f)](_0x11318f,tier)?(_0x3969f8[_0x46ee6b(0x496)](alert,_0x3969f8['gbnDU']['format'](_0x21c13c,_0x11318f,tier)),SceneManager['exit']()):tier=Math['max'](_0x11318f,tier);}VisuMZ[_0x46ee6b(0x334)+'ams'](VisuMZ[label][_0x46ee6b(0x573)],_0x47b1b6[_0x46ee6b(0x195)]);})(pluginData),PluginManager[_0x5db7a1(0x2dd)+_0x5db7a1(0x4fc)](pluginData[_0x5db7a1(0x5a2)],_0x5db7a1(0x388)+_0x5db7a1(0x1bf),_0x2bca62=>{const _0x357030=_0x5db7a1,_0x4af345={'FzVmX':_0x357030(0x20e)};if(!SceneManager['canRollDic'+'e']())return;VisuMZ[_0x357030(0x334)+_0x357030(0x497)](_0x2bca62,_0x2bca62);const _0x32bd91={};_0x32bd91[_0x357030(0x233)]=_0x4af345[_0x357030(0x43c)],VisuMZ[_0x357030(0x50f)+_0x357030(0x20a)][_0x357030(0x3f8)+'oll'](_0x32bd91,_0x2bca62);}),PluginManager['registerCo'+_0x5db7a1(0x4fc)](pluginData['name'],_0x5db7a1(0x200)+_0x5db7a1(0xe1),_0x78bbcb=>{const _0x511d4e=_0x5db7a1,_0x5bd784={'yCKLX':_0x511d4e(0x450)+'e'};if(!SceneManager['canRollDic'+'e']())return;VisuMZ[_0x511d4e(0x334)+_0x511d4e(0x497)](_0x78bbcb,_0x78bbcb);const _0x295cc9={};_0x295cc9[_0x511d4e(0x233)]=_0x5bd784['yCKLX'],VisuMZ[_0x511d4e(0x50f)+_0x511d4e(0x20a)]['SetupDiceR'+_0x511d4e(0xc0)](_0x295cc9,_0x78bbcb);}),VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x3f8)+_0x5db7a1(0xc0)]=function(_0x1d94f4,_0x2ecb4d){const _0x5a6b4b=_0x5db7a1;for(const _0x2e5510 in _0x2ecb4d){_0x1d94f4[_0x2e5510]=_0x2ecb4d[_0x2e5510];}_0x1d94f4[_0x5a6b4b(0x3de)]=_0x1d94f4[_0x5a6b4b(0x3de)]||0x24*-0x13+-0x648*-0x1+-0xd*0x47,_0x1d94f4[_0x5a6b4b(0x3de)]=_0x1d94f4[_0x5a6b4b(0x3de)][_0x5a6b4b(0x28f)](-0x12db+-0x1349+-0xcb7*-0x3,VisuMZ[_0x5a6b4b(0x50f)+'ngSeeds']['MAX_DICE']),![0x221*0xb+-0x1035+0x1*-0x732,0x875*0x2+-0x8*0x187+-0x4ac,-0x18ea+-0xd89+0x267b,0x237f+-0x1117*-0x1+-0x1a46*0x2,0x1c7e+0x100*-0x11+0x2*-0x5b9,0x567*0x1+-0xa2a+0x15*0x3b][_0x5a6b4b(0x135)](_0x1d94f4[_0x5a6b4b(0x119)])&&(_0x1d94f4['DiceSides']=0x14e*-0x7+0xb*0x11f+-0x31f),_0x1d94f4['DiceRank']=[-0x1d79*-0x1+-0x94f+-0x142a,0x221c+0x3ba+-0x25d2,-0x2052+0x1*0x428+0x1*0x1c30,0x73*0x2e+0x204e*0x1+0x1e4*-0x1c,0x16*0x123+-0x3*-0x6b5+-0x11*0x2a7,0x1d78+0x31f*0x5+0x2d07*-0x1,0x259b*-0x1+-0xb6c+0x311b][_0x5a6b4b(0x470)](_0x1d94f4['DiceSides']),_0x1d94f4[_0x5a6b4b(0x26b)]&&$gameSwitches[_0x5a6b4b(0x247)](_0x1d94f4[_0x5a6b4b(0x26b)],![]),_0x1d94f4[_0x5a6b4b(0x480)]&&$gameVariables[_0x5a6b4b(0x247)](_0x1d94f4['VariableID'],-0x1*0x705+0xe88+-0x783),SceneManager[_0x5a6b4b(0x288)+_0x5a6b4b(0xc0)](_0x1d94f4);},PluginManager[_0x5db7a1(0x2dd)+'mmand'](pluginData[_0x5db7a1(0x5a2)],_0x5db7a1(0x21a)+_0x5db7a1(0x198),_0x5b95e4=>{const _0x42b2b8=_0x5db7a1,_0x11c2bf={'mKfPc':function(_0x30a860,_0x1d7da4){return _0x30a860(_0x1d7da4);}};VisuMZ[_0x42b2b8(0x334)+_0x42b2b8(0x497)](_0x5b95e4,_0x5b95e4);const _0xaf795b=_0x5b95e4['VariableID']||0x19c2+0x1582+0x2f43*-0x1,_0x231047=Math[_0x42b2b8(0x1fb)](_0x5b95e4['Min']||0x409+-0xb9c+-0x1*-0x793,_0x5b95e4['Max']||0xcab+0x1f92+0x3*-0xebf),_0x28a412=Math['max'](_0x5b95e4['Min']||0xb*-0x356+0x53*-0x2f+0x5*0xa63,_0x5b95e4[_0x42b2b8(0x1fa)]||0x1*-0x1+-0x5b4+0x5b5),_0x200768=_0x11c2bf[_0x42b2b8(0x3c0)](String,_0x5b95e4[_0x42b2b8(0x375)])||'-',_0x2fe6f9=_0x5b95e4['ApplyDaily'],_0x6122e0=_0x5b95e4[_0x42b2b8(0x2e4)+'e'],_0x5c54fe=$gameSystem['getNextRan'+_0x42b2b8(0x605)+'mberFromSe'+'ed'](_0x231047,_0x28a412,_0x200768,_0x2fe6f9,_0x6122e0);$gameVariables[_0x42b2b8(0x247)](_0xaf795b,_0x5c54fe);}),PluginManager[_0x5db7a1(0x2dd)+_0x5db7a1(0x4fc)](pluginData[_0x5db7a1(0x5a2)],'Reset_RngS'+_0x5db7a1(0x221),_0x5dd97f=>{const _0x4519bb=_0x5db7a1,_0x19e9f9={'BHfWn':function(_0x1dddf4,_0xdbe1a8){return _0x1dddf4(_0xdbe1a8);}};VisuMZ[_0x4519bb(0x334)+_0x4519bb(0x497)](_0x5dd97f,_0x5dd97f);const _0x34b05d=_0x19e9f9[_0x4519bb(0x1ac)](String,_0x5dd97f[_0x4519bb(0x375)])||'-',_0x4e81b5=_0x5dd97f[_0x4519bb(0x3a2)],_0x5721ae=_0x5dd97f[_0x4519bb(0x2e4)+'e'];$gameSystem[_0x4519bb(0x4ff)+_0x4519bb(0x24f)+'d'](_0x34b05d,_0x4e81b5,_0x5721ae);}),VisuMZ['DiceRollsR'+_0x5db7a1(0x20a)][_0x5db7a1(0x296)]={'rngSeed':/<(?:RNG|SEED|RNG SEED):[ ](.*?)>/gi,'dailySeed':/<DAILY (?:RNG|SEED|RNG SEED):[ ](.*?)>/gi,'uniqueSeed':/<UNIQUE (?:RNG|SEED|RNG SEED):[ ](.*?)>/gi,'dailyUniqueSeed':/<DAILY UNIQUE (?:RNG|SEED|RNG SEED):[ ](.*?)>/gi,'noRngSeed':/<NO (?:RNG|SEED|RNG SEED)>/gi},ImageManager[_0x5db7a1(0x229)+'RATIOS']={'border':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x573)][_0x5db7a1(0x2f7)][_0x5db7a1(0x3c3)+_0x5db7a1(0x495)]??0x2*0xee6+-0x8*-0x56+-0x207c+0.3,'color1':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x573)][_0x5db7a1(0x2f7)]['Color1Rati'+'o']??0xd61+0x3*0xa84+-0x7*0x66b+0.6,'color2':VisuMZ['DiceRollsR'+'ngSeeds'][_0x5db7a1(0x573)]['Dice'][_0x5db7a1(0x465)+'o']??0xea8+0x1b2a+-0x29d2+0.8,'color3':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x573)]['Dice'][_0x5db7a1(0x3e5)+'o']??0x674+0x13a*-0x11+0xe67},ImageManager[_0x5db7a1(0x207)+_0x5db7a1(0x265)]=function(_0x469672){const _0x24486d=_0x5db7a1,_0x41f212=_0x469672[Math['randomInt'](_0x469672[_0x24486d(0x5de)])];return this[_0x24486d(0x19a)+'e'](_0x41f212);},ImageManager[_0x5db7a1(0x18f)+_0x5db7a1(0x3fa)]=function(_0x47cb7c,_0x2d6cfe){const _0x2c7441=_0x5db7a1,_0x19667e={'fHECj':_0x2c7441(0x121),'XZnVf':'d12','RYLNg':_0x2c7441(0x346)},_0x337472=_0x2d6cfe[Math['randomInt'](_0x2d6cfe['length'])]??'6';switch(_0x47cb7c){case'd4':return this[_0x2c7441(0x18f)+_0x2c7441(0x1d4)](_0x337472);case'd6':return this['createDice'+'Graphic_D6'](_0x337472);case'd8':return this[_0x2c7441(0x18f)+_0x2c7441(0x428)](_0x337472);case _0x19667e[_0x2c7441(0x4b8)]:return this[_0x2c7441(0x18f)+'Graphic_D1'+'0'](_0x337472);case _0x19667e['XZnVf']:return this[_0x2c7441(0x18f)+_0x2c7441(0x4c9)+'2'](_0x337472);case _0x19667e['RYLNg']:default:return this[_0x2c7441(0x18f)+_0x2c7441(0x461)+'0'](_0x337472);}},ImageManager['createDice'+_0x5db7a1(0x1d4)]=function(_0x6ef0f1){const _0x2726b=_0x5db7a1,_0x3503b7={'OyWrU':_0x2726b(0x18a),'EZmWH':function(_0x376aed,_0x1b9e29){return _0x376aed!==_0x1b9e29;},'aZHOU':'butt','NdMbA':_0x2726b(0x458)},_0x42d5b8=_0x3503b7['OyWrU'][_0x2726b(0x13e)](_0x6ef0f1);this[_0x2726b(0x352)+'ateDiceGra'+'phic_D4']=this[_0x2726b(0x352)+_0x2726b(0x206)+_0x2726b(0x432)]||{};if(_0x3503b7['EZmWH'](this[_0x2726b(0x352)+_0x2726b(0x206)+_0x2726b(0x432)][_0x42d5b8],undefined))return this['_cache_cre'+'ateDiceGra'+_0x2726b(0x432)][_0x42d5b8];const _0x3c8db8=ImageManager[_0x2726b(0x229)+'RATIOS'],_0x4e798d=ColorManager[_0x2726b(0x314)+'r'](_0x6ef0f1,_0x3c8db8[_0x2726b(0x3a7)]),_0x67ec88=ColorManager[_0x2726b(0x314)+'r'](_0x6ef0f1,_0x3c8db8[_0x2726b(0x2a5)]),_0x40406a=ColorManager[_0x2726b(0x314)+'r'](_0x6ef0f1,_0x3c8db8[_0x2726b(0x128)]),_0x5e062e=ColorManager['darkenColo'+'r'](_0x6ef0f1,_0x3c8db8['color3']),_0x43c0d0=new Bitmap(-0x17cd+0x581*-0x1+0x1dde,0x259f*-0x1+0x4a3*-0x2+0x2f69*0x1),_0xbe376=_0x43c0d0[_0x2726b(0x256)];return _0xbe376['save'](),_0xbe376[_0x2726b(0x268)](),_0xbe376['fillStyle']=_0x67ec88,_0xbe376[_0x2726b(0x363)]=-0xb63*-0x1+0x14c0+-0x2023+0.070004,_0xbe376[_0x2726b(0x1cf)]=_0x3503b7['aZHOU'],_0xbe376['lineJoin']=_0x3503b7['NdMbA'],_0xbe376[_0x2726b(0x5bd)](0x1c24+-0x1871+-0x36c+0.3622749999999968,0xc0e+-0x1b17*-0x1+-0xe9*0x2b+0.5149699999999999),_0xbe376[_0x2726b(0xc1)](0x1f5f*-0x1+0x1a6c+-0x4f6*-0x1+0.7724549999999999,-0xef5+0x265b+-0x5*0x49e+0.7934120000000036),_0xbe376[_0x2726b(0xc1)](0x25bc+0xc5f*-0x1+-0x195a+0.45808399999999994,0x2360*0x1+-0x52b+0xc3*-0x27+0.577840000000009),_0xbe376[_0x2726b(0xc1)](-0x16c6+0x1cd9*-0x1+0x1*0x3429+0.6377200000000016,-0x14b9+-0xdcc+0xa3*0x37+0.8922100000000057),_0xbe376[_0x2726b(0xc1)](0x1dc5+0x18e*-0xb+-0xc1e+0.15269000000000688,0x1321+-0x15d*0x11+0x3d*0x13+0.5478999999999985),_0xbe376[_0x2726b(0xc1)](0x15ad+0x251+-0x17b4+0.8203579999999988,-0x47*0x7f+-0xfea+-0x1993*-0x2+0.14371199999999984),_0xbe376[_0x2726b(0x3a8)](),_0xbe376['beginPath'](),_0xbe376[_0x2726b(0x5db)]=_0x40406a,_0xbe376[_0x2726b(0x363)]=0x1cb9+-0x12*-0x32+-0x7*0x49b+0.070004,_0xbe376[_0x2726b(0x1cf)]=_0x3503b7[_0x2726b(0x5e3)],_0xbe376[_0x2726b(0x4a0)]=_0x3503b7[_0x2726b(0x1ee)],_0xbe376['moveTo'](0x15e2+-0x1e78+0x8b1+0.9790419999999997,-0xc9e*-0x3+-0x25c5+0xa*0x3+0.24251499999999737),_0xbe376[_0x2726b(0xc1)](0xd46*0x1+0xad9*-0x3+0x134c+0.5449099999999998,0x2311+-0x57b*0x1+-0x5d1*0x5+0.2065900000000056),_0xbe376['lineTo'](-0xba8+0x18*0x98+-0x1*0x232+0.48502999999999474,-0x1f5b+-0x1*-0x9e0+0xd*0x1b1+0.14969999999999573),_0xbe376[_0x2726b(0xc1)](0x188+0x16a3+0x29*-0x95+0.9071840000000009,0x1a6b+0x1*0x1865+-0x32c8+0.8023950000000006),_0xbe376[_0x2726b(0xc1)](0x1*0x15b0+0x977+-0x1ede+0.5628729999999962,-0x751*-0x1+-0x2*-0x412+-0x317*0x5+0.20059899999999997),_0xbe376['lineTo'](-0x1f5a+-0x53*0x73+0x44e4+0.7035920000000004,0x26c9*0x1+-0x3*0x22f+-0x26*0xd9+0.9161679999999999),_0xbe376[_0x2726b(0x3a8)](),_0xbe376[_0x2726b(0x268)](),_0xbe376[_0x2726b(0x5db)]=_0x5e062e,_0xbe376[_0x2726b(0x363)]=-0x15f6+0x29*-0x6d+-0x1*-0x276b+0.070004,_0xbe376[_0x2726b(0x1cf)]=_0x3503b7[_0x2726b(0x5e3)],_0xbe376['lineJoin']=_0x3503b7[_0x2726b(0x1ee)],_0xbe376[_0x2726b(0x5bd)](-0x9fe*0x3+0x53a*0x2+0x13d0+0.03442900000000293,-0x211+-0xc24+-0x38*-0x41+0.7331590000000001),_0xbe376[_0x2726b(0xc1)](-0x12a3*-0x1+0x914+-0x1bb1+0.051647,0xe48+0x1dcd+-0x2b93+0.7784399999999891),_0xbe376['lineTo'](-0x241f+0x4*-0x809+0x44cd+0.9521000000000015,0x158f+0x1d*0x74+-0x2*0x1119+0.5209600000000023),_0xbe376[_0x2726b(0xc1)](0x1c1f+-0x2509+0x975+0.5808399999999949,0x21c6+0x23f3*0x1+-0x4546+0.6886200000000002),_0xbe376[_0x2726b(0x3a8)](),_0xbe376[_0x2726b(0x268)](),_0xbe376[_0x2726b(0x363)]=-0xc3e+-0x2234+-0xa*-0x4a5+0.200081,_0xbe376[_0x2726b(0x5db)]=_0x4e798d,_0xbe376[_0x2726b(0x5bd)](-0x1bca*-0x1+0x766*0x2+-0x2a08+0.9923400000000129,0x61*-0x29+-0x635+-0x471*-0x5+0.7990700000000004),_0xbe376[_0x2726b(0xc1)](0x15fd+0x42d*-0x2+0x9*-0x17b+0.03467399999999543,0x22b5+-0x1af4+0x1*-0x7bd+0.2856329999999998),_0xbe376[_0x2726b(0x189)+_0x2726b(0x4ba)](-0xd*-0x44+-0x246+-0xe0+0.7460930000000019,0x61*0x2a+-0x61*-0x29+-0x1f72+0.9219660000000001,0x1e67+0x137b+-0x3196+0.38864700000000596,-0x7f*-0x1a+-0x19c3+-0x59*-0x25+0.339813,-0x167f+-0x9d8*0x3+-0x4*-0xd14+0.7210440000000062,-0xb*-0x307+0x259*-0xd+-0xb2*0x4+0.048365),_0xbe376[_0x2726b(0x189)+_0x2726b(0x4ba)](0x776+0x1*0x32f+-0xa5e+0.053439999999994825,-(0x2a0*-0x2+-0x2077+0x25b7+0.243082),-0x24dd+-0x14f6*0x1+0x3a17+0.412352999999996,-0x1f2d*-0x1+-0x13e1+0x1e2*-0x6+0.792958,-0x4ed+0x4*0x45d+-0xc45+0.6477739999999983,0x721+0x254*-0xd+0x19*0xed+0.823054),_0xbe376[_0x2726b(0xc1)](-0xc79*0x3+-0x1*-0x1227+0x1346*0x1+0.022391999999999967,-0x2454+0x599+-0x18*-0x14b+0.1872539999999958),_0xbe376['bezierCurv'+_0x2726b(0x4ba)](0x1635*0x1+0x35*0x9+-0x1812+0.718566,-0x7f*-0xd+-0x1*0xc1+0x4*-0x159+0.6886980000000023,-0xc2*0x22+-0x2085+0x3a49+0.00016,-0x1530+0x8*-0x1cd+0x4*0x8fa+0.6134380000000021,0x1*-0x116e+-0x2155*0x1+0x32c3,0x1c04+0x157d*0x1+0x577*-0x9+0.6056039999999996),_0xbe376[_0x2726b(0xc1)](-0x10c7+-0x2*-0x841+0x45+0.0086,0x1795+-0xe6*0x19+-0x1*0xa4+0.6942300000000046),_0xbe376[_0x2726b(0x189)+_0x2726b(0x4ba)](-0x2546+-0x21ba+0x47*0x100+0.008596,0x259c+-0x100c+-0x1510+0.24486400000000685,0xa90+-0x1966+0xb5*0x15+0.6798440000000001,-0xbef+0x1233+-0x5c1+0.935056000000003,-0x3c1*0x1+0x1418+-0x104f+0.2112829999999999,0x99d*0x3+-0x1a89+-0x1cb+0.9392400000000123),_0xbe376[_0x2726b(0xc1)](-0x2*-0x8a0+-0xaa4+-0x615+0.7867899999999963,0x3*-0xb87+0x1*-0x11b+0xe*0x296+0.000040000000012696546),_0xbe376[_0x2726b(0x189)+_0x2726b(0x4ba)](-0x1388*0x1+0x1a0a+-0x5f8+0.6865679999999941,-0x121b+-0x982+0x1c21+0.0011090000000137934,-0x1a9e+-0x1241+-0x286*-0x12+0.3718430000000126,0x2067+0x1d47+0x1*-0x3d2c+0.46596099999999296,0xc43*-0x2+0x153e+0x3d6+0.8512159999999938,0x171c+0xad6+0x1*-0x2173+0.9613719999999972),_0xbe376['bezierCurv'+_0x2726b(0x4ba)](0x13c+0x3a5+-0x1*0x451+0.3305900000000008,0x1be1+-0xa3d*0x1+-0x1127+0.456782000000004,0xe1b*-0x1+-0x5f*0x3+0x14*0xca+0.3846240000000023,-0x285+-0x1ecd*0x1+0x21cc+0.35425999999999647,-0x1566+-0x980+-0x84*-0x3d+0.9933699999999988,0x222e+-0x32e*0x5+0x1*-0x11d1+0.7992500000000007),_0xbe376[_0x2726b(0x5bd)](-0x1281+0x1e89+0xb7e*-0x1+0.06470999999999094,0x1027+-0x169+0x4*-0x391+0.4590000000000032),_0xbe376[_0x2726b(0x189)+_0x2726b(0x4ba)](-0x46*0x7+0xa9b+-0x827+0.49828500000000986,-0x1*-0x19dd+0x47*0x5+-0x1ac5+0.25909099999999796,-0xcf1+-0x20c5*0x1+0x2e40+0.4803770000000043,0x798+-0x15c2+-0x19*-0x96+0.2293240000000054,0x2391+0x1990+0x3c97*-0x1+0.017573999999996204,-0x26eb*0x1+0x493*0x5+0x1089+0.012728999999993107),_0xbe376[_0x2726b(0x189)+_0x2726b(0x4ba)](-0x1393+0x1509+-0xed+0.554772000000014,-0x5*-0x4e2+-0x1*0x1d59+0x56c+0.796133999999995,0x1aac+0xfbc+-0x29e0+0.7154409999999984,0x19d6+-0x695*-0x3+0x11*-0x2a7+0.2769870000000054,0x19a*-0x2+-0x24d+-0xc1*-0x8+0.8083900000000028,0x1c3c+-0xa9a+-0x1124+0.27836999999999534),_0xbe376[_0x2726b(0xc1)](0x2608+-0xadb+-0x1b25+0.13477400000000017,-0xe42+-0x15d+0x101d+0.3843399999999946),_0xbe376['bezierCurv'+_0x2726b(0x4ba)](-0x14cb+-0x69+0x153a+0.7136110000000002,0x21d3+-0x7*-0x6d+0x530*-0x7+0.38434100000000626,-0xf19+-0x7*0x1ef+0x5*0x5bb+0.5615300000000003,-0x701*-0x1+-0x701*-0x1+-0x1*0xd85+0.22738200000000575,-0x2206*0x1+0x1*0xcdf+0x152c+0.5615290000000002,0x233b+-0x4*-0x9af+0x2*-0x24be+0.8002000000000038),_0xbe376[_0x2726b(0xc1)](-0x8e6+-0x9eb+0x12d6*0x1+0.5701289999999997,-0x8b*-0x3b+0x4*0x5a3+-0x3643+0.6358139999999963),_0xbe376['bezierCurv'+_0x2726b(0x4ba)](0x202e*0x1+0x13d7+0x80*-0x68+0.5703550000000002,0x8b5+-0xcf*-0x1b+0xf1c*-0x2+0.01167100000000687,0x185*0x6+0x1a18+0x333*-0xb+0.7955139999999998,0xa1*-0x2e+-0xeb9+-0x218*-0x15+0.4086989999999986,0x1cac+-0x1*-0x207d+-0x1a7*0x25+0.20400699999999983,0x2f2+0x1*0x2703+0x7*-0x5f3+0.9383040000000022),_0xbe376[_0x2726b(0xc1)](0x1*0x23c5+0x2466+0x3*-0x17f7+0.9113540000000029,0x3e8+-0x138a+0xfa8*0x1+0.490869),_0xbe376[_0x2726b(0x189)+_0x2726b(0x4ba)](0x16*-0xe9+-0x1e92+-0x5a7*-0x9+0.46497700000000464,0x1*-0x266e+-0x1e*0xac+-0x1*-0x3a9b+0.8549439999999997,0x2*0x11cf+-0xd*0x29c+-0xb5*0x2+0.2931439999999981,-0x9*-0x3b1+-0x24cc*0x1+0x398+0.5308809999999999,-0x1*0x1288+-0xaa*0x2d+0x30b3+0.12925500000000056,-0xa3d+0x48b+0x5b7+0.6230010000000004),_0xbe376[_0x2726b(0x189)+_0x2726b(0x4ba)](-0x1*0x2e7+0x19d5+-0x16a5+0.965366000000003,-0x2e7*0x7+0x1248+0x20e+0.7151209999999999,-0x16a5+0x63*-0x17+0x7*0x48c+0.7038670000000025,-0x9*0x10b+0x1759+-0xdf0*0x1+0.2117950000000004,-0xfd5+0x15e+0xec2+0.10702399999999557,0x12d8*-0x1+-0x2*0x1373+0x1*0x39c4+0.9531359999999998),_0xbe376[_0x2726b(0x3a8)](),_0xbe376[_0x2726b(0x268)](),_0xbe376[_0x2726b(0x363)]=-0x2*0x8eb+0x2*-0xc2e+0x1eb*0x16+0.200081,_0xbe376['fillStyle']=_0x4e798d,_0xbe376[_0x2726b(0x5bd)](0xa04*0x2+0x246c+-0x384f+0.33090500000000134,0x910+-0x51f+-0x3a6+0.8989640000000065),_0xbe376[_0x2726b(0x189)+_0x2726b(0x4ba)](0x1*0x24c9+-0x112f*-0x1+-0x35c8+0.2879440000000031,-0x13dc*0x1+-0x71*-0xf+-0x1*-0xd73+0.4730640000000008,-0x22ad+-0x5f0+0x28d8+0.22737399999999752,0x169e+-0x1c01*0x1+-0x1*-0x583+0.8880229999999969,0xce9+0x3*-0xad5+0x13dc+0.14919399999999428,0x1661+0x1a6e+-0x30c4+0.14384000000000086),_0xbe376['bezierCurv'+'eTo'](-0x1cb+0x1*-0x146f+0x1680+0.194461000000004,0x1409+0x1d*0x2b+-0x18dd+0.05291199999999918,-0x1a52+0x20ee+-0x656+0.1718269999999933,0x244e*0x1+0xc57+0x309b*-0x1+0.9821860000000004,-0x831+0x2*0x1339+-0x1dfb+0.08129399999999976,0x150f+0x12ab+-0x10*0x27b+0.9316630000000004),_0xbe376[_0x2726b(0xc1)](0x161a+-0x4d*-0x1+0x1621*-0x1+0.08129399999999976,0xbe1+0x3e+-0xc15*0x1+0.9316630000000004),_0xbe376[_0x2726b(0x189)+_0x2726b(0x4ba)](0x20cc+0x1*0xaae+0x14*-0x229+0.0008069999999946731,0x11*-0x9c+-0x20cc+0x2b32+0.886196,-0x1b2b+-0x947+0x24b7+0.9379210000000029,0xd6f+-0x3*0x9d7+-0x810*-0x2+0.9038760000000003,0x1e83+-0x181d+-0x3*0x20b+0.892634000000001,-0x1625+-0xa30+0x205f*0x1+0.9847029999999997),_0xbe376[_0x2726b(0x189)+_0x2726b(0x4ba)](0x25+0x15f4+-0x15e1+0.14854700000000065,-0xd15+-0x67c*0x3+0x20ac+0.14378399999999658,-0x1d*0xad+0x38d*-0x1+0x1750+0.5428050000000013,0xfdc+-0x64c+-0x955+0.45190099999999944,0x21*0x49+-0x257a+0x2*0xe17+0.07540600000000097,-0x2073+-0x24b4+0x457a+0.9090539999999976),_0xbe376['bezierCurv'+_0x2726b(0x4ba)](0x1825+-0x195c+0x14d+0.23355499999999907,0x15a6+0x1bec+-0x3132+0.3422309999999982,-0x1*-0x1c6+0x2418+-0x25cf+0.9501139999999992,0x1eee+-0x1a29*-0x1+-0x38aa+0.24020299999999395,-0x2385+-0x154f+0x38de+0.22508499999999998,-0x1*0x1bb+0x119*-0x1d+0x220a+0.6029699999999991),_0xbe376[_0x2726b(0x189)+_0x2726b(0x4ba)](0x8cb+-0x18ee+0x29*0x65+0.1697520000000008,-0x8*-0x3c4+0x257e+-0x4324+0.724222999999995,-0x1*0x1cc3+0x198d+0x340+0.20996599999999965,-0x2*0x37c+0x418+0x35a+0.7848500000000058,-0xfd8+0x5f3*0x5+-0xddd+0.34572799999999937,-0x310+-0x700+-0x47*-0x26+0.7848500000000058),_0xbe376['bezierCurv'+'eTo'](-0x13fd+-0x1889+0x2c90+0.40600099999999983,0x5e6+0x13*-0xb9+0x84f+0.790850000000006,-0xa16+-0x3dd+0xdfd+0.47644799999999954,0xdf*0x1f+0xdbf+-0x2846+0.7807499999999976,0x1*-0x1da5+0x1*-0x1343+0x30f2+0.5570690000000003,-0x74f+0x2104*0x1+-0x193b*0x1+0.7545499999999947),_0xbe376[_0x2726b(0x189)+_0x2726b(0x4ba)](0x43*0x1d+-0x1840+0x10b3+0.5821690000000004,-0x9b1+-0x13*-0x1bd+-0x1*0x16dc+0.7449500000000029,0x2451+-0x1d4+-0x2273+0.6023219999999991,0xe7b*0x1+-0xbf3*0x1+-0x20e*0x1+0.7297499999999957,0x1eb+-0x100c*-0x1+0x1*-0x11ed+0.6175289999999993,0x1*0x1b53+-0x280*-0x9+0x3159*-0x1+0.7089500000000015),_0xbe376[_0x2726b(0x189)+_0x2726b(0x4ba)](0x15d*-0x1+0x6*0x438+-0x1*0x17e0+0.10948399999999836,-0xd*-0x183+0x626+-0x1960+0.720043000000004,-0x28*-0x80+-0x15a6+-0xa*-0x2d+0.013963000000000392,-0x857+-0x74d*0x1+0x1002+0.11667799999999318,0xd*0x2bd+-0x1996+-0x2*0x4ef+0.33096499999999907,-0x5cc+-0x27*0x3+-0x4*-0x1a3+0.898854),_0xbe376[_0x2726b(0x3a8)](),_0xbe376[_0x2726b(0x416)](),_0x43c0d0[_0x2726b(0x3be)+'re'][_0x2726b(0x526)](),_0x43c0d0[_0x2726b(0x5fa)+_0x2726b(0x5ba)]=![],_0x43c0d0[_0x2726b(0x3d7)]=!![],this[_0x2726b(0x352)+_0x2726b(0x206)+_0x2726b(0x432)][_0x42d5b8]=_0x43c0d0,this['_cache_cre'+'ateDiceGra'+_0x2726b(0x432)][_0x42d5b8];},ImageManager[_0x5db7a1(0x18f)+_0x5db7a1(0x5e2)]=function(_0x574788){const _0x282f05=_0x5db7a1,_0x4a4763={'XazGh':_0x282f05(0x18a),'RmwpQ':function(_0x5dc480,_0x46f377){return _0x5dc480!==_0x46f377;},'ZzvOy':_0x282f05(0x1de),'lbWCu':_0x282f05(0x458)},_0x42c59c=_0x4a4763['XazGh'][_0x282f05(0x13e)](_0x574788);this[_0x282f05(0x352)+_0x282f05(0x206)+_0x282f05(0x224)]=this['_cache_cre'+_0x282f05(0x206)+_0x282f05(0x224)]||{};if(_0x4a4763[_0x282f05(0x39c)](this[_0x282f05(0x352)+_0x282f05(0x206)+'phic_D6'][_0x42c59c],undefined))return this[_0x282f05(0x352)+_0x282f05(0x206)+_0x282f05(0x224)][_0x42c59c];const _0xaae92c=ImageManager[_0x282f05(0x229)+_0x282f05(0x4cd)],_0x21a85e=ColorManager[_0x282f05(0x314)+'r'](_0x574788,_0xaae92c[_0x282f05(0x3a7)]),_0x14e51d=ColorManager[_0x282f05(0x314)+'r'](_0x574788,_0xaae92c[_0x282f05(0x2a5)]),_0x44c745=ColorManager['darkenColo'+'r'](_0x574788,_0xaae92c['color2']),_0xca2703=ColorManager[_0x282f05(0x314)+'r'](_0x574788,_0xaae92c[_0x282f05(0x4e9)]),_0x4249c1=new Bitmap(0xa6*0x29+0x1651+0xa5*-0x4b,0x2bd*0xd+-0x2*0x5f2+0x4f*-0x4b),_0x3e3084=_0x4249c1['_context'];return _0x3e3084[_0x282f05(0xfe)](),_0x3e3084['beginPath'](),_0x3e3084['fillStyle']=_0x14e51d,_0x3e3084[_0x282f05(0x363)]=-0x709+-0x240c+0x2b15+0.070004,_0x3e3084[_0x282f05(0x1cf)]=_0x4a4763[_0x282f05(0x172)],_0x3e3084['lineJoin']=_0x4a4763['lbWCu'],_0x3e3084[_0x282f05(0x5bd)](0x171d+0xc4*0x4+0x1*-0x1a29+0.7155690000000003,-0x20bb+-0x4e9*0x2+-0x1*-0x2a92+0.029939999999999856),_0x3e3084[_0x282f05(0xc1)](-0x3*-0x6b5+-0x1*0x1111+-0x1*0x30b+0.7724549999999999,-0xa*0x10e+-0x256e+0x2*0x183c+0.6916200000000003),_0x3e3084[_0x282f05(0xc1)](-0x9d2*-0x1+-0x6fa+-0x2c8+0.6616759999999999,-0x411*-0x4+0x8ac*0x2+-0x2110+0.8383200000000102),_0x3e3084[_0x282f05(0xc1)](-0x3*-0x577+-0x12*-0x195+-0x2c55+0.9521000000000015,-0x923+0x142d+-0x1*0xa7e+0.5239500000000135),_0x3e3084[_0x282f05(0xc1)](0x22b1+-0x19f7+0x5b*-0x17+0.4670600000000036,0x16ac+0xf0+0x35d*-0x7+0.290419),_0x3e3084['lineTo'](-0x1*0x109+-0x6*0x125+0x1ae*0x5+0.32035999999999376,0x1*-0x1247+-0x212b*0x1+0x3374+0.20059899999999997),_0x3e3084[_0x282f05(0x3a8)](),_0x3e3084['beginPath'](),_0x3e3084['fillStyle']=_0x44c745,_0x3e3084['lineWidth']=-0x386+0x1c7*-0xf+0x1*0x1e2f+0.070004,_0x3e3084['lineCap']=_0x4a4763[_0x282f05(0x172)],_0x3e3084['lineJoin']=_0x4a4763['lbWCu'],_0x3e3084[_0x282f05(0x5bd)](0x1f*-0x25+-0x2bd*0x5+0x299*0x7+0.6938620000000002,-0x86+0x79*0x3e+-0x1cc5*0x1+0.7724549999999999),_0x3e3084[_0x282f05(0xc1)](-0x290+-0x1114*0x2+0x24ca+0.5479039999999991,-0x89e+0x1de*-0x2+0xa*0x13e+0.23353300000000132),_0x3e3084['lineTo'](-0x332*-0x1+0x26e4+-0x1*0x2989+0.4670600000000036,0x1ca7+0xbec+-0x287f+0.11975999999999942),_0x3e3084[_0x282f05(0xc1)](0x2021+-0x14ca+-0xadb+0.1766499999999951,0x6a7*0x1+-0x10ae+-0xa09*-0x1+0.5149699999999999),_0x3e3084[_0x282f05(0x3a8)](),_0x3e3084[_0x282f05(0x268)](),_0x3e3084[_0x282f05(0x5db)]=_0xca2703,_0x3e3084[_0x282f05(0x363)]=-0x1f8b*0x1+-0x1a0f+-0x1ccd*-0x2+0.070004,_0x3e3084[_0x282f05(0x1cf)]=_0x4a4763[_0x282f05(0x172)],_0x3e3084['lineJoin']=_0x4a4763[_0x282f05(0x219)],_0x3e3084[_0x282f05(0x5bd)](0x15b2*0x1+-0x8da+-0xcc8+0.9760479999999987,0x88f*-0x1+-0x86a+0x110a+0.919160999999999),_0x3e3084[_0x282f05(0xc1)](-0xace+-0x349*-0x9+-0x12b2+0.565494000000001,0x2dc+0x21eb+-0x243c+0.10928999999998723),_0x3e3084[_0x282f05(0xc1)](0x12ad+-0x2416+-0x397*-0x5+0.9521000000000015,-0x48*0x26+0x116+0xa25+0.8952099999999916),_0x3e3084[_0x282f05(0xc1)](-0xed*-0x7+0x228*-0xe+0x183f+0.20545999999998799,-0x1*-0xf3e+0x3*-0xb1b+-0x1224*-0x1+0.29041799999999895),_0x3e3084[_0x282f05(0x3a8)](),_0x3e3084[_0x282f05(0x268)](),_0x3e3084[_0x282f05(0x5db)]=_0x21a85e,_0x3e3084[_0x282f05(0x363)]=-0x9e1+-0x2b*0x1d+-0x1d8*-0x8+0.236709,_0x3e3084['moveTo'](-0x1bcf+-0x1f2d+0x3b0a+0.17333099999999924,0x247c+0x1005+0x1151*-0x3+0.030730000000005475),_0x3e3084[_0x282f05(0x189)+_0x282f05(0x4ba)](0xa9*-0xd+-0x1124+-0x1e*-0xdc+0.5683299999999996,0x1*0x2383+-0x2046+-0x2ae+0.31964999999999577,-0x2*-0x1089+0x85*-0x2f+-0x1*0x895+0.1973489999999991,-0x3*-0xc5+0x2150*0x1+-0x703*0x5+0.008849999999995362,0x20b*0x4+0x918*0x2+-0x1a48+0.16464699999999866,-0xa13*-0x2+-0xf1*-0x7+-0x45d*0x6+0.9998999999999967),_0x3e3084['bezierCurv'+_0x282f05(0x4ba)](-0x16ea+0x1017+0x70b+0.8219309999999993,-0x377*-0xb+0x172f*0x1+-0xd5*0x49+0.9163599999999974,0x2e6*-0x8+-0x78d*-0x2+0x873+0.48517900000000225,-0x1b1*0x8+-0x1271*0x1+0x2088+0.9133600000000115,-0x1*0x265e+-0x1179+0xb45*0x5+0.15439000000000647,0xbc4+0xe12*-0x1+0x2dd*0x1+0.9909000000000106),_0x3e3084[_0x282f05(0x189)+_0x282f05(0x4ba)](-0xea8+0x41f+0x13*0x95+0.28570300000001225,0x1103*-0x1+0x21*0xf7+-0xe44+0.0028330000000096334,-0x1c99*0x1+-0xa*0x1cc+0x2f1a+0.07866699999999582,-0x266d+-0x1*-0x1f31+0x7*0x11d+0.6865730000000099,-0x10fc+0x1ef3+0x7*-0x1eb+0.5332799999999907,0x1c6*-0x1+-0x2402+0x2657+0.04212000000001126),_0x3e3084[_0x282f05(0x189)+_0x282f05(0x4ba)](0x1c*-0xda+-0x16dc+0x2*0x17a1+0.852390000000014,-0x20f1+-0x2605+-0x1*-0x4783+0.12649999999999295,-0x1af2*0x1+0x1ce6+-0x165+0.9970000000000141,0x1220+0x2179+0x662*-0x8+0.2866300000000024,-0xcb4+-0x5*-0x3df+0x104*-0x6+0.9970000000000141,0x2108+-0x682+0x1*-0x1a02+0.5069300000000112),_0x3e3084[_0x282f05(0x189)+'eTo'](-0x118c+0x1131+-0xeb*-0x1+0.002999999999985903,-0x1ace+-0x734+-0x1*-0x2260+0.6750849999999957,-0x96*0x24+-0x1763*-0x1+0x1*-0x1bb,-0x1*0x204d+-0x110a+0x318f+0.8402570000000011,-0x1ff6+-0x18f1+-0x1cbb*-0x2+0.9879999999999995,-0xa2d+-0x11f1+0x1c31+0.00244599999999906),_0x3e3084[_0x282f05(0x189)+_0x282f05(0x4ba)](-0x176f+-0x3ce+-0x4a2*-0x6+0.9879999999999995,0xb1*-0xf+-0x1d9f+-0x2*-0x1407+0.7468579999999996,0x1473+-0x14*-0x1f3+-0x3ae1*0x1+0.3515700000000095,-0x143b*-0x1+0x8fb+-0x1d28+0.4912679999999998,-0x120d+0xc6+0x11d3+0.5809999999999889,0xab3+0x59*0x7+-0xd16+0.7100670000000004),_0x3e3084['bezierCurv'+'eTo'](0x1*-0x1da7+0x2247+-0x417+0.23673299999998676,0x35b*0xa+0x2044+-0x41c9*0x1+0.33861600000000003,0x10*-0x21a+-0xb*0x179+-0x8*-0x64b+0.7910530000000051,-0x1fad+0x1d58*0x1+0x25a+0.8836259999999996,0x1598+-0x23a9+0xe93+0.24395999999998708,0x8*-0x2bd+-0x20a+-0x17f4*-0x1+0.34509599999999985),_0x3e3084['bezierCurv'+_0x282f05(0x4ba)](0x242e*0x1+0x1bd2+-0x3f80+0.3034800000000075,-0x384+-0xb*0x1+0x1*0x38f+0.411734,-0xb4+0xceb*0x1+0x1*-0xbb9+0.01426999999999623,0x368*0x7+-0xd21*-0x1+-0x5*0x765,-0x17a7+0xd*-0x179+0xe6d*0x3+0.0990900000000039,-0x2b0*0xe+-0x4*0x86d+0x67c*0xb),_0x3e3084[_0x282f05(0x189)+_0x282f05(0x4ba)](0x211c+-0x256f+-0x12a*-0x4+0.9470019999999977,0xaa9*-0x2+0x267+0x12eb*0x1+0.005867,-0xf31+-0x8fc+-0x21*-0xbd+0.7919330000000002,0x3*-0xa12+0x545*-0x5+-0x1*-0x388f+0.005867,-0x7c7+-0x114b+0x191d+0.6338830000000009,0x1*0x1a51+0x1fb3+-0xbc*0x4f),_0x3e3084[_0x282f05(0x189)+_0x282f05(0x4ba)](-0x1f1*0x6+0x105c+-0x4ae+0.5815909999999995,-0x73b+0x25ad+0x513*-0x6,0x1fb5+-0x149+-0x1e66+0.2983330000000004,-0x24ce+0x7*-0x58f+0x5b*0xd5+0.402783,0x419*-0x1+-0x255b+0x8*0x52f+0.7841069999999997,0x2a2*0x7+0xee*-0x1f+-0x377*-0x3+0.20835000000000004),_0x3e3084['bezierCurv'+'eTo'](0xda8+-0x267f+0x18d8+0.5947020000000001,-0x5c1+-0x1b*0x97+0x2*0xad8+0.9030269999999998,-0x1*-0x2610+0x1ab*0xb+-0x3869,-0x1ad*-0x17+0x26e3+0xb0f*-0x7+0.7762190000000002,0x2a4*-0x5+0x4a*0x86+-0x1988,-0x2c9*-0xe+-0x48d+-0x2268+0.8279259999999997),_0x3e3084['bezierCurv'+'eTo'](0x184a+0x1*0x20f+-0x1a59+0.0178,0xf92+-0x1bb4+0xc52+0.3161569999999969,0x511*-0x7+0x20fa+0x27d+0.029733,0xf3+-0xa15+-0x25e*-0x4+0.8043890000000005,-0x1d3b+0xf*-0x16d+0x329e+0.0358,0x1213+0x3*0x53b+-0x2147+0.29261999999999944),_0x3e3084[_0x282f05(0x189)+'eTo'](-0x1d97+-0x237b+-0x2089*-0x2+0.0358,-0x26b3*-0x1+-0x5*0x670+-0x605+0.7545729999999935,-0x1*-0x21b3+0x1cf4+0x2b*-0x175+0.631946,-0x1*-0x1b9d+0xbcf*0x2+-0x5a3*0x9+0.2135499999999979,0x3*-0x19b+-0x806+0xcd8+0.8242389999999999,0xd6*-0xe+-0x11b+-0x6*-0x238+0.6695499999999868),_0x3e3084[_0x282f05(0x189)+_0x282f05(0x4ba)](-0x1da3+-0x10f5+-0x97*-0x4f+0.860039,-0x1*-0x236+0x36b+-0x2*0x290+0.7173500000000104,-0x5*-0x5c5+0x1c6a+-0x1*0x3941+0.9241679999999999,-0x2524+0x1e26+0x80*0xf+0.8123229999999921,0x3b*-0x17+-0x49d*-0x1+0xb5+0.016626999999999725,-0x24d6+-0xc9*0x11+-0x32b3*-0x1+0.9544699999999864),_0x3e3084[_0x282f05(0x189)+_0x282f05(0x4ba)](-0x1703+0x1ac5+-0x3b9+0.14198400000000078,-0xaed+-0xcb8+0x182e+0.1732629999999915,-0x1d47+-0x6af*-0x1+0x16a4+0.19427600000000034,-0xd1a+0x14c*-0x1+0xef2*0x1+0.19861700000001292,-0x1448+-0x1e0f+0x3265+0.1735009999999999,0x1ef7+-0x12*-0xa9+0x191*-0x1b+0.030529999999998836),_0x3e3084['moveTo'](-0xddb*-0x1+-0xd*-0x25b+0x5*-0x8e4+0.8675160000000002,0x1f50+-0xd5*-0x24+0x1*-0x3cc7+0.024299999999996658),_0x3e3084[_0x282f05(0x189)+'eTo'](-0x2074+0x1*0xe6b+0x120f+0.7495469999999997,0xc11*0x2+0xa7b+-0x2221+0.7526929999999936,0x1714+-0x22a9+0xb9b+0.688663,0x7*-0x1e9+0x1874+0x1*-0xa99+0.4571550000000002,-0x1*-0x58d+0x2*-0x1381+0x3*0xb29+0.6886559999999999,0x8*-0xef+0x990+0x67*-0x4+0.15609000000000606),_0x3e3084[_0x282f05(0xc1)](0x10f*-0x23+0x1a00*0x1+0xb13+0.7153559999999999,0xf65*-0x2+0x14bd+0x7*0x171+0.06979499999999916),_0x3e3084[_0x282f05(0x189)+'eTo'](-0xb*0x1c9+0x14de*-0x1+0x2887+0.7153559999999999,-0x1b3+-0x25*-0xec+0x67a*-0x5+0.6709940000000003,-0x1441+-0x1842+0x1645*0x2+0.9136189999999997,-0x247a+-0x1b54+0x3fd4+0.4715930000000004,-0x1573+-0x1fe1*-0x1+0x214*-0x5+0.3101439999999993,-0x9c5+-0x9c9*-0x2+-0x9c7+0.4715930000000004),_0x3e3084['lineTo'](-0x3*0x403+0xbb7+0xcd+0.8590399999999931,0x1b77+0xe32+-0x11*0x273+0.4715930000000004),_0x3e3084[_0x282f05(0x189)+_0x282f05(0x4ba)](-0xae4+-0x1fde+0x2b3e+0.6097639999999984,-0x13*0x23+-0x1b1*-0xb+-0x6*0x2aa+0.47153699999999965,0x13*-0x1c1+-0x1726+0x38f6+0.33282300000000475,0x21a0+-0xb92+-0x582*0x4+0.7706860000000004,0xcd8+0x64c+0x5*-0x3bb+0.8710499999999968,-0x5d*0x65+-0x1629+0x1*0x3ae1+0.30401399999999956),_0x3e3084['lineTo'](0x621*0x6+-0x2*-0x69b+-0x107c*0x3+0.7090599999999938,0x1c68+0x1b89+-0x1*0x37df+0.14337400000000144),_0x3e3084['bezierCurv'+'eTo'](-0x1*-0x2187+-0x6f1+-0x1b*0xf7+0.10847999999998592,-0xada+-0x1431+0x1f1d+0.5431750000000015,0x5*-0x105+0x1b34+-0x1592+0.3081899999999962,0x1499+-0x1bd4+0x74e+0.023531999999999442,0x189c+-0xebc+-0x31d*0x3+0.3081899999999962,-0x807+0x23d*-0x11+-0x1*-0x2e27+0.5844459999999998),_0x3e3084[_0x282f05(0xc1)](-0x11+0x683*-0x5+0x2129+0.29919000000001006,-0x17cc+-0xd82+0x25d4+0.46735000000001037),_0x3e3084['bezierCurv'+_0x282f05(0x4ba)](0x1f3a+0x6*-0x5c1+0x3d5+0.2991890000000126,0x1*-0x1b37+-0x912+0x24d1+0.11843200000001275,0x1*-0x10b1+-0xcde+0x1e16+0.9619940000000042,-0x10d1+0x1*-0x35c+0xb*0x1e2+0.45689799999999536,0xbce*0x1+-0x27*-0xbd+-0x1*0x2813+0.31247999999999365,0x279*0xb+-0x1f3d+0x493+0.4568999999999903),_0x3e3084[_0x282f05(0x189)+_0x282f05(0x4ba)](0x125d*-0x1+0xa56+0x864*0x1+0.8994490000000042,-0x92+0x1be2+0x3*-0x8ed+0.4688329999999894,0xa6d*-0x2+0x1be9+-0x6d8+0.9962080000000029,0x387+0x1f79+-0x2277+0.4688329999999894,0x55*-0x1+-0x24b*-0x10+0xfb*-0x25+0.6027570000000004,-0xad7+-0x17e1+-0x13*-0x1db+0.4568999999999903),_0x3e3084[_0x282f05(0x189)+'eTo'](0x14cd+-0x19*-0x89+0x221b*-0x1+0.5118040000000015,0x12*0xaa+0x13f4+0x1f5f*-0x1+0.4568999999999903,0xf8*-0x28+-0x85f+0x2f31+0.5937349999999988,0xaec+0x155f*0x1+-0x1fc2+0.08693299999998771,-0x204e*0x1+-0x61c+-0x267b*-0x1+0.8485489999999984,0x796+0x944+-0x1052+0.3470000000000084),_0x3e3084[_0x282f05(0x189)+_0x282f05(0x4ba)](-0x168d+0x24b1+-0x70b*0x2+0.45049099999999953,0x3a*0x3e+-0xe49+0xc1+0.96958699999999,-0xd32+-0x888+0x15c5+0.05541299999999971,0x17*-0x18b+0xc06+0x17f8+0.580237000000011,0x7*0x222+-0x234d+0x175*0xe+0.6633149999999999,0x3*0x347+-0x10aa+0x753+0.1789500000000004),_0x3e3084[_0x282f05(0x189)+_0x282f05(0x4ba)](0x24a8+0x2f*0x8+0x3*-0xcb3+0.31158899999999967,0x3*-0x67d+0x13eb+0x9+0.8268829999999951,0x21af+-0x5*-0xbd+-0x2559+0.04630199999999984,0x7*0x243+-0x1756+0x7fe+0.44199999999999307,-0x3*-0xa1a+-0x1*-0xb5+-0x1efd+0.8674559999999998,-0x1429*0x1+-0x665+0x1b0b+0.024299999999996658),_0x3e3084[_0x282f05(0x3a8)](),_0x3e3084[_0x282f05(0x268)](),_0x3e3084['fillStyle']=_0x21a85e,_0x3e3084[_0x282f05(0x363)]=0x3*-0x8e2+-0x7e*-0x31+-0x6*-0x6c+0.236709,_0x3e3084[_0x282f05(0x5bd)](0x1*-0x1f22+0x1f0c+0x97*0x1+0.27808999999999173,0x1873+0x38*0xa3+-0x3c0a+0.3377669999999995),_0x3e3084[_0x282f05(0x189)+_0x282f05(0x4ba)](0x263c+-0xd3*0x29+-0x35*0x13+0.16635700000000497,0x6ad*0x3+-0x3*-0xa59+-0xb*0x4a3+0.27214000000000027,0xfcb*-0x1+-0x3*0xa39+0x1e1*0x19+0.05462299999999232,0x7*0x10f+0x1b*0x13+-0x959*0x1+0.3258499999999991,-0x92f*0x3+0x7*-0x2c1+0x2f57+0.9428900000000056,-0x120b+-0xad*0x1f+0x270f+0.4988969999999995),_0x3e3084[_0x282f05(0x189)+_0x282f05(0x4ba)](-0x225c+0x1171+0x116f+0.04423700000000963,-0x14f9+0xecf*-0x1+0x3*0xbf3+0.5167099999999998,0x1dd3+0x1ad+-0x4*0x7bf+0.1098130000000026,-0x80*-0x22+-0x1d78+-0xc89*-0x1+0.4988039999999998,0x138+0x1c8f+-0x1d43+0.13962000000000785,-0x1f15*0x1+0x3be+0x6da*0x4+0.44517700000000104),_0x3e3084[_0x282f05(0x189)+'eTo'](0x2241+-0x1*-0x81a+-0x29d7*0x1+0.15155300000000693,0x1ab0+0x543+-0x1fe2+0.42736400000000074,-0xf6f+-0x7a7*0x1+0x72*0x35+0.1575200000000052,0x225d+-0x158f+0x3*-0x43f+0.4064799999999984,-0x529+-0x116e+-0xd*-0x1c7+0.1575200000000052,0x3b3*0x1+-0x188f*0x1+0x14ed+0.3825269999999996),_0x3e3084[_0x282f05(0x189)+_0x282f05(0x4ba)](0x180a+-0x1eac+-0x1*-0x726+0.1575200000000052,-0x679+0x1*0x13e3+0xc9*-0x11+0.3347799999999985,-0xd73+0x112d+-0x3*0x112+0.1277200000000107,-0x3*0x5bb+-0x1a0f*-0x1+-0x8cd+0.31090700000000027,-0x205*-0xa+-0x7*0x38e+-0x25*-0x24+0.0681199999999933,-0x81e+0x1642+-0x1*0xe13+0.31090700000000027),_0x3e3084[_0x282f05(0x189)+_0x282f05(0x4ba)](-0x12a9+0x1*0x89f+0xa69+0.649281000000002,-0x1*0x1c6+0xb7b+-0x1*0x9a5+0.606781999999999,-0x5ce+-0x13b7+0x19bf+0.029210999999996545,-0x25e0+0x277*0x8+0x1*0x1237+0.950393,0x228a+0x147*-0x3+-0x1ea2+0.20790799999999976,-0x39e*-0xa+-0x22ef+-0x12e+0.341742),_0x3e3084['bezierCurv'+_0x282f05(0x4ba)](-0x2403+0xc27+0x17ee+0.5104089999999992,0x5e2*-0x3+0x17*-0xf1+-0x1ca*-0x16+0.3297889999999999,0x1908+0x17d*0xe+-0x929*0x5+0.8784889999999983,-0x1*0xdfd+-0x1*-0x2a9+-0x35*-0x37+0.11795399999999923,0x6*0x181+-0x2*0x7cd+0x1*0x6a5+0.31214900000000156,0x195b+0x1f4c*0x1+-0x3899+0.7062390000000001),_0x3e3084[_0x282f05(0xc1)](0x7be+0x2136+-0x28eb+0.21046399999999998,-0xb44+-0x20e6+0x2*0x1619+0.7539890000000007),_0x3e3084['bezierCurv'+'eTo'](-0x169*-0x1b+0x1*-0x1ad7+-0xb33+0.10635199999999934,-0x23*-0x6e+0x4*-0x481+0x302+0.6803260000000009,0x17*-0x44+0xb01+-0x4dd+0.9641889999999993,-0xa76*-0x2+0x409*0x1+-0x84f*0x3+0.6933419999999995,0x8*0x2c2+0x3f*0x11+-0x1a37+0.8751560000000005,0x3*0x3e1+0xc53+-0x17ee+0.7846879999999992),_0x3e3084[_0x282f05(0x189)+_0x282f05(0x4ba)](0x11bb+0xe3d+-0x1ff0+0.7861220000000007,-0x1*0xb5d+-0x17e+-0xce3*-0x1+0.8760340000000006,0x97*0xb+0xb7b*-0x1+0x506+0.7766330000000004,-0x26ac+-0x1ce5+0x439a+0.01861000000000068,0x1a4e+-0x8*-0x3fd+-0x3a2e+0.8527749999999994,-0x6da*0x2+-0x1*0x9b+0xe58+0.1209699999999998),_0x3e3084[_0x282f05(0xc1)](0xf0f+-0x6f*-0x4a+-0x2f16+0.12129099999999937,0x63f+-0x1f2d+0x18ff+0.6778900000000014),_0x3e3084[_0x282f05(0x189)+'eTo'](-0x1f0a+0x223a+-0x3*0x10b+0.29417699999999947,0xc9+0x21c8+0x2*-0x1140+0.922543000000001,0x242d+-0x1376+-0x42a*0x4+0.3835929999999994,-0x1a0*0x3+-0x11dd+0x16cf+0.1970320000000001,-0xebe*-0x1+0x3*0x1d1+0x1*-0x1422+0.3895400000000002,-0xca+-0x1*0x4e4+0x5c0+0.5013569999999987),_0x3e3084[_0x282f05(0x189)+_0x282f05(0x4ba)](-0x236e+0x8*0x328+0x1*0xa3d+0.9022330000000007,0x1607+0x66d+0xb*-0x292+0.505277999999997,0x329*0xb+-0x424+0x1*-0x1e8f+0.4149230000000017,0x259*-0x7+0x1ab+0x52*0x2f+0.7896530000000013,-0x24ff+-0xa09*-0x1+-0x902*-0x3+0.9276090000000003,-0x1ce7+-0x1535*0x1+0x3283+0.35447999999999524),_0x3e3084[_0x282f05(0x189)+_0x282f05(0x4ba)](0x3cc+0x85*-0x4+-0x1a7*0x1+0.05279600000000073,0xa4e+0x17b*0x3+-0xe51+0.5329870000000057,0x62b+0x66*-0x3d+-0xa*-0x1d2+0.20183600000000013,0x5c3+0x1e29+-0x2376+0.08145299999999622,0xaff+-0x19cf*0x1+0xee1*0x1+0.37472899999999854,0x12ce+-0x55f+-0xcf2+0.9998800000000045),_0x3e3084[_0x282f05(0x189)+_0x282f05(0x4ba)](-0x12*-0x1af+-0x17f0+-0x64d*0x1+0.38072899999999876,0x7bb+-0x1*0xb23+0x3e6+0.07747299999999768,0x1be7+-0xf48+-0xc8e+0.4224560000000004,0x1*-0x1fc9+0x712*0x3+0xb11*0x1+0.1162700000000001,-0x2095*0x1+0x14e7+0xbbf+0.4999089999999988,-0x172e+-0x59*-0x55+-0x5e1+0.1162700000000001),_0x3e3084[_0x282f05(0xc1)](-0x74*-0x1f+-0x1581+0x786+0.4999089999999988,0x2697+-0x1635+-0xfe4+0.1162700000000001),_0x3e3084['bezierCurv'+'eTo'](0x2*-0xe1d+-0xd8c+0x29d7+0.5774159999999995,0x8fa+0x1f7*0x12+0x2*-0x15ed+0.11026999999999987,-0x65*-0x24+0x1b2f+-0x2952+0.6161689999999993,-0x2*-0xf3a+0x21d7*0x1+-0x3fcd*0x1+0.07147299999999746,0x1*0x1d6f+-0x1*-0x1ae3+-0x3841+0.6161689999999993,0x1a2d+-0x469*-0x1+0x14f*-0x17+0.9998800000000045),_0x3e3084['bezierCurv'+'eTo'](0x3ad*0x8+0x24d3*-0x1+0x4*0x1df+0.5625689999999999,0x2322+-0x7*0x349+-0x3*0x3e3+0.8760699999999986,0xdf5+0x5*-0x188+-0x63c+0.8933789999999995,-0x268a+-0x1e6e+0x456f+0.3852799999999945,-0x1ba1+0x1820+-0x1c9*-0x2+0.9291389999999993,-0x1*0x13eb+-0x2dd*-0x1+0x1182+0.7000500000000045),_0x3e3084[_0x282f05(0x189)+_0x282f05(0x4ba)](0xae9+-0x22b9+-0x6*-0x3fb+0.38817200000000085,-0xb*-0x114+-0x7ec+-0x39c+0.5429850000000016,0x1f46+0xeea*0x2+-0x3d08+0.9306680000000007,-0x1b10+-0xda1+-0x1d*-0x169+0.3680179999999993,0xb*0x1d7+-0x18ec+0xae*0x7+0.5566279999999999,0x6*-0x427+-0xd6f+0xccf*0x3+0.17514800000000008),_0x3e3084['bezierCurv'+_0x282f05(0x4ba)](0x1062+0x5*0x6d1+-0x3264+0.568560999999999,-0x2c*-0x97+-0xd*-0x93+-0x2158+0.6858409999999999,-0x1fe0+-0xe5f*0x1+0x2e52+0.8189439999999983,-0x2357+0x4*-0x4d5+0x36be+0.4382039999999989,0x2ab*-0xd+-0x1*-0x997+0x192c*0x1+0.3077770000000015,0xc72+0x1c03+0x2862*-0x1+0.4322359999999996),_0x3e3084[_0x282f05(0x189)+_0x282f05(0x4ba)](-0x28*0x7f+-0xc1*0x7+0xd*0x1f3+0.2973750000000024,-0x1efb+0xb*0x254+0x571+0.9429289999999995,0x38*-0x6f+-0x5*-0x192+0x10ca+0.009759000000002516,-0x2*0xde7+0x1*-0x246a+-0x1a*-0x279+0.2865409999999997,0x1*0x17bc+-0x15a0+-0x19d+0.4449299999999994,-0x3*0x5ad+0x1f*0x77+0x2af+0.46307200000000037),_0x3e3084[_0x282f05(0x189)+_0x282f05(0x4ba)](0x68a+0x1bef+-0x21fa+0.48066300000000695,-0x11*0x3f+0x1*0x1c2b+-0x17eb+0.46307200000000037,0x22ad+-0x34c+0x1*-0x1ee1+0.09172000000000935,0x1*0x6f1+0x6ba+-0xd9a+0.42130399999999923,0xbdf+-0x62a+0x29a*-0x2+0.2780999999999949,-0xb50+0x18ef*-0x1+0x2450+0.3377669999999995),_0x3e3084[_0x282f05(0x3a8)](),_0x3e3084[_0x282f05(0x416)](),_0x4249c1['_baseTextu'+'re'][_0x282f05(0x526)](),_0x4249c1[_0x282f05(0x5fa)+_0x282f05(0x5ba)]=![],_0x4249c1[_0x282f05(0x3d7)]=!![],this[_0x282f05(0x352)+_0x282f05(0x206)+_0x282f05(0x224)][_0x42c59c]=_0x4249c1,this[_0x282f05(0x352)+_0x282f05(0x206)+_0x282f05(0x224)][_0x42c59c];},ImageManager['createDice'+'Graphic_D8']=function(_0xab08ff){const _0x17e5e6=_0x5db7a1,_0x6834f={'sjtlD':_0x17e5e6(0x18a),'yXXhA':function(_0x38337d,_0x26ae68){return _0x38337d!==_0x26ae68;},'ENuPF':_0x17e5e6(0x1de),'GNhEF':_0x17e5e6(0x458)},_0x4a3612=_0x6834f['sjtlD'][_0x17e5e6(0x13e)](_0xab08ff);this[_0x17e5e6(0x352)+_0x17e5e6(0x206)+_0x17e5e6(0x1c5)]=this[_0x17e5e6(0x352)+_0x17e5e6(0x206)+_0x17e5e6(0x1c5)]||{};if(_0x6834f[_0x17e5e6(0x1a3)](this[_0x17e5e6(0x352)+_0x17e5e6(0x206)+_0x17e5e6(0x1c5)][_0x4a3612],undefined))return this['_cache_cre'+_0x17e5e6(0x206)+'phic_D8'][_0x4a3612];const _0x214f66=ImageManager[_0x17e5e6(0x229)+_0x17e5e6(0x4cd)],_0x5e95fe=ColorManager['darkenColo'+'r'](_0xab08ff,_0x214f66[_0x17e5e6(0x3a7)]),_0x46c564=ColorManager[_0x17e5e6(0x314)+'r'](_0xab08ff,_0x214f66[_0x17e5e6(0x2a5)]),_0x4ff5a8=ColorManager['darkenColo'+'r'](_0xab08ff,_0x214f66['color2']),_0xf09f2a=ColorManager[_0x17e5e6(0x314)+'r'](_0xab08ff,_0x214f66[_0x17e5e6(0x4e9)]),_0x4390a6=new Bitmap(0x1*0x1471+0x25c6+0x3d9*-0xf,-0x34e+-0x50f+0x8ed),_0x4e5cfb=_0x4390a6[_0x17e5e6(0x256)];return _0x4e5cfb[_0x17e5e6(0xfe)](),_0x4e5cfb['beginPath'](),_0x4e5cfb['fillStyle']=_0x46c564,_0x4e5cfb[_0x17e5e6(0x363)]=-0x28b+0x4d1*-0x7+-0x2442*-0x1+0.070004,_0x4e5cfb[_0x17e5e6(0x1cf)]=_0x6834f[_0x17e5e6(0x2a4)],_0x4e5cfb[_0x17e5e6(0x4a0)]=_0x6834f['GNhEF'],_0x4e5cfb[_0x17e5e6(0x5bd)](0x19f*0x1+0x221f+-0x237f+0.7983910000000023,0x1a*0x1d+-0x1008+-0x4*-0x346+0.667529),_0x4e5cfb[_0x17e5e6(0xc1)](0x219d*-0x1+-0x19df+0x3b7e+0.4452349999999998,-0x7*0x28+-0x2549+-0x1*-0x2697+0.01745199999999869),_0x4e5cfb[_0x17e5e6(0xc1)](0x10d2+-0x1*-0x11c2+-0x3*0xb86+0.8898229999999998,0xca7*0x1+-0x9d9+-0x1*0x264+0.9234399999999994),_0x4e5cfb[_0x17e5e6(0xc1)](-0x3*-0xb27+0x1*0x1999+-0xbc3*0x5+0.5760959999999997,-0x1*-0x1de+0x1b11+-0x1c61+0.4904799999999909),_0x4e5cfb[_0x17e5e6(0xc1)](0x2*0xf2f+-0x1*0x209f+0x2bd+0.040080000000003224,0x62*0x49+0x343*0x8+0xd68*-0x4+0.9234399999999994),_0x4e5cfb[_0x17e5e6(0xc1)](0x2694+0x1*0x21f5+0x253*-0x1f+0.9292499999999961,0x2*-0xe0+0x2635+-0x2441+0.6836899999999986),_0x4e5cfb[_0x17e5e6(0x3a8)](),_0x4e5cfb[_0x17e5e6(0x268)](),_0x4e5cfb[_0x17e5e6(0x5db)]=_0x4ff5a8,_0x4e5cfb['lineWidth']=0x1d9f+-0xe20+-0x1*0xf7f+0.070004,_0x4e5cfb['lineCap']=_0x6834f[_0x17e5e6(0x2a4)],_0x4e5cfb['lineJoin']=_0x6834f[_0x17e5e6(0x3b6)],_0x4e5cfb[_0x17e5e6(0x5bd)](0x8d+0x16f*0x11+-0x18ae+0.02003899999999703,0x7*-0x25a+-0x4f5*0x4+0x194*0x17+0.8898229999999998),_0x4e5cfb[_0x17e5e6(0xc1)](-0x53*-0x4a+0xdf5+-0x1*0x25f1+0.667529,-0x1*-0x24e1+0x1a7b+-0x4*0xfca+0.9059820000000016),_0x4e5cfb['lineTo'](-0x87b+0x7bf+0xbe+0.3936099999999998,0x2216+-0x20c3*0x1+-0xe8+0.04247999999999763),_0x4e5cfb['lineTo'](0x1244+0xd8b+-0xd3*0x26+0.465919999999997,0x1b01+0x777+-0x220d+0.028999999999996362),_0x4e5cfb[_0x17e5e6(0xc1)](0x203*0x5+0x1*-0x9bb+0x1*0x27+0.8177799999999991,0x25d8+0xf99+-0x353b+0.23974700000000126),_0x4e5cfb[_0x17e5e6(0x3a8)](),_0x4e5cfb['beginPath'](),_0x4e5cfb[_0x17e5e6(0x5db)]=_0xf09f2a,_0x4e5cfb[_0x17e5e6(0x363)]=-0x83*-0x26+0x1f*0x47+0x3*-0x959+0.070004,_0x4e5cfb['lineCap']=_0x6834f['ENuPF'],_0x4e5cfb[_0x17e5e6(0x4a0)]=_0x6834f[_0x17e5e6(0x3b6)],_0x4e5cfb[_0x17e5e6(0x5bd)](-0xbf*0x2f+-0xb0*0x21+0x74*0x80+0.5171530000000004,-0x27*0x44+-0x2115+0x2b76+0.07972999999999963),_0x4e5cfb[_0x17e5e6(0xc1)](0x1*-0x1f85+0x18a5+0x6e4+0.821002,-0x21af*0x1+-0x2219*0x1+-0x1*-0x4433+0.09015999999999735),_0x4e5cfb[_0x17e5e6(0xc1)](0x594+-0x67*-0x53+0x5*-0x7b3+0.09753000000000611,-0x21e1+-0x650+0x289c+0.08341000000000065),_0x4e5cfb['fill'](),_0x4e5cfb['beginPath'](),_0x4e5cfb[_0x17e5e6(0x363)]=0xc*-0x4c+-0x1afd+-0x1e8d*-0x1+0.171967,_0x4e5cfb['fillStyle']=_0x5e95fe,_0x4e5cfb[_0x17e5e6(0x5bd)](0xabc+-0x1*-0x13cd+-0x1e52+0.3209450000000018,-0x5f*0x4c+0xe12+0xeae*0x1+0.39891000000000076),_0x4e5cfb[_0x17e5e6(0x189)+_0x17e5e6(0x4ba)](0x1ee*0x1+-0x1*0x21c2+-0x1ffa*-0x1+0.24877000000000038,0x153*-0x17+-0x76*-0x35+0x689+0.5022500000000036,-0x3*0x2a3+0x138e+-0xb91+0.7779559999999996,-0xdbc+-0x8b*-0x41+-0x1*0x1517+0.3932700000000011,-0x19c1+0xaad*-0x1+0x2470+0.9085019999999999,-0x25eb+0xb7*0x2e+0x577+0.0719699999999932),_0x4e5cfb['bezierCurv'+_0x17e5e6(0x4ba)](-0x647+0x20a1*-0x1+-0x9ba*-0x4+0.744151,0xb35+-0x25e5+0x1b1c+0.8175399999999939,-0x6*0xb2+0x1853+-0x43*0x4d+0.0097,0x7e*-0x9+-0x1a12+0x1eea+0.13322999999999752,0xb8a*0x1+-0x1b*-0xef+0x1*-0x24bf+0.0032,0x247f+0x258b+0x49a3*-0x1+0.5204099999999983),_0x4e5cfb['bezierCurv'+_0x17e5e6(0x4ba)](-(0x2318+-0x25f1+0x2d9+0.001067),0x1d3c+0x17df+-0x16*0x266+0.5054949999999963,-(-0x1f55+0x1*0x3d5+0x1b80+0.001067),0x5*0x3ed+0x26a9+0x3a03*-0x1+0.4905820000000034,-0x18b5+-0x1*0x1985+-0x2*-0x191d+0.0032,-0xb*0x43+-0x224c+0x2564+0.4756709999999984),_0x4e5cfb[_0x17e5e6(0x189)+_0x17e5e6(0x4ba)](0x2*-0x12dc+0x393*-0x7+0x3ebd+0.0032,-0xd8d*-0x1+-0x1d9a+0x1042*0x1+0.5604659999999981,-0x4*0x4e1+0x6a*-0x4a+0x3228+0.869808,-0x170e+-0x10d8+0x2819+0.8575799999999987,0x590+-0x1678+0x10ea+0.6030229999999999,0x12c7+-0x1959+0x6c4+0.3670139999999975),_0x4e5cfb[_0x17e5e6(0x189)+_0x17e5e6(0x4ba)](0x1*-0xa90+-0x1eed+0x2*0x14c9+0.2784240000000011,0x85*0x25+0xe5*-0x11+0x1*-0x3e2+0.2697730000000007,-0x10c*-0x9+-0x1787*0x1+0x2*0x721+0.9971559999999968,0x2d1*-0x3+0x22ae+-0x1a29+0.13570100000000096,-0x130d*-0x1+-0x29*-0xc1+-0x31bc+0.7592169999999996,-0x269b+-0x1668+-0xf41*-0x4+0.964798),_0x4e5cfb[_0x17e5e6(0x189)+_0x17e5e6(0x4ba)](0x4c7*0x5+0x37*-0x4f+0x39*-0x1e+0.7134179999999972,0x45*-0x61+0x1d*0x1+-0x682*-0x4+0.283579,-0xb*0x17f+-0x10*0x238+0x3433+0.7564449999999994,-(-0x21*0x93+-0x11*0x184+0x2cb7+0.318713),0xb2d*0x1+-0x1f6c+0x147f+0.8882990000000035,0x10*0x255+-0x25fe+0x3a*0x3+0.157921),_0x4e5cfb[_0x17e5e6(0x189)+_0x17e5e6(0x4ba)](0x13c5+-0x195d+0x5da+0.15787699999999916,0x12c+-0xf63+0xe37+0.439568,-0x4a1+0x1e34+-0x2*0xca8+0.7697699999999941,-0x77*0xb+0x1*0x2445+-0x1f27+0.4253340000000001,-0x7*0x106+0x2103+-0x1994*0x1+0.723977000000005,-0x264c+0x232*-0x4+-0x96b*-0x5+0.11521900000000018),_0x4e5cfb[_0x17e5e6(0x189)+_0x17e5e6(0x4ba)](-0x549+-0x1e63+0xa*0x39a+0.17404399999999498,0x20a7+0x2fa+-0x238e+0.008807999999998373,-0x1a3+-0x1*0x17e9+0x19f6+0.6241179999999957,-0x19d4+-0xe*0x14c+-0x160f*-0x2+0.9023970000000006,0x3b7*0x6+0x1b50+-0x311d*0x1+0.0742000000000047,-0x1*-0x1cdf+0x2*-0x182+-0x19a9+0.7959839999999971),_0x4e5cfb[_0x17e5e6(0x189)+_0x17e5e6(0x4ba)](-0x3*-0x17b+0x1db4+-0x21a7+0.738110000000006,0x6d*0x55+-0x355*-0x7+0x49*-0xd0+0.22588900000000223,0x217c+0xce9*0x3+-0x47b8+0.20606999999999687,-0x6f*0x1+-0xf1b+0xfc0+0.611227999999997,0x244*-0x2+-0x1c13*0x1+0x26*0xdf+0.20606999999999687,0xdd*-0x29+-0x169e+0x3a3b+0.9770669999999981),_0x4e5cfb[_0x17e5e6(0x189)+_0x17e5e6(0x4ba)](0x1432+-0x1e7*-0xc+-0x39*0xbf+0.22340300000000468,0x12b8+0x37*-0xa0+-0xf*-0x110+0.615003999999999,-0x1a2d+0x1a34+0x78+0.22996999999999446,0x13c+-0x7*-0x1c5+-0xd47+0.2551109999999994,-0x31*0xa7+0x4a9*-0x1+0x251f+0.22576999999999714,0x1c3b+-0x5de+-0x15f6+0.8973900000000015),_0x4e5cfb[_0x17e5e6(0x189)+_0x17e5e6(0x4ba)](0x25a9+-0x1311*0x1+-0x1219+0.22576999999999714,-0x853+-0x14c0+0x275*0xc+0.7865900000000039,0x1df3+0x4*0x417+-0x2dd1+0.6993130000000036,0x51*0x49+-0x2e*0x71+0x4c*-0x8+0.3833130000000011,-0xf*0xd8+0xa9*0x34+-0x152f+0.6463999999999999,-0x2190+-0x6*-0x567+0x6*0x43+0.6875600000000048),_0x4e5cfb[_0x17e5e6(0x189)+_0x17e5e6(0x4ba)](0x1*0xf45+0x1*0x1946+-0x1407*0x2+0.05708699999999567,0x1*-0x153d+0x2124+-0x1a*0x71+0.41983999999999355,-0x2*0x1370+0x2451+0x2*0x185+0.7680069999999972,-0x968+0x12b3+-0x8dd+0.3601069999999993,0x2648+0x9a2+0x6c7*-0x7+0.7791600000000045,0x1a57+-0x151c+-0x4cc+0.5083599999999961),_0x4e5cfb['bezierCurv'+_0x17e5e6(0x4ba)](0x1a5b+-0x2052+0x7*0xe9+0.28668000000000404,-0x2a*-0x6f+0x2377*-0x1+0x11ba+0.5956800000000015,-0x5b*-0x8+0x405*0x9+-0x26af*0x1+0.6533749999999969,-0x1*-0x1df7+-0xd*-0x1f+-0x1f07+0.7761529999999937,-0x1c46+0x283*0x1+0x1a07+0.8792439999999999,0x9*-0x2a5+0x2329+-0x3*0x39a+0.04977999999999838),_0x4e5cfb[_0x17e5e6(0x189)+_0x17e5e6(0x4ba)](0xd29+0x1*0x209f+-0x2d85+0.09836400000000367,-0x42*0x7b+0x1*0x362+0x1d*0xff+0.07672700000000532,0x261d+0x9*0x15b+-0x320f+0.7962859999999949,-0x9f*0x2c+-0xf29+0x227*0x14+0.6811899999999866,-0x2528+0xd*0x2b6+0x22a+0.9730100000000022,0x1d73*0x1+0x7*-0x2de+-0x2*0x469+0.8631699999999967),_0x4e5cfb[_0x17e5e6(0x189)+'eTo'](-0xe5b+-0x53*0xb+0x1229+0.7102280000000007,-0x1*0x565+0x5*0x2f3+-0x8ca+0.571629999999999,0xaf6+-0x5*0x1c6+-0x1de+0.7854269999999985,0x29*-0x4f+-0x1d13+-0x29*-0x108+0.4072700000000111,0xf60+0x1306+-0x222f+0.3211549999999974,-0x1fed+-0x1e90+-0x3f09*-0x1+0.39891000000000076),_0x4e5cfb[_0x17e5e6(0x5bd)](0x1a19+0x25af+-0x3f88+0.5568180000000069,0x1*0x22a3+0x2475+-0x468e+0.9819999999999993),_0x4e5cfb['lineTo'](0x7*0x165+-0x3*-0x70f+-0x1e77*0x1+0.4019700000000057,0x9b4+0x1*0x1ce1+-0x262b+0.15922999999999377),_0x4e5cfb[_0x17e5e6(0x189)+'eTo'](0x5*-0xc+-0x1*0x126e+0x1324+0.0009490000000056398,0x1484+-0x112*0x24+0x59*0x35+0.8131920000000008,0xf3*-0x19+0x3*-0x146+0x7*0x401+0.3700410000000005,-0x2069+-0x165a*0x1+0xd6*0x42+0.1716169999999977,0x8b*0xd+0x1ecb*0x1+-0x34*0xb8+0.3704000000000036,0x1*-0x243d+-0x1c01*-0x1+0x9e*0xe+0.4758499999999941),_0x4e5cfb[_0x17e5e6(0xc1)](0x1104*0x2+-0x4*-0x48+0x17*-0x182+0.3704000000000036,0xd*0x49+-0xb*0x323+0x1f03+0.8006420000000034),_0x4e5cfb['bezierCurv'+_0x17e5e6(0x4ba)](0x35*-0xb8+-0x92c+0x54e*0x9+0.37006100000000686,0x43a*0x9+-0x1ce1+0x5*-0x1ca+0.19374499999999983,-0xd32+0x1*-0x221f+0x2fcb+0.10680999999999585,-0x5*0x6f1+0x16e+-0x1*-0x217d+0.617440000000002,-0x1*-0x1f0b+0x303*-0x1+0x55*-0x53+0.6489499999999992,0x185d+-0x32*-0x2+0x3d*-0x67+0.22125700000000137),_0x4e5cfb[_0x17e5e6(0xc1)](0x1*0x76f+-0x1*0x33b+-0x3f3+0.005290000000002237,-0x23f5+0x1843*-0x1+0x3c3d+0.41606400000000043),_0x4e5cfb[_0x17e5e6(0x189)+_0x17e5e6(0x4ba)](0x2*-0xaa9+-0x2504+0x3a96+0.18673499999999876,-0x1d06+-0x1f32+0x3c3c+0.7125849999999998,0x1e42+-0xe3*0x1+-0x1d21+0.9770439999999994,-0x10f*-0xb+-0x1a4a+0xea9+0.7125849999999998,-0x7*0x1eb+0x25ac+-0x1*0x1801+0.158489000000003,0xdb0+-0x4*0x638+-0xb35*-0x1+0.41606400000000043),_0x4e5cfb[_0x17e5e6(0x189)+_0x17e5e6(0x4ba)](0x2*-0xa57+0x7f5+-0xc*-0x113+0.39209400000000016,0xe80*-0x2+0x94*0x11+0x1341+0.5869670000000013,-0x1c5f+-0xa6*-0x26+0xb*0x59+0.6083670000000012,0x1b1a+-0x542*-0x2+-0x2579+0.7752010000000027,0x1c5f+-0x83*0x16+-0x1118*0x1+0.8073059999999996,0xe53+0x61d+-0x143b+0.9807660000000027),_0x4e5cfb[_0x17e5e6(0x189)+_0x17e5e6(0x4ba)](0x835+0x13d1+-0x1c01+0.09235400000000027,-0x7e7+0x13*-0xce+0x1767+0.6003949999999989,-0x247a+-0x1*-0x1a3+0x22db+0.7348780000000001,-0x1051+-0x89*-0x25+-0x345+0.47783799999999843,-0x19da+-0x2*0x8d+0x1af8+0.7348780000000001,0x3*0x479+0x1c8*0xb+-0x20cb+0.6130950000000013),_0x4e5cfb[_0x17e5e6(0x189)+_0x17e5e6(0x4ba)](0x7cc+-0xad4+0x30c+0.7391449999999997,0x2*0xaad+-0x18b7+0x3a5+0.21203199999999356,-0xad9+-0x24d9+-0xc5*-0x3e+0.7412780000000003,-0x193c+-0x2*-0x5d4+-0x1b*-0x84+0.03628999999999394,-0x1*-0x1551+-0xb77+-0x9d6+0.7412780000000003,-0x7*-0x11e+-0x2*0x356+-0xbe+0.08586999999999989),_0x4e5cfb[_0x17e5e6(0x189)+'eTo'](0x1*-0x33f+0x15d7+0x1294*-0x1+0.7416679999999998,-0x8bd*0x1+-0x1360+0x1c85+0.9997570000000024,-0x7f6+0x12df+0x1*-0xae4+0.22686000000000028,-0x727+0x1a1*0x7+-0x3d7*0x1+0.8438960000000009,0x6fa+0x2622+-0x2d16+0.015193000000000012,-0xa08+-0x50e+0xf80+0.30222999999999445),_0x4e5cfb['lineTo'](-0x828+0x7f*0x3e+0x27c*-0x9+0.6133510000000015,0x74*0x3e+-0x2*-0xf19+-0x39c0+0.9819999999999993),_0x4e5cfb['bezierCurv'+_0x17e5e6(0x4ba)](-0x18+0x1*0x268a+-0x2633+0.2126829999999984,0x8f1+0x67*0x3a+-0x1fbc+0.32780299999998874,-0x11ec+-0x21cf+-0x19fd*-0x2+0.9527750000000026,0x4aa*-0x4+-0x147f+0x27b2+0.32780299999998874,0x23cc+0x1732+0x49*-0xce+0.5567180000000036,-0x17f2+0x1968+-0xec+0.9819999999999993),_0x4e5cfb['fill'](),_0x4e5cfb['beginPath'](),_0x4e5cfb['lineWidth']=-0x82a+0xbb3+0x389*-0x1+0.171967,_0x4e5cfb[_0x17e5e6(0x5db)]=_0x5e95fe,_0x4e5cfb[_0x17e5e6(0x5bd)](-0x8b1*0x4+-0x10a9+0x33a9+0.6765839999999983,-0x1f93+-0x219c+-0x1*-0x4139+0.5247170000000008),_0x4e5cfb[_0x17e5e6(0x189)+_0x17e5e6(0x4ba)](-0x18d7+0xe46+0xac5+0.30082000000000164,0xdfd+-0x26ab+0xd*0x1e8+0.032665999999998974,0x8d+-0x1cb2*-0x1+-0x1d16+0.5267180000000025,-0x515*-0x4+0x1797+-0x16*0x1fd+0.613669999999999,0x2179+-0x291*-0x8+-0x9*0x5fd+0.35427699999999973,0x1*-0x196e+-0x1*-0x1376+-0x63d*-0x1+0.2677309999999977),_0x4e5cfb[_0x17e5e6(0x189)+'eTo'](0x5e8+-0x760+0x18d+0.5990690000000001,0xc*-0x1f1+0x19dc+-0x23f+0.40457499999999413,-0x2*-0x18d+-0xb21+-0x815*-0x1+0.6228750000000005,-0x2a3+-0x1c0a+-0x7*-0x46f+0.6293150000000054,-0x4*0x657+0x5*-0x5be+-0x4eb*-0xb+0.42569500000000016,-0x23ee+-0x1*0x11a1+0x35f5+0.9419500000000056),_0x4e5cfb[_0x17e5e6(0x189)+_0x17e5e6(0x4ba)](0x142f+-0x1a17+0x5ef+0.3650349999999998,0x1cce+0x10b2+0x5*-0x905+0.03293700000000399,0x11fe+0x1904+-0x2afb+0.2870400000000002,-0x79*-0x11+-0x241*-0x9+-0x1*0x1beb+0.050269999999997594,0x1ce8+-0x1e73+0x192+0.19171099999999974,0x4*0x400+0x15e0+-0x257a+0.9939499999999981),_0x4e5cfb[_0x17e5e6(0xc1)](-0xfe*0x25+-0x2*-0x780+0x23*0x9f+0.05522700000000036,0x2*-0xae0+-0x23f6+0x3a1c*0x1+0.9094500000000068),_0x4e5cfb[_0x17e5e6(0x189)+'eTo'](0x67*0x2b+0x15*0x1d5+0x37bf*-0x1+0.02923999999999971,0xa1f+-0x2*-0x6c5+-0x1743+0.8965170000000029,-0x18af*-0x1+-0x119*0x17+0x97+0.0227700000000004,0xca3+-0xcd3+0x96+0.8791829999999976,0x257b+0x9e7*0x2+-0x3942+0.035816999999999766,0x1*0x10bf+-0x1*0x1e28+0xdcf+0.85745),_0x4e5cfb[_0x17e5e6(0x189)+_0x17e5e6(0x4ba)](0x22a5+-0x1e5a+-0x43f*0x1+0.8637540000000001,0x3*-0x3b7+0x1754+-0xbd5+0.4649600000000049,-0x3*0x9ab+-0x243f+0x4153+0.3849790000000013,0x743+-0x2389*0x1+0x1c94+0.2349569999999943,0x31*0x25+-0x153a+0xe3f+0.5994899999999994,0x2690*0x1+-0x380+0x1b*-0x14a+0.16743999999999915),_0x4e5cfb[_0x17e5e6(0x189)+_0x17e5e6(0x4ba)](0x623*0x3+0xc53*0x1+0xa*-0x30f+0.29870300000000327,-0x18e4+0x134f*-0x1+0x21d*0x15+0.5842609999999979,-0x1cff*-0x1+0x737+-0x2404+0.04990500000000253,-0xb8+0x1*0x168b+-0x15b9+0.8970969999999987,-0xcb4+-0x8*0x244+0x52*0x61+0.03508899999999926,-0xaf+0x1244+-0x15*0xd6+0.4634159999999996),_0x4e5cfb[_0x17e5e6(0x189)+_0x17e5e6(0x4ba)](0x1d7f+0x641*0x5+-0x3c86+0.06542199999999809,0x1edb+-0x2381+-0x13*-0x3f+0.411416,0x28*-0x58+0x18e+0xc70+0.10875599999999963,0x1*0x1a3f+0x2*-0x7a2+0x2bd*-0x4+0.40058300000000013,-0x1204*-0x1+0x11f5+-0x23bb+0.16508900000000182,-0x9e2+0x2*0x1+0x9e7*0x1+0.43091599999999985),_0x4e5cfb[_0x17e5e6(0xc1)](-0x1*-0x22de+0x1*-0x1b33+-0x76d*0x1+0.17108900000000204,-0x1b8+0xcba+-0xafb+0.43091599999999985),_0x4e5cfb[_0x17e5e6(0x189)+_0x17e5e6(0x4ba)](0x162e+0x2e9*-0x1+-0x1307+0.22742199999999713,0x7*-0x3f3+0x1*-0x10c7+0x2c73+0.4612499999999997,0xdb5*0x2+0x446*-0x7+0x1a*0x1b+0.24042200000000236,0x1783+-0x1874+-0x3e*-0x4+0.5045830000000002,-0x18be+-0x2b5+-0x8b*-0x33+0.21008900000000352,0x292*-0xd+0x2*-0x12fa+-0xa33*-0x7+0.5609159999999997),_0x4e5cfb[_0x17e5e6(0x189)+_0x17e5e6(0x4ba)](0x47f+0x134d+-0x178f+0.7161199999999965,-0xaa*-0x22+-0x3*0x649+-0x3b1+0.5531819999999996,-0x17*0x142+-0x1836+0xaad*0x5+0.20482200000000006,0xb*0x289+0x12*-0x8b+-0x1214+0.5411149999999996,0x7*-0x39d+0x13fc+-0x2b*-0x21+0.6761929999999978,0x3a*0x17+-0x12cc+0xda0+0.5247139999999995),_0x4e5cfb[_0x17e5e6(0x3a8)](),_0x4e5cfb['beginPath'](),_0x4e5cfb[_0x17e5e6(0x363)]=-0x11ef+0x28*0x6f+0x97+0.171967,_0x4e5cfb[_0x17e5e6(0x5db)]=_0x5e95fe,_0x4e5cfb['moveTo'](0xa*0xc8+0x13*-0x1ab+0x183a+0.8401000000000067,0x119d*0x1+-0x1d87+0xc1f+0.22032099999999843),_0x4e5cfb[_0x17e5e6(0x189)+_0x17e5e6(0x4ba)](-0x8f5+0x215c+-0x1816+0.46432900000000643,0x1*0x125b+0x13c*-0xf+0x4f+0.10667999999999722,0x9*-0x452+0x18bb*-0x1+0x3fe6+0.14056200000000274,-0xe*0x1eb+-0x1144+0x2c34+0.9497089999999986,0x19b*-0x10+0xd07+-0x5*-0x295+0.8687989999999957,-0x63f+0x4*0x198+-0x1a+0.7494069999999997),_0x4e5cfb[_0x17e5e6(0x189)+_0x17e5e6(0x4ba)](0x1*0x15c5+0x2f5*0x6+-0x211*0x13+0.855866000000006,-0x7df*-0x3+-0x13e*-0x11+-0x2cb4+0.727741,-0x19c6+0x98c+0x107a+0.8601989999999944,0x2503+-0x5fa+0x9*-0x372+0.710407,-0x1a61*0x1+0x107a+-0xa27*-0x1+0.8817990000000009,-0xa*-0x12e+0x3*0x2a1+-0x13a8+0.6974070000000001),_0x4e5cfb[_0x17e5e6(0xc1)](0xe3*-0x11+-0x195c+0x28b0+0.0377900000000011,-0x2335*0x1+0x908+0x1a34+0.6064170000000004),_0x4e5cfb[_0x17e5e6(0x189)+_0x17e5e6(0x4ba)](-0xe68+0x112b+-0x282+0.12877699999999948,-0x341+0x432*-0x9+0x290a+0.554424,-0x5*-0x767+-0x1a68+-0xa5a+0.20027000000000328,-0x26e5+0x5*0x4de+0x2*0x74b+0.5739210000000003,-0x7*0x496+0xb7d+0xa6f*0x2+0.25227099999999325,0x5*-0x2f5+0x36b*0x7+-0x91d*0x1+0.6649070000000004),_0x4e5cfb[_0x17e5e6(0x189)+_0x17e5e6(0x4ba)](0x1bcf*0x1+0x4f4+-0x2076+0.35012100000000146,-0x565*0x7+0x8fb+0x1ce3+0.4798949999999991,-0x1c2+0x18*0x9b+-0xc6d+0.3093109999999939,-0xcfa*-0x2+-0x15aa+0x1*-0x41b+0.34471099999999666,-0xa00+0x14ef+-0x13*0x8e+0.1298400000000015,-0xa2d*-0x1+0xea4+-0x188e+0.25935400000000186),_0x4e5cfb[_0x17e5e6(0x189)+'eTo'](-0x1*-0x425+0x60a+0x15*-0x77+0.08003300000000024,0x1bd*0x9+0x543+-0x149a+0.9672290000000032,0xb*-0x2e1+-0x81b+0x68*0x63+0.2849429999999984,0xd2a+-0x2e*-0x35+0x772*-0x3+0.6361050000000006,0x173+-0x208*-0x7+0x1c*-0x8b+0.744569999999996,-0x6a8+0x1220+0x6d*-0x1a+0.265979999999999),_0x4e5cfb['bezierCurv'+'eTo'](0xb*0x207+0x1*-0x1c37+-0x1*-0x661+0.8312030000000021,-0x1fc1*-0x1+0x94d+-0x28a8+0.45229999999999393,0x1*-0x1dc2+0x151*-0xd+0x2f56+0.8723930000000024,-0x43f*0x6+-0x1*-0x1ea9+-0x4c9+0.5671269999999993,-0xdb3+-0x1*-0x30a+0xb20+0.8681399999999968,0x15*-0x65+0x7*0x527+-0x1b62+0.6104600000000033),_0x4e5cfb[_0x17e5e6(0x189)+_0x17e5e6(0x4ba)](0xc5*0x20+-0x2*-0xf31+0x368b*-0x1+0.8160730000000029,0x1*-0x13a+-0x10d9+-0x1*-0x1279+0.9657669999999996,0x803+-0x1377*-0x1+0xf*-0x1cd+0.6882499999999965,-0xc5e*-0x1+0x178a+-0x2382+0.9960999999999984,0x1b7b+0x1*-0xa2a+0x10da*-0x1+0.48466999999999416,0xcf3+-0x1c51+0xfc4*0x1+0.7014599999999973),_0x4e5cfb[_0x17e5e6(0x189)+_0x17e5e6(0x4ba)](0x1c73+-0x329*0xb+0x2*0x35f+0.7146029999999968,-0x812+-0x20*-0x4+0x7eb*0x1+0.8626679999999993,0x17cb+0x5*0x1f3+-0x1c*0x12f+0.6269860000000023,0x646+0xd*0x2bf+0xe3*-0x2f+0.636066999999997,-0x1*-0x1633+0xe92*-0x1+-0x742*0x1+0.22181899999999644,0x162*-0x17+-0x509*-0x5+0x5*0x160+0.021658000000002176),_0x4e5cfb[_0x17e5e6(0x189)+_0x17e5e6(0x4ba)](0x1566+-0x241*-0xd+-0x3256+0.5406059999999968,0x20f2+0x1312+-0x1143*0x3+0.9322009999999992,0x2a*0xf+0x3d*-0x6b+0x1764+0.746727000000007,-0x2*0x5d9+0x8*-0x355+0x2692+0.6650890000000018,-0x400+-0x117*-0xb+0x28c*-0x3+0.8401800000000037,-0x1ab5+-0x191b+0x3405+0.22032200000000302),_0x4e5cfb[_0x17e5e6(0x3a8)](),_0x4e5cfb[_0x17e5e6(0x268)](),_0x4e5cfb['lineWidth']=0x453+0x2114+-0x2567+0.171967,_0x4e5cfb[_0x17e5e6(0x5db)]=_0x5e95fe,_0x4e5cfb[_0x17e5e6(0x5bd)](-0x3*-0xafd+0x1f6+-0x22e2+0.33193100000000086,-0x79*0x8+0x11c*-0x5+0x1*0x9bf+0.17315999999999576),_0x4e5cfb[_0x17e5e6(0x189)+'eTo'](0x781+0x1ba4+-0x231a+0.3059440000000002,0x1249+-0x8d3+-0x90b+0.17315999999999576,0x1f*-0xf1+-0x2a2+0x1fdc*0x1+0.2929510000000004,0xe45+-0x1e8+0xb*-0x116+0.16016000000000474,0xd52+-0x92c+0x1*-0x41b+0.2929510000000004,-0x207e*-0x1+-0xf12+-0x1101+0.13415999999999428),_0x4e5cfb[_0x17e5e6(0xc1)](0x4*0x119+0x537*-0x5+0x15ba+0.2929510000000004,-0xb48+0x5*0x1c9+0x2c6+0.12815999999999406),_0x4e5cfb['bezierCurv'+'eTo'](-0x73b*0x2+-0x2273+0x30f4+0.28868399999999994,0x11*-0x7d+-0x1*0x4ba+0xd72+0.06749299999999891,0x1108+0x47*0x59+-0x29ac+0.31685099999999977,0x251d+-0x1ce1+-0x45*0x1d+0.03932700000000011,0x7ce*0x5+-0x84*-0x44+-0x4a0b+0.37745100000000065,-0x1b96+-0x1*0x5e9+0x3*0xb4e+0.0436600000000027),_0x4e5cfb[_0x17e5e6(0x189)+_0x17e5e6(0x4ba)](-0x1*0x9ef+0x4*0x853+-0x1751+0.7098610000000001,-0x1*-0x213+0x14f5+-0x169d+0.0436600000000027,0xaf*0x1f+0x1b56+-0x307a+0.9837740000000004,0x199b+-0x714+-0x121d+0.7836800000000039,0x115*-0xa+-0x1*-0x2627+0xda3*-0x2+0.3421819999999993,-0x23e8*-0x1+-0x49*-0x86+-0x49b4+0.7251799999999946),_0x4e5cfb['bezierCurv'+'eTo'](0x1c6f+-0x1b9a+-0xf*0xb+0.10429299999999841,0x1*-0x7f4+0x97*0xb+0x1e0+0.2996069999999946,0x1105+-0xda*-0x5+-0x1*0x14f7+0.6844150000000013,0x1583*0x1+0xde5+-0x1*0x22ff+0.3451000000000022,-0x1265+0x112b+0x1ab+0.08254999999999768,-0x23b8+-0x2077+-0x11*-0x409+0.8616600000000005),_0x4e5cfb['bezierCurv'+_0x17e5e6(0x4ba)](-0x1e2f+-0x91+-0x5*-0x63d+0.8234970000000033,-0x1fb1+-0xd06+0x2d21+0.8963269999999994,-0x20b5*0x1+-0x1*-0x168e+0xa99*0x1+0.6424430000000001,0x125*0x1f+-0x3*-0x3a9+-0x1c*0x1a5+0.9613200000000006,-0x4*0x7ad+0x1761+0x7c6+0.5393899999999974,0x1efb+-0x835*0x1+0x61*-0x3b+0.05664000000000158),_0x4e5cfb[_0x17e5e6(0x189)+'eTo'](0x1*0x1c33+0x4*0x5a1+0x1922*-0x2+0.8513700000000028,-0x1*-0x1993+-0xf30+-0x9f8+0.09130700000000047,0xf6a+-0x4f5+-0xa02+0.8513700000000028,-0x37c*0xa+-0x220d+-0x10*-0x455+0.11513999999999669,-0x1d49+0x19ec+0x3d0+0.5393899999999974,0x2678+-0xf7e+-0x168f+0.12814000000000192),_0x4e5cfb[_0x17e5e6(0x189)+_0x17e5e6(0x4ba)](-0x2dd*-0x2+0x117e+0x85*-0x2c+0.4442810000000037,0x14c5+0xf75*-0x1+-0x272*0x2+0.1594000000000051,0x2261+0x9e9*-0x3+-0x460+0.23095200000000204,-0x186f+0xc90+-0x3*-0x419+0.5125429999999938,0xa0c+-0x1*-0x2150+0x1*-0x2b2c+0.8994009999999975,0x1219+0x2*0x133e+-0x3829+0.1875699999999938),_0x4e5cfb['bezierCurv'+'eTo'](-0x1d25+-0x2083+-0x1ee6*-0x2+0.9012180000000001,0x1f37+0x356*-0x1+-0x1b75+0.0012499999999988631,0x1fdc+-0x1fa5+0x1f*-0x1+0.37873499999999893,-0x11fe+-0x2687+-0x38f*-0x10+0.6632730000000038,0xc*-0x236+0x1*0xee6+-0x1ab*-0x7+0.33195399999999964,0x479+0x3f9*-0x3+0x3*0x29f+0.173640000000006),_0x4e5cfb[_0x17e5e6(0x3a8)](),_0x4e5cfb[_0x17e5e6(0x416)](),_0x4390a6['_baseTextu'+'re'][_0x17e5e6(0x526)](),_0x4390a6[_0x17e5e6(0x5fa)+_0x17e5e6(0x5ba)]=![],_0x4390a6[_0x17e5e6(0x3d7)]=!![],this['_cache_cre'+_0x17e5e6(0x206)+_0x17e5e6(0x1c5)][_0x4a3612]=_0x4390a6,this[_0x17e5e6(0x352)+_0x17e5e6(0x206)+_0x17e5e6(0x1c5)][_0x4a3612];},ImageManager[_0x5db7a1(0x18f)+_0x5db7a1(0x4c9)+'0']=function(_0x1051cf){const _0x5a8c8a=_0x5db7a1,_0xc1f908={'lxYaP':'color-%1','MgjuB':function(_0x121c81,_0x13cf4a){return _0x121c81!==_0x13cf4a;},'iMDXz':_0x5a8c8a(0x1de),'YDgiR':_0x5a8c8a(0x458)},_0x1d94be=_0xc1f908[_0x5a8c8a(0x530)][_0x5a8c8a(0x13e)](_0x1051cf);this[_0x5a8c8a(0x352)+_0x5a8c8a(0x206)+_0x5a8c8a(0x443)]=this[_0x5a8c8a(0x352)+'ateDiceGra'+_0x5a8c8a(0x443)]||{};if(_0xc1f908[_0x5a8c8a(0x38d)](this['_cache_cre'+_0x5a8c8a(0x206)+_0x5a8c8a(0x443)][_0x1d94be],undefined))return this[_0x5a8c8a(0x352)+_0x5a8c8a(0x206)+_0x5a8c8a(0x443)][_0x1d94be];const _0x16b853=ImageManager[_0x5a8c8a(0x229)+'RATIOS'],_0x32cad8=ColorManager[_0x5a8c8a(0x314)+'r'](_0x1051cf,_0x16b853[_0x5a8c8a(0x3a7)]),_0x1bb657=ColorManager['darkenColo'+'r'](_0x1051cf,_0x16b853[_0x5a8c8a(0x2a5)]),_0x542029=ColorManager['darkenColo'+'r'](_0x1051cf,_0x16b853[_0x5a8c8a(0x128)]),_0x29c035=ColorManager[_0x5a8c8a(0x314)+'r'](_0x1051cf,_0x16b853[_0x5a8c8a(0x4e9)]),_0x534ef7=new Bitmap(-0x1*0x1daa+0x3*0x69f+0xa57,0x1*0x150d+0x427+0x26*-0xa6),_0x17143c=_0x534ef7[_0x5a8c8a(0x256)];return _0x17143c['save'](),_0x17143c['beginPath'](),_0x17143c[_0x5a8c8a(0x5db)]=_0x1bb657,_0x17143c[_0x5a8c8a(0x363)]=-0x52*-0x37+-0x2417+0x1*0x1279+0.070004,_0x17143c[_0x5a8c8a(0x1cf)]=_0xc1f908[_0x5a8c8a(0x13a)],_0x17143c[_0x5a8c8a(0x4a0)]=_0xc1f908[_0x5a8c8a(0x49a)],_0x17143c[_0x5a8c8a(0x5bd)](0x2057+-0x16da+-0x313*0x3+0.46656699999999773,-0x47*0x9+-0x1*-0xa9b+-0x81a+0.22293999999999992),_0x17143c[_0x5a8c8a(0xc1)](0x756*0x4+0xe7c+-0x2bd1+0.11211700000000002,-0x100+0x25dc+-0x2493+0.5793280000000038),_0x17143c[_0x5a8c8a(0xc1)](0x1*-0x20a3+-0x9*0x3a+0x1*0x22af+0.0006460000000001465,0x1af*-0x2+0x23d3+-0x201a+0.1405589999999961),_0x17143c[_0x5a8c8a(0xc1)](0x12a6+0x167*-0x1+0x6a*-0x29+0.800329000000005,-0x1711+0x1*0x1bb+0x15e4+0.26819000000000415),_0x17143c['lineTo'](-0x2*-0xaeb+-0x25*-0xb9+0x7*-0x6dd+0.26625000000001364,0x35*-0xa3+0x56d+0x1cac+0.9182639999999935),_0x17143c[_0x5a8c8a(0xc1)](-0xbe6+-0x5*0x5f7+0x2a40+0.5993699999999933,0x18ee+0x247f+-0x1c*0x22f+0.8016230000000064),_0x17143c[_0x5a8c8a(0x3a8)](),_0x17143c['beginPath'](),_0x17143c['fillStyle']=_0x542029,_0x17143c[_0x5a8c8a(0x363)]=0xaac+-0x1*0x1265+-0x1*-0x7b9+0.070004,_0x17143c[_0x5a8c8a(0x1cf)]=_0xc1f908[_0x5a8c8a(0x13a)],_0x17143c[_0x5a8c8a(0x4a0)]=_0xc1f908[_0x5a8c8a(0x49a)],_0x17143c[_0x5a8c8a(0x5bd)](0x21c9+0xb5*-0xd+-0x1897+0.02811000000000008,0x1c*0x15b+0x2*-0xb3e+0x2*-0x790+0.11180299999999477),_0x17143c[_0x5a8c8a(0xc1)](0x225f+-0x2010+-0x234+0.5644610000000014,-0x108a+-0x2*0xb3+-0x928*-0x2+0.9202049999999957),_0x17143c[_0x5a8c8a(0xc1)](0xb00+-0xe11*-0x2+-0x1*0x26b5+0.14637999999999352,0xad4+0x12fc+-0x1d70+0.4756150000000048),_0x17143c[_0x5a8c8a(0xc1)](0x115*0x8+-0x2c*-0xf+-0xab4+0.26625000000001364,-0x185*0xe+-0x229+0x17c7+0.4730289999999968),_0x17143c['lineTo'](-0x4d9*0x7+-0x22ed+0x4563+0.5993699999999933,-0xbf4+-0x1da1+0x29e0+0.35768199999999695),_0x17143c[_0x5a8c8a(0xc1)](0x23a2*-0x1+0x1f3e+0x1*0x4a9+0.35574200000000644,-0x2fe+-0x1535+0x1834+0.33376399999999995),_0x17143c[_0x5a8c8a(0xc1)](0x3b*-0xe+0x4*-0x684+0x753*0x4+0.667529,0x42*0x63+-0xdf2+0x1*-0xb4a+0.24621000000000492),_0x17143c[_0x5a8c8a(0x3a8)](),_0x17143c[_0x5a8c8a(0x268)](),_0x17143c['fillStyle']=_0x29c035,_0x17143c[_0x5a8c8a(0x363)]=-0x21d5*0x1+0x1bd5*0x1+0x600+0.070004,_0x17143c[_0x5a8c8a(0x1cf)]=_0xc1f908['iMDXz'],_0x17143c[_0x5a8c8a(0x4a0)]=_0xc1f908[_0x5a8c8a(0x49a)],_0x17143c[_0x5a8c8a(0x5bd)](-0x1*-0xfda+0xc98+0x1*-0x1c2d+0.022300999999998794,-0x1d58+-0x17d8+0x3533+0.973506),_0x17143c[_0x5a8c8a(0xc1)](-0x2077+-0x2442+0x44d4+0.46005699999999905,-0x1dd*0x1+0x1c41+-0x1a04+0.2398369999999943),_0x17143c[_0x5a8c8a(0xc1)](-0x9c7+-0x1034+0x1a40+0.13344899999999882,0x1*-0x1d0e+0x1edf+-0x15a+0.14960999999999558),_0x17143c[_0x5a8c8a(0xc1)](0x1*0x1ddd+-0x25c0+0x851+0.8854299999999995,-0x20fd+-0x6*0x5dc+0x36d*0x14+0.9720829999999978),_0x17143c['fill'](),_0x17143c[_0x5a8c8a(0x268)](),_0x17143c['fillStyle']=_0x32cad8,_0x17143c[_0x5a8c8a(0x363)]=-0xec+0x5c*-0xd+0x166*0x4+0.170223,_0x17143c[_0x5a8c8a(0x5bd)](0x35f+-0x1379+0x1060+0.8608440000000002,0x3f1*-0x2+0x8ad*-0x2+0x19cb+0.7543699999999944),_0x17143c[_0x5a8c8a(0x189)+_0x5a8c8a(0x4ba)](0x1*-0x916+0x1a3a+-0x10e0+0.6139569999999992,0x1bd6*0x1+-0x1acf*0x1+-0x77+0.34415999999998803,-0x1*0x22d4+0xbe*0x30+-0x17*0x6+0.425179,-0x2673+-0x6*0x199+0x3098+0.8569300000000055,-0x8*-0x359+0x1517+-0x2f9f+0.6108849999999961,0x1e52+-0xe3b*-0x1+-0x2bff+0.4529799999999966),_0x17143c['bezierCurv'+'eTo'](0x237e+0x3e5*-0x1+-0x1b*0x12a+0.9412560000000028,0x7*-0x3d6+-0x2*-0x7d9+-0x2a*-0x47+0.49444699999999386,0x1c01+-0x938+0x12b2*-0x1+0.27593200000000095,-0x1f37+0x7c0+0x3*0x7f7+0.5273700000000048,0x1bf3+-0x509*0x2+-0x4b*0x3d+0.6149110000000002,-0x861+-0x2*0x53a+0x1333+0.5517499999999984),_0x17143c[_0x5a8c8a(0x189)+'eTo'](0x13c3+0xb36+-0x371*0x9+0.931899,-0x19*-0x16f+0xd18+-0x3092+0.24822299999999586,0x15f+-0x14d*0x2+0x13b+0.073175,0x80a+-0x2123+0x43e*0x6+0.3890999999999991,-0x1*-0x19b1+0xe*-0xa1+0x5a1*-0x3+0.03874,0x18f3+-0x7*-0x212+-0x2719*0x1+0.9743799999999965),_0x17143c['bezierCurv'+_0x5a8c8a(0x4ba)](-(0x513*-0x2+0x23e4*0x1+0x2*-0xcdf+0.012913),0x6d+0x241*0xb+-0x18e4+0.7090800000000002,-(-0xf6c+-0x1616+0x2582+0.012913),-0xec+0x1*-0x2029+0x2165+0.40532000000000323,-0x35*-0x69+-0xa*-0x269+-0x5*0x92b+0.03874,0x61*0x61+-0xdfb+-0xe*0x19b+0.06310000000000571),_0x17143c[_0x5a8c8a(0x189)+_0x5a8c8a(0x4ba)](0x21be+-0xb4+0x210a*-0x1+0.064563,0x1644+0x9f5+0xaa5*-0x3+0.030879999999996244,0x1ecf+0x5f*0x3+-0x2*0xff6+0.923289,-0x10b1+-0xd*0x6f+-0x169c*-0x1+0.49871000000000265,-0xa34+-0x21f+0xc55+0.36956100000000003,0x2*-0x47b+-0x13d*0x7+0x11e7+0.8767899999999997),_0x17143c['bezierCurv'+'eTo'](0x905*-0x4+0x74d+0x1cdd+0.3504889999999996,-0x353*-0x2+0x3ad+-0x1*0xa23+0.5758709999999994,0x18df+0x635*0x5+-0x37be+0.3271129999999971,0x20eb+-0x15cb+0xa6*-0x11+0.27281699999999987,0x1*0x1b47+0x3e4*-0x4+-0xb*0x10b+0.2994330000000005,0x568+-0x16*0x18c+0x1ca3+0.9676260000000001),_0x17143c[_0x5a8c8a(0x189)+_0x5a8c8a(0x4ba)](0x202c+-0x2585*0x1+0x599+0.12448999999999444,0x1*-0x19a5+-0x65*-0x34+-0x92*-0x9+0.933276,0x1c0f+-0x5*-0x251+-0xd21*0x3+0.5535430000000048,-0x20a0*0x1+0x11*0x20+0x1e80+0.747285,0x2446+0x1e*-0xa6+0x424*-0x4+0.5865940000000052,-0x1eb1+-0x199a+-0x384b*-0x1+0.409653),_0x17143c['bezierCurv'+_0x5a8c8a(0x4ba)](-0x40*0x74+-0x1ee*-0xd+0x5*0xd6+0.36860699999999724,-(0x243*0x2+-0x15af+0x1129+0.163043),0x1b3b+-0x36a*-0xa+0x1*-0x3d19+0.0709889999999973,-(-0x600+0x23*0x39+-0x1*0x1cb+0.135266),-0xc7*-0x13+0xfae+-0x1*0x1e2c+0.6937400000000054,-0x139*0x14+-0x84e+0x20c2*0x1+0.492983),_0x17143c['bezierCurv'+_0x5a8c8a(0x4ba)](-0x146d+-0x211f+0x35d4*0x1+0.662226000000004,0x3*-0xbb+-0x20e1+0x86*0x43+0.864809,0x753+0x76c+-0x2*0x73b+0.8588440000000048,-0x1*0x15cd+-0x2db+0x18a9+0.847793,-0x3de+0x1b4f+-0x1726+0.2835929999999962,0x7*-0x11b+-0x141e+0x94a*0x3+0.4419369999999998),_0x17143c['bezierCurv'+_0x5a8c8a(0x4ba)](0x256+-0xa66+-0x7f*-0x11+0.7078709999999973,0xa5+0x1*0xc69+-0xcf4+0.2343459999999986,0x1*-0xfa2+0xa00+0x616+0.1278470000000027,0x5e*-0x3e+-0x993+-0x56c*-0x6+0.028889999999996974,-0x8*-0x31+-0x989+0x889*0x1+0.5435200000000009,0x24d0+0x1*0x1c10+-0x4099+0.825569999999999),_0x17143c[_0x5a8c8a(0x189)+_0x5a8c8a(0x4ba)](0x2*-0x210+0x2003+0x3*-0x91e+0.5507399999999905,0xad0*-0x1+0x71*-0x3c+0x2594+0.941040000000001,-0x980*-0x1+-0xe4f+-0x4c*-0x12+0.9704199999999901,-0x2af*0x2+-0xd43+0x1d*0xa7+0.5950200000000052,-0x1*-0x17a5+0xa0e+-0x212a+0.9833299999999952,-0x1*0xf5+0xb45+-0xa04+0.22334999999999638),_0x17143c[_0x5a8c8a(0x189)+_0x5a8c8a(0x4ba)](0x1f7e+-0x2e9*-0x9+-0x3925*0x1+0.013463000000001557,0xcd*-0xf+-0x17*-0x168+-0xc*0x1ab+0.07416299999999865,0x194e+-0x1cf2+0xd6*0x5+0.002730000000013888,0x1*-0x19cf+-0x6e*-0x19+0xf66+0.7561599999999942,0x9*-0x3a1+0x9*-0x16b+-0x1*-0x2df5+0.9511300000000062,0x7d3*0x3+-0xc05*0x3+0x90*0x17+0.2693399999999997),_0x17143c['bezierCurv'+_0x5a8c8a(0x4ba)](-0x3bd+0x21a1*-0x1+0x1*0x25e7+0.9253300000000024,-0x2*-0x11a3+0xb*0x2e6+0x3*-0x1644+0.2951400000000035,0x1*0xb55+-0x17d*0x1+-0x950+0.07225999999999999,-0xa9a*-0x3+-0xa2a*0x1+0x185*-0xe+0.07734000000000663,-0x2*-0x1173+0x1*-0xb56+-0x170a+0.4258399999999938,-0x39e*0x2+-0x1da6+0x11*0x231+0.3530800000000056),_0x17143c[_0x5a8c8a(0x189)+'eTo'](0x8c*-0x4+0x4*0xd2+-0xa6+0.5654399999999953,0x1790+0x1110+-0x2832+0.700452999999996,0x7f4+-0x22bd+0x1b27+0.7050349999999952,-0x1415*0x1+0x1*-0x259a+0x3a2d+0.04568999999999335,0x36*0x76+0x303*0x5+0x47*-0x8f+0.844623999999996,0xa7*-0x12+0x635*0x5+-0x12be+0.3887900000000002),_0x17143c[_0x5a8c8a(0x189)+'eTo'](-0x7*0x3d3+-0xd7f*-0x1+0xd8f+0.12717499999999404,0x210a+0x2a5+-0x11*0x211+0.7179500000000019,-0x30b*0x5+-0x190*0x6+0x18de+0.7992739999999969,0x1cb7+0x3c1+-0x1fe9+0.5064729999999997,0x71f*0x3+0x790+-0x1e9*0xf+0.8609210000000047,-0xff6*0x2+0x2296+-0x21b+0.7543599999999913),_0x17143c[_0x5a8c8a(0x5bd)](0x4*-0x7c3+0x2a*0xa7+0x3eb+0.45976799999999685,0x11c3+0xdba*-0x1+-0x37e+0.2476000000000056),_0x17143c[_0x5a8c8a(0x189)+_0x5a8c8a(0x4ba)](0x1555+0x1b14+-0x4e*0x9e+0.817339000000004,0x49d+-0x26*-0xe5+-0x2610+0.1589050000000043,-0x22c*-0x1+0x1f08+-0x34b*0xa+0.15164699999999698,-0xfb8+-0x4b7+0x14f9+0.9973060000000089,-0xf1c*0x1+0x1dc+0xd86+0.441166999999993,-0x1c3e+0x1cd*-0x1+0x1e95+0.773210000000006),_0x17143c['bezierCurv'+_0x5a8c8a(0x4ba)](0x1*0x21b2+0x385+-0x126e*0x2+0.12370900000000518,0xa42+-0x71*-0x41+-0x1*0x2679+0.7804830000000038,-0x91a*0x4+-0x86*-0x2f+0xc3d+0.5931829999999962,0x160+-0x2677+-0x2581*-0x1+0.9608499999999935,-0x4f*-0x34+0x41*-0x7f+0x5d*0x2e+0.8495900000000063,-0x4*-0x76d+-0x12f3+-0xa66+0.3143100000000061),_0x17143c[_0x5a8c8a(0x189)+_0x5a8c8a(0x4ba)](-0x1*-0x9c5+-0x1*0x2006+-0x6a*-0x37+0.06343000000001098,-0xe3e+-0x157c+-0x4*-0x905+0.3719200000000029,-0x3d*0x11+-0x1d0a+-0x9*-0x3bc+0.2894100000000037,0x2208+0x279*0x2+0x13f*-0x1f+0.8141899999999964,-0x9*-0x421+-0xfe9+0x1d*-0xb7+0.2894100000000037,0x1d69*-0x1+-0x1*-0x15b9+0x808+0.3653500000000065),_0x17143c[_0x5a8c8a(0x189)+_0x5a8c8a(0x4ba)](0x131f*0x1+0x14f3+0x278d*-0x1+0.3022100000000023,0x1*0x1b7f+-0x112f+-0x9fc+0.35648999999999376,0x5bd+-0x1182+0x16*0x8f+0.2958099999999888,-0x1085*0x1+-0x66f+0x5d1*0x4+0.3711330000000004,-0xd*0x207+-0xe32+0x2912+0.2702099999999916,-0x9de+-0x1102+0x1b2c+0.4092799999999954),_0x17143c[_0x5a8c8a(0x189)+_0x5a8c8a(0x4ba)](0x442+0x685+-0xa42+0.2661689999999908,-0x3f5+-0x1394+-0x14*-0x131+0.7195940000000007,0x2c4+-0x2360+0x2121+0.008929999999992333,0x50b*0x1+-0x368*0xa+0x1d50+0.05605300000000568,0xc8e*0x1+0xfb8+-0x176*0x13+0.5469899999999939,-0x1e9e+0x427+0x1ac1+0.5437500000000028),_0x17143c['lineTo'](0x1a8f+0x1*0x2391+-0x3dda+0.6800580000000025,-0x61*-0x53+-0x26e0+0x1*0x772+0.467746),_0x17143c[_0x5a8c8a(0x189)+'eTo'](0x19c3+0x1*0x105b+-0x8*0x53b+0.26349500000000603,0x78c+-0x1d54*0x1+0x15cd+0.0029320000000003787,-0x65f+0x1b42+0x3a*-0x5b+0.6667280000000062,-0x18d*-0x4+-0xd3f+0x70f+0.7370320000000001,-0x5ca+-0xce3*0x2+0x1*0x1fd5+0.04008899999999471,0xb5*0x35+-0x37*-0x27+-0x2dd6+0.7370320000000001),_0x17143c[_0x5a8c8a(0x189)+_0x5a8c8a(0x4ba)](0xe64+0x21d0*0x1+0x5fe*-0x8+0.4134509999999949,-0x1dfb+0x6b*-0x41+0x1b*0x21e+0.7370320000000001,-0x1ee1+-0x2514+0x4438+0.8166839999999951,-0xa*-0x1eb+-0x1eec+0x1*0xbc3+0.0029320000000003787,0x1*0x11f5+0x1*0x23ab+-0x355d+0.4001209999999986,-0x130f+-0x1f3*-0x13+-0x11f5*0x1+0.467746),_0x17143c[_0x5a8c8a(0xc1)](-0x954+0x164c*-0x1+0x1fa5+0.4041490000000003,-0x20da+-0x17a9+-0x25*-0x189+0.6399100000000004),_0x17143c[_0x5a8c8a(0x189)+_0x5a8c8a(0x4ba)](0x15a+-0x1*-0x2447+-0x259c+0.029740999999999573,0x150f+0x25cc+0x1d48*-0x2+0.05680499999999711,-0x2c8*-0xa+-0x1a5b+-0x171*0x1+0.8229050000000004,0x5f*-0x2f+-0x1*0x13cf+0x258b+0.5953269999999975,-0x1*-0x26a8+0xa7*-0x35+-0x3*0x15b+0.8230579999999996,0xb95*-0x2+-0x26ce+-0x5*-0xc74+0.15285000000000082),_0x17143c[_0x5a8c8a(0xc1)](0x210e+-0xb4f*0x1+-0x15bb+0.8230579999999996,-0x2e3*0x2+-0x1b25*-0x1+-0x1506+0.1731099999999941),_0x17143c[_0x5a8c8a(0x189)+_0x5a8c8a(0x4ba)](0x7a+0x3d*-0x2b+0x9c9+0.822819,0xcc4+-0x13*-0x14+-0xde7+0.8405560000000065,0x16e8+0xe8d+-0x2570+0.13266400000000012,-0x1623*0x1+-0x33d*0x2+0x1cf7*0x1+0.4700519999999955,-0x7ca+-0x1*0xf91+0xb0*0x22+0.6624109999999996,0xc43+0x9a1+0x158a*-0x1+0.878380000000007),_0x17143c[_0x5a8c8a(0x189)+_0x5a8c8a(0x4ba)](0x1*0x22c1+0x1*-0x5bf+-0x1ce8+0.3923020000000008,-0xfd*0x19+-0x1*0x1cda+0x35f9+0.9010200000000026,-0x1*0x4e1+-0x76d*0x2+0x13ea+0.053322000000001424,-0x2*-0x105+-0x297+0x107*0x1+0.8745100000000008,0x954+0x2329+-0x3*0xebe+0.645471999999998,0x1ef6+0x15e1*0x1+-0x3*0x116f+0.7988499999999874),_0x17143c[_0x5a8c8a(0x189)+_0x5a8c8a(0x4ba)](0xb8b+0x5bf*-0x4+0x14d*0x9+0.2351720000000057,-0x1*0x98f+0x524+0x4f6+0.256149999999991,0x3*0xa89+-0xacd*-0x2+-0x1*0x34f1+0.8399370000000062,-0x6*0xcb+0x1e*-0x64+-0x1105*-0x1+0.4057329999999979,-0x1b3c+-0x760+0x22e1*0x1+0.45976799999999685,-0xdb5+-0x9da+0x181a+0.2476000000000056),_0x17143c[_0x5a8c8a(0x3a8)](),_0x17143c[_0x5a8c8a(0x268)](),_0x17143c[_0x5a8c8a(0x5db)]=_0x32cad8,_0x17143c[_0x5a8c8a(0x363)]=-0xbfc*0x2+0x2d9+0x151f+0.170223,_0x17143c[_0x5a8c8a(0x5bd)](-0x92b*0x4+-0x1*0xbb5+0x30d0+0.14982999999999436,0x177d+0x2*-0xc59+0x193+0.5260999999999996),_0x17143c[_0x5a8c8a(0x189)+_0x5a8c8a(0x4ba)](0x1cf*0x3+-0x8d*0x33+0x1*0x1719+0.4941830000000067,-0x46*0x2f+-0x5*0x507+0x265b+0.5260999999999996,0x2390+0x1d5+0x3*-0xc52+0.8363800000000055,-0xbd*0x1b+-0x5*-0x3a9+0x4*0x80+0.4833600000000047,-0x1aa3*0x1+0xa99*-0x1+0x4*0x96b+0.17641999999999314,-0x43a+0x7fc*0x2+-0xb60+0.3978800000000007),_0x17143c[_0x5a8c8a(0x189)+_0x5a8c8a(0x4ba)](0x916+0x1c92+0x3*-0xc66+0.18103299999999933,-0x861+-0x231a*-0x1+-0x1*0x1a5d+0.9276729999999986,-0x2f3*0x8+-0xefd+0x2711+0.18134000000000583,0x11a7+0x478+-0x15c4+0.5066199999999981,0x72a+0x1d3a+-0x23e2+0.17733999999998673,-0x23ab+-0x109*0x7+0xd5*0x34+0.1347200000000015),_0x17143c[_0x5a8c8a(0x189)+'eTo'](0x7e2*0x4+-0x1d14+-0x1f2+0.26343299999999203,-0x56c+0x10e0+0x196*-0x7+0.11765300000000423,-0x7b*0x1b+0x11*0x157+-0x94c+0.3193870000000061,-0x53*-0x39+0x1558*-0x1+0x337+0.14972000000000207,0x5b*0x13+-0x41d*-0x3+-0x1296+0.3452000000000055,0xa06*-0x1+-0xcf0+0x2ea*0x8+0.23091999999999757),_0x17143c[_0x5a8c8a(0xc1)](0x1*0xde7+-0x2*-0xe52+-0x2a09+0.3452000000000055,-0x25*0xb3+-0x259d+0x3fd6+0.2369199999999978),_0x17143c[_0x5a8c8a(0x189)+_0x5a8c8a(0x4ba)](0xf79+-0x152*0xe+0x385+0.36673300000001063,0x1*-0x169f+-0x19b+0x1894+0.30530000000000257,0x8*-0x3a1+-0x3*-0x612+-0x19*-0x74+0.3430669999999907,-0x26cf+0x11d*-0x17+0x1031*0x4+0.3523129999999952,0x4*-0x6fb+0x19f*0x5+0x1453+0.27420000000000755,-0x178f*-0x1+0x1bf4+-0x3329+0.37796000000000163),_0x17143c[_0x5a8c8a(0x189)+_0x5a8c8a(0x4ba)](-0xfa9+0x7e+0x1*0xfa7+0.0027269999999930405,0x202*0x13+0x238d+-0x2ef*0x19+0.7456729999999965,-0x3d*-0x11+-0x24a4+-0x234*-0xf+0.7506170000000054,0x1113+-0x1b62+-0x557*-0x2+0.12834300000000098,-0x29*0xf1+-0x1*-0x232b+-0x1*-0x3dd+0.517870000000002,-0x21a1*-0x1+-0x1be7*0x1+-0x1*0x559+0.5259700000000009),_0x17143c[_0x5a8c8a(0x189)+_0x5a8c8a(0x4ba)](-0x1*0x2f1+-0xce7+-0x1*-0x1046+0.3159169999999989,0x22*-0xd9+-0x215*0x1+-0x16c*-0x16+0.989569000000003,0x1983+-0x200f+-0x6f8*-0x1+0.9614179999999948,0x2*0x239+0x1da7*-0x1+0x1996+0.4249379999999974,-0x632*-0x1+0x2508+-0x2ace+0.45745999999999754,0x64*-0x25+-0x261b+0x11a5*0x3+0.2502199999999988),_0x17143c[_0x5a8c8a(0x189)+_0x5a8c8a(0x4ba)](0x3d*0x5c+0x1*0x1b92+-0x311f*0x1+0.957532999999998,0xb32*0x2+-0x2584+-0x3*-0x521+0.04722200000000498,0x1d*-0xfe+-0x76a+0x2483+0.520025000000004,0x5d1*0x1+-0x1*-0x20fe+-0x26aa+0.9189289999999986,-0x14df+0x4d9+0x104d+0.1449350000000038,-0x5fb+-0x293*0xe+0x5*0x869+0.8653410000000008),_0x17143c[_0x5a8c8a(0x189)+_0x5a8c8a(0x4ba)](-0x1*0x1c33+0x1*-0x761+0x23db+0.11480799999999647,0x12fd*-0x1+0x26c8+-0x13c3+0.8055079999999997,0x398+0xe2*-0x2+0x18d*-0x1+0.13203199999999526,0x1*0xb67+-0x23d1+0x95*0x2a+0.7606350000000006,-0x125a+0x1ac2+0x1*-0x821+0.19660500000000525,-0x270d+0x2022+0x251*0x3+0.7307210000000008),_0x17143c[_0x5a8c8a(0xc1)](0x6c3*-0x2+0x197d+-0xbb0+0.20290500000000122,-0xf4d+0x1ae*-0x11+0x1*0x2be3+0.7307210000000008),_0x17143c[_0x5a8c8a(0x189)+_0x5a8c8a(0x4ba)](0xe8f*0x1+-0x269e+0x1856+0.26316500000000076,-0x313*-0x1+-0x37a+-0x3*-0x25+0.7050680000000007,-0x1151+-0x4d3*-0x8+-0x1500+0.30835899999999583,0xef7+-0x26a5+0x17b6+0.7221650000000004,0x4*0x32b+-0x9b*-0x16+-0x1d*0xe3+0.33848700000000065,-0x16ba+0x47*-0xd+0x1a5d*0x1+0.7820110000000007),_0x17143c[_0x5a8c8a(0x189)+_0x5a8c8a(0x4ba)](0x3*0x7b2+0x167*0x9+-0x1*0x2361+0.5185280000000034,0x1*-0x1679+-0x1583+0x365*0xd+0.19452400000000125,0x487*0x7+0x1401+-0x3351+0.7222249999999946,-0x1a*0x74+0xc*-0x1f0+0x3*0xbc3+0.7309809999999999,0xb20+-0x3*-0x5b6+0x1a*-0x112+0.9495799999999974,0x38e*-0x7+-0xaf*-0x37+-0xc59+0.39137999999999806),_0x17143c['bezierCurv'+_0x5a8c8a(0x4ba)](-0x1b*-0x3d+-0x2*-0x116f+-0x28df+0.9855359999999962,-0x1a9e+0xd1*0x3+0x1889+0.4735280000000017,0x411*-0x7+0x91d+0x13c9+0.06427100000000507,0x1275*0x1+0x14ca+0x10d*-0x25+0.5264849999999939,-0x1e5*0xa+-0x75*0x12+0x1b9b+0.14973000000000525,0x8dd+-0x22c4+-0x1*-0x1a45+0.5259999999999962),_0x17143c[_0x5a8c8a(0x3a8)](),_0x17143c['beginPath'](),_0x17143c[_0x5a8c8a(0x5db)]=_0x32cad8,_0x17143c[_0x5a8c8a(0x363)]=0x7b2*-0x5+-0x95*-0x3b+0x423+0.170223,_0x17143c[_0x5a8c8a(0x5bd)](-0x122a*0x1+-0x15b5*-0x1+-0x371+0.5558690000000013,-0x2459+0x1639+-0x35*-0x46+0.5517499999999984),_0x17143c[_0x5a8c8a(0x189)+'eTo'](-0x178b+-0xa9d*0x1+0x2242+0.8031639999999989,-0x3*0x561+-0x71*0x3a+0x2a1b+0.6113299999999953,0x2*0xd2b+0x13*-0x133+-0x372+0.05947400000000158,-0x1dc4*0x1+0xd48+-0x86d*-0x2+0.48810000000000286,-0x1e69+0x233+-0xb*-0x293+0.1692430000000016,-0x194c+-0x3*-0xb1d+-0x7ad*0x1+0.25685),_0x17143c[_0x5a8c8a(0x189)+_0x5a8c8a(0x4ba)](0x1*-0x1b70+0x18f9+0x29f+0.2545560000000009,-0x723+0x60a+0x15a+0.8956210000000056,-0x1b62+0xc4*0x26+-0x181+0.35708600000000246,-0x1ffc+-0x505*0x2+-0x27b*-0x11+0.5664480000000012,0xbe*-0x3+-0x1*-0x1f79+0xb5*-0x29+0.4768329999999992,0x2078+-0x190+-0x1*0x1edf+0.2693290000000008),_0x17143c[_0x5a8c8a(0x189)+_0x5a8c8a(0x4ba)](-0x1f61+0x17d5+0x14d*0x6+0.5069600000000065,0x5cb*0x1+0x1cb+-0x78d*0x1+0.20095300000000016,-0x19c1+0x1*0x13a5+0x32f*0x2+0.5543090000000035,-0x1*-0x179f+-0x1137+-0x65f+0.18172299999999986,0x6d*0x1+0x12e8+0x13*-0x101+0.6188810000000018,-0x1f6*0x1+0x4d5*-0x6+0x1efd+0.2116389999999999),_0x17143c[_0x5a8c8a(0xc1)](0x2d5*-0xd+-0x8b*-0x17+0x1896+0.6251809999999978,-0x2386+0x129+0x2266+0.21793899999999944),_0x17143c[_0x5a8c8a(0x189)+'eTo'](0x3*-0x332+-0x1*0x26bb+-0x33d*-0xf+0.6940460000000002,-0x12a1+-0x1388+0x1319*0x2+0.2478529999999992,0xb10+0xd29+-0x3*0x7fd+0.7134120000000053,0x21c1+0xbbe+0x422*-0xb+0.29486600000000074,0x52a+0x1*-0x2519+-0x7b*-0x43+0.6832809999999938,0xa9*0x29+0x1837*-0x1+-0x2d1+0.35898000000000074),_0x17143c[_0x5a8c8a(0x189)+'eTo'](-0x1b0a*-0x1+0x411+-0x1ee5+0.2264380000000017,0x5*0x6ec+0x1412+-0x2ba*0x14+0.6647269999999992,-0x198d+-0xc43+0x25f9+0.8513629999999992,0x2*0x63a+-0x16f0+-0x15*-0x83+0.6542069999999995,-0x13*0x10f+0x957*-0x2+0x26e8+0.5580560000000006,-0xf85+0x65*0x1b+0x7a*0xb+0.3274200000000036),_0x17143c['bezierCurv'+_0x5a8c8a(0x4ba)](-0x3e7+0x1*-0x1b9d+0x1fa1+0.07245400000000046,0x1*-0x1a0a+-0x2345+0x3db0+0.4641989999999936,0x39a*-0x9+0xc91*-0x3+0x504*0xe+0.7628969999999988,0x741*-0x1+-0x1a66+0x2209+0.013767999999998892,0xf33*-0x2+0x1b35+-0x3*-0x119+0.5944929999999999,-0xd13*0x2+0x1fc0+-0x539+0.5711100000000044),_0x17143c[_0x5a8c8a(0x189)+'eTo'](0x35*0x89+0x6c6*0x3+-0x17*0x21d+0.3875770000000003,-0x1158+0x2083+-0xecc+0.1991299999999967,0x1*-0xbb+0x710+-0x647+0.10318299999999958,0x3ad+0x18b4+-0x1c05+0.8271469999999965,-0x2458+-0x3e*-0x33+0x1805+0.7413100000000004,0x12e1+-0x22ca+-0xb5*-0x17+0.45516000000000645),_0x17143c['bezierCurv'+_0x5a8c8a(0x4ba)](0x2*-0xc35+-0x154*-0x10+0x331+0.6595279999999999,-0x15a8+-0x66+0x1668+0.4252270000000067,0x4a3*-0x2+-0xac+-0x3*-0x353+0.6315530000000003,-0x2*0xcb5+-0x4*-0x32+0x18fc+0.3696699999999993,0x5d9*0x4+-0x881+-0xedc+0.6573849999999997,-0x2485+0x251*-0x4+-0xf61*-0x3+0.2884899999999959),_0x17143c[_0x5a8c8a(0xc1)](0xbdb+-0x4a*0xd+-0x812+0.6573849999999997,0x75b*0x5+0x33*0x39+0x2*-0x17e4+0.2824899999999957),_0x17143c[_0x5a8c8a(0x189)+_0x5a8c8a(0x4ba)](0x97c+0x1ff2+-0x2967+0.6789110000000003,0x1ed+-0x46*0x7f+0x2127+0.21835699999999747,-0x3dc+-0x268f*-0x1+0x2*-0x1156+0.7219569999999997,-0x1eb2+0x9e8*-0x3+-0xf31*-0x4+0.19272300000000087,-0x2*-0x12dc+-0x988+-0x1c29+0.786524,0x1f66+-0xc03+-0xb*0x1bb+0.20559000000000083),_0x17143c['bezierCurv'+_0x5a8c8a(0x4ba)](0x17*0x89+-0x981+0x1*-0x2c0+0.10104899999999972,0x461+0xf*-0x18b+-0x131f*-0x1+0.6330499999999972,0xb*-0x37f+-0x1721*-0x1+0x88*0x1d+0.35746500000000125,-0x1*0x1939+0xa86*0x3+-0x5fc+0.08188300000000481,-0x7f*-0x5+-0x807+0x5a6+0.555771,-0xe1a+0x1ae*0x11+0x4b2*-0x3+0.5520900000000069),_0x17143c[_0x5a8c8a(0x3a8)](),_0x17143c['beginPath'](),_0x17143c[_0x5a8c8a(0x5db)]=_0x32cad8,_0x17143c[_0x5a8c8a(0x363)]=-0x167e*0x1+-0x7*0x3c2+0x30cc+0.170223,_0x17143c[_0x5a8c8a(0x5bd)](-0x19ca+0x1af+0x185e+0.2387070000000051,-0x18e5+0x1875+0xe7+0.9255500000000012),_0x17143c[_0x5a8c8a(0x189)+'eTo'](-0x1*-0x66e+-0x4*-0x4f+0x3b9*-0x2+0.21949699999999694,-0x8*-0x4a3+-0x264+-0x2243+0.23271699999999385,0x8*-0x483+-0x40*-0x4a+0x11c5+0.13787299999999902,-0xce*0x4+0x176e+-0x13cc+0.5740700000000061,0xe96+-0x113c+0xed*0x3+0.9938360000000017,-0x25f5+0x13b7+0x12a1+0.949610000000007),_0x17143c[_0x5a8c8a(0x189)+_0x5a8c8a(0x4ba)](0x240c+-0x1669+0x85*-0x1a+0.920659999999998,-0x258d*-0x1+0x1b33+0x1*-0x405d+0.9068769999999944,-0x75f+0xb5*0x20+-0xf20+0.9055970000000002,-0x59d*0x4+0x1*-0x1101+0x27d8+0.8491769999999974,0x214c+-0x1f3*-0x8+0x1041*-0x3+0.9486459999999965,-0x831+-0x14cc+0x14*0x178+0.7765100000000018),_0x17143c[_0x5a8c8a(0xc1)](0x1d30+0x2242+-0x3f51+0.9486459999999965,-0x65f+0x2217+0x1*-0x1b55+0.7705100000000016),_0x17143c[_0x5a8c8a(0x189)+'eTo'](0x2*0xe21+-0x364*0x9+0x1*0x263+0.9916929999999979,0xb*0x173+0x16c3*-0x1+0x735+0.6978569999999991,0xe21+0x248d+0x50e*-0xa+0.049804000000001736,0x2603+0xaff+-0x309f+0.6807569999999998,-0x2*0xaa9+-0xe*0x22+0xba8*0x2+0.12297999999999831,0x1838+0x1*0xb49+-0x231e+0.7192100000000039),_0x17143c['bezierCurv'+_0x5a8c8a(0x4ba)](-0x1a50+-0x3d*0x5e+-0x9c7*-0x5+0.6414990000000032,0x382+-0x1277+0xf5e+0.5615499999999969,-0x26d5+-0x987+0x3095+0.1471039999999988,-0xb53+0x13*-0x65+-0x66b*-0x3+0.39748299999999404,0x285+-0xb*0x22b+-0x1598*-0x1+0.6397970000000015,-0x1*0x2674+0x2244+0x4a5+0.22701000000000704),_0x17143c[_0x5a8c8a(0x189)+_0x5a8c8a(0x4ba)](0x1*0x1ec6+-0x26*0xd1+0x84+0.8791279999999944,-0x19cc+0x1*0x1740+0x301+0.3480420000000066,0x1423+0x263b+-0x6b*0x8b+0.16234099999999785,0x12b6+0x16fc*-0x1+-0x4bb*-0x1+0.3480420000000066,-0x5*-0x37c+0x552*0x4+0x1*-0x266f+0.4016720000000049,-0x1*-0x9f5+0x8*-0x29d+0x92*0x14+0.22701000000000704),_0x17143c[_0x5a8c8a(0x189)+_0x5a8c8a(0x4ba)](-0x21d*-0xe+0x2099+-0x3dde+0.08375700000000563,-0x1b1d+0xdf3+0xd99+0.30773700000000304,0x55*-0x5d+0x1bbd+0x380+0.8304059999999964,-0x15eb+-0x1189+-0x5*-0x7f9+0.3414499999999947,-0x17*0x119+-0x164*0x17+0xe3*0x41+0.6416200000000032,0x101f*-0x1+0x272+-0x258*-0x6+0.3281499999999937),_0x17143c[_0x5a8c8a(0x189)+_0x5a8c8a(0x4ba)](0x25fa+0x8c0+-0x2e52+0.7147930000000002,0x4*-0xb0+-0x197a+0x5*0x5b9+0.29394999999999527,-0x17e1+0xc54+-0xbf5*-0x1+0.7707500000000067,-0x12b6+0x8f*0x32+-0x8d5+0.3110499999999945,0x1a3+-0x16*0x63+0x51*0x17+0.8094899999999967,-0x1c1*0xc+-0x18*-0x162+-0xb1*0x11+0.3794500000000056),_0x17143c[_0x5a8c8a(0xc1)](0x353*-0x6+-0x20d8+0x3532+0.8154899999999969,-0x14e9+0x1dd1+-0x885+0.38545000000000584),_0x17143c[_0x5a8c8a(0x189)+_0x5a8c8a(0x4ba)](-0x1*-0xe37+-0x137d*0x1+-0x5ae*-0x1+0.8542230000000046,0xa0*-0x9+0xd6f+-0x76c+0.4581100000000049,0x1224+-0x38f+0xbf*-0x13+0.8391570000000002,0x6*0x40c+-0x1c6d+0x488+0.5158100000000019,0x1*-0x9bd+0x1ba7+-0x1f2*0x9+0.7702900000000028,-0x71c+-0xd2f+0x1*0x14ae+0.5585499999999968),_0x17143c['bezierCurv'+'eTo'](-0x1*0x40f+-0x196c*0x1+0x1dd8+0.4067270000000036,0xb12+0x25c7+0x3*-0x1025+0.33687000000000467,0x9*-0x36a+0x46b*0x2+0x2*0xb1b+0.12064499999999612,0x1b19+0x1*-0x1e38+0x390+0.0874069999999989,0xb80+0x2*0x1057+0x232*-0x14+0.912042999999997,-0xd70+-0x5e9*-0x1+-0x6*-0x155+0.8101599999999962),_0x17143c[_0x5a8c8a(0x189)+_0x5a8c8a(0x4ba)](0x15be+-0x1e70+0x8f8+0.6756319999999931,-0x3e1+0x97*0x35+-0x1aeb+0.955797000000004,-0x1*-0x409+0x1d*-0x12b+-0x1e1c*-0x1+0.520616000000004,0x1*0x1cd5+0x715+-0x2372+0.2020650000000046,0x9f+-0xa31+0x9d8+0.49236700000000155,-0x210b+-0x1a61+0x3be4+0.4768799999999942),_0x17143c[_0x5a8c8a(0x189)+_0x5a8c8a(0x4ba)](0x1*0x138b+-0xc1+-0x1285*0x1+0.9844499999999954,0x1d*0x31+-0x3*-0xb78+-0x2778+0.9944129999999944,0x1*0x1786+-0xf15+-0x2*0x416+0.5755350000000021,0xd4f+-0xffd*-0x1+-0x1cc9*0x1+0.26619999999999777,-0x22f9+0x161*-0x4+0x28c2+0.2656199999999984,0x16f*0x7+-0x5*0xf8+-0x4a9+0.2922399999999925),_0x17143c[_0x5a8c8a(0x189)+_0x5a8c8a(0x4ba)](0xbdd*-0x1+0x2*-0x33d+0xc*0x18d+0.2656199999999984,-0x24c2*0x1+-0x37*0x9b+0x4697+0.3049729999999897,0x1*-0x162e+-0x1d4*-0x9+0x5ff+0.25919299999999623,-0x1*0x2209+-0x3*-0x166+0x1e5f*0x1+0.3113400000000013,0xec1+0x21e1+-0x305d+0.24634000000000356,0x1*-0x1f6a+0xfce*-0x2+0x3f8e+0.3113400000000013),_0x17143c[_0x5a8c8a(0xc1)](-0x1055+-0xd*0x233+-0x1*-0x2d31+0.07200600000000179,0x85*-0x25+0x1485+-0xc4*0x1+0.3113400000000013),_0x17143c[_0x5a8c8a(0x189)+_0x5a8c8a(0x4ba)](-0x1*-0x1d1b+-0x1*0x575+-0x1762+0.9773069999999962,0x1cce+0x1*-0x1a35+-0x211+0.31533999999999196,0x590+0x12d*0x1f+0x1*-0x29bf+0.9256539999999944,-0xca0+0x66*0x57+-0x1582*0x1+0.27046699999999646,0x2436+0x1*0x5ab+-0x299d+0.9170490000000058,-0x296+-0xeb+0x409+0.17671999999998889),_0x17143c['lineTo'](0xb9*0x2b+-0x2230+0x60*0x9+0.6002270000000038,0x1*0xcfe+-0x14e2+-0xd6*-0xa+0.5088499999999954),_0x17143c[_0x5a8c8a(0x189)+_0x5a8c8a(0x4ba)](-0x1*0xfe9+0xdba+-0x1*-0x272+0.5803530000000023,-0x106*-0x5+0x212f+-0x25d5+0.26731900000000053,0xb36+0x2427+-0x2f1a+0.44589899999999716,-0xd79*0x1+-0x19bb+0x4*0x9eb+0.05040200000000539,-0x19d4+0xbc8+-0x14d*-0xb+0.23867500000000064,0x2*-0x1f7+0xec0+0xa5b*-0x1+0.9255500000000012),_0x17143c['fill'](),_0x17143c[_0x5a8c8a(0x416)](),_0x534ef7['_baseTextu'+'re'][_0x5a8c8a(0x526)](),_0x534ef7[_0x5a8c8a(0x5fa)+_0x5a8c8a(0x5ba)]=![],_0x534ef7['_smooth']=!![],this[_0x5a8c8a(0x352)+_0x5a8c8a(0x206)+_0x5a8c8a(0x443)][_0x1d94be]=_0x534ef7,this[_0x5a8c8a(0x352)+_0x5a8c8a(0x206)+_0x5a8c8a(0x443)][_0x1d94be];},ImageManager[_0x5db7a1(0x18f)+'Graphic_D1'+'2']=function(_0x3519b9){const _0x2adf86=_0x5db7a1,_0x4ce2b1={'VOwuB':_0x2adf86(0x18a),'kEguk':function(_0x4c8b7a,_0x2269ff){return _0x4c8b7a!==_0x2269ff;},'daxms':_0x2adf86(0x1de),'XlYQt':_0x2adf86(0x458)},_0x234675=_0x4ce2b1['VOwuB']['format'](_0x3519b9);this[_0x2adf86(0x352)+_0x2adf86(0x206)+'phic_D12']=this['_cache_cre'+_0x2adf86(0x206)+_0x2adf86(0xbd)]||{};if(_0x4ce2b1['kEguk'](this[_0x2adf86(0x352)+_0x2adf86(0x206)+_0x2adf86(0xbd)][_0x234675],undefined))return this[_0x2adf86(0x352)+_0x2adf86(0x206)+_0x2adf86(0xbd)][_0x234675];const _0x2d5f3c=ImageManager['DICE_ROLL_'+_0x2adf86(0x4cd)],_0x570cb2=ColorManager[_0x2adf86(0x314)+'r'](_0x3519b9,_0x2d5f3c[_0x2adf86(0x3a7)]),_0x2bea0b=ColorManager['darkenColo'+'r'](_0x3519b9,_0x2d5f3c['color1']),_0x3578e1=ColorManager[_0x2adf86(0x314)+'r'](_0x3519b9,_0x2d5f3c[_0x2adf86(0x128)]),_0x5cb49f=ColorManager[_0x2adf86(0x314)+'r'](_0x3519b9,_0x2d5f3c[_0x2adf86(0x4e9)]),_0x23d291=new Bitmap(0xdbe*-0x1+0x1abb+-0xc73,-0x1482+0x373+0x119f),_0x398a33=_0x23d291[_0x2adf86(0x256)];return _0x398a33['save'](),_0x398a33[_0x2adf86(0x268)](),_0x398a33['fillStyle']=_0x2bea0b,_0x398a33['lineWidth']=0xa99+-0xb*0x15d+0x466+0.070004,_0x398a33[_0x2adf86(0x1cf)]=_0x4ce2b1[_0x2adf86(0x42c)],_0x398a33[_0x2adf86(0x4a0)]=_0x4ce2b1['XlYQt'],_0x398a33[_0x2adf86(0x5bd)](0xd86+-0x1*0x1f87+-0x3*-0x617+0.5329320000000024,-0x2f5+-0x3d7*0x4+0x1253+0.8293409999999999),_0x398a33[_0x2adf86(0xc1)](0x2b*0xe3+-0xadf+0x1b27*-0x1+0.035928999999999434,0x1f88+-0x45*0x4d+0x8*-0x157+0.40419100000000086),_0x398a33[_0x2adf86(0xc1)](-0x149*-0x19+0x1d75*0x1+0x3d93*-0x1+0.14371199999999984,0x2b6+0x10c+0xb*-0x53+0.9850300000000018),_0x398a33[_0x2adf86(0xc1)](-0x16cb+0x1*0x1bc9+0x55*-0xf+0.14371199999999984,-0x1901*0x1+-0x39b*0x2+-0xf*-0x22c+0.05389099999999303),_0x398a33[_0x2adf86(0xc1)](-0x1b2c+-0x189*0xd+0x2f3b+0.40718499999999835,0x1*0x1b3d+0x1b7c+-0x363a+0.9491000000000014),_0x398a33[_0x2adf86(0xc1)](0x1666*-0x1+0x1bd2+-0x529+0.2754469999999998,-0x7*-0x16d+-0x7d1*0x1+-0x19c+0.7245499999999936),_0x398a33['lineTo'](-0x2da+0x82c+-0x26*0x21+0.7724500000000063,0x1be6+-0x17b*0xf+-0x530+0.2065900000000056),_0x398a33[_0x2adf86(0xc1)](0x39*0x9b+-0x1031+-0x11cb+0.17964000000000624,0x1*0x369+0x2*0x95f+-0x15c9+0.31137599999999566),_0x398a33[_0x2adf86(0xc1)](-0x31*-0x59+0x2*0x88+-0xb*0x199+0.8652700000000095,-0x7a9+-0xde*0x19+-0x54*-0x5a+0.6706569999999985),_0x398a33[_0x2adf86(0xc1)](0x1f49+0x722*-0x5+0x4ce+0.7155699999999996,-0x1b02+-0x6*0x56e+0x1*0x3ba5+0.08981999999999957),_0x398a33['fill'](),_0x398a33[_0x2adf86(0x268)](),_0x398a33['fillStyle']=_0x3578e1,_0x398a33[_0x2adf86(0x363)]=0xc18+0x1d8b*-0x1+0x1173+0.070004,_0x398a33['lineCap']=_0x4ce2b1['daxms'],_0x398a33[_0x2adf86(0x4a0)]=_0x4ce2b1[_0x2adf86(0x36c)],_0x398a33[_0x2adf86(0x5bd)](-0x196f+-0x11ed*-0x1+0x7c6+0.8473050000000057,0xd7a+0x1ea+-0x166*0xb+0.8293409999999999),_0x398a33[_0x2adf86(0xc1)](0x19cf+0x259+-0x1c0d+0.6646719999999995,-0x1c23+-0x24*-0xeb+-0x4da+0.7185629999999996),_0x398a33[_0x2adf86(0xc1)](-0x8b*0x3b+0x156+-0xf*-0x20c+0.848088,0x1*0x178c+-0x1ca7+0x1*0x54d+0.0024629999999987717),_0x398a33[_0x2adf86(0xc1)](-0x1*0x158a+0x18a6*-0x1+-0x7*-0x69d+0.9790419999999997,-0x1*0x65+0x15c5*0x1+-0x1525+0.10179600000000022),_0x398a33[_0x2adf86(0xc1)](0xbb2+-0x2*0x36d+-0x493+0.9015650000000051,0xd61*0x1+0xc5c+-0xcd*0x20+0.2937359999999991),_0x398a33['lineTo'](0x92*-0x1d+-0xdb7+0x1eae+0.3439900000000051,-0x1*-0x23b1+0xbb*0x1f+0x3a1b*-0x1+0.21294300000000277),_0x398a33[_0x2adf86(0xc1)](-0x2688+-0x10d2*-0x1+0x585*0x4+0.052577999999996905,0x2*0x8ec+-0x8*0x29d+0x37b+0.6816900000000032),_0x398a33[_0x2adf86(0xc1)](0x2*0x1385+-0xc2+-0xa*0x3c9+0.32523999999999376,-0x1650+0x19ea+0x1*-0x31a+0.5048400000000015),_0x398a33[_0x2adf86(0xc1)](-0x1d8e+-0x19e1+0x37f5+0.5509000000000128,0x5b*-0x7+-0x1*-0x157d+-0x12a3*0x1+0.05389099999999303),_0x398a33[_0x2adf86(0xc1)](-0x5f6+-0x1*0x9ff+0x107a+0.9221499999999878,-0x2*-0xdc1+-0x202*-0xb+-0x3166+0.29939999999999856),_0x398a33[_0x2adf86(0xc1)](-0x11fb+-0x1*0x2077+0x32e0+0.344309999999993,0x1221*0x1+0x56*0x5+-0x13c0+0.40419100000000086),_0x398a33[_0x2adf86(0x3a8)](),_0x398a33[_0x2adf86(0x268)](),_0x398a33[_0x2adf86(0x5db)]=_0x5cb49f,_0x398a33['lineWidth']=-0x11f5+0x181f+-0x62a+0.070004,_0x398a33['lineCap']=_0x4ce2b1[_0x2adf86(0x42c)],_0x398a33['lineJoin']=_0x4ce2b1[_0x2adf86(0x36c)],_0x398a33[_0x2adf86(0x5bd)](-0x11cc+0x82b+0x9e6+0.911477000000005,0x1270+0x197e+-0x2bd2+0.453638999999999),_0x398a33[_0x2adf86(0xc1)](0x939+0x29*-0xde+0x2*0xd38+0.6756080000000004,-0x1b20+-0x13d+0x1c96+0.8520240000000001),_0x398a33[_0x2adf86(0xc1)](0x184c+-0x17e4+0x1*-0x3e+0.6804559999999995,0xdb3+-0x1b9f+0xe56+0.6455700000000064),_0x398a33[_0x2adf86(0xc1)](-0x2036+0x21bf*0x1+-0x12b+0.14152799999999388,0xb00+-0x11b+-0x97a*0x1+0.7014700000000005),_0x398a33[_0x2adf86(0xc1)](-0xa80+-0x729+0x1217*0x1+0.2578500000000048,0x25e*0x5+0x31f*-0x2+-0x55d+0.13021499999999975),_0x398a33[_0x2adf86(0x3a8)](),_0x398a33[_0x2adf86(0x268)](),_0x398a33[_0x2adf86(0x363)]=-0x5*0x4a2+0x1*0x8+0x1722+0.179435,_0x398a33[_0x2adf86(0x5db)]=_0x570cb2,_0x398a33[_0x2adf86(0x5bd)](0x2*-0x8d2+-0x852*0x2+0x2264+0.2535090000000011,0x94+0x6a5*-0x3+-0x1367*-0x1+0.8081040000000002),_0x398a33['bezierCurv'+_0x2adf86(0x4ba)](-0x369+0x10b1+-0x70*0x1e+0.5290279999999967,-0x1*0x4f7+-0x1cd9+0x21d8+0.7888169999999999,-0x2*0x6cb+0x312*0x4+0x183*0x1+0.2096560000000025,0xae6+0x21b8+0x1*-0x2c9a+0.6724350000000001,0xb7b+0x9*0x3ae+0x2c57*-0x1+0.2953940000000017,-0x33*0x5d+0x47*0x47+-0x95*0x2+0.458958),_0x398a33[_0x2adf86(0x189)+'eTo'](0x14d3+-0x2342+0xeb3+0.16931099999999333,-(-0x5*-0x477+0x15d7+0x2c2a*-0x1+0.150709),0x3*0x929+0x1*0x23ea+0x14*-0x328+0.6969629999999967,-(0x7d*-0x6+0x22ec+-0x1ffe+0.164256),-0x2407+-0x183*0x16+-0x9f0*-0x7+0.7202489999999955,0x49*-0x33+0x1f66*0x1+-0x35f*0x5+0.486046),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](-0x2468+-0x146c+0x2*0x1c94+0.5525109999999955,0x6dd*0x5+0x13e2+-0x1*0x362f+0.6227479999999996,-0x1f17*0x1+0x2*0x475+0x168e+0.37798499999999535,0x1f29+-0xc04+0xe9*-0x15+0.7820319999999992,0x512+0x323*-0x7+0x1151+0.19666999999999746,-0xcfb*-0x1+0x6aa*-0x5+0x11*0x133+0.9638969999999993),_0x398a33['bezierCurv'+'eTo'](-0x84*-0x6+-0x265*-0x6+-0x1107+0.10194300000000567,0x76e*-0x1+-0x1061+-0x2*-0xbee+0.26195599999999963,-0x1*0x165a+-0x3*0xa58+-0x1ae9*-0x2+0.004953000000000429,-0x15e3+-0x23c0+-0x1b*-0x223+0.025168000000000745,-0x7b9*0x4+-0x2*0x5a7+-0x33*-0xd6+0.905699999999996,0x1d*-0x98+-0x18e1+0x2a28+0.2535329999999991),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](0x1*-0x2228+-0x536*0x1+0x1*0x27d6+0.6955870000000033,-0x4a*0x65+-0xf25*-0x1+-0xe26*-0x1+0.8843199999999989,0x1dc2+0x26cb*0x1+-0x16af*0x3+0.4696270000000027,-0x14d6+-0x13e7+0x28e1+0.5286550000000005,-0x93a+-0xd*-0x2c5+-0x1a3f+0.22782000000000835,0x1*0x2209+0x2338+-0xe*0x4ef+0.18653799999999876),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](0xdf1+-0x1363*-0x1+-0x20cb+0.6672100000000114,0x659*-0x2+0x1589+-0x8a6+0.15779299999999807,0x4eb+-0x1e91*0x1+-0x346*-0x8+0.006689999999991869,0x5*0x681+-0x19a*0x4+0x52f*-0x5+0.45164199999999965,-0xb88+-0x1ca0+0x28b1+0.9998999999999967,0x963*0x4+-0x15a5+-0xfb2+0.05966200000000299),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](-0x1b*0x17+0x1043+-0xd4d+0.9908330000000092,0x24f7+-0x146c+-0x104a+0.9213770000000068,-0x4a*0x69+0x236f*0x1+0x184*-0x3+0.9840670000000102,-0x7*0x1a5+-0x26*0xa5+-0x37*-0xa9+0.7808349999999962,-0x1*-0x2f9+-0x800+0x590+0.9796000000000049,0xbd1+-0x387*-0xb+0x1*-0x3243+0.6380350000000021),_0x398a33['bezierCurv'+'eTo'](0x441*0x6+-0xb60+0x29*-0x55+0.9725999999999999,-0x1ba8+-0x1d80+0x25*0x18e+0.6118529999999964,-0x2d3*-0xa+0xca3*-0x3+0xa33+0.8661199999999951,0x1af*0x11+0x1031+-0x2c71*0x1+0.9057040000000001,0x600+-0x594+0x2*0xd+0.8699900000000014,0x2df+0x9*-0x13f+0x8ba+0.6424300000000045),_0x398a33[_0x2adf86(0x189)+'eTo'](0x1*0x39+-0x2*-0x12f7+-0x25a8+0.550849999999997,0x19ec+0x74*0x49+0x28c*-0x17+0.6770970000000034,0xbc+-0x11b1+0x116d+0.24076300000000117,-0x7b4*-0x4+0x3ed+0x2d*-0xc3+0.7185369999999978,0xb2b+0x2b8+-0xd73+0.9397299999999973,-0xbe9+-0x13b9+0x2022+0.7667500000000018),_0x398a33['bezierCurv'+_0x2adf86(0x4ba)](0x85c+-0x1*0x12e2+0x2*0x57b+0.08423700000000167,0x2*-0x2b+-0x1*-0x11a1+0xe*-0x133+0.9499570000000119,0x1df4+0xe8f*-0x2+0x1*-0x68+0.9526429999999948,-0x153+0x43*-0x2f+-0x12*-0xc9+0.7696200000000033,-0x798+-0x4*0xbf+-0x9*-0x139+0.54495,0x1dcc+-0x51*0xe+-0x18db+0.22574000000000183),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](0x1d91+-0x1*0x21f+0xa5*-0x2a+0.866581999999994,0x1a6c+0x11ad+-0x1fb*0x16+0.344380000000001,0xf17*-0x1+0xc45+0x326+0.19500499999999477,0xc03+-0x1*0x17c1+-0x25*-0x55+0.465280000000007,-0xa7*0x12+-0x1e10+0x2a15+0.5302199999999999,-0x385+-0x1fb+0x60f+0.5884399999999914),_0x398a33[_0x2adf86(0x189)+'eTo'](-0xa03+0xee8+0x4a0*-0x1+0.8599880000000013,-0x2162+-0x1b0a+0x3cfc+0.13035999999999603,0x7a6+0x1bb4+0x1*-0x2316+0.20333700000000476,-0x264c+0x156e+-0x17*-0xc2+0.13709299999999303,-0xe13+-0x40f+-0xb*-0x1ac+0.5602659999999986,-0x8*0xd5+-0x1c0f+-0x46*-0x81+0.6086400000000083),_0x398a33['bezierCurv'+_0x2adf86(0x4ba)](-0x1*-0x197b+-0x20b3+0x76d+0.7913730000000001,0x3fc+-0x1bbb+0x184a+0.47193300000000704,-0x9d1+0xbf*-0x12+0x1768+0.02247899999999703,0x523+-0x2*-0x278+-0x4c6*0x2+0.3374870000000101,0x10fc+0x2*0xd7c+-0x2bd8+0.25358599999999853,0x68d+-0xa6b+0x3b*0x13+0.20529999999999404),_0x398a33['bezierCurv'+_0x2adf86(0x4ba)](0x257f*0x1+-0x74+0x31*-0xc1+0.7327249999999985,-0x459+0x22f2+-0x1e17+0.7108000000000061,-0x1*0x1813+0x1316+0x516+0.5649230000000003,-0x796+0x1*-0xd36+-0x13*-0x11f+0.545659999999998,0x50b*-0x7+0xf1*0x29+-0x5*0xa4+0.5261220000000009,-0x455*0x1+-0x1718+0x94f*0x3+0.12987000000001103),_0x398a33['bezierCurv'+'eTo'](0xaaa+-0x1*-0x1ea1+0x1a*-0x196+0.16107399999999927,-0x1*0x22b+-0x269*-0x3+0x1*-0x49d+0.30429700000000537,0xac*0x25+-0x1a2a+0x1*0x155+0.3779849999999998,0x5a5+0x2*-0x39b+0x1f9+0.6125519999999938,0x23f5+-0x1289+-0xd*0x157+0.1768559999999999,0x80f*0x3+-0x9fb*-0x1+-0x1*0x21c8+0.05463600000000213),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](-0x2102+0x1a0f+0x1*0x6f3+0.420953,0x1b75+-0x11b9+-0x11*0x8d+0.011426999999997633,-0x166d+-0x191f+0x2f8c*0x1+0.040738,-0x1ff3*0x1+-0x1d54+-0x4*-0xf69+0.8778989999999993,0x226f+0x605*0x5+-0x24e*0x1c+0.036211,-0x6a3*-0x3+-0xbed+-0x7a0+0.654049999999998),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](-(0x2077*-0x1+0x84d*0x1+0x182a+0.000006),0xb*-0x24b+0x13a2+-0x5e5*-0x1+0.7717059999999947,-(0x74e+-0x1aaa*0x1+0xb1*0x1c+0.009056),0x3*0x628+0x3*0x2d9+-0x1ac2+0.10839099999999746,-0x1564*0x1+-0x1*0x1354+0x28b8+0.009061,-0x87+-0x9b9+-0x19*-0x6b+0.6641040000000018),_0x398a33[_0x2adf86(0x189)+'eTo'](0xb39+0x47*0xa+-0xdff+0.013509,0x65*0x63+0x34c+-0x1*0x2a29+0.1828390000000013,-0x1a49+0xcc4+0xd85+0.552147,-0xd65+-0x5*-0x6b1+-0x10*0x13e+0.7106070000000031,0x1c03*0x1+-0x1b22+-0xe0+0.6249750000000001,0x254*0xb+-0xbdb+0x9*-0x182+0.24740599999999802),_0x398a33['bezierCurv'+_0x2adf86(0x4ba)](-0x18ee+0x4c1*0x7+-0x850*0x1+0.27906800000000054,-0x2*0xc10+-0x18eb+-0x3*-0x1065+0.8017790000000034,0x1be4*0x1+0x959*-0x2+0x1*-0x921+0.0010559999999983916,-0x2b3*0x8+-0x2247+0x37f9+0.19809000000000054,0x1b2f+0xb*0x65+-0x1f6e+0.7909410000000001,-0x1759+-0x1*-0x1+-0x1*-0x1767+0.436337),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](-0x23df*0x1+0x9*-0x90+0x2908+0.7414790000000018,-0x1*0x6b7+-0x63*-0x1+-0x662*-0x1+0.12668200000000063,-0x15a3+-0x4eb*-0x1+0x10d2+0.895703000000001,0x10*-0x22d+-0x65*0x2b+0x7c*0x6b+0.25056799999999946,-0x139f+-0x1af*-0x10+-0x7b*0xf+0.2536139999999989,-0x1dcd+-0x2f5*-0x1+-0x1*-0x1ae4+0.8079959999999993),_0x398a33[_0x2adf86(0x5bd)](0xb3f+-0xcd5+-0x2*-0xda+0.12742599999999982,0x237a+-0x15*0xad+-0x14cb*0x1+0.5380899999999968),_0x398a33[_0x2adf86(0xc1)](0x75*-0x29+0x56f*-0x1+0x186f*0x1+0.9927820000000054,0x2b*-0x9d+-0x19f2+0x34db+0.819500000000005),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](0x2239+0x1*-0x111c+0x1*-0x10d9+0.6110489999999942,0xd84+0x26ad+-0x4b2*0xb+0.01780500000000984,0x13d3+-0x1274*0x1+-0x2f*0x6+0.27806699999999296,0x371+-0xb59*0x3+0x77*0x43+0.01780500000000984,-0x7f*0x38+-0x1c4f+0x385c+0.9006499999999988,-0x160*0xd+0xf64*0x1+0x56*0x9+0.819500000000005),_0x398a33[_0x2adf86(0xc1)](-0x226*-0xf+-0x1*0x103d+-0xf92+0.5555200000000013,-0x2*-0x4cf+-0x12e7+0x9c7+0.6193800000000067),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](0x1ea5+0x1ef*0x8+-0x2db1+0.15110099999999704,-0x47*-0x6a+0x222a+-0x3f12+0.42548299999999983,0x4*-0x827+-0x17*0x3a+0x263e+0.669360999999995,0x4*-0x78d+-0x26d8*-0x1+-0x413*0x2+0.04834900000000175,-0xf5a+0x152c+0x565*-0x1+0.035650000000003956,0x2070+0x19fe+-0x39f1+0.5422999999999973),_0x398a33[_0x2adf86(0xc1)](0x1460+0x358+0x294*-0x9+0.5411000000000001,0x1627*0x1+-0xb60+-0xa6a+0.297694000000007),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](0x2205*-0x1+0x6*-0x43+0x241b+0.7840219999999931,0x1*-0x159d+0x517+0x2*0x871+0.9631329999999991,0x1*-0x17fd+0x807+0x6*0x2bf+0.9147220000000118,0x1*-0x1b7d+-0x4cd*-0x5+0x3d8+0.5600649999999945,-0x7*-0x447+0x2a*-0x6+-0x1c71+0.9145200000000102,0x10*0x1+0x1fa0+-0x1f54+0.14610000000000412),_0x398a33['lineTo'](-0x30*-0x2e+0x1def+-0x260b+0.9075200000000052,-0xce3*0x2+0x1*-0x1e62+0x385b+0.874208000000003),_0x398a33[_0x2adf86(0x189)+'eTo'](-0x41*-0xb+0x1117*-0x2+-0x1*-0x1fe7+0.9075200000000052,0xc*0xa8+0x8b5*0x1+-0x1062+0.4451830000000001,-0x188*0x15+-0x12*0x217+-0x464a*-0x1+0.7830429999999922,-0x1*-0x14a8+0x434+0x3b*-0x6b+0.05906099999999981,0x3*0x8c3+0x6b0+-0x4a3*0x7+0.534089999999992,0x5f3*-0x2+0x2d6*-0x1+0xeee+0.7158420000000021),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](0x50*0x35+-0x1*-0x993+0x43*-0x62+0.13792300000000068,0x1*-0x6f7+-0xe83*0x2+0x2425+0.545693,0x2b3*0x2+-0x1b*-0x101+0x1c*-0x125+0.7101100000000002,0x11ee+0x1be*0x13+-0x32ea+0.3349000000000011,-0xe0*0x10+0x684+-0x7ea*-0x1+0.25064999999999316,-0x136*-0x1d+0x1*0x232d+-0x4637+0.08346099999999979),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](-0xc2e*0x1+-0xad+0xd48+0.7753799999999984,-0x4*-0x430+0x25*-0xeb+0x114a+0.4263769999999987,0x3af+0x1e*0x4e+-0x19*0x7f+0.7908999999999935,0x46d+0x53*-0x73+0x20ed*0x1+0.7802749999999996,0x2665+0x2*-0x62+-0x129b*0x2+0.9557800000000043,-0x180e*0x1+0x24bf*-0x1+-0x93*-0x6a+0.5093129999999988),_0x398a33[_0x2adf86(0x189)+'eTo'](0x16c1+0x4a*-0x18+-0x7b9*0x2+0.17805699999999547,-0xe*0x254+0x3d*0x86+0xb7+0.3590610000000005,0x1*0x235d+0x10af+-0x89f*0x6+0.46811800000000403,0x1b13+0x15e8+-0x30f2+0.2336469999999995,0x200b+0x2*-0x87c+-0xece*0x1+0.8259630000000016,0x173a+-0x65*0x43+0x33a+0.13307100000000016),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](-0x1*-0x1b5+-0x1*-0x1e47+-0x1fb7+0.2613620000000054,0x1feb+-0x108+-0x1edf+0.9484539999999999,0x1*-0x19d9+0x92e+0x5a5*0x3+0.6524370000000062,-0xbb1*0x1+-0xb*-0x83+-0x30a*-0x2+0.9484539999999999,0x8e3+-0xff*-0x11+-0x198e+0.0878359999999958,0xc96+0xf4d+-0x1d*0xf6+0.13307100000000016),_0x398a33['lineTo'](-0x2*0x49f+-0x1325+0x1c81+0.4397449999999985,-0x321*-0xc+-0x4a2+-0xaf3*0x3+0.33996000000000137),_0x398a33['bezierCurv'+_0x2adf86(0x4ba)](-0x52*-0x2c+-0x1*-0x19ab+0xcb*-0x32+0.7819399999999987,0x1*-0x198e+-0x1*0xd39+0x26d8+0.5514119999999991,-0x211*-0x11+-0x2265+-0x9f+0.20686500000000052,0x4ff*0x4+0x9*0x23a+0x1*-0x27f5+0.9663240000000002,-0x1b*0x8a+-0x6*-0x373+-0x4*0x182+0.7966739999999994,0x851+0x14b6+-0x3*0x9a7+0.525424000000001),_0x398a33[_0x2adf86(0xc1)](-0x3a9*-0x5+-0x28d*-0x2+0x92*-0x29+0.41344199999999987,0x13c3*0x1+-0x1445+-0x5*-0x24+0.6345540000000014),_0x398a33[_0x2adf86(0x189)+'eTo'](0x5c*-0x2f+0xdf7+0x2f2+0.08702100000000002,0x3*-0x1cf+-0x1*0xae5+0x1085+0.0791409999999999,0xba8+-0x1967+-0x10f*-0xd+0.9110360000000002,0x1*0x1687+-0x265d+-0x1009*-0x1+0.6177550000000025,-0x12bb+0x1f91+-0x1*0xcd2+0.9110139999999998,-0x104b+0xb8d+0x4f2+0.172269),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](-0x110+0x296*-0x3+0x8d6+0.906561,0x1*-0x21e4+-0x2c2*0x1+0x1*0x24e6+0.6952809999999943,-0x1*-0xa36+0x1d28+-0x275a+0.9043340000000004,0x786*-0x1+-0x74a*-0x5+0x1*-0x1c9f+0.33571000000000595,0x959+0x5*-0x374+-0x1*-0x7ef+0.9043340000000004,-0x1*0x21fe+0x2697+-0x43f+0.09355600000000663),_0x398a33['bezierCurv'+_0x2adf86(0x4ba)](0x1bc8+-0x1*0x1d71+0x8f*0x3+0.9043340000000004,-0x14bb+0x1f96+-0x70*0x18+0.10966700000000174,0x10e4+-0x664*-0x6+0x1f*-0x1c8+0.7889090000000003,0x1815+0x242a+0x3be3*-0x1+0.47803000000000395,0x1cf5+0x2*-0xa54+-0x848+0.35244500000000034,-0x13d7*0x1+-0x8*0x149+0x1e7c+0.25705000000000666),_0x398a33[_0x2adf86(0x189)+'eTo'](0x1*0x137f+-0xfb1+0x3c1*-0x1+0.296227,-0x9f7+0x7e8+0x277+0.15879700000000696,-0x39e*0x6+-0x85c+0x1*0x1e25+0.17663900000000154,0x17e1*-0x1+-0x1*-0x11b7+-0x9*-0xbc+0.979257000000004,-0x15c0+-0x36a*0x5+0x26ee+0.9936819999999997,0x15a5+-0x24d4+0xec*0x11+0.7184299999999979),_0x398a33[_0x2adf86(0x189)+'eTo'](0x2529+-0x639*0x3+-0x1261+0.2833690000000004,0x1950+-0x1f*0xe5+-0x2e9*-0x1+0.11584299999999814,0x1c7+0xb3*0x34+0x2*-0x1303+0.6613199999999999,0x16ea+-0xc57+0x59*-0x1d+0.38906299999999305,0x7*-0x220+0x3aa*-0x1+0x18*0xc7+0.12753700000000023,0x4c0+-0x1*0x3e5+-0x5d+0.5380899999999968),_0x398a33[_0x2adf86(0x3a8)](),_0x398a33[_0x2adf86(0x268)](),_0x398a33[_0x2adf86(0x363)]=0x159+-0xf02*-0x1+-0x1*0x105b+0.179435,_0x398a33[_0x2adf86(0x5db)]=_0x570cb2,_0x398a33[_0x2adf86(0x5bd)](-0x7c9*-0x2+0x13*0x161+-0x2981+0.821109000000007,-0x77*0x20+-0x951+0x1838+0.1652950000000004),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](0x9*-0x6+-0x332+0x4*0xeb+0.8301759999999945,-0x1*-0x247f+0xf39+-0x21*0x191+0.07496800000000015,0x2192+0x7a9*-0x5+0x4ff+0.8799669999999935,0x288+-0xd45+-0x4*-0x2b1+0.029804999999999637,-0x904+-0x1d3*-0x1+0x775+0.9704830000000015,-0x870+-0x28*-0xe8+-0x1bc9+0.029804999999999637),_0x398a33['lineTo'](0xbc4+0x2c*0xaf+-0x2994+0.9771829999999966,-0x13c6+0x31*0xb5+0x5*-0x2f8+0.029804999999999637),_0x398a33['bezierCurv'+_0x2adf86(0x4ba)](-0x1015*-0x2+-0x73a+-0x18ab+0.05864800000000514,0x107*0x11+0x88d+-0x19fd*0x1+0.029804999999999637,0x213a+-0x2263+0x3d*0x6+0.1016479999999973,-0x1*-0x58f+-0x530+-0x4*0x16+0.07045299999999965,-0x1a19+-0x1d1+0x22b*0xd+0.106182000000004,0x459+0x5e4+-0xa36+0.15175099999999997),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](-0x27*-0xd3+-0x6*0x2de+-0xeac+0.6448199999999957,0xb0*-0x13+0x12e*0x19+-0x1*0x1061+0.9755050000000001,0x3*-0x54+0x2407+-0x22c5+0.1925109999999961,0xbb7*-0x2+-0x1591*-0x1+0x1f1+0.6953899999999997,0xd6a+-0xa7+-0xc7d+0.7492560000000026,-0xf23*-0x1+-0x1*-0x179f+-0x5*0x7bb+0.3114069999999991),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](0x171e+-0x414+-0x12c4+0.7809429999999935,0x1*-0x99f+0x1c5a+0x10*-0x12a+0.6817220000000006,-0x106*-0x1b+-0x19ee+-0x16e+0.9438920000000053,-0x93c+0x13*-0x11f+0xd4*0x25+0.9842970000000015,-0x133b+-0x1005+0x2387+0.2381029999999953,0x1124+-0x13*-0xfd+-0x59*0x67+0.21913199999999833),_0x398a33[_0x2adf86(0xc1)](0x687*-0x1+-0xbb9+0x12a9+0.24020000000000152,0x133b+0xb9a+0x43*-0x75+0.976739000000002),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](-0x2539+-0x515*-0x1+0x281*0xd+0.3171470000000056,0x23b3+-0x163+-0x1d*0x12d+0.039959000000003186,0x593+-0x2508+-0x2*-0xfef+0.32621299999999565,-0xf*-0x14+0x47e+-0x573+0.10995700000000141,0x3db*0x9+-0x1b5c+-0x377*0x2+0.267399999999995,0x8*0x4a7+0xe54+-0x3355+0.1867340000000013),_0x398a33[_0x2adf86(0xc1)](0x58d*-0x1+0x1*0x1b31+-0x1*0x153b+0.15196000000000254,-0x28f*0x5+-0x2221*0x1+0x2f23+0.3493119999999976),_0x398a33[_0x2adf86(0x189)+'eTo'](0x23*0x3b+-0x2468+-0x1*-0x1cc0+0.13849299999999687,-0xffc+-0x1*0x7c5+-0x4*-0x5fe+0.36737200000000314,0xf78*-0x2+-0x26ba+-0x4613*-0x1+0.12265999999999622,-0x843+-0x23cc+-0x1*-0x2c46+0.36960499999999996,-0xed3+0x228*0xf+0x2da*-0x6+0.1044600000000031,0x1227+0x15bd+0x7*-0x5ab+0.3560119999999998),_0x398a33['bezierCurv'+_0x2adf86(0x4ba)](-0x8*-0x204+-0x2a0+-0x3a*0x3a+0.9330750000000023,0x161*0x4+-0x820+0x2cb+0.10974999999999824,0x4*0x406+-0x171d*0x1+0x755+0.7254649999999998,-0x1d*0x6b+0x53*-0x43+-0xe5*-0x26+0.9470110000000034,0x19e5+-0xedc+-0xac5+0.48162999999999556,0x1b47*0x1+0x1a3*0xe+0x3*-0x10b1+0.867794),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](0x1*0x17f1+-0x1500+0x7*-0x62+0.5348529999999982,0x30e*0x2+0x6b*0x4f+-0xd01*0x3+0.24048700000000167,-0x10c1+-0xa9f+0x1ba3+0.0044010000000014315,-0xae7+-0xe2c+0x1930+0.1482759999999992,-0x156c+0x118b+-0x4*-0x109+0.09655999999999665,-0x59e*0x2+-0x1505+0x205d+0.01590699999999856),_0x398a33[_0x2adf86(0x189)+'eTo'](0x171+0x1a58+0x1*-0x1b86+0.644250999999997,-0x2fb*-0x3+0x25a6+-0x2*0x1741+0.25086100000000044,-0x1eb7+-0xf*0x12f+0x30bc+0.21910099999999488,0xb*-0x12f+0x35*-0x4a+0x1c65+0.3006569999999993,0x592+-0x1de0+0x1892+0.821109000000007,-0x234+0x2400+-0x21c5+0.1652950000000004),_0x398a33[_0x2adf86(0x3a8)](),_0x398a33[_0x2adf86(0x268)](),_0x398a33['lineWidth']=0x1132+-0x9*-0x447+-0x37b1+0.179435,_0x398a33[_0x2adf86(0x5db)]=_0x570cb2,_0x398a33['moveTo'](-0x1*-0x2188+0xa6*-0x13+-0x151e+0.04398300000000077,-0x11d8+0x79*0x31+-0x516+0.21053599999999761),_0x398a33['bezierCurv'+_0x2adf86(0x4ba)](-0x180a+-0x2ea+0x1b06+0.31812400000000096,-0xb32+0x20fb*0x1+-0x1591+0.731223,0x1f69+0xbde+0x15*-0x20f+0.6058450000000004,0x2b*-0xd3+-0x75c+-0x5b*-0x79+0.3422309999999982,0x98*-0x27+-0x10c6+-0x4*-0x9fd+0.9071439999999997,-0x7a0+-0x3b*-0x79+-0x140f+0.04356099999999685),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](-0xa6*0x4+0x2708+-0x246a+0.8211440000000003,-0xdd*0xc+-0x1d*0x1f+0xe13+0.00742699999999985,0x3*-0x81a+0x2*-0xef3+0x363a+0.7917189999999996,0x82*0x14+-0x1bb9+0x11c4+0.9464579999999998,-0x14a+-0x13*0x161+0x1b83+0.8188690000000003,0x193*-0x13+-0x89b+0x26b7+0.8606539999999967),_0x398a33['lineTo'](0x1*-0x4f6+-0x4*0x479+0xb7*0x20+0.8255489999999996,0x1fb5*-0x1+-0x2*-0x858+-0x1*-0xf38+0.8539540000000017),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](0xf45*-0x1+0x2180+-0x1235+0.8572309999999996,0x22*0xc5+0x1872+-0x3269+0.7500909999999976,0x5*0x5db+0xb*0x12+-0x1*0x1e07+0.9251230000000001,-0x1506+0xc3*-0x7+0x16*0x135+0.7117039999999974,0x1351+-0x22*0x80+0x125*-0x2+0.029223,-0x2*0x5c9+-0x131+0xcf6+0.7387919999999966),_0x398a33[_0x2adf86(0x189)+'eTo'](0x183a+0xfb*0x13+-0x2ace+0.5698279999999993,0xca8+-0x17a1*0x1+0xb2e+0.31489299999999787,-0x1dfb+-0x3d4+0x21e3+0.17154000000000025,-0xe14+-0xc1c+0x2*0xd33+0.8751880000000014,-0x3*0x74f+0x251*0x1+0x13b6+0.8343589999999992,-0x2342+-0x115f+0x34d9+0.41967799999999755),_0x398a33[_0x2adf86(0x189)+'eTo'](0x1*-0x1571+0x4b8+0x10d4+0.24179300000000126,0xc7*-0x1a+0x1af8*0x1+-0x68a+0.5147460000000024,0x742+0x1067+-0xc9*0x1e+0.6692029999999995,-0x3a7*0x1+-0x1cff+0x106f*0x2+0.43877200000000016,-0x1*0x32f+-0x1837+0x2*0xdc1+0.01574199999999948,-0x12e*0x1a+-0x179c+0x3680+0.2096829999999983),_0x398a33[_0x2adf86(0xc1)](0x3*0x72f+-0x1ebc+0x11*0x8e+0.40290099999999995,-0x1*0x1987+-0x7*0x215+0x283a+0.703679000000001),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](0x1f54+-0x5*-0x7c2+-0x45df+0.4798509999999965,0x5b6+-0xcc7*0x1+-0x1*-0x731+0.6540120000000016,0x15e2+-0x2*-0xff7+0x3*-0x11db+0.5454840000000019,0x2240+-0x809+-0x1a17+0.6675660000000008,0xd75+0x142+-0xe78*0x1+0.5998000000000019,-0x8b*0x16+0x7ec*0x1+0x213*0x2+0.7443389999999965),_0x398a33['lineTo'](0x27c*-0x7+0x1b65*0x1+-0x9c2+0.7084249999999983,0xd58+0x604+0x2*-0x99e+0.8933729999999969),_0x398a33[_0x2adf86(0x189)+'eTo'](-0x1c41+-0x1a57+-0x65*-0x8b+0.717492,0x3f1*0x1+0xdb9+-0x118a+0.9068600000000018,0x106*0xb+-0x17f*0x4+0x21*-0x27+0.7152579999999986,0x2*-0x1cd+0xfe5+-0x1bd*0x7+0.9181499999999971,-0x1027*0x1+-0xd63+0x1dc9+0.7017250000000033,0x18a2+0x23fa+0x9e*-0x62+0.9272429999999972),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](-0xee5+0x1f1e+-0x1*0x1005+0.34053300000000064,-0xe*0x248+-0x93*0x1a+-0x2f07*-0x1+0.7741899999999973,0x22d4+0x6c9+-0x7*0x5ec+0.02234200000000186,0x29*-0x49+-0xa*-0x18d+-0x39f+0.6843610000000027,0x1*-0x223d+-0x1*0x827+0x1*0x2a81+0.7471509999999988,-0x278*0x5+0xa06+0x28d*0x1+0.6577559999999991),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](-0x1d0a+0x4ac*-0x1+0x21d1+0.9207609999999988,-0xd57+-0x17b+0xf0f+0.11418199999999956,0x5d*0x43+-0x1*-0x21b5+-0x39f3+0.8363669999999992,0x95d+-0xed5+-0x5b3*-0x1+0.9829110000000014,-0x15a4+0x1ca+0x13f2+0.04392400000000052,-0x1cd8+-0xf7a+-0x8e9*-0x5+0.21066600000000335),_0x398a33[_0x2adf86(0x3a8)](),_0x398a33['beginPath'](),_0x398a33[_0x2adf86(0x363)]=-0x2*-0x431+-0x9b9*-0x2+-0x1bd4+0.179435,_0x398a33[_0x2adf86(0x5db)]=_0x570cb2,_0x398a33[_0x2adf86(0x5bd)](-0x1*-0xbd3+-0x3f0+-0x6*0x13e+0.48668999999999585,-0x254c+0x31*-0x95+0x420d+0.5111589999999993),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](-0x2f1+0x1eb0+0x1*-0x1b55+0.3220969999999994,0xbb6*-0x3+-0x10c9+0x3435+0.1406029999999987,-0xcc2+0x16a+0xbbd+0.2412429999999972,-0x601*-0x5+0x1*0x184d+-0x35fb+0.9032700000000062,0xcda+-0x3f2+-0x888+0.24412800000000345,0x1*-0x21b+0x255+0x2b+0.7991600000000005),_0x398a33['bezierCurv'+_0x2adf86(0x4ba)](-0x1788+0x1*0x1dad+-0x5c5+0.23966099999999813,-0x2243*0x1+0x1fb9+-0x1*-0x2ef+0.8217599999999976,-0x1f6e+0xbbc*-0x3+-0x2*-0x2181+0.2260780000000011,0x1c22+-0x580+-0x1*0x163d+0.8284929999999946,-0x20f*0x9+0x97b+0x96c+0.20337800000000072,-0x727*0x1+0x13*-0xb+-0x85d*-0x1+0.8193600000000032),_0x398a33[_0x2adf86(0xc1)](0x1d28+0x3d7+-0x1*0x209f+0.02685300000000268,0x1*0x19f3+0x70d+-0x209b+0.7651599999999945),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](0x2a*0x43+-0x1*0x16a9+0xc0a*0x1+0.9499040000000036,0xdb3*-0x2+-0x1*-0x1d06+-0x13b+0.7380270000000024,-0x30b+0x2303+0x1*-0x1f99+0.9227439999999945,0x20*-0x53+0x1207+0x2*-0x3a1+0.6883469999999932,0x8a8+-0x270b+0x1ec2+0.9453730000000036,-0xeb4*0x1+-0x1bd2+0x2aeb+0.6161199999999951),_0x398a33[_0x2adf86(0xc1)](-0xc5b*-0x2+0x164a*-0x1+-0x200+0.0307899999999961,0x1ed9+0x109c+-0x2f3b*0x1+0.7768859999999975),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](0x2030+-0x679*0x1+-0x194b*0x1+0.324506999999997,0x32b+0xb5*0x35+0xd79*-0x3+0.7397599999999969,-0x1*0x94+-0x79*-0x1d+-0xcb4+0.15528000000000475,0x21*0x44+-0x3e*-0x5c+-0x1ed4+0.9419650000000033,-0xf13+-0xd4f+0xe68*0x2+0.20345000000000368,-0x1873+-0x712+0x7d*0x41+0.6904710000000023),_0x398a33['lineTo'](-0xcd3*0x3+0x2*-0x304+-0xf01*-0x3+0.7011200000000031,0x1561+-0x226f+-0xd*-0x105+0.8334559999999982),_0x398a33[_0x2adf86(0x189)+'eTo'](-0x9d5+-0x1783+0x21da+0.778066999999993,0x1*0xce1+0x249e*-0x1+0x17f*0x10+0.8153959999999998,0xc19+0xd99+-0x1930+0.8278569999999945,0x12c4+0x17d3+-0x2a64+0.8424929999999975,-0xf3e+0x2062+-0x10a2+0.8504900000000077,0x1ae3+-0x2315+-0x1*-0x865+0.914746000000001),_0x398a33['lineTo'](0x48b*0x1+-0x1a3*0x1+-0x266+0.9115899999999897,0xc7*0x10+-0x18ad+0x7*0x1c7+0.12474100000000021),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](0xb*0x11c+0x125+-0xcd7+0.9206570000000056,-0xb2*-0x29+0x2*0x5dc+-0xda*0x2f+0.1518480000000011,0xa49*0x1+0x1*-0x485+0x1*-0x542+0.9115899999999897,-0x2*0x1163+-0x1219+0x7*0x795+0.16991399999999857,-0x3e*-0x7b+-0x1f0d+0x97*0x3+0.8843899999999962,-0x1*-0xd4b+-0x1778+-0xa61*-0x1+0.1789410000000018),_0x398a33[_0x2adf86(0x189)+'eTo'](0x115*0x19+0x31c+-0x1dad+0.5701099999999997,-0x142*-0x1c+0x221a+-0x451c+0.6221239999999995,-0x1173+0x2698+-0x14af+0.26261300000000176,0x106e+-0x5*-0x71d+-0x6*0x8a1+0.23240100000000297,0x21ef+-0x21a9+0x1*0x29+0.9619,-0x66*0xe+0x1*0x883+0x2b3*-0x1+0.009774000000000171),_0x398a33['bezierCurv'+_0x2adf86(0x4ba)](-0x5b*-0x46+0x1af3+-0x891*0x6+0.7355869999999953,-0x2*-0xd79+-0x1cc3+0x20d+0.1091300000000004,0xe*0x124+0x1c5c+-0x2be5+0.5771670000000029,-0x230d*-0x1+-0x2*0x6d4+-0x1529+0.27622399999999914,-0xbae+-0xe*0xcd+0x1753+0.4866399999999942,-0x1a8+0x1344+0x4*-0x458+0.5110560000000035),_0x398a33[_0x2adf86(0x3a8)](),_0x398a33[_0x2adf86(0x268)](),_0x398a33['lineWidth']=0x161b*0x1+-0xb55+-0xac6+0.179435,_0x398a33[_0x2adf86(0x5db)]=_0x570cb2,_0x398a33[_0x2adf86(0x5bd)](-0xc89+0x77*0x13+-0x3d1*-0x1+0.5367369999999987,-0x1ab2+0x1*-0x20bf+-0x5*-0xbf0+0.5933640000000011),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](0x197*0x12+-0x11d3+-0xaa9+0.8506959999999992,-0x267e+-0x775*0x2+0x35b5+0.647317000000001,0x1a1b+-0x3*-0x5ac+-0x287*0x11+0.05375800000000197,-0x1a02+0x556+0x301*0x7+0.6877219999999937,-0x1*-0xffd+0x11*-0x1dd+0xfdd+0.14592400000000083,-0xa*-0x1c0+-0x1155+-0x1f*-0x2+0.714579999999998),_0x398a33['bezierCurv'+'eTo'](-0x1fc5+0x49*-0x5a+0x399c+0.5068600000000032,0x9e*0x10+-0x1409+0xa93+0.7021469999999965,-0x1838+0x4*0x56+0x15*0x119+0.3043559999999985,-0x72c+-0x72d*0x1+0xec4+0.8082019999999943,0x10cb*-0x2+0x1691+0xb31+0.6163390000000035,0x228f+-0x1ada*-0x1+-0x3cfd+0.6071100000000058),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](0xc7*0x29+0x2*0x757+-0x2e66*0x1+0.9813359999999989,0x14c9+0x47*0x3e+-0x2589+0.012822999999997364,0xbb+0x2644+-0x26dc+0.28748999999999825,-0x261+-0xc97+0xf6f+0.484020000000001,-0xe8d+0xe*0x11b+0xcf*-0x1+0.5348000000000006,-0x19f+-0x7*-0x153+-0x729+0.020700000000005048),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](-0x6*-0x167+-0x21e3+0x1997+0.4714330000000011,0xef4+-0x25bb+0x1744*0x1+0.0974729999999937,-0x6e3+0x14ea+0x1*-0xde9+0.3990089999999995,-0x1e53+0x111a+0xdb6+0.10650699999999347,0x22*0xe3+-0x202c+0x112*0x2+0.31752600000000086,0x2*0x617+-0x1107+0x556+0.04779999999999518),_0x398a33[_0x2adf86(0xc1)](0x3c*-0x24+0x24d7+-0x1c49+0.3108259999999987,0x1cd4+-0x8d1+0x11*-0x126+0.04080000000000439),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](0x4*-0x1e0+-0x1*-0x801+-0x1*0x63+0.22936100000000081,-0x20e6+-0x1bd2+-0x2*-0x1e9a+0.9820670000000007,0x19f*-0x6+-0x25f6+0x2fce+0.21578699999999884,0x73*0xe+0x3*0x7b5+0x1*-0x1ced+0.9098070000000007,0x7*-0x1af+0x2241+-0x165a+0.2701059999999984,-0x165a+-0xe2*-0x1+0x5*0x464+0.8240200000000044),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](0xa44+-0x1*-0x1e1+-0xc04*0x1+0.9364670000000004,0xcd*-0x2f+-0x484+0x2a9d+0.8944469999999995,0x1*0x1b5e+0x135c+-0x2d*0x109+0.5666160000000033,0xbe3+0x24c7+-0x303a+0.9829330000000027,-0x3*-0xa5d+-0x9*0x123+-0x14b3+0.16055300000000017,0x2*0x1348+0x248+-0x286d+0.08947999999999467),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](0x9ca+-0x1*-0x107+-0xaa8+0.35092199999999707,-0x1f*-0x95+-0x159d+0x3fc+0.7737889999999936,0x8a7+0x61*-0xb+-0x453+0.40246299999999735,-0x1806+-0x322*0x2+0x1eb4+0.3917639999999949,-0x19ca*-0x1+0x2640+0x1*-0x3fe1+0.3031270000000035,-0x1ac6+0x16da+0x456+0.032730000000000814),_0x398a33[_0x2adf86(0x189)+'eTo'](0x133f+0x79b+-0x1ab5+0.3380420000000015,-0xd45+-0x107*-0xa+0x35a+0.9970610000000022,0x22e5*-0x1+0x435+0x1ed1+0.34805300000000017,-0x1140+0x9*0x2c6+-0x769+0.8483810000000034,-0x9d6*0x1+0x361+-0x1d*-0x3a+0.3331620000000015,-0x20*-0x2+-0x5*-0x2c9+-0xdee+0.5866889999999998),_0x398a33['bezierCurv'+_0x2adf86(0x4ba)](0x22e6+-0x1*0x392+-0x1f37+0.31964200000000176,-0x1d*-0xe3+0x4*0x5a5+-0x300c+0.5505560000000003,0x21d*0x7+-0xedf+-0x31*-0x1+0.330959,-0x1482+-0x146f+0x2930+0.5279719999999983,0x2396+-0xf33+0xa23*-0x2+0.3671119999999988,-0x6*-0x2ad+-0x2174+0x11a5*0x1+0.5189390000000031),_0x398a33[_0x2adf86(0xc1)](-0x1a18+-0x149e*0x1+-0x1*-0x2ed3+0.3738120000000009,0x1*-0x2250+0x8f7+0x1998+0.512239000000001),_0x398a33[_0x2adf86(0x189)+'eTo'](-0x17ce+-0x10af*-0x1+0x73c+0.45076099999999997,0x8c9+-0x3*0x669+0xab1+0.4896590000000032,-0x2b*0x82+-0x49*0x61+0x319c+0.505078000000001,-0x1*-0xf11+-0x1*0x4f9+-0x9d9+0.5167560000000009,0x1a97+-0xbb9*0x3+-0x8b1*-0x1+0.5367609999999985,0x801*-0x1+0x98*0x22+-0xbf0+0.5935289999999966),_0x398a33[_0x2adf86(0x3a8)](),_0x398a33[_0x2adf86(0x268)](),_0x398a33['lineWidth']=0xd08+0x3*-0xc6d+0x183f+0.179435,_0x398a33[_0x2adf86(0x5db)]=_0x570cb2,_0x398a33[_0x2adf86(0x5bd)](-0x8*0x12+-0x54+-0x115*-0x1+0.5795069999999996,0x2*0xcf4+0x4*0x796+-0x37d6+0.7713300000000061),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](0x7ed+-0x1*-0x18f1+-0x20ac+0.43951700000000216,-0x1dd1+-0x9b*0x1+0x1ed6+0.6132769999999965,-0xfff+-0x185d+-0xd85*-0x3+0.31310599999999766,0x1*-0x2217+-0xf67+0x31e8+0.520700000000005,-0x23e*-0x1+-0x22b9*-0x1+-0x24c3+0.20027499999999776,0x2593+0x637+-0x2b60+0.4936000000000007),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](0x1*0x14a4+-0x293*0x3+-0xcaa+0.7703340000000054,0x1*-0x2643+0x224f+0x45e+0.11424700000000598,0xbd5+0x1d82+-0x2908+0.5078699999999969,0x111*-0xd+-0x26a9+0x34ef+0.5971569999999957,0x23*0xd8+0xe36+-0x2b61+0.4128809999999987,0x1aa8+-0xe7a+-0x112*0xb+0.9423299999999983),_0x398a33[_0x2adf86(0x189)+'eTo'](-0x265e+-0x207b*0x1+0x4737+0.9608999999999952,-0xd28+-0x517*-0x1+0x879+0.8746299999999962,-0xd*0x2d6+0x169b+0xea3+0.05401799999999923,0x3ad+0x5*0x406+-0x1762+0.7687700000000035,-0xdf8+-0x1*0x34a+0x11a2+0.8348179999999985,0x18f*-0x1+0x1de1*0x1+-0x1be7+0.1032600000000059),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](-0x2510+0x6*0x3db+0xe52+0.29296600000000694,-0x1*0x696+-0xa34+0x113b+0.0012270000000000891,-0x1*0x1b89+-0x4eb*-0x7+0x97*-0xb+0.8484299999999934,0x1*0x1873+0x1*0x443+-0x1c40+0.8179030000000012,0x1*-0x98e+-0xf85+0x197e+0.5012100000000004,0x1*-0x1ca2+0x126a*-0x2+0x41f2+0.5532900000000041),_0x398a33[_0x2adf86(0x189)+'eTo'](0x8a3+0x3b8*0x6+-0x1e88+0.5147429999999957,-0x62+-0x798+-0x1*-0x876+0.5803570000000065,-0xc3*-0x2c+0x79*-0x47+0x76+0.5102100000000007,0x1*0x2590+0x157e+-0x15*0x2ca+0.6006900000000002,-0xda*-0x15+0x82c+-0x1*0x19a3+0.48761000000000365,0x1d3*-0x5+-0xc7d+0x1618+0.6142899999999969),_0x398a33[_0x2adf86(0xc1)](0x1974+0x1912+0x7f*-0x65+0.338239999999999,-0x6d6+0x18ff*0x1+0x11ad*-0x1+0.7226699999999937),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](0x1a3b+0x23bb+-0x1*0x3d8b+0.27034000000000447,-0x1bc3+0x17*0x1a5+0x265*-0x4+0.7723369999999932,-0x3*-0x74d+-0x14*-0x101+-0x2990+0.20923000000000513,0x1301+-0x2471+0x8f6*0x2+0.7656029999999987,0x154c+0x1a*-0xd0+0x3*0x15+0.154910000000001,-0xd*0xa9+0x2615*0x1+-0x1d04+0.7024700000000053),_0x398a33[_0x2adf86(0xc1)](-0x565*0x7+-0xaae+0x30ce*0x1+0.7319559999999967,-0x52*-0x4f+0x4fc+-0x5f9*0x5+0.09492000000000189),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](0x434+0xa07+0x32*-0x47+0.5373469999999969,-0xce3+-0x10e3+-0x60a*-0x5+0.8690670000000011,-0x968+0x1*0x2523+0x1b5e*-0x1+0.29067100000000323,-0x78*0x50+-0x21af+-0x1*-0x479b+0.7493670000000066,-0xab1+0x2200+-0x16f3+0.9919299999999964,0x74b+-0x1*0x143b+0xd5c+0.7358200000000039),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](0x1f19+0x3*0x534+-0x2e66+0.7070310000000006,0x48d+-0x1a91+0x1670+0.20292700000000252,0x20b3+0x1*-0x575+-0x1afc+0.7910320000000013,-0x17f6+0x3da*-0x9+0x3b0b+0.7084169999999972,-0x22d3+0xb07+-0xe*-0x1b7+0.24393100000000345,0x5*0x23+-0x35*0x25+0x765+0.2522900000000021),_0x398a33[_0x2adf86(0x189)+'eTo'](0x1*-0xd7b+-0x1*-0x11c5+0x1*-0x416+0.5601219999999998,0x259e+-0x1*0x2234+-0x2ff+0.1890899999999931,-0xfc5+-0xced+0x739*0x4+0.9351550000000017,-0x26d7+-0x2d0+-0x1*-0x2a12+0.049092999999999165,-0xdac+0x13a+0xca3+0.36903099999999966,0x3*0x211+0x23e4+0x1*-0x29ad+0.8323000000000036),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](-0x7*-0x47+-0x1*-0x9eb+0x1*-0xbab+0.3617440000000016,0x1d4c+-0x201b*0x1+-0xb*-0x4b+0.8323000000000036,-0x1e*-0x127+-0x265e+-0x1*-0x3fd+0.3550109999999975,-0x3bb*-0x7+-0x1f7d+0x5ca+0.8284210000000058,-0xc74+0x47c+0x1*0x829+0.3513670000000033,-0xc44*-0x1+-0x3f6*-0x3+-0x17bc+0.8221249999999998),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](0x100f+0x2*-0x989+0x334+0.3477239999999995,-0x2e1+0x53*0x1+-0x17c*-0x2+0.8158289999999937,-0x2*0x41+0x1111+-0x105e+0.3477239999999995,-0x1cb2+0x1c6+0x1*0x1b56+0.8080709999999982,-0x97*0xa+0x9a4*-0x1+-0xfbb*-0x1+0.3513670000000033,0x1*0x1d9f+0xf55*-0x1+-0xde0*0x1+0.8017750000000063),_0x398a33['bezierCurv'+'eTo'](0x8*-0x42d+-0x1*-0x1fdf+-0x2*-0xdd+0.3550109999999975,0x11*0x131+0x265a*0x1+-0x1*0x3a31+0.7954790000000003,-0x1*-0xdc9+-0x616*-0x1+-0x13ae+0.3617440000000016,-0x25b6+0x114f+0x1*0x14d1+0.7916000000000025,-0x18fe+0x1bd5+-0x2a6+0.36903099999999966,0x260+0x22e1+-0x1*0x24d7+0.7916000000000025),_0x398a33[_0x2adf86(0x189)+_0x2adf86(0x4ba)](-0xec3+0x2310+0xd*-0x18c+0.4414469999999966,0xa*-0x133+-0xce9+-0x1*-0x1951+0.7916000000000025,0x107d+0x39*-0x61+0x54d+0.511605000000003,0x22*-0xe5+0x1e02+-0x7*-0x1e+0.7848670000000055,-0x1dd7+-0x13fd+0x3205+0.5795049999999975,-0x370+-0x13a3*0x1+-0x7*-0x35b+0.7713999999999999),_0x398a33[_0x2adf86(0x3a8)](),_0x398a33['restore'](),_0x23d291[_0x2adf86(0x3be)+'re'][_0x2adf86(0x526)](),_0x23d291[_0x2adf86(0x5fa)+_0x2adf86(0x5ba)]=![],_0x23d291[_0x2adf86(0x3d7)]=!![],this[_0x2adf86(0x352)+_0x2adf86(0x206)+'phic_D12'][_0x234675]=_0x23d291,this[_0x2adf86(0x352)+'ateDiceGra'+_0x2adf86(0xbd)][_0x234675];},ImageManager['createDice'+'Graphic_D2'+'0']=function(_0x36f902){const _0x255c57=_0x5db7a1,_0x9eeb24={'jtYJF':'color-%1','grOkY':function(_0x4aab4a,_0x285109){return _0x4aab4a!==_0x285109;},'xVXWb':_0x255c57(0x1de),'TeyPs':_0x255c57(0x458)},_0x2396d9=_0x9eeb24[_0x255c57(0x4b3)][_0x255c57(0x13e)](_0x36f902);this[_0x255c57(0x352)+_0x255c57(0x206)+_0x255c57(0x3a5)]=this[_0x255c57(0x352)+_0x255c57(0x206)+_0x255c57(0x3a5)]||{};if(_0x9eeb24[_0x255c57(0x11d)](this[_0x255c57(0x352)+'ateDiceGra'+_0x255c57(0x3a5)][_0x2396d9],undefined))return this[_0x255c57(0x352)+_0x255c57(0x206)+_0x255c57(0x3a5)][_0x2396d9];const _0x55ca45=ImageManager[_0x255c57(0x229)+'RATIOS'],_0x2c5b88=ColorManager[_0x255c57(0x314)+'r'](_0x36f902,_0x55ca45[_0x255c57(0x3a7)]),_0x4a6463=ColorManager['darkenColo'+'r'](_0x36f902,_0x55ca45[_0x255c57(0x2a5)]),_0x2df7de=ColorManager[_0x255c57(0x314)+'r'](_0x36f902,_0x55ca45['color2']),_0x45ed06=ColorManager[_0x255c57(0x314)+'r'](_0x36f902,_0x55ca45['color3']),_0x1186bd=new Bitmap(-0x1445+-0xce4+0x21a9,0x6b*-0x33+-0x2180+-0x1*-0x3761),_0x1c52f5=_0x1186bd[_0x255c57(0x256)];return _0x1c52f5[_0x255c57(0xfe)](),_0x1c52f5[_0x255c57(0x268)](),_0x1c52f5['fillStyle']=_0x4a6463,_0x1c52f5[_0x255c57(0x363)]=-0x420+0x2f2+0x12e+0.070004,_0x1c52f5[_0x255c57(0x1cf)]=_0x9eeb24['xVXWb'],_0x1c52f5[_0x255c57(0x4a0)]=_0x9eeb24[_0x255c57(0x41c)],_0x1c52f5[_0x255c57(0x5bd)](0xb*0x72+-0x1b6d+-0x11*-0x157+0.2429779999999937,-0x984+-0x565+0x4f9*0x3+0.4452349999999998),_0x1c52f5[_0x255c57(0xc1)](0x1e6c+0x1ee2*0x1+-0x1*0x3d4b+0.556705,-0x228c+0xb2b+0x1785+0.6785179999999968),_0x1c52f5[_0x255c57(0xc1)](0x127*-0x20+0x15c3+0xf1f+0.22293999999999992,-0x1e83*-0x1+0x22*0x3b+0x25ee*-0x1+0.36802000000000135),_0x1c52f5[_0x255c57(0xc1)](-0x3*0x102+-0x22*0x8+-0x455*-0x1+0.7983910000000023,0x1dbd+0x1*-0xe4b+-0xee4+0.0458900000000142),_0x1c52f5[_0x255c57(0xc1)](-0xd*-0x206+0x373+-0xea2*0x2+0.5961400000000054,-0x1bd1*-0x1+-0x1454*0x1+-0x5*0x16a+0.8126100000000065),_0x1c52f5['lineTo'](-0x421+-0x1139+0x82*0x2b+0.7069599999999951,-0xb*0x26b+0x1ce9+-0x116*0x2+0.23393000000000086),_0x1c52f5[_0x255c57(0x3a8)](),_0x1c52f5['beginPath'](),_0x1c52f5[_0x255c57(0x5db)]=_0x2df7de,_0x1c52f5['lineWidth']=-0x162f*0x1+0x52*0x44+0x67+0.070004,_0x1c52f5[_0x255c57(0x1cf)]=_0x9eeb24[_0x255c57(0x4f8)],_0x1c52f5[_0x255c57(0x4a0)]=_0x9eeb24['TeyPs'],_0x1c52f5['moveTo'](-0x1*0x12ba+-0xf2f+0x2229+0.2429779999999937,-0xf0b+0x9*-0x327+-0x2*-0x15bf+0.0064640000000011355),_0x1c52f5['lineTo'](-0x24b*0x9+0x3eb*0x5+0x111+0.4462039999999998,0x1cf9*0x1+-0x11f4+-0xadf+0.9153519999999986),_0x1c52f5[_0x255c57(0xc1)](0x2*0x46d+0x84e+-0x1118+0.8943480000000008,-0x1f98+0x1*-0x20bf+-0xe3*-0x49+0.6992000000000047),_0x1c52f5[_0x255c57(0xc1)](0xf9d+-0x23ce+-0x1471*-0x1+0.020685000000000286,-0x35f*-0x1+0x4*0x1c1+-0x9d9+0.04460000000000264),_0x1c52f5[_0x255c57(0xc1)](-0x26b*-0x1+0x1*0x1418+-0x1*0x1615+0.9247299999999967,0x1*0x7bb+-0x46a+0x1*-0x2ed+0.8103499999999997),_0x1c52f5['lineTo'](0x3*-0x10c+-0x21a0+0x2a9*0xe+0.03942999999999586,0x4d*0x11+0x7*0x346+-0x1be1+0.234575999999997),_0x1c52f5[_0x255c57(0x3a8)](),_0x1c52f5[_0x255c57(0x268)](),_0x1c52f5['fillStyle']=_0x45ed06,_0x1c52f5[_0x255c57(0x363)]=0xf1*0x2+0x2fd+-0x1d*0x2b+0.070004,_0x1c52f5['lineCap']=_0x9eeb24[_0x255c57(0x4f8)],_0x1c52f5[_0x255c57(0x4a0)]=_0x9eeb24['TeyPs'],_0x1c52f5['moveTo'](-0xa7d*0x3+-0x8e5+0x289b+0.9745509999999982,0xc8e+0x1fa+0xb9*-0x14+0.7485029999999995),_0x1c52f5['lineTo'](0x2339+0xf37+0x7c*-0x68+0.5044910000000016,0x740+-0x11de+0x581*0x2+0.7559799999999939),_0x1c52f5[_0x255c57(0xc1)](-0xe3*-0x1a+0x9c7*-0x1+-0xd*0xfd+0.6586800000000039,-0xb*0x205+-0x139b+0x2*0x151b+0.5987999999999971),_0x1c52f5[_0x255c57(0x3a8)](),_0x1c52f5[_0x255c57(0x268)](),_0x1c52f5['lineWidth']=-0x1*-0x1bd9+0xea*0xa+-0x24fd+0.171604,_0x1c52f5['fillStyle']=_0x2c5b88,_0x1c52f5[_0x255c57(0x5bd)](0x1634+-0x979+-0xc80+0.02566399999999902,0x15*-0xd4+0x260b*-0x1+0x1*0x37fd+0.3339200000000062),_0x1c52f5[_0x255c57(0x189)+'eTo'](-0x719+0x1b69*0x1+0x6*-0x35c+0.5964529999999968,0x3e+-0x171b+0x1760+0.7845499999999959,0x22b*-0x3+-0xb15+0x11ac+0.1476690000000005,-0x1527+0x4d*0x10+-0x10*-0x10d+0.26743999999999346,-0x1241*0x1+0xf*-0x9+0x12cb+0.6988850000000002,-0x1*0x257d+-0x21f0+0x47db+0.7438700000000011),_0x1c52f5['bezierCurv'+_0x255c57(0x4ba)](0xe63*-0x1+-0x150c+0x2371+0.2680389999999999,-0x1031+-0x3*0x58d+0xa7*0x33+0.9313899999999933,-0xa04+-0x9df+0x13e4+0.241657,0x68*0x3b+-0x4c6+-0x1b*0xb2+0.8351830000000007,-0x469+-0x13e8+0x1851+0.619739,-0xcf8+-0x6e5*0x5+-0x17ee*-0x2+0.4552500000000066),_0x1c52f5['bezierCurv'+_0x255c57(0x4ba)](-0x1dfd*0x1+-0x1027+0x2e24+0.215275,-0x1c1*0x9+-0x38e*0x8+-0x36f*-0xd+0.5653899999999936,0x1a55+-0x6*-0x15d+-0x2283+0.013043,-0x3c8+0x1*-0x926+0xd57+0.15321699999999794,0x3a4*-0x1+0x1*-0x2702+0x67*0x6a+0.013043,-0x2*-0x104d+0x11d1+-0xc81*0x4+0.21872999999999365),_0x1c52f5[_0x255c57(0x189)+_0x255c57(0x4ba)](0x17ae+-0x11c5+-0x59*0x11+0.013043,-0xc*-0x1cb+0x381+-0x18b3+0.0297300000000007,-0xed3+-0xbee+0x1ac1+0.008695,0x2*0x1c5+-0xf3*0x27+0x21b7+0.8407279999999986,0x141+-0xd0a+0xbc9,0x2054+-0x1998+-0x151*0x5+0.6517229999999969),_0x1c52f5[_0x255c57(0x189)+'eTo'](0x2d7*0xb+-0x129d+-0x1*0xca0,-0x13b0+-0x41f+0x17f3+0.9262579999999971,0x12fb+-0x2*-0x8ee+-0x24d6+0.21774099999999996,-0x5*0x4e7+-0x1073*-0x1+0x832+0.8671130000000034,-0x1594+0xc41*-0x1+0x21d8+0.6532239999999998,0x2e1+-0x1*0x190d+-0x21*-0xad+0.4742859999999993),_0x1c52f5[_0x255c57(0x189)+_0x255c57(0x4ba)](0x11de*0x1+0x19b2+0x1*-0x2b79+0.028359999999999275,-0x117d+0x6c4+0xacf*0x1+0.38756700000000066,0x2465+-0x1ec+-0x1*0x224f+0.07514100000000212,0x4*0x943+-0x253d+0x14*0x3+0.49859400000000065,-0xba7+-0x3*-0x8b+-0x521*-0x2+0.7935680000000005,-0x25*-0xd+0x1492+-0x7*0x335+0.807368),_0x1c52f5[_0x255c57(0x189)+_0x255c57(0x4ba)](0x899+0x110b*-0x1+0x8b0+0.8637289999999993,-(0x12a1*0x2+0x1079+-0xabf*0x5+0.374814),-0xd5*0x24+0xd26+-0xb*-0x18d+0.14046999999999343,-(0x4a5+0x47*0x29+-0x401*0x4+0.258746),0x1b46*0x1+-0x15ae+-0xd*0x69+0.6237930000000063,-0x2133+-0x704+0xd68*0x3+0.1555740000000001),_0x1c52f5['bezierCurv'+_0x255c57(0x4ba)](0x5ea*-0x2+0x16*-0x12+0x5*0x2be+0.955442000000005,-0x1a6+-0x1afd+0x1caf+0.1391220000000004,-0xf66*-0x2+-0xde4*-0x1+-0x2c47*0x1+0.9630850000000066,-0x4af*0x1+-0x28*0x60+0x13c5+0.9550139999999985,0x3*-0xbf0+-0x1*-0x23ad+-0x9f*-0x1+0.646720000000002,0x7*0xe3+-0x870+0x25c+0.6032500000000027),_0x1c52f5['bezierCurv'+'eTo'](-0x1581+0xd80+0x880+0.15831000000000017,0x9d*-0x1d+0x1*-0xc7d+-0x615*-0x5+0.034770000000001744,-0xab4*-0x1+0x26bb+-0x30ef+0.01290000000000191,0x644+-0xcc+-0x553+0.6785539999999983,0x3f7*0x1+0x1*-0x1fff+0x43*0x6d+0.999849999999995,-0x13c2+-0xb*0x313+0x189*0x23+0.4964420000000018),_0x1c52f5['bezierCurv'+_0x255c57(0x4ba)](0x145f+0x2*-0x9f7+-0xe*-0x1+0.9041770000000042,-0x1467+-0x1*-0x4c1+0xfe4+0.3861619999999988,0x21aa+0x1*-0x1ba6+-0x585+0.8780770000000047,0x7b7+-0x9*0x5a+-0x43a+0.8696379999999948,0x18e0+-0x8*0x169+-0xd19+0.9215499999999963,-0x1618+-0x749+0x1*0x1dc9+0.9468700000000041),_0x1c52f5[_0x255c57(0x189)+_0x255c57(0x4ba)](0x1c3+-0x1*0x1135+0xff1+0.9275499999999965,-0x5*0x4e5+0x17*0x14b+-0x26c*0x2+0.10007000000000232,-0x99e+-0x80e+0x1229+0.9122700000000066,-0x2*-0x26f+-0x215e+-0x1*-0x1ced+0.7572799999999944,0x1*-0xb2d+0x2*0x12c1+-0x19da+0.05492999999999881,-0xfb5+-0x2208+-0x2*-0x1916+0.38868999999999687),_0x1c52f5[_0x255c57(0x189)+_0x255c57(0x4ba)](0x11b9*0x2+0x1*-0xc07+-0x89*0x2b+0.6322579999999931,0x1*0x2215+-0x374+0x28*-0xc1+0.9079629999999952,0x9*-0xef+-0x63f+0xefc+0.20740299999999934,0x88*-0x7+0x2b2+0x2*0xc5+0.4229400000000112,-0x9e*0x1b+-0x6f5+0x1*0x17e2+0.7803650000000033,-0x9c2+-0xe9d+-0x84f*-0x3+0.9336199999999906),_0x1c52f5[_0x255c57(0x189)+'eTo'](-0x965+-0x1f*-0x1f+-0x2f2*-0x2+0.7207879999999989,0x17*0x182+-0x761+-0x1abd+0.6810900000000117,-0x7c5*0x4+-0x18af+0x3801+0.18310400000000016,-0x1f83+-0x1*0x49d+-0x496*-0x8+0.13944000000000756,-0x4*0x70c+0x1e*0x1f+0x5*0x4f5+0.02567499999999967,-0x24ce+0x33d*-0x1+0x1*0x2899+0.3339200000000062),_0x1c52f5[_0x255c57(0x5bd)](0x4*-0x5d5+-0x26a2+0x3e71+0.21151999999999305,0xa7f+0x2a1+-0xcf9+0.7291039999999995),_0x1c52f5['bezierCurv'+_0x255c57(0x4ba)](0x26c6+-0x1f4+-0x2457+0.2106859999999955,0x10*-0xfb+0x1fd0+0x2*-0x7fd+0.8591109999999986,-0x1f49*0x1+0x1*0x293+0x1d30+0.740791999999999,-0x52d*-0x4+0x240d*-0x1+-0x1*-0xf7f+0.055514000000002284,0xc97+0xa7b*-0x1+-0x1a3+0.9785499999999985,0xc50+0x233+-0xe5e+0.6205199999999991),_0x1c52f5[_0x255c57(0xc1)](0x18d2+0x553+-0x1*0x1de4+0.21005200000000457,-0x108b+0x1278*-0x1+0x2308+0.21153400000000033),_0x1c52f5[_0x255c57(0x189)+_0x255c57(0x4ba)](0xb60+-0x1ceb*-0x1+-0x280b+0.4470919999999978,-0x10f*0x1a+0xe95+0xcf5+0.7761259999999996,-0x21d0+0x109f+0x1170+0.507086000000001,0x102b*0x2+0x7*0x271+0x8b*-0x5b+0.7761259999999996,0x1*-0xa04+0x5ec+0x1*0x456+0.7441260000000014,0x4*0x148+-0x23c8+0x1ead*0x1+0.21153400000000033),_0x1c52f5[_0x255c57(0xc1)](0x1be7*-0x1+-0xbdd*0x2+0x33a6+0.9625789999999999,0x1a+-0xb77+0xb82+0.6269709999999975),_0x1c52f5[_0x255c57(0x189)+'eTo'](-0xa6e+0x606*-0x1+0x1*0x1079+0.2003389999999996,-0xdcc+0x3*0xb02+-0xc*0x197+0.06196700000000277,0x13b7+0x2633+-0x39e6+0.730448,0x3*0x3aa+0x1*0x42+-0xb1a+0.8655649999999966,0x1*-0x7b6+0x233f*0x1+0x581*-0x5+0.729616,-0x1*0x2079+-0x1b1f+0x325*0x13+0.735557),_0x1c52f5[_0x255c57(0xc1)](-0x1810+-0x1*-0x12f2+0x522+0.729616,0x19d0+0x162b+-0x281*0x13+0.37942999999999927),_0x1c52f5[_0x255c57(0x189)+_0x255c57(0x4ba)](0x1*0x496+0x165*0x1+-0x5f7+0.7304500000000003,-0x1a*0x12a+0x2f*-0x1+0x1edc+0.24942000000000064,0x2670+-0x585+-0x20e6+0.20034099999999988,-0x1d04+0x8c6*0x1+0x14a8+0.05301500000000203,0x3*-0x789+0x19c*0xd+0x1b4+0.9625789999999999,-0xc07*-0x1+0x1228+-0x1dc5+0.4880100000000027),_0x1c52f5[_0x255c57(0xc1)](0x2*-0xb70+-0x4aa+0xe*0x1fc+0.7441260000000014,0x1*0x885+-0x62a+0x9b*-0x3+0.8905499999999904),_0x1c52f5[_0x255c57(0x189)+'eTo'](-0x1348+0x1a89*-0x1+0x2e10+0.507086000000001,0x161d+0x1570+-0x2b02+0.3259569999999883,0x184*0x2+-0x24a7+0x21df+0.4470919999999978,-0x1901*0x1+0x10c2+-0x1c2*-0x5+0.3259569999999883,0x12*-0x14c+-0x918+-0x20b1*-0x1+0.21005200000000457,0x1034+0x1*0x160f+0x14d*-0x1d+0.8905499999999904),_0x1c52f5[_0x255c57(0xc1)](-0xc1b*0x3+-0x204f+-0x1d*-0x262+0.004649999999998045,-0x1cc8+-0x2697+-0x43*-0x103+0.48156000000000176),_0x1c52f5[_0x255c57(0x189)+'eTo'](-0x144f+-0x2153+-0x1b0e*-0x2+0.766886999999997,-0xd*0x224+-0x1*0x227+0x1e65+0.0465640000000036,-0xa02+0x1966+-0xee9+0.23677700000000357,-0x1669+-0xdc0+0x1f*0x12e+0.2429690000000022,-0x1987*0x1+-0x2334*-0x1+-0x932+0.23761000000000365,0x236a+0x1*0x16c6+-0x39c8+0.3729799999999983),_0x1c52f5[_0x255c57(0x3a8)](),_0x1c52f5['beginPath'](),_0x1c52f5[_0x255c57(0x363)]=-0x5*0x69a+0x69d*0x2+0x1a6*0xc+0.171604,_0x1c52f5[_0x255c57(0x5db)]=_0x2c5b88,_0x1c52f5['moveTo'](-0xc42+-0xa3d+0x16c2+0.604219999999998,-0x8f*0x2b+0x1*-0xe8b+-0x7bb*-0x5+0.08612899999999968),_0x1c52f5[_0x255c57(0x189)+_0x255c57(0x4ba)](-0x12e1+0x5*0x139+0xd07+0.3258790000000005,0x1b59*-0x1+0x469*0x1+0x1707+0.09046199999999871,0x98d+-0x9b2+0x68+0.2541180000000054,0x511*-0x1+0x1a*0x13d+-0x1b0a+0.21298000000000172,-0x322*-0x5+-0x50c+-0xf1*0xb+0.388937999999996,0x127f+-0x5a4*0x1+-0x331*0x4+0.45368099999999956),_0x1c52f5[_0x255c57(0x189)+'eTo'](0xdfe+0x2a*0x4a+0x52a*-0x5+0.9102149999999938,0x1b1c+0x1*0x841+0x9e*-0x39+0.38104799999999983,0x1*-0x1979+0x251a*-0x1+-0x3ef1*-0x1+0.3075460000000021,0x368+0x1db7*-0x1+0x29*0xa6+0.19879500000000405,-0x234d*0x1+-0x2524+0x48dc+0.5809299999999951,-0xa1f+-0x1031+0x1aae+0.9069219999999945),_0x1c52f5[_0x255c57(0x189)+'eTo'](0x1*-0x1ce1+0x1ced+0x5*0x13+0.6157299999999992,-0x20f7+0x11*0x1cd+0x3*0xe8+0.9670950000000005,0x3*-0x39b+-0x23*0x104+0x2ec8+0.6026970000000063,0x29b*-0xd+-0x482+0x26c0+0.016531999999997993,-0x1084+0x70b*0x2+0x2d9+0.5418300000000045,-0xa1a+0x25*-0x4+0xb0d+0.05523100000000625),_0x1c52f5[_0x255c57(0xc1)](-0x222b+-0x1*0x242b+0x46c1+0.5418300000000045,-0x1*-0x71d+0x2692+-0x2d50+0.05523100000000625),_0x1c52f5[_0x255c57(0x189)+_0x255c57(0x4ba)](-0xbc4+0x2*0x835+0x1*-0x43b+0.4809630000000027,-0x1*0x25f1+-0x17*-0x17d+0x37*0x13+0.08962400000000059,-0xd0e+-0x1*0x13a4+0x7*0x4bb+0.43312699999999893,-0x138d+-0xfa6*-0x2+-0xb60+0.07673800000000597,0x1d*0x56+0xa2f+-0x1382+0.39831999999999823,-0x69*0x49+-0x60d*-0x5+-0x1*-0xf+0.016570999999999003),_0x1c52f5['bezierCurv'+'eTo'](-0xdd4+0x5de*0x2+-0x1*-0x274+0.733193,0xa0*0x31+0x10d*-0x17+0x1*-0x62f+0.9086329999999947,0x96*-0x10+0x1e37+-0x1489+0.0833070000000049,-0x24b2+0xe45+0x1*0x169b+0.7491180000000028,0x1a25+-0x19a9+0x3d*-0x1+0.44866300000000336,0x7f5+0x25fd*0x1+0x1*-0x2ddc+0.5380259999999986),_0x1c52f5[_0x255c57(0x189)+'eTo'](0x1307*0x1+-0x77*-0x49+-0x34b7+0.3399379999999965,-0x1*0x1ecb+0x2339+-0x2*0x22c+0.35317600000000127,-0x168*-0x3+0x1f1c+0x2315*-0x1+0.1811969999999974,-0x767*0x1+-0xc75*0x1+-0x3*-0x6a6+0.29084299999999885,0x1ce8+-0x3*-0xe1+-0x3*0xa6f+0.9724399999999989,0x20b9+-0x1c3*-0x9+-0x307e*0x1+0.3510269999999984),_0x1c52f5[_0x255c57(0x189)+_0x255c57(0x4ba)](-0x10b7+-0x1*0x1b6b+0x2c4e+0.8280889999999985,-0x228f+0xbb7+0x16f3+0.6257090000000005,0xa3*-0x1a+-0xe0a*-0x2+-0xb6c+0.6663430000000012,-0x2477+0x274+0x2223+0.8810459999999978,0x2129+-0xed1+-0x1250+0.4872040000000002,0x140b+-0xa69+-0x97c+0.11703800000000086),_0x1c52f5[_0x255c57(0x189)+_0x255c57(0x4ba)](0x2397+-0x39*0x31+-0x18a6+0.4045710000000007,0x21*0x68+0xb2c+0x35*-0x76+0.14283799999999758,0x161*0x13+-0x186c+-0x1bf+0.35020899999999955,0x1888+0xe*-0x251+0x80c+0.11489499999999708,-0x1*0x1ea2+-0xcee+0x2b98+0.3241169999999993,0x8*0x497+-0x54*-0x13+-0x1*0x2ace+0.0332080000000019),_0x1c52f5[_0x255c57(0xc1)](0x2*-0x72f+0xdae+0xb8+0.3241169999999993,0x1cfb+-0x807+-0xa67*0x2+0.02640800000000354),_0x1c52f5[_0x255c57(0x189)+_0x255c57(0x4ba)](0x19e4+0x29c+-0x1c78+0.2980210000000003,-0x1*0x26bb+0x3*-0x932+0x4276+0.9447430000000026,-0x1*-0x1f47+-0x1e7a+-0xc5+0.32628899999999916,0xa74+-0x1*0x2275+0x1826+0.8910100000000014,0x15d5+0x1dbc+-0x4f*0xa7+0.40892200000000045,-0x9ad+0x8d2+0x100+0.8652080000000026),_0x1c52f5[_0x255c57(0x189)+'eTo'](-0x88a+0x1*-0x22a3+0xe6d*0x3+0.022684000000001703,-0x1610+-0xb*0x76+0x1b41+0.8253330000000005,0x1e61+0x17ed+-0x3623*0x1+0.9343560000000011,-0x16e5+-0x32*0x70+0x2cde+0.6951810000000016,0x26*-0x99+-0x1cc0+0x33b4+0.14393900000000315,0x22*-0xe3+-0xcc4+0x2afd+0.47475299999999976),_0x1c52f5['bezierCurv'+_0x255c57(0x4ba)](-0x2eb*0x1+-0x1d*-0x10f+-0x1b8a+0.44402099999999933,-0x1*-0x1974+0x1*-0x13c7+-0x59a+0.37587999999999866,0xf82*-0x1+-0x25eb+0xb*0x4e1+0.6071110000000033,0xe3*-0xd+-0x1aef*0x1+0x2689+0.1695360000000008,0xb58+0x2*0x4c7+-0x14a8+0.6332080000000033,0x54d+0x20c7+-0x2602+0.8557190000000006),_0x1c52f5[_0x255c57(0xc1)](-0x12c3+-0x200b*0x1+0x330d+0.755270000000003,-0x78f+0x2*0x923+-0xab1*0x1+0.46860000000000035),_0x1c52f5[_0x255c57(0x189)+_0x255c57(0x4ba)](0xa*-0x251+-0x6*0x5e3+-0x1e5*-0x1f+0.7595370000000017,-0xed2+0xc15*-0x3+0xb*0x4a5+0.40411600000000014,0x163*0x10+0x1*-0xbcb+0x1*-0xa26+0.7943330000000017,-0x6cc+-0x1*-0xd8d+-0x6bb+0.37187400000000004,-0x492+0x1e9d+-0x19cc+0.8596599999999981,-0xe1b+-0x84b+0x166c+0.37187400000000004),_0x1c52f5[_0x255c57(0xc1)](-0x94c+-0x1*0x146d+0x1df9+0.04886399999999469,-0x34a+0x1*0x1408+0x42e*-0x4+0.36541400000000035),_0x1c52f5[_0x255c57(0x189)+_0x255c57(0x4ba)](-0x2*-0xf95+-0x163c+-0x8ae*0x1+0.09237699999999904,0xc4a+0x13*-0x14e+0x7*0x1ca+0.36541400000000035,-0x1055+-0x20f3*0x1+0x3188+0.1163010000000071,0x1*-0x3f+-0x1*-0x18c5+-0x1880+0.38476,-0x19b1*-0x1+-0xe09+-0x2da*0x4+0.12063399999999547,-0x12f*0xa+-0x1e9f*0x1+-0x7d*-0x57+0.42345200000000016),_0x1c52f5[_0x255c57(0xc1)](-0x16f9*0x1+-0x2f2+0x1*0x1a2c+0.3601230000000015,-0x231+-0xa*0x4f+0x559+0.7654330000000016),_0x1c52f5['bezierCurv'+_0x255c57(0x4ba)](0xf7e+0x1*-0x1a51+0x58a*0x2+0.3955490000000026,0x12*-0x12e+-0x245*0x7+0x8a*0x45+0.11821199999999976,0x1df8+0x1195+0x2*-0x17a6+0.6379469999999969,-0x1*0x17de+-0x44d*0x9+0x2d9*0x16+0.4183400000000006,0x1396+-0x70c+0xb9*-0x11+0.9798660000000012,0x2187+-0xde3+-0x1391+0.5327769999999994),_0x1c52f5[_0x255c57(0x189)+_0x255c57(0x4ba)](-0x1f74+0x26a5+-0x6de+0.5675319999999999,0x1da7+0x11*-0x1c9+0xcb+0.40069799999999844,0x18af+-0x2e0*-0xb+-0x37ea*0x1+0.1899930000000012,-0x268d+-0x2*0x1124+0x48f4+0.2750699999999995,0x1a54+0x6e*0x1f+0x4e6*-0x8+0.8472500000000025,0x152f+-0x1938+-0xa*-0x6b+0.15589200000000147),_0x1c52f5['bezierCurv'+_0x255c57(0x4ba)](0x1c3f+0x1a*0xb3+-0x2df7+0.9255370000000056,-0x2575*0x1+-0x12d1+-0x1*-0x386b+0.1816650000000024,-0x91e+0xb*-0x256+0x2*0x11a3+0.9538029999999935,0x286*0xb+-0xa7*-0x14+0x7*-0x5cf+0.23325599999999724,-0x2*-0xe01+-0x516+-0x1676+0.9320500000000038,0x1388+0xa*-0x2e3+0x97b*0x1+0.3106640000000027),_0x1c52f5[_0x255c57(0xc1)](0xb1*-0x38+0x2c5*-0x1+0x1*0x29f3+0.9260500000000036,-0x2*0xcb3+-0x91f+0x22aa+0.31726400000000154),_0x1c52f5['bezierCurv'+_0x255c57(0x4ba)](-0x2*-0x737+-0xb*-0x59+-0x11cb+0.9043829999999957,0xe2*0x1+0x2648+-0x2705+0.3989350000000016,-0xd72*0x2+-0x232e+0x3e88+0.8500200000000007,0x2*-0xd7b+0x31*-0x23+0x21ce*0x1+0.4268819999999991,-0x8d3+-0x22ac+-0x3ff*-0xb+0.7629600000000067,-0x3*-0x4f5+0x9*-0x1bf+-0x1*-0xfd+0.4011039999999966),_0x1c52f5[_0x255c57(0x189)+'eTo'](0x18ad+-0x13ad+-0x49a+0.058038999999993734,0xe5*0x2b+0x605+-0x2c5c+0.7239670000000018,-0xc80+-0x12b7+-0x2*-0xfc6+0.12702600000000075,-0xbe3+-0x1448+0x22*0xf3+0.9672990000000006,0x1*0x2362+-0x1834*0x1+-0xaeb+0.9699190000000044,-0x3c0+0x53*0x65+-0x1ce8+0.13109899999999897),_0x1c52f5[_0x255c57(0x189)+_0x255c57(0x4ba)](-0x1ed7+-0xba2+0x2abc+0.8481419999999957,-0x19*-0xdf+0x116d+0x24d*-0x11+0.09670600000000107,0x3e3*-0x1+0x1a*-0x137+-0x8ef*-0x4+0.7263659999999987,0x2180+0x1c*0xf8+0x1*-0x3c89+0.08165899999999837,-0x645+-0x1b92+0x221a+0.6045890000000043,-0xed0+-0x539*-0x7+-0x108*0x15+0.08595899999999901),_0x1c52f5[_0x255c57(0x3a8)](),_0x1c52f5[_0x255c57(0x268)](),_0x1c52f5[_0x255c57(0x363)]=0x1aeb+-0x2*-0x1070+0x1*-0x3bcb+0.171604,_0x1c52f5[_0x255c57(0x5db)]=_0x2c5b88,_0x1c52f5[_0x255c57(0x5bd)](-0x2*-0x7c9+0x184c+-0x1*0x27cd+0.7507519999999985,-0x8d4+-0x13e1+0x1d15+0.18367800000000045),_0x1c52f5[_0x255c57(0x189)+_0x255c57(0x4ba)](0x49*0x47+0x136f+-0x279d+0.8116389999999996,-0x2a5*0x7+-0x1380+0x13d*0x1f+0.4588069999999931,0x11f0+-0x5*-0xef+-0x168a+0.9138419999999989,-0x2*-0x985+0x51a*0x1+0x4*-0x5f1+0.4760030000000057,0x1f55+-0x9*-0x265+-0x34d0+0.05736299999999872,0x220a+-0xa2a+0x20*-0xbc+0.23526800000000492),_0x1c52f5[_0x255c57(0x189)+_0x255c57(0x4ba)](-0x1*-0xe9e+-0x29f+-0xbe0+0.34379200000000054,0x19c3*0x1+0x290*-0x2+-0x1*0x1459+0.2552869999999956,0x168d+0x1*-0x2285+0xc24+0.7019810000000035,-0x1c07+-0x1d99+0x39d4+0.268853,0x1e71+0xd*0x68+-0x237f+0.131929999999997,-0x1e19+0x71*-0x1b+-0x1*-0x2a22+0.2759639999999983),_0x1c52f5[_0x255c57(0x189)+'eTo'](0xd*-0x15b+0x3c2+0xe17+0.16673000000000116,0x4ba+0x2*-0xd09+0x1576+0.2157839999999993,-0x204+0x517+-0x2d9+0.21456599999999781,0x1cd6+-0x35*-0x93+-0x3b27+0.20288400000000095,0xe*-0xb1+0x4*-0x771+0x1*0x27ac+0.27543899999999866,0x219+-0x2482+0x2287+0.2372639999999997),_0x1c52f5[_0x255c57(0xc1)](-0x2*-0x8b8+-0xe1c+0x18d*-0x2+0.28183899999999795,0x1658+0x74b+-0x1d85+0.24386399999999853),_0x1c52f5[_0x255c57(0x189)+'eTo'](0x1*0x1299+0x3*-0x47f+-0x4e2+0.35576700000000017,0x27e*-0x1+0x1*-0x14a5+0x1741*0x1+0.28255100000000155,0x4*-0x1d9+-0x2*0x4b9+0x1110+0.3709869999999995,-0xf*0x72+-0x16fe+0x1dca+0.33843299999999843,0x2*-0x9a4+0x45d*0x5+-0x24f+0.3274990000000031,0x1308+-0x16fb+-0x15b*-0x3+0.4115119999999983),_0x1c52f5['bezierCurv'+'eTo'](-0x1b22+0x5e1+0x156e+0.32385200000000225,0x227f+-0x15b1+-0xc99+0.6123440000000002,-0x2*-0x9fd+0x8f3+-0x1ccd+0.2918900000000022,0x99f*0x1+0x1e7*0x9+-0x1a72+0.8303870000000018,-0x11d4+-0x68*0x1f+-0x1*-0x1e7f+0.2316129999999994,0x26a0+-0x108d*-0x1+-0x21*0x1a9+0.06564000000000192),_0x1c52f5[_0x255c57(0x189)+'eTo'](-0x1d86*-0x1+0x2*-0x1003+0x293*0x1+0.11679300000000126,0x13*0xbb+-0x9be+0x7*-0x89+0.26783899999999505,0x1a7e+-0x1249*0x1+0x822*-0x1+0.1633199999999988,0x6*-0x574+0x515+-0x401*-0x7+0.5221370000000007,-0x1f45+0x1a40+0x518+0.34251199999999926,0x1c18+-0x598+0x11b*-0x14+0.6717799999999983),_0x1c52f5[_0x255c57(0x189)+_0x255c57(0x4ba)](0x208+-0x239f*-0x1+-0x2586+0.9162710000000018,-0x3a*0x31+-0x45+0xbcf+0.8246070000000003,0x1d37+-0x3*-0x14+-0x1d43+0.5095979999999969,-0x37f*-0x3+0x1dcc+-0x27cc+0.020426999999997975,0x1175*0x2+0x1a5f+-0x3d0a+0.12249400000000321,-0x1*-0x192b+-0x1*0x13c9+-0x49*0x11+0.25924000000000547),_0x1c52f5[_0x255c57(0x189)+_0x255c57(0x4ba)](0xf05+-0x16e9+-0x823*-0x1+0.17034100000000052,0x2702+0x20d9+-0x4752+0.30224000000001183,-0x707+0x30c+0x43a+0.17462400000000144,0x419+-0x1*-0xf5b+0x12eb*-0x1+0.34737000000001217,0x7a6*-0x1+-0x9a3*-0x1+-0x1be+0.13534400000000346,-0xe3b*-0x1+0x4*-0x49c+0x4be+0.3946300000000065),_0x1c52f5[_0x255c57(0xc1)](0x262e+0x756+0xf17*-0x3+0.13534400000000346,-0x9c2+-0x2*-0x547+-0x43+0.3946300000000065),_0x1c52f5[_0x255c57(0x189)+'eTo'](-0xc12+-0x390+0xfe1*0x1+0.09619099999999747,-0x1fdb+0x3c5+0x1c9f+0.4462300000000141,-0x1b68+-0x1*-0x1106+0xaa1*0x1+0.05053399999999897,-0x1f8*-0x10+0x1f39+0x31c*-0x14+0.45266300000000115,-0x1ca0+0x55*0x57+0x5*-0x1+0.9983739999999983,-0x600+-0xf7e+0x1607*0x1+0.41392999999999347),_0x1c52f5[_0x255c57(0x189)+_0x255c57(0x4ba)](0x3*-0xa51+0x1*0x83f+0x16e3+0.6983090000000018,0xdf9+0xd3d+-0x1ab9+0.880162999999996,0x34a*0x4+-0x1074+0x92*0x6+0.38520499999999913,0x5da+0x2b*0xd7+-0xdd7*0x3+0.2926429999999982,0xe76*0x1+-0xfb6*0x2+0x5ad*0x3+0.05906099999999981,0x1*0x155f+0xbc4*0x1+-0x20bd*0x1+0.65137),_0x1c52f5['bezierCurv'+_0x255c57(0x4ba)](-0x147e+-0x1*-0xe17+-0x14b*-0x5+0.8590060000000008,0x7aa+0xf85*-0x1+0x841*0x1+0.5009230000000002,0x7*0x20+-0x21aa*-0x1+-0x227a+0.6372029999999995,0xc*-0x52+0x1cc2+-0x2*0xc42+0.46009300000000053,-0x12e9+0x1*-0x39a+0x1693+0.39365199999999945,0x1*0x351+0x24d1+-0x27bc+0.5288800000000009),_0x1c52f5[_0x255c57(0xc1)](0x31*-0x23+-0x22c3+-0x297d*-0x1+0.0910359999999999,-0x13f7+-0x1cf7+0x3157+0.18550000000000466),_0x1c52f5['bezierCurv'+_0x255c57(0x4ba)](0x581*0x1+0x3*-0x34+-0x4e0+0.6036520000000003,0x936+-0x67d+-0x250+0.6110800000000012,0x29b*-0xe+-0x847+0x2cc6+0.5362410000000004,-0x24b3+0x63+0x24b9+0.4477229999999963,-0x1*-0x26c7+-0xc92+0x1a2f*-0x1+0.8888049999999996,0x1511+0x6be+-0x57b*0x5+0.6954300000000018),_0x1c52f5['lineTo'](-0x172*-0x8+-0x824+-0x35d+0.08246499999999912,0x11f6+0x1c2b+0x1*-0x2dbd+0.14294999999999902),_0x1c52f5[_0x255c57(0x189)+_0x255c57(0x4ba)](0x2c2*-0xb+-0x464*0x4+0x2ff5+0.2912219999999994,0x5e4+-0x127b*-0x1+0x1*-0x17fb+0.022563000000005218,0x2509+-0x3*0xa61+0x12b*-0x5+0.3760300000000001,-0x24bf+0x1a1c+-0x11*-0xa6+0.8441509999999965,0x168b+0x37*0xa7+-0x3a5d+0.33688899999999933,-0x24*0x74+-0x152d+0x25e0+0.6077149999999989),_0x1c52f5['lineTo'](-0x14b8+-0x97c+0xa13*0x3+0.7929659999999998,0x1*-0xfa9+-0x3fd+0x13cf+0.7603089999999995),_0x1c52f5['bezierCurv'+_0x255c57(0x4ba)](0x1186+-0xf5*0x1d+0x148*0x8+0.7842729999999998,0x4*-0x595+-0x2221+0x389e+0.6872380000000007,0x1dd1+-0xd*0x11+-0x1cef+0.8168899999999999,0x4*0x86f+0x4d*-0x18+-0x1a5b+0.6442529999999991,0x754+-0xf99+-0x2*-0x425+0.8908180000000003,0x170f+-0x1081+0x1*-0x665+0.6313519999999997),_0x1c52f5[_0x255c57(0xc1)](0x75*0x12+0x1*-0x752+-0xe2+0.08652499999999996,0x188c*-0x1+0x16*0x134+-0x1c3+0.5926520000000011),_0x1c52f5[_0x255c57(0x189)+_0x255c57(0x4ba)](0x79f*-0x1+0x7a9+-0x4+0.10393600000000003,-0x8ff+-0xe80+-0x4*-0x5ea+0.5883850000000024,0x1640+0x150+-0x178a+0.11480800000000002,0xc4d*0x3+-0xf8c+-0x1532+0.5948119999999975,0x97d+-0x23a0+0x1*0x1a29+0.11914200000000008,-0x1*-0x24aa+-0x7cd+-0x1cb4+0.611932000000003),_0x1c52f5[_0x255c57(0x189)+_0x255c57(0x4ba)](0x1f6a*-0x1+-0x1*-0x11c8+0xdab*0x1+0.8723960000000002,-0x7*0x26b+0x197e+-0x856+0.8820199999999971,0x1c74+-0x18d9*-0x1+-0x3540+0.7495980000000007,-0x862+-0x689+0xf39+0.07258099999999956,-0x239f+0x213f+0x271+0.750748999999999,-0x1e61+0x15d0+0x8f1+0.18361400000000572),_0x1c52f5[_0x255c57(0x3a8)](),_0x1c52f5[_0x255c57(0x268)](),_0x1c52f5[_0x255c57(0x363)]=-0x1*0x1ba7+-0x1c*0x59+-0x2563*-0x1+0.171604,_0x1c52f5['fillStyle']=_0x2c5b88,_0x1c52f5[_0x255c57(0x5bd)](-0x95*-0x4+-0x498+0x2b4*0x1+0.7541599999999988,0x1*0x102b+-0x173*-0xb+-0x1fb8+0.07842999999999734),_0x1c52f5[_0x255c57(0x189)+_0x255c57(0x4ba)](-0x1422+-0x1614+0x43*0xa3+0.6158530000000013,-0x95*0x16+-0x9fa*0x1+0x172d*0x1+0.7764769999999999,0xc4d+-0xb*0xee+-0x19d+0.49494300000000635,0x142a+-0x1ab*0x8+-0x66b+0.4745199999999983,-0x17a4+-0x64*-0x23+0x1*0xa71+0.3914299999999997,-0x4*0x4d2+0x1ac5+-0x714+0.17256000000000427),_0x1c52f5[_0x255c57(0x189)+_0x255c57(0x4ba)](0x13f2+-0x4ea+-0x1*0xe8f+0.44796300000000144,-0x1*-0x1e92+0x1424+-0x324d+0.20695999999999515,-0x4*0x5d9+0x634+0x11a9+0.47189699999999846,-0x1*-0xa52+0x1a36+-0x1*0x241f+0.2735930000000053,-0x2683+0x4*0x851+-0x3*-0x1e8+0.4632299999999958,0x151*0x6+0x1c5d+-0x23da+0.3724600000000038),_0x1c52f5[_0x255c57(0x189)+_0x255c57(0x4ba)](-0x1*0xd34+-0x577*0x3+0x1e12+0.4501630000000034,0x2e*-0xd9+-0x1855*-0x1+0xf12+0.5014400000000023,0x1*0x1dd4+-0xf*0x40+-0x73*0x39+0.38057000000000585,-0x1a5b+-0x107b+0x2b3f+0.546566999999996,-0x20b*-0xa+0x1260+-0x3*0xcc7+0.2544500000000056,0x25ab+-0x6*0x1ff+-0x1*0x1948+0.5078400000000016),_0x1c52f5[_0x255c57(0xc1)](-0x6*0x44a+0x1237+-0x1*-0x7f4+0.5146900000000016,-0x15*-0x3+-0x47*0x2b+-0x2*-0x60a+0.5609800000000007),_0x1c52f5['bezierCurv'+_0x255c57(0x4ba)](0x1*0x247f+-0x1d*0xc7+0x1*-0xd85+0.29815200000000175,0x21eb+-0x5d*-0x2+-0x223f+0.4958790000000022,-0x1352+0x1c*0x100+-0x83f+0.0623159999999956,0x70e+-0x73*0x47+0x193d+0.5391220000000061,0x1ed7+-0x1*0x1edd+0x74+0.8819000000000017,0x1aa0+-0x1430+0x60a*-0x1+0.6770099999999957),_0x1c52f5[_0x255c57(0x189)+_0x255c57(0x4ba)](0x1f72+-0x2642+0x72f+0.6166410000000013,0x1*0x107b+0x1197*0x1+-0x21a0+0.27099699999999416,0xdb*-0x1b+-0x238e+0x3af7+0.4057459999999935,0x1edb*-0x1+-0x243f+-0x1*-0x4397+0.8090930000000043,0x1472+0x25af+0x73c*-0x8+0.24921500000000663,-0x2*0x2ce+0x20d1+-0x1aac+0.2913000000000068),_0x1c52f5['bezierCurv'+_0x255c57(0x4ba)](0x277*0x5+-0xde5*0x1+0x1d3+0.19700799999999674,-0x5b*0xd+-0xd92*0x1+-0x5e*-0x33+0.33430000000001314,-0x73*-0x2+0x1a59+0x566*-0x5+0.14917199999999298,0xb2a*0x1+-0x1*-0x268d+-0x312e+0.3278669999999977,-0x16db+0x71*0x55+-0x1f*0x77+0.10570599999999786,0x1be7+0xa74+-0x25d2+0.27199999999999136),_0x1c52f5[_0x255c57(0xc1)](0x1d66*-0x1+-0x2701+-0x548*-0xd+0.09930599999999856,-0x1ae+-0x760+0x997+0.27199999999999136),_0x1c52f5[_0x255c57(0x189)+_0x255c57(0x4ba)](0xec6+0x6b1*-0x2+-0x123+0.06015299999999968,0x10d3+-0x1*-0x1645+-0x268f+0.22040000000001214,0x480*0x8+-0xc7*0x2f+0xca+0.06670300000000395,-0x1c05+0x13c2+0x8cc+0.17096300000000042,-0x1*-0x3c+0x3e7+0xe*-0x47+0.11895599999999718,-0x20fb*0x1+0x14c7+-0xcbd*-0x1+0.12369000000001051),_0x1c52f5[_0x255c57(0x189)+_0x255c57(0x4ba)](0x22f5+0x21d6+-0x447c+0.7883939999999967,-0x23ad+-0x1058+0x3481+0.8074969999999979,0x130+0x1095*0x1+-0x195*0xb+0.4339089999999999,0x9*0x2e1+-0x1*0x499+-0x8*0x29c+0.5321430000000049,0x84c*0x3+0x1368+0xb*-0x3fd+0.055499999999995,0x1*-0x1586+0x1*0x93+-0x1557*-0x1+0.29762999999999806),_0x1c52f5['bezierCurv'+_0x255c57(0x4ba)](0xe6e+0x2*0xe21+-0x2a43+0.3342140000000029,-0x182b*0x1+0x2*0x51e+0xe53+0.06791699999999423,0x211f+-0xb2*-0x2e+-0x40ae+0.5252919999999932,-0x1c6+-0x1*-0x32b+-0x102*0x1+0.7493419999999986,0x2274+-0x5f*-0xf+0xe*-0x2d4+0.5969599999999957,-0x17*-0x130+-0x3d8+0x137*-0x13+0.3948780000000056),_0x1c52f5['bezierCurv'+'eTo'](0x311*0xa+-0x23*0xcd+-0x232+0.41979999999999507,-0x1fb8+0x3ae+0x1c5a+0.4541679999999957,0x10ad+0x5aa*0x2+0x56*-0x52+0.30352299999999843,0x4*0x599+0xb3e+0x1*-0x2165+0.44467800000000324,0x7c0+0x1405+-0x4*0x6d3+0.2481300000000033,-0x6f*-0x5a+0x137c+-0x1d2c*0x2+0.3664089999999973),_0x1c52f5['bezierCurv'+_0x255c57(0x4ba)](-0xc85+-0x1f50*0x1+0x2c4e+0.26552999999999827,0x259d*0x1+0x59c+-0x97*0x49+0.2890299999999968,0x1*0x1ad9+0x1418+-0x2e78+0.31554699999999514,-0x1dbe+-0x2066+-0xa*-0x63b+0.2567900000000023,-0x127*-0xb+0x1549+0x1*-0x217d+0.3981799999999964,0x10aa+-0x1f6*-0xe+-0x2bf4+0.2696889999999996),_0x1c52f5['lineTo'](-0x1*0x14d1+0x1789+0x5*-0x73+0.3981799999999964,0x1a78+-0x174f+-0x2ff+0.2696889999999996),_0x1c52f5[_0x255c57(0x189)+_0x255c57(0x4ba)](0xd68+-0xa19*0x1+-0x2d6+0.47646699999999953,0x1bd3+-0x89*0x3d+0x4fc+0.2825419999999994,0x6f7+-0x15bf+-0x1*-0xf41+0.5091000000000037,-0xc41+0x28b*0xc+-0x1219+0.3276699999999977,0x24*-0x84+-0x196b+0x2c74+0.4960800000000063,0x1db+0x63a*0x1+-0x1*0x7eb+0.405071999999997),_0x1c52f5[_0x255c57(0x189)+'eTo'](-0x12cb+-0x11f7+-0x634*-0x6+0.5604600000000062,0x2636+-0x1*-0x114f+-0x3748+0.5134389999999982,0x8*0x3c1+0x2*0xe6b+0xf*-0x3e5+0.5922199999999975,-0x5*-0x2ef+0x14bc+-0x2317+0.6218029999999999,-0x26*0x39+0xa7*0x26+0x24*-0x71+0.5913599999999946,0x22*-0x22+-0x1186*-0x1+0x1*-0xc9f+0.7301649999999995),_0x1c52f5[_0x255c57(0x189)+'eTo'](0x3b*-0x3+-0x5*-0x2e3+-0xd*0x106+0.5681579999999968,0x5b7+-0x1*0x1a93+0x153f+0.8697879999999998,-0xac9+-0x1191+0x1cca+0.6330140000000029,-0x1c54+-0x114f+-0x1*-0x2e07+0.008270999999993478,0x1*-0xb03+0x76f+-0x1*-0x404+0.7544400000000024,-0x1*0x2614+-0x741+0x925*0x5+0.07837999999999568),_0x1c52f5[_0x255c57(0x3a8)](),_0x1c52f5[_0x255c57(0x268)](),_0x1c52f5[_0x255c57(0x363)]=-0x1094+-0x63b+0x16cf+0.171604,_0x1c52f5[_0x255c57(0x5db)]=_0x2c5b88,_0x1c52f5[_0x255c57(0x5bd)](-0x18d*0x4+-0x20b6+-0x3d*-0xa5+0.7385299999999972,0x283*0x7+0x1*0x9d+-0x11ce+0.7425999999999959),_0x1c52f5['bezierCurv'+'eTo'](0xc3+0x10*-0x13f+0x1394+0.7385299999999972,-0x1f1c+-0x45e*0x1+0x23de+0.8070670000000035,0x7f2+0x249b+-0x2c26+0.7058969999999931,0xcd0*0x1+-0x9fa*0x3+0x1182+0.8414470000000023,-0x24c5+0x1ed3+0x659+0.6406300000000016,-0x39a*0x9+-0x18da+0x39a8+0.8457400000000064),_0x1c52f5[_0x255c57(0x189)+_0x255c57(0x4ba)](0x6b5*0x1+-0x265a+0x1ff2+0.15475100000000452,0x2*-0x418+-0x289+0xb1f+0.07950700000000666,0x1fa1+0x149b+-0x340a+0.6580009999999987,-0x523*-0x5+-0x2134+-0x7eb*-0x1+0.07520700000000602,0x1*0x7ed+-0xaf6+-0x3*-0x10b+0.1503799999999984,0x1846+-0x24*-0x77+-0x289e+0.8328400000000045),_0x1c52f5['bezierCurv'+_0x255c57(0x4ba)](0x241a+-0x1a6c+0x6*-0x199+0.09384700000000024,0x10d3+0x1*0x86+-0x10f5*0x1+0.8288399999999996,0x4*0x967+-0x2193+-0x3f1+0.06558000000000064,0xc7*-0xd+-0x1a0c+0x248b*0x1+0.7987399999999951,0x1f8f+0x218*-0x8+-0xeb7+0.06558000000000064,0x1f66*0x1+-0x19f4+-0x50e+0.7425400000000053),_0x1c52f5[_0x255c57(0xc1)](-0x14e*0xe+-0x1b68*-0x1+-0x4*0x243+0.06558000000000064,0x1*-0x7ef+-0x1*-0x21b9+-0x1966+0.7425400000000053),_0x1c52f5[_0x255c57(0x189)+_0x255c57(0x4ba)](0x788+0x1*-0x127d+0xb0d+0.06558000000000064,0x10d1*0x2+-0x5*-0x679+0x419b*-0x1+0.6780729999999977,-0x212c+0x81d+0x1927+0.09602299999999886,-0x8a*0x37+0x791*0x3+0x757+0.6436900000000065,0x1*0x1cf+-0x16e5+0x2*0xa97+0.15690999999999988,-0x865*-0x2+-0xd*-0x1c9+0x1*-0x279b+0.6393900000000059),_0x1c52f5['bezierCurv'+_0x255c57(0x4ba)](0x2*0x5aa+0x240d+-0x2f2f+0.6253889999999984,0x1ca*0x5+0xf01+-0x1790*0x1+0.4701079999999962,-0xff9+-0x2f*0x7+0x1d*0x9b+0.11344200000000626,0x26c2+-0x1e*0x141+0xc1*-0x1+0.46367499999999495,0x2b*0x1+-0x1*-0x1a23+-0x19e7+0.6210700000000031,0x7*-0x137+-0x35*0xf+0xc00+0.6200900000000047),_0x1c52f5[_0x255c57(0x189)+_0x255c57(0x4ba)](-0x2124+0xb78+0x1613+0.6993570000000062,0x193+-0x4*-0x278+-0xb0f+0.6200900000000047,0x2*-0x4be+0x25e9+-0x1c06+0.7385000000000019,-0xe38+-0xe0+-0x1*-0xf7c+0.658779999999993,-0x1d16+0x1e3f*-0x1+0x3bbc+0.7385000000000019,-0x2103+0x6f+-0x8*-0x41f+0.7361599999999981),_0x1c52f5[_0x255c57(0x3a8)](),_0x1c52f5[_0x255c57(0x416)](),_0x1186bd[_0x255c57(0x3be)+'re'][_0x255c57(0x526)](),_0x1186bd[_0x255c57(0x5fa)+_0x255c57(0x5ba)]=![],_0x1186bd[_0x255c57(0x3d7)]=!![],this[_0x255c57(0x352)+_0x255c57(0x206)+_0x255c57(0x3a5)][_0x2396d9]=_0x1186bd,this[_0x255c57(0x352)+_0x255c57(0x206)+_0x255c57(0x3a5)][_0x2396d9];},SoundManager[_0x5db7a1(0x299)+_0x5db7a1(0x2da)]=function(_0x1d6c67){const _0x272cf9=_0x5db7a1,_0x3819ae={'bkrPH':'%1_name','WHFQx':'%1_volume','PkUnR':_0x272cf9(0x11b),'iZgMS':_0x272cf9(0x371),'PWsMw':function(_0x1e61e8,_0xca8e1a){return _0x1e61e8===_0xca8e1a;}},_0x2bfad5=VisuMZ[_0x272cf9(0x50f)+_0x272cf9(0x20a)][_0x272cf9(0x573)][_0x272cf9(0xc3)],_0x3af86d={'name':_0x2bfad5[_0x3819ae[_0x272cf9(0x255)]['format'](_0x1d6c67)]||'','volume':_0x2bfad5[_0x3819ae[_0x272cf9(0x3c6)][_0x272cf9(0x13e)](_0x1d6c67)]||-0x3*0x1+0x7*0x4fc+-0x22e1,'pitch':_0x2bfad5[_0x3819ae[_0x272cf9(0x186)]['format'](_0x1d6c67)]||-0x2519*-0x1+0x1f29*-0x1+0x4*-0x17c,'pan':_0x2bfad5[_0x3819ae[_0x272cf9(0x3ba)][_0x272cf9(0x13e)](_0x1d6c67)]||0xdad+-0x1759+0x9ac};if(_0x3819ae['PWsMw'](_0x3af86d[_0x272cf9(0x5a2)],''))return;AudioManager[_0x272cf9(0x3f3)](_0x3af86d);},SoundManager['playDiceTh'+_0x5db7a1(0x493)]=function(){const _0x229695=_0x5db7a1,_0xbb78bd={'PPYzs':'throw'};this[_0x229695(0x299)+'und'](_0xbb78bd[_0x229695(0x3ec)]);},SoundManager[_0x5db7a1(0x144)+_0x5db7a1(0x25f)]=function(){const _0x25e757=_0x5db7a1,_0x42d952={'HaDNe':_0x25e757(0x1f6)};this['playDiceSo'+_0x25e757(0x2da)](_0x42d952[_0x25e757(0x1b8)]);},SoundManager[_0x5db7a1(0x4c8)+'nusUse']=function(){const _0x12a6f4=_0x5db7a1,_0x1a8cef={'MkGof':_0x12a6f4(0x59f)};this[_0x12a6f4(0x299)+_0x12a6f4(0x2da)](_0x1a8cef[_0x12a6f4(0x489)]);},SoundManager['playDiceSu'+'ccess']=function(_0x290991){const _0x5e3029=_0x5db7a1,_0x2ab53c={'LIQgf':_0x5e3029(0x4ea)+'ss','YvBXx':_0x5e3029(0x448)};this[_0x5e3029(0x299)+_0x5e3029(0x2da)](_0x290991?_0x2ab53c[_0x5e3029(0x54d)]:_0x2ab53c[_0x5e3029(0x2df)]);},SoundManager[_0x5db7a1(0x430)+_0x5db7a1(0x22e)]=function(_0x2a7a38){const _0x31e863=_0x5db7a1,_0x3c619f={'CyJqI':_0x31e863(0x226)+'re','EJRiX':_0x31e863(0x37b)};this[_0x31e863(0x299)+_0x31e863(0x2da)](_0x2a7a38?_0x3c619f[_0x31e863(0x2b9)]:_0x3c619f[_0x31e863(0x386)]);},TextManager[_0x5db7a1(0x28a)]={'choices':{'roll':VisuMZ['DiceRollsR'+'ngSeeds'][_0x5db7a1(0x573)][_0x5db7a1(0x19e)][_0x5db7a1(0x16a)+'l']??_0x5db7a1(0x5a3),'effects':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)]['Settings']['Vocab']['CommandEff'+_0x5db7a1(0x3cd)]??_0x5db7a1(0x2e0)+'ts','bonus':VisuMZ['DiceRollsR'+_0x5db7a1(0x20a)][_0x5db7a1(0x573)]['Vocab'][_0x5db7a1(0xdd)+'us']??_0x5db7a1(0xe8)},'colors':{'diceUpColor':VisuMZ[_0x5db7a1(0x50f)+'ngSeeds'][_0x5db7a1(0x573)][_0x5db7a1(0x19e)][_0x5db7a1(0x3b9)+'r']??0xed3+-0xde5*0x1+0x6b*-0x2,'diceDownColor':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x573)][_0x5db7a1(0x19e)][_0x5db7a1(0xbf)+'lor']??-0x1e19+-0x1d48+0x1dbe*0x2,'rankUpColor':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x573)][_0x5db7a1(0x19e)][_0x5db7a1(0xd8)+'r']??0x9aa*0x1+0x161b+0xc*-0x2a4,'rankDownColor':VisuMZ[_0x5db7a1(0x50f)+'ngSeeds']['Settings']['Vocab'][_0x5db7a1(0x323)+_0x5db7a1(0x4cb)]??0x249*0x10+0x1faf*0x1+-0x443b,'modUpColor':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)]['Settings']['Vocab'][_0x5db7a1(0x50b)]??0x1*0x63e+0x15b*0x1+0x793*-0x1,'modDownColor':VisuMZ[_0x5db7a1(0x50f)+'ngSeeds'][_0x5db7a1(0x573)][_0x5db7a1(0x19e)]['modDownCol'+'or']??0x89d+0x1*0x1ef7+-0x2792},'data':{'count':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x573)][_0x5db7a1(0x19e)]['DataDiceCo'+_0x5db7a1(0x298)]??'\x5cC[16]Dice'+_0x5db7a1(0x159),'advantage':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x573)][_0x5db7a1(0x19e)][_0x5db7a1(0x1a7)+_0x5db7a1(0x32c)]??'\x5cC[24]Adva'+_0x5db7a1(0x18e),'disadvantage':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)]['Settings'][_0x5db7a1(0x19e)][_0x5db7a1(0x46d)+_0x5db7a1(0x1b3)]??'\x5cC[27]Disa'+_0x5db7a1(0x4ab),'rank':VisuMZ[_0x5db7a1(0x50f)+'ngSeeds']['Settings'][_0x5db7a1(0x19e)][_0x5db7a1(0x337)+'nk']??_0x5db7a1(0x107)+_0x5db7a1(0x5a8),'modifier':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x573)]['Vocab'][_0x5db7a1(0x43a)+_0x5db7a1(0x4a1)]??_0x5db7a1(0x52c)+'fiers:','rank1':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x573)][_0x5db7a1(0x19e)]['DataRank1']??'D4','rank2':VisuMZ[_0x5db7a1(0x50f)+'ngSeeds'][_0x5db7a1(0x573)][_0x5db7a1(0x19e)][_0x5db7a1(0x601)]??'D6','rank3':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x573)][_0x5db7a1(0x19e)][_0x5db7a1(0x1ef)]??'D8','rank4':VisuMZ[_0x5db7a1(0x50f)+'ngSeeds']['Settings'][_0x5db7a1(0x19e)][_0x5db7a1(0x4e3)]??'D10','rank5':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)]['Settings']['Vocab']['DataRank5']??_0x5db7a1(0x2cc),'rank6':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x573)]['Vocab']['DataRank6']??_0x5db7a1(0x5a1)},'bonus':{'displayFmt':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x573)][_0x5db7a1(0x19e)]['CostDispla'+_0x5db7a1(0x127)]??'\x5c}%1\x5c{','costTextFmt':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x573)][_0x5db7a1(0x19e)][_0x5db7a1(0x510)+_0x5db7a1(0x2a3)]??_0x5db7a1(0x53d),'usedUp':VisuMZ[_0x5db7a1(0x50f)+'ngSeeds'][_0x5db7a1(0x573)][_0x5db7a1(0x19e)][_0x5db7a1(0xc2)]??_0x5db7a1(0x36e),'useTimesFmt':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x573)][_0x5db7a1(0x19e)][_0x5db7a1(0x33b)+_0x5db7a1(0x60b)]??_0x5db7a1(0x40b),'showUseMax1':VisuMZ['DiceRollsR'+_0x5db7a1(0x20a)][_0x5db7a1(0x573)][_0x5db7a1(0x19e)][_0x5db7a1(0x28d)+_0x5db7a1(0x534)]??![],'unlimitedUse':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x573)][_0x5db7a1(0x19e)][_0x5db7a1(0x2ef)+_0x5db7a1(0x3f6)]??'∞','variableCostFmt':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x573)][_0x5db7a1(0x19e)][_0x5db7a1(0xce)+'mat']??_0x5db7a1(0x13f),'itemCostFmt':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x573)]['Vocab'][_0x5db7a1(0x4cc)+_0x5db7a1(0x476)]??_0x5db7a1(0x13f),'weaponCostFmt':VisuMZ[_0x5db7a1(0x50f)+'ngSeeds'][_0x5db7a1(0x573)][_0x5db7a1(0x19e)][_0x5db7a1(0x563)+_0x5db7a1(0x2bb)]??_0x5db7a1(0x13f),'armorCostFmt':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)]['Settings'][_0x5db7a1(0x19e)]['CostArmorF'+_0x5db7a1(0x1dc)]??'(×%2-%1)','skillUserFmt':VisuMZ[_0x5db7a1(0x50f)+'ngSeeds']['Settings'][_0x5db7a1(0x19e)]['CostSkillU'+_0x5db7a1(0x3c7)]??'[%1]','skillUserCostFmt':VisuMZ[_0x5db7a1(0x50f)+'ngSeeds'][_0x5db7a1(0x573)][_0x5db7a1(0x19e)][_0x5db7a1(0x2db)+_0x5db7a1(0x39d)]??_0x5db7a1(0x103)},'effectList':{'displayFmt':VisuMZ['DiceRollsR'+_0x5db7a1(0x20a)]['Settings'][_0x5db7a1(0x19e)][_0x5db7a1(0x4a8)+_0x5db7a1(0x127)]??'\x5c}%1\x5c{','effectTextFmt':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)]['Settings'][_0x5db7a1(0x19e)][_0x5db7a1(0x2e7)+_0x5db7a1(0x2a3)]??'%1\x20%2','orderFmt':VisuMZ['DiceRollsR'+_0x5db7a1(0x20a)]['Settings'][_0x5db7a1(0x19e)][_0x5db7a1(0x4b6)+'mt']??_0x5db7a1(0x4ee),'plusSign':VisuMZ[_0x5db7a1(0x50f)+'ngSeeds'][_0x5db7a1(0x573)][_0x5db7a1(0x19e)][_0x5db7a1(0x5c0)+_0x5db7a1(0x2b5)]??!![],'diceCountFmt':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x573)][_0x5db7a1(0x19e)][_0x5db7a1(0x56e)]??_0x5db7a1(0x1fd),'advantageFmt':VisuMZ[_0x5db7a1(0x50f)+'ngSeeds']['Settings'][_0x5db7a1(0x19e)][_0x5db7a1(0x30f)+_0x5db7a1(0x32c)]??'Adv%1','disadvantageFmt':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x573)][_0x5db7a1(0x19e)]['DiceDisadv'+_0x5db7a1(0x1b3)]??_0x5db7a1(0x21c),'rankFmt':VisuMZ[_0x5db7a1(0x50f)+'ngSeeds']['Settings']['Vocab']['DiceRank']??_0x5db7a1(0x3cc),'modifierFmt':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x573)][_0x5db7a1(0x19e)][_0x5db7a1(0x596)+'er']??_0x5db7a1(0x505)},'subtitle':{'total':VisuMZ[_0x5db7a1(0x50f)+'ngSeeds']['Settings'][_0x5db7a1(0x19e)][_0x5db7a1(0x51a)+'tal']??'Roll\x20for\x20\x5c'+_0x5db7a1(0x212)+_0x5db7a1(0x20b)+'er','highest':VisuMZ['DiceRollsR'+_0x5db7a1(0x20a)][_0x5db7a1(0x573)][_0x5db7a1(0x19e)]['SubtitleHi'+'ghest']??_0x5db7a1(0x527)+_0x5db7a1(0x50d)+_0x5db7a1(0x4d6)+_0x5db7a1(0x501),'average':VisuMZ['DiceRollsR'+_0x5db7a1(0x20a)][_0x5db7a1(0x573)][_0x5db7a1(0x19e)][_0x5db7a1(0xb9)+_0x5db7a1(0x2e9)]??_0x5db7a1(0x527)+'C[21]avera'+_0x5db7a1(0x294)+'mber','lowest':VisuMZ['DiceRollsR'+_0x5db7a1(0x20a)][_0x5db7a1(0x573)][_0x5db7a1(0x19e)][_0x5db7a1(0x3f5)+'west']??_0x5db7a1(0x527)+_0x5db7a1(0x4ac)+_0x5db7a1(0x44d)+'ber','aboveTarget':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)]['Settings'][_0x5db7a1(0x19e)][_0x5db7a1(0x422)+_0x5db7a1(0x2c8)]??_0x5db7a1(0x2cf)+'culty\x20Clas'+_0x5db7a1(0x2ed)+'ove\x20\x5cC[24]'+_0x5db7a1(0x40c),'aboveEqualTarget':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)]['Settings'][_0x5db7a1(0x19e)][_0x5db7a1(0x422)+_0x5db7a1(0x36f)+'rget']??_0x5db7a1(0x2cf)+_0x5db7a1(0x540)+'s:\x5cC[0]\x20At'+_0x5db7a1(0x2a0)+'24]%1\x5cC[0]','belowEqualTarget':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x573)][_0x5db7a1(0x19e)]['SubtitleBe'+_0x5db7a1(0x4bb)+'rget']??_0x5db7a1(0x2cf)+_0x5db7a1(0x540)+_0x5db7a1(0x152)+_0x5db7a1(0x111)+_0x5db7a1(0x568),'belowTarget':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)]['Settings'][_0x5db7a1(0x19e)]['SubtitleBe'+_0x5db7a1(0x425)]??_0x5db7a1(0x2cf)+_0x5db7a1(0x540)+_0x5db7a1(0x5b8)+'low\x20\x5cC[24]'+'%1\x5cC[0]','criticalSuccess':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)]['Settings'][_0x5db7a1(0x19e)]['SubtitleCr'+'itSuccess']??_0x5db7a1(0x327)+_0x5db7a1(0x43e)+'SS!\x5cC[0]','criticalFailure':VisuMZ['DiceRollsR'+_0x5db7a1(0x20a)]['Settings'][_0x5db7a1(0x19e)]['SubtitleCr'+_0x5db7a1(0x214)]??_0x5db7a1(0x498)+'CAL\x20FAILUR'+_0x5db7a1(0x609)}},TextManager[_0x5db7a1(0x2ee)+'lSubtitle']=function(){const _0x56fc7a=_0x5db7a1,_0x141bf0={'ZFgoq':_0x56fc7a(0x203),'uEBkU':_0x56fc7a(0x5bf),'gFmyh':_0x56fc7a(0xf7),'SVxVa':'lowest','peDOT':_0x56fc7a(0x1d5)+'t','XtekS':_0x56fc7a(0x39f)+_0x56fc7a(0xd7),'CBOhH':_0x56fc7a(0x558)+'Target','MFNYZ':_0x56fc7a(0x367)+'t'},_0x2bf446=SceneManager[_0x56fc7a(0x2aa)+_0x56fc7a(0x2d2)]||{},_0x26b685=_0x2bf446[_0x56fc7a(0x3aa)][_0x56fc7a(0x12c)]();switch(_0x26b685){case _0x141bf0[_0x56fc7a(0x27b)]:case _0x141bf0[_0x56fc7a(0x49b)]:case _0x141bf0[_0x56fc7a(0x4dc)]:case _0x141bf0[_0x56fc7a(0x376)]:return TextManager[_0x56fc7a(0x28a)][_0x56fc7a(0x431)][_0x26b685]||'';case _0x141bf0['peDOT']:case _0x141bf0[_0x56fc7a(0x228)]:case _0x141bf0['CBOhH']:case _0x141bf0[_0x56fc7a(0x27e)]:const _0x38d14d=_0x2bf446[_0x56fc7a(0x315)+'e']||-0x1b9+-0x1*0x107e+0x1237,_0x5d07a0=TextManager[_0x56fc7a(0x28a)][_0x56fc7a(0x431)][_0x26b685]||'';return _0x5d07a0[_0x56fc7a(0x13e)](_0x38d14d);}return'';},TextManager['getDiceRol'+_0x5db7a1(0x292)+'xt']=function(_0x378d8b){const _0x1aed7f=_0x5db7a1,_0x561db8={'Xeiul':function(_0x4f4386,_0x16d5ba){return _0x4f4386===_0x16d5ba;},'kHDpc':'rollValue','VmWyi':function(_0x40c275,_0x4a4564){return _0x40c275(_0x4a4564);},'nUlgD':function(_0x4f0bd3,_0xb68943){return _0x4f0bd3>=_0xb68943;},'juVzP':function(_0x16dfc1,_0x30c116){return _0x16dfc1+_0x30c116;},'hYEzK':function(_0x20ccad,_0x280930){return _0x20ccad>=_0x280930;},'PYBuK':_0x1aed7f(0x1a4)+'[0]','IaFRb':function(_0x3cab92,_0x37e419){return _0x3cab92(_0x37e419);},'CMryN':function(_0x2477dc,_0x6adae0){return _0x2477dc>=_0x6adae0;},'lfQsL':function(_0x1308f5,_0x442da0){return _0x1308f5>=_0x442da0;},'YgsRN':function(_0x18317e,_0x1bebfd){return _0x18317e+_0x1bebfd;},'WzqoZ':function(_0x5aede8,_0x221e9e){return _0x5aede8(_0x221e9e);},'iSPaG':function(_0x19f4d4,_0x2669ba){return _0x19f4d4||_0x2669ba;},'AsgOS':function(_0x30e176,_0x342862){return _0x30e176>_0x342862;},'dVNkd':function(_0x138c9b,_0xc5b6a5){return _0x138c9b>=_0xc5b6a5;},'auIDZ':function(_0x9203d2,_0x4d03be){return _0x9203d2+_0x4d03be;},'xkfrr':function(_0x2fb6ab,_0x94aa02){return _0x2fb6ab!==_0x94aa02;},'JjCrk':function(_0x47bc9b,_0x35c381){return _0x47bc9b>_0x35c381;},'sDQrw':_0x1aed7f(0x3bd),'RirTU':function(_0x49c213,_0x15c428){return _0x49c213>=_0x15c428;}};if(!_0x378d8b)return'';const _0x495d4a=SceneManager[_0x1aed7f(0x2aa)+_0x1aed7f(0x2d2)]||{},_0x726157=TextManager[_0x1aed7f(0x28a)][_0x1aed7f(0x2f1)],_0x42c508=TextManager[_0x1aed7f(0x28a)][_0x1aed7f(0x5d7)],_0x43097e=_0x726157['plusSign'];let _0x350f72='';if(_0x378d8b[_0x1aed7f(0x59e)]){if(_0x561db8[_0x1aed7f(0x1f0)](_0x495d4a[_0x1aed7f(0x233)],_0x561db8['kHDpc'])){let _0xa4ae48=_0x561db8[_0x1aed7f(0x253)](String,_0x378d8b[_0x1aed7f(0x59e)]);if(_0x43097e&&_0x561db8[_0x1aed7f(0x4ca)](_0x378d8b[_0x1aed7f(0x59e)],-0x86*-0x3+-0x13*0x91+0x931))_0xa4ae48=_0x561db8[_0x1aed7f(0x343)]('+',_0xa4ae48);_0x350f72=_0x726157[_0x1aed7f(0x364)+'mt'][_0x1aed7f(0x13e)](_0xa4ae48);}else{let _0x59bfdf=_0x561db8[_0x1aed7f(0x253)](String,Math[_0x1aed7f(0x553)](_0x378d8b[_0x1aed7f(0x59e)]));if(_0x43097e)_0x59bfdf=_0x561db8[_0x1aed7f(0x343)]('+',_0x59bfdf);const _0x1f74fe=_0x561db8[_0x1aed7f(0x202)](_0x378d8b[_0x1aed7f(0x59e)],0x92*0xb+-0x2c4+-0x382)?_0x726157[_0x1aed7f(0x21f)+'mt']:_0x726157[_0x1aed7f(0xcd)+_0x1aed7f(0x4f1)];_0x350f72=_0x1f74fe['format'](_0x59bfdf);}const _0x575ea0=_0x561db8[_0x1aed7f(0x4ca)](_0x378d8b[_0x1aed7f(0x59e)],-0x1*0x232f+0xdb*-0x23+-0x1*-0x4120)?_0x42c508['diceUpColo'+'r']:_0x42c508[_0x1aed7f(0xbf)+_0x1aed7f(0x4cb)];_0x350f72=_0x561db8['PYBuK']['format'](_0x350f72,_0x575ea0);}let _0x304498='';if(_0x378d8b[_0x1aed7f(0x18d)]){let _0x37e966=_0x561db8['IaFRb'](String,_0x378d8b[_0x1aed7f(0x18d)]);if(_0x43097e&&_0x561db8[_0x1aed7f(0x583)](_0x378d8b['DiceRank'],-0x1*-0x102b+-0x577*0x5+0xb28))_0x37e966=_0x561db8[_0x1aed7f(0x343)]('+',_0x37e966);_0x304498=_0x726157['rankFmt'][_0x1aed7f(0x13e)](_0x37e966);const _0x321ebd=_0x561db8[_0x1aed7f(0x5a4)](_0x378d8b['DiceRank'],-0x9*-0xdf+-0x1693+0x17*0xa4)?_0x42c508[_0x1aed7f(0xd8)+'r']:_0x42c508[_0x1aed7f(0x323)+_0x1aed7f(0x4cb)];_0x304498=_0x561db8[_0x1aed7f(0x3ca)][_0x1aed7f(0x13e)](_0x304498,_0x321ebd);}let _0x37335a='';if(_0x378d8b[_0x1aed7f(0x596)+'er']||_0x378d8b['DiceModifi'+_0x1aed7f(0x569)]){const _0x2001aa=_0x378d8b[_0x1aed7f(0x596)+'er']||0x1a29+0xfc+-0x1b25,_0x2e3441=_0x561db8[_0x1aed7f(0x395)](_0x2001aa,_0x378d8b[_0x1aed7f(0x596)+_0x1aed7f(0x569)]||0x17b*0x1a+-0xf*0x1df+-0x1*0xa6d),_0x571c84=Math['min'](_0x2001aa,_0x2e3441),_0x5131e2=Math[_0x1aed7f(0x508)](_0x2001aa,_0x2e3441);let _0x29fc6c=_0x561db8[_0x1aed7f(0x151)](String,_0x561db8['iSPaG'](_0x571c84,-0xe6d*-0x1+0x3d*0x4f+-0x2140));_0x561db8[_0x1aed7f(0x5ce)](Math[_0x1aed7f(0x553)](_0x571c84),Math['abs'](_0x5131e2))&&(_0x29fc6c=_0x561db8[_0x1aed7f(0x151)](String,_0x561db8[_0x1aed7f(0x124)](_0x5131e2,-0x2af*-0x1+-0xf8c+0xcdd)));if(_0x43097e&&_0x561db8['dVNkd'](_0x571c84,0x18+0x2*0xe75+-0x1d02))_0x29fc6c=_0x561db8[_0x1aed7f(0x341)]('+',_0x29fc6c);_0x561db8['xkfrr'](_0x5131e2,_0x571c84)&&(_0x561db8[_0x1aed7f(0x58c)](Math['abs'](_0x571c84),Math['abs'](_0x5131e2))?_0x29fc6c=_0x561db8['sDQrw'][_0x1aed7f(0x13e)](_0x29fc6c,_0x571c84):_0x29fc6c=_0x561db8[_0x1aed7f(0x14d)][_0x1aed7f(0x13e)](_0x29fc6c,_0x5131e2));_0x37335a=_0x726157[_0x1aed7f(0x435)+'t'][_0x1aed7f(0x13e)](_0x29fc6c);const _0x359581=_0x561db8[_0x1aed7f(0x583)](_0x571c84,-0x18*0xdd+-0x1*-0x1c65+0x3*-0x28f)||_0x561db8[_0x1aed7f(0xe4)](_0x5131e2,-0x11f6+-0x2012+0x3208)?_0x42c508[_0x1aed7f(0x50b)]:_0x42c508['modDownCol'+'or'];_0x37335a=_0x561db8[_0x1aed7f(0x3ca)][_0x1aed7f(0x13e)](_0x37335a,_0x359581);}let _0x41a7ca=_0x726157[_0x1aed7f(0x289)][_0x1aed7f(0x13e)](_0x350f72,_0x304498,_0x37335a)['trim']();return _0x41a7ca=_0x41a7ca[_0x1aed7f(0x2ec)](/[ ][ ]*/gi,'\x20'),_0x41a7ca=_0x41a7ca['replace'](/[ ]*\\}[ ]*/gi,'\x5c}'),_0x41a7ca=_0x41a7ca[_0x1aed7f(0x2ec)](/[ ]*\\{[ ]*/gi,'\x5c{'),_0x41a7ca[_0x1aed7f(0x12c)]();},ColorManager['getColor']=function(_0x442d78){const _0xa01911=_0x5db7a1,_0x2eb649={'zmxHL':function(_0x218321,_0x2b7b72){return _0x218321(_0x2b7b72);},'wiwTY':_0xa01911(0x262),'fykaZ':function(_0x11b68c,_0xf3d62f){return _0x11b68c(_0xf3d62f);}};return _0x442d78=_0x2eb649[_0xa01911(0x25e)](String,_0x442d78),_0x442d78[_0xa01911(0x316)](/#(.*)/i)?_0x2eb649[_0xa01911(0x53b)]['format'](_0x2eb649[_0xa01911(0x4a5)](String,RegExp['$1'])):this['textColor'](_0x2eb649[_0xa01911(0x25e)](Number,_0x442d78));},ColorManager[_0x5db7a1(0x314)+'r']=function(_0x8df970,_0x2a9d77){const _0xe0b7d0=_0x5db7a1,_0x3cbbba={'ZwuMj':function(_0x1230d8,_0x13d175){return _0x1230d8||_0x13d175;},'CLiUH':function(_0x400615,_0x3bb1a6,_0x3ba2cf){return _0x400615(_0x3bb1a6,_0x3ba2cf);},'CJfMQ':function(_0x42010f,_0x4aa16e){return _0x42010f*_0x4aa16e;},'Rqgvc':function(_0x31d154,_0xe75ade){return _0x31d154+_0xe75ade;},'FUrAf':function(_0x6f7e89,_0xa3ceae){return _0x6f7e89+_0xa3ceae;}};_0x2a9d77=_0x3cbbba[_0xe0b7d0(0x324)](_0x2a9d77,0x1b8e+0x640+-0x2*0x10e7);let _0x4e2c76=ColorManager['getColor'](_0x8df970),_0x4ee29d=_0x3cbbba[_0xe0b7d0(0x525)](parseInt,_0x4e2c76[_0xe0b7d0(0x4b2)](0x109+0x1423+-0x152b,0x232a+0xf86*0x2+-0x4233),-0x1ee9+-0x1089+-0x1*-0x2f82),_0x3e204f=_0x3cbbba[_0xe0b7d0(0x525)](parseInt,_0x4e2c76['slice'](-0x17*-0x16f+0x2239+-0x31*0x15f,-0x2695+-0x1697*0x1+0x3d31),0x175+0x2143+-0x22a8),_0x53e63b=_0x3cbbba[_0xe0b7d0(0x525)](parseInt,_0x4e2c76[_0xe0b7d0(0x4b2)](-0x879+0x75e+-0x12*-0x10,-0x1*0xc5d+0x2*0xecc+0x44d*-0x4),0xd68+-0x25f*-0xa+0x12*-0x20f);return _0x4ee29d=Math['max'](0xed5*-0x2+-0xaae+-0x2858*-0x1,Math['min'](0x1f6b*-0x1+0x15c2+0x7c*0x16,Math[_0xe0b7d0(0x19f)](_0x3cbbba['CJfMQ'](_0x4ee29d,_0x2a9d77))))[_0xe0b7d0(0x4df)](-0x1*-0x1439+0x2341+-0x376a*0x1),_0x3e204f=Math['max'](0x76a+-0x1e18+0x16ae,Math[_0xe0b7d0(0x1fb)](0xd6+0x13*0xed+-0x116e,Math[_0xe0b7d0(0x19f)](_0x3cbbba[_0xe0b7d0(0xe0)](_0x3e204f,_0x2a9d77))))['toString'](-0x1324+-0x2d*-0x77+-0x1b7*0x1),_0x53e63b=Math[_0xe0b7d0(0x508)](0xcd*0x9+0x2516*0x1+-0x2c4b,Math['min'](-0x1a7a*-0x1+-0x5e*-0x5d+-0x163*0x2b,Math[_0xe0b7d0(0x19f)](_0x3cbbba[_0xe0b7d0(0xe0)](_0x53e63b,_0x2a9d77))))[_0xe0b7d0(0x4df)](-0x1f67+0xf80*-0x1+0x2ef7),_0x3cbbba['Rqgvc'](_0x3cbbba[_0xe0b7d0(0x570)](_0x3cbbba[_0xe0b7d0(0x570)]('#',_0x4ee29d[_0xe0b7d0(0x1fe)](-0x1804+-0x32+-0x4*-0x60e,'0')),_0x3e204f['padStart'](0x54*0x4+-0x10c2+0xf74,'0')),_0x53e63b['padStart'](0x110b*-0x1+0xd27*-0x1+-0xf1a*-0x2,'0'));},SceneManager['isRollingD'+_0x5db7a1(0x38b)]=function(){const _0x488999=_0x5db7a1;return this[_0x488999(0x47f)];},SceneManager[_0x5db7a1(0x5fd)+'e']=function(){const _0x3c11fd=_0x5db7a1,_0x385118={'PdlCm':'Cannot\x20rol'+'l\x20multiple'+_0x3c11fd(0x53a)+'he\x20same\x20ti'+_0x3c11fd(0x436),'FWgKK':_0x3c11fd(0x1b7)+_0x3c11fd(0x134)+_0x3c11fd(0x1bc),'TiTom':_0x3c11fd(0x1b7)+_0x3c11fd(0x134)+_0x3c11fd(0xee)+_0x3c11fd(0x1b9)+_0x3c11fd(0x512),'iWslC':_0x3c11fd(0x1b7)+'l\x20dice\x20dur'+_0x3c11fd(0x243)+'Combo\x20Skil'+_0x3c11fd(0x13d),'HsicV':_0x3c11fd(0x1b7)+_0x3c11fd(0x134)+_0x3c11fd(0x5b4)+_0x3c11fd(0x194)+_0x3c11fd(0x132)};if(this[_0x3c11fd(0x5b6)+_0x3c11fd(0x38b)]()){if($gameTemp[_0x3c11fd(0x36a)]()){const _0x3bc39a=_0x385118[_0x3c11fd(0x52f)];console[_0x3c11fd(0x537)](_0x3bc39a);}return![];}if(Imported[_0x3c11fd(0x520)+_0x3c11fd(0x482)+_0x3c11fd(0x3d2)]){if(this[_0x3c11fd(0x45c)+'TE']()){if($gameTemp[_0x3c11fd(0x36a)]()){const _0x235a61=_0x385118['FWgKK'];console[_0x3c11fd(0x537)](_0x235a61);}return![];}}if(this[_0x3c11fd(0x53f)+_0x3c11fd(0x447)]()){const _0x9753e=this[_0x3c11fd(0x1f8)]['_logWindow'];if(Imported[_0x3c11fd(0x25a)+_0x3c11fd(0x2e5)+_0x3c11fd(0x160)]){if(this[_0x3c11fd(0x1f8)][_0x3c11fd(0x260)+_0x3c11fd(0x5cb)+'iVisible']()){const _0x37465b=_0x385118[_0x3c11fd(0x5cc)];return console[_0x3c11fd(0x537)](_0x37465b),![];}}if(Imported[_0x3c11fd(0x53c)+_0x3c11fd(0xca)+'kills']){if(_0x9753e[_0x3c11fd(0x183)+_0x3c11fd(0x429)]){const _0x16fb82=_0x385118[_0x3c11fd(0x391)];return console[_0x3c11fd(0x537)](_0x16fb82),![];}}if(Imported[_0x3c11fd(0x4c2)+_0x3c11fd(0x418)+_0x3c11fd(0x1af)]){if(_0x9753e[_0x3c11fd(0x3e2)+_0x3c11fd(0x281)]){const _0x3d828b=_0x385118[_0x3c11fd(0x585)];return console['log'](_0x3d828b),![];}}}return!this[_0x3c11fd(0x47f)];},SceneManager['setupDiceR'+_0x5db7a1(0xc0)]=function(_0x372689){const _0xd7adae=_0x5db7a1,_0x2f15c3={'qxoXx':_0xd7adae(0x399)};if(!this[_0xd7adae(0x5fd)+'e']())return;this['_diceRoll']=!![],this[_0xd7adae(0x2aa)+_0xd7adae(0x2d2)]=_0x372689,this[_0xd7adae(0x45b)+_0xd7adae(0x488)]=0x302*0x4+0x902*0x2+-0x1*0x1e0c,this['setupDiceE'+_0xd7adae(0x231)]();const _0x177a6e=$gameTemp[_0xd7adae(0xf5)+_0xd7adae(0xea)+'Interprete'+'r']();_0x177a6e&&_0x177a6e['setWaitMod'+'e'](_0x2f15c3[_0xd7adae(0x5ac)]);const _0x6ccfe6=this[_0xd7adae(0x1f8)];_0x6ccfe6?(this['_diceRollD'+_0xd7adae(0x488)]=0xa8a+0x1582*0x1+0x1*-0x1fd0,_0x6ccfe6[_0xd7adae(0x288)+'oll']()):this['endDiceRol'+'l']();},SceneManager['setupDiceE'+_0x5db7a1(0x231)]=function(){const _0x39b8fa=_0x5db7a1,_0x4257ab=this[_0x39b8fa(0x2aa)+'ettings'];_0x4257ab[_0x39b8fa(0x1a1)]=[],_0x4257ab[_0x39b8fa(0x17a)]=0x1b1+0x1261+-0x1412,_0x4257ab[_0x39b8fa(0x564)]=0x2f6*0x9+-0x1*-0x188c+-0x3332,_0x4257ab['modifiers']=0x1*-0x1dae+0x1e58*-0x1+-0x3c06*-0x1,_0x4257ab['modRand']=0x1d11+-0x232b*0x1+0x61a,this['setupDiceA'+_0x39b8fa(0x407)](),this[_0x39b8fa(0x16e)+_0x39b8fa(0x385)+'s']();},VisuMZ['DiceRollsR'+_0x5db7a1(0x20a)][_0x5db7a1(0x17f)+_0x5db7a1(0x532)]=[_0x5db7a1(0xde)+'ects',_0x5db7a1(0x1c2)+_0x5db7a1(0x4da),_0x5db7a1(0x1ed)+'s',_0x5db7a1(0x5a9)+_0x5db7a1(0x427),_0x5db7a1(0x606)+'ts'],SceneManager[_0x5db7a1(0x5eb)+_0x5db7a1(0x407)]=function(){const _0x4c4ba9=_0x5db7a1,_0xc7e8ba=this[_0x4c4ba9(0x2aa)+_0x4c4ba9(0x2d2)],_0x460fba=_0xc7e8ba['AutoMods']||{},_0x29cadd=VisuMZ[_0x4c4ba9(0x50f)+_0x4c4ba9(0x20a)][_0x4c4ba9(0x17f)+'T_KEYS'][_0x4c4ba9(0x175)]();for(const _0x29777d of _0x29cadd){if(!_0x460fba[_0x29777d])continue;const _0x2fca1d=_0x460fba[_0x29777d]||[];for(const _0x23202c of _0x2fca1d){this[_0x4c4ba9(0x2c6)+'utoEffectC'+_0x4c4ba9(0x259)](_0x23202c)&&this[_0x4c4ba9(0x516)+_0x4c4ba9(0x272)](_0x23202c);}}if(_0x460fba[_0x4c4ba9(0x248)+'ts']){const _0x254178=_0x460fba[_0x4c4ba9(0x248)+'ts']||[];for(const _0x3d7323 of _0x254178){const _0x3c4abf=this[_0x4c4ba9(0x109)+_0x4c4ba9(0x2eb)+'es'](_0x3d7323);for(const _0x35cedf of _0x3c4abf){this[_0x4c4ba9(0x2c6)+_0x4c4ba9(0x4d7)+'onditions'](_0x35cedf)&&this[_0x4c4ba9(0x516)+_0x4c4ba9(0x272)](_0x35cedf);}}}},SceneManager[_0x5db7a1(0x2c6)+_0x5db7a1(0x4d7)+_0x5db7a1(0x259)]=function(_0x3f9621){const _0x16a6a9=_0x5db7a1,_0x1c64a5={'GIpSy':function(_0x36cc3f,_0x477ec5){return _0x36cc3f<_0x477ec5;},'OvnZL':function(_0x5f1961,_0x28f6ec){return _0x5f1961<_0x28f6ec;}};if(_0x3f9621[_0x16a6a9(0x3bb)+_0x16a6a9(0x5e6)]){const _0x436c09=_0x3f9621[_0x16a6a9(0x3bb)+_0x16a6a9(0x1b0)]??-0x1*-0x1fff+-0x2157+0x159;if(_0x1c64a5[_0x16a6a9(0x11e)]($gameVariables['value'](_0x3f9621['VariableRe'+_0x16a6a9(0x5e6)]),_0x436c09))return![];}if(_0x3f9621[_0x16a6a9(0x5b7)]){const _0x307d39=$dataItems[_0x3f9621[_0x16a6a9(0x5b7)]],_0x2fe00f=_0x3f9621[_0x16a6a9(0x578)+'ue']??-0x24*0xe2+-0x1*0x1e2f+0x3df8;if(_0x1c64a5[_0x16a6a9(0x4e7)]($gameParty[_0x16a6a9(0x4ae)](_0x307d39),_0x2fe00f))return![];}if(_0x3f9621[_0x16a6a9(0x1c7)+'D']){const _0x47b74d=$dataWeapons[_0x3f9621[_0x16a6a9(0x1c7)+'D']],_0x1d65b1=_0x3f9621[_0x16a6a9(0x3db)+_0x16a6a9(0x1a9)];if(!$gameParty[_0x16a6a9(0x1f9)](_0x47b74d,_0x1d65b1))return![];}if(_0x3f9621[_0x16a6a9(0x21b)]){const _0x121fc3=$dataArmors[_0x3f9621[_0x16a6a9(0x21b)]],_0x45f095=_0x3f9621[_0x16a6a9(0x57a)+_0x16a6a9(0x483)];if(!$gameParty[_0x16a6a9(0x1f9)](_0x121fc3,_0x45f095))return![];}if(_0x3f9621[_0x16a6a9(0x419)]){const _0x5329eb=$gameActors[_0x16a6a9(0x154)](_0x3f9621['SkillUserA'+'ctorID']);if(!_0x5329eb)return![];if(_0x3f9621[_0x16a6a9(0x477)+'live']&&_0x5329eb[_0x16a6a9(0x5e8)]())return![];}if(_0x3f9621[_0x16a6a9(0x26b)]){if(!$gameSwitches[_0x16a6a9(0x3b0)](_0x3f9621[_0x16a6a9(0x26b)]))return![];}if(_0x3f9621[_0x16a6a9(0x33a)+'S']){if(!_0x3f9621['ConditionJ'+'S']())return![];}return!![];},SceneManager[_0x5db7a1(0x516)+_0x5db7a1(0x272)]=function(_0x409afe){const _0x4dc906=_0x5db7a1,_0x73e47e=this[_0x4dc906(0x2aa)+'ettings'];_0x73e47e[_0x4dc906(0x1a1)][_0x4dc906(0x1bd)](_0x409afe),_0x409afe['Advantage']&&(_0x73e47e[_0x4dc906(0x17a)]+=_0x409afe[_0x4dc906(0x59e)]),_0x409afe[_0x4dc906(0x18d)]&&(_0x73e47e['rankAdjust']+=_0x409afe[_0x4dc906(0x18d)]),_0x409afe['DiceModifi'+'er']&&(_0x73e47e[_0x4dc906(0x55c)]+=_0x409afe[_0x4dc906(0x596)+'er']),_0x409afe['DiceModifi'+_0x4dc906(0x569)]&&(_0x73e47e[_0x4dc906(0x1ca)]+=_0x409afe[_0x4dc906(0x596)+_0x4dc906(0x569)]);},SceneManager[_0x5db7a1(0x109)+_0x5db7a1(0x2eb)+'es']=function(_0x4c7edf){const _0x552c34=_0x5db7a1,_0x1c9074={'uAReD':function(_0x29dbc6,_0x1f4f71){return _0x29dbc6<=_0x1f4f71;},'PJiRh':_0x552c34(0x171),'UyhDL':_0x552c34(0x133),'VYNCN':_0x552c34(0x452)+'ember','AwxkW':_0x552c34(0x366)+_0x552c34(0x1ad),'haTtb':function(_0x300109,_0x3d812d){return _0x300109===_0x3d812d;},'qaiYS':function(_0x154e09,_0x3bf178){return _0x154e09===_0x3bf178;},'RTgJU':function(_0x44eeff,_0x681c93){return _0x44eeff===_0x681c93;},'OByzh':_0x552c34(0x1cb)+'r','XVGSV':'everyBattl'+_0x552c34(0x3f7),'gcAYS':_0x552c34(0x1e8)+_0x552c34(0x1df),'JhjVk':function(_0x481650,_0x19c93a){return _0x481650===_0x19c93a;},'lgHjF':_0x552c34(0x513),'mTUhz':'SpecificAc'+'torIDs'},_0x41ca25=_0x4c7edf['SkillReqID']||_0x4c7edf[_0x552c34(0x396)+'D']||0xafb+0x6e+-0xb69;if(_0x1c9074['uAReD'](_0x41ca25,-0x9f*0x7+-0x833+-0x16*-0x92))return[];const _0xa61d31=$dataSkills[_0x41ca25];if(!_0xa61d31)return[];const _0x704843=_0x4c7edf[_0x552c34(0x190)+'edOnly']??![],_0x104046=[],_0x5d720c=_0x4c7edf[_0x552c34(0x513)];switch(_0x5d720c){case _0x1c9074[_0x552c34(0x368)]:$gameParty[_0x552c34(0x171)]()&&_0x104046[_0x552c34(0x1bd)]($gameParty[_0x552c34(0x171)]()[_0x552c34(0x249)]());break;case _0x1c9074['UyhDL']:case _0x1c9074[_0x552c34(0xe2)]:case _0x1c9074[_0x552c34(0x44f)]:{let _0x33b82d=[];if(_0x1c9074[_0x552c34(0x33c)](_0x5d720c,_0x1c9074[_0x552c34(0x481)]))_0x33b82d=$gameParty[_0x552c34(0x2fd)]();else{if(_0x1c9074[_0x552c34(0x45e)](_0x5d720c,_0x1c9074['VYNCN']))_0x33b82d=$gameParty[_0x552c34(0x182)+_0x552c34(0x4a1)]();else{if(_0x1c9074[_0x552c34(0x31e)](_0x5d720c,_0x1c9074['AwxkW'])){const _0x21d821=_0x4c7edf[_0x552c34(0x575)+_0x552c34(0x5f9)]||[];_0x33b82d=_0x21d821[_0x552c34(0x3fc)](_0xfbd595=>$gameActors[_0x552c34(0x154)](_0xfbd595))[_0x552c34(0x524)](_0x41cb03=>$gameParty[_0x552c34(0x2fd)]()[_0x552c34(0x135)](_0x41cb03));}}}const _0x30064f=_0x33b82d['find'](_0x3b4ad0=>_0x3b4ad0&&(_0x704843?_0x3b4ad0[_0x552c34(0x377)+_0x552c34(0x1bb)](_0x41ca25):_0x3b4ad0[_0x552c34(0x442)](_0x41ca25))&&_0x3b4ad0[_0x552c34(0x48b)+_0x552c34(0xd6)](_0xa61d31));if(_0x30064f)_0x104046[_0x552c34(0x1bd)](_0x30064f[_0x552c34(0x249)]());}break;case _0x1c9074[_0x552c34(0x4aa)]:case _0x1c9074[_0x552c34(0x55d)]:case _0x1c9074[_0x552c34(0x347)]:{let _0x59ff8d=[];if(_0x1c9074[_0x552c34(0x31e)](_0x5d720c,_0x1c9074[_0x552c34(0x4aa)]))_0x59ff8d=$gameParty[_0x552c34(0x2fd)]();else{if(_0x1c9074[_0x552c34(0x31e)](_0x5d720c,_0x1c9074[_0x552c34(0x55d)]))_0x59ff8d=$gameParty[_0x552c34(0x182)+_0x552c34(0x4a1)]();else{if(_0x1c9074['JhjVk'](_0x5d720c,_0x1c9074[_0x552c34(0x347)])){const _0x3b1053=_0x4c7edf['SpecificAc'+_0x552c34(0x5f9)]||[];_0x59ff8d=_0x3b1053['map'](_0x31b82d=>$gameActors[_0x552c34(0x154)](_0x31b82d))['filter'](_0x283c94=>$gameParty[_0x552c34(0x2fd)]()['includes'](_0x283c94));}}}for(const _0x136d92 of _0x59ff8d){if(_0x704843&&!_0x136d92[_0x552c34(0x377)+_0x552c34(0x1bb)](_0x41ca25))continue;if(!_0x136d92['hasSkill'](_0x41ca25))continue;_0x104046[_0x552c34(0x1bd)](_0x136d92[_0x552c34(0x249)]());}}break;}if(_0x1c9074['uAReD'](_0x104046[_0x552c34(0x5de)],0x6cb*0x4+-0x5*-0x2b3+-0x28ab))return[];const _0x1d40a9=[],_0x459095=[_0x1c9074['lgHjF'],_0x1c9074[_0x552c34(0x577)]];for(const _0x154edf of _0x104046){const _0x8ca7d9={};_0x8ca7d9[_0x552c34(0x477)+'ctorID']=_0x154edf;for(const _0x502ae9 in _0x4c7edf){if(_0x459095[_0x552c34(0x135)](_0x502ae9))continue;_0x8ca7d9[_0x502ae9]=_0x4c7edf[_0x502ae9];}_0x1d40a9[_0x552c34(0x1bd)](_0x8ca7d9);}return _0x1d40a9;},SceneManager[_0x5db7a1(0x16e)+_0x5db7a1(0x385)+'s']=function(){const _0x3dcfe6=_0x5db7a1,_0x21711d=this[_0x3dcfe6(0x2aa)+_0x3dcfe6(0x2d2)];_0x21711d['bonusEffec'+'ts']=[];const _0x5610e2=_0x21711d[_0x3dcfe6(0x47b)]||{},_0x5cac29=VisuMZ[_0x3dcfe6(0x50f)+'ngSeeds']['EFFECT_LIS'+_0x3dcfe6(0x532)][_0x3dcfe6(0x175)]();for(const _0xe519e7 of _0x5cac29){if(!_0x5610e2[_0xe519e7])continue;const _0x2400c3=_0x5610e2[_0xe519e7]||[];for(const _0x4ecc18 of _0x2400c3){this[_0x3dcfe6(0x57b)+'sEffectInc'+_0x3dcfe6(0x1e1)](_0x4ecc18)&&this[_0x3dcfe6(0x147)+_0x3dcfe6(0x239)](_0x4ecc18);}}if(_0x5610e2[_0x3dcfe6(0x248)+'ts']){const _0x2ee5e6=_0x5610e2[_0x3dcfe6(0x248)+'ts']||[];for(const _0x2a516d of _0x2ee5e6){const _0x351838=this[_0x3dcfe6(0x109)+_0x3dcfe6(0x2eb)+'es'](_0x2a516d);for(const _0x1c9682 of _0x351838){this[_0x3dcfe6(0x57b)+'sEffectInc'+'luded'](_0x1c9682)&&this[_0x3dcfe6(0x147)+_0x3dcfe6(0x239)](_0x1c9682);}}}},SceneManager['isDiceBonu'+'sEffectInc'+_0x5db7a1(0x1e1)]=function(_0x187ec5){const _0x561d8d=_0x5db7a1,_0x4c30d1={'VbZba':function(_0x206c81,_0x4c56b1){return _0x206c81<=_0x4c56b1;},'nefad':function(_0x3e16fe,_0x3cff9b){return _0x3e16fe<=_0x3cff9b;},'RcUSS':function(_0xccafe6,_0x3da755){return _0xccafe6<=_0x3da755;}};if(_0x187ec5[_0x561d8d(0x286)+'stID']){if(_0x4c30d1[_0x561d8d(0xc6)]($gameVariables[_0x561d8d(0x3b0)](_0x187ec5['VariableCo'+_0x561d8d(0x279)]),-0x15f9+0x34*-0x26+0x1db1*0x1))return![];}if(_0x187ec5[_0x561d8d(0x5c6)]){const _0x1669ee=$dataItems[_0x187ec5['ItemCostID']];if(_0x4c30d1[_0x561d8d(0xc6)]($gameParty[_0x561d8d(0x4ae)](_0x1669ee),-0x1b6a+0x183*-0x9+0x2905))return![];}if(_0x187ec5[_0x561d8d(0x4fe)+'ID']){const _0x4532ab=$dataWeapons[_0x187ec5[_0x561d8d(0x4fe)+'ID']];if(_0x4c30d1[_0x561d8d(0x1d3)]($gameParty[_0x561d8d(0x4ae)](_0x4532ab),0x2505+-0x1118+-0x13ed))return![];}if(_0x187ec5[_0x561d8d(0x2bc)+'D']){const _0x3a8249=$dataArmors[_0x187ec5[_0x561d8d(0x2bc)+'D']];if(_0x4c30d1[_0x561d8d(0x31c)]($gameParty[_0x561d8d(0x4ae)](_0x3a8249),0x14ed+-0x2*0x1be+-0x1171))return![];}if(_0x187ec5[_0x561d8d(0x396)+'D']){const _0x123df4=$gameActors[_0x561d8d(0x154)](_0x187ec5[_0x561d8d(0x477)+_0x561d8d(0x29b)]);if(!_0x123df4)return![];if(_0x187ec5[_0x561d8d(0x477)+_0x561d8d(0x38f)]&&_0x123df4['isDead']())return![];}if(_0x187ec5[_0x561d8d(0x551)+'ID']){if(!$gameSwitches[_0x561d8d(0x3b0)](_0x187ec5[_0x561d8d(0x551)+'ID']))return![];}if(_0x187ec5['ShowJS']){if(!_0x187ec5[_0x561d8d(0x536)]())return![];}return!![];},SceneManager['addDiceBon'+_0x5db7a1(0x239)]=function(_0x298004){const _0x4b65ef=_0x5db7a1,_0x4ff139=this[_0x4b65ef(0x2aa)+_0x4b65ef(0x2d2)];_0x4ff139['bonusEffec'+'ts']['push'](_0x298004),_0x298004[_0x4b65ef(0x4fa)]=Math[_0x4b65ef(0x508)](Math['ceil'](_0x298004['MaxUses']||0xc62+0x1*0x155d+0x7*-0x4d2),0x16d3+0x1685+-0x9f*0x49),_0x298004[_0x4b65ef(0x5dd)+'s']=0xc5*0xd+-0x1*0x165f+0xc5e;},SceneManager[_0x5db7a1(0x439)+'l']=function(){const _0x4ac754=_0x5db7a1;this[_0x4ac754(0x47f)]=![],this[_0x4ac754(0x2aa)+'ettings']=undefined;const _0x540305=this['_scene'];_0x540305&&_0x540305[_0x4ac754(0x439)+'l']();},SceneManager[_0x5db7a1(0x53f)+_0x5db7a1(0x447)]=function(){const _0x1e1e75=_0x5db7a1,_0x4635a5={'wFPxn':function(_0x197f24,_0x3ff5e9){return _0x197f24===_0x3ff5e9;}};return this[_0x1e1e75(0x1f8)]&&_0x4635a5[_0x1e1e75(0x1b4)](this['_scene'][_0x1e1e75(0xeb)+'r'],Scene_Battle);},Game_Temp[_0x5db7a1(0x4ce)][_0x5db7a1(0x3e8)+_0x5db7a1(0xea)+_0x5db7a1(0x607)+'r']=function(_0x3e5c52){const _0x3b42b0=_0x5db7a1;this[_0x3b42b0(0x318)+_0x3b42b0(0x2dc)+_0x3b42b0(0x2a7)]=_0x3e5c52;},Game_Temp[_0x5db7a1(0x4ce)][_0x5db7a1(0xf5)+_0x5db7a1(0xea)+_0x5db7a1(0x607)+'r']=function(){const _0xea82e3=_0x5db7a1;return this[_0xea82e3(0x318)+_0xea82e3(0x2dc)+_0xea82e3(0x2a7)];},VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x521)+'preter_Plu'+'ginCommand']=Game_Interpreter['prototype']['command357'],Game_Interpreter['prototype'][_0x5db7a1(0x441)]=function(_0x4a48fa){const _0x23805e=_0x5db7a1;return $gameTemp[_0x23805e(0x3e8)+_0x23805e(0xea)+_0x23805e(0x607)+'r'](this),VisuMZ[_0x23805e(0x50f)+'ngSeeds']['Game_Inter'+_0x23805e(0x3a1)+_0x23805e(0xea)][_0x23805e(0x23f)](this,_0x4a48fa);},VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x521)+'preter_upd'+'ateWaitMod'+'e']=Game_Interpreter[_0x5db7a1(0x4ce)][_0x5db7a1(0x278)+_0x5db7a1(0x543)],Game_Interpreter[_0x5db7a1(0x4ce)][_0x5db7a1(0x278)+_0x5db7a1(0x543)]=function(){const _0x4132d0=_0x5db7a1,_0x158e50={'qlqGO':function(_0x1f8056,_0x4af3a7){return _0x1f8056===_0x4af3a7;},'jnMjI':_0x4132d0(0x399)};if(_0x158e50['qlqGO'](this[_0x4132d0(0x3cf)],_0x158e50['jnMjI'])){if(SceneManager[_0x4132d0(0x5b6)+_0x4132d0(0x38b)]())return!![];this[_0x4132d0(0x3cf)]='';}return VisuMZ[_0x4132d0(0x50f)+_0x4132d0(0x20a)]['Game_Inter'+_0x4132d0(0x25d)+_0x4132d0(0x1d8)+'e']['call'](this);},VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)]['m']=VisuMZ[_0x5db7a1(0x50f)+'ngSeeds'][_0x5db7a1(0x573)][_0x5db7a1(0x486)][_0x5db7a1(0x113)]??-0x2720503b*-0x2+-0x3675c042+-0x1*-0x68351fcc,VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)]['a']=VisuMZ['DiceRollsR'+_0x5db7a1(0x20a)]['Settings'][_0x5db7a1(0x486)]['multiplier']??-0x438c1*0x1d3b+0x2fb8577e+0x8d74e86a,VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)]['c']=VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)]['Settings'][_0x5db7a1(0x486)][_0x5db7a1(0x358)]??-0x55a4+-0x1*-0x269a+0x5f43,VisuMZ['DiceRollsR'+'ngSeeds'][_0x5db7a1(0x542)+_0x5db7a1(0x40d)+'ze']=Game_System[_0x5db7a1(0x4ce)][_0x5db7a1(0x244)],Game_System['prototype'][_0x5db7a1(0x244)]=function(){const _0x283d82=_0x5db7a1;VisuMZ[_0x283d82(0x50f)+_0x283d82(0x20a)]['Game_Syste'+_0x283d82(0x40d)+'ze'][_0x283d82(0x23f)](this),this[_0x283d82(0x307)+'NumberSeed'+'s']();},Game_System[_0x5db7a1(0x4ce)][_0x5db7a1(0x307)+_0x5db7a1(0x31b)+'s']=function(){const _0x294027=_0x5db7a1;this[_0x294027(0x3f2)+_0x294027(0x1ae)]={},this[_0x294027(0x3f2)+'berSeedUni'+_0x294027(0x258)]=Math['randomInt'](-0x4d18e3c2+-0x5a292262+0x127420624);},Game_System[_0x5db7a1(0x4ce)]['getRandomN'+_0x5db7a1(0x43b)]=function(_0x2b633e,_0x5153b7,_0x10b8ad){const _0x3ec139=_0x5db7a1,_0x461ded={'qzDYH':function(_0xb0ec2c,_0x5f0b25){return _0xb0ec2c===_0x5f0b25;}};_0x461ded['qzDYH'](this['_randomNum'+'berSeeds'],undefined)&&this['initRandom'+_0x3ec139(0x31b)+'s']();const _0x13f554=this['getRandomN'+_0x3ec139(0x5c9)+'ey'](_0x2b633e,_0x5153b7,_0x10b8ad);return _0x461ded[_0x3ec139(0x41b)](this['_randomNum'+'berSeeds'][_0x13f554],undefined)&&this[_0x3ec139(0x589)+'andomNumbe'+'rSeed'](_0x13f554),this['_randomNum'+_0x3ec139(0x1ae)][_0x13f554];},Game_System[_0x5db7a1(0x4ce)][_0x5db7a1(0xff)+_0x5db7a1(0x3ad)+'niqueKey']=function(){const _0x3cce2=_0x5db7a1,_0x17dc9d={'IZVIZ':function(_0x5623e5,_0x234e36){return _0x5623e5===_0x234e36;}};return _0x17dc9d[_0x3cce2(0x4e4)](this[_0x3cce2(0x3f2)+'berSeedUni'+_0x3cce2(0x258)],undefined)&&this[_0x3cce2(0x307)+_0x3cce2(0x31b)+'s'](),this['_randomNum'+_0x3cce2(0x2e3)+_0x3cce2(0x258)];},VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)]['Interweave']=function(_0x20164d,_0x2ab4dd){const _0x14b2fd=_0x5db7a1,_0x174d1e={'ZXWUP':function(_0x5e1a46,_0x46cf46){return _0x5e1a46(_0x46cf46);},'sEKMk':function(_0x235cbe,_0x5a209b){return _0x235cbe<_0x5a209b;},'fThff':function(_0x156166,_0x5c2af0){return _0x156166<_0x5c2af0;},'owunr':function(_0x1486f4,_0x58e350){return _0x1486f4<_0x58e350;}};_0x20164d=_0x174d1e['ZXWUP'](String,_0x20164d),_0x2ab4dd=_0x174d1e[_0x14b2fd(0x3e3)](String,_0x2ab4dd);let _0x3d834f='',_0x34a96e=0x203e+-0xa7*0x1+0x1*-0x1f97,_0x103338=-0x491*-0x5+-0x1*-0x1a7b+-0x2*0x18a8;while(_0x174d1e[_0x14b2fd(0x1ab)](_0x34a96e,_0x20164d['length'])||_0x174d1e[_0x14b2fd(0x515)](_0x103338,_0x2ab4dd[_0x14b2fd(0x5de)])){if(_0x174d1e['owunr'](_0x34a96e,_0x20164d['length']))_0x3d834f+=_0x20164d[_0x34a96e++];if(_0x174d1e[_0x14b2fd(0x515)](_0x103338,_0x2ab4dd[_0x14b2fd(0x5de)]))_0x3d834f+=_0x2ab4dd[_0x103338++];}return _0x3d834f;},VisuMZ[_0x5db7a1(0x50f)+'ngSeeds'][_0x5db7a1(0x421)+'y']=function(){const _0x471114=_0x5db7a1,_0x542f6b={'jddoq':function(_0x1e37f7,_0x4e7244){return _0x1e37f7(_0x4e7244);},'HOypn':function(_0x4d36c0,_0x5db4ff){return _0x4d36c0(_0x5db4ff);},'CkqnQ':function(_0x202f31,_0x121349){return _0x202f31+_0x121349;}},_0x2acadc=new Date();let _0x57ecd3=_0x542f6b[_0x471114(0x35f)](String,_0x2acadc['getDate']())[_0x471114(0x1fe)](-0x3c6+-0x1*-0xb3f+-0x777,'0'),_0x226d74=_0x542f6b[_0x471114(0x531)](String,_0x542f6b[_0x471114(0x5c5)](_0x2acadc[_0x471114(0x503)](),-0xec3+-0xfef+-0x1*-0x1eb3))['padStart'](-0x20a1+-0xbe5+0x64*0x72,'0'),_0x271e03=_0x2acadc[_0x471114(0x4b7)+'r']();return _0x57ecd3+'-'+_0x226d74+'-'+_0x271e03;},Game_System[_0x5db7a1(0x4ce)][_0x5db7a1(0xff)+_0x5db7a1(0x5c9)+'ey']=function(_0x17423f,_0x50b0ed,_0x17bb1d){const _0x4d284d=_0x5db7a1,_0x2eb2c5={'zDWPC':function(_0x28c6ed,_0x372c9f){return _0x28c6ed(_0x372c9f);}};_0x17423f=_0x2eb2c5['zDWPC'](String,_0x17423f);if(_0x50b0ed){const _0x1d9a56=VisuMZ[_0x4d284d(0x50f)+'ngSeeds'][_0x4d284d(0x421)+'y']();_0x17423f=VisuMZ[_0x4d284d(0x50f)+_0x4d284d(0x20a)]['Interweave'](_0x17423f,_0x1d9a56);}if(_0x17bb1d){const _0x34e031=this[_0x4d284d(0xff)+_0x4d284d(0x3ad)+'niqueKey']();_0x17423f=VisuMZ['DiceRollsR'+'ngSeeds'][_0x4d284d(0x410)](_0x17423f,_0x34e031);}return _0x17423f;},Game_System['prototype'][_0x5db7a1(0x589)+'andomNumbe'+_0x5db7a1(0x3ac)]=function(_0x383f49){const _0x43b2e3=_0x5db7a1,_0x4dc9bc={'jqhzK':function(_0x329672,_0x1db220){return _0x329672(_0x1db220);},'eACKS':function(_0x37496f,_0x4838c0){return _0x37496f<_0x4838c0;},'Grrvt':function(_0x514022,_0x592932){return _0x514022+_0x592932;},'zcrdF':function(_0x462176,_0xd47782){return _0x462176>_0xd47782;},'PwegN':function(_0x38db83,_0x581cad){return _0x38db83/_0x581cad;},'FyZEX':function(_0x33a8cf,_0x522711){return _0x33a8cf%_0x522711;}};_0x383f49=_0x4dc9bc[_0x43b2e3(0x408)](String,_0x383f49);var _0x1474c6=[];const _0x4818b5=_0x383f49[_0x43b2e3(0x5de)];for(var _0x4edd11=-0x983+-0x590+0x1*0xf13;_0x4dc9bc['eACKS'](_0x4edd11,_0x4818b5);_0x4edd11++){_0x1474c6[_0x43b2e3(0x1bd)](_0x383f49[_0x43b2e3(0x45a)](_0x4edd11));}let _0x3a2798=_0x4dc9bc['Grrvt'](_0x1474c6[_0x43b2e3(0x12a)](''),-0x149*0x17+-0x13a2+0x3131);while(_0x4dc9bc[_0x43b2e3(0x2d5)](_0x3a2798,VisuMZ[_0x43b2e3(0x50f)+_0x43b2e3(0x20a)]['m'])){_0x3a2798=Math[_0x43b2e3(0x19f)](_0x4dc9bc['PwegN'](_0x3a2798,VisuMZ[_0x43b2e3(0x50f)+'ngSeeds']['m']));}this[_0x43b2e3(0x3f2)+_0x43b2e3(0x1ae)][_0x383f49]=_0x4dc9bc[_0x43b2e3(0x544)](_0x3a2798,VisuMZ[_0x43b2e3(0x50f)+_0x43b2e3(0x20a)]['m']);},Game_System[_0x5db7a1(0x4ce)][_0x5db7a1(0x3ce)+_0x5db7a1(0x354)+_0x5db7a1(0x23e)]=function(_0x4b1191,_0x532eb8,_0x1f3cff){const _0x247af0=_0x5db7a1,_0x49f126={'SHFmj':function(_0x4654ba,_0x21e2b){return _0x4654ba%_0x21e2b;},'dYGyO':function(_0x24f0d8,_0x1d1469){return _0x24f0d8+_0x1d1469;},'CzMmZ':function(_0x162c7d,_0x5df78f){return _0x162c7d*_0x5df78f;}},_0x131b55=VisuMZ[_0x247af0(0x50f)+_0x247af0(0x20a)];let _0x4adcd1=this['getRandomN'+_0x247af0(0x43b)](_0x4b1191,_0x532eb8,_0x1f3cff);const _0x4a15af=_0x131b55['m'];_0x4adcd1=_0x49f126[_0x247af0(0x181)](_0x49f126[_0x247af0(0x188)](_0x49f126[_0x247af0(0x48c)](_0x131b55['a'],_0x4adcd1),_0x131b55['c']),_0x4a15af);const _0x24dca9=this[_0x247af0(0xff)+_0x247af0(0x5c9)+'ey'](_0x4b1191,_0x532eb8,_0x1f3cff);return this['_randomNum'+_0x247af0(0x1ae)][_0x24dca9]=_0x4adcd1,this[_0x247af0(0x3f2)+_0x247af0(0x1ae)][_0x24dca9];},Game_System[_0x5db7a1(0x4ce)][_0x5db7a1(0x561)+_0x5db7a1(0x3d8)+_0x5db7a1(0x1b5)+'ed']=function(_0x1981a1,_0x11ab5e,_0x1186ec){const _0x1c19ba=_0x5db7a1,_0x1bf5cf={'Htwyo':function(_0x285eaf,_0x35681a){return _0x285eaf-_0x35681a;},'imaEC':function(_0x78495a,_0x57c701){return _0x78495a/_0x57c701;}},_0x27196d=_0x1bf5cf[_0x1c19ba(0x201)](VisuMZ[_0x1c19ba(0x50f)+_0x1c19ba(0x20a)]['m'],-0x14*0x183+0x47e+0x3*0x895);return _0x1bf5cf[_0x1c19ba(0x405)](this[_0x1c19ba(0x3ce)+_0x1c19ba(0x354)+_0x1c19ba(0x23e)](_0x1981a1,_0x11ab5e,_0x1186ec),_0x27196d);},Game_System[_0x5db7a1(0x4ce)]['getNextRan'+_0x5db7a1(0x605)+_0x5db7a1(0x1b5)+'ed']=function(_0x56d909,_0x32d7bb,_0x5f431f,_0x47e257,_0x335938){const _0x34ea0e=_0x5db7a1,_0x579d2c={'TGYsh':function(_0x3d6429,_0x21513b){return _0x3d6429+_0x21513b;},'ZQzYo':function(_0x51be41,_0x212e5d){return _0x51be41-_0x212e5d;},'RIfWV':function(_0x34ec87,_0x1366a1){return _0x34ec87*_0x1366a1;}},_0x16190c=_0x579d2c[_0x34ea0e(0xe9)](_0x579d2c[_0x34ea0e(0x487)](_0x32d7bb,_0x56d909),-0xd1*0x3+-0x562*-0x7+-0x36*0xa7),_0x5d08ff=this['getNextFlo'+_0x34ea0e(0x3d8)+_0x34ea0e(0x1b5)+'ed'](_0x5f431f,_0x47e257,_0x335938),_0x54f9a9=Math['floor'](_0x579d2c[_0x34ea0e(0x2f5)](_0x5d08ff,_0x16190c));return _0x579d2c[_0x34ea0e(0xe9)](_0x56d909,_0x54f9a9);},Game_System['prototype'][_0x5db7a1(0x4ff)+_0x5db7a1(0x24f)+'d']=function(_0x411169,_0x31ac6a,_0x424b3d){const _0x3d542e=_0x5db7a1,_0x4fa79b={'MbmAr':function(_0x1efc60,_0x24e355){return _0x1efc60===_0x24e355;}};if(_0x4fa79b[_0x3d542e(0x16d)](_0x411169,undefined))return;const _0x4835ef=this[_0x3d542e(0xff)+_0x3d542e(0x5c9)+'ey'](_0x411169,_0x31ac6a,_0x424b3d);this[_0x3d542e(0x589)+_0x3d542e(0x4b0)+'rSeed'](_0x4835ef);},VisuMZ[_0x5db7a1(0x50f)+'ngSeeds'][_0x5db7a1(0x22c)+_0x5db7a1(0x213)+_0x5db7a1(0x379)+'es']=Game_Message[_0x5db7a1(0x4ce)][_0x5db7a1(0x143)+'leChoices'],Game_Message[_0x5db7a1(0x4ce)][_0x5db7a1(0x143)+_0x5db7a1(0x42d)]=function(){const _0x4d4e00=_0x5db7a1;this[_0x4d4e00(0x143)+'leChoiceSe'+'ed'](),VisuMZ[_0x4d4e00(0x50f)+_0x4d4e00(0x20a)]['Game_Messa'+_0x4d4e00(0x213)+_0x4d4e00(0x379)+'es']['call'](this),this[_0x4d4e00(0x305)+'pects']();},Game_Message[_0x5db7a1(0x4ce)][_0x5db7a1(0x305)+_0x5db7a1(0x276)]=function(){const _0x2fa4e1=_0x5db7a1;this[_0x2fa4e1(0x311)]='',this['_rngDaily']=![],this[_0x2fa4e1(0x46c)+_0x2fa4e1(0x29e)]=![];},Game_Message[_0x5db7a1(0x4ce)][_0x5db7a1(0x143)+_0x5db7a1(0x34d)+'ed']=function(){const _0x48170=_0x5db7a1,_0x33acaf={'xixDI':function(_0x136c10,_0x1106ff){return _0x136c10<_0x1106ff;},'zdEvB':function(_0x1b22e3,_0x233681){return _0x1b22e3(_0x233681);},'hBdGY':function(_0x4070bb,_0x5de7a3){return _0x4070bb(_0x5de7a3);}};this[_0x48170(0x305)+_0x48170(0x276)]();const _0x1af616=VisuMZ['DiceRollsR'+_0x48170(0x20a)][_0x48170(0x296)],_0xeec78=this[_0x48170(0x301)][_0x48170(0x5de)];for(let _0x46d76e=-0x853*-0x3+-0x5d*0x4d+0x300;_0x33acaf[_0x48170(0xd4)](_0x46d76e,_0xeec78);_0x46d76e++){let _0x4a9174=this[_0x48170(0x301)][_0x46d76e];_0x4a9174[_0x48170(0x316)](_0x1af616[_0x48170(0x319)])&&(this[_0x48170(0x311)]=_0x33acaf[_0x48170(0x2af)](String,RegExp['$1']),_0x4a9174=_0x4a9174[_0x48170(0x2ec)](_0x1af616[_0x48170(0x319)],'')),_0x4a9174[_0x48170(0x316)](_0x1af616[_0x48170(0x2a8)])&&(this[_0x48170(0x311)]=_0x33acaf[_0x48170(0x2af)](String,RegExp['$1']),this[_0x48170(0x51f)]=!![],_0x4a9174=_0x4a9174[_0x48170(0x2ec)](_0x1af616['dailySeed'],'')),_0x4a9174[_0x48170(0x316)](_0x1af616[_0x48170(0x57d)])&&(this['_rngSeed']=_0x33acaf[_0x48170(0x2af)](String,RegExp['$1']),this[_0x48170(0x46c)+_0x48170(0x29e)]=!![],_0x4a9174=_0x4a9174[_0x48170(0x2ec)](_0x1af616[_0x48170(0x57d)],'')),_0x4a9174[_0x48170(0x316)](_0x1af616[_0x48170(0xd3)+_0x48170(0x2f9)])&&(this['_rngSeed']=_0x33acaf[_0x48170(0x565)](String,RegExp['$1']),this[_0x48170(0x51f)]=!![],this[_0x48170(0x46c)+_0x48170(0x29e)]=!![],_0x4a9174=_0x4a9174[_0x48170(0x2ec)](_0x1af616[_0x48170(0xd3)+_0x48170(0x2f9)],'')),this[_0x48170(0x301)][_0x46d76e]=_0x4a9174[_0x48170(0x12c)]();}};VisuMZ['MessageCor'+'e']&&(VisuMZ[_0x5db7a1(0x50f)+'ngSeeds'][_0x5db7a1(0x4d5)+_0x5db7a1(0x433)]=VisuMZ[_0x5db7a1(0x4a7)+'e'][_0x5db7a1(0x3a4)+'ay'],VisuMZ[_0x5db7a1(0x4a7)+'e']['ShuffleArr'+'ay']=function(_0x1eb1a8){const _0x2615f9=_0x5db7a1,_0x20becb={'AGMzf':function(_0x238fff,_0x48df06){return _0x238fff!==_0x48df06;}};return $gameMessage&&_0x20becb[_0x2615f9(0x126)]($gameMessage['_rngSeed'],'')?VisuMZ[_0x2615f9(0x4a7)+'e'][_0x2615f9(0x567)+_0x2615f9(0x5ec)][_0x2615f9(0x23f)](this,_0x1eb1a8):VisuMZ[_0x2615f9(0x50f)+_0x2615f9(0x20a)][_0x2615f9(0x4d5)+_0x2615f9(0x433)]['call'](this,_0x1eb1a8);},VisuMZ[_0x5db7a1(0x4a7)+'e'][_0x5db7a1(0x567)+_0x5db7a1(0x5ec)]=function(_0x4bbf4f){const _0x228f3f=_0x5db7a1,_0x1368f5={'PsIEg':function(_0x50bba0,_0x15ca19){return _0x50bba0-_0x15ca19;},'MSmpd':function(_0x3dc3d0,_0x277949){return _0x3dc3d0>_0x277949;},'ZKTbc':function(_0x549f0c,_0x37effb,_0x451725,_0x5d0ef7){return _0x549f0c(_0x37effb,_0x451725,_0x5d0ef7);},'EaDua':function(_0x16fed7,_0x390c81){return _0x16fed7*_0x390c81;},'uPCss':function(_0x345539,_0x2afc99){return _0x345539+_0x2afc99;}},_0x256754=$gameMessage[_0x228f3f(0x311)]||'',_0x5a3cc7=$gameMessage['_rngDaily']||![],_0x61c622=$gameMessage[_0x228f3f(0x46c)+_0x228f3f(0x29e)]||![];var _0x412881,_0x228f55,_0x2d6c65;for(_0x2d6c65=_0x1368f5[_0x228f3f(0xda)](_0x4bbf4f[_0x228f3f(0x5de)],0xfa+0x13bb+-0x14b4);_0x1368f5[_0x228f3f(0x3a0)](_0x2d6c65,-0x154*0x1+-0x2487+0x25db);_0x2d6c65--){const _0x4b154f=_0x1368f5[_0x228f3f(0x130)]($rngSeed,_0x256754,_0x5a3cc7,_0x61c622);_0x412881=Math[_0x228f3f(0x19f)](_0x1368f5[_0x228f3f(0x56b)](_0x4b154f,_0x1368f5[_0x228f3f(0x11c)](_0x2d6c65,-0x251*-0x3+-0x16*-0x16e+-0xa*0x3d7))),_0x228f55=_0x4bbf4f[_0x2d6c65],_0x4bbf4f[_0x2d6c65]=_0x4bbf4f[_0x412881],_0x4bbf4f[_0x412881]=_0x228f55;}return _0x4bbf4f;});;Game_Temp[_0x5db7a1(0x4ce)][_0x5db7a1(0x305)+_0x5db7a1(0x276)]=function(){const _0xfa3604=_0x5db7a1;this[_0xfa3604(0x311)]='',this['_rngDaily']=![],this[_0xfa3604(0x46c)+'ique']=![];},VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x413)+_0x5db7a1(0x393)]=Game_Action[_0x5db7a1(0x4ce)]['apply'],Game_Action['prototype']['apply']=function(_0x1f7415){const _0x4ef811=_0x5db7a1;$gameTemp['clearRngAs'+'pects'](),this['applyRngAs'+_0x4ef811(0x276)](_0x1f7415),VisuMZ[_0x4ef811(0x50f)+'ngSeeds']['Game_Actio'+_0x4ef811(0x393)][_0x4ef811(0x23f)](this,_0x1f7415),$gameTemp['clearRngAs'+_0x4ef811(0x276)]();},Game_Action['prototype'][_0x5db7a1(0x31a)+'pects']=function(_0x4c1294){const _0x555827=_0x5db7a1,_0x269fd0={'DvwdG':function(_0x5df63e,_0x11b20b){return _0x5df63e===_0x11b20b;},'WSoZw':'none','efhMb':function(_0x432e86,_0x1cbdf4){return _0x432e86(_0x1cbdf4);},'Xgnuk':function(_0x42f15a,_0x2558a1){return _0x42f15a(_0x2558a1);},'CwHdl':function(_0x26ffa0,_0xb878b2){return _0x26ffa0(_0xb878b2);},'RxrcG':function(_0x2fd833,_0x30bfc6){return _0x2fd833===_0x30bfc6;},'Eybve':_0x555827(0x3dd),'ZJJxb':_0x555827(0x204)+'e','aMIhC':_0x555827(0x360)+_0x555827(0x1f5),'VPSPY':_0x555827(0x1b1),'YKINb':_0x555827(0x16c)+'%2','dEYtp':_0x555827(0x479),'gTseN':_0x555827(0x372),'WRkgS':_0x555827(0x2fc)};if(!this[_0x555827(0x545)]())return;if(!_0x4c1294)return;let _0x206d18=VisuMZ[_0x555827(0x50f)+'ngSeeds'][_0x555827(0x573)]['RngSeed']['DefaultRng'+_0x555827(0x375)]??'';if(_0x269fd0[_0x555827(0x287)](_0x206d18[_0x555827(0x484)+'e']()[_0x555827(0x12c)](),_0x269fd0[_0x555827(0x41d)]))_0x206d18='';let _0xbf8d32=![],_0x58e2d8=VisuMZ[_0x555827(0x50f)+_0x555827(0x20a)][_0x555827(0x573)][_0x555827(0x486)][_0x555827(0x559)+_0x555827(0x375)]?!![]:![];const _0x2af01d=VisuMZ['DiceRollsR'+_0x555827(0x20a)][_0x555827(0x296)],_0x1646b5=this[_0x555827(0x545)]()[_0x555827(0x241)]||'';if(_0x1646b5[_0x555827(0x316)](_0x2af01d['noRngSeed']))_0x206d18='',_0xbf8d32=![],_0x58e2d8=![];else{if(_0x1646b5[_0x555827(0x316)](_0x2af01d[_0x555827(0x319)]))_0x206d18=_0x269fd0['efhMb'](String,RegExp['$1'])[_0x555827(0x12c)](),_0xbf8d32=![],_0x58e2d8=![];else{if(_0x1646b5[_0x555827(0x316)](_0x2af01d[_0x555827(0x2a8)]))_0x206d18=_0x269fd0[_0x555827(0x58f)](String,RegExp['$1'])[_0x555827(0x12c)](),_0xbf8d32=!![],_0x58e2d8=![];else{if(_0x1646b5['match'](_0x2af01d[_0x555827(0x57d)]))_0x206d18=_0x269fd0['Xgnuk'](String,RegExp['$1'])[_0x555827(0x12c)](),_0xbf8d32=![],_0x58e2d8=!![];else _0x1646b5[_0x555827(0x316)](_0x2af01d[_0x555827(0xd3)+_0x555827(0x2f9)])&&(_0x206d18=_0x269fd0[_0x555827(0x2e2)](String,RegExp['$1'])[_0x555827(0x12c)](),_0xbf8d32=!![],_0x58e2d8=!![]);}}}_0x269fd0[_0x555827(0x5b5)](_0x206d18[_0x555827(0x484)+'e']()[_0x555827(0x12c)](),_0x269fd0['Eybve'])&&(_0x206d18=this[_0x555827(0x545)]()['name']||_0x269fd0[_0x555827(0x5ab)]);if(_0x206d18){const _0x1c9b39=_0x269fd0[_0x555827(0x267)][_0x555827(0x293)]('|');let _0x50d31c=-0xaa*-0x2e+-0x55d*-0x6+-0xe*0x47b;while(!![]){switch(_0x1c9b39[_0x50d31c++]){case'0':this['subject']()[_0x555827(0x158)]()?_0x206d18+=_0x269fd0[_0x555827(0x344)][_0x555827(0x13e)](this[_0x555827(0x238)]()[_0x555827(0x249)]()):_0x206d18+=_0x269fd0['YKINb'][_0x555827(0x13e)](this[_0x555827(0x238)]()['enemyId'](),this[_0x555827(0x238)]()['index']());continue;case'1':_0x206d18+=_0x269fd0[_0x555827(0x597)];continue;case'2':$gameTemp[_0x555827(0x51f)]=_0xbf8d32;continue;case'3':$gameTemp[_0x555827(0x46c)+'ique']=_0x58e2d8;continue;case'4':_0x4c1294['isActor']()?_0x206d18+=_0x269fd0[_0x555827(0x344)][_0x555827(0x13e)](_0x4c1294[_0x555827(0x249)]()):_0x206d18+=_0x269fd0[_0x555827(0x5fe)][_0x555827(0x13e)](_0x4c1294[_0x555827(0x504)](),_0x4c1294[_0x555827(0x1d6)]());continue;case'5':$gameTemp[_0x555827(0x311)]=_0x206d18;continue;case'6':this['isSkill']()?_0x206d18+=_0x269fd0[_0x555827(0xfd)][_0x555827(0x13e)](this[_0x555827(0x545)]()['id']):_0x206d18+=_0x269fd0['WRkgS'][_0x555827(0x13e)](this[_0x555827(0x545)]()['id']);continue;}break;}}},VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x43d)+'m']=Math[_0x5db7a1(0x541)],Math[_0x5db7a1(0x541)]=function(){const _0x261d43=_0x5db7a1;return $gameTemp[_0x261d43(0x311)]?VisuMZ['DiceRollsR'+_0x261d43(0x20a)][_0x261d43(0x576)+_0x261d43(0x52d)]():VisuMZ['DiceRollsR'+_0x261d43(0x20a)]['Math_rando'+'m'][_0x261d43(0x23f)](this);},VisuMZ['DiceRollsR'+_0x5db7a1(0x20a)][_0x5db7a1(0x576)+_0x5db7a1(0x52d)]=function(){const _0x4731ff=_0x5db7a1,_0x8b3949={'SifIL':function(_0x52858d,_0x1aac88,_0x56996d,_0x47998a){return _0x52858d(_0x1aac88,_0x56996d,_0x47998a);}},_0x49f796=$gameTemp[_0x4731ff(0x311)]||'',_0x563607=$gameTemp[_0x4731ff(0x51f)]||![],_0x466000=$gameTemp[_0x4731ff(0x46c)+'ique']||![];return _0x8b3949[_0x4731ff(0x58e)]($rngSeed,_0x49f796,_0x563607,_0x466000);},Scene_Message['DICE_ROLL']={'choiceBgType':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x573)][_0x5db7a1(0x2cb)]['Command_Bg'+'Type']??-0x19ce+-0x78a*0x5+-0x3f8*-0x10,'titleBgType':VisuMZ['DiceRollsR'+'ngSeeds']['Settings'][_0x5db7a1(0x2cb)][_0x5db7a1(0x3ee)+'pe']??0x1ab3+-0x26*0x44+-0x109b,'advantageBgType':VisuMZ[_0x5db7a1(0x50f)+'ngSeeds'][_0x5db7a1(0x573)][_0x5db7a1(0x2cb)]['DataCount_'+_0x5db7a1(0x34c)]??-0x1243*-0x1+-0x9ad*-0x4+-0x38f7,'rankBgType':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)]['Settings'][_0x5db7a1(0x2cb)][_0x5db7a1(0x4b1)+_0x5db7a1(0x56a)]??0xc1*0x7+-0x4*-0x5f0+-0x1d07,'modifierBgType':VisuMZ[_0x5db7a1(0x50f)+'ngSeeds'][_0x5db7a1(0x573)][_0x5db7a1(0x2cb)][_0x5db7a1(0x10d)+_0x5db7a1(0x1ce)]??-0x2046+0xaca*-0x1+-0x2b10*-0x1,'subtitleBgType':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x573)]['Window']['Subtitle_B'+_0x5db7a1(0x56a)]??0xca5+-0x1cb8+0x1013,'effectsBgType':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x573)][_0x5db7a1(0x2cb)][_0x5db7a1(0x3df)+'_BgType']??-0x8dc*0x2+0x2*-0xbca+0x294c,'bonusBgType':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x573)][_0x5db7a1(0x2cb)][_0x5db7a1(0x1da)+_0x5db7a1(0x34c)]??-0x1af5+-0x1b16*-0x1+-0xb*0x3},Scene_Message[_0x5db7a1(0x4ce)]['setupDiceR'+_0x5db7a1(0xc0)]=function(){const _0x2e8d4a=_0x5db7a1;this[_0x2e8d4a(0x252)+_0x2e8d4a(0x406)+_0x2e8d4a(0x2bd)]();},Scene_Message[_0x5db7a1(0x4ce)]['endDiceRol'+'l']=function(){const _0x1e948d=_0x5db7a1;this['removeAllD'+_0x1e948d(0x406)+_0x1e948d(0x2bd)]();},Scene_Message[_0x5db7a1(0x4ce)][_0x5db7a1(0x252)+_0x5db7a1(0x406)+_0x5db7a1(0x2bd)]=function(){const _0x2bd9cd=_0x5db7a1,_0x4407a1={'zGDOl':'7|3|0|8|1|'+_0x2bd9cd(0x216)},_0x6aa5fb=_0x4407a1[_0x2bd9cd(0x5e0)]['split']('|');let _0xbe0562=0x19be*0x1+-0x1*0xa1f+-0xf9f;while(!![]){switch(_0x6aa5fb[_0xbe0562++]){case'0':this[_0x2bd9cd(0x18f)+_0x2bd9cd(0x10a)+_0x2bd9cd(0x21d)]();continue;case'1':this[_0x2bd9cd(0x18f)+'RollRankWi'+_0x2bd9cd(0x5f1)]();continue;case'2':this[_0x2bd9cd(0x18f)+'RollBonusW'+_0x2bd9cd(0x21d)]();continue;case'3':this[_0x2bd9cd(0x18f)+_0x2bd9cd(0x218)+'Window']();continue;case'4':this[_0x2bd9cd(0x18f)+_0x2bd9cd(0x49d)+_0x2bd9cd(0x4d0)]();continue;case'5':this[_0x2bd9cd(0x18f)+_0x2bd9cd(0x3e7)+_0x2bd9cd(0x2a9)]();continue;case'6':this[_0x2bd9cd(0x18f)+'RollModifi'+'erWindow']();continue;case'7':this['createDice'+_0x2bd9cd(0x14c)+_0x2bd9cd(0x2cb)]();continue;case'8':this[_0x2bd9cd(0x18f)+_0x2bd9cd(0x15f)+_0x2bd9cd(0x2fa)]();continue;}break;}},Scene_Message[_0x5db7a1(0x4ce)][_0x5db7a1(0x18f)+_0x5db7a1(0x14c)+_0x5db7a1(0x2cb)]=function(){const _0x1babbe=_0x5db7a1,_0x5f206e=this['diceRollSp'+'riteWindow'+_0x1babbe(0x1ba)](),_0xbce348=new Window_DiceSprite(_0x5f206e);this[_0x1babbe(0x168)](_0xbce348),this[_0x1babbe(0x23a)+_0x1babbe(0x336)+'ow']=_0xbce348,_0xbce348[_0x1babbe(0x5c8)+_0x1babbe(0x3d3)](-0x1a11+0xb*-0xd2+-0x5*-0x705);},Scene_Message['prototype'][_0x5db7a1(0x600)+_0x5db7a1(0x1d7)+_0x5db7a1(0x1ba)]=function(){const _0xc304d4=_0x5db7a1,_0x22027={'dtEqj':function(_0x4cb185,_0x5380b5){return _0x4cb185*_0x5380b5;},'JduXD':function(_0x528f80,_0x417627){return _0x528f80/_0x417627;},'SUJko':function(_0x2ad059,_0xc8a5a5){return _0x2ad059-_0xc8a5a5;},'HAUKG':function(_0x43dd05,_0x105a59){return _0x43dd05+_0x105a59;},'ZmLgT':function(_0x58ff60,_0xf23ad8){return _0x58ff60-_0xf23ad8;}};if(VisuMZ['DiceRollsR'+_0xc304d4(0x20a)]['Settings'][_0xc304d4(0x2cb)][_0xc304d4(0x208)+'RectJS'])return VisuMZ[_0xc304d4(0x50f)+_0xc304d4(0x20a)][_0xc304d4(0x573)][_0xc304d4(0x2cb)][_0xc304d4(0x208)+_0xc304d4(0x4b4)]['call'](this);const _0x2a12a8=Math[_0xc304d4(0x1fb)](Math[_0xc304d4(0x383)](_0x22027[_0xc304d4(0x494)](Graphics[_0xc304d4(0x118)],-0x1*0x619+0x20*0x7f+-0x9c7+0.9)),0x1474+-0xd4f*-0x1+0x1*-0x1e93),_0x12405b=Math[_0xc304d4(0x383)](_0x22027[_0xc304d4(0x5aa)](_0x22027[_0xc304d4(0x349)](Graphics[_0xc304d4(0x118)],_0x2a12a8),0x455+-0x1a1d+0x15ca)),_0x4b7524=_0x22027[_0xc304d4(0x53e)](this[_0xc304d4(0xfb)+'Height'](0x1e42+-0x1398+0x16*-0x7c,![]),this[_0xc304d4(0xfb)+_0xc304d4(0x5d6)](0x2709+0xd*-0x39+-0x2423*0x1,![])),_0x5547ba=_0x22027[_0xc304d4(0x349)](_0x22027[_0xc304d4(0x349)](_0x22027[_0xc304d4(0x150)](Graphics['height'],_0x4b7524),this[_0xc304d4(0xfb)+_0xc304d4(0x5d6)](-0xde*0x19+-0x65a+-0x703*-0x4,!![])),this[_0xc304d4(0xfb)+_0xc304d4(0x5d6)](-0x215e+-0xd6a+-0xcb*-0x3b,![]));return new Rectangle(_0x12405b,_0x4b7524,_0x2a12a8,_0x5547ba);},Scene_Message[_0x5db7a1(0x4ce)][_0x5db7a1(0x18f)+_0x5db7a1(0x218)+_0x5db7a1(0x2cb)]=function(){const _0x422a7c=_0x5db7a1,_0x25b450={'sXXUK':'roll','rctVC':_0x422a7c(0x1a1),'aGgzf':_0x422a7c(0x59f)},_0x3a2f91=this[_0x422a7c(0x2ae)+_0x422a7c(0x2ac)+_0x422a7c(0x1ba)](),_0x3c30e9=new Window_DiceChoice(_0x3a2f91);this['addChild'](_0x3c30e9),_0x3c30e9['setHandler'](_0x25b450[_0x422a7c(0x100)],this[_0x422a7c(0x579)+_0x422a7c(0x15b)][_0x422a7c(0x17e)](this)),_0x3c30e9['setHandler'](_0x25b450[_0x422a7c(0x24e)],this['commandDic'+_0x422a7c(0x3f0)][_0x422a7c(0x17e)](this)),_0x3c30e9[_0x422a7c(0x401)](_0x25b450['aGgzf'],this[_0x422a7c(0x579)+_0x422a7c(0x339)][_0x422a7c(0x17e)](this)),this[_0x422a7c(0x23a)+'ChoiceWind'+'ow']=_0x3c30e9,_0x3c30e9[_0x422a7c(0x5c8)+'undType'](Scene_Message[_0x422a7c(0x28a)][_0x422a7c(0x37e)+'pe']);},Scene_Message[_0x5db7a1(0x4ce)][_0x5db7a1(0x2ae)+'oiceWindow'+_0x5db7a1(0x1ba)]=function(){const _0x130f18=_0x5db7a1,_0xedeea0={'STeLg':function(_0x290cae,_0x155711){return _0x290cae*_0x155711;},'lLBQf':function(_0x17c183,_0xb0d2f8){return _0x17c183/_0xb0d2f8;},'txpqI':function(_0x4bedd8,_0x35aa16){return _0x4bedd8-_0x35aa16;},'VMptN':function(_0x254154,_0x4353a0){return _0x254154+_0x4353a0;},'xZsDb':function(_0x5bc61d,_0x427a4a){return _0x5bc61d-_0x427a4a;},'Rpfgf':function(_0x173f31,_0xb77800){return _0x173f31/_0xb77800;}};if(VisuMZ[_0x130f18(0x50f)+_0x130f18(0x20a)][_0x130f18(0x573)]['Window'][_0x130f18(0x60a)+'ctJS'])return VisuMZ[_0x130f18(0x50f)+_0x130f18(0x20a)][_0x130f18(0x573)]['Window']['Command_Re'+_0x130f18(0x3af)][_0x130f18(0x23f)](this);const _0x569729=Math[_0x130f18(0x1fb)](Math[_0x130f18(0x383)](_0xedeea0[_0x130f18(0x4c1)](Graphics['width'],0x1*0x1389+-0xcb5+0x4c*-0x17+0.5)),-0xa8f+-0x1423+-0x496*-0x7),_0x523476=this[_0x130f18(0xfb)+'Height'](this[_0x130f18(0x361)+_0x130f18(0x54e)](),!![]),_0x44c09a=Math[_0x130f18(0x383)](_0xedeea0[_0x130f18(0x554)](_0xedeea0[_0x130f18(0x122)](Graphics[_0x130f18(0x118)],_0x569729),0x1*0x254+0x2175+-0x23c7)),_0x27a93a=_0xedeea0[_0x130f18(0x34e)](_0xedeea0[_0x130f18(0x362)](Graphics['height'],this[_0x130f18(0xfb)+_0x130f18(0x5d6)](-0xa35+0x103*0xd+-0xa*0x4b,!![])),Math[_0x130f18(0x383)](_0xedeea0[_0x130f18(0x3da)](_0xedeea0['txpqI'](this['calcWindow'+'Height'](-0x1669+-0x967*-0x1+0xd06,!![]),this['calcWindow'+'Height'](-0x22fd+-0xb5c+0x2e5c,!![])),0x2*-0x4d9+0x2*-0xb86+0x4*0x830)));return new Rectangle(_0x44c09a,_0x27a93a,_0x569729,_0x523476);},Scene_Message['prototype'][_0x5db7a1(0x361)+_0x5db7a1(0x54e)]=function(){const _0x328354=_0x5db7a1;return VisuMZ[_0x328354(0x50f)+_0x328354(0x20a)]['TotalDiceC'+_0x328354(0x394)]();},Scene_Message[_0x5db7a1(0x4ce)]['createDice'+_0x5db7a1(0x10a)+'indow']=function(){const _0x2594aa=_0x5db7a1,_0x5cc0ef=SceneManager[_0x2594aa(0x2aa)+'ettings']||{},_0x5a9f9e=_0x5cc0ef[_0x2594aa(0x2d4)]||'';if(!_0x5a9f9e)return;const _0x11e744=this[_0x2594aa(0x1a0)+'tleWindowR'+_0x2594aa(0x29c)](),_0x11a617=new Window_DiceText(_0x11e744);this[_0x2594aa(0x168)](_0x11a617),_0x11a617[_0x2594aa(0x529)+_0x2594aa(0x2b7)](_0x5a9f9e),this[_0x2594aa(0x23a)+_0x2594aa(0x5bb)+'w']=_0x11a617,_0x11a617[_0x2594aa(0x5c8)+'undType'](Scene_Message[_0x2594aa(0x28a)][_0x2594aa(0x54f)+'e']);},Scene_Message[_0x5db7a1(0x4ce)][_0x5db7a1(0x1a0)+_0x5db7a1(0x2c5)+_0x5db7a1(0x29c)]=function(){const _0x49c9be=_0x5db7a1,_0xbb031d={'IcsyY':function(_0x30c0fc,_0x5b84ac){return _0x30c0fc*_0x5b84ac;},'oMSsS':function(_0xc2b4e1,_0x8ab792){return _0xc2b4e1/_0x8ab792;},'SUglP':function(_0x3ae85e,_0x3d4c04){return _0x3ae85e-_0x3d4c04;},'USMsW':function(_0x2c27af,_0x22704f){return _0x2c27af-_0x22704f;}};if(VisuMZ[_0x49c9be(0x50f)+_0x49c9be(0x20a)][_0x49c9be(0x573)][_0x49c9be(0x2cb)][_0x49c9be(0x40a)+'JS'])return VisuMZ[_0x49c9be(0x50f)+_0x49c9be(0x20a)][_0x49c9be(0x573)][_0x49c9be(0x2cb)][_0x49c9be(0x40a)+'JS']['call'](this);const _0x1128cc=Math['min'](Math[_0x49c9be(0x383)](_0xbb031d[_0x49c9be(0x10c)](Graphics['width'],-0xbf7+-0x1b*-0x76+-0x7b+0.8)),0x2468+-0x2195+0x7*-0x1),_0x52c8fc=this[_0x49c9be(0xfb)+_0x49c9be(0x5d6)](0xd*-0x1bb+0x2025+0x9a5*-0x1,![]),_0x2ff724=Math['round'](_0xbb031d['oMSsS'](_0xbb031d[_0x49c9be(0x424)](Graphics[_0x49c9be(0x118)],_0x1128cc),-0x1858+-0x1da*0x5+-0x3bc*-0x9)),_0x1241f2=_0xbb031d[_0x49c9be(0x555)](this['calcWindow'+'Height'](0x1310*0x2+-0x1903*-0x1+0x1*-0x3f21,![]),_0x52c8fc);return new Rectangle(_0x2ff724,_0x1241f2,_0x1128cc,_0x52c8fc);},Scene_Message[_0x5db7a1(0x4ce)][_0x5db7a1(0x18f)+'RollAdvant'+_0x5db7a1(0x2fa)]=function(){const _0x2e3982=_0x5db7a1,_0x4df555={'beRxk':_0x2e3982(0x17a)},_0x1709f0=this[_0x2e3982(0x345)+_0x2e3982(0x1b6)+_0x2e3982(0x4f7)](),_0x1af4f7=new Window_DiceData(_0x1709f0);_0x1af4f7[_0x2e3982(0x3dc)+'e'](_0x4df555['beRxk']),this['addChild'](_0x1af4f7),this['_diceRoll_'+_0x2e3982(0x3fb)+_0x2e3982(0x21d)]=_0x1af4f7,_0x1af4f7[_0x2e3982(0x5c8)+_0x2e3982(0x3d3)](Scene_Message[_0x2e3982(0x28a)][_0x2e3982(0x3e1)+_0x2e3982(0x56a)]);},Scene_Message[_0x5db7a1(0x4ce)][_0x5db7a1(0x345)+_0x5db7a1(0x1b6)+_0x5db7a1(0x4f7)]=function(){const _0xe6cb26=_0x5db7a1,_0x4b347e={'ZjXEZ':function(_0x169aa1,_0x46cd6c){return _0x169aa1*_0x46cd6c;},'uaEWo':function(_0x5e1804,_0x1ea079){return _0x5e1804/_0x1ea079;},'RtFmz':function(_0x2df385,_0x523a74){return _0x2df385-_0x523a74;}};if(VisuMZ[_0xe6cb26(0x50f)+_0xe6cb26(0x20a)][_0xe6cb26(0x573)][_0xe6cb26(0x2cb)][_0xe6cb26(0x5ef)+_0xe6cb26(0x4b4)])return VisuMZ['DiceRollsR'+_0xe6cb26(0x20a)][_0xe6cb26(0x573)][_0xe6cb26(0x2cb)]['DataCount_'+_0xe6cb26(0x4b4)]['call'](this);const _0x12f756=Math['min'](Math[_0xe6cb26(0x383)](_0x4b347e[_0xe6cb26(0x52b)](Graphics['width'],-0x17*-0x11+-0x5c8+0x441+0.9)),-0x2552+0x1f9e+0x8e4),_0x1ff9b3=Math[_0xe6cb26(0x19f)](_0x4b347e['uaEWo'](_0x12f756,0x13*0xe9+-0x2*0xd3c+-0x30*-0x31)),_0x888dc7=this[_0xe6cb26(0xfb)+'Height'](-0x211e+-0xe*-0x229+0x2e1,![]),_0x562dad=Math[_0xe6cb26(0x383)](_0x4b347e[_0xe6cb26(0x35b)](_0x4b347e[_0xe6cb26(0x580)](Graphics['width'],_0x12f756),0x23fe+0x2*0xdc9+-0x65b*0xa)),_0x25fa1d=this[_0xe6cb26(0xfb)+_0xe6cb26(0x5d6)](0x9be+0x143b+-0x1df7*0x1,![]);return new Rectangle(_0x562dad,_0x25fa1d,_0x1ff9b3,_0x888dc7);},Scene_Message['prototype']['createDice'+'RollRankWi'+_0x5db7a1(0x5f1)]=function(){const _0x3a36a=_0x5db7a1,_0x3e28ae={'ujVWS':_0x3a36a(0x2f2)},_0x1d0e3d=this[_0x3a36a(0x329)+_0x3a36a(0x56f)+'ct'](),_0x19b9cd=new Window_DiceData(_0x1d0e3d);_0x19b9cd[_0x3a36a(0x3dc)+'e'](_0x3e28ae['ujVWS']),this['addChild'](_0x19b9cd),this[_0x3a36a(0x23a)+_0x3a36a(0x1ec)]=_0x19b9cd,_0x19b9cd['setBackgro'+'undType'](Scene_Message[_0x3a36a(0x28a)][_0x3a36a(0x472)]);},Scene_Message['prototype']['diceRollRa'+_0x5db7a1(0x56f)+'ct']=function(){const _0x48762a=_0x5db7a1,_0x533b98={'QfUgu':function(_0x5e028d,_0x57576c){return _0x5e028d*_0x57576c;},'JuXaT':function(_0x8ae66e,_0xb7c67d){return _0x8ae66e/_0xb7c67d;},'hixPh':function(_0x3cc548,_0x34ef81){return _0x3cc548/_0x34ef81;},'aRfpf':function(_0x228a9f,_0x1e4a3d){return _0x228a9f-_0x1e4a3d;}};if(VisuMZ['DiceRollsR'+_0x48762a(0x20a)][_0x48762a(0x573)][_0x48762a(0x2cb)][_0x48762a(0x49c)+'ectJS'])return VisuMZ[_0x48762a(0x50f)+'ngSeeds'][_0x48762a(0x573)][_0x48762a(0x2cb)]['DataRank_R'+'ectJS'][_0x48762a(0x23f)](this);const _0x3cba48=Math[_0x48762a(0x1fb)](Math['round'](_0x533b98[_0x48762a(0x509)](Graphics['width'],-0xcf*0xd+0x1f7d+-0x1*0x14fa+0.9)),-0x366+-0xd*0x290+0x27e6),_0x40225c=Math[_0x48762a(0x1e5)](_0x533b98['JuXaT'](_0x3cba48,0x47*0x43+-0xc5*-0x13+-0x2131)),_0x5473f1=this[_0x48762a(0xfb)+_0x48762a(0x5d6)](-0x2677+-0x2697+0x4d0f,![]),_0x11e599=Math[_0x48762a(0x383)](_0x533b98[_0x48762a(0x5e7)](_0x533b98[_0x48762a(0x56d)](Graphics['width'],_0x40225c),-0x1862+0x4a5+-0x695*-0x3)),_0x27ec5f=this[_0x48762a(0xfb)+_0x48762a(0x5d6)](-0x9cc+-0x18f4+-0x2*-0x1161,![]);return new Rectangle(_0x11e599,_0x27ec5f,_0x40225c,_0x5473f1);},Scene_Message[_0x5db7a1(0x4ce)][_0x5db7a1(0x18f)+_0x5db7a1(0x1cc)+_0x5db7a1(0x236)]=function(){const _0x59f948=_0x5db7a1,_0x299abf={'byREr':_0x59f948(0x26c)},_0x484f6f=this[_0x59f948(0xbe)+_0x59f948(0x1f7)+_0x59f948(0x335)](),_0x44c490=new Window_DiceData(_0x484f6f);_0x44c490[_0x59f948(0x3dc)+'e'](_0x299abf['byREr']),this['addChild'](_0x44c490),this[_0x59f948(0x23a)+_0x59f948(0x355)+_0x59f948(0x5f1)]=_0x44c490,_0x44c490[_0x59f948(0x5c8)+_0x59f948(0x3d3)](Scene_Message['DICE_ROLL'][_0x59f948(0x340)+'Type']);},Scene_Message[_0x5db7a1(0x4ce)][_0x5db7a1(0xbe)+'difierWind'+_0x5db7a1(0x335)]=function(){const _0x4d1bd0=_0x5db7a1,_0x4c2f10={'uXqZs':function(_0x4e5878,_0x24c91d){return _0x4e5878*_0x24c91d;},'PzcqY':function(_0x4de21a,_0x5d20f3){return _0x4de21a/_0x5d20f3;},'AKQCC':function(_0x44d29e,_0x21baee){return _0x44d29e/_0x21baee;},'NyCNj':function(_0x259bf7,_0x54b248){return _0x259bf7+_0x54b248;}};if(VisuMZ['DiceRollsR'+'ngSeeds'][_0x4d1bd0(0x573)][_0x4d1bd0(0x2cb)][_0x4d1bd0(0x499)+_0x4d1bd0(0x3af)])return VisuMZ[_0x4d1bd0(0x50f)+_0x4d1bd0(0x20a)][_0x4d1bd0(0x573)][_0x4d1bd0(0x2cb)][_0x4d1bd0(0x499)+'ctJS'][_0x4d1bd0(0x23f)](this);const _0x3f9f4e=Math[_0x4d1bd0(0x1fb)](Math[_0x4d1bd0(0x383)](_0x4c2f10[_0x4d1bd0(0x10b)](Graphics[_0x4d1bd0(0x118)],0x6e1+0x10f5+-0x17d6+0.9)),-0x1*-0x22a+-0x145b+0x1561),_0x357059=Math[_0x4d1bd0(0x19f)](_0x4c2f10[_0x4d1bd0(0x2ad)](_0x3f9f4e,0xb1e+-0x199d+-0x2*-0x741)),_0x38049e=this[_0x4d1bd0(0xfb)+_0x4d1bd0(0x5d6)](-0x911*0x1+-0x592*-0x7+-0xef6*0x2,![]),_0x39c55e=Math[_0x4d1bd0(0x383)](_0x4c2f10[_0x4d1bd0(0x3d1)](_0x4c2f10['NyCNj'](Graphics['width'],_0x357059),0x4c*0x72+-0x108+-0x20ce)),_0x57f8ea=this[_0x4d1bd0(0xfb)+_0x4d1bd0(0x5d6)](0xcc2+0xe21*0x1+-0x1*0x1ae1,![]);return new Rectangle(_0x39c55e,_0x57f8ea,_0x357059,_0x38049e);},Scene_Message[_0x5db7a1(0x4ce)][_0x5db7a1(0x18f)+_0x5db7a1(0x49d)+_0x5db7a1(0x4d0)]=function(){const _0x7f0ed9=_0x5db7a1,_0x41fd1d=TextManager[_0x7f0ed9(0x2ee)+_0x7f0ed9(0x1e4)]();if(!_0x41fd1d)return;const _0x427900=this[_0x7f0ed9(0x117)+'btitleWind'+_0x7f0ed9(0x335)](),_0x55ae19=new Window_DiceText(_0x427900);this[_0x7f0ed9(0x168)](_0x55ae19),_0x55ae19[_0x7f0ed9(0x529)+_0x7f0ed9(0x2b7)](_0x41fd1d),this[_0x7f0ed9(0x23a)+_0x7f0ed9(0x140)+_0x7f0ed9(0x5f1)]=_0x55ae19,_0x55ae19[_0x7f0ed9(0x5c8)+'undType'](Scene_Message['DICE_ROLL'][_0x7f0ed9(0x535)+_0x7f0ed9(0x1ce)]);},Scene_Message[_0x5db7a1(0x4ce)]['diceRollSu'+_0x5db7a1(0x19c)+_0x5db7a1(0x335)]=function(){const _0xee9644=_0x5db7a1,_0x341af0={'Mlcly':function(_0x17c38c,_0x5e1c5f){return _0x17c38c*_0x5e1c5f;},'OUCny':function(_0x21d133,_0x27b30e){return _0x21d133/_0x27b30e;},'ZXMQm':function(_0x5a6908,_0x331aae){return _0x5a6908-_0x331aae;}};if(VisuMZ['DiceRollsR'+_0xee9644(0x20a)][_0xee9644(0x573)][_0xee9644(0x2cb)][_0xee9644(0x22a)+_0xee9644(0xfc)])return VisuMZ[_0xee9644(0x50f)+_0xee9644(0x20a)][_0xee9644(0x573)][_0xee9644(0x2cb)][_0xee9644(0x22a)+'ectJS'][_0xee9644(0x23f)](this);const _0x55c645=Math[_0xee9644(0x1fb)](Math[_0xee9644(0x383)](_0x341af0[_0xee9644(0x3bc)](Graphics['width'],-0x1213*-0x1+-0x11c+-0x10f7+0.8)),-0x23f1+0x2*0x1079+0x5cb),_0x3efec2=this[_0xee9644(0xfb)+'Height'](-0x3d*0x1b+-0x1*0x1315+0x1985,![]),_0x302754=Math[_0xee9644(0x383)](_0x341af0[_0xee9644(0x167)](_0x341af0['ZXMQm'](Graphics[_0xee9644(0x118)],_0x55c645),0xbc6+-0xf8e*-0x1+0xd*-0x21a)),_0x1c8310=_0x341af0['ZXMQm'](_0x341af0[_0xee9644(0x137)](Graphics['height'],this[_0xee9644(0xfb)+_0xee9644(0x5d6)](0x2*0x1231+-0x9fd*0x1+-0x1a61,!![])),_0x3efec2);return new Rectangle(_0x302754,_0x1c8310,_0x55c645,_0x3efec2);},Scene_Message[_0x5db7a1(0x4ce)][_0x5db7a1(0x18f)+_0x5db7a1(0x3e7)+_0x5db7a1(0x2a9)]=function(){const _0x159217=_0x5db7a1,_0x3649c1={'echXL':_0x159217(0x584)},_0x5024d5=this[_0x159217(0x41e)+_0x159217(0x440)+_0x159217(0x48a)](),_0x1e0efd=new Window_DiceEffectsList(_0x5024d5);this[_0x159217(0x168)](_0x1e0efd),_0x1e0efd[_0x159217(0x401)](_0x3649c1[_0x159217(0x398)],this[_0x159217(0x185)+_0x159217(0x263)+'el'][_0x159217(0x17e)](this)),this[_0x159217(0x23a)+_0x159217(0x210)+_0x159217(0x3b3)]=_0x1e0efd,_0x1e0efd[_0x159217(0x5c8)+'undType'](Scene_Message[_0x159217(0x28a)]['effectsBgT'+_0x159217(0x4e1)]);},Scene_Message['prototype'][_0x5db7a1(0x18f)+'RollBonusW'+_0x5db7a1(0x21d)]=function(){const _0x59a418=_0x5db7a1,_0x59c279={'ggzOU':_0x59a418(0x584),'Irpiu':_0x59a418(0x105)},_0x27209=this[_0x59a418(0x41e)+_0x59a418(0x440)+_0x59a418(0x48a)](),_0x2076b2=new Window_DiceBonusList(_0x27209);this[_0x59a418(0x168)](_0x2076b2),_0x2076b2[_0x59a418(0x401)](_0x59c279[_0x59a418(0xd1)],this['onDiceRoll'+_0x59a418(0x1dd)+'l'][_0x59a418(0x17e)](this)),_0x2076b2[_0x59a418(0x401)](_0x59c279[_0x59a418(0x55e)],this[_0x59a418(0x185)+_0x59a418(0x149)+_0x59a418(0x403)][_0x59a418(0x17e)](this)),this[_0x59a418(0x23a)+_0x59a418(0x44c)+'w']=_0x2076b2,_0x2076b2[_0x59a418(0x5c8)+_0x59a418(0x3d3)](Scene_Message[_0x59a418(0x28a)]['bonusBgTyp'+'e']);},Scene_Message['prototype'][_0x5db7a1(0x41e)+_0x5db7a1(0x440)+_0x5db7a1(0x48a)]=function(){const _0x3092e6=_0x5db7a1,_0x296f0f={'FzSCw':function(_0x180a6a,_0x3db6e7){return _0x180a6a/_0x3db6e7;},'TcWon':function(_0x1f61fc,_0x5689e2){return _0x1f61fc-_0x5689e2;},'XikIL':function(_0x10cc59,_0x37c1a0){return _0x10cc59-_0x37c1a0;}};if(VisuMZ['DiceRollsR'+_0x3092e6(0x20a)][_0x3092e6(0x573)][_0x3092e6(0x2cb)][_0x3092e6(0x308)+'S'])return VisuMZ[_0x3092e6(0x50f)+_0x3092e6(0x20a)][_0x3092e6(0x573)][_0x3092e6(0x2cb)][_0x3092e6(0x308)+'S'][_0x3092e6(0x23f)](this);const _0x46b5a8=Math['min'](Graphics[_0x3092e6(0x118)],0x2249*-0x1+0xbfc+0x1a45),_0xc52b1d=this[_0x3092e6(0xfb)+'Height'](-0x2064+-0x47*-0x49+0xc29,!![]),_0x48b77d=Math[_0x3092e6(0x383)](_0x296f0f['FzSCw'](_0x296f0f[_0x3092e6(0x1e6)](Graphics[_0x3092e6(0x118)],_0x46b5a8),0x1*-0xc07+0x1e0c+-0x1203)),_0x1985f3=_0x296f0f['XikIL'](Graphics[_0x3092e6(0xe3)],_0xc52b1d);return new Rectangle(_0x48b77d,_0x1985f3,_0x46b5a8,_0xc52b1d);},Scene_Message[_0x5db7a1(0x4ce)]['startClosi'+_0x5db7a1(0x39b)+_0x5db7a1(0x485)]=function(){const _0x13ac04=_0x5db7a1,_0x2035b5={'KoPXo':_0x13ac04(0x23a)+_0x13ac04(0x5bb)+'w','tIMUy':_0x13ac04(0x23a)+_0x13ac04(0x3fb)+_0x13ac04(0x21d),'rCDmN':_0x13ac04(0x23a)+_0x13ac04(0x1ec),'NdjHG':_0x13ac04(0x23a)+_0x13ac04(0x355)+_0x13ac04(0x5f1),'SCdwZ':_0x13ac04(0x23a)+_0x13ac04(0x140)+_0x13ac04(0x5f1)},_0x11f28c=[_0x2035b5['KoPXo'],_0x2035b5[_0x13ac04(0x3ab)],_0x2035b5[_0x13ac04(0x4c6)],_0x2035b5[_0x13ac04(0xf8)],_0x2035b5['SCdwZ']];for(const _0x1fad08 of _0x11f28c){if(!this[_0x1fad08])continue;this[_0x1fad08][_0x13ac04(0x5c1)]();}},Scene_Message[_0x5db7a1(0x4ce)]['removeAllD'+_0x5db7a1(0x406)+_0x5db7a1(0x2bd)]=function(){const _0x52d4c3=_0x5db7a1,_0x3014f9={'upSQi':_0x52d4c3(0x23a)+_0x52d4c3(0x336)+'ow','bjZnV':'_diceRoll_'+_0x52d4c3(0x1c0)+'ow','hgDGH':_0x52d4c3(0x23a)+_0x52d4c3(0x5bb)+'w','EJMgR':_0x52d4c3(0x23a)+_0x52d4c3(0x3fb)+_0x52d4c3(0x21d),'eRArU':_0x52d4c3(0x23a)+_0x52d4c3(0x1ec),'eDIPZ':_0x52d4c3(0x23a)+_0x52d4c3(0x355)+_0x52d4c3(0x5f1),'ZsrHy':_0x52d4c3(0x23a)+_0x52d4c3(0x140)+_0x52d4c3(0x5f1),'drMmF':'_diceRoll_'+_0x52d4c3(0x210)+'dow','plvws':_0x52d4c3(0x23a)+_0x52d4c3(0x44c)+'w'},_0x3296d0=[_0x3014f9[_0x52d4c3(0x397)],_0x3014f9[_0x52d4c3(0x166)],_0x3014f9[_0x52d4c3(0x3b7)],_0x3014f9[_0x52d4c3(0x5f5)],_0x3014f9['eRArU'],_0x3014f9[_0x52d4c3(0x1f4)],_0x3014f9['ZsrHy'],_0x3014f9[_0x52d4c3(0x4ef)],_0x3014f9[_0x52d4c3(0x59a)]];for(const _0x258471 of _0x3296d0){if(!this[_0x258471])continue;this[_0x52d4c3(0x1e9)+'d'](this[_0x258471]),this[_0x258471]=undefined;}},Scene_Message[_0x5db7a1(0x4ce)]['commandDic'+_0x5db7a1(0x15b)]=function(){const _0x1dd87e=_0x5db7a1;this[_0x1dd87e(0x23a)+_0x1dd87e(0x336)+'ow'][_0x1dd87e(0x342)+_0x1dd87e(0xc0)](),this[_0x1dd87e(0x23a)+_0x1dd87e(0x1c0)+'ow']['close']();},Scene_Message[_0x5db7a1(0x4ce)][_0x5db7a1(0x579)+_0x5db7a1(0x3f0)]=function(){const _0x1e7793=_0x5db7a1;this[_0x1e7793(0x23a)+_0x1e7793(0x1c0)+'ow'][_0x1e7793(0x5c1)](),this[_0x1e7793(0x23a)+_0x1e7793(0x210)+_0x1e7793(0x3b3)][_0x1e7793(0x2f3)](),this[_0x1e7793(0x23a)+_0x1e7793(0x210)+_0x1e7793(0x3b3)][_0x1e7793(0x165)](),this['_diceRoll_'+_0x1e7793(0x210)+'dow'][_0x1e7793(0x21e)]();},Scene_Message[_0x5db7a1(0x4ce)][_0x5db7a1(0x185)+_0x5db7a1(0x263)+'el']=function(){const _0x367ef2=_0x5db7a1;this[_0x367ef2(0x23a)+_0x367ef2(0x210)+_0x367ef2(0x3b3)][_0x367ef2(0x5c1)](),this[_0x367ef2(0x23a)+'EffectsWin'+_0x367ef2(0x3b3)]['deactivate'](),this[_0x367ef2(0x23a)+_0x367ef2(0x1c0)+'ow'][_0x367ef2(0x2f3)](),this[_0x367ef2(0x23a)+_0x367ef2(0x1c0)+'ow']['activate']();},Scene_Message[_0x5db7a1(0x4ce)][_0x5db7a1(0x579)+'eBonus']=function(){const _0x4cf91b=_0x5db7a1;this[_0x4cf91b(0x23a)+_0x4cf91b(0x1c0)+'ow']['close'](),this[_0x4cf91b(0x23a)+_0x4cf91b(0x44c)+'w']['open'](),this[_0x4cf91b(0x23a)+_0x4cf91b(0x44c)+'w'][_0x4cf91b(0x165)](),this['_diceRoll_'+_0x4cf91b(0x44c)+'w'][_0x4cf91b(0x21e)]();},Scene_Message['prototype'][_0x5db7a1(0x185)+_0x5db7a1(0x1dd)+'l']=function(){const _0x1c1ce8=_0x5db7a1,_0x2f5892={'ICEtJ':_0x1c1ce8(0x4fb)},_0x4d3f08=_0x2f5892[_0x1c1ce8(0x145)][_0x1c1ce8(0x293)]('|');let _0x3dd471=-0xe5d*0x1+-0x55b*-0x2+0x3a7;while(!![]){switch(_0x4d3f08[_0x3dd471++]){case'0':this['_diceRoll_'+_0x1c1ce8(0x44c)+'w'][_0x1c1ce8(0x5c1)]();continue;case'1':this[_0x1c1ce8(0x23a)+_0x1c1ce8(0x1c0)+'ow'][_0x1c1ce8(0x2f3)]();continue;case'2':this['_diceRoll_'+_0x1c1ce8(0x1c0)+'ow'][_0x1c1ce8(0x21e)]();continue;case'3':this[_0x1c1ce8(0x23a)+'ChoiceWind'+'ow'][_0x1c1ce8(0x165)]();continue;case'4':this[_0x1c1ce8(0x23a)+'BonusWindo'+'w'][_0x1c1ce8(0x466)]();continue;}break;}},Scene_Message[_0x5db7a1(0x4ce)][_0x5db7a1(0x185)+'BonusUseEf'+_0x5db7a1(0x403)]=function(){const _0x366386=_0x5db7a1,_0x197f84=this[_0x366386(0x23a)+_0x366386(0x44c)+'w'][_0x366386(0x312)]();_0x197f84&&this[_0x366386(0x14e)+_0x366386(0x5d8)+_0x366386(0x272)](_0x197f84),this['_diceRoll_'+_0x366386(0x44c)+'w']['activate'](),this[_0x366386(0x23a)+_0x366386(0x44c)+'w']['refresh']();},Scene_Message['prototype']['useCurrent'+'DiceBonusE'+'ffect']=function(_0x435c04){const _0x45c5e8=_0x5db7a1,_0xbde74d={'bNbVt':function(_0x179e08,_0x51cce3){return _0x179e08-_0x51cce3;}};SceneManager[_0x45c5e8(0x516)+_0x45c5e8(0x272)](_0x435c04);_0x435c04[_0x45c5e8(0x254)+'D']&&$gameTemp['requestAni'+_0x45c5e8(0x27c)]([$gamePlayer],_0x435c04[_0x45c5e8(0x254)+'D']);if(_0x435c04[_0x45c5e8(0x286)+_0x45c5e8(0x279)]){const _0x3a9e55=$gameVariables[_0x45c5e8(0x3b0)](_0x435c04[_0x45c5e8(0x286)+_0x45c5e8(0x279)]),_0x3d5567=Math[_0x45c5e8(0x508)](_0x435c04['VariableCo'+_0x45c5e8(0x52e)]||0x264b*-0x1+-0x1*0x16ca+0x3d16,0x4*0x763+-0x203*-0x4+-0x2597),_0x566ae6=_0xbde74d[_0x45c5e8(0x5df)](_0x3a9e55,_0x3d5567);$gameVariables['setValue'](_0x435c04['VariableCo'+_0x45c5e8(0x279)],_0x566ae6);}if(_0x435c04['ItemCostID']){const _0x5b75e8=$dataItems[_0x435c04[_0x45c5e8(0x5c6)]],_0x58e472=Math[_0x45c5e8(0x508)](_0x435c04[_0x45c5e8(0x5f7)+_0x45c5e8(0x2c0)]||0x51b*-0x1+0x25ab*0x1+-0x208f,0x1ea8+0xc7e+-0x2b25);$gameParty[_0x45c5e8(0x5c7)](_0x5b75e8,_0x58e472,![]);}if(_0x435c04[_0x45c5e8(0x4fe)+'ID']){const _0x2a994f=$dataWeapons[_0x435c04[_0x45c5e8(0x4fe)+'ID']],_0x1ab9b9=Math[_0x45c5e8(0x508)](_0x435c04['WeaponCost'+'Value']||-0x4*-0x368+0x2085+-0x2e24,0x2*-0x747+-0x6*0x65b+0x149*0x29);$gameParty[_0x45c5e8(0x5c7)](_0x2a994f,_0x1ab9b9,![]);}if(_0x435c04[_0x45c5e8(0x2bc)+'D']){const _0x539fba=$dataArmors[_0x435c04[_0x45c5e8(0x2bc)+'D']],_0x1246ac=Math[_0x45c5e8(0x508)](_0x435c04['ArmorCostV'+_0x45c5e8(0x1bf)]||0x251d*-0x1+-0x2629+0x4b47,-0x3*-0x903+-0x5*0x528+-0x140);$gameParty['loseItem'](_0x539fba,_0x1246ac,![]);}if(_0x435c04['SkillCostI'+'D']){const _0x38c652=$gameActors[_0x45c5e8(0x154)](_0x435c04['SkillUserA'+'ctorID']);if(_0x38c652){const _0x2004c0=$dataSkills[_0x435c04[_0x45c5e8(0x396)+'D']];_0x38c652[_0x45c5e8(0x2ca)+'st'](_0x2004c0);}}_0x435c04[_0x45c5e8(0x4fa)]&&(_0x435c04['CurrentUse'+'s']=_0x435c04[_0x45c5e8(0x5dd)+'s']||-0x31*0x9+-0x1850+-0x9b*-0x2b,_0x435c04[_0x45c5e8(0x5dd)+'s']+=0x1306+-0x579*-0x2+-0x1df7),_0x435c04[_0x45c5e8(0x548)]&&_0x435c04[_0x45c5e8(0x548)]();};function Sprite_DiceCheck(){const _0x1ee9bc=_0x5db7a1;this[_0x1ee9bc(0x244)](...arguments);}Sprite_DiceCheck[_0x5db7a1(0x4ce)]=Object[_0x5db7a1(0x467)](Sprite[_0x5db7a1(0x4ce)]),Sprite_DiceCheck[_0x5db7a1(0x4ce)][_0x5db7a1(0xeb)+'r']=Sprite_DiceCheck,Sprite_DiceCheck[_0x5db7a1(0x444)]={'d4':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x573)][_0x5db7a1(0x2f7)]['D4']??{},'d6':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x573)]['Dice']['D6']??{},'d8':VisuMZ[_0x5db7a1(0x50f)+'ngSeeds']['Settings'][_0x5db7a1(0x2f7)]['D8']??{},'d10':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)]['Settings']['Dice'][_0x5db7a1(0x5ad)]??{},'d12':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x573)][_0x5db7a1(0x2f7)]['D12']??{},'d20':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x573)][_0x5db7a1(0x2f7)]['D20']??{},'offsetX':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)]['Settings']['Dice']['ArrangeOff'+_0x5db7a1(0x220)]??-0x13*0x85+-0x1*0x18e5+0x22c4,'offsetY':VisuMZ['DiceRollsR'+_0x5db7a1(0x20a)][_0x5db7a1(0x573)][_0x5db7a1(0x2f7)][_0x5db7a1(0x26f)+_0x5db7a1(0x49e)]??-0x36e+0x23eb+-0x207d,'fadeInDuration':VisuMZ[_0x5db7a1(0x50f)+'ngSeeds'][_0x5db7a1(0x573)][_0x5db7a1(0x2f7)][_0x5db7a1(0x2f4)+'tion']??0x23b*-0x3+0xe19+0x6*-0x137,'fadeOutDuration':VisuMZ[_0x5db7a1(0x50f)+'ngSeeds'][_0x5db7a1(0x573)][_0x5db7a1(0x2f7)][_0x5db7a1(0x13b)+_0x5db7a1(0x5dc)]??0x3*0x822+0xbad+-0x23ff,'finalizeDelay':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x573)][_0x5db7a1(0x2f7)][_0x5db7a1(0x1d2)+'lay']??0xcc*-0x8+-0x97*0x3b+-0x1*-0x2969,'rollDuration':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x573)][_0x5db7a1(0x2f7)][_0x5db7a1(0x40e)+'on']??0x99e*0x2+-0x1*0x23dd+0x1*0x10dd,'rollDelay':VisuMZ[_0x5db7a1(0x50f)+'ngSeeds'][_0x5db7a1(0x573)][_0x5db7a1(0x2f7)][_0x5db7a1(0x3b1)]??-0x25bd+-0x23ed+-0x4*-0x126d,'rollHeight':VisuMZ['DiceRollsR'+_0x5db7a1(0x20a)]['Settings'][_0x5db7a1(0x2f7)][_0x5db7a1(0x15d)]??-0x1ad4+-0x1f1e+-0x1b9*-0x22,'rotateSpeed':VisuMZ['DiceRollsR'+'ngSeeds']['Settings'][_0x5db7a1(0x2f7)]['rotateSpee'+'d']??-0x2*-0xcaa+0x1*-0x1f31+0x5ec,'moveDuration':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x573)][_0x5db7a1(0x2f7)][_0x5db7a1(0x595)+'on']??-0xe2e+0x885+0x5bd,'scaleDuration':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x573)][_0x5db7a1(0x2f7)]['scaleDurat'+_0x5db7a1(0x58a)]??-0x18ca+0x1*-0x12d9+0x25*0x12f,'numberDuration':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x573)][_0x5db7a1(0x2f7)][_0x5db7a1(0x392)+_0x5db7a1(0x2a1)]??0x1aa+0xc8c+-0x2*0x719,'maxNumberDuration':VisuMZ[_0x5db7a1(0x50f)+'ngSeeds'][_0x5db7a1(0x573)][_0x5db7a1(0x2f7)][_0x5db7a1(0x5f4)+_0x5db7a1(0x5d2)]??-0x1428+0x6cb*0x1+0x1*0xdad,'numberColorShift':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x573)][_0x5db7a1(0x2f7)][_0x5db7a1(0xd2)+_0x5db7a1(0x581)]??!![],'rollModDelay':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x573)][_0x5db7a1(0x2f7)][_0x5db7a1(0x381)+'ay']??-0x267*-0x1+0x3fa+0x79*-0xd},Sprite_DiceCheck[_0x5db7a1(0x4ce)][_0x5db7a1(0x244)]=function(){const _0x4d933e=_0x5db7a1,_0x4ba409={'TtDJX':_0x4d933e(0x400)},_0x484fe4=_0x4ba409[_0x4d933e(0x284)][_0x4d933e(0x293)]('|');let _0x446da5=-0xada+0x7f6*0x1+-0x94*-0x5;while(!![]){switch(_0x484fe4[_0x446da5++]){case'0':this[_0x4d933e(0x50c)+_0x4d933e(0x250)]();continue;case'1':this['createNumb'+'erSprite']();continue;case'2':this[_0x4d933e(0x142)+'ap']();continue;case'3':this['initMember'+'s']();continue;case'4':Sprite[_0x4d933e(0x4ce)][_0x4d933e(0x244)][_0x4d933e(0x23f)](this);continue;}break;}},Sprite_DiceCheck[_0x5db7a1(0x4ce)]['initMember'+'s']=function(){const _0x5217b1=_0x5db7a1,_0x1f581a={'GEyBX':'2|3|13|9|1'+_0x5217b1(0x357)+_0x5217b1(0x3a6)+_0x5217b1(0x2d8),'sVRmF':'d%1'},_0xf6b4d=_0x1f581a[_0x5217b1(0x4c5)][_0x5217b1(0x293)]('|');let _0x543859=-0x1128+-0x2592+-0x6*-0x91f;while(!![]){switch(_0xf6b4d[_0x543859++]){case'0':this['_numberShi'+'ftDuration']=-0x1c38+-0xa8b+-0x26c3*-0x1;continue;case'1':this['_fadeDurat'+_0x5217b1(0x58a)]=0x1*0x201a+-0xdb0+-0x126a*0x1;continue;case'2':this[_0x5217b1(0x26a)]['x']=0x26d0+0x4*0x652+0x2*-0x200c+0.5;continue;case'3':this[_0x5217b1(0x26a)]['y']=0x74*0x40+0xd32+-0x16*0x1eb+0.5;continue;case'4':this[_0x5217b1(0x572)+'t']=0x352*0x1+-0x5bd+0x36a;continue;case'5':this['_rollDurat'+'ion']=0xa7f*0x1+-0x1*-0x9f8+-0xa9*0x1f;continue;case'6':this[_0x5217b1(0x4e6)+'tX']=-0x13db*-0x1+-0x1c07+0x82c;continue;case'7':this['_numberShi'+_0x5217b1(0x282)]=0xce1*-0x2+0x6*0x164+0x116a;continue;case'8':this[_0x5217b1(0x5ca)+_0x5217b1(0x58a)]=0x2*-0x1302+-0xec3+0xe5*0x3b;continue;case'9':this['_settingsK'+'ey']=_0x1f581a[_0x5217b1(0x2ea)][_0x5217b1(0x13e)](VisuMZ['DiceRollsR'+'ngSeeds'][_0x5217b1(0x242)+_0x5217b1(0x4f5)]());continue;case'10':this[_0x5217b1(0x457)+_0x5217b1(0x139)]=-0x1495*-0x1+-0x1896+0x5*0xcd;continue;case'11':this[_0x5217b1(0x42a)+_0x5217b1(0x2a1)]=0x4f9*-0x4+0x1405+-0x21;continue;case'12':this[_0x5217b1(0x3f1)+'Duration']=-0x1*-0xbc5+-0x9b1*0x2+0x79d;continue;case'13':this[_0x5217b1(0x415)]=-0xe55+-0x1*0x1f2d+0x2d82;continue;case'14':this['_scaleTarg'+'et']=0x1307+0xd7+-0x13de;continue;case'15':this[_0x5217b1(0x310)+'uration']=-0xafe+-0x4e8+-0x1*-0xfe6;continue;}break;}},Sprite_DiceCheck[_0x5db7a1(0x4ce)]['diceSettin'+'gs']=function(){const _0x3af200=_0x5db7a1,_0x1a5eca={'FCQXH':_0x3af200(0x346)},_0x2dbc48=this[_0x3af200(0x5c3)+'ey']||_0x1a5eca[_0x3af200(0x14a)];return Sprite_DiceCheck[_0x3af200(0x444)][_0x2dbc48];},Sprite_DiceCheck[_0x5db7a1(0x4ce)]['getImageFi'+_0x5db7a1(0x169)]=function(){const _0x72c69e=_0x5db7a1,_0x315d6e={'arqMa':_0x72c69e(0x1e2)+'es','ztnXl':_0x72c69e(0x346)},_0x57d09f=SceneManager[_0x72c69e(0x2aa)+_0x72c69e(0x2d2)]||{};if(_0x57d09f[_0x72c69e(0x325)]){const _0x1e7211=_0x315d6e['arqMa']['format'](this[_0x72c69e(0x5c3)+'ey']||_0x315d6e[_0x72c69e(0x2b1)]);if(_0x57d09f[_0x72c69e(0x325)][_0x1e7211])return _0x57d09f[_0x72c69e(0x325)][_0x1e7211];}const _0xdd4335=this[_0x72c69e(0x2e8)+'gs']();return _0xdd4335[_0x72c69e(0x32d)]||[];},Sprite_DiceCheck[_0x5db7a1(0x4ce)][_0x5db7a1(0x1a5)+'lors']=function(){const _0x46034b=_0x5db7a1,_0x2d4656={'MNobU':function(_0x4c5b70,_0x2cf57a){return _0x4c5b70>_0x2cf57a;}},_0x5c5cf4=SceneManager[_0x46034b(0x2aa)+'ettings']||{};if(_0x5c5cf4[_0x46034b(0x325)]){if(_0x5c5cf4[_0x46034b(0x325)][_0x46034b(0x5d7)]&&_0x2d4656[_0x46034b(0x5a0)](_0x5c5cf4[_0x46034b(0x325)]['colors'][_0x46034b(0x5de)],-0x17ca+-0x2638*0x1+0x3e02*0x1))return _0x5c5cf4[_0x46034b(0x325)][_0x46034b(0x5d7)];}const _0x2ce713=this[_0x46034b(0x2e8)+'gs']();return _0x2ce713[_0x46034b(0x5d7)]||[0x766*-0x5+-0x1c95+0x419b,-0x6*0x11+0x130*-0x1c+0xc4*0x2c,0x13a3+-0x1*0x8d1+-0xabd,-0x238a+0x21*-0x1b+0x2*0x138b,-0x1*0x607+-0x210*0x2+0x36c*0x3,-0x11f9+0x177c+0x15b*-0x4,-0x20e6+-0x16b0+0x37b5*0x1,-0x539*0x1+0x10f*0x1a+-0x1632];},Sprite_DiceCheck[_0x5db7a1(0x4ce)][_0x5db7a1(0x142)+'ap']=function(){const _0x2f9664=_0x5db7a1,_0x10e761={'YIGvw':function(_0x217b3a,_0x1104df){return _0x217b3a>_0x1104df;}},_0x56da0b=this[_0x2f9664(0x5ed)+'lenames']();if(_0x10e761[_0x2f9664(0x1fc)](_0x56da0b[_0x2f9664(0x5de)],0x5*-0x301+-0x214b+0x1828*0x2))this[_0x2f9664(0x44e)]=ImageManager[_0x2f9664(0x207)+'cture'](_0x56da0b);else{const _0x1f1151=this[_0x2f9664(0x5c3)+'ey'],_0x2213d3=this[_0x2f9664(0x1a5)+'lors']();this[_0x2f9664(0x44e)]=ImageManager[_0x2f9664(0x18f)+_0x2f9664(0x3fa)](_0x1f1151,_0x2213d3);}},Sprite_DiceCheck['prototype']['createNumb'+_0x5db7a1(0xf9)]=function(){const _0xd1fe35=_0x5db7a1,_0x1988b9=new Sprite();_0x1988b9[_0xd1fe35(0x44e)]=new Bitmap(-0x259b+0x2d7*0x7+-0x121e*-0x1,-0x3*-0x13+-0x30e*-0x4+-0xc0d),this['addChild'](_0x1988b9);const _0x2c8932=this[_0xd1fe35(0x2e8)+'gs']();_0x1988b9['x']=_0x2c8932[_0xd1fe35(0x365)+'X']||-0x2ec+-0x1*0x1b6b+-0x3*-0xa1d,_0x1988b9['y']=_0x2c8932[_0xd1fe35(0x365)+'Y']||0x260a+-0x1ce5+-0x925,_0x1988b9[_0xd1fe35(0x26a)]['x']=0xc31+-0x119*0x16+0xbf5+0.5,_0x1988b9['anchor']['y']=-0x1449+0xa3*0x16+0x647+0.5,this[_0xd1fe35(0x163)+'ite']=_0x1988b9,this['_numberVal'+'ue']=0x621*-0x1+-0xa64+0x1085,this[_0xd1fe35(0x414)+'t']='?',this[_0xd1fe35(0x356)+'or']=0x129b+-0x2*-0xa2a+-0x26ef,this[_0xd1fe35(0x1ea)]();},Sprite_DiceCheck['prototype'][_0x5db7a1(0x50c)+_0x5db7a1(0x250)]=function(){const _0x1100ca=_0x5db7a1;this['_blurFilte'+'r']=new PIXI['filters']['BlurFilter'](),this[_0x1100ca(0x387)+'r'][_0x1100ca(0x35d)]=-0x2f*0x40+-0x2*-0x114e+0x2c*-0x85,this['filters']=this[_0x1100ca(0x3c8)]||[],this[_0x1100ca(0x3c8)][_0x1100ca(0x1bd)](this[_0x1100ca(0x387)+'r']);},Sprite_DiceCheck[_0x5db7a1(0x4ce)]['setBaseXy']=function(_0x4371eb,_0x267e7e){const _0xda3467=_0x5db7a1;this['_baseX']=_0x4371eb,this['_baseY']=_0x267e7e;{const _0x33a932=Sprite_DiceCheck[_0xda3467(0x444)];this[_0xda3467(0x1d0)]+=_0x33a932[_0xda3467(0x12d)],this['_baseY']+=_0x33a932[_0xda3467(0x517)];}{const _0x401860=this['diceSettin'+'gs']();this[_0xda3467(0x1d0)]+=_0x401860[_0xda3467(0x5ea)+_0xda3467(0x1eb)],this['_baseY']+=_0x401860[_0xda3467(0x5ea)+'fsetY'];}this['x']=this[_0xda3467(0x1d0)],this['y']=this['_baseY'],this[_0xda3467(0xd9)+'n']();},Sprite_DiceCheck['prototype'][_0x5db7a1(0x28c)+'le']=function(_0x4a435a){const _0x5d2293=_0x5db7a1;this['_baseScale']=_0x4a435a,this[_0x5d2293(0x1c6)]['x']=this['scale']['y']=_0x4a435a;},Sprite_DiceCheck['prototype']['startDiceR'+_0x5db7a1(0xc0)]=function(_0x2000cb){const _0x312b05=_0x5db7a1,_0x3ef71c={'mjPhb':function(_0x29078c,_0x5784d2){return _0x29078c*_0x5784d2;},'XxARU':function(_0x17e621,_0x195293){return _0x17e621||_0x195293;}},_0x5074c8=Sprite_DiceCheck['SETTINGS'];this[_0x312b05(0x35a)+_0x312b05(0x58a)]=_0x5074c8[_0x312b05(0x40e)+'on'],this['_wholeRoll'+_0x312b05(0x139)]=this[_0x312b05(0x35a)+_0x312b05(0x58a)],this[_0x312b05(0x3f1)+_0x312b05(0x139)]=_0x3ef71c[_0x312b05(0x3ef)](_0x3ef71c[_0x312b05(0x446)](_0x2000cb,0x26e*-0x10+-0xb5*-0x7+0x6c9*0x5),_0x5074c8['rollDelay']||-0xc*0x47+-0x1*0x6dd+0xa31);},Sprite_DiceCheck[_0x5db7a1(0x4ce)][_0x5db7a1(0x526)]=function(){const _0x340a65=_0x5db7a1,_0x35e623={'LRCZP':_0x340a65(0x5be)+_0x340a65(0x116)},_0xdf1a51=_0x35e623[_0x340a65(0x50a)]['split']('|');let _0x373283=0x138e+0x1376+-0x2*0x1382;while(!![]){switch(_0xdf1a51[_0x373283++]){case'0':this[_0x340a65(0x32e)+_0x340a65(0x2a1)]();continue;case'1':this[_0x340a65(0xf3)+'erShift']();continue;case'2':Sprite[_0x340a65(0x4ce)][_0x340a65(0x526)][_0x340a65(0x23f)](this);continue;case'3':this[_0x340a65(0x3f9)+_0x340a65(0x4d4)]();continue;case'4':this[_0x340a65(0x24b)]();continue;case'5':this[_0x340a65(0x490)]();continue;case'6':this[_0x340a65(0x574)+_0x340a65(0x420)]();continue;case'7':this[_0x340a65(0x42b)+_0x340a65(0x2de)]();continue;}break;}},Sprite_DiceCheck[_0x5db7a1(0x4ce)]['isAnimatin'+'g']=function(){const _0xcfa6af=_0x5db7a1,_0x5e331d={'nzmNC':_0xcfa6af(0x459)},_0x166917=_0x5e331d['nzmNC'][_0xcfa6af(0x293)]('|');let _0x225ad8=0x3a6*-0x7+-0x12b4+0x2c3e;while(!![]){switch(_0x166917[_0x225ad8++]){case'0':if(this[_0xcfa6af(0xef)+_0xcfa6af(0x51b)]())return!![];continue;case'1':return![];case'2':if(this[_0xcfa6af(0x5d4)]())return!![];continue;case'3':if(this['isRolling']())return!![];continue;case'4':if(this[_0xcfa6af(0x473)+_0xcfa6af(0x120)]())return!![];continue;}break;}},Sprite_DiceCheck[_0x5db7a1(0x4ce)][_0x5db7a1(0x24b)]=function(){const _0x27e6f3=_0x5db7a1,_0x26541e={'yGtNc':function(_0x5815af,_0x37ae39){return _0x5815af>_0x37ae39;},'hynpH':function(_0x308b52,_0x1e0eed){return _0x308b52<=_0x1e0eed;},'iBlmg':function(_0x3f651c,_0x5c4f75){return _0x3f651c-_0x5c4f75;},'AvFvL':function(_0x45e64a,_0x2de83b){return _0x45e64a/_0x2de83b;},'FztSj':function(_0xe3ae2d,_0x41267f){return _0xe3ae2d/_0x41267f;},'UTgSo':function(_0x4c1d8d,_0x3fb052){return _0x4c1d8d+_0x3fb052;},'bgdtj':function(_0x2d534e,_0x578c3a){return _0x2d534e*_0x578c3a;},'dFVQr':function(_0x370ce9,_0x2f4522){return _0x370ce9-_0x2f4522;},'eHsME':function(_0x4ce145,_0x451740){return _0x4ce145+_0x451740;},'GBeuB':function(_0x2e77ea,_0x40d834){return _0x2e77ea===_0x40d834;}};if(_0x26541e[_0x27e6f3(0x59d)](this[_0x27e6f3(0x3f1)+_0x27e6f3(0x139)],-0x51*0x37+-0xb9d+0x1d04))return this[_0x27e6f3(0x3f1)+_0x27e6f3(0x139)]--;if(_0x26541e[_0x27e6f3(0x3b4)](this[_0x27e6f3(0x35a)+_0x27e6f3(0x58a)],0x1da1+-0x3*0xa27+-0x4*-0x35))return;const _0x2d303e=this[_0x27e6f3(0x35a)+_0x27e6f3(0x58a)],_0x3aa0cd=this[_0x27e6f3(0x457)+'Duration'],_0x14373c=_0x26541e['iBlmg'](_0x3aa0cd,_0x2d303e),_0x5549db=_0x26541e[_0x27e6f3(0x2d6)](_0x3aa0cd,-0xc5a+-0xef*-0x22+-0x1362),_0x28fa84=Sprite_DiceCheck[_0x27e6f3(0x444)][_0x27e6f3(0x15d)]||0x74b+-0x839+0xef,_0x58efd0=_0x26541e[_0x27e6f3(0x449)](-_0x28fa84,Math[_0x27e6f3(0x552)](_0x5549db,-0x2a4*0x9+-0x2*0x95f+-0x2a84*-0x1)),_0x51c3b1=-_0x26541e['UTgSo'](_0x26541e[_0x27e6f3(0x157)](_0x58efd0,Math[_0x27e6f3(0x552)](_0x26541e['dFVQr'](_0x14373c,_0x5549db),0x729*0x2+0x1*-0x1a76+0xc26)),_0x28fa84);this['y']=_0x26541e[_0x27e6f3(0xdf)](this[_0x27e6f3(0x275)],_0x51c3b1),this[_0x27e6f3(0x285)+_0x27e6f3(0x582)](),_0x26541e[_0x27e6f3(0x5e1)](_0x2d303e,_0x3aa0cd)&&SoundManager[_0x27e6f3(0xc9)+_0x27e6f3(0x493)](),this['_rollDurat'+_0x27e6f3(0x58a)]--,_0x26541e[_0x27e6f3(0x3b4)](this[_0x27e6f3(0x35a)+_0x27e6f3(0x58a)],-0x81c+0x673+0x1a9)&&(this['y']=this[_0x27e6f3(0x275)],this[_0x27e6f3(0x285)+_0x27e6f3(0x582)](!![]));},Sprite_DiceCheck[_0x5db7a1(0x4ce)]['isRolling']=function(){const _0x26da8a=_0x5db7a1,_0x480cea={'eIGtq':function(_0x51845d,_0xca6f75){return _0x51845d>_0xca6f75;},'Dlyiq':function(_0x2e05a8,_0x349cce){return _0x2e05a8>_0x349cce;}};return _0x480cea[_0x26da8a(0x460)](this[_0x26da8a(0x3f1)+_0x26da8a(0x139)],-0x9a4*0x1+0x1*0x126e+-0x8ca)||_0x480cea[_0x26da8a(0x2bf)](this[_0x26da8a(0x35a)+'ion'],-0x2545+-0x26af+0x4bf4);},Sprite_DiceCheck[_0x5db7a1(0x4ce)][_0x5db7a1(0x32e)+'tion']=function(){const _0x1b3959=_0x5db7a1,_0x133cb7={'rJxbV':function(_0x2b4512,_0x379e97){return _0x2b4512===_0x379e97;},'WUCEo':function(_0x292d2e,_0x5b454b){return _0x292d2e!==_0x5b454b;}};if(_0x133cb7['rJxbV'](this['y'],this['_baseY'])){if(_0x133cb7[_0x1b3959(0x162)](this['angle'],0xbf*0x7+-0x4d*-0x77+-0x2904))this['angle']=0x1b65*0x1+-0x21ad+0x648;return;}const _0x2b0de2=Sprite_DiceCheck[_0x1b3959(0x444)][_0x1b3959(0x475)+'d']||0x583*0x7+-0x1639+0x417*-0x4;this[_0x1b3959(0x2c4)]+=_0x2b0de2;},Sprite_DiceCheck[_0x5db7a1(0x4ce)][_0x5db7a1(0x490)]=function(){const _0x5cbc81=_0x5db7a1,_0x223264={'ZFKgc':function(_0x28f482,_0x180389){return _0x28f482<=_0x180389;},'LXHvY':function(_0xf2f695,_0x3ef0b7){return _0xf2f695/_0x3ef0b7;},'eMPXi':function(_0x2d4d05,_0x4d03f9){return _0x2d4d05+_0x4d03f9;},'szfVI':function(_0x4a1055,_0x5862b9){return _0x4a1055*_0x5862b9;},'xSmLH':function(_0x2407a1,_0x2bb3a0){return _0x2407a1-_0x2bb3a0;}};if(_0x223264[_0x5cbc81(0x215)](this[_0x5cbc81(0x5ca)+'ion'],0xe3*0x19+0x78f+0x5f2*-0x5))return;const _0x359325=this[_0x5cbc81(0x5ca)+_0x5cbc81(0x58a)];this['x']=_0x223264[_0x5cbc81(0x155)](_0x223264['eMPXi'](_0x223264[_0x5cbc81(0x1ff)](this['x'],_0x223264[_0x5cbc81(0x42e)](_0x359325,-0x945+-0x1c99+0x115*0x23)),this[_0x5cbc81(0x4e6)+'tX']),_0x359325),this[_0x5cbc81(0x5ca)+_0x5cbc81(0x58a)]--,_0x223264['ZFKgc'](this[_0x5cbc81(0x5ca)+'ion'],-0x1*-0x22dd+-0x115d+-0x1180)&&(this['x']=this[_0x5cbc81(0x4e6)+'tX']);},Sprite_DiceCheck['prototype'][_0x5db7a1(0x211)+'oX']=function(_0xb2949e){const _0x82d861=_0x5db7a1,_0x168825={'vFcHi':function(_0x4717c3,_0x5421ca){return _0x4717c3||_0x5421ca;},'qofpv':function(_0x1a6af7,_0x4f294c){return _0x1a6af7===_0x4f294c;}},_0x1452f8=Sprite_DiceCheck[_0x82d861(0x444)],_0x208308=this[_0x82d861(0x2e8)+'gs']();_0xb2949e=_0x168825['vFcHi'](_0xb2949e,0x1*-0x48d+-0x1*0x1813+-0x394*-0x8),_0xb2949e+=_0x1452f8[_0x82d861(0x12d)]||-0x1041*0x2+0x1*0x4b5+-0x1bcd*-0x1,_0xb2949e+=_0x208308[_0x82d861(0x5ea)+'fsetX']||-0xfc4+0x9a5+0x1*0x61f;if(_0x168825[_0x82d861(0x4c3)](this['x'],_0xb2949e))return;this[_0x82d861(0x4e6)+'tX']=_0xb2949e,this[_0x82d861(0x5ca)+_0x82d861(0x58a)]=_0x1452f8['moveDurati'+'on']||-0x1160+-0x1*-0x11e+0x1043;},Sprite_DiceCheck[_0x5db7a1(0x4ce)][_0x5db7a1(0x5d4)]=function(){const _0x507d86=_0x5db7a1,_0x51f02d={'KmNQh':function(_0xe40092,_0x2c8b1c){return _0xe40092>_0x2c8b1c;}};return _0x51f02d[_0x507d86(0x20f)](this[_0x507d86(0x5ca)+'ion'],-0x2654+0x1cf5+-0x95f*-0x1);},Sprite_DiceCheck['prototype'][_0x5db7a1(0xf3)+_0x5db7a1(0x266)]=function(){const _0x46813e=_0x5db7a1,_0xb61940={'mfrfW':function(_0x3d933c,_0x54ea97){return _0x3d933c<=_0x54ea97;},'YvhLx':function(_0x2ed750,_0x53d946){return _0x2ed750/_0x53d946;},'tSENH':function(_0x141a8a,_0x5d6a56){return _0x141a8a+_0x5d6a56;},'QJEDg':function(_0x4f9728,_0x44d222){return _0x4f9728*_0x44d222;},'pYZQG':function(_0x444a81,_0x576543){return _0x444a81-_0x576543;},'KATkQ':function(_0xe35c02,_0x34c6a3){return _0xe35c02(_0x34c6a3);},'KiVgW':function(_0x555dba,_0x48f46d){return _0x555dba!==_0x48f46d;}};if(this[_0x46813e(0x5d4)]())return;if(_0xb61940[_0x46813e(0x22b)](this[_0x46813e(0x197)+_0x46813e(0x36d)],-0x39*0x1+-0x2650+0x2689))return;const _0x324570=this[_0x46813e(0x197)+_0x46813e(0x36d)];this[_0x46813e(0x539)+'ue']=_0xb61940[_0x46813e(0x28b)](_0xb61940[_0x46813e(0x546)](_0xb61940[_0x46813e(0x500)](this['_numberVal'+'ue'],_0xb61940[_0x46813e(0x2b3)](_0x324570,-0xfcf+0x7cf*0x3+-0x79d)),this['_numberShi'+_0x46813e(0x282)]),_0x324570),this[_0x46813e(0x197)+'ftDuration']--;_0xb61940['mfrfW'](this['_numberShi'+'ftDuration'],-0x1*-0x26a5+-0x4*-0xd5+0x1*-0x29f9)&&(this[_0x46813e(0x539)+'ue']=this[_0x46813e(0x197)+'ftTarget']);const _0x41c2e0=this[_0x46813e(0x414)+'t'];this[_0x46813e(0x414)+'t']=_0xb61940['KATkQ'](String,Math[_0x46813e(0x383)](this[_0x46813e(0x539)+'ue'])),this[_0x46813e(0x1ea)](),_0xb61940['KiVgW'](_0x41c2e0,this[_0x46813e(0x414)+'t'])&&SoundManager[_0x46813e(0x144)+'crement']();},Sprite_DiceCheck['prototype'][_0x5db7a1(0x285)+_0x5db7a1(0x582)]=function(_0xab68ee){const _0x3d23c4=_0x5db7a1,_0x413bb7={'TUJvt':function(_0x5aed34,_0x49a366){return _0x5aed34!==_0x49a366;},'gWiFe':_0x3d23c4(0x52a),'UpBzm':function(_0x25d537,_0x1b5869){return _0x25d537+_0x1b5869;},'uGKoH':function(_0xe7b82e,_0x5073fe){return _0xe7b82e(_0x5073fe);}},_0x466f3d=SceneManager[_0x3d23c4(0x2aa)+'ettings']||{},_0x222cb7=_0x466f3d[_0x3d23c4(0x325)]||{},_0x275cc1=VisuMZ['DiceRollsR'+_0x3d23c4(0x20a)]['CurrentDic'+_0x3d23c4(0x4f5)]();if(_0xab68ee&&_0x222cb7['Seed']&&_0x413bb7[_0x3d23c4(0x230)](_0x222cb7[_0x3d23c4(0x375)],_0x413bb7[_0x3d23c4(0x5da)])){const _0x42d5f6=_0x222cb7[_0x3d23c4(0x375)],_0xd184ae=_0x222cb7[_0x3d23c4(0x3a2)],_0x4cbff2=_0x222cb7[_0x3d23c4(0x2e4)+'e'];this['_numberVal'+'ue']=$gameSystem[_0x3d23c4(0x46b)+_0x3d23c4(0x605)+'mberFromSe'+'ed'](0x738+0xa99+0x4*-0x474,_0x275cc1,_0x42d5f6,_0xd184ae,_0x4cbff2);}else this['_numberVal'+'ue']=_0x413bb7[_0x3d23c4(0x47d)](Math[_0x3d23c4(0x170)](_0x275cc1),0x1263+0x2*-0x31a+-0xc2e);this[_0x3d23c4(0x414)+'t']=_0x413bb7[_0x3d23c4(0x438)](String,Math['round'](this['_numberVal'+'ue'])),this[_0x3d23c4(0x1ea)]();},Sprite_DiceCheck[_0x5db7a1(0x4ce)][_0x5db7a1(0x1ea)]=function(){const _0x4c259c=_0x5db7a1,_0x5688b6={'JvsBA':function(_0x376742,_0x1abfcf){return _0x376742+_0x1abfcf;},'AfQfb':_0x4c259c(0x5d9)+_0x4c259c(0x2ab),'zInCN':_0x4c259c(0x108)},_0x36c588=this[_0x4c259c(0x163)+_0x4c259c(0x196)],_0x4ecec1=_0x36c588[_0x4c259c(0x44e)],_0x222bc2=this[_0x4c259c(0x2e8)+'gs']();_0x4ecec1[_0x4c259c(0x608)](),_0x4ecec1[_0x4c259c(0x54a)]=$gameSystem['numberFont'+_0x4c259c(0x1a2)](),_0x4ecec1[_0x4c259c(0x199)]=_0x222bc2[_0x4c259c(0x199)]??_0x5688b6['JvsBA']($gameSystem['mainFontSi'+'ze'](),-0x19f5+0x207+0x17f2),_0x4ecec1['outlineCol'+'or']=_0x5688b6[_0x4c259c(0x12f)],_0x4ecec1[_0x4c259c(0xf1)+'th']=_0x222bc2[_0x4c259c(0xf1)+'th']??-0x160e*-0x1+-0xce9+-0x921,_0x4ecec1[_0x4c259c(0x177)]=ColorManager[_0x4c259c(0x59c)](this[_0x4c259c(0x356)+'or']),_0x4ecec1[_0x4c259c(0x3b8)](this['_numberTex'+'t'],-0x5*-0xcd+0x96c+-0xd6d,0x209f*-0x1+-0x253d+0x22ee*0x2,-0x24f8+0x175c+0xe00,-0x37*0x5a+-0xc91+0x204b,_0x5688b6[_0x4c259c(0x4cf)]);},Sprite_DiceCheck[_0x5db7a1(0x4ce)][_0x5db7a1(0xbb)+_0x5db7a1(0x44a)]=function(_0x4abf9a){const _0x2641cb=_0x5db7a1;if(!Sprite_DiceCheck[_0x2641cb(0x444)][_0x2641cb(0xd2)+_0x2641cb(0x581)])return;this[_0x2641cb(0x356)+'or']=_0x4abf9a,this[_0x2641cb(0x1ea)]();},Sprite_DiceCheck[_0x5db7a1(0x4ce)][_0x5db7a1(0x2f8)+_0x5db7a1(0x581)]=function(_0x274d34,_0x267fed){const _0x46d9a6=_0x5db7a1,_0x57c68f={'SJcNt':function(_0x2df771,_0x6e977){return _0x2df771===_0x6e977;},'vCROA':function(_0x12fbdb,_0x42ae06){return _0x12fbdb-_0x42ae06;},'NnaVl':function(_0xcf928c,_0x470126){return _0xcf928c*_0x470126;}};_0x267fed&&(this[_0x46d9a6(0x539)+'ue']=0x1*-0x2a9+-0x3fe+0x6a8,this[_0x46d9a6(0x414)+'t']='1');if(_0x57c68f[_0x46d9a6(0x599)](this[_0x46d9a6(0x2c9)](),_0x274d34))return;const _0x15e6d8=Sprite_DiceCheck[_0x46d9a6(0x444)],_0x42abb8=Math['abs'](_0x57c68f[_0x46d9a6(0x205)](this['number'](),_0x274d34)),_0x1f428c=_0x15e6d8[_0x46d9a6(0x392)+_0x46d9a6(0x2a1)]||0xd4d+0xf7*-0x4+0x8*-0x12e,_0x214d34=_0x15e6d8[_0x46d9a6(0x5f4)+_0x46d9a6(0x5d2)]||-0x5*-0x1d3+-0x17*-0x12b+-0x23fb;this[_0x46d9a6(0x197)+_0x46d9a6(0x282)]=_0x274d34,this[_0x46d9a6(0x197)+'ftDuration']=_0x57c68f[_0x46d9a6(0x411)](_0x1f428c,_0x42abb8)['clamp'](0x382*0x1+-0x1*-0x86b+0x1b4*-0x7,_0x214d34);},Sprite_DiceCheck['prototype'][_0x5db7a1(0x2c9)]=function(){const _0x379858=_0x5db7a1;return Math[_0x379858(0x383)](this[_0x379858(0x539)+'ue']);},Sprite_DiceCheck[_0x5db7a1(0x4ce)][_0x5db7a1(0xef)+_0x5db7a1(0x51b)]=function(){const _0x483428=_0x5db7a1,_0x30497f={'CvBfb':function(_0x167236,_0x4b193b){return _0x167236>_0x4b193b;}};return _0x30497f['CvBfb'](this['_numberShi'+_0x483428(0x36d)],0x159f+0x81*0x3a+0x10f3*-0x3);},Sprite_DiceCheck[_0x5db7a1(0x4ce)][_0x5db7a1(0x42b)+'ity']=function(){const _0x3c3441=_0x5db7a1,_0xffa83c={'irawf':function(_0x59a06a,_0x124329){return _0x59a06a>_0x124329;},'Kruex':function(_0x3ef021,_0x380bba){return _0x3ef021<=_0x380bba;},'LJfrk':function(_0x3bf58e,_0xafc42e){return _0x3bf58e/_0xafc42e;},'nnPUx':function(_0x8c15ff,_0x196159){return _0x8c15ff+_0x196159;},'EKhaz':function(_0x431f73,_0x5ad7c1){return _0x431f73*_0x5ad7c1;},'VgfPC':function(_0x3d7a13,_0x52d516){return _0x3d7a13-_0x52d516;}};if(_0xffa83c['irawf'](this['_finalizeD'+_0x3c3441(0x5d2)],0x2459+-0x1ffb*-0x1+-0x4454))return this[_0x3c3441(0x310)+_0x3c3441(0x5d2)]--;if(_0xffa83c[_0x3c3441(0x313)](this[_0x3c3441(0x57c)+_0x3c3441(0x58a)],0xe2f+-0xdf8+-0x37))return;const _0x277cd8=this[_0x3c3441(0x57c)+_0x3c3441(0x58a)];this[_0x3c3441(0x415)]=_0xffa83c[_0x3c3441(0x320)](_0xffa83c[_0x3c3441(0xed)](_0xffa83c['EKhaz'](this[_0x3c3441(0x415)],_0xffa83c[_0x3c3441(0x464)](_0x277cd8,-0x4ca+-0x24d0+-0x1*-0x299b)),this[_0x3c3441(0x572)+'t']),_0x277cd8),this[_0x3c3441(0x57c)+_0x3c3441(0x58a)]--,_0xffa83c[_0x3c3441(0x313)](this[_0x3c3441(0x57c)+'ion'],-0x11a7+0x166*-0x8+-0x6b*-0x45)&&(this['opacity']=this[_0x3c3441(0x572)+'t']);},Sprite_DiceCheck[_0x5db7a1(0x4ce)][_0x5db7a1(0xd9)+'n']=function(){const _0x5cc094=_0x5db7a1,_0x31ce7e=Sprite_DiceCheck[_0x5cc094(0x444)];this[_0x5cc094(0x57c)+_0x5cc094(0x58a)]=_0x31ce7e[_0x5cc094(0x2f4)+_0x5cc094(0x2a1)],this[_0x5cc094(0x572)+'t']=0x37*-0x3f+-0x1*-0x10ab+-0x1*0x223;},Sprite_DiceCheck['prototype']['startFadeO'+'ut']=function(_0x3f3a69){const _0x571cf8=_0x5db7a1,_0xf0dba3=Sprite_DiceCheck[_0x571cf8(0x444)];this['_fadeDurat'+_0x571cf8(0x58a)]=_0xf0dba3['fadeOutDur'+_0x571cf8(0x5dc)],this[_0x571cf8(0x572)+'t']=0x1*0x2245+-0x3c4+-0x89*0x39,_0x3f3a69&&(this['_finalizeD'+_0x571cf8(0x5d2)]=_0xf0dba3[_0x571cf8(0x1d2)+_0x571cf8(0x2cd)]||-0xebb+0xd9c*0x1+0x2*0x90);},Sprite_DiceCheck[_0x5db7a1(0x4ce)][_0x5db7a1(0x574)+_0x5db7a1(0x420)]=function(){const _0xa10421=_0x5db7a1,_0x32e01e={'AQsnX':function(_0x2eaa09,_0x2f9cbf){return _0x2eaa09<=_0x2f9cbf;},'XWhdG':function(_0x362889,_0x5ed7c3){return _0x362889/_0x5ed7c3;},'WAAnn':function(_0x3e2b67,_0x336663){return _0x3e2b67+_0x336663;},'WcYFS':function(_0xeb6783,_0x536aed){return _0xeb6783*_0x536aed;},'PwBvn':function(_0x2b6e4a,_0x235805){return _0x2b6e4a-_0x235805;},'WMwkH':function(_0x487c86,_0xaea89c){return _0x487c86/_0xaea89c;},'kOrLu':function(_0x1f0933,_0x4d3250){return _0x1f0933*_0x4d3250;},'fuaGX':function(_0x184cc8,_0x2c7669){return _0x184cc8-_0x2c7669;}};if(this[_0xa10421(0x5d4)]())return;if(_0x32e01e[_0xa10421(0x456)](this[_0xa10421(0x42a)+_0xa10421(0x2a1)],0x25db+0xabd+-0x3098))return;const _0x1cf964=this[_0xa10421(0x42a)+_0xa10421(0x2a1)];this[_0xa10421(0x1c6)]['x']=_0x32e01e['XWhdG'](_0x32e01e[_0xa10421(0x4c4)](_0x32e01e[_0xa10421(0x251)](this[_0xa10421(0x1c6)]['x'],_0x32e01e[_0xa10421(0x1cd)](_0x1cf964,0x566*-0x4+-0x2590+0x3b29)),this[_0xa10421(0x3d5)+'et']),_0x1cf964),this['scale']['y']=_0x32e01e[_0xa10421(0x16b)](_0x32e01e[_0xa10421(0x4c4)](_0x32e01e[_0xa10421(0x4d3)](this['scale']['y'],_0x32e01e['fuaGX'](_0x1cf964,-0x17f0+-0x2626+0x3e17)),this[_0xa10421(0x3d5)+'et']),_0x1cf964),this[_0xa10421(0x42a)+_0xa10421(0x2a1)]--,_0x32e01e['AQsnX'](this['_scaleDura'+'tion'],0xb*0x17d+-0x162*0x2+-0xd9b)&&(this[_0xa10421(0x1c6)]['x']=this[_0xa10421(0x3d5)+'et'],this[_0xa10421(0x1c6)]['y']=this[_0xa10421(0x3d5)+'et']);},Sprite_DiceCheck[_0x5db7a1(0x4ce)][_0x5db7a1(0x451)+_0x5db7a1(0x4ba)]=function(_0x38ad36){const _0x2615d2=_0x5db7a1,_0x110d52={'uahMD':function(_0x30f90b,_0xba509f){return _0x30f90b===_0xba509f;},'tqDoT':function(_0x206159,_0x58bb77){return _0x206159===_0x58bb77;}};if(_0x110d52['uahMD'](this[_0x2615d2(0x1c6)]['x'],_0x38ad36)&&_0x110d52[_0x2615d2(0x104)](this[_0x2615d2(0x1c6)]['y'],_0x38ad36))return;this[_0x2615d2(0x3d5)+'et']=_0x38ad36,this['_scaleDura'+_0x2615d2(0x2a1)]=Sprite_DiceCheck[_0x2615d2(0x444)][_0x2615d2(0x348)+'ion']||0x1a1d*0x1+0x1b0*0x13+0x22*-0x1b6;},Sprite_DiceCheck[_0x5db7a1(0x4ce)][_0x5db7a1(0x473)+_0x5db7a1(0x120)]=function(){const _0x10b4c6=_0x5db7a1,_0x502402={'gvrmM':function(_0x8d23ab,_0x28b897){return _0x8d23ab>_0x28b897;}};return _0x502402[_0x10b4c6(0x471)](this[_0x10b4c6(0x42a)+'tion'],0x2*0x2+0x7b9+-0x7bd);},Sprite_DiceCheck['prototype'][_0x5db7a1(0x3f9)+'Effect']=function(){const _0x286acc=_0x5db7a1,_0x5055c7={'jJwBu':function(_0x295d37,_0x140ac7){return _0x295d37===_0x140ac7;},'kPgot':function(_0x3addc9,_0x2961e8){return _0x3addc9!==_0x2961e8;},'LtlYP':function(_0xd7f353,_0x80df05){return _0xd7f353+_0x80df05;}};if(!this[_0x286acc(0x387)+'r'])return;if(_0x5055c7[_0x286acc(0x50e)](this['y'],this[_0x286acc(0x275)])){if(_0x5055c7['kPgot'](this[_0x286acc(0x387)+'r'][_0x286acc(0x35d)],0x3*0x569+0x1148+-0x2183))this[_0x286acc(0x387)+'r'][_0x286acc(0x35d)]=-0x12d3+-0xb2*0x2a+-0x3007*-0x1;return;}this[_0x286acc(0x387)+'r'][_0x286acc(0x35d)]=Math[_0x286acc(0x1fb)](_0x5055c7[_0x286acc(0x4eb)](this['_blurFilte'+'r']['blur'],-0x21cf+-0x1c8b+0x3e5a+0.2),-0x18e+-0xfad+0x113d);};function Window_DiceText(){const _0xaf8822=_0x5db7a1;this[_0xaf8822(0x244)](...arguments);}Window_DiceText[_0x5db7a1(0x4ce)]=Object[_0x5db7a1(0x467)](Window_Base[_0x5db7a1(0x4ce)]),Window_DiceText[_0x5db7a1(0x4ce)][_0x5db7a1(0xeb)+'r']=Window_DiceText,Window_DiceText[_0x5db7a1(0x4ce)]['initialize']=function(_0x29b5cf){const _0xa6d193=_0x5db7a1;Window_Base[_0xa6d193(0x4ce)][_0xa6d193(0x244)][_0xa6d193(0x23f)](this,_0x29b5cf),this['openness']=-0x2099+0x3*0x4b8+0x1271,this['open']();},Window_DiceText[_0x5db7a1(0x4ce)]['drawCenter'+_0x5db7a1(0x2b7)]=function(_0x18d06f,_0x400697,_0x3e3b44){const _0x1664e7=_0x5db7a1,_0x61281c={'OQWPi':function(_0x50cecb,_0x4fe370){return _0x50cecb||_0x4fe370;},'tHYGN':function(_0xa4ef1d,_0x13155f){return _0xa4ef1d+_0x13155f;},'eTSVg':function(_0x5de134,_0xef6413){return _0x5de134/_0xef6413;},'rVETL':function(_0xec5594,_0x4575bf){return _0xec5594-_0x4575bf;},'VftzT':function(_0x23b097,_0x244ceb){return _0x23b097/_0x244ceb;}};_0x400697=_0x61281c[_0x1664e7(0x27f)](_0x400697,-0x1*0xa57+0x1c3f*-0x1+-0x2696*-0x1),_0x3e3b44=_0x61281c[_0x1664e7(0x27f)](_0x3e3b44,0x17d*-0x15+0x454+0x1*0x1aed),this['contents']['clear']();const _0xa43822=this[_0x1664e7(0x511)](_0x18d06f),_0x4041d6=_0x61281c[_0x1664e7(0x10e)](Math['round'](_0x61281c[_0x1664e7(0x264)](_0x61281c[_0x1664e7(0x33e)](this['innerWidth'],_0xa43822['width']),-0x5cf*-0x3+-0xe62+0x309*-0x1)),_0x400697),_0x114d43=_0x61281c[_0x1664e7(0x10e)](Math[_0x1664e7(0x383)](_0x61281c[_0x1664e7(0x560)](_0x61281c[_0x1664e7(0x33e)](this['innerHeigh'+'t'],_0xa43822['height']),-0x38f*-0x3+-0x15a*-0x1c+-0x3083*0x1)),_0x3e3b44);this[_0x1664e7(0x423)](_0x18d06f,_0x4041d6,_0x114d43);};function Window_DiceData(){const _0x5b00ed=_0x5db7a1;this[_0x5b00ed(0x244)](...arguments);}Window_DiceData[_0x5db7a1(0x4ce)]=Object['create'](Window_Base[_0x5db7a1(0x4ce)]),Window_DiceData[_0x5db7a1(0x4ce)]['constructo'+'r']=Window_DiceData,Window_DiceData[_0x5db7a1(0x4ce)][_0x5db7a1(0x244)]=function(_0x4479f3){const _0x10c3c5=_0x5db7a1;Window_Base[_0x10c3c5(0x4ce)][_0x10c3c5(0x244)][_0x10c3c5(0x23f)](this,_0x4479f3),this[_0x10c3c5(0x5a6)]=-0x409*-0x1+-0xae5*-0x1+0x15*-0xb6,this[_0x10c3c5(0x2f3)]();},Window_DiceData[_0x5db7a1(0x4ce)][_0x5db7a1(0x2e8)+'gs']=function(){const _0x4be769=_0x5db7a1;return SceneManager[_0x4be769(0x2aa)+_0x4be769(0x2d2)]||{};},Window_DiceData[_0x5db7a1(0x4ce)][_0x5db7a1(0x3dc)+'e']=function(_0x56cca6){const _0x5f187b=_0x5db7a1;this[_0x5f187b(0x3eb)]=_0x56cca6,this[_0x5f187b(0x21e)]();},Window_DiceData[_0x5db7a1(0x4ce)]['update']=function(){const _0xa6ecea=_0x5db7a1;Window_Base[_0xa6ecea(0x4ce)][_0xa6ecea(0x526)][_0xa6ecea(0x23f)](this),this[_0xa6ecea(0x51c)+'sh']()&&(this[_0xa6ecea(0x3c5)](),this[_0xa6ecea(0x21e)]());},Window_DiceData['prototype']['needsRefre'+'sh']=function(){const _0x4eb836=_0x5db7a1,_0x59fce1={'yPRNK':_0x4eb836(0x17a),'OVrcv':function(_0x5175fd,_0x31c2ae){return _0x5175fd!==_0x31c2ae;},'GcrSH':'rank','MfUgf':_0x4eb836(0x26c),'riNBy':function(_0x5b1195,_0x2b12d1){return _0x5b1195!==_0x2b12d1;}},_0x186bf8=this[_0x4eb836(0x2e8)+'gs']();switch(this[_0x4eb836(0x3eb)]){case _0x59fce1[_0x4eb836(0x462)]:return _0x59fce1[_0x4eb836(0x232)](this['_lastAdvan'+_0x4eb836(0x4c0)],_0x186bf8['advantage']||0x2*-0x687+-0x5*0x5db+0x2a55);case _0x59fce1[_0x4eb836(0x5a7)]:return _0x59fce1['OVrcv'](this[_0x4eb836(0x29f)],_0x186bf8[_0x4eb836(0x564)]||-0x2293+-0x2ed+-0x50*-0x78);case _0x59fce1[_0x4eb836(0x3a9)]:return _0x59fce1[_0x4eb836(0x232)](this[_0x4eb836(0xcf)+'ier'],_0x186bf8['modifiers']||-0x144d*-0x1+-0x1*-0x1ced+0x313a*-0x1)||_0x59fce1[_0x4eb836(0x5d1)](this[_0x4eb836(0x453)+'nd'],_0x186bf8[_0x4eb836(0x1ca)]||0x455+0xbc7+0x1*-0x101c);}return![];},Window_DiceData[_0x5db7a1(0x4ce)][_0x5db7a1(0x3c5)]=function(){const _0x481663=_0x5db7a1,_0xe28949={'HxLdI':'advantage','nNAFj':_0x481663(0x2f2),'wuaZG':_0x481663(0x26c)},_0x272150=this['diceSettin'+'gs']();switch(this['_dataType']){case _0xe28949[_0x481663(0xcc)]:this[_0x481663(0x32f)+_0x481663(0x4c0)]=_0x272150[_0x481663(0x17a)]||0xf4*-0x16+0x98c+0x44*0x2b;break;case _0xe28949[_0x481663(0xf4)]:this['_lastRank']=_0x272150[_0x481663(0x564)]||0x1219+0x4*-0x3eb+-0x1*0x26d;break;case _0xe28949[_0x481663(0x602)]:this[_0x481663(0xcf)+_0x481663(0x51e)]=_0x272150[_0x481663(0x55c)]||0x89*0x44+-0x4d+-0x2417,this[_0x481663(0x453)+'nd']=_0x272150[_0x481663(0x1ca)]||-0x1282+-0x554+0x12*0x153;break;}},Window_DiceData[_0x5db7a1(0x4ce)][_0x5db7a1(0x21e)]=function(){const _0x438a5a=_0x5db7a1;this[_0x438a5a(0x191)][_0x438a5a(0x608)](),this[_0x438a5a(0x3c5)](),this[_0x438a5a(0x20c)+_0x438a5a(0x30a)](),this['drawDataTe'+'xt']();},Window_DiceData[_0x5db7a1(0x4ce)][_0x5db7a1(0x20c)+_0x5db7a1(0x30a)]=function(){const _0x16e07f=_0x5db7a1,_0x450de1={'nYotB':function(_0x2d251f,_0x2b47ba){return _0x2d251f===_0x2b47ba;},'AMsag':_0x16e07f(0x17a),'upNtU':function(_0x12585a,_0x118a5e){return _0x12585a===_0x118a5e;},'vmcZZ':'rollValue','tkjHB':function(_0x24f0a5,_0x4ab95c){return _0x24f0a5===_0x4ab95c;},'egyLS':_0x16e07f(0x4a2),'eCfMT':function(_0x40acbd,_0x3b931f){return _0x40acbd>_0x3b931f;},'kJfJn':function(_0x494f7b,_0x2e48d5){return _0x494f7b<_0x2e48d5;},'uDdFH':_0x16e07f(0xcd)+'ge'},_0x3d2698=TextManager[_0x16e07f(0x28a)][_0x16e07f(0x591)];let _0x5c6a69=this[_0x16e07f(0x3eb)];if(_0x450de1[_0x16e07f(0x1b2)](_0x5c6a69,_0x450de1['AMsag'])){const _0x333217=this[_0x16e07f(0x2e8)+'gs']();if(_0x450de1[_0x16e07f(0x23d)](_0x333217['type'],_0x450de1[_0x16e07f(0x125)])||_0x450de1[_0x16e07f(0x4ed)](_0x333217[_0x16e07f(0x17a)],-0x454+-0x1e29+-0x227d*-0x1))_0x5c6a69=_0x450de1[_0x16e07f(0x47e)];else{if(_0x450de1[_0x16e07f(0x588)](_0x333217[_0x16e07f(0x17a)],-0x1f84+0x1526+0xa5e))_0x5c6a69=_0x450de1[_0x16e07f(0x1c1)];else _0x450de1[_0x16e07f(0x322)](_0x333217[_0x16e07f(0x17a)],0x156c+-0x258e+-0x46*-0x3b)&&(_0x5c6a69=_0x450de1['uDdFH']);}}const _0x44077a=_0x3d2698[_0x5c6a69];this[_0x16e07f(0x423)](_0x44077a,this[_0x16e07f(0x4c7)+'g'](),0x2*0x496+0x9b3*0x2+-0x1c92);},Window_DiceData[_0x5db7a1(0x4ce)][_0x5db7a1(0x5fb)+'xt']=function(){const _0x289fa2=_0x5db7a1,_0xd8bd2c={'uKDyJ':_0x289fa2(0x17a),'PSJiH':function(_0x5e5a57,_0x9c4545){return _0x5e5a57===_0x9c4545;},'SUsco':_0x289fa2(0x20e),'ffoRZ':function(_0x5c58ee,_0x146bf4){return _0x5c58ee-_0x146bf4;},'iFodR':function(_0x262381,_0x4c6bdc){return _0x262381+_0x4c6bdc;},'CdRnP':_0x289fa2(0x2f2),'mTgoh':_0x289fa2(0x5a5),'UTzvI':_0x289fa2(0x26c),'uWCBk':function(_0x20a86f,_0x59c631){return _0x20a86f+_0x59c631;},'SKaks':function(_0xbf65fe,_0x1f04ae){return _0xbf65fe(_0x1f04ae);},'hLlDI':function(_0x4431ca,_0x4474e4){return _0x4431ca||_0x4474e4;},'EiKeL':function(_0x74abd6,_0x218850){return _0x74abd6>_0x218850;},'zHkGr':function(_0x68b75f,_0x138cd0){return _0x68b75f(_0x138cd0);},'PtEBo':function(_0x499e50,_0x461fcb){return _0x499e50>=_0x461fcb;},'QpGTp':function(_0x13921c,_0x5113a6){return _0x13921c!==_0x5113a6;},'yVAxW':function(_0x38f3e0,_0x2790cc){return _0x38f3e0>_0x2790cc;},'EMdrm':_0x289fa2(0x3bd)},_0x391536=this[_0x289fa2(0x2e8)+'gs'](),_0x57b3da=TextManager[_0x289fa2(0x28a)][_0x289fa2(0x2f1)][_0x289fa2(0x34b)];let _0x2dc1f9='';switch(this[_0x289fa2(0x3eb)]){case _0xd8bd2c[_0x289fa2(0x522)]:if(_0xd8bd2c[_0x289fa2(0x412)](_0x391536[_0x289fa2(0x233)],_0xd8bd2c['SUsco']))_0x2dc1f9=VisuMZ[_0x289fa2(0x50f)+'ngSeeds'][_0x289fa2(0x274)+_0x289fa2(0xc8)]();else{_0x2dc1f9=Math[_0x289fa2(0x553)](this['_lastAdvan'+'tage'])[_0x289fa2(0x28f)](0x5bd*0x1+0x1fcb+0x962*-0x4,_0xd8bd2c[_0x289fa2(0xf2)](VisuMZ[_0x289fa2(0x50f)+_0x289fa2(0x20a)][_0x289fa2(0x2d9)],0x1b7e+-0x4*-0x1f2+-0x2345));if(_0x57b3da)_0x2dc1f9=_0xd8bd2c[_0x289fa2(0x1a8)]('+',_0x2dc1f9);}break;case _0xd8bd2c[_0x289fa2(0x2b8)]:const _0x1d4f9b=VisuMZ[_0x289fa2(0x50f)+_0x289fa2(0x20a)][_0x289fa2(0x242)+_0x289fa2(0x533)](),_0x20025d=_0xd8bd2c['mTgoh'][_0x289fa2(0x13e)](_0x1d4f9b);_0x2dc1f9=TextManager[_0x289fa2(0x28a)][_0x289fa2(0x591)][_0x20025d];break;case _0xd8bd2c[_0x289fa2(0x5cd)]:const _0x458768=this['_lastModif'+_0x289fa2(0x51e)]||0x1*0x1ec1+0x1ceb+-0x3bac,_0x5b8ec4=_0xd8bd2c[_0x289fa2(0xc4)](_0x458768,this['_lastModRa'+'nd']||-0xaf6+0xef*0x23+-0x15b7),_0x359274=Math[_0x289fa2(0x1fb)](_0x458768,_0x5b8ec4),_0x38ff21=Math[_0x289fa2(0x508)](_0x458768,_0x5b8ec4);_0x2dc1f9=_0xd8bd2c['SKaks'](String,_0xd8bd2c[_0x289fa2(0x353)](_0x359274,0x65b*0x1+-0x2565*0x1+0x1f0a));_0xd8bd2c[_0x289fa2(0x402)](Math['abs'](_0x359274),Math[_0x289fa2(0x553)](_0x38ff21))&&(_0x2dc1f9=_0xd8bd2c[_0x289fa2(0x3ed)](String,_0xd8bd2c['hLlDI'](_0x38ff21,-0x4*0x28f+0x7*0x229+-0x3*0x1a1)));if(_0x57b3da&&_0xd8bd2c['PtEBo'](_0x359274,-0x10c3*-0x1+-0x1e6*0x12+-0x1169*-0x1))_0x2dc1f9=_0xd8bd2c[_0x289fa2(0x1a8)]('+',_0x2dc1f9);_0xd8bd2c[_0x289fa2(0x187)](_0x38ff21,_0x359274)&&(_0xd8bd2c[_0x289fa2(0x227)](Math[_0x289fa2(0x553)](_0x359274),Math[_0x289fa2(0x553)](_0x38ff21))?_0x2dc1f9=_0xd8bd2c[_0x289fa2(0x4d8)][_0x289fa2(0x13e)](_0x2dc1f9,_0x359274):_0x2dc1f9=_0xd8bd2c[_0x289fa2(0x4d8)]['format'](_0x2dc1f9,_0x38ff21));break;}_0x2dc1f9=_0xd8bd2c[_0x289fa2(0x3ed)](String,_0x2dc1f9);const _0x33556c=this[_0x289fa2(0x511)](_0x2dc1f9)[_0x289fa2(0x118)],_0x288a33=_0xd8bd2c[_0x289fa2(0xf2)](_0xd8bd2c[_0x289fa2(0xf2)](this[_0x289fa2(0x180)],_0x33556c),this['itemPaddin'+'g']());this['drawTextEx'](_0x2dc1f9,_0x288a33,0x3*0x5b9+-0x2*0xeb5+-0x1*-0xc3f);};function Window_DiceSprite(){this['initialize'](...arguments);}Window_DiceSprite[_0x5db7a1(0x4ce)]=Object['create'](Window_Base[_0x5db7a1(0x4ce)]),Window_DiceSprite[_0x5db7a1(0x4ce)][_0x5db7a1(0xeb)+'r']=Window_DiceSprite,Window_DiceSprite[_0x5db7a1(0x4ce)][_0x5db7a1(0x244)]=function(_0x2270c0){const _0x236fd0=_0x5db7a1;Window_Base[_0x236fd0(0x4ce)][_0x236fd0(0x244)][_0x236fd0(0x23f)](this,_0x2270c0),this[_0x236fd0(0x454)+'s'](),this[_0x236fd0(0x31f)+'teContaine'+'rs']();},Window_DiceSprite['prototype'][_0x5db7a1(0x454)+'s']=function(){const _0x262a72=_0x5db7a1,_0x516b58={'XCeap':_0x262a72(0x4d1)};this[_0x262a72(0x369)]=_0x516b58[_0x262a72(0x5d5)],this[_0x262a72(0x310)+_0x262a72(0x5d2)]=0x6*-0x20e+-0x1*0x6b6+0x130a,this[_0x262a72(0x283)+_0x262a72(0x3a3)]();},Window_DiceSprite[_0x5db7a1(0x4ce)]['updateCach'+'eInfo']=function(){const _0x3ed492=_0x5db7a1;this[_0x3ed492(0xc7)]=VisuMZ['DiceRollsR'+_0x3ed492(0x20a)][_0x3ed492(0x242)+_0x3ed492(0x4f5)]();},Window_DiceSprite[_0x5db7a1(0x4ce)][_0x5db7a1(0x31f)+_0x5db7a1(0x4ad)+'rs']=function(){const _0x2f7c54=_0x5db7a1,_0x292795={'PTfji':_0x2f7c54(0x13c)+'2','piPOa':function(_0x3cc0e4,_0x32faba){return _0x3cc0e4-_0x32faba;},'KyfLU':function(_0x4513d5,_0x56f128){return _0x4513d5-_0x56f128;}},_0x418eb0=_0x292795[_0x2f7c54(0x556)]['split']('|');let _0x113f6c=0x596*0x4+0x5fd+-0x1c55;while(!![]){switch(_0x418eb0[_0x113f6c++]){case'0':this['addChildTo'+_0x2f7c54(0x463)](this[_0x2f7c54(0x550)+_0x2f7c54(0x389)]);continue;case'1':this[_0x2f7c54(0x550)+'iner']['x']=this['_subContai'+_0x2f7c54(0x4dd)]['x']=-0x1e43+0x133b*-0x2+0xf1*0x49;continue;case'2':this[_0x2f7c54(0x550)+_0x2f7c54(0x389)]['y']=this[_0x2f7c54(0x326)+_0x2f7c54(0x4dd)]['y']=_0x292795[_0x2f7c54(0x4d9)](_0x292795[_0x2f7c54(0x4db)](this['height'],0x1*-0x195b+0x2320+-0x97d),this['lineHeight']());continue;case'3':this[_0x2f7c54(0x209)+_0x2f7c54(0x463)](this[_0x2f7c54(0x326)+'ner']);continue;case'4':this[_0x2f7c54(0x550)+_0x2f7c54(0x389)]=new Sprite();continue;case'5':this[_0x2f7c54(0x326)+_0x2f7c54(0x4dd)]=new Sprite();continue;}break;}},Window_DiceSprite[_0x5db7a1(0x4ce)]['isAnyDiceV'+_0x5db7a1(0x306)]=function(){const _0x50a0b7=_0x5db7a1,_0x4d8a0f={'pjEju':function(_0x4b9383,_0x52ae20){return _0x4b9383>_0x52ae20;}};if(this['_mainConta'+_0x50a0b7(0x389)]&&_0x4d8a0f['pjEju'](this[_0x50a0b7(0x550)+_0x50a0b7(0x389)]['children'][_0x50a0b7(0x5de)],0x107*-0x7+-0x954*0x2+0x19d9))return!![];if(this[_0x50a0b7(0x326)+_0x50a0b7(0x4dd)]&&_0x4d8a0f[_0x50a0b7(0x4bd)](this['_subContai'+_0x50a0b7(0x4dd)]['children'][_0x50a0b7(0x5de)],0x17*0x10d+-0x2ad*0xb+0x544))return!![];return![];},Window_DiceSprite['prototype'][_0x5db7a1(0x526)]=function(){const _0x31cd39=_0x5db7a1,_0x2ce06c={'pItBH':_0x31cd39(0x5cf)+'0'},_0x1736e4=_0x2ce06c[_0x31cd39(0x193)][_0x31cd39(0x293)]('|');let _0x284719=-0x1*0x609+-0xc5a+0x1263;while(!![]){switch(_0x1736e4[_0x284719++]){case'0':this[_0x31cd39(0x45d)+_0x31cd39(0x1f3)]();continue;case'1':Window_Base[_0x31cd39(0x4ce)]['update'][_0x31cd39(0x23f)](this);continue;case'2':this[_0x31cd39(0x297)+_0x31cd39(0x1db)]()&&(this[_0x31cd39(0x290)+'ice'](),this['updateCach'+_0x31cd39(0x3a3)](),this[_0x31cd39(0x2b4)+_0x31cd39(0x38b)]());continue;case'3':this[_0x31cd39(0x562)+'e']();continue;case'4':if(!this[_0x31cd39(0x550)+_0x31cd39(0x389)])return;continue;case'5':if(!this[_0x31cd39(0x326)+_0x31cd39(0x4dd)])return;continue;}break;}},Window_DiceSprite[_0x5db7a1(0x4ce)][_0x5db7a1(0x304)+_0x5db7a1(0x24d)]=function(){const _0x3f3df0=_0x5db7a1,_0x80d87=this[_0x3f3df0(0x550)+_0x3f3df0(0x389)]['children'];return _0x80d87['some'](_0x2ad4e8=>_0x2ad4e8['isAnimatin'+'g']());},Window_DiceSprite['prototype']['updatePhas'+'e']=function(){const _0x6e950=_0x5db7a1,_0x189064={'YFYGc':_0x6e950(0x4d1),'TVrHQ':_0x6e950(0x291),'qfjLw':_0x6e950(0x1f1),'DyuqI':_0x6e950(0x138),'WTHVs':_0x6e950(0x55c),'rGCjp':_0x6e950(0x2ce),'adQnj':_0x6e950(0x5ee)};if([_0x189064[_0x6e950(0x434)],_0x189064[_0x6e950(0x5d3)],_0x189064[_0x6e950(0x4bf)]]['includes'](this[_0x6e950(0x369)]))return;if(this[_0x6e950(0x304)+_0x6e950(0x24d)]())return;switch(this[_0x6e950(0x369)]){case _0x189064[_0x6e950(0x4f9)]:this[_0x6e950(0x15e)+_0x6e950(0x14f)]();break;case _0x189064['WTHVs']:this[_0x6e950(0x141)+_0x6e950(0x4e8)]();break;case _0x189064[_0x6e950(0x44b)]:this[_0x6e950(0x32b)+_0x6e950(0x3c9)]();break;case _0x189064[_0x6e950(0x549)]:this[_0x6e950(0x110)+_0x6e950(0x55b)]();break;}},Window_DiceSprite[_0x5db7a1(0x4ce)]['startDiceR'+'oll']=function(){const _0x23efd1=_0x5db7a1,_0x5207f2={'cnuoj':_0x23efd1(0x138)};this[_0x23efd1(0x369)]=_0x5207f2[_0x23efd1(0x48f)];const _0x53f2e6=this[_0x23efd1(0x550)+_0x23efd1(0x389)][_0x23efd1(0x4a6)][_0x23efd1(0x175)]();VisuMZ[_0x23efd1(0x50f)+_0x23efd1(0x20a)]['ShuffleArr'+'ay'](_0x53f2e6);let _0x4acb27=0x1335+0x58f*0x1+-0x27a*0xa;for(const _0x28b324 of _0x53f2e6){_0x28b324[_0x23efd1(0x342)+_0x23efd1(0xc0)](_0x4acb27),_0x4acb27++;}},VisuMZ['DiceRollsR'+_0x5db7a1(0x20a)][_0x5db7a1(0x3a4)+'ay']=function(_0xaaffbe){const _0x23f0e9=_0x5db7a1,_0x10d8cc={'yTIFR':function(_0x1b3e2e,_0x7154bb){return _0x1b3e2e-_0x7154bb;},'BvhbO':function(_0x151020,_0x46d56e){return _0x151020>_0x46d56e;},'GGuUV':function(_0x438d41,_0x209d93){return _0x438d41*_0x209d93;},'hbsdM':function(_0x24d3df,_0x52e851){return _0x24d3df+_0x52e851;}};var _0x36fa53,_0x4e43ca,_0x168132;for(_0x168132=_0x10d8cc[_0x23f0e9(0x566)](_0xaaffbe[_0x23f0e9(0x5de)],-0x3d6*0x1+0x25*0x3d+-0x5b*0xe);_0x10d8cc['BvhbO'](_0x168132,-0x1cac+0x20e4+-0x438);_0x168132--){_0x36fa53=Math[_0x23f0e9(0x19f)](_0x10d8cc['GGuUV'](Math[_0x23f0e9(0x541)](),_0x10d8cc[_0x23f0e9(0xfa)](_0x168132,-0x1f81+-0x10af+0xd*0x3b5))),_0x4e43ca=_0xaaffbe[_0x168132],_0xaaffbe[_0x168132]=_0xaaffbe[_0x36fa53],_0xaaffbe[_0x36fa53]=_0x4e43ca;}return _0xaaffbe;},Window_DiceSprite['prototype'][_0x5db7a1(0x15e)+'ngPhase']=function(){const _0x44c5c1=_0x5db7a1;this[_0x44c5c1(0x5af)+_0x44c5c1(0x46f)](),this[_0x44c5c1(0x502)+_0x44c5c1(0x1aa)]();},Window_DiceSprite['prototype']['processRol'+_0x5db7a1(0x46f)]=function(){const _0x5125f3=_0x5db7a1,_0x38ab66={'hRUCZ':function(_0x32fcb9,_0x3073dc){return _0x32fcb9/_0x3073dc;},'hLDdJ':'total','UnLTg':_0x5125f3(0xf7),'ETSWP':function(_0x1f6e6f,_0x4b0805){return _0x1f6e6f===_0x4b0805;},'NlVSf':_0x5125f3(0x5bf),'aVkNA':_0x5125f3(0x5c2),'jaesb':function(_0x370365,_0x3fa44a){return _0x370365===_0x3fa44a;},'HyiCV':_0x5125f3(0x450)+'e','QcZNS':function(_0x435ee6,_0x2d50e6){return _0x435ee6>=_0x2d50e6;},'wQDYv':_0x5125f3(0x1d5)+'t','epDmR':_0x5125f3(0x39f)+_0x5125f3(0xd7)},_0x42357b=SceneManager[_0x5125f3(0x2aa)+_0x5125f3(0x2d2)]||{},_0x524e1f=_0x42357b['ResultType']||'',_0x219e0c=Math[_0x5125f3(0x383)](_0x38ab66[_0x5125f3(0x3ea)](this[_0x5125f3(0x118)],0x405*0x1+-0xb3e+-0x269*-0x3)),_0xf01e49=this[_0x5125f3(0x550)+_0x5125f3(0x389)][_0x5125f3(0x4a6)],_0x9b5941=_0xf01e49[_0x5125f3(0x3fc)](_0x41c62a=>_0x41c62a[_0x5125f3(0x2c9)]());let _0x10d7b2=null;if([_0x38ab66['hLDdJ'],_0x38ab66['UnLTg']][_0x5125f3(0x135)](_0x524e1f)){_0x10d7b2=_0xf01e49[Math['randomInt'](_0xf01e49[_0x5125f3(0x5de)])];for(const _0x5db172 of _0xf01e49){_0x5db172[_0x5125f3(0x211)+'oX'](_0x219e0c);if(_0x38ab66['ETSWP'](_0x5db172,_0x10d7b2)){let _0x204eb8=_0x9b5941['reduce']((_0x5c3e2f,_0x5b94da)=>_0x5c3e2f+_0x5b94da,-0x1*0x17f5+0x417+0x9ef*0x2);_0x38ab66['ETSWP'](_0x524e1f,_0x38ab66[_0x5125f3(0x4fd)])&&(_0x204eb8=Math[_0x5125f3(0x383)](_0x38ab66[_0x5125f3(0x3ea)](_0x204eb8,_0x9b5941[_0x5125f3(0x5de)]))),_0x5db172[_0x5125f3(0x2f8)+_0x5125f3(0x581)](_0x204eb8,!![]);}else _0x5db172[_0x5125f3(0x19b)+'ut']();}}else{if([_0x38ab66[_0x5125f3(0x29a)],_0x38ab66[_0x5125f3(0x14b)]][_0x5125f3(0x135)](_0x524e1f)){const _0x3b7653=_0x38ab66['ETSWP'](_0x524e1f,_0x38ab66['NlVSf'])?Math[_0x5125f3(0x508)](..._0x9b5941):Math['min'](..._0x9b5941),_0x93c712=_0x9b5941[_0x5125f3(0x470)](_0x3b7653);_0x10d7b2=_0xf01e49[_0x93c712];}else{if(_0x38ab66['jaesb'](_0x42357b[_0x5125f3(0x233)],_0x38ab66[_0x5125f3(0x2b6)])){const _0x40dd89=_0x38ab66[_0x5125f3(0x54c)](_0x42357b[_0x5125f3(0x17a)],-0x1cd7+-0x187e+0x14d*0x29);let _0x10648d=-0x315+-0x36b*-0x3+0x72c*-0x1;[_0x38ab66[_0x5125f3(0x593)],_0x38ab66[_0x5125f3(0x2fe)]][_0x5125f3(0x135)](_0x524e1f)?_0x10648d=_0x40dd89?Math[_0x5125f3(0x508)](..._0x9b5941):Math['min'](..._0x9b5941):_0x10648d=_0x40dd89?Math['min'](..._0x9b5941):Math[_0x5125f3(0x508)](..._0x9b5941);if(this[_0x5125f3(0x5fc)+_0x5125f3(0x2a6)]()){const _0x2c337a=VisuMZ[_0x5125f3(0x50f)+'ngSeeds']['CurrentDic'+_0x5125f3(0x4f5)]();if(_0x38ab66[_0x5125f3(0x3b5)](_0x10648d,-0x1*0x67+0x1*0x1ca5+0x1*-0x1c3d))this['_naturalRo'+'ll']=!![];else _0x38ab66[_0x5125f3(0x3b5)](_0x10648d,_0x2c337a)&&(this[_0x5125f3(0x237)+'ll']=!![]);}const _0x3595fc=_0x9b5941[_0x5125f3(0x470)](_0x10648d);_0x10d7b2=_0xf01e49[_0x3595fc];}}}_0x10d7b2&&(_0x10d7b2[_0x5125f3(0x211)+'oX'](_0x219e0c),_0x10d7b2[_0x5125f3(0x451)+_0x5125f3(0x4ba)](-0x209d+-0x21*0x1e+0x247c),this['moveSprite'+'ToSubConta'+_0x5125f3(0x1d1)](_0x10d7b2));},Window_DiceSprite[_0x5db7a1(0x4ce)]['endRolling'+_0x5db7a1(0x1aa)]=function(){const _0x5d8f42=_0x5db7a1,_0x54b095={'ZOGKw':_0x5d8f42(0x55c),'DxPga':function(_0x3e755b,_0x2ae1fb){return _0x3e755b===_0x2ae1fb;},'VYYSU':function(_0x19cc5d,_0x162123){return _0x19cc5d===_0x162123;}};this[_0x5d8f42(0x369)]=_0x54b095[_0x5d8f42(0x2ba)],this[_0x5d8f42(0x4e2)+_0x5d8f42(0x2cd)]=0x1b66+0x1c9f+-0x3805;if(this[_0x5d8f42(0x237)+'ll'])return;const _0x7db546=SceneManager['_diceRollS'+_0x5d8f42(0x2d2)]||{};if(_0x54b095[_0x5d8f42(0x2e1)](_0x7db546[_0x5d8f42(0x55c)],0x8c+0x1f59+-0x1*0x1fe5)&&_0x54b095[_0x5d8f42(0x404)](_0x7db546[_0x5d8f42(0x1ca)],0x1c7b+-0x1c19*0x1+0x2*-0x31))return;this[_0x5d8f42(0x4e2)+'lay']+=Sprite_DiceCheck[_0x5d8f42(0x444)][_0x5d8f42(0x381)+'ay']||0x7*-0x7f+-0xc0*0x9+-0x7*-0x176;},Window_DiceSprite['prototype'][_0x5db7a1(0x141)+_0x5db7a1(0x4e8)]=function(){const _0x38a7cb=_0x5db7a1,_0x3a5291={'bXJQW':function(_0x15843a,_0x579e7b){return _0x15843a>_0x579e7b;}};if(_0x3a5291[_0x38a7cb(0x184)](this[_0x38a7cb(0x4e2)+'lay'],-0x197*0x18+0x243f+-0x1e9*-0x1))return this[_0x38a7cb(0x4e2)+_0x38a7cb(0x2cd)]--;this[_0x38a7cb(0xd5)+_0x38a7cb(0x18b)+'e'](),this[_0x38a7cb(0x4e0)+_0x38a7cb(0x5b1)]();},Window_DiceSprite[_0x5db7a1(0x4ce)][_0x5db7a1(0xd5)+'ifiersPhas'+'e']=function(){const _0x2d1b3b=_0x5db7a1,_0x4620b8={'TdsdF':function(_0x4ca69c,_0x59496c){return _0x4ca69c===_0x59496c;},'eGUFo':_0x2d1b3b(0x1d5)+'t','qeTPf':_0x2d1b3b(0x39f)+_0x2d1b3b(0xd7),'LfAFC':function(_0x170b23,_0x418903){return _0x170b23===_0x418903;},'KQSak':function(_0x19ac60,_0x4962f2){return _0x19ac60+_0x4962f2;},'Mlgjz':function(_0x15661f,_0x42f251){return _0x15661f+_0x42f251;},'SOHRB':function(_0x49f99c,_0x321e32){return _0x49f99c!==_0x321e32;},'rnVOl':'none','Zwbxl':function(_0x4693a1,_0x754018){return _0x4693a1+_0x754018;},'Fuudm':function(_0x34274c,_0x4247dd){return _0x34274c+_0x4247dd;},'hSQYm':function(_0x4feaad,_0x3fa935){return _0x4feaad>_0x3fa935;}},_0xe55edf=SceneManager[_0x2d1b3b(0x2aa)+_0x2d1b3b(0x2d2)]||{},_0x41a669=_0xe55edf[_0x2d1b3b(0x3aa)]||'',_0x5ae393=this[_0x2d1b3b(0x550)+_0x2d1b3b(0x389)][_0x2d1b3b(0x4a6)][-0x11*0x136+-0x2*-0x1099+-0x434*0x3],_0xbe1e19=TextManager[_0x2d1b3b(0x28a)][_0x2d1b3b(0x5d7)];if(this['_naturalRo'+'ll']){const _0x36fd63=SceneManager[_0x2d1b3b(0x1f8)][_0x2d1b3b(0x23a)+_0x2d1b3b(0x140)+'ndow'];if(_0x4620b8[_0x2d1b3b(0x48e)](_0x5ae393[_0x2d1b3b(0x2c9)](),0x4f3+0x2689+-0x2b7b)){[_0x4620b8[_0x2d1b3b(0x331)],_0x4620b8[_0x2d1b3b(0x3ae)]][_0x2d1b3b(0x135)](_0x41a669)?(_0x5ae393[_0x2d1b3b(0xbb)+'olor'](_0xbe1e19['modDownCol'+'or']),_0x36fd63&&_0x36fd63['drawCenter'+_0x2d1b3b(0x2b7)](TextManager[_0x2d1b3b(0x28a)][_0x2d1b3b(0x431)][_0x2d1b3b(0x3c2)+_0x2d1b3b(0x22e)])):(_0x5ae393[_0x2d1b3b(0xbb)+_0x2d1b3b(0x44a)](_0xbe1e19['modUpColor']),_0x36fd63&&_0x36fd63['drawCenter'+_0x2d1b3b(0x2b7)](TextManager[_0x2d1b3b(0x28a)]['subtitle'][_0x2d1b3b(0x409)+'ccess']));return;}else{if(_0x4620b8['LfAFC'](_0x5ae393[_0x2d1b3b(0x2c9)](),VisuMZ[_0x2d1b3b(0x50f)+_0x2d1b3b(0x20a)][_0x2d1b3b(0x242)+_0x2d1b3b(0x4f5)]())){[_0x4620b8[_0x2d1b3b(0x331)],_0x4620b8[_0x2d1b3b(0x3ae)]][_0x2d1b3b(0x135)](_0x41a669)?(_0x5ae393[_0x2d1b3b(0xbb)+_0x2d1b3b(0x44a)](_0xbe1e19[_0x2d1b3b(0x50b)]),_0x36fd63&&_0x36fd63[_0x2d1b3b(0x529)+'edText'](TextManager[_0x2d1b3b(0x28a)]['subtitle'][_0x2d1b3b(0x409)+_0x2d1b3b(0xdb)])):(_0x5ae393['setNumberC'+'olor'](_0xbe1e19[_0x2d1b3b(0x519)+'or']),_0x36fd63&&_0x36fd63[_0x2d1b3b(0x529)+_0x2d1b3b(0x2b7)](TextManager['DICE_ROLL'][_0x2d1b3b(0x431)][_0x2d1b3b(0x3c2)+_0x2d1b3b(0x22e)]));return;}}}const _0x3b9055=_0xe55edf['modifiers']||0x2b*0x9a+-0x1*-0xf43+-0x2921,_0x404035=_0xe55edf[_0x2d1b3b(0x1ca)]||0x8ac*0x1+-0x1*-0x1c03+0x24af*-0x1,_0x2033e6=_0x4620b8['KQSak'](_0x5ae393[_0x2d1b3b(0x2c9)](),_0x3b9055),_0x3fdd76=_0x4620b8['Mlgjz'](_0x2033e6,_0x404035);let _0x1a8f03=_0x2033e6;if(_0x4620b8[_0x2d1b3b(0x3d4)](_0x2033e6,_0x3fdd76)){const _0x22f64e=_0xe55edf[_0x2d1b3b(0x325)]||{};if(_0x22f64e[_0x2d1b3b(0x375)]&&_0x4620b8['SOHRB'](_0x22f64e[_0x2d1b3b(0x375)],_0x4620b8[_0x2d1b3b(0x24c)])){const _0x4c6c68=_0x22f64e['Seed'],_0x310287=_0x22f64e[_0x2d1b3b(0x3a2)],_0x1e798d=_0x22f64e['ApplyUniqu'+'e'];_0x1a8f03=$gameSystem[_0x2d1b3b(0x46b)+_0x2d1b3b(0x605)+_0x2d1b3b(0x1b5)+'ed'](_0x2033e6,_0x3fdd76,_0x4c6c68,_0x310287,_0x1e798d);}else _0x1a8f03=_0x4620b8[_0x2d1b3b(0x4be)](_0x2033e6,Math[_0x2d1b3b(0x170)](_0x4620b8['Fuudm'](_0x404035,-0xe3*0x12+0xb60+-0x2f*-0x19)));}if(_0x4620b8[_0x2d1b3b(0x48e)](_0x1a8f03,_0x5ae393[_0x2d1b3b(0x2c9)]()))return;_0x5ae393[_0x2d1b3b(0x2f8)+_0x2d1b3b(0x581)](_0x1a8f03),_0x4620b8[_0x2d1b3b(0x5b0)](_0x1a8f03,_0x5ae393[_0x2d1b3b(0x2c9)]())?_0x5ae393[_0x2d1b3b(0xbb)+_0x2d1b3b(0x44a)](_0xbe1e19['modUpColor']):_0x5ae393[_0x2d1b3b(0xbb)+'olor'](_0xbe1e19[_0x2d1b3b(0x519)+'or']);},Window_DiceSprite[_0x5db7a1(0x4ce)][_0x5db7a1(0x5fc)+_0x5db7a1(0x2a6)]=function(){const _0x41bab8=_0x5db7a1,_0x51fbd2=SceneManager[_0x41bab8(0x2aa)+'ettings']||{};return _0x51fbd2['NaturalRol'+'ls'];},Window_DiceSprite[_0x5db7a1(0x4ce)][_0x5db7a1(0x4e0)+_0x5db7a1(0x5b1)]=function(){const _0x293ee5=_0x5db7a1,_0x122947={'gQAwQ':'recording'};this[_0x293ee5(0x369)]=_0x122947[_0x293ee5(0x33f)];},Window_DiceSprite[_0x5db7a1(0x4ce)][_0x5db7a1(0x32b)+'dingPhase']=function(){const _0x4d0b15=_0x5db7a1;this['processRec'+_0x4d0b15(0x3e4)+'e'](),this['endRecordi'+_0x4d0b15(0x14f)]();},Window_DiceSprite['prototype'][_0x5db7a1(0x3b2)+_0x5db7a1(0x3e4)+'e']=function(){const _0x1f5e76=_0x5db7a1,_0x35eeaa={'GSMWJ':_0x1f5e76(0x1d5)+'t','GQzIA':_0x1f5e76(0x39f)+'Target','PBKEO':function(_0x2cea72,_0x16d771){return _0x2cea72!==_0x16d771;},'dXehR':function(_0x42566b,_0x1a36f6){return _0x42566b===_0x1a36f6;},'VYQZN':function(_0x4fb99f,_0xba033b){return _0x4fb99f===_0xba033b;},'MChvb':function(_0x4247c4,_0x43784c){return _0x4247c4>_0x43784c;},'oRpMY':function(_0x10f033,_0x5c46b8){return _0x10f033===_0x5c46b8;},'GticQ':function(_0x4a1d03,_0x3b4547){return _0x4a1d03>=_0x3b4547;},'AkEeI':_0x1f5e76(0x558)+_0x1f5e76(0xd7),'CvZjW':function(_0x221568,_0x570c13){return _0x221568<=_0x570c13;},'VngFq':'belowTarge'+'t','YdGgJ':function(_0x17124c,_0x44dd8b){return _0x17124c<_0x44dd8b;},'vbvyL':_0x1f5e76(0x450)+'e','dGxNy':function(_0x198d2d,_0x4fc50b){return _0x198d2d+_0x4fc50b;}},_0x7cd2b5=SceneManager[_0x1f5e76(0x2aa)+_0x1f5e76(0x2d2)]||{},_0xc04e69=_0x7cd2b5['ResultType']||'',_0x370da8=this[_0x1f5e76(0x550)+'iner'][_0x1f5e76(0x4a6)][-0x189b+-0xd12+-0x1*-0x25ad],_0x12dfd4=_0x370da8['number'](),_0x3bd346=_0x7cd2b5[_0x1f5e76(0x315)+'e']||-0xfe9+0x1fca+0x1*-0xfe1;let _0x1c0fea=![];if(_0x7cd2b5[_0x1f5e76(0x603)+'ls']&&this[_0x1f5e76(0x237)+'ll'])[_0x35eeaa[_0x1f5e76(0x2fb)],_0x35eeaa[_0x1f5e76(0x3cb)]][_0x1f5e76(0x135)](_0xc04e69)?_0x1c0fea=_0x35eeaa[_0x1f5e76(0x586)](_0x12dfd4,0x2*-0x1ec+0xb90+-0x7b7):_0x1c0fea=_0x35eeaa[_0x1f5e76(0x217)](_0x12dfd4,-0x892*0x1+0x3a1*0x3+-0x250);else{if(_0x35eeaa[_0x1f5e76(0x114)](_0xc04e69,_0x35eeaa['GSMWJ']))_0x1c0fea=_0x35eeaa[_0x1f5e76(0x246)](_0x12dfd4,_0x3bd346);else{if(_0x35eeaa[_0x1f5e76(0x18c)](_0xc04e69,_0x35eeaa[_0x1f5e76(0x3cb)]))_0x1c0fea=_0x35eeaa[_0x1f5e76(0x592)](_0x12dfd4,_0x3bd346);else{if(_0x35eeaa[_0x1f5e76(0x18c)](_0xc04e69,_0x35eeaa['AkEeI']))_0x1c0fea=_0x35eeaa['CvZjW'](_0x12dfd4,_0x3bd346);else _0x35eeaa[_0x1f5e76(0x217)](_0xc04e69,_0x35eeaa['VngFq'])&&(_0x1c0fea=_0x35eeaa['YdGgJ'](_0x12dfd4,_0x3bd346));}}}_0x7cd2b5[_0x1f5e76(0x26b)]&&$gameSwitches[_0x1f5e76(0x247)](_0x7cd2b5[_0x1f5e76(0x26b)],_0x1c0fea),_0x7cd2b5[_0x1f5e76(0x480)]&&$gameVariables[_0x1f5e76(0x247)](_0x7cd2b5[_0x1f5e76(0x480)],_0x12dfd4),_0x35eeaa[_0x1f5e76(0x114)](_0x7cd2b5[_0x1f5e76(0x233)],_0x35eeaa[_0x1f5e76(0x2d7)])&&(_0x1c0fea?SoundManager[_0x1f5e76(0x48d)+_0x1f5e76(0xdb)](this[_0x1f5e76(0x237)+'ll']):SoundManager['playDiceFa'+'ilure'](this['_naturalRo'+'ll'])),_0x370da8[_0x1f5e76(0x19b)+'ut'](!![]),this['_finalizeD'+_0x1f5e76(0x5d2)]=_0x35eeaa[_0x1f5e76(0x3e0)](_0x370da8['_finalizeD'+_0x1f5e76(0x5d2)],_0x370da8[_0x1f5e76(0x57c)+_0x1f5e76(0x58a)])||0x41*0x2d+-0x1070+0x504;},Window_DiceSprite[_0x5db7a1(0x4ce)][_0x5db7a1(0x27d)+'ngPhase']=function(){const _0x59e082=_0x5db7a1,_0xc2a526={'mUTQd':_0x59e082(0x5ee)};this[_0x59e082(0x369)]=_0xc2a526['mUTQd'];},Window_DiceSprite['prototype'][_0x5db7a1(0x110)+_0x5db7a1(0x55b)]=function(){const _0x5b7b3a=_0x5db7a1,_0x2ba069={'kyfHh':function(_0x1e1bf4,_0x3b339f){return _0x1e1bf4>_0x3b339f;}};if(_0x2ba069[_0x5b7b3a(0x2ff)](this[_0x5b7b3a(0x310)+_0x5b7b3a(0x5d2)],-0xd51*-0x1+0x8f7+0x17*-0xf8))return this[_0x5b7b3a(0x310)+_0x5b7b3a(0x5d2)]--;this['processEnd'+_0x5b7b3a(0x1d9)](),this[_0x5b7b3a(0x174)+_0x5b7b3a(0x26e)]();},Window_DiceSprite['prototype'][_0x5db7a1(0x4f6)+_0x5db7a1(0x1d9)]=function(){const _0x510068=_0x5db7a1,_0xdfd43b=this['_mainConta'+_0x510068(0x389)]['children'][-0x1*0x10d0+-0x6*-0x48d+-0xa7e];this[_0x510068(0x550)+'iner'][_0x510068(0x1e9)+'d'](_0xdfd43b),_0xdfd43b['destroy']();},Window_DiceSprite[_0x5db7a1(0x4ce)][_0x5db7a1(0x174)+_0x5db7a1(0x26e)]=function(){const _0x506492=_0x5db7a1,_0x580a33={'aEwcf':'final','qhujv':function(_0x483dfa,_0x4cad03){return _0x483dfa*_0x4cad03;},'CepJY':function(_0x5e566d,_0xc27402){return _0x5e566d/_0xc27402;},'anISt':function(_0x12def1,_0x53877b,_0x597df6){return _0x12def1(_0x53877b,_0x597df6);}};this[_0x506492(0x369)]=_0x580a33['aEwcf'],SceneManager[_0x506492(0x1f8)]['startClosi'+_0x506492(0x39b)+_0x506492(0x485)]();const _0x4e8493=Math['ceil'](_0x580a33[_0x506492(0x34f)](_0x580a33['CepJY'](-0x6*-0x192+-0x1*0x1502+0xba2,0x8*-0x251+-0x769*-0x5+-0x1249),-0x3d9*-0x1+-0x3*-0x57d+-0x1068));_0x580a33[_0x506492(0x106)](setTimeout,SceneManager[_0x506492(0x439)+'l'][_0x506492(0x17e)](SceneManager),_0x4e8493);},Window_DiceSprite[_0x5db7a1(0x4ce)][_0x5db7a1(0x297)+_0x5db7a1(0x1db)]=function(){const _0x54122d=_0x5db7a1,_0x5bf84c={'KJCLN':function(_0x216ee6,_0x4be91a){return _0x216ee6!==_0x4be91a;},'VFbIM':'prepare','GGDmO':function(_0x69e687,_0x44b2c3){return _0x69e687!==_0x44b2c3;}};if(_0x5bf84c[_0x54122d(0x15c)](this[_0x54122d(0x369)],_0x5bf84c[_0x54122d(0xec)]))return![];const _0x1adcdb=VisuMZ[_0x54122d(0x50f)+_0x54122d(0x20a)]['TotalDiceT'+_0x54122d(0xc8)]();if(this[_0x54122d(0x550)+'iner']&&_0x5bf84c['KJCLN'](this[_0x54122d(0x550)+'iner'][_0x54122d(0x4a6)]['length'],_0x1adcdb))return!![];if(_0x5bf84c['GGDmO'](this[_0x54122d(0xc7)],VisuMZ[_0x54122d(0x50f)+_0x54122d(0x20a)][_0x54122d(0x242)+_0x54122d(0x4f5)]()))return!![];return![];},Window_DiceSprite[_0x5db7a1(0x4ce)][_0x5db7a1(0x290)+_0x5db7a1(0x38b)]=function(){const _0x5ae5d2=_0x5db7a1,_0x3cb465={'KyMzn':function(_0x5c727c,_0x3bf3ec){return _0x5c727c>_0x3bf3ec;}};while(_0x3cb465['KyMzn'](this[_0x5ae5d2(0x550)+_0x5ae5d2(0x389)][_0x5ae5d2(0x4a6)][_0x5ae5d2(0x5de)],0x9b*0xd+-0xc3*-0x11+-0x14d2)){const _0x5a456d=this[_0x5ae5d2(0x550)+_0x5ae5d2(0x389)][_0x5ae5d2(0x4a6)][0x1*0x162d+-0x1dea+0x7bd];this[_0x5ae5d2(0x378)+_0x5ae5d2(0x2f0)+_0x5ae5d2(0x389)](_0x5a456d);}},Window_DiceSprite[_0x5db7a1(0x4ce)]['moveSprite'+_0x5db7a1(0x2f0)+'inerExcept']=function(_0x39ed2c){const _0x337cfe=_0x5db7a1,_0x1e9361={'ENyFY':function(_0x1b544e,_0x452859){return _0x1b544e>_0x452859;}},_0x3e0c9f=this[_0x337cfe(0x550)+_0x337cfe(0x389)]['children'],_0x4dbcf9=_0x3e0c9f[_0x337cfe(0x175)]();_0x4dbcf9['remove'](_0x39ed2c);while(_0x1e9361['ENyFY'](_0x4dbcf9['length'],0xddf+-0x3*-0x3a6+-0x18d1)){const _0x44cddb=_0x4dbcf9[_0x337cfe(0x129)]();this[_0x337cfe(0x378)+_0x337cfe(0x2f0)+_0x337cfe(0x389)](_0x44cddb);}},Window_DiceSprite[_0x5db7a1(0x4ce)][_0x5db7a1(0x378)+_0x5db7a1(0x2f0)+'iner']=function(_0x1584fb){const _0x13d972=_0x5db7a1;_0x1584fb[_0x13d972(0x19b)+'ut'](),this['_mainConta'+_0x13d972(0x389)]['removeChil'+'d'](_0x1584fb),this[_0x13d972(0x326)+_0x13d972(0x4dd)]['addChild'](_0x1584fb);},Window_DiceSprite[_0x5db7a1(0x4ce)][_0x5db7a1(0x2b4)+_0x5db7a1(0x38b)]=function(){const _0xefe380=_0x5db7a1,_0x337422={'ijLPR':function(_0x5671f4,_0x247b85){return _0x5671f4/_0x247b85;},'EjviO':function(_0x30899,_0x47c119){return _0x30899/_0x47c119;},'mRAJN':function(_0x43718b,_0x42a6d7){return _0x43718b<_0x42a6d7;},'zfpoD':function(_0x3b9766,_0x37541d){return _0x3b9766+_0x37541d;},'AXBgu':function(_0xfc060d,_0x11cf4d){return _0xfc060d*_0x11cf4d;}},_0x3a2c24=VisuMZ[_0xefe380(0x50f)+_0xefe380(0x20a)][_0xefe380(0x274)+_0xefe380(0xc8)](),_0x57f591=-0x372+-0x5d*-0x29+-0xb73,_0xfdb925=-0x1*-0x1aec+-0x198b+-0xc1*0x1,_0xe73371=Math[_0xefe380(0x19f)](_0x337422['ijLPR'](this[_0xefe380(0x118)],_0x3a2c24)),_0x103f8=_0x337422['EjviO'](_0xe73371,_0xfdb925)[_0xefe380(0x28f)](-0xb7*-0x11+0xd9a+-0x19c1+0.2,0x1c05+0xa19+-0x377*0xb);for(let _0x2b3f96=-0x6bb*-0x2+0x1781+-0x24f7;_0x337422[_0xefe380(0xe6)](_0x2b3f96,_0x3a2c24);_0x2b3f96++){const _0x8c2b97=new Sprite_DiceCheck();this['_mainConta'+_0xefe380(0x389)][_0xefe380(0x168)](_0x8c2b97);const _0x153e70=_0x337422['ijLPR'](_0x337422['zfpoD'](_0x2b3f96,-0x115*0x2+0x2237+-0x200c),_0x337422['zfpoD'](_0x3a2c24,-0xa32+0x1bd3*-0x1+0x2606)),_0x3145f2=Math[_0xefe380(0x383)](_0x337422[_0xefe380(0x5f6)](_0x153e70,this[_0xefe380(0x118)]));_0x8c2b97['setBaseXy'](_0x3145f2,_0x57f591),_0x8c2b97[_0xefe380(0x28c)+'le'](_0x103f8);}},Window_DiceSprite[_0x5db7a1(0x4ce)][_0x5db7a1(0x45d)+_0x5db7a1(0x1f3)]=function(){const _0x5cc132=_0x5db7a1,_0x4d474f={'HkXGB':function(_0x31f8e9,_0x58b954){return _0x31f8e9<=_0x58b954;}},_0x46c460=[];for(const _0x8c2024 of this[_0x5cc132(0x326)+_0x5cc132(0x4dd)][_0x5cc132(0x4a6)]){if(_0x4d474f[_0x5cc132(0x3e9)](_0x8c2024[_0x5cc132(0x415)],-0x1ac*0x13+0x20e8+-0x124))_0x46c460[_0x5cc132(0x1bd)](_0x8c2024);}for(const _0x2c735f of _0x46c460){this['_subContai'+_0x5cc132(0x4dd)]['removeChil'+'d'](_0x2c735f),_0x2c735f['destroy']();}};function Window_DiceChoice(){const _0x45a360=_0x5db7a1;this[_0x45a360(0x244)](...arguments);}Window_DiceChoice['prototype']=Object[_0x5db7a1(0x467)](Window_Command[_0x5db7a1(0x4ce)]),Window_DiceChoice[_0x5db7a1(0x4ce)][_0x5db7a1(0xeb)+'r']=Window_DiceChoice,Window_DiceChoice[_0x5db7a1(0x444)]={'textAlign':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)]['Settings']['Window'][_0x5db7a1(0x280)+_0x5db7a1(0x474)]??_0x5db7a1(0x108),'showEffects':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)]['Settings'][_0x5db7a1(0x2cb)][_0x5db7a1(0x328)+'wEffects']??!![],'showBonuses':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x573)][_0x5db7a1(0x2cb)][_0x5db7a1(0x328)+_0x5db7a1(0x37c)]??!![]},Window_DiceChoice['prototype'][_0x5db7a1(0x244)]=function(_0x4c3dd2){const _0x36bddd=_0x5db7a1;Window_Command[_0x36bddd(0x4ce)][_0x36bddd(0x244)][_0x36bddd(0x23f)](this,_0x4c3dd2),this[_0x36bddd(0x5a6)]=-0x76c+0x1fc1+-0x1855,this[_0x36bddd(0x2f3)]();},Window_DiceChoice[_0x5db7a1(0x4ce)]['makeComman'+_0x5db7a1(0x12e)]=function(){const _0x46b0b5=_0x5db7a1;this['addRollCom'+_0x46b0b5(0x3d0)](),this[_0x46b0b5(0x57f)+_0x46b0b5(0x4f4)](),this['addBonusCo'+_0x46b0b5(0x4fc)]();},Window_DiceChoice[_0x5db7a1(0x4ce)][_0x5db7a1(0x3d9)+'mand']=function(){const _0x2a6b8b=_0x5db7a1,_0x5cd3c3={'XypZH':_0x2a6b8b(0x4f0)},_0x29509a=TextManager[_0x2a6b8b(0x28a)][_0x2a6b8b(0x30c)][_0x2a6b8b(0x4f0)];this['addCommand'](_0x29509a,_0x5cd3c3[_0x2a6b8b(0x269)],!![]);},Window_DiceChoice[_0x5db7a1(0x4ce)]['addEffects'+_0x5db7a1(0x4f4)]=function(){const _0x4ec84e=_0x5db7a1,_0x3d702f={'NSyHp':'effects','vuDZy':function(_0x47d21b,_0x2e805f){return _0x47d21b>_0x2e805f;}};if(!VisuMZ[_0x4ec84e(0x50f)+_0x4ec84e(0x20a)]['AllowDiceE'+_0x4ec84e(0x231)]())return;const _0x58fc9b=TextManager['DICE_ROLL'][_0x4ec84e(0x30c)][_0x4ec84e(0x1a1)],_0x8dd2bb=SceneManager[_0x4ec84e(0x2aa)+'ettings']||{};_0x8dd2bb[_0x4ec84e(0x1a1)]=_0x8dd2bb[_0x4ec84e(0x1a1)]||[],this[_0x4ec84e(0x10f)](_0x58fc9b,_0x3d702f[_0x4ec84e(0x41a)],_0x3d702f[_0x4ec84e(0x2d3)](_0x8dd2bb[_0x4ec84e(0x1a1)][_0x4ec84e(0x5de)],0xc43+0xf2+-0xd35));},Window_DiceChoice[_0x5db7a1(0x4ce)][_0x5db7a1(0x38e)+_0x5db7a1(0x4fc)]=function(){const _0x2dd9bf=_0x5db7a1,_0x1ad4fb={'JooVo':_0x2dd9bf(0x59f)};if(!VisuMZ['DiceRollsR'+_0x2dd9bf(0x20a)][_0x2dd9bf(0x16f)+_0x2dd9bf(0x5e5)]())return;const _0x3a1cf2=TextManager[_0x2dd9bf(0x28a)][_0x2dd9bf(0x30c)][_0x2dd9bf(0x59f)];this[_0x2dd9bf(0x10f)](_0x3a1cf2,_0x1ad4fb[_0x2dd9bf(0x590)],!![]);},VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)]['TotalDiceC'+_0x5db7a1(0x394)]=function(){const _0x379554=_0x5db7a1;let _0x465100=-0x1*-0x2+0x3a7+-0x3a8;return VisuMZ[_0x379554(0x50f)+_0x379554(0x20a)]['AllowDiceE'+_0x379554(0x231)]()&&(_0x465100+=-0x7b+0x184d+-0x17d1),VisuMZ[_0x379554(0x50f)+_0x379554(0x20a)][_0x379554(0x16f)+_0x379554(0x5e5)]()&&(_0x465100+=-0x1484+-0x248b+-0x10*-0x391),_0x465100;},VisuMZ['DiceRollsR'+_0x5db7a1(0x20a)][_0x5db7a1(0x523)+_0x5db7a1(0x231)]=function(){const _0x4521d9=_0x5db7a1,_0xd0a2a6={'taMmq':function(_0x2abdb8,_0x496808){return _0x2abdb8>_0x496808;}};if(!Window_DiceChoice['SETTINGS'][_0x4521d9(0x38a)+'s'])return![];if(this['AllowDiceB'+_0x4521d9(0x5e5)]())return!![];const _0xdf9711=SceneManager[_0x4521d9(0x2aa)+_0x4521d9(0x2d2)]||{};return _0xdf9711['effects']=_0xdf9711[_0x4521d9(0x1a1)]||[],_0xd0a2a6[_0x4521d9(0x4b9)](_0xdf9711[_0x4521d9(0x1a1)][_0x4521d9(0x5de)],-0x1b75+0x1ff3*-0x1+0x3b68);},VisuMZ[_0x5db7a1(0x50f)+'ngSeeds']['AllowDiceB'+'onuses']=function(){const _0xabb3d0=_0x5db7a1,_0x581bca={'djSkM':function(_0x295d16,_0x2d15ce){return _0x295d16>_0x2d15ce;}};if(!Window_DiceChoice[_0xabb3d0(0x444)][_0xabb3d0(0x2b2)+'s'])return![];const _0x2dfade=SceneManager[_0xabb3d0(0x2aa)+_0xabb3d0(0x2d2)]||{};return _0x2dfade['bonusEffec'+'ts']=_0x2dfade['bonusEffec'+'ts']||[],_0x581bca[_0xabb3d0(0x374)](_0x2dfade[_0xabb3d0(0x5b3)+'ts'][_0xabb3d0(0x5de)],0xa9b+-0x8ee+-0x1ad);},Window_DiceChoice[_0x5db7a1(0x4ce)][_0x5db7a1(0x235)+_0x5db7a1(0x22d)]=function(){const _0x5676e4=_0x5db7a1;return Window_DiceChoice[_0x5676e4(0x444)]['textAlign'];},Window_DiceChoice[_0x5db7a1(0x4ce)]['drawItem']=function(_0x14fa19){const _0x5843a7=_0x5db7a1,_0x5d0e84={'VhOad':function(_0x149efe,_0x5ae652){return _0x149efe===_0x5ae652;},'NLMDe':_0x5843a7(0x45f),'dwuJz':function(_0x1b7e02,_0x48f22f){return _0x1b7e02-_0x48f22f;},'NuaZS':function(_0x2bb4ac,_0x532c0e){return _0x2bb4ac+_0x532c0e;},'IiWZp':'center','MnsZt':function(_0x553e3d,_0xa9afb2){return _0x553e3d+_0xa9afb2;},'nejIA':function(_0x21995d,_0x3388d2){return _0x21995d/_0x3388d2;},'dVjTr':function(_0x5b7959,_0x2776dc){return _0x5b7959-_0x2776dc;}},_0xd8206f=this[_0x5843a7(0x39a)+'ct'](_0x14fa19),_0xeab88d=this[_0x5843a7(0x5d0)+'e'](_0x14fa19),_0x3706a1=this[_0x5843a7(0x511)](_0xeab88d)['width'];this['changePain'+_0x5843a7(0x2c2)](this[_0x5843a7(0x478)+_0x5843a7(0x35c)](_0x14fa19));const _0xcba26b=this[_0x5843a7(0x235)+_0x5843a7(0x22d)]();if(_0x5d0e84[_0x5843a7(0xe5)](_0xcba26b,_0x5d0e84['NLMDe']))this[_0x5843a7(0x423)](_0xeab88d,_0x5d0e84['dwuJz'](_0x5d0e84[_0x5843a7(0x257)](_0xd8206f['x'],_0xd8206f[_0x5843a7(0x118)]),_0x3706a1),_0xd8206f['y'],_0x3706a1);else{if(_0x5d0e84['VhOad'](_0xcba26b,_0x5d0e84['IiWZp'])){const _0x4e9579=_0x5d0e84[_0x5843a7(0x5ff)](_0xd8206f['x'],Math[_0x5843a7(0x19f)](_0x5d0e84['nejIA'](_0x5d0e84[_0x5843a7(0x373)](_0xd8206f[_0x5843a7(0x118)],_0x3706a1),0x53*0x6e+0x48f+-0x2837)));this[_0x5843a7(0x423)](_0xeab88d,_0x4e9579,_0xd8206f['y'],_0x3706a1);}else this[_0x5843a7(0x423)](_0xeab88d,_0xd8206f['x'],_0xd8206f['y'],_0x3706a1);}};function Window_DiceListBase(){const _0x12739=_0x5db7a1;this[_0x12739(0x244)](...arguments);}Window_DiceListBase[_0x5db7a1(0x4ce)]=Object['create'](Window_Command[_0x5db7a1(0x4ce)]),Window_DiceListBase[_0x5db7a1(0x4ce)][_0x5db7a1(0xeb)+'r']=Window_DiceListBase,Window_DiceListBase[_0x5db7a1(0x444)]={'columns':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x573)][_0x5db7a1(0x2cb)]['ListColumn'+'s']??0x1cce*0x1+-0x245e+-0x11*-0x72,'colSpacing':VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)]['Settings'][_0x5db7a1(0x2cb)][_0x5db7a1(0x12b)+_0x5db7a1(0x380)]??-0x110a+-0x2483+-0x131*-0x2d},Window_DiceListBase[_0x5db7a1(0x4ce)][_0x5db7a1(0x244)]=function(_0x139072){const _0x3fec11=_0x5db7a1;Window_Command['prototype']['initialize'][_0x3fec11(0x23f)](this,_0x139072),this[_0x3fec11(0x5a6)]=0x15e+0x10b0+-0x120e,this[_0x3fec11(0x466)]();},Window_DiceListBase[_0x5db7a1(0x4ce)][_0x5db7a1(0x11a)]=function(){const _0x56415d=_0x5db7a1;return Window_DiceListBase[_0x56415d(0x444)]['columns']||-0x1e8+0x177c+-0x315*0x7;},Window_DiceListBase[_0x5db7a1(0x4ce)][_0x5db7a1(0x370)]=function(){const _0x3bd5bf=_0x5db7a1;return Window_DiceListBase[_0x3bd5bf(0x444)]['colSpacing']||-0x1e72+-0x9fe+0x2*0x1438;},Window_DiceListBase[_0x5db7a1(0x4ce)]['makeComman'+_0x5db7a1(0x12e)]=function(){const _0x13f1a6=_0x5db7a1,_0x22548f=this[_0x13f1a6(0x153)+'t']();for(const _0x286a2f of _0x22548f){if(!this[_0x13f1a6(0x417)](_0x286a2f))return;this[_0x13f1a6(0x23b)+'Command'](_0x286a2f);}},Window_DiceListBase[_0x5db7a1(0x4ce)][_0x5db7a1(0x153)+'t']=function(){return[];},Window_DiceListBase['prototype'][_0x5db7a1(0x417)]=function(_0x57f474){if(!_0x57f474)return![];return!![];},Window_DiceListBase[_0x5db7a1(0x4ce)]['makeEffect'+_0x5db7a1(0x4f4)]=function(_0x310c0b){const _0x53bdef=_0x5db7a1,_0x1126f8={'FDGpR':_0x53bdef(0x105)},_0x10bfaa=this['makeEffect'+'Name'](_0x310c0b),_0x357340=_0x1126f8[_0x53bdef(0xe7)],_0x436d88=this['isEnabled'](_0x310c0b),_0x30408c=_0x310c0b;this[_0x53bdef(0x10f)](_0x10bfaa,_0x357340,_0x436d88,_0x30408c);},Window_DiceListBase[_0x5db7a1(0x4ce)][_0x5db7a1(0x23b)+_0x5db7a1(0x3fd)]=function(_0x4b25d6){const _0x55d15c=_0x5db7a1,_0x14348c={'EhZMk':function(_0xc1901a,_0x28ced2){return _0xc1901a===_0x28ced2;},'FfWLQ':'AUTONAME','BJsLQ':function(_0x36e92b,_0x441223){return _0x36e92b(_0x441223);},'RVXfB':_0x55d15c(0x4a9)+_0x55d15c(0x148),'wduDJ':function(_0x576084,_0x1a6bc5){return _0x576084+_0x1a6bc5;},'UvyKL':_0x55d15c(0x2c1)+_0x55d15c(0x38c),'WMnFx':function(_0x427984,_0x52df81){return _0x427984>=_0x52df81;},'gSbIf':_0x55d15c(0x39e),'viuuJ':function(_0x25ea66,_0x1328a8){return _0x25ea66||_0x1328a8;},'zsanO':_0x55d15c(0x164),'taBSd':function(_0x49d554,_0x54f7df){return _0x49d554||_0x54f7df;},'DMPfO':_0x55d15c(0x390)+_0x55d15c(0x5b9)};if(_0x4b25d6[_0x55d15c(0x3fd)]||_0x4b25d6['Icon']){let _0x2cdc15=_0x4b25d6['Name']||'',_0x3ab96a=_0x4b25d6[_0x55d15c(0x5e4)]||0x1a*-0x14b+-0x3e2*0x9+-0x2*-0x2248,_0x242469=null;(_0x4b25d6[_0x55d15c(0x5b7)]||_0x4b25d6[_0x55d15c(0x5c6)])&&(_0x242469=$dataItems[_0x4b25d6[_0x55d15c(0x5b7)]||_0x4b25d6[_0x55d15c(0x5c6)]]);(_0x4b25d6[_0x55d15c(0x1c7)+'D']||_0x4b25d6['WeaponCost'+'ID'])&&(_0x242469=$dataWeapons[_0x4b25d6['WeaponReqI'+'D']||_0x4b25d6['WeaponCost'+'ID']]);(_0x4b25d6[_0x55d15c(0x21b)]||_0x4b25d6[_0x55d15c(0x2bc)+'D'])&&(_0x242469=$dataArmors[_0x4b25d6[_0x55d15c(0x21b)]||_0x4b25d6[_0x55d15c(0x2bc)+'D']]);(_0x4b25d6[_0x55d15c(0x419)]||_0x4b25d6[_0x55d15c(0x396)+'D'])&&(_0x242469=$dataSkills[_0x4b25d6[_0x55d15c(0x419)]||_0x4b25d6[_0x55d15c(0x396)+'D']]);if(_0x14348c[_0x55d15c(0x17d)](_0x2cdc15[_0x55d15c(0x3bf)+'e']()[_0x55d15c(0x12c)](),_0x14348c[_0x55d15c(0x146)])){_0x2cdc15=_0x242469?_0x242469[_0x55d15c(0x5a2)]:'';if(Imported['VisuMZ_1_I'+_0x55d15c(0x598)+_0x55d15c(0x587)]&&_0x242469){if(_0x242469[_0x55d15c(0x241)]['match'](/<COLOR:[ ](\d+)>/i)){const _0x34370b=_0x14348c[_0x55d15c(0x34a)](Number,RegExp['$1']);_0x2cdc15=_0x14348c[_0x55d15c(0x1be)][_0x55d15c(0x13e)](_0x34370b,_0x2cdc15[_0x55d15c(0x12c)]());}else{if(Imported[_0x55d15c(0x47a)+_0x55d15c(0x15a)]&&_0x242469[_0x55d15c(0x241)][_0x55d15c(0x316)](/<COLOR:[ ]#(.*)>/i)){const _0x46a90b=_0x14348c['wduDJ']('#',_0x14348c[_0x55d15c(0x34a)](String,RegExp['$1']));_0x2cdc15=_0x14348c[_0x55d15c(0x5bc)][_0x55d15c(0x13e)](_0x46a90b,_0x2cdc15[_0x55d15c(0x12c)]());}}}_0x2cdc15=_0x2cdc15[_0x55d15c(0x12c)]();}return _0x14348c[_0x55d15c(0x31d)](_0x3ab96a,0x4c923+-0x798da+0x1211f7)&&(_0x3ab96a=_0x242469?_0x242469[_0x55d15c(0x55f)]:0x2*-0x185+0x1638+-0x2*0x997),_0x14348c['gSbIf']['format'](_0x14348c[_0x55d15c(0x30b)](_0x2cdc15,_0x14348c[_0x55d15c(0x17c)]),_0x14348c[_0x55d15c(0x604)](_0x3ab96a,0x129a+-0x1*0x425+-0xe75));}return _0x14348c[_0x55d15c(0x17b)];},Window_DiceListBase[_0x5db7a1(0x4ce)][_0x5db7a1(0x309)]=function(_0x35d687){if(!_0x35d687)return![];return!![];},Window_DiceListBase['prototype']['drawItem']=function(_0x54ea2d){const _0x3f1f75=_0x5db7a1,_0x54e030=this['itemLineRe'+'ct'](_0x54ea2d);this[_0x3f1f75(0x54b)+_0x3f1f75(0x2d2)](),this[_0x3f1f75(0x302)+_0x3f1f75(0x2c2)](this['isCommandE'+_0x3f1f75(0x35c)](_0x54ea2d));const _0x22ca1a=this['_list'][_0x54ea2d][_0x3f1f75(0x30a)]||{},_0x14a4c1=this[_0x3f1f75(0xc5)+'t'](_0x22ca1a,_0x54ea2d)[_0x3f1f75(0x12c)]();this[_0x3f1f75(0x423)](_0x14a4c1,_0x54e030['x'],_0x54e030['y'],_0x54e030['width']),this['drawEffect'+'s'](_0x22ca1a,_0x54e030);},Window_DiceListBase[_0x5db7a1(0x4ce)][_0x5db7a1(0xc5)+'t']=function(_0x49d95e,_0x350d4e){const _0x20ab69=_0x5db7a1,_0x13f9c7={'cqWaM':function(_0x2100db,_0x2f626d){return _0x2100db+_0x2f626d;},'YARgQ':function(_0x1264f8,_0xc8773){return _0x1264f8+_0xc8773;}},_0x256922=this[_0x20ab69(0x5d0)+'e'](_0x350d4e)[_0x20ab69(0x12c)]();let _0x142376=this['getNameExt'+'ra'](_0x49d95e)[_0x20ab69(0x12c)]();const _0x257bc4=TextManager[_0x20ab69(0x28a)][_0x20ab69(0x59f)][_0x20ab69(0x4a3)];return _0x13f9c7['cqWaM'](_0x13f9c7[_0x20ab69(0x25b)](_0x256922,'\x20'),_0x257bc4[_0x20ab69(0x13e)](_0x142376));},Window_DiceListBase[_0x5db7a1(0x4ce)][_0x5db7a1(0x47c)+'ra']=function(_0x22f62b){const _0x4d1d00=_0x5db7a1,_0x52a7b9={'yDdWb':function(_0x535f2d,_0x19e90f){return _0x535f2d>_0x19e90f;}},_0xdad41a=TextManager['DICE_ROLL'][_0x4d1d00(0x59f)];let _0x282922=this[_0x4d1d00(0x36b)+'t'](_0x22f62b);if(_0x22f62b['SkillListU'+_0x4d1d00(0x3c7)]){const _0x2f17fe=$gameActors[_0x4d1d00(0x154)](_0x22f62b[_0x4d1d00(0x477)+_0x4d1d00(0x29b)]);if(_0x2f17fe){const _0x5cce36=_0xdad41a[_0x4d1d00(0x1e0)+'mt'],_0x3dc018=_0x5cce36['format'](_0x2f17fe[_0x4d1d00(0x5a2)]())['trim']();if(_0x52a7b9['yDdWb'](_0x282922[_0x4d1d00(0x5de)],-0x11*-0x6+-0x179f*-0x1+-0x2b*0x8f)){const _0x5a1f4f=_0xdad41a[_0x4d1d00(0x35e)+'ostFmt'];_0x282922=_0x5a1f4f[_0x4d1d00(0x13e)](_0x3dc018,_0x282922)[_0x4d1d00(0x12c)]();}else _0x282922+=_0x3dc018;}_0x282922=_0x282922[_0x4d1d00(0x12c)]();}return _0x282922;},Window_DiceListBase[_0x5db7a1(0x4ce)][_0x5db7a1(0x36b)+'t']=function(_0x44e924){return'';},Window_DiceListBase[_0x5db7a1(0x4ce)]['drawEffect'+'s']=function(_0x445a3e,_0x5ad89f){const _0x5b37be=_0x5db7a1,_0x4b9dba={'LBYUg':function(_0x3b6eac,_0x35e06e){return _0x3b6eac-_0x35e06e;},'MMOtV':function(_0x50ec9f,_0x71c8a0){return _0x50ec9f+_0x71c8a0;}};let _0x1867be=this[_0x5b37be(0x547)+_0x5b37be(0x30a)](_0x445a3e)[_0x5b37be(0x12c)]();const _0x43b2b0=TextManager['DICE_ROLL']['effectList'];if(_0x445a3e[_0x5b37be(0x1a6)+_0x5b37be(0x30a)]){const _0x1a027e=_0x43b2b0[_0x5b37be(0x2b0)+'Fmt'];_0x1867be=_0x1a027e[_0x5b37be(0x13e)](_0x445a3e[_0x5b37be(0x1a6)+_0x5b37be(0x30a)],_0x1867be),_0x1867be=_0x1867be[_0x5b37be(0x12c)]();}if(_0x445a3e[_0x5b37be(0x571)+_0x5b37be(0x33d)]){const _0x34b988=_0x43b2b0[_0x5b37be(0x2b0)+_0x5b37be(0x1c3)];_0x1867be=_0x34b988['format'](_0x1867be,_0x445a3e[_0x5b37be(0x571)+'Text']),_0x1867be=_0x1867be[_0x5b37be(0x12c)]();}_0x1867be=_0x43b2b0[_0x5b37be(0x4a3)][_0x5b37be(0x13e)](_0x1867be)[_0x5b37be(0x12c)]();const _0xc58fc1=this['textSizeEx'](_0x1867be)[_0x5b37be(0x118)];this['drawTextEx'](_0x1867be,_0x4b9dba['LBYUg'](_0x4b9dba[_0x5b37be(0x1c9)](_0x5ad89f['x'],_0x5ad89f['width']),_0xc58fc1),_0x5ad89f['y']);},Window_DiceListBase[_0x5db7a1(0x4ce)][_0x5db7a1(0x547)+'ext']=function(_0x3d4be7){const _0x510159=_0x5db7a1,_0x37386e=TextManager[_0x510159(0x28a)][_0x510159(0x59f)];let _0x1af0e4=TextManager[_0x510159(0x2ee)+_0x510159(0x292)+'xt'](_0x3d4be7);return _0x1af0e4;};function Window_DiceEffectsList(){const _0x5df4a4=_0x5db7a1;this[_0x5df4a4(0x244)](...arguments);}function _0x42c9(){const _0x3c3891=['data','GticQ','wQDYv','VisuMZ_1_S','moveDurati','DiceModifi','dEYtp','temsEquips','SJcNt','plvws','skillTpCos','getColor','yGtNc','Advantage','bonus','MNobU','D20','name','Roll\x20Dice','lfQsL','rank%1','openness','GcrSH','\x20Rank:','WeaponEffe','JduXD','ZJJxb','qxoXx','D10','PhXaV','processRol','hSQYm','rsPhase','leCost','bonusEffec','ing\x20Evolut','RxrcG','isRollingD','ItemReqID','s:\x5cC[0]\x20Be','fined','ified','TitleWindo','UvyKL','moveTo','2|4|0|5|1|','highest','DicePlusSi','close','lowest','_settingsK','ier\x20number','CkqnQ','ItemCostID','loseItem','setBackgro','umberSeedK','_moveDurat','ainSkillsU','TiTom','UTzvI','AsgOS','1|4|5|3|2|','commandNam','riNBy','uration','TVrHQ','isMoving','XCeap','Height','colors','DiceBonusE','rgba(0,\x200,','gWiFe','fillStyle','ation','CurrentUse','length','bNbVt','zGDOl','GBeuB','Graphic_D6','aZHOU','Icon','onuses','qID','hixPh','isDead','EVAL','positionOf','setupDiceA','dedArray','getImageFi','ending','DataCount_','ShowItemCo','ndow','e\x20Plugin\x20M','Zmpod','maxNumberD','EJMgR','AXBgu','ItemCostVa','\x5cC[29]%1\x20%','torIDs','_customMod','drawDataTe','allowNatur','canRollDic','YKINb','MnsZt','diceRollSp','DataRank2','wuaZG','NaturalRol','taBSd','geRandomNu','ArmorEffec','Interprete','clear','E!\x5cC[0]','Command_Re','esFmt','PjMJs','SubtitleAv','install\x20%2','setNumberC','exit','phic_D12','diceRollMo','diceDownCo','oll','lineTo','CostUsedUp','Sound','uWCBk','getNameTex','VbZba','_diceSides','oRoll','playDiceTh','nputComboS','11298309NztTDr','HxLdI','disadvanta','CostVarFor','_lastModif','VURDW','ggzOU','numberColo','dailyUniqu','xixDI','processMod','lCost','Target','rankUpColo','startFadeI','PsIEg','ccess','VtppG','CommandBon','GeneralEff','eHsME','CJfMQ','tValue','VYNCN','height','RirTU','VhOad','mRAJN','FDGpR','Add\x20Bonus','TGYsh','ginCommand','constructo','VFbIM','nnPUx','ing\x20Active','isNumberSh','31hnhyuE','outlineWid','ffoRZ','updateNumb','nNAFj','getLastPlu','%1\x27s\x20versi','average','NdjHG','erSprite','hbsdM','calcWindow','ectJS','gTseN','save','getRandomN','sXXUK','ShowArmorC','obCch','%1➤%2','tqDoT','effect','anISt','\x5cC[16]Dice','center','createSkil','RollTitleW','uXqZs','IcsyY','DataMod_Bg','tHYGN','addCommand','startEndin','\x20most\x20\x5cC[2','eFfUe','modulus','VYQZN','MgyFM','7|6|3','diceRollSu','width','DiceSides','maxCols','%1_pitch','uPCss','grOkY','GIpSy','useTimesFm','Scale','d10','txpqI','Ezame','iSPaG','vmcZZ','AGMzf','yFormat','color2','pop','join','ListColSpa','trim','offsetX','dList','AfQfb','ZKTbc','t\x20match\x20pl','\x20Skills.','anyMember','l\x20dice\x20dur','includes','xeZYF','ZXMQm','rolling','Duration','iMDXz','fadeOutDur','4|0|5|3|1|','ls.','format','(×%2-%1)','SubtitleWi','startModif','createBitm','setupShuff','playDiceIn','ICEtJ','FfWLQ','addDiceBon','[0]','BonusUseEf','FCQXH','aVkNA','RollSprite','sDQrw','useCurrent','ngPhase','ZmLgT','WzqoZ','s:\x5cC[0]\x20At','effectsLis','actor','LXHvY','mpA','bgdtj','isActor','\x20Count:','essageCore','eRoll','KJCLN','rollHeight','startRolli','RollAdvant','Skills','e\x20plugin\x20l','WUCEo','_numberSpr','Undefined','activate','bjZnV','OUCny','addChild','lenames','CommandRol','WMwkH','-enemy-%1-','MbmAr','setupDiceB','AllowDiceB','randomInt','leader','ZzvOy','64PBXmJh','endEndingP','clone','czmTv','textColor','KfcHU','xWCBB','advantage','DMPfO','zsanO','EhZMk','bind','EFFECT_LIS','innerWidth','SHFmj','battleMemb','_inputComb','bXJQW','onDiceRoll','PkUnR','QpGTp','dYGyO','bezierCurv','color-%1','ifiersPhas','oRpMY','DiceRank','ntage:','createDice','SkillLearn','contents','276392nLyDUx','pItBH','ion\x20Matrix','parameters','ite','_numberShi','ngRange','fontSize','loadPictur','startFadeO','btitleWind','stFmt','Vocab','floor','diceRollTi','effects','Face','yXXhA','\x5cC[%2]%1\x5cC','getImageCo','PreEffectT','DataAdvant','iFodR','udeEquip','Phase','sEKMk','BHfWn','cActor','berSeeds','ills','qValue','-actor-%1','nYotB','antage','wFPxn','mberFromSe','vantageWin','Cannot\x20rol','HaDNe','\x20Chain\x20Ski','Rect','kill','ing\x20a\x20QTE.','push','RVXfB','alue','ChoiceWind','AMsag','VariableEf','Fmt','playOkSoun','phic_D8','scale','WeaponReqI','SKHVr','MMOtV','modRand','everyMembe','RollModifi','PwBvn','Type','lineCap','_baseX','inerExcept','finalizeDe','nefad','Graphic_D4','aboveTarge','index','riteWindow','ateWaitMod','ingPhase','BonusList_','ceBatch','ormat','BonusCance','butt','ficActor','skillUserF','luded','%1_filenam','n.\x0aPlease\x20','lSubtitle','ceil','TcWon','Cost','everySpeci','removeChil','drawNumber','fsetX','RankWindow','ItemEffect','NdMbA','DataRank3','Xeiul','final','usedUp','ontainer','eDIPZ','2|3','tick','difierWind','_scene','hasItem','Max','min','YIGvw','Dice%1','padStart','szfVI','Dice_Targe','Htwyo','hYEzK','total','unknownNam','vCROA','ateDiceGra','loadDicePi','Container_','addChildTo','ngSeeds','\x5cC[0]\x20numb','drawLabelT','ShowSkillC','rollValue','KmNQh','EffectsWin','startMoveT','C[23]total','ge_setupSh','itFailure','ZFKgc','6|4|5|2','dXehR','RollChoice','lbWCu','Variable_R','ArmorReqID','Dis%1','indow','refresh','advantageF','setX','eed','SzPqm','5PGkLwF','phic_D6','ARRAYFUNC','crit_failu','yVAxW','XtekS','DICE_ROLL_','Subtitle_R','mfrfW','Game_Messa','ign','ilure','rrectly\x20pl','TUJvt','ffects','OVrcv','type','killCostTe','itemTextAl','erWindow','_naturalRo','subject','usEffects','_diceRoll_','makeEffect','STR','upNtU','erFromSeed','call','AnhJd','note','CurrentDic','ing\x20Input\x20','initialize','Xeasx','MChvb','setValue','SkillEffec','actorId','killsState','updateRoll','rnVOl','nimating','rctVC','mNumberSee','Filter','WcYFS','createAllD','VmWyi','AnimationI','bkrPH','_context','NuaZS','queKey','onditions','VisuMZ_3_A','YARgQ','wedJS','preter_upd','zmxHL','crement','isActiveCh','e\x20it\x20in\x20th','#%1','EffectCanc','eTSVg','cture','erShift','aMIhC','beginPath','XypZH','anchor','SwitchID','modifier','MLAcB','hase','ArrangeOff','SYZlz','ARRAYEVAL','ffect','ARRAYSTRUC','TotalDiceT','_baseY','pects','costTextFm','updateWait','stID','IODzA','ZFgoq','mation','endRecordi','MFNYZ','OQWPi','Command_Te','SkillMode','ftTarget','updateCach','TtDJX','randomizeN','VariableCo','DvwdG','setupDiceR','orderFmt','DICE_ROLL','YvhLx','setBaseSca','CostShowMa','evuVr','clamp','removeOldD','animation','lEffectsTe','split','ge\x5cC[0]\x20nu','aced\x20on\x20th','RegExp','needsNewDi','unt','playDiceSo','NlVSf','ctorID','ect','EnableJS','ique','_lastRank','\x20least\x20\x5cC[','tion','PreCostTex','tFormat','ENuPF','color1','alRolls','terpreter','dailySeed','sWindow','_diceRollS','\x200,\x200.9)','oiceWindow','PzcqY','diceRollCh','zdEvB','effectText','ztnXl','showBonuse','pYZQG','createNewD','gns','HyiCV','edText','CdRnP','CyJqI','ZOGKw','Format','ArmorCostI','dows','dLfnd','Dlyiq','lue','\x5cHEXCOLOR<','tOpacity','LAsWX','angle','tleWindowR','meetsDiceA','ist.\x0aIt\x20is','oveTarget','number','paySkillCo','Window','D12','lay','recording','\x5cC[5]Diffi','\x20into\x20the\x20','sWpxw','ettings','vuDZy','Title','zcrdF','AvFvL','vbvyL','7|11|14','MAX_DICE','und','CostSkillU','nCommandIn','registerCo','ity','YvBXx','View\x20Effec','DxPga','CwHdl','berSeedUni','ApplyUniqu','ctiveChain','variableCo','DicePrePos','diceSettin','erage','sVRmF','lEffectDup','replace','s:\x5cC[0]\x20Ab','getDiceRol','CostUnlimi','ToSubConta','effectList','rank','open','fadeInDura','RIfWV','GqyLZ','Dice','startNumbe','eSeed','ageWindow','GSMWJ','-item-%1','allMembers','epDmR','kyfHh','ShowVariab','_choices','changePain','hMdMp','isAnyDiceA','clearRngAs','isible','initRandom','List_RectJ','isEnabled','ext','viuuJ','choices','uuURS','createAllS','DiceAdvant','_finalizeD','_rngSeed','currentExt','Kruex','darkenColo','TargetValu','match','weaponCost','_lastPlugi','rngSeed','applyRngAs','NumberSeed','RcUSS','WMnFx','RTgJU','createSpri','LJfrk','mallest\x20to','kJfJn','rankDownCo','ZwuMj','DiceSeed','_subContai','\x5cC[17]CRIT','CommandSho','diceRollRa','return\x200','startRecor','age','filenames','updateRota','_lastAdvan','lmCHm','eGUFo','3059268uDjneJ','yilkh','ConvertPar','owRect','SpriteWind','DataDiceRa','730401BSemqf','eBonus','ConditionJ','CostUseTim','haTtb','Text','rVETL','gQAwQ','modifierBg','auIDZ','startDiceR','juVzP','VPSPY','diceRollAd','d20','gcAYS','scaleDurat','SUJko','BJsLQ','plusSign','BgType','leChoiceSe','VMptN','qhujv','parse','PostCostTe','_cache_cre','hLlDI','RandomNumb','ModifierWi','_numberCol','|4|15|5|10','increment','SUcoV','_rollDurat','uaEWo','nabled','blur','skillUserC','jddoq','0|1|4|6|5|','totalDiceR','xZsDb','lineWidth','diceCountF','fontOffset','anySpecifi','belowTarge','PJiRh','_phase','isPlaytest','getNameCos','XlYQt','ftDuration','USED!','oveEqualTa','colSpacing','%1_pan','-skill-%1','dVjTr','djSkM','Seed','SVxVa','isLearnedS','moveSprite','uffleChoic','TIXJP','failure','wBonus','uLnCy','choiceBgTy','ShowWeapon','cing','rollModDel','descriptio','round','JSON','onusEffect','EJRiX','_blurFilte','Dice_RollV','iner','showEffect','ice','%1>%2\x5cC[0]','MgjuB','addBonusCo','live','\x5cI[16]Unde','iWslC','numberDura','n_apply','hoices','YgsRN','SkillCostI','upSQi','echXL','diceRoll','itemLineRe','ngDiceWind','RmwpQ','serFmt','\x5cI[%2]%1','aboveEqual','MSmpd','preter_Plu','ApplyDaily','eInfo','ShuffleArr','phic_D20','|12|8|6|0|','border','fill','MfUgf','ResultType','tIMUy','rSeed','umberSeedU','qeTPf','ctJS','value','rollDelay','processRec','dow','hynpH','ETSWP','GNhEF','hgDGH','drawText','diceUpColo','iZgMS','VariableRe','Mlcly','%1~%2','_baseTextu','toUpperCas','mKfPc','%1\x20is\x20inco','criticalFa','ColorBorde','\x20largest\x20t','cacheData','WHFQx','serName','filters','dingPhase','PYBuK','GQzIA','Rank%1','ects','getNextInt','_waitMode','mand','AKQCC','Sys','undType','SOHRB','_scaleTarg','ager.','_smooth','atRandomNu','addRollCom','Rpfgf','WeaponIncl','setDataTyp','auto','TotalRolls','EffectList','dGxNy','advantageB','_evoMatrix','ZXWUP','ordingPhas','Color3Rati','20164eYvgol','RollEffect','setLastPlu','HkXGB','hRUCZ','_dataType','PPYzs','zHkGr','Title_BgTy','mjPhb','eEffects','_delayRoll','_randomNum','playSe','STRUCT','SubtitleLo','tedUse','eMember','SetupDiceR','updateBlur','Graphic','AdvantageW','map','Name','3950KjCpge','JilRd','4|3|2|1|0','setHandler','EiKeL','fect','VYYSU','imaEC','iceRollWin','utoEffects','jqhzK','criticalSu','Title_Rect','(×%1/%2)','%1\x5cC[0]','m_initiali','rollDurati','MaxDiceCou','Interweave','NnaVl','PSJiH','Game_Actio','_numberTex','opacity','restore','isIncluded','voMatrixSk','SkillReqID','NSyHp','qzDYH','TeyPs','WSoZw','diceRollEf','sCore','eEffect','GetDailyKe','SubtitleAb','drawTextEx','SUglP','lowTarget','status','cts','Graphic_D8','oSkillMode','_scaleDura','updateOpac','daxms','leChoices','xSmLH','version','playDiceFa','subtitle','phic_D4','ffleArray','YFYGc','modifierFm','me.','s.\x0aPlease\x20','uGKoH','endDiceRol','DataModifi','umberSeeds','FzVmX','Math_rando','ICAL\x20SUCCE','ZaeMS','fectsWindo','command357','hasSkill','phic_D10','SETTINGS','skillMpCos','XxARU','tle','success','FztSj','olor','rGCjp','BonusWindo','t\x5cC[0]\x20num','bitmap','AwxkW','targetValu','changeScal','anyBattleM','_lastModRa','initMember','xZxXg','AQsnX','_wholeRoll','miter','3|2|0|4|1','charCodeAt','_diceRollD','isPlayingQ','updateSubC','qaiYS','right','eIGtq','Graphic_D2','yPRNK','Back','VgfPC','Color2Rati','deactivate','create','aced\x20over\x20','armorCostF','EPewe','getNextRan','_rngSaveUn','DataDisadv','TiYhQ','lingPhase','indexOf','gvrmM','rankBgType','isChanging','xtAlign','rotateSpee','rmat','SkillUserA','isCommandE','vs-','VisuMZ_1_M','BonusMods','getNameExt','UpBzm','egyLS','_diceRoll','VariableID','UyhDL','TE_Trigger','deEquip','toLowerCas','ows','RngSeed','ZQzYo','elay','MkGof','wRect','canPaySkil','CzMmZ','playDiceSu','TdsdF','cnuoj','updateMove','OiVnV','ease\x20updat','row','dtEqj','rRatio','hxRNC','ams','\x5cC[2]CRITI','DataMod_Re','YDgiR','uEBkU','DataRank_R','RollSubtit','setY','qXKOD','lineJoin','ers','count','displayFmt','ArmorCostV','fykaZ','children','MessageCor','DiceDispla','\x5cC[%1]%2\x5cC','OByzh','dvantage:','C[27]lowes','teContaine','numItems','DVyCn','andomNumbe','DataRank_B','slice','jtYJF','RectJS','ing\x20a\x20requ','DiceOrderF','getFullYea','fHECj','taMmq','eTo','lowEqualTa','\x5cC[23]%1\x20%','pjEju','Zwbxl','qfjLw','tage','STeLg','VisuMZ_3_E','qofpv','WAAnn','GEyBX','rCDmN','itemPaddin','playDiceBo','Graphic_D1','nUlgD','lor','CostItemFo','RATIOS','prototype','zInCN','leWindow','prepare','nusUse','kOrLu','Effect','VisuMZ_Shu','st\x5cC[0]\x20nu','utoEffectC','EMdrm','piPOa','fects','KyfLU','gFmyh','ner','FskOa','toString','endModifie','ype','_rollingDe','DataRank4','IZVIZ','ost','_moveTarge','OvnZL','iersPhase','color3','crit_succe','LtlYP','itemCostFm','tkjHB','%1\x20%2\x20%3','drMmF','roll','geFmt','66849nOEEeG','OuBmj','Command','eSides','processEnd','dowRect','xVXWb','DyuqI','MaxUses','0|4|1|3|2','mmand','UnLTg','WeaponCost','resetRando','QJEDg','mber','endRolling','getMonth','enemyId','Roll%1','gEQeW','DgKYO','max','QfUgu','LRCZP','modUpColor','createBlur','C[24]highe','jJwBu','DiceRollsR','CostPrePos','textSizeEx','lls.','SkillUser','Value','fThff','applyDiceE','offsetY','chID','modDownCol','SubtitleTo','ifting','needsRefre','eQZyY','ier','_rngDaily','VisuMZ_2_Q','Game_Inter','uKDyJ','AllowDiceE','filter','CLiUH','update','Roll\x20for\x20\x5c','EVLds','drawCenter','none','ZjXEZ','\x5cC[16]Modi','gSeed','stValue','PdlCm','lxYaP','HOypn','T_KEYS','eRank','xUse1','subtitleBg','ShowJS','log','zUtgC','_numberVal','\x20dice\x20at\x20t','wiwTY','VisuMZ_3_I','%1\x20%2','HAUKG','isSceneBat','culty\x20Clas','random','Game_Syste','Mode','FyZEX','item','tSENH','getEffectT','ActivateJS','adQnj','fontFace','resetFontS','QcZNS','LIQgf','ollChoices','titleBgTyp','_mainConta','ShowSwitch','pow','abs','lLBQf','USMsW','PTfji','ShowUses','belowEqual','DefaultRng','\x20a\x20Tier\x20%2','gPhase','modifiers','XVGSV','Irpiu','iconIndex','VftzT','getNextFlo','updatePhas','CostWeapon','rankAdjust','hBdGY','yTIFR','ShuffleSee','4]%1\x5cC[0]','erRand','gType','EaDua','PszJW','aRfpf','DiceCount','nkWindowRe','FUrAf','PostEffect','_fadeTarge','Settings','updateScal','SpecificAc','InjectedRn','mTUhz','ItemReqVal','commandDic','ArmorInclu','isDiceBonu','_fadeDurat','uniqueSeed','1395QsNqbD','addEffects','RtFmz','rShift','umber','CMryN','cancel','HsicV','PBKEO','Core','eCfMT','createNewR','ion','BCQfz','JjCrk','zXoKF','SifIL','efhMb','JooVo'];_0x42c9=function(){return _0x3c3891;};return _0x42c9();}function _0x2d89(_0x2b7962,_0xa746bc){const _0x4b0a87=_0x42c9();return _0x2d89=function(_0x5b6e5e,_0x517981){_0x5b6e5e=_0x5b6e5e-(-0x1*0x217f+-0xd*-0x8b+-0x1b28*-0x1);let _0x3d9d68=_0x4b0a87[_0x5b6e5e];return _0x3d9d68;},_0x2d89(_0x2b7962,_0xa746bc);}Window_DiceEffectsList[_0x5db7a1(0x4ce)]=Object[_0x5db7a1(0x467)](Window_DiceListBase[_0x5db7a1(0x4ce)]),Window_DiceEffectsList[_0x5db7a1(0x4ce)][_0x5db7a1(0xeb)+'r']=Window_DiceEffectsList,Window_DiceEffectsList['prototype']['initialize']=function(_0x4d2bbe){const _0x517ad8=_0x5db7a1;Window_DiceListBase[_0x517ad8(0x4ce)]['initialize'][_0x517ad8(0x23f)](this,_0x4d2bbe);},Window_DiceEffectsList['prototype']['playOkSoun'+'d']=function(){},Window_DiceEffectsList['prototype']['playBuzzer'+_0x5db7a1(0xc3)]=function(){},Window_DiceEffectsList[_0x5db7a1(0x4ce)][_0x5db7a1(0x153)+'t']=function(){const _0x4a0f1d=_0x5db7a1,_0x38b9e9=SceneManager['_diceRollS'+_0x4a0f1d(0x2d2)]||{},_0x4b4e14=_0x38b9e9[_0x4a0f1d(0x1a1)]||[];return _0x4b4e14;};function Window_DiceBonusList(){const _0x199f0d=_0x5db7a1;this[_0x199f0d(0x244)](...arguments);}Window_DiceBonusList[_0x5db7a1(0x4ce)]=Object[_0x5db7a1(0x467)](Window_DiceListBase[_0x5db7a1(0x4ce)]),Window_DiceBonusList['prototype'][_0x5db7a1(0xeb)+'r']=Window_DiceBonusList,Window_DiceBonusList[_0x5db7a1(0x4ce)]['initialize']=function(_0x4565e4){const _0x1ef3cd=_0x5db7a1;Window_DiceListBase[_0x1ef3cd(0x4ce)]['initialize'][_0x1ef3cd(0x23f)](this,_0x4565e4);},Window_DiceBonusList[_0x5db7a1(0x4ce)][_0x5db7a1(0x1c4)+'d']=function(){const _0x363acd=_0x5db7a1;SoundManager['playDiceBo'+_0x363acd(0x4d2)]();},Window_DiceBonusList[_0x5db7a1(0x4ce)][_0x5db7a1(0x153)+'t']=function(){const _0x52efea=_0x5db7a1,_0x1c1f02=SceneManager[_0x52efea(0x2aa)+_0x52efea(0x2d2)]||{},_0x49e5ca=_0x1c1f02[_0x52efea(0x5b3)+'ts']||[];return _0x49e5ca;},Window_DiceBonusList[_0x5db7a1(0x4ce)][_0x5db7a1(0x309)]=function(_0x32c6e5){const _0x588404=_0x5db7a1,_0x1d3ad3={'KfcHU':function(_0x573b5e,_0x5a959d){return _0x573b5e>_0x5a959d;},'OiVnV':function(_0x25f7c4,_0x2aadbe){return _0x25f7c4>_0x2aadbe;},'iOggx':function(_0x334cf3,_0x5e0679){return _0x334cf3<_0x5e0679;},'IODzA':function(_0x2eccc5,_0x438490){return _0x2eccc5>=_0x438490;}};if(!_0x32c6e5)return![];if(_0x32c6e5[_0x588404(0x286)+_0x588404(0x279)]){const _0x4f59cf=$gameVariables[_0x588404(0x3b0)](_0x32c6e5['VariableCo'+'stID']),_0x3609ff=Math['max'](_0x32c6e5['VariableCo'+_0x588404(0x52e)]||0x3*-0x3d5+0x49*0x25+0x51*0x3,-0x56e*-0x1+-0x17ed+0x1280);if(_0x1d3ad3['KfcHU'](_0x3609ff,_0x4f59cf))return![];}if(_0x32c6e5['ItemCostID']){const _0x372274=$dataItems[_0x32c6e5[_0x588404(0x5c6)]],_0x5f17fe=Math[_0x588404(0x508)](_0x32c6e5[_0x588404(0x5f7)+'lue']||0x20ca+-0x1f*-0x1+-0x20e8,0x9a8*-0x3+0xbae+-0xe9*-0x13),_0x3617dc=$gameParty[_0x588404(0x4ae)](_0x372274);if(_0x1d3ad3['KfcHU'](_0x5f17fe,_0x3617dc))return![];}if(_0x32c6e5['WeaponCost'+'ID']){const _0xfdbdda=$dataWeapons[_0x32c6e5[_0x588404(0x4fe)+'ID']],_0x4be44e=Math[_0x588404(0x508)](_0x32c6e5[_0x588404(0x4fe)+_0x588404(0x514)]||-0x10e2+-0x81*-0x41+-0x6*0x2a5,0x353+0x110f+-0x1461),_0x42cea5=$gameParty['numItems'](_0xfdbdda);if(_0x1d3ad3[_0x588404(0x178)](_0x4be44e,_0x42cea5))return![];}if(_0x32c6e5['ArmorCostI'+'D']){const _0x2d9cbc=$dataArmors[_0x32c6e5[_0x588404(0x2bc)+'D']],_0x55bab1=Math['max'](_0x32c6e5[_0x588404(0x4a4)+'alue']||0xd9f+-0xbba+-0xf2*0x2,-0x24d1+0x49*0x1f+0x1bfb),_0x29cacf=$gameParty['numItems'](_0x2d9cbc);if(_0x1d3ad3[_0x588404(0x491)](_0x55bab1,_0x29cacf))return![];}if(_0x32c6e5[_0x588404(0x396)+'D']){const _0x3cb324=$gameActors['actor'](_0x32c6e5['SkillUserA'+_0x588404(0x29b)]),_0x1c9699=$dataSkills[_0x32c6e5[_0x588404(0x396)+'D']];if(!_0x3cb324[_0x588404(0x48b)+'lCost'](_0x1c9699))return![];}if(_0x32c6e5[_0x588404(0x4fa)]){const _0x3dd210=_0x32c6e5[_0x588404(0x5dd)+'s']||-0x173*0xa+-0xb53+-0x3*-0x89b,_0x116216=_0x32c6e5[_0x588404(0x4fa)]||-0x727*-0x1+0x2*-0x5a8+0x42a;if(_0x1d3ad3['iOggx'](_0x116216,0x1c56d1+0x235bd*-0x3+-0x6735a*0x1)&&_0x1d3ad3[_0x588404(0x27a)](_0x3dd210,_0x116216))return![];}if(_0x32c6e5['EnableSwit'+_0x588404(0x518)]){if(!$gameSwitches[_0x588404(0x3b0)](_0x32c6e5['EnableSwit'+_0x588404(0x518)]))return![];}if(_0x32c6e5[_0x588404(0x29d)]){if(!_0x32c6e5[_0x588404(0x29d)]())return![];}return!![];},Window_DiceBonusList[_0x5db7a1(0x4ce)][_0x5db7a1(0x47c)+'ra']=function(_0x3da3c8){const _0x5350f9=_0x5db7a1,_0x120cfa={'acXTO':function(_0x4dcd6b,_0x287c52){return _0x4dcd6b>=_0x287c52;}},_0x3ed4f6=TextManager[_0x5350f9(0x28a)][_0x5350f9(0x59f)];let _0x5dbfcf=Window_DiceListBase[_0x5350f9(0x4ce)][_0x5350f9(0x47c)+'ra'][_0x5350f9(0x23f)](this,_0x3da3c8);if(_0x3ed4f6[_0x5350f9(0x1f2)]){const _0x7fce58=_0x3da3c8[_0x5350f9(0x5dd)+'s']||-0x21e7+-0xe*-0x21e+0x443*0x1,_0x2ff63b=_0x3da3c8[_0x5350f9(0x4fa)]||0x27e*0x8+0x2f*0x10+-0x16df;if(_0x120cfa['acXTO'](_0x7fce58,_0x2ff63b))return _0x3ed4f6[_0x5350f9(0x1f2)][_0x5350f9(0x12c)]();}if(_0x3da3c8[_0x5350f9(0x2a2)+'t']){const _0x4a6ba2=_0x3ed4f6[_0x5350f9(0x277)+'t'];_0x5dbfcf=_0x4a6ba2[_0x5350f9(0x13e)](_0x3da3c8[_0x5350f9(0x2a2)+'t'],_0x5dbfcf),_0x5dbfcf=_0x5dbfcf[_0x5350f9(0x12c)]();}if(_0x3da3c8[_0x5350f9(0x351)+'xt']){const _0x326efa=_0x3ed4f6[_0x5350f9(0x277)+'t'];_0x5dbfcf=_0x326efa[_0x5350f9(0x13e)](_0x5dbfcf,_0x3da3c8['PostCostTe'+'xt']),_0x5dbfcf=_0x5dbfcf['trim']();}return _0x5dbfcf;},Window_DiceBonusList[_0x5db7a1(0x4ce)]['getNameCos'+'t']=function(_0x66d101){const _0x17e01d=_0x5db7a1,_0xe52323={'SYZlz':function(_0x2f414e,_0x3475b1){return _0x2f414e-_0x3475b1;},'ZaeMS':function(_0x54f133,_0x2eb7e1){return _0x54f133>=_0x2eb7e1;},'EVLds':function(_0x43834c,_0x3492e5){return _0x43834c+_0x3492e5;},'GqyLZ':function(_0x4de700,_0x969ebe){return _0x4de700===_0x969ebe;},'SzPqm':function(_0x258160,_0xa11aa4){return _0x258160+_0xa11aa4;},'xWCBB':function(_0x1d83e4,_0x27394e){return _0x1d83e4+_0x27394e;},'MgyFM':function(_0x3d2071,_0x32ee07){return _0x3d2071+_0x32ee07;},'AnhJd':function(_0x341cbc,_0x2401a9){return _0x341cbc>_0x2401a9;},'evuVr':function(_0x25834d,_0x90a220){return _0x25834d+_0x90a220;},'VtppG':_0x17e01d(0x4bc)+'2','PjMJs':function(_0x3a1dfc,_0x4a6eda){return _0x3a1dfc>_0x4a6eda;},'EPewe':function(_0x3068be,_0xebae00){return _0x3068be+_0xebae00;},'czmTv':_0x17e01d(0x5f8)+'2'},_0x395d22=TextManager['DICE_ROLL'][_0x17e01d(0x59f)];let _0x57aa6c=Window_DiceListBase[_0x17e01d(0x4ce)][_0x17e01d(0x36b)+'t'][_0x17e01d(0x23f)](this,_0x66d101);if(_0x66d101[_0x17e01d(0x557)]){const _0x905beb=_0x66d101[_0x17e01d(0x5dd)+'s']||-0x176c+0x1b4a+0x21*-0x1e,_0x259c58=_0x66d101[_0x17e01d(0x4fa)]||-0x1*-0x14a3+0x5*0x723+-0x455*0xd,_0xf8b2c2=_0xe52323[_0x17e01d(0x270)](_0x259c58,_0x905beb),_0x2ba929=_0x395d22[_0x17e01d(0x11f)+'t'];if(_0xe52323['ZaeMS'](_0x259c58,-0x1*0x2bf1f+0x15*0x1352e+-0xae3*0xad))_0x57aa6c+=_0xe52323[_0x17e01d(0x528)]('\x20',_0x395d22['unlimitedU'+'se']);else(_0xe52323[_0x17e01d(0x43f)](_0x259c58,-0x18bc+-0x1f61*-0x1+-0x6a3*0x1)||_0xe52323[_0x17e01d(0x2f6)](_0x259c58,-0x277+0x312+0x16*-0x7)&&_0x395d22['showUseMax'+'1'])&&(_0x57aa6c+=_0xe52323[_0x17e01d(0x222)]('\x20',_0x2ba929[_0x17e01d(0x13e)](_0x905beb,_0x259c58,_0xf8b2c2)));_0x57aa6c=_0x57aa6c[_0x17e01d(0x12c)]();}if(_0x66d101[_0x17e01d(0x286)+_0x17e01d(0x279)]&&_0x66d101[_0x17e01d(0x300)+_0x17e01d(0x5b2)]){const _0x2bf1fa=$gameVariables['value'](_0x66d101[_0x17e01d(0x286)+_0x17e01d(0x279)]),_0x34dd9c=Math[_0x17e01d(0x508)](_0x66d101[_0x17e01d(0x286)+_0x17e01d(0x52e)]||-0x26b8+0x1*-0x17c5+0x26*0x1a5,0x1692+0x7*-0x1c1+-0xa4a),_0x33681c=_0x395d22[_0x17e01d(0x2e6)+_0x17e01d(0x19d)];_0x57aa6c+=_0xe52323[_0x17e01d(0x222)]('\x20',_0x33681c[_0x17e01d(0x13e)](_0x34dd9c,_0x2bf1fa)),_0x57aa6c=_0x57aa6c['trim']();}if(_0x66d101[_0x17e01d(0x5c6)]&&_0x66d101[_0x17e01d(0x5f0)+'st']){const _0x2762a1=$dataItems[_0x66d101[_0x17e01d(0x5c6)]],_0x1f79df=Math['max'](_0x66d101[_0x17e01d(0x5f7)+'lue']||-0xa80+0x1*-0x8fb+0x137c,0x1*0x1000+-0x204e+0x104f),_0x48b9f4=$gameParty['numItems'](_0x2762a1),_0x1c8a4c=_0x395d22[_0x17e01d(0x4ec)+'t'];_0x57aa6c+=_0xe52323['SzPqm']('\x20',_0x1c8a4c[_0x17e01d(0x13e)](_0x1f79df,_0x48b9f4)),_0x57aa6c=_0x57aa6c[_0x17e01d(0x12c)]();}if(_0x66d101[_0x17e01d(0x4fe)+'ID']&&_0x66d101[_0x17e01d(0x37f)+_0x17e01d(0x1e7)]){const _0x5a81ed=$dataWeapons[_0x66d101[_0x17e01d(0x4fe)+'ID']],_0x48990a=Math[_0x17e01d(0x508)](_0x66d101[_0x17e01d(0x4fe)+_0x17e01d(0x514)]||0xd03+-0x131+0x79*-0x19,-0x18ca+-0x211d+0x39e8),_0x1cfddb=$gameParty['numItems'](_0x5a81ed),_0x256df4=_0x395d22[_0x17e01d(0x317)+_0x17e01d(0x1c3)];_0x57aa6c+=_0xe52323[_0x17e01d(0x179)]('\x20',_0x256df4['format'](_0x48990a,_0x1cfddb)),_0x57aa6c=_0x57aa6c['trim']();}if(_0x66d101['ArmorCostI'+'D']&&_0x66d101[_0x17e01d(0x101)+_0x17e01d(0x4e5)]){const _0x122fbd=$dataArmors[_0x66d101[_0x17e01d(0x2bc)+'D']],_0x1dea4e=Math['max'](_0x66d101[_0x17e01d(0x4a4)+_0x17e01d(0x1bf)]||0x13ab+0x45*0x27+-0x1e2d,-0x5*-0x305+0x1*0x223+-0x1*0x113b),_0x3db678=$gameParty['numItems'](_0x122fbd),_0x517a29=_0x395d22[_0x17e01d(0x469)+'mt'];_0x57aa6c+=_0xe52323[_0x17e01d(0x222)]('\x20',_0x517a29['format'](_0x1dea4e,_0x3db678)),_0x57aa6c=_0x57aa6c['trim']();}if(_0x66d101['SkillCostI'+'D']&&_0x66d101[_0x17e01d(0x20d)+'ost']){const _0x2927e0=$gameActors[_0x17e01d(0x154)](_0x66d101[_0x17e01d(0x477)+_0x17e01d(0x29b)]);if(_0x2927e0){const _0x789d76=$dataSkills[_0x66d101[_0x17e01d(0x396)+'D']];if(Imported[_0x17e01d(0x594)+_0x17e01d(0x24a)+_0x17e01d(0x41f)]){let _0x214969=this[_0x17e01d(0x30e)+_0x17e01d(0x234)+'xt'](_0x2927e0,_0x789d76);_0x214969=_0x214969['replace'](/\\FS\[(\d+)\]/gi,''),_0x214969=_0x214969[_0x17e01d(0x2ec)](/\\{/gi,''),_0x214969=_0x214969[_0x17e01d(0x2ec)](/\\}/gi,''),_0x57aa6c+=_0xe52323[_0x17e01d(0x115)]('\x20',_0x214969[_0x17e01d(0x12c)]()),_0x57aa6c=_0x57aa6c[_0x17e01d(0x12c)]();}else{const _0x2ace1a=_0x2927e0[_0x17e01d(0x445)+'t'](_0x789d76);_0xe52323[_0x17e01d(0x240)](_0x2ace1a,-0x5f1*-0x1+0x13e9+-0x19da)&&(_0x57aa6c+=_0xe52323[_0x17e01d(0x28e)]('\x20',_0xe52323[_0x17e01d(0xdc)][_0x17e01d(0x13e)](_0x2ace1a,TextManager[_0x17e01d(0x156)])),_0x57aa6c=_0x57aa6c[_0x17e01d(0x12c)]());const _0x20f912=_0x2927e0[_0x17e01d(0x59b)+'t'](_0x789d76);_0xe52323[_0x17e01d(0xb8)](_0x20f912,0x11f9*-0x1+-0x15*0xd9+0x23c6*0x1)&&(_0x57aa6c+=_0xe52323[_0x17e01d(0x46a)]('\x20',_0xe52323[_0x17e01d(0x176)]['format'](_0x20f912,TextManager['tpA'])),_0x57aa6c=_0x57aa6c['trim']());}}}return _0x57aa6c;},VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)]['MAX_DICE']=VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x573)][_0x5db7a1(0x2f7)][_0x5db7a1(0x40f)+'nt']??-0x1e0b+-0xa*-0x1ba+0xccc,VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)]['TotalDiceT'+_0x5db7a1(0xc8)]=function(){const _0x41768c=_0x5db7a1,_0x30dd1c={'LAsWX':function(_0x3c36d6,_0xb661cf){return _0x3c36d6===_0xb661cf;},'zXoKF':_0x41768c(0x20e),'Xeasx':function(_0x46688a,_0x177f08){return _0x46688a===_0x177f08;},'SKHVr':_0x41768c(0x450)+'e'};if(!SceneManager[_0x41768c(0x5b6)+_0x41768c(0x38b)]())return 0x5*-0x336+0x1231*0x2+0xa2a*-0x2;const _0x50164d=SceneManager[_0x41768c(0x2aa)+_0x41768c(0x2d2)]||{};let _0x1ad297=_0x50164d[_0x41768c(0x3de)]||-0xc15*0x2+-0x189*-0xb+-0x1d2*-0x4;if(_0x30dd1c[_0x41768c(0x2c3)](_0x50164d['type'],_0x30dd1c[_0x41768c(0x58d)]))_0x1ad297+=_0x50164d[_0x41768c(0x17a)]||0x2649+-0x168a+-0x1*0xfbf;else _0x30dd1c[_0x41768c(0x245)](_0x50164d[_0x41768c(0x233)],_0x30dd1c[_0x41768c(0x1c8)])&&(_0x1ad297+=Math[_0x41768c(0x553)](_0x50164d['advantage']||-0xd6c+0x122+0xc4a));return _0x1ad297=_0x1ad297[_0x41768c(0x28f)](-0x1592*-0x1+0x51*0x57+-0x3118,VisuMZ[_0x41768c(0x50f)+_0x41768c(0x20a)][_0x41768c(0x2d9)]),_0x1ad297;},VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x242)+_0x5db7a1(0x533)]=function(){const _0x182ae5=_0x5db7a1;if(!SceneManager[_0x182ae5(0x5b6)+_0x182ae5(0x38b)]())return-0xde*-0x27+-0xc9d+-0x1535;const _0x2dfa08=SceneManager[_0x182ae5(0x2aa)+_0x182ae5(0x2d2)]||{};let _0x56735f=_0x2dfa08[_0x182ae5(0x18d)];return _0x56735f+=_0x2dfa08[_0x182ae5(0x564)]||-0x147*-0x5+-0x1*-0x359+-0x9bc,_0x56735f=_0x56735f[_0x182ae5(0x28f)](0x64*0x37+0x21c3+0x373e*-0x1,0x1b00+0x2*-0xa6b+-0x624),_0x56735f;},VisuMZ[_0x5db7a1(0x50f)+_0x5db7a1(0x20a)][_0x5db7a1(0x242)+_0x5db7a1(0x4f5)]=function(){const _0x51fbcb=this['CurrentDic'+'eRank']();return[0x21bb+0x4c3+-0x267e,-0xa33+0x5*0x6da+-0x180b,0x25e4+-0xbf2*-0x1+0x4*-0xc74,0x1b58*0x1+-0x21ea+0x69a*0x1,-0x995+0x1*-0xf7d+0x191c,0x301+0x74*0x24+-0x1*0x1345,-0x5a6+0x22aa+-0x1cf0][_0x51fbcb];};var $rngSeed=function(_0x5d313f,_0x41111e,_0x4496a8){const _0x436027=_0x5db7a1,_0x245bdb={'VURDW':function(_0x2ca116,_0x382abc){return _0x2ca116===_0x382abc;}};if(_0x245bdb[_0x436027(0xd0)](_0x5d313f,undefined))return Math[_0x436027(0x541)]();return $gameSystem[_0x436027(0x561)+_0x436027(0x3d8)+_0x436027(0x1b5)+'ed'](_0x5d313f,_0x41111e,_0x4496a8);},$resetRngSeed=function(_0x45056a,_0x12e3fb,_0x181e0e){const _0x545870=_0x5db7a1;$gameSystem[_0x545870(0x4ff)+'mNumberSee'+'d'](_0x45056a,_0x12e3fb,_0x181e0e);},$dailyRngSeed=function(_0x38b87c){const _0xb0df8b=_0x5db7a1,_0x10af1c={'obCch':function(_0x5b006e,_0x5c0716,_0x25c818,_0x4cd450){return _0x5b006e(_0x5c0716,_0x25c818,_0x4cd450);}};return _0x10af1c[_0xb0df8b(0x102)]($rngSeed,_0x38b87c,!![],![]);},$resetDailyRngSeed=function(_0x503e89){const _0x5ba3d4={'adYqZ':function(_0x378898,_0x24bad4,_0x30eb71,_0x2f389e){return _0x378898(_0x24bad4,_0x30eb71,_0x2f389e);}};_0x5ba3d4['adYqZ']($resetRngSeed,_0x503e89,!![],![]);},$uniqueRngSeed=function(_0x57e4d8){const _0x85d190=_0x5db7a1,_0x4a2214={'gEQeW':function(_0x321ccb,_0x149cd6,_0x6f42ea,_0x3b98b){return _0x321ccb(_0x149cd6,_0x6f42ea,_0x3b98b);}};return _0x4a2214[_0x85d190(0x506)]($rngSeed,_0x57e4d8,![],!![]);},$resetUniqueRngSeed=function(_0x5ea2cc){const _0xb3a5aa=_0x5db7a1,_0xc2196a={'DgKYO':function(_0x2b54cc,_0x288573,_0x1babc2,_0x2b3331){return _0x2b54cc(_0x288573,_0x1babc2,_0x2b3331);}};_0xc2196a[_0xb3a5aa(0x507)]($resetRngSeed,_0x5ea2cc,![],!![]);},$dailyUniqueRngSeed=function(_0x3e507a){const _0x2be085={'SwxFZ':function(_0x55d555,_0x406c80,_0x351957,_0x37f4c6){return _0x55d555(_0x406c80,_0x351957,_0x37f4c6);}};return _0x2be085['SwxFZ']($rngSeed,_0x3e507a,!![],!![]);},$resetDailyUniqueRngSeed=function(_0x5bf13d){const _0x584853=_0x5db7a1,_0x43c10e={'uuURS':function(_0x44d6d8,_0x338500,_0x3d605a,_0x1e4d6e){return _0x44d6d8(_0x338500,_0x3d605a,_0x1e4d6e);}};_0x43c10e[_0x584853(0x30d)]($resetRngSeed,_0x5bf13d,!![],!![]);},$addDiceCount=function(_0x3e889e){const _0x3b7d6a=_0x5db7a1,_0x11aa6a={'OuBmj':function(_0x24f3e8,_0x1fe730){return _0x24f3e8===_0x1fe730;},'SUcoV':_0x3b7d6a(0x20e)},_0x5dd426=SceneManager[_0x3b7d6a(0x2aa)+_0x3b7d6a(0x2d2)]||{};_0x11aa6a[_0x3b7d6a(0x4f3)](_0x5dd426[_0x3b7d6a(0x233)],_0x11aa6a[_0x3b7d6a(0x359)])&&(_0x5dd426[_0x3b7d6a(0x17a)]=_0x5dd426[_0x3b7d6a(0x17a)]||-0x15d*0x13+-0x15d7+0x2fbe,_0x5dd426[_0x3b7d6a(0x17a)]+=_0x3e889e,_0x5dd426['advantage']=Math['round'](_0x5dd426[_0x3b7d6a(0x17a)]));},$addDiceAdvantage=function(_0x34121e){const _0x3d95d4=_0x5db7a1,_0x12ae20={'xZxXg':function(_0xeed2fc,_0x57d251){return _0xeed2fc===_0x57d251;},'JilRd':_0x3d95d4(0x450)+'e'},_0x4f6c93=SceneManager[_0x3d95d4(0x2aa)+_0x3d95d4(0x2d2)]||{};_0x12ae20[_0x3d95d4(0x455)](_0x4f6c93[_0x3d95d4(0x233)],_0x12ae20[_0x3d95d4(0x3ff)])&&(_0x4f6c93[_0x3d95d4(0x17a)]=_0x4f6c93[_0x3d95d4(0x17a)]||0x535+-0x751+0x21c,_0x4f6c93['advantage']+=_0x34121e,_0x4f6c93['advantage']=Math[_0x3d95d4(0x383)](_0x4f6c93['advantage']));},$addDiceDisadvantage=function(_0x3e4258){const _0x167ea4={'qhFdL':function(_0x92c2aa,_0x5243c8){return _0x92c2aa(_0x5243c8);}};_0x167ea4['qhFdL']($addDiceAdvantage,-_0x3e4258);},$addDiceRank=function(_0x4a472a){const _0x514dfe=_0x5db7a1,_0x4d412e=SceneManager[_0x514dfe(0x2aa)+'ettings']||{};_0x4d412e[_0x514dfe(0x564)]=_0x4d412e[_0x514dfe(0x564)]||0x1a*0x4d+0x1050+-0x1821,_0x4d412e['rankAdjust']+=_0x4a472a,_0x4d412e['rankAdjust']=Math[_0x514dfe(0x383)](_0x4d412e[_0x514dfe(0x564)]);},$addDiceModifier=function(_0x188f83){const _0x3c4618=_0x5db7a1,_0x533ef0=SceneManager[_0x3c4618(0x2aa)+_0x3c4618(0x2d2)]||{};_0x533ef0['modifiers']=_0x533ef0[_0x3c4618(0x55c)]||-0xad1+-0x2*0xd21+0x2513,_0x533ef0[_0x3c4618(0x55c)]+=_0x188f83,_0x533ef0[_0x3c4618(0x55c)]=Math['round'](_0x533ef0[_0x3c4618(0x55c)]);},$addDiceModRand=function(_0x53a0ab){const _0x41bd74=_0x5db7a1,_0x292a47=SceneManager['_diceRollS'+_0x41bd74(0x2d2)]||{};_0x292a47[_0x41bd74(0x1ca)]=_0x292a47[_0x41bd74(0x1ca)]||-0x10cc+-0x141a+0x24e6,_0x292a47[_0x41bd74(0x1ca)]+=_0x53a0ab,_0x292a47[_0x41bd74(0x1ca)]=Math[_0x41bd74(0x383)](_0x292a47[_0x41bd74(0x1ca)]);};