//=============================================================================
// VisuStella MZ - Unique Tile Effects
// VisuMZ_4_UniqueTileEffects.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_4_UniqueTileEffects = true;

var VisuMZ = VisuMZ || {};
VisuMZ.UniqueTileEffects = VisuMZ.UniqueTileEffects || {};
VisuMZ.UniqueTileEffects.version = 1.03;

//=============================================================================
/* ----------------------------------------------------------------------------
 * Slippery Tile Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Slippery:
 *
 * @param General
 *
 * @param DefaultRegions:arraynum
 * @text Default Region(s)
 * @parent General
 * @type number[]
 * @min 1
 * @max 255
 * @desc Which region(s) will be used to mark this tile type?
 * Ignore if map has <Slippery Region: x> notetag.
 * @default []
 * 
 * @param EventDefaults
 * @text Event Defaults
 * @parent General
 *
 * @param DefaultAffected:eval
 * @text Default Affected
 * @parent EventDefaults
 * @type boolean
 * @on Affected
 * @off Unaffected
 * @desc Are events affected by this tile by default?
 * @default false
 *
 * @param DefaultAvoid:eval
 * @text Default Avoid
 * @parent EventDefaults
 * @type boolean
 * @on Avoid
 * @off Normal
 * @desc Will events avoid stepping on this tile by default?
 * @default false
 *
 * @param MoveSpeed:num
 * @text Tile Move Speed
 * @parent General
 * @type number
 * @desc Forces this move speed when on this tile type.
 * Use 0 to use the character's current move speed.
 * @default 4
 *
 * @param Pattern:num
 * @text Tile Sprite Pattern
 * @parent General
 * @desc Forces this sprite pattern when on this tile type.
 * Use -1 to allow characters to freely animate.
 * @default 2
 * 
 * @param Sound
 * @text Sound Effects
 * 
 * @param Footsteps
 * @parent Sound
 *
 * @param footstepsEnabled:eval
 * @text Enabled?
 * @parent Footsteps
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Enable footstep sounds for this tile?
 * Requires VisuMZ_2_MovementEffects!
 * @default true
 *
 * @param footstepsName:str
 * @text Filename
 * @parent Footsteps
 * @type file
 * @dir audio/se/
 * @require 1
 * @desc Filename of the sound effect played.
 * Requires VisuMZ_2_MovementEffects!
 * @default Sand
 *
 * @param footstepsVolume:num
 * @text Volume
 * @parent Footsteps
 * @type number
 * @max 100
 * @desc Volume of the sound effect played.
 * Requires VisuMZ_2_MovementEffects!
 * @default 10
 *
 * @param footstepsPitch:num
 * @text Pitch
 * @parent Footsteps
 * @type number
 * @desc Pitch of the sound effect played.
 * Requires VisuMZ_2_MovementEffects!
 * @default 150
 *
 * @param footstepsPan:num
 * @text Pan
 * @parent Footsteps
 * @desc Pan of the sound effect played.
 * Requires VisuMZ_2_MovementEffects!
 * @default 0
 *
 */
/* ----------------------------------------------------------------------------
 * Force Move Tile Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ForceMove:
 *
 * @param General
 *
 * @param DefaultRegions
 * @text Default Region(s)
 * @parent General
 *
 * @param DownRegions:arraynum
 * @text Down Region(s)
 * @parent DefaultRegions
 * @type number[]
 * @min 1
 * @max 255
 * @desc Which region(s) will be used to mark this tile type?
 * Ignore if map has <Force Down Region: x> notetag.
 * @default []
 *
 * @param LeftRegions:arraynum
 * @text Left Region(s)
 * @parent DefaultRegions
 * @type number[]
 * @min 1
 * @max 255
 * @desc Which region(s) will be used to mark this tile type?
 * Ignore if map has <Force Left Region: x> notetag.
 * @default []
 *
 * @param RightRegions:arraynum
 * @text Right Region(s)
 * @parent DefaultRegions
 * @type number[]
 * @min 1
 * @max 255
 * @desc Which region(s) will be used to mark this tile type?
 * Ignore if map has <Force Right Region: x> notetag.
 * @default []
 *
 * @param UpRegions:arraynum
 * @text Up Region(s)
 * @parent DefaultRegions
 * @type number[]
 * @min 1
 * @max 255
 * @desc Which region(s) will be used to mark this tile type?
 * Ignore if map has <Force Up Region: x> notetag.
 * @default []
 * 
 * @param EventDefaults
 * @text Event Defaults
 * @parent General
 *
 * @param DefaultAffected:eval
 * @text Default Affected
 * @parent EventDefaults
 * @type boolean
 * @on Affected
 * @off Unaffected
 * @desc Are events affected by this tile by default?
 * @default false
 *
 * @param DefaultAvoid:eval
 * @text Default Avoid
 * @parent EventDefaults
 * @type boolean
 * @on Avoid
 * @off Normal
 * @desc Will events avoid stepping on this tile by default?
 * @default false
 *
 * @param MoveSpeed:num
 * @text Tile Move Speed
 * @parent General
 * @type number
 * @desc Forces this move speed when on this tile type.
 * Use 0 to use the character's current move speed.
 * @default 6
 *
 * @param Pattern:num
 * @text Tile Sprite Pattern
 * @parent General
 * @desc Forces this sprite pattern when on this tile type.
 * Use -1 to allow characters to freely animate.
 * @default 2
 * 
 * @param Sound
 * @text Sound Effects
 * 
 * @param Footsteps
 * @parent Sound
 *
 * @param footstepsEnabled:eval
 * @text Enabled?
 * @parent Footsteps
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Enable footstep sounds for this tile?
 * Requires VisuMZ_2_MovementEffects!
 * @default true
 *
 * @param footstepsName:str
 * @text Filename
 * @parent Footsteps
 * @type file
 * @dir audio/se/
 * @require 1
 * @desc Filename of the sound effect played.
 * Requires VisuMZ_2_MovementEffects!
 * @default Skill1
 *
 * @param footstepsVolume:num
 * @text Volume
 * @parent Footsteps
 * @type number
 * @max 100
 * @desc Volume of the sound effect played.
 * Requires VisuMZ_2_MovementEffects!
 * @default 10
 *
 * @param footstepsPitch:num
 * @text Pitch
 * @parent Footsteps
 * @type number
 * @desc Pitch of the sound effect played.
 * Requires VisuMZ_2_MovementEffects!
 * @default 130
 *
 * @param footstepsPan:num
 * @text Pan
 * @parent Footsteps
 * @desc Pan of the sound effect played.
 * Requires VisuMZ_2_MovementEffects!
 * @default 0
 *
 */
/* ----------------------------------------------------------------------------
 * Pitfall Tile Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Pitfall:
 *
 * @param General
 *
 * @param DefaultRegions:arraynum
 * @text Default Region(s)
 * @parent General
 * @type number[]
 * @min 1
 * @max 255
 * @desc Which region(s) will be used to mark this tile type?
 * Ignore if map has <Pitfall Region: x> notetag.
 * @default []
 * 
 * @param EventDefaults
 * @text Event Defaults
 * @parent General
 *
 * @param DefaultAffected:eval
 * @text Default Affected
 * @parent EventDefaults
 * @type boolean
 * @on Affected
 * @off Unaffected
 * @desc Are events affected by this tile by default?
 * @default false
 *
 * @param DefaultAvoid:eval
 * @text Default Avoid
 * @parent EventDefaults
 * @type boolean
 * @on Avoid
 * @off Normal
 * @desc Will events avoid stepping on this tile by default?
 * @default true
 *
 * @param EffectDuration:num
 * @text Fall Duration
 * @parent General
 * @type number
 * @min 1
 * @desc How many frames will the falling animation take?
 * @default 20
 *
 * @param DmgCalc
 * @text Damage Calculation
 *
 * @param DmgDeathAllow:eval
 * @text Allow Death?
 * @parent DmgCalc
 * @type boolean
 * @on Affected
 * @off Unaffected
 * @desc Can actors die from the damage dealt by this tile?
 * @default true
 *
 * @param DmgRate:num
 * @text Rate Damage
 * @parent DmgCalc
 * @desc What percentile of the actor's MaxHP is dealt as damage?
 * @default 0.20
 *
 * @param DmgFlat:num
 * @text Flat Damage
 * @parent DmgCalc
 * @type number
 * @desc What flat amount of damage is dealt to the actor?
 * @default 20
 * 
 * @param Sound
 * @text Sound Effects
 * 
 * @param Effect
 * @text Fall
 * @parent Sound
 *
 * @param effectName:str
 * @text Filename
 * @parent Effect
 * @type file
 * @dir audio/se/
 * @require 1
 * @desc Filename of the sound effect played.
 * @default Fall
 *
 * @param effectVolume:num
 * @text Volume
 * @parent Effect
 * @type number
 * @max 100
 * @desc Volume of the sound effect played.
 * @default 50
 *
 * @param effectPitch:num
 * @text Pitch
 * @parent Effect
 * @type number
 * @desc Pitch of the sound effect played.
 * @default 80
 *
 * @param effectPan:num
 * @text Pan
 * @parent Effect
 * @desc Pan of the sound effect played.
 * @default 0
 * 
 * @param Damage
 * @parent Sound
 *
 * @param damageName:str
 * @text Filename
 * @parent Damage
 * @type file
 * @dir audio/se/
 * @require 1
 * @desc Filename of the sound effect played.
 * @default Earth4
 *
 * @param damageVolume:num
 * @text Volume
 * @parent Damage
 * @type number
 * @max 100
 * @desc Volume of the sound effect played.
 * @default 30
 *
 * @param damagePitch:num
 * @text Pitch
 * @parent Damage
 * @type number
 * @desc Pitch of the sound effect played.
 * @default 80
 *
 * @param damagePan:num
 * @text Pan
 * @parent Damage
 * @desc Pan of the sound effect played.
 * @default 0
 *
 */
/* ----------------------------------------------------------------------------
 * Swimming Tile Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Swimming:
 *
 * @param General
 * 
 * @param EventDefaults
 * @text Event Defaults
 * @parent General
 *
 * @param DefaultAffected:eval
 * @text Default Affected
 * @parent EventDefaults
 * @type boolean
 * @on Affected
 * @off Unaffected
 * @desc Are events affected by this tile by default?
 * @default false
 *
 * @param DefaultAvoid:eval
 * @text Default Avoid
 * @parent EventDefaults
 * @type boolean
 * @on Avoid
 * @off Normal
 * @desc Will events avoid stepping on this tile by default?
 * @default true
 *
 * @param EffectDuration:num
 * @text Drowning Duration
 * @parent General
 * @type number
 * @min 1
 * @desc How many frames will the drowning animation take?
 * @default 30
 *
 * @param playerCanDrown:eval
 * @text Player Can Drown?
 * @parent General
 * @type boolean
 * @on Drown
 * @off Avoid
 * @desc Allow the player to be able to step into water tiles
 * without the ability to swim and causing player to drown?
 * @default true
 *
 * @param SwimmingDepth:num
 * @text Swimming Depth
 * @parent General
 * @type number
 * @desc How many pixels will the player character be submerged
 * when in a state of swimming?
 * @default 16
 *
 * @param MoveSpeed:num
 * @text Tile Move Speed
 * @parent General
 * @type number
 * @desc Forces this move speed when on this tile type.
 * Use 0 to use the character's current move speed.
 * @default 4
 *
 * @param DmgCalc
 * @text Damage Calculation
 *
 * @param DmgDeathAllow:eval
 * @text Allow Death?
 * @parent DmgCalc
 * @type boolean
 * @on Affected
 * @off Unaffected
 * @desc Can actors die from the damage dealt by this tile?
 * @default true
 *
 * @param DmgRate:num
 * @text Rate Damage
 * @parent DmgCalc
 * @desc What percentile of the actor's MaxHP is dealt as damage?
 * @default 0.10
 *
 * @param DmgFlat:num
 * @text Flat Damage
 * @parent DmgCalc
 * @type number
 * @desc What flat amount of damage is dealt to the actor?
 * @default 15
 * 
 * @param Sound
 * @text Sound Effects
 * 
 * @param Footsteps
 * @parent Sound
 *
 * @param footstepsEnabled:eval
 * @text Enabled?
 * @parent Footsteps
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Enable footstep sounds for this tile?
 * Requires VisuMZ_2_MovementEffects!
 * @default true
 *
 * @param footstepsName:str
 * @text Filename
 * @parent Footsteps
 * @type file
 * @dir audio/se/
 * @require 1
 * @desc Filename of the sound effect played.
 * Requires VisuMZ_2_MovementEffects!
 * @default Water1
 *
 * @param footstepsVolume:num
 * @text Volume
 * @parent Footsteps
 * @type number
 * @max 100
 * @desc Volume of the sound effect played.
 * Requires VisuMZ_2_MovementEffects!
 * @default 10
 *
 * @param footstepsPitch:num
 * @text Pitch
 * @parent Footsteps
 * @type number
 * @desc Pitch of the sound effect played.
 * Requires VisuMZ_2_MovementEffects!
 * @default 80
 *
 * @param footstepsPan:num
 * @text Pan
 * @parent Footsteps
 * @desc Pan of the sound effect played.
 * Requires VisuMZ_2_MovementEffects!
 * @default 0
 * 
 * @param Effect
 * @text Drown
 * @parent Sound
 *
 * @param effectName:str
 * @text Filename
 * @parent Effect
 * @type file
 * @dir audio/se/
 * @require 1
 * @desc Filename of the sound effect played.
 * @default Dive
 *
 * @param effectVolume:num
 * @text Volume
 * @parent Effect
 * @type number
 * @max 100
 * @desc Volume of the sound effect played.
 * @default 50
 *
 * @param effectPitch:num
 * @text Pitch
 * @parent Effect
 * @type number
 * @desc Pitch of the sound effect played.
 * @default 120
 *
 * @param effectPan:num
 * @text Pan
 * @parent Effect
 * @desc Pan of the sound effect played.
 * @default 0
 * 
 * @param Damage
 * @parent Sound
 *
 * @param damageName:str
 * @text Filename
 * @parent Damage
 * @type file
 * @dir audio/se/
 * @require 1
 * @desc Filename of the sound effect played.
 * @default Water3
 *
 * @param damageVolume:num
 * @text Volume
 * @parent Damage
 * @type number
 * @max 100
 * @desc Volume of the sound effect played.
 * @default 30
 *
 * @param damagePitch:num
 * @text Pitch
 * @parent Damage
 * @type number
 * @desc Pitch of the sound effect played.
 * @default 80
 *
 * @param damagePan:num
 * @text Pan
 * @parent Damage
 * @desc Pan of the sound effect played.
 * @default 0
 *
 */
/* ----------------------------------------------------------------------------
 * Quicksand Tile Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Quicksand:
 *
 * @param General
 *
 * @param DefaultRegions:arraynum
 * @text Default Region(s)
 * @parent General
 * @type number[]
 * @min 1
 * @max 255
 * @desc Which region(s) will be used to mark this tile type?
 * Ignore if map has <Quicksand Region: x> notetag.
 * @default []
 * 
 * @param EventDefaults
 * @text Event Defaults
 * @parent General
 *
 * @param DefaultAffected:eval
 * @text Default Affected
 * @parent EventDefaults
 * @type boolean
 * @on Affected
 * @off Unaffected
 * @desc Are events affected by this tile by default?
 * @default false
 *
 * @param DefaultAvoid:eval
 * @text Default Avoid
 * @parent EventDefaults
 * @type boolean
 * @on Avoid
 * @off Normal
 * @desc Will events avoid stepping on this tile by default?
 * @default true
 *
 * @param StepsSandSink:num
 * @text Steps to Sandsink
 * @parent General
 * @type number
 * @min 1
 * @desc How many steps will it take on quicksand before
 * sandsinking a character?
 * @default 10
 *
 * @param MoveSpeed:num
 * @text Tile Move Speed
 * @parent General
 * @type number
 * @desc Forces this move speed when on this tile type.
 * Use 0 to use the character's current move speed.
 * @default 3
 *
 * @param DmgCalc
 * @text Damage Calculation
 *
 * @param DmgDeathAllow:eval
 * @text Allow Death?
 * @parent DmgCalc
 * @type boolean
 * @on Affected
 * @off Unaffected
 * @desc Can actors die from the damage dealt by this tile?
 * @default true
 *
 * @param DmgRate:num
 * @text Rate Damage
 * @parent DmgCalc
 * @desc What percentile of the actor's MaxHP is dealt as damage?
 * @default 0.30
 *
 * @param DmgFlat:num
 * @text Flat Damage
 * @parent DmgCalc
 * @type number
 * @desc What flat amount of damage is dealt to the actor?
 * @default 40
 * 
 * @param Sound
 * @text Sound Effects
 * 
 * @param Footsteps
 * @parent Sound
 *
 * @param footstepsEnabled:eval
 * @text Enabled?
 * @parent Footsteps
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Enable footstep sounds for this tile?
 * Requires VisuMZ_2_MovementEffects!
 * @default true
 *
 * @param footstepsName:str
 * @text Filename
 * @parent Footsteps
 * @type file
 * @dir audio/se/
 * @require 1
 * @desc Filename of the sound effect played.
 * Requires VisuMZ_2_MovementEffects!
 * @default Blow2
 *
 * @param footstepsVolume:num
 * @text Volume
 * @parent Footsteps
 * @type number
 * @max 100
 * @desc Volume of the sound effect played.
 * Requires VisuMZ_2_MovementEffects!
 * @default 10
 *
 * @param footstepsPitch:num
 * @text Pitch
 * @parent Footsteps
 * @type number
 * @desc Pitch of the sound effect played.
 * Requires VisuMZ_2_MovementEffects!
 * @default 60
 *
 * @param footstepsPan:num
 * @text Pan
 * @parent Footsteps
 * @desc Pan of the sound effect played.
 * Requires VisuMZ_2_MovementEffects!
 * @default 0
 * 
 * @param Damage
 * @parent Sound
 *
 * @param damageName:str
 * @text Filename
 * @parent Damage
 * @type file
 * @dir audio/se/
 * @require 1
 * @desc Filename of the sound effect played.
 * @default Earth3
 *
 * @param damageVolume:num
 * @text Volume
 * @parent Damage
 * @type number
 * @max 100
 * @desc Volume of the sound effect played.
 * @default 30
 *
 * @param damagePitch:num
 * @text Pitch
 * @parent Damage
 * @type number
 * @desc Pitch of the sound effect played.
 * @default 120
 *
 * @param damagePan:num
 * @text Pan
 * @parent Damage
 * @desc Pan of the sound effect played.
 * @default 0
 *
 */
/* ----------------------------------------------------------------------------
 * Lava Tile Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Lava:
 *
 * @param General
 *
 * @param DefaultRegions:arraynum
 * @text Default Region(s)
 * @parent General
 * @type number[]
 * @min 1
 * @max 255
 * @desc Which region(s) will be used to mark this tile type?
 * Ignore if map has <Lava Region: x> notetag.
 * @default []
 * 
 * @param EventDefaults
 * @text Event Defaults
 * @parent General
 *
 * @param DefaultAffected:eval
 * @text Default Affected
 * @parent EventDefaults
 * @type boolean
 * @on Affected
 * @off Unaffected
 * @desc Are events affected by this tile by default?
 * @default false
 *
 * @param DefaultAvoid:eval
 * @text Default Avoid
 * @parent EventDefaults
 * @type boolean
 * @on Avoid
 * @off Normal
 * @desc Will events avoid stepping on this tile by default?
 * @default true
 *
 * @param LavaBurnEventMax:num
 * @text Event Lava Burn Max
 * @parent EventDefaults
 * @type number
 * @min 1
 * @desc Default number of times an event can suffer lava burns
 * before being erased.
 * @default 6
 *
 * @param LavaBurnTimer:num
 * @text Lava Burn Frame Delay
 * @parent General
 * @type number
 * @min 1
 * @desc Frames to delay lava burn iterations from one another.
 * Lower: less delay. Higher: larger delay.
 * @default 20
 *
 * @param DmgCalc
 * @text Damage Calculation
 *
 * @param DmgDeathAllow:eval
 * @text Allow Death?
 * @parent DmgCalc
 * @type boolean
 * @on Affected
 * @off Unaffected
 * @desc Can actors die from the damage dealt by this tile?
 * @default true
 *
 * @param DmgRate:num
 * @text Rate Damage
 * @parent DmgCalc
 * @desc What percentile of the actor's MaxHP is dealt as damage?
 * @default 0.05
 *
 * @param DmgFlat:num
 * @text Flat Damage
 * @parent DmgCalc
 * @type number
 * @desc What flat amount of damage is dealt to the actor?
 * @default 50
 *
 * @param Animation
 *
 * @param AnimationID:num
 * @text Animation ID
 * @parent Animation
 * @type animation
 * @desc Play this animation when the effect activates.
 * Requires VisuMZ_0_CoreEngine.
 * @default 0
 *
 * @param AnimationMirror:eval
 * @text Mirror Animation
 * @parent Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the effect animation?
 * Requires VisuMZ_0_CoreEngine.
 * @default false
 *
 * @param AnimationMute:eval
 * @text Mute Animation
 * @parent Animation
 * @type boolean
 * @on Mute
 * @off Normal
 * @desc Mute the effect animation?
 * Requires VisuMZ_0_CoreEngine.
 * @default false
 * 
 * @param Sound
 * @text Sound Effects
 * 
 * @param Footsteps
 * @text Footsteps
 * @parent Sound
 *
 * @param footstepsEnabled:eval
 * @text Enabled?
 * @parent Footsteps
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Enable footstep sounds for this tile?
 * Requires VisuMZ_2_MovementEffects!
 * @default true
 *
 * @param footstepsName:str
 * @text Filename
 * @parent Footsteps
 * @type file
 * @dir audio/se/
 * @require 1
 * @desc Filename of the sound effect played.
 * Requires VisuMZ_2_MovementEffects!
 * @default Fire2
 *
 * @param footstepsVolume:num
 * @text Volume
 * @parent Footsteps
 * @type number
 * @max 100
 * @desc Volume of the sound effect played.
 * Requires VisuMZ_2_MovementEffects!
 * @default 10
 *
 * @param footstepsPitch:num
 * @text Pitch
 * @parent Footsteps
 * @type number
 * @desc Pitch of the sound effect played.
 * Requires VisuMZ_2_MovementEffects!
 * @default 120
 *
 * @param footstepsPan:num
 * @text Pan
 * @parent Footsteps
 * @desc Pan of the sound effect played.
 * Requires VisuMZ_2_MovementEffects!
 * @default 0
 * 
 * @param Damage
 * @parent Sound
 *
 * @param damageName:str
 * @text Filename
 * @parent Damage
 * @type file
 * @dir audio/se/
 * @require 1
 * @desc Filename of the sound effect played.
 * @default Fire8
 *
 * @param damageVolume:num
 * @text Volume
 * @parent Damage
 * @type number
 * @max 100
 * @desc Volume of the sound effect played.
 * @default 30
 *
 * @param damagePitch:num
 * @text Pitch
 * @parent Damage
 * @type number
 * @desc Pitch of the sound effect played.
 * @default 100
 *
 * @param damagePan:num
 * @text Pan
 * @parent Damage
 * @desc Pan of the sound effect played.
 * @default 0
 *
 */
/* ----------------------------------------------------------------------------
 * Shock Tile Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Shock:
 *
 * @param General
 *
 * @param DefaultRegions:arraynum
 * @text Default Region(s)
 * @parent General
 * @type number[]
 * @min 1
 * @max 255
 * @desc Which region(s) will be used to mark this tile type?
 * Ignore if map has <Shock Region: x> notetag.
 * @default []
 * 
 * @param EventDefaults
 * @text Event Defaults
 * @parent General
 *
 * @param DefaultAffected:eval
 * @text Default Affected
 * @parent EventDefaults
 * @type boolean
 * @on Affected
 * @off Unaffected
 * @desc Are events affected by this tile by default?
 * @default false
 *
 * @param DefaultAvoid:eval
 * @text Default Avoid
 * @parent EventDefaults
 * @type boolean
 * @on Avoid
 * @off Normal
 * @desc Will events avoid stepping on this tile by default?
 * @default true
 *
 * @param ShockTimer:num
 * @text Shock Input Delay
 * @parent General
 * @type number
 * @min 1
 * @desc How many frames to wait before giving player move input?
 * Lower: less delay. Higher: larger delay.
 * @default 60
 *
 * @param DmgCalc
 * @text Damage Calculation
 *
 * @param DmgDeathAllow:eval
 * @text Allow Death?
 * @parent DmgCalc
 * @type boolean
 * @on Affected
 * @off Unaffected
 * @desc Can actors die from the damage dealt by this tile?
 * @default true
 *
 * @param DmgRate:num
 * @text Rate Damage
 * @parent DmgCalc
 * @desc What percentile of the actor's MaxHP is dealt as damage?
 * @default 0.25
 *
 * @param DmgFlat:num
 * @text Flat Damage
 * @parent DmgCalc
 * @type number
 * @desc What flat amount of damage is dealt to the actor?
 * @default 60
 *
 * @param Animation
 *
 * @param AnimationID:num
 * @text Animation ID
 * @parent Animation
 * @type animation
 * @desc Play this animation when the effect activates.
 * Requires VisuMZ_0_CoreEngine.
 * @default 0
 *
 * @param AnimationMirror:eval
 * @text Mirror Animation
 * @parent Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the effect animation?
 * Requires VisuMZ_0_CoreEngine.
 * @default false
 *
 * @param AnimationMute:eval
 * @text Mute Animation
 * @parent Animation
 * @type boolean
 * @on Mute
 * @off Normal
 * @desc Mute the effect animation?
 * Requires VisuMZ_0_CoreEngine.
 * @default false
 * 
 * @param Sound
 * @text Sound Effects
 * 
 * @param Damage
 * @parent Sound
 *
 * @param damageName:str
 * @text Filename
 * @parent Damage
 * @type file
 * @dir audio/se/
 * @require 1
 * @desc Filename of the sound effect played.
 * @default Thunder3
 *
 * @param damageVolume:num
 * @text Volume
 * @parent Damage
 * @type number
 * @max 100
 * @desc Volume of the sound effect played.
 * @default 30
 *
 * @param damagePitch:num
 * @text Pitch
 * @parent Damage
 * @type number
 * @desc Pitch of the sound effect played.
 * @default 120
 *
 * @param damagePan:num
 * @text Pan
 * @parent Damage
 * @desc Pan of the sound effect played.
 * @default 0
 *
 */
/* ----------------------------------------------------------------------------
 * Bounce Tile Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Bounce:
 *
 * @param General
 *
 * @param DefaultRegions
 * @text Default Region(s)
 * @parent General
 *
 * @param Bounce1Regions:arraynum
 * @text Bounce 1 Region(s)
 * @parent DefaultRegions
 * @type number[]
 * @min 1
 * @max 255
 * @desc Which region(s) will be used to mark this tile type?
 * Ignore if map has <Bounce 1 Region: x> notetag.
 * @default []
 *
 * @param Bounce2Regions:arraynum
 * @text Bounce 2 Region(s)
 * @parent DefaultRegions
 * @type number[]
 * @min 1
 * @max 255
 * @desc Which region(s) will be used to mark this tile type?
 * Ignore if map has <Bounce 2 Region: x> notetag.
 * @default []
 *
 * @param Bounce3Regions:arraynum
 * @text Bounce 3 Region(s)
 * @parent DefaultRegions
 * @type number[]
 * @min 1
 * @max 255
 * @desc Which region(s) will be used to mark this tile type?
 * Ignore if map has <Bounce 3 Region: x> notetag.
 * @default []
 *
 * @param Bounce4Regions:arraynum
 * @text Bounce 4 Region(s)
 * @parent DefaultRegions
 * @type number[]
 * @min 1
 * @max 255
 * @desc Which region(s) will be used to mark this tile type?
 * Ignore if map has <Bounce 4 Region: x> notetag.
 * @default []
 *
 * @param Bounce5Regions:arraynum
 * @text Bounce 5 Region(s)
 * @parent DefaultRegions
 * @type number[]
 * @min 1
 * @max 255
 * @desc Which region(s) will be used to mark this tile type?
 * Ignore if map has <Bounce 5 Region: x> notetag.
 * @default []
 *
 * @param Bounce6Regions:arraynum
 * @text Bounce 6 Region(s)
 * @parent DefaultRegions
 * @type number[]
 * @min 1
 * @max 255
 * @desc Which region(s) will be used to mark this tile type?
 * Ignore if map has <Bounce 6 Region: x> notetag.
 * @default []
 *
 * @param Bounce7Regions:arraynum
 * @text Bounce 7 Region(s)
 * @parent DefaultRegions
 * @type number[]
 * @min 1
 * @max 255
 * @desc Which region(s) will be used to mark this tile type?
 * Ignore if map has <Bounce 7 Region: x> notetag.
 * @default []
 *
 * @param Bounce8Regions:arraynum
 * @text Bounce 8 Region(s)
 * @parent DefaultRegions
 * @type number[]
 * @min 1
 * @max 255
 * @desc Which region(s) will be used to mark this tile type?
 * Ignore if map has <Bounce 8 Region: x> notetag.
 * @default []
 *
 * @param Bounce9Regions:arraynum
 * @text Bounce 9 Region(s)
 * @parent DefaultRegions
 * @type number[]
 * @min 1
 * @max 255
 * @desc Which region(s) will be used to mark this tile type?
 * Ignore if map has <Bounce 9 Region: x> notetag.
 * @default []
 * 
 * @param EventDefaults
 * @text Event Defaults
 * @parent General
 *
 * @param DefaultAffected:eval
 * @text Default Affected
 * @parent EventDefaults
 * @type boolean
 * @on Affected
 * @off Unaffected
 * @desc Are events affected by this tile by default?
 * @default false
 *
 * @param DefaultAvoid:eval
 * @text Default Avoid
 * @parent EventDefaults
 * @type boolean
 * @on Avoid
 * @off Normal
 * @desc Will events avoid stepping on this tile by default?
 * @default false
 * 
 * @param Sound
 * @text Sound Effects
 * 
 * @param Effect
 * @parent Sound
 *
 * @param effectName:str
 * @text Filename
 * @parent Effect
 * @type file
 * @dir audio/se/
 * @require 1
 * @desc Filename of the sound effect played.
 * @default Jump2
 *
 * @param effectVolume:num
 * @text Volume
 * @parent Effect
 * @type number
 * @max 100
 * @desc Volume of the sound effect played.
 * @default 50
 *
 * @param effectPitch:num
 * @text Pitch
 * @parent Effect
 * @type number
 * @desc Pitch of the sound effect played.
 * @default 120
 *
 * @param effectPan:num
 * @text Pan
 * @parent Effect
 * @desc Pan of the sound effect played.
 * @default 0
 *
 */
//=============================================================================

const _0xbd6e50=_0x3d6d;(function(_0x241662,_0x2f55af){const _0x85faf1=_0x3d6d,_0x24d2f8=_0x241662();while(!![]){try{const _0x1e6f46=-parseInt(_0x85faf1(0x33e))/0x1+-parseInt(_0x85faf1(0x367))/0x2+-parseInt(_0x85faf1(0x347))/0x3+parseInt(_0x85faf1(0x1d7))/0x4+-parseInt(_0x85faf1(0x2c6))/0x5+-parseInt(_0x85faf1(0x2cd))/0x6*(-parseInt(_0x85faf1(0x2b9))/0x7)+parseInt(_0x85faf1(0x22a))/0x8;if(_0x1e6f46===_0x2f55af)break;else _0x24d2f8['push'](_0x24d2f8['shift']());}catch(_0x5e895d){_0x24d2f8['push'](_0x24d2f8['shift']());}}}(_0x231c,0x4096d));var label=_0xbd6e50(0x247),tier=tier||0x0,dependencies=[],pluginData=$plugins[_0xbd6e50(0x298)](function(_0x5c88ba){const _0x447d5c=_0xbd6e50;return _0x5c88ba[_0x447d5c(0x2d0)]&&_0x5c88ba[_0x447d5c(0x37e)][_0x447d5c(0x2be)]('['+label+']');})[0x0];VisuMZ[label]['Settings']=VisuMZ[label]['Settings']||{},VisuMZ[_0xbd6e50(0x251)]=function(_0x29b232,_0x419b82){const _0x519e37=_0xbd6e50;for(const _0xf5865e in _0x419b82){if(_0xf5865e[_0x519e37(0x230)](/(.*):(.*)/i)){const _0x32c781=String(RegExp['$1']),_0x2963f9=String(RegExp['$2'])['toUpperCase']()[_0x519e37(0x1ce)]();let _0x478241,_0x509474,_0x48fe9b;switch(_0x2963f9){case _0x519e37(0x2e6):_0x478241=_0x419b82[_0xf5865e]!==''?Number(_0x419b82[_0xf5865e]):0x0;break;case _0x519e37(0x1fd):_0x509474=_0x419b82[_0xf5865e]!==''?JSON['parse'](_0x419b82[_0xf5865e]):[],_0x478241=_0x509474[_0x519e37(0x258)](_0x47641d=>Number(_0x47641d));break;case'EVAL':_0x478241=_0x419b82[_0xf5865e]!==''?eval(_0x419b82[_0xf5865e]):null;break;case _0x519e37(0x2e0):_0x509474=_0x419b82[_0xf5865e]!==''?JSON[_0x519e37(0x307)](_0x419b82[_0xf5865e]):[],_0x478241=_0x509474[_0x519e37(0x258)](_0x5afd78=>eval(_0x5afd78));break;case _0x519e37(0x33f):_0x478241=_0x419b82[_0xf5865e]!==''?JSON[_0x519e37(0x307)](_0x419b82[_0xf5865e]):'';break;case'ARRAYJSON':_0x509474=_0x419b82[_0xf5865e]!==''?JSON[_0x519e37(0x307)](_0x419b82[_0xf5865e]):[],_0x478241=_0x509474['map'](_0x360975=>JSON[_0x519e37(0x307)](_0x360975));break;case'FUNC':_0x478241=_0x419b82[_0xf5865e]!==''?new Function(JSON[_0x519e37(0x307)](_0x419b82[_0xf5865e])):new Function(_0x519e37(0x25e));break;case _0x519e37(0x2f7):_0x509474=_0x419b82[_0xf5865e]!==''?JSON['parse'](_0x419b82[_0xf5865e]):[],_0x478241=_0x509474[_0x519e37(0x258)](_0x3e1463=>new Function(JSON[_0x519e37(0x307)](_0x3e1463)));break;case'STR':_0x478241=_0x419b82[_0xf5865e]!==''?String(_0x419b82[_0xf5865e]):'';break;case _0x519e37(0x24a):_0x509474=_0x419b82[_0xf5865e]!==''?JSON[_0x519e37(0x307)](_0x419b82[_0xf5865e]):[],_0x478241=_0x509474['map'](_0x4208a1=>String(_0x4208a1));break;case _0x519e37(0x334):_0x48fe9b=_0x419b82[_0xf5865e]!==''?JSON[_0x519e37(0x307)](_0x419b82[_0xf5865e]):{},_0x478241=VisuMZ[_0x519e37(0x251)]({},_0x48fe9b);break;case _0x519e37(0x342):_0x509474=_0x419b82[_0xf5865e]!==''?JSON[_0x519e37(0x307)](_0x419b82[_0xf5865e]):[],_0x478241=_0x509474[_0x519e37(0x258)](_0x3c9efa=>VisuMZ[_0x519e37(0x251)]({},JSON['parse'](_0x3c9efa)));break;default:continue;}_0x29b232[_0x32c781]=_0x478241;}}return _0x29b232;},(_0x457e05=>{const _0x2ff942=_0xbd6e50,_0x133a21=_0x457e05[_0x2ff942(0x2d5)];for(const _0x146b14 of dependencies){if(!Imported[_0x146b14]){alert(_0x2ff942(0x335)[_0x2ff942(0x217)](_0x133a21,_0x146b14)),SceneManager[_0x2ff942(0x27a)]();break;}}const _0x39cbc9=_0x457e05[_0x2ff942(0x37e)];if(_0x39cbc9[_0x2ff942(0x230)](/\[Version[ ](.*?)\]/i)){const _0x21b26e=Number(RegExp['$1']);_0x21b26e!==VisuMZ[label][_0x2ff942(0x368)]&&(alert('%1\x27s\x20version\x20does\x20not\x20match\x20plugin\x27s.\x20Please\x20update\x20it\x20in\x20the\x20Plugin\x20Manager.'[_0x2ff942(0x217)](_0x133a21,_0x21b26e)),SceneManager[_0x2ff942(0x27a)]());}if(_0x39cbc9[_0x2ff942(0x230)](/\[Tier[ ](\d+)\]/i)){const _0x6b9e8a=Number(RegExp['$1']);_0x6b9e8a<tier?(alert(_0x2ff942(0x387)[_0x2ff942(0x217)](_0x133a21,_0x6b9e8a,tier)),SceneManager[_0x2ff942(0x27a)]()):tier=Math['max'](_0x6b9e8a,tier);}VisuMZ[_0x2ff942(0x251)](VisuMZ[label][_0x2ff942(0x2b5)],_0x457e05[_0x2ff942(0x2c0)]);})(pluginData),PluginManager['registerCommand'](pluginData[_0xbd6e50(0x2d5)],'PlayerSetAntiBounce',_0x3b84b3=>{const _0x239641=_0xbd6e50;VisuMZ[_0x239641(0x251)](_0x3b84b3,_0x3b84b3);const _0x2b7456=_0x3b84b3[_0x239641(0x2bf)];$gamePlayer[_0x239641(0x33d)](_0x239641(0x30a),_0x2b7456);}),PluginManager[_0xbd6e50(0x2a9)](pluginData[_0xbd6e50(0x2d5)],_0xbd6e50(0x389),_0x754f37=>{const _0x46dc60=_0xbd6e50;VisuMZ[_0x46dc60(0x251)](_0x754f37,_0x754f37);const _0x5675bc=_0x754f37[_0x46dc60(0x2bf)];$gamePlayer[_0x46dc60(0x33d)](_0x46dc60(0x2f3),_0x5675bc);}),PluginManager[_0xbd6e50(0x2a9)](pluginData[_0xbd6e50(0x2d5)],_0xbd6e50(0x2f6),_0xeaf04c=>{const _0x47ebb6=_0xbd6e50;VisuMZ['ConvertParams'](_0xeaf04c,_0xeaf04c);const _0x32ebaa=_0xeaf04c[_0x47ebb6(0x2bf)];$gamePlayer[_0x47ebb6(0x33d)]('lava',_0x32ebaa);}),PluginManager[_0xbd6e50(0x2a9)](pluginData[_0xbd6e50(0x2d5)],_0xbd6e50(0x2a8),_0x6490e9=>{const _0x2730c6=_0xbd6e50;VisuMZ[_0x2730c6(0x251)](_0x6490e9,_0x6490e9);const _0x16abf9=_0x6490e9[_0x2730c6(0x2bf)];$gamePlayer[_0x2730c6(0x33d)](_0x2730c6(0x32e),_0x16abf9);}),PluginManager[_0xbd6e50(0x2a9)](pluginData[_0xbd6e50(0x2d5)],'PlayerSetAntiShock',_0x591240=>{const _0xc610c3=_0xbd6e50;VisuMZ[_0xc610c3(0x251)](_0x591240,_0x591240);const _0x46ef5d=_0x591240[_0xc610c3(0x2bf)];$gamePlayer['setImmuneToUniqueTileType']('shock',_0x46ef5d);}),PluginManager[_0xbd6e50(0x2a9)](pluginData['name'],_0xbd6e50(0x28a),_0x2c5beb=>{const _0x325e96=_0xbd6e50;VisuMZ[_0x325e96(0x251)](_0x2c5beb,_0x2c5beb);const _0x44c91e=_0x2c5beb[_0x325e96(0x2bf)];$gamePlayer[_0x325e96(0x33d)](_0x325e96(0x248),_0x44c91e);}),PluginManager[_0xbd6e50(0x2a9)](pluginData[_0xbd6e50(0x2d5)],_0xbd6e50(0x2af),_0x2c8fbc=>{const _0x16fb10=_0xbd6e50;VisuMZ['ConvertParams'](_0x2c8fbc,_0x2c8fbc);const _0x2e8c8f=_0x2c8fbc[_0x16fb10(0x2bf)];$gamePlayer[_0x16fb10(0x33d)](_0x16fb10(0x21e),_0x2e8c8f);}),VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x240)]=function(_0x5e643c){const _0x45f03a=_0xbd6e50,_0x1272e7=[_0x45f03a(0x248),'pitfall',_0x45f03a(0x21e),_0x45f03a(0x32e),_0x45f03a(0x1f7),'shock'];return _0x5e643c?(_0x1272e7[_0x45f03a(0x311)]('down',_0x45f03a(0x383),'right','up'),_0x1272e7[_0x45f03a(0x311)]('bounce1',_0x45f03a(0x2f8),'bounce3',_0x45f03a(0x1e7),_0x45f03a(0x36a)),_0x1272e7[_0x45f03a(0x311)](_0x45f03a(0x1f2),_0x45f03a(0x2e7),_0x45f03a(0x27b),_0x45f03a(0x32a))):(_0x1272e7[_0x45f03a(0x311)](_0x45f03a(0x2f3)),_0x1272e7[_0x45f03a(0x311)](_0x45f03a(0x30a))),_0x1272e7;},VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x348)]={'slippery':{'regions':/<SLIP(?:|PERY) REGION(?:|S):[ ](.*)>/i,'terrainTags':/<SLIP(?:|PERY) (?:|TERRAIN|TERRAIN )TAG(?:|S):[ ](.*)>/i,'affected':/<(?:|CAN )SLIP>/i,'immune':/<(?:ANTI|ANTI-|ANTI )SLIP(?:|PERY)>/i,'avoid':/<(?:AVOID|BEWARE) (?:SLIP|SLIPPERY|ICE)>/i,'ignore':/<(?:IGNORE|CARELESS) (?:SLIP|SLIPPERY|ICE)>/i},'down':{'regions':/<FORCE DOWN REGION(?:|S):[ ](.*)>/i,'terrainTags':/<FORCE DOWN (?:|TERRAIN|TERRAIN )TAG(?:|S):[ ](.*)>/i},'left':{'regions':/<FORCE LEFT REGION(?:|S):[ ](.*)>/i,'terrainTags':/<FORCE LEFT (?:|TERRAIN|TERRAIN )TAG(?:|S):[ ](.*)>/i},'right':{'regions':/<FORCE RIGHT REGION(?:|S):[ ](.*)>/i,'terrainTags':/<FORCE RIGHT (?:|TERRAIN|TERRAIN )TAG(?:|S):[ ](.*)>/i},'up':{'regions':/<FORCE UP REGION(?:|S):[ ](.*)>/i,'terrainTags':/<FORCE UP (?:|TERRAIN|TERRAIN )TAG(?:|S):[ ](.*)>/i},'forceMove':{'affected':/<(?:|CAN )FORCE MOVE>/i,'immune':/<(?:ANTI|ANTI-|ANTI )FORCE MOVE>/i,'avoid':/<(?:AVOID|BEWARE) FORCE MOVE>/i,'ignore':/<(?:IGNORE|CARELESS) FORCE MOVE>/i},'pitfall':{'regions':/<PIT(?:|FALL) REGION(?:|S):[ ](.*)>/i,'terrainTags':/<PIT(?:|FALL) (?:|TERRAIN|TERRAIN )TAG(?:|S):[ ](.*)>/i,'affected':/<(?:|CAN )PIT(?:|FALL)>/i,'immune':/<(?:ANTI|ANTI-|ANTI )PIT(?:|FALL)>/i,'avoid':/<(?:AVOID|BEWARE) PIT(?:|FALL)>/i,'ignore':/<(?:IGNORE|CARELESS) PIT(?:|FALL)>/i,'mapTransfer':/<PIT(?:|FALL) (?:TRANSFER|TELEPORT):[ ](.*)>/i},'swimming':{'affected':/<(?:|CAN )DROWN(?:|ING)>/i,'immune':/<(?:ANTI|ANTI-|ANTI |CAN |)(?:SWIM|DROWN)(?:|ING|MING)>/i,'avoid':/<(?:AVOID|BEWARE) DROWN(?:|ING)>/i,'ignore':/<(?:IGNORE|CARELESS) DROWN(?:|ING)>/i},'quicksand':{'regions':/<QUICKSAND REGION(?:|S):[ ](.*)>/i,'terrainTags':/<QUICKSAND (?:|TERRAIN|TERRAIN )TAG(?:|S):[ ](.*)>/i,'affected':/<(?:|CAN )(?:|SAND)SINK>/i,'immune':/<(?:ANTI|ANTI-|ANTI )(?:QUICKSAND|SAND|SANDSINK|SINK)>/i,'avoid':/<(?:AVOID|BEWARE) QUICKSAND>/i,'ignore':/<(?:IGNORE|CARELESS) QUICKSAND>/i},'lava':{'regions':/<LAVA REGION(?:|S):[ ](.*)>/i,'terrainTags':/<LAVA (?:|TERRAIN|TERRAIN )TAG(?:|S):[ ](.*)>/i,'affected':/<(?:|CAN )(?:|LAVA|LAVA )BURN>/i,'immune':/<(?:ANTI|ANTI-|ANTI )(?:LAVA|BURN|LAVABURN|LAVA BURN)>/i,'avoid':/<(?:AVOID|BEWARE) LAVA>/i,'ignore':/<(?:IGNORE|CARELESS) LAVA>/i,'burnMax':/<(?:|LAVA|LAVA )BURN MAX:[ ](\d+)>/i},'shock':{'regions':/<SHOCK REGION(?:|S):[ ](.*)>/i,'terrainTags':/<SHOCK (?:|TERRAIN|TERRAIN )TAG(?:|S):[ ](.*)>/i,'affected':/<(?:|CAN )SHOCK>/i,'immune':/<(?:ANTI|ANTI-|ANTI )SHOCK>/i,'avoid':/<(?:AVOID|BEWARE) SHOCK>/i,'ignore':/<(?:IGNORE|CARELESS) SHOCK>/i},'bounce1':{'regions':/<BOUNCE 1 REGION(?:|S):[ ](.*)>/i,'terrainTags':/<BOUNCE 1 (?:|TERRAIN|TERRAIN )TAG(?:|S):[ ](.*)>/i},'bounce2':{'regions':/<BOUNCE 2 REGION(?:|S):[ ](.*)>/i,'terrainTags':/<BOUNCE 2 (?:|TERRAIN|TERRAIN )TAG(?:|S):[ ](.*)>/i},'bounce3':{'regions':/<BOUNCE 3 REGION(?:|S):[ ](.*)>/i,'terrainTags':/<BOUNCE 3 (?:|TERRAIN|TERRAIN )TAG(?:|S):[ ](.*)>/i},'bounce4':{'regions':/<BOUNCE 4 REGION(?:|S):[ ](.*)>/i,'terrainTags':/<BOUNCE 4 (?:|TERRAIN|TERRAIN )TAG(?:|S):[ ](.*)>/i},'bounce5':{'regions':/<BOUNCE 5 REGION(?:|S):[ ](.*)>/i,'terrainTags':/<BOUNCE 5 (?:|TERRAIN|TERRAIN )TAG(?:|S):[ ](.*)>/i},'bounce6':{'regions':/<BOUNCE 6 REGION(?:|S):[ ](.*)>/i,'terrainTags':/<BOUNCE 6 (?:|TERRAIN|TERRAIN )TAG(?:|S):[ ](.*)>/i},'bounce7':{'regions':/<BOUNCE 7 REGION(?:|S):[ ](.*)>/i,'terrainTags':/<BOUNCE 7 (?:|TERRAIN|TERRAIN )TAG(?:|S):[ ](.*)>/i},'bounce8':{'regions':/<BOUNCE 8 REGION(?:|S):[ ](.*)>/i,'terrainTags':/<BOUNCE 8 (?:|TERRAIN|TERRAIN )TAG(?:|S):[ ](.*)>/i},'bounce9':{'regions':/<BOUNCE 9 REGION(?:|S):[ ](.*)>/i,'terrainTags':/<BOUNCE 9 (?:|TERRAIN|TERRAIN )TAG(?:|S):[ ](.*)>/i},'bounce':{'affected':/<(?:|CAN )BOUNCE>/i,'immune':/<(?:ANTI|ANTI-|ANTI )BOUNCE>/i,'avoid':/<(?:AVOID|BEWARE) BOUNCE>/i,'ignore':/<(?:IGNORE|CARELESS) BOUNCE>/i}},SoundManager['UNIQUE_TILE_SFX']={'slippery':{'footstep':{'enabled':VisuMZ['UniqueTileEffects'][_0xbd6e50(0x2b5)][_0xbd6e50(0x296)]['footstepsEnabled']??!![],'name':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x296)]['footstepsName']??_0xbd6e50(0x1df),'volume':VisuMZ['UniqueTileEffects'][_0xbd6e50(0x2b5)][_0xbd6e50(0x296)]['footstepsVolume']??0xa,'pitch':VisuMZ['UniqueTileEffects'][_0xbd6e50(0x2b5)][_0xbd6e50(0x296)][_0xbd6e50(0x35a)]??0x96,'pan':VisuMZ['UniqueTileEffects'][_0xbd6e50(0x2b5)]['Slippery'][_0xbd6e50(0x1ed)]??0x0}},'forceMove':{'footstep':{'enabled':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x2b1)][_0xbd6e50(0x1ec)]??!![],'name':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x2b1)][_0xbd6e50(0x292)]??'Skill1','volume':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x2b1)][_0xbd6e50(0x256)]??0xa,'pitch':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x2b1)][_0xbd6e50(0x35a)]??0x82,'pan':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)]['ForceMove']['footstepsPan']??0x0}},'pitfall':{'effect':{'name':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x1ee)][_0xbd6e50(0x350)]??_0xbd6e50(0x1d3),'volume':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x1ee)]['effectVolume']??0x32,'pitch':VisuMZ['UniqueTileEffects'][_0xbd6e50(0x2b5)][_0xbd6e50(0x1ee)][_0xbd6e50(0x2aa)]??0x50,'pan':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x1ee)]['effectPan']??0x0},'damage':{'name':VisuMZ[_0xbd6e50(0x247)]['Settings']['Pitfall'][_0xbd6e50(0x316)]??_0xbd6e50(0x2e8),'volume':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x1ee)]['damageVolume']??0x1e,'pitch':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)]['Pitfall'][_0xbd6e50(0x1fa)]??0x50,'pan':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x1ee)][_0xbd6e50(0x25f)]??0x0}},'swimming':{'footstep':{'enabled':VisuMZ['UniqueTileEffects'][_0xbd6e50(0x2b5)][_0xbd6e50(0x31f)][_0xbd6e50(0x1ec)]??!![],'name':VisuMZ[_0xbd6e50(0x247)]['Settings'][_0xbd6e50(0x31f)][_0xbd6e50(0x292)]??_0xbd6e50(0x236),'volume':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x31f)][_0xbd6e50(0x256)]??0xa,'pitch':VisuMZ['UniqueTileEffects'][_0xbd6e50(0x2b5)]['Swimming'][_0xbd6e50(0x35a)]??0x50,'pan':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x31f)]['footstepsPan']??0x0},'effect':{'name':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)]['Swimming']['effectName']??'Dive','volume':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x31f)][_0xbd6e50(0x273)]??0x32,'pitch':VisuMZ[_0xbd6e50(0x247)]['Settings']['Swimming'][_0xbd6e50(0x2aa)]??0x78,'pan':VisuMZ['UniqueTileEffects'][_0xbd6e50(0x2b5)][_0xbd6e50(0x31f)][_0xbd6e50(0x1d8)]??0x0},'damage':{'name':VisuMZ['UniqueTileEffects']['Settings'][_0xbd6e50(0x31f)][_0xbd6e50(0x316)]??_0xbd6e50(0x380),'volume':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x31f)][_0xbd6e50(0x31e)]??0x1e,'pitch':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x31f)][_0xbd6e50(0x1fa)]??0x50,'pan':VisuMZ['UniqueTileEffects'][_0xbd6e50(0x2b5)][_0xbd6e50(0x31f)][_0xbd6e50(0x25f)]??0x0}},'quicksand':{'footstep':{'enabled':VisuMZ[_0xbd6e50(0x247)]['Settings']['Quicksand'][_0xbd6e50(0x1ec)]??!![],'name':VisuMZ[_0xbd6e50(0x247)]['Settings']['Quicksand'][_0xbd6e50(0x292)]??'Blow2','volume':VisuMZ[_0xbd6e50(0x247)]['Settings']['Quicksand'][_0xbd6e50(0x256)]??0xa,'pitch':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)]['Quicksand'][_0xbd6e50(0x35a)]??0x3c,'pan':VisuMZ['UniqueTileEffects'][_0xbd6e50(0x2b5)][_0xbd6e50(0x21c)][_0xbd6e50(0x1ed)]??0x0},'damage':{'name':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)]['Quicksand'][_0xbd6e50(0x316)]??_0xbd6e50(0x360),'volume':VisuMZ[_0xbd6e50(0x247)]['Settings'][_0xbd6e50(0x21c)][_0xbd6e50(0x31e)]??0x1e,'pitch':VisuMZ['UniqueTileEffects'][_0xbd6e50(0x2b5)][_0xbd6e50(0x21c)][_0xbd6e50(0x1fa)]??0x78,'pan':VisuMZ['UniqueTileEffects'][_0xbd6e50(0x2b5)][_0xbd6e50(0x21c)][_0xbd6e50(0x25f)]??0x0}},'lava':{'footstep':{'enabled':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x206)][_0xbd6e50(0x1ec)]??!![],'name':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x206)][_0xbd6e50(0x292)]??_0xbd6e50(0x20b),'volume':VisuMZ['UniqueTileEffects'][_0xbd6e50(0x2b5)][_0xbd6e50(0x206)][_0xbd6e50(0x256)]??0xa,'pitch':VisuMZ[_0xbd6e50(0x247)]['Settings'][_0xbd6e50(0x206)][_0xbd6e50(0x35a)]??0x78,'pan':VisuMZ[_0xbd6e50(0x247)]['Settings'][_0xbd6e50(0x206)]['footstepsPan']??0x0},'damage':{'name':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x206)][_0xbd6e50(0x316)]??_0xbd6e50(0x31a),'volume':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x206)][_0xbd6e50(0x31e)]??0x1e,'pitch':VisuMZ['UniqueTileEffects']['Settings'][_0xbd6e50(0x206)][_0xbd6e50(0x1fa)]??0x64,'pan':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)]['Lava'][_0xbd6e50(0x25f)]??0x0}},'shock':{'damage':{'name':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x304)][_0xbd6e50(0x316)]??_0xbd6e50(0x277),'volume':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x304)][_0xbd6e50(0x31e)]??0x1e,'pitch':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x304)]['damagePitch']??0x78,'pan':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x304)][_0xbd6e50(0x25f)]??0x0}},'bounce':{'effect':{'name':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x245)][_0xbd6e50(0x350)]??_0xbd6e50(0x353),'volume':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)]['Bounce'][_0xbd6e50(0x273)]??0x32,'pitch':VisuMZ['UniqueTileEffects'][_0xbd6e50(0x2b5)]['Bounce']['effectPitch']??0x78,'pan':VisuMZ['UniqueTileEffects'][_0xbd6e50(0x2b5)][_0xbd6e50(0x245)][_0xbd6e50(0x1d8)]??0x0}}},SoundManager['playUniqueTileSfx']=function(_0x44e2d7,_0x383b81,_0x55444f){const _0x3962cc=_0xbd6e50;if(_0x44e2d7===_0x3962cc(0x276))return;const _0x34a113=SoundManager['UNIQUE_TILE_SFX'][_0x44e2d7][_0x383b81];if(!_0x34a113)return;if(_0x383b81===_0x3962cc(0x30e)&&_0x55444f['constructor']===Game_Follower)return;if(_0x44e2d7===_0x3962cc(0x30a)&&_0x55444f[_0x3962cc(0x286)]===Game_Follower)return;const _0x2514ca={'name':_0x34a113[_0x3962cc(0x2d5)]||'','volume':_0x34a113[_0x3962cc(0x213)]||0x0,'pitch':_0x34a113[_0x3962cc(0x2ee)]||0x0,'pan':_0x34a113[_0x3962cc(0x1da)]||0x0};if(_0x2514ca['name']==='')return;_0x55444f&&Imported[_0x3962cc(0x2c9)]&&VisuMZ[_0x3962cc(0x385)][_0x3962cc(0x31d)](_0x2514ca,_0x55444f),AudioManager[_0x3962cc(0x32b)](_0x2514ca);},SceneManager[_0xbd6e50(0x2d7)]=function(){const _0x305919=_0xbd6e50;return this[_0x305919(0x269)]&&this[_0x305919(0x269)][_0x305919(0x286)]===Scene_Map;},Game_Map['UNIQUE_TILE_REGIONS']={'slippery':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x296)][_0xbd6e50(0x37b)],'down':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x2b1)][_0xbd6e50(0x37c)],'left':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x2b1)][_0xbd6e50(0x313)],'right':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x2b1)][_0xbd6e50(0x299)],'up':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x2b1)][_0xbd6e50(0x321)],'pitfall':VisuMZ['UniqueTileEffects'][_0xbd6e50(0x2b5)][_0xbd6e50(0x1ee)][_0xbd6e50(0x37b)],'quicksand':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x21c)][_0xbd6e50(0x37b)],'lava':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x206)][_0xbd6e50(0x37b)],'shock':VisuMZ['UniqueTileEffects'][_0xbd6e50(0x2b5)][_0xbd6e50(0x304)][_0xbd6e50(0x37b)],'bounce1':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x245)][_0xbd6e50(0x305)],'bounce2':VisuMZ[_0xbd6e50(0x247)]['Settings'][_0xbd6e50(0x245)][_0xbd6e50(0x294)],'bounce3':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x245)]['Bounce3Regions'],'bounce4':VisuMZ[_0xbd6e50(0x247)]['Settings'][_0xbd6e50(0x245)][_0xbd6e50(0x1f4)],'bounce5':VisuMZ[_0xbd6e50(0x247)]['Settings'][_0xbd6e50(0x245)][_0xbd6e50(0x282)],'bounce6':VisuMZ['UniqueTileEffects'][_0xbd6e50(0x2b5)][_0xbd6e50(0x245)][_0xbd6e50(0x34d)],'bounce7':VisuMZ['UniqueTileEffects'][_0xbd6e50(0x2b5)][_0xbd6e50(0x245)][_0xbd6e50(0x279)],'bounce8':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)]['Bounce']['Bounce8Regions'],'bounce9':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)]['Bounce'][_0xbd6e50(0x330)]},VisuMZ['UniqueTileEffects'][_0xbd6e50(0x1d9)]=Game_Map[_0xbd6e50(0x242)]['setupEvents'],Game_Map['prototype']['setupEvents']=function(){const _0x276e79=_0xbd6e50;this[_0x276e79(0x2d3)](),VisuMZ[_0x276e79(0x247)]['Game_Map_setupEvents'][_0x276e79(0x1f6)](this);},Game_Map[_0xbd6e50(0x242)]['setupUniqueTileData']=function(){this['initUniqueTileData'](),this['parseUniqueTileNotetags']();},Game_Map[_0xbd6e50(0x242)][_0xbd6e50(0x26f)]=function(){const _0x54c1a7=_0xbd6e50,_0x22355a=VisuMZ['UniqueTileEffects']['TileTypes'](!![]);this[_0x54c1a7(0x262)]={};for(const _0x196d7b of _0x22355a){this[_0x54c1a7(0x262)][_0x196d7b]={'regions':[],'terrainTags':[]},Game_Map[_0x54c1a7(0x254)][_0x196d7b]&&(this[_0x54c1a7(0x262)][_0x196d7b][_0x54c1a7(0x314)]=Game_Map[_0x54c1a7(0x254)][_0x196d7b]['clone']());}this[_0x54c1a7(0x2ec)]={},this[_0x54c1a7(0x34b)]={};},Game_Map[_0xbd6e50(0x242)][_0xbd6e50(0x379)]=function(){const _0x199bd5=_0xbd6e50,_0x5b4e80=VisuMZ[_0x199bd5(0x247)][_0x199bd5(0x348)],_0x4b4afb=$dataMap?$dataMap['note']||'':'',_0x46bc84=this[_0x199bd5(0x202)]()?this[_0x199bd5(0x202)]()[_0x199bd5(0x32c)]||'':'',_0x1d3722=VisuMZ[_0x199bd5(0x247)][_0x199bd5(0x240)](!![]);for(const _0x375857 of _0x1d3722){if(!_0x5b4e80[_0x375857])continue;_0x5b4e80[_0x375857][_0x199bd5(0x314)]&&_0x4b4afb[_0x199bd5(0x230)](_0x5b4e80[_0x375857][_0x199bd5(0x314)])&&(this[_0x199bd5(0x262)][_0x375857]['regions']=RegExp['$1'][_0x199bd5(0x214)](',')['map'](_0x42db5d=>Number(_0x42db5d)[_0x199bd5(0x30b)](0x1,0xff)));_0x5b4e80[_0x375857][_0x199bd5(0x266)]&&_0x46bc84['match'](_0x5b4e80[_0x375857][_0x199bd5(0x266)])&&(this[_0x199bd5(0x262)][_0x375857][_0x199bd5(0x266)]=RegExp['$1'][_0x199bd5(0x214)](',')[_0x199bd5(0x258)](_0x58a676=>Number(_0x58a676)['clamp'](0x1,0x7)));if(_0x5b4e80[_0x375857][_0x199bd5(0x309)]&&_0x4b4afb[_0x199bd5(0x230)](_0x5b4e80[_0x375857]['mapTransfer'])){const _0x2a2098=RegExp['$1']['split'](',')[_0x199bd5(0x258)](_0x3ee4e3=>Number(_0x3ee4e3)||0x0);this[_0x199bd5(0x34b)][_0x375857]=_0x2a2098;}}},Game_Map[_0xbd6e50(0x242)][_0xbd6e50(0x27c)]=function(_0x3f8f49){const _0xe29e33=_0xbd6e50;if(this['_uniqueTileData']===undefined)this[_0xe29e33(0x2d3)]();return this[_0xe29e33(0x262)][_0x3f8f49]||{};},Game_Map[_0xbd6e50(0x242)][_0xbd6e50(0x200)]=function(_0x1569c){const _0xa2753f=_0xbd6e50;return this[_0xa2753f(0x27c)](_0x1569c)[_0xa2753f(0x314)]||[];},Game_Map[_0xbd6e50(0x242)]['getUniqueTileTerrainTags']=function(_0x2f863b){return this['getUniqueTileData'](_0x2f863b)['terrainTags']||[];},Game_Map[_0xbd6e50(0x242)]['getUniqueTileXyType']=function(_0x19c745,_0x504116,_0x31bbf8){const _0x38be1b=_0xbd6e50;if(this[_0x38be1b(0x2ed)](_0x19c745,_0x504116))return _0x38be1b(0x21e);const _0x241da4=[_0x19c745,_0x504116];if(this[_0x38be1b(0x2ec)][_0x241da4]!==undefined){const _0xb3c180=this[_0x38be1b(0x2ec)][_0x241da4];if(!_0x31bbf8&&[_0x38be1b(0x25a),_0x38be1b(0x383),_0x38be1b(0x346),'up'][_0x38be1b(0x2be)](_0xb3c180))return _0x38be1b(0x2f3);if(!_0x31bbf8&&[_0x38be1b(0x2cf),_0x38be1b(0x2f8),_0x38be1b(0x21b),_0x38be1b(0x1e7),_0x38be1b(0x36a)][_0x38be1b(0x2be)](_0xb3c180))return _0x38be1b(0x30a);if(!_0x31bbf8&&[_0x38be1b(0x1f2),_0x38be1b(0x2e7),'bounce8',_0x38be1b(0x32a)][_0x38be1b(0x2be)](_0xb3c180))return'bounce';return _0xb3c180;}this['_uniqueTileXyType'][_0x241da4]=_0x38be1b(0x276);const _0x5593fe=this[_0x38be1b(0x359)](_0x19c745,_0x504116),_0x21b294=this[_0x38be1b(0x274)](_0x19c745,_0x504116),_0x1ce5cf=VisuMZ[_0x38be1b(0x247)][_0x38be1b(0x240)](!![]);for(const _0x28c4f7 of _0x1ce5cf){const _0x457db4=this['getUniqueTileRegions'](_0x28c4f7);if(_0x457db4[_0x38be1b(0x2be)](_0x5593fe)){this[_0x38be1b(0x2ec)][_0x241da4]=_0x28c4f7;break;}if(this['_uniqueTileXyType'][_0x241da4]!==_0x38be1b(0x276))break;const _0x51afb2=this['getUniqueTileTerrainTags'](_0x28c4f7);if(_0x51afb2[_0x38be1b(0x2be)](_0x21b294)){this[_0x38be1b(0x2ec)][_0x241da4]=_0x28c4f7;break;}if(this['_uniqueTileXyType'][_0x241da4]!==_0x38be1b(0x276))break;}if(!_0x31bbf8&&[_0x38be1b(0x25a),'left',_0x38be1b(0x346),'up'][_0x38be1b(0x2be)](this[_0x38be1b(0x2ec)][_0x241da4]))return'forceMove';if(!_0x31bbf8&&['bounce1',_0x38be1b(0x2f8),'bounce3',_0x38be1b(0x1e7),_0x38be1b(0x36a),_0x38be1b(0x1f2),_0x38be1b(0x2e7),_0x38be1b(0x27b),_0x38be1b(0x32a)][_0x38be1b(0x2be)](this[_0x38be1b(0x2ec)][_0x241da4]))return _0x38be1b(0x30a);return this[_0x38be1b(0x2ec)][_0x241da4];},Game_Map[_0xbd6e50(0x242)][_0xbd6e50(0x2dd)]=function(_0x2713d6,_0x2663ed){const _0x20eab3=_0xbd6e50;return this[_0x20eab3(0x234)](_0x2713d6,_0x2663ed,![])!==_0x20eab3(0x276);},Game_Map['prototype'][_0xbd6e50(0x1c9)]=function(_0x2825c2,_0x3734d3,_0x1ef955){const _0x2ea027=_0xbd6e50;return this[_0x2ea027(0x234)](_0x2825c2,_0x3734d3,![])===_0x1ef955;},Game_Map['prototype'][_0xbd6e50(0x1d1)]=function(_0x3465c0,_0x34cebd){return this['isUniqueTile'](_0x3465c0,_0x34cebd)&&!this['hasBelowPriorityEventsXy'](_0x3465c0,_0x34cebd);},Game_Map[_0xbd6e50(0x242)][_0xbd6e50(0x33c)]=function(_0x5056bc,_0x241a8b){const _0xc50b74=_0xbd6e50;this[_0xc50b74(0x1cc)]=!![];let _0x2009e1=![];if(this['isPassable'](_0x5056bc,_0x241a8b,0x2))_0x2009e1=!![];if(this[_0xc50b74(0x241)](_0x5056bc,_0x241a8b,0x4))_0x2009e1=!![];if(this['isPassable'](_0x5056bc,_0x241a8b,0x6))_0x2009e1=!![];if(this[_0xc50b74(0x241)](_0x5056bc,_0x241a8b,0x8))_0x2009e1=!![];return this[_0xc50b74(0x1cc)]=![],_0x2009e1;},Game_Map[_0xbd6e50(0x242)][_0xbd6e50(0x2f2)]=function(_0x3a1291,_0x14d7b2){const _0x2fa243=_0xbd6e50,_0x484902=this[_0x2fa243(0x219)](_0x3a1291,_0x14d7b2)[_0x2fa243(0x298)](_0x1a0f05=>_0x1a0f05&&!_0x1a0f05[_0x2fa243(0x278)]&&_0x1a0f05[_0x2fa243(0x2c8)]===0x0&&(_0x1a0f05[_0x2fa243(0x2a2)]()!==''||_0x1a0f05[_0x2fa243(0x280)]()>0x0));return _0x484902[_0x2fa243(0x268)]>0x0;},Game_Map[_0xbd6e50(0x242)][_0xbd6e50(0x2ed)]=function(_0x3922a6,_0x52595d){return this['checkPassageNoEvents'](_0x3922a6,_0x52595d,0x200)||this['checkPassageNoEvents'](_0x3922a6,_0x52595d,0x400);},Game_Map['prototype'][_0xbd6e50(0x2b0)]=function(_0x4100c6,_0x2a8024){const _0x4aac0f=_0xbd6e50;return this[_0x4aac0f(0x2ed)](_0x4100c6,_0x2a8024)&&this['hasBelowPriorityEventsXy'](_0x4100c6,_0x2a8024);},Game_Map[_0xbd6e50(0x242)][_0xbd6e50(0x2cb)]=function(_0x4f5c7b,_0x5d4b9b){const _0x5578ff=_0xbd6e50;return this[_0x5578ff(0x2ed)](_0x4f5c7b,_0x5d4b9b)&&!this[_0x5578ff(0x2f2)](_0x4f5c7b,_0x5d4b9b);},Game_Map[_0xbd6e50(0x242)][_0xbd6e50(0x263)]=function(_0x60cbcc,_0x132e1d,_0xb6f094){const _0x11f480=_0xbd6e50,_0x87b4ee=this[_0x11f480(0x243)](),_0x109ab1=this[_0x11f480(0x1d0)](_0x60cbcc,_0x132e1d);for(const _0x21f28b of _0x109ab1){const _0xe16bc9=_0x87b4ee[_0x21f28b];if(_0xe16bc9===undefined||_0xe16bc9===null){if($gameTemp['isPlaytest']()&&!DataManager['isEventTest']()){let _0xeabc44=_0x11f480(0x237)+'\x0a';_0xeabc44+='Click\x20\x22Copy\x20Page\x22\x20from\x20another\x20tileset\x27s\x20pages'+'\x0a',_0xeabc44+='and\x20add\x20it\x20onto\x20this\x20one.',alert(_0xeabc44),SceneManager['exit']();}}if((_0xe16bc9&0x10)!==0x0)continue;if((_0xe16bc9&_0xb6f094)===0x0)return!![];if((_0xe16bc9&_0xb6f094)===_0xb6f094)return![];}return![];},Game_CharacterBase[_0xbd6e50(0x308)]={'slippery':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x296)][_0xbd6e50(0x1e4)]??0x4,'forceMove':VisuMZ[_0xbd6e50(0x247)]['Settings']['ForceMove'][_0xbd6e50(0x1e4)]??0x6,'swimming':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x31f)][_0xbd6e50(0x1e4)]??0x4,'quicksand':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x21c)][_0xbd6e50(0x1e4)]??0x3},Game_CharacterBase[_0xbd6e50(0x1fe)]={'slippery':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)]['Slippery'][_0xbd6e50(0x21f)]??0x2,'forceMove':VisuMZ[_0xbd6e50(0x247)]['Settings'][_0xbd6e50(0x2b1)]['Pattern']??0x2},Game_CharacterBase[_0xbd6e50(0x1f0)]=VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x31f)]['playerCanDrown']??!![],Game_CharacterBase[_0xbd6e50(0x1e3)]=VisuMZ['UniqueTileEffects'][_0xbd6e50(0x2b5)][_0xbd6e50(0x31f)][_0xbd6e50(0x365)]??0x10,Game_CharacterBase['QUICKSAND_MAX_STEPS']=VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)]['Quicksand'][_0xbd6e50(0x33a)]??0xa,Game_CharacterBase[_0xbd6e50(0x244)]={'id':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x206)][_0xbd6e50(0x34c)]??0x7d,'mirror':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x206)][_0xbd6e50(0x2db)]??![],'mute':VisuMZ['UniqueTileEffects']['Settings'][_0xbd6e50(0x206)][_0xbd6e50(0x1cd)]??!![]},Game_CharacterBase[_0xbd6e50(0x333)]=VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x206)]['LavaBurnTimer']??0x14,Game_CharacterBase['LAVA_EVENT_MAX']=VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x206)][_0xbd6e50(0x23c)]??0x6,Game_CharacterBase[_0xbd6e50(0x31b)]={'id':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x304)][_0xbd6e50(0x34c)]??0x4d,'mirror':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x304)][_0xbd6e50(0x2db)]??![],'mute':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)]['Shock'][_0xbd6e50(0x1cd)]??!![]},Game_CharacterBase[_0xbd6e50(0x283)]=VisuMZ['UniqueTileEffects']['Settings'][_0xbd6e50(0x304)][_0xbd6e50(0x312)]??0x3c,VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x1cb)]=Game_CharacterBase[_0xbd6e50(0x242)]['initMembers'],Game_CharacterBase['prototype'][_0xbd6e50(0x2b7)]=function(){const _0x2d0600=_0xbd6e50;VisuMZ[_0x2d0600(0x247)]['Game_CharacterBase_initMembers'][_0x2d0600(0x1f6)](this),this[_0x2d0600(0x2d3)]();},Game_CharacterBase[_0xbd6e50(0x242)][_0xbd6e50(0x2d3)]=function(){const _0x4bfd1c=_0xbd6e50;this[_0x4bfd1c(0x37f)]={},this[_0x4bfd1c(0x1e5)]=-0x1,this['_uniqueTilePattern']=-0x1,this[_0x4bfd1c(0x215)]=0x0;},Game_CharacterBase[_0xbd6e50(0x242)]['isOnUniqueTile']=function(){const _0x5d1b0c=_0xbd6e50;if(DataManager[_0x5d1b0c(0x34f)]())return![];if(this[_0x5d1b0c(0x278)])return![];return $gameMap[_0x5d1b0c(0x2dd)](this['x'],this['y']);},Game_Vehicle[_0xbd6e50(0x242)][_0xbd6e50(0x339)]=function(){return![];},Game_CharacterBase[_0xbd6e50(0x242)]['getUniqueTileType']=function(){const _0x41bfa3=_0xbd6e50;if(DataManager[_0x41bfa3(0x34f)]())return![];if(this[_0x41bfa3(0x278)])return'none';return $gameMap[_0x41bfa3(0x234)](this['x'],this['y'],![]);},Game_Vehicle['prototype']['getUniqueTileType']=function(){return'none';},Game_CharacterBase[_0xbd6e50(0x242)][_0xbd6e50(0x2b2)]=function(_0x40d4af,_0x1fb6bd){const _0x165ef0=_0xbd6e50;if(this['_uniqueTileAffected']===undefined)this[_0x165ef0(0x2d3)]();this[_0x165ef0(0x37f)][_0x40d4af]=_0x1fb6bd,this[_0x165ef0(0x364)]();},Game_CharacterBase[_0xbd6e50(0x242)][_0xbd6e50(0x287)]=function(_0x495a9d){const _0x205048=_0xbd6e50;if(_0x495a9d==='none')return![];if(this['_erased'])return![];if(this[_0x205048(0x37f)]===undefined)this[_0x205048(0x2d3)]();return this['_uniqueTileAffected'][_0x495a9d];},Game_Player[_0xbd6e50(0x242)]['isUniqueTileAffected']=function(_0x4c5098){const _0x6df427=_0xbd6e50;if(_0x4c5098==='none')return![];if(this[_0x6df427(0x358)](_0x4c5098)){if(_0x4c5098===_0x6df427(0x21e))return!![];return![];}if(_0x4c5098==='swimming')return Game_CharacterBase[_0x6df427(0x1f0)];return!![];},Game_Follower[_0xbd6e50(0x242)]['isUniqueTileAffected']=function(_0x4441ef){const _0x2f7791=_0xbd6e50;return $gamePlayer[_0x2f7791(0x287)](_0x4441ef);},Game_CharacterBase[_0xbd6e50(0x242)][_0xbd6e50(0x2a6)]=function(){const _0x16ff72=_0xbd6e50;if(this['_erased'])return![];const _0x27a17e=this['getUniqueTileType']();if(_0x27a17e==='none')return![];return this[_0x16ff72(0x287)](_0x27a17e);},Game_CharacterBase[_0xbd6e50(0x242)][_0xbd6e50(0x22b)]=function(){const _0x5a4bc8=_0xbd6e50;this[_0x5a4bc8(0x1e5)]=-0x1,this[_0x5a4bc8(0x372)]=-0x1;},Game_CharacterBase['prototype'][_0xbd6e50(0x26a)]=function(){const _0x3874ce=_0xbd6e50;this[_0x3874ce(0x22b)]();if(!this[_0x3874ce(0x339)]())return;if($gameMap['hasBelowPriorityEventsXy'](this['x'],this['y']))return;if(this['_erased'])return;if(this[_0x3874ce(0x2a6)]()){const _0x3f5688=this[_0x3874ce(0x25d)]();this['_uniqueTileMoveSpeed']=Game_CharacterBase[_0x3874ce(0x308)][_0x3f5688]??-0x1,this['_uniqueTilePattern']=Game_CharacterBase[_0x3874ce(0x1fe)][_0x3f5688]??-0x1;}},VisuMZ['UniqueTileEffects'][_0xbd6e50(0x284)]=Game_CharacterBase[_0xbd6e50(0x242)]['realMoveSpeed'],Game_CharacterBase[_0xbd6e50(0x242)][_0xbd6e50(0x1f1)]=function(){const _0x4a8528=_0xbd6e50;if(!this['isDebugThrough']()){if(this[_0x4a8528(0x1e5)]===undefined)this[_0x4a8528(0x26a)]();if(this[_0x4a8528(0x1e5)]>0x0)return this['_uniqueTileMoveSpeed'];}return VisuMZ[_0x4a8528(0x247)][_0x4a8528(0x284)]['call'](this);},VisuMZ[_0xbd6e50(0x247)]['Game_CharacterBase_pattern']=Game_CharacterBase[_0xbd6e50(0x242)]['pattern'],Game_CharacterBase['prototype'][_0xbd6e50(0x1e8)]=function(){const _0x148175=_0xbd6e50;if(!this[_0x148175(0x351)]()){if(this[_0x148175(0x302)]&&!this['_stepAnime']){if(this[_0x148175(0x372)]===undefined)this[_0x148175(0x26a)]();if(this['_uniqueTilePattern']>-0x1)return this['_uniqueTilePattern'];}}return VisuMZ[_0x148175(0x247)][_0x148175(0x2ac)][_0x148175(0x1f6)](this);},VisuMZ['UniqueTileEffects'][_0xbd6e50(0x2ba)]=Game_Player[_0xbd6e50(0x242)][_0xbd6e50(0x36b)],Game_Player[_0xbd6e50(0x242)]['isDashing']=function(){const _0x22a87a=_0xbd6e50;if(this[_0x22a87a(0x227)]())return![];return VisuMZ[_0x22a87a(0x247)][_0x22a87a(0x2ba)]['call'](this);},Game_Player['prototype'][_0xbd6e50(0x227)]=function(){const _0x403635=_0xbd6e50;if(this[_0x403635(0x351)]())return![];if($gameMap[_0x403635(0x1c9)](this['x'],this['y'],_0x403635(0x355)))return![];if($gameMap[_0x403635(0x1c9)](this['x'],this['y'],_0x403635(0x30a)))return![];if($gameMap[_0x403635(0x2f2)](this['x'],this['y']))return![];return this[_0x403635(0x2a6)]();},VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x329)]=Game_CharacterBase[_0xbd6e50(0x242)]['locate'],Game_CharacterBase[_0xbd6e50(0x242)][_0xbd6e50(0x1e2)]=function(_0x43f296,_0x21b82d){const _0x5de993=_0xbd6e50;VisuMZ[_0x5de993(0x247)][_0x5de993(0x329)][_0x5de993(0x1f6)](this,_0x43f296,_0x21b82d),this[_0x5de993(0x26a)](),this[_0x5de993(0x27f)](0x1),this[_0x5de993(0x317)]=!![];},VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x323)]=Game_CharacterBase[_0xbd6e50(0x242)][_0xbd6e50(0x34e)],Game_CharacterBase[_0xbd6e50(0x242)]['moveStraight']=function(_0x124ff3){const _0x585054=_0xbd6e50;if(this===$gamePlayer)this[_0x585054(0x2c1)]();VisuMZ[_0x585054(0x247)][_0x585054(0x323)]['call'](this,_0x124ff3),this[_0x585054(0x26a)]();if(this[_0x585054(0x324)]())this['updateQuicksand'](0x1);this[_0x585054(0x2fb)]=_0x124ff3,this[_0x585054(0x317)]=![];},VisuMZ[_0xbd6e50(0x247)]['Game_CharacterBase_moveDiagonally']=Game_CharacterBase[_0xbd6e50(0x242)][_0xbd6e50(0x2fc)],Game_CharacterBase['prototype'][_0xbd6e50(0x2fc)]=function(_0xf99e32,_0x3631c9){const _0x2ba20d=_0xbd6e50;if(this===$gamePlayer)this['registerLastUniqueTileCoordinate']();VisuMZ[_0x2ba20d(0x247)][_0x2ba20d(0x1e0)][_0x2ba20d(0x1f6)](this,_0xf99e32,_0x3631c9),this['updateUniqueTileData'](),this['updateQuicksand'](0x2),this[_0x2ba20d(0x317)]=![];},VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x23f)]=Game_CharacterBase[_0xbd6e50(0x242)][_0xbd6e50(0x28c)],Game_CharacterBase[_0xbd6e50(0x242)][_0xbd6e50(0x28c)]=function(_0x2d1cb1,_0x50d9b3){const _0x51b4d5=_0xbd6e50;VisuMZ[_0x51b4d5(0x247)][_0x51b4d5(0x23f)][_0x51b4d5(0x1f6)](this,_0x2d1cb1,_0x50d9b3),this['updateUniqueTileData'](),this['_uniqueTileMoveDirection']=this[_0x51b4d5(0x2c4)](),this[_0x51b4d5(0x317)]=![];},VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x35f)]=Game_CharacterBase[_0xbd6e50(0x242)][_0xbd6e50(0x2e3)],Game_CharacterBase[_0xbd6e50(0x242)][_0xbd6e50(0x2e3)]=function(){const _0x10fe10=_0xbd6e50;if(this[_0x10fe10(0x224)])return!![];if(this[_0x10fe10(0x388)])return!![];return VisuMZ[_0x10fe10(0x247)][_0x10fe10(0x35f)][_0x10fe10(0x1f6)](this);},VisuMZ['UniqueTileEffects']['Game_Player_moveByInput']=Game_Player[_0xbd6e50(0x242)]['moveByInput'],Game_Player['prototype'][_0xbd6e50(0x376)]=function(){const _0x24325a=_0xbd6e50;if(this[_0x24325a(0x224)])return;if(this[_0x24325a(0x388)])return;if(this[_0x24325a(0x1ff)]!==undefined&&this[_0x24325a(0x1ff)]-->0x0)return;VisuMZ[_0x24325a(0x247)][_0x24325a(0x260)][_0x24325a(0x1f6)](this);},Game_CharacterBase[_0xbd6e50(0x242)]['doesCurrentTileHaveUniqueFootstepSfx']=function(){const _0x409408=_0xbd6e50;if($gameMap[_0x409408(0x2f2)](this['x'],this['y']))return![];if(this['isAffectedByCurrentUniqueTile']()){const _0x520620=this[_0x409408(0x25d)]();if(SoundManager[_0x409408(0x37a)][_0x520620][_0x409408(0x259)]&&SoundManager['UNIQUE_TILE_SFX'][_0x520620]['footstep'][_0x409408(0x1f5)])return!![];}return![];},VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x366)]=Game_CharacterBase['prototype']['canMakeFootstepSounds'],Game_CharacterBase['prototype'][_0xbd6e50(0x362)]=function(){const _0xaee428=_0xbd6e50;if(this[_0xaee428(0x23a)]())return![];if(this[_0xaee428(0x278)])return![];return VisuMZ[_0xaee428(0x247)][_0xaee428(0x366)]['call'](this);},VisuMZ['UniqueTileEffects'][_0xbd6e50(0x26c)]=Game_CharacterBase[_0xbd6e50(0x242)]['increaseSteps'],Game_CharacterBase[_0xbd6e50(0x242)][_0xbd6e50(0x35c)]=function(){const _0x3a38df=_0xbd6e50;VisuMZ[_0x3a38df(0x247)][_0x3a38df(0x26c)][_0x3a38df(0x1f6)](this),this[_0x3a38df(0x238)]();},VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x33b)]=Game_CharacterBase[_0xbd6e50(0x242)][_0xbd6e50(0x30c)],Game_CharacterBase[_0xbd6e50(0x242)][_0xbd6e50(0x30c)]=function(){const _0x41a62a=_0xbd6e50;VisuMZ[_0x41a62a(0x247)][_0x41a62a(0x33b)][_0x41a62a(0x1f6)](this),this['_jumpCount']===0x0&&this[_0x41a62a(0x2eb)]()&&this[_0x41a62a(0x301)]();},Game_CharacterBase[_0xbd6e50(0x242)][_0xbd6e50(0x238)]=function(){const _0xfda49a=_0xbd6e50;this[_0xfda49a(0x2eb)]()&&this['makeUniqueTileFootstepSounds'](),this===$gamePlayer&&this['meetsUniqueTileGatherConditions']()&&this[_0xfda49a(0x29f)]();},Game_CharacterBase['prototype']['canMakeUniqueTileFootstepSounds']=function(){const _0x14b1d8=_0xbd6e50;if(!Imported[_0x14b1d8(0x2c9)])return![];if(!$gameSystem[_0x14b1d8(0x362)]())return![];if(this[_0x14b1d8(0x286)]===Game_Follower&&!this[_0x14b1d8(0x2b8)]())return![];if(!this[_0x14b1d8(0x339)]())return![];if(!this[_0x14b1d8(0x2a6)]())return![];if(!this['doesCurrentTileHaveUniqueFootstepSfx']())return![];return!![];},Game_CharacterBase[_0xbd6e50(0x242)]['makeUniqueTileFootstepSounds']=function(){const _0x12425d=_0xbd6e50,_0x557270=this['getUniqueTileType']();SoundManager[_0x12425d(0x319)](_0x557270,_0x12425d(0x259),this);},Game_Player[_0xbd6e50(0x242)][_0xbd6e50(0x2c7)]=function(){const _0x114fa3=_0xbd6e50;if(this[_0x114fa3(0x351)]())return![];if(this['canSwimInWater']()){if(this[_0x114fa3(0x326)]())return this[_0x114fa3(0x270)]();if(!this['isSwimming']()&&this[_0x114fa3(0x28b)]())return!![];}const _0x2883cc=this['getLastUniqueTileCoordinate'](),_0x1999c9=$gameMap['getUniqueTileXyType'](_0x2883cc['x'],_0x2883cc['y']),_0x129717=this[_0x114fa3(0x287)](_0x1999c9),_0x2c0442=$gameMap[_0x114fa3(0x2f2)](_0x2883cc['x'],_0x2883cc['y']);if(!this[_0x114fa3(0x2a6)]()||$gameMap[_0x114fa3(0x2f2)](this['x'],this['y']))return _0x129717&&!_0x2c0442;return![];},Game_Player[_0xbd6e50(0x242)][_0xbd6e50(0x28b)]=function(){const _0x5c0dee=_0xbd6e50;return this[_0x5c0dee(0x264)]['visibleFollowers']()[_0x5c0dee(0x208)](_0x1cef42=>_0x1cef42[_0x5c0dee(0x326)]());},Game_Player['prototype'][_0xbd6e50(0x270)]=function(){const _0x4d37da=_0xbd6e50;return this[_0x4d37da(0x264)][_0x4d37da(0x221)]()[_0x4d37da(0x208)](_0x25c37a=>!_0x25c37a[_0x4d37da(0x326)]());},VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x1fb)]=Game_CharacterBase[_0xbd6e50(0x242)]['isMapPassable'],Game_CharacterBase[_0xbd6e50(0x242)][_0xbd6e50(0x371)]=function(_0x583506,_0x3892b0,_0x27954b){const _0x1536e4=_0xbd6e50;if(this['_uniqueTileSelfMove']){const _0xd07200=$gameMap[_0x1536e4(0x2d9)](_0x583506,_0x27954b),_0x70e7ec=$gameMap[_0x1536e4(0x28f)](_0x3892b0,_0x27954b),_0x84ba0c=$gameMap[_0x1536e4(0x234)](_0xd07200,_0x70e7ec,![]);if(this['isUniqueTileAvoided'](_0x84ba0c))return![];}if(this[_0x1536e4(0x287)](_0x1536e4(0x355))){if($gameMap[_0x1536e4(0x1c9)](this['x'],this['y'],'pitfall')){if(!$gameMap[_0x1536e4(0x2f2)](this['x'],this['y']))return![];}const _0x203ff5=$gameMap[_0x1536e4(0x2d9)](_0x583506,_0x27954b),_0x22ff92=$gameMap['roundYWithDirection'](_0x3892b0,_0x27954b);if($gameMap[_0x1536e4(0x1c9)](_0x203ff5,_0x22ff92,_0x1536e4(0x355)))return!![];}if(this['isUniqueTileAffected'](_0x1536e4(0x21e))){const _0xa7ace5=$gameMap[_0x1536e4(0x2d9)](_0x583506,_0x27954b),_0x5c7824=$gameMap[_0x1536e4(0x28f)](_0x3892b0,_0x27954b);if($gameMap[_0x1536e4(0x1c9)](this['x'],this['y'],_0x1536e4(0x21e))){if(!$gameMap[_0x1536e4(0x1c9)](_0xa7ace5,_0x5c7824,'swimming')){if($gameMap[_0x1536e4(0x24c)](_0xa7ace5,_0x5c7824,this[_0x1536e4(0x2d8)](_0x27954b)))return![];if($gameMap[_0x1536e4(0x33c)](_0xa7ace5,_0x5c7824))return!![];if(!VisuMZ[_0x1536e4(0x247)][_0x1536e4(0x1fb)]['call'](this,_0x583506,_0x3892b0,_0x27954b))return![];}if(!$gameMap[_0x1536e4(0x2f2)](this['x'],this['y']))return this[_0x1536e4(0x203)]();}if($gameMap[_0x1536e4(0x1c9)](_0xa7ace5,_0x5c7824,'swimming')){if($gameMap[_0x1536e4(0x24c)](this['x'],this['y'],_0x27954b))return![];return!![];}}return VisuMZ[_0x1536e4(0x247)]['Game_CharacterBase_isMapPassable']['call'](this,_0x583506,_0x3892b0,_0x27954b);},Game_Map['prototype'][_0xbd6e50(0x24c)]=function(_0x188c52,_0x2b90a6,_0x1182cf){const _0x46e131=_0xbd6e50,_0x54df95=this[_0x46e131(0x243)](),_0x1decf0=this['allTiles'](_0x188c52,_0x2b90a6);for(const _0x106ae5 of _0x1decf0){const _0x3ecb22=_0x54df95[_0x106ae5];if([0x1,0x2,0x3][_0x46e131(0x2be)](_0x1182cf)&&_0x3ecb22===0x601)return!![];if([0x4,0x1,0x2][_0x46e131(0x2be)](_0x1182cf)&&_0x3ecb22===0x603)return!![];if([0x2,0x3,0x6][_0x46e131(0x2be)](_0x1182cf)&&_0x3ecb22===0x605)return!![];if([0x7,0x4,0x3][_0x46e131(0x2be)](_0x1182cf)&&_0x3ecb22===0x602)return!![];if([0x9,0x6,0x3][_0x46e131(0x2be)](_0x1182cf)&&_0x3ecb22===0x604)return!![];if([0x7,0x8,0x9][_0x46e131(0x2be)](_0x1182cf)&&_0x3ecb22===0x608)return!![];if([0x4,0x7,0x8]['includes'](_0x1182cf)&&_0x3ecb22===0x60a)return!![];if([0x8,0x9,0x6]['includes'](_0x1182cf)&&_0x3ecb22===0x60c)return!![];}return![];},VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x361)]=Game_CharacterBase[_0xbd6e50(0x242)][_0xbd6e50(0x205)],Game_CharacterBase[_0xbd6e50(0x242)]['update']=function(){const _0x42a075=_0xbd6e50;VisuMZ[_0x42a075(0x247)][_0x42a075(0x361)]['call'](this);if(this[_0x42a075(0x370)]())this[_0x42a075(0x281)]();if(this[_0x42a075(0x201)]())this['processLavaEffect']();},Game_CharacterBase[_0xbd6e50(0x242)][_0xbd6e50(0x370)]=function(){const _0x21500a=_0xbd6e50;if(this[_0x21500a(0x22d)]())return![];if(this[_0x21500a(0x271)]())return![];if(this[_0x21500a(0x351)]())return![];if(this['_erased'])return![];if(this===$gamePlayer){if($gamePlayer['isInVehicle']())return![];if($gamePlayer[_0x21500a(0x21d)]())return![];}if(this[_0x21500a(0x286)]===Game_Follower&&$gamePlayer[_0x21500a(0x351)]())return![];if(!this['isAffectedByCurrentUniqueTile']())return![];if($gameMap['hasBelowPriorityEventsXy'](this['x'],this['y']))return![];return!![];},Game_CharacterBase[_0xbd6e50(0x242)][_0xbd6e50(0x281)]=function(){const _0x4cba6f=_0xbd6e50,_0x4266b7=this[_0x4cba6f(0x25d)]();this['processUniqueTileEffect'](_0x4266b7);},Game_CharacterBase[_0xbd6e50(0x242)]['processUniqueTileEffect']=function(_0x584be2){const _0x123808=_0xbd6e50;switch(_0x584be2){case _0x123808(0x248):this[_0x123808(0x2da)]();break;case'forceMove':this[_0x123808(0x30d)]();break;case _0x123808(0x355):this['processPitfallEffect']();break;case _0x123808(0x21e):this[_0x123808(0x345)]();break;case _0x123808(0x2fa):this[_0x123808(0x354)]();break;case _0x123808(0x30a):this[_0x123808(0x2e1)]();break;}},Game_CharacterBase[_0xbd6e50(0x242)][_0xbd6e50(0x2da)]=function(){const _0x8de2fd=_0xbd6e50;if(this[_0x8de2fd(0x317)])return;if(this[_0x8de2fd(0x286)]===Game_Follower)return;const _0x15b2d8=this[_0x8de2fd(0x2c4)]();if([0x7,0x1]['includes'](_0x15b2d8))this['setDirection'](0x4);if([0x9,0x3][_0x8de2fd(0x2be)](_0x15b2d8))this[_0x8de2fd(0x384)](0x6);this[_0x8de2fd(0x34e)](this[_0x8de2fd(0x1db)]()),this===$gamePlayer&&$gamePlayer['checkEventTriggerHere']([0x1,0x2]),!this[_0x8de2fd(0x324)]()&&(this[_0x8de2fd(0x317)]=!![]);},Game_CharacterBase[_0xbd6e50(0x242)][_0xbd6e50(0x1db)]=function(){const _0x335587=_0xbd6e50;return this['_uniqueTileMoveDirection']||this[_0x335587(0x2c4)]();},Game_CharacterBase[_0xbd6e50(0x242)]['processForceMoveEffect']=function(){const _0x301a5a=_0xbd6e50;if(this[_0x301a5a(0x286)]===Game_Follower)return;this[_0x301a5a(0x34e)](this[_0x301a5a(0x318)]()),this===$gamePlayer&&$gamePlayer[_0x301a5a(0x1dd)]([0x1,0x2]);},Game_CharacterBase[_0xbd6e50(0x242)][_0xbd6e50(0x318)]=function(){const _0x59a03e=_0xbd6e50,_0x59df7b=$gameMap['getUniqueTileXyType'](this['x'],this['y'],!![]);switch(_0x59df7b){case _0x59a03e(0x25a):return 0x2;case _0x59a03e(0x383):return 0x4;case'right':return 0x6;case'up':return 0x8;default:return 0x0;}},Game_CharacterBase[_0xbd6e50(0x242)][_0xbd6e50(0x29c)]=function(){const _0x4bbf1e=_0xbd6e50;if(this[_0x4bbf1e(0x224)])return;if($gameMap[_0x4bbf1e(0x2f2)](this['x'],this['y']))return;this['_isPitfalling']=!![],SoundManager[_0x4bbf1e(0x319)](_0x4bbf1e(0x355),_0x4bbf1e(0x30e),this);const _0x2ca105=SceneManager['_scene']['_spriteset'];if(_0x2ca105){const _0x18bfa1=_0x2ca105[_0x4bbf1e(0x377)](this);if(_0x18bfa1){_0x18bfa1[_0x4bbf1e(0x1e6)]();return;}}this[_0x4bbf1e(0x35e)]();},Game_CharacterBase[_0xbd6e50(0x242)][_0xbd6e50(0x35e)]=function(){const _0x1b1f9f=_0xbd6e50;setTimeout(this['turnOffPitfalling'][_0x1b1f9f(0x1dc)](this),0x64);},Game_CharacterBase[_0xbd6e50(0x242)][_0xbd6e50(0x2c2)]=function(){const _0x318770=_0xbd6e50;this[_0x318770(0x224)]=![];},Game_Player[_0xbd6e50(0x242)][_0xbd6e50(0x35e)]=function(){const _0x3d325b=_0xbd6e50;$gameParty[_0x3d325b(0x24f)]();if($gameParty[_0x3d325b(0x2b6)]()){this[_0x3d325b(0x264)][_0x3d325b(0x2bb)]();return;}Game_Character[_0x3d325b(0x242)]['onPitfallFinish']['call'](this);if(this[_0x3d325b(0x29d)](_0x3d325b(0x355)))return;this[_0x3d325b(0x285)](),this[_0x3d325b(0x264)]['onPitfallFinish']();if(SceneManager[_0x3d325b(0x2d7)]()){const _0x4a229e=SceneManager[_0x3d325b(0x269)][_0x3d325b(0x35b)][_0x3d325b(0x377)](this);if(_0x4a229e)_0x4a229e['restorePrePitfallScale']();}},Game_Followers['prototype'][_0xbd6e50(0x35e)]=function(){const _0x1c9a8c=_0xbd6e50;for(const _0x1f8a2b of this[_0x1c9a8c(0x272)]){if(!_0x1f8a2b)continue;_0x1f8a2b[_0x1c9a8c(0x35e)]();if(SceneManager[_0x1c9a8c(0x2d7)]()){const _0x4a1b71=SceneManager[_0x1c9a8c(0x269)][_0x1c9a8c(0x35b)][_0x1c9a8c(0x377)](_0x1f8a2b);if(_0x4a1b71)_0x4a1b71[_0x1c9a8c(0x378)]();}}},Game_Followers['prototype'][_0xbd6e50(0x2bb)]=function(){const _0x267a35=_0xbd6e50;for(const _0x45d4aa of this[_0x267a35(0x272)]){if(!_0x45d4aa)continue;_0x45d4aa['_isPitfalling']=!![];}},Game_Follower[_0xbd6e50(0x242)][_0xbd6e50(0x35e)]=function(){const _0x364a50=_0xbd6e50;if($gameParty[_0x364a50(0x2b6)]())return;Game_Character['prototype'][_0x364a50(0x35e)][_0x364a50(0x1f6)](this),this[_0x364a50(0x1e2)]($gamePlayer['x'],$gamePlayer['y']),this[_0x364a50(0x384)]($gamePlayer[_0x364a50(0x2c4)]()),this[_0x364a50(0x223)](),this[_0x364a50(0x26a)]();if($gamePlayer[_0x364a50(0x224)])return;if(SceneManager[_0x364a50(0x2d7)]()){const _0x4eb9d6=SceneManager['_scene'][_0x364a50(0x35b)][_0x364a50(0x377)](this);_0x4eb9d6&&(_0x4eb9d6[_0x364a50(0x378)](),_0x4eb9d6[_0x364a50(0x205)]());}},Game_Event[_0xbd6e50(0x242)]['onPitfallFinish']=function(){const _0x4108cb=_0xbd6e50;Game_Character[_0x4108cb(0x242)][_0x4108cb(0x35e)][_0x4108cb(0x1f6)](this),this[_0x4108cb(0x24b)]();},Game_Character[_0xbd6e50(0x242)][_0xbd6e50(0x203)]=function(){return![];},Game_Player['prototype'][_0xbd6e50(0x203)]=function(){const _0x1d5fa4=_0xbd6e50;return this[_0x1d5fa4(0x358)](_0x1d5fa4(0x21e));},Game_Follower[_0xbd6e50(0x242)][_0xbd6e50(0x203)]=function(){const _0x20fc97=_0xbd6e50;return $gamePlayer[_0x20fc97(0x203)]();},Game_Character['prototype'][_0xbd6e50(0x326)]=function(){const _0x4b6f8f=_0xbd6e50;if(!this[_0x4b6f8f(0x203)]())return![];if(!$gameMap[_0x4b6f8f(0x2ed)](this['x'],this['y']))return![];if($gameMap[_0x4b6f8f(0x2f2)](this['x'],this['y']))return![];return $gameMap[_0x4b6f8f(0x1c9)](this['x'],this['y'],'swimming');},VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x20e)]=Game_CharacterBase[_0xbd6e50(0x242)][_0xbd6e50(0x1ef)],Game_CharacterBase['prototype']['isOnBush']=function(){const _0x3d488d=_0xbd6e50;if(this['isSwimming']())return![];return VisuMZ[_0x3d488d(0x247)][_0x3d488d(0x20e)]['call'](this);},Game_Character[_0xbd6e50(0x242)][_0xbd6e50(0x20c)]=function(){const _0x173f92=_0xbd6e50;return Game_CharacterBase[_0x173f92(0x1e3)];},Game_CharacterBase[_0xbd6e50(0x242)]['processDrowningEffect']=function(){const _0x29c789=_0xbd6e50;if(this['_isDrowning'])return;if($gameMap[_0x29c789(0x2f2)](this['x'],this['y']))return;if(this[_0x29c789(0x203)]())return;this[_0x29c789(0x388)]=!![],SoundManager['playUniqueTileSfx'](_0x29c789(0x21e),'effect',this);const _0x5c0a12=SceneManager[_0x29c789(0x269)][_0x29c789(0x35b)];if(_0x5c0a12){const _0x1650b8=_0x5c0a12[_0x29c789(0x377)](this);if(_0x1650b8){_0x1650b8['startDrowningEffect']();return;}}this[_0x29c789(0x1d5)]();},Game_Follower[_0xbd6e50(0x242)][_0xbd6e50(0x345)]=function(){const _0x478427=_0xbd6e50;if($gamePlayer[_0x478427(0x32d)])return;if($gamePlayer[_0x478427(0x233)]())return;Game_Character[_0x478427(0x242)][_0x478427(0x345)][_0x478427(0x1f6)](this);},Game_CharacterBase['prototype'][_0xbd6e50(0x1d5)]=function(){const _0x1cc7f6=_0xbd6e50;setTimeout(this['turnOffDrowning'][_0x1cc7f6(0x1dc)](this),0x64);},Game_CharacterBase['prototype']['turnOffDrowning']=function(){const _0x543d21=_0xbd6e50;this[_0x543d21(0x388)]=![];},Game_Player[_0xbd6e50(0x242)][_0xbd6e50(0x1d5)]=function(){const _0x23e849=_0xbd6e50;$gameParty[_0x23e849(0x24f)]();if($gameParty[_0x23e849(0x2b6)]()){this['_followers'][_0x23e849(0x2a4)]();return;}Game_Character['prototype']['onDrowningFinish'][_0x23e849(0x1f6)](this),this[_0x23e849(0x285)](),this['_followers'][_0x23e849(0x1d5)]();if(SceneManager[_0x23e849(0x2d7)]()){const _0x4f104d=SceneManager[_0x23e849(0x269)]['_spriteset'][_0x23e849(0x377)](this);if(_0x4f104d)_0x4f104d[_0x23e849(0x24e)]();}},Game_Followers[_0xbd6e50(0x242)]['onDrowningFinish']=function(){const _0x277749=_0xbd6e50;for(const _0x49e6b8 of this[_0x277749(0x272)]){if(!_0x49e6b8)continue;_0x49e6b8[_0x277749(0x1d5)]();if(SceneManager['isSceneMap']()){const _0x2ed0c2=SceneManager[_0x277749(0x269)][_0x277749(0x35b)][_0x277749(0x377)](_0x49e6b8);if(_0x2ed0c2)_0x2ed0c2[_0x277749(0x24e)]();}}},Game_Followers[_0xbd6e50(0x242)][_0xbd6e50(0x2a4)]=function(){for(const _0x5b6ae0 of this['_data']){if(!_0x5b6ae0)continue;_0x5b6ae0['_isDrowning']=!![];}},Game_Follower[_0xbd6e50(0x242)][_0xbd6e50(0x1d5)]=function(){const _0x124de3=_0xbd6e50;if($gameParty['isAllDead']())return;Game_Character[_0x124de3(0x242)][_0x124de3(0x1d5)][_0x124de3(0x1f6)](this),this[_0x124de3(0x1e2)]($gamePlayer['x'],$gamePlayer['y']),this['setDirection']($gamePlayer[_0x124de3(0x2c4)]()),this[_0x124de3(0x223)](),this[_0x124de3(0x26a)]();if($gamePlayer[_0x124de3(0x388)])return;if(SceneManager[_0x124de3(0x2d7)]()){const _0xf37ef5=SceneManager[_0x124de3(0x269)][_0x124de3(0x35b)][_0x124de3(0x377)](this);_0xf37ef5&&(_0xf37ef5[_0x124de3(0x24e)](),_0xf37ef5[_0x124de3(0x205)]());}},Game_Event['prototype'][_0xbd6e50(0x1d5)]=function(){const _0x46daef=_0xbd6e50;Game_Character[_0x46daef(0x242)][_0x46daef(0x1d5)][_0x46daef(0x1f6)](this),this[_0x46daef(0x24b)]();},Game_Character[_0xbd6e50(0x242)]['isQuicksandSinking']=function(){const _0x3de9b2=_0xbd6e50;return this[_0x3de9b2(0x287)](_0x3de9b2(0x32e))&&this[_0x3de9b2(0x25d)]()===_0x3de9b2(0x32e)&&!$gameMap[_0x3de9b2(0x2f2)](this['x'],this['y']);},Game_Character[_0xbd6e50(0x242)][_0xbd6e50(0x338)]=function(){const _0x29740f=_0xbd6e50;return this[_0x29740f(0x215)]=this[_0x29740f(0x215)]||0x0,(this[_0x29740f(0x215)]/Game_CharacterBase[_0x29740f(0x386)])['clamp'](0x0,0x1);},Game_CharacterBase[_0xbd6e50(0x242)][_0xbd6e50(0x27f)]=function(_0x529efd){const _0x2de93f=_0xbd6e50;_0x529efd=_0x529efd||0x1,this[_0x2de93f(0x23e)]()?(this[_0x2de93f(0x215)]+=_0x529efd,this[_0x2de93f(0x215)]>=Game_CharacterBase[_0x2de93f(0x386)]&&this['onQuicksandSink']()):this['_quicksandSteps']=0x0;},Game_CharacterBase['prototype'][_0xbd6e50(0x2b3)]=function(){},Game_Player['prototype'][_0xbd6e50(0x2b3)]=function(){const _0x259498=_0xbd6e50;Input[_0x259498(0x23d)](),TouchInput[_0x259498(0x23d)](),$gameParty[_0x259498(0x24f)]();if($gameParty[_0x259498(0x2b6)]())return;Game_Character[_0x259498(0x242)]['onQuicksandSink'][_0x259498(0x1f6)](this),this['gotoLastSafestCoordinate']();},Game_Event['prototype'][_0xbd6e50(0x2b3)]=function(){const _0x14a4c7=_0xbd6e50;Game_Character[_0x14a4c7(0x242)]['onQuicksandSink'][_0x14a4c7(0x1f6)](this),this[_0x14a4c7(0x24b)]();},Game_CharacterBase[_0xbd6e50(0x242)][_0xbd6e50(0x201)]=function(){const _0x577bb3=_0xbd6e50;if(!this[_0x577bb3(0x287)](_0x577bb3(0x1f7)))return![];if(this[_0x577bb3(0x271)]())return![];if(this[_0x577bb3(0x351)]())return![];if(this[_0x577bb3(0x278)])return![];if(this===$gamePlayer){if($gamePlayer[_0x577bb3(0x233)]())return![];if($gamePlayer[_0x577bb3(0x21d)]())return![];}if(this[_0x577bb3(0x286)]===Game_Follower&&$gamePlayer[_0x577bb3(0x351)]())return![];if(!this['isAffectedByCurrentUniqueTile']())return![];if(this['getUniqueTileType']()!=='lava')return![];if($gameMap[_0x577bb3(0x2f2)](this['x'],this['y']))return![];return Graphics[_0x577bb3(0x363)]%Game_CharacterBase[_0x577bb3(0x333)]===0x0;},Game_CharacterBase['prototype']['processLavaEffect']=function(){const _0xb89917=_0xbd6e50;if(this[_0xb89917(0x286)]===Game_Follower&&!this['isVisible']())return;if(Imported[_0xb89917(0x239)]){const _0x5e8dd8=Game_CharacterBase[_0xb89917(0x244)];if(_0x5e8dd8['id']<=0x0)return;$gameTemp[_0xb89917(0x1cf)]([this],_0x5e8dd8['id'],_0x5e8dd8[_0xb89917(0x28d)],_0x5e8dd8[_0xb89917(0x1e1)]);}},Game_Player[_0xbd6e50(0x242)][_0xbd6e50(0x29b)]=function(){const _0x338c49=_0xbd6e50;$gameParty['processUniqueTileDamage']();if($gameParty[_0x338c49(0x2b6)]())return;Game_Character[_0x338c49(0x242)][_0x338c49(0x29b)][_0x338c49(0x1f6)](this);},Game_Event['prototype'][_0xbd6e50(0x29b)]=function(){const _0x47cb17=_0xbd6e50;Game_Character[_0x47cb17(0x242)][_0x47cb17(0x29b)][_0x47cb17(0x1f6)](this),this[_0x47cb17(0x325)]=this['_lavaBurnTimes']||0x0,this[_0x47cb17(0x325)]++,SoundManager['playUniqueTileSfx'](_0x47cb17(0x1f7),_0x47cb17(0x352),this),this[_0x47cb17(0x325)]>=(this['_lavaBurnMax']??Game_CharacterBase[_0x47cb17(0x218)])&&this['erase']();},Game_CharacterBase['prototype'][_0xbd6e50(0x354)]=function(){const _0x5d275c=_0xbd6e50;if(Imported['VisuMZ_0_CoreEngine']){const _0x23b408=Game_CharacterBase[_0x5d275c(0x31b)];if(_0x23b408['id']<=0x0)return;$gameTemp['requestFauxAnimation']([this],_0x23b408['id'],_0x23b408[_0x5d275c(0x28d)],_0x23b408[_0x5d275c(0x1e1)]);}},Game_Player[_0xbd6e50(0x242)][_0xbd6e50(0x354)]=function(){const _0x2d4a45=_0xbd6e50;if(this[_0x2d4a45(0x2de)])return;Input[_0x2d4a45(0x23d)](),TouchInput['clear'](),$gameParty[_0x2d4a45(0x24f)](),Game_Character[_0x2d4a45(0x242)][_0x2d4a45(0x354)]['call'](this);if($gameParty[_0x2d4a45(0x2b6)]()){this[_0x2d4a45(0x2de)]=!![];return;}this['gotoLastSafestCoordinate'](),this['_shockEffectDelay']=Game_CharacterBase['SHOCK_DELAY'];},Game_Follower[_0xbd6e50(0x242)]['processShockEffect']=function(){},Game_Event[_0xbd6e50(0x242)][_0xbd6e50(0x354)]=function(){const _0x5583cd=_0xbd6e50;if(this[_0x5583cd(0x2de)])return;Game_Character[_0x5583cd(0x242)][_0x5583cd(0x354)][_0x5583cd(0x1f6)](this),SoundManager[_0x5583cd(0x319)](_0x5583cd(0x2fa),_0x5583cd(0x352),this),this[_0x5583cd(0x2de)]=!![],setTimeout(this['erase']['bind'](this),0x64);},Game_CharacterBase[_0xbd6e50(0x242)][_0xbd6e50(0x2e1)]=function(){const _0x1cf85d=_0xbd6e50,_0x50fdce=this[_0x1cf85d(0x2d4)]();let _0x7fdb74=0x0,_0x2f951a=0x0;const _0x1a1d4d=this['bounceMoveDirection']();if([0x7,0x1][_0x1cf85d(0x2be)](_0x1a1d4d))this[_0x1cf85d(0x384)](0x4);if([0x9,0x3]['includes'](_0x1a1d4d))this['setDirection'](0x6);switch(_0x1a1d4d){case 0x2:_0x2f951a=_0x50fdce;break;case 0x4:_0x7fdb74=-_0x50fdce;break;case 0x6:_0x7fdb74=_0x50fdce;break;case 0x8:_0x2f951a=-_0x50fdce;break;}this[_0x1cf85d(0x28c)](_0x7fdb74,_0x2f951a),(_0x7fdb74!==0x0||_0x2f951a!==0x0)&&SoundManager[_0x1cf85d(0x319)](_0x1cf85d(0x30a),'effect',this);},Game_Follower[_0xbd6e50(0x242)][_0xbd6e50(0x2e1)]=function(){},Game_CharacterBase[_0xbd6e50(0x242)][_0xbd6e50(0x2e9)]=function(){const _0x127c8d=_0xbd6e50;return this[_0x127c8d(0x2fb)]||this[_0x127c8d(0x2c4)]();},Game_CharacterBase[_0xbd6e50(0x242)][_0xbd6e50(0x2d4)]=function(){const _0x924b2=_0xbd6e50,_0x4a0ed7=$gameMap[_0x924b2(0x234)](this['x'],this['y'],!![]);return[_0x924b2(0x1ea),'bounce1',_0x924b2(0x2f8),_0x924b2(0x21b),_0x924b2(0x1e7),_0x924b2(0x36a),_0x924b2(0x1f2),'bounce7',_0x924b2(0x27b),_0x924b2(0x32a)][_0x924b2(0x265)](_0x4a0ed7);},Game_Player['prototype'][_0xbd6e50(0x2d3)]=function(){const _0x282379=_0xbd6e50;Game_Character[_0x282379(0x242)][_0x282379(0x2d3)][_0x282379(0x1f6)](this),this[_0x282379(0x2cc)]={},this[_0x282379(0x336)]={};},Game_Player['prototype'][_0xbd6e50(0x358)]=function(_0x35d2a5){const _0x18865b=_0xbd6e50;if(this[_0x18865b(0x2cc)]===undefined)this[_0x18865b(0x2d3)]();if(this['_uniqueTilePartyImmune']===undefined)this[_0x18865b(0x331)]();return this['_uniqueTileCmdImmune'][_0x35d2a5]||this[_0x18865b(0x336)][_0x35d2a5];},Game_Player[_0xbd6e50(0x242)]['setImmuneToUniqueTileType']=function(_0x2965e2,_0x349208){const _0x4af3b0=_0xbd6e50;if(this[_0x4af3b0(0x2cc)]===undefined)this[_0x4af3b0(0x2d3)]();this['_uniqueTileCmdImmune'][_0x2965e2]=_0x349208,this[_0x4af3b0(0x364)]();},VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x204)]=Game_Player[_0xbd6e50(0x242)]['refresh'],Game_Player[_0xbd6e50(0x242)][_0xbd6e50(0x364)]=function(){const _0x8fa983=_0xbd6e50;VisuMZ[_0x8fa983(0x247)]['Game_Player_refresh'][_0x8fa983(0x1f6)](this),this['clearUniqueTilePartyImmunity']();},Game_Player['prototype'][_0xbd6e50(0x207)]=function(){const _0x8779f3=_0xbd6e50;this[_0x8779f3(0x336)]=undefined;},Game_Player[_0xbd6e50(0x242)][_0xbd6e50(0x331)]=function(){const _0x465496=_0xbd6e50;this[_0x465496(0x336)]={};const _0x48bd42=VisuMZ[_0x465496(0x247)][_0x465496(0x348)],_0x49bdf0=VisuMZ[_0x465496(0x247)][_0x465496(0x240)]();for(const _0x5d6b1d of _0x49bdf0){if(!_0x48bd42[_0x5d6b1d])continue;const _0x4ac719=_0x48bd42[_0x5d6b1d][_0x465496(0x30f)];_0x4ac719&&(this['_uniqueTilePartyImmune'][_0x5d6b1d]=$gameParty['hasUniqueTileEffects'](_0x4ac719));}},Game_Party[_0xbd6e50(0x242)][_0xbd6e50(0x300)]=function(_0x4b400b){const _0x1ca01e=_0xbd6e50;if(this['items']()[_0x1ca01e(0x208)](_0x289735=>_0x289735&&_0x289735['note'][_0x1ca01e(0x230)](_0x4b400b)))return!![];const _0x402eab=Game_Party[_0x1ca01e(0x2f4)]['general']['immuneReserveParty'],_0x374c40=_0x402eab?this['allMembers']():this['battleMembers']();for(const _0x30ae93 of _0x374c40){if(!_0x30ae93)continue;if(_0x30ae93[_0x1ca01e(0x2f1)]()[_0x1ca01e(0x208)](_0x511ff6=>_0x511ff6&&_0x511ff6[_0x1ca01e(0x32c)][_0x1ca01e(0x230)](_0x4b400b)))return!![];}return![];},VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2ef)]=Game_Party[_0xbd6e50(0x242)][_0xbd6e50(0x288)],Game_Party[_0xbd6e50(0x242)]['gainItem']=function(_0x23248b,_0x2d89cb,_0x28bfe0){const _0x80acfc=_0xbd6e50;VisuMZ['UniqueTileEffects'][_0x80acfc(0x2ef)][_0x80acfc(0x1f6)](this,_0x23248b,_0x2d89cb,_0x28bfe0),$gamePlayer[_0x80acfc(0x207)]();},VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x1fc)]=Game_Actor[_0xbd6e50(0x242)][_0xbd6e50(0x20d)],Game_Actor['prototype'][_0xbd6e50(0x20d)]=function(_0x2744c5,_0x5ce481){const _0x26438a=_0xbd6e50;VisuMZ[_0x26438a(0x247)][_0x26438a(0x1fc)][_0x26438a(0x1f6)](this,_0x2744c5,_0x5ce481),$gamePlayer[_0x26438a(0x207)]();},VisuMZ['UniqueTileEffects'][_0xbd6e50(0x344)]=Game_Actor[_0xbd6e50(0x242)][_0xbd6e50(0x2f9)],Game_Actor[_0xbd6e50(0x242)]['forceChangeEquip']=function(_0x2cbe9f,_0x3be21e){const _0x3eb3fa=_0xbd6e50;VisuMZ['UniqueTileEffects'][_0x3eb3fa(0x344)][_0x3eb3fa(0x1f6)](this,_0x2cbe9f,_0x3be21e),$gamePlayer[_0x3eb3fa(0x207)]();},VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x24d)]=Game_Player[_0xbd6e50(0x242)][_0xbd6e50(0x1e2)],Game_Player[_0xbd6e50(0x242)][_0xbd6e50(0x1e2)]=function(_0x1aa16c,_0x3914a0){const _0x340180=_0xbd6e50;VisuMZ[_0x340180(0x247)]['Game_Player_locate'][_0x340180(0x1f6)](this,_0x1aa16c,_0x3914a0),this[_0x340180(0x2c1)](),this[_0x340180(0x23b)](!![]);},VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x209)]=Game_Player[_0xbd6e50(0x242)][_0xbd6e50(0x35c)],Game_Player[_0xbd6e50(0x242)][_0xbd6e50(0x35c)]=function(){const _0x5affc0=_0xbd6e50;VisuMZ[_0x5affc0(0x247)][_0x5affc0(0x209)][_0x5affc0(0x1f6)](this),this[_0x5affc0(0x23b)]();},Game_Player[_0xbd6e50(0x242)][_0xbd6e50(0x2c1)]=function(){const _0x5e4561=_0xbd6e50;this[_0x5e4561(0x2ff)]={'x':this['x'],'y':this['y']};},Game_Player[_0xbd6e50(0x242)][_0xbd6e50(0x246)]=function(){const _0xde14e9=_0xbd6e50;return this[_0xde14e9(0x2ff)]||{'x':this['x'],'y':this['y']};},Game_Player[_0xbd6e50(0x242)]['registerLastSafestCoordinate']=function(_0x3ea377){const _0x420626=_0xbd6e50;if(!_0x3ea377){if(this[_0x420626(0x2d6)]())return;}this[_0x420626(0x2e4)]={'x':this['x'],'y':this['y'],'d':this[_0x420626(0x2c4)]()};},Game_Player[_0xbd6e50(0x242)][_0xbd6e50(0x2d6)]=function(){const _0x18ce06=_0xbd6e50;if(this[_0x18ce06(0x339)]())return!![];if(!$gameMap['isRawPassableByAnyDirection'](this['x'],this['y']))return!![];if($gameMap['isDamageFloor'](this['x'],this['y']))return!![];if($gameMap[_0x18ce06(0x235)](this['x'],this['y']))return!![];if($gameMap['isShipPassable'](this['x'],this['y']))return!![];return![];},Game_Player[_0xbd6e50(0x242)][_0xbd6e50(0x285)]=function(){const _0x1cd48e=_0xbd6e50;if(this[_0x1cd48e(0x2e4)]===undefined)return;this[_0x1cd48e(0x384)](this[_0x1cd48e(0x2e4)]['d']||this[_0x1cd48e(0x2c4)]()),this[_0x1cd48e(0x1e2)](this[_0x1cd48e(0x2e4)]['x']??this['x'],this[_0x1cd48e(0x2e4)]['y']??this['y']),this[_0x1cd48e(0x332)]();},Game_Player[_0xbd6e50(0x242)]['clearUniqueTileSpriteEffects']=function(){const _0x16f4c1=_0xbd6e50;if(!SceneManager[_0x16f4c1(0x2d7)]())return;const _0x47f16c=SceneManager[_0x16f4c1(0x269)]['_spriteset'];if(!_0x47f16c)return;{const _0x3924b2=_0x47f16c['findTargetSprite'](this);if(_0x3924b2)_0x3924b2[_0x16f4c1(0x332)]();}for(const _0x591e7c of this[_0x16f4c1(0x264)][_0x16f4c1(0x221)]()){const _0xb3e82b=_0x47f16c[_0x16f4c1(0x377)](_0x591e7c);if(_0xb3e82b)_0xb3e82b[_0x16f4c1(0x332)]();}},Game_Player[_0xbd6e50(0x242)][_0xbd6e50(0x29d)]=function(_0x66e979){const _0x675a80=_0xbd6e50,_0x17288d=$gameMap[_0x675a80(0x34b)][_0x66e979];if(!_0x17288d)return![];const _0x573dec=_0x17288d[0x0]||$gameMap[_0x675a80(0x1f8)](),_0xdf49de=_0x17288d[0x1]??this['x'],_0xea9697=_0x17288d[0x2]??this['y'];if(_0x573dec===$gameMap[_0x675a80(0x1f8)]()&&_0xdf49de===this['x']&&_0xea9697===this['y'])return![];return this['reserveTransfer'](_0x573dec,_0xdf49de,_0xea9697,this[_0x675a80(0x2c4)](),0x0),!![];},Game_Event['UNIQUE_TILE_AFFECTED_DEFAULT']={'slippery':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x296)][_0xbd6e50(0x253)],'forceMove':VisuMZ['UniqueTileEffects'][_0xbd6e50(0x2b5)][_0xbd6e50(0x2b1)][_0xbd6e50(0x253)],'pitfall':VisuMZ['UniqueTileEffects']['Settings'][_0xbd6e50(0x1ee)][_0xbd6e50(0x253)],'swimming':VisuMZ['UniqueTileEffects'][_0xbd6e50(0x2b5)][_0xbd6e50(0x31f)][_0xbd6e50(0x253)],'quicksand':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x21c)][_0xbd6e50(0x253)],'lava':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x206)][_0xbd6e50(0x253)],'shock':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x304)][_0xbd6e50(0x253)],'bounce':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x245)][_0xbd6e50(0x253)]},Game_Event['UNIQUE_TILE_AVOID_DEFAULT']={'slippery':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x296)][_0xbd6e50(0x2ca)],'forceMove':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x2b1)]['DefaultAvoid'],'pitfall':VisuMZ['UniqueTileEffects']['Settings'][_0xbd6e50(0x1ee)]['DefaultAvoid'],'swimming':VisuMZ['UniqueTileEffects'][_0xbd6e50(0x2b5)][_0xbd6e50(0x31f)][_0xbd6e50(0x2ca)],'quicksand':VisuMZ['UniqueTileEffects'][_0xbd6e50(0x2b5)]['Quicksand'][_0xbd6e50(0x2ca)],'lava':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x206)][_0xbd6e50(0x2ca)],'shock':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)]['Shock'][_0xbd6e50(0x2ca)],'bounce':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x245)][_0xbd6e50(0x2ca)]},VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x20a)]=Game_Event[_0xbd6e50(0x242)]['clearPageSettings'],Game_Event[_0xbd6e50(0x242)][_0xbd6e50(0x229)]=function(){const _0x420311=_0xbd6e50;VisuMZ[_0x420311(0x247)][_0x420311(0x20a)][_0x420311(0x1f6)](this),this[_0x420311(0x2fd)]();},VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x255)]=Game_Event[_0xbd6e50(0x242)][_0xbd6e50(0x1eb)],Game_Event[_0xbd6e50(0x242)][_0xbd6e50(0x1eb)]=function(){const _0x3343f0=_0xbd6e50;VisuMZ[_0x3343f0(0x247)][_0x3343f0(0x255)][_0x3343f0(0x1f6)](this),this['setupUniqueTileEffectsEffects']();},Game_Event[_0xbd6e50(0x242)]['setupUniqueTileEffectsEffects']=function(){const _0x215b18=_0xbd6e50;if(!this[_0x215b18(0x1ca)]())return;this[_0x215b18(0x2fd)](),this[_0x215b18(0x35d)](),this[_0x215b18(0x310)]();},Game_Event[_0xbd6e50(0x242)]['setupUniqueTileEffectsNotetags']=function(){const _0x243a59=_0xbd6e50,_0x1b8f63=this[_0x243a59(0x1ca)]()[_0x243a59(0x32c)];if(_0x1b8f63==='')return;this[_0x243a59(0x22e)](_0x1b8f63);},Game_Event[_0xbd6e50(0x242)][_0xbd6e50(0x310)]=function(){const _0x53c936=_0xbd6e50;if(!this[_0x53c936(0x2ce)]())return;const _0x4c727f=this[_0x53c936(0x1d4)]();let _0xb85995='';for(const _0x3e10ad of _0x4c727f){if([0x6c,0x198][_0x53c936(0x2be)](_0x3e10ad[_0x53c936(0x2d1)])){if(_0xb85995!=='')_0xb85995+='\x0a';_0xb85995+=_0x3e10ad[_0x53c936(0x2c0)][0x0];}}this[_0x53c936(0x22e)](_0xb85995);},Game_Event[_0xbd6e50(0x242)]['initUniqueTileEffectsEffects']=function(){const _0x4baf96=_0xbd6e50;this[_0x4baf96(0x37f)]={},this['_uniqueTileAvoid']={};const _0x173e51=VisuMZ[_0x4baf96(0x247)][_0x4baf96(0x240)]();for(const _0x53a487 of _0x173e51){this[_0x4baf96(0x37f)][_0x53a487]=Game_Event[_0x4baf96(0x2a3)][_0x53a487]||![],this[_0x4baf96(0x327)][_0x53a487]=Game_Event['UNIQUE_TILE_AVOID_DEFAULT'][_0x53a487]||![];}this['_lavaBurnMax']=Game_CharacterBase[_0x4baf96(0x218)]||0x1;},Game_Event[_0xbd6e50(0x242)][_0xbd6e50(0x22e)]=function(_0x597b2b){const _0x5c2c52=_0xbd6e50,_0x3477e2=VisuMZ[_0x5c2c52(0x247)][_0x5c2c52(0x348)],_0x5b1d98=VisuMZ[_0x5c2c52(0x247)]['TileTypes']();for(const _0xc31252 of _0x5b1d98){if(!_0x3477e2[_0xc31252])continue;_0x3477e2[_0xc31252][_0x5c2c52(0x36e)]&&_0x597b2b[_0x5c2c52(0x230)](_0x3477e2[_0xc31252][_0x5c2c52(0x36e)])&&(this[_0x5c2c52(0x37f)][_0xc31252]=!![]),_0x3477e2[_0xc31252][_0x5c2c52(0x30f)]&&_0x597b2b['match'](_0x3477e2[_0xc31252]['immune'])&&(this[_0x5c2c52(0x37f)][_0xc31252]=![]),_0x3477e2[_0xc31252]['avoid']&&_0x597b2b[_0x5c2c52(0x230)](_0x3477e2[_0xc31252][_0x5c2c52(0x303)])&&(this['_uniqueTileAvoid'][_0xc31252]=!![]),_0x3477e2[_0xc31252]['ignore']&&_0x597b2b[_0x5c2c52(0x230)](_0x3477e2[_0xc31252][_0x5c2c52(0x228)])&&(this['_uniqueTileAvoid'][_0xc31252]=![]);}_0x597b2b['match'](_0x3477e2[_0x5c2c52(0x1f7)]['burnMax'])&&(this[_0x5c2c52(0x25c)]=Math['max'](Number(RegExp['$1']),0x1));},VisuMZ[_0xbd6e50(0x247)]['Game_Event_updateSelfMovement']=Game_Event['prototype'][_0xbd6e50(0x32f)],Game_Event['prototype'][_0xbd6e50(0x32f)]=function(){const _0x5edffe=_0xbd6e50;if(this[_0x5edffe(0x224)])return;if(this['_isDrowning'])return;this[_0x5edffe(0x210)]=!![],VisuMZ['UniqueTileEffects']['Game_Event_updateSelfMovement'][_0x5edffe(0x1f6)](this),this[_0x5edffe(0x210)]=undefined;},Game_Event[_0xbd6e50(0x242)]['isUniqueTileAffected']=function(_0x23723d){const _0x470b1b=_0xbd6e50;if(this[_0x470b1b(0x210)]){this[_0x470b1b(0x327)]===undefined&&this[_0x470b1b(0x1d6)]();if(this[_0x470b1b(0x2f5)](_0x23723d))return![];}return Game_Character[_0x470b1b(0x242)][_0x470b1b(0x287)][_0x470b1b(0x1f6)](this,_0x23723d);},Game_Event[_0xbd6e50(0x242)]['isUniqueTileAvoided']=function(_0x3dd2d8){const _0x39c04a=_0xbd6e50;return this[_0x39c04a(0x327)]===undefined&&this[_0x39c04a(0x1d6)](),this[_0x39c04a(0x327)][_0x3dd2d8];},Game_Party['UNIQUE_TILE_DAMAGE']={'general':{'immuneReserveParty':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x220)]},'pitfall':{'deathAllow':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)]['Pitfall'][_0xbd6e50(0x373)]??!![],'dmgRate':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x1ee)]['DmgRate']??0.2,'dmgFlat':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x1ee)][_0xbd6e50(0x374)]??0x14},'swimming':{'deathAllow':VisuMZ['UniqueTileEffects'][_0xbd6e50(0x2b5)][_0xbd6e50(0x31f)]['DmgDeathAllow']??!![],'dmgRate':VisuMZ[_0xbd6e50(0x247)]['Settings']['Swimming'][_0xbd6e50(0x381)]??0.1,'dmgFlat':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x31f)][_0xbd6e50(0x374)]??0xf},'quicksand':{'deathAllow':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)]['Quicksand'][_0xbd6e50(0x373)]??!![],'dmgRate':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x21c)][_0xbd6e50(0x381)]??0.3,'dmgFlat':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x21c)][_0xbd6e50(0x374)]??0x28},'lava':{'deathAllow':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)]['Lava'][_0xbd6e50(0x373)]??!![],'dmgRate':VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)]['Lava'][_0xbd6e50(0x381)]??0.05,'dmgFlat':VisuMZ['UniqueTileEffects']['Settings'][_0xbd6e50(0x206)][_0xbd6e50(0x374)]??0x32},'shock':{'deathAllow':VisuMZ['UniqueTileEffects'][_0xbd6e50(0x2b5)][_0xbd6e50(0x304)][_0xbd6e50(0x373)]??!![],'dmgRate':VisuMZ['UniqueTileEffects'][_0xbd6e50(0x2b5)][_0xbd6e50(0x304)][_0xbd6e50(0x381)]??0.25,'dmgFlat':VisuMZ[_0xbd6e50(0x247)]['Settings'][_0xbd6e50(0x304)][_0xbd6e50(0x374)]??0x3c}},Game_Party[_0xbd6e50(0x242)][_0xbd6e50(0x24f)]=function(){const _0x564376=_0xbd6e50,_0x2e83b3=$gamePlayer['getUniqueTileType']();SoundManager[_0x564376(0x319)](_0x2e83b3,_0x564376(0x352),$gamePlayer);for(const _0x2eb4a5 of this[_0x564376(0x343)]()){if(!_0x2eb4a5)continue;_0x2eb4a5[_0x564376(0x24f)](_0x2e83b3);}},Game_Actor[_0xbd6e50(0x242)][_0xbd6e50(0x24f)]=function(_0x2e8d1d){const _0x2b0440=_0xbd6e50,_0x28c831=Game_Party['UNIQUE_TILE_DAMAGE'][_0x2e8d1d];if(!_0x28c831)return;let _0x1a45dd=0x0;_0x1a45dd+=_0x28c831['dmgRate']*this['mhp'],_0x1a45dd+=_0x28c831[_0x2b0440(0x34a)],_0x1a45dd=Math[_0x2b0440(0x226)](_0x1a45dd);!_0x28c831['deathAllow']&&(_0x1a45dd=Math[_0x2b0440(0x340)](_0x1a45dd,this['hp']-0x1));_0x1a45dd>0x0&&($gameTemp['_executeFloorDamage']=!![],this['performMapDamage'](),$gameTemp[_0x2b0440(0x295)]=![]);this[_0x2b0440(0x257)](-_0x1a45dd);if(this['isDead']())this[_0x2b0440(0x2c5)]();},Sprite_Character[_0xbd6e50(0x349)]=VisuMZ['UniqueTileEffects'][_0xbd6e50(0x2b5)][_0xbd6e50(0x1ee)][_0xbd6e50(0x232)]??0x14,Sprite_Character[_0xbd6e50(0x320)]=VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2b5)][_0xbd6e50(0x31f)][_0xbd6e50(0x232)]??0x1e,VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x252)]=Sprite_Character[_0xbd6e50(0x242)][_0xbd6e50(0x2b7)],Sprite_Character[_0xbd6e50(0x242)]['initMembers']=function(){const _0xfbca02=_0xbd6e50;VisuMZ[_0xfbca02(0x247)][_0xfbca02(0x252)][_0xfbca02(0x1f6)](this),this[_0xfbca02(0x322)]();},Sprite_Character['prototype'][_0xbd6e50(0x322)]=function(){const _0x37431f=_0xbd6e50;this[_0x37431f(0x297)]=0x0,this['_drowningDuration']=0x0,this[_0x37431f(0x250)]=0x0;},Sprite_Character[_0xbd6e50(0x242)]['clearUniqueTileSpriteEffects']=function(){const _0xa296e1=_0xbd6e50;this[_0xa296e1(0x250)]=0x0,this['update']();},VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x341)]=Sprite_Character['prototype']['update'],Sprite_Character[_0xbd6e50(0x242)][_0xbd6e50(0x205)]=function(){const _0x4cb2c1=_0xbd6e50;this[_0x4cb2c1(0x2fe)](),VisuMZ[_0x4cb2c1(0x247)]['Sprite_Character_update'][_0x4cb2c1(0x1f6)](this),this[_0x4cb2c1(0x261)]();},VisuMZ['UniqueTileEffects']['Sprite_Character_updateCharacterFrame']=Sprite_Character[_0xbd6e50(0x242)][_0xbd6e50(0x2e5)],Sprite_Character['prototype'][_0xbd6e50(0x2e5)]=function(){const _0x22fe50=_0xbd6e50;this[_0x22fe50(0x2e2)](),this[_0x22fe50(0x250)]>0x0?this[_0x22fe50(0x328)]():(VisuMZ[_0x22fe50(0x247)][_0x22fe50(0x22c)]['call'](this),this[_0x22fe50(0x2ab)]());},Sprite_Character[_0xbd6e50(0x242)][_0xbd6e50(0x2e2)]=function(){const _0xb64c82=_0xbd6e50,_0x35f8f0=this[_0xb64c82(0x375)](),_0x5a73b7=0x1;if(this[_0xb64c82(0x250)]>_0x35f8f0)this[_0xb64c82(0x250)]=Math[_0xb64c82(0x27e)](this[_0xb64c82(0x250)]-_0x5a73b7*0x4,_0x35f8f0);else this[_0xb64c82(0x250)]<_0x35f8f0?this['_uniqueTileFrameMinusY']=Math[_0xb64c82(0x340)](this[_0xb64c82(0x250)]+_0x5a73b7,_0x35f8f0):this[_0xb64c82(0x250)]=_0x35f8f0;},Sprite_Character[_0xbd6e50(0x242)][_0xbd6e50(0x375)]=function(){const _0x1e6bdc=_0xbd6e50;if(!this['_character'])return 0x0;if(this['_character'][_0x1e6bdc(0x326)]())return this[_0x1e6bdc(0x22f)]();else{if(this[_0x1e6bdc(0x275)]['isQuicksandSinking']())return this['getUniqueTileCharaQuicksandFrameTarget']();}return 0x0;},Sprite_Character[_0xbd6e50(0x242)][_0xbd6e50(0x2fe)]=function(){const _0x462e1c=_0xbd6e50;if(this[_0x462e1c(0x297)]<=0x0)return;const _0x293996=this[_0x462e1c(0x297)];this[_0x462e1c(0x2b4)]['x']=this[_0x462e1c(0x2b4)]['x']*(_0x293996-0x1)/_0x293996,this[_0x462e1c(0x2b4)]['y']=this[_0x462e1c(0x2b4)]['y']*(_0x293996-0x1)/_0x293996,this[_0x462e1c(0x297)]--;if(this[_0x462e1c(0x297)]<=0x0){if(this[_0x462e1c(0x275)])this[_0x462e1c(0x275)][_0x462e1c(0x35e)]();this['finishPitfallEffect']();}},Sprite_Character[_0xbd6e50(0x242)][_0xbd6e50(0x1e6)]=function(){const _0x23638b=_0xbd6e50;if($gameParty[_0x23638b(0x2b6)]())return;this['_pitfallDuration']=Sprite_Character[_0x23638b(0x349)],this[_0x23638b(0x2bc)]={'scaleX':this[_0x23638b(0x2b4)]['x'],'scaleY':this['scale']['y'],'shadowScaleX':this[_0x23638b(0x315)]?this[_0x23638b(0x315)][_0x23638b(0x2b4)]['x']:0x0,'shadowScaleY':this[_0x23638b(0x315)]?this['_shadowSprite'][_0x23638b(0x2b4)]['y']:0x0};},Sprite_Character[_0xbd6e50(0x242)]['finishPitfallEffect']=function(){const _0x2ed198=_0xbd6e50;this[_0x2ed198(0x297)]=0x0;},Sprite_Character[_0xbd6e50(0x242)][_0xbd6e50(0x378)]=function(){const _0x2f45c8=_0xbd6e50;this[_0x2f45c8(0x297)]=0x0;if(!this[_0x2f45c8(0x2bc)])return;this[_0x2f45c8(0x2b4)]['x']=this['_pitfallData'][_0x2f45c8(0x212)],this['scale']['y']=this[_0x2f45c8(0x2bc)]['scaleY'],this['_shadowSprite']&&(this['_shadowSprite'][_0x2f45c8(0x2b4)]['x']=this['_pitfallData'][_0x2f45c8(0x290)],this['_shadowSprite']['scale']['y']=this[_0x2f45c8(0x2bc)][_0x2f45c8(0x25b)]),this[_0x2f45c8(0x2bc)]=undefined;},Sprite_Character[_0xbd6e50(0x242)]['updateCharacterFrameDrowning']=function(){const _0x2b831d=_0xbd6e50;if(this[_0x2b831d(0x28e)]!==undefined){const _0x3c18ad=Math['floor'](this[_0x2b831d(0x20f)][_0x2b831d(0x306)]*this[_0x2b831d(0x28e)]);this[_0x2b831d(0x20f)][_0x2b831d(0x306)]=_0x3c18ad,this[_0x2b831d(0x2a0)]();}},Sprite_Character[_0xbd6e50(0x242)][_0xbd6e50(0x261)]=function(){const _0x3c393c=_0xbd6e50;if(this['_drowningDuration']<=0x0)return;const _0x2c8ef9=this['_drowningDuration'];this[_0x3c393c(0x28e)]=this[_0x3c393c(0x28e)]*(_0x2c8ef9-0x1)/_0x2c8ef9,this[_0x3c393c(0x2e5)](),this[_0x3c393c(0x2f0)]--;if(this[_0x3c393c(0x2f0)]<=0x0){if(this[_0x3c393c(0x275)])this['_character'][_0x3c393c(0x1d5)]();this[_0x3c393c(0x291)]();}},Sprite_Character[_0xbd6e50(0x242)][_0xbd6e50(0x225)]=function(){const _0x47d47f=_0xbd6e50;if($gameParty[_0x47d47f(0x2b6)]())return;this['_drowningDuration']=Sprite_Character[_0x47d47f(0x320)],this[_0x47d47f(0x28e)]=0x1;},Sprite_Character[_0xbd6e50(0x242)]['finishDrowningEffect']=function(){const _0xbc0ec2=_0xbd6e50;this[_0xbc0ec2(0x2f0)]=0x0;},Sprite_Character['prototype'][_0xbd6e50(0x24e)]=function(){const _0x7c74c2=_0xbd6e50;this[_0x7c74c2(0x2f0)]=0x0,this[_0x7c74c2(0x28e)]=undefined,this[_0x7c74c2(0x2e5)]();},Sprite_Character['prototype'][_0xbd6e50(0x22f)]=function(){const _0x416148=_0xbd6e50;return this[_0x416148(0x275)][_0x416148(0x20c)]();},Sprite_Character[_0xbd6e50(0x242)][_0xbd6e50(0x328)]=function(){const _0x165a5=_0xbd6e50,_0x5c254b=this[_0x165a5(0x382)](),_0x2c9e69=this[_0x165a5(0x2bd)](),_0x4225dd=(this[_0x165a5(0x1f3)]()+this[_0x165a5(0x211)]())*_0x5c254b,_0x2e2b7a=(this['characterBlockY']()+this[_0x165a5(0x2a5)]())*_0x2c9e69;this['setFrame'](_0x4225dd,_0x2e2b7a,_0x5c254b,_0x2c9e69-this[_0x165a5(0x250)]);if(this[_0x165a5(0x26d)])this[_0x165a5(0x26d)][_0x165a5(0x26b)](0x0,0x0,0x0,0x0);if(this[_0x165a5(0x29a)])this[_0x165a5(0x29a)]['setFrame'](0x0,0x0,0x0,0x0);},Sprite_Character['prototype'][_0xbd6e50(0x36d)]=function(){const _0x4749e1=_0xbd6e50;return Math[_0x4749e1(0x249)](this[_0x4749e1(0x275)][_0x4749e1(0x338)]()*this[_0x4749e1(0x2bd)]());};Imported['VisuMZ_2_MovementEffects']&&(Game_Player[_0xbd6e50(0x242)][_0xbd6e50(0x2df)]=function(){const _0x3f443f=_0xbd6e50;if(this[_0x3f443f(0x2a6)]()){if(this[_0x3f443f(0x25d)]()===_0x3f443f(0x355))return $gameMap[_0x3f443f(0x2f2)](this['x'],this['y']);if(this[_0x3f443f(0x25d)]()===_0x3f443f(0x21e))return $gameMap[_0x3f443f(0x2f2)](this['x'],this['y']);return![];}return!![];},VisuMZ[_0xbd6e50(0x247)]['Game_Player_canSmartRush']=Game_Player['prototype'][_0xbd6e50(0x1d2)],Game_Player[_0xbd6e50(0x242)][_0xbd6e50(0x1d2)]=function(){const _0x31727b=_0xbd6e50;if(!this[_0x31727b(0x2df)]())return![];return VisuMZ[_0x31727b(0x247)]['Game_Player_canSmartRush'][_0x31727b(0x1f6)](this);},VisuMZ['UniqueTileEffects'][_0xbd6e50(0x2d2)]=Game_Player[_0xbd6e50(0x242)][_0xbd6e50(0x1f9)],Game_Player['prototype'][_0xbd6e50(0x1f9)]=function(_0x578948){const _0x25b237=_0xbd6e50;if(!this[_0x25b237(0x2df)]())return![];return VisuMZ[_0x25b237(0x247)][_0x25b237(0x2d2)][_0x25b237(0x1f6)](this,_0x578948);},VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2c3)]=Game_Player[_0xbd6e50(0x242)][_0xbd6e50(0x2dc)],Game_Player[_0xbd6e50(0x242)]['canSmartJump']=function(){const _0x47a416=_0xbd6e50;if(!this['canUniqueTileEndSmartAction']())return![];return VisuMZ['UniqueTileEffects'][_0x47a416(0x2c3)][_0x47a416(0x1f6)](this);},VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2ad)]=Game_Player[_0xbd6e50(0x242)][_0xbd6e50(0x231)],Game_Player[_0xbd6e50(0x242)]['moveBySmartRush']=function(){const _0x2966dc=_0xbd6e50;if(!this[_0x2966dc(0x2df)]()){this[_0x2966dc(0x26e)]();return;}return VisuMZ['UniqueTileEffects'][_0x2966dc(0x2ad)][_0x2966dc(0x1f6)](this);},Game_Player[_0xbd6e50(0x242)][_0xbd6e50(0x216)]=function(_0x44627d,_0x3e1498){return![];},VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x369)]=Game_Player[_0xbd6e50(0x242)]['isTileSmartJumpBreakable'],Game_Player['prototype'][_0xbd6e50(0x1e9)]=function(_0x405516,_0xe0a27e){const _0x174c67=_0xbd6e50;if(this[_0x174c67(0x216)](_0x405516,_0xe0a27e))return!![];return VisuMZ['UniqueTileEffects']['Game_Player_isTileSmartJumpBreakable'][_0x174c67(0x1f6)](this,_0x405516,_0xe0a27e);},Game_Player[_0xbd6e50(0x242)][_0xbd6e50(0x222)]=function(_0x292b61,_0x5d1148){const _0x14cd1b=_0xbd6e50;if($gameMap[_0x14cd1b(0x1c9)](_0x292b61,_0x5d1148,'pitfall'))return $gamePlayer['isUniqueTileAffected'](_0x14cd1b(0x355));if($gameMap[_0x14cd1b(0x1c9)](_0x292b61,_0x5d1148,_0x14cd1b(0x21e)))return $gamePlayer[_0x14cd1b(0x287)]('swimming');return![];},VisuMZ[_0xbd6e50(0x247)][_0xbd6e50(0x2ea)]=Game_Player[_0xbd6e50(0x242)][_0xbd6e50(0x27d)],Game_Player[_0xbd6e50(0x242)]['isTileSmartJumpCompatible']=function(_0x47bef1,_0x209afc){const _0x1b79b2=_0xbd6e50;if(this[_0x1b79b2(0x222)](_0x47bef1,_0x209afc))return!![];return VisuMZ[_0x1b79b2(0x247)][_0x1b79b2(0x2ea)][_0x1b79b2(0x1f6)](this,_0x47bef1,_0x209afc);},Game_Player['prototype'][_0xbd6e50(0x2a1)]=function(_0x4110bd,_0x4d6587){return![];},VisuMZ['UniqueTileEffects'][_0xbd6e50(0x21a)]=Game_Player[_0xbd6e50(0x242)]['isTileSmartBlinkBreakable'],Game_Player[_0xbd6e50(0x242)][_0xbd6e50(0x37d)]=function(_0x18624b,_0x5f2421){const _0x8a8942=_0xbd6e50;if(this[_0x8a8942(0x2a1)](_0x18624b,_0x5f2421))return!![];return VisuMZ['UniqueTileEffects'][_0x8a8942(0x21a)][_0x8a8942(0x1f6)](this,_0x18624b,_0x5f2421);},Game_Player[_0xbd6e50(0x242)][_0xbd6e50(0x2a7)]=function(_0x374786,_0xf6f69d){return![];},VisuMZ['UniqueTileEffects'][_0xbd6e50(0x36f)]=Game_Player[_0xbd6e50(0x242)][_0xbd6e50(0x31c)],Game_Player[_0xbd6e50(0x242)][_0xbd6e50(0x31c)]=function(_0x55ecb4,_0x37d1cd){const _0x163d7=_0xbd6e50;if(this[_0x163d7(0x2a7)](_0x55ecb4,_0x37d1cd))return!![];return VisuMZ[_0x163d7(0x247)][_0x163d7(0x36f)][_0x163d7(0x1f6)](this,_0x55ecb4,_0x37d1cd);});function _0x3d6d(_0x54435a,_0x47dafb){const _0x231c0c=_0x231c();return _0x3d6d=function(_0x3d6d0f,_0xaa260d){_0x3d6d0f=_0x3d6d0f-0x1c9;let _0x1b6aef=_0x231c0c[_0x3d6d0f];return _0x1b6aef;},_0x3d6d(_0x54435a,_0x47dafb);};function _0x231c(){const _0x41a2d2=['registerLastSafestCoordinate','LavaBurnTimer','clear','isQuicksandSinking','Game_CharacterBase_jump','TileTypes','isPassable','prototype','tilesetFlags','LAVA_ANIMATION','Bounce','getLastUniqueTileCoordinate','UniqueTileEffects','slippery','floor','ARRAYSTR','erase','checkBlockedCliffTiles','Game_Player_locate','restorePreDrowning','processUniqueTileDamage','_uniqueTileFrameMinusY','ConvertParams','Sprite_Character_initMembers','DefaultAffected','UNIQUE_TILE_REGIONS','Game_Event_setupPageSettings','footstepsVolume','gainHp','map','footstep','down','shadowScaleY','_lavaBurnMax','getUniqueTileType','return\x200','damagePan','Game_Player_moveByInput','updateDrowningEffect','_uniqueTileData','checkPassageNoEvents','_followers','indexOf','terrainTags','hasPullConditionsUniqueTiles','length','_scene','updateUniqueTileData','setFrame','Game_CharacterBase_increaseSteps','_upperBody','endSmartRush','initUniqueTileData','anyFollowersNotSwimming','isJumping','_data','effectVolume','terrainTag','_character','none','Thunder3','_erased','Bounce7Regions','exit','bounce8','getUniqueTileData','isTileSmartJumpCompatible','max','updateQuicksand','tileId','updateUniqueTileEffects','Bounce5Regions','SHOCK_DELAY','Game_CharacterBase_realMoveSpeed','gotoLastSafestCoordinate','constructor','isUniqueTileAffected','gainItem','hasPushConditionsUniqueTiles','PlayerSetAntiSlippery','anyFollowersSwimming','jump','mirror','_drowningHeightRate','roundYWithDirection','shadowScaleX','finishDrowningEffect','footstepsName','behindUniqueTileMeetsPullTargetEventConditions','Bounce2Regions','_executeFloorDamage','Slippery','_pitfallDuration','filter','RightRegions','_lowerBody','processLavaEffect','processPitfallEffect','processUniqueTileTransfer','Game_Event_canBePushed','gatherFollowers','_refresh','isMovementEffectsUniqueTilesSmartBlinkBreakable','characterName','UNIQUE_TILE_AFFECTED_DEFAULT','onDrowningDead','characterPatternY','isAffectedByCurrentUniqueTile','isMovementEffectsUniqueTilesSmartBlinkCompatible','PlayerSetAntiQuicksand','registerCommand','effectPitch','updateCharacterFrameDrowning','Game_CharacterBase_pattern','Game_Player_moveBySmartRush','Game_Event_canBePulled','PlayerSetAllowSwimming','isSwimmingTileWithBridge','ForceMove','setUniqueTileAffected','onQuicksandSink','scale','Settings','isAllDead','initMembers','isVisible','940793tvxPCN','Game_Player_isDashing','onPitfallDead','_pitfallData','patternHeight','includes','Setting','parameters','registerLastUniqueTileCoordinate','turnOffPitfalling','Game_Player_canSmartJump','direction','performCollapse','1659750NTtApS','meetsUniqueTileGatherConditions','_priorityType','VisuMZ_2_MovementEffects','DefaultAvoid','isSwimmingTileWithNoBridge','_uniqueTileCmdImmune','6SUaSdH','page','bounce1','status','code','Game_Player_canSmartBlink','setupUniqueTileData','getBounceTileDistance','name','canPreventSafestCoordinateRegistration','isSceneMap','reverseDir','roundXWithDirection','processSlipperyEffect','AnimationMirror','canSmartJump','isUniqueTile','_isShocked','canUniqueTileEndSmartAction','ARRAYEVAL','processBounceEffect','calcUniqueTileCharaFrame','isStopping','_lastSafestCoordinate','updateCharacterFrame','NUM','bounce7','Earth4','bounceMoveDirection','Game_Player_isTileSmartJumpCompatible','canMakeUniqueTileFootstepSounds','_uniqueTileXyType','isSwimmingTile','pitch','Game_Party_gainItem','_drowningDuration','equips','hasBelowPriorityEventsXy','forceMove','UNIQUE_TILE_DAMAGE','isUniqueTileAvoided','PlayerSetAntiLava','ARRAYFUNC','bounce2','forceChangeEquip','shock','_uniqueTileMoveDirection','moveDiagonally','initUniqueTileEffectsEffects','updatePitfallEffect','_lastUniqueTileCoordinate','hasUniqueTileEffects','makeUniqueTileFootstepSounds','_walkAnime','avoid','Shock','Bounce1Regions','height','parse','UNIQUE_TILE_MOVE_SPEED','mapTransfer','bounce','clamp','updateJump','processForceMoveEffect','effect','immune','setupUniqueTileEffectsCommentTags','push','ShockTimer','LeftRegions','regions','_shadowSprite','damageName','_tempSlipperyTileStop','forceMoveDirection','playUniqueTileSfx','Fire8','SHOCK_ANIMATION','isTileSmartBlinkCompatible','ApplyFootstepSfxModifiers','damageVolume','Swimming','DROWNING_DURATION','UpRegions','initMembersUniqueTileEffects','Game_CharacterBase_moveStraight','isMovementSucceeded','_lavaBurnTimes','isSwimming','_uniqueTileAvoid','updateCharacterSwimmingFrame','Game_CharacterBase_locate','bounce9','playSe','note','_vehicleGettingOn','quicksand','updateSelfMovement','Bounce9Regions','refreshUniqueTileImmunityPartyCheck','clearUniqueTileSpriteEffects','LAVA_DELAY','STRUCT','%1\x20is\x20missing\x20a\x20required\x20plugin.\x0aPlease\x20install\x20%2\x20into\x20the\x20Plugin\x20Manager.','_uniqueTilePartyImmune','Game_Player_pullTargetEvent','getQuicksandSinkRate','isOnUniqueTile','StepsSandSink','Game_CharacterBase_updateJump','isRawPassableByAnyDirection','setImmuneToUniqueTileType','340669XJfpFD','JSON','min','Sprite_Character_update','ARRAYSTRUCT','aliveMembers','Game_Actor_forceChangeEquip','processDrowningEffect','right','1351173UNOvIM','RegExp','PITFALL_DURATION','dmgFlat','_uniqueTileTransfer','AnimationID','Bounce6Regions','moveStraight','isEventTest','effectName','isDebugThrough','damage','Jump2','processShockEffect','pitfall','VisuMZ_3_EventChainReact','canBePulled','isImmuneToUniqueTileType','regionId','footstepsPitch','_spriteset','increaseSteps','setupUniqueTileEffectsNotetags','onPitfallFinish','Game_CharacterBase_isStopping','Earth3','Game_CharacterBase_update','canMakeFootstepSounds','frameCount','refresh','SwimmingDepth','Game_CharacterBase_canMakeFootstepSounds','1041386cdfsMl','version','Game_Player_isTileSmartJumpBreakable','bounce5','isDashing','canBePushed','getUniqueTileCharaQuicksandFrameTarget','affected','Game_Player_isTileSmartBlinkCompatible','canUpdateUniqueTileEffects','isMapPassable','_uniqueTilePattern','DmgDeathAllow','DmgFlat','getUniqueTileCharaFrameTarget','moveByInput','findTargetSprite','restorePrePitfallScale','parseUniqueTileNotetags','UNIQUE_TILE_SFX','DefaultRegions','DownRegions','isTileSmartBlinkBreakable','description','_uniqueTileAffected','Water3','DmgRate','patternWidth','left','setDirection','MovementEffects','QUICKSAND_MAX_STEPS','%1\x20is\x20incorrectly\x20placed\x20on\x20the\x20plugin\x20list.\x0aIt\x20is\x20a\x20Tier\x20%2\x20plugin\x20placed\x20over\x20other\x20Tier\x20%3\x20plugins.\x0aPlease\x20reorder\x20the\x20plugin\x20list\x20from\x20smallest\x20to\x20largest\x20tier\x20numbers.','_isDrowning','PlayerSetAntiForceMove','checkUniqueTileType','event','Game_CharacterBase_initMembers','_bypassPassableAnyDirection','AnimationMute','trim','requestFauxAnimation','layeredTiles','isUniqueTileWithoutBelow','canSmartRush','Fall','list','onDrowningFinish','setupUniqueTileEffectsEffects','1484004eDqYHc','effectPan','Game_Map_setupEvents','pan','slipperyMoveDirection','bind','checkEventTriggerHere','pullTargetEvent','Sand','Game_CharacterBase_moveDiagonally','mute','locate','SWIMMING_DEPTH','MoveSpeed','_uniqueTileMoveSpeed','startPitfallEffect','bounce4','pattern','isTileSmartJumpBreakable','bounce0','setupPageSettings','footstepsEnabled','footstepsPan','Pitfall','isOnBush','PLAYER_CAN_DROWN','realMoveSpeed','bounce6','characterBlockX','Bounce4Regions','enabled','call','lava','mapId','canSmartBlink','damagePitch','Game_CharacterBase_isMapPassable','Game_Actor_changeEquip','ARRAYNUM','UNIQUE_TILE_PATTERN','_shockEffectDelay','getUniqueTileRegions','canUpdateUniqueTileLava','tileset','canSwimInWater','Game_Player_refresh','update','Lava','clearUniqueTilePartyImmunity','some','Game_Player_increaseSteps','Game_Event_clearPageSettings','Fire2','swimmingDepth','changeEquip','Game_CharacterBase_isOnBush','_frame','_uniqueTileSelfMove','characterPatternX','scaleX','volume','split','_quicksandSteps','isMovementEffectsUniqueTilesSmartJumpBreakable','format','LAVA_EVENT_MAX','eventsXy','Game_Player_isTileSmartBlinkBreakable','bounce3','Quicksand','isTransferring','swimming','Pattern','NotetagPartyWide','visibleFollowers','isMovementEffectsUniqueTilesSmartJumpCompatible','resetPattern','_isPitfalling','startDrowningEffect','ceil','isDashingAffectedByUniqueTile','ignore','clearPageSettings','11222880HseMuj','clearUniqueTileTempData','Sprite_Character_updateCharacterFrame','isMoving','checkUniqueTileEffectsStringTags','getUniqueTileCharaSwimFrameTarget','match','moveBySmartRush','EffectDuration','isInVehicle','getUniqueTileXyType','isBoatPassable','Water1','Current\x20tileset\x20has\x20incomplete\x20flag\x20data.','increaseStepsUniqueTileEffects','VisuMZ_0_CoreEngine','doesCurrentTileHaveUniqueFootstepSfx'];_0x231c=function(){return _0x41a2d2;};return _0x231c();}Imported[_0xbd6e50(0x356)]&&(Game_Player[_0xbd6e50(0x242)][_0xbd6e50(0x289)]=function(_0x43dfe3){return!![];},VisuMZ[_0xbd6e50(0x247)]['Game_Event_canBePushed']=Game_Event[_0xbd6e50(0x242)][_0xbd6e50(0x36c)],Game_Event[_0xbd6e50(0x242)][_0xbd6e50(0x36c)]=function(){const _0x4ada3a=_0xbd6e50;if(!$gamePlayer[_0x4ada3a(0x289)](this))return![];return VisuMZ['UniqueTileEffects'][_0x4ada3a(0x29e)]['call'](this);},Game_Player[_0xbd6e50(0x242)][_0xbd6e50(0x267)]=function(_0x4bfbf4){return!![];},VisuMZ[_0xbd6e50(0x247)]['Game_Event_canBePulled']=Game_Event[_0xbd6e50(0x242)][_0xbd6e50(0x357)],Game_Event['prototype'][_0xbd6e50(0x357)]=function(){const _0x28d7fc=_0xbd6e50;if(!$gamePlayer[_0x28d7fc(0x267)](this))return![];return VisuMZ['UniqueTileEffects'][_0x28d7fc(0x2ae)][_0x28d7fc(0x1f6)](this);},Game_Player['prototype'][_0xbd6e50(0x293)]=function(_0x5e5d29,_0x397ca0){const _0x4822ab=_0xbd6e50;if($gameMap['isUniqueTile'](_0x5e5d29,_0x397ca0)){const _0x40bbb4=$gameMap[_0x4822ab(0x234)](_0x5e5d29,_0x397ca0);if(_0x40bbb4===_0x4822ab(0x355)&&$gameMap[_0x4822ab(0x2f2)](_0x5e5d29,_0x397ca0))return!![];if($gameMap['isSwimmingTileWithBridge'](this['x'],this['y']))return!![];return![];}return!![];},VisuMZ[_0xbd6e50(0x247)]['Game_Player_pullTargetEvent']=Game_Player['prototype'][_0xbd6e50(0x1de)],Game_Player[_0xbd6e50(0x242)][_0xbd6e50(0x1de)]=function(_0x5ec559,_0xcd8a1a,_0x74ae4b){const _0x3cca82=_0xbd6e50,_0x55032c=0xa-this[_0x3cca82(0x2c4)]();if(_0x55032c%0x2!==0x0)return;const _0x1543bc=$gameMap[_0x3cca82(0x2d9)](this['x'],_0x55032c),_0x1809df=$gameMap[_0x3cca82(0x28f)](this['y'],_0x55032c);if(!this[_0x3cca82(0x293)](_0x1543bc,_0x1809df))return;VisuMZ[_0x3cca82(0x247)][_0x3cca82(0x337)][_0x3cca82(0x1f6)](this,_0x5ec559,_0xcd8a1a,_0x74ae4b);});;