﻿//=============================================================================
// アクター全員が戦闘不能になってもゲームオーバーにならなくなるプラグイン
// BattleNotEndAllDown.js
// by みっぷ　
//=============================================================================
/*:ja
 * @target MZ
 * @plugindesc 全員戦闘不能になってもゲームオーバーにならなくなります。
 * @author みっぷ
 * 
 *
 * @help
 *
 *             ★アクター全員が戦闘不能になってもゲームオーバーにならなくなる★
 *
 * このプラグインを導入すると
 * アクター全員が戦闘不能になってもゲームオーバーになりません。
 *
 * そのままだとゲームが進行しなくなるので
 * 予め主人公のHPが0になったら実行されるバトルイベントを用意したり
 * 戦闘中でも並列処理が走る「NRP_BattleParallelCommon」(砂川様制作)などと
 * 組み合わせて使ってください。
 *             
 * このプラグイン以外で、戦闘敗北時の処理を変更するプラグインが
 * 導入されている場合、競合を起こす可能性が極めて高いので
 * それらのプラグインと同時に使用しないでください。
 *
 * このプラグインを導入した事で発生した、すべての事象について
 * 当方は責任を負いかねます。
 *
 * みっぷ
 *
 */
(function() {

BattleManager.checkBattleEnd = function() {
    if (this._phase) {
        if ($gameParty.isEscaped()) {
            this.processPartyEscape();
            return true;
        } else if ($gameParty.isAllDead()) {
//            this.processDefeat();
//            return true;
        } else if ($gameTroop.isAllDead()) {
            this.processVictory();
            return true;
        }
    }
    return false;
};

BattleManager.updateEventMain = function() {
    $gameTroop.updateInterpreter();
    $gameParty.requestMotionRefresh();
    if ($gameTroop.isEventRunning() || this.checkBattleEnd()) {
        return true;
    }
    $gameTroop.setupBattleEvent();
    if ($gameTroop.isEventRunning() || SceneManager.isSceneChanging()) {
        return true;
    }
    return false;
};


})();

