//=============================================================================
//  Keke_MenuSKin - メニュースキン
// バージョン: 1.2.1
//=============================================================================
// Copyright (c) 2022 ケケー
// Released under the MIT license
// http://opensource.org/licenses/mit-license.php
//=============================================================================

/*:
 * @target MZ
 * @plugindesc メニューにスキンを被せてビジュアル改造
 * @author ケケー
 * @url https://kekeelabo.com
 * 
 * @help
 * 【ver.1.2.1】
 * メニューに様々なスキンを貼り付けて、好みのビジュアルに改造できる
 * 
 * ● 特徴 ●
 * 
 * ◎ウインドウ毎にスキン貼り付け
 * ◎スキンのアニメーション
 * ◎フォントをウインドウ毎に変更
 * ◎動かせる背景
 * ◎好きな位置にピクチャ貼り付け
 * ◎メニューで流すBGM
 * ◎ゲーム中の動的なデザイン変更
 * 
 * 
 * ● 使い方 ●
 * 
 * 【基本】最初にやること
 * [1] スキン・背景・フレーム(枠)に使う画像をピクチャフォルダに入れる
 * 　img/pictures
 * 　背景とフレームはなくてもよい。あると恰好いい。好みで
 * 　※画像サイズや形の制限は一切ない
 * 　　サイズと形は自動調整されるのでどんなものでもそのまま放り込んでかまわない
 * 　　あまり小さいとぼやけるし大きいと容量の無駄ではあるが
 * 　※背景を移動させるとループするが、ループ対応画像である必要はない
 * 　　どんな画像でも切れ目が出ない特殊処理をしてループさせるので、
 * 　　背景として問題なく使用することできる
 * [2] デザインを選択する
 * 　初期状態で
 * 　◎デザイン1 → シンプルなアニメーション
 * 　◎デザイン2 → ダイナミックなアニメーション
 * 　となっている。好きな方を選ぼう
 * 　初期設定はデザイン1。デザイン2にする場合は
 * 　プラグインパラメータ → 開始デザイン
 * 　　でデザイン2を選択する　
 * [3] スキン画像を設定する
 * 　プラグインパラメータ → スキン登録 → d1-ベース → 画像
 * 　　※デザイン2の場合は d2-ベース
 * 　　[1]で入れた画像を選択する
 * [4] 背景画像を設定する
 * 　プラグインパラメータ → 背景登録 → d1-背景 → 画像
 * 　　※デザイン2の場合は d2-背景
 * 　　[1]で入れた画像を選択する
 * [5] フレーム画像を設定する
 * 　プラグインパラメータ → ピクチャ登録 → d1-フレーム → 画像
 * 　　※デザイン2の場合は d2-フレーム
 * 　　[1]で入れた画像を選択する
 * [6] BGMを設定する
 * 　プラグインパラメータ → BGM登録 → d1-BGM → ファイル
 * 　※デザイン2の場合は d2-BGM
 * 　　好きなBGMファイルを選択する
 * 　　BGMを流さないのであれば無選択で
 * [7] テストプレイ。メニューを開いてみる
 * 　スキンが適用されているはず
 * [8] 以上、最初の設定は終わり
 * 　これだけでも機能はするが、
 * 　あとは好きなように改造していこう
 * 
 * 
 * 【機能マップ】
 * ■ウインドウ毎にスキンを設定 => 機能1 (重要。最初に見るべし)
 * ■スキンのアニメーションを変更 => 機能2
 * ■フォント設定を変更 => 機能3
 * ■背景を変更 => 機能4
 * ■ピクチャを張り付ける => 機能5
 * ■メニューBGMを流す => 機能6
 * ■カーソルを変更 => 機能7
 * ■ゲーム中にデザイン変更 => 機能8
 * ■背景、ピクチャ、BGMを個別に変更 => 機能9
 * 
 * 
 * 【機能1】ウインドウ毎にスキンを設定
 * ◎本プラグインの構造としては、
 * 　ウインドウ毎(もしくはシーン毎)に『スタイル』(各種設定の詰め合わせ)を
 * 　適用し、その内容によって状態制御している
 * 　スキン設定もスタイルの内に含まれる
 * ◎なのでスキン変更する場合、
 * 　ウインドウにスタイルを適用し、そのスタイルの中で、
 * 　使用するスキンを設定すればよい
 * ◎まずはスキンを登録する
 * 　プラグインパラメータ → スキン登録
 * 　)好きな『スキン名』を付け、
 * 　)好きな『画像』を選択、
 * 　)あとは位置や拡大率など好きに設定していく
 * ◎次にスタイルを登録する
 * 　プラグインパラメータ → スタイル登録
 * 　)好きな『スタイル名』を付け、
 * 　)『スキン』に登録したスキンの『スキン名』を書く
 * 　　これでスキンが適用される
 * 　※背面にスキン適用したい場合は『バックスキン』に適用したいスキン名を書く
 * ◎スタイルをウインドウに適用する
 * 　プラグインパラメータ → デザイン1
 * 　◇ズラリと項目が並んでいるが、変えたいウインドウの項目を選択する
 * 　　たとえばステータス全般を変えたい場合は『StatusBase』
 * 　　装備スロットを変えたいなら『EquipSlot』など
 * 　◇変えたいウインドウがリストにない場合は新しく追加する
 * 　　『対象ウインドウ』に変えたいウインドウのクラス名を書く
 * 　　ただし Window_ の部分は不要
 * 　　たとえば Window_MenuStatus なら MenuStatus だけでよい
 * 　◇『適用スタイル』に登録したスタイルの『スタイル名』を書く
 * 　　これでスタイルが適用される
 * 　　※デザインの各項目は「上から下へと上書きされる」
 * 　◇一番上(A)は対象シーン『MenuBase, Message』となっていて、
 * 　　ここのスタイルは全てのシーン、ウインドウに適用される
 * 　◇その下に対象ウインドウ『StatusBase』の項目(B)があった場合、
 * 　　AのスタイルをBのスタイルで上書きする
 * 　　具体的にはBスタイルで書かれている項目はそれを使用
 * 　　空欄の項目はAスタイルのものを使用する
 * 
 * 
 * 【機能2】スキンのアニメーションを変更
 * ◎アニメーションを登録する
 *  プラグインパラメータ → アニメーション登録
 * 　)新しい項目を追加
 * 　)好きな『アニメ名』を付け
 * 　)『アニメ時間』を好きな長さに設定
 * 　)『アニメ回数』は基本的に 1 でいいが、ループさせる場合は -1 に
 * 　※アニメ書式1 - 変動
 * 　　たとえば位置Xの場合、『位置X』と『→位置X』が存在する
 * 　　これは『位置X』から『→位置X』へと変動するという意味
 * 　　つまり『位置X』が -400、『→位置X』が 0 の場合は、
 * 　　画面X座標 -400 から 0 に向かって移動する
 * 　※アニメ書式2 - 計算記号
 * 　　『位置X』を +100 と書いた場合
 * 　　　=> 現在のX座標から +100 の位置に移動
 * 　　『位置X』を +-100 と書いた場合
 * 　　　=> 現在のX座標から -100 の位置に移動
 * 　　『スケールX』を *2 と書いた場合
 * 　　　=> X拡大率を 2倍 にする
 * 　　『スケールX』を /2 と書いた場合
 * 　　　=> X拡大率を 1/2倍 にする
 * 　※アニメ書式2 - イージング
 * 　　　値の語尾にイージング記号を付けることでイージング可能
 * 　　『位置X』を +100eo と書くなど
 * 　　 ◇e - イージングインアウト。ゆっくり-速い-ゆっくり。標準はこれ
 * 　　 ◇ei -イージングイン。ゆっくり-速い
 * 　　 ◇eo -  イージングアウト。速い-ゆっくり
 * 　　 ◇tn - ターン。→←。進んで戻る
 * 　　 ◇cg - チャージ。←→→。少し戻り一気に進む。cg(**)で戻り幅 **倍
 * 　　 ◇fk - フック。→→←。一気に進んで少し戻る。fk(**)で戻り幅 **倍
 * 　　 ◇cf - チャージフック。←→→←。cg と fk の融合。cf(**)で戻り幅 **倍
 * 　　 ◇rd - ラウンド。→←←→。ぐるりと円を描く
 * 　　 ◇bk - バック。←。戻ってくる
 * ◎アニメーションはサンプルがいくつか入っているので、それを使ってもよい
 * ◎スタイルに適用する
 * 　プラグインパラメータ → スタイル登録 → …スキンアニメ
 * 　)登録したアニメの『アニメ名』を書く
 * 
 * 
 * 【機能3】フォント設定を変更
 * ◎全体のフォント設定を変えたい場合
 * 　プラグインパラメータ → フォント登録 → メイン
 * 　)メインは全てのシーン、ウインドウに適用されるので、
 * 　　この内容を変更するだけでよい
 * ◎シーン毎、ウインドウ毎にフォント設定を変えたい場合
 * 　新しくフォント設定を作り、各スタイルに適用する
 *  ◇フォント設定を登録する
 * 　　プラグインパラメータ → フォント登録
 * 　　)好きな『フォント名』を付け、後は好きに設定していく
 *  ◇スタイルに適用する
 * 　　プラグインパラメータ → スタイル登録 → フォント/数字フォント
 * 　　)登録したフォントの『フォント名』を書く
 * 　　　数字フォントはゲージの数字部分にのみ適用されるフォント設定
 * 　　　空欄なら数字にも通常フォント設定が適用される
 *  ※メインフォントと別のフォントを使用する場合は、
 * 　プラグイン『Keke_CommonData』であらかじめ登録しておく必要がある
 * 
 * 
 * 【機能4】背景を変更
 * 　背景については【最初に】で設定したが、
 * 　ここではもう少し深堀りしていく
 * ◎シーン毎に背景を変更
 * 　【最初に】では背景をひとつだけ設定したが、
 * 　　シーン毎に背景を変えることもできる
 * 　　ここではアイテム画面で背景が変わるようにしてみる
 *  　◇背景を登録する
 * 　　　プラグインパラメータ → 背景登録
 * 　　　)好きな『背景名』を付け、
 * 　　　)好きな『画像』を選択、
 * 　　　)あとは好きに設定していく
 * 　　　※移動
 * 　　　　背景固有のパラメータに『移動X』『移動Y』がある
 * 　　　　背景を移動させることができる
 * 　　　　自動的にループするので背景が途切れることはない
 * ◎スタイルを登録する
 * 　プラグインパラメータ → スタイル登録
 * 　)新しく項目を作る
 * 　)『スタイル名』は「s-シーン/アイテム」とでも(何でもいい)
 * 　)『背景』に登録した背景の「背景名』を書く
 * 　)『…背景アニメ』にアニメーション登録した『アニメ名』を書くと、
 * 　　背景に開始アニメをさせることができる
 * 　　アニメを新しく作ってもいいが、
 * 　　ここはサンプルアニメの『開く』と書いておく
 * ◎シーンにスタイルを適用
 * 　プラグインパラメータ →　デザイン1
 * 　)新しく項目を作る
 * 　)『対象シーン』を「Item」(Scene_Itemを対象にするので)
 * 　)『適用スタイル』に登録したスタイルの『スタイル名』を書く
 * 
 * 
 * 【機能5】ピクチャを張り付ける
 * ◎ピクチャ(型)を登録する
 * 　プラグインパラメータ → ピクチャ登録
 * 　)好きな『ピクチャ名』を付け、
 * 　)好きな『画像』を選択
 * 　)あとは好きに設定していく
 * ◎ピクチャパックを登録する
 * 　ピクチャパックとは1画面に表示するピクチャの集まり
 * 　ピクチャパックにピクチャを追加し、
 * 　ピクチャパック全体を表示することでピクチャを表示する
 * 　)好きな『パック名』を付け、
 * 　)『ピクチャリスト』にピクチャを追加していく
 * 　　試しにひとつ追加してみよう
 * ◎ピクチャリストにピクチャを追加
 * 　)新しく項目を作る
 * 　)好きな『ピクチャ名』を付ける
 * 　)『使用ピクチャ』に登録したピクチャの『ピクチャ名』を書く
 * 　※ピクチャ名が二つあるが、ピクチャの“型”の名前と、
 * 　　“実際張り付けるピクチャ”の名前ということ。別物
 * 　)あとは好きに設定していく
 * 　　ピクチャはかなりたくさんのパラメータがあるが、
 * 　　詳しくは添付のヘルプを参照
 * 　)このような感じでピクチャを追加していき、
 * 　　ピクチャパックを構成する
 * ◎ピクチャパックをスタイルに適用する
 * 　※ピクチャパックはシーン対象のスタイルでのみ効果がある
 * 　プラグインパラメータ → スタイル登録 → ピクチャパック
 * 　)登録したピクチャパックの『パック名』を書く
 * 
 * 
 * 【機能6】メニューBGMを流す
 * 　メニューを開いた時に指定のBGMを流すことができる
 * 　メニューを出ると元のBGNに戻る
 * ◎BGMを登録する
 * 　プラグインパラメータ → BGM登録
 * 　)好きな『BGM名』を付け、
 * 　)好きな『ファイル』を選択
 * 　)あとは好きに設定していく
 * ◎スタイルに適用する
 * 　プラグインパラメータ → スタイル登録 → BGM
 * 　)登録したBGMの『BGN名』を書く
 * 
 * 
 * 【機能7】カーソルを変更
 * 　カーソルには二種類ある
 * ◎カーソルアニメ
 * 　スキンをアニメーションさせることでカーソル代わりとする
 * 　◇使うアニメを『アニメーション登録』する
 * 　◇スタイルに適用する
 * 　　プラグインパラメータ → スタイル登録 → カーソルアニメ
 * 　　登録したアニメの『アニメ名』を書く
 * 　　初期状態はこれ
 * ◎カーソルスキン
 * 　カーソル用スキンを表示する
 * 　◇使うスキンを『スキン登録』する
 * 　◇スタイルに適用する
 * 　　プラグインパラメータ → スタイル登録 → カーソルスキン
 * 　　登録したスキンの『スキン名』を書く
 * 
 * 
 * 【機能8】ゲーム中にデザイン変更
 * 　ゲーム中、動的にデザインを変更し、
 * 　メニューの見た目をガラリと変えることができる
 * ◎デザインを複数作る
 * 　プラグインパラメータ → デザイン1
 * 　という感じで今まではデザイン1だけを使ってきたが、
 * 　実はデザインは10個まで作れる
 * 　あらかじめデザインを複数作っておき、それを切り替えることで、
 * 　パッとデザイン変更することができる
 * ◎別のデザインに切り替える
 * 　プラグインコマンド → デザイン変更 → デザイン
 * 　)使用するデザインを選択する
 * 
 * 
 * 【機能9】背景、ピクチャ、BGMを一時的に変更
 * 　デザインを丸ごと変えなくとも、
 * 　背景、ピクチャ、BGMだけを一時的に変更できる
 * ◎背景を変更
 * 　プラグインコマンド　→ 背景変更 → 背景
 * 　)あらかじめ使いたい背景を登録しておき、その『背景名』を書く
 * ◎背景を戻す
 * 　プラグインコマンド　→ 背景戻す
 * 　)デザイン本来の背景に戻せる
 * ◎ピクチャパックを変更
 * 　プラグインコマンド　→ ピクチャパック変更 → ピクチャパック
 * 　)あらかじめ使いたいピクチャパックを登録しておき、その『パック名』を書く
 * ◎ピクチャパックを戻す
 * 　プラグインコマンド　→ ピクチャパック戻す
 * 　)デザイン本来のピクチャパックに戻せる
 * ◎BGMを変更
 * 　プラグインコマンド　→ BGM変更 → BGM
 * 　)あらかじめ使いたいBGMを登録しておき、その『BGM名』を書く
 * ◎BGMを戻す
 * 　プラグインコマンド　→ BGM戻す
 * 　)デザイン本来のBGMに戻せる
 * 
 * 
 * ● 利用規約 ●
 * MITライセンスのもと、自由に使ってくれて大丈夫です
 *
 *
 * 
 * ● Features ●
 * 
 * ◎ Apply skin to each window
 * ◎ Skin animation
 * ◎ Change the font for each window
 * ◎ Movable background
 * ◎ Paste the picture where you like
 * ◎ BGM played in the menu
 * ◎ Dynamic design changes during the game
 *
 *
 * ● How to use ●
 *
 * [Basics] What to do first
 * [1] Put images to be used for skins, backgrounds,
 * 　and frames in the Pictures folder
 * 　img/pictures
 * 　The background and frame can be omitted. It's cool to have. as you like
 *   ※ There are no restrictions on image size or shape.
 *     The display size and shape are automatically adjusted,
 *     so you can just throw in whatever you want.
 *     If it is too small, it will be blurred, and if it is too large,
 *     it will waste space.
 * 　※ It loops when the background is moved,
 *     but it does not have to be a loop-compatible image
 *     Any image will be looped with special processing that does not break, so
 *     Can be used as a background without problems.
 * [2] Choose a design
 * 　In the initial state
 * 　◎ design1 → Simple animation
 * 　◎ design2 → Dynamic animation
 * 　has become. choose who you like
 * 　Design 1 is the default setting. For design 2
 * 　Plug-in parameters → start design
 * 　　Select design 2 with
 * [3] Set skin image
 * 　Plugin parameters → skinMaking → d1-ベース → image
 * 　※ d2-base for design 2
 * 　　Select the image inserted in [1]
 * [4] Set background image
 * 　Plugin parameters → backMaking → d1-背景 → image
 * 　※ d2-background for design 2
 * 　　Select the image inserted in [1]
 * [5] Set frame image
 * 　Plugin parameters → pictureMaking → d1-フレーム → image
 * 　※ d2-frame for design 2
 * 　　Select the image inserted in [1]
 * [6] Set background music
 * 　Plugin parameter → BGMMaking → d1-BGM → File
 *   ※ d2-BGM for design 2
 * 　　Select your favorite BGM file
 * 　　If you don't want to play BGM, leave it unselected
 * [7] Test play. open the menu
 * 　The skin should have been applied
 * [8] That's it, initial setup done
 * 　This alone works, but
 * 　After that, remodel it as you like
 *
 *
 * [Function map]
 * ■ Set skin for each window => Function 1 (Important, should be seen first)
 * ■ Change skin animation => Function 2
 * ■ Change font settings => Feature 3
 * ■ Change the background => Feature 4
 * ■ Paste a picture => Feature 5
 * ■ Play menu BGM => Function 6
 * ■ Change cursor => Function 7
 * ■ Design changes during the game => Feature 8
 * ■ Change background, picture and BGM individually => Feature 9
 *
 *
 * [Function 1] Set skin for each window
 * ◎ As the structure of this plug-in,
 * 　"style" (assortment of various settings) for each window (or scene)
 * 　Apply and control the state according to its contents
 * 　Skin settings are also included in the style
 * ◎ So if you want to change the skin,
 * 　Apply a style to the window, and in that style,
 *　 All you have to do is set the skin to use
 * ◎ First, register the skin
 * 　Plugin parameters → skinMaking
 * 　) Add your favorite "skinName",
 * 　) Select your favorite "image",
 * 　) After that, set the position and magnification as you like
 * ◎ Next, register the style
 * 　Plugin parameter → styleMaking
 * 　) Add your favorite "styleName",
 * 　) Write the "skinName" of the registered skin in "skin"
 * 　　Now the skin is applied
 *   ※ If you want to apply a skin to the back,
 *     write the name of the skin you want to apply to "backSkin"
 * ◎ Apply style to window
 * 　Plugin parameters → design1
 * 　◇ Items are lined up in a row, but select the item
 * 　　in the window you want to change
 * 　　For example, if you want to change the overall status, "statusBase"
 * 　　If you want to change the equipment slot, use "equipSlot" etc.
 * 　◇ If the window you want to change is not in the list, add it newly
 * 　　Write the class name of the window you want to change to "subjectWindow"
 * 　　However, the Window_ part is unnecessary
 * 　　For example, for Window_MenuStatus, you only need MenuStatus
 * 　◇ Write the "styleName" of the style registered in "applied style"
 * 　　Now the style is applied
 * 　　※ Each item in the design is "overwritten from top to bottom"
 * 　◇ The top (A) is the target scene "menuBase, message",
 * 　　The style here is applied to all scenes and windows
 * 　◇ If there is an item (B) of the target window "StatusBase" below it,
 * 　　Overwrite A's style with B's style
 * 　　Specifically, items written in B style use it
 * 　　Blank items use A style
 *
 *
 * [Feature 2] Change skin animation
 * ◎ Register animation
 * 　Plugin parameters → animeMaking
 * 　) Add new item
 * 　) Add your favorite "animeName"
 * 　) Set "animeTime" to your desired length
 * 　) "animeTimes" is basically 1,
 * 　　but if you want it to loop, set it to -1
 * 　※ Animation format 1 - variation
 * 　　For example, in the case of position X,
 * 　　there are "posX" and "→ posX"
 * 　　This means that it fluctuates from "posX" to "→ posX"
 * 　　In other words, if "posX" is -400 and "→ posX" is 0,
 * 　　Move from screen X coordinate -400 to 0
 * 　※ Animation format 2 - calculation symbol
 * 　　When "posX" is written as +100
 * 　　=> Move to +100 position from current X coordinate
 * 　　When "posX" is written as +-100
 * 　　=> Move to position -100 from current X coordinate
 * 　　When "scaleX" is written as *2
 * 　　=> Double the X magnification
 * 　　When "scaleX" is written as /2
 * 　　=> Set the X magnification ratio to 1/2
 * 　※ Animation format 2 - Easing
 * 　　Easing is possible by adding an easing symbol to the end of the value
 * 　　For example, write "posX" as +100eo
 * 　　◇e - Easing In Out. Slow-fast-slow. the standard is this
 * 　　◇ei - Easing in. slow-fast
 * 　　◇eo - Easing out. fast-slow
 * 　　◇tn - turn. →←. willing to go back
 * 　　◇cg - charge. ←→→. Go back a little and move on.
 * 　　　　Return width ** times with cg(**)
 * 　　◇fk - Hook. →→←. Go forward and back a little.
 * 　　　　Return width ** times with fk(**)
 * 　　◇cf - Charge hook. ←→→←. Fusion of cg and fk.
 * 　　　　Return width ** times with cf(**)
 * 　　◇rd - Round. →←←→. draw a circle around
 * 　　◇bk - Back. ←. Come back
 * ◎ There are some animation samples, so you can use them.
 * ◎ apply to style
 * 　Plug-in parameters → style registration → ... skin animation
 * 　) Write the "animeName" of the registered anime
 *
 *
 * [Feature 3] Change font settings
 * ◎ If you want to change the overall font settings
 * 　Plugin parameters → fontMaking → メイン
 * 　) Main applies to all scenes and windows, so
 * 　  Just change this content
 * ◎ If you want to change the font settings for each scene or window
 * 　Create a new font settings and apply it to each style
 * 　◇ Register fonts settings
 * 　　Plugin parameter → fontMaking
 * 　　) Add your favorite "fontName", and then set it as you like
 * 　◇ Apply to style
 * 　　Plugin parameters → styleMaking → font / number font
 *　　 ) Write the "fontName" of the registered font settings
 * 　　  If the field is blank,
 *       the normal font settings is also applied to numbers.
 * 　※ If you want to use a different font from the main font,
 * 　　It is necessary to register in advance
 * 　　with the plug-in "Keke_CommonData"
 *
 *
 * [Feature 4] Change the background
 * 　The background was set in [First], but
 * 　Here we will dig a little deeper
 * ◎ Change the background for each scene
 * 　In [First], only one background was set,
 * 　You can also change the background for each scene
 * 　Here, try to change the background on the item screen
 * ◇ Register a background
 * 　Plugin parameter → backMaking
 * 　) Add your favorite "backName",
 * 　) Select your favorite "image",
 * 　) After that, set it as you like
 * 　※ Move
 * 　　Background-specific parameters include "moveX" and "moveY"
 * 　　You can move the background
 * 　　Automatically loops so the background is never interrupted
 * ◎ Register a style
 * 　Plugin parameter → styleMaking
 * 　) Create a new item
 * 　) "styleName" can be "s-シーン/アイテム" (whatever you want)
 * 　) Write the "backName" of the registered background
 * 　　in "back"
 * 　) If you write the "animeName" 
 * 　　that was registered as an animation in "...backAnime",
 * 　　You can set the background to start animation
 * 　　You can make a new animation, but
 * 　　Write "open" in the sample animation here
 * ◎Apply style to scene
 * 　Plugin parameters → design1
 * 　) Create a new item
 * 　) "subjectScene" is "item" (because it targets Scene_Item)
 * 　) Write the "styleName" of the registered style in "applystyle"
 *
 *
 * [Feature 5] Paste a picture
 * ◎ Register a picture (type)
 * 　Plug-in parameter → pictureMaking
 * 　) Add your favorite "pictureName",
 * 　) Select your favorite "image"
 * 　) After that, set it as you like
 * ◎ Register Picture Pack
 * 　A picture pack is a collection of pictures displayed on one screen
 * 　Add pictures to the picture pack,
 * 　Display a picture by displaying the entire picture pack
 * 　) Add your favorite "packName",
 * 　) Add pictures to the "pictureList"
 * 　Let's try adding one
 * ◎ Add pictures to picture list
 * 　) Create a new item
 * 　) Add your favorite "pictureMame"
 * 　) Write the "pictureName" of the registered picture in "UsePcture"
 * 　※ There are two picture names, the "type" name of the picture and
 * 　　The name of the "actually pasted picture". another thing
 * 　) After that, set it as you like
 * 　　A picture has quite a lot of parameters, but
 * 　　See the attached help for details
 * 　) Add pictures like this,
 * 　　Configure picture pack
 * ◎ Apply picture packs to styles
 * 　※ Picture packs are effective only in scene-targeted styles
 * 　Plug-in parameter → styleMaking → picturePack
 * 　) Write the "packName" of the registered picture pack
 *
 *
 * [Feature 6] Play menu BGM
 * 　The specified BGM can be played when the menu is opened
 * 　Returns to the original BGN when exiting the menu
 * ◎ Register BGM
 * 　Plug-in parameter → bgmMaking
 * 　) Add your favorite "bgmName",
 * 　) Select your favorite "file"
 * 　) After that, set it as you like
 * ◎ apply to style
 * 　Plug-in parameter → styleMaking → BGM
 * 　) Write the "bgmName" of the registered BGM
 * 
 * 
 * [Function 7] Change cursor
 * 　There are two types of cursors
 * ◎ Cursor animation
 * 　By animating the skin, it can be used as a cursor
 * 　◇ "animeMaking" for the animation to be used
 * 　◇ Apply to style
 * 　　Plug-in parameter → styleMaking → cursorAnime
 * 　　Write the "animeName" of the registered anime
 * 　　This is the initial state
 * ◎ Cursor Skin
 * 　Display cursor skin
 * 　◇ "skinMaking" for the skin to be used
 * 　◇ Apply to style
 * 　　Plugin parameters → styleMaking → cursorSkin
 * 　　Write the "skinName" of the registered skin
 *
 *
 * [Feature 8] Change the design during the game
 * 　Dynamically change the design during the game,
 * 　You can completely change the appearance of the menu
 * ◎ Make multiple designs
 * 　Plugin parameter → design1
 * 　So far, I've only used Design 1, but
 * 　Actually, you can make up to 10 designs.
 * 　By creating multiple designs in advance and switching between them,
 * 　The design can be changed at once
 * ◎ Switch to another design
 * 　Plugin command → chaingeDesign → design
 * 　) Select the design to use
 *
 *
 * [Function 9] Temporarily change the background, picture, and BGM
 * 　Even if you don't change the design completely,
 * 　Only backgrounds, pictures, and BGM can be changed temporarily
 * ◎ Change the background
 * 　Plugin command → changeBack → back
 * 　) Register the background you want to use
 * 　　in advance and write the "backName"
 * ◎ Restore the background
 * 　Plugin command  → undoBack
 * 　) You can return to the original background of the design
 * ◎ Change picture pack
 * 　Plugin command → ChangePicturePack → picturePack
 * 　) Register the picture pack you want to use
 * 　　in advance and write the "packName"
 * ◎ Return picture pack
 * 　Plug-in command → undoPicture
 * 　) You can return to the original picture pack design
 * ◎ Change BGM
 * 　Plugin command → bgmChange → BGM
 * 　) Register the BGM you want to use
 * 　　in advance and write the "bgmName"
 * ◎ Restore BGM
 * 　Plug-in command　→ undoBGM
 * 　) You can return to the original BGM of the design
 *
 *
 * ● Terms of Use ●
 * Feel free to use it under the MIT license.
 * 
 * 
 * 
 * @param ■登録1
 * 
 * @param スタイル登録
 * @parent ■登録1
 * @desc styleMaking スタイルを登録する
 * @type struct<style>[]
 * @default ["{\"スタイル名\":\"■デザイン1\",\"スキン\":\"\",\"…スキンアニメ\":\"\",\"ウインドウ消す\":\"true\",\"フォント\":\"\",\"数字フォント\":\"\",\"■シーン設定\":\"\",\"カーソルアニメ-開始\":\"\",\"カーソルアニメ\":\"\",\"…カラートーン補正\":\"\",\"カーソルスキン\":\"\",\"背景\":\"\",\"…背景アニメ\":\"\",\"メニュー終了アニメ\":\"\",\"ピクチャパック\":\"\",\"BGM\":\"\",\"■その他設定\":\"\",\"並べ替えカーソル色\":\"\",\"並べ替えカーソル丸み\":\"\",\"バックスキン\":\"\",\"バック塗り\":\"\",\"手前に表示\":\"\"}","{\"スタイル名\":\"d1-シーン/ベース\",\"スキン\":\"d1-ベース\",\"…スキンアニメ\":\"左から出る\",\"ウインドウ消す\":\"true\",\"フォント\":\"メイン\",\"数字フォント\":\"数字\",\"■シーン設定\":\"\",\"カーソルアニメ-開始\":\"\",\"カーソルアニメ\":\"セレクト, セレクト中\",\"…カラートーン補正\":\"180\",\"カーソルスキン\":\"\",\"背景\":\"d1-背景\",\"…背景アニメ\":\"縮小開く-速\",\"メニュー終了アニメ\":\"縮小閉じ\",\"ピクチャパック\":\"d1-ピクチャ\",\"BGM\":\"d1-BGM\",\"■その他設定\":\"\",\"並べ替えカーソル色\":\"255, 224, 0\",\"並べ替えカーソル丸み\":\"50, 0\",\"バックスキン\":\"\",\"バック塗り\":\"\",\"手前に表示\":\"\"}","{\"スタイル名\":\"d1-シーン/ショップ\",\"スキン\":\"\",\"…スキンアニメ\":\"\",\"ウインドウ消す\":\"\",\"フォント\":\"\",\"数字フォント\":\"\",\"■シーン設定\":\"\",\"カーソルアニメ-開始\":\"\",\"カーソルアニメ\":\"\",\"…カラートーン補正\":\"\",\"カーソルスキン\":\"\",\"背景\":\"\",\"…背景アニメ\":\"\",\"メニュー終了アニメ\":\"\",\"ピクチャパック\":\"\",\"BGM\":\"\",\"■その他設定\":\"\",\"並べ替えカーソル色\":\"\",\"並べ替えカーソル丸み\":\"\",\"バックスキン\":\"\",\"バック塗り\":\"\",\"手前に表示\":\"\"}","{\"スタイル名\":\"d1-ステータスベース\",\"スキン\":\"d1-ステータスベース\",\"…スキンアニメ\":\"右から出る\",\"ウインドウ消す\":\"\",\"フォント\":\"\",\"数字フォント\":\"\",\"■シーン設定\":\"\",\"カーソルアニメ-開始\":\"\",\"カーソルアニメ\":\"\",\"…カラートーン補正\":\"\",\"カーソルスキン\":\"\",\"背景\":\"\",\"…背景アニメ\":\"\",\"メニュー終了アニメ\":\"\",\"ピクチャパック\":\"\",\"BGM\":\"\",\"■その他設定\":\"\",\"並べ替えカーソル色\":\"\",\"並べ替えカーソル丸み\":\"\",\"バックスキン\":\"d1-バックステータス\",\"バック塗り\":\"\",\"手前に表示\":\"\"}","{\"スタイル名\":\"d1-リスト\",\"スキン\":\"d1-リスト\",\"…スキンアニメ\":\"右から出る\",\"ウインドウ消す\":\"\",\"フォント\":\"\",\"数字フォント\":\"\",\"■シーン設定\":\"\",\"カーソルアニメ-開始\":\"\",\"カーソルアニメ\":\"\",\"…カラートーン補正\":\"\",\"カーソルスキン\":\"\",\"背景\":\"\",\"…背景アニメ\":\"\",\"メニュー終了アニメ\":\"\",\"ピクチャパック\":\"\",\"BGM\":\"\",\"■その他設定\":\"\",\"並べ替えカーソル色\":\"\",\"並べ替えカーソル丸み\":\"\",\"バックスキン\":\"\",\"バック塗り\":\"\",\"手前に表示\":\"\"}","{\"スタイル名\":\"d1-装備スロット\",\"スキン\":\"d1-スロット\",\"…スキンアニメ\":\"左から出る\",\"ウインドウ消す\":\"\",\"フォント\":\"\",\"数字フォント\":\"\",\"■シーン設定\":\"\",\"カーソルアニメ-開始\":\"\",\"カーソルアニメ\":\"\",\"…カラートーン補正\":\"\",\"カーソルスキン\":\"\",\"背景\":\"\",\"…背景アニメ\":\"\",\"メニュー終了アニメ\":\"\",\"ピクチャパック\":\"\",\"BGM\":\"\",\"■その他設定\":\"\",\"並べ替えカーソル色\":\"\",\"並べ替えカーソル丸み\":\"\",\"バックスキン\":\"none\",\"バック塗り\":\"\",\"手前に表示\":\"\"}","{\"スタイル名\":\"d1-ステータス\",\"スキン\":\"\",\"…スキンアニメ\":\"左から出る\",\"ウインドウ消す\":\"\",\"フォント\":\"\",\"数字フォント\":\"\",\"■シーン設定\":\"\",\"カーソルアニメ-開始\":\"\",\"カーソルアニメ\":\"\",\"…カラートーン補正\":\"\",\"カーソルスキン\":\"\",\"背景\":\"\",\"…背景アニメ\":\"\",\"メニュー終了アニメ\":\"\",\"ピクチャパック\":\"\",\"BGM\":\"\",\"■その他設定\":\"\",\"並べ替えカーソル色\":\"\",\"並べ替えカーソル丸み\":\"\",\"バックスキン\":\"\",\"バック塗り\":\"\",\"手前に表示\":\"\"}","{\"スタイル名\":\"d1-ステータスパラム\",\"スキン\":\"\",\"…スキンアニメ\":\"右から出る\",\"ウインドウ消す\":\"\",\"フォント\":\"\",\"数字フォント\":\"\",\"■シーン設定\":\"\",\"カーソルアニメ-開始\":\"\",\"カーソルアニメ\":\"\",\"…カラートーン補正\":\"\",\"カーソルスキン\":\"\",\"背景\":\"\",\"…背景アニメ\":\"\",\"メニュー終了アニメ\":\"\",\"ピクチャパック\":\"\",\"BGM\":\"\",\"■その他設定\":\"\",\"並べ替えカーソル色\":\"\",\"並べ替えカーソル丸み\":\"\",\"バックスキン\":\"\",\"バック塗り\":\"\",\"手前に表示\":\"\"}","{\"スタイル名\":\"d1-縦リスト\",\"スキン\":\"\",\"…スキンアニメ\":\"\",\"ウインドウ消す\":\"\",\"フォント\":\"\",\"数字フォント\":\"\",\"■シーン設定\":\"\",\"カーソルアニメ-開始\":\"\",\"カーソルアニメ\":\"\",\"…カラートーン補正\":\"\",\"カーソルスキン\":\"\",\"背景\":\"\",\"…背景アニメ\":\"\",\"メニュー終了アニメ\":\"\",\"ピクチャパック\":\"\",\"BGM\":\"\",\"■その他設定\":\"\",\"並べ替えカーソル色\":\"\",\"並べ替えカーソル丸み\":\"\",\"バックスキン\":\"\",\"バック塗り\":\"\",\"手前に表示\":\"\"}","{\"スタイル名\":\"d1-ゴールド\",\"スキン\":\"d1-ゴールド\",\"…スキンアニメ\":\"\",\"ウインドウ消す\":\"\",\"フォント\":\"\",\"数字フォント\":\"\",\"■シーン設定\":\"\",\"カーソルアニメ-開始\":\"\",\"カーソルアニメ\":\"\",\"…カラートーン補正\":\"\",\"カーソルスキン\":\"\",\"背景\":\"\",\"…背景アニメ\":\"\",\"メニュー終了アニメ\":\"\",\"ピクチャパック\":\"\",\"BGM\":\"\",\"■その他設定\":\"\",\"並べ替えカーソル色\":\"\",\"並べ替えカーソル丸み\":\"\",\"バックスキン\":\"\",\"バック塗り\":\"\",\"手前に表示\":\"\"}","{\"スタイル名\":\"d1-ヘルプ\",\"スキン\":\"d1-ヘルプ\",\"…スキンアニメ\":\"\",\"ウインドウ消す\":\"\",\"フォント\":\"\",\"数字フォント\":\"\",\"■シーン設定\":\"\",\"カーソルアニメ-開始\":\"\",\"カーソルアニメ\":\"\",\"…カラートーン補正\":\"\",\"カーソルスキン\":\"\",\"背景\":\"\",\"…背景アニメ\":\"\",\"メニュー終了アニメ\":\"\",\"ピクチャパック\":\"\",\"BGM\":\"\",\"■その他設定\":\"\",\"並べ替えカーソル色\":\"\",\"並べ替えカーソル丸み\":\"\",\"バックスキン\":\"\",\"バック塗り\":\"\",\"手前に表示\":\"\"}","{\"スタイル名\":\"d1-ショップ決済\",\"スキン\":\"\",\"…スキンアニメ\":\"\",\"ウインドウ消す\":\"\",\"フォント\":\"\",\"数字フォント\":\"\",\"■シーン設定\":\"\",\"カーソルアニメ-開始\":\"\",\"カーソルアニメ\":\"\",\"…カラートーン補正\":\"\",\"カーソルスキン\":\"\",\"背景\":\"\",\"…背景アニメ\":\"\",\"メニュー終了アニメ\":\"\",\"ピクチャパック\":\"\",\"BGM\":\"\",\"■その他設定\":\"\",\"並べ替えカーソル色\":\"\",\"並べ替えカーソル丸み\":\"\",\"バックスキン\":\"d1-バックショップ\",\"バック塗り\":\"\",\"手前に表示\":\"\"}","{\"スタイル名\":\"■デザイン2\",\"スキン\":\"\",\"…スキンアニメ\":\"\",\"ウインドウ消す\":\"true\",\"フォント\":\"\",\"数字フォント\":\"\",\"■シーン設定\":\"\",\"カーソルアニメ-開始\":\"\",\"カーソルアニメ\":\"\",\"…カラートーン補正\":\"\",\"カーソルスキン\":\"\",\"背景\":\"\",\"…背景アニメ\":\"\",\"メニュー終了アニメ\":\"\",\"ピクチャパック\":\"\",\"BGM\":\"\",\"■その他設定\":\"\",\"並べ替えカーソル色\":\"\",\"並べ替えカーソル丸み\":\"\",\"バックスキン\":\"\",\"バック塗り\":\"\",\"手前に表示\":\"\"}","{\"スタイル名\":\"d2-シーン/ベース\",\"スキン\":\"d2-ベース\",\"…スキンアニメ\":\"ダイナミックインL\",\"ウインドウ消す\":\"true\",\"フォント\":\"メイン\",\"数字フォント\":\"数字\",\"■シーン設定\":\"\",\"カーソルアニメ-開始\":\"セレクト\",\"カーソルアニメ\":\"セレクト中\",\"…カラートーン補正\":\"180\",\"カーソルスキン\":\"\",\"背景\":\"d2-背景\",\"…背景アニメ\":\"縮小開く\",\"メニュー終了アニメ\":\"拡大閉じ\",\"ピクチャパック\":\"d2-ピクチャ\",\"BGM\":\"d2-BGM\",\"■その他設定\":\"\",\"並べ替えカーソル色\":\"255, 224, 0\",\"並べ替えカーソル丸み\":\"\",\"バックスキン\":\"\",\"バック塗り\":\"\",\"手前に表示\":\"\"}","{\"スタイル名\":\"d2-シーン/ショップ\",\"スキン\":\"\",\"…スキンアニメ\":\"\",\"ウインドウ消す\":\"\",\"フォント\":\"\",\"数字フォント\":\"\",\"■シーン設定\":\"\",\"カーソルアニメ-開始\":\"\",\"カーソルアニメ\":\"\",\"…カラートーン補正\":\"\",\"カーソルスキン\":\"\",\"背景\":\"\",\"…背景アニメ\":\"\",\"メニュー終了アニメ\":\"\",\"ピクチャパック\":\"\",\"BGM\":\"\",\"■その他設定\":\"\",\"並べ替えカーソル色\":\"\",\"並べ替えカーソル丸み\":\"\",\"バックスキン\":\"\",\"バック塗り\":\"\",\"手前に表示\":\"\"}","{\"スタイル名\":\"d2-ステータスベース\",\"スキン\":\"d2-ステータスベース\",\"…スキンアニメ\":\"ダイナミックインR\",\"ウインドウ消す\":\"\",\"フォント\":\"\",\"数字フォント\":\"\",\"■シーン設定\":\"\",\"カーソルアニメ-開始\":\"\",\"カーソルアニメ\":\"\",\"…カラートーン補正\":\"\",\"カーソルスキン\":\"\",\"背景\":\"\",\"…背景アニメ\":\"\",\"メニュー終了アニメ\":\"\",\"ピクチャパック\":\"\",\"BGM\":\"\",\"■その他設定\":\"\",\"並べ替えカーソル色\":\"\",\"並べ替えカーソル丸み\":\"\",\"バックスキン\":\"d2-バックステータス\",\"バック塗り\":\"\",\"手前に表示\":\"\"}","{\"スタイル名\":\"d2-リスト\",\"スキン\":\"d2-リスト\",\"…スキンアニメ\":\"ダイナミックインR\",\"ウインドウ消す\":\"\",\"フォント\":\"\",\"数字フォント\":\"\",\"■シーン設定\":\"\",\"カーソルアニメ-開始\":\"\",\"カーソルアニメ\":\"\",\"…カラートーン補正\":\"\",\"カーソルスキン\":\"\",\"背景\":\"\",\"…背景アニメ\":\"\",\"メニュー終了アニメ\":\"\",\"ピクチャパック\":\"\",\"BGM\":\"\",\"■その他設定\":\"\",\"並べ替えカーソル色\":\"\",\"並べ替えカーソル丸み\":\"\",\"バックスキン\":\"\",\"バック塗り\":\"\",\"手前に表示\":\"\"}","{\"スタイル名\":\"d2-スキルステータス\",\"スキン\":\"\",\"…スキンアニメ\":\"ダイナミックインR-2\",\"ウインドウ消す\":\"\",\"フォント\":\"\",\"数字フォント\":\"\",\"■シーン設定\":\"\",\"カーソルアニメ-開始\":\"\",\"カーソルアニメ\":\"\",\"…カラートーン補正\":\"\",\"カーソルスキン\":\"\",\"背景\":\"\",\"…背景アニメ\":\"\",\"メニュー終了アニメ\":\"\",\"ピクチャパック\":\"\",\"BGM\":\"\",\"■その他設定\":\"\",\"並べ替えカーソル色\":\"\",\"並べ替えカーソル丸み\":\"\",\"バックスキン\":\"\",\"バック塗り\":\"\",\"手前に表示\":\"\"}","{\"スタイル名\":\"d2-装備スロット\",\"スキン\":\"d2-スロット\",\"…スキンアニメ\":\"ダイナミックインL-2\",\"ウインドウ消す\":\"\",\"フォント\":\"\",\"数字フォント\":\"\",\"■シーン設定\":\"\",\"カーソルアニメ-開始\":\"\",\"カーソルアニメ\":\"\",\"…カラートーン補正\":\"\",\"カーソルスキン\":\"\",\"背景\":\"\",\"…背景アニメ\":\"\",\"メニュー終了アニメ\":\"\",\"ピクチャパック\":\"\",\"BGM\":\"\",\"■その他設定\":\"\",\"並べ替えカーソル色\":\"\",\"並べ替えカーソル丸み\":\"\",\"バックスキン\":\"none\",\"バック塗り\":\"\",\"手前に表示\":\"\"}","{\"スタイル名\":\"d2-ステータス\",\"スキン\":\"\",\"…スキンアニメ\":\"ダイナミックインL\",\"ウインドウ消す\":\"\",\"フォント\":\"\",\"数字フォント\":\"\",\"■シーン設定\":\"\",\"カーソルアニメ-開始\":\"\",\"カーソルアニメ\":\"\",\"…カラートーン補正\":\"\",\"カーソルスキン\":\"\",\"背景\":\"\",\"…背景アニメ\":\"\",\"メニュー終了アニメ\":\"\",\"ピクチャパック\":\"\",\"BGM\":\"\",\"■その他設定\":\"\",\"並べ替えカーソル色\":\"\",\"並べ替えカーソル丸み\":\"\",\"バックスキン\":\"\",\"バック塗り\":\"\",\"手前に表示\":\"\"}","{\"スタイル名\":\"d2-ステータスパラム\",\"スキン\":\"\",\"…スキンアニメ\":\"ダイナミックインL-2\",\"ウインドウ消す\":\"\",\"フォント\":\"\",\"数字フォント\":\"\",\"■シーン設定\":\"\",\"カーソルアニメ-開始\":\"\",\"カーソルアニメ\":\"\",\"…カラートーン補正\":\"\",\"カーソルスキン\":\"\",\"背景\":\"\",\"…背景アニメ\":\"\",\"メニュー終了アニメ\":\"\",\"ピクチャパック\":\"\",\"BGM\":\"\",\"■その他設定\":\"\",\"並べ替えカーソル色\":\"\",\"並べ替えカーソル丸み\":\"\",\"バックスキン\":\"\",\"バック塗り\":\"\",\"手前に表示\":\"\"}","{\"スタイル名\":\"d2-縦リスト\",\"スキン\":\"\",\"…スキンアニメ\":\"ダイナミックインU\",\"ウインドウ消す\":\"\",\"フォント\":\"\",\"数字フォント\":\"\",\"■シーン設定\":\"\",\"カーソルアニメ-開始\":\"\",\"カーソルアニメ\":\"\",\"…カラートーン補正\":\"\",\"カーソルスキン\":\"\",\"背景\":\"\",\"…背景アニメ\":\"\",\"メニュー終了アニメ\":\"\",\"ピクチャパック\":\"\",\"BGM\":\"\",\"■その他設定\":\"\",\"並べ替えカーソル色\":\"\",\"並べ替えカーソル丸み\":\"\",\"バックスキン\":\"\",\"バック塗り\":\"\",\"手前に表示\":\"\"}","{\"スタイル名\":\"d2-ゴールド\",\"スキン\":\"d2-ゴールド\",\"…スキンアニメ\":\"ダイナミックインL-2\",\"ウインドウ消す\":\"\",\"フォント\":\"\",\"数字フォント\":\"\",\"■シーン設定\":\"\",\"カーソルアニメ-開始\":\"\",\"カーソルアニメ\":\"\",\"…カラートーン補正\":\"\",\"カーソルスキン\":\"\",\"背景\":\"\",\"…背景アニメ\":\"\",\"メニュー終了アニメ\":\"\",\"ピクチャパック\":\"\",\"BGM\":\"\",\"■その他設定\":\"\",\"並べ替えカーソル色\":\"\",\"並べ替えカーソル丸み\":\"\",\"バックスキン\":\"\",\"バック塗り\":\"\",\"手前に表示\":\"\"}","{\"スタイル名\":\"d2-ヘルプ\",\"スキン\":\"d2-ヘルプ\",\"…スキンアニメ\":\"\",\"ウインドウ消す\":\"\",\"フォント\":\"\",\"数字フォント\":\"\",\"■シーン設定\":\"\",\"カーソルアニメ-開始\":\"\",\"カーソルアニメ\":\"\",\"…カラートーン補正\":\"\",\"カーソルスキン\":\"\",\"背景\":\"\",\"…背景アニメ\":\"\",\"メニュー終了アニメ\":\"\",\"ピクチャパック\":\"\",\"BGM\":\"\",\"■その他設定\":\"\",\"並べ替えカーソル色\":\"\",\"並べ替えカーソル丸み\":\"\",\"バックスキン\":\"\",\"バック塗り\":\"\",\"手前に表示\":\"\"}","{\"スタイル名\":\"d2-ショップ決済\",\"スキン\":\"\",\"…スキンアニメ\":\"\",\"ウインドウ消す\":\"\",\"フォント\":\"\",\"数字フォント\":\"\",\"■シーン設定\":\"\",\"カーソルアニメ-開始\":\"\",\"カーソルアニメ\":\"\",\"…カラートーン補正\":\"\",\"カーソルスキン\":\"\",\"背景\":\"\",\"…背景アニメ\":\"\",\"メニュー終了アニメ\":\"\",\"ピクチャパック\":\"\",\"BGM\":\"\",\"■その他設定\":\"\",\"並べ替えカーソル色\":\"\",\"並べ替えカーソル丸み\":\"\",\"バックスキン\":\"d2-バックショップ\",\"バック塗り\":\"\",\"手前に表示\":\"\"}","{\"スタイル名\":\"d2-名前変更\",\"スキン\":\"\",\"…スキンアニメ\":\"ダイナミックインL\",\"ウインドウ消す\":\"\",\"フォント\":\"\",\"数字フォント\":\"\",\"■シーン設定\":\"\",\"カーソルアニメ-開始\":\"\",\"カーソルアニメ\":\"\",\"…カラートーン補正\":\"\",\"カーソルスキン\":\"\",\"背景\":\"\",\"…背景アニメ\":\"\",\"メニュー終了アニメ\":\"\",\"ピクチャパック\":\"\",\"BGM\":\"\",\"■その他設定\":\"\",\"並べ替えカーソル色\":\"\",\"並べ替えカーソル丸み\":\"\",\"バックスキン\":\"\",\"バック塗り\":\"\",\"手前に表示\":\"\"}","{\"スタイル名\":\"d2-名前入力\",\"スキン\":\"\",\"…スキンアニメ\":\"ダイナミックインR\",\"ウインドウ消す\":\"\",\"フォント\":\"\",\"数字フォント\":\"\",\"■シーン設定\":\"\",\"カーソルアニメ-開始\":\"\",\"カーソルアニメ\":\"\",\"…カラートーン補正\":\"\",\"カーソルスキン\":\"\",\"背景\":\"\",\"…背景アニメ\":\"\",\"メニュー終了アニメ\":\"\",\"ピクチャパック\":\"\",\"BGM\":\"\",\"■その他設定\":\"\",\"並べ替えカーソル色\":\"\",\"並べ替えカーソル丸み\":\"\",\"バックスキン\":\"\",\"バック塗り\":\"\",\"手前に表示\":\"\"}","{\"スタイル名\":\"■その他\",\"スキン\":\"\",\"…スキンアニメ\":\"\",\"ウインドウ消す\":\"true\",\"フォント\":\"\",\"数字フォント\":\"\",\"■シーン設定\":\"\",\"カーソルアニメ-開始\":\"\",\"カーソルアニメ\":\"\",\"…カラートーン補正\":\"\",\"カーソルスキン\":\"\",\"背景\":\"\",\"…背景アニメ\":\"\",\"メニュー終了アニメ\":\"\",\"ピクチャパック\":\"\",\"BGM\":\"\",\"■その他設定\":\"\",\"並べ替えカーソル色\":\"\",\"並べ替えカーソル丸み\":\"\",\"バックスキン\":\"\",\"バック塗り\":\"\",\"手前に表示\":\"\"}","{\"スタイル名\":\"確認\",\"スキン\":\"\",\"…スキンアニメ\":\"\",\"ウインドウ消す\":\"\",\"フォント\":\"\",\"数字フォント\":\"\",\"■シーン設定\":\"\",\"カーソルアニメ-開始\":\"\",\"カーソルアニメ\":\"\",\"…カラートーン補正\":\"\",\"カーソルスキン\":\"\",\"背景\":\"\",\"…背景アニメ\":\"\",\"メニュー終了アニメ\":\"\",\"ピクチャパック\":\"\",\"BGM\":\"\",\"■その他設定\":\"\",\"並べ替えカーソル色\":\"\",\"並べ替えカーソル丸み\":\"\",\"バックスキン\":\"確認バック\",\"バック塗り\":\"\",\"手前に表示\":\"\"}"]
 * 
 *
 * @param スキン登録
 * @parent ■登録1
 * @desc skinMaking スキンを登録する。スタイルから呼び出せる
 * @type struct<skin>[]
 * @default ["{\"スキン名\":\"■デザイン1\",\"画像\":\"\",\"位置X\":\"0\",\"位置Y\":\"0\",\"スケールX\":\"1\",\"スケールY\":\"1\",\"横幅+\":\"0\",\"高さ+\":\"0\",\"横幅\":\"\",\"高さ\":\"\",\"回転角\":\"0\",\"不透明度\":\"255\",\"カラー赤\":\"0\",\"カラー緑\":\"0\",\"カラー青\":\"0\",\"カラー灰\":\"0\"}","{\"スキン名\":\"d1-ベース\",\"画像\":\"\",\"位置X\":\"0\",\"位置Y\":\"0\",\"スケールX\":\"1\",\"スケールY\":\"1\",\"横幅+\":\"0\",\"高さ+\":\"0\",\"横幅\":\"\",\"高さ\":\"\",\"回転角\":\"0\",\"不透明度\":\"255\",\"カラー赤\":\"0\",\"カラー緑\":\"0\",\"カラー青\":\"0\",\"カラー灰\":\"0\"}","{\"スキン名\":\"d1-ステータスベース\",\"画像\":\"\",\"位置X\":\"0\",\"位置Y\":\"0\",\"スケールX\":\"1\",\"スケールY\":\"1\",\"横幅+\":\"0\",\"高さ+\":\"0\",\"横幅\":\"\",\"高さ\":\"\",\"回転角\":\"0\",\"不透明度\":\"255\",\"カラー赤\":\"0\",\"カラー緑\":\"0\",\"カラー青\":\"0\",\"カラー灰\":\"0\"}","{\"スキン名\":\"d1-バックステータス\",\"画像\":\"\",\"位置X\":\"0\",\"位置Y\":\"0\",\"スケールX\":\"1\",\"スケールY\":\"1\",\"横幅+\":\"0\",\"高さ+\":\"0\",\"横幅\":\"\",\"高さ\":\"\",\"回転角\":\"-2\",\"不透明度\":\"255\",\"カラー赤\":\"0\",\"カラー緑\":\"0\",\"カラー青\":\"0\",\"カラー灰\":\"0\"}","{\"スキン名\":\"d1-リスト\",\"画像\":\"\",\"位置X\":\"0\",\"位置Y\":\"0\",\"スケールX\":\"1\",\"スケールY\":\"1\",\"横幅+\":\"0\",\"高さ+\":\"0\",\"横幅\":\"\",\"高さ\":\"\",\"回転角\":\"0\",\"不透明度\":\"255\",\"カラー赤\":\"0\",\"カラー緑\":\"0\",\"カラー青\":\"0\",\"カラー灰\":\"0\"}","{\"スキン名\":\"d1-バックショップ\",\"画像\":\"\",\"位置X\":\"0\",\"位置Y\":\"0\",\"スケールX\":\"1\",\"スケールY\":\"1\",\"横幅+\":\"0\",\"高さ+\":\"0\",\"横幅\":\"\",\"高さ\":\"\",\"回転角\":\"-2\",\"不透明度\":\"192\",\"カラー赤\":\"0\",\"カラー緑\":\"0\",\"カラー青\":\"0\",\"カラー灰\":\"0\"}","{\"スキン名\":\"d1-スロット\",\"画像\":\"\",\"位置X\":\"0\",\"位置Y\":\"0\",\"スケールX\":\"1\",\"スケールY\":\"1\",\"横幅+\":\"0\",\"高さ+\":\"0\",\"横幅\":\"\",\"高さ\":\"\",\"回転角\":\"0\",\"不透明度\":\"255\",\"カラー赤\":\"0\",\"カラー緑\":\"0\",\"カラー青\":\"0\",\"カラー灰\":\"0\"}","{\"スキン名\":\"d1-ゴールド\",\"画像\":\"\",\"位置X\":\"0\",\"位置Y\":\"0\",\"スケールX\":\"1\",\"スケールY\":\"1\",\"横幅+\":\"0\",\"高さ+\":\"0\",\"横幅\":\"\",\"高さ\":\"\",\"回転角\":\"0\",\"不透明度\":\"255\",\"カラー赤\":\"0\",\"カラー緑\":\"0\",\"カラー青\":\"0\",\"カラー灰\":\"0\"}","{\"スキン名\":\"d1-ヘルプ\",\"画像\":\"\",\"位置X\":\"0\",\"位置Y\":\"0\",\"スケールX\":\"1.15\",\"スケールY\":\"1\",\"横幅+\":\"0\",\"高さ+\":\"0\",\"横幅\":\"\",\"高さ\":\"\",\"回転角\":\"0\",\"不透明度\":\"255\",\"カラー赤\":\"0\",\"カラー緑\":\"0\",\"カラー青\":\"0\",\"カラー灰\":\"0\"}","{\"スキン名\":\"■デザイン2\",\"画像\":\"\",\"位置X\":\"0\",\"位置Y\":\"0\",\"スケールX\":\"1\",\"スケールY\":\"1\",\"横幅+\":\"0\",\"高さ+\":\"0\",\"横幅\":\"\",\"高さ\":\"\",\"回転角\":\"0\",\"不透明度\":\"255\",\"カラー赤\":\"0\",\"カラー緑\":\"0\",\"カラー青\":\"0\",\"カラー灰\":\"0\"}","{\"スキン名\":\"d2-ベース\",\"画像\":\"\",\"位置X\":\"0\",\"位置Y\":\"0\",\"スケールX\":\"1\",\"スケールY\":\"1\",\"横幅+\":\"0\",\"高さ+\":\"0\",\"横幅\":\"\",\"高さ\":\"\",\"回転角\":\"0\",\"不透明度\":\"255\",\"カラー赤\":\"0\",\"カラー緑\":\"0\",\"カラー青\":\"0\",\"カラー灰\":\"0\"}","{\"スキン名\":\"d2-ステータスベース\",\"画像\":\"\",\"位置X\":\"0\",\"位置Y\":\"0\",\"スケールX\":\"1\",\"スケールY\":\"1\",\"横幅+\":\"0\",\"高さ+\":\"0\",\"横幅\":\"\",\"高さ\":\"\",\"回転角\":\"0\",\"不透明度\":\"255\",\"カラー赤\":\"0\",\"カラー緑\":\"0\",\"カラー青\":\"0\",\"カラー灰\":\"0\"}","{\"スキン名\":\"d2-バックステータス\",\"画像\":\"\",\"位置X\":\"0\",\"位置Y\":\"0\",\"スケールX\":\"1\",\"スケールY\":\"1\",\"横幅+\":\"0\",\"高さ+\":\"0\",\"横幅\":\"\",\"高さ\":\"\",\"回転角\":\"-2\",\"不透明度\":\"255\",\"カラー赤\":\"0\",\"カラー緑\":\"0\",\"カラー青\":\"0\",\"カラー灰\":\"0\"}","{\"スキン名\":\"d2-リスト\",\"画像\":\"\",\"位置X\":\"0\",\"位置Y\":\"0\",\"スケールX\":\"1\",\"スケールY\":\"1\",\"横幅+\":\"0\",\"高さ+\":\"0\",\"横幅\":\"\",\"高さ\":\"\",\"回転角\":\"0\",\"不透明度\":\"255\",\"カラー赤\":\"0\",\"カラー緑\":\"0\",\"カラー青\":\"0\",\"カラー灰\":\"0\"}","{\"スキン名\":\"d1-バックショップ\",\"画像\":\"\",\"位置X\":\"0\",\"位置Y\":\"0\",\"スケールX\":\"1\",\"スケールY\":\"1\",\"横幅+\":\"0\",\"高さ+\":\"0\",\"横幅\":\"\",\"高さ\":\"\",\"回転角\":\"-2\",\"不透明度\":\"192\",\"カラー赤\":\"0\",\"カラー緑\":\"0\",\"カラー青\":\"0\",\"カラー灰\":\"0\"}","{\"スキン名\":\"d2-スロット\",\"画像\":\"\",\"位置X\":\"0\",\"位置Y\":\"0\",\"スケールX\":\"1\",\"スケールY\":\"1\",\"横幅+\":\"0\",\"高さ+\":\"0\",\"横幅\":\"\",\"高さ\":\"\",\"回転角\":\"0\",\"不透明度\":\"255\",\"カラー赤\":\"0\",\"カラー緑\":\"0\",\"カラー青\":\"0\",\"カラー灰\":\"0\"}","{\"スキン名\":\"d2-ゴールド\",\"画像\":\"\",\"位置X\":\"0\",\"位置Y\":\"0\",\"スケールX\":\"1\",\"スケールY\":\"1\",\"横幅+\":\"0\",\"高さ+\":\"0\",\"横幅\":\"\",\"高さ\":\"\",\"回転角\":\"0\",\"不透明度\":\"255\",\"カラー赤\":\"0\",\"カラー緑\":\"0\",\"カラー青\":\"0\",\"カラー灰\":\"0\"}","{\"スキン名\":\"d2-ヘルプ\",\"画像\":\"\",\"位置X\":\"0\",\"位置Y\":\"0\",\"スケールX\":\"1.15\",\"スケールY\":\"1\",\"横幅+\":\"0\",\"高さ+\":\"0\",\"横幅\":\"\",\"高さ\":\"\",\"回転角\":\"0\",\"不透明度\":\"255\",\"カラー赤\":\"0\",\"カラー緑\":\"0\",\"カラー青\":\"0\",\"カラー灰\":\"0\"}","{\"スキン名\":\"■その他\",\"画像\":\"\",\"位置X\":\"0\",\"位置Y\":\"0\",\"スケールX\":\"1\",\"スケールY\":\"1\",\"横幅+\":\"0\",\"高さ+\":\"0\",\"横幅\":\"\",\"高さ\":\"\",\"回転角\":\"0\",\"不透明度\":\"255\",\"カラー赤\":\"0\",\"カラー緑\":\"0\",\"カラー青\":\"0\",\"カラー灰\":\"0\"}","{\"スキン名\":\"確認バック\",\"画像\":\"\",\"位置X\":\"0\",\"位置Y\":\"0\",\"スケールX\":\"1\",\"スケールY\":\"1\",\"横幅+\":\"0\",\"高さ+\":\"0\",\"横幅\":\"\",\"高さ\":\"\",\"回転角\":\"0\",\"不透明度\":\"255\",\"カラー赤\":\"0\",\"カラー緑\":\"0\",\"カラー青\":\"0\",\"カラー灰\":\"0\"}"]
 *
 * 
 * 
 * @param アニメーション登録
 * @parent ■登録1
 * @desc animationMaking アニメーションを登録する。スタイルから呼び出せる
 * @type struct<animation>[]
 * @default ["{\"アニメ名\":\"■出現\",\"アニメ時間\":\"0\",\"アニメ回数\":\"1\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"\",\"→スケールY\":\"\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\",\"透明化\":\"\"}","{\"アニメ名\":\"左から出る\",\"アニメ時間\":\"10\",\"アニメ回数\":\"1\",\"位置X\":\"-400\",\"位置Y\":\"\",\"→位置X\":\"0eo\",\"→位置Y\":\"\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"\",\"→スケールY\":\"\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"0\",\"→不透明度\":\"255\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\",\"透明化\":\"\"}","{\"アニメ名\":\"右から出る\",\"アニメ時間\":\"10\",\"アニメ回数\":\"1\",\"位置X\":\"400\",\"位置Y\":\"\",\"→位置X\":\"0eo\",\"→位置Y\":\"\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"\",\"→スケールY\":\"\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"0\",\"→不透明度\":\"255\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\",\"透明化\":\"\"}","{\"アニメ名\":\"上から出る\",\"アニメ時間\":\"10\",\"アニメ回数\":\"1\",\"位置X\":\"\",\"位置Y\":\"-300\",\"→位置X\":\"\",\"→位置Y\":\"0\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"\",\"→スケールY\":\"\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"0\",\"→不透明度\":\"255\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\",\"透明化\":\"\"}","{\"アニメ名\":\"下から出る\",\"アニメ時間\":\"10\",\"アニメ回数\":\"1\",\"位置X\":\"\",\"位置Y\":\"300\",\"→位置X\":\"\",\"→位置Y\":\"0\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"\",\"→スケールY\":\"\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"0\",\"→不透明度\":\"255\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\",\"透明化\":\"\"}","{\"アニメ名\":\"ダイナミックインL\",\"アニメ時間\":\"10~18\",\"アニメ回数\":\"1\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"-100tn\",\"→位置Y\":\"-75tn\",\"スケールX\":\"2.5\",\"スケールY\":\"2.5\",\"→スケールX\":\"1\",\"→スケールY\":\"1\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\",\"透明化\":\"\"}","{\"アニメ名\":\"ダイナミックインL-2\",\"アニメ時間\":\"10~18\",\"アニメ回数\":\"1\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"-100tn\",\"→位置Y\":\"0\",\"スケールX\":\"2.5\",\"スケールY\":\"2.5\",\"→スケールX\":\"1\",\"→スケールY\":\"1\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\",\"透明化\":\"\"}","{\"アニメ名\":\"ダイナミックインR\",\"アニメ時間\":\"10~18\",\"アニメ回数\":\"1\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"100tn\",\"→位置Y\":\"75tn\",\"スケールX\":\"2.5\",\"スケールY\":\"2.5\",\"→スケールX\":\"1\",\"→スケールY\":\"1\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\",\"透明化\":\"\"}","{\"アニメ名\":\"ダイナミックインR-2\",\"アニメ時間\":\"10~18\",\"アニメ回数\":\"1\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"100tn\",\"→位置Y\":\"0\",\"スケールX\":\"2.5\",\"スケールY\":\"2.5\",\"→スケールX\":\"1\",\"→スケールY\":\"1\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\",\"透明化\":\"\"}","{\"アニメ名\":\"ダイナミックインU\",\"アニメ時間\":\"10~18\",\"アニメ回数\":\"1\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"-50tn\",\"→位置Y\":\"-75tn\",\"スケールX\":\"2.5\",\"スケールY\":\"2.5\",\"→スケールX\":\"1\",\"→スケールY\":\"1\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\",\"透明化\":\"\"}","{\"アニメ名\":\"ダイナミックインD\",\"アニメ時間\":\"10~18\",\"アニメ回数\":\"1\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"-50tn\",\"→位置Y\":\"75tn\",\"スケールX\":\"2.5\",\"スケールY\":\"2.5\",\"→スケールX\":\"1\",\"→スケールY\":\"1\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\",\"透明化\":\"\"}","{\"アニメ名\":\"飛び出る\",\"アニメ時間\":\"13\",\"アニメ回数\":\"1\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"-30tn\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"0.95rd\",\"→スケールY\":\"1.1tn\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\",\"透明化\":\"\"}","{\"アニメ名\":\"飛び出る-大\",\"アニメ時間\":\"16\",\"アニメ回数\":\"1\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"-30tn\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"0.9rd\",\"→スケールY\":\"1.2tn\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\",\"透明化\":\"\"}","{\"アニメ名\":\"左から飛ぶ\",\"アニメ時間\":\"13\",\"アニメ回数\":\"1\",\"位置X\":\"-400\",\"位置Y\":\"\",\"→位置X\":\"0eo\",\"→位置Y\":\"-30tn\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"0.95rd\",\"→スケールY\":\"1.1tn\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"0\",\"→不透明度\":\"255\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\",\"透明化\":\"\"}","{\"アニメ名\":\"弾け出る\",\"アニメ時間\":\"13\",\"アニメ回数\":\"1\",\"位置X\":\"0\",\"位置Y\":\"-30tn\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"0\",\"スケールY\":\"\",\"→スケールX\":\"1fk(0.25)\",\"→スケールY\":\"1.5tn\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\",\"透明化\":\"\"}","{\"アニメ名\":\"■開く\",\"アニメ時間\":\"0\",\"アニメ回数\":\"1\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"\",\"→スケールY\":\"\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\",\"透明化\":\"\"}","{\"アニメ名\":\"縮小開く\",\"アニメ時間\":\"13\",\"アニメ回数\":\"1\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"2\",\"スケールY\":\"2\",\"→スケールX\":\"1\",\"→スケールY\":\"1\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\",\"透明化\":\"\"}","{\"アニメ名\":\"縮小開く-速\",\"アニメ時間\":\"8\",\"アニメ回数\":\"1\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"2\",\"スケールY\":\"2\",\"→スケールX\":\"1\",\"→スケールY\":\"1\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\",\"透明化\":\"\"}","{\"アニメ名\":\"拡大開く\",\"アニメ時間\":\"13\",\"アニメ回数\":\"1\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"0\",\"スケールY\":\"0\",\"→スケールX\":\"1\",\"→スケールY\":\"1\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\",\"透明化\":\"\"}","{\"アニメ名\":\"拡大開く-速\",\"アニメ時間\":\"8\",\"アニメ回数\":\"1\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"0\",\"スケールY\":\"0\",\"→スケールX\":\"1\",\"→スケールY\":\"1\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\",\"透明化\":\"\"}","{\"アニメ名\":\"回転開く\",\"アニメ時間\":\"13\",\"アニメ回数\":\"1\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"\",\"→スケールY\":\"\",\"回転角\":\"-90\",\"→回転角\":\"0\",\"不透明度\":\"0\",\"→不透明度\":\"255\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\",\"透明化\":\"\"}","{\"アニメ名\":\"回転開く-速\",\"アニメ時間\":\"8\",\"アニメ回数\":\"1\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"\",\"→スケールY\":\"\",\"回転角\":\"-90\",\"→回転角\":\"0\",\"不透明度\":\"0\",\"→不透明度\":\"255\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\",\"透明化\":\"\"}","{\"アニメ名\":\"横に開く\",\"アニメ時間\":\"13\",\"アニメ回数\":\"1\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"0\",\"スケールY\":\"\",\"→スケールX\":\"1\",\"→スケールY\":\"\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\",\"透明化\":\"\"}","{\"アニメ名\":\"縦に開く\",\"アニメ時間\":\"13\",\"アニメ回数\":\"1\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"\",\"スケールY\":\"0\",\"→スケールX\":\"\",\"→スケールY\":\"1\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\",\"透明化\":\"\"}","{\"アニメ名\":\"■閉じ\",\"アニメ時間\":\"0\",\"アニメ回数\":\"1\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"\",\"→スケールY\":\"\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\",\"透明化\":\"\"}","{\"アニメ名\":\"拡大閉じ\",\"アニメ時間\":\"10\",\"アニメ回数\":\"1\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"3\",\"→スケールY\":\"3\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"0ei\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\",\"透明化\":\"\"}","{\"アニメ名\":\"縮小閉じ\",\"アニメ時間\":\"10\",\"アニメ回数\":\"1\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"0\",\"→スケールY\":\"0\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\",\"透明化\":\"\"}","{\"アニメ名\":\"回転閉じ\",\"アニメ時間\":\"10\",\"アニメ回数\":\"1\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"\",\"→スケールY\":\"\",\"回転角\":\"\",\"→回転角\":\"90\",\"不透明度\":\"\",\"→不透明度\":\"0\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\",\"透明化\":\"\"}","{\"アニメ名\":\"横に閉じ\",\"アニメ時間\":\"10\",\"アニメ回数\":\"1\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"0\",\"→スケールY\":\"\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\",\"透明化\":\"\"}","{\"アニメ名\":\"縦に閉じ\",\"アニメ時間\":\"10\",\"アニメ回数\":\"1\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"\",\"→スケールY\":\"0\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\",\"透明化\":\"\"}","{\"アニメ名\":\"■表示中\",\"アニメ時間\":\"0\",\"アニメ回数\":\"1\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"\",\"→スケールY\":\"\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\",\"透明化\":\"\"}","{\"アニメ名\":\"呼吸\",\"アニメ時間\":\"120\",\"アニメ回数\":\"-1\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"1.004rd\",\"→スケールY\":\"\",\"回転角\":\"\",\"→回転角\":\"0.1rd\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\",\"透明化\":\"\"}","{\"アニメ名\":\"呼吸-中\",\"アニメ時間\":\"120\",\"アニメ回数\":\"-1\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"1.006rd\",\"→スケールY\":\"\",\"回転角\":\"\",\"→回転角\":\"0.15rd\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\",\"透明化\":\"\"}","{\"アニメ名\":\"呼吸-大\",\"アニメ時間\":\"120\",\"アニメ回数\":\"-1\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"1.008rd\",\"→スケールY\":\"\",\"回転角\":\"\",\"→回転角\":\"0.2rd\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\",\"透明化\":\"\"}","{\"アニメ名\":\"拡縮\",\"アニメ時間\":\"60\",\"アニメ回数\":\"-1\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"*1.015tn\",\"→スケールY\":\"*1.015tn\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"255\",\"→不透明度\":\"224tn\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\",\"透明化\":\"\"}","{\"アニメ名\":\"光る\",\"アニメ時間\":\"40\",\"アニメ回数\":\"-1\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"\",\"→スケールY\":\"\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"40tn\",\"→カラー緑\":\"40tn\",\"→カラー青\":\"40tn\",\"→カラー灰\":\"\",\"透明化\":\"\"}","{\"アニメ名\":\"■カーソル\",\"アニメ時間\":\"0\",\"アニメ回数\":\"1\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"\",\"→スケールY\":\"\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\",\"透明化\":\"\"}","{\"アニメ名\":\"セレクト\",\"アニメ時間\":\"24\",\"アニメ回数\":\"1\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"*1.03tn\",\"→スケールY\":\"*1.03tn\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"160\",\"カラー青\":\"160\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"255tn\",\"→カラー青\":\"255tn\",\"→カラー灰\":\"\",\"透明化\":\"\"}","{\"アニメ名\":\"セレクト中\",\"アニメ時間\":\"36\",\"アニメ回数\":\"-1\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"*1.025tn\",\"→スケールY\":\"*1.025tn\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"160\",\"カラー緑\":\"160\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"255tn\",\"→カラー青\":\"255tn\",\"→カラー灰\":\"\",\"透明化\":\"\"}","{\"アニメ名\":\"■ディレイ\",\"アニメ時間\":\"0\",\"アニメ回数\":\"1\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"\",\"→スケールY\":\"\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\",\"透明化\":\"\"}","{\"アニメ名\":\"ディレイ\",\"アニメ時間\":\"5\",\"アニメ回数\":\"1\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"\",\"→スケールY\":\"\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\",\"透明化\":\"true\"}","{\"アニメ名\":\"ディレイ2\",\"アニメ時間\":\"10\",\"アニメ回数\":\"1\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"\",\"→スケールY\":\"\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\",\"透明化\":\"true\"}"]
 * 
 * 
 * 
 * @param フォント登録
 * @parent ■登録1
 * @desc fontMaking フォント設定を登録する。スタイルから呼び出せる
 * @type struct<font>[]
 * @default ["{\"フォント名\":\"メイン\",\"フォント\":\"\",\"文字サイズ\":\"\",\"文字色\":\"\",\"縁取り幅\":\"6\",\"縁取り色\":\"0, 0, 0, 1\"}","{\"フォント名\":\"数字\",\"フォント\":\"\",\"文字サイズ\":\"\",\"文字色\":\"\",\"縁取り幅\":\"5\",\"縁取り色\":\"0, 0, 0, 1\"}","{\"フォント名\":\"セリフ\",\"フォント\":\"\",\"文字サイズ\":\"\",\"文字色\":\"\",\"縁取り幅\":\"7\",\"縁取り色\":\"0, 0, 0, 1\"}","{\"フォント名\":\"看板\",\"フォント\":\"\",\"文字サイズ\":\"+10\",\"文字色\":\"\",\"縁取り幅\":\"8\",\"縁取り色\":\"0, 0, 0, 1\"}","{\"フォント名\":\"名前\",\"フォント\":\"\",\"文字サイズ\":\"-5\",\"文字色\":\"\",\"縁取り幅\":\"6\",\"縁取り色\":\"0, 0, 0, 1\"}"]
 * 
 * 
 * 
 * @param ■登録2
 * 
 * @param 背景登録
 * @parent ■登録2
 * @desc backMaking 背景を登録する。スタイルかプラグインコマンドから呼び出せる
 * @type struct<back>[]
 * @default ["{\"背景名\":\"d1-背景\",\"画像\":\"\",\"不透明度\":\"255\",\"カラー赤\":\"0\",\"カラー緑\":\"0\",\"カラー青\":\"0\",\"カラー灰\":\"0\",\"移動X\":\"0.25\",\"移動Y\":\"0\"}","{\"背景名\":\"d2-背景\",\"画像\":\"\",\"不透明度\":\"255\",\"カラー赤\":\"0\",\"カラー緑\":\"0\",\"カラー青\":\"0\",\"カラー灰\":\"0\",\"移動X\":\"0.25\",\"移動Y\":\"0\"}","{\"背景名\":\"ショップ1\",\"画像\":\"\",\"不透明度\":\"255\",\"カラー赤\":\"0\",\"カラー緑\":\"0\",\"カラー青\":\"0\",\"カラー灰\":\"0\",\"移動X\":\"0.25\",\"移動Y\":\"0\"}","{\"背景名\":\"ショップ2\",\"画像\":\"\",\"不透明度\":\"255\",\"カラー赤\":\"0\",\"カラー緑\":\"0\",\"カラー青\":\"0\",\"カラー灰\":\"0\",\"移動X\":\"0.25\",\"移動Y\":\"0\"}","{\"背景名\":\"名前入力\",\"画像\":\"\",\"不透明度\":\"255\",\"カラー赤\":\"0\",\"カラー緑\":\"0\",\"カラー青\":\"0\",\"カラー灰\":\"0\",\"移動X\":\"0.25\",\"移動Y\":\"0\"}"]
 * 
 * 
 * 
 * @param ピクチャパック登録
 * @parent ■登録2
 * @desc picturePackMaking ピクチャパックを登録する。スタイルかプラグインコマンドから呼び出せる
 * @type struct<pictPack>[]
 * @default ["{\"パック名\":\"d1-ピクチャ\",\"ピクチャリスト\":\"[\\\"{\\\\\\\"ピクチャ名\\\\\\\":\\\\\\\"フレーム\\\\\\\",\\\\\\\"使用ピクチャ\\\\\\\":\\\\\\\"d1-フレーム\\\\\\\",\\\\\\\"レイヤー\\\\\\\":\\\\\\\"下層\\\\\\\",\\\\\\\"原点X\\\\\\\":\\\\\\\"0.5\\\\\\\",\\\\\\\"原点Y\\\\\\\":\\\\\\\"0.5\\\\\\\",\\\\\\\"位置X\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"位置Y\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"位置寄せX\\\\\\\":\\\\\\\"中央寄せ\\\\\\\",\\\\\\\"位置寄せY\\\\\\\":\\\\\\\"中央寄せ\\\\\\\",\\\\\\\"横幅\\\\\\\":\\\\\\\"gw\\\\\\\",\\\\\\\"高さ\\\\\\\":\\\\\\\"gh\\\\\\\",\\\\\\\"連動ウインドウ\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"有効シーン\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"表示条件\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"開始アニメ\\\\\\\":\\\\\\\"縮小開く-速\\\\\\\",\\\\\\\"…再アニメ\\\\\\\":\\\\\\\"true\\\\\\\",\\\\\\\"表示中アニメ\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ピクチャテキスト\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"…フォント\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"無効\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"ピクチャ名\\\\\\\":\\\\\\\"ぬこさん\\\\\\\",\\\\\\\"使用ピクチャ\\\\\\\":\\\\\\\"ぬこさん\\\\\\\",\\\\\\\"レイヤー\\\\\\\":\\\\\\\"下層\\\\\\\",\\\\\\\"原点X\\\\\\\":\\\\\\\"0.5\\\\\\\",\\\\\\\"原点Y\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"位置X\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"位置Y\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"位置寄せX\\\\\\\":\\\\\\\"左寄せ\\\\\\\",\\\\\\\"位置寄せY\\\\\\\":\\\\\\\"下寄せ\\\\\\\",\\\\\\\"横幅\\\\\\\":\\\\\\\"230\\\\\\\",\\\\\\\"高さ\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"連動ウインドウ\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"有効シーン\\\\\\\":\\\\\\\"Menu, Message, Options, GameEnd, CustomMenu\\\\\\\",\\\\\\\"表示条件\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"開始アニメ\\\\\\\":\\\\\\\"ディレイ,　飛び出る-大\\\\\\\",\\\\\\\"…再アニメ\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"表示中アニメ\\\\\\\":\\\\\\\"呼吸-大\\\\\\\",\\\\\\\"ピクチャテキスト\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"…フォント\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"無効\\\\\\\":\\\\\\\"\\\\\\\"}\\\"]\"}","{\"パック名\":\"d2-ピクチャ\",\"ピクチャリスト\":\"[\\\"{\\\\\\\"ピクチャ名\\\\\\\":\\\\\\\"フレーム\\\\\\\",\\\\\\\"使用ピクチャ\\\\\\\":\\\\\\\"d2-フレーム\\\\\\\",\\\\\\\"レイヤー\\\\\\\":\\\\\\\"下層\\\\\\\",\\\\\\\"原点X\\\\\\\":\\\\\\\"0.5\\\\\\\",\\\\\\\"原点Y\\\\\\\":\\\\\\\"0.5\\\\\\\",\\\\\\\"位置X\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"位置Y\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"位置寄せX\\\\\\\":\\\\\\\"中央寄せ\\\\\\\",\\\\\\\"位置寄せY\\\\\\\":\\\\\\\"中央寄せ\\\\\\\",\\\\\\\"横幅\\\\\\\":\\\\\\\"gw\\\\\\\",\\\\\\\"高さ\\\\\\\":\\\\\\\"gh\\\\\\\",\\\\\\\"連動ウインドウ\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"有効シーン\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"表示条件\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"開始アニメ\\\\\\\":\\\\\\\"縮小開く-速\\\\\\\",\\\\\\\"…再アニメ\\\\\\\":\\\\\\\"true\\\\\\\",\\\\\\\"表示中アニメ\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ピクチャテキスト\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"…フォント\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"無効\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"ピクチャ名\\\\\\\":\\\\\\\"きつね\\\\\\\",\\\\\\\"使用ピクチャ\\\\\\\":\\\\\\\"きつね\\\\\\\",\\\\\\\"レイヤー\\\\\\\":\\\\\\\"下層\\\\\\\",\\\\\\\"原点X\\\\\\\":\\\\\\\"0.5\\\\\\\",\\\\\\\"原点Y\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"位置X\\\\\\\":\\\\\\\"15\\\\\\\",\\\\\\\"位置Y\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"位置寄せX\\\\\\\":\\\\\\\"左寄せ\\\\\\\",\\\\\\\"位置寄せY\\\\\\\":\\\\\\\"下寄せ\\\\\\\",\\\\\\\"横幅\\\\\\\":\\\\\\\"230\\\\\\\",\\\\\\\"高さ\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"連動ウインドウ\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"有効シーン\\\\\\\":\\\\\\\"Menu, Message, Options, GameEnd, CustomMenu\\\\\\\",\\\\\\\"表示条件\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"開始アニメ\\\\\\\":\\\\\\\"ディレイ, 左から飛ぶ\\\\\\\",\\\\\\\"…再アニメ\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"表示中アニメ\\\\\\\":\\\\\\\"呼吸-大\\\\\\\",\\\\\\\"ピクチャテキスト\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"…フォント\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"無効\\\\\\\":\\\\\\\"\\\\\\\"}\\\"]\"}","{\"パック名\":\"ショップ1\",\"ピクチャリスト\":\"[\\\"{\\\\\\\"ピクチャ名\\\\\\\":\\\\\\\"フレーム\\\\\\\",\\\\\\\"使用ピクチャ\\\\\\\":\\\\\\\"フレーム1\\\\\\\",\\\\\\\"レイヤー\\\\\\\":\\\\\\\"下層\\\\\\\",\\\\\\\"原点X\\\\\\\":\\\\\\\"0.5\\\\\\\",\\\\\\\"原点Y\\\\\\\":\\\\\\\"0.5\\\\\\\",\\\\\\\"位置X\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"位置Y\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"位置寄せX\\\\\\\":\\\\\\\"中央寄せ\\\\\\\",\\\\\\\"位置寄せY\\\\\\\":\\\\\\\"中央寄せ\\\\\\\",\\\\\\\"横幅\\\\\\\":\\\\\\\"gw\\\\\\\",\\\\\\\"高さ\\\\\\\":\\\\\\\"gh\\\\\\\",\\\\\\\"連動ウインドウ\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"有効シーン\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"表示条件\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"開始アニメ\\\\\\\":\\\\\\\"縮小開く\\\\\\\",\\\\\\\"…再アニメ\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"表示中アニメ\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ピクチャテキスト\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"…フォント\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"無効\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"ピクチャ名\\\\\\\":\\\\\\\"店主\\\\\\\",\\\\\\\"使用ピクチャ\\\\\\\":\\\\\\\"ズキンちゃん\\\\\\\",\\\\\\\"レイヤー\\\\\\\":\\\\\\\"下層\\\\\\\",\\\\\\\"原点X\\\\\\\":\\\\\\\"0.5\\\\\\\",\\\\\\\"原点Y\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"位置X\\\\\\\":\\\\\\\"-50\\\\\\\",\\\\\\\"位置Y\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"位置寄せX\\\\\\\":\\\\\\\"左寄せ\\\\\\\",\\\\\\\"位置寄せY\\\\\\\":\\\\\\\"下寄せ\\\\\\\",\\\\\\\"横幅\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"高さ\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"連動ウインドウ\\\\\\\":\\\\\\\"ShopCommand\\\\\\\",\\\\\\\"有効シーン\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"表示条件\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"開始アニメ\\\\\\\":\\\\\\\"ディレイ, 左から出る\\\\\\\",\\\\\\\"…再アニメ\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"表示中アニメ\\\\\\\":\\\\\\\"呼吸\\\\\\\",\\\\\\\"ピクチャテキスト\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"…フォント\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"無効\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"ピクチャ名\\\\\\\":\\\\\\\"セリフ\\\\\\\",\\\\\\\"使用ピクチャ\\\\\\\":\\\\\\\"セリフ\\\\\\\",\\\\\\\"レイヤー\\\\\\\":\\\\\\\"下層\\\\\\\",\\\\\\\"原点X\\\\\\\":\\\\\\\"0.5\\\\\\\",\\\\\\\"原点Y\\\\\\\":\\\\\\\"0.5\\\\\\\",\\\\\\\"位置X\\\\\\\":\\\\\\\"290\\\\\\\",\\\\\\\"位置Y\\\\\\\":\\\\\\\"-180\\\\\\\",\\\\\\\"位置寄せX\\\\\\\":\\\\\\\"左寄せ\\\\\\\",\\\\\\\"位置寄せY\\\\\\\":\\\\\\\"下寄せ\\\\\\\",\\\\\\\"横幅\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"高さ\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"連動ウインドウ\\\\\\\":\\\\\\\"ShopCommand\\\\\\\",\\\\\\\"有効シーン\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"表示条件\\\\\\\":\\\\\\\"{\\\\\\\\\\\\\\\"ショップ購入前\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"true\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ショップ購入後\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ショップ売却前\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ショップ売却後\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\",\\\\\\\"開始アニメ\\\\\\\":\\\\\\\"ディレイ, 弾け出る\\\\\\\",\\\\\\\"…再アニメ\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"表示中アニメ\\\\\\\":\\\\\\\"拡縮\\\\\\\",\\\\\\\"ピクチャテキスト\\\\\\\":\\\\\\\"クスリのチカラで\\\\\\\\nアナタも最強になれる！！\\\\\\\",\\\\\\\"…フォント\\\\\\\":\\\\\\\"セリフ\\\\\\\",\\\\\\\"無効\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"ピクチャ名\\\\\\\":\\\\\\\"セリフ-購入後\\\\\\\",\\\\\\\"使用ピクチャ\\\\\\\":\\\\\\\"セリフ\\\\\\\",\\\\\\\"レイヤー\\\\\\\":\\\\\\\"下層\\\\\\\",\\\\\\\"原点X\\\\\\\":\\\\\\\"0.5\\\\\\\",\\\\\\\"原点Y\\\\\\\":\\\\\\\"0.5\\\\\\\",\\\\\\\"位置X\\\\\\\":\\\\\\\"290\\\\\\\",\\\\\\\"位置Y\\\\\\\":\\\\\\\"-180\\\\\\\",\\\\\\\"位置寄せX\\\\\\\":\\\\\\\"左寄せ\\\\\\\",\\\\\\\"位置寄せY\\\\\\\":\\\\\\\"下寄せ\\\\\\\",\\\\\\\"横幅\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"高さ\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"連動ウインドウ\\\\\\\":\\\\\\\"ShopCommand\\\\\\\",\\\\\\\"有効シーン\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"表示条件\\\\\\\":\\\\\\\"{\\\\\\\\\\\\\\\"ショップ購入前\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ショップ購入後\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"true\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ショップ売却前\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ショップ売却後\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\",\\\\\\\"開始アニメ\\\\\\\":\\\\\\\"ディレイ, 弾け出る\\\\\\\",\\\\\\\"…再アニメ\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"表示中アニメ\\\\\\\":\\\\\\\"拡縮\\\\\\\",\\\\\\\"ピクチャテキスト\\\\\\\":\\\\\\\"修行なんてくだらない\\\\\\\\nクスリこそ最強への道なのよ！\\\\\\\",\\\\\\\"…フォント\\\\\\\":\\\\\\\"セリフ\\\\\\\",\\\\\\\"無効\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"ピクチャ名\\\\\\\":\\\\\\\"看板\\\\\\\",\\\\\\\"使用ピクチャ\\\\\\\":\\\\\\\"看板\\\\\\\",\\\\\\\"レイヤー\\\\\\\":\\\\\\\"下層\\\\\\\",\\\\\\\"原点X\\\\\\\":\\\\\\\"0.5\\\\\\\",\\\\\\\"原点Y\\\\\\\":\\\\\\\"0.5\\\\\\\",\\\\\\\"位置X\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"位置Y\\\\\\\":\\\\\\\"-120\\\\\\\",\\\\\\\"位置寄せX\\\\\\\":\\\\\\\"右寄せ\\\\\\\",\\\\\\\"位置寄せY\\\\\\\":\\\\\\\"中央寄せ\\\\\\\",\\\\\\\"横幅\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"高さ\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"連動ウインドウ\\\\\\\":\\\\\\\"ShopCommand\\\\\\\",\\\\\\\"有効シーン\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"表示条件\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"開始アニメ\\\\\\\":\\\\\\\"ディレイ, 右から出る\\\\\\\",\\\\\\\"…再アニメ\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"表示中アニメ\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ピクチャテキスト\\\\\\\":\\\\\\\"ドーピング屋\\\\\\\",\\\\\\\"…フォント\\\\\\\":\\\\\\\"看板\\\\\\\",\\\\\\\"無効\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"ピクチャ名\\\\\\\":\\\\\\\"名前\\\\\\\",\\\\\\\"使用ピクチャ\\\\\\\":\\\\\\\"名前\\\\\\\",\\\\\\\"レイヤー\\\\\\\":\\\\\\\"下層\\\\\\\",\\\\\\\"原点X\\\\\\\":\\\\\\\"0.5\\\\\\\",\\\\\\\"原点Y\\\\\\\":\\\\\\\"0.5\\\\\\\",\\\\\\\"位置X\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"位置Y\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"位置寄せX\\\\\\\":\\\\\\\"左寄せ\\\\\\\",\\\\\\\"位置寄せY\\\\\\\":\\\\\\\"下寄せ\\\\\\\",\\\\\\\"横幅\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"高さ\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"連動ウインドウ\\\\\\\":\\\\\\\"ShopCommand\\\\\\\",\\\\\\\"有効シーン\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"表示条件\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"開始アニメ\\\\\\\":\\\\\\\"ディレイ, 左から出る\\\\\\\",\\\\\\\"…再アニメ\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"表示中アニメ\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ピクチャテキスト\\\\\\\":\\\\\\\"ズキンちゃん\\\\\\\",\\\\\\\"…フォント\\\\\\\":\\\\\\\"名前\\\\\\\",\\\\\\\"無効\\\\\\\":\\\\\\\"\\\\\\\"}\\\"]\"}","{\"パック名\":\"ショップ2\",\"ピクチャリスト\":\"[\\\"{\\\\\\\"ピクチャ名\\\\\\\":\\\\\\\"フレーム\\\\\\\",\\\\\\\"使用ピクチャ\\\\\\\":\\\\\\\"フレーム1\\\\\\\",\\\\\\\"レイヤー\\\\\\\":\\\\\\\"下層\\\\\\\",\\\\\\\"原点X\\\\\\\":\\\\\\\"0.5\\\\\\\",\\\\\\\"原点Y\\\\\\\":\\\\\\\"0.5\\\\\\\",\\\\\\\"位置X\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"位置Y\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"位置寄せX\\\\\\\":\\\\\\\"中央寄せ\\\\\\\",\\\\\\\"位置寄せY\\\\\\\":\\\\\\\"中央寄せ\\\\\\\",\\\\\\\"横幅\\\\\\\":\\\\\\\"gw\\\\\\\",\\\\\\\"高さ\\\\\\\":\\\\\\\"gh\\\\\\\",\\\\\\\"連動ウインドウ\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"有効シーン\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"表示条件\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"開始アニメ\\\\\\\":\\\\\\\"縮小開く\\\\\\\",\\\\\\\"…再アニメ\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"表示中アニメ\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ピクチャテキスト\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"…フォント\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"無効\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"ピクチャ名\\\\\\\":\\\\\\\"店主\\\\\\\",\\\\\\\"使用ピクチャ\\\\\\\":\\\\\\\"大魔王\\\\\\\",\\\\\\\"レイヤー\\\\\\\":\\\\\\\"下層\\\\\\\",\\\\\\\"原点X\\\\\\\":\\\\\\\"0.5\\\\\\\",\\\\\\\"原点Y\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"位置X\\\\\\\":\\\\\\\"-50\\\\\\\",\\\\\\\"位置Y\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"位置寄せX\\\\\\\":\\\\\\\"左寄せ\\\\\\\",\\\\\\\"位置寄せY\\\\\\\":\\\\\\\"下寄せ\\\\\\\",\\\\\\\"横幅\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"高さ\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"連動ウインドウ\\\\\\\":\\\\\\\"ShopCommand\\\\\\\",\\\\\\\"有効シーン\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"表示条件\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"開始アニメ\\\\\\\":\\\\\\\"ディレイ, 左から出る\\\\\\\",\\\\\\\"…再アニメ\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"表示中アニメ\\\\\\\":\\\\\\\"呼吸\\\\\\\",\\\\\\\"ピクチャテキスト\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"…フォント\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"無効\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"ピクチャ名\\\\\\\":\\\\\\\"セリフ\\\\\\\",\\\\\\\"使用ピクチャ\\\\\\\":\\\\\\\"セリフ\\\\\\\",\\\\\\\"レイヤー\\\\\\\":\\\\\\\"下層\\\\\\\",\\\\\\\"原点X\\\\\\\":\\\\\\\"0.5\\\\\\\",\\\\\\\"原点Y\\\\\\\":\\\\\\\"0.5\\\\\\\",\\\\\\\"位置X\\\\\\\":\\\\\\\"290\\\\\\\",\\\\\\\"位置Y\\\\\\\":\\\\\\\"-180\\\\\\\",\\\\\\\"位置寄せX\\\\\\\":\\\\\\\"左寄せ\\\\\\\",\\\\\\\"位置寄せY\\\\\\\":\\\\\\\"下寄せ\\\\\\\",\\\\\\\"横幅\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"高さ\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"連動ウインドウ\\\\\\\":\\\\\\\"ShopCommand\\\\\\\",\\\\\\\"有効シーン\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"表示条件\\\\\\\":\\\\\\\"{\\\\\\\\\\\\\\\"ショップ購入前\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"true\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ショップ購入後\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ショップ売却前\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ショップ売却後\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\",\\\\\\\"開始アニメ\\\\\\\":\\\\\\\"ディレイ, 弾け出る\\\\\\\",\\\\\\\"…再アニメ\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"表示中アニメ\\\\\\\":\\\\\\\"拡縮\\\\\\\",\\\\\\\"ピクチャテキスト\\\\\\\":\\\\\\\"最強への道とは、一に修行！\\\\\\\\n二に修行を支える良質な武器なのだ！\\\\\\\",\\\\\\\"…フォント\\\\\\\":\\\\\\\"セリフ\\\\\\\",\\\\\\\"無効\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"ピクチャ名\\\\\\\":\\\\\\\"セリフ-購入後\\\\\\\",\\\\\\\"使用ピクチャ\\\\\\\":\\\\\\\"セリフ\\\\\\\",\\\\\\\"レイヤー\\\\\\\":\\\\\\\"下層\\\\\\\",\\\\\\\"原点X\\\\\\\":\\\\\\\"0.5\\\\\\\",\\\\\\\"原点Y\\\\\\\":\\\\\\\"0.5\\\\\\\",\\\\\\\"位置X\\\\\\\":\\\\\\\"290\\\\\\\",\\\\\\\"位置Y\\\\\\\":\\\\\\\"-180\\\\\\\",\\\\\\\"位置寄せX\\\\\\\":\\\\\\\"左寄せ\\\\\\\",\\\\\\\"位置寄せY\\\\\\\":\\\\\\\"下寄せ\\\\\\\",\\\\\\\"横幅\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"高さ\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"連動ウインドウ\\\\\\\":\\\\\\\"ShopCommand\\\\\\\",\\\\\\\"有効シーン\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"表示条件\\\\\\\":\\\\\\\"{\\\\\\\\\\\\\\\"ショップ購入前\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ショップ購入後\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"true\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ショップ売却前\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\",\\\\\\\\\\\\\\\"ショップ売却後\\\\\\\\\\\\\\\":\\\\\\\\\\\\\\\"\\\\\\\\\\\\\\\"}\\\\\\\",\\\\\\\"開始アニメ\\\\\\\":\\\\\\\"ディレイ, 弾け出る\\\\\\\",\\\\\\\"…再アニメ\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"表示中アニメ\\\\\\\":\\\\\\\"拡縮\\\\\\\",\\\\\\\"ピクチャテキスト\\\\\\\":\\\\\\\"大切なのは地道な鍛錬\\\\\\\\nクスリになど頼るでないぞ！！\\\\\\\",\\\\\\\"…フォント\\\\\\\":\\\\\\\"セリフ\\\\\\\",\\\\\\\"無効\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"ピクチャ名\\\\\\\":\\\\\\\"看板\\\\\\\",\\\\\\\"使用ピクチャ\\\\\\\":\\\\\\\"看板\\\\\\\",\\\\\\\"レイヤー\\\\\\\":\\\\\\\"下層\\\\\\\",\\\\\\\"原点X\\\\\\\":\\\\\\\"0.5\\\\\\\",\\\\\\\"原点Y\\\\\\\":\\\\\\\"0.5\\\\\\\",\\\\\\\"位置X\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"位置Y\\\\\\\":\\\\\\\"-120\\\\\\\",\\\\\\\"位置寄せX\\\\\\\":\\\\\\\"右寄せ\\\\\\\",\\\\\\\"位置寄せY\\\\\\\":\\\\\\\"中央寄せ\\\\\\\",\\\\\\\"横幅\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"高さ\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"連動ウインドウ\\\\\\\":\\\\\\\"ShopCommand\\\\\\\",\\\\\\\"有効シーン\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"表示条件\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"開始アニメ\\\\\\\":\\\\\\\"ディレイ, 右から出る\\\\\\\",\\\\\\\"…再アニメ\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"表示中アニメ\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ピクチャテキスト\\\\\\\":\\\\\\\"大魔王の鍛冶屋\\\\\\\",\\\\\\\"…フォント\\\\\\\":\\\\\\\"看板\\\\\\\",\\\\\\\"無効\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"ピクチャ名\\\\\\\":\\\\\\\"名前\\\\\\\",\\\\\\\"使用ピクチャ\\\\\\\":\\\\\\\"名前\\\\\\\",\\\\\\\"レイヤー\\\\\\\":\\\\\\\"下層\\\\\\\",\\\\\\\"原点X\\\\\\\":\\\\\\\"0.5\\\\\\\",\\\\\\\"原点Y\\\\\\\":\\\\\\\"0.5\\\\\\\",\\\\\\\"位置X\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"位置Y\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"位置寄せX\\\\\\\":\\\\\\\"左寄せ\\\\\\\",\\\\\\\"位置寄せY\\\\\\\":\\\\\\\"下寄せ\\\\\\\",\\\\\\\"横幅\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"高さ\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"連動ウインドウ\\\\\\\":\\\\\\\"ShopCommand\\\\\\\",\\\\\\\"有効シーン\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"表示条件\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"開始アニメ\\\\\\\":\\\\\\\"ディレイ, 左から出る\\\\\\\",\\\\\\\"…再アニメ\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"表示中アニメ\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ピクチャテキスト\\\\\\\":\\\\\\\"大魔王ヤラレヤーク\\\\\\\",\\\\\\\"…フォント\\\\\\\":\\\\\\\"名前\\\\\\\",\\\\\\\"無効\\\\\\\":\\\\\\\"\\\\\\\"}\\\"]\"}","{\"パック名\":\"名前入力\",\"ピクチャリスト\":\"[\\\"{\\\\\\\"ピクチャ名\\\\\\\":\\\\\\\"フレーム\\\\\\\",\\\\\\\"使用ピクチャ\\\\\\\":\\\\\\\"フレーム2\\\\\\\",\\\\\\\"レイヤー\\\\\\\":\\\\\\\"下層\\\\\\\",\\\\\\\"原点X\\\\\\\":\\\\\\\"0.5\\\\\\\",\\\\\\\"原点Y\\\\\\\":\\\\\\\"0.5\\\\\\\",\\\\\\\"位置X\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"位置Y\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"位置寄せX\\\\\\\":\\\\\\\"中央寄せ\\\\\\\",\\\\\\\"位置寄せY\\\\\\\":\\\\\\\"中央寄せ\\\\\\\",\\\\\\\"横幅\\\\\\\":\\\\\\\"gw\\\\\\\",\\\\\\\"高さ\\\\\\\":\\\\\\\"gh\\\\\\\",\\\\\\\"連動ウインドウ\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"有効シーン\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"表示条件\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"開始アニメ\\\\\\\":\\\\\\\"縮小開く\\\\\\\",\\\\\\\"…再アニメ\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"表示中アニメ\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ピクチャテキスト\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"…フォント\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"無効\\\\\\\":\\\\\\\"\\\\\\\"}\\\"]\"}"]
 * 
 * 
 * 
 * @param ピクチャ登録
 * @parent ■登録2
 * @desc pictureMaking ピクチャを登録する。ピクチャパックから呼び出せる
 * @type struct<pict>[]
 * @default ["{\"ピクチャ名\":\"d1-フレーム\",\"画像\":\"\",\"位置X\":\"0\",\"位置Y\":\"0\",\"スケールX\":\"1\",\"スケールY\":\"1\",\"横幅+\":\"0\",\"高さ+\":\"0\",\"横幅\":\"\",\"高さ\":\"\",\"回転角\":\"0\",\"不透明度\":\"255\",\"カラー赤\":\"0\",\"カラー緑\":\"0\",\"カラー青\":\"0\",\"カラー灰\":\"0\"}","{\"ピクチャ名\":\"d2-フレーム\",\"画像\":\"\",\"位置X\":\"0\",\"位置Y\":\"0\",\"スケールX\":\"1\",\"スケールY\":\"1\",\"横幅+\":\"0\",\"高さ+\":\"0\",\"横幅\":\"\",\"高さ\":\"\",\"回転角\":\"0\",\"不透明度\":\"255\",\"カラー赤\":\"0\",\"カラー緑\":\"0\",\"カラー青\":\"0\",\"カラー灰\":\"0\"}","{\"ピクチャ名\":\"フレーム1\",\"画像\":\"\",\"位置X\":\"0\",\"位置Y\":\"0\",\"スケールX\":\"1\",\"スケールY\":\"1\",\"横幅+\":\"0\",\"高さ+\":\"0\",\"横幅\":\"\",\"高さ\":\"\",\"回転角\":\"0\",\"不透明度\":\"255\",\"カラー赤\":\"0\",\"カラー緑\":\"0\",\"カラー青\":\"0\",\"カラー灰\":\"0\"}","{\"ピクチャ名\":\"フレーム2\",\"画像\":\"\",\"位置X\":\"0\",\"位置Y\":\"0\",\"スケールX\":\"1\",\"スケールY\":\"1\",\"横幅+\":\"0\",\"高さ+\":\"0\",\"横幅\":\"\",\"高さ\":\"\",\"回転角\":\"0\",\"不透明度\":\"255\",\"カラー赤\":\"0\",\"カラー緑\":\"0\",\"カラー青\":\"0\",\"カラー灰\":\"0\"}","{\"ピクチャ名\":\"セリフ\",\"画像\":\"\",\"位置X\":\"-12\",\"位置Y\":\"-3\",\"スケールX\":\"1\",\"スケールY\":\"1\",\"横幅+\":\"70\",\"高さ+\":\"30\",\"横幅\":\"\",\"高さ\":\"\",\"回転角\":\"0\",\"不透明度\":\"255\",\"カラー赤\":\"0\",\"カラー緑\":\"0\",\"カラー青\":\"0\",\"カラー灰\":\"0\"}","{\"ピクチャ名\":\"看板\",\"画像\":\"\",\"位置X\":\"0\",\"位置Y\":\"-5\",\"スケールX\":\"1.25\",\"スケールY\":\"1.25\",\"横幅+\":\"0\",\"高さ+\":\"0\",\"横幅\":\"\",\"高さ\":\"\",\"回転角\":\"0\",\"不透明度\":\"255\",\"カラー赤\":\"0\",\"カラー緑\":\"0\",\"カラー青\":\"0\",\"カラー灰\":\"0\"}","{\"ピクチャ名\":\"名前\",\"画像\":\"\",\"位置X\":\"0\",\"位置Y\":\"-3\",\"スケールX\":\"1\",\"スケールY\":\"1\",\"横幅+\":\"0\",\"高さ+\":\"0\",\"横幅\":\"\",\"高さ\":\"\",\"回転角\":\"0\",\"不透明度\":\"255\",\"カラー赤\":\"0\",\"カラー緑\":\"0\",\"カラー青\":\"0\",\"カラー灰\":\"0\"}","{\"ピクチャ名\":\"ぬこさん\",\"画像\":\"\",\"位置X\":\"0\",\"位置Y\":\"0\",\"スケールX\":\"-1\",\"スケールY\":\"1\",\"横幅+\":\"0\",\"高さ+\":\"0\",\"横幅\":\"\",\"高さ\":\"\",\"回転角\":\"0\",\"不透明度\":\"255\",\"カラー赤\":\"0\",\"カラー緑\":\"0\",\"カラー青\":\"0\",\"カラー灰\":\"0\"}","{\"ピクチャ名\":\"きつね\",\"画像\":\"\",\"位置X\":\"0\",\"位置Y\":\"0\",\"スケールX\":\"-1\",\"スケールY\":\"1\",\"横幅+\":\"0\",\"高さ+\":\"0\",\"横幅\":\"\",\"高さ\":\"\",\"回転角\":\"0\",\"不透明度\":\"255\",\"カラー赤\":\"0\",\"カラー緑\":\"0\",\"カラー青\":\"0\",\"カラー灰\":\"0\"}","{\"ピクチャ名\":\"ズキンちゃん\",\"画像\":\"\",\"位置X\":\"0\",\"位置Y\":\"0\",\"スケールX\":\"-1\",\"スケールY\":\"1\",\"横幅+\":\"0\",\"高さ+\":\"0\",\"横幅\":\"\",\"高さ\":\"\",\"回転角\":\"0\",\"不透明度\":\"255\",\"カラー赤\":\"0\",\"カラー緑\":\"0\",\"カラー青\":\"0\",\"カラー灰\":\"0\"}","{\"ピクチャ名\":\"大魔王\",\"画像\":\"\",\"位置X\":\"0\",\"位置Y\":\"0\",\"スケールX\":\"-1\",\"スケールY\":\"1\",\"横幅+\":\"0\",\"高さ+\":\"0\",\"横幅\":\"\",\"高さ\":\"\",\"回転角\":\"0\",\"不透明度\":\"255\",\"カラー赤\":\"0\",\"カラー緑\":\"0\",\"カラー青\":\"0\",\"カラー灰\":\"0\"}"]
 *
 * 
 * 
 * @param BGM登録
 * @parent ■登録2
 * @desc bgmMaking BGMを登録する。スタイルかプラグインコマンドから呼び出せる
 * @type struct<bgm>[]
 * @default ["{\"BGM名\":\"d1-BGM\",\"ファイル\":\"\",\"音量\":\"50\",\"ピッチ\":\"100\",\"位相\":\"0\"}","{\"BGM名\":\"d2-BGM\",\"ファイル\":\"\",\"音量\":\"50\",\"ピッチ\":\"100\",\"位相\":\"0\"}","{\"BGM名\":\"ショップ1\",\"ファイル\":\"\",\"音量\":\"50\",\"ピッチ\":\"100\",\"位相\":\"0\"}","{\"BGM名\":\"ショップ2\",\"ファイル\":\"\",\"音量\":\"50\",\"ピッチ\":\"100\",\"位相\":\"0\"}","{\"BGM名\":\"名前入力\",\"ファイル\":\"\",\"音量\":\"50\",\"ピッチ\":\"100\",\"位相\":\"0\"}"]
 * 
 * 
 * 
 * @param ■デザイン
 * 
 * @param デザイン1
 * @parent ■デザイン
 * @desc design1 スタイルの各ウインドウやシーンに対する適用パターン。その1
 * @type struct<design>[]
 * @default ["{\"対象ウインドウ\":\"\",\"対象シーン\":\"MenuBase,\\nMessage\",\"継承先にも適用\":\"true\",\"適用スタイル\":\"d1-シーン/ベース\",\"無効\":\"\",\"外部プラグイン用\":\"\",\"対象ウインドウC\":\"\",\"対象シーンC\":\"\"}","{\"対象ウインドウ\":\"\",\"対象シーン\":\"Shop\",\"継承先にも適用\":\"true\",\"適用スタイル\":\"d1-シーン/ショップ\",\"無効\":\"\",\"外部プラグイン用\":\"\",\"対象ウインドウC\":\"\",\"対象シーンC\":\"\"}","{\"対象ウインドウ\":\"StatusBase\",\"対象シーン\":\"\",\"継承先にも適用\":\"true\",\"適用スタイル\":\"d1-ステータスベース\",\"無効\":\"\",\"外部プラグイン用\":\"\",\"対象ウインドウC\":\"\",\"対象シーンC\":\"\"}","{\"対象ウインドウ\":\"ItemList,\\nSkillList,\\nShopBuy,\\nShopSell\",\"対象シーン\":\"\",\"継承先にも適用\":\"\",\"適用スタイル\":\"d1-リスト\",\"無効\":\"\",\"外部プラグイン用\":\"\",\"対象ウインドウC\":\"\",\"対象シーンC\":\"\"}","{\"対象ウインドウ\":\"ShopBuy,\\nShopSell\",\"対象シーン\":\"\",\"継承先にも適用\":\"\",\"適用スタイル\":\"d1-リスト\",\"無効\":\"\",\"外部プラグイン用\":\"\",\"対象ウインドウC\":\"\",\"対象シーンC\":\"\"}","{\"対象ウインドウ\":\"EquipSlot\",\"対象シーン\":\"\",\"継承先にも適用\":\"\",\"適用スタイル\":\"d1-装備スロット\",\"無効\":\"\",\"外部プラグイン用\":\"\",\"対象ウインドウC\":\"\",\"対象シーンC\":\"\"}","{\"対象ウインドウ\":\"Status\",\"対象シーン\":\"\",\"継承先にも適用\":\"\",\"適用スタイル\":\"d1-ステータス\",\"無効\":\"\",\"外部プラグイン用\":\"\",\"対象ウインドウC\":\"\",\"対象シーンC\":\"\"}","{\"対象ウインドウ\":\"StatusParams\",\"対象シーン\":\"\",\"継承先にも適用\":\"\",\"適用スタイル\":\"d1-ステータスパラム\",\"無効\":\"\",\"外部プラグイン用\":\"\",\"対象ウインドウC\":\"\",\"対象シーンC\":\"\"}","{\"対象ウインドウ\":\"Options,\\nSavefileList,\\nGameEnd\",\"対象シーン\":\"\",\"継承先にも適用\":\"\",\"適用スタイル\":\"d1-縦リスト\",\"無効\":\"\",\"外部プラグイン用\":\"\",\"対象ウインドウC\":\"\",\"対象シーンC\":\"\"}","{\"対象ウインドウ\":\"Gold\",\"対象シーン\":\"\",\"継承先にも適用\":\"\",\"適用スタイル\":\"d1-ゴールド\",\"無効\":\"\",\"外部プラグイン用\":\"\",\"対象ウインドウC\":\"\",\"対象シーンC\":\"\"}","{\"対象ウインドウ\":\"Help\",\"対象シーン\":\"\",\"継承先にも適用\":\"\",\"適用スタイル\":\"d1-ヘルプ\",\"無効\":\"\",\"外部プラグイン用\":\"\",\"対象ウインドウC\":\"\",\"対象シーンC\":\"\"}","{\"対象ウインドウ\":\"ShopNumber\",\"対象シーン\":\"\",\"継承先にも適用\":\"\",\"適用スタイル\":\"d1-ショップ決済\",\"無効\":\"\",\"外部プラグイン用\":\"\",\"対象ウインドウC\":\"\",\"対象シーンC\":\"\"}"]
 * 
 * 
 * 
 * @param デザイン2
 * @parent ■デザイン
 * @desc design2 スタイルの各ウインドウやシーンに対する適用パターン。その2
 * @type struct<design>[]
 * @default ["{\"対象ウインドウ\":\"\",\"対象シーン\":\"MenuBase,\\nMessage\",\"継承先にも適用\":\"true\",\"適用スタイル\":\"d2-シーン/ベース\",\"無効\":\"\",\"外部プラグイン用\":\"\",\"対象ウインドウC\":\"\",\"対象シーンC\":\"\"}","{\"対象ウインドウ\":\"\",\"対象シーン\":\"Shop\",\"継承先にも適用\":\"true\",\"適用スタイル\":\"d2-シーン/ショップ\",\"無効\":\"\",\"外部プラグイン用\":\"\",\"対象ウインドウC\":\"\",\"対象シーンC\":\"\"}","{\"対象ウインドウ\":\"StatusBase\",\"対象シーン\":\"\",\"継承先にも適用\":\"true\",\"適用スタイル\":\"d2-ステータスベース\",\"無効\":\"\",\"外部プラグイン用\":\"\",\"対象ウインドウC\":\"\",\"対象シーンC\":\"\"}","{\"対象ウインドウ\":\"ItemList,\\nSkillList,\\nShopBuy,\\nShopSell\",\"対象シーン\":\"\",\"継承先にも適用\":\"\",\"適用スタイル\":\"d2-リスト\",\"無効\":\"\",\"外部プラグイン用\":\"\",\"対象ウインドウC\":\"\",\"対象シーンC\":\"\"}","{\"対象ウインドウ\":\"SkillStatus\",\"対象シーン\":\"\",\"継承先にも適用\":\"\",\"適用スタイル\":\"d2-スキルステータス\",\"無効\":\"\",\"外部プラグイン用\":\"\",\"対象ウインドウC\":\"\",\"対象シーンC\":\"\"}","{\"対象ウインドウ\":\"EquipSlot\",\"対象シーン\":\"\",\"継承先にも適用\":\"\",\"適用スタイル\":\"d2-装備スロット\",\"無効\":\"\",\"外部プラグイン用\":\"\",\"対象ウインドウC\":\"\",\"対象シーンC\":\"\"}","{\"対象ウインドウ\":\"Status\",\"対象シーン\":\"\",\"継承先にも適用\":\"\",\"適用スタイル\":\"d2-ステータス\",\"無効\":\"\",\"外部プラグイン用\":\"\",\"対象ウインドウC\":\"\",\"対象シーンC\":\"\"}","{\"対象ウインドウ\":\"StatusParams\",\"対象シーン\":\"\",\"継承先にも適用\":\"\",\"適用スタイル\":\"d2-ステータスパラム\",\"無効\":\"\",\"外部プラグイン用\":\"\",\"対象ウインドウC\":\"\",\"対象シーンC\":\"\"}","{\"対象ウインドウ\":\"Options,\\nSavefileList,\\nGameEnd\",\"対象シーン\":\"\",\"継承先にも適用\":\"\",\"適用スタイル\":\"d2-縦リスト\",\"無効\":\"\",\"外部プラグイン用\":\"\",\"対象ウインドウC\":\"\",\"対象シーンC\":\"\"}","{\"対象ウインドウ\":\"Gold\",\"対象シーン\":\"\",\"継承先にも適用\":\"\",\"適用スタイル\":\"d2-ゴールド\",\"無効\":\"\",\"外部プラグイン用\":\"\",\"対象ウインドウC\":\"\",\"対象シーンC\":\"\"}","{\"対象ウインドウ\":\"Help\",\"対象シーン\":\"\",\"継承先にも適用\":\"\",\"適用スタイル\":\"d2-ヘルプ\",\"無効\":\"\",\"外部プラグイン用\":\"\",\"対象ウインドウC\":\"\",\"対象シーンC\":\"\"}","{\"対象ウインドウ\":\"ShopNumber\",\"対象シーン\":\"\",\"継承先にも適用\":\"\",\"適用スタイル\":\"d2-ショップ決済\",\"無効\":\"\",\"外部プラグイン用\":\"\",\"対象ウインドウC\":\"\",\"対象シーンC\":\"\"}","{\"対象ウインドウ\":\"NameEdit\",\"対象シーン\":\"\",\"継承先にも適用\":\"\",\"適用スタイル\":\"d2-名前変更\",\"無効\":\"\",\"外部プラグイン用\":\"\",\"対象ウインドウC\":\"\",\"対象シーンC\":\"\"}","{\"対象ウインドウ\":\"NameInput\",\"対象シーン\":\"\",\"継承先にも適用\":\"\",\"適用スタイル\":\"d2-名前入力\",\"無効\":\"\",\"外部プラグイン用\":\"\",\"対象ウインドウC\":\"\",\"対象シーンC\":\"\"}"]
 * 
 * 
 * 
 * @param デザイン3
 * @parent ■デザイン
 * @desc design3 スタイルの各ウインドウやシーンに対する適用パターン。その3
 * @type struct<design>[]
 * @default 
 * 
 * @param デザイン4
 * @parent ■デザイン
 * @desc design4 スタイルの各ウインドウやシーンに対する適用パターン。その4
 * @type struct<design>[]
 * @default 
 * 
 * @param デザイン5
 * @parent ■デザイン
 * @desc design5 スタイルの各ウインドウやシーンに対する適用パターン。その5
 * @type struct<design>[]
 * @default 
 * 
 * @param デザイン6
 * @parent ■デザイン
 * @desc design6 スタイルの各ウインドウやシーンに対する適用パターン。その6
 * @type struct<design>[]
 * @default 
 * 
 * @param デザイン7
 * @parent ■デザイン
 * @desc design7 スタイルの各ウインドウやシーンに対する適用パターン。その7
 * @type struct<design>[]
 * @default 
 * 
 * @param デザイン8
 * @parent ■デザイン
 * @desc design8 スタイルの各ウインドウやシーンに対する適用パターン。その8
 * @type struct<design>[]
 * @default 
 * 
 * @param デザイン9
 * @parent ■デザイン
 * @desc design9 スタイルの各ウインドウやシーンに対する適用パターン。その9
 * @type struct<design>[]
 * @default 
 * 
 * @param デザイン10
 * @parent ■デザイン
 * @desc design10 スタイルの各ウインドウやシーンに対する適用パターン。その10
 * @type struct<design>[]
 * @default 
 * 
 * @param 開始デザイン
 * @parent ■デザイン
 * @desc startDesign ゲーム開始時に適用するデザイン
 * @type select
 * @option デザイン1
 * @option デザイン2
 * @option デザイン3
 * @option デザイン4
 * @option デザイン5
 * @option デザイン6
 * @option デザイン7
 * @option デザイン8
 * @option デザイン9
 * @option デザイン10
 * @option デザインなし
 * @default デザイン1
 *
 *
 *
 * @command デザイン変更
 * @desc changeDisign デザインを変更する
 *
 * @arg デザイン
 * @desc desing 使用するデザイン
 * @type select
 * @option デザイン1
 * @option デザイン2
 * @option デザイン3
 * @option デザイン4
 * @option デザイン5
 * @option デザイン6
 * @option デザイン7
 * @option デザイン8
 * @option デザイン9
 * @option デザイン10
 * @option デザインなし
 * @default
 * 
 * 
 * 
 * @command 背景変更
 * @desc changeBack メニューの背景を変更する
 *
 * @arg 対象デザイン
 * @desc subjectDesign 背景を変更するデザイン
 * @type select
 * @option デザイン1
 * @option デザイン2
 * @option デザイン3
 * @option デザイン4
 * @option デザイン5
 * @option デザイン6
 * @option デザイン7
 * @option デザイン8
 * @option デザイン9
 * @option デザイン10
 * @option 全部
 * @default 全部
 * 
 * @arg 背景
 * @desc 適用する背景。背景登録した背景名を書く。none で背景なし
 * 
 * 
 * 
 * @command 背景戻す
 * @desc undoBack 変更した背景を元に戻す
 *
 * @arg 対象デザイン
 * @desc subjectDesign 背景を元に戻すデザイン
 * @type select
 * @option デザイン1
 * @option デザイン2
 * @option デザイン3
 * @option デザイン4
 * @option デザイン5
 * @option デザイン6
 * @option デザイン7
 * @option デザイン8
 * @option デザイン9
 * @option デザイン10
 * @option 全部
 * @default 全部
 * 
 * 
 * 
 * @command ピクチャ変更
 * @desc changePicture メニューのピクチャを変更する
 *
 * @arg 対象デザイン
 * @desc subjectDesing ピクチャを変更するデザイン
 * @type select
 * @option デザイン1
 * @option デザイン2
 * @option デザイン3
 * @option デザイン4
 * @option デザイン5
 * @option デザイン6
 * @option デザイン7
 * @option デザイン8
 * @option デザイン9
 * @option デザイン10
 * @option 全部
 * @default 全部
 * 
 * @arg ピクチャパック
 * @desc 適用するピクチャパック。ピクチャパック登録したパック名を書く。none でピクチャなし
 * 
 * 
 * 
 * @command ピクチャ戻す
 * @desc undoPicture 変更したピクチャを元に戻す
 *
 * @arg 対象デザイン
 * @desc subjectDesign ピクチャを元に戻すデザイン
 * @type select
 * @option デザイン1
 * @option デザイン2
 * @option デザイン3
 * @option デザイン4
 * @option デザイン5
 * @option デザイン6
 * @option デザイン7
 * @option デザイン8
 * @option デザイン9
 * @option デザイン10
 * @option 全部
 * @default 全部
 * 
 * 
 * 
 * @command BGM変更
 * @desc changeBGM メニューのBGMを変更する
 *
 * @arg 対象デザイン
 * @desc subjectDesign BGMを変更するデザイン
 * @type select
 * @option デザイン1
 * @option デザイン2
 * @option デザイン3
 * @option デザイン4
 * @option デザイン5
 * @option デザイン6
 * @option デザイン7
 * @option デザイン8
 * @option デザイン9
 * @option デザイン10
 * @option 全部
 * @default 全部
 * 
 * @arg BGM
 * @desc 適用するBGM。BGM登録したパック名を書く。none でBGMなし
 * 
 * 
 * 
 * @command BGM戻す
 * @desc undoBGM 変更したBGMを元に戻す
 *
 * @arg 対象デザイン
 * @desc subjectDesign BGMを元に戻すデザイン
 * @type select
 * @option デザイン1
 * @option デザイン2
 * @option デザイン3
 * @option デザイン4
 * @option デザイン5
 * @option デザイン6
 * @option デザイン7
 * @option デザイン8
 * @option デザイン9
 * @option デザイン10
 * @option 全部
 * @default 全部
 */



//==================================================
/*~struct~style:
//==================================================
 * @param スタイル名
 * @desc styleName スタイルの名前。デザインからの呼び出しに使う
 *
 * @param スキン
 * @desc skin 適用するスキン。スキン登録したスキン名を書く
 * 
 * @param …スキンアニメ
 * @desc skinAnime-open シーン開始時にスキンに適用するアニメ。アニメーション登録したアニメ名を書く
 *
 * 
 * @param ウインドウ消す
 * @desc hideWindow 標準のウインドウを表示しない
 * @type boolean
 * 
 * @param フォント
 * @desc font 適用するフォント設定。フォント登録したフォント名を書く
 * 
 * @param 数字フォント
 * @desc numberFont 数字に適用するフォント設定。フォント登録したフォント名を書く
 * 
 * @param ■シーン設定
 * 
 * @param カーソルアニメ-開始
 * @parent ■シーン設定
 * @desc cursorAnime-open 最初に実行するカーソルアニメ。このアニメが終了後に通常カーソルアニメを実行
 * 
 * @param カーソルアニメ
 * @parent ■シーン設定
 * @desc cursorAnime カーソルが当たっている時にスキンに適用するアニメ。アニメーション登録したアニメ名を書く
 * 
 * @param …カラートーン補正
 * @parent ■シーン設定
 * @desc colorToneAdjust カーソルアニメでスキンがどんな不透明度でも近い色合いになる補正。その基準不透明度。基本 180
 * 
 * @param カーソルスキン
 * @parent ■シーン設定
 * @desc cursorSkin カーソルとして適用するスキン。スキン登録したスキン名を書く。空欄なら非表示。default で通常カーソル
 * 
 * @param 背景
 * @parent ■シーン設定
 * @desc back 適用する背景。背景登録した背景名を書く
 * 
 * @param …背景アニメ
 * @parent ■シーン設定
 * @desc backAnime-open 背景が出た時に適用するアニメ。アニメーション登録したアニメ名を書く

 * 
 * @param メニュー終了アニメ
 * @parent ■シーン設定
 * @desc menuCloseAnime メニューを閉じる時のアニメ。アニメーション登録したアニメ名を書く
 * 
 * @param ピクチャパック
 * @parent ■シーン設定
 * @desc picturePack 画面に表示するピクチャパック。ピクチャパック登録したパック名を書く
 * 
 * @param BGM
 * @parent ■シーン設定
 * @desc メニュー画面で流すBGM。BGM登録したBGM名を書く
 * 
 * @param ■その他設定
 *
 * @param 並べ替えカーソル色
 * @parent ■その他設定
 * @desc pendingCursorColor 並べ替えカーソルの色。赤, 緑, 青, 濃度。各0～255、濃度は0～1。基本 255, 224, 0
 * 
 * @param 並べ替えカーソル丸み
 * @parent ■その他設定
 * @desc pendingCursorRound 並べ替え時カーソルの角の丸み。角丸み, 線丸み。5 なら 5ピクセル 丸まる。基本 75, 0
 * 
 * @param バックスキン
 * @parent ■その他設定
 * @desc backSkin 通常スキンの奥に表示するスキン。スキン登録したスキン名を書く
 * 
 * @param バック塗り
 * @parent ■その他設定
 * @desc backColor 通常スキンの奥を塗りつぶす。その色。赤, 緑, 青, 濃度。各0～255、濃度は0～1
 * 
 * @param 手前に表示
 * @parent ■その他設定
 * @desc showFront ウインドウを他より手前に表示する
 * @type boolean
 */



//==================================================
/*~struct~skin:
//==================================================
 * @param スキン名
 * @desc skinName スキンの名前。スタイルからの呼び出しに使う
 *
 * @param 画像
 * @desc image スキンに使う画像。picturesフォルダに入れる
 * @type file
 * @dir img/pictures
 *
 * @param 位置X
 * @desc posX スキンのX位置。5 なら 5ピクセル 右へ
 *
 * @param 位置Y
 * @desc posY スキンのY位置。5 なら 5ピクセル 下へ
 *
 * @param スケールX
 * @desc scaleX スキンのX拡大率。1.5 なら 1.5倍
 *
 * @param スケールY
 * @desc scaleY スキンのY拡大率。1.5 なら 1.5倍
 *
 * @param 横幅+
 * @desc width+ スキン横幅の増減幅。5 なら 5ピクセル 拡大
 *
 * @param 高さ+
 * @desc height+ スキン縦高の増減幅。5 なら 5ピクセル 拡大
 *
 * @param 横幅
 * @desc width スキンの横幅。50 なら 50ピクセル。空欄ならウインドウ幅に合わせる
 *
 * @param 高さ
 * @desc height スキンの縦高。50 なら 50ピクセル。空欄ならウインドウ幅に合わせる
 * 
 * @param 回転角
 * @desc spin スキンの回転角。0〜360度。90 で右に 90度、-90 で左に 90度
 *
 * @param 不透明度
 * @desc opacity スキンの不透明度。0〜255。値を増すほど濃くなる
 *
 * @param カラー赤
 * @desc colorRed スキンの赤み。-255〜255
 *
 * @param カラー緑
 * @desc colorGreen スキンの緑み。-255〜255
 *
 * @param カラー青
 * @desc colorBlue スキンの青み。-255〜255
 *
 * @param カラー灰
 * @desc colorGray スキンの灰色み。0〜255
 */



//==================================================
/*~struct~pict:
//==================================================
 * @param ピクチャ名
 * @desc pictureName ピクチャの名前。ピクチャパックからの呼び出しに使う
 *
 * @param 画像
 * @desc image ピクチャに使う画像。picturesフォルダに入れる
 * @type file
 * @dir img/pictures
 *
 * @param 位置X
 * @desc posX ピクチャのX位置。5 なら 5ピクセル 右へ
 *
 * @param 位置Y
 * @desc posY ピクチャのY位置。5 なら 5ピクセル 下へ
 * 
 * @param スケールX
 * @desc scaleX ピクチャのX拡大率。1.5 なら横幅 1.5倍
 *
 * @param スケールY
 * @desc scaleY ピクチャのY拡大率。1.5 なら縦高 1.5倍
 *
 * @param 横幅+
 * @desc width+ ピクチャ横幅の増減幅。5 なら横に 5ピクセル 拡大
 *
 * @param 高さ+
 * @desc height+ ピクチャ縦高の増減幅。5 なら縦に 5ピクセル 拡大
 * 
 * @param 横幅
 * @desc width ピクチャの横幅。50 なら 50ピクセル。空欄ならウインドウ幅に合わせる
 *
 * @param 高さ
 * @desc height ピクチャの縦高。50 なら 50ピクセル。空欄ならウインドウ幅に合わせる
 *
 * @param 回転角
 * @desc spin ピクチャの回転角。0〜360度。90 で右に 90度、-90 で左に 90度
 *
 * @param 不透明度
 * @desc opacity ピクチャの不透明度。0〜255。値を増すほど濃くなる
 *
 * @param カラー赤
 * @desc colorRed ピクチャの赤み。-255〜255
 *
 * @param カラー緑
 * @desc colorGreen ピクチャの緑み。-255〜255
 * 
 * @param カラー青
 * @desc colorBlue ピクチャの青み。-255〜255
 *
 * @param カラー灰
 * @desc colorGray ピクチャの灰色み。0〜255
 */



//==================================================
/*~struct~back:
//==================================================
 * @param 背景名
 * @desc backName 背景の名前。スタイルかプラグインコマンドからの呼び出しに使う
 *
 * @param 画像
 * @desc image 背景に使う画像。picturesフォルダに入れる
 * @type file
 * @dir img/pictures
 *
 * @param 不透明度
 * @desc opacity 背景の不透明度。0〜255。値を増すほど濃くなる
 *
 * @param カラー赤
 * @desc colorRed 背景の赤み。-255〜255
 *
 * @param カラー緑
 * @desc colorGreen 背景の緑み。-255〜255
 *
 * @param カラー青
 * @desc colorBlue 背景の青み。-255〜255
 *
 * @param カラー灰
 * @desc colorGray 背景の灰色み。0〜255
 * 
 * @param 移動X
 * @desc moveX 背景を横移動させる。5 なら1フレームあたり 5ピクセル 右へ
 * 
 * @param 移動Y
 * @desc moveY 背景を縦移動させる。5 なら1フレームあたり 5ピクセル 下へ
 */



//==================================================
/*~struct~animation:
//==================================================
 * @param アニメ名
 * @desc animeName アニメーションの名前。スタイルからの呼び出しに使う
 *
 * @param アニメ時間
 * @desc animeTime アニメの実行時間。5 なら 5フレーム、1s なら 1秒。5~10 なら 5 から 10 の間のランダム
 * @default 0
 *
 * @param アニメ回数
 * @desc animeTimes アニメの実行回数。2 なら 2回 実行。-1 でループ実行
 * @default 1
 * 
 * @param 位置X
 * @desc posX 最初のX位置。5 で右に 5ピクセル、-5で左に 5ピクセル
 *
 * @param 位置Y
 * @desc posY 最初のY位置。5 で下に 5ピクセル、-5で上に 5ピクセル
 *
 * @param →位置X
 * @desc →posX 目標とするX位置。5 で右に 5ピクセル、-5で左に 5ピクセル
 *
 * @param →位置Y
 * @desc →posY 目標とするY位置。5 で下に 5ピクセル、-5で上に 5ピクセル
 *
 * @param スケールX
 * @desc scaleX 最初のX拡大率。1.5 で 1.5倍、0.5 で 0.5倍。マイナスで左右反転
 *
 * @param スケールY
 * @desc scaleY 最初のY拡大率。1.5 で 1.5倍、0.5 で 0.5倍。マイナスで上下反転
 *
 * @param →スケールX
 * @desc →scaleX 目標とするX拡大率。1.5 で 1.5倍、0.5 で 0.5倍。マイナスで左右反転
 *
 * @param →スケールY
 * @desc →scaleY 目標とするY拡大率。1.5 で 1.5倍、0.5 で 0.5倍。マイナスで上下反転
 *
 * @param 回転角
 * @desc angle 最初の回転角。0〜360度。90 で右に 90度、-90 で左に 90度
 *
 * @param →回転角
 * @desc →angle 目標とする回転角。0〜360度。90 で右に 90度、-90 で左に 90度
 *
 * @param 不透明度
 * @desc opacity 最初の不透明度。0〜255
 *
 * @param →不透明度
 * @desc →opacity 目標とする不透明度。0〜255
 *
 * @param カラー赤
 * @desc colorRed カラートーン・赤。-255〜255
 *
 * @param カラー緑
 * @desc colorGreen 最初のカラートーン・緑。-255〜255
 *
 * @param カラー青
 * @desc colorBlue 最初のカラートーン・青。-255〜255
 *
 * @param カラー灰
 * @desc colorGray 最初のカラートーン・グレー。-255〜255
 *
 * @param →カラー赤
 * @desc →colorRed カラートーン・赤。-255〜255
 *
 * @param →カラー緑
 * @desc →colorGreen 目標とするカラートーン・緑。-255〜255
 *
 * @param →カラー青
 * @desc →colorBlue 目標とするカラートーン・青。-255〜255
 *
 * @param →カラー灰
 * @desc →colorGray 目標とするカラートーン・グレー。-255〜255
 * 
 * @param 透明化
 * @desc transparent 透明にする
 * @type boolean
 */



//==================================================
/*~struct~font:
//==================================================
/*
 * @param フォント名
 * @desc fontName フォント設定の名前。スタイルからの呼び出しに使う
 * 
 * @param フォント
 * @desc font 使用するフォント。『Keke_CommonData』でフォント登録した名を書く
 * 
 * @param 文字サイズ
 * @desc fontSize テキストの文字サイズ。空欄なら標準サイズ。+1 で標準サイズ + 1、-1 で標準サイズ - 1
 * 
 * @param 文字色
 * @desc fontColor テキストの文字色。赤, 緑, 青, 濃度。色0〜255、濃度0〜1。空欄なら元々の色を適用
 * @default 255, 255, 255, 1
 *
 * @param 縁取り幅
 * @desc outWidth テキストの縁取り幅。5 なら 5ピクセル。空欄なら元々の縁取り幅を適用
 * @default 6
 *
 * @param 縁取り色
 * @desc outColor テキストの縁取り色。赤, 緑, 青, 濃度。色0〜255、濃度0〜1。。空欄なら元々の色を適用
 * @default 0, 0, 0, 1
 */



//==================================================
/*~struct~pictPack:
//==================================================
* @param パック名
* @desc packName ピクチャパックの名前。スタイルかプラグインコマンドからの呼び出しに使う
*
* @param ピクチャリスト
* @desc pictureList 表示するピクチャのリスト
* @type struct<picture>[] 
*/



//==================================================
/*~struct~picture:
//==================================================
* @param ピクチャ名
* @desc pictureName ピクチャの名前
*
* @param 使用ピクチャ
* @desc usePicture 使用するピクチャ。ピクチャ登録したピクチャ名を書く
*
* @param レイヤー
* @desc layer ピクチャを表示するレイヤー。下層はメニュー本体より下、上層は上
* @type select
* @option 上層
* @option 下層
* @default 下層
*
* @param 原点X
* @desc originX ピクチャのX原点。0～1
* @default 0.5
*
* @param 原点Y
* @desc originY ピクチャのY原点。0～1
* @default 0.5
*
* @param 位置X
* @desc posX ピクチャを表示する画面X座標
*
* @param 位置Y
* @desc posY ピクチャを表示する画面Y座標
*
* @param 位置寄せX
* @desc alignX 横方向の位置を画面左寄せか、画面中央寄せか、画面右寄せにする
* @type select
* @option 寄せない
* @option 左寄せ
* @option 中央寄せ
* @option 右寄せ
*
* @param 位置寄せY
* @desc alignY 横方向の位置を画面上寄せか、画面中央寄せか、画面下寄せにする
* @type select
* @option 寄せない
* @option 上寄せ
* @option 中央寄せ
* @option 下寄せ
*
* @param 横幅
* @desc width ピクチャの横幅。50 なら 50ピクセル。gw なら画面横幅
*
* @param 高さ
* @desc height ピクチャの縦高。50 なら 50ピクセル。gw なら画面高さ
* 
* @param 連動ウインドウ
* @desc linkWindow 連動ウインドウが有効な時のみピクチャを表示する。ShopCommand なら Window_ShopCommand と連動
*
* @param 有効シーン
* @desc validSceen 現在が有効シーンの時のみピクチャを表示する。Menu なら Scene_Menu の時のみ表示
*
* @param 表示条件
* @desc showCondition 様々なピクチャ表示条件。条件を満たさない場合は消える
* @type struct<pictCondition>
*
* @param 開始アニメ
* @desc startAnime シーン開始時にピクチャに実行させるアニメ。アニメーション登録したアニメ名を書く
*
* @param …再アニメ
* @desc animeRedo シーンが切り替わるたびに開始アニメを繰り返す
* @type boolean

* @param 表示中アニメ
* @desc inAnime ピクチャ表示中に実行させるアニメ。アニメーション登録したアニメ名を書く
*
* @param ピクチャテキスト
* @desc pictureText ピクチャに乗せるテキスト。横幅・高さ未指定の場合、ピクチャの幅はテキストの幅から決定される
* @type multiline_string
* @default　
*
* @param …フォント
* @desc font ピクチャテキストのフォント設定。フォント登録したフォント名を書く
*
* @param 無効
* @desc invalid ピクチャを無効にする
* @type boolean
*/



//==================================================
/*~struct~pictCondition:
//==================================================
* @param ショップ購入前
* @desc shopBeforeBuy ショップ画面で購入前であること
* @type boolean
*
* @param ショップ購入後
* @desc shopAfterBuy ショップ画面で購入後であること
* @type boolean
*
* @param ショップ売却前
* @desc shopBeforeSell ショップ画面で売却前であること
* @type boolean
*
* @param ショップ売却後
* @desc shopAfterSell ショップ画面で売却後であること
* @type boolean
*
* @param スクリプト
* @desc script js式で条件を記述する
* @type multiline_string
*/



//==================================================
/*~struct~bgm:
//==================================================
 * @param BGM名
 * @desc bgmName BGMの名前。スタイルかプラグインコマンドからの呼び出しに使う
 *
 * @param ファイル
 * @desc file BGMファイル
 * @type file
 * @dir audio/bgm
 * *
 * @param 音量
 * @desc volume BGMの音量
 * @default 50
 *
 * @param ピッチ
 * @desc pitch BMGのピッチ
 * @default 100
 * 
 * @param 位相
 * @desc pan BMGの位相
 * @default 0
 */



//==================================================
/*~struct~design:
//==================================================
 * @param 対象ウインドウ
 * @desc subjectWindow 対象とするウインドウ。Window_MenuCommand なら MenuCommand と書く。, で区切って複数指定可能
 * @type multiline_string
 * 
 * @param 対象シーン
 * @desc subjectScene 対象とするシーン。Scene_MenuBase なら MenuBase と書く。, で区切って複数指定可能
 * @type multiline_string
 * 
 * @param 継承先にも適用
 * @desc applyOverRide 継承先のウイドウウ/シーンにもデザイン適用する
 * @type boolean
 * 
 * @param 適用スタイル
 * @desc applyStyle 適用するスタイル。スタイル登録したスタイル名を書く
 * 
 * @param 無効
 * @desc invalidこの項目を無効にする
 * @type boolean
 * 
 * @param 外部プラグイン用
 * 
 * @param 対象ウインドウC
 * @parent 外部プラグイン用
 * @desc subjectWindowC カスタムメニュー系の他プラグイン用。対象とするウインドウの識別子, で区切って複数指定可能
 * @type multiline_string
 * @default 
 * 
 * @param 対象シーンC
 * @parent 外部プラグイン用
 * @desc subjectSceneC カスタムメニュー系の他プラグイン用。対象とするシーンの識別子, で区切って複数指定可能
 * @type multiline_string
 * @default 
 * 
 */
 
 
 
(() => {
    //- プラグイン名
    const pluginName = document.currentScript.src.match(/^.*\/(.*).js$/)[1];
    
    
    
    //==================================================
    //--  スプライト追加 /ベーシック
    //==================================================
    
    //- 破棄付きスプライト
    function SpriteKeMnsk() {
        this.initialize(...arguments);
    }

    SpriteKeMnsk.prototype = Object.create(Sprite.prototype);
    SpriteKeMnsk.prototype.constructor = SpriteKeMnsk;

    SpriteKeMnsk.prototype.destroy = function() {
        if (this.bitmap && !this.bitmap._url) { this.bitmap.destroy(); }
        Sprite.prototype.destroy.call(this);
    };
    
    
    //-  クリッカブルスプライト-メニューに化粧
    function Sprite_ClickableKeMnsk() {
        this.initialize(...arguments);
    }
    
    Sprite_ClickableKeMnsk.prototype = Object.create(Sprite_Clickable.prototype);
    Sprite_ClickableKeMnsk.prototype.constructor = Sprite_ClickableKeMnsk;
    
    Sprite_ClickableKeMnsk.prototype.initialize = function(bitmap, handler) {
        Sprite_Clickable.prototype.initialize.apply(this);
        this.bitmap = bitmap;
        this._clickHandler = handler;
    };
    
    Sprite_ClickableKeMnsk.prototype.destroy = function() {
        if (this.bitmap && !this.bitmap._url) { this.bitmap.destroy(); }
        Sprite.prototype.destroy.apply(this);
    };
    
    //- ハンドラのセット
    Sprite_ClickableKeMnsk.prototype.setHandler = function(method) {
        this._clickHandler = method;
    };
    
    //- ハンドラの呼び出し
    Sprite_ClickableKeMnsk.prototype.callHandler = function() {
        this._clickHandler()
    };
    
    //- オンクリックの処理
    Sprite_ClickableKeMnsk.prototype.onClick = function() {
        if (this._clickHandler) {
            this._clickHandler();
        } else {
            Input.virtualClick(this._buttonType);
        }
    };
    
    
    
    //==================================================
    //--  文字列オート変換 /ベーシック
    //==================================================
    
    // 文字列のハッシュ化
    function strToHash(str) {
        if (!str || !str.length) { return {}; }
        let hash = {};
        const strs = JSON.parse(str);
        let val = null;
        let val2 = null;
        for (let key in strs) {
            val = strs[key];
            if (!key || !val) { continue; }
            val2 = strToAuto(val, key);
            hash[key] = val2;
        }
        return hash;
    };
    
    
    // 文字列のリスト化
    function strToList(str) {
        if (!str || !str.length) { return []; }
        let array = JSON.parse(str);
        return array.map((val, i) => {
            return strToAuto(val);
        });
    };
    
    
    // 文字列の自動処理
    function strToAuto(val, key = "") {
        let val2 = null;
        let match = null;
        let end = false;
        if (!end) {
            if (val[0] == "{") {
                val2 = strToHash(val);
                end = true;
            }
        }
        if (!end) {
            if (val[0] == "[") {
                val2 = strToList(val);
                end = true;
            }
        }
        if (!end) { val = val + ","; }
        if (!end) {
            match = val.match(/^\s*(-?\d+,\s*-?\d+,\s*-?\d+,?\s*-?\d*\.?\d*)\s*,$/);
            if (match && !val.match(/[^\d\.\-,\s]/)) {
                if (key.match(/(カラー|色|塗り)/) && !key.includes("トーン") && !key.includes("ブレンド") && !key.includes("配色") && !key.includes("着色") &&  !key.includes("フラッシュ") && !key.includes("チェンジ") &&  !key.includes("選択")) {
                    val2 = "rgba(" +  match[1] + ")";
                } else {
                    val2 = JSON.parse("[" +  match[1] + "]");
                }
                end = true;
            }
        }
        if (!end) {
            match = val.match(/(-?\d+\.?\d*),\s*/g);
            if (match && match.length >= 2 && !val.match(/[^\d\.\-,\s]/)) {
                val2 = JSON.parse("[" + match.reduce((r, s) => r + s).replace(/,$/, "") + "]");
                end = true;
            }
        }
        if (!end) {
            match = val.match(/^(true|false)\s*,/);
            if (match) {
                val2 = match[1] == "true" ? true : false;
                end = true;
            }
        }
        if (!end) {
            match = val.match(/^(-?\d+\.?\d*)\s*,/);
            if (match && !val.match(/[^\d\.\-,\s]/)) {
                val2 = Number(match[1]); end = true;
                end = true;
            }
        }
        if (!end) {
            match = val.match(/^.+,\n?.+/);
            if (match) {
                val2 = val.replace(/\s/g, "").split(",").filter(v => v);
                end = true;
            }
        }
        if (!end) {
            if (val[0] == "\"") { val = val.slice(1); }
            val2 = val.slice(0, -1);
        }
        return val2;
    };



    //==================================================
    //--  パラメータ受け取り
    //==================================================
    
    //- 真偽化
    function toBoolean(str) {
        if (!str) { return false; }
        const str2 = str.toString().toLowerCase();
        if (str2 == "true" || str2 == "on") { return true; }
        if (str2 == "false" || str2 == "off") { return false; }
        return Number(str);
    };

    const parameters = PluginManager.parameters(pluginName);
    
    //- 登録
    const keke_styleList = strToList(parameters["スタイル登録"]);
    const keke_skinList = strToList(parameters["スキン登録"]);
    const keke_animeList = strToList(parameters["アニメーション登録"]);
    const keke_fontList = strToList(parameters["フォント登録"]);
    const keke_backList = strToList(parameters["背景登録"]);
    const keke_pictList = strToList(parameters["ピクチャ登録"]);
    const keke_pictPackList = strToList(parameters["ピクチャパック登録"]);
    const keke_bgmList = strToList(parameters["BGM登録"]);

    //- デザイン
    const keke_disigns = [];
    for (let i = 1; i <= 10; i++) {
        keke_disigns[i] = strToList(parameters["デザイン" + i]);
    }
    const keke_startPack = parameters["開始デザイン"];
    
    
    
    //==================================================
    //--  プラグインコマンド
    //==================================================
    
    //- デザイン変更
    PluginManager.registerCommand(pluginName, "デザイン変更", args => {
        const designName = args["デザイン"];
        if (!designName) { return; }
        $gameSystem._designKeMnsk = designName;
        // 背景位置の初期化
        initBackPoss();
    });


    //- 背景変更
    PluginManager.registerCommand(pluginName, "背景変更", args => {
        const tageDesign = args["対象デザイン"];
        const backName = args["背景"];
        if (!$gameSystem._backChangesKeMnsk) { $gameSystem._backChangesKeMnsk = {}; };
        $gameSystem._backChangesKeMnsk[tageDesign] = backName;
        // 背景位置の初期化
        initBackPoss();
    });


    //- 背景戻す
    PluginManager.registerCommand(pluginName, "背景戻す", args => {
        const tageDesign = args["対象デザイン"];
        if (!$gameSystem._backChangesKeMnsk) { return; };
        $gameSystem._backChangesKeMnsk[tageDesign] = null;
        // 背景位置の初期化
        initBackPoss();
    });


    //- ピクチャ変更
    PluginManager.registerCommand(pluginName, "ピクチャ変更", args => {
        const tageDesign = args["対象デザイン"];
        const pictName = args["ピクチャパック"];
        if (!$gameSystem._pictChangesKeMnsk) { $gameSystem._pictChangesKeMnsk = {}; };
        $gameSystem._pictChangesKeMnsk[tageDesign] = pictName;
    });


    //- ピクチャ戻す
    PluginManager.registerCommand(pluginName, "ピクチャ戻す", args => {
        const tageDesign = args["対象デザイン"];
        if (!$gameSystem._pictChangesKeMnsk) { return; };
        $gameSystem._pict
        $gameSystem._pictChangesKeMnsk[tageDesign] = null;
    });


    //- BGM変更
    PluginManager.registerCommand(pluginName, "BGM変更", args => {
        const tageDesign = args["対象デザイン"];
        const bgmName = args["BGM"];
        if (!$gameSystem._bgmChangesKeMnsk) { $gameSystem._bgmChangesKeMnsk = {}; };
        $gameSystem._bgmChangesKeMnsk[tageDesign] = bgmName;
    });


    //- BGM戻す
    PluginManager.registerCommand(pluginName, "BGM戻す", args => {
        const tageDesign = args["対象デザイン"];
        if (!$gameSystem._bgmChangesKeMnsk) { return; };
        $gameSystem._bgmChangesKeMnsk[tageDesign] = null;
    });
    
    
    
    //==================================================
    //--  共通開始
    //==================================================
    
    //- ウインドウベース(コア追加)
    const _Window_Base_initialize = Window_Base.prototype.initialize;
    Window_Base.prototype.initialize = function(rect) {
        _Window_Base_initialize.apply(this, arguments);
        // ウインドウの消去
        eraseWindow(this);
        
    };


    //- シーン・メニューベース/メッセージ(コア追加)
    let inSceneInit = false;

    const _Scene_MenuBase_create = Scene_MenuBase.prototype.create;
    Scene_MenuBase.prototype.create = function() {
        // シーン開始中フラグ
        inSceneInit = true;
        _Scene_MenuBase_create.apply(this);
        setTimeout(remInSceneInit, 0);
        // メニューBGMの開始
        //startMenuBGM(this);
    };

    const _Scene_Message_create = Scene_Message.prototype.create;
    Scene_Message.prototype.create = function() {
        // シーン開始中フラグ
        inSceneInit = true;
        _Scene_Message_create.apply(this);
        setTimeout(remInSceneInit, 0);
        if (!isValidDesign()) { return; }
        // メニューBGMの開始
        //startMenuBGM(this);
    };

    function remInSceneInit() {
        inSceneInit = false
    };


    //- シーンマップ(コア追加)
    const _Scene_Map_createDisplayObjects = Scene_Map.prototype.createDisplayObjects;
    Scene_Map.prototype.createDisplayObjects = function() {
        _Scene_Map_createDisplayObjects.apply(this);
        // メニュー終了アニメの処理
        processMenuEndAnime(this);
    };


    //- シーンメニューベース・背景の形成(コア追加)
    const _Scene_MenuBase_createBackground = Scene_MenuBase.prototype.createBackground;
    Scene_MenuBase.prototype.createBackground = function() {
        _Scene_MenuBase_createBackground.apply(this);
        // 背景の形成
        createBack(this);
        // ピクチャの形成
        createPicture(this);
    };


    //- シーンメッセージ・ウインドウレイヤーの形成(コア追加)
    Scene_Message.prototype.createWindowLayer = function() {
        if (isValidDesign()) {
            // 背景の形成
            createBack(this);
            // ピクチャの形成
            createPicture(this);
        }
        Scene_Base.prototype.createWindowLayer.apply(this);
    };


    //- シーンマネージャー・クリエイト後の処理
    const _SceneManager_onSceneCreate = SceneManager.onSceneCreate;
    SceneManager.onSceneCreate = function() {
        _SceneManager_onSceneCreate.apply(this);
        // ウインドウアニメのセット
        setWindowAnime(this._scene);
        // メニューBGMの開始
        startMenuBGM(this._scene);
    };

    
    
    //==================================================
    //--  共通更新
    //==================================================
    
    //- ウインドウベース(コア追加)
    const _Window_Base_update = Window_Base.prototype.update;
    Window_Base.prototype.update = function() {
        _Window_Base_update.apply(this);
        if (!isValidDesign()) { return; }
        // スキンの更新
        updateSkin(this);
        // ウインドウ開き率の更新
        updateWindowOpenness(this);
    };


    //- シーンマップ(コア追加)
    const _Scene_Map_update = Scene_Map.prototype.update;
    Scene_Map.prototype.update = function() {
        _Scene_Map_update.apply(this);
        // メニュー終了アニメの更新
        updateMenuEndAnime(this);
    };


    //- シーンベース
    const _Scene_Base_update = Scene_Base.prototype.update;
    Scene_Base.prototype.update = function() {
        _Scene_Base_update.apply(this);
        if (!isValidDesign()) { return; }
        // ピクチャの更新
        updatePict(this);
        // 背景の更新
        updateBack(this);
        //- アニメスプライトの更新
        if ($gameTemp._backAnimedKeMnsk) {
            updateAnimeSprite(this);
        }
    };

    
    
    //==================================================
    //--  共通終了
    //==================================================
    
    //- スプライトの破棄
    function destroySprite(sprite) {
        if (!sprite) { return; }
        sprite.children.forEach(s => destroySprite(s));
        if (sprite.bitmap && !sprite.bitmap._url) { sprite.bitmap.destroy(); }
        if (sprite._texture) { sprite.destroy(); }
    };


    //- シーン・メニューベース(コア追加)
    const _Scene_MenuBase_terminate = Scene_MenuBase.prototype.terminate;
    Scene_MenuBase.prototype.terminate = function() {
        _Scene_MenuBase_terminate.apply(this);
        // メニューの終了
        endMenu(this);
    };


    //- シーン・メッセージ(コア追加)
    const _Scene_Message_terminate = Scene_Message.prototype.terminate;
    Scene_Message.prototype.terminate = function() {
        _Scene_Message_terminate.apply(this);
        if (!isValidDesign()) { return; }
        // メニューの終了
        endMenu(this);
    };
    
    
    
    //==================================================
    //--  共通処理
    //==================================================


    //- 自動スタイル取得
    function getStyleAuto(windo) {
        // デザインの取得
        const design = getDesign();
        if (!design) { return; }
        let windoStyle = null;
        // ウインドウからのスタイル取得
        if (windo) {
            windoStyle = getStyleByWindow(windo, design);
        }
        // シーンからのスタイル取得
        const sceneStyle = getStyleByScene(null, design);
        return uniteStyle(sceneStyle, windoStyle);
    };


    //- ウインドウからのスタイル取得
    function getStyleByWindow(windo, design) {
        // デザインの取得
        if (!design) {
            design = getDesign();
            if (!design) { return; }
        }
        const windowName = windo.constructor.name;
        const finds = design.filter(d => {
            if (d["無効"]) { return false; }
            // 対象ウインドウの判定(カスタムメニュー)
            if (judgeTageWindowCustomMenu(d, windo)) { return true; }
            // 対象ウインドウの判定
            if (judgeTageWindow(d, windo, windowName)) { return true; }
            return false;
        });
        if (!finds.length) { return; }
        // 名前からのスタイル統合
        return uniteStyleByName(finds.map(d => d["適用スタイル"]));
    };
    

    //- 対象ウインドウの判定
    function judgeTageWindow(d, windo, windowName) {
        if (!d["対象ウインドウ"]) { return false; }
        let tages = d["対象ウインドウ"];
        tages = Array.isArray(tages) ? tages : [tages];
        for (let tage of tages) {
            const tageWindow = "Window_" + tage;
            if (d["継承先にも適用"]) {
                if (windo instanceof window[tageWindow]) { return true; }
            } else {
                if (windowName == tageWindow) { return true; }
            }
        };
        return false;
    };


    //- 対象ウインドウの判定(カスタムメニュー)
    function judgeTageWindowCustomMenu(d, windo) {
        if (!d["対象ウインドウC"]) { return false; }
        if (!windo._data) { return false;}
        const windowId = windo._data._parameter ? windo._data._parameter.Id : windo._data.Id;
        if (!windowId) { return; }
        let tages = d["対象ウインドウC"];
        tages = Array.isArray(tages) ? tages : [tages];
        for (let tage of tages) {
            if (windowId == tage) { return true; }
        };
        return false;
    };


    //- シーンからのスタイル取得
    function getStyleByScene(currentScene, design) {
        // デザインの取得
        if (!design) {
            design = getDesign();
            if (!design) { return; }
        }
        if (!currentScene) { currentScene = SceneManager._scene; }
        const sceneName = currentScene.constructor.name;
        const finds = design.filter(d => {
            if (d["無効"]) { return false; }
            // 対象シーンの判定
            if (judgeTageScene(d, currentScene, sceneName)) { return true; }
            // 対象シーンの判定(カスタムメニュー)
            if (judgeTageSceneCustomMenu(d)) { return true; }
        });
        if (!finds.length) { return; }
        // 名前からのスタイル統合
        return uniteStyleByName(finds.map(d => d["適用スタイル"]));
    };


    //- 対象シーンの判定
    function judgeTageScene(d, currentScene, sceneName) {
        if (!d["対象シーン"]) { return false; }
        let tages = d["対象シーン"];
        tages = Array.isArray(tages) ? tages : [tages];
        for (let tage of tages) {
            const tageScene = tage.match(/^Scene_/i) ? tage : "Scene_" + tage;
            if (d["継承先にも適用"]) {
                if (currentScene instanceof window[tageScene]) { return true;}
            } else {
                if (sceneName == tageScene) { return true; }
            }
        }
        return false;
    };


    //- 対象シーンの判定(カスタムメニュー)
    function judgeTageSceneCustomMenu(d) {
        if (!PluginManager._scripts.some(n => n == "SceneCustomMenu") || !d["対象シーンC"]) { return false; }
        let tages = d["対象シーンC"];
        tages = Array.isArray(tages) ? tages : [tages];
        for (let tage of tages) {
            if (SceneManager.isCustomScene(tage)) { return true; }
        }
        return false;
    };


    //- 名前からのスタイル統合
    function uniteStyleByName(styleNames) {
        if (!styleNames || !styleNames.length) { return; }
        const uniStyle = {};
        while(styleNames.length) {
            const styleName = styleNames.shift()
            if (!styleName) { return; }
            const style = getStyle(styleName);
            if (!style) { return; }
            // スタイルの統合
            uniteStyle(uniStyle, style);
        }
        return uniStyle;
    };


    //- スタイルの統合
    function uniteStyle(uniStyle, newStyle) {
        if (!uniStyle && !newStyle) { return; }
        if (!uniStyle) { uniStyle = {}; }
        if (!newStyle) { return uniStyle; }
        Object.keys(newStyle).forEach(key => {
            if (newStyle[key] != null) {
                uniStyle[key] = newStyle[key] == "none" ? null : newStyle[key];
            }
        });
        return uniStyle;
    };


    //- スタイルの取得
    function getStyle(styleName) {
        if (!styleName) { return; }
        return keke_styleList.find(c => c["スタイル名"] == styleName);
    };


    //- デザインの取得
    function getDesign() {
        if (!$gameSystem._designKeMnsk) { $gameSystem._designKeMnsk = keke_startPack; }
        const packName = $gameSystem._designKeMnsk;
        if (packName == "デザインなし") { return; }
        const packId = Number(packName.replace("デザイン", ""));
        return keke_disigns[packId];
    };


    //- デザイン有効か
    function isValidDesign() {
        if (!isValidScene(SceneManager._scene)) { return false; }
        if (!$gameSystem) { return false; }
        const design = $gameSystem._designKeMnsk;
        if (design && design == "デザインなし") { return false; }
        return true;
    };


    //- スキンデータの取得
    function getSkinData(skinName) {
        if (!skinName) { return; }
        let skinData = keke_skinList.find(c => c["スキン名"] == skinName);
        return skinData;
    };


    //- ピクチャデータの取得
    function getPictData(pictName) {
        if (!pictName) { return; }
        let pictData = keke_pictList.find(c => c["ピクチャ名"] == pictName);
        return pictData;
    };


    //- 自動フォント設定取得
    function getFontCfgAuto(windo, isValue) {
        const style = getStyleAuto(windo);
        const word = isValue ? "数字フォント" : "フォント";
        if (!style || !style[word]) { return false; }
        const fontName = style[word];
        return keke_fontList.find(c => c["フォント名"] == fontName);
    };


    //- フォント設定の取得
    function getFontCfg(fontName) {
        return keke_fontList.find(c => c["フォント名"] == fontName);
    };


    //- 背景の取得
    function getBack(backName) {
        // 背景変更の取得
        const backData = getBackChange();
        if (backData == "none") { return null; }
        if (backData) { return backData; }
        return keke_backList.find(c => c["背景名"] == backName);
    };


    //- 背景変更の取得
    function getBackChange() {
        if (!$gameSystem._backChangesKeMnsk) { return null; }
        const changes = $gameSystem._backChangesKeMnsk;
        const designName = $gameSystem._designKeMnsk;
        if (!(changes["全部"] || changes[designName])) { return null; }
        const backName = changes["全部"] || changes[designName];
        if (backName == "none") { return "none"; }
        return keke_backList.find(c => c["背景名"] == backName);
    };


    //- ピクチャパックの取得
    function getPictPack(packName) {
        // ピクチャ変更の取得
        const pictData = getPictChange();
        if (pictData == "none") { return null; }
        if (pictData) { return pictData; }
        return keke_pictPackList.find(c => c["パック名"] == packName);
    };


    //- ピクチャ変更の取得
    function getPictChange() {
        if (!$gameSystem._pictChangesKeMnsk) { return null; }
        const changes = $gameSystem._pictChangesKeMnsk;
        const designName = $gameSystem._designKeMnsk;
        if (!(changes["全部"] || changes[designName])) { return null; }
        const pictPackName = changes["全部"] || changes[designName];
        if (pictPackName == "none") { return "none"; }
        return keke_pictPackList.find(c => c["パック名"] == pictPackName);
    };


    //- BGMの取得
    function getBGM(bgmName) {
        // BGM変更の取得
        const bgmData = getBGMChange();
        if (bgmData == "none") { return null; }
        if (bgmData) { return bgmData; }
        return keke_bgmList.find(c => c["BGM名"] == bgmName);
    };


    //- BGM変更の取得
    function getBGMChange() {
        if (!$gameSystem._bgmChangesKeMnsk) { return null; }
        const changes = $gameSystem._bgmChangesKeMnsk;
        const designName = $gameSystem._designKeMnsk;
        if (!(changes["全部"] || changes[designName])) { return null; }
        const bgmName = changes["全部"] || changes[designName];
        if (bgmName == "none") { return "none"; }
        return keke_bgmList.find(c => c["BGM名"] == bgmName);
    };


    //- アニメ有効か
    function isValidAnime(style, word) {
        if (!word) { return false; }
        let animeNames = style[word];
        if (!animeNames) { return false; }
        if (!Array.isArray(animeNames)) { animeNames = [animeNames]; }
        const valid = keke_animeList.some(d => {
            return animeNames.some(name => d["アニメ名"] == name);
        });
        return valid;
    };


    //- 有効シーンか
    function isValidScene(scene) {
        if (scene.constructor.name.match(/Scene_Map|Scene_Battle/)) { return false; }
        if (scene instanceof Scene_MenuBase) { return true; }
        if (scene instanceof Scene_Message) { return true; }
        return false;
    };



    //==================================================
    //--  スキン
    //==================================================
    
    //- スキンの形成
    function createSkin(x, y, parentW, parentH, skin, windo, style, openAnime, inAnime, option = {}) {
        if (!skin || !skin["画像"]) { return; }
        // ビットマップ形成
        const bitmap = ImageManager.loadPicture(skin["画像"]);
        if (!bitmap) { return { sprite:null }; }
        // スプライト形成
        const sprite = new SpriteKeMnsk(bitmap);
        // スキンフラグ
        sprite._isSkinKe = true;
        // アンカー
        sprite.anchor.x = option.anchorX != null ? option.anchorX : 0.5;
        sprite.anchor.y = option.anchorY != null ? option.anchorY : 0.5;
        // 位置
        sprite._offsetXKe = skin["位置X"] || 0;
        sprite._offsetYKe = skin["位置Y"] || 0;
        sprite.x = x + sprite._offsetXKe + (option.posX != null ? option.posX : 0);
        sprite.y = y + sprite._offsetYKe + (option.posY != null ? option.posY : 0);
        // スケール
        sprite._scaleXKe = (skin["スケールX"] || 1) * (option.scaleX || 1);
        sprite._scaleYKe = (skin["スケールY"] || 1) * (option.scaleY || 1);
        // 固定幅
        if (skin["横幅"]) { parentW = skin["横幅"] || 0; }
        if (skin["高さ"]) { parentH = skin["高さ"] || 0; }
        // 幅の増減
        if (skin["横幅+"]) { parentW += skin["横幅+"]; }
        if (skin["高さ+"]) { parentH += skin["高さ+"]; }
        // 回転角
        sprite._angleKe = (skin["回転角"] || 0) + (option.angle || 0);
        sprite.rotation = angleToRadian(sprite._angleKe);
        // 不透明度
        sprite.opacity = skin["不透明度"] || 255;
        // カラートーン
        const colorTone = strToColorTone(skin);
        if (colorTone) { sprite.setColorTone(colorTone); }
        // サイズを保存
        sprite._widthKe = parentW * sprite._scaleXKe;
        sprite._heightKe = parentH * sprite._scaleYKe;
        // 開始アニメ待機
        if (option.standbyStart) {
            sprite.visible = false;
            sprite._waitStartAnimeKe = 1;
        }
        // 継続アニメ待機
        if (option.standbyIng) {
            sprite._waitIngAnimeKe = 1;
        }
        // ビットマップ読み込み待ち
        bitmap.addLoadListener(() => {
            // スキンの仕上げ
            finishSkin(sprite, bitmap, parentW, parentH, windo, style, openAnime, inAnime, option);
        });
        return sprite
    };


    //- スキンの仕上げ
    function finishSkin(sprite, bitmap, parentW, parentH, windo, style, openAnime, inAnime, option) {
        if (!sprite.transform) { sprite._breakSetupKe = true;  return; }
        // 親のサイズに合わせる
        adjustParentSize(sprite, bitmap, parentW, parentH);
        // スプライトの標準値を保存
        saveSpriteOriVal(sprite);
        // アニメタイプを取得
        const animeType = option.animeType ? "_" + option.animeType : "";
        // アニメの呼び出し-開く
        callAnimeByStyle(sprite, windo, style, openAnime, "start" + animeType, option.animeDelay);
        // アニメの呼び出し-表示中
        callAnimeByStyle(sprite, windo, style, inAnime, "ing" + animeType, option.animeDelay);
        // セットアップ完了フラグ
        sprite._isSetupedKe = true;
    }
    
    
    //- 親のサイズに合わせる
    function adjustParentSize(sprite, bitmap, parentW, parentH) {
        if (parentW) {
            sprite.scale.x = parentW / bitmap.width * sprite._scaleXKe;
        } else {
            sprite.scale.x = parentH / bitmap.height * sprite._scaleXKe;
        }
        if (parentH) {
            sprite.scale.y = parentH / bitmap.height * sprite._scaleYKe;
        } else {
            sprite.scale.y = parentW / bitmap.width * sprite._scaleYKe;
        }
    };
    
    
    //- スプライトの標準値を保存
    function saveSpriteOriVal(sprite) {
        sprite._posXOriKe = sprite.x;
        sprite._posYOriKe = sprite.y;
        sprite._scaleXOriKe = "*" + sprite.scale.x;
        sprite._scaleYOriKe = "*" + sprite.scale.y;
        sprite._angleOriKe = sprite._angleKe || 0;
        sprite._opacityOriKe = "*" + sprite.opacity / 255;
        sprite._colorToneOriKe = sprite._colorTone.concat();
    };


    //- スキンの更新
    function updateSkin(windo) {
        if (!windo._animeSetedKeMnsk) { return; }
        // アニメスプライトの更新
        updateAnimeSprite(windo);
        // ウインドウスキンの可視更新
        updateWindowSkinVisible(windo)
    };
    


    //==================================================
    //--  レクトスキン
    //==================================================

    let setsWindowAnimes = [];

    //- 追加クライアントエリアの作成(コア追加)
    const _Window_Base_createClientArea = Window_Base.prototype._createClientArea;
    Window_Base.prototype._createClientArea = function() {
        if (isValidDesign()) {
            this._clientAreaKeMnsk = new Sprite();
            this._clientAreaKeMnsk.filters = [new PIXI.filters.AlphaFilter()];
            this._clientAreaKeMnsk.move(this._padding, this._padding);
            this._container.addChild(this._clientAreaKeMnsk);
            // ウインドウセレクタブル系のみフィルターエリアを作成
            if (this instanceof Window_Selectable) {
                this._clientAreaKeMnsk.filterArea = new Rectangle();
            }
        }
        _Window_Base_createClientArea.apply(this);
    };


    //- 追加クライアントエリアの更新(コア追加)
    const _Window_Base_updateClientArea = Window.prototype._updateClientArea;
    Window_Base.prototype._updateClientArea = function() {
        _Window_Base_updateClientArea.apply(this);
        if (!this._clientAreaKeMnsk) { return; }
        const pad = this._padding;
        this._clientAreaKeMnsk.move(pad, pad);
        this._clientAreaKeMnsk.x = pad - this.origin.x;
        this._clientAreaKeMnsk.y = pad - this.origin.y;
        if (this.innerWidth > 0 && this.innerHeight > 0) {
            this._clientAreaKeMnsk.visible = this.isOpen();
        } else {
            this._clientAreaKeMnsk.visible = false;
        }
    };


    //- 追加クライアントエリアのフィルター更新(コア追加)
    const _Window_Base_updateFilterArea = Window_Base.prototype._updateFilterArea;
    Window_Base.prototype._updateFilterArea = function() {
        _Window_Base_updateFilterArea.apply(this);
        if (!this._clientAreaKeMnsk) { return; }
        const pos = this._clientAreaKeMnsk.worldTransform.apply(new Point(0, 0));
        const filterArea = this._clientAreaKeMnsk.filterArea;
        if (filterArea) {
            filterArea.x = pos.x + this.origin.x;
            filterArea.y = pos.y + this.origin.y;
            filterArea.width = this.innerWidth;
            filterArea.height = this.innerHeight;
        }
    };


    //- レクトスキンの形成 呼び出し(コア追加)
    const _Window_Selectable_drawBackgroundRect = Window_Selectable.prototype.drawBackgroundRect;
    Window_Selectable.prototype.drawBackgroundRect = function(rect) {
        // レクトスキンの形成
        if (createRectSkin(this, rect)) { return; };
        _Window_Selectable_drawBackgroundRect.apply(this, arguments);
    };


    //- レクトスキンの形成
    function createRectSkin(windo, rect) {
        const scene = SceneManager._scene;
        if (!isValidScene(scene)) { return; }
        let maked = true;
        // 自動スタイル取得
        const style = getStyleAuto(windo);
        if (!style) { return; }
        // スキンデータを取得
        skin = getSkinData(style["スキン"]);
        if (!skin) { return; }
        // 項目の余白を取得
        const padding = windo.itemPadding();
        // アニメを取得
        const openAnime = windo._animeSetedKeMnsk ? "" : "…スキンアニメ";
        // アニメディレイを取得
        const animeDelay = style["…アニメディレイ"] || 0;
        // スキンの形成
        const skinSprite = createSkin(rect.x + padding * 0, rect.y + padding * 0, rect.width, rect.height, skin, windo, style, openAnime, "", { anchorX:0.5, anchorY:0.5, animeDelay:animeDelay });
        if (!skinSprite) { return; }
        skinSprite.x += rect.width / 2;
        skinSprite.y += rect.height / 2;
        // ウインドウにもアニメを適用
        if (isValidAnime(style, openAnime) && !windo._animeSetedKeMnsk) {
            // ウインドウアニメのセット予約
            setsWindowAnimes.push({ windo:windo, style:style, openAnime:openAnime, animeName:"start", animeDelay:animeDelay });
            // アニメセット済みフラグ
            windo._animeSetedKeMnsk = true;
        }
        // チルド
        const cliendArea = windo._clientAreaKeMnsk;
        cliendArea.addChild(skinSprite);
        // 変数セット
        if (!windo._rectSkinsKe) { windo._rectSkinsKe = []; }
        const index = Math.floor((rect.y - windo.rowSpacing() / 2) / windo.itemHeight());
        windo._rectSkinsKe.push({ sprite:skinSprite, x:rect.x, y:rect.y, index:index });
        // レクト描画済みフラグ_1
        //if (!windo._drawedRectKeMnsk) { windo._drawedRectKeMnsk = 1; }
        // レクトスキン作成フラグ
        windo._makedRectSkinKe = true;
        // ウインドウスキンがあったらリムーブ
        if (windo._windowSkinKe) {
            windo._windowSkinKe.parent.removeChild(windo._windowSkinKe);
            windo._windowSkinKe = null;
        }
        // ウインドウのフィルターを削除
        //windo._clientArea.filters = null;
        //windo._clientArea.filterArea = null;
        // カーソルアニメの開始
        startCursorAnime(windo);
        // バックスキンの作成
        makeBackSkin(windo);
        return maked;
    };


    //- レクトスキンの消去 呼び出し(コア追加)
    const _Window_Selectable_clearItem = Window_Selectable.prototype.clearItem;
    Window_Selectable.prototype.clearItem = function(index) {
        _Window_Selectable_clearItem.apply(this, arguments);
        // レクトスキンの消去
        delRectSkin(this, this.itemRect(index));
    };


    //- レクトスキンの消去
    function delRectSkin(windo, rect) {
        if (!windo._rectSkinsKe || !windo._rectSkinsKe.length) { return; }
        let del = false;
        windo._rectSkinsKe.forEach((d, i) => {
            if (d.x == rect.x && d.y == rect.y) {
                // カーソルアニメの消去
                delCursorAnime(windo, d.sprite)
                destroySprite(d.sprite);
                windo._rectSkinsKe[i] = null;
                del = true;
            }
        });
        if (del) {
            windo._rectSkinsKe = windo._rectSkinsKe.filter(d => d);
        }
    };


    //- レクトスキンのクリア 呼び出し(コア追加)
    const _Window_Selectable_paint = Window_Selectable.prototype.paint;
    Window_Selectable.prototype.paint = function() {
        // レクトスキンのクリア
        if (this.contents) {
            clearRectSkin(this);
        }
        _Window_Selectable_paint.apply(this);
        // カーソルが空き部分を差さないようにする
        if (this._index >= this.maxItems()) {
            this._index = Math.max(this._index - 1, 0);
        }
    };


    //- レクト完了フラグのセット
    /*function setRectDrawedFlag(windo, force) {
        if (!isValidDesign()) { return; }
        if (!windo) { return; }
        if (force || windo._drawedRectKeMnsk || !windo.maxItems()) { windo._drawedRectKeMnsk = 2; }
    };*/


    //- レクトスキンのクリア
    function clearRectSkin(windo) {
        if (!windo._rectSkinsKe || !windo._rectSkinsKe.length) { return; }
        windo._rectSkinsKe.forEach(d => {
            destroySprite(d.sprite);
        });
        windo._rectSkinsKe = [];
    };


    //- ウインドウフィルターの無効化
    /*const _Window_Base_updateFilterArea = Window_Base.prototype._updateFilterArea;
    Window_Base.prototype._updateFilterArea = function() {
        if (!this._clientArea.filters) { return; }
        _Window_Base_updateFilterArea.apply(this);
    };*/


    //- ウインドウアニメのセット
    function setWindowAnime(scene) {
        if (!setsWindowAnimes || !setsWindowAnimes.length) { return; }
        setsWindowAnimes.forEach(d => {
            // スプライトの標準値を保存
            saveSpriteOriVal(d.windo);
            // アニメの呼び出し-開く
            callAnimeByStyle(d.windo, d.windo, d.style, d.openAnime, d.animeName, d.animeDelay);
        });
        setsWindowAnimes = [];
    };



    //==================================================
    //--  ウインドウスキン
    //==================================================

    //- ウインドウスキンの形成 呼び出し(コア追加)
    const _Window_Base_createContents = Window_Base.prototype.createContents;
    Window_Base.prototype.createContents = function() {
        _Window_Base_createContents.apply(this);
        // ウインドウスキンの形成
        createWindowSkin(this);
    };


    //- ウインドウスキンの形成
    function createWindowSkin(windo) {
        if (!isValidDesign()) { return; }
        // レクトスキン描画済みならリターン
        if (windo._makedRectSkinKe) { return; }
        // すでにスキンがあったら破棄
        if (windo._windowSkinKe) {
            windo._windowSkinKe.parent.removeChild(windo._windowSkinKe);
            windo._windowSkinKe = null;
        }
        // 自動スタイル取得
        const style = getStyleAuto(windo);
        if (!style) { return; }
        // スキンデータを取得
        skin = getSkinData(style["スキン"]);
        if (!skin) { return; }
        // アニメを取得
        const openAnime = windo._animeSetedKeMnsk ? "" : "…スキンアニメ";
        // アニメディレイを取得
        const animeDelay = style["…アニメディレイ"] || 0;
        // ウインドウにアニメを適用
        if (isValidAnime(style, openAnime) && !windo._animeSetedKeMnsk) {
            // ウインドウアニメのセット予約
            setsWindowAnimes.push({ windo:windo, style:style, openAnime:openAnime, animeName:"start", animeDelay:animeDelay });
            // アニメセット済みフラグ
            windo._animeSetedKeMnsk = true;
        }
        // ウインドウのフィルターを削除
        //windo._clientArea.filters = null;
        //windo._clientArea.filterArea = null;
        //- ウインドウスキンの形成2
        setTimeout(createWindowSkin2, 0, windo, style, skin, openAnime, animeDelay);
        // バックスキンの作成
        makeBackSkin(windo);
    };


    //- ウインドウスキンの形成2
    function createWindowSkin2(windo, style, skin, openAnime, animeDelay) {
        // レクトスキン描画済みならリターン
        if (windo._makedRectSkinKe) { return; }
        // ウインドウの大きさを取得
        let width = windo.innerWidth;
        const height = windo.innerHeight;
        const padding = $gameSystem.windowPadding();
        // スキンの形成
        const skinSprite = createSkin(0 + padding * 0, 0 + padding * 0, width, height, skin, windo, style, openAnime, "", { anchorX:0.5, anchorY:0.5, animeDelay:animeDelay });
        if (!skinSprite) { return; }
        skinSprite.x += width / 2;
        skinSprite.y += height / 2;
        // チルド
        windo._clientAreaKeMnsk.addChild(skinSprite);
        // 変数セット
        windo._windowSkinKe = skinSprite;
    };


    //- ウインドウスキンの可視更新
    function updateWindowSkinVisible(windo) {
        if (!windo._windowSkinKe) { return; }
        // ウインドウコマンドの場合
        if (windo instanceof Window_Command) {
            // コマンドがあるなら見える化
            if (windo.maxItems()) {
                windo._windowSkinKe.visible = true;
            } else {
                windo._windowSkinKe.visible = false;
            }
        // ウインドウセレクタブルの場合
        } else if (windo instanceof Window_Selectable) {
            if (windo._drawedTextKeMnsk || (windo.contents && windo.contents._url)) {
                windo._windowSkinKe.visible = true;
            } else {
                windo._windowSkinKe.visible = false;
            }
        }
    };


    //- テキスト描画時済みフラグのオン(コア追加)
    const _Window_Selectable_drawText = Window_Selectable.prototype.drawText;
    Window_Selectable.prototype.drawText = function(text, x, y, maxWidth, align) {
        _Window_Selectable_drawText.apply(this, arguments);
        // テキスト描画済みフラグをセット
        this._drawedTextKeMnsk　= true;
    };

    const _Window_Selectable_drawTextEx = Window_Selectable.prototype.drawTextEx;
    Window_Selectable.prototype.drawTextEx = function(text, x, y, maxWidth, align) {
        _Window_Selectable_drawTextEx.apply(this, arguments);
        // テキスト描画済みフラグをセット
        this._drawedTextKeMnsk　= true;
    };

    const _Window_Selectable_drawIcon = Window_Selectable.prototype.drawIcon;
    Window_Selectable.prototype.drawIcon = function(iconIndex, x, y) {
        _Window_Selectable_drawIcon.apply(this, arguments);
        // テキスト描画済みフラグをセット
        this._drawedTextKeMnsk　= true;
    };

    const _Window_Selectable_drawFace = Window_Selectable.prototype.drawFace;
    Window_Selectable.prototype.drawFace = function(faceName, faceIndex, x, y, width, height) {
        _Window_Selectable_drawFace.apply(this, arguments);
        // テキスト描画済みフラグをセット
        this._drawedTextKeMnsk　= true;
    };

    const _Window_Selectable_drawCharacter = Window_Selectable.prototype.drawCharacter;
    Window_Selectable.prototype.drawCharacter = function(characterName, characterIndex, x, y) {
        _Window_Selectable_drawCharacter.apply(this, arguments);
        // テキスト描画済みフラグをセット
        this._drawedTextKeMnsk　= true;
    };

    const _Window_Selectable_drawItemName = Window_Selectable.prototype.drawItemName;
    Window_Selectable.prototype.drawItemName = function(item, x, y, width) {
        _Window_Selectable_drawItemName.apply(this, arguments);
        // テキスト描画済みフラグをセット
        this._drawedTextKeMnsk　= true;
    };

    const _Window_Selectable_drawCurrencyValue = Window_Selectable.prototype.drawCurrencyValue;
    Window_Selectable.prototype.drawCurrencyValue = function(value, unit, x, y, width) {
        _Window_Selectable_drawCurrencyValue.apply(this, arguments);
        // テキスト描画済みフラグをセット
        this._drawedTextKeMnsk　= true;
    };


    //- テキスト描画時済みフラグの解除(コア追加)
    const _Window_Selectable_refresh = Window_Selectable.prototype.refresh;
    Window_Selectable.prototype.refresh = function(text, x, y, maxWidth, align) {
        // テキスト描画済みフラグを解除
        this._drawedTextKeMnsk　= false;
        _Window_Selectable_refresh.apply(this, arguments);
    };



    //==================================================
    //--  バックスキン
    //==================================================

    //- バックスキンの作成
    function makeBackSkin(windo) {
        if (!isValidDesign() || windo._drawedBackSkinKe) { return; }
        // 自動スタイル取得
        const style = getStyleAuto(windo);
        if (!style) { return; }
        // バックスキンの形成
        createBackSkin(windo, style);
        // バックの塗りつぶし
        fillBack(windo, style);
        // バックスキン描画済みフラグ
        windo._drawedBackSkinKe = true;
        // ウインドウを手前へ
        setTimeout(windowToFront, 0, windo, style);
    };


    //- バックスキンの形成
    function createBackSkin(windo, style) {
        const backSkin = getSkinData(style["バックスキン"]);
        if (!backSkin) { return; }
        const w = windo.width;
        const h = windo.height;
        const padding =  $gameSystem.windowPadding();
        // スキンの形成
        const skinSprite = createSkin(-padding, -padding, w, h, backSkin, windo, style, "", "", { anchorX:0.5, anchorY:0.5 });
        if (!skinSprite) { return; }
        skinSprite.x += w / 2 + windo._padding;
        skinSprite.y += h / 2 + windo._padding;
        // チルド
        windo._container.addChildAt(skinSprite, 0);
        // 変数セット
        //windo._backSkinSpriteKe = skinSprite;
    };


    //- バックの塗りつぶし
    function fillBack(windo, style) {
        const backColor = style["バック塗り"];
        if (!backColor) { return; }
        const w = windo.width;
        const h = windo.height;
        // 形成
        const bitmap = new Bitmap(w, h);
        bitmap.fillRect(0, 0, w, h, backColor);
        const sprite = new SpriteKeMnsk(bitmap);
        // 位置
        sprite.x = 0;
        sprite.y = 0;
        // チルド
        windo._container.addChildAt(sprite, 0);
        // 変数セット
        //windo._openBackSpriteKe = sprite;
    };


    //- ウインドウを手前へ
    function windowToFront(windo, style) {
        if (!style["手前に表示"]) { return; }
        SceneManager._scene.addChild(windo);
    };


    
    //==================================================
    //--  カーソルスキン
    //==================================================

    //- カーソルの形成 呼び出し(コア追加)
    const _Window_Base_createCursorSprite = Window_Base.prototype._createCursorSprite;
    Window_Base.prototype._createCursorSprite = function() {
        _Window_Base_createCursorSprite.apply(this);
        // カーソルの形成
        createCursor(this);
    };


    //- カーソルの形成
    function createCursor(windo) {
        if (!isValidDesign()) { return; }
        // カーソルスプライトの形成
        const cursorSprite = createCursorSprite(windo);
        if (!cursorSprite) { return false; }
        // チルド
        windo._clientArea.addChild(cursorSprite);
        // 変数セット
        windo._cursorSpriteKe = cursorSprite;
        return true;
    };


    //- カーソルスプライトの形成
    function createCursorSprite(windo) {
        // 自動スタイル取得
        const style = getStyleAuto(windo);
        if (!style) { return; }
        let cursorSprite = null;
        // カーソル非表示
        const cursorSkin = getSkinData(style["カーソルスキン"]);
        const skinData = getSkinData(style["スキン"]);
        const onCursorAnime = skinData && skinData["画像"] && (style["カーソルアニメ-開始"] || style["カーソルアニメ"]);
        if (cursorSkin || onCursorAnime) {
            windo._cursorSprite._isNoneKe = true;
        }
        // 表示
        if (cursorSkin) {
            cursorSprite = createSkin(0, 0, 0, 0, cursorSkin, windo, style, "", "", { anchorX:0.5, anchorY:0.5 });
        }
        return cursorSprite;
    };


    //- カーソルのリフレッシュ 呼び出し(コア追加)
    const _Window_Base_refreshCursor = Window_Base.prototype._refreshCursor;
    Window_Base.prototype._refreshCursor = function() {
        // カーソルのリフレッシュ
        if (refreshCursor(this, this._cursorSpriteKe)) { return; }
        _Window_Base_refreshCursor.apply(this);
    };


    //- カーソルのリフレッシュ
    function refreshCursor(windo, cursor) {
        if (!cursor) { return false; }
        const rect = windo._cursorRect;
        if (cursor.bitmap) {
            cursor.bitmap.addLoadListener(() => {
                const frame = cursor._frame;
                cursor.scale.x = (rect.width / frame.width) * cursor._scaleXKe;
                cursor.scale.y = (rect.height / frame.height) * cursor._scaleYKe;
            });
        }
        return true;
    };


    //- カーソルの更新 呼び出し(コア追加)
    const _Window_Selectable_updateCursor = Window_Selectable.prototype._updateCursor;
    Window_Selectable.prototype._updateCursor = function() {
        _Window_Selectable_updateCursor.apply(this);
        // カーソルの更新
        updateCursor(this);
    };


    //- カーソルの更新
    function updateCursor(windo) {
        // 標準カーソル
        const defoCursor = windo._cursorSprite;
        if (defoCursor._isNoneKe) {
            const del = windo.maxItems() || (windo.constructor.name == "Window_ShopNumber" && windo._makedRectSkinKe);
            if (del) { defoCursor.visible = false; } else
            { defoCursor.visible = true; }
        }
        // 独自カーソル
        if (!windo._cursorSpriteKe) { return false; }
        const cursor = windo._cursorSpriteKe;
        cursor.alpha = windo._makeCursorAlpha();
        cursor.visible = windo.isOpen() && windo.cursorVisible;
        const rect = windo._cursorRect;
        // 全体カーソル
        if (windo._cursorAll) {
            cursor.x = windo.innerWidth / 2;
            cursor.y = windo.innerHeight / 2;
        // 通常カーソル
        } else {
            cursor.x = rect.x + rect.width / 2;
            cursor.y = rect.y + rect.height / 2;
        }
        return true;
    };


    //- 全体カーソルのリフレッシュ 呼び出し(コア追加)
    const _Window_Selectable_refreshCursorForAll = Window_Selectable.prototype.refreshCursorForAll;
    Window_Selectable.prototype.refreshCursorForAll = function() {
        //if (refreshCursorAll(this, this._cursorSpriteKe)) { return; }
        _Window_Selectable_refreshCursorForAll.apply(this);
    };


    //- 全体カーソルのリフレッシュ
    function refreshCursorAll(windo, cursor) {
        if (!cursor) { return false;}
        if (cursor.bitmap) {
            cursor.bitmap.addLoadListener(() => {
                const frame = cursor._frame;
                cursor.scale.x = (windo.innerWidth / frame.width) * cursor._scaleXKe;
                cursor.scale.y = (windo.innerHeight / frame.height) * cursor._scaleYKe;
            });
        }
        return true;
    };


    //- 全体カーソルの処理 呼び出し(コア追加)
    const _Window_Selectable_setCursorAll = Window_Selectable.prototype.setCursorAll;
    Window_Selectable.prototype.setCursorAll = function(cursorAll) {
        _Window_Selectable_setCursorAll.apply(this, arguments);
        // 全体カーソルの処理
        processAllCursor(this, cursorAll)
    };


    //- 全体カーソルの処理
    function processAllCursor(windo, cursorAll) {
        // 全体カーソルセット時
        if (cursorAll) {
            // 全体カーソルのリフレッシュ
            refreshCursorAll(windo, windo._cursorSpriteKe)
        // 解除時
        } else {
            // カーソルのリフレッシュ
            refreshCursor(windo, windo._cursorSpriteKe)
        }
        // カーソルアニメの全停止
        stopCursorAnimeAll(windo);
    };



    //==================================================
    //--  カーソルアニメ
    //==================================================

    //- カーソルアニメの開始 呼び出し(コア追加)
    const _Window_Selectable_setCursorRect = Window_Selectable.prototype.setCursorRect;
    Window_Selectable.prototype.setCursorRect = function(x, y, width, height) {
        _Window_Selectable_setCursorRect.apply(this, arguments);
        // カーソルアニメの開始
        if (inSceneInit) {
            setTimeout(startCursorAnime, 100, this);
        } else {
            startCursorAnime(this);
        }
    };


    //- カーソルアニメの開始
    function startCursorAnime(windo, skinSprite) {
        if (!windo._rectSkinsKe || !windo._rectSkinsKe.length) { return; }
        if (!windo._inCursorAnimeSpritesKe) { windo._inCursorAnimeSpritesKe = []; }
        // 自動スタイル取得
        const style = getStyleAuto(windo);
        if (!style) { return; }
        // カーソルアニメを取得
        const cursorAnimeStart = "カーソルアニメ-開始"
        const cursorAnime = "カーソルアニメ";
        if (!isValidAnime(style, cursorAnime) && !isValidAnime(style, cursorAnimeStart)) { return; }
        // 現在のレクトを取得
        const rect = windo.itemRect(windo.index());
        // 対象スキンを取得
        if (!skinSprite) {
            const rectSkins = windo._rectSkinsKe;
            const skin = rectSkins.find(skin => skin.x == rect.x && skin.y == rect.y);
            if (!skin) { return;} 
            skinSprite = skin.sprite;
        }
        // すでにカーソルアニメ中ならリターン
        if (windo._inCursorAnimeSpritesKe.some(s => s == skinSprite)) { return; }
        // セットアップ未完了時
        if (!skinSprite._isSetupedKe) {
            if (skinSprite._breakSetupKe) { return; }
            setTimeout(startCursorAnime, 100, windo);
            return;
        }
        // カーソルアニメの全停止
        stopCursorAnimeAll(windo);
        // 対象スキンを取得
        const tageSkins = windo._cursorAll ? windo._rectSkinsKe.map(d => d.sprite) : [skinSprite];
        tageSkins.forEach(sprite => {
            // アニメの呼び出し-開始
            callAnimeByStyle(sprite, windo, style, cursorAnimeStart, getCursorAnimeType(windo, style, true));
            // アニメの呼び出し-表示中
            callAnimeByStyle(sprite, windo, style, cursorAnime, getCursorAnimeType(windo, style));
            // カーソルアニメ中スプライトとしてセット
            if (!windo._inCursorAnimeSpritesKe.some(s => s == sprite)) {
                windo._inCursorAnimeSpritesKe.push(sprite);
            }
        });
        return skinSprite;
    };


    //- カーソルアニメタイプの取得
    function getCursorAnimeType(windo, style, isStart) {
        let type = isStart ? "cursor_start" : "cursor_noEnd";
        if (style["…カラートーン補正"]) {
            type += "_opa" + style["…カラートーン補正"];
        }
        return type;
    };


    //- カーソルアニメの全停止
    function stopCursorAnimeAll(windo) {
        if (!windo._inCursorAnimeSpritesKe || !windo._inCursorAnimeSpritesKe.length) { return; }
        windo._inCursorAnimeSpritesKe.forEach(sprite => {
            // アニメの停止
            stopAnime(sprite, "", true);
            // スプライト標準値の復帰
            restoreSpriteOriVar(sprite);
        });
        windo._inCursorAnimeSpritesKe = [];
    };


    //- カーソルアニメの消去
    function delCursorAnime(windo, skinSprite) {
        if (!windo._inCursorAnimeSpritesKe || !windo._inCursorAnimeSpritesKe.length) { return; }
        windo._inCursorAnimeSpritesKe.remove(skinSprite);
    };


    //- カーソルアニメの更新
    function updateCursorAnime(sprite, windo, drift) {
        const animeType = drift.animeType;
        if (!animeType.includes("cursor") || !(windo instanceof Window_Base)) { return false; }
        // ウインドウが非アクティブ時の処理
        if (!windo.active) {
            const rect = windo._cursorRect;
            // カーソル表示なしなら
            if (!rect || !rect.width) {
                // カーソルアニメの全停止
                stopCursorAnimeAll(windo);
            // 開始アニメ中なら何もしない
            } else if (animeType.includes("start")) {
                // カーソルアニメの全停止
                //stopCursorAnimeAll(windo, animeType);
                //updateAnimeStart(sprite, windo, true);
            // 表示中ならストップ
            } else　{
                return true;
            } 
        }
        return false;
    };


    // 並べ替えカーソル色(コア追加)
    const _ColorManager_pendingColor = ColorManager.pendingColor;
    ColorManager.pendingColor = function() {
        // シーンからのスタイル取得
        const style = getStyleByScene(SceneManager._scene);
        if (style && style["並べ替えカーソル色"]) {
            return style["並べ替えカーソル色"];
        }
        return _ColorManager_pendingColor.apply(this);
    };


    //- 並べ替えカーソルの丸み描画 呼び出し(コア追加)
    const _Window_MenuStatus_drawPendingItemBackground = Window_MenuStatus.prototype.drawPendingItemBackground;
    Window_MenuStatus.prototype.drawPendingItemBackground = function(index) {
        // 並べ替えカーソルの描画
        if (drawPendingCursorRound(this, index)) {
            return; 
        };
        _Window_MenuStatus_drawPendingItemBackground.apply(this, arguments);
    };


    //- 並べ替えカーソルの丸み描画
    function drawPendingCursorRound(windo, index) {
        if (index != windo._pendingIndex) { return false; }
        // シーンからのスタイル取得
        const style = getStyleByScene(SceneManager._scene);
        if (!style || !style["並べ替えカーソル丸み"]) { return false; }
        // 描画
        let rounds = style["並べ替えカーソル丸み"];
        rounds = Array.isArray(rounds) ? rounds : [rounds];
        const edgeRound = Math.abs(rounds[0] || 0);
        const lineRound = Math.abs(rounds[1] || 0);
        const rect = windo.itemRect(index);
        const color = ColorManager.pendingColor();
        windo.changePaintOpacity(false);
        fillSquare(windo.contents, rect.x, rect.y, rect.width, rect.height, color, lineRound, edgeRound);
        windo.changePaintOpacity(true);
        return true;
    };



    //==================================================
    //--  ウインドウ消す
    //==================================================

    //- ウインドウの消去
    function eraseWindow(windo) {
        if (!isValidDesign()) { return; }
        // 自動スタイル取得
        const style = getStyleAuto(windo);
        if (!style) { return; }
        if (style["ウインドウ消す"]) {
            windo._frameSprite.opacity = 0;
            windo._backSprite.opacity = 0;
            windo._windowNoVisibleKe = true;
        }
    };


    //- ウインドウ開き率の更新
    function updateWindowOpenness(windo) {
        return;
        if (!windo._windowNoVisibleKe) { return; }
        if (windo.openness > 0 && windo.openness < 255) {
            windo._backSprite.opacity = windo.openness;
        } else {
            windo._backSprite.opacity = 0;
        }
    };



    //==================================================
    //--  ヘルプウインドウの可視状態更新
    //==================================================
    
    // ヘルプの可視更新 呼び出し(コア追加)
    const _Window_Help_update = Window_Help.prototype.update;
    Window_Help.prototype.update = function(rect) {
        _Window_Help_update.apply(this, arguments);
        // ヘルプの可視更新
        updateHelpVisible(this);
    };


    // ヘルプの可視更新
    function updateHelpVisible(windo) {
        if (!isValidDesign() || !windo._windowSkinKe) { return; }
        if (windo._text) {
            windo.visible = true;
        } else {
            windo.visible = false;
        }
    };



    //==================================================
    //--  背景
    //==================================================

    let backAnimeSeted = false;

    //- 背景の形成
    function createBack(scene) {
        // シーンからのスタイル取得
        const style = getStyleByScene(scene);
        if (!style) { return false; }
        // 背景の取得
        const back = getBack(style["背景"]);
        if (!back) { return false; }
        // 背景変更されたらアニメ初期化
        if ($gameTemp._currentBackKeMnsk && $gameTemp._currentBackKeMnsk != back["背景名"]) {
            $gameTemp._currentBackKeMnsk = null;
            $gameTemp._backPossKeMnsk = null;
        }
        // 背景位置の初期化
        if (!$gameTemp._backPossKeMnsk) { initBackPoss(); }
        scene._backSkinsKe = [];
        const gw = Graphics.width;
        const gh = Graphics.height;
        const moveX = back["移動X"] || 0;
        const moveY = back["移動Y"] || 0
        // 移動がない場合
        if (!moveX && !moveY) {
            createBackEach(scene, back, style, 0, 0, 0, 0, moveX, moveY);
        // X移動だけある場合
        } else if (moveX && !moveY) {
            for (let i = 0; i < 3; i++) {
                const x = -gw + gw * i;
                const scaleX = i % 2 == 0 ? -1 : 1;
                createBackEach(scene, back, style, i, 0, x, 0, moveX, moveY, scaleX);
            }
        // Y移動だけある場合
        } else if (!moveX && moveY) {
            for (let j = 0; j < 3; j++) {
                const y = -gh + gh * j;
                const scaleY = j % 2 == 0 ? -1 : 1;
                createBackEach(scene, back, style, 0, j, 0, y, moveX, moveY, 1, scaleY);
            }
        // XY移動する場合
        } else {
            for (let i = 0; i < 3; i++) {
                for (let j = 0; j < 3; j++) {
                    const x = -gw + gw * i;
                    const y = -gh + gh * j;
                    const scaleX = i % 2 == 0 ? -1 : 1;
                    const scaleY = j % 2 == 0 ? -1 : 1;
                    createBackEach(scene, back, style, i, j, x, y, moveX, moveY, scaleX, scaleY);
                }
            }
        }
        // 現在のアニメ名を保存
        $gameTemp._currentBackKeMnsk = back["背景名"];
        // 背景アニメ済みフラグ
        if (backAnimeSeted) {
            $gameTemp._backAnimedKeMnsk = true;
            backAnimeSeted = false;
        }
        return true;
    };


    //- 背景の形成-個別
    function createBackEach(scene, back, style, i, j, x, y, moveX = 0, moveY = 0, scaleX = 1, scaleY = 1) {
        // 名前を取得
        const name = `${i}:${j}`;
        // 現在位置変数を取得
        if (!$gameTemp._backPossKeMnsk[name]) { $gameTemp._backPossKeMnsk[name] = { x:0, y:0, scaleX:0, scaleY:0 }; }
        const poss = $gameTemp._backPossKeMnsk[name] || {};
        // 現在スケールを取得
        if (poss.scaleX) {
            scaleX = poss.scaleX < 0 ? -1 : 1;
            scaleY = poss.scaleY < 0 ? -1 : 1;
        }
        // アニメを取得
        const openAnime = $gameTemp._backAnimedKeMnsk ? "" : "…背景アニメ";
        // アニメ済みフラグ
        if (isValidAnime(style, openAnime)) {
            backAnimeSeted = true;
        }
        // スキンの形成
        const backSkin = createSkin(0, 0, Graphics.width, Graphics.height, back, scene, style, openAnime, "", { anchorX:0.5, anchorY:0.5, scaleX:scaleX, scaleY:scaleY, animeType:"scaleMirror" });
        if (!backSkin) { return; }
        // 名前をセット
        backSkin._nameKe = name;
        // 現在位置を適用
        backSkin.x = poss.x ? poss.x : x + Graphics.width / 2;
        backSkin.y = poss.y ? poss.y : y + Graphics.height / 2;
        // 移動量をセット
        backSkin._moveXKe = moveX;
        backSkin._moveYKe = moveY;
        backSkin._movedXKe = 0;
        backSkin._movedYKe = 0;
        // チルド
        scene.addChild(backSkin);
        // 変数セット
        scene._backSkinsKe.push(backSkin);
    };
    

    //- 標準の背景無効化に伴う処理(コア追加)
    const _Scene_MenuBase_setBackgroundOpacity = Scene_MenuBase.prototype.setBackgroundOpacity;
    Scene_MenuBase.prototype.setBackgroundOpacity = function(opacity) {
        if (!this._backgroundSprite) { return; }
        _Scene_MenuBase_setBackgroundOpacity.apply(this, arguments);
    };


    //- 背景の更新
    function updateBack(scene) {
        if (!scene._backSkinsKe || !scene._backSkinsKe.length || !$gameTemp._backPossKeMnsk) { return; }
        const gw = Graphics.width;
        const gh = Graphics.height;
        scene._backSkinsKe.forEach((back, i) => {
            const name = back._nameKe;
            // 現在位置変数を取得
            const poss = $gameTemp._backPossKeMnsk[name] || {};
            const moveX = back._moveXKe;
            const moveY = back._moveYKe;
            if (moveX) {
                back.x += moveX;
                // 横ループ
                if (moveX < 0 && back.x <= -gw * 0.5) {
                    back.x += gw * 3;
                    back.scale.x *= -1;
                    reverseScaleAnime(back, "X");
                } else if (moveX > 0 && back.x >= gw * 1.5) {
                    back.x -= gw * 3;
                    back.scale.x *= -1;
                    reverseScaleAnime(back, "X");
                }
                // 現在位置を保存
                poss.x = back.x;
                poss.scaleX = back.scale.x;
            }
            if (moveY) {
                back.y += moveY;
                // 縦ループ
                if (moveY < 0 && back.y <= -gh * 0.5) {
                    back.y += gh * 3;
                    back.scale.y *= -1;
                    reverseScaleAnime(back, "Y");
                } else if (moveY > 0 && back.y >= gh * 1.5) {
                    back.y -= gh * 3;
                    back.scale.y *= -1;
                    reverseScaleAnime(back, "Y");
                }
                // 現在位置を保存
                poss.y = back.y;
                poss.scaleY = back.scale.y;
            }
        });
    };


    //- スケールアニメの反転
    function reverseScaleAnime(sprite, xy) {
        if (!sprite._animationsKe || !sprite._animationsKe.length) { return; }
        sprite._animationsKe.forEach(drift => {
            if (!drift["scale" + xy + "s"]) { return; }
            const ds = drift["scale" + xy + "s"];
            ds.forEach(d => {
                d.current *= -1;
                d.start *= -1;
                d.target *= -1;
                d.end *= -1;
                d.vol *= -1;
            });
            sprite["_scale" + xy + "OriKe"] *= -1;
            sprite["_scale" + xy + "Ke"] *= -1;
        });
    };
    
    
    //- 背景位置の初期化
    function initBackPoss() {
        $gameTemp._backPossKeMnsk = {};
    };


    //- 背景の初期化
    function initBack() {
        // 背景位置の初期化
        initBackPoss();
        // 各種フラグを解除
        $gameTemp._currentBackKeMnsk = null;
        $gameTemp._backAnimedKeMnsk = null;
    };



    //==================================================
    //--  ピクチャ
    //==================================================

    //- ピクチャの形成
    function createPicture(scene) {
        // シーンからのスタイル取得
        const style = getStyleByScene(scene);
        if (!style) { return false; }
        // ピクチャパックの取得
        const pictPack = getPictPack(style["ピクチャパック"]);
        if (!pictPack) { return false; }
        // ピクチャ変更されたらアニメ初期化
        if ($gameTemp._pictAnimedKeMnsk && $gameTemp._pictAnimedKeMnsk != pictPack["パック名"]) {
            $gameTemp._pictAnimedKeMnsk = null;
        }
        // ピクチャリストを取得
        const picts = pictPack["ピクチャリスト"];
        if (!picts || !picts.length) { return; }
        // データを全て処理
        picts.forEach(pict => {
            // ピクチャの形成-個別
            createPictureEach(style, pict, scene);
        });
        // ピクチャアニメ済みフラグ
        $gameTemp._pictAnimedKeMnsk = pictPack["パック名"];
    };


    // ピクチャの形成-個別
    function createPictureEach(style, pict, scene) {
        if (pict["無効"]) { return; }
        // スキンデータを取得
        const skin = getPictData(pict["使用ピクチャ"]);
        if (!skin) { return; }
        // 原点
        const anchorX = pict["原点X"]　!= null ? pict["原点X"] : 0.5;
        const anchorY = pict["原点Y"] != null ? pict["原点Y"] : 0.5;
        // 位置
        const posX = pict["位置X"] || 0;
        const posY = pict["位置Y"] || 0;
        let x = posX;
        let y = posY;
        // テキスト
        const text = pict["ピクチャテキスト"];
        const fontName = pict["…フォント"] || style["フォント"];
        const font = getFontCfg(fontName);
        const fontSize = getFontSize(font["文字サイズ"]);
        const ow = font["縁取り幅"];
        const lineSpace = 8;
        let textW = 0;
        let textH = 0;
        let textWTotal = 0;
        let textHTotal = 0;
        if (text) {
            textW = getTextWidth(text, fontSize, fontSize);
            textH = getTextHeight(text, fontSize, fontSize, lineSpace);
            textWTotal = textW + ow * 2;
            textHTotal = textH + ow * 2;
        }
        // サイズ
        const wo = pict["横幅"] == "gw" ? Graphics.width : pict["横幅"];
        const ho = pict["高さ"] == "gh" ? Graphics.height : pict["高さ"];
        const w = wo || textWTotal;
        const h = ho || textHTotal;
        // 位置寄せX
        const alignX = pict["位置寄せX"];
        if (alignX && alignX != "寄せない") {
            const totalW = w * Math.abs(skin["スケールX"] || 1);
            if (alignX == "左寄せ") {
                const left = totalW * anchorX;
                x = left;
            } else if (alignX == "中央寄せ") {
                const center = totalW * (0.5 - anchorX);
                x = Graphics.width / 2 - center;
            } else if (alignX === "右寄せ") {
                const right = totalW * (1 - anchorX);
                x = Graphics.width - right;
            }
            x += posX;
        }
        // 位置寄せY
        const alignY = pict["位置寄せY"];
        if (alignY && alignY != "寄せない") {
            const totalH = h * Math.abs(skin["スケールY"] || 1);
            if (alignY == "上寄せ") {
                const up = totalH * anchorY;
                y = up;
            } else if (alignY == "中央寄せ") {
                const center = totalH * (0.5 - anchorY);
                y = Graphics.height / 2 - center;
            } else if (alignY === "下寄せ") {
                const down = totalH * (1 - anchorY);
                y = Graphics.height - down;
            }
            y += posY
        }
        // アニメ
        const openAnime = ($gameTemp._pictAnimedKeMnsk && !pict["…再アニメ"]) ? "" : "開始アニメ";
        const ingAnime = "表示中アニメ";
        // スキンの形成
        const pictSprite = createSkin(x, y, w, h, skin, scene, pict, openAnime, ingAnime, { anchorX:anchorX, anchorY:anchorY, animeDelay:0 });
        if (!pictSprite) { return; }
        // レイヤー
        const layer = pict["レイヤー"];
        // チルド
        if (layer == "下層") { scene.addChild(pictSprite) } else 
        { childPict(scene, pictSprite);  setTimeout(childPict, 0, scene, pictSprite); }
        // 変数セット
        if (!scene._pictsKeMnsk) { scene._pictsKeMnsk = []; }
        scene._pictsKeMnsk.push(pictSprite);
        // テキストを作成
        let textSprite = null;
        if (text) {
            // スプライト形成
            const textBitmap = new Bitmap(textWTotal, textHTotal);
            textSprite = new SpriteKeMnsk(textBitmap);
            // 基本のフォント設定
            fontSettingBasic(textBitmap, fontSize);
            // スタイルに応じたフォント設定
            fontSettingByStyle(textBitmap, font, "");
            // テキストの読み取り描画
            drawTextLoading(textSprite, textBitmap, text, ow, ow, textW, textH, 0, fontSize, fontSize, 1, lineSpace);
            // チルド
            if (layer == "下層") { scene.addChild(textSprite) } else 
            {  childPict(scene, pictSprite);  setTimeout(childPict, 0, scene, textSprite); }
            // アンカー
            textSprite.anchor.x = anchorX;
            textSprite.anchor.y = anchorY;
            // 位置
            textSprite.x = (pictSprite._posXOriKe || pictSprite.x) - pictSprite._offsetXKe;
            textSprite.y = (pictSprite._posYOriKe || pictSprite.y) - pictSprite._offsetYKe;
            // スプライトの標準値を保存
            saveSpriteOriVal(textSprite);
            // アニメの呼び出し-開始
            callAnimeByStyle(textSprite, scene, pict, openAnime, "start");
            // ピクチャに変数セット
            pictSprite._textSpriteKe = textSprite;
        }
        // 連動ウインドウをセット
        if (pict["連動ウインドウ"]) {
            pictSprite._synchroWindowNameKe = "Window_" + pict["連動ウインドウ"];
            pictSprite.visible = false;
            if (textSprite) { textSprite.visible = false; }
        }
        // 有効シーンの判定
        if (pict["有効シーン"]) {
            const okScene = pict["有効シーン"];
            const tageScenes = Array.isArray(okScene) ? okScene.map(s => s.match(/^Scene_/i) ? s : "Scene_" + s) : "Scene" + okScene;
            if (!tageScenes.some(sceneName => scene.constructor.name == sceneName)) {
                // ピクチャの見えない化
                pictToNoVisible(pictSprite, "validScene");    
            }
        }
        // 表示条件をセット
        if (pict["表示条件"]) {
            pictSprite._showConditionKe = copyHash(pict["表示条件"]);
            // ピクチャ表示の判定
            judgePictShow(pictSprite);
        }
    };


    //- 基本のフォント設定
    function fontSettingBasic(bitmap, fontSize) {
        bitmap.fontFace = $gameSystem.mainFontFace();
        bitmap.fontSize = fontSize || $gameSystem.mainFontSize();
    };


    //- ピクチャのチルド
    function childPict(scene, pictSprite) {
        if (!scene || !pictSprite) { return;}
        scene.addChild(pictSprite);
    };


    //- ピクチャの更新
    function updatePict(scene) {
        if (!scene._pictsKeMnsk || !scene._pictsKeMnsk.length) { return; }
        // ピクチャを全て処理
        scene._pictsKeMnsk.forEach(pictSprite => {
            // ピクチャの可視状態の更新
            updatePictVisible(pictSprite);
        });
    };


    //- ピクチャの可視状態の更新
    function updatePictVisible(pictSprite) {
        if (!pictSprite._noVisiblesKe || !pictSprite._noVisiblesKe.length) {
            pictSprite.visible = true;
            if (pictSprite._textSpriteKe) { pictSprite._textSpriteKe.visible = true; }
        } else {
            pictSprite.visible = false;
            if (pictSprite._textSpriteKe) { pictSprite._textSpriteKe.visible = false; }
        }
    };


    //- ピクチャの見えない化
    function pictToNoVisible(pictSprite, word) {
        if (!pictSprite._noVisiblesKe) { pictSprite._noVisiblesKe = []; }
        if (pictSprite._noVisiblesKe.some(w => w == word)) { return; }
        pictSprite._noVisiblesKe.push(word);
    };


    //- ピクチャの見える化
    function pictToVisible(pictSprite, word) {
        if (!pictSprite._noVisiblesKe || !pictSprite._noVisiblesKe.length) { return; }
        pictSprite._noVisiblesKe = pictSprite._noVisiblesKe.filter(w => w != word);
    };


    //- ピクチャのウインドウ連動 呼び出し(コア追加)
    const _Window_Base_activate = Window_Base.prototype.activate;
    Window_Base.prototype.activate = function() {
        _Window_Base_activate.apply(this);
        // ピクチャのウインドウ連動
        setTimeout(pictSynchroWindow, 0, this, true);
    };

    const _Window_Base_deactivate = Window_Base.prototype.deactivate;
    Window_Base.prototype.deactivate = function() {
        _Window_Base_deactivate.apply(this);
        // ピクチャのウインドウ連動
        setTimeout(pictSynchroWindow, 0, this, false);
    };


    //- ピクチャのウインドウ連動
    function pictSynchroWindow(windo, flag) {
        if (!isValidDesign() || !windo || !windo.parent) { return; }
        const scene = SceneManager._scene;
        const picts = scene._pictsKeMnsk;
        if (!picts || !picts.length) { return; }
        // ピクチャを全て処理
        picts.forEach(pictSprite => {
            // 連動するなら可視状態を変更
            if (!pictSprite._synchroWindowNameKe) { return; }
            if (windo.constructor.name.includes(pictSprite._synchroWindowNameKe)) {
                if (flag) {
                    // ピクチャの見える化
                    pictToVisible(pictSprite, "synchroWindow");
                } else {
                    // ピクチャの見えない化
                    pictToNoVisible(pictSprite, "synchroWindow");
                }
            }
        });
    };


    //- ピクチャ表示の判定-全て
    function judgePictShowAll() {
        const scene = SceneManager._scene;
        if (!scene._pictsKeMnsk || !scene._pictsKeMnsk.length) { return; }
        // ピクチャを全て処理
        scene._pictsKeMnsk.forEach(pictSprite => {
            // ピクチャ表示の判定
            judgePictShow(pictSprite)
        });
    };


    //- ピクチャ表示の判定
    function judgePictShow(pictSprite) {
        if (!pictSprite._showConditionKe) { return; }
        const condition = pictSprite._showConditionKe;
        if (condition["ショップ購入前"]) {
            if (!shopBuyed) { pictToVisible(pictSprite, "shopBuy"); } else
            { pictToNoVisible(pictSprite, "shopBuy")}
        }
        if (condition["ショップ購入後"]) {
            if (!shopBuyed) { pictToNoVisible(pictSprite, "shopBuy"); } else
            { pictToVisible(pictSprite, "shopBuy")}
        }
        if (condition["ショップ売却前"]) {
            if (!shopSelled) { pictToVisible(pictSprite, "shopSell"); } else
            { pictToNoVisible(pictSprite, "shopSell")}
        }
        if (condition["ショップ売却後"]) {
            if (!shopSelled) { pictToNoVisible(pictSprite, "shopSell"); } else
            { pictToVisible(pictSprite, "shopSell")}
        }
        if (condition["スクリプト"]) {
            if (newFunc(condition["スクリプト"])) {
                pictToVisible(pictSprite, "script")
            } else {
                pictToNoVisible(pictSprite, "script")
            }
        }
    };


    //- ニューファンク
    let funcs = {};
    function newFunc(str) {
        if (!funcs[str]) {
            funcs[str] = new Function("", "return " + str);
            return funcs[str]();
        } else {
            return funcs[str]();
        }
    };


    //- ショップフラグの操作(コア追加)
    let shopBuyed = false;
    let shopSelled = false;

    const _Scene_Shop_doBuy = Scene_Shop.prototype.doBuy;
    Scene_Shop.prototype.doBuy = function(number) {
        _Scene_Shop_doBuy.apply(this, arguments);
        // ショップフラグを変更
        shopBuyed = true;
        shopSelled = false;
        // ピクチャ表示の判定-全て
        judgePictShowAll();
    };
    
    const _Scene_Shop_doSell = Scene_Shop.prototype.doSell;
    Scene_Shop.prototype.doSell = function(number) {
        _Scene_Shop_doSell.apply(this, arguments);
        // ショップフラグを変更
        shopSelled = true;
        shopBuyed = false;
        // ピクチャ表示の判定-全て
        judgePictShowAll();
    };


    //- ピクチャの初期化
    function initPict() {
        // ピクチャアニメ済みフラグを解除
        $gameTemp._pictAnimedKeMnsk = null;
        // ショップフラグを解除
        shopBuyed = false;
        shopSelled = false;
    };



    //==================================================
    //--  フォント設定
    //==================================================

    // 強制カラー変更フラグ
    let colorChangeForce = false;

    //- フォント設定の適用 呼び出し(コア追加)
    const _Window_Base_resetFontSettings = Window_Base.prototype.resetFontSettings;
    Window_Base.prototype.resetFontSettings = function() {
        _Window_Base_resetFontSettings.apply(this);
        // フォント設定の適用
        applyFontCfg(this);
    };


    //- フォント設定の適用
    function applyFontCfg(windo) {
        if (!isValidDesign()) { return; }
        // フォント設定の取得
        const font = getFontCfgAuto(windo);
        if (!font) { return; }
        // スタイルに応じたフォント設定
        fontSettingByStyle(windo.contents, font, "");
        // 文字色設定済みフラグ
        if (font["文字色"]) { windo._textColorSetedKeMnsk = true; }
        if (font["縁取り色"]) { windo._outColorSetedKeMnsk = true; }
        // フォント設定を記憶
        windo._fontKeMnsk = font;
        return true;
    };


    //- 制御文字でのカラー変更は通す
    const _Window_Base_processColorChange = Window_Base.prototype.processColorChange;
    Window_Base.prototype.processColorChange = function(colorIndex) {
        colorChangeForce = true;
        _Window_Base_processColorChange.apply(this, arguments);
        colorChangeForce = false;
    };


    //- 文字色設定済みの場合はそれ以上変更させない(コア追加)
    const _Window_Base_changeTextColor = Window_Base.prototype.changeTextColor;
    Window_Base.prototype.changeTextColor = function(color) {
        if (this._textColorSetedKeMnsk && !colorChangeForce) { return; }
        _Window_Base_changeTextColor.apply(this, arguments);
    };

    const _Window_Base_changeOutlineColor = Window_Base.prototype.changeOutlineColor;
    Window_Base.prototype.changeOutlineColor = function(color) {
        if (this._outColorSetedKeMnsk && !colorChangeForce) { return; }
        _Window_Base_changeOutlineColor.apply(this, arguments);
    };


    //- ゲージフォント
    const _Window_StatusBase_createInnerSprite = Window_StatusBase.prototype.createInnerSprite;
    Window_StatusBase.prototype.createInnerSprite = function(key, spriteClass) {
        const sprite = _Window_StatusBase_createInnerSprite.apply(this, arguments);
        if (spriteClass == Sprite_Gauge) {
            // フォント設定の取得
            const font = getFontCfgAuto(this, true) || getFontCfgAuto(this);
            if (!font) { return sprite; }
            // スタイルに応じたフォント設定
            sprite._fontKe = font;
        }
        return sprite;
    };


    //- ラベルフォント
    const _Sprite_Gauge_setupLabelFont = Sprite_Gauge.prototype.setupLabelFont;
    Sprite_Gauge.prototype.setupLabelFont = function() {
        _Sprite_Gauge_setupLabelFont.apply(this);
        if (this._fontKe) {
            fontSettingByStyle(this.bitmap, this._fontKe, "");
        }
    };


    //- 数値フォント
    const _Sprite_Gauge_setupValueFont = Sprite_Gauge.prototype.setupValueFont;
    Sprite_Gauge.prototype.setupValueFont = function() {
        _Sprite_Gauge_setupValueFont.apply(this);
        if (this._fontKe) {
            fontSettingByStyle(this.bitmap, this._fontKe, "");
        }
    };





    //==================================================
    //--  メニューBGM
    //==================================================

    // メニューBGMデータ
    let menuBgmData = null;

    // メニューBGMの開始
    function startMenuBGM(scene) {
        if (!isValidDesign()) { return; }
        let preScene = SceneManager._previousScene;
        preScene = preScene ? preScene.constructor.name : null;
        // シーンからのスタイル取得
        const style = getStyleByScene();
        if (!style) { return; }
        // BGMを取得
        const bgmName = style["BGM"];
        if (!bgmName) { return; }
        // BGM変更なしならリターン
        if (menuBgmData && bgmName == menuBgmData.curBgmName) { return; }
        const bgm = getBGM(bgmName);
        if (!bgm || !bgm["ファイル"]) { return; }
        if (!menuBgmData) { menuBgmData = {}; }
        // 流すBGMを記録
        menuBgmData.curBgmName = bgmName;
        // 前シーンがマップの時の処理
        if (preScene == "Scene_Map" || preScene == "Scene_Battle") {
            // マップBGMをセーブ
            BattleManager.saveBgmAndBgs();
            // マップBGMを保存
            menuBgmData.mapBgm = AudioManager._currentBgm;
        }
        // BGMを再生
        const bgmData = { name:bgm["ファイル"], volume:bgm["音量"] || 100, pitch:bgm["ピッチ"] || 100, pan:bgm["位相"] || 0}
        AudioManager.playBgm(bgmData);
    };



    //- メニューBGMをセーブしない(コア追加)
    const _Game_System_onBeforeSave = Game_System.prototype.onBeforeSave;
    Game_System.prototype.onBeforeSave = function() {
        _Game_System_onBeforeSave.apply(this);
        if (menuBgmData) {
            const bgm = menuBgmData.mapBgm || { bgm:"", volume:90, pitch:100, pan:0 };
            this._bgmOnSave = { name:bgm.name, volume:bgm.volume, pitch:bgm.pitch, pan:bgm.pan, pos:0 };
        }
    };


    //- メニューBGMの終了
    function endMenuBgm(noPlay) {
        if (!menuBgmData) { return; }
        // 元のBGMを復元
        if (!noPlay && (BattleManager._mapBgm || BattleManager._mapBgs)) {
            BattleManager.replayBgmAndBgs();
        }
        // メニューBGMデータを初期化
        menuBgmData = null;
    };


    //- ロード後にメニューBGMを終了(コア追加)
    const _Game_System_onAfterLoad = Game_System.prototype.onAfterLoad;
    Game_System.prototype.onAfterLoad = function() {
        // メニューBGMの終了
        endMenuBgm(true);
        _Game_System_onAfterLoad.apply(this);
    };



    //==================================================
    //--  メニュー終了
    //==================================================

    //- メニューの終了
    function endMenu(scene) {
        let nextScene = SceneManager._nextScene;
        nextScene = nextScene ? nextScene.constructor.name : null;
        if (!(nextScene.match(/Map|Battle|Title|Load/))) { return; }
        // 背景の初期化
        initBack();
        // ピクチャの初期化
        initPict();
        // メニューBGMの終了
        endMenuBgm();
        // メニュー終了アニメのセット
        setMenuEndAnime(scene);
        // 変数の初期化
        setsWindowAnimes = [];
        backAnimeSeted = false;
        menuBgmData = null;
    };


    //- メニュー終了アニメのセット
    function setMenuEndAnime(scene) {
        const sceneName = scene.constructor.name;
        if (sceneName.match(/Scene_Load|Scene_GameEnd/)) { return; }
        // シーンからのスタイル取得
        const style = getStyleByScene(scene);
        if (!style) { return false; }
        // 終了アニメが有効でなければリターン
        const endAnime = "メニュー終了アニメ";
        if (!isValidAnime(style, endAnime)) { return; }
        // 画面を撮影
        SceneManager.snapForBackground();
        // 終了アニメを予約
        $gameTemp._menuEndAnimeAppoKe = { style:style, endAnime:endAnime };
    };


    //- メニュー終了アニメの処理
    function processMenuEndAnime(scene) {
        if (!$gameTemp._menuEndAnimeAppoKe) { return; }
        // メニュー終了スプライトを形成
        const endSprite = new SpriteKeMnsk();
        endSprite.bitmap = SceneManager.backgroundBitmap();
        scene.addChild(endSprite);
        scene._menuEndSpriteKe = endSprite;
        // アンカー & 位置
        endSprite.anchor.x = 0.5;
        endSprite.anchor.y = 0.5;
        endSprite.x = Graphics.width / 2;
        endSprite.y = Graphics.height / 2;
        // アニメを適用
        const appo = $gameTemp._menuEndAnimeAppoKe;
        // スプライトの標準値を保存
        saveSpriteOriVal(endSprite);
        // アニメの呼び出し
        callAnimeByStyle(endSprite, scene, appo.style, appo.endAnime, "start");
        // 予約を解除
        $gameTemp._menuEndAnimeAppoKe = null;
        // メニュー終了アニメ中フラグ
        scene._inMenuEndAniemKe = true;
    };


    //- メニュー終了アニメの更新
    function updateMenuEndAnime(scene) {
        if (!scene._inMenuEndAniemKe) { return; }
        // アニメスプライトの更新
        updateAnimeSprite(scene);
        // 終了
        const animeSprites = scene._inAnimeSpritesKeMnsk;
        if (!animeSprites || !animeSprites.length) {
            scene._inMenuEndAniemKe = null;
            destroySprite(scene._menuEndSpriteKe);
            scene._menuEndSpriteKe = null;
        }
    };



    //==================================================
    //--  その他
    //==================================================

    //- ショップ画面のダミーウインドウを消去(コア追加)
    const _Scene_Shop_update = Scene_Shop.prototype.update;
    Scene_Shop.prototype.update = function() {
        _Scene_Shop_update.apply(this);
        if (this._dummyWindow && isValidDesign()) {
            this._dummyWindow.visible = false;
        }
    };



    //==================================================
    //--  アニメーションの開始
    //==================================================
    
    //- アニメの呼び出し
    function callAnime(sprite, body, animeName, animeType, delay = 0) {
        if (!animeName) { return; }
        // アニメデータの取得
        const animeDatas = getAnimeData(animeName, animeType, delay);
        // アニメデータのセット
        setAnimeData(sprite, animeDatas, body, delay);
        return true;
    };
    
    
    //- スタイルからのアニメ呼び出し
    function callAnimeByStyle(sprite, body, style, word, animeType, delay = 0) {
        if (!style || !word) { return; }
        // アニメ名を取得
        const animeName = style[word];
        // アニメの呼び出し
        return callAnime(sprite, body, animeName, animeType, delay);
    };
    
    
    //- アニメデータの取得
    function getAnimeData(animeName, animeType, delay = 0) {
        const animeDatas = [];
        if (animeName.constructor.name == "Array") {
            animeName.forEach(name => {
                const args = keke_animeList.filter(d => d["アニメ名"] == name)[0];
                if (args) { animeDatas.push({ args:args, animeType:animeType, delay:delay }); }
            });
        } else {
            const args = keke_animeList.filter(d => d["アニメ名"] == animeName)[0];
            if (args) { animeDatas.push({ args:args, animeType:animeType, delay:delay }); }
        }
        return animeDatas;
    };
    
    
    //- アニメデータのセット
    function setAnimeData(sprite, animeDatas, body) {
        if (!animeDatas || !animeDatas.length) { return; }
        // シングルアニメの処理
        const animeType = animeDatas[0].animeType;
        const isSingle = animeType == "single";
        if (isSingle) {
            if (sprite._inSingleAnimeKe) { return; }
            sprite._inSingleAnimeKe = true;
        }
        // データを追加
        if (!sprite._animeDatasKe) { sprite._animeDatasKe = []; }
        sprite._animeDatasKe = [...sprite._animeDatasKe, ...animeDatas];
        // アニメ開始スプライテスとしてセット
        if (!body._animeStartSpritesKeMnsk) { body._animeStartSpritesKeMnsk = []; }
        if (!body._animeStartSpritesKeMnsk.some(s => s == sprite)) {
            body._animeStartSpritesKeMnsk.push(sprite);
        }
        // アニメ開始の更新
        updateAnimeStart(sprite, body);
    };
    
    
    //- アニメ開始の更新
    function updateAnimeStart(sprite, body, force) {
        if (!sprite._animeDatasKe || !sprite._animeDatasKe.length) { return; }
        // データをひとつ取得
        const data = sprite._animeDatasKe[0];
        const animeType = data.animeType;
        // 各アニメウェイト
        if (!force) {
            if (sprite._animationsKe && sprite._animationsKe.some(drift => drift.animeType.includes("start") && !drift.noWait)) { return; }
            if (sprite._animationsKe && sprite._animationsKe.some(drift => drift.animeType.includes("end") && !drift.noWait)) { return; }
            if (animeType.includes("start") && sprite._waitStartAnimeKe) { return; }
            if (animeType.includes("ing") && sprite._waitIngAnimeKe) { return; }
        }
        // データをひとつ消去
        sprite._animeDatasKe.shift();
        // アニメのセット
        setAnime(sprite, data, body);
        // データがなくなったらアニメ開始スプライテスから除外
        let del = false;
        if (!sprite._animeDatasKe.length) {
            body._animeStartSpritesKeMnsk = body._animeStartSpritesKeMnsk.filter(s => s != sprite);
        };
    };
    
    
    //- 見えないか
    function isNoVisible(sprite) {
        let hide = false;
        while (true) {
            sprite = sprite.parent;
            if (!sprite) { break; }
            if (!sprite.visible) { hide = true; break; }
        }
        return hide;
    };
    
    
    //- アニメのセット
    function setAnime(sprite, data, body) {
        if (!sprite.transform) { return; }
        const args = data.args;
        const time = makeTime(args["アニメ時間"]) || 1;
        const num = Math.round(Number(args["アニメ回数"])) || 1;
        if (!time || !num) { return; }
        // 回転角の初期化
        if (sprite._angleKe == null) { sprite._angleKe = angleToDegree(sprite.rotation); }
        //sprite._angleKe = loopAngle(sprite._angleKe);
        // 最初の値をセット
        setOpenVal(sprite, args, data);
        // 変動値を取得
        const drift = {};
        drift.animeType = data.animeType;
        drift.timeMax = time
        drift.duration = drift.timeMax;
        drift.timeMaxOri = drift.timeMax;
        drift.num = num;
        drift.noWait = toBoolean(args["ノーウェイト"]);
        // 挿入ウェイト
        if (args["…挿入ウェイト"]) {
            const insertWait = strToHash(args["…挿入ウェイト"]);
            drift.waitStart = insertWait["ウェイト開始"].clamp(0, time - 1);
            drift.waitTime = insertWait["ウェイト時間"];
            drift.waitStartOri = drift.waitStart;
            drift.inWait = 0;
        }
        // ディレイ
        if (data.delay) {
            drift.delay = data.delay;
        }
        // 位置X
        if (args["→位置X"] != null) {
            const posXs = calcMulti(sprite.x, args["→位置X"], sprite._posXOriKe);
            drift.posXs = makeDrift(posXs, sprite.x, time, "位置X");
        }
        // 位置Y
        if (args["→位置Y"] != null) {
            const posYs = calcMulti(sprite.y, args["→位置Y"], sprite._posYOriKe);
            drift.posYs = makeDrift(posYs, sprite.y, time, "位置Y");
        }
        // スケールX
        if (args["→スケールX"] != null) {
            const scaleXs = calcMulti(sprite.scale.x,  args["→スケールX"], sprite._scaleXOriKe);
            drift.scaleXs = makeDrift(scaleXs, sprite.scale.x, time, "スケールX");
        }
        // スケールY
        if (args["→スケールY"] != null) {
            const scaleYs = calcMulti(sprite.scale.y, args["→スケールY"], sprite._scaleYOriKe);
            drift.scaleYs = makeDrift(scaleYs, sprite.scale.y, time, "スケールY");
        }
        // 回転角
        if (args["→回転角"] != null) {
            const angles = calcMulti(sprite._angleKe, args["→回転角"], sprite._angleOriKe);
            drift.angles = makeDrift(angles, sprite._angleKe, time, "回転角");
        }
        // 不透明度
        if (args["→不透明度"] != null) {
            const opacities = calcMulti(sprite.opacity, args["→不透明度"], sprite._opacityOriKe);
            drift.opacities = makeDrift(opacities, sprite.opacity, time, "不透明度");
        }
        // カラートーン
        ct = [args["→カラー赤"], args["→カラー緑"], args["→カラー青"], args["→カラー灰"]];
        drift.colorTones = [];
        for (let i = 0; i <= 3; i++) {
            if (ct[i] != null) {
                const colorTones = calcMulti(sprite._colorTone[i], ct[i], sprite._colorToneOriKe ? sprite._colorToneOriKe[i] : 0);
                // カラートーンの不透明度補正
                colorTones[0].val = colorToneOpaRevise(colorTones[0].val, sprite.opacity, data.animeType);
                drift.colorTones[i] = makeDrift(colorTones, sprite._colorTone[i], time, "カラートーン");
            }
        }
        // 透明化
        if (args["透明化"]) {
            drift.noVisible = 1;
            sprite._noVisibleKe = true;
            sprite.x -= 10000;
        }
        // アニメタイプをセット
        drift.animeType = data.animeType;
        // 変数セット
        if (!sprite._animationsKe) { sprite._animationsKe = []; }
        sprite._animationsKe.push(drift);
        // アニメ中スプライテスとしてセット
        if (!body._inAnimeSpritesKeMnsk) { body._inAnimeSpritesKeMnsk = []; }
        if (!body._inAnimeSpritesKeMnsk.some(s => s == sprite)) {
            body._inAnimeSpritesKeMnsk.push(sprite);
        }
    };


    //- カラートーンの不透明度補正
    function colorToneOpaRevise(val, bodyOpa, animeType) {
        if (!val) { return val; }
        let match = animeType.match(/opa(\d+)/i);
        if (!match) { return val; }
        const opaCenter = Number(match[1]);
        return Math.round(val * (opaCenter / bodyOpa)).clamp(0, 255);
    };
    
    
    //- 最初の値をセット
    function setOpenVal(sprite, args, data) {
        if (args["位置X"] != null) { sprite.x = calcMulti(sprite.x, args["位置X"], sprite._posXOriKe)[0].val; }
        if (args["位置Y"] != null) { sprite.y = calcMulti(sprite.y, args["位置Y"], sprite._posYOriKe)[0].val; }
        if (args["スケールX"] != null) {
            sprite.scale.x = calcMulti(sprite.scale.x, args["スケールX"], sprite._scaleXOriKe)[0].val;
        }
        if (args["スケールY"] != null) {
            sprite.scale.y = calcMulti(sprite.scale.y, args["スケールY"], sprite._scaleYOriKe)[0].val;
        }
        if (args["回転角"] != null) {
            sprite._angleKe = calcMulti(sprite._angleKe, args["回転角"], sprite._angleOriKe)[0].val;
            sprite.rotation = angleToRadian(sprite._angleKe);
        }
        if (args["不透明度"] != null) { sprite.opacity = calcMulti(sprite.opacity, args["不透明度"], sprite._opacityOriKe)[0].val; }
        if (args["カラー赤"] != null || args["カラー緑"] != null || args["カラー青"] != null || args["カラー灰"] != null) {
            let ct = [args["カラー赤"], args["カラー緑"], args["カラー青"], args["カラー灰"]];
            for (let i = 0; i <= 3; i++) {
                if (ct[i] != null) {
                    sprite._colorTone[i] = calcMulti(sprite._colorTone[i], ct[i], sprite._colorToneOriKe[i])[0].val;
                    // カラートーンの不透明度補正
                    sprite._colorTone[i] = colorToneOpaRevise(sprite._colorTone[i], sprite.opacity, data.animeType);
                }
            }
            sprite._updateColorFilter();
        }
    };
    
    
    //- 変動の作成
    function makeDrift(datas, current, time, word) {
        if (!datas || !datas.length) { return; }
        if (word == "回転角") { current %= 360; }
        let ds = [];
        // データの数だけ処理
        datas.forEach(data => {
            if (data.val == null) { return; }
            const d = {};
            d.num = data.num || 1;
            d.datas = data.datas || ["", ""];
            const extra = data.extra || "";
            d.break = extra.includes("B");
            d.jump = extra.includes("J");
            d.direction = extra.includes("D");
            d.isCos = extra.includes("C");
            d.isRandom = d.datas[1].includes("~");
            d.easing = data.easing || "E";
            d.easingRate = data.easingRate || 1;
            d.timeMax = time / d.num;
            d.duration = d.timeMax;
            d.start = roundDecimal(current, 1000000);
            d.target = Number(data.val);
            d.vol = d.target - d.start;
            d.current = d.start;
            d.end = 0;
            // 終点
            if (d.easing == "TN" || d.easing == "RD") {
                d.end = d.start;
            } else {
                d.end = d.target;
            }
            ds.push(d);
        });
        return ds;
    };
    
    
    
    //==================================================
    //--  アニメーションの更新
    //==================================================
    
    //- アニメスプライトの更新
    function updateAnimeSprite(body) {
        if (!body) { return; }
        // アニメ開始スプライトの更新
        updataAnimeStartSprite(body);
        // アニメ中スプライトの更新
        updataInAnimeSprites(body);
    };
    
    
    //- アニメ開始スプライトの更新
    function updataAnimeStartSprite(body) {
        if (!body._animeStartSpritesKeMnsk || !body._animeStartSpritesKeMnsk.length) { return; }
        let del = false;
        body._animeStartSpritesKeMnsk.forEach((sprite, i) => {
            if (!sprite || !sprite.parent) {
                destroySprite(sprite);
                body._animeStartSpritesKeMnsk[i] = null;
                del = true;
                return;
            }
            // アニメ開始の更新
            del = updateAnimeStart(sprite, body);
        });
        if (del) { body._animeStartSpritesKeMnsk = body._animeStartSpritesKeMnsk.filter(s => s); }
    };
    
    
    //- アニメ中スプライトの更新
    function updataInAnimeSprites(body) {
        if (!body._inAnimeSpritesKeMnsk || !body._inAnimeSpritesKeMnsk.length) { return; }
        let del = false;
        body._inAnimeSpritesKeMnsk.forEach((sprite, i) => {
            if (!sprite || !sprite.parent) {
                destroySprite(sprite);
                body._inAnimeSpritesKeMnsk[i] = null;
                del = true;
                return;
            }
            // アニメの更新
            if (updateAnime(sprite, body)) {
                body._inAnimeSpritesKeMnsk[i] = null;
                del = true;
            }
        });
        if (del) {
            body._inAnimeSpritesKeMnsk = body._inAnimeSpritesKeMnsk.filter(s => s);
            // 終了アニメの完了判定
            if (!body._inAnimeSpritesKeMnsk.length && inEndAnime(body)) {
                // アニメ終了時関数の実行
                doAnimeEndFunc(body);
            }
        }
    }
    
    
    //- アニメの更新
    function updateAnime(sprite, body) {
        if (!sprite._animationsKe || !sprite._animationsKe.length) { return; }
        let end = false;
        let del = false;
        let single = false;
        let destroy = false;
        // データごとに処理
        sprite._animationsKe.forEach((drift, i) => {
            // アニメの更新-個別
            drift = updateAnimeEach(sprite, drift, i, body);
            if (!sprite.transform || !drift || drift.terminate) {
                sprite._animationsKe[i] = null;
                end = true;
                // シングル判定
                if (drift && drift.animeType == "single") { single = true; }
                // 破棄判定
                if (drift && drift.animeType == "destroy") { destroy = true; }
            }
        });
        // null を消去
        if (end) {
            sprite._animationsKe = sprite._animationsKe.filter(d => d);
            // アニメの終了
            endAnime(sprite, body, single, destroy);
            if (!sprite._animationsKe.length) { del = true; }
        }
        return del;
    };


    //- アニメの更新-個別
    function updateAnimeEach(sprite, drift, i, body) {
        if (!sprite.transform || !drift) { return drift; }
        // カーソルアニメの更新
        if (updateCursorAnime(sprite, body, drift)) { return drift; };
        // ループアニメの停止
        if (sprite._stopLoopAnimeKe && drift.num < 0) {
            if (sprite._stopLoopAnimeKe == 1) {
                // アニメの中断
                breakAnime(sprite, drift);
                sprite._stopLoopAnimeKe = 2;
            } else {
                return drift;
            }
        };
        // フリーズ
        if (drift.freeze) {
            return drift;
        }
        // 挿入ウェイト
        if (drift.inWait) {
            drift.inWait--;
            return drift
        }
        if (drift.waitStart == drift.dura && drift.waitTime) {
            drift.waitStart = null;
            drift.inWait = drift.waitTime;
            return drift
        }
        // ディレイ
        if (drift.delay) {
            drift.delay--;
            return drift;
        }
        // 位置X
        if (drift.posXs && drift.posXs.length) {
            let moveXs = updateDrift(drift.posXs, "位置X");
            moveXs.forEach(v => sprite.x += v);
        }
        // 位置Y
        if (drift.posYs && drift.posYs.length) {
            let moveYs = updateDrift(drift.posYs, "位置Y");
            moveYs.forEach(v => sprite.y += v);
        }
        // スケールX
        if (drift.scaleXs && drift.scaleXs.length) {
            let scaleXs = updateDrift(drift.scaleXs, "スケールX");
            scaleXs.forEach(v => sprite.scale.x += v);
        }
        // スケールY
        if (drift.scaleYs && drift.scaleYs.length) {
            let scaleYs = updateDrift(drift.scaleYs, "スケールY");
            scaleYs.forEach(v => sprite.scale.y += v);
        }
        // 回転角
        if (drift.angles && drift.angles.length) {
            let angles = updateDrift(drift.angles, "回転角");
            angles.forEach(v => sprite._angleKe += v);
            sprite.rotation = angleToRadian(sprite._angleKe);
        }
        // 不透明度
        if (drift.opacities && drift.opacities.length) {
            let opacities = updateDrift(drift.opacities, "不透明度");
            opacities.forEach(v => sprite.opacity += v);
        }
        // カラートーン
        if (drift.colorTones && drift.colorTones.length && drift.colorTones.some(c => c.length)) {
            let colorTones = [];
            for (let j = 0; j < 4; j++) {
                if (!drift.colorTones[j]) { continue; }
                colorTones[j] = updateDrift(drift.colorTones[j], "カラートーン");
                colorTones[j].forEach(v => {
                    sprite._colorTone[j] += v;
                });
            }
            sprite._updateColorFilter();
        }
        // カウント
        drift.duration--;
        // 終了
        if (drift.duration <= 0) {
            if (drift.num >= 0) { drift.num--; }
            // 非ループ時
            if (!drift.num) {
                // スプライト標準値の復帰
                //restoreSpriteOriVar(sprite);
                if (drift.animeType.includes("noEnd")) {
                    drift.freeze = true;
                } else {
                    // 透明化の解除
                    if (drift.noVisible) {
                        sprite._noVisibleKe = false;
                        setTimeout(remNoVisible, 0, sprite);
                    }
                    drift.terminate = true;
                }
            // ループ時
            } else {
                // 変動値の再セット
                resetDrift(sprite, drift, sprite, i);
                drift.duration = drift.timeMax;
            }
        }
        return drift;
    }


    //- 透明化の解除
    function remNoVisible(sprite) {
        if (!sprite || !sprite.parent || !sprite.transform || sprite._noVisibleKe) { return; }
        if (sprite.x > -5000) { return; }
        sprite.x += 10000;
    };
    
    
    //- 変動の更新
    function updateDrift(ds, word) {
        let rs= []
        // データを全て処理
        ds.forEach(d => {
            // カウントを減らす
            d.duration--;
            let r = 0;
            next = applyEasing(d.current, d.start, d.target, d.duration, d.timeMax, d.easing, d.easingRate);
            r = next - d.current;
            d.current = next;
            // 終了
            if (d.duration <= 0) {
                // 終了値に合わせる
                r += roundDecimal(d.end - next, 1000000);
                d.num--;
                d.duration = d.timeMax;
            }
            if (r) { rs.push(r); }
        });
        return rs;
    };
    
    
    
    //==================================================
    //--  アニメーションの終了
    //==================================================
    
    //- アニメの終了
    function endAnime(sprite, body, single, destroy) {
        // アニメ中スプライトから除外
        if (!sprite._animationsKe.length && body._inAnimeSpritesKeMnsk) { 
            //body._inAnimeSpritesKeMnsk = body._inAnimeSpritesKeMnsk.filter(s => s != sprite);
        }
        // シングル終了
        if (single) { sprite._inSingleAnimeKe = false; }
        // 破棄
        if (destroy) { destroySprite(sprite); }
    };
    
    
    //- 変動値の再セット
    function resetDrift(sprite, drift, sprite, time) {
        //if (!drift.isRandom) { return; }
        const keys = ["posXs", "posYs", "scaleXs", "scaleYs", "angles", "opacities", "colorTones"];
        const curs = ["x", "y", "scale.x", "scale.y", "_angleKe", "opacity", "_colorTone"];
        const words = ["位置X", "位置Y", "スケールX", "スケールY", "回転角", "不透明度", ["カラー赤", "カラー緑", "カラー青", "カラー灰"]];
        const oris = ["posXOri", "posYOri", "scaleXOri", "scaleYOri", "angleOri", "opacityOri", "colorToneOri", ];
        // キーごとに処理
        keys.forEach((key, j) => {
            if (!drift[key] || !drift[key].length) { return; }
            const ds = drift[key];
            // カラートーンの場合
            if (key == "colorTones") {
                ds.forEach((cols, c) => {
                    if (!cols.length) { return; }
                    const datas = cols[0].datas;
                    datas[2] = sprite["_"+oris[j]+"Ke"][c];
                    const current = sprite[curs[j]][c];
                    const newData = calcMulti(current, datas[1], datas[2], datas[3]);
                    // カラートーンの不透明度補正
                    newData[0].val = colorToneOpaRevise(newData[0].val, sprite.opacity, drift.animeType);
                    drift[key][c] = makeDrift(newData, current, drift.timeMax, words[j][c]);
                });
                return
            };
            // それ以外の場合
            const datas = ds[0].datas;
            datas[2] = sprite["_"+oris[j]+"Ke"];
            let current = 0;
            if (curs[j].includes("scale")) {
                const cs = curs[j].split(".");
                current = sprite[cs[0]][cs[1]] || 0;
            } else {
                current = sprite[curs[j]] || 0;
            }
            //if (key == "angles") { current = loopAngle(Math.ceil(current)); }
            const newData = calcMulti(current, datas[1], datas[2], datas[3]);
            drift[key] = makeDrift(newData, current, drift.timeMax, words[j]);
        });
        // アニメ時間
        drift.timeMax = drift.timeMaxOri;
    };
    
    
    // スプライト標準値の復帰
    function restoreSpriteOriVar(sprite) {
        if (!(sprite instanceof Sprite) || !sprite.transform) { return; }
        if (sprite._scaleXOriKe != null) { sprite.scale.x = Number(sprite._scaleXOriKe.replace("\*", "")); }
        if (sprite._scaleYOriKe != null) { sprite.scale.y = Number(sprite._scaleYOriKe.replace("\*", "")); }
        if (sprite._angleOriKe != null) { sprite._angleKe = sprite._angleOriKe; }
        if (sprite._opacityOriKe) { sprite.opacity = 255 * Number(sprite._opacityOriKe.replace("\*", "")) }
        if (sprite._colorToneOriKe != null) { sprite.setColorTone(sprite._colorToneOriKe); }
    };


    //- アニメの停止
    function stopAnime(sprite, animeType, instant) {
        // アニメデータ
        if (sprite._animeDatasKe) {
            sprite._animeDatasKe = sprite._animeDatasKe.filter(data => animeType && data.aniemType != animeType)
        }
        // アニメ中
        if (sprite._animationsKe) {
            sprite._animationsKe.forEach(drift => {
                if (!animeType || drift.animeType == animeType) {
                    // アニメの中断
                    breakAnime(sprite, drift, instant);
                };
            });
        }
    };
    
    
    //- アニメの中断
    function breakAnime(sprite, drift, instant) {
        if (!drift) { return; }
        Object.keys(drift).forEach(k => {
            const ds = drift[k];
            if (!ds) { return; }
            if (ds.constructor.name == "Array") {
                ds.forEach(d => {
                    if (d.constructor.name == "Array") {
                        d.forEach(c => c.duration = 1);
                    } else {
                        d.duration = 1;
                    }
                });
            }
        });
        drift.duration = 1;
        drift.num = 1;
        if (instant) { updateAnime(sprite, instant); }
    };
    
    
    //- アニメの全終了
    function allEndAnime(body) {
        // アニメ開始スプライテス
        const aniDataSprites = body._animeStartSpritesKeMnsk;
        if (aniDataSprites) {
            aniDataSprites.forEach(sprite => sprite ? sprite._animeDatasKe = null : 0);
        }
        body._animeStartSpritesKeMnsk = null;
        // アニメ中スプライテス
        const inAnimeSprites = body._inAnimeSpritesKeMnsk;
        if (inAnimeSprites) {
            inAnimeSprites.forEach(sprite => sprite ? sprite._animationsKe = null : 0);
        }
        body._inAnimeSpritesKeMnsk = null;
    };
    
    
    //- アニメ終了時関数のセット
    function setAnimeEndFunc(body, func, ...args) {
        body._animeEndFuncKe = { func:func, args:args };
    };
    

    //- アニメ終了時関数の実行
    function doAnimeEndFunc(body) {
        if (!body._animeEndFuncKe) { return; }
        const funcs = body._animeEndFuncKe;
        funcs.func(...funcs.args);
        body._animeEndFuncKe = null;
    };
    
    
    //- アニメ実行中か
    function isAnimeRunning(sprite) {
        return ((sprite._animeDatasKe && sprite._animeDatasKe.length) || (sprite._animationsKe && sprite._animationsKe.length));
    };
    
    
    //- アニメ中か
    function inAnime(body) {
        return (body._animeStartSpritesKeMnsk && body._animeStartSpritesKeMnsk.length) || (body._inAnimeSpritesKeMnsk && body._inAnimeSpritesKeMnsk.length)
    };
    
    
    //- 終了アニメ中か
    function inEndAnime(body) {
        return body._inEndAnimeKe;
    };



    //==================================================
    //--  ピクチャテキスト
    //==================================================
    
    //- テキストの読み取り描画
    function drawTextLoading(sprite, bitmap, text, x, y, width, height, align, fontSize, fontSizeOri, fontSizeRate, lineSpace) {
        // 行に分ける
        const lines = text.split(/\n|\\n/);
        // 行ごとに描画
        let up = 0;
        lines.forEach((line, i) => {
            // ライン幅の取得
            const lw = getLineWidth(line, fontSize, fontSizeRate, fontSizeOri).lineW;
            // 左端を取得
            let left = 0;
            // 左揃え
            if (align == 0) {
            // 右揃え
            } else if (align == 2) {
                left = Math.max(0, width - lw);
            // 中央揃え
            } else {
                left = Math.max(0, (width - lw) / 2);
            }
            // ライン高の取得
            const lh = getLineHeight(line, fontSize, fontSizeOri);
            // テキストラインの描画
            drawTextLine(sprite, bitmap, line, x + left, y + up, width, lh.lineH, fontSize);
            fontSize = lh.fontSize;
            up += lh.lineH + (lineSpace || 0);
        });
    };


    //- テキストラインの描画
    function drawTextLine(sprite, bitmap, line, x, y, width, height, fontSize, fontSizeOri, fontSizeRate) {
        let left = 0;
        while (line) {
            const match = line.match(/^[\x1b\\](\w*)\[?([^\]]*)*\]?\s*/i);
            // 制御文字を処理
            if (match) {
                // 制御文字の読み取り
                const r = scanControlChar(line, fontSize, fontSizeOri, bitmap);
                fontSize = r.fontSize;
                line = r.text;
                // アイコンの作成
                if (r.cmd.icd) {
                    const icd = r.cmd.icd;
                    const startX = -width / 2 + icd.wd / 2;
                    const startY = -height / 2 + icd.wd / 2;
                    const up = Math.max(0, (height - icd.wd) / 2);
                    makeIcon(sprite, icd, startX + x + left, startY + y + up);
                    left += icd.wd;
                }
            // 一字を描画
            } else {
                const c = line[0];
                const cw = strWidth(c, fontSize, fontSizeRate);
                const up = Math.max(0, (height - fontSize) / 2);
                bitmap.drawText(c, x + left, y + up, cw, fontSize);
                line = line.slice(1);
                left += cw
            }
        }
    };
    
    
    //- 制御文字の読み取り
    function scanControlChar(text, fontSize, fontSizeOri, bitmap = null) {
        let matched = false;
        let cmd = {};
        // フォントサイズ
        match = text.match(/^[\x1b\\]fs\[([^\]]*)\]/i);
        if (match) {
            fontSize = getFontSize(match[1], fontSizeOri);
            if (bitmap) { bitmap.fontSize = fontSize; }
            text = text.replace(match[0], "");
            matched = true;
        }
        // フォントボールド
        match = text.match(/^[\x1b\\]fb\[([^\]]*)\]/i);
        if (match) {
            if (bitmap) { bitmap.fontBold = !match[1] ? false : Number(match[1]) ? true : false; }
            text = text.replace(match[0], "");
            matched = true;
        }
        // フォントイタリック
        match = text.match(/^[\x1b\\]fi\[([^\]]*)\]/i);
        if (match) {
            if (bitmap) { bitmap.fontItalic = !match[1] ? false : Number(match[1]) ? true : false; }
            text = text.replace(match[0], "");
            matched = true;
        }
        // フォントカラー
        match = text.match(/^[\x1b\\]c\[([^\]]*)\]/i);
        if (match) {
            if (bitmap) { bitmap.textColor = match[1].includes(",") ? strToColor(match[1]) : ColorManager.textColor(Number(match[1])); }
            text = text.replace(match[0], "");
            matched = true;
        }
        // 縁取りカラー
        match = text.match(/^[\x1b\\]oc\[([^\]]*)\]/i);
        if (match) {
            if (bitmap) { bitmap.outlineColor = strToColor(match[1]); }
            text = text.replace(match[0], "");
            matched = true;
        }
        // 縁取り幅
        match = text.match(/^[\x1b\\]ow\[([^\]]*)\]/i);
        if (match) {
            if (bitmap) { bitmap.outlineWidth = !match[1] ? 3 : Number(match[1]); }
            text = text.replace(match[0], "");
            matched = true;
        }
        // クリア
        match = text.match(/^[\x1b\\]cl/i);
        if (match) {
            fontSize = fontSizeOri;
            if (bitmap) {
                bitmap.fontSize = fontSize;
                bitmap.textColor = ColorManager.textColor(0);
            }
            text = text.replace(match[0], "");
            matched = true;
        }
        // アイコン
        match = text.match(/^[\x1b\\]ic\[([^\]]+)\]/i);
        if (match) {
            const icd = match[1].replace(/\s/g, "").split(",");
            cmd.icd = { index:Number(icd[0]), wd:Number(icd[1]) || fontSize || ImageManager.iconWidth }
            text = text.replace(match[0], "");
            matched = true;
        }
        // マッチしなかったら \ だけ消去
        if (!matched) { text = text.replace(/^[\x1b\\]/, ""); }
        return { text:text, fontSize:fontSize, cmd:cmd };
    };


    //- テキスト幅の取得
    function getTextWidth(text, fontSize, fontSizeOri, fontSizeRate) {
        if (!text) { return 0; }
        const lines = text.split(/\n|\\n/);
        let width = 0;
        lines.forEach(line => {
            if (!line) { return; }
            // ライン幅の取得
            const r = getLineWidth(line, fontSize, fontSizeOri, fontSizeRate);
            fontSize = r.fontSize;
            width = Math.max(width, r.lineW);
        });
        return width;
    };
    
    
    //- ライン幅の取得
    function getLineWidth(line, fontSize, fontSizeOri, fontSizeRate) {
        fontSizeOri = fontSizeOri || fontSize;
        let lineW = 0;
        while (line) {
            let match = line.match(/^[\x1b\\]sc\#([^\#]*)\#(\d*\.?\d*)\#?/i);
            if (match) {
                lineW += Number(match[2]) || strWidth(match[1], fontSize, fontSizeRate);
                line = line.replace(match[0], "");
                continue;
            }
            match = line.match(/^[\x1b\\](\w+)\[([^\]]*)\]/i);
            if (match) {
                if (match[1].toUpperCase() == "FS") {
                    fontSize = getFontSize(match[2], fontSizeOri);
                }
                if (match[1].toUpperCase() == "IC") {
                    lineW += (Number(match[2].replace(/\s/g, "").split(",")[1]) || fontSize || ImageManager.iconWidth) + 1;
                }
                if (match[1].toUpperCase() == "I") {
                    lineW += ImageManager.iconWidth;
                }
                line = line.replace(match[0], "");
                continue;
            }
            match = line.match(/^[\x1b\\]cl/i);
            if (match) {
                fontSize = fontSizeOri;
                line = line.replace(match[0], "");
                continue;
            }
            match = line.match(/^[\x1b\\]\w*/i);
            if (match) {
                line = line.replace(match[0], "");
                continue;
            }
            lineW += strWidth(line[0], fontSize, fontSizeRate);
            line = line.slice(1);
        }
        return { lineW:lineW, fontSize:fontSize }
    };
    
    
     //- テキスト高の取得
    function getTextHeight(text, fontSize, fontSizeOri, lineSpace) {
        if (!text) { return 0; }
        const lines = text.split(/\n|\\n/);
        let height = 0;
        lines.forEach(line => {
            if (!line) { return; }
            // ライン高の取得
            const r = getLineHeight(line, fontSize, fontSizeOri);
            fontSize = r.fontSize;
            // 制御文字の除外
            const d = delControlChar(line);
            if (!d.cOk && (d.cNum && (strBytes(d.str) - d.cNum) <= 1)) { return; }
            height += r.lineH + lineSpace;
        });
        return height;
    };
    
    
    //- ライン高の取得
    function getLineHeight(line, fontSize, fontSizeOri) {
        fontSizeOri = fontSizeOri || fontSize;
        let fontSizePre = fontSize;
        let lineH = 0;
        while (true) {
            let match = line.match(/[\x1b\\](\w+)\[([^\]]*)\]/i);
            if (match) {
                if (match[1].toUpperCase() == "FS") {
                    fontSize = getFontSize(match[2], fontSizeOri);
                    lineH = Math.max(lineH, fontSize);
                }
                if (match[1].toUpperCase() == "IC") {
                    const iw = Number(match[2].replace(/\s/g, "").split(",")[1]) || ImageManager.iconWidth;
                    lineH = Math.max(lineH, iw);
                }
                if (match[1].toUpperCase() == "I") {
                    const iw = ImageManager.iconWidth;
                    lineH = Math.max(lineH, iw);
                }
                line = line.replace(match[0], "");
                continue;
            }
            match = line.match(/[\x1b\\]cl/i);
            if (match) {
                fontSize = fontSizeOri;
                lineH = Math.max(lineH, fontSize);
                line = line.replace(match[0], "");
                continue;
            }
            if (!match) { break; }
        }
        if (!lineH) { lineH = fontSize; }
        return { lineH:lineH, fontSize:fontSize }
    };
    
    
    //- 制御文字の除外
    function delControlChar(str) {
        let cNum = 0;
        let cOk = false;
        if (str.match(/[\x1b\\](ic|i)/i)) { cOk = true; }
        let matches = str.match(/[\x1b\\]\w+\[[^\]]*\]/gi);
        if (matches) {
            cNum += matches ? matches.length : 0;
            matches.forEach(match => str = str.replace(match, ""));
        }
        matches = str.match(/[\x1b\\]\w*/gi);
        if (matches) {
            cNum += matches ? matches.length : 0;
            matches.forEach(match => str = str.replace(match, ""));
        }
        return { str:str, cNum:cNum, cOk:cOk }
    };


    //- アイコンの作成
    function makeIcon(body, sprite, icd, x, y) {
        // アイコンスプライトの形成
        const iconSprite = createIconSprite(Number(icd.index));
        // アイコンZ座標
        iconSprite._zIndex = 1;
        // チルド
        sprite.addChild(iconSprite);
        // 変数セット
        if (!body._iconSpritesKe) { bpdy._iconSpritesKe = []; }
        body._iconSpritesKe.push(iconSprite);
        // 拡大率
        const iw = ImageManager.iconWidth;
        iconSprite.scale.x = icd.wd / iw;
        iconSprite.scale.y = icd.wd / iw;
        // 位置
        iconSprite.x = x;
        iconSprite.y = y;
    };



    //==================================================
    //--  文字列基本 /ベーシック
    //==================================================
    
    //- 文字列幅
    function strWidth(str, fontSize, halfSize = 1) {
        return strBytes(str, 0.5, halfSize) * fontSize;
    };
    
    
    //- 文字列バイト数
    function strBytes(str, rate = 1, halfSize = 1) {
        let byte = 0;
        for (var i = 0; i < str.length; i++) {
            var c = str.charCodeAt(i);
            if ((c >= 0x0 && c < 0x81) || (c === 0xf8f0) || (c >= 0xff61 && c < 0xffa0) || (c >= 0xf8f1 && c < 0xf8f4)) {
                byte += 1 * (rate * halfSize);
            } else {
                byte += 2 * rate;
            }
        }
        return byte;
    };
    
    
     //- 文字列をカラートーンに
    function strToColorTone(strs) {
        const red = strs["カラー赤"] || 0;
        const green= strs["カラー緑"] || 0;
        const blue = strs["カラー青"] || 0;
        const gray = strs["カラー灰"] || 0;
        if (!red && !green && !blue && !gray) { return null; }
        return [red, green, blue, gray];
    };
    
    
    //- 変数の置換
    function convertVariable(str) {
        if (!str) { return str; }
        str = str.toString();
        const matches = str.match(/[\x1b\\]v\[(\d+)\]/gi);
        if (!matches) { return str; }
        matches.forEach(parts => {
            const match = parts.match(/\\[vV]\[(\d+)\]/);
            const id = Number(match[1]);
            const val = $gameVariables.value(id);
            str = str.replace(match[0], val);
        });
        return str;
    };


    //- スタイルに応じたフォント設定
    function fontSettingByStyle(bitmap, style, word) {
        if (style[word+"フォント"]) { bitmap.fontFace = style[word+"フォント"]; }
        if (style[word+"文字サイズ"]) { bitmap.fontSize = getFontSize(style[word+"文字サイズ"]); }
        if (style[word+"文字色"]) { bitmap.textColor = style[word+"文字色"] || "rgba(255, 255, 255, 1)"; }
        if (style[word+"縁取り幅"]) { bitmap.outlineWidth = style[word+"縁取り幅"] || 4; }
        if (style[word+"縁取り色"]) { bitmap.outlineColor = style[word+"縁取り色"] || "rgba(0, 0, 0, 1)"; }
    };
    
    
    //- フォントサイズの取得
    function getFontSize(size) {
        const mainSize = $gameSystem.mainFontSize();
        if (!size) { return mainSize; }
        const sizeStr = size.toString();
        if (sizeStr.includes("+")) {
            const plus = Number(sizeStr.replace("+", ""));
            size = mainSize + plus;
        } else if (sizeStr.includes("-")) {
            const minus = Number(sizeStr.replace("-", ""));
            size = mainSize - minus;
        }
        return Number(size);
    };



    //==================================================
    //--  計算基本 /ベーシック
    //==================================================
    
    //- マルチ演算
    function calcMulti(cur, tage, ori, cmds = []) {
        if (tage == null) { return [{}]; }
        const datas = [cur, tage.toString(), ori, cmds];
        cur = cur || 0;
        let tageStr = tage.toString();
        let tageLine = tageStr.split(",");
        tageLine = tageLine.map(v => v.replace(/\s/g, ""));
        let sols = [];
        tageLine.forEach((tages, i) => {
             const match = tages.match(/^(r*m*s*\/|)([\+\*\/\%\=←→↑↓]*)(\-*\d+\.*\d*)~*(\-*\d*\.*\d*)([\+\*\/\%\=←→↑↓]*)(tn|cg|fk|cf|rd|bk|ei|eo|en|e|)(\(?\-*\d*\.*\d*\)?)(&*b*j*d*c*t*o*)(\_*\-?\d*\.*\d*)$/i);
            if (!match) {
                sols.push({ val:tages, header:"", easing:"", easingRate:1, extra:"", num:0, datas:datas });
                return;
            }
            let val = 0;
            let rvs = 1;
            let header = "";
            let easing = "";
            let easingRate = 1;
            let extra = "";
            let num = 1;
            let rand = null;
            if (match[1]) {
                header = match[1].replace(/\//g, "").toUpperCase();
                if (header.match(/r/i)) { rvs = -1; }
            }
            if (match[6]) {
                easing = match[6].toUpperCase();
            }
            if (match[7]) {
                const mt = match[7].match(/\-*\d+\.*\d*/);
                easingRate = mt ? Number(mt[0]) : 1;
            }
            if (match[8]) {
                extra = match[8].replace(/&/g, "").toUpperCase();
            }
            if (match[9]) {
                num = Number(match[9].replace(/\_/g, ""));
            }
            let v = 0;
            if (match[4]) {
                const vs = [Number(match[3]), Number(match[4])];
                vs.sort((a, b) => a - b);
                v = vs[0] + Math.random() * (vs[1] - vs[0]);
            } else {
                v = Number(match[3]);
            }
            const symbol = (match[2] || "") + (match[5] || "");
            if (symbol.includes("+")) {
                val = Number(cur) + v * rvs;
            } else if (symbol.includes("*")) {
                val = Number(cur) * v * rvs;
            } else if (symbol.includes("/")) {
                val = Number(cur) / v * rvs;
            } else if (symbol.includes("%")) {
                val = Number(cur) % v * rvs;
            } else if (symbol.includes("←")) {
                val = Number(cur) - v * rvs;
            } else if (symbol.includes("→")) {
                val = Number(cur) + v * rvs;
            } else if (symbol.includes("↑")) {
                val = Number(cur) - v * rvs;
            } else if (symbol.includes("↓")) {
                val = Number(cur) + v * rvs;
            } else {
                val = v * rvs;
                if (ori && !symbol.includes("=")) {
                    if (ori.toString().includes("*")) {
                        val *= Number(ori.replace(/\*/g, ""));
                    } else {
                        val += ori;
                    }
                }
            }
            cmds.forEach(cmd => {
                if (cmd.includes("+")) {
                    val += Number(cmd.replace(/\+/g, ""));
                } else if (cmd.includes("*")) {
                    val *= Number(cmd.replace(/\*/g, ""));
                } else if (cmd.includes("/")) {
                    val /= Number(cmd.replace(/\//g, ""));
                } else if (cmd.includes("%")) {
                    val %= Number(cmd.replace(/\%/g, ""));
                } else {
                    val = Number(cmd);
                }
            });
            sols.push({ val:val, header:header, easing:easing, easingRate:easingRate, extra:extra, num:num, datas:datas });
        });
        return sols;
    };
    
    
    //- 小数点を丸める
    function roundDecimal(val, rate) {
        const newVal = Math.floor(val* rate) / rate
        return newVal;
    };
    
    
    //- 時間の作成
    function makeTime(time) {
        if (!time) { return 0; }
        time = time.toString();
        if (time.includes("~")) {
            return randomise(time);
        } else {
            return convertSecond(time);
        }
    };


    //- ランダマイズ
    function randomise(str) {
        const strs = str.split("~");
        const vals = [convertSecond(strs[0]), convertSecond(strs[1])];
        vals.sort((a, b) => a - b);
        return vals[0] + Math.random() * (vals[1] - vals[0]);
    };


    //- 秒を変換
    function convertSecond(time) {
        return Math.round(Number(time.match(/(\d+\.?\d*)/)[0]) * (time.match(/s/i) ? 60 : 1));
    };
    
    

    //==================================================
    //--  イージング /ベーシック
    //==================================================

    //- イージングの適用
    function applyEasing(current, start, target, duration, timeMax, easing, easingRate = 1) {
        // イージングの処理
        if (easing.match(/ei|eo|e/i)) {
            return processEasing(current, target, duration + 1, timeMax, easing, easingRate);
        }
        // カービング
        if (easing.match(/tn|cg|fk|cf|rd|bk/i)) {
            return processCurving(current, start, target, duration + 1, timeMax, easing, easingRate);
        }
    };
    
    
    //- イージングの処理
    function processEasing(current, target, duration, timeMax, easing, easingRate = 1) {
        const lt = calcEasing((timeMax - duration) / timeMax, easing, easingRate);
        const t = calcEasing((timeMax - duration + 1) / timeMax, easing, easingRate);
        const start = (current - target * lt) / (1 - lt);
        return start + (target - start) * t;
    };
    
    
    //- イージングの計算
    function calcEasing(t, easing, easingRate = 1) {
        const exponent = 2 * easingRate;
        switch (easing.toUpperCase()) {
            case "EI":
                return easeIn(t, exponent);
            case "EO":
                return easeOut(t, exponent);
            case "E":
                return easeInOut(t, exponent);
            default:
                return t;
        }
    };
    
    
    //- 各イージング処理
    function easeIn(t, exponent) {
        return Math.pow(t, exponent) || 0.001;
    };
    
    function easeOut(t, exponent) {;
        return 1 - (Math.pow(1 - t, exponent) || 0.001);
    };
    
    function easeInOut(t, exponent) {
        if (t < 0.5) {
            return easeIn(t * 2, exponent) / 2;
        } else {
            return easeOut(t * 2 - 1, exponent) / 2 + 0.5;
        }
    };
    
    
    //- カービングの処理
    function processCurving(current, start, target, duration, timeMax, easing, easingRate = 1) {
        // 0 の時の処理
        if (duration <= 0) { return easing.match(/tn|rd|bk/i) ? start : target; }
        let result = 0;
        // ターン
        if (easing.toUpperCase() == "TN") {
            result = processTurn(current, start, target, duration, timeMax, easingRate);
        // チャージ
        } else if (easing.toUpperCase() == "CG") {
            result = processCharge(current, start, target, duration, timeMax, easingRate);
        // フック
        } else if (easing.toUpperCase() == "FK") {
            result = processFook(current, start, target, duration, timeMax, easingRate);
        // チャージフック
        } else if (easing.toUpperCase() == "CF") {
            result = processChargeFook(current, start, target, duration, timeMax, easingRate);
        // ラウンド
        } else if (easing.toUpperCase() == "RD") {
            result = processRound(current, start, target, duration, timeMax, easingRate);
        // バック
        }  else if (easing.toUpperCase() == "BK") {
            result = processBack(current, start, target, duration, timeMax, easingRate);
        }
        return result;
    };
    
    
    //- ターンの処理
    function processTurn(current, start, target, duration, timeMax, easingRate) {
        let result = 0;
        const d1 = Math.round(timeMax / 2);
        const d2 = timeMax - d1;
        if (duration > d2) {
            result = processEasing(current, target, duration - d2, d1, "eo", easingRate);
        } else {
            result = processEasing(current, start, duration, d2, "ei", easingRate);
        }
        return result;
    };
    
    
    //- チャージの処理
    function processCharge(current, start, target, duration, timeMax, easingRate) {
        let result = 0;
        const d1 = Math.round(timeMax / 3);
        const d2 = timeMax - d1;
        if (duration > d2) {
            result = processEasing(current, start + (start - target) * easingRate, duration - d2, d1, "e");
        } else {
            result = processEasing(current, target, duration, d2, "e");
        }
        return result;
    };
    
    
    //- フックの処理
    function processFook(current, start, target, duration, timeMax, easingRate) {
        let result = 0;
        const d1 = Math.round(timeMax * 2 / 3);
        const d2 = timeMax - d1;
        if (duration > d2) {
            result = processEasing(current, target + (target - start) * easingRate, duration - d2, d1, "e");
        } else {
            result = processEasing(current, target, duration, d2, "e");
        }
        return result;
    };
    
    
    //- チャージフックの処理
    function processChargeFook(current, start, target, duration, timeMax, easingRate) {
        let result = 0;
        const d1 = Math.round(timeMax / 4);
        const d3 = Math.round(timeMax / 4);
        const d2 = timeMax - d1 - d3;
        if (duration > (d2 + d3)) {
            result = processEasing(current, start + (start - target) * easingRate, duration - d2 - d3, d1, "e");
        } else if (duration > d3) {
            result = processEasing(current, target + (target - start) * easingRate, duration - d3, d2, "e");
        } else {
            result = processEasing(current, target, duration, d3, "e");
        }
        return result;
    };
    
    
    //- ラウンドの処理
    function processRound(current, start, target, duration, timeMax, easingRate) {
        let result = 0;
        const d1 = Math.round(timeMax / 4);
        const d2 = Math.round(timeMax / 2);
        const d3 = timeMax - d1 - d2;
        if (duration > (d2 + d3)) {
            result = processEasing(current, target, duration - d2 - d3, d1, "eo");
        } else if (duration > d3) {
            result = processEasing(current, start + (start - target) * easingRate, duration - d3, d2, "e");
        } else {
            result = processEasing(current, start, duration, d3, "ei");
        }
        return result;
    };
    
    
    //- バックの処理
    function processBack(current, start, target, duration, timeMax, easingRate) {
        let result = 0;
        const d1 = 1;
        const d2 = timeMax - d1;
        if (duration > d2) {
            result = processEasing(current, target, duration - d2, d1, "e", easingRate);
        } else {
            result = processEasing(current, start, duration, d2, "e", easingRate);
        }
        return result;
    };
    
    
    
    //==================================================
    //--  配列基本 /ベーシック
    //==================================================
    
    //- ハッシュのディープコピー
    function copyHash(hash) {
        const copy = {};
        Object.keys(hash).forEach(k => {
            if (hash[k].constructor.name == "Object") {
                copy[k] = copyHash(hash[k]);
            } else if (hash[k].constructor.name == "Array") {
                copy[k] = copyArray(hash[k]);
            } else {
                copy[k] = hash[k];
            }
        });
        return copy;
    };
    
    
    //- 配列のディープコピー
    function copyArray(array) {
        const copy = [];
        array.forEach((v, i) => {
            if (v.constructor.name == "Object") {
                copy[i] = copyHash(v);
            } else if (v.constructor.name == "Array") {
                copy[i] = copyArray(v);
            } else {
                copy[i] = v;
            }
        });
        return copy;
    };
    
    
    
    //==================================================
    //--  位置基本 /ベーシック
    //==================================================
    
    //- スクリーンX
    function screenX(x, anchor = 0.5) {
        const tw = $gameMap.tileWidth();
        return Math.floor($gameMap.adjustX(x) * tw + tw * anchor);
    };
    
    
    //- スクリーンY
    function screenY(y, anchor = 0.5) {
         const th = $gameMap.tileHeight();
        return Math.floor( $gameMap.adjustY(y) * th + th * anchor);
    };
    
    
    //- 角度を度数に
    function angleToDegree(angle) {
        angle *= (180 / Math.PI);
        if (angle < 0) { angle += 360; };
        return angle;
    };
    
    
    //- 角度をπに
    function angleToRadian(angle) {
        angle *= (Math.PI / 180);
        return angle;
    };
    
    
    //- ループ角度
    function loopAngle(angle) {
        let newAngle = angle;
        if (angle >= 360) { newAngle = angle % 360; } else
        if (angle < 0) { newAngle = angle < -1 ? 360 + angle % 360 : 0; }
        return newAngle;
    };
    
    
    //- ポイント間の距離を算出
    function pointsLength(ax, ay, bx, by) {
        const xLength = bx - ax;
        const yLength = by - ay;
        return Math.sqrt(xLength ** 2 + yLength ** 2);
    };
    
    
    //- ポイント間の角度を算出
    function pointsAngle(ax, ay, bx, by) {
        if (ax== bx && ay== by) { return null; }
        const radian = Math.atan2(by - ay, bx- ax);
        return angleToDegree(radian);
    };
    
    
    //- 角度から座標を算出
    function posFromAngle(ax, ay, radius, angle) {
        const radian = angleToRadian(angle);
        const x = ax + radius * Math.cos(radian);
        const y = ay + radius * Math.sin(radian);
        return { x:x, y:y }
    };



    //==================================================
    //--  位置基本 /ベーシック
    //==================================================
    
    //- 角度を度数に
    function angleToDegree(angle) {
        angle *= (180 / Math.PI);
        if (angle < 0) { angle += 360; };
        return angle;
    };
    
    
    //- 角度をπに
    function angleToRadian(angle) {
        angle *= (Math.PI / 180);
        return angle;
    };
    
    
    //- ループ角度
    function loopAngle(angle) {
        let newAngle = angle;
        if (angle >= 360) { newAngle = angle % 360; } else
        if (angle < 0) { newAngle = angle < -1 ? 360 + angle % 360 : 0; }
        return newAngle;
    };
    
    
    //- ポイント間の距離を算出
    function pointsLength(ax, ay, bx, by) {
        const xLength = bx - ax;
        const yLength = by - ay;
        return Math.sqrt(xLength ** 2 + yLength ** 2);
    };
    
    
    //- ポイント間の角度を算出
    function pointsAngle(ax, ay, bx, by) {
        if (ax== bx && ay== by) { return null; }
        const radian = Math.atan2(by - ay, bx- ax);
        return angleToDegree(radian);
    };
    
    
    //- 角度から座標を算出
    function posFromAngle(ax, ay, radius, angle) {
        const radian = angleToRadian(angle);
        const x = ax + radius * Math.cos(radian);
        const y = ay + radius * Math.sin(radian);
        return { x:x, y:y }
    };


    
    //==================================================
    //--  図形描画 /ベーシック
    //==================================================

    //- スクエアの塗り潰し
    function fillSquare(bitmap, x, y, w, h, color = "rgba(0,0,0,1)", roundLine = 0, roundEdge = 0, corner = "") {
        const context = bitmap.context;
        context.save();
        if (Array.isArray(color)) {
            const x1 = x + w;
            const y1 = y + h;
            const grad = context.createLinearGradient(x, y, x1, y1);
            grad.addColorStop(0, color[0]);
            grad.addColorStop(1, color[1]);
            context.fillStyle = grad;
        } else {
            context.fillStyle = color;
        }
        designSquare(bitmap, x, y, w, h, roundLine, roundEdge, corner);
        context.fill();
        context.restore();
        bitmap._baseTexture.update();
    };
    
    
    //- スクエアの線画
    function strokeSquare(bitmap, x, y, w, h, color = "rgba(0,0,0,1)", lineW = 1,  roundLine = 0, roundEdge = 0, corner = "") {
        const context = bitmap.context;
        context.strokeStyle = color;
        context.lineWidth = lineW;
        designSquare(bitmap, x, y, w, h, roundLine, roundEdge, corner, lineW);
        context.stroke();
        context.restore();
        bitmap._baseTexture.update();
    };
    
    
    //- スクエアのデザイン
    function designSquare(bitmap, x, y, w, h, roundLine = 0, roundEdge = 0, corner = "", lineW = 0, airUp) {
        const context = bitmap.context;
        context.beginPath();
        const x2 = x + w / 2;
        const y2 = y + h / 2;
        const x3 = x + w;
        const y3 = y + h;
        const c1 = corner.includes("1") ? 0 : roundEdge;    // 左上
        const c2 = corner.includes("2") ? 0 : roundEdge;    // 左下
        const c3 = corner.includes("3") ? 0 : roundEdge;    // 右上
        const c4 = corner.includes("4") ? 0 : roundEdge;    // 右下
        context.moveTo(x + c1,  y);
        // 右上
        if (roundLine && !airUp) {
            context.quadraticCurveTo(x2,  y + roundLine,  x3 - c3,  y);
        } else {
            context.lineTo(x3 - c3,  y);
        }
        context.quadraticCurveTo(x3,  y,  x3,  y + c3);
        // 右下
        if (roundLine) {
            context.quadraticCurveTo(x3 - roundLine,  y2,  x3,  y3 - c4);
        } else {
            context.lineTo(x3,  y3 - c4);
        }
        context.quadraticCurveTo(x3,  y3,  x3 - c4,  y3);
        // 左下
        if (roundLine) {
            context.quadraticCurveTo(x2,  y3 - roundLine,  x + c2,  y3);
        } else {
            context.lineTo(x + c2,  y3);
        }
        context.quadraticCurveTo(x,  y3,  x,  y3 - c2);
        // 左上
        if (roundLine) {
            context.quadraticCurveTo(x + roundLine,  y2,  x,  y + c1);
        } else {
            context.lineTo(x,  y + c1);
        }
        if (c1) {
            context.quadraticCurveTo(x,  y,  x + c1,  y);
        } else {
            context.lineTo(x,  y - lineW / 2);
        }
    };

})();