//=============================================================================
// TRP_ParticleMZ_ExPreset2.js
//=============================================================================
/*:
 * @target MZ
 * @author Thirop
 * @plugindesc 追加プリセット(レビューキャンペーン特典)
 * @base TRP_ParticleMZ_Preset
 * @orderAfter TRP_ParticleMZ_Preset
 *
 *
 * @help
 * ※「パーティクルプラグイン追加プリセットデータ集」を導入済みの場合は
 * 本プラグインを導入する必要はありません。
 *  
 *
 * 本プリセット用のサンプルマップはTRP_ParticlesMZ本体データの
 * バージョン1.04より追加されています。
 * 動作を確認される場合は、必要により購入履歴より再度ダウンロードいただき
 * 本プラグインをサンプルプロジェクトのjs/pluginsフォルダにコピペし
 * プラグインをインポートした上でご確認ｋづあさい。
 * 
 * また、サンプル「データ空間」用の各種データは本体データの
 * 「materials/tilesets/Particles_Digital.png」を使用してますので、
 * ご自身のプロジェクトで使う場合は画像ファイルをコピペしてご利用ください。
 *
 *
 * 【コマンド登録】
 * 「コマンド登録」コマンドを実行することでTRP_ParticleMZ_Presetの
 * コマンド一覧からも呼び出せるようになります。
 * TRP_ParticleMZ_Preset.jsファイルを上書きするため
 * 必ずバックアップを取ってから実行してください。
 *
 * 【更新履歴】
 * 1.00 2020/4/20  初版。
 *
 * 【収録設定データ】
 * 【パーティクルグループ】
 * digital_01_w <対象:weather> 01が並ぶ背景
 * digital_w <対象:weather> ＠素早く切り替わる文字
 * narration_fire_s <対象:screen> ＠ナレーション用、画面下部の炎
 * matrix_w <対象:weather> ＠マト○ックス風に文字が流れる演出
 * wind_w <対象:weather> ＠風の天候
 *
 *
 * @command register
 * @text コマンド登録<開発用/注意>
 * @desc TRP_ParticleMZ_Presetにコマンドを登録(バックアップをとっておくこと)
 *
 *
 * @requiredAssets img/particles/line_oval1
 * @requiredAssets img/particles/leaf1
 * @requiredAssets img/particles/flame1g
 * @requiredAssets img/particles/particle7
 * @requiredAssets img/particles/smoke2
 * @requiredAssets img/particles/smoke1
 * @requiredAssets img/tilesets/Particles_Digital
 */
//============================================================================= 


(()=>{
var pluginName = 'TRP_ParticleMZ_ExPreset2';
$dataTrpParticlePreset["_auto:0:wind_w/h"] = [4,[[0,1,1,1]],[[0,0,1,0],0.5],[[0,500,1,500],0.5],[[0,"#ffffff",1,"#ffffff"]],0,[1000,-200],null,[15,30],[0,0],0,0,0,[1,2],1,0.1,0.3,1,-1,1000,[5,0.1],1,[0,0],[-408,-312,100,624],0,0,null,6,
    "wind_wメイン：風の動き"];
$dataTrpParticlePreset["_sub:0:wind_w/h"] = [4,[[0,0.6,1,0]],[[0,0.25,1,0.25],1],[[0,0,1,0],1],[[0,"#8dffb6",1,"#8dffb6"]],0,[0,0],null,[0,0],[0,0],0,0,0,[0.5,0.5],1,0.01,1,1,-1,10000,[0,0],0,[0,0],null,0,0,"line_oval1",0,
    "wind_wサブ：風の軌跡"];
$dataTrpParticlePreset["_sub:1:wind_w/h"] = [4,[[0,0,0.5,1,1,0]],[[0,0.2,1,0.2],1],[[0,300,1,1],1],[[0,"#066f0b",1,"#46cf4c"]],1,[0,0],null,[0,0],[0,0],0,0,0,[1,1],0,0.15,0.5,1,-1,10000,[10,0.1],0,[0,0],null,0,0,"leaf1",0,
    "wind_wサブ2：風に舞う葉っぱ"];

$dataTrpParticlePreset["_auto:0:matrix_w/h"] = [4,[[0,0,1,0]],[[0,0,1,0],0.4],[[0,600,1,1000],0.7],[[0,"#ffffff",1,"#ffffff"]],0,[0,0],null,[90,90],[0,0],0,0,0,[1,1],1,0.15,1,1,-1,10000,[0,0],1,[0,0],[-404,-400,808,50],0,0,null,6,
    "matrix_wメイン：文字の流れ"];
$dataTrpParticlePreset["_sub:0:matrix_w/h"] = [4,[[0,1,1,0]],[[0,0.8,1,0.8],1],[[0,0,1,0],1],[[0,"#2ef1ff",1,"#5fffc0"]],0,[0,0],null,[0,0],[0,0],0,0,0,[3,3],1,0.04,1,1,-1,10000,[0,0],0,[0,0],null,0,0,"tile:Particles_Digital:17,tile:Particles_Digital:0,tile:Particles_Digital:22,tile:Particles_Digital:21,tile:Particles_Digital:35,tile:Particles_Digital:50,tile:Particles_Digital:82,tile:Particles_Digital:99,tile:Particles_Digital:85,tile:Particles_Digital:54,tile:Particles_Digital:68,tile:Particles_Digital:97,tile:Particles_Digital:41,tile:Particles_Digital:61,tile:Particles_Digital:92,tile:Particles_Digital:107,tile:Particles_Digital:137,tile:Particles_Digital:168,tile:Particles_Digital:170,tile:Particles_Digital:142,tile:Particles_Digital:100,tile:Particles_Digital:101,tile:Particles_Digital:102,tile:Particles_Digital:103,tile:Particles_Digital:112,tile:Particles_Digital:113,tile:Particles_Digital:114,tile:Particles_Digital:115,tile:Particles_Digital:116,tile:Particles_Digital:59,tile:Particles_Digital:105,tile:Particles_Digital:140",0,
    "matrix_wサブ：ランダムな文字"];

$dataTrpParticlePreset["_auto:0:digital_w/h"] = [4,[[0,0,1,0]],[[0,1,1,1],0.4],[[0,0,1,0],1],[[0,"#ffffff",1,"#ffffff"]],0,[0,0],null,[0,360],[0,0],0,0,0,[0.5,3],1,0.1,0.5,1,-1,10000,[0,0],1,[0,0],[-408,-312,816,624],0,0,null,6,
    "digital_wメイン：文字位置&需要"];
$dataTrpParticlePreset["_sub:0:digital_w/h"] = [4,[[0,0.5,1,0]],[[0,1.2,1,1.2],1],[[0,0,1,0],1],[[0,"#30eaff",1,"#30c8ff"]],0,[0,0],null,[0,0],[0,0],0,0,0,[0.072,0.072],0,0.072,1,1,-1,10000,[0,0],0,[0,0],null,0,0,"tile:Particles_Digital:0,tile:Particles_Digital:36,tile:Particles_Digital:66,tile:Particles_Digital:113,tile:Particles_Digital:115,tile:Particles_Digital:69,tile:Particles_Digital:18,tile:Particles_Digital:100,tile:Particles_Digital:101,tile:Particles_Digital:103,tile:Particles_Digital:10,tile:Particles_Digital:78,tile:Particles_Digital:123,tile:Particles_Digital:155,tile:Particles_Digital:141,tile:Particles_Digital:72",0,
    "digital_wサブ：すぐ消える１文字１文字"];
$dataTrpParticlePreset["_auto:0:digital_01_w/h"] = [4,[[0,0,1,0]],[[0,0,1,0],1],[[0,0,1,0],1],[[0,"#ffffff",1,"#ffffff"]],0,[0,0],null,[0,360],[0,0],0,0,0,[999999999,999999999],1,0.1,1,36,0.11,36,[0,0],4,[-396,-300],[0,0,0,0,0,24,0],0,0,null,6,
    "digital_01_wメイン：横並びの位置指定"];
$dataTrpParticlePreset["_sub:0:digital_01_w/h"] = [4,[[0,0.5,1,0.8]],[[0,0.6,1,0.6],1],[[0,0,1,0],1],[[0,"#2c90d2",1,"#2c90d2"]],0,[0,0],null,[0,0],[0,0],0,0,0,[0.09,0.09],1,0.072,1,20,-1,999999,[0,0],4,[0,0],[360,0,0,0,0,0,32],0,0,"tile:Particles_Digital:99,tile:Particles_Digital:100",0,
    "digital_01_wサブ：縦並びに01発生"];

$dataTrpParticlePreset["_auto:0:narration_fire_s/h"] = [4,[[0,0,0.15,1,1,0]],[[0,2,1,0],0.5],[[0,200,0.2,100,1,100],0.5],[[0,"#ff2e2e",1,"#ffb92e"]],0,[0,0],null,[-80,-100],[50,-50],0,2,0,[0.8,1],1,0.005,0.5,1,-1,10000,[0,0],1,[0,0],[-408,350,816,0],0,0,"smoke2,smoke1",6,
    "narration_fire_sメイン：画面下部の炎"];
[4,[[0,0,0.5,1,1,0]],[[0,0,0.5,0.2,1,0],0.1],[[0,100,1,0],1],[[0,"#ff4242",1,"#ffdf42"]],0,[0,0],null,[0,360],[0,0],0,0,0,[1,1],1,0.1,0.5,1,0.11,10000,[5,0.1],0,[0,0],null,0,0,"flame1g,particle7",0,
    "narration_fire_sサブ：小さな火の粉"];

//groups
$dataTrpParticleGroupsPreset.wind_w = {"repeat":-1,"list":["set _auto:0 target","sub set _auto:0 _sub:0 0 -1 0 1 1","sub set _auto:0 _sub:1 0 -1 0.3 0 0"],"targetType":6,
    "comment":"風の天候"};

$dataTrpParticleGroupsPreset.matrix_w = {"repeat":-1,"list":["set _auto:0 weather def above","sub set _auto:0 _sub:0 0 -1 0 0 1","loop _auto:0 48 1000","filter _auto:0 glow 8 2 9.5 0 255 255"],"targetType":6,
    "comment":"マト○ックス風に文字が流れる演出"};
$dataTrpParticleGroupsPreset.digital_w = {"repeat":-1,"list":["set _auto:0 target","sub set _auto:0 _sub:0 0 -1 0 0 1","loop _auto:0 48 1000","filter _auto:0 glow 10 10 9.5 0 200 255"],"targetType":6,
    "comment":"素早く切り替わる文字"};
$dataTrpParticleGroupsPreset.digital_01_w = {"repeat":-1,"list":["set _auto:0 target def back","sub set _auto:0 _sub:0 0 -1 0 0 0","filter _auto:0 glow 1 3 20 0 200 255","loop _auto:0 24 24"],"targetType":6,
    "comment":"01が並ぶ背景"};

$dataTrpParticleGroupsPreset.narration_fire_s = {"repeat":-1,"list":["set _auto:0 target","sub set _auto:0 _sub:0 0.3 -1 0.5 1 0"],"targetType":6,
    "comment":"ナレーション用、画面下部の炎"};



/* register command
===================================*/
if(!Utils.isOptionValid('test'))return;

PluginManager.registerCommand(pluginName, 'register', function(args){
    var database = $dataTrpParticlePreset;
    var keys = Object.keys(database);
    keys.sort();
    var length = keys.length;
    
    file = '';
    file += '//=============================================================================\n';
    file += '// TRP_ParticlePreset.js\n';
    file += '//=============================================================================\n';
    file += '/'+'*:\n';
    file += ' * @target MZ\n';
    file += ' * @base TRP_ParticleMZ\n';
    file += ' * @plugindesc パーティクルプリセットデータ\n';
    file += ' * @help\n';

    var images = [];
    var idx = 0;
    for(var i = 0; i<length; i=(i+1)|0){
        var key = keys[i];
        var data = database[key];

        var isHidden = Game_Particle.isIdHidden(key)

        if(Array.isArray(data)){
            data = Game_Particle.decompressConfigDataFromArray(data);
        }
        var imageStr = data.image;
        var targetType = data.targetType;
        var comment = data.comment;
        if(!isHidden){
            if(idx++>0){
                file += '\n';
            }
            file += ' * '+ParticleEditor.helpFileListText(key,targetType,comment);
        }

        if(imageStr){
            imageStr.split(',').forEach(function(image){
                if(image.indexOf('tile:')===0)return;
                if(image.indexOf('ANIM:')===0){

                }else if(!images.contains(image)){
                    images.push(image);
                }
            });
        }
    }

    file += '\n *\n *\n * 【パーティクルグループ】\n';
    var database = $dataTrpParticleGroupsPreset;
    var keys = Object.keys(database);
    keys.sort();
    var length = keys.length;
    var idx = 0;
    for(var i = 0; i<length; i=(i+1)|0){
        var key = keys[i];
        if(Game_Particle.isIdHidden(key)){
            continue;
        }
        var data = database[key];
        if(idx++>0){
            file += '\n';
        }
        var targetType = data.targetType;
        var comment = data.comment;
        file += ' * '+ParticleEditor.helpFileListText(key,targetType,comment);
    }
    file += '\n *';
    file += ParticleEditor.prototype.helpPluginCommandTexts.call(this,$dataTrpParticlePreset);
    file += '\n *\n *';
    file += ParticleGroupEditor.prototype._helpPluginCommandTexts.call(this,$dataTrpParticleGroupsPreset);
    file += '\n *';
    var length = images.length;
    for(var i = 0; i<length; i=(i+1)|0){
        file += '\n * @requiredAssets img/particles/'+images[i];
    }
    file += '\n *'+'/';


    /* read preset file
    ===================================*/
    var helpTexts = file;
    var filePath = 'js/plugins/TRP_ParticleMZ_Preset.js';

    var fs = require('fs');
    var path = require('path');
    var base = path.dirname(process.mainModule.filename);
    filePath = path.join(base, filePath);

    var file = fs.readFileSync(filePath,{ encoding: "utf8" });

    var index = file.indexOf('*'+'/');
    file = helpTexts + file.substring(index+2);

    fs.writeFileSync(filePath,file);

    $gameMessage.add('\x1b>'+pluginName+'の収録データの呼び出しコマンドを')
    $gameMessage.add('\x1b>TRP_ParticleMZ_Presetに登録しました。');
});


})();