//=============================================================================
// YKP_BattleInsertEvent.js
//
// Copyright (c) 2022 YukiKamijo
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
//=============================================================================

var Imported = Imported || {};
Imported.YKP_BattleInsertEvent = true;

var YukiKP = YukiKP || {};
YukiKP.BattleInsertEvent = YukiKP.BattleInsertEvent || {};

/*:
 * @plugindesc 戦闘時にイベントを割り込ませるプラグイン。
 * @target MZ
 * @author YukiKamijo
 * 
 * @param ActorActionCommonEventId
 * @desc アクターが行動するたびに実行するコモンイベントID。(0は無効)
 * @text コモンイベントID
 * @type number
 * @default 0
 *
 * @help
 * 戦闘時にイベントを割り込ませるプラグインです。
 * 
 * スキル実行によるコモンイベントや敵ＨＰが０の時に発生するイベントなど
 * 敵に「不死身」ステートを付与せずに実行することが可能となります。
 * 
 * ただし、実行されるイベントは敵消滅エフェクトの後になっているため
 * 敵消滅エフェクト前にイベント実行したい場合は
 * エネミーに「不死身」ステートを付与しておく必要があります。
 * 
 * また、アクターが行動するたびに特定のコモンイベントを実行させることも可能です。
 *
 * plugin version 1.0.0
 */

(() => {
    'use strict';
    const pluginName = 'YKP_BattleInsertEvent';
    const parameters = PluginManager.parameters(pluginName);
    
	const ActorActionCommonEventId = Number(parameters['ActorActionCommonEventId']);;

    BattleManager.updateEventMain = function() {
        $gameTroop.updateInterpreter();
        $gameParty.requestMotionRefresh();
        if ($gameTroop.isEventRunning()) return true;
        $gameTroop.setupBattleEvent();
        if ($gameTroop.isEventRunning() || this.checkBattleEnd() || SceneManager.isSceneChanging()) {
            return true;
        }
        return false;
    };

	YukiKP.BattleInsertEvent.GameActor_performActionEnd = Game_Actor.prototype.performActionEnd;
	Game_Actor.prototype.performActionEnd = function(){
		YukiKP.BattleInsertEvent.GameActor_performActionEnd.apply(this, arguments);
        if (ActorActionCommonEventId !== 0) {
            $gameTemp.reserveCommonEvent(ActorActionCommonEventId);
        }
	}
})();