//===================================================================
//MessageBackGroundSet.js
//メッセージウィンドウ背景指定プラグイン
//===================================================================
//■改変元
//Copyright (c) 2018 蔦森くいな
//Released under the MIT license.
//http://opensource.org/licenses/mit-license.php
//-------------------------------------------------------------------
//blog   : http://paradre.com/
//Twitter: https://twitter.com/Kuina_T
//===================================================================
//＜更新情報＞
//　ver1.0.0 2018/06/02 初版
//===================================================================

/*:
 * @target MZ
 * @plugindesc メッセージウィンドウ背景のデフォルト値を指定するプラグイン
 * @author 蔦森くいな (改変 宗盛ゼツキヨ)
 *
 * @help 「文章の表示」コマンドで表示されるメッセージウィンドウの背景を指定した物に変更します。
 * デフォルトで「ウィンドウ」が指定されていますが、これを強制的に変更します。
 *
 * プラグイン管理画面のパラメータから有効にするスイッチとデフォルト値を指定して下さい。
 * プラグインコマンドChangeBackgroundSwitchCheckにより、
 * 「文章の表示」コマンドの背景が「ウィンドウ」の時に
 * プラグインで指定した「暗くする」や「透明」の背景が適用されます。
 *
 * プラグインコマンドにて直接指定も可能です。
 * ChangeBackgroundにて数値を指定して変更できます。
 * 通常の設定に戻す場合はResetBackground。
 *
 * @command ResetBackground
 * @text 通常のウィンドウに戻す
 *
 * @command ChangeBackground
 * @text ウィンドウの変更
 * @desc 番号を指定して変更します。
 * @arg 変更後
 * @type select
 * @option 通常
 * @value 0
 * @type select
 * @option 暗くする
 * @value 1
 * @option 透明
 * @value 2
 * @desc 変更したいメッセージウィンドウのタイプを選択
 * @default 0
 *
 * @command ChangeBackgroundSwitchCheck
 * @text ウィンドウの変更(スイッチ判定有)
 *
 * @param BackgroundSwitch
 * @text 切り替えスイッチ
 * @type switch
 * @desc ONの時のみ切り替えが有効となるスイッチ
 * 未指定の場合は常に有効とします。
 *
 * @param 背景タイプ
 * @type select
 * @option 通常
 * @value 0
 * @type select
 * @option 暗くする
 * @value 1
 * @option 透明
 * @value 2
 * @desc スイッチONでChangeBackgroundSwitchCheck起動時に変更するタイプ
 * @default 0
 */
/* 利用規約：
 * このプラグインは商用・非商用を問わず無料でご利用いただけます。
 * どのようなゲームに使っても、どのように加工していただいても構いません。
 * MIT Licenseにつき著作権表示とライセンスURLは残しておいて下さい。
 */

(() => {
    'use strict';
     const pluginName = "MessageBackGroundSet";
     const bgparam = PluginManager.parameters(pluginName);

    //メッセージウィンドウの背景を強制的に変更する
    const pd_MBGS_Game_Message_setBackground = Game_Message.prototype.setBackground;

PluginManager.registerCommand(pluginName,"ResetBackground",()=>{
    Game_Message.prototype.setBackground = function(background) {
        if (background === 0) background = 0;
        pd_MBGS_Game_Message_setBackground.call(this, background);
    };
});

PluginManager.registerCommand(pluginName,"ChangeBackground", (arg) =>{
    const num = Number(arg.変更後)
    Game_Message.prototype.setBackground = function(background) {
        if (background === 0) background = num;
        pd_MBGS_Game_Message_setBackground.call(this, background);
    };
});

PluginManager.registerCommand(pluginName,"ChangeBackgroundSwitchCheck",()=>{
    var bgSwitch = Number(bgparam["BackgroundSwitch"]);
    //スイッチがONの時、設定したスイッチがONの時設定を有効に
    if( $gameSwitches.value(bgSwitch) ) {
        Game_Message.prototype.setBackground = function(background) {
           var groundparam = Number(bgparam['背景タイプ']);
           if (background === 0) background = groundparam;
           pd_MBGS_Game_Message_setBackground.call(this, background);
        };
    }
    else{
        //初期化
        Game_Message.prototype.setBackground = function(background) {
            if (background === 0) background = 0;
            pd_MBGS_Game_Message_setBackground.call(this, background);
        };
    };
});

function resetBackground() {
    const pd_MBGS_Game_Message_setBackground = Game_Message.prototype.setBackground;
}

})();
