//=============================================================================
// Keke_MenuFreeSpace - メニュー自由欄
// バージョン: 1.1.3
//=============================================================================
// Copyright (c) 2023 ケケー
// Released under the MIT license
// http://opensource.org/licenses/mit-license.php
//=============================================================================

/*:
 * @target MZ
 * @plugindesc メニューに自由欄や立ち絵を追加する
 * @author ケケー
 * @url https://kekeelabo.com
 * 
 * @help
 * 【ver.1.1.3】
 * メニューの各所に何を書いてもいい自由欄を追加する
 * 具体的には以下の3つ
 * ◎ステータス自由欄
 * ◎ステータスヘルプ欄
 * ◎一言メッセージ(UIボタンエリアの自由欄)
 * さらに加えて
 * ◎ステータス立ち絵
 * の機能も
 * 自由欄の表示内容はいくつも登録しておき、条件で切り替え可能
 * ストーリー進行と共に切り替えるなど
 * 
 * ● 使い方 ●
 * 
 * ■【最初に】機能を試してみる
 * 好きなアクターのメモ欄に
 * <ステータス自由欄: プリシア>
 * と記入してテストプレイ、メニューを開いてみよう
 * 
 * 
 * ■【機能1】ステータスの自由欄/ヘルプ欄の表示内容を設定
 * 
 * 手順の流れ
 * [1]プラグインパラメータでテキスト登録
 * [2]プラグインパラメータで自由欄パック登録
 * [3]データベースのメモ欄で表示する自由欄パックを指定
 * 
 * ▼[手順1]プラグインパラメータ → テキスト登録　で、
 * 　テキスト内容を作成・登録
 * 
 * ▼[手順2]プラグインパラメータ → 自由欄パック登録　で、
 * 　自由欄パックを作成・登録
 * ◎自由欄パックとはテキストデータの詰め合わせ
 * 　テキストデータを何個でも登録できる
 * ◎テキストデータには「条件」を設定でき、
 * 　リストの上から「最初に条件を満たしたテキストデータ」が選択される
 * 　条件が空の場合も条件を満たしたことになる
 * ◎選択されたテキストデータが実際に自由欄に表示される
 * 　正確には、テキストデータ内の「呼ぶテキスト」により
 * 　呼び出されたテキストが表示される
 * ◎「呼ぶテキスト」には、
 * 　【1】のテキスト登録で作成したテキストのテキスト名を書く
 * 　するとそのテキストを呼び出せる
 * ◎テキストデータのリストはふたつある
 * 　「自由欄テキスト」と「ヘルプテキスト」
 * 　その名の通り自由欄テキストの方は自由欄に表示され、
 * 　ヘルプテキストはヘルプ欄に表示される
 * ◎なお自由欄はステータスの経験値の欄に表示される
 * 　当然、経験値は見れなくなるが、必要なら自由欄の中に、
 * 　現在の経験値: a.currentExp()
 * 　次のレベルまで: a.nextRequiredExp()
 * 　と入力することで表示可能
 * ◎さらにステータス画面に表示する立ち絵を設定することも可能 　
 *
 * ▼[手順3]データベースのメモ欄で表示する自由欄パックを指定
 * ◎アクター、職業、スキル、アイテム、武器、防具、敵キャラ、ステートのメモ欄に
 * 　<ステータス自由欄: パック名>
 * ★例)
 * <ステータス自由欄: プリシア>
 * 　自由欄パック『プリシア』を自由欄に表示する
 * 
 * 
 * ■【機能2】一言メッセージの表示内容を設定
 * 
 * 手順の流れ
 * [1]プラグインパラメータでテキスト登録
 * [2]プラグインパラメータで一言メッセージ登録
 * 
 * ▼[手順1]プラグインパラメータ → テキスト登録　で、
 * 　テキスト内容を作成・登録
 * 
 * ▼[手順2]プラグインパラメータ → 一言メッセージ登録　で、
 * 　一言メッセージを作成・登録
 * ◎一言メッセージとはUIボタンエリア欄に表示されるテキストのこと
 * ◎一言メッセージ登録はテキストデータの詰め合わせ
 * 　テキストデータを何個でも登録できる
 * ◎テキストデータには「条件」を設定でき、
 * 　リストの中から「条件を満たした全てのテキストデータ」が選択される
 * 　条件が空の場合も条件を満たしたことになる
 * ◎選択されたテキストデータが順番に表示される
 * 　メニューを開くたびに次のテキストに変わる。最後までいったら最初に戻る
 * ◎正確には、テキストデータ内の「呼ぶテキスト」により
 * 　呼び出されたテキストが表示される
 * ◎「呼ぶテキスト」には、
 * 　【1】のテキスト登録で作成したテキストのテキスト名を書く
 * 　するとそのテキストを呼び出せる
 * ◎一言メッセージの内容を変更した際には、
 * 　表示順を初期化することをオススメ
 * 　プラグインコマンド → 一言メッセージ初期化　で初期化できる
 * 
 * 
 * ■【機能3】レイアウトを設定
 * 
 * ◎ステータス自由欄のレイアウトなら、
 * プラグインパラメータ → ステータス自由欄
 * 
 * ◎ステータスヘルプ欄のレイアウトなら、
 * プラグインパラメータ → ステータスヘルプ
 * 
 * ◎一言メッセージのレイアウトなら、
 * プラグインパラメータ → 一言メッセージ
 * 
 * 
 * 【機能2】立ち絵のアニメーションを設定
 * ◎アニメーションを登録する
 *  プラグインパラメータ → アニメーション登録
 * 　)新しい項目を追加
 * 　)好きな『アニメ名』を付け
 * 　)『アニメ時間』を好きな長さに設定
 * 　)『アニメ回数』は基本的に 1 でいいが、ループさせる場合は -1 に
 * 　※アニメ書式1 - 変動
 * 　　たとえば位置Xの場合、『位置X』と『→位置X』が存在する
 * 　　これは『位置X』から『→位置X』へと変動するという意味
 * 　　つまり『位置X』が -400、『→位置X』が 0 の場合は、
 * 　　画面X座標 -400 から 0 に向かって移動する
 * 　※アニメ書式2 - 計算記号
 * 　　『位置X』を +100 と書いた場合
 * 　　　=> 現在のX座標から +100 の位置に移動
 * 　　『位置X』を +-100 と書いた場合
 * 　　　=> 現在のX座標から -100 の位置に移動
 * 　　『スケールX』を *2 と書いた場合
 * 　　　=> X拡大率を現在の値から 2倍 にする
 * 　　『スケールX』を /2 と書いた場合
 * 　　　=> X拡大率を現在の値から 1/2倍 にする
 * 　※アニメ書式2 - イージング
 * 　　　値の語尾にイージング記号を付けることでイージング可能
 * 　　『位置X』を +100 eo と書くなど
 * 　　 ◇e - イージングインアウト。ゆっくり-速い-ゆっくり。標準はこれ
 * 　　 ◇ei -イージングイン。ゆっくり-速い
 * 　　 ◇eo -  イージングアウト。速い-ゆっくり
 * 　　 ◇en - イージングなし
 * 　　 ◇tn - ターン。→←。進んで戻る
 * 　　 ◇cg - チャージ。←→→。少し戻り一気に進む。cg(**)で戻り幅 **倍
 * 　　 ◇fk - フック。→→←。一気に進んで少し戻る。fk(**)で戻り幅 **倍
 * 　　 ◇cf - チャージフック。←→→←。cg と fk の融合。cf(**)で戻り幅 **倍
 * 　　 ◇rd - ラウンド。→←←→。ぐるりと円を描く
 * 　　 ◇bk - バック。←。戻ってくる
 * 　※アニメ書式3 - 実行回数
 * 　　　語尾に _2 と付けるとアニメを2回実行する。_3 なら3回
 * ◎アニメーションはサンプルがいくつか入っているので、それを使ってもよい
 * ◎立ち絵に適用する
 * 　プラグインパラメータ → 自由欄パック → 立ち絵 → 開始アニメ/表示中アニメ
 * 　)登録したアニメの『アニメ名』を記入
 * 
 * 
 * ● 利用規約 ●
 * MITライセンスのもと、自由に使ってくれて大丈夫です
 * 
 * 
 * 
 * Add free space where you can write anything you want 
 *  in various parts of the menu
 * Specifically, the following three
 * ◎ Free space in status
 * ◎ help space in status
 * ◎ Short message (free space in UI button area)
 * In addition, 
 * ◎ Standing Picture in status
 * Such a function is also
 * You can register a number of display contents in the free space 
 *  and switch them according to conditions.
 * Switch as the story progresses, etc.
 *
 * ● How to use ●
 *
 * ■ [First] Try out the function
 * In the memo field for your favorite actor, write
 * <statusFreeSpace: priscia>
 * and try a test play, then open the menu.


 * ■ [Function 1] Set the display contents of the status free space/help space
 * 
 * Procedure flow
 * [1] TextMaking with plugin parameters
 * [2] FreePackMaking with plugin parameters
 * [3] Specify the text pack to be displayed in the database memo field
 *
 * ▼[Step 1] Plugin parameters → TextMaking,
 * Create and register text content
 *
 * ▼[Step 2] Plugin parameters → FreePackMaking,
 * Create and register free packs
 * ◎ What is a free pack? An assortment of text data
 * Any number of text data can be registered
 * ◎ “Condition” can be set for text data,
 * "The first text data that satisfies the condition" is selected 
 *  from the top of the list.
 * Even if the condition is empty, the condition is met
 * ◎ The selected text data is actually displayed in the free field.
 * To be exact, it depends on the "CallText" in the text data.
 * The called text is displayed
 * ◎ “CallText” includes
 * Write the text name of the text maked in [1] text making
 * Then you can call the text
 * ◎ There are two lists of text data.
 * "FreeSpaceText" and "HelpText"
 * As the name suggests, free space text is displayed in the free space,
 * Help text is displayed in the help space
 * ◎ The free space is displayed in the experience value space of the status.
 * Of course, you will not be able to see your experience points, 
 * but if you wish, you can enter them in the free space.
 * Total exp: a.currentExp()
 * Next level exp: a.nextRequiredExp()
 * Can be displayed by entering
 * ◎ You can also set the standing picture on the status.
 *
 * ▼[Step 3] Specify the free pack to be displayed 
 *  in the memo field of the database
 * ◎ In the memo field for actors, occupations, skills, items, weapons, armor, 
 *  enemy characters, and states.
 * <statusFreeSpace: packName>
 * ★Example)
 * <statusFreeSpace: pricia>
 * Display the free pack "pricia" in the free space
 *
 *
 * ■[Function 2] Set the display content of the short message
 * 
 * Procedure flow
 * [1] TextMaking with plugin parameters
 * [2] ShortMessageMaking width plugin parameters
 *
 * ▼[Step 1] Plugin parameters → TextMaking,
 * Create and register text content
 *
 * ▼[Step 2] Plugin parameters → ShortMessageMaking,
 * Create and register a short message
 * ◎ Short message is the text displayed from the UI button area column.
 * ◎ Short message making is an assortment of text data
 * Any number of text data can be registered
 * ◎ “Conditions” can be set for text data,
 * "All text data that meets the conditions" is selected from the list
 * Even if the condition is empty, the condition is met
 * ◎ Selected text data will be displayed in order
 * The text changes to the following every time the menu is opened
 * When you get to the end, go back to the beginning
 * ◎ Accurately, depend on the "CallText" in the text data
 * The called text is displayed
 * ◎ “CallText” includes
 * Write the text name of the maked text in [1] text registration
 * Then you can call the text
 * ◎ When changing the content of a short message,
  * It is recommended to initialize the display order.
  * Can be initialized with plugin command → InitShortMessage
 *
 *
 * ■[Function 3] Set layout
 *
 * ◎ For the status free space layout,
 * Plugin parameters → StatusFreeSpace
 *
 * ◎ For the layout of the status help space,
 * Plugin parameters → StatusHelp
 *
 * ◎ For a short message layout,
 * Plugin parameters → ShortMessage
 * 
 * 
 * [Feature 4] setting standing picture animation
 * ◎ Register animation
 * 　Plugin parameters → animeMaking
 * 　) Add new item
 * 　) Add your favorite "animeName"
 * 　) Set "animeTime" to your desired length
 * 　) "animeTimes" is basically 1,
 * 　　but if you want it to loop, set it to -1
 * 　※ Animation format 1 - variation
 * 　　For example, in the case of position X,
 * 　　there are "posX" and "→ posX"
 * 　　This means that it fluctuates from "posX" to "→ posX"
 * 　　In other words, if "posX" is -400 and "→ posX" is 0,
 * 　　Move from screen X coordinate -400 to 0
 * 　※ Animation format 2 - calculation symbol
 * 　　When "posX" is written as +100
 * 　　=> Move to +100 position from current X coordinate
 * 　　When "posX" is written as +-100
 * 　　=> Move to position -100 from current X coordinate
 * 　　When "scaleX" is written as *2
 * 　　=> Double the X magnification from current value
 * 　　When "scaleX" is written as /2
 * 　　=> Set the X magnification ratio to 1/2 from current value
 * 　※ Animation format 2 - Easing
 * 　　Easing is possible by adding an easing symbol to the end of the value
 * 　　For example, write "posX" as +100eo
 * 　　◇e - Easing In Out. Slow-fast-slow. the standard is this
 * 　　◇ei - Easing in. slow-fast
 * 　　◇eo - Easing out. fast-slow
 * 　　◇en - Easing nothing.
 * 　　◇tn - turn. →←. willing to go back
 * 　　◇cg - charge. ←→→. Go back a little and move on.
 * 　　　　Return width ** times with cg(**)
 * 　　◇fk - Hook. →→←. Go forward and back a little.
 * 　　　　Return width ** times with fk(**)
 * 　　◇cf - Charge hook. ←→→←. Fusion of cg and fk.
 * 　　　　Return width ** times with cf(**)
 * 　　◇rd - Round. →←←→. draw a circle around
 * 　　◇bk - Back. ←. Come back
 * 　※ Animation format 3 - Number of times to run
 * 　　If you add _2 to the end of the word, the animation will run twice. 
 * 　　If you add _3, it will run three times.
 * ◎ There are some animation samples, so you can use them.
 * ◎ apply to standing picture
 * 　Plug-in parameters → freePackMaking → standingPicture → openAnime/inAnime
 * 　) Write the "animeName" of the registered anime
 *
 *
 * ● Terms of Use ●
 * You can use it freely under the MIT license.
 * 
 *
 *
 * @param 自由欄パック登録
 * @desc freePackMaking ステータス自由欄に表示するテキスト群を登録する。メモ欄から<ステータス自由欄: パック名>で呼び出せる
 * @type struct<freePackMake>[]
 * @default 
 * 
 * @param 自由欄パック_1
 * @parent 自由欄パック登録
 * @desc freePackMaking ステータス自由欄に表示するテキスト群を登録する。メモ欄から<ステータス自由欄: パック名>で呼び出せる
 * @type struct<freePackMake>[]
 * @default ["{\"パック名\":\"リード\",\"自由欄テキスト\":\"[\\\"{\\\\\\\"条件\\\\\\\":\\\\\\\"true\\\\\\\",\\\\\\\"呼ぶテキスト\\\\\\\":\\\\\\\"追加能力値c\\\\\\\"}\\\"]\",\"ヘルプテキスト\":\"[\\\"{\\\\\\\"条件\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"呼ぶテキスト\\\\\\\":\\\\\\\"リードh\\\\\\\"}\\\"]\",\"立ち絵\":\"[\\\"{\\\\\\\"条件\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"画像\\\\\\\":\\\\\\\"Actor1_1\\\\\\\",\\\\\\\"レイヤー\\\\\\\":\\\\\\\"上層\\\\\\\",\\\\\\\"原点X\\\\\\\":\\\\\\\"0.5\\\\\\\",\\\\\\\"原点Y\\\\\\\":\\\\\\\"0.5\\\\\\\",\\\\\\\"位置X\\\\\\\":\\\\\\\"-20\\\\\\\",\\\\\\\"位置Y\\\\\\\":\\\\\\\"20\\\\\\\",\\\\\\\"位置寄せX\\\\\\\":\\\\\\\"右寄せ\\\\\\\",\\\\\\\"位置寄せY\\\\\\\":\\\\\\\"下寄せ\\\\\\\",\\\\\\\"スケールX\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"スケールY\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"横幅\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"高さ\\\\\\\":\\\\\\\"gh\\\\\\\",\\\\\\\"回転角\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"不透明度\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"カラー赤\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"カラー緑\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"カラー青\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"カラー灰\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"開始アニメ\\\\\\\":\\\\\\\"突進1, 突進2, ぷるん\\\\\\\",\\\\\\\"表示中アニメ\\\\\\\":\\\\\\\"呼吸\\\\\\\",\\\\\\\"無効\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"条件\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"画像\\\\\\\":\\\\\\\"Actor1_1\\\\\\\",\\\\\\\"レイヤー\\\\\\\":\\\\\\\"上層\\\\\\\",\\\\\\\"原点X\\\\\\\":\\\\\\\"0.5\\\\\\\",\\\\\\\"原点Y\\\\\\\":\\\\\\\"0.5\\\\\\\",\\\\\\\"位置X\\\\\\\":\\\\\\\"-20\\\\\\\",\\\\\\\"位置Y\\\\\\\":\\\\\\\"20\\\\\\\",\\\\\\\"位置寄せX\\\\\\\":\\\\\\\"右寄せ\\\\\\\",\\\\\\\"位置寄せY\\\\\\\":\\\\\\\"下寄せ\\\\\\\",\\\\\\\"スケールX\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"スケールY\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"横幅\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"高さ\\\\\\\":\\\\\\\"gh\\\\\\\",\\\\\\\"回転角\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"不透明度\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"カラー赤\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"カラー緑\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"カラー青\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"カラー灰\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"開始アニメ\\\\\\\":\\\\\\\"左から出る2, きめる-小\\\\\\\",\\\\\\\"表示中アニメ\\\\\\\":\\\\\\\"呼吸\\\\\\\",\\\\\\\"無効\\\\\\\":\\\\\\\"\\\\\\\"}\\\"]\"}","{\"パック名\":\"プリシア\",\"自由欄テキスト\":\"[\\\"{\\\\\\\"条件\\\\\\\":\\\\\\\"true\\\\\\\",\\\\\\\"呼ぶテキスト\\\\\\\":\\\\\\\"追加能力値c\\\\\\\"}\\\"]\",\"ヘルプテキスト\":\"[\\\"{\\\\\\\"条件\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"呼ぶテキスト\\\\\\\":\\\\\\\"プリシアh\\\\\\\"}\\\"]\",\"立ち絵\":\"[\\\"{\\\\\\\"条件\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"画像\\\\\\\":\\\\\\\"Actor1_2\\\\\\\",\\\\\\\"レイヤー\\\\\\\":\\\\\\\"上層\\\\\\\",\\\\\\\"原点X\\\\\\\":\\\\\\\"0.5\\\\\\\",\\\\\\\"原点Y\\\\\\\":\\\\\\\"0.5\\\\\\\",\\\\\\\"位置X\\\\\\\":\\\\\\\"-100\\\\\\\",\\\\\\\"位置Y\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"位置寄せX\\\\\\\":\\\\\\\"右寄せ\\\\\\\",\\\\\\\"位置寄せY\\\\\\\":\\\\\\\"下寄せ\\\\\\\",\\\\\\\"スケールX\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"スケールY\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"横幅\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"高さ\\\\\\\":\\\\\\\"gh\\\\\\\",\\\\\\\"回転角\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"不透明度\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"カラー赤\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"カラー緑\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"カラー青\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"カラー灰\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"開始アニメ\\\\\\\":\\\\\\\"手前から出る2, ぷるん-微\\\\\\\",\\\\\\\"表示中アニメ\\\\\\\":\\\\\\\"呼吸\\\\\\\",\\\\\\\"無効\\\\\\\":\\\\\\\"\\\\\\\"}\\\"]\"}","{\"パック名\":\"ゲイル\",\"自由欄テキスト\":\"[\\\"{\\\\\\\"条件\\\\\\\":\\\\\\\"true\\\\\\\",\\\\\\\"呼ぶテキスト\\\\\\\":\\\\\\\"追加能力値c\\\\\\\"}\\\"]\",\"ヘルプテキスト\":\"[\\\"{\\\\\\\"条件\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"呼ぶテキスト\\\\\\\":\\\\\\\"ゲイルh\\\\\\\"}\\\"]\",\"立ち絵\":\"[\\\"{\\\\\\\"条件\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"画像\\\\\\\":\\\\\\\"Actor1_3\\\\\\\",\\\\\\\"レイヤー\\\\\\\":\\\\\\\"上層\\\\\\\",\\\\\\\"原点X\\\\\\\":\\\\\\\"0.5\\\\\\\",\\\\\\\"原点Y\\\\\\\":\\\\\\\"0.5\\\\\\\",\\\\\\\"位置X\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"位置Y\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"位置寄せX\\\\\\\":\\\\\\\"右寄せ\\\\\\\",\\\\\\\"位置寄せY\\\\\\\":\\\\\\\"下寄せ\\\\\\\",\\\\\\\"スケールX\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"スケールY\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"横幅\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"高さ\\\\\\\":\\\\\\\"gh\\\\\\\",\\\\\\\"回転角\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"不透明度\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"カラー赤\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"カラー緑\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"カラー青\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"カラー灰\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"開始アニメ\\\\\\\":\\\\\\\"分身1, 分身2, 分身3\\\\\\\",\\\\\\\"表示中アニメ\\\\\\\":\\\\\\\"呼吸\\\\\\\",\\\\\\\"無効\\\\\\\":\\\\\\\"\\\\\\\"}\\\"]\"}","{\"パック名\":\"アルベール\",\"自由欄テキスト\":\"[\\\"{\\\\\\\"条件\\\\\\\":\\\\\\\"true\\\\\\\",\\\\\\\"呼ぶテキスト\\\\\\\":\\\\\\\"追加能力値c\\\\\\\"}\\\"]\",\"ヘルプテキスト\":\"[\\\"{\\\\\\\"条件\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"呼ぶテキスト\\\\\\\":\\\\\\\"アルベールh\\\\\\\"}\\\"]\",\"立ち絵\":\"[\\\"{\\\\\\\"条件\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"画像\\\\\\\":\\\\\\\"Actor1_5\\\\\\\",\\\\\\\"レイヤー\\\\\\\":\\\\\\\"上層\\\\\\\",\\\\\\\"原点X\\\\\\\":\\\\\\\"0.5\\\\\\\",\\\\\\\"原点Y\\\\\\\":\\\\\\\"0.5\\\\\\\",\\\\\\\"位置X\\\\\\\":\\\\\\\"-30\\\\\\\",\\\\\\\"位置Y\\\\\\\":\\\\\\\"10\\\\\\\",\\\\\\\"位置寄せX\\\\\\\":\\\\\\\"右寄せ\\\\\\\",\\\\\\\"位置寄せY\\\\\\\":\\\\\\\"下寄せ\\\\\\\",\\\\\\\"スケールX\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"スケールY\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"横幅\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"高さ\\\\\\\":\\\\\\\"gh\\\\\\\",\\\\\\\"回転角\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"不透明度\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"カラー赤\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"カラー緑\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"カラー青\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"カラー灰\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"開始アニメ\\\\\\\":\\\\\\\"左から出る, フラッシュ\\\\\\\",\\\\\\\"表示中アニメ\\\\\\\":\\\\\\\"呼吸\\\\\\\",\\\\\\\"無効\\\\\\\":\\\\\\\"\\\\\\\"}\\\"]\"}","{\"パック名\":\"priscia\",\"自由欄テキスト\":\"[\\\"{\\\\\\\"条件\\\\\\\":\\\\\\\"true\\\\\\\",\\\\\\\"呼ぶテキスト\\\\\\\":\\\\\\\"追加能力値c\\\\\\\"}\\\"]\",\"ヘルプテキスト\":\"[\\\"{\\\\\\\"条件\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"呼ぶテキスト\\\\\\\":\\\\\\\"プリシアh\\\\\\\"}\\\"]\",\"立ち絵\":\"[\\\"{\\\\\\\"条件\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"画像\\\\\\\":\\\\\\\"Actor1_2\\\\\\\",\\\\\\\"レイヤー\\\\\\\":\\\\\\\"上層\\\\\\\",\\\\\\\"原点X\\\\\\\":\\\\\\\"0.5\\\\\\\",\\\\\\\"原点Y\\\\\\\":\\\\\\\"0.5\\\\\\\",\\\\\\\"位置X\\\\\\\":\\\\\\\"-100\\\\\\\",\\\\\\\"位置Y\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"位置寄せX\\\\\\\":\\\\\\\"右寄せ\\\\\\\",\\\\\\\"位置寄せY\\\\\\\":\\\\\\\"下寄せ\\\\\\\",\\\\\\\"スケールX\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"スケールY\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"横幅\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"高さ\\\\\\\":\\\\\\\"gh\\\\\\\",\\\\\\\"回転角\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"不透明度\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"カラー赤\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"カラー緑\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"カラー青\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"カラー灰\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"開始アニメ\\\\\\\":\\\\\\\"手前から出る2, ぷるん\\\\\\\",\\\\\\\"表示中アニメ\\\\\\\":\\\\\\\"呼吸\\\\\\\",\\\\\\\"無効\\\\\\\":\\\\\\\"\\\\\\\"}\\\"]\"}"]
 * 
 * @param 自由欄パック_2
 * @parent 自由欄パック登録
 * @desc freePackMaking ステータス自由欄に表示するテキスト群を登録する。メモ欄から<ステータス自由欄: パック名>で呼び出せる
 * @type struct<freePackMake>[]
 * @default 
 * 
 * @param 自由欄パック_3
 * @parent 自由欄パック登録
 * @desc freePackMaking ステータス自由欄に表示するテキスト群を登録する。メモ欄から<ステータス自由欄: パック名>で呼び出せる
 * @type struct<freePackMake>[]
 * @default 
 * 
 * @param 自由欄パック_4
 * @parent 自由欄パック登録
 * @desc freePackMaking ステータス自由欄に表示するテキスト群を登録する。メモ欄から<ステータス自由欄: パック名>で呼び出せる
 * @type struct<freePackMake>[]
 * @default 
 * 
 * @param 自由欄パック_5
 * @parent 自由欄パック登録
 * @desc freePackMaking ステータス自由欄に表示するテキスト群を登録する。メモ欄から<ステータス自由欄: パック名>で呼び出せる
 * @type struct<freePackMake>[]
 * @default 
 * 
 * @param 一言メッセージ登録
 * @desc shortMessageMaking UIボタンエリアに表示される一言メッセージを登録する。条件を満たした物が順に表示される
 * @type struct<textData>[]
 * @default 
 * 
 * @param 一言メッセージ_1
 * @parent 一言メッセージ登録
 * @desc shortMessageMaking UIボタンエリアに表示される一言メッセージを登録する。条件を満たした物が順に表示される
 * @type struct<textData>[]
 * @default ["{\"呼ぶテキスト\":\"サンプル/一言_1\",\"条件\":\"\"}","{\"呼ぶテキスト\":\"サンプル/一言_2\",\"条件\":\"\"}","{\"呼ぶテキスト\":\"サンプル/一言_3\",\"条件\":\"\"}"]
 * 
 * @param 一言メッセージ_2
 * @parent 一言メッセージ登録
 * @desc shortMessageMaking UIボタンエリアに表示される一言メッセージを登録する。条件を満たした物が順に表示される
 * @type struct<textData>[]
 * @default 
 * 
 * @param 一言メッセージ_3
 * @parent 一言メッセージ登録
 * @desc shortMessageMaking UIボタンエリアに表示される一言メッセージを登録する。条件を満たした物が順に表示される
 * @type struct<textData>[]
 * @default 
 * 
 * @param 一言メッセージ_4
 * @parent 一言メッセージ登録
 * @desc shortMessageMaking UIボタンエリアに表示される一言メッセージを登録する。条件を満たした物が順に表示される
 * @type struct<textData>[]
 * @default 
 * 
 * @param 一言メッセージ_5
 * @parent 一言メッセージ登録
 * @desc shortMessageMaking UIボタンエリアに表示される一言メッセージを登録する。条件を満たした物が順に表示される
 * @type struct<textData>[]
 * @default 
 * 
 * @param テキスト登録
 * @desc textMaking テキスト内容を登録する。自由欄パック登録/一言メッセージ登録の「呼び出すテキスト」から呼び出せる
 * @type struct<textMake>[]
 * @default 
 * 
 * @param テキスト_1
 * @parent テキスト登録
 * @desc textMaking テキスト内容を登録する。自由欄パック登録/一言メッセージ登録の「呼び出すテキスト」から呼び出せる
 * @type struct<textMake>[]
 * @default ["{\"テキスト名\":\"◆自由欄\",\"テキスト\":\"\"}","{\"テキスト名\":\"追加能力値c\",\"テキスト\":\"\\\\c[16]合計経験値:\\\\cl  \\\\sc[a.currentExp()]\\\\c[16]　\\\\c[16]次レベルまで:\\\\cl  \\\\sc[a.nextRequiredExp()]\\n\\\\c[16]命中率:\\\\cl  \\\\sc[a.hit*100]%　\\\\c[16]回避率:\\\\cl  \\\\sc[a.eva*100]%\\n\\\\c[16]会心率:\\\\cl  \\\\sc[a.cri*100]%　\\\\c[16]狙われ率:\\\\cl  \\\\sc[a.tgr*100]%\\n\\\\c[16]反撃率:\\\\cl  \\\\sc[a.cnt*100]%　\\\\c[16]魔法反射率:\\\\cl  \\\\sc[a.mrf*100]%\\n\\\\c[16]HP再生率:\\\\cl  \\\\sc[a.hrg*100]%　\\\\c[16]MP再生率:\\\\cl  \\\\sc[a.mrg*100]%\"}","{\"テキスト名\":\"追加能力値\",\"テキスト\":\"\\\\c[16]合計経験値:\\\\cl  \\\\sc[a.currentExp()]\\\\c[16]　\\\\c[16]次レベルまで:\\\\cl  \\\\sc[a.nextRequiredExp()]\\n\\\\c[16]命中率:\\\\cl  \\\\sc[a.hit*100]%　\\\\c[16]回避率:\\\\cl  \\\\sc[a.eva*100]%\\n\\\\c[16]会心率:\\\\cl  \\\\sc[a.cri*100]%　\\\\c[16]会心回避率:\\\\cl  \\\\sc[a.cev*100]%\\n\\\\c[16]魔法回避率:\\\\cl  \\\\sc[a.mev*100]%　\\\\c[16]魔法反射率:\\\\cl  \\\\sc[a.mrf*100]%\\n\\\\c[16]反撃率:\\\\cl  \\\\sc[a.cnt*100]%　\\\\c[16]HP再生率:\\\\cl  \\\\sc[a.hrg*100]%\\n\\\\c[16]MP再生率:\\\\cl  \\\\sc[a.mrg*100]%　\\\\c[16]TP再生率:\\\\cl  \\\\sc[a.trg*100]%\\n\\\\c[16]防御効果率:\\\\cl  \\\\sc[a.grd*100]%　\\\\c[16]回復効果率:\\\\cl  \\\\sc[a.rec*100]%\\n\\\\c[16]狙われ率:\\\\cl  \\\\sc[a.tgr*100]%　\\\\c[16]MP消費率:\\\\cl  \\\\sc[a.mcr*100]%\"}"]
 * 
 * @param テキスト_2
 * @parent テキスト登録
 * @desc textMaking テキスト内容を登録する。自由欄パック登録/一言メッセージ登録の「呼び出すテキスト」から呼び出せる
 * @type struct<textMake>[]
 * @default ["{\"テキスト名\":\"◆ヘルプ欄\",\"テキスト\":\"\"}","{\"テキスト名\":\"リードh\",\"テキスト\":\"\\\\c[16]名前:\\\\cl リード・エムゼット　\\\\c[16]年齢:\\\\cl 18歳　\\\\c[16]身長:\\\\cl 175cm　\\\\c[16]体重:\\\\cl 70kg\\n\\\\c[16]好きなもの:\\\\cl 倒しがいある強敵　\\\\c[16]嫌いなもの:\\\\cl 雑魚\\nツクールMZの男主人公枠。けっこう童顔気味なのが好みが分かれるとこかもしれない\\n\\n\"}","{\"テキスト名\":\"プリシアh\",\"テキスト\":\"\\\\c[16]名前:\\\\cl プリシア・ギガヒロイン　\\\\c[16]年齢:\\\\cl 18歳　\\\\c[16]身長:\\\\cl 165cm　\\\\c[16]体重:\\\\cl 60kg\\n\\\\c[16]好きなもの:\\\\cl あたしを輝かせる適度に強い悪者　\\\\c[16]嫌いなもの:\\\\cl あたしより可愛い女\\nツクールMZの女主人公枠。ケタ外れの正統派ヒロイン力で他のキャラを圧倒する\\n\\n\"}","{\"テキスト名\":\"ゲイルh\",\"テキスト\":\"\\\\c[16]名前:\\\\cl ゲイル・チピン　\\\\c[16]年齢:\\\\cl 33歳　\\\\c[16]身長:\\\\cl 168cm　\\\\c[16]体重:\\\\cl 67kg\\n\\\\c[16]好きなもの:\\\\cl 下克上　\\\\c[16]嫌いなもの:\\\\cl 主人公的存在\\nツクールMZのチンピラ枠。何だか脇役としての出番の方が多い気がしてならない\\n\\n\"}","{\"テキスト名\":\"アルベールh\",\"テキスト\":\"\\\\c[16]名前:\\\\cl アルベール・ケメーン　\\\\c[16]年齢:\\\\cl 25歳　\\\\c[16]身長:\\\\cl 180cm　\\\\c[16]体重:\\\\cl 75kg\\n\\\\c[16]好きなもの:\\\\cl ルッキズム　\\\\c[16]嫌いなもの:\\\\cl 実力主義\\nツクールMZのイケメン枠。二枚目から残念なイケメンまでその役者の幅は広い\\n\\n\"}"]
 * 
 * @param テキスト_3
 * @parent テキスト登録
 * @desc textMaking テキスト内容を登録する。自由欄パック登録/一言メッセージ登録の「呼び出すテキスト」から呼び出せる
 * @type struct<textMake>[]
 * @default ["{\"テキスト名\":\"◆一言\",\"テキスト\":\"\"}","{\"テキスト名\":\"サンプル/一言_1\",\"テキスト\":\"ケケーラボの他のプラグインもよろしくね\"}","{\"テキスト名\":\"サンプル/一言_2\",\"テキスト\":\"メニュースキン、メニュー快適化、メニュー自由欄の3つのプラグインで\"}","{\"テキスト名\":\"サンプル/一言_3\",\"テキスト\":\"メニュー画面を見た目も機能も大幅パワーアップだ！！\"}"]
 * 
 * @param テキスト_4
 * @parent テキスト登録
 * @desc textMaking テキスト内容を登録する。自由欄パック登録/一言メッセージ登録の「呼び出すテキスト」から呼び出せる
 * @type struct<textMake>[]
 * @default 
 * 
 * @param テキスト_5
 * @parent テキスト登録
 * @desc textMaking テキスト内容を登録する。自由欄パック登録/一言メッセージ登録の「呼び出すテキスト」から呼び出せる
 * @type struct<textMake>[]
 * @default 
 * 
 * @param テキスト_6
 * @parent テキスト登録
 * @desc textMaking テキスト内容を登録する。自由欄パック登録/一言メッセージ登録の「呼び出すテキスト」から呼び出せる
 * @type struct<textMake>[]
 * @default 
 * 
 * @param テキスト_7
 * @parent テキスト登録
 * @desc textMaking テキスト内容を登録する。自由欄パック登録/一言メッセージ登録の「呼び出すテキスト」から呼び出せる
 * @type struct<textMake>[]
 * @default 
 * 
 * @param テキスト_8
 * @parent テキスト登録
 * @desc textMaking テキスト内容を登録する。自由欄パック登録/一言メッセージ登録の「呼び出すテキスト」から呼び出せる
 * @type struct<textMake>[]
 * @default 
 *
 * @param その他登録
 * 
 * @param アニメーション登録
 * @parent その他登録
 * @desc animationMaking アニメーションを登録する。自由欄パック→立ち絵から呼び出せる
 * @type struct<animation>[]
 * @default ["{\"アニメ名\":\"■移動系\",\"アニメ時間\":\"0\",\"アニメ回数\":\"1\",\"ノーウェイト\":\"\",\"ディレイ\":\"\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"\",\"→スケールY\":\"\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\"}","{\"アニメ名\":\"上から出る\",\"アニメ時間\":\"20\",\"アニメ回数\":\"1\",\"ノーウェイト\":\"\",\"ディレイ\":\"\",\"位置X\":\"\",\"位置Y\":\"-gh\",\"→位置X\":\"\",\"→位置Y\":\"0\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"\",\"→スケールY\":\"\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\"}","{\"アニメ名\":\"上から出る2\",\"アニメ時間\":\"20\",\"アニメ回数\":\"1\",\"ノーウェイト\":\"\",\"ディレイ\":\"\",\"位置X\":\"\",\"位置Y\":\"-gh\",\"→位置X\":\"→50 rd _2\",\"→位置Y\":\"0\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"\",\"→スケールY\":\"\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\"}","{\"アニメ名\":\"下から出る\",\"アニメ時間\":\"30\",\"アニメ回数\":\"1\",\"ノーウェイト\":\"\",\"ディレイ\":\"\",\"位置X\":\"\",\"位置Y\":\"gh\",\"→位置X\":\"\",\"→位置Y\":\"0\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"\",\"→スケールY\":\"\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\"}","{\"アニメ名\":\"下から出る2\",\"アニメ時間\":\"30\",\"アニメ回数\":\"1\",\"ノーウェイト\":\"\",\"ディレイ\":\"\",\"位置X\":\"\",\"位置Y\":\"gh\",\"→位置X\":\"→50 rd _2\",\"→位置Y\":\"0\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"\",\"→スケールY\":\"\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\"}","{\"アニメ名\":\"左から出る\",\"アニメ時間\":\"20\",\"アニメ回数\":\"1\",\"ノーウェイト\":\"\",\"ディレイ\":\"\",\"位置X\":\"-gw\",\"位置Y\":\"\",\"→位置X\":\"0\",\"→位置Y\":\"\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"\",\"→スケールY\":\"\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\"}","{\"アニメ名\":\"左から出る2\",\"アニメ時間\":\"20\",\"アニメ回数\":\"1\",\"ノーウェイト\":\"\",\"ディレイ\":\"\",\"位置X\":\"-gw\",\"位置Y\":\"\",\"→位置X\":\"0 e\",\"→位置Y\":\"100 tn\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"\",\"→スケールY\":\"\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"0\",\"→不透明度\":\"255 e\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\"}","{\"アニメ名\":\"右から出る\",\"アニメ時間\":\"20\",\"アニメ回数\":\"1\",\"ノーウェイト\":\"\",\"ディレイ\":\"\",\"位置X\":\"gw\",\"位置Y\":\"\",\"→位置X\":\"0\",\"→位置Y\":\"\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"\",\"→スケールY\":\"\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\"}","{\"アニメ名\":\"右から出る2\",\"アニメ時間\":\"20\",\"アニメ回数\":\"1\",\"ノーウェイト\":\"\",\"ディレイ\":\"\",\"位置X\":\"gw\",\"位置Y\":\"\",\"→位置X\":\"0 e\",\"→位置Y\":\"100 tn\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"\",\"→スケールY\":\"\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"0\",\"→不透明度\":\"255 e\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\"}","{\"アニメ名\":\"手前から出る\",\"アニメ時間\":\"30\",\"アニメ回数\":\"1\",\"ノーウェイト\":\"\",\"ディレイ\":\"\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"3\",\"スケールY\":\"3\",\"→スケールX\":\"1 ei\",\"→スケールY\":\"1 ei\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\"}","{\"アニメ名\":\"手前から出る2\",\"アニメ時間\":\"30\",\"アニメ回数\":\"1\",\"ノーウェイト\":\"true\",\"ディレイ\":\"15\",\"位置X\":\"\",\"位置Y\":\"200\",\"→位置X\":\"→100 tn\",\"→位置Y\":\"0\",\"スケールX\":\"2\",\"スケールY\":\"2\",\"→スケールX\":\"1 ei\",\"→スケールY\":\"1 ei\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\"}","{\"アニメ名\":\"奥から出る\",\"アニメ時間\":\"30\",\"アニメ回数\":\"1\",\"ノーウェイト\":\"\",\"ディレイ\":\"\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"0\",\"スケールY\":\"0\",\"→スケールX\":\"1 ei\",\"→スケールY\":\"1 ei\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"0\",\"→不透明度\":\"255\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\"}","{\"アニメ名\":\"奥から出る2\",\"アニメ時間\":\"30\",\"アニメ回数\":\"1\",\"ノーウェイト\":\"\",\"ディレイ\":\"\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"→100 rd\",\"→位置Y\":\"↑100 rd\",\"スケールX\":\"0\",\"スケールY\":\"0\",\"→スケールX\":\"1 ei\",\"→スケールY\":\"1 ei\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"0\",\"→不透明度\":\"255\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\"}","{\"アニメ名\":\"■動き系\",\"アニメ時間\":\"0\",\"アニメ回数\":\"1\",\"ノーウェイト\":\"\",\"ディレイ\":\"\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"\",\"→スケールY\":\"\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\"}","{\"アニメ名\":\"ぴょこん\",\"アニメ時間\":\"20\",\"アニメ回数\":\"1\",\"ノーウェイト\":\"\",\"ディレイ\":\"\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"↑100 tn\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"*1.1 tn\",\"→スケールY\":\"*1.1 rd\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\"}","{\"アニメ名\":\"ぴょこん-中\",\"アニメ時間\":\"20\",\"アニメ回数\":\"1\",\"ノーウェイト\":\"\",\"ディレイ\":\"\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"↑25 tn\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"*1.05 tn\",\"→スケールY\":\"*1.05 rd\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\"}","{\"アニメ名\":\"ぴょこん-小\",\"アニメ時間\":\"20\",\"アニメ回数\":\"1\",\"ノーウェイト\":\"\",\"ディレイ\":\"\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"↑25 tn\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"*1.025 tn\",\"→スケールY\":\"*1.025 rd\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\"}","{\"アニメ名\":\"ぴょこん-微\",\"アニメ時間\":\"20\",\"アニメ回数\":\"1\",\"ノーウェイト\":\"\",\"ディレイ\":\"\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"↑12 tn\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"*1.0125 tn\",\"→スケールY\":\"*1.0125 rd\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\"}","{\"アニメ名\":\"ぷるん\",\"アニメ時間\":\"20\",\"アニメ回数\":\"1\",\"ノーウェイト\":\"\",\"ディレイ\":\"\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"*1.05 tn\",\"→スケールY\":\"*1.05 rd\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\"}","{\"アニメ名\":\"ぷるん-中\",\"アニメ時間\":\"30\",\"アニメ回数\":\"1\",\"ノーウェイト\":\"\",\"ディレイ\":\"\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"*1.05 tn\",\"→スケールY\":\"*1.05 rd\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\"}","{\"アニメ名\":\"ぷるん-小\",\"アニメ時間\":\"30\",\"アニメ回数\":\"1\",\"ノーウェイト\":\"\",\"ディレイ\":\"\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"*1.025 tn\",\"→スケールY\":\"*1.025 rd\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\"}","{\"アニメ名\":\"ぷるん-微\",\"アニメ時間\":\"30\",\"アニメ回数\":\"1\",\"ノーウェイト\":\"\",\"ディレイ\":\"\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"*1.0125 tn\",\"→スケールY\":\"*1.0125 rd\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\"}","{\"アニメ名\":\"きめる\",\"アニメ時間\":\"20\",\"アニメ回数\":\"1\",\"ノーウェイト\":\"\",\"ディレイ\":\"\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"20 tn\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"*0.9 tn\",\"→スケールY\":\"*0.9 rd\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\"}","{\"アニメ名\":\"きめる-中\",\"アニメ時間\":\"20\",\"アニメ回数\":\"1\",\"ノーウェイト\":\"\",\"ディレイ\":\"\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"10 tn\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"*0.95 tn\",\"→スケールY\":\"*0.95 rd\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\"}","{\"アニメ名\":\"きめる-小\",\"アニメ時間\":\"20\",\"アニメ回数\":\"1\",\"ノーウェイト\":\"\",\"ディレイ\":\"\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"*0.975 tn\",\"→スケールY\":\"*0.975 rd\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\"}","{\"アニメ名\":\"きめる-微\",\"アニメ時間\":\"20\",\"アニメ回数\":\"1\",\"ノーウェイト\":\"\",\"ディレイ\":\"\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"*0.9875 tn\",\"→スケールY\":\"*0.9875 rd\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\"}","{\"アニメ名\":\"■変化系\",\"アニメ時間\":\"0\",\"アニメ回数\":\"1\",\"ノーウェイト\":\"\",\"ディレイ\":\"\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"\",\"→スケールY\":\"\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\"}","{\"アニメ名\":\"フェードイン\",\"アニメ時間\":\"30\",\"アニメ回数\":\"1\",\"ノーウェイト\":\"\",\"ディレイ\":\"\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"\",\"→スケールY\":\"\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"0\",\"→不透明度\":\"255\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\"}","{\"アニメ名\":\"フラッシュ\",\"アニメ時間\":\"30\",\"アニメ回数\":\"1\",\"ノーウェイト\":\"\",\"ディレイ\":\"\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"*1.02 tn\",\"→スケールY\":\"*1.02 rd\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"64\",\"カラー緑\":\"64\",\"カラー青\":\"64\",\"カラー灰\":\"\",\"→カラー赤\":\"0 ei\",\"→カラー緑\":\"0 ei\",\"→カラー青\":\"0 ei\",\"→カラー灰\":\"\"}","{\"アニメ名\":\"■複合系\",\"アニメ時間\":\"0\",\"アニメ回数\":\"1\",\"ノーウェイト\":\"\",\"ディレイ\":\"\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"\",\"→スケールY\":\"\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\"}","{\"アニメ名\":\"突進1\",\"アニメ時間\":\"30\",\"アニメ回数\":\"1\",\"ノーウェイト\":\"\",\"ディレイ\":\"\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"→100 rd\",\"→位置Y\":\"↓100 tn\",\"スケールX\":\"0\",\"スケールY\":\"0\",\"→スケールX\":\"2 ei\",\"→スケールY\":\"2 ei\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\"}","{\"アニメ名\":\"突進2\",\"アニメ時間\":\"20\",\"アニメ回数\":\"1\",\"ノーウェイト\":\"true\",\"ディレイ\":\"\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"↑ 100 tn\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"1 eo\",\"→スケールY\":\"1 eo\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"64\",\"カラー緑\":\"64\",\"カラー青\":\"64\",\"カラー灰\":\"\",\"→カラー赤\":\"0 ei\",\"→カラー緑\":\"0 ei\",\"→カラー青\":\"0 ei\",\"→カラー灰\":\"\"}","{\"アニメ名\":\"分身1\",\"アニメ時間\":\"15\",\"アニメ回数\":\"1\",\"ノーウェイト\":\"\",\"ディレイ\":\"\",\"位置X\":\"-gw\",\"位置Y\":\"\",\"→位置X\":\"→gw\",\"→位置Y\":\"\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"\",\"→スケールY\":\"\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"128\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\"}","{\"アニメ名\":\"分身2\",\"アニメ時間\":\"15\",\"アニメ回数\":\"1\",\"ノーウェイト\":\"\",\"ディレイ\":\"\",\"位置X\":\"gw\",\"位置Y\":\"\",\"→位置X\":\"←gw\",\"→位置Y\":\"\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"\",\"→スケールY\":\"\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"128\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\"}","{\"アニメ名\":\"分身3\",\"アニメ時間\":\"15\",\"アニメ回数\":\"1\",\"ノーウェイト\":\"\",\"ディレイ\":\"\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"3\",\"スケールY\":\"3\",\"→スケールX\":\"1 ei\",\"→スケールY\":\"1 ei\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"0\",\"→不透明度\":\"255\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\"}","{\"アニメ名\":\"■呼吸系\",\"アニメ時間\":\"0\",\"アニメ回数\":\"1\",\"ノーウェイト\":\"\",\"ディレイ\":\"\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"\",\"→スケールY\":\"\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\"}","{\"アニメ名\":\"呼吸\",\"アニメ時間\":\"120\",\"アニメ回数\":\"-1\",\"ノーウェイト\":\"\",\"ディレイ\":\"\",\"位置X\":\"\",\"位置Y\":\"\",\"→位置X\":\"\",\"→位置Y\":\"\",\"スケールX\":\"\",\"スケールY\":\"\",\"→スケールX\":\"*1.005 rd\",\"→スケールY\":\"*0.9975 tn\",\"回転角\":\"\",\"→回転角\":\"\",\"不透明度\":\"\",\"→不透明度\":\"\",\"カラー赤\":\"\",\"カラー緑\":\"\",\"カラー青\":\"\",\"カラー灰\":\"\",\"→カラー赤\":\"\",\"→カラー緑\":\"\",\"→カラー青\":\"\",\"→カラー灰\":\"\"}"]
 * 
 * @param レイアウト設定
 * 
 * @param ステータス自由欄
 * @parent レイアウト設定
 * @desc statsuFreeSpace_layout ステータス自由欄のレイアウト設定
 * @type struct<layoutFreeSpaceStatus>
 * @default {"位置X":"392","位置Y":"-10","文字サイズ":"18","文字縁取り幅":"5","文字色":"","バック":"","バック表示":"false","バック色":"0, 0, 0, 0.3","バック丸み":"20","バック余白X":"0","バック余白Y":"0"}
 * 
 * @param ステータスヘルプ
 * @parent レイアウト設定
 * @desc statsuHelp_layout ステータスヘルプ欄のレイアウト設定
 * @type struct<layoutStatusHelp>
 * @default {"位置X":"0","位置Y":"-8","文字サイズ":"20","文字縁取り幅":"5","文字色":"","バック":"","バック表示":"false","バック色":"0, 0, 0, 0.3","バック丸み":"20","バック余白X":"0","バック余白Y":"0"}
 *
 * @param 一言メッセージ
 * @parent レイアウト設定
 * @desc shortMessage_layout 一言メッセージのレイアウト設定
 * @type struct<layoutShortMessage>
 * @default {"位置X":"0","位置Y":"-4","文字サイズ":"26","文字縁取り幅":"6","文字色":"","表示しないシーン":"[\"Options\",\"GameEnd\"]","メインメニューのみ":"false","表示順":"リスト順","UIボタンエリア高さ":"52","行間":"4","バック":"","バック表示":"false","バック色":"0, 0, 0, 0.3","バック丸み":"20","バック余白X":"0","バック余白Y":"0"}
 *
 *
 *
 * @command 一言メッセージ初期化
 * @desc initShortMessage 一言メッセージの表示順を最初に戻す
 *
 * @arg 
 * @desc 
 * @default 
 */



//==================================================
/*~struct~freePackMake:
//==================================================
 * @param パック名
 * @desc packName 自由欄パックの名前。メモ欄からの呼び出しに使う
 *
 * @param 自由欄テキスト
 * @desc freeTextList ステータス画面の自由欄に表示するテキストのリスト。上から条件を満たしたものを採用する
 * @type struct<textData>[]
 * 
 * @param ヘルプテキスト
 * @desc helpTextList ステータス画面のヘルプ欄に表示するテキストのリスト。上から条件を満たしたものを採用する
 * @type struct<textData>[]
 * 
 * @param 立ち絵
 * @desc standingPicture ステータス画面に表示する立ち絵の設定
 * @type struct<standData>[]
 */



//==================================================
/*~struct~textMake:
//==================================================
 * @param テキスト名
 * @desc textName テキストの名前。自由欄パックからの呼び出しに使う
 *
 * @param テキスト
 * @desc test 表示するテキスト内容
 * @type multiline_string
 */


//==================================================
/*~struct~textData:
//==================================================
 * @param 条件
 * @desc condition 表示する条件。javaScript式で記述。a:アクター v:変数 s:スイッチ
 * @type multiline_string
 * 
 * @param 呼ぶテキスト
 * @desc callText 呼び出すテキスト。テキスト登録したテキスト名を書く
 */



//==================================================
/*~struct~freeText:
//==================================================
 * @param タグ
 * @desc 何を書いてもいい欄
 * 
 * @param 条件
 * @desc condition 表示する条件。javaScript式で記述。a:アクター v:変数 s:スイッチ
 * @type multiline_string
 * 
 * @param フリーテキスト
 * @desc freeText 自由欄に表示するテキスト
 * @type multiline_string
 */



//==================================================
/*~struct~helpText:
//==================================================
 * @param タグ
 * @desc 何を書いてもいい欄
 * 
 * @param 条件
 * @desc condition 表示する条件。javaScript式で記述。a:アクター v:変数 s:スイッチ
 * @type multiline_string
 * 
 * @param ヘルプテキスト
 * @desc helpText ヘルプ欄に表示するテキスト
 * @type multiline_string
 */



//==================================================
/*~struct~layoutFreeSpaceStatus:
//==================================================
 * @param 位置X
 * @desc posX ステータス自由欄の描画開始X位置。5 ならウインドウ左端から 5ピクセル。基本 392
 * @default 392
 * 
 * @param 位置Y
 * @desc posY ステータス自由欄の描画開始Y位置。5 ならウインドウ上端から 5ピクセル。基本 -10
 * @default -10
 * 
 * @param 文字サイズ
 * @desc fontSize ステータス自由欄の文字サイズ。空欄なら標準サイズ。+1 で標準サイズ + 1、-1 で標準サイズ - 1。基本 18
 * @default 18
 * 
 * @param 文字縁取り幅
 * @desc fontOutWidth ステータス自由欄の文字縁取り幅。空欄なら標準に合わせる。基本 5
 * @default 5
 * 
 * @param 文字色
 * @desc textColor ステータス自由欄の文字色。赤, 緑, 青。各0～255。空欄なら標準に合わせる。基本 空欄
 * @default 
 * 
 * @param バック
 * 
 * @param バック表示
 * @parent バック
 * @desc ステータス自由欄に背景部分を表示する
 * @type boolean
 * @default true
 * 
 * @param バック色
 * @parent バック
 * @desc 背景部分の色色。赤, 緑, 青, 濃度。色0～255、濃度0～1。空欄なら標準に合わせる。基本 0, 0, 0, 0.3
 * @default 0, 0, 0, 0.3
 * 
 * @param バック丸み
 * @parent バック
 * @desc 背景部分の角の丸み。5 なら 5ピクセル 丸まる。基本 20 
 * @default 20
 * 
 * @param バック余白X
 * @parent バック
 * @desc 背景部分のX方向の余白。5 なら 5ピクセル。基本 0
 * @default 0
 * 
 * @param バック余白Y
 * @parent バック
 * @desc 背景部分のY方向の余白。5 なら 5ピクセル。基本 0
 * @default 0
 */



//==================================================
/*~struct~layoutStatusHelp:
//==================================================
 * @param 位置X
 * @desc posX ステータスヘルプの描画開始X位置。5 ならウインドウ左端から 5ピクセル。基本 0
 * @default 0
 * 
 * @param 位置Y
 * @desc posY ステータスヘルプの描画開始Y位置。5 ならウインドウ上端から 5ピクセル。基本 -8
 * @default -8
 * 
 * @param 文字サイズ
 * @desc fontSize ステータスヘルプの文字サイズ。空欄なら標準サイズ。+1 で標準サイズ + 1、-1 で標準サイズ - 1。基本 20
 * @default 20
 * 
 * @param 文字縁取り幅
 * @desc fontOutWidth ステータスヘルプの文字縁取り幅。空欄なら標準に合わせる。基本 5
 * @default 5
 * 
 * @param 文字色
 * @desc textColor ステータスヘルプの文字色。赤, 緑, 青。各0～255。空欄なら標準に合わせる。基本 空欄
 * @default 
 * 
 * @param バック
 * 
 * @param バック表示
 * @parent バック
 * @desc ステータス自由欄に背景部分を表示する
 * @type boolean
 * @default true
 * 
 * @param バック色
 * @parent バック
 * @desc 背景部分の色色。赤, 緑, 青, 濃度。色0～255、濃度0～1。空欄なら標準に合わせる。基本 0, 0, 0, 0.3
 * @default 0, 0, 0, 0.3
 * 
 * @param バック丸み
 * @parent バック
 * @desc 背景部分の角の丸み。5 なら 5ピクセル 丸まる。基本 20 
 * @default 20
 * 
 * @param バック余白X
 * @parent バック
 * @desc 背景部分のX方向の余白。5 なら 5ピクセル。基本 0
 * @default 0
 * 
 * @param バック余白Y
 * @parent バック
 * @desc 背景部分のY方向の余白。5 なら 5ピクセル。基本 0
 * @default 0
 */



//==================================================
/*~struct~layoutShortMessage:
//==================================================
 * @param 位置X
 * @desc posX 一言メッセージの描画開始X位置。5 ならウインドウ左端から 5ピクセル。基本 0
 * @default 0
 * 
 * @param 位置Y
 * @desc posY 一言メッセージの描画開始Y位置。5 ならウインドウ上端から 5ピクセル。基本 -4
 * @default -4
 * 
 * @param 文字サイズ
 * @desc fontSize 一言メッセージの文字サイズ。空欄なら標準サイズ。+1 で標準サイズ + 1、-1 で標準サイズ - 1。基本 26
 * @default 26
 * 
 * @param 文字縁取り幅
 * @desc fontOutWidth 一言メッセージの文字縁取り幅。空欄なら標準に合わせる。基本 6
 * @default 6
 * 
 * @param 文字色
 * @desc textColor 一言メッセージの文字色。赤, 緑, 青。各0～255。空欄なら標準に合わせる。基本 空欄
 * @default
 * 
 * @param 表示しないシーン
 * @desc hideScene 一言メッセージを表示しないシーン。オプションシーンなら Options。シーン名の頭の Scene_ は不要
 * @type string[]
 * @default ["Options","GameEnd"]
 * 
 * @param メインメニューのみ
 * @desc showOnlyMainMenu メインメニュー画面でのみ一言メッセージを表示する。基本 false
 * @type boolean
 * @default false
 * 
 * @param 表示順
 * @desc shorOrder メッセージが複数ある時どのような順番で表示するか
 * @type select
 * @option リスト順
 * @option ランダム
 * @default リスト順
 * 
 * @param UIボタンエリア高さ
 * @desc uiButtonAreaHeight 一言メッセージが表示されるUIボタンエリアの高さ。50 なら 50ピクセル 基本 52
 * @default 52
 * 
 * @param 行間
 * @desc lineSpace 一言メッセージが複数行にまたがる時の行間。5 なら 5ビクセル。基本 4
 * @default 4
 * 
 * @param バック
 * 
 * @param バック表示
 * @parent バック
 * @desc ステータス自由欄に背景部分を表示する
 * @type boolean
 * @default false
 * 
 * @param バック色
 * @parent バック
 * @desc 背景部分の色色。赤, 緑, 青, 濃度。色0～255、濃度0～1。空欄なら標準に合わせる。基本 0, 0, 0, 0.3
 * @default 0, 0, 0, 0.3
 * 
 * @param バック丸み
 * @parent バック
 * @desc 背景部分の角の丸み。5 なら 5ピクセル 丸まる。基本 20 
 * @default 20
 * 
 * @param バック余白X
 * @parent バック
 * @desc 背景部分のX方向の余白。5 なら 5ピクセル。基本 0
 * @default 0
 * 
 * @param バック余白Y
 * @parent バック
 * @desc 背景部分のY方向の余白。5 なら 5ピクセル。基本 0
 * @default 0
 */



//==================================================
/*~struct~standData:
//==================================================
 * @param 条件
 * @desc condition 表示する条件。javaScript式で記述。a:アクター v:変数 s:スイッチ
 * @type multiline_string
 * 
 * @param 画像
 * @desc picture 立ち絵に使う画像ファイル。picturesフォルダを参照する
 * @type file
 * @dir img/pictures
 *
 * @param レイヤー
 * @desc layer ピクチャを表示するレイヤー。上層はウインドウより上、下層は下
 * @type select
 * @option 上層
 * @option 下層
 * @default 上層
 *
 * @param 原点X
 * @desc originX ピクチャのX原点。0～1
 * @default 0.5
 *
 * @param 原点Y
 * @desc originY ピクチャのY原点。0～1
 * @default 0.5
 *
 * @param 位置X
 * @desc posX 立ち絵の左端のX位置。5 ならウインドウ左端から 5ピクセル
 * @default 
 * 
 * @param 位置Y
 * @desc posY 立ち絵の上端のY位置。5 ならウインドウ上端から 5ピクセル
 * @default 
 * 
 * @param 位置寄せX
 * @desc alignX 横方向の位置を画面左寄せか、画面中央寄せか、画面右寄せにする
 * @type select
 * @option 寄せない
 * @option 左寄せ
 * @option 中央寄せ
 * @option 右寄せ
 * @default 右寄せ
 *
 * @param 位置寄せY
 * @desc alignY 横方向の位置を画面上寄せか、画面中央寄せか、画面下寄せにする
 * @type select
 * @option 寄せない
 * @option 上寄せ
 * @option 中央寄せ
 * @option 下寄せ
 * @default 下寄せ
 *
 * @param スケールX
 * @desc scaleX 立ち絵のX拡大率。1.5 なら 1.5倍。-1 で左右反転
 *
 * @param スケールY
 * @desc scaleY 立ち絵のY拡大率。1.5 なら 1.5倍。-1 で上下反転
 *
 * @param 横幅
 * @desc width 立ち絵の横幅。50 なら 50ピクセル。空欄ならウインドウ幅に合わせる
 *
 * @param 高さ
 * @desc height 立ち絵の縦高。50 なら 50ピクセル。空欄ならウインドウ幅に合わせる
 * @default gh
 * 
 * @param 回転角
 * @desc spin 立ち絵の回転角。0〜360度。90 で右に 90度、-90 で左に 90度
 *
 * @param 不透明度
 * @desc opacity 立ち絵の不透明度。0〜255。値を増すほど濃くなる
 *
 * @param カラー赤
 * @desc colorRed 立ち絵の赤み。-255〜255
 *
 * @param カラー緑
 * @desc colorGreen 立ち絵の緑み。-255〜255
 *
 * @param カラー青
 * @desc colorBlue 立ち絵の青み。-255〜255
 *
 * @param カラー灰
 * @desc colorGray 立ち絵の灰色み。0〜255
 * 
 * @param 開始アニメ
 * @desc startAnime シーン開始時に立ち絵に実行させるアニメ。アニメーション登録したアニメ名を書く
 * @type multiline_string
 
 * @default 下から出る
 *
 * @param 表示中アニメ
 * @desc inAnime 立ち絵表示中に実行させるアニメ。アニメーション登録したアニメ名を書く
 * @default 呼吸
 *
 * @param 無効
 * @desc invalid 立ち絵を無効にする
 * @type boolean
 */



//==================================================
/*~struct~animation:
//==================================================
 * @param アニメ名
 * @desc アニメーションの名前。アニメの呼び出しに使う
 *
 * @param アニメ時間
 * @desc アニメの実行時間。5 なら 5フレーム、1s なら 1秒 かけて実行。5~10 なら 5 から 10 の間のランダム
 * @default 0
 *
 * @param アニメ回数
 * @desc アニメの実行回数。2 なら 2回 実行。-1 でループ実行
 * @default 1
 * 
 * @param ノーウェイト
 * @desc アニメ終了を待たずにすぐ次のアニメを実行する
 * @type boolean
 * 
 * @param ディレイ
 * @desc アニメ開始までの待ち時間。5 なら 5フレーム
 *
 * @param 位置X
 * @desc 最初のX位置。5 で右に 5ピクセル、-5で左に 5ピクセル。演算可。gw:画面横幅
 *
 * @param 位置Y
 * @desc 最初のY位置。5 で下に 5ピクセル、-5で上に 5ピクセル。演算可。gh:画面縦高
 *
 * @param →位置X
 * @desc 目標とするX位置。→5 で右に 5ピクセル、←5で左に 5ピクセル
 *
 * @param →位置Y
 * @desc 目標とするY位置。↓5 で下に 5ピクセル、↑5で上に 5ピクセル
 *
 * @param スケールX
 * @desc 最初のX拡大率。1.5 で 1.5倍、0.5 で 0.5倍。-1 で左右反転
 *
 * @param スケールY
 * @desc 最初のY拡大率。1.5 で 1.5倍、0.5 で 0.5倍。-1 で上下反転
 *
 * @param →スケールX
 * @desc 目標とするX拡大率。1.5 で 1.5倍、0.5 で 0.5倍。マイナスで左右反転
 *
 * @param →スケールY
 * @desc 目標とするY拡大率。1.5 で 1.5倍、0.5 で 0.5倍。マイナスで上下反転
 *
 * @param 回転角
 * @desc 最初の回転角。0〜360度。90 で右に 90度、-90 で左に 90度
 *
 * @param →回転角
 * @desc 目標とする回転角。0〜360度。90 で右に 90度、-90 で左に 90度
 *
 * @param 不透明度
 * @desc 最初の不透明度。0〜255
 *
 * @param →不透明度
 * @desc 目標とする不透明度。0〜255
 *
 * @param カラー赤
 * @desc カラートーン・赤。-255〜255
 *
 * @param カラー緑
 * @desc 最初のカラートーン・緑。-255〜255
 *
 * @param カラー青
 * @desc 最初のカラートーン・青。-255〜255
 *
 * @param カラー灰
 * @desc 最初のカラートーン・グレー。-255〜255
 *
 * @param →カラー赤
 * @desc カラートーン・赤。-255〜255
 *
 * @param →カラー緑
 * @desc 目標とするカラートーン・緑。-255〜255
 *
 * @param →カラー青
 * @desc 目標とするカラートーン・青。-255〜255
 *
 * @param →カラー灰
 * @desc 目標とするカラートーン・グレー。0〜255
 */
 
 
 
(() => {
    //- プラグイン名
    const pluginName = document.currentScript.src.match(/^.*\/(.*).js$/)[1];
    
    
    
    //==================================================
    //--  スプライト追加 /ベーシック
    //==================================================
    
    //- 破棄付きスプライト
    function SpriteKeMnfs() {
        this.initialize(...arguments);
    };

    SpriteKeMnfs.prototype = Object.create(Sprite.prototype);
    SpriteKeMnfs.prototype.constructor = SpriteKeMnfs;

    SpriteKeMnfs.prototype.destroy = function() {
        if (this.bitmap && !this.bitmap._url) { this.bitmap.destroy(); }
        Sprite.prototype.destroy.call(this);
    };


    //- 上方レイヤースプライト
    function Sprite_UpperLayerKeMnfs() {
        this.initialize(...arguments);
    };

    Sprite_UpperLayerKeMnfs.prototype = Object.create(Sprite.prototype);
    Sprite_UpperLayerKeMnfs.prototype.constructor = Sprite_UpperLayerKeMnfs;

    Sprite_UpperLayerKeMnfs.prototype.initialize = function(bitmap, body, padding) {
        bitmap = new Bitmap(Graphics.width, Graphics.height);
        Sprite.prototype.initialize.call(this, bitmap);
        this._body = body;
        this._padding = padding || 0;
        if (body && body.constructor.name.toUpperCase().includes("EQUIP")) {
            this._clientArea = new SpriteKeMnfs();
            this.addChild(this._clientArea);
        }
        this.clear();
    };
    
    Sprite_UpperLayerKeMnfs.prototype.destroy = function() {
        if (this.bitmap && !this.bitmap._url) { this.bitmap.destroy(); }
        if (this._clientArea && this._clientArea.bitmap && !this._clientArea.bitmap._url) { this._clientArea.bitmap.destroy(); }
        Sprite.prototype.destroy.call(this);
    };

    Sprite_UpperLayerKeMnfs.prototype.update = function() {
        Sprite.prototype.update.call(this);
        if (this._body) {
            this.x = this._body.x + (Graphics.width - Graphics.boxWidth) / 2;
            this.y = this._body.y + (Graphics.height - Graphics.boxHeight) / 2;
            if (this._clientArea) {
                this._clientArea.filters = this._body._clientArea.filters;
                this._clientArea.filterArea = this._body._clientArea.filterArea;
            }
        }
    };

    Sprite_UpperLayerKeMnfs.prototype.clear = function() {
        if (this.bitmap) { this.bitmap.destroy(); }
        this.bitmap = new Bitmap(Graphics.width, Graphics.height);
        this._onBitmapChange();
        if (this._clientArea) {
            if (this._clientArea.bitmap) { this._clientArea.bitmap.destroy(); }
            this._clientArea.bitmap = new Bitmap(Graphics.width, Graphics.height);
            this._clientArea._onBitmapChange();
        }
    };



    //==================================================
    //--  動的関数
    //==================================================

    let funcs = {};

    //- ニューファンク
    function newFunc(str, a, v, s) {
        if (!funcs[str]) {
            funcs[str] = new Function("a", "v", "s", "return " + str);
            return funcs[str](a, v, s);
        } else {
            return funcs[str](a, v, s);
        }
    };

    //- ニューファンク-画面幅の演算
    function newFunc_screenW(str) {
        if (!str) { return null; }
        str = str.toString();
        if (!str.match(/(\d|gw|gh)/)) { return str; }
        str = str.replace(/(\d)[a-z]+/gi, "$1");
        str = str.replace(/[a-z]+(\d)/gi, "$1");
        const gw = Graphics.width;
        const gh = Graphics.height;
        if (!funcs[str]) {
            funcs[str] = new Function("gw", "gh", "return " + str);
            return Math.round(funcs[str](gw, gh));
        } else {
            return Math.round(funcs[str](gw, gh));
        }
    };



    //==================================================
    //--  文字列オート変換 /ベーシック
    //==================================================
    
    // 文字列のハッシュ化
    function strToHash(str) {
        if (!str || !str.length) { return {}; }
        let hash = {};
        const strs = JSON.parse(str);
        let val = null;
        let val2 = null;
        for (let key in strs) {
            val = strs[key];
            if (!key || !val) { continue; }
            val2 = strToAuto(val, key);
            hash[key] = val2;
        }
        return hash;
    };
    
    // 文字列のリスト化
    function strToList(str) {
        if (!str || !str.length) { return []; }
        let array = JSON.parse(str);
        return array.map((val, i) => {
            return strToAuto(val);
        }, this);
    };
    
    // 文字列の自動処理
    function strToAuto(val, key = "") {
        let val2 = null;
        let match = null;
        let end = false;
        if (!end) {
            if (val[0] == "{") {
                val2 = strToHash(val);
                end = true;
            }
        }
        if (!end) {
            if (val[0] == "[") {
                val2 = strToList(val);
                end = true;
            }
        }
        if (!end) { val = val + ","; }
        if (!end) {
            match = val.match(/^\s*(-?\d+,\s*-?\d+,\s*-?\d+,?\s*-?\d*\.?\d*)\s*,$/);
            if (match && !val.match(/[^\d\.\-,\s]/)) {
                if (key.match(/カラー|色|塗り|color|paint/i) && !key.match(/トーン|tone/i) && !key.match(/ブレンド|blend/i) && !key.match(/配色|scheme/i) && !key.match(/着色|coloring/i) &&  !key.match(/フラッシュ|flash/i) && !key.match(/チェンジ|change/i) &&  !key.match(/選択|select/i)) {
                    val2 = "rgba(" +  match[1] + ")";
                } else {
                    val2 = JSON.parse("[" +  match[1] + "]");
                }
                end = true;
            }
        }
        if (!end) {
            match = val.match(/(-?\d+\.?\d*),\s*/g);
            if (match && match.length >= 2 && !val.match(/[^\d\.\-,\s]/)) {
                val2 = JSON.parse("[" + match.reduce((r, s) => r + s).replace(/,$/, "") + "]");
                end = true;
            }
        }
        if (!end) {
            match = val.match(/^(true|false)\s*,/);
            if (match) {
                val2 = match[1] == "true" ? true : false;
                end = true;
            }
        }
        if (!end) {
            match = val.match(/^(-?\d+\.?\d*)\s*,/);
            if (match && !val.match(/[^\d\.\-,\s]/)) {
                val2 = Number(match[1]); end = true;
                end = true;
            }
        }
        if (!end) {
            match = val.match(/^.+,\n?.+/);
            if (match) {
                val2 = val.replace(/\s/g, "").split(/,|\n/).filter(v => v);
                end = true;
            }
        }
        if (!end) {
            if (val[0] == "\"") { val = val.slice(1); }
            val2 = val.slice(0, -1);
        }
        if (key.match(/アニメ|anime/i)) {
            val2 = delLineBreak(val2);
        }
        return val2;
    };

    //- 改行の消去
    function delLineBreak(v) {
        if (typeof v == "string") { v = v.replace(/\n/g, "") }
        if (Array.isArray(v)) { v = v.map(e => (typeof e == "string") ? e.replace(/\n/g, "") : e); }
        return v;
    }



    //==================================================
    //--  パラメータ受け取り
    //==================================================
    
    //- 真偽化
    function toBoolean(str) {
        if (!str) { return false; }
        const str2 = str.toString().toLowerCase();
        if (str2 == "true" || str2 == "on") { return true; }
        if (str2 == "false" || str2 == "off") { return false; }
        return Number(str);
    };

    let parameters = PluginManager.parameters(pluginName);
    
    //- データ登録
    const keke_freePackMaking = compileParameters(parameters, "自由欄パック登録", "自由欄パック_");
    const keke_animeList = strToList(parameters["アニメーション登録"]);
    const keke_shortMessageMaking = compileParameters(parameters, "一言メッセージ登録", "一言メッセージ_");
    const keke_textMaking =compileParameters(parameters, "テキスト登録", "テキスト_");

    //- レイアウト設定
    const keke_freeSpaceStatus = strToHash(parameters["ステータス自由欄"]);
    const keke_StatusHelp = strToHash(parameters["ステータスヘルプ"]); 
    const keke_shortMessage = strToHash(parameters["一言メッセージ"]); 

    parameters = null;

    //- パラメータの合体
    function compileParameters(parameters, word1, word2) {
        let list = strToList(parameters[word1]);
        let i = 1;
        while (parameters[word2 + i]) {
            const addList = strToList(parameters[word2 + i]);
            list = [...list, ...addList];
            i++;
        }
        return list
    };
    
    
    
    //==================================================
    //--  プラグインコマンド
    //==================================================
    
    //- 一言メッセージ初期化
    PluginManager.registerCommand(pluginName, "一言メッセージ初期化", args => {
        $gameSystem._shortMessageNumberKeMnfs = 0;
    });
    
    
    
    //==================================================
    //--  共通開始
    //==================================================

    //- シーンステータス/アクターのリフレッシュ(処理追加)
    const _Scene_Status_refreshActor = Scene_Status.prototype.refreshActor;
    Scene_Status.prototype.refreshActor = function() {
        _Scene_Status_refreshActor.apply(this);
        const actor = this.actor();
        // ステータスヘルプの表示
        showStatusHelp(this, actor);
        // 立ち絵の形成
        createStand(this, actor);
        // 上方スブライト群のチルド
        childUpperSprites(this, actor);
    };
    
    

    //==================================================
    //--  共通更新
    //==================================================
    
    //- シーンステータス/更新(処理追加)
    const _Scene_Status_update = Scene_Status.prototype.update;
    Scene_Status.prototype.update = function() {
        _Scene_Status_update.apply(this);
        // アニメスプライトの更新
        updateAnimeSprite(this);
    };
    

    
    //==================================================
    //--  共通終了
    //==================================================

    //- スプライトの破棄
    function destroySprite(sprite) {
        if (!sprite) { return; }
        sprite.children.forEach(s => destroySprite(s));
        if (sprite.bitmap && !sprite.bitmap._url) { sprite.bitmap.destroy(); }
        if (sprite._texture) { sprite.destroy(); }
    };



    //==================================================
    //--  共通処理
    //==================================================

    //- ウインドウ・ステータスベース/テキスト描画(処理追加)
    if (Window_StatusBase.prototype.drawText == Window_Base.prototype.drawText) {
        Window_StatusBase.prototype.drawText = function(text, x, y, maxWidth, align) {
            Window_Base.prototype.drawText.apply(this, arguments);
        };
    };
    const _Window_StatusBase_drawText = Window_StatusBase.prototype.drawText;
    Window_StatusBase.prototype.drawText = function(text, x, y, maxWidth, align) {
        // 上方レイヤーへのテキスト描画
        if (drawTextToUpperSprite(this, text, x, y, maxWidth, align)) { return; };
        _Window_StatusBase_drawText.apply(this, arguments);
    };


    //- シーンステータス/アクターの変更(処理追加)
    const _Scene_Status_onActorChange = Scene_Status.prototype.onActorChange;
    Scene_Status.prototype.onActorChange = function() {
        // 上方スブライトのクリア予約-全て
        clearOrderUpperLayerAll(this);
        // ヘルプ追加コンテンツのクリア
        clearHelpContentsEx(this);
        _Scene_Status_onActorChange.apply(this);
    };


    //- ウインドウ・ステータスベース/ペイント(処理追加)
    if (Window_StatusBase.prototype.paint == Window_Selectable.prototype.paint) {
        Window_StatusBase.prototype.paint = function() {
            Window_Selectable.prototype.paint.call(this);
        };
    }
    const _Window_StatusBase_paint = Window_StatusBase.prototype.paint;
    Window_StatusBase.prototype.paint = function() {
        // 描画前に追加スプライトをクリア
        const upperSprite = this._upperSpriteKeMnfs;
        if (upperSprite) {
            if (upperSprite.bitmap) { upperSprite.bitmap.clear(); }
            if (upperSprite._clientArea && upperSprite._clientArea.bitmap) {
                upperSprite._clientArea.bitmap.clear();
            }
        }
        const contetnsEx = this._contentsSpriteKeMnfs;
        if (contetnsEx && contetnsEx.bitmap) {
            contetnsEx.bitmap.clear();
        }
        _Window_StatusBase_paint.apply(this);
    };



    //==================================================
    //--  上方スブライト
    //==================================================
    
    //- ウインドウ・ステータスベース/形成(処理追加)
    const _Window_StatusBase_initialize = Window_StatusBase.prototype.initialize;
    Window_StatusBase.prototype.initialize = function(rect) {
        _Window_StatusBase_initialize.apply(this, arguments);
        // 上方スブライトの形成
        createUpperSprite(this);
    };

    //- 上方スブライトの形成
    function createUpperSprite(windo) {
        const scene = SceneManager._scene;
        if (scene.constructor.name != "Scene_Status") { return; }
        windo._upperSpriteKeMnfs = new Sprite_UpperLayerKeMnfs(null, windo, windo._padding);
        addToUpperSprites(windo._upperSpriteKeMnfs);
    };

    //- 上方スブライト群に追加
    function addToUpperSprites(sprite) {
        const scene = SceneManager._scene;
        if (!scene._upperSpritesKeMnfs) { scene._upperSpritesKeMnfs = []; }
        scene._upperSpritesKeMnfs.push(sprite);
    };


    //- 上方スブライト群のチルド
    function childUpperSprites(scene) {
        const upperSprites = scene._upperSpritesKeMnfs;
        if (upperSprites && upperSprites.length) {
            upperSprites.forEach(upperSprite => {
                scene.addChild(upperSprite);
            });
        }
    };


    //- 上方スブライトのクリア予約
    function clearOrderUpperLayerAll(scene) {
        const upperLayers = scene._upperSpritesKeMnfs;
        if (upperLayers && upperLayers.length) {
            upperLayers.forEach(layer => {
                layer._clearOrderKe = true;
            });
        }
    };

    //- 上方スブライトのクリア
    function clearUpperSprite(windo) {
        const upperSprite = windo._upperSpriteKeMnfs;
        if (!upperSprite || !upperSprite._clearOrderKe) { return; }
        upperSprite.clear();
        upperSprite._clearOrderKe = null;
    };


    //- 上方スブライトへのテキスト描画
    function drawTextToUpperSprite(windo, text, x, y, maxWidth, align) {
        if (!windo._upperSpriteKeMnfs) { return false;}
        // 上方スブライトのクリア
        clearUpperSprite(windo);
        const upperSprite = windo._upperSpriteKeMnfs;
        const upperBitmap = upperSprite._clientArea ? upperSprite._clientArea.bitmap : upperSprite.bitmap;
        // 描画位置
        x += windo._padding;
        y += windo._padding;
        // フォント設定のコピー
        copyFontSetting(upperBitmap, windo.contents);
        // 描画
        upperBitmap.drawText(text, x, y, maxWidth, windo.lineHeight(), align);
        // テキスト描画済みフラグをセット
        windo._drawedTextKeMnsk　= true;
        return true;
    };

    //- フォント設定のコピー
    function copyFontSetting(bitmap, oriBitmap) {
        bitmap.fontFace = oriBitmap.fontFace;
        bitmap.fontSize = oriBitmap.fontSize;
        bitmap.textColor = oriBitmap.textColor;
        bitmap.outlineWidth = oriBitmap.outlineWidth;
        bitmap.outlineColor = oriBitmap.outlineColor;
    };


    //- ウインドウ・ステータスベース/内部スプライトの形成(処理追加)
    const _Window_StatusBase_createInnerSprite = Window_StatusBase.prototype.createInnerSprite;
    Window_StatusBase.prototype.createInnerSprite = function(key, spriteClass) {
        const sprite = _Window_StatusBase_createInnerSprite.apply(this, arguments);
        // 上方レイヤーへのチルド
        childToUpperLayer(this, sprite);
        return sprite;
    };


    //- 上方スブライトへのチルド
    function childToUpperLayer(windo, sprite) {
        if (!windo._upperSpriteKeMnfs) { return; }
        windo._upperSpriteKeMnfs.addChild(sprite);
    };


    
    //==================================================
    //--  追加コンテンツスプライト-ステータス
    //==================================================

    //- ウインドウステータス/コンテンツスプライトの形成(処理追加)
    if (Window_Status.prototype._createContentsSprite == Window.prototype._createContentsSprite) {
        Window_Status.prototype._createContentsSprite = function() {
            Window.prototype._createContentsSprite.apply(this);
        };
    };
    const _Window_Status_createContentsSprite =  Window_Status.prototype._createContentsSprite;
    Window_Status.prototype._createContentsSprite = function() {
        // ステータス追加コンテンツスブライトの形成
        this._contentsSpriteKeMnfs = new Sprite_UpperLayerKeMnfs(null, this, this._padding);
        addToUpperSprites(this._contentsSpriteKeMnfs);
        _Window_Status_createContentsSprite.apply(this);
    };


    //- ウインドウステータス/コンテンツの更新(処理追加)
    if (Window_Status.prototype._updateContents == Window.prototype._updateContents) {
        Window_Status.prototype._updateContents = function() {
            Window.prototype._updateContents.apply(this);
        };
    };
    const _Window_Status_updateContents =  Window_Status.prototype._updateContents;
    Window_Status.prototype._updateContents = function() {
        _Window_Status_updateContents.apply(this);
        // ステータス追加コンテンツの更新
        const bitmap = this._contentsSpriteKeMnfs.bitmap;
        if (bitmap) {
            this._contentsSpriteKeMnfs.setFrame(0, 0, bitmap.width, bitmap.height);
        }
    };


    //- ウインドウステータス/コンテンツの形成(処理追加)
    if (Window_Status.prototype.createContents == Window_Base.prototype.createContents) {
        Window_Status.prototype.createContents = function() {
            Window_Base.prototype.createContents.apply(this);
        };
    };
    const _Window_Status_createContents = Window_Status.prototype.createContents;
    Window_Status.prototype.createContents = function() {
        //Window_Base.prototype.createContents.call(this);
        _Window_Status_createContents.apply(this);
         //- ステータス追加コンテンツの形成
        const width = Graphics.width;
        const height = Graphics.height;
        this._contentsSpriteKeMnfs.bitmap = new Bitmap(width, height);
    };


    ///- ウインドウステータス/コンテンツの破棄(処理追加)
    if (Window_Status.prototype.destroyContents == Window_Base.prototype.destroyContents) {
        Window_Status.prototype.destroyContents = function() {
            Window_Base.prototype.destroyContents.apply(this);
        };
    };
    const _Window_Status_destroyContents =  Window_Status.prototype.destroyContents;
    Window_Status.prototype.destroyContents = function() {
        _Window_Status_destroyContents.apply(this);
        //- ステータス追加コンテンツの破棄
        const contetnsEx = this._contentsSpriteKeMnfs;
        if (contetnsEx && contetnsEx.bitmap) {
            contetnsEx.bitmap.destroy();
        }
    };



    //==================================================
    //--  ステータス自由欄の作成
    //==================================================

    //- ウインドウステータス/経験値の描画(処理追加)
    const _Window_Status_drawExpInfo = Window_Status.prototype.drawExpInfo;
    Window_Status.prototype.drawExpInfo = function(x, y) {
        // 自由欄テキストの取得
        if (getFreeText(this._actor)) { return; };  
        _Window_Status_drawExpInfo.apply(this, arguments);
    };

    //- ウインドウステータス/ブロックの描画2(処理追加)
    const _Window_Status_drawBlock2 = Window_Status.prototype.drawBlock2;
    Window_Status.prototype.drawBlock2 = function() {
        _Window_Status_drawBlock2.apply(this);
        // ステータス自由欄の描画
        drawFreeSpaceStatus(this, this._actor);
    };

    //- ステータス自由欄の描画
    function drawFreeSpaceStatus(windo, actor) {
        const layout = keke_freeSpaceStatus;
        const fontSize = getFontSize(layout["文字サイズ"]);
        const outWidth = layout["文字縁取り幅"] || windo.contents.outlineWidth;;
        // 自由欄テキストの取得
        const text = getFreeText(actor, fontSize);
        if (!text) { return; }
        // コンテンツ取得 & クリア
        const contents = windo.contents;
        const contentsEx = windo._contentsSpriteKeMnfs.bitmap;
        contentsEx.clear();
        // コンテンツを入れ替え
        windo.contents = contentsEx;
        // フォント設定の構築
        windo._fontSettingKeMnfs = buildFontSetting(contents, { fontSize:fontSize, textColor:layout["文字色"], outWidth:outWidth });
        // 描画
        const padding = windo._padding;
        const x = calcMulti(0, layout["位置X"])[0].val;
        const y = calcMulti(0, layout["位置Y"])[0].val + padding;
        const width = windo.width - x;
        const height = windo.height;
        // バック描画
        if (layout["バック表示"]) {
            const color = layout["バック色"] || "rgba(0, 0, 0, 0)";
            const round = layout["バック丸み"] || 0;
            const marginX = layout["バック余白X"] || 0;
            const marginY = layout["バック余白Y"] || 0;
            const bx = x - marginX - outWidth;
            const by = padding / 2 - marginY;
            fillSquare(contentsEx, bx, by, width + marginX * 2 - padding / 2 + outWidth, height + marginY * 2 - padding, color, 0, round);
        }
        // テキスト描画
        windo.drawTextEx(text, x, y, width);
        // フォント設定を消去
        windo._fontSettingKeMnfs = null;
        // コンテンツを戻す
        windo.contents = contents;
    };


    //- ウインドウステータス/フォント設定のリセット(処理追加)
    if (Window_Status.prototype.resetFontSettings == Window_Base.prototype.resetFontSettings) {
        Window_Status.prototype.resetFontSettings = function() {
            Window_Base.prototype.resetFontSettings.apply(this);
        };
    };
    const _Window_Status_resetFontSettings = Window_Status.prototype.resetFontSettings;
    Window_Status.prototype.resetFontSettings = function() {
        Window_Base.prototype.resetFontSettings.call(this);
        _Window_Status_resetFontSettings.apply(this);
        // 構築したフォント設定を適用
        if (this._fontSettingKeMnfs) {
            // フォント設定の適用
            applyFontSetting(this.contents, this._fontSettingKeMnfs);
        }
    };



    //==================================================
    //--  追加コンテンツスプライト-ヘルプ
    //==================================================

    //- ウインドウヘルプ/コンテンツスプライトの形成(処理追加)
    if (Window_Help.prototype._createContentsSprite == Window.prototype._createContentsSprite) {
        Window_Help.prototype._createContentsSprite = function() {
            Window.prototype._createContentsSprite.apply(this);
        };
    };
    const _Window_Help_createContentsSprite = Window_Help.prototype._createContentsSprite;
    Window_Help.prototype._createContentsSprite = function() {
        // ヘルプ追加コンテンツスブライトの形成
        if (SceneManager._scene.constructor.name == "Scene_Status") {
            this._contentsSpriteKeMnfs = new Sprite_UpperLayerKeMnfs(null, this, this._padding);
            addToUpperSprites(this._contentsSpriteKeMnfs);
        }
        _Window_Help_createContentsSprite.apply(this);
    };


    //- ウインドウヘルプ/コンテンツの更新(処理追加)
    if (Window_Help.prototype._updateContents == Window.prototype._updateContents) {
        Window_Help.prototype._updateContents = function() {
            Window.prototype._updateContents.apply(this);
        };
    };
    const _Window_Help_updateContents = Window_Help.prototype._updateContents;
    Window_Help.prototype._updateContents = function() {
        _Window_Help_updateContents.apply(this);
        // ヘルプ追加コンテンツの更新
        if (SceneManager._scene.constructor.name == "Scene_Status") {
            const bitmap = this._contentsSpriteKeMnfs.bitmap;
            if (bitmap) {
                this._contentsSpriteKeMnfs.setFrame(0, 0, bitmap.width, bitmap.height);
                addToUpperSprites(this._contentsSpriteKeMnfs);
            }
        }
    };


    //- ウインドウヘルプ/コンテンツの形成(処理追加)
    if (Window_Help.prototype.createContents == Window_Base.prototype.createContents) {
        Window_Help.prototype.createContents = function() {
            Window_Base.prototype.createContents.apply(this);
        };
    };
    const _Window_Help_createContents = Window_Help.prototype.createContents;
    Window_Help.prototype.createContents = function() {
        _Window_Help_createContents.apply(this);
        // ヘルプ追加コンテンツの形成
        if (SceneManager._scene.constructor.name == "Scene_Status") {
            const width = Graphics.width;
            const height = Graphics.height;
            this._contentsSpriteKeMnfs.bitmap = new Bitmap(width, height);
        }
    };


    //- ウインドウヘルプ/コンテンツの破棄(処理追加)
    if (Window_Help.prototype.destroyContents == Window_Base.prototype.destroyContents) {
        Window_Help.prototype.destroyContents = function() {
            Window_Base.prototype.destroyContents.apply(this);
        };
    };
    const _Window_Help_destroyContents = Window_Help.prototype.destroyContents;
    Window_Help.prototype.destroyContents = function() {
        _Window_Help_destroyContents.apply(this);
        // ヘルプ追加コンテンツの破棄
        if (SceneManager._scene.constructor.name == "Scene_Status") {
            const contetnsEx = this._contentsSpriteKeMnfs;
            if (contetnsEx && contetnsEx.bitmap) {
                contetnsEx.bitmap.destroy();
            }
        }
    };


    //- ウインドウヘルプ/クリア(処理追加)
    const _Window_Help_clear = Window_Help.prototype.clear;
    Window_Help.prototype.clear = function() {
        _Window_Help_clear.apply(this);
        // ヘルプ追加コンテンツのクリア
        clearHelpContentsEx();
    };

    const _Window_Help_refresh = Window_Help.prototype.refresh;
    Window_Help.prototype.refresh = function() {
        _Window_Help_refresh.apply(this);
        // ヘルプ追加コンテンツのクリア
        clearHelpContentsEx();
    };


    //- ヘルプ追加コンテンツのクリア
    function clearHelpContentsEx(scene) {
        if (!scene) { scene = SceneManager._scene; }
        if (scene.constructor.name != "Scene_Status") { return; }
        const helpWindow = scene._profileWindow;
        if (!helpWindow) { return; }
        const contentsEx = helpWindow._contentsSpriteKeMnfs;
        if (!contentsEx || !contentsEx.bitmap) { return; }
        contentsEx.bitmap.clear();
    };



    //==================================================
    //--  ステータスヘルプ
    //==================================================

    //- ステータスヘルプの表示
    function showStatusHelp(scene, actor) {
        const layout = keke_StatusHelp;
        const fontSize = getFontSize(layout["文字サイズ"]);
        // フリーヘルプの取得
        const text = getFreeHelp(actor, fontSize);
        if (!text) { return; }
        const windo = scene._profileWindow;
        // コンテンツ取得 & クリア
        const contents = windo.contents;
        const contentsEx = windo._contentsSpriteKeMnfs.bitmap;
        contents.clear();
        contentsEx.clear();
        // コンテンツを入れ替え
        windo.contents = contentsEx;
        // フォント設定の構築
        windo._fontSettingKeMnfs = buildFontSetting(contents, { fontSize:fontSize, textColor:layout["文字色"], outWidth:layout["文字縁取り幅"]});
        // 描画
        const padding = windo._padding;
        const x = calcMulti(0, layout["位置X"])[0].val + padding;
        const y = calcMulti(0, layout["位置Y"])[0].val + padding;
        const width = windo.width;
        const height = windo.height;
        // バック描画
        if (layout["バック表示"]) {
            const color = layout["バック色"] || "rgba(0, 0, 0, 0)";
            const round = layout["バック丸み"] || 0;
            const marginX = layout["バック余白X"] || 0;
            const marginY = layout["バック余白Y"] || 0;
            const bx = padding / 2 - marginX;
            const by = padding / 2 - marginY;
            fillSquare(contentsEx, bx, by, width + marginX * 2 - padding, height + marginY * 2 - padding, color, 0, round);
        }
        // テキスト描画
        windo.drawTextEx(text, x, y, width);
        // フォント設定を消去
        windo._fontSettingKeMnfs = null;
        // コンテンツを戻す
        windo.contents = contents;
        // テキスト描画済みフラグをセット
        windo._drawedTextKeMnsk　= true;
    };


    //- ウインドウヘルプ/フォント設定のリセット(処理追加)
    if (Window_Help.prototype.resetFontSettings == Window_Base.prototype.resetFontSettings) {
        Window_Help.prototype.resetFontSettings = function() {
            Window_Base.prototype.resetFontSettings.apply(this);
        };
    };
    const _Window_Help_resetFontSettings = Window_Help.prototype.resetFontSettings;
    Window_Help.prototype.resetFontSettings = function() {
        Window_Base.prototype.resetFontSettings.call(this);
        _Window_Help_resetFontSettings.apply(this);
        // 構築したフォント設定を適用
        if (this._fontSettingKeMnfs) {
            // フォント設定の適用
            applyFontSetting(this.contents, this._fontSettingKeMnfs);
        }
    };



    //==================================================
    //--  ステータス立ち絵
    //==================================================

    // 立ち絵の形成
    function createStand(scene, actor) {
        // 前の立ち絵を消去
        if (scene._standSpriteKeMnfs) {
            const preSprite = scene._standSpriteKeMnfs;
            scene._standSpriteKeMnfs = null;
            scene.removeChild(preSprite);
            preSprite.destroy();
        }
        // 立ち絵データの取得
        const stand = getStandData(actor);
        if (!stand) { return; }
        if (stand["無効"]) { return; }
        // ピクチャの形成
        const standSprite = createPicture(stand, scene);
        if (!standSprite) { return; }
        // チルド
        if (stand["レイヤー"] && stand["レイヤー"].includes("下")) {
            const windowLayerIndex = scene.children.indexOf(scene._windowLayer);
            scene.addChildAt(standSprite, windowLayerIndex - 1);
        } else {
            scene.addChild(standSprite);
        }
        // 変数にセット
        scene._standSpriteKeMnfs = standSprite;
    };



    //==================================================
    //--  ピクチャ
    //==================================================
    
    //- ピクチャの形成
    function createPicture(pict, scene) {
        if (!pict || !pict["画像"]) { return; }
        // ビットマップ形成
        const bitmap = ImageManager.loadPicture(pict["画像"]);
        if (!bitmap) { return { sprite:null }; }
        // スプライト形成
        const sprite = new SpriteKeMnfs(bitmap);
        // 原点
        sprite.anchor.x = pict["原点X"]　!= null ? pict["原点X"] : 0.5;
        sprite.anchor.y = pict["原点Y"] != null ? pict["原点Y"] : 0.5;
        // 位置
        sprite._posXKe = calcMulti(0, pict["位置X"])[0].val;
        sprite._posYKe = calcMulti(0, pict["位置Y"])[0].val;
        sprite.x = sprite._posXKe;
        sprite.y = sprite._posYKe ;
        // 位置寄せ
        sprite._alignXKe = pict["位置寄せX"];
        sprite._alignYKe = pict["位置寄せY"];
        // スケール
        sprite._scaleXKe = pict["スケールX"] || 1;
        sprite._scaleYKe = pict["スケールY"] || 1;
        // 固定幅
        const fixW = newFunc_screenW(pict["横幅"]) || 0;
        const fixH = newFunc_screenW(pict["高さ"]) || 0;
        // 回転角
        sprite._angleKe = pict["回転角"] || 0;
        sprite.rotation = angleToRadian(sprite._angleKe);
        // 不透明度
        sprite.opacity = pict["不透明度"] || 255;
        // カラートーン
        const colorTone = strToColorTone(pict);
        if (colorTone) { sprite.setColorTone(colorTone); }
        // サイズを保存
        sprite._widthKe = fixW * sprite._scaleXKe;
        sprite._heightKe = fixH * sprite._scaleYKe;
        // アニメ
        const openAnime = pict["開始アニメ"];
        const inAnime = pict["表示中アニメ"];
        const animeType = "stand";
        const animeDelay = pict["アニメディレイ"] || 0;
        // ビットマップ読み込み待ち
        bitmap.addLoadListener(() => {
            // ピクチャの仕上げ
            finishPicture(sprite, bitmap, fixW, fixH, scene, openAnime, inAnime, animeType, animeDelay);
        });
        return sprite
    };

    //- ピクチャの仕上げ
    function finishPicture(sprite, bitmap, fixW, fixH, scene, openAnime, inAnime, animeType, animeDelay) {
        if (!sprite.transform) { sprite._breakSetupKe = true;  return; }
        // 親のサイズに合わせる
        adjustParentSize(sprite, bitmap, fixW, fixH);
        // スプライトの標準値を保存
        saveSpriteOriVal(sprite);
        // アニメタイプを取得
        animeType = animeType ? "_" + animeType : "";
        // アニメの呼び出し-開く
        callAnime(sprite, scene, openAnime, "start" + animeType, animeDelay);
        // アニメの呼び出し-表示中
        callAnime(sprite, scene, inAnime, "ing" + animeType, animeDelay);
        // セットアップ完了フラグ
        sprite._isSetupedKe = true;
    }

    //- 親のサイズに合わせる
    function adjustParentSize(sprite, bitmap, fixW, fixH) {
        // サイズ合わせ
        if (fixW) {
            sprite.scale.x = fixW / bitmap.width * sprite._scaleXKe;
        } else if (fixH) {
            sprite.scale.x = fixH / bitmap.height  * sprite._scaleXKe;
        }
        if (fixH) {
            sprite.scale.y = fixH / bitmap.height * sprite._scaleYKe;
        } else if (fixW) {
            sprite.scale.y = fixW / bitmap.width * sprite._scaleYKe;
        }
        // 位置寄せX
        const alignX = sprite._alignXKe;
        const w = bitmap.width * Math.abs(sprite.scale.x);
        if (alignX && alignX != "寄せない") {
            let x = 0;
            if (alignX == "左寄せ") {
                const left = w * sprite.anchor.x;
                x = left;
            } else if (alignX == "中央寄せ") {
                const center = w * (0.5 - sprite.anchor.x);
                x = Graphics.width / 2 - center;
            } else if (alignX === "右寄せ") {
                const right = w * (1 - sprite.anchor.x);
                x = Graphics.width - right;
            }
            sprite.x = x + sprite._posXKe;
        }
        // 位置寄せY
        const alignY = sprite._alignYKe;
        const h = bitmap.height * Math.abs(sprite.scale.y);
        if (alignY && alignY != "寄せない") {
            let y = 0;
            if (alignY == "上寄せ") {
                const up = h * sprite.anchor.y;
                y = up;
            } else if (alignY == "中央寄せ") {
                const center = h * (0.5 - sprite.anchor.y);
                y = Graphics.height / 2 - center;
            } else if (alignY === "下寄せ") {
                const down = h * (1 - sprite.anchor.y);
                y = Graphics.height - down;
            }
            sprite.y = y + sprite._posYKe;
        }
    };
    
    //- スプライトの標準値を保存
    function saveSpriteOriVal(sprite) {
        sprite._posXOriKe = sprite.x;
        sprite._posYOriKe = sprite.y;
        sprite._scaleXOriKe = "*" + sprite.scale.x;
        sprite._scaleYOriKe = "*" + sprite.scale.y;
        sprite._angleOriKe = sprite._angleKe || 0;
        sprite._opacityOriKe = "*" + sprite.opacity / 255;
        sprite._colorToneOriKe = sprite._colorTone.concat();
    };



    //==================================================
    //--  一言メッセージウインドウ
    //==================================================

    function Window_ShortMessageKe() {
        this.initialize(...arguments);
    }
    
    Window_ShortMessageKe.prototype = Object.create(Window_Base.prototype);
    Window_ShortMessageKe.prototype.constructor = Window_ShortMessageKe;

    //- 初期化
    Window_ShortMessageKe.prototype.initialize = function(rect, text = "") {
        Window_Base.prototype.initialize.call(this, rect);
        // メッセージの描画
        this.drawMessage(text);
    };

    //- 一言追加コンテンツの形成
    Window_ShortMessageKe.prototype._createContentsSprite = function() {
        this._contentsSpriteKeMnfs = new SpriteKeMnfs();
        if (SceneManager._scene.constructor.name == "Scene_Status") {
            addToUpperSprites(this._contentsSpriteKeMnfs);
        } else {
            this.addChild(this._contentsSpriteKeMnfs);
        }
        Window.prototype._createContentsSprite.call(this);
    };

    //- 一言追加コンテンツの更新
    Window_ShortMessageKe.prototype._updateContents = function() {
        Window.prototype._updateContents.call(this);
        const bitmap = this._contentsSpriteKeMnfs.bitmap;
        if (bitmap) {
            this._contentsSpriteKeMnfs.setFrame(0, 0, bitmap.width, bitmap.height);
        }
    };

    //- 一言追加コンテンツの形成
    Window_ShortMessageKe.prototype.createContents = function() {
        Window_Base.prototype.createContents.call(this);
        const width = Graphics.width;
        const height = Graphics.height;
        this._contentsSpriteKeMnfs.bitmap = new Bitmap(width, height);
    };

    //- 一言追加コンテンツの破棄
    Window_ShortMessageKe.prototype.destroyContents = function() {
        Window_Base.prototype.destroyContents.call(this);
        const contetnsEx = this._contentsSpriteKeMnfs;
        if (contetnsEx && contetnsEx.bitmap) {
            contetnsEx.bitmap.destroy();
        }
    };

    //- 一言メッセージの描画
    Window_ShortMessageKe.prototype.drawMessage = function(text) {
        const layout = keke_shortMessage;
        let fontSize = getFontSize(layout["文字サイズ"]);
        // コンテンツ取得 & クリア
        const contents = this.contents;
        const contentsEx = this._contentsSpriteKeMnfs.bitmap;
        contents.clear();
        contentsEx.clear();
        // 位置
        const padding = this._padding;
        const isStatus = SceneManager._scene.constructor.name == "Scene_Status";
        const xOffset = isStatus ? this.x + (Graphics.width - Graphics.boxWidth) / 2 : 0;
        const yOffset = isStatus ? this.y + (Graphics.height - Graphics.boxHeight) / 2 : 0;
        const x = calcMulti(0, layout["位置X"])[0].val + padding + xOffset;
        const y = calcMulti(0, layout["位置Y"])[0].val + padding + yOffset;
        const width = this.width - 12;
        const height = this.height;
        // 制御文字の処理
        const r = this.processControlChar(text);
        text = r.text;
        fontSize = r.fontSize || fontSize;
        textColor = r.textColor || layout["文字色"];
        outWidth = r.outWidth || layout["文字縁取り幅"];
        // フォント設定の構築
        this._fontSettingKeMnfs = buildFontSetting(this.contents, { fontSize:fontSize, textColor:textColor, outWidth:outWidth});
        // コンテンツを入れ替え
        this.contents = contentsEx;
        // バック描画
        if (layout["バック表示"]) {
            const color = layout["バック色"] || "rgba(0, 0, 0, 0)";
            const round = layout["バック丸み"] || 0;
            const marginX = layout["バック余白X"] || 0;
            const marginY = layout["バック余白Y"] || 0;
            const bx = padding / 2 - marginX;
            const by = padding / 2 - marginY;
            fillSquare(contentsEx, bx, by, width + marginX * 2 - padding, height + marginY * 2 - padding, color, 0, round);
        }
        // テキスト描画
        this.resetFontSettings();
        const texts = text.split(/\n|\\n/);
        const lineSpace = layout["行間"] || 0;
        let drawY = y;
        texts.forEach(tx => {
            this.drawText(tx, x, drawY, width - padding);
            drawY += fontSize + lineSpace;
        });
        // コンテンツを戻す
        this.contents = contents;
    };

    //- 制御文字の処理
    Window_ShortMessageKe.prototype.processControlChar = function(text) {
        //text = text.replace(/\n/g, "");
        let fontSize = null;
        let textColor = null;
        let outWidth = null;
        // 文字サイズ
        let regExp = /\\fs\[([\d\+\-]*)\]/g;
        while (true) {
            const match = regExp.exec(text);
            if (!match) { break; }
            const str = match[0];
            fontSize = getFontSize(match[1]);
            const a = text.slice(0, regExp.lastIndex - str.length);
            const b = text.slice(regExp.lastIndex);
            text = a + b;
        }
        // 文字色
        regExp = /\\c\[(\d*)\]/g;
        while (true) {
            const match = regExp.exec(text);
            if (!match) { break; }
            const str = match[0];
            textColor = ColorManager.textColor(Number(match[1]));
            const a = text.slice(0, regExp.lastIndex - str.length);
            const b = text.slice(regExp.lastIndex);
            text = a + b;
        }
        // 縁取り幅
        regExp = /\\ow\[(\d*)\]/g;
        while (true) {
            const match = regExp.exec(text);
            if (!match) { break; }
            const str = match[0];
            outWidth = Number(match[1]);
            const a = text.slice(0, regExp.lastIndex - str.length);
            const b = text.slice(regExp.lastIndex);
            text = a + b;
        }
        return { text:text, fontSize:fontSize, textColor:textColor, outWidth:outWidth }
    };

    //- 構築したフォント設定を適用
    Window_ShortMessageKe.prototype.resetFontSettings = function() {
        Window_Base.prototype.resetFontSettings.call(this);
        if (this._fontSettingKeMnfs) {
            // フォント設定の適用
            applyFontSetting(this.contents, this._fontSettingKeMnfs);
        }
    };


    //- シーンベース/ボタンエリアの高さ(処理追加)
    const _Scene_Base_buttonAreaHeight = Scene_Base.prototype.buttonAreaHeight;
    Scene_Base.prototype.buttonAreaHeight = function() {
        let h = _Scene_Base_buttonAreaHeight.apply(this);
        // UIボタンエリアの高さを変更
        if (isValidShortMessage(this)) {
            const areaH = keke_shortMessage["UIボタンエリア高さ"];
            if (areaH) {
                return areaH;
            }
        }
        return h;
    };



    //==================================================
    //--  一言メッセージ
    //==================================================

    //- シーン・メニューベース/ボタンの形成(処理追加)
    const _Scene_MenuBase_createButtons = Scene_MenuBase.prototype.createButtons;
    Scene_MenuBase.prototype.createButtons = function() {
        _Scene_MenuBase_createButtons.apply(this);
        // 一言メッセージの形成
        if (isValidShortMessage(this)) {
            createShortMessage(this);
        }
    };

    //- 一言メッセージの形成
    function createShortMessage(scene) {
        if (!isValidShortMessage(scene)) { return; }
        // キャンセルボタン/ページボタン
        const cancelButton = scene._cancelButton;
        const pageupButton = scene._pageupButton;
        const pagedownButton = scene._pagedownButton;
        // UIボタン幅
        const padding = 12;
        const cancelW = cancelButton ? cancelButton.width + padding : 0;
        const pageW = pageupButton ? (pageupButton.width + pagedownButton.width + 8) : 0;
        // ウインドウ位置/サイズ
        const rect = {};
        rect.x = (pageupButton ? pageW : 0);
        rect.y = scene.buttonAreaTop();
        rect.width = Graphics.width - cancelW - pageW;
        rect.height = scene.buttonAreaHeight();
        // 一言メッセージの取得
        const text = getShortMessage();
        if (!text) { return; }
        // ウインドウ形成
        this._shortMessageWindowKe = new Window_ShortMessageKe(rect, text);
        // チルド
        scene.addWindow(this._shortMessageWindowKe);
    };

    //- 一言メッセージ有効か
    function isValidShortMessage(scene) {
        if (isHideShortMaeeageScene(scene)) { return false; }
        if (!getShortMessage()) { return false; }
        return true;
    };

    //- 一言メッセージ表示しないシーンか
    function isHideShortMaeeageScene(scene) {
        // 表示しないシーン
        const hideScenes = keke_shortMessage["表示しないシーン"];
        if (!hideScenes || !hideScenes.length) { return false; }
        const currentScene = scene.constructor.name;
        for (const name of hideScenes) {
            const hideScene = name.match(/^Scene_/i) ? name : "Scene_" + name;
            if (currentScene == hideScene) { return true;}
        };
        // メインメニューのみ
        if (keke_shortMessage["メインメニューのみ"]) {
            if (scene.constructor.name != "Scene_Menu") { return true; }
        }
        return false;
    };

    //- 一言メッセージの取得
    function getShortMessage() {
        // 条件に合うメッセージを全て取得
        const messages = keke_shortMessageMaking.filter(d => {
            let condition = d["条件"];
            if (condition == null) { return true; }
            condition = (typeof condition == "string") ? condition.replace(/[\x1b\\]/g, "") : condition;
            return newFunc(condition, {}, $gameVariables._data, $gameSwitches._data);
        });
        if (!messages.length) { return; }
        // 表示順を取得
        const order = keke_shortMessage["表示順"] || "リスト順";
        let text = "";
        // リスト順
        if (order == "リスト順") {
            // 番号を取得
            if (!$gameSystem._shortMessageNumberKeMnfs) { $gameSystem._shortMessageNumberKeMnfs = 0; }
            if (!messages[$gameSystem._shortMessageNumberKeMnfs]) { $gameSystem._shortMessageNumberKeMnfs = 0; }
            const number = $gameSystem._shortMessageNumberKeMnfs;
            text = getText(messages[number]["呼ぶテキスト"]);
        // ランダム
        } else {
            text = getText(messages[Math.randomInt(messages.length)]["呼ぶテキスト"]);
        }
        return text;
    };


    //- シーンマップ/初期化(処理追加)
    const _Scene_Map_initialize = Scene_Map.prototype.initialize;
    Scene_Map.prototype.initialize = function() {
        _Scene_Map_initialize.apply(this);
        //- メニューを閉じたときに一言メッセージを進める
        if (SceneManager._scene instanceof Scene_MenuBase) {
            if ($gameSystem._shortMessageNumberKeMnfs == null) { $gameSystem._shortMessageNumberKeMnfs = 0; } else
            { $gameSystem._shortMessageNumberKeMnfs++; }
        }
    };



    //==================================================
    //--  自由欄パック
    //==================================================

    //- 自由欄テキストの取得
    function getFreeText(actor, fontSize) {
        // 自由欄パックの取得
        const pack = getFreePack(actor);
        if (!pack) { return; }
        // テキスト群を取得
        const textList = pack["自由欄テキスト"];
        if (!textList || !textList.length) { return; }
        // 条件検索
        const d = conditionalSearch(textList, actor);
        if (!d) { return; }
        // テキスト名を取得
        const textName = d["呼ぶテキスト"];
        if (!textName) { return; }
        // テキストの取得
        const text = getText(textName);
        return convertText(text, fontSize, actor);
    };

    //- フリーヘルプの取得
    function getFreeHelp(actor, fontSize) {
        // 自由欄パックの取得
        const pack = getFreePack(actor);
        if (!pack) { return; }
        // テキスト群を取得
        const textList = pack["ヘルプテキスト"];
        if (!textList || !textList.length) { return; }
        // 条件検索
        const d = conditionalSearch(textList, actor);
        if (!d) { return; }
        // テキスト名を取得
        const textName = d["呼ぶテキスト"];
        if (!textName) { return; }
        // テキストの取得
        const text = getText(textName);
        return convertText(text, fontSize, actor);
    };

    //- 立ち絵データの取得
    function getStandData(actor) {
        // 自由欄パックの取得
        const pack = getFreePack(actor);
        if (!pack) { return; }
        // 立ち絵リストを取得
        const standList = pack["立ち絵"];
        if (!standList || !standList.length) { return; }
        // 条件検索
        const standData = conditionalSearch(standList, actor);
        return standData;
    };

    //- 自由欄パックの取得
    function getFreePack(actor) {
        // パック名を取得
        const names = totalAllMetaArray(actor, ["ステータス自由欄", "statusFreeSpace"]);
        if (!names || !names.length) { return; }
        const name = names[names.length - 1];
        if (!name) { return; }
        // パックを取得
        const pack = keke_freePackMaking.find(p => p["パック名"] == name);
        return pack;
    };

    //- 条件検索
    function conditionalSearch(list, actor) {
        // 条件に合うデータを取得
        const data = list.find(d => {
            let condition = d["条件"];
            if (condition == null) { return true; }
            condition = (typeof condition == "string") ? condition.replace(/[\x1b\\]/g, "") : condition;
            return newFunc(condition, actor, $gameVariables._data, $gameSwitches._data);
        });
        return data;
    };

    //- テキストの取得
    function getText(textName) {
        const textData = keke_textMaking.find(d => d["テキスト名"] == textName);
        if (!textData) { return ""; }
        return textData["テキスト"] || "";
    };

    //- テキストの置換
    function convertText(text, fontSize, actor) {
        const mainSize = fontSize || $gameSystem.mainFontSize();
        // フォントクリア
        text = text.replace(/\\cl/g, `\\c[0]\\fs[${mainSize}]`);
        // 文字サイズ+-
        let regExp = /\\fs\[([+-]+)(\d+)\]/g;
        while (true) {
            const match = regExp.exec(text);
            if (!match) { break; }
            const str = match[0];
            const symbol = match[1];
            const val = Number(match[2]);
            const size = fontSize + (symbol.includes("+") ? val : -val);
            const a = text.slice(0, regExp.lastIndex - str.length);
            const b = `\\fs[${size}]`;
            const c = text.slice(regExp.lastIndex);
            text = a + b + c;
        }
        // スクリプト
        regExp = /\\sc\[([^\]]+)\]/g;
        while (true) {
            const match = regExp.exec(text);
            if (!match) { break; }
            const str = match[0];
            const code = newFunc(match[1], actor, $gameVariables._data, $gameSwitches._data);
            const a = text.slice(0, regExp.lastIndex - str.length);
            const b = code;
            const c = text.slice(regExp.lastIndex);
            text = a + b + c;
        }
        return text;
    };



    //==================================================
    //-- 文字列基本 /ベーシック
    //==================================================

    //- フォントサイズの取得
    function getFontSize(size, oriSize) {
        if (!oriSize) { oriSize = $gameSystem.mainFontSize(); }
        if (!size) { return oriSize; }
        const sizeStr = size.toString();
        if (sizeStr.includes("+")) {
            const plus = Number(sizeStr.replace("+", ""));
            size = oriSize + plus;
        } else if (sizeStr.includes("-")) {
            const minus = Number(sizeStr.replace("-", ""));
            size = oriSize - minus;
        }
        return Number(size);
    };
    
    //- フォント設定の構築
    function buildFontSetting(contents, d = {}) {
        const cfg = {};
        cfg.fontFace = d.fontFace || contents.fontFace;
        cfg.fontSize = d.fontSize || contents.fontSize;
        cfg.textColor = d.textColor || contents.textColor;
        cfg.outlineWidth = d.outWidth || contents.outlineWidth;
        cfg.outlineColor = d.outColor || "rgba(0, 0, 0, 1)";
        return cfg;
    };

    //- フォント設定の適用
    function applyFontSetting(bitmap, cfg) {
        bitmap.fontFace = cfg.fontFace || bitmap.fontFace;
        bitmap.fontSize = cfg.fontSize || bitmap.fontSize;
        bitmap.textColor = cfg.textColor || bitmap.textColor;
        bitmap.outlineWidth = cfg.outlineWidth || bitmap.outlineWidth;
        bitmap.outlineColor = cfg.outlineColor || bitmap.outlineColor;
    };

    //- 文字列をカラートーンに
    function strToColorTone(strs) {
        const red = strs["カラー赤"] || 0;
        const green= strs["カラー緑"] || 0;
        const blue = strs["カラー青"] || 0;
        const gray = strs["カラー灰"] || 0;
        if (!red && !green && !blue && !gray) { return null; }
        return [red, green, blue, gray];
    };



    //==================================================
    //--  メタ取得 /ベーシック
    //==================================================
    
    //- 全てのメタ配列の合算
    function totalAllMetaArray(battler, words, action, noDelSpace) {
        let data = null
        let array = [];
        // バトラー値
        data = battler._actorId ? battler.actor() : battler.enemy();
        if (data) { metaAll(data.note, words).forEach(e => array.push(e)); }
        if (battler._actorId) {
            // 職業値
            data = battler.currentClass();
            if (data) { metaAll(data.note, words).forEach(e => array.push(e)); }
            // 装備値
            battler._equips.forEach(equip => {
                data = equip.object();
                if (data) { metaAll(data.note, words).forEach(e => array.push(e)); }
            });
        }
        // ステート値
        battler._states.forEach(stateId => {
            data = $dataStates[stateId];
            if (data) { metaAll(data.note, words).forEach(e => array.push(e)); }
        });
        // アクション値
        if (action) {
            data = action.item();
            if (data) { metaAll(data.note, words).forEach(e => array.push(e)); }
        }
        // スペースを削除
        if (!noDelSpace) { array = array.map(e => e.replace(/\s/g, "")); }
        // 空の要素は削除
        array = array.filter(e => e);
        return array;
    };
    
    //- 全取得メタ
    function metaAll(note, words) {
        var result = [];
        words.forEach(word => {
            var regText = '\<' + word + ':([^\>]*)\>';
            var regExp_g = new RegExp(regText, 'ig');
            var regExp = new RegExp(regText);
            var matches = note.match(regExp_g);
            if (matches) {
                matches.forEach(function(line) {
                    const match = line.match(regExp);
                    result.push(match[1]);
                });
            }
        });
        return result;
    };



    //==================================================
    //--  計算基本 /ベーシック
    //==================================================
    
    //- マルチ演算
    function calcMulti(cur, tage, ori, cmds = {}) {
        if (tage == null) { return [{ val:0 }]; }
        const datas = [cur, tage.toString(), ori, cmds];
        cur = cur || 0;
        let tageStr = tage.toString();
        // 画面横幅/縦高を変換
        const matches = tageStr.match(/[\s\d\.\+\-\*\/\%\(\)]*(gw|gh)[\s\d\.\+\-\*\/\%\(\)]*/gi);
        if (matches) {
            matches.forEach(formula => {
                const v = newFunc_screenW(formula);
                tageStr = tageStr.replace(formula, v.toString());
            });
        }
        let tageLine = tageStr.split(",");
        tageLine = tageLine.map(v => v.replace(/\s/g, ""));
        let sols = [];
        tageLine.forEach((tages, i) => {
            const match = tages.match(/^(r*m*s*\/|)\s*([\+\*\/\%\=↑↓←→]*)\s*(\-*\s*\d+\.*\d*)\s*~*(\-*\s*\d*\.*\d*)\s*([\+\*\/\%\=←→↑↓]*)\s*(tn|cg|fk|cf|rd|bk|ei|eo|e|en|)\s*(\(*\-*\s*\d*\.*\d*\)*)\s*(&*b*j*d*c*t*o*)\s*(\_*\-*\s*\d*\.*\d*)$/i);
            if (!match) {
                sols.push({ val:tages, header:"", easing:"", easingRate:1, extra:"", num:0, datas:datas });
                return;
            }
            let val = 0;
            let rvs = 1;
            let header = "";
            let easing = "";
            let easingRate = 1;
            let extra = "";
            let num = 1;
            if (match[1]) {
                header = match[1].replace(/\//g, "").toUpperCase();
                if (header.match(/r/i)) { rvs = -1; }
            }
            if (match[6]) {
                easing = match[6].toUpperCase();
            }
            if (match[7]) {
                const mt = match[7].match(/\-*\d+\.*\d*/);
                easingRate = mt ? Number(mt[0]) : 1;
            }
            if (match[8]) {
                extra = match[8].replace(/&/g, "").toUpperCase();
            }
            if (match[9]) {
                num = Number(match[9].replace(/\_/g, ""));
            }
            if (match[4]) {
                const vs = [Number(match[3]), Number(match[4])];
                vs.sort((a, b) => a - b);
                v = vs[0] + Math.random() * (vs[1] - vs[0]);
            } else {
                v = Number(match[3]);
            }
            const symbol = (match[2] || "") + (match[5] || "");
            if (cmds.noMinus && !symbol && v < 0) {
                symbol = "+";
            }
            if (symbol.includes("+")) {
                val = Number(cur) + v * rvs;
            } else if (symbol.includes("*")) {
                val = Number(cur) * v * rvs;
            } else if (symbol.includes("/")) {
                val = Number(cur) / v * rvs;
            } else if (symbol.includes("%")) {
                val = Number(cur) % v * rvs;
            } else if (symbol.includes("←")) {
                val = Number(cur) - v * rvs;
            } else if (symbol.includes("→")) {
                val = Number(cur) + v * rvs;
            } else if (symbol.includes("↑")) {
                val = Number(cur) - v * rvs;
            } else if (symbol.includes("↓")) {
                val = Number(cur) + v * rvs;
            } else {
                val = v * rvs;
                if (ori && !symbol.includes("=")) {
                    if (ori.toString().includes("*")) {
                        val *= Number(ori.replace(/\*/g, ""));
                    } else {
                        val += ori;
                    }
                }
            }
            sols.push({ val:val, header:header, easing:easing, easingRate:easingRate, extra:extra, num:num, datas:datas });
        });
        return sols;
    };

    //- 小数点を丸める
    function roundDecimal(val, rate) {
        const newVal = Math.floor(val* rate) / rate
        return newVal;
    };
    
    //- 時間の作成
    function makeTime(time) {
        if (!time) { return 0; }
        time = time.toString();
        if (time.includes("~")) {
            return randomise(time);
        } else {
            return convertSecond(time);
        }
    };

    //- ランダマイズ
    function randomise(str) {
        const strs = str.split("~");
        const vals = [convertSecond(strs[0]), convertSecond(strs[1])];
        vals.sort((a, b) => a - b);
        return vals[0] + Math.random() * (vals[1] - vals[0]);
    };

    //- 秒を変換
    function convertSecond(time) {
        return Math.round(Number(time.match(/(\d+\.?\d*)/)[0]) * (time.match(/s/i) ? 60 : 1));
    };



    //==================================================
    //--  位置基本 /ベーシック
    //==================================================
    
    //- 角度を度数に
    function angleToDegree(angle) {
        angle *= (180 / Math.PI);
        if (angle < 0) { angle += 360; };
        return angle;
    };
    
    //- 角度をπに
    function angleToRadian(angle) {
        angle *= (Math.PI / 180);
        return angle;
    };



    //==================================================
    //--  アニメーションの開始 /ベーシック
    //==================================================
    
    //- アニメの呼び出し
    function callAnime(sprite, body, animeName, animeType, delay = 0) {
        if (!animeName) { return; }
        // アニメデータの取得
        const animeDatas = getAnimeData(animeName, animeType, delay);
        // アニメデータのセット
        setAnimeData(sprite, body, animeDatas, delay);
        return true;
    };
    
    //- アニメデータの取得
    function getAnimeData(animeName, animeType, delay = 0) {
        const animeDatas = [];
        if (animeName.constructor.name == "Array") {
            animeName.forEach(name => {
                const args = keke_animeList.filter(d => d["アニメ名"] == name)[0];
                if (args) { animeDatas.push({ args:args, animeType:animeType, delay:delay }); }
            });
        } else {
            const args = keke_animeList.filter(d => d["アニメ名"] == animeName)[0];
            if (args) { animeDatas.push({ args:args, animeType:animeType, delay:delay }); }
        }
        return animeDatas;
    };
    
    //- アニメデータのセット
    function setAnimeData(sprite, body, animeDatas) {
        if (!animeDatas || !animeDatas.length) { return; }
        // シングルアニメの処理
        const animeType = animeDatas[0].animeType;
        const isSingle = animeType == "single";
        if (isSingle) {
            if (sprite._inSingleAnimeKe) { return; }
            sprite._inSingleAnimeKe = true;
        }
        // データを追加
        if (!sprite._animeDatasKe) { sprite._animeDatasKe = []; }
        sprite._animeDatasKe = [...sprite._animeDatasKe, ...animeDatas];
        // アニメ開始スプライテスとしてセット
        if (!body._animeStartSpritesKeMnfs) { body._animeStartSpritesKeMnfs = []; }
        if (!body._animeStartSpritesKeMnfs.some(s => s == sprite)) {
            body._animeStartSpritesKeMnfs.push(sprite);
        }
        // アニメ開始の更新
        updateAnimeStart(sprite, body);
    };
    
    //- アニメ開始の更新
    function updateAnimeStart(sprite, body, force) {
        if (!sprite._animeDatasKe || !sprite._animeDatasKe.length) { return; }
        // データをひとつ取得
        const data = sprite._animeDatasKe[0];
        const animeType = data.animeType;
        // 各アニメウェイト
        if (!force) {
            if (sprite._animationsKe && sprite._animationsKe.some(drift => drift.animeType.includes("start") && !drift.noWait)) { return; }
            if (sprite._animationsKe && sprite._animationsKe.some(drift => drift.animeType.includes("end") && !drift.noWait)) { return; }
            if (animeType.includes("start") && sprite._waitStartAnimeKe) { return; }
            if (animeType.includes("ing") && sprite._waitIngAnimeKe) { return; }
        }
        // データをひとつ消去
        sprite._animeDatasKe.shift();
        // ノーウェイトを解除
        /*if (sprite._animationsKe) {
            sprite._animationsKe.forEach(drift => drift.noWait = false);
        }*/
        // アニメのセット
        setAnime(sprite, body, data);
        // データがなくなったらアニメ開始スプライテスから除外
        let del = false;
        if (!sprite._animeDatasKe.length) {
            body._animeStartSpritesKeMnfs = body._animeStartSpritesKeMnfs.filter(s => s != sprite);
        };
    };
    
    //- 見えないか
    function isNoVisible(sprite) {
        let hide = false;
        while (true) {
            sprite = sprite.parent;
            if (!sprite) { break; }
            if (!sprite.visible) { hide = true; break; }
        }
        return hide;
    };
    
    //- アニメのセット
    function setAnime(sprite, body, data) {
        if (!sprite.transform) { return; }
        const args = data.args;
        const time = makeTime(args["アニメ時間"]) || 1;
        const num = Math.round(Number(args["アニメ回数"])) || 1;
        if (!time || !num) { return; }
        // 回転角の初期化
        if (sprite._angleKe == null) { sprite._angleKe = angleToDegree(sprite.rotation); }
        // 最初の値をセット
        setOpenVal(sprite, args, data);
        // 変動値を取得
        const drift = {};
        drift.animeType = data.animeType;
        drift.timeMax = time
        drift.duration = drift.timeMax;
        drift.timeMaxOri = drift.timeMax;
        drift.num = num;
        // ノーウェイト
        drift.noWait = toBoolean(args["ノーウェイト"]);
        // 挿入ウェイト
        if (args["…挿入ウェイト"]) {
            const insertWait = strToHash(args["…挿入ウェイト"]);
            drift.waitStart = insertWait["ウェイト開始"].clamp(0, time - 1);
            drift.waitTime = insertWait["ウェイト時間"];
            drift.waitStartOri = drift.waitStart;
            drift.inWait = 0;
        }
        // ディレイ
        drift.delay = Number(args["ディレイ"]) || data.delay;
        // 位置X
        if (args["→位置X"] != null) {
            const posXs = calcMulti(sprite.x, args["→位置X"], sprite._posXOriKe);
            drift.posXs = makeDrift(posXs, sprite.x, time, "位置X");
        }
        // 位置Y
        if (args["→位置Y"] != null) {
            const posYs = calcMulti(sprite.y, args["→位置Y"], sprite._posYOriKe);
            drift.posYs = makeDrift(posYs, sprite.y, time, "位置Y");
        }
        // スケールX
        if (args["→スケールX"] != null) {
            const scaleXs = calcMulti(sprite.scale.x, args["→スケールX"], sprite._scaleXOriKe);
            drift.scaleXs = makeDrift(scaleXs, sprite.scale.x, time, "スケールX");
        }
        // スケールY
        if (args["→スケールY"] != null) {
            const scaleYs = calcMulti(sprite.scale.y, args["→スケールY"], sprite._scaleYOriKe);
            drift.scaleYs = makeDrift(scaleYs, sprite.scale.y, time, "スケールY");
        }
        // 回転角
        if (args["→回転角"] != null) {
            const angles = calcMulti(sprite._angleKe, args["→回転角"], sprite._angleOriKe);
            drift.angles = makeDrift(angles, sprite._angleKe, time, "回転角");
        }
        // 不透明度
        if (args["→不透明度"] != null) {
            const opacities = calcMulti(sprite.opacity, args["→不透明度"], sprite._opacityOriKe);
            drift.opacities = makeDrift(opacities, sprite.opacity, time, "不透明度");
        }
        // カラートーン
        ct = [args["→カラー赤"], args["→カラー緑"], args["→カラー青"], args["→カラー灰"]];
        drift.colorTones = [];
        for (let i = 0; i <= 3; i++) {
            if (ct[i] != null) {
                const colorTones = calcMulti(sprite._colorTone[i], ct[i], sprite._colorToneOriKe ? sprite._colorToneOriKe[i] : 0);
                // カラートーンの不透明度補正
                colorTones[0].val = colorToneOpaRevise(colorTones[0].val, sprite.opacity, data.animeType);
                drift.colorTones[i] = makeDrift(colorTones, sprite._colorTone[i], time, "カラートーン");
            }
        }
        // 透明化
        if (args["透明化"]) {
            drift.noVisible = 1;
            sprite._noVisibleKe = true;
            sprite.x -= 10000;
        }
        // アニメタイプをセット
        drift.animeType = data.animeType;
        // 変数にセット
        if (!sprite._animationsKe) { sprite._animationsKe = []; }
        sprite._animationsKe.push(drift);
        // アニメ中スプライテスとしてセット
        if (!body._inAnimeSpritesKeMnfs) { body._inAnimeSpritesKeMnfs = []; }
        if (!body._inAnimeSpritesKeMnfs.some(s => s == sprite)) {
            body._inAnimeSpritesKeMnfs.push(sprite);
        }
    };

    //- 計算記号の調整
    function adjustSymbol(val, symbol = "*") {
        if (!val) { return val; }
        if (val.match(/\+|\-|\*|\/|\%|\=|↑|↓|←|→/i)) {
            return val;
        } else if (val.match(/tn|rd|bk/i)) {
            return symbol + val;
        } else {
            return val;
        }
    };

    //- カラートーンの不透明度補正
    function colorToneOpaRevise(val, bodyOpa, animeType) {
        if (!val) { return val; }
        let match = animeType.match(/opa(\d+)/i);
        if (!match) { return val; }
        const opaCenter = Number(match[1]);
        return Math.round(val * (opaCenter / bodyOpa)).clamp(0, 255);
    };
    
    //- 最初の値をセット
    function setOpenVal(sprite, args, data) {
        if (args["位置X"] != null) { sprite.x = calcMulti(sprite.x, args["位置X"], sprite._posXOriKe)[0].val; }
        if (args["位置Y"] != null) { sprite.y = calcMulti(sprite.y, args["位置Y"], sprite._posYOriKe)[0].val; }
        if (args["スケールX"] != null) {
            sprite.scale.x = calcMulti(sprite.scale.x, args["スケールX"], sprite._scaleXOriKe)[0].val;
        }
        if (args["スケールY"] != null) {
            sprite.scale.y = calcMulti(sprite.scale.y, args["スケールY"], sprite._scaleYOriKe)[0].val;
        }
        if (args["回転角"] != null) {
            sprite._angleKe = calcMulti(sprite._angleKe, args["回転角"], sprite._angleOriKe)[0].val;
            sprite.rotation = angleToRadian(sprite._angleKe);
        }
        if (args["不透明度"] != null) { sprite.opacity = calcMulti(sprite.opacity, args["不透明度"], sprite._opacityOriKe)[0].val; }
        if (args["カラー赤"] != null || args["カラー緑"] != null || args["カラー青"] != null || args["カラー灰"] != null) {
            let ct = [args["カラー赤"], args["カラー緑"], args["カラー青"], args["カラー灰"]];
            for (let i = 0; i <= 3; i++) {
                if (ct[i] != null) {
                    sprite._colorTone[i] = calcMulti(sprite._colorTone[i], ct[i], sprite._colorToneOriKe[i])[0].val;
                    // カラートーンの不透明度補正
                    sprite._colorTone[i] = colorToneOpaRevise(sprite._colorTone[i], sprite.opacity, data.animeType);
                }
            }
            sprite._updateColorFilter();
        }
    };
    
    //- 変動の作成
    function makeDrift(datas, current, time, word) {
        if (!datas || !datas.length) { return; }
        if (word == "回転角") { current %= 360; }
        let ds = [];
        // データの数だけ処理
        datas.forEach(data => {
            if (data.val == null) { return; }
            const d = {};
            d.num = data.num || 1;
            d.datas = data.datas || ["", ""];
            const extra = data.extra || "";
            d.break = extra.includes("B");
            d.jump = extra.includes("J");
            d.direction = extra.includes("D");
            d.isCos = extra.includes("C");
            d.isRandom = d.datas[1].includes("~");
            d.easing = data.easing || "E";
            d.easingRate = data.easingRate || 1;
            d.timeMax = time / d.num;
            d.duration = d.timeMax;
            d.start = roundDecimal(current, 1000000);
            d.target = Number(data.val);
            d.vol = d.target - d.start;
            d.current = d.start;
            d.end = 0;
            // 終点
            if (d.easing == "TN" || d.easing == "RD") {
                d.end = d.start;
            } else {
                d.end = d.target;
            }
            ds.push(d);
        });
        return ds;
    };
    
    
    
    //==================================================
    //--  アニメーションの更新 /ベーシック
    //==================================================
    
    //- アニメスプライトの更新
    function updateAnimeSprite(body) {
        if (!body) { return; }
        // アニメ開始スプライトの更新
        updataAnimeStartSprite(body);
        // アニメ中スプライトの更新
        updataInAnimeSprites(body);
    };
    
    //- アニメ開始スプライトの更新
    function updataAnimeStartSprite(body) {
        if (!body._animeStartSpritesKeMnfs || !body._animeStartSpritesKeMnfs.length) { return; }
        let del = false;
        body._animeStartSpritesKeMnfs.forEach((sprite, i) => {
            if (!sprite || !sprite.parent) {
                destroySprite(sprite);
                body._animeStartSpritesKeMnfs[i] = null;
                del = true;
                return;
            }
            // アニメ開始の更新
            del = updateAnimeStart(sprite, body);
        });
        if (del) { body._animeStartSpritesKeMnfs = body._animeStartSpritesKeMnfs.filter(s => s); }
    };
    
    //- アニメ中スプライトの更新
    function updataInAnimeSprites(body) {
        if (!body._inAnimeSpritesKeMnfs || !body._inAnimeSpritesKeMnfs.length) { return; }
        let del = false;
        body._inAnimeSpritesKeMnfs.forEach((sprite, i) => {
            if (!sprite || !sprite.parent) {
                destroySprite(sprite);
                body._inAnimeSpritesKeMnfs[i] = null;
                del = true;
                return;
            }
            // アニメの更新
            if (updateAnime(sprite, body)) {
                body._inAnimeSpritesKeMnfs[i] = null;
                del = true;
            }
        });
        if (del) {
            body._inAnimeSpritesKeMnfs = body._inAnimeSpritesKeMnfs.filter(s => s);
            // 終了アニメの完了判定
            if (!body._inAnimeSpritesKeMnfs.length && inEndAnime(body)) {
                // アニメ終了時関数の実行
                doAnimeEndFunc(body);
            }
        }
    };
    
    //- アニメの更新
    function updateAnime(sprite, body) {
        if (!sprite._animationsKe || !sprite._animationsKe.length) { return; }
        let end = false;
        let del = false;
        let single = false;
        let destroy = false;
        // データごとに処理
        sprite._animationsKe.forEach((drift, i) => {
            // アニメの更新-個別
            drift = updateAnimeEach(sprite, drift, i, body);
            if (!sprite.transform || !drift || drift.terminate) {
                sprite._animationsKe[i] = null;
                end = true;
                // シングル判定
                if (drift && drift.animeType.includes("single")) { single = true; }
                // 破棄判定
                if (drift && drift.animeType.includes("destroy")) { destroy = true; }
            }
        });
        // null を消去
        if (end) {
            sprite._animationsKe = sprite._animationsKe.filter(d => d);
            // アニメの終了
            endAnime(sprite, body, single, destroy);
            if (!sprite._animationsKe.length) { del = true; }
        }
        return del;
    };

    //- アニメの更新-個別
    function updateAnimeEach(sprite, drift, i, body) {
        if (!sprite.transform || !drift) { return drift; }
        // ループアニメの停止
        if (sprite._stopLoopAnimeKe && drift.num < 0) {
            if (sprite._stopLoopAnimeKe == 1) {
                // アニメの中断
                breakAnime(sprite, drift);
                sprite._stopLoopAnimeKe = 2;
            } else {
                return drift;
            }
        };
        // フリーズ
        if (drift.freeze) {
            return drift;
        }
        // 挿入ウェイト
        if (drift.inWait) {
            drift.inWait--;
            return drift
        }
        if (drift.waitStart == drift.dura && drift.waitTime) {
            drift.waitStart = null;
            drift.inWait = drift.waitTime;
            return drift
        }
        // ディレイ
        if (drift.delay) {
            drift.delay--;
            return drift;
        }
        // 位置X
        if (drift.posXs && drift.posXs.length) {
            let moveXs = updateDrift(drift.posXs, "位置X");
            moveXs.forEach(v => sprite.x += v);
        }
        // 位置Y
        if (drift.posYs && drift.posYs.length) {
            let moveYs = updateDrift(drift.posYs, "位置Y");
            moveYs.forEach(v => sprite.y += v);
        }
        // スケールX
        if (drift.scaleXs && drift.scaleXs.length) {
            let scaleXs = updateDrift(drift.scaleXs, "スケールX");
            scaleXs.forEach(v => sprite.scale.x += v);
        }
        // スケールY
        if (drift.scaleYs && drift.scaleYs.length) {
            let scaleYs = updateDrift(drift.scaleYs, "スケールY");
            scaleYs.forEach(v => sprite.scale.y += v);
        }
        // 回転角
        if (drift.angles && drift.angles.length) {
            let angles = updateDrift(drift.angles, "回転角");
            angles.forEach(v => sprite._angleKe += v);
            sprite.rotation = angleToRadian(sprite._angleKe);
        }
        // 不透明度
        if (drift.opacities && drift.opacities.length) {
            let opacities = updateDrift(drift.opacities, "不透明度");
            opacities.forEach(v => sprite.opacity += v);
        }
        // カラートーン
        if (drift.colorTones && drift.colorTones.length && drift.colorTones.some(c => c.length)) {
            let colorTones = [];
            for (let j = 0; j < 4; j++) {
                if (!drift.colorTones[j]) { continue; }
                colorTones[j] = updateDrift(drift.colorTones[j], "カラートーン");
                colorTones[j].forEach(v => {
                    sprite._colorTone[j] += v;
                });
            }
            sprite._updateColorFilter();
        }
        // カウント
        drift.duration--;
        // 終了
        if (drift.duration <= 0) {
            if (drift.num >= 0) { drift.num--; }
            // 非ループ時
            if (!drift.num) {
                drift.terminate = true;
            // ループ時
            } else {
                // 変動値の再セット
                resetDrift(sprite, drift, sprite, i);
                drift.duration = drift.timeMax;
            }
        }
        return drift;
    };

    //- 透明化の解除
    function remNoVisible(sprite) {
        if (!sprite || !sprite.parent || !sprite.transform || sprite._noVisibleKe) { return; }
        if (sprite.x > -5000) { return; }
        sprite.x += 10000;
    };
    
    //- 変動の更新
    function updateDrift(ds, word) {
        let rs= []
        // データを全て処理
        ds.forEach(d => {
            // カウントを減らす
            d.duration--;
            let r = 0;
            next = applyEasing(d.current, d.start, d.target, d.duration, d.timeMax, d.easing, d.easingRate);
            r = next - d.current;
            d.current = next;
            // 終了
            if (d.duration <= 0) {
                // 終了値に合わせる
                r += roundDecimal(d.end - next, 1000000);
                d.num--;
                d.duration = d.timeMax;
            }
            if (r) { rs.push(r); }
        });
        return rs;
    };
    
    
    
    //==================================================
    //--  アニメーションの終了 /ベーシック
    //==================================================
    
    //- アニメの終了
    function endAnime(sprite, body, single, destroy) {
        // アニメ中スプライトから除外
        if (!sprite._animationsKe.length && body._inAnimeSpritesKeMnfs) { 
            //body._inAnimeSpritesKeMnfs = body._inAnimeSpritesKeMnfs.filter(s => s != sprite);
        }
        // シングル終了
        if (single) { sprite._inSingleAnimeKe = false; }
        // 破棄
        if (destroy) { destroySprite(sprite); }
    };
    
    //- 変動値の再セット
    function resetDrift(sprite, drift, sprite, time) {
        //if (!drift.isRandom) { return; }
        const keys = ["posXs", "posYs", "scaleXs", "scaleYs", "angles", "opacities", "colorTones"];
        const curs = ["x", "y", "scale.x", "scale.y", "_angleKe", "opacity", "_colorTone"];
        const words = ["位置X", "位置Y", "スケールX", "スケールY", "回転角", "不透明度", ["カラー赤", "カラー緑", "カラー青", "カラー灰"]];
        const oris = ["posXOri", "posYOri", "scaleXOri", "scaleYOri", "angleOri", "opacityOri", "colorToneOri", ];
        // キーごとに処理
        keys.forEach((key, j) => {
            if (!drift[key] || !drift[key].length) { return; }
            const ds = drift[key];
            // カラートーンの場合
            if (key == "colorTones") {
                ds.forEach((cols, c) => {
                    if (!cols.length) { return; }
                    const datas = cols[0].datas;
                    datas[2] = sprite["_"+oris[j]+"Ke"][c];
                    const current = sprite[curs[j]][c];
                    const newData = calcMulti(current, datas[1], datas[2], datas[3]);
                    // カラートーンの不透明度補正
                    newData[0].val = colorToneOpaRevise(newData[0].val, sprite.opacity, drift.animeType);
                    drift[key][c] = makeDrift(newData, current, drift.timeMax, words[j][c]);
                });
                return
            };
            // それ以外の場合
            const datas = ds[0].datas;
            datas[2] = sprite["_"+oris[j]+"Ke"];
            let current = 0;
            if (curs[j].includes("scale")) {
                const cs = curs[j].split(".");
                current = sprite[cs[0]][cs[1]] || 0;
            } else {
                current = sprite[curs[j]] || 0;
            }
            //if (key == "angles") { current = loopAngle(Math.ceil(current)); }
            const newData = calcMulti(current, datas[1], datas[2], datas[3]);
            drift[key] = makeDrift(newData, current, drift.timeMax, words[j]);
        });
        // アニメ時間
        drift.timeMax = drift.timeMaxOri;
    };
    
    // スプライト標準値の復帰
    function restoreSpriteOriVar(sprite) {
        if (!(sprite instanceof Sprite) || !sprite.transform) { return; }
        if (sprite._scaleXOriKe != null) { sprite.scale.x = Number(sprite._scaleXOriKe.replace("\*", "")); }
        if (sprite._scaleYOriKe != null) { sprite.scale.y = Number(sprite._scaleYOriKe.replace("\*", "")); }
        if (sprite._angleOriKe != null) { sprite._angleKe = sprite._angleOriKe; }
        if (sprite._opacityOriKe) { sprite.opacity = 255 * Number(sprite._opacityOriKe.replace("\*", "")) }
        if (sprite._colorToneOriKe != null) { sprite.setColorTone(sprite._colorToneOriKe); }
    };

    //- アニメの停止
    function stopAnime(sprite, animeType, instant) {
        // アニメデータ
        if (sprite._animeDatasKe) {
            sprite._animeDatasKe = sprite._animeDatasKe.filter(data => animeType && data.aniemType != animeType)
        }
        // アニメ中
        if (sprite._animationsKe) {
            sprite._animationsKe.forEach(drift => {
                if (!animeType || drift.animeType == animeType) {
                    // アニメの中断
                    breakAnime(sprite, drift, instant);
                };
            });
        }
    };
    
    //- アニメの中断
    function breakAnime(sprite, drift, instant) {
        if (!drift) { return; }
        Object.keys(drift).forEach(k => {
            const ds = drift[k];
            if (!ds) { return; }
            if (ds.constructor.name == "Array") {
                ds.forEach(d => {
                    if (d.constructor.name == "Array") {
                        d.forEach(c => c.duration = 1);
                    } else {
                        d.duration = 1;
                    }
                });
            }
        });
        drift.duration = 1;
        drift.num = 1;
        if (instant) { updateAnime(sprite, instant); }
    };
    
    //- アニメの全終了
    function allEndAnime(body) {
        // アニメ開始スプライテス
        const aniDataSprites = body._animeStartSpritesKeMnfs;
        if (aniDataSprites) {
            aniDataSprites.forEach(sprite => sprite ? sprite._animeDatasKe = null : 0);
        }
        body._animeStartSpritesKeMnfs = null;
        // アニメ中スプライテス
        const inAnimeSprites = body._inAnimeSpritesKeMnfs;
        if (inAnimeSprites) {
            inAnimeSprites.forEach(sprite => sprite ? sprite._animationsKe = null : 0);
        }
        body._inAnimeSpritesKeMnfs = null;
    };
    
    //- アニメ終了時関数のセット
    function setAnimeEndFunc(body, func, ...args) {
        body._animeEndFuncKe = { func:func, args:args };
    };
    
    //- アニメ終了時関数の実行
    function doAnimeEndFunc(body) {
        if (!body._animeEndFuncKe) { return; }
        const funcs = body._animeEndFuncKe;
        funcs.func(...funcs.args);
        body._animeEndFuncKe = null;
    };
    
    //- アニメ実行中か
    function isAnimeRunning(sprite) {
        return ((sprite._animeDatasKe && sprite._animeDatasKe.length) || (sprite._animationsKe && sprite._animationsKe.length));
    };
    
    //- アニメ中か
    function inAnime(body) {
        return (body._animeStartSpritesKeMnfs && body._animeStartSpritesKeMnfs.length) || (body._inAnimeSpritesKeMnfs && body._inAnimeSpritesKeMnfs.length)
    };
    
    //- 終了アニメ中か
    function inEndAnime(body) {
        return body._inEndAnimeKe;
    };



    //==================================================
    //--  イージング /ベーシック
    //==================================================

    //- イージングの適用
    function applyEasing(current, start, target, duration, timeMax, easing, easingRate = 1) {
        // イージングの処理
        if (easing.match(/ei|eo|e|en/i)) {
            return processEasing(current, target, duration + 1, timeMax, easing, easingRate);
        }
        // カービング
        if (easing.match(/tn|cg|fk|cf|rd|bk/i)) {
            return processCurving(current, start, target, duration + 1, timeMax, easing, easingRate);
        }
    };
    
    //- イージングの処理
    function processEasing(current, target, duration, timeMax, easing, easingRate = 1) {
        const lt = calcEasing((timeMax - duration) / timeMax, easing, easingRate);
        const t = calcEasing((timeMax - duration + 1) / timeMax, easing, easingRate);
        const start = (current - target * lt) / (1 - lt);
        return start + (target - start) * t;
    };
    
    //- イージングの計算
    function calcEasing(t, easing, easingRate = 1) {
        const exponent = 2 * easingRate;
        switch (easing.toUpperCase()) {
            case "EI":
                return easeIn(t, exponent);
            case "EO":
                return easeOut(t, exponent);
            case "E":
                return easeInOut(t, exponent);
            case "EN":
                return t;
            default:
                return t;
        }
    };
    
    //- 各イージング処理
    function easeIn(t, exponent) {
        return Math.pow(t, exponent) || 0.001;
    };
    
    function easeOut(t, exponent) {;
        return 1 - (Math.pow(1 - t, exponent) || 0.001);
    };
    
    function easeInOut(t, exponent) {
        if (t < 0.5) {
            return easeIn(t * 2, exponent) / 2;
        } else {
            return easeOut(t * 2 - 1, exponent) / 2 + 0.5;
        }
    };
    
    //- カービングの処理
    function processCurving(current, start, target, duration, timeMax, easing, easingRate = 1) {
        // 0 の時の処理
        if (duration <= 0) { return easing.match(/tn|rd|bk/i) ? start : target; }
        let result = 0;
        // ターン
        if (easing.toUpperCase() == "TN") {
            result = processTurn(current, start, target, duration, timeMax, easingRate);
        // チャージ
        } else if (easing.toUpperCase() == "CG") {
            result = processCharge(current, start, target, duration, timeMax, easingRate);
        // フック
        } else if (easing.toUpperCase() == "FK") {
            result = processFook(current, start, target, duration, timeMax, easingRate);
        // チャージフック
        } else if (easing.toUpperCase() == "CF") {
            result = processChargeFook(current, start, target, duration, timeMax, easingRate);
        // ラウンド
        } else if (easing.toUpperCase() == "RD") {
            result = processRound(current, start, target, duration, timeMax, easingRate);
        // バック
        }  else if (easing.toUpperCase() == "BK") {
            result = processBack(current, start, target, duration, timeMax, easingRate);
        }
        return result;
    };
    
    //- ターンの処理
    function processTurn(current, start, target, duration, timeMax, easingRate) {
        let result = 0;
        const d1 = Math.round(timeMax / 2);
        const d2 = timeMax - d1;
        if (duration > d2) {
            result = processEasing(current, target, duration - d2, d1, "eo", easingRate);
        } else {
            result = processEasing(current, start, duration, d2, "ei", easingRate);
        }
        return result;
    };
    
    //- チャージの処理
    function processCharge(current, start, target, duration, timeMax, easingRate) {
        let result = 0;
        const d1 = Math.round(timeMax / 3);
        const d2 = timeMax - d1;
        if (duration > d2) {
            result = processEasing(current, start + (start - target) * easingRate, duration - d2, d1, "e");
        } else {
            result = processEasing(current, target, duration, d2, "e");
        }
        return result;
    };
    
    //- フックの処理
    function processFook(current, start, target, duration, timeMax, easingRate) {
        let result = 0;
        const d1 = Math.round(timeMax * 2 / 3);
        const d2 = timeMax - d1;
        if (duration > d2) {
            result = processEasing(current, target + (target - start) * easingRate, duration - d2, d1, "e");
        } else {
            result = processEasing(current, target, duration, d2, "e");
        }
        return result;
    };
    
    //- チャージフックの処理
    function processChargeFook(current, start, target, duration, timeMax, easingRate) {
        let result = 0;
        const d1 = Math.round(timeMax / 4);
        const d3 = Math.round(timeMax / 4);
        const d2 = timeMax - d1 - d3;
        if (duration > (d2 + d3)) {
            result = processEasing(current, start + (start - target) * easingRate, duration - d2 - d3, d1, "e");
        } else if (duration > d3) {
            result = processEasing(current, target + (target - start) * easingRate, duration - d3, d2, "e");
        } else {
            result = processEasing(current, target, duration, d3, "e");
        }
        return result;
    };
    
    //- ラウンドの処理
    function processRound(current, start, target, duration, timeMax, easingRate) {
        let result = 0;
        const d1 = Math.round(timeMax / 4);
        const d2 = Math.round(timeMax / 2);
        const d3 = timeMax - d1 - d2;
        if (duration > (d2 + d3)) {
            result = processEasing(current, target, duration - d2 - d3, d1, "eo");
        } else if (duration > d3) {
            result = processEasing(current, start + (start - target) * easingRate, duration - d3, d2, "e");
        } else {
            result = processEasing(current, start, duration, d3, "ei");
        }
        return result;
    };
    
    //- バックの処理
    function processBack(current, start, target, duration, timeMax, easingRate) {
        let result = 0;
        const d1 = 1;
        const d2 = timeMax - d1;
        if (duration > d2) {
            result = processEasing(current, target, duration - d2, d1, "e", easingRate);
        } else {
            result = processEasing(current, start, duration, d2, "e", easingRate);
        }
        return result;
    };



    //==================================================
    //--  図形描画 /ベーシック
    //==================================================
    
    //- スクエアの塗り潰し
    function fillSquare(bitmap, x, y, w, h, color = "rgba(0,0,0,1)", roundLine = 0, roundEdge = 0, corner = "") {
        const context = bitmap.context;
        context.save();
        if (Array.isArray(color)) {
            const x1 = x + w;
            const y1 = y + h;
            const grad = context.createLinearGradient(x, y, x1, y1);
            grad.addColorStop(0, color[0]);
            grad.addColorStop(1, color[1]);
            context.fillStyle = grad;
        } else {
            context.fillStyle = color;
        }
        designSquare(bitmap, x, y, w, h, roundLine, roundEdge, corner);
        context.fill();
        context.restore();
        bitmap._baseTexture.update();
    };
    
    //- スクエアの線画
    function strokeSquare(bitmap, x, y, w, h, color = "rgba(0,0,0,1)", lineW = 1,  roundLine = 0, roundEdge = 0, corner = "") {
        const context = bitmap.context;
        context.strokeStyle = color;
        context.lineWidth = lineW;
        designSquare(bitmap, x, y, w, h, roundLine, roundEdge, corner, lineW);
        context.stroke();
        context.restore();
        bitmap._baseTexture.update();
    };
    
    //- スクエアのデザイン
    function designSquare(bitmap, x, y, w, h, roundLine = 0, roundEdge = 0, corner = "", lineW = 0, airUp) {
        const context = bitmap.context;
        context.beginPath();
        const x2 = x + w / 2;
        const y2 = y + h / 2;
        const x3 = x + w;
        const y3 = y + h;
        const c1 = corner.includes("1") ? 0 : roundEdge;    // 左上
        const c2 = corner.includes("2") ? 0 : roundEdge;    // 左下
        const c3 = corner.includes("3") ? 0 : roundEdge;    // 右上
        const c4 = corner.includes("4") ? 0 : roundEdge;    // 右下
        context.moveTo(x + c1,  y);
        // 右上
        if (roundLine && !airUp) {
            context.quadraticCurveTo(x2,  y + roundLine,  x3 - c3,  y);
        } else {
            context.lineTo(x3 - c3,  y);
        }
        context.quadraticCurveTo(x3,  y,  x3,  y + c3);
        // 右下
        if (roundLine) {
            context.quadraticCurveTo(x3 - roundLine,  y2,  x3,  y3 - c4);
        } else {
            context.lineTo(x3,  y3 - c4);
        }
        context.quadraticCurveTo(x3,  y3,  x3 - c4,  y3);
        // 左下
        if (roundLine) {
            context.quadraticCurveTo(x2,  y3 - roundLine,  x + c2,  y3);
        } else {
            context.lineTo(x + c2,  y3);
        }
        context.quadraticCurveTo(x,  y3,  x,  y3 - c2);
        // 左上
        if (roundLine) {
            context.quadraticCurveTo(x + roundLine,  y2,  x,  y + c1);
        } else {
            context.lineTo(x,  y + c1);
        }
        if (c1) {
            context.quadraticCurveTo(x,  y,  x + c1,  y);
        } else {
            context.lineTo(x,  y - lineW / 2);
        }
    };
    
})();