//=============================================================================
// AP2F_ReverseKey.js 第1版
// 
// Copyright © 2024 Ahina
// This work is free. You can redistribute it and/or modify it under the
// terms of the Do What The Fuck You Want To Public License, Version 2,
// as published by Sam Hocevar. See http://www.wtfpl.net/ for more details. 
// 
// 第1版 - 初版
// 第2版 - 一部処理の記述を変更
// 第3版 - 一部処理の記述を変更
//=============================================================================

/*:
 * @target MZ
 * @plugindesc 反転移動
 * @author 安比奈
 * @help
 * 
 * 指定のスイッチがONの場合 移動先が反転します
 * 
 * 
 * @param switchId
 * @text 有効化スイッチID
 * @desc 
 * @type switch
 * @default 0
 */
( function()
{
	"use strict";
	
	const P_name = decodeURIComponent(document.currentScript.src).match(/([^\/]+)\.js$/)[1]; //プラグイン名
	
	const GP = PluginManager.parameters(P_name);
	const PP = {};
	
	PP.switchId = Number(GP.switchId);
	function PF_Vector(g,n)
	{
		const amount = (g - n);
		return g + (amount);
	}
	
	const _Game_Temp_setDestination = Game_Temp.prototype.setDestination;
	Game_Temp.prototype.setDestination = function(x, y)
	{
		let nx = x;
		let ny = y;
		if($gameSwitches.value(PP.switchId))
		{
			nx = PF_Vector($gamePlayer.x,x);
			ny = PF_Vector($gamePlayer.y,y);
		}
		_Game_Temp_setDestination.call(this,nx,ny);
	};
	
	const _Game_Player_getInputDirection  = Game_Player.prototype.getInputDirection;
	Game_Player.prototype.getInputDirection = function()
	{
		let direction = _Game_Player_getInputDirection.apply(this,arguments);
		if($gameSwitches.value(PP.switchId) && direction !== 0)
		{
			return 10 - direction;
		}
		return direction;
    	
	};
	
	
})();
