/*:
 * 「全てのスキル表示」Ver1.00
 * Copyright (c) 2016 夢の村制作委員会
 * This software is released under the MIT License.
 * http://opensource.org/licenses/mit-license.php
 *
 * @plugindesc 戦闘中にスキルタイプ別のコマンドを追加せず、「スキル」コマンドのみを追加します。
 * @author 夢の村制作委員会
 *
 * @help プラグインをONにすると、アクターコマンドにスキルタイプ別のコマンドが追加されず
 * 「スキル」コマンドのみが追加されます。（名称はデータベースの用語の「スキル」コマンド名）
 * 選択すると全タイプのスキルの一覧が表示されます。
 * メニューではこれまで通りタイプ別に分類されます。
 * アクターコマンドが増えすぎて困る場合にどうぞ。
 * 
 * ※再定義を使用しているので、プラグイン管理の上の方に配置することを推奨します。
 * ただし、「YEP_CoreEngine」よりは下にしてください。
 * また、ツクールMVのバージョンアップにより使用できなくなる場合があります。
 * （現在1.3.3に対応）
 */

(function() {
    
    // 再定義「スキルコマンド追加」
    Window_ActorCommand.prototype.addSkillCommands = function() {
        this.addCommand(TextManager.skill, 'skill', true, 0);
    };
    
    // 再定義「スキルリストに含む条件」
    Window_SkillList.prototype.includes = function(item) {
        if ( $gameParty.inBattle() ) {
            return item;// 戦闘中は全てのスキル表示
        }else{
            return item && item.stypeId === this._stypeId;
        }
    };
    
})();