/** 插件参数格式化器 */
class PluginParamsParser {
  constructor(predictEnable = true) {
    this._predictEnable = predictEnable;
  }
  static parse(params, typeData, predictEnable = true) {
    return new PluginParamsParser(predictEnable).parse(params, typeData);
  }
  parse(params, typeData, loopCount = 0) {
    if (++loopCount > 255)
      throw new Error("endless loop error");
    const result = {};
    for (const name in typeData) {
      if (params[name] === "" || params[name] === undefined) {
        result[name] = null;
      }
      else {
        result[name] = this.convertParam(params[name], typeData[name], loopCount);
      }
    }
    if (!this._predictEnable)
      return result;
    if (typeof params === "object" && !(params instanceof Array)) {
      for (const name in params) {
        if (result[name])
          continue;
        const param = params[name];
        const type = this.predict(param);
        result[name] = this.convertParam(param, type, loopCount);
      }
    }
    return result;
  }
  convertParam(param, type, loopCount) {
    if (typeof type === "string") {
      let str = param;
      if (str[0] == '"' && str[str.length - 1] == '"') {
        str = str.substring(1, str.length - 1).replace(/\\n/g, '\n').replace(/\\"/g, '"')
      }
      return this.cast(str, type);
    }
    else if (typeof type === "object" && type instanceof Array) {
      const aryParam = JSON.parse(param);
      if (type[0] === "string") {
        return aryParam.map((strParam) => this.cast(strParam, type[0]));
      } else if (type[0] === "number") {
        return aryParam.map((strParam) => this.cast(strParam, type[0]));
      } else {
        if (!aryParam.length) return [];
        else {
          if (typeof aryParam === "string") {
            return JSON.parse(aryParam);
          } else {
            return aryParam.map((strParam) => this.parse(JSON.parse(strParam), type[0]), loopCount);
          }
        }
      }
    }
    else if (typeof type === "object") {
      return this.parse(JSON.parse(param), type, loopCount);
    }
    else {
      throw new Error(`${type} is not string or object`);
    }
  }
  cast(param, type) {
    switch (type) {
      case "any":
        if (!this._predictEnable)
          throw new Error("Predict mode is disable");
        return this.cast(param, this.predict(param));
      case "string":
        return param;
      case "number":
        if (param.match(/^\-?\d+\.\d+$/))
          return parseFloat(param);
        return parseInt(param);
      case "boolean":
        return param === "true";
      default:
        throw new Error(`Unknow type: ${type}`);
    }
  }
  predict(param) {
    if (param.match(/^\-?\d+$/) || param.match(/^\-?\d+\.\d+$/)) {
      return "number";
    }
    else if (param === "true" || param === "false") {
      return "boolean";
    }
    else {
      return "string";
    }
  }
}
window.PluginParamsParser = PluginParamsParser;