//=============================================================================
// ** RPG Maker MZ - Hakubox_Component_Adventure.js
//=============================================================================

// #region 脚本注释
/*:
 * @plugindesc 定制场景 - 冒险场景 (v1.0.0)
 * @version 1.0.0
 * @author hakubox
 * @email hakubox@outlook.com
 * @target MZ
 * 
 * @help
 * 【与傲娇妹妹的治愈日常】定制插件。
 * 
 * 
 * 
 * @command changeFaceByAdventure
 * @text 修改加奈表情 - 冒险模式
 * 
 * @arg face
 * @text 默认表情
 * @type select
 * @option 普通 - 01
 * @value 01,普通
 * @option 委屈 - 02
 * @value 02,委屈
 * @option 生气 - 03
 * @value 03,生气
 * @option 吃惊 - 04
 * @value 04,吃惊
 * @option 开心 - 05
 * @value 05,开心
 * @option 微笑 - 06
 * @value 06,微笑
 * @option 哭泣 - 07
 * @value 07,哭泣
 * @option 迷惑 - 08
 * @value 08,迷惑
 * @option 爱心眼 - 09
 * @value 09,爱心眼
 * 
 * @arg attach
 * @text 额外表情
 * @type select
 * @option 无
 * @value 
 * @option 脸红1 - a1
 * @value a1,脸红1
 * @option 脸红2 - a2
 * @value a2,脸红2
 * @option 脸黑 - a3
 * @value a3,脸黑
 * 
 * 
 * @command changeTachieDirection
 * @text 切换立绘方向
 * 
 * @arg direction
 * @text 是否往前
 * @desc 立绘的方向，默认为正面
 * @type boolean
 * @on 往前/正面
 * @off 往后/背面
 * @default true
 * 
 * 
 * @command changeTachieIsReached
 * @text 切换立绘姿势（是否伸手）
 * 
 * @arg isReached
 * @text 是否伸手
 * @desc 是否伸手
 * @type boolean
 * @on 伸手
 * @off 不伸手
 * @default true
 * 
 * 
 * @command action_shake
 * @text 立绘动作 - 震动
 * @desc 立绘动作 - 立绘震动
 * 
 * @arg duration
 * @text 帧数
 * @type number
 * @default 30
 * 
 * @arg loop
 * @text 循环次数
 * @desc 循环次数，注意需要是双数
 * @type number
 * @default 1
 * 
 * @arg power
 * @text 强度
 * @desc 震动强度，默认为10
 * @type number
 * @max 100
 * @default 10
 * 
 * @arg frequency
 * @text 频率
 * @desc 震动频率，默认为2
 * @type number
 * @max 100
 * @default 2
 * 
 * @arg dir
 * @text 方向
 * @desc 震动方向，默认为水平
 * @type select
 * @option horizontal - 水平
 * @value horizontal
 * @option vertical - 竖直
 * @value vertical
 * @default horizontal
 * 
 * @arg isWait
 * @text 是否等待
 * @desc 是否等待
 * @type boolean
 * @on 等待
 * @off 不等待
 * @default true
 * 
 * 
 * @command tachieMove
 * @text 角色往前走的效果
 * @desc 角色往前走的效果
 * 
 * @arg isWait
 * @text 是否等待
 * @desc 是否等待
 * @type boolean
 * @on 等待
 * @off 不等待
 * @default true
 * 
 */
// #endregion
(() => {
  /** 插件名称 */
  const PluginName = document.currentScript ? decodeURIComponent(document.currentScript.src.match(/^.*\/(.+)\.js$/)[1]) : "Hakubox_Component_Adventure";


  /** 按钮列表 */
  const buttons = [
    {
      name: '小憩片刻',
      text: '小憩片刻',
      icon: 'icon_zzz',
      get tooltip() {
        return '在森林里休息一会儿…话说真的不会有问题吗？';
      },
      get disabled() { return false; },
      get visible() {
        return Utils_Time.hour < 19;
      },
      onTap() {
        Utils_Actor.live += 20;
        Utils_Time.timeElapse(60 * 2, { mask: true, isSleep: false, delay: 5, callback: () => {
        } });
      }
    }, {
      name: '使用道具',
      text: '使用道具',
      icon: 'icon_box',
      get tooltip() {
        return '要恢复一些体力吗？';
      },
      get disabled() { return false; },
      onTap() {
        SceneManager.push(Scene_Haku_Item);
      }
    }, {
      name: '结束冒险',
      text: '结束冒险',
      icon: 'icon_close',
      get tooltip() {
        return '剩下的还是下次再来探索吧～';
      },
      get disabled() { return false; },
      onTap() {
        useConfirm({
          title: '提示',
          content: '是否要结束冒险？',
          useMask: true,
          okHandler: (info) => {
            info.close();
            this.leaveMap();
          },
          cancelHandler() {
          }
        });
      }
    }
  ];

  /** 特效表 */
  const animeMap = {
    /** 开始动画 */
    start(name, config, callback, interpreter) {
      if (config.isWait === undefined) config.isWait = true;

      const _effect = animeMap[name];
      if (_effect.cache.isStart) {
        console.warn(`特效 ${name} 已经开始播放`);
        return;
      }
      _effect.cache.isStart = true;
      
      if (interpreter && config.isWait && interpreter.wait) interpreter.wait(_effect.duration);

      const _start = () => {
        useTimeout(() => {
          callback && callback();
          _effect.cache.isStart = false;
        }, _effect.duration, (progress, frameIndex) => {
          _effect.start.call(this, _effect, progress, frameIndex, config);
        });
      };

      if (_effect.prepare) {
        _effect.prepare.call(this, _effect, _start, config);
      } else {
        _start();
      }
    },
    /** 移动动画 */
    move: {
      duration: 20,
      cache: {},
      prepare(effect, callback) {
        // Promise.all([
        //   ImageManager.loadImg('actor/kana/entrance/bg'),
        // ]).then(imgs => {
        //   this.cache.bg = new Sprite(imgs[0]);
        //   this.cache.bg.alpha = 0;
        //   container.addChild(this.cache.bg);
          
        //   callback(imgs);
        // })

        callback();
      },
      start(effect, progress, frameIndex) {
        // if (frameIndex >= 40 && frameIndex < 80) {
        //   this.cache.bg.alpha = (frameIndex - 40) / 40;
        // }
        
        this.cursorPanel.alpha = progress;

        this.drawMiniMapData({ progress });
        
        this.updateCardListData(frameIndex);

        // const _miniMapList = this.miniMapContentContainer.children;

        // for (let i = 0; i < _miniMapList.length; i++) {
        //   const _item = _miniMapList[i];
        //   _item.y += 0.5;
        //   console.log('_item.y', _item.y);
        // }
      },
      end(effect, progress, frameIndex) {
        if (frameIndex >= 40 && frameIndex < 80) {
          this.cache.bg.alpha = (80 - frameIndex) / 40;
        }

      },
    },
    /** 卡片掉落反弹动画 */
    dropBounce: {

    }
  };

  /** 特殊状态 */
  const buttons2 = [
    {
      name: '打屁股',
      text() { return `♥  打屁股` },
      onTap() {
        Utils_Favor.addKanaSexCount('ass', 1);
        $gameTemp.execCommonEvent(302, () => {});
      }
    }, {
      name: '摸腿',
      text() { return `♥  摸腿` },
      onTap() {
        $gameTemp.execCommonEvent(303, () => {});
      }
    }, {
      name: '揉胸',
      text() { return `♥  揉胸` },
      onTap() {
        Utils_Favor.addKanaSexCount('chest', 1);
        $gameTemp.execCommonEvent(304, () => {});
      }
    }, {
      name: '裙子状态',
      text() { return `裙子:${({ 'normal': '正常', 'half': '掀起', 'none': '脱下' })[this.tachieSkirtState]}` },
      onTap() {
        if (this.tachieSkirtState === 'normal') this.tachieSkirtState = 'half';
        else if (this.tachieSkirtState === 'half') this.tachieSkirtState = 'none';
        else this.tachieSkirtState = 'normal';
        this.updateTachie();
      }
    }, {
      name: '内裤状态',
      text() { return `内裤:${({ 'normal': '正常', 'half': '半脱', 'none': '脱下' })[this.tachiePantState]}` },
      onTap() {
        if (this.tachiePantState === 'normal') this.tachiePantState = 'half';
        else if (this.tachiePantState === 'half') this.tachiePantState = 'none';
        else this.tachiePantState = 'normal';
        this.updateTachie();
      }
    }, {
      name: '方向',
      text() { return `${this.tachieDirection === 'back' ? '回头看' : '往前看'}` },
      onTap() {
        this.tachieDirection = this.tachieDirection === 'back' ? 'front' : 'back';
        this.updateTachie();
      }
    }, {
      name: '动作',
      visibled() { return this.tachieDirection === 'back' },
      text() { return `动作:${this.tachieIsReached ? 'A' : 'B'}` },
      onTap() {
        this.tachieIsReached = !this.tachieIsReached;
        this.updateTachie();
      }
    }, {
      name: '表情',
      text() { return `表情:${this.tachieFace}` },
      onTap() {
        let _faceIndex = Number(this.tachieFace) + 1;
        if (_faceIndex > 9) {
          _faceIndex = 1;
        }
        this.tachieFace = `0${_faceIndex}`;
        this.updateTachie(false);
      }
    }, {
      name: '湿身',
      text() { return `湿身:${this.tachieIsWet ? '是' : '否'}` },
      onTap() {
        this.tachieIsWet = !this.tachieIsWet;
        this.updateTachie();
      }
    }, {
      name: '受伤',
      text() { return `受伤:${this.tachieIsWound ? '是' : '否'}` },
      onTap() {
        this.tachieIsWound = !this.tachieIsWound;
        this.updateTachie();
      }
    }, {
      name: '破衣',
      text() { return `破衣:${this.tachieIsBroken ? '是' : '否'}` },
      onTap() {
        this.tachieIsBroken = !this.tachieIsBroken;
        this.updateTachie();
      }
    }, {
      name: '裸体',
      text() { return `裸体:${this.tachieIsNude ? '是' : '否'}` },
      onTap() {
        this.tachieIsNude = !this.tachieIsNude;
        this.updateTachie();
      }
    }, 
  ];

  /**
   * 冒险场景
   */
  class Scene_Haku_Adventure extends Scene_MainScene {
    initialize() {

      super.initialize();

      if (!adventure_data) throw new Error("缺少adventure_data地图数据");

      /** 是否繁忙（动画播放中） */
      this._isBusy = false;

      if (!$gameData.tempAdventure) {
        $gameData.tempAdventure = {
          monsterId: undefined,
          useEvents: {},
        };
      }

      /** 卡背图 */
      this.cardBackBitmap = ImageManager.loadPicture('adventure/card/card_back');
      
      /** 当前层级已显示的单元格地图 */
      this.showCellByMap = {};
      /** 当前层级已使用的单元格地图 */
      this.useFloorCellMap = {};
      /** 当前地图已使用的单元格地图 */
      this.useMapCellMap = {};

      /** 气泡对话框配置 */
      this.balloonTalkConfig = {
        visible: false,
        frameIndex: 0,
        frameCount: 180, // 每次固定显示对话两秒
      };

      this.refreshMapData();
    }

    checkSisterState() {
      
    }

    /** 刷新地图数据 */
    refreshMapData() {
      /** 获取当前的MapID */
      this.mapId = $gameData.adventure_map_id;
      this.mapInfo = adventure_data.find(i => i.mapId === this.mapId);
      
      if (!this.mapInfo) throw new Error("缺少adventure_data地图数据");

      /** 迷你地图信息 */
      this.miniMapSprites = [];

      /** 当前处于第几层 */
      // this.levelIndex = 0;
      // this.rowIndex = 0;
      /** 当前层级的地图信息 */
      this.levelInfo = this.mapInfo.levels[this.levelIndex];
      /** 当前处于多少列（默认为中间） */
      if (this.colIndex === undefined) this.colIndex = Math.floor((this.levelInfo.colCount - 1) / 2);
      /** 下一步要走的方向 */
      this.nextMoveDirection = undefined;

      if (this.mapInfo.bgm) {
        AudioManager.playBgm({ name: this.mapInfo.bgm, volume: 100, pitch: 100, pan: 0 });
      }
    }

    /** 当前处于多少层 */
    get levelIndex() {
      return $gameData.tempAdventure.levelIndex || 0;
    }
    set levelIndex(value) {
      $gameData.tempAdventure.levelIndex = value;
    }

    /** 当前处于多少行 */
    get colIndex() {
      return $gameData.tempAdventure.colIndex;
    }
    set colIndex(value) {
      $gameData.tempAdventure.colIndex = value;
    }

    /** 当前处于多少行 */
    get rowIndex() {
      return $gameData.tempAdventure.rowIndex || 0;
    }
    set rowIndex(value) {
      $gameData.tempAdventure.rowIndex = value;
    }
    
    get tachieInfo() {
      if (!this._tachieInfo) this._tachieInfo = {
        direction: 'front',
        isBroken: false,
        isNude: false,
        isReached: true,
        pantState: 'normal',
        skirtState: 'normal',
        state: 'normal',
        sexState: '',
        stateList: [],
      };
      return this._tachieInfo;
    }

    /** 角色状态列表 */
    get tachieStateList() {
      if (!this.tachieInfo.stateList) this.tachieInfo.stateList = [];
      return this.tachieInfo.stateList;
    }
    set tachieStateList(value) {
      this.tachieInfo.stateList = value;
    }

    /**
     * 增加状态
     * @param {'wet'|'wound'} stateName 状态名称
     * @param {number} turn 持续步数，-1表示永久
     */
    addState(stateName, turn = -1) {
      const _index = this.tachieStateList.findIndex(i => i.name === stateName);
      if (_index >= 0) {
        if (this.tachieStateList[_index].turn !== -1) {
          this.tachieStateList[_index].turn = Math.min(this.tachieStateList[_index].turn + 10, 20);
        }
      } else {
        this.tachieStateList.push({ name: stateName, turn: turn });
      }
    }
    /** 删除状态 */
    removeState(stateName) {
      const _index = this.tachieStateList.findIndex(i => i.name === stateName);
      if (_index >= 0) {
        this.tachieStateList.splice(_index, 1);
      }
    }
    /** 状态回合流逝 */
    elapseTurnState(stateName, turn = 1) {
      if (stateName) {
        const _index = this.tachieStateList.findIndex(i => i.name === stateName);
        if (_index >= 0) {
          if (this.tachieStateList[_index].turn !== -turn) {
            this.tachieStateList[_index].turn -= turn;

            if (this.tachieStateList[_index].turn <= 0) {
              this.tachieStateList.splice(_index, 1);
              this.updateTachie();
            }
          }
        }
      } else {
        let _isChange = false;
        for (let i = this.tachieStateList.length - 1; i >= 0; i--) {
          const _state = this.tachieStateList[i];
          if (_state.turn !== -turn) {
            _state.turn -= turn;

            if (_state.turn <= 0) {
              this.tachieStateList.splice(i, 1);
              _isChange = true;
            }
          }
        }

        if (_isChange) {
          this.updateTachie();
        }
      }
    }

    /**
     * 角色表情（01:普通 02:委屈 03:生气 04:吃惊 05:开心 06:微笑 07:哭泣 08:迷惑 09:爱心眼）
     * @type {'01'|'02'|'03'|'04'|'05'|'06'|'07'|'08'|'09'}
     */
    get tachieFace() {
      return this.tachieInfo.face || '01';
    }
    set tachieFace(value) {
      this.tachieInfo.face = value;
    }

    /**
     * 角色附加表情（a1:脸红 a2:更加脸红 a3:黑脸）
     * @type {''|'a1'|'a2'|'a3'}
     */
    get tachieFaceAtta() {
      return this.tachieInfo.faceAtta || '';
    }
    set tachieFaceAtta(value) {
      this.tachieInfo.faceAtta = value;
    }

    /**
     * 角色是否裸体
     * @type {boolean}
     */
    get tachieIsNude() {
      return this.tachieInfo.isNude === undefined ? false : this.tachieInfo.isNude;
    }
    set tachieIsNude(value) {
      this.tachieInfo.isNude = value;
    }

    /**
     * 角色是否破衣
     * @type {boolean}
     */
    get tachieIsBroken() {
      return this.tachieInfo.isBroken === undefined ? false : this.tachieInfo.isBroken;
    }
    set tachieIsBroken(value) {
      this.tachieInfo.isBroken = value;
    }

    /**
     * 角色是否受伤
     * @type {boolean}
     */
    get tachieIsWound() {
      return this.tachieStateList.some(i => i.name === 'wound');
    }
    set tachieIsWound(value) {
      if (value) {
        if (!this.tachieStateList.some(i => i.name === 'wound')) {
          this.tachieStateList.push({ name: 'wound', turn: 10 });
        }
      } else {
        const _index = this.tachieStateList.findIndex(i => i.name === 'wound');
        if (_index >= 0) {
          this.tachieStateList.splice(_index, 1);
        }
      }
    }

    /**
     * 角色是否淋湿
     * @type {boolean}
     */
    get tachieIsWet() {
      return this.tachieStateList.some(i => i.name === 'wet');
    }
    set tachieIsWet(value) {
      if (value) {
        if (!this.tachieStateList.some(i => i.name === 'wet')) {
          this.tachieStateList.push({ name: 'wet', turn: 10 });
        }
      } else {
        const _index = this.tachieStateList.findIndex(i => i.name === 'wet');
        if (_index >= 0) {
          this.tachieStateList.splice(_index, 1);
        }
      }
    }

    /**
     * 角色方向（朝前看、往后看）
     * @type {'front'|'back'}
     */
    get tachieDirection() {
      return this.tachieInfo.direction || 'front';
    }
    set tachieDirection(value) {
      this.tachieInfo.direction = value;
    }

    /**
     * 角色是否伸出手
     * @type {boolean}
     */
    get tachieIsReached() {
      return this.tachieInfo.isReached === undefined ? true : this.tachieInfo.isReached;
    }
    set tachieIsReached(value) {
      this.tachieInfo.isReached = value;
    }

    /**
     * 性骚扰列表（00:无 01:揉胸 02:摸腿 03:揉胸 04:揉屁股 05:亲吻 06:手指插小穴）
     * @type {string}
     */
    get tachieSexState() {
      return this.tachieInfo.sexState;
    }
    set tachieSexState(value) {
      this.tachieInfo.sexState = value;
    }

    /** 裙子状态（normal:普通 half:掀起 none:脱） */
    get tachieSkirtState() {
      return this.tachieInfo.skirtState;
    }
    set tachieSkirtState(value) {
      this.tachieInfo.skirtState = value;
    }

    /** 胖次状态（normal:普通 half:半脱 none:脱） */
    get tachiePantState() {
      return this.tachieInfo.pantState || 'normal';
    }
    set tachiePantState(value) {
      this.tachieInfo.pantState = value;
    }

    create() {
      super.create();
    }

    /** 显示气泡对话 */
    showBalloonTalk(text) {
      this.balloonTalkTextSprite.bitmap.clear();
      this.balloonTalkTextSprite.drawTextEx(text, 10, 10, 340);
      this.balloonTalkConfig.visible = true;

      if (this.balloonTalkContainer.alpha === 0) {
        this.balloonTalkContainer.alpha = 0;
        useTimeout(() => {
        }, 15, (progress) => {
          this.balloonTalkContainer.alpha = progress;
          this.balloonTalkContainer.y = 570 - progress * 30;
        });
      } else {
        this.balloonTalkConfig.frameIndex = 0;
      }
    }

    /** 隐藏气泡对话 */
    hideBalloonTalk() {
      this.balloonTalkConfig.visible = false;
      let _alpha = this.balloonTalkContainer.alpha;
      useTimeout(() => {
        this.balloonTalkTextSprite.bitmap.clear();
      }, 15, (progress) => {
        this.balloonTalkContainer.y = 540 + progress * 30;
        this.balloonTalkContainer.alpha = _alpha - progress * _alpha;
      });
    }

    updateBalloonTalk() {
      if (this.balloonTalkConfig.visible) {
        this.balloonTalkConfig.frameIndex++;
        if (this.balloonTalkConfig.frameIndex >= this.balloonTalkConfig.frameCount) {
          this.balloonTalkConfig.frameIndex = 0;
          this.hideBalloonTalk();
        }
      }
    }

    /** 变更体力 */
    changeLive(live) {
      Utils_Actor.live += live;

      if (Utils_Actor.live <= 0) {
        // 体力耗尽事件
        $gameTemp.execCommonEvent(291);
      }
    }

    /** 时间流逝 */
    timeElapse(duration, config) {
      Utils_Time.timeElapse(duration, config);

      // 时间超出强制结束
      if (Utils_Time.hour >= 21) {
        this._isBusy = true;
        $gameData.isEventBusy = true;
        $gameTemp.execCommonEvent(315, () => {
          this._isBusy = false;
          $gameData.isEventBusy = false;
        });
      }
    }

    /** 最简化的战斗流程 */
    _battleFlow(monsterInfo) {
      $gameData.tempAdventure.monsterTitle = monsterInfo.title;
      
      $gameTemp.execCommonEvent(293, () => {
        this.drawQuestList();
        this._startMove();
      });
      Utils_Cursor.cursorType = 'default';
    }

    /** 显示对象（怪物/物品等） */
    _showObject(info, callback) {
      if (!this.battleContainer) {
        this.battleContainer = new PIXI.Container();
        this.battleContainer.x = 160;
        this.battleContainer.y = 160;
        this.uiContainer.addChild(this.battleContainer);
      }

      this.platformBg = new Sprite(ImageManager.loadPicture(this.mapInfo.platformBackground));
      this.platformBg.y = -300;
      this.battleContainer.addChild(this.platformBg);

      Utils_Tachie.startAction.call(this, 'move', this.platformBg, {
        duration: 20, loop: 1, ry: 300,
      });

      const _img = info.img_l || (typeof _cellInfo.img === 'function' ? _cellInfo.img(this.levelIndex) : _cellInfo.img);

      this.platformObject = new Sprite(ImageManager.loadPicture(_img));
      this.platformObject.alpha = 0;
      this.platformObject.x = 160;
      this.platformObject.y = -130;
      this.battleContainer.addChild(this.platformObject);

      useTimeout(() => {
        callback && callback();
      }, 60, (progress, frameIndex) => {
        if (frameIndex === 20) {
          this.platformObject.alpha = 1;
          Utils_Tachie.startAction.call(this, 'dropBounce', this.platformObject, {
            duration: 40, loop: 1, height: 300, count: 3, power: 0.3,
          });
        }
      });
    }

    /** 隐藏对象（怪物/物品等） */
    _hideObject(info, callback) {
      useTimeout(() => {
        callback && callback();
      }, 40, (progress, frameIndex) => {
        if (frameIndex >= 20) {
          const _progress1 = (frameIndex - 20) / 20;
          this.platformBg.y = _progress1 * 200;
          this.platformBg.alpha = 1 - _progress1;
        }

        if (frameIndex <= 20) {
          const _progress2 = frameIndex / 20;
          this.platformObject.y = -130 - _progress2 * 200;
          this.platformObject.alpha = 1 - _progress2;
        }
      });
    }

    // 步骤三、开始移动
    _startMove() {
      this.colIndex += this.moveType || 0;

      AudioManager.playSe({ name: "walk-grass-short", volume: 60, pitch: 100, pan: 0 });

      this.elapseTurnState();

      this.tachieMoveEffect();
      

      // 立绘小跳跃
      Utils_Tachie.startAction.call(this, 'jump', this.qActorPanel, {
        duration: 18, loop: 1, power: 25, easingType: 'Linear', inout: 'None',
      });

      // 开始移动动画
      animeMap.start.call(this, 'move', { isWait: false }, () => {
        this.rowIndex++;

        if (this.rowIndex >= this.mapInfo.levels[this.levelIndex].map.length) {
          this.rowIndex = 0;
        }

        this._activeCard = '';
        this.isMove = false;
        this._isBusy = false;
        // this.createCards();
      });
      // this.drawMiniMapData();
    };

    /**
     * 移动
     * @param {number} moveType 移动类型，-1:左移动 0:路线不变 1:右移动
     */
    move(moveType) {
      if (this.isMove) return;

      this.moveType = moveType;
      this._isBusy = true;
      this.nextMoveDirection = undefined;

      const _nextRowIndex = this.rowIndex < this.levelInfo.map.length ? this.rowIndex : 0;
      const _nextColIndex = this.colIndex + this.moveType;
      const _nextCardId = this.levelInfo.map[_nextRowIndex][_nextColIndex];
      const _nextCardInfo = this.mapInfo.cells.find(i => i.id === _nextCardId);
      const _isHide = this.getMapCellIsHide(_nextRowIndex, _nextColIndex);
      const _nextCardContainer = this.cardContainer.children[5].children[_nextColIndex];

      if (_nextCardInfo && _nextCardInfo.type === 'block') {
        return;
      }

      if (this.tachieIsWet) {
        this.timeElapse(15, { delay: 1 });
      } else {
        this.timeElapse(10, { delay: 1 });
      }

      if (this.tachieIsWound) {
        this.changeLive(-5);
      } else {
        this.changeLive(-3);
      }

      this.isMove = true;

      // 步骤二、翻转卡片
      const _advance1 = () => {
        if (_isHide) {
          this.showCellByMap[`${this.levelIndex}_${_nextRowIndex}_${_nextColIndex}`] = 1;

          let _cardSprite = this.getCardSprite(this.levelInfo, _nextRowIndex, _nextColIndex, _nextCardId, true);
          _cardSprite.scale.set(1, 1);
          _cardSprite.x = _nextCardContainer.x;
          _cardSprite.y = _nextCardContainer.y;
          _cardSprite.rotation = Math.PI / 2;
          _cardSprite.alpha = 0;

          const _parentIndex = _nextCardContainer.parent.getChildIndex(_nextCardContainer);
          _nextCardContainer.parent.addChildAt(_cardSprite, _parentIndex + 1);
          useTimeout(() => {
            _checkCard();
          }, 20, (progress, frameIndex) => {
            if (frameIndex === 11) {
              _cardSprite.alpha = 1;
              _nextCardContainer.destroy();
            }

            if (frameIndex <= 10) {
              _nextCardContainer.rotation = Math.PI * (1 - progress);
            } else {
              _cardSprite.rotation = Math.PI * (1 - progress);
            }
          });
        } else {
          _checkCard();
        }
      };

      // 校验卡片
      const _checkCard = () => {
        const _isUsed = this.checkIsUseByCell(_nextRowIndex, _nextColIndex, this.levelIndex);

        if (_nextCardInfo.type === 'empty' || _isUsed) {
          this._startMove();
        } else {
          if (_nextCardInfo.type === 'monster') {
            this._showObject(_nextCardInfo, () => {
              this._battleFlow(_nextCardInfo);
            });
          } else if (_nextCardInfo.type === 'item') {
            AudioManager.playSe({ name: "get_item", volume: 90, pitch: 100, pan: 0 });
            $gameParty.gainItem($dataItems[_nextCardInfo.itemId], _nextCardInfo.itemCount || 1);
            this.drawQuestList();
            const _itemName = $dataItems[_nextCardInfo.itemId].name;
            useConfirm({
              hasCancel: false,
              content: TranslateUtils.getText(`获得了道具「$1」`, [TranslateUtils.getText(_itemName)]),
              okHandler: (info) => {
                SoundManager.playOk();
                info.close();
                useTimeout(() => {
                  this._startMove();
                }, 20);
              }
            });
          } else if (_nextCardInfo.type === 'trap') {
            this.executeEvent(_nextCardInfo.event, () => {
              this.drawQuestList();
              useConfirm({
                hasCancel: false,
                content: TranslateUtils.getText(`落入了「$1」中`, [TranslateUtils.getText(_nextCardInfo.title)]),
                okHandler: (info) => {
                  SoundManager.playOk();
                  info.close();
                  useTimeout(() => {
                    this._startMove();
                  }, 20);
                }
              });
            });
          } else if (_nextCardInfo.type === 'move') {
            this.nextMoveDirection = undefined;
            if (_nextCardInfo.moveTo === 'leave-map') {
              this.leaveMap();
            } else {
              const [rowIndex, colIndex, levelIndex, mapId] = _nextCardInfo.moveTo || [];
              this.changeLoc(rowIndex, colIndex, levelIndex, mapId, () => {
                this.executeEvent(_nextCardInfo.event, () => {
                  this.drawQuestList();
                  this._activeCard = '';
                });
              });
            }
          } else if (_nextCardInfo.type === 'event') {
            this.executeEvent(_nextCardInfo.event, () => {
              this.drawQuestList();
              this._startMove();
            });
          } else if (_nextCardInfo.type === 'h') {
            this.executeEvent(_nextCardInfo.event, () => {
              this.drawQuestList();
              this._startMove();
            });
          }
          
          this.useMapCell(_nextRowIndex, _nextColIndex);
        }
      };

      // 步骤一、如果要修改移动路线，则先修改路线后移动
      if (this.moveType !== 0) {
        const _rowList = this.cardContainer.children;

        useTimeout(() => {
          _advance1();
        }, 20, (progress, frameIndex) => {
          if (!this.miniMapCursorSprite.transform) {
            return;
          }

          const _offset = this.moveType * progress;
          this.miniMapCursorSprite.x = 50 + (155 - 54) / 2 + (this.colIndex - (this.levelInfo.colCount - 1) / 2) * 17 + _offset * 17;
          this.miniMapArrowUpSprite.x = 50 + (155 - 20) / 2 + (this.colIndex - (this.levelInfo.colCount - 1) / 2) * 17 + _offset * 17;
          // this.qActorPanel.x += moveType * frameIndex / 30;
          // 重新显示选择框
          this.cursorPanel.alpha = 1 - progress;
          // 
          this.cursorCardSprite.alpha = 1 - progress;

          // 这里加上地图横向移动逻辑
          for (let i = 0; i < _rowList.length; i++) {
            const rowSprite = _rowList[i];
            const _rowIndex = _rowList.length - i - 1;
            
            for (let o = 0; o < rowSprite.children.length; o++) {
              const cardSprite = rowSprite.children[o];

              const colViewIndex = o + (5 - this.levelInfo.colCount) / 2 + ((this.levelInfo.colCount - 1) / 2 - this.colIndex);
              const _x2 = colViewIndex * (155 - _rowIndex * 15) + _rowIndex * 38;
              const _x1 = (colViewIndex + this.moveType) * (155 - _rowIndex * 15) + _rowIndex * 38;
              cardSprite.x = _x2 + (_x2 - _x1) * progress;
            }
          }
        });
      } else {
        _advance1();
      }
    }

    /** 角色往前走的效果 */
    tachieMoveEffect() {
      // 背景上下移动
      Utils_Tachie.startAction.call(this, 'shake', this.tachieBackground, {
        duration: 20, loop: 1, power: 8, frequency: 1, dir: 'vertical',
        easingType: 'Linear', inout: 'None',
      });
      // 角色上下移动
      Utils_Tachie.startAction.call(this, 'shake', this.tachieContainer, {
        duration: 15, loop: 1, power: -6, frequency: 0.6, dir: 'vertical',
        easingType: 'Linear', inout: 'None',
      });
    }

    /**
     * 执行事件
     * @param {string} eventId 事件ID
     * @param {(cb) => void} callback 
     */
    executeEvent(eventId, callback) {
      this._isBusy = true;
      let _isExecuted = false;
      $gameData.isEventBusy = true;
      const _cb = () => {
        this.isMove = false;
        this._isBusy = false;
        $gameData.isEventBusy = false;
        SceneManager._scene.uiPanel.alpha = 1;
        callback && callback();
        // this.redrawUI();
      };
      if (eventId) {
        const _event = this.mapInfo.events.find(i => i.id === eventId);
        if (_event) {
          if (_event.repeatType === 'once') {
            if ($gameData.tempAdventure.useEvents[_event.id]) {
              _cb();
              return;
            }
            $gameData.tempAdventure.useEvents[_event.id] = true;
          }

          if (_event.commonEventId) {
            _isExecuted = true;
            $gameTemp.execCommonEvent(_event.commonEventId, _cb);
          } else if (_event.execute && typeof _event.execute === 'function') {
            _isExecuted = true;
            _event.execute(this, _cb);
          }
        }
      }
      if (!_isExecuted) {
        _cb();
      }
    }

    /** 切换坐标 */
    changeLoc(rowIndex, colIndex, levelIndex, mapId, callback) {
      if (levelIndex !== undefined) {
        if (this.levelIndex !== levelIndex) {
          this.useFloorCellMap = {};
        }
        this.levelIndex = levelIndex;
      }
      if (mapId !== undefined) {
        if ($gameData.adventure_map_id !== mapId) {
          this.useMapCellMap = {};
        }
        $gameData.adventure_map_id = mapId;
      }
      this._activeCard = '';
      this.isMove = false;
      this._isBusy = false;

      this._startMove();
      Utils_Scene.setMaskAlpha(0, 30, false, () => {
        this.rowIndex = rowIndex;
        this.colIndex = colIndex;
        this.refreshMapData();
        this.redrawUI();
        Utils_Scene.setMaskAlpha(255, 30, false);

        callback && callback();
      });
    }

    /** 跳转页时重绘部分UI */
    redrawUI() {
      // 绘制卡片列表
      this.drawCardListData();
      // 绘制任务数据
      this.drawQuestList();
      // 绘制小地图数据
      this.drawMiniMapData();
      // 绘制Q版立绘和光标
      this.createCursorPanel();
      // UI区域
      this.redrawTaskPanel();
      // 重绘标题
      this.redrawTitle();
    }

    updateTime() {
      if (this._prevTimeSpan !== Utils_Time.timeSpan) {
        this._prevTimeSpan = Utils_Time.timeSpan;
        this.drawFilter();
      }
      super.updateTime();
    }

    /** 创建冒险UI */
    createUI() {
      // this.uiContainer = new HakuContainer();
      // this.addChild(this.uiContainer);

      this.sceneInfo = {};

      // 创建背景
      this.createBackground();

      super.refreshData();

      // 内容区域
      if (!this.contentContainer || !this.contentContainer.parent) {
        this.contentContainer = new PIXI.Container();
        this.contentContainer.x = -5;
        this.contentContainer.y = 230;
        this.backUIContainer.addChild(this.contentContainer);
      }

      // 卡片阵列
      if (!this.cardContainer || !this.cardContainer.parent) {
        this.cardContainer = new PIXI.Container();
        this.cardContainer.x = -59;
        this.cardContainer.y = 30;
        this.contentContainer.addChild(this.cardContainer);
      }
      
      // 创建卡片选择高亮框
      if (!this.cursorCardSprite || !this.cursorCardSprite.parent) {
        this.cursorCardSprite = new Sprite(ImageManager.loadPicture('adventure/card_cursor'));
        this.cursorCardSprite.alpha = 0;
        this.cursorCardSprite.blendMode = 3;
        this.cursorCardSprite.x = 51;
        this.cursorCardSprite.y = 30;
        this.contentContainer.addChild(this.cursorCardSprite);
      }
      // 创建立绘区域
      this.createTachieContainer();
      
      // 绘制环境
      this.createFilter();
      this.drawFilter();

      // UI区域
      this.createTaskPanel();
      
      // 创建任务列表
      this.drawQuestList();
      // 创建按钮组
      this.createButtons();

      // 创建卡片阵列（地图）
      this.createCards();
      // 创建光标面板
      this.createCursorPanel();
      // 创建小地图面板
      this.createMiniMap();
      
      this.createTooltip();
      // 3. 绘制左上角信息
      this.createActorInfoUI();
      // 创建妹妹相关的属性
      this.createSisterInfoUI();
      // 4. 绘制右上角菜单按钮
      this.createSysMenuUI();
      // 8. 创建游戏组件
      // this.createGameComponents();
      // 9. 绘制右上角日期时间UI
      this.createDateTimeUI();

      // this.createTachieButtons();

      // 创建标题
      // this.titleSprite = new Sprite(ImageManager.loadPicture('adventure/title_bg'));
      // this.titleSprite.x = 280;
      // this.titleSprite.y = 10;
      // this.addChild(this.titleSprite);

      this.dateContainer.x = 608;
      this.menuContainer.x = 660;
      this.moodContainer.visible = false;
      this.tooltipBgSprite.bitmap = undefined;
      // this.tooltipIconSprite.bitmap = undefined;
      // this.backUIContainer.addChild(this.menuContainer);

      this.enterMap();
    }

    /** 进入地图 */
    enterMap() {
      // 进入时的事件
      if (this.mapInfo.enterEvent) {
        this.executeEvent(this.mapInfo.enterEvent);
      }
    }

    /** 离开地图 */
    leaveMap() {
      // 离开时的事件
      if (this.mapInfo.levelEvent) {

        this._isBusy = true;
        // 这里判断返回的场景
        this.executeEvent(this.mapInfo.levelEvent, () => {
          AudioManager.stopBgs();
          this._isBusy = false;
        });
      }
    }

    /** 创建环境 */
    createFilter() {
      const _container = new PIXI.Container();
      this.gameFilter = _container;
      this.backUIContainer.addChild(_container);
    }

    /** 绘制不同环境（白天/黄昏/夜晚） */
    drawFilter() {
      let _path = '';
      let _blendMode = 0;
      let _alpha = 1;
      switch (Utils_Time.timeSpan) {
        case 'daytime': break;
        case 'dusk':
          _path = 'bg/background_dusk_mask';
          _blendMode = 2;
          break;
        case 'night':
          _path = 'bg/background_night_mask';
          _blendMode = 2;
          _alpha = 0.8;
          break;
          // return `${_base}/bedroom_night${_scene.isOnLight ? "_light" : ""}${_scene.isSleep ? "_sleep" : ""}`;
        default:
          break;
      }
      const _sprite = new Sprite(new Bitmap(Graphics.width, Graphics.height));
      _sprite.alpha = _alpha;
      if (_blendMode) {
        _sprite.blendMode = _blendMode;
      }
      if (_path) {
        ImageManager.loadImgCb(_path, bitmap => {
          _sprite.bitmap.blt(bitmap,
            0, 0, bitmap.width, bitmap.height, 
            0, 0, _sprite.width, _sprite.height
          );
          changeImgs(this.gameFilter, _sprite, 30);
        });
      } else {
        changeImgs(this.gameFilter, _sprite, 30);
      }
    }

    createTaskPanel() {
      if (this.uiPanel) {
        this.uiPanel.destroy();
        this.uiPanel = undefined;
      }

      this.uiPanel = new HakuContainer();
      this.uiPanel.x = Graphics.width - 427 - 860;
      this.uiPanel.y = Graphics.height - 207;
      this.backUIContainer.addChild(this.uiPanel);

      // UI面板
      const _uiBgPanel = new Sprite(ImageManager.loadPicture('adventure/ui_panel'));
      this.uiPanel.addChild(_uiBgPanel);
      // 地图标题
      const _uiPanelTitleSprite = new Sprite(ImageManager.loadPicture('adventure/ui_panel_title'));
      _uiPanelTitleSprite.x = -30;
      _uiPanelTitleSprite.y = 25;
      this.uiPanel.addChild(_uiPanelTitleSprite);
      // 地图标题
      this.uiTitleBitmap = new Bitmap(250, 48);
      this.uiTitleBitmap.fontFace = 'ChillRoundF';
      this.uiTitleBitmap.fontSize = 24;
      this.uiTitleBitmap.textColor = '#FFFFFF';
      this.uiTitleBitmap.outlineColor = '#0';
      this.uiTitleBitmap.outlineWidth = 'rgba(0,0,0,0)';

      const _uiTitleSprite = new Sprite(this.uiTitleBitmap);
      _uiTitleSprite.x = 30;
      _uiTitleSprite.y = 32;
      this.uiPanel.addChild(_uiTitleSprite);

      this.redrawTitle();
    }

    redrawTaskPanel() {

    }

    /** 重绘标题 */
    redrawTitle() {
      this.uiTitleBitmap.clear();
      this.uiTitleBitmap.drawText(`${this.levelInfo.title || this.mapInfo.title}`, 0, 0, 250, 48);
    }
    
    /** 当前场景的NPC角色 */
    get npcActor() {
      return 'kana';
    }
    
    /** 绘制任务列表 */
    drawQuestList() {
      if (!this.questContainer) {
        this.questContainer = new HakuContainer();
        this.questContainer.x = 10;
        this.questContainer.y = 100;
        this.uiPanel.addChild(this.questContainer);
      } else {
        this.questContainer.removeChildren();
      }

      /** 任务列表 */
      this.questList = Utils_Quest.getCurrentQuestList();

      let _y = 0;

      for (let i = 0; i < this.questList.length; i++) {
        const quest = this.questList[i];
        
        const _container = new HakuContainer();
        _container.x = 0;
        _container.y = 0;

        const _progress = quest.info.progress;
        let _state = '';
        let _color = '';
        let _isCompleted = undefined;

        if (_progress === true || _progress === 1) {
          _state = 'completed';
          _color = '#3a4d37';
          _isCompleted = true;
        } else {
          _state = 'progress';
          _color = '#6a5657';
          _isCompleted = false;
        }

        const _questIconSprite = new Sprite(ImageManager.loadPicture(`adventure/icon_check_${_state}`));
        _questIconSprite.x = 5;
        _questIconSprite.y = _y;
        _container.addChild(_questIconSprite);

        const _questDescSprite = new Sprite(new Bitmap(500, 30));
        _questDescSprite.bitmap.fontFace = 'ChillRoundF';
        _questDescSprite.bitmap.fontSize = 18;
        _questDescSprite.bitmap.textColor = '#FFFFFF';
        _questDescSprite.bitmap.outlineColor = _color;
        _questDescSprite.bitmap.outlineWidth = 4;
        _questDescSprite.x = 40;
        _questDescSprite.y = _y;
        _container.addChild(_questDescSprite);

        _questDescSprite.bitmap.drawText(quest.info.content, 0, 0, 500, 30, 'left');
        
        if (_isCompleted) {
          const _textWidth = _questDescSprite.bitmap.measureTextWidth(quest.content);
          _questDescSprite.bitmap.fillRect(0, 14, _textWidth + 5, 2, '#3a4d37');
        }

        _y += 30;

        this.questContainer.addChild(_container);
      }
    }

    /** 创建操作按钮组 */
    createButtons() {
      if (!this.buttonsContainer) {
        this.buttonsContainer = new HakuContainer();
        this.uiPanel.addChild(this.buttonsContainer);
      }
      
      const _menus = buttons.filter(i => i.visible !== false);
      
      this.buttonsContainer.x = 630;
      this.buttonsContainer.y = 200 - _menus.length * 55;

      for (let i = _menus.length - 1; i >= 0; i--) {
        const item = _menus[i];
        
        const _container = new HakuContainer({
          useHover: true, x: 0, y: i * 55, me: this,
          disabled() { return item.disabled === true; },
          onHover() {
            item.maskSprite.alpha = 1;
            if (item.tooltip) {
              this.me.setTooltip(item.tooltip);
            }
          },
          onBlur() {
            item.maskSprite.alpha = 0;
            this.me.setTooltip();
          },
          onTap() {
            if (item.onTap) item.onTap.call(this.me);
          }
        });
        _container.index = i;

        let _itemBg = 'ui/button/button_4';
        if (item.disabled === true) {
          _itemBg = 'ui/button/button_4_disabled';
        }

        _menus[i].container = _container;

        // 绘制背景
        const _sprite = new Sprite(ImageManager.loadPicture(_itemBg));
        _sprite.bitmap.smooth = false;
        _menus[i].bgSprite = _sprite;
        _sprite.x = 0;
        _sprite.y = 0;
        _container.addChild(_sprite);

        // 绘制图标
        const _iconSprite = new Sprite(ImageManager.loadPicture('ui/icon/white/' + item.icon));
        _iconSprite.bitmap.smooth = false;
        _menus[i].iconSprite = _iconSprite;
        _iconSprite.x = 20;
        _iconSprite.y = 6;
        _container.addChild(_iconSprite);

        // 绘制文字
        const _textSprite = new Sprite(new Bitmap(160, 34));
        _textSprite.bitmap.smooth = false;
        _textSprite.bitmap.fontFace = 'Source Han Sans VF';
        _textSprite.bitmap.fontSize = 17;
        if (item.disabled === true) {
          _textSprite.bitmap.textColor = '#888888';
        } else {
          _textSprite.bitmap.textColor = '#C4541C';
        }
        _textSprite.bitmap.outlineWidth = 6;
        _textSprite.bitmap.outlineColor = '#FFFFFF';
        _textSprite.bitmap.drawText(item.text, 5, 5, 200, 30, 'left');
        _textSprite.x = 62;
        _textSprite.y = 4;
        _menus[i].textSprite = _textSprite;
        _container.addChild(_textSprite);

        // 绘制遮罩
        const _maskSprite = new Sprite(ImageManager.loadPicture('ui/button/button_4_mask'));
        _maskSprite.bitmap.smooth = false;
        _menus[i].maskSprite = _maskSprite;
        _maskSprite.alpha = 0;
        _maskSprite.x = 0;
        _maskSprite.y = 0;
        _container.addChild(_maskSprite);

        this.buttonsContainer.addChild(_container);
      }
    }

    /** 创建立绘操作按钮组 */
    createTachieButtons() {
      if (!this.tachieButtonsContainer) {
        this.tachieButtonsContainer = new HakuContainer();
        this.backUIContainer.addChild(this.tachieButtonsContainer);
      }
      
      const _menus = buttons2.filter(i => i.visible !== false);
      
      this.tachieButtonsContainer.x = 650;
      this.tachieButtonsContainer.y = 860 - _menus.length * 55;

      for (let i = _menus.length - 1; i >= 0; i--) {
        const item = _menus[i];
        
        const _container = new HakuContainer({
          useHover: true, x: i % 2 === 0 ? 0 : 100, y: (i % 2 === 0 ? i / 2 : (i - 1) / 2) * 41, me: this, alpha: 0.85,
          disabled() { return item.disabled === true; },
          onHover() {
            this.alpha = 1;
            if (item.tooltip) {
              this.me.setTooltip(item.tooltip);
            }
          },
          onBlur() {
            this.alpha = 0.85;
            this.me.setTooltip();
          },
          onTap() {
            if (item.onTap) item.onTap.call(this.me);
            item.textSprite.bitmap.clear();
            item.textSprite.bitmap.drawText(typeof item.text === 'function' ? item.text.call(this.me) : item.text, 0, 5, 150, 16, 'left');
          }
        });
        _container.index = i;

        let _itemBg = 'ui/button/button_4_s';

        _menus[i].container = _container;

        // 绘制背景
        const _sprite = new Sprite(ImageManager.loadPicture(_itemBg));
        _sprite.bitmap.smooth = false;
        _menus[i].bgSprite = _sprite;
        _sprite.x = 0;
        _sprite.y = 0;
        _container.addChild(_sprite);

        // 绘制文字
        const _textSprite = new Sprite(new Bitmap(90, 34));
        _textSprite.bitmap.smooth = false;
        _textSprite.bitmap.fontFace = 'Source Han Sans VF';
        _textSprite.bitmap.fontSize = 14;
        if (item.disabled === true) {
          _textSprite.bitmap.textColor = '#888888';
        } else {
          _textSprite.bitmap.textColor = '#C4541C';
        }
        _textSprite.bitmap.outlineWidth = 6;
        _textSprite.bitmap.outlineColor = '#FFFFFF';
        _textSprite.bitmap.drawText(typeof item.text === 'function'? item.text.call(this) : item.text, 5, 5, 150, 16, 'left');
        _textSprite.x = 10;
        _textSprite.y = 4;
        _menus[i].textSprite = _textSprite;
        _container.addChild(_textSprite);

        this.tachieButtonsContainer.addChild(_container);
      }
    }
    
    /** 显示普通宽度提示 */
    showNormalTooltip() {
      if (!this.tooltipBgSprite || this.isFullTooltip === false) return;
      this.tooltipBgSprite.bitmap = undefined;
      // this.tooltipIconSprite.bitmap = undefined;
      // this.tooltipBgSprite._refresh();
      this.isFullTooltip = false;
    }
    /** 显示全宽度提示 */
    showFullTooltip() {
      if (!this.tooltipBgSprite || this.isFullTooltip === true) return;
      this.tooltipBgSprite.bitmap = ImageManager.loadPicture('adventure/tooltip_bg_full');
      this.isFullTooltip = true;
    }

    /** 创建立绘区域 */
    createTachieContainer() {
      // 立绘背景
      this.tachieBackground = new Sprite(ImageManager.loadPicture(this.mapInfo.tachieBackground));
      this.backUIContainer.addChild(this.tachieBackground);
      this.tachieBackground.x = Graphics.width - 427;
      this.tachieBackground.y = -20;

      // 立绘部分
      this.tachieContainer = new PIXI.Container();
      this.tachieContainer.x = Graphics.width - 427;
      this.backUIContainer.addChild(this.tachieContainer);

      this.createBalloonTalkContainer();

      this.updateTachie();
    }

    /** 创建立绘气泡对话框部分 */
    createBalloonTalkContainer() {
      if (!this.balloonTalkContainer) {
        this.balloonTalkContainer = new PIXI.Container();
        this.balloonTalkContainer.alpha = 0;
        this.balloonTalkContainer.x = Graphics.width - 410;
        this.balloonTalkContainer.y = 540;
        this.backUIContainer.addChild(this.balloonTalkContainer);
      } else {
        this.balloonTalkContainer.removeChildren();
      }

      this.balloonTalkContainer.addChild(new Sprite(ImageManager.loadPicture('adventure/message_bg')));
      // 文字部分
      this.balloonTalkTextSprite = new Sprite(new Bitmap(360, 110));
      this.balloonTalkTextSprite.x = 12;
      this.balloonTalkTextSprite.y = 32;
      this.balloonTalkTextSprite.bitmap.fontSize = 23;
      this.balloonTalkTextSprite.bitmap.fontFace = 'ChillRoundF';
      this.balloonTalkTextSprite.bitmap.textColor = '#514247';
      this.balloonTalkTextSprite.bitmap.outlineColor = 'rgba(0,0,0,0)';
      this.balloonTalkTextSprite.bitmap.outlineWidth = 0;
      this.balloonTalkContainer.addChild(this.balloonTalkTextSprite);
    }

    /** 创建背景 */
    createBackground() {
      // 大背景
      this.background = new Sprite(ImageManager.loadPicture(this.mapInfo.background));
      this.backUIContainer.addChild(this.background);

      // 下方半透黑遮罩
      // this.maskBottomPanel = new Sprite(ImageManager.loadPicture('adventure/mask_panel_bottom'));
      // this.backUIContainer.addChild(this.maskBottomPanel);
    }

    /** 创建立绘 */
    createTachie() {

    }

    /**
     * 更新立绘
     */
    updateTachie(isDuration = true) {
      const _imgs = [];

      const _basePath = 'adventure/tachie';
      let _direction = '';

      // 立绘方向
      if (this.tachieDirection === 'front') {
        _imgs.push(`${_basePath}/body_front`);
        _direction = 'front';
      } else if (this.tachieIsReached) {
        _imgs.push(`${_basePath}/body_back_reached`);
        _direction = 'back_reached';
      } else {
        _imgs.push(`${_basePath}/body_back`);
        _direction = 'back';
      }

      // 是否打了屁股
      if (this.tachieSexState === '01') {
        _imgs.push(`${_basePath}/sex/01/base`);
      }
      
      // 是否有伤口
      if (this.tachieIsWound) {
        if (this.tachieDirection === 'front') {
          _imgs.push(`${_basePath}/wound/front`);
        } else {
          _imgs.push(`${_basePath}/wound/back`);
        }
      }

      // 是否裸体
      if (!this.tachieIsNude) {

        // 胖次
        if (this.tachiePantState === 'normal') {
          if (this.tachieIsBroken && this.tachieIsWet) {
            _imgs.push(`${_basePath}/pants/04`);
          } else if (this.tachieIsWet) {
            _imgs.push(`${_basePath}/pants/03`);
          } else if (this.tachieIsBroken) {
            _imgs.push(`${_basePath}/pants/02`);
          } else {
            _imgs.push(`${_basePath}/pants/01`);
          }

          // 额外的胖次阴影
          if (this.tachieSkirtState === 'half') {
            _imgs.push(`${_basePath}/pants/05`);
          }
        } else if (this.tachiePantState === 'half') {
          
          if (this.tachieIsBroken && this.tachieIsWet) {
            _imgs.push(`${_basePath}/pants/s_04`);
          } else if (this.tachieIsWet) {
            _imgs.push(`${_basePath}/pants/s_03`);
          } else if (this.tachieIsBroken) {
            _imgs.push(`${_basePath}/pants/s_02`);
          } else {
            _imgs.push(`${_basePath}/pants/s_01`);
          }
        }

        // 裙子
        if (this.tachieSkirtState === 'normal') {
          if (this.tachieIsBroken && this.tachieIsWet) {
            _imgs.push(`${_basePath}/skirt/04`);
          } else if (this.tachieIsWet) {
            if (this.tachieIsNude || this.tachiePantState !== 'normal') {
              _imgs.push(`${_basePath}/skirt/03`);
            } else {
              _imgs.push(`${_basePath}/skirt/03_1`);
            }
          } else if (this.tachieIsBroken) {
            _imgs.push(`${_basePath}/skirt/02`);
          } else {
            if (this.tachieIsNude || this.tachiePantState !== 'normal') {
              _imgs.push(`${_basePath}/skirt/01`);
            } else {
              _imgs.push(`${_basePath}/skirt/01_1`);
            }
          }
        }

        // 上衣
        if (this.tachieIsBroken && this.tachieIsWet) {
          _imgs.push(`${_basePath}/clothes/${this.tachieSkirtState === 'half' ? 's_' : ''}${_direction}_04`);
        } else if (this.tachieIsWet) {
          _imgs.push(`${_basePath}/clothes/${this.tachieSkirtState === 'half' ? 's_' : ''}${_direction}_03`);
        } else if (this.tachieIsBroken) {
          _imgs.push(`${_basePath}/clothes/${this.tachieSkirtState === 'half' ? 's_' : ''}${_direction}_02`);
        } else {
          _imgs.push(`${_basePath}/clothes/${this.tachieSkirtState === 'half' ? 's_' : ''}${_direction}_01`);
        }

        // 裙子（特殊情况下盖在上面）
        if (this.tachieSkirtState === 'half') {
          if (this.tachieIsBroken && this.tachieIsWet) {
            _imgs.push(`${_basePath}/skirt/s_04`);
          } else if (this.tachieIsWet) {
            _imgs.push(`${_basePath}/skirt/s_03`);
          } else if (this.tachieIsBroken) {
            _imgs.push(`${_basePath}/skirt/s_02`);
          } else {
            _imgs.push(`${_basePath}/skirt/s_01`);
          }
        }
      }

      // H状态
      // if (this.tachieSexContainer && (!this.tachieSexContainer || !this.tachieSexContainer.parent)) {
      if (!this.tachieSexContainer || !this.tachieSexContainer.parent) {
        this.tachieSexContainer = new PIXI.Container();
      }
      _imgs.push(this.tachieSexContainer);
      // }

      // 头发
      if (this.tachieDirection === 'front') {
        _imgs.push(`adventure/tachie/hair/hair_front`);
      } else {
        _imgs.push(`adventure/tachie/hair/hair_back`);
      }

      // 水雾/水滴
      if (this.tachieIsWet) {
        if (this.tachieDirection === 'front') {
          _imgs.push(`adventure/tachie/wet/front`);
        } else {
          _imgs.push(`adventure/tachie/wet/back`);
        }
      }

      if (this.tachieDirection === 'back') {
        // 表情
        _imgs.push(`adventure/tachie/face/${this.tachieFace}`);
        // 附加表情
        if (this.tachieFaceAtta) _imgs.push(`adventure/tachie/face/${this.tachieFaceAtta}`);
      }



      this.drawImages(this.tachieContainer, _imgs, { isClear: true, duration: 0 }); // isDuration ? 10 : 0
    }

    /** 显示性骚扰 */
    showSexAction(sexState) {
      if (!this.tachieSexState && !sexState) return;

      this.tachieSexContainer.removeChildren();
      if (sexState) {
        this.tachieSexState = sexState;
      }
      let _sprite;
      switch (this.tachieSexState) {
        case '01': // 打屁股
          _sprite = new Sprite(ImageManager.loadPicture('adventure/tachie/sex/01/01'));
          this.tachieSexContainer.addChild(_sprite);
          useTimeout(() => {
            Utils_Actor.live += 10;
            _sprite.destroy();
          }, 20, (progress, frameIndex) => {
            if (frameIndex === 5) _sprite.bitmap = ImageManager.loadPicture('adventure/tachie/sex/01/02');
            else if (frameIndex === 10) _sprite.bitmap = ImageManager.loadPicture('adventure/tachie/sex/01/03');
            else if (frameIndex === 15) _sprite.bitmap = ImageManager.loadPicture('adventure/tachie/sex/01/04');
            else if (frameIndex === 20) _sprite.bitmap = undefined;
          });
          break;
        case '02': // 摸腿
          _sprite = new Sprite(ImageManager.loadPicture('adventure/tachie/sex/02/01'));
          this.tachieSexContainer.addChild(_sprite);
          useTimeout(() => {
            Utils_Actor.live += 10;
            _sprite.destroy();
          }, 180, (progress, frameIndex) => {
            if (frameIndex === 30) _sprite.bitmap = ImageManager.loadPicture('adventure/tachie/sex/02/02');
            else if (frameIndex === 60)  _sprite.bitmap = ImageManager.loadPicture('adventure/tachie/sex/02/01');
            else if (frameIndex === 90)  _sprite.bitmap = ImageManager.loadPicture('adventure/tachie/sex/02/02');
            else if (frameIndex === 120) _sprite.bitmap = ImageManager.loadPicture('adventure/tachie/sex/02/01');
            else if (frameIndex === 150) _sprite.bitmap = ImageManager.loadPicture('adventure/tachie/sex/02/02');
            else if (frameIndex === 180) _sprite.bitmap = undefined;
          });
          break;
        case '03': // 揉胸
          _sprite = new Sprite(ImageManager.loadPicture('adventure/tachie/sex/03/01'));
          this.tachieSexContainer.addChild(_sprite);
          useTimeout(() => {
            Utils_Actor.live += 15;
            _sprite.destroy();
          }, 180, (progress, frameIndex) => {
            if (frameIndex === 30) _sprite.bitmap = ImageManager.loadPicture('adventure/tachie/sex/03/02');
            else if (frameIndex === 60) _sprite.bitmap = ImageManager.loadPicture('adventure/tachie/sex/03/01');
            else if (frameIndex === 90) _sprite.bitmap = ImageManager.loadPicture('adventure/tachie/sex/03/02');
            else if (frameIndex === 120) _sprite.bitmap = ImageManager.loadPicture('adventure/tachie/sex/03/01');
            else if (frameIndex === 150) _sprite.bitmap = ImageManager.loadPicture('adventure/tachie/sex/03/02');
            else if (frameIndex === 180) _sprite.bitmap = undefined;
          });
          break;
        case '04': // 揉屁股
          _sprite = new Sprite(ImageManager.loadPicture('adventure/tachie/sex/04/01'));
          this.tachieSexContainer.addChild(_sprite);
          useTimeout(() => {
            _sprite.destroy();
          }, 180, (progress, frameIndex) => {
            if (frameIndex === 30) _sprite.bitmap = ImageManager.loadPicture('adventure/tachie/sex/04/02');
            else if (frameIndex === 60) _sprite.bitmap = ImageManager.loadPicture('adventure/tachie/sex/04/01');
            else if (frameIndex === 90) _sprite.bitmap = ImageManager.loadPicture('adventure/tachie/sex/04/02');
            else if (frameIndex === 120) _sprite.bitmap = ImageManager.loadPicture('adventure/tachie/sex/04/01');
            else if (frameIndex === 150) _sprite.bitmap = ImageManager.loadPicture('adventure/tachie/sex/04/02');
            else if (frameIndex === 180) _sprite.bitmap = undefined;
          });
          break;
        case '05': // 亲吻
          
          break;
        case '06': // 手指插小穴
          
          break;
        default:
          break;
      }
    }

    /** 创建卡片 */
    createCards() {

      // 创建卡片（此时卡片未显示）
      this.drawCardListData();
    }

    /** 绘制卡片阵列数据 */
    drawCardListData() {
      if (this.cardContainer) {
        this.cardContainer.removeChildren();
      }

      /** 数据行号 */
      let _rowIndex = this.rowIndex;
      /** 仅用来统计的行号 */
      let _rowCountIndex = 0;
      for (;_rowCountIndex < 6;) {
        const _rowCells = this.levelInfo.map[_rowIndex];

        const _y = -_rowCountIndex * 35 + _rowCountIndex * _rowCountIndex * 3;
        const _tempRowCountIndex = _rowCountIndex;

        // 行
        let _rowContainer = new PIXI.Container();
        _rowContainer.x = 110 + 69.5;
        _rowContainer.y = _y - 300;
        _rowContainer.scale.y = 0.3;

        for (let col = 0; col < _rowCells.length; col++) {
          const cell = _rowCells[col];
          
          const colViewIndex = col + (5 - this.levelInfo.colCount) / 2 + ((this.levelInfo.colCount - 1) / 2 - this.colIndex);
          
          let _cardSprite = this.getCardSprite(this.levelInfo, _rowIndex, col, cell, false, _rowCountIndex);
          _cardSprite.scale.set(1 - _rowCountIndex * 0.1, 1 - _rowCountIndex * 0.1);
          _cardSprite.x = colViewIndex * (155 - _rowCountIndex * 15) + _rowCountIndex * 38;
          
          if (_rowCountIndex === 6) {
            _cardSprite.alpha = 0.0;
          }
          
          _rowContainer.addChild(_cardSprite);
        }
        
        this.cardContainer.addChildAt(_rowContainer, 0);
        _rowIndex++;
        _rowCountIndex++;
        
        if (_rowIndex >= this.levelInfo.map.length) {
          _rowIndex = 0;
        }

        useTimeout(() => {}, _tempRowCountIndex * 4 + 15, (progress, frameIndex) => {
          if (!_rowContainer || !_rowContainer.transform) return;

          if (frameIndex >= _tempRowCountIndex * 4) {
            const _progress = (frameIndex - _tempRowCountIndex * 4) / 15;
            let _reProgress = Math.max(0, Math.min(1, _progress));
            _reProgress = 1 - (1 - _reProgress) * (1 - _reProgress);
            // _rowContainer.alpha = _reProgress;
            _rowContainer.y = _y - 300 * (1 - _reProgress);
          }
        });
      }
    }
    
    updateCardListData(frameIndex) {
      const _frameCount = 20;
      const _progress = frameIndex / _frameCount;
      const _frameIndex = frameIndex || 1;

      if (_frameIndex === 1) {
        /** 仅用来统计的行号 */
        const _rowCountIndex = 6;
        /** 数据行号 */
        let _rowIndex = this.rowIndex + _rowCountIndex < this.levelInfo.map.length ? this.rowIndex + _rowCountIndex : this.rowIndex + _rowCountIndex - this.levelInfo.map.length;

        let _rowContainer = new PIXI.Container();
        _rowContainer.x = 110 + 69.5;
        _rowContainer.y = -_rowCountIndex * 35 + _rowCountIndex * _rowCountIndex * 3;
        _rowContainer.alpha = 0;
        _rowContainer.scale.y = 0.3;

        const _rowCells = this.levelInfo.map[_rowIndex];
        
        for (let col = 0; col < _rowCells.length; col++) {
          const cell = _rowCells[col];
          
          const colViewIndex = col + (5 - this.levelInfo.colCount) / 2 + ((this.levelInfo.colCount - 1) / 2 - this.colIndex);
          
          let _cardSprite = this.getCardSprite(this.levelInfo, _rowIndex, col, cell, false, 6);
          _cardSprite.scale.set(1 - _rowCountIndex * 0.1, 1 - _rowCountIndex * 0.1);
          _cardSprite.x = colViewIndex * (155 - _rowCountIndex * 15) + _rowCountIndex * 38;
          
          _rowContainer.addChild(_cardSprite);
        }
        
        this.cardContainer.addChildAt(_rowContainer, 0);
      }

      const _rowList = this.cardContainer.children;

      // 最后面一行渐显
      const _firstRow = _rowList[0];
      _firstRow.alpha = _progress;

      // 最前面一行渐隐
      const _lastRow = _rowList[_rowList.length - 1];
      _lastRow.alpha = 1 - _progress;

      for (let i = 0; i < _rowList.length; i++) {
        const rowSprite = _rowList[i];
        const _prevRowIndex = _rowList.length - i - 2;
        const _rowIndex = _rowList.length - i - 1;
        const _nextRowIndex = _rowList.length - i;

        
        for (let o = 0; o < rowSprite.children.length; o++) {
          const cardSprite = rowSprite.children[o];

          const colViewIndex = o + (5 - this.levelInfo.colCount) / 2 + ((this.levelInfo.colCount - 1) / 2 - this.colIndex);
          const _x2 = colViewIndex * (155 - _rowIndex * 15) + _rowIndex * 38;
          const _x1 = colViewIndex * (155 - _nextRowIndex * 15) + _nextRowIndex * 38;
          cardSprite.x = _x2 + (_x2 - _x1) * _progress;

          cardSprite.scale.set(
            1 - _rowIndex * 0.1 + 0.1 * _progress, 
            1 - _rowIndex * 0.1 + 0.1 * _progress, 
          );

          
          const _maskAlpha1 = 0.15 * _nextRowIndex;
          const _maskAlpha2 = 0.15 * _rowIndex;

          cardSprite.maskSprite.alpha = Math.sin((_maskAlpha2 + (_maskAlpha2 - _maskAlpha1) * _progress) * Math.PI / 2);
        }

        const _y2 = -_prevRowIndex * 35 + _prevRowIndex * _prevRowIndex * 3;
        const _y1 = -_rowIndex * 35 + _rowIndex * _rowIndex * 3;

        rowSprite.y = _y1 + (_y2 - _y1) * _progress;
      }

      if (_frameIndex === _frameCount) {
        this.cardContainer.children[this.cardContainer.children.length - 1].destroy();
      }
    }

    getCardTitle(cardInfo) {
      if (cardInfo.title) {
        if (typeof cardInfo.title === 'function') {
          return cardInfo.title(this.levelIndex);
        } else {
          return cardInfo.title;
        }
      } else {
        return '';
      }
    }

    /** 创建一个卡片 */
    getCardSprite(levelInfo, rowIndex, colIndex, cell, forceShow = false, showRowIndex = 0) {
      let _cardSprite = new PIXI.Container();
      let _cellInfo = undefined;
      const _isHide = this.getMapCellIsHide(rowIndex, colIndex);
      const _isUsed = this.checkIsUseByCell(rowIndex, colIndex, this.levelIndex);
      if (!forceShow && _isHide) {
        _cardSprite.addChild(new Sprite(this.cardBackBitmap));
      } else {
        _cellInfo = this.mapInfo.cells.find(i => i.id === cell);
        const _img = typeof _cellInfo.img === 'function' ? _cellInfo.img(this.levelIndex) : _cellInfo.img;

        if (_cellInfo.type === 'block') {
          const _content = new Sprite(ImageManager.loadPicture(_img));
          if (_content.bitmap.isReady()) {
            _content.y = 225 - _content.bitmap.height;
          } else {
            _content.bitmap.addLoadListener((bitmap) => {
              _content.y = 225 - bitmap.height;
            });
          }
          _cardSprite.addChild(_content);
        } else {
          let _cardFgPath = 'adventure/card/';
          if (_isUsed) {
            _cardFgPath += 'card_empty';
            _cardSprite.addChild(new Sprite(ImageManager.loadPicture(this.mapInfo.cardBackground)));
            _cardSprite.addChild(new Sprite(ImageManager.loadPicture(_cardFgPath)));
          } else {
            switch (_cellInfo.type) {
              case 'monster': _cardFgPath += 'card_monster'; break;
              case 'item': _cardFgPath += 'card_item'; break;
              case 'lock': _cardFgPath += 'card_lock'; break;
              case 'move': _cardFgPath += 'card_move'; break;
              case 'trap': _cardFgPath += 'card_trap'; break;
              case 'event': _cardFgPath += 'card_event'; break;
              case 'h': _cardFgPath += 'card_h'; break;
              default: _cardFgPath += 'card_empty'; break;
            }
            _cardSprite.addChild(new Sprite(ImageManager.loadPicture(this.mapInfo.cardBackground)));
            if (_img) _cardSprite.addChild(new Sprite(ImageManager.loadPicture(_img)));
            _cardSprite.addChild(new Sprite(ImageManager.loadPicture(_cardFgPath)));
          }
        }

        // 卡片标题
        const _cardTitle = this.getCardTitle(_cellInfo);
        if (_cardTitle && !_isUsed) {
          const _cardTitleContainer = new PIXI.Container();
          _cardTitleContainer.x = 10;
          _cardTitleContainer.y = 82;
          _cardTitleContainer.addChild(new Sprite(ImageManager.loadPicture('adventure/card_title')));
          const _cardTitleText = new Bitmap(120, 36);
          _cardTitleText.fontSize = 16;
          _cardTitleText.textColor = 'white';
          _cardTitleText.outlineColor = 'black';
          _cardTitleText.outlineWidth = 3;
          _cardTitleText.drawText(_cardTitle, 0, 0, 120, 36, 'center');
          _cardTitleContainer.addChild(new Sprite(_cardTitleText));
          _cardSprite.addChild(_cardTitleContainer);
        }
      }
      // 创建遮罩
      let _maskUrl = _cellInfo && _cellInfo.maskImg ? _cellInfo.maskImg : 'adventure/card_mask';
      let _maskSprite = new Sprite(ImageManager.loadPicture(_maskUrl));
      if (_cellInfo && _cellInfo.type === 'block') {
        if (_maskSprite.bitmap.isReady()) {
          _maskSprite.y = 225 - _maskSprite.bitmap.height;
        } else {
          _maskSprite.bitmap.addLoadListener((bitmap) => {
            _maskSprite.y = 225 - bitmap.height;
          });
        }
      }
      _cardSprite.maskSprite = _maskSprite;
      _cardSprite.maskSprite.blendMode = 2;
      _cardSprite.maskSprite.alpha = Math.sin((0.15 * showRowIndex) * Math.PI / 2);
      _cardSprite.addChild(_cardSprite.maskSprite);

      _cardSprite.convertTo3d();
      _cardSprite.pivot3d.set(69.5, 0, 0);
      _cardSprite.proj.affine = PIXI.projection.AFFINE.AXIS_X;
      // _cardSprite.rotation = 1
      
      // const _tempText = new Sprite(new Bitmap(139, 225));
      // _tempText.bitmap.fontSize = 50;
      // _tempText.bitmap.textColor = 'red';
      // _tempText.bitmap.drawText(rowIndex, 0, 0, 139, 225, 'center');
      // _cardSprite.addChild(_tempText);

      return _cardSprite;
    }

    /** 创建选择光标和Q版角色 */
    createCursorPanel() {
      // 上方半透黑遮罩
      if (this.maskPanel) {
        this.maskPanel.destroy();
      }
      this.maskPanel = new Sprite(ImageManager.loadPicture('adventure/mask_panel_top'));
      this.backUIContainer.addChild(this.maskPanel);

      // 卡牌选择光标面板
      if (this.cursorPanel) {
        this.cursorPanel.destroy();
      }
      this.cursorPanel = new Sprite(ImageManager.loadPicture('adventure/cursor_panel'));
      this.cursorPanel.x = 193;
      this.cursorPanel.y = 11;
      this.contentContainer.addChild(this.cursorPanel);

      // 下方Q版角色
      if (this.qActorPanel) {
        this.qActorPanel.destroy();
      }
      this.qActorPanel = new Sprite(ImageManager.loadPicture('adventure/kana_mini'));
      this.qActorPanel.x = 361; // 51 / 206 / 361
      this.qActorPanel.y = 170;
      this.contentContainer.addChild(this.qActorPanel);
    }

    /** 创建小地图面板 */
    createMiniMap() {
      // 小地图
      this.miniMapContainer = new PIXI.Container();
      this.miniMapContainer.x = -40;
      this.miniMapContainer.y = 80;
      this.backUIContainer.addChild(this.miniMapContainer);

      // 小地图背景
      const _bg = new Sprite(ImageManager.loadPicture('adventure/mobile_background'));
      _bg.x = 51;
      _bg.y = 28;
      this.miniMapContainer.addChild(_bg);

      this.miniMapContentSprite = new Sprite(new Bitmap(155, 172));
      this.miniMapContentSprite.x = 50;
      this.miniMapContentSprite.y = 48;
      this.miniMapContentBitmap = this.miniMapContentSprite.bitmap;
      this.miniMapContentBitmap.fillRect(0, 0, 155, 172, 'rgba(60, 60, 60, 0.5)');
      this.miniMapContainer.addChild(this.miniMapContentSprite);

      // 小地图光标
      this.miniMapCursorSprite = new Sprite(ImageManager.loadPicture('adventure/minimap_cursor'));
      this.miniMapCursorSprite.x = 50 + (155 - 54) / 2 + (this.colIndex - (this.levelInfo.colCount - 1) / 2) * 17;
      this.miniMapCursorSprite.y = 201;
      this.miniMapContainer.addChild(this.miniMapCursorSprite);
      
      // 小地图箭头
      this.miniMapArrowUpSprite = new Sprite(ImageManager.loadPicture('adventure/arrow_up2'));
      this.miniMapArrowUpSprite.x = 50 + (155 - 20) / 2 + (this.colIndex - (this.levelInfo.colCount - 1) / 2) * 17;
      this.miniMapArrowUpSprite.y = 220;
      this.miniMapContainer.addChild(this.miniMapArrowUpSprite);

      // 绘制小地图数据
      this.drawMiniMapData();

      // 小地图前景
      // const _fg = new Sprite(ImageManager.loadPicture('adventure/mobile_foreground'));
      // this.miniMapContainer.addChild(_fg);
    }

    /** 获取当前地图的卡片信息 */
    getMapCellInfo(rowIndex, colIndex) {
      return this.mapInfo.cells.find(i => i.id === this.levelInfo.map[rowIndex][colIndex]);
    }
    /** 获取当前地图卡片是否隐藏 */
    getMapCellIsHide(rowIndex, colIndex, levelIndex) {
      if (!levelIndex) levelIndex = this.levelIndex;
      return !this.showCellByMap[`${levelIndex}_${rowIndex}_${colIndex}`] && this.levelInfo.hideMap[rowIndex][colIndex];
    }
    /** 确认当前地图卡片是否可使用 */
    checkIsUseByCell(rowIndex, colIndex, levelIndex) {
      let _levelIndex = levelIndex === undefined ? this.levelIndex : levelIndex;
      if (
        $gameData.adventureInfo.useCells[`${this.mapId}_${_levelIndex}_${rowIndex}_${colIndex}`] ||
        this.useMapCellMap[`${_levelIndex}_${rowIndex}_${colIndex}`] ||
        this.useFloorCellMap[`${_levelIndex}_${rowIndex}_${colIndex}`]
      ) {
        return true;
      }
      return false;
    }
    /** 使用卡片 */
    useMapCell(rowIndex, colIndex, levelIndex) {
      const cellInfo = this.getMapCellInfo(rowIndex, colIndex);
      if (!cellInfo) return;

      const _levelIndex = levelIndex || this.levelIndex;

      if (cellInfo.repeatType === 'once') {
        $gameData.adventureInfo.useCells[`${this.mapId}_${_levelIndex}_${rowIndex}_${colIndex}`] = 1;
      } else if (cellInfo.repeatType === 'map') {
        this.useMapCellMap[`${_levelIndex}_${rowIndex}_${colIndex}`] = 1;
      } else if (cellInfo.repeatType === 'floor') {
        this.useFloorCellMap[`${_levelIndex}_${rowIndex}_${colIndex}`] = 1;
      }
    }

    /** 绘制小地图数据 */
    drawMiniMapData({ progress, frameIndex, frameCount } = {}) {
      this.miniMapContentBitmap.clear();
      
      // this.miniMapContentBitmap.fillRect(30, 0, 155 - 62, 172, 'rgba(100, 100, 100, 0.4)');

      const _progress = progress || 0;
      const _offset = _progress * 17;

      /** 数据行号 */
      let _rowIndex = this.rowIndex;
      /** 仅用来统计的行号 */
      let _rowCountIndex = 0;
      /** 小地图精灵列表 */
      // this.miniMapSpriteList = [];

      const _baseX = (155 - this.levelInfo.colCount * 17) / 2;
      
      this.miniMapContentBitmap.fontSize = 12;

      for (; _rowCountIndex < 11;) {
        if (_rowIndex >= this.levelInfo.map.length) {
          _rowIndex = 0;
        }

        const _rowCells = this.levelInfo.map[_rowIndex];

        for (let col = 0; col < _rowCells.length; col++) {
          const cell = _rowCells[col];

          const cellInfo = this.getMapCellInfo(_rowIndex, col);

          if (cellInfo.type === 'block') {
            continue;
          }

          const isHide = this.getMapCellIsHide(_rowIndex, col);
          const isUsed = this.checkIsUseByCell(_rowIndex, col, this.levelIndex);

          let _color = '#FFFFFF';

          if (isHide) {
            _color = '#BBBBBB';
          } else if (isUsed) {
            _color = '#FFFFFF';
          } else {
            _color = ({
              'empty': '#FFFFFF',
              'block': 'rgba(0,0,0,0)',
              'monster': '#df193e',
              'event': '#1989df',
              'trap': '#761ced',
              'h': '#b91ced',
              'item': '#e3e611',
              'move': '#1bfb6d',
            })[cellInfo.type];
          }

          this.miniMapContentBitmap.fillRect(
            _baseX + col * 17, _offset + 172 - (_rowCountIndex + 1) * 17, 
            16, 16, _color
          );
          // this.miniMapContentBitmap.drawText(`${_rowIndex}`, 
          //   _baseX + col * 17, _offset + 172 - (_rowCountIndex + 1) * 17, 
          //   16, 16, 'center'
          // );
        }
        
        _rowIndex++;
        _rowCountIndex++;
        
        if (_rowIndex >= this.levelInfo.map.length) {
          this.miniMapContentBitmap.fillRect(
            _baseX - 4, _offset + 172 - _rowCountIndex * 17 - 1, 
            this.levelInfo.colCount * 17 - 1 + 8, 2, '#FF1139'
          );
        }
      }
    }

    update() {
      super.update();

      if (SceneManager._scene.visibleDialog) return;

      this.updateBalloonTalk();

      if (!this.isMove && this.nextMoveDirection !== undefined) {
        this.move(this.nextMoveDirection);
        this.nextMoveDirection = undefined;
        return;
      }

      if ($gameData.isEventBusy) return;
      if (this._isBusy) return;
      if (this.isMove) return;

      const _nextRowIndex = this.rowIndex < this.levelInfo.map.length ? this.rowIndex : 0;

      if (Input.isPressed('left') && this.colIndex > 0) {
        const cellInfo = this.mapInfo.cells.find(i => i.id === this.levelInfo.map[_nextRowIndex][this.colIndex - 1]);
        if (cellInfo.type === 'block') {
          SoundManager.playBuzzer();
          return;
        } else {
          if (!this.isMove) {
            this.move(-1);
          } else {
            this.nextMoveDirection = 1;
          }
        }
      } else if (Input.isPressed('right') && this.colIndex < this.levelInfo.colCount - 1) {
        const cellInfo = this.mapInfo.cells.find(i => i.id === this.levelInfo.map[_nextRowIndex][this.colIndex + 1]);
        if (cellInfo.type === 'block') {
          SoundManager.playBuzzer();
          return;
        } else {
          if (!this.isMove) {
            this.move(1);
          } else {
            this.nextMoveDirection = 1;
          }
        }
      } else if (Input.isPressed('up')) {
        const cellInfo = this.mapInfo.cells.find(i => i.id === this.levelInfo.map[_nextRowIndex][this.colIndex]);
        if (cellInfo.type === 'block') {
          SoundManager.playBuzzer();
          return;
        } else {
          if (!this.isMove) {
            this.move(0);
          } else {
            this.nextMoveDirection = 0;
          }
        }
      }

      const _x = TouchInput.x;
      const _y = TouchInput.y;
      let _activeCard = undefined;

      const _offsetX = 155;

      if (_y >= 260 && _y <= 225 + 260) {

        for (let i = -1; i < this.levelInfo.colCount && i <= 1; i++) {
          
          if (_x >= 51 + (i + 1) * 155 + _offsetX && _x <= 51 + (i + 1) * 155 + 155 + _offsetX && i + this.colIndex >= 0 && i + this.colIndex <= this.levelInfo.colCount - 1) {
            
            const cellInfo = this.getMapCellInfo(_nextRowIndex, i + this.colIndex);
            
            if (cellInfo.type !== 'block') {
              _activeCard = 'c' + i;
              if (this._activeCard !== 'c' + i) {
                SoundManager.playCursor();
                this.cursorCardSprite.alpha = 1;
                this.cursorCardSprite.x = 51 + (i + 1) * 155 + _offsetX;
              } else {
                
              }
            }
            if (TouchInput.isTriggered() || TouchInput.isLongPressed()) {
              if (cellInfo.type === 'block') {
                SoundManager.playBuzzer();
                return;
              } else {
                if (!this.isMove) {
                  this.move(i);
                } else {
                  this.nextMoveDirection = (i - this.moveType);
                }
              }
            }
            break;
          }
        }
      }
      
      if (this._activeCard) {
        if (_activeCard) {
          Utils_Cursor.cursorType = 'pointer';
        } else {
          Utils_Cursor.cursorType = 'default';
        }
      }

      if (this._activeCard !== _activeCard) {
        this._activeCard = _activeCard;
      }

      if (!this._activeCard) {
        this.cursorCardSprite.alpha = 0;
      }
    }
  }
  window.Scene_Haku_Adventure = Scene_Haku_Adventure;

  
  const adventureModule = {
    checkScene() {
      const _scene = SceneManager._scene;
      if (!(_scene instanceof Scene_Haku_Adventure)) {
        throw new Error('Scene is not Adventure');
      }
      return _scene;
    },
    /**
     * 修改表情 - 冒险模式
     * @param {number} face 表情编号
     * @param {number} attach 额外表情编号
     */
    changeFaceByAdventure(face, attach) {
      const _scene = adventureModule.checkScene();
      // 如果没转头回来就强制先转头
      if (_scene.tachieDirection === 'front') {
        _scene.tachieDirection === 'back';
      }
      _scene.tachieFace = face;
      _scene.tachieFaceAtta = attach;
      _scene.updateTachie();
    },
    /** 切换方向 */
    changeTachieDirection(direction) {
      const _scene = adventureModule.checkScene();
      _scene.tachieDirection = direction;
      _scene.updateTachie();
    },
    /** 切换角色动作-是否伸手 */
    changeTachieIsReached(isReached) {
      const _scene = adventureModule.checkScene();
      _scene.tachieIsReached = isReached;
      _scene.updateTachie();
    },
    /** 角色移动 */
    tachieMove(interpreter, isWait = true) {
      const _scene = adventureModule.checkScene();
      _scene.tachieMoveEffect();
        
      if (interpreter && isWait === true) {
        interpreter.wait(20);
      }
    },
    /** 开始动作 */
    startAction(actionName, config = {}, callback, interpreter) {
      const _scene = adventureModule.checkScene();
      
      Utils_Tachie.startAction(actionName, _scene.tachieContainer, config, callback, interpreter);
    }
  };

  class Utils_Adventure {
    /**
     * 修改表情-冒险场景
     * @param {number} face 
     * @param {number} attach 
     */
    static changeFaceByAdventure(face, attach) {
      adventureModule.changeFaceByAdventure(face, attach);
    }
    /**
     * 修改角色方向
     * @param {'front'|'back'} direction 方向
     */
    static changeTachieDirection(direction) {
      adventureModule.changeTachieDirection(direction);
    }
    /** 
     * 切换角色动作-是否伸手
     * @param {boolean} isReached 是否伸手
     */
    static changeTachieIsReached(isReached) {
      adventureModule.changeTachieIsReached(isReached);
    }
    /** 角色移动 */
    static tachieMove(interpreter, isWait) {
      const _scene = adventureModule.checkScene();
      _scene.tachieMoveEffect();

      if (interpreter && isWait === true) {
        interpreter.wait(200);
      }
    }
  }
  window.Utils_Adventure = Utils_Adventure;

  
  if (Utils.RPGMAKER_NAME === "MZ") {
    // 冒险模式 - 切换表情
    PluginManager.registerCommand(PluginName, 'changeFaceByAdventure', function(args) {
      Utils_Adventure.changeFaceByAdventure.call(this, args.face.split(',')[0], args.attach.split(',')[0]);
    });
    // 冒险模式 - 切换角色方向
    PluginManager.registerCommand(PluginName, 'changeTachieDirection', function(args) {
      Utils_Adventure.changeTachieDirection.call(this, args.direction === 'true' ? 'front' : 'back');
    });
    // 冒险模式 - 切换角色动作-是否伸手
    PluginManager.registerCommand(PluginName, 'changeTachieIsReached', function(args) {
      Utils_Adventure.changeTachieIsReached.call(this, args.isReached === 'true');
    });
    // 冒险模式 - 角色往前走的效果
    PluginManager.registerCommand(PluginName, 'tachieMove', function(args) {
      adventureModule.tachieMove(this, args.isWait === 'true');
    });
    
    // 立绘动作 - 震动
    PluginManager.registerCommand(PluginName, 'action_shake', function(args) {
      adventureModule.startAction.call(this, 'shake', {
        duration: Number(args.duration),
        loop: Number(args.loop),
        power: Number(args.power),
        frequency: Number(args.frequency),
        dir: args.dir,
        easingType: args.easingType,
        inout: args.inout,
        isWait: args.isWait === 'true'
      }, undefined, this);
    });
    // 立绘动作 - 立绘八方震动
    PluginManager.registerCommand(PluginName, 'action_rumble', function(args) {
      adventureModule.startAction.call(this, 'rumble', {
        duration: Number(args.duration),
        loop: Number(args.loop),
        power: Number(args.power),
        frequency: Number(args.frequency),
        easingType: args.easingType,
        inout: args.inout,
        isWait: args.isWait === 'true'
      }, undefined, this);
    });
    
  }
})();