//=============================================================================
// ** RPG Maker MZ - Hakubox_Component_Course.js
//=============================================================================

// #region 脚本注释
/*:
 * @plugindesc 定制功能 - 定制教程插件 (v1.0.0)
 * @version 1.0.0
 * @author hakubox
 * @email hakubox@outlook.com
 * @target MZ
 * 
 * @help
 * 【与傲娇妹妹的治愈日常】定制教程插件。
 * 
 */
// #endregion
(() => {

  const courseData = {
    home: [
      { x: 55, y: 92, width: 620, img: 'home/01', desc: '状态栏', text: '这里显示着重要的角色数值：【体力】、【理智】、【好感度】、【淫乱度】和【心情】各种行动都会消耗体力，但可以通过休息或锻炼来管理。时刻关注这些变化，是成功“攻略”她的关键。' },
      { x: 335, y: 50, width: 740, img: 'home/02', desc: '时间日期', text: '距离故事结局只剩三十天了。在这段时间里，和妹妹创造些美好的回忆吧，说不定会有意想不到的展开哦？' },
      { x: 356, y: 130, width: 660, img: 'home/03', desc: '系统菜单', text: '想要更了解妹妹吗？在这里可以查看她的详细状态，或是进行游戏设置，让你们的相处更顺利。' },
      // { x: 495, y: 304, width: 620, img: 'home/04', desc: '加奈', text: '你最可爱的妹妹——加奈。多和她互动来增进感情吧。随着关系越来越亲密，也许就能解锁更多…特别的日常哦～' },
      { x: 423, y: 550, width: 640, img: 'home/05', desc: '功能菜单', text: '每天的行动都在这里选择。无论是休息、锻炼还是使用道具，合理的规划是加深和加奈关系的关键。' },
    ],
    interact: [
      { x: 600, y: 60, width: 400, img: 'interact/01', desc: '时间日期', text: '要注意，如果时间太晚或是体⼒耗尽，就⽆法继续互动了哦。' },
      { x: 650, y: 270, width: 420, img: 'interact/02', desc: '换衣', text: '随着好感度和淫乱度的增加，可以让加奈露出胸部甚⾄脱光所有⾐服。' },
      { x: 720, y: 438, width: 358, img: 'interact/03', desc: '动作', text: '在这可以切换你的互动部位，不同的部位进⾏的互动各有不同。' },
      { x: 560, y: 550, width: 480, img: 'interact/04', desc: '离开', text: '如果感到疲惫或是玩够了，那就结束交互，继续与妹妹的治愈⽇常吧～' },
      { x: 600, y: 310, width: 560, img: 'interact/05', desc: '交互1', text: '加奈可互动区域为头、胸、腿等等，随着好感度的增加，可互动区域和⽅式也会增加，加奈对你的反应也会有所不同哦～' },
      { x: 630, y: 338, width: 360, img: 'interact/06', desc: '交互2', text: '和可爱的妹妹⼀起亲密互动吧~' },
    ],
    yobai: [
      { x: 52, y: 106, width: 620, img: 'yobai/01', desc: '睡眠条', text: '这是妹妹的睡眠度，如果动作幅度过⼤可能会惊醒加奈，或许可以⽤⼀些道具来加深睡眠？' },
      { x: 576, y: 108, width: 650, img: 'yobai/02', desc: '快感条', text: '这⾥是妹妹的快感度，如果积累满了加奈便会在睡梦中⾼潮哦～' },
      { x: 527, y: 415, width: 550, img: 'yobai/03', desc: '动作', text: '在这⾥可以选择各种玩弄⽅式，⽤你的身体去感受妹妹的温暖吧～' },
      { x: 540, y: 600, width: 530, img: 'yobai/04', desc: '操作', text: '可以选择开关灯或者结束这次的夜袭。' },
      { x: 440, y: 520, width: 380, img: 'yobai/05', desc: '开始', text: '现在，让我们慢慢拉下被⼦，开始夜晚的游戏吧！' },
    ],
    adventure: [
      { x: 305, y: 570, width: 220, img: 'adventure/01', desc: '任务面板', text: '这⾥是当前的任务' },
      { x: 135, y: 550, width: 460, img: 'adventure/02', desc: '操作列表', text: '进⾏休息恢复体⼒，使⽤⽬前拥有的道具，以及结束冒险' },
      { x: 810, y: 350, width: 360, img: 'adventure/03', desc: '卡牌列表', text: '通过点击卡牌决定加奈前进的道路逐渐深⼊森林寻找⽬标吧～' },
    ],
  };

  const courseModule = {
    /** 当前状态 */
    state: {
      /** 是否开始 */
      isStart: false,
      /** 页面索引 */
      pageIndex: 0,
      /** 教程场景 */
      courseScene: '',
      /** 教程场景容器 */
      container: undefined,
      /** 背景精灵 */
      bgSprite: undefined,
      /** 教程文字背景 */
      textBgSprite: undefined,
      /** 教程文字 */
      textSprite: undefined,
      /** 上一页按钮 */
      prevBtnSprite: undefined,
      /** 下一页按钮 */
      nextBtnSprite: undefined,
    },
    /** 最大页面数量 */
    get maxPage() {
      if (!courseModule.state.courseScene) return 0;
      return courseData[courseModule.state.courseScene].length - 1;
    },
    /** 教程文字 */
    get text() {
      if (!courseData[courseModule.state.courseScene] || !courseData[courseModule.state.courseScene][courseModule.state.pageIndex]) return '';
      return courseData[courseModule.state.courseScene][courseModule.state.pageIndex].text;
    },
    /** 上一页 */
    prevPage() {
      if (courseModule.state.pageIndex > 0) {
        courseModule.state.pageIndex--;
      }
      courseModule.refreshPage();
    },
    /** 下一页 */
    nextPage() {
      SoundManager.playOk();
      if (courseModule.state.pageIndex >= courseModule.maxPage) {
        courseModule.hideCourse();
      } else {
        courseModule.state.pageIndex++;
        courseModule.refreshPage();
      }
    },
    /** 刷新页面 */
    refreshPage() {
      if (!courseModule.state.isStart) return;

      const _info = courseData[courseModule.state.courseScene];
      const _infoItem = _info[courseModule.state.pageIndex];

      if (!_infoItem) throw new Error('教程场景不存在');

      courseModule.state.bgSprite.bitmap = ImageManager.loadPicture(`course/${_info[courseModule.state.pageIndex].img}`);

      if (courseModule.state.textBgSprite.bitmap) courseModule.state.textBgSprite.bitmap.clear();
      if (courseModule.state.textSprite.bitmap) courseModule.state.textSprite.bitmap.clear();

      const _textState = courseModule.state.textSprite.drawTextEx(_infoItem.text, _infoItem.x + 20, _infoItem.y + 20, _infoItem.width - 40);
      
      
      courseModule.bltBg(courseModule.state.textBgSprite.bitmap, _infoItem.x, _infoItem.y, _infoItem.width + 10, _textState.outputHeight + 40);
    
      courseModule.state.prevBtnSprite.x = _infoItem.x + _infoItem.width - 250 + 3;
      courseModule.state.prevBtnSprite.y = _infoItem.y + _textState.outputHeight + 45;
      courseModule.state.nextBtnSprite.x = _infoItem.x + _infoItem.width - 120 + 3;
      courseModule.state.nextBtnSprite.y = _infoItem.y + _textState.outputHeight + 45;

      // 绘制当前页数
      ImageManager.loadImgCb('course/sprite_label_bg', bitmap => {
        courseModule.state.textBgSprite.bitmap.blt(bitmap, 
          0, 0, 92, 53,
          _infoItem.x, _infoItem.y + _textState.outputHeight + 45, 92, 53
        );

        courseModule.state.textBgSprite.bitmap.drawText(
          `${courseModule.state.pageIndex + 1} / ${courseModule.maxPage + 1}`, 
          _infoItem.x, _infoItem.y + _textState.outputHeight + 45, 
          92, 53, 'center'
        );
      });
      
      courseModule.state.prevBtnSprite.refreshSprite();
      courseModule.state.nextBtnSprite.refreshSprite();
    },
    /** 绘制方块图 */
    bltBg(img, x = 0, y = 0, width, height, cb) {
      const bw = 15;
      ImageManager.loadImgCb('course/sprite_bg', bitmap => {
        // 填充背景图片
        for (let _x = bw; _x < width - bw; _x += bw) {
          for (let _y = bw; _y < height - bw; _y += bw) {
            img.blt(bitmap, bw, bw, bw, bw, x + _x, y + _y, bw, bw);
          }
        }

        // 四个角的图片
        img.blt(bitmap, 0, 0, bw, bw, x - 0, y - 0, bw, bw);
        img.blt(bitmap, bw * 2, 0, bw, bw, x + width - bw, y - 0, bw, bw);
        img.blt(bitmap, 0, bw * 2, bw, bw, x - 0, y + height - bw, bw, bw);
        img.blt(bitmap, bw * 2, bw * 2, bw, bw, x + width - bw, y + height - bw, bw, bw);
        
        // 四条边的图片
        let _x2 = 0;
        for (; _x2 <= width - bw * 3; _x2 += bw) {
          img.blt(bitmap, bw, 0, bw, bw, x + _x2 + bw, y + 0, bw, bw);
          img.blt(bitmap, bw, bw * 2, bw, bw, x + _x2 + bw, y + height - bw, bw, bw);
        }
        const _surplusWidth = (width - bw) % bw;
        img.blt(bitmap, bw, 0, _surplusWidth, bw, x + _x2 + bw, y + 0, _surplusWidth, bw);
        img.blt(bitmap, bw, bw * 2, _surplusWidth, bw, x + _x2 + bw, y + height - bw, _surplusWidth, bw);

        let _y2 = 0;
        for (; _y2 <= height - bw * 3; _y2 += bw) {
          img.blt(bitmap, 0, bw, bw, bw, x + 0, y + _y2 + bw, bw, bw);
          img.blt(bitmap, bw * 2, bw, bw, bw, x + width - bw, y + _y2 + bw, bw, bw);
        }
        const _surplusHeight = (height - bw) % bw;
        img.blt(bitmap, 0, bw, bw, _surplusHeight, x + 0, y + _y2 + bw, bw, _surplusHeight);
        img.blt(bitmap, bw * 2, bw, bw, _surplusHeight, x + width - bw, y + _y2 + bw, bw, _surplusHeight);

        cb && cb();
      });
    },
    /**
     * 开始显示教程
     * @param {string} scene 教程场景
     * @param {PIXI.Container} container 容器
     * @param {boolean} [isForce=false] 是否强制开启
     */
    showCourse(scene, container, isForce = false) {
      if (!container) container = SceneManager._scene;

      // 判断是否开启过
      if (!isForce && DataManager.isClearCourse(scene)) return;

      DataManager.clearCourse(scene);

      courseModule.hideCourse();

      // SceneManager._scene.visibleDialog = true;
      SceneManager._scene._isBusy = true;
      $gameData.isEventBusy = true;

      courseModule.state.courseScene = scene;
      courseModule.state.isStart = true;

      const _info = courseData[scene];
      if (!_info) throw new Error('教程场景不存在');
      
      const _container = new HakuContainer({
        useHover: false, x: 0, y: 0, width: Graphics.width, height: Graphics.height, me: this, isSys: true,
        update() {
          if (Input.isTriggered('right') || Input.isTriggered('bottom')) {
            courseModule.nextPage();
          } else if (Input.isTriggered('left') || Input.isTriggered('top')) {
            courseModule.prevPage();
          }
        },
      });

      courseModule.state.container = _container;
      courseModule.state.bgSprite = new Sprite();
      _container.addChild(courseModule.state.bgSprite);
      courseModule.state.textBgSprite = new Sprite(new Bitmap(Graphics.width, Graphics.height));
      courseModule.state.textBgSprite.bitmap.fontFace = 'ChillRoundF';
      courseModule.state.textBgSprite.bitmap.fontSize = 20;
      courseModule.state.textBgSprite.bitmap.textColor = '#FFFFFF';
      courseModule.state.textBgSprite.bitmap.outlineWidth = 4;
      courseModule.state.textBgSprite.bitmap.outlineColor = '#82390c';
      _container.addChild(courseModule.state.textBgSprite);
      courseModule.state.textSprite = new Sprite();
      _container.addChild(courseModule.state.textSprite);
      courseModule.state.textSprite.bitmap = new Bitmap(Graphics.width, Graphics.height);
      courseModule.state.textSprite.bitmap.fontFace = 'ChillRoundF';
      courseModule.state.textSprite.bitmap.fontSize = 20;
      courseModule.state.textSprite.bitmap.textColor = '#FFFFFF';
      courseModule.state.textSprite.bitmap.outlineWidth = 4;
      courseModule.state.textSprite.bitmap.outlineColor = '#82390c';
      courseModule.state.textSprite.x = 0;
      courseModule.state.textSprite.y = 0;

      courseModule.state.prevBtnSprite = new HakuContainer({
        useHover: true, x: 200, y: 200, width: 128, height: 53, me: this, isSys: true,
        disabled() { return courseModule.state.pageIndex === 0; },
        onHover() {
          this.refreshSprite(true);
        },
        onBlur() {
          this.refreshSprite(false);
        },
        onTap() {
          courseModule.prevPage();
          this.refreshSprite();
        }
      });
      courseModule.state.prevBtnSprite.refreshSprite = function(isHover, isStart) {
        if (this.disabled) {
          this.bgSprite.bitmap = ImageManager.loadPicture('course/sprite_btn_bg_disabled');
          this.textSprite.bitmap.outlineColor = '#999999';
        } else {
          if (isHover === true) {
            this.bgSprite.bitmap = ImageManager.loadPicture('course/sprite_btn_bg_hover');
          } else if (isHover === false) {
            this.bgSprite.bitmap = ImageManager.loadPicture('course/sprite_btn_bg');
          }
          this.textSprite.bitmap.outlineColor = '#82390c';
        }
        this.textSprite.bitmap.clear();
        this.textSprite.bitmap.drawText('上一页', 0, 0, 128, 53, 'center');
        if (isStart !== false) courseModule.state.nextBtnSprite.refreshSprite(false, false);
      };
      const _prevBtnBgSprite = new Sprite(ImageManager.loadPicture('course/sprite_btn_bg_disabled'));
      courseModule.state.prevBtnSprite.addChild(_prevBtnBgSprite);
      courseModule.state.prevBtnSprite.bgSprite = _prevBtnBgSprite;
      const _prevBtnTextSprite = new Sprite(new Bitmap(128, 53));
      courseModule.state.prevBtnSprite.addChild(_prevBtnTextSprite);
      courseModule.state.prevBtnSprite.textSprite = _prevBtnTextSprite;
      _prevBtnTextSprite.bitmap.fontFace = 'ChillRoundF';
      _prevBtnTextSprite.bitmap.fontSize = 20;
      _prevBtnTextSprite.bitmap.textColor = '#FFFFFF';
      _prevBtnTextSprite.bitmap.outlineWidth = 4;
      _prevBtnTextSprite.bitmap.outlineColor = '#999999';
      _prevBtnTextSprite.bitmap.drawText('上一页', 0, 0, 128, 53, 'center');
      _container.addChild(courseModule.state.prevBtnSprite);


      courseModule.state.nextBtnSprite = new HakuContainer({
        useHover: true, x: 350, y: 200, width: 128, height: 53, me: this, isSys: true,
        onHover() {
          this.refreshSprite(true);
        },
        onBlur() {
          this.refreshSprite(false);
        },
        onTap() {
          courseModule.nextPage();
        }
      });
      courseModule.state.nextBtnSprite.refreshSprite = function(isHover, isStart) {
        if (this.disabled) {
          this.bgSprite.bitmap = ImageManager.loadPicture('course/sprite_btn_bg_disabled');
          this.textSprite.bitmap.outlineColor = '#999999';
        } else {
          if (isHover === true) {
            this.bgSprite.bitmap = ImageManager.loadPicture('course/sprite_btn_bg_hover');
          } else if (isHover === false) {
            this.bgSprite.bitmap = ImageManager.loadPicture('course/sprite_btn_bg');
          }
          this.textSprite.bitmap.outlineColor = '#82390c';
        }
        this.textSprite.bitmap.clear();
        if (courseModule.state.pageIndex === courseModule.maxPage) {
          this.textSprite.bitmap.drawText('关闭', 0, 0, 128, 53, 'center');
        } else {
          this.textSprite.bitmap.drawText('下一页', 0, 0, 128, 53, 'center');
        }
        if (isStart !== false) courseModule.state.prevBtnSprite.refreshSprite(false, false);
      };
      const _nextBtnBgSprite = new Sprite(ImageManager.loadPicture('course/sprite_btn_bg'));
      courseModule.state.nextBtnSprite.addChild(_nextBtnBgSprite);
      courseModule.state.nextBtnSprite.bgSprite = _nextBtnBgSprite;
      const _nextBtnTextSprite = new Sprite(new Bitmap(128, 53));
      courseModule.state.nextBtnSprite.addChild(_nextBtnTextSprite);
      courseModule.state.nextBtnSprite.textSprite = _nextBtnTextSprite;
      _nextBtnTextSprite.bitmap.fontFace = 'ChillRoundF';
      _nextBtnTextSprite.bitmap.fontSize = 20;
      _nextBtnTextSprite.bitmap.textColor = '#FFFFFF';
      _nextBtnTextSprite.bitmap.outlineWidth = 4;
      _nextBtnTextSprite.bitmap.outlineColor = '#82390c';
      _nextBtnTextSprite.bitmap.drawText('下一页', 0, 0, 128, 53, 'center');
      _container.addChild(courseModule.state.nextBtnSprite);

      container.addChild(_container);

      courseModule.refreshPage();
    },
    /**
     * 隐藏教程
     */
    hideCourse() {
      courseModule.state.isStart = false;
      courseModule.state.courseScene = '';
      courseModule.state.pageIndex = 0;
      if (courseModule.state.textBgSprite) courseModule.state.textBgSprite = undefined;
      if (courseModule.state.bgSprite) courseModule.state.bgSprite = undefined;
      if (courseModule.state.textSprite) courseModule.state.textSprite = undefined;
      
      if (courseModule.state.prevBtnSprite) {
        courseModule.state.prevBtnSprite.scene.hoverElement = undefined;
        courseModule.state.prevBtnSprite.destroy();
        courseModule.state.prevBtnSprite = undefined;
      }
      if (courseModule.state.nextBtnSprite) {
        courseModule.state.nextBtnSprite.scene.hoverElement = undefined;
        courseModule.state.nextBtnSprite.destroy();
        courseModule.state.nextBtnSprite = undefined;
      }

      if (courseModule.state.container) {
        courseModule.state.container.removeChildren();
        courseModule.state.container.destroy();
        courseModule.state.container = undefined;
      }

      // SceneManager._scene.visibleDialog = false;
      SceneManager._scene._isBusy = false;
      $gameData.isEventBusy = false;
    }
  };


  class Utils_Course {
    /**
     * 开始显示教程
     * @param {string} scene 教程场景
     * @param {PIXI.Container} container 容器
     * @param {boolean} [isForce=false] 是否强制开启
     */
    static showCourse(scene, container, isForce = false) {
      courseModule.showCourse(scene, container, isForce);
    }
    /**
     * 隐藏教程
     */
    static hideCourse() {
      courseModule.hideCourse();
    }
  }
  window.Utils_Course = Utils_Course;

})();