//=============================================================================
// ** RPG Maker MZ - Hakubox_Component_Extras.js
//=============================================================================

// #region 脚本注释
/*:
 * @plugindesc 定制功能 - 定制回想插件 (v1.0.0)
 * @version 1.0.0
 * @author hakubox
 * @email hakubox@outlook.com
 * @target MZ
 * 
 * @help
 * 【与傲娇妹妹的治愈日常】定制回想插件。
 * 
 */
// #endregion
(() => {

  /** 插件名称 */
  const PluginName = document.currentScript ? decodeURIComponent(document.currentScript.src.match(/^.*\/(.+)\.js$/)[1]) : "Hakubox_Component_Log";

  const typeDefine = {
  };
  // #endregion

  // #region 插件参数

  const params = PluginParamsParser.parse(PluginManager.parameters(PluginName), typeDefine);
  
  // #endregion

  /** 额外功能模块 */
  const extrasModule = {
    fullData: {
      /** CG列表 */
      cgList: [
        {
          id: '1', name: '卫生间偷窥', previewImg: 'cg/thumbnail/01', tooltip: '如果给加奈喝点什么的话…',
          baseUrl: 'cg/01/',
          imgs: [
            '01_a_01', '01_a_02_a', '01_a_03', '01_a_03_a', '01_a_04', '01_a_04_a', '01_a_05',
            '01_a_05_a', '01_a_05_b', '01_b_01', '01_b_02', '01_b_02_a', '01_b_03', '01_b_03_a', '01_b_04', 
            '01_b_04_a', '01_b_05', '01_b_05_a', '01_b_05_b'
          ],
          condition() {
            return DataManager.isClearScene('1');
          }
        }, {
          id: '3', name: '晚餐的“甜点”', previewImg: 'cg/thumbnail/03', tooltip: '如果加奈好感度达到2级且性欲大于15的话…',
          baseUrl: 'cg/03/',
          imgs: [
            '04_a_01', '04_a_02', '04_a_03', '04_a_04', '04_a_05', '04_a_06', '04_a_07', '04_a_07_1', '04_a_08',
            '04_a_08_1', '04_a_09', '04_a_10', '04_a_11'
          ],
          condition() {
            return DataManager.isClearScene('3');
          }
        }, {
          id: '4-1', name: '浴室中的亲昵 - 1', previewImg: 'cg/thumbnail/04', tooltip: '如果加奈好感度达到2级且性欲大于30的话…',
          baseUrl: 'cg/04/',
          imgs: [
            '04_a_01','04_a_02','04_a_03','04_a_04','04_a_05','04_a_06','04_a_07','04_b_01','04_b_02',
            '04_b_03','04_b_04','04_b_04_2','04_b_04_3','04_b_05','04_b_06','04_b_07','04_b_08','04_b_09',
            '04_b_10','04_b_11','04_b_11_2','04_b_12','04_b_13','04_b_14','04_b_15','04_b_16','04_b_17',
            '04_b_17_1','04_b_17_2','04_b_17_3','04_b_18','04_b_19','04_b_20','04_b_21',
          ],
          condition() {
            return DataManager.isClearScene('4-1');
          }
        },
        // {
        //   id: '4-2', name: '浴室中的亲昵 - 2', previewImg: 'cg/thumbnail/04', tooltip: '如果加奈好感度达到3级且性欲大于50的话…',
        //   baseUrl: 'cg/04_2/',
        //   imgs: [
        //     '042_01','042_02','042_03','042_03_01','042_03_02','042_03_03','042_04','042_04_01','042_05',
        //     '042_05_01','042_05_02','042_06','042_07','042_08','042_09','042_a_01','042_a_02','042_a_03',
        //     '042_a_04','042_a_05'
        //   ],
        //   condition() {
        //     return DataManager.isClearScene('4-2');
        //   }
        // },
        {
          id: '5-1', name: '千夏的报恩～♡', previewImg: 'cg/thumbnail/05', tooltip: '如果千夏好感度达到2级的话…',
          baseUrl: 'cg/05/',
          imgs: [
            '05_a_01','05_a_02','05_a_03','05_a_04','05_a_05','05_a_06','05_a_07','05_a_07_1','05_a_07_2',
            '05_a_08','05_a_10','05_a_10_1','05_a_10_2','05_a_11','05_a_12','05_a_12_1','05_a_13','05_a_14',
            '05_a_15','05_a_16'
          ],
          condition() {
            return DataManager.isClearScene('5-1');
          }
        }, {
          id: '6-1', name: '对熟睡之人的恶作剧', previewImg: 'cg/thumbnail/06', tooltip: '如果由纪好感度达到2级的话…',
          baseUrl: 'cg/06/',
          imgs: [
            '06_b_01','06_b_02','06_b_03','06_b_04','06_b_05','06_b_05_01','06_b_06','06_b_06_1','06_b_06_2',
            '06_b_06_3','06_b_07','06_b_08','06_b_09','06_b_10','06_b_11','06_b_11_1','06_b_11_2','06_b_11_3',
            '06_b_12','06_b_12_1','06_b_13','06_b_13_1','06_b_14','06_b_15','06_b_16','06_b_17','06_b_18',
            '06_b_18_1','06_b_18_2','06_b_19','06_b_20','06_b_21'
          ],
          condition() {
            return DataManager.isClearScene('6-1');
          }
        }, {
          id: '7-1', name: '名为艾露的陷阱', eventId: 172, previewImg: 'cg/thumbnail/07', tooltip: '如果艾露好感度达到2级的话…',
          baseUrl: 'cg/07/',
          imgs: [
            '07_01','07_02','07_03','07_04','07_05','07_05_01','07_06','07_07','07_08','07_09'
          ],
          condition() {
            return DataManager.isClearScene('7-1');
          }
        }, {
          id: 'x1', name: '角色立绘', previewImg: 'cg/tachie/thumbnail', tooltip: '如果加奈好感度达到2级且性欲大于15的话…',
          baseUrl: 'cg/tachie/',
          imgs: [
            'kana_tachie_1','kana_tachie_2','kana_tachie_3','kana_tachie_4',
            'chinatsu_tachie_l1','chinatsu_tachie_l2','chinatsu_tachie_l3','chinatsu_tachie_l4','chinatsu_tachie_s1',
            'chinatsu_tachie_s2','chinatsu_tachie_s3','chinatsu_tachie_s4',
            'ere_tachie_1','ere_tachie_2','ere_tachie_3','ere_tachie_4',
            'yuki_tachie_1','yuki_tachie_2',
            'mini_11','mini_12','mini_13','mini_21',
            'mini_22','mini_23','mini_31','mini_32','mini_33','mini_41','mini_42','mini_43',
          ],
          condition() { return true; }
        }
      ],
      /** 场景回想列表 */
      sceneList: [
        {
          id: '1', name: '卫生间偷窥', eventId: 153, previewImg: 'cg/thumbnail/01', tooltip: '如果给加奈喝点什么的话…',
          condition() {
            return DataManager.isClearScene('1');
          }
        }, {
          id: '2', name: '浴室偷窥', eventId: 152, previewImg: 'cg/thumbnail/02', tooltip: '晚上趁着加奈洗澡的时候…',
          condition() {
            return DataManager.isClearScene('2');
          }
        }, {
          id: '3-1', name: '晚餐的“甜点”', eventId: 160, previewImg: 'cg/thumbnail/03', tooltip: '如果加奈好感度达到2级且性欲大于15的话…',
          condition() {
            return DataManager.isClearScene('3-1');
          }
        }, {
          id: '4-1', name: '浴室中的亲昵 - 1', eventId: 163, previewImg: 'cg/thumbnail/04', tooltip: '如果加奈好感度达到2级且性欲大于30的话…',
          condition() {
            return DataManager.isClearScene('4-1');
          }
        },
        // {
        //   id: '4-2', name: '浴室中的亲昵 - 2', eventId: 164, previewImg: 'cg/thumbnail/04_2', tooltip: '如果加奈好感度达到3级且性欲大于50的话…',
        //   condition() {
        //     return DataManager.isClearScene('4-2');
        //   }
        // },
        {
          id: '5-1', name: '千夏的报恩～♡', eventId: 166, previewImg: 'cg/thumbnail/05', tooltip: '如果千夏好感度达到2级的话…',
          condition() {
            return DataManager.isClearScene('5-1');
          }
        }, {
          id: '6-1', name: '对熟睡之人的恶作剧', eventId: 169, previewImg: 'cg/thumbnail/06', tooltip: '如果由纪好感度达到2级的话…',
          condition() {
            return DataManager.isClearScene('6-1');
          }
        }, {
          id: '7-1', name: '名为艾露的陷阱', eventId: 172, previewImg: 'cg/thumbnail/07', tooltip: '如果艾露好感度达到2级的话…',
          optionConfig: [
            { text: '是否观看处女路线？', options: ['是', '否'], onConfirm(index) { $gameSwitches.setValue(1, index); } },
          ],
          condition() {
            return DataManager.isClearScene('7-1');
          }
        }
      ],
      /** 【暂时不做】立绘列表 */
      tachieList: [],
      /** 音乐列表 */
      musicList: [],
    },
  };

  /** 事件回想专用场景 */
  class Scene_SceneThink extends Scene_Game {
    initialize() {
      super.initialize();
      this.isOnLight = true;
      /** 当前场景的立绘 */
      this.tachieMap = {};
    }

    createUI() {
      super.createUI();

      this.createBackground();
      this.createSceneObjects();

      // 获取当前场景
      this.sceneInfo = Utils_Scene.sceneList.find(i => i.name === this.currentScene);
      if (!this.sceneInfo) throw new Error(`场景[${this.currentScene}]不存在`);
      // 绘制界面
      this.createViewer();

      // 切换背景音乐
      // 如果上一个场景是游戏场景，且有保存BGM则还原，否则播放游戏自带BGM
      if (!SceneManager.isGameScene(SceneManager._previousClass) && $gameSystem._savedBgm) {
        $gameSystem.replayBgm();
      } else if (this.sceneInfo.bgm) {
        AudioManager.playBgm({ name: this.sceneInfo.bgm, volume: 100, pitch: 100, pan: 0 });
      }

      // 如果上一个场景是游戏场景，且有保存BGS则还原
      if (!SceneManager.isGameScene(SceneManager._previousClass) && $gameSystem._savedBgs) {
        $gameSystem.replayBgs();
      }

      this.createBackUI();
    }

    /** 显示返回的UI */
    createBackUI() {
      this.backBtn = new HakuComponent.Button({
        style: {
          backgroundImage: '/img/pictures/ui/common/btn_back'
        },
        'hover:style': {
          backgroundImage: '/img/pictures/ui/common/btn_back_active'
        },
        'tap:style': {
          backgroundImage: '/img/pictures/ui/common/btn_back_active'
        },
      });
      this.backBtn.width = 180;
      this.backBtn.height = 54;
      this.backBtn.x = 1110;
      this.backBtn.y = 10;
      this.backBtn.on('tap', () => {
        $gameMessage.isStopMessage = true;
        useConfirm({
          hasCancel: true,
          content: `要结束观看剧情回想吗？`,
          okHandler: (info) => {
            SoundManager.playOk();
            info.close();
            useTimeout(() => {
              this.finishSceneThink();
            }, 20);
          },
          cancelHandler() {
            SoundManager.playCancel();
            SceneManager._scene._messageWindow.cancelWait()
            useTimeout(() => {
              $gameMessage.isStopMessage = false;
            }, 20);
          }
        });
      });
      this.addChild(this.backBtn);
    }

    /** 结束事件回想 */
    finishSceneThink() {
      SceneManager.clearSceneInfo();
    }

    /** 显示游戏UI */
    showGameUI() {
      if ($gameData.isEventBusy) return;
      this.showNormalTooltip();
    }
    
    /** 隐藏游戏UI */
    hideGameUI() {
      this.setTooltip();
      this.showFullTooltip();
    }
    
    hideAllUI() {
      this._hideAllUIList = [];

      if (this.titleContainer) {
        this._hideAllUIList.push(this.titleContainer);
        this.titleContainer.alpha = 0;
      }
    }

    showAllUI() {
      for (let i = 0; i < this._hideAllUIList.length; i++) {
        const _item = this._hideAllUIList[i];
        _item.alpha = 1;
      }
      this._hideAllUIList = [];
    }
    
    /** 显示全宽度提示 */
    showFullTooltip() {
      if (!this.tooltipBgSprite || this.isFullTooltip === true) return;
      this.tooltipBgSprite.bitmap = ImageManager.loadPicture('ui/tooltip_bg_full');
      this.isFullTooltip = true;
    }
    /** 显示普通宽度提示 */
    showNormalTooltip() {
      if (!this.tooltipBgSprite || this.isFullTooltip === false) return;
      this.tooltipBgSprite.bitmap = ImageManager.loadPicture('ui/tooltip_bg');
      this.isFullTooltip = false;
    }

    /** 绘制界面 */
    drawViewer() {
      // 1. 绘制背景
      this.drawBackground();
      // 3. 绘制前景
      this.drawForeground();
      // 4. 绘制游戏组件
      this.drawGameComponents();
    }
    
    /** 创建界面 */
    createViewer() {
      // 1. 创建背景
      this.drawBackground();
      // 2. 创建立绘区域
      this.createTachieContainer();
      // 4. 创建前景和前景
      this.createForeground();
      this.drawForeground();
      // 5. 创建光照滤镜
      this.createFilter();
      // 6. 创建游戏组件
      this.createGameComponents();
    }
    
    createTachieContainer() {
      if (!this.tachieContainer) {
        this.tachieContainer = new SpineContainer();
        this.backUIContainer.addChild(this.tachieContainer);
      }
    }
    
    // #region 创建UI部分
    /** 创建游戏UI */
    createGameComponents() {
      // 1. 绘制最下方文本提示
      this.createTooltip();
      // 2. 绘制中上的场景标题
      // this.createSceneTitle();
    }

    /** 绘制最下方文本提示 */
    createTooltip() {
      this.tooltipContainer = new PIXI.Container();

      // 绘制背景
      const _bgSprite = new Sprite(ImageManager.loadPicture('ui/tooltip_bg'));
      _bgSprite.x = 0;
      _bgSprite.y = Graphics.height - 30;
      _bgSprite.uid = 'tooltip_bg';
      this.tooltipContainer.addChild(_bgSprite);
      this.tooltipBgSprite = _bgSprite;
      this.isFullTooltip = false;

      // 绘制图标
      const _iconSprite = new Sprite(ImageManager.loadPicture('ui/tooltip_icon'));
      _iconSprite.x = 15;
      _iconSprite.y = Graphics.height - 27;
      this.tooltipContainer.addChild(_iconSprite);

      // 绘制文本Sprite
      const _textSprite = new Sprite(new Bitmap(Graphics.width - 40 - 30, 30));
      _textSprite.x = 40;
      _textSprite.y = Graphics.height - 30;
      _textSprite.bitmap.textColor = '#D6D0CD';
      _textSprite.bitmap.drawText('', 5, 5, _textSprite.width - 40 - 30, 20);
      this.tooltipSprite = _textSprite;
      this.tooltipContainer.addChild(_textSprite);

      this.uiContainer.addChild(this.tooltipContainer);
    }

    /** 绘制场景标题 */
    createSceneTitle() {
      this.titleContainer = new PIXI.Container();

      // 绘制背景
      const _bgSprite = new Sprite(ImageManager.loadPicture('ui/title_name'));
      _bgSprite.x = (Graphics.width - 500);
      _bgSprite.y = 0;
      this.titleContainer.addChild(_bgSprite);

      // 绘制文本Sprite
      const _textSprite = new Sprite(new Bitmap(240, 36));
      _textSprite.x = (Graphics.width - 500);
      _textSprite.y = 0;
      _textSprite.bitmap.fontSize = 20;
      _textSprite.bitmap.textColor = '#dd7e54';
      _textSprite.bitmap.outlineWidth = 3;
      _textSprite.bitmap.outlineColor = '#FFFFFF';
      _textSprite.bitmap.drawText(this.sceneInfo.title || '', 5, 5, 240 - 10, 28, 'center');
      this.titleSprite = _textSprite;
      this.titleContainer.addChild(_textSprite);

      if (this.sceneInfo.title) {
        this.titleContainer.alpha = 1;
        this.titleContainer.children.forEach(i => i.alpha = 1);
      } else {
        this.titleContainer.alpha = 0;
        this.titleContainer.children.forEach(i => i.alpha = 0);
      }

      this.uiContainer.addChild(this.titleContainer);
    }

    /** 创建场景物品容器 */
    createSceneObjects() {
      const _container = new HakuContainer();
      this.objectsContainer = _container;
      this.backUIContainer.addChild(_container);
    }

    /** 清空场景物品 */
    clearSceneObjects() {
      if (this.objectsContainer) {
        this.objectsContainer.removeChildren();
      }
    }

    /** 创建场景物品 */
    drawSceneObjects() {
      if (!this.sceneInfo || !this.sceneInfo.sceneObjects) return;

      this.objectsContainer.removeChildren();

      const _objs = this.sceneInfo.sceneObjects;

      for (let i = 0; i < _objs.length; i++) {
        const _item = _objs[i];
        if (_item.condition && !_item.condition.call(this)) continue;

        const _sprite = new HakuSprite({
          useHover: false, x: _item.x, y: _item.y,
          hoverBitmap: _item.hoverImg,
          normalBitmap: _item.normalImg,
        });
        this.objectsContainer.addChild(_sprite);
      }
    }

    /** 创建环境 */
    createFilter() {
      const _container = new PIXI.Container();
      this.gameFilter = _container;
      this.backUIContainer.addChild(_container);
    }

    /** 绘制环境 */
    drawFilter(duration = 0) {
      if (this.sceneInfo.hasFilter) {
        if (this.sceneInfo.customFilter) {
          const _sprites = this.sceneInfo.customFilter();
          changeImgs(this.gameFilter, _sprites, duration);
        } else {
          let _path = '';
          let _blendMode = 0;

          switch (Utils_Time.timeSpan) {
            case 'daytime': break;
            case 'dusk':
              _path = 'bg/background_dusk_mask';
              _blendMode = 2;
              break;
            case 'night':
              _path = 'bg/background_night_mask';
              _blendMode = 2;
              // return `${_base}/bedroom_night${_scene.isOnLight ? "_light" : ""}${_scene.isSleep ? "_sleep" : ""}`;
            default:
              break;
          }
          const _sprite = new Sprite(_path ? ImageManager.loadPicture(_path) : undefined);
          if (_blendMode) {
            _sprite.blendMode = _blendMode;
          }
          changeImgs(this.gameFilter, _sprite, duration);
        }
      }
    }

    /**
     * 切换时段滤镜（动画）
     * @param {string|string[]} url 背景图片路径 
     * @param {number} duration 切换时间（帧数）
     * @param {Game_Interpreter} interpreter 事件执行器
     */
    changeFilter(filter, duration = 30, interpreter) {
      // 事件中的等待
      if (interpreter && duration) {
        interpreter.wait(duration);
      }

      this.drawFilter(duration);
    }

    /**
     * 清理时段滤镜（动画）
     * @param {string|string[]} url 背景图片路径 
     * @param {number} duration 切换时间（帧数）
     * @param {Game_Interpreter} interpreter 事件执行器
     */
    clearFilter(duration = 30, interpreter) {
      if (!this.gameFilter) return;
      // 事件中的等待
      if (interpreter && duration) {
        interpreter.wait(duration);
      }

      const _sprite = new Sprite();
      _sprite.blendMode = 2;
      changeImgs(this.gameFilter, _sprite, duration);
    }
    
    /** 绘制背景 */
    drawBackground() {
      if ((!this.sceneInfo.background && !$gameData.tempBackground) || !this.gameBackground) return;
      
      this.updateBlackMask();
      this.updateOverallFilters();

      if ($gameData.tempBackground) {
        this.drawImages(this.gameBackground, $gameData.tempBackground);
      } else {
        this.drawImages(this.gameBackground, this.sceneInfo.background);
      }

      if (isSameImage($gameData.tempBackground, this.sceneInfo.background)) {
        this.drawSceneObjects();
      } else {
        this.clearSceneObjects();
      }
    }
    
    /** 绘制前景 */
    drawForeground() {
      if ((!this.sceneInfo.foreground && !$gameData.tempForeground) || !this.gameForeground) return;

      if ($gameData.tempForeground) {
        this.drawImages(this.gameForeground, $gameData.tempForeground);
      } else {
        this.drawImages(this.gameForeground, this.sceneInfo.foreground);
      }
    }

    /** 绘制图片 */
    drawImages(container, imgObj, { isClear = true, duration } = { isClear: true, duration: 0 }) {

      if (!duration) {
        if (typeof imgObj === 'string') {
          ImageManager.loadImgCb(imgObj, (bitmap) => {
            if (isClear) container.removeChildren();
            container.addChild(new Sprite(bitmap));
          });
        } else if (Array.isArray(imgObj)) {
          if (isClear) {
            let _count = imgObj.length;
            let _index = 0;
            const _complete = () => {
              container.removeChildren();

              for (let i = 0; i < imgObj.length; i++) {
                const _img = imgObj[i];
                if (typeof _img === 'string') {
                  container.addChild(new Sprite(ImageManager.loadPicture(_img)));
                } else if (_img instanceof Sprite) {
                  container.addChild(_img);
                } else if (typeof _img === 'object') {
                  const _sprite = new Sprite(ImageManager.loadPicture(_img.path));
                  if (_img.blendMode) {
                    _sprite.blendMode = _img.blendMode;
                  }
                  container.addChild(_sprite);
                }
              }
            };

            for (let i = 0; i < imgObj.length; i++) {
              const _img = imgObj[i];
              if (typeof _img === 'string') {
                ImageManager.loadImgCb(_img, (bitmap) => {
                  _index++;
                  if (_index === _count) _complete();
                });
              } else if (_img instanceof Sprite) {
                _index++;
                if (_index === _count) _complete();
              } else if (typeof _img === 'object') {
                const _bitmap = ImageManager.loadPicture(_img.path);
                if (_bitmap.isReady()) {
                  _index++;
                  if (_index === _count) _complete();
                } else {
                  _bitmap.addLoadListener(() => {
                    _index++;
                    if (_index === _count) _complete();
                  });
                }
              }
            }

          } else {
            for (let i = 0; i < imgObj.length; i++) {
              const _img = imgObj[i];
              if (typeof _img === 'string') {
                container.addChild(new Sprite(ImageManager.loadPicture(_img)));
              } else if (_img instanceof Sprite) {
                container.addChild(_img);
              } else if (typeof _img === 'object') {
                const _sprite = new Sprite(ImageManager.loadPicture(_img.path));
                if (_img.blendMode) {
                  _sprite.blendMode = _img.blendMode;
                }
                container.addChild(_sprite);
              }
            }
          }
        }
      } else {
        const _newContainer = new PIXI.Container();
        const _oldContainer = new PIXI.Container();
        _newContainer.alpha = 0;

        for (let i = 0; i < container.children.length; ) {
          const _item = container.children[i];
          _oldContainer.addChild(_item);
        }
        
        if (typeof imgObj === 'string') {
          _newContainer.addChild(new Sprite(ImageManager.loadPicture(imgObj)));
        } else if (Array.isArray(imgObj)) {
          for (let i = 0; i < imgObj.length; i++) {
            const _img = imgObj[i];
            if (typeof _img === 'string') {
              _newContainer.addChild(new Sprite(ImageManager.loadPicture(_img)));
            } else if (typeof _img === 'object') {
              const _sprite = new Sprite(ImageManager.loadPicture(_img.path));
              if (_img.blendMode) {
                _sprite.blendMode = _img.blendMode;
              }
              _newContainer.addChild(_sprite);
            }
          }
        }

        container.addChild(_oldContainer);
        container.addChild(_newContainer);

        useTimeout(() => {
          _newContainer.alpha = 1;
          _oldContainer.alpha = 0;
          while (_newContainer.children.length > 0) {
            const _item = _newContainer.children[0];
            container.addChild(_item);
          }
          _newContainer.destroy();
          _oldContainer.destroy();
        }, duration, progress => {
          _newContainer.alpha = progress;
          _oldContainer.alpha = 1 - progress;
        }, {
          easingType: 'Quadratic',
          inout: 'InOut'
        });
      }
    }
    
    /**
     * 切换背景（动画）
     * @param {string|string[]} url 背景图片路径 
     * @param {number} duration 切换时间（帧数）
     * @param {Game_Interpreter} interpreter 事件执行器
     */
    changeBackground(url, duration = 30, interpreter) {
      if ((!url && !this.sceneInfo.background) || !this.gameBackground) return;

      if (url && Array.isArray(url)) {
        if (url.length === 0) {
          url = undefined;
        } else if (url.length === 1) {
          url = url[0];
        }
      }

      $gameData.tempBackground = url === '' ? '' : !!url ? url : undefined;

      // 事件中的等待
      if (interpreter && duration) {
        interpreter.wait(duration);
      }

      if ($gameData.tempBackground) {
        this.drawImages(this.gameBackground, $gameData.tempBackground, { clear: true, duration });
        if (isSameImage($gameData.tempBackground, this.sceneInfo.background)) {
          this.drawSceneObjects();
        } else {
          this.clearSceneObjects();
        }
      } else {
        this.drawImages(this.gameBackground, this.sceneInfo.background, { clear: true, duration });
        this.drawSceneObjects();
      }
    }
    
    /**
     * 切换前景（动画）
     * @param {string|string[]} url 背景图片路径 
     * @param {number} duration 切换时间（帧数）
     * @param {Game_Interpreter} interpreter 事件执行器
     */
    changeForeground(url, duration = 30, interpreter) {
      if ((!url && !this.sceneInfo.foreground) || !this.gameForeground) return;

      if (url && Array.isArray(url)) {
        if (url.length === 0) {
          url = undefined;
        } else if (url.length === 1) {
          url = url[0];
        }
      }

      $gameData.tempForeground = url === '' ? '' : !!url ? url : undefined;

      // 事件中的等待
      if (interpreter && duration) {
        interpreter.wait(duration);
      }
      
      if ($gameData.tempForeground) {
        this.drawImages(this.gameForeground, $gameData.tempForeground, { clear: true, duration });
      } else {
        this.drawImages(this.gameForeground, this.sceneInfo.foreground, { clear: true, duration });
      }
    }

    // #region 绘制UI部分
    /** 绘制游戏UI */
    drawGameComponents() {
      this.setTooltip();
      this.setSceneName(this.sceneInfo.title);
    }

    /** 设置说明文本 */
    setTooltip(text) {
      this.tooltipSprite.bitmap.clear();
      if (text) {
        this.tooltipSprite.bitmap.drawText(text, 5, 5, this.tooltipSprite.width - 40 - 30, 20);
      }
    }

    /** 设置场景名称 */
    setSceneName(name) {
      this.titleSprite.bitmap.clear();
      if (name) {
        console.log('场景名称', name);
        this.titleContainer.alpha = 1;
        this.titleSprite.bitmap.drawText(name, 5, 5, 240 - 10, 28, 'center');
        this.titleContainer.children.forEach(i => i.alpha = 1);
      } else {
        this.titleContainer.alpha = 0;
        this.titleContainer.children.forEach(i => i.alpha = 0);
      }
    }

    /** 创建背景 */
    createBackground() {
      const _sprite = new Sprite(new Bitmap(Graphics.width, Graphics.height));
      this.gameBackground = _sprite;
      _sprite.x = 0;
      _sprite.y = 0;
      this.backUIContainer.addChildAt(_sprite, 0);
    }
    /** 绘制前景 */
    createForeground() {
      const _sprite = new Sprite(new Bitmap(Graphics.width, Graphics.height));
      this.gameForeground = _sprite;
      _sprite.x = 0;
      _sprite.y = 0;
      this.backUIContainer.addChild(_sprite);
    }

    start() {
      super.start();
      // SceneManager.clearStack();
    }

    create() {
      super.create();
    }

    update() {
      if (Input.isTriggered('escape')) {
        $gameMessage.isStopMessage = true;
        useConfirm({
          hasCancel: true,
          content: `要结束观看剧情回想吗？`,
          okHandler: (info) => {
            SoundManager.playOk();
            info.close();
            useTimeout(() => {
              this.finishSceneThink();
            }, 20);
          },
          cancelHandler() {
            SoundManager.playCancel();
            SceneManager._scene._messageWindow.cancelWait()
            useTimeout(() => {
              $gameMessage.isStopMessage = false;
            }, 20);
          }
        });
      } else {
        super.update();
      }
    }

    get currentScene() {
      return 'scene_bedroom';
    }
  }
  window.Scene_SceneThink = Scene_SceneThink;

  /** 图片查看专用场景 */
  class Scene_ImgViewer extends Scene_Game {
    initialize() {
      super.initialize();

      $gameSystem._menuEnabled = false;
      this.pageIndex = 0;
      this.cgInfo = null;

      /** 是否自适应 */
      this.isAutoAdaptive = true;

      /** 自动播放配置 */
      this.autoConfig = {
        isStart: false,
        frameIndex: 0,
        frameCount: 200
      };
      
      this._cid = $gameData.img_viewer_cid;
      this.cgInfo = extrasModule.fullData.cgList.find(i => i.id === this._cid);
    }

    get pageCount() {
      if (!this._cid || !this.cgInfo) return 0;
      return this.cgInfo.imgs.length;
    }

    get isFullScreen() {
      return !!Graphics._isFullScreen();
    }

    createUI() {
      super.createUI();
      
      this.pageIndex = 0;
      
      // 主图
      if (!this.imgContainer) {
        this.imgContainer = new PIXI.Container();
        this.imgSprite = new Sprite();
        this.imgSprite.anchor.set(0.5, 0.5);
        this.imgSprite.x = (Graphics.width - this.imgSprite.width) / 2;
        this.imgSprite.y = (Graphics.height - this.imgSprite.height) / 2;
        this.imgContainer.addChild(this.imgSprite);
        this.addChild(this.imgContainer);
      }

      this.createPagination();
      this.createBackUI();
      this.createToolbarUI();
      this.changePage();
    }
    
    isFirstPage() {
      return this.pageIndex === 0;
    }
    isLastPage() {
      return this.pageIndex === this.pageCount - 1;
    }

    /** 创建翻页器和中间区域 */
    createPagination() {
      if (!this.paginationContainer) {
        this.paginationContainer = new HakuContainer();
        this.addChild(this.paginationContainer);
      }

      // 中间拖拽区域
      this.paginationContainer.addChild(new HakuContainer({ x: 80, y: 0 }));

      // 左右翻页按钮
      this.prevBtnSprite = new Sprite(ImageManager.loadPicture('ui/extras/img_viewer/prev_btn'));
      this.prevBtnSprite.alpha = 0.5;
      this.prevBtnSprite.x = 20;
      this.prevBtnSprite.y = 300;
      this.paginationContainer.addChild(this.prevBtnSprite);
      
      this.nextBtnSprite = new Sprite(ImageManager.loadPicture('ui/extras/img_viewer/next_btn'));
      this.nextBtnSprite.alpha = 0.5;
      this.nextBtnSprite.x = this.width - 95;
      this.nextBtnSprite.y = 300;
      this.paginationContainer.addChild(this.nextBtnSprite);
    }

    /** 切换页 */
    changePage(pageIndex) {
      if (pageIndex !== undefined) this.pageIndex = pageIndex;

      const _url = `${this.cgInfo.baseUrl || ''}${this.cgInfo.imgs[this.pageIndex]}`;
      
      this.imgSprite.bitmap = ImageManager.loadPicture(_url);

      if (this.pageTextSprite) {
        this.pageTextSprite.bitmap.clear();
        this.pageTextSprite.bitmap.drawText(TranslateUtils.getText(`$1 页`, `${this.pageIndex + 1} / ${this.pageCount}`), 0, 0, 200, 50);
      }

      if (this.isAutoAdaptive) {
        if (this.imgSprite.bitmap.isReady()) {
          let _scaleX = (Graphics.width / this.imgSprite.bitmap.width) || 1;
          let _scaleY = (Graphics.height / this.imgSprite.bitmap.height) || 1;
          let _scale = Math.min(_scaleX, _scaleY);
          this.imgSprite.scale.set(_scale, _scale);
          setTimeout(() => {
            this.ratioScroll.value = _scale * 100;
          }, 30);
        } else {
          this.imgSprite.bitmap.addLoadListener(() => {
            let _scaleX = (Graphics.width / this.imgSprite.bitmap.width) || 1;
            let _scaleY = (Graphics.height / this.imgSprite.bitmap.height) || 1;
            let _scale = Math.min(_scaleX, _scaleY);
            this.imgSprite.scale.set(_scale, _scale);
            setTimeout(() => {
              this.ratioScroll.value = _scale * 100;
            }, 30);
          });
        }
      }
    }

    /** 显示返回的UI */
    createBackUI() {

      this.closeBtn = new HakuSprite({
        useHover: true, x: 1200, y: 15, me: this,
        normalBitmap: ImageManager.loadPicture('ui/extras/img_viewer/close_btn'),
        hoverBitmap: ImageManager.loadPicture('ui/extras/img_viewer/close_btn_active'),
        onTap() {
          SoundManager.playOk();
          SceneManager.pop();
        }
      });
      this.addChild(this.closeBtn);
    }
    
    /** 创建工具栏UI */
    createToolbarUI() {
      if (this.toolbarContainer) {
        this.toolbarContainer.removeChildren();
      }
      this.toolbarContainer = new HakuContainer({
        x: 0, y: 650
      });
      this.addChild(this.toolbarContainer);

      // 背景图
      this.toolbarContainer.addChild(new Sprite(ImageManager.loadPicture('ui/extras/img_viewer/tool_bar_bg')));

      // 文本（页数）
      this.pageTextSprite = new Sprite(new Bitmap(200, 50));
      this.pageTextSprite.x = 90;
      this.pageTextSprite.y = 14;
      this.pageTextSprite.bitmap.fontFace = 'ChillRoundF';
      this.pageTextSprite.bitmap.fontSize = 20;
      this.pageTextSprite.bitmap.textColor = '#FFFFFF';
      this.pageTextSprite.bitmap.drawText(`${this.pageIndex + 1} / ${this.pageCount} 页`, 0, 0, 200, 50);
      this.toolbarContainer.addChild(this.pageTextSprite);

      // 自动播放
      this.toolbarContainer.addChild(new HakuSprite({
        useHover: true, x: 15, y: 16, me: this,
        normalBitmap() {
          const _url = `ui/extras/img_viewer/powerpoint_btn${ this.me.autoConfig.isStart ? '_enable' : '' }`;
          return ImageManager.loadPicture(_url);
        },
        hoverBitmap() {
          const _url = `ui/extras/img_viewer/powerpoint_btn${ this.me.autoConfig.isStart ? '_enable_active' : '_active' }`;
          return ImageManager.loadPicture(_url);
        },
        onTap() {
          this.me.autoConfig.isStart = !this.me.autoConfig.isStart;
          this.refresh();
        }
      }));

      // 自动调整为合适大小
      this.toolbarContainer.addChild(new HakuSprite({
        useHover: true, x: 860, y: 16, me: this,
        normalBitmap: ImageManager.loadPicture(`ui/extras/img_viewer/adapt_btn`),
        hoverBitmap: ImageManager.loadPicture(`ui/extras/img_viewer/adapt_btn_active`),
        
        normalBitmap() {
          const _url = `ui/extras/img_viewer/adapt_btn${ this.me.isAutoAdaptive ? '_enable' : '' }`;
          return ImageManager.loadPicture(_url);
        },
        hoverBitmap() {
          const _url = `ui/extras/img_viewer/adapt_btn${ this.me.isAutoAdaptive ? '_enable' : '' }_active`;
          return ImageManager.loadPicture(_url);
        },
        onTap() {
          this.me.isAutoAdaptive = !this.me.isAutoAdaptive;
          this.refresh();
          this.me.changePage();
        }
      }));

      // 滚动条
      this.ratioScroll = new HakuScroll({
        x: 1000, y: 25, direction: 'horizontal', max: 300, min: 30, me: this, defaultValue: 100,
        barImage: 'ui/extras/img_viewer/scroll_bar',
        progressImage: 'ui/extras/img_viewer/scroll_thumb_progress',
        thumbImage: 'ui/extras/img_viewer/scroll_thumb',
        pageHeight: this._messageWindow.height,
        onChange(value) {
          const _val = Number((value / 100).toFixed(2));
          this.me.imgSprite.scale.set(_val);

          this.me.ratioTextSprite.bitmap.clear();
          this.me.ratioTextSprite.bitmap.drawText(`${Math.round(_val * 100)}%`, 0, 0, 80, 50, 'center');
        }
      });
      this.toolbarContainer.addChild(this.ratioScroll);

      // 文本（放大比率）
      this.ratioTextContainer = new HakuContainer({
        useHover: true, x: 920, y: 15, width: 80, height: 50, me: this,
        onHover() {
          this.me.ratioTextBgSprite.bitmap = ImageManager.loadPicture('ui/extras/img_viewer/ratiotext_btn_active');
        },
        onBlur() {
          this.me.ratioTextBgSprite.bitmap = ImageManager.loadPicture('ui/extras/img_viewer/ratiotext_btn');
        },
        onTap() {
          this.me.ratioScroll.value = 100;
        }
      });

      this.ratioTextBgSprite = new Sprite(ImageManager.loadPicture('ui/extras/img_viewer/ratiotext_btn'));
      this.ratioTextContainer.addChild(this.ratioTextBgSprite);

      this.ratioTextSprite = new Sprite(new Bitmap(80, 50));
      this.ratioTextSprite.x = 0;
      this.ratioTextSprite.y = 0;
      this.ratioTextSprite.bitmap.fontFace = 'ChillRoundF';
      this.ratioTextSprite.bitmap.fontSize = 20;
      this.ratioTextSprite.bitmap.textColor = '#FFFFFF';
      this.ratioTextSprite.bitmap.drawText(`100%`, 0, 0, 80, 50, 'center');
      this.ratioTextContainer.addChild(this.ratioTextSprite);

      this.toolbarContainer.addChild(this.ratioTextContainer);

      // 最大化
      this.toolbarContainer.addChild(new HakuSprite({
        useHover: true, x: 1220, y: 16, me: this,
        normalBitmap() {
          const _url = `ui/extras/img_viewer/${ this.me.isFullScreen ? 'minimize' : 'maximize' }_btn`;
          return ImageManager.loadPicture(_url);
        },
        hoverBitmap() {
          const _url = `ui/extras/img_viewer/${ this.me.isFullScreen ? 'minimize' : 'maximize' }_btn_active`;
          return ImageManager.loadPicture(_url);
        },
        onTap() {
          Graphics._switchFullScreen();
        }
      }));
    }
    
    hideAllUI() {
      this.isHideUI = true;
      this.toolbarContainer.visible = false;
      this.prevBtnSprite.visible = false;
      this.nextBtnSprite.visible = false;
      this.closeBtn.visible = false;
    }

    showAllUI() {
      this.isHideUI = false;
      this.toolbarContainer.visible = true;
      this.prevBtnSprite.visible = true;
      this.nextBtnSprite.visible = true;
      this.closeBtn.visible = true;
    }

    update() {
      super.update();

      if (this.visibleDialog) return;

      if (Input.isTriggered('escape') || TouchInput.isCancelled()) {
        useConfirm({
          hasCancel: true,
          content: `要结束观看CG吗？`,
          okHandler: (info) => {
            SoundManager.playOk();
            info.close();
            SceneManager.pop();
          }
        });
        return;
      } else if (Input.isTriggered('pageup') || Input.isTriggered('left')) {
        SoundManager.playOk();
        const _pageIndex = this.isFirstPage() ? this.pageCount - 1 : this.pageIndex - 1;
        this.changePage(_pageIndex);
        return;
      } else if (Input.isTriggered('pagedown') || Input.isTriggered('right')) {
        SoundManager.playOk();
        const _pageIndex = this.isLastPage() ? 0 : this.pageIndex + 1;
        this.changePage(_pageIndex);
        return;
      } else if (TouchInput.wheelY > 0) {
        this.ratioScroll.value = this.ratioScroll.value - 10;
        return;
      } else if (TouchInput.wheelY < 0) {
        this.ratioScroll.value = this.ratioScroll.value + 10;
        return;
      }

      const _isTriggered = TouchInput.isTriggered();
      const _x = TouchInput.x;
      const _y = TouchInput.y;
      let _tempActiveElement = '';

      if (_x > 100 && _x < Graphics.width - 100 && _y < Graphics.height - 100) {
        _tempActiveElement = 'panel';

        if (_isTriggered) {
          if (this.isHideUI) {
            this.showAllUI();
          } else {
            this.hideAllUI();
          }
        }
      }

      // 左侧翻页
      if (_x < 100 && _y < Graphics.height - 100) {
        if (this.activeElementId !== 'prev-btn') {
          SoundManager.playCursor();
          Utils_Cursor.cursorType = 'pointer';
          this.prevBtnSprite.alpha = 1;
          this.prevBtnSprite.bitmap = ImageManager.loadPicture('ui/extras/img_viewer/prev_btn_active');
          this.activeElementId = 'prev-btn';
        }
        _tempActiveElement = 'prev-btn';

        if (_isTriggered) {
          SoundManager.playOk();
          const _pageIndex = this.isFirstPage() ? this.pageCount - 1 : this.pageIndex - 1;
          this.changePage(_pageIndex);
        }
      } else if (this.activeElementId === 'prev-btn') {
        this.activeElementId = '';
        Utils_Cursor.cursorType = 'default';
        this.prevBtnSprite.alpha = 0.5;
        this.prevBtnSprite.bitmap = ImageManager.loadPicture('ui/extras/img_viewer/prev_btn');
      }
      
      // 右侧翻页
      if (_x > Graphics.width - 100 && _y > 100 && _y < Graphics.height - 100) {
        if (this.activeElementId !== 'next-btn') {
          SoundManager.playCursor();
          Utils_Cursor.cursorType = 'pointer';
          this.nextBtnSprite.alpha = 1;
          this.nextBtnSprite.bitmap = ImageManager.loadPicture('ui/extras/img_viewer/next_btn_active');
          this.activeElementId = 'next-btn';
        }
        _tempActiveElement = 'next-btn';

        if (_isTriggered) {
          SoundManager.playOk();
          const _pageIndex = this.isLastPage() ? 0 : this.pageIndex + 1;
          this.changePage(_pageIndex);
        }
      } else if (this.activeElementId === 'next-btn') {
        this.activeElementId = '';
        Utils_Cursor.cursorType = 'default';
        this.nextBtnSprite.alpha = 0.5;
        this.nextBtnSprite.bitmap = ImageManager.loadPicture('ui/extras/img_viewer/next_btn');
      }
      
      if (!_tempActiveElement) {
        Utils_Cursor.cursorType = 'default';
        this.activeElementId = '';
      }

      if (this.autoConfig.isStart) {
        this.autoConfig.frameIndex++;
        if (this.autoConfig.frameIndex >= this.autoConfig.frameCount) {
          this.autoConfig.frameIndex = 0;
          const _pageIndex = this.isLastPage() ? 0 : this.pageIndex + 1;
          this.changePage(_pageIndex);
        }
      }

    }
  }
  window.Scene_ImgViewer = Scene_ImgViewer;

  class Scene_Extras extends Scene_Game {
    initialize() {
      super.initialize();

      /** tab选项列表 */
      this.tabs = [
        // CG浏览 / グラフィック / Graphic
        { name: 'CG浏览', tabText: 'CG浏览' },
        // 事件回想 / シーン回想 / Scene
        { name: '事件回想', tabText: '事件回想' },
        // 动画鉴赏 / ムービー鉴赏 / Moive
        // { name: '动画鉴赏', tabText: '动画鉴赏' },
        // 音乐鉴赏 / 音楽鑑賞 / Music
        // { name: '音乐鉴赏', tabText: '音乐鉴赏' },
      ];

      this.pageWidth = 1080;
      this.pageHeight = 500;

      // this.animeType = 'in';
      // this.animeInOutInfo = useAnime({
      //   frameDelay: 0,
      //   frameCount: 2,
      //   easingType: 'Quadratic',
      //   inout: 'InOut',
      // }, progress => {
      //   const _baseY = (Graphics.height - this.pageHeight) / 2 + 40;
      //   if (this.animeType === 'in') {
      //     this._messageWindow.alpha = progress;
      //     // this._messageWindow.y = parseInt(_baseY - 30 + progress * 30);
      //   } else if (this.animeType === 'out') {
      //     this._messageWindow.alpha = 1 - progress;
      //     // this._messageWindow.y = parseInt(_baseY - progress * 30);
      //     if (progress >= 1) {
      //       SceneManager.pop();
      //     }
      //   }
      // });
    }

    /** 当前Tab索引 */
    get tabIndex() {
      if (!$gameData.tempInfo) $gameData.tempInfo = {};
      return $gameData.tempInfo.tabIndex || 0;
    }
    set tabIndex(value) {
      $gameData.tempInfo.tabIndex = value;
    }

    create() {
      super.create();
      this.createBackground();
      this.createTabs();
      this.createWindows();
      this.refreshTab();

      this.addChild(new HakuSprite({
        useHover: true, x: 1120, y: 10, me: this,
        normalBitmap: ImageManager.loadPicture('ui/common/btn_back_mini'),
        hoverBitmap: ImageManager.loadPicture('ui/common/btn_back_mini_active'),
        onTap: () => {
          SoundManager.playCancel();
          SceneManager.pop();
        }
      }));
    }

    /** 透明背景 */
    createBackground() {
      this._backgroundSprite = new Sprite(ImageManager.loadPicture('ui/background'));
      this.addChildAt(this._backgroundSprite, 0);
      
      this._panelSprite = new Sprite(ImageManager.loadPicture('ui/extras/background'));
      this._panelSprite.x = 0;
      this._panelSprite.y = 0;
      this.addChildAt(this._panelSprite, 1);
      
      this._titleSprite = new Sprite(ImageManager.loadPicture('ui/title_txt/extras_title_zh-CN'));
      this._titleSprite.x = 106;
      this._titleSprite.y = 38;
      this.addChildAt(this._titleSprite, 2);
    }

    /** 创建Tabs */
    createTabs() {
      if (this.tabContainer) {
        this.tabContainer.destroy();
        this.tabContainer = null;
      }
      
      this.tabContainer = new PIXI.Container();
      this.tabContainer.x = 576 + (4 - this.tabs.length) * 168;
      this.tabContainer.y = 74;

      for (let i = 0; i < this.tabs.length; i++) {
        const _tab = this.tabs[i];
        
        const _tabItemContainer = new PIXI.Container();
        _tabItemContainer.x = i * 168;

        const _bgImg = ImageManager.loadPicture(`ui/extras/tab_${this.tabIndex === i ? '' : 'un'}active`);
        const _tabBg = new Sprite(_bgImg);
        _tab.sprite = _tabBg;
        _tabItemContainer.addChild(_tabBg);
        
        const _bgText = new Bitmap(160, 48);
        _bgText.smooth = false;
        _bgText.fontFace = 'ChillRoundF';
        _bgText.fontSize = 20;
        _bgText.textColor = '#FFFFFF';
        _bgText.outlineWidth = 1;
        _bgText.outlineColor = 'rgba(0,0,0,0)';
        _bgText.drawText(_tab.tabText, 0, 10, 160, 38, 'center');
        _bgText.y = 8;
        const _tabText = new Sprite(_bgText);
        _tabItemContainer.addChild(_tabText);

        const _maskImg = ImageManager.loadPicture(`ui/extras/tab_mask`);
        const _tabMask = new Sprite(_maskImg);
        _tabMask.alpha = 0;
        _tab.maskSprite = _tabMask;
        _tabItemContainer.addChild(_tabMask);

        _tab.container = _tabItemContainer;

        this.tabContainer.addChild(_tabItemContainer);
      }

      this.addChild(this.tabContainer);
    }

    createWindows() {
      this._galleryWindow = new Window_Gallery(this.pageWidth, this.pageHeight);
      this._galleryWindow.visible = false;
      this.addChild(this._galleryWindow);

      this._recollectionWindow = new Window_Recollection(this.pageWidth, this.pageHeight);
      this._recollectionWindow.visible = false;
      this.addChild(this._recollectionWindow);

      // this._movieWindow = new Window_Moive(this.pageWidth, this.pageHeight);
      // this._movieWindow.visible = false;
      // this.addChild(this._movieWindow);
      
      // this._musicWindow = new Window_Music(this.pageWidth, this.pageHeight);
      // this._musicWindow.visible = false;
      // this.addChild(this._musicWindow);
    }

    changeTab(index) {
      if (this.tabIndex === index) return;

      for (let i = 0; i < this.tabs.length; i++) {
        const _item = this.tabs[i];
        if (i === index) {
          _item.sprite.bitmap = ImageManager.loadPicture(`ui/extras/tab_active`);
        } else {
          _item.sprite.bitmap = ImageManager.loadPicture(`ui/extras/tab_unactive`);
        }
      }
      

      this.tabIndex = index;
      this.refreshTab();
    }

    refreshTab() {
      if (this.tabIndex !== 0 && this._galleryWindow.visible !== false) {
        this._galleryWindow.visible = false;
      }
      if (this.tabIndex !== 1 && this._recollectionWindow.visible !== false) {
        this._recollectionWindow.visible = false;
      }
      // if (this.tabIndex !== 1 && this._movieWindow.visible !== false) {
      //   this._movieWindow.visible = false;
      // }
      // if (this.tabIndex !== 1 && this._musicWindow.visible !== false) {
      //   this._musicWindow.visible = false;
      // }

      if (this.tabIndex === 0) {
        // CG浏览
        this._galleryWindow.visible = true;
      } else if (this.tabIndex === 1) {
        // 事件回想
        this._recollectionWindow.visible = true;
      } 
      // else if (this.tabIndex === 2) {
      //   // 动画鉴赏
      //   this._movieWindow.visible = true;

      // } else if (this.tabIndex === 3) {
      //   // 音乐鉴赏
      //   this._musicWindow.visible = true;

      // }
    }

    update() {
      super.update();

      this.updateTabs();
    }

    callMenu() {
      
    }

    updateTabs() {
      const _mouseX = TouchInput.x;
      const _mouseY = TouchInput.y;

      if (SceneManager._scene.visibleDialog) return;

      if (this.tabContainer && this.tabContainer.inArea(_mouseX, _mouseY, -30, -30, 60, 60)) {
        // 更新tab
        const _tabs = this.tabs.filter(i => i.visible !== false);
        for (let i = 0; i < _tabs.length; i++) {
          const item = _tabs[i];
          // 光标进入范围内
          if (item.container && item.container.inArea(_mouseX, _mouseY, this.tabContainer.x, this.tabContainer.y)) {
            if (item.disabled !== true) {
              if (!item.isHover) {
                Utils_Cursor.cursorType = 'pointer';
                item.maskSprite.alpha = 1;
                // this.hoverBtn = item.name;
                SoundManager.playCursor();
              }
              item.isHover = true;
            }
            // 点击
            if (TouchInput.isTriggered()) {
              // 禁用状态
              if (item.disabled === true) {
                SoundManager.playBuzzer();
                continue;
              } else {
                item.isHover = false;
                SoundManager.playOk();
                this.changeTab(i);
              }
            }
          } else {
            if (item.isHover) {
              item.isHover = false;
              item.maskSprite.alpha = 0;
            }
          }
        }
        
        if (this.tabs.every(i => i.isHover !== true)) {
          Utils_Cursor.cursorType = 'default';
        }
      }


      // 判断取消/返回
      if (TouchInput.isCancelled() || Input.isPressed('cancel')) {
        SoundManager.playCancel();
        SceneManager.pop();
      }
    }
  }
  window.Scene_Extras = Scene_Extras;

  /**
   * CG浏览窗口
   */
  class Window_Gallery extends Window_Base {
    initialize(pageWidth, pageHeight) {
      this.pageWidth = pageWidth;
      this.pageHeight = pageHeight;
      this._handlers = {};
      super.initialize(new Rectangle(98, 120 + 30, this.pageWidth, this.pageHeight));
      this.opacity = 0;

      this._listData = [];

      this.refresh();


      this.mainContainer = new HakuContainer();
      this.addChild(this.mainContainer);
      // 创建翻页器
      this.createPagination();
      // 翻页（创建列表项）
      this.changePage();
    }

    /** 翻页索引 */
    get pageIndex() {
      if (!$gameData.tempInfo) $gameData.tempInfo = {};
      return $gameData.tempInfo.galleryPageIndex || 0;
    }
    set pageIndex(value) {
      $gameData.tempInfo.galleryPageIndex = value;
    }

    /** 获取当前页数据 */
    getCurrentPageData() {
      return extrasModule.fullData.cgList.slice(this.pageIndex * 6, (this.pageIndex + 1) * 6);
    }

    refresh() {

    }

    changePage(index) {
      if (index === undefined) {
        this.drawItems();
        return;
      }
      if (index === this.pageIndex) return;

      this.pageIndex = index;

      this.createPagination();
      this.drawItems();
    }

    isFirstPage() {
      return this.pageIndex === 0;
    }
    isLastPage() {
      return this.pageIndex === this.maxPageCount - 1;
    }
    get maxPageCount() {
      const _hasRem = extrasModule.fullData.cgList.length % 6 > 0 ? 1 : 0;
      return Math.floor(extrasModule.fullData.cgList.length / 6) + _hasRem;
    }

    /** 创建翻页器 */
    createPagination() {
      if (this.paginationContainer && this.paginationContainer.parent) {
        this.paginationContainer.removeChildren();
        this.numSplitContainer.removeChildren();
      } else {
        this.paginationContainer = new HakuContainer();
        this.numSplitContainer = new HakuContainer({
          x: (this.width - this.maxPageCount * 60) / 2, y: Graphics.height - 235,
        });
        this.mainContainer.addChild(this.paginationContainer);
        this.mainContainer.addChild(this.numSplitContainer);
      }
      if (this.maxPageCount <= 1) {
        this.paginationContainer.visible = false;
        this.numSplitContainer.visible = false;
      }

      // 翻页按钮
      this.paginationContainer.addChild(new HakuSprite({
        useHover: true, x: -46, y: 170, me: this,
        normalBitmap: 'ui/button/page_prev_btn',
        hoverBitmap: 'ui/button/page_prev_btn_active',
        // disabledBitmap: 'ui/button/page_prev_btn_disabled',
        // disabled() { return this.isFirstPage() },
        onTap() {
          const _pageIndex = this.me.isFirstPage() ? this.me.maxPageCount - 1 : this.me.pageIndex - 1;
          this.me.changePage(_pageIndex);
        }
      }));
      
      this.paginationContainer.addChild(new HakuSprite({
        useHover: true, x: this.width - 18, y: 170, me: this,
        normalBitmap: 'ui/button/page_next_btn',
        hoverBitmap: 'ui/button/page_next_btn_active',
        // disabledBitmap: 'ui/button/page_next_btn_disabled',
        // disabled() { return this.isLastPage() },
        onTap() {
          const _pageIndex = this.me.isLastPage() ? 0 : this.me.pageIndex + 1;
          this.me.changePage(_pageIndex);
        }
      }));

      
      // 数字翻页器
      this._pageNumSpriteList = [];

      for (let i = 0; i < this.maxPageCount; i++) {
        let _bitmapUrl;
        if (this.pageIndex === i) {
          _bitmapUrl = 'ui/button/page_num_item_active';
        } else {
          _bitmapUrl = 'ui/button/page_num_item';
        }

        const _pageNumContainer = new HakuContainer({
          useHover: true, x: i * 60, y: 0, me: this,
          disabled() { return this.pageIndex === i },
          onHover() {
            if (this.me.pageIndex === i) return;
            this.me._pageNumSpriteList[i].bgSprite.bitmap = ImageManager.loadPicture('ui/button/page_num_item_hover');
          },
          onBlur() {
            if (this.me.pageIndex === i) return;
            this.me._pageNumSpriteList[i].bgSprite.bitmap = ImageManager.loadPicture('ui/button/page_num_item');
          },
          onTap() {
            this.me.changePage(i);
          }
        });
        this.numSplitContainer.addChild(_pageNumContainer);

        const _pageNumSprite = new Sprite(ImageManager.loadPicture(_bitmapUrl));
        _pageNumContainer.addChild(_pageNumSprite);

        const _pageNumTextSprite = new Sprite(new Bitmap(50, 50));
        _pageNumTextSprite.bitmap.fontSize = 26;
        _pageNumTextSprite.bitmap.outlineWidth = 3;
        if (this.pageIndex === i) {
          _pageNumTextSprite.bitmap.textColor = '#ffffff';
          _pageNumTextSprite.bitmap.outlineColor = 'rgba(0,0,0,0)';
        } else {
          _pageNumTextSprite.bitmap.textColor = '#fc8919';
          _pageNumTextSprite.bitmap.outlineColor = '#ffffff';
        }
        _pageNumTextSprite.bitmap.drawText((i + 1) + '', 0, 0, 50, 50, 'center');
        _pageNumContainer.addChild(_pageNumTextSprite);

        this._pageNumSpriteList.push({
          bgSprite: _pageNumSprite,
          textSprite: _pageNumTextSprite,
          index: i
        });
      }
    }

    drawItems() {
      if (this.itemsContainer) {
        this.itemsContainer.removeChildren();
      } else {
        this.itemsContainer = new HakuContainer({
          x: 36, y: 30,
        });
        this.mainContainer.addChild(this.itemsContainer);
      }
      const _list = this.getCurrentPageData();
      this._listData = [];

      let _index = this.pageIndex * 6;

      for (let y = 0; y < 2; y++) {
        for (let x = 0; x < 3; x++) {

          if (x + y * 3 < _list.length) {
            const _item = _list[x + y * 3];
            const _obj = { info: cloneLoop(_item) };
            
            _obj.container = new HakuContainer({
              useHover: true, x: x * 344, y: y * 230, me: this,
              disabled() { return !_item.condition() },
              onHover() {
                _obj.maskSprite.alpha = 1;
              },
              onBlur() {
                _obj.maskSprite.alpha = 0;
              },
              onTap() {
                this.me.tapItem(_obj.info);
              }
            });
            this.drawItem(_item, _obj.container, _obj);
            this.itemsContainer.addChild(_obj.container);
            this._listData.push(_obj);
          }

          _index++;
        }
      }
    }

    /** 画单个项 */
    drawItem(item, container, obj) {
      // 缩略图
      const _itemPreviewSprite = new Sprite(ImageManager.loadPicture(item.previewImg));
      container.addChild(_itemPreviewSprite);
      // 背景框
      const _borderBgSprite = new Sprite(ImageManager.loadPicture('ui/extras/item_border'));
      container.addChild(_borderBgSprite);
      // 滑块
      if (!item.condition()) {
        const _itemLock1Sprite = new Sprite(ImageManager.loadPicture('ui/extras/item_lock_l1'));
        container.addChild(_itemLock1Sprite);
        const _itemLock2Sprite = new Sprite(ImageManager.loadPicture('ui/extras/item_lock_l2'));
        obj.slideSprite = _itemLock2Sprite;
        container.addChild(_itemLock2Sprite);
        const _itemLock3Sprite = new Sprite(ImageManager.loadPicture('ui/extras/item_lock_l3'));
        container.addChild(_itemLock3Sprite);
      }
      obj.maskSprite = new Sprite(ImageManager.loadPicture('ui/extras/item_mask'));
      obj.maskSprite.alpha = 0;
      container.addChild(obj.maskSprite);
      // 标题
      const _titleSprite = new Sprite(new Bitmap(320, 40));
      _titleSprite.bitmap.smooth = false;
      _titleSprite.bitmap.fontFace = 'ChillRoundF';
      _titleSprite.bitmap.fontSize = 22;
      _titleSprite.bitmap.textColor = '#665258';
      _titleSprite.bitmap.outlineWidth = 1;
      _titleSprite.bitmap.outlineColor = 'rgba(0,0,0,0)';
      _titleSprite.bitmap.drawText(item.name, 0, 0, 320, 40, 'center');
      _titleSprite.y = 180;
      container.addChild(_titleSprite);
    }

    tapItem(info) {
      Utils_History.clear();

      $gameData.img_viewer_cid = info.id;
      SceneManager.add(Scene_ImgViewer);
    }
  }
  window.Window_Gallery = Window_Gallery;

  /**
   * 事件回想窗口
   */
  class Window_Recollection extends Window_Base {
    initialize(pageWidth, pageHeight) {
      this.pageWidth = pageWidth;
      this.pageHeight = pageHeight;
      this._handlers = {};
      super.initialize(new Rectangle(98, 120 + 30, this.pageWidth, this.pageHeight));
      this.opacity = 0;

      this._listData = [];

      this.refresh();


      this.mainContainer = new HakuContainer();
      this.addChild(this.mainContainer);
      // 创建翻页器
      this.createPagination();
      // 翻页（创建列表项）
      this.changePage();
    }

    /** 翻页索引 */
    get pageIndex() {
      if (!$gameData.tempInfo) $gameData.tempInfo = {};
      return $gameData.tempInfo.recollectionPageIndex || 0;
    }
    set pageIndex(value) {
      $gameData.tempInfo.recollectionPageIndex = value;
    }

    /** 获取当前页数据 */
    getCurrentPageData() {
      return extrasModule.fullData.sceneList.slice(this.pageIndex * 6, (this.pageIndex + 1) * 6);
    }

    refresh() {

    }

    changePage(index) {
      if (index === undefined) {
        this.drawItems();
        return;
      }
      if (index === this.pageIndex) return;

      this.pageIndex = index;

      this.createPagination();
      this.drawItems();
    }

    isFirstPage() {
      return this.pageIndex === 0;
    }
    isLastPage() {
      return this.pageIndex === this.maxPageCount - 1;
    }
    get maxPageCount() {
      const _hasRem = extrasModule.fullData.sceneList.length % 6 > 0 ? 1 : 0;
      return Math.floor(extrasModule.fullData.sceneList.length / 6) + _hasRem;
    }

    /** 创建翻页器 */
    createPagination() {
      if (this.paginationContainer && this.paginationContainer.parent) {
        this.paginationContainer.removeChildren();
        this.numSplitContainer.removeChildren();
      } else {
        this.paginationContainer = new HakuContainer();
        this.numSplitContainer = new HakuContainer({
          x: (this.width - this.maxPageCount * 60) / 2, y: Graphics.height - 235,
        });
        this.mainContainer.addChild(this.paginationContainer);
        this.mainContainer.addChild(this.numSplitContainer);
      }

      // 左翻页按钮
      this.paginationContainer.addChild(new HakuSprite({
        useHover: true, x: -46, y: 170, me: this,
        normalBitmap: 'ui/button/page_prev_btn',
        hoverBitmap: 'ui/button/page_prev_btn_active',
        // disabledBitmap: 'ui/button/page_prev_btn_disabled',
        // disabled() { return this.isFirstPage() },
        onTap() {
          const _pageIndex = this.me.isFirstPage() ? this.me.maxPageCount - 1 : this.me.pageIndex - 1;
          this.me.changePage(_pageIndex);
        }
      }));
      
      this.paginationContainer.addChild(new HakuSprite({
        useHover: true, x: this.width - 18, y: 170, me: this,
        normalBitmap: 'ui/button/page_next_btn',
        hoverBitmap: 'ui/button/page_next_btn_active',
        // disabledBitmap: 'ui/button/page_next_btn_disabled',
        // disabled() { return this.isLastPage() },
        onTap() {
          const _pageIndex = this.me.isLastPage() ? 0 : this.me.pageIndex + 1;
          this.me.changePage(_pageIndex);
        }
      }));

      
      // 数字翻页器
      this._pageNumSpriteList = [];

      for (let i = 0; i < this.maxPageCount; i++) {
        let _bitmapUrl;
        if (this.pageIndex === i) {
          _bitmapUrl = 'ui/button/page_num_item_active';
        } else {
          _bitmapUrl = 'ui/button/page_num_item';
        }

        const _pageNumContainer = new HakuContainer({
          useHover: true, x: i * 60, y: 0, me: this,
          disabled() { return this.pageIndex === i },
          onHover() {
            if (this.me.pageIndex === i) return;
            this.me._pageNumSpriteList[i].bgSprite.bitmap = ImageManager.loadPicture('ui/button/page_num_item_hover');
          },
          onBlur() {
            if (this.me.pageIndex === i) return;
            this.me._pageNumSpriteList[i].bgSprite.bitmap = ImageManager.loadPicture('ui/button/page_num_item');
          },
          onTap() {
            this.me.changePage(i);
          }
        });
        this.numSplitContainer.addChild(_pageNumContainer);

        const _pageNumSprite = new Sprite(ImageManager.loadPicture(_bitmapUrl));
        _pageNumContainer.addChild(_pageNumSprite);

        const _pageNumTextSprite = new Sprite(new Bitmap(50, 50));
        _pageNumTextSprite.bitmap.fontSize = 26;
        _pageNumTextSprite.bitmap.outlineWidth = 3;
        if (this.pageIndex === i) {
          _pageNumTextSprite.bitmap.textColor = '#ffffff';
          _pageNumTextSprite.bitmap.outlineColor = 'rgba(0,0,0,0)';
        } else {
          _pageNumTextSprite.bitmap.textColor = '#fc8919';
          _pageNumTextSprite.bitmap.outlineColor = '#ffffff';
        }
        _pageNumTextSprite.bitmap.drawText((i + 1) + '', 0, 0, 50, 50, 'center');
        _pageNumContainer.addChild(_pageNumTextSprite);

        this._pageNumSpriteList.push({
          bgSprite: _pageNumSprite,
          textSprite: _pageNumTextSprite,
          index: i
        });
      }
    }

    drawItems() {
      if (this.itemsContainer) {
        this.itemsContainer.removeChildren();
      } else {
        this.itemsContainer = new HakuContainer({
          x: 36, y: 30,
        });
        this.mainContainer.addChild(this.itemsContainer);
      }
      const _list = this.getCurrentPageData();
      this._listData = [];

      let _index = this.pageIndex * 6;

      for (let y = 0; y < 2; y++) {
        for (let x = 0; x < 3; x++) {

          if (x + y * 3 < _list.length) {
            const _item = _list[x + y * 3];
            const _obj = { info: cloneLoop(_item) };
            
            _obj.container = new HakuContainer({
              useHover: true, x: x * 344, y: y * 230, me: this,
              disabled() { return !_item.condition() },
              onHover() {
                _obj.maskSprite.alpha = 1;
              },
              onBlur() {
                _obj.maskSprite.alpha = 0;
              },
              onTap() {
                this.me.tapItem(_obj.info);
              }
            });
            this.drawItem(_item, _obj.container, _obj);
            this.itemsContainer.addChild(_obj.container);
            this._listData.push(_obj);
          }

          _index++;
        }
      }
    }

    /** 画单个项 */
    drawItem(item, container, obj) {
      // 缩略图
      const _itemPreviewSprite = new Sprite(ImageManager.loadPicture(item.previewImg));
      container.addChild(_itemPreviewSprite);
      // 背景框
      const _borderBgSprite = new Sprite(ImageManager.loadPicture('ui/extras/item_border'));
      container.addChild(_borderBgSprite);
      // 滑块
      if (!item.condition()) {
        const _itemLock1Sprite = new Sprite(ImageManager.loadPicture('ui/extras/item_lock_l1'));
        container.addChild(_itemLock1Sprite);
        const _itemLock2Sprite = new Sprite(ImageManager.loadPicture('ui/extras/item_lock_l2'));
        obj.slideSprite = _itemLock2Sprite;
        container.addChild(_itemLock2Sprite);
        const _itemLock3Sprite = new Sprite(ImageManager.loadPicture('ui/extras/item_lock_l3'));
        container.addChild(_itemLock3Sprite);
      }
      obj.maskSprite = new Sprite(ImageManager.loadPicture('ui/extras/item_mask'));
      obj.maskSprite.alpha = 0;
      container.addChild(obj.maskSprite);
      // 标题
      const _titleSprite = new Sprite(new Bitmap(320, 40));
      _titleSprite.bitmap.smooth = false;
      _titleSprite.bitmap.fontFace = 'ChillRoundF';
      _titleSprite.bitmap.fontSize = 22;
      _titleSprite.bitmap.textColor = '#665258';
      _titleSprite.bitmap.outlineWidth = 1;
      _titleSprite.bitmap.outlineColor = 'rgba(0,0,0,0)';
      _titleSprite.bitmap.drawText(item.name, 0, 0, 320, 40, 'center');
      _titleSprite.y = 180;
      container.addChild(_titleSprite);
    }

    tapItem(info) {
      Utils_History.clear();

      // TODO: 后续添加选项选择功能
      // const configs = info.optionConfig;
      // let _busy = false;
      // if (configs.length) {
      //   _busy = true;
      //   configs.forEach(config => {
      //     if (config.type === 'switch') {
      //       $gameSwitches.setValue(config.switchId, true);
      //     }
      //   });
      // }

      useConfirm({
        hasCancel: true,
        content: `要开始观看剧情回想吗？`,
        okHandler() {
          SceneManager.add(Scene_SceneThink, () => {
            $gameTemp.execCommonEvent(info.eventId, () => {
              $gameSystem._savedBgm = null;
              $gameSystem._savedBgs = null;
              $gameMap._interpreter.clear();
              SceneManager._scene._messageWindow.terminateMessage();
              SceneManager.pop();
              AudioManager.stopAll();
              Utils_History.clear();
            });
          });
        }
      });
    }
  }
  window.Window_Recollection = Window_Recollection;

  /**
   * 影片鉴赏窗口
   */
  class Window_Moive extends Window_Base {
    initialize(pageWidth, pageHeight) {
      this.pageWidth = pageWidth;
      this.pageHeight = pageHeight;
      this._handlers = {};
      super.initialize(new Rectangle(98, 120, this.pageWidth, this.pageHeight));
      this.opacity = 0;
      
      this.pageIndex = 0;
      this.maxPageIndex = 2;

      this.refresh();
    }

    refresh() {

    }

    handle() {
      if (TouchInput.isCancelled() || Input.isPressed('cancel')) {
        SoundManager.playCancel();
      }
    }

    update() {
      super.update();
      this.handle();
    }
  }

  /**
   * 音乐鉴赏窗口
   */
  class Window_Music extends Window_Base {
    initialize(pageWidth, pageHeight) {
      this.pageWidth = pageWidth;
      this.pageHeight = pageHeight;
      this._handlers = {};
      super.initialize(new Rectangle(98, 120, this.pageWidth, this.pageHeight));
      this.opacity = 0;
      
      this.pageIndex = 0;
      this.maxPageIndex = 2;

      this.refresh();
    }

    refresh() {

    }

    handle() {
      if (TouchInput.isCancelled() || Input.isPressed('cancel')) {
        SoundManager.playCancel();
      }
    }

    update() {
      super.update();
      this.handle();
    }
  }


})();